!STARTOFREGISTRYGENERATEDFILE 'BEMT_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! BEMT_Types
!.................................................................................................................................
! This file is part of BEMT.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in BEMT. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE BEMT_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE AirfoilInfo_Types
USE UnsteadyAero_Types
USE DBEMT_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Skew_Mod_Orthogonal = -1      ! Inflow orthogonal to rotor [-] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Skew_Mod_None = 0      ! No skew model [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Skew_Mod_Active = 1      ! Skew model active [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Skew_Mod_PittPeters_Cont = 4      ! Pitt/Peters continuous formulation [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: SkewRedistrMod_None = 0      ! No redistribution [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: SkewRedistrMod_PittPeters = 1      ! Pitt/Peters/Glauert redistribution [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: BEMMod_2D = 1      ! 2D BEM assuming Cx, Cy, phi, L, D are in the same plane [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: BEMMod_3D = 2      ! 3D BEM assuming a momentum balance system, and an airfoil system [-]
! =========  BEMT_InitInputType  =======
  TYPE, PUBLIC :: BEMT_InitInputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: chord      !< Chord length at node [m]
    INTEGER(IntKi)  :: numBlades = 0_IntKi      !< Number of blades [-]
    REAL(ReKi)  :: airDens = 0.0_ReKi      !< Air density [kg/m^3]
    REAL(ReKi)  :: kinVisc = 0.0_ReKi      !< Kinematic air viscosity [m^2/s]
    INTEGER(IntKi)  :: skewWakeMod = 0_IntKi      !< Type of skewed-wake model [switch] {0=None, 1=Glauert} [-]
    INTEGER(IntKi)  :: skewRedistrMod = 0_IntKi      !< Type of skewed-wake redistribution model (switch) {0=no redistribution, 1=Glauert/Pitt/Peters, 2=Vortex Cylinder} [unsed only when SkewMod=1] [-]
    REAL(ReKi)  :: aTol = 0.0_ReKi      !< Tolerance for the induction solution [-]
    LOGICAL  :: useTipLoss = .false.      !< Use the Prandtl tip-loss model?  [flag] [-]
    LOGICAL  :: useHubLoss = .false.      !< Use the Prandtl hub-loss model?  [flag] [-]
    LOGICAL  :: useInduction = .false.      !< Include induction in BEMT calculations [flag] { If FALSE then useTanInd will be set to FALSE} [-]
    LOGICAL  :: useTanInd = .false.      !< Include tangential induction in BEMT calculations [flag] [-]
    LOGICAL  :: useAIDrag = .false.      !< Include the drag term in the axial-induction calculation?  [flag] [-]
    LOGICAL  :: useTIDrag = .false.      !< Include the drag term in the tangential-induction calculation?  Ignored if TanInd is False.  [flag] [-]
    LOGICAL  :: MomentumCorr = .false.      !< Momentum Correction {0=Axial Theory, 1 = Glauert Momentum Theory} [-]
    INTEGER(IntKi)  :: numBladeNodes = 0_IntKi      !< Number of blade nodes used in the analysis [-]
    INTEGER(IntKi)  :: numReIterations = 0_IntKi      !< Number of iterations for finding the Reynolds number [-]
    INTEGER(IntKi)  :: maxIndIterations = 0_IntKi      !< Maximum number of iterations of induction factor solve [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: AFindx      !< Index of airfoil data file for blade node location [array of numBladeNodes] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: zHub      !< Distance to hub for each blade [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: zLocal      !< Distance to blade node, measured along the blade [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: zTip      !< Distance to blade tip, measured along the blade [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: rLocal      !< Radial distance to blade node from the center of rotation, measured in the rotor plane, needed for DBEMT [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rTipFix      !< Nominally the coned rotor diameter (without prebend), used to align with Bladed calculations [m]
    LOGICAL  :: UA_Flag = .false.      !< logical flag indicating whether to use UnsteadyAero [-]
    INTEGER(IntKi)  :: DBEMT_Mod = 0_IntKi      !< DBEMT model.  1 = constant tau1, 2 = time dependent tau1 [-]
    REAL(ReKi)  :: tau1_const = 0.0_ReKi      !< DBEMT time constant (when DBEMT_Mod=1) [s]
    REAL(ReKi)  :: yawCorrFactor = 0.0_ReKi      !< constant used in Pitt/Peters skewed wake model (default is 15*pi/32) [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    LOGICAL  :: SumPrint = .false.      !< logical flag indicating whether to use UnsteadyAero [-]
    INTEGER(IntKi)  :: BEM_Mod = 0_IntKi      !< BEM Model 0=OpenFAST 2=Envision  [-]
    TYPE(UA_InitInputType)  :: UA_Init      !< InitInput data for UA model [-]
  END TYPE BEMT_InitInputType
! =======================
! =========  BEMT_InitOutputType  =======
  TYPE, PUBLIC :: BEMT_InitOutputType
    TYPE(ProgDesc)  :: Version      !<  [-]
  END TYPE BEMT_InitOutputType
! =======================
! =========  BEMT_SkewWake_InputType  =======
  TYPE, PUBLIC :: BEMT_SkewWake_InputType
    REAL(ReKi) , DIMENSION(1:3)  :: v_qsw = 0.0_ReKi      !< quasi-steady instantaneous wake velocity (value to be filtered in Skewed Wake model) [m/s]
    REAL(ReKi)  :: V0 = 0.0_ReKi      !< magnitude of disk-averaged velocity (for input to SkewWake) [m/s]
    REAL(ReKi)  :: R = 0.0_ReKi      !< rotor radius (for input to SkewWake) [m]
  END TYPE BEMT_SkewWake_InputType
! =======================
! =========  BEMT_ContinuousStateType  =======
  TYPE, PUBLIC :: BEMT_ContinuousStateType
    TYPE(UA_ContinuousStateType)  :: UA      !< UA module continuous states [-]
    TYPE(DBEMT_ContinuousStateType)  :: DBEMT      !< DBEMT module continuous states [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: V_w = 0.0_R8Ki      !< continuous state for filtering  wake velocity [-]
  END TYPE BEMT_ContinuousStateType
! =======================
! =========  BEMT_DiscreteStateType  =======
  TYPE, PUBLIC :: BEMT_DiscreteStateType
    TYPE(UA_DiscreteStateType)  :: UA      !< states for UnsteadyAero [-]
  END TYPE BEMT_DiscreteStateType
! =======================
! =========  BEMT_ConstraintStateType  =======
  TYPE, PUBLIC :: BEMT_ConstraintStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: phi      !< angle between the plane of rotation and the direction of the local wind [rad]
  END TYPE BEMT_ConstraintStateType
! =======================
! =========  BEMT_OtherStateType  =======
  TYPE, PUBLIC :: BEMT_OtherStateType
    TYPE(UA_OtherStateType)  :: UA      !< other states for UnsteadyAero [-]
    TYPE(DBEMT_OtherStateType)  :: DBEMT      !< other states for DBEMT [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: ValidPhi      !< set to indicate when there is no valid Phi for this node at this time (temporarially turn off induction when this is false) [-]
    LOGICAL  :: nodesInitialized = .false.      !< the node states have been initialized properly [-]
    TYPE(BEMT_ContinuousStateType) , DIMENSION(1:4)  :: xdot      !< history states for continuous state integration [-]
    INTEGER(IntKi)  :: n = 0_IntKi      !< time step # value used for continuous state integrator [-]
  END TYPE BEMT_OtherStateType
! =======================
! =========  BEMT_MiscVarType  =======
  TYPE, PUBLIC :: BEMT_MiscVarType
    LOGICAL  :: FirstWarn_Skew = .false.      !< flag so invalid skew warning doesn't get repeated forever [-]
    LOGICAL  :: FirstWarn_Phi = .false.      !< flag so Invalid Phi warning doesn't get repeated forever [-]
    LOGICAL  :: FirstWarn_BEMoff = .false.      !< flag to warn the BEM was turned off [-]
    TYPE(UA_MiscVarType)  :: UA      !< misc vars for UnsteadyAero [-]
    TYPE(DBEMT_MiscVarType)  :: DBEMT      !< misc vars for DBEMT [-]
    TYPE(UA_OutputType)  :: y_UA      !< outputs from UnsteadyAero [-]
    TYPE(UA_InputType) , DIMENSION(:,:,:), ALLOCATABLE  :: u_UA      !< inputs to UnsteadyAero at t and t+dt [-]
    TYPE(DBEMT_InputType) , DIMENSION(1:2)  :: u_DBEMT      !< inputs to DBEMT at t and t+dt [-]
    TYPE(BEMT_SkewWake_InputType) , DIMENSION(1:2)  :: u_SkewWake      !< inputs to SkewedWake at t and t+dt [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TnInd_op      !< tangential induction at the operating point (for linearization with frozen wake assumption) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AxInd_op      !< axial induction at the operating point (for linearization) with frozen wake assumption [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AxInduction      !< axial induction used for code run-time optimization [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TanInduction      !< tangential induction used for code run-time optimization [-]
    LOGICAL  :: UseFrozenWake = .false.      !< flag set to determine if frozen values of TnInd_op and AxInd_op should be used for this calculation in the linearization process [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Rtip      !< maximum rlocal value for each blade (typically the value at the tip) [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: phi      !< temp variable used in update states for returning phi (to allow computing inputs and states at multiple times) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: chi      !< temp variable used in update states for returning chi (to allow calling same routine from CalcOutput and UpdateStates) [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: ValidPhi      !< temp variable used in calcOutput for ValidPhi (to allow calling same routine from CalcOutput and UpdateStates) [-]
    REAL(ReKi)  :: BEM_weight = 0.0_ReKi 
  END TYPE BEMT_MiscVarType
! =======================
! =========  BEMT_ParameterType  =======
  TYPE, PUBLIC :: BEMT_ParameterType
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< time step [s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: chord      !< Chord length at node [m]
    INTEGER(IntKi)  :: numBlades = 0_IntKi      !< Number of blades [-]
    REAL(ReKi)  :: airDens = 0.0_ReKi      !< Air density [kg/m^3]
    REAL(ReKi)  :: kinVisc = 0.0_ReKi      !< Kinematic air viscosity [m^2/s]
    INTEGER(IntKi)  :: skewWakeMod = 0_IntKi      !< Type of skewed-wake correction model [switch] {0=None, 1=Glauert/Pitt/Peters} [-]
    INTEGER(IntKi)  :: skewRedistrMod = 0_IntKi      !< Type of skewed-wake redistribution model (switch) {0=no redistribution, 1=Glauert/Pitt/Peters, 2=Vortex Cylinder} [unsed only when SkewMod=1] [-]
    REAL(ReKi)  :: aTol = 0.0_ReKi      !< Tolerance for the induction solution [-]
    LOGICAL  :: useTipLoss = .false.      !< Use the Prandtl tip-loss model?  [flag] [-]
    LOGICAL  :: useHubLoss = .false.      !< Use the Prandtl hub-loss model?  [flag] [-]
    LOGICAL  :: useInduction = .false.      !< Include induction in BEMT calculations [flag] { If FALSE then useTanInd will be set to FALSE} [-]
    LOGICAL  :: useTanInd = .false.      !< Include tangential induction in BEMT calculations [flag] [-]
    LOGICAL  :: useAIDrag = .false.      !< Include the drag term in the axial-induction calculation?  [flag] [-]
    LOGICAL  :: useTIDrag = .false.      !< Include the drag term in the tangential-induction calculation?  Ignored if TanInd is False.  [flag] [-]
    INTEGER(IntKi)  :: numBladeNodes = 0_IntKi      !< Number of blade nodes used in the analysis [-]
    INTEGER(IntKi)  :: numReIterations = 0_IntKi      !< Number of iterations for finding the Reynolds number [-]
    INTEGER(IntKi)  :: maxIndIterations = 0_IntKi      !< Maximum number of iterations of induction factor solve [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: AFindx      !< Index of airfoil data file for blade node location [array of numBladeNodes] [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: tipLossConst      !< A constant computed during initialization based on B*(zTip-zLocal)/(2*zLocal) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: hubLossConst      !< A constant computed during initialization based on B*(zLocal-zHub)/(2*zHub) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: zHub      !< Distance to hub for each blade [m]
    TYPE(UA_ParameterType)  :: UA      !< parameters for UnsteadyAero [-]
    TYPE(DBEMT_ParameterType)  :: DBEMT      !< parameters for DBEMT [-]
    LOGICAL  :: UA_Flag = .false.      !< logical flag indicating whether to use UnsteadyAero [-]
    INTEGER(IntKi)  :: DBEMT_Mod = 0_IntKi      !< DBEMT Model.  0 = constant tau1, 1 = time dependent tau1 [-]
    REAL(ReKi)  :: yawCorrFactor = 0.0_ReKi      !< constant used in Pitt/Peters skewed wake model (default is 15*pi/32) [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: FixedInductions      !< flag to determine if BEM inductions should be fixed and not modified by dbemt or skewed wake [-]
    LOGICAL  :: MomentumCorr = .false.      !< Momentum Correction {0=Axial Theory, 1 = Glauert Momentum Theory} [-]
    REAL(ReKi)  :: rTipFixMax = 0.0_ReKi      !< Nominally the coned rotor diameter (without prebend), used to align with Bladed calculations [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: IntegrateWeight      !< A weighting factor for calculating rotor-averaged values (e.g., AxInd) [-]
    INTEGER(IntKi)  :: lin_nx = 0      !< Number of continuous states for linearization [-]
    INTEGER(IntKi)  :: BEM_Mod = 0_IntKi      !< BEM Model 0=OpenFAST 2=Envision  [-]
  END TYPE BEMT_ParameterType
! =======================
! =========  BEMT_InputType  =======
  TYPE, PUBLIC :: BEMT_InputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: theta      !< Twist angle (includes all sources of twist)  [Array of size (NumBlNds,numBlades)] [rad]
    REAL(ReKi)  :: chi0 = 0.0_ReKi      !< Angle between the vector normal to the rotor plane and the wind vector (e.g., the yaw angle in the case of no tilt) [rad]
    REAL(ReKi)  :: psiSkewOffset = 0.0_ReKi      !< Skew azimuth angle offset (relative to 90 deg) of the most downwind blade when chi0 is non-zero [rad]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: psi_s      !< Skew azimuth angle [rad]
    REAL(ReKi)  :: omega = 0.0_ReKi      !< Angular velocity of rotor [rad/s]
    REAL(ReKi)  :: TSR = 0.0_ReKi      !< Tip-speed ratio (to check if BEM should be turned off) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vx      !< Local axial velocity at node [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vy      !< Local tangential velocity at node [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vz      !< Local radial velocity at node [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: omega_z      !< rotation of no-sweep-pitch-twist coordinate system around z (for CDBEMT and CUA) [rad/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: xVelCorr      !< projection of velocity when yawed + prebend [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: rLocal      !< Radial distance from center-of-rotation to node [m]
    REAL(ReKi)  :: Un_disk = 0.0_ReKi      !< disk-averaged velocity normal to the rotor disk (for input to DBEMT) [m/s]
    REAL(ReKi) , DIMENSION(1:3)  :: V0 = 0.0_ReKi      !< disk-averaged velocity (for input to SkewWake) [m/s]
    REAL(R8Ki) , DIMENSION(1:3)  :: x_hat_disk = 0.0_R8Ki      !< Hub Orientation vector: normal to rotor disk [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: UserProp      !< Optional user property for interpolating airfoils (per element per blade) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: CantAngle      !< Cant angle [Array of size (NumBlNds,numBlades)] [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: drdz      !< dr/dz geometric parameter [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: toeAngle      !< Toe angle [Array of size (NumBlNds,numBlades)] [rad]
  END TYPE BEMT_InputType
! =======================
! =========  BEMT_OutputType  =======
  TYPE, PUBLIC :: BEMT_OutputType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vrel      !< Total local relative velocity [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: phi      !< angle between the plane of rotation and the direction of the local wind [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: axInduction      !< axial induction [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: tanInduction      !< tangential induction [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: axInduction_qs      !< axial induction quasi steady [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: tanInduction_qs      !< tangential induction quasi steady [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: k      !< Factor k in blade element theory thrust coefficient [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: k_p      !< Factor kp in blade element theory torque coefficient [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: F      !< Tip/hub loss factor [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Re      !< Reynold's number [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AOA      !< angle of attack [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cx      !< normal force coefficient (normal to the plane, not chord) of the jth node in the kth blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cy      !< tangential force coefficient (tangential to the plane, not chord) of the jth node in the kth blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cz      !< axial force coefficient (tangential to the plane, not chord) of the jth node in the kth blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cmx      !< pitching moment coefficient (x-component) of the jth node in the kth blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cmy      !< pitching moment coefficient (y-component) of the jth node in the kth blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cmz      !< pitching moment coefficient (z-component) of the jth node in the kth blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cm      !< pitching moment coefficient of the jth node in the kth blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cl      !< lift coefficient [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cd      !< drag coefficient [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: chi      !< wake skew angle [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cpmin      !< min Cpressure [-]
  END TYPE BEMT_OutputType
! =======================
CONTAINS

subroutine BEMT_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(BEMT_InitInputType), intent(in) :: SrcInitInputData
   type(BEMT_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BEMT_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitInputData%chord)) then
      LB(1:2) = lbound(SrcInitInputData%chord)
      UB(1:2) = ubound(SrcInitInputData%chord)
      if (.not. allocated(DstInitInputData%chord)) then
         allocate(DstInitInputData%chord(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%chord.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%chord = SrcInitInputData%chord
   end if
   DstInitInputData%numBlades = SrcInitInputData%numBlades
   DstInitInputData%airDens = SrcInitInputData%airDens
   DstInitInputData%kinVisc = SrcInitInputData%kinVisc
   DstInitInputData%skewWakeMod = SrcInitInputData%skewWakeMod
   DstInitInputData%skewRedistrMod = SrcInitInputData%skewRedistrMod
   DstInitInputData%aTol = SrcInitInputData%aTol
   DstInitInputData%useTipLoss = SrcInitInputData%useTipLoss
   DstInitInputData%useHubLoss = SrcInitInputData%useHubLoss
   DstInitInputData%useInduction = SrcInitInputData%useInduction
   DstInitInputData%useTanInd = SrcInitInputData%useTanInd
   DstInitInputData%useAIDrag = SrcInitInputData%useAIDrag
   DstInitInputData%useTIDrag = SrcInitInputData%useTIDrag
   DstInitInputData%MomentumCorr = SrcInitInputData%MomentumCorr
   DstInitInputData%numBladeNodes = SrcInitInputData%numBladeNodes
   DstInitInputData%numReIterations = SrcInitInputData%numReIterations
   DstInitInputData%maxIndIterations = SrcInitInputData%maxIndIterations
   if (allocated(SrcInitInputData%AFindx)) then
      LB(1:2) = lbound(SrcInitInputData%AFindx)
      UB(1:2) = ubound(SrcInitInputData%AFindx)
      if (.not. allocated(DstInitInputData%AFindx)) then
         allocate(DstInitInputData%AFindx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%AFindx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%AFindx = SrcInitInputData%AFindx
   end if
   if (allocated(SrcInitInputData%zHub)) then
      LB(1:1) = lbound(SrcInitInputData%zHub)
      UB(1:1) = ubound(SrcInitInputData%zHub)
      if (.not. allocated(DstInitInputData%zHub)) then
         allocate(DstInitInputData%zHub(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%zHub.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%zHub = SrcInitInputData%zHub
   end if
   if (allocated(SrcInitInputData%zLocal)) then
      LB(1:2) = lbound(SrcInitInputData%zLocal)
      UB(1:2) = ubound(SrcInitInputData%zLocal)
      if (.not. allocated(DstInitInputData%zLocal)) then
         allocate(DstInitInputData%zLocal(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%zLocal.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%zLocal = SrcInitInputData%zLocal
   end if
   if (allocated(SrcInitInputData%zTip)) then
      LB(1:1) = lbound(SrcInitInputData%zTip)
      UB(1:1) = ubound(SrcInitInputData%zTip)
      if (.not. allocated(DstInitInputData%zTip)) then
         allocate(DstInitInputData%zTip(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%zTip.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%zTip = SrcInitInputData%zTip
   end if
   if (allocated(SrcInitInputData%rLocal)) then
      LB(1:2) = lbound(SrcInitInputData%rLocal)
      UB(1:2) = ubound(SrcInitInputData%rLocal)
      if (.not. allocated(DstInitInputData%rLocal)) then
         allocate(DstInitInputData%rLocal(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%rLocal.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%rLocal = SrcInitInputData%rLocal
   end if
   if (allocated(SrcInitInputData%rTipFix)) then
      LB(1:1) = lbound(SrcInitInputData%rTipFix)
      UB(1:1) = ubound(SrcInitInputData%rTipFix)
      if (.not. allocated(DstInitInputData%rTipFix)) then
         allocate(DstInitInputData%rTipFix(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%rTipFix.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%rTipFix = SrcInitInputData%rTipFix
   end if
   DstInitInputData%UA_Flag = SrcInitInputData%UA_Flag
   DstInitInputData%DBEMT_Mod = SrcInitInputData%DBEMT_Mod
   DstInitInputData%tau1_const = SrcInitInputData%tau1_const
   DstInitInputData%yawCorrFactor = SrcInitInputData%yawCorrFactor
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%SumPrint = SrcInitInputData%SumPrint
   DstInitInputData%BEM_Mod = SrcInitInputData%BEM_Mod
   call UA_CopyInitInput(SrcInitInputData%UA_Init, DstInitInputData%UA_Init, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine BEMT_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(BEMT_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BEMT_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%chord)) then
      deallocate(InitInputData%chord)
   end if
   if (allocated(InitInputData%AFindx)) then
      deallocate(InitInputData%AFindx)
   end if
   if (allocated(InitInputData%zHub)) then
      deallocate(InitInputData%zHub)
   end if
   if (allocated(InitInputData%zLocal)) then
      deallocate(InitInputData%zLocal)
   end if
   if (allocated(InitInputData%zTip)) then
      deallocate(InitInputData%zTip)
   end if
   if (allocated(InitInputData%rLocal)) then
      deallocate(InitInputData%rLocal)
   end if
   if (allocated(InitInputData%rTipFix)) then
      deallocate(InitInputData%rTipFix)
   end if
   call UA_DestroyInitInput(InitInputData%UA_Init, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine BEMT_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BEMT_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BEMT_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%chord)
   call RegPack(RF, InData%numBlades)
   call RegPack(RF, InData%airDens)
   call RegPack(RF, InData%kinVisc)
   call RegPack(RF, InData%skewWakeMod)
   call RegPack(RF, InData%skewRedistrMod)
   call RegPack(RF, InData%aTol)
   call RegPack(RF, InData%useTipLoss)
   call RegPack(RF, InData%useHubLoss)
   call RegPack(RF, InData%useInduction)
   call RegPack(RF, InData%useTanInd)
   call RegPack(RF, InData%useAIDrag)
   call RegPack(RF, InData%useTIDrag)
   call RegPack(RF, InData%MomentumCorr)
   call RegPack(RF, InData%numBladeNodes)
   call RegPack(RF, InData%numReIterations)
   call RegPack(RF, InData%maxIndIterations)
   call RegPackAlloc(RF, InData%AFindx)
   call RegPackAlloc(RF, InData%zHub)
   call RegPackAlloc(RF, InData%zLocal)
   call RegPackAlloc(RF, InData%zTip)
   call RegPackAlloc(RF, InData%rLocal)
   call RegPackAlloc(RF, InData%rTipFix)
   call RegPack(RF, InData%UA_Flag)
   call RegPack(RF, InData%DBEMT_Mod)
   call RegPack(RF, InData%tau1_const)
   call RegPack(RF, InData%yawCorrFactor)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%SumPrint)
   call RegPack(RF, InData%BEM_Mod)
   call UA_PackInitInput(RF, InData%UA_Init) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BEMT_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BEMT_UnPackInitInput'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%chord); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%airDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%kinVisc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%skewWakeMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%skewRedistrMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%aTol); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%useTipLoss); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%useHubLoss); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%useInduction); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%useTanInd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%useAIDrag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%useTIDrag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MomentumCorr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numBladeNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numReIterations); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%maxIndIterations); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AFindx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%zHub); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%zLocal); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%zTip); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rLocal); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rTipFix); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UA_Flag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DBEMT_Mod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tau1_const); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%yawCorrFactor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SumPrint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BEM_Mod); if (RegCheckErr(RF, RoutineName)) return
   call UA_UnpackInitInput(RF, OutData%UA_Init) ! UA_Init 
end subroutine

subroutine BEMT_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(BEMT_InitOutputType), intent(in) :: SrcInitOutputData
   type(BEMT_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BEMT_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Version, DstInitOutputData%Version, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine BEMT_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(BEMT_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BEMT_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyProgDesc(InitOutputData%Version, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine BEMT_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BEMT_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BEMT_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call NWTC_Library_PackProgDesc(RF, InData%Version) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BEMT_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BEMT_UnPackInitOutput'
   if (RF%ErrStat /= ErrID_None) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Version) ! Version 
end subroutine

subroutine BEMT_CopySkewWake_InputType(SrcSkewWake_InputTypeData, DstSkewWake_InputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(BEMT_SkewWake_InputType), intent(in) :: SrcSkewWake_InputTypeData
   type(BEMT_SkewWake_InputType), intent(inout) :: DstSkewWake_InputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BEMT_CopySkewWake_InputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstSkewWake_InputTypeData%v_qsw = SrcSkewWake_InputTypeData%v_qsw
   DstSkewWake_InputTypeData%V0 = SrcSkewWake_InputTypeData%V0
   DstSkewWake_InputTypeData%R = SrcSkewWake_InputTypeData%R
end subroutine

subroutine BEMT_DestroySkewWake_InputType(SkewWake_InputTypeData, ErrStat, ErrMsg)
   type(BEMT_SkewWake_InputType), intent(inout) :: SkewWake_InputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BEMT_DestroySkewWake_InputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine BEMT_PackSkewWake_InputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BEMT_SkewWake_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BEMT_PackSkewWake_InputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%v_qsw)
   call RegPack(RF, InData%V0)
   call RegPack(RF, InData%R)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_UnPackSkewWake_InputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BEMT_SkewWake_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BEMT_UnPackSkewWake_InputType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%v_qsw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%V0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%R); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(BEMT_ContinuousStateType), intent(in) :: SrcContStateData
   type(BEMT_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BEMT_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call UA_CopyContState(SrcContStateData%UA, DstContStateData%UA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call DBEMT_CopyContState(SrcContStateData%DBEMT, DstContStateData%DBEMT, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstContStateData%V_w = SrcContStateData%V_w
end subroutine

subroutine BEMT_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(BEMT_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BEMT_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call UA_DestroyContState(ContStateData%UA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call DBEMT_DestroyContState(ContStateData%DBEMT, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine BEMT_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BEMT_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BEMT_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call UA_PackContState(RF, InData%UA) 
   call DBEMT_PackContState(RF, InData%DBEMT) 
   call RegPack(RF, InData%V_w)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BEMT_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BEMT_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call UA_UnpackContState(RF, OutData%UA) ! UA 
   call DBEMT_UnpackContState(RF, OutData%DBEMT) ! DBEMT 
   call RegUnpack(RF, OutData%V_w); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(BEMT_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(BEMT_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BEMT_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call UA_CopyDiscState(SrcDiscStateData%UA, DstDiscStateData%UA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine BEMT_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(BEMT_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BEMT_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call UA_DestroyDiscState(DiscStateData%UA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine BEMT_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BEMT_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BEMT_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call UA_PackDiscState(RF, InData%UA) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BEMT_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BEMT_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call UA_UnpackDiscState(RF, OutData%UA) ! UA 
end subroutine

subroutine BEMT_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(BEMT_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(BEMT_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'BEMT_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcConstrStateData%phi)) then
      LB(1:2) = lbound(SrcConstrStateData%phi)
      UB(1:2) = ubound(SrcConstrStateData%phi)
      if (.not. allocated(DstConstrStateData%phi)) then
         allocate(DstConstrStateData%phi(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%phi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstConstrStateData%phi = SrcConstrStateData%phi
   end if
end subroutine

subroutine BEMT_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(BEMT_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BEMT_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ConstrStateData%phi)) then
      deallocate(ConstrStateData%phi)
   end if
end subroutine

subroutine BEMT_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BEMT_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BEMT_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%phi)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BEMT_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BEMT_UnPackConstrState'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%phi); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(BEMT_OtherStateType), intent(in) :: SrcOtherStateData
   type(BEMT_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BEMT_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call UA_CopyOtherState(SrcOtherStateData%UA, DstOtherStateData%UA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call DBEMT_CopyOtherState(SrcOtherStateData%DBEMT, DstOtherStateData%DBEMT, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOtherStateData%ValidPhi)) then
      LB(1:2) = lbound(SrcOtherStateData%ValidPhi)
      UB(1:2) = ubound(SrcOtherStateData%ValidPhi)
      if (.not. allocated(DstOtherStateData%ValidPhi)) then
         allocate(DstOtherStateData%ValidPhi(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%ValidPhi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%ValidPhi = SrcOtherStateData%ValidPhi
   end if
   DstOtherStateData%nodesInitialized = SrcOtherStateData%nodesInitialized
   LB(1:1) = lbound(SrcOtherStateData%xdot)
   UB(1:1) = ubound(SrcOtherStateData%xdot)
   do i1 = LB(1), UB(1)
      call BEMT_CopyContState(SrcOtherStateData%xdot(i1), DstOtherStateData%xdot(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   DstOtherStateData%n = SrcOtherStateData%n
end subroutine

subroutine BEMT_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(BEMT_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BEMT_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call UA_DestroyOtherState(OtherStateData%UA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call DBEMT_DestroyOtherState(OtherStateData%DBEMT, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OtherStateData%ValidPhi)) then
      deallocate(OtherStateData%ValidPhi)
   end if
   LB(1:1) = lbound(OtherStateData%xdot)
   UB(1:1) = ubound(OtherStateData%xdot)
   do i1 = LB(1), UB(1)
      call BEMT_DestroyContState(OtherStateData%xdot(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
end subroutine

subroutine BEMT_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BEMT_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BEMT_PackOtherState'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call UA_PackOtherState(RF, InData%UA) 
   call DBEMT_PackOtherState(RF, InData%DBEMT) 
   call RegPackAlloc(RF, InData%ValidPhi)
   call RegPack(RF, InData%nodesInitialized)
   LB(1:1) = lbound(InData%xdot)
   UB(1:1) = ubound(InData%xdot)
   do i1 = LB(1), UB(1)
      call BEMT_PackContState(RF, InData%xdot(i1)) 
   end do
   call RegPack(RF, InData%n)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BEMT_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BEMT_UnPackOtherState'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call UA_UnpackOtherState(RF, OutData%UA) ! UA 
   call DBEMT_UnpackOtherState(RF, OutData%DBEMT) ! DBEMT 
   call RegUnpackAlloc(RF, OutData%ValidPhi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nodesInitialized); if (RegCheckErr(RF, RoutineName)) return
   LB(1:1) = lbound(OutData%xdot)
   UB(1:1) = ubound(OutData%xdot)
   do i1 = LB(1), UB(1)
      call BEMT_UnpackContState(RF, OutData%xdot(i1)) ! xdot 
   end do
   call RegUnpack(RF, OutData%n); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(BEMT_MiscVarType), intent(in) :: SrcMiscData
   type(BEMT_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BEMT_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%FirstWarn_Skew = SrcMiscData%FirstWarn_Skew
   DstMiscData%FirstWarn_Phi = SrcMiscData%FirstWarn_Phi
   DstMiscData%FirstWarn_BEMoff = SrcMiscData%FirstWarn_BEMoff
   call UA_CopyMisc(SrcMiscData%UA, DstMiscData%UA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call DBEMT_CopyMisc(SrcMiscData%DBEMT, DstMiscData%DBEMT, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call UA_CopyOutput(SrcMiscData%y_UA, DstMiscData%y_UA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMiscData%u_UA)) then
      LB(1:3) = lbound(SrcMiscData%u_UA)
      UB(1:3) = ubound(SrcMiscData%u_UA)
      if (.not. allocated(DstMiscData%u_UA)) then
         allocate(DstMiscData%u_UA(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%u_UA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i3 = LB(3), UB(3)
         do i2 = LB(2), UB(2)
            do i1 = LB(1), UB(1)
               call UA_CopyInput(SrcMiscData%u_UA(i1,i2,i3), DstMiscData%u_UA(i1,i2,i3), CtrlCode, ErrStat2, ErrMsg2)
               call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
               if (ErrStat >= AbortErrLev) return
            end do
         end do
      end do
   end if
   LB(1:1) = lbound(SrcMiscData%u_DBEMT)
   UB(1:1) = ubound(SrcMiscData%u_DBEMT)
   do i1 = LB(1), UB(1)
      call DBEMT_CopyInput(SrcMiscData%u_DBEMT(i1), DstMiscData%u_DBEMT(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   LB(1:1) = lbound(SrcMiscData%u_SkewWake)
   UB(1:1) = ubound(SrcMiscData%u_SkewWake)
   do i1 = LB(1), UB(1)
      call BEMT_CopySkewWake_InputType(SrcMiscData%u_SkewWake(i1), DstMiscData%u_SkewWake(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   if (allocated(SrcMiscData%TnInd_op)) then
      LB(1:2) = lbound(SrcMiscData%TnInd_op)
      UB(1:2) = ubound(SrcMiscData%TnInd_op)
      if (.not. allocated(DstMiscData%TnInd_op)) then
         allocate(DstMiscData%TnInd_op(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%TnInd_op.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%TnInd_op = SrcMiscData%TnInd_op
   end if
   if (allocated(SrcMiscData%AxInd_op)) then
      LB(1:2) = lbound(SrcMiscData%AxInd_op)
      UB(1:2) = ubound(SrcMiscData%AxInd_op)
      if (.not. allocated(DstMiscData%AxInd_op)) then
         allocate(DstMiscData%AxInd_op(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AxInd_op.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AxInd_op = SrcMiscData%AxInd_op
   end if
   if (allocated(SrcMiscData%AxInduction)) then
      LB(1:2) = lbound(SrcMiscData%AxInduction)
      UB(1:2) = ubound(SrcMiscData%AxInduction)
      if (.not. allocated(DstMiscData%AxInduction)) then
         allocate(DstMiscData%AxInduction(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AxInduction.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AxInduction = SrcMiscData%AxInduction
   end if
   if (allocated(SrcMiscData%TanInduction)) then
      LB(1:2) = lbound(SrcMiscData%TanInduction)
      UB(1:2) = ubound(SrcMiscData%TanInduction)
      if (.not. allocated(DstMiscData%TanInduction)) then
         allocate(DstMiscData%TanInduction(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%TanInduction.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%TanInduction = SrcMiscData%TanInduction
   end if
   DstMiscData%UseFrozenWake = SrcMiscData%UseFrozenWake
   if (allocated(SrcMiscData%Rtip)) then
      LB(1:1) = lbound(SrcMiscData%Rtip)
      UB(1:1) = ubound(SrcMiscData%Rtip)
      if (.not. allocated(DstMiscData%Rtip)) then
         allocate(DstMiscData%Rtip(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Rtip.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%Rtip = SrcMiscData%Rtip
   end if
   if (allocated(SrcMiscData%phi)) then
      LB(1:2) = lbound(SrcMiscData%phi)
      UB(1:2) = ubound(SrcMiscData%phi)
      if (.not. allocated(DstMiscData%phi)) then
         allocate(DstMiscData%phi(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%phi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%phi = SrcMiscData%phi
   end if
   if (allocated(SrcMiscData%chi)) then
      LB(1:2) = lbound(SrcMiscData%chi)
      UB(1:2) = ubound(SrcMiscData%chi)
      if (.not. allocated(DstMiscData%chi)) then
         allocate(DstMiscData%chi(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%chi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%chi = SrcMiscData%chi
   end if
   if (allocated(SrcMiscData%ValidPhi)) then
      LB(1:2) = lbound(SrcMiscData%ValidPhi)
      UB(1:2) = ubound(SrcMiscData%ValidPhi)
      if (.not. allocated(DstMiscData%ValidPhi)) then
         allocate(DstMiscData%ValidPhi(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ValidPhi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%ValidPhi = SrcMiscData%ValidPhi
   end if
   DstMiscData%BEM_weight = SrcMiscData%BEM_weight
end subroutine

subroutine BEMT_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(BEMT_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BEMT_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call UA_DestroyMisc(MiscData%UA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call DBEMT_DestroyMisc(MiscData%DBEMT, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call UA_DestroyOutput(MiscData%y_UA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MiscData%u_UA)) then
      LB(1:3) = lbound(MiscData%u_UA)
      UB(1:3) = ubound(MiscData%u_UA)
      do i3 = LB(3), UB(3)
         do i2 = LB(2), UB(2)
            do i1 = LB(1), UB(1)
               call UA_DestroyInput(MiscData%u_UA(i1,i2,i3), ErrStat2, ErrMsg2)
               call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
            end do
         end do
      end do
      deallocate(MiscData%u_UA)
   end if
   LB(1:1) = lbound(MiscData%u_DBEMT)
   UB(1:1) = ubound(MiscData%u_DBEMT)
   do i1 = LB(1), UB(1)
      call DBEMT_DestroyInput(MiscData%u_DBEMT(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   LB(1:1) = lbound(MiscData%u_SkewWake)
   UB(1:1) = ubound(MiscData%u_SkewWake)
   do i1 = LB(1), UB(1)
      call BEMT_DestroySkewWake_InputType(MiscData%u_SkewWake(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   if (allocated(MiscData%TnInd_op)) then
      deallocate(MiscData%TnInd_op)
   end if
   if (allocated(MiscData%AxInd_op)) then
      deallocate(MiscData%AxInd_op)
   end if
   if (allocated(MiscData%AxInduction)) then
      deallocate(MiscData%AxInduction)
   end if
   if (allocated(MiscData%TanInduction)) then
      deallocate(MiscData%TanInduction)
   end if
   if (allocated(MiscData%Rtip)) then
      deallocate(MiscData%Rtip)
   end if
   if (allocated(MiscData%phi)) then
      deallocate(MiscData%phi)
   end if
   if (allocated(MiscData%chi)) then
      deallocate(MiscData%chi)
   end if
   if (allocated(MiscData%ValidPhi)) then
      deallocate(MiscData%ValidPhi)
   end if
end subroutine

subroutine BEMT_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BEMT_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BEMT_PackMisc'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%FirstWarn_Skew)
   call RegPack(RF, InData%FirstWarn_Phi)
   call RegPack(RF, InData%FirstWarn_BEMoff)
   call UA_PackMisc(RF, InData%UA) 
   call DBEMT_PackMisc(RF, InData%DBEMT) 
   call UA_PackOutput(RF, InData%y_UA) 
   call RegPack(RF, allocated(InData%u_UA))
   if (allocated(InData%u_UA)) then
      call RegPackBounds(RF, 3, lbound(InData%u_UA), ubound(InData%u_UA))
      LB(1:3) = lbound(InData%u_UA)
      UB(1:3) = ubound(InData%u_UA)
      do i3 = LB(3), UB(3)
         do i2 = LB(2), UB(2)
            do i1 = LB(1), UB(1)
               call UA_PackInput(RF, InData%u_UA(i1,i2,i3)) 
            end do
         end do
      end do
   end if
   LB(1:1) = lbound(InData%u_DBEMT)
   UB(1:1) = ubound(InData%u_DBEMT)
   do i1 = LB(1), UB(1)
      call DBEMT_PackInput(RF, InData%u_DBEMT(i1)) 
   end do
   LB(1:1) = lbound(InData%u_SkewWake)
   UB(1:1) = ubound(InData%u_SkewWake)
   do i1 = LB(1), UB(1)
      call BEMT_PackSkewWake_InputType(RF, InData%u_SkewWake(i1)) 
   end do
   call RegPackAlloc(RF, InData%TnInd_op)
   call RegPackAlloc(RF, InData%AxInd_op)
   call RegPackAlloc(RF, InData%AxInduction)
   call RegPackAlloc(RF, InData%TanInduction)
   call RegPack(RF, InData%UseFrozenWake)
   call RegPackAlloc(RF, InData%Rtip)
   call RegPackAlloc(RF, InData%phi)
   call RegPackAlloc(RF, InData%chi)
   call RegPackAlloc(RF, InData%ValidPhi)
   call RegPack(RF, InData%BEM_weight)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BEMT_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BEMT_UnPackMisc'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%FirstWarn_Skew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FirstWarn_Phi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FirstWarn_BEMoff); if (RegCheckErr(RF, RoutineName)) return
   call UA_UnpackMisc(RF, OutData%UA) ! UA 
   call DBEMT_UnpackMisc(RF, OutData%DBEMT) ! DBEMT 
   call UA_UnpackOutput(RF, OutData%y_UA) ! y_UA 
   if (allocated(OutData%u_UA)) deallocate(OutData%u_UA)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 3, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u_UA(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u_UA.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i3 = LB(3), UB(3)
         do i2 = LB(2), UB(2)
            do i1 = LB(1), UB(1)
               call UA_UnpackInput(RF, OutData%u_UA(i1,i2,i3)) ! u_UA 
            end do
         end do
      end do
   end if
   LB(1:1) = lbound(OutData%u_DBEMT)
   UB(1:1) = ubound(OutData%u_DBEMT)
   do i1 = LB(1), UB(1)
      call DBEMT_UnpackInput(RF, OutData%u_DBEMT(i1)) ! u_DBEMT 
   end do
   LB(1:1) = lbound(OutData%u_SkewWake)
   UB(1:1) = ubound(OutData%u_SkewWake)
   do i1 = LB(1), UB(1)
      call BEMT_UnpackSkewWake_InputType(RF, OutData%u_SkewWake(i1)) ! u_SkewWake 
   end do
   call RegUnpackAlloc(RF, OutData%TnInd_op); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AxInd_op); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AxInduction); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TanInduction); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UseFrozenWake); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Rtip); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%phi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%chi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ValidPhi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BEM_weight); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(BEMT_ParameterType), intent(in) :: SrcParamData
   type(BEMT_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BEMT_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%DT = SrcParamData%DT
   if (allocated(SrcParamData%chord)) then
      LB(1:2) = lbound(SrcParamData%chord)
      UB(1:2) = ubound(SrcParamData%chord)
      if (.not. allocated(DstParamData%chord)) then
         allocate(DstParamData%chord(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%chord.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%chord = SrcParamData%chord
   end if
   DstParamData%numBlades = SrcParamData%numBlades
   DstParamData%airDens = SrcParamData%airDens
   DstParamData%kinVisc = SrcParamData%kinVisc
   DstParamData%skewWakeMod = SrcParamData%skewWakeMod
   DstParamData%skewRedistrMod = SrcParamData%skewRedistrMod
   DstParamData%aTol = SrcParamData%aTol
   DstParamData%useTipLoss = SrcParamData%useTipLoss
   DstParamData%useHubLoss = SrcParamData%useHubLoss
   DstParamData%useInduction = SrcParamData%useInduction
   DstParamData%useTanInd = SrcParamData%useTanInd
   DstParamData%useAIDrag = SrcParamData%useAIDrag
   DstParamData%useTIDrag = SrcParamData%useTIDrag
   DstParamData%numBladeNodes = SrcParamData%numBladeNodes
   DstParamData%numReIterations = SrcParamData%numReIterations
   DstParamData%maxIndIterations = SrcParamData%maxIndIterations
   if (allocated(SrcParamData%AFindx)) then
      LB(1:2) = lbound(SrcParamData%AFindx)
      UB(1:2) = ubound(SrcParamData%AFindx)
      if (.not. allocated(DstParamData%AFindx)) then
         allocate(DstParamData%AFindx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AFindx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AFindx = SrcParamData%AFindx
   end if
   if (allocated(SrcParamData%tipLossConst)) then
      LB(1:2) = lbound(SrcParamData%tipLossConst)
      UB(1:2) = ubound(SrcParamData%tipLossConst)
      if (.not. allocated(DstParamData%tipLossConst)) then
         allocate(DstParamData%tipLossConst(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%tipLossConst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%tipLossConst = SrcParamData%tipLossConst
   end if
   if (allocated(SrcParamData%hubLossConst)) then
      LB(1:2) = lbound(SrcParamData%hubLossConst)
      UB(1:2) = ubound(SrcParamData%hubLossConst)
      if (.not. allocated(DstParamData%hubLossConst)) then
         allocate(DstParamData%hubLossConst(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%hubLossConst.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%hubLossConst = SrcParamData%hubLossConst
   end if
   if (allocated(SrcParamData%zHub)) then
      LB(1:1) = lbound(SrcParamData%zHub)
      UB(1:1) = ubound(SrcParamData%zHub)
      if (.not. allocated(DstParamData%zHub)) then
         allocate(DstParamData%zHub(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%zHub.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%zHub = SrcParamData%zHub
   end if
   call UA_CopyParam(SrcParamData%UA, DstParamData%UA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call DBEMT_CopyParam(SrcParamData%DBEMT, DstParamData%DBEMT, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstParamData%UA_Flag = SrcParamData%UA_Flag
   DstParamData%DBEMT_Mod = SrcParamData%DBEMT_Mod
   DstParamData%yawCorrFactor = SrcParamData%yawCorrFactor
   if (allocated(SrcParamData%FixedInductions)) then
      LB(1:2) = lbound(SrcParamData%FixedInductions)
      UB(1:2) = ubound(SrcParamData%FixedInductions)
      if (.not. allocated(DstParamData%FixedInductions)) then
         allocate(DstParamData%FixedInductions(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FixedInductions.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%FixedInductions = SrcParamData%FixedInductions
   end if
   DstParamData%MomentumCorr = SrcParamData%MomentumCorr
   DstParamData%rTipFixMax = SrcParamData%rTipFixMax
   if (allocated(SrcParamData%IntegrateWeight)) then
      LB(1:2) = lbound(SrcParamData%IntegrateWeight)
      UB(1:2) = ubound(SrcParamData%IntegrateWeight)
      if (.not. allocated(DstParamData%IntegrateWeight)) then
         allocate(DstParamData%IntegrateWeight(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%IntegrateWeight.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%IntegrateWeight = SrcParamData%IntegrateWeight
   end if
   DstParamData%lin_nx = SrcParamData%lin_nx
   DstParamData%BEM_Mod = SrcParamData%BEM_Mod
end subroutine

subroutine BEMT_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(BEMT_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'BEMT_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%chord)) then
      deallocate(ParamData%chord)
   end if
   if (allocated(ParamData%AFindx)) then
      deallocate(ParamData%AFindx)
   end if
   if (allocated(ParamData%tipLossConst)) then
      deallocate(ParamData%tipLossConst)
   end if
   if (allocated(ParamData%hubLossConst)) then
      deallocate(ParamData%hubLossConst)
   end if
   if (allocated(ParamData%zHub)) then
      deallocate(ParamData%zHub)
   end if
   call UA_DestroyParam(ParamData%UA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call DBEMT_DestroyParam(ParamData%DBEMT, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ParamData%FixedInductions)) then
      deallocate(ParamData%FixedInductions)
   end if
   if (allocated(ParamData%IntegrateWeight)) then
      deallocate(ParamData%IntegrateWeight)
   end if
end subroutine

subroutine BEMT_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BEMT_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BEMT_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPackAlloc(RF, InData%chord)
   call RegPack(RF, InData%numBlades)
   call RegPack(RF, InData%airDens)
   call RegPack(RF, InData%kinVisc)
   call RegPack(RF, InData%skewWakeMod)
   call RegPack(RF, InData%skewRedistrMod)
   call RegPack(RF, InData%aTol)
   call RegPack(RF, InData%useTipLoss)
   call RegPack(RF, InData%useHubLoss)
   call RegPack(RF, InData%useInduction)
   call RegPack(RF, InData%useTanInd)
   call RegPack(RF, InData%useAIDrag)
   call RegPack(RF, InData%useTIDrag)
   call RegPack(RF, InData%numBladeNodes)
   call RegPack(RF, InData%numReIterations)
   call RegPack(RF, InData%maxIndIterations)
   call RegPackAlloc(RF, InData%AFindx)
   call RegPackAlloc(RF, InData%tipLossConst)
   call RegPackAlloc(RF, InData%hubLossConst)
   call RegPackAlloc(RF, InData%zHub)
   call UA_PackParam(RF, InData%UA) 
   call DBEMT_PackParam(RF, InData%DBEMT) 
   call RegPack(RF, InData%UA_Flag)
   call RegPack(RF, InData%DBEMT_Mod)
   call RegPack(RF, InData%yawCorrFactor)
   call RegPackAlloc(RF, InData%FixedInductions)
   call RegPack(RF, InData%MomentumCorr)
   call RegPack(RF, InData%rTipFixMax)
   call RegPackAlloc(RF, InData%IntegrateWeight)
   call RegPack(RF, InData%lin_nx)
   call RegPack(RF, InData%BEM_Mod)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BEMT_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BEMT_UnPackParam'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%chord); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%airDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%kinVisc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%skewWakeMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%skewRedistrMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%aTol); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%useTipLoss); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%useHubLoss); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%useInduction); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%useTanInd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%useAIDrag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%useTIDrag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numBladeNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numReIterations); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%maxIndIterations); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AFindx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%tipLossConst); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%hubLossConst); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%zHub); if (RegCheckErr(RF, RoutineName)) return
   call UA_UnpackParam(RF, OutData%UA) ! UA 
   call DBEMT_UnpackParam(RF, OutData%DBEMT) ! DBEMT 
   call RegUnpack(RF, OutData%UA_Flag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DBEMT_Mod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%yawCorrFactor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FixedInductions); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MomentumCorr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rTipFixMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IntegrateWeight); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%lin_nx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BEM_Mod); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(BEMT_InputType), intent(in) :: SrcInputData
   type(BEMT_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'BEMT_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInputData%theta)) then
      LB(1:2) = lbound(SrcInputData%theta)
      UB(1:2) = ubound(SrcInputData%theta)
      if (.not. allocated(DstInputData%theta)) then
         allocate(DstInputData%theta(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%theta.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%theta = SrcInputData%theta
   end if
   DstInputData%chi0 = SrcInputData%chi0
   DstInputData%psiSkewOffset = SrcInputData%psiSkewOffset
   if (allocated(SrcInputData%psi_s)) then
      LB(1:1) = lbound(SrcInputData%psi_s)
      UB(1:1) = ubound(SrcInputData%psi_s)
      if (.not. allocated(DstInputData%psi_s)) then
         allocate(DstInputData%psi_s(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%psi_s.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%psi_s = SrcInputData%psi_s
   end if
   DstInputData%omega = SrcInputData%omega
   DstInputData%TSR = SrcInputData%TSR
   if (allocated(SrcInputData%Vx)) then
      LB(1:2) = lbound(SrcInputData%Vx)
      UB(1:2) = ubound(SrcInputData%Vx)
      if (.not. allocated(DstInputData%Vx)) then
         allocate(DstInputData%Vx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Vx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%Vx = SrcInputData%Vx
   end if
   if (allocated(SrcInputData%Vy)) then
      LB(1:2) = lbound(SrcInputData%Vy)
      UB(1:2) = ubound(SrcInputData%Vy)
      if (.not. allocated(DstInputData%Vy)) then
         allocate(DstInputData%Vy(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Vy.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%Vy = SrcInputData%Vy
   end if
   if (allocated(SrcInputData%Vz)) then
      LB(1:2) = lbound(SrcInputData%Vz)
      UB(1:2) = ubound(SrcInputData%Vz)
      if (.not. allocated(DstInputData%Vz)) then
         allocate(DstInputData%Vz(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Vz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%Vz = SrcInputData%Vz
   end if
   if (allocated(SrcInputData%omega_z)) then
      LB(1:2) = lbound(SrcInputData%omega_z)
      UB(1:2) = ubound(SrcInputData%omega_z)
      if (.not. allocated(DstInputData%omega_z)) then
         allocate(DstInputData%omega_z(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%omega_z.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%omega_z = SrcInputData%omega_z
   end if
   if (allocated(SrcInputData%xVelCorr)) then
      LB(1:2) = lbound(SrcInputData%xVelCorr)
      UB(1:2) = ubound(SrcInputData%xVelCorr)
      if (.not. allocated(DstInputData%xVelCorr)) then
         allocate(DstInputData%xVelCorr(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%xVelCorr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%xVelCorr = SrcInputData%xVelCorr
   end if
   if (allocated(SrcInputData%rLocal)) then
      LB(1:2) = lbound(SrcInputData%rLocal)
      UB(1:2) = ubound(SrcInputData%rLocal)
      if (.not. allocated(DstInputData%rLocal)) then
         allocate(DstInputData%rLocal(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%rLocal.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%rLocal = SrcInputData%rLocal
   end if
   DstInputData%Un_disk = SrcInputData%Un_disk
   DstInputData%V0 = SrcInputData%V0
   DstInputData%x_hat_disk = SrcInputData%x_hat_disk
   if (allocated(SrcInputData%UserProp)) then
      LB(1:2) = lbound(SrcInputData%UserProp)
      UB(1:2) = ubound(SrcInputData%UserProp)
      if (.not. allocated(DstInputData%UserProp)) then
         allocate(DstInputData%UserProp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%UserProp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%UserProp = SrcInputData%UserProp
   end if
   if (allocated(SrcInputData%CantAngle)) then
      LB(1:2) = lbound(SrcInputData%CantAngle)
      UB(1:2) = ubound(SrcInputData%CantAngle)
      if (.not. allocated(DstInputData%CantAngle)) then
         allocate(DstInputData%CantAngle(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%CantAngle.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%CantAngle = SrcInputData%CantAngle
   end if
   if (allocated(SrcInputData%drdz)) then
      LB(1:2) = lbound(SrcInputData%drdz)
      UB(1:2) = ubound(SrcInputData%drdz)
      if (.not. allocated(DstInputData%drdz)) then
         allocate(DstInputData%drdz(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%drdz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%drdz = SrcInputData%drdz
   end if
   if (allocated(SrcInputData%toeAngle)) then
      LB(1:2) = lbound(SrcInputData%toeAngle)
      UB(1:2) = ubound(SrcInputData%toeAngle)
      if (.not. allocated(DstInputData%toeAngle)) then
         allocate(DstInputData%toeAngle(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%toeAngle.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%toeAngle = SrcInputData%toeAngle
   end if
end subroutine

subroutine BEMT_DestroyInput(InputData, ErrStat, ErrMsg)
   type(BEMT_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BEMT_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%theta)) then
      deallocate(InputData%theta)
   end if
   if (allocated(InputData%psi_s)) then
      deallocate(InputData%psi_s)
   end if
   if (allocated(InputData%Vx)) then
      deallocate(InputData%Vx)
   end if
   if (allocated(InputData%Vy)) then
      deallocate(InputData%Vy)
   end if
   if (allocated(InputData%Vz)) then
      deallocate(InputData%Vz)
   end if
   if (allocated(InputData%omega_z)) then
      deallocate(InputData%omega_z)
   end if
   if (allocated(InputData%xVelCorr)) then
      deallocate(InputData%xVelCorr)
   end if
   if (allocated(InputData%rLocal)) then
      deallocate(InputData%rLocal)
   end if
   if (allocated(InputData%UserProp)) then
      deallocate(InputData%UserProp)
   end if
   if (allocated(InputData%CantAngle)) then
      deallocate(InputData%CantAngle)
   end if
   if (allocated(InputData%drdz)) then
      deallocate(InputData%drdz)
   end if
   if (allocated(InputData%toeAngle)) then
      deallocate(InputData%toeAngle)
   end if
end subroutine

subroutine BEMT_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BEMT_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BEMT_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%theta)
   call RegPack(RF, InData%chi0)
   call RegPack(RF, InData%psiSkewOffset)
   call RegPackAlloc(RF, InData%psi_s)
   call RegPack(RF, InData%omega)
   call RegPack(RF, InData%TSR)
   call RegPackAlloc(RF, InData%Vx)
   call RegPackAlloc(RF, InData%Vy)
   call RegPackAlloc(RF, InData%Vz)
   call RegPackAlloc(RF, InData%omega_z)
   call RegPackAlloc(RF, InData%xVelCorr)
   call RegPackAlloc(RF, InData%rLocal)
   call RegPack(RF, InData%Un_disk)
   call RegPack(RF, InData%V0)
   call RegPack(RF, InData%x_hat_disk)
   call RegPackAlloc(RF, InData%UserProp)
   call RegPackAlloc(RF, InData%CantAngle)
   call RegPackAlloc(RF, InData%drdz)
   call RegPackAlloc(RF, InData%toeAngle)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BEMT_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BEMT_UnPackInput'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%theta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%chi0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%psiSkewOffset); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%psi_s); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%omega); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TSR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%omega_z); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%xVelCorr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rLocal); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Un_disk); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%V0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%x_hat_disk); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%UserProp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CantAngle); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%drdz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%toeAngle); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(BEMT_OutputType), intent(in) :: SrcOutputData
   type(BEMT_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'BEMT_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%Vrel)) then
      LB(1:2) = lbound(SrcOutputData%Vrel)
      UB(1:2) = ubound(SrcOutputData%Vrel)
      if (.not. allocated(DstOutputData%Vrel)) then
         allocate(DstOutputData%Vrel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Vrel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Vrel = SrcOutputData%Vrel
   end if
   if (allocated(SrcOutputData%phi)) then
      LB(1:2) = lbound(SrcOutputData%phi)
      UB(1:2) = ubound(SrcOutputData%phi)
      if (.not. allocated(DstOutputData%phi)) then
         allocate(DstOutputData%phi(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%phi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%phi = SrcOutputData%phi
   end if
   if (allocated(SrcOutputData%axInduction)) then
      LB(1:2) = lbound(SrcOutputData%axInduction)
      UB(1:2) = ubound(SrcOutputData%axInduction)
      if (.not. allocated(DstOutputData%axInduction)) then
         allocate(DstOutputData%axInduction(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%axInduction.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%axInduction = SrcOutputData%axInduction
   end if
   if (allocated(SrcOutputData%tanInduction)) then
      LB(1:2) = lbound(SrcOutputData%tanInduction)
      UB(1:2) = ubound(SrcOutputData%tanInduction)
      if (.not. allocated(DstOutputData%tanInduction)) then
         allocate(DstOutputData%tanInduction(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%tanInduction.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%tanInduction = SrcOutputData%tanInduction
   end if
   if (allocated(SrcOutputData%axInduction_qs)) then
      LB(1:2) = lbound(SrcOutputData%axInduction_qs)
      UB(1:2) = ubound(SrcOutputData%axInduction_qs)
      if (.not. allocated(DstOutputData%axInduction_qs)) then
         allocate(DstOutputData%axInduction_qs(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%axInduction_qs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%axInduction_qs = SrcOutputData%axInduction_qs
   end if
   if (allocated(SrcOutputData%tanInduction_qs)) then
      LB(1:2) = lbound(SrcOutputData%tanInduction_qs)
      UB(1:2) = ubound(SrcOutputData%tanInduction_qs)
      if (.not. allocated(DstOutputData%tanInduction_qs)) then
         allocate(DstOutputData%tanInduction_qs(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%tanInduction_qs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%tanInduction_qs = SrcOutputData%tanInduction_qs
   end if
   if (allocated(SrcOutputData%k)) then
      LB(1:2) = lbound(SrcOutputData%k)
      UB(1:2) = ubound(SrcOutputData%k)
      if (.not. allocated(DstOutputData%k)) then
         allocate(DstOutputData%k(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%k.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%k = SrcOutputData%k
   end if
   if (allocated(SrcOutputData%k_p)) then
      LB(1:2) = lbound(SrcOutputData%k_p)
      UB(1:2) = ubound(SrcOutputData%k_p)
      if (.not. allocated(DstOutputData%k_p)) then
         allocate(DstOutputData%k_p(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%k_p.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%k_p = SrcOutputData%k_p
   end if
   if (allocated(SrcOutputData%F)) then
      LB(1:2) = lbound(SrcOutputData%F)
      UB(1:2) = ubound(SrcOutputData%F)
      if (.not. allocated(DstOutputData%F)) then
         allocate(DstOutputData%F(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%F.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%F = SrcOutputData%F
   end if
   if (allocated(SrcOutputData%Re)) then
      LB(1:2) = lbound(SrcOutputData%Re)
      UB(1:2) = ubound(SrcOutputData%Re)
      if (.not. allocated(DstOutputData%Re)) then
         allocate(DstOutputData%Re(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Re.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Re = SrcOutputData%Re
   end if
   if (allocated(SrcOutputData%AOA)) then
      LB(1:2) = lbound(SrcOutputData%AOA)
      UB(1:2) = ubound(SrcOutputData%AOA)
      if (.not. allocated(DstOutputData%AOA)) then
         allocate(DstOutputData%AOA(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%AOA.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%AOA = SrcOutputData%AOA
   end if
   if (allocated(SrcOutputData%Cx)) then
      LB(1:2) = lbound(SrcOutputData%Cx)
      UB(1:2) = ubound(SrcOutputData%Cx)
      if (.not. allocated(DstOutputData%Cx)) then
         allocate(DstOutputData%Cx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Cx = SrcOutputData%Cx
   end if
   if (allocated(SrcOutputData%Cy)) then
      LB(1:2) = lbound(SrcOutputData%Cy)
      UB(1:2) = ubound(SrcOutputData%Cy)
      if (.not. allocated(DstOutputData%Cy)) then
         allocate(DstOutputData%Cy(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cy.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Cy = SrcOutputData%Cy
   end if
   if (allocated(SrcOutputData%Cz)) then
      LB(1:2) = lbound(SrcOutputData%Cz)
      UB(1:2) = ubound(SrcOutputData%Cz)
      if (.not. allocated(DstOutputData%Cz)) then
         allocate(DstOutputData%Cz(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Cz = SrcOutputData%Cz
   end if
   if (allocated(SrcOutputData%Cmx)) then
      LB(1:2) = lbound(SrcOutputData%Cmx)
      UB(1:2) = ubound(SrcOutputData%Cmx)
      if (.not. allocated(DstOutputData%Cmx)) then
         allocate(DstOutputData%Cmx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cmx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Cmx = SrcOutputData%Cmx
   end if
   if (allocated(SrcOutputData%Cmy)) then
      LB(1:2) = lbound(SrcOutputData%Cmy)
      UB(1:2) = ubound(SrcOutputData%Cmy)
      if (.not. allocated(DstOutputData%Cmy)) then
         allocate(DstOutputData%Cmy(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cmy.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Cmy = SrcOutputData%Cmy
   end if
   if (allocated(SrcOutputData%Cmz)) then
      LB(1:2) = lbound(SrcOutputData%Cmz)
      UB(1:2) = ubound(SrcOutputData%Cmz)
      if (.not. allocated(DstOutputData%Cmz)) then
         allocate(DstOutputData%Cmz(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cmz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Cmz = SrcOutputData%Cmz
   end if
   if (allocated(SrcOutputData%Cm)) then
      LB(1:2) = lbound(SrcOutputData%Cm)
      UB(1:2) = ubound(SrcOutputData%Cm)
      if (.not. allocated(DstOutputData%Cm)) then
         allocate(DstOutputData%Cm(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cm.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Cm = SrcOutputData%Cm
   end if
   if (allocated(SrcOutputData%Cl)) then
      LB(1:2) = lbound(SrcOutputData%Cl)
      UB(1:2) = ubound(SrcOutputData%Cl)
      if (.not. allocated(DstOutputData%Cl)) then
         allocate(DstOutputData%Cl(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cl.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Cl = SrcOutputData%Cl
   end if
   if (allocated(SrcOutputData%Cd)) then
      LB(1:2) = lbound(SrcOutputData%Cd)
      UB(1:2) = ubound(SrcOutputData%Cd)
      if (.not. allocated(DstOutputData%Cd)) then
         allocate(DstOutputData%Cd(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Cd = SrcOutputData%Cd
   end if
   if (allocated(SrcOutputData%chi)) then
      LB(1:2) = lbound(SrcOutputData%chi)
      UB(1:2) = ubound(SrcOutputData%chi)
      if (.not. allocated(DstOutputData%chi)) then
         allocate(DstOutputData%chi(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%chi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%chi = SrcOutputData%chi
   end if
   if (allocated(SrcOutputData%Cpmin)) then
      LB(1:2) = lbound(SrcOutputData%Cpmin)
      UB(1:2) = ubound(SrcOutputData%Cpmin)
      if (.not. allocated(DstOutputData%Cpmin)) then
         allocate(DstOutputData%Cpmin(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%Cpmin.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%Cpmin = SrcOutputData%Cpmin
   end if
end subroutine

subroutine BEMT_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(BEMT_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'BEMT_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%Vrel)) then
      deallocate(OutputData%Vrel)
   end if
   if (allocated(OutputData%phi)) then
      deallocate(OutputData%phi)
   end if
   if (allocated(OutputData%axInduction)) then
      deallocate(OutputData%axInduction)
   end if
   if (allocated(OutputData%tanInduction)) then
      deallocate(OutputData%tanInduction)
   end if
   if (allocated(OutputData%axInduction_qs)) then
      deallocate(OutputData%axInduction_qs)
   end if
   if (allocated(OutputData%tanInduction_qs)) then
      deallocate(OutputData%tanInduction_qs)
   end if
   if (allocated(OutputData%k)) then
      deallocate(OutputData%k)
   end if
   if (allocated(OutputData%k_p)) then
      deallocate(OutputData%k_p)
   end if
   if (allocated(OutputData%F)) then
      deallocate(OutputData%F)
   end if
   if (allocated(OutputData%Re)) then
      deallocate(OutputData%Re)
   end if
   if (allocated(OutputData%AOA)) then
      deallocate(OutputData%AOA)
   end if
   if (allocated(OutputData%Cx)) then
      deallocate(OutputData%Cx)
   end if
   if (allocated(OutputData%Cy)) then
      deallocate(OutputData%Cy)
   end if
   if (allocated(OutputData%Cz)) then
      deallocate(OutputData%Cz)
   end if
   if (allocated(OutputData%Cmx)) then
      deallocate(OutputData%Cmx)
   end if
   if (allocated(OutputData%Cmy)) then
      deallocate(OutputData%Cmy)
   end if
   if (allocated(OutputData%Cmz)) then
      deallocate(OutputData%Cmz)
   end if
   if (allocated(OutputData%Cm)) then
      deallocate(OutputData%Cm)
   end if
   if (allocated(OutputData%Cl)) then
      deallocate(OutputData%Cl)
   end if
   if (allocated(OutputData%Cd)) then
      deallocate(OutputData%Cd)
   end if
   if (allocated(OutputData%chi)) then
      deallocate(OutputData%chi)
   end if
   if (allocated(OutputData%Cpmin)) then
      deallocate(OutputData%Cpmin)
   end if
end subroutine

subroutine BEMT_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BEMT_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'BEMT_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Vrel)
   call RegPackAlloc(RF, InData%phi)
   call RegPackAlloc(RF, InData%axInduction)
   call RegPackAlloc(RF, InData%tanInduction)
   call RegPackAlloc(RF, InData%axInduction_qs)
   call RegPackAlloc(RF, InData%tanInduction_qs)
   call RegPackAlloc(RF, InData%k)
   call RegPackAlloc(RF, InData%k_p)
   call RegPackAlloc(RF, InData%F)
   call RegPackAlloc(RF, InData%Re)
   call RegPackAlloc(RF, InData%AOA)
   call RegPackAlloc(RF, InData%Cx)
   call RegPackAlloc(RF, InData%Cy)
   call RegPackAlloc(RF, InData%Cz)
   call RegPackAlloc(RF, InData%Cmx)
   call RegPackAlloc(RF, InData%Cmy)
   call RegPackAlloc(RF, InData%Cmz)
   call RegPackAlloc(RF, InData%Cm)
   call RegPackAlloc(RF, InData%Cl)
   call RegPackAlloc(RF, InData%Cd)
   call RegPackAlloc(RF, InData%chi)
   call RegPackAlloc(RF, InData%Cpmin)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BEMT_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'BEMT_UnPackOutput'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Vrel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%phi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%axInduction); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%tanInduction); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%axInduction_qs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%tanInduction_qs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%k); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%k_p); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%F); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Re); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AOA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cmx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cmy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cmz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%chi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cpmin); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine BEMT_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(BEMT_InputType), intent(in)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(BEMT_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'BEMT_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call BEMT_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call BEMT_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call BEMT_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE BEMT_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(BEMT_InputType), INTENT(IN)  :: u1    ! Input at t1 > t2
   TYPE(BEMT_InputType), INTENT(IN)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(BEMT_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'BEMT_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(u_out%theta) .AND. ALLOCATED(u1%theta)) THEN
      u_out%theta = a1*u1%theta + a2*u2%theta
   END IF ! check if allocated
   u_out%chi0 = a1*u1%chi0 + a2*u2%chi0
   u_out%psiSkewOffset = a1*u1%psiSkewOffset + a2*u2%psiSkewOffset
   IF (ALLOCATED(u_out%psi_s) .AND. ALLOCATED(u1%psi_s)) THEN
      u_out%psi_s = a1*u1%psi_s + a2*u2%psi_s
   END IF ! check if allocated
   u_out%omega = a1*u1%omega + a2*u2%omega
   u_out%TSR = a1*u1%TSR + a2*u2%TSR
   IF (ALLOCATED(u_out%Vx) .AND. ALLOCATED(u1%Vx)) THEN
      u_out%Vx = a1*u1%Vx + a2*u2%Vx
   END IF ! check if allocated
   IF (ALLOCATED(u_out%Vy) .AND. ALLOCATED(u1%Vy)) THEN
      u_out%Vy = a1*u1%Vy + a2*u2%Vy
   END IF ! check if allocated
   IF (ALLOCATED(u_out%Vz) .AND. ALLOCATED(u1%Vz)) THEN
      u_out%Vz = a1*u1%Vz + a2*u2%Vz
   END IF ! check if allocated
   IF (ALLOCATED(u_out%omega_z) .AND. ALLOCATED(u1%omega_z)) THEN
      u_out%omega_z = a1*u1%omega_z + a2*u2%omega_z
   END IF ! check if allocated
   IF (ALLOCATED(u_out%xVelCorr) .AND. ALLOCATED(u1%xVelCorr)) THEN
      u_out%xVelCorr = a1*u1%xVelCorr + a2*u2%xVelCorr
   END IF ! check if allocated
   IF (ALLOCATED(u_out%rLocal) .AND. ALLOCATED(u1%rLocal)) THEN
      u_out%rLocal = a1*u1%rLocal + a2*u2%rLocal
   END IF ! check if allocated
   u_out%Un_disk = a1*u1%Un_disk + a2*u2%Un_disk
   u_out%V0 = a1*u1%V0 + a2*u2%V0
   u_out%x_hat_disk = a1*u1%x_hat_disk + a2*u2%x_hat_disk
   IF (ALLOCATED(u_out%UserProp) .AND. ALLOCATED(u1%UserProp)) THEN
      u_out%UserProp = a1*u1%UserProp + a2*u2%UserProp
   END IF ! check if allocated
   IF (ALLOCATED(u_out%CantAngle) .AND. ALLOCATED(u1%CantAngle)) THEN
      u_out%CantAngle = a1*u1%CantAngle + a2*u2%CantAngle
   END IF ! check if allocated
   IF (ALLOCATED(u_out%drdz) .AND. ALLOCATED(u1%drdz)) THEN
      u_out%drdz = a1*u1%drdz + a2*u2%drdz
   END IF ! check if allocated
   IF (ALLOCATED(u_out%toeAngle) .AND. ALLOCATED(u1%toeAngle)) THEN
      u_out%toeAngle = a1*u1%toeAngle + a2*u2%toeAngle
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE BEMT_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(BEMT_InputType), INTENT(IN)  :: u1      ! Input at t1 > t2 > t3
   TYPE(BEMT_InputType), INTENT(IN)  :: u2      ! Input at t2 > t3
   TYPE(BEMT_InputType), INTENT(IN)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(BEMT_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'BEMT_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(u_out%theta) .AND. ALLOCATED(u1%theta)) THEN
      u_out%theta = a1*u1%theta + a2*u2%theta + a3*u3%theta
   END IF ! check if allocated
   u_out%chi0 = a1*u1%chi0 + a2*u2%chi0 + a3*u3%chi0
   u_out%psiSkewOffset = a1*u1%psiSkewOffset + a2*u2%psiSkewOffset + a3*u3%psiSkewOffset
   IF (ALLOCATED(u_out%psi_s) .AND. ALLOCATED(u1%psi_s)) THEN
      u_out%psi_s = a1*u1%psi_s + a2*u2%psi_s + a3*u3%psi_s
   END IF ! check if allocated
   u_out%omega = a1*u1%omega + a2*u2%omega + a3*u3%omega
   u_out%TSR = a1*u1%TSR + a2*u2%TSR + a3*u3%TSR
   IF (ALLOCATED(u_out%Vx) .AND. ALLOCATED(u1%Vx)) THEN
      u_out%Vx = a1*u1%Vx + a2*u2%Vx + a3*u3%Vx
   END IF ! check if allocated
   IF (ALLOCATED(u_out%Vy) .AND. ALLOCATED(u1%Vy)) THEN
      u_out%Vy = a1*u1%Vy + a2*u2%Vy + a3*u3%Vy
   END IF ! check if allocated
   IF (ALLOCATED(u_out%Vz) .AND. ALLOCATED(u1%Vz)) THEN
      u_out%Vz = a1*u1%Vz + a2*u2%Vz + a3*u3%Vz
   END IF ! check if allocated
   IF (ALLOCATED(u_out%omega_z) .AND. ALLOCATED(u1%omega_z)) THEN
      u_out%omega_z = a1*u1%omega_z + a2*u2%omega_z + a3*u3%omega_z
   END IF ! check if allocated
   IF (ALLOCATED(u_out%xVelCorr) .AND. ALLOCATED(u1%xVelCorr)) THEN
      u_out%xVelCorr = a1*u1%xVelCorr + a2*u2%xVelCorr + a3*u3%xVelCorr
   END IF ! check if allocated
   IF (ALLOCATED(u_out%rLocal) .AND. ALLOCATED(u1%rLocal)) THEN
      u_out%rLocal = a1*u1%rLocal + a2*u2%rLocal + a3*u3%rLocal
   END IF ! check if allocated
   u_out%Un_disk = a1*u1%Un_disk + a2*u2%Un_disk + a3*u3%Un_disk
   u_out%V0 = a1*u1%V0 + a2*u2%V0 + a3*u3%V0
   u_out%x_hat_disk = a1*u1%x_hat_disk + a2*u2%x_hat_disk + a3*u3%x_hat_disk
   IF (ALLOCATED(u_out%UserProp) .AND. ALLOCATED(u1%UserProp)) THEN
      u_out%UserProp = a1*u1%UserProp + a2*u2%UserProp + a3*u3%UserProp
   END IF ! check if allocated
   IF (ALLOCATED(u_out%CantAngle) .AND. ALLOCATED(u1%CantAngle)) THEN
      u_out%CantAngle = a1*u1%CantAngle + a2*u2%CantAngle + a3*u3%CantAngle
   END IF ! check if allocated
   IF (ALLOCATED(u_out%drdz) .AND. ALLOCATED(u1%drdz)) THEN
      u_out%drdz = a1*u1%drdz + a2*u2%drdz + a3*u3%drdz
   END IF ! check if allocated
   IF (ALLOCATED(u_out%toeAngle) .AND. ALLOCATED(u1%toeAngle)) THEN
      u_out%toeAngle = a1*u1%toeAngle + a2*u2%toeAngle + a3*u3%toeAngle
   END IF ! check if allocated
END SUBROUTINE

subroutine BEMT_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(BEMT_OutputType), intent(in)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(BEMT_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'BEMT_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call BEMT_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call BEMT_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call BEMT_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE BEMT_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(BEMT_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
   TYPE(BEMT_OutputType), INTENT(IN)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(BEMT_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'BEMT_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%Vrel) .AND. ALLOCATED(y1%Vrel)) THEN
      y_out%Vrel = a1*y1%Vrel + a2*y2%Vrel
   END IF ! check if allocated
   IF (ALLOCATED(y_out%phi) .AND. ALLOCATED(y1%phi)) THEN
      y_out%phi = a1*y1%phi + a2*y2%phi
   END IF ! check if allocated
   IF (ALLOCATED(y_out%axInduction) .AND. ALLOCATED(y1%axInduction)) THEN
      y_out%axInduction = a1*y1%axInduction + a2*y2%axInduction
   END IF ! check if allocated
   IF (ALLOCATED(y_out%tanInduction) .AND. ALLOCATED(y1%tanInduction)) THEN
      y_out%tanInduction = a1*y1%tanInduction + a2*y2%tanInduction
   END IF ! check if allocated
   IF (ALLOCATED(y_out%axInduction_qs) .AND. ALLOCATED(y1%axInduction_qs)) THEN
      y_out%axInduction_qs = a1*y1%axInduction_qs + a2*y2%axInduction_qs
   END IF ! check if allocated
   IF (ALLOCATED(y_out%tanInduction_qs) .AND. ALLOCATED(y1%tanInduction_qs)) THEN
      y_out%tanInduction_qs = a1*y1%tanInduction_qs + a2*y2%tanInduction_qs
   END IF ! check if allocated
   IF (ALLOCATED(y_out%k) .AND. ALLOCATED(y1%k)) THEN
      y_out%k = a1*y1%k + a2*y2%k
   END IF ! check if allocated
   IF (ALLOCATED(y_out%k_p) .AND. ALLOCATED(y1%k_p)) THEN
      y_out%k_p = a1*y1%k_p + a2*y2%k_p
   END IF ! check if allocated
   IF (ALLOCATED(y_out%F) .AND. ALLOCATED(y1%F)) THEN
      y_out%F = a1*y1%F + a2*y2%F
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Re) .AND. ALLOCATED(y1%Re)) THEN
      y_out%Re = a1*y1%Re + a2*y2%Re
   END IF ! check if allocated
   IF (ALLOCATED(y_out%AOA) .AND. ALLOCATED(y1%AOA)) THEN
      y_out%AOA = a1*y1%AOA + a2*y2%AOA
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cx) .AND. ALLOCATED(y1%Cx)) THEN
      y_out%Cx = a1*y1%Cx + a2*y2%Cx
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cy) .AND. ALLOCATED(y1%Cy)) THEN
      y_out%Cy = a1*y1%Cy + a2*y2%Cy
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cz) .AND. ALLOCATED(y1%Cz)) THEN
      y_out%Cz = a1*y1%Cz + a2*y2%Cz
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cmx) .AND. ALLOCATED(y1%Cmx)) THEN
      y_out%Cmx = a1*y1%Cmx + a2*y2%Cmx
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cmy) .AND. ALLOCATED(y1%Cmy)) THEN
      y_out%Cmy = a1*y1%Cmy + a2*y2%Cmy
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cmz) .AND. ALLOCATED(y1%Cmz)) THEN
      y_out%Cmz = a1*y1%Cmz + a2*y2%Cmz
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cm) .AND. ALLOCATED(y1%Cm)) THEN
      y_out%Cm = a1*y1%Cm + a2*y2%Cm
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cl) .AND. ALLOCATED(y1%Cl)) THEN
      y_out%Cl = a1*y1%Cl + a2*y2%Cl
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cd) .AND. ALLOCATED(y1%Cd)) THEN
      y_out%Cd = a1*y1%Cd + a2*y2%Cd
   END IF ! check if allocated
   IF (ALLOCATED(y_out%chi) .AND. ALLOCATED(y1%chi)) THEN
      y_out%chi = a1*y1%chi + a2*y2%chi
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cpmin) .AND. ALLOCATED(y1%Cpmin)) THEN
      y_out%Cpmin = a1*y1%Cpmin + a2*y2%Cpmin
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE BEMT_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(BEMT_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
   TYPE(BEMT_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
   TYPE(BEMT_OutputType), INTENT(IN)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(BEMT_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'BEMT_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%Vrel) .AND. ALLOCATED(y1%Vrel)) THEN
      y_out%Vrel = a1*y1%Vrel + a2*y2%Vrel + a3*y3%Vrel
   END IF ! check if allocated
   IF (ALLOCATED(y_out%phi) .AND. ALLOCATED(y1%phi)) THEN
      y_out%phi = a1*y1%phi + a2*y2%phi + a3*y3%phi
   END IF ! check if allocated
   IF (ALLOCATED(y_out%axInduction) .AND. ALLOCATED(y1%axInduction)) THEN
      y_out%axInduction = a1*y1%axInduction + a2*y2%axInduction + a3*y3%axInduction
   END IF ! check if allocated
   IF (ALLOCATED(y_out%tanInduction) .AND. ALLOCATED(y1%tanInduction)) THEN
      y_out%tanInduction = a1*y1%tanInduction + a2*y2%tanInduction + a3*y3%tanInduction
   END IF ! check if allocated
   IF (ALLOCATED(y_out%axInduction_qs) .AND. ALLOCATED(y1%axInduction_qs)) THEN
      y_out%axInduction_qs = a1*y1%axInduction_qs + a2*y2%axInduction_qs + a3*y3%axInduction_qs
   END IF ! check if allocated
   IF (ALLOCATED(y_out%tanInduction_qs) .AND. ALLOCATED(y1%tanInduction_qs)) THEN
      y_out%tanInduction_qs = a1*y1%tanInduction_qs + a2*y2%tanInduction_qs + a3*y3%tanInduction_qs
   END IF ! check if allocated
   IF (ALLOCATED(y_out%k) .AND. ALLOCATED(y1%k)) THEN
      y_out%k = a1*y1%k + a2*y2%k + a3*y3%k
   END IF ! check if allocated
   IF (ALLOCATED(y_out%k_p) .AND. ALLOCATED(y1%k_p)) THEN
      y_out%k_p = a1*y1%k_p + a2*y2%k_p + a3*y3%k_p
   END IF ! check if allocated
   IF (ALLOCATED(y_out%F) .AND. ALLOCATED(y1%F)) THEN
      y_out%F = a1*y1%F + a2*y2%F + a3*y3%F
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Re) .AND. ALLOCATED(y1%Re)) THEN
      y_out%Re = a1*y1%Re + a2*y2%Re + a3*y3%Re
   END IF ! check if allocated
   IF (ALLOCATED(y_out%AOA) .AND. ALLOCATED(y1%AOA)) THEN
      y_out%AOA = a1*y1%AOA + a2*y2%AOA + a3*y3%AOA
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cx) .AND. ALLOCATED(y1%Cx)) THEN
      y_out%Cx = a1*y1%Cx + a2*y2%Cx + a3*y3%Cx
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cy) .AND. ALLOCATED(y1%Cy)) THEN
      y_out%Cy = a1*y1%Cy + a2*y2%Cy + a3*y3%Cy
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cz) .AND. ALLOCATED(y1%Cz)) THEN
      y_out%Cz = a1*y1%Cz + a2*y2%Cz + a3*y3%Cz
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cmx) .AND. ALLOCATED(y1%Cmx)) THEN
      y_out%Cmx = a1*y1%Cmx + a2*y2%Cmx + a3*y3%Cmx
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cmy) .AND. ALLOCATED(y1%Cmy)) THEN
      y_out%Cmy = a1*y1%Cmy + a2*y2%Cmy + a3*y3%Cmy
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cmz) .AND. ALLOCATED(y1%Cmz)) THEN
      y_out%Cmz = a1*y1%Cmz + a2*y2%Cmz + a3*y3%Cmz
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cm) .AND. ALLOCATED(y1%Cm)) THEN
      y_out%Cm = a1*y1%Cm + a2*y2%Cm + a3*y3%Cm
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cl) .AND. ALLOCATED(y1%Cl)) THEN
      y_out%Cl = a1*y1%Cl + a2*y2%Cl + a3*y3%Cl
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cd) .AND. ALLOCATED(y1%Cd)) THEN
      y_out%Cd = a1*y1%Cd + a2*y2%Cd + a3*y3%Cd
   END IF ! check if allocated
   IF (ALLOCATED(y_out%chi) .AND. ALLOCATED(y1%chi)) THEN
      y_out%chi = a1*y1%chi + a2*y2%chi + a3*y3%chi
   END IF ! check if allocated
   IF (ALLOCATED(y_out%Cpmin) .AND. ALLOCATED(y1%Cpmin)) THEN
      y_out%Cpmin = a1*y1%Cpmin + a2*y2%Cpmin + a3*y3%Cpmin
   END IF ! check if allocated
END SUBROUTINE
END MODULE BEMT_Types
!ENDOFREGISTRYGENERATEDFILE
