!STARTOFREGISTRYGENERATEDFILE 'AirfoilInfo_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! AirfoilInfo_Types
!.................................................................................................................................
! This file is part of AirfoilInfo.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in AirfoilInfo. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE AirfoilInfo_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: AFITable_1 = 1      ! 1D interpolation on AoA (first table only) [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: AFITable_2Re = 2      ! 2D interpolation on AoA and Re [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: AFITable_2User = 3      ! 2D interpolation on AoA and UserProp [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_None = 0      ! Steady aerodynamics, using the same angle of attack convention as UA [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_Baseline = 1      ! UAMod = 1 [Baseline model (Original)] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_Gonzalez = 2      ! UAMod = 2 [Gonzalez's variant (changes in Cn,Cc,Cm)] [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_MinnemaPierce = 3      ! Minnema/Pierce variant (changes in Cc and Cm) [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_HGM = 4      ! continuous variant of HGM (Hansen) model [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_HGMV = 5      ! continuous variant of HGM (Hansen) model with vortex modifications [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_Oye = 6      ! Stieg Oye dynamic stall model [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_BV = 7      ! Boeing-Vertol dynamic stall model (e.g. used in CACTUS) [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: UA_HGMV360 = 8      ! continuous variant of HGM (Hansen) model with vortex modifications modified for 360-deg [-]
! =========  AFI_UA_BL_Type  =======
  TYPE, PUBLIC :: AFI_UA_BL_Type
    REAL(ReKi)  :: alpha0 = 0.0_ReKi      !< Angle of attack for zero lift (also used in HGM) [input in degrees; stored as radians]
    REAL(ReKi)  :: alpha1 = 0.0_ReKi      !< angle of attack at f = 0.7, approximately the stall angle; for alpha >= alpha0 [input in degrees; stored as radians]
    REAL(ReKi)  :: alpha2 = 0.0_ReKi      !< angle of attack at f = 0.7, approximately the stall angle; for alpha < alpha0 [input in degrees; stored as radians]
    REAL(ReKi)  :: eta_e = 0.0_ReKi      !< Recovery factor in the range [0.85 - 0.95] [-]
    REAL(ReKi)  :: C_nalpha = 0.0_ReKi      !< Cn slope for zero lift (used for Beddoes-Leishman unsteady aero) [1/rad]
    REAL(ReKi)  :: C_lalpha = 0.0_ReKi      !< Cl slope for zero lift (used for HGM unsteady aero only) -> calculated [1/rad]
    REAL(ReKi)  :: T_f0 = 0.0_ReKi      !< initial value of T_f, airfoil specific, used to compute D_f and fprimeprime (also used in HGM) [-]
    REAL(ReKi)  :: T_V0 = 0.0_ReKi      !< initial value of T_V, airfoil specific, time parameter associated with the vortex lift decay process, used in Cn_v [-]
    REAL(ReKi)  :: T_p = 0.0_ReKi      !< boundary-layer, leading edge pressure gradient time parameter; used in D_p; airfoil specific (also used in HGM) [-]
    REAL(ReKi)  :: T_VL = 0.0_ReKi      !< Initial value of the time constant associated with the vortex advection process; it represents the non-dimensional time in semi-chords, needed for a vortex to travel from LE to trailing edge (TE); it is used in the expression of Cvn. It depends on Re, M (weakly), and airfoil. [valid range = 6 - 13] [-]
    REAL(ReKi)  :: b1 = 0.0_ReKi      !< airfoil constant derived from experimental results (also used in HGM), usually 0.14 [-]
    REAL(ReKi)  :: b2 = 0.0_ReKi      !< airfoil constant derived from experimental results (also used in HGM), usually 0.53 [-]
    REAL(ReKi)  :: b5 = 0.0_ReKi      !< airfoil constant derived from experimental results, usually 5.0 [-]
    REAL(ReKi)  :: A1 = 0.0_ReKi      !< airfoil constant derived from experimental results (also used in HGM), usually 0.3 [-]
    REAL(ReKi)  :: A2 = 0.0_ReKi      !< airfoil constant derived from experimental results (also used in HGM), usually 0.7 [-]
    REAL(ReKi)  :: A5 = 0.0_ReKi      !< airfoil constant derived from experimental results, usually 1.0 [-]
    REAL(ReKi)  :: S1 = 0.0_ReKi      !< Constant in the f curve best-fit for alpha0<=AOA<=alpha1 [-]
    REAL(ReKi)  :: S2 = 0.0_ReKi      !< Constant in the f curve best-fit for         AOA> alpha1 [-]
    REAL(ReKi)  :: S3 = 0.0_ReKi      !< Constant in the f curve best-fit for alpha2<=AOA< alpha0 [-]
    REAL(ReKi)  :: S4 = 0.0_ReKi      !< Constant in the f curve best-fit for         AOA< alpha2 [-]
    REAL(ReKi)  :: Cn1 = 0.0_ReKi      !< Cn at stall value for positive angle of attack [or critical value of Cn_prime at LE separation for alpha >= alpha0] [-]
    REAL(ReKi)  :: Cn2 = 0.0_ReKi      !< Cn at stall value for negative angle of attack [or critical value of Cn_prime at LE separation for alpha < alpha0] [-]
    REAL(ReKi)  :: St_sh = 0.0_ReKi      !< Strouhal's shedding frequency constant. [-]
    REAL(ReKi)  :: Cd0 = 0.0_ReKi      !< Minimum Cd value [-]
    REAL(ReKi)  :: Cm0 = 0.0_ReKi      !< 2D pitching moment coefficient at zero lift, positive if nose is up [-]
    REAL(ReKi)  :: k0 = 0.0_ReKi      !< airfoil parameter in the x_cp_hat curve best-fit [ignored if UAMod<>1] [-]
    REAL(ReKi)  :: k1 = 0.0_ReKi      !< airfoil parameter in the x_cp_hat curve best-fit [ignored if UAMod<>1] [-]
    REAL(ReKi)  :: k2 = 0.0_ReKi      !< airfoil parameter in the x_cp_hat curve best-fit [ignored if UAMod<>1] [-]
    REAL(ReKi)  :: k3 = 0.0_ReKi      !< airfoil parameter in the x_cp_hat curve best-fit [ignored if UAMod<>1] [-]
    REAL(ReKi)  :: k1_hat = 0.0_ReKi      !< Constant in the expression of Cc due to leading edge vortex effects.  [ignored if UAMod<>1] [-]
    REAL(ReKi)  :: x_cp_bar = 0.0_ReKi      !< Constant in the expression of \hat(x)_cp^v [ignored if UAMod<>1, default = 0.2] [-]
    REAL(ReKi)  :: UACutout = 0.0_ReKi      !< Angle of attack above which unsteady aerodynamics are disabled [input in degrees; stored as radians]
    REAL(ReKi)  :: UACutout_delta = 0.0_ReKi      !< Number of angles-of-attack below UACutout where unsteady aerodynamics begin to be disabled [input in degrees; stored as radians]
    REAL(ReKi)  :: UACutout_blend = 0.0_ReKi      !< Angle of attack above which unsteady aerodynamics begins to be disabled [stored as radians]
    REAL(ReKi)  :: filtCutOff = 0.0_ReKi      !< Reduced frequency cutoff used to calculate the dynamic low pass filter cut-off frequency for the pitching rate and accelerations [default = 0.5] [-]
    REAL(ReKi)  :: alphaUpper = 0.0_ReKi      !< (input) upper angle of attack defining fully attached region [input in degrees; stored as radians]
    REAL(ReKi)  :: alphaLower = 0.0_ReKi      !< (input) lower angle of attack defining fully attached region [input in degrees; stored as radians]
    REAL(ReKi)  :: c_alphaLower = 0.0_ReKi      !< (calculated) value of cn or cl at alphaLower [-]
    REAL(ReKi)  :: c_alphaUpper = 0.0_ReKi      !< (calculated) value of cn or cl at alphaUpper [-]
    REAL(ReKi)  :: alpha0ReverseFlow = 0.0_ReKi      !< (calculated) Angle of attack for Cn=0 for reverse flow [rad]
    REAL(ReKi)  :: alphaBreakUpper = 0.0_ReKi      !< (calculated) Angle of attack where normal and reverse flow CnAttached intersect; between 0 and +pi; will be near +pi/2 deg in most cases [rad]
    REAL(ReKi)  :: CnBreakUpper = 0.0_ReKi      !< (calculated) CnAttached value at alphaBreakUpper where normal and reverse flow CnAttached intersect; will be positive [-]
    REAL(ReKi)  :: alphaBreakLower = 0.0_ReKi      !< (calculated) Angle of attack where normal and reverse flow CnAttached intersect; between -pi and 0; will be near -pi/2 deg in most cases [rad]
    REAL(ReKi)  :: CnBreakLower = 0.0_ReKi      !< (calculated) CnAttached value at alphaBreakLower where normal and reverse flow CnAttached intersect; will be negative [-]
  END TYPE AFI_UA_BL_Type
! =======================
! =========  AFI_UA_BL_Default_Type  =======
  TYPE, PUBLIC :: AFI_UA_BL_Default_Type
    LOGICAL  :: alpha0 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: alpha1 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: alpha2 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: eta_e = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: C_nalpha = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: C_lalpha = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: T_f0 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: T_V0 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: T_p = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: T_VL = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: b1 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: b2 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: b5 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: A1 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: A2 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: A5 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: S1 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: S2 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: S3 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: S4 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: Cn1 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: Cn2 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: St_sh = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: Cd0 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: Cm0 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: k0 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: k1 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: k2 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: k3 = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: k1_hat = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: x_cp_bar = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: UACutout = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: UACutout_delta = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: filtCutOff = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: alphaUpper = .true.      !< Calculate value for this input? [-]
    LOGICAL  :: alphaLower = .true.      !< Calculate value for this input? [-]
  END TYPE AFI_UA_BL_Default_Type
! =======================
! =========  AFI_Table_Type  =======
  TYPE, PUBLIC :: AFI_Table_Type
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Alpha      !< Angle-of-attack vector that matches the Coefs matrix [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Coefs      !< Airfoil coefficients for Cd, Cl,  and maybe Cm and/or Cpmin [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: SplineCoefs      !< Spline coefficients for Cd, Cl,  and maybe Cm and/or Cpmin [-]
    REAL(ReKi)  :: UserProp = 0.0_ReKi      !< User Property for a table, for example a Control setting [-]
    REAL(ReKi)  :: Re = 0.0_ReKi      !< Reynolds number [-]
    INTEGER(IntKi)  :: NumAlf = 0_IntKi      !< Length of the Alpha and Coefs arrays [-]
    LOGICAL  :: ConstData = .false.      !< Flag that tells if aerodynamic coefficients are the same for all alphas [-]
    LOGICAL  :: InclUAdata = .false.      !< Flag that tells if UA data is included in the input file [-]
    TYPE(AFI_UA_BL_Type)  :: UA_BL      !< The tables of Leishman-Beddoes unsteady-aero data for given Re and control setting [-]
  END TYPE AFI_Table_Type
! =======================
! =========  AFI_InitInputType  =======
  TYPE, PUBLIC :: AFI_InitInputType
    CHARACTER(1024)  :: FileName      !< The name of the file the data is read from [-]
    INTEGER(IntKi)  :: AFTabMod = 0_IntKi      !< Interpolation method for multiple airfoil tables {1 = 1D on AoA (only first table is used); 2 = 2D on AoA and Re; 3 = 2D on AoA and UserProp} [-]
    INTEGER(IntKi)  :: InCol_Alfa = 0_IntKi      !< The column of the coefficient tables that holds the angle of attack [-]
    INTEGER(IntKi)  :: InCol_Cl = 0_IntKi      !< The column of the coefficient tables that holds the lift coefficient [-]
    INTEGER(IntKi)  :: InCol_Cd = 0_IntKi      !< The column of the coefficient tables that holds the minimum pressure coefficient [-]
    INTEGER(IntKi)  :: InCol_Cm = 0_IntKi      !< The column of the coefficient tables that holds the pitching-moment coefficient [-]
    INTEGER(IntKi)  :: InCol_Cpmin = 0_IntKi      !< The column of the coefficient tables that holds the minimum pressure coefficient [-]
    INTEGER(IntKi)  :: UAMod = 0_IntKi      !< UA model: used to determine how UA separation functions should be calculated [-]
  END TYPE AFI_InitInputType
! =======================
! =========  AFI_InitOutputType  =======
  TYPE, PUBLIC :: AFI_InitOutputType
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
  END TYPE AFI_InitOutputType
! =======================
! =========  AFI_ParameterType  =======
  TYPE, PUBLIC :: AFI_ParameterType
    INTEGER(IntKi)  :: ColCd = 0_IntKi      !< The column in the p%Coefs arrays that contains Cd data [-]
    INTEGER(IntKi)  :: ColCl = 0_IntKi      !< The column in the p%Coefs arrays that contains Cl data [-]
    INTEGER(IntKi)  :: ColCm = 0_IntKi      !< The column in the p%Coefs arrays that contains Cm data [-]
    INTEGER(IntKi)  :: ColCpmin = 0_IntKi      !< The column in the p%Coefs arrays that contains Cpmin data [-]
    INTEGER(IntKi)  :: ColUAf = 0_IntKi      !< The column in the p%Coefs arrays that contains f_st data (on cl or cn) for UA [-]
    INTEGER(IntKi)  :: AFTabMod = 0_IntKi      !< Interpolation method for multiple airfoil tables {1 = 1D on AoA (only first table is used); 2 = 2D on AoA and Re; 3 = 2D on AoA and UserProp} [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: secondVals      !< The values of the 2nd dependent variable when using multiple airfoil tables (Re or UserProp, saved in an array so that the logic in the interpolation scheme is cleaner) [-]
    INTEGER(IntKi)  :: InterpOrd = 0_IntKi      !< Interpolation order [-]
    REAL(ReKi)  :: RelThickness = 0.0_ReKi      !< Relative thickness of airfoil thickness/chord [-]
    REAL(ReKi)  :: NonDimArea = 0.0_ReKi      !< The non-dimensional area of the airfoil (area/chord^2) [unused] [-]
    INTEGER(IntKi)  :: NumCoords = 0_IntKi      !< The number of coordinates which define the airfoil shape [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: X_Coord      !< X-coordinate for the airfoil shape [unused] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Y_Coord      !< Y-coordinate for the airfoil shape [unused] [-]
    INTEGER(IntKi)  :: NumTabs = 0_IntKi      !< The number of airfoil tables in the airfoil file [-]
    TYPE(AFI_Table_Type) , DIMENSION(:), ALLOCATABLE  :: Table      !< The tables of airfoil data for given Re and control setting [-]
    CHARACTER(1024)  :: BL_file      !< The name of the file with the boundary layer data [-]
    CHARACTER(1024)  :: FileName      !< The name of the file that stored this information. [-]
  END TYPE AFI_ParameterType
! =======================
! =========  AFI_InputType  =======
  TYPE, PUBLIC :: AFI_InputType
    REAL(ReKi)  :: AoA = 0.0_ReKi      !< The angle of attack [radians]
    REAL(ReKi)  :: UserProp = 0.0_ReKi      !< The user-defined control setting [-]
    REAL(ReKi)  :: Re = 0.0_ReKi      !< Reynolds number [-]
  END TYPE AFI_InputType
! =======================
! =========  AFI_OutputType  =======
  TYPE, PUBLIC :: AFI_OutputType
    REAL(ReKi)  :: Cl = 0.      !< Dimensionless coefficient of lift [-]
    REAL(ReKi)  :: Cd = 0.      !< Dimensionless coefficient of drag [-]
    REAL(ReKi)  :: Cm = 0.      !< Dimensionless coefficient of pitching moment [-]
    REAL(ReKi)  :: Cpmin = 0.      !< Dimensionless coefficient of minimum pressure [-]
    REAL(ReKi)  :: Cd0 = 0.      !< Minimum Cd value (used for Beddoes-Leishman unsteady aero) [-]
    REAL(ReKi)  :: Cm0 = 0.      !< 2D pitching moment coefficient at zero lift, positive if nose is up [-]
    REAL(ReKi)  :: f_st = 0.      !< separation function based on cl or cn (used for UA models) [-]
    REAL(ReKi)  :: FullySeparate = 0.      !< fully separated cn or cl polar function (used for UA models) [-]
    REAL(ReKi)  :: FullyAttached = 0.      !< fully attached cn or cl polar function (used for UA models) [-]
  END TYPE AFI_OutputType
! =======================
CONTAINS

subroutine AFI_CopyUA_BL_Type(SrcUA_BL_TypeData, DstUA_BL_TypeData, CtrlCode, ErrStat, ErrMsg)
   type(AFI_UA_BL_Type), intent(in) :: SrcUA_BL_TypeData
   type(AFI_UA_BL_Type), intent(inout) :: DstUA_BL_TypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AFI_CopyUA_BL_Type'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstUA_BL_TypeData%alpha0 = SrcUA_BL_TypeData%alpha0
   DstUA_BL_TypeData%alpha1 = SrcUA_BL_TypeData%alpha1
   DstUA_BL_TypeData%alpha2 = SrcUA_BL_TypeData%alpha2
   DstUA_BL_TypeData%eta_e = SrcUA_BL_TypeData%eta_e
   DstUA_BL_TypeData%C_nalpha = SrcUA_BL_TypeData%C_nalpha
   DstUA_BL_TypeData%C_lalpha = SrcUA_BL_TypeData%C_lalpha
   DstUA_BL_TypeData%T_f0 = SrcUA_BL_TypeData%T_f0
   DstUA_BL_TypeData%T_V0 = SrcUA_BL_TypeData%T_V0
   DstUA_BL_TypeData%T_p = SrcUA_BL_TypeData%T_p
   DstUA_BL_TypeData%T_VL = SrcUA_BL_TypeData%T_VL
   DstUA_BL_TypeData%b1 = SrcUA_BL_TypeData%b1
   DstUA_BL_TypeData%b2 = SrcUA_BL_TypeData%b2
   DstUA_BL_TypeData%b5 = SrcUA_BL_TypeData%b5
   DstUA_BL_TypeData%A1 = SrcUA_BL_TypeData%A1
   DstUA_BL_TypeData%A2 = SrcUA_BL_TypeData%A2
   DstUA_BL_TypeData%A5 = SrcUA_BL_TypeData%A5
   DstUA_BL_TypeData%S1 = SrcUA_BL_TypeData%S1
   DstUA_BL_TypeData%S2 = SrcUA_BL_TypeData%S2
   DstUA_BL_TypeData%S3 = SrcUA_BL_TypeData%S3
   DstUA_BL_TypeData%S4 = SrcUA_BL_TypeData%S4
   DstUA_BL_TypeData%Cn1 = SrcUA_BL_TypeData%Cn1
   DstUA_BL_TypeData%Cn2 = SrcUA_BL_TypeData%Cn2
   DstUA_BL_TypeData%St_sh = SrcUA_BL_TypeData%St_sh
   DstUA_BL_TypeData%Cd0 = SrcUA_BL_TypeData%Cd0
   DstUA_BL_TypeData%Cm0 = SrcUA_BL_TypeData%Cm0
   DstUA_BL_TypeData%k0 = SrcUA_BL_TypeData%k0
   DstUA_BL_TypeData%k1 = SrcUA_BL_TypeData%k1
   DstUA_BL_TypeData%k2 = SrcUA_BL_TypeData%k2
   DstUA_BL_TypeData%k3 = SrcUA_BL_TypeData%k3
   DstUA_BL_TypeData%k1_hat = SrcUA_BL_TypeData%k1_hat
   DstUA_BL_TypeData%x_cp_bar = SrcUA_BL_TypeData%x_cp_bar
   DstUA_BL_TypeData%UACutout = SrcUA_BL_TypeData%UACutout
   DstUA_BL_TypeData%UACutout_delta = SrcUA_BL_TypeData%UACutout_delta
   DstUA_BL_TypeData%UACutout_blend = SrcUA_BL_TypeData%UACutout_blend
   DstUA_BL_TypeData%filtCutOff = SrcUA_BL_TypeData%filtCutOff
   DstUA_BL_TypeData%alphaUpper = SrcUA_BL_TypeData%alphaUpper
   DstUA_BL_TypeData%alphaLower = SrcUA_BL_TypeData%alphaLower
   DstUA_BL_TypeData%c_alphaLower = SrcUA_BL_TypeData%c_alphaLower
   DstUA_BL_TypeData%c_alphaUpper = SrcUA_BL_TypeData%c_alphaUpper
   DstUA_BL_TypeData%alpha0ReverseFlow = SrcUA_BL_TypeData%alpha0ReverseFlow
   DstUA_BL_TypeData%alphaBreakUpper = SrcUA_BL_TypeData%alphaBreakUpper
   DstUA_BL_TypeData%CnBreakUpper = SrcUA_BL_TypeData%CnBreakUpper
   DstUA_BL_TypeData%alphaBreakLower = SrcUA_BL_TypeData%alphaBreakLower
   DstUA_BL_TypeData%CnBreakLower = SrcUA_BL_TypeData%CnBreakLower
end subroutine

subroutine AFI_DestroyUA_BL_Type(UA_BL_TypeData, ErrStat, ErrMsg)
   type(AFI_UA_BL_Type), intent(inout) :: UA_BL_TypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AFI_DestroyUA_BL_Type'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AFI_PackUA_BL_Type(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AFI_UA_BL_Type), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AFI_PackUA_BL_Type'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%alpha0)
   call RegPack(RF, InData%alpha1)
   call RegPack(RF, InData%alpha2)
   call RegPack(RF, InData%eta_e)
   call RegPack(RF, InData%C_nalpha)
   call RegPack(RF, InData%C_lalpha)
   call RegPack(RF, InData%T_f0)
   call RegPack(RF, InData%T_V0)
   call RegPack(RF, InData%T_p)
   call RegPack(RF, InData%T_VL)
   call RegPack(RF, InData%b1)
   call RegPack(RF, InData%b2)
   call RegPack(RF, InData%b5)
   call RegPack(RF, InData%A1)
   call RegPack(RF, InData%A2)
   call RegPack(RF, InData%A5)
   call RegPack(RF, InData%S1)
   call RegPack(RF, InData%S2)
   call RegPack(RF, InData%S3)
   call RegPack(RF, InData%S4)
   call RegPack(RF, InData%Cn1)
   call RegPack(RF, InData%Cn2)
   call RegPack(RF, InData%St_sh)
   call RegPack(RF, InData%Cd0)
   call RegPack(RF, InData%Cm0)
   call RegPack(RF, InData%k0)
   call RegPack(RF, InData%k1)
   call RegPack(RF, InData%k2)
   call RegPack(RF, InData%k3)
   call RegPack(RF, InData%k1_hat)
   call RegPack(RF, InData%x_cp_bar)
   call RegPack(RF, InData%UACutout)
   call RegPack(RF, InData%UACutout_delta)
   call RegPack(RF, InData%UACutout_blend)
   call RegPack(RF, InData%filtCutOff)
   call RegPack(RF, InData%alphaUpper)
   call RegPack(RF, InData%alphaLower)
   call RegPack(RF, InData%c_alphaLower)
   call RegPack(RF, InData%c_alphaUpper)
   call RegPack(RF, InData%alpha0ReverseFlow)
   call RegPack(RF, InData%alphaBreakUpper)
   call RegPack(RF, InData%CnBreakUpper)
   call RegPack(RF, InData%alphaBreakLower)
   call RegPack(RF, InData%CnBreakLower)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AFI_UnPackUA_BL_Type(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AFI_UA_BL_Type), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AFI_UnPackUA_BL_Type'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%alpha0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alpha1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alpha2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%eta_e); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_nalpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_lalpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T_f0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T_V0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T_p); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T_VL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%b1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%b2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%b5); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%A1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%A2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%A5); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%S1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%S2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%S3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%S4); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cn1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cn2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%St_sh); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cd0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cm0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k1_hat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%x_cp_bar); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UACutout); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UACutout_delta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UACutout_blend); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%filtCutOff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alphaUpper); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alphaLower); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%c_alphaLower); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%c_alphaUpper); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alpha0ReverseFlow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alphaBreakUpper); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CnBreakUpper); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alphaBreakLower); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CnBreakLower); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AFI_CopyUA_BL_Default_Type(SrcUA_BL_Default_TypeData, DstUA_BL_Default_TypeData, CtrlCode, ErrStat, ErrMsg)
   type(AFI_UA_BL_Default_Type), intent(in) :: SrcUA_BL_Default_TypeData
   type(AFI_UA_BL_Default_Type), intent(inout) :: DstUA_BL_Default_TypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AFI_CopyUA_BL_Default_Type'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstUA_BL_Default_TypeData%alpha0 = SrcUA_BL_Default_TypeData%alpha0
   DstUA_BL_Default_TypeData%alpha1 = SrcUA_BL_Default_TypeData%alpha1
   DstUA_BL_Default_TypeData%alpha2 = SrcUA_BL_Default_TypeData%alpha2
   DstUA_BL_Default_TypeData%eta_e = SrcUA_BL_Default_TypeData%eta_e
   DstUA_BL_Default_TypeData%C_nalpha = SrcUA_BL_Default_TypeData%C_nalpha
   DstUA_BL_Default_TypeData%C_lalpha = SrcUA_BL_Default_TypeData%C_lalpha
   DstUA_BL_Default_TypeData%T_f0 = SrcUA_BL_Default_TypeData%T_f0
   DstUA_BL_Default_TypeData%T_V0 = SrcUA_BL_Default_TypeData%T_V0
   DstUA_BL_Default_TypeData%T_p = SrcUA_BL_Default_TypeData%T_p
   DstUA_BL_Default_TypeData%T_VL = SrcUA_BL_Default_TypeData%T_VL
   DstUA_BL_Default_TypeData%b1 = SrcUA_BL_Default_TypeData%b1
   DstUA_BL_Default_TypeData%b2 = SrcUA_BL_Default_TypeData%b2
   DstUA_BL_Default_TypeData%b5 = SrcUA_BL_Default_TypeData%b5
   DstUA_BL_Default_TypeData%A1 = SrcUA_BL_Default_TypeData%A1
   DstUA_BL_Default_TypeData%A2 = SrcUA_BL_Default_TypeData%A2
   DstUA_BL_Default_TypeData%A5 = SrcUA_BL_Default_TypeData%A5
   DstUA_BL_Default_TypeData%S1 = SrcUA_BL_Default_TypeData%S1
   DstUA_BL_Default_TypeData%S2 = SrcUA_BL_Default_TypeData%S2
   DstUA_BL_Default_TypeData%S3 = SrcUA_BL_Default_TypeData%S3
   DstUA_BL_Default_TypeData%S4 = SrcUA_BL_Default_TypeData%S4
   DstUA_BL_Default_TypeData%Cn1 = SrcUA_BL_Default_TypeData%Cn1
   DstUA_BL_Default_TypeData%Cn2 = SrcUA_BL_Default_TypeData%Cn2
   DstUA_BL_Default_TypeData%St_sh = SrcUA_BL_Default_TypeData%St_sh
   DstUA_BL_Default_TypeData%Cd0 = SrcUA_BL_Default_TypeData%Cd0
   DstUA_BL_Default_TypeData%Cm0 = SrcUA_BL_Default_TypeData%Cm0
   DstUA_BL_Default_TypeData%k0 = SrcUA_BL_Default_TypeData%k0
   DstUA_BL_Default_TypeData%k1 = SrcUA_BL_Default_TypeData%k1
   DstUA_BL_Default_TypeData%k2 = SrcUA_BL_Default_TypeData%k2
   DstUA_BL_Default_TypeData%k3 = SrcUA_BL_Default_TypeData%k3
   DstUA_BL_Default_TypeData%k1_hat = SrcUA_BL_Default_TypeData%k1_hat
   DstUA_BL_Default_TypeData%x_cp_bar = SrcUA_BL_Default_TypeData%x_cp_bar
   DstUA_BL_Default_TypeData%UACutout = SrcUA_BL_Default_TypeData%UACutout
   DstUA_BL_Default_TypeData%UACutout_delta = SrcUA_BL_Default_TypeData%UACutout_delta
   DstUA_BL_Default_TypeData%filtCutOff = SrcUA_BL_Default_TypeData%filtCutOff
   DstUA_BL_Default_TypeData%alphaUpper = SrcUA_BL_Default_TypeData%alphaUpper
   DstUA_BL_Default_TypeData%alphaLower = SrcUA_BL_Default_TypeData%alphaLower
end subroutine

subroutine AFI_DestroyUA_BL_Default_Type(UA_BL_Default_TypeData, ErrStat, ErrMsg)
   type(AFI_UA_BL_Default_Type), intent(inout) :: UA_BL_Default_TypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AFI_DestroyUA_BL_Default_Type'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AFI_PackUA_BL_Default_Type(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AFI_UA_BL_Default_Type), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AFI_PackUA_BL_Default_Type'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%alpha0)
   call RegPack(RF, InData%alpha1)
   call RegPack(RF, InData%alpha2)
   call RegPack(RF, InData%eta_e)
   call RegPack(RF, InData%C_nalpha)
   call RegPack(RF, InData%C_lalpha)
   call RegPack(RF, InData%T_f0)
   call RegPack(RF, InData%T_V0)
   call RegPack(RF, InData%T_p)
   call RegPack(RF, InData%T_VL)
   call RegPack(RF, InData%b1)
   call RegPack(RF, InData%b2)
   call RegPack(RF, InData%b5)
   call RegPack(RF, InData%A1)
   call RegPack(RF, InData%A2)
   call RegPack(RF, InData%A5)
   call RegPack(RF, InData%S1)
   call RegPack(RF, InData%S2)
   call RegPack(RF, InData%S3)
   call RegPack(RF, InData%S4)
   call RegPack(RF, InData%Cn1)
   call RegPack(RF, InData%Cn2)
   call RegPack(RF, InData%St_sh)
   call RegPack(RF, InData%Cd0)
   call RegPack(RF, InData%Cm0)
   call RegPack(RF, InData%k0)
   call RegPack(RF, InData%k1)
   call RegPack(RF, InData%k2)
   call RegPack(RF, InData%k3)
   call RegPack(RF, InData%k1_hat)
   call RegPack(RF, InData%x_cp_bar)
   call RegPack(RF, InData%UACutout)
   call RegPack(RF, InData%UACutout_delta)
   call RegPack(RF, InData%filtCutOff)
   call RegPack(RF, InData%alphaUpper)
   call RegPack(RF, InData%alphaLower)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AFI_UnPackUA_BL_Default_Type(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AFI_UA_BL_Default_Type), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AFI_UnPackUA_BL_Default_Type'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%alpha0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alpha1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alpha2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%eta_e); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_nalpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_lalpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T_f0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T_V0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T_p); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%T_VL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%b1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%b2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%b5); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%A1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%A2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%A5); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%S1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%S2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%S3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%S4); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cn1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cn2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%St_sh); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cd0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cm0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%k1_hat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%x_cp_bar); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UACutout); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UACutout_delta); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%filtCutOff); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alphaUpper); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%alphaLower); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AFI_CopyTable_Type(SrcTable_TypeData, DstTable_TypeData, CtrlCode, ErrStat, ErrMsg)
   type(AFI_Table_Type), intent(in) :: SrcTable_TypeData
   type(AFI_Table_Type), intent(inout) :: DstTable_TypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AFI_CopyTable_Type'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcTable_TypeData%Alpha)) then
      LB(1:1) = lbound(SrcTable_TypeData%Alpha)
      UB(1:1) = ubound(SrcTable_TypeData%Alpha)
      if (.not. allocated(DstTable_TypeData%Alpha)) then
         allocate(DstTable_TypeData%Alpha(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstTable_TypeData%Alpha.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstTable_TypeData%Alpha = SrcTable_TypeData%Alpha
   end if
   if (allocated(SrcTable_TypeData%Coefs)) then
      LB(1:2) = lbound(SrcTable_TypeData%Coefs)
      UB(1:2) = ubound(SrcTable_TypeData%Coefs)
      if (.not. allocated(DstTable_TypeData%Coefs)) then
         allocate(DstTable_TypeData%Coefs(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstTable_TypeData%Coefs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstTable_TypeData%Coefs = SrcTable_TypeData%Coefs
   end if
   if (allocated(SrcTable_TypeData%SplineCoefs)) then
      LB(1:3) = lbound(SrcTable_TypeData%SplineCoefs)
      UB(1:3) = ubound(SrcTable_TypeData%SplineCoefs)
      if (.not. allocated(DstTable_TypeData%SplineCoefs)) then
         allocate(DstTable_TypeData%SplineCoefs(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstTable_TypeData%SplineCoefs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstTable_TypeData%SplineCoefs = SrcTable_TypeData%SplineCoefs
   end if
   DstTable_TypeData%UserProp = SrcTable_TypeData%UserProp
   DstTable_TypeData%Re = SrcTable_TypeData%Re
   DstTable_TypeData%NumAlf = SrcTable_TypeData%NumAlf
   DstTable_TypeData%ConstData = SrcTable_TypeData%ConstData
   DstTable_TypeData%InclUAdata = SrcTable_TypeData%InclUAdata
   call AFI_CopyUA_BL_Type(SrcTable_TypeData%UA_BL, DstTable_TypeData%UA_BL, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine AFI_DestroyTable_Type(Table_TypeData, ErrStat, ErrMsg)
   type(AFI_Table_Type), intent(inout) :: Table_TypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AFI_DestroyTable_Type'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(Table_TypeData%Alpha)) then
      deallocate(Table_TypeData%Alpha)
   end if
   if (allocated(Table_TypeData%Coefs)) then
      deallocate(Table_TypeData%Coefs)
   end if
   if (allocated(Table_TypeData%SplineCoefs)) then
      deallocate(Table_TypeData%SplineCoefs)
   end if
   call AFI_DestroyUA_BL_Type(Table_TypeData%UA_BL, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AFI_PackTable_Type(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AFI_Table_Type), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AFI_PackTable_Type'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%Alpha)
   call RegPackAlloc(RF, InData%Coefs)
   call RegPackAlloc(RF, InData%SplineCoefs)
   call RegPack(RF, InData%UserProp)
   call RegPack(RF, InData%Re)
   call RegPack(RF, InData%NumAlf)
   call RegPack(RF, InData%ConstData)
   call RegPack(RF, InData%InclUAdata)
   call AFI_PackUA_BL_Type(RF, InData%UA_BL) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AFI_UnPackTable_Type(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AFI_Table_Type), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AFI_UnPackTable_Type'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%Alpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Coefs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SplineCoefs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UserProp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Re); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumAlf); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ConstData); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InclUAdata); if (RegCheckErr(RF, RoutineName)) return
   call AFI_UnpackUA_BL_Type(RF, OutData%UA_BL) ! UA_BL 
end subroutine

subroutine AFI_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(AFI_InitInputType), intent(in) :: SrcInitInputData
   type(AFI_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AFI_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%FileName = SrcInitInputData%FileName
   DstInitInputData%AFTabMod = SrcInitInputData%AFTabMod
   DstInitInputData%InCol_Alfa = SrcInitInputData%InCol_Alfa
   DstInitInputData%InCol_Cl = SrcInitInputData%InCol_Cl
   DstInitInputData%InCol_Cd = SrcInitInputData%InCol_Cd
   DstInitInputData%InCol_Cm = SrcInitInputData%InCol_Cm
   DstInitInputData%InCol_Cpmin = SrcInitInputData%InCol_Cpmin
   DstInitInputData%UAMod = SrcInitInputData%UAMod
end subroutine

subroutine AFI_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(AFI_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AFI_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AFI_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AFI_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AFI_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%FileName)
   call RegPack(RF, InData%AFTabMod)
   call RegPack(RF, InData%InCol_Alfa)
   call RegPack(RF, InData%InCol_Cl)
   call RegPack(RF, InData%InCol_Cd)
   call RegPack(RF, InData%InCol_Cm)
   call RegPack(RF, InData%InCol_Cpmin)
   call RegPack(RF, InData%UAMod)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AFI_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AFI_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AFI_UnPackInitInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%FileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AFTabMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InCol_Alfa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InCol_Cl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InCol_Cd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InCol_Cm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InCol_Cpmin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UAMod); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AFI_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(AFI_InitOutputType), intent(in) :: SrcInitOutputData
   type(AFI_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AFI_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine AFI_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(AFI_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AFI_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AFI_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AFI_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AFI_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AFI_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AFI_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AFI_UnPackInitOutput'
   if (RF%ErrStat /= ErrID_None) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
end subroutine

subroutine AFI_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(AFI_ParameterType), intent(in) :: SrcParamData
   type(AFI_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AFI_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%ColCd = SrcParamData%ColCd
   DstParamData%ColCl = SrcParamData%ColCl
   DstParamData%ColCm = SrcParamData%ColCm
   DstParamData%ColCpmin = SrcParamData%ColCpmin
   DstParamData%ColUAf = SrcParamData%ColUAf
   DstParamData%AFTabMod = SrcParamData%AFTabMod
   if (allocated(SrcParamData%secondVals)) then
      LB(1:1) = lbound(SrcParamData%secondVals)
      UB(1:1) = ubound(SrcParamData%secondVals)
      if (.not. allocated(DstParamData%secondVals)) then
         allocate(DstParamData%secondVals(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%secondVals.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%secondVals = SrcParamData%secondVals
   end if
   DstParamData%InterpOrd = SrcParamData%InterpOrd
   DstParamData%RelThickness = SrcParamData%RelThickness
   DstParamData%NonDimArea = SrcParamData%NonDimArea
   DstParamData%NumCoords = SrcParamData%NumCoords
   if (allocated(SrcParamData%X_Coord)) then
      LB(1:1) = lbound(SrcParamData%X_Coord)
      UB(1:1) = ubound(SrcParamData%X_Coord)
      if (.not. allocated(DstParamData%X_Coord)) then
         allocate(DstParamData%X_Coord(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%X_Coord.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%X_Coord = SrcParamData%X_Coord
   end if
   if (allocated(SrcParamData%Y_Coord)) then
      LB(1:1) = lbound(SrcParamData%Y_Coord)
      UB(1:1) = ubound(SrcParamData%Y_Coord)
      if (.not. allocated(DstParamData%Y_Coord)) then
         allocate(DstParamData%Y_Coord(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Y_Coord.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Y_Coord = SrcParamData%Y_Coord
   end if
   DstParamData%NumTabs = SrcParamData%NumTabs
   if (allocated(SrcParamData%Table)) then
      LB(1:1) = lbound(SrcParamData%Table)
      UB(1:1) = ubound(SrcParamData%Table)
      if (.not. allocated(DstParamData%Table)) then
         allocate(DstParamData%Table(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Table.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AFI_CopyTable_Type(SrcParamData%Table(i1), DstParamData%Table(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%BL_file = SrcParamData%BL_file
   DstParamData%FileName = SrcParamData%FileName
end subroutine

subroutine AFI_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(AFI_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AFI_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%secondVals)) then
      deallocate(ParamData%secondVals)
   end if
   if (allocated(ParamData%X_Coord)) then
      deallocate(ParamData%X_Coord)
   end if
   if (allocated(ParamData%Y_Coord)) then
      deallocate(ParamData%Y_Coord)
   end if
   if (allocated(ParamData%Table)) then
      LB(1:1) = lbound(ParamData%Table)
      UB(1:1) = ubound(ParamData%Table)
      do i1 = LB(1), UB(1)
         call AFI_DestroyTable_Type(ParamData%Table(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%Table)
   end if
end subroutine

subroutine AFI_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AFI_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AFI_PackParam'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%ColCd)
   call RegPack(RF, InData%ColCl)
   call RegPack(RF, InData%ColCm)
   call RegPack(RF, InData%ColCpmin)
   call RegPack(RF, InData%ColUAf)
   call RegPack(RF, InData%AFTabMod)
   call RegPackAlloc(RF, InData%secondVals)
   call RegPack(RF, InData%InterpOrd)
   call RegPack(RF, InData%RelThickness)
   call RegPack(RF, InData%NonDimArea)
   call RegPack(RF, InData%NumCoords)
   call RegPackAlloc(RF, InData%X_Coord)
   call RegPackAlloc(RF, InData%Y_Coord)
   call RegPack(RF, InData%NumTabs)
   call RegPack(RF, allocated(InData%Table))
   if (allocated(InData%Table)) then
      call RegPackBounds(RF, 1, lbound(InData%Table), ubound(InData%Table))
      LB(1:1) = lbound(InData%Table)
      UB(1:1) = ubound(InData%Table)
      do i1 = LB(1), UB(1)
         call AFI_PackTable_Type(RF, InData%Table(i1)) 
      end do
   end if
   call RegPack(RF, InData%BL_file)
   call RegPack(RF, InData%FileName)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AFI_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AFI_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AFI_UnPackParam'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%ColCd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ColCl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ColCm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ColCpmin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ColUAf); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AFTabMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%secondVals); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InterpOrd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RelThickness); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NonDimArea); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumCoords); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%X_Coord); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Y_Coord); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumTabs); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%Table)) deallocate(OutData%Table)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Table(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Table.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AFI_UnpackTable_Type(RF, OutData%Table(i1)) ! Table 
      end do
   end if
   call RegUnpack(RF, OutData%BL_file); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FileName); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AFI_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(AFI_InputType), intent(in) :: SrcInputData
   type(AFI_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AFI_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputData%AoA = SrcInputData%AoA
   DstInputData%UserProp = SrcInputData%UserProp
   DstInputData%Re = SrcInputData%Re
end subroutine

subroutine AFI_DestroyInput(InputData, ErrStat, ErrMsg)
   type(AFI_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AFI_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AFI_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AFI_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AFI_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%AoA)
   call RegPack(RF, InData%UserProp)
   call RegPack(RF, InData%Re)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AFI_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AFI_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AFI_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%AoA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UserProp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Re); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AFI_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(AFI_OutputType), intent(in) :: SrcOutputData
   type(AFI_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AFI_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOutputData%Cl = SrcOutputData%Cl
   DstOutputData%Cd = SrcOutputData%Cd
   DstOutputData%Cm = SrcOutputData%Cm
   DstOutputData%Cpmin = SrcOutputData%Cpmin
   DstOutputData%Cd0 = SrcOutputData%Cd0
   DstOutputData%Cm0 = SrcOutputData%Cm0
   DstOutputData%f_st = SrcOutputData%f_st
   DstOutputData%FullySeparate = SrcOutputData%FullySeparate
   DstOutputData%FullyAttached = SrcOutputData%FullyAttached
end subroutine

subroutine AFI_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(AFI_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AFI_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AFI_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AFI_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AFI_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Cl)
   call RegPack(RF, InData%Cd)
   call RegPack(RF, InData%Cm)
   call RegPack(RF, InData%Cpmin)
   call RegPack(RF, InData%Cd0)
   call RegPack(RF, InData%Cm0)
   call RegPack(RF, InData%f_st)
   call RegPack(RF, InData%FullySeparate)
   call RegPack(RF, InData%FullyAttached)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AFI_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AFI_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AFI_UnPackOutput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Cl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cpmin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cd0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cm0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%f_st); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FullySeparate); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FullyAttached); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AFI_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(AFI_OutputType), intent(in)  :: y(:) ! Output at t1 > t2 > t3
   real(ReKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(AFI_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(ReKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'AFI_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call AFI_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call AFI_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call AFI_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE AFI_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(AFI_OutputType), INTENT(IN)  :: y1    ! Output at t1 > t2
   TYPE(AFI_OutputType), INTENT(IN)  :: y2    ! Output at t2 
   REAL(ReKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(AFI_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(ReKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(ReKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(ReKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'AFI_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   y_out%Cl = a1*y1%Cl + a2*y2%Cl
   y_out%Cd = a1*y1%Cd + a2*y2%Cd
   y_out%Cm = a1*y1%Cm + a2*y2%Cm
   y_out%Cpmin = a1*y1%Cpmin + a2*y2%Cpmin
   y_out%Cd0 = a1*y1%Cd0 + a2*y2%Cd0
   y_out%Cm0 = a1*y1%Cm0 + a2*y2%Cm0
   y_out%f_st = a1*y1%f_st + a2*y2%f_st
   y_out%FullySeparate = a1*y1%FullySeparate + a2*y2%FullySeparate
   y_out%FullyAttached = a1*y1%FullyAttached + a2*y2%FullyAttached
END SUBROUTINE

SUBROUTINE AFI_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(AFI_OutputType), INTENT(IN)  :: y1      ! Output at t1 > t2 > t3
   TYPE(AFI_OutputType), INTENT(IN)  :: y2      ! Output at t2 > t3
   TYPE(AFI_OutputType), INTENT(IN)  :: y3      ! Output at t3
   REAL(ReKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(AFI_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(ReKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(ReKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(ReKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'AFI_Output_ExtrapInterp2'
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   y_out%Cl = a1*y1%Cl + a2*y2%Cl + a3*y3%Cl
   y_out%Cd = a1*y1%Cd + a2*y2%Cd + a3*y3%Cd
   y_out%Cm = a1*y1%Cm + a2*y2%Cm + a3*y3%Cm
   y_out%Cpmin = a1*y1%Cpmin + a2*y2%Cpmin + a3*y3%Cpmin
   y_out%Cd0 = a1*y1%Cd0 + a2*y2%Cd0 + a3*y3%Cd0
   y_out%Cm0 = a1*y1%Cm0 + a2*y2%Cm0 + a3*y3%Cm0
   y_out%f_st = a1*y1%f_st + a2*y2%f_st + a3*y3%f_st
   y_out%FullySeparate = a1*y1%FullySeparate + a2*y2%FullySeparate + a3*y3%FullySeparate
   y_out%FullyAttached = a1*y1%FullyAttached + a2*y2%FullyAttached + a3*y3%FullyAttached
END SUBROUTINE

subroutine AFI_UA_BL_Type_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) UA_BL_Type u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(AFI_UA_BL_Type), intent(in)  :: u(:) ! UA_BL_Type at t1 > t2 > t3
   real(ReKi),                 intent(in   )  :: t(:)           ! Times associated with the UA_BL_Types
   type(AFI_UA_BL_Type), intent(inout)  :: u_out ! UA_BL_Type at tin_out
   real(ReKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'AFI_UA_BL_Type_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call AFI_CopyUA_BL_Type(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call AFI_UA_BL_Type_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call AFI_UA_BL_Type_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE AFI_UA_BL_Type_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) UA_BL_Type u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(AFI_UA_BL_Type), INTENT(IN)  :: u1    ! UA_BL_Type at t1 > t2
   TYPE(AFI_UA_BL_Type), INTENT(IN)  :: u2    ! UA_BL_Type at t2 
   REAL(ReKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the UA_BL_Types
   TYPE(AFI_UA_BL_Type), INTENT(INOUT)  :: u_out ! UA_BL_Type at tin_out
   REAL(ReKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(ReKi)                                 :: t(2)     ! Times associated with the UA_BL_Types
   REAL(ReKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'AFI_UA_BL_Type_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL Angles_ExtrapInterp( u1%alpha0, u2%alpha0, tin, u_out%alpha0, tin_out )
   CALL Angles_ExtrapInterp( u1%alpha1, u2%alpha1, tin, u_out%alpha1, tin_out )
   CALL Angles_ExtrapInterp( u1%alpha2, u2%alpha2, tin, u_out%alpha2, tin_out )
   u_out%eta_e = a1*u1%eta_e + a2*u2%eta_e
   u_out%C_nalpha = a1*u1%C_nalpha + a2*u2%C_nalpha
   u_out%C_lalpha = a1*u1%C_lalpha + a2*u2%C_lalpha
   u_out%T_f0 = a1*u1%T_f0 + a2*u2%T_f0
   u_out%T_V0 = a1*u1%T_V0 + a2*u2%T_V0
   u_out%T_p = a1*u1%T_p + a2*u2%T_p
   u_out%T_VL = a1*u1%T_VL + a2*u2%T_VL
   u_out%b1 = a1*u1%b1 + a2*u2%b1
   u_out%b2 = a1*u1%b2 + a2*u2%b2
   u_out%b5 = a1*u1%b5 + a2*u2%b5
   u_out%A1 = a1*u1%A1 + a2*u2%A1
   u_out%A2 = a1*u1%A2 + a2*u2%A2
   u_out%A5 = a1*u1%A5 + a2*u2%A5
   u_out%S1 = a1*u1%S1 + a2*u2%S1
   u_out%S2 = a1*u1%S2 + a2*u2%S2
   u_out%S3 = a1*u1%S3 + a2*u2%S3
   u_out%S4 = a1*u1%S4 + a2*u2%S4
   u_out%Cn1 = a1*u1%Cn1 + a2*u2%Cn1
   u_out%Cn2 = a1*u1%Cn2 + a2*u2%Cn2
   u_out%St_sh = a1*u1%St_sh + a2*u2%St_sh
   u_out%Cd0 = a1*u1%Cd0 + a2*u2%Cd0
   u_out%Cm0 = a1*u1%Cm0 + a2*u2%Cm0
   u_out%k0 = a1*u1%k0 + a2*u2%k0
   u_out%k1 = a1*u1%k1 + a2*u2%k1
   u_out%k2 = a1*u1%k2 + a2*u2%k2
   u_out%k3 = a1*u1%k3 + a2*u2%k3
   u_out%k1_hat = a1*u1%k1_hat + a2*u2%k1_hat
   u_out%x_cp_bar = a1*u1%x_cp_bar + a2*u2%x_cp_bar
   u_out%UACutout = a1*u1%UACutout + a2*u2%UACutout
   u_out%UACutout_delta = a1*u1%UACutout_delta + a2*u2%UACutout_delta
   u_out%UACutout_blend = a1*u1%UACutout_blend + a2*u2%UACutout_blend
   u_out%filtCutOff = a1*u1%filtCutOff + a2*u2%filtCutOff
   CALL Angles_ExtrapInterp( u1%alphaUpper, u2%alphaUpper, tin, u_out%alphaUpper, tin_out )
   CALL Angles_ExtrapInterp( u1%alphaLower, u2%alphaLower, tin, u_out%alphaLower, tin_out )
   u_out%c_alphaLower = a1*u1%c_alphaLower + a2*u2%c_alphaLower
   u_out%c_alphaUpper = a1*u1%c_alphaUpper + a2*u2%c_alphaUpper
   CALL Angles_ExtrapInterp( u1%alpha0ReverseFlow, u2%alpha0ReverseFlow, tin, u_out%alpha0ReverseFlow, tin_out )
   CALL Angles_ExtrapInterp( u1%alphaBreakUpper, u2%alphaBreakUpper, tin, u_out%alphaBreakUpper, tin_out )
   u_out%CnBreakUpper = a1*u1%CnBreakUpper + a2*u2%CnBreakUpper
   CALL Angles_ExtrapInterp( u1%alphaBreakLower, u2%alphaBreakLower, tin, u_out%alphaBreakLower, tin_out )
   u_out%CnBreakLower = a1*u1%CnBreakLower + a2*u2%CnBreakLower
END SUBROUTINE

SUBROUTINE AFI_UA_BL_Type_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) UA_BL_Type u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(AFI_UA_BL_Type), INTENT(IN)  :: u1      ! UA_BL_Type at t1 > t2 > t3
   TYPE(AFI_UA_BL_Type), INTENT(IN)  :: u2      ! UA_BL_Type at t2 > t3
   TYPE(AFI_UA_BL_Type), INTENT(IN)  :: u3      ! UA_BL_Type at t3
   REAL(ReKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the UA_BL_Types
   TYPE(AFI_UA_BL_Type), INTENT(INOUT)  :: u_out     ! UA_BL_Type at tin_out
   REAL(ReKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(ReKi)                                 :: t(3)      ! Times associated with the UA_BL_Types
   REAL(ReKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'AFI_UA_BL_Type_ExtrapInterp2'
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL Angles_ExtrapInterp( u1%alpha0, u2%alpha0, u3%alpha0, tin, u_out%alpha0, tin_out )
   CALL Angles_ExtrapInterp( u1%alpha1, u2%alpha1, u3%alpha1, tin, u_out%alpha1, tin_out )
   CALL Angles_ExtrapInterp( u1%alpha2, u2%alpha2, u3%alpha2, tin, u_out%alpha2, tin_out )
   u_out%eta_e = a1*u1%eta_e + a2*u2%eta_e + a3*u3%eta_e
   u_out%C_nalpha = a1*u1%C_nalpha + a2*u2%C_nalpha + a3*u3%C_nalpha
   u_out%C_lalpha = a1*u1%C_lalpha + a2*u2%C_lalpha + a3*u3%C_lalpha
   u_out%T_f0 = a1*u1%T_f0 + a2*u2%T_f0 + a3*u3%T_f0
   u_out%T_V0 = a1*u1%T_V0 + a2*u2%T_V0 + a3*u3%T_V0
   u_out%T_p = a1*u1%T_p + a2*u2%T_p + a3*u3%T_p
   u_out%T_VL = a1*u1%T_VL + a2*u2%T_VL + a3*u3%T_VL
   u_out%b1 = a1*u1%b1 + a2*u2%b1 + a3*u3%b1
   u_out%b2 = a1*u1%b2 + a2*u2%b2 + a3*u3%b2
   u_out%b5 = a1*u1%b5 + a2*u2%b5 + a3*u3%b5
   u_out%A1 = a1*u1%A1 + a2*u2%A1 + a3*u3%A1
   u_out%A2 = a1*u1%A2 + a2*u2%A2 + a3*u3%A2
   u_out%A5 = a1*u1%A5 + a2*u2%A5 + a3*u3%A5
   u_out%S1 = a1*u1%S1 + a2*u2%S1 + a3*u3%S1
   u_out%S2 = a1*u1%S2 + a2*u2%S2 + a3*u3%S2
   u_out%S3 = a1*u1%S3 + a2*u2%S3 + a3*u3%S3
   u_out%S4 = a1*u1%S4 + a2*u2%S4 + a3*u3%S4
   u_out%Cn1 = a1*u1%Cn1 + a2*u2%Cn1 + a3*u3%Cn1
   u_out%Cn2 = a1*u1%Cn2 + a2*u2%Cn2 + a3*u3%Cn2
   u_out%St_sh = a1*u1%St_sh + a2*u2%St_sh + a3*u3%St_sh
   u_out%Cd0 = a1*u1%Cd0 + a2*u2%Cd0 + a3*u3%Cd0
   u_out%Cm0 = a1*u1%Cm0 + a2*u2%Cm0 + a3*u3%Cm0
   u_out%k0 = a1*u1%k0 + a2*u2%k0 + a3*u3%k0
   u_out%k1 = a1*u1%k1 + a2*u2%k1 + a3*u3%k1
   u_out%k2 = a1*u1%k2 + a2*u2%k2 + a3*u3%k2
   u_out%k3 = a1*u1%k3 + a2*u2%k3 + a3*u3%k3
   u_out%k1_hat = a1*u1%k1_hat + a2*u2%k1_hat + a3*u3%k1_hat
   u_out%x_cp_bar = a1*u1%x_cp_bar + a2*u2%x_cp_bar + a3*u3%x_cp_bar
   u_out%UACutout = a1*u1%UACutout + a2*u2%UACutout + a3*u3%UACutout
   u_out%UACutout_delta = a1*u1%UACutout_delta + a2*u2%UACutout_delta + a3*u3%UACutout_delta
   u_out%UACutout_blend = a1*u1%UACutout_blend + a2*u2%UACutout_blend + a3*u3%UACutout_blend
   u_out%filtCutOff = a1*u1%filtCutOff + a2*u2%filtCutOff + a3*u3%filtCutOff
   CALL Angles_ExtrapInterp( u1%alphaUpper, u2%alphaUpper, u3%alphaUpper, tin, u_out%alphaUpper, tin_out )
   CALL Angles_ExtrapInterp( u1%alphaLower, u2%alphaLower, u3%alphaLower, tin, u_out%alphaLower, tin_out )
   u_out%c_alphaLower = a1*u1%c_alphaLower + a2*u2%c_alphaLower + a3*u3%c_alphaLower
   u_out%c_alphaUpper = a1*u1%c_alphaUpper + a2*u2%c_alphaUpper + a3*u3%c_alphaUpper
   CALL Angles_ExtrapInterp( u1%alpha0ReverseFlow, u2%alpha0ReverseFlow, u3%alpha0ReverseFlow, tin, u_out%alpha0ReverseFlow, tin_out )
   CALL Angles_ExtrapInterp( u1%alphaBreakUpper, u2%alphaBreakUpper, u3%alphaBreakUpper, tin, u_out%alphaBreakUpper, tin_out )
   u_out%CnBreakUpper = a1*u1%CnBreakUpper + a2*u2%CnBreakUpper + a3*u3%CnBreakUpper
   CALL Angles_ExtrapInterp( u1%alphaBreakLower, u2%alphaBreakLower, u3%alphaBreakLower, tin, u_out%alphaBreakLower, tin_out )
   u_out%CnBreakLower = a1*u1%CnBreakLower + a2*u2%CnBreakLower + a3*u3%CnBreakLower
END SUBROUTINE
END MODULE AirfoilInfo_Types
!ENDOFREGISTRYGENERATEDFILE
