!STARTOFREGISTRYGENERATEDFILE 'AeroDyn_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! AeroDyn_Types
!.................................................................................................................................
! This file is part of AeroDyn.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in AeroDyn. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE AeroDyn_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE AirfoilInfo_Types
USE BEMT_Types
USE FVW_Types
USE AeroAcoustics_Types
USE InflowWind_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: ModelUnknown = -1      !  [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WakeMod_none = 0      ! Wake model - none [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WakeMod_BEMT = 1      ! Wake model - BEMT (blade elememnt momentum theory) [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: WakeMod_FVW = 3      ! Wake model - FVW (free vortex wake, OLAF) [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TwrPotent_none = 0      ! no tower potential flow [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TwrPotent_baseline = 1      ! baseline tower potential flow [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TwrPotent_Bak = 2      ! tower potential flow with Bak correction [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TwrShadow_none = 0      ! no tower shadow [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TwrShadow_Powles = 1      ! Powles tower shadow model [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TwrShadow_Eames = 2      ! Eames tower shadow model [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TwrAero_none = 0      ! no tower aero [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TwrAero_noVIV = 1      ! Tower aero model without VIV [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TwrAero_VIV = 2      ! Tower aero model with VIV [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: SA_Wgt_Uniform = 1      ! Sector average weighting - Uniform [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TFinAero_none = 0      ! no tail fin aero [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TFinAero_polar = 1      ! polar-based tail fin aerodynamics [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TFinAero_USB = 2      ! unsteady slender body tail fin aerodynamics model [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TFinIndMod_none = 0      ! no induction [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: TFinIndMod_rotavg = 1      ! rotor averaged induction [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: APM_BEM_NoSweepPitchTwist = 1      ! Original AeroDyn model where momentum balance is done in the WithoutSweepPitchTwist system [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: APM_BEM_Polar = 2      ! Use staggered polar grid for momentum balance in each annulus [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: APM_LiftingLine = 3      ! Use the blade lifting line (i.e. the structural) orientation (currently for OLAF with VAWT) [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: AD_MaxBl_Out = 3      ! Maximum number of blades for information output (or linearization) [-]
! =========  TFinParameterType  =======
  TYPE, PUBLIC :: TFinParameterType
    INTEGER(IntKi)  :: TFinMod = 0_IntKi      !< Tail fin aerodynamics model {0=none, 1=polar-based, 2=USB-based} [(switch)]
    REAL(ReKi)  :: TFinArea = 0.0_ReKi      !< Tail fin planform area [m^2]
    INTEGER(IntKi)  :: TFinIndMod = 0_IntKi      !< Model for induced velocity calculation {0=none, 1=rotor-average} [(switch)]
    INTEGER(IntKi)  :: TFinAFID = 0_IntKi      !< Index of Tail fin airfoil number [1 to NumAFfiles] [-]
    REAL(ReKi)  :: TFinChord = 0.0_ReKi      !< Tail fin chord [m]
    REAL(ReKi)  :: TFinKp = 0.0_ReKi      !< Tail fin potential flow coefficient for unsteady aerodynamics [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TFinSigma = 0.0_ReKi      !< Tail fin empirical constants characterizing the decay of separation functions [1/deg]
    REAL(ReKi) , DIMENSION(1:3)  :: TFinAStar = 0.0_ReKi      !< Tail fin characteristics angles for separation functions [deg]
    REAL(ReKi)  :: TFinKv = 0.0_ReKi      !< Tail fin vortex lift coefficient for unsteady aerodynamics [-]
    REAL(ReKi)  :: TFinCDc = 0.0_ReKi      !< Tail fin drag coefficient for unsteady aerodynamics [-]
  END TYPE TFinParameterType
! =======================
! =========  TFinInputFileType  =======
  TYPE, PUBLIC :: TFinInputFileType
    INTEGER(IntKi)  :: TFinMod = 0_IntKi      !< Tail fin aerodynamics model {0=none, 1=polar-based, 2=USB-based} [(switch)]
    REAL(ReKi)  :: TFinArea = 0.0_ReKi      !< Tail fin planform area [m^2]
    REAL(ReKi) , DIMENSION(1:3)  :: TFinRefP_n = 0.0_ReKi      !< Undeflected position of the tail fin reference point wrt the tower top [m]
    REAL(ReKi) , DIMENSION(1:3)  :: TFinAngles = 0.0_ReKi      !< Tail fin chordline skew, tilt, and bank angles about the reference point [(deg)]
    INTEGER(IntKi)  :: TFinIndMod = 0_IntKi      !< Model for induced velocity calculation {0=none, 1=rotor-average} [(switch)]
    INTEGER(IntKi)  :: TFinAFID = 0_IntKi      !< Index of Tail fin airfoil number [1 to NumAFfiles] [-]
    REAL(ReKi)  :: TFinChord = 0.0_ReKi      !< Tail fin chord [m]
    REAL(ReKi)  :: TFinKp = 0.0_ReKi      !< Tail fin potential flow coefficient for unsteady aerodynamics [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TFinSigma = 0.0_ReKi      !< Tail fin empirical constants characterizing the decay of separation functions [1/deg]
    REAL(ReKi) , DIMENSION(1:3)  :: TFinAStar = 0.0_ReKi      !< Tail fin characteristics angles for separation functions [deg]
    REAL(ReKi)  :: TFinKv = 0.0_ReKi      !< Tail fin vortex lift coefficient for unsteady aerodynamics [-]
    REAL(ReKi)  :: TFinCDc = 0.0_ReKi      !< Tail fin drag coefficient for unsteady aerodynamics [-]
  END TYPE TFinInputFileType
! =======================
! =========  AD_VTK_BLSurfaceType  =======
  TYPE, PUBLIC :: AD_VTK_BLSurfaceType
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AirfoilCoords      !< x,y coordinates for airfoil around each blade node on a blade (relative to reference) [-]
  END TYPE AD_VTK_BLSurfaceType
! =======================
! =========  AD_VTK_RotSurfaceType  =======
  TYPE, PUBLIC :: AD_VTK_RotSurfaceType
    TYPE(AD_VTK_BLSurfaceType) , DIMENSION(:), ALLOCATABLE  :: BladeShape      !< AirfoilCoords for each blade [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: TowerRad      !< radius of each ED tower node [m]
  END TYPE AD_VTK_RotSurfaceType
! =======================
! =========  RotInitInputType  =======
  TYPE, PUBLIC :: RotInitInputType
    INTEGER(IntKi)  :: NumBlades = 0_IntKi      !< Number of blades on the turbine [-]
    REAL(ReKi) , DIMENSION(1:3)  :: originInit = 0.0_ReKi      !< X-Y-Z reference position for the turbine [m]
    REAL(ReKi) , DIMENSION(1:3)  :: HubPosition = 0.0_ReKi      !< X-Y-Z reference position of hub [m]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: HubOrientation = 0.0_R8Ki      !< DCM reference orientation of hub [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BladeRootPosition      !< X-Y-Z reference position of each blade root (3 x NumBlades) [m]
    REAL(R8Ki) , DIMENSION(:,:,:), ALLOCATABLE  :: BladeRootOrientation      !< DCM reference orientation of blade roots (3x3 x NumBlades) [-]
    REAL(R8Ki) , DIMENSION(1:3)  :: NacellePosition = 0.0_R8Ki      !< X-Y-Z reference position of nacelle [m]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: NacelleOrientation = 0.0_R8Ki      !< DCM reference orientation of nacelle [-]
    INTEGER(IntKi)  :: AeroProjMod = 1      !< Flag to switch between different projection models [-]
    REAL(ReKi)  :: RotSpeed = 0.0_ReKi      !< Rotor speed used when AeroDyn is computing aero maps [rad/s]
  END TYPE RotInitInputType
! =======================
! =========  AD_InitInputType  =======
  TYPE, PUBLIC :: AD_InitInputType
    TYPE(RotInitInputType) , DIMENSION(:), ALLOCATABLE  :: rotors      !< Init Input Types for rotors [-]
    CHARACTER(1024)  :: InputFile      !< Name of the input file [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    LOGICAL  :: UsePrimaryInputFile = .TRUE.      !< Read input file instead of passed data [-]
    TYPE(FileInfoType)  :: PassedPrimaryInputData      !< Primary input file as FileInfoType (set by driver/glue code) [-]
    LOGICAL  :: Linearize = .FALSE.      !< Flag that tells this module if the glue code wants to linearize. [-]
    LOGICAL  :: CompAeroMaps = .FALSE.      !< flag to determine if AeroDyn is computing aero maps (true) or running a normal simulation (false) [-]
    REAL(ReKi)  :: Gravity = 0.0_ReKi      !< Gravity force [Nm/s^2]
    INTEGER(IntKi)  :: MHK = 0_IntKi      !< MHK turbine type switch [-]
    REAL(ReKi)  :: defFldDens = 0.0_ReKi      !< Default fluid density from the driver; may be overwritten [kg/m^3]
    REAL(ReKi)  :: defKinVisc = 0.0_ReKi      !< Default kinematic viscosity from the driver; may be overwritten [m^2/s]
    REAL(ReKi)  :: defSpdSound = 0.0_ReKi      !< Default speed of sound from the driver; may be overwritten [m/s]
    REAL(ReKi)  :: defPatm = 0.0_ReKi      !< Default atmospheric pressure from the driver; may be overwritten [Pa]
    REAL(ReKi)  :: defPvap = 0.0_ReKi      !< Default vapor pressure from the driver; may be overwritten [Pa]
    REAL(ReKi)  :: WtrDpth = 0.0_ReKi      !< Water depth [m]
    REAL(ReKi)  :: MSL2SWL = 0.0_ReKi      !< Offset between still-water level and mean sea level [m]
    TYPE(FlowFieldType) , POINTER :: FlowField => NULL()      !< Pointer of InflowWinds flow field data type [-]
  END TYPE AD_InitInputType
! =======================
! =========  AD_BladePropsType  =======
  TYPE, PUBLIC :: AD_BladePropsType
    INTEGER(IntKi)  :: NumBlNds = 0_IntKi      !< Number of blade nodes used in the analysis [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlSpn      !< Span at blade node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlCrvAC      !< Curve at blade node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlSwpAC      !< Sweep at blade node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlCrvAng      !< Curve angle at blade node [radians]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlTwist      !< Twist at blade node [radians]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlChord      !< Chord at blade node [m]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: BlAFID      !< ID of Airfoil at blade node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlCb      !< Coefficient of buoyancy at blade node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlCenBn      !< Center of buoyancy normal offset at blade node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: BlCenBt      !< Center of buoyancy tangential offset at blade node [m]
  END TYPE AD_BladePropsType
! =======================
! =========  AD_BladeShape  =======
  TYPE, PUBLIC :: AD_BladeShape
    REAL(SiKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AirfoilCoords      !< x-y coordinates for airfoils, relative to node [m]
  END TYPE AD_BladeShape
! =======================
! =========  RotInitOutputType  =======
  TYPE, PUBLIC :: RotInitOutputType
    REAL(ReKi)  :: AirDens = 0.0_ReKi      !< Air density [kg/m^3]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(AD_BladeShape) , DIMENSION(:), ALLOCATABLE  :: BladeShape      !< airfoil coordinates for each blade [m]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_y      !< Names of the outputs used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_x      !< Names of the continuous states used in linearization [-]
    CHARACTER(LinChanLen) , DIMENSION(:), ALLOCATABLE  :: LinNames_u      !< Names of the inputs used in linearization [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_y      !< Flag that tells FAST/MBC3 if the outputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_x      !< Flag that tells FAST/MBC3 if the continuous states used in linearization are in the rotating frame (not used for glue) [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: RotFrame_u      !< Flag that tells FAST/MBC3 if the inputs used in linearization are in the rotating frame [-]
    LOGICAL , DIMENSION(:), ALLOCATABLE  :: IsLoad_u      !< Flag that tells FAST if the inputs used in linearization are loads (for preconditioning matrix) [-]
    TYPE(AD_BladePropsType) , DIMENSION(:), ALLOCATABLE  :: BladeProps      !< blade property information from blade input files [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: DerivOrder_x      !< Integer that tells FAST/MBC3 the maximum derivative order of continuous states used in linearization [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrElev      !< Elevation at tower node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrDiam      !< Diameter of tower at node [m]
  END TYPE RotInitOutputType
! =======================
! =========  AD_InitOutputType  =======
  TYPE, PUBLIC :: AD_InitOutputType
    TYPE(RotInitOutputType) , DIMENSION(:), ALLOCATABLE  :: rotors      !< Rotor init output type [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    INTEGER(IntKi)  :: nNodesVel = 0_IntKi      !< number of nodes velocity values are needed at (for ExtLoads coupling) [-]
  END TYPE AD_InitOutputType
! =======================
! =========  RotInputFile  =======
  TYPE, PUBLIC :: RotInputFile
    TYPE(AD_BladePropsType) , DIMENSION(:), ALLOCATABLE  :: BladeProps      !< blade property information from blade input files [-]
    INTEGER(IntKi)  :: NumTwrNds = 0_IntKi      !< Number of tower nodes used in the analysis [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrElev      !< Elevation at tower node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrDiam      !< Diameter of tower at node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrCd      !< Coefficient of drag at tower node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrTI      !< Turbulence intensity for tower shadow at tower node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrCb      !< Coefficient of buoyancy at tower node [-]
    REAL(ReKi)  :: VolHub = 0.0_ReKi      !< Hub volume [m^3]
    REAL(ReKi)  :: HubCenBx = 0.0_ReKi      !< Hub center of buoyancy x direction offset [m]
    REAL(ReKi)  :: VolNac = 0.0_ReKi      !< Nacelle volume [m^3]
    REAL(ReKi) , DIMENSION(1:3)  :: NacCenB = 0.0_ReKi      !< Position of nacelle center of buoyancy from yaw bearing in nacelle coordinates [m]
    REAL(ReKi) , DIMENSION(1:3)  :: NacArea = 0.0_ReKi      !< Projected area of the nacelle in X, Y, Z in the nacelle coordinate system [m^2]
    REAL(ReKi) , DIMENSION(1:3)  :: NacCd = 0.0_ReKi      !< Drag cefficient for the nacelle areas defied above [-]
    REAL(ReKi) , DIMENSION(1:3)  :: NacDragAC = 0.0_ReKi      !< Position of aerodynamic center of nacelle drag in nacelle coordinates [m]
    LOGICAL  :: TFinAero = .FALSE.      !< Calculate tail fin aerodynamics model (flag) [flag]
    CHARACTER(1024)  :: TFinFile      !< Input file for tail fin aerodynamics [used only when TFinAero=True] [-]
    TYPE(TFinInputFileType)  :: TFin      !< Input file data for tail fin [-]
  END TYPE RotInputFile
! =======================
! =========  AD_InputFile  =======
  TYPE, PUBLIC :: AD_InputFile
    LOGICAL  :: Echo = .false.      !< Echo input file to echo file [-]
    REAL(DbKi)  :: DTAero = 0.0_R8Ki      !< Time interval for aerodynamic calculations {or "default"} [s]
    INTEGER(IntKi)  :: Wake_Mod = 0_IntKi      !< Type of wake/induction model {0=none, 1=BEMT, 2=DBEMT, 3=FVW} [-]
    INTEGER(IntKi)  :: BEM_Mod = 0_IntKi      !< Type of BEM model {1=legacy NoSweepPitchTwist, 2=polar grid} [-]
    INTEGER(IntKi)  :: TwrPotent = 0_IntKi      !< Type of tower influence on wind based on potential flow around the tower {0=none, 1=baseline potential flow, 2=potential flow with Bak correction} [-]
    INTEGER(IntKi)  :: TwrShadow = 0_IntKi      !< Type of tower influence on wind based on downstream tower shadow {0=none, 1=Powles model, 2=Eames model} [-]
    INTEGER(IntKi)  :: TwrAero = 0_IntKi      !< Calculate tower aerodynamic loads? {0=none, 1=aero without VIV, 2=aero with VIV} [-]
    LOGICAL  :: CavitCheck = .false.      !< Flag that tells us if we want to check for cavitation [-]
    LOGICAL  :: Buoyancy = .false.      !< Include buoyancy effects? [flag]
    LOGICAL  :: NacelleDrag = .false.      !< Include NacelleDrag effects? [flag]
    LOGICAL  :: CompAA = .false.      !< Compute AeroAcoustic noise [flag]
    CHARACTER(1024)  :: AA_InputFile      !< AeroAcoustics input file name [quoted strings]
    CHARACTER(1024) , DIMENSION(:), ALLOCATABLE  :: ADBlFile      !< AD blade file (NumBl filenames) [quoted strings]
    REAL(ReKi)  :: AirDens = 0.0_ReKi      !< Air density [kg/m^3]
    REAL(ReKi)  :: KinVisc = 0.0_ReKi      !< Kinematic air viscosity [m^2/s]
    REAL(ReKi)  :: Patm = 0.0_ReKi      !< Atmospheric pressure [Pa]
    REAL(ReKi)  :: Pvap = 0.0_ReKi      !< Vapour pressure [Pa]
    REAL(ReKi)  :: SpdSound = 0.0_ReKi      !< Speed of sound [m/s]
    INTEGER(IntKi)  :: Skew_Mod = 0_IntKi      !< Select skew model {0=No skew model at all, -1=Throw away non-normal component for linearization, 1=Glauert skew model} [-]
    LOGICAL  :: SkewMomCorr = .false.      !< Turn the skew momentum correction on or off [used only when SkewMod=1] [-]
    INTEGER(IntKi)  :: SkewRedistr_Mod = 0_IntKi      !< Type of skewed-wake redistribution model (switch) {0=no redistribution, 1=Glauert/Pitt/Peters, 2=Vortex Cylinder} [unsed only when SkewMod=1] [-]
    REAL(ReKi)  :: SkewModFactor = 0.0_ReKi      !< Constant used in Pitt/Peters skewed wake model (default is 15*pi/32) [-]
    LOGICAL  :: TipLoss = .false.      !< Use the Prandtl tip-loss model? [unused when Wake_Mod=0] [flag]
    LOGICAL  :: HubLoss = .false.      !< Use the Prandtl hub-loss model? [unused when Wake_Mod=0] [flag]
    LOGICAL  :: TanInd = .false.      !< Include tangential induction in BEMT calculations? [unused when Wake_Mod=0] [flag]
    LOGICAL  :: AIDrag = .false.      !< Include the drag term in the axial-induction calculation? [unused when Wake_Mod=0] [flag]
    LOGICAL  :: TIDrag = .false.      !< Include the drag term in the tangential-induction calculation? [unused when Wake_Mod=0 or TanInd=FALSE] [flag]
    REAL(ReKi)  :: IndToler = 0.0_ReKi      !< Convergence tolerance for BEM induction factors [unused when Wake_Mod=0] [-]
    REAL(ReKi)  :: MaxIter = 0.0_ReKi      !< Maximum number of iteration steps [unused when Wake_Mod=0] [-]
    LOGICAL  :: SectAvg = .False.      !< Use Sector average for BEM inflow velocity calculation (flag) [-]
    INTEGER(IntKi)  :: SA_Weighting = 1      !< Sector Average - Weighting function for sector average  {1=Uniform, 2=Impulse, }  within a 360/nB sector centered on the blade (switch) [used only when SectAvg=True] [-]
    REAL(ReKi)  :: SA_PsiBwd = -60      !< Sector Average - Backard Azimuth (<0) [deg]
    REAL(ReKi)  :: SA_PsiFwd = 60      !< Sector Average - Forward Azimuth (>0) [deg]
    INTEGER(IntKi)  :: SA_nPerSec = 5      !< Sector average - Number of points per sectors (-) [used only when SectAvg=True] [-]
    LOGICAL  :: AoA34 = .false.      !< Sample the angle of attack (AoA) at the 3/4 chord or the AC point {default=True} [always used] [-]
    TYPE(UA_InitInputType)  :: UA_Init      !< InitInput data for UA model [-]
    REAL(ReKi)  :: InCol_Alfa = 0.0_ReKi      !< The column in the airfoil tables that contains the angle of attack [-]
    REAL(ReKi)  :: InCol_Cl = 0.0_ReKi      !< The column in the airfoil tables that contains the lift coefficient [-]
    REAL(ReKi)  :: InCol_Cd = 0.0_ReKi      !< The column in the airfoil tables that contains the drag coefficient [-]
    REAL(ReKi)  :: InCol_Cm = 0.0_ReKi      !< The column in the airfoil tables that contains the pitching-moment coefficient; use zero if there is no Cm column [-]
    REAL(ReKi)  :: InCol_Cpmin = 0.0_ReKi      !< The column in the airfoil tables that contains the drag coefficient; use zero if there is no Cpmin column [-]
    INTEGER(IntKi)  :: AFTabMod = 0_IntKi      !< Interpolation method for multiple airfoil tables {1 = 1D on AoA (only first table is used); 2 = 2D on AoA and Re; 3 = 2D on AoA and UserProp} [-]
    INTEGER(IntKi)  :: NumAFfiles = 0_IntKi      !< Number of airfoil files used [-]
    CHARACTER(1024)  :: FVWFileName      !< FVW input filename [quoted string]
    CHARACTER(1024) , DIMENSION(:), ALLOCATABLE  :: AFNames      !< Airfoil file names (NumAF lines) [quoted strings]
    LOGICAL  :: UseBlCm = .false.      !< Include aerodynamic pitching moment in calculations? [flag]
    LOGICAL  :: SumPrint = .false.      !< Generate a summary file listing input options and interpolated properties to "<rootname>.AD.sum"? [flag]
    INTEGER(IntKi)  :: NBlOuts = 0_IntKi      !< Number of blade node outputs [0 - 9] [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: BlOutNd = 0_IntKi      !< Blade nodes whose values will be output [-]
    INTEGER(IntKi)  :: NTwOuts = 0_IntKi      !< Number of tower node outputs [0 - 9] [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: TwOutNd = 0_IntKi      !< Tower nodes whose values will be output [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< List of user-requested output channels [-]
    REAL(ReKi)  :: tau1_const = 0.0_ReKi      !< time constant for DBEMT [s]
    INTEGER(IntKi)  :: DBEMT_Mod = 0_IntKi      !< Type of dynamic BEMT (DBEMT) model {0=No Dynamic Wake, -1=Frozen Wake for linearization, 1=constant tau1, 2=time-dependent tau1, 3=constant tau1 with continuous formulation} (-) [used only when WakeMod=1] [-]
    INTEGER(IntKi)  :: BldNd_NumOuts = 0_IntKi      !< Number of requested output channels per blade node (AD_AllBldNdOuts) [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: BldNd_OutList      !< List of user-requested output channels (AD_AllBldNdOuts) [-]
    CHARACTER(1024)  :: BldNd_BlOutNd_Str      !< String to parse for the blade nodes to actually output (AD_AllBldNdOuts) [-]
    INTEGER(IntKi)  :: BldNd_BladesOut = 0_IntKi      !< The blades to output (AD_AllBldNdOuts) [-]
    REAL(ReKi)  :: UAStartRad = 0.0_ReKi      !< Starting [radius]
    REAL(ReKi)  :: UAEndRad = 0.0_ReKi      !< Ending [radius]
    TYPE(RotInputFile) , DIMENSION(:), ALLOCATABLE  :: rotors      !< Rotor (blades and tower) input file data [-]
  END TYPE AD_InputFile
! =======================
! =========  RotContinuousStateType  =======
  TYPE, PUBLIC :: RotContinuousStateType
    TYPE(BEMT_ContinuousStateType)  :: BEMT      !< Continuous states from the BEMT module [-]
    TYPE(AA_ContinuousStateType)  :: AA      !< Continuous states from the AA module [-]
  END TYPE RotContinuousStateType
! =======================
! =========  AD_ContinuousStateType  =======
  TYPE, PUBLIC :: AD_ContinuousStateType
    TYPE(RotContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: rotors      !< Continuous states for each rotor [-]
    TYPE(FVW_ContinuousStateType)  :: FVW      !< Continuous states from the FVW module [-]
  END TYPE AD_ContinuousStateType
! =======================
! =========  RotDiscreteStateType  =======
  TYPE, PUBLIC :: RotDiscreteStateType
    TYPE(BEMT_DiscreteStateType)  :: BEMT      !< Discrete states from the BEMT module [-]
    TYPE(AA_DiscreteStateType)  :: AA      !< Discrete states from the AA module [-]
  END TYPE RotDiscreteStateType
! =======================
! =========  AD_DiscreteStateType  =======
  TYPE, PUBLIC :: AD_DiscreteStateType
    TYPE(RotDiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: rotors      !< Discrete states for each rotor [-]
    TYPE(FVW_DiscreteStateType)  :: FVW      !< Discrete states from the FVW module [-]
  END TYPE AD_DiscreteStateType
! =======================
! =========  RotConstraintStateType  =======
  TYPE, PUBLIC :: RotConstraintStateType
    TYPE(BEMT_ConstraintStateType)  :: BEMT      !< Constraint states from the BEMT module [-]
    TYPE(AA_ConstraintStateType)  :: AA      !< Constraint states from the AA module [-]
  END TYPE RotConstraintStateType
! =======================
! =========  AD_ConstraintStateType  =======
  TYPE, PUBLIC :: AD_ConstraintStateType
    TYPE(RotConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: rotors      !< Constraint states for each rotor [-]
    TYPE(FVW_ConstraintStateType)  :: FVW      !< Constraint states from the FVW module [-]
  END TYPE AD_ConstraintStateType
! =======================
! =========  RotOtherStateType  =======
  TYPE, PUBLIC :: RotOtherStateType
    TYPE(BEMT_OtherStateType)  :: BEMT      !< OtherStates from the BEMT module [-]
    TYPE(AA_OtherStateType)  :: AA      !< OtherStates from the AA module [-]
  END TYPE RotOtherStateType
! =======================
! =========  AD_OtherStateType  =======
  TYPE, PUBLIC :: AD_OtherStateType
    TYPE(RotOtherStateType) , DIMENSION(:), ALLOCATABLE  :: rotors      !< OtherStates from the BEMT module [-]
    TYPE(FVW_OtherStateType)  :: FVW      !< OtherStates from the FVW module [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: WakeLocationPoints      !< wake points velocity [m/s]
  END TYPE AD_OtherStateType
! =======================
! =========  RotMiscVarType  =======
  TYPE, PUBLIC :: RotMiscVarType
    TYPE(BEMT_MiscVarType)  :: BEMT      !< MiscVars from the BEMT module [-]
    TYPE(BEMT_OutputType)  :: BEMT_y      !< Outputs from the BEMT module [-]
    TYPE(BEMT_InputType) , DIMENSION(1:2)  :: BEMT_u      !< Inputs to the BEMT module [-]
    TYPE(AA_MiscVarType)  :: AA      !< MiscVars from the AA module [-]
    TYPE(AA_OutputType)  :: AA_y      !< Outputs from the AA module [-]
    TYPE(AA_InputType)  :: AA_u      !< Inputs to the AA module [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: DisturbedInflow      !< InflowOnBlade values modified by tower influence [m/s]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: SectAvgInflow      !< Sector averaged - disturbed inflow to improve BEM shear calculations [m/s]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: orientationAnnulus      !< Coordinate system equivalent to BladeMotion Orientation, but without live sweep, blade-pitch, and twist angles [-]
    REAL(R8Ki) , DIMENSION(:,:,:,:), ALLOCATABLE  :: R_li      !< Transformation matrix from inertial system to the staggered polar coordinate system of a given section [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AllOuts      !< An array holding the value of all of the calculated (not only selected) output channels [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: W_Twr      !< relative wind speed normal to the tower at node j [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: X_Twr      !< local x-component of force per unit length of the jth node in the tower [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Y_Twr      !< local y-component of force per unit length of the jth node in the tower [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Cant      !< curvature angle, saved for possible output to file [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Toe      !< Toe angle, saved for possible output to file [rad]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TwrClrnc      !< Distance between tower (including tower radius) and blade node (not including blade width), saved for possible output to file [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: X      !< normal force per unit length (normal to the plane, not chord) of the jth node in the kth blade [N/m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Y      !< tangential force per unit length (tangential to the plane, not chord) of the jth node in the kth blade [N/m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Z      !< axial force per unit length (tangential to the plane, not chord) of the jth node in the kth blade [N/m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: M      !< pitching moment per unit length of the jth node in the kth blade [Nm/m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Mx      !< pitching moment per unit length of the jth node in the kth blade (in x direction) [Nm/m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: My      !< pitching moment per unit length of the jth node in the kth blade  (in y direction) [Nm/m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Mz      !< pitching moment per unit length of the jth node in the kth blade  (in z direction) [Nm/m]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Vind_i      !< Induced velocities at jth node and kth blade (3xnSpanxnB) [m/s]
    REAL(ReKi) , DIMENSION(1:3)  :: V_DiskAvg = 0.0_ReKi      !< disk-average relative wind speed [m/s]
    REAL(ReKi)  :: yaw = 0.0_ReKi      !< Yaw calculated in  SetInputsForBEMT [rad]
    REAL(ReKi)  :: tilt = 0.0_ReKi      !< tilt calculated in  SetInputsForBEMT [rad]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: hub_theta_x_root      !< angles saved for FAST.Farm [rad]
    REAL(ReKi)  :: V_dot_x = 0.0_ReKi 
    TYPE(MeshType)  :: HubLoad      !< mesh at hub; used to compute an integral for mapping the output blade loads to a single point (for writing to file only) [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: B_L_2_H_P      !< mapping data structure to map each bladeLoad output mesh to the MiscVar%HubLoad mesh [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: SigmaCavitCrit      !< critical cavitation number-  inception value (above which cavit will occur) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: SigmaCavit      !< cavitation number at node  [-]
    LOGICAL , DIMENSION(:,:), ALLOCATABLE  :: CavitWarnSet      !< cavitation warning issued  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TwrFB      !< buoyant force per unit length at tower node [N/m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TwrMB      !< buoyant moment per unit length at tower node [Nm/m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: HubFB      !< buoyant force at hub node [N]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: HubMB      !< buoyant moment at hub node [Nm]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: NacFB      !< buoyant force at nacelle (tower top) node [N]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: NacMB      !< buoyant moment at nacelle (tower top) node [Nm]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: NacDragF      !< drag force at nacelle (tower top) node [N]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: NacDragM      !< drag moment at nacelle (tower top) node [Nm]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: NacFi      !< Total force at nacelle (tower top) node [N]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: NacMi      !< Total moment at nacelle (tower top) node [Nm]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeRootLoad      !< meshes at blade root; used to compute an integral for mapping the output blade loads to single points (for writing to file only) [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: B_L_2_R_P      !< mapping data structure to map each bladeLoad output mesh to corresponding MiscVar%BladeRootLoad mesh [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeBuoyLoadPoint      !< point mesh for lumped buoyant blade loads [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeBuoyLoad      !< line mesh for per unit length buoyant blade loads [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: B_P_2_B_L      !< mapping data structure to map buoyant blade point loads (m%BladeBuoyLoadPoint) to buoyant blade line loads (m%BladeBuoyLoad) [-]
    TYPE(MeshType)  :: TwrBuoyLoadPoint      !< point mesh for lumped buoyant tower loads [-]
    TYPE(MeshType)  :: TwrBuoyLoad      !< line mesh for per unit length buoyant tower loads [-]
    TYPE(MeshMapType)  :: T_P_2_T_L      !< mapping data structure to map buoyant tower point loads (m%TwrBuoyLoadPoint) to buoyant tower line loads (m%TwrBuoyLoad) [-]
    LOGICAL  :: FirstWarn_TowerStrike = .false.      !< flag to avoid printing tower strike multiple times [-]
    REAL(ReKi) , DIMENSION(1:3)  :: AvgDiskVel = 0.0_ReKi      !< disk-averaged U,V,W (undisturbed) [m/s]
    REAL(ReKi) , DIMENSION(1:3)  :: AvgDiskVelDist = 0.0_ReKi      !< disk-averaged U,V,W (disturbed) [m/s]
    REAL(ReKi)  :: TFinAlpha = 0.0_ReKi      !< Angle of attack for tailfin [-]
    REAL(ReKi)  :: TFinRe = 0.0_ReKi      !< Reynolds number for tailfin [-]
    REAL(ReKi)  :: TFinVrel = 0.0_ReKi      !< Orthogonal relative velocity nrom at the reference point [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TFinVund_i = 0.0_ReKi      !< Undisturbed wind velocity at the reference point of the fin in the inertial system [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TFinVind_i = 0.0_ReKi      !< Induced velocity at the reference point of the fin in the inertial system [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TFinVrel_i = 0.0_ReKi      !< Relative velocity at the reference point of the fin in the inertial system [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TFinSTV_i = 0.0_ReKi      !< Structural velocity at the reference point of the fin in the inertial system [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TFinF_i = 0.0_ReKi      !< Forces at the reference point of the fin in the inertial system [-]
    REAL(ReKi) , DIMENSION(1:3)  :: TFinM_i = 0.0_ReKi      !< Moments at the reference point of the fin in the inertial system [-]
  END TYPE RotMiscVarType
! =======================
! =========  ElemInflowType  =======
  TYPE, PUBLIC :: ElemInflowType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: InflowVel      !< U,V,W at nodes on element (note if we change the requirement that NumNodes is the same for each blade, this will need to change) [m/s]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: InflowAcc      !< Wind acceleration at nodes on element (blade or tower) (note if we change the requirement that NumNodes is the same for each blade, this will need to change) [m/s]
  END TYPE ElemInflowType
! =======================
! =========  RotInflowType  =======
  TYPE, PUBLIC :: RotInflowType
    TYPE(ElemInflowType) , DIMENSION(:), ALLOCATABLE  :: Blade      !< Blade wind inputs [-]
    TYPE(ElemInflowType)  :: Tower      !< Blade wind inputs [-]
    REAL(ReKi) , DIMENSION(1:3,1:1)  :: InflowOnHub = 0.0_ReKi      !< U,V,W at hub [m/s]
    REAL(ReKi) , DIMENSION(1:3,1:1)  :: InflowOnNacelle = 0.0_ReKi      !< U,V,W at nacelle [m/s]
    REAL(ReKi) , DIMENSION(1:3,1:1)  :: InflowOnTailFin = 0.0_ReKi      !< U,V,W at tailfin [m/s]
    REAL(ReKi) , DIMENSION(1:3)  :: AvgDiskVel = 0.0_ReKi      !< disk-averaged U,V,W [m/s]
  END TYPE RotInflowType
! =======================
! =========  AD_InflowType  =======
  TYPE, PUBLIC :: AD_InflowType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: InflowWakeVel      !< U,V,W at wake points [m/s]
    TYPE(RotInflowType) , DIMENSION(:), ALLOCATABLE  :: RotInflow      !< Inflow on rotor [-]
  END TYPE AD_InflowType
! =======================
! =========  AD_MiscVarType  =======
  TYPE, PUBLIC :: AD_MiscVarType
    TYPE(RotMiscVarType) , DIMENSION(:), ALLOCATABLE  :: rotors      !< MiscVars for each rotor [-]
    TYPE(FVW_InputType) , DIMENSION(:), ALLOCATABLE  :: FVW_u      !< Inputs to the FVW module [-]
    TYPE(FVW_OutputType)  :: FVW_y      !< Outputs from the FVW module [-]
    TYPE(FVW_MiscVarType)  :: FVW      !< MiscVars from the FVW module [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: WindPos      !< XYZ coordinates to query for wind velocity/acceleration [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: WindVel      !< XYZ components of wind velocity [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: WindAcc      !< XYZ components of wind acceleration [-]
    TYPE(AD_InflowType) , DIMENSION(:), ALLOCATABLE  :: Inflow      !< Inflow storage (size of u for history of inputs) [-]
  END TYPE AD_MiscVarType
! =======================
! =========  Jac_u_idxStarts  =======
  TYPE, PUBLIC :: Jac_u_idxStarts
    INTEGER(IntKi)  :: Nacelle = 1      !< Index to first point in u jacobian for Nacelle [-]
    INTEGER(IntKi)  :: Hub = 1      !< Index to first point in u jacobian for Hub [-]
    INTEGER(IntKi)  :: TFin = 1      !< Index to first point in u jacobian for TFin [-]
    INTEGER(IntKi)  :: Tower = 1      !< Index to first point in u jacobian for Tower [-]
    INTEGER(IntKi)  :: BladeRoot = 1      !< Index to first point in u jacobian for BladeRoot [-]
    INTEGER(IntKi)  :: Blade = 1      !< Index to first point in u jacobian for Blade [-]
    INTEGER(IntKi)  :: UserProp = 1      !< Index to first point in u jacobian for UserProp [-]
    INTEGER(IntKi)  :: Extended = 1      !< Index to first point in u jacobian for Extended [-]
  END TYPE Jac_u_idxStarts
! =======================
! =========  Jac_y_idxStarts  =======
  TYPE, PUBLIC :: Jac_y_idxStarts
    INTEGER(IntKi)  :: NacelleLoad = 1      !< Index to first point in y jacobian for NacelleLoad [-]
    INTEGER(IntKi)  :: HubLoad = 1      !< Index to first point in y jacobian for HubLoad [-]
    INTEGER(IntKi)  :: TFinLoad = 1      !< Index to first point in y jacobian for TFinLoad [-]
    INTEGER(IntKi)  :: TowerLoad = 1      !< Index to first point in y jacobian for TowerLoad [-]
    INTEGER(IntKi)  :: BladeLoad = 1      !< Index to first point in y jacobian for BladeLoad [-]
  END TYPE Jac_y_idxStarts
! =======================
! =========  RotParameterType  =======
  TYPE, PUBLIC :: RotParameterType
    INTEGER(IntKi)  :: NumBlades = 0_IntKi      !< Number of blades on the turbine [-]
    INTEGER(IntKi)  :: NumBlNds = 0_IntKi      !< Number of nodes on each blade [-]
    INTEGER(IntKi)  :: NumTwrNds = 0_IntKi      !< Number of nodes on the tower [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrDiam      !< Diameter of tower at node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrCd      !< Coefficient of drag at tower node [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrTI      !< Turbulence intensity for tower shadow at tower node [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlTwist      !< Twist at blade node [radians]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrCb      !< Coefficient of buoyancy at tower node [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlCenBn      !< Normal offset between aerodynamic center and center of buoyancy at blade node [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlCenBt      !< Tangential offset between aerodynamic center and center of buoyancy at blade node [m]
    REAL(ReKi)  :: VolHub = 0.0_ReKi      !< Hub volume [m^3]
    REAL(ReKi)  :: HubCenBx = 0.0_ReKi      !< Hub center of buoyancy x direction offset [m]
    REAL(ReKi)  :: VolNac = 0.0_ReKi      !< Nacelle volume [m^3]
    REAL(ReKi) , DIMENSION(1:3)  :: NacCenB = 0.0_ReKi      !< Position of nacelle center of buoyancy from yaw bearing in nacelle coordinates [m]
    REAL(ReKi) , DIMENSION(1:3)  :: NacArea = 0.0_ReKi      !< Projected area of the nacelle in X, Y, Z in the nacelle coordinate system [m^2]
    REAL(ReKi) , DIMENSION(1:3)  :: NacCd = 0.0_ReKi      !< Drag cefficient for the nacelle areas defied above [-]
    REAL(ReKi) , DIMENSION(1:3)  :: NacDragAC = 0.0_ReKi      !< Position of aerodynamic center of nacelle drag in nacelle coordinates [m]
    REAL(ReKi)  :: VolBl = 0.0_ReKi      !< Buoyancy volume of all blades [m^3]
    REAL(ReKi)  :: VolTwr = 0.0_ReKi      !< Buoyancy volume of the tower [m^3]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlRad      !< Matrix of equivalent blade radius at each node, used in buoyancy calculation [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlDL      !< Matrix of blade element length based on CB, used in buoyancy calculation [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlTaper      !< Matrix of blade element taper, used in buoyancy calculation [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlAxCent      !< Matrix of blade element axial centroid, used in buoyancy calculation [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrRad      !< Array of equivalent tower radius at each node, used in buoyancy calculation [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrDL      !< Array of tower element length, used in buoyancy calculation [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrTaper      !< Array of tower element taper, used in buoyancy calculation [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: TwrAxCent      !< Array of tower element axial centroid, used in buoyancy calculation [-]
    TYPE(BEMT_ParameterType)  :: BEMT      !< Parameters for BEMT module [-]
    TYPE(AA_ParameterType)  :: AA      !< Parameters for AA module [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: Jac_u_indx      !< matrix to help fill/pack the u vector in computing the jacobian [-]
    TYPE(Jac_u_idxStarts)  :: Jac_u_idxStartList      !< Starting indices for all Jac_u components [-]
    TYPE(Jac_y_idxStarts)  :: Jac_y_idxStartList      !< Starting indices for all Jac_y components [-]
    INTEGER(IntKi)  :: NumExtendedInputs = 0_IntKi      !< number of extended inputs [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: du      !< vector that determines size of perturbation for u (inputs) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dx      !< vector that determines size of perturbation for x (continuous states) [-]
    INTEGER(IntKi)  :: Jac_ny = 0_IntKi      !< number of outputs in jacobian matrix [-]
    INTEGER(IntKi)  :: NumBl_Lin = 0_IntKi      !< number of blades in the jacobian [-]
    INTEGER(IntKi)  :: TwrPotent = 0_IntKi      !< Type of tower influence on wind based on potential flow around the tower {0=none, 1=baseline potential flow, 2=potential flow with Bak correction} [-]
    INTEGER(IntKi)  :: TwrShadow = 0_IntKi      !< Type of tower influence on wind based on downstream tower shadow {0=none, 1=Powles model, 2=Eames model} [-]
    INTEGER(IntKi)  :: TwrAero = 0_IntKi      !< Calculate tower aerodynamic loads? {0=none, 1=aero without VIV, 2=aero with VIV} [switch]
    INTEGER(IntKi)  :: DBEMT_Mod = 0_IntKi      !< DBEMT_Mod [-]
    LOGICAL  :: CavitCheck = .false.      !< Flag that tells us if we want to check for cavitation [-]
    LOGICAL  :: Buoyancy = .false.      !< Include buoyancy effects? [flag]
    LOGICAL  :: NacelleDrag = .false.      !< Include NacelleDrag effects? [flag]
    INTEGER(IntKi)  :: MHK = 0_IntKi      !< MHK [flag]
    LOGICAL  :: CompAA = .false.      !< Compute AeroAcoustic noise [flag]
    REAL(ReKi)  :: AirDens = 0.0_ReKi      !< Air density [kg/m^3]
    REAL(ReKi)  :: KinVisc = 0.0_ReKi      !< Kinematic air viscosity [m^2/s]
    REAL(ReKi)  :: SpdSound = 0.0_ReKi      !< Speed of sound [m/s]
    REAL(ReKi)  :: Gravity = 0.0_ReKi      !< Gravitational acceleration [m/s^2]
    REAL(ReKi)  :: Patm = 0.0_ReKi      !< Atmospheric pressure [Pa]
    REAL(ReKi)  :: Pvap = 0.0_ReKi      !< Vapour pressure [Pa]
    REAL(ReKi)  :: WtrDpth = 0.0_ReKi      !< Water depth [m]
    REAL(ReKi)  :: MSL2SWL = 0.0_ReKi      !< Offset between still-water level and mean sea level [m]
    INTEGER(IntKi)  :: AeroProjMod = 1      !< Flag to switch between different projection models [-]
    INTEGER(IntKi)  :: BEM_Mod = -1      !< Flag to switch between different BEM Model [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    INTEGER(IntKi)  :: NBlOuts = 0_IntKi      !< Number of blade node outputs [0 - 9] [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: BlOutNd = 0_IntKi      !< Blade nodes whose values will be output [-]
    INTEGER(IntKi)  :: NTwOuts = 0_IntKi      !< Number of tower node outputs [0 - 9] [-]
    INTEGER(IntKi) , DIMENSION(1:9)  :: TwOutNd = 0_IntKi      !< Tower nodes whose values will be output [-]
    INTEGER(IntKi)  :: BldNd_NumOuts = 0_IntKi      !< Number of requested output channels per blade node (AD_AllBldNdOuts) [-]
    INTEGER(IntKi)  :: BldNd_TotNumOuts = 0_IntKi      !< Total number of requested output channels of blade node information (BldNd_NumOuts * BldNd_BlOutNd * BldNd_BladesOut -- AD_AllBldNdOuts) [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: BldNd_OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: BldNd_BlOutNd      !< The blade nodes to actually output (AD_AllBldNdOuts) [-]
    INTEGER(IntKi)  :: BldNd_BladesOut = 0_IntKi      !< The blades to output (AD_AllBldNdOuts) [-]
    INTEGER(IntKi)  :: BldNd_NumNodesOut = 0_IntKi      !< The blades to output (AD_AllBldNdOuts) [-]
    LOGICAL  :: TFinAero = .FALSE.      !< Calculate tail fin aerodynamics model (flag) [flag]
    TYPE(TFinParameterType)  :: TFin      !< Parameters for tail fin of current rotor [-]
  END TYPE RotParameterType
! =======================
! =========  AD_ParameterType  =======
  TYPE, PUBLIC :: AD_ParameterType
    TYPE(RotParameterType) , DIMENSION(:), ALLOCATABLE  :: rotors      !< Parameter types for each rotor [-]
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for continuous state integration & discrete state update [seconds]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    TYPE(AFI_ParameterType) , DIMENSION(:), ALLOCATABLE  :: AFI      !< AirfoilInfo parameters [-]
    INTEGER(IntKi)  :: Skew_Mod = 0_IntKi      !< Type of skewed-wake correction model {-1=orthogonal, 0=None, 1=Glauert} [unused when Wake_Mod=0] [-]
    INTEGER(IntKi)  :: Wake_Mod = 0_IntKi      !< Type of wake/induction model {0=none, 1=BEMT, 2=DBEMT, 3=FVW} [-]
    TYPE(FVW_ParameterType)  :: FVW      !< Parameters for FVW module [-]
    LOGICAL  :: CompAeroMaps = .FALSE.      !< flag to determine if AeroDyn is computing aero maps (true) or running a normal simulation (false) [-]
    LOGICAL  :: UA_Flag = .false.      !< logical flag indicating whether to use UnsteadyAero [-]
    TYPE(FlowFieldType) , POINTER :: FlowField => NULL()      !< Pointer of InflowWinds flow field data type [-]
    LOGICAL  :: SectAvg = .false.      !< Use Sector average for BEM inflow velocity calculation [-]
    INTEGER(IntKi)  :: SA_Weighting = 0_IntKi      !< Sector Average - Weighting function for sector average  {1=Uniform, 2=Impulse}  within a 360/nB sector centered on the blade (switch) [used only when SectAvg=True] [-]
    REAL(ReKi)  :: SA_PsiBwd = 0.0_ReKi      !< Sector Average - Backard Azimuth (<0) [deg]
    REAL(ReKi)  :: SA_PsiFwd = 0.0_ReKi      !< Sector Average - Forward Azimuth (>0) [deg]
    INTEGER(IntKi)  :: SA_nPerSec = 0_IntKi      !< Sector Average - Number of points per sector (>1) [-]
  END TYPE AD_ParameterType
! =======================
! =========  RotInputType  =======
  TYPE, PUBLIC :: RotInputType
    TYPE(MeshType)  :: NacelleMotion      !< motion on the nacelle [-]
    TYPE(MeshType)  :: TowerMotion      !< motion on the tower [-]
    TYPE(MeshType)  :: HubMotion      !< motion on the hub [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeRootMotion      !< motion on each blade root [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeMotion      !< motion on each blade [-]
    TYPE(MeshType)  :: TFinMotion      !< motion of tail fin (at tail fin ref point) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: UserProp      !< Optional user property for interpolating airfoils (per element per blade) [-]
  END TYPE RotInputType
! =======================
! =========  AD_InputType  =======
  TYPE, PUBLIC :: AD_InputType
    TYPE(RotInputType) , DIMENSION(:), ALLOCATABLE  :: rotors      !< Inputs for each rotor [-]
  END TYPE AD_InputType
! =======================
! =========  RotOutputType  =======
  TYPE, PUBLIC :: RotOutputType
    TYPE(MeshType)  :: NacelleLoad      !< loads on the nacelle [-]
    TYPE(MeshType)  :: HubLoad      !< loads on the hub [-]
    TYPE(MeshType)  :: TowerLoad      !< loads on the tower [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeLoad      !< loads on each blade [-]
    TYPE(MeshType)  :: TFinLoad      !< loads on tail fin (at tail fin ref point) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
  END TYPE RotOutputType
! =======================
! =========  AD_OutputType  =======
  TYPE, PUBLIC :: AD_OutputType
    TYPE(RotOutputType) , DIMENSION(:), ALLOCATABLE  :: rotors      !< Ouputs for each rotor [-]
  END TYPE AD_OutputType
! =======================
CONTAINS

subroutine AD_CopyTFinParameterType(SrcTFinParameterTypeData, DstTFinParameterTypeData, CtrlCode, ErrStat, ErrMsg)
   type(TFinParameterType), intent(in) :: SrcTFinParameterTypeData
   type(TFinParameterType), intent(inout) :: DstTFinParameterTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_CopyTFinParameterType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstTFinParameterTypeData%TFinMod = SrcTFinParameterTypeData%TFinMod
   DstTFinParameterTypeData%TFinArea = SrcTFinParameterTypeData%TFinArea
   DstTFinParameterTypeData%TFinIndMod = SrcTFinParameterTypeData%TFinIndMod
   DstTFinParameterTypeData%TFinAFID = SrcTFinParameterTypeData%TFinAFID
   DstTFinParameterTypeData%TFinChord = SrcTFinParameterTypeData%TFinChord
   DstTFinParameterTypeData%TFinKp = SrcTFinParameterTypeData%TFinKp
   DstTFinParameterTypeData%TFinSigma = SrcTFinParameterTypeData%TFinSigma
   DstTFinParameterTypeData%TFinAStar = SrcTFinParameterTypeData%TFinAStar
   DstTFinParameterTypeData%TFinKv = SrcTFinParameterTypeData%TFinKv
   DstTFinParameterTypeData%TFinCDc = SrcTFinParameterTypeData%TFinCDc
end subroutine

subroutine AD_DestroyTFinParameterType(TFinParameterTypeData, ErrStat, ErrMsg)
   type(TFinParameterType), intent(inout) :: TFinParameterTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_DestroyTFinParameterType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AD_PackTFinParameterType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(TFinParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackTFinParameterType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%TFinMod)
   call RegPack(RF, InData%TFinArea)
   call RegPack(RF, InData%TFinIndMod)
   call RegPack(RF, InData%TFinAFID)
   call RegPack(RF, InData%TFinChord)
   call RegPack(RF, InData%TFinKp)
   call RegPack(RF, InData%TFinSigma)
   call RegPack(RF, InData%TFinAStar)
   call RegPack(RF, InData%TFinKv)
   call RegPack(RF, InData%TFinCDc)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackTFinParameterType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(TFinParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackTFinParameterType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%TFinMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinArea); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinIndMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinAFID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinChord); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinKp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinSigma); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinAStar); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinKv); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinCDc); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyTFinInputFileType(SrcTFinInputFileTypeData, DstTFinInputFileTypeData, CtrlCode, ErrStat, ErrMsg)
   type(TFinInputFileType), intent(in) :: SrcTFinInputFileTypeData
   type(TFinInputFileType), intent(inout) :: DstTFinInputFileTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_CopyTFinInputFileType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstTFinInputFileTypeData%TFinMod = SrcTFinInputFileTypeData%TFinMod
   DstTFinInputFileTypeData%TFinArea = SrcTFinInputFileTypeData%TFinArea
   DstTFinInputFileTypeData%TFinRefP_n = SrcTFinInputFileTypeData%TFinRefP_n
   DstTFinInputFileTypeData%TFinAngles = SrcTFinInputFileTypeData%TFinAngles
   DstTFinInputFileTypeData%TFinIndMod = SrcTFinInputFileTypeData%TFinIndMod
   DstTFinInputFileTypeData%TFinAFID = SrcTFinInputFileTypeData%TFinAFID
   DstTFinInputFileTypeData%TFinChord = SrcTFinInputFileTypeData%TFinChord
   DstTFinInputFileTypeData%TFinKp = SrcTFinInputFileTypeData%TFinKp
   DstTFinInputFileTypeData%TFinSigma = SrcTFinInputFileTypeData%TFinSigma
   DstTFinInputFileTypeData%TFinAStar = SrcTFinInputFileTypeData%TFinAStar
   DstTFinInputFileTypeData%TFinKv = SrcTFinInputFileTypeData%TFinKv
   DstTFinInputFileTypeData%TFinCDc = SrcTFinInputFileTypeData%TFinCDc
end subroutine

subroutine AD_DestroyTFinInputFileType(TFinInputFileTypeData, ErrStat, ErrMsg)
   type(TFinInputFileType), intent(inout) :: TFinInputFileTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_DestroyTFinInputFileType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AD_PackTFinInputFileType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(TFinInputFileType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackTFinInputFileType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%TFinMod)
   call RegPack(RF, InData%TFinArea)
   call RegPack(RF, InData%TFinRefP_n)
   call RegPack(RF, InData%TFinAngles)
   call RegPack(RF, InData%TFinIndMod)
   call RegPack(RF, InData%TFinAFID)
   call RegPack(RF, InData%TFinChord)
   call RegPack(RF, InData%TFinKp)
   call RegPack(RF, InData%TFinSigma)
   call RegPack(RF, InData%TFinAStar)
   call RegPack(RF, InData%TFinKv)
   call RegPack(RF, InData%TFinCDc)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackTFinInputFileType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(TFinInputFileType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackTFinInputFileType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%TFinMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinArea); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinRefP_n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinAngles); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinIndMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinAFID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinChord); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinKp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinSigma); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinAStar); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinKv); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinCDc); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyVTK_BLSurfaceType(SrcVTK_BLSurfaceTypeData, DstVTK_BLSurfaceTypeData, CtrlCode, ErrStat, ErrMsg)
   type(AD_VTK_BLSurfaceType), intent(in) :: SrcVTK_BLSurfaceTypeData
   type(AD_VTK_BLSurfaceType), intent(inout) :: DstVTK_BLSurfaceTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AD_CopyVTK_BLSurfaceType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcVTK_BLSurfaceTypeData%AirfoilCoords)) then
      LB(1:3) = lbound(SrcVTK_BLSurfaceTypeData%AirfoilCoords)
      UB(1:3) = ubound(SrcVTK_BLSurfaceTypeData%AirfoilCoords)
      if (.not. allocated(DstVTK_BLSurfaceTypeData%AirfoilCoords)) then
         allocate(DstVTK_BLSurfaceTypeData%AirfoilCoords(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_BLSurfaceTypeData%AirfoilCoords.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVTK_BLSurfaceTypeData%AirfoilCoords = SrcVTK_BLSurfaceTypeData%AirfoilCoords
   end if
end subroutine

subroutine AD_DestroyVTK_BLSurfaceType(VTK_BLSurfaceTypeData, ErrStat, ErrMsg)
   type(AD_VTK_BLSurfaceType), intent(inout) :: VTK_BLSurfaceTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_DestroyVTK_BLSurfaceType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(VTK_BLSurfaceTypeData%AirfoilCoords)) then
      deallocate(VTK_BLSurfaceTypeData%AirfoilCoords)
   end if
end subroutine

subroutine AD_PackVTK_BLSurfaceType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_VTK_BLSurfaceType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackVTK_BLSurfaceType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%AirfoilCoords)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackVTK_BLSurfaceType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_VTK_BLSurfaceType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackVTK_BLSurfaceType'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%AirfoilCoords); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyVTK_RotSurfaceType(SrcVTK_RotSurfaceTypeData, DstVTK_RotSurfaceTypeData, CtrlCode, ErrStat, ErrMsg)
   type(AD_VTK_RotSurfaceType), intent(in) :: SrcVTK_RotSurfaceTypeData
   type(AD_VTK_RotSurfaceType), intent(inout) :: DstVTK_RotSurfaceTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyVTK_RotSurfaceType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcVTK_RotSurfaceTypeData%BladeShape)) then
      LB(1:1) = lbound(SrcVTK_RotSurfaceTypeData%BladeShape)
      UB(1:1) = ubound(SrcVTK_RotSurfaceTypeData%BladeShape)
      if (.not. allocated(DstVTK_RotSurfaceTypeData%BladeShape)) then
         allocate(DstVTK_RotSurfaceTypeData%BladeShape(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_RotSurfaceTypeData%BladeShape.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyVTK_BLSurfaceType(SrcVTK_RotSurfaceTypeData%BladeShape(i1), DstVTK_RotSurfaceTypeData%BladeShape(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcVTK_RotSurfaceTypeData%TowerRad)) then
      LB(1:1) = lbound(SrcVTK_RotSurfaceTypeData%TowerRad)
      UB(1:1) = ubound(SrcVTK_RotSurfaceTypeData%TowerRad)
      if (.not. allocated(DstVTK_RotSurfaceTypeData%TowerRad)) then
         allocate(DstVTK_RotSurfaceTypeData%TowerRad(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstVTK_RotSurfaceTypeData%TowerRad.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstVTK_RotSurfaceTypeData%TowerRad = SrcVTK_RotSurfaceTypeData%TowerRad
   end if
end subroutine

subroutine AD_DestroyVTK_RotSurfaceType(VTK_RotSurfaceTypeData, ErrStat, ErrMsg)
   type(AD_VTK_RotSurfaceType), intent(inout) :: VTK_RotSurfaceTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyVTK_RotSurfaceType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(VTK_RotSurfaceTypeData%BladeShape)) then
      LB(1:1) = lbound(VTK_RotSurfaceTypeData%BladeShape)
      UB(1:1) = ubound(VTK_RotSurfaceTypeData%BladeShape)
      do i1 = LB(1), UB(1)
         call AD_DestroyVTK_BLSurfaceType(VTK_RotSurfaceTypeData%BladeShape(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(VTK_RotSurfaceTypeData%BladeShape)
   end if
   if (allocated(VTK_RotSurfaceTypeData%TowerRad)) then
      deallocate(VTK_RotSurfaceTypeData%TowerRad)
   end if
end subroutine

subroutine AD_PackVTK_RotSurfaceType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_VTK_RotSurfaceType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackVTK_RotSurfaceType'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%BladeShape))
   if (allocated(InData%BladeShape)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeShape), ubound(InData%BladeShape))
      LB(1:1) = lbound(InData%BladeShape)
      UB(1:1) = ubound(InData%BladeShape)
      do i1 = LB(1), UB(1)
         call AD_PackVTK_BLSurfaceType(RF, InData%BladeShape(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%TowerRad)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackVTK_RotSurfaceType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_VTK_RotSurfaceType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackVTK_RotSurfaceType'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%BladeShape)) deallocate(OutData%BladeShape)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeShape(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeShape.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackVTK_BLSurfaceType(RF, OutData%BladeShape(i1)) ! BladeShape 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%TowerRad); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyRotInitInputType(SrcRotInitInputTypeData, DstRotInitInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(RotInitInputType), intent(in) :: SrcRotInitInputTypeData
   type(RotInitInputType), intent(inout) :: DstRotInitInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AD_CopyRotInitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstRotInitInputTypeData%NumBlades = SrcRotInitInputTypeData%NumBlades
   DstRotInitInputTypeData%originInit = SrcRotInitInputTypeData%originInit
   DstRotInitInputTypeData%HubPosition = SrcRotInitInputTypeData%HubPosition
   DstRotInitInputTypeData%HubOrientation = SrcRotInitInputTypeData%HubOrientation
   if (allocated(SrcRotInitInputTypeData%BladeRootPosition)) then
      LB(1:2) = lbound(SrcRotInitInputTypeData%BladeRootPosition)
      UB(1:2) = ubound(SrcRotInitInputTypeData%BladeRootPosition)
      if (.not. allocated(DstRotInitInputTypeData%BladeRootPosition)) then
         allocate(DstRotInitInputTypeData%BladeRootPosition(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitInputTypeData%BladeRootPosition.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInitInputTypeData%BladeRootPosition = SrcRotInitInputTypeData%BladeRootPosition
   end if
   if (allocated(SrcRotInitInputTypeData%BladeRootOrientation)) then
      LB(1:3) = lbound(SrcRotInitInputTypeData%BladeRootOrientation)
      UB(1:3) = ubound(SrcRotInitInputTypeData%BladeRootOrientation)
      if (.not. allocated(DstRotInitInputTypeData%BladeRootOrientation)) then
         allocate(DstRotInitInputTypeData%BladeRootOrientation(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitInputTypeData%BladeRootOrientation.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInitInputTypeData%BladeRootOrientation = SrcRotInitInputTypeData%BladeRootOrientation
   end if
   DstRotInitInputTypeData%NacellePosition = SrcRotInitInputTypeData%NacellePosition
   DstRotInitInputTypeData%NacelleOrientation = SrcRotInitInputTypeData%NacelleOrientation
   DstRotInitInputTypeData%AeroProjMod = SrcRotInitInputTypeData%AeroProjMod
   DstRotInitInputTypeData%RotSpeed = SrcRotInitInputTypeData%RotSpeed
end subroutine

subroutine AD_DestroyRotInitInputType(RotInitInputTypeData, ErrStat, ErrMsg)
   type(RotInitInputType), intent(inout) :: RotInitInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_DestroyRotInitInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(RotInitInputTypeData%BladeRootPosition)) then
      deallocate(RotInitInputTypeData%BladeRootPosition)
   end if
   if (allocated(RotInitInputTypeData%BladeRootOrientation)) then
      deallocate(RotInitInputTypeData%BladeRootOrientation)
   end if
end subroutine

subroutine AD_PackRotInitInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(RotInitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackRotInitInputType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NumBlades)
   call RegPack(RF, InData%originInit)
   call RegPack(RF, InData%HubPosition)
   call RegPack(RF, InData%HubOrientation)
   call RegPackAlloc(RF, InData%BladeRootPosition)
   call RegPackAlloc(RF, InData%BladeRootOrientation)
   call RegPack(RF, InData%NacellePosition)
   call RegPack(RF, InData%NacelleOrientation)
   call RegPack(RF, InData%AeroProjMod)
   call RegPack(RF, InData%RotSpeed)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackRotInitInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(RotInitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackRotInitInputType'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NumBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%originInit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubPosition); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubOrientation); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BladeRootPosition); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BladeRootOrientation); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacellePosition); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacelleOrientation); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AeroProjMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(AD_InitInputType), intent(in) :: SrcInitInputData
   type(AD_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitInputData%rotors)) then
      LB(1:1) = lbound(SrcInitInputData%rotors)
      UB(1:1) = ubound(SrcInitInputData%rotors)
      if (.not. allocated(DstInitInputData%rotors)) then
         allocate(DstInitInputData%rotors(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%rotors.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyRotInitInputType(SrcInitInputData%rotors(i1), DstInitInputData%rotors(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%UsePrimaryInputFile = SrcInitInputData%UsePrimaryInputFile
   call NWTC_Library_CopyFileInfoType(SrcInitInputData%PassedPrimaryInputData, DstInitInputData%PassedPrimaryInputData, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%Linearize = SrcInitInputData%Linearize
   DstInitInputData%CompAeroMaps = SrcInitInputData%CompAeroMaps
   DstInitInputData%Gravity = SrcInitInputData%Gravity
   DstInitInputData%MHK = SrcInitInputData%MHK
   DstInitInputData%defFldDens = SrcInitInputData%defFldDens
   DstInitInputData%defKinVisc = SrcInitInputData%defKinVisc
   DstInitInputData%defSpdSound = SrcInitInputData%defSpdSound
   DstInitInputData%defPatm = SrcInitInputData%defPatm
   DstInitInputData%defPvap = SrcInitInputData%defPvap
   DstInitInputData%WtrDpth = SrcInitInputData%WtrDpth
   DstInitInputData%MSL2SWL = SrcInitInputData%MSL2SWL
   DstInitInputData%FlowField => SrcInitInputData%FlowField
end subroutine

subroutine AD_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(AD_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%rotors)) then
      LB(1:1) = lbound(InitInputData%rotors)
      UB(1:1) = ubound(InitInputData%rotors)
      do i1 = LB(1), UB(1)
         call AD_DestroyRotInitInputType(InitInputData%rotors(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%rotors)
   end if
   call NWTC_Library_DestroyFileInfoType(InitInputData%PassedPrimaryInputData, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   nullify(InitInputData%FlowField)
end subroutine

subroutine AD_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackInitInput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%rotors))
   if (allocated(InData%rotors)) then
      call RegPackBounds(RF, 1, lbound(InData%rotors), ubound(InData%rotors))
      LB(1:1) = lbound(InData%rotors)
      UB(1:1) = ubound(InData%rotors)
      do i1 = LB(1), UB(1)
         call AD_PackRotInitInputType(RF, InData%rotors(i1)) 
      end do
   end if
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%UsePrimaryInputFile)
   call NWTC_Library_PackFileInfoType(RF, InData%PassedPrimaryInputData) 
   call RegPack(RF, InData%Linearize)
   call RegPack(RF, InData%CompAeroMaps)
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%MHK)
   call RegPack(RF, InData%defFldDens)
   call RegPack(RF, InData%defKinVisc)
   call RegPack(RF, InData%defSpdSound)
   call RegPack(RF, InData%defPatm)
   call RegPack(RF, InData%defPvap)
   call RegPack(RF, InData%WtrDpth)
   call RegPack(RF, InData%MSL2SWL)
   call RegPack(RF, associated(InData%FlowField))
   if (associated(InData%FlowField)) then
      call RegPackPointer(RF, c_loc(InData%FlowField), PtrInIndex)
      if (.not. PtrInIndex) then
         call IfW_FlowField_PackFlowFieldType(RF, InData%FlowField) 
      end if
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackInitInput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%rotors)) deallocate(OutData%rotors)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%rotors(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotors.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackRotInitInputType(RF, OutData%rotors(i1)) ! rotors 
      end do
   end if
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UsePrimaryInputFile); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackFileInfoType(RF, OutData%PassedPrimaryInputData) ! PassedPrimaryInputData 
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompAeroMaps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MHK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%defFldDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%defKinVisc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%defSpdSound); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%defPatm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%defPvap); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MSL2SWL); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%FlowField)) deallocate(OutData%FlowField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%FlowField)
      else
         allocate(OutData%FlowField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FlowField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%FlowField)
         call IfW_FlowField_UnpackFlowFieldType(RF, OutData%FlowField) ! FlowField 
      end if
   else
      OutData%FlowField => null()
   end if
end subroutine

subroutine AD_CopyBladePropsType(SrcBladePropsTypeData, DstBladePropsTypeData, CtrlCode, ErrStat, ErrMsg)
   type(AD_BladePropsType), intent(in) :: SrcBladePropsTypeData
   type(AD_BladePropsType), intent(inout) :: DstBladePropsTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AD_CopyBladePropsType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstBladePropsTypeData%NumBlNds = SrcBladePropsTypeData%NumBlNds
   if (allocated(SrcBladePropsTypeData%BlSpn)) then
      LB(1:1) = lbound(SrcBladePropsTypeData%BlSpn)
      UB(1:1) = ubound(SrcBladePropsTypeData%BlSpn)
      if (.not. allocated(DstBladePropsTypeData%BlSpn)) then
         allocate(DstBladePropsTypeData%BlSpn(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladePropsTypeData%BlSpn.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladePropsTypeData%BlSpn = SrcBladePropsTypeData%BlSpn
   end if
   if (allocated(SrcBladePropsTypeData%BlCrvAC)) then
      LB(1:1) = lbound(SrcBladePropsTypeData%BlCrvAC)
      UB(1:1) = ubound(SrcBladePropsTypeData%BlCrvAC)
      if (.not. allocated(DstBladePropsTypeData%BlCrvAC)) then
         allocate(DstBladePropsTypeData%BlCrvAC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladePropsTypeData%BlCrvAC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladePropsTypeData%BlCrvAC = SrcBladePropsTypeData%BlCrvAC
   end if
   if (allocated(SrcBladePropsTypeData%BlSwpAC)) then
      LB(1:1) = lbound(SrcBladePropsTypeData%BlSwpAC)
      UB(1:1) = ubound(SrcBladePropsTypeData%BlSwpAC)
      if (.not. allocated(DstBladePropsTypeData%BlSwpAC)) then
         allocate(DstBladePropsTypeData%BlSwpAC(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladePropsTypeData%BlSwpAC.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladePropsTypeData%BlSwpAC = SrcBladePropsTypeData%BlSwpAC
   end if
   if (allocated(SrcBladePropsTypeData%BlCrvAng)) then
      LB(1:1) = lbound(SrcBladePropsTypeData%BlCrvAng)
      UB(1:1) = ubound(SrcBladePropsTypeData%BlCrvAng)
      if (.not. allocated(DstBladePropsTypeData%BlCrvAng)) then
         allocate(DstBladePropsTypeData%BlCrvAng(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladePropsTypeData%BlCrvAng.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladePropsTypeData%BlCrvAng = SrcBladePropsTypeData%BlCrvAng
   end if
   if (allocated(SrcBladePropsTypeData%BlTwist)) then
      LB(1:1) = lbound(SrcBladePropsTypeData%BlTwist)
      UB(1:1) = ubound(SrcBladePropsTypeData%BlTwist)
      if (.not. allocated(DstBladePropsTypeData%BlTwist)) then
         allocate(DstBladePropsTypeData%BlTwist(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladePropsTypeData%BlTwist.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladePropsTypeData%BlTwist = SrcBladePropsTypeData%BlTwist
   end if
   if (allocated(SrcBladePropsTypeData%BlChord)) then
      LB(1:1) = lbound(SrcBladePropsTypeData%BlChord)
      UB(1:1) = ubound(SrcBladePropsTypeData%BlChord)
      if (.not. allocated(DstBladePropsTypeData%BlChord)) then
         allocate(DstBladePropsTypeData%BlChord(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladePropsTypeData%BlChord.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladePropsTypeData%BlChord = SrcBladePropsTypeData%BlChord
   end if
   if (allocated(SrcBladePropsTypeData%BlAFID)) then
      LB(1:1) = lbound(SrcBladePropsTypeData%BlAFID)
      UB(1:1) = ubound(SrcBladePropsTypeData%BlAFID)
      if (.not. allocated(DstBladePropsTypeData%BlAFID)) then
         allocate(DstBladePropsTypeData%BlAFID(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladePropsTypeData%BlAFID.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladePropsTypeData%BlAFID = SrcBladePropsTypeData%BlAFID
   end if
   if (allocated(SrcBladePropsTypeData%BlCb)) then
      LB(1:1) = lbound(SrcBladePropsTypeData%BlCb)
      UB(1:1) = ubound(SrcBladePropsTypeData%BlCb)
      if (.not. allocated(DstBladePropsTypeData%BlCb)) then
         allocate(DstBladePropsTypeData%BlCb(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladePropsTypeData%BlCb.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladePropsTypeData%BlCb = SrcBladePropsTypeData%BlCb
   end if
   if (allocated(SrcBladePropsTypeData%BlCenBn)) then
      LB(1:1) = lbound(SrcBladePropsTypeData%BlCenBn)
      UB(1:1) = ubound(SrcBladePropsTypeData%BlCenBn)
      if (.not. allocated(DstBladePropsTypeData%BlCenBn)) then
         allocate(DstBladePropsTypeData%BlCenBn(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladePropsTypeData%BlCenBn.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladePropsTypeData%BlCenBn = SrcBladePropsTypeData%BlCenBn
   end if
   if (allocated(SrcBladePropsTypeData%BlCenBt)) then
      LB(1:1) = lbound(SrcBladePropsTypeData%BlCenBt)
      UB(1:1) = ubound(SrcBladePropsTypeData%BlCenBt)
      if (.not. allocated(DstBladePropsTypeData%BlCenBt)) then
         allocate(DstBladePropsTypeData%BlCenBt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladePropsTypeData%BlCenBt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladePropsTypeData%BlCenBt = SrcBladePropsTypeData%BlCenBt
   end if
end subroutine

subroutine AD_DestroyBladePropsType(BladePropsTypeData, ErrStat, ErrMsg)
   type(AD_BladePropsType), intent(inout) :: BladePropsTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_DestroyBladePropsType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(BladePropsTypeData%BlSpn)) then
      deallocate(BladePropsTypeData%BlSpn)
   end if
   if (allocated(BladePropsTypeData%BlCrvAC)) then
      deallocate(BladePropsTypeData%BlCrvAC)
   end if
   if (allocated(BladePropsTypeData%BlSwpAC)) then
      deallocate(BladePropsTypeData%BlSwpAC)
   end if
   if (allocated(BladePropsTypeData%BlCrvAng)) then
      deallocate(BladePropsTypeData%BlCrvAng)
   end if
   if (allocated(BladePropsTypeData%BlTwist)) then
      deallocate(BladePropsTypeData%BlTwist)
   end if
   if (allocated(BladePropsTypeData%BlChord)) then
      deallocate(BladePropsTypeData%BlChord)
   end if
   if (allocated(BladePropsTypeData%BlAFID)) then
      deallocate(BladePropsTypeData%BlAFID)
   end if
   if (allocated(BladePropsTypeData%BlCb)) then
      deallocate(BladePropsTypeData%BlCb)
   end if
   if (allocated(BladePropsTypeData%BlCenBn)) then
      deallocate(BladePropsTypeData%BlCenBn)
   end if
   if (allocated(BladePropsTypeData%BlCenBt)) then
      deallocate(BladePropsTypeData%BlCenBt)
   end if
end subroutine

subroutine AD_PackBladePropsType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_BladePropsType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackBladePropsType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NumBlNds)
   call RegPackAlloc(RF, InData%BlSpn)
   call RegPackAlloc(RF, InData%BlCrvAC)
   call RegPackAlloc(RF, InData%BlSwpAC)
   call RegPackAlloc(RF, InData%BlCrvAng)
   call RegPackAlloc(RF, InData%BlTwist)
   call RegPackAlloc(RF, InData%BlChord)
   call RegPackAlloc(RF, InData%BlAFID)
   call RegPackAlloc(RF, InData%BlCb)
   call RegPackAlloc(RF, InData%BlCenBn)
   call RegPackAlloc(RF, InData%BlCenBt)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackBladePropsType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_BladePropsType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackBladePropsType'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NumBlNds); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlSpn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlCrvAC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlSwpAC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlCrvAng); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlTwist); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlChord); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlAFID); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlCb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlCenBn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlCenBt); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyBladeShape(SrcBladeShapeData, DstBladeShapeData, CtrlCode, ErrStat, ErrMsg)
   type(AD_BladeShape), intent(in) :: SrcBladeShapeData
   type(AD_BladeShape), intent(inout) :: DstBladeShapeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AD_CopyBladeShape'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcBladeShapeData%AirfoilCoords)) then
      LB(1:3) = lbound(SrcBladeShapeData%AirfoilCoords)
      UB(1:3) = ubound(SrcBladeShapeData%AirfoilCoords)
      if (.not. allocated(DstBladeShapeData%AirfoilCoords)) then
         allocate(DstBladeShapeData%AirfoilCoords(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeShapeData%AirfoilCoords.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeShapeData%AirfoilCoords = SrcBladeShapeData%AirfoilCoords
   end if
end subroutine

subroutine AD_DestroyBladeShape(BladeShapeData, ErrStat, ErrMsg)
   type(AD_BladeShape), intent(inout) :: BladeShapeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_DestroyBladeShape'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(BladeShapeData%AirfoilCoords)) then
      deallocate(BladeShapeData%AirfoilCoords)
   end if
end subroutine

subroutine AD_PackBladeShape(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_BladeShape), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackBladeShape'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%AirfoilCoords)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackBladeShape(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_BladeShape), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackBladeShape'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%AirfoilCoords); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyRotInitOutputType(SrcRotInitOutputTypeData, DstRotInitOutputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(RotInitOutputType), intent(in) :: SrcRotInitOutputTypeData
   type(RotInitOutputType), intent(inout) :: DstRotInitOutputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyRotInitOutputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstRotInitOutputTypeData%AirDens = SrcRotInitOutputTypeData%AirDens
   if (allocated(SrcRotInitOutputTypeData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcRotInitOutputTypeData%WriteOutputHdr)
      UB(1:1) = ubound(SrcRotInitOutputTypeData%WriteOutputHdr)
      if (.not. allocated(DstRotInitOutputTypeData%WriteOutputHdr)) then
         allocate(DstRotInitOutputTypeData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitOutputTypeData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInitOutputTypeData%WriteOutputHdr = SrcRotInitOutputTypeData%WriteOutputHdr
   end if
   if (allocated(SrcRotInitOutputTypeData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcRotInitOutputTypeData%WriteOutputUnt)
      UB(1:1) = ubound(SrcRotInitOutputTypeData%WriteOutputUnt)
      if (.not. allocated(DstRotInitOutputTypeData%WriteOutputUnt)) then
         allocate(DstRotInitOutputTypeData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitOutputTypeData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInitOutputTypeData%WriteOutputUnt = SrcRotInitOutputTypeData%WriteOutputUnt
   end if
   if (allocated(SrcRotInitOutputTypeData%BladeShape)) then
      LB(1:1) = lbound(SrcRotInitOutputTypeData%BladeShape)
      UB(1:1) = ubound(SrcRotInitOutputTypeData%BladeShape)
      if (.not. allocated(DstRotInitOutputTypeData%BladeShape)) then
         allocate(DstRotInitOutputTypeData%BladeShape(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitOutputTypeData%BladeShape.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyBladeShape(SrcRotInitOutputTypeData%BladeShape(i1), DstRotInitOutputTypeData%BladeShape(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcRotInitOutputTypeData%LinNames_y)) then
      LB(1:1) = lbound(SrcRotInitOutputTypeData%LinNames_y)
      UB(1:1) = ubound(SrcRotInitOutputTypeData%LinNames_y)
      if (.not. allocated(DstRotInitOutputTypeData%LinNames_y)) then
         allocate(DstRotInitOutputTypeData%LinNames_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitOutputTypeData%LinNames_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInitOutputTypeData%LinNames_y = SrcRotInitOutputTypeData%LinNames_y
   end if
   if (allocated(SrcRotInitOutputTypeData%LinNames_x)) then
      LB(1:1) = lbound(SrcRotInitOutputTypeData%LinNames_x)
      UB(1:1) = ubound(SrcRotInitOutputTypeData%LinNames_x)
      if (.not. allocated(DstRotInitOutputTypeData%LinNames_x)) then
         allocate(DstRotInitOutputTypeData%LinNames_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitOutputTypeData%LinNames_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInitOutputTypeData%LinNames_x = SrcRotInitOutputTypeData%LinNames_x
   end if
   if (allocated(SrcRotInitOutputTypeData%LinNames_u)) then
      LB(1:1) = lbound(SrcRotInitOutputTypeData%LinNames_u)
      UB(1:1) = ubound(SrcRotInitOutputTypeData%LinNames_u)
      if (.not. allocated(DstRotInitOutputTypeData%LinNames_u)) then
         allocate(DstRotInitOutputTypeData%LinNames_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitOutputTypeData%LinNames_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInitOutputTypeData%LinNames_u = SrcRotInitOutputTypeData%LinNames_u
   end if
   if (allocated(SrcRotInitOutputTypeData%RotFrame_y)) then
      LB(1:1) = lbound(SrcRotInitOutputTypeData%RotFrame_y)
      UB(1:1) = ubound(SrcRotInitOutputTypeData%RotFrame_y)
      if (.not. allocated(DstRotInitOutputTypeData%RotFrame_y)) then
         allocate(DstRotInitOutputTypeData%RotFrame_y(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitOutputTypeData%RotFrame_y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInitOutputTypeData%RotFrame_y = SrcRotInitOutputTypeData%RotFrame_y
   end if
   if (allocated(SrcRotInitOutputTypeData%RotFrame_x)) then
      LB(1:1) = lbound(SrcRotInitOutputTypeData%RotFrame_x)
      UB(1:1) = ubound(SrcRotInitOutputTypeData%RotFrame_x)
      if (.not. allocated(DstRotInitOutputTypeData%RotFrame_x)) then
         allocate(DstRotInitOutputTypeData%RotFrame_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitOutputTypeData%RotFrame_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInitOutputTypeData%RotFrame_x = SrcRotInitOutputTypeData%RotFrame_x
   end if
   if (allocated(SrcRotInitOutputTypeData%RotFrame_u)) then
      LB(1:1) = lbound(SrcRotInitOutputTypeData%RotFrame_u)
      UB(1:1) = ubound(SrcRotInitOutputTypeData%RotFrame_u)
      if (.not. allocated(DstRotInitOutputTypeData%RotFrame_u)) then
         allocate(DstRotInitOutputTypeData%RotFrame_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitOutputTypeData%RotFrame_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInitOutputTypeData%RotFrame_u = SrcRotInitOutputTypeData%RotFrame_u
   end if
   if (allocated(SrcRotInitOutputTypeData%IsLoad_u)) then
      LB(1:1) = lbound(SrcRotInitOutputTypeData%IsLoad_u)
      UB(1:1) = ubound(SrcRotInitOutputTypeData%IsLoad_u)
      if (.not. allocated(DstRotInitOutputTypeData%IsLoad_u)) then
         allocate(DstRotInitOutputTypeData%IsLoad_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitOutputTypeData%IsLoad_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInitOutputTypeData%IsLoad_u = SrcRotInitOutputTypeData%IsLoad_u
   end if
   if (allocated(SrcRotInitOutputTypeData%BladeProps)) then
      LB(1:1) = lbound(SrcRotInitOutputTypeData%BladeProps)
      UB(1:1) = ubound(SrcRotInitOutputTypeData%BladeProps)
      if (.not. allocated(DstRotInitOutputTypeData%BladeProps)) then
         allocate(DstRotInitOutputTypeData%BladeProps(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitOutputTypeData%BladeProps.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyBladePropsType(SrcRotInitOutputTypeData%BladeProps(i1), DstRotInitOutputTypeData%BladeProps(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcRotInitOutputTypeData%DerivOrder_x)) then
      LB(1:1) = lbound(SrcRotInitOutputTypeData%DerivOrder_x)
      UB(1:1) = ubound(SrcRotInitOutputTypeData%DerivOrder_x)
      if (.not. allocated(DstRotInitOutputTypeData%DerivOrder_x)) then
         allocate(DstRotInitOutputTypeData%DerivOrder_x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitOutputTypeData%DerivOrder_x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInitOutputTypeData%DerivOrder_x = SrcRotInitOutputTypeData%DerivOrder_x
   end if
   if (allocated(SrcRotInitOutputTypeData%TwrElev)) then
      LB(1:1) = lbound(SrcRotInitOutputTypeData%TwrElev)
      UB(1:1) = ubound(SrcRotInitOutputTypeData%TwrElev)
      if (.not. allocated(DstRotInitOutputTypeData%TwrElev)) then
         allocate(DstRotInitOutputTypeData%TwrElev(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitOutputTypeData%TwrElev.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInitOutputTypeData%TwrElev = SrcRotInitOutputTypeData%TwrElev
   end if
   if (allocated(SrcRotInitOutputTypeData%TwrDiam)) then
      LB(1:1) = lbound(SrcRotInitOutputTypeData%TwrDiam)
      UB(1:1) = ubound(SrcRotInitOutputTypeData%TwrDiam)
      if (.not. allocated(DstRotInitOutputTypeData%TwrDiam)) then
         allocate(DstRotInitOutputTypeData%TwrDiam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInitOutputTypeData%TwrDiam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInitOutputTypeData%TwrDiam = SrcRotInitOutputTypeData%TwrDiam
   end if
end subroutine

subroutine AD_DestroyRotInitOutputType(RotInitOutputTypeData, ErrStat, ErrMsg)
   type(RotInitOutputType), intent(inout) :: RotInitOutputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyRotInitOutputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(RotInitOutputTypeData%WriteOutputHdr)) then
      deallocate(RotInitOutputTypeData%WriteOutputHdr)
   end if
   if (allocated(RotInitOutputTypeData%WriteOutputUnt)) then
      deallocate(RotInitOutputTypeData%WriteOutputUnt)
   end if
   if (allocated(RotInitOutputTypeData%BladeShape)) then
      LB(1:1) = lbound(RotInitOutputTypeData%BladeShape)
      UB(1:1) = ubound(RotInitOutputTypeData%BladeShape)
      do i1 = LB(1), UB(1)
         call AD_DestroyBladeShape(RotInitOutputTypeData%BladeShape(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotInitOutputTypeData%BladeShape)
   end if
   if (allocated(RotInitOutputTypeData%LinNames_y)) then
      deallocate(RotInitOutputTypeData%LinNames_y)
   end if
   if (allocated(RotInitOutputTypeData%LinNames_x)) then
      deallocate(RotInitOutputTypeData%LinNames_x)
   end if
   if (allocated(RotInitOutputTypeData%LinNames_u)) then
      deallocate(RotInitOutputTypeData%LinNames_u)
   end if
   if (allocated(RotInitOutputTypeData%RotFrame_y)) then
      deallocate(RotInitOutputTypeData%RotFrame_y)
   end if
   if (allocated(RotInitOutputTypeData%RotFrame_x)) then
      deallocate(RotInitOutputTypeData%RotFrame_x)
   end if
   if (allocated(RotInitOutputTypeData%RotFrame_u)) then
      deallocate(RotInitOutputTypeData%RotFrame_u)
   end if
   if (allocated(RotInitOutputTypeData%IsLoad_u)) then
      deallocate(RotInitOutputTypeData%IsLoad_u)
   end if
   if (allocated(RotInitOutputTypeData%BladeProps)) then
      LB(1:1) = lbound(RotInitOutputTypeData%BladeProps)
      UB(1:1) = ubound(RotInitOutputTypeData%BladeProps)
      do i1 = LB(1), UB(1)
         call AD_DestroyBladePropsType(RotInitOutputTypeData%BladeProps(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotInitOutputTypeData%BladeProps)
   end if
   if (allocated(RotInitOutputTypeData%DerivOrder_x)) then
      deallocate(RotInitOutputTypeData%DerivOrder_x)
   end if
   if (allocated(RotInitOutputTypeData%TwrElev)) then
      deallocate(RotInitOutputTypeData%TwrElev)
   end if
   if (allocated(RotInitOutputTypeData%TwrDiam)) then
      deallocate(RotInitOutputTypeData%TwrDiam)
   end if
end subroutine

subroutine AD_PackRotInitOutputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(RotInitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackRotInitOutputType'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%AirDens)
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call RegPack(RF, allocated(InData%BladeShape))
   if (allocated(InData%BladeShape)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeShape), ubound(InData%BladeShape))
      LB(1:1) = lbound(InData%BladeShape)
      UB(1:1) = ubound(InData%BladeShape)
      do i1 = LB(1), UB(1)
         call AD_PackBladeShape(RF, InData%BladeShape(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%LinNames_y)
   call RegPackAlloc(RF, InData%LinNames_x)
   call RegPackAlloc(RF, InData%LinNames_u)
   call RegPackAlloc(RF, InData%RotFrame_y)
   call RegPackAlloc(RF, InData%RotFrame_x)
   call RegPackAlloc(RF, InData%RotFrame_u)
   call RegPackAlloc(RF, InData%IsLoad_u)
   call RegPack(RF, allocated(InData%BladeProps))
   if (allocated(InData%BladeProps)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeProps), ubound(InData%BladeProps))
      LB(1:1) = lbound(InData%BladeProps)
      UB(1:1) = ubound(InData%BladeProps)
      do i1 = LB(1), UB(1)
         call AD_PackBladePropsType(RF, InData%BladeProps(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%DerivOrder_x)
   call RegPackAlloc(RF, InData%TwrElev)
   call RegPackAlloc(RF, InData%TwrDiam)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackRotInitOutputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(RotInitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackRotInitOutputType'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%AirDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BladeShape)) deallocate(OutData%BladeShape)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeShape(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeShape.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackBladeShape(RF, OutData%BladeShape(i1)) ! BladeShape 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%LinNames_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LinNames_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RotFrame_u); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IsLoad_u); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BladeProps)) deallocate(OutData%BladeProps)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeProps(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeProps.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackBladePropsType(RF, OutData%BladeProps(i1)) ! BladeProps 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%DerivOrder_x); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrElev); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrDiam); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(AD_InitOutputType), intent(in) :: SrcInitOutputData
   type(AD_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%rotors)) then
      LB(1:1) = lbound(SrcInitOutputData%rotors)
      UB(1:1) = ubound(SrcInitOutputData%rotors)
      if (.not. allocated(DstInitOutputData%rotors)) then
         allocate(DstInitOutputData%rotors(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%rotors.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyRotInitOutputType(SrcInitOutputData%rotors(i1), DstInitOutputData%rotors(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitOutputData%nNodesVel = SrcInitOutputData%nNodesVel
end subroutine

subroutine AD_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(AD_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%rotors)) then
      LB(1:1) = lbound(InitOutputData%rotors)
      UB(1:1) = ubound(InitOutputData%rotors)
      do i1 = LB(1), UB(1)
         call AD_DestroyRotInitOutputType(InitOutputData%rotors(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitOutputData%rotors)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AD_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackInitOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%rotors))
   if (allocated(InData%rotors)) then
      call RegPackBounds(RF, 1, lbound(InData%rotors), ubound(InData%rotors))
      LB(1:1) = lbound(InData%rotors)
      UB(1:1) = ubound(InData%rotors)
      do i1 = LB(1), UB(1)
         call AD_PackRotInitOutputType(RF, InData%rotors(i1)) 
      end do
   end if
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPack(RF, InData%nNodesVel)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackInitOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%rotors)) deallocate(OutData%rotors)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%rotors(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotors.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackRotInitOutputType(RF, OutData%rotors(i1)) ! rotors 
      end do
   end if
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpack(RF, OutData%nNodesVel); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyRotInputFile(SrcRotInputFileData, DstRotInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(RotInputFile), intent(in) :: SrcRotInputFileData
   type(RotInputFile), intent(inout) :: DstRotInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyRotInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcRotInputFileData%BladeProps)) then
      LB(1:1) = lbound(SrcRotInputFileData%BladeProps)
      UB(1:1) = ubound(SrcRotInputFileData%BladeProps)
      if (.not. allocated(DstRotInputFileData%BladeProps)) then
         allocate(DstRotInputFileData%BladeProps(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInputFileData%BladeProps.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyBladePropsType(SrcRotInputFileData%BladeProps(i1), DstRotInputFileData%BladeProps(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstRotInputFileData%NumTwrNds = SrcRotInputFileData%NumTwrNds
   if (allocated(SrcRotInputFileData%TwrElev)) then
      LB(1:1) = lbound(SrcRotInputFileData%TwrElev)
      UB(1:1) = ubound(SrcRotInputFileData%TwrElev)
      if (.not. allocated(DstRotInputFileData%TwrElev)) then
         allocate(DstRotInputFileData%TwrElev(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInputFileData%TwrElev.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInputFileData%TwrElev = SrcRotInputFileData%TwrElev
   end if
   if (allocated(SrcRotInputFileData%TwrDiam)) then
      LB(1:1) = lbound(SrcRotInputFileData%TwrDiam)
      UB(1:1) = ubound(SrcRotInputFileData%TwrDiam)
      if (.not. allocated(DstRotInputFileData%TwrDiam)) then
         allocate(DstRotInputFileData%TwrDiam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInputFileData%TwrDiam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInputFileData%TwrDiam = SrcRotInputFileData%TwrDiam
   end if
   if (allocated(SrcRotInputFileData%TwrCd)) then
      LB(1:1) = lbound(SrcRotInputFileData%TwrCd)
      UB(1:1) = ubound(SrcRotInputFileData%TwrCd)
      if (.not. allocated(DstRotInputFileData%TwrCd)) then
         allocate(DstRotInputFileData%TwrCd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInputFileData%TwrCd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInputFileData%TwrCd = SrcRotInputFileData%TwrCd
   end if
   if (allocated(SrcRotInputFileData%TwrTI)) then
      LB(1:1) = lbound(SrcRotInputFileData%TwrTI)
      UB(1:1) = ubound(SrcRotInputFileData%TwrTI)
      if (.not. allocated(DstRotInputFileData%TwrTI)) then
         allocate(DstRotInputFileData%TwrTI(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInputFileData%TwrTI.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInputFileData%TwrTI = SrcRotInputFileData%TwrTI
   end if
   if (allocated(SrcRotInputFileData%TwrCb)) then
      LB(1:1) = lbound(SrcRotInputFileData%TwrCb)
      UB(1:1) = ubound(SrcRotInputFileData%TwrCb)
      if (.not. allocated(DstRotInputFileData%TwrCb)) then
         allocate(DstRotInputFileData%TwrCb(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInputFileData%TwrCb.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInputFileData%TwrCb = SrcRotInputFileData%TwrCb
   end if
   DstRotInputFileData%VolHub = SrcRotInputFileData%VolHub
   DstRotInputFileData%HubCenBx = SrcRotInputFileData%HubCenBx
   DstRotInputFileData%VolNac = SrcRotInputFileData%VolNac
   DstRotInputFileData%NacCenB = SrcRotInputFileData%NacCenB
   DstRotInputFileData%NacArea = SrcRotInputFileData%NacArea
   DstRotInputFileData%NacCd = SrcRotInputFileData%NacCd
   DstRotInputFileData%NacDragAC = SrcRotInputFileData%NacDragAC
   DstRotInputFileData%TFinAero = SrcRotInputFileData%TFinAero
   DstRotInputFileData%TFinFile = SrcRotInputFileData%TFinFile
   call AD_CopyTFinInputFileType(SrcRotInputFileData%TFin, DstRotInputFileData%TFin, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine AD_DestroyRotInputFile(RotInputFileData, ErrStat, ErrMsg)
   type(RotInputFile), intent(inout) :: RotInputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyRotInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(RotInputFileData%BladeProps)) then
      LB(1:1) = lbound(RotInputFileData%BladeProps)
      UB(1:1) = ubound(RotInputFileData%BladeProps)
      do i1 = LB(1), UB(1)
         call AD_DestroyBladePropsType(RotInputFileData%BladeProps(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotInputFileData%BladeProps)
   end if
   if (allocated(RotInputFileData%TwrElev)) then
      deallocate(RotInputFileData%TwrElev)
   end if
   if (allocated(RotInputFileData%TwrDiam)) then
      deallocate(RotInputFileData%TwrDiam)
   end if
   if (allocated(RotInputFileData%TwrCd)) then
      deallocate(RotInputFileData%TwrCd)
   end if
   if (allocated(RotInputFileData%TwrTI)) then
      deallocate(RotInputFileData%TwrTI)
   end if
   if (allocated(RotInputFileData%TwrCb)) then
      deallocate(RotInputFileData%TwrCb)
   end if
   call AD_DestroyTFinInputFileType(RotInputFileData%TFin, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AD_PackRotInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(RotInputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackRotInputFile'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%BladeProps))
   if (allocated(InData%BladeProps)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeProps), ubound(InData%BladeProps))
      LB(1:1) = lbound(InData%BladeProps)
      UB(1:1) = ubound(InData%BladeProps)
      do i1 = LB(1), UB(1)
         call AD_PackBladePropsType(RF, InData%BladeProps(i1)) 
      end do
   end if
   call RegPack(RF, InData%NumTwrNds)
   call RegPackAlloc(RF, InData%TwrElev)
   call RegPackAlloc(RF, InData%TwrDiam)
   call RegPackAlloc(RF, InData%TwrCd)
   call RegPackAlloc(RF, InData%TwrTI)
   call RegPackAlloc(RF, InData%TwrCb)
   call RegPack(RF, InData%VolHub)
   call RegPack(RF, InData%HubCenBx)
   call RegPack(RF, InData%VolNac)
   call RegPack(RF, InData%NacCenB)
   call RegPack(RF, InData%NacArea)
   call RegPack(RF, InData%NacCd)
   call RegPack(RF, InData%NacDragAC)
   call RegPack(RF, InData%TFinAero)
   call RegPack(RF, InData%TFinFile)
   call AD_PackTFinInputFileType(RF, InData%TFin) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackRotInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(RotInputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackRotInputFile'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%BladeProps)) deallocate(OutData%BladeProps)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeProps(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeProps.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackBladePropsType(RF, OutData%BladeProps(i1)) ! BladeProps 
      end do
   end if
   call RegUnpack(RF, OutData%NumTwrNds); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrElev); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrDiam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrCd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrTI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrCb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VolHub); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubCenBx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VolNac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacCenB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacArea); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacCd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacDragAC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinAero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinFile); if (RegCheckErr(RF, RoutineName)) return
   call AD_UnpackTFinInputFileType(RF, OutData%TFin) ! TFin 
end subroutine

subroutine AD_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(AD_InputFile), intent(in) :: SrcInputFileData
   type(AD_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%Echo = SrcInputFileData%Echo
   DstInputFileData%DTAero = SrcInputFileData%DTAero
   DstInputFileData%Wake_Mod = SrcInputFileData%Wake_Mod
   DstInputFileData%BEM_Mod = SrcInputFileData%BEM_Mod
   DstInputFileData%TwrPotent = SrcInputFileData%TwrPotent
   DstInputFileData%TwrShadow = SrcInputFileData%TwrShadow
   DstInputFileData%TwrAero = SrcInputFileData%TwrAero
   DstInputFileData%CavitCheck = SrcInputFileData%CavitCheck
   DstInputFileData%Buoyancy = SrcInputFileData%Buoyancy
   DstInputFileData%NacelleDrag = SrcInputFileData%NacelleDrag
   DstInputFileData%CompAA = SrcInputFileData%CompAA
   DstInputFileData%AA_InputFile = SrcInputFileData%AA_InputFile
   if (allocated(SrcInputFileData%ADBlFile)) then
      LB(1:1) = lbound(SrcInputFileData%ADBlFile)
      UB(1:1) = ubound(SrcInputFileData%ADBlFile)
      if (.not. allocated(DstInputFileData%ADBlFile)) then
         allocate(DstInputFileData%ADBlFile(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%ADBlFile.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%ADBlFile = SrcInputFileData%ADBlFile
   end if
   DstInputFileData%AirDens = SrcInputFileData%AirDens
   DstInputFileData%KinVisc = SrcInputFileData%KinVisc
   DstInputFileData%Patm = SrcInputFileData%Patm
   DstInputFileData%Pvap = SrcInputFileData%Pvap
   DstInputFileData%SpdSound = SrcInputFileData%SpdSound
   DstInputFileData%Skew_Mod = SrcInputFileData%Skew_Mod
   DstInputFileData%SkewMomCorr = SrcInputFileData%SkewMomCorr
   DstInputFileData%SkewRedistr_Mod = SrcInputFileData%SkewRedistr_Mod
   DstInputFileData%SkewModFactor = SrcInputFileData%SkewModFactor
   DstInputFileData%TipLoss = SrcInputFileData%TipLoss
   DstInputFileData%HubLoss = SrcInputFileData%HubLoss
   DstInputFileData%TanInd = SrcInputFileData%TanInd
   DstInputFileData%AIDrag = SrcInputFileData%AIDrag
   DstInputFileData%TIDrag = SrcInputFileData%TIDrag
   DstInputFileData%IndToler = SrcInputFileData%IndToler
   DstInputFileData%MaxIter = SrcInputFileData%MaxIter
   DstInputFileData%SectAvg = SrcInputFileData%SectAvg
   DstInputFileData%SA_Weighting = SrcInputFileData%SA_Weighting
   DstInputFileData%SA_PsiBwd = SrcInputFileData%SA_PsiBwd
   DstInputFileData%SA_PsiFwd = SrcInputFileData%SA_PsiFwd
   DstInputFileData%SA_nPerSec = SrcInputFileData%SA_nPerSec
   DstInputFileData%AoA34 = SrcInputFileData%AoA34
   call UA_CopyInitInput(SrcInputFileData%UA_Init, DstInputFileData%UA_Init, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInputFileData%InCol_Alfa = SrcInputFileData%InCol_Alfa
   DstInputFileData%InCol_Cl = SrcInputFileData%InCol_Cl
   DstInputFileData%InCol_Cd = SrcInputFileData%InCol_Cd
   DstInputFileData%InCol_Cm = SrcInputFileData%InCol_Cm
   DstInputFileData%InCol_Cpmin = SrcInputFileData%InCol_Cpmin
   DstInputFileData%AFTabMod = SrcInputFileData%AFTabMod
   DstInputFileData%NumAFfiles = SrcInputFileData%NumAFfiles
   DstInputFileData%FVWFileName = SrcInputFileData%FVWFileName
   if (allocated(SrcInputFileData%AFNames)) then
      LB(1:1) = lbound(SrcInputFileData%AFNames)
      UB(1:1) = ubound(SrcInputFileData%AFNames)
      if (.not. allocated(DstInputFileData%AFNames)) then
         allocate(DstInputFileData%AFNames(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%AFNames.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%AFNames = SrcInputFileData%AFNames
   end if
   DstInputFileData%UseBlCm = SrcInputFileData%UseBlCm
   DstInputFileData%SumPrint = SrcInputFileData%SumPrint
   DstInputFileData%NBlOuts = SrcInputFileData%NBlOuts
   DstInputFileData%BlOutNd = SrcInputFileData%BlOutNd
   DstInputFileData%NTwOuts = SrcInputFileData%NTwOuts
   DstInputFileData%TwOutNd = SrcInputFileData%TwOutNd
   DstInputFileData%NumOuts = SrcInputFileData%NumOuts
   if (allocated(SrcInputFileData%OutList)) then
      LB(1:1) = lbound(SrcInputFileData%OutList)
      UB(1:1) = ubound(SrcInputFileData%OutList)
      if (.not. allocated(DstInputFileData%OutList)) then
         allocate(DstInputFileData%OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%OutList = SrcInputFileData%OutList
   end if
   DstInputFileData%tau1_const = SrcInputFileData%tau1_const
   DstInputFileData%DBEMT_Mod = SrcInputFileData%DBEMT_Mod
   DstInputFileData%BldNd_NumOuts = SrcInputFileData%BldNd_NumOuts
   if (allocated(SrcInputFileData%BldNd_OutList)) then
      LB(1:1) = lbound(SrcInputFileData%BldNd_OutList)
      UB(1:1) = ubound(SrcInputFileData%BldNd_OutList)
      if (.not. allocated(DstInputFileData%BldNd_OutList)) then
         allocate(DstInputFileData%BldNd_OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%BldNd_OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%BldNd_OutList = SrcInputFileData%BldNd_OutList
   end if
   DstInputFileData%BldNd_BlOutNd_Str = SrcInputFileData%BldNd_BlOutNd_Str
   DstInputFileData%BldNd_BladesOut = SrcInputFileData%BldNd_BladesOut
   DstInputFileData%UAStartRad = SrcInputFileData%UAStartRad
   DstInputFileData%UAEndRad = SrcInputFileData%UAEndRad
   if (allocated(SrcInputFileData%rotors)) then
      LB(1:1) = lbound(SrcInputFileData%rotors)
      UB(1:1) = ubound(SrcInputFileData%rotors)
      if (.not. allocated(DstInputFileData%rotors)) then
         allocate(DstInputFileData%rotors(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%rotors.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyRotInputFile(SrcInputFileData%rotors(i1), DstInputFileData%rotors(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine AD_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(AD_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputFileData%ADBlFile)) then
      deallocate(InputFileData%ADBlFile)
   end if
   call UA_DestroyInitInput(InputFileData%UA_Init, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InputFileData%AFNames)) then
      deallocate(InputFileData%AFNames)
   end if
   if (allocated(InputFileData%OutList)) then
      deallocate(InputFileData%OutList)
   end if
   if (allocated(InputFileData%BldNd_OutList)) then
      deallocate(InputFileData%BldNd_OutList)
   end if
   if (allocated(InputFileData%rotors)) then
      LB(1:1) = lbound(InputFileData%rotors)
      UB(1:1) = ubound(InputFileData%rotors)
      do i1 = LB(1), UB(1)
         call AD_DestroyRotInputFile(InputFileData%rotors(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputFileData%rotors)
   end if
end subroutine

subroutine AD_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackInputFile'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Echo)
   call RegPack(RF, InData%DTAero)
   call RegPack(RF, InData%Wake_Mod)
   call RegPack(RF, InData%BEM_Mod)
   call RegPack(RF, InData%TwrPotent)
   call RegPack(RF, InData%TwrShadow)
   call RegPack(RF, InData%TwrAero)
   call RegPack(RF, InData%CavitCheck)
   call RegPack(RF, InData%Buoyancy)
   call RegPack(RF, InData%NacelleDrag)
   call RegPack(RF, InData%CompAA)
   call RegPack(RF, InData%AA_InputFile)
   call RegPackAlloc(RF, InData%ADBlFile)
   call RegPack(RF, InData%AirDens)
   call RegPack(RF, InData%KinVisc)
   call RegPack(RF, InData%Patm)
   call RegPack(RF, InData%Pvap)
   call RegPack(RF, InData%SpdSound)
   call RegPack(RF, InData%Skew_Mod)
   call RegPack(RF, InData%SkewMomCorr)
   call RegPack(RF, InData%SkewRedistr_Mod)
   call RegPack(RF, InData%SkewModFactor)
   call RegPack(RF, InData%TipLoss)
   call RegPack(RF, InData%HubLoss)
   call RegPack(RF, InData%TanInd)
   call RegPack(RF, InData%AIDrag)
   call RegPack(RF, InData%TIDrag)
   call RegPack(RF, InData%IndToler)
   call RegPack(RF, InData%MaxIter)
   call RegPack(RF, InData%SectAvg)
   call RegPack(RF, InData%SA_Weighting)
   call RegPack(RF, InData%SA_PsiBwd)
   call RegPack(RF, InData%SA_PsiFwd)
   call RegPack(RF, InData%SA_nPerSec)
   call RegPack(RF, InData%AoA34)
   call UA_PackInitInput(RF, InData%UA_Init) 
   call RegPack(RF, InData%InCol_Alfa)
   call RegPack(RF, InData%InCol_Cl)
   call RegPack(RF, InData%InCol_Cd)
   call RegPack(RF, InData%InCol_Cm)
   call RegPack(RF, InData%InCol_Cpmin)
   call RegPack(RF, InData%AFTabMod)
   call RegPack(RF, InData%NumAFfiles)
   call RegPack(RF, InData%FVWFileName)
   call RegPackAlloc(RF, InData%AFNames)
   call RegPack(RF, InData%UseBlCm)
   call RegPack(RF, InData%SumPrint)
   call RegPack(RF, InData%NBlOuts)
   call RegPack(RF, InData%BlOutNd)
   call RegPack(RF, InData%NTwOuts)
   call RegPack(RF, InData%TwOutNd)
   call RegPack(RF, InData%NumOuts)
   call RegPackAlloc(RF, InData%OutList)
   call RegPack(RF, InData%tau1_const)
   call RegPack(RF, InData%DBEMT_Mod)
   call RegPack(RF, InData%BldNd_NumOuts)
   call RegPackAlloc(RF, InData%BldNd_OutList)
   call RegPack(RF, InData%BldNd_BlOutNd_Str)
   call RegPack(RF, InData%BldNd_BladesOut)
   call RegPack(RF, InData%UAStartRad)
   call RegPack(RF, InData%UAEndRad)
   call RegPack(RF, allocated(InData%rotors))
   if (allocated(InData%rotors)) then
      call RegPackBounds(RF, 1, lbound(InData%rotors), ubound(InData%rotors))
      LB(1:1) = lbound(InData%rotors)
      UB(1:1) = ubound(InData%rotors)
      do i1 = LB(1), UB(1)
         call AD_PackRotInputFile(RF, InData%rotors(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackInputFile'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Echo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DTAero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Wake_Mod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BEM_Mod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrPotent); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrShadow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrAero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CavitCheck); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Buoyancy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacelleDrag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompAA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AA_InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ADBlFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AirDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%KinVisc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Patm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Pvap); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SpdSound); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Skew_Mod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SkewMomCorr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SkewRedistr_Mod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SkewModFactor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TipLoss); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubLoss); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TanInd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AIDrag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TIDrag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IndToler); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MaxIter); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SectAvg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SA_Weighting); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SA_PsiBwd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SA_PsiFwd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SA_nPerSec); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AoA34); if (RegCheckErr(RF, RoutineName)) return
   call UA_UnpackInitInput(RF, OutData%UA_Init) ! UA_Init 
   call RegUnpack(RF, OutData%InCol_Alfa); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InCol_Cl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InCol_Cd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InCol_Cm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InCol_Cpmin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AFTabMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumAFfiles); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FVWFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AFNames); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UseBlCm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SumPrint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NBlOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BlOutNd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NTwOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwOutNd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tau1_const); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DBEMT_Mod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BldNd_OutList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_BlOutNd_Str); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_BladesOut); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UAStartRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UAEndRad); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%rotors)) deallocate(OutData%rotors)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%rotors(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotors.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackRotInputFile(RF, OutData%rotors(i1)) ! rotors 
      end do
   end if
end subroutine

subroutine AD_CopyRotContinuousStateType(SrcRotContinuousStateTypeData, DstRotContinuousStateTypeData, CtrlCode, ErrStat, ErrMsg)
   type(RotContinuousStateType), intent(in) :: SrcRotContinuousStateTypeData
   type(RotContinuousStateType), intent(inout) :: DstRotContinuousStateTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyRotContinuousStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call BEMT_CopyContState(SrcRotContinuousStateTypeData%BEMT, DstRotContinuousStateTypeData%BEMT, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AA_CopyContState(SrcRotContinuousStateTypeData%AA, DstRotContinuousStateTypeData%AA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine AD_DestroyRotContinuousStateType(RotContinuousStateTypeData, ErrStat, ErrMsg)
   type(RotContinuousStateType), intent(inout) :: RotContinuousStateTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyRotContinuousStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call BEMT_DestroyContState(RotContinuousStateTypeData%BEMT, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AA_DestroyContState(RotContinuousStateTypeData%AA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AD_PackRotContinuousStateType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(RotContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackRotContinuousStateType'
   if (RF%ErrStat >= AbortErrLev) return
   call BEMT_PackContState(RF, InData%BEMT) 
   call AA_PackContState(RF, InData%AA) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackRotContinuousStateType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(RotContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackRotContinuousStateType'
   if (RF%ErrStat /= ErrID_None) return
   call BEMT_UnpackContState(RF, OutData%BEMT) ! BEMT 
   call AA_UnpackContState(RF, OutData%AA) ! AA 
end subroutine

subroutine AD_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(AD_ContinuousStateType), intent(in) :: SrcContStateData
   type(AD_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcContStateData%rotors)) then
      LB(1:1) = lbound(SrcContStateData%rotors)
      UB(1:1) = ubound(SrcContStateData%rotors)
      if (.not. allocated(DstContStateData%rotors)) then
         allocate(DstContStateData%rotors(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstContStateData%rotors.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyRotContinuousStateType(SrcContStateData%rotors(i1), DstContStateData%rotors(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call FVW_CopyContState(SrcContStateData%FVW, DstContStateData%FVW, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine AD_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(AD_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ContStateData%rotors)) then
      LB(1:1) = lbound(ContStateData%rotors)
      UB(1:1) = ubound(ContStateData%rotors)
      do i1 = LB(1), UB(1)
         call AD_DestroyRotContinuousStateType(ContStateData%rotors(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ContStateData%rotors)
   end if
   call FVW_DestroyContState(ContStateData%FVW, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AD_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackContState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%rotors))
   if (allocated(InData%rotors)) then
      call RegPackBounds(RF, 1, lbound(InData%rotors), ubound(InData%rotors))
      LB(1:1) = lbound(InData%rotors)
      UB(1:1) = ubound(InData%rotors)
      do i1 = LB(1), UB(1)
         call AD_PackRotContinuousStateType(RF, InData%rotors(i1)) 
      end do
   end if
   call FVW_PackContState(RF, InData%FVW) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackContState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%rotors)) deallocate(OutData%rotors)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%rotors(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotors.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackRotContinuousStateType(RF, OutData%rotors(i1)) ! rotors 
      end do
   end if
   call FVW_UnpackContState(RF, OutData%FVW) ! FVW 
end subroutine

subroutine AD_CopyRotDiscreteStateType(SrcRotDiscreteStateTypeData, DstRotDiscreteStateTypeData, CtrlCode, ErrStat, ErrMsg)
   type(RotDiscreteStateType), intent(in) :: SrcRotDiscreteStateTypeData
   type(RotDiscreteStateType), intent(inout) :: DstRotDiscreteStateTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyRotDiscreteStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call BEMT_CopyDiscState(SrcRotDiscreteStateTypeData%BEMT, DstRotDiscreteStateTypeData%BEMT, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AA_CopyDiscState(SrcRotDiscreteStateTypeData%AA, DstRotDiscreteStateTypeData%AA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine AD_DestroyRotDiscreteStateType(RotDiscreteStateTypeData, ErrStat, ErrMsg)
   type(RotDiscreteStateType), intent(inout) :: RotDiscreteStateTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyRotDiscreteStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call BEMT_DestroyDiscState(RotDiscreteStateTypeData%BEMT, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AA_DestroyDiscState(RotDiscreteStateTypeData%AA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AD_PackRotDiscreteStateType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(RotDiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackRotDiscreteStateType'
   if (RF%ErrStat >= AbortErrLev) return
   call BEMT_PackDiscState(RF, InData%BEMT) 
   call AA_PackDiscState(RF, InData%AA) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackRotDiscreteStateType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(RotDiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackRotDiscreteStateType'
   if (RF%ErrStat /= ErrID_None) return
   call BEMT_UnpackDiscState(RF, OutData%BEMT) ! BEMT 
   call AA_UnpackDiscState(RF, OutData%AA) ! AA 
end subroutine

subroutine AD_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(AD_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(AD_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcDiscStateData%rotors)) then
      LB(1:1) = lbound(SrcDiscStateData%rotors)
      UB(1:1) = ubound(SrcDiscStateData%rotors)
      if (.not. allocated(DstDiscStateData%rotors)) then
         allocate(DstDiscStateData%rotors(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%rotors.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyRotDiscreteStateType(SrcDiscStateData%rotors(i1), DstDiscStateData%rotors(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call FVW_CopyDiscState(SrcDiscStateData%FVW, DstDiscStateData%FVW, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine AD_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(AD_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(DiscStateData%rotors)) then
      LB(1:1) = lbound(DiscStateData%rotors)
      UB(1:1) = ubound(DiscStateData%rotors)
      do i1 = LB(1), UB(1)
         call AD_DestroyRotDiscreteStateType(DiscStateData%rotors(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(DiscStateData%rotors)
   end if
   call FVW_DestroyDiscState(DiscStateData%FVW, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AD_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackDiscState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%rotors))
   if (allocated(InData%rotors)) then
      call RegPackBounds(RF, 1, lbound(InData%rotors), ubound(InData%rotors))
      LB(1:1) = lbound(InData%rotors)
      UB(1:1) = ubound(InData%rotors)
      do i1 = LB(1), UB(1)
         call AD_PackRotDiscreteStateType(RF, InData%rotors(i1)) 
      end do
   end if
   call FVW_PackDiscState(RF, InData%FVW) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackDiscState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%rotors)) deallocate(OutData%rotors)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%rotors(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotors.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackRotDiscreteStateType(RF, OutData%rotors(i1)) ! rotors 
      end do
   end if
   call FVW_UnpackDiscState(RF, OutData%FVW) ! FVW 
end subroutine

subroutine AD_CopyRotConstraintStateType(SrcRotConstraintStateTypeData, DstRotConstraintStateTypeData, CtrlCode, ErrStat, ErrMsg)
   type(RotConstraintStateType), intent(in) :: SrcRotConstraintStateTypeData
   type(RotConstraintStateType), intent(inout) :: DstRotConstraintStateTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyRotConstraintStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call BEMT_CopyConstrState(SrcRotConstraintStateTypeData%BEMT, DstRotConstraintStateTypeData%BEMT, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AA_CopyConstrState(SrcRotConstraintStateTypeData%AA, DstRotConstraintStateTypeData%AA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine AD_DestroyRotConstraintStateType(RotConstraintStateTypeData, ErrStat, ErrMsg)
   type(RotConstraintStateType), intent(inout) :: RotConstraintStateTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyRotConstraintStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call BEMT_DestroyConstrState(RotConstraintStateTypeData%BEMT, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AA_DestroyConstrState(RotConstraintStateTypeData%AA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AD_PackRotConstraintStateType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(RotConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackRotConstraintStateType'
   if (RF%ErrStat >= AbortErrLev) return
   call BEMT_PackConstrState(RF, InData%BEMT) 
   call AA_PackConstrState(RF, InData%AA) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackRotConstraintStateType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(RotConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackRotConstraintStateType'
   if (RF%ErrStat /= ErrID_None) return
   call BEMT_UnpackConstrState(RF, OutData%BEMT) ! BEMT 
   call AA_UnpackConstrState(RF, OutData%AA) ! AA 
end subroutine

subroutine AD_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(AD_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(AD_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcConstrStateData%rotors)) then
      LB(1:1) = lbound(SrcConstrStateData%rotors)
      UB(1:1) = ubound(SrcConstrStateData%rotors)
      if (.not. allocated(DstConstrStateData%rotors)) then
         allocate(DstConstrStateData%rotors(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstConstrStateData%rotors.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyRotConstraintStateType(SrcConstrStateData%rotors(i1), DstConstrStateData%rotors(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call FVW_CopyConstrState(SrcConstrStateData%FVW, DstConstrStateData%FVW, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine AD_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(AD_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ConstrStateData%rotors)) then
      LB(1:1) = lbound(ConstrStateData%rotors)
      UB(1:1) = ubound(ConstrStateData%rotors)
      do i1 = LB(1), UB(1)
         call AD_DestroyRotConstraintStateType(ConstrStateData%rotors(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ConstrStateData%rotors)
   end if
   call FVW_DestroyConstrState(ConstrStateData%FVW, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AD_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackConstrState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%rotors))
   if (allocated(InData%rotors)) then
      call RegPackBounds(RF, 1, lbound(InData%rotors), ubound(InData%rotors))
      LB(1:1) = lbound(InData%rotors)
      UB(1:1) = ubound(InData%rotors)
      do i1 = LB(1), UB(1)
         call AD_PackRotConstraintStateType(RF, InData%rotors(i1)) 
      end do
   end if
   call FVW_PackConstrState(RF, InData%FVW) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackConstrState'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%rotors)) deallocate(OutData%rotors)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%rotors(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotors.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackRotConstraintStateType(RF, OutData%rotors(i1)) ! rotors 
      end do
   end if
   call FVW_UnpackConstrState(RF, OutData%FVW) ! FVW 
end subroutine

subroutine AD_CopyRotOtherStateType(SrcRotOtherStateTypeData, DstRotOtherStateTypeData, CtrlCode, ErrStat, ErrMsg)
   type(RotOtherStateType), intent(in) :: SrcRotOtherStateTypeData
   type(RotOtherStateType), intent(inout) :: DstRotOtherStateTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyRotOtherStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call BEMT_CopyOtherState(SrcRotOtherStateTypeData%BEMT, DstRotOtherStateTypeData%BEMT, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AA_CopyOtherState(SrcRotOtherStateTypeData%AA, DstRotOtherStateTypeData%AA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine AD_DestroyRotOtherStateType(RotOtherStateTypeData, ErrStat, ErrMsg)
   type(RotOtherStateType), intent(inout) :: RotOtherStateTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyRotOtherStateType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call BEMT_DestroyOtherState(RotOtherStateTypeData%BEMT, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AA_DestroyOtherState(RotOtherStateTypeData%AA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AD_PackRotOtherStateType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(RotOtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackRotOtherStateType'
   if (RF%ErrStat >= AbortErrLev) return
   call BEMT_PackOtherState(RF, InData%BEMT) 
   call AA_PackOtherState(RF, InData%AA) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackRotOtherStateType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(RotOtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackRotOtherStateType'
   if (RF%ErrStat /= ErrID_None) return
   call BEMT_UnpackOtherState(RF, OutData%BEMT) ! BEMT 
   call AA_UnpackOtherState(RF, OutData%AA) ! AA 
end subroutine

subroutine AD_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(AD_OtherStateType), intent(in) :: SrcOtherStateData
   type(AD_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOtherStateData%rotors)) then
      LB(1:1) = lbound(SrcOtherStateData%rotors)
      UB(1:1) = ubound(SrcOtherStateData%rotors)
      if (.not. allocated(DstOtherStateData%rotors)) then
         allocate(DstOtherStateData%rotors(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%rotors.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyRotOtherStateType(SrcOtherStateData%rotors(i1), DstOtherStateData%rotors(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call FVW_CopyOtherState(SrcOtherStateData%FVW, DstOtherStateData%FVW, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOtherStateData%WakeLocationPoints)) then
      LB(1:2) = lbound(SrcOtherStateData%WakeLocationPoints)
      UB(1:2) = ubound(SrcOtherStateData%WakeLocationPoints)
      if (.not. allocated(DstOtherStateData%WakeLocationPoints)) then
         allocate(DstOtherStateData%WakeLocationPoints(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOtherStateData%WakeLocationPoints.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOtherStateData%WakeLocationPoints = SrcOtherStateData%WakeLocationPoints
   end if
end subroutine

subroutine AD_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(AD_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OtherStateData%rotors)) then
      LB(1:1) = lbound(OtherStateData%rotors)
      UB(1:1) = ubound(OtherStateData%rotors)
      do i1 = LB(1), UB(1)
         call AD_DestroyRotOtherStateType(OtherStateData%rotors(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OtherStateData%rotors)
   end if
   call FVW_DestroyOtherState(OtherStateData%FVW, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OtherStateData%WakeLocationPoints)) then
      deallocate(OtherStateData%WakeLocationPoints)
   end if
end subroutine

subroutine AD_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackOtherState'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%rotors))
   if (allocated(InData%rotors)) then
      call RegPackBounds(RF, 1, lbound(InData%rotors), ubound(InData%rotors))
      LB(1:1) = lbound(InData%rotors)
      UB(1:1) = ubound(InData%rotors)
      do i1 = LB(1), UB(1)
         call AD_PackRotOtherStateType(RF, InData%rotors(i1)) 
      end do
   end if
   call FVW_PackOtherState(RF, InData%FVW) 
   call RegPackAlloc(RF, InData%WakeLocationPoints)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackOtherState'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%rotors)) deallocate(OutData%rotors)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%rotors(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotors.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackRotOtherStateType(RF, OutData%rotors(i1)) ! rotors 
      end do
   end if
   call FVW_UnpackOtherState(RF, OutData%FVW) ! FVW 
   call RegUnpackAlloc(RF, OutData%WakeLocationPoints); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyRotMiscVarType(SrcRotMiscVarTypeData, DstRotMiscVarTypeData, CtrlCode, ErrStat, ErrMsg)
   type(RotMiscVarType), intent(inout) :: SrcRotMiscVarTypeData
   type(RotMiscVarType), intent(inout) :: DstRotMiscVarTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyRotMiscVarType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call BEMT_CopyMisc(SrcRotMiscVarTypeData%BEMT, DstRotMiscVarTypeData%BEMT, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call BEMT_CopyOutput(SrcRotMiscVarTypeData%BEMT_y, DstRotMiscVarTypeData%BEMT_y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   LB(1:1) = lbound(SrcRotMiscVarTypeData%BEMT_u)
   UB(1:1) = ubound(SrcRotMiscVarTypeData%BEMT_u)
   do i1 = LB(1), UB(1)
      call BEMT_CopyInput(SrcRotMiscVarTypeData%BEMT_u(i1), DstRotMiscVarTypeData%BEMT_u(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   call AA_CopyMisc(SrcRotMiscVarTypeData%AA, DstRotMiscVarTypeData%AA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AA_CopyOutput(SrcRotMiscVarTypeData%AA_y, DstRotMiscVarTypeData%AA_y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AA_CopyInput(SrcRotMiscVarTypeData%AA_u, DstRotMiscVarTypeData%AA_u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcRotMiscVarTypeData%DisturbedInflow)) then
      LB(1:3) = lbound(SrcRotMiscVarTypeData%DisturbedInflow)
      UB(1:3) = ubound(SrcRotMiscVarTypeData%DisturbedInflow)
      if (.not. allocated(DstRotMiscVarTypeData%DisturbedInflow)) then
         allocate(DstRotMiscVarTypeData%DisturbedInflow(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%DisturbedInflow.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%DisturbedInflow = SrcRotMiscVarTypeData%DisturbedInflow
   end if
   if (allocated(SrcRotMiscVarTypeData%SectAvgInflow)) then
      LB(1:3) = lbound(SrcRotMiscVarTypeData%SectAvgInflow)
      UB(1:3) = ubound(SrcRotMiscVarTypeData%SectAvgInflow)
      if (.not. allocated(DstRotMiscVarTypeData%SectAvgInflow)) then
         allocate(DstRotMiscVarTypeData%SectAvgInflow(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%SectAvgInflow.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%SectAvgInflow = SrcRotMiscVarTypeData%SectAvgInflow
   end if
   if (allocated(SrcRotMiscVarTypeData%orientationAnnulus)) then
      LB(1:4) = lbound(SrcRotMiscVarTypeData%orientationAnnulus)
      UB(1:4) = ubound(SrcRotMiscVarTypeData%orientationAnnulus)
      if (.not. allocated(DstRotMiscVarTypeData%orientationAnnulus)) then
         allocate(DstRotMiscVarTypeData%orientationAnnulus(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%orientationAnnulus.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%orientationAnnulus = SrcRotMiscVarTypeData%orientationAnnulus
   end if
   if (allocated(SrcRotMiscVarTypeData%R_li)) then
      LB(1:4) = lbound(SrcRotMiscVarTypeData%R_li)
      UB(1:4) = ubound(SrcRotMiscVarTypeData%R_li)
      if (.not. allocated(DstRotMiscVarTypeData%R_li)) then
         allocate(DstRotMiscVarTypeData%R_li(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%R_li.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%R_li = SrcRotMiscVarTypeData%R_li
   end if
   if (allocated(SrcRotMiscVarTypeData%AllOuts)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%AllOuts)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%AllOuts)
      if (.not. allocated(DstRotMiscVarTypeData%AllOuts)) then
         allocate(DstRotMiscVarTypeData%AllOuts(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%AllOuts.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%AllOuts = SrcRotMiscVarTypeData%AllOuts
   end if
   if (allocated(SrcRotMiscVarTypeData%W_Twr)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%W_Twr)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%W_Twr)
      if (.not. allocated(DstRotMiscVarTypeData%W_Twr)) then
         allocate(DstRotMiscVarTypeData%W_Twr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%W_Twr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%W_Twr = SrcRotMiscVarTypeData%W_Twr
   end if
   if (allocated(SrcRotMiscVarTypeData%X_Twr)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%X_Twr)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%X_Twr)
      if (.not. allocated(DstRotMiscVarTypeData%X_Twr)) then
         allocate(DstRotMiscVarTypeData%X_Twr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%X_Twr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%X_Twr = SrcRotMiscVarTypeData%X_Twr
   end if
   if (allocated(SrcRotMiscVarTypeData%Y_Twr)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%Y_Twr)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%Y_Twr)
      if (.not. allocated(DstRotMiscVarTypeData%Y_Twr)) then
         allocate(DstRotMiscVarTypeData%Y_Twr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%Y_Twr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%Y_Twr = SrcRotMiscVarTypeData%Y_Twr
   end if
   if (allocated(SrcRotMiscVarTypeData%Cant)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%Cant)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%Cant)
      if (.not. allocated(DstRotMiscVarTypeData%Cant)) then
         allocate(DstRotMiscVarTypeData%Cant(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%Cant.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%Cant = SrcRotMiscVarTypeData%Cant
   end if
   if (allocated(SrcRotMiscVarTypeData%Toe)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%Toe)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%Toe)
      if (.not. allocated(DstRotMiscVarTypeData%Toe)) then
         allocate(DstRotMiscVarTypeData%Toe(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%Toe.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%Toe = SrcRotMiscVarTypeData%Toe
   end if
   if (allocated(SrcRotMiscVarTypeData%TwrClrnc)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%TwrClrnc)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%TwrClrnc)
      if (.not. allocated(DstRotMiscVarTypeData%TwrClrnc)) then
         allocate(DstRotMiscVarTypeData%TwrClrnc(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%TwrClrnc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%TwrClrnc = SrcRotMiscVarTypeData%TwrClrnc
   end if
   if (allocated(SrcRotMiscVarTypeData%X)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%X)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%X)
      if (.not. allocated(DstRotMiscVarTypeData%X)) then
         allocate(DstRotMiscVarTypeData%X(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%X.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%X = SrcRotMiscVarTypeData%X
   end if
   if (allocated(SrcRotMiscVarTypeData%Y)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%Y)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%Y)
      if (.not. allocated(DstRotMiscVarTypeData%Y)) then
         allocate(DstRotMiscVarTypeData%Y(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%Y.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%Y = SrcRotMiscVarTypeData%Y
   end if
   if (allocated(SrcRotMiscVarTypeData%Z)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%Z)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%Z)
      if (.not. allocated(DstRotMiscVarTypeData%Z)) then
         allocate(DstRotMiscVarTypeData%Z(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%Z.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%Z = SrcRotMiscVarTypeData%Z
   end if
   if (allocated(SrcRotMiscVarTypeData%M)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%M)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%M)
      if (.not. allocated(DstRotMiscVarTypeData%M)) then
         allocate(DstRotMiscVarTypeData%M(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%M.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%M = SrcRotMiscVarTypeData%M
   end if
   if (allocated(SrcRotMiscVarTypeData%Mx)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%Mx)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%Mx)
      if (.not. allocated(DstRotMiscVarTypeData%Mx)) then
         allocate(DstRotMiscVarTypeData%Mx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%Mx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%Mx = SrcRotMiscVarTypeData%Mx
   end if
   if (allocated(SrcRotMiscVarTypeData%My)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%My)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%My)
      if (.not. allocated(DstRotMiscVarTypeData%My)) then
         allocate(DstRotMiscVarTypeData%My(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%My.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%My = SrcRotMiscVarTypeData%My
   end if
   if (allocated(SrcRotMiscVarTypeData%Mz)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%Mz)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%Mz)
      if (.not. allocated(DstRotMiscVarTypeData%Mz)) then
         allocate(DstRotMiscVarTypeData%Mz(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%Mz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%Mz = SrcRotMiscVarTypeData%Mz
   end if
   if (allocated(SrcRotMiscVarTypeData%Vind_i)) then
      LB(1:3) = lbound(SrcRotMiscVarTypeData%Vind_i)
      UB(1:3) = ubound(SrcRotMiscVarTypeData%Vind_i)
      if (.not. allocated(DstRotMiscVarTypeData%Vind_i)) then
         allocate(DstRotMiscVarTypeData%Vind_i(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%Vind_i.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%Vind_i = SrcRotMiscVarTypeData%Vind_i
   end if
   DstRotMiscVarTypeData%V_DiskAvg = SrcRotMiscVarTypeData%V_DiskAvg
   DstRotMiscVarTypeData%yaw = SrcRotMiscVarTypeData%yaw
   DstRotMiscVarTypeData%tilt = SrcRotMiscVarTypeData%tilt
   if (allocated(SrcRotMiscVarTypeData%hub_theta_x_root)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%hub_theta_x_root)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%hub_theta_x_root)
      if (.not. allocated(DstRotMiscVarTypeData%hub_theta_x_root)) then
         allocate(DstRotMiscVarTypeData%hub_theta_x_root(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%hub_theta_x_root.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%hub_theta_x_root = SrcRotMiscVarTypeData%hub_theta_x_root
   end if
   DstRotMiscVarTypeData%V_dot_x = SrcRotMiscVarTypeData%V_dot_x
   call MeshCopy(SrcRotMiscVarTypeData%HubLoad, DstRotMiscVarTypeData%HubLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcRotMiscVarTypeData%B_L_2_H_P)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%B_L_2_H_P)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%B_L_2_H_P)
      if (.not. allocated(DstRotMiscVarTypeData%B_L_2_H_P)) then
         allocate(DstRotMiscVarTypeData%B_L_2_H_P(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%B_L_2_H_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcRotMiscVarTypeData%B_L_2_H_P(i1), DstRotMiscVarTypeData%B_L_2_H_P(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcRotMiscVarTypeData%SigmaCavitCrit)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%SigmaCavitCrit)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%SigmaCavitCrit)
      if (.not. allocated(DstRotMiscVarTypeData%SigmaCavitCrit)) then
         allocate(DstRotMiscVarTypeData%SigmaCavitCrit(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%SigmaCavitCrit.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%SigmaCavitCrit = SrcRotMiscVarTypeData%SigmaCavitCrit
   end if
   if (allocated(SrcRotMiscVarTypeData%SigmaCavit)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%SigmaCavit)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%SigmaCavit)
      if (.not. allocated(DstRotMiscVarTypeData%SigmaCavit)) then
         allocate(DstRotMiscVarTypeData%SigmaCavit(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%SigmaCavit.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%SigmaCavit = SrcRotMiscVarTypeData%SigmaCavit
   end if
   if (allocated(SrcRotMiscVarTypeData%CavitWarnSet)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%CavitWarnSet)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%CavitWarnSet)
      if (.not. allocated(DstRotMiscVarTypeData%CavitWarnSet)) then
         allocate(DstRotMiscVarTypeData%CavitWarnSet(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%CavitWarnSet.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%CavitWarnSet = SrcRotMiscVarTypeData%CavitWarnSet
   end if
   if (allocated(SrcRotMiscVarTypeData%TwrFB)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%TwrFB)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%TwrFB)
      if (.not. allocated(DstRotMiscVarTypeData%TwrFB)) then
         allocate(DstRotMiscVarTypeData%TwrFB(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%TwrFB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%TwrFB = SrcRotMiscVarTypeData%TwrFB
   end if
   if (allocated(SrcRotMiscVarTypeData%TwrMB)) then
      LB(1:2) = lbound(SrcRotMiscVarTypeData%TwrMB)
      UB(1:2) = ubound(SrcRotMiscVarTypeData%TwrMB)
      if (.not. allocated(DstRotMiscVarTypeData%TwrMB)) then
         allocate(DstRotMiscVarTypeData%TwrMB(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%TwrMB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%TwrMB = SrcRotMiscVarTypeData%TwrMB
   end if
   if (allocated(SrcRotMiscVarTypeData%HubFB)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%HubFB)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%HubFB)
      if (.not. allocated(DstRotMiscVarTypeData%HubFB)) then
         allocate(DstRotMiscVarTypeData%HubFB(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%HubFB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%HubFB = SrcRotMiscVarTypeData%HubFB
   end if
   if (allocated(SrcRotMiscVarTypeData%HubMB)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%HubMB)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%HubMB)
      if (.not. allocated(DstRotMiscVarTypeData%HubMB)) then
         allocate(DstRotMiscVarTypeData%HubMB(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%HubMB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%HubMB = SrcRotMiscVarTypeData%HubMB
   end if
   if (allocated(SrcRotMiscVarTypeData%NacFB)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%NacFB)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%NacFB)
      if (.not. allocated(DstRotMiscVarTypeData%NacFB)) then
         allocate(DstRotMiscVarTypeData%NacFB(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%NacFB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%NacFB = SrcRotMiscVarTypeData%NacFB
   end if
   if (allocated(SrcRotMiscVarTypeData%NacMB)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%NacMB)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%NacMB)
      if (.not. allocated(DstRotMiscVarTypeData%NacMB)) then
         allocate(DstRotMiscVarTypeData%NacMB(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%NacMB.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%NacMB = SrcRotMiscVarTypeData%NacMB
   end if
   if (allocated(SrcRotMiscVarTypeData%NacDragF)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%NacDragF)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%NacDragF)
      if (.not. allocated(DstRotMiscVarTypeData%NacDragF)) then
         allocate(DstRotMiscVarTypeData%NacDragF(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%NacDragF.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%NacDragF = SrcRotMiscVarTypeData%NacDragF
   end if
   if (allocated(SrcRotMiscVarTypeData%NacDragM)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%NacDragM)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%NacDragM)
      if (.not. allocated(DstRotMiscVarTypeData%NacDragM)) then
         allocate(DstRotMiscVarTypeData%NacDragM(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%NacDragM.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%NacDragM = SrcRotMiscVarTypeData%NacDragM
   end if
   if (allocated(SrcRotMiscVarTypeData%NacFi)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%NacFi)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%NacFi)
      if (.not. allocated(DstRotMiscVarTypeData%NacFi)) then
         allocate(DstRotMiscVarTypeData%NacFi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%NacFi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%NacFi = SrcRotMiscVarTypeData%NacFi
   end if
   if (allocated(SrcRotMiscVarTypeData%NacMi)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%NacMi)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%NacMi)
      if (.not. allocated(DstRotMiscVarTypeData%NacMi)) then
         allocate(DstRotMiscVarTypeData%NacMi(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%NacMi.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotMiscVarTypeData%NacMi = SrcRotMiscVarTypeData%NacMi
   end if
   if (allocated(SrcRotMiscVarTypeData%BladeRootLoad)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%BladeRootLoad)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%BladeRootLoad)
      if (.not. allocated(DstRotMiscVarTypeData%BladeRootLoad)) then
         allocate(DstRotMiscVarTypeData%BladeRootLoad(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%BladeRootLoad.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcRotMiscVarTypeData%BladeRootLoad(i1), DstRotMiscVarTypeData%BladeRootLoad(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcRotMiscVarTypeData%B_L_2_R_P)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%B_L_2_R_P)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%B_L_2_R_P)
      if (.not. allocated(DstRotMiscVarTypeData%B_L_2_R_P)) then
         allocate(DstRotMiscVarTypeData%B_L_2_R_P(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%B_L_2_R_P.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcRotMiscVarTypeData%B_L_2_R_P(i1), DstRotMiscVarTypeData%B_L_2_R_P(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcRotMiscVarTypeData%BladeBuoyLoadPoint)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%BladeBuoyLoadPoint)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%BladeBuoyLoadPoint)
      if (.not. allocated(DstRotMiscVarTypeData%BladeBuoyLoadPoint)) then
         allocate(DstRotMiscVarTypeData%BladeBuoyLoadPoint(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%BladeBuoyLoadPoint.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcRotMiscVarTypeData%BladeBuoyLoadPoint(i1), DstRotMiscVarTypeData%BladeBuoyLoadPoint(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcRotMiscVarTypeData%BladeBuoyLoad)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%BladeBuoyLoad)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%BladeBuoyLoad)
      if (.not. allocated(DstRotMiscVarTypeData%BladeBuoyLoad)) then
         allocate(DstRotMiscVarTypeData%BladeBuoyLoad(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%BladeBuoyLoad.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcRotMiscVarTypeData%BladeBuoyLoad(i1), DstRotMiscVarTypeData%BladeBuoyLoad(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcRotMiscVarTypeData%B_P_2_B_L)) then
      LB(1:1) = lbound(SrcRotMiscVarTypeData%B_P_2_B_L)
      UB(1:1) = ubound(SrcRotMiscVarTypeData%B_P_2_B_L)
      if (.not. allocated(DstRotMiscVarTypeData%B_P_2_B_L)) then
         allocate(DstRotMiscVarTypeData%B_P_2_B_L(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotMiscVarTypeData%B_P_2_B_L.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcRotMiscVarTypeData%B_P_2_B_L(i1), DstRotMiscVarTypeData%B_P_2_B_L(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call MeshCopy(SrcRotMiscVarTypeData%TwrBuoyLoadPoint, DstRotMiscVarTypeData%TwrBuoyLoadPoint, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcRotMiscVarTypeData%TwrBuoyLoad, DstRotMiscVarTypeData%TwrBuoyLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcRotMiscVarTypeData%T_P_2_T_L, DstRotMiscVarTypeData%T_P_2_T_L, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstRotMiscVarTypeData%FirstWarn_TowerStrike = SrcRotMiscVarTypeData%FirstWarn_TowerStrike
   DstRotMiscVarTypeData%AvgDiskVel = SrcRotMiscVarTypeData%AvgDiskVel
   DstRotMiscVarTypeData%AvgDiskVelDist = SrcRotMiscVarTypeData%AvgDiskVelDist
   DstRotMiscVarTypeData%TFinAlpha = SrcRotMiscVarTypeData%TFinAlpha
   DstRotMiscVarTypeData%TFinRe = SrcRotMiscVarTypeData%TFinRe
   DstRotMiscVarTypeData%TFinVrel = SrcRotMiscVarTypeData%TFinVrel
   DstRotMiscVarTypeData%TFinVund_i = SrcRotMiscVarTypeData%TFinVund_i
   DstRotMiscVarTypeData%TFinVind_i = SrcRotMiscVarTypeData%TFinVind_i
   DstRotMiscVarTypeData%TFinVrel_i = SrcRotMiscVarTypeData%TFinVrel_i
   DstRotMiscVarTypeData%TFinSTV_i = SrcRotMiscVarTypeData%TFinSTV_i
   DstRotMiscVarTypeData%TFinF_i = SrcRotMiscVarTypeData%TFinF_i
   DstRotMiscVarTypeData%TFinM_i = SrcRotMiscVarTypeData%TFinM_i
end subroutine

subroutine AD_DestroyRotMiscVarType(RotMiscVarTypeData, ErrStat, ErrMsg)
   type(RotMiscVarType), intent(inout) :: RotMiscVarTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyRotMiscVarType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call BEMT_DestroyMisc(RotMiscVarTypeData%BEMT, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call BEMT_DestroyOutput(RotMiscVarTypeData%BEMT_y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   LB(1:1) = lbound(RotMiscVarTypeData%BEMT_u)
   UB(1:1) = ubound(RotMiscVarTypeData%BEMT_u)
   do i1 = LB(1), UB(1)
      call BEMT_DestroyInput(RotMiscVarTypeData%BEMT_u(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
   call AA_DestroyMisc(RotMiscVarTypeData%AA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AA_DestroyOutput(RotMiscVarTypeData%AA_y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AA_DestroyInput(RotMiscVarTypeData%AA_u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(RotMiscVarTypeData%DisturbedInflow)) then
      deallocate(RotMiscVarTypeData%DisturbedInflow)
   end if
   if (allocated(RotMiscVarTypeData%SectAvgInflow)) then
      deallocate(RotMiscVarTypeData%SectAvgInflow)
   end if
   if (allocated(RotMiscVarTypeData%orientationAnnulus)) then
      deallocate(RotMiscVarTypeData%orientationAnnulus)
   end if
   if (allocated(RotMiscVarTypeData%R_li)) then
      deallocate(RotMiscVarTypeData%R_li)
   end if
   if (allocated(RotMiscVarTypeData%AllOuts)) then
      deallocate(RotMiscVarTypeData%AllOuts)
   end if
   if (allocated(RotMiscVarTypeData%W_Twr)) then
      deallocate(RotMiscVarTypeData%W_Twr)
   end if
   if (allocated(RotMiscVarTypeData%X_Twr)) then
      deallocate(RotMiscVarTypeData%X_Twr)
   end if
   if (allocated(RotMiscVarTypeData%Y_Twr)) then
      deallocate(RotMiscVarTypeData%Y_Twr)
   end if
   if (allocated(RotMiscVarTypeData%Cant)) then
      deallocate(RotMiscVarTypeData%Cant)
   end if
   if (allocated(RotMiscVarTypeData%Toe)) then
      deallocate(RotMiscVarTypeData%Toe)
   end if
   if (allocated(RotMiscVarTypeData%TwrClrnc)) then
      deallocate(RotMiscVarTypeData%TwrClrnc)
   end if
   if (allocated(RotMiscVarTypeData%X)) then
      deallocate(RotMiscVarTypeData%X)
   end if
   if (allocated(RotMiscVarTypeData%Y)) then
      deallocate(RotMiscVarTypeData%Y)
   end if
   if (allocated(RotMiscVarTypeData%Z)) then
      deallocate(RotMiscVarTypeData%Z)
   end if
   if (allocated(RotMiscVarTypeData%M)) then
      deallocate(RotMiscVarTypeData%M)
   end if
   if (allocated(RotMiscVarTypeData%Mx)) then
      deallocate(RotMiscVarTypeData%Mx)
   end if
   if (allocated(RotMiscVarTypeData%My)) then
      deallocate(RotMiscVarTypeData%My)
   end if
   if (allocated(RotMiscVarTypeData%Mz)) then
      deallocate(RotMiscVarTypeData%Mz)
   end if
   if (allocated(RotMiscVarTypeData%Vind_i)) then
      deallocate(RotMiscVarTypeData%Vind_i)
   end if
   if (allocated(RotMiscVarTypeData%hub_theta_x_root)) then
      deallocate(RotMiscVarTypeData%hub_theta_x_root)
   end if
   call MeshDestroy( RotMiscVarTypeData%HubLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(RotMiscVarTypeData%B_L_2_H_P)) then
      LB(1:1) = lbound(RotMiscVarTypeData%B_L_2_H_P)
      UB(1:1) = ubound(RotMiscVarTypeData%B_L_2_H_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(RotMiscVarTypeData%B_L_2_H_P(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotMiscVarTypeData%B_L_2_H_P)
   end if
   if (allocated(RotMiscVarTypeData%SigmaCavitCrit)) then
      deallocate(RotMiscVarTypeData%SigmaCavitCrit)
   end if
   if (allocated(RotMiscVarTypeData%SigmaCavit)) then
      deallocate(RotMiscVarTypeData%SigmaCavit)
   end if
   if (allocated(RotMiscVarTypeData%CavitWarnSet)) then
      deallocate(RotMiscVarTypeData%CavitWarnSet)
   end if
   if (allocated(RotMiscVarTypeData%TwrFB)) then
      deallocate(RotMiscVarTypeData%TwrFB)
   end if
   if (allocated(RotMiscVarTypeData%TwrMB)) then
      deallocate(RotMiscVarTypeData%TwrMB)
   end if
   if (allocated(RotMiscVarTypeData%HubFB)) then
      deallocate(RotMiscVarTypeData%HubFB)
   end if
   if (allocated(RotMiscVarTypeData%HubMB)) then
      deallocate(RotMiscVarTypeData%HubMB)
   end if
   if (allocated(RotMiscVarTypeData%NacFB)) then
      deallocate(RotMiscVarTypeData%NacFB)
   end if
   if (allocated(RotMiscVarTypeData%NacMB)) then
      deallocate(RotMiscVarTypeData%NacMB)
   end if
   if (allocated(RotMiscVarTypeData%NacDragF)) then
      deallocate(RotMiscVarTypeData%NacDragF)
   end if
   if (allocated(RotMiscVarTypeData%NacDragM)) then
      deallocate(RotMiscVarTypeData%NacDragM)
   end if
   if (allocated(RotMiscVarTypeData%NacFi)) then
      deallocate(RotMiscVarTypeData%NacFi)
   end if
   if (allocated(RotMiscVarTypeData%NacMi)) then
      deallocate(RotMiscVarTypeData%NacMi)
   end if
   if (allocated(RotMiscVarTypeData%BladeRootLoad)) then
      LB(1:1) = lbound(RotMiscVarTypeData%BladeRootLoad)
      UB(1:1) = ubound(RotMiscVarTypeData%BladeRootLoad)
      do i1 = LB(1), UB(1)
         call MeshDestroy( RotMiscVarTypeData%BladeRootLoad(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotMiscVarTypeData%BladeRootLoad)
   end if
   if (allocated(RotMiscVarTypeData%B_L_2_R_P)) then
      LB(1:1) = lbound(RotMiscVarTypeData%B_L_2_R_P)
      UB(1:1) = ubound(RotMiscVarTypeData%B_L_2_R_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(RotMiscVarTypeData%B_L_2_R_P(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotMiscVarTypeData%B_L_2_R_P)
   end if
   if (allocated(RotMiscVarTypeData%BladeBuoyLoadPoint)) then
      LB(1:1) = lbound(RotMiscVarTypeData%BladeBuoyLoadPoint)
      UB(1:1) = ubound(RotMiscVarTypeData%BladeBuoyLoadPoint)
      do i1 = LB(1), UB(1)
         call MeshDestroy( RotMiscVarTypeData%BladeBuoyLoadPoint(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotMiscVarTypeData%BladeBuoyLoadPoint)
   end if
   if (allocated(RotMiscVarTypeData%BladeBuoyLoad)) then
      LB(1:1) = lbound(RotMiscVarTypeData%BladeBuoyLoad)
      UB(1:1) = ubound(RotMiscVarTypeData%BladeBuoyLoad)
      do i1 = LB(1), UB(1)
         call MeshDestroy( RotMiscVarTypeData%BladeBuoyLoad(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotMiscVarTypeData%BladeBuoyLoad)
   end if
   if (allocated(RotMiscVarTypeData%B_P_2_B_L)) then
      LB(1:1) = lbound(RotMiscVarTypeData%B_P_2_B_L)
      UB(1:1) = ubound(RotMiscVarTypeData%B_P_2_B_L)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(RotMiscVarTypeData%B_P_2_B_L(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotMiscVarTypeData%B_P_2_B_L)
   end if
   call MeshDestroy( RotMiscVarTypeData%TwrBuoyLoadPoint, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( RotMiscVarTypeData%TwrBuoyLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(RotMiscVarTypeData%T_P_2_T_L, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AD_PackRotMiscVarType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(RotMiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackRotMiscVarType'
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   if (RF%ErrStat >= AbortErrLev) return
   call BEMT_PackMisc(RF, InData%BEMT) 
   call BEMT_PackOutput(RF, InData%BEMT_y) 
   LB(1:1) = lbound(InData%BEMT_u)
   UB(1:1) = ubound(InData%BEMT_u)
   do i1 = LB(1), UB(1)
      call BEMT_PackInput(RF, InData%BEMT_u(i1)) 
   end do
   call AA_PackMisc(RF, InData%AA) 
   call AA_PackOutput(RF, InData%AA_y) 
   call AA_PackInput(RF, InData%AA_u) 
   call RegPackAlloc(RF, InData%DisturbedInflow)
   call RegPackAlloc(RF, InData%SectAvgInflow)
   call RegPackAlloc(RF, InData%orientationAnnulus)
   call RegPackAlloc(RF, InData%R_li)
   call RegPackAlloc(RF, InData%AllOuts)
   call RegPackAlloc(RF, InData%W_Twr)
   call RegPackAlloc(RF, InData%X_Twr)
   call RegPackAlloc(RF, InData%Y_Twr)
   call RegPackAlloc(RF, InData%Cant)
   call RegPackAlloc(RF, InData%Toe)
   call RegPackAlloc(RF, InData%TwrClrnc)
   call RegPackAlloc(RF, InData%X)
   call RegPackAlloc(RF, InData%Y)
   call RegPackAlloc(RF, InData%Z)
   call RegPackAlloc(RF, InData%M)
   call RegPackAlloc(RF, InData%Mx)
   call RegPackAlloc(RF, InData%My)
   call RegPackAlloc(RF, InData%Mz)
   call RegPackAlloc(RF, InData%Vind_i)
   call RegPack(RF, InData%V_DiskAvg)
   call RegPack(RF, InData%yaw)
   call RegPack(RF, InData%tilt)
   call RegPackAlloc(RF, InData%hub_theta_x_root)
   call RegPack(RF, InData%V_dot_x)
   call MeshPack(RF, InData%HubLoad) 
   call RegPack(RF, allocated(InData%B_L_2_H_P))
   if (allocated(InData%B_L_2_H_P)) then
      call RegPackBounds(RF, 1, lbound(InData%B_L_2_H_P), ubound(InData%B_L_2_H_P))
      LB(1:1) = lbound(InData%B_L_2_H_P)
      UB(1:1) = ubound(InData%B_L_2_H_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%B_L_2_H_P(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%SigmaCavitCrit)
   call RegPackAlloc(RF, InData%SigmaCavit)
   call RegPackAlloc(RF, InData%CavitWarnSet)
   call RegPackAlloc(RF, InData%TwrFB)
   call RegPackAlloc(RF, InData%TwrMB)
   call RegPackAlloc(RF, InData%HubFB)
   call RegPackAlloc(RF, InData%HubMB)
   call RegPackAlloc(RF, InData%NacFB)
   call RegPackAlloc(RF, InData%NacMB)
   call RegPackAlloc(RF, InData%NacDragF)
   call RegPackAlloc(RF, InData%NacDragM)
   call RegPackAlloc(RF, InData%NacFi)
   call RegPackAlloc(RF, InData%NacMi)
   call RegPack(RF, allocated(InData%BladeRootLoad))
   if (allocated(InData%BladeRootLoad)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeRootLoad), ubound(InData%BladeRootLoad))
      LB(1:1) = lbound(InData%BladeRootLoad)
      UB(1:1) = ubound(InData%BladeRootLoad)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeRootLoad(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%B_L_2_R_P))
   if (allocated(InData%B_L_2_R_P)) then
      call RegPackBounds(RF, 1, lbound(InData%B_L_2_R_P), ubound(InData%B_L_2_R_P))
      LB(1:1) = lbound(InData%B_L_2_R_P)
      UB(1:1) = ubound(InData%B_L_2_R_P)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%B_L_2_R_P(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%BladeBuoyLoadPoint))
   if (allocated(InData%BladeBuoyLoadPoint)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeBuoyLoadPoint), ubound(InData%BladeBuoyLoadPoint))
      LB(1:1) = lbound(InData%BladeBuoyLoadPoint)
      UB(1:1) = ubound(InData%BladeBuoyLoadPoint)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeBuoyLoadPoint(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%BladeBuoyLoad))
   if (allocated(InData%BladeBuoyLoad)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeBuoyLoad), ubound(InData%BladeBuoyLoad))
      LB(1:1) = lbound(InData%BladeBuoyLoad)
      UB(1:1) = ubound(InData%BladeBuoyLoad)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeBuoyLoad(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%B_P_2_B_L))
   if (allocated(InData%B_P_2_B_L)) then
      call RegPackBounds(RF, 1, lbound(InData%B_P_2_B_L), ubound(InData%B_P_2_B_L))
      LB(1:1) = lbound(InData%B_P_2_B_L)
      UB(1:1) = ubound(InData%B_P_2_B_L)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%B_P_2_B_L(i1)) 
      end do
   end if
   call MeshPack(RF, InData%TwrBuoyLoadPoint) 
   call MeshPack(RF, InData%TwrBuoyLoad) 
   call NWTC_Library_PackMeshMapType(RF, InData%T_P_2_T_L) 
   call RegPack(RF, InData%FirstWarn_TowerStrike)
   call RegPack(RF, InData%AvgDiskVel)
   call RegPack(RF, InData%AvgDiskVelDist)
   call RegPack(RF, InData%TFinAlpha)
   call RegPack(RF, InData%TFinRe)
   call RegPack(RF, InData%TFinVrel)
   call RegPack(RF, InData%TFinVund_i)
   call RegPack(RF, InData%TFinVind_i)
   call RegPack(RF, InData%TFinVrel_i)
   call RegPack(RF, InData%TFinSTV_i)
   call RegPack(RF, InData%TFinF_i)
   call RegPack(RF, InData%TFinM_i)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackRotMiscVarType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(RotMiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackRotMiscVarType'
   integer(B4Ki)   :: i1, i2, i3, i4
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call BEMT_UnpackMisc(RF, OutData%BEMT) ! BEMT 
   call BEMT_UnpackOutput(RF, OutData%BEMT_y) ! BEMT_y 
   LB(1:1) = lbound(OutData%BEMT_u)
   UB(1:1) = ubound(OutData%BEMT_u)
   do i1 = LB(1), UB(1)
      call BEMT_UnpackInput(RF, OutData%BEMT_u(i1)) ! BEMT_u 
   end do
   call AA_UnpackMisc(RF, OutData%AA) ! AA 
   call AA_UnpackOutput(RF, OutData%AA_y) ! AA_y 
   call AA_UnpackInput(RF, OutData%AA_u) ! AA_u 
   call RegUnpackAlloc(RF, OutData%DisturbedInflow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SectAvgInflow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%orientationAnnulus); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%R_li); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AllOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%W_Twr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%X_Twr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Y_Twr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Cant); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Toe); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrClrnc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%X); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Y); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Z); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%M); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Mx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%My); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Mz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vind_i); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%V_DiskAvg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%yaw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tilt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%hub_theta_x_root); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%V_dot_x); if (RegCheckErr(RF, RoutineName)) return
   call MeshUnpack(RF, OutData%HubLoad) ! HubLoad 
   if (allocated(OutData%B_L_2_H_P)) deallocate(OutData%B_L_2_H_P)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%B_L_2_H_P(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%B_L_2_H_P.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%B_L_2_H_P(i1)) ! B_L_2_H_P 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%SigmaCavitCrit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SigmaCavit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CavitWarnSet); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrFB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrMB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%HubFB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%HubMB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NacFB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NacMB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NacDragF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NacDragM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NacFi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%NacMi); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BladeRootLoad)) deallocate(OutData%BladeRootLoad)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeRootLoad(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeRootLoad.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeRootLoad(i1)) ! BladeRootLoad 
      end do
   end if
   if (allocated(OutData%B_L_2_R_P)) deallocate(OutData%B_L_2_R_P)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%B_L_2_R_P(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%B_L_2_R_P.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%B_L_2_R_P(i1)) ! B_L_2_R_P 
      end do
   end if
   if (allocated(OutData%BladeBuoyLoadPoint)) deallocate(OutData%BladeBuoyLoadPoint)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeBuoyLoadPoint(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeBuoyLoadPoint.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeBuoyLoadPoint(i1)) ! BladeBuoyLoadPoint 
      end do
   end if
   if (allocated(OutData%BladeBuoyLoad)) deallocate(OutData%BladeBuoyLoad)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeBuoyLoad(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeBuoyLoad.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeBuoyLoad(i1)) ! BladeBuoyLoad 
      end do
   end if
   if (allocated(OutData%B_P_2_B_L)) deallocate(OutData%B_P_2_B_L)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%B_P_2_B_L(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%B_P_2_B_L.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%B_P_2_B_L(i1)) ! B_P_2_B_L 
      end do
   end if
   call MeshUnpack(RF, OutData%TwrBuoyLoadPoint) ! TwrBuoyLoadPoint 
   call MeshUnpack(RF, OutData%TwrBuoyLoad) ! TwrBuoyLoad 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%T_P_2_T_L) ! T_P_2_T_L 
   call RegUnpack(RF, OutData%FirstWarn_TowerStrike); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AvgDiskVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AvgDiskVelDist); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinAlpha); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinRe); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinVrel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinVund_i); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinVind_i); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinVrel_i); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinSTV_i); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinF_i); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinM_i); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyElemInflowType(SrcElemInflowTypeData, DstElemInflowTypeData, CtrlCode, ErrStat, ErrMsg)
   type(ElemInflowType), intent(in) :: SrcElemInflowTypeData
   type(ElemInflowType), intent(inout) :: DstElemInflowTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AD_CopyElemInflowType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcElemInflowTypeData%InflowVel)) then
      LB(1:2) = lbound(SrcElemInflowTypeData%InflowVel)
      UB(1:2) = ubound(SrcElemInflowTypeData%InflowVel)
      if (.not. allocated(DstElemInflowTypeData%InflowVel)) then
         allocate(DstElemInflowTypeData%InflowVel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstElemInflowTypeData%InflowVel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstElemInflowTypeData%InflowVel = SrcElemInflowTypeData%InflowVel
   end if
   if (allocated(SrcElemInflowTypeData%InflowAcc)) then
      LB(1:2) = lbound(SrcElemInflowTypeData%InflowAcc)
      UB(1:2) = ubound(SrcElemInflowTypeData%InflowAcc)
      if (.not. allocated(DstElemInflowTypeData%InflowAcc)) then
         allocate(DstElemInflowTypeData%InflowAcc(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstElemInflowTypeData%InflowAcc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstElemInflowTypeData%InflowAcc = SrcElemInflowTypeData%InflowAcc
   end if
end subroutine

subroutine AD_DestroyElemInflowType(ElemInflowTypeData, ErrStat, ErrMsg)
   type(ElemInflowType), intent(inout) :: ElemInflowTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_DestroyElemInflowType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ElemInflowTypeData%InflowVel)) then
      deallocate(ElemInflowTypeData%InflowVel)
   end if
   if (allocated(ElemInflowTypeData%InflowAcc)) then
      deallocate(ElemInflowTypeData%InflowAcc)
   end if
end subroutine

subroutine AD_PackElemInflowType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ElemInflowType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackElemInflowType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%InflowVel)
   call RegPackAlloc(RF, InData%InflowAcc)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackElemInflowType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ElemInflowType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackElemInflowType'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%InflowVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%InflowAcc); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyRotInflowType(SrcRotInflowTypeData, DstRotInflowTypeData, CtrlCode, ErrStat, ErrMsg)
   type(RotInflowType), intent(in) :: SrcRotInflowTypeData
   type(RotInflowType), intent(inout) :: DstRotInflowTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyRotInflowType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcRotInflowTypeData%Blade)) then
      LB(1:1) = lbound(SrcRotInflowTypeData%Blade)
      UB(1:1) = ubound(SrcRotInflowTypeData%Blade)
      if (.not. allocated(DstRotInflowTypeData%Blade)) then
         allocate(DstRotInflowTypeData%Blade(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInflowTypeData%Blade.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyElemInflowType(SrcRotInflowTypeData%Blade(i1), DstRotInflowTypeData%Blade(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call AD_CopyElemInflowType(SrcRotInflowTypeData%Tower, DstRotInflowTypeData%Tower, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstRotInflowTypeData%InflowOnHub = SrcRotInflowTypeData%InflowOnHub
   DstRotInflowTypeData%InflowOnNacelle = SrcRotInflowTypeData%InflowOnNacelle
   DstRotInflowTypeData%InflowOnTailFin = SrcRotInflowTypeData%InflowOnTailFin
   DstRotInflowTypeData%AvgDiskVel = SrcRotInflowTypeData%AvgDiskVel
end subroutine

subroutine AD_DestroyRotInflowType(RotInflowTypeData, ErrStat, ErrMsg)
   type(RotInflowType), intent(inout) :: RotInflowTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyRotInflowType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(RotInflowTypeData%Blade)) then
      LB(1:1) = lbound(RotInflowTypeData%Blade)
      UB(1:1) = ubound(RotInflowTypeData%Blade)
      do i1 = LB(1), UB(1)
         call AD_DestroyElemInflowType(RotInflowTypeData%Blade(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotInflowTypeData%Blade)
   end if
   call AD_DestroyElemInflowType(RotInflowTypeData%Tower, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AD_PackRotInflowType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(RotInflowType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackRotInflowType'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%Blade))
   if (allocated(InData%Blade)) then
      call RegPackBounds(RF, 1, lbound(InData%Blade), ubound(InData%Blade))
      LB(1:1) = lbound(InData%Blade)
      UB(1:1) = ubound(InData%Blade)
      do i1 = LB(1), UB(1)
         call AD_PackElemInflowType(RF, InData%Blade(i1)) 
      end do
   end if
   call AD_PackElemInflowType(RF, InData%Tower) 
   call RegPack(RF, InData%InflowOnHub)
   call RegPack(RF, InData%InflowOnNacelle)
   call RegPack(RF, InData%InflowOnTailFin)
   call RegPack(RF, InData%AvgDiskVel)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackRotInflowType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(RotInflowType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackRotInflowType'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%Blade)) deallocate(OutData%Blade)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Blade(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Blade.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackElemInflowType(RF, OutData%Blade(i1)) ! Blade 
      end do
   end if
   call AD_UnpackElemInflowType(RF, OutData%Tower) ! Tower 
   call RegUnpack(RF, OutData%InflowOnHub); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InflowOnNacelle); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%InflowOnTailFin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AvgDiskVel); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyInflowType(SrcInflowTypeData, DstInflowTypeData, CtrlCode, ErrStat, ErrMsg)
   type(AD_InflowType), intent(in) :: SrcInflowTypeData
   type(AD_InflowType), intent(inout) :: DstInflowTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyInflowType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInflowTypeData%InflowWakeVel)) then
      LB(1:2) = lbound(SrcInflowTypeData%InflowWakeVel)
      UB(1:2) = ubound(SrcInflowTypeData%InflowWakeVel)
      if (.not. allocated(DstInflowTypeData%InflowWakeVel)) then
         allocate(DstInflowTypeData%InflowWakeVel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInflowTypeData%InflowWakeVel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInflowTypeData%InflowWakeVel = SrcInflowTypeData%InflowWakeVel
   end if
   if (allocated(SrcInflowTypeData%RotInflow)) then
      LB(1:1) = lbound(SrcInflowTypeData%RotInflow)
      UB(1:1) = ubound(SrcInflowTypeData%RotInflow)
      if (.not. allocated(DstInflowTypeData%RotInflow)) then
         allocate(DstInflowTypeData%RotInflow(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInflowTypeData%RotInflow.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyRotInflowType(SrcInflowTypeData%RotInflow(i1), DstInflowTypeData%RotInflow(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine AD_DestroyInflowType(InflowTypeData, ErrStat, ErrMsg)
   type(AD_InflowType), intent(inout) :: InflowTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyInflowType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InflowTypeData%InflowWakeVel)) then
      deallocate(InflowTypeData%InflowWakeVel)
   end if
   if (allocated(InflowTypeData%RotInflow)) then
      LB(1:1) = lbound(InflowTypeData%RotInflow)
      UB(1:1) = ubound(InflowTypeData%RotInflow)
      do i1 = LB(1), UB(1)
         call AD_DestroyRotInflowType(InflowTypeData%RotInflow(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InflowTypeData%RotInflow)
   end if
end subroutine

subroutine AD_PackInflowType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_InflowType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackInflowType'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%InflowWakeVel)
   call RegPack(RF, allocated(InData%RotInflow))
   if (allocated(InData%RotInflow)) then
      call RegPackBounds(RF, 1, lbound(InData%RotInflow), ubound(InData%RotInflow))
      LB(1:1) = lbound(InData%RotInflow)
      UB(1:1) = ubound(InData%RotInflow)
      do i1 = LB(1), UB(1)
         call AD_PackRotInflowType(RF, InData%RotInflow(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackInflowType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_InflowType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackInflowType'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%InflowWakeVel); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%RotInflow)) deallocate(OutData%RotInflow)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%RotInflow(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%RotInflow.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackRotInflowType(RF, OutData%RotInflow(i1)) ! RotInflow 
      end do
   end if
end subroutine

subroutine AD_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(AD_MiscVarType), intent(inout) :: SrcMiscData
   type(AD_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%rotors)) then
      LB(1:1) = lbound(SrcMiscData%rotors)
      UB(1:1) = ubound(SrcMiscData%rotors)
      if (.not. allocated(DstMiscData%rotors)) then
         allocate(DstMiscData%rotors(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%rotors.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyRotMiscVarType(SrcMiscData%rotors(i1), DstMiscData%rotors(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%FVW_u)) then
      LB(1:1) = lbound(SrcMiscData%FVW_u)
      UB(1:1) = ubound(SrcMiscData%FVW_u)
      if (.not. allocated(DstMiscData%FVW_u)) then
         allocate(DstMiscData%FVW_u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FVW_u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call FVW_CopyInput(SrcMiscData%FVW_u(i1), DstMiscData%FVW_u(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call FVW_CopyOutput(SrcMiscData%FVW_y, DstMiscData%FVW_y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FVW_CopyMisc(SrcMiscData%FVW, DstMiscData%FVW, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMiscData%WindPos)) then
      LB(1:2) = lbound(SrcMiscData%WindPos)
      UB(1:2) = ubound(SrcMiscData%WindPos)
      if (.not. allocated(DstMiscData%WindPos)) then
         allocate(DstMiscData%WindPos(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%WindPos.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%WindPos = SrcMiscData%WindPos
   end if
   if (allocated(SrcMiscData%WindVel)) then
      LB(1:2) = lbound(SrcMiscData%WindVel)
      UB(1:2) = ubound(SrcMiscData%WindVel)
      if (.not. allocated(DstMiscData%WindVel)) then
         allocate(DstMiscData%WindVel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%WindVel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%WindVel = SrcMiscData%WindVel
   end if
   if (allocated(SrcMiscData%WindAcc)) then
      LB(1:2) = lbound(SrcMiscData%WindAcc)
      UB(1:2) = ubound(SrcMiscData%WindAcc)
      if (.not. allocated(DstMiscData%WindAcc)) then
         allocate(DstMiscData%WindAcc(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%WindAcc.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%WindAcc = SrcMiscData%WindAcc
   end if
   if (allocated(SrcMiscData%Inflow)) then
      LB(1:1) = lbound(SrcMiscData%Inflow)
      UB(1:1) = ubound(SrcMiscData%Inflow)
      if (.not. allocated(DstMiscData%Inflow)) then
         allocate(DstMiscData%Inflow(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%Inflow.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyInflowType(SrcMiscData%Inflow(i1), DstMiscData%Inflow(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine AD_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(AD_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%rotors)) then
      LB(1:1) = lbound(MiscData%rotors)
      UB(1:1) = ubound(MiscData%rotors)
      do i1 = LB(1), UB(1)
         call AD_DestroyRotMiscVarType(MiscData%rotors(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%rotors)
   end if
   if (allocated(MiscData%FVW_u)) then
      LB(1:1) = lbound(MiscData%FVW_u)
      UB(1:1) = ubound(MiscData%FVW_u)
      do i1 = LB(1), UB(1)
         call FVW_DestroyInput(MiscData%FVW_u(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%FVW_u)
   end if
   call FVW_DestroyOutput(MiscData%FVW_y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FVW_DestroyMisc(MiscData%FVW, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MiscData%WindPos)) then
      deallocate(MiscData%WindPos)
   end if
   if (allocated(MiscData%WindVel)) then
      deallocate(MiscData%WindVel)
   end if
   if (allocated(MiscData%WindAcc)) then
      deallocate(MiscData%WindAcc)
   end if
   if (allocated(MiscData%Inflow)) then
      LB(1:1) = lbound(MiscData%Inflow)
      UB(1:1) = ubound(MiscData%Inflow)
      do i1 = LB(1), UB(1)
         call AD_DestroyInflowType(MiscData%Inflow(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%Inflow)
   end if
end subroutine

subroutine AD_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackMisc'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%rotors))
   if (allocated(InData%rotors)) then
      call RegPackBounds(RF, 1, lbound(InData%rotors), ubound(InData%rotors))
      LB(1:1) = lbound(InData%rotors)
      UB(1:1) = ubound(InData%rotors)
      do i1 = LB(1), UB(1)
         call AD_PackRotMiscVarType(RF, InData%rotors(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%FVW_u))
   if (allocated(InData%FVW_u)) then
      call RegPackBounds(RF, 1, lbound(InData%FVW_u), ubound(InData%FVW_u))
      LB(1:1) = lbound(InData%FVW_u)
      UB(1:1) = ubound(InData%FVW_u)
      do i1 = LB(1), UB(1)
         call FVW_PackInput(RF, InData%FVW_u(i1)) 
      end do
   end if
   call FVW_PackOutput(RF, InData%FVW_y) 
   call FVW_PackMisc(RF, InData%FVW) 
   call RegPackAlloc(RF, InData%WindPos)
   call RegPackAlloc(RF, InData%WindVel)
   call RegPackAlloc(RF, InData%WindAcc)
   call RegPack(RF, allocated(InData%Inflow))
   if (allocated(InData%Inflow)) then
      call RegPackBounds(RF, 1, lbound(InData%Inflow), ubound(InData%Inflow))
      LB(1:1) = lbound(InData%Inflow)
      UB(1:1) = ubound(InData%Inflow)
      do i1 = LB(1), UB(1)
         call AD_PackInflowType(RF, InData%Inflow(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackMisc'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%rotors)) deallocate(OutData%rotors)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%rotors(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotors.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackRotMiscVarType(RF, OutData%rotors(i1)) ! rotors 
      end do
   end if
   if (allocated(OutData%FVW_u)) deallocate(OutData%FVW_u)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%FVW_u(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FVW_u.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call FVW_UnpackInput(RF, OutData%FVW_u(i1)) ! FVW_u 
      end do
   end if
   call FVW_UnpackOutput(RF, OutData%FVW_y) ! FVW_y 
   call FVW_UnpackMisc(RF, OutData%FVW) ! FVW 
   call RegUnpackAlloc(RF, OutData%WindPos); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WindVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WindAcc); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%Inflow)) deallocate(OutData%Inflow)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Inflow(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Inflow.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackInflowType(RF, OutData%Inflow(i1)) ! Inflow 
      end do
   end if
end subroutine

subroutine AD_CopyJac_u_idxStarts(SrcJac_u_idxStartsData, DstJac_u_idxStartsData, CtrlCode, ErrStat, ErrMsg)
   type(Jac_u_idxStarts), intent(in) :: SrcJac_u_idxStartsData
   type(Jac_u_idxStarts), intent(inout) :: DstJac_u_idxStartsData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_CopyJac_u_idxStarts'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstJac_u_idxStartsData%Nacelle = SrcJac_u_idxStartsData%Nacelle
   DstJac_u_idxStartsData%Hub = SrcJac_u_idxStartsData%Hub
   DstJac_u_idxStartsData%TFin = SrcJac_u_idxStartsData%TFin
   DstJac_u_idxStartsData%Tower = SrcJac_u_idxStartsData%Tower
   DstJac_u_idxStartsData%BladeRoot = SrcJac_u_idxStartsData%BladeRoot
   DstJac_u_idxStartsData%Blade = SrcJac_u_idxStartsData%Blade
   DstJac_u_idxStartsData%UserProp = SrcJac_u_idxStartsData%UserProp
   DstJac_u_idxStartsData%Extended = SrcJac_u_idxStartsData%Extended
end subroutine

subroutine AD_DestroyJac_u_idxStarts(Jac_u_idxStartsData, ErrStat, ErrMsg)
   type(Jac_u_idxStarts), intent(inout) :: Jac_u_idxStartsData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_DestroyJac_u_idxStarts'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AD_PackJac_u_idxStarts(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Jac_u_idxStarts), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackJac_u_idxStarts'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Nacelle)
   call RegPack(RF, InData%Hub)
   call RegPack(RF, InData%TFin)
   call RegPack(RF, InData%Tower)
   call RegPack(RF, InData%BladeRoot)
   call RegPack(RF, InData%Blade)
   call RegPack(RF, InData%UserProp)
   call RegPack(RF, InData%Extended)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackJac_u_idxStarts(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Jac_u_idxStarts), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackJac_u_idxStarts'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Nacelle); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Hub); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Tower); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BladeRoot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Blade); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UserProp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Extended); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyJac_y_idxStarts(SrcJac_y_idxStartsData, DstJac_y_idxStartsData, CtrlCode, ErrStat, ErrMsg)
   type(Jac_y_idxStarts), intent(in) :: SrcJac_y_idxStartsData
   type(Jac_y_idxStarts), intent(inout) :: DstJac_y_idxStartsData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_CopyJac_y_idxStarts'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstJac_y_idxStartsData%NacelleLoad = SrcJac_y_idxStartsData%NacelleLoad
   DstJac_y_idxStartsData%HubLoad = SrcJac_y_idxStartsData%HubLoad
   DstJac_y_idxStartsData%TFinLoad = SrcJac_y_idxStartsData%TFinLoad
   DstJac_y_idxStartsData%TowerLoad = SrcJac_y_idxStartsData%TowerLoad
   DstJac_y_idxStartsData%BladeLoad = SrcJac_y_idxStartsData%BladeLoad
end subroutine

subroutine AD_DestroyJac_y_idxStarts(Jac_y_idxStartsData, ErrStat, ErrMsg)
   type(Jac_y_idxStarts), intent(inout) :: Jac_y_idxStartsData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_DestroyJac_y_idxStarts'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AD_PackJac_y_idxStarts(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Jac_y_idxStarts), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackJac_y_idxStarts'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NacelleLoad)
   call RegPack(RF, InData%HubLoad)
   call RegPack(RF, InData%TFinLoad)
   call RegPack(RF, InData%TowerLoad)
   call RegPack(RF, InData%BladeLoad)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackJac_y_idxStarts(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Jac_y_idxStarts), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackJac_y_idxStarts'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NacelleLoad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubLoad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinLoad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TowerLoad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BladeLoad); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyRotParameterType(SrcRotParameterTypeData, DstRotParameterTypeData, CtrlCode, ErrStat, ErrMsg)
   type(RotParameterType), intent(in) :: SrcRotParameterTypeData
   type(RotParameterType), intent(inout) :: DstRotParameterTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyRotParameterType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstRotParameterTypeData%NumBlades = SrcRotParameterTypeData%NumBlades
   DstRotParameterTypeData%NumBlNds = SrcRotParameterTypeData%NumBlNds
   DstRotParameterTypeData%NumTwrNds = SrcRotParameterTypeData%NumTwrNds
   if (allocated(SrcRotParameterTypeData%TwrDiam)) then
      LB(1:1) = lbound(SrcRotParameterTypeData%TwrDiam)
      UB(1:1) = ubound(SrcRotParameterTypeData%TwrDiam)
      if (.not. allocated(DstRotParameterTypeData%TwrDiam)) then
         allocate(DstRotParameterTypeData%TwrDiam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%TwrDiam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%TwrDiam = SrcRotParameterTypeData%TwrDiam
   end if
   if (allocated(SrcRotParameterTypeData%TwrCd)) then
      LB(1:1) = lbound(SrcRotParameterTypeData%TwrCd)
      UB(1:1) = ubound(SrcRotParameterTypeData%TwrCd)
      if (.not. allocated(DstRotParameterTypeData%TwrCd)) then
         allocate(DstRotParameterTypeData%TwrCd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%TwrCd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%TwrCd = SrcRotParameterTypeData%TwrCd
   end if
   if (allocated(SrcRotParameterTypeData%TwrTI)) then
      LB(1:1) = lbound(SrcRotParameterTypeData%TwrTI)
      UB(1:1) = ubound(SrcRotParameterTypeData%TwrTI)
      if (.not. allocated(DstRotParameterTypeData%TwrTI)) then
         allocate(DstRotParameterTypeData%TwrTI(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%TwrTI.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%TwrTI = SrcRotParameterTypeData%TwrTI
   end if
   if (allocated(SrcRotParameterTypeData%BlTwist)) then
      LB(1:2) = lbound(SrcRotParameterTypeData%BlTwist)
      UB(1:2) = ubound(SrcRotParameterTypeData%BlTwist)
      if (.not. allocated(DstRotParameterTypeData%BlTwist)) then
         allocate(DstRotParameterTypeData%BlTwist(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%BlTwist.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%BlTwist = SrcRotParameterTypeData%BlTwist
   end if
   if (allocated(SrcRotParameterTypeData%TwrCb)) then
      LB(1:1) = lbound(SrcRotParameterTypeData%TwrCb)
      UB(1:1) = ubound(SrcRotParameterTypeData%TwrCb)
      if (.not. allocated(DstRotParameterTypeData%TwrCb)) then
         allocate(DstRotParameterTypeData%TwrCb(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%TwrCb.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%TwrCb = SrcRotParameterTypeData%TwrCb
   end if
   if (allocated(SrcRotParameterTypeData%BlCenBn)) then
      LB(1:2) = lbound(SrcRotParameterTypeData%BlCenBn)
      UB(1:2) = ubound(SrcRotParameterTypeData%BlCenBn)
      if (.not. allocated(DstRotParameterTypeData%BlCenBn)) then
         allocate(DstRotParameterTypeData%BlCenBn(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%BlCenBn.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%BlCenBn = SrcRotParameterTypeData%BlCenBn
   end if
   if (allocated(SrcRotParameterTypeData%BlCenBt)) then
      LB(1:2) = lbound(SrcRotParameterTypeData%BlCenBt)
      UB(1:2) = ubound(SrcRotParameterTypeData%BlCenBt)
      if (.not. allocated(DstRotParameterTypeData%BlCenBt)) then
         allocate(DstRotParameterTypeData%BlCenBt(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%BlCenBt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%BlCenBt = SrcRotParameterTypeData%BlCenBt
   end if
   DstRotParameterTypeData%VolHub = SrcRotParameterTypeData%VolHub
   DstRotParameterTypeData%HubCenBx = SrcRotParameterTypeData%HubCenBx
   DstRotParameterTypeData%VolNac = SrcRotParameterTypeData%VolNac
   DstRotParameterTypeData%NacCenB = SrcRotParameterTypeData%NacCenB
   DstRotParameterTypeData%NacArea = SrcRotParameterTypeData%NacArea
   DstRotParameterTypeData%NacCd = SrcRotParameterTypeData%NacCd
   DstRotParameterTypeData%NacDragAC = SrcRotParameterTypeData%NacDragAC
   DstRotParameterTypeData%VolBl = SrcRotParameterTypeData%VolBl
   DstRotParameterTypeData%VolTwr = SrcRotParameterTypeData%VolTwr
   if (allocated(SrcRotParameterTypeData%BlRad)) then
      LB(1:2) = lbound(SrcRotParameterTypeData%BlRad)
      UB(1:2) = ubound(SrcRotParameterTypeData%BlRad)
      if (.not. allocated(DstRotParameterTypeData%BlRad)) then
         allocate(DstRotParameterTypeData%BlRad(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%BlRad.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%BlRad = SrcRotParameterTypeData%BlRad
   end if
   if (allocated(SrcRotParameterTypeData%BlDL)) then
      LB(1:2) = lbound(SrcRotParameterTypeData%BlDL)
      UB(1:2) = ubound(SrcRotParameterTypeData%BlDL)
      if (.not. allocated(DstRotParameterTypeData%BlDL)) then
         allocate(DstRotParameterTypeData%BlDL(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%BlDL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%BlDL = SrcRotParameterTypeData%BlDL
   end if
   if (allocated(SrcRotParameterTypeData%BlTaper)) then
      LB(1:2) = lbound(SrcRotParameterTypeData%BlTaper)
      UB(1:2) = ubound(SrcRotParameterTypeData%BlTaper)
      if (.not. allocated(DstRotParameterTypeData%BlTaper)) then
         allocate(DstRotParameterTypeData%BlTaper(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%BlTaper.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%BlTaper = SrcRotParameterTypeData%BlTaper
   end if
   if (allocated(SrcRotParameterTypeData%BlAxCent)) then
      LB(1:2) = lbound(SrcRotParameterTypeData%BlAxCent)
      UB(1:2) = ubound(SrcRotParameterTypeData%BlAxCent)
      if (.not. allocated(DstRotParameterTypeData%BlAxCent)) then
         allocate(DstRotParameterTypeData%BlAxCent(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%BlAxCent.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%BlAxCent = SrcRotParameterTypeData%BlAxCent
   end if
   if (allocated(SrcRotParameterTypeData%TwrRad)) then
      LB(1:1) = lbound(SrcRotParameterTypeData%TwrRad)
      UB(1:1) = ubound(SrcRotParameterTypeData%TwrRad)
      if (.not. allocated(DstRotParameterTypeData%TwrRad)) then
         allocate(DstRotParameterTypeData%TwrRad(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%TwrRad.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%TwrRad = SrcRotParameterTypeData%TwrRad
   end if
   if (allocated(SrcRotParameterTypeData%TwrDL)) then
      LB(1:1) = lbound(SrcRotParameterTypeData%TwrDL)
      UB(1:1) = ubound(SrcRotParameterTypeData%TwrDL)
      if (.not. allocated(DstRotParameterTypeData%TwrDL)) then
         allocate(DstRotParameterTypeData%TwrDL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%TwrDL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%TwrDL = SrcRotParameterTypeData%TwrDL
   end if
   if (allocated(SrcRotParameterTypeData%TwrTaper)) then
      LB(1:1) = lbound(SrcRotParameterTypeData%TwrTaper)
      UB(1:1) = ubound(SrcRotParameterTypeData%TwrTaper)
      if (.not. allocated(DstRotParameterTypeData%TwrTaper)) then
         allocate(DstRotParameterTypeData%TwrTaper(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%TwrTaper.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%TwrTaper = SrcRotParameterTypeData%TwrTaper
   end if
   if (allocated(SrcRotParameterTypeData%TwrAxCent)) then
      LB(1:1) = lbound(SrcRotParameterTypeData%TwrAxCent)
      UB(1:1) = ubound(SrcRotParameterTypeData%TwrAxCent)
      if (.not. allocated(DstRotParameterTypeData%TwrAxCent)) then
         allocate(DstRotParameterTypeData%TwrAxCent(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%TwrAxCent.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%TwrAxCent = SrcRotParameterTypeData%TwrAxCent
   end if
   call BEMT_CopyParam(SrcRotParameterTypeData%BEMT, DstRotParameterTypeData%BEMT, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AA_CopyParam(SrcRotParameterTypeData%AA, DstRotParameterTypeData%AA, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcRotParameterTypeData%Jac_u_indx)) then
      LB(1:2) = lbound(SrcRotParameterTypeData%Jac_u_indx)
      UB(1:2) = ubound(SrcRotParameterTypeData%Jac_u_indx)
      if (.not. allocated(DstRotParameterTypeData%Jac_u_indx)) then
         allocate(DstRotParameterTypeData%Jac_u_indx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%Jac_u_indx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%Jac_u_indx = SrcRotParameterTypeData%Jac_u_indx
   end if
   call AD_CopyJac_u_idxStarts(SrcRotParameterTypeData%Jac_u_idxStartList, DstRotParameterTypeData%Jac_u_idxStartList, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AD_CopyJac_y_idxStarts(SrcRotParameterTypeData%Jac_y_idxStartList, DstRotParameterTypeData%Jac_y_idxStartList, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstRotParameterTypeData%NumExtendedInputs = SrcRotParameterTypeData%NumExtendedInputs
   if (allocated(SrcRotParameterTypeData%du)) then
      LB(1:1) = lbound(SrcRotParameterTypeData%du)
      UB(1:1) = ubound(SrcRotParameterTypeData%du)
      if (.not. allocated(DstRotParameterTypeData%du)) then
         allocate(DstRotParameterTypeData%du(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%du.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%du = SrcRotParameterTypeData%du
   end if
   if (allocated(SrcRotParameterTypeData%dx)) then
      LB(1:1) = lbound(SrcRotParameterTypeData%dx)
      UB(1:1) = ubound(SrcRotParameterTypeData%dx)
      if (.not. allocated(DstRotParameterTypeData%dx)) then
         allocate(DstRotParameterTypeData%dx(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%dx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%dx = SrcRotParameterTypeData%dx
   end if
   DstRotParameterTypeData%Jac_ny = SrcRotParameterTypeData%Jac_ny
   DstRotParameterTypeData%NumBl_Lin = SrcRotParameterTypeData%NumBl_Lin
   DstRotParameterTypeData%TwrPotent = SrcRotParameterTypeData%TwrPotent
   DstRotParameterTypeData%TwrShadow = SrcRotParameterTypeData%TwrShadow
   DstRotParameterTypeData%TwrAero = SrcRotParameterTypeData%TwrAero
   DstRotParameterTypeData%DBEMT_Mod = SrcRotParameterTypeData%DBEMT_Mod
   DstRotParameterTypeData%CavitCheck = SrcRotParameterTypeData%CavitCheck
   DstRotParameterTypeData%Buoyancy = SrcRotParameterTypeData%Buoyancy
   DstRotParameterTypeData%NacelleDrag = SrcRotParameterTypeData%NacelleDrag
   DstRotParameterTypeData%MHK = SrcRotParameterTypeData%MHK
   DstRotParameterTypeData%CompAA = SrcRotParameterTypeData%CompAA
   DstRotParameterTypeData%AirDens = SrcRotParameterTypeData%AirDens
   DstRotParameterTypeData%KinVisc = SrcRotParameterTypeData%KinVisc
   DstRotParameterTypeData%SpdSound = SrcRotParameterTypeData%SpdSound
   DstRotParameterTypeData%Gravity = SrcRotParameterTypeData%Gravity
   DstRotParameterTypeData%Patm = SrcRotParameterTypeData%Patm
   DstRotParameterTypeData%Pvap = SrcRotParameterTypeData%Pvap
   DstRotParameterTypeData%WtrDpth = SrcRotParameterTypeData%WtrDpth
   DstRotParameterTypeData%MSL2SWL = SrcRotParameterTypeData%MSL2SWL
   DstRotParameterTypeData%AeroProjMod = SrcRotParameterTypeData%AeroProjMod
   DstRotParameterTypeData%BEM_Mod = SrcRotParameterTypeData%BEM_Mod
   DstRotParameterTypeData%NumOuts = SrcRotParameterTypeData%NumOuts
   DstRotParameterTypeData%RootName = SrcRotParameterTypeData%RootName
   if (allocated(SrcRotParameterTypeData%OutParam)) then
      LB(1:1) = lbound(SrcRotParameterTypeData%OutParam)
      UB(1:1) = ubound(SrcRotParameterTypeData%OutParam)
      if (.not. allocated(DstRotParameterTypeData%OutParam)) then
         allocate(DstRotParameterTypeData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcRotParameterTypeData%OutParam(i1), DstRotParameterTypeData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstRotParameterTypeData%NBlOuts = SrcRotParameterTypeData%NBlOuts
   DstRotParameterTypeData%BlOutNd = SrcRotParameterTypeData%BlOutNd
   DstRotParameterTypeData%NTwOuts = SrcRotParameterTypeData%NTwOuts
   DstRotParameterTypeData%TwOutNd = SrcRotParameterTypeData%TwOutNd
   DstRotParameterTypeData%BldNd_NumOuts = SrcRotParameterTypeData%BldNd_NumOuts
   DstRotParameterTypeData%BldNd_TotNumOuts = SrcRotParameterTypeData%BldNd_TotNumOuts
   if (allocated(SrcRotParameterTypeData%BldNd_OutParam)) then
      LB(1:1) = lbound(SrcRotParameterTypeData%BldNd_OutParam)
      UB(1:1) = ubound(SrcRotParameterTypeData%BldNd_OutParam)
      if (.not. allocated(DstRotParameterTypeData%BldNd_OutParam)) then
         allocate(DstRotParameterTypeData%BldNd_OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%BldNd_OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcRotParameterTypeData%BldNd_OutParam(i1), DstRotParameterTypeData%BldNd_OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcRotParameterTypeData%BldNd_BlOutNd)) then
      LB(1:1) = lbound(SrcRotParameterTypeData%BldNd_BlOutNd)
      UB(1:1) = ubound(SrcRotParameterTypeData%BldNd_BlOutNd)
      if (.not. allocated(DstRotParameterTypeData%BldNd_BlOutNd)) then
         allocate(DstRotParameterTypeData%BldNd_BlOutNd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotParameterTypeData%BldNd_BlOutNd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotParameterTypeData%BldNd_BlOutNd = SrcRotParameterTypeData%BldNd_BlOutNd
   end if
   DstRotParameterTypeData%BldNd_BladesOut = SrcRotParameterTypeData%BldNd_BladesOut
   DstRotParameterTypeData%BldNd_NumNodesOut = SrcRotParameterTypeData%BldNd_NumNodesOut
   DstRotParameterTypeData%TFinAero = SrcRotParameterTypeData%TFinAero
   call AD_CopyTFinParameterType(SrcRotParameterTypeData%TFin, DstRotParameterTypeData%TFin, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine AD_DestroyRotParameterType(RotParameterTypeData, ErrStat, ErrMsg)
   type(RotParameterType), intent(inout) :: RotParameterTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyRotParameterType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(RotParameterTypeData%TwrDiam)) then
      deallocate(RotParameterTypeData%TwrDiam)
   end if
   if (allocated(RotParameterTypeData%TwrCd)) then
      deallocate(RotParameterTypeData%TwrCd)
   end if
   if (allocated(RotParameterTypeData%TwrTI)) then
      deallocate(RotParameterTypeData%TwrTI)
   end if
   if (allocated(RotParameterTypeData%BlTwist)) then
      deallocate(RotParameterTypeData%BlTwist)
   end if
   if (allocated(RotParameterTypeData%TwrCb)) then
      deallocate(RotParameterTypeData%TwrCb)
   end if
   if (allocated(RotParameterTypeData%BlCenBn)) then
      deallocate(RotParameterTypeData%BlCenBn)
   end if
   if (allocated(RotParameterTypeData%BlCenBt)) then
      deallocate(RotParameterTypeData%BlCenBt)
   end if
   if (allocated(RotParameterTypeData%BlRad)) then
      deallocate(RotParameterTypeData%BlRad)
   end if
   if (allocated(RotParameterTypeData%BlDL)) then
      deallocate(RotParameterTypeData%BlDL)
   end if
   if (allocated(RotParameterTypeData%BlTaper)) then
      deallocate(RotParameterTypeData%BlTaper)
   end if
   if (allocated(RotParameterTypeData%BlAxCent)) then
      deallocate(RotParameterTypeData%BlAxCent)
   end if
   if (allocated(RotParameterTypeData%TwrRad)) then
      deallocate(RotParameterTypeData%TwrRad)
   end if
   if (allocated(RotParameterTypeData%TwrDL)) then
      deallocate(RotParameterTypeData%TwrDL)
   end if
   if (allocated(RotParameterTypeData%TwrTaper)) then
      deallocate(RotParameterTypeData%TwrTaper)
   end if
   if (allocated(RotParameterTypeData%TwrAxCent)) then
      deallocate(RotParameterTypeData%TwrAxCent)
   end if
   call BEMT_DestroyParam(RotParameterTypeData%BEMT, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AA_DestroyParam(RotParameterTypeData%AA, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(RotParameterTypeData%Jac_u_indx)) then
      deallocate(RotParameterTypeData%Jac_u_indx)
   end if
   call AD_DestroyJac_u_idxStarts(RotParameterTypeData%Jac_u_idxStartList, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AD_DestroyJac_y_idxStarts(RotParameterTypeData%Jac_y_idxStartList, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(RotParameterTypeData%du)) then
      deallocate(RotParameterTypeData%du)
   end if
   if (allocated(RotParameterTypeData%dx)) then
      deallocate(RotParameterTypeData%dx)
   end if
   if (allocated(RotParameterTypeData%OutParam)) then
      LB(1:1) = lbound(RotParameterTypeData%OutParam)
      UB(1:1) = ubound(RotParameterTypeData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(RotParameterTypeData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotParameterTypeData%OutParam)
   end if
   if (allocated(RotParameterTypeData%BldNd_OutParam)) then
      LB(1:1) = lbound(RotParameterTypeData%BldNd_OutParam)
      UB(1:1) = ubound(RotParameterTypeData%BldNd_OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(RotParameterTypeData%BldNd_OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotParameterTypeData%BldNd_OutParam)
   end if
   if (allocated(RotParameterTypeData%BldNd_BlOutNd)) then
      deallocate(RotParameterTypeData%BldNd_BlOutNd)
   end if
   call AD_DestroyTFinParameterType(RotParameterTypeData%TFin, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AD_PackRotParameterType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(RotParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackRotParameterType'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NumBlades)
   call RegPack(RF, InData%NumBlNds)
   call RegPack(RF, InData%NumTwrNds)
   call RegPackAlloc(RF, InData%TwrDiam)
   call RegPackAlloc(RF, InData%TwrCd)
   call RegPackAlloc(RF, InData%TwrTI)
   call RegPackAlloc(RF, InData%BlTwist)
   call RegPackAlloc(RF, InData%TwrCb)
   call RegPackAlloc(RF, InData%BlCenBn)
   call RegPackAlloc(RF, InData%BlCenBt)
   call RegPack(RF, InData%VolHub)
   call RegPack(RF, InData%HubCenBx)
   call RegPack(RF, InData%VolNac)
   call RegPack(RF, InData%NacCenB)
   call RegPack(RF, InData%NacArea)
   call RegPack(RF, InData%NacCd)
   call RegPack(RF, InData%NacDragAC)
   call RegPack(RF, InData%VolBl)
   call RegPack(RF, InData%VolTwr)
   call RegPackAlloc(RF, InData%BlRad)
   call RegPackAlloc(RF, InData%BlDL)
   call RegPackAlloc(RF, InData%BlTaper)
   call RegPackAlloc(RF, InData%BlAxCent)
   call RegPackAlloc(RF, InData%TwrRad)
   call RegPackAlloc(RF, InData%TwrDL)
   call RegPackAlloc(RF, InData%TwrTaper)
   call RegPackAlloc(RF, InData%TwrAxCent)
   call BEMT_PackParam(RF, InData%BEMT) 
   call AA_PackParam(RF, InData%AA) 
   call RegPackAlloc(RF, InData%Jac_u_indx)
   call AD_PackJac_u_idxStarts(RF, InData%Jac_u_idxStartList) 
   call AD_PackJac_y_idxStarts(RF, InData%Jac_y_idxStartList) 
   call RegPack(RF, InData%NumExtendedInputs)
   call RegPackAlloc(RF, InData%du)
   call RegPackAlloc(RF, InData%dx)
   call RegPack(RF, InData%Jac_ny)
   call RegPack(RF, InData%NumBl_Lin)
   call RegPack(RF, InData%TwrPotent)
   call RegPack(RF, InData%TwrShadow)
   call RegPack(RF, InData%TwrAero)
   call RegPack(RF, InData%DBEMT_Mod)
   call RegPack(RF, InData%CavitCheck)
   call RegPack(RF, InData%Buoyancy)
   call RegPack(RF, InData%NacelleDrag)
   call RegPack(RF, InData%MHK)
   call RegPack(RF, InData%CompAA)
   call RegPack(RF, InData%AirDens)
   call RegPack(RF, InData%KinVisc)
   call RegPack(RF, InData%SpdSound)
   call RegPack(RF, InData%Gravity)
   call RegPack(RF, InData%Patm)
   call RegPack(RF, InData%Pvap)
   call RegPack(RF, InData%WtrDpth)
   call RegPack(RF, InData%MSL2SWL)
   call RegPack(RF, InData%AeroProjMod)
   call RegPack(RF, InData%BEM_Mod)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPack(RF, InData%NBlOuts)
   call RegPack(RF, InData%BlOutNd)
   call RegPack(RF, InData%NTwOuts)
   call RegPack(RF, InData%TwOutNd)
   call RegPack(RF, InData%BldNd_NumOuts)
   call RegPack(RF, InData%BldNd_TotNumOuts)
   call RegPack(RF, allocated(InData%BldNd_OutParam))
   if (allocated(InData%BldNd_OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%BldNd_OutParam), ubound(InData%BldNd_OutParam))
      LB(1:1) = lbound(InData%BldNd_OutParam)
      UB(1:1) = ubound(InData%BldNd_OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%BldNd_OutParam(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%BldNd_BlOutNd)
   call RegPack(RF, InData%BldNd_BladesOut)
   call RegPack(RF, InData%BldNd_NumNodesOut)
   call RegPack(RF, InData%TFinAero)
   call AD_PackTFinParameterType(RF, InData%TFin) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackRotParameterType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(RotParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackRotParameterType'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NumBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBlNds); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumTwrNds); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrDiam); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrCd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrTI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlTwist); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrCb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlCenBn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlCenBt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VolHub); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubCenBx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VolNac); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacCenB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacArea); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacCd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacDragAC); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VolBl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VolTwr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlDL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlTaper); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlAxCent); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrDL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrTaper); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TwrAxCent); if (RegCheckErr(RF, RoutineName)) return
   call BEMT_UnpackParam(RF, OutData%BEMT) ! BEMT 
   call AA_UnpackParam(RF, OutData%AA) ! AA 
   call RegUnpackAlloc(RF, OutData%Jac_u_indx); if (RegCheckErr(RF, RoutineName)) return
   call AD_UnpackJac_u_idxStarts(RF, OutData%Jac_u_idxStartList) ! Jac_u_idxStartList 
   call AD_UnpackJac_y_idxStarts(RF, OutData%Jac_y_idxStartList) ! Jac_y_idxStartList 
   call RegUnpack(RF, OutData%NumExtendedInputs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%du); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Jac_ny); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBl_Lin); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrPotent); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrShadow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwrAero); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DBEMT_Mod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CavitCheck); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Buoyancy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacelleDrag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MHK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompAA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AirDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%KinVisc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SpdSound); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Gravity); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Patm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Pvap); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MSL2SWL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AeroProjMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BEM_Mod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpack(RF, OutData%NBlOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BlOutNd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NTwOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TwOutNd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_TotNumOuts); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BldNd_OutParam)) deallocate(OutData%BldNd_OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BldNd_OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BldNd_OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%BldNd_OutParam(i1)) ! BldNd_OutParam 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%BldNd_BlOutNd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_BladesOut); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BldNd_NumNodesOut); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TFinAero); if (RegCheckErr(RF, RoutineName)) return
   call AD_UnpackTFinParameterType(RF, OutData%TFin) ! TFin 
end subroutine

subroutine AD_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(AD_ParameterType), intent(in) :: SrcParamData
   type(AD_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcParamData%rotors)) then
      LB(1:1) = lbound(SrcParamData%rotors)
      UB(1:1) = ubound(SrcParamData%rotors)
      if (.not. allocated(DstParamData%rotors)) then
         allocate(DstParamData%rotors(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rotors.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyRotParameterType(SrcParamData%rotors(i1), DstParamData%rotors(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%DT = SrcParamData%DT
   DstParamData%RootName = SrcParamData%RootName
   if (allocated(SrcParamData%AFI)) then
      LB(1:1) = lbound(SrcParamData%AFI)
      UB(1:1) = ubound(SrcParamData%AFI)
      if (.not. allocated(DstParamData%AFI)) then
         allocate(DstParamData%AFI(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AFI.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AFI_CopyParam(SrcParamData%AFI(i1), DstParamData%AFI(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%Skew_Mod = SrcParamData%Skew_Mod
   DstParamData%Wake_Mod = SrcParamData%Wake_Mod
   call FVW_CopyParam(SrcParamData%FVW, DstParamData%FVW, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstParamData%CompAeroMaps = SrcParamData%CompAeroMaps
   DstParamData%UA_Flag = SrcParamData%UA_Flag
   DstParamData%FlowField => SrcParamData%FlowField
   DstParamData%SectAvg = SrcParamData%SectAvg
   DstParamData%SA_Weighting = SrcParamData%SA_Weighting
   DstParamData%SA_PsiBwd = SrcParamData%SA_PsiBwd
   DstParamData%SA_PsiFwd = SrcParamData%SA_PsiFwd
   DstParamData%SA_nPerSec = SrcParamData%SA_nPerSec
end subroutine

subroutine AD_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(AD_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%rotors)) then
      LB(1:1) = lbound(ParamData%rotors)
      UB(1:1) = ubound(ParamData%rotors)
      do i1 = LB(1), UB(1)
         call AD_DestroyRotParameterType(ParamData%rotors(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%rotors)
   end if
   if (allocated(ParamData%AFI)) then
      LB(1:1) = lbound(ParamData%AFI)
      UB(1:1) = ubound(ParamData%AFI)
      do i1 = LB(1), UB(1)
         call AFI_DestroyParam(ParamData%AFI(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%AFI)
   end if
   call FVW_DestroyParam(ParamData%FVW, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   nullify(ParamData%FlowField)
end subroutine

subroutine AD_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackParam'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%rotors))
   if (allocated(InData%rotors)) then
      call RegPackBounds(RF, 1, lbound(InData%rotors), ubound(InData%rotors))
      LB(1:1) = lbound(InData%rotors)
      UB(1:1) = ubound(InData%rotors)
      do i1 = LB(1), UB(1)
         call AD_PackRotParameterType(RF, InData%rotors(i1)) 
      end do
   end if
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, allocated(InData%AFI))
   if (allocated(InData%AFI)) then
      call RegPackBounds(RF, 1, lbound(InData%AFI), ubound(InData%AFI))
      LB(1:1) = lbound(InData%AFI)
      UB(1:1) = ubound(InData%AFI)
      do i1 = LB(1), UB(1)
         call AFI_PackParam(RF, InData%AFI(i1)) 
      end do
   end if
   call RegPack(RF, InData%Skew_Mod)
   call RegPack(RF, InData%Wake_Mod)
   call FVW_PackParam(RF, InData%FVW) 
   call RegPack(RF, InData%CompAeroMaps)
   call RegPack(RF, InData%UA_Flag)
   call RegPack(RF, associated(InData%FlowField))
   if (associated(InData%FlowField)) then
      call RegPackPointer(RF, c_loc(InData%FlowField), PtrInIndex)
      if (.not. PtrInIndex) then
         call IfW_FlowField_PackFlowFieldType(RF, InData%FlowField) 
      end if
   end if
   call RegPack(RF, InData%SectAvg)
   call RegPack(RF, InData%SA_Weighting)
   call RegPack(RF, InData%SA_PsiBwd)
   call RegPack(RF, InData%SA_PsiFwd)
   call RegPack(RF, InData%SA_nPerSec)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackParam'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%rotors)) deallocate(OutData%rotors)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%rotors(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotors.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackRotParameterType(RF, OutData%rotors(i1)) ! rotors 
      end do
   end if
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%AFI)) deallocate(OutData%AFI)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%AFI(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%AFI.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AFI_UnpackParam(RF, OutData%AFI(i1)) ! AFI 
      end do
   end if
   call RegUnpack(RF, OutData%Skew_Mod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Wake_Mod); if (RegCheckErr(RF, RoutineName)) return
   call FVW_UnpackParam(RF, OutData%FVW) ! FVW 
   call RegUnpack(RF, OutData%CompAeroMaps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UA_Flag); if (RegCheckErr(RF, RoutineName)) return
   if (associated(OutData%FlowField)) deallocate(OutData%FlowField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%FlowField)
      else
         allocate(OutData%FlowField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FlowField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%FlowField)
         call IfW_FlowField_UnpackFlowFieldType(RF, OutData%FlowField) ! FlowField 
      end if
   else
      OutData%FlowField => null()
   end if
   call RegUnpack(RF, OutData%SectAvg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SA_Weighting); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SA_PsiBwd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SA_PsiFwd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SA_nPerSec); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyRotInputType(SrcRotInputTypeData, DstRotInputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(RotInputType), intent(inout) :: SrcRotInputTypeData
   type(RotInputType), intent(inout) :: DstRotInputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyRotInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcRotInputTypeData%NacelleMotion, DstRotInputTypeData%NacelleMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcRotInputTypeData%TowerMotion, DstRotInputTypeData%TowerMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcRotInputTypeData%HubMotion, DstRotInputTypeData%HubMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcRotInputTypeData%BladeRootMotion)) then
      LB(1:1) = lbound(SrcRotInputTypeData%BladeRootMotion)
      UB(1:1) = ubound(SrcRotInputTypeData%BladeRootMotion)
      if (.not. allocated(DstRotInputTypeData%BladeRootMotion)) then
         allocate(DstRotInputTypeData%BladeRootMotion(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInputTypeData%BladeRootMotion.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcRotInputTypeData%BladeRootMotion(i1), DstRotInputTypeData%BladeRootMotion(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcRotInputTypeData%BladeMotion)) then
      LB(1:1) = lbound(SrcRotInputTypeData%BladeMotion)
      UB(1:1) = ubound(SrcRotInputTypeData%BladeMotion)
      if (.not. allocated(DstRotInputTypeData%BladeMotion)) then
         allocate(DstRotInputTypeData%BladeMotion(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInputTypeData%BladeMotion.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcRotInputTypeData%BladeMotion(i1), DstRotInputTypeData%BladeMotion(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call MeshCopy(SrcRotInputTypeData%TFinMotion, DstRotInputTypeData%TFinMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcRotInputTypeData%UserProp)) then
      LB(1:2) = lbound(SrcRotInputTypeData%UserProp)
      UB(1:2) = ubound(SrcRotInputTypeData%UserProp)
      if (.not. allocated(DstRotInputTypeData%UserProp)) then
         allocate(DstRotInputTypeData%UserProp(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotInputTypeData%UserProp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotInputTypeData%UserProp = SrcRotInputTypeData%UserProp
   end if
end subroutine

subroutine AD_DestroyRotInputType(RotInputTypeData, ErrStat, ErrMsg)
   type(RotInputType), intent(inout) :: RotInputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyRotInputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( RotInputTypeData%NacelleMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( RotInputTypeData%TowerMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( RotInputTypeData%HubMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(RotInputTypeData%BladeRootMotion)) then
      LB(1:1) = lbound(RotInputTypeData%BladeRootMotion)
      UB(1:1) = ubound(RotInputTypeData%BladeRootMotion)
      do i1 = LB(1), UB(1)
         call MeshDestroy( RotInputTypeData%BladeRootMotion(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotInputTypeData%BladeRootMotion)
   end if
   if (allocated(RotInputTypeData%BladeMotion)) then
      LB(1:1) = lbound(RotInputTypeData%BladeMotion)
      UB(1:1) = ubound(RotInputTypeData%BladeMotion)
      do i1 = LB(1), UB(1)
         call MeshDestroy( RotInputTypeData%BladeMotion(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotInputTypeData%BladeMotion)
   end if
   call MeshDestroy( RotInputTypeData%TFinMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(RotInputTypeData%UserProp)) then
      deallocate(RotInputTypeData%UserProp)
   end if
end subroutine

subroutine AD_PackRotInputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(RotInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackRotInputType'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%NacelleMotion) 
   call MeshPack(RF, InData%TowerMotion) 
   call MeshPack(RF, InData%HubMotion) 
   call RegPack(RF, allocated(InData%BladeRootMotion))
   if (allocated(InData%BladeRootMotion)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeRootMotion), ubound(InData%BladeRootMotion))
      LB(1:1) = lbound(InData%BladeRootMotion)
      UB(1:1) = ubound(InData%BladeRootMotion)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeRootMotion(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%BladeMotion))
   if (allocated(InData%BladeMotion)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeMotion), ubound(InData%BladeMotion))
      LB(1:1) = lbound(InData%BladeMotion)
      UB(1:1) = ubound(InData%BladeMotion)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeMotion(i1)) 
      end do
   end if
   call MeshPack(RF, InData%TFinMotion) 
   call RegPackAlloc(RF, InData%UserProp)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackRotInputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(RotInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackRotInputType'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%NacelleMotion) ! NacelleMotion 
   call MeshUnpack(RF, OutData%TowerMotion) ! TowerMotion 
   call MeshUnpack(RF, OutData%HubMotion) ! HubMotion 
   if (allocated(OutData%BladeRootMotion)) deallocate(OutData%BladeRootMotion)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeRootMotion(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeRootMotion.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeRootMotion(i1)) ! BladeRootMotion 
      end do
   end if
   if (allocated(OutData%BladeMotion)) deallocate(OutData%BladeMotion)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeMotion(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeMotion.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeMotion(i1)) ! BladeMotion 
      end do
   end if
   call MeshUnpack(RF, OutData%TFinMotion) ! TFinMotion 
   call RegUnpackAlloc(RF, OutData%UserProp); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(AD_InputType), intent(inout) :: SrcInputData
   type(AD_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInputData%rotors)) then
      LB(1:1) = lbound(SrcInputData%rotors)
      UB(1:1) = ubound(SrcInputData%rotors)
      if (.not. allocated(DstInputData%rotors)) then
         allocate(DstInputData%rotors(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%rotors.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyRotInputType(SrcInputData%rotors(i1), DstInputData%rotors(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine AD_DestroyInput(InputData, ErrStat, ErrMsg)
   type(AD_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%rotors)) then
      LB(1:1) = lbound(InputData%rotors)
      UB(1:1) = ubound(InputData%rotors)
      do i1 = LB(1), UB(1)
         call AD_DestroyRotInputType(InputData%rotors(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputData%rotors)
   end if
end subroutine

subroutine AD_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackInput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%rotors))
   if (allocated(InData%rotors)) then
      call RegPackBounds(RF, 1, lbound(InData%rotors), ubound(InData%rotors))
      LB(1:1) = lbound(InData%rotors)
      UB(1:1) = ubound(InData%rotors)
      do i1 = LB(1), UB(1)
         call AD_PackRotInputType(RF, InData%rotors(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackInput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%rotors)) deallocate(OutData%rotors)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%rotors(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotors.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackRotInputType(RF, OutData%rotors(i1)) ! rotors 
      end do
   end if
end subroutine

subroutine AD_CopyRotOutputType(SrcRotOutputTypeData, DstRotOutputTypeData, CtrlCode, ErrStat, ErrMsg)
   type(RotOutputType), intent(inout) :: SrcRotOutputTypeData
   type(RotOutputType), intent(inout) :: DstRotOutputTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyRotOutputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcRotOutputTypeData%NacelleLoad, DstRotOutputTypeData%NacelleLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcRotOutputTypeData%HubLoad, DstRotOutputTypeData%HubLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcRotOutputTypeData%TowerLoad, DstRotOutputTypeData%TowerLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcRotOutputTypeData%BladeLoad)) then
      LB(1:1) = lbound(SrcRotOutputTypeData%BladeLoad)
      UB(1:1) = ubound(SrcRotOutputTypeData%BladeLoad)
      if (.not. allocated(DstRotOutputTypeData%BladeLoad)) then
         allocate(DstRotOutputTypeData%BladeLoad(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotOutputTypeData%BladeLoad.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcRotOutputTypeData%BladeLoad(i1), DstRotOutputTypeData%BladeLoad(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call MeshCopy(SrcRotOutputTypeData%TFinLoad, DstRotOutputTypeData%TFinLoad, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcRotOutputTypeData%WriteOutput)) then
      LB(1:1) = lbound(SrcRotOutputTypeData%WriteOutput)
      UB(1:1) = ubound(SrcRotOutputTypeData%WriteOutput)
      if (.not. allocated(DstRotOutputTypeData%WriteOutput)) then
         allocate(DstRotOutputTypeData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotOutputTypeData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstRotOutputTypeData%WriteOutput = SrcRotOutputTypeData%WriteOutput
   end if
end subroutine

subroutine AD_DestroyRotOutputType(RotOutputTypeData, ErrStat, ErrMsg)
   type(RotOutputType), intent(inout) :: RotOutputTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyRotOutputType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( RotOutputTypeData%NacelleLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( RotOutputTypeData%HubLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( RotOutputTypeData%TowerLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(RotOutputTypeData%BladeLoad)) then
      LB(1:1) = lbound(RotOutputTypeData%BladeLoad)
      UB(1:1) = ubound(RotOutputTypeData%BladeLoad)
      do i1 = LB(1), UB(1)
         call MeshDestroy( RotOutputTypeData%BladeLoad(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotOutputTypeData%BladeLoad)
   end if
   call MeshDestroy( RotOutputTypeData%TFinLoad, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(RotOutputTypeData%WriteOutput)) then
      deallocate(RotOutputTypeData%WriteOutput)
   end if
end subroutine

subroutine AD_PackRotOutputType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(RotOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackRotOutputType'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%NacelleLoad) 
   call MeshPack(RF, InData%HubLoad) 
   call MeshPack(RF, InData%TowerLoad) 
   call RegPack(RF, allocated(InData%BladeLoad))
   if (allocated(InData%BladeLoad)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeLoad), ubound(InData%BladeLoad))
      LB(1:1) = lbound(InData%BladeLoad)
      UB(1:1) = ubound(InData%BladeLoad)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeLoad(i1)) 
      end do
   end if
   call MeshPack(RF, InData%TFinLoad) 
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackRotOutputType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(RotOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackRotOutputType'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%NacelleLoad) ! NacelleLoad 
   call MeshUnpack(RF, OutData%HubLoad) ! HubLoad 
   call MeshUnpack(RF, OutData%TowerLoad) ! TowerLoad 
   if (allocated(OutData%BladeLoad)) deallocate(OutData%BladeLoad)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeLoad(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeLoad.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeLoad(i1)) ! BladeLoad 
      end do
   end if
   call MeshUnpack(RF, OutData%TFinLoad) ! TFinLoad 
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(AD_OutputType), intent(inout) :: SrcOutputData
   type(AD_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%rotors)) then
      LB(1:1) = lbound(SrcOutputData%rotors)
      UB(1:1) = ubound(SrcOutputData%rotors)
      if (.not. allocated(DstOutputData%rotors)) then
         allocate(DstOutputData%rotors(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%rotors.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyRotOutputType(SrcOutputData%rotors(i1), DstOutputData%rotors(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine AD_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(AD_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%rotors)) then
      LB(1:1) = lbound(OutputData%rotors)
      UB(1:1) = ubound(OutputData%rotors)
      do i1 = LB(1), UB(1)
         call AD_DestroyRotOutputType(OutputData%rotors(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(OutputData%rotors)
   end if
end subroutine

subroutine AD_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AD_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_PackOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%rotors))
   if (allocated(InData%rotors)) then
      call RegPackBounds(RF, 1, lbound(InData%rotors), ubound(InData%rotors))
      LB(1:1) = lbound(InData%rotors)
      UB(1:1) = ubound(InData%rotors)
      do i1 = LB(1), UB(1)
         call AD_PackRotOutputType(RF, InData%rotors(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AD_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_UnPackOutput'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%rotors)) deallocate(OutData%rotors)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%rotors(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%rotors.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackRotOutputType(RF, OutData%rotors(i1)) ! rotors 
      end do
   end if
end subroutine

subroutine AD_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(AD_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(AD_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'AD_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call AD_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call AD_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call AD_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE AD_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(AD_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(AD_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(AD_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'AD_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(u_out%rotors) .AND. ALLOCATED(u1%rotors)) THEN
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         CALL MeshExtrapInterp1(u1%rotors(i01)%NacelleMotion, u2%rotors(i01)%NacelleMotion, tin, u_out%rotors(i01)%NacelleMotion, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         CALL MeshExtrapInterp1(u1%rotors(i01)%TowerMotion, u2%rotors(i01)%TowerMotion, tin, u_out%rotors(i01)%TowerMotion, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         CALL MeshExtrapInterp1(u1%rotors(i01)%HubMotion, u2%rotors(i01)%HubMotion, tin, u_out%rotors(i01)%HubMotion, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         IF (ALLOCATED(u_out%rotors(i01)%BladeRootMotion) .AND. ALLOCATED(u1%rotors(i01)%BladeRootMotion)) THEN
            do i1 = lbound(u_out%rotors(i01)%BladeRootMotion,1),ubound(u_out%rotors(i01)%BladeRootMotion,1)
               CALL MeshExtrapInterp1(u1%rotors(i01)%BladeRootMotion(i1), u2%rotors(i01)%BladeRootMotion(i1), tin, u_out%rotors(i01)%BladeRootMotion(i1), tin_out, ErrStat2, ErrMsg2)
                  CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
            END DO
         END IF ! check if allocated
      END DO
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         IF (ALLOCATED(u_out%rotors(i01)%BladeMotion) .AND. ALLOCATED(u1%rotors(i01)%BladeMotion)) THEN
            do i1 = lbound(u_out%rotors(i01)%BladeMotion,1),ubound(u_out%rotors(i01)%BladeMotion,1)
               CALL MeshExtrapInterp1(u1%rotors(i01)%BladeMotion(i1), u2%rotors(i01)%BladeMotion(i1), tin, u_out%rotors(i01)%BladeMotion(i1), tin_out, ErrStat2, ErrMsg2)
                  CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
            END DO
         END IF ! check if allocated
      END DO
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         CALL MeshExtrapInterp1(u1%rotors(i01)%TFinMotion, u2%rotors(i01)%TFinMotion, tin, u_out%rotors(i01)%TFinMotion, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         IF (ALLOCATED(u_out%rotors(i01)%UserProp) .AND. ALLOCATED(u1%rotors(i01)%UserProp)) THEN
            u_out%rotors(i01)%UserProp = a1*u1%rotors(i01)%UserProp + a2*u2%rotors(i01)%UserProp
         END IF ! check if allocated
      END DO
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE AD_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(AD_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(AD_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(AD_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(AD_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'AD_Input_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(u_out%rotors) .AND. ALLOCATED(u1%rotors)) THEN
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         CALL MeshExtrapInterp2(u1%rotors(i01)%NacelleMotion, u2%rotors(i01)%NacelleMotion, u3%rotors(i01)%NacelleMotion, tin, u_out%rotors(i01)%NacelleMotion, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         CALL MeshExtrapInterp2(u1%rotors(i01)%TowerMotion, u2%rotors(i01)%TowerMotion, u3%rotors(i01)%TowerMotion, tin, u_out%rotors(i01)%TowerMotion, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         CALL MeshExtrapInterp2(u1%rotors(i01)%HubMotion, u2%rotors(i01)%HubMotion, u3%rotors(i01)%HubMotion, tin, u_out%rotors(i01)%HubMotion, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         IF (ALLOCATED(u_out%rotors(i01)%BladeRootMotion) .AND. ALLOCATED(u1%rotors(i01)%BladeRootMotion)) THEN
            do i1 = lbound(u_out%rotors(i01)%BladeRootMotion,1),ubound(u_out%rotors(i01)%BladeRootMotion,1)
               CALL MeshExtrapInterp2(u1%rotors(i01)%BladeRootMotion(i1), u2%rotors(i01)%BladeRootMotion(i1), u3%rotors(i01)%BladeRootMotion(i1), tin, u_out%rotors(i01)%BladeRootMotion(i1), tin_out, ErrStat2, ErrMsg2)
                  CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
            END DO
         END IF ! check if allocated
      END DO
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         IF (ALLOCATED(u_out%rotors(i01)%BladeMotion) .AND. ALLOCATED(u1%rotors(i01)%BladeMotion)) THEN
            do i1 = lbound(u_out%rotors(i01)%BladeMotion,1),ubound(u_out%rotors(i01)%BladeMotion,1)
               CALL MeshExtrapInterp2(u1%rotors(i01)%BladeMotion(i1), u2%rotors(i01)%BladeMotion(i1), u3%rotors(i01)%BladeMotion(i1), tin, u_out%rotors(i01)%BladeMotion(i1), tin_out, ErrStat2, ErrMsg2)
                  CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
            END DO
         END IF ! check if allocated
      END DO
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         CALL MeshExtrapInterp2(u1%rotors(i01)%TFinMotion, u2%rotors(i01)%TFinMotion, u3%rotors(i01)%TFinMotion, tin, u_out%rotors(i01)%TFinMotion, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(u_out%rotors,1),ubound(u_out%rotors,1)
         IF (ALLOCATED(u_out%rotors(i01)%UserProp) .AND. ALLOCATED(u1%rotors(i01)%UserProp)) THEN
            u_out%rotors(i01)%UserProp = a1*u1%rotors(i01)%UserProp + a2*u2%rotors(i01)%UserProp + a3*u3%rotors(i01)%UserProp
         END IF ! check if allocated
      END DO
   END IF ! check if allocated
END SUBROUTINE

subroutine AD_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(AD_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(AD_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'AD_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call AD_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call AD_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call AD_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE AD_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(AD_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(AD_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(AD_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'AD_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(y_out%rotors) .AND. ALLOCATED(y1%rotors)) THEN
      do i01 = lbound(y_out%rotors,1),ubound(y_out%rotors,1)
         CALL MeshExtrapInterp1(y1%rotors(i01)%NacelleLoad, y2%rotors(i01)%NacelleLoad, tin, y_out%rotors(i01)%NacelleLoad, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(y_out%rotors,1),ubound(y_out%rotors,1)
         CALL MeshExtrapInterp1(y1%rotors(i01)%HubLoad, y2%rotors(i01)%HubLoad, tin, y_out%rotors(i01)%HubLoad, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(y_out%rotors,1),ubound(y_out%rotors,1)
         CALL MeshExtrapInterp1(y1%rotors(i01)%TowerLoad, y2%rotors(i01)%TowerLoad, tin, y_out%rotors(i01)%TowerLoad, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(y_out%rotors,1),ubound(y_out%rotors,1)
         IF (ALLOCATED(y_out%rotors(i01)%BladeLoad) .AND. ALLOCATED(y1%rotors(i01)%BladeLoad)) THEN
            do i1 = lbound(y_out%rotors(i01)%BladeLoad,1),ubound(y_out%rotors(i01)%BladeLoad,1)
               CALL MeshExtrapInterp1(y1%rotors(i01)%BladeLoad(i1), y2%rotors(i01)%BladeLoad(i1), tin, y_out%rotors(i01)%BladeLoad(i1), tin_out, ErrStat2, ErrMsg2)
                  CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
            END DO
         END IF ! check if allocated
      END DO
      do i01 = lbound(y_out%rotors,1),ubound(y_out%rotors,1)
         CALL MeshExtrapInterp1(y1%rotors(i01)%TFinLoad, y2%rotors(i01)%TFinLoad, tin, y_out%rotors(i01)%TFinLoad, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(y_out%rotors,1),ubound(y_out%rotors,1)
         IF (ALLOCATED(y_out%rotors(i01)%WriteOutput) .AND. ALLOCATED(y1%rotors(i01)%WriteOutput)) THEN
            y_out%rotors(i01)%WriteOutput = a1*y1%rotors(i01)%WriteOutput + a2*y2%rotors(i01)%WriteOutput
         END IF ! check if allocated
      END DO
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE AD_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(AD_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(AD_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(AD_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(AD_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'AD_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(y_out%rotors) .AND. ALLOCATED(y1%rotors)) THEN
      do i01 = lbound(y_out%rotors,1),ubound(y_out%rotors,1)
         CALL MeshExtrapInterp2(y1%rotors(i01)%NacelleLoad, y2%rotors(i01)%NacelleLoad, y3%rotors(i01)%NacelleLoad, tin, y_out%rotors(i01)%NacelleLoad, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(y_out%rotors,1),ubound(y_out%rotors,1)
         CALL MeshExtrapInterp2(y1%rotors(i01)%HubLoad, y2%rotors(i01)%HubLoad, y3%rotors(i01)%HubLoad, tin, y_out%rotors(i01)%HubLoad, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(y_out%rotors,1),ubound(y_out%rotors,1)
         CALL MeshExtrapInterp2(y1%rotors(i01)%TowerLoad, y2%rotors(i01)%TowerLoad, y3%rotors(i01)%TowerLoad, tin, y_out%rotors(i01)%TowerLoad, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(y_out%rotors,1),ubound(y_out%rotors,1)
         IF (ALLOCATED(y_out%rotors(i01)%BladeLoad) .AND. ALLOCATED(y1%rotors(i01)%BladeLoad)) THEN
            do i1 = lbound(y_out%rotors(i01)%BladeLoad,1),ubound(y_out%rotors(i01)%BladeLoad,1)
               CALL MeshExtrapInterp2(y1%rotors(i01)%BladeLoad(i1), y2%rotors(i01)%BladeLoad(i1), y3%rotors(i01)%BladeLoad(i1), tin, y_out%rotors(i01)%BladeLoad(i1), tin_out, ErrStat2, ErrMsg2)
                  CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
            END DO
         END IF ! check if allocated
      END DO
      do i01 = lbound(y_out%rotors,1),ubound(y_out%rotors,1)
         CALL MeshExtrapInterp2(y1%rotors(i01)%TFinLoad, y2%rotors(i01)%TFinLoad, y3%rotors(i01)%TFinLoad, tin, y_out%rotors(i01)%TFinLoad, tin_out, ErrStat2, ErrMsg2)
            CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
      END DO
      do i01 = lbound(y_out%rotors,1),ubound(y_out%rotors,1)
         IF (ALLOCATED(y_out%rotors(i01)%WriteOutput) .AND. ALLOCATED(y1%rotors(i01)%WriteOutput)) THEN
            y_out%rotors(i01)%WriteOutput = a1*y1%rotors(i01)%WriteOutput + a2*y2%rotors(i01)%WriteOutput + a3*y3%rotors(i01)%WriteOutput
         END IF ! check if allocated
      END DO
   END IF ! check if allocated
END SUBROUTINE

subroutine AD_InflowType_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) InflowType u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(AD_InflowType), intent(in)  :: u(:) ! InflowType at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the InflowTypes
   type(AD_InflowType), intent(inout)  :: u_out ! InflowType at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'AD_InflowType_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call AD_CopyInflowType(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call AD_InflowType_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call AD_InflowType_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE AD_InflowType_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) InflowType u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(AD_InflowType), INTENT(IN)  :: u1    ! InflowType at t1 > t2
   TYPE(AD_InflowType), INTENT(IN)  :: u2    ! InflowType at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the InflowTypes
   TYPE(AD_InflowType), INTENT(INOUT)  :: u_out ! InflowType at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the InflowTypes
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'AD_InflowType_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i11      ! dim1 level 1 counter variable for arrays of ddts
   INTEGER                                    :: i02      ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i12      ! dim2 level 1 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   INTEGER                                    :: i2       ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   IF (ALLOCATED(u_out%InflowWakeVel) .AND. ALLOCATED(u1%InflowWakeVel)) THEN
      u_out%InflowWakeVel = a1*u1%InflowWakeVel + a2*u2%InflowWakeVel
   END IF ! check if allocated
   IF (ALLOCATED(u_out%RotInflow) .AND. ALLOCATED(u1%RotInflow)) THEN
      do i01 = lbound(u_out%RotInflow,1),ubound(u_out%RotInflow,1)
         IF (ALLOCATED(u_out%RotInflow(i01)%Blade) .AND. ALLOCATED(u1%RotInflow(i01)%Blade)) THEN
            do i11 = lbound(u_out%RotInflow(i01)%Blade,1),ubound(u_out%RotInflow(i01)%Blade,1)
               IF (ALLOCATED(u_out%RotInflow(i01)%Blade(i11)%InflowVel) .AND. ALLOCATED(u1%RotInflow(i01)%Blade(i11)%InflowVel)) THEN
                  u_out%RotInflow(i01)%Blade(i11)%InflowVel = a1*u1%RotInflow(i01)%Blade(i11)%InflowVel + a2*u2%RotInflow(i01)%Blade(i11)%InflowVel
               END IF ! check if allocated
            END DO
            do i11 = lbound(u_out%RotInflow(i01)%Blade,1),ubound(u_out%RotInflow(i01)%Blade,1)
               IF (ALLOCATED(u_out%RotInflow(i01)%Blade(i11)%InflowAcc) .AND. ALLOCATED(u1%RotInflow(i01)%Blade(i11)%InflowAcc)) THEN
                  u_out%RotInflow(i01)%Blade(i11)%InflowAcc = a1*u1%RotInflow(i01)%Blade(i11)%InflowAcc + a2*u2%RotInflow(i01)%Blade(i11)%InflowAcc
               END IF ! check if allocated
            END DO
         END IF ! check if allocated
      END DO
      do i01 = lbound(u_out%RotInflow,1),ubound(u_out%RotInflow,1)
         IF (ALLOCATED(u_out%RotInflow(i01)%Tower%InflowVel) .AND. ALLOCATED(u1%RotInflow(i01)%Tower%InflowVel)) THEN
            u_out%RotInflow(i01)%Tower%InflowVel = a1*u1%RotInflow(i01)%Tower%InflowVel + a2*u2%RotInflow(i01)%Tower%InflowVel
         END IF ! check if allocated
         IF (ALLOCATED(u_out%RotInflow(i01)%Tower%InflowAcc) .AND. ALLOCATED(u1%RotInflow(i01)%Tower%InflowAcc)) THEN
            u_out%RotInflow(i01)%Tower%InflowAcc = a1*u1%RotInflow(i01)%Tower%InflowAcc + a2*u2%RotInflow(i01)%Tower%InflowAcc
         END IF ! check if allocated
      END DO
      do i01 = lbound(u_out%RotInflow,1),ubound(u_out%RotInflow,1)
         u_out%RotInflow(i01)%InflowOnHub = a1*u1%RotInflow(i01)%InflowOnHub + a2*u2%RotInflow(i01)%InflowOnHub
      END DO
      do i01 = lbound(u_out%RotInflow,1),ubound(u_out%RotInflow,1)
         u_out%RotInflow(i01)%InflowOnNacelle = a1*u1%RotInflow(i01)%InflowOnNacelle + a2*u2%RotInflow(i01)%InflowOnNacelle
      END DO
      do i01 = lbound(u_out%RotInflow,1),ubound(u_out%RotInflow,1)
         u_out%RotInflow(i01)%InflowOnTailFin = a1*u1%RotInflow(i01)%InflowOnTailFin + a2*u2%RotInflow(i01)%InflowOnTailFin
      END DO
      do i01 = lbound(u_out%RotInflow,1),ubound(u_out%RotInflow,1)
         u_out%RotInflow(i01)%AvgDiskVel = a1*u1%RotInflow(i01)%AvgDiskVel + a2*u2%RotInflow(i01)%AvgDiskVel
      END DO
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE AD_InflowType_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) InflowType u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(AD_InflowType), INTENT(IN)  :: u1      ! InflowType at t1 > t2 > t3
   TYPE(AD_InflowType), INTENT(IN)  :: u2      ! InflowType at t2 > t3
   TYPE(AD_InflowType), INTENT(IN)  :: u3      ! InflowType at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the InflowTypes
   TYPE(AD_InflowType), INTENT(INOUT)  :: u_out     ! InflowType at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the InflowTypes
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'AD_InflowType_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i11    ! dim1 level 1 counter variable for arrays of ddts
   INTEGER                                    :: i02    ! dim2 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i12    ! dim2 level 1 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   INTEGER                                    :: i2    ! dim2 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   IF (ALLOCATED(u_out%InflowWakeVel) .AND. ALLOCATED(u1%InflowWakeVel)) THEN
      u_out%InflowWakeVel = a1*u1%InflowWakeVel + a2*u2%InflowWakeVel + a3*u3%InflowWakeVel
   END IF ! check if allocated
   IF (ALLOCATED(u_out%RotInflow) .AND. ALLOCATED(u1%RotInflow)) THEN
      do i01 = lbound(u_out%RotInflow,1),ubound(u_out%RotInflow,1)
         IF (ALLOCATED(u_out%RotInflow(i01)%Blade) .AND. ALLOCATED(u1%RotInflow(i01)%Blade)) THEN
            do i11 = lbound(u_out%RotInflow(i01)%Blade,1),ubound(u_out%RotInflow(i01)%Blade,1)
               IF (ALLOCATED(u_out%RotInflow(i01)%Blade(i11)%InflowVel) .AND. ALLOCATED(u1%RotInflow(i01)%Blade(i11)%InflowVel)) THEN
                  u_out%RotInflow(i01)%Blade(i11)%InflowVel = a1*u1%RotInflow(i01)%Blade(i11)%InflowVel + a2*u2%RotInflow(i01)%Blade(i11)%InflowVel + a3*u3%RotInflow(i01)%Blade(i11)%InflowVel
               END IF ! check if allocated
            END DO
            do i11 = lbound(u_out%RotInflow(i01)%Blade,1),ubound(u_out%RotInflow(i01)%Blade,1)
               IF (ALLOCATED(u_out%RotInflow(i01)%Blade(i11)%InflowAcc) .AND. ALLOCATED(u1%RotInflow(i01)%Blade(i11)%InflowAcc)) THEN
                  u_out%RotInflow(i01)%Blade(i11)%InflowAcc = a1*u1%RotInflow(i01)%Blade(i11)%InflowAcc + a2*u2%RotInflow(i01)%Blade(i11)%InflowAcc + a3*u3%RotInflow(i01)%Blade(i11)%InflowAcc
               END IF ! check if allocated
            END DO
         END IF ! check if allocated
      END DO
      do i01 = lbound(u_out%RotInflow,1),ubound(u_out%RotInflow,1)
         IF (ALLOCATED(u_out%RotInflow(i01)%Tower%InflowVel) .AND. ALLOCATED(u1%RotInflow(i01)%Tower%InflowVel)) THEN
            u_out%RotInflow(i01)%Tower%InflowVel = a1*u1%RotInflow(i01)%Tower%InflowVel + a2*u2%RotInflow(i01)%Tower%InflowVel + a3*u3%RotInflow(i01)%Tower%InflowVel
         END IF ! check if allocated
         IF (ALLOCATED(u_out%RotInflow(i01)%Tower%InflowAcc) .AND. ALLOCATED(u1%RotInflow(i01)%Tower%InflowAcc)) THEN
            u_out%RotInflow(i01)%Tower%InflowAcc = a1*u1%RotInflow(i01)%Tower%InflowAcc + a2*u2%RotInflow(i01)%Tower%InflowAcc + a3*u3%RotInflow(i01)%Tower%InflowAcc
         END IF ! check if allocated
      END DO
      do i01 = lbound(u_out%RotInflow,1),ubound(u_out%RotInflow,1)
         u_out%RotInflow(i01)%InflowOnHub = a1*u1%RotInflow(i01)%InflowOnHub + a2*u2%RotInflow(i01)%InflowOnHub + a3*u3%RotInflow(i01)%InflowOnHub
      END DO
      do i01 = lbound(u_out%RotInflow,1),ubound(u_out%RotInflow,1)
         u_out%RotInflow(i01)%InflowOnNacelle = a1*u1%RotInflow(i01)%InflowOnNacelle + a2*u2%RotInflow(i01)%InflowOnNacelle + a3*u3%RotInflow(i01)%InflowOnNacelle
      END DO
      do i01 = lbound(u_out%RotInflow,1),ubound(u_out%RotInflow,1)
         u_out%RotInflow(i01)%InflowOnTailFin = a1*u1%RotInflow(i01)%InflowOnTailFin + a2*u2%RotInflow(i01)%InflowOnTailFin + a3*u3%RotInflow(i01)%InflowOnTailFin
      END DO
      do i01 = lbound(u_out%RotInflow,1),ubound(u_out%RotInflow,1)
         u_out%RotInflow(i01)%AvgDiskVel = a1*u1%RotInflow(i01)%AvgDiskVel + a2*u2%RotInflow(i01)%AvgDiskVel + a3*u3%RotInflow(i01)%AvgDiskVel
      END DO
   END IF ! check if allocated
END SUBROUTINE
END MODULE AeroDyn_Types
!ENDOFREGISTRYGENERATEDFILE
