!STARTOFREGISTRYGENERATEDFILE 'AeroDyn_Inflow_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! AeroDyn_Inflow_Types
!.................................................................................................................................
! This file is part of AeroDyn_Inflow.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in AeroDyn_Inflow. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE AeroDyn_Inflow_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE AeroDyn_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: ADI_Version = 1      !  [-]
! =========  ADI_InflowWindData  =======
  TYPE, PUBLIC :: ADI_InflowWindData
    TYPE(InflowWind_ContinuousStateType)  :: x      !< Continuous states [-]
    TYPE(InflowWind_DiscreteStateType)  :: xd      !< Discrete states [-]
    TYPE(InflowWind_ConstraintStateType)  :: z      !< Constraint states [-]
    TYPE(InflowWind_OtherStateType)  :: OtherSt      !< Other states [-]
    TYPE(InflowWind_ParameterType)  :: p      !< Parameters [-]
    TYPE(InflowWind_MiscVarType)  :: m      !< Misc/optimization variables [-]
    TYPE(InflowWind_InputType)  :: u      !< Array of inputs associated with InputTimes [-]
    TYPE(InflowWind_OutputType)  :: y      !< System outputs [-]
    INTEGER(IntKi)  :: CompInflow = 0_IntKi      !< 0=Steady Wind, 1=InflowWind [-]
    REAL(ReKi)  :: HWindSpeed = 0.0_ReKi      !< RefHeight Wind speed [-]
    REAL(ReKi)  :: RefHt = 0.0_ReKi      !< RefHeight [-]
    REAL(ReKi)  :: PLExp = 0.0_ReKi      !< PLExp [-]
  END TYPE ADI_InflowWindData
! =======================
! =========  ADI_IW_InputData  =======
  TYPE, PUBLIC :: ADI_IW_InputData
    Character(1024)  :: InputFile      !< Name of InfloWind input file [-]
    INTEGER(IntKi)  :: CompInflow = 0_IntKi      !< 0=Steady Wind, 1=InflowWind [-]
    REAL(ReKi)  :: HWindSpeed = 0.0_ReKi      !< RefHeight Wind speed [-]
    REAL(ReKi)  :: RefHt = 0.0_ReKi      !< RefHeight [-]
    REAL(ReKi)  :: PLExp = 0.0_ReKi      !< PLExp [-]
    INTEGER(IntKi)  :: MHK = 0_IntKi      !< MHK turbine type switch [-]
    INTEGER(IntKi)  :: FilePassingMethod = 0      !< Should we read everthing from an input file (0), passed in as a FileInfoType structure (1), or passed as the IfW_InputFile structure (2) [-]
    TYPE(FileInfoType)  :: PassedFileInfo      !< If we don't use the input file, pass everything through this as a FileInfo structure [-]
    TYPE(InflowWind_InputFile)  :: PassedFileData      !< If we don't use the input file, pass everything through this as an IfW InputFile structure [-]
    LOGICAL  :: Linearize = .FALSE.      !< Flag that tells this module if the glue code wants to linearize. [-]
  END TYPE ADI_IW_InputData
! =======================
! =========  ADI_InitInputType  =======
  TYPE, PUBLIC :: ADI_InitInputType
    TYPE(AD_InitInputType)  :: AD      !< AD Init input types [-]
    TYPE(ADI_IW_InputData)  :: IW_InitInp      !< IW Init input types [-]
    Character(1024)  :: RootName      !< RootName for writing output files [-]
    LOGICAL  :: storeHHVel = .false.      !< If True, hub height velocity will be computed by infow wind [-]
    INTEGER(IntKi)  :: WrVTK = 0      !< 0= no vtk, 1=init only, 2=animation [-]
    INTEGER(IntKi)  :: WrVTK_Type = 1      !< Flag for VTK output type (1=surface, 2=line, 3=both) [-]
    REAL(ReKi)  :: WtrDpth = 0.0_ReKi      !< Water depth [m]
  END TYPE ADI_InitInputType
! =======================
! =========  ADI_InitOutputType  =======
  TYPE, PUBLIC :: ADI_InitOutputType
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    character(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Channel headers [-]
    character(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Channel units [-]
  END TYPE ADI_InitOutputType
! =======================
! =========  ADI_ContinuousStateType  =======
  TYPE, PUBLIC :: ADI_ContinuousStateType
    TYPE(AD_ContinuousStateType)  :: AD      !< AD Continuous states [-]
  END TYPE ADI_ContinuousStateType
! =======================
! =========  ADI_DiscreteStateType  =======
  TYPE, PUBLIC :: ADI_DiscreteStateType
    TYPE(AD_DiscreteStateType)  :: AD      !< Discrete states [-]
  END TYPE ADI_DiscreteStateType
! =======================
! =========  ADI_ConstraintStateType  =======
  TYPE, PUBLIC :: ADI_ConstraintStateType
    TYPE(AD_ConstraintStateType)  :: AD      !< Constraint states [-]
  END TYPE ADI_ConstraintStateType
! =======================
! =========  ADI_OtherStateType  =======
  TYPE, PUBLIC :: ADI_OtherStateType
    TYPE(AD_OtherStateType)  :: AD      !< Other states [-]
  END TYPE ADI_OtherStateType
! =======================
! =========  ADI_MiscVarType  =======
  TYPE, PUBLIC :: ADI_MiscVarType
    TYPE(AD_MiscVarType)  :: AD      !< misc/optimization variables [-]
    TYPE(ADI_InflowWindData)  :: IW      !< All the necessary inflow wind data [-]
    TYPE(AD_VTK_RotSurfaceType) , DIMENSION(:), ALLOCATABLE  :: VTK_surfaces      !< VTK outputs surfaces for each rotor [-]
  END TYPE ADI_MiscVarType
! =======================
! =========  ADI_ParameterType  =======
  TYPE, PUBLIC :: ADI_ParameterType
    TYPE(AD_ParameterType)  :: AD      !< Parameters [-]
    REAL(DbKi)  :: dt = 0.0_R8Ki      !< time increment [s]
    LOGICAL  :: storeHHVel = .false.      !< If True, hub height velocity will be computed by infow wind [-]
    INTEGER(IntKi)  :: wrVTK = 0_IntKi      !< 0= no vtk, 1=init only, 2=animation [-]
    INTEGER(IntKi)  :: WrVTK_Type = 0_IntKi      !< Flag for VTK output type (1=surface, 2=line, 3=both) [-]
    INTEGER(IntKi)  :: NumOuts = 0      !< Total number of WriteOutput outputs [-]
    INTEGER(IntKi)  :: MHK = 0_IntKi      !< MHK turbine type switch [-]
    REAL(ReKi)  :: WtrDpth = 0.0_ReKi      !< Water depth [m]
  END TYPE ADI_ParameterType
! =======================
! =========  ADI_InputType  =======
  TYPE, PUBLIC :: ADI_InputType
    TYPE(AD_InputType)  :: AD      !< Array of system inputs [-]
  END TYPE ADI_InputType
! =======================
! =========  ADI_OutputType  =======
  TYPE, PUBLIC :: ADI_OutputType
    TYPE(AD_OutputType)  :: AD      !< System outputs [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: HHVel      !< Hub Height velocities for each rotors [-]
    REAL(ReKi)  :: PLExp = 0.0_ReKi      !< Power law exponents (for outputs only) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: IW_WriteOutput      !< WriteOutputs for inflow wind [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< System outputs [-]
  END TYPE ADI_OutputType
! =======================
! =========  ADI_Data  =======
  TYPE, PUBLIC :: ADI_Data
    TYPE(ADI_ContinuousStateType) , DIMENSION(:), ALLOCATABLE  :: x      !< Continuous states [-]
    TYPE(ADI_DiscreteStateType) , DIMENSION(:), ALLOCATABLE  :: xd      !< Discrete states [-]
    TYPE(ADI_ConstraintStateType) , DIMENSION(:), ALLOCATABLE  :: z      !< Constraint states [-]
    TYPE(ADI_OtherStateType) , DIMENSION(:), ALLOCATABLE  :: OtherState      !< Other states [-]
    TYPE(ADI_ParameterType)  :: p      !< Parameters [-]
    TYPE(ADI_MiscVarType)  :: m      !< Misc/optimization variables [-]
    TYPE(ADI_InputType) , DIMENSION(:), ALLOCATABLE  :: u      !< Array of inputs associated with InputTimes [-]
    TYPE(ADI_OutputType)  :: y      !< System outputs [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: inputTimes      !< Array of times associated with u array [-]
  END TYPE ADI_Data
! =======================
! =========  RotFED  =======
  TYPE, PUBLIC :: RotFED
    TYPE(MeshType)  :: PlatformPtMesh      !< Platform reference point positions/orientations/velocities/accelerations [-]
    TYPE(MeshType)  :: TwrPtMesh      !< (only if hasTower) Point mesh for tower base motion [-]
    TYPE(MeshType)  :: TwrPtMeshAD      !< (only if hasTower) Point mesh for tower base for AD [-]
    TYPE(MeshType)  :: NacelleMotion      !< Point mesh for nacelle point motion [-]
    TYPE(MeshType)  :: HubPtMotion      !< Point mesh for hub point motion [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeRootMotion      !< BladeRootMotion Point mesh for blade root motion [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: BladeLn2Mesh      !< (only if elastic blades) BladeLn2Mesh    Line mesh along blade [-]
    LOGICAL  :: hasTower = .true.      !< True if a tower is present [-]
    LOGICAL  :: rigidBlades = .true.      !< True if blades are rigid (using BladeRootMotion) or not (Useing BldeLn2Mesh) [-]
    INTEGER(IntKi)  :: numBlades = 0_IntKi      !< Number of blades [-]
    TYPE(MeshMapType)  :: ED_P_2_AD_P_T      !< (only if hasTower) Mesh mapping from tower base to AD tower base [-]
    TYPE(MeshMapType)  :: AD_P_2_AD_L_T      !< (only if hasTower) Mesh mapping from tower base to AD tower line [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: AD_P_2_AD_L_B      !< (only for rigid blades) Mesh mapping from AD blade root to AD line mesh [-]
    TYPE(MeshMapType)  :: ED_P_2_AD_P_TF      !< Map ElastoDyn TailFin CM point (taken as Nacelle) motion mesh to AeroDyn TailFin ref point motion mesh [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: ED_P_2_AD_P_R      !< Map ElastoDyn BladeRootMotion point meshes to AeroDyn BladeRootMotion point meshes [-]
    TYPE(MeshMapType)  :: ED_P_2_AD_P_H      !< Map ElastoDyn HubPtMotion point mesh to AeroDyn HubMotion point mesh [-]
    TYPE(MeshMapType)  :: ED_P_2_AD_P_N      !< Map ElastoDyn Nacelle point motion mesh to AeroDyn Nacelle point motion mesh [-]
  END TYPE RotFED
! =======================
! =========  FED_Data  =======
  TYPE, PUBLIC :: FED_Data
    TYPE(RotFED) , DIMENSION(:), ALLOCATABLE  :: WT      !< Wind turbine/rotors elastic data [-]
  END TYPE FED_Data
! =======================
CONTAINS

subroutine ADI_CopyInflowWindData(SrcInflowWindDataData, DstInflowWindDataData, CtrlCode, ErrStat, ErrMsg)
   type(ADI_InflowWindData), intent(in) :: SrcInflowWindDataData
   type(ADI_InflowWindData), intent(inout) :: DstInflowWindDataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyInflowWindData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call InflowWind_CopyContState(SrcInflowWindDataData%x, DstInflowWindDataData%x, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyDiscState(SrcInflowWindDataData%xd, DstInflowWindDataData%xd, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyConstrState(SrcInflowWindDataData%z, DstInflowWindDataData%z, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyOtherState(SrcInflowWindDataData%OtherSt, DstInflowWindDataData%OtherSt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyParam(SrcInflowWindDataData%p, DstInflowWindDataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyMisc(SrcInflowWindDataData%m, DstInflowWindDataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyInput(SrcInflowWindDataData%u, DstInflowWindDataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyOutput(SrcInflowWindDataData%y, DstInflowWindDataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInflowWindDataData%CompInflow = SrcInflowWindDataData%CompInflow
   DstInflowWindDataData%HWindSpeed = SrcInflowWindDataData%HWindSpeed
   DstInflowWindDataData%RefHt = SrcInflowWindDataData%RefHt
   DstInflowWindDataData%PLExp = SrcInflowWindDataData%PLExp
end subroutine

subroutine ADI_DestroyInflowWindData(InflowWindDataData, ErrStat, ErrMsg)
   type(ADI_InflowWindData), intent(inout) :: InflowWindDataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyInflowWindData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call InflowWind_DestroyContState(InflowWindDataData%x, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyDiscState(InflowWindDataData%xd, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyConstrState(InflowWindDataData%z, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyOtherState(InflowWindDataData%OtherSt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyParam(InflowWindDataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyMisc(InflowWindDataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyInput(InflowWindDataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyOutput(InflowWindDataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ADI_PackInflowWindData(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADI_InflowWindData), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackInflowWindData'
   if (RF%ErrStat >= AbortErrLev) return
   call InflowWind_PackContState(RF, InData%x) 
   call InflowWind_PackDiscState(RF, InData%xd) 
   call InflowWind_PackConstrState(RF, InData%z) 
   call InflowWind_PackOtherState(RF, InData%OtherSt) 
   call InflowWind_PackParam(RF, InData%p) 
   call InflowWind_PackMisc(RF, InData%m) 
   call InflowWind_PackInput(RF, InData%u) 
   call InflowWind_PackOutput(RF, InData%y) 
   call RegPack(RF, InData%CompInflow)
   call RegPack(RF, InData%HWindSpeed)
   call RegPack(RF, InData%RefHt)
   call RegPack(RF, InData%PLExp)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackInflowWindData(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADI_InflowWindData), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackInflowWindData'
   if (RF%ErrStat /= ErrID_None) return
   call InflowWind_UnpackContState(RF, OutData%x) ! x 
   call InflowWind_UnpackDiscState(RF, OutData%xd) ! xd 
   call InflowWind_UnpackConstrState(RF, OutData%z) ! z 
   call InflowWind_UnpackOtherState(RF, OutData%OtherSt) ! OtherSt 
   call InflowWind_UnpackParam(RF, OutData%p) ! p 
   call InflowWind_UnpackMisc(RF, OutData%m) ! m 
   call InflowWind_UnpackInput(RF, OutData%u) ! u 
   call InflowWind_UnpackOutput(RF, OutData%y) ! y 
   call RegUnpack(RF, OutData%CompInflow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HWindSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PLExp); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_CopyIW_InputData(SrcIW_InputDataData, DstIW_InputDataData, CtrlCode, ErrStat, ErrMsg)
   type(ADI_IW_InputData), intent(in) :: SrcIW_InputDataData
   type(ADI_IW_InputData), intent(inout) :: DstIW_InputDataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyIW_InputData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstIW_InputDataData%InputFile = SrcIW_InputDataData%InputFile
   DstIW_InputDataData%CompInflow = SrcIW_InputDataData%CompInflow
   DstIW_InputDataData%HWindSpeed = SrcIW_InputDataData%HWindSpeed
   DstIW_InputDataData%RefHt = SrcIW_InputDataData%RefHt
   DstIW_InputDataData%PLExp = SrcIW_InputDataData%PLExp
   DstIW_InputDataData%MHK = SrcIW_InputDataData%MHK
   DstIW_InputDataData%FilePassingMethod = SrcIW_InputDataData%FilePassingMethod
   call NWTC_Library_CopyFileInfoType(SrcIW_InputDataData%PassedFileInfo, DstIW_InputDataData%PassedFileInfo, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyInputFile(SrcIW_InputDataData%PassedFileData, DstIW_InputDataData%PassedFileData, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstIW_InputDataData%Linearize = SrcIW_InputDataData%Linearize
end subroutine

subroutine ADI_DestroyIW_InputData(IW_InputDataData, ErrStat, ErrMsg)
   type(ADI_IW_InputData), intent(inout) :: IW_InputDataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyIW_InputData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyFileInfoType(IW_InputDataData%PassedFileInfo, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyInputFile(IW_InputDataData%PassedFileData, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ADI_PackIW_InputData(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADI_IW_InputData), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackIW_InputData'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%CompInflow)
   call RegPack(RF, InData%HWindSpeed)
   call RegPack(RF, InData%RefHt)
   call RegPack(RF, InData%PLExp)
   call RegPack(RF, InData%MHK)
   call RegPack(RF, InData%FilePassingMethod)
   call NWTC_Library_PackFileInfoType(RF, InData%PassedFileInfo) 
   call InflowWind_PackInputFile(RF, InData%PassedFileData) 
   call RegPack(RF, InData%Linearize)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackIW_InputData(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADI_IW_InputData), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackIW_InputData'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%CompInflow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HWindSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RefHt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PLExp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MHK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FilePassingMethod); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackFileInfoType(RF, OutData%PassedFileInfo) ! PassedFileInfo 
   call InflowWind_UnpackInputFile(RF, OutData%PassedFileData) ! PassedFileData 
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(ADI_InitInputType), intent(in) :: SrcInitInputData
   type(ADI_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_CopyInitInput(SrcInitInputData%AD, DstInitInputData%AD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ADI_CopyIW_InputData(SrcInitInputData%IW_InitInp, DstInitInputData%IW_InitInp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%storeHHVel = SrcInitInputData%storeHHVel
   DstInitInputData%WrVTK = SrcInitInputData%WrVTK
   DstInitInputData%WrVTK_Type = SrcInitInputData%WrVTK_Type
   DstInitInputData%WtrDpth = SrcInitInputData%WtrDpth
end subroutine

subroutine ADI_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(ADI_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_DestroyInitInput(InitInputData%AD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ADI_DestroyIW_InputData(InitInputData%IW_InitInp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ADI_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADI_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackInitInput'
   if (RF%ErrStat >= AbortErrLev) return
   call AD_PackInitInput(RF, InData%AD) 
   call ADI_PackIW_InputData(RF, InData%IW_InitInp) 
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%storeHHVel)
   call RegPack(RF, InData%WrVTK)
   call RegPack(RF, InData%WrVTK_Type)
   call RegPack(RF, InData%WtrDpth)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADI_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackInitInput'
   if (RF%ErrStat /= ErrID_None) return
   call AD_UnpackInitInput(RF, OutData%AD) ! AD 
   call ADI_UnpackIW_InputData(RF, OutData%IW_InitInp) ! IW_InitInp 
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%storeHHVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrVTK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrVTK_Type); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDpth); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(ADI_InitOutputType), intent(in) :: SrcInitOutputData
   type(ADI_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
end subroutine

subroutine ADI_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(ADI_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
end subroutine

subroutine ADI_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADI_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADI_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(ADI_ContinuousStateType), intent(in) :: SrcContStateData
   type(ADI_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_CopyContState(SrcContStateData%AD, DstContStateData%AD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine ADI_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(ADI_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_DestroyContState(ContStateData%AD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ADI_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADI_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call AD_PackContState(RF, InData%AD) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADI_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call AD_UnpackContState(RF, OutData%AD) ! AD 
end subroutine

subroutine ADI_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(ADI_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(ADI_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_CopyDiscState(SrcDiscStateData%AD, DstDiscStateData%AD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine ADI_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(ADI_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_DestroyDiscState(DiscStateData%AD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ADI_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADI_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call AD_PackDiscState(RF, InData%AD) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADI_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call AD_UnpackDiscState(RF, OutData%AD) ! AD 
end subroutine

subroutine ADI_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(ADI_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(ADI_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_CopyConstrState(SrcConstrStateData%AD, DstConstrStateData%AD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine ADI_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(ADI_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_DestroyConstrState(ConstrStateData%AD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ADI_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADI_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call AD_PackConstrState(RF, InData%AD) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADI_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call AD_UnpackConstrState(RF, OutData%AD) ! AD 
end subroutine

subroutine ADI_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(ADI_OtherStateType), intent(in) :: SrcOtherStateData
   type(ADI_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_CopyOtherState(SrcOtherStateData%AD, DstOtherStateData%AD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine ADI_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(ADI_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_DestroyOtherState(OtherStateData%AD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ADI_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADI_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call AD_PackOtherState(RF, InData%AD) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADI_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call AD_UnpackOtherState(RF, OutData%AD) ! AD 
end subroutine

subroutine ADI_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(ADI_MiscVarType), intent(inout) :: SrcMiscData
   type(ADI_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_CopyMisc(SrcMiscData%AD, DstMiscData%AD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ADI_CopyInflowWindData(SrcMiscData%IW, DstMiscData%IW, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMiscData%VTK_surfaces)) then
      LB(1:1) = lbound(SrcMiscData%VTK_surfaces)
      UB(1:1) = ubound(SrcMiscData%VTK_surfaces)
      if (.not. allocated(DstMiscData%VTK_surfaces)) then
         allocate(DstMiscData%VTK_surfaces(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%VTK_surfaces.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_CopyVTK_RotSurfaceType(SrcMiscData%VTK_surfaces(i1), DstMiscData%VTK_surfaces(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine ADI_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(ADI_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_DestroyMisc(MiscData%AD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ADI_DestroyInflowWindData(MiscData%IW, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MiscData%VTK_surfaces)) then
      LB(1:1) = lbound(MiscData%VTK_surfaces)
      UB(1:1) = ubound(MiscData%VTK_surfaces)
      do i1 = LB(1), UB(1)
         call AD_DestroyVTK_RotSurfaceType(MiscData%VTK_surfaces(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%VTK_surfaces)
   end if
end subroutine

subroutine ADI_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADI_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackMisc'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call AD_PackMisc(RF, InData%AD) 
   call ADI_PackInflowWindData(RF, InData%IW) 
   call RegPack(RF, allocated(InData%VTK_surfaces))
   if (allocated(InData%VTK_surfaces)) then
      call RegPackBounds(RF, 1, lbound(InData%VTK_surfaces), ubound(InData%VTK_surfaces))
      LB(1:1) = lbound(InData%VTK_surfaces)
      UB(1:1) = ubound(InData%VTK_surfaces)
      do i1 = LB(1), UB(1)
         call AD_PackVTK_RotSurfaceType(RF, InData%VTK_surfaces(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADI_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackMisc'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call AD_UnpackMisc(RF, OutData%AD) ! AD 
   call ADI_UnpackInflowWindData(RF, OutData%IW) ! IW 
   if (allocated(OutData%VTK_surfaces)) deallocate(OutData%VTK_surfaces)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%VTK_surfaces(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%VTK_surfaces.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_UnpackVTK_RotSurfaceType(RF, OutData%VTK_surfaces(i1)) ! VTK_surfaces 
      end do
   end if
end subroutine

subroutine ADI_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(ADI_ParameterType), intent(in) :: SrcParamData
   type(ADI_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_CopyParam(SrcParamData%AD, DstParamData%AD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstParamData%dt = SrcParamData%dt
   DstParamData%storeHHVel = SrcParamData%storeHHVel
   DstParamData%wrVTK = SrcParamData%wrVTK
   DstParamData%WrVTK_Type = SrcParamData%WrVTK_Type
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%MHK = SrcParamData%MHK
   DstParamData%WtrDpth = SrcParamData%WtrDpth
end subroutine

subroutine ADI_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(ADI_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_DestroyParam(ParamData%AD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ADI_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADI_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call AD_PackParam(RF, InData%AD) 
   call RegPack(RF, InData%dt)
   call RegPack(RF, InData%storeHHVel)
   call RegPack(RF, InData%wrVTK)
   call RegPack(RF, InData%WrVTK_Type)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%MHK)
   call RegPack(RF, InData%WtrDpth)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADI_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackParam'
   if (RF%ErrStat /= ErrID_None) return
   call AD_UnpackParam(RF, OutData%AD) ! AD 
   call RegUnpack(RF, OutData%dt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%storeHHVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%wrVTK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrVTK_Type); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MHK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDpth); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(ADI_InputType), intent(inout) :: SrcInputData
   type(ADI_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_CopyInput(SrcInputData%AD, DstInputData%AD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine ADI_DestroyInput(InputData, ErrStat, ErrMsg)
   type(ADI_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_DestroyInput(InputData%AD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ADI_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADI_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call AD_PackInput(RF, InData%AD) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADI_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call AD_UnpackInput(RF, OutData%AD) ! AD 
end subroutine

subroutine ADI_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(ADI_OutputType), intent(inout) :: SrcOutputData
   type(ADI_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_CopyOutput(SrcOutputData%AD, DstOutputData%AD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcOutputData%HHVel)) then
      LB(1:2) = lbound(SrcOutputData%HHVel)
      UB(1:2) = ubound(SrcOutputData%HHVel)
      if (.not. allocated(DstOutputData%HHVel)) then
         allocate(DstOutputData%HHVel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%HHVel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%HHVel = SrcOutputData%HHVel
   end if
   DstOutputData%PLExp = SrcOutputData%PLExp
   if (allocated(SrcOutputData%IW_WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%IW_WriteOutput)
      UB(1:1) = ubound(SrcOutputData%IW_WriteOutput)
      if (.not. allocated(DstOutputData%IW_WriteOutput)) then
         allocate(DstOutputData%IW_WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%IW_WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%IW_WriteOutput = SrcOutputData%IW_WriteOutput
   end if
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine ADI_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(ADI_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_DestroyOutput(OutputData%AD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%HHVel)) then
      deallocate(OutputData%HHVel)
   end if
   if (allocated(OutputData%IW_WriteOutput)) then
      deallocate(OutputData%IW_WriteOutput)
   end if
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine ADI_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADI_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call AD_PackOutput(RF, InData%AD) 
   call RegPackAlloc(RF, InData%HHVel)
   call RegPack(RF, InData%PLExp)
   call RegPackAlloc(RF, InData%IW_WriteOutput)
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADI_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackOutput'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call AD_UnpackOutput(RF, OutData%AD) ! AD 
   call RegUnpackAlloc(RF, OutData%HHVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PLExp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%IW_WriteOutput); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_CopyData(SrcDataData, DstDataData, CtrlCode, ErrStat, ErrMsg)
   type(ADI_Data), intent(inout) :: SrcDataData
   type(ADI_Data), intent(inout) :: DstDataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcDataData%x)) then
      LB(1:1) = lbound(SrcDataData%x)
      UB(1:1) = ubound(SrcDataData%x)
      if (.not. allocated(DstDataData%x)) then
         allocate(DstDataData%x(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDataData%x.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ADI_CopyContState(SrcDataData%x(i1), DstDataData%x(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcDataData%xd)) then
      LB(1:1) = lbound(SrcDataData%xd)
      UB(1:1) = ubound(SrcDataData%xd)
      if (.not. allocated(DstDataData%xd)) then
         allocate(DstDataData%xd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDataData%xd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ADI_CopyDiscState(SrcDataData%xd(i1), DstDataData%xd(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcDataData%z)) then
      LB(1:1) = lbound(SrcDataData%z)
      UB(1:1) = ubound(SrcDataData%z)
      if (.not. allocated(DstDataData%z)) then
         allocate(DstDataData%z(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDataData%z.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ADI_CopyConstrState(SrcDataData%z(i1), DstDataData%z(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcDataData%OtherState)) then
      LB(1:1) = lbound(SrcDataData%OtherState)
      UB(1:1) = ubound(SrcDataData%OtherState)
      if (.not. allocated(DstDataData%OtherState)) then
         allocate(DstDataData%OtherState(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDataData%OtherState.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ADI_CopyOtherState(SrcDataData%OtherState(i1), DstDataData%OtherState(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call ADI_CopyParam(SrcDataData%p, DstDataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ADI_CopyMisc(SrcDataData%m, DstDataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcDataData%u)) then
      LB(1:1) = lbound(SrcDataData%u)
      UB(1:1) = ubound(SrcDataData%u)
      if (.not. allocated(DstDataData%u)) then
         allocate(DstDataData%u(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDataData%u.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ADI_CopyInput(SrcDataData%u(i1), DstDataData%u(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call ADI_CopyOutput(SrcDataData%y, DstDataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcDataData%inputTimes)) then
      LB(1:1) = lbound(SrcDataData%inputTimes)
      UB(1:1) = ubound(SrcDataData%inputTimes)
      if (.not. allocated(DstDataData%inputTimes)) then
         allocate(DstDataData%inputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDataData%inputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDataData%inputTimes = SrcDataData%inputTimes
   end if
end subroutine

subroutine ADI_DestroyData(DataData, ErrStat, ErrMsg)
   type(ADI_Data), intent(inout) :: DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(DataData%x)) then
      LB(1:1) = lbound(DataData%x)
      UB(1:1) = ubound(DataData%x)
      do i1 = LB(1), UB(1)
         call ADI_DestroyContState(DataData%x(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(DataData%x)
   end if
   if (allocated(DataData%xd)) then
      LB(1:1) = lbound(DataData%xd)
      UB(1:1) = ubound(DataData%xd)
      do i1 = LB(1), UB(1)
         call ADI_DestroyDiscState(DataData%xd(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(DataData%xd)
   end if
   if (allocated(DataData%z)) then
      LB(1:1) = lbound(DataData%z)
      UB(1:1) = ubound(DataData%z)
      do i1 = LB(1), UB(1)
         call ADI_DestroyConstrState(DataData%z(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(DataData%z)
   end if
   if (allocated(DataData%OtherState)) then
      LB(1:1) = lbound(DataData%OtherState)
      UB(1:1) = ubound(DataData%OtherState)
      do i1 = LB(1), UB(1)
         call ADI_DestroyOtherState(DataData%OtherState(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(DataData%OtherState)
   end if
   call ADI_DestroyParam(DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ADI_DestroyMisc(DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(DataData%u)) then
      LB(1:1) = lbound(DataData%u)
      UB(1:1) = ubound(DataData%u)
      do i1 = LB(1), UB(1)
         call ADI_DestroyInput(DataData%u(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(DataData%u)
   end if
   call ADI_DestroyOutput(DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(DataData%inputTimes)) then
      deallocate(DataData%inputTimes)
   end if
end subroutine

subroutine ADI_PackData(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADI_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackData'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%x))
   if (allocated(InData%x)) then
      call RegPackBounds(RF, 1, lbound(InData%x), ubound(InData%x))
      LB(1:1) = lbound(InData%x)
      UB(1:1) = ubound(InData%x)
      do i1 = LB(1), UB(1)
         call ADI_PackContState(RF, InData%x(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%xd))
   if (allocated(InData%xd)) then
      call RegPackBounds(RF, 1, lbound(InData%xd), ubound(InData%xd))
      LB(1:1) = lbound(InData%xd)
      UB(1:1) = ubound(InData%xd)
      do i1 = LB(1), UB(1)
         call ADI_PackDiscState(RF, InData%xd(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%z))
   if (allocated(InData%z)) then
      call RegPackBounds(RF, 1, lbound(InData%z), ubound(InData%z))
      LB(1:1) = lbound(InData%z)
      UB(1:1) = ubound(InData%z)
      do i1 = LB(1), UB(1)
         call ADI_PackConstrState(RF, InData%z(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%OtherState))
   if (allocated(InData%OtherState)) then
      call RegPackBounds(RF, 1, lbound(InData%OtherState), ubound(InData%OtherState))
      LB(1:1) = lbound(InData%OtherState)
      UB(1:1) = ubound(InData%OtherState)
      do i1 = LB(1), UB(1)
         call ADI_PackOtherState(RF, InData%OtherState(i1)) 
      end do
   end if
   call ADI_PackParam(RF, InData%p) 
   call ADI_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%u))
   if (allocated(InData%u)) then
      call RegPackBounds(RF, 1, lbound(InData%u), ubound(InData%u))
      LB(1:1) = lbound(InData%u)
      UB(1:1) = ubound(InData%u)
      do i1 = LB(1), UB(1)
         call ADI_PackInput(RF, InData%u(i1)) 
      end do
   end if
   call ADI_PackOutput(RF, InData%y) 
   call RegPackAlloc(RF, InData%inputTimes)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackData(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADI_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackData'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%x)) deallocate(OutData%x)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%x(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%x.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ADI_UnpackContState(RF, OutData%x(i1)) ! x 
      end do
   end if
   if (allocated(OutData%xd)) deallocate(OutData%xd)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%xd(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%xd.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ADI_UnpackDiscState(RF, OutData%xd(i1)) ! xd 
      end do
   end if
   if (allocated(OutData%z)) deallocate(OutData%z)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%z(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%z.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ADI_UnpackConstrState(RF, OutData%z(i1)) ! z 
      end do
   end if
   if (allocated(OutData%OtherState)) deallocate(OutData%OtherState)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OtherState(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OtherState.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ADI_UnpackOtherState(RF, OutData%OtherState(i1)) ! OtherState 
      end do
   end if
   call ADI_UnpackParam(RF, OutData%p) ! p 
   call ADI_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%u)) deallocate(OutData%u)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%u(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%u.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ADI_UnpackInput(RF, OutData%u(i1)) ! u 
      end do
   end if
   call ADI_UnpackOutput(RF, OutData%y) ! y 
   call RegUnpackAlloc(RF, OutData%inputTimes); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_CopyRotFED(SrcRotFEDData, DstRotFEDData, CtrlCode, ErrStat, ErrMsg)
   type(RotFED), intent(inout) :: SrcRotFEDData
   type(RotFED), intent(inout) :: DstRotFEDData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyRotFED'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcRotFEDData%PlatformPtMesh, DstRotFEDData%PlatformPtMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcRotFEDData%TwrPtMesh, DstRotFEDData%TwrPtMesh, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcRotFEDData%TwrPtMeshAD, DstRotFEDData%TwrPtMeshAD, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcRotFEDData%NacelleMotion, DstRotFEDData%NacelleMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MeshCopy(SrcRotFEDData%HubPtMotion, DstRotFEDData%HubPtMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcRotFEDData%BladeRootMotion)) then
      LB(1:1) = lbound(SrcRotFEDData%BladeRootMotion)
      UB(1:1) = ubound(SrcRotFEDData%BladeRootMotion)
      if (.not. allocated(DstRotFEDData%BladeRootMotion)) then
         allocate(DstRotFEDData%BladeRootMotion(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotFEDData%BladeRootMotion.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcRotFEDData%BladeRootMotion(i1), DstRotFEDData%BladeRootMotion(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcRotFEDData%BladeLn2Mesh)) then
      LB(1:1) = lbound(SrcRotFEDData%BladeLn2Mesh)
      UB(1:1) = ubound(SrcRotFEDData%BladeLn2Mesh)
      if (.not. allocated(DstRotFEDData%BladeLn2Mesh)) then
         allocate(DstRotFEDData%BladeLn2Mesh(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotFEDData%BladeLn2Mesh.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcRotFEDData%BladeLn2Mesh(i1), DstRotFEDData%BladeLn2Mesh(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstRotFEDData%hasTower = SrcRotFEDData%hasTower
   DstRotFEDData%rigidBlades = SrcRotFEDData%rigidBlades
   DstRotFEDData%numBlades = SrcRotFEDData%numBlades
   call NWTC_Library_CopyMeshMapType(SrcRotFEDData%ED_P_2_AD_P_T, DstRotFEDData%ED_P_2_AD_P_T, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcRotFEDData%AD_P_2_AD_L_T, DstRotFEDData%AD_P_2_AD_L_T, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcRotFEDData%AD_P_2_AD_L_B)) then
      LB(1:1) = lbound(SrcRotFEDData%AD_P_2_AD_L_B)
      UB(1:1) = ubound(SrcRotFEDData%AD_P_2_AD_L_B)
      if (.not. allocated(DstRotFEDData%AD_P_2_AD_L_B)) then
         allocate(DstRotFEDData%AD_P_2_AD_L_B(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotFEDData%AD_P_2_AD_L_B.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcRotFEDData%AD_P_2_AD_L_B(i1), DstRotFEDData%AD_P_2_AD_L_B(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call NWTC_Library_CopyMeshMapType(SrcRotFEDData%ED_P_2_AD_P_TF, DstRotFEDData%ED_P_2_AD_P_TF, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcRotFEDData%ED_P_2_AD_P_R)) then
      LB(1:1) = lbound(SrcRotFEDData%ED_P_2_AD_P_R)
      UB(1:1) = ubound(SrcRotFEDData%ED_P_2_AD_P_R)
      if (.not. allocated(DstRotFEDData%ED_P_2_AD_P_R)) then
         allocate(DstRotFEDData%ED_P_2_AD_P_R(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstRotFEDData%ED_P_2_AD_P_R.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcRotFEDData%ED_P_2_AD_P_R(i1), DstRotFEDData%ED_P_2_AD_P_R(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call NWTC_Library_CopyMeshMapType(SrcRotFEDData%ED_P_2_AD_P_H, DstRotFEDData%ED_P_2_AD_P_H, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcRotFEDData%ED_P_2_AD_P_N, DstRotFEDData%ED_P_2_AD_P_N, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine ADI_DestroyRotFED(RotFEDData, ErrStat, ErrMsg)
   type(RotFED), intent(inout) :: RotFEDData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyRotFED'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( RotFEDData%PlatformPtMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( RotFEDData%TwrPtMesh, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( RotFEDData%TwrPtMeshAD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( RotFEDData%NacelleMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MeshDestroy( RotFEDData%HubPtMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(RotFEDData%BladeRootMotion)) then
      LB(1:1) = lbound(RotFEDData%BladeRootMotion)
      UB(1:1) = ubound(RotFEDData%BladeRootMotion)
      do i1 = LB(1), UB(1)
         call MeshDestroy( RotFEDData%BladeRootMotion(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotFEDData%BladeRootMotion)
   end if
   if (allocated(RotFEDData%BladeLn2Mesh)) then
      LB(1:1) = lbound(RotFEDData%BladeLn2Mesh)
      UB(1:1) = ubound(RotFEDData%BladeLn2Mesh)
      do i1 = LB(1), UB(1)
         call MeshDestroy( RotFEDData%BladeLn2Mesh(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotFEDData%BladeLn2Mesh)
   end if
   call NWTC_Library_DestroyMeshMapType(RotFEDData%ED_P_2_AD_P_T, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(RotFEDData%AD_P_2_AD_L_T, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(RotFEDData%AD_P_2_AD_L_B)) then
      LB(1:1) = lbound(RotFEDData%AD_P_2_AD_L_B)
      UB(1:1) = ubound(RotFEDData%AD_P_2_AD_L_B)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(RotFEDData%AD_P_2_AD_L_B(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotFEDData%AD_P_2_AD_L_B)
   end if
   call NWTC_Library_DestroyMeshMapType(RotFEDData%ED_P_2_AD_P_TF, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(RotFEDData%ED_P_2_AD_P_R)) then
      LB(1:1) = lbound(RotFEDData%ED_P_2_AD_P_R)
      UB(1:1) = ubound(RotFEDData%ED_P_2_AD_P_R)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(RotFEDData%ED_P_2_AD_P_R(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(RotFEDData%ED_P_2_AD_P_R)
   end if
   call NWTC_Library_DestroyMeshMapType(RotFEDData%ED_P_2_AD_P_H, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(RotFEDData%ED_P_2_AD_P_N, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ADI_PackRotFED(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(RotFED), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackRotFED'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%PlatformPtMesh) 
   call MeshPack(RF, InData%TwrPtMesh) 
   call MeshPack(RF, InData%TwrPtMeshAD) 
   call MeshPack(RF, InData%NacelleMotion) 
   call MeshPack(RF, InData%HubPtMotion) 
   call RegPack(RF, allocated(InData%BladeRootMotion))
   if (allocated(InData%BladeRootMotion)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeRootMotion), ubound(InData%BladeRootMotion))
      LB(1:1) = lbound(InData%BladeRootMotion)
      UB(1:1) = ubound(InData%BladeRootMotion)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeRootMotion(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%BladeLn2Mesh))
   if (allocated(InData%BladeLn2Mesh)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeLn2Mesh), ubound(InData%BladeLn2Mesh))
      LB(1:1) = lbound(InData%BladeLn2Mesh)
      UB(1:1) = ubound(InData%BladeLn2Mesh)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%BladeLn2Mesh(i1)) 
      end do
   end if
   call RegPack(RF, InData%hasTower)
   call RegPack(RF, InData%rigidBlades)
   call RegPack(RF, InData%numBlades)
   call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_AD_P_T) 
   call NWTC_Library_PackMeshMapType(RF, InData%AD_P_2_AD_L_T) 
   call RegPack(RF, allocated(InData%AD_P_2_AD_L_B))
   if (allocated(InData%AD_P_2_AD_L_B)) then
      call RegPackBounds(RF, 1, lbound(InData%AD_P_2_AD_L_B), ubound(InData%AD_P_2_AD_L_B))
      LB(1:1) = lbound(InData%AD_P_2_AD_L_B)
      UB(1:1) = ubound(InData%AD_P_2_AD_L_B)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%AD_P_2_AD_L_B(i1)) 
      end do
   end if
   call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_AD_P_TF) 
   call RegPack(RF, allocated(InData%ED_P_2_AD_P_R))
   if (allocated(InData%ED_P_2_AD_P_R)) then
      call RegPackBounds(RF, 1, lbound(InData%ED_P_2_AD_P_R), ubound(InData%ED_P_2_AD_P_R))
      LB(1:1) = lbound(InData%ED_P_2_AD_P_R)
      UB(1:1) = ubound(InData%ED_P_2_AD_P_R)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_AD_P_R(i1)) 
      end do
   end if
   call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_AD_P_H) 
   call NWTC_Library_PackMeshMapType(RF, InData%ED_P_2_AD_P_N) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackRotFED(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(RotFED), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackRotFED'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%PlatformPtMesh) ! PlatformPtMesh 
   call MeshUnpack(RF, OutData%TwrPtMesh) ! TwrPtMesh 
   call MeshUnpack(RF, OutData%TwrPtMeshAD) ! TwrPtMeshAD 
   call MeshUnpack(RF, OutData%NacelleMotion) ! NacelleMotion 
   call MeshUnpack(RF, OutData%HubPtMotion) ! HubPtMotion 
   if (allocated(OutData%BladeRootMotion)) deallocate(OutData%BladeRootMotion)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeRootMotion(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeRootMotion.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeRootMotion(i1)) ! BladeRootMotion 
      end do
   end if
   if (allocated(OutData%BladeLn2Mesh)) deallocate(OutData%BladeLn2Mesh)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeLn2Mesh(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeLn2Mesh.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%BladeLn2Mesh(i1)) ! BladeLn2Mesh 
      end do
   end if
   call RegUnpack(RF, OutData%hasTower); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rigidBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numBlades); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_AD_P_T) ! ED_P_2_AD_P_T 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%AD_P_2_AD_L_T) ! AD_P_2_AD_L_T 
   if (allocated(OutData%AD_P_2_AD_L_B)) deallocate(OutData%AD_P_2_AD_L_B)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%AD_P_2_AD_L_B(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%AD_P_2_AD_L_B.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%AD_P_2_AD_L_B(i1)) ! AD_P_2_AD_L_B 
      end do
   end if
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_AD_P_TF) ! ED_P_2_AD_P_TF 
   if (allocated(OutData%ED_P_2_AD_P_R)) deallocate(OutData%ED_P_2_AD_P_R)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%ED_P_2_AD_P_R(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%ED_P_2_AD_P_R.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_AD_P_R(i1)) ! ED_P_2_AD_P_R 
      end do
   end if
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_AD_P_H) ! ED_P_2_AD_P_H 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%ED_P_2_AD_P_N) ! ED_P_2_AD_P_N 
end subroutine

subroutine ADI_CopyFED_Data(SrcFED_DataData, DstFED_DataData, CtrlCode, ErrStat, ErrMsg)
   type(FED_Data), intent(inout) :: SrcFED_DataData
   type(FED_Data), intent(inout) :: DstFED_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_CopyFED_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcFED_DataData%WT)) then
      LB(1:1) = lbound(SrcFED_DataData%WT)
      UB(1:1) = ubound(SrcFED_DataData%WT)
      if (.not. allocated(DstFED_DataData%WT)) then
         allocate(DstFED_DataData%WT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstFED_DataData%WT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call ADI_CopyRotFED(SrcFED_DataData%WT(i1), DstFED_DataData%WT(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine ADI_DestroyFED_Data(FED_DataData, ErrStat, ErrMsg)
   type(FED_Data), intent(inout) :: FED_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADI_DestroyFED_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(FED_DataData%WT)) then
      LB(1:1) = lbound(FED_DataData%WT)
      UB(1:1) = ubound(FED_DataData%WT)
      do i1 = LB(1), UB(1)
         call ADI_DestroyRotFED(FED_DataData%WT(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(FED_DataData%WT)
   end if
end subroutine

subroutine ADI_PackFED_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FED_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADI_PackFED_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, allocated(InData%WT))
   if (allocated(InData%WT)) then
      call RegPackBounds(RF, 1, lbound(InData%WT), ubound(InData%WT))
      LB(1:1) = lbound(InData%WT)
      UB(1:1) = ubound(InData%WT)
      do i1 = LB(1), UB(1)
         call ADI_PackRotFED(RF, InData%WT(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADI_UnPackFED_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FED_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADI_UnPackFED_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   if (allocated(OutData%WT)) deallocate(OutData%WT)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%WT(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WT.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call ADI_UnpackRotFED(RF, OutData%WT(i1)) ! WT 
      end do
   end if
end subroutine
END MODULE AeroDyn_Inflow_Types
!ENDOFREGISTRYGENERATEDFILE
