!STARTOFREGISTRYGENERATEDFILE 'AeroDyn_Driver_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! AeroDyn_Driver_Types
!.................................................................................................................................
! This file is part of AeroDyn_Driver.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in AeroDyn_Driver. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE AeroDyn_Driver_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE AeroDyn_Types
USE AeroDyn_Inflow_Types
USE NWTC_Library
IMPLICIT NONE
! =========  Dvr_Case  =======
  TYPE, PUBLIC :: Dvr_Case
    REAL(ReKi)  :: HWindSpeed = 0.0_ReKi      !< Hub wind speed [m/s]
    REAL(ReKi)  :: PLExp = 0.0_ReKi      !< Power law wind-shear exponent [-]
    REAL(ReKi)  :: rotSpeed = 0.0_ReKi      !< Rotor speed [rad/s]
    REAL(ReKi)  :: bldPitch = 0.0_ReKi      !< Pitch angle [rad]
    REAL(ReKi)  :: nacYaw = 0.0_ReKi      !< Yaw angle [rad]
    REAL(DbKi)  :: tMax = 0.0_R8Ki      !< Max time [s]
    REAL(DbKi)  :: dT = 0.0_R8Ki      !< time increment [s]
    INTEGER(IntKi)  :: numSteps = 0_IntKi      !< number of steps in this case [-]
    INTEGER(IntKi)  :: DOF = 0_IntKi      !< Degree of freedom for sinusoidal motion [-]
    REAL(ReKi)  :: amplitude = 0.0_ReKi      !< Amplitude for sinusoidal motion (when DOF>0) [-]
    REAL(ReKi)  :: frequency = 0.0_ReKi      !< Frequency for sinusoidal motion (when DOF>0) [-]
  END TYPE Dvr_Case
! =======================
! =========  DvrVTK_SurfaceType  =======
  TYPE, PUBLIC :: DvrVTK_SurfaceType
    INTEGER(IntKi)  :: NumSectors = 0_IntKi      !< number of sectors in which to split circles (higher number gives smoother surface) [-]
    REAL(SiKi) , DIMENSION(1:3,1:8)  :: NacelleBox = 0.0_R4Ki      !< X-Y-Z locations of 8 points that define the nacelle box, relative to the nacelle position [m]
    REAL(SiKi) , DIMENSION(1:3,1:8)  :: BaseBox = 0.0_R4Ki      !< X-Y-Z locations of 8 points that define the base box [m]
  END TYPE DvrVTK_SurfaceType
! =======================
! =========  Dvr_Outputs  =======
  TYPE, PUBLIC :: Dvr_Outputs
    TYPE(ProgDesc)  :: AD_ver      !< AeroDyn version information [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: unOutFile      !< unit number for writing output file for each rotor [-]
    INTEGER(IntKi)  :: ActualChanLen = 0_IntKi      !< Actual length of channels written to text file (less than or equal to ChanLen) [-]
    INTEGER(IntKi)  :: nDvrOutputs = 0_IntKi      !< Number of outputs for the driver (without AD and IW) [-]
    character(20)  :: Fmt_t      !< Format specifier for time channel [-]
    character(25)  :: Fmt_a      !< Format specifier for each column (including delimiter) [-]
    character(1)  :: delim      !< column delimiter [-]
    character(20)  :: outFmt      !< Format specifier [-]
    INTEGER(IntKi)  :: fileFmt = 0_IntKi      !< Output format 1=Text, 2=Binary, 3=Both [-]
    INTEGER(IntKi)  :: WrVTK = 0_IntKi      !< 0= no vtk, 1=init only, 2=animation [-]
    INTEGER(IntKi)  :: WrVTK_Type = 0_IntKi      !< Flag for VTK output type (1=surface, 2=line, 3=both) [-]
    character(1024)  :: Root      !< Output file rootname [-]
    character(1024)  :: VTK_OutFileRoot      !< Output file rootname for vtk (includes directory) [-]
    character(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Channel headers [-]
    character(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Channel units [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: storage      !< nTurbines x nChannel x nTime [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: outLine      !< Output line to be written to disk [-]
    TYPE(DvrVTK_SurfaceType) , DIMENSION(:), ALLOCATABLE  :: VTK_surface      !< Data for VTK surface visualization [-]
    INTEGER(IntKi)  :: VTK_tWidth = 0_IntKi      !< Width of number of files for leading zeros in file name format [-]
    INTEGER(IntKi)  :: n_VTKTime = 0_IntKi      !< Number of time steps between writing VTK files [-]
    REAL(DbKi)  :: VTK_DT = 0.0_R8Ki      !< Write VTK time step [-]
    REAL(SiKi)  :: VTKHubRad = 0.0_R4Ki      !< Hub radius for visualization [m]
    REAL(ReKi) , DIMENSION(1:6)  :: VTKNacDim = 0.0_ReKi      !< Nacelle dimensions for visualization [m]
    REAL(SiKi) , DIMENSION(1:3)  :: VTKRefPoint = 0.0_R4Ki      !< RefPoint for VTK outputs [-]
    REAL(DbKi)  :: DT_Outs = 0.0_R8Ki      !< Output time resolution [s]
    INTEGER(IntKi)  :: n_DT_Out = 0_IntKi      !< Number of time steps between writing a line in the time-marching output files [-]
  END TYPE Dvr_Outputs
! =======================
! =========  BladeData  =======
  TYPE, PUBLIC :: BladeData
    REAL(ReKi)  :: pitch = 0.0_ReKi      !< rad [-]
    REAL(ReKi)  :: pitchSpeed = 0.0_ReKi      !< rad/s [-]
    REAL(ReKi)  :: pitchAcc = 0.0_ReKi      !< rad/s/s [-]
    REAL(ReKi) , DIMENSION(1:3)  :: origin_h = 0.0_ReKi      !<  [-]
    REAL(ReKi) , DIMENSION(1:3)  :: orientation_h = 0.0_ReKi      !<  [-]
    REAL(ReKi)  :: hubRad_bl = 0.0_ReKi      !<  [-]
    REAL(DbKi) , DIMENSION(1:3,1:3)  :: Rh2bl0 = 0.0_R8Ki      !< Rotation matrix blade 2 hub [-]
    INTEGER(IntKi)  :: motionType = 0_IntKi      !<  [-]
    INTEGER(IntKi)  :: iMotion = 0_IntKi      !< Stored index to optimize time interpolation [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: motion      !<  [-]
    character(1024)  :: motionFileName      !<  [-]
  END TYPE BladeData
! =======================
! =========  HubData  =======
  TYPE, PUBLIC :: HubData
    REAL(ReKi) , DIMENSION(1:3)  :: origin_n = 0.0_ReKi      !<  [-]
    REAL(ReKi) , DIMENSION(1:3)  :: orientation_n = 0.0_ReKi      !<  [-]
    INTEGER(IntKi)  :: motionType = 0_IntKi      !<  [-]
    INTEGER(IntKi)  :: iMotion = 0_IntKi      !< Stored index to optimize time interpolation [-]
    REAL(ReKi)  :: azimuth = 0.0_ReKi      !< rotor position [rad]
    REAL(ReKi)  :: rotSpeed = 0.0_ReKi      !< rotor speed [rad/s]
    REAL(ReKi)  :: rotAcc = 0.0_ReKi      !< rotor acceleration [rad/s/s]
    character(1024)  :: motionFileName      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: motion      !<  [-]
  END TYPE HubData
! =======================
! =========  NacData  =======
  TYPE, PUBLIC :: NacData
    REAL(ReKi) , DIMENSION(1:3)  :: origin_t = 0.0_ReKi      !<  [-]
    INTEGER(IntKi)  :: motionType = 0_IntKi      !<  [-]
    INTEGER(IntKi)  :: iMotion = 0_IntKi      !< Stored index to optimize time interpolation [-]
    REAL(ReKi)  :: yaw = 0.0_ReKi      !< rad [rad]
    REAL(ReKi)  :: yawSpeed = 0.0_ReKi      !< yawspeed  [rad/s]
    REAL(ReKi)  :: yawAcc = 0.0_ReKi      !< yawAcceleration [rad/s^2]
    character(1024)  :: motionFileName      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: motion      !<  [-]
  END TYPE NacData
! =======================
! =========  TwrData  =======
  TYPE, PUBLIC :: TwrData
    REAL(ReKi) , DIMENSION(1:3)  :: origin_t = 0.0_ReKi      !<  [-]
  END TYPE TwrData
! =======================
! =========  WTData  =======
  TYPE, PUBLIC :: WTData
    REAL(ReKi) , DIMENSION(1:3)  :: originInit = 0.0_ReKi      !<  [-]
    REAL(ReKi) , DIMENSION(1:3)  :: orientationInit = 0.0_ReKi      !<  [-]
    TYPE(MeshMapType)  :: map2twrPt      !< Mesh mapping from base to tower [-]
    TYPE(MeshMapType)  :: map2nacPt      !< Mesh mapping from base to nacelle [-]
    TYPE(MeshMapType)  :: map2hubPt      !< Mesh mapping from Nacelle to hub [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: map2BldPt      !< Mesh mapping from hub to bld root motion [-]
    TYPE(BladeData) , DIMENSION(:), ALLOCATABLE  :: bld      !<  [-]
    TYPE(HubData)  :: hub      !<  [-]
    TYPE(NacData)  :: nac      !<  [-]
    TYPE(TwrData)  :: twr      !<  [-]
    INTEGER(IntKi)  :: numBlades = 0_IntKi      !<  [-]
    LOGICAL  :: basicHAWTFormat = .false.      !< If true simply input HubRad/Pitch/Overhang/Cone, otherwise all turbine inputs [-]
    LOGICAL  :: hasTower = .false.      !<  [-]
    INTEGER(IntKi)  :: projMod = 0_IntKi      !< If true simply input HubRad/Pitch/Overhang/Cone, otherwise all turbine inputs [-]
    INTEGER(IntKi)  :: BEM_Mod = 0_IntKi      !< Switch for different BEM implementations [-]
    LOGICAL  :: HAWTprojection = .false.      !<  [-]
    INTEGER(IntKi)  :: motionType = 0_IntKi      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: motion      !<  [-]
    INTEGER(IntKi)  :: iMotion = 0_IntKi      !< Stored index to optimize time interpolation [-]
    INTEGER(IntKi)  :: degreeOfFreedom = 0_IntKi      !<  [-]
    REAL(ReKi)  :: amplitude = 0.0_ReKi      !<  [-]
    REAL(ReKi)  :: frequency = 0.0_ReKi      !<  [-]
    character(1024)  :: motionFileName      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< WriteOutputs of the driver only [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: userSwapArray      !< Array to store user data for user-defined functions [-]
  END TYPE WTData
! =======================
! =========  Dvr_SimData  =======
  TYPE, PUBLIC :: Dvr_SimData
    character(1024)  :: AD_InputFile      !< Name of AeroDyn input file [-]
    INTEGER(IntKi)  :: MHK = 0_IntKi      !< MHK turbine type (switch) {0: not an MHK turbine, 1: fixed MHK turbine, 2: floating MHK turbine} [-]
    INTEGER(IntKi)  :: AnalysisType = 0_IntKi      !< 0=Steady Wind, 1=InflowWind [-]
    REAL(ReKi)  :: FldDens = 0.0_ReKi      !< Density of working fluid [kg/m^3]
    REAL(ReKi)  :: KinVisc = 0.0_ReKi      !< Kinematic viscosity of working fluid [m^2/s]
    REAL(ReKi)  :: SpdSound = 0.0_ReKi      !< Speed of sound in working fluid [m/s]
    REAL(ReKi)  :: Patm = 0.0_ReKi      !< Atmospheric pressure [Pa]
    REAL(ReKi)  :: Pvap = 0.0_ReKi      !< Vapour pressure of working fluid [Pa]
    REAL(ReKi)  :: WtrDpth = 0.0_ReKi      !< Water depth [m]
    REAL(ReKi)  :: MSL2SWL = 0.0_ReKi      !< Offset between still-water level and mean sea level [m]
    INTEGER(IntKi)  :: numTurbines = -9999      !< number of turbine rotors [-]
    TYPE(WTData) , DIMENSION(:), ALLOCATABLE  :: WT      !< Wind turbine data for driver [-]
    REAL(DbKi)  :: dT = 0.0_R8Ki      !< time increment [s]
    REAL(DbKi)  :: tMax = 0.0_R8Ki      !< time increment [s]
    INTEGER(IntKi)  :: numSteps = 0_IntKi      !< number of steps in this case [-]
    INTEGER(IntKi)  :: numCases = 0_IntKi      !< number of steps in this case [-]
    TYPE(Dvr_Case) , DIMENSION(:), ALLOCATABLE  :: Cases      !< table of cases to run when AnalysisType=2 [-]
    INTEGER(IntKi)  :: iCase = 0_IntKi      !< Current Case being run [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: timeSeries      !< Times series inputs when AnalysisType=1, 6 columns, Time, WndSpeed, ShearExp, RotSpd, Pitch, Yaw [-]
    INTEGER(IntKi)  :: iTimeSeries = 0_IntKi      !< Stored index to optimize time interpolation [-]
    character(1024)  :: root      !< Output file rootname [-]
    TYPE(Dvr_Outputs)  :: out      !< data for driver output file [-]
    TYPE(ADI_IW_InputData)  :: IW_InitInp      !<  [-]
  END TYPE Dvr_SimData
! =======================
! =========  AllData  =======
  TYPE, PUBLIC :: AllData
    TYPE(Dvr_SimData)  :: dvr      !< Driver data [-]
    TYPE(ADI_Data)  :: ADI      !< AeroDyn InflowWind Data [-]
    TYPE(FED_Data)  :: FED      !< Elastic wind turbine data (Fake ElastoDyn) [-]
    INTEGER(IntKi)  :: errStat = 0_IntKi      !<  [-]
    character(ErrMsgLen)  :: errMsg      !<  [-]
    LOGICAL  :: initialized = .false.      !<  [-]
  END TYPE AllData
! =======================
CONTAINS

subroutine AD_Dvr_CopyDvr_Case(SrcDvr_CaseData, DstDvr_CaseData, CtrlCode, ErrStat, ErrMsg)
   type(Dvr_Case), intent(in) :: SrcDvr_CaseData
   type(Dvr_Case), intent(inout) :: DstDvr_CaseData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_Dvr_CopyDvr_Case'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDvr_CaseData%HWindSpeed = SrcDvr_CaseData%HWindSpeed
   DstDvr_CaseData%PLExp = SrcDvr_CaseData%PLExp
   DstDvr_CaseData%rotSpeed = SrcDvr_CaseData%rotSpeed
   DstDvr_CaseData%bldPitch = SrcDvr_CaseData%bldPitch
   DstDvr_CaseData%nacYaw = SrcDvr_CaseData%nacYaw
   DstDvr_CaseData%tMax = SrcDvr_CaseData%tMax
   DstDvr_CaseData%dT = SrcDvr_CaseData%dT
   DstDvr_CaseData%numSteps = SrcDvr_CaseData%numSteps
   DstDvr_CaseData%DOF = SrcDvr_CaseData%DOF
   DstDvr_CaseData%amplitude = SrcDvr_CaseData%amplitude
   DstDvr_CaseData%frequency = SrcDvr_CaseData%frequency
end subroutine

subroutine AD_Dvr_DestroyDvr_Case(Dvr_CaseData, ErrStat, ErrMsg)
   type(Dvr_Case), intent(inout) :: Dvr_CaseData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_Dvr_DestroyDvr_Case'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AD_Dvr_PackDvr_Case(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Dvr_Case), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_Dvr_PackDvr_Case'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%HWindSpeed)
   call RegPack(RF, InData%PLExp)
   call RegPack(RF, InData%rotSpeed)
   call RegPack(RF, InData%bldPitch)
   call RegPack(RF, InData%nacYaw)
   call RegPack(RF, InData%tMax)
   call RegPack(RF, InData%dT)
   call RegPack(RF, InData%numSteps)
   call RegPack(RF, InData%DOF)
   call RegPack(RF, InData%amplitude)
   call RegPack(RF, InData%frequency)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_UnPackDvr_Case(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Dvr_Case), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_Dvr_UnPackDvr_Case'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%HWindSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PLExp); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%bldPitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nacYaw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numSteps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DOF); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%amplitude); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%frequency); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_CopyDvrVTK_SurfaceType(SrcDvrVTK_SurfaceTypeData, DstDvrVTK_SurfaceTypeData, CtrlCode, ErrStat, ErrMsg)
   type(DvrVTK_SurfaceType), intent(in) :: SrcDvrVTK_SurfaceTypeData
   type(DvrVTK_SurfaceType), intent(inout) :: DstDvrVTK_SurfaceTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_Dvr_CopyDvrVTK_SurfaceType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDvrVTK_SurfaceTypeData%NumSectors = SrcDvrVTK_SurfaceTypeData%NumSectors
   DstDvrVTK_SurfaceTypeData%NacelleBox = SrcDvrVTK_SurfaceTypeData%NacelleBox
   DstDvrVTK_SurfaceTypeData%BaseBox = SrcDvrVTK_SurfaceTypeData%BaseBox
end subroutine

subroutine AD_Dvr_DestroyDvrVTK_SurfaceType(DvrVTK_SurfaceTypeData, ErrStat, ErrMsg)
   type(DvrVTK_SurfaceType), intent(inout) :: DvrVTK_SurfaceTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_Dvr_DestroyDvrVTK_SurfaceType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AD_Dvr_PackDvrVTK_SurfaceType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(DvrVTK_SurfaceType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_Dvr_PackDvrVTK_SurfaceType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%NumSectors)
   call RegPack(RF, InData%NacelleBox)
   call RegPack(RF, InData%BaseBox)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_UnPackDvrVTK_SurfaceType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(DvrVTK_SurfaceType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_Dvr_UnPackDvrVTK_SurfaceType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%NumSectors); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NacelleBox); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BaseBox); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_CopyDvr_Outputs(SrcDvr_OutputsData, DstDvr_OutputsData, CtrlCode, ErrStat, ErrMsg)
   type(Dvr_Outputs), intent(in) :: SrcDvr_OutputsData
   type(Dvr_Outputs), intent(inout) :: DstDvr_OutputsData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_Dvr_CopyDvr_Outputs'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_CopyProgDesc(SrcDvr_OutputsData%AD_ver, DstDvr_OutputsData%AD_ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcDvr_OutputsData%unOutFile)) then
      LB(1:1) = lbound(SrcDvr_OutputsData%unOutFile)
      UB(1:1) = ubound(SrcDvr_OutputsData%unOutFile)
      if (.not. allocated(DstDvr_OutputsData%unOutFile)) then
         allocate(DstDvr_OutputsData%unOutFile(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDvr_OutputsData%unOutFile.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDvr_OutputsData%unOutFile = SrcDvr_OutputsData%unOutFile
   end if
   DstDvr_OutputsData%ActualChanLen = SrcDvr_OutputsData%ActualChanLen
   DstDvr_OutputsData%nDvrOutputs = SrcDvr_OutputsData%nDvrOutputs
   DstDvr_OutputsData%Fmt_t = SrcDvr_OutputsData%Fmt_t
   DstDvr_OutputsData%Fmt_a = SrcDvr_OutputsData%Fmt_a
   DstDvr_OutputsData%delim = SrcDvr_OutputsData%delim
   DstDvr_OutputsData%outFmt = SrcDvr_OutputsData%outFmt
   DstDvr_OutputsData%fileFmt = SrcDvr_OutputsData%fileFmt
   DstDvr_OutputsData%WrVTK = SrcDvr_OutputsData%WrVTK
   DstDvr_OutputsData%WrVTK_Type = SrcDvr_OutputsData%WrVTK_Type
   DstDvr_OutputsData%Root = SrcDvr_OutputsData%Root
   DstDvr_OutputsData%VTK_OutFileRoot = SrcDvr_OutputsData%VTK_OutFileRoot
   if (allocated(SrcDvr_OutputsData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcDvr_OutputsData%WriteOutputHdr)
      UB(1:1) = ubound(SrcDvr_OutputsData%WriteOutputHdr)
      if (.not. allocated(DstDvr_OutputsData%WriteOutputHdr)) then
         allocate(DstDvr_OutputsData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDvr_OutputsData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDvr_OutputsData%WriteOutputHdr = SrcDvr_OutputsData%WriteOutputHdr
   end if
   if (allocated(SrcDvr_OutputsData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcDvr_OutputsData%WriteOutputUnt)
      UB(1:1) = ubound(SrcDvr_OutputsData%WriteOutputUnt)
      if (.not. allocated(DstDvr_OutputsData%WriteOutputUnt)) then
         allocate(DstDvr_OutputsData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDvr_OutputsData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDvr_OutputsData%WriteOutputUnt = SrcDvr_OutputsData%WriteOutputUnt
   end if
   if (allocated(SrcDvr_OutputsData%storage)) then
      LB(1:3) = lbound(SrcDvr_OutputsData%storage)
      UB(1:3) = ubound(SrcDvr_OutputsData%storage)
      if (.not. allocated(DstDvr_OutputsData%storage)) then
         allocate(DstDvr_OutputsData%storage(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDvr_OutputsData%storage.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDvr_OutputsData%storage = SrcDvr_OutputsData%storage
   end if
   if (allocated(SrcDvr_OutputsData%outLine)) then
      LB(1:1) = lbound(SrcDvr_OutputsData%outLine)
      UB(1:1) = ubound(SrcDvr_OutputsData%outLine)
      if (.not. allocated(DstDvr_OutputsData%outLine)) then
         allocate(DstDvr_OutputsData%outLine(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDvr_OutputsData%outLine.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDvr_OutputsData%outLine = SrcDvr_OutputsData%outLine
   end if
   if (allocated(SrcDvr_OutputsData%VTK_surface)) then
      LB(1:1) = lbound(SrcDvr_OutputsData%VTK_surface)
      UB(1:1) = ubound(SrcDvr_OutputsData%VTK_surface)
      if (.not. allocated(DstDvr_OutputsData%VTK_surface)) then
         allocate(DstDvr_OutputsData%VTK_surface(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDvr_OutputsData%VTK_surface.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_Dvr_CopyDvrVTK_SurfaceType(SrcDvr_OutputsData%VTK_surface(i1), DstDvr_OutputsData%VTK_surface(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstDvr_OutputsData%VTK_tWidth = SrcDvr_OutputsData%VTK_tWidth
   DstDvr_OutputsData%n_VTKTime = SrcDvr_OutputsData%n_VTKTime
   DstDvr_OutputsData%VTK_DT = SrcDvr_OutputsData%VTK_DT
   DstDvr_OutputsData%VTKHubRad = SrcDvr_OutputsData%VTKHubRad
   DstDvr_OutputsData%VTKNacDim = SrcDvr_OutputsData%VTKNacDim
   DstDvr_OutputsData%VTKRefPoint = SrcDvr_OutputsData%VTKRefPoint
   DstDvr_OutputsData%DT_Outs = SrcDvr_OutputsData%DT_Outs
   DstDvr_OutputsData%n_DT_Out = SrcDvr_OutputsData%n_DT_Out
end subroutine

subroutine AD_Dvr_DestroyDvr_Outputs(Dvr_OutputsData, ErrStat, ErrMsg)
   type(Dvr_Outputs), intent(inout) :: Dvr_OutputsData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_Dvr_DestroyDvr_Outputs'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyProgDesc(Dvr_OutputsData%AD_ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(Dvr_OutputsData%unOutFile)) then
      deallocate(Dvr_OutputsData%unOutFile)
   end if
   if (allocated(Dvr_OutputsData%WriteOutputHdr)) then
      deallocate(Dvr_OutputsData%WriteOutputHdr)
   end if
   if (allocated(Dvr_OutputsData%WriteOutputUnt)) then
      deallocate(Dvr_OutputsData%WriteOutputUnt)
   end if
   if (allocated(Dvr_OutputsData%storage)) then
      deallocate(Dvr_OutputsData%storage)
   end if
   if (allocated(Dvr_OutputsData%outLine)) then
      deallocate(Dvr_OutputsData%outLine)
   end if
   if (allocated(Dvr_OutputsData%VTK_surface)) then
      LB(1:1) = lbound(Dvr_OutputsData%VTK_surface)
      UB(1:1) = ubound(Dvr_OutputsData%VTK_surface)
      do i1 = LB(1), UB(1)
         call AD_Dvr_DestroyDvrVTK_SurfaceType(Dvr_OutputsData%VTK_surface(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(Dvr_OutputsData%VTK_surface)
   end if
end subroutine

subroutine AD_Dvr_PackDvr_Outputs(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Dvr_Outputs), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_Dvr_PackDvr_Outputs'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   if (RF%ErrStat >= AbortErrLev) return
   call NWTC_Library_PackProgDesc(RF, InData%AD_ver) 
   call RegPackAlloc(RF, InData%unOutFile)
   call RegPack(RF, InData%ActualChanLen)
   call RegPack(RF, InData%nDvrOutputs)
   call RegPack(RF, InData%Fmt_t)
   call RegPack(RF, InData%Fmt_a)
   call RegPack(RF, InData%delim)
   call RegPack(RF, InData%outFmt)
   call RegPack(RF, InData%fileFmt)
   call RegPack(RF, InData%WrVTK)
   call RegPack(RF, InData%WrVTK_Type)
   call RegPack(RF, InData%Root)
   call RegPack(RF, InData%VTK_OutFileRoot)
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call RegPackAlloc(RF, InData%storage)
   call RegPackAlloc(RF, InData%outLine)
   call RegPack(RF, allocated(InData%VTK_surface))
   if (allocated(InData%VTK_surface)) then
      call RegPackBounds(RF, 1, lbound(InData%VTK_surface), ubound(InData%VTK_surface))
      LB(1:1) = lbound(InData%VTK_surface)
      UB(1:1) = ubound(InData%VTK_surface)
      do i1 = LB(1), UB(1)
         call AD_Dvr_PackDvrVTK_SurfaceType(RF, InData%VTK_surface(i1)) 
      end do
   end if
   call RegPack(RF, InData%VTK_tWidth)
   call RegPack(RF, InData%n_VTKTime)
   call RegPack(RF, InData%VTK_DT)
   call RegPack(RF, InData%VTKHubRad)
   call RegPack(RF, InData%VTKNacDim)
   call RegPack(RF, InData%VTKRefPoint)
   call RegPack(RF, InData%DT_Outs)
   call RegPack(RF, InData%n_DT_Out)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_UnPackDvr_Outputs(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Dvr_Outputs), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_Dvr_UnPackDvr_Outputs'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%AD_ver) ! AD_ver 
   call RegUnpackAlloc(RF, OutData%unOutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ActualChanLen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nDvrOutputs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Fmt_t); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Fmt_a); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%delim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%outFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%fileFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrVTK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrVTK_Type); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Root); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_OutFileRoot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%storage); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%outLine); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%VTK_surface)) deallocate(OutData%VTK_surface)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%VTK_surface(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%VTK_surface.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_Dvr_UnpackDvrVTK_SurfaceType(RF, OutData%VTK_surface(i1)) ! VTK_surface 
      end do
   end if
   call RegUnpack(RF, OutData%VTK_tWidth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_VTKTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTKHubRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTKNacDim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTKRefPoint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT_Outs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_DT_Out); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_CopyBladeData(SrcBladeDataData, DstBladeDataData, CtrlCode, ErrStat, ErrMsg)
   type(BladeData), intent(in) :: SrcBladeDataData
   type(BladeData), intent(inout) :: DstBladeDataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AD_Dvr_CopyBladeData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstBladeDataData%pitch = SrcBladeDataData%pitch
   DstBladeDataData%pitchSpeed = SrcBladeDataData%pitchSpeed
   DstBladeDataData%pitchAcc = SrcBladeDataData%pitchAcc
   DstBladeDataData%origin_h = SrcBladeDataData%origin_h
   DstBladeDataData%orientation_h = SrcBladeDataData%orientation_h
   DstBladeDataData%hubRad_bl = SrcBladeDataData%hubRad_bl
   DstBladeDataData%Rh2bl0 = SrcBladeDataData%Rh2bl0
   DstBladeDataData%motionType = SrcBladeDataData%motionType
   DstBladeDataData%iMotion = SrcBladeDataData%iMotion
   if (allocated(SrcBladeDataData%motion)) then
      LB(1:2) = lbound(SrcBladeDataData%motion)
      UB(1:2) = ubound(SrcBladeDataData%motion)
      if (.not. allocated(DstBladeDataData%motion)) then
         allocate(DstBladeDataData%motion(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstBladeDataData%motion.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstBladeDataData%motion = SrcBladeDataData%motion
   end if
   DstBladeDataData%motionFileName = SrcBladeDataData%motionFileName
end subroutine

subroutine AD_Dvr_DestroyBladeData(BladeDataData, ErrStat, ErrMsg)
   type(BladeData), intent(inout) :: BladeDataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_Dvr_DestroyBladeData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(BladeDataData%motion)) then
      deallocate(BladeDataData%motion)
   end if
end subroutine

subroutine AD_Dvr_PackBladeData(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(BladeData), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_Dvr_PackBladeData'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%pitch)
   call RegPack(RF, InData%pitchSpeed)
   call RegPack(RF, InData%pitchAcc)
   call RegPack(RF, InData%origin_h)
   call RegPack(RF, InData%orientation_h)
   call RegPack(RF, InData%hubRad_bl)
   call RegPack(RF, InData%Rh2bl0)
   call RegPack(RF, InData%motionType)
   call RegPack(RF, InData%iMotion)
   call RegPackAlloc(RF, InData%motion)
   call RegPack(RF, InData%motionFileName)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_UnPackBladeData(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(BladeData), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_Dvr_UnPackBladeData'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%pitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pitchSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%pitchAcc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%origin_h); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%orientation_h); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%hubRad_bl); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Rh2bl0); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%motionType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iMotion); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%motion); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%motionFileName); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_CopyHubData(SrcHubDataData, DstHubDataData, CtrlCode, ErrStat, ErrMsg)
   type(HubData), intent(in) :: SrcHubDataData
   type(HubData), intent(inout) :: DstHubDataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AD_Dvr_CopyHubData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstHubDataData%origin_n = SrcHubDataData%origin_n
   DstHubDataData%orientation_n = SrcHubDataData%orientation_n
   DstHubDataData%motionType = SrcHubDataData%motionType
   DstHubDataData%iMotion = SrcHubDataData%iMotion
   DstHubDataData%azimuth = SrcHubDataData%azimuth
   DstHubDataData%rotSpeed = SrcHubDataData%rotSpeed
   DstHubDataData%rotAcc = SrcHubDataData%rotAcc
   DstHubDataData%motionFileName = SrcHubDataData%motionFileName
   if (allocated(SrcHubDataData%motion)) then
      LB(1:2) = lbound(SrcHubDataData%motion)
      UB(1:2) = ubound(SrcHubDataData%motion)
      if (.not. allocated(DstHubDataData%motion)) then
         allocate(DstHubDataData%motion(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstHubDataData%motion.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstHubDataData%motion = SrcHubDataData%motion
   end if
end subroutine

subroutine AD_Dvr_DestroyHubData(HubDataData, ErrStat, ErrMsg)
   type(HubData), intent(inout) :: HubDataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_Dvr_DestroyHubData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(HubDataData%motion)) then
      deallocate(HubDataData%motion)
   end if
end subroutine

subroutine AD_Dvr_PackHubData(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(HubData), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_Dvr_PackHubData'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%origin_n)
   call RegPack(RF, InData%orientation_n)
   call RegPack(RF, InData%motionType)
   call RegPack(RF, InData%iMotion)
   call RegPack(RF, InData%azimuth)
   call RegPack(RF, InData%rotSpeed)
   call RegPack(RF, InData%rotAcc)
   call RegPack(RF, InData%motionFileName)
   call RegPackAlloc(RF, InData%motion)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_UnPackHubData(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(HubData), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_Dvr_UnPackHubData'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%origin_n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%orientation_n); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%motionType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iMotion); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%azimuth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%rotAcc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%motionFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%motion); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_CopyNacData(SrcNacDataData, DstNacDataData, CtrlCode, ErrStat, ErrMsg)
   type(NacData), intent(in) :: SrcNacDataData
   type(NacData), intent(inout) :: DstNacDataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AD_Dvr_CopyNacData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstNacDataData%origin_t = SrcNacDataData%origin_t
   DstNacDataData%motionType = SrcNacDataData%motionType
   DstNacDataData%iMotion = SrcNacDataData%iMotion
   DstNacDataData%yaw = SrcNacDataData%yaw
   DstNacDataData%yawSpeed = SrcNacDataData%yawSpeed
   DstNacDataData%yawAcc = SrcNacDataData%yawAcc
   DstNacDataData%motionFileName = SrcNacDataData%motionFileName
   if (allocated(SrcNacDataData%motion)) then
      LB(1:2) = lbound(SrcNacDataData%motion)
      UB(1:2) = ubound(SrcNacDataData%motion)
      if (.not. allocated(DstNacDataData%motion)) then
         allocate(DstNacDataData%motion(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstNacDataData%motion.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstNacDataData%motion = SrcNacDataData%motion
   end if
end subroutine

subroutine AD_Dvr_DestroyNacData(NacDataData, ErrStat, ErrMsg)
   type(NacData), intent(inout) :: NacDataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_Dvr_DestroyNacData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(NacDataData%motion)) then
      deallocate(NacDataData%motion)
   end if
end subroutine

subroutine AD_Dvr_PackNacData(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(NacData), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_Dvr_PackNacData'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%origin_t)
   call RegPack(RF, InData%motionType)
   call RegPack(RF, InData%iMotion)
   call RegPack(RF, InData%yaw)
   call RegPack(RF, InData%yawSpeed)
   call RegPack(RF, InData%yawAcc)
   call RegPack(RF, InData%motionFileName)
   call RegPackAlloc(RF, InData%motion)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_UnPackNacData(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(NacData), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_Dvr_UnPackNacData'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%origin_t); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%motionType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iMotion); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%yaw); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%yawSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%yawAcc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%motionFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%motion); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_CopyTwrData(SrcTwrDataData, DstTwrDataData, CtrlCode, ErrStat, ErrMsg)
   type(TwrData), intent(in) :: SrcTwrDataData
   type(TwrData), intent(inout) :: DstTwrDataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_Dvr_CopyTwrData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstTwrDataData%origin_t = SrcTwrDataData%origin_t
end subroutine

subroutine AD_Dvr_DestroyTwrData(TwrDataData, ErrStat, ErrMsg)
   type(TwrData), intent(inout) :: TwrDataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AD_Dvr_DestroyTwrData'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AD_Dvr_PackTwrData(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(TwrData), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_Dvr_PackTwrData'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%origin_t)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_UnPackTwrData(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(TwrData), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_Dvr_UnPackTwrData'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%origin_t); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_CopyWTData(SrcWTDataData, DstWTDataData, CtrlCode, ErrStat, ErrMsg)
   type(WTData), intent(inout) :: SrcWTDataData
   type(WTData), intent(inout) :: DstWTDataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_Dvr_CopyWTData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstWTDataData%originInit = SrcWTDataData%originInit
   DstWTDataData%orientationInit = SrcWTDataData%orientationInit
   call NWTC_Library_CopyMeshMapType(SrcWTDataData%map2twrPt, DstWTDataData%map2twrPt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcWTDataData%map2nacPt, DstWTDataData%map2nacPt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call NWTC_Library_CopyMeshMapType(SrcWTDataData%map2hubPt, DstWTDataData%map2hubPt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcWTDataData%map2BldPt)) then
      LB(1:1) = lbound(SrcWTDataData%map2BldPt)
      UB(1:1) = ubound(SrcWTDataData%map2BldPt)
      if (.not. allocated(DstWTDataData%map2BldPt)) then
         allocate(DstWTDataData%map2BldPt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWTDataData%map2BldPt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcWTDataData%map2BldPt(i1), DstWTDataData%map2BldPt(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcWTDataData%bld)) then
      LB(1:1) = lbound(SrcWTDataData%bld)
      UB(1:1) = ubound(SrcWTDataData%bld)
      if (.not. allocated(DstWTDataData%bld)) then
         allocate(DstWTDataData%bld(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWTDataData%bld.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_Dvr_CopyBladeData(SrcWTDataData%bld(i1), DstWTDataData%bld(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call AD_Dvr_CopyHubData(SrcWTDataData%hub, DstWTDataData%hub, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AD_Dvr_CopyNacData(SrcWTDataData%nac, DstWTDataData%nac, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AD_Dvr_CopyTwrData(SrcWTDataData%twr, DstWTDataData%twr, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstWTDataData%numBlades = SrcWTDataData%numBlades
   DstWTDataData%basicHAWTFormat = SrcWTDataData%basicHAWTFormat
   DstWTDataData%hasTower = SrcWTDataData%hasTower
   DstWTDataData%projMod = SrcWTDataData%projMod
   DstWTDataData%BEM_Mod = SrcWTDataData%BEM_Mod
   DstWTDataData%HAWTprojection = SrcWTDataData%HAWTprojection
   DstWTDataData%motionType = SrcWTDataData%motionType
   if (allocated(SrcWTDataData%motion)) then
      LB(1:2) = lbound(SrcWTDataData%motion)
      UB(1:2) = ubound(SrcWTDataData%motion)
      if (.not. allocated(DstWTDataData%motion)) then
         allocate(DstWTDataData%motion(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWTDataData%motion.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWTDataData%motion = SrcWTDataData%motion
   end if
   DstWTDataData%iMotion = SrcWTDataData%iMotion
   DstWTDataData%degreeOfFreedom = SrcWTDataData%degreeOfFreedom
   DstWTDataData%amplitude = SrcWTDataData%amplitude
   DstWTDataData%frequency = SrcWTDataData%frequency
   DstWTDataData%motionFileName = SrcWTDataData%motionFileName
   if (allocated(SrcWTDataData%WriteOutput)) then
      LB(1:1) = lbound(SrcWTDataData%WriteOutput)
      UB(1:1) = ubound(SrcWTDataData%WriteOutput)
      if (.not. allocated(DstWTDataData%WriteOutput)) then
         allocate(DstWTDataData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWTDataData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWTDataData%WriteOutput = SrcWTDataData%WriteOutput
   end if
   if (allocated(SrcWTDataData%userSwapArray)) then
      LB(1:1) = lbound(SrcWTDataData%userSwapArray)
      UB(1:1) = ubound(SrcWTDataData%userSwapArray)
      if (.not. allocated(DstWTDataData%userSwapArray)) then
         allocate(DstWTDataData%userSwapArray(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstWTDataData%userSwapArray.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstWTDataData%userSwapArray = SrcWTDataData%userSwapArray
   end if
end subroutine

subroutine AD_Dvr_DestroyWTData(WTDataData, ErrStat, ErrMsg)
   type(WTData), intent(inout) :: WTDataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_Dvr_DestroyWTData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyMeshMapType(WTDataData%map2twrPt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(WTDataData%map2nacPt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call NWTC_Library_DestroyMeshMapType(WTDataData%map2hubPt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(WTDataData%map2BldPt)) then
      LB(1:1) = lbound(WTDataData%map2BldPt)
      UB(1:1) = ubound(WTDataData%map2BldPt)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(WTDataData%map2BldPt(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(WTDataData%map2BldPt)
   end if
   if (allocated(WTDataData%bld)) then
      LB(1:1) = lbound(WTDataData%bld)
      UB(1:1) = ubound(WTDataData%bld)
      do i1 = LB(1), UB(1)
         call AD_Dvr_DestroyBladeData(WTDataData%bld(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(WTDataData%bld)
   end if
   call AD_Dvr_DestroyHubData(WTDataData%hub, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AD_Dvr_DestroyNacData(WTDataData%nac, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AD_Dvr_DestroyTwrData(WTDataData%twr, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(WTDataData%motion)) then
      deallocate(WTDataData%motion)
   end if
   if (allocated(WTDataData%WriteOutput)) then
      deallocate(WTDataData%WriteOutput)
   end if
   if (allocated(WTDataData%userSwapArray)) then
      deallocate(WTDataData%userSwapArray)
   end if
end subroutine

subroutine AD_Dvr_PackWTData(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WTData), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_Dvr_PackWTData'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%originInit)
   call RegPack(RF, InData%orientationInit)
   call NWTC_Library_PackMeshMapType(RF, InData%map2twrPt) 
   call NWTC_Library_PackMeshMapType(RF, InData%map2nacPt) 
   call NWTC_Library_PackMeshMapType(RF, InData%map2hubPt) 
   call RegPack(RF, allocated(InData%map2BldPt))
   if (allocated(InData%map2BldPt)) then
      call RegPackBounds(RF, 1, lbound(InData%map2BldPt), ubound(InData%map2BldPt))
      LB(1:1) = lbound(InData%map2BldPt)
      UB(1:1) = ubound(InData%map2BldPt)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%map2BldPt(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%bld))
   if (allocated(InData%bld)) then
      call RegPackBounds(RF, 1, lbound(InData%bld), ubound(InData%bld))
      LB(1:1) = lbound(InData%bld)
      UB(1:1) = ubound(InData%bld)
      do i1 = LB(1), UB(1)
         call AD_Dvr_PackBladeData(RF, InData%bld(i1)) 
      end do
   end if
   call AD_Dvr_PackHubData(RF, InData%hub) 
   call AD_Dvr_PackNacData(RF, InData%nac) 
   call AD_Dvr_PackTwrData(RF, InData%twr) 
   call RegPack(RF, InData%numBlades)
   call RegPack(RF, InData%basicHAWTFormat)
   call RegPack(RF, InData%hasTower)
   call RegPack(RF, InData%projMod)
   call RegPack(RF, InData%BEM_Mod)
   call RegPack(RF, InData%HAWTprojection)
   call RegPack(RF, InData%motionType)
   call RegPackAlloc(RF, InData%motion)
   call RegPack(RF, InData%iMotion)
   call RegPack(RF, InData%degreeOfFreedom)
   call RegPack(RF, InData%amplitude)
   call RegPack(RF, InData%frequency)
   call RegPack(RF, InData%motionFileName)
   call RegPackAlloc(RF, InData%WriteOutput)
   call RegPackAlloc(RF, InData%userSwapArray)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_UnPackWTData(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WTData), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_Dvr_UnPackWTData'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%originInit); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%orientationInit); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackMeshMapType(RF, OutData%map2twrPt) ! map2twrPt 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%map2nacPt) ! map2nacPt 
   call NWTC_Library_UnpackMeshMapType(RF, OutData%map2hubPt) ! map2hubPt 
   if (allocated(OutData%map2BldPt)) deallocate(OutData%map2BldPt)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%map2BldPt(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%map2BldPt.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%map2BldPt(i1)) ! map2BldPt 
      end do
   end if
   if (allocated(OutData%bld)) deallocate(OutData%bld)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%bld(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%bld.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_Dvr_UnpackBladeData(RF, OutData%bld(i1)) ! bld 
      end do
   end if
   call AD_Dvr_UnpackHubData(RF, OutData%hub) ! hub 
   call AD_Dvr_UnpackNacData(RF, OutData%nac) ! nac 
   call AD_Dvr_UnpackTwrData(RF, OutData%twr) ! twr 
   call RegUnpack(RF, OutData%numBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%basicHAWTFormat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%hasTower); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%projMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BEM_Mod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HAWTprojection); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%motionType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%motion); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iMotion); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%degreeOfFreedom); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%amplitude); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%frequency); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%motionFileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%userSwapArray); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_CopyDvr_SimData(SrcDvr_SimDataData, DstDvr_SimDataData, CtrlCode, ErrStat, ErrMsg)
   type(Dvr_SimData), intent(inout) :: SrcDvr_SimDataData
   type(Dvr_SimData), intent(inout) :: DstDvr_SimDataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_Dvr_CopyDvr_SimData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDvr_SimDataData%AD_InputFile = SrcDvr_SimDataData%AD_InputFile
   DstDvr_SimDataData%MHK = SrcDvr_SimDataData%MHK
   DstDvr_SimDataData%AnalysisType = SrcDvr_SimDataData%AnalysisType
   DstDvr_SimDataData%FldDens = SrcDvr_SimDataData%FldDens
   DstDvr_SimDataData%KinVisc = SrcDvr_SimDataData%KinVisc
   DstDvr_SimDataData%SpdSound = SrcDvr_SimDataData%SpdSound
   DstDvr_SimDataData%Patm = SrcDvr_SimDataData%Patm
   DstDvr_SimDataData%Pvap = SrcDvr_SimDataData%Pvap
   DstDvr_SimDataData%WtrDpth = SrcDvr_SimDataData%WtrDpth
   DstDvr_SimDataData%MSL2SWL = SrcDvr_SimDataData%MSL2SWL
   DstDvr_SimDataData%numTurbines = SrcDvr_SimDataData%numTurbines
   if (allocated(SrcDvr_SimDataData%WT)) then
      LB(1:1) = lbound(SrcDvr_SimDataData%WT)
      UB(1:1) = ubound(SrcDvr_SimDataData%WT)
      if (.not. allocated(DstDvr_SimDataData%WT)) then
         allocate(DstDvr_SimDataData%WT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDvr_SimDataData%WT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_Dvr_CopyWTData(SrcDvr_SimDataData%WT(i1), DstDvr_SimDataData%WT(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstDvr_SimDataData%dT = SrcDvr_SimDataData%dT
   DstDvr_SimDataData%tMax = SrcDvr_SimDataData%tMax
   DstDvr_SimDataData%numSteps = SrcDvr_SimDataData%numSteps
   DstDvr_SimDataData%numCases = SrcDvr_SimDataData%numCases
   if (allocated(SrcDvr_SimDataData%Cases)) then
      LB(1:1) = lbound(SrcDvr_SimDataData%Cases)
      UB(1:1) = ubound(SrcDvr_SimDataData%Cases)
      if (.not. allocated(DstDvr_SimDataData%Cases)) then
         allocate(DstDvr_SimDataData%Cases(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDvr_SimDataData%Cases.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AD_Dvr_CopyDvr_Case(SrcDvr_SimDataData%Cases(i1), DstDvr_SimDataData%Cases(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstDvr_SimDataData%iCase = SrcDvr_SimDataData%iCase
   if (allocated(SrcDvr_SimDataData%timeSeries)) then
      LB(1:2) = lbound(SrcDvr_SimDataData%timeSeries)
      UB(1:2) = ubound(SrcDvr_SimDataData%timeSeries)
      if (.not. allocated(DstDvr_SimDataData%timeSeries)) then
         allocate(DstDvr_SimDataData%timeSeries(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDvr_SimDataData%timeSeries.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDvr_SimDataData%timeSeries = SrcDvr_SimDataData%timeSeries
   end if
   DstDvr_SimDataData%iTimeSeries = SrcDvr_SimDataData%iTimeSeries
   DstDvr_SimDataData%root = SrcDvr_SimDataData%root
   call AD_Dvr_CopyDvr_Outputs(SrcDvr_SimDataData%out, DstDvr_SimDataData%out, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ADI_CopyIW_InputData(SrcDvr_SimDataData%IW_InitInp, DstDvr_SimDataData%IW_InitInp, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine AD_Dvr_DestroyDvr_SimData(Dvr_SimDataData, ErrStat, ErrMsg)
   type(Dvr_SimData), intent(inout) :: Dvr_SimDataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_Dvr_DestroyDvr_SimData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(Dvr_SimDataData%WT)) then
      LB(1:1) = lbound(Dvr_SimDataData%WT)
      UB(1:1) = ubound(Dvr_SimDataData%WT)
      do i1 = LB(1), UB(1)
         call AD_Dvr_DestroyWTData(Dvr_SimDataData%WT(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(Dvr_SimDataData%WT)
   end if
   if (allocated(Dvr_SimDataData%Cases)) then
      LB(1:1) = lbound(Dvr_SimDataData%Cases)
      UB(1:1) = ubound(Dvr_SimDataData%Cases)
      do i1 = LB(1), UB(1)
         call AD_Dvr_DestroyDvr_Case(Dvr_SimDataData%Cases(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(Dvr_SimDataData%Cases)
   end if
   if (allocated(Dvr_SimDataData%timeSeries)) then
      deallocate(Dvr_SimDataData%timeSeries)
   end if
   call AD_Dvr_DestroyDvr_Outputs(Dvr_SimDataData%out, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ADI_DestroyIW_InputData(Dvr_SimDataData%IW_InitInp, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AD_Dvr_PackDvr_SimData(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Dvr_SimData), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_Dvr_PackDvr_SimData'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%AD_InputFile)
   call RegPack(RF, InData%MHK)
   call RegPack(RF, InData%AnalysisType)
   call RegPack(RF, InData%FldDens)
   call RegPack(RF, InData%KinVisc)
   call RegPack(RF, InData%SpdSound)
   call RegPack(RF, InData%Patm)
   call RegPack(RF, InData%Pvap)
   call RegPack(RF, InData%WtrDpth)
   call RegPack(RF, InData%MSL2SWL)
   call RegPack(RF, InData%numTurbines)
   call RegPack(RF, allocated(InData%WT))
   if (allocated(InData%WT)) then
      call RegPackBounds(RF, 1, lbound(InData%WT), ubound(InData%WT))
      LB(1:1) = lbound(InData%WT)
      UB(1:1) = ubound(InData%WT)
      do i1 = LB(1), UB(1)
         call AD_Dvr_PackWTData(RF, InData%WT(i1)) 
      end do
   end if
   call RegPack(RF, InData%dT)
   call RegPack(RF, InData%tMax)
   call RegPack(RF, InData%numSteps)
   call RegPack(RF, InData%numCases)
   call RegPack(RF, allocated(InData%Cases))
   if (allocated(InData%Cases)) then
      call RegPackBounds(RF, 1, lbound(InData%Cases), ubound(InData%Cases))
      LB(1:1) = lbound(InData%Cases)
      UB(1:1) = ubound(InData%Cases)
      do i1 = LB(1), UB(1)
         call AD_Dvr_PackDvr_Case(RF, InData%Cases(i1)) 
      end do
   end if
   call RegPack(RF, InData%iCase)
   call RegPackAlloc(RF, InData%timeSeries)
   call RegPack(RF, InData%iTimeSeries)
   call RegPack(RF, InData%root)
   call AD_Dvr_PackDvr_Outputs(RF, InData%out) 
   call ADI_PackIW_InputData(RF, InData%IW_InitInp) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_UnPackDvr_SimData(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Dvr_SimData), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_Dvr_UnPackDvr_SimData'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%AD_InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MHK); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AnalysisType); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FldDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%KinVisc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SpdSound); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Patm); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Pvap); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WtrDpth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MSL2SWL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numTurbines); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%WT)) deallocate(OutData%WT)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%WT(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WT.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_Dvr_UnpackWTData(RF, OutData%WT(i1)) ! WT 
      end do
   end if
   call RegUnpack(RF, OutData%dT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numSteps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%numCases); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%Cases)) deallocate(OutData%Cases)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Cases(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Cases.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AD_Dvr_UnpackDvr_Case(RF, OutData%Cases(i1)) ! Cases 
      end do
   end if
   call RegUnpack(RF, OutData%iCase); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%timeSeries); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%iTimeSeries); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%root); if (RegCheckErr(RF, RoutineName)) return
   call AD_Dvr_UnpackDvr_Outputs(RF, OutData%out) ! out 
   call ADI_UnpackIW_InputData(RF, OutData%IW_InitInp) ! IW_InitInp 
end subroutine

subroutine AD_Dvr_CopyAllData(SrcAllDataData, DstAllDataData, CtrlCode, ErrStat, ErrMsg)
   type(AllData), intent(inout) :: SrcAllDataData
   type(AllData), intent(inout) :: DstAllDataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_Dvr_CopyAllData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_Dvr_CopyDvr_SimData(SrcAllDataData%dvr, DstAllDataData%dvr, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ADI_CopyData(SrcAllDataData%ADI, DstAllDataData%ADI, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call ADI_CopyFED_Data(SrcAllDataData%FED, DstAllDataData%FED, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstAllDataData%errStat = SrcAllDataData%errStat
   DstAllDataData%errMsg = SrcAllDataData%errMsg
   DstAllDataData%initialized = SrcAllDataData%initialized
end subroutine

subroutine AD_Dvr_DestroyAllData(AllDataData, ErrStat, ErrMsg)
   type(AllData), intent(inout) :: AllDataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AD_Dvr_DestroyAllData'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AD_Dvr_DestroyDvr_SimData(AllDataData%dvr, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ADI_DestroyData(AllDataData%ADI, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call ADI_DestroyFED_Data(AllDataData%FED, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AD_Dvr_PackAllData(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AllData), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AD_Dvr_PackAllData'
   if (RF%ErrStat >= AbortErrLev) return
   call AD_Dvr_PackDvr_SimData(RF, InData%dvr) 
   call ADI_PackData(RF, InData%ADI) 
   call ADI_PackFED_Data(RF, InData%FED) 
   call RegPack(RF, InData%errStat)
   call RegPack(RF, InData%errMsg)
   call RegPack(RF, InData%initialized)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AD_Dvr_UnPackAllData(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AllData), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AD_Dvr_UnPackAllData'
   if (RF%ErrStat /= ErrID_None) return
   call AD_Dvr_UnpackDvr_SimData(RF, OutData%dvr) ! dvr 
   call ADI_UnpackData(RF, OutData%ADI) ! ADI 
   call ADI_UnpackFED_Data(RF, OutData%FED) ! FED 
   call RegUnpack(RF, OutData%errStat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%errMsg); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%initialized); if (RegCheckErr(RF, RoutineName)) return
end subroutine
END MODULE AeroDyn_Driver_Types
!ENDOFREGISTRYGENERATEDFILE
