!STARTOFREGISTRYGENERATEDFILE 'AeroAcoustics_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! AeroAcoustics_Types
!.................................................................................................................................
! This file is part of AeroAcoustics.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in AeroAcoustics. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE AeroAcoustics_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE AirfoilInfo_Types
USE NWTC_Library
IMPLICIT NONE
! =========  AA_BladePropsType  =======
  TYPE, PUBLIC :: AA_BladePropsType
    REAL(ReKi)  :: TEThick = 0.0_ReKi      !<  [-]
    REAL(ReKi)  :: TEAngle = 0.0_ReKi      !<  [-]
  END TYPE AA_BladePropsType
! =======================
! =========  AA_InitInputType  =======
  TYPE, PUBLIC :: AA_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file [-]
    INTEGER(IntKi)  :: NumBlades = 0_IntKi      !< Number of blades on the turbine [-]
    INTEGER(IntKi)  :: NumBlNds = 0_IntKi      !< Number of blade nodes [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlSpn      !< Span at blade node [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlChord      !< Chord at blade node [m]
    REAL(ReKi)  :: AirDens = 0.0_ReKi      !< Air density [kg/m^3]
    REAL(ReKi)  :: KinVisc = 0.0_ReKi      !< Kinematic air viscosity [m^2/s]
    REAL(ReKi)  :: SpdSound = 0.0_ReKi      !< Speed of sound [m/s]
    REAL(ReKi)  :: HubHeight = 0.0_ReKi      !< Hub Height [m]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: BlAFID      !< Index of airfoil data file for blade node location [array of numBladeNodes by numBlades] [-]
    TYPE(AFI_ParameterType) , DIMENSION(:), ALLOCATABLE  :: AFInfo      !< Airfoil information structure containing the aerodynamic center and airfoil shape coordinates [-]
  END TYPE AA_InitInputType
! =======================
! =========  AA_InitOutputType  =======
  TYPE, PUBLIC :: AA_InitOutputType
    CHARACTER(20) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(20) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    CHARACTER(20) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdrforPE      !< Names of the output-to-file channels [-]
    CHARACTER(20) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUntforPE      !< Units of the output-to-file channels [-]
    CHARACTER(25) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdrSep      !< Names of the output-to-file channels [-]
    CHARACTER(25) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUntSep      !< Units of the output-to-file channels [-]
    CHARACTER(25) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdrNodes      !< Names of the output-to-file channels [-]
    CHARACTER(25) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUntNodes      !< Units of the output-to-file channels [-]
    character(1)  :: delim      !< column delimiter [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    REAL(ReKi)  :: AirDens = 0.0_ReKi      !< Air density [kg/m^3]
  END TYPE AA_InitOutputType
! =======================
! =========  AA_InputFile  =======
  TYPE, PUBLIC :: AA_InputFile
    REAL(DbKi)  :: DT_AA = 0.0_R8Ki      !< Time interval for aerodynamic calculations {or "default"} [s]
    INTEGER(IntKi)  :: IBLUNT = 0_IntKi      !< FLAG TO COMPUTE BLUNTNESS NOISE [-]
    INTEGER(IntKi)  :: ILAM = 0_IntKi      !< FLAG TO COMPUTE LBL NOISE {1=steady model, 2=Beddoes-Leishman unsteady model} [-]
    INTEGER(IntKi)  :: ITIP = 0_IntKi      !< FLAG TO COMPUTE TIP NOISE {0=none, 1=baseline potential flow, 2=potential flow with Bak correction} [-]
    INTEGER(IntKi)  :: ITRIP = 0_IntKi      !< FLAG TO TRIP BOUNDARY LAYER {0=none, 1=baseline potential flow, 2=potential flow with Bak correction} [-]
    INTEGER(IntKi)  :: ITURB = 0_IntKi      !< FLAG TO COMPUTE TBLTE NOISE {0=none, 1=baseline potential flow, 2=potential flow with Bak correction} [-]
    INTEGER(IntKi)  :: IInflow = 0_IntKi      !< FLAG TO COMPUTE Turbulent Inflow NOISE {0=none, 1=baseline potential flow, 2=potential flow with Bak correction} [-]
    INTEGER(IntKi)  :: X_BLMethod = 0_IntKi      !< Integer describing calculation method for boundary layer properties,  = 1 BPM = 2 Pretabulated [-]
    INTEGER(IntKi)  :: TICalcMeth = 0_IntKi      !< TICalcMeth [-]
    INTEGER(IntKi)  :: NReListBL = 0_IntKi      !< Number of values of ReListBL [-]
    LOGICAL  :: aweightflag = .false.      !< Integer a weighting call [-]
    LOGICAL  :: ROUND = .false.      !< LOGICAL INDICATING ROUNDED TIP [-]
    REAL(ReKi)  :: ALPRAT = 0.0_ReKi      !< TIP LIFT CURVE SLOPE [-]
    INTEGER(IntKi)  :: AA_Bl_Prcntge = 0_IntKi      !< see the AeroAcoustics input file for description   [-]
    INTEGER(IntKi)  :: NrObsLoc = 0_IntKi      !< Number of observer locations  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ObsX      !< Observer location in tower-base coordinate X horizontal [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ObsY      !< Observer location in tower-base coordinate Y lateral [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ObsZ      !< Observer location in tower-base coordinate Z vertical [m]
    TYPE(AA_BladePropsType) , DIMENSION(:), ALLOCATABLE  :: BladeProps      !< blade property information from blade input files [-]
    INTEGER(IntKi)  :: NrOutFile = 0_IntKi      !< Nr of output files [-]
    CHARACTER(1024) , DIMENSION(:), ALLOCATABLE  :: AAoutfile      !< AAoutfile for writing output files [-]
    CHARACTER(1024)  :: FTitle      !< File Title: the 2nd line of the input file, which contains a description of its contents [-]
    REAL(DbKi)  :: AAStart = 0.0_R8Ki      !< Time after which to calculate AA [s]
    REAL(ReKi)  :: TI = 0.0_ReKi      !< Average rotor incident turbulence intensity [-]
    REAL(ReKi)  :: avgV = 0.0_ReKi      !< Average wind speed [-]
    REAL(ReKi)  :: Lturb = 0.0_ReKi      !< Turbulent lengthscale in Amiet model [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ReListBL      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AoAListBL      !<  [deg]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Pres_DispThick      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Suct_DispThick      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Pres_BLThick      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Suct_BLThick      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Pres_Cf      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Suct_Cf      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Pres_EdgeVelRat      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Suct_EdgeVelRat      !<  [-]
  END TYPE AA_InputFile
! =======================
! =========  AA_ContinuousStateType  =======
  TYPE, PUBLIC :: AA_ContinuousStateType
    REAL(SiKi)  :: DummyContState = 0.0_R4Ki      !< Remove this variable if you have continuous states [-]
  END TYPE AA_ContinuousStateType
! =======================
! =========  AA_DiscreteStateType  =======
  TYPE, PUBLIC :: AA_DiscreteStateType
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MeanVrel      !< Vrel Cumu. Mean [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: VrelSq      !< Vrel Squared Store [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TIVrel      !< Vrel St. deviat [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: VrelStore      !< Vrel Store for fft - dissipation [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TIVx      !< Vx St. deviat [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: MeanVxVyVz      !< Vrel Cumu. Mean [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: VxSq      !< Vxl Squared Store [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: allregcounter      !<  [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: VxSqRegion      !<  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: RegVxStor      !< VxVyVz Store for fft or TI - dissipation [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: RegionTIDelete      !<  [-]
  END TYPE AA_DiscreteStateType
! =======================
! =========  AA_ConstraintStateType  =======
  TYPE, PUBLIC :: AA_ConstraintStateType
    REAL(SiKi)  :: DummyConstrState = 0.0_R4Ki      !< Remove this variable if you have  states [-]
  END TYPE AA_ConstraintStateType
! =======================
! =========  AA_OtherStateType  =======
  TYPE, PUBLIC :: AA_OtherStateType
    REAL(SiKi)  :: DummyOtherState = 0.0_R4Ki      !< Remove this variable if you have  states [-]
  END TYPE AA_OtherStateType
! =======================
! =========  AA_MiscVarType  =======
  TYPE, PUBLIC :: AA_MiscVarType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AllOuts      !< An array holding the value of all of the calculated (not only selected) output channels [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: ChordAngleTE      !< C [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: SpanAngleTE      !< C [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: ChordAngleLE      !< C [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: SpanAngleLE      !< C [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: rTEtoObserve      !< C [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: rLEtoObserve      !< C [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: LE_Location      !< Height of Leading Edge for calculation of TI and Scales if needed [-]
    REAL(ReKi)  :: RotSpeedAoA = 0.0_ReKi      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLLBL      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLP      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLS      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLALPH      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLTBL      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLTIP      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLTI      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLTIGui      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: SPLBLUNT      !< C [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: CfVar      !< Output Skin friction coef Pressure Side [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: d99Var      !< BL Output  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: dStarVar      !< BL Output  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: EdgeVelVar      !< BL Output  [-]
    INTEGER(IntKi)  :: speccou = 0_IntKi      !< Secptrum counter every XX seconds new spectrum [-]
    INTEGER(IntKi)  :: filesopen = 0_IntKi      !< check if file is open [-]
  END TYPE AA_MiscVarType
! =======================
! =========  AA_ParameterType  =======
  TYPE, PUBLIC :: AA_ParameterType
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for continuous state integration & discrete state update [seconds]
    INTEGER(IntKi)  :: IBLUNT = 0_IntKi      !< Bluntness noise model [-]
    INTEGER(IntKi)  :: ILAM = 0_IntKi      !< LBL noise model  [-]
    INTEGER(IntKi)  :: ITIP = 0_IntKi      !< Tip noise model [-]
    INTEGER(IntKi)  :: ITRIP = 0_IntKi      !< Trip boundary layer [-]
    INTEGER(IntKi)  :: ITURB = 0_IntKi      !< Tblte noise model [-]
    INTEGER(IntKi)  :: IInflow = 0_IntKi      !< Turbulent inflow noise model [-]
    INTEGER(IntKi)  :: X_BLMethod = 0_IntKi      !< Integer describing calculation method for boundary layer properties,  = 1 BPM = 2 Pretabulated [-]
    INTEGER(IntKi)  :: TICalcMeth = 0_IntKi      !<  [-]
    LOGICAL  :: ROUND = .false.      !< Logical indicating rounded tip [-]
    REAL(ReKi)  :: ALPRAT = 0.0_ReKi      !< TIP LIFT CURVE SLOPE [-]
    INTEGER(IntKi)  :: NumBlades = 0_IntKi      !< Number of blades on the turbine [-]
    INTEGER(IntKi)  :: NumBlNds = 0_IntKi      !< Number of nodes on each blade [-]
    REAL(ReKi)  :: AirDens = 0.0_ReKi      !< Air density [kg/m^3]
    REAL(ReKi)  :: KinVisc = 0.0_ReKi      !< Kinematic air viscosity [m^2/s]
    REAL(ReKi)  :: SpdSound = 0.0_ReKi      !< Speed of sound [m/s]
    REAL(ReKi)  :: HubHeight = 0.0_ReKi      !< Hub height [m]
    REAL(ReKi)  :: toptip = 0.0_ReKi      !< Top Tip Height = Hub height plus radius [m]
    REAL(ReKi)  :: bottip = 0.0_ReKi      !< Bottom Tip Height = Hub height minus radius [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rotorregionlimitsVert      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rotorregionlimitsHorz      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rotorregionlimitsalph      !<  [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: rotorregionlimitsrad      !<  [-]
    INTEGER(IntKi)  :: NrObsLoc = 0_IntKi      !< Number of observer locations  [-]
    LOGICAL  :: aweightflag = .false.      !<   [-]
    LOGICAL  :: TxtFileOutput = .false.      !<   [-]
    REAL(DbKi)  :: AAStart = 0.0_R8Ki      !< Time after which to calculate AA [s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ObsX      !< Observer location in tower-base coordinate X horizontal [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ObsY      !< Observer location in tower-base coordinate Y lateral [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ObsZ      !< Observer location in tower-base coordinate Z vertical [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: FreqList      !< List of Acoustic Frequencies to Calculate [Hz]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: Aweight      !< List of Acoustic Frequencies a weighting [dB]
    REAL(ReKi)  :: Fsample = 0.0_ReKi      !< Sampling Frequency 1/delta(t) - 1/(simulation time step) [Hz]
    INTEGER(IntKi)  :: total_sample = 0_IntKi      !< Total FFT Sample amount for dissipation calculation [-]
    INTEGER(IntKi)  :: total_sampleTI = 0_IntKi      !< Total FFT Sample amount for dissipation calculation [-]
    INTEGER(IntKi)  :: AA_Bl_Prcntge = 0_IntKi      !< The Percentage of the Blade which the noise is calculated [%]
    INTEGER(IntKi)  :: startnode = 0_IntKi      !< Corersponding node to the noise calculation percentage of the blade [-]
    REAL(ReKi)  :: Lturb = 0.0_ReKi      !< Turbulent lengthscale in Amiet model [m]
    REAL(ReKi)  :: avgV = 0.0_ReKi      !< Average wind speed to compute incident turbulence intensity [m]
    REAL(ReKi)  :: TI = 0.0_ReKi      !< Rotor incident turbulent intensity [-]
    CHARACTER(1024)  :: FTitle      !< File Title: the 2nd line of the input file, which contains a description of its contents [-]
    character(20)  :: outFmt      !< Format specifier [-]
    INTEGER(IntKi)  :: NrOutFile = 0_IntKi      !< Nr of output files [-]
    character(1)  :: delim      !< column delimiter [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    INTEGER(IntKi)  :: NumOutsForPE = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    INTEGER(IntKi)  :: NumOutsForSep = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    INTEGER(IntKi)  :: NumOutsForNodes = 0_IntKi      !< Number of parameters in the output list (number of outputs requested) [-]
    INTEGER(IntKi)  :: unOutFile = 0_IntKi      !< unit number for writing output file [-]
    INTEGER(IntKi)  :: unOutFile2 = 0_IntKi      !< unit number for writing output file [-]
    INTEGER(IntKi)  :: unOutFile3 = 0_IntKi      !< unit number for writing output file [-]
    INTEGER(IntKi)  :: unOutFile4 = 0_IntKi      !< unit number for writing output file [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: StallStart      !< ation [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TEThick      !< ation [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: TEAngle      !< ation [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AerCent      !< ation [-]
    INTEGER(IntKi) , DIMENSION(:,:), ALLOCATABLE  :: BlAFID      !< Index of airfoil data file for blade node location [array of numBladeNodes by numBlades] [-]
    TYPE(AFI_ParameterType) , DIMENSION(:), ALLOCATABLE  :: AFInfo      !< Airfoil information structure containing the aerodynamic center and airfoil shape coordinates [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AFLECo      !< Dimensionalized  [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AFTECo 
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlSpn      !< Span at blade node [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: BlChord      !< Chord at blade node [m]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: ReListBL      !< BL list of Reynolds [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AOAListBL      !< BL list of Angle Of Attack  [deg]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: dStarAll1      !< Output Disp Thickness Suction Side [m]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: dStarAll2      !< Output Disp Thickness Pressure Side [m]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: d99All1      !< Output B.L. Thickness Suction Side [m]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: d99All2      !< Output B.L. Thickness Pressure Side [m]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: CfAll1      !< Output Skin friction coef Suction Side [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: CfAll2      !< Output Skin friction coef Pressure Side [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: EdgeVelRat1      !< Output Edge Velocity Ratio Suction [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: EdgeVelRat2      !< Output Edge Velocity Ratio Pressure Side [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AFThickGuida      !< 1 and 10 percent thickness t/c used for Simplified Guidati [-]
  END TYPE AA_ParameterType
! =======================
! =========  AA_InputType  =======
  TYPE, PUBLIC :: AA_InputType
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: RotGtoL      !< 3x3 rotation matrix transform a vector from the local airfoil coordinate system to the global inertial coordinate system [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: AeroCent_G      !< location in global coordinates of the blade element aerodynamic center.  1st index = vector components, 2nd index = blade node, 3rd index = blade [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: Vrel      !< Vrel [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AoANoise      !< Angle of attack [-]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: Inflow      !< atmospheric undisturbed flow on blade [-]
  END TYPE AA_InputType
! =======================
! =========  AA_OutputType  =======
  TYPE, PUBLIC :: AA_OutputType
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: SumSpecNoise      !< Spectra of summed noise level of each blade and blade nodes for each receiver and frequency [SPL]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: SumSpecNoiseSep      !< Spectra of summed noise level of all blades and blade nodes for each receiver and frequency [SPL]
    REAL(ReKi) , DIMENSION(:,:,:), ALLOCATABLE  :: OASPL      !< summed noise level for each blade and blade nodes and receiver  [SPL]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: OASPL_Mech      !< 5 different mechanism noise level for each blade and blade nodes and receiver  [SPL]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: DirectiviOutput      !<   [SPL]
    REAL(ReKi) , DIMENSION(:,:,:,:), ALLOCATABLE  :: OutLECoords      !<   [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: PtotalFreq      !< SPL for each observer and frequency [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutputForPE      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutputSep      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutputNode      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
  END TYPE AA_OutputType
! =======================
CONTAINS

subroutine AA_CopyBladePropsType(SrcBladePropsTypeData, DstBladePropsTypeData, CtrlCode, ErrStat, ErrMsg)
   type(AA_BladePropsType), intent(in) :: SrcBladePropsTypeData
   type(AA_BladePropsType), intent(inout) :: DstBladePropsTypeData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AA_CopyBladePropsType'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstBladePropsTypeData%TEThick = SrcBladePropsTypeData%TEThick
   DstBladePropsTypeData%TEAngle = SrcBladePropsTypeData%TEAngle
end subroutine

subroutine AA_DestroyBladePropsType(BladePropsTypeData, ErrStat, ErrMsg)
   type(AA_BladePropsType), intent(inout) :: BladePropsTypeData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AA_DestroyBladePropsType'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AA_PackBladePropsType(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AA_BladePropsType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AA_PackBladePropsType'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%TEThick)
   call RegPack(RF, InData%TEAngle)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_UnPackBladePropsType(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AA_BladePropsType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AA_UnPackBladePropsType'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%TEThick); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TEAngle); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(AA_InitInputType), intent(in) :: SrcInitInputData
   type(AA_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AA_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%NumBlades = SrcInitInputData%NumBlades
   DstInitInputData%NumBlNds = SrcInitInputData%NumBlNds
   DstInitInputData%RootName = SrcInitInputData%RootName
   if (allocated(SrcInitInputData%BlSpn)) then
      LB(1:2) = lbound(SrcInitInputData%BlSpn)
      UB(1:2) = ubound(SrcInitInputData%BlSpn)
      if (.not. allocated(DstInitInputData%BlSpn)) then
         allocate(DstInitInputData%BlSpn(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BlSpn.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%BlSpn = SrcInitInputData%BlSpn
   end if
   if (allocated(SrcInitInputData%BlChord)) then
      LB(1:2) = lbound(SrcInitInputData%BlChord)
      UB(1:2) = ubound(SrcInitInputData%BlChord)
      if (.not. allocated(DstInitInputData%BlChord)) then
         allocate(DstInitInputData%BlChord(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BlChord.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%BlChord = SrcInitInputData%BlChord
   end if
   DstInitInputData%AirDens = SrcInitInputData%AirDens
   DstInitInputData%KinVisc = SrcInitInputData%KinVisc
   DstInitInputData%SpdSound = SrcInitInputData%SpdSound
   DstInitInputData%HubHeight = SrcInitInputData%HubHeight
   if (allocated(SrcInitInputData%BlAFID)) then
      LB(1:2) = lbound(SrcInitInputData%BlAFID)
      UB(1:2) = ubound(SrcInitInputData%BlAFID)
      if (.not. allocated(DstInitInputData%BlAFID)) then
         allocate(DstInitInputData%BlAFID(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%BlAFID.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitInputData%BlAFID = SrcInitInputData%BlAFID
   end if
   if (allocated(SrcInitInputData%AFInfo)) then
      LB(1:1) = lbound(SrcInitInputData%AFInfo)
      UB(1:1) = ubound(SrcInitInputData%AFInfo)
      if (.not. allocated(DstInitInputData%AFInfo)) then
         allocate(DstInitInputData%AFInfo(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitInputData%AFInfo.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AFI_CopyParam(SrcInitInputData%AFInfo(i1), DstInitInputData%AFInfo(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine AA_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(AA_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AA_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitInputData%BlSpn)) then
      deallocate(InitInputData%BlSpn)
   end if
   if (allocated(InitInputData%BlChord)) then
      deallocate(InitInputData%BlChord)
   end if
   if (allocated(InitInputData%BlAFID)) then
      deallocate(InitInputData%BlAFID)
   end if
   if (allocated(InitInputData%AFInfo)) then
      LB(1:1) = lbound(InitInputData%AFInfo)
      UB(1:1) = ubound(InitInputData%AFInfo)
      do i1 = LB(1), UB(1)
         call AFI_DestroyParam(InitInputData%AFInfo(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InitInputData%AFInfo)
   end if
end subroutine

subroutine AA_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AA_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AA_PackInitInput'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%NumBlades)
   call RegPack(RF, InData%NumBlNds)
   call RegPack(RF, InData%RootName)
   call RegPackAlloc(RF, InData%BlSpn)
   call RegPackAlloc(RF, InData%BlChord)
   call RegPack(RF, InData%AirDens)
   call RegPack(RF, InData%KinVisc)
   call RegPack(RF, InData%SpdSound)
   call RegPack(RF, InData%HubHeight)
   call RegPackAlloc(RF, InData%BlAFID)
   call RegPack(RF, allocated(InData%AFInfo))
   if (allocated(InData%AFInfo)) then
      call RegPackBounds(RF, 1, lbound(InData%AFInfo), ubound(InData%AFInfo))
      LB(1:1) = lbound(InData%AFInfo)
      UB(1:1) = ubound(InData%AFInfo)
      do i1 = LB(1), UB(1)
         call AFI_PackParam(RF, InData%AFInfo(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AA_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AA_UnPackInitInput'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBlNds); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlSpn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlChord); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AirDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%KinVisc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SpdSound); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubHeight); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlAFID); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%AFInfo)) deallocate(OutData%AFInfo)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%AFInfo(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%AFInfo.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AFI_UnpackParam(RF, OutData%AFInfo(i1)) ! AFInfo 
      end do
   end if
end subroutine

subroutine AA_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(AA_InitOutputType), intent(in) :: SrcInitOutputData
   type(AA_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AA_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   if (allocated(SrcInitOutputData%WriteOutputHdrforPE)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdrforPE)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdrforPE)
      if (.not. allocated(DstInitOutputData%WriteOutputHdrforPE)) then
         allocate(DstInitOutputData%WriteOutputHdrforPE(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdrforPE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdrforPE = SrcInitOutputData%WriteOutputHdrforPE
   end if
   if (allocated(SrcInitOutputData%WriteOutputUntforPE)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUntforPE)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUntforPE)
      if (.not. allocated(DstInitOutputData%WriteOutputUntforPE)) then
         allocate(DstInitOutputData%WriteOutputUntforPE(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUntforPE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUntforPE = SrcInitOutputData%WriteOutputUntforPE
   end if
   if (allocated(SrcInitOutputData%WriteOutputHdrSep)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdrSep)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdrSep)
      if (.not. allocated(DstInitOutputData%WriteOutputHdrSep)) then
         allocate(DstInitOutputData%WriteOutputHdrSep(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdrSep.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdrSep = SrcInitOutputData%WriteOutputHdrSep
   end if
   if (allocated(SrcInitOutputData%WriteOutputUntSep)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUntSep)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUntSep)
      if (.not. allocated(DstInitOutputData%WriteOutputUntSep)) then
         allocate(DstInitOutputData%WriteOutputUntSep(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUntSep.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUntSep = SrcInitOutputData%WriteOutputUntSep
   end if
   if (allocated(SrcInitOutputData%WriteOutputHdrNodes)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdrNodes)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdrNodes)
      if (.not. allocated(DstInitOutputData%WriteOutputHdrNodes)) then
         allocate(DstInitOutputData%WriteOutputHdrNodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdrNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdrNodes = SrcInitOutputData%WriteOutputHdrNodes
   end if
   if (allocated(SrcInitOutputData%WriteOutputUntNodes)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUntNodes)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUntNodes)
      if (.not. allocated(DstInitOutputData%WriteOutputUntNodes)) then
         allocate(DstInitOutputData%WriteOutputUntNodes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUntNodes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUntNodes = SrcInitOutputData%WriteOutputUntNodes
   end if
   DstInitOutputData%delim = SrcInitOutputData%delim
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitOutputData%AirDens = SrcInitOutputData%AirDens
end subroutine

subroutine AA_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(AA_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AA_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   if (allocated(InitOutputData%WriteOutputHdrforPE)) then
      deallocate(InitOutputData%WriteOutputHdrforPE)
   end if
   if (allocated(InitOutputData%WriteOutputUntforPE)) then
      deallocate(InitOutputData%WriteOutputUntforPE)
   end if
   if (allocated(InitOutputData%WriteOutputHdrSep)) then
      deallocate(InitOutputData%WriteOutputHdrSep)
   end if
   if (allocated(InitOutputData%WriteOutputUntSep)) then
      deallocate(InitOutputData%WriteOutputUntSep)
   end if
   if (allocated(InitOutputData%WriteOutputHdrNodes)) then
      deallocate(InitOutputData%WriteOutputHdrNodes)
   end if
   if (allocated(InitOutputData%WriteOutputUntNodes)) then
      deallocate(InitOutputData%WriteOutputUntNodes)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine AA_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AA_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AA_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call RegPackAlloc(RF, InData%WriteOutputHdrforPE)
   call RegPackAlloc(RF, InData%WriteOutputUntforPE)
   call RegPackAlloc(RF, InData%WriteOutputHdrSep)
   call RegPackAlloc(RF, InData%WriteOutputUntSep)
   call RegPackAlloc(RF, InData%WriteOutputHdrNodes)
   call RegPackAlloc(RF, InData%WriteOutputUntNodes)
   call RegPack(RF, InData%delim)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPack(RF, InData%AirDens)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AA_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AA_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdrforPE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUntforPE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdrSep); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUntSep); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdrNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUntNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%delim); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpack(RF, OutData%AirDens); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(AA_InputFile), intent(in) :: SrcInputFileData
   type(AA_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AA_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%DT_AA = SrcInputFileData%DT_AA
   DstInputFileData%IBLUNT = SrcInputFileData%IBLUNT
   DstInputFileData%ILAM = SrcInputFileData%ILAM
   DstInputFileData%ITIP = SrcInputFileData%ITIP
   DstInputFileData%ITRIP = SrcInputFileData%ITRIP
   DstInputFileData%ITURB = SrcInputFileData%ITURB
   DstInputFileData%IInflow = SrcInputFileData%IInflow
   DstInputFileData%X_BLMethod = SrcInputFileData%X_BLMethod
   DstInputFileData%TICalcMeth = SrcInputFileData%TICalcMeth
   DstInputFileData%NReListBL = SrcInputFileData%NReListBL
   DstInputFileData%aweightflag = SrcInputFileData%aweightflag
   DstInputFileData%ROUND = SrcInputFileData%ROUND
   DstInputFileData%ALPRAT = SrcInputFileData%ALPRAT
   DstInputFileData%AA_Bl_Prcntge = SrcInputFileData%AA_Bl_Prcntge
   DstInputFileData%NrObsLoc = SrcInputFileData%NrObsLoc
   if (allocated(SrcInputFileData%ObsX)) then
      LB(1:1) = lbound(SrcInputFileData%ObsX)
      UB(1:1) = ubound(SrcInputFileData%ObsX)
      if (.not. allocated(DstInputFileData%ObsX)) then
         allocate(DstInputFileData%ObsX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%ObsX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%ObsX = SrcInputFileData%ObsX
   end if
   if (allocated(SrcInputFileData%ObsY)) then
      LB(1:1) = lbound(SrcInputFileData%ObsY)
      UB(1:1) = ubound(SrcInputFileData%ObsY)
      if (.not. allocated(DstInputFileData%ObsY)) then
         allocate(DstInputFileData%ObsY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%ObsY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%ObsY = SrcInputFileData%ObsY
   end if
   if (allocated(SrcInputFileData%ObsZ)) then
      LB(1:1) = lbound(SrcInputFileData%ObsZ)
      UB(1:1) = ubound(SrcInputFileData%ObsZ)
      if (.not. allocated(DstInputFileData%ObsZ)) then
         allocate(DstInputFileData%ObsZ(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%ObsZ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%ObsZ = SrcInputFileData%ObsZ
   end if
   if (allocated(SrcInputFileData%BladeProps)) then
      LB(1:1) = lbound(SrcInputFileData%BladeProps)
      UB(1:1) = ubound(SrcInputFileData%BladeProps)
      if (.not. allocated(DstInputFileData%BladeProps)) then
         allocate(DstInputFileData%BladeProps(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%BladeProps.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AA_CopyBladePropsType(SrcInputFileData%BladeProps(i1), DstInputFileData%BladeProps(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstInputFileData%NrOutFile = SrcInputFileData%NrOutFile
   if (allocated(SrcInputFileData%AAoutfile)) then
      LB(1:1) = lbound(SrcInputFileData%AAoutfile)
      UB(1:1) = ubound(SrcInputFileData%AAoutfile)
      if (.not. allocated(DstInputFileData%AAoutfile)) then
         allocate(DstInputFileData%AAoutfile(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%AAoutfile.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%AAoutfile = SrcInputFileData%AAoutfile
   end if
   DstInputFileData%FTitle = SrcInputFileData%FTitle
   DstInputFileData%AAStart = SrcInputFileData%AAStart
   DstInputFileData%TI = SrcInputFileData%TI
   DstInputFileData%avgV = SrcInputFileData%avgV
   DstInputFileData%Lturb = SrcInputFileData%Lturb
   if (allocated(SrcInputFileData%ReListBL)) then
      LB(1:1) = lbound(SrcInputFileData%ReListBL)
      UB(1:1) = ubound(SrcInputFileData%ReListBL)
      if (.not. allocated(DstInputFileData%ReListBL)) then
         allocate(DstInputFileData%ReListBL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%ReListBL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%ReListBL = SrcInputFileData%ReListBL
   end if
   if (allocated(SrcInputFileData%AoAListBL)) then
      LB(1:1) = lbound(SrcInputFileData%AoAListBL)
      UB(1:1) = ubound(SrcInputFileData%AoAListBL)
      if (.not. allocated(DstInputFileData%AoAListBL)) then
         allocate(DstInputFileData%AoAListBL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%AoAListBL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%AoAListBL = SrcInputFileData%AoAListBL
   end if
   if (allocated(SrcInputFileData%Pres_DispThick)) then
      LB(1:3) = lbound(SrcInputFileData%Pres_DispThick)
      UB(1:3) = ubound(SrcInputFileData%Pres_DispThick)
      if (.not. allocated(DstInputFileData%Pres_DispThick)) then
         allocate(DstInputFileData%Pres_DispThick(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Pres_DispThick.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%Pres_DispThick = SrcInputFileData%Pres_DispThick
   end if
   if (allocated(SrcInputFileData%Suct_DispThick)) then
      LB(1:3) = lbound(SrcInputFileData%Suct_DispThick)
      UB(1:3) = ubound(SrcInputFileData%Suct_DispThick)
      if (.not. allocated(DstInputFileData%Suct_DispThick)) then
         allocate(DstInputFileData%Suct_DispThick(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Suct_DispThick.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%Suct_DispThick = SrcInputFileData%Suct_DispThick
   end if
   if (allocated(SrcInputFileData%Pres_BLThick)) then
      LB(1:3) = lbound(SrcInputFileData%Pres_BLThick)
      UB(1:3) = ubound(SrcInputFileData%Pres_BLThick)
      if (.not. allocated(DstInputFileData%Pres_BLThick)) then
         allocate(DstInputFileData%Pres_BLThick(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Pres_BLThick.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%Pres_BLThick = SrcInputFileData%Pres_BLThick
   end if
   if (allocated(SrcInputFileData%Suct_BLThick)) then
      LB(1:3) = lbound(SrcInputFileData%Suct_BLThick)
      UB(1:3) = ubound(SrcInputFileData%Suct_BLThick)
      if (.not. allocated(DstInputFileData%Suct_BLThick)) then
         allocate(DstInputFileData%Suct_BLThick(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Suct_BLThick.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%Suct_BLThick = SrcInputFileData%Suct_BLThick
   end if
   if (allocated(SrcInputFileData%Pres_Cf)) then
      LB(1:3) = lbound(SrcInputFileData%Pres_Cf)
      UB(1:3) = ubound(SrcInputFileData%Pres_Cf)
      if (.not. allocated(DstInputFileData%Pres_Cf)) then
         allocate(DstInputFileData%Pres_Cf(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Pres_Cf.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%Pres_Cf = SrcInputFileData%Pres_Cf
   end if
   if (allocated(SrcInputFileData%Suct_Cf)) then
      LB(1:3) = lbound(SrcInputFileData%Suct_Cf)
      UB(1:3) = ubound(SrcInputFileData%Suct_Cf)
      if (.not. allocated(DstInputFileData%Suct_Cf)) then
         allocate(DstInputFileData%Suct_Cf(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Suct_Cf.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%Suct_Cf = SrcInputFileData%Suct_Cf
   end if
   if (allocated(SrcInputFileData%Pres_EdgeVelRat)) then
      LB(1:3) = lbound(SrcInputFileData%Pres_EdgeVelRat)
      UB(1:3) = ubound(SrcInputFileData%Pres_EdgeVelRat)
      if (.not. allocated(DstInputFileData%Pres_EdgeVelRat)) then
         allocate(DstInputFileData%Pres_EdgeVelRat(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Pres_EdgeVelRat.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%Pres_EdgeVelRat = SrcInputFileData%Pres_EdgeVelRat
   end if
   if (allocated(SrcInputFileData%Suct_EdgeVelRat)) then
      LB(1:3) = lbound(SrcInputFileData%Suct_EdgeVelRat)
      UB(1:3) = ubound(SrcInputFileData%Suct_EdgeVelRat)
      if (.not. allocated(DstInputFileData%Suct_EdgeVelRat)) then
         allocate(DstInputFileData%Suct_EdgeVelRat(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%Suct_EdgeVelRat.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%Suct_EdgeVelRat = SrcInputFileData%Suct_EdgeVelRat
   end if
end subroutine

subroutine AA_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(AA_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AA_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputFileData%ObsX)) then
      deallocate(InputFileData%ObsX)
   end if
   if (allocated(InputFileData%ObsY)) then
      deallocate(InputFileData%ObsY)
   end if
   if (allocated(InputFileData%ObsZ)) then
      deallocate(InputFileData%ObsZ)
   end if
   if (allocated(InputFileData%BladeProps)) then
      LB(1:1) = lbound(InputFileData%BladeProps)
      UB(1:1) = ubound(InputFileData%BladeProps)
      do i1 = LB(1), UB(1)
         call AA_DestroyBladePropsType(InputFileData%BladeProps(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(InputFileData%BladeProps)
   end if
   if (allocated(InputFileData%AAoutfile)) then
      deallocate(InputFileData%AAoutfile)
   end if
   if (allocated(InputFileData%ReListBL)) then
      deallocate(InputFileData%ReListBL)
   end if
   if (allocated(InputFileData%AoAListBL)) then
      deallocate(InputFileData%AoAListBL)
   end if
   if (allocated(InputFileData%Pres_DispThick)) then
      deallocate(InputFileData%Pres_DispThick)
   end if
   if (allocated(InputFileData%Suct_DispThick)) then
      deallocate(InputFileData%Suct_DispThick)
   end if
   if (allocated(InputFileData%Pres_BLThick)) then
      deallocate(InputFileData%Pres_BLThick)
   end if
   if (allocated(InputFileData%Suct_BLThick)) then
      deallocate(InputFileData%Suct_BLThick)
   end if
   if (allocated(InputFileData%Pres_Cf)) then
      deallocate(InputFileData%Pres_Cf)
   end if
   if (allocated(InputFileData%Suct_Cf)) then
      deallocate(InputFileData%Suct_Cf)
   end if
   if (allocated(InputFileData%Pres_EdgeVelRat)) then
      deallocate(InputFileData%Pres_EdgeVelRat)
   end if
   if (allocated(InputFileData%Suct_EdgeVelRat)) then
      deallocate(InputFileData%Suct_EdgeVelRat)
   end if
end subroutine

subroutine AA_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AA_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AA_PackInputFile'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT_AA)
   call RegPack(RF, InData%IBLUNT)
   call RegPack(RF, InData%ILAM)
   call RegPack(RF, InData%ITIP)
   call RegPack(RF, InData%ITRIP)
   call RegPack(RF, InData%ITURB)
   call RegPack(RF, InData%IInflow)
   call RegPack(RF, InData%X_BLMethod)
   call RegPack(RF, InData%TICalcMeth)
   call RegPack(RF, InData%NReListBL)
   call RegPack(RF, InData%aweightflag)
   call RegPack(RF, InData%ROUND)
   call RegPack(RF, InData%ALPRAT)
   call RegPack(RF, InData%AA_Bl_Prcntge)
   call RegPack(RF, InData%NrObsLoc)
   call RegPackAlloc(RF, InData%ObsX)
   call RegPackAlloc(RF, InData%ObsY)
   call RegPackAlloc(RF, InData%ObsZ)
   call RegPack(RF, allocated(InData%BladeProps))
   if (allocated(InData%BladeProps)) then
      call RegPackBounds(RF, 1, lbound(InData%BladeProps), ubound(InData%BladeProps))
      LB(1:1) = lbound(InData%BladeProps)
      UB(1:1) = ubound(InData%BladeProps)
      do i1 = LB(1), UB(1)
         call AA_PackBladePropsType(RF, InData%BladeProps(i1)) 
      end do
   end if
   call RegPack(RF, InData%NrOutFile)
   call RegPackAlloc(RF, InData%AAoutfile)
   call RegPack(RF, InData%FTitle)
   call RegPack(RF, InData%AAStart)
   call RegPack(RF, InData%TI)
   call RegPack(RF, InData%avgV)
   call RegPack(RF, InData%Lturb)
   call RegPackAlloc(RF, InData%ReListBL)
   call RegPackAlloc(RF, InData%AoAListBL)
   call RegPackAlloc(RF, InData%Pres_DispThick)
   call RegPackAlloc(RF, InData%Suct_DispThick)
   call RegPackAlloc(RF, InData%Pres_BLThick)
   call RegPackAlloc(RF, InData%Suct_BLThick)
   call RegPackAlloc(RF, InData%Pres_Cf)
   call RegPackAlloc(RF, InData%Suct_Cf)
   call RegPackAlloc(RF, InData%Pres_EdgeVelRat)
   call RegPackAlloc(RF, InData%Suct_EdgeVelRat)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AA_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AA_UnPackInputFile'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT_AA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IBLUNT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ILAM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ITIP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ITRIP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ITURB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IInflow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%X_BLMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TICalcMeth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NReListBL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%aweightflag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ROUND); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ALPRAT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AA_Bl_Prcntge); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NrObsLoc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ObsX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ObsY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ObsZ); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%BladeProps)) deallocate(OutData%BladeProps)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%BladeProps(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%BladeProps.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AA_UnpackBladePropsType(RF, OutData%BladeProps(i1)) ! BladeProps 
      end do
   end if
   call RegUnpack(RF, OutData%NrOutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AAoutfile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FTitle); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AAStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%avgV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Lturb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ReListBL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AoAListBL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Pres_DispThick); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Suct_DispThick); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Pres_BLThick); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Suct_BLThick); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Pres_Cf); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Suct_Cf); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Pres_EdgeVelRat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Suct_EdgeVelRat); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(AA_ContinuousStateType), intent(in) :: SrcContStateData
   type(AA_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AA_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstContStateData%DummyContState = SrcContStateData%DummyContState
end subroutine

subroutine AA_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(AA_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AA_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AA_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AA_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AA_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyContState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AA_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AA_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyContState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(AA_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(AA_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AA_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcDiscStateData%MeanVrel)) then
      LB(1:2) = lbound(SrcDiscStateData%MeanVrel)
      UB(1:2) = ubound(SrcDiscStateData%MeanVrel)
      if (.not. allocated(DstDiscStateData%MeanVrel)) then
         allocate(DstDiscStateData%MeanVrel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%MeanVrel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%MeanVrel = SrcDiscStateData%MeanVrel
   end if
   if (allocated(SrcDiscStateData%VrelSq)) then
      LB(1:2) = lbound(SrcDiscStateData%VrelSq)
      UB(1:2) = ubound(SrcDiscStateData%VrelSq)
      if (.not. allocated(DstDiscStateData%VrelSq)) then
         allocate(DstDiscStateData%VrelSq(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%VrelSq.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%VrelSq = SrcDiscStateData%VrelSq
   end if
   if (allocated(SrcDiscStateData%TIVrel)) then
      LB(1:2) = lbound(SrcDiscStateData%TIVrel)
      UB(1:2) = ubound(SrcDiscStateData%TIVrel)
      if (.not. allocated(DstDiscStateData%TIVrel)) then
         allocate(DstDiscStateData%TIVrel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%TIVrel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%TIVrel = SrcDiscStateData%TIVrel
   end if
   if (allocated(SrcDiscStateData%VrelStore)) then
      LB(1:3) = lbound(SrcDiscStateData%VrelStore)
      UB(1:3) = ubound(SrcDiscStateData%VrelStore)
      if (.not. allocated(DstDiscStateData%VrelStore)) then
         allocate(DstDiscStateData%VrelStore(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%VrelStore.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%VrelStore = SrcDiscStateData%VrelStore
   end if
   if (allocated(SrcDiscStateData%TIVx)) then
      LB(1:2) = lbound(SrcDiscStateData%TIVx)
      UB(1:2) = ubound(SrcDiscStateData%TIVx)
      if (.not. allocated(DstDiscStateData%TIVx)) then
         allocate(DstDiscStateData%TIVx(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%TIVx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%TIVx = SrcDiscStateData%TIVx
   end if
   if (allocated(SrcDiscStateData%MeanVxVyVz)) then
      LB(1:2) = lbound(SrcDiscStateData%MeanVxVyVz)
      UB(1:2) = ubound(SrcDiscStateData%MeanVxVyVz)
      if (.not. allocated(DstDiscStateData%MeanVxVyVz)) then
         allocate(DstDiscStateData%MeanVxVyVz(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%MeanVxVyVz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%MeanVxVyVz = SrcDiscStateData%MeanVxVyVz
   end if
   if (allocated(SrcDiscStateData%VxSq)) then
      LB(1:2) = lbound(SrcDiscStateData%VxSq)
      UB(1:2) = ubound(SrcDiscStateData%VxSq)
      if (.not. allocated(DstDiscStateData%VxSq)) then
         allocate(DstDiscStateData%VxSq(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%VxSq.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%VxSq = SrcDiscStateData%VxSq
   end if
   if (allocated(SrcDiscStateData%allregcounter)) then
      LB(1:2) = lbound(SrcDiscStateData%allregcounter)
      UB(1:2) = ubound(SrcDiscStateData%allregcounter)
      if (.not. allocated(DstDiscStateData%allregcounter)) then
         allocate(DstDiscStateData%allregcounter(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%allregcounter.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%allregcounter = SrcDiscStateData%allregcounter
   end if
   if (allocated(SrcDiscStateData%VxSqRegion)) then
      LB(1:2) = lbound(SrcDiscStateData%VxSqRegion)
      UB(1:2) = ubound(SrcDiscStateData%VxSqRegion)
      if (.not. allocated(DstDiscStateData%VxSqRegion)) then
         allocate(DstDiscStateData%VxSqRegion(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%VxSqRegion.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%VxSqRegion = SrcDiscStateData%VxSqRegion
   end if
   if (allocated(SrcDiscStateData%RegVxStor)) then
      LB(1:3) = lbound(SrcDiscStateData%RegVxStor)
      UB(1:3) = ubound(SrcDiscStateData%RegVxStor)
      if (.not. allocated(DstDiscStateData%RegVxStor)) then
         allocate(DstDiscStateData%RegVxStor(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%RegVxStor.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%RegVxStor = SrcDiscStateData%RegVxStor
   end if
   if (allocated(SrcDiscStateData%RegionTIDelete)) then
      LB(1:2) = lbound(SrcDiscStateData%RegionTIDelete)
      UB(1:2) = ubound(SrcDiscStateData%RegionTIDelete)
      if (.not. allocated(DstDiscStateData%RegionTIDelete)) then
         allocate(DstDiscStateData%RegionTIDelete(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstDiscStateData%RegionTIDelete.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstDiscStateData%RegionTIDelete = SrcDiscStateData%RegionTIDelete
   end if
end subroutine

subroutine AA_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(AA_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AA_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(DiscStateData%MeanVrel)) then
      deallocate(DiscStateData%MeanVrel)
   end if
   if (allocated(DiscStateData%VrelSq)) then
      deallocate(DiscStateData%VrelSq)
   end if
   if (allocated(DiscStateData%TIVrel)) then
      deallocate(DiscStateData%TIVrel)
   end if
   if (allocated(DiscStateData%VrelStore)) then
      deallocate(DiscStateData%VrelStore)
   end if
   if (allocated(DiscStateData%TIVx)) then
      deallocate(DiscStateData%TIVx)
   end if
   if (allocated(DiscStateData%MeanVxVyVz)) then
      deallocate(DiscStateData%MeanVxVyVz)
   end if
   if (allocated(DiscStateData%VxSq)) then
      deallocate(DiscStateData%VxSq)
   end if
   if (allocated(DiscStateData%allregcounter)) then
      deallocate(DiscStateData%allregcounter)
   end if
   if (allocated(DiscStateData%VxSqRegion)) then
      deallocate(DiscStateData%VxSqRegion)
   end if
   if (allocated(DiscStateData%RegVxStor)) then
      deallocate(DiscStateData%RegVxStor)
   end if
   if (allocated(DiscStateData%RegionTIDelete)) then
      deallocate(DiscStateData%RegionTIDelete)
   end if
end subroutine

subroutine AA_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AA_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AA_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%MeanVrel)
   call RegPackAlloc(RF, InData%VrelSq)
   call RegPackAlloc(RF, InData%TIVrel)
   call RegPackAlloc(RF, InData%VrelStore)
   call RegPackAlloc(RF, InData%TIVx)
   call RegPackAlloc(RF, InData%MeanVxVyVz)
   call RegPackAlloc(RF, InData%VxSq)
   call RegPackAlloc(RF, InData%allregcounter)
   call RegPackAlloc(RF, InData%VxSqRegion)
   call RegPackAlloc(RF, InData%RegVxStor)
   call RegPackAlloc(RF, InData%RegionTIDelete)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AA_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AA_UnPackDiscState'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%MeanVrel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VrelSq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TIVrel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VrelStore); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TIVx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%MeanVxVyVz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VxSq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%allregcounter); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VxSqRegion); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RegVxStor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RegionTIDelete); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(AA_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(AA_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AA_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine AA_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(AA_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AA_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AA_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AA_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AA_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AA_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AA_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(AA_OtherStateType), intent(in) :: SrcOtherStateData
   type(AA_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AA_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%DummyOtherState = SrcOtherStateData%DummyOtherState
end subroutine

subroutine AA_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(AA_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AA_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine AA_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AA_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AA_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyOtherState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AA_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AA_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyOtherState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(AA_MiscVarType), intent(in) :: SrcMiscData
   type(AA_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AA_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%AllOuts)) then
      LB(1:1) = lbound(SrcMiscData%AllOuts)
      UB(1:1) = ubound(SrcMiscData%AllOuts)
      if (.not. allocated(DstMiscData%AllOuts)) then
         allocate(DstMiscData%AllOuts(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AllOuts.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AllOuts = SrcMiscData%AllOuts
   end if
   if (allocated(SrcMiscData%ChordAngleTE)) then
      LB(1:3) = lbound(SrcMiscData%ChordAngleTE)
      UB(1:3) = ubound(SrcMiscData%ChordAngleTE)
      if (.not. allocated(DstMiscData%ChordAngleTE)) then
         allocate(DstMiscData%ChordAngleTE(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ChordAngleTE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%ChordAngleTE = SrcMiscData%ChordAngleTE
   end if
   if (allocated(SrcMiscData%SpanAngleTE)) then
      LB(1:3) = lbound(SrcMiscData%SpanAngleTE)
      UB(1:3) = ubound(SrcMiscData%SpanAngleTE)
      if (.not. allocated(DstMiscData%SpanAngleTE)) then
         allocate(DstMiscData%SpanAngleTE(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SpanAngleTE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%SpanAngleTE = SrcMiscData%SpanAngleTE
   end if
   if (allocated(SrcMiscData%ChordAngleLE)) then
      LB(1:3) = lbound(SrcMiscData%ChordAngleLE)
      UB(1:3) = ubound(SrcMiscData%ChordAngleLE)
      if (.not. allocated(DstMiscData%ChordAngleLE)) then
         allocate(DstMiscData%ChordAngleLE(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ChordAngleLE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%ChordAngleLE = SrcMiscData%ChordAngleLE
   end if
   if (allocated(SrcMiscData%SpanAngleLE)) then
      LB(1:3) = lbound(SrcMiscData%SpanAngleLE)
      UB(1:3) = ubound(SrcMiscData%SpanAngleLE)
      if (.not. allocated(DstMiscData%SpanAngleLE)) then
         allocate(DstMiscData%SpanAngleLE(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SpanAngleLE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%SpanAngleLE = SrcMiscData%SpanAngleLE
   end if
   if (allocated(SrcMiscData%rTEtoObserve)) then
      LB(1:3) = lbound(SrcMiscData%rTEtoObserve)
      UB(1:3) = ubound(SrcMiscData%rTEtoObserve)
      if (.not. allocated(DstMiscData%rTEtoObserve)) then
         allocate(DstMiscData%rTEtoObserve(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%rTEtoObserve.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%rTEtoObserve = SrcMiscData%rTEtoObserve
   end if
   if (allocated(SrcMiscData%rLEtoObserve)) then
      LB(1:3) = lbound(SrcMiscData%rLEtoObserve)
      UB(1:3) = ubound(SrcMiscData%rLEtoObserve)
      if (.not. allocated(DstMiscData%rLEtoObserve)) then
         allocate(DstMiscData%rLEtoObserve(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%rLEtoObserve.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%rLEtoObserve = SrcMiscData%rLEtoObserve
   end if
   if (allocated(SrcMiscData%LE_Location)) then
      LB(1:3) = lbound(SrcMiscData%LE_Location)
      UB(1:3) = ubound(SrcMiscData%LE_Location)
      if (.not. allocated(DstMiscData%LE_Location)) then
         allocate(DstMiscData%LE_Location(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%LE_Location.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%LE_Location = SrcMiscData%LE_Location
   end if
   DstMiscData%RotSpeedAoA = SrcMiscData%RotSpeedAoA
   if (allocated(SrcMiscData%SPLLBL)) then
      LB(1:1) = lbound(SrcMiscData%SPLLBL)
      UB(1:1) = ubound(SrcMiscData%SPLLBL)
      if (.not. allocated(DstMiscData%SPLLBL)) then
         allocate(DstMiscData%SPLLBL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLLBL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%SPLLBL = SrcMiscData%SPLLBL
   end if
   if (allocated(SrcMiscData%SPLP)) then
      LB(1:1) = lbound(SrcMiscData%SPLP)
      UB(1:1) = ubound(SrcMiscData%SPLP)
      if (.not. allocated(DstMiscData%SPLP)) then
         allocate(DstMiscData%SPLP(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%SPLP = SrcMiscData%SPLP
   end if
   if (allocated(SrcMiscData%SPLS)) then
      LB(1:1) = lbound(SrcMiscData%SPLS)
      UB(1:1) = ubound(SrcMiscData%SPLS)
      if (.not. allocated(DstMiscData%SPLS)) then
         allocate(DstMiscData%SPLS(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLS.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%SPLS = SrcMiscData%SPLS
   end if
   if (allocated(SrcMiscData%SPLALPH)) then
      LB(1:1) = lbound(SrcMiscData%SPLALPH)
      UB(1:1) = ubound(SrcMiscData%SPLALPH)
      if (.not. allocated(DstMiscData%SPLALPH)) then
         allocate(DstMiscData%SPLALPH(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLALPH.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%SPLALPH = SrcMiscData%SPLALPH
   end if
   if (allocated(SrcMiscData%SPLTBL)) then
      LB(1:1) = lbound(SrcMiscData%SPLTBL)
      UB(1:1) = ubound(SrcMiscData%SPLTBL)
      if (.not. allocated(DstMiscData%SPLTBL)) then
         allocate(DstMiscData%SPLTBL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLTBL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%SPLTBL = SrcMiscData%SPLTBL
   end if
   if (allocated(SrcMiscData%SPLTIP)) then
      LB(1:1) = lbound(SrcMiscData%SPLTIP)
      UB(1:1) = ubound(SrcMiscData%SPLTIP)
      if (.not. allocated(DstMiscData%SPLTIP)) then
         allocate(DstMiscData%SPLTIP(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLTIP.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%SPLTIP = SrcMiscData%SPLTIP
   end if
   if (allocated(SrcMiscData%SPLTI)) then
      LB(1:1) = lbound(SrcMiscData%SPLTI)
      UB(1:1) = ubound(SrcMiscData%SPLTI)
      if (.not. allocated(DstMiscData%SPLTI)) then
         allocate(DstMiscData%SPLTI(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLTI.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%SPLTI = SrcMiscData%SPLTI
   end if
   if (allocated(SrcMiscData%SPLTIGui)) then
      LB(1:1) = lbound(SrcMiscData%SPLTIGui)
      UB(1:1) = ubound(SrcMiscData%SPLTIGui)
      if (.not. allocated(DstMiscData%SPLTIGui)) then
         allocate(DstMiscData%SPLTIGui(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLTIGui.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%SPLTIGui = SrcMiscData%SPLTIGui
   end if
   if (allocated(SrcMiscData%SPLBLUNT)) then
      LB(1:1) = lbound(SrcMiscData%SPLBLUNT)
      UB(1:1) = ubound(SrcMiscData%SPLBLUNT)
      if (.not. allocated(DstMiscData%SPLBLUNT)) then
         allocate(DstMiscData%SPLBLUNT(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%SPLBLUNT.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%SPLBLUNT = SrcMiscData%SPLBLUNT
   end if
   if (allocated(SrcMiscData%CfVar)) then
      LB(1:1) = lbound(SrcMiscData%CfVar)
      UB(1:1) = ubound(SrcMiscData%CfVar)
      if (.not. allocated(DstMiscData%CfVar)) then
         allocate(DstMiscData%CfVar(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%CfVar.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%CfVar = SrcMiscData%CfVar
   end if
   if (allocated(SrcMiscData%d99Var)) then
      LB(1:1) = lbound(SrcMiscData%d99Var)
      UB(1:1) = ubound(SrcMiscData%d99Var)
      if (.not. allocated(DstMiscData%d99Var)) then
         allocate(DstMiscData%d99Var(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%d99Var.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%d99Var = SrcMiscData%d99Var
   end if
   if (allocated(SrcMiscData%dStarVar)) then
      LB(1:1) = lbound(SrcMiscData%dStarVar)
      UB(1:1) = ubound(SrcMiscData%dStarVar)
      if (.not. allocated(DstMiscData%dStarVar)) then
         allocate(DstMiscData%dStarVar(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%dStarVar.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%dStarVar = SrcMiscData%dStarVar
   end if
   if (allocated(SrcMiscData%EdgeVelVar)) then
      LB(1:1) = lbound(SrcMiscData%EdgeVelVar)
      UB(1:1) = ubound(SrcMiscData%EdgeVelVar)
      if (.not. allocated(DstMiscData%EdgeVelVar)) then
         allocate(DstMiscData%EdgeVelVar(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%EdgeVelVar.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%EdgeVelVar = SrcMiscData%EdgeVelVar
   end if
   DstMiscData%speccou = SrcMiscData%speccou
   DstMiscData%filesopen = SrcMiscData%filesopen
end subroutine

subroutine AA_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(AA_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AA_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%AllOuts)) then
      deallocate(MiscData%AllOuts)
   end if
   if (allocated(MiscData%ChordAngleTE)) then
      deallocate(MiscData%ChordAngleTE)
   end if
   if (allocated(MiscData%SpanAngleTE)) then
      deallocate(MiscData%SpanAngleTE)
   end if
   if (allocated(MiscData%ChordAngleLE)) then
      deallocate(MiscData%ChordAngleLE)
   end if
   if (allocated(MiscData%SpanAngleLE)) then
      deallocate(MiscData%SpanAngleLE)
   end if
   if (allocated(MiscData%rTEtoObserve)) then
      deallocate(MiscData%rTEtoObserve)
   end if
   if (allocated(MiscData%rLEtoObserve)) then
      deallocate(MiscData%rLEtoObserve)
   end if
   if (allocated(MiscData%LE_Location)) then
      deallocate(MiscData%LE_Location)
   end if
   if (allocated(MiscData%SPLLBL)) then
      deallocate(MiscData%SPLLBL)
   end if
   if (allocated(MiscData%SPLP)) then
      deallocate(MiscData%SPLP)
   end if
   if (allocated(MiscData%SPLS)) then
      deallocate(MiscData%SPLS)
   end if
   if (allocated(MiscData%SPLALPH)) then
      deallocate(MiscData%SPLALPH)
   end if
   if (allocated(MiscData%SPLTBL)) then
      deallocate(MiscData%SPLTBL)
   end if
   if (allocated(MiscData%SPLTIP)) then
      deallocate(MiscData%SPLTIP)
   end if
   if (allocated(MiscData%SPLTI)) then
      deallocate(MiscData%SPLTI)
   end if
   if (allocated(MiscData%SPLTIGui)) then
      deallocate(MiscData%SPLTIGui)
   end if
   if (allocated(MiscData%SPLBLUNT)) then
      deallocate(MiscData%SPLBLUNT)
   end if
   if (allocated(MiscData%CfVar)) then
      deallocate(MiscData%CfVar)
   end if
   if (allocated(MiscData%d99Var)) then
      deallocate(MiscData%d99Var)
   end if
   if (allocated(MiscData%dStarVar)) then
      deallocate(MiscData%dStarVar)
   end if
   if (allocated(MiscData%EdgeVelVar)) then
      deallocate(MiscData%EdgeVelVar)
   end if
end subroutine

subroutine AA_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AA_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AA_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%AllOuts)
   call RegPackAlloc(RF, InData%ChordAngleTE)
   call RegPackAlloc(RF, InData%SpanAngleTE)
   call RegPackAlloc(RF, InData%ChordAngleLE)
   call RegPackAlloc(RF, InData%SpanAngleLE)
   call RegPackAlloc(RF, InData%rTEtoObserve)
   call RegPackAlloc(RF, InData%rLEtoObserve)
   call RegPackAlloc(RF, InData%LE_Location)
   call RegPack(RF, InData%RotSpeedAoA)
   call RegPackAlloc(RF, InData%SPLLBL)
   call RegPackAlloc(RF, InData%SPLP)
   call RegPackAlloc(RF, InData%SPLS)
   call RegPackAlloc(RF, InData%SPLALPH)
   call RegPackAlloc(RF, InData%SPLTBL)
   call RegPackAlloc(RF, InData%SPLTIP)
   call RegPackAlloc(RF, InData%SPLTI)
   call RegPackAlloc(RF, InData%SPLTIGui)
   call RegPackAlloc(RF, InData%SPLBLUNT)
   call RegPackAlloc(RF, InData%CfVar)
   call RegPackAlloc(RF, InData%d99Var)
   call RegPackAlloc(RF, InData%dStarVar)
   call RegPackAlloc(RF, InData%EdgeVelVar)
   call RegPack(RF, InData%speccou)
   call RegPack(RF, InData%filesopen)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AA_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AA_UnPackMisc'
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%AllOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ChordAngleTE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SpanAngleTE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ChordAngleLE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SpanAngleLE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rTEtoObserve); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rLEtoObserve); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%LE_Location); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotSpeedAoA); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SPLLBL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SPLP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SPLS); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SPLALPH); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SPLTBL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SPLTIP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SPLTI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SPLTIGui); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SPLBLUNT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CfVar); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%d99Var); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dStarVar); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%EdgeVelVar); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%speccou); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%filesopen); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(AA_ParameterType), intent(in) :: SrcParamData
   type(AA_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)                  :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AA_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%DT = SrcParamData%DT
   DstParamData%IBLUNT = SrcParamData%IBLUNT
   DstParamData%ILAM = SrcParamData%ILAM
   DstParamData%ITIP = SrcParamData%ITIP
   DstParamData%ITRIP = SrcParamData%ITRIP
   DstParamData%ITURB = SrcParamData%ITURB
   DstParamData%IInflow = SrcParamData%IInflow
   DstParamData%X_BLMethod = SrcParamData%X_BLMethod
   DstParamData%TICalcMeth = SrcParamData%TICalcMeth
   DstParamData%ROUND = SrcParamData%ROUND
   DstParamData%ALPRAT = SrcParamData%ALPRAT
   DstParamData%NumBlades = SrcParamData%NumBlades
   DstParamData%NumBlNds = SrcParamData%NumBlNds
   DstParamData%AirDens = SrcParamData%AirDens
   DstParamData%KinVisc = SrcParamData%KinVisc
   DstParamData%SpdSound = SrcParamData%SpdSound
   DstParamData%HubHeight = SrcParamData%HubHeight
   DstParamData%toptip = SrcParamData%toptip
   DstParamData%bottip = SrcParamData%bottip
   if (allocated(SrcParamData%rotorregionlimitsVert)) then
      LB(1:1) = lbound(SrcParamData%rotorregionlimitsVert)
      UB(1:1) = ubound(SrcParamData%rotorregionlimitsVert)
      if (.not. allocated(DstParamData%rotorregionlimitsVert)) then
         allocate(DstParamData%rotorregionlimitsVert(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rotorregionlimitsVert.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%rotorregionlimitsVert = SrcParamData%rotorregionlimitsVert
   end if
   if (allocated(SrcParamData%rotorregionlimitsHorz)) then
      LB(1:1) = lbound(SrcParamData%rotorregionlimitsHorz)
      UB(1:1) = ubound(SrcParamData%rotorregionlimitsHorz)
      if (.not. allocated(DstParamData%rotorregionlimitsHorz)) then
         allocate(DstParamData%rotorregionlimitsHorz(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rotorregionlimitsHorz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%rotorregionlimitsHorz = SrcParamData%rotorregionlimitsHorz
   end if
   if (allocated(SrcParamData%rotorregionlimitsalph)) then
      LB(1:1) = lbound(SrcParamData%rotorregionlimitsalph)
      UB(1:1) = ubound(SrcParamData%rotorregionlimitsalph)
      if (.not. allocated(DstParamData%rotorregionlimitsalph)) then
         allocate(DstParamData%rotorregionlimitsalph(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rotorregionlimitsalph.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%rotorregionlimitsalph = SrcParamData%rotorregionlimitsalph
   end if
   if (allocated(SrcParamData%rotorregionlimitsrad)) then
      LB(1:1) = lbound(SrcParamData%rotorregionlimitsrad)
      UB(1:1) = ubound(SrcParamData%rotorregionlimitsrad)
      if (.not. allocated(DstParamData%rotorregionlimitsrad)) then
         allocate(DstParamData%rotorregionlimitsrad(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%rotorregionlimitsrad.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%rotorregionlimitsrad = SrcParamData%rotorregionlimitsrad
   end if
   DstParamData%NrObsLoc = SrcParamData%NrObsLoc
   DstParamData%aweightflag = SrcParamData%aweightflag
   DstParamData%TxtFileOutput = SrcParamData%TxtFileOutput
   DstParamData%AAStart = SrcParamData%AAStart
   if (allocated(SrcParamData%ObsX)) then
      LB(1:1) = lbound(SrcParamData%ObsX)
      UB(1:1) = ubound(SrcParamData%ObsX)
      if (.not. allocated(DstParamData%ObsX)) then
         allocate(DstParamData%ObsX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ObsX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ObsX = SrcParamData%ObsX
   end if
   if (allocated(SrcParamData%ObsY)) then
      LB(1:1) = lbound(SrcParamData%ObsY)
      UB(1:1) = ubound(SrcParamData%ObsY)
      if (.not. allocated(DstParamData%ObsY)) then
         allocate(DstParamData%ObsY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ObsY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ObsY = SrcParamData%ObsY
   end if
   if (allocated(SrcParamData%ObsZ)) then
      LB(1:1) = lbound(SrcParamData%ObsZ)
      UB(1:1) = ubound(SrcParamData%ObsZ)
      if (.not. allocated(DstParamData%ObsZ)) then
         allocate(DstParamData%ObsZ(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ObsZ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ObsZ = SrcParamData%ObsZ
   end if
   if (allocated(SrcParamData%FreqList)) then
      LB(1:1) = lbound(SrcParamData%FreqList)
      UB(1:1) = ubound(SrcParamData%FreqList)
      if (.not. allocated(DstParamData%FreqList)) then
         allocate(DstParamData%FreqList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%FreqList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%FreqList = SrcParamData%FreqList
   end if
   if (allocated(SrcParamData%Aweight)) then
      LB(1:1) = lbound(SrcParamData%Aweight)
      UB(1:1) = ubound(SrcParamData%Aweight)
      if (.not. allocated(DstParamData%Aweight)) then
         allocate(DstParamData%Aweight(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%Aweight.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%Aweight = SrcParamData%Aweight
   end if
   DstParamData%Fsample = SrcParamData%Fsample
   DstParamData%total_sample = SrcParamData%total_sample
   DstParamData%total_sampleTI = SrcParamData%total_sampleTI
   DstParamData%AA_Bl_Prcntge = SrcParamData%AA_Bl_Prcntge
   DstParamData%startnode = SrcParamData%startnode
   DstParamData%Lturb = SrcParamData%Lturb
   DstParamData%avgV = SrcParamData%avgV
   DstParamData%TI = SrcParamData%TI
   DstParamData%FTitle = SrcParamData%FTitle
   DstParamData%outFmt = SrcParamData%outFmt
   DstParamData%NrOutFile = SrcParamData%NrOutFile
   DstParamData%delim = SrcParamData%delim
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%NumOutsForPE = SrcParamData%NumOutsForPE
   DstParamData%NumOutsForSep = SrcParamData%NumOutsForSep
   DstParamData%NumOutsForNodes = SrcParamData%NumOutsForNodes
   DstParamData%unOutFile = SrcParamData%unOutFile
   DstParamData%unOutFile2 = SrcParamData%unOutFile2
   DstParamData%unOutFile3 = SrcParamData%unOutFile3
   DstParamData%unOutFile4 = SrcParamData%unOutFile4
   DstParamData%RootName = SrcParamData%RootName
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%StallStart)) then
      LB(1:2) = lbound(SrcParamData%StallStart)
      UB(1:2) = ubound(SrcParamData%StallStart)
      if (.not. allocated(DstParamData%StallStart)) then
         allocate(DstParamData%StallStart(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%StallStart.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%StallStart = SrcParamData%StallStart
   end if
   if (allocated(SrcParamData%TEThick)) then
      LB(1:2) = lbound(SrcParamData%TEThick)
      UB(1:2) = ubound(SrcParamData%TEThick)
      if (.not. allocated(DstParamData%TEThick)) then
         allocate(DstParamData%TEThick(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TEThick.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%TEThick = SrcParamData%TEThick
   end if
   if (allocated(SrcParamData%TEAngle)) then
      LB(1:2) = lbound(SrcParamData%TEAngle)
      UB(1:2) = ubound(SrcParamData%TEAngle)
      if (.not. allocated(DstParamData%TEAngle)) then
         allocate(DstParamData%TEAngle(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%TEAngle.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%TEAngle = SrcParamData%TEAngle
   end if
   if (allocated(SrcParamData%AerCent)) then
      LB(1:3) = lbound(SrcParamData%AerCent)
      UB(1:3) = ubound(SrcParamData%AerCent)
      if (.not. allocated(DstParamData%AerCent)) then
         allocate(DstParamData%AerCent(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AerCent.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AerCent = SrcParamData%AerCent
   end if
   if (allocated(SrcParamData%BlAFID)) then
      LB(1:2) = lbound(SrcParamData%BlAFID)
      UB(1:2) = ubound(SrcParamData%BlAFID)
      if (.not. allocated(DstParamData%BlAFID)) then
         allocate(DstParamData%BlAFID(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BlAFID.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BlAFID = SrcParamData%BlAFID
   end if
   if (allocated(SrcParamData%AFInfo)) then
      LB(1:1) = lbound(SrcParamData%AFInfo)
      UB(1:1) = ubound(SrcParamData%AFInfo)
      if (.not. allocated(DstParamData%AFInfo)) then
         allocate(DstParamData%AFInfo(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AFInfo.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call AFI_CopyParam(SrcParamData%AFInfo(i1), DstParamData%AFInfo(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcParamData%AFLECo)) then
      LB(1:3) = lbound(SrcParamData%AFLECo)
      UB(1:3) = ubound(SrcParamData%AFLECo)
      if (.not. allocated(DstParamData%AFLECo)) then
         allocate(DstParamData%AFLECo(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AFLECo.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AFLECo = SrcParamData%AFLECo
   end if
   if (allocated(SrcParamData%AFTECo)) then
      LB(1:3) = lbound(SrcParamData%AFTECo)
      UB(1:3) = ubound(SrcParamData%AFTECo)
      if (.not. allocated(DstParamData%AFTECo)) then
         allocate(DstParamData%AFTECo(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AFTECo.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AFTECo = SrcParamData%AFTECo
   end if
   if (allocated(SrcParamData%BlSpn)) then
      LB(1:2) = lbound(SrcParamData%BlSpn)
      UB(1:2) = ubound(SrcParamData%BlSpn)
      if (.not. allocated(DstParamData%BlSpn)) then
         allocate(DstParamData%BlSpn(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BlSpn.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BlSpn = SrcParamData%BlSpn
   end if
   if (allocated(SrcParamData%BlChord)) then
      LB(1:2) = lbound(SrcParamData%BlChord)
      UB(1:2) = ubound(SrcParamData%BlChord)
      if (.not. allocated(DstParamData%BlChord)) then
         allocate(DstParamData%BlChord(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%BlChord.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%BlChord = SrcParamData%BlChord
   end if
   if (allocated(SrcParamData%ReListBL)) then
      LB(1:1) = lbound(SrcParamData%ReListBL)
      UB(1:1) = ubound(SrcParamData%ReListBL)
      if (.not. allocated(DstParamData%ReListBL)) then
         allocate(DstParamData%ReListBL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%ReListBL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%ReListBL = SrcParamData%ReListBL
   end if
   if (allocated(SrcParamData%AOAListBL)) then
      LB(1:1) = lbound(SrcParamData%AOAListBL)
      UB(1:1) = ubound(SrcParamData%AOAListBL)
      if (.not. allocated(DstParamData%AOAListBL)) then
         allocate(DstParamData%AOAListBL(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AOAListBL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AOAListBL = SrcParamData%AOAListBL
   end if
   if (allocated(SrcParamData%dStarAll1)) then
      LB(1:3) = lbound(SrcParamData%dStarAll1)
      UB(1:3) = ubound(SrcParamData%dStarAll1)
      if (.not. allocated(DstParamData%dStarAll1)) then
         allocate(DstParamData%dStarAll1(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dStarAll1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%dStarAll1 = SrcParamData%dStarAll1
   end if
   if (allocated(SrcParamData%dStarAll2)) then
      LB(1:3) = lbound(SrcParamData%dStarAll2)
      UB(1:3) = ubound(SrcParamData%dStarAll2)
      if (.not. allocated(DstParamData%dStarAll2)) then
         allocate(DstParamData%dStarAll2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%dStarAll2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%dStarAll2 = SrcParamData%dStarAll2
   end if
   if (allocated(SrcParamData%d99All1)) then
      LB(1:3) = lbound(SrcParamData%d99All1)
      UB(1:3) = ubound(SrcParamData%d99All1)
      if (.not. allocated(DstParamData%d99All1)) then
         allocate(DstParamData%d99All1(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%d99All1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%d99All1 = SrcParamData%d99All1
   end if
   if (allocated(SrcParamData%d99All2)) then
      LB(1:3) = lbound(SrcParamData%d99All2)
      UB(1:3) = ubound(SrcParamData%d99All2)
      if (.not. allocated(DstParamData%d99All2)) then
         allocate(DstParamData%d99All2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%d99All2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%d99All2 = SrcParamData%d99All2
   end if
   if (allocated(SrcParamData%CfAll1)) then
      LB(1:3) = lbound(SrcParamData%CfAll1)
      UB(1:3) = ubound(SrcParamData%CfAll1)
      if (.not. allocated(DstParamData%CfAll1)) then
         allocate(DstParamData%CfAll1(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CfAll1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CfAll1 = SrcParamData%CfAll1
   end if
   if (allocated(SrcParamData%CfAll2)) then
      LB(1:3) = lbound(SrcParamData%CfAll2)
      UB(1:3) = ubound(SrcParamData%CfAll2)
      if (.not. allocated(DstParamData%CfAll2)) then
         allocate(DstParamData%CfAll2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%CfAll2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%CfAll2 = SrcParamData%CfAll2
   end if
   if (allocated(SrcParamData%EdgeVelRat1)) then
      LB(1:3) = lbound(SrcParamData%EdgeVelRat1)
      UB(1:3) = ubound(SrcParamData%EdgeVelRat1)
      if (.not. allocated(DstParamData%EdgeVelRat1)) then
         allocate(DstParamData%EdgeVelRat1(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%EdgeVelRat1.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%EdgeVelRat1 = SrcParamData%EdgeVelRat1
   end if
   if (allocated(SrcParamData%EdgeVelRat2)) then
      LB(1:3) = lbound(SrcParamData%EdgeVelRat2)
      UB(1:3) = ubound(SrcParamData%EdgeVelRat2)
      if (.not. allocated(DstParamData%EdgeVelRat2)) then
         allocate(DstParamData%EdgeVelRat2(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%EdgeVelRat2.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%EdgeVelRat2 = SrcParamData%EdgeVelRat2
   end if
   if (allocated(SrcParamData%AFThickGuida)) then
      LB(1:2) = lbound(SrcParamData%AFThickGuida)
      UB(1:2) = ubound(SrcParamData%AFThickGuida)
      if (.not. allocated(DstParamData%AFThickGuida)) then
         allocate(DstParamData%AFThickGuida(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%AFThickGuida.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%AFThickGuida = SrcParamData%AFThickGuida
   end if
end subroutine

subroutine AA_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(AA_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'AA_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%rotorregionlimitsVert)) then
      deallocate(ParamData%rotorregionlimitsVert)
   end if
   if (allocated(ParamData%rotorregionlimitsHorz)) then
      deallocate(ParamData%rotorregionlimitsHorz)
   end if
   if (allocated(ParamData%rotorregionlimitsalph)) then
      deallocate(ParamData%rotorregionlimitsalph)
   end if
   if (allocated(ParamData%rotorregionlimitsrad)) then
      deallocate(ParamData%rotorregionlimitsrad)
   end if
   if (allocated(ParamData%ObsX)) then
      deallocate(ParamData%ObsX)
   end if
   if (allocated(ParamData%ObsY)) then
      deallocate(ParamData%ObsY)
   end if
   if (allocated(ParamData%ObsZ)) then
      deallocate(ParamData%ObsZ)
   end if
   if (allocated(ParamData%FreqList)) then
      deallocate(ParamData%FreqList)
   end if
   if (allocated(ParamData%Aweight)) then
      deallocate(ParamData%Aweight)
   end if
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   if (allocated(ParamData%StallStart)) then
      deallocate(ParamData%StallStart)
   end if
   if (allocated(ParamData%TEThick)) then
      deallocate(ParamData%TEThick)
   end if
   if (allocated(ParamData%TEAngle)) then
      deallocate(ParamData%TEAngle)
   end if
   if (allocated(ParamData%AerCent)) then
      deallocate(ParamData%AerCent)
   end if
   if (allocated(ParamData%BlAFID)) then
      deallocate(ParamData%BlAFID)
   end if
   if (allocated(ParamData%AFInfo)) then
      LB(1:1) = lbound(ParamData%AFInfo)
      UB(1:1) = ubound(ParamData%AFInfo)
      do i1 = LB(1), UB(1)
         call AFI_DestroyParam(ParamData%AFInfo(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%AFInfo)
   end if
   if (allocated(ParamData%AFLECo)) then
      deallocate(ParamData%AFLECo)
   end if
   if (allocated(ParamData%AFTECo)) then
      deallocate(ParamData%AFTECo)
   end if
   if (allocated(ParamData%BlSpn)) then
      deallocate(ParamData%BlSpn)
   end if
   if (allocated(ParamData%BlChord)) then
      deallocate(ParamData%BlChord)
   end if
   if (allocated(ParamData%ReListBL)) then
      deallocate(ParamData%ReListBL)
   end if
   if (allocated(ParamData%AOAListBL)) then
      deallocate(ParamData%AOAListBL)
   end if
   if (allocated(ParamData%dStarAll1)) then
      deallocate(ParamData%dStarAll1)
   end if
   if (allocated(ParamData%dStarAll2)) then
      deallocate(ParamData%dStarAll2)
   end if
   if (allocated(ParamData%d99All1)) then
      deallocate(ParamData%d99All1)
   end if
   if (allocated(ParamData%d99All2)) then
      deallocate(ParamData%d99All2)
   end if
   if (allocated(ParamData%CfAll1)) then
      deallocate(ParamData%CfAll1)
   end if
   if (allocated(ParamData%CfAll2)) then
      deallocate(ParamData%CfAll2)
   end if
   if (allocated(ParamData%EdgeVelRat1)) then
      deallocate(ParamData%EdgeVelRat1)
   end if
   if (allocated(ParamData%EdgeVelRat2)) then
      deallocate(ParamData%EdgeVelRat2)
   end if
   if (allocated(ParamData%AFThickGuida)) then
      deallocate(ParamData%AFThickGuida)
   end if
end subroutine

subroutine AA_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AA_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AA_PackParam'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%IBLUNT)
   call RegPack(RF, InData%ILAM)
   call RegPack(RF, InData%ITIP)
   call RegPack(RF, InData%ITRIP)
   call RegPack(RF, InData%ITURB)
   call RegPack(RF, InData%IInflow)
   call RegPack(RF, InData%X_BLMethod)
   call RegPack(RF, InData%TICalcMeth)
   call RegPack(RF, InData%ROUND)
   call RegPack(RF, InData%ALPRAT)
   call RegPack(RF, InData%NumBlades)
   call RegPack(RF, InData%NumBlNds)
   call RegPack(RF, InData%AirDens)
   call RegPack(RF, InData%KinVisc)
   call RegPack(RF, InData%SpdSound)
   call RegPack(RF, InData%HubHeight)
   call RegPack(RF, InData%toptip)
   call RegPack(RF, InData%bottip)
   call RegPackAlloc(RF, InData%rotorregionlimitsVert)
   call RegPackAlloc(RF, InData%rotorregionlimitsHorz)
   call RegPackAlloc(RF, InData%rotorregionlimitsalph)
   call RegPackAlloc(RF, InData%rotorregionlimitsrad)
   call RegPack(RF, InData%NrObsLoc)
   call RegPack(RF, InData%aweightflag)
   call RegPack(RF, InData%TxtFileOutput)
   call RegPack(RF, InData%AAStart)
   call RegPackAlloc(RF, InData%ObsX)
   call RegPackAlloc(RF, InData%ObsY)
   call RegPackAlloc(RF, InData%ObsZ)
   call RegPackAlloc(RF, InData%FreqList)
   call RegPackAlloc(RF, InData%Aweight)
   call RegPack(RF, InData%Fsample)
   call RegPack(RF, InData%total_sample)
   call RegPack(RF, InData%total_sampleTI)
   call RegPack(RF, InData%AA_Bl_Prcntge)
   call RegPack(RF, InData%startnode)
   call RegPack(RF, InData%Lturb)
   call RegPack(RF, InData%avgV)
   call RegPack(RF, InData%TI)
   call RegPack(RF, InData%FTitle)
   call RegPack(RF, InData%outFmt)
   call RegPack(RF, InData%NrOutFile)
   call RegPack(RF, InData%delim)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%NumOutsForPE)
   call RegPack(RF, InData%NumOutsForSep)
   call RegPack(RF, InData%NumOutsForNodes)
   call RegPack(RF, InData%unOutFile)
   call RegPack(RF, InData%unOutFile2)
   call RegPack(RF, InData%unOutFile3)
   call RegPack(RF, InData%unOutFile4)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%StallStart)
   call RegPackAlloc(RF, InData%TEThick)
   call RegPackAlloc(RF, InData%TEAngle)
   call RegPackAlloc(RF, InData%AerCent)
   call RegPackAlloc(RF, InData%BlAFID)
   call RegPack(RF, allocated(InData%AFInfo))
   if (allocated(InData%AFInfo)) then
      call RegPackBounds(RF, 1, lbound(InData%AFInfo), ubound(InData%AFInfo))
      LB(1:1) = lbound(InData%AFInfo)
      UB(1:1) = ubound(InData%AFInfo)
      do i1 = LB(1), UB(1)
         call AFI_PackParam(RF, InData%AFInfo(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%AFLECo)
   call RegPackAlloc(RF, InData%AFTECo)
   call RegPackAlloc(RF, InData%BlSpn)
   call RegPackAlloc(RF, InData%BlChord)
   call RegPackAlloc(RF, InData%ReListBL)
   call RegPackAlloc(RF, InData%AOAListBL)
   call RegPackAlloc(RF, InData%dStarAll1)
   call RegPackAlloc(RF, InData%dStarAll2)
   call RegPackAlloc(RF, InData%d99All1)
   call RegPackAlloc(RF, InData%d99All2)
   call RegPackAlloc(RF, InData%CfAll1)
   call RegPackAlloc(RF, InData%CfAll2)
   call RegPackAlloc(RF, InData%EdgeVelRat1)
   call RegPackAlloc(RF, InData%EdgeVelRat2)
   call RegPackAlloc(RF, InData%AFThickGuida)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AA_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AA_UnPackParam'
   integer(B4Ki)   :: i1, i2, i3
   integer(B4Ki)   :: LB(3), UB(3)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IBLUNT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ILAM); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ITIP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ITRIP); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ITURB); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%IInflow); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%X_BLMethod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TICalcMeth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ROUND); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ALPRAT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBlades); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumBlNds); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AirDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%KinVisc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SpdSound); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubHeight); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%toptip); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%bottip); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rotorregionlimitsVert); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rotorregionlimitsHorz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rotorregionlimitsalph); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%rotorregionlimitsrad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NrObsLoc); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%aweightflag); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TxtFileOutput); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AAStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ObsX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ObsY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ObsZ); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%FreqList); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Aweight); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Fsample); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%total_sample); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%total_sampleTI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AA_Bl_Prcntge); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%startnode); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Lturb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%avgV); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TI); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FTitle); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%outFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NrOutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%delim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOutsForPE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOutsForSep); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOutsForNodes); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%unOutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%unOutFile2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%unOutFile3); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%unOutFile4); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%StallStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TEThick); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TEAngle); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AerCent); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlAFID); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%AFInfo)) deallocate(OutData%AFInfo)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%AFInfo(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%AFInfo.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call AFI_UnpackParam(RF, OutData%AFInfo(i1)) ! AFInfo 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%AFLECo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AFTECo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlSpn); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%BlChord); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%ReListBL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AOAListBL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dStarAll1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%dStarAll2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%d99All1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%d99All2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CfAll1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%CfAll2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%EdgeVelRat1); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%EdgeVelRat2); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AFThickGuida); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(AA_InputType), intent(in) :: SrcInputData
   type(AA_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AA_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInputData%RotGtoL)) then
      LB(1:4) = lbound(SrcInputData%RotGtoL)
      UB(1:4) = ubound(SrcInputData%RotGtoL)
      if (.not. allocated(DstInputData%RotGtoL)) then
         allocate(DstInputData%RotGtoL(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%RotGtoL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%RotGtoL = SrcInputData%RotGtoL
   end if
   if (allocated(SrcInputData%AeroCent_G)) then
      LB(1:3) = lbound(SrcInputData%AeroCent_G)
      UB(1:3) = ubound(SrcInputData%AeroCent_G)
      if (.not. allocated(DstInputData%AeroCent_G)) then
         allocate(DstInputData%AeroCent_G(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%AeroCent_G.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%AeroCent_G = SrcInputData%AeroCent_G
   end if
   if (allocated(SrcInputData%Vrel)) then
      LB(1:2) = lbound(SrcInputData%Vrel)
      UB(1:2) = ubound(SrcInputData%Vrel)
      if (.not. allocated(DstInputData%Vrel)) then
         allocate(DstInputData%Vrel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Vrel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%Vrel = SrcInputData%Vrel
   end if
   if (allocated(SrcInputData%AoANoise)) then
      LB(1:2) = lbound(SrcInputData%AoANoise)
      UB(1:2) = ubound(SrcInputData%AoANoise)
      if (.not. allocated(DstInputData%AoANoise)) then
         allocate(DstInputData%AoANoise(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%AoANoise.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%AoANoise = SrcInputData%AoANoise
   end if
   if (allocated(SrcInputData%Inflow)) then
      LB(1:3) = lbound(SrcInputData%Inflow)
      UB(1:3) = ubound(SrcInputData%Inflow)
      if (.not. allocated(DstInputData%Inflow)) then
         allocate(DstInputData%Inflow(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputData%Inflow.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputData%Inflow = SrcInputData%Inflow
   end if
end subroutine

subroutine AA_DestroyInput(InputData, ErrStat, ErrMsg)
   type(AA_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AA_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputData%RotGtoL)) then
      deallocate(InputData%RotGtoL)
   end if
   if (allocated(InputData%AeroCent_G)) then
      deallocate(InputData%AeroCent_G)
   end if
   if (allocated(InputData%Vrel)) then
      deallocate(InputData%Vrel)
   end if
   if (allocated(InputData%AoANoise)) then
      deallocate(InputData%AoANoise)
   end if
   if (allocated(InputData%Inflow)) then
      deallocate(InputData%Inflow)
   end if
end subroutine

subroutine AA_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AA_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AA_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%RotGtoL)
   call RegPackAlloc(RF, InData%AeroCent_G)
   call RegPackAlloc(RF, InData%Vrel)
   call RegPackAlloc(RF, InData%AoANoise)
   call RegPackAlloc(RF, InData%Inflow)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AA_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AA_UnPackInput'
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%RotGtoL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AeroCent_G); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Vrel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AoANoise); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Inflow); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(AA_OutputType), intent(in) :: SrcOutputData
   type(AA_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(4), UB(4)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'AA_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcOutputData%SumSpecNoise)) then
      LB(1:3) = lbound(SrcOutputData%SumSpecNoise)
      UB(1:3) = ubound(SrcOutputData%SumSpecNoise)
      if (.not. allocated(DstOutputData%SumSpecNoise)) then
         allocate(DstOutputData%SumSpecNoise(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%SumSpecNoise.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%SumSpecNoise = SrcOutputData%SumSpecNoise
   end if
   if (allocated(SrcOutputData%SumSpecNoiseSep)) then
      LB(1:3) = lbound(SrcOutputData%SumSpecNoiseSep)
      UB(1:3) = ubound(SrcOutputData%SumSpecNoiseSep)
      if (.not. allocated(DstOutputData%SumSpecNoiseSep)) then
         allocate(DstOutputData%SumSpecNoiseSep(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%SumSpecNoiseSep.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%SumSpecNoiseSep = SrcOutputData%SumSpecNoiseSep
   end if
   if (allocated(SrcOutputData%OASPL)) then
      LB(1:3) = lbound(SrcOutputData%OASPL)
      UB(1:3) = ubound(SrcOutputData%OASPL)
      if (.not. allocated(DstOutputData%OASPL)) then
         allocate(DstOutputData%OASPL(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%OASPL.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%OASPL = SrcOutputData%OASPL
   end if
   if (allocated(SrcOutputData%OASPL_Mech)) then
      LB(1:4) = lbound(SrcOutputData%OASPL_Mech)
      UB(1:4) = ubound(SrcOutputData%OASPL_Mech)
      if (.not. allocated(DstOutputData%OASPL_Mech)) then
         allocate(DstOutputData%OASPL_Mech(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%OASPL_Mech.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%OASPL_Mech = SrcOutputData%OASPL_Mech
   end if
   if (allocated(SrcOutputData%DirectiviOutput)) then
      LB(1:1) = lbound(SrcOutputData%DirectiviOutput)
      UB(1:1) = ubound(SrcOutputData%DirectiviOutput)
      if (.not. allocated(DstOutputData%DirectiviOutput)) then
         allocate(DstOutputData%DirectiviOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%DirectiviOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%DirectiviOutput = SrcOutputData%DirectiviOutput
   end if
   if (allocated(SrcOutputData%OutLECoords)) then
      LB(1:4) = lbound(SrcOutputData%OutLECoords)
      UB(1:4) = ubound(SrcOutputData%OutLECoords)
      if (.not. allocated(DstOutputData%OutLECoords)) then
         allocate(DstOutputData%OutLECoords(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%OutLECoords.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%OutLECoords = SrcOutputData%OutLECoords
   end if
   if (allocated(SrcOutputData%PtotalFreq)) then
      LB(1:2) = lbound(SrcOutputData%PtotalFreq)
      UB(1:2) = ubound(SrcOutputData%PtotalFreq)
      if (.not. allocated(DstOutputData%PtotalFreq)) then
         allocate(DstOutputData%PtotalFreq(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%PtotalFreq.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%PtotalFreq = SrcOutputData%PtotalFreq
   end if
   if (allocated(SrcOutputData%WriteOutputForPE)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutputForPE)
      UB(1:1) = ubound(SrcOutputData%WriteOutputForPE)
      if (.not. allocated(DstOutputData%WriteOutputForPE)) then
         allocate(DstOutputData%WriteOutputForPE(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutputForPE.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutputForPE = SrcOutputData%WriteOutputForPE
   end if
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
   if (allocated(SrcOutputData%WriteOutputSep)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutputSep)
      UB(1:1) = ubound(SrcOutputData%WriteOutputSep)
      if (.not. allocated(DstOutputData%WriteOutputSep)) then
         allocate(DstOutputData%WriteOutputSep(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutputSep.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutputSep = SrcOutputData%WriteOutputSep
   end if
   if (allocated(SrcOutputData%WriteOutputNode)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutputNode)
      UB(1:1) = ubound(SrcOutputData%WriteOutputNode)
      if (.not. allocated(DstOutputData%WriteOutputNode)) then
         allocate(DstOutputData%WriteOutputNode(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutputNode.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutputNode = SrcOutputData%WriteOutputNode
   end if
end subroutine

subroutine AA_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(AA_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'AA_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%SumSpecNoise)) then
      deallocate(OutputData%SumSpecNoise)
   end if
   if (allocated(OutputData%SumSpecNoiseSep)) then
      deallocate(OutputData%SumSpecNoiseSep)
   end if
   if (allocated(OutputData%OASPL)) then
      deallocate(OutputData%OASPL)
   end if
   if (allocated(OutputData%OASPL_Mech)) then
      deallocate(OutputData%OASPL_Mech)
   end if
   if (allocated(OutputData%DirectiviOutput)) then
      deallocate(OutputData%DirectiviOutput)
   end if
   if (allocated(OutputData%OutLECoords)) then
      deallocate(OutputData%OutLECoords)
   end if
   if (allocated(OutputData%PtotalFreq)) then
      deallocate(OutputData%PtotalFreq)
   end if
   if (allocated(OutputData%WriteOutputForPE)) then
      deallocate(OutputData%WriteOutputForPE)
   end if
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
   if (allocated(OutputData%WriteOutputSep)) then
      deallocate(OutputData%WriteOutputSep)
   end if
   if (allocated(OutputData%WriteOutputNode)) then
      deallocate(OutputData%WriteOutputNode)
   end if
end subroutine

subroutine AA_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AA_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'AA_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%SumSpecNoise)
   call RegPackAlloc(RF, InData%SumSpecNoiseSep)
   call RegPackAlloc(RF, InData%OASPL)
   call RegPackAlloc(RF, InData%OASPL_Mech)
   call RegPackAlloc(RF, InData%DirectiviOutput)
   call RegPackAlloc(RF, InData%OutLECoords)
   call RegPackAlloc(RF, InData%PtotalFreq)
   call RegPackAlloc(RF, InData%WriteOutputForPE)
   call RegPackAlloc(RF, InData%WriteOutput)
   call RegPackAlloc(RF, InData%WriteOutputSep)
   call RegPackAlloc(RF, InData%WriteOutputNode)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine AA_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AA_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'AA_UnPackOutput'
   integer(B4Ki)   :: LB(4), UB(4)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%SumSpecNoise); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%SumSpecNoiseSep); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OASPL); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OASPL_Mech); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DirectiviOutput); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutLECoords); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%PtotalFreq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputForPE); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputSep); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputNode); if (RegCheckErr(RF, RoutineName)) return
end subroutine
END MODULE AeroAcoustics_Types
!ENDOFREGISTRYGENERATEDFILE
