!STARTOFREGISTRYGENERATEDFILE 'AeroDisk_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! AeroDisk_Types
!.................................................................................................................................
! This file is part of AeroDisk.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in AeroDisk. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE AeroDisk_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE IfW_FlowField_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: ADsk_NumPtsDiskAvg = 144      ! Number of points averaged for rotor-average wind speed [-]
! =========  ADsk_AeroTable  =======
  TYPE, PUBLIC :: ADsk_AeroTable
    INTEGER(IntKi)  :: N_TSR = 0_IntKi      !< Number of rotor tip-speed ratios in tables [-]
    INTEGER(IntKi)  :: N_RtSpd = 0_IntKi      !< Number of rotor speeds in tables [-]
    INTEGER(IntKi)  :: N_VRel = 0_IntKi      !< Number of rotor inflow wind speeds in tables [-]
    INTEGER(IntKi)  :: N_Pitch = 0_IntKi      !< Number of rotor-collective blade-pitch angles in tables [-]
    INTEGER(IntKi)  :: N_Skew = 0_IntKi      !< Number of rotor inflow-skew angles in tables [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: TSR      !< Rotor TSR values in tables [-]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: RtSpd      !< Rotor speed values in tables [rad/s]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: VRel      !< Rotor inflow wind speeds tables [m/s]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: Pitch      !< Rotor-collective blade-pitch anges in tables [rad]
    REAL(SiKi) , DIMENSION(:), ALLOCATABLE  :: Skew      !< Rotor inflow-skew values in tables [rad]
    REAL(SiKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: C_Fx      !< Thrust (x/axial)      coefficient [N_TSR, N_RtSpd, N_VRel, N_Pitch, N_Skew] [-]
    REAL(SiKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: C_Fy      !< Transverse (y) force  coefficient [N_TSR, N_RtSpd, N_VRel, N_Pitch, N_Skew] [-]
    REAL(SiKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: C_Fz      !< Transverse (z) force  coefficient [N_TSR, N_RtSpd, N_VRel, N_Pitch, N_Skew] [-]
    REAL(SiKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: C_Mx      !< Torque (x/axial)      coefficient [N_TSR, N_RtSpd, N_VRel, N_Pitch, N_Skew] [-]
    REAL(SiKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: C_My      !< Transverse (y) moment coefficient [N_TSR, N_RtSpd, N_VRel, N_Pitch, N_Skew] [-]
    REAL(SiKi) , DIMENSION(:,:,:,:,:), ALLOCATABLE  :: C_Mz      !< Transverse (z) moment coefficient [N_TSR, N_RtSpd, N_VRel, N_Pitch, N_Skew] [-]
  END TYPE ADsk_AeroTable
! =======================
! =========  ADsk_InputFile  =======
  TYPE, PUBLIC :: ADsk_InputFile
    LOGICAL  :: Echo = .false.      !< Echo the input file [-]
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for module time integration [s]
    REAL(ReKi)  :: AirDens = 0.0_ReKi      !< Air density [kg/m^3]
    REAL(ReKi)  :: RotorRad = 0.0_ReKi      !< Rotor radius [m]
    LOGICAL  :: SumPrint = .false.      !< Print summary data to <RootName>.sum [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of outputs [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: OutList      !< List of user-requested output channels [-]
    TYPE(ADsk_AeroTable)  :: AeroTable      !< Data table [-]
  END TYPE ADsk_InputFile
! =======================
! =========  ADsk_InitInputType  =======
  TYPE, PUBLIC :: ADsk_InitInputType
    CHARACTER(1024)  :: InputFile      !< Name of the input file [-]
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    REAL(ReKi)  :: RotorRad = 0.0_ReKi      !< Rotor radius [m]
    REAL(ReKi) , DIMENSION(1:3)  :: HubPosition = 0.0_ReKi      !< Hub position -- center of rotor [m]
    REAL(R8Ki) , DIMENSION(1:3,1:3)  :: HubOrientation = 0.0_R8Ki      !< Hub orientation [-]
    REAL(ReKi)  :: defAirDens = 0.0_ReKi      !< Default atmospheric density from the driver; may be overwritten [kg/m^3]
    LOGICAL  :: Linearize = .false.      !< this module cannot be linearized at present [-]
    LOGICAL  :: UseInputFile = .TRUE.      !< Supplied by Driver:  .TRUE. if using a input file, .FALSE. if all inputs are being passed in by the caller [-]
    TYPE(FileInfoType)  :: PassedFileData      !< If we don't use the input file, pass everything through this [-]
    TYPE(FlowFieldType) , POINTER :: FlowField => NULL()      !< Pointer of InflowWinds flow field data type [-]
  END TYPE ADsk_InitInputType
! =======================
! =========  ADsk_InitOutputType  =======
  TYPE, PUBLIC :: ADsk_InitOutputType
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputHdr      !< Names of the output-to-file channels [-]
    CHARACTER(ChanLen) , DIMENSION(:), ALLOCATABLE  :: WriteOutputUnt      !< Units of the output-to-file channels [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
    REAL(ReKi)  :: AirDens = 0.0_ReKi      !< Air density [kg/m^3]
  END TYPE ADsk_InitOutputType
! =======================
! =========  ADsk_InputType  =======
  TYPE, PUBLIC :: ADsk_InputType
    TYPE(MeshType)  :: HubMotion      !< Hub motion [-]
    REAL(ReKi)  :: RotSpeed = 0.0_ReKi      !< Rotor speed [rad/s]
    REAL(ReKi)  :: BlPitch = 0.0_ReKi      !< blade pitch [rad]
  END TYPE ADsk_InputType
! =======================
! =========  ADsk_OutputType  =======
  TYPE, PUBLIC :: ADsk_OutputType
    TYPE(MeshType)  :: AeroLoads      !< Mesh containing the forces and moments from the aero loading (at HubMotion mesh) [-]
    REAL(ReKi)  :: YawErr = 0.0_ReKi      !< Nacelle-yaw error, i.e., the angle about positive Z from the rotor centerline to the rotor-disk-averaged relative wind velocity (ambient + rotor  motion), both projected onto the horizontal plane [rad]
    REAL(ReKi)  :: PsiSkew = 0.0_ReKi      !< Azimuth angle (from the nominally vertical axis in the disk plane, Z_disk ) to the vector about which the inflow skew angle is defined, i.e., the angle about positive X_disk  from Z_disk  to the vector about which the positive inflow skew angle is defined  [rad]
    REAL(ReKi)  :: ChiSkew = 0.0_ReKi      !< Inflow skew angle [rad]
    REAL(ReKi)  :: VRel = 0.0_ReKi      !< Rotor-disk-averaged relative wind speed (ambient + rotor motion), normal to disk [m/s]
    REAL(ReKi)  :: Ct = 0.0_ReKi      !< Thrust force coefficient (normal to disk) [-]
    REAL(ReKi)  :: Cq = 0.0_ReKi      !< Torque coefficient (normal to disk) [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WriteOutput      !< Data to be written to an output file: see WriteOutputHdr for names of each variable [see WriteOutputUnt]
  END TYPE ADsk_OutputType
! =======================
! =========  ADsk_ContinuousStateType  =======
  TYPE, PUBLIC :: ADsk_ContinuousStateType
    REAL(ReKi)  :: DummyContState = 0.0_ReKi      !<  [-]
  END TYPE ADsk_ContinuousStateType
! =======================
! =========  ADsk_DiscreteStateType  =======
  TYPE, PUBLIC :: ADsk_DiscreteStateType
    REAL(ReKi)  :: DummyDiscreteState = 0.0_ReKi      !<  [-]
  END TYPE ADsk_DiscreteStateType
! =======================
! =========  ADsk_ConstraintStateType  =======
  TYPE, PUBLIC :: ADsk_ConstraintStateType
    REAL(ReKi)  :: DummyConstrState = 0.0_ReKi      !<  [-]
  END TYPE ADsk_ConstraintStateType
! =======================
! =========  ADsk_OtherStateType  =======
  TYPE, PUBLIC :: ADsk_OtherStateType
    INTEGER(IntKi)  :: DummyOtherState = 0_IntKi      !<  [-]
  END TYPE ADsk_OtherStateType
! =======================
! =========  ADsk_ParameterType  =======
  TYPE, PUBLIC :: ADsk_ParameterType
    CHARACTER(1024)  :: RootName      !< RootName for writing output files [-]
    REAL(DbKi)  :: DT = 0.0_R8Ki      !< Time step for module time integration [s]
    REAL(ReKi)  :: RotorRad = 0.0_ReKi      !< Rotor radius [m]
    REAL(ReKi)  :: AirDens = 0.0_ReKi      !< Air density [kg/m^3]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of outputs [-]
    REAL(ReKi)  :: halfRhoA = 0.0_ReKi      !< half air density times rotor swept area [kg/m]
    TYPE(ADsk_AeroTable)  :: AeroTable      !< Data table [-]
    LOGICAL  :: UseTSR = .false.      !< Use TSR values from table instead of VRel + RtSpd [-]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameters [-]
    TYPE(FlowFieldType) , POINTER :: FlowField => NULL()      !< Pointer of InflowWinds flow field data type [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: DiskWindPosRel      !< Disk locations for sampling to get disk avarage velocity (relative to hub) [m]
  END TYPE ADsk_ParameterType
! =======================
! =========  ADsk_MiscVarType  =======
  TYPE, PUBLIC :: ADsk_MiscVarType
    INTEGER(IntKi) , DIMENSION(1:5)  :: idx_last = 0_IntKi      !< Last indices used in lookup search [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AllOuts      !< Array of all outputs [-]
    REAL(SiKi) , DIMENSION(1:3)  :: x_hat = 0.0_R4Ki      !< Acuator disk X direction unit vector (global) [-]
    REAL(SiKi) , DIMENSION(1:3)  :: y_hat = 0.0_R4Ki      !< Acuator disk Y direction unit vector (global) [-]
    REAL(SiKi) , DIMENSION(1:3)  :: z_hat = 0.0_R4Ki      !< Acuator disk Z direction unit vector (global) [-]
    REAL(SiKi)  :: VRel = 0.0_R4Ki      !< magnitude of VRel (output as y%VRel) [m/s]
    REAL(SiKi)  :: VRel_xd = 0.0_R4Ki      !< relative wind velocity along disk normal [m/s]
    REAL(SiKi)  :: lambda = 0.0_R4Ki      !< TSR - tip speed ratio [-]
    REAL(SiKi)  :: Chi = 0.0_R4Ki      !< Inflow skew angle [rad]
    REAL(SiKi) , DIMENSION(1:3)  :: C_F = 0.0_R4Ki      !< Force  coefficients from table [-]
    REAL(SiKi) , DIMENSION(1:3)  :: C_M = 0.0_R4Ki      !< Moment coefficients from table [-]
    REAL(SiKi) , DIMENSION(1:3)  :: Force = 0.0_R4Ki      !< Force  calculated in actuator disk coordinates [N]
    REAL(SiKi) , DIMENSION(1:3)  :: Moment = 0.0_R4Ki      !< Moment calculated in actuator disk coordinates [N-m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: DiskWindPosAbs      !< Disk locations for sampling to get disk avarage velocity (absolute for getting wind) [m]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: DiskWindVel      !< Wind speed at disk locations for disk velocity [m/s]
    REAL(ReKi) , DIMENSION(1:3)  :: DiskAvgVel = 0.0_ReKi      !< Average wind speed across rotor disk [m/s]
  END TYPE ADsk_MiscVarType
! =======================
CONTAINS

subroutine ADsk_CopyAeroTable(SrcAeroTableData, DstAeroTableData, CtrlCode, ErrStat, ErrMsg)
   type(ADsk_AeroTable), intent(in) :: SrcAeroTableData
   type(ADsk_AeroTable), intent(inout) :: DstAeroTableData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(5), UB(5)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ADsk_CopyAeroTable'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstAeroTableData%N_TSR = SrcAeroTableData%N_TSR
   DstAeroTableData%N_RtSpd = SrcAeroTableData%N_RtSpd
   DstAeroTableData%N_VRel = SrcAeroTableData%N_VRel
   DstAeroTableData%N_Pitch = SrcAeroTableData%N_Pitch
   DstAeroTableData%N_Skew = SrcAeroTableData%N_Skew
   if (allocated(SrcAeroTableData%TSR)) then
      LB(1:1) = lbound(SrcAeroTableData%TSR)
      UB(1:1) = ubound(SrcAeroTableData%TSR)
      if (.not. allocated(DstAeroTableData%TSR)) then
         allocate(DstAeroTableData%TSR(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroTableData%TSR.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstAeroTableData%TSR = SrcAeroTableData%TSR
   end if
   if (allocated(SrcAeroTableData%RtSpd)) then
      LB(1:1) = lbound(SrcAeroTableData%RtSpd)
      UB(1:1) = ubound(SrcAeroTableData%RtSpd)
      if (.not. allocated(DstAeroTableData%RtSpd)) then
         allocate(DstAeroTableData%RtSpd(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroTableData%RtSpd.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstAeroTableData%RtSpd = SrcAeroTableData%RtSpd
   end if
   if (allocated(SrcAeroTableData%VRel)) then
      LB(1:1) = lbound(SrcAeroTableData%VRel)
      UB(1:1) = ubound(SrcAeroTableData%VRel)
      if (.not. allocated(DstAeroTableData%VRel)) then
         allocate(DstAeroTableData%VRel(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroTableData%VRel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstAeroTableData%VRel = SrcAeroTableData%VRel
   end if
   if (allocated(SrcAeroTableData%Pitch)) then
      LB(1:1) = lbound(SrcAeroTableData%Pitch)
      UB(1:1) = ubound(SrcAeroTableData%Pitch)
      if (.not. allocated(DstAeroTableData%Pitch)) then
         allocate(DstAeroTableData%Pitch(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroTableData%Pitch.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstAeroTableData%Pitch = SrcAeroTableData%Pitch
   end if
   if (allocated(SrcAeroTableData%Skew)) then
      LB(1:1) = lbound(SrcAeroTableData%Skew)
      UB(1:1) = ubound(SrcAeroTableData%Skew)
      if (.not. allocated(DstAeroTableData%Skew)) then
         allocate(DstAeroTableData%Skew(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroTableData%Skew.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstAeroTableData%Skew = SrcAeroTableData%Skew
   end if
   if (allocated(SrcAeroTableData%C_Fx)) then
      LB(1:5) = lbound(SrcAeroTableData%C_Fx)
      UB(1:5) = ubound(SrcAeroTableData%C_Fx)
      if (.not. allocated(DstAeroTableData%C_Fx)) then
         allocate(DstAeroTableData%C_Fx(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4),LB(5):UB(5)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroTableData%C_Fx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstAeroTableData%C_Fx = SrcAeroTableData%C_Fx
   end if
   if (allocated(SrcAeroTableData%C_Fy)) then
      LB(1:5) = lbound(SrcAeroTableData%C_Fy)
      UB(1:5) = ubound(SrcAeroTableData%C_Fy)
      if (.not. allocated(DstAeroTableData%C_Fy)) then
         allocate(DstAeroTableData%C_Fy(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4),LB(5):UB(5)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroTableData%C_Fy.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstAeroTableData%C_Fy = SrcAeroTableData%C_Fy
   end if
   if (allocated(SrcAeroTableData%C_Fz)) then
      LB(1:5) = lbound(SrcAeroTableData%C_Fz)
      UB(1:5) = ubound(SrcAeroTableData%C_Fz)
      if (.not. allocated(DstAeroTableData%C_Fz)) then
         allocate(DstAeroTableData%C_Fz(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4),LB(5):UB(5)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroTableData%C_Fz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstAeroTableData%C_Fz = SrcAeroTableData%C_Fz
   end if
   if (allocated(SrcAeroTableData%C_Mx)) then
      LB(1:5) = lbound(SrcAeroTableData%C_Mx)
      UB(1:5) = ubound(SrcAeroTableData%C_Mx)
      if (.not. allocated(DstAeroTableData%C_Mx)) then
         allocate(DstAeroTableData%C_Mx(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4),LB(5):UB(5)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroTableData%C_Mx.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstAeroTableData%C_Mx = SrcAeroTableData%C_Mx
   end if
   if (allocated(SrcAeroTableData%C_My)) then
      LB(1:5) = lbound(SrcAeroTableData%C_My)
      UB(1:5) = ubound(SrcAeroTableData%C_My)
      if (.not. allocated(DstAeroTableData%C_My)) then
         allocate(DstAeroTableData%C_My(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4),LB(5):UB(5)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroTableData%C_My.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstAeroTableData%C_My = SrcAeroTableData%C_My
   end if
   if (allocated(SrcAeroTableData%C_Mz)) then
      LB(1:5) = lbound(SrcAeroTableData%C_Mz)
      UB(1:5) = ubound(SrcAeroTableData%C_Mz)
      if (.not. allocated(DstAeroTableData%C_Mz)) then
         allocate(DstAeroTableData%C_Mz(LB(1):UB(1),LB(2):UB(2),LB(3):UB(3),LB(4):UB(4),LB(5):UB(5)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAeroTableData%C_Mz.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstAeroTableData%C_Mz = SrcAeroTableData%C_Mz
   end if
end subroutine

subroutine ADsk_DestroyAeroTable(AeroTableData, ErrStat, ErrMsg)
   type(ADsk_AeroTable), intent(inout) :: AeroTableData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ADsk_DestroyAeroTable'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(AeroTableData%TSR)) then
      deallocate(AeroTableData%TSR)
   end if
   if (allocated(AeroTableData%RtSpd)) then
      deallocate(AeroTableData%RtSpd)
   end if
   if (allocated(AeroTableData%VRel)) then
      deallocate(AeroTableData%VRel)
   end if
   if (allocated(AeroTableData%Pitch)) then
      deallocate(AeroTableData%Pitch)
   end if
   if (allocated(AeroTableData%Skew)) then
      deallocate(AeroTableData%Skew)
   end if
   if (allocated(AeroTableData%C_Fx)) then
      deallocate(AeroTableData%C_Fx)
   end if
   if (allocated(AeroTableData%C_Fy)) then
      deallocate(AeroTableData%C_Fy)
   end if
   if (allocated(AeroTableData%C_Fz)) then
      deallocate(AeroTableData%C_Fz)
   end if
   if (allocated(AeroTableData%C_Mx)) then
      deallocate(AeroTableData%C_Mx)
   end if
   if (allocated(AeroTableData%C_My)) then
      deallocate(AeroTableData%C_My)
   end if
   if (allocated(AeroTableData%C_Mz)) then
      deallocate(AeroTableData%C_Mz)
   end if
end subroutine

subroutine ADsk_PackAeroTable(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADsk_AeroTable), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADsk_PackAeroTable'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%N_TSR)
   call RegPack(RF, InData%N_RtSpd)
   call RegPack(RF, InData%N_VRel)
   call RegPack(RF, InData%N_Pitch)
   call RegPack(RF, InData%N_Skew)
   call RegPackAlloc(RF, InData%TSR)
   call RegPackAlloc(RF, InData%RtSpd)
   call RegPackAlloc(RF, InData%VRel)
   call RegPackAlloc(RF, InData%Pitch)
   call RegPackAlloc(RF, InData%Skew)
   call RegPackAlloc(RF, InData%C_Fx)
   call RegPackAlloc(RF, InData%C_Fy)
   call RegPackAlloc(RF, InData%C_Fz)
   call RegPackAlloc(RF, InData%C_Mx)
   call RegPackAlloc(RF, InData%C_My)
   call RegPackAlloc(RF, InData%C_Mz)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_UnPackAeroTable(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADsk_AeroTable), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADsk_UnPackAeroTable'
   integer(B4Ki)   :: LB(5), UB(5)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%N_TSR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%N_RtSpd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%N_VRel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%N_Pitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%N_Skew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TSR); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%RtSpd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%VRel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Pitch); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%Skew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C_Fx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C_Fy); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C_Fz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C_Mx); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C_My); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%C_Mz); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_CopyInputFile(SrcInputFileData, DstInputFileData, CtrlCode, ErrStat, ErrMsg)
   type(ADsk_InputFile), intent(in) :: SrcInputFileData
   type(ADsk_InputFile), intent(inout) :: DstInputFileData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADsk_CopyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputFileData%Echo = SrcInputFileData%Echo
   DstInputFileData%DT = SrcInputFileData%DT
   DstInputFileData%AirDens = SrcInputFileData%AirDens
   DstInputFileData%RotorRad = SrcInputFileData%RotorRad
   DstInputFileData%SumPrint = SrcInputFileData%SumPrint
   DstInputFileData%NumOuts = SrcInputFileData%NumOuts
   if (allocated(SrcInputFileData%OutList)) then
      LB(1:1) = lbound(SrcInputFileData%OutList)
      UB(1:1) = ubound(SrcInputFileData%OutList)
      if (.not. allocated(DstInputFileData%OutList)) then
         allocate(DstInputFileData%OutList(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInputFileData%OutList.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInputFileData%OutList = SrcInputFileData%OutList
   end if
   call ADsk_CopyAeroTable(SrcInputFileData%AeroTable, DstInputFileData%AeroTable, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine ADsk_DestroyInputFile(InputFileData, ErrStat, ErrMsg)
   type(ADsk_InputFile), intent(inout) :: InputFileData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADsk_DestroyInputFile'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InputFileData%OutList)) then
      deallocate(InputFileData%OutList)
   end if
   call ADsk_DestroyAeroTable(InputFileData%AeroTable, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ADsk_PackInputFile(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADsk_InputFile), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADsk_PackInputFile'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%Echo)
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%AirDens)
   call RegPack(RF, InData%RotorRad)
   call RegPack(RF, InData%SumPrint)
   call RegPack(RF, InData%NumOuts)
   call RegPackAlloc(RF, InData%OutList)
   call ADsk_PackAeroTable(RF, InData%AeroTable) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_UnPackInputFile(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADsk_InputFile), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADsk_UnPackInputFile'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%Echo); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AirDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotorRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SumPrint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutList); if (RegCheckErr(RF, RoutineName)) return
   call ADsk_UnpackAeroTable(RF, OutData%AeroTable) ! AeroTable 
end subroutine

subroutine ADsk_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(ADsk_InitInputType), intent(in) :: SrcInitInputData
   type(ADsk_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADsk_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%InputFile = SrcInitInputData%InputFile
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%RotorRad = SrcInitInputData%RotorRad
   DstInitInputData%HubPosition = SrcInitInputData%HubPosition
   DstInitInputData%HubOrientation = SrcInitInputData%HubOrientation
   DstInitInputData%defAirDens = SrcInitInputData%defAirDens
   DstInitInputData%Linearize = SrcInitInputData%Linearize
   DstInitInputData%UseInputFile = SrcInitInputData%UseInputFile
   call NWTC_Library_CopyFileInfoType(SrcInitInputData%PassedFileData, DstInitInputData%PassedFileData, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitInputData%FlowField => SrcInitInputData%FlowField
end subroutine

subroutine ADsk_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(ADsk_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADsk_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyFileInfoType(InitInputData%PassedFileData, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   nullify(InitInputData%FlowField)
end subroutine

subroutine ADsk_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADsk_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADsk_PackInitInput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%InputFile)
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%RotorRad)
   call RegPack(RF, InData%HubPosition)
   call RegPack(RF, InData%HubOrientation)
   call RegPack(RF, InData%defAirDens)
   call RegPack(RF, InData%Linearize)
   call RegPack(RF, InData%UseInputFile)
   call NWTC_Library_PackFileInfoType(RF, InData%PassedFileData) 
   call RegPack(RF, associated(InData%FlowField))
   if (associated(InData%FlowField)) then
      call RegPackPointer(RF, c_loc(InData%FlowField), PtrInIndex)
      if (.not. PtrInIndex) then
         call IfW_FlowField_PackFlowFieldType(RF, InData%FlowField) 
      end if
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADsk_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADsk_UnPackInitInput'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%InputFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotorRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubPosition); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%HubOrientation); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%defAirDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Linearize); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%UseInputFile); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackFileInfoType(RF, OutData%PassedFileData) ! PassedFileData 
   if (associated(OutData%FlowField)) deallocate(OutData%FlowField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%FlowField)
      else
         allocate(OutData%FlowField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FlowField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%FlowField)
         call IfW_FlowField_UnpackFlowFieldType(RF, OutData%FlowField) ! FlowField 
      end if
   else
      OutData%FlowField => null()
   end if
end subroutine

subroutine ADsk_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(ADsk_InitOutputType), intent(in) :: SrcInitOutputData
   type(ADsk_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADsk_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcInitOutputData%WriteOutputHdr)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputHdr)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputHdr)
      if (.not. allocated(DstInitOutputData%WriteOutputHdr)) then
         allocate(DstInitOutputData%WriteOutputHdr(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputHdr.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputHdr = SrcInitOutputData%WriteOutputHdr
   end if
   if (allocated(SrcInitOutputData%WriteOutputUnt)) then
      LB(1:1) = lbound(SrcInitOutputData%WriteOutputUnt)
      UB(1:1) = ubound(SrcInitOutputData%WriteOutputUnt)
      if (.not. allocated(DstInitOutputData%WriteOutputUnt)) then
         allocate(DstInitOutputData%WriteOutputUnt(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstInitOutputData%WriteOutputUnt.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstInitOutputData%WriteOutputUnt = SrcInitOutputData%WriteOutputUnt
   end if
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInitOutputData%AirDens = SrcInitOutputData%AirDens
end subroutine

subroutine ADsk_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(ADsk_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADsk_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(InitOutputData%WriteOutputHdr)) then
      deallocate(InitOutputData%WriteOutputHdr)
   end if
   if (allocated(InitOutputData%WriteOutputUnt)) then
      deallocate(InitOutputData%WriteOutputUnt)
   end if
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ADsk_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADsk_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADsk_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%WriteOutputHdr)
   call RegPackAlloc(RF, InData%WriteOutputUnt)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   call RegPack(RF, InData%AirDens)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADsk_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADsk_UnPackInitOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%WriteOutputHdr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutputUnt); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
   call RegUnpack(RF, OutData%AirDens); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(ADsk_InputType), intent(inout) :: SrcInputData
   type(ADsk_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADsk_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcInputData%HubMotion, DstInputData%HubMotion, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstInputData%RotSpeed = SrcInputData%RotSpeed
   DstInputData%BlPitch = SrcInputData%BlPitch
end subroutine

subroutine ADsk_DestroyInput(InputData, ErrStat, ErrMsg)
   type(ADsk_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADsk_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( InputData%HubMotion, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine ADsk_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADsk_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADsk_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%HubMotion) 
   call RegPack(RF, InData%RotSpeed)
   call RegPack(RF, InData%BlPitch)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADsk_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADsk_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%HubMotion) ! HubMotion 
   call RegUnpack(RF, OutData%RotSpeed); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%BlPitch); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(ADsk_OutputType), intent(inout) :: SrcOutputData
   type(ADsk_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADsk_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshCopy(SrcOutputData%AeroLoads, DstOutputData%AeroLoads, CtrlCode, ErrStat2, ErrMsg2 )
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstOutputData%YawErr = SrcOutputData%YawErr
   DstOutputData%PsiSkew = SrcOutputData%PsiSkew
   DstOutputData%ChiSkew = SrcOutputData%ChiSkew
   DstOutputData%VRel = SrcOutputData%VRel
   DstOutputData%Ct = SrcOutputData%Ct
   DstOutputData%Cq = SrcOutputData%Cq
   if (allocated(SrcOutputData%WriteOutput)) then
      LB(1:1) = lbound(SrcOutputData%WriteOutput)
      UB(1:1) = ubound(SrcOutputData%WriteOutput)
      if (.not. allocated(DstOutputData%WriteOutput)) then
         allocate(DstOutputData%WriteOutput(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%WriteOutput.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%WriteOutput = SrcOutputData%WriteOutput
   end if
end subroutine

subroutine ADsk_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(ADsk_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADsk_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MeshDestroy( OutputData%AeroLoads, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(OutputData%WriteOutput)) then
      deallocate(OutputData%WriteOutput)
   end if
end subroutine

subroutine ADsk_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADsk_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADsk_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call MeshPack(RF, InData%AeroLoads) 
   call RegPack(RF, InData%YawErr)
   call RegPack(RF, InData%PsiSkew)
   call RegPack(RF, InData%ChiSkew)
   call RegPack(RF, InData%VRel)
   call RegPack(RF, InData%Ct)
   call RegPack(RF, InData%Cq)
   call RegPackAlloc(RF, InData%WriteOutput)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADsk_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADsk_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MeshUnpack(RF, OutData%AeroLoads) ! AeroLoads 
   call RegUnpack(RF, OutData%YawErr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%PsiSkew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%ChiSkew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VRel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Ct); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Cq); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WriteOutput); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(ADsk_ContinuousStateType), intent(in) :: SrcContStateData
   type(ADsk_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ADsk_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstContStateData%DummyContState = SrcContStateData%DummyContState
end subroutine

subroutine ADsk_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(ADsk_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ADsk_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ADsk_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADsk_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADsk_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyContState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADsk_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADsk_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyContState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(ADsk_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(ADsk_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ADsk_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%DummyDiscreteState = SrcDiscStateData%DummyDiscreteState
end subroutine

subroutine ADsk_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(ADsk_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ADsk_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ADsk_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADsk_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADsk_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyDiscreteState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADsk_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADsk_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyDiscreteState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(ADsk_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(ADsk_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ADsk_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%DummyConstrState = SrcConstrStateData%DummyConstrState
end subroutine

subroutine ADsk_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(ADsk_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ADsk_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ADsk_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADsk_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADsk_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyConstrState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADsk_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADsk_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyConstrState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(ADsk_OtherStateType), intent(in) :: SrcOtherStateData
   type(ADsk_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ADsk_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%DummyOtherState = SrcOtherStateData%DummyOtherState
end subroutine

subroutine ADsk_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(ADsk_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ADsk_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine ADsk_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADsk_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADsk_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DummyOtherState)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADsk_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADsk_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DummyOtherState); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(ADsk_ParameterType), intent(in) :: SrcParamData
   type(ADsk_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADsk_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%RootName = SrcParamData%RootName
   DstParamData%DT = SrcParamData%DT
   DstParamData%RotorRad = SrcParamData%RotorRad
   DstParamData%AirDens = SrcParamData%AirDens
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%halfRhoA = SrcParamData%halfRhoA
   call ADsk_CopyAeroTable(SrcParamData%AeroTable, DstParamData%AeroTable, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstParamData%UseTSR = SrcParamData%UseTSR
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%FlowField => SrcParamData%FlowField
   if (allocated(SrcParamData%DiskWindPosRel)) then
      LB(1:2) = lbound(SrcParamData%DiskWindPosRel)
      UB(1:2) = ubound(SrcParamData%DiskWindPosRel)
      if (.not. allocated(DstParamData%DiskWindPosRel)) then
         allocate(DstParamData%DiskWindPosRel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%DiskWindPosRel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%DiskWindPosRel = SrcParamData%DiskWindPosRel
   end if
end subroutine

subroutine ADsk_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(ADsk_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'ADsk_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call ADsk_DestroyAeroTable(ParamData%AeroTable, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   nullify(ParamData%FlowField)
   if (allocated(ParamData%DiskWindPosRel)) then
      deallocate(ParamData%DiskWindPosRel)
   end if
end subroutine

subroutine ADsk_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADsk_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADsk_PackParam'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%RootName)
   call RegPack(RF, InData%DT)
   call RegPack(RF, InData%RotorRad)
   call RegPack(RF, InData%AirDens)
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%halfRhoA)
   call ADsk_PackAeroTable(RF, InData%AeroTable) 
   call RegPack(RF, InData%UseTSR)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPack(RF, associated(InData%FlowField))
   if (associated(InData%FlowField)) then
      call RegPackPointer(RF, c_loc(InData%FlowField), PtrInIndex)
      if (.not. PtrInIndex) then
         call IfW_FlowField_PackFlowFieldType(RF, InData%FlowField) 
      end if
   end if
   call RegPackAlloc(RF, InData%DiskWindPosRel)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADsk_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADsk_UnPackParam'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotorRad); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%AirDens); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%halfRhoA); if (RegCheckErr(RF, RoutineName)) return
   call ADsk_UnpackAeroTable(RF, OutData%AeroTable) ! AeroTable 
   call RegUnpack(RF, OutData%UseTSR); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   if (associated(OutData%FlowField)) deallocate(OutData%FlowField)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackPointer(RF, Ptr, PtrIdx); if (RegCheckErr(RF, RoutineName)) return
      if (c_associated(Ptr)) then
         call c_f_pointer(Ptr, OutData%FlowField)
      else
         allocate(OutData%FlowField,stat=stat)
         if (stat /= 0) then 
            call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FlowField.', RF%ErrStat, RF%ErrMsg, RoutineName)
            return
         end if
         RF%Pointers(PtrIdx) = c_loc(OutData%FlowField)
         call IfW_FlowField_UnpackFlowFieldType(RF, OutData%FlowField) ! FlowField 
      end if
   else
      OutData%FlowField => null()
   end if
   call RegUnpackAlloc(RF, OutData%DiskWindPosRel); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(ADsk_MiscVarType), intent(in) :: SrcMiscData
   type(ADsk_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'ADsk_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstMiscData%idx_last = SrcMiscData%idx_last
   if (allocated(SrcMiscData%AllOuts)) then
      LB(1:1) = lbound(SrcMiscData%AllOuts)
      UB(1:1) = ubound(SrcMiscData%AllOuts)
      if (.not. allocated(DstMiscData%AllOuts)) then
         allocate(DstMiscData%AllOuts(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AllOuts.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AllOuts = SrcMiscData%AllOuts
   end if
   DstMiscData%x_hat = SrcMiscData%x_hat
   DstMiscData%y_hat = SrcMiscData%y_hat
   DstMiscData%z_hat = SrcMiscData%z_hat
   DstMiscData%VRel = SrcMiscData%VRel
   DstMiscData%VRel_xd = SrcMiscData%VRel_xd
   DstMiscData%lambda = SrcMiscData%lambda
   DstMiscData%Chi = SrcMiscData%Chi
   DstMiscData%C_F = SrcMiscData%C_F
   DstMiscData%C_M = SrcMiscData%C_M
   DstMiscData%Force = SrcMiscData%Force
   DstMiscData%Moment = SrcMiscData%Moment
   if (allocated(SrcMiscData%DiskWindPosAbs)) then
      LB(1:2) = lbound(SrcMiscData%DiskWindPosAbs)
      UB(1:2) = ubound(SrcMiscData%DiskWindPosAbs)
      if (.not. allocated(DstMiscData%DiskWindPosAbs)) then
         allocate(DstMiscData%DiskWindPosAbs(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%DiskWindPosAbs.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%DiskWindPosAbs = SrcMiscData%DiskWindPosAbs
   end if
   if (allocated(SrcMiscData%DiskWindVel)) then
      LB(1:2) = lbound(SrcMiscData%DiskWindVel)
      UB(1:2) = ubound(SrcMiscData%DiskWindVel)
      if (.not. allocated(DstMiscData%DiskWindVel)) then
         allocate(DstMiscData%DiskWindVel(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%DiskWindVel.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%DiskWindVel = SrcMiscData%DiskWindVel
   end if
   DstMiscData%DiskAvgVel = SrcMiscData%DiskAvgVel
end subroutine

subroutine ADsk_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(ADsk_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'ADsk_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%AllOuts)) then
      deallocate(MiscData%AllOuts)
   end if
   if (allocated(MiscData%DiskWindPosAbs)) then
      deallocate(MiscData%DiskWindPosAbs)
   end if
   if (allocated(MiscData%DiskWindVel)) then
      deallocate(MiscData%DiskWindVel)
   end if
end subroutine

subroutine ADsk_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(ADsk_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'ADsk_PackMisc'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%idx_last)
   call RegPackAlloc(RF, InData%AllOuts)
   call RegPack(RF, InData%x_hat)
   call RegPack(RF, InData%y_hat)
   call RegPack(RF, InData%z_hat)
   call RegPack(RF, InData%VRel)
   call RegPack(RF, InData%VRel_xd)
   call RegPack(RF, InData%lambda)
   call RegPack(RF, InData%Chi)
   call RegPack(RF, InData%C_F)
   call RegPack(RF, InData%C_M)
   call RegPack(RF, InData%Force)
   call RegPack(RF, InData%Moment)
   call RegPackAlloc(RF, InData%DiskWindPosAbs)
   call RegPackAlloc(RF, InData%DiskWindVel)
   call RegPack(RF, InData%DiskAvgVel)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(ADsk_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'ADsk_UnPackMisc'
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%idx_last); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AllOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%x_hat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%y_hat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%z_hat); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VRel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VRel_xd); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%lambda); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Chi); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_F); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%C_M); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Force); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Moment); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DiskWindPosAbs); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%DiskWindVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DiskAvgVel); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine ADsk_Input_ExtrapInterp(u, t, u_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
   ! values of u (which has values associated with times in t).  Order of the interpolation is given by the size of u
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = u1, f(t2) = u2, f(t3) = u3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(ADsk_InputType), intent(inout)  :: u(:) ! Input at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Inputs
   type(ADsk_InputType), intent(inout)  :: u_out ! Input at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'ADsk_Input_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(u)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(u)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(u) - 1
   select case (order)
   case (0)
      call ADsk_CopyInput(u(1), u_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call ADsk_Input_ExtrapInterp1(u(1), u(2), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call ADsk_Input_ExtrapInterp2(u(1), u(2), u(3), t, u_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(u) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE ADsk_Input_ExtrapInterp1(u1, u2, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = u1, f(t2) = u2
!
!..................................................................................................................................

   TYPE(ADsk_InputType), INTENT(INOUT)  :: u1    ! Input at t1 > t2
   TYPE(ADsk_InputType), INTENT(INOUT)  :: u2    ! Input at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Inputs
   TYPE(ADsk_InputType), INTENT(INOUT)  :: u_out ! Input at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'ADsk_Input_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(u1%HubMotion, u2%HubMotion, tin, u_out%HubMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   u_out%RotSpeed = a1*u1%RotSpeed + a2*u2%RotSpeed
   CALL Angles_ExtrapInterp( u1%BlPitch, u2%BlPitch, tin, u_out%BlPitch, tin_out )
END SUBROUTINE

SUBROUTINE ADsk_Input_ExtrapInterp2(u1, u2, u3, tin, u_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Input u_out at time t_out, from previous/future time
! values of u (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = u1, f(t2) = u2, f(t3) = u3
!
!..................................................................................................................................

   TYPE(ADsk_InputType), INTENT(INOUT)  :: u1      ! Input at t1 > t2 > t3
   TYPE(ADsk_InputType), INTENT(INOUT)  :: u2      ! Input at t2 > t3
   TYPE(ADsk_InputType), INTENT(INOUT)  :: u3      ! Input at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Inputs
   TYPE(ADsk_InputType), INTENT(INOUT)  :: u_out     ! Input at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Inputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'ADsk_Input_ExtrapInterp2'
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(u1%HubMotion, u2%HubMotion, u3%HubMotion, tin, u_out%HubMotion, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   u_out%RotSpeed = a1*u1%RotSpeed + a2*u2%RotSpeed + a3*u3%RotSpeed
   CALL Angles_ExtrapInterp( u1%BlPitch, u2%BlPitch, u3%BlPitch, tin, u_out%BlPitch, tin_out )
END SUBROUTINE

subroutine ADsk_Output_ExtrapInterp(y, t, y_out, t_out, ErrStat, ErrMsg)
   !
   ! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
   ! values of y (which has values associated with times in t).  Order of the interpolation is given by the size of y
   !
   !  expressions below based on either
   !
   !  f(t) = a
   !  f(t) = a + b * t, or
   !  f(t) = a + b * t + c * t**2
   !
   !  where a, b and c are determined as the solution to
   !  f(t1) = y1, f(t2) = y2, f(t3) = y3  (as appropriate)
   !
   !----------------------------------------------------------------------------------------------------------------------------------
   
   type(ADsk_OutputType), intent(inout)  :: y(:) ! Output at t1 > t2 > t3
   real(DbKi),                 intent(in   )  :: t(:)           ! Times associated with the Outputs
   type(ADsk_OutputType), intent(inout)  :: y_out ! Output at tin_out
   real(DbKi),                 intent(in   )  :: t_out           ! time to be extrap/interp'd to
   integer(IntKi),             intent(  out)  :: ErrStat         ! Error status of the operation
   character(*),               intent(  out)  :: ErrMsg          ! Error message if ErrStat /= ErrID_None
   ! local variables
   integer(IntKi)                             :: order           ! order of polynomial fit (max 2)
   integer(IntKi)                             :: ErrStat2        ! local errors
   character(ErrMsgLen)                       :: ErrMsg2         ! local errors
   character(*),    PARAMETER                 :: RoutineName = 'ADsk_Output_ExtrapInterp'
   
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (size(t) /= size(y)) then
      call SetErrStat(ErrID_Fatal, 'size(t) must equal size(y)', ErrStat, ErrMsg, RoutineName)
      return
   endif
   order = size(y) - 1
   select case (order)
   case (0)
      call ADsk_CopyOutput(y(1), y_out, MESH_UPDATECOPY, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (1)
      call ADsk_Output_ExtrapInterp1(y(1), y(2), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case (2)
      call ADsk_Output_ExtrapInterp2(y(1), y(2), y(3), t, y_out, t_out, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   case default
      call SetErrStat(ErrID_Fatal, 'size(y) must be less than 4 (order must be less than 3).', ErrStat, ErrMsg, RoutineName)
      return
   end select
end subroutine

SUBROUTINE ADsk_Output_ExtrapInterp1(y1, y2, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 1.
!
!  f(t) = a + b * t, or
!
!  where a and b are determined as the solution to
!  f(t1) = y1, f(t2) = y2
!
!..................................................................................................................................

   TYPE(ADsk_OutputType), INTENT(INOUT)  :: y1    ! Output at t1 > t2
   TYPE(ADsk_OutputType), INTENT(INOUT)  :: y2    ! Output at t2 
   REAL(DbKi),         INTENT(IN   )          :: tin(2)   ! Times associated with the Outputs
   TYPE(ADsk_OutputType), INTENT(INOUT)  :: y_out ! Output at tin_out
   REAL(DbKi),         INTENT(IN   )          :: tin_out  ! time to be extrap/interp'd to
   INTEGER(IntKi),     INTENT(  OUT)          :: ErrStat  ! Error status of the operation
   CHARACTER(*),       INTENT(  OUT)          :: ErrMsg   ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(2)     ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out    ! Time to which to be extrap/interpd
   CHARACTER(*),                    PARAMETER :: RoutineName = 'ADsk_Output_ExtrapInterp1'
   REAL(DbKi)                                 :: a1, a2   ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   INTEGER                                    :: i01      ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1       ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF (EqualRealNos(t(1), t(2))) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg, RoutineName)
      RETURN
   END IF
   
   ! Calculate weighting factors from Lagrange polynomial
   a1 = -(t_out - t(2))/t(2)
   a2 = t_out/t(2)
   
   CALL MeshExtrapInterp1(y1%AeroLoads, y2%AeroLoads, tin, y_out%AeroLoads, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   y_out%YawErr = a1*y1%YawErr + a2*y2%YawErr
   y_out%PsiSkew = a1*y1%PsiSkew + a2*y2%PsiSkew
   y_out%ChiSkew = a1*y1%ChiSkew + a2*y2%ChiSkew
   y_out%VRel = a1*y1%VRel + a2*y2%VRel
   y_out%Ct = a1*y1%Ct + a2*y2%Ct
   y_out%Cq = a1*y1%Cq + a2*y2%Cq
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput
   END IF ! check if allocated
END SUBROUTINE

SUBROUTINE ADsk_Output_ExtrapInterp2(y1, y2, y3, tin, y_out, tin_out, ErrStat, ErrMsg )
!
! This subroutine calculates a extrapolated (or interpolated) Output y_out at time t_out, from previous/future time
! values of y (which has values associated with times in t).  Order of the interpolation is 2.
!
!  expressions below based on either
!
!  f(t) = a + b * t + c * t**2
!
!  where a, b and c are determined as the solution to
!  f(t1) = y1, f(t2) = y2, f(t3) = y3
!
!..................................................................................................................................

   TYPE(ADsk_OutputType), INTENT(INOUT)  :: y1      ! Output at t1 > t2 > t3
   TYPE(ADsk_OutputType), INTENT(INOUT)  :: y2      ! Output at t2 > t3
   TYPE(ADsk_OutputType), INTENT(INOUT)  :: y3      ! Output at t3
   REAL(DbKi),                 INTENT(IN   )  :: tin(3)    ! Times associated with the Outputs
   TYPE(ADsk_OutputType), INTENT(INOUT)  :: y_out     ! Output at tin_out
   REAL(DbKi),                 INTENT(IN   )  :: tin_out   ! time to be extrap/interp'd to
   INTEGER(IntKi),             INTENT(  OUT)  :: ErrStat   ! Error status of the operation
   CHARACTER(*),               INTENT(  OUT)  :: ErrMsg    ! Error message if ErrStat /= ErrID_None
   ! local variables
   REAL(DbKi)                                 :: t(3)      ! Times associated with the Outputs
   REAL(DbKi)                                 :: t_out     ! Time to which to be extrap/interpd
   INTEGER(IntKi)                             :: order     ! order of polynomial fit (max 2)
   REAL(DbKi)                                 :: a1,a2,a3 ! temporary for extrapolation/interpolation
   INTEGER(IntKi)                             :: ErrStat2 ! local errors
   CHARACTER(ErrMsgLen)                       :: ErrMsg2  ! local errors
   CHARACTER(*),            PARAMETER         :: RoutineName = 'ADsk_Output_ExtrapInterp2'
   INTEGER                                    :: i01    ! dim1 level 0 counter variable for arrays of ddts
   INTEGER                                    :: i1    ! dim1 counter variable for arrays
   ! Initialize ErrStat
   ErrStat = ErrID_None
   ErrMsg  = ''
   ! we'll subtract a constant from the times to resolve some 
   ! numerical issues when t gets large (and to simplify the equations)
   t = tin - tin(1)
   t_out = tin_out - tin(1)
   
   IF ( EqualRealNos( t(1), t(2) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(2) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(2), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(2) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   ELSE IF ( EqualRealNos( t(1), t(3) ) ) THEN
      CALL SetErrStat(ErrID_Fatal, 't(1) must not equal t(3) to avoid a division-by-zero error.', ErrStat, ErrMsg,RoutineName)
      RETURN
   END IF
   
   ! Calculate Lagrange polynomial coefficients
   a1 = (t_out - t(2))*(t_out - t(3))/((t(1) - t(2))*(t(1) - t(3)))
   a2 = (t_out - t(1))*(t_out - t(3))/((t(2) - t(1))*(t(2) - t(3)))
   a3 = (t_out - t(1))*(t_out - t(2))/((t(3) - t(1))*(t(3) - t(2)))
   CALL MeshExtrapInterp2(y1%AeroLoads, y2%AeroLoads, y3%AeroLoads, tin, y_out%AeroLoads, tin_out, ErrStat2, ErrMsg2)
      CALL SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg,RoutineName)
   y_out%YawErr = a1*y1%YawErr + a2*y2%YawErr + a3*y3%YawErr
   y_out%PsiSkew = a1*y1%PsiSkew + a2*y2%PsiSkew + a3*y3%PsiSkew
   y_out%ChiSkew = a1*y1%ChiSkew + a2*y2%ChiSkew + a3*y3%ChiSkew
   y_out%VRel = a1*y1%VRel + a2*y2%VRel + a3*y3%VRel
   y_out%Ct = a1*y1%Ct + a2*y2%Ct + a3*y3%Ct
   y_out%Cq = a1*y1%Cq + a2*y2%Cq + a3*y3%Cq
   IF (ALLOCATED(y_out%WriteOutput) .AND. ALLOCATED(y1%WriteOutput)) THEN
      y_out%WriteOutput = a1*y1%WriteOutput + a2*y2%WriteOutput + a3*y3%WriteOutput
   END IF ! check if allocated
END SUBROUTINE
END MODULE AeroDisk_Types
!ENDOFREGISTRYGENERATEDFILE
