!STARTOFREGISTRYGENERATEDFILE 'FAST_Farm_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! FAST_Farm_Types
!.................................................................................................................................
! This file is part of FAST_Farm.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in FAST_Farm. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE FAST_Farm_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE FASTWrapper_Types
USE WakeDynamics_Types
USE AWAE_Types
USE NWTC_Library
IMPLICIT NONE
    INTEGER(IntKi), PUBLIC, PARAMETER  :: NumFFModules = 5      ! The number of modules available in FAST.Farm [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: ModuleFF_None = 0      ! No module selected [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: ModuleFF_FWrap = 2      ! FAST Wrapper [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: ModuleFF_WD = 3      ! Wake Dynamics [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: ModuleFF_AWAE = 4      ! Ambient Wind and Array Effects [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: ModuleFF_MD = 5      ! Farm-level MoorDyn [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Mod_WAT_None = 0      ! WAT: off [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Mod_WAT_PreDef = 1      ! WAT: predefined turbulence boxes [-]
    INTEGER(IntKi), PUBLIC, PARAMETER  :: Mod_WAT_UserDef = 2      ! WAT: user defined turbulence boxes [-]
! =========  Farm_ParameterType  =======
  TYPE, PUBLIC :: Farm_ParameterType
    REAL(DbKi)  :: DT_low = 0.0_R8Ki      !< Time step for low-resolution wind data input files; will be used as the global FAST.Farm time step [seconds]
    REAL(DbKi)  :: DT_high = 0.0_R8Ki      !< High-resolution time step [seconds]
    REAL(DbKi)  :: TMax = 0.0_R8Ki      !< Total run time [seconds]
    INTEGER(IntKi)  :: n_high_low = 0_IntKi      !< Number of high-resolution time steps per low-resolution time step [-]
    INTEGER(IntKi)  :: NumTurbines = 0_IntKi      !< Number of turbines in the simulation [-]
    CHARACTER(1024)  :: WindFilePath      !< Path name of wind data files from ABLSolver precursor [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: WT_Position      !< X-Y-Z position of each wind turbine; index 1 = XYZ; index 2 = turbine number [meters]
    INTEGER(IntKi)  :: WaveFieldMod = 0_IntKi      !< Wave field handling (-) (switch) {0: use individual HydroDyn inputs without adjustment, 1: adjust wave phases based on turbine offsets from farm origin} [-]
    INTEGER(IntKi)  :: MooringMod = 0_IntKi      !< Mod_SharedMooring is a flag for array-level mooring. (switch) {0: none, 3: yes/MoorDyn} [-]
    LOGICAL  :: WrMooringVis = .false.      !< Write shared mooring visualization (-) [only used for Mod_SharedMooring=3] [-]
    CHARACTER(1024)  :: MD_FileName      !< Name/location of the farm-level MoorDyn input file [-]
    REAL(DbKi)  :: DT_mooring = 0.0_R8Ki      !< Time step for farm-levem mooring coupling with each turbine [used only when Mod_SharedMooring > 0] [seconds]
    INTEGER(IntKi)  :: n_mooring = 0_IntKi      !< Number of FAST and MoorDyn time steps per FAST.Farm timestep when mooring > 0 [-]
    CHARACTER(1024) , DIMENSION(:), ALLOCATABLE  :: WT_FASTInFile      !< Name of input file for each turbine [-]
    CHARACTER(1024)  :: FTitle      !< The description line from the primary FAST.Farm input file [-]
    CHARACTER(1024)  :: OutFileRoot      !< The root name derived from the primary FAST.Farm input file [-]
    INTEGER(IntKi)  :: n_ChkptTime = 0_IntKi      !< Number of time steps between writing checkpoint files [-]
    REAL(DbKi)  :: TStart = 0.0_R8Ki      !< Time to begin tabular output [s]
    INTEGER(IntKi)  :: n_TMax = 0_IntKi      !< Number of the time step of TMax (the end time of the simulation) [-]
    REAL(ReKi)  :: RotorDiamRef = 0.0_ReKi      !< Reference turbine rotor diameter for wake calculations (m) [>0.0] [-]
    LOGICAL  :: SumPrint = .false.      !< Print summary data to file? (.sum) [-]
    LOGICAL  :: WrBinOutFile = .false.      !< Write a binary output file? (.outb) [-]
    LOGICAL  :: WrTxtOutFile = .false.      !< Write a text (formatted) output file? (.out) [-]
    CHARACTER(1)  :: Delim      !< Delimiter between columns of text output file (.out): space or tab [-]
    CHARACTER(20)  :: OutFmt      !< Format used for text tabular output (except time); resulting field should be 10 characters [-]
    CHARACTER(20)  :: OutFmt_t      !< Format used for time channel in text tabular output; resulting field should be 10 characters [-]
    INTEGER(IntKi)  :: FmtWidth = 0_IntKi      !< width of the time OutFmt specifier [-]
    INTEGER(IntKi)  :: TChanLen = 0_IntKi      !< width of the time channel [-]
    INTEGER(IntKi)  :: NOutTurb = 0_IntKi      !< Number of turbines for write output [1 to 9] [-]
    INTEGER(IntKi)  :: NOutRadii = 0_IntKi      !< Number of radial nodes for wake output for an individual rotor [0 to 20] [-]
    INTEGER(IntKi) , DIMENSION(:), ALLOCATABLE  :: OutRadii      !< List of radial nodes for wake output for an individual rotor [1 to NOutRadii] [-]
    INTEGER(IntKi)  :: NOutDist = 0_IntKi      !< Number of downstream distances for wake output for an individual rotor [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: OutDist      !< List of downstream distances for wake output for an individual rotor [1 to NOutDist] [meters]
    INTEGER(IntKi)  :: NWindVel = 0_IntKi      !< Number of points for wind output [0 to 9] [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WindVelX      !< List of coordinates in the X direction for wind output [1 to NWindVel] [meters]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WindVelY      !< List of coordinates in the Y direction for wind output [1 to NWindVel] [meters]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: WindVelZ      !< List of coordinates in the Z direction for wind output [1 to NWindVel] [meters]
    TYPE(OutParmType) , DIMENSION(:), ALLOCATABLE  :: OutParam      !< Names and units (and other characteristics) of all requested output parameter [-]
    INTEGER(IntKi)  :: NumOuts = 0_IntKi      !< Number of user-requested outputs [-]
    INTEGER(IntKi)  :: NOutSteps = 0_IntKi      !< Maximum number of output steps [-]
    CHARACTER(1024) , DIMENSION(1:3)  :: FileDescLines      !< File Description lines [-]
    TYPE(ProgDesc) , DIMENSION(1:NumModules)  :: Module_Ver      !< Version information from all modules [-]
    INTEGER(IntKi)  :: UnOu = 0_IntKi      !< File unit for Fast.Farm output data [-]
    REAL(ReKi)  :: dX_low = 0.0_ReKi      !< The spacing of the low-resolution nodes in X direction [m]
    REAL(ReKi)  :: dY_low = 0.0_ReKi      !< The spacing of the low-resolution nodes in Y direction [m]
    REAL(ReKi)  :: dZ_low = 0.0_ReKi      !< The spacing of the low-resolution nodes in Z direction [m]
    INTEGER(IntKi)  :: nX_low = 0_IntKi      !< Number of low-resolution spatial nodes in X direction [-]
    INTEGER(IntKi)  :: nY_low = 0_IntKi      !< Number of low-resolution spatial nodes in Y direction [-]
    INTEGER(IntKi)  :: nZ_low = 0_IntKi      !< Number of low-resolution spatial nodes in Z direction [-]
    REAL(ReKi)  :: X0_low = 0.0_ReKi      !< X-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi)  :: Y0_low = 0.0_ReKi      !< Y-component of the origin of the low-resolution spatial domain [m]
    REAL(ReKi)  :: Z0_low = 0.0_ReKi      !< Z-component of the origin of the low-resolution spatial domain [m]
    INTEGER(IntKi)  :: WAT = 0_IntKi      !< Switch between wake-added turbulence box options {0: no wake added turbulence, 1: predefined turbulence box, 2: user defined turbulence box} [-]
    CHARACTER(1024)  :: WAT_BoxFile      !< Filepath to the file containing the u-component of the turbulence box (either predefined or user-defined). [-]
    INTEGER(IntKi) , DIMENSION(1:3)  :: WAT_NxNyNz = 0_IntKi      !< Number of points in the x, y, and z directions of the WAT_BoxFile -- derived (WAT=1) or read from input file (WAT=2) [(m)]
    REAL(ReKi) , DIMENSION(1:3)  :: WAT_DxDyDz = 0.0_ReKi      !< Distance (in meters) between points in the x, y, and z directions of the WAT_BoxFile -- derived (WAT=1) or read from input file (WAT=2) [(m)]
    LOGICAL  :: WAT_ScaleBox = .false.      !< Flag to scale the input turbulence box to zero mean and unit standard deviation at every node [-]
  END TYPE Farm_ParameterType
! =======================
! =========  Farm_MiscVarType  =======
  TYPE, PUBLIC :: Farm_MiscVarType
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AllOuts      !< An array holding the value of all of the calculated (not only selected) output channels [see OutListParameters.xlsx spreadsheet]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: TimeData      !< Array to contain the time output data for the binary file (first output time and a time [fixed] increment) [-]
    REAL(ReKi) , DIMENSION(:,:), ALLOCATABLE  :: AllOutData      !< Array to contain all the output data (time history of all outputs); Index 1 is NumOuts, Index 2 is Time step [-]
    INTEGER(IntKi)  :: n_Out = 0_IntKi      !< Time index into the AllOutData array [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: FWrap_2_MD      !< Map platform kinematics from each FAST instance to MD [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: MD_2_FWrap      !< Map MD loads at the array level to each FAST instance [-]
  END TYPE Farm_MiscVarType
! =======================
! =========  FASTWrapper_Data  =======
  TYPE, PUBLIC :: FASTWrapper_Data
    TYPE(FWrap_ContinuousStateType)  :: x      !< Continuous states [-]
    TYPE(FWrap_DiscreteStateType)  :: xd      !< Discrete states [-]
    TYPE(FWrap_ConstraintStateType)  :: z      !< Constraint states [-]
    TYPE(FWrap_OtherStateType)  :: OtherSt      !< Other states [-]
    TYPE(FWrap_ParameterType)  :: p      !< Parameters [-]
    TYPE(FWrap_InputType)  :: u      !< System inputs [-]
    TYPE(FWrap_OutputType)  :: y      !< System outputs [-]
    TYPE(FWrap_MiscVarType)  :: m      !< Misc/optimization variables [-]
    LOGICAL  :: IsInitialized = .FALSE.      !< Has FWrap_Init been called [-]
  END TYPE FASTWrapper_Data
! =======================
! =========  WakeDynamics_Data  =======
  TYPE, PUBLIC :: WakeDynamics_Data
    TYPE(WD_ContinuousStateType)  :: x      !< Continuous states [-]
    TYPE(WD_DiscreteStateType)  :: xd      !< Discrete states [-]
    TYPE(WD_ConstraintStateType)  :: z      !< Constraint states [-]
    TYPE(WD_OtherStateType)  :: OtherSt      !< Other states [-]
    TYPE(WD_ParameterType)  :: p      !< Parameters [-]
    TYPE(WD_InputType)  :: u      !< System inputs [-]
    TYPE(WD_OutputType)  :: y      !< System outputs [-]
    TYPE(WD_MiscVarType)  :: m      !< Misc/optimization variables [-]
    LOGICAL  :: IsInitialized = .FALSE.      !< Has WD_Init been called [-]
  END TYPE WakeDynamics_Data
! =======================
! =========  AWAE_Data  =======
  TYPE, PUBLIC :: AWAE_Data
    TYPE(AWAE_ContinuousStateType)  :: x      !< Continuous states [-]
    TYPE(AWAE_DiscreteStateType)  :: xd      !< Discrete states [-]
    TYPE(AWAE_ConstraintStateType)  :: z      !< Constraint states [-]
    TYPE(AWAE_OtherStateType)  :: OtherSt      !< Other states [-]
    TYPE(AWAE_ParameterType)  :: p      !< Parameters [-]
    TYPE(AWAE_InputType)  :: u      !< System inputs [-]
    TYPE(AWAE_OutputType)  :: y      !< System outputs [-]
    TYPE(AWAE_MiscVarType)  :: m      !< Misc/optimization variables [-]
    LOGICAL  :: IsInitialized = .FALSE.      !< Has AWAE_Init been called [-]
  END TYPE AWAE_Data
! =======================
! =========  MD_Data  =======
  TYPE, PUBLIC :: MD_Data
    TYPE(MD_ContinuousStateType)  :: x      !< Continuous states [-]
    TYPE(MD_DiscreteStateType)  :: xd      !< Discrete states [-]
    TYPE(MD_ConstraintStateType)  :: z      !< Constraint states [-]
    TYPE(MD_OtherStateType)  :: OtherSt      !< Other states [-]
    TYPE(MD_ParameterType)  :: p      !< Parameters [-]
    TYPE(MD_InputType)  :: u      !< Extrapolated system inputs [-]
    TYPE(MD_InputType) , DIMENSION(:), ALLOCATABLE  :: Input      !< System inputs [-]
    REAL(DbKi) , DIMENSION(:), ALLOCATABLE  :: InputTimes      !< Current time [s]
    TYPE(MD_OutputType)  :: y      !< System outputs [-]
    TYPE(MD_MiscVarType)  :: m      !< Misc/optimization variables [-]
    LOGICAL  :: IsInitialized = .FALSE.      !< Has MD_Init been called [-]
    INTEGER(IntKi)  :: VTK_count = 0      !< Counter for VTK output of shared moorings [-]
    INTEGER(IntKi)  :: VTK_TWidth = 0_IntKi      !< width for VTK_count field in output name [-]
    character(1024)  :: VTK_OutFileRoot      !< Rootfilename for VTK output [-]
  END TYPE MD_Data
! =======================
! =========  WAT_IfW_data  =======
  TYPE, PUBLIC :: WAT_IfW_data
    TYPE(InflowWind_ContinuousStateType)  :: x      !< Continuous states [-]
    TYPE(InflowWind_DiscreteStateType)  :: xd      !< Discrete states [-]
    TYPE(InflowWind_ConstraintStateType)  :: z      !< Constraint states [-]
    TYPE(InflowWind_OtherStateType)  :: OtherSt      !< Other states [-]
    TYPE(InflowWind_ParameterType)  :: p      !< Parameters [-]
    TYPE(InflowWind_InputType)  :: u      !< System inputs [-]
    TYPE(InflowWind_OutputType)  :: y      !< System outputs [-]
    TYPE(InflowWind_MiscVarType)  :: m      !< Misc/optimization variables [-]
    LOGICAL  :: IsInitialized = .FALSE.      !< Has IfW_Init been called [-]
  END TYPE WAT_IfW_data
! =======================
! =========  All_FastFarm_Data  =======
  TYPE, PUBLIC :: All_FastFarm_Data
    TYPE(Farm_ParameterType)  :: p      !< FAST.Farm parameter data [-]
    TYPE(Farm_MiscVarType)  :: m      !< FAST.Farm misc var data [-]
    TYPE(FASTWrapper_Data) , DIMENSION(:), ALLOCATABLE  :: FWrap      !< FASTWrapper data (one instance per turbine) [-]
    TYPE(WakeDynamics_Data) , DIMENSION(:), ALLOCATABLE  :: WD      !< WakeDynamics (WD) data [-]
    TYPE(AWAE_Data)  :: AWAE      !< Ambient Wind & Array Effects (AWAE) data [-]
    TYPE(MD_Data)  :: MD      !< Farm-level MoorDyn model data [-]
    TYPE(WAT_IfW_data)  :: WAT_IfW      !< IfW data for WAT (temporary location until pointers are enabled) [-]
  END TYPE All_FastFarm_Data
! =======================
CONTAINS

subroutine Farm_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(Farm_ParameterType), intent(in) :: SrcParamData
   type(Farm_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%DT_low = SrcParamData%DT_low
   DstParamData%DT_high = SrcParamData%DT_high
   DstParamData%TMax = SrcParamData%TMax
   DstParamData%n_high_low = SrcParamData%n_high_low
   DstParamData%NumTurbines = SrcParamData%NumTurbines
   DstParamData%WindFilePath = SrcParamData%WindFilePath
   if (allocated(SrcParamData%WT_Position)) then
      LB(1:2) = lbound(SrcParamData%WT_Position)
      UB(1:2) = ubound(SrcParamData%WT_Position)
      if (.not. allocated(DstParamData%WT_Position)) then
         allocate(DstParamData%WT_Position(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WT_Position.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WT_Position = SrcParamData%WT_Position
   end if
   DstParamData%WaveFieldMod = SrcParamData%WaveFieldMod
   DstParamData%MooringMod = SrcParamData%MooringMod
   DstParamData%WrMooringVis = SrcParamData%WrMooringVis
   DstParamData%MD_FileName = SrcParamData%MD_FileName
   DstParamData%DT_mooring = SrcParamData%DT_mooring
   DstParamData%n_mooring = SrcParamData%n_mooring
   if (allocated(SrcParamData%WT_FASTInFile)) then
      LB(1:1) = lbound(SrcParamData%WT_FASTInFile)
      UB(1:1) = ubound(SrcParamData%WT_FASTInFile)
      if (.not. allocated(DstParamData%WT_FASTInFile)) then
         allocate(DstParamData%WT_FASTInFile(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WT_FASTInFile.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WT_FASTInFile = SrcParamData%WT_FASTInFile
   end if
   DstParamData%FTitle = SrcParamData%FTitle
   DstParamData%OutFileRoot = SrcParamData%OutFileRoot
   DstParamData%n_ChkptTime = SrcParamData%n_ChkptTime
   DstParamData%TStart = SrcParamData%TStart
   DstParamData%n_TMax = SrcParamData%n_TMax
   DstParamData%RotorDiamRef = SrcParamData%RotorDiamRef
   DstParamData%SumPrint = SrcParamData%SumPrint
   DstParamData%WrBinOutFile = SrcParamData%WrBinOutFile
   DstParamData%WrTxtOutFile = SrcParamData%WrTxtOutFile
   DstParamData%Delim = SrcParamData%Delim
   DstParamData%OutFmt = SrcParamData%OutFmt
   DstParamData%OutFmt_t = SrcParamData%OutFmt_t
   DstParamData%FmtWidth = SrcParamData%FmtWidth
   DstParamData%TChanLen = SrcParamData%TChanLen
   DstParamData%NOutTurb = SrcParamData%NOutTurb
   DstParamData%NOutRadii = SrcParamData%NOutRadii
   if (allocated(SrcParamData%OutRadii)) then
      LB(1:1) = lbound(SrcParamData%OutRadii)
      UB(1:1) = ubound(SrcParamData%OutRadii)
      if (.not. allocated(DstParamData%OutRadii)) then
         allocate(DstParamData%OutRadii(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutRadii.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%OutRadii = SrcParamData%OutRadii
   end if
   DstParamData%NOutDist = SrcParamData%NOutDist
   if (allocated(SrcParamData%OutDist)) then
      LB(1:1) = lbound(SrcParamData%OutDist)
      UB(1:1) = ubound(SrcParamData%OutDist)
      if (.not. allocated(DstParamData%OutDist)) then
         allocate(DstParamData%OutDist(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutDist.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%OutDist = SrcParamData%OutDist
   end if
   DstParamData%NWindVel = SrcParamData%NWindVel
   if (allocated(SrcParamData%WindVelX)) then
      LB(1:1) = lbound(SrcParamData%WindVelX)
      UB(1:1) = ubound(SrcParamData%WindVelX)
      if (.not. allocated(DstParamData%WindVelX)) then
         allocate(DstParamData%WindVelX(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WindVelX.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WindVelX = SrcParamData%WindVelX
   end if
   if (allocated(SrcParamData%WindVelY)) then
      LB(1:1) = lbound(SrcParamData%WindVelY)
      UB(1:1) = ubound(SrcParamData%WindVelY)
      if (.not. allocated(DstParamData%WindVelY)) then
         allocate(DstParamData%WindVelY(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WindVelY.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WindVelY = SrcParamData%WindVelY
   end if
   if (allocated(SrcParamData%WindVelZ)) then
      LB(1:1) = lbound(SrcParamData%WindVelZ)
      UB(1:1) = ubound(SrcParamData%WindVelZ)
      if (.not. allocated(DstParamData%WindVelZ)) then
         allocate(DstParamData%WindVelZ(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%WindVelZ.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%WindVelZ = SrcParamData%WindVelZ
   end if
   if (allocated(SrcParamData%OutParam)) then
      LB(1:1) = lbound(SrcParamData%OutParam)
      UB(1:1) = ubound(SrcParamData%OutParam)
      if (.not. allocated(DstParamData%OutParam)) then
         allocate(DstParamData%OutParam(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%OutParam.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyOutParmType(SrcParamData%OutParam(i1), DstParamData%OutParam(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   DstParamData%NumOuts = SrcParamData%NumOuts
   DstParamData%NOutSteps = SrcParamData%NOutSteps
   DstParamData%FileDescLines = SrcParamData%FileDescLines
   LB(1:1) = lbound(SrcParamData%Module_Ver)
   UB(1:1) = ubound(SrcParamData%Module_Ver)
   do i1 = LB(1), UB(1)
      call NWTC_Library_CopyProgDesc(SrcParamData%Module_Ver(i1), DstParamData%Module_Ver(i1), CtrlCode, ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      if (ErrStat >= AbortErrLev) return
   end do
   DstParamData%UnOu = SrcParamData%UnOu
   DstParamData%dX_low = SrcParamData%dX_low
   DstParamData%dY_low = SrcParamData%dY_low
   DstParamData%dZ_low = SrcParamData%dZ_low
   DstParamData%nX_low = SrcParamData%nX_low
   DstParamData%nY_low = SrcParamData%nY_low
   DstParamData%nZ_low = SrcParamData%nZ_low
   DstParamData%X0_low = SrcParamData%X0_low
   DstParamData%Y0_low = SrcParamData%Y0_low
   DstParamData%Z0_low = SrcParamData%Z0_low
   DstParamData%WAT = SrcParamData%WAT
   DstParamData%WAT_BoxFile = SrcParamData%WAT_BoxFile
   DstParamData%WAT_NxNyNz = SrcParamData%WAT_NxNyNz
   DstParamData%WAT_DxDyDz = SrcParamData%WAT_DxDyDz
   DstParamData%WAT_ScaleBox = SrcParamData%WAT_ScaleBox
end subroutine

subroutine Farm_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(Farm_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%WT_Position)) then
      deallocate(ParamData%WT_Position)
   end if
   if (allocated(ParamData%WT_FASTInFile)) then
      deallocate(ParamData%WT_FASTInFile)
   end if
   if (allocated(ParamData%OutRadii)) then
      deallocate(ParamData%OutRadii)
   end if
   if (allocated(ParamData%OutDist)) then
      deallocate(ParamData%OutDist)
   end if
   if (allocated(ParamData%WindVelX)) then
      deallocate(ParamData%WindVelX)
   end if
   if (allocated(ParamData%WindVelY)) then
      deallocate(ParamData%WindVelY)
   end if
   if (allocated(ParamData%WindVelZ)) then
      deallocate(ParamData%WindVelZ)
   end if
   if (allocated(ParamData%OutParam)) then
      LB(1:1) = lbound(ParamData%OutParam)
      UB(1:1) = ubound(ParamData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyOutParmType(ParamData%OutParam(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(ParamData%OutParam)
   end if
   LB(1:1) = lbound(ParamData%Module_Ver)
   UB(1:1) = ubound(ParamData%Module_Ver)
   do i1 = LB(1), UB(1)
      call NWTC_Library_DestroyProgDesc(ParamData%Module_Ver(i1), ErrStat2, ErrMsg2)
      call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   end do
end subroutine

subroutine Farm_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Farm_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Farm_PackParam'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%DT_low)
   call RegPack(RF, InData%DT_high)
   call RegPack(RF, InData%TMax)
   call RegPack(RF, InData%n_high_low)
   call RegPack(RF, InData%NumTurbines)
   call RegPack(RF, InData%WindFilePath)
   call RegPackAlloc(RF, InData%WT_Position)
   call RegPack(RF, InData%WaveFieldMod)
   call RegPack(RF, InData%MooringMod)
   call RegPack(RF, InData%WrMooringVis)
   call RegPack(RF, InData%MD_FileName)
   call RegPack(RF, InData%DT_mooring)
   call RegPack(RF, InData%n_mooring)
   call RegPackAlloc(RF, InData%WT_FASTInFile)
   call RegPack(RF, InData%FTitle)
   call RegPack(RF, InData%OutFileRoot)
   call RegPack(RF, InData%n_ChkptTime)
   call RegPack(RF, InData%TStart)
   call RegPack(RF, InData%n_TMax)
   call RegPack(RF, InData%RotorDiamRef)
   call RegPack(RF, InData%SumPrint)
   call RegPack(RF, InData%WrBinOutFile)
   call RegPack(RF, InData%WrTxtOutFile)
   call RegPack(RF, InData%Delim)
   call RegPack(RF, InData%OutFmt)
   call RegPack(RF, InData%OutFmt_t)
   call RegPack(RF, InData%FmtWidth)
   call RegPack(RF, InData%TChanLen)
   call RegPack(RF, InData%NOutTurb)
   call RegPack(RF, InData%NOutRadii)
   call RegPackAlloc(RF, InData%OutRadii)
   call RegPack(RF, InData%NOutDist)
   call RegPackAlloc(RF, InData%OutDist)
   call RegPack(RF, InData%NWindVel)
   call RegPackAlloc(RF, InData%WindVelX)
   call RegPackAlloc(RF, InData%WindVelY)
   call RegPackAlloc(RF, InData%WindVelZ)
   call RegPack(RF, allocated(InData%OutParam))
   if (allocated(InData%OutParam)) then
      call RegPackBounds(RF, 1, lbound(InData%OutParam), ubound(InData%OutParam))
      LB(1:1) = lbound(InData%OutParam)
      UB(1:1) = ubound(InData%OutParam)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackOutParmType(RF, InData%OutParam(i1)) 
      end do
   end if
   call RegPack(RF, InData%NumOuts)
   call RegPack(RF, InData%NOutSteps)
   call RegPack(RF, InData%FileDescLines)
   LB(1:1) = lbound(InData%Module_Ver)
   UB(1:1) = ubound(InData%Module_Ver)
   do i1 = LB(1), UB(1)
      call NWTC_Library_PackProgDesc(RF, InData%Module_Ver(i1)) 
   end do
   call RegPack(RF, InData%UnOu)
   call RegPack(RF, InData%dX_low)
   call RegPack(RF, InData%dY_low)
   call RegPack(RF, InData%dZ_low)
   call RegPack(RF, InData%nX_low)
   call RegPack(RF, InData%nY_low)
   call RegPack(RF, InData%nZ_low)
   call RegPack(RF, InData%X0_low)
   call RegPack(RF, InData%Y0_low)
   call RegPack(RF, InData%Z0_low)
   call RegPack(RF, InData%WAT)
   call RegPack(RF, InData%WAT_BoxFile)
   call RegPack(RF, InData%WAT_NxNyNz)
   call RegPack(RF, InData%WAT_DxDyDz)
   call RegPack(RF, InData%WAT_ScaleBox)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Farm_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Farm_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Farm_UnPackParam'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%DT_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_high_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NumTurbines); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WindFilePath); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WT_Position); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveFieldMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MooringMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrMooringVis); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%MD_FileName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DT_mooring); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_mooring); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WT_FASTInFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FTitle); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFileRoot); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_ChkptTime); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TStart); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_TMax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RotorDiamRef); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%SumPrint); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrBinOutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WrTxtOutFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Delim); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%OutFmt_t); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FmtWidth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TChanLen); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutTurb); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutRadii); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutRadii); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutDist); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%OutDist); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NWindVel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WindVelX); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WindVelY); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%WindVelZ); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%OutParam)) deallocate(OutData%OutParam)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%OutParam(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%OutParam.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackOutParmType(RF, OutData%OutParam(i1)) ! OutParam 
      end do
   end if
   call RegUnpack(RF, OutData%NumOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%NOutSteps); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FileDescLines); if (RegCheckErr(RF, RoutineName)) return
   LB(1:1) = lbound(OutData%Module_Ver)
   UB(1:1) = ubound(OutData%Module_Ver)
   do i1 = LB(1), UB(1)
      call NWTC_Library_UnpackProgDesc(RF, OutData%Module_Ver(i1)) ! Module_Ver 
   end do
   call RegUnpack(RF, OutData%UnOu); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dX_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dY_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dZ_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nX_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nY_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nZ_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%X0_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Y0_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%Z0_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_BoxFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_NxNyNz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_DxDyDz); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WAT_ScaleBox); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Farm_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(Farm_MiscVarType), intent(inout) :: SrcMiscData
   type(Farm_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)                  :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(SrcMiscData%AllOuts)) then
      LB(1:1) = lbound(SrcMiscData%AllOuts)
      UB(1:1) = ubound(SrcMiscData%AllOuts)
      if (.not. allocated(DstMiscData%AllOuts)) then
         allocate(DstMiscData%AllOuts(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AllOuts.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AllOuts = SrcMiscData%AllOuts
   end if
   if (allocated(SrcMiscData%TimeData)) then
      LB(1:1) = lbound(SrcMiscData%TimeData)
      UB(1:1) = ubound(SrcMiscData%TimeData)
      if (.not. allocated(DstMiscData%TimeData)) then
         allocate(DstMiscData%TimeData(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%TimeData.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%TimeData = SrcMiscData%TimeData
   end if
   if (allocated(SrcMiscData%AllOutData)) then
      LB(1:2) = lbound(SrcMiscData%AllOutData)
      UB(1:2) = ubound(SrcMiscData%AllOutData)
      if (.not. allocated(DstMiscData%AllOutData)) then
         allocate(DstMiscData%AllOutData(LB(1):UB(1),LB(2):UB(2)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AllOutData.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMiscData%AllOutData = SrcMiscData%AllOutData
   end if
   DstMiscData%n_Out = SrcMiscData%n_Out
   if (allocated(SrcMiscData%FWrap_2_MD)) then
      LB(1:1) = lbound(SrcMiscData%FWrap_2_MD)
      UB(1:1) = ubound(SrcMiscData%FWrap_2_MD)
      if (.not. allocated(DstMiscData%FWrap_2_MD)) then
         allocate(DstMiscData%FWrap_2_MD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%FWrap_2_MD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcMiscData%FWrap_2_MD(i1), DstMiscData%FWrap_2_MD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%MD_2_FWrap)) then
      LB(1:1) = lbound(SrcMiscData%MD_2_FWrap)
      UB(1:1) = ubound(SrcMiscData%MD_2_FWrap)
      if (.not. allocated(DstMiscData%MD_2_FWrap)) then
         allocate(DstMiscData%MD_2_FWrap(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%MD_2_FWrap.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcMiscData%MD_2_FWrap(i1), DstMiscData%MD_2_FWrap(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine Farm_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(Farm_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(MiscData%AllOuts)) then
      deallocate(MiscData%AllOuts)
   end if
   if (allocated(MiscData%TimeData)) then
      deallocate(MiscData%TimeData)
   end if
   if (allocated(MiscData%AllOutData)) then
      deallocate(MiscData%AllOutData)
   end if
   if (allocated(MiscData%FWrap_2_MD)) then
      LB(1:1) = lbound(MiscData%FWrap_2_MD)
      UB(1:1) = ubound(MiscData%FWrap_2_MD)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(MiscData%FWrap_2_MD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%FWrap_2_MD)
   end if
   if (allocated(MiscData%MD_2_FWrap)) then
      LB(1:1) = lbound(MiscData%MD_2_FWrap)
      UB(1:1) = ubound(MiscData%MD_2_FWrap)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(MiscData%MD_2_FWrap(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%MD_2_FWrap)
   end if
end subroutine

subroutine Farm_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(Farm_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Farm_PackMisc'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   if (RF%ErrStat >= AbortErrLev) return
   call RegPackAlloc(RF, InData%AllOuts)
   call RegPackAlloc(RF, InData%TimeData)
   call RegPackAlloc(RF, InData%AllOutData)
   call RegPack(RF, InData%n_Out)
   call RegPack(RF, allocated(InData%FWrap_2_MD))
   if (allocated(InData%FWrap_2_MD)) then
      call RegPackBounds(RF, 1, lbound(InData%FWrap_2_MD), ubound(InData%FWrap_2_MD))
      LB(1:1) = lbound(InData%FWrap_2_MD)
      UB(1:1) = ubound(InData%FWrap_2_MD)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%FWrap_2_MD(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%MD_2_FWrap))
   if (allocated(InData%MD_2_FWrap)) then
      call RegPackBounds(RF, 1, lbound(InData%MD_2_FWrap), ubound(InData%MD_2_FWrap))
      LB(1:1) = lbound(InData%MD_2_FWrap)
      UB(1:1) = ubound(InData%MD_2_FWrap)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%MD_2_FWrap(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Farm_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(Farm_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Farm_UnPackMisc'
   integer(B4Ki)   :: i1, i2
   integer(B4Ki)   :: LB(2), UB(2)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpackAlloc(RF, OutData%AllOuts); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%TimeData); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AllOutData); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_Out); if (RegCheckErr(RF, RoutineName)) return
   if (allocated(OutData%FWrap_2_MD)) deallocate(OutData%FWrap_2_MD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%FWrap_2_MD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FWrap_2_MD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%FWrap_2_MD(i1)) ! FWrap_2_MD 
      end do
   end if
   if (allocated(OutData%MD_2_FWrap)) deallocate(OutData%MD_2_FWrap)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%MD_2_FWrap(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%MD_2_FWrap.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%MD_2_FWrap(i1)) ! MD_2_FWrap 
      end do
   end if
end subroutine

subroutine Farm_CopyFASTWrapper_Data(SrcFASTWrapper_DataData, DstFASTWrapper_DataData, CtrlCode, ErrStat, ErrMsg)
   type(FASTWrapper_Data), intent(inout) :: SrcFASTWrapper_DataData
   type(FASTWrapper_Data), intent(inout) :: DstFASTWrapper_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_CopyFASTWrapper_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call FWrap_CopyContState(SrcFASTWrapper_DataData%x, DstFASTWrapper_DataData%x, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FWrap_CopyDiscState(SrcFASTWrapper_DataData%xd, DstFASTWrapper_DataData%xd, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FWrap_CopyConstrState(SrcFASTWrapper_DataData%z, DstFASTWrapper_DataData%z, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FWrap_CopyOtherState(SrcFASTWrapper_DataData%OtherSt, DstFASTWrapper_DataData%OtherSt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FWrap_CopyParam(SrcFASTWrapper_DataData%p, DstFASTWrapper_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FWrap_CopyInput(SrcFASTWrapper_DataData%u, DstFASTWrapper_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FWrap_CopyOutput(SrcFASTWrapper_DataData%y, DstFASTWrapper_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call FWrap_CopyMisc(SrcFASTWrapper_DataData%m, DstFASTWrapper_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstFASTWrapper_DataData%IsInitialized = SrcFASTWrapper_DataData%IsInitialized
end subroutine

subroutine Farm_DestroyFASTWrapper_Data(FASTWrapper_DataData, ErrStat, ErrMsg)
   type(FASTWrapper_Data), intent(inout) :: FASTWrapper_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_DestroyFASTWrapper_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call FWrap_DestroyContState(FASTWrapper_DataData%x, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FWrap_DestroyDiscState(FASTWrapper_DataData%xd, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FWrap_DestroyConstrState(FASTWrapper_DataData%z, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FWrap_DestroyOtherState(FASTWrapper_DataData%OtherSt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FWrap_DestroyParam(FASTWrapper_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FWrap_DestroyInput(FASTWrapper_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FWrap_DestroyOutput(FASTWrapper_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call FWrap_DestroyMisc(FASTWrapper_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine Farm_PackFASTWrapper_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FASTWrapper_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Farm_PackFASTWrapper_Data'
   if (RF%ErrStat >= AbortErrLev) return
   call FWrap_PackContState(RF, InData%x) 
   call FWrap_PackDiscState(RF, InData%xd) 
   call FWrap_PackConstrState(RF, InData%z) 
   call FWrap_PackOtherState(RF, InData%OtherSt) 
   call FWrap_PackParam(RF, InData%p) 
   call FWrap_PackInput(RF, InData%u) 
   call FWrap_PackOutput(RF, InData%y) 
   call FWrap_PackMisc(RF, InData%m) 
   call RegPack(RF, InData%IsInitialized)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Farm_UnPackFASTWrapper_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FASTWrapper_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Farm_UnPackFASTWrapper_Data'
   if (RF%ErrStat /= ErrID_None) return
   call FWrap_UnpackContState(RF, OutData%x) ! x 
   call FWrap_UnpackDiscState(RF, OutData%xd) ! xd 
   call FWrap_UnpackConstrState(RF, OutData%z) ! z 
   call FWrap_UnpackOtherState(RF, OutData%OtherSt) ! OtherSt 
   call FWrap_UnpackParam(RF, OutData%p) ! p 
   call FWrap_UnpackInput(RF, OutData%u) ! u 
   call FWrap_UnpackOutput(RF, OutData%y) ! y 
   call FWrap_UnpackMisc(RF, OutData%m) ! m 
   call RegUnpack(RF, OutData%IsInitialized); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Farm_CopyWakeDynamics_Data(SrcWakeDynamics_DataData, DstWakeDynamics_DataData, CtrlCode, ErrStat, ErrMsg)
   type(WakeDynamics_Data), intent(in) :: SrcWakeDynamics_DataData
   type(WakeDynamics_Data), intent(inout) :: DstWakeDynamics_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_CopyWakeDynamics_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call WD_CopyContState(SrcWakeDynamics_DataData%x, DstWakeDynamics_DataData%x, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call WD_CopyDiscState(SrcWakeDynamics_DataData%xd, DstWakeDynamics_DataData%xd, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call WD_CopyConstrState(SrcWakeDynamics_DataData%z, DstWakeDynamics_DataData%z, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call WD_CopyOtherState(SrcWakeDynamics_DataData%OtherSt, DstWakeDynamics_DataData%OtherSt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call WD_CopyParam(SrcWakeDynamics_DataData%p, DstWakeDynamics_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call WD_CopyInput(SrcWakeDynamics_DataData%u, DstWakeDynamics_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call WD_CopyOutput(SrcWakeDynamics_DataData%y, DstWakeDynamics_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call WD_CopyMisc(SrcWakeDynamics_DataData%m, DstWakeDynamics_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstWakeDynamics_DataData%IsInitialized = SrcWakeDynamics_DataData%IsInitialized
end subroutine

subroutine Farm_DestroyWakeDynamics_Data(WakeDynamics_DataData, ErrStat, ErrMsg)
   type(WakeDynamics_Data), intent(inout) :: WakeDynamics_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_DestroyWakeDynamics_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call WD_DestroyContState(WakeDynamics_DataData%x, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call WD_DestroyDiscState(WakeDynamics_DataData%xd, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call WD_DestroyConstrState(WakeDynamics_DataData%z, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call WD_DestroyOtherState(WakeDynamics_DataData%OtherSt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call WD_DestroyParam(WakeDynamics_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call WD_DestroyInput(WakeDynamics_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call WD_DestroyOutput(WakeDynamics_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call WD_DestroyMisc(WakeDynamics_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine Farm_PackWakeDynamics_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WakeDynamics_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Farm_PackWakeDynamics_Data'
   if (RF%ErrStat >= AbortErrLev) return
   call WD_PackContState(RF, InData%x) 
   call WD_PackDiscState(RF, InData%xd) 
   call WD_PackConstrState(RF, InData%z) 
   call WD_PackOtherState(RF, InData%OtherSt) 
   call WD_PackParam(RF, InData%p) 
   call WD_PackInput(RF, InData%u) 
   call WD_PackOutput(RF, InData%y) 
   call WD_PackMisc(RF, InData%m) 
   call RegPack(RF, InData%IsInitialized)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Farm_UnPackWakeDynamics_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WakeDynamics_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Farm_UnPackWakeDynamics_Data'
   if (RF%ErrStat /= ErrID_None) return
   call WD_UnpackContState(RF, OutData%x) ! x 
   call WD_UnpackDiscState(RF, OutData%xd) ! xd 
   call WD_UnpackConstrState(RF, OutData%z) ! z 
   call WD_UnpackOtherState(RF, OutData%OtherSt) ! OtherSt 
   call WD_UnpackParam(RF, OutData%p) ! p 
   call WD_UnpackInput(RF, OutData%u) ! u 
   call WD_UnpackOutput(RF, OutData%y) ! y 
   call WD_UnpackMisc(RF, OutData%m) ! m 
   call RegUnpack(RF, OutData%IsInitialized); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Farm_CopyAWAE_Data(SrcAWAE_DataData, DstAWAE_DataData, CtrlCode, ErrStat, ErrMsg)
   type(AWAE_Data), intent(in) :: SrcAWAE_DataData
   type(AWAE_Data), intent(inout) :: DstAWAE_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_CopyAWAE_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AWAE_CopyContState(SrcAWAE_DataData%x, DstAWAE_DataData%x, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AWAE_CopyDiscState(SrcAWAE_DataData%xd, DstAWAE_DataData%xd, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AWAE_CopyConstrState(SrcAWAE_DataData%z, DstAWAE_DataData%z, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AWAE_CopyOtherState(SrcAWAE_DataData%OtherSt, DstAWAE_DataData%OtherSt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AWAE_CopyParam(SrcAWAE_DataData%p, DstAWAE_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AWAE_CopyInput(SrcAWAE_DataData%u, DstAWAE_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AWAE_CopyOutput(SrcAWAE_DataData%y, DstAWAE_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call AWAE_CopyMisc(SrcAWAE_DataData%m, DstAWAE_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstAWAE_DataData%IsInitialized = SrcAWAE_DataData%IsInitialized
end subroutine

subroutine Farm_DestroyAWAE_Data(AWAE_DataData, ErrStat, ErrMsg)
   type(AWAE_Data), intent(inout) :: AWAE_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_DestroyAWAE_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call AWAE_DestroyContState(AWAE_DataData%x, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AWAE_DestroyDiscState(AWAE_DataData%xd, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AWAE_DestroyConstrState(AWAE_DataData%z, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AWAE_DestroyOtherState(AWAE_DataData%OtherSt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AWAE_DestroyParam(AWAE_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AWAE_DestroyInput(AWAE_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AWAE_DestroyOutput(AWAE_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call AWAE_DestroyMisc(AWAE_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine Farm_PackAWAE_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(AWAE_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Farm_PackAWAE_Data'
   if (RF%ErrStat >= AbortErrLev) return
   call AWAE_PackContState(RF, InData%x) 
   call AWAE_PackDiscState(RF, InData%xd) 
   call AWAE_PackConstrState(RF, InData%z) 
   call AWAE_PackOtherState(RF, InData%OtherSt) 
   call AWAE_PackParam(RF, InData%p) 
   call AWAE_PackInput(RF, InData%u) 
   call AWAE_PackOutput(RF, InData%y) 
   call AWAE_PackMisc(RF, InData%m) 
   call RegPack(RF, InData%IsInitialized)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Farm_UnPackAWAE_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(AWAE_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Farm_UnPackAWAE_Data'
   if (RF%ErrStat /= ErrID_None) return
   call AWAE_UnpackContState(RF, OutData%x) ! x 
   call AWAE_UnpackDiscState(RF, OutData%xd) ! xd 
   call AWAE_UnpackConstrState(RF, OutData%z) ! z 
   call AWAE_UnpackOtherState(RF, OutData%OtherSt) ! OtherSt 
   call AWAE_UnpackParam(RF, OutData%p) ! p 
   call AWAE_UnpackInput(RF, OutData%u) ! u 
   call AWAE_UnpackOutput(RF, OutData%y) ! y 
   call AWAE_UnpackMisc(RF, OutData%m) ! m 
   call RegUnpack(RF, OutData%IsInitialized); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Farm_CopyMD_Data(SrcMD_DataData, DstMD_DataData, CtrlCode, ErrStat, ErrMsg)
   type(MD_Data), intent(inout) :: SrcMD_DataData
   type(MD_Data), intent(inout) :: DstMD_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_CopyMD_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MD_CopyContState(SrcMD_DataData%x, DstMD_DataData%x, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MD_CopyDiscState(SrcMD_DataData%xd, DstMD_DataData%xd, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MD_CopyConstrState(SrcMD_DataData%z, DstMD_DataData%z, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MD_CopyOtherState(SrcMD_DataData%OtherSt, DstMD_DataData%OtherSt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MD_CopyParam(SrcMD_DataData%p, DstMD_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MD_CopyInput(SrcMD_DataData%u, DstMD_DataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMD_DataData%Input)) then
      LB(1:1) = lbound(SrcMD_DataData%Input)
      UB(1:1) = ubound(SrcMD_DataData%Input)
      if (.not. allocated(DstMD_DataData%Input)) then
         allocate(DstMD_DataData%Input(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMD_DataData%Input.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MD_CopyInput(SrcMD_DataData%Input(i1), DstMD_DataData%Input(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMD_DataData%InputTimes)) then
      LB(1:1) = lbound(SrcMD_DataData%InputTimes)
      UB(1:1) = ubound(SrcMD_DataData%InputTimes)
      if (.not. allocated(DstMD_DataData%InputTimes)) then
         allocate(DstMD_DataData%InputTimes(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMD_DataData%InputTimes.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstMD_DataData%InputTimes = SrcMD_DataData%InputTimes
   end if
   call MD_CopyOutput(SrcMD_DataData%y, DstMD_DataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call MD_CopyMisc(SrcMD_DataData%m, DstMD_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstMD_DataData%IsInitialized = SrcMD_DataData%IsInitialized
   DstMD_DataData%VTK_count = SrcMD_DataData%VTK_count
   DstMD_DataData%VTK_TWidth = SrcMD_DataData%VTK_TWidth
   DstMD_DataData%VTK_OutFileRoot = SrcMD_DataData%VTK_OutFileRoot
end subroutine

subroutine Farm_DestroyMD_Data(MD_DataData, ErrStat, ErrMsg)
   type(MD_Data), intent(inout) :: MD_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_DestroyMD_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call MD_DestroyContState(MD_DataData%x, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MD_DestroyDiscState(MD_DataData%xd, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MD_DestroyConstrState(MD_DataData%z, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MD_DestroyOtherState(MD_DataData%OtherSt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MD_DestroyParam(MD_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MD_DestroyInput(MD_DataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MD_DataData%Input)) then
      LB(1:1) = lbound(MD_DataData%Input)
      UB(1:1) = ubound(MD_DataData%Input)
      do i1 = LB(1), UB(1)
         call MD_DestroyInput(MD_DataData%Input(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MD_DataData%Input)
   end if
   if (allocated(MD_DataData%InputTimes)) then
      deallocate(MD_DataData%InputTimes)
   end if
   call MD_DestroyOutput(MD_DataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call MD_DestroyMisc(MD_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine Farm_PackMD_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(MD_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Farm_PackMD_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call MD_PackContState(RF, InData%x) 
   call MD_PackDiscState(RF, InData%xd) 
   call MD_PackConstrState(RF, InData%z) 
   call MD_PackOtherState(RF, InData%OtherSt) 
   call MD_PackParam(RF, InData%p) 
   call MD_PackInput(RF, InData%u) 
   call RegPack(RF, allocated(InData%Input))
   if (allocated(InData%Input)) then
      call RegPackBounds(RF, 1, lbound(InData%Input), ubound(InData%Input))
      LB(1:1) = lbound(InData%Input)
      UB(1:1) = ubound(InData%Input)
      do i1 = LB(1), UB(1)
         call MD_PackInput(RF, InData%Input(i1)) 
      end do
   end if
   call RegPackAlloc(RF, InData%InputTimes)
   call MD_PackOutput(RF, InData%y) 
   call MD_PackMisc(RF, InData%m) 
   call RegPack(RF, InData%IsInitialized)
   call RegPack(RF, InData%VTK_count)
   call RegPack(RF, InData%VTK_TWidth)
   call RegPack(RF, InData%VTK_OutFileRoot)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Farm_UnPackMD_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(MD_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Farm_UnPackMD_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call MD_UnpackContState(RF, OutData%x) ! x 
   call MD_UnpackDiscState(RF, OutData%xd) ! xd 
   call MD_UnpackConstrState(RF, OutData%z) ! z 
   call MD_UnpackOtherState(RF, OutData%OtherSt) ! OtherSt 
   call MD_UnpackParam(RF, OutData%p) ! p 
   call MD_UnpackInput(RF, OutData%u) ! u 
   if (allocated(OutData%Input)) deallocate(OutData%Input)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%Input(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%Input.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MD_UnpackInput(RF, OutData%Input(i1)) ! Input 
      end do
   end if
   call RegUnpackAlloc(RF, OutData%InputTimes); if (RegCheckErr(RF, RoutineName)) return
   call MD_UnpackOutput(RF, OutData%y) ! y 
   call MD_UnpackMisc(RF, OutData%m) ! m 
   call RegUnpack(RF, OutData%IsInitialized); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_count); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_TWidth); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%VTK_OutFileRoot); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Farm_CopyWAT_IfW_data(SrcWAT_IfW_dataData, DstWAT_IfW_dataData, CtrlCode, ErrStat, ErrMsg)
   type(WAT_IfW_data), intent(in) :: SrcWAT_IfW_dataData
   type(WAT_IfW_data), intent(inout) :: DstWAT_IfW_dataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_CopyWAT_IfW_data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call InflowWind_CopyContState(SrcWAT_IfW_dataData%x, DstWAT_IfW_dataData%x, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyDiscState(SrcWAT_IfW_dataData%xd, DstWAT_IfW_dataData%xd, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyConstrState(SrcWAT_IfW_dataData%z, DstWAT_IfW_dataData%z, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyOtherState(SrcWAT_IfW_dataData%OtherSt, DstWAT_IfW_dataData%OtherSt, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyParam(SrcWAT_IfW_dataData%p, DstWAT_IfW_dataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyInput(SrcWAT_IfW_dataData%u, DstWAT_IfW_dataData%u, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyOutput(SrcWAT_IfW_dataData%y, DstWAT_IfW_dataData%y, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call InflowWind_CopyMisc(SrcWAT_IfW_dataData%m, DstWAT_IfW_dataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   DstWAT_IfW_dataData%IsInitialized = SrcWAT_IfW_dataData%IsInitialized
end subroutine

subroutine Farm_DestroyWAT_IfW_data(WAT_IfW_dataData, ErrStat, ErrMsg)
   type(WAT_IfW_data), intent(inout) :: WAT_IfW_dataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_DestroyWAT_IfW_data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call InflowWind_DestroyContState(WAT_IfW_dataData%x, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyDiscState(WAT_IfW_dataData%xd, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyConstrState(WAT_IfW_dataData%z, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyOtherState(WAT_IfW_dataData%OtherSt, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyParam(WAT_IfW_dataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyInput(WAT_IfW_dataData%u, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyOutput(WAT_IfW_dataData%y, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call InflowWind_DestroyMisc(WAT_IfW_dataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine Farm_PackWAT_IfW_data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(WAT_IfW_data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Farm_PackWAT_IfW_data'
   if (RF%ErrStat >= AbortErrLev) return
   call InflowWind_PackContState(RF, InData%x) 
   call InflowWind_PackDiscState(RF, InData%xd) 
   call InflowWind_PackConstrState(RF, InData%z) 
   call InflowWind_PackOtherState(RF, InData%OtherSt) 
   call InflowWind_PackParam(RF, InData%p) 
   call InflowWind_PackInput(RF, InData%u) 
   call InflowWind_PackOutput(RF, InData%y) 
   call InflowWind_PackMisc(RF, InData%m) 
   call RegPack(RF, InData%IsInitialized)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Farm_UnPackWAT_IfW_data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(WAT_IfW_data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Farm_UnPackWAT_IfW_data'
   if (RF%ErrStat /= ErrID_None) return
   call InflowWind_UnpackContState(RF, OutData%x) ! x 
   call InflowWind_UnpackDiscState(RF, OutData%xd) ! xd 
   call InflowWind_UnpackConstrState(RF, OutData%z) ! z 
   call InflowWind_UnpackOtherState(RF, OutData%OtherSt) ! OtherSt 
   call InflowWind_UnpackParam(RF, OutData%p) ! p 
   call InflowWind_UnpackInput(RF, OutData%u) ! u 
   call InflowWind_UnpackOutput(RF, OutData%y) ! y 
   call InflowWind_UnpackMisc(RF, OutData%m) ! m 
   call RegUnpack(RF, OutData%IsInitialized); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Farm_CopyAll_FastFarm_Data(SrcAll_FastFarm_DataData, DstAll_FastFarm_DataData, CtrlCode, ErrStat, ErrMsg)
   type(All_FastFarm_Data), intent(inout) :: SrcAll_FastFarm_DataData
   type(All_FastFarm_Data), intent(inout) :: DstAll_FastFarm_DataData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_CopyAll_FastFarm_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call Farm_CopyParam(SrcAll_FastFarm_DataData%p, DstAll_FastFarm_DataData%p, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Farm_CopyMisc(SrcAll_FastFarm_DataData%m, DstAll_FastFarm_DataData%m, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcAll_FastFarm_DataData%FWrap)) then
      LB(1:1) = lbound(SrcAll_FastFarm_DataData%FWrap)
      UB(1:1) = ubound(SrcAll_FastFarm_DataData%FWrap)
      if (.not. allocated(DstAll_FastFarm_DataData%FWrap)) then
         allocate(DstAll_FastFarm_DataData%FWrap(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAll_FastFarm_DataData%FWrap.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Farm_CopyFASTWrapper_Data(SrcAll_FastFarm_DataData%FWrap(i1), DstAll_FastFarm_DataData%FWrap(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcAll_FastFarm_DataData%WD)) then
      LB(1:1) = lbound(SrcAll_FastFarm_DataData%WD)
      UB(1:1) = ubound(SrcAll_FastFarm_DataData%WD)
      if (.not. allocated(DstAll_FastFarm_DataData%WD)) then
         allocate(DstAll_FastFarm_DataData%WD(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstAll_FastFarm_DataData%WD.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call Farm_CopyWakeDynamics_Data(SrcAll_FastFarm_DataData%WD(i1), DstAll_FastFarm_DataData%WD(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   call Farm_CopyAWAE_Data(SrcAll_FastFarm_DataData%AWAE, DstAll_FastFarm_DataData%AWAE, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Farm_CopyMD_Data(SrcAll_FastFarm_DataData%MD, DstAll_FastFarm_DataData%MD, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   call Farm_CopyWAT_IfW_data(SrcAll_FastFarm_DataData%WAT_IfW, DstAll_FastFarm_DataData%WAT_IfW, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine Farm_DestroyAll_FastFarm_Data(All_FastFarm_DataData, ErrStat, ErrMsg)
   type(All_FastFarm_Data), intent(inout) :: All_FastFarm_DataData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'Farm_DestroyAll_FastFarm_Data'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call Farm_DestroyParam(All_FastFarm_DataData%p, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Farm_DestroyMisc(All_FastFarm_DataData%m, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(All_FastFarm_DataData%FWrap)) then
      LB(1:1) = lbound(All_FastFarm_DataData%FWrap)
      UB(1:1) = ubound(All_FastFarm_DataData%FWrap)
      do i1 = LB(1), UB(1)
         call Farm_DestroyFASTWrapper_Data(All_FastFarm_DataData%FWrap(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(All_FastFarm_DataData%FWrap)
   end if
   if (allocated(All_FastFarm_DataData%WD)) then
      LB(1:1) = lbound(All_FastFarm_DataData%WD)
      UB(1:1) = ubound(All_FastFarm_DataData%WD)
      do i1 = LB(1), UB(1)
         call Farm_DestroyWakeDynamics_Data(All_FastFarm_DataData%WD(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(All_FastFarm_DataData%WD)
   end if
   call Farm_DestroyAWAE_Data(All_FastFarm_DataData%AWAE, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Farm_DestroyMD_Data(All_FastFarm_DataData%MD, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   call Farm_DestroyWAT_IfW_data(All_FastFarm_DataData%WAT_IfW, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine Farm_PackAll_FastFarm_Data(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(All_FastFarm_Data), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'Farm_PackAll_FastFarm_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call Farm_PackParam(RF, InData%p) 
   call Farm_PackMisc(RF, InData%m) 
   call RegPack(RF, allocated(InData%FWrap))
   if (allocated(InData%FWrap)) then
      call RegPackBounds(RF, 1, lbound(InData%FWrap), ubound(InData%FWrap))
      LB(1:1) = lbound(InData%FWrap)
      UB(1:1) = ubound(InData%FWrap)
      do i1 = LB(1), UB(1)
         call Farm_PackFASTWrapper_Data(RF, InData%FWrap(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%WD))
   if (allocated(InData%WD)) then
      call RegPackBounds(RF, 1, lbound(InData%WD), ubound(InData%WD))
      LB(1:1) = lbound(InData%WD)
      UB(1:1) = ubound(InData%WD)
      do i1 = LB(1), UB(1)
         call Farm_PackWakeDynamics_Data(RF, InData%WD(i1)) 
      end do
   end if
   call Farm_PackAWAE_Data(RF, InData%AWAE) 
   call Farm_PackMD_Data(RF, InData%MD) 
   call Farm_PackWAT_IfW_data(RF, InData%WAT_IfW) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine Farm_UnPackAll_FastFarm_Data(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(All_FastFarm_Data), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'Farm_UnPackAll_FastFarm_Data'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call Farm_UnpackParam(RF, OutData%p) ! p 
   call Farm_UnpackMisc(RF, OutData%m) ! m 
   if (allocated(OutData%FWrap)) deallocate(OutData%FWrap)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%FWrap(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%FWrap.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Farm_UnpackFASTWrapper_Data(RF, OutData%FWrap(i1)) ! FWrap 
      end do
   end if
   if (allocated(OutData%WD)) deallocate(OutData%WD)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%WD(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%WD.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call Farm_UnpackWakeDynamics_Data(RF, OutData%WD(i1)) ! WD 
      end do
   end if
   call Farm_UnpackAWAE_Data(RF, OutData%AWAE) ! AWAE 
   call Farm_UnpackMD_Data(RF, OutData%MD) ! MD 
   call Farm_UnpackWAT_IfW_data(RF, OutData%WAT_IfW) ! WAT_IfW 
end subroutine
END MODULE FAST_Farm_Types
!ENDOFREGISTRYGENERATEDFILE
