!STARTOFREGISTRYGENERATEDFILE 'FASTWrapper_Types.f90'
!
! WARNING This file is generated automatically by the FAST registry.
! Do not edit.  Your changes to this file will be lost.
!
! FAST Registry
!*********************************************************************************************************************************
! FASTWrapper_Types
!.................................................................................................................................
! This file is part of FASTWrapper.
!
! Copyright (C) 2012-2016 National Renewable Energy Laboratory
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!
! W A R N I N G : This file was automatically generated from the FAST registry.  Changes made to this file may be lost.
!
!*********************************************************************************************************************************
!> This module contains the user-defined types needed in FASTWrapper. It also contains copy, destroy, pack, and
!! unpack routines associated with each defined data type. This code is automatically generated by the FAST Registry.
MODULE FASTWrapper_Types
!---------------------------------------------------------------------------------------------------------------------------------
USE FAST_Types
USE NWTC_Library
IMPLICIT NONE
! =========  FWrap_InitInputType  =======
  TYPE, PUBLIC :: FWrap_InitInputType
    INTEGER(IntKi)  :: nr = 0_IntKi      !< Number of radii in the radial finite-difference grid [-]
    CHARACTER(1024)  :: FASTInFile      !< Filename of primary FAST input file of this turbine [-]
    REAL(ReKi)  :: dr = 0.0_ReKi      !< Radial increment of radial finite-difference grid [m]
    REAL(DbKi)  :: tmax = 0.0_R8Ki      !< Simulation length [s]
    REAL(ReKi) , DIMENSION(1:3)  :: p_ref_Turbine = 0.0_ReKi      !< Undisplaced global coordinates of this turbine [m]
    INTEGER(IntKi)  :: WaveFieldMod = 0_IntKi      !< Wave field handling (-) (switch) 0: use individual HydroDyn inputs without adjustment, 1: adjust wave phases based on turbine offsets from farm origin [-]
    INTEGER(IntKi)  :: n_high_low = 0_IntKi      !< Number of high-resolution time steps per low-resolution time step [-]
    REAL(DbKi)  :: dt_high = 0.0_R8Ki      !< High-resolution time step [s]
    REAL(ReKi) , DIMENSION(1:3)  :: p_ref_high = 0.0_ReKi      !< Position of the origin of the high-resolution spatial domain for this turbine [m]
    INTEGER(IntKi)  :: nX_high = 0_IntKi      !< Number of high-resolution spatial nodes in X direction [-]
    INTEGER(IntKi)  :: nY_high = 0_IntKi      !< Number of high-resolution spatial nodes in Y direction [-]
    INTEGER(IntKi)  :: nZ_high = 0_IntKi      !< Number of high-resolution spatial nodes in Z direction [-]
    REAL(ReKi)  :: dX_high = 0.0_ReKi      !< X-component of the spatial increment of the high-resolution spatial domain for this turbine [m]
    REAL(ReKi)  :: dY_high = 0.0_ReKi      !< Y-component of the spatial increment of the high-resolution spatial domain for this turbine [m]
    REAL(ReKi)  :: dZ_high = 0.0_ReKi      !< Z-component of the spatial increment of the high-resolution spatial domain for this turbine [m]
    INTEGER(IntKi)  :: TurbNum = 0_IntKi      !< Turbine ID number (start with 1; end with number of turbines) [-]
    CHARACTER(1024)  :: RootName      !< The root name derived from the primary FAST.Farm input file [For output reporting in this module we need to have Rootname include the turbine number] [-]
    REAL(SiKi) , DIMENSION(:,:,:,:,:), POINTER  :: Vdist_High => NULL()      !< Pointer to UVW components of disturbed wind [nx^high, ny^high, nz^high, n^high/low] (ambient + deficits) across the high-resolution domain around the turbine for each high-resolution time step within a low-resolution time step [(m/s)]
  END TYPE FWrap_InitInputType
! =======================
! =========  FWrap_InitOutputType  =======
  TYPE, PUBLIC :: FWrap_InitOutputType
    REAL(DbKi) , DIMENSION(1:6)  :: PtfmInit = 0.0_R8Ki      !< Initial platform position/rotation vector - surge,sway,heave,roll,pitch,yaw - needed for mooring module initInp [-]
    TYPE(ProgDesc)  :: Ver      !< This module's name, version, and date [-]
  END TYPE FWrap_InitOutputType
! =======================
! =========  FWrap_ContinuousStateType  =======
  TYPE, PUBLIC :: FWrap_ContinuousStateType
    REAL(ReKi)  :: dummy = 0.0_ReKi      !< Remove this variable if you have continuous states [-]
  END TYPE FWrap_ContinuousStateType
! =======================
! =========  FWrap_DiscreteStateType  =======
  TYPE, PUBLIC :: FWrap_DiscreteStateType
    REAL(ReKi)  :: dummy = 0.0_ReKi      !< Remove this variable if you have continuous states [-]
  END TYPE FWrap_DiscreteStateType
! =======================
! =========  FWrap_ConstraintStateType  =======
  TYPE, PUBLIC :: FWrap_ConstraintStateType
    REAL(ReKi)  :: dummy = 0.0_ReKi      !< Remove this variable if you have constraint states [-]
  END TYPE FWrap_ConstraintStateType
! =======================
! =========  FWrap_OtherStateType  =======
  TYPE, PUBLIC :: FWrap_OtherStateType
    INTEGER(IntKi)  :: dummy = 0_IntKi      !< Remove this variable if you have other states [-]
  END TYPE FWrap_OtherStateType
! =======================
! =========  FWrap_MiscVarType  =======
  TYPE, PUBLIC :: FWrap_MiscVarType
    TYPE(FAST_TurbineType)  :: Turbine      !< Data for this FAST instance [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: TempDisp      !< temp displacement mesh (for AzimAvg_Ct) [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: TempLoads      !< temp loads mesh (for AzimAvg_Ct) [-]
    TYPE(MeshType) , DIMENSION(:), ALLOCATABLE  :: ADRotorDisk      !< Mesh that does not deflect with the blade (for AzimAvg_Ct) [-]
    TYPE(MeshMapType) , DIMENSION(:), ALLOCATABLE  :: AD_L2L      !< Map AD loads from deflected mesh to rotor-disk plane [-]
  END TYPE FWrap_MiscVarType
! =======================
! =========  FWrap_ParameterType  =======
  TYPE, PUBLIC :: FWrap_ParameterType
    INTEGER(IntKi)  :: nr = 0_IntKi      !< Number of radii in the radial finite-difference grid [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: r      !< Discretization of radial finite-difference grid [m]
    INTEGER(IntKi)  :: n_FAST_low = 0_IntKi      !< Number of FAST time steps per low-resolution time step [-]
    REAL(ReKi) , DIMENSION(1:3)  :: p_ref_Turbine = 0.0_ReKi      !< Undisplaced global position of this turbine [m]
  END TYPE FWrap_ParameterType
! =======================
! =========  FWrap_InputType  =======
  TYPE, PUBLIC :: FWrap_InputType
    REAL(ReKi)  :: dummy = 0.0_ReKi      !< Remove this variable if you have InputType [-]
  END TYPE FWrap_InputType
! =======================
! =========  FWrap_OutputType  =======
  TYPE, PUBLIC :: FWrap_OutputType
    REAL(ReKi) , DIMENSION(1:3)  :: xHat_Disk = 0.0_ReKi      !< Orientation of rotor centerline, normal to disk [-]
    REAL(ReKi)  :: YawErr = 0.0_ReKi      !< Nacelle-yaw error i.e. the angle about positive Z^ from the rotor centerline to the rotor-disk-averaged relative wind velocity (ambients + deficits + motion), both projected onto the horizontal plane [rad]
    REAL(ReKi)  :: psi_skew = 0.0_ReKi      !< Azimuth angle from the nominally vertical axis in the disk plane to the vector about which the inflow skew angle is defined [rad]
    REAL(ReKi)  :: chi_skew = 0.0_ReKi      !< Inflow skew angle [rad]
    REAL(ReKi) , DIMENSION(1:3)  :: p_hub = 0.0_ReKi      !< Center position of hub [m]
    REAL(ReKi)  :: D_rotor = 0.0_ReKi      !< Rotor diameter [m]
    REAL(ReKi)  :: DiskAvg_Vx_Rel = 0.0_ReKi      !< Rotor-disk-averaged relative wind speed (ambient + deficits + motion), normal to disk [m/s]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AzimAvg_Ct      !< Azimuthally averaged thrust force coefficient (normal to disk), distributed radially [-]
    REAL(ReKi) , DIMENSION(:), ALLOCATABLE  :: AzimAvg_Cq      !< Azimuthally averaged torque coefficient (normal to disk), distributed radially [-]
  END TYPE FWrap_OutputType
! =======================
CONTAINS

subroutine FWrap_CopyInitInput(SrcInitInputData, DstInitInputData, CtrlCode, ErrStat, ErrMsg)
   type(FWrap_InitInputType), intent(in) :: SrcInitInputData
   type(FWrap_InitInputType), intent(inout) :: DstInitInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(5), UB(5)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FWrap_CopyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitInputData%nr = SrcInitInputData%nr
   DstInitInputData%FASTInFile = SrcInitInputData%FASTInFile
   DstInitInputData%dr = SrcInitInputData%dr
   DstInitInputData%tmax = SrcInitInputData%tmax
   DstInitInputData%p_ref_Turbine = SrcInitInputData%p_ref_Turbine
   DstInitInputData%WaveFieldMod = SrcInitInputData%WaveFieldMod
   DstInitInputData%n_high_low = SrcInitInputData%n_high_low
   DstInitInputData%dt_high = SrcInitInputData%dt_high
   DstInitInputData%p_ref_high = SrcInitInputData%p_ref_high
   DstInitInputData%nX_high = SrcInitInputData%nX_high
   DstInitInputData%nY_high = SrcInitInputData%nY_high
   DstInitInputData%nZ_high = SrcInitInputData%nZ_high
   DstInitInputData%dX_high = SrcInitInputData%dX_high
   DstInitInputData%dY_high = SrcInitInputData%dY_high
   DstInitInputData%dZ_high = SrcInitInputData%dZ_high
   DstInitInputData%TurbNum = SrcInitInputData%TurbNum
   DstInitInputData%RootName = SrcInitInputData%RootName
   DstInitInputData%Vdist_High => SrcInitInputData%Vdist_High
end subroutine

subroutine FWrap_DestroyInitInput(InitInputData, ErrStat, ErrMsg)
   type(FWrap_InitInputType), intent(inout) :: InitInputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FWrap_DestroyInitInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   nullify(InitInputData%Vdist_High)
end subroutine

subroutine FWrap_PackInitInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FWrap_InitInputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FWrap_PackInitInput'
   logical         :: PtrInIndex
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%nr)
   call RegPack(RF, InData%FASTInFile)
   call RegPack(RF, InData%dr)
   call RegPack(RF, InData%tmax)
   call RegPack(RF, InData%p_ref_Turbine)
   call RegPack(RF, InData%WaveFieldMod)
   call RegPack(RF, InData%n_high_low)
   call RegPack(RF, InData%dt_high)
   call RegPack(RF, InData%p_ref_high)
   call RegPack(RF, InData%nX_high)
   call RegPack(RF, InData%nY_high)
   call RegPack(RF, InData%nZ_high)
   call RegPack(RF, InData%dX_high)
   call RegPack(RF, InData%dY_high)
   call RegPack(RF, InData%dZ_high)
   call RegPack(RF, InData%TurbNum)
   call RegPack(RF, InData%RootName)
   call RegPackPtr(RF, InData%Vdist_High)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_UnPackInitInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FWrap_InitInputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FWrap_UnPackInitInput'
   integer(B4Ki)   :: LB(5), UB(5)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   integer(B8Ki)   :: PtrIdx
   type(c_ptr)     :: Ptr
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%nr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%FASTInFile); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%tmax); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%p_ref_Turbine); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%WaveFieldMod); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_high_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dt_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%p_ref_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nX_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nY_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%nZ_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dX_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dY_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%dZ_high); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%TurbNum); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%RootName); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackPtr(RF, OutData%Vdist_High, LB, UB); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_CopyInitOutput(SrcInitOutputData, DstInitOutputData, CtrlCode, ErrStat, ErrMsg)
   type(FWrap_InitOutputType), intent(in) :: SrcInitOutputData
   type(FWrap_InitOutputType), intent(inout) :: DstInitOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FWrap_CopyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInitOutputData%PtfmInit = SrcInitOutputData%PtfmInit
   call NWTC_Library_CopyProgDesc(SrcInitOutputData%Ver, DstInitOutputData%Ver, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
end subroutine

subroutine FWrap_DestroyInitOutput(InitOutputData, ErrStat, ErrMsg)
   type(FWrap_InitOutputType), intent(inout) :: InitOutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FWrap_DestroyInitOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call NWTC_Library_DestroyProgDesc(InitOutputData%Ver, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
end subroutine

subroutine FWrap_PackInitOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FWrap_InitOutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FWrap_PackInitOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%PtfmInit)
   call NWTC_Library_PackProgDesc(RF, InData%Ver) 
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_UnPackInitOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FWrap_InitOutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FWrap_UnPackInitOutput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%PtfmInit); if (RegCheckErr(RF, RoutineName)) return
   call NWTC_Library_UnpackProgDesc(RF, OutData%Ver) ! Ver 
end subroutine

subroutine FWrap_CopyContState(SrcContStateData, DstContStateData, CtrlCode, ErrStat, ErrMsg)
   type(FWrap_ContinuousStateType), intent(in) :: SrcContStateData
   type(FWrap_ContinuousStateType), intent(inout) :: DstContStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FWrap_CopyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstContStateData%dummy = SrcContStateData%dummy
end subroutine

subroutine FWrap_DestroyContState(ContStateData, ErrStat, ErrMsg)
   type(FWrap_ContinuousStateType), intent(inout) :: ContStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FWrap_DestroyContState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine FWrap_PackContState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FWrap_ContinuousStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FWrap_PackContState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_UnPackContState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FWrap_ContinuousStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FWrap_UnPackContState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dummy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_CopyDiscState(SrcDiscStateData, DstDiscStateData, CtrlCode, ErrStat, ErrMsg)
   type(FWrap_DiscreteStateType), intent(in) :: SrcDiscStateData
   type(FWrap_DiscreteStateType), intent(inout) :: DstDiscStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FWrap_CopyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstDiscStateData%dummy = SrcDiscStateData%dummy
end subroutine

subroutine FWrap_DestroyDiscState(DiscStateData, ErrStat, ErrMsg)
   type(FWrap_DiscreteStateType), intent(inout) :: DiscStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FWrap_DestroyDiscState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine FWrap_PackDiscState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FWrap_DiscreteStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FWrap_PackDiscState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_UnPackDiscState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FWrap_DiscreteStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FWrap_UnPackDiscState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dummy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_CopyConstrState(SrcConstrStateData, DstConstrStateData, CtrlCode, ErrStat, ErrMsg)
   type(FWrap_ConstraintStateType), intent(in) :: SrcConstrStateData
   type(FWrap_ConstraintStateType), intent(inout) :: DstConstrStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FWrap_CopyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstConstrStateData%dummy = SrcConstrStateData%dummy
end subroutine

subroutine FWrap_DestroyConstrState(ConstrStateData, ErrStat, ErrMsg)
   type(FWrap_ConstraintStateType), intent(inout) :: ConstrStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FWrap_DestroyConstrState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine FWrap_PackConstrState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FWrap_ConstraintStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FWrap_PackConstrState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_UnPackConstrState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FWrap_ConstraintStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FWrap_UnPackConstrState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dummy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_CopyOtherState(SrcOtherStateData, DstOtherStateData, CtrlCode, ErrStat, ErrMsg)
   type(FWrap_OtherStateType), intent(in) :: SrcOtherStateData
   type(FWrap_OtherStateType), intent(inout) :: DstOtherStateData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FWrap_CopyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOtherStateData%dummy = SrcOtherStateData%dummy
end subroutine

subroutine FWrap_DestroyOtherState(OtherStateData, ErrStat, ErrMsg)
   type(FWrap_OtherStateType), intent(inout) :: OtherStateData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FWrap_DestroyOtherState'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine FWrap_PackOtherState(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FWrap_OtherStateType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FWrap_PackOtherState'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_UnPackOtherState(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FWrap_OtherStateType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FWrap_UnPackOtherState'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dummy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_CopyMisc(SrcMiscData, DstMiscData, CtrlCode, ErrStat, ErrMsg)
   type(FWrap_MiscVarType), intent(inout) :: SrcMiscData
   type(FWrap_MiscVarType), intent(inout) :: DstMiscData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FWrap_CopyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call FAST_CopyTurbineType(SrcMiscData%Turbine, DstMiscData%Turbine, CtrlCode, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (ErrStat >= AbortErrLev) return
   if (allocated(SrcMiscData%TempDisp)) then
      LB(1:1) = lbound(SrcMiscData%TempDisp)
      UB(1:1) = ubound(SrcMiscData%TempDisp)
      if (.not. allocated(DstMiscData%TempDisp)) then
         allocate(DstMiscData%TempDisp(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%TempDisp.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcMiscData%TempDisp(i1), DstMiscData%TempDisp(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%TempLoads)) then
      LB(1:1) = lbound(SrcMiscData%TempLoads)
      UB(1:1) = ubound(SrcMiscData%TempLoads)
      if (.not. allocated(DstMiscData%TempLoads)) then
         allocate(DstMiscData%TempLoads(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%TempLoads.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcMiscData%TempLoads(i1), DstMiscData%TempLoads(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%ADRotorDisk)) then
      LB(1:1) = lbound(SrcMiscData%ADRotorDisk)
      UB(1:1) = ubound(SrcMiscData%ADRotorDisk)
      if (.not. allocated(DstMiscData%ADRotorDisk)) then
         allocate(DstMiscData%ADRotorDisk(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%ADRotorDisk.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call MeshCopy(SrcMiscData%ADRotorDisk(i1), DstMiscData%ADRotorDisk(i1), CtrlCode, ErrStat2, ErrMsg2 )
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
   if (allocated(SrcMiscData%AD_L2L)) then
      LB(1:1) = lbound(SrcMiscData%AD_L2L)
      UB(1:1) = ubound(SrcMiscData%AD_L2L)
      if (.not. allocated(DstMiscData%AD_L2L)) then
         allocate(DstMiscData%AD_L2L(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstMiscData%AD_L2L.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_CopyMeshMapType(SrcMiscData%AD_L2L(i1), DstMiscData%AD_L2L(i1), CtrlCode, ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
         if (ErrStat >= AbortErrLev) return
      end do
   end if
end subroutine

subroutine FWrap_DestroyMisc(MiscData, ErrStat, ErrMsg)
   type(FWrap_MiscVarType), intent(inout) :: MiscData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(ErrMsgLen)           :: ErrMsg2
   character(*), parameter        :: RoutineName = 'FWrap_DestroyMisc'
   ErrStat = ErrID_None
   ErrMsg  = ''
   call FAST_DestroyTurbineType(MiscData%Turbine, ErrStat2, ErrMsg2)
   call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
   if (allocated(MiscData%TempDisp)) then
      LB(1:1) = lbound(MiscData%TempDisp)
      UB(1:1) = ubound(MiscData%TempDisp)
      do i1 = LB(1), UB(1)
         call MeshDestroy( MiscData%TempDisp(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%TempDisp)
   end if
   if (allocated(MiscData%TempLoads)) then
      LB(1:1) = lbound(MiscData%TempLoads)
      UB(1:1) = ubound(MiscData%TempLoads)
      do i1 = LB(1), UB(1)
         call MeshDestroy( MiscData%TempLoads(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%TempLoads)
   end if
   if (allocated(MiscData%ADRotorDisk)) then
      LB(1:1) = lbound(MiscData%ADRotorDisk)
      UB(1:1) = ubound(MiscData%ADRotorDisk)
      do i1 = LB(1), UB(1)
         call MeshDestroy( MiscData%ADRotorDisk(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%ADRotorDisk)
   end if
   if (allocated(MiscData%AD_L2L)) then
      LB(1:1) = lbound(MiscData%AD_L2L)
      UB(1:1) = ubound(MiscData%AD_L2L)
      do i1 = LB(1), UB(1)
         call NWTC_Library_DestroyMeshMapType(MiscData%AD_L2L(i1), ErrStat2, ErrMsg2)
         call SetErrStat(ErrStat2, ErrMsg2, ErrStat, ErrMsg, RoutineName)
      end do
      deallocate(MiscData%AD_L2L)
   end if
end subroutine

subroutine FWrap_PackMisc(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FWrap_MiscVarType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FWrap_PackMisc'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   if (RF%ErrStat >= AbortErrLev) return
   call FAST_PackTurbineType(RF, InData%Turbine) 
   call RegPack(RF, allocated(InData%TempDisp))
   if (allocated(InData%TempDisp)) then
      call RegPackBounds(RF, 1, lbound(InData%TempDisp), ubound(InData%TempDisp))
      LB(1:1) = lbound(InData%TempDisp)
      UB(1:1) = ubound(InData%TempDisp)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%TempDisp(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%TempLoads))
   if (allocated(InData%TempLoads)) then
      call RegPackBounds(RF, 1, lbound(InData%TempLoads), ubound(InData%TempLoads))
      LB(1:1) = lbound(InData%TempLoads)
      UB(1:1) = ubound(InData%TempLoads)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%TempLoads(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%ADRotorDisk))
   if (allocated(InData%ADRotorDisk)) then
      call RegPackBounds(RF, 1, lbound(InData%ADRotorDisk), ubound(InData%ADRotorDisk))
      LB(1:1) = lbound(InData%ADRotorDisk)
      UB(1:1) = ubound(InData%ADRotorDisk)
      do i1 = LB(1), UB(1)
         call MeshPack(RF, InData%ADRotorDisk(i1)) 
      end do
   end if
   call RegPack(RF, allocated(InData%AD_L2L))
   if (allocated(InData%AD_L2L)) then
      call RegPackBounds(RF, 1, lbound(InData%AD_L2L), ubound(InData%AD_L2L))
      LB(1:1) = lbound(InData%AD_L2L)
      UB(1:1) = ubound(InData%AD_L2L)
      do i1 = LB(1), UB(1)
         call NWTC_Library_PackMeshMapType(RF, InData%AD_L2L(i1)) 
      end do
   end if
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_UnPackMisc(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FWrap_MiscVarType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FWrap_UnPackMisc'
   integer(B4Ki)   :: i1
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call FAST_UnpackTurbineType(RF, OutData%Turbine) ! Turbine 
   if (allocated(OutData%TempDisp)) deallocate(OutData%TempDisp)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%TempDisp(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%TempDisp.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%TempDisp(i1)) ! TempDisp 
      end do
   end if
   if (allocated(OutData%TempLoads)) deallocate(OutData%TempLoads)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%TempLoads(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%TempLoads.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%TempLoads(i1)) ! TempLoads 
      end do
   end if
   if (allocated(OutData%ADRotorDisk)) deallocate(OutData%ADRotorDisk)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%ADRotorDisk(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%ADRotorDisk.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call MeshUnpack(RF, OutData%ADRotorDisk(i1)) ! ADRotorDisk 
      end do
   end if
   if (allocated(OutData%AD_L2L)) deallocate(OutData%AD_L2L)
   call RegUnpack(RF, IsAllocAssoc); if (RegCheckErr(RF, RoutineName)) return
   if (IsAllocAssoc) then
      call RegUnpackBounds(RF, 1, LB, UB); if (RegCheckErr(RF, RoutineName)) return
      allocate(OutData%AD_L2L(LB(1):UB(1)),stat=stat)
      if (stat /= 0) then 
         call SetErrStat(ErrID_Fatal, 'Error allocating OutData%AD_L2L.', RF%ErrStat, RF%ErrMsg, RoutineName)
         return
      end if
      do i1 = LB(1), UB(1)
         call NWTC_Library_UnpackMeshMapType(RF, OutData%AD_L2L(i1)) ! AD_L2L 
      end do
   end if
end subroutine

subroutine FWrap_CopyParam(SrcParamData, DstParamData, CtrlCode, ErrStat, ErrMsg)
   type(FWrap_ParameterType), intent(in) :: SrcParamData
   type(FWrap_ParameterType), intent(inout) :: DstParamData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FWrap_CopyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstParamData%nr = SrcParamData%nr
   if (allocated(SrcParamData%r)) then
      LB(1:1) = lbound(SrcParamData%r)
      UB(1:1) = ubound(SrcParamData%r)
      if (.not. allocated(DstParamData%r)) then
         allocate(DstParamData%r(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstParamData%r.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstParamData%r = SrcParamData%r
   end if
   DstParamData%n_FAST_low = SrcParamData%n_FAST_low
   DstParamData%p_ref_Turbine = SrcParamData%p_ref_Turbine
end subroutine

subroutine FWrap_DestroyParam(ParamData, ErrStat, ErrMsg)
   type(FWrap_ParameterType), intent(inout) :: ParamData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FWrap_DestroyParam'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(ParamData%r)) then
      deallocate(ParamData%r)
   end if
end subroutine

subroutine FWrap_PackParam(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FWrap_ParameterType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FWrap_PackParam'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%nr)
   call RegPackAlloc(RF, InData%r)
   call RegPack(RF, InData%n_FAST_low)
   call RegPack(RF, InData%p_ref_Turbine)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_UnPackParam(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FWrap_ParameterType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FWrap_UnPackParam'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%nr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%r); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%n_FAST_low); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%p_ref_Turbine); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_CopyInput(SrcInputData, DstInputData, CtrlCode, ErrStat, ErrMsg)
   type(FWrap_InputType), intent(in) :: SrcInputData
   type(FWrap_InputType), intent(inout) :: DstInputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FWrap_CopyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstInputData%dummy = SrcInputData%dummy
end subroutine

subroutine FWrap_DestroyInput(InputData, ErrStat, ErrMsg)
   type(FWrap_InputType), intent(inout) :: InputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FWrap_DestroyInput'
   ErrStat = ErrID_None
   ErrMsg  = ''
end subroutine

subroutine FWrap_PackInput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FWrap_InputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FWrap_PackInput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%dummy)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_UnPackInput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FWrap_InputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FWrap_UnPackInput'
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%dummy); if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_CopyOutput(SrcOutputData, DstOutputData, CtrlCode, ErrStat, ErrMsg)
   type(FWrap_OutputType), intent(in) :: SrcOutputData
   type(FWrap_OutputType), intent(inout) :: DstOutputData
   integer(IntKi),  intent(in   ) :: CtrlCode
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   integer(B4Ki)                  :: LB(1), UB(1)
   integer(IntKi)                 :: ErrStat2
   character(*), parameter        :: RoutineName = 'FWrap_CopyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   DstOutputData%xHat_Disk = SrcOutputData%xHat_Disk
   DstOutputData%YawErr = SrcOutputData%YawErr
   DstOutputData%psi_skew = SrcOutputData%psi_skew
   DstOutputData%chi_skew = SrcOutputData%chi_skew
   DstOutputData%p_hub = SrcOutputData%p_hub
   DstOutputData%D_rotor = SrcOutputData%D_rotor
   DstOutputData%DiskAvg_Vx_Rel = SrcOutputData%DiskAvg_Vx_Rel
   if (allocated(SrcOutputData%AzimAvg_Ct)) then
      LB(1:1) = lbound(SrcOutputData%AzimAvg_Ct)
      UB(1:1) = ubound(SrcOutputData%AzimAvg_Ct)
      if (.not. allocated(DstOutputData%AzimAvg_Ct)) then
         allocate(DstOutputData%AzimAvg_Ct(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%AzimAvg_Ct.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%AzimAvg_Ct = SrcOutputData%AzimAvg_Ct
   end if
   if (allocated(SrcOutputData%AzimAvg_Cq)) then
      LB(1:1) = lbound(SrcOutputData%AzimAvg_Cq)
      UB(1:1) = ubound(SrcOutputData%AzimAvg_Cq)
      if (.not. allocated(DstOutputData%AzimAvg_Cq)) then
         allocate(DstOutputData%AzimAvg_Cq(LB(1):UB(1)), stat=ErrStat2)
         if (ErrStat2 /= 0) then
            call SetErrStat(ErrID_Fatal, 'Error allocating DstOutputData%AzimAvg_Cq.', ErrStat, ErrMsg, RoutineName)
            return
         end if
      end if
      DstOutputData%AzimAvg_Cq = SrcOutputData%AzimAvg_Cq
   end if
end subroutine

subroutine FWrap_DestroyOutput(OutputData, ErrStat, ErrMsg)
   type(FWrap_OutputType), intent(inout) :: OutputData
   integer(IntKi),  intent(  out) :: ErrStat
   character(*),    intent(  out) :: ErrMsg
   character(*), parameter        :: RoutineName = 'FWrap_DestroyOutput'
   ErrStat = ErrID_None
   ErrMsg  = ''
   if (allocated(OutputData%AzimAvg_Ct)) then
      deallocate(OutputData%AzimAvg_Ct)
   end if
   if (allocated(OutputData%AzimAvg_Cq)) then
      deallocate(OutputData%AzimAvg_Cq)
   end if
end subroutine

subroutine FWrap_PackOutput(RF, Indata)
   type(RegFile), intent(inout) :: RF
   type(FWrap_OutputType), intent(in) :: InData
   character(*), parameter         :: RoutineName = 'FWrap_PackOutput'
   if (RF%ErrStat >= AbortErrLev) return
   call RegPack(RF, InData%xHat_Disk)
   call RegPack(RF, InData%YawErr)
   call RegPack(RF, InData%psi_skew)
   call RegPack(RF, InData%chi_skew)
   call RegPack(RF, InData%p_hub)
   call RegPack(RF, InData%D_rotor)
   call RegPack(RF, InData%DiskAvg_Vx_Rel)
   call RegPackAlloc(RF, InData%AzimAvg_Ct)
   call RegPackAlloc(RF, InData%AzimAvg_Cq)
   if (RegCheckErr(RF, RoutineName)) return
end subroutine

subroutine FWrap_UnPackOutput(RF, OutData)
   type(RegFile), intent(inout)    :: RF
   type(FWrap_OutputType), intent(inout) :: OutData
   character(*), parameter            :: RoutineName = 'FWrap_UnPackOutput'
   integer(B4Ki)   :: LB(1), UB(1)
   integer(IntKi)  :: stat
   logical         :: IsAllocAssoc
   if (RF%ErrStat /= ErrID_None) return
   call RegUnpack(RF, OutData%xHat_Disk); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%YawErr); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%psi_skew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%chi_skew); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%p_hub); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%D_rotor); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpack(RF, OutData%DiskAvg_Vx_Rel); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AzimAvg_Ct); if (RegCheckErr(RF, RoutineName)) return
   call RegUnpackAlloc(RF, OutData%AzimAvg_Cq); if (RegCheckErr(RF, RoutineName)) return
end subroutine
END MODULE FASTWrapper_Types
!ENDOFREGISTRYGENERATEDFILE
