**Feature or improvement description**
Pull request to merge `rc-4.1.2` into `main` and create a tagged release for v4.1.2

See the milestone and project pages for additional information

    https://github.com/OpenFAST/openfast/milestone/25

Test results, if applicable
See GitHub Actions

### Release checklist:
- [ ] Update the documentation version in docs/conf.py
- [ ] Update the versions in docs/source/user/api\_change.rst
- [ ] Update version info in openfast\_io/pyproject.toml (`openfast_io` package)
- [ ] Update version info in glue-codes/python/pyproject.toml (`pyOpenFAST` package for testing)
- [ ] Verify readthedocs builds correctly
- [ ] Create an annotated tag in OpenFAST during merge (mark as most recent if necessary)
- [ ] Create a merge commit in r-test and add a corresponding annotated tag
- [ ] Upload Docker image
- [ ] Compile executables for Windows builds
    - [ ] `AeroDisk_Driver_x64.exe`
    - [ ] `AeroDyn_Driver_x64.exe`
    - [ ] `AeroDyn_Driver_x64_OpenMP.exe`
    - [ ] `AeroDyn_Inflow_c_binding_x64.dll`
    - [ ] `AeroDyn_Inflow_c_binding_x64_OpenMP.dll`
    - [ ] `BeamDyn_Driver_x64.exe`
    - [ ] `DISCON.dll (x64)`
    - [ ] `DISCON_ITIBarge.dll (x64)`
    - [ ] `DISCON_OC3Hywind.dll (x64)`
    - [ ] `DISCON_SC.dll (x64)`
    - [ ] `FAST.Farm_x64.exe`
    - [ ] `FAST.Farm_x64_OMP.exe`
    - [ ] `FAST_SFunc.mexw64`
    - [ ] `HydroDynDriver_x64.exe`
    - [ ] `HydroDyn_C_Binding_x64.dll`
    - [ ] `IinflowWind_c_binding_x64.dll`
    - [ ] `InflowWind_Driver_x64.exe`
    - [ ] `InflowWind_Driver_x64_OpenMP.exe`
    - [ ] `MoorDyn_Driver_x64.exe`
    - [ ] `MoorDyn_c_binding_x64.dll`
    - [ ] `OpenFAST-Simulink_x64.dll`
    - [ ] `openfast_x64.exe`
    - [ ] `SeaStateDriver_x64.exe`
    - [ ] `SeaState_c_binding_x64.dll`
    - [ ] `SimpleElastoDyn_x64.exe`
    - [ ] `SubDyn_x64.exe`
    - [ ] `Turbsim_x64.exe`
    - [ ] `UnsteadyAero_x64.exe`

# Changelog (from 4.1.1)

## Overview

This release includes several bug fixes and improvements for _OpenFAST_ and fixes a critical error in the Visual Studio build system for _OpenFAST_ and _MoorDyn_. 


## General

### Visual Studio build system

#2914 Add SeaState path when running MoorDyn registry in RunRegistry.bat (@deslaughter)




## Solvers

### OpenFAST

#2915 Don't allow MAP when writing checkpoint files (@deslaughter)



## Module changes

### HydroDyn

#2941 HD: Switched to an equivalent but numerically more reliable expression for the hydrostatic moment on (partially wetted) circular endplates (@luwang00)


### SeaState

#2919 Backport of #2906 ( SeaState: Allow WaveStMod=1 with WaveMod=0) (@luwang00)


### ServoDyn

#2942 SrvD: bugfix linearization of StC `_dYdx` was not using `x_perturb` (@andrew-platt)

### SubDyn

#2934 Backport of 2905: SD: Fix a bug where interface DoF loads are incomplete if the interface joint is part of a rigid assembly (@luwang00)



## Documentation

#2931 docs: add guide for WSL+VScode (@skvibimigger)

#2937 Docs update recomendations from issue #1822 (FAST.Farm) (@andrew-platt)


## Testing

Test results for the `StC_test_OC4Semi_Linear_Nac` and `StC_test_OC4Semi_Linear_Tow` cases were updated in #2942 - these were missing effects from the state variables for structural controls.


## Input file changes

No input file changes since v4.1.0


## Known issues
There are several issues that have not been addressed in this release due to time constraints, but will be addressed in future releases.  These include:

- No visualization of rectangular members from _HydroDyn_ or _SubDyn_ through the VTK output options
- Missing and broken features from several c-binding library interfaces:
   - the _AeroDyn\_Inflow\_c-binding_ library interface does not allow for coupling to the tower.  This will require an interface update.
   - the _HydroDyn\_c-binding_ library interface does not currently support vizualization.  This will require an interface update.
   - the `InitNodePositions` input to _HydroDyn\_c-binding_ library interface does not currently work with any non-zero `x` or `y` coordinates (non-zero `z` is ok)
   - the _MoorDyn\_c-binding_ library interface does not currently support vizualization.  This will require an interface update.
   - error messages from c-binding library interfaces will get truncated to 1024 characters.  A fix is nearly ready, but will have to wait until the next release.
- A `glue-codes/labview/src/WaveTank.f90` file is included in this release, but it is incomplete and untested.  This is a placeholder for internal development work that may be released in complete form at a later date.
- The GitHub `deploy` action to build Windows executables does not currently catch failed builds.  This might be addressed at a later date. We are manually checking these builds for now.
- Documentation on the new _pyOpenFAST_ module is incomplete.  Partial documentation exists on how to use it in regression testing, but no documentation or examples exist on using it to call c-bindings modules from Python.
- Documentation is incomplete for _HydroDyn_, _SubDyn_, and a few other modules.
