**Feature or improvement description**
Pull request to merge `rc-4.1.1` into `main` and create a tagged release for v4.1.1

See the milestone and project pages for additional information

    https://github.com/OpenFAST/openfast/milestone/24

Test results, if applicable
See GitHub Actions

### Release checklist:
- [ ] Update the documentation version in docs/conf.py
- [ ] Update the versions in docs/source/user/api\_change.rst
- [ ] Update version info in openfast\_io/pyproject.toml (`openfast_io` package)
- [ ] Update version info in glue-codes/python/pyproject.toml (`pyOpenFAST` package for testing)
- [ ] Verify readthedocs builds correctly
- [ ] Create an annotated tag in OpenFAST during merge (mark as most recent if necessary)
- [ ] Create a merge commit in r-test and add a corresponding annotated tag
- [ ] Upload Docker image
- [ ] Compile executables for Windows builds
    - [ ] `AeroDisk_Driver_x64.exe`
    - [ ] `AeroDyn_Driver_x64.exe`
    - [ ] `AeroDyn_Driver_x64_OpenMP.exe`
    - [ ] `AeroDyn_Inflow_c_binding_x64.dll`
    - [ ] `AeroDyn_Inflow_c_binding_x64_OpenMP.dll`
    - [ ] `BeamDyn_Driver_x64.exe`
    - [ ] `DISCON.dll (x64)`
    - [ ] `DISCON_ITIBarge.dll (x64)`
    - [ ] `DISCON_OC3Hywind.dll (x64)`
    - [ ] `DISCON_SC.dll (x64)`
    - [ ] `FAST.Farm_x64.exe`
    - [ ] `FAST.Farm_x64_OMP.exe`
    - [ ] `FAST_SFunc.mexw64`
    - [ ] `HydroDynDriver_x64.exe`
    - [ ] `HydroDyn_C_Binding_x64.dll`
    - [ ] `IinflowWind_c_binding_x64.dll`
    - [ ] `InflowWind_Driver_x64.exe`
    - [ ] `InflowWind_Driver_x64_OpenMP.exe`
    - [ ] `MoorDyn_Driver_x64.exe`
    - [ ] `MoorDyn_c_binding_x64.dll`
    - [ ] `OpenFAST-Simulink_x64.dll`
    - [ ] `openfast_x64.exe`
    - [ ] `SeaStateDriver_x64.exe`
    - [ ] `SeaState_c_binding_x64.dll`
    - [ ] `SimpleElastoDyn_x64.exe`
    - [ ] `SubDyn_x64.exe`
    - [ ] `Turbsim_x64.exe`
    - [ ] `UnsteadyAero_x64.exe`

# Changelog (from 4.1.0)

## Overview

This release includes several bug fixes and improvements for _OpenFAST_, GitHub actions, and the C++ interface. 


## General

### CMake build system

#2910 CMake: update location of external lapack (@andrew-platt)

### GitHub actions

#2883 Gh actions debug (@deslaughter)


### Conda deployment

#2891 Minor fixes for v4.1 for smoother conda deployment (@gbarter)


## Python packages

### pyOpenFAST

#2907 pyOpenFAST: remove unnecessary files, move examples (@andrew-platt)


## Module changes

### HydroDyn

#2880 HD bug fix: avoid division by zero with MHstLMod=2 (@luwang00)

### ServoDyn

#2908 SrvD: add numbering to StC echo files (@andrew-platt)


## Code API changes

#### CPP interface

#2881 Fix FAST_CreateCheckpoint in c++ interface (@marchdf)


### HydroDyn c-binding library interface

#2894 Fix segfault when SeaState OutSwitch=2 and no output channels (@andrew-platt)


## Testing

Updated `driver_utilities.py` to allow testing to run in current build directory which might not be `build` (included in #2894 above)

## Input file changes

No input file changes since v4.1.0


## Known issues
There are several issues that have not been addressed in this release due to time constraints, but will be addressed in future releases.  These include:

- No visualization of rectangular members from _HydroDyn_ or _SubDyn_ through the VTK output options
- Missing and broken features from several c-binding library interfaces:
   - the _AeroDyn\_Inflow\_c-binding_ library interface does not allow for coupling to the tower.  This will require an interface update.
   - the _HydroDyn\_c-binding_ library interface does not currently support vizualization.  This will require an interface update.
   - the `InitNodePositions` input to _HydroDyn\_c-binding_ library interface does not currently work with any non-zero `x` or `y` coordinates (non-zero `z` is ok)
   - the _MoorDyn\_c-binding_ library interface does not currently support vizualization.  This will require an interface update.
   - error messages from c-binding library interfaces will get truncated to 1024 characters.  A fix is nearly ready, but will have to wait until the next release.
- A `glue-codes/labview/src/WaveTank.f90` file is included in this release, but it is incomplete and untested.  This is a placeholder for internal development work that may be released in complete form at a later date.
- The GitHub `deploy` action to build Windows executables does not currently catch failed builds.  This might be addressed at a later date. We are manually checking these builds for now.
- Documentation on the new _pyOpenFAST_ module is incomplete.  Partial documentation exists on how to use it in regression testing, but no documentation or examples exist on using it to call c-bindings modules from Python.
- Documentation is incomplete for _HydroDyn_, _SubDyn_, and a few other modules.
