**Feature or improvement description**
Pull request to merge `rc-4.1.0` into `main` and create a tagged release for v4.1.0

See the milestone and project pages for additional information

    https://github.com/OpenFAST/openfast/milestone/17

Test results, if applicable
See GitHub Actions

### Release checklist:
- [ ] Update the documentation version in docs/conf.py
- [ ] Update the versions in docs/source/user/api\_change.rst
- [ ] Update version info in openfast\_io/pyproject.toml (`openfast_io` package)
- [ ] Update version info in glue-codes/python/pyproject.toml (`pyOpenFAST` package for testing)
- [ ] Verify readthedocs builds correctly
- [ ] Create an annotated tag in OpenFAST during merge (mark as most recent if necessary)
- [ ] Create a merge commit in r-test and add a corresponding annotated tag
- [ ] Upload Docker image
- [ ] Compile executables for Windows builds
    - [ ] `AeroDisk_Driver_x64.exe`
    - [ ] `AeroDyn_Driver_x64.exe`
    - [ ] `AeroDyn_Driver_x64_OpenMP.exe`
    - [ ] `AeroDyn_Inflow_c_binding_x64.dll`
    - [ ] `AeroDyn_Inflow_c_binding_x64_OpenMP.dll`
    - [ ] `BeamDyn_Driver_x64.exe`
    - [ ] `DISCON.dll (x64)`
    - [ ] `DISCON_ITIBarge.dll (x64)`
    - [ ] `DISCON_OC3Hywind.dll (x64)`
    - [ ] `DISCON_SC.dll (x64)`
    - [ ] `FAST.Farm_x64.exe`
    - [ ] `FAST.Farm_x64_OMP.exe`
    - [ ] `FAST_SFunc.mexw64`
    - [ ] `HydroDynDriver_x64.exe`
    - [ ] `HydroDyn_C_Binding_x64.dll`
    - [ ] `IinflowWind_c_binding_x64.dll`
    - [ ] `InflowWind_Driver_x64.exe`
    - [ ] `InflowWind_Driver_x64_OpenMP.exe`
    - [ ] `MoorDyn_Driver_x64.exe`
    - [ ] `MoorDyn_c_binding_x64.dll`
    - [ ] `OpenFAST-Simulink_x64.dll`
    - [ ] `openfast_x64.exe`
    - [ ] `SeaStateDriver_x64.exe`
    - [ ] `SeaState_c_binding_x64.dll`
    - [ ] `SimpleElastoDyn_x64.exe`
    - [ ] `SubDyn_x64.exe`
    - [ ] `Turbsim_x64.exe`
    - [ ] `UnsteadyAero_x64.exe`

# Changelog (from 4.0.5)

## Overview

This release removes the SuperController from _FAST.Farm_ in favor of ZeroMQ communication between ROSCO controllers.
This release also adds several new features including direct coupling of _MoorDyn_ to _SeaState_, rectangular members in _HydroDyn_ and _SubDyn_, vortex-induced vibration (VIV) capabilities in _MoorDyn_, and a new _pyOpenFAST_ module for calling c-binding libraries directly from Python.
This release also includes several bug fixes and improvements for _AeroDyn_, _BeamDyn_, _MoorDyn_, _OpenFAST_, several various c-binding libary interfaces, and GitHub actions.


## General

### CMake build system

#2632 Reduce optimization level for `FAST*_Types.f90` with gcc (@andrew-platt)

### GitHub actions

#2636 Add job to build Windows executables to deploy.yml (@deslaughter)

#2771 Update GH conda-deploy action to use Ubuntu 24.04 (@andrew-platt)


### Visual Studio build system

#2866 VS build: fix MD, add `SeaStateS_c_binding` and update GH `deploy` action (@andrew-platt)



## Python packages

### openfast_io

#2658 `openfast_IO` MoorDyn compatibility (@RyanDavies19)


### pyOpenFAST
This is a new python package that interfaces the c-bindings library versions of _OpenFAST_ with Python. Users who want to call standalone _OpenFAST_ modules from Python will want to look into using this package. Note that the documentation is limited at this time.

This package is also used in testing (see [documentation on testing environments]([https://openfast.readthedocs.io/en/main/source/testing/regression_test.html#testing-environment))

#2680 Refactor the Aerodyn/Inflowwind Python interface to the C-bindings interface (@faisal-bhuiyan)

#2719 Python infrastructure improvements (new pyOpenFAST package) (@rafmudaf)



## Solvers

### FAST.Farm

#2729 Remove supercontroller from FAST.Farm (@abhineet-gupta)


### OpenFAST

#2671 Avoid ending program when called as a shared library (@bjonkman)

#2705 MoorDyn-SeaState Coupling (OpenFAST and FAST.Farm) (@RyanDavies19)

#2760 bug fix: Adjust steady-state solver small angle assumptions (@bjonkman)



## Module changes

### multiple modules

#2770 Bug fix for Failed0 error checking functions (@rafmudaf)


### AeroDyn

#2848 Bug fix: remove spaces in OLAF's UA summary file name (@bjonkman)


### BeamDyn

#2642 [BugFix] BD: variable passing in `Calc_RR0mEta_rho` (@bjonkman, @andrew-platt)


### HydroDyn

#2646 Implementation of rectangular members in HD and SD (@luwang00)

#2663 HydroDyn C-binding: Added mass matrix (@luwang00)

#2787 HD-cbind: Add HydroDyn input files handle (@wenchaoyu, @andrew-platt)

#2865 Reduce memory requirement in HydroDyn initialization (@bjonkman)


### MoorDyn

#2746 MoorDyn bugfixes (@RyanDavies19)

#2650 MoorDyn: VIV and Rk4 solver (@RyanDavies19 )

#2791 MD cbind: correction to description of mesh point mapping (@andrew-platt)

#2794 MoorDyn wave directional spreading and custom current profile if no SeaState current (@RyanDavies19)


### SeaState

#2720 Adds first pass SeaState C Binding interface (@rafmudaf)


### ServoDyn

#2798 Docs: correct Bladed Interface channel 63 description (@andrew-platt)


### SubDyn

#2646 (see above in HydroDyn)

### TurbSim

#2808 [BugFix] TurbSim calculating grid bottom location (@ptrbortolotti)


## Documentation

#2867 Docs: update info on testing (with `pyOpenFAST` module) (@andrew-platt)

#2850 Docs Update for the New Rectangular Members in HydroDyn and SubDyn (@luwang00)


## Typo fixes in code comments
There have been several "fluff" pull requests with only typo fixes and no code changes.

#2858 Fix Typos in Comments and Log Messages for Flexural and Crushing Ice Failure Initialization (@kilavvy)


## Regression Testing

#2765 MHK RM1: reduce HD resolution (@andrew-platt)

## Code API changes
The SuperController has been removed.  This changes the interfaces for some files:

#### CPP interface
- `glue-codes/openfast-cpp/src/OpenFAST.H`
    - `class fastInputs {`
    - `class OpenFAST {`
-  `glue-codes/openfast-cpp/src/OpenFAST.cpp`
    - `class fastInputs `
    - `fast::fastInputs::fastInputs():`

#### OpenFAST library interface
- `modules/openfast-library/src/FAST_Library.h`
    - `FAST_ExtLoads_Restart` - removal of SuperController arguments
    - `FAST_ExtLoads_Init` - removal of SuperController arguments
    - ` FAST_ExtInfw_Restart` - removal of SuperController arguments
    - ` FAST_ExtInfw_Init` -removal of SuperController arguments
- `modules/openfast-library/src/FAST_Library.f90`
    - `FAST_ExtLoads_Restart` - removal of SuperController arguments
    - `FAST_ExtLoads_Init` - removal of SuperController arguments
    - ` FAST_ExtInfw_Restart` - removal of SuperController arguments
    - ` FAST_ExtInfw_Init` -removal of SuperController arguments

### HydroDyn c-binding library interface
- `modules/hydrodyn/src/HydroDyn_C_Binding.f90`
   - `HydroDyn_C_Init` - arguments
   - `HydroDyn_C_CalcOutput_and_AddedMass` - new routine
   
### MoorDyn c-bindings libarary interface
- `modules/moordyn/src/MoorDyn_C_Binding.f90`
   - `MD_C_Init` - new argument
   

## Input file changes
This release brings several input file changes including the FAST.Farm (removal of supercontroller sections), HydroDyn (new sections for rectangular members, revised members table), SubDyn (new rectangular cross-section table, and additional columns in other tables).
A list of changes can be found here: https://openfast.readthedocs.io/en/main/source/user/api_change.html.  However, we recommend that if you start by comparing to the complete set of input files found in the regression tests: https://github.com/OpenFAST/r-test/tree/v4.1.0 (example input files from the regression testing)


## Known issues
There are several issues that have not been addressed in this release due to time constraints, but will be addressed in future releases.  These include:

- No visualization of rectangular members from _HydroDyn_ or _SubDyn_ through the VTK output options
- Missing and broken features from several c-binding library interfaces:
   - the _AeroDyn\_Inflow\_c-binding_ library interface does not allow for coupling to the tower.  This will require an interface update.
   - the _HydroDyn\_c-binding_ library interface does not currently support vizualization.  This will require an interface update.
   - the `InitNodePositions` input to _HydroDyn\_c-binding_ library interface does not currently work with any non-zero `x` or `y` coordinates (non-zero `z` is ok)
   - the _MoorDyn\_c-binding_ library interface does not currently support vizualization.  This will require an interface update.
   - error messages from c-binding library interfaces will get truncated to 1024 characters.  A fix is nearly ready, but will have to wait until the next release.
- There are leftover unused and incomplete files from development in the `glue-codes/python` directory.  These will be removed later.
- A `glue-codes/labview/src/WaveTank.f90` file is included in this release, but it is incomplete and untested.  This is a placeholder for internal development work that may be released in complete form at a later date.
- The GitHub `deploy` action to build Windows executables does not currently catch failed builds.  This might be addressed at a later date. We are manually checking these builds for now.
- Documentation on the new _pyOpenFAST_ module is incomplete.  Partial documentation exists on how to use it in regression testing, but no documentation or examples exist on using it to call c-bindings modules from Python.
- Documentation is incomplete for _HydroDyn_, _SubDyn_, and a few other modules.
