**Feature or improvement description**
Pull request to merge `rc-4.0.5` into `main` and create a tagged release for v4.0.5

See the milestone and project pages for additional information

    https://github.com/OpenFAST/openfast/milestone/22

Test results, if applicable
See GitHub Actions

### Release checklist:
- [ ] Update the documentation version in docs/conf.py
- [ ] Update the versions in docs/source/user/api\_change.rst
- [ ] Update version info in openfast\_io/pyproject.toml
- [ ] Verify readthedocs builds correctly
- [ ] Create an annotated tag in OpenFAST during merge (mark as most recent if necessary)
- [ ] Create a merge commit in r-test and add a corresponding annotated tag
- [ ] Upload Docker image
- [ ] Compile executables for Windows builds
    - [ ] `AeroDisk_Driver_x64.exe`
    - [ ] `AeroDyn_Driver_x64.exe`
    - [ ] `AeroDyn_Driver_x64_OpenMP.exe`
    - [ ] `AeroDyn_Inflow_c_binding_x64.dll`
    - [ ] `AeroDyn_Inflow_c_binding_x64_OpenMP.dll`
    - [ ] `BeamDyn_Driver_x64.exe`
    - [ ] `DISCON.dll (x64)`
    - [ ] `DISCON_ITIBarge.dll (x64)`
    - [ ] `DISCON_OC3Hywind.dll (x64)`
    - [ ] `DISCON_SC.dll (x64)`
    - [ ] `FAST.Farm_x64.exe`
    - [ ] `FAST.Farm_x64_OMP.exe`
    - [ ] `FAST_SFunc.mexw64`
    - [ ] `HydroDynDriver_x64.exe`
    - [ ] `HydroDyn_C_Binding_x64.dll`
    - [ ] `IinflowWind_c_binding_x64.dll`
    - [ ] `InflowWind_Driver_x64.exe`
    - [ ] `InflowWind_Driver_x64_OpenMP.exe`
    - [ ] `MoorDyn_Driver_x64.exe`
    - [ ] `MoorDyn_c_binding_x64.dll`
    - [ ] `OpenFAST-Simulink_x64.dll`
    - [ ] `openfast_x64.exe`
    - [ ] `SeaStateDriver_x64.exe`
    - [ ] `SimpleElastoDyn_x64.exe`
    - [ ] `SubDyn_x64.exe`
    - [ ] `Turbsim_x64.exe`
    - [ ] `UnsteadyAero_x64.exe`

# Changelog

## Overview

This release includes several bug fixes and improvements for _OpenFAST_, GitHub actions, and _openfast\_io_.

## General

### CMake build system

### GitHub actions

#2825 Simplify GitHub Action for regression tests (backport from dev-tc) (@deslaughter)


### openfast_io

#2828 updated outlist reading in openfast\_io (@mayankchetan)

#2818 OpenFAST IO updates: MoorDyn and StC (@dzalkind)



## Solvers

### OpenFAST

#2831 [BugFix] WrVTK with VTK\_fps fails (@andrew-platt)


## Interfaces

### cpp interface

#2792 Fix openfastcpp restart parsing of file name (@marchdf)

#2804 Add a checkError in openfast cpp (@marchdf)

#2815 Fix restart parsing of file name (backport of #2792 and #2793) (@marchdf)


## Module changes

### AeroDyn

#2853 Backport #2848 (@bjonkman)


### BeamDyn

#2811 BD: new output - aero only loads mapped to the root (@andrew-platt)


### IceFlow

#2855 Fix Typo in "interpolation" in Ice Crushing Modules (@leopardracer)


### SubDyn

#2821 bugfix: SD maximum number of output channels was incorrectly set (@andrew-platt)


## Input file changes

No input file changes since v4.0.0

#2829 FF: typo in SeaState names in `MD_Shared` .fst files - this is not an API change (@andrew-platt)

