**Feature or improvement description**
Pull request to merge `rc-4.0.4` into `main` and create a tagged release for v4.0.4

See the milestone and project pages for additional information

    https://github.com/OpenFAST/openfast/milestone/20

Test results, if applicable
See GitHub Actions

### Release checklist:
- [ ] Update the documentation version in docs/conf.py
- [ ] Update the versions in docs/source/user/api\_change.rst
- [ ] Update version info in openfast\_io/pyproject.toml
- [ ] Verify readthedocs builds correctly
- [ ] Create an annotated tag in OpenFAST during merge (mark as most recent if necessary)
- [ ] Create a merge commit in r-test and add a corresponding annotated tag
- [ ] Upload Docker image
- [ ] Compile executables for Windows builds
    - [ ] `AeroDisk_Driver_x64.exe`
    - [ ] `AeroDyn_Driver_x64.exe`
    - [ ] `AeroDyn_Driver_x64_OpenMP.exe`
    - [ ] `AeroDyn_Inflow_c_binding_x64.dll`
    - [ ] `AeroDyn_Inflow_c_binding_x64_OpenMP.dll`
    - [ ] `BeamDyn_Driver_x64.exe`
    - [ ] `DISCON.dll (x64)`
    - [ ] `DISCON_ITIBarge.dll (x64)`
    - [ ] `DISCON_OC3Hywind.dll (x64)`
    - [ ] `DISCON_SC.dll (x64)`
    - [ ] `FAST.Farm_x64.exe`
    - [ ] `FAST.Farm_x64_OMP.exe`
    - [ ] `FAST_SFunc.mexw64`
    - [ ] `HydroDynDriver_x64.exe`
    - [ ] `HydroDyn_C_Binding_x64.dll`
    - [ ] `IinflowWind_c_binding_x64.dll`
    - [ ] `InflowWind_Driver_x64.exe`
    - [ ] `InflowWind_Driver_x64_OpenMP.exe`
    - [ ] `MoorDyn_Driver_x64.exe`
    - [ ] `MoorDyn_c_binding_x64.dll`
    - [ ] `OpenFAST-Simulink_x64.dll`
    - [ ] `openfast_x64.exe`
    - [ ] `SeaStateDriver_x64.exe`
    - [ ] `SimpleElastoDyn_x64.exe`
    - [ ] `SubDyn_x64.exe`
    - [ ] `Turbsim_x64.exe`
    - [ ] `UnsteadyAero_x64.exe`

# Changelog

## Overview

This release includes several bug fixes and improvements for _OpenFAST_, GitHub actions, and _openfast\_io_.

## General

### CMake build system

### GitHub actions

#2778 Backport of GitHub Action to build windows executables on release (@deslaughter) -- backport of #2636


### openfast_io

#2779 MD: Backport of PR #2658 -- openfast\_IO MoorDyn compatibility (@RyanDavies19)

#2777 bug fix #2762 (@mayankchetan)

#2658 openfast\_IO MoorDyn compatibilityModule (@RyanDavies19)



## Solvers

### Simulink

#2785 Avoid ending program when called as a shared library (@bjonkman) -- backport of #2671



## Module changes

### OpenFAST library

#2780 backport of #2760: bug-fix: Adjust steady-state solver small angle assumptions (@bjonkman)

#2776 Fix FAST\_ExtInfw\_Restart APIC++ API (@marchdf)



## Input file changes

No input file changes since v4.0.0

