**Feature or improvement description**
Pull request to merge `rc-4.0.3` into `main` and create a tagged release for v4.0.3

See the milestone and project pages for additional information

    https://github.com/OpenFAST/openfast/milestone/19

Test results, if applicable
See GitHub Actions

### Release checklist:
- [ ] Update the documentation version in docs/conf.py
- [ ] Update the versions in docs/source/user/api\_change.rst
- [ ] Update version info in openfast\_io/pyproject.toml
- [ ] Verify readthedocs builds correctly
- [ ] Create an annotated tag in OpenFAST during merge (mark as most recent if necessary)
- [ ] Create a merge commit in r-test and add a corresponding annotated tag
- [ ] Compile executables for Windows builds
    - [ ] `AeroDisk_Driver_x64.exe`
    - [ ] `AeroDyn_Driver_x64.exe`
    - [ ] `AeroDyn_Driver_x64_OpenMP.exe`
    - [ ] `AeroDyn_Inflow_c_binding_x64.dll`
    - [ ] `AeroDyn_Inflow_c_binding_x64_OpenMP.dll`
    - [ ] `BeamDyn_Driver_x64.exe`
    - [ ] `DISCON.dll (x64)`
    - [ ] `DISCON_ITIBarge.dll (x64)`
    - [ ] `DISCON_OC3Hywind.dll (x64)`
    - [ ] `DISCON_SC.dll (x64)`
    - [ ] `FAST.Farm_x64.exe`
    - [ ] `FAST.Farm_x64_OMP.exe`
    - [ ] `FAST_SFunc.mexw64`
    - [ ] `HydroDynDriver_x64.exe`
    - [ ] `HydroDyn_C_Binding_x64.dll`
    - [ ] `IinflowWind_c_binding_x64.dll`
    - [ ] `InflowWind_Driver_x64.exe`
    - [ ] `InflowWind_Driver_x64_OpenMP.exe`
    - [ ] `MoorDyn_Driver_x64.exe`
    - [ ] `MoorDyn_c_binding_x64.dll`
    - [ ] `OpenFAST-Simulink_x64.dll`
    - [ ] `openfast_x64.exe`
    - [ ] `SeaStateDriver_x64.exe`
    - [ ] `SimpleElastoDyn_x64.exe`
    - [ ] `SubDyn_x64.exe`
    - [ ] `Turbsim_x64.exe`
    - [ ] `UnsteadyAero_x64.exe`

# Changelog

## Overview

This release includes several bug fixes and improvements for _FAST.Farm_, including segmentation faults with large farms, file I/O collision fixes, increased error message length, and build/compile issues.

## General

### CMake build system

#2709 Add "nouninit" to debug flags for IntelLLVM (@andrew-platt)

#2732 Disable use of heap arrays for the Intel fortran compilers (@deslaughter)


### openfast_io

#2727 generate BD files if fst_vt dictionary BD keys are not empty (@mayankchetan)


### Visual Studio build

#2742 Fix VS build for FAST when using IFX Complier (@deslaughter)


## Solvers

### FAST.Farm

#2711 Fix FAST.Farm issues with OMP (segfaults mostly) (@andrew-platt)


## Module changes

### NWTC library

#2710 Increase length of error messages (@andrew-platt)

#2741 bug in simulation status number of days left (@andrew-platt)


## Input file changes

No input file changes are required from 4.0.2.

