**Feature or improvement description**
Pull request to merge `rc-4.0.2` into `main` and create a tagged release for v4.0.2

See the milestone and project pages for additional information

    https://github.com/OpenFAST/openfast/milestone/18

Test results, if applicable
See GitHub Actions

### Release checklist:
- [ ] Update the documentation version in docs/conf.py
- [ ] Update the versions in docs/source/user/api\_change.rst
- [ ] Verify readthedocs builds correctly
- [ ] Create a tag in OpenFAST
- [ ] Create a merge commit in r-test and add a corresponding annotated tag
- [ ] Compile executables for Windows builds
    - [ ] `AeroDyn_Driver_x64.exe`
    - [ ] `AeroDyn_Driver_x64_OpenMP.exe`
    - [ ] `AeroDyn_Inflow_C_Binding_x64.dll`
    - [ ] `AeroDyn_Inflow_C_Binding_x64_OpenMP.dll`
    - [ ] `BeamDyn_Driver_x64.exe`
    - [ ] `DISCON.dll (x64)`
    - [ ] `DISCON_ITIBarge.dll (x64)`
    - [ ] `DISCON_OC3Hywind.dll (x64)`
    - [ ] `DISCON_SC.dll (x64)`
    - [ ] `FAST.Farm_x64.exe`
    - [ ] `FAST.Farm_x64_OMP.exe`
    - [ ] `FAST_SFunc.mexw64`
    - [ ] `HydroDynDriver_x64.exe`
    - [ ] `HydroDyn_C_Binding_x64.dll`
    - [ ] `IfW_C_Binding_x64.dll`
    - [ ] `InflowWind_Driver_x64.exe`
    - [ ] `InflowWind_Driver_x64_OpenMP.exe`
    - [ ] `MoorDyn_Driver_x64.exe`
    - [ ] `MoorDyn_C_Binding_x64.dll`
    - [ ] `OpenFAST-Simulink_x64.dll`
    - [ ] `openfast_x64.exe`
    - [ ] `SubDyn_x64.exe`
    - [ ] `Turbsim_x64.exe`

# Changelog

## Overview

This release includes a bug fix to the `ExternalInflow` module which is used by AMR-Wind to provide wind velocities to AeroDyn and receive aerodynamic forces. It also contains additional documentation on OpenFAST coordinate systems and more information on the release process.

## General

#2626 Docs: add presentation overview of OF Coordinate systems (2024) (@andrew-platt)

#2627 Update ReleaseProcess.md notes (@andrew-platt)

## Module changes

### ExternalInflow

#2628 Fix bug in ExternalInflow Orientation indexing (@deslaughter)

## Input file changes

No input file changes are required from 4.0.1.

