**Feature or improvement description**
Pull request to merge `rc-4.0.1` into `main` and create a tagged release for v4.0.1

See the milestone and project pages for additional information

    https://github.com/OpenFAST/openfast/milestone/16

Test results, if applicable
See GitHub Actions

### Release checklist:
- [ ] Update the documentation version in docs/conf.py
- [ ] Update the versions in docs/source/user/api\_change.rst
- [ ] Verify readthedocs builds correctly
- [ ] Create a tag in OpenFAST
- [ ] Create a merge commit in r-test and add a corresponding annotated tag
- [ ] Compile executables for Windows builds
    - [ ] `AeroDyn_Driver_x64.exe`
    - [ ] `AeroDyn_Driver_x64_OpenMP.exe`
    - [ ] `AeroDyn_Inflow_C_Binding_x64.dll`
    - [ ] `AeroDyn_Inflow_C_Binding_x64_OpenMP.dll`
    - [ ] `BeamDyn_Driver_x64.exe`
    - [ ] `DISCON.dll (x64)`
    - [ ] `DISCON_ITIBarge.dll (x64)`
    - [ ] `DISCON_OC3Hywind.dll (x64)`
    - [ ] `DISCON_SC.dll (x64)`
    - [ ] `FAST.Farm_x64.exe`
    - [ ] `FAST.Farm_x64_OMP.exe`
    - [ ] `FAST_SFunc.mexw64`
    - [ ] `HydroDynDriver_x64.exe`
    - [ ] `HydroDyn_C_Binding_x64.dll`
    - [ ] `IfW_C_Binding_x64.dll`
    - [ ] `InflowWind_Driver_x64.exe`
    - [ ] `InflowWind_Driver_x64_OpenMP.exe`
    - [ ] `MoorDyn_Driver_x64.exe`
    - [ ] `MoorDyn_C_Binding_x64.dll`
    - [ ] `OpenFAST-Simulink_x64.dll`
    - [ ] `openfast_x64.exe`
    - [ ] `SubDyn_x64.exe`
    - [ ] `Turbsim_x64.exe`

# Changelog

## Overview

This release includes multiple small bug-fixes including compilation issues with Flang and Intel (IFX), improved diagnostics for the AeroDyn\_Inflow\_c-binding interface, user specified external loads and damping for MoorDyn, `Wind_IO` updates, a fix for a stack overflow with FAST.Farm built with Visual Studio on Windows, and other minor bugfixes.



## General

### Wind_IO

#2603 updates to handle writing OpenFAST models from weis and wind_io (mayankchetan)


### Build systems

#2607 Windows VS build -- stack overflow with FAST.Farm (andrew-platt)

#2619 ROCM Flang doesn't compile NWTC_IO.f90 (andrew-platt)

#2621 Bugfix: Update `create_FAST_SFunc.m` for Windows, update docs on Simulink MEX building (andrew-platt)


## Module changes

### AeroDyn

#2609 AD bugfix: aerodyn driver non-OLAF combined cases don't update wind (andrew-platt)

#2615 Improve diagnostics for ADI_c interface coupling (andrew-platt)


### MoorDyn

#2597 MD: User-specified external forces and translational damping for MoorDyn point, rod, and body objects (luwang00)


## Input file changes

No input file changes are required from 4.0.0.  MoorDyn can contain an optional section for `External Loads`.

Full list of changes: https://openfast.readthedocs.io/en/main/source/user/api_change.html

Full input file sets: https://github.com/OpenFAST/r-test/tree/v4.0.1 (example input files from the regression testing)

