**Feature or improvement description**
Pull request to merge `dev` into `main` for release version 4.0.0

See the milestone and project pages for additional information

    https://github.com/OpenFAST/openfast/milestone/3

Test results, if applicable
See GitHub Actions

### Release checklist:
- [ ] Review GH projects and Milestones for outstanding items
- [ ] Update version info
   - [ ] Update the documentation version in `docs/conf.py`
   - [ ] Update the versions in `docs/source/user/api_change.rst`
   - [ ] Update `openfast_io/pyproject.toml`
- [ ] Verify readthedocs builds correctly
- [ ] Create a merge commit in r-test and add a corresponding annotated tag
- [ ] Update pointer to r-test
- [ ] Merge PR
- [ ] Create release
   - [ ] Check "create a discussion" box
   - [ ] Create a new tag
- [ ] Compile executables for Windows builds
    - [ ] AeroDisk_Driver_x64.exe
    - [ ] AeroDyn_Driver_x64.exe
    - [ ] AeroDyn_Driver_x64_OpenMP.exe
    - [ ] AeroDyn_Inflow_C_Binding_x64.dll
    - [ ] AeroDyn_Inflow_C_Binding_x64_OpenMP.dll
    - [ ] BeamDyn_Driver_x64.exe
    - [ ] DISCON.dll (x64)
    - [ ] DISCON_ITIBarge.dll (x64)
    - [ ] DISCON_OC3Hywind.dll (x64)
    - [ ] DISCON_SC.dll (x64)
    - [ ] FAST.Farm_x64.exe
    - [ ] FAST.Farm_x64_OMP.exe
    - [ ] FAST_SFunc.mexw64
    - [ ] HydroDynDriver_x64.exe
    - [ ] HydroDyn_C_Binding_x64.dll
    - [ ] IfW_C_Binding_x64.dll
    - [ ] InflowWind_Driver_x64.exe
    - [ ] InflowWind_Driver_x64_OpenMP.exe
    - [ ] MoorDyn_Driver_x64.exe
    - [ ] MoorDyn_C_Binding_x64.dll
    - [ ] OpenFAST-Simulink_x64.dll
    - [ ] openfast_x64.exe
    - [ ] SeaState_driver_x64.exe
    - [ ] SimpleElastodyn_driver_x64.exe
    - [ ] Turbsim_x64.exe



# Release Overview
------
This release includes many architectural changes and physics improvements from the OpenFAST 3.5 series.  Improvements and new features include large platform yaw dynamics, reduced order structural and aero modules (_Simplified-ElastoDyn_ (SED) and _AeroDisk_ (ADsk)), fluid-structure coupling with _AMR-Wind_, wake-added turbulence for _FAST.Farm_, linearization for MHK turbines, aeromap calculations, an updated Python library for _OpenFAST_ file handling, revised wind and wave data handling, removal of _AeroDyn14_, many hydrodynamic improvements including the splitting of the wave field (new _SeaState_ (SS) module) from HydroDyn, and many bug fixes.  The number of changes to input files is very large, so we recommend reviewing the changelog below and notes in https://openfast.readthedocs.io/en/main/source/user/api_change.html for specifics about which files have changes.


### Contribution Acknowledgements
Thanks to @bjonkman, @jjonkman, @deslaughter, @luwang00, @RBergua, and @MattEHall for numerous code reviews and suggestions and testing.

Many thanks to @jjonkman and others for theory development and guidance to developers.

### Statistics (since 3.5.5)
* Total PR's unique to 4.0.0:           169
* Total individual code contributors:   27
* OpenFAST code/docs:  601 files changed, 220202 insertions(+), 445810 deletions(-)
* regression tests: 1587 files changed, 1214606 insertions(+), 537760 deletions(-)



# Changelog
------

## General

### Build systems
There were several updates to the `CMake` and Visual Studio build systems to support code revisions and improve support for compilers such as Flang.

#### CMake

#1630 Make CMake module libs STATIC (@deslaughter)

#1989 Bug: openfastcpp executable is installed to lib directory instead of bin (@deslaughter)

#1998 switch from -fpic to -fPIC for all gfortran builds (@gbarter)

#2094 Support cross-compiling with Mingw (MAP++)(@pablo-benito)

#2133 Remove linking of implicit Fortran libraries (@jrood-nrel)

#2210 New registry needs C++14 (@deslaughter)

#2229 CMake: OpenMP turned on only if requested (@andrew-platt)

#2136 ADI: adilib was getting included in aerodynlib (@andrew-platt)

#2256 Remove ModVar from dev as ROCm Flang compiler can't build it (@deslaughter)

#2392 Install also the Map++ API headers (@sanguinariojoe)

#2442 Fix path to installed MAP include files (@deslaughter)

#1682 Fix missing symbols for Simulink and LAPACK build (@deslaughter)


#### Visual Studio (Windows)

#1968 VS: update VS build process to include ExtLoads (@andrew-platt)

#2187 Fix syntax errors in Visual Studio project file for AD driver (@bjonkman)

#2189 More fixes for Visual Studio (@bjonkman)

#2327 Remove AD14 from FASTlib Visual Studio project (@bjonkman)

#2548 Build OpenFAST in Visual Studio 2022 using IFX (@deslaughter)

#2589 VSbuild: updates for 4.0.0 release (binary output paths, OMP usage) (@andrew-platt)


### Docker

#2183 Update GHCR doc, remove old Dockerfile (@mayankchetan)

### Documentation
There were multiple improvements to documentation, notably with _TurbSim_, _SubDyn_, _HydroDyn_, and _SeaState_.

#1664, #1665 TurbSim documentation (@bjonkman)

#2212 Minor corrections to docs (@andrew-platt)

#2315, #2336 Update SeaState and HydroDyn user documentation for OpenFAST 4.0 (@luwang00)

#2366 Fixed typo in docs/source/install/index.rst (@Gjacquenot)

#2372 SubDyn: Beam Element Formulation documentation (@RBergua)

#2374 SubDyn documentation: Member Cosine Matrices (@RBergua)

#2404 Update SubDyn User Documentation to reflect the removed input parameters (@luwang00)

#2455 HydroDyn user documentation update for large platform rotation (@luwang00)

#2587 Add release notes from v2.4 - v3.4.1 (@andrew-platt)




## Solvers

### FAST.Farm
_FAST.Farm_ received a major upgrade with the addition of wake-added turbulence effects across the entire farm domain.  This improves the turbulence characteristics of propagating turbine wakes.
* Input file changes

#1624 Use pointers to couple InflowWind and FAST.Farm (@deslaughter)

#1729 FF: fix plane output for wakedynamics (@ebranlard)

#2202 Wake-added turbulence in FAST.Farm (@ebranlard, @andrew-platt)

#2584 Visualization of shared moorings (@andrew-platt)


### OpenFAST
Several improvements to the _OpenFAST_ glue code include a major restructuring of the core routines for better integration into CFD, a revised initialization ordering, the addition of logic for new or replaced modules, new data passing for wave and wind data, and bug fixes.  Module related updates to logic and restructuring for CFD is included in pull-requests related to those modules.
* Input file changes

#1610 Remove TurbineType parameter (@hkross)

#1707 Linear trim solution: add error check (@bjonkman)

#2076 Move flag for WriteThisStep to `FAST_PreWork` (@bjonkman, @andrew-platt)

#2078 Minor code cleanup (replace some non-standard Fortran 2003 code) (@bjonkman)

#2186 [Bug] Writing checkpoint files created empty `fort.#` files (@deslaughter)

#2219 Turn off "#Restoring here" messages in .out files during linearization visualization sims (@andrew-platt)

#2338 Vis: Fix bug with vtk writing of non-square wave surface (@andrew-platt)

#2350 Vis: Fix another bug with vtk writing of non-square wave surface (@luwang00)

#2431 Enable linearization with MHK turbines (@andrew-platt)

#2445 ExtInfw: relocate initialization to after `AD_Init` (@andrew-platt)

#2478 [BugFix] Incorrect value of AirDens passed to `ExtInfw_Init` from `FAST_Subs.f90` (@andrew-platt)


### OpenFAST interfaces

#### OpenFASTcpp
* Interface library changes

#2245 Fix restart file index and nc write (@ndevelder)


#### Simulink

#1703 Add tests for `FAST_SFunc` using Matlab action to integrate with CI (@deslaughter)



## Modules

### Multiple
There are several pull requests that affected multiple modules.  Important features include the initial development of aeromaps (for controls development), initial development of the reduced order modules of _AeroDisk_ and _Simplified-ElastoDyn_ (overviews of each below).


#1295 Reduced order models: AeroDisk and Simplified-ElastoDyn (SED) (@andrew-platt)

#1629 MHK: add parameters for readability (@bjonkman)

#1631 Initial AeroMap changes for ElastoDyn and BeamDyn (@bjonkman)

#2203 Support for large platform yaw offset in OpenFAST (ED, HD, SD) (@luwang00)

#2254 Minor changes to FF input descriptions, re-enable test cases, update Simulink string compare (@andrew-platt)

#2332 Minor bugfix: ED blade file parsing (no PichAxis column), AD warnings (@andrew-platt)

#2415 Lidar bug fix + other minor changes (@bjonkman)

#2416 SED+ADsk: update registry comments slightly (@andrew-platt)



### AeroDyn 14 (deprecated, option replaced by AeroDisk)
_AeroDyn14_ has been removed from the code base as it has been superseded by _AeroDyn15_ (now called simply _AeroDyn_) for many years.

#2267 AeroDyn14 removal (@andrew-platt)


### AeroDisk
_AeroDisk_ is a new module for a disk actuator aerodynamic module for modeling turbine aerodynamics as a simple actuator disk. This module assumes that the rotor is a rigid disk, and so, should be not be combined with _BeamDyn_ or _ElastoDyn_ with blade degrees of freedom enabled; it is meant to be used with the new _Simplified-ElastoDyn_ module.  This is useful for modeling turbines that are not of interest in very large wind farms modeled by _FAST.Farm_, but whose wake dynamics are needed for turbines further into the wind farm that are of interest.  We do not recommend using this module with standalone _OpenFAST_ simulations.
* New input file

#2575 ADsk: correction to disk average velocity equations (@andrew-platt)



### AeroDyn
_AeroDyn_ improvements include a new input file, new options in BEM to improve aerodynamics for skewed and sheared inflow and coned rotors, nacelle drag, visualization improvements, unsteady aero for tailfins, an improved unsteady airfoil aerodynamics driver, multi-rotor support in the interface library, a simple ground effect model for _OLAF_ wakes, using _InflowWind_ pointers for data access, and many bug fixes.  With the removal of _AeroDyn14_, _AeroDyn15_ is now simply referred to as _AeroDyn_ in the input files and code (documentation may not be fully updated).
* _Major_ input file changes
* Driver input file changes
* Interface library API changes

#2428 Single value of TI in AD15 Aeroacoustics (@ptrbortolotti)

#1596 Use pointers to couple InflowWind and AeroDyn (IfW pointer) (@andrew-platt)

#1715 AD: Initial AeroMap changes for AeroDyn and misc UA/DBEMT changes (@bjonkman)

#1882 Remove IfW data from AD15 inputs (@andrew-platt)

#1909 New AeroDyn input file exposing new BEM options (polar BEM, skew momentum correction, sector averaging) (@ebranlard)

#1973 Use AD tower diameter for VTK visualization + minor improvements (@bjonkman)

#2014 Fix linearization with AD15 and IfW (@andrew-platt)

#2181 AD15: use current wind instead of extrapolated wind (IfW pointer) (@andrew-platt)

#2283 Aero modifications (many small updates) (@bjonkman)

#2358 Adding nacelle drag to AeroDyn (@mayankchetan)

#2425 AD: Bug Fix: Twist in blades 2 and 3 wrong when using Polar BEM (@ebranlard)

#2427 `DBEMT_Mod = -1` for linearization (@andrew-platt)

#2429 Fix seg-fault for `DBEMT_Mod=-1` (@andrew-platt)

#2456 Add safety checks in AirfoilInfo for ill-defined airfoils (@bjonkman)

#2559 Bug Fix: AD: projection method should now depend on `BEM_Mod` (@ebranlard)


#### Unsteady

#1874 Add unsteady aerodynamic model for turbine tail fin (@abhineet-gupta)

#1910 Unsteady Aero Driver: adding 3 degrees of freedom for the motion of a genralized airfoil section (@ebranlard)

#2091 Fix bug in new UA driver (array size) (@bjonkman)

#2357 Bug Fix: UA driver aero-elastic simulation had wrong sign (@bjonkman)

#2375 Tail fin aerodynamics: address changes requested in pull request #1874 (@abhineet-gupta)


#### OLAF 

#1791 Apply the FakeGroundEffect to all FWspan points (@rcorniglion)

#2349 [OLAF] Bug Fix: Twist Not Computed in OLAF cases when Polar Projection is used, resulting in wrong Fn, Ft outputs (@ebranlard)

#2581 OLAF out of bounds (@andrew-platt)


#### AeroDyn Driver / AeroDyn\_Inflow\_C\_Bindings interface

#1784 Multi-rotor support in ADI c-bindings interface (@andrew-platt)

#2108 Refactored Aerodyn inflow C binding interface to get blade resolved mesh information (@faisal-bhuiyan)

#2140 ADI: disable OMP in `AeroDyn_Inflow.f90` (@andrew-platt)

#2287 Bug Fix: AeroDyn driver output files contained wrong channel names (@bjonkman)

#2370 Correct frequency error in AeroDyn driver prescribed motions (@hkross)

#2457 Bug: AeroDyn-Inflow WriteOutput Value Ordering (@deslaughter)

#2470 Add blade distributed load output to AeroDyn-InflowWind C bindings (@deslaughter)

#2571 Add new routine and variables to init in the `ADI_c_binding` interface (@andrew-platt)



### ElastoDyn
_ElastoDyn_ includes a new yaw friction model, new output channels, new platform cross-inertia terms, several bugfixes, and code cleanup.
* Input file changes

#2017 Yaw friction implementation (@abhineet-gupta, @kevo331, @rdamiani)

#1760 Add output channels of linear acceleration relative to g in ElastoDyn (@luwang00)

#1426 Remove references to ADAMS coupling (@hkross)

#2247 ED: Add inputs for the off-diagonal terms of the platform moment of inertia matrix (@luwang00)

#2561 ED: Extended yaw-friction modeling (@luwang00)



### ExtInflow (formerly OpenFOAM)
_ExtInflow_ (also called _ExternalInflow_) is the renamed _OpenFOAM_ module.  The name change better reflects what this module does as it can couple to more than just the _OpenFOAM_ solver used in _SOWFA_.

#1687 ExternalInflow: rename files, change names in files (@andrew-platt)

#2443 Fixes in ExtInflw (heap-buffer-overflow, index flip, empty structure) (@marchdf)



### ExtLoads
_ExtLoads_ is a new module for blade resolved fluid-structure interaction with CFD codes such as _AMR-Wind_.  This module is accessed through the CPP interface to OpenFAST.

#1932, #1946 Blade resolved loads from CFD (@gantech, @deslaughter, @psakievich, @jrood-nrel, @andrew-platt)

#2001 ExtLoads: move integers from inputs to parameters (@andrew-platt)

#2009 ExtLoads module: Use pointers for wind (@andrew-platt)

#2226 Fix turbine indexing on ExtLoads Restart (@ndevelder)

#2412 ExtLd: require use of InflowWind (@andrew-platt)


### HydroDyn
The _HydroDyn_ module was completely restructured with wave dynamics split out into a new module, _SeaState_ (documented below).  _HydroDyn_ now accesses wave-field data through a pointer to the data held in the _SeaState_ module.  Other improvements include large yaw angle dynamics, wave loads at the displaced position in surge/sway, MacCamy-Fuchs diffraction for strip-theory members, wave stretching (various models) with load smoothing, constrained New Wave theory, new strip-theory hydrostatic solution valid for near-horizontal members at the free surface, and bug fixes.
* _Major_ input file changes

#1578 More updates to the Morison module (@luwang00)

#1609 Use pointers to couple SeaState and HydroDyn (@luwang00)

#1612 Force the numerical hydrostatic load calculation to use double precision (@luwang00)

#1623 Ensure the estimated intersections between the free surface and the Morison members are treated as under water (@luwang00)

#1804 Bug Fix with MSL2SWL (@luwang00)

#1883 HD: Remove extra copy of WaveStMod from Morison (@bjonkman)

#2031 HD Bug Fix for ExctnDisp and updates to CTestList.cmake with new r-tests (@luwang00)

#2035 Backward compatibility for the AXIAL COEFFICIENTS section of the HydroDyn input file (@luwang00)

#2069 HD bug fixes to the inertial loads from marine growth and ballast water on strip-theory members (@luwang00)

#2073 HD bug fix to the inertial load from ballast water on strip-theory members (@luwang00)

#2089 HD Bug Fix: Correct the indices of mean drift load components in WAMIT2 (@luwang00)

#2098 More bug fixes in the WAMIT and WAMIT2 modules of HydroDyn with wave headings (@luwang00)

#2341 HD: Initialization of the low-pass-filtered displacements of potential-flow bodies when `ExctnDisp = 2` (@luwang00)

#2356 Fix a bug when reading WAMIT QTF files with multiple wave headings (@getChaos22)

#2408 HD: Bug fix for potential-flow wave excitation with multiple bodies and large yaw offset (@luwang00)

#2517 HD bug fix for depth-based axial hydrodynamic coefficients (@luwang00)

#2444 HD: Reimplement the initialization of low-pass-filtered potential-flow body positions for `ExctnDisp=2` (@luwang00)


### InflowWind
The _InflowWind_ module data handling was updated so that _AeroDyn_, _ExtInflow_, and _Lidar_ can retrieve FlowField data through a pointer.  The driver was updated to allow the export of VTK slices in XY planes at a chosen elevation from any wind format.  This can be useful when visualizing wind flow in an _OpenFAST_ or _FAST.Farm_ simulation.
* Driver input file changes
* library API changes

#1639 InflowWind pointers in AeroDyn, OpenFOAM (now ExtInflow), and Lidar (@deslaughter)

#1684 [BugFix] change time handling to double precision for G4D timestep index (@deslaughter)

#1869 IfW: check that uniform wind file time vector is always increasing (@andrew-platt)

#2201 IfW: add VTK output of slice in XY to driver (@andrew-platt)



### MAP++
Several improvements were made to _MAP++_ to allow more modular coupling into other codes.

#2394 Fixes to Map++ C API (@sanguinariojoe)

#2405 [BugFix] remove extra summary file write from MAP++ (@sanguinariojoe, @andrew-platt)

#2420 MAP: change `strncpy` to use macro `MAP_STRNCPY` (@andrew-platt)


### MoorDyn
_MoorDyn_ received several new features including coupled pinned bodies, ramping of inertial loads to better handle startup transients, updated body kinematics, linear damping for rod elements, and mooring line failures.  Visualization of shared mooring lines for _FAST.Farm_ is also included.
* Input file changes

#1967 MoorDyn: Coupled Pinned Bodies and bug fixes (@RyanDavies19)

#1990 MD version update (@RyanDavies19)

#2005 Removes MD driver standalone option, bug fix on initialization (@RyanDavies19)

#2243 Initialize mass matrix to zeros in Moordyn (@faisal-bhuiyan)

#2280 MD: ramp inertial loads during startup transients (@andrew-platt)

#2294 Add MoorDyn module regression tests (@RyanDavies19)

#2334 Updating MD Body Kinematics (@RyanDavies19)

#2342 Linear damping for rod elements in MoorDyn (@RBergua, with contributions from Johyun Kyoung at Front Energies)

#2400 MD: replace "save" variable with logical in MD\_Point (@andrew-platt)

#2436 MD: Automatically detect the number of header lines in the WaveKin (wave elevation) file (@luwang00)

#2459 MD: Adding Load dependent dynamic stiffness (@RyanDavies19)

#2214 Mooring line failures added to MoorDyn (@RyanDavies19)


### NWTC-Library
There are a few minor bug fixes for the library.

#2191 [BugFix] blank line not handled by InitFileInfo (@andrew-platt)

#2223 SetErrStat referenced incorrectly in VTK.f90 (@andrew-platt)


### Registry
The _Registry_ was completely rewritten in C++ (included in #1609, @deslaughter) significantly cleaning up the code.  New features include pointer handling and new data structures to streamline packing and unpacking for saves/restarts.

#1618 [BugFix] OpenFAST Registry on Windows (@deslaughter)

#1625 Add support for pointers in OpenFAST Registry generated Pack and Unpack subroutines (@deslaughter)

#1919 Use int64 to index arrays for Registry pack/unpack routines (@deslaughter)

#1986 Save registry structures to file without using a buffer (@deslaughter)

#2249 Bug in OpenFAST Registry Unpacking Structures with `C_obj` data (@deslaughter)

#2365 Bugfix for OpenFAST Registry incorrectly restoring pointers in modules with `CObjs` (ExtLd) (@deslaughter, @gantech)

#2519 Use B4Ki to store array bounds during pack/restore of TurbineType to file (@deslaughter)


### SeaState
The _SeaState_ module contains all the wave dynamics previously included within _HydroDyn_.  As a standalone module, data is stored in the _WaveField_ data structure which is accessible from other modules through pointers.  The first implementation of this code was developed by @HaymanConsulting (#970).
* New input file

#970  Initial split of HydroDyn into HydroDyn+SeaState (@HaymanConsulting)
 - PR 1008 supersedes this, but GitHub does not show the full history so this is listed here for completeness (PR 970 was merged through PR 1008)

#1008 Additional features for the new SeaState module and HydroDyn (@HaymanConsulting, @bjonkman, @luwang00)

#1864 Cleanup HydroDyn and SeaState code (@bjonkman)

#1992 SeaState: fix grid size in wave surface visualization (@andrew-platt)

#2026 SeaState: combine `SeaSt_Interp` into `SeaSt_WaveField`, and bug fix (@andrew-platt)

#2071 SeaSt Vis: corrections to PR #1992 (@bjonkman, @andrew-platt)

#2113 SeaState: replace pointer attribute with allocatable (@bjonkman)


### Simplified-ElastoDyn
The _Simplified-ElastoDyn_ module (_SED_) is a one degree of freedom rigid structural model useful for cases where a full structural model is not needed (for example, leading turbines in a _FAST.Farm_ simulation).  This speeds up computations significantly, but at the expense of accuracy.  So it is only recommended that this be used within _FAST.Farm_ for turbines where load calculations are not needed.  This is often paired with the _AeroDisk_ module.
* New input file

#2406 Correct issues with SED (logic lost in prior merge) (@andrew-platt)


### SubDyn
_SubDyn_ improvements include a new 6x6 spring element, removal of some stiffness terms for cable pretension, a few bug fixes, and code cleanup.
* Input file changes

#1889 New spring element in SubDyn: 6 by 6 stiffness matrix (@RBergua)

#1911 SubDyn summary file: fixes (@RBergua)

#2363 SD: Comment out the geometric stiffness terms associated with cable pretension to prevent unphysical results (@luwang00)

#2401 SD: Remove the misleading CBMod input (@luwang00)

#2458 SD: Bug fix for concentrated mass with CoG offset (@luwang00)



## Testing and input file processing
There were several updates and improvements to the testing system and GitHub actions.

### openfast_io
This Python based library provides _OpenFAST_ users with library to read and write _OpenFAST_ input files.  This library will be able usable for updating input files starting with this release of _OpenFAST_ going forward.  This is designed for inclusion in other workflows, such as _WEIS_.

#2361 Updates to `openfast_io` to match current dev branch API (@mayankchetan)

#2577 Refactor `openfast/openfast_python/openfast_io/turbsim_file.py` (new entry point) (@Gjacquenot)


### GitHub actions

#2072 GH actions: update matlab-actions version (@andrew-platt)

#2074 GH actions: remove extraneous "products:" from recipe (added in #2072) (@andrew-platt)

#2154 GH actions: build docker on release instead of merge (@andrew-platt)


### Regression and Unit testing

#1598 Reduce memory requirements for regression tests after PR #1008 (@andrew-platt)

#1950 Option to turn off `unit_tests` from cmake (@andrew-platt)

#2024 Improvements to linearization regression testing (@andrew-platt)

#2182 Move test `seastate_wavemod5` to after test `seastate_wr_kin1` (@andrew-platt)

#2250 Add CalcSteady Regression Test (@deslaughter)

#2276 Replace pFUnit with test-drive for running unit tests (@deslaughter)

#2329 Remove pfunit as a submodule (@bjonkman)



## Input file changes
This release brings a large number of input file changes and rearrangements with multiple new modules.  A partial list of changes can be found here: https://openfast.readthedocs.io/en/main/source/user/api_change.html.  However, we recommend that if you start by comparing to the complete set of input files found in the regression tests: https://github.com/OpenFAST/r-test/tree/v4.0.0 (example input files from the regression testing)

