**Feature or improvement description**
Pull request to merge `rc-3.5.5` into `main` and create a tagged release for v3.5.5.

See the milestone and project pages for additional information

    https://github.com/OpenFAST/openfast/milestone/15

Test results, if applicable
See GitHub Actions

### Release checklist:
- [ ] Update the documentation version in docs/conf.py
- [ ] Update the versions in docs/source/user/api_change.rst
- [ ] Verify readthedocs builds correctly
- [ ] Create a tag in OpenFAST
- [ ] Create a merge commit in r-test and add a corresponding annotated tag
- [ ] Compile executables for Windows builds
    - [ ] AeroDyn_Driver_x64.exe
    - [ ] AeroDyn_Driver_x64_OpenMP.exe
    - [ ] AeroDyn_Inflow_C_Binding_x64.dll
    - [ ] AeroDyn_Inflow_C_Binding_x64_OpenMP.dll
    - [ ] BeamDyn_Driver_x64.exe
    - [ ] DISCON.dll (x64)
    - [ ] DISCON_ITIBarge.dll (x64)
    - [ ] DISCON_OC3Hywind.dll (x64)
    - [ ] DISCON_SC.dll (x64)
    - [ ] FAST.Farm_x64.exe
    - [ ] FAST.Farm_x64_OMP.exe
    - [ ] FAST_SFunc.mexw64
    - [ ] HydroDynDriver_x64.exe
    - [ ] HydroDyn_C_Binding_x64.dll
    - [ ] IfW_C_Binding_x64.dll
    - [ ] InflowWind_Driver_x64.exe
    - [ ] InflowWind_Driver_x64_OpenMP.exe
    - [ ] MoorDyn_Driver_x64.exe
    - [ ] MoorDyn_C_Binding_x64.dll
    - [ ] OpenFAST-Simulink_x64.dll
    - [ ] openfast_x64.exe
    - [ ] Turbsim_x64.exe

# Changelog

## Overview

This release includes multiple small bug-fixes for compilation with CMake, compilation with the IFX compilers, file opening issues when OpenMP is used, and a couple of infrequent segmentation faults from improper usage.  One minor feature improvement is the increase in the number of output planes available in _FAST.Farm_ from 99 to 999.

We recommend all users currently using any 3.5.x version to update to this version. There are no input files changes or API changes for calling from other codes since version 3.5.0.



## General

### Build systems

#2497 `CMAKE_INSTALL_PREFIX` was incorrectly being prepended to the install direcotry (@deslaughter) Derek Slaughter

#2564 Create `BUILD_OPENFAST_LIB_DRIVER` flag for the OpenFAST C++ Library Interface (not CFD) (@deslaughter)


### Docker

#2498 Docker: typo was preventing docker build upload to GH (@andrew-platt)



## Solvers

### FAST.Farm

#2536 FAST.Farm: increase number of output planes to 999 (@andrew-platt)

#2554 Add `!$OMP critical` directives around some `GetNewUnit/Open*File` to reduce probability of file unit conflicts (@andrew-platt)

#2569 Disable LiDAR in IfW at FAST.Farm level (@andrew-platt)


## Module changes

### AeroDyn

#2501 Remove `$OMP` directives from `AeroDyn_Inflow` due to Intel compiler bug (@deslaughter)

#2516 AD bugfix: Segmentation fault with ifx compiler (@andrew-platt)


### InflowWind

#2518, #2530 ADI bugfix: BoxExceed was not enabled for OLAF with ADI (@andrew-platt)

#2532 bugfix: IfW rotor points for disk average incorrect (@andrew-platt)


### NWTC-Library

#2558 Allow ParseVar to parse file paths containing spaces. (@deslaughter)




## Input file changes

No input files change with this release as this only includes minor bugfixes (input files are identical across all 3.5.x releases).

Full list of changes: https://openfast.readthedocs.io/en/main/source/user/api_change.html

Full input file sets: https://github.com/OpenFAST/r-test/tree/v3.5.5 (example input files from the regression testing)

