**Feature or improvement description**
Pull request to merge `rc-3.5.4` into `main` and create a tagged release for v3.5.4.

See the milestone and project pages for additional information

    https://github.com/OpenFAST/openfast/milestone/14

Test results, if applicable
See GitHub Actions

### Release checklist:
- [ ] Update the documentation version in docs/conf.py
- [ ] Update the versions in docs/source/user/api_change.rst
- [ ] Verify readthedocs builds correctly
- [ ] Create a tag in OpenFAST
- [ ] Create a merge commit in r-test and add a corresponding annotated tag
- [ ] Compile executables for Windows builds
    - [ ] AeroDyn_Driver_x64.exe
    - [ ] AeroDyn_Driver_x64_OpenMP.exe
    - [ ] AeroDyn_Inflow_C_Binding_x64.dll
    - [ ] AeroDyn_Inflow_C_Binding_x64_OpenMP.dll
    - [ ] BeamDyn_Driver_x64.exe
    - [ ] DISCON.dll (x64)
    - [ ] DISCON_ITIBarge.dll (x64)
    - [ ] DISCON_OC3Hywind.dll (x64)
    - [ ] DISCON_SC.dll (x64)
    - [ ] FAST.Farm_x64.exe
    - [ ] FAST.Farm_x64_OMP.exe
    - [ ] FAST_SFunc.mexw64
    - [ ] HydroDynDriver_x64.exe
    - [ ] HydroDyn_C_Binding_x64.dll
    - [ ] IfW_C_Binding_x64.dll
    - [ ] InflowWind_Driver_x64.exe
    - [ ] InflowWind_Driver_x64_OpenMP.exe
    - [ ] MoorDyn_Driver_x64.exe
    - [ ] MoorDyn_C_Binding_x64.dll
    - [ ] OpenFAST-Simulink_x64.dll
    - [ ] openfast_x64.exe
    - [ ] Turbsim_x64.exe

# Changelog

## Overview

This release includes performance improvements for BeamDyn (up to 30% speed increase), python file readers and writers from WEIS, and a fix for stack overflows with FAST.Farm (Intel compilation).  A few other minor updates are included as outlined below.

Anyone using BeamDyn will want to update to this version.


## General

### Build systems

#2311 Always build `openfastcpplib` as shared. Use `BUILD_OPENFAST_CPP_DRIVER` to disable `openfastcpp` executable (@deslaughter)
#2173 Fix crash in `MAP_End` when using Intel's new icx compiler and disable caching in setup-python GH action (@deslaughter)


### Python file readers/writers

#2188 Add WEIS file readers and writers (@cortadocodes and @mayankchetan)


## Solvers

### FAST.Farm

#2452  Fix for some stack overflow issues with FAST.Farm when copying large amounts of wind data (closes #2053) (@andrew-platt)
#2340  Add `!$ OMP critical` around file opening for VTK to prevent file collision (@andrew-platt)


## Module changes

### BeamDyn

#2399 BeamDyn performance improvements (@deslaughter)


### ElastoDyn

#2321 Backport of #2317: Explicitly initialize `ED` `RtHS` to zero -- corrects issue with inccorect linearization results (@andrew-platt)


### HydroDyn
#2397 HD bug fix: prevent array index out-of-bound error in `HDOut_MapOutputs` when more than 9 potential-flow bodies are present (@luwang00)

### NWTC-Library
#2389 FileInfoType: increase line length allowed (@andrew-platt)

## Input file changes

No input files change with this release, as this only includes minor bugfixes.

Full list of changes: https://openfast.readthedocs.io/en/main/source/user/api_change.html

Full input file sets: https://github.com/OpenFAST/r-test/tree/v3.5.4 (example input files from the regression testing)

