**Feature or improvement description**
Pull request to merge `rc-3.5.3` into `main` and create a tagged release for v3.5.3.

See the milestone and project pages for additional information

    https://github.com/OpenFAST/openfast/milestone/13

Test results, if applicable
See GitHub Actions

### Release checklist:
- [ ] Update the documentation version in docs/conf.py
- [ ] Update the versions in docs/source/user/api_change.rst
- [ ] Verify readthedocs builds correctly
- [ ] Create a tag in OpenFAST
- [ ] Create a merge commit in r-test and add a corresponding annotated tag
- [ ] Compile executables for Windows builds
    - [ ] AeroDyn_Driver_x64.exe
    - [ ] AeroDyn_Driver_x64_OpenMP.exe
    - [ ] AeroDyn_Inflow_C_Binding_x64.dll
    - [ ] AeroDyn_Inflow_C_Binding_x64_OpenMP.dll
    - [ ] BeamDyn_Driver_x64.exe
    - [ ] DISCON.dll (x64)
    - [ ] DISCON_ITIBarge.dll (x64)
    - [ ] DISCON_OC3Hywind.dll (x64)
    - [ ] DISCON_SC.dll (x64)
    - [ ] FAST.Farm_x64.exe
    - [ ] FAST.Farm_x64_OMP.exe
    - [ ] FAST_SFunc.mexw64
    - [ ] HydroDynDriver_x64.exe
    - [ ] HydroDyn_C_Binding_x64.dll
    - [ ] IfW_C_Binding_x64.dll
    - [ ] InflowWind_Driver_x64.exe
    - [ ] InflowWind_Driver_x64_OpenMP.exe
    - [ ] MoorDyn_Driver_x64.exe
    - [ ] MoorDyn_C_Binding_x64.dll
    - [ ] OpenFAST-Simulink_x64.dll
    - [ ] openfast_x64.exe

# Changelog

## Overview

This release includes a long awaited set of bug fixes for linearization with BeamDyn.  Anyone needing to linearize with BeamDyn should not use any version of OpenFAST prior to this release.

Other notable improvements include corrections to turbine indexing when coupled to external codes such as AMR-Wind, new linearization regression tests, and new docker images (thanks to first time contributor @cortadocodes at the @Octue organization).


## General

### Build systems

#2116 VSbuild: always build Registry as release x64 (@andrew-platt)
#2120 #2125 CMake: openmp optional for FF and CPP if not explicitly requested (@andrew-platt and @deslaughter)
#2128 VSbuild: set VS version to VS 2017 (@andrew-platt)
#2138 Remove linking of implicit Fortran libraries. (@jrood-nrel)


### Docker builds

#2124 Update dockerfile and facilitate nrel/openfast Docker Hub registry, with documentation (@cortadocodes, first time contributor)
#2139 Add final dockerfile updates (@cortadocodes)
#2141 GH actions to push docker image to Github container registry (@mayankchetan, first time contributor)


### GH actions

#2041 Upgrade to setup-python@v4 and cache@v4 for GH actions (@andrew-platt)
#2129 Fix cache failure in Github Actions caused by setup-python (@deslaughter)

### Documentation

#2130 Fix cache failure in Github Actions caused by setup-python (@andrew-platt)
#2144 Edit to readthedocs.io -- Adding Internal Reference Hyperlink for appendixD.rst (@reilandsberger, first time contributor)
#2145 Docs/update for 3.5.3 release (@andrew-platt)


## Solvers

### OpenFAST

#2060 Fix BD + AD linearization indexing (negative damping results) (@deslaugher and @andrew-platt)


## Module changes

### Multiple

#2118 Fix use of uninitialized variables in FAST.Farm and increase stack size in Visual Studio (@deslaughter and @andrew-platt)


### BeamDyn

#2063 Fix bug in BD linearization resulting from reference rotation change (@deslaughter)
#2085 Bug: BeamDyn Initial Strain and Linearization (@deslaughter)


### MoorDyn

#2049 Backport of bathymetry bugfixes in #2013 and #2016 (@RyanDavies19)


### OpenFAST library

#2097 Consistent use of turbine indexing when coupled to c/c++ (@andrew-platt and @deslaughter)


### ServoDyn

#2079 Handling of Paths for SrvD UserSubs Input Files (@rdamiani)
#2134 Bugfix seg fault if blade StC used while writing summary file (@andrew-platt)


### TurbSim

#2102 TurbSim: increase filename to 1024 characters (@andrew-platt)


## Regression tests

#2038 Add linearization regression tests (@andrew-platt)
#2055 Lin tests: increase out precision, error printing full filename, add SD linearization test (@andrew-platt)



## Input file changes

No input files change with this release, as this only includes minor bugfixes.

Full list of changes: https://openfast.readthedocs.io/en/main/source/user/api_change.html

Full input file sets: https://github.com/OpenFAST/r-test/tree/v3.5.3 (example input files from the regression testing)

