**Feature or improvement description**
Pull request to merge `rc-3.5.2` into `main` and create a tagged release for v3.5.2.

See the milestone and project pages for additional information

    https://github.com/OpenFAST/openfast/milestone/12

Test results, if applicable
See GitHub Actions

### Release checklist:
- [ ] Update the documentation version in docs/conf.py
- [ ] Update the versions in docs/source/user/api_change.rst
- [ ] Verify readthedocs builds correctly
- [ ] Create a tag in OpenFAST
- [ ] Create a merge commit in r-test and add a corresponding tag
- [ ] Compile executables for Windows builds
    - [ ] FAST_SFunc.mexw64
    - [ ] OpenFAST-Simulink_x64.dll
    - [ ] openfast_x64.exe
    - [ ] DISCON.dll (x64)
    - [ ] AeroDyn_Driver
    - [ ] AeroDyn_Inflow_C_Binding
    - [ ] BeamDyn_Driver
    - [ ] HydroDyn_Driver
    - [ ] HydroDyn_C_Binding (x64)
    - [ ] InflowWind_Driver
    - [ ] IfW_C_Binding (x64)
    - [ ] MoorDyn_Driver
    - [ ] FAST.Farm (x64)

# Changelog

## General

### Build systems

#1948 Pass Python_EXECUTABLE to pfunit, add error check on Python version


## Module changes

### AeroDyn

#1913 ADI: memory leak in ADI_UpdateStates

### AWAE

#1963 FAST.Farm, Mod_AmbWind=3: add error if HR grid not centered on turbine in Y dimension

### HydroDyn

#1872 Fix segfault in HD when no outputs specified



## Regression tests

#1886  Update floating MHK case input files



## Input file changes

No input files change with this release, as this only includes minor bugfixes.

Full list of changes: https://openfast.readthedocs.io/en/main/source/user/api_change.html

Full input file sets: https://github.com/OpenFAST/r-test/tree/v3.5.2 (example input files from the regression testing)

