**Feature or improvement description**
Pull request to merge `rc-3.5.1` into `main` and create a tagged release for v3.5.1.

See the milestone and project pages for additional information

    https://github.com/OpenFAST/openfast/milestone/10
    https://github.com/orgs/OpenFAST/projects/4

Test results, if applicable
See GitHub Actions

### Release checklist:
- [ ] Update the documentation version in docs/conf.py
- [ ] Update the versions in docs/source/user/api_change.rst
- [ ] Verify readthedocs builds correctly
- [ ] Create a tag in OpenFAST
- [ ] Create a merge commit in r-test and add a corresponding tag
- [ ] Compile executables for Windows builds
    - [ ] FAST_SFunc.mexw64
    - [ ] OpenFAST-Simulink_x64.dll
    - [ ] openfast_x64.exe
    - [ ] DISCON.dll (x64)
    - [ ] AeroDyn_Driver
    - [ ] AeroDyn_Inflow_C_Binding
    - [ ] BeamDyn_Driver
    - [ ] HydroDyn_Driver
    - [ ] HydroDyn_C_Binding (x64)
    - [ ] InflowWind_Driver
    - [ ] IfW_C_Binding (x64)
    - [ ] MoorDyn_Driver
    - [ ] FAST.Farm (x64)

# Changelog

## General

### Build systems

#1586 CMake: Remove openfast_cpp target if BUILD_OPENFAST_CPP_API not selected
#1647 Fix adding OpenMP flags to CMAKE_Fortran_FLAGS
#1818 VS-build updates for rc-3.5.1 and other minor updates.  Includes truing up some Types files.


### Documentation

#1788 Readthedocs configuration changes


## Solvers

### FAST.Farm

#1648 Fix bug with Mod_AmbWind=3 -- hub point wasn't shifted.


## Module changes

### AeroDyn

#1657 AD Driver: stack size for 64 bit solutions (see #1260)
#1658 AD/TailFin: Bug Fix: remove chord in fy (see #1653)
#1659 AD: Adding rtest for TailFin polar-based model
#1679 AD: nodal outputs in different coordinate systems (new feature)
#1700 Remove deleted variables BlFB and BlMB from AeroDyn_AllBldNdOuts_IO


### BeamDyn

#1771 Change BD states to follow the blade root reference frame.  Small performance improvements around azimuth=180.
#1796 Resolve BeamDyn initial strain for rotated blade.  Backport of #1663


### ElastoDyn

#1654 fix segfault when BldNd_BladesOut==0 (Also for AeroDyn)


### HydroDyn

#1621 [BugFix] HD wave visualization with 2nd order waves
#1780 [BugFix]  AddF0 for multiple potential-flow bodies with NBodyMod/=0 (backport of #1776)
#1768 new feature: Visualization of HydroDyn Morison mesh (also MoorDyn lines)
#1806 fixed some existing bugs with the strip-theory loads and updated the radiation convolution integral to 2nd order


### InflowWind

#1620 [BugFix] ServoDyn inputs for Lidar allocated twice, and a few other minor issues
#1655 [BugFix] InflowWind was not setting InitOut MWS data.
#1748 [BugFix] compute vel avg profile when exceed allowed
#1759 [BugFix] InflowWind Flow Field fails to calculate AvgVel for large wind files when using Intel Compiler 
#1769 [BugFix] Add additional modulo in IfW_FlowField to correct error with exhausted field from Grid3D on long simulations (see #1746 and PR #1730)


### MAP++

#1752 MAP++ linear spring approach improvement (@rbergua)


### MoorDyn

#1768 MoorDyn line visualization (see HydroDyn above)
#1727 MoorDyn updates and bug fixes (naming, catenary solve improvement, output channels, bugs with added mass, rods, and comment typos
#1815 MoorDyn dynamic relaxation and fixed bodies
#1816 Fixed drag coefficient scaling


### NWTC-Library

#1731 Blade Pitch input to ElastoDyn drifts during solution if ServoDyn is not active (improvements to Extrap/Interp routines)


### SubDyn

#1802 Increase SubDyn output to allow NMOutputs up to 99.  Backport of features from dev (multiple commits)


## Regression tests

#1581, #1593  Update floating MHK case input files
#1694 Improved linearization file comparison
#1695 AD: adding linearization tests for aerodyn continuous-states model
#1801 Add Mod_AmbWind=3 regression test to the CI


## Input file changes

No input files change with this release, as this only includes minor bugfixes.

Full list of changes: https://openfast.readthedocs.io/en/main/source/user/api_change.html

Full input file sets: https://github.com/OpenFAST/r-test/tree/v3.5.1 (example input files from the regression testing)

