# Release Notes

OpenFAST v3.4.0 includes several major new features and bug fixes.  New features include a new curled-wake model in FAST.Farm (#931), buoyancy calculations in AeroDyn 15 for MHK turbines (#957), rotor and tail furling (#1277), and new library interfaces for AeroDyn 15 and MoorDyn to couple with other codes (#1110 & #848). One major bug fix is changing the CFD coupling to use only the AeroDyn 15 mesh information -- this had led to some discrepancies in CFD results (#1324).

The full set of changes included in this version are further documented in the following listed pull requests.


### General
#889 Add a super-controller library target to CMake
#1303 Small reorganization and clean up FAST.Farm r-test input files, upload of artifact
#1311 NWTC_IO: nullifying DLL (on restart)  if not present when packing
#1318 Allow Registry to generate extrap/interp routines for types without module nickname
#1327 add version info to c-binding libraries
#1332 Documentation fixes
#1357 CI: exclude bokeh 3.0.[0-3] -- broken plots
#1376 Add `regression_tests` to the ALL target.

### Documentation
#1267 OLAF: documentation: updated guidelines and using nFWPanels instead of WakeLength
#1406 Update example InflowWind and FAST.Farm input files

### Visualization
#1319 Cleanup OpenFAST VTK output for HydroDyn
#1321 Add safety checks to VTK output
#1330 VTKLin: being more forgiving with number of modes
#1333 NWTC_Lib: Adding Yaml and VTK to library (moved from SD and AD)

### FAST.Farm
#931 Implementation of the curled-wake model in FAST.Farm
#1263 FAST.Farm WriteOutput: fix for Windows Intel OMP build
#1304 API changes for future curl wake implementation, WD restructuring (Cq, OMP, skew filt)
#1305 FF: Cartesian grid for AWAE and WD outputs
#1310 FF: additional OpenMP parallelizations in FAST.Farm
#1328  FF: update of guidelines for Curled wake dr and DT_low

### OpenFAST
#1275 Linear Trim Solution Improvements (Linearization)

### AeroDyn
#957 Calculate buoyancy for an MHK turbine
#1110 New AeroDynInflow module with c-bindings interface
#1276 Bug Fix: OLAF: particles are NaN when vortex segments have zero length
#1277 Reactivating rotor furling and tailfin aerodynamics (ElastoDyn also)
#1283 Add new projection method and BEM methods
#1293 Minor error handling and code cleanup (OLAF)
#1317 Fix for Visual Studio builds with ADI
#1347 AeroDyn/UnsteadyAero_Driver: Fix for bug #1346
#1355 OLAF: Adding free near wake panels
#1356 AeroDyn/UnsteadyAero_Driver: Fix for bug #1346
#1369 UA: adding UA_Driver outputs, fix separation function for UAMod=6, and adding r-tests

### BeamDyn
#1335 BeamDyn: output summary file in yaml format

### InflowWind
#1240 Improvements to the InflowWind disk averaged velocity calculations
#1266 Temporarily removing InflowWind parallelization

### MoorDyn
#848 MoorDyn v2 C-bindings interface
#1371 MoorDyn bending bugfix and message updates for v2

### OpenFOAM
#1324 CFD coupling to use AD15 mesh only
#1365 OpFM: [bugfix] test for warning condition was broken
#1372 [BugFix] the DEBUG_OPENFOAM preprocessor directive was never updated for multiple AD15 rotors

### TurbSim
#1361 TurbSim: User-defined time series updates

