### General
In v2.5.0, the `master` branch will become `main` and this will serve as the "trunk" or primary branch for OpenFAST. This is in line with current best practices in naming conventions (see [here](https://github.com/github/renaming)).

### AeroDyn
- #538 Update AeroDyn to allow for linearized dynamic stall and dynamic inflow models
- #538 Disable BEM if TSR <= 1, blend BEM and non-BEM when 1 < TSR < 2, output the proportion of BEM in GeomPhi output channel
- #590 [BugFix] VTK folder location, Vx sign for OLAF
- #594 [BugFix] Close a file that was opened but not closed
- #623 [BugFix] Allocate array to size 0 before getting its size
- #627 [BugFix] Fix logic for setting size of arrays for airfoil tables

### BeamDyn
- #560 Expand and improve BeamDyn unit tests
- #564 Documentation updates: Add BD OpenFAST solve section 
- #576 Replace cubic spline with least squares fit
- #619 [BugFix] Regenerate Types files after registry file changes

### FAST Library
- #550 Make channel length consistent between C and Fortran sides of interface
- #616 Fix potential memory leak and expand error handling

### HydroDyn
- #582 Use RANLUX pRNG in offshore floating regression test cases
- #586 Hd Driver - Add Morrison mesh and standalone driver test cases
- #602 Vectorize a section of VariousWaves_Init (also #606)

### InflowWind
- #578 InflowWind Updates (vertical flow angle, Bladed support, negetive height)
- #596 Add support for initializing InflowWind with string inputs

### MoorDyn
- #565 Add active tensioning capabilities in MoorDyn
- #604 [BugFix] Fix position and tension node outputs
- #619 [BugFix] Regenerate Types files after registry file changes

### NWTC Library
- #588 Add NWTC Library infrastructure for parsing inputs as strings
- #603 [BugFix] Fix order of variables declaration

### Simulink
- #545 Support for GNU compiler on Linux systems
- #577 Updated examples for OpenFAST-Simulink Interface
- #616 Fix potential memory leak and add more error handling

### Documentation
- #558 Refer to conda for installation ([docs](https://openfast.readthedocs.io/en/dev/source/install/index.html#download-binaries))
- #559 Update unit test guidance ([docs](https://openfast.readthedocs.io/en/dev/source/testing/unit_test.html))
- #614 [BugFix] Fix api_change.rst ([docs](https://openfast.readthedocs.io/en/dev/source/user/api_change.html))

### Build system
- #547 [BugFix] cmake configuration for  Linux + Intel + Debug
- #583 CMake: set CMP0074 policy explicitly to avoid warnings
- #595 Disable gfortran stack-reuse compiler option
- #610 Prevent variable tracking in large Fortran modules

### Testing
- #579 #599 #610 Improve GH Actions
