/* -*- mode: c; tab-width: 4; c-basic-offset: 4; c-file-style: "linux" -*- */
//
// Copyright (c) 2009-2011, Wei Mingzhi <whistler_wmz@users.sf.net>.
// Copyright (c) 2011-2024, SDLPAL development team.
// All rights reserved.
//
// This file is part of SDLPAL.
//
// SDLPAL is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License, version 3
// as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// fontglyph.h: Unicode font glyph definition file, converted from GNU Unifont.
//     @Author: Lou Yihua <louyihua@21cn.com>, 2015-06-07.
//

#ifndef _FONTGLYPH_H
#define _FONTGLYPH_H

#ifndef _FONT_C
#error "This file should only be included inside font.c!"
#endif

static unsigned char unicode_font[65536][32] = {
  { 170,170,0,1,128,0,0,1,128,0,74,81,234,80,90,81,201,158,0,1,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,57,147,194,82,50,95,138,82,113,147,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,59,165,193,36,49,25,137,36,113,37,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,123,165,193,36,121,25,193,36,121,37,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,121,191,194,72,122,73,194,72,121,137,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,122,77,194,82,123,83,194,214,122,79,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,49,165,202,40,122,49,202,40,73,165,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,115,209,202,16,115,209,202,16,115,223,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,30,57,145,64,30,49,145,8,30,113,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,34,249,162,32,62,33,162,32,34,33,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,32,249,160,128,32,249,160,128,62,129,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,34,249,162,32,34,33,148,32,8,33,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,62,249,160,128,62,249,160,128,32,129,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,30,241,160,136,32,241,160,144,30,137,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,30,113,160,136,28,137,130,136,60,113,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,30,249,160,32,28,33,130,32,60,249,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,57,29,165,16,37,29,165,16,57,221,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,113,137,202,24,74,9,202,8,113,157,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,113,153,202,4,74,9,202,16,113,157,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,113,153,202,4,74,25,202,4,113,153,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,113,133,202,12,74,21,202,28,113,133,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,73,147,234,84,106,89,219,212,74,83,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,52,83,194,154,49,23,137,18,113,19,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,123,185,193,36,121,57,193,36,121,57,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,51,37,196,180,71,173,196,164,52,165,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,62,137,160,216,62,169,160,136,62,137,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,58,93,194,82,50,93,138,82,113,157,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,121,207,194,16,121,145,192,80,123,143,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,30,113,144,128,30,97,144,16,16,225,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,14,113,144,128,22,97,146,16,14,225,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,28,113,146,128,28,97,148,16,18,225,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,18,113,146,128,18,97,146,16,12,225,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,8,8,8,8,8,8,8,0,8,8,0,0 },
  { 0,0,34,34,34,34,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,18,18,18,126,36,36,126,72,72,72,0,0 },
  { 0,0,0,0,8,62,73,72,56,14,9,73,62,8,0,0 },
  { 0,0,0,0,49,74,74,52,8,8,22,41,41,70,0,0 },
  { 0,0,0,0,28,34,34,20,24,41,69,66,70,57,0,0 },
  { 0,0,8,8,8,8,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,4,8,8,16,16,16,16,16,16,8,8,4,0 },
  { 0,0,0,32,16,16,8,8,8,8,8,8,16,16,32,0 },
  { 0,0,0,0,0,0,8,73,42,28,42,73,8,0,0,0 },
  { 0,0,0,0,0,0,8,8,8,127,8,8,8,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,8,8,16 },
  { 0,0,0,0,0,0,0,0,0,60,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,24,0,0 },
  { 0,0,0,0,2,2,4,8,8,16,16,32,64,64,0,0 },
  { 0,0,0,0,24,36,66,66,66,66,66,66,36,24,0,0 },
  { 0,0,0,0,8,24,40,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,60,66,66,2,12,16,32,64,64,126,0,0 },
  { 0,0,0,0,60,66,66,2,28,2,2,66,66,60,0,0 },
  { 0,0,0,0,4,12,20,36,68,68,126,4,4,4,0,0 },
  { 0,0,0,0,126,64,64,64,124,2,2,2,66,60,0,0 },
  { 0,0,0,0,28,32,64,64,124,66,66,66,66,60,0,0 },
  { 0,0,0,0,126,2,2,4,4,4,8,8,8,8,0,0 },
  { 0,0,0,0,60,66,66,66,60,66,66,66,66,60,0,0 },
  { 0,0,0,0,60,66,66,66,62,2,2,2,4,56,0,0 },
  { 0,0,0,0,0,0,24,24,0,0,0,24,24,0,0,0 },
  { 0,0,0,0,0,0,24,24,0,0,0,24,8,8,16,0 },
  { 0,0,0,0,0,2,4,8,16,32,16,8,4,2,0,0 },
  { 0,0,0,0,0,0,0,126,0,0,0,126,0,0,0,0 },
  { 0,0,0,0,0,64,32,16,8,4,8,16,32,64,0,0 },
  { 0,0,0,0,60,66,66,2,4,8,8,0,8,8,0,0 },
  { 0,0,0,0,28,34,74,86,82,82,82,78,32,30,0,0 },
  { 0,0,0,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,0,0,0,124,66,66,66,124,66,66,66,66,124,0,0 },
  { 0,0,0,0,60,66,66,64,64,64,64,66,66,60,0,0 },
  { 0,0,0,0,120,68,66,66,66,66,66,66,68,120,0,0 },
  { 0,0,0,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,0,0,0,126,64,64,64,124,64,64,64,64,64,0,0 },
  { 0,0,0,0,60,66,66,64,64,78,66,66,70,58,0,0 },
  { 0,0,0,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 0,0,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,31,4,4,4,4,4,4,68,68,56,0,0 },
  { 0,0,0,0,66,68,72,80,96,96,80,72,68,66,0,0 },
  { 0,0,0,0,64,64,64,64,64,64,64,64,64,126,0,0 },
  { 0,0,0,0,66,66,102,102,90,90,66,66,66,66,0,0 },
  { 0,0,0,0,66,98,98,82,82,74,74,70,70,66,0,0 },
  { 0,0,0,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,124,66,66,66,124,64,64,64,64,64,0,0 },
  { 0,0,0,0,60,66,66,66,66,66,66,90,102,60,3,0 },
  { 0,0,0,0,124,66,66,66,124,72,68,68,66,66,0,0 },
  { 0,0,0,0,60,66,66,64,48,12,2,66,66,60,0,0 },
  { 0,0,0,0,127,8,8,8,8,8,8,8,8,8,0,0 },
  { 0,0,0,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,65,65,65,34,34,34,20,20,8,8,0,0 },
  { 0,0,0,0,66,66,66,66,90,90,102,102,66,66,0,0 },
  { 0,0,0,0,66,66,36,36,24,24,36,36,66,66,0,0 },
  { 0,0,0,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,0,0,0,126,2,2,4,8,16,32,64,64,126,0,0 },
  { 0,0,0,14,8,8,8,8,8,8,8,8,8,8,14,0 },
  { 0,0,0,0,64,64,32,16,16,8,8,4,2,2,0,0 },
  { 0,0,0,112,16,16,16,16,16,16,16,16,16,16,112,0 },
  { 0,0,24,36,66,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,0 },
  { 0,32,16,8,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,0,0,64,64,64,92,98,66,66,66,66,98,92,0,0 },
  { 0,0,0,0,0,0,60,66,64,64,64,64,66,60,0,0 },
  { 0,0,0,2,2,2,58,70,66,66,66,66,70,58,0,0 },
  { 0,0,0,0,0,0,60,66,66,126,64,64,66,60,0,0 },
  { 0,0,0,12,16,16,16,124,16,16,16,16,16,16,0,0 },
  { 0,0,0,0,0,2,58,68,68,68,56,32,60,66,66,60 },
  { 0,0,0,64,64,64,92,98,66,66,66,66,66,66,0,0 },
  { 0,0,0,8,8,0,24,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,4,4,0,12,4,4,4,4,4,4,4,72,48 },
  { 0,0,0,64,64,64,68,72,80,96,80,72,68,66,0,0 },
  { 0,0,0,24,8,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,0,0,118,73,73,73,73,73,73,73,0,0 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,98,92,64,64 },
  { 0,0,0,0,0,0,58,70,66,66,66,66,70,58,2,2 },
  { 0,0,0,0,0,0,92,98,66,64,64,64,64,64,0,0 },
  { 0,0,0,0,0,0,60,66,64,48,12,2,66,60,0,0 },
  { 0,0,0,0,16,16,16,124,16,16,16,16,16,12,0,0 },
  { 0,0,0,0,0,0,66,66,66,66,66,66,70,58,0,0 },
  { 0,0,0,0,0,0,66,66,66,36,36,36,24,24,0,0 },
  { 0,0,0,0,0,0,65,73,73,73,73,73,73,54,0,0 },
  { 0,0,0,0,0,0,66,66,36,24,24,36,66,66,0,0 },
  { 0,0,0,0,0,0,66,66,66,66,66,38,26,2,2,60 },
  { 0,0,0,0,0,0,126,2,4,8,16,32,64,126,0,0 },
  { 0,0,0,12,16,16,8,8,16,16,8,8,16,16,12,0 },
  { 0,0,8,8,8,8,8,8,8,8,8,8,8,8,8,8 },
  { 0,0,0,48,8,8,16,16,8,8,16,16,8,8,48,0 },
  { 0,0,0,49,73,70,0,0,0,0,0,0,0,0,0,0 },
  { 170,170,0,1,128,0,0,1,128,0,115,209,202,16,75,209,202,16,115,223,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,113,157,202,82,115,211,194,82,66,93,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,73,157,202,82,122,93,202,80,73,145,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,115,147,202,82,115,159,202,18,114,19,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,75,147,234,82,91,159,202,82,75,147,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,116,185,166,164,37,165,164,164,116,185,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,75,209,234,16,91,209,202,16,75,223,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,57,205,194,18,49,159,136,82,115,147,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,121,205,194,18,121,159,192,82,123,147,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,75,157,201,32,121,25,201,4,73,57,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,37,221,164,132,60,133,164,132,36,153,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,69,205,196,144,68,137,168,132,16,153,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,114,29,202,18,114,19,194,18,67,221,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,114,19,202,18,114,19,194,18,67,205,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,14,33,137,32,14,33,138,32,9,33,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,57,221,194,2,49,141,136,80,115,159,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,57,221,194,2,49,141,136,66,115,157,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,113,207,202,16,74,13,202,2,113,221,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,114,69,202,76,114,69,194,68,65,143,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,114,93,202,66,114,77,194,80,65,159,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,59,157,193,32,49,25,137,4,113,57,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,57,211,194,18,66,31,194,18,57,211,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,34,137,182,136,42,169,162,216,34,137,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,59,141,194,82,51,159,138,18,114,19,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,123,141,194,82,123,159,194,18,122,19,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,57,143,194,80,50,77,138,66,113,157,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,51,155,196,34,37,163,148,162,99,155,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,57,221,194,8,50,9,138,8,113,221,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,57,221,194,8,65,137,192,72,59,157,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,14,249,144,32,12,33,130,32,28,33,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,49,207,202,16,73,145,200,80,51,143,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,28,137,146,216,28,169,144,136,16,137,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,51,143,202,80,123,145,202,16,74,15,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,8,8,0,8,8,8,8,8,8,8,0,0 },
  { 0,0,0,0,8,8,62,73,72,72,73,62,8,8,0,0 },
  { 0,0,0,0,14,16,16,16,124,16,16,16,62,97,0,0 },
  { 0,0,0,0,0,66,36,60,36,36,60,36,66,0,0,0 },
  { 0,0,0,0,65,34,20,8,127,8,127,8,8,8,0,0 },
  { 0,0,0,0,8,8,8,8,0,0,8,8,8,8,0,0 },
  { 0,0,0,0,60,66,64,60,66,66,60,2,66,60,0,0 },
  { 36,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,60,66,153,165,161,161,165,153,66,60,0,0 },
  { 0,0,28,2,30,34,30,0,62,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,18,18,36,36,72,36,36,18,18,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,126,2,2,2,0,0 },
  { 170,170,0,1,128,0,58,99,194,84,51,201,138,72,114,73,128,0,0,1,128,0,3,193,128,0,0,1,128,0,85,85 },
  { 0,0,0,0,60,66,185,165,165,185,169,165,66,60,0,0 },
  { 0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 16,40,40,16,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,8,8,8,127,8,8,8,0,127,0,0,0 },
  { 0,0,28,34,2,28,32,32,62,0,0,0,0,0,0,0 },
  { 0,0,28,34,2,28,2,34,28,0,0,0,0,0,0,0 },
  { 0,4,8,16,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,66,66,66,66,66,66,102,89,64,128 },
  { 0,0,0,62,122,122,122,122,58,10,10,10,10,10,14,0 },
  { 0,0,0,0,0,0,0,0,24,24,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,48 },
  { 0,0,8,24,40,8,8,8,8,0,0,0,0,0,0,0 },
  { 0,0,28,34,34,34,28,0,62,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,72,72,36,36,18,36,36,72,72,0,0 },
  { 0,0,0,0,34,98,36,40,40,18,22,42,78,66,0,0 },
  { 0,0,0,0,34,98,36,40,40,20,26,34,68,78,0,0 },
  { 0,0,0,0,98,18,36,24,104,18,22,42,78,66,0,0 },
  { 0,0,0,0,8,8,0,8,8,48,66,66,66,60,0,0 },
  { 48,12,0,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 12,48,0,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 24,36,0,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 50,76,0,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 36,36,0,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 24,36,24,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,0,0,0,31,40,72,72,127,72,72,72,72,79,0,0 },
  { 0,0,0,0,60,66,66,64,64,64,64,66,66,60,8,48 },
  { 48,12,0,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 12,48,0,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 24,36,0,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 36,36,0,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 24,6,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 12,48,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 24,36,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 36,36,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,120,68,66,66,242,66,66,66,68,120,0,0 },
  { 50,76,0,0,66,98,98,82,82,74,74,70,70,66,0,0 },
  { 48,12,0,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 12,48,0,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 24,36,0,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 50,76,0,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 36,36,0,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,0,66,36,24,36,66,0,0,0,0 },
  { 0,0,0,2,58,68,70,74,74,82,82,98,34,92,64,0 },
  { 48,12,0,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 12,48,0,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 24,36,0,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 36,36,0,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 12,48,0,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,0,0,64,64,120,68,66,66,68,120,64,64,64,0,0 },
  { 0,0,0,0,56,68,68,72,88,68,66,66,82,76,0,0 },
  { 0,0,48,12,0,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,0,12,48,0,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,0,24,36,0,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,0,50,76,0,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,0,36,36,0,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,24,36,24,0,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,0,0,0,0,0,62,73,9,63,72,72,73,62,0,0 },
  { 0,0,0,0,0,0,60,66,64,64,64,64,66,60,8,48 },
  { 0,0,48,12,0,0,60,66,66,126,64,64,66,60,0,0 },
  { 0,0,12,48,0,0,60,66,66,126,64,64,66,60,0,0 },
  { 0,0,24,36,0,0,60,66,66,126,64,64,66,60,0,0 },
  { 0,0,36,36,0,0,60,66,66,126,64,64,66,60,0,0 },
  { 0,0,48,12,0,0,24,8,8,8,8,8,8,62,0,0 },
  { 0,0,12,48,0,0,24,8,8,8,8,8,8,62,0,0 },
  { 0,0,24,36,0,0,24,8,8,8,8,8,8,62,0,0 },
  { 0,0,36,36,0,0,24,8,8,8,8,8,8,62,0,0 },
  { 0,0,50,12,20,34,2,62,66,66,66,66,66,60,0,0 },
  { 0,0,50,76,0,0,92,98,66,66,66,66,66,66,0,0 },
  { 0,0,48,12,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,12,48,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,24,36,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,50,76,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,36,36,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,24,0,0,126,0,0,24,0,0,0 },
  { 0,0,0,0,0,2,60,70,74,74,82,82,98,60,64,0 },
  { 0,0,48,12,0,0,66,66,66,66,66,66,70,58,0,0 },
  { 0,0,12,48,0,0,66,66,66,66,66,66,70,58,0,0 },
  { 0,0,24,36,0,0,66,66,66,66,66,66,70,58,0,0 },
  { 0,0,36,36,0,0,66,66,66,66,66,66,70,58,0,0 },
  { 0,0,12,48,0,0,66,66,66,66,66,38,26,2,2,60 },
  { 0,0,0,0,32,32,60,34,34,34,36,40,48,32,32,32 },
  { 0,0,36,36,0,0,66,66,66,66,66,38,26,2,2,60 },
  { 0,60,0,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,0,0,60,0,0,60,66,2,62,66,66,70,58,0,0 },
  { 66,66,60,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,66,66,60,0,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,0,0,0,24,36,36,66,66,126,66,66,66,66,4,3 },
  { 0,0,0,0,0,0,60,66,2,62,66,66,70,58,4,3 },
  { 12,48,0,0,60,66,66,64,64,64,64,66,66,60,0,0 },
  { 0,0,12,48,0,0,60,66,64,64,64,64,66,60,0,0 },
  { 24,36,0,0,60,66,66,64,64,64,64,66,66,60,0,0 },
  { 0,0,24,36,0,0,60,66,64,64,64,64,66,60,0,0 },
  { 16,16,0,0,60,66,66,64,64,64,64,66,66,60,0,0 },
  { 0,0,16,16,0,0,60,66,64,64,64,64,66,60,0,0 },
  { 36,24,0,0,60,66,66,64,64,64,64,66,66,60,0,0 },
  { 0,0,36,24,0,0,60,66,64,64,64,64,66,60,0,0 },
  { 72,48,0,0,120,68,66,66,66,66,66,66,68,120,0,0 },
  { 36,24,0,2,2,2,58,70,66,66,66,66,70,58,0,0 },
  { 0,0,0,0,120,68,66,66,242,66,66,66,68,120,0,0 },
  { 0,0,0,2,15,2,58,70,66,66,66,66,70,58,0,0 },
  { 0,60,0,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,0,0,60,0,0,60,66,66,126,64,64,66,60,0,0 },
  { 66,66,60,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,0,66,66,60,0,60,66,66,126,64,64,66,60,0,0 },
  { 16,16,0,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,0,16,16,0,0,60,66,66,126,64,64,66,60,0,0 },
  { 0,0,0,0,126,64,64,64,124,64,64,64,64,126,8,6 },
  { 0,0,0,0,0,0,60,66,66,126,64,64,66,60,16,12 },
  { 36,24,0,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,0,36,24,0,0,60,66,66,126,64,64,66,60,0,0 },
  { 24,36,0,0,60,66,66,64,64,78,66,66,70,58,0,0 },
  { 0,0,24,36,0,2,58,68,68,68,56,32,60,66,66,60 },
  { 66,66,60,0,60,66,66,64,64,78,66,66,70,58,0,0 },
  { 0,66,66,60,0,2,58,68,68,68,56,32,60,66,66,60 },
  { 16,16,0,0,60,66,66,64,64,78,66,66,70,58,0,0 },
  { 0,0,16,16,0,2,58,68,68,68,56,32,60,66,66,60 },
  { 0,0,0,0,60,66,66,64,64,78,66,66,70,58,8,48 },
  { 0,0,12,16,0,2,58,68,68,68,56,32,60,66,66,60 },
  { 24,36,0,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 48,72,0,64,64,64,92,98,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,66,66,255,66,66,126,66,66,66,66,0,0 },
  { 0,0,0,64,240,64,92,98,66,66,66,66,66,66,0,0 },
  { 50,76,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,50,76,0,0,24,8,8,8,8,8,8,62,0,0 },
  { 0,60,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,60,0,0,24,8,8,8,8,8,8,62,0,0 },
  { 66,66,60,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,66,66,60,0,24,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,62,8,8,8,8,8,8,8,8,62,8,6 },
  { 0,0,0,8,8,0,24,8,8,8,8,8,8,62,8,6 },
  { 8,8,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,0,0,24,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,66,66,66,66,66,66,2,2,66,60,0,0 },
  { 0,0,34,34,0,0,34,34,34,34,34,34,26,2,34,28 },
  { 12,18,0,0,31,4,4,4,4,4,4,68,68,56,0,0 },
  { 0,0,12,18,0,0,12,4,4,4,4,4,4,4,72,48 },
  { 0,0,0,0,66,68,72,80,96,96,80,72,68,66,32,192 },
  { 0,0,0,64,64,64,68,72,80,96,80,72,68,66,32,192 },
  { 0,0,0,0,0,0,66,68,72,112,112,72,68,66,0,0 },
  { 24,96,0,0,64,64,64,64,64,64,64,64,64,126,0,0 },
  { 12,48,0,24,8,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,64,64,64,64,64,64,64,64,64,126,8,48 },
  { 0,0,0,24,8,8,8,8,8,8,8,8,8,62,8,48 },
  { 36,24,0,0,64,64,64,64,64,64,64,64,64,126,0,0 },
  { 36,24,0,24,8,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,64,64,64,64,68,68,64,64,64,126,0,0 },
  { 0,0,0,48,16,16,16,16,20,20,16,16,16,124,0,0 },
  { 0,0,0,0,64,64,72,80,96,192,64,64,64,126,0,0 },
  { 0,0,0,24,8,8,10,12,24,40,8,8,8,62,0,0 },
  { 12,48,0,0,66,98,98,82,82,74,74,70,70,66,0,0 },
  { 0,0,12,48,0,0,92,98,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,66,98,98,82,82,74,74,70,70,66,32,192 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,66,66,32,192 },
  { 36,24,0,0,66,98,98,82,82,74,74,70,70,66,0,0 },
  { 0,0,36,24,0,0,92,98,66,66,66,66,66,66,0,0 },
  { 0,96,32,32,64,0,92,98,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,92,98,66,66,66,66,66,66,66,76,0,0 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,66,66,2,12 },
  { 0,60,0,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,60,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 66,66,60,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,66,66,60,0,60,66,66,66,66,66,66,60,0,0 },
  { 51,68,0,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,51,68,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,55,72,72,72,78,72,72,72,72,55,0,0 },
  { 0,0,0,0,0,0,54,73,73,79,72,72,73,54,0,0 },
  { 12,48,0,0,124,66,66,66,124,72,68,68,66,66,0,0 },
  { 0,0,12,48,0,0,92,98,66,64,64,64,64,64,0,0 },
  { 0,0,0,0,124,66,66,66,124,72,68,68,66,66,32,192 },
  { 0,0,0,0,0,0,92,98,66,64,64,64,64,64,32,192 },
  { 36,24,0,0,124,66,66,66,124,72,68,68,66,66,0,0 },
  { 0,0,36,24,0,0,92,98,66,64,64,64,64,64,0,0 },
  { 12,48,0,0,60,66,66,64,48,12,2,66,66,60,0,0 },
  { 0,0,12,48,0,0,60,66,64,48,12,66,66,60,0,0 },
  { 24,36,0,0,60,66,66,64,48,12,2,66,66,60,0,0 },
  { 0,0,24,36,0,0,60,66,64,48,12,2,66,60,0,0 },
  { 0,0,0,0,60,66,66,64,48,12,2,66,66,60,8,48 },
  { 0,0,0,0,0,0,60,66,64,48,12,2,66,60,8,48 },
  { 36,24,0,0,60,66,66,64,48,12,2,66,66,60,0,0 },
  { 0,0,36,24,0,0,60,66,64,48,12,2,66,60,0,0 },
  { 0,0,0,0,127,8,8,8,8,8,8,8,8,8,8,48 },
  { 0,0,0,0,16,16,16,124,16,16,16,16,16,12,8,48 },
  { 36,24,0,0,127,8,8,8,8,8,8,8,8,8,0,0 },
  { 36,24,0,0,16,16,16,124,16,16,16,16,16,12,0,0 },
  { 0,0,0,0,127,8,8,10,12,24,40,8,8,8,0,0 },
  { 0,0,0,0,16,16,16,124,16,20,24,48,80,12,0,0 },
  { 50,76,0,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,50,76,0,0,66,66,66,66,66,66,70,58,0,0 },
  { 0,60,0,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,60,0,0,66,66,66,66,66,66,70,58,0,0 },
  { 66,66,60,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,66,66,60,0,0,66,66,66,66,66,66,70,58,0,0 },
  { 24,36,24,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,24,36,24,0,66,66,66,66,66,66,70,58,0,0 },
  { 51,68,0,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,51,68,0,0,66,66,66,66,66,66,70,58,0,0 },
  { 0,0,0,0,66,66,66,66,66,66,66,66,66,60,16,12 },
  { 0,0,0,0,0,0,66,66,66,66,66,66,70,58,4,3 },
  { 24,36,0,0,66,66,66,66,90,90,102,102,66,66,0,0 },
  { 0,0,24,36,0,0,65,73,73,73,73,73,73,54,0,0 },
  { 24,36,0,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,0,24,36,0,0,66,66,66,66,66,38,26,2,2,60 },
  { 36,36,0,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 12,48,0,0,126,2,2,4,8,16,32,64,64,126,0,0 },
  { 0,0,12,48,0,0,126,2,4,8,16,32,64,126,0,0 },
  { 16,16,0,0,126,2,2,4,8,16,32,64,64,126,0,0 },
  { 0,0,16,16,0,0,126,2,4,8,16,32,64,126,0,0 },
  { 36,24,0,0,126,2,2,4,8,16,32,64,64,126,0,0 },
  { 0,0,36,24,0,0,126,2,4,8,16,32,64,126,0,0 },
  { 0,0,0,12,16,16,16,48,16,16,16,16,16,16,0,0 },
  { 0,0,0,64,240,64,92,98,66,66,66,66,98,92,0,0 },
  { 0,0,0,0,124,162,162,34,60,34,34,34,34,60,0,0 },
  { 0,0,0,0,126,64,64,64,124,66,66,66,66,124,0,0 },
  { 0,0,0,0,126,64,64,92,98,66,66,66,98,92,0,0 },
  { 0,0,0,0,96,32,32,32,60,34,34,34,34,60,0,0 },
  { 0,0,0,0,0,0,96,32,32,32,60,34,34,60,0,0 },
  { 0,0,0,0,60,66,66,2,2,2,2,66,66,124,0,0 },
  { 0,0,3,4,60,68,68,64,64,64,64,68,68,56,0,0 },
  { 0,0,0,0,3,4,60,68,64,64,64,64,68,56,0,0 },
  { 0,0,0,0,120,68,66,66,242,66,66,66,68,120,0,0 },
  { 0,0,0,0,120,164,162,34,34,34,34,34,36,56,0,0 },
  { 0,0,0,0,126,2,2,2,62,66,66,66,66,62,0,0 },
  { 0,0,0,0,126,2,2,58,70,66,66,66,70,58,0,0 },
  { 0,0,0,0,0,0,60,66,66,66,66,36,24,4,4,56 },
  { 0,0,0,0,126,2,2,2,62,2,2,2,2,126,0,0 },
  { 0,0,0,0,24,36,66,2,2,126,66,66,36,24,0,0 },
  { 0,0,0,0,60,66,66,64,56,64,64,66,66,60,0,0 },
  { 0,0,0,0,31,16,16,16,30,16,16,16,16,16,96,0 },
  { 0,0,0,12,16,16,16,124,16,16,16,16,16,16,96,0 },
  { 0,0,0,3,60,68,68,64,64,92,68,68,76,52,0,0 },
  { 0,0,0,0,66,66,66,36,36,24,24,36,36,24,0,0 },
  { 0,0,0,64,64,64,64,114,74,74,74,74,74,68,0,0 },
  { 0,0,0,112,16,16,16,16,16,16,16,16,16,12,0,0 },
  { 0,0,0,0,62,8,8,8,62,8,8,8,8,62,0,0 },
  { 0,0,0,0,70,74,80,80,96,96,80,72,68,66,0,0 },
  { 0,0,0,48,72,64,68,72,80,96,80,72,68,66,0,0 },
  { 0,0,0,24,8,8,8,62,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,36,40,16,48,72,24,36,36,66,66,0,0 },
  { 0,0,0,0,73,73,73,73,73,73,73,73,73,55,0,0 },
  { 0,0,0,0,34,34,50,50,42,42,38,38,34,34,192,0 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,66,66,2,2 },
  { 0,0,0,0,60,66,66,66,126,66,66,66,66,60,0,0 },
  { 0,0,0,2,58,68,68,68,68,68,68,68,68,56,0,0 },
  { 0,0,0,0,0,2,58,68,68,68,68,68,68,56,0,0 },
  { 0,0,0,0,54,74,74,74,74,74,74,74,74,50,2,2 },
  { 0,0,0,0,0,0,54,74,74,74,74,74,74,50,2,2 },
  { 0,0,0,0,62,81,81,17,30,16,16,16,16,16,0,0 },
  { 0,0,0,0,0,3,92,100,68,68,68,68,100,88,64,64 },
  { 0,0,0,0,112,32,60,34,34,60,40,36,34,33,0,0 },
  { 0,0,0,0,60,66,66,2,12,48,64,66,66,60,0,0 },
  { 0,0,0,0,0,0,60,66,2,12,48,64,66,60,0,0 },
  { 0,0,0,0,126,64,32,16,8,8,16,32,64,126,0,0 },
  { 0,0,0,32,80,80,48,16,16,16,16,16,16,16,12,0 },
  { 0,0,0,0,16,16,16,124,16,16,16,16,16,12,4,24 },
  { 0,0,0,0,63,72,72,8,8,8,8,8,8,8,0,0 },
  { 0,0,0,12,16,16,16,124,16,16,16,16,16,12,0,0 },
  { 0,0,0,0,127,8,8,8,8,8,8,8,8,8,6,0 },
  { 0,0,1,1,70,68,68,68,68,68,68,68,68,56,0,0 },
  { 0,0,0,0,1,1,70,68,68,68,68,68,76,52,0,0 },
  { 0,0,0,0,66,36,36,66,66,66,66,66,36,24,0,0 },
  { 0,0,0,0,76,66,66,66,66,66,66,68,72,48,0,0 },
  { 0,0,0,0,70,69,68,40,40,16,16,16,16,16,0,0 },
  { 0,0,0,0,0,3,68,68,68,68,68,36,28,4,4,56 },
  { 0,0,0,0,126,2,4,8,60,16,32,64,64,126,0,0 },
  { 0,0,0,0,0,0,126,4,8,60,16,32,64,126,0,0 },
  { 0,0,0,0,126,4,8,16,28,2,2,2,70,60,0,0 },
  { 0,0,0,0,126,32,16,8,56,64,64,64,98,60,0,0 },
  { 0,0,0,0,0,0,124,32,16,8,56,64,64,64,66,60 },
  { 0,0,0,0,0,0,62,4,8,28,2,2,60,64,66,60 },
  { 0,0,0,0,60,66,66,4,8,126,32,64,64,126,0,0 },
  { 0,0,0,0,126,32,32,32,60,2,2,2,66,60,0,0 },
  { 0,0,0,0,0,0,126,32,32,60,2,2,66,60,0,0 },
  { 0,0,0,0,16,16,124,16,16,24,4,4,68,56,0,0 },
  { 0,0,0,0,0,0,92,98,66,66,68,72,80,96,64,64 },
  { 0,0,0,16,16,16,16,16,16,16,16,16,16,16,0,0 },
  { 0,0,0,40,40,40,40,40,40,40,40,40,40,40,0,0 },
  { 0,0,0,16,16,16,16,124,16,124,16,16,16,16,0,0 },
  { 0,0,0,0,8,8,8,8,8,8,8,0,8,8,0,0 },
  { 5,2,0,0,103,81,81,81,82,82,84,84,84,103,0,0 },
  { 0,0,5,2,96,80,87,81,81,82,82,84,84,103,0,0 },
  { 0,0,5,18,16,16,55,81,81,82,82,84,84,55,0,0 },
  { 0,0,0,0,71,65,65,65,65,65,65,73,73,118,0,0 },
  { 0,0,0,1,65,64,67,65,65,65,65,65,65,121,2,12 },
  { 0,0,0,97,33,32,35,33,33,33,33,33,33,249,2,12 },
  { 0,0,0,0,75,73,73,105,105,89,89,77,77,74,0,0 },
  { 0,0,0,1,73,72,107,105,105,89,89,89,73,73,18,12 },
  { 0,0,0,1,1,0,83,105,73,73,73,73,73,73,18,12 },
  { 36,24,0,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,0,36,24,0,0,60,66,2,62,66,66,70,58,0,0 },
  { 36,24,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,36,24,0,0,24,8,8,8,8,8,8,62,0,0 },
  { 36,24,0,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,36,24,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 36,24,0,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,36,24,0,0,66,66,66,66,66,66,70,58,0,0 },
  { 60,0,36,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,60,0,36,36,0,66,66,66,66,66,66,70,58,0,0 },
  { 12,48,0,36,0,66,66,66,66,66,66,66,66,60,0,0 },
  { 12,48,0,36,36,0,66,66,66,66,66,66,70,58,0,0 },
  { 36,24,0,36,0,66,66,66,66,66,66,66,66,60,0,0 },
  { 36,24,0,36,36,0,66,66,66,66,66,66,70,58,0,0 },
  { 48,12,0,36,0,66,66,66,66,66,66,66,66,60,0,0 },
  { 48,12,0,36,36,0,66,66,66,66,66,66,70,58,0,0 },
  { 0,0,0,0,0,0,60,66,2,2,126,66,66,60,0,0 },
  { 60,0,36,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,60,0,36,36,0,60,66,2,62,66,66,70,58,0,0 },
  { 60,0,24,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,60,0,16,16,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,60,0,0,31,40,72,72,127,72,72,72,72,79,0,0 },
  { 0,0,0,60,0,0,62,73,9,63,72,72,73,62,0,0 },
  { 0,0,0,0,60,66,66,64,64,78,66,79,66,62,0,0 },
  { 0,0,0,0,0,2,58,68,68,68,56,32,60,79,66,60 },
  { 36,24,0,0,60,66,66,64,64,78,66,66,70,58,0,0 },
  { 0,0,36,24,0,2,58,68,68,68,56,32,60,66,66,60 },
  { 36,24,0,0,66,68,72,80,96,96,80,72,68,66,0,0 },
  { 36,24,0,64,64,64,68,72,80,96,80,72,68,66,0,0 },
  { 0,0,0,0,60,66,66,66,66,66,66,66,66,60,16,12 },
  { 0,0,0,0,0,0,60,66,66,66,66,66,66,60,16,12 },
  { 0,60,0,0,60,66,66,66,66,66,66,66,66,60,16,12 },
  { 0,0,0,60,0,0,60,66,66,66,66,66,66,60,16,12 },
  { 36,24,0,0,126,4,8,16,28,2,2,2,70,60,0,0 },
  { 0,0,36,24,0,0,62,4,8,16,28,2,2,2,66,60 },
  { 0,0,18,12,0,0,12,4,4,4,4,4,4,4,72,48 },
  { 0,0,0,0,103,81,81,81,82,82,84,84,84,103,0,0 },
  { 0,0,0,0,96,80,87,81,81,82,82,84,84,103,0,0 },
  { 0,0,0,16,16,16,55,81,81,82,82,84,84,55,0,0 },
  { 12,48,0,0,60,66,66,64,64,78,66,66,70,58,0,0 },
  { 0,0,12,48,0,2,58,68,68,68,56,32,60,66,66,60 },
  { 0,0,0,0,72,72,72,74,122,74,74,74,74,68,0,0 },
  { 0,0,0,0,92,98,66,66,68,72,80,96,64,64,64,0 },
  { 0,48,12,0,66,98,98,82,82,74,74,70,70,66,0,0 },
  { 0,0,0,48,12,0,92,98,66,66,66,66,66,66,0,0 },
  { 12,48,24,36,24,24,36,36,66,126,66,66,66,66,0,0 },
  { 12,48,0,24,36,24,0,60,66,2,62,66,70,58,0,0 },
  { 6,24,0,0,31,40,72,72,127,72,72,72,72,79,0,0 },
  { 0,0,6,24,0,0,62,73,9,63,72,72,73,62,0,0 },
  { 12,48,0,2,58,68,70,74,74,82,82,98,34,92,64,0 },
  { 0,0,12,48,0,2,60,70,74,74,82,82,98,60,64,0 },
  { 204,34,0,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,0,204,34,0,0,60,66,2,62,66,66,70,58,0,0 },
  { 60,66,66,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,0,60,66,66,0,60,66,2,62,66,66,70,58,0,0 },
  { 204,34,0,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,0,204,34,0,0,60,66,66,126,64,64,66,60,0,0 },
  { 60,66,66,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,0,60,66,66,0,60,66,66,126,64,64,66,60,0,0 },
  { 204,34,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,204,34,0,0,24,8,8,8,8,8,8,62,0,0 },
  { 60,66,66,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,60,66,66,0,24,8,8,8,8,8,8,62,0,0 },
  { 204,34,0,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,204,34,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 60,66,66,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,60,66,66,0,60,66,66,66,66,66,66,60,0,0 },
  { 204,34,0,0,124,66,66,66,124,72,68,68,66,66,0,0 },
  { 0,0,204,34,0,0,92,98,66,64,64,64,64,64,0,0 },
  { 60,66,66,0,124,66,66,66,124,72,68,68,66,66,0,0 },
  { 0,0,60,66,66,0,92,98,66,64,64,64,64,64,0,0 },
  { 204,34,0,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,204,34,0,0,66,66,66,66,66,66,70,58,0,0 },
  { 60,66,66,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,60,66,66,0,66,66,66,66,66,66,70,58,0,0 },
  { 0,0,0,0,60,66,66,64,48,12,2,66,66,60,8,16 },
  { 0,0,0,0,0,0,60,66,64,48,12,2,66,60,8,16 },
  { 0,0,0,0,127,8,8,8,8,8,8,8,8,8,2,4 },
  { 0,0,0,0,16,16,16,124,16,16,16,16,16,12,32,64 },
  { 0,0,0,0,60,66,66,2,12,52,2,2,2,60,0,0 },
  { 0,0,0,0,0,0,60,66,2,12,50,2,12,48,0,0 },
  { 0,36,24,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 0,36,24,0,64,64,64,92,98,66,66,66,66,66,0,0 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,66,66,2,2 },
  { 0,0,0,2,2,2,58,70,66,66,66,66,71,59,2,4 },
  { 0,0,0,0,8,36,66,66,36,60,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,18,34,36,24,36,34,34,28,0,0 },
  { 0,0,0,0,126,2,2,4,8,16,32,64,64,126,2,4 },
  { 0,0,0,0,0,0,126,2,4,8,16,32,64,126,2,4 },
  { 0,0,8,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,0,0,0,8,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,0,0,0,126,64,64,64,124,64,64,64,64,126,8,48 },
  { 0,0,0,0,0,0,60,66,66,126,64,64,66,60,8,48 },
  { 60,0,36,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,60,0,36,0,60,66,66,66,66,66,66,60,0,0 },
  { 60,0,50,76,0,60,66,66,66,66,66,66,66,60,0,0 },
  { 0,60,0,50,76,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,8,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,8,0,60,66,66,66,66,66,66,60,0,0 },
  { 60,0,8,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,60,0,8,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,62,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,0,0,0,60,0,66,66,66,66,66,38,26,2,2,60 },
  { 0,0,0,24,8,8,8,8,8,8,8,8,12,12,16,32 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,67,67,2,4 },
  { 0,0,0,0,16,16,16,124,16,16,16,16,22,14,8,16 },
  { 0,0,0,0,0,0,12,4,4,4,4,4,4,4,72,48 },
  { 0,0,0,16,16,16,84,186,146,146,146,146,186,84,0,0 },
  { 0,0,0,0,0,0,84,186,146,146,146,146,186,84,16,16 },
  { 0,0,0,2,26,36,44,74,82,126,98,66,66,194,0,0 },
  { 0,0,0,2,60,70,74,72,80,80,96,98,66,124,128,0 },
  { 0,0,0,0,2,4,60,74,80,80,96,96,66,124,128,0 },
  { 0,0,0,0,32,32,32,32,120,32,32,32,32,62,0,0 },
  { 0,0,1,2,127,12,12,8,8,24,24,40,40,72,0,0 },
  { 0,0,0,0,0,0,60,66,64,48,12,2,66,60,9,6 },
  { 0,0,0,0,0,0,126,2,4,8,16,32,64,96,16,14 },
  { 0,0,0,0,60,66,66,2,4,8,8,8,8,8,0,0 },
  { 0,0,0,0,0,0,60,66,66,2,4,8,8,8,0,0 },
  { 0,0,0,0,60,34,34,34,60,34,122,34,34,60,0,0 },
  { 0,0,0,0,68,68,68,68,68,254,68,68,68,56,0,0 },
  { 0,0,0,0,24,24,24,36,36,36,36,66,66,66,0,0 },
  { 0,0,4,4,126,72,72,80,124,80,80,96,96,126,64,64 },
  { 0,0,0,0,0,2,60,70,74,126,80,96,66,124,128,0 },
  { 0,0,0,0,31,4,4,4,4,31,4,68,68,56,0,0 },
  { 0,0,0,4,4,0,12,4,4,31,4,4,4,4,72,48 },
  { 0,0,0,0,56,68,68,68,68,68,68,68,76,52,4,3 },
  { 0,0,0,0,0,0,52,76,68,68,68,68,76,52,4,3 },
  { 0,0,0,0,60,34,34,34,124,40,36,36,34,34,0,0 },
  { 0,0,0,0,0,0,44,50,34,112,32,32,32,32,0,0 },
  { 0,0,0,0,65,65,34,127,20,8,8,8,8,8,0,0 },
  { 0,0,0,0,0,0,34,34,34,127,34,18,14,2,2,28 },
  { 0,0,0,0,0,0,92,98,66,66,124,64,66,60,0,0 },
  { 0,0,0,0,0,0,58,70,66,66,66,70,74,50,0,0 },
  { 0,0,0,0,0,0,76,82,98,66,66,66,98,92,0,0 },
  { 0,0,0,56,64,64,92,98,66,66,66,66,98,92,0,0 },
  { 0,0,0,0,0,0,60,66,2,2,2,2,66,60,0,0 },
  { 0,0,0,0,0,0,60,66,64,64,64,76,82,60,64,0 },
  { 0,0,0,4,4,4,52,76,68,68,68,68,76,52,3,0 },
  { 0,0,0,3,4,4,52,76,68,68,68,68,76,52,0,0 },
  { 0,0,0,0,0,0,60,66,66,126,2,2,66,60,0,0 },
  { 0,0,0,0,0,0,60,66,2,2,126,66,66,60,0,0 },
  { 0,0,0,0,0,0,57,70,4,4,124,68,68,56,0,0 },
  { 0,0,0,0,0,0,60,66,64,60,64,64,66,60,0,0 },
  { 0,0,0,0,0,0,60,66,2,60,2,2,66,60,0,0 },
  { 0,0,0,0,0,0,57,70,4,56,4,4,68,56,0,0 },
  { 0,0,0,0,0,0,60,66,66,92,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,12,4,4,4,31,4,4,4,72,48 },
  { 0,0,0,0,0,3,52,76,68,68,68,76,52,4,68,56 },
  { 0,0,0,0,0,0,58,70,66,66,66,70,58,2,66,60 },
  { 0,0,0,0,0,0,60,66,64,64,78,66,66,62,0,0 },
  { 0,0,0,0,0,0,66,66,66,36,36,24,24,36,36,24 },
  { 0,0,0,0,0,0,66,66,36,36,24,24,36,24,0,0 },
  { 0,0,0,0,0,66,66,66,66,66,66,70,58,2,2,2 },
  { 0,0,0,56,64,64,92,98,66,66,66,66,66,66,0,0 },
  { 0,0,0,56,64,64,92,98,66,66,66,66,66,76,0,0 },
  { 0,0,0,8,8,0,24,8,8,62,8,8,8,62,0,0 },
  { 0,0,0,0,0,0,16,16,16,16,16,16,16,12,0,0 },
  { 0,0,0,0,0,0,62,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,24,8,8,8,58,76,8,8,8,8,62,0,0 },
  { 0,0,0,24,8,8,56,72,62,8,8,8,8,62,0,0 },
  { 0,0,0,24,8,8,8,8,8,8,8,8,8,8,6,0 },
  { 0,0,0,48,16,16,31,17,18,20,22,17,17,125,9,6 },
  { 0,0,0,0,0,0,73,73,73,73,73,73,73,55,0,0 },
  { 0,0,0,0,0,0,73,73,73,73,73,73,73,55,1,1 },
  { 0,0,0,0,0,0,118,73,73,73,73,73,73,65,6,0 },
  { 0,0,0,0,0,0,22,25,17,17,17,17,17,17,96,0 },
  { 0,0,0,0,0,0,88,100,68,68,68,68,68,68,3,0 },
  { 0,0,0,0,0,0,66,66,98,82,74,70,66,66,0,0 },
  { 0,0,0,0,0,0,60,66,66,126,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,55,72,72,78,72,72,72,55,0,0 },
  { 0,0,0,0,0,0,62,65,65,73,73,73,73,54,0,0 },
  { 0,0,0,0,8,8,62,73,73,73,73,73,73,62,8,8 },
  { 0,0,0,0,0,0,2,2,2,2,2,66,70,58,0,0 },
  { 0,0,0,0,2,2,2,2,2,2,2,66,70,58,0,0 },
  { 0,0,0,0,0,0,4,4,4,4,4,68,76,52,3,0 },
  { 0,0,0,0,0,0,92,98,66,64,64,64,64,64,64,64 },
  { 0,0,0,0,0,0,92,98,66,64,64,64,64,64,48,0 },
  { 0,0,0,0,0,0,60,66,66,64,64,64,64,64,0,0 },
  { 0,0,0,0,0,0,60,66,66,2,2,2,2,2,0,0 },
  { 0,0,0,0,0,0,124,66,66,124,68,66,66,66,0,0 },
  { 0,0,0,0,0,0,66,66,66,68,124,66,66,124,0,0 },
  { 0,0,0,0,0,0,60,66,64,48,12,2,66,124,64,48 },
  { 0,0,0,12,16,16,16,16,16,16,16,16,16,16,96,0 },
  { 0,0,0,12,16,16,16,16,16,16,124,16,16,16,96,0 },
  { 0,0,0,0,0,0,96,16,16,16,16,16,16,16,12,0 },
  { 0,0,0,6,8,8,8,8,8,8,8,8,56,78,48,0 },
  { 0,0,0,0,96,16,16,16,16,16,16,124,16,16,0,0 },
  { 0,0,0,0,16,16,16,124,16,16,16,16,16,16,14,0 },
  { 0,0,0,0,0,0,34,34,34,127,34,34,38,26,0,0 },
  { 0,0,0,0,0,0,66,36,66,66,66,66,36,24,0,0 },
  { 0,0,0,0,0,0,76,66,66,66,66,68,72,48,0,0 },
  { 0,0,0,0,0,0,24,24,36,36,36,66,66,66,0,0 },
  { 0,0,0,0,0,0,54,73,73,73,73,73,73,65,0,0 },
  { 0,0,0,0,0,0,60,64,64,88,100,66,66,66,66,66 },
  { 0,0,0,0,0,0,65,65,34,20,8,8,8,8,0,0 },
  { 0,0,0,0,0,0,124,8,8,16,16,32,32,124,4,3 },
  { 0,0,0,0,0,0,126,2,4,8,16,38,73,126,16,0 },
  { 0,0,0,0,0,0,62,4,8,16,28,2,2,2,66,60 },
  { 0,0,0,0,0,0,62,4,8,16,28,2,2,50,74,60 },
  { 0,0,0,0,60,66,66,2,4,8,8,8,8,8,0,0 },
  { 0,0,0,0,60,66,66,64,32,16,16,16,16,16,0,0 },
  { 0,0,0,0,8,8,8,8,8,4,2,66,66,60,0,0 },
  { 0,0,0,0,0,0,60,66,64,64,64,64,64,64,66,60 },
  { 0,0,0,0,0,0,60,66,66,90,90,66,66,60,0,0 },
  { 0,0,0,0,0,0,124,66,66,124,66,66,66,124,0,0 },
  { 0,0,0,0,0,0,60,66,66,58,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,59,68,64,64,76,68,68,60,0,0 },
  { 0,0,0,0,0,0,34,34,34,62,34,34,34,34,0,0 },
  { 0,0,0,4,4,0,12,4,4,4,4,4,4,62,72,48 },
  { 0,0,0,0,0,66,34,18,10,6,10,18,34,2,2,2 },
  { 0,0,0,0,0,0,64,64,64,64,64,64,64,126,0,0 },
  { 0,0,0,0,0,3,52,76,68,68,68,68,76,52,4,4 },
  { 0,0,0,0,60,66,66,2,4,8,8,62,8,8,0,0 },
  { 0,0,0,0,60,66,66,64,32,16,16,124,16,16,0,0 },
  { 0,0,0,16,16,16,63,81,82,82,84,84,88,63,0,0 },
  { 0,0,0,16,16,16,63,81,82,84,86,81,81,49,9,6 },
  { 0,0,0,16,16,16,63,81,82,84,88,90,85,62,4,0 },
  { 0,0,0,0,64,64,70,248,72,68,66,65,65,62,0,0 },
  { 0,0,0,3,36,36,36,124,36,36,36,36,36,28,4,24 },
  { 0,0,0,0,64,64,70,249,72,72,72,74,77,62,4,0 },
  { 0,0,0,0,48,72,64,110,81,81,81,81,81,81,2,12 },
  { 0,0,0,96,32,32,32,39,40,40,38,33,33,62,0,0 },
  { 0,0,0,192,64,64,64,64,126,68,72,80,96,126,0,0 },
  { 0,0,0,65,73,73,73,54,0,65,73,73,73,54,0,0 },
  { 0,0,0,0,126,66,66,66,0,0,126,66,66,66,0,0 },
  { 0,0,0,0,0,0,100,36,36,36,36,36,44,20,4,4 },
  { 0,0,0,0,0,0,100,36,36,36,36,36,44,20,4,3 },
  { 0,0,0,0,32,32,44,50,34,34,0,0,0,0,0,0 },
  { 0,0,0,28,34,32,44,50,34,34,0,0,0,0,0,0 },
  { 0,0,0,4,0,4,4,4,36,24,0,0,0,0,0,0 },
  { 0,0,0,0,44,50,32,32,32,0,0,0,0,0,0,0 },
  { 0,0,0,0,4,4,4,76,52,0,0,0,0,0,0,0 },
  { 0,0,0,0,4,4,4,76,52,3,0,0,0,0,0,0 },
  { 0,0,0,0,68,72,120,68,68,120,0,0,0,0,0,0 },
  { 0,0,0,0,68,84,84,40,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,68,68,60,4,56,0,0,0,0,0,0,0 },
  { 0,0,0,0,8,16,32,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,18,36,72,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,8,16,16,24,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,24,8,8,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,24,16,16,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,48,8,4,4,8,48,0,0,0,0,0,0,0 },
  { 0,0,0,12,16,32,32,16,12,0,0,0,0,0,0,0 },
  { 0,0,0,60,66,2,2,28,16,16,0,0,0,0,0,0 },
  { 0,0,0,60,66,64,64,56,8,8,0,0,0,0,0,0 },
  { 0,0,0,4,8,16,32,16,8,4,0,0,0,0,0,0 },
  { 0,0,0,32,16,8,4,8,16,32,0,0,0,0,0,0 },
  { 0,0,0,0,8,20,34,65,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,65,34,20,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,24,36,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,36,24,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,8,8,8,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,60,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,12,48,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,48,12,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,8,8,8,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,60,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,48,12,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,12,48,0 },
  { 0,0,0,0,0,0,0,56,16,0,0,16,56,0,0,0 },
  { 0,0,0,0,0,0,0,0,56,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,48,8,4,4,8,48,0,0,0,0 },
  { 0,0,0,0,0,0,12,16,32,32,16,12,0,0,0,0 },
  { 0,0,0,0,0,0,0,16,16,16,16,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,124,16,16,16,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,16,16,124,16,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,124,0,0,0,0,0,0 },
  { 0,0,66,66,60,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,24,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,24,36,24,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,6 },
  { 0,0,50,76,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,51,68,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,32,96,162,28,0,0,0,0,0 },
  { 0,0,0,0,66,36,24,36,66,0,0,0,0,0,0,0 },
  { 0,0,0,0,68,40,16,40,40,16,0,0,0,0,0,0 },
  { 0,0,48,16,16,16,16,56,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,60,64,56,4,120,0,0,0,0,0,0,0 },
  { 0,0,0,0,68,40,16,40,68,0,0,0,0,0,0,0 },
  { 0,0,60,64,64,56,8,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,124,4,4,4,4,4,4,4,4,4,4,0,0 },
  { 0,0,0,4,4,124,4,4,4,4,4,4,4,4,0,0 },
  { 0,0,0,4,4,4,4,4,124,4,4,4,4,4,0,0 },
  { 0,0,0,4,4,4,4,4,4,4,4,124,4,4,0,0 },
  { 0,0,0,4,4,4,4,4,4,4,4,4,4,124,0,0 },
  { 0,0,0,0,0,0,0,0,64,64,64,64,64,124,0,0 },
  { 0,0,0,0,0,0,0,64,64,64,120,64,64,64,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,68,40,16,0,0 },
  { 0,0,126,0,126,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,102,34,34,68,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,68,40,16,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,16,40,68,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,8,16,8,4,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,8,4,8,16,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,36,24,0 },
  { 0,0,32,16,8,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,72,36,18,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,18,36,72,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,76 },
  { 0,0,0,24,24,0,0,0,24,24,0,0,0,0,0,0 },
  { 0,0,0,56,32,32,32,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,56,8,8,8,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,32,32,32,56,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,8,8,56,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,66,66,126 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,64,64,126 },
  { 0,0,0,0,0,0,16,32,126,32,16,0,0,0,0,0 },
  { 0,32,16,8,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,4,8,16,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,24,36,66,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,50,76,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,66,66,60,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,24,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,102,102,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,24,36,4,8,8,0,0,0,0,0,0,0,0,0,0 },
  { 0,24,36,36,24,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,18,36,72,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,66,36,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,36,36,36,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,72,36,18,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,24,90,66,60,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,60,66,66,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,8,16,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,24,8,16,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,24,16,8,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,6,2,4,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,16,8,4,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,16,32,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,56,8,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,16,28,16,0 },
  { 0,14,2,2,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,10,2,4,8,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,32,24,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,16,16,56,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,56,16,16,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,16,16,124,16,16 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,60,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,2,2,18,12,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,8,9,6,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,24,24,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,102,102,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,36,36,24 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,24,8,16 },
  { 0,0,0,0,0,0,0,0,0,0,0,16,24,4,56,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,8,6,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,16,16,16,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,126,66,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,73,73,54,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,66,36,24,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,36,66,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,66,66,60,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,60,66,66,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,50,76,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,126,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,255,0,255,0 },
  { 0,0,0,0,0,0,0,0,50,76,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,60,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,189,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,2,12,24,48,64,0,0,0,0,0 },
  { 0,0,0,0,0,3,2,12,24,48,64,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,4,4,24 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,66,126,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,60,36,36,60 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,108,146,16 },
  { 0,102,24,102,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 8,16,16,8,16,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,255,0,255,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,64,32,16,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,2,4,8,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,52,72,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,48,16,32,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,16,16,84,68,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,16,16,16,12 },
  { 0,126,66,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,126,0,126 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,36 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,8 },
  { 0,8,58,92,16,0,0,0,0,0,0,0,0,0,0,0 },
  { 16,16,50,92,16,16,0,0,0,0,0,0,0,0,0,0 },
  { 50,76,0,50,76,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,34,127,34 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,28,8,8 },
  { 85,85,128,0,0,1,128,0,57,195,194,2,66,227,194,42,57,197,128,0,2,65,128,0,4,33,128,0,2,65,170,170 },
  { 4,2,4,8,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,32,32,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 60,66,90,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,36,24,24 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,4,8,16,8 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,16,8,4,8 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,132,74,42,81 },
  { 24,4,4,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,84,56,124,56 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,56,84,84,84 },
  { 8,16,62,4,8,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,2,63,252 },
  { 0,0,64,2,48,12,15,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,31,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,248 },
  { 0,0,30,2,33,132,64,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,15,240,48,12,64,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,31,248,0,16 },
  { 60,68,68,76,52,0,0,0,0,0,0,0,0,0,0,0 },
  { 56,68,120,64,60,0,0,0,0,0,0,0,0,0,0,0 },
  { 16,0,48,16,56,0,0,0,0,0,0,0,0,0,0,0 },
  { 56,68,68,68,56,0,0,0,0,0,0,0,0,0,0,0 },
  { 68,68,68,68,60,0,0,0,0,0,0,0,0,0,0,0 },
  { 56,64,64,64,56,0,0,0,0,0,0,0,0,0,0,0 },
  { 4,4,60,36,60,0,0,0,0,0,0,0,0,0,0,0 },
  { 32,32,60,36,36,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,236,146,146,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,56,36,32,32,0,0,0,0,0,0,0,0,0,0,0 },
  { 32,120,32,32,24,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,68,68,40,16,0,0,0,0,0,0,0,0,0,0,0 },
  { 36,24,24,36,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,64,64,64,64,124,64,64,64,64,64,0,0 },
  { 0,0,0,0,0,0,32,80,80,30,16,16,16,16,0,0 },
  { 0,0,0,0,254,146,146,146,16,16,16,16,16,16,0,0 },
  { 0,0,0,0,124,84,84,84,16,16,16,16,16,16,0,0 },
  { 0,0,0,0,12,24,16,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,12,24,16,32 },
  { 0,0,0,0,66,70,70,74,74,82,82,98,98,66,0,0 },
  { 0,0,0,0,0,0,136,152,152,168,168,202,202,132,0,0 },
  { 0,0,127,254,115,142,109,246,109,198,109,246,115,142,127,254,127,254,97,206,125,182,123,206,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,246,109,198,109,246,115,142,127,254,127,254,97,206,125,182,123,198,119,246,119,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,24 },
  { 0,0,0,0,0,0,60,66,2,2,2,2,66,60,0,0 },
  { 0,0,0,0,0,0,60,66,64,88,88,64,66,60,0,0 },
  { 0,0,0,0,0,0,60,66,2,26,26,2,66,60,0,0 },
  { 0,0,0,0,0,0,0,0,24,24,0,0,24,8,8,16 },
  { 0,0,0,0,31,4,4,4,4,4,4,68,68,56,0,0 },
  { 0,0,127,254,115,142,109,246,109,198,109,246,115,142,127,254,127,254,115,206,109,182,115,182,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,246,109,198,109,246,115,142,127,254,127,254,115,238,109,206,115,238,109,238,115,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,246,109,198,109,246,115,142,127,254,127,254,115,134,109,246,115,134,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,246,109,198,109,246,115,142,127,254,127,254,115,142,109,246,115,198,109,246,115,142,127,254,0,0 },
  { 16,16,16,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 16,16,16,68,68,0,0,0,0,0,0,0,0,0,0,0 },
  { 64,64,64,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,0,0,0,0,0,0,0,8,28,8,0,0,0,0,0 },
  { 64,64,64,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 64,64,64,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 64,64,64,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,127,254,115,142,109,246,109,198,109,246,115,142,127,254,127,254,115,142,109,182,115,142,109,182,115,142,127,254,0,0 },
  { 64,64,64,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,127,254,115,142,109,246,109,198,109,246,115,142,127,254,127,254,115,142,109,182,115,182,109,182,115,142,127,254,0,0 },
  { 64,64,64,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 64,64,64,0,62,65,65,65,65,65,65,34,20,20,119,0 },
  { 16,16,16,68,68,0,16,16,16,16,16,16,16,12,0,0 },
  { 0,0,0,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,0,0,0,124,66,66,66,124,66,66,66,66,124,0,0 },
  { 0,0,0,0,126,64,64,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,0,8,8,20,20,34,34,34,65,65,127,0,0 },
  { 0,0,0,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,0,0,0,126,2,2,4,8,16,32,64,64,126,0,0 },
  { 0,0,0,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 0,0,0,0,60,66,66,66,126,66,66,66,66,60,0,0 },
  { 0,0,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,66,68,72,80,96,96,80,72,68,66,0,0 },
  { 0,0,0,0,8,8,20,20,34,34,34,65,65,65,0,0 },
  { 0,0,0,0,66,66,102,102,90,90,66,66,66,66,0,0 },
  { 0,0,0,0,66,98,98,82,82,74,74,70,70,66,0,0 },
  { 0,0,0,0,126,0,0,0,60,0,0,0,0,126,0,0 },
  { 0,0,0,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,127,34,34,34,34,34,34,34,34,34,0,0 },
  { 0,0,0,0,124,66,66,66,124,64,64,64,64,64,0,0 },
  { 0,0,127,254,115,142,109,246,109,198,109,246,115,142,127,254,127,254,97,134,109,246,97,134,109,190,109,134,127,254,0,0 },
  { 0,0,0,0,126,64,32,16,8,8,16,32,64,126,0,0 },
  { 0,0,0,0,127,8,8,8,8,8,8,8,8,8,0,0 },
  { 0,0,0,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,0,0,0,127,8,62,73,73,73,73,62,8,127,0,0 },
  { 0,0,0,0,66,66,36,36,24,24,36,36,66,66,0,0 },
  { 0,0,0,0,73,73,73,73,73,62,8,8,8,8,0,0 },
  { 0,0,0,0,62,65,65,65,65,65,34,20,20,119,0,0 },
  { 36,36,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 36,36,0,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,16,16,16,0,0,50,74,68,68,68,68,74,50,0,0 },
  { 0,16,16,16,0,0,62,64,64,60,64,64,64,62,0,0 },
  { 0,16,16,16,0,0,92,98,66,66,66,66,66,66,2,2 },
  { 0,16,16,16,0,0,16,16,16,16,16,16,16,12,0,0 },
  { 16,16,16,68,68,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,50,74,68,68,68,68,74,50,0,0 },
  { 0,0,0,0,56,68,68,68,124,66,66,66,98,92,64,64 },
  { 0,0,0,0,0,0,49,73,10,4,8,8,16,16,0,0 },
  { 0,0,0,0,28,32,32,32,24,36,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,60,66,64,60,64,64,66,60,0,0 },
  { 0,0,0,0,32,32,28,8,16,32,32,32,32,28,2,28 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,66,66,2,2 },
  { 0,0,0,0,24,36,36,66,126,66,66,36,36,24,0,0 },
  { 0,0,0,0,0,0,16,16,16,16,16,16,16,12,0,0 },
  { 0,0,0,0,0,0,34,36,40,48,48,40,36,34,0,0 },
  { 0,0,0,0,32,32,16,16,8,24,36,36,66,66,0,0 },
  { 0,0,0,0,0,0,66,66,66,66,102,102,90,66,64,64 },
  { 0,0,0,0,0,0,66,66,66,68,68,72,80,96,0,0 },
  { 0,0,0,0,64,64,60,64,64,60,64,64,60,2,2,60 },
  { 0,0,0,0,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,126,36,36,36,36,36,36,36,0,0 },
  { 0,0,0,0,0,0,60,66,66,66,66,66,98,92,64,64 },
  { 0,0,0,0,0,0,30,32,64,64,64,32,28,2,2,28 },
  { 0,0,0,0,0,0,63,72,68,68,68,68,68,56,0,0 },
  { 0,0,0,0,0,0,126,16,16,16,16,16,16,12,0,0 },
  { 0,0,0,0,0,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,38,73,73,73,73,73,73,62,8,8 },
  { 0,0,0,0,0,0,66,66,36,36,24,24,36,36,66,66 },
  { 0,0,0,0,0,0,73,73,73,73,73,73,73,62,8,8 },
  { 0,0,0,0,0,0,34,65,65,73,73,73,73,54,0,0 },
  { 0,0,36,36,0,0,16,16,16,16,16,16,16,12,0,0 },
  { 0,0,36,36,0,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,16,16,16,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,16,16,16,0,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,8,8,8,0,0,34,65,65,73,73,73,73,54,0,0 },
  { 0,0,0,0,66,68,72,80,96,96,80,72,68,66,4,8 },
  { 0,0,0,0,28,34,66,68,120,68,66,66,68,56,0,0 },
  { 0,0,0,0,12,18,18,18,15,34,98,34,34,28,0,0 },
  { 0,0,0,0,54,73,8,8,8,8,8,8,8,28,0,0 },
  { 0,64,64,0,54,73,8,8,8,8,8,8,8,28,0,0 },
  { 0,54,54,0,54,73,8,8,8,8,8,8,8,28,0,0 },
  { 0,0,0,0,8,8,62,73,73,73,73,73,73,62,8,8 },
  { 0,0,0,0,0,0,127,34,65,65,73,73,73,54,0,0 },
  { 0,0,0,0,0,0,66,36,40,56,40,40,37,67,2,12 },
  { 0,0,0,0,60,66,66,66,66,66,66,66,66,60,24,60 },
  { 0,0,0,0,0,0,60,66,66,66,66,66,66,60,24,24 },
  { 0,0,0,0,56,68,64,64,64,48,12,2,2,60,0,0 },
  { 0,0,0,0,0,0,0,62,64,64,32,28,2,28,0,0 },
  { 0,0,0,0,126,66,64,64,120,72,64,64,64,64,0,0 },
  { 0,0,0,0,0,0,0,60,34,32,32,56,32,32,32,32 },
  { 0,0,0,0,96,32,32,32,32,62,4,4,8,8,0,0 },
  { 0,0,0,0,0,0,0,0,16,32,124,8,16,0,0,0 },
  { 0,0,0,0,28,34,6,10,18,38,74,18,34,76,0,0 },
  { 0,0,0,0,0,0,0,96,16,8,24,44,20,4,4,4 },
  { 0,0,0,0,219,73,73,73,73,73,73,55,1,62,64,0 },
  { 0,0,0,0,0,0,73,73,73,73,73,55,1,62,64,0 },
  { 0,0,0,0,50,74,66,66,70,58,2,2,2,2,0,0 },
  { 0,0,0,0,0,0,26,34,34,34,30,2,2,2,0,0 },
  { 0,0,0,0,112,32,32,44,50,34,34,2,98,28,0,0 },
  { 0,0,0,0,0,8,60,82,82,34,2,2,50,76,0,0 },
  { 0,0,0,0,60,66,66,2,12,48,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,60,66,66,36,24,32,64,62,0,0 },
  { 0,0,0,0,195,165,36,24,24,36,36,66,66,126,0,0 },
  { 0,0,0,0,0,0,36,90,24,24,24,36,66,126,0,0 },
  { 0,0,0,2,60,64,92,98,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,2,60,64,92,98,66,66,66,60,0,0 },
  { 0,0,0,0,28,8,62,73,42,8,8,8,8,28,0,0 },
  { 0,0,0,0,0,12,8,9,62,72,8,8,8,24,0,0 },
  { 0,0,0,0,0,0,98,18,20,24,16,48,72,70,0,0 },
  { 0,0,0,0,0,0,60,66,66,66,124,64,64,60,2,0 },
  { 0,0,0,0,0,2,60,64,64,64,64,64,64,60,2,0 },
  { 0,0,2,2,0,0,14,2,2,2,2,2,2,34,28,0 },
  { 0,0,0,0,24,36,66,66,126,66,66,66,36,24,0,0 },
  { 0,0,0,0,0,0,28,32,64,120,64,64,32,28,0,0 },
  { 0,0,0,0,0,0,112,8,4,60,4,4,8,112,0,0 },
  { 0,0,0,0,0,64,92,98,66,66,66,66,98,92,64,64 },
  { 0,0,0,64,64,64,92,98,66,66,66,66,98,92,64,64 },
  { 0,0,0,0,60,66,66,64,64,64,64,66,66,60,0,0 },
  { 0,0,0,0,66,66,102,102,90,90,66,66,66,66,0,0 },
  { 0,0,0,0,0,68,108,108,84,84,68,68,69,66,64,64 },
  { 0,0,0,0,0,44,50,34,34,34,34,50,44,32,120,32 },
  { 0,0,0,0,60,66,66,2,2,2,2,66,66,60,0,0 },
  { 0,0,0,0,60,66,66,64,88,88,64,66,66,60,0,0 },
  { 0,0,0,0,60,66,66,2,26,26,2,66,66,60,0,0 },
  { 0,48,12,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 36,36,0,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,0,0,0,126,16,16,16,30,17,17,17,17,22,0,0 },
  { 12,48,0,0,126,64,64,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,0,28,34,64,64,124,64,64,64,34,28,0,0 },
  { 0,0,0,0,60,66,66,64,48,12,2,66,66,60,0,0 },
  { 0,0,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 36,36,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,14,4,4,4,4,4,4,68,68,56,0,0 },
  { 0,0,0,0,120,72,72,72,78,73,73,73,73,142,0,0 },
  { 0,0,0,0,72,72,72,72,126,73,73,73,73,78,0,0 },
  { 0,0,0,0,126,16,16,16,30,17,17,17,17,17,0,0 },
  { 12,48,0,0,64,70,72,80,96,96,80,72,68,66,0,0 },
  { 0,48,12,0,66,70,70,74,74,82,82,98,98,66,0,0 },
  { 66,66,60,0,65,65,34,34,20,20,8,8,16,48,0,0 },
  { 0,0,0,0,65,65,65,65,65,65,65,65,65,127,8,8 },
  { 0,0,0,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,0,0,0,124,64,64,64,124,66,66,66,66,124,0,0 },
  { 0,0,0,0,124,66,66,66,124,66,66,66,66,124,0,0 },
  { 0,0,0,0,126,64,64,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,0,14,18,18,18,34,34,34,66,66,255,129,129 },
  { 0,0,0,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,0,0,0,73,73,42,42,28,28,42,42,73,73,0,0 },
  { 0,0,0,0,60,66,2,2,60,4,2,2,66,60,0,0 },
  { 0,0,0,0,66,70,70,74,74,82,82,98,98,66,0,0 },
  { 0,36,24,0,66,70,70,74,74,82,82,98,98,66,0,0 },
  { 0,0,0,0,70,72,72,80,80,96,80,72,68,66,0,0 },
  { 0,0,0,0,30,18,18,18,18,18,18,34,34,66,0,0 },
  { 0,0,0,0,66,66,102,102,90,90,66,66,66,66,0,0 },
  { 0,0,0,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 0,0,0,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,126,66,66,66,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,124,66,66,66,124,64,64,64,64,64,0,0 },
  { 0,0,0,0,60,66,66,64,64,64,64,66,66,60,0,0 },
  { 0,0,0,0,127,8,8,8,8,8,8,8,8,8,0,0 },
  { 0,0,0,0,65,65,34,34,20,20,8,8,16,48,0,0 },
  { 0,0,0,8,62,73,73,73,73,73,62,8,8,8,0,0 },
  { 0,0,0,0,66,66,36,36,24,24,36,36,66,66,0,0 },
  { 0,0,0,0,66,66,66,66,66,66,66,66,66,127,1,1 },
  { 0,0,0,0,66,66,66,66,66,126,2,2,2,2,0,0 },
  { 0,0,0,0,73,73,73,73,73,73,73,73,73,127,0,0 },
  { 0,0,0,0,146,146,146,146,146,146,146,146,146,255,1,1 },
  { 0,0,0,0,112,16,16,16,30,17,17,17,17,30,0,0 },
  { 0,0,0,0,66,66,66,66,114,74,74,74,74,114,0,0 },
  { 0,0,0,0,64,64,64,64,124,66,66,66,66,124,0,0 },
  { 0,0,0,0,56,68,2,2,62,2,2,2,68,56,0,0 },
  { 0,0,0,0,76,82,82,82,114,82,82,82,82,76,0,0 },
  { 0,0,0,0,62,66,66,66,62,18,34,34,66,66,0,0 },
  { 0,0,0,0,0,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,0,2,28,32,64,124,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,124,66,66,124,66,66,66,124,0,0 },
  { 0,0,0,0,0,0,126,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,0,0,0,30,18,34,34,66,66,66,127,65,0 },
  { 0,0,0,0,0,0,60,66,66,126,64,64,66,60,0,0 },
  { 0,0,0,0,0,0,73,73,42,28,28,42,73,73,0,0 },
  { 0,0,0,0,0,0,60,66,2,60,4,2,66,60,0,0 },
  { 0,0,0,0,0,0,70,70,74,74,82,82,98,98,0,0 },
  { 0,0,36,24,0,0,70,70,74,74,82,82,98,98,0,0 },
  { 0,0,0,0,0,0,70,72,80,96,80,72,68,66,0,0 },
  { 0,0,0,0,0,0,30,18,18,18,18,34,34,66,0,0 },
  { 0,0,0,0,0,0,66,102,102,90,90,66,66,66,0,0 },
  { 0,0,0,0,0,0,66,66,66,126,66,66,66,66,0,0 },
  { 0,0,0,0,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,126,66,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,98,92,64,64 },
  { 0,0,0,0,0,0,60,66,64,64,64,64,66,60,0,0 },
  { 0,0,0,0,0,0,127,8,8,8,8,8,8,8,0,0 },
  { 0,0,0,0,0,0,66,66,36,36,24,24,16,16,32,96 },
  { 0,0,0,8,8,8,62,73,73,73,73,73,73,62,8,8 },
  { 0,0,0,0,0,0,66,66,36,24,24,36,66,66,0,0 },
  { 0,0,0,0,0,0,66,66,66,66,66,66,66,127,1,1 },
  { 0,0,0,0,0,0,66,66,66,66,126,2,2,2,0,0 },
  { 0,0,0,0,0,0,73,73,73,73,73,73,73,127,0,0 },
  { 0,0,0,0,0,0,146,146,146,146,146,146,146,255,1,1 },
  { 0,0,0,0,0,0,112,16,16,30,17,17,17,30,0,0 },
  { 0,0,0,0,0,0,66,66,66,114,74,74,74,114,0,0 },
  { 0,0,0,0,0,0,64,64,64,124,66,66,66,124,0,0 },
  { 0,0,0,0,0,0,56,68,2,62,2,2,68,56,0,0 },
  { 0,0,0,0,0,0,76,82,82,114,82,82,82,76,0,0 },
  { 0,0,0,0,0,0,62,66,66,66,62,18,34,66,0,0 },
  { 0,0,48,12,0,0,60,66,66,126,64,64,66,60,0,0 },
  { 0,0,36,36,0,0,60,66,66,126,64,64,66,60,0,0 },
  { 0,0,0,64,240,64,92,98,66,66,66,66,66,66,2,12 },
  { 0,0,12,48,0,0,126,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,0,0,0,28,34,64,124,64,64,34,28,0,0 },
  { 0,0,0,0,0,0,60,66,64,48,12,2,66,60,0,0 },
  { 0,0,0,8,8,0,24,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,36,36,0,24,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,4,4,0,12,4,4,4,4,4,4,4,72,48 },
  { 0,0,0,0,0,0,120,72,72,78,73,73,73,142,0,0 },
  { 0,0,0,0,0,0,72,72,72,126,73,73,73,78,0,0 },
  { 0,0,0,64,240,64,92,98,66,66,66,66,66,66,0,0 },
  { 0,0,12,48,0,0,70,72,80,96,80,72,68,66,0,0 },
  { 0,0,48,12,0,0,70,70,74,74,82,82,98,98,0,0 },
  { 0,66,66,60,0,0,66,66,36,36,24,24,16,16,32,96 },
  { 0,0,0,0,0,0,34,34,34,34,34,34,34,62,8,8 },
  { 0,0,0,0,73,73,73,73,73,73,73,73,90,36,0,0 },
  { 0,0,0,0,0,0,34,65,65,73,73,73,73,54,0,0 },
  { 0,0,0,0,16,124,16,16,30,17,17,17,17,30,0,0 },
  { 0,0,0,0,32,32,120,32,32,60,34,34,34,60,0,0 },
  { 0,0,0,0,70,73,80,80,126,80,80,80,73,70,0,0 },
  { 0,0,0,0,0,0,70,73,80,126,80,80,73,70,0,0 },
  { 0,0,0,0,8,8,20,20,34,54,42,73,73,73,0,0 },
  { 0,0,0,0,0,0,8,20,20,34,54,73,73,73,0,0 },
  { 0,0,0,0,72,72,84,84,82,118,106,73,73,73,0,0 },
  { 0,0,0,0,0,0,72,84,84,82,118,73,73,73,0,0 },
  { 0,0,0,0,62,34,34,20,8,28,42,73,73,73,0,0 },
  { 0,0,0,0,0,0,62,34,20,8,62,73,73,73,0,0 },
  { 0,0,0,0,95,81,81,74,116,78,85,85,85,85,0,0 },
  { 0,0,0,0,0,0,95,81,74,116,78,85,85,85,0,0 },
  { 0,0,36,24,60,66,2,2,60,4,2,2,2,60,64,64 },
  { 0,0,0,36,24,0,60,66,2,60,4,2,2,60,64,64 },
  { 0,0,0,0,73,73,73,73,73,62,8,8,8,8,0,0 },
  { 0,0,0,0,0,0,0,0,73,73,73,73,73,62,8,8 },
  { 0,0,0,0,60,66,66,66,126,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,60,66,66,126,66,66,66,60,0,0 },
  { 0,0,0,0,67,68,68,68,40,40,40,16,16,16,0,0 },
  { 0,0,0,0,0,0,70,72,72,40,40,40,16,16,0,0 },
  { 102,17,0,0,67,68,68,68,40,40,40,16,16,16,0,0 },
  { 0,0,102,17,0,0,70,72,72,40,40,40,16,16,0,0 },
  { 0,0,0,0,32,80,89,89,89,85,86,84,84,36,8,8 },
  { 0,0,0,0,0,0,41,89,89,85,86,84,84,36,8,8 },
  { 0,0,0,8,62,73,65,65,65,65,65,65,73,62,8,0 },
  { 0,0,0,0,0,8,62,73,65,65,65,65,73,62,8,0 },
  { 60,67,24,4,8,0,54,65,65,73,73,73,73,54,0,0 },
  { 0,0,0,60,67,24,4,8,0,54,65,73,73,54,0,0 },
  { 0,127,8,0,73,73,73,73,73,73,73,73,90,36,0,0 },
  { 0,0,0,0,127,8,0,73,73,73,73,73,90,36,0,0 },
  { 0,0,0,0,60,66,66,64,64,64,64,64,60,4,4,4 },
  { 0,0,0,0,0,0,60,66,66,64,64,64,60,4,4,4 },
  { 0,0,0,0,0,0,18,12,68,42,17,24,36,0,0,0 },
  { 0,8,120,64,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,16,40,72,128,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,56,64,48,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,56,4,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,48,76,131,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,2,128,16,16,40,40,0,0,0,0,64,8,160,20,0,0,0,0,0,0,16,16,41,40,2,128 },
  { 0,0,0,0,0,128,16,132,9,136,12,48,0,0,0,0,0,8,112,14,16,0,0,0,0,0,12,216,8,136,16,132 },
  { 0,36,24,0,66,70,70,74,74,82,82,98,98,67,2,4 },
  { 0,0,36,24,0,0,70,70,74,74,82,82,98,99,2,4 },
  { 0,0,0,0,32,112,32,32,32,60,34,34,38,60,0,0 },
  { 0,0,0,0,0,0,0,32,112,32,60,34,34,60,0,0 },
  { 0,0,0,0,124,66,74,68,122,64,64,64,64,64,0,0 },
  { 0,0,0,0,0,0,92,98,66,66,66,74,100,90,64,64 },
  { 0,0,2,2,126,64,64,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,0,2,2,126,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,0,31,16,16,16,16,124,16,16,16,16,0,0 },
  { 0,0,0,0,0,0,31,16,16,16,124,16,16,16,0,0 },
  { 0,0,0,0,126,64,64,64,64,124,66,66,66,66,12,0 },
  { 0,0,0,0,0,0,126,64,64,64,124,66,66,66,12,0 },
  { 0,0,0,0,73,73,42,42,28,28,42,42,73,73,1,1 },
  { 0,0,0,0,0,0,73,73,42,28,28,42,73,73,1,1 },
  { 0,0,0,0,60,66,2,2,60,4,2,2,66,60,8,48 },
  { 0,0,0,0,0,0,60,66,2,60,4,2,66,60,8,48 },
  { 0,0,0,0,64,70,72,80,96,96,80,72,68,66,2,2 },
  { 0,0,0,0,0,0,70,72,80,96,80,72,68,66,2,2 },
  { 0,0,0,0,64,67,84,84,120,84,84,84,66,65,0,0 },
  { 0,0,0,0,0,0,67,84,84,120,84,84,66,65,0,0 },
  { 0,0,0,0,32,115,36,40,48,48,40,36,34,33,0,0 },
  { 0,0,0,0,0,0,35,116,40,48,40,36,34,33,0,0 },
  { 0,0,0,0,224,35,36,40,48,48,40,36,34,33,0,0 },
  { 0,0,0,0,0,0,227,36,40,48,40,36,34,33,0,0 },
  { 0,0,0,0,66,66,66,66,126,66,66,66,66,67,1,1 },
  { 0,0,0,0,0,0,66,66,66,126,66,66,66,67,1,1 },
  { 0,0,0,0,71,68,68,68,124,68,68,68,68,68,0,0 },
  { 0,0,0,0,0,0,71,68,68,124,68,68,68,68,0,0 },
  { 0,0,0,0,120,72,72,72,72,78,73,73,73,73,1,6 },
  { 0,0,0,0,0,0,120,72,72,72,78,73,73,73,1,6 },
  { 0,0,0,32,76,82,82,82,82,82,82,82,44,24,6,0 },
  { 0,0,0,0,0,0,32,76,82,82,82,82,44,24,6,0 },
  { 0,0,0,0,60,66,66,64,64,64,64,66,66,60,16,12 },
  { 0,0,0,0,0,0,60,66,66,64,64,66,66,60,16,12 },
  { 0,0,0,0,127,8,8,8,8,8,8,8,8,12,4,4 },
  { 0,0,0,0,0,0,127,8,8,8,8,8,8,12,4,4 },
  { 0,0,0,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,0,0,0,0,0,34,34,34,20,20,8,8,8,8,8 },
  { 0,0,0,0,65,65,34,34,20,8,8,62,8,8,0,0 },
  { 0,0,0,0,0,0,34,34,34,20,8,8,62,8,0,0 },
  { 0,0,0,0,66,66,36,36,24,24,36,36,66,67,1,1 },
  { 0,0,0,0,0,0,66,66,36,24,24,36,66,67,1,1 },
  { 0,0,0,0,250,34,34,34,34,34,34,34,34,63,1,1 },
  { 0,0,0,0,0,0,250,34,34,34,34,34,34,63,1,1 },
  { 0,0,0,0,66,66,66,66,66,70,58,2,2,3,1,1 },
  { 0,0,0,0,0,0,66,66,66,66,70,58,2,3,1,1 },
  { 0,0,0,0,66,66,66,66,82,86,58,18,18,2,0,0 },
  { 0,0,0,0,0,0,66,66,66,82,86,58,18,2,0,0 },
  { 0,0,0,0,64,64,64,92,98,66,66,66,66,66,0,0 },
  { 0,0,0,0,0,0,64,64,92,98,66,66,66,66,0,0 },
  { 0,0,0,0,76,82,82,82,62,16,16,18,18,12,0,0 },
  { 0,0,0,0,0,0,76,82,82,62,16,16,18,12,0,0 },
  { 0,0,0,0,76,82,82,82,62,16,16,18,18,12,8,8 },
  { 0,0,0,0,76,82,82,82,62,16,16,18,18,12,8,8 },
  { 0,0,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 65,65,62,0,73,73,42,42,28,28,42,42,73,73,0,0 },
  { 0,34,34,28,0,0,73,73,42,28,28,42,73,73,0,0 },
  { 0,0,0,0,64,70,72,80,96,124,66,66,66,66,2,12 },
  { 0,0,0,0,0,0,70,72,80,96,124,66,66,66,2,12 },
  { 0,0,0,0,30,18,18,18,18,18,18,34,34,67,2,4 },
  { 0,0,0,0,0,0,30,18,18,18,18,34,34,67,2,4 },
  { 0,0,0,0,66,66,66,66,126,66,66,66,66,66,2,12 },
  { 0,0,0,0,0,0,66,66,66,126,66,66,66,66,2,12 },
  { 0,0,0,0,66,66,66,66,126,66,66,66,66,67,2,4 },
  { 0,0,0,0,0,0,66,66,66,126,66,66,66,67,2,4 },
  { 0,0,0,0,66,66,66,66,66,70,58,2,2,6,4,4 },
  { 0,0,0,0,0,0,66,66,66,66,70,58,2,6,4,4 },
  { 0,0,0,0,66,66,102,102,90,90,66,66,66,67,2,4 },
  { 0,0,0,0,0,0,66,102,102,90,90,66,66,67,2,4 },
  { 0,0,0,0,28,8,8,8,8,8,8,8,8,28,0,0 },
  { 66,66,60,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,66,66,60,0,0,60,66,2,62,66,66,70,58,0,0 },
  { 36,36,0,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,0,36,36,0,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,0,0,0,31,40,72,72,127,72,72,72,72,79,0,0 },
  { 0,0,0,0,0,0,62,73,9,63,72,72,73,62,0,0 },
  { 66,66,60,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,0,66,66,60,0,60,66,66,126,64,64,66,60,0,0 },
  { 0,0,0,0,24,36,66,2,2,126,66,66,36,24,0,0 },
  { 0,0,0,0,0,0,60,66,2,2,126,66,66,60,0,0 },
  { 36,36,0,0,24,36,66,2,2,126,66,66,36,24,0,0 },
  { 0,0,36,36,0,0,60,66,2,2,126,66,66,60,0,0 },
  { 36,36,0,0,73,73,42,42,28,28,42,42,73,73,0,0 },
  { 0,0,36,36,0,0,73,73,42,28,28,42,73,73,0,0 },
  { 36,36,0,0,60,66,2,2,60,4,2,2,66,60,0,0 },
  { 0,0,36,36,0,0,60,66,2,60,4,2,66,60,0,0 },
  { 0,0,0,0,126,4,8,16,28,2,2,2,70,60,0,0 },
  { 0,0,0,0,0,0,62,4,8,16,28,2,2,2,66,60 },
  { 0,60,0,0,66,70,70,74,74,82,82,98,98,66,0,0 },
  { 0,0,0,60,0,0,70,70,74,74,82,82,98,98,0,0 },
  { 36,36,0,0,66,70,70,74,74,82,82,98,98,66,0,0 },
  { 0,0,36,36,0,0,70,70,74,74,82,82,98,98,0,0 },
  { 36,36,0,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,36,36,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,60,66,66,66,126,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,60,66,66,126,66,66,66,60,0,0 },
  { 36,36,0,0,60,66,66,66,126,66,66,66,66,60,0,0 },
  { 0,0,36,36,0,0,60,66,66,126,66,66,66,60,0,0 },
  { 0,0,36,0,60,66,2,2,62,2,2,2,66,60,0,0 },
  { 0,0,0,0,36,0,60,66,2,30,2,2,66,60,0,0 },
  { 0,62,0,0,65,65,34,34,20,20,8,8,16,48,0,0 },
  { 0,0,0,60,0,0,66,66,36,36,24,24,16,16,32,96 },
  { 36,36,0,0,65,65,34,34,20,20,8,8,16,48,0,0 },
  { 0,0,36,36,0,0,66,66,36,36,24,24,16,16,32,96 },
  { 51,68,0,0,65,65,34,34,20,20,8,8,16,48,0,0 },
  { 0,0,51,68,0,0,66,66,36,36,24,24,16,16,32,96 },
  { 36,36,0,0,66,66,66,66,66,70,58,2,2,2,0,0 },
  { 0,0,36,36,0,0,66,66,66,66,70,58,2,2,0,0 },
  { 0,0,0,0,126,64,64,64,64,64,64,64,64,112,48,16 },
  { 0,0,0,0,0,0,126,64,64,64,64,64,64,112,48,16 },
  { 36,36,0,0,66,66,66,66,114,74,74,74,74,114,0,0 },
  { 0,0,36,36,0,0,66,66,66,114,74,74,74,114,0,0 },
  { 0,0,0,0,126,64,64,64,124,64,64,64,64,96,32,96 },
  { 0,0,0,0,0,0,124,64,64,120,64,64,64,96,32,96 },
  { 0,0,0,0,66,66,36,36,24,24,36,36,66,66,2,4 },
  { 0,0,0,0,0,0,66,66,36,24,24,36,66,66,2,4 },
  { 0,0,0,0,66,66,36,36,24,126,36,36,66,66,0,0 },
  { 0,0,0,0,0,0,66,66,36,24,126,36,66,66,0,0 },
  { 0,0,0,2,2,2,62,66,66,66,66,66,70,58,0,0 },
  { 0,0,0,2,2,2,2,58,70,66,66,66,70,58,0,0 },
  { 0,0,0,4,4,4,60,68,68,69,69,69,77,54,0,0 },
  { 0,0,0,4,4,4,4,52,76,68,68,69,77,54,0,0 },
  { 0,0,0,0,56,68,68,4,24,5,5,5,5,2,0,0 },
  { 0,0,0,0,0,0,56,68,68,4,24,5,5,2,0,0 },
  { 0,0,0,0,56,68,68,4,24,4,4,4,4,3,1,1 },
  { 0,0,0,0,0,0,56,68,68,4,24,4,4,3,1,1 },
  { 0,0,0,0,60,36,36,36,36,37,37,69,69,130,0,0 },
  { 0,0,0,0,0,0,60,36,36,36,36,69,69,130,0,0 },
  { 0,0,0,0,68,68,68,68,124,69,69,69,69,70,0,0 },
  { 0,0,0,0,0,0,68,68,68,124,68,69,69,70,0,0 },
  { 0,0,0,0,60,66,66,64,64,78,66,66,68,56,0,0 },
  { 0,0,0,0,0,0,60,66,64,64,78,66,66,60,0,0 },
  { 0,0,0,0,127,8,8,8,8,9,9,9,9,14,0,0 },
  { 0,0,0,0,0,0,127,8,8,8,9,9,9,14,0,0 },
  { 0,0,0,0,60,66,64,64,60,32,64,64,66,60,0,0 },
  { 0,0,0,0,0,0,60,66,64,60,32,64,66,60,0,0 },
  { 0,0,0,0,30,18,18,18,18,18,18,34,34,66,10,12 },
  { 0,0,0,0,0,0,30,18,18,18,18,34,34,66,10,12 },
  { 0,0,0,0,241,81,74,74,68,68,74,74,81,145,0,0 },
  { 0,0,0,0,0,0,241,81,74,68,68,74,81,145,0,0 },
  { 0,0,0,0,225,146,148,152,144,240,136,132,130,129,0,0 },
  { 0,0,0,0,0,0,1,226,148,152,152,148,226,129,128,128 },
  { 0,0,0,0,127,136,136,136,127,40,72,72,136,143,0,0 },
  { 0,0,0,0,0,0,126,137,137,127,40,40,73,70,0,0 },
  { 0,0,0,0,60,66,66,66,66,66,66,90,102,60,3,0 },
  { 0,0,0,0,0,0,58,70,66,66,66,66,70,58,2,2 },
  { 0,0,0,0,66,66,66,66,90,90,102,102,66,66,0,0 },
  { 0,0,0,0,0,0,65,73,73,73,73,73,73,54,0,0 },
  { 0,0,0,0,74,68,74,80,96,96,80,72,68,66,0,0 },
  { 0,0,0,0,0,0,84,72,84,96,80,72,68,66,0,0 },
  { 0,0,0,0,112,80,80,80,94,81,81,145,145,145,5,2 },
  { 0,0,0,0,0,0,112,80,80,94,81,81,145,145,5,2 },
  { 0,0,0,0,144,144,144,144,254,145,145,145,145,145,5,2 },
  { 0,0,0,0,0,0,144,144,144,254,145,145,145,145,5,2 },
  { 0,0,0,0,124,68,68,68,68,68,68,68,68,71,1,1 },
  { 0,0,0,0,0,0,124,68,68,68,68,68,68,71,1,1 },
  { 0,0,0,0,128,128,128,128,240,136,132,132,132,135,1,1 },
  { 0,0,0,0,128,128,128,128,240,136,136,136,136,142,2,2 },
  { 0,0,0,0,17,17,17,17,31,17,17,17,17,17,80,32 },
  { 0,0,0,0,0,0,17,17,17,31,17,17,17,17,80,32 },
  { 0,0,0,0,0,0,0,0,12,64,20,70,20,72,20,80,39,224,36,96,36,80,68,72,68,68,254,66,130,0,130,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,28,70,20,72,36,80,39,224,68,80,68,72,68,68,126,66,66,0,0,0 },
  { 0,0,0,0,76,76,84,84,84,124,36,36,68,126,66,66 },
  { 0,0,0,0,0,0,76,84,84,84,124,36,36,36,126,66 },
  { 0,0,0,0,124,68,68,68,68,68,68,68,68,135,1,1 },
  { 0,0,0,0,0,0,124,68,68,68,68,68,68,135,1,1 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,99,206,125,182,113,182,125,182,99,206,127,254,0,0 },
  { 0,0,0,0,68,68,68,68,68,68,68,71,69,56,0,0 },
  { 0,0,0,0,60,66,66,64,124,66,64,64,64,64,0,0 },
  { 0,0,0,0,56,68,68,68,68,62,5,4,4,4,0,0 },
  { 0,0,0,0,56,68,68,4,4,6,5,4,4,4,0,0 },
  { 0,0,0,0,64,64,124,66,64,64,64,66,66,60,0,0 },
  { 0,0,0,0,28,34,34,34,34,28,4,8,16,126,2,0 },
  { 0,0,0,0,64,64,64,124,66,64,64,64,64,124,2,0 },
  { 0,0,0,0,60,66,66,64,64,64,64,64,64,124,2,0 },
  { 0,0,0,0,56,68,68,79,84,84,72,64,64,64,0,0 },
  { 0,0,0,0,4,4,4,4,63,68,68,68,68,56,0,0 },
  { 0,0,0,0,64,64,92,98,66,64,64,64,64,64,0,0 },
  { 0,0,0,0,64,64,64,64,64,64,64,64,64,126,2,0 },
  { 0,0,0,0,64,64,64,121,73,73,73,73,73,70,0,0 },
  { 0,0,0,0,126,24,36,66,66,66,66,66,36,24,0,0 },
  { 0,0,0,0,64,64,66,66,66,66,66,62,2,2,0,0 },
  { 0,0,0,0,8,16,16,8,16,32,64,96,24,6,0,0 },
  { 0,0,0,0,28,34,34,34,34,28,36,88,72,54,0,0 },
  { 0,0,0,0,56,68,68,4,4,4,4,4,4,7,1,0 },
  { 0,0,0,0,4,100,24,36,36,66,66,66,66,126,0,0 },
  { 0,0,0,0,71,69,68,68,68,68,68,68,68,56,0,0 },
  { 0,0,0,0,28,34,2,66,124,66,2,2,34,28,0,0 },
  { 0,0,0,0,64,48,16,16,16,16,16,16,17,17,14,0 },
  { 0,0,0,64,60,32,64,64,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,60,66,66,66,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,28,34,34,34,34,28,4,8,112,24,6,0 },
  { 0,0,0,0,62,73,73,73,73,9,9,1,1,1,0,0 },
  { 0,0,0,0,28,34,34,18,10,12,12,8,16,126,2,0 },
  { 0,0,0,0,56,68,68,71,69,68,68,68,68,68,0,0 },
  { 0,0,0,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,4,4,68,68,68,68,68,60,4,7,1,0 },
  { 0,0,0,0,60,66,66,64,48,12,2,66,66,60,0,0 },
  { 0,0,0,0,60,66,66,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,0,60,66,66,66,60,66,2,2,66,60,0,0 },
  { 0,0,0,0,64,64,88,100,68,68,67,64,64,64,0,0 },
  { 0,0,0,0,16,56,84,84,84,84,84,84,56,16,0,0 },
  { 0,0,0,0,12,18,18,18,28,80,124,20,16,16,0,0 },
  { 0,0,0,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,56,72,72,56,14,9,9,9,73,62,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,134,111,246,97,238,125,222,97,222,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,206,111,182,97,206,125,182,97,206,127,254,0,0 },
  { 16,32,32,16,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 32,16,16,32,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 8,24,48,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 12,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 32,16,8,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 56,68,84,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 48,80,64,60,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,115,206,111,182,99,182,109,182,115,206,127,254,0,0 },
  { 0,0,0,0,0,0,73,73,73,73,73,73,73,55,0,0 },
  { 0,0,0,0,0,0,0,28,34,66,66,64,126,64,64,64 },
  { 0,0,0,0,0,0,56,68,68,68,68,68,63,4,4,4 },
  { 0,0,0,0,0,0,88,100,68,68,68,68,68,71,4,4 },
  { 0,0,0,0,0,64,64,64,126,64,66,66,34,28,0,0 },
  { 0,0,0,0,0,0,52,76,68,68,68,68,60,4,4,7 },
  { 0,0,0,0,64,64,124,64,64,64,64,64,64,56,4,0 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,66,66,64,126 },
  { 0,0,0,0,0,0,88,100,68,79,84,84,72,64,64,64 },
  { 0,0,0,0,4,4,4,63,68,68,68,68,68,56,0,0 },
  { 0,0,0,0,64,64,92,98,66,66,66,66,66,66,64,64 },
  { 0,0,0,0,0,0,64,64,64,64,64,64,64,64,64,124 },
  { 0,0,0,0,64,64,64,121,73,73,73,73,70,64,64,64 },
  { 0,0,0,0,112,8,4,63,68,68,68,68,68,56,0,0 },
  { 0,0,0,0,32,32,34,34,34,34,34,34,34,30,2,2 },
  { 0,0,0,0,64,64,64,92,98,66,66,66,66,66,0,0 },
  { 0,0,0,0,8,16,8,62,66,66,66,66,66,62,0,0 },
  { 0,0,0,0,0,0,88,100,68,68,68,68,68,68,4,7 },
  { 0,0,0,0,14,17,16,127,17,17,17,17,19,13,0,0 },
  { 0,0,0,0,2,5,4,68,68,68,68,68,76,52,0,0 },
  { 0,0,0,0,0,0,12,4,4,4,4,4,4,4,72,48 },
  { 0,0,0,0,60,66,64,66,66,66,66,66,70,58,0,0 },
  { 0,0,0,0,56,68,4,8,8,16,16,32,32,63,0,0 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,16,32,16,8,8,16,16,32,32,63,0,0 },
  { 0,0,0,0,0,0,73,73,73,73,73,73,73,55,1,1 },
  { 0,0,0,0,56,68,68,36,20,24,24,32,32,63,0,0 },
  { 0,0,0,0,0,0,88,100,68,68,68,68,68,71,0,0 },
  { 0,0,0,0,0,0,66,66,66,66,66,66,70,58,0,0 },
  { 0,0,0,0,4,4,4,68,68,68,68,68,76,52,4,7 },
  { 0,0,0,0,0,0,74,77,73,73,73,73,89,41,0,0 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,66,66,64,64 },
  { 0,0,0,0,0,0,58,70,66,66,66,70,58,2,66,60 },
  { 0,0,0,0,0,0,24,8,8,8,8,8,8,14,0,0 },
  { 0,0,0,0,8,8,74,77,73,73,73,73,89,41,8,8 },
  { 0,0,0,0,0,0,12,18,18,18,28,16,60,16,16,24 },
  { 0,0,0,0,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,56,72,72,56,14,9,9,9,73,62,8,8 },
  { 0,0,0,0,64,64,64,68,68,68,68,68,68,59,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,115,206,109,182,115,206,109,182,115,206,127,254,0,0 },
  { 0,0,0,0,0,0,24,24,0,0,0,24,24,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,98,60,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,115,142,109,182,115,142,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,115,198,109,190,115,190,109,190,115,198,127,254,0,0 },
  { 0,0,0,0,0,0,13,192,18,48,18,72,41,136,39,176,39,200,27,200,35,40,36,144,24,144,7,96,0,0,0,0 },
  { 0,0,0,0,0,0,7,96,24,144,36,144,35,40,27,200,39,200,39,176,41,136,18,72,18,48,13,192,0,0,0,0 },
  { 0,0,0,0,56,68,68,4,31,4,31,4,4,4,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,115,206,109,182,113,182,125,182,115,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,8,28,34,0 },
  { 0,0,24,0,102,0,0,0,0,0,0,0,0,0,0,0 },
  { 12,48,12,48,12,48,0,0,0,0,0,0,0,0,0,0 },
  { 0,24,0,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,44,32,44,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,16,16,12,0 },
  { 8,28,62,28,8,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,36,82,74,36,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,192,32,32,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,2,4,2,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,104,104,8,112 },
  { 0,12,16,16,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,3,4,4,0,0,0,0,0,0,0,0,0,0,0 },
  { 6,8,19,20,4,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,66,165,66,36,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,2,5,2,4,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,80,96,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,68,56,16 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,8,56,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,16,8,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,8,48,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,20,100,8,48 },
  { 0,0,0,0,0,0,0,0,0,0,0,24,32,24,4,24 },
  { 0,0,48,8,8,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,32,80,32,16,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,34,28,8,8 },
  { 0,16,32,16,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,4,4,28,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,4,4,3,0 },
  { 0,72,168,168,144,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,24,36,36,24,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,0,24,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,42,0,18,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,58,0,2,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,58,16,18,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,24,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,102,102,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,102,0,24 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,60,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,62,8,8 },
  { 0,0,48,48,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,96,96,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,32,8,2,0 },
  { 0,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,8,8,0 },
  { 0,0,62,124,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,60,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,8,8,8,8,8,8,8,8,8,0,0 },
  { 0,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,96,96,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,8,28,8,0,0,8,28,8,0,0 },
  { 0,0,24,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,24,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,56,32,32,32,32,32,32,32,60,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,62,8,8,8 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,113,206,111,182,111,206,111,182,113,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,113,206,111,182,111,198,111,246,113,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,113,134,111,182,111,134,111,182,113,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,113,142,111,182,111,142,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,113,198,111,190,111,190,111,190,113,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,113,142,111,182,111,182,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,113,134,111,190,111,142,111,190,113,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,113,134,111,190,111,142,111,190,113,190,127,254,0,0 },
  { 0,0,0,0,0,66,66,34,18,44,72,68,66,66,0,0 },
  { 0,0,0,0,0,124,4,4,4,4,4,4,4,127,0,0 },
  { 0,0,0,0,0,48,8,8,8,4,12,20,34,66,0,0 },
  { 0,0,0,0,0,126,4,4,4,4,4,4,4,4,0,0 },
  { 0,0,0,0,0,126,2,2,34,34,34,34,34,34,0,0 },
  { 0,0,0,0,0,56,8,8,8,8,8,8,8,8,0,0 },
  { 0,0,0,0,0,48,12,10,8,8,8,8,8,8,0,0 },
  { 0,0,0,0,0,126,34,34,34,34,34,34,34,34,0,0 },
  { 0,0,0,0,0,70,74,66,66,66,66,66,66,126,0,0 },
  { 0,0,0,0,0,56,8,8,8,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,126,2,2,2,2,2,2,2,2,2,2 },
  { 0,0,0,0,0,126,2,2,2,2,2,2,2,124,0,0 },
  { 0,0,0,32,32,62,2,2,2,2,4,4,8,48,0,0 },
  { 0,0,0,0,0,254,34,34,34,34,34,34,34,62,0,0 },
  { 0,0,0,0,0,78,49,33,65,65,65,65,65,71,0,0 },
  { 0,0,0,0,0,56,8,8,8,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,28,4,4,4,4,4,4,4,60,0,0 },
  { 0,0,0,0,0,126,66,66,66,66,66,66,68,120,0,0 },
  { 0,0,0,0,0,18,18,18,18,18,18,18,18,254,0,0 },
  { 0,0,0,0,0,126,66,66,66,114,2,2,2,2,2,2 },
  { 0,0,0,0,0,126,66,66,66,114,2,2,2,126,0,0 },
  { 0,0,0,0,0,34,34,36,40,48,32,32,32,32,32,32 },
  { 0,0,0,0,0,66,66,36,24,8,4,2,2,126,0,0 },
  { 0,0,0,0,0,126,34,34,36,36,40,32,32,32,32,32 },
  { 0,0,0,0,0,126,2,2,2,2,2,2,2,2,0,0 },
  { 0,0,0,0,0,73,73,73,73,73,73,73,73,127,0,0 },
  { 0,0,0,0,0,62,34,34,34,34,34,34,34,98,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,142,111,182,99,142,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,198,111,190,99,190,111,190,97,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,142,111,182,99,182,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,134,111,190,99,142,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,134,111,190,99,142,111,190,97,190,127,254,0,0 },
  { 0,0,0,0,0,119,17,17,17,17,17,17,17,17,0,0 },
  { 0,0,0,0,0,119,17,17,17,1,1,1,1,1,0,0 },
  { 0,0,0,0,0,119,17,17,17,0,0,0,0,0,0,0 },
  { 0,0,2,4,8,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,18,36,72,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,134,111,190,99,134,111,246,111,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,134,109,246,115,134,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 85,85,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,4,0,9,128,8,63,253,128,0,0,1,170,170 },
  { 85,85,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,4,42,13,170,12,53,245,128,0,0,1,170,170 },
  { 85,85,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,142,0,14,25,135,224,0,1,128,0,0,1,170,170 },
  { 85,85,128,0,0,1,128,0,0,1,128,0,0,25,128,36,0,69,129,68,1,73,158,240,0,1,128,0,0,1,170,170 },
  { 85,85,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,0,1,149,130,124,2,1,191,0,0,1,170,170 },
  { 85,85,128,0,0,1,136,4,22,25,161,224,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,170,170 },
  { 0,0,0,168,112,168,16,208,8,128,8,128,4,128,4,0,2,112,2,64,1,64,1,128,1,128,1,0,1,0,0,0 },
  { 0,32,0,64,112,128,16,160,8,64,8,144,4,96,4,0,2,112,2,64,1,64,1,128,1,128,1,0,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,100,14,152,50,176,4,80,4,16,8,32,7,192,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,4,4,40,8,16,16,32,32,68,80,0,0,0 },
  { 0,0,0,4,4,40,8,16,16,32,33,68,80,0,0,0 },
  { 0,0,0,0,6,0,6,0,0,192,1,32,0,224,0,32,1,192,30,16,0,8,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,8,16,24,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,24,32,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,17,0,17,6,15,248,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,6,0,8,0,8,0,6,0,8,0,19,0,20,128,24,128,9,0,22,0,32,0,0,0,0,0 },
  { 0,6,9,57,22,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,48,0,64,2,120,3,128,4,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,31,136,2,8,4,16,8,224,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,6,8,9,8,57,16,22,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,8,31,200,0,40,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,0,5,192,6,32,15,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 5,0,5,0,5,0,13,0,16,0,15,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,128,0,0,0,128,0,128,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,192,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,128,1,64,1,128,3,0,4,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,3,0 },
  { 0,0,0,0,0,0,0,8,16,24,0,24,0,0,0,0 },
  { 170,170,0,1,128,0,0,1,178,34,74,55,250,42,74,35,203,162,0,1,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 0,0,127,254,115,206,109,190,109,142,109,182,115,206,127,254,127,254,123,142,115,182,123,182,123,182,113,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,1,64,0,0,0,0 },
  { 0,0,0,62,65,64,32,16,8,8,0,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,12,82,72,68,56,16,40,16,0 },
  { 0,0,0,0,0,0,0,28,32,60,16,32,0,0,0,0 },
  { 0,1,62,64,8,8,8,8,8,8,8,0,0,0,0,0 },
  { 24,32,24,32,8,8,8,8,8,8,8,0,0,0,0,0 },
  { 0,0,12,16,12,16,0,12,18,18,30,2,4,72,48,0 },
  { 0,0,0,0,8,8,8,8,8,8,8,0,12,16,12,16 },
  { 0,0,0,0,24,32,24,32,0,70,72,72,70,66,60,0 },
  { 0,0,0,8,8,8,8,8,8,8,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,4,34,66,60,0,0,8,0,0 },
  { 0,0,0,36,0,0,24,36,34,34,28,0,0,0,0,0 },
  { 0,0,0,0,20,0,0,4,34,66,60,0,0,0,0,0 },
  { 0,0,16,0,40,0,0,4,34,66,60,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,126,16,32,64,72,64,34,28 },
  { 0,0,0,0,0,0,0,0,126,16,32,64,64,64,34,28 },
  { 0,0,0,0,0,16,0,0,126,16,32,64,64,64,34,28 },
  { 0,0,0,0,0,0,8,4,2,66,124,0,0,0,0,0 },
  { 0,0,0,0,32,0,8,4,2,66,124,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,4,2,2,2,4,72,48,0 },
  { 0,0,0,0,0,16,0,0,4,2,2,2,4,72,48,0 },
  { 0,0,0,0,0,0,0,0,1,21,21,94,72,72,48,0 },
  { 0,0,0,8,0,18,0,0,1,21,21,94,72,72,48,0 },
  { 0,0,0,0,0,0,0,0,6,25,78,72,72,48,0,0 },
  { 0,0,0,0,0,4,0,0,6,25,78,72,72,48,0,0 },
  { 0,0,0,32,32,32,32,44,50,34,124,0,0,0,0,0 },
  { 0,0,0,32,36,32,32,44,50,34,124,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,24,36,32,28,32,64,64,66,60 },
  { 0,0,0,0,8,0,0,24,36,32,28,32,64,64,66,60 },
  { 0,0,80,4,8,16,32,64,60,130,126,0,0,0,0,0 },
  { 0,0,0,4,8,16,32,64,60,130,126,0,40,0,16,0 },
  { 0,0,0,0,0,32,80,80,4,74,72,68,66,66,60,0 },
  { 0,0,0,0,0,0,80,0,4,74,72,68,66,66,60,0 },
  { 0,0,0,0,0,32,0,80,4,74,72,68,66,66,60,0 },
  { 0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0 },
  { 0,0,0,8,0,6,10,6,66,66,60,0,0,0,0,0 },
  { 0,0,0,0,36,0,0,28,18,10,38,66,68,56,0,0 },
  { 0,0,0,2,10,18,10,34,66,66,60,0,0,0,0,0 },
  { 0,0,0,2,2,2,2,2,2,34,66,66,68,60,0,0 },
  { 0,0,0,0,0,0,0,0,28,6,30,32,32,32,32,32 },
  { 0,0,0,0,0,16,0,0,4,34,66,66,68,56,0,0 },
  { 0,0,0,0,0,0,0,0,2,0,1,128,3,64,5,32,5,32,3,32,12,192,48,0,64,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,12,18,18,30,2,4,72,48,0 },
  { 0,0,0,0,0,0,0,0,4,74,72,68,66,66,60,0 },
  { 0,0,0,0,0,0,0,0,4,74,72,68,66,60,0,40 },
  { 0,12,48,12,48,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,6,6,50,20,56,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,48,12,48,0,0 },
  { 0,0,0,12,48,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,40,40,28,16,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,48 },
  { 0,0,0,4,20,88,96,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,24,36,36,24,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,62,64,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,32,24,32,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,32,24,32 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,32,0,32 },
  { 0,64,0,128,1,0,7,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,2,64,2,64,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,64,2,128,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,0,1,0,2,128,4,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,1,128,0,0,0,0 },
  { 3,0,7,0,1,0,0,128,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,2,64,1,128,1,128,2,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,28,32,60,16,32 },
  { 0,0,0,0,0,0,16,56,16,0,0,0,0,0,0,0 },
  { 0,0,0,32,32,16,16,8,8,4,4,4,0,0,0,0 },
  { 0,0,0,34,36,24,16,8,8,4,4,4,0,0,0,0 },
  { 0,0,0,73,82,60,32,16,16,8,8,8,0,0,0,0 },
  { 0,0,0,4,8,16,32,24,32,64,66,60,0,0,0,0 },
  { 0,0,0,24,36,36,66,66,66,66,36,24,0,0,0,0 },
  { 0,0,0,64,60,4,4,2,2,2,1,1,0,0,0,0 },
  { 0,0,0,65,65,34,34,20,20,8,8,8,0,0,0,0 },
  { 0,0,0,8,8,8,20,20,34,34,65,65,0,0,0,0 },
  { 0,0,0,24,36,68,76,52,2,2,1,1,0,0,0,0 },
  { 0,0,4,4,72,72,16,16,36,36,64,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,4,4,56,0,0,0 },
  { 0,0,0,24,24,8,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,8,8,127,28,54,34,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,4,34,66,60,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,28,18,10,38,66,68,56,0,0 },
  { 0,0,0,8,8,8,8,0,0,0,0,0,0,0,0,0 },
  { 4,10,30,32,8,8,8,8,8,8,8,0,0,0,0,0 },
  { 6,8,38,88,0,8,8,8,8,8,8,0,0,0,0,0 },
  { 0,0,0,0,8,8,8,8,8,8,8,0,6,8,38,88 },
  { 24,32,24,32,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 6,8,6,8,32,32,32,32,32,32,32,0,0,0,0,0 },
  { 0,0,3,4,3,4,0,12,18,18,30,2,4,72,48,0 },
  { 0,0,51,52,19,36,64,12,18,18,30,2,4,72,48,0 },
  { 0,0,0,0,3,4,3,4,0,70,72,72,70,66,60,0 },
  { 0,0,32,32,56,56,0,4,34,66,60,0,0,0,0,0 },
  { 0,0,16,0,16,0,0,4,34,66,60,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,4,34,66,60,0,8,0,8,0 },
  { 0,0,0,0,20,0,0,4,34,66,60,8,20,8,0,0 },
  { 0,0,40,0,16,0,0,4,34,66,60,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,4,34,66,60,0,20,0,8,0 },
  { 0,0,40,0,40,0,0,4,34,66,60,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,4,34,66,60,0,20,0,20,0 },
  { 0,0,0,24,32,24,32,0,126,16,32,64,64,64,34,28 },
  { 0,0,0,16,0,16,0,0,126,16,32,64,64,64,34,28 },
  { 0,0,0,0,0,0,0,0,126,16,32,64,84,64,34,28 },
  { 0,0,0,0,0,0,0,0,126,16,32,72,64,72,34,28 },
  { 0,0,0,16,0,36,0,0,126,16,32,64,64,64,34,28 },
  { 0,0,0,0,0,0,0,0,126,32,64,84,64,72,34,28 },
  { 0,0,0,0,0,0,0,0,126,32,64,84,64,84,34,28 },
  { 0,32,32,56,56,0,8,4,2,66,124,0,0,0,0,0 },
  { 0,0,0,0,0,0,8,4,2,66,124,8,20,8,0,0 },
  { 0,0,0,0,0,0,8,4,2,66,124,0,8,0,0,0 },
  { 0,32,32,56,56,0,8,4,2,66,124,0,8,0,0,0 },
  { 0,0,0,40,0,0,8,4,2,66,124,0,0,0,0,0 },
  { 0,0,0,0,0,0,8,4,2,66,124,0,40,0,0,0 },
  { 0,0,16,0,40,0,8,4,2,66,124,0,0,0,0,0 },
  { 0,0,40,0,16,0,8,4,2,66,124,0,0,0,0,0 },
  { 0,0,40,0,40,0,8,4,2,66,124,0,0,0,0,0 },
  { 0,0,8,8,14,14,0,0,4,2,2,2,4,72,48,0 },
  { 0,0,17,10,4,4,0,0,4,2,2,2,4,72,48,0 },
  { 0,0,0,0,0,0,0,0,4,2,2,2,4,76,58,4 },
  { 0,0,0,0,0,0,0,0,4,2,2,2,4,72,50,0 },
  { 0,0,0,0,0,0,0,0,8,4,4,4,8,72,53,2 },
  { 0,0,0,0,0,0,0,0,4,2,2,18,4,72,50,0 },
  { 0,0,0,0,0,18,0,0,4,2,2,2,4,72,48,0 },
  { 0,0,0,8,0,20,0,0,4,2,2,2,4,72,48,0 },
  { 0,0,0,18,0,18,0,0,4,2,2,2,4,72,48,0 },
  { 0,0,0,0,4,0,0,1,21,21,94,72,74,48,0,0 },
  { 0,0,0,0,0,0,0,1,21,21,94,80,85,32,2,0 },
  { 0,0,8,0,18,0,0,1,21,21,94,80,85,32,2,0 },
  { 0,0,0,0,0,0,0,0,6,25,78,80,85,32,0,0 },
  { 0,0,0,8,0,18,0,0,6,25,78,72,72,48,0,0 },
  { 0,0,0,36,32,42,32,44,50,34,124,0,0,0,0,0 },
  { 0,0,16,0,36,0,0,24,36,32,28,32,64,64,66,60 },
  { 0,0,0,0,0,6,10,6,66,66,60,0,0,0,0,0 },
  { 0,0,0,0,0,6,10,6,66,66,60,0,8,0,0,0 },
  { 0,0,4,0,0,6,10,6,66,66,60,0,8,0,0,0 },
  { 0,8,0,18,0,6,10,6,66,66,60,0,0,0,0,0 },
  { 0,0,0,0,0,6,10,6,66,66,60,0,36,0,16,0 },
  { 0,10,0,10,0,6,10,6,66,66,60,0,0,0,0,0 },
  { 0,0,0,0,4,0,0,28,18,10,38,66,68,56,0,0 },
  { 0,0,16,0,36,0,0,28,18,10,38,66,68,56,0,0 },
  { 0,0,0,4,8,16,32,64,60,130,126,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,24,0,96,1,128,6,0,8,0,7,252,64,2,63,252,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,4,12,26,36,64,60,130,126,0,0,0,0,0 },
  { 0,8,0,2,10,18,10,34,66,66,60,0,0,0,0,0 },
  { 16,0,40,2,10,18,10,34,66,66,60,0,0,0,0,0 },
  { 0,0,0,2,10,18,10,34,66,66,60,0,20,0,8,0 },
  { 0,8,16,36,72,16,32,64,60,130,126,0,0,0,0,0 },
  { 0,8,16,36,76,26,36,64,60,130,126,0,0,0,0,0 },
  { 0,80,6,24,98,12,48,64,60,130,126,0,0,0,0,0 },
  { 0,8,16,36,72,16,32,64,60,130,126,0,40,0,0,0 },
  { 0,8,16,36,72,16,32,64,60,130,126,0,16,0,16,0 },
  { 64,0,166,24,98,12,48,64,60,130,126,0,0,0,0,0 },
  { 17,10,4,4,0,2,2,2,2,34,66,66,68,60,0,0 },
  { 0,2,0,2,2,2,2,2,2,34,66,66,68,60,0,0 },
  { 4,0,9,0,2,2,2,2,2,34,66,66,68,60,0,0 },
  { 0,0,0,2,2,2,2,2,2,34,66,60,0,20,0,8 },
  { 0,0,0,0,0,8,0,0,4,34,66,66,68,56,0,8 },
  { 0,0,0,0,0,0,0,0,4,34,66,66,68,56,0,0 },
  { 0,0,16,16,28,28,0,0,4,34,66,66,68,56,0,0 },
  { 0,0,0,0,0,8,0,0,4,34,66,66,68,60,10,4 },
  { 0,0,0,16,0,36,0,0,4,34,66,66,68,56,0,0 },
  { 0,0,0,0,0,0,16,44,42,26,36,64,0,0,0,0 },
  { 0,0,0,0,0,16,0,0,126,32,64,84,64,72,34,28 },
  { 0,24,32,24,32,0,16,24,36,36,60,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,16,46,64,0,0,0,0 },
  { 0,0,0,0,24,32,24,32,0,16,46,64,0,0,0,0 },
  { 0,0,0,0,0,0,40,0,0,16,46,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,12,18,18,14,34,82,36,120,0 },
  { 0,0,0,0,0,0,0,12,18,18,30,2,28,72,48,0 },
  { 0,0,34,20,8,8,0,12,18,18,30,2,4,72,48,0 },
  { 0,16,40,40,28,16,32,76,18,18,30,2,4,72,48,0 },
  { 0,0,0,8,4,4,0,12,18,18,30,2,4,72,48,0 },
  { 0,0,0,8,20,34,0,12,18,18,30,2,4,72,48,0 },
  { 0,0,0,0,20,0,0,12,18,18,30,2,4,72,48,0 },
  { 0,0,8,0,18,0,0,12,18,18,30,2,4,72,48,0 },
  { 0,0,0,0,0,0,0,0,4,74,72,68,66,66,60,0 },
  { 0,0,0,0,0,0,0,0,4,42,104,164,34,34,28,0 },
  { 0,0,0,68,40,16,16,0,4,74,72,68,66,66,60,0 },
  { 0,0,0,0,8,0,0,12,18,18,30,2,4,72,48,0 },
  { 0,0,0,0,0,0,0,12,82,72,68,56,0,16,0,16 },
  { 0,0,0,0,0,0,0,12,82,72,68,56,0,40,0,16 },
  { 0,0,0,0,0,0,0,0,0,8,20,16,32,64,127,0 },
  { 0,0,0,0,0,48,64,48,64,8,20,16,32,64,127,0 },
  { 0,0,0,0,0,0,0,0,0,0,60,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,24,36,36,60,0,0,0,0,0 },
  { 2,8,2,92,15,252,16,0,31,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 2,72,2,32,15,224,16,0,31,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,64,0,160,1,224,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 8,128,4,128,3,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 31,128,4,0,9,0,4,32,3,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,10,0,8,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,40,9,248,9,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 85,85,128,0,1,193,134,48,11,233,140,24,16,5,144,4,16,5,140,24,11,233,134,48,1,193,128,0,0,1,170,170 },
  { 0,0,0,128,1,64,31,252,20,20,24,12,17,196,50,38,82,37,50,38,17,196,24,12,20,20,31,252,1,64,0,128 },
  { 0,0,1,128,2,128,2,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,128,2,64,2,64,2,64,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,7,224,0,64,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,128,3,128,2,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,40,9,248,9,0,6,0 },
  { 0,0,0,0,0,96,7,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,6,6,4,56,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,16,32,64,127,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,0,8,0,16,0,31,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,128,4,32,4,32,3,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,128,1,64,2,160,5,80,10,168,21,84,42,42,21,84,21,84,21,84,21,212,20,20,23,244,48,6,127,255 },
  { 1,0,2,128,4,64,2,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,128,4,64,2,128,1,0 },
  { 0,0,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,1,0,1,0,0,128 },
  { 0,0,8,20,34,0,8,4,2,66,124,0,0,0,0,0 },
  { 0,0,0,0,4,10,17,0,4,2,2,2,4,72,48,0 },
  { 0,0,0,0,0,0,16,56,16,0,0,0,0,0,0,0 },
  { 0,0,0,32,32,16,16,8,8,4,4,4,0,0,0,0 },
  { 0,0,0,34,36,24,16,8,8,4,4,4,0,0,0,0 },
  { 0,0,0,73,82,60,32,16,16,8,8,8,0,0,0,0 },
  { 0,0,0,24,36,96,114,44,32,16,16,16,0,0,0,0 },
  { 0,0,0,0,8,8,20,20,34,34,73,85,99,0,0,0 },
  { 0,0,0,0,28,34,32,32,24,6,24,96,0,0,0,0 },
  { 0,0,0,65,65,34,34,20,20,8,8,8,0,0,0,0 },
  { 0,0,0,8,8,8,20,20,34,34,65,65,0,0,0,0 },
  { 0,0,0,24,36,68,76,52,2,2,1,1,0,0,0,0 },
  { 0,0,8,0,18,0,0,1,21,21,94,72,74,48,0,0 },
  { 0,0,0,0,0,4,0,0,6,25,78,72,74,48,0,0 },
  { 0,0,0,0,8,0,0,24,36,32,28,32,72,64,66,60 },
  { 0,0,0,0,0,0,28,32,60,16,32,0,20,20,20,20 },
  { 0,0,0,0,0,0,0,0,28,6,62,64,74,74,74,74 },
  { 0,0,2,0,5,0,8,128,2,0,1,128,3,64,5,32,5,32,3,32,12,192,48,0,64,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,0,3,128,1,0,8,32,28,112,8,32,1,0,3,128,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,24,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,24,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,24,0,24,0,0,0,0,0,0,0,0,0,24,0,24,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,24,0,0,0,0,0,0,0,0,0,24,0,24,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,102,0,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,96,0,96,0,0,0,0,0,6,0,6,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,6,0,6,0,0,0,0,0,0,0,96,0,96,0,0,0,0,0,0,0 },
  { 0,0,0,0,96,0,96,0,0,0,0,0,6,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,96,0,0,0,0,0,6,0,6,0 },
  { 0,0,36,0,36,0,126,0,0,0,0,0,0,0,0,0,24,0,24,0,0,0,0,0,0,0,0,0,24,0,24,0 },
  { 0,0,0,0,0,0,0,0,127,254,0,0,0,0,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,64,0,32,0,16,0,8,0,4,0,2,0,1,0,0,128,0,64,0,36,0,28,0,28,0,60,0,0,0,0 },
  { 0,0,1,128,1,128,25,152,25,152,1,128,1,128,127,254,127,254,1,128,1,128,25,152,25,152,1,128,1,128,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,115,134,109,190,109,142,109,190,115,134,127,254,0,0 },
  { 0,0,0,0,49,140,63,252,49,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,7,0,7,0,14,0,60,127,248,255,192,198,0,195,0,193,192,192,240,64,112,0,0,0,0,0,0 },
  { 2,0,12,0,120,0,80,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,12,0,15,240,7,248,0,8,96,8,96,8,127,248,63,240,0,0,0,0,0,0 },
  { 0,0,6,0,7,0,3,0,1,128,1,128,112,192,124,96,15,48,3,240,0,248,0,28,0,6,0,0,0,0,0,0 },
  { 0,0,6,0,7,0,3,0,1,128,1,128,115,192,126,96,15,48,3,240,0,248,0,28,0,6,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,0,62,0,14,0,6,0,6,0,6,0,6,0,38,0,6,0,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,0,62,0,14,0,6,0,6,0,6,0,6,0,6,0,6,0,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,31,120,63,252,96,132,64,130,64,130,65,2,97,6,50,12,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,128,12,192,24,96,16,32,16,48,16,16,25,152,15,152,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,12,0,14,0,14,0,6,0,6,0,6,0,6,0,6,0,6,0,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,12,3,12,1,6,1,2,0,130,64,130,96,132,63,252,31,120,0,0,0,0 },
  { 0,0,12,0,14,0,6,0,3,0,1,0,1,128,96,128,127,248,63,252,0,66,0,66,0,66,0,36,0,24,0,0 },
  { 0,0,12,0,14,0,6,0,3,0,1,0,1,128,96,128,127,248,63,252,0,66,0,90,0,90,0,36,0,24,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,24,0,12,0,12,0,12,0,24,0,48,0 },
  { 0,0,2,0,0,0,5,0,0,0,29,192,63,224,98,32,66,36,66,34,68,18,100,18,36,12,0,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,0,24,96,24,112,28,152,4,152,7,136,3,12,0,4,0,4,0,2,0,2,0,1 },
  { 0,0,0,0,14,0,14,0,6,0,3,0,1,128,0,192,0,96,48,48,48,48,63,240,31,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,112,0,126,0,31,248,3,252,3,4,3,4,3,4,3,252,6,248,12,0,24,0,16,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,0,62,0,63,128,7,192,0,240,0,24,0,4,0,2,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,60,0,102,120,67,204,65,132,97,132,49,136,31,240,15,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,60,0,102,120,67,204,65,132,97,132,49,136,31,240,15,224,1,128,1,128,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,0,1,128,96,192,96,96,127,254,63,254,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,224,2,48,2,16,2,24,1,232,96,12,96,4,127,254,63,254,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,0,24,128,16,128,48,128,47,0,96,12,64,12,255,252,255,248,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,16,0,56,15,252,31,252,16,0,12,0,3,192,0,48,0,24,0,56,255,240,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,240,3,248,2,8,2,4,2,4,19,252,23,252,12,0,0,0,0,0 },
  { 2,0,0,0,0,0,63,0,62,0,14,0,6,0,6,0,6,0,6,0,6,0,6,0,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,6,96,15,240,15,240,7,224,3,192,97,134,127,254,63,254,0,0,0,0,0,0 },
  { 0,0,96,0,112,0,48,0,8,192,5,224,6,16,6,16,10,8,17,8,32,140,63,140,31,12,0,0,0,0,0,0 },
  { 0,0,0,0,0,32,0,96,0,192,1,128,3,252,3,254,0,2,0,2,96,2,127,254,63,252,0,0,0,0,0,0 },
  { 0,0,3,0,1,128,25,128,31,0,12,0,2,0,1,0,96,128,124,64,63,224,7,248,0,28,0,6,0,2,0,0 },
  { 0,0,0,0,0,0,63,0,62,0,14,0,6,0,6,0,6,0,6,0,70,0,6,0,18,0,0,0,0,0,0,0 },
  { 62,0,36,0,40,0,48,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,12,0,20,0,36,0,124,0 },
  { 0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0 },
  { 24,0,36,0,36,0,24,0,16,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,8,0,24,0,36,0,36,0,24,0 },
  { 0,0,8,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,0,4,0,10,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,0,40,0,16,0,12,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,32,0 },
  { 124,0,16,0,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,0,8,0,62,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0 },
  { 1,0,2,0,5,0,8,128,18,64,5,32,2,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,128,9,64,4,144,2,32,1,64,0,128,1,0 },
  { 0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0 },
  { 0,0,16,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,16,0 },
  { 0,0,16,0,0,0,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,0,0,0,16,0 },
  { 0,0,0,0,8,0,16,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,16,0,8,0 },
  { 1,32,0,208,0,232,1,116,0,186,0,92,0,44,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 84,0,16,0,124,0,16,0,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,109,142,109,182,97,142,125,182,125,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,109,198,109,190,97,190,125,190,125,198,127,254,0,0 },
  { 0,0,24,24,24,24,24,24,12,48,12,48,4,32,4,96,6,96,6,96,2,192,2,192,3,192,1,128,1,128,0,0 },
  { 0,0,0,0,0,12,0,6,0,230,0,252,0,48,0,16,0,8,0,8,96,4,127,254,63,254,0,0,0,0,0,0 },
  { 0,0,1,128,1,128,0,192,0,44,0,50,0,18,0,28,0,8,0,8,96,4,127,254,63,254,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,4,34,66,60,0,0,42,0,0 },
  { 0,0,0,16,0,40,0,4,34,66,60,0,0,8,0,0 },
  { 0,0,0,0,0,0,0,4,34,66,60,0,8,0,20,0 },
  { 0,0,0,0,8,32,0,4,34,66,60,0,8,0,20,0 },
  { 0,0,0,0,0,16,0,4,34,66,60,0,0,20,0,0 },
  { 0,0,0,0,0,0,0,4,34,66,60,0,8,20,34,0 },
  { 0,0,0,68,40,16,0,4,34,66,60,0,0,0,0,0 },
  { 0,0,0,0,0,0,40,0,126,16,32,64,64,64,34,28 },
  { 0,0,0,0,0,0,0,0,126,16,36,64,74,64,34,28 },
  { 0,32,56,36,120,0,8,4,2,66,124,0,16,0,16,0 },
  { 0,0,0,0,0,0,8,4,2,66,124,0,8,20,34,0 },
  { 0,0,0,0,0,0,0,0,4,2,2,31,4,72,48,0 },
  { 0,0,0,0,0,20,0,20,1,21,21,94,72,72,48,0 },
  { 0,0,0,0,0,40,0,24,36,32,28,32,64,64,66,60 },
  { 0,0,0,40,0,16,0,24,36,32,28,32,64,64,66,60 },
  { 0,0,0,16,0,16,0,24,36,32,28,32,64,64,66,60 },
  { 0,0,0,0,0,6,10,6,66,66,60,0,10,0,0,0 },
  { 0,0,0,0,0,6,10,6,66,66,60,0,4,0,10,0 },
  { 0,0,0,4,136,16,32,64,60,130,126,0,0,0,0,0 },
  { 0,64,0,164,8,16,32,64,60,130,126,0,0,0,0,0 },
  { 0,0,0,4,8,16,32,64,60,130,126,0,8,0,20,0 },
  { 0,0,0,0,0,8,0,0,28,6,30,32,32,32,32,32 },
  { 0,0,0,0,0,0,0,0,28,6,30,32,40,32,32,32 },
  { 0,0,0,0,0,0,32,0,4,34,66,66,68,56,0,20 },
  { 0,32,56,36,120,0,32,0,4,34,66,66,68,56,0,0 },
  { 0,0,68,40,16,0,32,0,4,34,66,66,68,56,0,0 },
  { 0,0,0,4,4,4,4,30,4,36,68,68,68,56,0,0 },
  { 0,0,0,0,16,0,16,0,4,2,2,2,4,72,48,0 },
  { 0,0,0,24,32,24,32,0,4,2,2,2,4,72,48,0 },
  { 0,0,0,0,4,0,4,0,1,21,21,94,72,72,48,0 },
  { 0,0,0,0,0,0,0,0,126,16,40,76,74,92,34,28 },
  { 0,0,0,0,0,126,16,40,76,74,92,64,84,64,34,28 },
  { 32,32,40,52,120,0,20,1,21,21,94,72,72,48,0,0 },
  { 32,32,40,52,120,0,16,64,4,2,2,2,4,72,48,0 },
  { 0,0,16,16,20,26,60,0,126,16,32,64,64,64,34,28 },
  { 40,40,48,32,40,40,8,8,8,8,8,0,0,0,0,0 },
  { 42,42,52,32,40,40,8,8,8,8,8,0,0,0,0,0 },
  { 0,0,0,20,20,24,16,16,16,70,72,72,70,66,60,0 },
  { 0,0,0,21,21,26,16,16,16,70,72,72,70,66,60,0 },
  { 0,0,0,0,70,72,72,70,66,60,0,8,22,16,16,16 },
  { 0,0,80,80,96,64,64,76,18,18,30,2,4,72,48,0 },
  { 0,0,84,84,104,64,64,76,18,18,30,2,4,72,48,0 },
  { 0,0,0,0,0,80,80,96,64,72,84,16,32,64,127,0 },
  { 0,0,0,0,0,84,84,104,64,72,84,16,32,64,127,0 },
  { 0,0,0,0,0,0,0,0,126,16,36,75,72,72,34,28 },
  { 0,0,8,22,16,16,16,1,21,21,94,72,72,48,0,0 },
  { 0,0,0,8,20,20,0,1,21,21,94,72,72,48,0,0 },
  { 0,0,0,10,34,2,10,18,10,10,50,2,4,124,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,16,32,64,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,18,28,32,64,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,42,52,64,128,0,0 },
  { 0,0,0,0,0,0,0,0,18,12,12,18,32,64,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,40,84,84,40,0,0 },
  { 0,0,0,0,0,0,0,0,0,16,36,24,16,32,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,36,40,48,32,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,12,20,36,0,0 },
  { 0,0,0,0,0,0,0,0,8,20,20,8,16,32,0,0 },
  { 0,0,0,0,0,0,0,0,56,4,4,8,16,32,0,0 },
  { 0,0,0,0,0,0,2,4,2,4,2,4,8,16,0,0 },
  { 0,0,0,0,0,0,0,0,0,2,4,4,24,32,64,0 },
  { 0,0,0,0,0,0,0,0,12,18,44,64,32,64,0,0 },
  { 0,0,0,0,0,0,0,0,8,18,60,8,16,32,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,8,16,8,48,0,0 },
  { 0,0,0,0,0,0,0,0,0,84,40,64,64,56,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,8,31,240,32,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,16,12,8,16,30,0,0 },
  { 0,0,0,0,0,0,0,18,12,12,18,32,32,28,0,0 },
  { 0,0,0,0,0,0,0,20,42,42,20,32,32,28,0,0 },
  { 0,0,0,0,0,0,0,0,0,22,26,18,32,64,0,0 },
  { 0,0,0,0,0,0,2,4,2,4,2,4,8,18,0,0 },
  { 0,0,0,0,0,0,0,4,8,8,112,64,64,56,0,0 },
  { 0,0,0,0,0,1,2,4,12,26,42,68,32,192,0,0 },
  { 0,0,0,0,4,0,10,0,12,26,42,68,32,192,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,16,32,72,0,0 },
  { 0,0,0,0,0,0,0,0,16,0,16,16,32,64,0,0 },
  { 0,0,0,0,0,0,0,4,0,2,4,4,24,32,64,0 },
  { 0,0,0,0,0,0,4,0,18,12,12,18,32,64,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,1,64,24,8,31,240,32,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,8,31,240,32,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,24,8,31,240,32,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,18,44,64,36,64,0,0 },
  { 0,0,0,0,0,0,4,0,12,18,44,64,32,64,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,12,20,36,0,16 },
  { 0,0,0,0,0,0,0,0,4,0,4,12,20,36,0,0 },
  { 0,0,0,0,0,0,0,20,0,4,8,16,8,48,0,0 },
  { 0,0,0,0,0,0,8,0,8,20,20,8,16,32,0,0 },
  { 0,16,32,64,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,96,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,16,32,64 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,16,36,72 },
  { 0,96,16,32,64,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,102,17,34,68,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,16,32,64,48,0,0,0,0,0,0,0,0,0,0,0 },
  { 34,68,136,102,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 66,36,24,102,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,36,64,72,48,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,48,72,48,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,40,40,16,32,64,64,56,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,99,134,109,246,99,134,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,99,142,109,246,99,198,109,246,99,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,99,182,109,182,99,134,109,246,99,246,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,99,134,109,190,99,134,109,246,99,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,99,206,109,190,99,142,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,99,134,109,246,99,238,109,222,99,222,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,99,206,109,182,99,206,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,99,206,109,182,99,198,109,246,99,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,99,134,109,182,99,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,99,142,109,182,99,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,99,198,109,190,99,190,109,190,99,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,99,142,109,182,99,182,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,99,134,109,190,99,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,99,134,109,190,99,142,109,190,99,190,127,254,0,0 },
  { 0,0,0,0,24,36,36,66,66,66,66,36,36,24,0,0 },
  { 0,0,0,0,24,20,18,16,16,16,16,16,16,126,0,0 },
  { 0,0,0,0,34,34,34,62,32,32,32,32,32,32,0,0 },
  { 0,0,0,0,0,0,4,4,4,4,4,4,60,4,4,60 },
  { 0,0,0,0,0,0,4,4,4,4,4,60,32,32,32,60 },
  { 0,0,0,0,32,32,32,32,56,32,32,32,32,32,0,0 },
  { 0,0,0,0,64,64,64,64,124,4,4,4,4,4,0,0 },
  { 0,0,0,0,64,64,64,64,66,68,72,80,96,96,0,0 },
  { 0,0,0,0,64,64,64,64,126,68,72,80,96,96,0,0 },
  { 0,0,0,0,56,68,68,68,56,16,16,16,16,16,0,0 },
  { 0,0,0,0,16,16,16,16,16,16,16,16,16,16,0,0 },
  { 0,0,0,0,0,0,0,0,24,36,66,66,36,24,0,0 },
  { 0,0,0,0,130,68,40,40,16,16,16,16,16,16,0,0 },
  { 0,0,0,0,0,0,0,0,0,16,40,40,68,68,0,0 },
  { 0,0,0,0,0,0,0,0,68,68,68,68,68,124,0,0 },
  { 0,0,0,0,0,0,0,0,124,4,4,4,4,124,0,0 },
  { 0,0,0,0,56,68,68,68,56,16,16,16,16,124,0,0 },
  { 0,0,0,0,0,16,32,32,24,0,0,0,0,126,0,0 },
  { 0,0,0,0,16,40,40,30,10,18,2,2,2,2,0,0 },
  { 0,0,0,0,0,60,32,32,60,32,32,32,32,32,32,0 },
  { 0,0,0,0,0,60,4,4,60,4,4,4,4,4,4,0 },
  { 0,0,0,0,64,64,64,64,120,68,68,68,68,120,0,0 },
  { 0,0,0,0,0,62,32,32,16,16,8,8,4,4,4,0 },
  { 0,0,0,0,24,40,72,8,8,8,8,8,8,8,0,0 },
  { 0,0,0,0,0,0,0,0,44,82,82,82,82,126,0,0 },
  { 0,0,0,0,8,8,62,8,8,8,8,8,8,8,0,0 },
  { 0,0,0,0,36,36,36,36,126,36,36,36,36,60,0,0 },
  { 0,0,0,0,0,0,0,0,126,66,66,66,66,126,0,0 },
  { 0,0,0,0,0,0,0,0,124,68,68,40,40,16,0,0 },
  { 0,0,0,0,4,10,10,10,12,120,72,72,72,120,0,0 },
  { 0,0,0,0,0,4,36,36,60,36,36,4,4,4,4,0 },
  { 0,0,0,0,48,72,72,72,62,8,8,8,8,8,0,0 },
  { 0,0,0,0,124,16,16,16,16,16,16,16,16,16,0,0 },
  { 0,0,0,0,0,0,0,0,16,40,40,68,68,124,0,0 },
  { 0,0,0,0,112,16,16,56,68,68,56,16,16,16,0,0 },
  { 0,0,0,0,0,62,34,34,2,2,2,2,2,2,2,0 },
  { 0,0,0,0,0,32,32,60,36,36,4,4,4,4,4,0 },
  { 0,0,0,0,0,60,4,4,4,60,36,36,36,36,60,0 },
  { 0,0,0,0,16,16,16,56,68,68,56,16,16,16,0,0 },
  { 0,0,0,0,124,16,16,56,68,68,56,16,16,16,0,0 },
  { 0,0,0,0,2,2,28,4,8,8,16,34,68,120,0,0 },
  { 0,0,0,0,2,2,28,4,8,8,28,34,68,120,0,0 },
  { 0,0,0,0,8,8,8,8,62,8,8,8,8,8,0,0 },
  { 0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,18,44,64,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,16,40,68,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 8,4,2,126,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,72,52,2,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,16,32,64,126,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0 },
  { 0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,48,8,8,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,32,32,24,0,0,0,0,0,0 },
  { 0,0,0,0,0,28,34,34,34,30,4,8,16,32,62,0 },
  { 0,0,0,0,28,34,42,34,65,85,65,42,28,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,0,0,56,0,0 },
  { 0,0,0,0,0,0,0,0,56,0,16,0,16,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,60,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,246,109,238,109,222,115,222,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,1,16,2,160,4,64,8,36,8,40,16,48,16,32,12,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,128,4,64,8,32,15,224,0,16,0,16,0,8,63,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,48,7,192,4,64,8,64,0,32,0,16,0,32,0,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,248,4,32,8,16,15,240,0,8,0,8,0,16,0,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,48,7,192,4,192,9,64,2,96,4,144,5,32,0,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,64,7,160,4,144,9,0,3,0,4,224,0,16,0,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,128,4,64,28,96,19,144,16,16,16,16,16,32,28,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,32,7,192,4,192,9,64,50,96,12,144,5,16,2,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,0,4,0,9,240,17,16,8,160,4,160,2,64,1,64,0,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,3,144,4,144,4,144,9,32,9,32,9,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,8,12,8,31,240,0,16,0,16,0,16,2,16,7,144,15,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,128,0,128,0,128,3,0,4,0,8,0,8,16,24,48,31,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,136,29,216,31,248,32,8,0,8,8,16,30,16,63,240,0,0,0,0 },
  { 0,0,0,0,4,0,4,0,4,0,8,0,8,0,15,240,0,16,0,16,0,16,2,16,7,144,15,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,0,9,0,10,0,25,192,0,120,0,144,8,160,31,96,1,0,2,0,7,128,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,8,64,4,64,2,128,1,128,0,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,240,0,16,0,16,0,16,2,16,7,144,15,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,240,20,144,28,144,20,144,5,32,25,32,9,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,0,7,224,6,16,9,16,0,160,0,64,1,128,2,0,1,128,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,192,4,32,8,16,15,240,0,8,0,8,0,16,0,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,136,29,216,31,248,32,4,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,128,4,64,8,36,8,40,16,48,16,32,12,64,0,0,0,0 },
  { 0,0,0,16,0,32,0,40,0,18,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,16,0,18,0,20,0,22,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,15,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,128,0,64,0,32,0,64,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,7,16,8,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,7,16,8,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,68,0,68,0,40,0,40,0,16,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,68,0,40,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,0,16,0,16,0,16,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,0,16,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,128,0,128,1,0,1,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,8,0,8,0,16,0,16,0,32,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,0,16,0,40,0,40,0,68,0,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,0,40,0,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,128,1,0,2,0,1,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,3,0,12,0,48,0,12,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,2,0,4,0,8,0,4,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,0,16,0,40,0,40,0,68,0,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,192,1,32,1,32,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,134,125,190,97,142,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,134,125,190,97,142,111,190,97,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,128,1,128,0,0,0,0,0,0,0,0,1,128,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,12,96,12,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,63,24,48,24,16,0,8,0,4,0,2,0,2,0,4,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,63,24,48,24,16,0,8,0,4,0,2,24,2,24,4,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,64,0,0,3,192,4,0,4,0,3,0,0,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,48,0,48,0,0,0,128,0,64,0,64,0,128,1,0,2,0,6,0,7,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,126,0,96,0,32,127,144,0,8,0,4,0,4,0,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,127,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,0,6,0,0,127,224,0,0,0,6,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,127,230,0,0,0,0,0,0,0,6,127,230,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,96,4,96,4,0,4,0,4,0,4,96,4,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,16,0,32,0,64,0,128,1,0,2,0,4,0,8,0,16,0,32,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,16,0,32,0,64,0,128,1,24,2,24,4,0,8,0,17,152,33,152,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,128,2,64,2,64,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,134,125,190,113,142,125,190,99,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,4,64,8,32,8,32,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,132,1,4,2,4,3,248,0,64,0,32,63,254,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,96,0,144,1,96,1,0,0,128,0,64,0,48,63,252,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,20,0,36,0,68,0,124,0,4,0,4,63,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,0,84,63,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,16,0,8,0,4,3,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,224,4,16,4,8,3,252,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,224,1,32,1,64,1,64,0,160,63,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,128,1,0,2,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,64,16,128,9,0,9,0,4,224,4,32,4,64,4,128,9,0,14,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,0,4,0,4,0,4,0,4,0,4,0,4,1,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,132,1,4,2,4,3,252,0,68,0,36,63,196,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,64,8,32,8,32,4,32,4,64,4,64,4,128,9,0,14,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,132,0,68,63,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,64,0,128,1,0,1,248,0,4,0,4,63,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,192,17,32,9,96,8,160,4,32,4,64,4,64,4,128,9,0,14,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,42,16,42,8,62,8,32,4,32,4,64,4,64,4,128,9,0,14,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,132,1,4,2,4,3,252,0,68,0,36,63,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,132,1,4,2,4,3,252,0,4,0,4,63,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,12,24,18,36,18,36,13,88,1,64,1,64,0,128,0,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,132,0,124,0,36,0,36,15,196,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,16,4,32,8,64,15,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,17,16,32,160,32,160,31,156,0,132,0,136,0,144,1,32,1,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,128,1,0,2,0,2,0,1,192,2,0,2,0,2,0,1,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,64,2,64,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,128,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,198,111,190,97,190,125,190,97,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,142,111,182,97,182,125,182,97,142,127,254,0,0 },
  { 0,0,0,0,0,0,1,128,6,96,8,16,9,144,18,72,18,72,9,144,8,16,6,96,1,128,0,0,0,0,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,134,111,190,97,142,125,190,97,190,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,206,111,182,99,182,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,238,111,206,99,238,109,238,115,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,111,246,99,134,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,142,111,246,99,198,109,246,115,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,182,111,182,99,134,109,246,115,246,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,111,190,99,134,109,246,115,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,206,111,190,99,142,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,111,246,99,238,109,222,115,222,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,206,111,182,99,206,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,206,111,182,99,198,109,246,115,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,111,182,99,134,109,182,115,182,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,142,111,182,99,142,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,198,111,190,99,190,109,190,115,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,142,111,182,99,182,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,111,190,99,142,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,111,190,99,142,109,190,115,190,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,206,125,182,123,182,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,238,125,206,123,238,119,238,119,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,134,125,246,123,134,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,142,125,246,123,198,119,246,119,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,182,125,182,123,134,119,246,119,246,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,134,125,190,123,134,119,246,119,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,206,125,190,123,142,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,134,125,246,123,238,119,222,119,222,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,206,125,182,123,206,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,206,125,182,123,198,119,246,119,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,134,125,182,123,134,119,182,119,182,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,142,125,182,123,142,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,198,125,190,123,190,119,190,119,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,142,125,182,123,182,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,134,125,190,123,142,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,134,125,190,123,142,119,190,119,190,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,206,109,182,115,182,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,238,109,206,115,238,109,238,115,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,109,246,115,134,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,142,109,246,115,198,109,246,115,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,182,109,182,115,134,109,246,115,246,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,109,190,115,134,109,246,115,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,206,109,190,115,142,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,109,246,115,238,109,222,115,222,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,206,109,182,115,206,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,206,109,182,115,198,109,246,115,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,109,182,115,134,109,182,115,182,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,142,109,182,115,142,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,198,109,190,115,190,109,190,115,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,142,109,182,115,182,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,109,190,115,142,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,109,190,115,142,109,190,115,190,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,206,109,182,113,182,125,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,238,109,206,113,238,125,238,115,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,109,246,113,134,125,190,115,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,142,109,246,113,198,125,246,115,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,182,109,182,113,134,125,246,115,246,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,109,190,113,134,125,246,115,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,206,109,190,113,142,125,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,109,246,113,238,125,222,115,222,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,206,109,182,113,206,125,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,206,109,182,113,198,125,246,115,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,109,182,113,134,125,182,115,182,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,142,109,182,113,142,125,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,198,109,190,113,190,125,190,115,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,142,109,182,113,182,125,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,109,190,113,142,125,190,115,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,115,134,109,190,113,142,125,190,115,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,4,34,66,60,0,40,40,16,0 },
  { 0,0,12,16,12,16,0,4,34,66,60,0,16,0,0,0 },
  { 0,0,0,0,0,8,32,0,126,16,32,64,72,64,34,28 },
  { 0,0,0,32,34,40,32,44,50,34,124,0,0,0,0,0 },
  { 0,16,0,40,0,6,10,6,66,66,60,0,16,0,0,0 },
  { 0,0,0,0,36,0,0,28,18,10,38,66,68,56,0,16 },
  { 0,0,0,4,4,31,4,31,4,36,68,68,72,56,0,0 },
  { 0,0,0,0,8,0,20,0,28,6,30,32,32,32,32,32 },
  { 0,0,0,0,24,32,24,32,4,74,72,68,66,60,0,40 },
  { 0,0,0,0,0,0,16,0,4,74,72,68,66,60,0,40 },
  { 0,0,0,0,0,0,0,0,4,2,2,2,52,72,52,2 },
  { 0,0,0,0,0,0,0,12,18,18,14,34,4,72,48,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,20,20,110,64,74 },
  { 0,0,0,0,0,0,8,8,8,8,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,8,4,2,66,124,0,40,0,16,0 },
  { 0,0,0,0,0,0,0,0,6,25,78,72,48,4,32,8 },
  { 0,0,8,16,36,72,80,64,60,130,126,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,8,20,20,30,4,4,4,4,0 },
  { 0,0,16,40,68,0,16,0,4,2,2,2,4,72,48,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,142,109,246,99,198,109,246,99,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,182,109,182,99,134,109,246,99,246,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,134,109,190,99,134,109,246,99,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,206,109,190,99,142,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,134,109,246,99,238,109,222,99,222,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,206,109,182,99,206,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,206,109,182,99,198,109,246,99,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,134,109,182,99,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,142,109,182,99,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,198,109,190,99,190,109,190,99,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,142,109,182,99,182,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,134,109,190,99,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,134,109,190,99,142,109,190,99,190,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,206,111,182,111,182,111,182,113,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,238,111,206,111,238,111,238,113,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,134,111,246,111,134,111,190,113,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,142,111,246,111,198,111,246,113,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,182,111,182,111,134,111,246,113,246,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,134,111,190,111,134,111,246,113,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,206,111,190,111,142,111,182,113,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,134,111,246,111,238,111,222,113,222,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,206,111,182,111,206,111,182,113,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,206,111,182,111,198,111,246,113,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,134,111,182,111,134,111,182,113,182,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,142,111,182,111,142,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,198,111,190,111,190,111,190,113,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,142,111,182,111,182,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,134,111,190,111,142,111,190,113,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,113,134,111,190,111,142,111,190,113,190,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,206,109,182,109,182,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,238,109,206,109,238,109,238,99,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,134,109,246,109,134,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,142,109,246,109,198,109,246,99,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,182,109,182,109,134,109,246,99,246,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,134,109,190,109,134,109,246,99,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,206,109,190,109,142,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,134,109,246,109,238,109,222,99,222,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,206,109,182,109,206,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,206,109,182,109,198,109,246,99,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,134,109,182,109,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,142,109,182,109,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,198,109,190,109,190,109,190,99,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,142,109,182,109,182,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,134,109,190,109,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,99,134,109,190,109,142,109,190,99,190,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,206,111,182,99,182,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,238,111,206,99,238,111,238,97,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,134,111,246,99,134,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,206,109,182,115,206,127,254,127,254,97,142,111,246,99,198,111,246,97,142,127,254,0,0 },
  { 0,4,2,12,16,8,0,0,0,0,0,0,0,0,0,0 },
  { 0,2,5,5,2,37,24,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,4,2,12,16,8 },
  { 0,34,17,102,136,68,0,0,0,0,0,0,0,0,0,0 },
  { 28,34,34,85,34,34,28,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,34,17,102,136,68 },
  { 0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,32,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,26,36,26,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,64 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,52,72,52 },
  { 0,6,24,0,24,96,0,0,0,0,0,0,0,0,0,0 },
  { 0,34,85,85,34,85,136,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,24,0,24,96 },
  { 0,4,10,14,2,28,0,0,0,0,0,0,0,0,0,0 },
  { 0,52,72,84,36,88,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,32,6,24,96,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,24,96,4,0 },
  { 0,16,32,64,32,16,0,0,0,0,0,0,0,0,0,0 },
  { 0,32,16,8,16,32,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,16,32,16,8 },
  { 0,0,0,0,0,0,0,0,0,0,0,32,16,8,16,32 },
  { 0,72,36,18,36,72,0,0,0,0,0,0,0,0,0,0 },
  { 0,72,36,146,36,72,0,0,0,0,0,0,0,0,0,0 },
  { 0,16,8,36,8,16,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,8,20,20,78,8,48,0,0,0,0,0,0,0,0 },
  { 0,28,2,2,4,24,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,192,2,48,5,176,9,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,9,128,5,176,2,48,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,12,0,0,0,12,0,12,0,0,0,0,0,0,0,0,0,0 },
  { 8,0,7,192,0,32,14,127,17,48,1,48,3,48,14,48,2,48,33,240,33,176,19,176,15,48,0,48,0,16,0,0 },
  { 0,0,0,0,0,0,28,255,34,96,2,96,6,96,28,96,4,96,67,224,67,96,39,96,30,96,0,96,0,32,0,0 },
  { 0,0,0,0,0,0,28,255,34,102,2,102,6,102,28,102,4,102,67,230,67,102,39,102,30,102,0,102,0,34,0,0 },
  { 0,0,0,0,0,0,255,255,0,192,0,192,15,192,24,0,24,0,15,224,0,48,3,48,5,176,7,224,0,64,0,32 },
  { 3,192,6,32,1,0,255,255,0,192,0,192,15,192,24,0,24,0,15,224,0,48,3,48,5,176,7,224,0,64,0,32 },
  { 0,0,0,0,0,0,255,255,1,128,0,192,0,192,1,192,15,128,65,128,64,192,32,192,16,192,9,192,7,128,0,0 },
  { 0,0,0,0,0,0,255,255,1,128,0,192,0,192,1,192,15,156,65,178,64,226,32,194,16,198,9,196,7,128,0,0 },
  { 0,0,0,0,0,0,255,255,1,128,57,128,101,152,3,152,7,248,31,136,57,136,33,156,1,184,1,160,0,160,0,30 },
  { 0,0,0,0,0,0,255,255,0,32,0,32,56,32,116,248,99,204,99,12,48,12,16,120,12,192,2,128,0,124,0,0 },
  { 0,152,0,112,0,0,255,255,12,48,12,48,12,48,12,48,12,96,4,0,2,0,1,128,0,96,0,16,0,24,0,24 },
  { 16,0,15,224,0,16,255,255,12,48,12,48,12,48,12,48,12,96,4,0,2,0,1,128,0,96,0,16,0,24,0,24 },
  { 0,0,0,0,0,0,255,255,12,48,12,48,12,48,12,48,12,96,4,0,2,0,1,128,0,96,0,16,0,24,0,24 },
  { 15,0,0,128,0,64,255,255,12,48,12,48,12,48,12,48,12,96,4,0,2,0,1,128,0,96,0,16,0,24,0,24 },
  { 0,38,0,30,0,0,28,255,34,102,2,102,6,102,28,102,4,102,67,230,67,102,39,102,30,102,0,102,0,34,0,0 },
  { 1,0,0,248,0,4,28,255,34,102,2,102,6,102,28,102,4,102,67,230,67,102,39,102,30,102,0,102,0,34,0,0 },
  { 0,224,0,16,0,8,28,255,34,102,2,102,6,102,28,102,4,102,67,230,67,102,39,102,30,102,0,102,0,34,0,0 },
  { 0,112,0,232,0,20,28,255,34,102,2,102,6,102,28,102,4,102,67,230,67,102,39,102,30,102,0,102,0,34,0,0 },
  { 0,0,0,0,0,0,255,255,1,128,1,128,29,128,51,224,35,144,39,152,29,152,1,152,1,152,1,128,0,128,0,0 },
  { 0,0,0,0,0,0,255,255,8,24,8,24,9,216,59,56,58,24,18,56,17,216,8,24,6,24,1,152,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,1,152,1,152,1,152,1,152,7,152,3,152,1,152,0,152,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,12,24,12,24,7,216,2,24,4,24,4,56,4,120,3,216,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,0,96,0,96,15,224,24,0,24,4,15,206,0,100,16,96,8,96,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,0,24,31,248,3,24,6,56,6,120,3,216,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,0,16,0,16,60,120,112,228,96,196,32,68,31,44,12,24,24,56,24,100,7,134,0,6 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,0,24,3,248,17,152,8,216,8,216,7,152,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,3,24,3,24,31,24,48,24,48,24,31,248,1,24,13,24,22,24,29,24,0,136,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,7,24,5,152,33,184,33,248,33,216,19,152,15,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,0,192,0,192,0,192,7,192,12,0,24,0,24,0,24,0,12,16,7,224,0,0,0,0 },
  { 0,0,0,0,0,0,255,255,1,128,1,128,1,128,3,128,7,96,12,16,8,24,8,24,8,56,4,112,3,224,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,3,248,6,0,6,0,3,240,0,24,4,24,2,24,1,240,0,0,0,0 },
  { 0,0,0,0,0,0,255,255,0,96,0,96,7,224,12,0,24,0,24,192,25,160,9,16,5,16,3,48,1,224,0,0 },
  { 0,0,0,0,0,0,255,255,25,152,25,152,25,152,25,152,25,152,9,152,7,24,0,24,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,0,24,7,248,14,24,12,24,12,24,6,24,2,24,1,24,0,136,0,0 },
  { 0,0,0,0,0,0,28,127,27,24,25,152,9,152,3,152,15,24,12,56,4,120,3,216,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,0,24,1,248,2,0,6,0,6,24,2,40,1,240,0,8,0,4,0,0 },
  { 0,0,0,0,0,0,14,127,25,24,24,24,24,24,12,24,3,152,6,24,12,24,12,56,12,120,3,216,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,0,24,7,248,6,24,6,24,2,24,0,24,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,0,24,7,248,6,24,6,24,2,24,0,24,1,24,3,152,1,8,0,0 },
  { 0,0,0,0,0,0,255,255,6,24,6,24,6,24,6,24,6,24,2,56,1,216,0,24,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,49,128,49,128,49,128,49,240,49,200,19,132,15,132,1,132,1,140,1,140,0,128,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,7,216,14,120,13,24,12,152,12,120,7,248,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,56,255,54,24,50,24,19,24,15,24,3,24,7,248,7,24,3,24,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,6,24,6,24,6,24,6,24,6,24,15,248,6,24,2,24,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,3,24,3,24,3,24,3,24,6,24,4,56,4,120,3,216,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,0,192,0,192,0,192,3,192,3,128,3,128,1,0,0,128,0,64,0,32,0,24,0,0 },
  { 0,0,0,0,0,0,255,255,0,192,0,192,0,192,3,192,3,128,3,128,1,0,0,128,4,64,14,32,4,24,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,28,56,58,248,49,216,49,152,24,24,8,24,4,24,3,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,0,48,0,48,0,112,14,200,25,140,49,140,49,140,49,152,19,112,14,0,0,0,0,0 },
  { 0,0,0,0,0,0,255,255,0,48,0,48,0,112,14,200,25,140,49,140,49,140,49,152,19,112,14,0,0,192,0,192 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,3,216,15,56,12,24,12,56,4,120,3,216,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,6,24,6,24,31,24,1,152,1,152,25,152,21,24,30,24,2,24,1,24,0,136,0,0 },
  { 0,0,0,0,0,0,255,255,12,24,14,24,13,24,12,152,12,88,12,56,6,56,1,216,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,3,24,3,24,3,24,11,24,15,24,14,248,4,24,4,24,2,24,1,24,0,136,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,7,248,12,0,12,0,6,240,1,152,3,16,3,0,1,128,0,252,0,0 },
  { 1,128,1,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,12,0,12,0,12,0,63,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,4 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,1,128,0,0 },
  { 0,0,0,0,0,0,0,127,0,128,0,128,0,192,0,96,0,48,0,16,0,24,0,24,1,56,0,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,63,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,4 },
  { 60,0,98,0,49,0,252,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,16,0,0,0,0,0 },
  { 0,240,1,8,1,8,0,63,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,4 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,128,4,64,3,128,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,192,2,32,1,144,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,2,0,1,192,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,2,0,1,128,2,0,1,128,0,0 },
  { 0,0,4,64,2,64,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,8,0,7,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,0,1,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,0,1,0,28,128,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,34,0,30,0,0,0,63,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,4 },
  { 0,128,0,120,0,4,0,63,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,4 },
  { 0,240,0,8,0,4,0,63,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,4 },
  { 0,240,1,232,0,20,0,63,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,4 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,0,64,0,32,0,0 },
  { 0,0,0,0,0,0,60,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,32,0 },
  { 0,64,0,60,1,2,0,251,0,6,0,62,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,6,0,2,0,0 },
  { 0,0,2,96,1,108,28,140,34,112,2,0,6,28,28,38,4,102,67,206,67,60,39,0,30,0,0,0,0,0,0,0 },
  { 0,0,0,128,0,128,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,192,0,0,0,0 },
  { 0,0,2,0,1,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,64,0,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,64,2,64,1,128,0,0,7,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,128,15,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,128,15,0,32,64,31,128 },
  { 0,0,0,0,0,0,255,255,0,192,0,192,14,192,25,248,17,200,19,204,14,204,0,204,0,204,4,192,14,64,4,0 },
  { 0,0,0,0,0,0,255,255,8,24,8,24,9,216,59,56,58,24,18,56,17,216,8,24,4,24,0,152,1,200,0,128 },
  { 0,0,0,0,0,0,255,255,1,152,1,152,1,152,1,152,7,152,3,152,1,152,0,152,0,24,0,152,1,200,0,128 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,0,24,3,248,17,152,8,216,8,216,7,152,0,24,0,152,1,200,0,128 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,3,248,6,0,6,0,3,240,0,24,4,24,3,240,0,0,0,192,0,192 },
  { 0,0,0,0,0,0,255,255,0,96,0,96,7,224,12,0,24,224,25,144,25,16,13,48,7,224,0,0,1,128,1,128 },
  { 0,0,0,0,0,0,255,255,49,128,49,128,49,128,49,240,49,200,19,132,15,132,1,132,1,140,9,140,28,128,8,0 },
  { 0,0,0,0,0,0,255,255,3,24,3,24,3,24,3,24,6,24,4,56,4,120,3,216,0,24,1,24,3,136,1,0 },
  { 0,0,0,0,0,0,255,255,3,0,3,0,51,24,75,40,7,240,15,24,51,8,67,24,3,48,3,28,1,16,0,14 },
  { 0,0,0,0,0,0,255,255,0,32,0,32,30,112,49,152,49,152,16,48,8,96,4,192,0,60,0,192,0,192,0,60 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,128,9,32,8,32,4,64,0,48,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,128,9,32,8,64,4,48,0,64,0,48 },
  { 0,0,0,0,0,0,1,0,1,128,1,128,1,128,1,128,1,128,1,128,1,128,1,128,1,128,1,128,0,128,0,0 },
  { 0,0,0,0,0,0,2,64,3,96,3,96,3,96,3,96,3,96,3,96,3,96,3,96,3,96,3,96,1,32,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,192,4,224,12,112,12,48,14,48,7,32,3,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,7,64,6,96,6,96,2,96,1,224,0,192,1,128,3,0,1,0,0,128,0,64,0,32 },
  { 0,0,0,0,0,0,15,192,14,32,0,16,0,16,0,16,0,48,3,96,2,192,3,128,0,64,0,32,0,16,0,8 },
  { 0,0,0,0,0,0,15,192,14,32,0,32,0,32,3,192,0,32,0,16,3,48,2,224,3,192,0,64,0,32,0,16 },
  { 0,0,0,0,0,0,32,4,16,12,8,24,4,48,2,96,1,192,1,128,3,64,2,96,2,96,2,96,1,192,0,0 },
  { 0,0,0,0,0,0,12,0,12,48,12,48,4,48,3,224,0,192,0,192,6,128,5,128,7,128,0,64,0,32,0,16 },
  { 0,0,0,0,0,0,3,192,12,0,8,0,12,0,7,192,1,0,2,0,2,48,3,48,0,240,0,64,0,64,0,32 },
  { 0,0,0,0,0,0,16,0,16,224,17,216,17,136,8,140,8,124,8,4,4,4,4,8,3,24,0,224,0,0,0,0 },
  { 0,0,0,0,0,0,31,248,4,0,8,0,16,0,16,0,16,96,16,240,15,144,7,16,0,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,6,64,6,32,6,16,2,0,3,128,4,128,12,0,12,0,12,0,2,0,1,240,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,192,2,32,2,32,1,192,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,0,0,144,0,96,28,255,34,96,2,96,6,96,28,96,4,96,67,224,67,96,39,96,30,96,0,96,0,32,0,0 },
  { 0,96,0,96,0,96,28,255,34,96,2,96,6,96,28,96,4,96,67,224,67,96,39,96,30,96,0,96,0,32,0,0 },
  { 0,6,0,6,0,6,28,255,34,102,2,102,6,102,28,102,4,102,67,230,67,102,39,102,30,102,0,102,0,34,0,0 },
  { 0,64,0,60,1,2,28,251,34,6,2,62,6,102,28,102,4,102,67,230,67,102,39,102,30,102,0,102,0,34,0,0 },
  { 1,0,0,144,0,96,28,255,34,96,2,96,6,96,28,96,4,96,67,224,67,96,39,96,30,96,0,32,16,128,15,0 },
  { 1,0,0,144,0,96,28,255,34,96,2,96,6,96,28,96,4,96,67,224,39,96,30,96,16,224,15,0,32,64,31,128 },
  { 0,0,0,0,0,0,255,255,24,0,24,0,24,0,63,224,56,112,0,48,0,48,0,48,0,48,0,96,0,64,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,0,24,3,248,17,152,8,216,8,216,7,152,0,24,8,152,2,8,0,0 },
  { 0,0,0,0,0,0,255,255,3,24,3,24,3,24,3,152,6,88,4,56,4,120,3,216,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,1,152,1,152,1,152,1,152,7,152,3,152,1,152,0,152,0,24,0,24,15,248,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,0,24,3,248,17,152,8,216,8,216,7,152,0,24,0,24,31,248,0,0 },
  { 0,0,0,0,0,0,7,192,14,32,12,16,0,16,0,16,0,48,3,224,3,192,3,0,3,0,3,0,3,0,1,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,3,248,6,0,6,0,3,240,0,24,4,24,2,24,1,240,0,0,15,254 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,7,216,14,120,13,24,12,152,12,120,7,248,0,24,0,24,15,248,0,0 },
  { 0,0,0,0,0,0,7,128,13,192,24,96,48,96,48,96,22,96,14,96,0,96,0,96,0,104,0,104,0,48,0,0 },
  { 0,0,1,128,5,160,4,32,3,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,18,0,12,0,0,0,24,0,12,0,6,0,1,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,18,0,12,0,0,0,12,0,18,0,12,0,0,0,0,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,115,182,109,182,115,134,109,246,115,246,127,254,0,0 },
  { 0,0,0,0,0,0,255,255,0,12,64,12,67,140,71,204,71,236,99,44,32,108,48,124,24,220,15,140,0,4,0,0 },
  { 0,0,0,0,0,6,255,247,0,110,64,102,70,102,79,102,79,102,69,102,65,102,97,102,51,230,30,102,0,34,0,0 },
  { 32,0,31,192,0,32,255,255,0,0,15,192,24,96,60,48,60,48,24,48,0,96,63,192,7,0,1,192,0,124,0,0 },
  { 32,0,31,240,0,8,255,255,30,0,63,12,59,30,25,56,1,248,1,240,3,144,79,16,60,16,16,24,0,14,0,0 },
  { 16,0,15,224,0,16,255,255,3,0,3,0,67,0,67,16,67,56,99,108,33,204,48,12,24,12,14,24,3,240,0,0 },
  { 16,0,15,224,0,16,255,255,3,0,3,0,83,0,83,16,83,56,83,108,73,204,40,12,36,12,18,24,15,240,0,0 },
  { 0,0,32,0,114,0,115,103,66,230,60,230,1,230,7,102,60,102,48,118,60,126,7,110,1,230,0,230,0,34,0,0 },
  { 0,0,32,0,64,0,64,0,32,0,63,224,15,248,0,28,7,134,12,70,28,38,28,38,28,38,8,108,1,248,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,115,142,109,182,115,182,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,115,134,109,190,115,142,109,190,115,134,127,254,0,0 },
  { 0,0,0,0,0,24,0,124,0,198,1,134,67,198,67,198,65,134,64,6,96,6,32,54,48,78,25,134,7,2,0,0 },
  { 0,4,0,8,0,8,0,108,1,246,3,26,70,26,79,26,79,26,70,28,96,24,32,216,49,56,30,24,12,8,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,115,238,109,206,113,238,125,238,115,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,115,134,109,246,113,134,125,190,115,134,127,254,0,0 },
  { 0,0,0,0,0,120,1,140,3,6,7,6,71,6,67,60,96,124,32,60,48,6,24,6,12,6,6,12,3,248,0,0 },
  { 0,4,0,8,0,8,3,236,4,54,14,26,14,26,78,26,68,242,65,252,96,240,32,24,48,24,24,56,15,240,0,0 },
  { 0,0,0,0,0,0,255,255,0,96,0,96,1,248,7,100,60,98,48,98,60,110,7,108,1,224,0,224,0,32,0,0 },
  { 0,0,0,0,16,0,56,143,56,204,49,76,30,76,0,76,1,140,30,12,31,140,0,108,0,28,0,12,0,4,0,0 },
  { 0,0,0,0,0,0,15,159,28,88,56,56,56,24,63,24,17,152,1,152,1,152,7,24,30,24,8,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,24,24,48,24,56,24,31,152,1,152,6,24,12,24,31,24,1,216,0,56,0,8,0,0 },
  { 0,0,0,0,8,0,8,240,5,144,3,16,3,224,35,0,34,8,34,28,49,236,16,12,24,12,12,24,7,224,0,0 },
  { 0,0,0,0,0,0,255,255,24,0,24,0,28,0,27,0,24,252,24,12,24,12,24,12,24,24,28,48,15,192,0,0 },
  { 0,0,0,0,0,0,255,255,24,0,24,0,28,0,27,224,24,56,24,104,28,200,15,16,0,96,1,248,0,14,0,0 },
  { 0,0,0,0,0,0,255,255,1,240,3,28,70,15,76,2,76,196,79,36,102,44,32,44,48,100,24,196,15,131,0,0 },
  { 0,0,0,0,0,0,255,231,0,102,0,102,1,230,7,102,60,102,48,102,60,102,7,126,1,238,0,230,0,34,0,0 },
  { 0,0,0,0,3,128,6,192,12,216,24,252,28,230,92,198,72,220,64,198,96,230,99,252,55,216,60,192,24,64,0,0 },
  { 16,0,15,192,0,32,255,255,24,0,24,0,24,0,24,96,24,240,24,112,24,48,24,96,24,192,15,128,7,0,0,0 },
  { 16,0,15,0,0,128,255,255,0,128,0,128,0,192,1,192,1,96,35,48,58,24,20,24,24,24,12,48,7,224,0,0 },
  { 0,0,0,0,0,0,255,255,3,0,3,0,67,0,67,16,67,56,99,108,33,204,48,12,24,12,14,24,3,240,0,0 },
  { 0,0,0,0,0,0,255,255,24,0,24,0,24,0,24,96,24,240,24,112,24,48,24,96,24,192,15,128,7,0,0,0 },
  { 0,0,0,0,3,140,7,207,12,44,24,28,24,28,28,12,28,12,8,12,0,12,0,12,0,12,0,12,0,4,0,0 },
  { 0,0,0,0,0,0,255,255,0,0,65,248,67,12,67,132,67,134,99,134,33,6,48,6,24,12,12,28,7,240,0,0 },
  { 0,0,0,0,30,0,49,31,120,152,120,152,48,152,0,152,3,24,60,24,63,24,0,216,0,56,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,12,0,12,0,12,120,12,240,13,224,13,96,15,96,14,96,14,96,12,48,8,28,0,0 },
  { 0,0,0,0,6,0,15,15,14,12,8,12,6,60,1,236,3,140,14,12,15,140,0,236,0,60,0,28,0,4,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,0,24,0,24,30,24,63,152,60,216,56,120,0,56,0,24,0,8,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,97,206,109,182,97,198,109,246,109,206,127,254,0,0 },
  { 0,0,0,0,7,24,15,223,24,120,48,56,120,120,77,216,7,24,12,24,16,24,0,24,0,24,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,16,0,56,120,12,100,6,98,12,98,24,110,48,108,63,96,1,224,0,96,0,32,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,0,120,3,216,7,24,28,24,31,24,1,216,0,120,0,56,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,0,0,66,16,71,8,71,12,70,20,99,230,32,6,48,6,24,12,12,28,7,240,0,0 },
  { 0,0,0,0,0,0,255,255,12,24,28,24,14,24,3,24,3,24,3,24,15,216,30,120,12,56,0,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,8,48,28,48,6,48,3,48,6,48,12,48,24,48,31,176,0,240,0,48,0,16,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,120,3,216,7,24,28,24,31,24,1,216,2,120,7,56,7,24,2,8,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,238,109,206,99,238,109,238,99,198,127,254,0,0 },
  { 0,0,0,0,0,0,255,255,0,6,0,6,28,22,62,62,99,102,65,198,65,198,64,134,124,6,60,6,24,2,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,142,109,246,99,198,109,246,99,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,182,109,182,99,134,109,246,99,246,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,134,109,190,99,134,109,246,99,134,127,254,0,0 },
  { 0,0,0,0,56,102,124,247,71,158,71,142,15,198,31,230,12,198,0,6,0,6,0,6,0,6,0,6,0,2,0,0 },
  { 0,0,0,0,0,0,255,255,28,24,14,24,7,152,1,216,6,120,28,24,31,24,1,216,0,120,0,56,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,16,12,56,12,28,12,6,12,2,204,1,236,3,28,102,12,60,12,24,12,0,4,0,0 },
  { 0,0,0,0,0,0,255,255,0,0,15,192,24,96,60,48,60,48,24,48,0,96,63,192,7,0,1,192,0,124,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,134,109,182,99,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,142,109,182,99,142,109,182,99,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,1,128,0,0 },
  { 0,0,0,0,0,0,240,0,8,0,15,192,28,96,60,48,60,48,24,48,0,96,63,192,7,0,1,192,0,124,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,0,23,0,14,0,6,0,6,0,6,0,6,0,6,0,6,0,2,0,0 },
  { 0,0,15,128,63,224,96,16,96,8,32,0,248,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,16,0,0,0 },
  { 0,0,3,240,4,24,8,12,11,228,4,20,0,31,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,4,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,3,64,4,128,3,64,0,32 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,2,0,1,192,0,32,0,16 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,3,0,4,0,3,0,0,192 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,2,0,1,128,2,0,1,0,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,113,134,111,190,111,134,111,246,113,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,113,206,111,190,111,142,111,182,113,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,248,0,24,0,48,0,96,0,64,0,64,0,64,0,88,0,56,0,0,0 },
  { 0,0,0,0,0,0,128,0,112,0,8,0,248,0,24,0,48,0,96,0,64,0,64,0,64,0,88,0,56,0,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,113,206,111,182,111,198,111,246,113,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,113,134,111,182,111,134,111,182,113,182,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,248,23,24,14,48,6,96,6,64,6,64,6,64,6,88,6,56,2,0,0 },
  { 0,0,0,0,0,128,0,112,0,8,0,4,248,23,24,14,48,6,96,6,64,6,64,6,64,6,88,6,56,2,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,192,0,32,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,5,192,12,192,14,192,13,128,12,0,6,0,3,128,0,192,0,96,0,48,0,16,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,113,134,111,190,111,142,111,190,113,190,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,206,109,182,109,182,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,238,109,206,109,238,109,238,99,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,134,109,246,109,134,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,142,109,246,109,198,109,246,99,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,182,109,182,109,134,109,246,99,246,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,134,109,190,109,134,109,246,99,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,206,109,190,109,142,109,182,99,206,127,254,0,0 },
  { 0,0,0,0,0,128,0,112,0,8,0,4,0,23,0,14,0,6,0,6,0,6,0,6,0,6,0,6,0,2,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,206,109,182,109,206,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,206,109,182,109,198,109,246,99,206,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,134,109,182,109,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,142,109,182,109,142,109,182,99,142,127,254,0,0 },
  { 0,0,0,0,0,0,255,255,3,0,67,16,67,56,99,108,35,204,49,140,24,12,14,24,3,240,0,0,0,192,0,192 },
  { 0,0,0,0,0,0,255,255,12,0,12,0,12,0,12,48,12,120,12,56,12,48,7,224,3,192,0,0,1,128,1,128 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,99,134,109,190,109,142,109,190,99,134,127,254,0,0 },
  { 0,0,0,0,0,0,255,255,4,24,14,24,3,24,1,152,3,24,6,24,12,24,15,216,0,120,1,24,3,136,1,0 },
  { 0,0,32,0,114,0,115,103,66,230,60,230,1,230,7,102,60,102,48,118,60,126,7,110,61,230,48,230,60,34,7,0 },
  { 0,0,8,0,7,192,0,48,7,144,12,80,12,208,9,224,8,0,7,192,0,48,7,144,12,80,12,208,9,224,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,224,0,16,3,144,6,80,6,224,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,3,130,0,82,2,106,5,108,5,128,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,97,182,111,182,99,134,111,246,97,246,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,97,134,111,190,99,134,111,246,97,134,127,254,0,0 },
  { 0,0,0,0,0,0,3,192,7,224,12,48,24,24,24,24,24,24,24,24,24,24,12,48,7,224,3,192,0,0,0,0 },
  { 0,0,0,0,4,0,4,0,6,0,3,128,0,224,0,48,0,24,6,24,14,24,14,24,12,48,7,224,0,0,0,0 },
  { 0,0,0,0,0,0,28,0,7,0,1,192,0,96,0,96,28,96,15,192,3,128,0,192,0,48,0,8,0,0,0,0 },
  { 0,0,0,0,0,0,32,240,33,24,34,12,35,12,35,140,35,140,33,140,16,12,16,24,8,24,4,112,3,192,0,0 },
  { 0,0,0,0,7,192,15,224,24,48,16,16,24,48,12,96,7,192,24,48,48,24,48,24,56,56,31,240,7,192,0,0 },
  { 0,0,0,0,1,192,7,128,14,88,28,48,24,96,48,192,49,128,49,128,49,128,49,128,24,216,12,48,7,224,0,0 },
  { 0,0,0,0,0,0,7,0,3,0,3,0,35,0,35,24,35,40,35,108,49,204,16,12,24,12,12,24,7,240,0,0 },
  { 0,0,0,0,3,192,7,224,12,48,12,48,12,112,7,240,3,176,0,48,0,48,0,48,0,48,0,48,0,24,0,0 },
  { 0,0,0,0,112,0,48,0,48,0,48,4,51,248,63,224,56,48,48,48,48,48,48,48,56,96,31,192,15,0,0,0 },
  { 0,0,32,0,32,0,24,0,15,0,3,192,0,240,0,56,0,12,15,12,16,140,56,76,56,76,56,88,16,112,0,64 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,0,120,3,216,7,152,28,120,31,24,1,216,0,120,0,56,0,8,0,0 },
  { 0,0,0,0,0,0,255,255,0,24,0,24,0,120,3,216,7,24,28,24,31,24,1,216,28,120,7,56,1,136,0,64 },
  { 0,0,0,0,0,0,28,0,31,0,15,128,1,192,0,96,0,32,0,16,0,16,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,24,0,60,0,102,0,6,0,15,248,6,0,6,48,6,120,6,120,6,24,6,48,3,224,1,192,0,0 },
  { 0,0,0,0,0,0,0,0,0,16,0,16,0,32,0,96,1,192,15,128,31,0,28,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,14,4,31,4,56,136,60,152,60,176,24,176,1,224,3,192,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,4,0,4,0,4,14,4,31,4,31,132,15,132,1,140,3,24,62,56,48,112,31,224,7,128,0,0 },
  { 0,0,0,0,0,128,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,64,0,0 },
  { 0,0,0,0,56,0,24,0,24,48,24,112,24,240,24,176,25,176,27,48,30,48,28,48,24,48,0,48,0,24,0,0 },
  { 0,0,0,0,0,0,3,224,7,240,12,24,24,12,24,12,24,12,24,12,12,24,7,240,3,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,2,67,132,67,132,33,8,48,24,24,48,15,224,7,128,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,4,0,4,0,2,0,1,0,0,128,0,64,0,32 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,115,206,109,182,109,198,109,246,115,206,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,206,109,182,109,182,109,182,115,206,127,254,0,0 },
  { 2,160,2,32,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,5,0,2,0,0,0,2,0,5,0,2,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,182,109,182,109,134,109,246,115,246,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,192,7,32,4,19,4,20,156,56,100,48,196,32,196,0,132,0,4,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,192,63,32,36,16,36,22,100,57,160,51,32,35,32,2,32,0,32,0,0,0,0,0,0 },
  { 60,0,66,0,66,0,64,0,255,255,68,4,68,4,66,4,65,252,66,0,68,0,66,4,65,248,0,0,0,0,0,0 },
  { 0,120,0,132,0,132,0,4,255,254,64,68,64,68,32,68,31,196,32,4,64,4,32,68,31,132,0,0,0,0,0,0 },
  { 7,192,8,32,16,16,32,8,255,255,32,8,32,8,32,16,63,224,16,16,8,16,4,32,3,192,0,0,8,16,7,224 },
  { 7,192,8,32,16,16,32,8,255,255,32,8,32,16,63,224,16,16,8,16,4,32,3,192,8,16,7,224,8,16,7,224 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,142,109,182,109,142,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,198,109,190,109,190,109,190,115,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,142,109,182,109,182,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,134,109,190,109,142,109,190,115,134,127,254,0,0 },
  { 0,192,0,32,0,16,0,16,255,255,16,16,16,16,8,16,7,240,8,0,16,0,8,0,7,240,0,0,0,0,0,0 },
  { 0,240,0,8,0,244,0,12,192,31,32,4,19,4,20,156,56,100,48,196,32,196,0,132,0,4,0,4,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,123,238,115,206,123,238,123,238,113,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,123,134,115,246,123,134,123,190,113,134,127,254,0,0 },
  { 7,240,8,0,16,0,32,0,255,255,32,8,32,8,32,16,63,224,16,16,8,16,4,32,3,192,0,0,0,0,0,0 },
  { 2,0,1,240,0,72,0,72,192,31,32,4,19,4,20,156,56,100,48,196,32,196,0,132,0,4,0,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,16,0,16,15,16,16,160,32,96,32,96,32,144,17,16,14,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,240,31,16,16,8,16,15,240,16,16,32,16,16,48,15,208,0,16,0,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,144,0,144,0,144,31,144,32,144,32,144,16,144,9,16,6,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,241,31,17,16,9,16,9,16,17,16,33,16,17,48,14,208,0,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,16,0,16,0,31,192,0,32,3,160,4,64,4,160,3,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,32,0,32,24,32,31,224,8,32,8,32,4,32,3,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,16,0,16,31,240,32,0,31,240,33,8,33,8,31,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,16,0,16,24,16,31,240,8,16,8,16,8,16,8,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,12,48,2,64,15,224,16,16,38,8,7,240,1,0,0,128,0,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,32,16,32,16,31,240,32,0,32,0,31,240,4,0,3,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,64,0,64,1,192,2,0,4,0,8,0,4,16,3,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,1,0,1,0,2,128,4,64,8,32,16,16,16,16,8,32,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,8,0,8,3,240,0,16,0,16,31,8,32,136,16,112,15,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,16,0,16,24,16,31,240,8,0,8,0,9,224,10,16,4,32,3,192,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,255,255,1,0,0,192,0,96,15,80,16,192,32,0,16,16,8,32,7,192,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,16,0,16,7,160,7,224,0,48,32,16,48,16,12,32,3,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,16,16,8,16,15,240,16,16,48,16,12,48,3,208,0,16,0,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,32,0,32,48,32,63,224,16,0,16,0,8,0,4,16,3,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,8,16,4,16,4,16,8,16,16,16,8,16,6,112,1,144,0,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,1,0,1,0,2,128,4,64,8,32,16,16,16,16,8,32,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,206,125,182,97,198,111,246,97,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,248,31,8,16,4,16,4,16,8,16,16,16,8,16,6,112,1,144,0,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,16,0,16,31,240,32,0,32,0,33,224,18,16,12,32,3,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,8,16,4,16,7,240,8,16,16,16,8,16,6,112,1,144,0,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,16,0,16,3,208,4,48,3,200,0,8,16,16,8,32,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,240,31,8,16,8,16,8,16,15,240,24,16,24,16,0,16,1,144,1,144,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,8,16,4,16,4,16,8,240,16,144,8,144,4,144,3,144,0,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,16,0,16,7,240,8,16,8,16,8,16,4,16,2,16,1,224,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,238,125,206,113,238,125,238,99,198,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,8,32,8,32,4,64,10,160,17,16,16,16,8,32,4,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,8,32,8,32,4,64,10,160,17,16,16,16,8,32,4,76,0,12,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,182,125,182,113,134,125,246,99,246,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,16,0,16,31,240,32,0,48,0,15,240,4,0,3,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,8,16,8,16,8,16,15,240,24,16,24,16,0,16,1,144,1,144,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,134,125,246,113,238,125,222,99,222,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,8,16,8,16,8,16,15,240,24,16,24,16,0,16,0,16,0,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,16,0,16,7,16,8,16,8,16,8,16,4,16,2,16,1,224,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,134,125,182,113,134,125,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,142,125,182,113,142,125,182,99,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,1,128 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,142,125,182,113,182,125,182,99,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,31,0,4,0,4,0,4,0,4,0,4,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 120,0,132,0,132,0,132,0,224,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,0,0 },
  { 0,120,0,132,0,132,0,132,0,31,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,32,7,192,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,32,7,192,8,32,7,192 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,109,142,109,246,97,198,125,246,125,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,109,182,109,182,97,134,125,246,125,246,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,109,134,109,190,97,134,125,246,125,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,109,206,109,190,97,142,125,182,125,206,127,254,0,0 },
  { 0,0,0,224,0,16,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,224,0,16,0,248,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,109,206,109,182,97,198,125,246,125,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,109,134,109,182,97,134,125,182,125,182,127,254,0,0 },
  { 2,0,1,240,0,8,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 2,0,1,240,0,72,0,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,4,0,2 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,109,134,109,190,97,142,125,190,125,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,109,134,109,190,97,142,125,190,125,190,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,206,111,182,97,182,125,182,97,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,6,0,1,128 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,111,246,97,134,125,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,142,111,246,97,198,125,246,97,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,182,111,182,97,134,125,246,97,246,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,111,190,97,134,125,246,97,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,206,111,190,97,142,125,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,111,246,97,238,125,222,97,222,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,206,111,182,97,206,125,182,97,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,248,31,8,16,4,16,7,240,8,16,16,16,8,16,6,112,1,144,24,16,24,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,144,0,144,15,144,16,144,16,144,16,144,8,144,4,144,3,16,24,0,24,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,16,0,16,24,16,31,240,8,16,8,16,8,16,8,16,9,144,1,128,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,32,0,32,0,32,7,224,0,16,0,16,16,32,8,64,7,192,4,32,2,16 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,142,111,182,97,182,125,182,97,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,0,16,0,16,31,240,32,0,32,0,33,224,18,16,12,32,99,192,96,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,111,190,97,142,125,190,97,190,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,206,111,182,99,182,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,238,111,206,99,238,109,238,115,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,134,111,246,99,134,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,142,111,246,99,198,109,246,115,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,182,111,182,99,134,109,246,115,246,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,134,111,190,99,134,109,246,115,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,7,128,8,64,16,32,32,16,32,16,32,16,16,32,8,64,7,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,0,8,128,8,64,8,192,7,64,0,64,0,64,0,64,0,64,0,48,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,0,32,0,16,0,16,0,32,15,192,0,64,0,32,0,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,128,0,64,0,32,0,64,31,128,0,64,0,32,48,64,63,128,8,0,4,0,2,0 },
  { 0,0,0,0,0,0,0,0,4,64,8,32,8,32,4,64,3,128,4,64,8,32,8,32,4,64,3,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,60,16,32,8,32,8,32,16,32,32,32,16,32,12,224,3,32,0,32,0,0,0,0 },
  { 0,224,1,0,1,0,0,192,3,240,4,48,8,0,4,0,3,240,4,0,8,0,4,8,3,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,4,32,8,16,8,16,6,16,0,32,0,64,0,128,3,0,4,0,0,0,0,0 },
  { 0,0,0,0,0,0,48,0,63,240,16,0,16,0,16,0,16,0,16,0,8,0,4,0,3,240,0,0,0,0,0,0 },
  { 0,96,0,128,0,128,48,96,63,240,16,48,16,0,16,0,16,0,16,0,8,0,4,0,3,240,0,0,0,0,0,0 },
  { 3,192,4,32,2,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 4,32,4,32,3,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,255,255,16,16,16,16,8,16,7,240,8,0,16,0,8,16,4,32,3,192,0,0,0,0 },
  { 7,224,8,16,16,8,32,8,255,255,32,8,32,8,32,16,63,224,16,16,8,16,4,32,3,192,0,0,0,0,0,0 },
  { 0,0,0,0,24,4,36,248,37,12,29,146,11,66,20,130,40,12,40,2,40,2,36,4,18,8,9,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,64,1,128 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,206,125,190,123,142,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,125,246,123,238,119,222,119,222,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,206,125,182,123,206,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,206,125,182,123,198,119,246,119,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,125,182,123,134,119,182,119,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,142,125,182,123,142,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,198,125,190,123,190,119,190,119,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,142,125,182,123,182,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,125,190,123,142,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,125,190,123,142,119,190,119,190,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,206,109,182,115,182,109,182,115,206,127,254,0,0 },
  { 2,160,2,32,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,0,0,0,0,0,3,0,3,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,182,109,182,115,134,109,246,115,246,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,120,8,4,8,4,136,56,248,16,72,8,136,7,10,0,4,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,240,34,8,34,9,34,113,226,32,162,17,34,14,42,0,17,0,0,0,0,0,0,0,0 },
  { 0,0,0,24,0,32,0,32,3,160,4,32,4,32,4,32,3,32,4,32,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,48,0,72,0,72,7,64,8,64,8,64,8,64,6,64,8,64,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,3,192,4,32,8,16,9,192,8,32,8,32,8,32,8,192,4,32,2,32,1,192,0,0,0,0,0,0,0,0 },
  { 0,0,15,0,16,128,32,64,39,32,32,144,32,144,32,144,35,16,16,144,8,148,7,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,57,16,5,40,3,40,1,24,3,228,5,2,9,66,16,132,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,32,15,112,16,136,32,132,32,24,16,32,12,32,0,28,0,0,0,0,0,0,0,0 },
  { 0,64,0,32,0,24,0,0,120,8,4,8,4,136,56,248,16,72,8,136,7,10,0,4,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,134,109,190,115,142,109,190,115,134,127,254,0,0 },
  { 0,0,0,96,0,16,0,8,120,8,4,8,4,136,56,248,16,72,8,136,7,10,0,4,0,0,0,0,0,0,0,0 },
  { 0,224,0,24,0,248,0,8,120,8,4,8,4,136,56,248,16,72,8,136,7,10,0,4,0,0,0,0,0,0,0,0 },
  { 0,16,0,8,0,6,0,0,240,34,8,34,9,34,113,226,32,162,17,34,14,42,0,17,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,115,134,109,246,113,134,125,190,115,134,127,254,0,0 },
  { 0,0,0,24,0,4,0,2,240,34,8,34,9,34,113,226,32,162,17,34,14,42,0,17,0,0,0,0,0,0,0,0 },
  { 0,56,0,6,0,62,0,2,240,34,8,34,9,34,113,226,32,162,17,34,14,42,0,17,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,128,2,0,2,64,1,128,1,128,2,64,8,64,7,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,64,80,64,18,64,19,192,12,64,0,64,0,80,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,32,18,32,1,32,1,32,18,32,12,32,0,40,0,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,144,4,16,4,16,4,16,3,16,4,48,4,84,3,136,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,0,1,0,2,96,4,96,2,0,33,0,17,0,14,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,60,16,2,16,2,16,28,16,8,48,4,80,3,148,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,192,33,32,33,32,33,32,24,160,32,64,32,128,31,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,14,16,17,32,40,192,72,128,73,64,49,32,1,32,0,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,64,18,64,1,64,1,224,18,16,12,16,0,16,0,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,32,18,32,1,32,1,224,18,32,12,32,0,40,0,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,56,0,4,0,4,0,24,0,32,0,64,0,68,0,56,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,128,2,0,2,0,1,0,7,0,8,128,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,0,1,0,2,0,4,0,2,0,33,0,17,0,14,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,0,2,0,12,0,16,192,33,32,33,32,16,192,15,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,76,64,82,64,65,64,65,64,82,64,76,64,64,80,64,32,32,0,16,0,8,0,16,0 },
  { 0,0,0,0,0,0,0,0,0,64,0,64,3,192,4,64,8,64,8,64,4,80,2,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,64,18,64,10,64,4,64,8,192,7,64,0,80,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,4,0,4,0,4,0,3,0,4,0,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,6,0,8,0,8,0,6,64,8,64,8,192,7,64,0,64,0,64,0,80,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,128,0,128,0,128,31,128,24,128,0,128,0,160,0,64,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,206,109,182,97,198,109,246,109,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,16,64,40,64,8,64,8,192,7,64,0,64,0,80,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,128,2,0,2,64,1,128,1,128,2,64,24,64,31,128,4,0,2,0,1,128,0,0 },
  { 0,0,0,0,0,0,0,0,8,8,16,8,32,136,32,248,17,8,14,8,0,10,0,4,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,8,8,136,16,136,16,248,16,8,8,8,4,10,0,4,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,32,2,32,2,32,3,224,0,32,0,32,0,40,0,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,32,2,32,4,32,8,32,4,96,3,160,0,40,0,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,30,0,1,0,1,0,14,0,4,0,2,0,1,192,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,238,109,206,99,238,109,238,99,198,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,12,128,16,128,32,128,39,128,32,128,16,128,12,160,0,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,33,128,34,64,34,64,34,64,28,64,0,64,0,80,0,32,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,182,109,182,99,134,109,246,99,246,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,64,8,192,8,64,8,192,7,64,0,64,0,80,0,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,32,18,32,18,32,12,32,4,32,24,32,8,40,7,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,64,10,64,9,64,8,192,7,64,0,64,0,80,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,60,32,2,32,3,224,28,32,8,32,4,32,3,40,0,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,33,0,34,0,33,0,32,128,36,128,35,32,16,32,15,192,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,134,109,182,99,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,142,109,182,99,142,109,182,99,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,1,128 },
  { 0,0,0,0,0,0,0,0,56,0,64,0,64,0,48,0,8,0,4,0,68,0,56,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,0,4,0,4,0,4,0,4,0,4,0,5,0,2,0,0,0,0,0,0,0,0 },
  { 96,0,144,0,136,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,160,0,64,0,0,0,0,0,0,0,0,0 },
  { 0,24,0,36,0,36,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,5,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,96,1,16,0,224 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,192,2,32,1,144 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,192,2,0,1,192 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,2,0,1,128,2,0,1,192 },
  { 0,16,0,8,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,113,206,111,190,111,142,111,182,113,206,127,254,0,0 },
  { 0,0,0,24,0,4,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,56,0,6,0,62,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,32,0,16,0,12,0,0,0,4,0,4,0,4,0,4,0,4,0,4,0,5,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,113,134,111,182,111,134,111,182,113,182,127,254,0,0 },
  { 0,48,0,8,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,5,0,2,0,0,0,0,0,0,0,0 },
  { 0,56,0,4,0,52,0,12,0,4,0,4,0,4,0,4,0,4,0,4,0,5,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,192,0,32,0,16 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,113,134,111,190,111,142,111,190,113,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,113,134,111,190,111,142,111,190,113,190,127,254,0,0 },
  { 0,48,0,48,0,0,0,132,60,120,2,0,2,12,12,18,24,50,4,76,67,128,66,0,60,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,238,109,206,109,238,109,238,99,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,134,109,246,109,134,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,142,109,246,109,198,109,246,99,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,182,109,182,109,134,109,246,99,246,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,134,109,190,109,134,109,246,99,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,206,109,190,109,142,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,134,109,246,109,238,109,222,99,222,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,206,109,182,109,206,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,206,109,182,109,198,109,246,99,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,134,109,182,109,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,142,109,182,109,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,198,109,190,109,190,109,190,99,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,142,109,182,109,182,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,134,109,190,109,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,99,134,109,190,109,142,109,190,99,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,114,32,10,80,6,80,2,48,7,220,10,16,18,146,33,12,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,32,15,112,16,136,32,132,32,24,16,32,12,32,0,28,0,32,0,32,0,28,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,96,4,144,4,32,0,24 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,96,4,144,4,36,0,26,0,12 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,182,111,182,99,134,111,246,97,246,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,111,190,99,134,111,246,97,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,7,128,8,64,16,32,32,16,32,16,32,16,16,32,8,64,7,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,0,8,128,8,64,8,192,7,64,0,64,0,64,0,64,0,64,0,48,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,0,32,0,16,0,16,12,32,15,192,2,0,1,0,0,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,192,0,32,0,16,0,32,3,192,16,32,8,16,4,32,3,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,8,2,16,1,32,0,192,0,192,1,32,2,32,2,32,2,32,1,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,64,40,64,8,64,8,192,7,64,0,64,0,80,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,0,8,0,16,0,8,0,7,224,4,0,8,0,4,0,3,240,0,8,0,8,0,112 },
  { 0,0,0,0,0,0,0,0,3,192,4,96,8,144,9,16,6,16,32,16,32,16,32,32,16,64,15,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,128,1,0,2,0,4,0,8,0,16,0,16,0,16,0,8,64,7,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,0,16,64,32,128,33,0,34,0,32,0,16,0,15,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,36,0,36,0,24,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,0,2,0,1,0,2,0,28,28,2,34,1,34,50,34,60,28,8,0,4,0,3,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,111,246,99,134,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,142,111,246,99,198,111,246,111,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,182,111,182,99,134,111,246,111,246,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,111,190,99,134,111,246,111,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,182,109,134,109,182,115,182,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,206,109,182,109,182,109,182,115,206,127,254,0,0 },
  { 2,160,2,32,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,2,0,5,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,2,0,5,0,5,0,2,0,5,0,5,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,182,109,182,109,134,109,246,115,246,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,54,16,73,16,73,16,34,16,4,16,8,16,8,48,7,208,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,54,20,73,20,73,20,34,20,4,20,4,20,2,52,1,212,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,128,48,64,64,32,64,32,74,32,53,64,21,64,10,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,4,64,62,32,64,32,74,32,53,64,21,64,10,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,128,48,64,64,32,65,32,82,32,38,64,34,64,28,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,128,48,64,64,64,65,64,82,32,38,16,34,32,28,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,0,24,128,32,128,32,128,44,64,18,32,18,64,12,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,4,64,1,128,2,0,4,192,5,32,3,192,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,142,109,182,109,182,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,134,109,190,109,142,109,190,115,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,2,0,6,0,10,0,66,0,34,0,18,0,10,0,6,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,224,2,16,0,16,1,32,3,32,5,32,33,224,17,32,9,32,5,32,3,32,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,123,238,115,206,123,238,123,238,113,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,123,134,115,246,123,134,123,190,113,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,4,192,9,32,8,32,8,32,8,192,4,32,2,32,1,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,240,1,8,0,8,19,16,36,144,32,144,32,240,35,16,16,144,8,144,7,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,192,48,32,64,16,64,16,73,128,54,64,22,64,10,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,144,5,16,9,48,8,208,8,16,7,16,4,144,3,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,144,4,80,8,48,8,16,8,16,7,16,4,144,3,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,144,4,80,8,48,10,16,12,16,17,16,17,48,14,208,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,0,48,128,64,112,65,72,82,48,38,0,34,0,28,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,4,32,8,16,8,16,8,16,7,32,4,128,3,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,4,32,8,16,11,16,4,128,23,0,10,128,5,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,4,32,8,16,8,0,10,96,4,160,4,160,3,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,160,4,144,9,16,16,224,22,0,9,0,9,128,6,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,19,96,36,144,32,16,31,224,19,96,36,144,32,16,31,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,144,4,80,8,48,8,16,8,0,7,0,4,128,3,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,0,8,128,16,64,16,64,16,64,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,12,32,16,16,16,80,20,144,9,160,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,12,32,16,16,16,16,20,16,9,32,10,128,7,0,2,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,144,4,80,10,48,17,16,28,16,2,16,2,16,12,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,128,48,64,64,32,64,32,83,64,35,0,35,0,28,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,16,9,16,1,16,14,16,16,16,16,16,8,48,7,208,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,128,48,64,64,32,65,32,83,0,35,0,35,0,29,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,16,4,16,2,16,3,16,4,144,4,16,4,48,3,208,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,128,16,64,32,32,32,32,39,32,25,64,13,0,13,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,206,125,182,97,198,111,246,97,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,7,144,8,80,16,48,18,16,12,16,8,16,8,48,7,208,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,176,34,200,65,200,72,176,48,128,32,128,33,128,30,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,128,24,64,32,32,46,32,49,32,17,0,17,128,14,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,128,48,64,64,32,69,32,85,32,35,64,33,64,30,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,144,8,80,16,48,18,16,12,16,16,16,96,16,96,16,0,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,144,8,80,16,48,18,16,12,16,24,16,104,48,103,208,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,4,32,8,16,8,16,8,16,7,32,4,160,3,16,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,238,125,206,113,238,125,238,99,198,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,31,192,32,32,64,16,64,16,91,16,36,160,36,160,36,144,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,192,32,32,64,16,64,16,91,32,36,128,36,128,36,128,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,182,125,182,113,134,125,246,99,246,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,7,128,24,64,32,32,46,32,49,32,21,0,17,128,14,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,144,8,80,12,48,18,16,16,16,14,16,9,16,6,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,144,12,80,18,48,19,16,12,144,8,80,8,48,7,208,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,144,16,80,32,48,33,16,38,16,30,16,1,144,0,112,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,128,48,64,64,32,65,32,83,0,35,0,35,0,29,0,8,0,6,0,1,128,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,134,125,182,113,134,125,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,142,125,182,113,142,125,182,99,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,1,128 },
  { 0,0,0,0,0,0,0,0,12,0,48,0,64,0,48,0,12,0,48,0,64,0,48,0,12,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,0,0,0,0,0 },
  { 7,240,8,8,8,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,0,24,0,40,0,8,0,8,0,8,0,8,0,8,0,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,7,160,8,192,7,176 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,4,0,4,64,3,176 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,64,4,160,4,32,3,192 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,8,64,6,160,8,32,7,192 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,109,134,109,190,97,134,125,246,125,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,109,206,109,190,97,142,125,182,125,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,96,0,128,0,128,0,128,0,224,0,144,0,144,0,144,0,96,0,0,0,0,0,0,0 },
  { 1,0,0,248,0,4,0,4,96,0,128,0,128,0,128,0,224,0,144,0,144,0,144,0,96,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,109,206,109,182,97,198,125,246,125,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,109,134,109,182,97,134,125,182,125,182,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,96,8,128,8,128,8,128,8,224,8,144,8,144,8,144,8,96,8,0,0,0,0,0,0 },
  { 0,0,0,120,0,132,0,4,96,8,128,8,128,8,128,8,224,8,144,8,144,8,144,8,96,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,64,0,32 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,109,134,109,190,97,142,125,190,125,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,109,134,109,190,97,142,125,190,125,190,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,206,111,182,97,182,125,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,238,111,206,97,238,125,238,97,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,134,111,246,97,134,125,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,142,111,246,97,198,125,246,97,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,182,111,182,97,134,125,246,97,246,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,134,111,190,97,134,125,246,97,134,127,254,0,0 },
  { 1,0,0,248,0,4,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,120,0,132,0,4,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,206,111,182,97,206,125,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,206,111,182,97,198,125,246,97,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,134,111,182,97,134,125,182,97,182,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,142,111,182,97,142,125,182,97,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,12,32,16,16,16,80,20,144,9,160,8,128,7,0,0,0,3,0,3,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,12,32,16,16,16,16,20,16,9,32,10,128,7,0,2,0,1,0,12,0,12,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,134,111,190,97,142,125,190,97,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,7,144,8,80,16,48,18,16,12,16,24,48,104,72,103,156,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,128,24,64,32,192,32,32,44,192,18,32,18,192,12,32,0,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,4,64,1,128,2,0,4,192,5,32,3,192,0,128,0,64,0,32,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,64,1,64,0,152,1,36,0,248 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,64,1,88,0,164,1,56,0,208 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,182,111,182,99,134,109,246,115,246,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,134,111,190,99,134,109,246,115,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,128,4,64,16,16,16,16,16,16,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,4,32,10,16,10,16,9,224,4,0,2,0,1,0,0,192,0,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,4,32,8,80,8,80,7,144,0,32,0,64,0,128,3,0,4,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,14,224,17,16,33,16,41,16,37,16,25,16,1,16,1,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,4,8,2,16,1,32,0,192,0,192,1,32,2,32,2,32,2,32,1,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,192,18,32,10,32,6,64,1,128,2,96,4,80,4,72,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,4,32,3,16,0,144,8,144,7,32,0,64,0,128,3,0,4,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,4,32,9,16,10,144,10,144,7,32,0,64,0,128,3,0,4,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,224,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,32,8,160,8,96,8,0,8,0,8,0,4,0,3,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,16,0,32,12,64,12,128,65,0,34,0,20,0,8,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,9,224,18,16,16,224,8,16,7,240,8,16,8,48,7,208,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,128,8,128,8,128,9,128,6,128,0,128,0,128,0,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,34,32,34,32,34,32,38,96,25,160,0,32,0,32,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,32,0,64,0,128,1,0,2,0,4,0,8,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,32,28,64,42,128,43,0,18,0,4,0,8,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,2,0,4,0,8,0,16,54,32,73,64,73,128,73,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,206,125,182,123,206,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,206,125,182,123,198,119,246,119,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,134,125,182,123,134,119,182,119,182,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,142,125,182,123,142,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,198,125,190,123,190,119,190,119,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,142,125,182,123,182,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,134,125,190,123,142,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,134,125,190,123,142,119,190,119,190,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,206,109,182,115,182,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,238,109,206,115,238,109,238,115,198,127,254,0,0 },
  { 1,0,2,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,128,2,64,2,64,1,128,24,24,36,36,36,36,24,24,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,182,109,182,115,134,109,246,115,246,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,6,16,9,16,9,144,6,144,0,144,31,240,32,144,31,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,64,36,64,38,64,26,64,2,64,127,224,130,80,124,80,1,80,2,16,1,224,0,0 },
  { 0,0,0,0,15,128,16,64,35,32,36,144,36,144,19,80,8,64,31,128,34,64,29,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,224,66,0,90,192,90,192,66,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,60,0,74,0,73,0,49,0,2,0,60,0,64,0,63,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,112,0,152,0,153,248,106,208,9,80,112,80,128,0,127,248,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,142,109,182,115,142,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,198,109,190,115,190,109,190,115,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,142,109,182,115,182,109,182,115,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,7,252,8,16,16,16,28,16,34,16,34,16,34,16,28,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,252,8,16,16,16,28,16,34,16,34,16,34,16,28,16,0,32,0,64,0,128,0,0 },
  { 0,0,0,0,0,0,0,0,62,224,73,16,49,16,0,16,63,224,64,0,66,16,63,224,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,238,109,206,113,238,125,238,115,198,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,31,192,32,32,64,16,64,16,113,208,74,80,74,144,50,96,2,0,17,224,16,64,15,128 },
  { 0,0,0,0,0,0,0,0,31,192,32,32,64,16,64,16,113,208,74,80,74,144,50,96,2,0,49,224,72,64,63,128 },
  { 0,0,0,0,0,0,0,0,60,0,66,0,129,0,129,124,205,168,181,104,185,40,86,0,16,0,143,0,130,0,124,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,224,8,128,8,128,8,128,63,224,64,144,63,32,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,206,109,190,113,142,125,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,134,109,246,113,238,125,222,115,222,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,206,109,182,113,206,125,182,115,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,126,16,72,16,79,16,72,144,72,144,65,16,66,16,79,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,224,8,128,8,128,8,128,63,224,64,128,63,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,142,109,182,113,142,125,182,115,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,62,224,73,16,49,16,0,16,63,224,64,0,67,224,60,16,0,224,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,115,142,109,182,113,182,125,182,115,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,39,224,72,128,144,128,156,160,162,208,162,144,162,144,156,144,128,16,64,32,63,192,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,16,0,16,0,16,0,31,240,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,206,109,182,97,182,109,182,109,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,238,109,206,97,238,109,238,109,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,134,109,246,97,134,109,190,109,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,59,191,68,72,138,168,202,168,170,168,170,168,68,72,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,224,8,128,8,128,8,128,63,224,64,144,63,16,0,16,0,32,63,192,64,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,134,109,190,97,134,109,246,109,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,206,109,190,97,142,109,182,109,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,134,109,246,97,238,109,222,109,222,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,224,8,128,8,128,8,128,8,224,8,144,0,16,0,16,0,32,63,192,64,0 },
  { 0,0,0,0,0,0,0,0,30,252,33,16,66,144,114,144,74,144,74,144,49,16,0,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,128,8,128,8,128,8,128,8,128,15,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,142,109,182,97,142,109,182,109,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,198,109,190,97,190,109,190,109,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,142,109,182,97,182,109,182,109,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,192,17,32,17,32,17,32,31,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,16,18,16,18,16,18,16,15,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,240,8,64,8,64,8,64,8,64,8,64,8,64,8,64,0,64,0,128,1,0,2,0 },
  { 0,0,0,0,0,0,0,0,7,112,8,136,8,136,8,136,8,136,8,136,8,136,8,136,0,16,0,16,15,224,16,0 },
  { 0,0,0,0,0,0,0,0,28,32,34,16,65,16,65,16,113,16,73,16,73,16,48,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,252,35,16,65,16,65,16,113,16,73,16,73,16,49,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,33,192,34,32,34,32,34,32,34,32,34,32,34,32,63,192,2,0,35,192,32,128,31,0 },
  { 0,0,0,0,0,0,0,0,28,16,35,16,64,144,64,144,112,144,72,144,73,16,51,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,143,248,136,136,136,136,136,136,136,136,136,136,136,136,136,136,112,112,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,16,34,40,65,40,65,40,113,16,73,40,74,72,51,240,0,128,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,29,144,34,72,66,72,66,72,114,72,74,72,74,72,50,48,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,56,108,68,146,130,146,130,146,226,146,146,146,148,146,103,146,0,4,0,4,63,248,64,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,134,109,182,99,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,142,109,182,99,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,198,109,190,99,190,109,190,99,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,142,109,182,99,182,109,182,99,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,31,0,18,0,18,0,18,0,18,0,18,0,18,0,18,0,0,0,0,0,0,0,0 },
  { 0,28,0,34,0,34,0,18,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,0,0,0,0,0,0,0 },
  { 1,192,2,32,2,192,1,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,6,96,8,80,8,16,7,224 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,113,142,111,246,111,198,111,246,113,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,113,182,111,182,111,134,111,246,113,246,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,113,134,111,190,111,134,111,246,113,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,48,0,72,0,132,0,132,0,228,0,148,0,148,0,100,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,48,0,72,0,176,0,128,0,128,0,176,0,72,0,48,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,61,128,66,64,135,64,133,64,229,64,149,64,146,64,96,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,113,206,111,182,111,198,111,246,113,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,48,31,72,18,132,18,132,18,228,18,148,18,148,18,100,18,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,48,31,72,18,176,18,128,18,128,18,176,18,72,18,48,18,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,48,31,72,42,132,74,132,202,228,170,148,170,148,170,100,74,0,0,0,0,0,0,0,0 },
  { 3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,113,134,111,190,111,142,111,190,113,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,113,134,111,190,111,142,111,190,113,190,127,254,0,0 },
  { 0,0,0,0,0,0,15,240,48,12,64,2,128,1,128,1,224,29,144,37,148,41,97,38,26,160,39,158,32,4,31,248 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,238,109,206,109,238,109,238,99,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,134,109,246,109,134,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,142,109,246,109,198,109,246,99,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,182,109,182,109,134,109,246,99,246,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,134,109,190,109,134,109,246,99,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,206,109,190,109,142,109,182,99,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,31,0,42,0,74,0,202,0,170,0,170,0,170,0,74,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,206,109,182,109,206,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,206,109,182,109,198,109,246,99,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,134,109,182,109,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,142,109,182,109,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,198,109,190,109,190,109,190,99,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,142,109,182,109,182,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,134,109,190,109,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,99,134,109,190,109,142,109,190,99,190,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,206,111,182,99,182,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,238,111,206,99,238,111,238,97,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,134,111,246,99,134,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,142,111,246,99,198,111,246,97,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,182,111,182,99,134,111,246,97,246,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,134,111,190,99,134,111,246,97,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,1,128,2,64,4,32,4,32,4,32,4,32,2,64,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,224,8,128,8,128,8,128,63,224,64,144,63,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,56,0,68,0,68,0,68,0,56,0,16,0,31,252,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,63,128,34,0,34,0,34,192,35,32,34,32,32,64,35,252,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,228,8,132,8,132,8,132,63,252,64,128,63,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,19,248,34,32,66,32,66,32,66,32,66,56,66,36,66,36,64,4,32,8,31,240,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,224,8,128,8,128,8,128,63,254,64,164,63,36,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,252,8,16,16,16,28,16,34,16,34,16,34,16,28,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,14,0,17,16,16,144,8,80,6,80,63,240,64,80,32,144,31,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,192,9,0,9,0,9,28,63,226,65,50,62,42,0,18,0,0,0,0,0,0 },
  { 0,0,3,128,0,64,0,32,34,32,34,32,34,32,34,32,34,32,34,32,34,32,34,32,29,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,27,248,38,32,34,32,34,32,34,32,34,32,34,32,34,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,224,8,128,8,128,8,128,63,252,64,144,63,120,0,84,0,52,0,4,0,120 },
  { 0,0,0,0,0,0,0,0,28,0,35,0,64,128,64,128,112,128,72,128,73,0,51,240,0,0,0,0,0,0,0,0 },
  { 0,112,0,200,0,174,0,192,33,192,34,32,34,32,34,32,34,32,34,32,34,32,63,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,252,64,2,156,58,162,82,161,84,161,85,177,82,169,88,170,84,147,212,128,4,64,8,63,240,0,0 },
  { 0,0,0,0,0,0,0,0,8,128,8,128,8,128,8,144,8,144,8,144,8,144,7,144,0,144,7,240,8,128,7,0 },
  { 0,0,0,0,0,0,0,0,31,0,36,0,68,0,100,196,149,36,151,148,149,84,100,156,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,62,2,65,5,128,133,131,197,228,162,148,149,148,165,99,62,0,8,0,16,0,0,0,0 },
  { 14,0,17,0,60,128,82,240,76,0,71,224,72,64,72,64,72,64,72,112,72,72,72,72,64,8,32,16,31,224,0,0 },
  { 0,56,0,68,0,242,1,75,1,48,15,128,17,0,17,0,17,0,17,192,17,32,17,32,0,32,0,64,31,128,32,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,142,109,182,115,142,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,1,128,9,144,4,32,3,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,4,0,4,0,4,0,2,0,1,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,9,0,6,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,2,0,5,0,5,0,2,0,0,0,2,0,5,0,5,0,2,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,115,182,109,182,109,134,109,246,115,246,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,18,144,50,72,44,200,32,8,32,8,16,16,15,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,16,18,40,50,40,44,240,32,16,32,16,16,32,15,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,59,128,68,64,68,64,0,64,30,128,33,0,30,128,0,64,0,64,0,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,66,0,36,0,24,96,60,144,66,32,127,224,66,144,60,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,15,224,16,16,32,0,127,248,64,0,64,96,34,144,29,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,5,0,5,0,31,136,32,68,64,8,255,248,128,20,128,136,69,64,59,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,100,144,146,72,18,72,34,72,66,72,130,72,146,72,109,176,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,27,0,36,128,36,128,1,16,2,16,2,16,2,32,1,192,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,115,142,109,182,109,182,109,182,115,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,32,0,16,0,8,0,8,0,8,14,8,19,16,12,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,2,0,4,224,8,16,8,8,0,8,0,8,14,8,19,16,12,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,14,224,17,16,17,8,0,8,0,8,14,8,19,16,12,224,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,123,238,115,206,123,238,123,238,113,198,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,12,0,18,0,18,0,4,0,8,0,16,0,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,0,6,0,9,0,4,0,12,0,18,0,18,0,4,0,8,0,16,0,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,0,63,224,1,80,62,32,12,0,18,0,18,0,4,0,8,0,16,0,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,32,2,64,1,128,1,128,2,64,2,0,1,128,0,64,0,32,8,32,7,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,48,0,72,0,52,128,4,64,4,32,52,32,76,64,55,128,4,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,128,5,0,2,0,5,0,5,0,8,128,8,128,8,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,0,73,48,48,136,0,72,48,72,76,144,55,96,4,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,64,18,64,19,240,4,0,8,0,16,0,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,16,0,32,1,192,1,160,0,16,0,8,120,8,9,8,19,144,12,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,16,0,32,1,192,1,160,0,16,0,8,120,8,9,8,19,144,13,96,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,64,19,32,18,192,4,0,8,0,16,0,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,128,33,0,18,0,12,144,18,72,18,72,18,72,18,72,18,72,18,232,13,80,0,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,27,0,36,128,36,160,0,240,0,128,29,0,34,0,29,0,1,0,1,0,0,0,0,0 },
  { 0,0,0,0,16,0,16,0,24,192,36,32,88,32,64,16,64,16,64,16,34,16,29,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,64,8,128,7,0,8,128,16,64,18,64,16,64,15,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,32,8,64,4,128,15,0,18,0,33,0,64,128,64,0,64,96,34,144,29,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,32,8,64,4,128,15,0,18,0,33,0,64,128,64,0,64,96,34,144,31,224,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,18,144,33,8,32,8,24,8,32,56,34,72,28,48,0,0,0,0,0,0,0,0 },
  { 0,8,1,16,0,160,0,64,12,96,18,144,44,104,32,8,32,8,32,8,16,16,15,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,64,8,128,7,0,8,128,18,64,16,64,18,64,15,128,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,64,8,128,7,0,8,128,16,64,16,64,18,64,13,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,64,8,128,7,0,8,128,16,64,16,64,18,64,15,128,2,0,0,0,0,0,0,0 },
  { 0,128,1,0,26,0,28,0,3,128,0,64,0,32,0,16,24,16,36,16,34,32,17,192,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,206,125,182,97,198,111,246,97,206,127,254,0,0 },
  { 0,64,0,128,9,0,6,0,0,224,0,16,0,8,0,8,0,8,14,8,19,16,12,224,0,0,0,0,0,0,0,0 },
  { 0,64,0,128,9,0,6,0,0,224,0,16,0,8,0,8,0,8,14,8,19,16,13,224,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,48,192,72,32,8,16,16,8,32,8,33,8,18,144,12,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,4,0,8,0,208,48,224,72,32,8,16,16,8,32,8,33,8,18,144,12,96,1,0,0,0,0,0,0,0 },
  { 0,64,0,128,1,0,6,0,7,48,0,136,0,72,0,72,0,72,56,72,76,200,51,48,0,0,0,0,0,0,0,0 },
  { 0,64,0,128,13,0,2,0,1,48,0,136,48,72,72,72,72,72,72,72,76,200,51,48,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,64,8,128,7,0,8,128,16,64,16,64,16,64,15,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,18,144,50,136,47,200,32,8,32,8,16,16,15,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,192,36,32,100,16,88,16,64,16,64,32,32,64,31,128,0,0,0,0,0,0,0,0 },
  { 0,8,0,16,1,160,1,192,0,64,24,32,36,16,44,16,16,32,15,192,9,0,6,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,192,37,32,101,48,88,208,64,16,66,16,34,32,29,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,32,0,64,1,224,1,144,0,8,0,8,0,8,14,8,19,16,12,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,64,0,128,1,0,7,128,6,64,0,32,14,32,17,64,19,128,4,128,3,0,0,0,0,0,0,0,0,0 },
  { 0,64,0,128,9,0,6,0,0,224,0,16,0,8,0,8,0,8,14,8,19,16,12,224,0,16,0,8,0,4,0,0 },
  { 0,64,0,128,5,0,2,0,0,224,0,16,0,8,0,8,0,8,14,8,19,16,16,224,0,0,0,0,0,0,0,0 },
  { 4,0,8,0,80,0,32,0,7,248,2,40,1,16,0,128,0,128,56,128,76,128,51,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,134,125,182,113,134,125,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,142,125,182,113,142,125,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,198,125,190,113,190,125,190,99,198,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,0,0,128,0,128,3,0,4,0,4,0,3,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,255,0,5,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,128,2,64,1,192,7,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 4,0,9,128,6,64,1,192,7,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,0,1,0,1,0,1,0,1,0,9,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,255,0,37,0,18,0,8,0,4,0,2,0,18,0,12,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,0,1,0,1,0,1,0,5,0,11,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,31,0,17,0,8,0,4,0,2,0,10,0,22,0,12,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,109,134,109,190,97,134,125,246,125,134,127,254,0,0 },
  { 15,192,0,32,0,32,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,96,0,128,15,192,0,32,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 15,192,0,32,0,32,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,10,0,15,240 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,109,206,109,182,97,198,125,246,125,206,127,254,0,0 },
  { 0,0,55,224,8,144,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,48,0,72,55,224,72,80,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,63,224,4,144,56,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 15,0,16,0,12,0,16,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,109,134,109,190,97,142,125,190,125,134,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,109,134,109,190,97,142,125,190,125,190,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,206,111,182,97,182,125,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,238,111,206,97,238,125,238,97,198,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,134,111,246,97,134,125,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,142,111,246,97,198,125,246,97,142,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,182,111,182,97,134,125,246,97,246,127,254,0,0 },
  { 0,96,0,144,0,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,10,0,15,240 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,134,111,246,97,238,125,222,97,222,127,254,0,0 },
  { 1,0,2,128,127,144,0,32,1,192,1,160,0,16,0,8,120,8,9,8,19,144,12,96,0,0,0,0,0,0,0,0 },
  { 0,64,0,160,31,224,0,0,12,64,19,32,18,192,4,0,8,0,16,0,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,134,111,182,97,134,125,182,97,182,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,142,111,182,97,142,125,182,97,142,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,198,111,190,97,190,125,190,97,198,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,142,111,182,97,182,125,182,97,142,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,134,111,190,97,142,125,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,134,111,190,97,142,125,190,97,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,73,62,164,149,36,146,36,144,68,144,132,144,164,144,91,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,27,62,36,165,36,162,1,16,2,16,2,16,2,32,1,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,192,9,40,0,40,0,16 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,56,36,180,0,168,0,64 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,115,182,111,182,99,134,109,246,115,246,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,115,134,111,190,99,134,109,246,115,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,1,128,2,64,4,32,4,32,4,32,4,32,2,64,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,4,32,8,16,8,16,8,16,8,16,4,32,2,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,224,1,16,1,72,0,136,0,8,0,16,63,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,224,2,16,2,16,0,224,0,16,2,16,2,16,1,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,4,32,8,16,8,16,4,32,3,192,4,32,4,32,3,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,3,4,0,200,0,48,0,48,0,72,0,136,7,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,56,0,64,0,64,0,63,0,64,0,64,0,32,0,31,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,192,2,32,4,32,0,64,3,136,4,8,4,16,3,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,252,32,128,64,64,64,64,64,64,64,64,32,128,31,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,248,32,0,64,0,64,0,63,0,64,0,64,0,56,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,206,125,182,123,182,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,238,125,206,123,238,119,238,119,198,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,134,125,246,123,134,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,142,125,246,123,198,119,246,119,142,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,182,125,182,123,134,119,246,119,246,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,134,125,190,123,134,119,246,119,134,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,206,125,190,123,142,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,134,125,246,123,238,119,222,119,222,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,4,32,4,32,4,32,4,32,3,192,0,32,0,16,0,96,1,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,32,2,32,2,32,2,32,1,224,0,32,0,32,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,9,32,9,32,9,32,9,32,6,224,0,32,0,32,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,0,32,0,32,1,192,2,0,4,0,4,0,3,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,0,0,128,3,0,4,0,3,0,0,128,3,0,4,0,3,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,0,9,0,22,8,16,8,16,16,16,16,8,32,7,192,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,115,206,109,182,115,182,109,182,115,206,127,254,0,0 },
  { 0,0,1,128,9,144,4,32,3,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,9,0,6,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,2,0,5,0,5,0,2,0,2,0,5,0,5,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,115,182,109,182,115,134,109,246,115,246,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,18,144,50,72,44,232,32,8,32,8,16,16,15,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,48,18,72,50,40,44,240,32,8,32,8,16,16,15,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,59,128,68,64,68,64,0,64,30,128,33,0,30,128,0,64,0,64,0,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,0,2,0,254,96,60,144,66,96,127,224,66,32,60,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,70,32,169,16,169,16,201,16,137,16,137,16,73,32,48,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,70,28,169,34,169,34,201,34,137,38,137,42,73,42,48,196,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,128,0,128,103,144,144,136,104,68,8,68,8,68,104,68,148,164,99,24,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,27,0,36,128,36,128,1,16,2,16,2,16,2,32,1,192,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,115,142,109,182,115,182,109,182,115,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,62,0,1,128,0,64,0,32,32,16,81,8,66,136,60,80,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,32,0,16,0,9,128,6,64,0,32,32,16,81,8,66,136,60,112,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,96,34,144,65,8,0,8,32,8,81,8,66,136,60,112,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,115,238,109,206,113,238,125,238,115,198,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,48,0,72,0,72,0,16,32,32,16,65,8,66,136,60,112,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,24,0,32,0,48,0,72,0,72,0,16,32,32,16,65,8,66,136,60,112,0,0,0,0,0,0,0,0 },
  { 127,224,2,16,2,16,124,144,49,32,72,192,72,0,16,32,32,16,65,8,66,136,60,112,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,192,0,32,31,192,2,0,2,0,31,192,8,128,16,64,16,64,15,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,14,32,17,16,32,136,32,132,1,4,15,4,18,132,12,120,0,0,0,0,0,0,0,0 },
  { 0,0,0,224,0,16,0,16,63,224,4,64,8,32,8,32,8,32,8,32,8,32,8,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,7,0,0,128,255,32,0,16,2,8,96,40,144,48,98,32,39,32,26,192,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,51,240,76,8,72,48,17,0,32,16,65,8,66,136,60,112,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,48,0,8,96,240,144,128,144,64,32,224,64,64,132,64,138,64,113,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,48,0,8,96,240,144,128,144,64,224,64,128,64,132,64,142,64,117,128,4,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,49,128,72,64,79,128,16,0,32,64,66,32,69,32,56,192,0,0,0,0,0,0,0,0 },
  { 0,0,14,0,1,0,62,0,28,144,34,72,34,72,34,72,34,72,34,72,34,232,29,80,0,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,27,96,36,144,36,144,0,128,0,128,29,0,34,0,29,0,1,0,1,0,0,0,0,0 },
  { 32,16,32,16,32,16,16,32,24,192,36,32,88,32,64,16,64,16,64,16,34,16,29,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,0,64,31,128,7,0,8,128,16,64,18,64,16,64,15,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,0,64,127,128,32,0,64,0,64,32,66,80,37,16,24,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,0,64,127,128,32,0,64,0,64,32,66,80,39,16,26,224,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,224,37,16,66,8,64,8,32,136,65,72,65,80,48,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,192,0,32,15,192,0,32,0,16,16,208,17,32,8,208,4,16,3,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,0,64,31,128,7,0,8,128,18,64,16,64,18,64,15,128,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,0,64,31,128,7,0,8,128,16,64,16,64,18,64,13,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,0,64,31,128,7,0,8,128,16,64,16,64,18,64,15,128,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,224,0,16,7,224,0,64,0,32,0,16,24,16,36,16,34,32,17,192,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,206,109,182,97,198,109,246,109,206,127,254,0,0 },
  { 0,0,0,0,0,224,0,16,31,224,0,0,32,32,81,16,80,8,97,8,66,136,60,112,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,224,0,16,31,224,0,0,32,32,81,16,80,8,97,8,66,136,61,112,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,48,192,72,32,8,16,16,8,32,8,33,8,18,144,12,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,112,0,8,49,240,72,64,8,32,16,16,32,8,33,8,18,144,13,96,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,3,128,0,64,63,128,0,0,64,144,160,72,160,72,196,72,138,72,113,176,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,192,0,32,51,192,72,144,132,72,132,72,132,72,138,72,113,176,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,0,64,31,128,7,0,8,128,16,64,16,64,16,64,15,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,18,144,50,152,63,248,32,8,33,8,18,144,12,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,0,48,128,72,64,112,32,64,32,64,32,32,64,31,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,96,0,16,1,224,48,128,72,64,112,32,64,32,64,32,32,64,31,128,9,0,6,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,182,109,182,99,134,109,246,99,246,127,254,0,0 },
  { 0,0,0,0,0,0,0,48,0,8,3,240,32,32,80,16,80,8,97,8,66,136,60,112,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,192,0,32,127,192,48,128,72,64,68,32,36,32,4,32,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,192,0,32,15,192,0,0,32,32,81,16,80,8,97,40,66,152,60,116,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,128,0,64,15,128,0,0,4,32,0,16,14,16,17,16,32,144,32,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,224,0,16,7,224,0,0,2,160,5,208,8,136,8,136,4,144,3,96,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,134,109,182,99,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,142,109,182,99,142,109,182,99,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,64,0,0 },
  { 0,0,0,0,0,0,0,0,14,0,16,0,32,0,16,0,12,0,2,0,66,0,60,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,1,0,5,0,9,0,6,0,0,0,0,0,0,0,0,0,0 },
  { 0,192,1,32,0,224,0,64,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,192,1,32,0,224,0,64,1,130,0,5,0,5,0,6,0,4,0,4,0,4,0,4,0,2,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,4,0,2,0,1,0,1,0,1,0,9,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,9,0,11,0,11,0,11,0,8,0,8,0,48,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,12,0,2,0,1,0,1,0,7,0,7,0,7,0,0,0,0,0,0,0,0 },
  { 0,126,0,33,0,21,0,22,0,16,0,8,0,4,0,2,0,1,0,5,0,9,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,113,134,111,190,111,134,111,246,113,134,127,254,0,0 },
  { 0,24,0,36,0,4,15,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,24,0,36,0,4,15,248,0,2,0,5,0,5,0,6,0,4,0,4,0,4,0,2,0,0,0,0,0,0,0,0 },
  { 0,24,0,36,0,4,15,248,0,4,0,2,0,4,0,2,0,1,0,13,0,13,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,113,206,111,182,111,198,111,246,113,206,127,254,0,0 },
  { 0,24,0,36,0,4,15,248,0,0,0,6,0,9,0,9,0,11,0,11,0,11,0,8,0,8,0,48,0,0,0,0 },
  { 0,99,0,147,0,18,15,226,0,1,0,7,0,9,0,9,0,11,0,11,0,11,0,8,0,8,0,48,0,0,0,0 },
  { 31,252,0,130,0,186,31,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,24,0,32,7,240,0,40,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,113,134,111,190,111,142,111,190,113,134,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,113,134,111,190,111,142,111,190,113,190,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,206,109,182,109,182,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,238,109,206,109,238,109,238,99,198,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,134,109,246,109,134,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,142,109,246,109,198,109,246,99,142,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,182,109,182,109,134,109,246,99,246,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,2,0,5,0,5,0,6,0,4,0,4,0,4,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,0,2,0,4,0,2,0,1,0,13,0,13,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,134,109,246,109,238,109,222,99,222,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,206,109,182,109,206,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,206,109,182,109,198,109,246,99,206,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,134,109,182,109,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,142,109,182,109,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,198,109,190,109,190,109,190,99,198,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,142,109,182,109,182,109,182,99,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,18,144,50,152,44,104,32,8,32,8,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,99,134,109,190,109,142,109,190,99,190,127,254,0,0 },
  { 0,0,0,0,0,64,0,64,15,128,98,14,145,17,113,17,17,19,113,21,153,149,102,98,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,49,159,74,83,68,83,32,72,0,136,0,136,0,136,0,112,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,192,9,32,8,32,4,24 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,128,18,76,16,80,8,60 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,182,111,182,99,134,111,246,97,246,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,134,111,190,99,134,111,246,97,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,1,128,2,64,4,32,4,32,4,32,4,32,2,64,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,4,32,8,16,8,16,8,16,8,16,4,32,2,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,224,1,16,1,48,0,208,0,16,0,16,0,16,7,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,0,18,128,18,64,12,64,14,64,17,72,16,144,15,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,32,9,16,14,16,4,32,3,192,4,32,4,32,3,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,24,28,36,35,36,16,248,7,224,25,16,34,16,28,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,8,0,8,0,62,0,73,0,73,0,70,0,64,0,64,0,32,0,31,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,192,1,32,0,160,0,64,3,128,4,0,4,0,3,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,32,0,64,24,128,36,128,68,64,120,64,64,64,64,64,32,128,31,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,248,32,0,64,0,64,0,63,0,64,0,64,0,56,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,206,111,182,99,182,111,182,111,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,224,4,64,2,128,1,0,2,128,4,64,15,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,28,112,34,136,34,136,34,136,28,112,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,142,111,246,99,198,111,246,111,142,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,182,111,182,99,134,111,246,111,246,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,134,111,190,99,134,111,246,111,134,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,115,198,109,190,109,190,109,190,115,198,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,115,206,109,182,109,182,109,182,115,206,127,254,0,0 },
  { 0,0,1,128,9,144,4,32,3,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,9,0,6,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,2,0,5,0,5,0,2,0,0,0,2,0,5,0,5,0,2,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,115,182,109,182,109,134,109,246,115,246,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,30,48,33,72,124,132,162,132,188,156,162,164,162,164,28,152,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,30,50,33,77,124,141,162,149,188,165,162,165,162,165,28,153,0,1,0,62,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,192,37,32,66,16,66,16,114,16,74,16,74,16,50,16,0,16,63,224,64,0,63,224 },
  { 0,0,0,0,0,0,0,0,116,80,138,168,138,168,138,168,202,8,170,72,170,48,66,0,2,0,124,0,128,0,124,0 },
  { 0,0,0,0,0,0,0,0,15,0,18,128,18,64,12,64,0,64,15,128,16,0,31,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,80,42,168,42,168,18,168,2,8,28,72,32,48,62,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,18,144,28,112,16,16,8,32,7,192,8,32,7,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,18,144,33,40,33,72,57,72,37,72,37,72,25,48,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,115,142,109,182,109,182,109,182,115,142,127,254,0,0 },
  { 0,0,0,0,0,240,1,8,113,40,137,40,137,40,95,232,1,40,1,40,1,40,0,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,224,2,16,114,136,138,136,138,136,95,144,2,136,2,136,2,136,1,48,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,14,0,17,115,149,172,85,172,85,74,253,8,21,0,21,0,21,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,123,238,115,206,123,238,123,238,113,198,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,7,128,8,64,16,32,32,16,32,16,60,32,34,16,28,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,14,24,17,36,33,4,32,132,32,132,49,4,40,164,19,24,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,40,34,84,66,84,65,84,65,4,98,36,81,24,38,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,4,64,4,64,63,240,76,72,52,72,4,80,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,30,4,33,4,64,132,64,68,112,68,72,68,72,132,49,252,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,112,32,136,65,4,65,4,34,8,28,112,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,114,0,138,56,138,68,138,68,138,47,250,0,130,0,254,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,224,37,16,66,8,66,8,114,112,74,8,74,8,50,112,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,0,8,0,8,6,8,9,8,1,8,2,8,63,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,48,0,72,0,132,12,132,18,140,2,148,4,84,63,200,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,62,224,65,16,113,16,73,16,48,32,63,240,64,200,63,48,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,60,36,94,34,165,34,165,34,153,34,129,34,65,36,0,216,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,192,37,56,66,84,66,148,114,148,74,148,74,148,50,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,8,0,8,0,7,192,0,32,0,32,7,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,7,128,8,64,8,64,8,64,7,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,12,72,18,68,34,68,34,68,34,68,18,68,2,72,1,176,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,24,144,36,168,36,168,36,168,36,168,4,152,4,144,3,96,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,25,176,38,72,66,72,66,72,66,72,114,72,74,72,50,80,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,240,19,8,34,132,36,68,36,36,36,36,34,68,17,136,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,240,65,8,65,8,65,8,65,8,65,8,65,8,127,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,8,32,16,32,17,192,16,32,16,32,18,32,9,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,9,32,17,16,33,8,33,8,33,8,33,8,17,16,6,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,14,224,17,16,33,8,33,8,33,8,33,8,17,16,9,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,224,19,16,33,8,57,8,37,8,37,8,37,16,25,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,0,8,0,8,0,8,56,8,68,8,68,8,47,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,112,0,136,0,136,0,136,56,136,68,136,68,136,47,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,25,136,38,72,66,72,66,72,66,72,114,72,74,72,50,120,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,8,32,16,32,17,192,18,0,17,192,16,32,11,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,9,16,16,136,16,136,17,8,18,8,28,8,31,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,17,136,34,68,36,36,36,36,36,68,34,132,19,8,12,240,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,0,16,192,32,160,33,16,33,8,33,8,32,144,16,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,8,32,16,16,16,16,16,16,16,16,16,16,8,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,8,18,8,33,8,33,8,63,8,32,8,32,8,63,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,192,16,32,32,32,56,192,36,32,24,32,0,32,15,192,16,0,15,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,224,17,16,17,16,9,32,7,192,1,0,17,0,14,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,30,8,33,8,64,136,64,136,64,136,64,136,65,8,35,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,112,16,136,33,4,33,4,33,28,33,36,18,36,12,24,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,0,2,152,2,168,57,200,68,136,68,136,47,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,54,16,73,8,136,136,136,136,136,136,136,136,136,144,72,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,224,1,16,2,8,2,8,114,8,138,8,137,16,95,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,192,17,32,17,32,17,32,17,32,16,160,16,96,31,248,0,32,0,32,0,32,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,99,142,125,182,113,142,125,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,99,198,125,190,113,190,125,190,99,198,127,254,0,0 },
  { 0,0,0,16,0,40,0,40,0,64,0,64,0,64,0,64,0,64,0,64,0,64,2,128,2,128,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,6,0,9,0,1,0,1,0,1,0,1,0,9,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,6,0,9,0,9,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0 },
  { 0,6,0,9,0,7,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,1,0,2,0,4,0,4,0,10,0,4,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,1,0,2,0,4,0,4,0,10,0,5,0,1,0,14,0,0 },
  { 0,0,0,0,0,0,0,0,0,1,0,2,0,4,0,4,0,4,0,2,0,1,0,1,0,1,0,31,0,33,0,30 },
  { 0,0,0,0,0,0,0,0,0,1,0,2,0,4,0,4,0,4,0,2,0,1,0,1,0,1,0,255,1,85,0,254 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,109,134,109,190,97,134,125,246,125,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,112,0,136,0,136,0,136,0,200,0,168,0,168,0,72,0,16,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,96,0,144,0,224,0,128,0,128,0,224,0,144,0,96,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,216,0,180,0,180,0,180,0,144,0,144,0,216,0,216,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,109,206,109,182,97,198,125,246,125,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,112,6,136,9,136,1,136,1,200,1,168,1,168,9,72,6,16,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,96,6,144,9,224,1,128,1,128,1,224,1,144,9,96,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,112,10,136,21,136,21,136,1,200,2,168,4,168,0,72,0,16,0,0,0,0,0,0,0 },
  { 0,18,0,33,0,33,0,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,96,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,109,134,109,190,97,142,125,190,125,190,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,206,111,182,97,182,125,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,238,111,206,97,238,125,238,97,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,134,111,246,97,134,125,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,142,111,246,97,198,125,246,97,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,182,111,182,97,134,125,246,97,246,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,134,111,190,97,134,125,246,97,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,206,111,190,97,142,125,182,97,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,10,0,21,0,21,0,1,0,2,0,4,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,206,111,182,97,206,125,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,206,111,182,97,198,125,246,97,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,134,111,182,97,134,125,182,97,182,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,142,111,182,97,142,125,182,97,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,198,111,190,97,190,125,190,97,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,142,111,182,97,182,125,182,97,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,134,111,190,97,142,125,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,134,111,190,97,142,125,190,97,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,24,96,36,144,88,104,64,8,32,16,31,224,32,16,36,144,32,16,31,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,192,37,56,66,84,66,148,114,148,74,148,74,148,50,100,0,4,0,72,0,48,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,240,57,56,37,72,25,48 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,240,57,56,37,72,24,56,0,240 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,115,182,111,182,99,134,109,246,115,246,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,115,134,111,190,99,134,109,246,115,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,192,4,32,4,32,4,32,3,192,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,240,1,8,1,8,1,8,1,8,1,8,1,8,31,248,32,0,31,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,30,0,33,0,64,128,64,128,64,128,64,128,65,0,35,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,27,0,36,128,68,64,68,64,68,64,68,64,68,64,36,124,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,0,1,0,1,0,7,192,9,32,17,32,17,32,16,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,8,16,17,136,18,72,18,136,18,72,8,80,7,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,27,24,36,164,68,66,68,66,68,66,68,66,68,66,36,66,0,4,0,8,0,16,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,5,64,9,32,9,32,6,32,0,64,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,32,28,32,34,32,34,32,23,224,0,32,0,32,1,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,0,128,0,128,27,224,36,144,68,144,68,144,36,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,72,2,68,2,68,2,68,2,68,2,68,2,72,3,176,2,0,60,0,0,0 },
  { 0,0,0,0,0,0,0,0,14,224,17,16,33,8,33,8,33,8,17,8,0,16,2,32,1,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,27,132,36,74,68,42,68,254,69,32,69,32,68,160,36,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,248,16,0,28,0,18,0,12,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,192,0,32,0,16,15,208,16,32,32,80,32,144,56,144,36,144,36,144,24,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,224,0,16,0,8,12,104,18,144,33,40,33,72,57,72,37,72,37,72,25,48,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,206,125,190,123,142,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,134,125,246,123,238,119,222,119,222,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,206,125,182,123,206,119,182,119,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,27,128,36,64,68,32,68,254,69,32,69,32,68,160,36,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,48,0,72,0,4,27,52,36,136,68,152,68,168,100,168,84,168,84,168,36,144,0,0,0,0,0,0,0,0 },
  { 0,0,0,224,0,16,0,8,12,104,18,144,33,40,33,72,33,72,33,72,17,72,9,48,0,0,0,0,0,0,0,0 },
  { 0,0,0,192,0,32,0,16,7,208,8,32,16,80,16,144,16,144,16,144,8,144,4,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,224,0,16,0,8,28,232,35,16,69,40,73,72,73,72,73,72,73,72,38,48,0,0,0,0,0,0,0,0 },
  { 0,0,0,224,0,16,0,8,0,104,16,144,33,40,33,72,33,72,33,72,18,72,12,48,0,0,0,0,0,0,0,0 },
  { 0,0,3,128,4,64,0,32,7,32,8,160,8,160,63,248,72,164,72,164,72,152,55,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,115,206,109,182,115,182,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,115,238,109,206,115,238,109,238,115,198,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,9,0,6,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,6,0,9,0,9,0,6,0,0,0,6,0,9,0,9,0,6,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,115,182,109,182,115,134,109,246,115,246,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,3,24,4,168,0,104,15,240,16,32,16,32,8,32,7,224,0,32,0,32,0,32,0,32 },
  { 0,0,0,0,0,0,0,0,24,216,37,100,3,66,127,130,129,2,129,2,65,36,63,24,1,0,1,0,1,0,1,0 },
  { 0,0,0,0,0,0,0,0,12,64,18,160,1,190,63,194,64,132,64,132,32,132,31,132,0,132,0,132,0,132,0,131 },
  { 0,0,0,0,0,0,0,0,12,64,18,160,1,190,63,196,64,136,64,158,32,130,31,132,0,132,0,132,0,132,0,131 },
  { 0,0,0,0,0,0,0,0,7,192,8,32,17,16,18,144,17,16,14,96,0,16,0,224,0,0,0,0,0,0,0,0 },
  { 8,0,21,0,9,32,2,80,4,32,7,0,8,128,16,64,16,64,16,64,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,128,2,64,0,32,15,224,16,0,16,16,16,32,15,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,44,9,42,0,146,63,130,64,18,64,76,64,128,63,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,97,128,146,64,10,38,123,233,128,33,132,39,138,73,113,134,128,1,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,66,0,165,0,20,146,119,173,128,137,136,155,149,45,98,18,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,56,42,84,66,66,78,114,80,10,72,18,39,228,16,8,15,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,113,192,170,160,138,54,187,181,160,169,160,161,159,41,64,70,63,128,0,0,0,0,0,0 },
  { 3,128,4,128,3,128,0,128,12,128,2,64,62,32,16,32,32,32,32,32,16,64,15,128,0,0,0,0,0,0,0,0 },
  { 3,184,4,164,3,184,0,160,12,160,2,96,62,32,16,32,32,32,32,32,16,64,15,128,0,0,0,0,0,0,0,0 },
  { 0,28,0,36,0,28,0,4,0,100,112,18,137,241,132,129,179,1,185,1,136,130,112,124,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,224,64,16,1,200,97,164,80,36,79,196,64,4,33,8,30,240,0,0,0,0,0,0,0,0 },
  { 0,0,127,192,32,32,63,240,64,16,1,200,97,164,80,36,79,196,64,4,33,8,30,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,127,0,128,128,14,64,13,108,193,106,190,82,128,66,136,146,119,12,0,7,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,115,134,109,246,113,238,125,222,115,222,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,115,206,109,182,113,206,125,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,115,206,109,182,113,198,125,246,115,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,96,0,147,224,140,16,15,200,16,40,32,40,68,72,187,144,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,224,32,16,15,8,16,136,32,72,32,72,44,144,28,224,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,39,128,72,64,142,32,130,32,68,64,56,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,48,128,73,64,5,64,125,128,16,64,32,32,39,32,24,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,128,64,64,28,32,26,16,2,16,62,16,64,16,64,16,34,32,29,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,56,42,68,66,66,78,114,80,18,72,34,39,196,31,136,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,31,0,32,128,12,64,2,32,62,32,16,32,32,32,32,32,16,64,15,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,32,0,64,0,128,12,176,2,200,62,120,16,76,32,50,32,2,16,4,15,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,8,0,16,0,32,12,32,2,112,62,168,16,168,32,112,32,32,16,64,15,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,112,224,136,144,4,39,194,120,34,134,66,129,130,201,146,182,108,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,57,240,86,40,132,4,152,124,166,128,193,128,201,68,182,56,0,8,0,16,0,16,0,12 },
  { 0,0,0,0,0,0,0,0,56,56,84,84,132,130,153,190,161,224,194,64,196,76,56,52,0,4,0,8,0,8,0,6 },
  { 0,0,0,4,0,8,0,16,29,144,42,56,66,84,76,84,80,56,96,16,96,32,31,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,128,32,64,0,32,28,32,32,32,32,32,16,64,15,128,0,0,0,0,0,0,0,0 },
  { 1,192,2,64,1,192,0,64,0,64,0,32,0,16,32,16,64,16,64,16,34,32,29,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,31,192,32,32,12,16,2,8,62,8,16,8,32,8,32,8,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 1,192,2,64,1,192,0,64,24,64,4,32,124,16,32,16,64,16,64,16,34,32,29,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,248,1,0,30,0,38,0,57,12,53,82,57,178,65,82,130,12,252,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,31,192,32,32,7,16,10,136,16,136,19,8,20,8,24,8,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,96,0,147,224,140,16,15,200,16,40,32,40,64,72,191,144,0,0,0,0,0,0,0,0 },
  { 1,192,2,64,1,192,0,64,16,64,32,32,64,16,64,16,64,16,64,16,32,32,31,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,192,1,32,0,32,7,224,4,0,4,48,3,208,0,16,0,32,0,32,0,24 },
  { 0,0,0,0,15,192,16,32,32,16,0,8,12,8,16,8,32,8,32,8,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,224,97,16,146,8,140,4,15,4,16,132,32,132,65,36,190,24,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,99,134,109,246,99,134,109,190,99,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,5,64,8,32,11,224,12,0,12,0,2,32,1,192,0,64,0,128,0,128,0,96 },
  { 0,0,0,0,0,0,0,0,0,0,6,16,1,40,3,104,12,24,16,4,12,24,3,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,224,1,32,0,224,0,32,6,32,1,16,3,8,12,8,16,4,12,24,3,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,224,32,16,15,8,16,136,32,72,32,72,44,144,28,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,48,112,72,136,5,4,125,196,16,68,32,132,33,8,30,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,224,32,16,1,200,26,40,26,168,22,40,19,200,8,16,7,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,224,32,16,1,200,27,40,27,232,23,232,16,8,9,144,6,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,128,1,64,1,192,16,64,32,32,34,32,29,192,0,0,0,0,0,0,0,0 },
  { 0,0,1,0,1,0,2,0,4,0,7,0,8,128,16,64,16,64,16,64,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,99,198,109,190,99,190,109,190,99,198,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,15,128,16,64,39,32,34,72,33,136,32,16,16,32,15,192,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,99,134,109,190,99,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,99,134,109,190,99,142,109,190,99,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,31,192,32,32,70,16,65,16,15,16,16,16,8,32,7,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,39,192,72,32,142,16,130,80,68,160,56,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,12,64,2,160,14,224,16,32,35,80,36,144,35,16,16,32,15,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,48,128,73,64,5,64,125,128,16,64,32,32,34,32,29,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,48,112,72,136,5,4,29,196,16,68,32,132,33,8,30,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,192,9,32,8,32,31,224,24,10,23,242,16,4,15,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,14,224,17,16,32,8,32,8,16,16,12,96,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,113,134,111,246,111,238,111,222,113,222,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,113,206,111,182,111,206,111,182,113,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,113,206,111,182,111,198,111,246,113,206,127,254,0,0 },
  { 0,14,0,9,0,14,0,8,0,8,0,8,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,113,142,111,182,111,142,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,113,198,111,190,111,190,111,190,113,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,113,142,111,182,111,182,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,113,134,111,190,111,142,111,190,113,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,1,0,1,0,9,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,62,0,2,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,3,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,2,0,4,0,2,0,4,0,4,0,4,0,3,0,0,0,0 },
  { 7,240,8,8,8,8,4,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 7,240,8,72,8,72,4,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,16,16,16,15,240 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,99,134,109,190,109,134,109,246,99,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,16,16,208,15,48 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,99,134,109,246,109,238,109,222,99,222,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,64,0,0,0,6,0,9,0,1,0,7,0,9,0,6,0,1,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,0,160,0,144,0,144,0,128,0,224,0,224,0,224,0,0,0,0,0,0,0,0,0 },
  { 0,14,0,9,0,14,0,8,64,8,160,8,144,8,144,0,128,0,224,0,224,0,224,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,72,0,180,0,144,0,144,0,144,0,252,0,252,0,252,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,0,160,0,144,6,144,9,128,1,224,1,224,9,224,6,0,0,0,0,0,0,0,0 },
  { 0,14,0,9,0,14,0,8,64,8,160,8,144,14,144,9,128,1,224,1,224,9,224,6,15,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,4,160,8,144,10,144,13,128,1,224,1,224,9,224,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,0,8,0,10,0,13,0,1,0,1,0,9,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,206,111,182,99,182,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,238,111,206,99,238,111,238,97,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,134,111,246,99,134,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,142,111,246,99,198,111,246,97,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,182,111,182,99,134,111,246,97,246,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,134,111,190,99,134,111,246,97,134,127,254,0,0 },
  { 0,0,0,0,7,0,8,128,16,128,16,128,15,224,0,144,0,144,1,224,0,128,0,128,0,128,0,128,0,128,0,128 },
  { 0,0,0,0,0,0,0,0,31,192,32,32,71,144,73,80,73,80,70,80,32,144,31,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,140,32,82,79,34,82,162,82,162,76,162,33,36,30,40,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,62,44,65,82,156,146,170,146,170,146,146,146,68,162,56,172,0,0,0,0,0,0,0,0 },
  { 0,8,0,16,8,32,28,112,42,168,50,152,4,64,24,48,32,8,32,8,16,16,15,224,0,0,0,0,0,0,0,0 },
  { 0,0,1,0,3,128,5,64,6,64,0,128,3,0,4,0,4,16,2,96,1,128,0,128,0,128,0,112,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,14,224,17,16,44,124,34,138,18,146,12,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,224,16,32,18,64,12,64,0,64,0,128,0,128,0,132,0,132,0,120,0,0,0,0 },
  { 0,0,0,64,0,128,1,0,2,0,4,192,9,32,18,16,16,16,16,16,8,32,7,192,0,0,0,0,0,0,0,0 },
  { 7,224,8,144,8,96,4,0,31,140,32,82,79,34,82,162,82,162,76,162,33,36,30,40,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,206,111,182,99,182,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,238,111,206,99,238,111,238,111,198,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,45,0,9,0,27,0,45,0,18,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,0,8,0,10,0,13,0,1,0,5,0,11,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,10,160,74,164,85,84,37,72,80,20,192,6,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,134,111,190,99,134,111,246,111,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,115,142,109,182,109,182,109,182,115,142,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,206,109,182,109,182,109,182,115,206,127,254,0,0 },
  { 0,0,0,0,0,0,60,66,98,34,34,34,34,34,0,0 },
  { 0,0,0,0,0,0,100,100,36,68,68,68,68,56,0,0 },
  { 0,0,0,0,0,0,82,114,18,34,34,34,34,28,0,0 },
  { 0,0,0,0,0,0,60,66,66,90,122,98,66,66,0,0 },
  { 0,0,0,0,0,0,52,74,66,90,122,98,66,66,0,0 },
  { 0,0,0,0,0,0,82,114,18,34,34,34,114,108,0,0 },
  { 0,0,0,0,0,0,12,12,4,4,68,36,20,12,0,0 },
  { 0,0,0,0,0,0,60,66,2,26,26,10,10,12,0,0 },
  { 0,0,0,0,0,0,56,68,4,100,100,36,46,54,0,0 },
  { 0,0,0,0,0,2,50,52,18,34,34,34,34,28,0,0 },
  { 0,0,0,0,0,2,82,116,18,34,34,34,34,28,0,0 },
  { 0,0,0,0,0,0,57,69,37,69,69,69,111,109,0,0 },
  { 0,0,0,0,0,0,50,74,42,74,74,74,110,98,14,0 },
  { 0,0,0,0,0,0,60,66,98,34,34,34,102,122,22,0 },
  { 0,0,0,0,0,0,60,66,98,34,34,34,106,110,26,0 },
  { 0,0,0,0,0,0,30,32,28,2,26,26,6,2,42,22 },
  { 0,0,0,0,0,0,84,122,18,34,34,34,34,34,0,0 },
  { 0,0,0,0,0,0,41,85,69,117,117,85,111,77,0,0 },
  { 0,0,0,0,0,0,50,74,42,74,74,74,111,107,0,0 },
  { 0,0,0,0,0,0,60,66,66,90,90,74,114,66,0,0 },
  { 0,0,0,0,0,0,52,74,66,90,90,74,114,66,0,0 },
  { 0,0,0,0,0,0,60,66,98,34,34,34,50,50,0,0 },
  { 0,0,0,0,0,0,100,106,50,34,34,34,34,34,0,0 },
  { 0,0,0,0,0,0,60,64,120,36,36,36,36,24,0,0 },
  { 0,0,0,0,0,0,100,100,36,68,68,68,78,54,0,0 },
  { 0,0,0,0,0,0,50,50,18,34,34,34,34,28,0,0 },
  { 0,0,0,0,0,2,2,50,50,18,34,34,34,28,0,0 },
  { 0,0,0,0,0,0,105,105,73,73,73,73,73,54,0,0 },
  { 0,0,0,0,0,1,1,105,105,73,73,73,73,54,0,0 },
  { 0,0,0,0,0,0,105,105,41,73,73,73,73,54,0,0 },
  { 0,0,0,0,0,1,1,105,105,41,73,73,73,54,0,0 },
  { 0,0,0,0,0,0,60,66,98,34,34,34,98,98,0,0 },
  { 0,0,0,0,0,0,98,98,34,34,34,34,114,108,0,0 },
  { 0,0,0,0,0,0,98,98,66,50,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,60,64,120,4,4,4,12,12,0,0 },
  { 0,0,0,0,0,0,60,66,98,34,34,34,50,50,2,0 },
  { 0,0,0,0,0,0,60,66,2,26,38,34,50,50,0,0 },
  { 0,0,0,0,0,0,60,66,98,34,34,34,98,98,2,0 },
  { 0,0,0,0,0,0,56,68,4,4,4,4,12,12,0,0 },
  { 0,0,0,0,0,2,2,60,66,90,122,98,66,66,0,0 },
  { 0,0,0,0,0,0,98,98,34,42,47,34,34,28,0,0 },
  { 0,0,0,0,0,3,60,66,2,26,38,34,50,50,0,0 },
  { 0,0,0,0,0,0,102,102,36,42,50,34,34,34,0,0 },
  { 0,0,0,0,0,1,1,106,105,41,73,73,73,54,0,0 },
  { 0,0,0,0,0,0,60,66,2,98,98,66,66,126,0,0 },
  { 0,0,0,0,0,3,60,122,2,98,98,66,66,126,0,0 },
  { 0,0,0,0,0,0,108,116,4,4,4,4,4,4,0,0 },
  { 0,0,0,0,0,0,0,52,56,0,52,56,0,0,0,0 },
  { 0,0,0,49,62,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,56,68,4,4,4,4,4,4,0,0 },
  { 0,0,0,96,96,0,28,34,2,2,2,2,2,2,0,0 },
  { 0,0,0,60,66,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,62,70,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,58,78,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,58,70,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,2 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,14 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,12 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,99,142,125,182,113,142,125,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,99,198,125,190,113,190,125,190,99,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,99,142,125,182,113,182,125,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,99,134,125,190,113,142,125,190,99,134,127,254,0,0 },
  { 0,0,0,0,8,124,42,42,42,60,42,42,42,124,8,0 },
  { 0,0,0,0,0,0,8,8,8,8,8,8,12,12,0,0 },
  { 0,0,0,0,0,0,18,18,18,18,18,18,27,27,0,0 },
  { 0,0,0,62,65,124,4,4,4,4,4,4,6,6,0,0 },
  { 0,0,0,56,68,84,52,4,4,4,4,4,6,6,0,0 },
  { 0,0,0,108,20,4,4,4,4,4,4,4,6,6,0,0 },
  { 0,0,0,0,0,0,56,68,4,4,4,4,4,4,4,4 },
  { 0,0,0,0,0,0,108,114,2,2,2,2,2,2,4,8 },
  { 0,0,0,62,84,0,0,0,0,0,0,0,0,0,0,0 },
  { 4,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,9,30,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 40,85,102,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 4,14,4,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,14,12,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,7,4,10,12,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,60,66,90,90,66,60,0,0 },
  { 0,0,0,0,0,0,0,60,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,0,60,66,66,90,58,2,60,0,0 },
  { 0,0,0,0,0,64,64,74,86,82,90,90,66,60,0,0 },
  { 0,0,0,0,0,0,0,52,74,74,74,66,114,114,0,0 },
  { 0,0,0,0,0,2,2,60,64,64,76,76,72,62,0,0 },
  { 0,0,0,0,0,26,22,60,64,64,76,76,72,62,0,0 },
  { 0,0,0,0,0,0,64,44,18,2,2,50,50,60,0,0 },
  { 0,0,0,0,0,2,2,42,90,74,74,74,106,108,0,0 },
  { 0,0,0,0,0,0,3,60,64,64,70,86,82,110,0,0 },
  { 0,0,0,0,0,2,2,26,52,80,72,72,100,100,0,0 },
  { 0,0,0,0,0,0,2,54,58,2,2,2,6,4,0,0 },
  { 0,0,0,0,0,0,32,80,88,87,84,80,96,96,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,198,111,190,97,190,125,190,97,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,142,111,182,97,182,125,182,97,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,111,190,97,142,125,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,111,190,97,142,125,190,97,190,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,206,111,182,99,182,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,238,111,206,99,238,109,238,115,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,134,111,246,99,134,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,142,111,246,99,198,109,246,115,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,182,111,182,99,134,109,246,115,246,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,134,111,190,99,134,109,246,115,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,206,111,190,99,142,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,134,111,246,99,238,109,222,115,222,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,206,111,182,99,206,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,206,111,182,99,198,109,246,115,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,134,111,182,99,134,109,182,115,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,142,111,182,99,142,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,198,111,190,99,190,109,190,115,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,142,111,182,99,182,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,134,111,190,99,142,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,134,111,190,99,142,109,190,115,190,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,125,182,123,182,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,238,125,206,123,238,119,238,119,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,125,246,123,134,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,142,125,246,123,198,119,246,119,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,182,125,182,123,134,119,246,119,246,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,125,190,123,134,119,246,119,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,125,190,123,142,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,125,246,123,238,119,222,119,222,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,125,182,123,206,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,125,182,123,198,119,246,119,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,125,182,123,134,119,182,119,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,142,125,182,123,142,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,198,125,190,123,190,119,190,119,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,142,125,182,123,182,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,125,190,123,142,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,125,190,123,142,119,190,119,190,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,206,109,182,115,182,109,182,115,206,127,254,0,0 },
  { 0,0,0,0,0,92,34,34,34,34,34,34,98,0,0,0 },
  { 0,0,0,0,0,60,66,4,24,32,76,82,34,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,142,109,246,115,198,109,246,115,142,127,254,0,0 },
  { 0,0,0,0,0,60,66,66,50,66,66,66,50,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,134,109,190,115,134,109,246,115,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,206,109,190,115,142,109,182,115,206,127,254,0,0 },
  { 0,0,0,0,0,24,44,20,4,4,4,4,100,68,68,56 },
  { 0,0,0,0,0,60,66,2,26,38,2,2,2,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,206,109,182,115,198,109,246,115,206,127,254,0,0 },
  { 0,0,0,0,0,60,66,100,8,16,32,76,114,2,2,2 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,142,109,182,115,142,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,198,109,190,115,190,109,190,115,198,127,254,0,0 },
  { 0,0,0,0,0,50,66,66,50,66,66,66,60,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,134,109,190,115,142,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,134,109,190,115,142,109,190,115,190,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,206,109,182,113,182,125,182,115,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,238,109,206,113,238,125,238,115,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,134,109,246,113,134,125,190,115,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,142,109,246,113,198,125,246,115,142,127,254,0,0 },
  { 0,0,0,0,0,60,66,66,66,66,66,82,34,0,0,0 },
  { 0,0,0,0,0,36,90,66,66,66,66,66,34,0,0,0 },
  { 0,0,0,0,0,92,34,34,34,34,34,34,50,2,2,2 },
  { 0,0,0,0,0,140,82,82,82,82,82,82,34,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,115,206,109,182,113,206,125,182,115,206,127,254,0,0 },
  { 0,0,0,0,0,34,82,34,34,34,34,34,92,0,0,0 },
  { 0,0,0,0,0,34,82,34,66,66,66,66,60,0,0,0 },
  { 0,2,2,2,2,34,82,34,66,66,66,66,60,0,0,0 },
  { 0,0,0,0,1,102,134,130,130,130,146,146,108,0,0,0 },
  { 0,2,2,2,2,98,130,130,130,130,146,146,108,0,0,0 },
  { 0,0,0,0,0,66,162,66,130,130,146,146,108,0,0,0 },
  { 0,2,2,2,2,66,162,66,130,130,146,146,108,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,109,182,97,182,109,182,109,206,127,254,0,0 },
  { 0,0,0,0,0,34,34,34,34,34,34,34,92,0,0,0 },
  { 0,2,2,2,2,50,66,66,34,66,66,66,60,0,0,0 },
  { 0,0,0,0,0,60,66,64,60,2,98,66,60,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,182,109,182,97,134,109,246,109,246,127,254,0,0 },
  { 0,0,0,0,0,60,66,2,2,2,50,74,36,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,109,190,97,142,109,182,109,206,127,254,0,0 },
  { 0,0,0,0,0,60,66,2,2,2,66,66,60,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,109,182,97,206,109,182,109,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,109,182,97,198,109,246,109,206,127,254,0,0 },
  { 0,0,0,0,0,58,68,70,122,2,50,74,68,0,0,0 },
  { 0,0,0,0,0,150,73,73,73,73,73,73,49,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,198,109,190,97,190,109,190,109,198,127,254,0,0 },
  { 0,0,0,0,0,60,66,66,70,58,2,68,56,0,0,0 },
  { 0,0,0,0,0,50,76,64,60,2,98,66,60,0,0,0 },
  { 0,0,0,0,0,34,38,26,2,4,4,8,8,16,16,32 },
  { 0,0,0,0,0,0,0,52,56,0,52,56,0,0,0,0 },
  { 97,98,124,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,24,36,20,4,4,4,4,4,0,0,0 },
  { 0,0,192,192,0,12,18,10,2,2,2,2,2,0,0,0 },
  { 124,68,40,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 124,68,46,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 124,84,40,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 124,84,46,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,8 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,12 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,99,134,109,182,99,134,109,182,99,182,127,254,0,0 },
  { 62,97,96,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,50,76 },
  { 0,0,0,0,0,58,36,24,4,4,4,4,100,68,68,56 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,99,134,109,190,99,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,99,134,109,190,99,142,109,190,99,190,127,254,0,0 },
  { 0,0,0,0,0,8,8,8,8,8,8,12,12,0,0,0 },
  { 0,0,0,0,0,36,36,36,36,36,36,54,54,0,0,0 },
  { 0,48,76,34,24,4,4,4,4,4,4,6,6,0,0,0 },
  { 0,56,68,84,52,4,4,4,4,4,4,6,6,0,0,0 },
  { 0,128,76,52,4,4,4,4,4,4,4,6,6,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,113,134,111,190,111,134,111,246,113,134,127,254,0,0 },
  { 0,0,0,0,0,108,82,82,34,2,2,2,2,2,4,8 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,113,134,111,246,111,238,111,222,113,222,127,254,0,0 },
  { 16,16,16,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 50,20,56,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 40,85,102,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 8,28,8,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 2,28,24,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,8,20,8,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,113,134,111,190,111,142,111,190,113,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,113,134,111,190,111,142,111,190,113,190,127,254,0,0 },
  { 0,0,0,0,0,0,60,66,66,66,66,66,60,0,0,0 },
  { 0,0,0,0,0,0,60,66,66,90,58,2,60,0,0,0 },
  { 0,0,0,0,0,0,56,68,64,92,92,68,56,0,0,0 },
  { 0,0,0,8,20,10,68,34,34,34,34,34,92,0,0,0 },
  { 0,0,0,0,2,2,60,64,64,76,76,72,62,0,0,0 },
  { 0,0,0,0,2,26,60,64,64,76,76,72,62,0,0,0 },
  { 0,0,0,8,20,10,36,66,66,66,82,82,44,0,0,0 },
  { 0,0,0,0,0,0,92,34,34,34,34,34,98,2,2,2 },
  { 0,0,0,0,0,0,44,82,82,66,66,38,10,20,44,48 },
  { 0,0,0,0,0,0,50,74,74,74,74,74,36,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,99,134,109,182,109,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,99,142,109,182,109,142,109,182,99,142,127,254,0,0 },
  { 0,0,0,0,185,213,85,85,85,85,85,85,38,0,0,0 },
  { 0,0,0,0,137,213,85,85,85,85,85,93,46,0,0,0 },
  { 0,0,0,0,0,184,68,68,84,109,94,68,196,0,0,0 },
  { 0,0,0,0,0,100,132,132,116,173,158,132,120,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,111,182,99,182,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,238,111,206,99,238,111,238,97,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,111,246,99,134,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,142,111,246,99,198,111,246,97,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,182,111,182,99,134,111,246,97,246,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,111,190,99,134,111,246,97,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,111,190,99,142,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,111,246,99,238,111,222,97,222,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,111,182,99,206,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,111,182,99,198,111,246,97,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,111,182,99,134,111,182,97,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,142,111,182,99,142,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,198,111,190,99,190,111,190,97,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,142,111,182,99,182,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,111,190,99,142,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,111,190,99,142,111,190,97,190,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,111,182,99,182,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,238,111,206,99,238,111,238,111,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,111,246,99,134,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,142,111,246,99,198,111,246,111,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,182,111,182,99,134,111,246,111,246,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,111,190,99,134,111,246,111,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,134,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 24,0,103,0,28,0,93,0,73,0,85,0,83,0,75,0,57,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,92,0,72,0,84,0,82,0,74,0,57,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 16,0,16,0,24,0,68,48,186,72,124,72,120,48,132,0,136,48,156,72,34,72,2,48,6,0,97,0,18,0,12,0 },
  { 16,0,16,0,24,0,68,48,186,72,124,72,120,48,132,0,136,120,156,0,34,48,2,72,6,72,97,48,18,0,12,0 },
  { 0,0,0,0,0,0,0,0,6,0,193,0,49,0,78,0,49,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,0,2,0,98,0,28,0,98,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,0,193,0,49,0,78,0,49,0,14,0,0,0,12,0,4,0,4,0,4,0,4,0 },
  { 0,0,0,0,0,0,0,0,8,0,21,0,196,0,57,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,50,0,76,0,0,0,108,0,16,0,56,0,16,0,16,0,16,0,16,0,16,0,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,30,0,33,0,1,0,2,0,14,0,17,0,14,0,17,0,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,15,0,48,0,78,0,81,0,65,0,66,0,78,0,81,0,78,0,81,0,64,0,49,0,15,0,0,0,0,0 },
  { 0,0,0,0,0,0,24,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,24,24,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,24,0,24,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,54,0,54,0,18,0,18,0,18,0,18,0,18,0,18,0,18,0,18,0,18,0,0,0,0,0 },
  { 0,0,0,0,0,0,24,0,24,0,0,0,24,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,24,0,0,0,24,0,0,0,24,0,8,0,8,0,8,0,8,0,8,0,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,102,0,0,0,24,0,0,0,24,0,8,0,8,0,8,0,8,0,8,0,8,0,0,0,0,0 },
  { 8,0,20,0,73,0,62,0,0,0,119,0,0,0,26,0,44,0,8,0,8,0,8,0,8,0,8,0,8,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,0,0,0,24,0,165,0,165,0,24,0,0,0,24,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,24,0,36,0,36,0,24,0,0,0,60,0,0,0,24,0,36,0,36,0,24,0,0,0,0,0 },
  { 0,0,255,0,231,0,129,0,165,0,129,0,255,0,177,0,141,0,227,0,19,0,9,0,5,0,3,0,3,0,1,0 },
  { 0,2,127,130,127,130,96,2,127,254,127,254,1,130,127,130,127,130,0,2,127,254,0,130,127,254,64,2,127,254,0,2 },
  { 0,17,0,137,4,73,34,74,18,82,18,148,19,252,87,20,88,20,88,36,87,196,80,8,55,240,24,0,16,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,2,0,1,0,25,0,37,0,38,0,24,1,144,2,96,2,64,1,128,9,0,6,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,8,0,8,0,8,0,8,0,8,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,0,36,0,36,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,34,0,85,0,85,0,34,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,0,20,0,20,0,8,0,34,0,85,0,85,0,34,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,8,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,34,0,85,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,82,0,37,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,14,0,17,0,33,0,33,0,34,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,6,0,11,0,17,0,1,0,2,0,4,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,30,0,33,0,1,0,2,0,14,0,17,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,30,0,33,0,2,0,14,0,1,0,2,0,30,0,33,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,18,0,44,0,64,0,65,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,34,0,68,0,68,0,60,0,4,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,64,0,68,0,40,0,39,0,17,0,17,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,1,0,49,0,74,0,18,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,8,0,16,0,32,0,112,0,8,0,4,0,2,0,1,0,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,28,0,34,0,36,0,73,0,78,0,64,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,12,0,22,0,34,0,15,0,116,0,8,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,60,0,66,0,15,0,116,0,28,0,34,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,60,0,66,0,4,0,31,0,114,0,4,0,60,0,66,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,18,0,44,0,70,0,73,0,126,0,32,0,64,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,34,0,78,0,85,0,60,0,68,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,64,0,69,0,42,0,39,0,25,0,17,0,46,0,64,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,1,0,49,0,79,0,114,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,8,0,16,0,32,0,114,0,13,0,52,0,66,0,1,0,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,3,0,29,0,42,0,52,0,105,0,78,0,64,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,29,0,34,0,70,0,74,0,84,0,56,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,0,24,0,0,0,16,0,28,0,4,0,16,0,28,0,4,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,85,0,42,0,28,0 },
  { 0,0,0,0,0,0,0,0,24,0,24,0,0,0,102,0,102,0,0,0,24,0,24,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,36,0,36,0,24,0 },
  { 51,0,74,0,82,0,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 7,0,4,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,128,9,64,20,144,196,40,56,144,1,64,0,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,2,0,5,32,18,80,40,70,18,56,5,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,2,0,2,0,4,0,8,0,8,0,24,0,32,0,32,0,32,0,32,0,32,0,32,0,64,0,0,0 },
  { 0,0,0,0,32,0,32,0,16,0,8,0,8,0,12,0,2,0,2,0,2,0,2,0,2,0,2,0,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,2,0,2,0,2,0,2,0,2,0,2,0,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,64,0,64,0,64,0,64,0,64,0,64,0,128,0,0,0 },
  { 0,0,0,0,0,0,63,0,21,0,101,0,5,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,0,73,0,77,0,75,0,65,0,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,0,73,0,105,0,89,0,9,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,0,73,0,105,0,89,0,9,0,31,0,32,0,78,0,49,0,17,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,30,0,32,0,64,0,120,0,68,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,62,0,8,0,8,0,78,0,49,0,17,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,62,0,8,0,8,0,62,0,73,0,73,0,54,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,30,0,32,0,60,0,64,0,124,0,66,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,109,206,109,182,97,206,125,182,125,206,127,254,0,0 },
  { 0,0,0,0,0,0,56,0,68,0,78,0,17,0,17,0,1,0,1,0,2,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,127,0,1,0,61,0,67,0,65,0,64,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,0,33,0,58,0,44,0,34,0,47,0,48,0,32,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,60,0,2,0,1,0,31,0,33,0,64,0,64,0,64,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,60,0,2,0,1,0,31,0,32,0,94,0,96,0,78,0,49,0,17,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,0,8,0,28,0,18,0,50,0,44,0,32,0,32,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,127,0,64,0,94,0,97,0,65,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,0,33,0,23,0,13,0,17,0,61,0,3,0,1,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,30,0,32,0,64,0,124,0,66,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,30,0,32,0,64,0,124,0,66,0,31,0,32,0,78,0,49,0,17,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,0,4,0,14,0,18,0,19,0,13,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,51,0,33,0,65,0,125,0,67,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,51,0,35,0,69,0,125,0,67,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,0,33,0,65,0,125,0,67,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,0,33,0,65,0,125,0,67,0,31,0,32,0,78,0,49,0,17,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,125,0,9,0,49,0,77,0,75,0,49,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,0,1,0,62,0,8,0,8,0,78,0,49,0,17,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,0,1,0,62,0,8,0,8,0,62,0,73,0,73,0,54,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,0,1,0,30,0,32,0,56,0,64,0,124,0,66,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,0,1,0,30,0,32,0,56,0,64,0,124,0,66,0,31,0,32,0,78,0,49,0,17,0,1,0,0,0 },
  { 0,0,0,0,0,0,49,0,73,0,79,0,9,0,17,0,29,0,19,0,1,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,28,0,34,0,76,0,82,0,83,0,77,0,33,0,1,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,0,1,0,31,0,1,0,61,0,3,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,56,0,68,0,68,0,72,0,28,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,107,0,73,0,73,0,73,0,53,0,3,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,62,0,8,0,28,0,2,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,57,0,69,0,73,0,13,0,3,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,0,17,0,17,0,79,0,49,0,17,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,60,0,34,0,34,0,61,0,35,0,34,0,32,0,32,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,123,0,17,0,41,0,101,0,3,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,30,0,32,0,78,0,49,0,17,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,93,0,73,0,85,0,83,0,75,0,49,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,0,21,0,101,0,5,0,1,0,57,0,37,0,36,0,61,0,34,0,36,0,32,0,0,0 },
  { 0,0,0,0,0,0,124,0,8,0,48,0,76,0,2,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,126,0,84,0,83,0,80,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,0,0 },
  { 0,0,0,0,0,0,31,0,8,0,6,0,25,0,32,0,64,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,115,142,111,182,99,182,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,115,134,111,190,99,142,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,115,134,111,190,99,142,109,190,115,190,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,206,125,182,123,182,119,182,119,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,40,0,4,0,0,0,0,0,0,0 },
  { 112,0,72,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 112,0,72,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,63,0,66,0,66,0,4,0,28,0,34,0,2,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,36,0,28,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,0,66,0,66,0,4,0,12,0,66,0,34,0,28,0 },
  { 112,0,72,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,114,0,10,0,6,0,2,0,0,0,0,0,0,0 },
  { 112,0,72,0,4,0,0,0,0,0,0,0,0,0,2,0,122,0,6,0,63,0,66,0,4,0,28,0,34,0,0,0 },
  { 112,0,72,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,0,82,0,94,0,2,0 },
  { 112,0,72,0,4,0,0,0,0,0,0,0,0,0,50,0,94,0,2,0,63,0,66,0,4,0,28,0,34,0,0,0 },
  { 224,0,24,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 204,0,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 207,0,40,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 69,0,238,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 16,0,40,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,24,0,36,0,36,0,24,0,0,0,24,0,36,0,36,0,24,0,0,0,0,0,0,0,0,0 },
  { 28,0,36,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 28,0,36,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,63,0,66,0,66,0,4,0,28,0,34,0,2,0 },
  { 8,0,8,0,12,0,34,0,93,0,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 8,0,20,0,73,0,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,6,0,2,0,3,0,1,0,1,0,1,0 },
  { 0,0,0,0,0,0,0,0,0,0,56,0,68,0,68,0,8,0,28,0,18,0,18,0,10,0,2,0,2,0,1,0 },
  { 16,0,16,0,16,0,36,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 16,0,16,0,16,0,16,0,16,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,63,128,10,0,4,0,10,0,63,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,54,0,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,238,0,170,0,170,0,170,0,186,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,58,0,74,0,74,0,46,0,0,0,0,0 },
  { 0,0,73,0,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,0,34,0,20,0,8,0,20,0,34,0,127,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,0,73,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,0,54,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,0,21,0,37,0,1,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,0,73,0,77,0,75,0,65,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,0,73,0,121,0,9,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,0,73,0,121,0,1,0,30,0,32,0,78,0,49,0,17,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,32,0,124,0,66,0,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,0,8,0,78,0,49,0,14,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,0,8,0,62,0,73,0,54,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,32,0,56,0,64,0,126,0,65,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,115,206,109,182,113,206,125,182,115,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,68,0,14,0,17,0,1,0,2,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,0,1,0,61,0,67,0,65,0,64,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,0,68,0,120,0,68,0,126,0,64,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,0,2,0,31,0,33,0,64,0,64,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,0,2,0,31,0,32,0,126,0,81,0,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,30,0,8,0,28,0,50,0,76,0,64,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,0,64,0,94,0,97,0,65,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,0,17,0,15,0,17,0,63,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,32,0,124,0,66,0,1,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,32,0,124,0,66,0,31,0,32,0,78,0,49,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,60,0,8,0,28,0,38,0,25,0,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,0,33,0,125,0,3,0,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,0,73,0,125,0,3,0,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,0,33,0,125,0,3,0,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,0,33,0,125,0,3,0,31,0,32,0,78,0,49,0,17,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,121,0,49,0,77,0,51,0,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,60,0,10,0,9,0,76,0,50,0,18,0,12,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,0,9,0,62,0,73,0,73,0,54,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,28,0,34,0,57,0,65,0,124,0,66,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,28,0,34,0,57,0,65,0,124,0,66,0,30,0,32,0,78,0,49,0,17,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,3,0,5,0,3,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,0,34,0,76,0,83,0,77,0,33,0,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,0,1,0,31,0,1,0,63,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,68,0,72,0,28,0,2,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,18,0,28,0,9,0,6,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,57,0,69,0,3,0,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,0,69,0,73,0,29,0,3,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,9,0,47,0,17,0,9,0,1,0,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,36,0,61,0,34,0,36,0,32,0,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,0,41,0,69,0,99,0,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,32,0,78,0,49,0,17,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,0,73,0,85,0,83,0,49,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,0,21,0,101,0,5,0,57,0,36,0,61,0,34,0,32,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,0,73,0,79,0,9,0,29,0,3,0,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,0,73,0,73,0,53,0,3,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,0,8,0,28,0,2,0,1,0,1,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,99,142,109,182,99,182,109,182,99,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,65,0,34,0,20,0,8,0,20,0,34,0,65,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,73,0,34,0,20,0,73,0,20,0,34,0,73,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,28,0,34,0,65,0,65,0,34,0,28,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,0,34,0,34,0,28,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,0,2,0,26,0,36,0,36,0,88,0,64,0,56,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,0,34,0,73,0,85,0,73,0,42,0,28,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,107,0,20,0,8,0,28,0,34,0,34,0,34,0,62,0,65,0,127,0,0,0,0,0,0,0 },
  { 13,96,2,128,1,0,3,128,12,96,25,48,20,80,34,136,33,8,21,80,17,16,13,96,3,128,1,0,2,128,13,96 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,68,42,168,42,168,18,144,15,224,21,80,37,72 },
  { 13,96,2,128,1,0,3,128,140,98,153,50,84,84,162,138,161,10,85,84,145,18,141,98,3,128,1,0,2,128,13,96 },
  { 0,0,13,96,2,128,1,0,63,248,36,72,18,144,18,144,9,32,9,32,4,64,4,64,2,128,2,128,1,0,0,0 },
  { 0,0,0,0,3,128,4,64,9,32,20,80,19,144,40,40,39,200,32,8,32,8,16,16,24,48,7,192,0,0,0,0 },
  { 0,0,7,192,8,32,48,24,32,8,64,4,158,6,161,38,193,6,201,10,192,242,64,4,32,8,48,24,8,32,7,192 },
  { 0,0,7,192,8,32,48,24,60,12,66,76,129,10,145,18,129,226,129,2,130,2,66,68,34,8,50,24,9,32,7,192 },
  { 0,0,7,192,8,32,48,56,33,40,124,36,130,66,129,130,137,34,131,2,132,130,72,124,41,8,56,24,8,32,7,192 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,113,142,111,182,111,182,111,182,113,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,48,24,72,24,72,36,48,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,2,64,1,128,1,128,2,64,0,0,0,0,0,0,36,72,24,48,24,48,36,72,0,0,0,0,0,0 },
  { 0,0,0,0,31,0,32,128,64,68,15,56,16,128,0,128,1,0,7,0,8,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,60,0,66,0,2,0,4,0,28,0,34,0,28,0,34,0,24,0,36,0,4,0,8,0,4,0,2,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,3,128,1,0,0,0,0,0,0,0,7,192,3,128,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,72,96,68,24,52,6,4,1,8,0,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,192,1,32,1,16,0,208,8,16,4,32,3,192,0,0,0,0,0,0 },
  { 0,0,0,0,65,252,65,0,65,0,65,0,65,0,65,0,127,252,1,4,1,4,1,4,1,4,1,4,127,4,0,0 },
  { 0,0,0,0,127,4,1,4,1,4,1,4,1,4,1,4,127,252,65,0,65,0,65,0,65,0,65,0,65,252,0,0 },
  { 0,0,0,0,65,252,65,0,65,0,73,32,65,0,65,0,127,252,1,4,1,4,9,36,1,4,1,4,127,4,0,0 },
  { 0,0,0,0,127,4,1,4,1,4,9,36,1,4,1,4,127,252,65,0,65,0,73,32,65,0,65,0,65,252,0,0 },
  { 0,0,0,0,0,0,64,0,96,0,64,0,0,0,16,2,24,6,16,2,0,0,2,16,7,56,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,2,0,6,0,2,0,0,64,8,96,24,64,8,0,0,8,64,28,224,0,0,0,0,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,99,142,109,182,109,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,99,198,109,190,109,190,109,190,99,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,99,142,109,182,109,182,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,99,134,109,190,109,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,99,134,109,190,109,142,109,190,99,190,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,206,111,182,99,182,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,238,111,206,99,238,111,238,97,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,134,111,246,99,134,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,142,111,246,99,198,111,246,97,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,182,111,182,99,134,111,246,97,246,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,134,111,190,99,134,111,246,97,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,206,111,190,99,142,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,134,111,246,99,238,111,222,97,222,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,206,111,182,99,206,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,206,111,182,99,198,111,246,97,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,134,111,182,99,134,111,182,97,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,142,111,182,99,142,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,198,111,190,99,190,111,190,97,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,142,111,182,99,182,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,134,111,190,99,142,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,134,111,190,99,142,111,190,97,190,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,206,111,182,99,182,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,238,111,206,99,238,111,238,111,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,134,111,246,99,134,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,142,111,246,99,198,111,246,111,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,182,111,182,99,134,111,246,111,246,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,134,111,190,99,134,111,246,111,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,115,134,109,190,109,142,109,190,115,190,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,61,224,66,16,129,8,129,8,129,8,66,16,36,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,0,16,128,0,64,62,64,33,64,16,128,15,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,0,16,128,32,64,32,64,32,64,16,128,9,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,96,0,146,16,33,8,64,132,64,132,64,132,33,8,30,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,0,16,128,32,0,32,0,32,0,16,128,15,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,0,16,128,40,64,40,64,40,64,16,128,15,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,49,224,74,16,4,8,228,8,148,8,74,16,49,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,0,16,128,33,64,32,128,32,96,16,0,15,0,0,0,0,0,0,0,0,0 },
  { 56,64,68,64,162,64,162,64,162,64,68,64,56,64,16,64,16,64,16,64,8,64,7,128,0,0,0,0,0,0,0,0 },
  { 56,64,68,64,2,64,2,64,2,64,68,64,120,64,64,64,64,64,64,64,64,64,127,192,0,0,0,0,0,0,0,0 },
  { 56,224,68,16,2,8,2,8,2,8,69,16,120,224,64,0,64,0,64,8,64,8,127,248,0,0,0,0,0,0,0,0 },
  { 56,0,68,0,128,0,128,0,128,0,100,0,88,0,66,0,62,0,2,0,2,0,3,128,0,0,0,0,0,0,0,0 },
  { 56,68,128,128,128,70,58,2,2,50,66,126,0,0,0,0 },
  { 56,0,68,0,2,0,2,0,2,0,100,0,88,0,66,0,62,0,2,0,2,0,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,56,0,68,128,72,64,16,32,16,32,16,32,8,64,7,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,55,96,72,144,133,8,133,8,133,8,72,144,15,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,49,128,74,64,132,32,132,32,132,32,72,64,48,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,49,128,74,64,132,32,132,32,132,32,74,64,49,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,30,0,33,0,32,128,16,128,3,0,0,128,32,128,31,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,0,8,128,16,64,16,64,16,64,23,64,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,0,8,128,8,0,7,0,0,128,32,64,80,64,63,128,16,0,16,0,16,0,16,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,16,128,32,64,32,64,32,64,16,128,15,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,0,10,128,18,64,18,64,18,64,17,64,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,128,23,64,16,64,16,64,16,64,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,49,128,74,64,4,32,4,32,4,32,72,64,49,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,128,16,64,16,64,16,64,23,64,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,72,64,132,32,132,32,132,32,74,64,49,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,30,0,33,0,81,0,73,0,49,0,1,0,1,0,1,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,49,128,72,64,132,32,132,32,132,32,66,64,49,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,14,0,17,0,32,128,32,128,32,128,17,0,14,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,49,128,72,64,4,32,4,32,4,32,74,64,49,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,74,64,132,32,132,32,132,32,72,64,49,128,0,0,0,0,0,0,0,0 },
  { 56,68,128,128,128,102,26,66,124,64,66,126,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,112,0,137,192,134,32,68,48,24,80,4,144,132,160,120,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,29,192,34,32,66,16,66,16,66,16,34,32,100,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,29,192,34,32,34,32,16,64,0,0,29,192,34,32,34,64,16,120,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,56,224,69,16,130,16,68,16,0,16,62,16,64,16,63,224,0,0,0,0,0,0,0,0 },
  { 56,0,68,0,2,0,2,0,2,0,68,0,120,0,64,0,67,128,68,64,64,64,127,192,0,0,0,0,0,0,0,0 },
  { 56,0,68,0,84,0,108,0,56,0,68,0,2,0,68,0,120,0,67,128,64,64,127,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,128,8,64,23,128,16,0,23,128,8,64,7,128,0,0,0,0,0,0,0,0 },
  { 7,128,8,64,19,32,20,160,16,160,17,32,16,192,16,0,16,32,16,32,8,64,7,128,0,0,0,0,0,0,0,0 },
  { 0,0,255,224,128,0,142,56,145,4,128,130,128,130,128,130,145,68,142,56,128,16,255,240,0,0,0,0,0,0,0,0 },
  { 0,6,15,232,8,8,8,6,8,0,107,54,136,137,248,137,152,201,107,50,8,16,15,240,0,0,0,0,0,0,0,0 },
  { 0,56,0,68,0,66,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,1,0,1,0,6,0,0,0,0,0,0,0,0,0,0 },
  { 1,128,2,64,2,64,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,192,2,32,2,160,2,32,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,128,0,128,0,224 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,64,1,64,1,64,1,112 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,0,32,0,64,0,88,0,104,0,48,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,0,0,128,0,64,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,192,2,160,3,96,2,160,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,128,1,0,2,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,192,2,32,3,128,2,64,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,0,2,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,80,0,32 },
  { 0,0,0,0,0,0,0,0,0,0,0,2,0,5,0,2,0,0,0,2,0,5,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,192,0,128 },
  { 1,128,2,64,2,0,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,0,2,0,2,0,2,0,18,0,18,0,10,0,4 },
  { 127,254,64,2,64,2,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,2,64,2,64,2,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,64,2,32,1,192 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,64,1,192 },
  { 0,0,0,0,0,0,0,0,0,0,49,140,72,66,4,33,4,33,4,33,74,82,49,140,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,13,128,16,64,32,32,32,32,32,32,16,64,13,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,0,16,128,0,64,0,64,0,64,16,128,15,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,1,1,1,1,17,17,14,0,0,0,0 },
  { 0,0,0,0,14,17,1,34,28,16,8,4,2,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,0,8,128,8,0,4,64,3,128,0,128,1,0,2,0,4,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,5,64,5,64,2,64,0,64,0,64,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,4,64,4,0,4,128,5,0,4,192,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,0,8,128,0,128,1,0,2,0,4,0,4,128,3,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,0,8,128,20,64,18,64,18,64,18,64,10,128,6,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,4,64,4,192,5,0,4,128,4,0,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0 },
  { 0,0,0,0,36,36,36,36,36,36,36,36,0,0,0,0 },
  { 24,32,24,56,4,4,56,66,126,2,66,126,0,0,0,0 },
  { 0,48,0,72,0,64,0,32,3,144,5,80,5,80,2,80,0,80,0,80,0,80,3,80,4,16,3,224,0,0,0,0 },
  { 0,0,0,96,0,128,0,132,0,106,6,100,8,128,8,132,9,138,6,100,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,48,0,72,0,64,0,32,1,144,58,80,68,80,184,80,128,80,184,80,68,80,56,80,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,0,8,128,16,64,18,64,16,64,8,128,5,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,5,0,8,128,16,64,18,64,16,64,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,192,5,0,8,128,16,64,16,64,16,64,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,192,5,0,8,128,16,64,16,64,16,64,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,14,17,46,32,32,17,14,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,14,0,17,0,46,0,32,0,32,64,36,128,27,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,3,0,4,0,4,0,2,0,1,0,1,0,17,0,14,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,3,0,4,0,4,0,2,0,1,0,1,0,21,0,10,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,4,64,7,128,4,32,3,192 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,4,64,7,128,4,144,3,96 },
  { 0,0,0,0,0,0,0,0,0,0,3,192,4,32,4,0,4,0,4,32,3,192,1,128,2,64,2,64,0,64,0,48 },
  { 0,0,0,0,0,0,0,0,0,0,3,196,4,164,4,92,4,4,4,4,3,196,0,132,0,132,0,132,0,72,0,48 },
  { 0,0,0,0,0,0,0,0,3,192,4,32,9,144,10,80,10,80,9,144,4,32,3,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,64,4,32,4,32,7,224,4,32,3,208,0,16,1,144,2,144,2,32,1,192 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,3,192,4,160,3,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,128,1,128,2,32,1,192 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,0,2,0,3,192 },
  { 0,0,3,128,4,64,8,32,14,32,9,32,4,160,3,160,0,160,0,160,0,160,7,160,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,2,0,2,0,2,0,2,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,12,0,18,0,2,0,18,0,28,0,16,0,16,0,16,0,16,0,16,0,16 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,4,0,4,0,4,0,4,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,192,4,32,0,32,0,32,4,32,3,192,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,64,4,32,4,32,4,32,4,32,3,208,0,16,0,16,0,16,0,16,0,240 },
  { 0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,0,6,0,10,0,10,0,4,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,4,0,10,0,4,0,0,0,2,0,2,0,2,0,2,0,2,0,14,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,12,0,2,0,2,0,4,0,8,0,8,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,0,10,0,4,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,10,0,2,0,2,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,8,0,8,0,10,0,4,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,0,8,0,8,0,4,0,2,0,2,0,12,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,29,176,34,72,66,68,66,68,66,68,66,68,36,152,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,34,112,65,136,65,4,65,4,65,4,34,68,28,56,0,8,0,8,0,8,0,56 },
  { 0,0,0,0,0,0,0,0,0,0,100,64,34,32,66,16,66,16,66,16,34,32,29,208,0,16,0,16,0,16,0,112 },
  { 2,32,5,80,2,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,192,2,32,2,0,2,32,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,128,1,64,2,32,4,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,64,2,32,2,32,2,32,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,128,8,64,16,32,16,32,16,32,8,64,24,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,19,128,20,64,8,32,0,32,7,160,8,64,7,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,128,8,64,16,160,16,160,16,160,8,160,24,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,56,192,69,32,130,16,130,16,130,16,65,32,48,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,56,192,69,32,130,16,226,16,146,16,73,32,48,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,56,192,68,32,130,16,130,16,130,16,67,32,50,192,2,0,2,0,2,0,3,128 },
  { 0,0,0,0,0,0,0,0,0,0,49,192,74,32,132,16,132,112,132,144,73,32,48,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,56,224,69,16,2,0,2,0,63,224,69,16,56,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,96,224,33,16,66,0,66,0,67,224,69,16,56,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,96,224,33,16,66,0,66,0,67,224,69,16,56,224,0,64,0,64,0,64,1,192 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,128,20,64,20,64,20,64,12,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,56,96,68,16,2,8,2,8,62,8,69,16,56,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,0,8,128,16,64,16,64,20,64,12,128,5,0,4,0,4,0,4,0,28,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,128,0,144,0,96 },
  { 0,0,0,0,0,0,0,0,0,0,0,28,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,7 },
  { 0,0,0,0,0,112,136,96,16,96,136,112,0,0,0,0 },
  { 1,192,2,32,1,0,2,32,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,64,0,160,0,96,0,32,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,10,0,6,0,2,0,4 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,10,0,4,0,0,0,4,0,10,0,6,0,2,0,4 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,10,0,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,21,0,14,0,0,0,8,0,21,0,14,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,10,0,4,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,85,0,34,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,4,64,11,160,8,32,8,32,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,10,0,4,0,0,0,4,0,10,0,12,0,8,0,4 },
  { 0,0,0,0,0,0,0,0,0,0,3,192,4,32,4,32,4,32,4,32,4,32,3,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,0,5,0,1,0,1,0,1,0,1,64,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,11,128,12,64,0,64,0,128,1,0,2,0,2,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,128,0,128,1,0,1,0,2,0,3,128,4,64,4,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,128,0,128,1,128,1,128,2,128,2,128,4,160,4,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,64,0,64,0,64,7,224,8,64,8,64,7,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,128,8,64,8,64,7,224,0,64,0,64,0,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,0,64,0,128,1,0,2,0,4,0,7,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,32,4,32,2,64,3,192,4,32,4,32,3,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,192,4,32,4,32,3,192,2,64,4,32,4,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,0,10,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,0,10,0,6,0,2,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,21,0,8,0,0,0,14,0,21,0,8,0,0,0,0,0,0 },
  { 0,0,1,192,2,32,2,32,0,32,0,32,0,32,0,32,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,128,1,64,0,128,0,0,1,192,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,112,0,0,0,0,0,0 },
  { 0,48,0,72,0,64,0,32,3,16,4,136,8,72,8,72,4,72,0,72,0,72,0,48,0,0,0,0,0,0,0,0 },
  { 0,0,0,128,254,34,64,128,128,128,128,130,70,58,0,0 },
  { 0,0,0,0,104,136,136,136,152,104,8,8,8,14,2,0 },
  { 0,0,0,0,248,136,136,8,8,8,8,8,8,14,2,0 },
  { 0,0,0,0,128,254,18,16,56,68,130,130,68,56,0,0 },
  { 0,0,0,0,124,68,68,4,4,4,4,4,4,4,0,0 },
  { 0,0,0,0,248,136,136,8,14,10,8,8,8,8,0,0 },
  { 0,0,0,0,128,224,32,32,32,44,50,34,34,34,28,0 },
  { 0,0,0,0,48,80,144,144,158,146,144,144,80,48,0,0 },
  { 0,0,0,64,124,4,4,4,4,4,4,4,4,4,0,0 },
  { 0,0,0,0,64,64,88,100,68,68,76,52,4,4,0,0 },
  { 0,0,0,0,0,224,160,32,32,44,50,34,34,34,28,0 },
  { 0,0,0,128,248,8,8,8,126,138,138,136,136,112,0,0 },
  { 0,0,0,4,124,64,64,64,124,68,68,68,68,68,0,0 },
  { 0,0,0,0,112,136,136,136,136,136,136,138,138,116,0,0 },
  { 0,0,0,128,226,34,34,34,34,34,34,34,34,28,0,0 },
  { 0,0,0,64,122,18,34,34,38,26,2,2,2,2,0,0 },
  { 0,0,0,0,16,16,20,26,18,146,144,144,144,96,0,0 },
  { 0,0,0,0,64,64,64,64,72,68,68,68,68,56,0,0 },
  { 0,0,0,0,124,66,66,66,124,64,64,64,64,126,2,0 },
  { 0,0,0,0,112,136,136,136,136,136,136,140,138,114,0,0 },
  { 0,0,0,0,124,146,146,146,124,16,16,16,16,16,0,0 },
  { 0,0,0,0,16,16,16,80,124,20,16,16,16,16,0,0 },
  { 0,0,0,0,60,66,66,66,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,36,68,68,68,68,68,76,52,4,4,0,0 },
  { 0,0,0,0,52,68,68,68,76,52,4,68,68,56,0,0 },
  { 0,0,0,0,64,64,64,64,124,68,68,68,68,68,0,0 },
  { 0,0,0,0,28,34,66,64,64,64,64,66,34,28,4,8 },
  { 0,0,0,0,8,8,8,8,62,74,74,72,72,48,0,0 },
  { 0,0,0,0,124,66,66,66,124,64,64,120,68,72,64,64 },
  { 0,0,0,0,0,0,56,68,68,32,16,8,4,66,66,60 },
  { 0,0,0,0,68,68,68,68,68,124,64,64,64,124,4,0 },
  { 0,0,0,128,254,34,34,20,20,8,20,20,34,34,64,128 },
  { 0,0,0,0,240,144,144,16,16,16,18,18,18,12,0,0 },
  { 0,0,0,0,64,64,120,68,70,64,64,64,64,64,0,0 },
  { 0,0,0,64,120,68,2,2,2,2,2,66,68,56,0,0 },
  { 0,0,0,0,52,68,68,68,76,52,4,4,4,4,0,0 },
  { 0,0,0,0,130,130,130,130,68,40,16,16,16,16,0,0 },
  { 0,0,0,0,28,18,18,28,16,124,148,150,144,96,0,0 },
  { 0,0,127,254,123,206,115,182,123,182,123,182,113,206,127,254,127,254,113,206,111,190,111,142,111,182,113,206,127,254,0,0 },
  { 0,0,0,0,0,0,28,34,34,4,8,16,32,66,66,60 },
  { 0,0,127,254,123,206,115,182,123,182,123,182,113,206,127,254,127,254,113,206,111,182,111,206,111,182,113,206,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,182,123,182,113,206,127,254,127,254,113,206,111,182,111,198,111,246,113,206,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,182,123,182,113,206,127,254,127,254,113,134,111,182,111,134,111,182,113,182,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,182,123,182,113,206,127,254,127,254,113,142,111,182,111,142,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,182,123,182,113,206,127,254,127,254,113,198,111,190,111,190,111,190,113,198,127,254,0,0 },
  { 0,0,0,0,124,4,4,8,16,16,32,32,64,124,0,0 },
  { 0,0,127,254,123,206,115,182,123,182,123,182,113,206,127,254,127,254,113,134,111,190,111,142,111,190,113,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,182,123,182,113,206,127,254,127,254,113,134,111,190,111,142,111,190,113,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,16,16,12,2,2,66,60,0,0 },
  { 0,0,0,0,32,48,16,16,60,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,48,72,72,8,8,60,66,66,66,66,60 },
  { 0,0,0,0,0,0,0,44,82,82,82,82,76,32,28,2 },
  { 0,0,0,0,60,66,66,2,2,2,2,2,2,66,66,60 },
  { 0,0,0,0,0,0,60,66,66,2,28,2,2,66,66,60 },
  { 0,0,0,0,32,80,80,84,56,28,18,18,18,12,0,0 },
  { 0,0,0,0,0,0,0,52,74,74,74,74,74,50,0,0 },
  { 0,0,0,0,0,0,0,60,66,66,66,66,66,36,0,0 },
  { 0,0,0,0,0,0,12,2,2,2,28,2,2,66,66,60 },
  { 0,0,0,0,0,0,0,42,85,85,85,65,66,64,62,1 },
  { 0,0,0,0,60,66,66,2,2,62,66,66,66,60,0,0 },
  { 0,0,0,0,2,60,64,64,64,124,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,0,40,84,84,84,84,68,36,0,0 },
  { 0,0,0,0,32,24,4,2,2,28,2,66,66,60,0,0 },
  { 0,0,0,0,0,0,0,6,10,82,82,34,2,34,34,28 },
  { 0,0,0,0,4,56,64,104,84,84,84,84,68,36,0,0 },
  { 0,0,0,0,64,64,64,72,80,72,68,68,68,56,0,0 },
  { 0,0,0,0,24,36,36,60,102,102,90,66,66,66,66,60 },
  { 0,0,0,0,0,0,0,108,18,18,2,2,2,34,34,28 },
  { 0,0,0,0,0,0,0,52,74,74,74,74,52,2,2,28 },
  { 0,0,0,0,4,12,4,4,4,28,36,4,4,4,68,56 },
  { 0,0,0,0,0,0,0,40,84,84,84,68,72,64,56,4 },
  { 0,0,0,0,0,0,0,34,66,66,66,38,26,66,66,60 },
  { 0,0,0,0,40,84,84,4,4,28,36,36,36,24,0,0 },
  { 0,0,0,0,56,68,120,64,92,98,66,66,66,66,0,0 },
  { 0,0,0,0,0,0,76,66,66,66,92,66,66,66,66,60 },
  { 0,0,0,0,4,2,2,2,2,62,66,66,66,60,0,0 },
  { 0,0,0,0,40,84,84,64,64,124,68,68,40,40,16,16 },
  { 0,0,0,0,8,24,40,8,8,25,38,29,4,4,68,56 },
  { 0,0,0,0,64,64,64,72,80,120,68,68,68,56,0,0 },
  { 0,0,0,0,0,0,0,0,66,36,24,24,36,66,32,64 },
  { 0,0,16,12,2,18,12,2,18,12,2,66,66,60,0,0 },
  { 0,0,80,76,66,82,76,66,82,76,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,60,66,66,66,66,36,24,126,0,0 },
  { 0,0,0,0,0,0,62,2,4,8,28,2,2,66,66,60 },
  { 0,0,0,0,8,16,12,2,2,2,28,2,2,66,66,60 },
  { 0,0,0,0,0,56,68,68,62,4,62,68,68,56,0,0 },
  { 0,0,0,0,32,16,16,16,56,84,84,56,16,16,16,8 },
  { 0,0,0,0,0,0,60,66,66,4,8,16,32,66,66,60 },
  { 0,0,0,0,0,0,0,68,66,66,66,100,88,66,66,60 },
  { 0,0,0,0,0,60,66,66,66,66,60,16,16,18,18,12 },
  { 0,0,0,0,0,0,60,66,66,48,12,28,34,64,0,0 },
  { 0,0,0,0,0,0,48,48,6,6,48,48,0,0,0,0 },
  { 0,0,2,28,32,32,60,34,34,28,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,60,66,66,32,16,8,4,66,66,60 },
  { 0,0,0,0,0,0,0,192,34,28,34,34,34,28,0,0 },
  { 0,0,0,0,0,0,0,0,0,28,34,34,34,28,0,0 },
  { 0,0,0,0,127,128,0,128,0,128,0,128,0,128,1,0,1,0,2,0,4,0,24,0,96,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,123,128,8,128,8,128,8,128,8,128,17,0,17,0,34,0,68,0,8,0,0,0,0,0,0,0 },
  { 0,0,32,0,32,0,32,0,32,0,63,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,63,128,32,0,32,0,32,0,63,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,59,128,34,0,34,0,34,0,59,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,128,0,128,63,128,32,0,63,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,63,128,32,128,32,128,32,128,63,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,32,128,32,128,63,128,32,128,63,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,42,128,42,128,59,128,42,128,59,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,0,4,0,4,0,10,0,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,17,0,17,0,17,0,42,128,68,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,0,17,0,17,0,17,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,63,128,1,0,2,0,13,0,48,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,59,192,8,128,21,0,34,128,4,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 14,0,0,0,63,128,2,0,13,0,48,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,63,128,0,128,63,128,0,128,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,63,128,32,0,63,128,32,0,63,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,128,18,0,18,0,18,0,127,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,0,0,0,63,128,0,0,31,0,32,128,32,128,32,128,31,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,33,252,32,4,32,4,32,4,63,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,32,64,32,64,32,64,32,64,62,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,32,124,32,64,32,64,32,64,62,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,32,68,32,68,32,124,32,68,62,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,62,124,32,4,32,4,32,4,62,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,62,64,2,64,62,64,32,64,62,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,62,124,2,4,62,124,32,64,62,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,62,48,2,252,62,48,32,72,62,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,31,248,0,8,31,248,16,0,31,248,3,192,4,32,4,32,3,192,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,62,68,34,68,34,124,34,68,62,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,31,252,16,4,16,4,16,4,31,252,0,0,0,0,0,0,3,224,4,16,4,16,4,16,3,224,0,0,0,0 },
  { 0,0,34,124,34,4,62,4,34,4,62,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,34,64,34,64,62,64,34,64,62,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,34,124,34,64,62,64,34,64,62,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,34,16,34,16,62,16,34,40,62,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,72,158,72,130,120,130,73,66,122,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,72,142,72,136,120,136,73,72,122,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,73,36,73,36,121,60,74,164,124,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,72,136,72,136,120,136,73,84,122,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,73,62,73,4,121,8,74,148,124,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,34,124,34,8,62,16,34,40,62,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,56,34,0,34,124,62,16,34,40,62,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,34,124,34,64,62,124,34,64,62,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,34,124,34,40,62,40,34,40,62,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,8,8,15,248,8,8,15,248,1,192,2,32,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,34,68,62,124,34,68,62,124,3,192,4,32,3,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,124,4,4,4,4,10,4,17,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,64,4,64,4,64,10,64,17,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,124,4,64,4,64,10,64,17,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,124,4,4,4,124,10,64,17,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,124,4,68,4,68,10,68,17,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,68,4,68,4,124,10,68,17,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,17,46,17,34,17,226,41,34,69,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,8,136,8,136,8,136,21,84,34,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,56,4,68,4,68,10,68,17,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,124,4,8,4,16,10,40,17,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,56,4,0,4,124,4,16,10,40,17,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,124,4,4,4,124,10,4,17,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,124,4,64,4,124,10,64,17,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,124,4,40,4,40,10,40,17,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,48,4,252,4,48,10,72,17,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,64,0,64,1,128,6,128,24,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,32,1,32,2,160,4,80,25,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,128,0,128,1,0,6,128,24,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,128,4,128,5,64,10,48,17,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,2,0,5,0,8,128,16,64,63,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,124,17,4,17,4,17,4,14,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,60,17,32,17,32,17,32,14,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,62,17,34,17,34,17,34,14,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,36,17,36,17,60,17,36,14,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,8,17,8,17,8,17,20,14,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,56,32,68,80,68,136,69,4,57,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,56,17,68,17,68,17,68,14,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,124,17,8,17,16,17,40,14,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,56,14,0,17,124,17,16,17,40,14,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,60,17,32,17,60,17,32,14,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,124,17,40,17,40,17,40,14,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,14,0,17,0,17,0,17,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,62,56,4,68,8,68,20,68,34,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,63,224,0,192,3,128,12,64,48,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,31,240,1,32,2,160,12,80,49,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,31,240,0,96,1,192,6,32,24,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,224,8,64,20,160,35,16,1,140,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 28,0,0,124,62,4,8,124,20,4,34,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,0,0,48,62,252,8,48,20,72,34,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 7,128,0,0,31,192,1,128,6,64,56,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 14,0,0,0,63,0,2,0,13,128,48,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,62,68,20,68,20,124,20,68,62,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,31,248,4,32,31,248,3,192,4,32,3,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,24,48,126,252,28,112,34,136,34,136,28,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 31,240,1,0,7,192,8,32,8,32,7,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,62,124,2,64,2,64,2,64,2,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,16,16,16,16,16,16,40,31,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,124,16,8,16,16,16,40,31,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,112,17,252,16,112,16,136,30,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,62,124,32,4,32,124,32,64,62,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 85,85,128,0,0,1,162,56,34,65,190,64,34,65,162,56,0,1,131,224,2,1,131,128,2,1,130,0,0,1,170,170 },
  { 85,85,128,0,0,1,162,120,34,17,190,16,34,81,162,32,0,1,131,224,2,1,131,128,2,1,130,0,0,1,170,170 },
  { 0,0,0,16,0,16,0,16,0,30,0,16,0,16,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,18,0,18,0,18,0,30,0,18,0,18,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,16,0,16,0,30,0,16,0,30,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,18,0,18,0,18,0,30,0,18,0,30,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,16,0,16,0,112,0,16,0,16,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,18,0,18,0,18,0,114,0,18,0,18,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,16,0,16,0,112,0,16,0,112,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,18,0,18,0,18,0,114,0,18,0,114,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,128,63,254,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,16,0,16,0,30,4,16,4,16,63,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,18,0,18,0,18,0,30,4,18,4,18,63,242,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,16,0,16,0,16,4,16,4,16,63,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,64,2,64,63,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,0,128,0,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,16,0,16,0,16,0,16,0,16,63,144,4,16,4,240,4,16,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,18,0,18,0,18,0,18,0,18,0,18,63,146,4,18,4,242,4,18,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,16,0,16,0,16,0,16,0,16,63,240,4,16,4,16,4,16,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,2,32,2,32,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,63,240,0,16,0,16,0,0,0,0 },
  { 0,0,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,32,0,32,0,32,0,56,0,160,0,160,63,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,16,0,16,0,28,0,16,0,16,63,254,0,128,0,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,0,8,0,14,0,8,0,14,0,136,0,136,63,254,0,0,0,0,0,0,0,0 },
  { 0,8,0,8,0,14,0,8,0,14,2,72,2,72,63,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,8,0,8,0,8,0,56,0,8,0,8,0,136,0,136,63,254,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,4,0,4,0,4,0,28,0,4,0,4,0,4,63,254,0,128,0,128,0,0,0,0,0,0,0,0 },
  { 0,32,0,32,0,32,0,224,0,32,0,32,0,32,0,32,63,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,0,8,0,56,0,8,0,56,0,136,0,136,63,254,0,0,0,0,0,0,0,0 },
  { 0,8,0,8,0,8,0,56,0,8,0,56,0,8,63,254,0,128,0,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,2,0,2,0,2,0,2,0,2,63,254,0,130,0,142,0,2,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,18,0,18,0,18,0,114,0,18,0,18,1,18,1,18,63,242,0,18,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,18,0,18,0,18,0,114,0,18,0,18,1,114,1,18,63,242,0,18,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,63,254,0,128,63,254,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,128,63,254,0,0,63,254,0,128,0,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,16,0,16,0,30,9,16,9,16,63,254,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,164,0,164,0,164,4,188,4,164,4,252,63,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,2,0,2,0,14,0,2,0,14,4,130,4,130,63,254,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,32,63,254,0,128,63,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,2,0,2,0,2,2,66,2,66,63,254,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,0,8,0,8,63,254,2,8,2,8,0,8,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,18,0,18,0,18,63,254,2,18,2,18,0,18,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,8,0,8,0,8,0,8,31,200,2,8,2,120,2,8,63,254,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,10,0,10,0,10,0,10,0,10,0,10,63,234,2,10,2,58,0,10,0,58,0,10,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,0,128,63,254,0,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,8,0,8,0,8,0,8,0,8,0,8,63,254,2,72,2,72,0,8,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,1,0,1,0,1,0,1,0,1,0,1,63,255,2,33,2,47,0,1,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,10,0,10,0,10,0,10,0,10,63,250,4,138,4,186,0,10,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,2,0,2,0,2,0,2,0,2,63,254,2,66,2,78,0,2,0,14,0,2,0,0,0,0,0,0 },
  { 0,0,0,0,0,10,0,10,0,10,0,10,0,10,63,250,4,138,4,186,0,10,0,58,0,10,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,2,32,63,254,0,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,1,0,1,0,1,0,1,0,1,63,255,2,33,2,33,0,1,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,0,0,63,254,0,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,254,0,0,63,254,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,4,0,4,0,4,0,4,0,4,0,4,0,4,15,252,0,4,63,254,0,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,72,0,72,0,72,0,78,0,72,0,72,0,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,72,0,72,0,78,0,72,0,78,0,72,0,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,4,0,4,0,4,0,4,0,4,0,4,0,132,0,132,63,254,0,0,0,0,0,0,0,0 },
  { 0,4,0,4,0,4,0,4,0,4,0,4,0,4,63,254,0,128,0,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,4,0,4,0,4,0,4,0,4,0,4,63,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,0,0,192,0,32,0,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,32,0,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,16,0,16,0,112,12,16,2,16,1,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,96,0,16,0,8,63,254,0,128,0,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,16,0,16,0,16,24,16,4,16,2,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,24,96,4,16,2,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,32,0,32,0,32,0,56,0,32,0,32,63,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,0,8,0,14,0,8,0,14,0,8,0,8,63,254,0,128,0,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,40,0,40,0,46,0,232,0,40,0,238,0,40,0,40,0,40,0,0,0,0,0,0 },
  { 0,0,0,0,0,16,0,16,0,30,1,16,1,16,63,254,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,36,0,36,0,36,0,60,4,36,4,252,63,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,240,0,16,0,16,0,16,0,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,120,1,8,1,8,1,8,1,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,16,1,16,1,16,1,40,1,68,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,4,0,4,0,4,0,7,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,248,8,32,8,32,8,80,15,136,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,48,8,252,8,48,8,72,15,48,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,240,4,0,4,0,4,0,7,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,240,0,16,7,240,4,0,7,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,120,1,8,15,8,8,8,15,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,240,2,144,30,144,16,144,30,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,144,2,144,30,240,16,144,30,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,32,2,32,30,32,16,80,30,136,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,240,2,128,30,240,16,128,30,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,248,2,80,30,80,16,80,30,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,96,3,248,30,96,16,144,30,96,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,240,4,16,4,16,4,16,7,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,16,4,16,7,240,4,16,7,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,32,18,32,30,32,18,80,30,136,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,64,0,192,3,32,28,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,32,1,32,3,160,12,80,49,136,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,192,2,32,2,32,2,32,1,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,240,0,128,0,128,1,64,2,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,224,0,0,7,248,0,64,3,160,12,24,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,240,0,16,7,240,0,16,0,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,240,4,0,7,240,4,0,7,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,240,2,64,2,64,2,64,15,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,192,0,0,7,240,0,0,1,192,2,32,1,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,124,2,4,2,124,2,64,2,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,158,8,130,8,130,9,66,10,34,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,252,32,4,32,4,32,4,63,132,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,124,32,64,32,64,32,64,62,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,32,32,32,32,32,32,80,62,136,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,16,64,40,64,68,64,130,124,254,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,124,32,64,32,124,32,64,62,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,124,32,4,32,4,32,4,62,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,124,32,4,32,124,32,64,62,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,196,8,68,120,68,64,74,120,81,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,64,2,64,62,64,32,64,62,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,124,2,64,62,64,32,64,62,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,247,140,20,63,244,12,132,18,247,140,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,124,2,4,62,124,32,64,62,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,222,10,66,122,66,66,66,123,194,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,196,10,68,122,68,66,74,123,209,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,122,68,10,68,123,196,66,74,123,209,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,244,140,20,191,247,140,132,146,247,140,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,0,120,62,72,2,120,62,48,32,72,62,48,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,136,8,136,120,136,65,84,122,34,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,32,4,80,60,136,33,4,61,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,124,2,4,62,124,32,4,62,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,56,2,254,62,56,32,68,62,56,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,124,34,4,34,4,34,4,62,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,124,34,4,34,124,34,64,62,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,68,34,68,34,124,34,68,62,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,16,17,16,17,16,17,40,31,68,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,68,68,68,68,68,68,170,125,17,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,16,34,40,34,68,34,130,62,254,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,62,0,34,254,34,8,34,52,62,194,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,56,34,254,34,56,34,68,62,56,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,224,8,32,15,224,0,0,3,128,4,64,3,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,124,34,4,62,124,34,64,62,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,124,34,40,62,40,34,40,62,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,56,34,254,62,56,34,68,62,56,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,16,7,240,4,16,7,240,1,192,2,32,1,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,248,4,8,4,8,10,8,17,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,124,4,64,4,64,10,64,17,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,248,8,8,8,248,20,128,34,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,68,4,68,4,124,10,68,17,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,128,4,64,8,32,31,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,124,17,4,17,4,17,4,14,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,220,68,68,68,68,68,68,56,68,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,56,34,68,34,68,34,68,28,56,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,124,34,4,34,124,34,4,28,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,3,128,4,64,4,64,4,64,3,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,32,34,32,34,32,34,80,28,136,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,32,68,80,68,136,69,4,57,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,68,20,68,20,124,20,68,62,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,240,2,64,15,240,3,192,4,32,3,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,64,127,64,28,64,34,64,28,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,124,127,4,28,124,34,64,28,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,124,127,68,28,68,34,68,28,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,68,127,68,28,124,34,68,28,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,15,224,3,128,4,64,3,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,64,2,64,2,64,2,64,2,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,68,2,68,2,124,2,68,2,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,62,0,2,254,2,8,2,52,2,194,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,124,2,4,2,124,2,4,2,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,56,2,254,2,56,2,68,2,56,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,64,32,64,32,64,32,64,62,124,0,0,0,0 },
  { 0,0,0,0,0,0,1,192,48,192,48,192,48,192,48,192,48,192,48,192,49,128,49,128,31,0,14,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,192,48,192,48,192,48,192,48,252,48,204,48,192,49,128,49,128,31,0,14,0,0,0,0,0 },
  { 0,0,0,0,6,96,12,96,12,96,12,96,12,96,7,192,3,192,0,192,1,128,3,0,3,48,3,240,0,0,0,0 },
  { 0,0,0,0,6,96,12,96,12,96,12,96,12,96,7,192,3,192,0,192,1,128,3,0,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,6,96,12,96,12,96,12,96,12,96,7,192,3,192,0,192,1,192,3,64,3,32,3,224,0,0,0,0 },
  { 0,0,0,0,0,0,24,112,24,48,28,48,14,48,6,48,12,48,12,48,12,48,12,96,7,224,3,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,240,48,200,48,216,48,224,48,192,48,192,48,192,49,128,49,128,31,0,14,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,60,12,50,12,54,12,56,108,48,124,48,108,48,12,96,12,96,7,192,3,128,0,0,0,0 },
  { 0,0,0,0,3,0,3,0,3,0,7,128,7,192,12,224,12,96,12,96,12,96,12,96,12,96,12,96,0,0,0,0 },
  { 0,0,0,0,12,0,12,0,12,0,30,0,31,0,51,128,49,128,49,128,49,248,49,152,49,128,49,128,0,0,0,0 },
  { 0,0,0,0,12,0,12,0,12,0,30,0,31,0,51,128,49,128,49,128,49,128,49,128,49,152,49,248,0,0,0,0 },
  { 0,0,0,0,3,0,3,0,3,0,7,128,7,192,12,224,12,96,12,96,12,96,0,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,12,0,12,0,12,0,30,0,31,0,51,128,49,128,49,128,49,128,49,240,49,152,49,240,0,0,0,0 },
  { 0,0,0,0,3,0,3,0,3,0,7,128,7,192,12,224,12,96,24,96,24,96,30,96,27,96,30,96,0,0,0,0 },
  { 0,0,0,0,12,0,12,0,12,0,30,0,31,0,51,128,49,128,49,248,49,172,49,184,49,128,49,128,0,0,0,0 },
  { 0,0,0,0,3,0,3,0,3,0,7,128,7,192,12,224,12,96,12,96,12,96,0,96,0,96,0,96,3,252,7,14 },
  { 0,0,0,0,1,128,1,128,1,128,1,128,1,128,7,224,13,176,13,176,25,152,25,152,25,152,25,152,0,0,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,6,0,6,0,31,128,54,192,54,192,102,126,102,102,102,96,102,96,0,0,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,6,0,6,0,31,128,54,192,54,192,102,96,102,96,102,102,102,126,0,0,0,0 },
  { 0,0,0,0,1,128,1,128,1,128,1,128,1,128,7,224,13,176,13,176,25,152,0,24,0,24,0,24,0,0,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,6,0,6,0,31,128,54,192,54,192,102,64,102,120,102,76,102,120,0,0,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,7,128,1,128,7,224,13,176,13,176,25,152,25,152,25,152,25,152,0,0,0,0 },
  { 0,0,0,0,1,128,1,128,1,128,1,128,1,128,7,224,13,176,13,176,25,152,24,0,24,0,24,0,0,0,0,0 },
  { 0,0,3,0,3,0,3,0,3,0,3,0,15,192,27,96,27,96,51,48,0,48,0,48,0,48,1,254,3,135,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,252,31,252,17,36,49,100,35,68,38,76,60,120,60,112,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,63,240,127,240,68,144,197,158,141,18,153,50,241,224,241,192,0,0,0,0,0,0 },
  { 0,0,0,0,31,248,63,248,98,136,66,136,69,8,125,248,56,248,0,16,0,16,0,32,0,38,0,62,0,0,0,0 },
  { 0,0,0,0,15,252,31,252,49,68,33,68,34,132,62,252,28,124,0,8,0,8,0,16,0,16,0,16,0,0,0,0 },
  { 0,0,0,0,31,248,63,248,98,136,66,136,69,8,125,248,56,248,0,16,0,16,0,60,0,38,0,60,0,0,0,0 },
  { 0,0,0,0,31,240,31,248,50,136,34,136,34,136,34,248,62,112,30,0,2,0,6,0,12,0,24,0,0,0,0,0 },
  { 0,0,0,0,31,240,31,248,50,136,34,136,34,136,34,248,62,112,30,0,2,0,2,0,2,0,3,0,0,0,0,0 },
  { 0,0,0,0,31,248,63,248,98,136,66,136,69,8,125,248,56,248,0,16,0,16,0,48,0,32,0,32,1,248,3,12 },
  { 0,0,0,0,0,0,0,0,9,152,25,152,25,152,25,152,25,152,25,176,25,240,13,128,7,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,38,192,102,192,102,252,102,204,102,192,102,192,103,192,54,0,30,0,0,0,0,0,0,0 },
  { 0,0,0,0,102,64,102,96,102,96,102,96,102,96,118,224,63,224,0,96,0,96,0,96,0,102,0,126,0,0,0,0 },
  { 0,0,0,0,25,144,25,152,25,152,25,152,25,152,29,184,15,248,0,24,0,24,0,24,0,24,0,24,0,0,0,0 },
  { 0,0,0,0,51,32,51,48,51,48,51,48,51,48,59,112,31,240,0,48,0,48,0,56,0,100,0,120,0,0,0,0 },
  { 0,0,0,0,25,144,25,152,25,152,25,152,25,152,29,184,31,240,28,0,24,0,24,0,24,0,24,0,0,0,0,0 },
  { 0,0,0,0,25,152,25,152,25,152,25,152,25,152,29,184,15,240,3,128,3,0,7,0,14,0,12,0,0,0,0,0 },
  { 0,0,102,64,102,96,102,96,102,96,102,96,118,224,63,224,0,96,0,96,0,96,0,96,0,96,3,252,7,14,0,0 },
  { 0,0,0,0,1,128,1,128,1,128,3,0,7,0,14,0,28,0,24,0,24,0,28,96,15,224,7,224,0,0,0,0 },
  { 0,0,0,0,3,0,3,0,7,0,14,0,28,0,24,0,48,0,56,0,31,240,15,240,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,1,128,1,128,1,128,3,0,7,0,14,0,28,0,24,96,24,112,28,48,15,224,7,192,0,0,0,0 },
  { 0,0,0,0,3,0,3,0,3,0,6,0,14,0,28,0,56,0,48,120,48,248,57,152,31,128,15,0,0,0,0,0 },
  { 0,0,0,0,1,128,1,128,1,128,3,0,7,0,14,0,28,0,24,0,24,0,28,240,15,152,7,240,0,0,0,0 },
  { 0,0,0,0,0,0,7,224,15,224,24,96,24,0,24,0,24,0,24,0,24,0,24,96,31,224,15,192,0,0,0,0 },
  { 0,0,0,0,0,0,7,240,15,152,24,240,24,0,24,0,24,0,24,0,24,0,24,96,31,224,15,192,0,0,0,0 },
  { 0,0,0,0,48,48,28,224,3,0,3,0,6,0,14,0,28,0,56,0,48,120,48,248,57,152,31,128,15,0,0,0 },
  { 0,0,0,0,1,0,1,0,3,128,7,192,12,96,12,96,12,96,12,96,12,96,12,96,12,96,12,96,0,0,0,0 },
  { 0,0,0,0,4,0,4,0,14,0,31,0,49,128,49,128,49,128,49,248,49,152,49,128,49,128,49,128,0,0,0,0 },
  { 0,0,0,0,4,0,4,0,14,0,31,0,49,128,49,128,49,128,49,128,49,128,49,128,49,152,49,248,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,3,128,7,192,12,96,12,96,12,96,12,96,12,96,0,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,2,0,2,0,7,0,15,128,24,192,24,192,24,192,24,192,24,224,24,208,24,200,24,248,0,0,0,0 },
  { 0,0,0,0,0,0,3,0,1,128,1,192,3,224,6,48,6,48,6,48,6,48,6,48,6,48,6,48,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,3,128,7,192,12,96,12,96,12,96,12,96,12,96,12,0,12,0,12,0,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,3,128,7,192,12,96,12,96,12,96,12,96,12,96,0,96,0,96,0,96,1,248,3,12 },
  { 0,0,0,0,48,96,31,192,2,0,7,0,15,128,24,192,24,192,24,192,24,192,24,192,24,192,24,192,0,0,0,0 },
  { 0,0,0,0,48,96,31,192,2,0,7,0,15,128,24,192,24,192,24,252,24,204,24,204,24,192,24,192,0,0,0,0 },
  { 0,0,0,0,48,96,31,192,2,0,7,0,15,128,24,192,24,192,24,192,24,192,24,192,24,204,24,252,0,0,0,0 },
  { 0,0,0,0,24,48,15,224,1,0,3,128,7,192,12,96,12,96,12,96,12,96,0,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,48,96,31,192,2,0,7,0,15,128,24,192,24,192,24,192,24,192,24,248,24,204,24,248,0,0,0,0 },
  { 0,0,0,0,24,96,15,192,1,128,1,192,3,224,3,48,6,48,6,48,6,48,6,48,6,48,6,48,0,0,0,0 },
  { 0,0,0,0,24,48,15,224,1,0,3,128,7,192,12,96,12,96,12,96,12,96,12,0,12,0,12,0,0,0,0,0 },
  { 0,0,0,0,48,96,31,192,2,0,7,0,15,128,24,192,24,192,24,192,24,192,24,192,0,192,0,192,3,240,6,24 },
  { 0,0,0,0,1,128,1,128,1,128,3,240,13,152,25,152,25,176,15,192,1,128,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,3,0,3,0,3,0,7,224,27,48,51,48,51,96,31,128,3,0,3,240,3,48,3,0,0,0,0,0 },
  { 0,0,0,0,3,0,3,0,3,0,7,224,27,48,51,48,51,96,31,128,3,0,3,0,3,48,3,240,0,0,0,0 },
  { 0,0,0,0,1,128,1,128,1,128,3,240,13,152,25,152,25,176,15,192,1,128,3,0,6,0,12,0,0,0,0,0 },
  { 0,0,0,0,3,0,3,0,3,0,7,224,27,48,51,48,51,96,31,128,3,0,3,224,3,48,3,224,0,0,0,0 },
  { 0,0,0,0,6,0,6,0,7,128,1,128,3,240,13,152,25,152,25,176,15,192,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,1,192,2,96,2,192,3,0,7,224,27,48,51,48,51,96,31,128,3,0,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,1,192,2,96,2,192,3,0,7,224,27,48,51,48,51,96,31,128,3,0,51,0,63,0,48,0,0,0 },
  { 0,0,0,0,1,128,1,128,1,128,3,240,13,152,25,152,25,176,15,192,1,248,1,172,1,184,1,128,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,109,206,109,182,97,198,125,246,125,206,127,254,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,15,192,54,108,102,108,102,252,63,7,6,3,6,0,6,0,6,0,0,0,0,0 },
  { 0,0,0,0,1,128,1,128,1,128,3,240,13,152,25,152,25,176,15,192,1,128,1,128,1,128,1,128,7,224,12,48 },
  { 0,0,0,0,1,128,1,128,1,128,3,240,13,152,25,152,25,176,15,192,1,128,1,128,1,240,1,152,7,240,12,0 },
  { 0,0,0,0,6,0,6,24,6,24,15,254,54,102,102,96,102,192,63,0,6,0,6,0,6,0,6,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,109,134,109,190,97,142,125,190,125,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,109,134,109,190,97,142,125,190,125,190,127,254,0,0 },
  { 0,0,0,0,12,48,7,224,1,128,1,128,3,240,13,152,25,152,25,176,15,192,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,24,96,15,192,3,0,3,0,7,224,27,48,51,48,51,96,31,128,3,0,3,240,3,48,0,0,0,0 },
  { 0,0,0,0,24,96,15,192,3,0,3,0,7,224,27,48,51,48,51,96,31,128,3,0,3,48,3,240,0,0,0,0 },
  { 0,0,0,0,12,48,7,224,1,128,1,128,3,240,13,152,25,152,25,176,15,192,1,128,3,0,6,0,0,0,0,0 },
  { 0,0,0,0,24,96,15,192,3,0,7,224,27,48,51,48,51,96,31,128,3,0,3,224,3,48,3,224,0,0,0,0 },
  { 0,0,0,0,48,192,31,128,6,0,7,128,1,128,3,240,13,152,25,152,25,176,15,192,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,12,24,7,240,1,32,1,96,1,128,3,240,13,152,25,152,25,176,15,192,1,128,1,128,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,97,134,111,246,97,238,125,222,97,222,127,254,0,0 },
  { 0,0,0,0,24,96,15,192,3,0,7,224,27,48,51,48,51,96,31,128,3,240,3,88,3,112,3,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,97,206,111,182,97,198,125,246,97,206,127,254,0,0 },
  { 0,0,0,0,48,192,31,128,6,0,6,0,15,192,54,108,102,108,102,252,63,7,6,3,6,0,6,0,0,0,0,0 },
  { 0,0,0,0,12,48,7,224,1,128,1,128,3,240,13,152,25,152,25,176,15,192,1,128,1,128,1,128,7,224,12,48 },
  { 0,0,0,0,12,48,7,224,1,128,1,128,3,240,13,152,25,152,25,176,15,192,1,128,1,240,1,152,7,240,12,0 },
  { 0,0,0,0,48,192,31,128,6,24,6,24,15,254,54,102,102,96,102,192,63,0,6,0,6,0,6,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,97,134,111,190,97,142,125,190,97,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,97,134,111,190,97,142,125,190,97,190,127,254,0,0 },
  { 0,0,0,0,0,0,3,128,7,192,12,96,12,96,12,96,12,96,12,96,12,96,12,96,12,96,12,96,0,0,0,0 },
  { 0,0,0,0,0,0,14,0,31,0,49,128,49,128,49,128,49,248,49,152,49,152,49,128,49,128,49,128,0,0,0,0 },
  { 0,0,0,0,0,0,14,0,31,0,49,128,49,128,49,128,49,128,49,128,49,128,49,128,49,152,49,248,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,7,192,12,96,12,96,12,96,12,96,12,96,0,96,0,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,0,0,7,0,15,128,24,192,24,192,24,192,24,192,24,192,24,192,24,248,24,204,24,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,224,1,240,3,24,3,24,3,24,63,24,51,24,51,24,3,24,3,24,3,24,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,7,192,12,96,12,96,12,96,12,96,12,96,12,0,12,0,12,0,12,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,7,192,12,96,12,96,12,96,12,96,12,96,0,96,0,96,0,96,0,96,1,248,3,12 },
  { 0,0,0,0,48,96,31,192,0,0,7,0,15,128,24,192,24,192,24,192,24,192,24,192,24,192,24,192,0,0,0,0 },
  { 0,0,0,0,48,96,31,192,0,0,7,0,15,128,24,192,24,192,24,252,24,204,24,204,24,192,24,192,0,0,0,0 },
  { 0,0,0,0,48,96,31,192,0,0,7,0,15,128,24,192,24,192,24,192,24,192,24,192,24,204,24,252,0,0,0,0 },
  { 0,0,0,0,48,96,31,192,0,0,7,0,15,128,24,192,24,192,24,192,24,192,24,192,0,192,0,192,0,0,0,0 },
  { 0,0,0,0,96,192,63,128,0,0,14,0,31,0,49,128,49,128,49,128,49,128,49,240,49,152,49,240,0,0,0,0 },
  { 0,0,0,0,12,24,7,240,0,0,1,192,3,224,6,48,6,48,126,48,102,48,102,48,6,48,6,48,0,0,0,0 },
  { 0,0,0,0,48,96,31,192,0,0,7,0,15,128,24,192,24,192,24,192,24,192,24,192,24,0,24,0,0,0,0,0 },
  { 0,0,0,0,48,96,31,192,0,0,7,0,15,128,24,192,24,192,24,192,24,192,24,192,0,192,0,192,3,240,6,24 },
  { 0,0,0,0,7,0,3,0,3,0,3,0,63,240,127,248,99,24,3,0,3,0,3,0,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,7,0,3,0,3,0,3,0,63,240,127,248,99,24,3,0,3,240,3,48,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,7,0,3,0,3,0,3,0,63,240,127,248,99,24,3,0,3,0,3,0,3,48,3,240,0,0,0,0 },
  { 0,0,0,0,7,0,3,0,3,0,3,0,63,240,127,248,99,24,3,0,3,0,7,0,14,0,28,0,0,0,0,0 },
  { 0,0,0,0,7,0,3,0,3,0,3,0,63,240,127,248,99,24,3,0,3,0,3,224,3,48,3,224,0,0,0,0 },
  { 0,0,0,0,6,0,7,0,3,128,1,128,1,128,31,248,63,252,49,140,1,128,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,3,224,3,32,1,96,1,128,31,248,63,252,49,140,1,128,1,128,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,3,128,1,128,1,128,1,128,31,248,63,252,49,140,1,128,1,128,1,128,1,128,1,128,7,224,12,48 },
  { 0,0,0,0,24,24,31,248,63,252,49,140,1,128,31,248,63,252,49,140,1,128,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,24,24,31,248,63,252,49,140,1,128,31,248,63,252,49,140,1,128,1,248,1,152,1,128,0,0,0,0 },
  { 0,0,0,0,24,24,31,248,63,252,49,140,1,128,31,248,63,252,49,140,1,128,1,128,1,152,1,248,0,0,0,0 },
  { 0,0,0,0,48,48,63,240,127,248,99,24,3,0,63,240,127,248,99,24,3,0,7,0,14,0,28,0,0,0,0,0 },
  { 0,0,0,0,48,48,63,240,127,248,99,24,3,0,63,240,127,248,99,24,3,0,3,224,3,48,3,224,0,0,0,0 },
  { 0,0,0,0,48,192,63,192,127,224,102,96,7,0,1,128,31,248,63,252,49,140,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,12,48,31,248,26,88,2,64,1,128,31,248,63,252,49,140,1,128,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,24,24,31,248,63,252,49,140,1,128,31,248,63,252,49,140,1,128,1,128,1,128,1,128,7,224,12,48 },
  { 0,0,0,0,1,128,1,128,1,128,31,128,25,224,0,96,0,96,0,96,0,96,0,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,3,0,3,0,3,0,63,0,51,192,0,192,0,192,0,252,0,204,0,192,0,192,0,192,0,0,0,0 },
  { 0,0,0,0,3,0,3,0,3,0,63,0,51,192,0,192,0,192,0,192,0,192,0,192,0,204,0,252,0,0,0,0 },
  { 0,0,0,0,0,192,0,192,0,192,15,192,12,240,0,48,0,48,0,48,0,224,1,128,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,3,0,3,0,3,0,63,0,51,192,0,192,0,192,0,192,0,192,0,248,0,204,0,248,0,0,0,0 },
  { 0,0,0,0,0,192,0,192,0,192,3,192,6,240,12,48,12,48,0,48,0,48,0,48,0,48,0,48,0,0,0,0 },
  { 0,0,0,0,1,248,3,228,6,56,62,0,54,0,6,0,7,224,3,224,0,96,0,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,1,248,3,228,6,56,62,0,54,0,6,0,7,224,3,224,0,96,0,96,6,96,7,224,6,0,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,126,0,103,128,1,128,1,248,1,172,1,184,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,115,206,109,182,115,198,109,246,115,206,127,254,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,126,0,103,128,1,152,1,152,1,248,1,142,1,134,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,1,128,1,128,1,128,31,128,25,224,0,96,0,96,0,96,0,96,0,96,0,96,0,96,1,248,3,12 },
  { 0,0,0,0,3,0,3,0,3,0,63,0,51,192,0,192,0,192,0,192,0,192,0,192,0,248,0,204,3,248,6,0 },
  { 0,0,0,0,6,0,6,0,6,0,126,48,103,176,1,252,1,140,1,128,1,128,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,115,134,109,190,115,142,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,115,134,109,190,115,142,109,190,115,190,127,254,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,7,128,1,192,1,128,1,128,1,128,3,0,3,0,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,7,128,1,192,1,128,1,128,1,240,3,48,3,0,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,12,0,12,0,12,0,15,0,3,128,3,0,3,0,3,0,6,0,6,0,6,96,7,224,0,0,0,0 },
  { 0,0,0,0,7,192,15,224,24,96,48,0,56,0,31,0,3,128,1,128,1,0,3,0,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,7,128,1,192,1,128,1,128,1,128,3,192,3,32,3,96,3,192,0,0,0,0 },
  { 0,0,0,0,63,192,63,128,49,128,3,0,7,192,0,192,1,128,3,0,3,0,6,0,6,0,12,0,0,0,0,0 },
  { 0,0,0,0,7,240,15,200,24,88,48,48,56,0,31,0,3,128,1,128,1,0,3,0,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,192,15,224,24,96,48,0,56,0,31,0,3,128,1,128,1,0,3,0,3,0,15,192,24,96 },
  { 0,0,0,0,12,48,31,248,17,136,1,128,1,224,0,112,0,96,0,96,0,192,0,192,0,192,0,192,0,0,0,0 },
  { 0,0,0,0,24,96,63,240,35,16,3,0,3,192,0,224,0,192,0,248,1,152,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,24,96,63,240,35,16,3,0,3,192,0,224,0,192,0,192,1,128,1,128,1,152,1,248,0,0,0,0 },
  { 0,0,12,48,31,248,17,136,7,192,15,224,24,96,48,0,56,0,31,0,3,128,1,128,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,24,96,63,240,35,16,3,0,3,192,0,224,0,192,0,192,1,224,1,144,1,176,1,224,0,0,0,0 },
  { 0,0,48,192,127,224,70,32,31,192,63,128,49,128,3,0,7,192,0,192,1,128,3,0,3,0,3,0,0,0,0,0 },
  { 0,0,12,96,31,240,17,16,7,240,15,200,24,88,48,48,56,0,31,0,3,128,1,128,3,0,3,0,0,0,0,0 },
  { 0,0,12,48,31,248,17,136,7,192,15,224,24,96,48,0,56,0,31,0,3,128,1,128,3,0,3,0,15,192,24,96 },
  { 0,0,0,0,6,0,6,0,6,0,7,128,1,128,3,128,3,192,6,224,14,96,12,96,12,96,12,96,0,0,0,0 },
  { 0,0,0,0,24,0,24,0,24,0,30,0,6,0,14,0,15,0,27,128,57,248,49,152,49,128,49,128,0,0,0,0 },
  { 0,0,0,0,24,0,24,0,24,0,30,0,6,0,14,0,15,0,27,128,57,128,49,128,49,152,49,248,0,0,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,7,128,1,128,3,192,6,224,12,96,12,96,12,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,24,0,24,0,24,0,30,0,6,0,14,0,15,0,27,128,57,128,49,240,49,152,49,240,0,0,0,0 },
  { 0,0,0,0,12,0,12,0,14,0,6,0,3,0,3,128,7,192,14,224,12,96,12,96,12,96,12,96,0,0,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,7,128,1,128,3,192,6,224,12,96,12,96,12,96,12,0,12,0,0,0,0,0 },
  { 0,0,24,192,31,192,54,96,6,0,7,128,1,128,3,128,3,192,6,224,14,96,12,96,12,96,12,96,0,0,0,0 },
  { 0,0,0,0,0,0,24,0,25,192,31,224,30,48,6,48,6,48,6,48,6,48,6,48,6,48,6,48,0,0,0,0 },
  { 0,0,0,0,0,0,96,0,103,0,127,128,120,192,24,192,24,192,24,252,24,204,24,192,24,192,24,192,0,0,0,0 },
  { 0,0,0,0,0,0,96,0,103,0,127,128,120,192,24,192,24,192,24,192,24,192,24,192,24,204,24,252,0,0,0,0 },
  { 0,0,0,0,0,0,24,0,25,192,31,224,30,48,6,48,6,48,6,48,6,48,0,48,0,48,0,48,0,0,0,0 },
  { 0,0,0,0,0,0,96,0,103,0,127,128,120,192,24,192,24,192,24,192,24,192,24,248,24,204,24,248,0,0,0,0 },
  { 0,0,0,0,0,0,24,0,25,192,27,224,30,48,12,48,14,48,6,48,6,48,6,48,6,48,6,48,0,0,0,0 },
  { 0,0,0,0,0,0,24,0,25,192,31,224,30,48,6,48,6,48,6,48,6,48,6,0,6,0,6,0,0,0,0,0 },
  { 0,0,0,0,0,0,12,0,12,224,15,240,15,24,3,24,51,24,63,24,51,24,3,0,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,0,0,96,0,102,0,127,0,121,128,25,128,25,248,25,172,25,184,25,128,25,128,25,128,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,99,238,109,206,99,238,109,238,99,198,127,254,0,0 },
  { 0,0,0,0,0,0,96,0,102,0,127,0,121,128,25,152,25,152,25,248,25,142,25,134,25,128,25,128,0,0,0,0 },
  { 0,0,0,0,0,0,24,0,25,192,31,224,30,48,6,48,6,48,6,48,6,48,0,48,0,48,0,48,0,252,1,134 },
  { 0,0,0,0,0,0,96,0,103,0,127,128,120,192,24,192,24,192,24,192,24,192,0,192,0,248,0,204,3,248,6,0 },
  { 0,0,0,0,0,0,96,0,102,48,127,48,121,252,25,140,25,128,25,128,25,128,25,128,25,128,25,128,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,99,206,109,190,99,142,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,99,134,109,246,99,238,109,222,99,222,127,254,0,0 },
  { 0,0,0,0,97,128,63,0,12,0,13,192,15,224,6,48,6,48,6,48,6,48,6,48,6,48,6,48,0,0,0,0 },
  { 0,0,0,0,195,0,126,0,24,0,27,128,31,192,12,96,12,96,12,126,12,102,12,96,12,96,12,96,0,0,0,0 },
  { 0,0,0,0,195,0,126,0,24,0,27,128,31,192,12,96,12,96,12,96,12,96,12,96,12,102,12,126,0,0,0,0 },
  { 0,0,0,0,97,128,63,0,12,0,13,192,15,224,6,48,6,48,6,48,6,48,0,48,0,48,0,48,0,0,0,0 },
  { 0,0,0,0,97,128,63,0,12,0,13,192,15,224,6,48,6,48,6,48,6,48,6,62,6,51,6,62,0,0,0,0 },
  { 0,0,0,0,97,128,63,0,12,0,14,224,15,240,3,24,3,152,1,152,1,152,1,152,1,152,1,152,0,0,0,0 },
  { 0,0,0,0,97,128,63,0,12,0,13,192,15,224,6,48,6,48,6,48,6,48,6,0,6,0,6,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,99,134,109,190,99,142,109,190,99,190,127,254,0,0 },
  { 0,0,0,0,195,0,126,0,24,0,27,128,31,192,12,96,12,126,12,107,12,110,12,96,12,96,12,96,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,113,238,111,206,111,238,111,238,113,198,127,254,0,0 },
  { 0,0,0,0,195,0,126,0,24,0,27,0,31,128,12,204,12,204,12,252,12,199,12,195,12,192,12,192,0,0,0,0 },
  { 0,0,0,0,97,128,63,0,12,0,13,192,15,224,6,112,6,48,6,48,6,48,0,48,0,48,0,48,0,252,1,134 },
  { 0,0,0,0,97,128,63,0,12,0,13,192,15,224,6,112,6,48,6,48,6,48,0,48,0,62,0,51,0,254,1,128 },
  { 0,0,0,0,195,0,126,0,24,12,27,140,31,255,12,99,12,96,12,96,12,96,12,96,12,96,12,96,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,113,206,111,190,111,142,111,182,113,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,113,134,111,246,111,238,111,222,113,222,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,240,29,184,49,152,49,152,51,24,51,48,59,112,31,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,63,192,118,224,198,96,198,96,204,96,204,224,237,198,127,252,0,12,0,0,0,0 },
  { 0,0,0,0,15,240,29,184,49,152,49,152,51,24,59,176,31,224,3,0,3,0,7,0,6,96,7,224,0,0,0,0 },
  { 0,0,0,0,15,240,29,184,49,152,49,152,51,24,59,176,31,224,3,0,3,0,3,0,3,0,7,0,0,0,0,0 },
  { 0,0,0,0,15,240,29,184,49,152,49,152,51,24,59,176,31,224,3,0,3,0,7,128,6,96,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,63,192,118,224,198,96,198,126,204,102,204,194,237,192,127,0,0,0,0,0,0,0 },
  { 0,0,0,0,15,240,29,184,49,152,49,152,51,24,59,176,31,224,3,0,6,0,12,0,24,0,24,0,0,0,0,0 },
  { 0,0,0,0,3,252,7,110,108,102,124,102,108,198,14,236,7,248,0,192,1,128,3,0,6,0,6,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,224,6,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,7,240,6,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,24,192,48,192,48,192,48,192,48,192,48,252,48,204,48,192,31,192,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,0,49,128,97,128,97,128,97,128,63,192,0,192,0,192,1,128,1,152,1,248,0,0,0,0 },
  { 0,0,0,0,0,0,7,192,12,96,24,96,24,96,24,96,15,240,0,48,0,48,0,48,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,0,0,31,0,49,128,97,128,97,128,97,128,63,192,0,192,0,192,1,240,1,152,1,240,0,0,0,0 },
  { 0,0,1,128,1,128,1,128,7,224,14,48,12,48,12,48,12,48,12,48,12,48,12,48,7,240,6,0,0,0,0,0 },
  { 0,0,0,0,3,192,6,96,12,48,12,48,12,48,14,112,7,224,3,192,7,0,12,0,12,0,12,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,134,123,190,113,134,127,254,127,254,99,134,109,246,109,238,109,222,99,222,127,254,0,0 },
  { 0,0,0,0,12,96,12,96,12,96,12,96,12,96,15,224,15,224,12,96,12,96,12,96,12,96,12,96,0,0,0,0 },
  { 0,0,0,0,49,128,49,128,49,128,49,128,49,128,63,128,63,128,49,248,49,152,49,152,49,128,49,128,0,0,0,0 },
  { 0,0,0,0,49,128,49,128,49,128,49,128,49,128,63,128,63,128,49,128,49,128,49,128,49,152,49,248,0,0,0,0 },
  { 0,0,0,0,12,96,12,96,12,96,12,96,15,224,15,224,12,96,12,96,12,96,0,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,24,192,24,192,24,192,24,192,24,192,31,192,31,192,24,192,24,192,24,248,24,204,24,248,0,0,0,0 },
  { 0,0,0,0,28,48,54,48,54,48,6,48,6,48,7,240,7,240,6,48,6,48,6,48,6,48,6,48,0,0,0,0 },
  { 0,0,0,0,12,96,12,96,12,96,12,96,15,224,15,224,12,96,12,96,12,96,12,0,12,0,12,0,0,0,0,0 },
  { 0,0,0,0,12,96,12,96,12,96,12,96,15,224,15,224,12,96,12,96,12,96,0,96,0,96,0,96,1,248,3,12 },
  { 0,0,0,0,28,56,54,108,54,108,6,96,6,96,7,224,7,224,6,96,6,96,6,96,6,96,6,96,0,0,0,0 },
  { 0,0,0,0,56,112,108,216,108,216,12,192,12,192,15,192,15,192,12,252,12,204,12,204,12,192,12,192,0,0,0,0 },
  { 0,0,0,0,56,112,108,216,108,216,12,192,12,192,15,192,15,192,12,192,12,192,12,192,12,204,12,252,0,0,0,0 },
  { 0,0,0,0,28,56,54,108,54,108,6,96,7,224,7,224,6,96,6,96,6,96,0,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,56,112,108,216,108,216,12,192,12,192,15,192,15,192,12,192,12,192,12,248,12,204,12,248,0,0,0,0 },
  { 0,0,97,128,63,0,12,0,28,56,54,108,54,108,6,96,7,224,7,224,6,96,6,96,6,96,6,96,0,0,0,0 },
  { 0,0,0,0,28,56,54,108,54,108,6,96,7,224,7,224,6,96,6,96,6,96,6,0,6,0,6,0,0,0,0,0 },
  { 0,0,0,0,28,56,54,108,54,108,6,96,7,224,7,224,6,96,6,96,6,96,0,96,0,96,0,96,1,248,3,12 },
  { 0,0,0,0,3,128,6,192,12,96,12,96,12,96,12,96,14,192,7,128,3,0,3,0,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,3,128,6,192,12,96,12,96,12,96,12,96,14,192,7,128,3,0,3,240,3,48,3,0,0,0,0,0 },
  { 0,0,0,0,7,0,13,128,24,192,24,192,24,192,24,192,29,128,15,0,6,96,7,248,6,24,6,0,0,0,0,0 },
  { 0,0,0,0,1,192,3,96,6,48,6,48,6,48,6,96,7,192,3,128,1,192,0,96,1,192,3,128,0,0,0,0 },
  { 0,0,0,0,7,0,13,128,24,192,24,192,24,192,24,192,29,128,15,0,6,240,7,152,6,240,6,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,12,192,24,192,24,192,24,192,13,128,15,48,7,48,3,224,62,0,112,0,96,0,0,0 },
  { 0,0,0,0,14,0,27,0,49,128,49,248,49,152,49,128,59,0,30,0,12,0,12,0,12,0,12,0,0,0,0,0 },
  { 0,0,0,0,3,128,6,192,12,96,12,126,12,102,12,96,110,192,127,128,99,0,3,0,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,3,128,7,192,12,64,12,64,12,192,15,128,6,0,3,0,3,0,1,128,31,248,24,24,0,0,0,0 },
  { 0,0,0,0,7,0,15,128,24,128,25,128,31,0,12,0,6,0,31,192,48,192,48,252,1,140,1,128,0,0,0,0 },
  { 0,0,0,0,7,0,15,128,24,128,25,128,31,0,12,0,6,0,31,192,48,192,48,192,1,152,1,248,0,0,0,0 },
  { 0,0,0,0,1,192,3,224,6,32,6,96,7,192,3,0,1,128,15,240,12,48,12,48,0,48,0,48,0,0,0,0 },
  { 0,0,0,0,7,0,15,128,24,128,24,128,25,128,31,0,12,0,6,0,6,0,3,240,63,152,48,240,0,0,0,0 },
  { 0,0,0,0,7,0,15,128,24,248,24,152,25,128,31,0,12,0,6,0,6,0,3,0,63,240,48,48,0,0,0,0 },
  { 0,0,0,0,1,192,3,224,6,32,6,96,7,192,3,128,7,240,12,48,24,0,24,0,24,0,24,0,0,0,0,0 },
  { 0,0,0,0,1,192,3,224,6,32,6,96,7,192,3,0,1,128,15,240,12,48,12,48,0,48,0,48,0,252,1,134 },
  { 0,0,0,0,1,0,1,0,3,128,7,192,12,64,12,192,15,128,6,0,3,0,1,128,15,240,12,48,0,0,0,0 },
  { 0,0,0,0,2,0,2,0,7,0,15,128,24,128,25,128,31,0,12,0,31,192,48,252,49,140,1,128,0,0,0,0 },
  { 0,0,0,0,2,0,2,0,7,0,15,128,24,128,25,128,31,0,12,0,31,192,48,192,49,152,1,248,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,3,128,7,192,12,64,12,192,15,128,6,0,31,224,24,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,4,0,4,0,14,0,31,0,49,0,51,0,62,0,24,0,12,0,6,240,63,152,48,240,0,0,0,0 },
  { 0,0,0,0,2,0,2,0,7,0,15,128,24,248,25,152,31,0,12,0,6,0,3,0,31,224,24,96,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,3,128,7,192,12,64,12,192,15,128,7,240,12,48,24,0,24,0,24,0,0,0,0,0 },
  { 0,128,0,128,1,192,3,224,6,32,6,96,7,192,3,0,1,128,15,240,12,48,12,48,0,48,0,48,0,252,1,134 },
  { 0,0,48,48,31,224,3,0,7,128,12,192,12,64,12,192,7,128,6,0,7,0,3,0,31,224,24,96,0,0,0,0 },
  { 0,0,96,96,63,192,6,0,15,0,25,128,25,128,15,0,6,0,31,192,48,192,48,252,1,140,1,128,0,0,0,0 },
  { 0,0,96,96,63,192,6,0,15,0,25,128,25,128,15,0,6,0,31,192,48,192,48,192,1,152,1,248,0,0,0,0 },
  { 0,0,48,48,31,224,3,0,7,128,12,192,12,192,7,128,3,0,31,224,24,96,24,96,0,96,0,96,0,0,0,0 },
  { 0,0,96,96,63,192,6,0,15,0,25,128,24,128,25,128,15,0,12,0,14,0,7,240,63,152,48,240,0,0,0,0 },
  { 0,0,48,48,31,224,3,0,7,128,12,192,12,124,12,204,7,128,6,0,7,0,3,0,31,224,24,96,0,0,0,0 },
  { 0,0,48,48,31,224,3,0,7,128,12,192,12,192,7,128,7,240,12,48,24,0,24,0,24,0,24,0,0,0,0,0 },
  { 0,0,48,48,31,224,3,0,7,128,12,192,12,192,7,128,3,0,31,224,24,96,24,96,0,96,0,96,3,252,7,14 },
  { 0,0,0,0,0,0,15,128,24,192,24,192,0,192,0,192,0,192,1,128,1,128,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,0,0,31,0,49,128,49,128,1,128,1,128,1,128,3,248,3,24,3,0,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,24,192,24,192,0,192,0,192,0,192,1,128,1,128,1,128,1,152,1,248,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,15,224,12,96,0,96,0,96,0,96,0,192,1,192,7,128,14,0,12,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,24,192,24,192,0,192,0,192,0,192,1,128,1,128,1,240,1,152,1,240,0,0,0,0 },
  { 0,0,0,0,0,0,15,224,25,176,15,48,0,48,0,48,0,96,0,96,0,96,0,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,1,0,7,192,12,96,12,96,0,96,0,64,0,192,0,192,0,192,0,192,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,1,0,7,192,12,96,12,96,0,96,0,64,0,192,0,192,12,192,15,192,12,0,0,0 },
  { 0,0,0,0,0,0,31,0,49,128,49,128,1,128,1,128,1,248,3,172,3,56,3,0,3,0,3,0,0,0,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,123,238,115,206,123,238,123,238,113,198,127,254,0,0 },
  { 0,0,0,0,0,0,31,0,49,128,49,128,1,128,1,176,1,176,3,240,3,28,3,12,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,12,192,12,192,0,192,7,224,6,96,0,96,0,96,0,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,24,192,24,192,0,192,0,192,0,192,1,128,1,128,1,128,1,240,1,152,7,240,12,0 },
  { 0,0,0,0,0,0,31,0,49,176,49,176,1,252,1,140,1,128,3,128,3,0,3,0,3,0,3,0,0,0,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,123,206,115,190,123,142,123,182,113,206,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,123,134,115,246,123,238,123,222,113,222,127,254,0,0 },
  { 0,0,0,0,12,48,7,224,0,0,7,192,12,96,12,96,0,96,0,64,0,192,0,192,0,192,0,192,0,0,0,0 },
  { 0,0,0,0,48,192,31,128,0,0,31,0,49,128,49,128,1,128,1,128,3,248,3,24,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,24,96,15,192,0,0,15,128,24,192,24,192,0,192,0,128,1,128,1,128,1,152,1,248,0,0,0,0 },
  { 0,0,0,0,12,48,7,224,0,0,3,192,7,240,4,48,0,48,0,48,0,224,3,192,7,0,14,0,0,0,0,0 },
  { 0,0,0,0,24,96,15,192,0,0,15,128,24,192,24,192,0,192,0,128,1,128,1,240,1,152,1,240,0,0,0,0 },
  { 0,0,0,0,24,96,15,192,0,0,15,224,25,176,15,48,0,48,0,32,0,96,0,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,12,96,7,192,1,0,7,192,12,96,12,96,0,96,0,64,0,192,0,192,0,192,0,192,0,0,0,0 },
  { 0,0,0,0,24,96,15,192,2,0,15,128,24,192,24,192,0,192,0,128,1,128,1,128,1,128,15,240,12,48,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,13,96,13,96,25,48,25,48,25,48,25,48,25,48,25,48,25,48,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,0,53,128,53,128,100,192,100,192,100,252,100,204,100,192,100,192,100,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,0,53,128,53,128,100,192,100,192,100,192,100,192,100,192,100,204,100,252,0,0,0,0 },
  { 0,0,0,0,0,0,7,192,13,96,13,96,25,48,25,48,25,48,25,48,0,48,0,48,0,48,0,48,0,0,0,0 },
  { 0,0,0,0,0,0,31,0,53,128,53,128,100,192,100,192,100,192,100,192,100,192,100,248,100,204,100,248,0,0,0,0 },
  { 0,0,0,0,0,0,15,224,31,240,19,48,51,24,51,152,49,152,1,128,1,128,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,0,0,7,192,13,96,13,96,25,48,25,48,25,48,25,48,24,0,24,0,24,0,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,192,13,96,13,96,25,48,25,48,25,48,25,48,0,48,0,48,0,48,0,48,0,252,1,134 },
  { 0,0,0,0,0,0,0,0,31,128,63,192,98,96,194,48,194,48,194,48,243,56,218,182,202,178,251,190,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,128,63,192,98,96,194,48,194,63,194,51,243,56,218,180,202,178,251,190,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,128,63,192,98,96,194,48,194,48,194,48,243,48,218,176,202,179,251,191,0,0,0,0 },
  { 0,0,0,0,15,224,31,240,49,24,97,24,113,152,105,88,101,88,125,216,0,24,0,52,0,50,0,62,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,128,63,192,98,96,194,63,194,57,194,55,243,48,218,188,202,178,251,190,0,0,0,0 },
  { 0,0,0,0,0,0,31,192,127,224,198,48,230,56,151,36,243,60,3,0,3,128,3,64,3,32,3,224,0,0,0,0 },
  { 0,0,0,0,15,224,31,240,26,24,50,24,35,24,98,148,98,82,99,156,112,0,104,0,100,0,124,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,224,31,240,49,24,97,24,113,152,105,88,101,88,125,216,0,24,0,48,0,48,0,252,1,134 },
  { 0,0,0,0,1,128,1,128,1,128,3,192,6,96,6,96,3,192,7,224,14,112,12,48,12,48,12,48,0,0,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,15,0,25,128,25,128,15,0,31,128,57,192,48,252,48,204,48,192,0,0,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,15,0,25,128,25,128,15,0,31,128,57,192,48,192,48,204,48,252,0,0,0,0 },
  { 0,0,0,0,1,128,1,128,1,128,3,192,6,96,3,192,7,224,14,112,12,112,12,48,0,48,0,48,0,0,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,15,0,25,128,25,128,15,0,31,128,57,192,48,248,48,204,48,248,0,0,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,15,0,25,248,25,152,15,0,31,128,57,192,48,192,48,192,48,192,0,0,0,0 },
  { 0,0,0,0,1,128,1,128,1,128,3,192,6,96,3,192,7,224,14,112,12,48,12,48,12,0,12,0,0,0,0,0 },
  { 0,0,0,0,3,0,3,0,3,0,7,128,12,192,7,128,15,192,28,192,24,224,24,96,0,96,0,96,1,248,3,12 },
  { 0,0,0,0,0,0,0,0,1,128,3,192,6,96,6,96,3,192,7,224,14,112,12,48,12,48,12,48,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,0,15,0,25,128,25,128,15,0,31,128,57,192,48,252,48,204,48,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,0,15,0,25,128,25,128,15,0,31,128,57,192,48,192,48,204,48,252,0,0,0,0 },
  { 0,0,0,0,0,0,3,0,7,128,12,192,12,192,7,128,15,192,28,192,24,224,24,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,0,15,0,25,128,25,128,15,0,31,128,57,192,48,240,48,216,48,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,0,15,0,25,248,25,152,15,0,31,128,57,192,48,192,48,192,48,192,0,0,0,0 },
  { 0,0,0,0,0,0,3,0,7,128,12,192,12,192,7,128,15,192,28,224,24,96,24,96,24,0,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,0,7,128,12,192,12,192,7,128,15,192,28,192,24,224,24,96,0,96,0,96,1,248,3,12 },
  { 0,0,0,0,0,0,1,224,6,48,12,48,12,48,12,48,15,240,12,48,12,48,12,48,7,240,6,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,24,192,48,192,48,192,48,192,63,192,48,252,48,204,48,192,31,192,24,0,0,0,0,0 },
  { 0,0,0,0,126,0,195,0,195,0,255,0,195,0,195,0,127,0,3,0,3,0,3,0,3,48,3,240,0,0,0,0 },
  { 0,0,126,195,195,255,195,195,127,3,3,3,3,3,0,0 },
  { 0,0,0,0,126,0,195,0,195,0,255,0,195,0,195,0,127,0,3,0,3,0,3,224,3,48,3,224,0,0,0,0 },
  { 0,0,1,128,1,128,1,128,7,224,14,48,12,48,12,48,15,240,12,48,12,48,12,48,7,240,6,0,0,0,0,0 },
  { 0,0,0,0,3,192,6,96,12,48,15,240,12,48,14,112,7,224,3,192,7,0,12,0,12,0,12,0,0,0,0,0 },
  { 0,0,0,0,1,224,3,48,54,24,63,248,54,24,7,56,3,240,1,224,3,128,6,0,6,0,6,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,192,0,64,0,192,1,128,3,0,6,0,15,0,25,128,24,136,15,248,3,232,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,128,1,128,3,0,6,0,12,0,31,0,25,16,25,240,31,192,3,0,6,0,6,0 },
  { 0,0,0,0,0,0,1,128,0,128,1,128,3,0,6,0,12,0,30,48,51,16,49,48,31,224,15,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,0,3,0,6,0,4,0,12,0,28,0,54,0,51,32,31,240,3,16,3,0,3,0 },
  { 0,0,0,0,1,128,0,128,1,128,3,0,6,0,12,0,30,0,51,0,49,48,31,232,7,200,0,112,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,128,25,192,16,192,48,0,48,0,62,0,51,192,55,64,27,0,3,0,3,0,3,0 },
  { 0,0,0,0,0,0,7,224,15,144,24,240,48,0,48,0,48,0,60,0,58,0,49,48,27,96,15,224,0,0,0,0 },
  { 0,0,0,0,0,0,2,0,3,0,6,0,4,0,12,0,28,0,54,0,51,32,31,240,3,16,3,0,15,192,24,96 },
  { 0,0,0,0,12,48,15,240,31,248,25,152,1,128,1,128,1,128,1,128,1,128,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,12,48,15,240,31,248,25,152,1,128,1,128,1,128,1,248,1,152,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,12,48,15,240,31,248,25,152,1,128,1,128,1,128,1,128,1,128,1,128,1,152,1,248,0,0,0,0 },
  { 0,0,0,0,12,48,15,240,31,248,25,152,1,128,1,128,1,128,1,128,3,0,6,0,12,0,8,0,0,0,0,0 },
  { 0,0,0,0,12,48,15,240,31,248,25,152,1,128,1,128,1,128,1,128,1,128,1,240,1,152,1,240,0,0,0,0 },
  { 0,0,0,0,12,48,15,240,31,248,25,152,1,128,1,224,0,96,0,96,0,96,0,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,12,48,15,240,31,248,25,152,1,128,1,128,3,0,3,0,6,0,6,0,6,0,6,0,0,0,0,0 },
  { 0,0,0,0,12,48,15,240,31,248,25,152,1,128,1,128,1,128,1,128,1,128,1,128,1,128,1,128,15,240,28,56 },
  { 0,0,24,24,15,240,1,128,1,128,1,128,3,0,7,0,14,0,28,0,24,96,24,112,28,48,15,224,7,192,0,0 },
  { 28,28,7,240,1,192,15,252,31,252,49,68,33,68,34,132,62,252,28,124,0,8,0,8,0,16,0,16,0,16,0,0 },
  { 0,0,24,24,15,240,1,128,0,128,1,128,3,0,6,0,12,0,30,48,51,16,49,48,31,224,15,128,0,0,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,142,111,182,97,142,125,182,97,142,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,198,111,190,97,190,125,190,97,198,127,254,0,0 },
  { 25,152,25,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 12,48,12,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,9,144,4,32,2,64,25,152,25,152,2,64,4,32,9,144,1,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,3,3,0,0,3,3,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,6,96,6,96,0,0,0,0,6,96,6,96,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,0,0,1,128,1,128,0,0,1,128,1,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,0,0,1,128,1,128,0,0,1,128,1,128,0,0,7,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,0,6,0,0,0,31,128,0,0,6,0,6,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,0,6,0,0,0,3,192,0,0,6,0,6,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,1,128,0,0,0,0,1,128,1,128,0,0,0,0,1,128,1,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,1,128,12,48,12,48,1,128,1,128,12,48,12,48,1,128,1,128,0,0,0,0,0,0 },
  { 0,0,0,0,24,48,15,224,0,0,1,128,1,128,3,0,7,192,12,96,12,96,7,192,0,0,15,224,24,48,0,0 },
  { 0,0,0,0,12,24,7,240,0,0,1,192,3,96,6,96,7,192,6,0,7,192,3,96,1,192,7,240,12,24,0,0 },
  { 0,0,0,0,0,0,12,48,7,224,0,0,7,224,6,96,6,0,6,0,6,0,6,0,0,0,7,224,12,48,0,0 },
  { 0,0,0,0,0,0,12,48,7,224,0,0,3,192,6,96,6,96,6,96,6,96,3,192,0,0,7,224,12,48,0,0 },
  { 0,0,0,0,24,48,15,224,0,0,3,0,3,0,7,224,14,96,12,0,12,96,7,224,0,0,15,224,24,48,0,0 },
  { 0,0,24,48,15,224,0,0,7,128,15,192,12,192,0,192,1,128,1,192,3,96,3,192,0,0,15,224,24,48,0,0 },
  { 0,0,24,48,15,224,0,0,7,128,15,192,12,192,0,192,1,128,1,0,3,32,3,224,0,0,15,224,24,48,0,0 },
  { 0,0,0,0,24,24,15,240,0,0,15,240,13,176,1,128,1,128,1,128,15,240,12,48,0,0,15,240,24,24,0,0 },
  { 0,0,0,0,12,48,7,224,0,0,0,0,6,96,6,96,7,224,6,96,6,64,3,128,0,0,7,224,12,48,0,0 },
  { 0,0,0,0,0,0,12,48,7,224,0,0,1,128,1,128,1,128,1,128,1,128,1,128,0,0,7,224,12,48,0,0 },
  { 0,0,0,0,0,0,24,24,15,240,0,0,7,224,5,160,1,128,3,192,6,96,6,96,0,0,15,240,24,24,0,0 },
  { 0,0,0,0,0,0,24,24,15,240,0,0,5,224,13,176,13,176,13,176,13,176,7,48,0,0,15,240,24,24,0,0 },
  { 0,0,0,0,24,24,15,240,0,0,13,176,13,176,13,176,7,240,0,48,0,48,0,48,0,0,15,240,24,24,0,0 },
  { 0,0,0,0,12,48,7,224,0,0,3,224,6,96,3,224,0,96,0,192,0,192,0,192,0,0,7,224,12,48,0,0 },
  { 0,0,0,0,24,24,15,240,0,0,15,240,13,176,1,128,1,192,0,192,15,240,12,48,0,0,15,240,24,24,0,0 },
  { 0,0,0,0,0,0,12,48,7,224,0,0,3,224,6,176,6,224,6,0,6,96,3,224,0,0,7,224,12,48,0,0 },
  { 0,0,0,0,0,0,48,24,31,240,0,0,31,240,22,208,6,192,6,192,6,192,6,192,0,0,31,240,48,24,0,0 },
  { 0,0,24,48,15,224,0,0,7,192,6,192,1,128,1,192,0,192,1,128,1,128,1,128,0,0,15,224,24,48,0,0 },
  { 0,0,0,0,12,48,7,224,0,0,3,192,6,96,7,192,6,0,3,0,3,0,3,0,0,0,7,224,12,48,0,0 },
  { 0,0,0,0,48,12,31,248,0,0,30,120,51,204,62,248,48,192,24,96,24,96,24,96,0,0,31,248,48,12,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,142,125,182,123,182,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,134,125,190,123,142,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,134,125,190,123,142,119,190,119,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,63,240,127,240,68,144,197,159,141,21,153,55,241,224,241,192,0,0,0,0,0,0 },
  { 0,0,0,0,63,224,127,224,197,44,133,60,138,47,251,227,113,224,0,64,0,64,0,128,0,152,0,248,0,0,0,0 },
  { 0,0,0,0,31,248,63,248,98,136,66,136,69,8,125,248,56,248,0,16,0,16,0,60,0,36,3,252,3,0,0,0 },
  { 0,0,0,0,63,224,127,224,197,62,133,42,138,46,251,224,113,224,16,0,16,0,48,0,32,0,32,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,14,0,31,0,49,128,49,128,49,248,49,168,49,184,49,128,49,128,49,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,14,0,31,0,49,176,49,176,49,252,49,140,49,128,49,128,49,128,49,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,14,0,31,0,49,128,49,128,49,128,49,128,49,128,49,224,49,160,49,224,6,0,6,0 },
  { 0,0,0,0,0,0,0,0,3,128,7,192,12,96,12,96,124,126,108,106,12,110,12,96,12,96,12,96,0,0,0,0 },
  { 0,0,0,0,0,0,0,192,0,64,0,252,1,148,3,28,6,0,15,0,25,176,24,240,15,48,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,0,176,1,240,3,60,6,12,12,0,30,0,51,96,49,224,30,96,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,0,1,0,3,0,6,0,12,0,30,0,17,248,19,168,15,56,6,0,12,0,8,0,12,0 },
  { 0,0,0,0,0,0,0,0,15,128,25,192,16,192,48,0,55,240,51,80,51,112,51,0,31,224,3,96,3,0,3,0 },
  { 0,0,0,0,12,48,15,240,31,248,25,152,1,128,1,128,1,248,1,172,1,184,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,24,96,31,224,63,240,51,48,3,0,3,0,3,96,3,224,3,24,3,24,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,12,48,15,240,31,248,25,152,1,128,1,128,1,128,1,128,1,128,1,240,1,152,15,240,12,0,12,0 },
  { 0,0,0,0,24,96,31,224,63,240,51,48,3,0,3,0,1,248,1,172,1,184,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,24,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,36,36,60,0,0 },
  { 0,0,24,24,0,0,0,24,24,0,0,0,24,24,0,0 },
  { 0,0,0,0,0,0,0,24,24,0,0,0,24,24,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,60,36,36,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,24,0,24,0,56,7,240,120,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,6,6,14,28,96,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,0,72,0,127,254,0,0,0,0 },
  { 0,0,0,0,0,96,96,96,102,126,102,96,96,96,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,115,134,109,182,113,134,125,182,115,182,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,115,142,109,182,113,142,125,182,115,142,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,115,198,109,190,113,190,125,190,115,198,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,115,142,109,182,113,182,125,182,115,142,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,115,134,109,190,113,142,125,190,115,134,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,115,134,109,190,113,142,125,190,115,190,127,254,0,0 },
  { 0,0,0,0,120,36,34,34,34,34,34,34,36,120,0,0 },
  { 0,0,0,0,120,68,66,68,120,80,72,68,68,67,0,0 },
  { 0,0,0,0,127,73,8,8,8,8,8,8,8,8,0,0 },
  { 0,0,0,0,28,8,20,18,33,81,81,81,85,86,0,0 },
  { 0,0,0,0,48,72,72,75,73,78,72,72,72,48,0,0 },
  { 0,0,0,0,0,8,8,0,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,60,66,66,64,32,127,4,66,66,60,0,0 },
  { 0,0,0,0,28,2,114,82,82,82,98,66,66,60,0,0 },
  { 0,0,0,0,112,32,34,42,62,32,32,32,32,112,0,0 },
  { 0,0,0,0,66,66,66,66,66,38,26,2,2,60,0,0 },
  { 0,0,0,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,0,0,0,31,4,4,4,4,4,4,68,68,56,0,0 },
  { 0,0,0,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,0,0,0,16,16,16,16,80,126,82,20,20,24,0,0 },
  { 0,0,0,0,60,34,2,114,34,60,32,32,32,32,0,0 },
  { 0,0,0,0,14,17,17,17,17,31,17,17,85,119,0,0 },
  { 0,0,0,0,124,16,16,18,30,18,16,16,16,124,0,0 },
  { 0,0,0,0,126,66,64,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,0,24,36,36,36,36,24,91,89,90,36,0,0 },
  { 0,0,0,0,82,82,82,74,90,90,102,102,66,66,0,0 },
  { 0,0,0,0,4,10,10,8,56,68,68,68,68,56,0,0 },
  { 0,0,0,0,60,66,66,82,76,64,64,64,64,64,0,0 },
  { 0,0,0,0,60,66,66,64,72,76,74,66,68,56,0,0 },
  { 0,0,0,0,66,66,102,102,90,90,66,66,66,66,0,0 },
  { 0,0,0,0,56,100,98,2,66,114,94,2,2,2,0,0 },
  { 0,0,0,0,24,10,21,32,124,84,20,20,20,28,0,0 },
  { 0,0,0,0,50,74,74,74,78,78,74,74,74,50,0,0 },
  { 0,0,0,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 0,0,0,0,56,16,56,68,2,2,2,66,66,60,0,0 },
  { 0,0,0,0,71,66,66,66,66,38,26,2,114,60,0,0 },
  { 0,0,0,0,60,66,66,66,66,126,66,66,66,60,0,0 },
  { 0,0,0,0,32,120,32,32,32,32,32,39,34,30,0,0 },
  { 0,0,0,0,60,66,66,64,64,78,66,66,70,58,0,0 },
  { 0,0,0,0,48,72,72,72,68,68,68,66,66,71,0,0 },
  { 0,0,0,64,64,64,64,64,92,98,66,66,66,66,0,0 },
  { 0,0,0,0,126,66,2,4,8,16,32,64,66,126,0,0 },
  { 0,0,0,0,28,34,114,2,114,34,30,2,2,2,0,0 },
  { 0,0,0,0,48,72,72,72,74,79,72,72,72,48,0,0 },
  { 0,0,0,0,127,73,8,8,8,8,8,8,73,127,0,0 },
  { 0,0,0,0,12,18,2,66,74,74,74,74,74,52,0,0 },
  { 0,0,0,0,36,90,74,22,40,72,72,72,72,48,0,0 },
  { 0,0,0,0,103,37,36,36,40,40,40,40,40,16,0,0 },
  { 0,0,0,0,65,65,65,65,73,85,81,81,81,46,0,0 },
  { 0,0,0,0,60,66,64,64,60,64,64,70,66,60,0,0 },
  { 0,0,0,0,119,34,34,34,34,62,34,34,34,28,0,0 },
  { 0,0,0,0,6,9,9,9,9,1,29,105,89,102,0,0 },
  { 0,0,0,0,4,12,20,36,68,68,126,4,4,4,0,0 },
  { 0,0,0,0,112,32,32,32,32,60,34,34,34,124,0,0 },
  { 0,0,0,0,28,8,8,8,11,93,104,8,8,28,0,0 },
  { 0,0,0,0,114,77,113,39,64,124,66,66,66,60,0,0 },
  { 0,0,0,0,120,68,66,68,120,80,72,68,68,78,0,0 },
  { 0,0,0,0,112,32,32,32,32,32,32,34,34,28,0,0 },
  { 0,0,0,0,85,85,85,73,89,89,101,101,67,65,0,0 },
  { 0,0,0,0,60,66,79,64,32,31,4,66,66,60,0,0 },
  { 0,0,0,0,126,80,16,16,16,16,16,19,17,14,0,0 },
  { 0,0,0,0,7,2,2,2,2,6,10,18,34,71,0,0 },
  { 0,0,0,0,127,66,2,2,2,6,10,18,34,71,0,0 },
  { 0,0,0,0,65,65,65,34,34,34,20,20,8,8,0,0 },
  { 0,0,0,0,60,66,66,64,48,12,2,66,66,60,0,0 },
  { 0,0,0,0,54,73,98,80,72,72,72,72,40,16,0,0 },
  { 0,0,0,0,24,36,24,36,34,85,85,85,85,34,0,0 },
  { 0,0,0,0,24,36,64,64,64,64,64,66,66,126,0,0 },
  { 0,0,0,0,64,64,64,64,64,64,64,66,66,126,0,0 },
  { 0,0,0,0,60,66,66,64,64,64,64,66,66,60,0,0 },
  { 0,0,0,0,7,34,82,127,18,18,18,18,18,12,0,0 },
  { 0,0,0,0,36,90,89,91,24,36,36,36,36,24,0,0 },
  { 0,0,0,0,124,66,66,66,124,64,64,64,64,64,0,0 },
  { 0,0,0,0,60,66,71,64,64,70,70,66,66,60,0,0 },
  { 0,0,0,0,123,81,18,18,20,20,20,24,24,16,0,0 },
  { 0,0,0,64,64,64,64,67,77,116,68,68,68,68,0,0 },
  { 0,0,0,0,66,68,72,80,96,96,80,72,68,66,0,0 },
  { 0,0,0,0,7,2,2,2,30,34,66,66,34,28,0,0 },
  { 0,0,0,0,48,72,74,69,64,64,69,74,72,48,0,0 },
  { 0,0,0,0,56,68,76,76,64,64,78,68,68,59,0,0 },
  { 0,0,0,0,34,85,85,83,81,49,17,89,85,98,0,0 },
  { 0,0,0,0,60,66,66,114,82,94,66,66,66,60,0,0 },
  { 0,0,0,0,34,85,81,81,97,65,65,65,34,28,0,0 },
  { 0,0,0,0,8,20,18,18,10,6,2,98,100,56,0,0 },
  { 0,0,0,0,60,70,70,64,64,124,66,66,66,60,0,0 },
  { 0,0,0,0,6,9,1,1,1,93,73,73,42,20,0,0 },
  { 0,0,0,0,28,34,34,34,60,34,34,98,50,44,0,0 },
  { 0,0,0,0,28,8,28,34,34,66,66,74,82,76,0,0 },
  { 0,0,0,60,66,66,64,64,92,98,66,66,66,66,0,0 },
  { 0,0,0,0,48,72,74,69,64,64,92,72,72,48,0,0 },
  { 0,0,0,0,124,66,66,66,124,66,66,66,66,124,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,134,111,190,99,134,111,246,111,134,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,123,142,115,246,123,198,123,246,113,142,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,0,0,0,0,126,0,0,0,126,0,0,0,0,0 },
  { 0,0,0,127,65,34,34,34,20,20,20,8,8,8,0,0 },
  { 8,20,8,0,8,8,20,20,20,34,34,34,65,127,0,0 },
  { 0,0,0,8,8,8,20,20,20,34,34,34,65,127,0,0 },
  { 8,8,0,8,8,8,20,20,20,34,34,34,65,127,0,0 },
  { 0,0,0,64,96,80,72,68,66,68,72,80,96,64,0,0 },
  { 16,16,0,64,96,80,72,68,66,68,72,80,96,64,0,0 },
  { 36,36,0,64,96,80,72,68,66,68,72,80,96,64,0,0 },
  { 0,0,0,64,96,80,72,84,82,84,72,80,96,64,0,0 },
  { 0,0,0,64,96,80,72,68,82,68,72,80,96,64,0,0 },
  { 0,0,0,2,6,10,18,34,66,34,18,10,6,2,0,0 },
  { 16,16,0,2,6,10,18,34,66,34,18,10,6,2,0,0 },
  { 0,0,0,127,65,34,34,34,20,84,84,8,8,8,0,0 },
  { 0,0,0,127,65,34,34,34,20,21,21,8,8,8,0,0 },
  { 0,0,0,8,8,8,84,84,20,34,34,34,65,127,0,0 },
  { 0,0,0,8,8,8,21,21,20,34,34,34,65,127,0,0 },
  { 8,8,0,8,8,8,84,84,20,34,34,34,65,127,0,0 },
  { 8,8,0,8,8,8,21,21,20,34,34,34,65,127,0,0 },
  { 0,0,0,0,16,24,20,82,81,18,20,24,16,0,0,0 },
  { 0,0,0,0,64,96,80,73,69,72,80,96,64,0,0,0 },
  { 0,8,8,0,16,24,20,82,81,18,20,24,16,0,0,0 },
  { 0,32,32,0,64,96,80,73,69,72,80,96,64,0,0,0 },
  { 32,32,0,64,98,82,72,68,66,68,72,80,96,64,0,0 },
  { 0,0,0,0,1,3,5,73,81,9,5,3,1,0,0,0 },
  { 0,0,0,0,4,12,20,37,69,36,20,12,4,0,0,0 },
  { 0,2,2,0,1,3,5,73,81,9,5,3,1,0,0,0 },
  { 0,8,8,0,4,12,20,37,69,36,20,12,4,0,0,0 },
  { 4,4,0,2,70,74,18,34,66,34,18,10,6,2,0,0 },
  { 0,0,0,73,73,73,54,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,10,36,112,32,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,40,68,124,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,4,8,16,32,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,32,16,8,4,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,65,65,34,28,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,28,34,65,65,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,48,8,4,4,8,48,0,0,0,0,0,0,0 },
  { 0,0,0,24,36,36,24,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,9,18,36,72,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,36,36,36,36,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,16,56,16,0,0,0,0,0,0 },
  { 0,0,0,124,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,16,124,16,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,124,16,16,16,0,0,0,0,0,0,0,0,0 },
  { 4,2,1,127,65,34,34,34,20,20,20,8,8,8,0,0 },
  { 0,4,2,9,8,8,20,20,20,34,34,34,65,127,0,0 },
  { 0,8,4,66,96,80,72,68,66,68,72,80,96,64,0,0 },
  { 8,4,2,0,6,10,18,34,66,34,18,10,6,2,0,0 },
  { 0,0,0,65,65,34,34,34,20,20,20,8,8,8,0,0 },
  { 8,20,8,0,8,8,20,20,20,34,34,34,65,65,0,0 },
  { 0,0,0,8,8,8,20,20,20,34,34,34,65,65,0,0 },
  { 8,8,0,8,8,8,20,20,20,34,34,34,65,65,0,0 },
  { 0,0,0,64,32,16,8,4,2,4,8,16,32,64,0,0 },
  { 16,16,0,64,32,16,8,4,2,4,8,16,32,64,0,0 },
  { 36,36,0,64,32,16,8,4,2,4,8,16,32,64,0,0 },
  { 0,0,0,64,32,16,8,36,34,36,8,16,32,64,0,0 },
  { 0,0,0,64,32,16,8,4,34,4,8,16,32,64,0,0 },
  { 0,0,0,2,4,8,16,32,64,32,16,8,4,2,0,0 },
  { 16,16,0,2,4,8,16,32,64,32,16,8,4,2,0,0 },
  { 0,0,0,65,65,34,34,34,20,84,84,8,8,8,0,0 },
  { 0,0,0,65,65,34,34,34,20,21,21,8,8,8,0,0 },
  { 0,0,0,8,8,8,84,84,20,34,34,34,65,65,0,0 },
  { 0,0,0,8,8,8,21,21,20,34,34,34,65,65,0,0 },
  { 8,8,0,8,8,8,84,84,20,34,34,34,65,65,0,0 },
  { 8,8,0,8,8,8,21,21,20,34,34,34,65,65,0,0 },
  { 0,0,0,0,16,8,4,66,65,2,4,8,16,0,0,0 },
  { 0,0,0,0,64,32,16,9,5,8,16,32,64,0,0,0 },
  { 0,8,8,0,16,8,4,66,65,2,4,8,16,0,0,0 },
  { 0,32,32,0,64,32,16,9,5,8,16,32,64,0,0,0 },
  { 0,0,0,0,1,2,4,72,80,8,4,2,1,0,0,0 },
  { 0,0,0,0,4,8,16,33,65,32,16,8,4,0,0,0 },
  { 0,2,2,0,1,2,4,72,80,8,4,2,1,0,0,0 },
  { 0,8,8,0,4,8,16,33,65,32,16,8,4,0,0,0 },
  { 36,36,0,2,4,8,16,32,64,32,16,8,4,2,0,0 },
  { 0,0,0,4,8,16,32,16,8,4,0,0,0,0,0,0 },
  { 0,0,0,16,16,16,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,64,80,104,72,72,0,0,0,0,0,0,0,0 },
  { 0,0,0,65,65,65,65,65,65,65,65,65,34,28,0,0 },
  { 8,20,8,28,34,65,65,65,65,65,65,65,65,65,0,0 },
  { 0,0,0,28,34,65,65,65,65,65,65,65,65,65,0,0 },
  { 8,8,0,28,34,65,65,65,65,65,65,65,65,65,0,0 },
  { 0,0,0,112,12,2,2,1,1,1,2,2,12,112,0,0 },
  { 8,8,0,112,12,2,2,1,1,1,2,2,12,112,0,0 },
  { 18,18,0,112,12,2,2,1,1,1,2,2,12,112,0,0 },
  { 0,0,0,112,12,2,2,33,33,33,2,2,12,112,0,0 },
  { 0,0,0,112,12,2,2,1,33,1,2,2,12,112,0,0 },
  { 0,0,0,7,24,32,32,64,64,64,32,32,24,7,0,0 },
  { 8,8,0,7,24,32,32,64,64,64,32,32,24,7,0,0 },
  { 0,0,0,17,17,17,17,17,81,81,17,17,17,14,0,0 },
  { 0,0,0,68,68,68,68,68,69,69,68,68,68,56,0,0 },
  { 0,0,0,14,17,17,17,81,81,17,17,17,17,17,0,0 },
  { 0,0,0,56,68,68,68,69,69,68,68,68,68,68,0,0 },
  { 4,4,0,14,17,17,17,81,81,17,17,17,17,17,0,0 },
  { 16,16,0,56,68,68,68,69,69,68,68,68,68,68,0,0 },
  { 0,0,0,28,2,2,1,65,65,1,1,2,2,28,0,0 },
  { 0,0,0,112,8,8,4,5,5,4,4,8,8,112,0,0 },
  { 8,8,0,28,2,2,1,65,65,1,1,2,2,28,0,0 },
  { 32,32,0,112,8,8,4,5,5,4,4,8,8,112,0,0 },
  { 0,0,0,7,8,8,16,80,80,16,16,8,8,7,0,0 },
  { 0,0,0,28,32,32,64,65,65,64,64,32,32,28,0,0 },
  { 2,2,0,7,8,8,16,80,80,16,16,8,8,7,0,0 },
  { 8,8,0,28,32,32,64,65,65,64,64,32,32,28,0,0 },
  { 0,0,0,7,8,8,80,80,16,80,80,8,8,7,0,0 },
  { 0,0,0,28,32,64,64,64,32,28,0,0,0,0,0,0 },
  { 0,0,0,69,69,69,68,68,68,68,68,68,68,56,0,0 },
  { 0,0,0,57,69,69,68,68,68,68,68,68,68,68,0,0 },
  { 0,1,1,113,12,2,2,1,1,1,2,2,12,112,0,0 },
  { 0,1,1,29,32,32,64,64,64,64,64,32,32,28,0,0 },
  { 0,0,0,56,68,68,68,60,4,4,4,4,4,4,0,0 },
  { 16,40,16,56,68,68,68,120,64,64,64,64,64,64,0,0 },
  { 0,0,0,56,68,68,68,120,64,64,64,64,64,64,0,0 },
  { 16,16,0,56,68,68,68,120,64,64,64,64,64,64,0,0 },
  { 0,0,0,4,4,4,4,4,4,60,68,68,68,56,0,0 },
  { 4,4,0,4,4,4,4,4,4,60,68,68,68,56,0,0 },
  { 10,10,0,4,4,4,4,4,4,60,68,68,68,56,0,0 },
  { 0,0,0,64,64,64,64,64,64,120,68,68,68,56,0,0 },
  { 64,64,0,64,64,64,64,64,64,120,68,68,68,56,0,0 },
  { 0,0,0,14,17,17,81,79,1,1,1,1,1,1,0,0 },
  { 0,0,0,56,68,68,69,61,4,4,4,4,4,4,0,0 },
  { 0,0,0,14,17,17,81,94,16,16,16,16,16,16,0,0 },
  { 0,0,0,56,68,68,69,121,64,64,64,64,64,64,0,0 },
  { 4,4,0,14,17,17,81,94,16,16,16,16,16,16,0,0 },
  { 16,16,0,56,68,68,69,121,64,64,64,64,64,64,0,0 },
  { 0,0,0,1,1,1,1,1,65,79,17,17,17,14,0,0 },
  { 0,0,0,4,4,4,4,4,5,61,68,68,68,56,0,0 },
  { 1,1,0,1,1,1,1,1,65,79,17,17,17,14,0,0 },
  { 4,4,0,4,4,4,4,4,5,61,68,68,68,56,0,0 },
  { 0,0,0,16,16,16,16,16,80,94,17,17,17,14,0,0 },
  { 0,0,0,64,64,64,64,64,65,121,68,68,68,56,0,0 },
  { 16,16,0,16,16,16,16,16,80,94,17,17,17,14,0,0 },
  { 64,64,0,64,64,64,64,64,65,121,68,68,68,56,0,0 },
  { 0,0,0,16,16,16,80,80,16,94,81,17,17,14,0,0 },
  { 0,0,0,32,32,32,56,36,36,24,0,0,0,0,0,0 },
  { 0,0,0,4,4,4,28,36,36,24,0,0,0,0,0,0 },
  { 0,0,0,57,69,69,68,60,4,4,4,4,4,4,0,0 },
  { 0,0,0,57,69,69,68,120,64,64,64,64,64,64,0,0 },
  { 0,0,0,5,5,5,4,4,4,60,68,68,68,56,0,0 },
  { 0,0,0,65,65,65,64,64,64,120,68,68,68,56,0,0 },
  { 0,0,0,56,68,68,68,4,4,4,4,4,4,4,0,0 },
  { 16,40,16,56,68,68,68,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,56,68,68,68,64,64,64,64,64,64,64,0,0 },
  { 16,16,0,56,68,68,68,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,4,4,4,4,4,4,4,68,68,68,56,0,0 },
  { 4,4,0,4,4,4,4,4,4,4,68,68,68,56,0,0 },
  { 10,10,0,4,4,4,4,4,4,4,68,68,68,56,0,0 },
  { 0,0,0,64,64,64,64,64,64,64,68,68,68,56,0,0 },
  { 64,64,0,64,64,64,64,64,64,64,68,68,68,56,0,0 },
  { 0,0,0,14,17,17,81,65,1,1,1,1,1,1,0,0 },
  { 0,0,0,56,68,68,69,5,4,4,4,4,4,4,0,0 },
  { 0,0,0,14,17,17,81,80,16,16,16,16,16,16,0,0 },
  { 0,0,0,56,68,68,69,65,64,64,64,64,64,64,0,0 },
  { 4,4,0,14,17,17,81,80,16,16,16,16,16,16,0,0 },
  { 16,16,0,56,68,68,69,65,64,64,64,64,64,64,0,0 },
  { 0,0,0,1,1,1,1,1,65,65,17,17,17,14,0,0 },
  { 0,0,0,4,4,4,4,4,5,5,68,68,68,56,0,0 },
  { 1,1,0,1,1,1,1,1,65,65,17,17,17,14,0,0 },
  { 4,4,0,4,4,4,4,4,5,5,68,68,68,56,0,0 },
  { 0,0,0,16,16,16,16,16,80,80,17,17,17,14,0,0 },
  { 0,0,0,64,64,64,64,64,65,65,68,68,68,56,0,0 },
  { 16,16,0,16,16,16,16,16,80,80,17,17,17,14,0,0 },
  { 64,64,0,64,64,64,64,64,65,65,68,68,68,56,0,0 },
  { 0,0,0,16,16,16,80,80,16,80,81,17,17,14,0,0 },
  { 0,0,0,32,32,32,32,36,36,24,0,0,0,0,0,0 },
  { 0,0,0,4,4,4,4,36,36,24,0,0,0,0,0,0 },
  { 0,0,0,124,4,4,4,4,4,4,4,4,4,4,0,0 },
  { 16,40,16,124,64,64,64,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,124,64,64,64,64,64,64,64,64,64,64,0,0 },
  { 16,16,0,124,64,64,64,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,4,4,4,4,4,4,4,4,4,4,124,0,0 },
  { 4,4,0,4,4,4,4,4,4,4,4,4,4,124,0,0 },
  { 10,10,0,4,4,4,4,4,4,4,4,4,4,124,0,0 },
  { 0,0,0,64,64,64,64,64,64,64,64,64,64,124,0,0 },
  { 64,64,0,64,64,64,64,64,64,64,64,64,64,124,0,0 },
  { 0,0,0,31,1,1,65,65,1,1,1,1,1,1,0,0 },
  { 0,0,0,124,4,4,5,5,4,4,4,4,4,4,0,0 },
  { 0,0,0,31,16,16,80,80,16,16,16,16,16,16,0,0 },
  { 0,0,0,124,64,64,65,65,64,64,64,64,64,64,0,0 },
  { 4,4,0,31,16,16,80,80,16,16,16,16,16,16,0,0 },
  { 16,16,0,124,64,64,65,65,64,64,64,64,64,64,0,0 },
  { 0,0,0,1,1,1,1,1,65,65,1,1,1,31,0,0 },
  { 0,0,0,4,4,4,4,4,5,5,4,4,4,124,0,0 },
  { 1,1,0,1,1,1,1,1,65,65,1,1,1,31,0,0 },
  { 4,4,0,4,4,4,4,4,5,5,4,4,4,124,0,0 },
  { 0,0,0,16,16,16,16,16,80,80,16,16,16,31,0,0 },
  { 0,0,0,64,64,64,64,64,65,65,64,64,64,124,0,0 },
  { 16,16,0,16,16,16,16,16,80,80,16,16,16,31,0,0 },
  { 64,64,0,64,64,64,64,64,65,65,64,64,64,124,0,0 },
  { 0,0,0,16,16,16,80,80,16,80,80,16,16,31,0,0 },
  { 0,0,0,32,32,32,32,32,32,60,0,0,0,0,0,0 },
  { 0,0,0,12,16,32,32,16,12,0,0,0,0,0,0,0 },
  { 0,0,0,4,4,4,4,4,4,60,0,0,0,0,0,0 },
  { 0,0,0,24,36,8,16,60,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,60,66,2,2,4,8,16,32,66,126,0,0 },
  { 0,0,0,0,0,0,0,0,126,9,9,9,9,6,0,0 },
  { 0,0,0,0,8,20,8,0,63,72,72,72,72,48,0,0 },
  { 0,0,0,0,0,0,0,0,63,72,72,72,72,48,0,0 },
  { 0,0,0,0,0,8,8,0,63,72,72,72,72,48,0,0 },
  { 0,0,0,0,0,0,0,0,6,9,9,9,9,126,0,0 },
  { 0,0,0,0,0,2,2,0,6,9,9,9,9,126,0,0 },
  { 0,0,0,0,0,9,9,0,6,9,9,9,9,126,0,0 },
  { 0,0,0,0,0,0,0,0,48,72,72,72,72,63,0,0 },
  { 0,0,0,0,0,32,32,0,48,72,72,72,72,63,0,0 },
  { 0,0,0,0,0,0,0,0,94,69,5,5,5,2,0,0 },
  { 0,0,0,0,0,0,0,0,121,21,20,20,20,8,0,0 },
  { 0,0,0,0,0,0,0,0,72,84,20,20,20,15,0,0 },
  { 0,0,0,0,0,0,0,0,49,73,72,72,72,62,0,0 },
  { 0,0,0,0,0,8,8,0,72,84,20,20,20,15,0,0 },
  { 0,0,0,0,0,32,32,0,49,73,72,72,72,62,0,0 },
  { 0,0,0,0,0,72,72,0,48,72,72,72,72,63,0,0 },
  { 0,0,0,32,80,80,63,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,65,65,65,34,28,0,0,0,0,0,0,0,0 },
  { 0,0,0,2,5,5,126,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,126,1,1,1,1,6,0,0 },
  { 0,0,0,0,8,20,8,0,63,64,64,64,64,48,0,0 },
  { 0,0,0,0,0,0,0,0,63,64,64,64,64,48,0,0 },
  { 0,0,0,0,0,8,8,0,63,64,64,64,64,48,0,0 },
  { 0,0,0,0,0,0,0,0,6,1,1,1,1,126,0,0 },
  { 0,0,0,0,0,2,2,0,6,1,1,1,1,126,0,0 },
  { 0,0,0,0,0,9,9,0,6,1,1,1,1,126,0,0 },
  { 0,0,0,0,0,0,0,0,48,64,64,64,64,63,0,0 },
  { 0,0,0,0,0,32,32,0,48,64,64,64,64,63,0,0 },
  { 0,0,0,0,0,0,0,0,94,65,1,1,1,2,0,0 },
  { 0,0,0,0,0,0,0,0,121,5,4,4,4,8,0,0 },
  { 0,0,0,0,0,0,0,0,79,80,16,16,16,8,0,0 },
  { 0,0,0,0,0,0,0,0,61,65,64,64,64,32,0,0 },
  { 0,0,0,0,0,4,4,0,79,80,16,16,16,8,0,0 },
  { 0,0,0,0,0,16,16,0,61,65,64,64,64,32,0,0 },
  { 0,0,0,0,0,0,0,0,66,65,1,1,1,62,0,0 },
  { 0,0,0,0,0,0,0,0,9,5,4,4,4,120,0,0 },
  { 0,0,0,0,0,4,4,0,66,65,1,1,1,62,0,0 },
  { 0,0,0,0,0,8,8,0,9,5,4,4,4,120,0,0 },
  { 0,0,0,0,0,0,0,0,72,80,16,16,16,15,0,0 },
  { 0,0,0,0,0,0,0,0,33,65,64,64,64,62,0,0 },
  { 0,0,0,0,0,4,4,0,72,80,16,16,16,15,0,0 },
  { 0,0,0,0,0,16,16,0,33,65,64,64,64,62,0,0 },
  { 0,0,0,32,64,64,63,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,12,48,12,48,12,0,0,0,0,0,0,0,0 },
  { 0,0,0,6,24,96,48,12,2,12,48,96,24,6,0,0 },
  { 0,0,0,64,64,64,64,32,28,4,4,4,4,4,0,0 },
  { 4,10,4,0,4,4,4,8,112,64,64,64,64,64,0,0 },
  { 0,0,0,4,4,4,4,8,112,64,64,64,64,64,0,0 },
  { 4,4,0,4,4,4,4,8,112,64,64,64,64,64,0,0 },
  { 0,0,0,4,4,4,4,4,28,32,64,64,64,64,0,0 },
  { 4,4,0,4,4,4,4,4,28,32,64,64,64,64,0,0 },
  { 10,10,0,4,4,4,4,4,28,32,64,64,64,64,0,0 },
  { 0,0,0,64,64,64,64,64,112,8,4,4,4,4,0,0 },
  { 64,64,0,64,64,64,64,64,112,8,4,4,4,4,0,0 },
  { 0,0,0,16,16,16,80,72,7,1,1,1,1,1,0,0 },
  { 0,0,0,64,64,64,65,33,28,4,4,4,4,4,0,0 },
  { 0,0,0,1,1,1,65,66,28,16,16,16,16,16,0,0 },
  { 0,0,0,4,4,4,5,9,112,64,64,64,64,64,0,0 },
  { 1,1,0,1,1,1,65,66,28,16,16,16,16,16,0,0 },
  { 4,4,0,4,4,4,5,9,112,64,64,64,64,64,0,0 },
  { 0,0,0,1,1,1,65,65,7,8,16,16,16,16,0,0 },
  { 0,0,0,4,4,4,5,5,28,32,64,64,64,64,0,0 },
  { 1,1,0,1,1,1,65,65,7,8,16,16,16,16,0,0 },
  { 4,4,0,4,4,4,5,5,28,32,64,64,64,64,0,0 },
  { 0,0,0,16,16,16,80,80,28,2,1,1,1,1,0,0 },
  { 0,0,0,64,64,64,65,65,112,8,4,4,4,4,0,0 },
  { 16,16,0,16,16,16,80,80,28,2,1,1,1,1,0,0 },
  { 64,64,0,64,64,64,65,65,112,8,4,4,4,4,0,0 },
  { 0,0,0,16,16,16,80,80,28,66,65,1,1,1,0,0 },
  { 0,0,0,32,32,32,48,8,8,8,0,0,0,0,0,0 },
  { 0,0,0,60,66,64,60,2,66,60,0,0,0,0,0,0 },
  { 0,0,0,8,8,8,24,32,32,32,0,0,0,0,0,0 },
  { 0,0,0,64,64,64,62,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,32,32,32,48,8,24,40,16,0,0,0,0,0 },
  { 0,0,0,8,8,8,24,32,48,40,16,0,0,0,0,0 },
  { 32,32,0,32,32,32,48,8,8,0,8,8,0,0,0,0 },
  { 32,0,32,0,0,0,32,8,32,16,32,32,48,64,8,128,9,0,0,128,8,64,8,32,0,16,0,8,0,0,0,0 },
  { 32,0,32,0,0,0,32,28,32,96,32,128,48,128,9,0,9,0,1,0,8,128,8,128,0,96,0,28,0,0,0,0 },
  { 32,0,32,0,0,0,32,128,32,128,32,128,48,128,8,128,8,128,0,240,8,136,8,136,0,136,0,112,0,0,0,0 },
  { 32,0,32,0,0,0,32,128,32,128,32,128,48,128,8,128,8,128,0,128,8,136,8,136,0,136,0,112,0,0,0,0 },
  { 0,0,0,48,72,72,72,8,8,8,9,9,9,6,0,0 },
  { 0,0,0,6,9,9,9,8,8,8,72,72,72,48,0,0 },
  { 8,8,0,6,9,9,9,8,8,8,72,72,72,48,0,0 },
  { 0,0,0,6,1,1,1,1,62,64,64,64,64,48,0,0 },
  { 8,8,0,6,1,1,1,1,62,64,64,64,64,48,0,0 },
  { 0,0,0,48,64,64,64,64,62,1,1,1,1,6,0,0 },
  { 8,8,0,48,64,64,64,64,62,1,1,1,1,6,0,0 },
  { 0,0,0,8,20,20,20,68,68,4,5,5,5,2,0,0 },
  { 0,0,0,32,80,80,80,17,17,16,20,20,20,8,0,0 },
  { 0,0,0,2,5,5,5,68,68,4,20,20,20,8,0,0 },
  { 0,0,0,8,20,20,20,17,17,16,80,80,80,32,0,0 },
  { 0,8,8,2,5,5,5,68,68,4,20,20,20,8,0,0 },
  { 0,32,32,8,20,20,20,17,17,16,80,80,80,32,0,0 },
  { 0,0,0,2,1,1,1,1,78,80,16,16,16,8,0,0 },
  { 0,0,0,8,4,4,4,4,57,65,64,64,64,32,0,0 },
  { 4,4,0,2,1,1,1,1,78,80,16,16,16,8,0,0 },
  { 32,32,0,8,4,4,4,4,57,65,64,64,64,32,0,0 },
  { 0,0,0,8,16,16,16,16,78,65,1,1,1,2,0,0 },
  { 0,0,0,32,64,64,64,64,57,5,4,4,4,8,0,0 },
  { 2,2,0,8,16,16,16,16,78,65,1,1,1,2,0,0 },
  { 16,16,0,32,64,64,64,64,57,5,4,4,4,8,0,0 },
  { 0,0,0,32,64,64,62,1,1,2,0,0,0,0,0,0 },
  { 0,0,0,2,4,8,16,32,126,2,2,2,2,2,0,0 },
  { 32,80,32,64,32,16,8,4,126,64,64,64,64,64,0,0 },
  { 0,0,0,64,32,16,8,4,126,64,64,64,64,64,0,0 },
  { 32,32,0,64,32,16,8,4,126,64,64,64,64,64,0,0 },
  { 0,0,0,2,2,2,2,2,126,32,16,8,4,2,0,0 },
  { 2,2,0,2,2,2,2,2,126,32,16,8,4,2,0,0 },
  { 18,18,0,2,2,2,2,2,126,32,16,8,4,2,0,0 },
  { 0,0,0,64,64,64,64,64,126,4,8,16,32,64,0,0 },
  { 64,64,0,64,64,64,64,64,126,4,8,16,32,64,0,0 },
  { 0,0,0,1,2,4,8,80,95,1,1,1,1,1,0,0 },
  { 0,0,0,4,8,16,32,65,125,4,4,4,4,4,0,0 },
  { 0,0,0,16,8,4,2,65,95,16,16,16,16,16,0,0 },
  { 0,0,0,64,32,16,8,5,125,64,64,64,64,64,0,0 },
  { 16,16,0,16,8,4,2,65,95,16,16,16,16,16,0,0 },
  { 64,64,0,64,32,16,8,5,125,64,64,64,64,64,0,0 },
  { 0,0,0,1,1,1,1,1,95,80,8,4,2,1,0,0 },
  { 0,0,0,4,4,4,4,4,125,65,32,16,8,4,0,0 },
  { 1,1,0,1,1,1,1,1,95,80,8,4,2,1,0,0 },
  { 4,4,0,4,4,4,4,4,125,65,32,16,8,4,0,0 },
  { 0,0,0,16,16,16,16,16,95,65,2,4,8,16,0,0 },
  { 0,0,0,64,64,64,64,64,125,5,8,16,32,64,0,0 },
  { 16,16,0,16,16,16,16,16,95,65,2,4,8,16,0,0 },
  { 64,64,0,64,64,64,64,64,125,5,8,16,32,64,0,0 },
  { 0,0,0,16,16,16,80,80,31,65,66,4,8,16,0,0 },
  { 0,0,0,32,32,60,8,16,32,0,0,0,0,0,0,0 },
  { 0,0,0,0,40,40,84,84,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,16,124,16,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,68,40,16,40,68,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,71,68,68,68,56,0,0 },
  { 0,0,0,0,0,0,0,0,0,113,17,17,17,14,0,0 },
  { 0,0,0,0,0,0,0,0,0,14,17,17,17,113,0,0 },
  { 0,0,0,0,0,16,40,16,0,56,68,68,68,71,0,0 },
  { 0,0,0,0,0,0,0,0,0,56,68,68,68,71,0,0 },
  { 0,0,0,0,0,0,16,16,0,56,68,68,68,71,0,0 },
  { 0,0,0,112,8,4,4,8,112,64,64,64,64,64,0,0 },
  { 32,32,0,112,8,4,4,8,112,64,64,64,64,64,0,0 },
  { 0,0,0,64,64,64,64,64,112,8,4,4,8,112,0,0 },
  { 0,0,0,28,32,64,64,32,28,4,4,4,4,4,0,0 },
  { 8,8,0,28,32,64,64,32,28,4,4,4,4,4,0,0 },
  { 0,0,0,4,4,4,4,4,28,32,64,64,32,28,0,0 },
  { 2,2,0,7,8,16,16,72,71,1,1,1,1,1,0,0 },
  { 8,8,0,28,32,64,64,33,29,4,4,4,4,4,0,0 },
  { 0,0,0,24,32,24,8,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,48,12,48,12,48,0,0,0,0,0,0,0,0 },
  { 0,0,0,96,24,6,12,48,64,48,12,6,24,96,0,0 },
  { 0,0,0,49,73,50,34,34,20,20,20,8,8,8,0,0 },
  { 8,20,8,0,8,8,20,20,20,34,34,50,73,49,0,0 },
  { 0,0,0,8,8,8,20,20,20,34,34,50,73,49,0,0 },
  { 8,8,0,8,8,8,20,20,20,34,34,50,73,49,0,0 },
  { 0,0,0,32,80,40,4,2,1,2,4,8,16,32,0,0 },
  { 8,8,0,32,80,40,4,2,1,2,4,8,16,32,0,0 },
  { 0,0,0,2,5,10,16,32,64,32,16,8,4,2,0,0 },
  { 8,8,0,2,5,10,16,32,64,32,16,8,4,2,0,0 },
  { 4,4,0,0,2,5,10,144,160,16,8,4,2,0,0,0 },
  { 8,8,0,0,4,10,20,33,65,32,16,8,4,0,0,0 },
  { 0,0,0,8,20,40,64,32,16,8,0,0,0,0,0,0 },
  { 0,0,0,49,73,113,65,65,65,65,65,65,34,28,0,0 },
  { 0,0,0,70,73,71,65,65,65,65,65,65,34,28,0,0 },
  { 0,0,0,28,34,65,65,65,65,65,65,113,73,49,0,0 },
  { 0,0,0,28,34,65,65,65,65,65,65,71,73,70,0,0 },
  { 8,8,0,28,34,65,65,65,65,65,65,113,73,49,0,0 },
  { 8,8,0,28,34,65,65,65,65,65,65,71,73,70,0,0 },
  { 0,0,0,48,76,50,2,1,1,1,2,2,12,112,0,0 },
  { 8,8,0,48,76,50,2,1,1,1,2,2,12,112,0,0 },
  { 0,0,0,6,25,38,32,64,64,64,32,32,24,7,0,0 },
  { 8,8,0,6,25,38,32,64,64,64,32,32,24,7,0,0 },
  { 2,2,0,6,9,14,16,80,80,16,16,8,8,7,0,0 },
  { 8,8,0,24,36,56,64,65,65,64,64,32,32,28,0,0 },
  { 0,0,0,24,52,72,64,64,32,28,0,0,0,0,0,0 },
  { 0,0,0,73,73,73,73,73,73,65,65,65,34,28,0,0 },
  { 0,0,0,28,34,65,65,65,73,73,73,73,73,73,0,0 },
  { 0,0,0,112,12,2,2,1,121,1,2,2,12,112,0,0 },
  { 0,0,0,7,24,32,32,64,79,64,32,32,24,7,0,0 },
  { 0,0,0,0,0,0,42,168,28,112,62,248,28,112,42,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,85,85,85,85,85,73,65,65,65,34,28,0,0 },
  { 0,0,0,28,34,65,65,65,73,85,85,85,85,85,0,0 },
  { 0,0,0,112,12,2,114,9,9,9,114,2,12,112,0,0 },
  { 0,0,0,7,24,32,39,72,72,72,39,32,24,7,0,0 },
  { 0,0,0,56,68,68,68,60,4,4,4,5,6,4,0,0 },
  { 0,0,0,14,17,17,17,30,16,16,16,80,48,16,0,0 },
  { 4,4,0,14,17,17,17,30,16,16,16,80,48,16,0,0 },
  { 0,0,0,4,6,5,4,4,4,60,68,68,68,56,0,0 },
  { 4,4,0,4,6,5,4,4,4,60,68,68,68,56,0,0 },
  { 0,0,0,16,48,80,16,16,16,30,17,17,17,14,0,0 },
  { 16,16,0,16,48,80,16,16,16,30,17,17,17,14,0,0 },
  { 0,0,0,32,96,32,56,36,36,24,0,0,0,0,0,0 },
  { 0,0,0,66,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 0,0,0,68,40,16,40,68,0,0,0,0,0,0,0,0 },
  { 0,32,0,80,0,32,24,112,32,136,24,136,8,136,8,240,0,128,0,128,0,128,0,128,0,128,0,128,0,0,0,0 },
  { 0,0,0,0,0,0,24,112,32,136,24,136,8,136,8,240,0,128,0,128,0,128,0,128,0,128,0,128,0,0,0,0 },
  { 0,32,0,32,0,0,24,112,32,136,24,136,8,136,8,240,0,128,0,128,0,128,0,128,0,128,0,128,0,0,0,0 },
  { 0,0,0,0,0,0,24,8,32,8,24,8,8,8,8,8,0,8,0,120,0,136,0,136,0,136,0,112,0,0,0,0 },
  { 0,8,0,8,0,0,24,8,32,8,24,8,8,8,8,8,0,8,0,120,0,136,0,136,0,136,0,112,0,0,0,0 },
  { 0,0,0,0,0,0,24,128,32,128,24,128,8,128,8,128,0,128,0,240,0,136,0,136,0,136,0,112,0,0,0,0 },
  { 0,128,0,128,0,0,24,128,32,128,24,128,8,128,8,128,0,128,0,240,0,136,0,136,0,136,0,112,0,0,0,0 },
  { 0,0,0,52,68,54,21,18,0,0,0,0,0,0,0,0 },
  { 0,0,0,56,68,68,68,60,20,20,36,36,68,68,0,0 },
  { 0,0,0,56,68,68,68,120,80,80,72,72,68,68,0,0 },
  { 0,0,0,68,68,36,36,20,20,60,68,68,68,56,0,0 },
  { 0,0,0,68,68,72,72,80,80,120,68,68,68,56,0,0 },
  { 0,0,0,56,68,68,68,4,4,4,4,5,6,4,0,0 },
  { 0,0,0,14,17,17,17,16,16,16,16,80,48,16,0,0 },
  { 0,0,0,4,6,5,4,4,4,4,68,68,68,56,0,0 },
  { 0,0,0,16,48,80,16,16,16,16,17,17,17,14,0,0 },
  { 0,4,0,10,48,4,72,14,72,17,60,17,4,145,4,144,3,16,0,16,0,16,0,16,0,16,0,16,0,0,0,0 },
  { 0,0,0,0,48,0,72,14,72,17,60,17,4,145,4,144,3,16,0,16,0,16,0,16,0,16,0,16,0,0,0,0 },
  { 0,4,0,4,48,0,72,14,72,17,60,17,4,145,4,144,3,16,0,16,0,16,0,16,0,16,0,16,0,0,0,0 },
  { 0,0,0,0,48,0,72,1,72,1,60,1,4,129,4,129,3,1,0,1,0,17,0,17,0,17,0,14,0,0,0,0 },
  { 0,1,0,1,48,0,72,1,72,1,60,1,4,129,4,129,3,1,0,1,0,17,0,17,0,17,0,14,0,0,0,0 },
  { 0,0,0,0,48,0,72,16,72,16,60,16,4,144,4,144,3,16,0,16,0,17,0,17,0,17,0,14,0,0,0,0 },
  { 0,16,0,16,48,0,72,16,72,16,60,16,4,144,4,144,3,16,0,16,0,17,0,17,0,17,0,14,0,0,0,0 },
  { 0,0,48,72,72,60,5,5,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,49,128,74,64,74,64,63,248,0,9,0,9,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,60,66,90,74,50,2,2,2,2,2,2,0,0 },
  { 0,0,0,60,66,90,82,76,64,64,64,64,64,64,0,0 },
  { 0,0,0,2,2,2,2,2,2,50,74,90,66,60,0,0 },
  { 0,0,0,64,64,64,64,64,64,76,82,90,66,60,0,0 },
  { 0,0,0,0,0,0,126,0,126,9,9,9,9,6,0,0 },
  { 0,0,0,0,0,0,63,0,63,72,72,72,72,48,0,0 },
  { 0,0,0,0,0,0,126,0,6,9,9,9,9,126,0,0 },
  { 0,0,0,0,0,0,63,0,48,72,72,72,72,63,0,0 },
  { 0,0,0,63,0,32,80,80,63,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,4,2,63,64,64,64,64,48,0,0 },
  { 0,0,0,0,0,16,20,2,63,64,64,64,64,48,0,0 },
  { 0,0,0,0,0,0,0,0,6,1,1,1,1,126,32,16 },
  { 0,0,0,0,0,2,2,0,6,1,1,1,1,126,32,16 },
  { 0,0,0,0,0,0,0,0,48,64,64,64,64,63,2,4 },
  { 0,0,0,0,0,32,32,0,48,64,64,64,64,63,2,4 },
  { 0,0,0,32,64,64,63,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,2,4,8,16,32,124,4,4,31,4,4,0,0 },
  { 0,0,0,32,16,8,4,2,31,16,16,124,16,16,0,0 },
  { 16,16,0,32,16,8,4,2,31,16,16,124,16,16,0,0 },
  { 0,0,0,4,4,31,4,4,124,32,16,8,4,2,0,0 },
  { 4,4,0,4,4,31,4,4,124,32,16,8,4,2,0,0 },
  { 0,0,0,16,16,124,16,16,31,2,4,8,16,32,0,0 },
  { 16,16,0,16,16,124,16,16,31,2,4,8,16,32,0,0 },
  { 0,0,0,32,112,32,60,8,16,32,0,0,0,0,0,0 },
  { 0,0,0,64,64,64,64,64,92,98,65,65,98,92,0,0 },
  { 0,0,0,92,126,127,127,126,92,64,64,64,64,64,0,0 },
  { 0,0,0,1,1,1,1,1,29,63,127,127,63,29,0,0 },
  { 0,0,0,64,64,64,64,64,92,126,127,127,126,92,0,0 },
  { 0,0,0,29,63,127,127,63,29,1,1,1,1,1,0,0 },
  { 0,0,0,124,64,64,64,124,64,64,64,64,64,64,0,0 },
  { 0,0,0,4,4,4,4,4,4,124,4,4,4,124,0,0 },
  { 0,0,0,64,64,64,64,64,64,124,64,64,64,124,0,0 },
  { 0,0,0,124,4,4,4,124,4,4,4,4,4,4,0,0 },
  { 0,0,0,114,82,82,76,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,2,2,2,2,2,2,2,50,74,74,78,0,0 },
  { 0,0,0,64,64,64,64,64,64,64,76,82,82,114,0,0 },
  { 0,0,0,78,74,74,50,2,2,2,2,2,2,2,0,0 },
  { 0,0,0,65,98,84,72,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,1,1,1,1,1,1,1,9,21,35,65,0,0 },
  { 0,0,0,64,64,64,64,64,64,64,72,84,98,65,0,0 },
  { 0,0,0,65,35,21,9,1,1,1,1,1,1,1,0,0 },
  { 0,0,0,1,1,1,1,1,57,69,69,69,3,1,0,0 },
  { 0,0,0,64,64,64,64,64,78,81,81,81,96,64,0,0 },
  { 0,0,0,3,69,69,69,57,1,1,1,1,1,1,0,0 },
  { 0,0,0,96,81,81,81,78,64,64,64,64,64,64,0,0 },
  { 0,0,0,65,65,34,34,62,20,20,20,8,8,8,0,0 },
  { 0,0,0,8,8,8,20,20,20,62,34,34,65,65,0,0 },
  { 0,0,0,64,32,16,24,20,18,20,24,16,32,64,0,0 },
  { 0,0,0,64,32,16,24,84,82,84,24,16,32,64,0,0 },
  { 0,0,0,64,32,16,24,20,82,20,24,16,32,64,0,0 },
  { 0,0,0,2,4,8,24,40,72,40,24,8,4,2,0,0 },
  { 0,0,0,65,127,34,34,34,20,20,20,8,8,8,0,0 },
  { 0,0,0,8,8,8,20,20,20,34,34,34,127,65,0,0 },
  { 0,0,0,64,32,48,40,36,34,36,40,48,32,64,0,0 },
  { 0,0,0,64,32,48,40,52,50,52,40,48,32,64,0,0 },
  { 0,0,0,64,32,48,40,36,50,36,40,48,32,64,0,0 },
  { 0,0,0,2,4,12,20,36,68,36,20,12,4,2,0,0 },
  { 0,0,0,73,73,42,42,42,28,28,28,8,8,8,0,0 },
  { 0,0,0,8,8,8,28,28,28,42,42,42,73,73,0,0 },
  { 0,0,0,64,32,16,8,4,126,4,8,16,32,64,0,0 },
  { 0,0,0,64,32,16,40,36,126,36,40,16,32,64,0,0 },
  { 0,0,0,64,32,16,8,52,126,52,8,16,32,64,0,0 },
  { 0,0,0,2,4,8,16,32,126,32,16,8,4,2,0,0 },
  { 0,0,0,73,73,62,42,42,28,28,28,8,8,8,0,0 },
  { 0,0,0,8,8,8,28,28,28,42,42,62,73,73,0,0 },
  { 0,0,0,64,48,24,20,18,127,18,20,24,48,64,0,0 },
  { 0,0,0,64,32,16,88,84,254,84,88,16,32,64,0,0 },
  { 0,0,0,64,32,16,24,116,254,116,24,16,32,64,0,0 },
  { 0,0,0,1,6,12,20,36,127,36,20,12,6,1,0,0 },
  { 0,0,0,126,66,66,66,66,66,66,66,66,36,24,0,0 },
  { 0,0,0,24,36,66,66,66,66,66,66,66,66,126,0,0 },
  { 0,0,0,120,68,66,66,66,66,66,66,66,68,120,0,0 },
  { 0,0,0,120,68,66,66,82,82,82,66,66,68,120,0,0 },
  { 0,0,0,120,68,66,66,90,90,66,66,66,68,120,0,0 },
  { 0,0,0,30,34,66,66,66,66,66,66,66,34,30,0,0 },
  { 0,0,0,66,102,90,66,66,66,66,66,66,36,24,0,0 },
  { 0,0,0,24,36,66,66,66,66,66,66,90,102,66,0,0 },
  { 0,0,0,120,68,66,34,34,18,34,34,66,68,120,0,0 },
  { 0,0,0,120,68,66,34,42,26,42,34,66,68,120,0,0 },
  { 0,0,0,240,140,130,66,90,58,66,66,130,140,240,0,0 },
  { 0,0,0,30,34,66,68,68,72,68,68,66,34,30,0,0 },
  { 0,0,0,66,66,126,66,66,66,66,66,66,36,24,0,0 },
  { 0,0,0,24,36,66,66,66,66,66,66,126,66,66,0,0 },
  { 0,0,0,248,36,34,34,34,34,34,34,34,36,248,0,0 },
  { 0,0,0,248,36,34,34,42,42,42,34,34,36,248,0,0 },
  { 0,0,0,240,76,66,66,90,90,66,66,66,76,240,0,0 },
  { 0,0,0,62,72,136,136,136,136,136,136,136,72,62,0,0 },
  { 0,0,0,16,16,16,124,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,73,73,73,73,73,73,73,73,73,42,20,0,0 },
  { 0,0,0,20,42,73,73,73,73,73,73,73,73,73,0,0 },
  { 0,0,0,120,4,2,2,2,124,2,2,2,4,120,0,0 },
  { 0,0,0,120,4,2,2,18,124,18,2,2,4,120,0,0 },
  { 0,0,0,112,12,2,2,50,124,50,2,2,12,112,0,0 },
  { 0,0,0,30,32,64,64,64,62,64,64,64,32,30,0,0 },
  { 0,0,0,127,73,73,73,73,73,73,73,73,42,20,0,0 },
  { 0,0,0,20,42,73,73,73,73,73,73,73,73,127,0,0 },
  { 0,0,0,120,68,66,66,66,124,66,66,66,68,120,0,0 },
  { 0,0,0,120,68,66,66,82,124,82,66,66,68,120,0,0 },
  { 0,0,0,240,140,130,130,178,252,178,130,130,140,240,0,0 },
  { 0,0,0,30,34,66,66,66,62,66,66,66,34,30,0,0 },
  { 0,0,0,73,107,93,73,73,73,73,73,73,42,20,0,0 },
  { 0,0,0,20,42,73,73,73,73,73,73,93,107,73,0,0 },
  { 0,0,0,120,68,66,34,34,126,34,34,66,68,120,0,0 },
  { 0,0,0,120,68,66,34,42,126,42,34,66,68,120,0,0 },
  { 0,0,0,240,140,130,66,90,254,90,66,130,140,240,0,0 },
  { 0,0,0,30,34,66,68,68,126,68,68,66,34,30,0,0 },
  { 0,0,0,0,68,40,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,64,64,64,64,64,64,66,66,66,36,24,0,0 },
  { 0,0,0,24,36,66,66,66,2,2,2,2,2,2,0,0 },
  { 0,0,0,0,0,0,0,0,0,252,2,2,2,12,0,0 },
  { 0,0,0,0,0,0,0,0,0,252,2,34,34,12,0,0 },
  { 0,0,0,0,0,0,0,0,0,252,2,98,98,12,0,0 },
  { 0,0,0,0,0,0,0,0,0,96,128,128,128,126,0,0 },
  { 0,0,0,64,64,64,64,64,64,73,73,73,42,20,0,0 },
  { 0,0,0,20,42,73,73,73,1,1,1,1,1,1,0,0 },
  { 0,0,0,120,4,2,2,2,28,2,2,2,4,24,0,0 },
  { 0,0,0,120,4,2,2,18,28,18,2,2,4,24,0,0 },
  { 0,0,0,240,12,2,2,50,124,50,2,2,12,48,0,0 },
  { 0,0,0,24,32,64,64,64,56,64,64,64,32,30,0,0 },
  { 0,0,0,76,82,82,82,74,66,66,66,66,36,24,0,0 },
  { 0,0,0,24,36,66,66,66,66,82,74,74,74,50,0,0 },
  { 0,0,0,0,0,120,4,2,2,50,66,66,68,56,0,0 },
  { 0,0,0,0,0,120,4,2,18,50,82,66,68,56,0,0 },
  { 0,0,0,0,0,120,4,2,26,62,90,66,68,56,0,0 },
  { 0,0,0,0,0,28,34,66,66,76,64,64,32,30,0,0 },
  { 0,0,0,0,254,4,8,16,32,64,152,164,132,120,0,0 },
  { 0,0,0,0,254,64,32,16,8,4,50,74,66,60,0,0 },
  { 0,0,0,60,66,74,50,4,8,16,32,64,254,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,224,33,16,34,8,36,200,41,8,49,16,32,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,224,33,16,34,72,36,200,41,72,49,16,32,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,224,33,16,34,104,36,248,41,104,49,16,32,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,224,49,16,41,8,36,200,34,8,33,16,32,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,8,17,24,33,40,38,72,32,136,17,8,14,8,0,0,0,0 },
  { 0,0,8,32,4,64,2,128,1,0,2,0,4,0,9,192,10,32,10,16,9,16,4,16,2,32,1,192,0,0,0,0 },
  { 0,0,3,128,4,64,8,32,8,144,8,80,4,80,3,144,0,32,0,64,0,128,1,64,2,32,4,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,240,17,8,10,100,4,146,8,130,16,130,32,68,0,56,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,240,17,8,10,4,4,18,8,114,16,146,32,68,0,56,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,240,17,8,10,4,4,26,8,122,16,154,32,68,0,56,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,0,34,4,65,8,65,16,73,32,38,80,16,136,15,4,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,136,1,8,2,8,1,16,0,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,8,128,16,64,16,128,17,248,0,0,0,0 },
  { 0,0,0,0,64,64,64,80,104,68,4,4,8,112,0,0 },
  { 0,0,0,0,64,64,64,80,104,68,20,20,8,112,0,0 },
  { 0,0,0,0,64,64,64,80,104,68,52,52,8,112,0,0 },
  { 0,0,0,0,4,4,4,20,44,68,64,64,32,28,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,16,0,31,136,17,8,18,8,1,16,0,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,8,128,16,72,16,136,17,248,0,8,0,8 },
  { 0,0,0,0,248,32,32,40,52,34,2,2,4,56,0,0 },
  { 0,0,0,0,248,32,32,40,52,34,10,10,4,56,0,0 },
  { 0,0,0,0,248,32,32,40,52,34,26,26,4,56,0,0 },
  { 0,0,0,0,31,4,4,20,44,68,64,64,32,28,0,0 },
  { 0,0,0,0,0,0,0,198,68,130,130,130,68,56,0,0 },
  { 0,0,0,0,0,0,0,56,68,130,130,130,68,198,0,0 },
  { 0,0,0,0,0,0,0,184,196,2,2,2,196,184,0,0 },
  { 0,0,0,0,0,0,0,184,196,18,18,18,196,184,0,0 },
  { 0,0,0,0,0,0,0,184,196,26,62,26,196,184,0,0 },
  { 0,0,0,0,0,0,0,58,70,128,128,128,70,58,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,0,8,12,120,4,72,8,40,8,32,8,32,4,64,3,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,192,2,32,4,16,4,16,20,16,18,32,30,48,16,0,16,0 },
  { 0,0,0,0,0,240,64,92,98,1,1,1,98,92,0,0 },
  { 0,0,0,0,0,240,64,92,98,9,9,9,98,92,0,0 },
  { 0,0,0,0,0,240,64,92,98,13,31,13,98,92,0,0 },
  { 0,0,0,0,0,15,2,58,70,128,128,128,70,58,0,0 },
  { 0,0,0,4,0,4,32,60,32,36,34,36,34,32,34,32,34,32,34,32,34,32,34,32,18,64,13,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,96,4,144,8,136,8,136,8,136,8,136,8,136,8,136,72,136,72,8,120,8,64,0 },
  { 0,0,0,0,248,0,32,0,32,0,63,224,0,16,0,8,0,8,15,240,0,8,0,8,0,16,63,224,0,0,0,0 },
  { 0,0,0,0,248,0,32,0,32,0,63,224,0,16,8,8,8,8,15,240,8,8,8,8,0,16,63,224,0,0,0,0 },
  { 0,0,0,0,248,0,32,0,32,0,63,224,0,16,0,8,6,8,15,240,6,8,0,8,0,16,63,224,0,0,0,0 },
  { 0,0,0,0,0,62,0,8,0,8,15,248,16,0,32,0,32,0,31,224,32,0,32,0,16,0,15,248,0,0,0,0 },
  { 0,0,0,130,68,68,68,68,68,68,68,68,40,16,0,0 },
  { 0,0,0,16,40,68,68,68,68,68,68,68,68,130,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,0,15,240,0,8,0,8,0,8,0,8,0,8,15,240,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,0,15,240,0,8,0,136,0,136,0,136,0,8,15,240,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,0,15,240,0,8,0,200,1,232,0,200,0,8,15,240,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,15,240,16,0,16,0,16,0,16,0,16,0,15,240,0,8,0,0,0,0 },
  { 0,0,0,0,0,254,4,8,16,32,64,254,0,0,0,0 },
  { 0,0,0,16,16,254,20,24,16,48,80,254,16,16,0,0 },
  { 0,0,0,186,84,84,68,68,68,68,68,68,40,16,0,0 },
  { 0,0,0,16,40,68,68,68,68,68,68,84,84,186,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,0,15,240,0,8,16,8,28,8,16,8,0,8,15,240,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,0,15,240,0,8,16,136,28,136,16,136,0,8,15,240,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,0,15,240,0,8,16,200,29,232,16,200,0,8,15,240,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,15,240,16,0,16,8,16,56,16,8,16,0,15,240,0,8,0,0,0,0 },
  { 0,0,0,0,0,0,32,8,16,16,17,16,17,16,17,16,17,16,17,16,17,16,17,16,9,32,6,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,192,9,32,17,16,17,16,17,16,17,16,17,16,17,16,17,16,16,16,32,8,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,0,16,0,8,0,8,15,240,0,8,0,8,0,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,0,16,8,8,8,8,15,240,8,8,8,8,0,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,0,16,0,8,6,8,15,240,6,8,0,8,0,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,15,240,16,0,32,0,32,0,31,224,32,0,32,0,16,0,15,240,0,8,0,0 },
  { 0,0,0,0,0,0,33,8,17,16,31,240,17,16,17,16,17,16,17,16,17,16,17,16,9,32,6,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,192,9,32,17,16,17,16,17,16,17,16,17,16,17,16,31,240,17,16,33,8,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,8,16,8,8,8,8,63,240,8,8,8,8,8,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,8,16,8,136,8,136,63,240,8,136,8,136,8,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,8,16,8,8,9,136,63,240,9,136,8,8,8,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,15,240,16,32,32,32,32,32,31,248,32,32,32,32,16,32,15,240,0,8,0,0 },
  { 0,16,16,56,84,80,56,20,84,56,16,16,0,0,0,0 },
  { 0,0,0,0,0,0,39,200,17,16,31,240,17,16,17,16,17,16,17,16,17,16,17,16,9,32,6,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,192,9,32,17,16,17,16,17,16,17,16,17,16,17,16,31,240,17,16,39,200,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,8,16,40,8,40,8,63,240,40,8,40,8,8,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,8,16,40,136,40,136,63,240,40,136,40,136,8,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,8,16,40,8,41,136,63,240,41,136,40,8,8,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,15,240,16,32,32,40,32,40,31,248,32,40,32,40,16,32,15,240,0,8,0,0 },
  { 0,0,0,0,0,0,39,200,17,16,17,16,17,16,17,16,17,16,17,16,17,16,17,16,9,32,6,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,192,9,32,17,16,17,16,17,16,17,16,17,16,17,16,17,16,17,16,39,200,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,0,16,32,8,32,8,63,240,32,8,32,8,0,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,0,16,32,136,32,136,63,240,32,136,32,136,0,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,0,16,32,8,33,136,63,240,33,136,32,8,0,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,15,240,16,0,32,8,32,8,31,248,32,8,32,8,16,0,15,240,0,8,0,0 },
  { 0,0,0,0,0,0,39,200,17,16,25,48,21,80,19,144,17,16,17,16,17,16,17,16,9,32,6,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,192,9,32,17,16,17,16,17,16,17,16,19,144,21,80,25,48,17,16,39,200,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,8,16,36,8,34,8,63,240,34,8,36,8,8,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,8,16,36,136,34,136,63,240,34,136,36,136,8,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,31,224,8,16,36,8,34,232,63,240,34,232,36,8,8,16,31,224,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,15,240,16,32,32,72,32,136,31,248,32,136,32,72,16,32,15,240,0,8,0,0 },
  { 0,0,0,98,34,20,20,8,8,8,20,20,34,35,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,40,16,40,0 },
  { 0,0,0,0,0,0,24,112,32,136,24,136,8,136,8,120,0,8,0,8,0,8,0,8,0,8,0,8,0,0,0,0 },
  { 0,0,0,0,48,0,72,14,72,17,60,17,4,145,4,129,3,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0 },
  { 0,0,0,0,36,0,90,14,90,17,63,17,1,81,1,80,0,144,0,16,0,16,0,16,0,16,0,16,0,0,0,0 },
  { 0,4,0,4,36,0,90,14,90,17,63,17,1,81,1,80,0,144,0,16,0,16,0,16,0,16,0,16,0,0,0,0 },
  { 0,0,0,0,36,0,90,1,90,1,63,1,1,65,1,65,0,129,0,1,0,17,0,17,0,17,0,14,0,0,0,0 },
  { 0,1,0,1,36,0,90,1,90,1,63,1,1,65,1,65,0,129,0,1,0,17,0,17,0,17,0,14,0,0,0,0 },
  { 0,0,0,0,36,0,90,16,90,16,63,16,1,80,1,80,0,144,0,16,0,17,0,17,0,17,0,14,0,0,0,0 },
  { 0,16,0,16,36,0,90,16,90,16,63,16,1,80,1,80,0,144,0,16,0,17,0,17,0,17,0,14,0,0,0,0 },
  { 0,0,0,16,16,32,32,70,70,128,248,8,62,8,0,0 },
  { 0,0,0,32,32,16,19,11,8,4,124,64,240,64,0,0 },
  { 0,12,12,32,32,16,19,11,8,4,124,64,240,64,0,0 },
  { 0,0,0,8,62,8,248,128,70,70,32,32,16,16,0,0 },
  { 0,12,12,0,8,62,8,248,128,70,70,32,32,16,16,0 },
  { 0,0,0,64,240,64,124,4,8,11,19,16,32,32,0,0 },
  { 0,192,192,0,64,240,64,124,4,8,11,19,16,32,32,0 },
  { 0,16,16,124,16,124,16,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,124,0,124,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,2,128,2,128,2,128,2,128,2,128,2,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,5,64,5,64,5,64,5,64,5,64,5,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,10,160,10,160,10,160,10,160,10,160,10,160,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,21,80,21,80,21,80,21,80,21,80,21,80,0,0,0,0 },
  { 0,0,1,0,1,0,1,0,1,0,1,0,1,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,2,128,2,128,2,128,2,128,2,128,2,128,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,5,64,5,64,5,64,5,64,5,64,5,64,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,10,160,10,160,10,160,10,160,10,160,10,160,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,21,80,21,80,21,80,21,80,21,80,21,80,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,64,0,64,0,128,0,128,1,0,255,255,1,0,2,0,2,0,4,0,4,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,160,0,160,1,64,1,64,2,128,255,255,2,128,5,0,5,0,10,0,10,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,80,1,80,2,160,2,160,5,64,255,255,5,64,10,128,10,128,21,0,21,0,0,0,0,0,0,0 },
  { 0,0,0,0,2,168,2,168,5,80,5,80,10,160,255,255,10,160,21,64,21,64,42,128,42,128,0,0,0,0,0,0 },
  { 0,0,0,0,5,84,5,84,10,168,10,168,21,80,255,255,21,80,42,160,42,160,85,64,85,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,0,1,0,255,255,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,128,2,128,255,255,2,128,2,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,5,64,5,64,255,255,5,64,5,64,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,10,160,10,160,255,255,10,160,10,160,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,21,80,21,80,255,255,21,80,21,80,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,4,64,4,64,2,128,2,128,1,0,255,255,1,0,2,128,2,128,4,64,4,64,0,0,0,0,0,0 },
  { 0,0,1,0,1,0,2,128,2,128,4,64,4,64,255,255,4,64,4,64,2,128,2,128,1,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,8,0,8,0,9,192,8,64,8,64,15,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,18,144,9,32,6,192,6,192,9,32,18,144,36,72,0,0 },
  { 5,80,15,248,5,80,15,248,5,80,15,248,5,80,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,0,0,15,240,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,32,0,16,0,8,0,4,0,2,0,1,255,2,0,4,0,8,0,16,0,32,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,4,0,8,0,16,0,32,0,64,255,128,0,64,0,32,0,16,0,8,0,4,0,0,0,0,0,0 },
  { 0,0,127,254,123,206,115,190,123,142,123,182,113,206,127,254,127,254,115,142,109,182,113,182,125,182,115,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,190,123,142,123,182,113,206,127,254,127,254,115,134,109,190,113,142,125,190,115,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,190,123,142,123,182,113,206,127,254,127,254,115,134,109,190,113,142,125,190,115,190,127,254,0,0 },
  { 0,146,164,200,144,160,192,128,128,128,128,128,128,128,128,0 },
  { 0,170,148,168,208,160,192,128,128,128,128,128,128,128,128,0 },
  { 0,128,192,160,144,136,132,132,132,132,132,132,132,132,132,0 },
  { 0,128,192,160,144,136,132,130,146,146,146,146,146,146,146,0 },
  { 0,128,192,160,144,136,132,132,180,180,132,132,132,132,132,0 },
  { 0,128,192,160,144,136,132,194,162,146,146,146,146,146,146,0 },
  { 0,128,128,128,192,160,144,136,136,144,160,192,128,128,128,0 },
  { 0,128,128,128,192,160,144,168,168,144,160,192,128,128,128,0 },
  { 0,128,192,160,144,200,160,144,136,128,128,128,128,128,128,0 },
  { 0,128,194,164,152,194,164,152,128,128,128,128,128,128,128,0 },
  { 0,128,194,164,152,192,160,144,128,128,128,128,128,128,128,0 },
  { 0,128,192,160,144,200,160,144,136,128,128,128,128,128,128,0 },
  { 0,16,16,144,80,48,144,88,52,18,24,20,18,16,16,0 },
  { 0,16,16,16,16,16,24,20,18,24,20,18,16,16,16,0 },
  { 0,8,8,8,8,8,24,40,72,24,40,72,8,8,8,8 },
  { 0,16,16,18,20,24,18,52,88,144,48,80,144,16,16,0 },
  { 0,16,16,18,20,24,16,48,80,144,48,80,144,16,16,0 },
  { 0,128,192,160,144,136,132,136,144,160,160,144,136,132,130,0 },
  { 0,0,0,4,8,16,32,64,32,16,8,4,0,0,0,0 },
  { 0,128,128,128,128,128,128,128,128,192,160,144,136,132,130,0 },
  { 0,130,132,136,144,160,192,128,128,128,128,128,128,128,128,0 },
  { 0,178,180,136,144,160,192,128,128,128,128,128,128,128,128,0 },
  { 0,66,68,72,80,224,224,224,64,64,64,64,64,64,64,0 },
  { 0,130,130,68,68,40,40,16,16,40,40,68,68,130,130,0 },
  { 0,130,130,68,68,40,40,84,84,40,40,68,68,130,130,0 },
  { 0,128,192,160,144,136,144,160,192,128,128,128,128,128,128,0 },
  { 0,130,130,130,130,130,226,146,142,130,130,130,130,130,130,0 },
  { 0,130,130,130,130,226,146,142,226,146,142,130,130,130,130,0 },
  { 0,16,16,16,146,84,56,16,56,84,146,16,16,16,16,0 },
  { 0,16,16,16,16,16,56,56,56,16,16,16,16,16,16,0 },
  { 0,16,16,16,144,80,48,16,24,20,18,16,16,16,16,0 },
  { 0,32,32,32,32,32,48,40,36,34,32,32,32,32,32,0 },
  { 0,16,16,16,144,80,56,56,56,20,18,16,16,16,16,0 },
  { 0,16,16,16,16,16,16,16,16,16,16,16,16,16,16,0 },
  { 0,16,16,16,16,16,56,56,56,16,16,16,16,16,16,0 },
  { 0,0,0,16,32,64,136,68,34,4,8,16,0,0,0,0 },
  { 0,16,16,16,16,56,84,146,146,84,56,16,16,16,16,0 },
  { 0,16,16,16,18,20,24,16,48,80,144,16,16,16,16,0 },
  { 0,8,8,8,8,8,8,24,40,72,136,8,8,8,8,0 },
  { 0,16,24,20,18,16,16,16,16,16,16,144,80,48,16,0 },
  { 0,130,196,168,144,128,128,128,128,128,128,144,168,196,130,0 },
  { 0,146,146,84,84,56,56,16,16,16,16,16,16,16,16,0 },
  { 0,8,16,32,64,32,16,8,16,32,64,32,16,8,0,0 },
  { 0,64,64,64,64,68,76,84,100,68,4,4,4,4,4,0 },
  { 0,16,16,16,16,16,16,16,0,0,0,0,0,0,0,0 },
  { 0,16,16,16,16,16,56,56,56,0,0,0,0,0,0,0 },
  { 0,16,16,16,16,146,84,56,16,0,0,0,0,0,0,0 },
  { 0,16,56,84,146,16,16,16,16,16,16,16,16,16,16,0 },
  { 0,8,24,40,72,136,8,8,8,8,8,8,8,8,8,0 },
  { 0,8,24,40,72,136,8,28,28,28,8,8,8,8,8,0 },
  { 0,96,80,72,68,72,80,96,96,80,72,68,72,80,96,0 },
  { 0,64,64,68,72,80,100,72,80,96,64,64,64,64,64,0 },
  { 0,192,160,144,168,144,160,192,192,160,144,168,144,160,192,0 },
  { 0,130,132,136,144,160,192,128,128,192,160,144,136,132,130,0 },
  { 0,130,198,198,170,170,146,146,130,130,130,130,130,130,130,0 },
  { 0,130,198,170,146,170,198,130,130,130,130,130,130,130,130,0 },
  { 0,146,146,84,84,56,56,16,16,16,16,16,16,16,16,0 },
  { 0,56,56,56,16,16,16,16,16,16,16,16,16,16,16,0 },
  { 0,64,96,80,72,68,66,64,64,64,64,64,64,64,64,0 },
  { 0,64,96,80,72,68,66,224,224,224,64,64,64,64,64,0 },
  { 0,0,0,0,16,40,68,130,130,68,40,16,0,0,0,0 },
  { 0,130,68,40,16,40,68,130,130,68,40,16,40,68,130,0 },
  { 0,130,198,198,170,170,146,146,146,146,170,170,198,198,130,0 },
  { 0,0,16,40,68,130,130,68,40,16,40,68,130,0,0,0 },
  { 0,0,130,8,71,16,42,160,18,64,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,0,0 },
  { 0,16,16,16,146,84,56,16,56,84,146,16,16,16,16,0 },
  { 0,0,2,8,3,16,2,160,2,64,2,0,2,0,2,0,2,0,2,0,2,0,18,0,42,0,70,0,130,0,0,0 },
  { 0,16,16,16,16,16,16,16,16,56,56,84,84,146,146,0 },
  { 0,146,146,84,84,56,56,84,84,56,56,84,84,146,146,0 },
  { 0,130,198,170,146,170,198,130,130,198,170,146,170,198,130,0 },
  { 0,16,16,16,16,16,16,16,16,56,56,84,84,146,146,0 },
  { 0,0,0,0,0,0,0,0,16,16,16,16,16,16,16,0 },
  { 0,16,56,84,146,16,16,16,16,16,16,146,84,56,16,0 },
  { 0,4,12,20,36,68,36,20,12,4,4,4,4,4,4,0 },
  { 0,64,64,224,64,68,76,84,100,68,4,14,4,4,4,0 },
  { 0,0,0,0,0,0,56,56,56,0,0,0,0,0,0,0 },
  { 0,0,112,112,112,0,0,0,0,0,112,112,112,0,0,0 },
  { 0,0,0,56,56,16,214,254,214,16,56,56,0,0,0,0 },
  { 0,16,24,20,18,16,16,48,80,144,16,16,16,16,16,0 },
  { 0,146,84,84,56,56,16,16,16,16,56,56,84,84,146,0 },
  { 0,16,16,16,56,84,146,146,146,146,146,84,56,16,16,0 },
  { 0,64,64,64,64,64,64,64,72,84,100,68,66,66,66,0 },
  { 0,8,8,8,8,136,200,168,152,136,128,128,128,128,128,0 },
  { 0,8,28,42,73,42,28,8,8,8,8,8,8,8,8,0 },
  { 0,64,64,64,68,70,76,84,100,196,68,4,4,4,4,0 },
  { 0,8,16,32,16,8,16,32,16,8,16,32,16,8,0,0 },
  { 0,128,128,64,64,34,36,24,16,40,72,132,4,2,2,0 },
  { 0,64,64,64,64,112,72,68,66,66,66,66,66,66,66,0 },
  { 0,8,8,8,8,8,8,8,8,8,20,34,34,65,65,0 },
  { 0,0,127,254,123,206,115,190,123,142,123,182,113,206,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,123,206,115,190,123,142,123,182,113,206,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,123,206,115,190,123,142,123,182,113,206,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,190,123,142,123,182,113,206,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,123,206,115,190,123,142,123,182,113,206,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,190,123,142,123,182,113,206,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,190,123,142,123,182,113,206,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,96,4,16,10,120,8,8,16,8,16,8,32,8,64,8,128,7,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,0,48,0,15,252,4,2,10,128,115,64,2,34,0,28,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,224,4,16,0,16,0,32,0,80,0,16,0,16,8,32,7,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,0,32,2,31,252,1,0,1,0,67,252,60,2,0,2,0,4,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,96,32,144,0,144,1,16,2,144,0,144,0,144,1,16,62,12,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,78,12,81,18,33,226,1,2,62,12,64,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,28,64,34,64,66,32,128,31,0,8,0,16,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,252,67,2,44,2,48,48,16,72,15,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,9,32,17,16,18,16,1,0,0,128,1,0,2,0,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,120,12,8,18,8,18,16,16,16,24,32,36,32,64,16,128,15,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,192,16,32,32,16,64,8,64,8,64,8,65,8,34,144,28,96,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,6,0,8,112,8,11,208,12,48,8,32,8,64,8,128,7,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,0,10,48,10,72,28,8,16,8,32,8,64,8,128,7,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,115,142,109,182,109,182,109,182,115,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,64,124,67,130,60,130,1,0,0,128,1,0,1,0,0,128,3,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,192,2,32,4,16,0,8,0,8,1,8,3,8,12,144,0,96,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,12,0,18,56,34,8,36,8,74,4,66,4,130,2,132,3,24,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,28,16,98,33,130,38,2,24,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,12,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,24,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,3,128,1,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,123,134,115,190,123,134,123,246,113,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,123,206,115,190,123,142,123,182,113,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,123,134,115,246,123,238,123,222,113,222,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,123,206,115,182,123,206,123,182,113,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,123,206,115,182,123,198,123,246,113,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,123,134,115,182,123,134,123,182,113,182,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,123,142,115,182,123,142,123,182,113,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,123,198,115,190,123,190,123,190,113,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,123,142,115,182,123,182,123,182,113,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,123,134,115,190,123,142,123,190,113,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,123,134,115,190,123,142,123,190,113,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,0,8,24,16,104,32,8,64,8,128,9,0,10,0,12,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,0,8,24,16,104,32,8,72,8,144,9,32,10,0,12,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,0,64,0,128,1,0,7,240,0,32,0,64,0,128,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,224,17,16,10,16,6,32,5,192,8,0,8,0,8,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,16,16,48,16,80,16,144,17,16,18,16,20,16,24,16,16,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,16,16,32,16,64,16,128,17,64,18,32,20,0,24,0,16,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,128,17,136,17,136,18,144,18,144,20,160,20,160,24,192,16,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,8,8,16,8,32,0,64,56,128,9,0,10,0,12,0,8,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,71,24,58,232,2,8,2,8,2,8,2,8,2,8,2,8,2,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,120,8,8,8,8,16,8,24,8,36,8,64,8,128,7,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,63,192,0,64,0,128,0,128,1,0,1,0,2,0,2,0,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,4,54,8,5,8,8,144,8,80,8,32,8,80,8,136,15,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,8,40,24,72,40,8,72,8,136,9,8,10,8,12,8,8,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,33,0,35,0,35,0,37,0,37,0,41,96,41,144,49,16,32,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,48,64,72,194,8,164,9,24,17,0,18,0,18,0,20,0,24,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,32,0,96,24,96,104,160,8,160,9,36,9,76,10,116,12,2,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,8,8,16,8,32,8,64,8,128,9,0,18,0,20,0,24,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,0,0 },
  { 0,0,0,0,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,4,0,4,0,8,0,48,31,192 },
  { 0,0,0,0,0,0,0,0,0,64,0,128,0,128,1,0,1,0,2,0,2,0,4,0,4,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,8,2,16,2,16,4,32,4,32,8,64,8,64,16,128,16,128,0,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,99,134,125,246,113,238,125,222,99,222,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,99,206,125,182,113,206,125,182,99,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,99,206,125,182,113,198,125,246,99,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,99,134,125,182,113,134,125,182,99,182,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,99,142,125,182,113,142,125,182,99,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,99,198,125,190,113,190,125,190,99,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,99,142,125,182,113,182,125,182,99,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,99,134,125,190,113,142,125,190,99,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,99,134,125,190,113,142,125,190,99,190,127,254,0,0 },
  { 0,0,0,8,0,8,0,16,56,16,56,32,8,32,8,64,15,192,15,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,8,0,8,0,16,56,16,56,32,8,32,8,64,15,192,15,128,0,0,31,0,31,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,128,15,128,0,128,0,240,1,224,0,64,0,64,0,128,0,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,240,3,240,0,0,0,0,0,0,0,0,0,0,31,128,31,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,0,2,0,4,0,7,240,7,240,0,16,0,32,0,32,0,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,240,7,240,0,32,0,32,0,124,0,124,0,128,31,128,31,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,17,226,17,226,17,34,34,68,34,68,34,68,68,136,124,248,124,248,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,8,1,8,1,8,62,16,62,16,2,16,4,32,7,224,7,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,248,7,248,0,64,0,128,0,128,0,128,1,0,1,0,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,60,60,60,60,4,32,8,64,8,64,8,64,16,128,31,128,31,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,224,15,224,0,32,0,32,0,64,0,64,15,192,15,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,8,0,8,0,16,4,16,7,240,7,240,8,32,8,32,8,32,31,224,31,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,62,124,62,124,2,68,4,136,4,136,4,136,9,16,15,16,15,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,248,31,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,240,1,240,1,16,34,16,34,32,63,224,63,224,4,0,4,0,8,0,8,0,0,0 },
  { 0,0,0,0,4,0,4,0,8,248,8,248,8,136,17,8,16,16,31,240,31,240,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,62,0,62,0,2,0,4,0,7,192,7,192,0,64,0,128,0,248,0,248,0,8,0,16,0,16,0,32 },
  { 0,0,0,0,0,0,0,0,2,0,2,0,2,0,4,0,4,0,4,0,8,0,15,224,15,224,0,0,0,0,0,0 },
  { 0,0,0,124,0,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,0,248,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,182,111,182,97,134,125,246,97,246,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,111,190,97,134,125,246,97,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,206,111,190,97,142,125,182,97,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,111,246,97,238,125,222,97,222,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,206,111,182,97,206,125,182,97,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,206,111,182,97,198,125,246,97,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,111,182,97,134,125,182,97,182,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,142,111,182,97,142,125,182,97,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,198,111,190,97,190,125,190,97,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,142,111,182,97,182,125,182,97,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,111,190,97,142,125,190,97,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,111,190,97,142,125,190,97,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,0,10,48,8,72,16,8,16,8,32,8,64,8,128,23,0,32,0,32,0,16,0 },
  { 0,0,0,0,0,0,0,16,0,38,0,72,48,8,72,16,8,16,8,32,8,64,8,128,7,0,0,0,0,0,0,0 },
  { 0,0,0,0,16,8,16,32,16,8,16,32,16,8,16,0 },
  { 0,0,0,0,0,0,0,0,48,24,8,32,4,64,2,128,1,0,2,128,4,64,8,32,16,24,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,224,49,24,64,132,1,0,2,0,1,0,0,128,1,0,2,0,1,0,0,128,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,64,28,32,34,31,194,32,4,64,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,0,32,0,64,0,128,56,64,68,63,132,64,8,128,0,64,0,32,0,64,0,0,0 },
  { 0,0,0,0,0,224,1,0,2,6,4,8,52,8,72,16,8,16,8,32,8,64,8,128,7,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,224,49,24,65,4,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,6,0,8,48,8,72,16,8,16,8,40,8,68,8,130,7,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,240,8,8,16,4,32,4,32,4,32,4,32,4,32,8,16,16,15,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,6,0,8,51,200,76,48,8,16,8,32,8,64,8,128,7,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,12,0,18,48,18,72,36,8,32,8,64,8,64,8,128,7,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,115,142,111,182,99,182,109,182,115,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,14,0,16,48,16,72,32,8,32,8,84,8,90,8,172,7,22,0,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,12,32,16,32,32,0,64,0,64,0,65,252,70,2,56,2,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,32,0,80,48,80,72,144,8,160,9,24,9,16,9,12,6,8,0,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,238,125,206,123,238,119,238,119,198,127,254,0,0 },
  { 0,0,0,8,0,4,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,8,0,16,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,182,125,182,123,134,119,246,119,246,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,125,190,123,134,119,246,119,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,206,125,190,123,142,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,125,246,123,238,119,222,119,222,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,206,125,182,123,206,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,206,125,182,123,198,119,246,119,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,125,182,123,134,119,182,119,182,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,142,125,182,123,142,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,198,125,190,123,190,119,190,119,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,142,125,182,123,182,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,125,190,123,142,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,125,190,123,142,119,190,119,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,7,96,8,144,4,0,15,240,8,16,8,16,8,16,8,16,8,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,64,3,128,4,64,4,32,2,32,0,64,3,128,4,32,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,96,8,144,4,0,15,240,8,16,8,16,9,144,10,144,12,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,25,152,42,32,43,48,9,16,9,16,9,16,9,16,9,16,6,224,0,0,0,0,0,0 },
  { 0,0,0,0,4,0,2,0,2,128,3,64,1,128,0,64,6,32,10,32,10,160,3,96,2,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,96,8,144,16,0,8,112,8,144,30,112,41,16,41,16,0,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,32,3,16,4,144,8,96,12,0,4,64,4,64,5,64,6,192,4,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,102,34,136,34,204,34,68,34,68,50,68,42,68,42,68,49,184,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,13,184,18,68,16,68,16,68,16,68,24,68,20,68,20,68,24,68,0,16,7,8,8,240 },
  { 0,0,0,0,3,128,0,64,3,32,4,32,3,192,0,0,2,32,2,32,2,160,3,96,2,32,0,0,0,0,0,0 },
  { 0,0,0,32,0,16,0,16,3,48,5,64,5,96,1,32,1,32,1,32,1,32,1,32,0,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,14,224,17,16,16,16,8,32,0,192,3,16,12,48,16,48,15,208,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,27,6,36,136,32,140,32,132,32,132,49,196,42,164,42,164,49,152,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,56,34,68,34,100,34,36,34,36,50,36,42,164,43,100,50,36,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,62,56,34,68,34,100,34,36,34,36,34,36,58,164,43,100,50,36,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,96,8,144,4,0,15,224,8,32,12,32,10,32,10,32,12,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,32,0,16,3,16,4,224,8,0,12,96,4,160,4,160,4,96,4,32,7,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,248,4,4,8,8,8,96,4,144,3,224,0,128,8,128,15,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,14,192,17,32,16,0,24,48,8,80,8,80,9,48,10,144,12,112,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,192,2,32,4,64,4,0,3,192,0,64,5,64,6,192,4,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,24,8,32,12,48,4,16,4,16,4,16,4,16,4,16,3,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,32,3,16,4,144,8,96,8,0,8,48,8,80,8,80,9,48,10,144,12,112,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,112,8,136,8,8,8,8,8,8,12,8,10,8,10,8,12,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,96,8,144,4,0,0,0,3,240,2,16,10,16,18,16,14,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,48,16,64,24,96,8,32,8,32,15,224,8,32,8,32,7,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,204,21,16,21,152,24,136,16,136,16,136,16,136,16,136,31,112,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,192,1,0,1,128,0,128,0,128,0,128,2,128,4,128,3,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,12,16,144,16,152,16,136,16,136,24,136,20,136,20,136,24,112,0,0,0,0,0,0 },
  { 0,0,0,64,0,160,0,32,0,224,1,32,1,128,0,128,0,128,0,128,2,128,4,128,3,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,96,8,144,4,0,15,224,8,32,8,168,10,112,13,32,12,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,48,16,64,24,96,8,32,8,168,8,112,8,32,8,32,7,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,24,16,32,24,48,15,16,17,16,25,16,21,16,21,16,24,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,120,16,132,24,196,8,68,8,68,8,68,8,68,8,68,7,132,0,0,0,0,0,0 },
  { 0,0,0,0,15,128,16,64,17,24,10,160,7,48,30,16,0,16,7,16,9,80,5,176,1,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,24,8,32,12,48,4,16,7,240,4,16,20,80,36,144,28,112,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,24,8,32,12,48,4,16,7,240,4,16,20,80,36,144,28,112,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,108,16,148,24,196,8,68,15,196,8,68,41,68,74,68,57,196,0,0,0,0,0,0 },
  { 0,0,0,0,0,32,3,16,4,144,2,96,0,0,7,240,4,16,6,16,5,16,5,16,6,16,0,0,0,0,0,0 },
  { 0,0,0,4,0,10,31,130,16,142,28,146,18,152,28,136,0,8,31,136,24,136,20,136,24,248,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,4,64,4,32,2,32,0,64,3,144,4,48,4,80,3,144,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,96,8,144,4,0,3,192,4,32,0,64,3,144,4,48,3,208,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,14,0,17,0,16,128,8,144,1,16,14,80,16,208,17,80,14,80,0,0,0,0,0,0 },
  { 1,0,0,128,0,64,7,64,8,192,6,64,1,0,3,192,4,32,0,64,3,144,4,48,3,208,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,24,8,32,12,48,4,16,4,16,4,16,4,16,4,16,3,224,0,48,7,8,8,240 },
  { 0,0,0,0,0,0,0,0,6,24,8,32,12,48,4,16,4,16,4,16,4,16,4,16,3,224,0,48,7,8,8,246 },
  { 0,0,0,0,0,0,0,0,7,112,8,136,8,8,8,8,8,8,12,8,10,8,10,8,12,8,0,96,7,16,8,224 },
  { 0,0,0,0,0,0,0,0,7,112,8,136,8,8,8,8,8,8,12,8,10,8,10,8,12,8,0,96,7,16,8,236 },
  { 0,0,0,0,0,0,0,0,3,0,1,0,1,112,1,144,0,16,7,16,9,80,5,176,1,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,112,8,136,8,8,8,8,12,8,10,8,10,8,12,8,0,0,3,248,4,144,3,96 },
  { 0,0,0,0,0,0,3,128,4,64,6,32,1,0,3,192,4,32,0,64,3,144,4,48,3,208,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,16,7,224,8,0,8,224,9,16,9,16,8,32,8,16,8,16,7,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,136,4,80,6,32,1,0,3,192,4,32,0,64,3,144,4,48,3,208,0,0,0,0,0,0 },
  { 85,85,128,0,37,69,169,68,49,41,169,40,37,17,128,0,0,1,136,112,20,137,162,168,62,153,162,120,0,5,170,170 },
  { 85,85,128,0,37,69,169,68,49,41,169,40,37,17,128,0,0,1,136,16,20,41,162,68,62,125,162,68,0,1,170,170 },
  { 0,0,0,0,0,0,0,30,0,34,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,0,0,0,0,0 },
  { 0,0,3,128,4,64,3,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,3,144,4,80,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,3,144,4,104,3,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,80,3,208,4,112,3,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,64,2,64,3,192 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,32,2,160,3,96 },
  { 0,0,3,144,4,80,3,240,192,0,160,0,128,0,128,0,128,0,192,0,160,0,160,0,192,0,0,0,0,0,0,0 },
  { 0,80,3,208,4,112,3,254,192,1,160,1,128,1,128,1,128,1,192,1,160,1,160,1,192,1,16,7,8,1,7,254 },
  { 0,24,0,8,0,16,0,62,192,1,160,1,128,1,128,1,128,1,192,1,160,1,160,1,192,1,16,7,8,1,7,254 },
  { 0,0,0,0,192,160,128,128,128,192,160,160,192,0,0,0 },
  { 24,136,112,0,192,160,128,128,128,192,160,160,192,0,0,0 },
  { 152,100,68,24,192,160,128,128,128,192,160,160,192,0,0,0 },
  { 0,0,0,0,0,0,0,30,192,34,160,2,128,2,128,2,128,2,192,2,160,2,160,2,192,2,0,0,0,0,0,0 },
  { 0,4,0,2,0,2,0,30,192,34,160,2,128,2,128,2,128,2,192,2,160,2,160,2,192,2,0,0,0,0,0,0 },
  { 1,128,2,64,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,2,0,5,0,5,0,2,0,0,0,2,0,5,0,5,0,2,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,64,1,64,1,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 7,96,8,144,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 3,136,4,80,2,32,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 3,136,4,80,2,32,1,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,128,3,224,0,128,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,230,2,28,2,160,3,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,12,0,68,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,63,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 85,85,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,0,1,1,131,128,1,1,170,170 },
  { 3,128,4,64,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,128,9,128,18,128,12,128,0,128,0,128,0,128,0,128,0,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,128,38,128,74,128,50,128,2,128,2,128,2,128,2,128,2,128,0,0,0,0,0,0 },
  { 0,0,0,0,48,72,48,0,120,0,48,72,48,0,0,0 },
  { 62,60,65,66,112,130,72,2,112,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,64,2,64,2,63,252 },
  { 0,0,19,25,20,161,20,177,20,145,180,155,84,149,20,145,20,145,22,81,21,81,21,81,22,49,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,4,64,9,32,10,160,10,160,9,32,8,32,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,113,0,138,136,170,149,146,82,68,80,56,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,192,1,0,1,128,0,128,3,224,0,128,2,128,4,128,3,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,28,34,32,28,2,18,36,24,0,0,0 },
  { 0,0,3,192,4,32,8,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,99,134,109,190,109,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,99,134,109,190,109,142,109,190,99,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,8,32,8,32,8,32,8,32,8,32,8,32,8,32,7,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,8,32,9,16,6,16,0,16,0,16,0,16,14,16,17,224,0,0,0,0,0,0 },
  { 0,0,32,0,32,0,32,0,39,112,40,136,44,8,42,8,42,8,44,8,32,8,32,8,31,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,30,240,33,8,33,8,33,8,33,8,49,8,41,8,41,8,49,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,4,0,8,3,232,4,24,8,192,9,32,8,128,8,64,8,32,7,224,0,0,0,0,0,0 },
  { 0,0,6,0,9,16,9,32,10,32,7,224,4,0,8,192,9,32,8,128,8,64,8,32,7,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,0,8,0,11,224,12,16,0,16,6,16,9,16,8,32,7,192,0,0,0,0,0,0 },
  { 0,0,0,2,0,4,0,4,29,196,34,36,32,36,32,36,32,36,48,36,40,36,40,36,48,24,0,0,0,0,0,0 },
  { 0,0,0,8,0,16,7,208,8,48,16,0,16,48,16,80,16,144,16,80,16,16,19,208,12,48,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,15,16,16,208,16,48,8,0,31,0,32,128,36,64,24,48,0,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,111,182,99,134,111,182,97,182,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,142,111,182,99,142,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,198,111,190,99,190,111,190,97,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,142,111,182,99,182,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,111,190,99,142,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,111,190,99,142,111,190,97,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,48,72,72,72,48,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,40,40,68,64,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,32,32,32,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,36,90,137,0,0,0 },
  { 0,0,0,0,0,0,0,0,68,68,40,40,16,0,0,0 },
  { 0,0,0,0,0,0,0,68,40,16,40,40,16,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,16,16,8,8,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,34,84,136,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,16,16,32,32,0,0,0 },
  { 0,0,0,0,0,0,0,24,32,64,120,4,24,0,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,246,123,238,123,222,113,222,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,120,112,132,8,132,4,4,2,8,1,240,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,128,1,128,0,0,0,0,1,128,1,128,0,0,0,0,1,128,1,128,0,0,0,0,1,128,1,128,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,0,3,128,15,224,3,128,1,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,3,128,15,224,3,128,1,0,0,0,0,0,1,0,3,128,15,224,3,128,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,48,12,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,0,3,128,15,224,3,128,1,0,16,16,56,56,254,254,56,56,17,16,3,128,15,224,3,128,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,1,128,1,128,1,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,1,128,7,128,15,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,8,8,16,7,224,3,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,8,8,16,7,224,3,192,0,0,0,0,16,8,8,16,7,224,3,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 85,85,128,0,60,69,160,68,56,41,160,40,32,17,128,0,0,1,156,16,32,49,152,16,4,17,184,124,0,1,170,170 },
  { 85,85,128,0,60,69,160,68,56,41,160,40,32,17,128,0,0,1,156,120,32,5,152,56,4,65,184,124,0,1,170,170 },
  { 85,85,128,0,60,69,160,68,56,41,160,40,32,17,128,0,0,1,156,120,32,5,152,56,4,5,184,120,0,1,170,170 },
  { 85,85,128,0,34,69,182,68,42,41,162,40,34,17,128,0,0,1,129,192,2,1,129,128,0,65,131,128,0,1,170,170 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,115,134,109,190,109,142,109,190,115,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,24,24,32,4,32,4,32,4,32,4,24,24,7,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,224,19,24,32,4,32,4,32,4,32,4,24,24,7,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,24,24,32,4,0,4,0,4,0,4,24,24,23,224,16,0,8,0,6,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,24,24,32,4,0,4,1,248,0,4,24,24,23,224,16,0,8,0,6,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,0,24,200,32,36,32,4,32,4,32,4,24,24,7,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,0,24,0,32,0,32,0,16,0,15,224,0,24,0,96,1,128,6,0,24,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,24,24,32,4,32,4,35,228,32,132,24,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,136,24,100,0,20,0,20,31,228,32,4,32,4,24,24,7,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,56,0,38,0,33,128,32,96,32,24,24,0,6,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,24,24,32,4,32,4,32,4,33,196,25,56,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,123,134,115,182,123,134,123,182,113,182,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,123,142,115,182,123,142,123,182,113,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,123,198,115,190,123,190,123,190,113,198,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,123,142,115,182,123,182,123,182,113,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,123,134,115,190,123,142,123,190,113,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,123,134,115,190,123,142,123,190,113,190,127,254,0,0 },
  { 0,0,0,16,0,8,15,248,1,128,1,128,7,128,8,0,16,0,28,0,3,136,0,112,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,15,248,1,128,1,128,1,128,97,128,33,128,31,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,15,248,1,128,1,128,7,240,8,8,16,8,32,8,0,112,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,15,248,1,128,1,128,1,128,15,128,17,128,17,128,15,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,15,248,1,128,1,128,1,128,15,128,17,128,17,128,15,128,1,128,1,128,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,15,248,1,128,1,128,1,128,15,128,17,128,17,128,15,128,1,128,1,128,3,128,15,0,0,0 },
  { 0,0,0,16,0,8,15,248,1,128,1,128,1,128,15,128,17,128,17,128,15,128,1,128,3,128,5,128,9,128,0,0 },
  { 0,0,0,16,0,8,15,248,1,128,1,128,1,128,15,128,17,128,17,128,9,128,1,128,1,128,3,128,15,0,0,0 },
  { 0,0,0,16,0,8,111,248,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,3,128,1,128,1,128,7,240,8,8,16,4,0,4,0,4,0,120,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,240,17,136,17,136,15,136,0,8,0,8,1,240,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,49,240,49,136,49,136,31,136,0,8,0,8,3,240,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,1,128,11,240,13,136,1,136,1,136,31,240,1,128,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,1,128,171,240,173,136,1,136,1,136,31,240,1,128,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,64,0,32,15,248,1,136,1,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,70,0,40,15,248,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,64,0,128,0,112,0,8,15,248,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,128,1,0,0,230,0,22,15,240,1,134,1,134,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,128,1,64,2,32,4,16,2,32,15,192,3,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,240,17,128,41,128,37,128,25,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,1,128,49,128,25,128,25,128,25,128,31,128,1,128,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,25,128,97,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,41,128,17,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,64,0,39,128,25,128,97,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,17,128,17,128,9,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,111,240,17,136,17,136,15,136,0,8,0,8,1,240,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,240,8,8,48,8,0,8,0,8,1,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,240,9,136,49,136,0,8,0,8,1,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,33,128,49,128,49,128,31,128,41,128,41,128,17,128,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,33,128,49,128,49,128,31,128,33,128,33,128,17,128,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,15,248,1,128,1,128,15,128,16,0,32,0,23,128,9,128,1,128,1,128,0,0,0,0,0,0 },
  { 0,0,31,240,32,8,40,68,16,36,7,248,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,68,0,40,15,248,1,128,1,128,15,128,16,0,32,0,23,128,9,128,1,128,1,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,16,0,32,0,23,128,9,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,17,128,17,128,15,128,1,128,15,128,17,128,17,128,15,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,0,0,1,240,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,31,248,1,128,1,128,15,128,17,128,17,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,15,248,1,128,1,128,15,252,0,4,0,8,12,48,3,192,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,31,248,1,128,1,128,15,128,17,128,17,128,31,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,31,248,1,128,1,128,15,240,17,136,49,136,79,136,64,8,0,16,1,224,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,31,248,1,128,1,128,15,128,17,144,17,224,31,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,31,248,1,128,1,128,15,240,17,136,17,136,15,136,0,8,0,16,1,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,3,128,1,128,15,128,17,128,17,128,1,128,97,128,33,128,17,128,15,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,17,128,17,128,15,128,97,128,33,128,17,128,15,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,128,1,128,31,248,17,128,23,224,24,16,0,8,0,8,0,16,1,224,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,111,248,3,128,1,128,111,128,3,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,39,248,83,128,81,128,39,128,3,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,128,1,240,2,8,4,16,8,32,15,228,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,224,4,16,8,16,15,224,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,25,128,19,128,13,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,33,128,81,128,81,128,49,128,15,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,33,128,81,128,81,128,79,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,33,128,17,128,17,128,15,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,25,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,25,128,41,128,41,128,17,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,252,20,2,24,2,0,2,0,4,0,56,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,11,252,4,2,8,2,0,2,0,4,0,56,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,3,128,1,128,15,128,16,0,32,0,23,128,9,128,1,128,3,128,15,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,240,17,136,17,132,79,132,96,4,80,8,79,240,1,128,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,240,33,144,33,144,17,248,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,29,128,77,128,45,128,63,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,152,24,0,32,0,63,192,0,48,0,10,0,4,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,3,128,1,128,7,128,25,128,33,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,144,15,160,3,192,1,160,1,144,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,0,8,31,248,1,128,1,128,15,128,17,152,17,132,15,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,17,128,17,128,15,128,1,128,3,128,5,128,9,128,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,3,128,1,128,15,128,3,128,1,128,97,128,17,128,15,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,8,0,16,0,31,224,0,26,72,4,36,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,128,17,128,23,224,24,24,0,4,0,4,24,24,7,224,1,136,1,132,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,128,17,128,23,224,24,24,0,4,0,4,24,28,7,234,1,138,1,132,1,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,240,17,136,17,136,15,176,0,8,0,8,1,240,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,4,32,8,64,16,48,0,8,31,248,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,128,1,144,1,168,1,196,1,132,1,132,15,248,1,128,1,128,0,0,0,0,0,0 },
  { 0,128,1,64,2,32,4,16,2,32,15,192,3,144,1,136,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,128,67,128,69,128,57,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,8,0,4,0,4,0,24,7,224,25,128,33,128,33,128,17,128,1,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,224,4,16,24,16,0,20,0,34,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,192,4,36,24,42,0,42,0,68,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,0,2,0,1,200,0,40,15,254,1,136,1,136,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,0,2,0,1,196,0,36,15,252,1,132,1,132,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,248,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,33,144,17,168,17,168,15,144,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,128,67,144,69,168,57,168,1,144,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,25,128,97,128,1,128,7,128,25,128,97,128,1,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,3,128,1,128,1,128,7,128,24,0,32,0,63,192,0,48,36,10,18,4,0,0,0,0 },
  { 0,0,0,0,0,0,55,128,9,128,49,128,1,128,3,128,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,128,1,136,1,132,1,132,1,152,7,224,25,128,33,128,33,128,17,128,1,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,25,144,1,168,1,168,1,144,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,206,125,182,123,206,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,206,125,182,123,198,119,246,119,206,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,134,125,182,123,134,119,182,119,182,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,142,125,182,123,142,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,198,125,190,123,190,119,190,119,198,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,142,125,182,123,182,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,134,125,190,123,142,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,134,125,190,123,142,119,190,119,190,127,254,0,0 },
  { 0,0,0,0,0,0,3,192,4,32,4,32,19,200,8,16,7,224,3,192,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,2,64,2,64,1,128,1,128,2,64,2,64,1,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,240,4,32,2,64,1,128,2,64,4,32,15,240,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,17,16,33,8,33,8,34,136,28,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,28,112,34,136,33,8,33,8,17,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,3,128,4,64,4,32,2,32,0,64,3,128,4,64,4,32,2,32,0,64,7,128,0,64,0,32,0,0 },
  { 0,0,0,0,0,0,99,24,148,164,82,148,16,132,99,24,148,164,82,148,16,132,231,56,16,132,8,66,0,0,0,0 },
  { 0,0,0,16,0,8,31,248,1,128,1,128,1,128,1,128,1,128,1,128,1,128,9,128,5,128,3,0,0,0,0,0 },
  { 0,0,0,16,0,8,31,248,1,128,7,224,8,16,16,8,16,4,8,4,0,24,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,224,24,24,32,4,0,4,0,8,1,240,1,128,1,128,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,16,64,8,47,248,1,128,1,128,15,224,16,16,0,16,0,32,0,192,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,49,128,9,128,9,128,15,128,73,128,73,128,49,128,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,128,9,128,19,128,37,128,57,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,17,128,17,128,15,128,3,128,5,128,9,128,5,128,3,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,25,128,33,128,33,128,29,128,5,128,25,128,1,128,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,25,128,49,128,49,128,1,128,1,128,1,128,1,128,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,25,128,35,128,37,128,25,128,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,25,128,33,128,21,128,9,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,224,9,152,17,132,17,132,15,136,0,16,0,224,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,49,224,73,152,73,132,41,132,7,136,0,16,0,224,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,192,8,60,0,2,96,2,0,2,96,4,7,248,1,128,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,252,32,2,32,2,32,2,16,4,7,248,1,128,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,224,9,152,41,132,41,132,23,136,0,16,0,224,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,240,16,8,16,8,16,8,12,16,0,224,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,25,128,19,128,13,128,9,128,9,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,224,16,16,39,16,41,144,41,144,39,224,1,128,1,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,128,17,128,17,128,31,240,0,8,0,8,0,16,7,224,1,142,1,128,1,132,1,138,1,132,1,128,0,0 },
  { 0,0,0,16,0,8,31,248,1,128,9,128,21,128,21,128,9,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,2,0,4,0,3,148,0,122,15,250,1,154,1,148,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,2,0,4,0,3,144,0,112,15,240,1,144,1,128,1,144,1,168,1,168,1,144,1,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,12,0,48,3,192,13,144,49,168,1,168,1,144,1,128,1,128,1,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,13,144,49,168,1,144,1,128,1,144,1,168,1,144,1,128,1,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,25,128,35,128,21,176,9,136,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,128,1,64,2,32,4,16,2,32,15,192,3,156,1,128,1,136,1,148,1,136,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,32,0,64,96,48,0,8,103,248,1,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,12,0,48,3,192,13,128,49,128,1,128,1,128,1,128,1,128,1,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,4,128,9,0,16,196,0,42,31,234,1,132,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,128,1,0,0,196,0,42,31,234,1,132,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,5,128,9,128,5,128,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,76,0,113,128,71,128,57,128,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,240,17,136,17,136,15,136,0,16,1,224,1,136,1,148,1,148,1,136,1,128,0,0,0,0 },
  { 0,0,32,0,32,0,64,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,70,0,40,31,248,1,128,1,144,1,168,1,168,1,144,1,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,142,109,182,97,142,109,182,109,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,198,109,190,97,190,109,190,109,198,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,142,109,182,97,182,109,182,109,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,134,109,190,97,142,109,190,109,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,134,109,190,97,142,109,190,109,190,127,254,0,0 },
  { 0,8,20,72,96,80,72,68,66,68,72,80,96,64,0,0 },
  { 0,16,40,18,6,10,18,34,66,34,18,10,6,2,0,0 },
  { 0,88,188,90,6,10,18,34,66,34,18,10,6,2,0,0 },
  { 0,4,10,4,1,3,5,73,81,9,5,3,1,0,0,0 },
  { 0,8,20,72,32,16,8,4,2,4,8,16,32,64,0,0 },
  { 0,16,40,18,4,8,16,32,64,32,16,8,4,2,0,0 },
  { 0,8,20,72,32,16,8,4,98,100,8,16,32,64,0,0 },
  { 0,8,20,8,0,30,32,64,64,64,64,64,32,30,0,0 },
  { 0,8,20,72,64,64,64,64,64,120,68,68,68,56,0,0 },
  { 0,2,5,18,16,16,16,16,80,94,17,17,17,14,0,0 },
  { 0,32,80,32,0,32,32,32,32,32,32,32,32,62,0,0 },
  { 0,0,0,8,20,8,0,0,12,18,18,18,18,124,0,0 },
  { 0,0,0,16,40,16,0,0,48,72,72,72,72,62,0,0 },
  { 0,0,0,4,10,4,0,0,48,64,64,64,64,63,0,0 },
  { 0,8,20,9,1,1,1,1,7,8,16,16,16,16,0,0 },
  { 0,2,5,18,16,16,16,16,28,2,1,1,1,1,0,0 },
  { 0,8,20,8,0,62,1,1,1,62,64,64,64,62,0,0 },
  { 0,8,20,8,0,62,64,64,64,62,1,1,1,62,0,0 },
  { 0,4,10,4,0,14,1,1,97,110,16,16,16,14,0,0 },
  { 0,16,40,18,2,2,2,2,62,32,16,8,4,2,0,0 },
  { 0,4,10,36,32,32,32,32,62,2,4,8,16,32,0,0 },
  { 16,40,16,0,28,32,64,64,32,28,4,4,4,4,0,0 },
  { 0,0,0,0,0,0,0,0,79,84,20,20,20,8,0,0 },
  { 0,0,0,0,0,0,0,0,61,81,80,80,80,32,0,0 },
  { 0,0,0,0,0,8,8,0,79,84,20,20,20,8,0,0 },
  { 0,0,0,0,0,32,32,0,61,81,80,80,80,32,0,0 },
  { 0,0,0,0,0,0,0,0,6,9,73,73,9,62,0,0 },
  { 0,0,0,0,0,0,0,0,9,21,20,20,20,120,0,0 },
  { 0,0,0,0,0,4,4,0,6,9,73,73,9,62,0,0 },
  { 0,0,0,0,0,4,4,0,8,21,21,20,20,120,0,0 },
  { 0,0,0,0,0,0,0,0,128,185,9,9,9,6,0,0 },
  { 0,0,0,0,0,0,0,0,128,152,36,36,36,39,0,0 },
  { 0,0,0,0,0,0,8,8,128,152,36,36,36,39,0,0 },
  { 0,0,0,28,2,1,1,66,92,16,16,16,16,16,0,0 },
  { 8,8,0,28,2,1,1,66,92,16,16,16,16,16,0,0 },
  { 0,0,0,7,8,16,16,72,71,1,1,1,1,1,0,0 },
  { 0,0,0,16,16,40,40,68,68,0,0,0,0,0,0,0 },
  { 0,0,0,24,36,36,36,36,0,0,0,0,0,0,0,0 },
  { 0,0,0,24,36,56,32,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,24,36,36,32,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,56,32,32,32,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,30,40,40,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,4,8,48,32,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,49,73,70,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,8,72,84,20,34,62,0,0,0,0,0,0,0 },
  { 0,0,0,16,18,42,40,68,124,0,0,0,0,0,0,0 },
  { 0,0,16,40,16,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,24,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,1,229,36,36,36,24,0,0,0 },
  { 8,8,0,32,32,32,32,32,56,4,2,2,4,56,0,0 },
  { 8,8,0,2,2,2,2,2,14,16,32,32,16,14,0,0 },
  { 0,0,0,68,164,196,133,133,132,132,132,132,72,48,0,0 },
  { 0,0,0,14,21,34,64,64,65,65,64,32,16,15,0,0 },
  { 0,0,0,84,84,84,85,85,84,68,68,68,68,56,0,0 },
  { 0,0,8,8,0,124,2,1,1,121,1,1,2,124,0,0 },
  { 0,0,8,8,0,31,32,64,64,79,64,64,32,31,0,0 },
  { 0,0,0,56,68,68,68,61,21,20,36,36,68,68,0,0 },
  { 0,16,16,68,68,36,36,20,20,60,68,68,68,56,0,0 },
  { 0,0,0,56,68,84,84,37,5,4,4,4,4,4,0,0 },
  { 0,2,2,0,0,2,2,2,2,50,74,90,66,60,0,0 },
  { 0,8,8,3,69,69,69,57,1,1,1,1,1,1,0,0 },
  { 0,0,0,84,84,84,84,85,85,84,84,84,84,40,0,0 },
  { 0,0,8,8,0,124,2,2,2,124,2,2,2,124,0,0 },
  { 0,0,16,16,0,62,64,64,64,62,64,64,64,62,0,0 },
  { 0,0,0,0,0,60,64,64,66,58,64,64,64,60,0,0 },
  { 0,16,16,0,254,4,8,16,32,64,152,164,132,120,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,20,34,52,66,80,76,144,65,16,34,16,28,16,0,0,0,0 },
  { 0,0,0,24,8,8,8,8,62,0,0,0,0,0,0,0 },
  { 0,0,0,44,50,32,32,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,28,32,24,4,56,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,206,123,182,113,206,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,0,0,0,0,255,128,16,128,32,128,64,128,124,128,8,128,16,128,32,128,78,128,113,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,0,1,0,1,0,2,0,2,0,4,0,4,0,8,0,8,0,15,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,128,66,0,132,0,132,0,132,0,132,0,132,0,132,0,74,64,49,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,120,0,8,64,16,128,33,0,126,0,5,0,8,128,8,128,8,128,7,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,255,128,32,128,32,128,32,128,32,128,17,128,14,128,0,128,0,128,0,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,95,32,65,80,66,32,68,0,79,0,64,128,64,64,32,64,16,64,15,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,120,0,4,64,2,64,1,64,1,64,1,64,17,64,41,64,42,64,28,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,127,128,8,0,16,0,32,0,120,0,78,0,64,0,64,128,33,0,30,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,127,128,0,128,120,128,4,128,4,128,120,128,0,128,0,128,0,128,0,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,0,32,0,32,0,32,0,31,0,32,0,32,0,32,0,32,0,31,0,2,0,4,0,8,0 },
  { 0,0,0,0,0,0,63,192,2,0,2,0,26,0,38,0,35,0,36,160,24,64,0,160,1,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,0,32,128,64,128,1,0,6,0,1,0,0,128,64,128,32,128,31,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,124,0,4,0,4,0,4,0,4,0,63,128,68,64,68,64,68,64,56,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,96,192,31,0,4,0,4,0,7,0,0,128,0,64,64,64,32,128,31,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,124,128,24,128,32,128,32,128,24,128,32,128,32,128,32,128,17,0,14,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,0,1,0,1,0,2,0,2,0,7,128,4,0,8,0,8,0,15,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,32,128,64,64,128,32,128,32,128,32,128,32,128,32,132,32,74,64,49,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,119,0,136,128,8,128,8,128,8,128,8,128,136,128,136,128,119,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,96,192,31,0,4,0,4,0,28,0,32,0,65,128,66,64,34,128,31,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,56,128,68,128,68,128,72,128,80,128,81,128,78,128,32,128,0,128,0,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,127,128,8,128,8,128,16,128,16,128,32,128,64,128,120,128,6,128,1,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,124,0,4,0,8,0,16,0,60,0,2,0,1,0,49,0,73,0,62,0,8,0,8,0,0,0 },
  { 0,0,0,0,0,0,31,0,1,0,1,0,2,0,2,0,6,0,6,0,9,0,8,128,16,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,49,128,46,128,32,128,16,128,14,128,0,128,0,128,0,128,0,128,0,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,128,48,128,80,128,144,128,16,128,9,128,6,128,0,128,0,128,0,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,65,224,65,0,65,0,65,0,65,0,65,0,65,0,65,0,65,0,62,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,26,0,38,0,34,0,34,0,34,0,38,0,26,0,2,0,2,0,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,192,34,64,34,64,34,64,34,64,34,64,28,64,0,64,0,64,0,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,0,33,0,66,0,68,0,79,0,64,128,64,0,32,0,16,64,15,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,127,192,16,0,16,0,28,0,18,0,17,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,127,192,16,0,16,0,31,0,1,0,1,0,9,0,21,0,18,0,14,0,1,0,1,0,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,123,134,115,190,123,142,123,190,113,190,127,254,0,0 },
  { 6,0,9,0,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 3,224,4,16,2,32,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,7,240 },
  { 0,0,0,0,0,0,0,4,0,10,0,10,0,6,0,2,0,2,0,4,0,4,0,8,0,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,18,0,45,0,45,0,27,0,9,0,9,0,18,0,18,0,36,0,36,0,0,0,0,0,0 },
  { 6,0,9,0,7,240,0,4,0,10,0,10,0,6,0,2,0,2,0,4,0,4,0,8,0,8,0,0,0,0,0,0 },
  { 6,0,9,0,7,240,0,18,0,45,0,45,0,27,0,9,0,9,0,18,0,18,0,36,0,36,0,0,0,0,0,0 },
  { 16,0,8,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,64,36,128,5,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,66,0,162,0,34,0,28,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,20,0,34 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,0,162,0,98,0,70,0,58,0,2,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,198,125,190,97,190,111,190,97,198,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,142,125,182,97,182,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,134,125,190,97,142,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,134,125,190,97,142,111,190,97,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,31,0,8,0,16,0,17,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,9,0,6,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,2,64,1,128 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,68,0,0 },
  { 0,0,0,0,0,0,0,32,0,16,0,16,0,18,0,21,0,21,0,14,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,33,0,17,0,17,0,19,0,13,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,34,0,21,0,21,0,14,0,4,0,4,0,4,0,4,0,4,0,4,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,8,0,4 },
  { 0,0,0,0,0,0,0,9,0,9,0,9,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,16,0,32 },
  { 0,0,2,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,224,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,99,198,125,190,113,190,125,190,99,198,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,99,142,125,182,113,182,125,182,99,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,99,134,125,190,113,142,125,190,99,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,99,134,125,190,113,142,125,190,99,190,127,254,0,0 },
  { 0,0,0,0,0,0,16,0,32,0,64,0,64,0,65,128,66,64,66,64,33,64,16,128,15,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,109,238,109,206,97,238,125,238,125,198,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,109,134,109,246,97,134,125,190,125,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,109,142,109,246,97,198,125,246,125,142,127,254,0,0 },
  { 0,0,0,0,0,0,48,0,72,0,72,0,40,0,8,0,8,0,8,0,8,0,0,0,8,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,65,128,34,64,20,64,20,128,8,0,8,0,8,0,8,0,0,0,8,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,4,64,8,32,8,32,8,32,8,32,8,32,8,32,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,8,0,8,0,8,0,8,0,8,96,8,144,8,144,8,80,4,32,3,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,2,128,2,128,4,64,4,64,8,32,8,32,16,16,16,16,16,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,8,64,8,0,4,0,3,128,0,64,0,32,0,32,4,32,3,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,24,48,4,64,2,128,2,128,1,0,2,128,2,128,4,64,8,32,48,24,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,192,4,160,8,160,8,64,8,0,8,0,8,64,8,160,4,160,3,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,4,64,8,32,8,0,8,0,8,0,8,64,8,160,4,160,3,192,0,128,0,64,0,32 },
  { 0,0,0,0,0,0,12,64,16,160,17,0,9,0,6,0,3,0,4,128,4,64,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,16,16,16,16,16,8,32,8,32,4,64,4,64,2,128,2,128,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,224,18,32,10,32,6,64,2,64,0,128,0,128,1,0,2,0,4,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,72,84,36,4,4,4,4,0,0,0 },
  { 0,0,0,0,0,0,72,84,36,4,28,36,28,0,0,0 },
  { 0,0,0,0,0,0,88,100,68,68,68,68,68,0,0,0 },
  { 0,0,0,0,0,0,160,86,26,18,18,22,26,0,0,0 },
  { 0,0,0,0,0,0,160,82,18,18,18,22,26,0,0,0 },
  { 0,0,0,0,0,0,66,66,66,66,66,86,42,0,0,0 },
  { 0,0,0,0,0,0,54,218,146,146,146,178,210,0,0,0 },
  { 0,0,0,0,0,0,182,218,146,146,146,182,218,0,0,0 },
  { 0,0,0,0,0,0,2,2,2,2,66,86,42,0,0,0 },
  { 0,0,0,0,0,0,0,36,36,36,36,44,52,0,0,0 },
  { 0,0,0,0,0,0,150,154,146,146,146,182,218,0,0,0 },
  { 0,0,0,0,0,0,0,36,36,60,36,44,52,0,0,0 },
  { 0,0,0,0,0,0,150,154,146,146,146,182,218,2,4,8 },
  { 0,0,0,0,0,0,0,44,52,36,36,44,52,0,0,0 },
  { 0,0,0,0,0,0,182,218,146,146,146,178,210,16,32,64 },
  { 0,0,0,0,0,0,27,173,73,9,9,9,9,8,16,32 },
  { 0,0,0,0,0,0,72,84,36,4,28,36,28,4,8,16 },
  { 0,0,0,0,0,0,160,82,18,18,18,22,26,2,4,8 },
  { 0,0,0,0,0,0,70,74,74,82,82,98,66,0,0,0 },
  { 0,0,0,4,4,4,4,4,4,4,4,4,4,0,0,0 },
  { 0,0,0,60,36,36,36,60,36,36,36,52,44,0,0,0 },
  { 0,0,0,60,36,36,36,36,36,36,36,36,36,0,0,0 },
  { 0,0,0,60,36,36,36,36,36,36,36,36,36,4,4,28 },
  { 0,0,0,32,32,32,32,32,32,32,32,32,60,0,60,0 },
  { 0,0,0,32,32,32,32,32,32,32,32,32,60,0,0,0 },
  { 0,0,0,36,36,36,36,36,36,36,36,36,60,0,0,0 },
  { 0,0,0,60,36,36,36,60,36,36,36,52,44,32,32,56 },
  { 0,0,0,60,36,36,36,36,36,36,36,36,36,32,32,56 },
  { 0,0,0,60,32,32,32,32,32,32,32,32,32,0,0,0 },
  { 0,0,0,0,0,0,160,82,18,18,18,22,26,2,4,8 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,115,134,111,190,99,142,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,115,134,111,190,99,142,109,190,115,190,127,254,0,0 },
  { 0,0,0,0,0,0,124,36,36,36,36,37,66,0,0,0 },
  { 0,0,0,0,0,0,24,36,68,124,64,68,56,0,0,0 },
  { 0,0,0,0,0,0,28,36,68,68,68,76,52,0,0,0 },
  { 0,0,0,0,0,0,64,36,42,42,38,34,28,0,0,0 },
  { 0,0,0,0,0,0,24,36,64,64,64,68,56,0,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,134,125,190,123,134,119,246,119,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,206,125,190,123,142,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,134,125,246,123,238,119,222,119,222,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,206,125,182,123,206,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,206,125,182,123,198,119,246,119,206,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,134,125,182,123,134,119,182,119,182,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,142,125,182,123,142,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,198,125,190,123,190,119,190,119,198,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,142,125,182,123,182,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,134,125,190,123,142,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,134,125,190,123,142,119,190,119,190,127,254,0,0 },
  { 0,0,0,0,0,0,6,96,9,144,1,16,1,16,1,16,1,32,1,16,1,16,9,16,6,16,0,160,0,64,0,0 },
  { 1,0,2,128,0,0,12,192,19,32,2,32,2,32,2,32,2,32,2,64,2,32,18,32,12,32,1,64,0,128,0,0 },
  { 0,0,0,0,0,0,6,192,9,32,16,16,16,16,12,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,192,2,32,0,32,0,32,1,160,2,64,1,160,0,32,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,16,144,17,16,17,16,18,16,12,96,0,0,3,224,4,16,7,144,16,80,15,224 },
  { 0,0,0,0,0,0,7,192,8,32,16,16,16,16,16,16,16,16,16,16,16,16,8,32,4,64,0,0,0,0,0,0 },
  { 0,0,7,128,8,64,16,32,16,0,23,128,24,64,16,32,16,32,16,32,16,32,8,64,4,128,0,0,0,0,0,0 },
  { 0,0,7,128,8,64,16,32,16,32,22,32,25,32,0,32,0,32,0,32,16,32,8,64,7,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,4,64,4,32,4,32,4,32,3,32,4,32,4,32,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,6,96,9,16,1,16,1,16,1,16,1,16,1,16,1,16,9,144,6,96,0,0,0,0,0,0 },
  { 0,0,0,24,0,36,3,164,4,32,4,32,4,32,4,32,3,32,4,32,4,32,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,4,64,8,64,8,64,8,64,1,128,0,64,0,64,8,64,7,128,0,0,0,0,0,0 },
  { 0,0,7,192,8,32,11,128,12,64,8,64,8,64,8,64,1,128,0,64,0,64,8,64,7,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,24,192,32,32,32,32,32,32,32,32,32,32,34,32,29,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,29,192,34,32,34,32,34,32,34,32,34,32,34,32,34,32,34,32,28,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,4,64,4,32,4,32,4,32,3,32,4,32,4,32,4,160,3,32,0,64,1,128,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,16,144,17,16,17,16,18,80,12,96,0,64,0,96,0,16,2,16,1,224,0,0 },
  { 0,0,3,192,4,32,9,128,10,64,8,64,8,64,8,64,9,128,8,64,8,64,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,8,32,16,16,16,16,9,32,6,192,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,4,64,8,0,8,0,8,0,15,224,0,32,0,32,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,48,0,72,0,64,0,64,8,64,16,64,16,64,16,64,16,64,8,128,7,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,14,64,16,160,16,160,16,160,16,160,12,160,16,168,16,168,16,72,15,176,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,16,144,17,16,17,16,18,16,12,224,0,64,0,96,0,16,2,16,1,224,0,0 },
  { 0,0,0,0,0,0,14,224,17,16,16,16,16,16,16,48,12,208,0,16,0,16,15,16,16,144,23,32,16,64,15,128 },
  { 0,0,0,0,0,0,6,96,9,144,1,16,1,16,1,16,1,16,1,16,1,16,9,16,6,96,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,4,64,8,32,16,16,16,16,19,144,20,80,8,32,7,208,0,16,0,16,16,16,8,32,7,192 },
  { 15,192,16,0,15,128,0,64,14,64,16,64,16,64,16,64,16,64,12,64,16,64,16,128,15,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,16,144,17,16,17,16,18,16,12,96,0,0,7,128,8,64,7,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,16,144,17,16,17,16,18,16,12,224,0,64,28,64,35,128,16,0,0,0,0,0 },
  { 15,0,16,128,16,0,22,192,9,32,16,16,16,16,12,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,192,4,32,8,16,8,16,8,16,8,16,8,16,8,16,4,32,3,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,18,16,17,16,17,16,16,144,12,96,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,16,144,17,16,17,16,18,16,12,96,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,4,64,0,64,0,64,0,64,1,128,0,64,8,64,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,4,64,8,32,16,16,16,16,16,16,16,16,16,16,16,16,8,32,7,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,0,8,128,8,64,4,64,2,32,10,32,4,32,0,64,0,64,0,128,0,0,0,0,0,0 },
  { 1,0,2,128,0,0,3,128,4,64,8,64,0,64,0,64,1,128,0,64,0,64,8,64,7,128,0,0,0,0,0,0 },
  { 1,0,2,128,0,0,4,64,8,32,16,16,16,16,16,16,16,16,16,16,16,16,8,32,7,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,6,192,9,32,16,16,16,16,12,96,0,0,0,0,0,0,7,128,8,64,7,128,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,4,64,0,64,0,64,3,64,4,128,3,64,0,32,7,128,8,64,7,128,0,0,0,0 },
  { 0,0,0,0,0,0,7,192,8,32,16,16,16,16,16,16,8,32,4,64,0,0,3,128,4,64,3,128,0,0,0,0 },
  { 15,192,16,32,16,0,23,192,8,32,16,16,16,16,16,16,8,32,4,64,0,0,3,128,4,64,3,128,0,0,0,0 },
  { 0,0,0,0,0,0,6,96,9,16,1,16,1,16,1,16,9,144,6,96,0,0,3,128,4,64,3,128,0,0,0,0 },
  { 15,192,16,32,16,0,23,192,8,32,16,16,16,16,16,16,8,32,4,64,0,32,3,144,4,80,3,128,0,0,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,198,109,190,97,190,109,190,109,198,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,142,109,182,97,182,109,182,109,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,134,109,190,97,142,109,190,109,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,97,134,109,190,97,142,109,190,109,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,24,0,37,0,26,0,0,0,24,0,37,0,26,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,1,0,1,0,9,0,6,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,9,0,15,0,9,0,9,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,1,0,15,0,8,0,9,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,20,0,20,0,20,0,12,0,4,0,5,0,5,0,2,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,96,0,144,0,144,0,144,0,144,0,80,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,72,0,180,0,180,0,180,0,180,0,180,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,96,0,144,0,128,0,128,0,128,0,64,0,128,0,128,0,144,0,96,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,4,0,10,0,10,0,10,0,10,0,10,0,4,0,27,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,14,0,21,0,21,0,31,0,17,0,17,0,14,0,0,0,0,0,0,0,0 },
  { 0,0,32,0,80,0,80,0,16,0,112,0,144,0,128,0,128,0,144,0,96,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,24,0,37,0,5,0,5,0,37,0,29,0,5,0,2,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,36,0,37,0,37,0,37,0,37,0,29,0,5,0,2,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,24,0,37,0,37,0,37,0,37,0,29,0,5,0,2,0,0,0,0,0,0 },
  { 0,0,0,2,0,5,0,4,0,4,0,4,0,20,0,44,0,44,0,44,0,44,0,52,0,216,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,56,0,85,0,85,0,125,0,69,0,69,0,61,0,2,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,24,0,37,0,37,0,61,0,37,0,37,0,29,0,2,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,4,64,4,64,4,64,4,64,3,192,0,64,1,192,2,64,1,128,0,0,0,0,0,0 },
  { 0,0,7,128,8,64,16,32,16,32,22,32,25,32,0,32,0,32,0,32,0,224,1,32,0,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,4,64,4,0,4,0,4,0,7,128,0,64,1,192,2,64,1,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,4,64,8,32,16,16,16,16,19,144,20,80,8,32,7,208,0,16,0,112,0,144,0,96,0,0 },
  { 0,0,0,0,0,0,6,192,9,32,16,16,16,16,12,112,0,16,0,16,0,112,0,144,0,96,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,4,64,8,64,0,64,0,64,1,128,0,64,6,64,9,64,7,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,4,64,8,32,16,16,16,16,8,48,7,208,0,16,0,112,0,144,0,96,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,8,0,14,0,9,0,6,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,14,0,8,0,9,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,113,134,111,182,111,134,111,182,113,182,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,113,142,111,182,111,142,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,113,198,111,190,111,190,111,190,113,198,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,113,142,111,182,111,182,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,113,134,111,190,111,142,111,190,113,134,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,113,134,111,190,111,142,111,190,113,190,127,254,0,0 },
  { 0,0,0,0,0,0,3,192,4,32,8,16,8,16,8,16,8,16,8,16,8,16,4,32,3,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,192,4,32,0,16,0,16,0,16,4,32,3,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,192,0,32,0,32,0,32,0,32,0,32,0,32,4,32,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,192,2,32,2,0,2,0,2,32,1,192,0,64,0,128,1,0,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,0,8,128,8,0,8,64,8,192,7,64,0,64,0,80,0,80,0,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,6,192,9,32,16,16,16,16,12,112,0,16,0,16,0,80,0,80,0,32,0,0,0,0,0,0 },
  { 0,0,1,192,2,32,4,0,4,0,4,192,5,32,5,0,4,128,4,64,4,32,2,32,1,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,13,128,18,64,32,32,32,32,24,224,0,32,0,32,0,40,0,40,0,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,1,128,2,64,2,64,4,32,4,32,8,16,8,16,16,8,96,6,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,128,4,64,8,32,10,32,9,192,8,0,8,0,8,32,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,32,0,32,0,32,7,64,8,128,8,0,8,0,8,128,7,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,99,142,109,182,109,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,99,198,109,190,109,190,109,190,99,198,127,254,0,0 },
  { 0,0,127,254,123,206,115,182,123,198,123,246,113,206,127,254,127,254,99,142,109,182,109,182,109,182,99,142,127,254,0,0 },
  { 0,0,0,24,0,36,0,36,0,32,28,32,34,32,33,32,33,32,37,32,24,192,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,24,0,36,0,36,0,32,28,32,34,32,33,32,33,32,37,32,24,192,0,0,3,128,4,64,3,128,0,0 },
  { 0,0,0,0,1,192,2,32,2,32,2,32,2,32,1,192,0,8,3,248,4,0,8,224,9,32,8,160,10,32,13,224 },
  { 0,0,3,128,4,64,5,64,2,64,0,64,4,64,3,128,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 0,0,16,0,19,96,20,144,20,16,19,16,16,16,15,224,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 0,0,0,0,14,224,17,16,17,16,25,16,21,16,25,16,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 0,0,2,0,4,0,9,0,10,128,10,0,9,0,7,128,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 4,128,11,128,4,0,9,0,10,128,10,0,9,0,7,128,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 4,0,5,128,6,64,0,64,2,64,5,64,4,64,3,128,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 0,0,0,16,6,200,9,40,8,40,12,40,10,40,12,16,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 0,32,3,224,4,0,8,224,9,32,8,160,10,32,13,192,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 0,0,0,64,0,64,3,192,4,0,3,0,4,64,3,128,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 0,0,28,56,34,68,42,68,18,68,2,68,34,68,28,56,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 0,0,28,56,34,68,42,84,18,36,2,4,34,68,28,56,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 0,0,57,0,69,44,85,82,37,66,5,34,69,2,56,252,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 0,0,56,236,69,18,85,18,37,18,5,146,69,82,57,146,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 0,0,28,16,34,32,42,72,18,84,2,80,34,72,28,60,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 0,36,28,92,34,32,42,72,18,84,2,80,34,72,28,60,0,0,2,64,4,192,3,64,0,64,0,64,0,64,0,0 },
  { 0,32,3,224,4,0,8,224,9,32,8,160,10,32,13,192,0,32,3,224,4,0,8,224,9,32,8,160,10,32,13,192 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,0,0,3,128,4,64,5,64,2,64,0,64,4,64,3,128,0,0 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,0,0,16,0,19,96,20,144,20,16,19,16,16,16,15,224,0,0 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,0,0,0,0,14,224,17,16,17,16,25,16,21,16,25,16,0,0 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,0,0,2,0,4,0,9,0,10,128,10,0,9,0,7,128,0,0 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,4,32,11,224,4,0,9,0,10,128,10,0,9,0,7,128,0,0 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,4,0,5,128,6,64,0,64,2,64,5,64,4,64,3,128,0,0 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,0,0,0,16,6,200,9,40,8,40,12,40,10,40,12,16,0,0 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,0,32,3,224,4,0,8,224,9,32,8,160,10,32,13,192,0,0 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,0,0,0,64,0,64,3,192,4,0,3,0,4,64,3,128,0,0 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,0,0,28,56,34,68,42,68,18,68,2,68,34,68,28,56,0,0 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,0,0,28,56,34,68,42,84,18,36,2,4,34,68,28,56,0,0 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,0,0,57,0,69,44,85,82,37,66,5,34,69,2,56,252,0,0 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,0,0,56,236,69,18,85,18,37,18,5,146,69,82,57,146,0,0 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,0,0,28,16,34,32,42,72,18,84,2,80,34,72,28,60,0,0 },
  { 0,0,4,128,9,128,6,128,0,128,0,128,0,128,0,36,28,92,34,32,42,72,18,84,2,80,34,72,28,60,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,25,0,51,0,102,0,76,0,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,96,2,48,7,24,13,176,24,224,18,64,2,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,48,0,24,0,28,0,54,0,34,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,14,0,27,0,57,0,108,0,196,0,128,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,96,2,48,7,24,13,176,24,224,16,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,0,56,0,108,0,198,0,98,0,48,0,56,0,108,0,198,0,130,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,99,0,54,0,28,0,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,128,24,192,12,96,14,48,27,96,49,192,32,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,28,0,54,0,99,0,65,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,73,0,99,0,54,0,28,0,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,28,0,54,0,99,0,73,0,8,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,96,2,48,7,24,13,176,24,224,18,64,5,0,13,128 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,96,3,48,7,152,12,152,26,48,19,96,1,192,0,128 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,1,224,3,48,6,24,13,176,24,224,16,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,32,28,112,54,216,99,140,69,68,2,128,1,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,32,14,112,27,216,49,140,99,198,66,66,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,32,28,112,54,216,99,140,73,36,8,32,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,0,56,0,108,0,68,0,16,0,56,0,108,0,68,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,192,9,96,28,48,54,152,99,140,65,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,32,28,112,54,216,99,140,65,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,1,224,3,48,3,24,1,176,0,224,0,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,32,28,112,54,216,99,140,65,36,0,32,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,32,28,112,54,216,99,140,99,140,54,216,28,112,8,32,0,0,0,0 },
  { 0,0,0,0,0,6,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,96,0,192,0,96,0,48,0,16,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,28,0,54,0,3,0,1 },
  { 128,0,192,0,96,0,48,0,96,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,123,198,115,190,123,190,123,190,113,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,123,142,115,182,123,182,123,182,113,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,192,0,192,0,0,0,24,0,24,0,0,0,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,56,0,68,0,0,0,68,0,56,0,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,14,224,17,16,32,136,32,136,32,136,17,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,128,8,64,0,32,7,160,8,96,8,96,7,144,0,0,0,0,0,0,0,0 },
  { 0,0,3,128,4,64,8,32,8,0,11,128,12,64,0,32,7,160,8,96,8,96,7,144,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,128,4,64,8,32,8,32,8,32,4,64,0,0,0,0,0,0,0,0 },
  { 0,0,3,128,4,64,8,32,8,0,8,0,11,128,12,64,8,32,8,32,8,32,4,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,40,0,85,16,4,136,8,136,16,136,21,16,10,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,0,16,128,32,64,16,32,32,32,37,32,26,160,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,4,64,2,32,1,32,2,32,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,0,128,14,96,17,16,32,136,0,136,32,136,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,192,4,32,8,32,8,64,8,32,4,32,3,32,0,0,0,0,0,0,0,0 },
  { 0,0,3,128,4,64,8,32,8,0,8,0,11,192,12,32,8,64,8,32,4,32,3,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,0,128,14,96,17,16,8,136,4,136,8,136,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,14,96,17,16,0,136,0,136,32,136,49,16,46,224,32,0,32,0,32,8,16,8,15,240 },
  { 0,0,0,0,0,0,0,0,2,64,5,32,4,16,2,16,4,16,4,16,2,160,1,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,2,64,5,32,4,16,2,16,4,16,4,16,2,176,1,80,0,16,0,16,7,208,8,48,7,224 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,192,4,32,4,32,0,192,3,0,4,192,0,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,40,0,84,16,4,8,8,8,16,8,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,14,224,17,16,34,136,34,136,34,136,17,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,14,224,17,16,32,136,32,136,17,16,14,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,224,8,16,16,8,16,8,12,104,16,104,16,40,18,72,13,136,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,4,192,8,160,16,80,16,16,16,96,16,16,16,16,8,16,7,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,128,4,64,8,32,9,32,10,160,4,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,192,4,32,8,96,8,96,8,0,7,0,0,128,0,64,0,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,128,4,64,8,32,8,32,8,32,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,24,0,32,0,64,0,64,0,64,8,64,16,64,16,64,16,64,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,32,8,80,16,80,16,80,12,80,16,80,16,32,15,208,0,8,0,0,0,0,0,0 },
  { 1,224,2,16,4,0,4,0,2,8,1,248,0,8,6,8,6,8,4,8,2,72,1,176,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,4,64,10,160,9,32,8,32,4,64,2,128,0,0,0,0,0,0,0,0 },
  { 0,0,3,128,4,64,8,32,8,0,8,0,12,64,10,160,9,32,8,32,4,64,2,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,14,224,17,16,32,136,0,136,32,136,17,16,14,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,4,64,8,32,9,160,9,160,4,64,3,160,0,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,10,96,17,16,32,136,32,136,32,136,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,12,0,16,0,16,0,16,0,16,7,16,8,16,8,16,6,16,8,16,8,32,7,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,0,8,128,4,64,2,32,5,16,8,144,8,144,7,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,4,64,10,160,17,16,33,16,48,16,40,16,16,16,0,16,0,16,0,16,7,240,9,16,7,232 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,12,96,18,16,33,8,33,8,16,144,8,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,192,4,32,8,16,8,16,0,32,0,192,3,0,0,192,0,32,0,16,7,240,9,16,7,232 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,192,2,32,4,16,4,16,2,32,1,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,32,3,160,4,64,9,160,9,160,8,32,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,28,16,34,8,65,4,1,52,65,52,34,136,28,116,0,4,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,14,32,17,16,32,136,0,136,32,136,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,12,96,16,144,33,8,33,8,18,16,12,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,224,4,16,8,8,6,8,8,8,9,136,14,72,8,0,8,0,8,0,15,224,8,16,7,224 },
  { 0,0,0,0,0,0,0,0,0,0,14,224,17,16,32,136,0,136,32,136,17,16,14,32,0,16,0,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,12,96,16,144,33,8,33,8,18,16,12,96,0,32,7,224,8,32,7,192 },
  { 0,0,0,0,0,0,6,48,9,72,8,136,8,8,4,16,2,32,0,0,3,192,4,32,8,16,9,144,10,144,4,16 },
  { 0,192,1,32,1,8,1,24,0,232,0,8,3,104,4,152,4,24,2,40,0,8,7,200,8,40,9,168,10,168,4,48 },
  { 0,0,0,0,0,0,3,128,4,64,0,32,0,32,8,32,12,64,11,128,8,0,8,0,8,32,4,64,3,128,0,0 },
  { 0,0,3,128,4,64,4,0,4,0,7,128,4,64,0,64,0,64,4,64,7,128,4,0,4,0,4,64,3,128,0,0 },
  { 0,0,0,0,0,0,3,128,4,64,8,32,8,32,8,32,8,64,9,128,8,0,8,0,8,32,4,64,3,128,0,0 },
  { 0,0,0,0,0,0,48,0,64,0,71,112,72,136,80,68,64,68,80,68,72,136,71,16,64,8,64,4,48,0,0,0 },
  { 0,0,0,6,0,8,0,16,0,16,0,16,24,16,36,16,66,16,66,16,33,32,16,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,51,48,72,136,4,68,4,68,72,136,55,112,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,48,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,48,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,96,9,16,8,144,6,96 },
  { 0,0,0,0,0,0,0,12,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,3,130,4,90,4,68,2,58 },
  { 0,0,0,0,0,0,0,0,0,14,0,10,0,100,0,155,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,7,192,8,32,17,144,18,80,13,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,64,2,160,2,32,1,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,8,0,8,3,200,4,16,3,224 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,64,4,32,4,96,4,48,3,200 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,64,4,32,4,32,4,32,3,192 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,48,8,136,0,136,8,136,7,112 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,111,190,97,142,125,190,97,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,128,3,224,0,128,0,128 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,13,0,0,0,0,0,14,0,13,0,0,0,0,0,0 },
  { 0,0,0,0,0,48,0,192,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,1,0,9,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,56,0,68,0,130,0,130,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,0,0,0,0,0,0,0 },
  { 1,192,2,32,4,16,5,16,2,160,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,224,2,16,4,32,5,16,2,136,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 7,240,8,72,8,168,10,72,5,8,2,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,216,2,36,4,18,5,18,2,164,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,64,0,64,0,72,0,48 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,192,0,200,0,176 },
  { 0,0,0,0,0,0,0,224,0,208,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,20,0,40,0,33,8,17,136,14,112 },
  { 0,0,0,3,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,116,0,180,0,132,0,100,0,136,0,112 },
  { 0,0,0,0,0,0,0,0,0,0,60,0,66,0,128,0,132,0,138,0,70,0,56,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,0,137,0,138,0,187,0,119,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,48,0,72,0,128,0,128,0,64,0,48,0,72,0,128,0,128,0,72,0,48,0,0,0,0,0 },
  { 0,0,0,0,192,0,32,0,32,0,16,0,16,0,8,0,56,0,72,0,128,0,128,0,72,0,48,0,0,0,0,0 },
  { 0,0,0,0,112,0,136,0,136,0,8,0,8,0,8,0,56,0,72,0,128,0,128,0,72,0,48,0,0,0,0,0 },
  { 0,0,0,0,0,128,0,128,1,64,6,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,128,1,64,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,128,0,128,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,8,0,144,0,160,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,8,0,8,0,20,0,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,1,0,1,0,1,0,9,0,5,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,6,0,9,0,1,0,9,0,14,0,8,0,9,0,6,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,112,0,200,0,164,0,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,6,0,9,0,8,0,8,0,8,0,8,0,4,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,49,0,13,0,138,0,138,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,142,125,182,123,182,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,125,190,123,142,119,190,119,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,144,0,144,0,96 },
  { 0,0,0,0,0,0,0,0,0,0,1,192,2,32,4,16,4,16,4,16,2,32,1,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,192,2,32,4,16,0,16,4,16,2,32,1,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,4,16,4,16,4,16,2,32,1,192 },
  { 0,0,0,0,0,0,0,0,3,128,4,64,8,32,0,32,8,32,4,64,3,128,2,0,1,0,1,0,0,128,0,64 },
  { 0,0,0,0,0,0,0,0,3,128,4,64,8,32,8,0,8,32,4,64,3,128,0,128,1,0,1,0,2,0,4,0 },
  { 0,0,7,192,8,32,16,16,16,16,16,16,22,16,9,16,6,16,0,16,0,16,16,16,16,16,16,16,8,32,7,192 },
  { 0,0,3,224,4,16,8,8,8,8,8,8,8,0,8,0,8,96,8,144,8,224,8,128,8,96,8,16,4,16,3,224 },
  { 0,0,3,192,4,32,8,16,8,16,12,16,10,16,4,16,0,16,0,16,0,16,0,16,0,12,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,192,4,32,8,16,8,16,10,16,5,16,2,96,0,0,0,0,0,0,0,0 },
  { 0,0,3,224,4,16,8,16,8,96,8,128,8,224,8,144,8,96,8,0,8,0,8,8,8,8,8,8,4,16,3,224 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,115,134,109,182,115,134,109,182,115,182,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,115,142,109,182,115,142,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,115,198,109,190,115,190,109,190,115,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,115,142,109,182,115,182,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,115,134,109,190,115,142,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,115,134,109,190,115,142,109,190,115,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,192,2,32,4,16,4,16,4,16,2,32,1,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,16,0,8,1,200,2,40,4,16,4,0,5,0,2,128,1,0,0,0,0,0,0,0,0,0 },
  { 1,192,2,32,4,16,4,16,4,16,4,0,4,0,4,0,4,0,4,0,4,0,6,0,5,0,2,0,0,0,0,0 },
  { 0,0,1,0,1,0,0,128,0,128,14,96,17,16,32,136,0,136,32,136,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 4,128,9,64,16,160,16,32,16,32,16,192,16,32,24,32,23,192,16,0,16,0,16,0,17,224,18,16,8,16,7,224 },
  { 0,0,0,0,0,16,0,16,0,32,0,192,3,0,4,16,8,40,8,20,8,4,8,4,8,24,8,132,4,132,3,120 },
  { 0,0,0,0,0,12,0,16,0,16,0,16,0,16,8,16,20,16,40,16,32,16,32,16,24,16,33,16,33,32,30,192 },
  { 0,0,0,0,0,0,4,48,10,8,20,4,16,4,16,4,12,4,16,132,16,136,15,112,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,2,32,5,80,4,144,4,16,2,96,0,64,0,64,0,64,0,64,3,240,4,64,9,240,10,72,4,48 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,12,96,18,16,33,8,41,8,20,144,8,96,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,115,134,109,182,113,134,125,182,115,182,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,115,142,109,182,113,142,125,182,115,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,115,198,109,190,113,190,125,190,115,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,115,142,109,182,113,182,125,182,115,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,115,134,109,190,113,142,125,190,115,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,115,134,109,190,113,142,125,190,115,190,127,254,0,0 },
  { 0,0,0,0,3,224,4,144,8,136,16,132,16,132,31,252,16,132,16,132,8,136,4,144,3,224,0,0,0,0,0,0 },
  { 0,0,0,0,3,128,4,128,8,128,16,128,16,128,31,252,16,132,16,132,8,136,4,144,3,224,0,0,0,0,0,0 },
  { 0,9,0,38,0,28,0,104,0,16,14,96,17,16,32,136,0,136,32,136,17,16,14,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,128,1,64,1,192,2,32,12,152,21,84,12,152,2,32,1,192,1,64,0,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,224,16,16,39,200,40,40,41,200,40,16,39,224,16,12,15,240,0,0,0,0,0,0,0,0 },
  { 0,0,3,224,2,32,9,72,21,84,10,168,101,83,90,45,68,17,90,45,101,83,10,168,21,84,9,72,2,32,3,224 },
  { 0,0,1,192,2,32,4,16,4,16,1,144,2,96,2,0,2,96,1,144,4,16,4,16,2,32,1,192,0,0,0,0 },
  { 0,0,3,176,4,72,10,72,4,8,0,8,0,16,0,96,1,128,2,0,4,0,4,0,4,0,2,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,128,0,128,0,128,0,128,0,128,0,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,64,2,64,2,64,2,64,2,64,2,64,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,2,64,1,192,0,64,0,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,32,2,32,4,32,4,160,3,160,0,160,0,160,0,0,0,0,0,0,0,0 },
  { 0,0,0,56,0,4,0,4,1,196,2,40,0,48,14,32,17,64,1,128,17,0,14,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,2,128,5,32,4,16,2,8,4,8,4,8,2,16,1,224,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,109,190,97,142,109,190,109,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,109,190,97,142,109,190,109,190,127,254,0,0 },
  { 0,0,40,84,146,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,40,170,16,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,108,146,108,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,16,84,56,16,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,68,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,85,34,85 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,84,170,170 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,4 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,36,36,18 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,32,64,128 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,32,192,192 },
  { 0,0,68,130,130,68,0,0,0,0,0,0,0,0,0,0 },
  { 0,36,195,195,195,195,36,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,68,130,130,68 },
  { 0,0,0,0,0,0,0,0,0,0,66,129,129,66,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,134,109,190,99,142,109,190,99,190,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,206,111,182,111,182,111,182,113,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,238,111,206,111,238,111,238,113,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,134,111,246,111,134,111,190,113,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,142,111,246,111,198,111,246,113,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,182,111,182,111,134,111,246,113,246,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,134,111,190,111,134,111,246,113,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,206,111,190,111,142,111,182,113,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,134,111,246,111,238,111,222,113,222,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,206,111,182,111,206,111,182,113,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,206,111,182,111,198,111,246,113,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,134,111,182,111,134,111,182,113,182,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,142,111,182,111,142,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,198,111,190,111,190,111,190,113,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,142,111,182,111,182,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,134,111,190,111,142,111,190,113,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,113,134,111,190,111,142,111,190,113,190,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,206,109,182,109,182,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,238,109,206,109,238,109,238,99,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,134,109,246,109,134,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,142,109,246,109,198,109,246,99,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,182,109,182,109,134,109,246,99,246,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,134,109,190,109,134,109,246,99,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,206,109,190,109,142,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,134,109,246,109,238,109,222,99,222,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,206,109,182,109,206,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,206,109,182,109,198,109,246,99,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,134,109,182,109,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,142,109,182,109,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,198,109,190,109,190,109,190,99,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,142,109,182,109,182,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,134,109,190,109,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,99,134,109,190,109,142,109,190,99,190,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,206,111,182,99,182,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,238,111,206,99,238,111,238,97,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,111,246,99,134,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,142,111,246,99,198,111,246,97,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,182,111,182,99,134,111,246,97,246,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,111,190,99,134,111,246,97,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,206,111,190,99,142,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,111,246,99,238,111,222,97,222,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,206,111,182,99,206,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,206,111,182,99,198,111,246,97,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,111,182,99,134,111,182,97,182,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,142,111,182,99,142,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,198,111,190,99,190,111,190,97,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,142,111,182,99,182,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,111,190,99,142,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,111,190,99,142,111,190,97,190,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,206,111,182,99,182,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,238,111,206,99,238,111,238,111,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,111,246,99,134,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,142,111,246,99,198,111,246,111,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,182,111,182,99,134,111,246,111,246,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,111,190,99,134,111,246,111,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,182,123,134,123,182,113,182,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 15,224,17,16,18,144,9,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,0,10,160,10,160,7,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,0,2,128,0,64,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,2,0,1,0,0,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,2,0,5,0,1,0,2,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,14,112,17,40,36,164,42,36,34,252,36,164,18,36,12,196,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,56,0,68,56,146,68,168,130,136,130,146,130,73,68,54,40,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,17,176,42,72,10,8,10,8,4,200,1,0,0,192,2,32,1,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,70,204,169,34,40,33,40,33,19,38,4,0,3,0,8,128,7,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,11,128,4,64,0,64,0,128,3,0,4,0,9,192,10,32,4,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,23,48,8,136,0,132,1,4,6,24,8,0,19,128,20,64,8,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,16,20,40,4,40,3,200,1,128,2,0,1,128,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,152,161,68,33,66,30,66,12,12,16,0,12,0,34,0,28,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,17,176,42,72,10,10,10,124,4,136,1,16,0,144,0,96,0,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,70,192,169,32,40,46,41,241,18,33,4,66,2,73,1,137,1,6,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,12,0,16,0,19,128,20,64,12,32,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,70,197,169,43,40,46,40,34,16,66,7,130,8,2,16,194,15,60,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,70,192,169,32,40,32,40,32,16,64,7,128,8,0,17,192,14,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,70,204,169,34,40,33,40,33,16,70,7,128,8,0,17,192,14,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,35,204,84,42,20,42,63,42,84,170,35,18,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,35,192,84,32,20,32,63,32,84,160,35,28,0,2,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,35,152,84,84,20,84,20,84,18,148,14,228,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,35,56,85,20,21,20,21,20,21,84,8,164,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,35,96,84,144,20,16,20,16,20,16,12,16,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,112,20,72,4,40,14,40,21,40,8,200,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,60,48,66,40,66,40,74,40,74,40,49,200,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,17,224,42,16,10,16,10,96,10,16,6,8,0,8,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,12,0,18,0,15,70,194,169,34,40,34,40,34,16,66,7,130,8,2,16,194,15,60,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,70,198,169,41,40,41,40,41,40,41,24,50,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,35,96,84,144,16,16,56,16,84,16,72,0,33,0,34,0,28,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,35,96,84,144,16,16,17,16,17,16,14,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,48,80,40,16,40,16,40,19,40,12,200,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,16,40,16,8,16,8,16,9,144,6,96,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,156,226,163,21,64,21,0,21,0,21,0,25,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,35,204,84,42,23,42,16,170,16,170,15,18,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,17,224,40,144,8,80,10,80,9,80,7,144,1,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,112,20,136,4,136,9,200,18,168,12,72,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,120,40,36,8,20,8,20,9,148,6,100,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,240,21,8,5,8,15,200,21,40,8,200,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,96,40,80,8,80,8,80,8,80,7,144,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,136,41,80,8,224,8,64,8,64,7,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,70,204,169,42,40,42,40,42,40,42,24,50,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,240,81,8,9,8,3,200,21,40,8,200,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,176,36,40,36,40,3,40,4,40,4,72,3,136,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,8,80,20,17,20,17,20,18,148,12,100,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,224,41,16,5,16,5,16,5,16,6,16,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,70,12,169,10,41,10,41,10,41,10,16,242,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,240,20,72,4,40,4,40,4,40,3,200,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,71,230,169,21,42,149,40,149,36,165,28,57,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,96,80,80,18,80,21,80,17,80,15,208,1,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,96,40,80,8,80,28,80,42,80,17,144,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,204,161,42,33,42,33,42,33,42,30,18,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,0,0,0,4,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,12,0,2,0,1,0,1,0,9,0,6,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 3,192,20,32,12,32,2,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 3,192,21,32,14,160,4,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,3,0,3,0,3,0,5,0,9,0,17,0,18,0,12 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,4,0,4,0,2,0,1,0,1,0,2,0,4 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,16,4,16,9,144,8,160,7,192,0,128 },
  { 0,0,0,0,0,0,0,0,0,12,0,2,0,1,0,1,0,9,0,38,0,16,4,16,9,144,8,160,7,192,0,128 },
  { 0,224,1,32,18,64,10,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,8,84,136,20,136,8,112 },
  { 0,224,1,32,18,64,10,128,0,12,0,2,0,1,0,1,0,9,0,6,0,0,0,0,35,8,84,136,20,136,8,112 },
  { 0,0,0,0,0,0,0,0,48,0,72,0,8,0,16,0,16,0,32,0,32,0,32,0,16,0,0,0,0,0,0,0 },
  { 56,0,64,0,48,0,8,0,48,0,176,0,200,0,144,0,16,0,32,0,32,0,32,0,16,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,48,12,72,2,8,1,16,1,16,9,32,6,32,0,32,0,16,0,0,0,0,0,0,0 },
  { 56,0,64,0,48,0,8,0,48,12,176,2,200,1,144,1,16,9,32,6,32,0,32,0,16,0,0,0,0,0,0,0 },
  { 0,224,1,32,18,64,10,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,224,1,32,18,64,10,128,0,12,0,2,0,1,0,1,0,9,0,6,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,14,0,17,0,17,0,1,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,0,1,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,35,204,84,42,28,42,63,42,92,170,43,18,8,0,8,128,7,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,71,22,168,173,40,173,124,173,170,173,68,68,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,35,204,84,42,23,42,16,170,20,170,15,18,4,0,4,64,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,48,20,40,4,40,5,40,5,40,3,200,1,0,1,16,0,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,240,20,72,4,40,5,40,5,40,3,200,1,0,1,16,0,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,96,40,80,8,80,29,80,43,80,17,144,1,0,1,16,0,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,67,2,162,165,34,165,114,181,170,181,68,181,0,77,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,109,198,109,190,97,190,125,190,125,198,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,109,142,109,182,97,182,125,182,125,142,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,109,134,109,190,97,142,125,190,125,134,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,109,134,109,190,97,142,125,190,125,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,1,128,2,64,2,64,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,4,0,10,0,7,35,98,84,146,20,18,20,18,20,20,12,56,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,17,176,42,72,10,10,10,124,4,136,1,16,0,144,0,96,0,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,70,192,169,32,40,32,40,32,16,64,7,128,8,0,17,192,14,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,11,0,8,128,9,0,8,128,4,128,3,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,128,8,64,11,32,8,160,9,32,8,160,4,160,3,32,0,32,0,32,0,16,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,12,0,16,0,19,128,20,64,12,32,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,70,34,169,84,41,56,41,16,41,16,24,224,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,136,41,80,8,224,8,64,8,64,7,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,34,80,84,17,56,17,16,18,144,12,96,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,48,18,72,18,72,146,72,146,72,97,137,0,9,0,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,70,204,169,42,40,42,40,42,40,42,24,10,2,63,18,74,17,138,16,10,17,138,14,114 },
  { 0,0,0,0,0,0,0,0,1,128,2,64,2,64,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,16,4,160,3,192,0,0,3,16,4,160,3,192,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,0,5,0,0,128,0,128,0,64,0,64,0,32,0,32,0,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,0,40,160,4,16,4,16,2,8,2,8,1,4,1,4,1,4,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,128,0,64,1,128,4,64,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,12,0,2,0,1,0,1,0,9,0,6,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,5,128,6,64,4,64,0,128,0,128,1,0,1,0,1,0,0,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,64,0,192,0,192,0,192,1,64,2,64,4,64,4,128,3,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,0,5,0,0,128,0,128,0,64,0,64,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,1,0,0,240,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,192,20,32,12,32,2,64,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,112,0,144,9,32,5,64,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,0,16,0,32,0,32,0,16,0,8,0,8,0,16,0,32,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,70,204,169,42,40,42,40,42,16,74,7,138,8,10,17,138,14,114,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,0,20,0,4,0,8,0,4,0,4,0,4,0,8,0,8,0,8,0,4,0,4,0 },
  { 0,128,1,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,0,0,128 },
  { 3,0,1,0,7,192,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,3,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,0,2,128,4,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 7,0,1,0,15,224,3,128,5,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 7,240,1,64,2,32,4,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 4,64,2,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 3,128,4,64,5,64,4,64,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,0,40,0,40,0,68,0,68,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,48,0,72,0,72,0,72,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,144,0,104,0,40,0,84,0,68,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,184,0,68,0,100,0,84,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,0,16,0,32,0,32,0,64,0,120,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,64,0,32,0,120,0,16,0,8,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,144,0,80,0,32,0,48,0,72,0,124,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,97,142,125,182,123,182,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,97,134,125,190,123,142,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,97,134,125,190,123,142,119,190,119,190,127,254,0,0 },
  { 1,128,2,64,4,128,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,16,2,32,5,64,8,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,18,0,10,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,2,64,0,192,1,32,16,32,8,64,7,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,2,0,2,0,4,0,4,0,8,0,15,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,0,64,0,128,1,0,2,48,4,64,7,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,2,72,0,212,1,36,16,32,8,64,7,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,4,64,2,128,1,0,2,48,4,72,7,232,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,4,0,4,64,3,128,16,128,17,0,14,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,32,2,64,1,128,0,0,1,128,2,64,0,192,1,32,16,32,8,64,7,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,62,124,2,4,2,4,4,8,4,8,8,16,8,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,31,252,16,132,16,132,33,8,33,8,66,16,66,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,0,64,0,128,1,56,2,8,4,16,7,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,0,64,0,128,1,0,2,32,4,16,7,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,0,68,0,132,1,8,2,8,29,16,24,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,0,2,32,4,16,9,136,18,72,34,32,63,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,0,64,0,128,1,0,2,48,4,72,7,228,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,31,62,1,2,2,2,4,4,8,196,17,40,31,152,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,32,0,32,0,64,8,120,20,200,4,144,3,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,0,2,0,4,0,9,128,18,64,34,32,63,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,224,0,32,0,64,0,128,1,0,2,0,3,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,62,124,2,4,2,4,4,8,4,8,8,16,15,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,14,4,2,4,2,4,4,8,4,8,8,16,15,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,4,2,4,2,4,4,8,4,8,8,16,15,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,62,2,2,4,4,9,132,18,72,34,40,63,48,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,240,0,16,14,16,2,32,4,32,8,64,15,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,32,0,32,0,72,8,68,20,196,4,184,3,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,224,0,0,7,224,0,32,3,192,0,128,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,16,10,16,10,16,10,16,10,16,9,16,8,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,240,2,0,2,0,2,112,2,16,2,16,1,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,62,124,2,4,2,4,28,56,4,8,8,16,8,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,31,248,1,8,1,8,15,240,2,16,4,32,4,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,30,0,33,7,33,9,17,1,18,2,34,3,194,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,0,6,0,6,0,6,0,10,0,10,1,138,2,18,1,226 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,48,2,8,1,240 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,2,128,4,240 },
  { 7,192,0,64,2,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,192,0,128,1,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,32,0,64,0,176,0,224,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,1,0,2,0,28,0,7,0,0,0,0,0,0,0,0 },
  { 4,0,2,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 5,0,2,32,1,64,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,31,0,1,0,2,0,4,0,7,0,1,0,2,0,4,0,4,0,4,0,3 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,192,0,128 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,64,16,128,17,0,14,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,240,2,16,4,32,8,64,15,120 },
  { 0,0,0,0,0,0,0,0,0,0,127,158,8,161,8,161,17,17,17,18,34,34,35,194,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,127,132,8,132,8,136,127,8,17,18,34,153,34,102,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,192,4,32,8,16,8,16,8,16,4,32,3,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,0,64,0,128,1,56,2,8,4,16,7,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,0,64,0,128,1,0,2,240,4,0,7,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,0,64,0,128,1,56,2,64,4,32,7,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,224,0,0,7,224,0,32,3,240,0,128,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,124,126,4,128,8,128,16,64,32,32,64,16,127,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,0,1,0,2,96,2,128,4,96,4,16,7,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,16,10,16,10,16,10,16,10,16,9,16,8,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,200,0,72,0,144,13,16,18,32,21,32,8,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,192,1,0,2,96,2,128,4,96,4,16,7,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,224,0,32,0,32,7,192,0,64,0,128,0,128,1,0,1,0,2,0,2,0 },
  { 0,0,0,0,0,0,0,0,0,0,62,124,2,4,2,4,4,8,4,8,8,16,8,16,15,240,0,0,15,240,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,28,56,32,8,32,8,68,16,74,16,137,32,253,160,0,32,0,224,1,52,0,200 },
  { 0,0,0,0,0,0,0,0,0,0,62,124,34,68,50,76,4,128,4,128,4,128,31,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,62,124,2,4,50,100,20,40,36,72,40,80,8,16,63,252,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,248,0,8,3,200,0,16,3,144,0,32,3,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,17,16,9,8,6,56,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,17,16,9,0,6,48,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,14,224,17,16,2,16,4,32,8,64,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,12,96,16,16,0,0,0,0,3,48,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,12,96,16,16,2,32,4,64,8,128,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,12,96,16,16,17,16,18,144,12,96,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,224,8,16,16,8,16,8,8,16,7,224,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,17,16,14,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,63,0,0,0,3,224,4,16,8,8,4,16,3,224,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,63,0,0,0,14,112,1,128,2,64,4,32,3,192,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,12,96,16,16,16,16,28,112,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,12,96,16,16,0,0,28,112,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,15,128,8,0,8,0,7,128,0,64,0,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,12,96,16,16,0,32,0,64,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,12,96,16,16,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,96,1,128,6,0,24,56,3,0,0,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,96,1,128,6,0,24,0,3,0,0,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,12,96,16,16,7,192,8,32,16,16,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,31,0,0,0,31,240,0,0,0,112,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,31,56,4,64,4,128,4,192,3,48,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,0,8,152,0,96,1,128,6,0,0,192,0,48,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,240,4,32,2,64,1,128,2,64,12,48,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,48,4,72,4,136,3,56,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,14,240,17,8,2,0,3,0,0,192,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,12,96,16,16,0,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,12,96,18,16,1,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,48,4,72,4,136,3,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,14,0,17,48,4,72,4,136,3,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,96,1,128,6,0,24,0,6,0,1,128,0,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,192,6,48,8,8,4,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,12,96,16,16,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,7,192,8,32,17,0,24,128,6,64,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,28,194,35,36,34,24,34,0,28,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,6,0,1,128,0,96,0,24,0,192,3,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,224,8,16,17,136,17,136,8,16,7,224,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,12,96,16,16,3,128,4,64,0,0,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,0,0,4,64,3,128,16,16,12,96,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,56,0,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,4,0,2,0,4,0,8,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,16,0,8,0,4,0,8,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,18,0,18,0,18,0,12,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,0,0,6,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,10,0,4,0,10,0,17,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,16,7,8,0,4,0,8,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,8,0,4,0,8,0,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,128,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,28,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,4,0,2,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,97,182,111,182,99,134,111,246,111,246,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,97,134,111,190,99,134,111,246,111,134,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,142,123,182,113,142,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,16,16,32,8,35,136,20,80,8,32,20,80,34,136,33,8,34,136,20,80,8,32,20,80,35,136,32,8,16,16 },
  { 0,0,0,0,0,0,1,0,2,128,2,128,4,64,26,176,33,8,26,176,4,64,2,128,2,128,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,17,16,34,32,34,32,34,32,17,16,8,136,8,136,8,136,17,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,112,0,8,0,4,0,4,0,4,0,4,0,4,0,8,0,112,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,240,2,0,4,0,4,0,31,240,4,0,4,0,2,0,1,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,192,4,0,4,0,5,128,6,64,8,64,16,128,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,96,4,144,8,128,8,64,8,32,4,32,3,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,32,8,16,17,8,17,8,16,136,9,144,6,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,32,8,16,17,8,63,252,16,136,9,144,6,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,0,1,248,0,16,0,32,0,64,0,64,0,128,0,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,2,64,2,32,28,32,2,32,1,64,0,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,48,15,200,16,192,3,32,4,16,9,200,30,56,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,220,2,32,4,80,8,144,8,96,4,0,2,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,63,192,1,0,1,0,2,136,4,112,8,0,4,0,2,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,128,0,64,0,32,1,144,2,96,1,0,0,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,0,4,0,2,224,3,16,2,224,4,0,4,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,128,17,32,15,192,2,0,15,192,18,32,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,2,64,4,32,8,32,9,16,17,16,16,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,240,0,32,0,32,0,16,0,16,0,8,7,136,8,112,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,12,16,19,224,16,0,8,0,31,240,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,240,4,32,8,32,16,16,16,16,8,8,15,8,16,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,240,2,0,4,0,4,8,31,240,4,32,4,16,6,16,9,224,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,32,10,80,18,80,17,48,17,16,8,160,4,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,0,4,128,8,64,8,32,8,32,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,64,5,160,8,144,8,16,8,16,4,32,2,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,240,0,192,1,0,2,0,7,192,10,32,17,32,0,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,240,0,128,0,64,0,64,3,240,4,64,4,128,3,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,248,4,16,8,32,8,32,8,32,8,16,4,16,3,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,0,16,16,16,40,17,40,16,144,8,236,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,64,8,128,8,184,11,192,60,128,8,128,4,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,192,3,0,4,0,4,192,3,0,4,32,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,8,24,7,224,4,0,2,0,1,0,1,0,2,0,2,0,4,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,64,10,32,18,16,17,16,17,16,8,160,4,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,48,24,72,4,64,15,224,4,64,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,32,4,64,2,128,1,0,2,128,4,64,8,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,0,4,128,8,64,15,224,8,32,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,0,16,0,17,80,17,80,16,160,8,128,7,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,0,8,0,9,64,9,64,10,128,4,32,3,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,6,236,9,16,18,168,18,168,17,16,8,0,4,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,192,20,32,2,32,1,64,3,128,4,80,4,32,3,208,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,16,0,8,0,8,0,5,0,5,0,5,0,6,0,4,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,2,0,1,0,1,0,1,0,1,0,1,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,2,0,2,0,2,0,2,0,1,0,0,0,0,0,0,0,0 },
  { 0,0,32,0,80,0,136,0,64,0,64,0,32,0,32,0,32,0,32,0,160,0,64,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,64,0,128,0,128,0,128,0,128,0,128,0,64,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,252,32,0,64,0,128,0,128,0,128,0,128,0,128,0,64,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,4,0,2,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,18,0,12 },
  { 0,0,0,24,0,36,0,2,0,2,0,5,0,9,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,18,0,12 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,0,1,192,2,32 },
  { 1,0,2,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 2,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 3,192,4,32,9,32,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,0,2,128,2,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,128,36,64,34,64,17,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,0,32,0,80,0,144,0,144,0,80,0,32,0,64,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,64,0,128,0,128,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,0,2,196,4,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,206,125,182,113,206,125,182,99,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,206,125,182,113,198,125,246,99,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,134,125,182,113,134,125,182,99,182,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,64,2,64,2,64,2,64,2,64,2,64,2,64,2,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,32,1,64,0,128,1,64,2,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,32,1,64,4,144,1,64,2,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,136,9,16,9,16,4,160,4,32,4,160,9,16,9,16,16,136,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,128,4,64,4,64,2,128,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,0,2,128,2,192,1,64,0,64,0,128,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,8,32,0,192,3,0,4,0,3,0,0,192,0,48,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,8,32,0,64,1,224,2,16,0,32,1,192,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,32,5,192,4,0,8,0,8,48,7,192,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,16,4,32,4,96,4,160,5,32,6,32,8,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,64,0,160,1,16,0,128,0,64,16,32,12,32,3,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,64,2,32,1,32,1,32,0,160,0,192,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,2,64,2,0,4,0,4,0,3,128,0,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,2,64,2,128,2,96,2,0,2,0,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,109,134,109,182,97,134,125,182,125,182,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,109,142,109,182,97,142,125,182,125,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,109,198,109,190,97,190,125,190,125,198,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,16,192,15,64,0,64,0,64,1,240,0,64,0,64,0,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,192,15,64,0,64,1,240,0,64,1,240,0,64,0,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,128,29,56,35,200,1,8,1,8,1,8,0,136,7,200,8,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,56,68,68,68,68,68,68,68,68,68,56,0,0 },
  { 0,0,0,98,82,74,70,64,64,64,64,32,16,14,0,0 },
  { 0,0,0,24,36,36,20,8,16,32,66,66,36,24,0,0 },
  { 0,0,0,50,74,74,62,16,32,32,64,64,48,12,0,0 },
  { 0,0,0,30,32,64,64,64,96,82,78,66,36,24,0,0 },
  { 0,0,0,16,32,70,72,80,80,72,70,66,36,24,0,0 },
  { 0,0,0,92,34,82,76,64,64,64,64,32,16,12,0,0 },
  { 0,0,0,12,82,50,4,8,16,32,66,66,36,24,0,0 },
  { 0,0,0,52,74,90,100,64,64,64,64,66,36,24,0,0 },
  { 0,0,0,28,32,64,64,64,76,82,82,74,36,24,0,0 },
  { 0,0,0,28,34,102,10,18,34,66,66,66,34,28,0,0 },
  { 0,0,0,60,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,28,34,64,64,78,80,80,78,66,36,24,0,0 },
  { 0,0,0,28,34,68,72,16,38,16,72,68,34,28,0,0 },
  { 0,0,0,72,84,98,66,66,66,66,98,84,72,64,0,0 },
  { 0,0,0,36,90,218,18,50,82,82,146,162,164,72,0,0 },
  { 0,0,0,64,72,84,98,66,66,66,66,34,20,8,0,0 },
  { 0,0,0,72,68,66,66,66,66,66,66,98,84,72,0,0 },
  { 0,0,0,18,34,66,66,66,66,66,66,70,42,18,0,0 },
  { 0,0,0,100,146,138,10,10,18,226,130,66,36,24,0,0 },
  { 0,0,0,56,68,6,10,10,18,18,34,34,66,66,0,0 },
  { 0,0,0,66,66,68,68,72,72,80,80,96,34,28,0,0 },
  { 0,0,0,68,68,130,130,130,130,130,130,146,170,68,0,0 },
  { 0,0,0,16,40,68,66,66,66,66,70,42,18,2,0,0 },
  { 0,0,0,120,4,2,66,34,18,10,6,34,82,140,0,0 },
  { 0,0,0,64,72,84,98,66,2,2,66,34,20,8,0,0 },
  { 0,0,0,56,68,68,68,68,68,68,68,186,130,124,0,0 },
  { 0,0,0,16,40,68,130,146,84,16,112,64,68,56,0,0 },
  { 0,0,0,68,170,146,130,130,130,130,130,130,68,68,0,0 },
  { 0,0,0,48,72,132,132,140,144,160,160,162,146,76,0,0 },
  { 0,0,0,56,68,4,8,8,16,16,32,32,66,60,0,0 },
  { 0,0,0,60,98,164,164,36,36,36,37,37,70,60,0,0 },
  { 0,0,0,88,148,146,146,146,146,146,146,146,82,52,0,0 },
  { 0,0,0,60,198,68,68,72,72,80,80,96,34,28,0,0 },
  { 0,0,0,56,68,6,10,10,18,18,34,34,195,126,0,0 },
  { 0,0,0,24,36,66,14,18,18,18,14,66,36,24,0,0 },
  { 0,0,0,72,84,98,66,66,66,66,66,66,68,72,0,0 },
  { 0,0,0,52,82,146,146,146,146,146,146,146,148,88,0,0 },
  { 0,0,0,98,146,136,8,10,18,226,130,66,36,24,0,0 },
  { 0,0,0,24,36,34,18,78,130,130,130,146,170,68,0,0 },
  { 0,0,0,0,24,24,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,24,24,0,0,0 },
  { 0,0,0,0,24,24,0,0,0,0,0,24,24,0,0,0 },
  { 0,0,0,0,0,0,96,146,12,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,56,0,0,0,0,0,0,0,0 },
  { 0,0,0,48,72,68,36,28,4,4,4,68,40,16,0,0 },
  { 0,0,0,0,0,16,16,16,16,16,16,16,0,0,0,0 },
  { 0,0,0,0,0,36,36,36,36,36,36,36,0,0,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,206,109,182,115,182,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,238,109,206,115,238,109,238,115,198,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,134,109,246,115,134,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,142,109,246,115,198,109,246,115,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,182,109,182,115,134,109,246,115,246,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,134,109,190,115,134,109,246,115,134,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,206,109,190,115,142,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,134,109,246,115,238,109,222,115,222,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,206,109,182,115,206,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,206,109,182,115,198,109,246,115,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,134,109,182,115,134,109,182,115,182,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,142,109,182,115,142,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,198,109,190,115,190,109,190,115,198,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,142,109,182,115,182,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,134,109,190,115,142,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,134,109,190,115,142,109,190,115,190,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,206,109,182,113,182,125,182,115,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,238,109,206,113,238,125,238,115,198,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,134,109,246,113,134,125,190,115,134,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,142,109,246,113,198,125,246,115,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,182,109,182,113,134,125,246,115,246,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,134,109,190,113,134,125,246,115,134,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,206,109,190,113,142,125,182,115,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,134,109,246,113,238,125,222,115,222,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,206,109,182,113,206,125,182,115,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,206,109,182,113,198,125,246,115,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,134,109,182,113,134,125,182,115,182,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,142,109,182,113,142,125,182,115,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,198,109,190,113,190,125,190,115,198,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,142,109,182,113,182,125,182,115,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,134,109,190,113,142,125,190,115,134,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,115,134,109,190,113,142,125,190,115,190,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,206,109,182,97,182,109,182,109,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,238,109,206,97,238,109,238,109,198,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,134,109,246,97,134,109,190,109,134,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,142,109,246,97,198,109,246,109,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,182,109,182,97,134,109,246,109,246,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,134,109,190,97,134,109,246,109,134,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,206,109,190,97,142,109,182,109,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,134,109,246,97,238,109,222,109,222,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,206,109,182,97,206,109,182,109,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,206,109,182,97,198,109,246,109,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,134,109,182,97,134,109,182,109,182,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,142,109,182,97,142,109,182,109,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,198,109,190,97,190,109,190,109,198,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,142,109,182,97,182,109,182,109,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,134,109,190,97,142,109,190,109,134,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,134,109,190,97,142,109,190,109,190,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,206,109,182,99,182,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,238,109,206,99,238,109,238,99,198,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,134,109,246,99,134,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,142,109,246,99,198,109,246,99,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,182,109,182,99,134,109,246,99,246,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,134,109,190,99,134,109,246,99,134,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,206,109,190,99,142,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,134,109,246,99,238,109,222,99,222,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,206,109,182,99,206,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,206,109,182,99,198,109,246,99,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,134,109,182,99,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,142,109,182,99,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,198,109,190,99,190,109,190,99,198,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,142,109,182,99,182,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,134,109,190,99,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,99,134,109,190,99,142,109,190,99,190,127,254,0,0 },
  { 0,0,0,0,0,0,2,128,1,0,3,128,4,64,41,40,26,176,41,40,4,64,3,128,1,0,2,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,192,2,32,5,80,4,144,5,80,2,32,1,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,192,2,32,5,208,4,16,5,208,2,32,1,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,192,2,32,4,16,4,16,4,16,2,32,1,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,27,187,32,8,33,203,68,16,74,214,137,32,253,172,0,32,0,224,1,52,0,200 },
  { 0,0,0,0,0,0,0,0,0,0,31,56,1,0,1,112,2,0,2,224,4,0,5,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,191,4,0,4,62,8,0,8,62,17,0,18,156,34,64,63,40,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,249,125,2,4,228,9,9,8,146,147,34,80,191,103,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,113,206,111,182,111,206,111,182,113,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,113,206,111,182,111,198,111,246,113,206,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,113,134,111,182,111,134,111,182,113,182,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,113,142,111,182,111,142,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,113,198,111,190,111,190,111,190,113,198,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,113,142,111,182,111,182,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,113,134,111,190,111,142,111,190,113,134,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,113,134,111,190,111,142,111,190,113,190,127,254,0,0 },
  { 0,128,1,64,2,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,128,1,192,2,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,3,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,32,2,64,4,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,144,4,144,3,96 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,7,224 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,4,0,3,224 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,32,2,32,1,192 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,1,64,2,32 },
  { 1,64,1,64,1,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 2,160,2,160,2,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,128,0,128 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,32,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,144,0,0 },
  { 0,124,0,128,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,12,0,18,0,17,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,240 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,2,64,0,0,7,224,0,0,2,64,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,32,0,16,0,8,0,8,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,4,0,8,0,16,0,16,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,16,0,16,0,8,0,4,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,0,8,0,8,0,16,0,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,24,0,36,0,32,0,16,0,8,0,8,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,16,0,16,0,8,0,4,0,36,0,24,0,0,0 },
  { 0,0,0,0,0,0,0,0,12,96,18,144,44,104,32,8,32,8,32,8,16,16,8,32,7,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,4,64,10,160,10,160,4,64,8,32,16,16,16,16,16,16,8,32,7,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,4,96,10,144,10,112,4,16,8,16,16,16,16,16,16,16,8,32,7,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,4,0,10,32,10,80,4,80,8,48,16,24,16,20,16,36,8,72,7,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,128,0,64,0,32 },
  { 0,0,0,0,0,0,7,128,8,0,8,0,8,0,7,32,4,0,4,0,4,64,3,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,128,8,64,9,0,4,0,3,192,4,0,5,0,4,128,3,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,128,2,64,2,0,1,16,1,128,2,64,4,32,4,32,4,32,2,64,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,0,4,0,8,64,8,0,7,224,0,16,2,16,0,32,0,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,6,0,0,0,6,0,9,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,5,0,5,0,8,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,128,8,128,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,32,2,32,1,64,1,64,0,128,1,64,1,64,2,32,2,32,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,18,64,18,64,13,128,0,0,0,0,13,128,18,64,18,64,0,0,0,0,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,3,0,4,128,4,128,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,24,48,36,72,36,72,24,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,123,198,115,190,123,190,123,190,113,198,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,0,0,0,0,16,40,68,68,124,68,68,68,0,0 },
  { 0,0,0,0,0,0,30,40,72,126,72,72,72,78,0,0 },
  { 0,0,0,0,0,0,124,146,18,18,252,144,146,124,0,0 },
  { 0,0,0,0,0,0,120,68,72,254,72,68,68,120,0,0 },
  { 0,0,0,0,0,0,60,66,64,64,64,64,66,60,0,0 },
  { 0,0,0,0,0,0,120,68,68,68,68,68,68,120,0,0 },
  { 0,0,0,0,0,0,120,68,68,228,68,68,68,120,0,0 },
  { 0,0,0,0,0,0,124,64,64,120,64,64,64,124,0,0 },
  { 0,0,0,0,0,0,60,66,2,28,2,66,66,60,0,0 },
  { 0,0,0,0,0,124,16,16,16,16,16,16,24,0,16,16 },
  { 0,0,0,0,0,0,124,16,16,16,16,16,16,96,0,0 },
  { 0,0,0,0,0,0,34,36,40,48,48,40,36,34,0,0 },
  { 0,0,0,0,0,0,32,32,40,48,32,96,32,62,0,0 },
  { 0,0,0,0,0,0,34,34,54,54,42,42,34,34,0,0 },
  { 0,0,0,0,0,0,68,76,76,84,84,100,100,68,0,0 },
  { 0,0,0,0,0,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,60,66,2,2,2,2,66,60,0,0,0 },
  { 0,0,0,0,0,0,0,0,62,65,65,65,65,62,0,0 },
  { 0,0,0,0,0,0,0,0,62,65,65,65,65,34,0,0 },
  { 0,0,0,0,0,0,0,32,62,81,73,73,69,62,2,0 },
  { 0,0,0,0,0,0,54,73,9,9,121,73,73,54,0,0 },
  { 0,0,0,0,0,0,68,68,68,56,68,68,68,56,0,0 },
  { 0,0,0,0,0,0,28,34,34,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,68,68,56,0,0 },
  { 0,0,0,0,0,0,124,66,66,124,64,64,64,64,0,0 },
  { 0,0,0,0,0,0,62,66,66,62,18,34,66,66,0,0 },
  { 0,0,0,0,0,0,66,66,34,18,62,66,66,62,0,0 },
  { 0,0,0,0,0,0,127,8,8,8,8,8,8,8,0,0 },
  { 0,0,0,0,0,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,0,63,2,1,1,1,1,62,0,0 },
  { 0,0,0,0,0,0,0,31,66,1,1,1,65,30,0,0 },
  { 0,0,0,0,0,0,127,1,1,1,126,1,1,126,0,0 },
  { 0,0,0,0,0,0,65,65,34,34,20,20,8,8,0,0 },
  { 0,0,0,0,0,0,66,66,90,90,102,102,66,66,0,0 },
  { 0,0,0,0,0,0,126,2,4,8,16,32,64,126,0,0 },
  { 0,0,0,0,0,0,126,4,8,28,2,2,66,60,0,0 },
  { 0,0,0,0,60,66,2,4,24,24,32,64,66,60,0,0 },
  { 0,0,0,0,0,56,124,254,254,124,56,16,146,108,0,0 },
  { 0,0,0,0,0,0,126,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,0,0,0,8,8,20,20,34,34,65,65,0,0 },
  { 0,0,0,0,0,0,127,34,34,34,34,34,34,34,0,0 },
  { 0,0,0,0,0,0,124,66,66,124,64,64,64,64,0,0 },
  { 0,0,0,0,0,0,73,73,73,73,62,8,8,8,0,0 },
  { 0,0,0,0,0,0,30,18,18,18,18,18,34,98,0,0 },
  { 0,0,16,40,68,68,124,68,68,68,0,0,0,0,0,0 },
  { 0,0,30,40,72,126,72,72,72,78,0,0,0,0,0,0 },
  { 0,0,120,68,68,120,68,68,68,120,0,0,0,0,0,0 },
  { 0,120,68,72,254,72,68,68,120,0,0,0,0,0,0,0 },
  { 0,0,120,68,68,68,68,68,68,120,0,0,0,0,0,0 },
  { 0,0,124,64,64,120,64,64,64,124,0,0,0,0,0,0 },
  { 0,0,124,4,4,60,4,4,4,124,0,0,0,0,0,0 },
  { 0,0,60,66,64,64,78,66,70,58,0,0,0,0,0,0 },
  { 0,0,66,66,66,126,66,66,66,66,0,0,0,0,0,0 },
  { 0,0,124,16,16,16,16,16,16,124,0,0,0,0,0,0 },
  { 0,0,124,16,16,16,16,16,16,96,0,0,0,0,0,0 },
  { 0,0,34,36,40,48,48,40,36,34,0,0,0,0,0,0 },
  { 0,0,32,32,32,32,32,32,32,62,0,0,0,0,0,0 },
  { 0,0,34,34,54,54,42,42,34,34,0,0,0,0,0,0 },
  { 0,0,68,100,100,84,84,76,76,68,0,0,0,0,0,0 },
  { 0,0,68,76,76,84,84,100,100,68,0,0,0,0,0,0 },
  { 0,0,60,66,66,66,66,66,66,60,0,0,0,0,0,0 },
  { 0,0,68,68,68,56,68,68,68,56,0,0,0,0,0,0 },
  { 0,0,124,66,66,124,64,64,64,64,0,0,0,0,0,0 },
  { 0,0,124,66,66,124,72,68,66,66,0,0,0,0,0,0 },
  { 0,0,127,8,8,8,8,8,8,8,0,0,0,0,0,0 },
  { 0,0,66,66,66,66,66,66,66,60,0,0,0,0,0,0 },
  { 0,0,66,66,90,90,102,102,66,66,0,0,0,0,0,0 },
  { 0,0,60,66,2,62,66,66,70,58,0,0,0,0,0,0 },
  { 0,0,92,98,66,66,124,64,66,60,0,0,0,0,0,0 },
  { 0,0,50,74,68,68,68,68,74,50,0,0,0,0,0,0 },
  { 0,0,124,146,18,18,252,144,146,124,0,0,0,0,0,0 },
  { 0,0,64,64,64,120,68,68,68,120,0,0,0,0,0,0 },
  { 0,0,4,4,4,60,68,68,68,60,0,0,0,0,0,0 },
  { 0,0,60,66,66,126,64,64,66,60,0,0,0,0,0,0 },
  { 0,0,60,66,2,2,126,66,66,60,0,0,0,0,0,0 },
  { 0,0,60,66,66,64,56,64,66,60,0,0,0,0,0,0 },
  { 0,0,60,66,2,28,2,66,66,60,0,0,0,0,0,0 },
  { 0,2,58,68,68,68,56,32,60,66,66,60,0,0,0,0 },
  { 0,0,124,16,16,16,16,16,24,0,16,0,0,0,0,0 },
  { 0,0,64,64,64,72,80,96,80,72,0,0,0,0,0,0 },
  { 0,0,118,73,73,73,73,73,73,73,0,0,0,0,0,0 },
  { 0,0,92,98,66,66,66,66,66,66,10,4,0,0,0,0 },
  { 0,0,60,66,66,66,66,66,66,60,0,0,0,0,0,0 },
  { 0,0,60,66,2,2,2,2,66,60,0,0,0,0,0,0 },
  { 0,0,28,34,34,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,34,34,28,0,0,0,0,0,0,0,0,0 },
  { 0,0,92,98,66,66,66,66,98,92,64,64,0,0,0,0 },
  { 0,0,16,16,124,16,16,16,16,12,0,0,0,0,0,0 },
  { 0,0,66,66,66,66,66,66,70,58,0,0,0,0,0,0 },
  { 0,0,0,0,126,4,2,2,2,124,0,0,0,0,0,0 },
  { 0,0,73,73,73,73,73,73,73,55,0,0,0,0,0,0 },
  { 0,0,66,66,66,36,36,36,24,24,0,0,0,0,0,0 },
  { 0,56,124,254,254,124,56,16,146,108,0,0,0,0,0,0 },
  { 0,0,56,68,68,124,66,66,98,92,64,0,0,0,0,0 },
  { 0,0,49,73,10,4,8,8,16,16,0,0,0,0,0,0 },
  { 0,0,28,32,32,24,36,66,66,60,0,0,0,0,0,0 },
  { 0,0,38,73,73,73,73,73,73,62,8,8,0,0,0,0 },
  { 0,0,98,18,20,24,16,48,72,70,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,16,0,48,16,16,16,16,16,124 },
  { 0,0,0,0,0,0,0,0,0,92,98,66,64,64,64,64 },
  { 0,0,0,0,0,0,0,0,0,66,66,66,66,66,70,58 },
  { 0,0,0,0,0,0,0,0,0,66,66,66,36,36,24,24 },
  { 0,0,0,0,0,0,0,56,68,68,124,66,66,98,92,64 },
  { 0,0,0,0,0,0,0,0,0,0,49,73,6,8,16,16 },
  { 0,0,0,0,0,0,0,0,0,56,68,68,120,64,56,4 },
  { 0,0,0,0,0,0,0,0,38,73,73,73,73,62,8,8 },
  { 0,0,0,0,0,0,0,0,98,18,20,24,16,48,72,70 },
  { 0,0,0,0,0,0,142,137,137,143,136,136,153,110,0,0 },
  { 0,0,0,40,112,160,44,50,34,34,34,34,50,44,0,0 },
  { 0,0,0,5,14,20,4,52,76,68,68,68,76,52,0,0 },
  { 0,0,0,12,16,16,16,124,16,16,20,56,80,16,0,0 },
  { 0,0,0,0,0,0,124,74,74,74,123,206,74,74,0,0 },
  { 0,0,0,0,0,0,44,50,34,34,51,110,34,34,0,0 },
  { 0,0,0,0,0,0,44,50,34,51,110,34,50,44,32,32 },
  { 0,0,0,0,0,0,44,50,34,32,57,102,32,32,0,0 },
  { 0,0,0,0,0,0,12,18,34,32,57,102,32,32,0,0 },
  { 0,0,0,0,0,0,60,66,64,51,204,2,66,52,0,0 },
  { 0,0,0,0,16,16,124,16,16,50,92,16,16,12,0,0 },
  { 0,0,0,0,0,0,126,2,4,106,156,32,64,126,0,0 },
  { 0,0,0,0,0,60,66,66,60,32,56,68,68,68,58,2 },
  { 0,0,66,66,66,126,66,66,66,66,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,126,4,8,16,16,8,60,66,66,60 },
  { 0,0,0,0,0,8,0,144,8,160,8,192,62,184,9,196,10,132,12,132,8,132,24,132,40,132,6,132,0,0,0,0 },
  { 0,0,0,0,0,0,124,16,16,124,16,16,16,124,0,0 },
  { 0,0,0,0,0,0,112,16,16,124,16,16,16,12,0,0 },
  { 0,0,0,0,0,0,44,50,34,127,34,34,50,44,32,32 },
  { 0,0,0,0,0,0,34,34,34,127,34,34,34,28,0,0 },
  { 0,0,0,0,0,0,65,34,34,127,34,34,34,28,0,0 },
  { 0,0,0,64,64,64,92,98,66,66,66,66,99,93,1,6 },
  { 0,0,0,2,2,2,58,70,66,66,66,66,70,59,1,6 },
  { 0,0,0,12,16,16,16,124,16,16,16,16,24,24,8,48 },
  { 0,0,0,0,0,0,0,60,68,68,68,68,71,57,9,114 },
  { 0,0,0,0,64,64,68,72,80,96,80,72,70,66,2,12 },
  { 0,0,0,0,24,8,8,8,8,8,8,8,10,62,2,12 },
  { 0,0,0,0,0,0,116,74,74,74,74,74,75,75,1,6 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,67,67,1,6 },
  { 0,0,0,0,0,0,88,100,68,68,68,68,102,90,66,76 },
  { 0,0,0,0,0,0,44,50,34,32,32,32,48,48,16,96 },
  { 0,0,0,0,0,0,60,66,64,48,12,2,67,61,1,6 },
  { 0,0,0,12,16,16,16,16,16,16,16,30,18,18,98,12 },
  { 0,0,0,0,0,0,66,66,66,36,36,38,26,26,2,12 },
  { 0,0,0,0,0,0,68,68,40,16,16,40,70,70,2,12 },
  { 0,0,0,0,0,0,126,2,4,8,16,32,64,126,2,12 },
  { 0,0,0,0,0,0,56,68,4,60,68,68,78,54,2,12 },
  { 0,0,0,0,0,0,56,68,4,60,68,68,76,52,4,3 },
  { 0,0,3,4,4,4,52,76,68,68,68,68,68,60,4,4 },
  { 0,0,0,0,0,0,60,66,66,126,64,64,66,60,4,3 },
  { 0,0,0,0,0,0,60,66,64,60,64,64,66,60,4,3 },
  { 0,0,0,0,0,0,60,66,2,60,2,2,66,60,16,96 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,15,0,16,128,0,128,0,128,31,224,16,160,16,160,15,32,0,32,0,24 },
  { 0,0,0,8,8,0,24,8,8,8,8,8,8,60,4,3 },
  { 0,0,0,0,0,0,60,66,2,2,2,2,66,124,64,48 },
  { 0,0,0,12,16,16,16,16,16,16,16,16,16,96,64,48 },
  { 0,0,0,0,0,0,136,136,136,136,136,136,156,108,4,3 },
  { 0,0,0,0,0,0,126,4,8,16,28,2,2,60,32,24 },
  { 0,0,0,92,98,66,66,66,66,98,92,0,0,0,0,0 },
  { 0,0,0,56,68,64,64,64,68,56,0,0,0,0,0,0 },
  { 0,0,0,56,68,64,64,88,100,56,64,0,0,0,0,0 },
  { 50,12,20,2,30,34,34,34,34,34,28,0,0,0,0,0 },
  { 0,0,0,28,34,2,28,2,34,28,0,0,0,0,0,0 },
  { 0,0,12,16,16,124,16,16,16,16,0,0,0,0,0,0 },
  { 0,0,8,8,8,8,62,8,8,48,0,0,0,0,0,0 },
  { 0,0,56,72,72,72,72,56,8,8,112,0,0,0,0,0 },
  { 0,0,68,68,68,68,76,52,4,4,4,0,0,0,0,0 },
  { 0,0,16,0,48,16,56,16,16,124,0,0,0,0,0,0 },
  { 0,0,0,0,48,16,16,16,16,12,0,0,0,0,0,0 },
  { 0,0,124,16,16,16,16,16,124,0,0,0,0,0,0,0 },
  { 0,0,124,16,16,124,16,16,124,0,0,0,0,0,0,0 },
  { 0,0,8,0,24,8,8,8,56,76,50,0,0,0,0,0 },
  { 0,0,112,16,16,16,16,16,16,12,0,0,0,0,0,0 },
  { 0,0,16,16,16,16,16,24,24,8,48,0,0,0,0,0 },
  { 0,0,16,16,16,16,16,30,0,0,0,0,0,0,0,0 },
  { 0,0,118,73,73,73,73,73,73,73,1,6,0,0,0,0 },
  { 0,0,73,73,73,73,73,73,73,55,1,1,1,0,0,0 },
  { 0,0,22,25,17,17,17,17,17,17,16,96,0,0,0,0 },
  { 0,0,88,100,68,68,68,68,68,4,3,0,0,0,0,0 },
  { 0,0,34,50,50,42,42,38,38,34,0,0,0,0,0,0 },
  { 0,0,24,36,66,126,66,36,24,0,0,0,0,0,0,0 },
  { 0,0,16,16,56,84,84,84,56,16,16,0,0,0,0,0 },
  { 0,0,24,36,16,8,36,56,32,24,0,0,0,0,0,0 },
  { 0,0,0,12,16,16,16,16,16,16,16,96,0,0,0,0 },
  { 0,0,16,16,124,16,16,16,18,14,2,12,0,0,0,0 },
  { 0,0,34,34,34,127,34,34,38,26,0,0,0,0,0,0 },
  { 0,0,119,20,34,34,34,34,34,28,0,0,0,0,0,0 },
  { 0,0,34,34,34,34,34,34,34,28,0,0,0,0,0,0 },
  { 0,4,98,34,36,40,48,32,0,0,0,0,0,0,0,0 },
  { 0,0,8,20,20,34,34,0,0,0,0,0,0,0,0,0 },
  { 0,0,62,4,8,16,62,0,0,0,0,0,0,0,0,0 },
  { 0,0,124,8,16,36,124,4,3,0,0,0,0,0,0,0 },
  { 0,0,124,8,22,41,126,16,0,0,0,0,0,0,0,0 },
  { 0,0,126,4,8,28,2,66,60,0,0,0,0,0,0,0 },
  { 0,0,8,20,34,62,34,34,20,8,0,0,0,0,0,0 },
  { 0,36,16,8,36,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,36,8,16,36,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,112,56,28,14 },
  { 0,2,36,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,2,4,120,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,64,32,30,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,120,4,2,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,60,64,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,136,84,34,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,34,84,136,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,44,48,32,32 },
  { 0,142,112,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,112,142,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,128,6,96,8,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,48,8,8,16,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,16,32,60,4,8 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,18,57,70,0 },
  { 0,100,146,76,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,24,36,20,4,8,16,0,0,0,0,0,0,0,0,0 },
  { 0,146,108,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 236,18,124,144,110,0,0,0,0,0,0,0,0,0,0,0 },
  { 236,18,114,146,108,0,0,0,0,0,0,0,0,0,0,0 },
  { 225,17,122,154,100,0,0,0,0,0,0,0,0,0,0,0 },
  { 28,32,32,32,28,8,16,0,0,0,0,0,0,0,0,0 },
  { 48,8,28,36,24,0,0,0,0,0,0,0,0,0,0,0 },
  { 40,16,40,28,36,24,0,0,0,0,0,0,0,0,0,0 },
  { 28,36,28,4,56,0,0,0,0,0,0,0,0,0,0,0 },
  { 28,32,44,36,24,0,0,0,0,0,0,0,0,0,0,0 },
  { 32,36,40,52,36,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,8,8,8,28,0,0,0,0,0,0,0,0,0,0,0 },
  { 32,32,32,32,60,0,0,0,0,0,0,0,0,0,0,0 },
  { 68,108,84,68,68,0,0,0,0,0,0,0,0,0,0,0 },
  { 88,100,68,68,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 68,100,84,76,68,0,0,0,0,0,0,0,0,0,0,0 },
  { 56,36,56,40,36,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,36,4,8,4,2,0,0,0,0,0,0,0,0,0,0 },
  { 28,32,24,4,56,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,36,32,96,32,32,0,0,0,0,0,0,0,0,0,0 },
  { 60,4,24,32,60,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,28,36,36,28,0,0,0,0,0,0,0,0,0,0,0 },
  { 16,28,18,28,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,36,40,36,56,0,0,0,0,0,0,0,0,0,0,0 },
  { 56,4,60,36,24,0,0,0,0,0,0,0,0,0,0,0 },
  { 12,16,56,16,16,0,0,0,0,0,0,0,0,0,0,0 },
  { 16,56,16,56,16,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,24,36,36,88,128,0,0,0,0,0,0,0,0,0,0 },
  { 56,36,56,32,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 12,16,16,16,96,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,36,36,92,128,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,146,84,40,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 20,0,28,36,28,0,0,0,0,0,0,0,0,0,0,0 },
  { 40,0,24,36,24,0,0,0,0,0,0,0,0,0,0,0 },
  { 40,0,40,40,56,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,16,16,124,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,142,115,182,123,182,123,182,113,142,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,182,123,182,113,142,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,182,123,182,113,142,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,182,123,182,113,142,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,182,123,182,113,142,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,123,142,115,182,123,182,123,182,113,142,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,224,6,24,8,4 },
  { 0,0,0,0,0,0,0,0,0,0,0,50,76,0,50,76 },
  { 8,16,32,16,8,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,74,36,64 },
  { 0,0,0,0,24,36,36,66,66,126,66,66,66,24,36,24 },
  { 0,0,0,0,0,0,60,66,2,62,66,70,58,24,36,24 },
  { 0,16,0,0,124,66,66,66,124,66,66,66,66,124,0,0 },
  { 0,0,0,72,64,64,92,98,66,66,66,66,98,92,0,0 },
  { 0,0,0,0,124,66,66,66,124,66,66,66,66,124,0,16 },
  { 0,0,0,64,64,64,92,98,66,66,66,66,98,92,0,8 },
  { 0,0,0,0,124,66,66,66,124,66,66,66,66,124,0,60 },
  { 0,0,0,64,64,64,92,98,66,66,66,66,98,92,0,60 },
  { 8,16,32,0,60,66,66,64,64,64,64,66,66,60,8,48 },
  { 0,0,8,16,32,0,60,66,64,64,64,64,66,60,8,48 },
  { 0,16,0,0,120,68,66,66,66,66,66,66,68,120,0,0 },
  { 0,0,0,18,2,2,58,70,66,66,66,66,70,58,0,0 },
  { 0,0,0,0,120,68,66,66,66,66,66,66,68,120,0,16 },
  { 0,0,0,2,2,2,58,70,66,66,66,66,70,58,0,16 },
  { 0,0,0,0,120,68,66,66,66,66,66,66,68,120,0,60 },
  { 0,0,0,2,2,2,58,70,66,66,66,66,70,58,0,60 },
  { 0,0,0,0,120,68,66,66,66,66,66,66,68,120,16,32 },
  { 0,0,0,2,2,2,58,70,66,66,66,66,70,58,8,16 },
  { 0,0,0,0,120,68,66,66,66,66,66,66,68,120,48,72 },
  { 0,0,0,2,2,2,58,70,66,66,66,66,70,58,24,36 },
  { 16,8,60,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 32,16,8,0,60,0,60,66,66,126,64,64,66,60,0,0 },
  { 8,16,60,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 8,16,32,0,60,0,60,66,66,126,64,64,66,60,0,0 },
  { 0,0,0,0,126,64,64,64,124,64,64,64,64,126,24,36 },
  { 0,0,0,0,0,0,60,66,66,126,64,64,66,60,24,36 },
  { 0,0,0,0,126,64,64,64,124,64,64,64,64,126,50,76 },
  { 0,0,0,0,0,0,60,66,66,126,64,64,66,60,50,76 },
  { 0,34,28,0,126,64,64,64,124,64,64,64,64,126,4,24 },
  { 0,0,34,28,0,0,60,66,66,126,64,64,66,60,8,48 },
  { 0,16,0,0,126,64,64,64,124,64,64,64,64,64,0,0 },
  { 8,0,0,12,16,16,16,124,16,16,16,16,16,16,0,0 },
  { 0,0,60,0,60,66,66,64,64,78,66,66,70,58,0,0 },
  { 0,0,0,0,120,2,58,68,68,68,56,32,60,66,66,60 },
  { 0,0,16,0,68,68,68,68,124,68,68,68,68,68,0,0 },
  { 0,0,0,72,64,64,92,98,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,68,68,68,68,124,68,68,68,68,68,0,16 },
  { 0,0,0,64,64,64,92,98,66,66,66,66,66,66,0,8 },
  { 0,36,0,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 36,0,0,64,64,64,92,98,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,66,66,66,66,126,66,66,66,98,98,16,96 },
  { 0,0,0,64,64,64,92,98,66,66,66,66,98,98,16,96 },
  { 0,0,0,0,130,130,130,130,254,130,130,130,130,130,40,56 },
  { 0,0,0,64,64,64,78,81,97,65,65,65,65,65,20,28 },
  { 0,0,0,0,62,8,8,8,8,8,8,8,8,62,50,76 },
  { 0,0,0,8,8,0,24,8,8,8,8,8,8,62,50,76 },
  { 4,8,42,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,2,4,8,34,0,24,8,8,8,8,8,8,62,0,0 },
  { 0,4,8,16,66,68,72,80,96,96,80,72,68,66,0,0 },
  { 0,2,4,72,64,64,68,72,80,96,80,72,68,66,0,0 },
  { 0,0,0,0,66,68,72,80,96,96,80,72,68,66,0,16 },
  { 0,0,0,64,64,64,68,72,80,96,80,72,68,66,0,16 },
  { 0,0,0,0,66,68,72,80,96,96,80,72,68,66,0,60 },
  { 0,0,0,64,64,64,68,72,80,96,80,72,68,66,0,60 },
  { 0,0,0,0,64,64,64,64,64,64,64,64,64,126,0,16 },
  { 0,0,0,24,8,8,8,8,8,8,8,8,8,62,0,8 },
  { 0,0,60,0,64,64,64,64,64,64,64,64,64,126,0,16 },
  { 0,60,0,24,8,8,8,8,8,8,8,8,8,62,0,8 },
  { 0,0,0,0,64,64,64,64,64,64,64,64,64,126,0,60 },
  { 0,0,0,24,8,8,8,8,8,8,8,8,8,62,0,28 },
  { 0,0,0,0,64,64,64,64,64,64,64,64,64,126,24,36 },
  { 0,0,0,24,8,8,8,8,8,8,8,8,8,62,24,36 },
  { 0,4,8,16,66,66,102,102,90,90,66,66,66,66,0,0 },
  { 0,0,4,8,16,0,118,73,73,73,73,73,73,73,0,0 },
  { 0,0,16,0,66,66,102,102,90,90,66,66,66,66,0,0 },
  { 0,0,0,8,0,0,118,73,73,73,73,73,73,73,0,0 },
  { 0,0,0,0,66,66,102,102,90,90,66,66,66,66,0,8 },
  { 0,0,0,0,0,0,118,73,73,73,73,73,73,73,0,8 },
  { 0,0,8,0,66,98,98,82,82,74,74,70,70,66,0,0 },
  { 0,0,0,8,0,0,92,98,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,66,98,98,82,82,74,74,70,70,66,0,8 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,66,66,0,8 },
  { 0,0,0,0,66,98,98,82,82,74,74,70,70,66,0,60 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,66,66,0,60 },
  { 0,0,0,0,66,98,98,82,82,74,74,70,70,66,24,36 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,66,66,24,36 },
  { 4,8,50,76,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 2,4,8,50,76,0,60,66,66,66,66,66,66,60,0,0 },
  { 36,0,50,76,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,36,0,50,76,0,60,66,66,66,66,66,66,60,0,0 },
  { 16,8,60,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 32,16,8,0,60,0,60,66,66,66,66,66,66,60,0,0 },
  { 8,16,60,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 8,16,32,0,60,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,4,8,16,124,66,66,66,124,64,64,64,64,64,0,0 },
  { 0,0,4,8,16,0,92,98,66,66,66,66,98,92,64,64 },
  { 0,16,0,0,124,66,66,66,124,64,64,64,64,64,0,0 },
  { 0,0,0,8,0,0,92,98,66,66,66,66,98,92,64,64 },
  { 0,16,0,0,124,66,66,66,124,72,68,68,66,66,0,0 },
  { 0,0,0,16,0,0,92,98,66,64,64,64,64,64,0,0 },
  { 0,0,0,0,124,66,66,66,124,72,68,68,66,66,0,8 },
  { 0,0,0,0,0,0,92,98,66,64,64,64,64,64,8,0 },
  { 0,0,60,0,124,66,66,66,124,72,68,68,66,66,0,8 },
  { 0,0,0,0,60,0,92,98,66,64,64,64,64,64,8,0 },
  { 0,0,0,0,124,66,66,66,124,72,68,68,66,66,0,60 },
  { 0,0,0,0,0,0,92,98,66,64,64,64,64,64,0,60 },
  { 0,16,0,0,60,66,66,64,48,12,2,66,66,60,0,0 },
  { 0,0,0,16,0,0,60,66,64,48,12,2,66,60,0,0 },
  { 0,0,0,0,60,66,66,64,48,12,2,66,66,60,0,8 },
  { 0,0,0,0,0,0,60,66,64,48,12,2,66,60,0,8 },
  { 36,8,16,0,60,66,66,64,48,12,2,66,66,60,0,0 },
  { 0,32,8,16,32,0,60,66,64,48,12,2,66,60,0,0 },
  { 8,34,20,8,60,66,66,64,48,12,2,66,66,60,0,0 },
  { 0,8,0,34,20,8,60,66,64,48,12,2,66,60,0,0 },
  { 0,8,0,0,60,66,66,64,48,12,2,66,66,60,0,8 },
  { 0,0,0,8,0,0,60,66,64,48,12,2,66,60,0,8 },
  { 0,8,0,0,127,8,8,8,8,8,8,8,8,8,0,0 },
  { 0,16,0,0,16,16,16,124,16,16,16,16,16,12,0,0 },
  { 0,0,0,0,127,8,8,8,8,8,8,8,8,8,0,8 },
  { 0,0,0,0,16,16,16,124,16,16,16,16,16,12,0,16 },
  { 0,0,0,0,127,8,8,8,8,8,8,8,8,8,0,62 },
  { 0,0,0,0,16,16,16,124,16,16,16,16,16,12,0,60 },
  { 0,0,0,0,127,8,8,8,8,8,8,8,0,8,20,34 },
  { 0,0,0,0,16,16,16,124,16,16,16,16,18,12,20,34 },
  { 0,0,0,0,66,66,66,66,66,66,66,66,66,60,0,36 },
  { 0,0,0,0,0,0,66,66,66,66,66,66,70,58,0,40 },
  { 0,0,0,0,66,66,66,66,66,66,66,66,66,60,50,76 },
  { 0,0,0,0,0,0,66,66,66,66,66,66,70,58,50,76 },
  { 0,0,0,0,66,66,66,66,66,66,66,66,66,60,20,34 },
  { 0,0,0,0,0,0,66,66,66,66,66,66,70,58,20,34 },
  { 4,8,50,76,0,66,66,66,66,66,66,66,66,60,0,0 },
  { 2,4,8,50,76,0,66,66,66,66,66,66,70,58,0,0 },
  { 36,0,60,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,36,0,60,0,66,66,66,66,66,66,70,58,0,0 },
  { 0,0,50,76,0,65,65,34,34,34,20,20,8,8,0,0 },
  { 0,0,50,76,0,0,66,66,66,36,36,36,24,24,0,0 },
  { 0,0,0,0,65,65,65,34,34,34,20,20,8,8,0,8 },
  { 0,0,0,0,0,0,68,68,68,40,40,40,16,16,0,16 },
  { 0,32,16,8,66,66,66,66,90,90,102,102,66,66,0,0 },
  { 0,0,16,8,4,0,65,73,73,73,73,73,73,54,0,0 },
  { 0,4,8,16,66,66,66,66,90,90,102,102,66,66,0,0 },
  { 0,0,4,8,16,0,65,73,73,73,73,73,73,54,0,0 },
  { 0,36,0,0,66,66,66,66,90,90,102,102,66,66,0,0 },
  { 0,0,0,34,0,0,65,73,73,73,73,73,73,54,0,0 },
  { 0,16,0,0,68,68,68,68,84,84,108,108,68,68,0,0 },
  { 0,0,0,8,0,0,65,73,73,73,73,73,73,54,0,0 },
  { 0,0,0,0,68,68,68,68,84,84,108,108,68,68,0,16 },
  { 0,0,0,0,0,0,65,73,73,73,73,73,73,54,0,8 },
  { 0,16,0,0,68,68,40,40,16,16,40,40,68,68,0,0 },
  { 0,0,0,16,0,0,68,68,40,16,16,40,68,68,0,0 },
  { 0,36,0,0,66,66,36,36,24,24,36,36,66,66,0,0 },
  { 0,0,0,36,0,0,66,66,36,24,24,36,66,66,0,0 },
  { 0,8,0,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,0,0,8,0,0,66,66,66,66,66,38,26,2,2,60 },
  { 8,20,34,0,126,2,2,4,8,16,32,64,64,126,0,0 },
  { 0,8,20,34,0,0,126,2,4,8,16,32,64,126,0,0 },
  { 0,0,0,0,126,2,2,4,8,16,32,64,64,126,0,8 },
  { 0,0,0,0,0,0,126,2,4,8,16,32,64,126,0,8 },
  { 0,0,0,0,126,2,2,4,8,16,32,64,64,126,0,60 },
  { 0,0,0,0,0,0,126,2,4,8,16,32,64,126,0,60 },
  { 0,0,0,64,64,64,92,98,66,66,66,66,66,66,0,60 },
  { 0,0,68,0,16,16,16,124,16,16,16,16,16,12,0,0 },
  { 0,8,20,8,0,0,65,73,73,73,73,73,73,54,0,0 },
  { 0,8,20,8,0,0,66,66,66,66,66,38,26,2,2,60 },
  { 0,2,1,1,2,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,16,0,12,16,16,16,48,16,16,16,16,16,16,0,0 },
  { 0,0,0,12,16,16,16,52,24,48,80,16,16,16,0,0 },
  { 0,0,0,12,16,124,16,48,16,16,16,16,16,16,0,0 },
  { 0,0,0,62,66,68,68,72,76,66,66,66,82,76,0,0 },
  { 0,0,0,0,28,32,32,32,24,36,66,66,66,60,0,0 },
  { 0,0,0,0,16,40,40,68,68,124,68,68,68,68,0,16 },
  { 0,0,0,0,0,0,60,66,2,62,66,66,70,58,0,16 },
  { 64,32,32,64,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,8,4,4,8,0,60,66,2,62,66,66,70,58,0,0 },
  { 2,20,40,68,16,40,40,68,68,124,68,68,68,68,0,0 },
  { 0,2,20,40,68,0,60,66,2,62,66,66,70,58,0,0 },
  { 64,40,20,34,8,20,20,34,34,62,34,34,34,34,0,0 },
  { 0,64,40,20,34,0,60,66,2,62,66,66,70,58,0,0 },
  { 4,2,20,40,84,40,40,68,68,124,68,68,68,68,0,0 },
  { 2,1,10,20,34,0,60,66,2,62,66,66,70,58,0,0 },
  { 25,38,8,20,34,8,20,20,34,34,62,34,34,34,0,0 },
  { 25,38,8,20,34,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,8,20,34,8,20,20,34,34,62,34,34,34,34,0,8 },
  { 0,0,8,20,34,0,60,66,2,62,66,66,70,58,0,8 },
  { 8,16,68,56,16,40,40,68,68,124,68,68,68,68,0,0 },
  { 4,8,16,68,56,0,60,66,2,62,66,66,70,58,0,0 },
  { 32,16,68,56,16,40,40,68,68,124,68,68,68,68,0,0 },
  { 32,16,8,34,28,0,60,66,2,62,66,66,70,58,0,0 },
  { 16,8,178,124,16,40,40,68,68,124,68,68,68,68,0,0 },
  { 8,8,16,68,56,0,60,66,2,62,66,66,70,58,0,0 },
  { 50,76,130,124,16,40,40,68,68,124,68,68,68,68,0,0 },
  { 50,76,0,66,60,0,60,66,2,62,66,66,70,58,0,0 },
  { 0,0,68,56,16,40,40,68,68,124,68,68,68,68,0,16 },
  { 0,0,0,36,24,0,60,66,2,62,66,66,70,58,0,16 },
  { 0,0,0,0,126,64,64,64,124,64,64,64,64,126,0,16 },
  { 0,0,0,0,0,0,60,66,66,126,64,64,66,60,0,16 },
  { 16,8,8,16,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 16,8,8,16,0,0,60,66,66,126,64,64,66,60,0,0 },
  { 0,50,76,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,0,0,50,76,0,60,66,66,126,64,64,66,60,0,0 },
  { 2,20,40,68,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,2,20,40,68,0,60,66,66,126,64,64,66,60,0,0 },
  { 64,40,20,34,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,64,40,20,34,0,60,66,66,126,64,64,66,60,0,0 },
  { 4,18,42,68,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 4,2,18,44,68,0,60,66,66,126,64,64,66,60,0,0 },
  { 50,76,16,40,68,126,64,64,124,64,64,64,64,126,0,0 },
  { 50,76,16,40,68,0,60,66,66,126,64,64,66,60,0,0 },
  { 0,8,20,34,126,64,64,64,124,64,64,64,64,126,0,8 },
  { 0,0,8,20,34,0,60,66,66,126,64,64,66,60,0,8 },
  { 8,4,4,8,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,16,8,8,16,0,24,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,62,8,8,8,8,8,8,8,8,62,0,8 },
  { 0,0,0,8,8,0,24,8,8,8,8,8,8,62,0,8 },
  { 0,0,0,0,60,66,66,66,66,66,66,66,66,60,0,8 },
  { 0,0,0,0,0,0,60,66,66,66,66,66,66,60,0,8 },
  { 16,8,8,16,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,16,8,8,16,0,60,66,66,66,66,66,66,60,0,0 },
  { 2,20,40,68,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,2,20,40,68,0,60,66,66,66,66,66,66,60,0,0 },
  { 64,40,20,34,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,64,40,20,34,0,60,66,66,66,66,66,66,60,0,0 },
  { 4,18,42,68,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 4,2,18,44,68,0,60,66,66,66,66,66,66,60,0,0 },
  { 50,76,16,40,68,60,66,66,66,66,66,66,66,60,0,0 },
  { 50,76,16,40,68,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,16,40,68,60,66,66,66,66,66,66,66,66,60,0,8 },
  { 0,0,8,20,34,0,60,66,66,66,66,66,66,60,0,8 },
  { 8,16,34,1,57,70,68,68,68,68,68,68,68,56,0,0 },
  { 0,0,8,16,34,1,57,70,68,68,68,68,68,56,0,0 },
  { 32,16,10,1,57,70,68,68,68,68,68,68,68,56,0,0 },
  { 0,0,32,16,10,1,57,70,68,68,68,68,68,56,0,0 },
  { 16,8,10,17,57,70,68,68,68,68,68,68,68,56,0,0 },
  { 0,16,8,8,18,1,57,70,68,68,68,68,68,56,0,0 },
  { 0,50,76,2,57,69,70,68,68,68,68,68,68,56,0,0 },
  { 0,50,76,0,2,1,57,70,68,68,68,68,68,56,0,0 },
  { 0,0,2,1,57,70,68,68,68,68,68,68,68,56,0,16 },
  { 0,0,0,0,2,1,57,70,68,68,68,68,68,56,0,16 },
  { 0,0,0,0,66,66,66,66,66,66,66,66,66,60,0,8 },
  { 0,0,0,0,0,0,66,66,66,66,66,66,70,58,0,8 },
  { 16,8,8,16,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,16,8,8,16,0,66,66,66,66,66,66,70,58,0,0 },
  { 4,8,18,1,69,70,68,68,68,68,68,68,68,56,0,0 },
  { 0,0,4,8,18,1,69,70,68,68,68,68,76,52,0,0 },
  { 64,32,18,1,69,70,68,68,68,68,68,68,68,56,0,0 },
  { 0,0,64,32,18,1,69,70,68,68,68,68,76,52,0,0 },
  { 16,8,10,17,69,70,68,68,68,68,68,68,68,56,0,0 },
  { 0,16,8,8,18,1,69,70,68,68,68,68,76,52,0,0 },
  { 50,76,2,1,69,70,68,68,68,68,68,68,68,56,0,0 },
  { 0,50,76,0,2,1,69,70,68,68,68,68,76,52,0,0 },
  { 0,0,2,1,69,70,68,68,68,68,68,68,68,56,0,16 },
  { 0,0,0,0,2,1,69,70,68,68,68,68,76,52,0,16 },
  { 32,16,8,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,32,16,8,0,0,66,66,66,66,66,38,26,2,2,60 },
  { 0,0,0,0,65,65,34,34,20,8,8,8,8,8,0,8 },
  { 0,0,0,0,0,0,66,66,66,66,66,38,26,2,60,8 },
  { 8,4,4,8,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,16,8,8,16,0,66,66,66,66,66,38,26,2,2,60 },
  { 0,50,76,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,0,50,76,0,0,66,66,66,66,66,38,26,2,2,60 },
  { 0,0,0,240,80,80,80,80,80,80,80,80,80,254,0,0 },
  { 0,0,0,108,36,36,36,126,36,36,36,36,36,255,0,0 },
  { 0,0,0,0,4,8,16,16,32,36,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,8,16,32,32,72,68,68,56,0,0 },
  { 0,0,0,0,66,66,34,20,20,8,8,8,8,56,72,48 },
  { 0,0,0,0,0,0,66,66,34,20,20,8,8,56,72,48 },
  { 0,0,48,16,32,0,50,74,68,68,68,68,74,50,0,0 },
  { 0,0,48,32,16,0,50,74,68,68,68,68,74,50,0,0 },
  { 0,0,104,40,68,0,50,74,68,68,68,68,74,50,0,0 },
  { 0,0,104,72,36,0,50,74,68,68,68,68,74,50,0,0 },
  { 0,0,100,40,72,0,50,74,68,68,68,68,74,50,0,0 },
  { 0,0,100,72,40,0,50,74,68,68,68,68,74,50,0,0 },
  { 100,152,0,48,16,32,0,50,74,68,68,68,74,50,0,0 },
  { 100,152,0,48,32,16,0,50,74,68,68,68,74,50,0,0 },
  { 192,64,128,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 192,128,64,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 208,80,136,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 208,144,72,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 200,80,144,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 200,144,80,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 100,152,96,32,64,24,36,36,66,126,66,66,66,66,0,0 },
  { 100,152,96,64,32,24,36,36,66,126,66,66,66,66,0,0 },
  { 0,0,24,8,16,0,60,66,64,60,64,64,66,60,0,0 },
  { 0,0,24,16,8,0,60,66,64,60,64,64,66,60,0,0 },
  { 0,0,52,20,34,0,60,66,64,60,64,64,66,60,0,0 },
  { 0,0,52,36,18,0,60,66,64,60,64,64,66,60,0,0 },
  { 0,0,50,20,36,0,60,66,64,60,64,64,66,60,0,0 },
  { 0,0,50,36,20,0,60,66,64,60,64,64,66,60,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,123,206,115,190,123,142,123,182,113,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,123,134,115,246,123,238,123,222,113,222,127,254,0,0 },
  { 192,64,128,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 192,128,64,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 208,80,136,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 208,144,72,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 200,80,144,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 200,144,80,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,123,134,115,190,123,142,123,190,113,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,123,134,115,190,123,142,123,190,113,190,127,254,0,0 },
  { 0,0,24,8,16,0,92,98,66,66,66,66,66,66,2,2 },
  { 0,0,24,16,8,0,92,98,66,66,66,66,66,66,2,2 },
  { 0,0,52,20,34,0,92,98,66,66,66,66,66,66,2,2 },
  { 0,0,52,36,18,0,92,98,66,66,66,66,66,66,2,2 },
  { 0,0,50,20,36,0,92,98,66,66,66,66,66,66,2,2 },
  { 0,0,50,36,20,0,92,98,66,66,66,66,66,66,2,2 },
  { 50,76,0,24,8,16,0,92,98,66,66,66,66,66,2,2 },
  { 50,76,0,24,16,8,0,92,98,66,66,66,66,66,2,2 },
  { 192,64,128,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 192,128,64,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 208,80,136,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 208,144,72,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 200,80,144,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 200,144,80,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 100,152,96,32,64,66,66,66,126,66,66,66,66,66,0,0 },
  { 100,152,96,64,32,66,66,66,126,66,66,66,66,66,0,0 },
  { 0,0,24,8,16,0,16,16,16,16,16,16,16,12,0,0 },
  { 0,0,24,16,8,0,16,16,16,16,16,16,16,12,0,0 },
  { 0,0,104,40,68,0,16,16,16,16,16,16,16,12,0,0 },
  { 0,0,104,72,36,0,16,16,16,16,16,16,16,12,0,0 },
  { 0,0,100,40,72,0,16,16,16,16,16,16,16,12,0,0 },
  { 0,0,100,72,40,0,16,16,16,16,16,16,16,12,0,0 },
  { 50,76,0,24,8,16,0,16,16,16,16,16,16,12,0,0 },
  { 50,76,0,24,16,8,0,16,16,16,16,16,16,12,0,0 },
  { 192,64,128,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 192,128,96,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 208,80,136,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 208,144,72,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 200,80,144,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 200,144,80,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 100,152,96,32,64,62,8,8,8,8,8,8,8,62,0,0 },
  { 100,152,96,64,32,62,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,24,8,16,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,24,16,8,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,52,20,34,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,52,36,18,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,50,20,36,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,50,36,20,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,109,206,109,190,97,142,125,182,125,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,109,134,109,246,97,238,125,222,125,222,127,254,0,0 },
  { 192,64,128,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 192,128,64,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 208,80,136,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 208,144,72,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 200,80,144,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 200,144,80,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,109,134,109,190,97,142,125,190,125,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,109,134,109,190,97,142,125,190,125,190,127,254,0,0 },
  { 0,0,24,8,16,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,24,16,8,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,52,20,34,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,52,36,18,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,50,20,36,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,50,36,20,0,66,66,66,66,66,66,66,60,0,0 },
  { 50,76,0,24,8,16,66,66,66,66,66,66,66,60,0,0 },
  { 50,76,0,24,16,8,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,97,206,111,182,97,206,125,182,97,206,127,254,0,0 },
  { 192,128,64,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,97,134,111,182,97,134,125,182,97,182,127,254,0,0 },
  { 208,144,72,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,97,198,111,190,97,190,125,190,97,198,127,254,0,0 },
  { 200,144,80,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,97,134,111,190,97,142,125,190,97,134,127,254,0,0 },
  { 100,152,96,64,32,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,0,12,4,8,0,34,65,65,73,73,73,73,54,0,0 },
  { 0,0,12,8,4,0,34,65,65,73,73,73,73,54,0,0 },
  { 0,0,52,20,34,0,34,65,65,73,73,73,73,54,0,0 },
  { 0,0,52,36,18,0,34,65,65,73,73,73,73,54,0,0 },
  { 0,0,50,20,36,0,34,65,65,73,73,73,73,54,0,0 },
  { 0,0,50,36,20,0,34,65,65,73,73,73,73,54,0,0 },
  { 50,76,0,24,8,16,0,34,65,73,73,73,73,54,0,0 },
  { 50,76,0,24,16,8,0,34,65,73,73,73,73,54,0,0 },
  { 192,64,128,0,62,65,65,65,65,65,34,20,20,119,0,0 },
  { 192,128,64,0,62,65,65,65,65,65,34,20,20,119,0,0 },
  { 208,80,136,0,62,65,65,65,65,65,34,20,20,119,0,0 },
  { 208,144,72,0,62,65,65,65,65,65,34,20,20,119,0,0 },
  { 200,80,144,0,62,65,65,65,65,65,34,20,20,119,0,0 },
  { 200,144,80,0,62,65,65,65,65,65,34,20,20,119,0,0 },
  { 50,76,24,8,16,28,34,65,65,65,34,20,20,119,0,0 },
  { 50,76,24,16,8,28,35,65,65,65,34,20,20,119,0,0 },
  { 0,0,32,32,16,0,50,74,68,68,68,68,74,50,0,0 },
  { 0,0,16,32,32,0,50,74,68,68,68,68,74,50,0,0 },
  { 0,0,16,16,8,0,60,66,64,60,64,64,66,60,0,0 },
  { 0,0,8,16,16,0,60,66,64,60,64,64,66,60,0,0 },
  { 0,0,16,16,8,0,92,98,66,66,66,66,66,66,2,2 },
  { 0,0,8,16,16,0,92,98,66,66,66,66,66,66,2,2 },
  { 0,0,16,16,8,0,16,16,16,16,16,16,16,12,0,0 },
  { 0,0,8,16,16,0,16,16,16,16,16,16,16,12,0,0 },
  { 0,0,16,16,8,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,8,16,16,0,60,66,66,66,66,66,66,60,0,0 },
  { 0,0,16,16,8,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,8,16,16,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,16,16,8,0,34,65,65,73,73,73,73,54,0,0 },
  { 0,0,4,8,8,0,34,65,65,73,73,73,73,54,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,97,134,125,190,123,142,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,97,134,125,190,123,142,119,190,119,190,127,254,0,0 },
  { 0,0,48,16,32,0,50,74,68,68,68,68,74,50,32,48 },
  { 0,0,48,32,16,0,50,74,68,68,68,68,74,50,32,48 },
  { 0,0,104,40,68,0,50,74,68,68,68,68,74,50,32,48 },
  { 0,0,104,72,36,0,50,74,68,68,68,68,74,50,32,48 },
  { 0,0,100,40,72,0,50,74,68,68,68,68,74,50,32,48 },
  { 0,0,100,72,40,0,50,74,68,68,68,68,74,50,32,48 },
  { 50,76,0,48,16,32,0,50,74,68,68,68,74,50,32,48 },
  { 50,76,0,48,32,16,0,50,74,68,68,68,74,50,32,48 },
  { 192,64,128,0,24,36,36,66,66,126,66,66,66,66,16,12 },
  { 192,128,64,0,24,36,36,66,66,126,66,66,66,66,16,12 },
  { 208,80,136,0,24,36,36,66,66,126,66,66,66,66,16,12 },
  { 208,144,72,0,24,36,36,66,66,126,66,66,66,66,16,12 },
  { 200,80,144,0,24,36,36,66,66,126,66,66,66,66,16,12 },
  { 200,144,80,0,24,36,36,66,66,126,66,66,66,66,16,12 },
  { 100,152,96,32,64,24,36,36,66,126,66,66,66,66,16,12 },
  { 100,152,96,64,32,24,36,36,66,126,66,66,66,66,16,12 },
  { 0,0,24,8,16,0,92,98,66,66,66,66,66,66,34,50 },
  { 0,0,24,16,8,0,92,98,66,66,66,66,66,66,34,50 },
  { 0,0,52,20,34,0,92,98,66,66,66,66,66,66,34,50 },
  { 0,0,52,36,18,0,92,98,66,66,66,66,66,66,34,50 },
  { 0,0,50,20,36,0,92,98,66,66,66,66,66,66,34,50 },
  { 0,0,50,36,20,0,92,98,66,66,66,66,66,66,34,50 },
  { 50,76,0,24,8,16,0,92,98,66,66,66,66,66,34,50 },
  { 50,76,0,24,16,8,0,92,98,66,66,66,66,66,34,50 },
  { 192,64,128,0,66,66,66,66,126,66,66,66,66,66,32,24 },
  { 192,128,64,0,66,66,66,66,126,66,66,66,66,66,32,24 },
  { 208,80,136,0,66,66,66,66,126,66,66,66,66,66,32,24 },
  { 208,144,72,0,66,66,66,66,126,66,66,66,66,66,32,24 },
  { 200,80,144,0,66,66,66,66,126,66,66,66,66,66,32,24 },
  { 200,144,80,0,66,66,66,66,126,66,66,66,66,66,32,24 },
  { 100,152,96,32,64,66,66,66,126,66,66,66,66,66,32,24 },
  { 100,152,96,64,32,66,66,66,126,66,66,66,66,66,32,24 },
  { 0,0,24,8,16,0,34,65,65,73,73,73,73,54,8,12 },
  { 0,0,24,16,8,0,34,65,65,73,73,73,73,54,8,12 },
  { 0,0,52,20,34,0,34,65,65,73,73,73,73,54,8,12 },
  { 0,0,52,36,18,0,34,65,65,73,73,73,73,54,8,12 },
  { 0,0,50,20,36,0,34,65,65,73,73,73,73,54,8,12 },
  { 0,0,50,36,20,0,34,65,65,73,73,73,73,54,8,12 },
  { 50,76,0,24,8,16,0,34,65,73,73,73,73,54,8,12 },
  { 50,76,0,24,16,8,0,34,65,73,73,73,73,54,8,12 },
  { 192,64,128,0,62,65,65,65,65,65,34,20,20,119,8,6 },
  { 192,128,64,0,62,65,65,65,65,65,34,20,20,119,8,6 },
  { 208,80,136,0,62,65,65,65,65,65,34,20,20,119,8,6 },
  { 208,144,72,0,62,65,65,65,65,65,34,20,20,119,8,6 },
  { 200,80,144,0,62,65,65,65,65,65,34,20,20,119,8,6 },
  { 200,144,80,0,62,65,65,65,65,65,34,20,20,119,8,6 },
  { 100,152,96,32,64,28,34,65,65,65,34,20,20,119,8,6 },
  { 100,152,96,64,32,28,34,65,65,65,34,20,20,119,8,6 },
  { 0,0,68,68,56,0,50,74,68,68,68,68,74,50,0,0 },
  { 0,0,0,0,124,0,50,74,68,68,68,68,74,50,0,0 },
  { 0,0,32,32,16,0,50,74,68,68,68,68,74,50,32,48 },
  { 0,0,0,0,0,0,50,74,68,68,68,68,74,50,32,48 },
  { 0,0,16,32,32,0,50,74,68,68,68,68,74,50,32,48 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,99,134,109,190,99,134,109,246,99,134,127,254,0,0 },
  { 0,0,0,50,76,0,50,74,68,68,68,68,74,50,0,0 },
  { 0,0,0,50,76,0,50,74,68,68,68,68,74,50,32,48 },
  { 66,66,60,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,60,0,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 128,128,64,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 64,128,128,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,0,0,0,24,36,36,66,66,126,66,66,66,66,16,12 },
  { 0,0,0,0,24,8,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,12 },
  { 24,8,16,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 50,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 50,76,0,102,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,16,8,0,92,98,66,66,66,66,66,66,34,50 },
  { 0,0,0,0,0,0,92,98,66,66,66,66,66,66,34,50 },
  { 0,0,8,16,16,0,92,98,66,66,66,66,66,66,34,50 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,113,134,111,190,111,134,111,246,113,134,127,254,0,0 },
  { 0,0,0,50,76,0,92,98,66,66,66,66,66,66,2,2 },
  { 0,0,0,50,76,0,92,98,66,66,66,66,66,66,34,50 },
  { 128,128,64,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 64,128,128,0,126,64,64,64,124,64,64,64,64,126,0,0 },
  { 128,128,64,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 64,128,128,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 0,0,0,0,66,66,66,66,126,66,66,66,66,66,16,12 },
  { 104,40,68,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 100,40,72,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 50,76,0,24,8,16,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,68,68,56,0,16,16,16,16,16,16,16,12,0,0 },
  { 0,0,0,0,60,0,16,16,16,16,16,16,16,12,0,0 },
  { 16,16,8,0,102,0,16,16,16,16,16,16,16,12,0,0 },
  { 8,16,16,0,102,0,16,16,16,16,16,16,16,12,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,99,182,109,182,109,134,109,246,99,246,127,254,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,99,134,109,190,109,134,109,246,99,134,127,254,0,0 },
  { 0,0,0,50,76,0,16,16,16,16,16,16,16,12,0,0 },
  { 0,50,76,0,102,0,16,16,16,16,16,16,16,12,0,0 },
  { 34,34,28,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,62,0,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 128,128,64,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 64,128,128,0,62,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,99,198,109,190,109,190,109,190,99,198,127,254,0,0 },
  { 104,72,36,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 100,72,40,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 50,76,0,24,16,8,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,66,66,60,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,60,0,0,66,66,66,66,66,66,66,60,0,0 },
  { 16,16,8,0,102,0,66,66,66,66,66,66,66,60,0,0 },
  { 8,16,16,0,102,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,24,8,16,0,60,66,66,66,66,66,98,92,64,64 },
  { 0,0,24,16,8,0,60,66,66,66,66,66,98,92,64,64 },
  { 0,0,0,50,76,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,50,76,0,102,0,66,66,66,66,66,66,66,60,0,0 },
  { 34,34,28,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 0,0,62,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 128,128,64,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 64,128,128,0,65,65,34,34,20,8,8,8,8,8,0,0 },
  { 192,128,64,0,124,66,66,66,124,64,64,64,64,64,0,0 },
  { 16,16,8,0,102,0,0,0,0,0,0,0,0,0,0,0 },
  { 8,16,16,0,102,0,0,0,0,0,0,0,0,0,0,0 },
  { 16,16,8,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,97,206,111,182,99,182,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,97,238,111,206,99,238,111,238,111,198,127,254,0,0 },
  { 0,0,16,16,8,0,34,65,65,73,73,73,73,54,8,12 },
  { 0,0,0,0,0,0,34,65,65,73,73,73,73,54,8,12 },
  { 0,0,4,8,8,0,34,65,65,73,73,73,73,54,8,12 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,97,134,111,190,99,134,111,246,111,134,127,254,0,0 },
  { 0,0,0,50,76,0,34,65,65,73,73,73,73,54,0,0 },
  { 0,0,0,50,76,0,34,65,65,73,73,73,73,54,8,12 },
  { 128,128,64,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 64,128,128,0,60,66,66,66,66,66,66,66,66,60,0,0 },
  { 128,128,64,0,62,65,65,65,65,65,34,20,20,119,0,0 },
  { 64,128,128,0,62,65,65,65,65,65,34,20,20,119,0,0 },
  { 0,0,0,0,62,65,65,65,65,65,34,20,20,119,8,6 },
  { 8,16,16,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,16,8,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,123,134,115,190,123,142,123,190,113,190,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 170,170,0,1,158,68,2,69,132,84,8,85,144,108,30,69,128,0,14,57,144,36,12,57,130,32,28,33,128,0,85,85 },
  { 170,170,0,1,158,68,2,69,132,84,8,85,144,108,30,69,128,0,18,9,154,8,22,73,146,72,18,49,128,0,85,85 },
  { 170,170,0,1,158,68,2,69,132,84,8,85,144,108,30,69,128,0,0,65,128,64,2,65,130,64,1,129,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,199,34,68,183,199,42,69,35,244,162,0,1,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,242,34,74,55,242,42,82,35,203,162,0,1,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 0,0,0,0,0,0,0,0,0,60,0,0,0,0,0,0 },
  { 170,170,0,1,128,0,18,113,154,72,22,113,146,72,18,113,128,0,0,1,131,192,0,1,128,0,0,1,128,0,85,85 },
  { 0,0,0,0,0,0,0,0,0,126,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,126,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0 },
  { 0,0,0,20,20,20,20,20,20,20,20,20,20,20,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,255,0,255 },
  { 0,0,8,16,16,24,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,24,8,8,16,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,8,8,16 },
  { 0,0,24,16,16,8,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,34,68,68,102,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,102,34,34,68,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,102,34,34,68 },
  { 0,0,102,68,68,34,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,8,28,8,42,127,42,8,28,8,8,8,8,0,0 },
  { 0,8,28,8,42,127,42,8,8,42,127,42,8,28,8,0 },
  { 0,0,0,0,0,0,0,56,124,124,124,56,0,0,0,0 },
  { 0,0,0,0,0,0,32,48,56,60,56,48,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,24,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,54,54,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,73,73,0,0 },
  { 0,0,0,0,0,0,0,0,0,24,24,0,0,0,0,0 },
  { 170,170,0,1,128,0,2,1,130,0,2,1,130,0,3,193,128,0,59,221,194,18,51,221,138,16,115,209,128,0,85,85 },
  { 170,170,0,1,128,0,3,129,130,64,3,129,130,0,2,1,128,0,59,221,194,18,51,221,138,16,115,209,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,195,158,66,81,195,158,66,145,250,94,0,1,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,242,30,74,17,242,30,82,17,203,222,0,1,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,243,158,74,81,242,94,66,81,195,144,0,1,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,195,140,66,83,195,146,66,147,250,76,0,1,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,242,12,74,19,242,18,82,19,203,204,0,1,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,74,93,235,82,90,221,202,82,74,93,128,0,14,57,144,36,12,57,130,32,28,33,128,0,85,85 },
  { 0,0,0,0,66,164,164,72,16,16,42,85,85,138,0,0 },
  { 0,0,0,0,64,160,160,76,48,192,42,85,85,42,0,0 },
  { 0,0,0,0,12,24,16,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,51,102,68,136,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,126,84,168,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,48,24,8,4,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,204,102,34,17,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,252,126,42,21,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,16,40,68 },
  { 0,0,0,0,2,2,4,4,8,8,4,4,2,2,0,0 },
  { 0,0,0,0,64,64,32,32,16,16,32,32,64,64,0,0 },
  { 0,0,0,0,0,73,34,20,73,20,34,73,0,0,0,0 },
  { 0,0,0,0,36,36,36,36,36,36,36,0,36,36,0,0 },
  { 0,0,0,0,60,74,74,10,12,8,8,0,8,8,0,0 },
  { 126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,60 },
  { 60,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,4,8,16,40,68 },
  { 0,0,0,0,0,0,8,28,8,0,34,119,34,0,0,0 },
  { 0,0,0,0,0,0,0,0,60,60,0,0,0,0,0,0 },
  { 0,0,0,0,2,2,4,8,8,16,16,32,64,64,0,0 },
  { 0,0,0,14,8,8,8,8,14,8,8,8,8,8,14,0 },
  { 0,0,0,112,16,16,16,16,112,16,16,16,16,16,112,0 },
  { 0,0,0,238,17,17,34,204,136,136,136,0,0,136,0,0 },
  { 0,0,0,114,10,10,18,98,66,66,66,0,0,66,0,0 },
  { 0,0,0,92,66,66,68,88,80,80,80,0,0,80,0,0 },
  { 0,0,0,0,0,0,0,0,0,124,4,8,16,32,0,0 },
  { 0,0,0,0,252,94,94,94,92,80,80,80,80,80,80,0 },
  { 0,0,0,0,30,58,58,58,30,0,0,0,0,0,0,0 },
  { 0,0,0,0,120,92,92,92,120,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,8,73,42,28,42,73,8,0,0 },
  { 0,0,0,0,0,0,24,24,0,0,0,24,16,16,8,0 },
  { 0,0,0,60,66,66,0,0,0,66,66,60,0,0,0,0 },
  { 0,8,73,42,28,42,73,8,0,8,73,42,28,42,73,8 },
  { 0,0,0,0,98,98,4,8,8,16,16,32,70,70,0,0 },
  { 0,0,0,0,0,0,0,0,0,113,142,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,66 },
  { 0,0,0,0,146,84,56,254,56,84,146,0,0,0,0,0 },
  { 0,0,0,0,0,4,0,0,32,0,0,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,51,51,102,102,68,68,136,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,16,0,68,0,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,68,0,16,0,68,0,0,0,0,0 },
  { 0,0,0,0,0,16,0,0,0,0,0,0,0,16,0,0 },
  { 0,0,0,0,16,0,0,130,0,0,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,84,16,124,16,84,0,0,0,0,0 },
  { 0,0,0,0,0,16,0,0,0,16,0,0,0,16,0,0 },
  { 0,0,0,0,16,0,0,16,0,0,16,0,0,16,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 170,170,0,1,128,0,0,1,128,0,0,1,162,8,34,9,170,8,54,137,162,112,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,140,0,16,1,144,136,16,137,145,4,17,5,145,4,125,5,145,4,17,5,144,136,96,137,128,0,85,85 },
  { 170,170,64,5,160,8,16,17,136,32,4,65,130,128,1,1,130,128,4,65,136,32,16,17,160,8,64,5,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,0,24,1,136,0,8,1,144,0,85,85 },
  { 170,170,0,1,128,0,0,1,128,0,1,1,129,0,1,1,143,224,1,1,129,0,1,1,129,0,0,1,128,0,85,85 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,115,134,111,190,99,134,109,246,115,134,127,254,0,0 },
  { 170,170,0,1,128,0,0,1,163,156,34,73,163,136,34,137,186,92,0,1,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,185,28,37,9,185,8,41,9,165,220,0,1,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,185,220,34,9,185,136,32,73,163,156,0,1,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,0,1,243,156,74,73,242,72,66,73,195,156,0,1,128,0,0,1,128,0,0,1,128,0,85,85 },
  { 170,170,0,1,128,0,7,193,129,0,1,1,129,0,7,193,128,0,30,121,160,128,28,113,130,8,60,241,128,0,85,85 },
  { 170,170,0,1,128,0,3,129,132,64,7,193,132,64,4,65,128,0,30,121,160,128,28,113,130,8,60,241,128,0,85,85 },
  { 170,170,0,1,128,0,3,225,128,128,0,129,128,128,3,225,128,0,57,246,197,8,125,231,197,1,69,15,128,0,85,85 },
  { 170,170,0,1,128,0,1,193,130,32,3,225,130,32,2,33,128,0,57,246,197,8,125,231,197,1,69,15,128,0,85,85 },
  { 170,170,0,1,128,0,34,113,178,136,42,249,166,136,34,137,128,0,60,121,162,128,34,113,162,8,60,241,128,0,85,85 },
  { 170,170,0,1,128,0,34,113,178,136,42,137,166,136,34,113,128,0,60,121,162,128,34,113,162,8,60,241,128,0,85,85 },
  { 0,0,28,34,34,34,34,34,28,0,0,0,0,0,0,0 },
  { 0,0,8,0,8,8,8,8,8,0,0,0,0,0,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,134,125,246,123,134,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,142,125,246,123,198,119,246,119,142,127,254,0,0 },
  { 0,0,4,12,20,36,62,4,4,0,0,0,0,0,0,0 },
  { 0,0,62,32,32,60,2,2,60,0,0,0,0,0,0,0 },
  { 0,0,28,34,32,60,34,34,28,0,0,0,0,0,0,0 },
  { 0,0,62,2,2,4,8,8,8,0,0,0,0,0,0,0 },
  { 0,0,28,34,34,28,34,34,28,0,0,0,0,0,0,0 },
  { 0,0,28,34,34,30,2,34,28,0,0,0,0,0,0,0 },
  { 0,0,0,8,8,62,8,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,62,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,62,0,62,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,8,8,8,8,8,4,0,0,0,0,0,0,0 },
  { 0,0,16,8,8,8,8,8,16,0,0,0,0,0,0,0 },
  { 0,0,0,0,44,50,34,34,34,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,28,34,34,34,34,34,28 },
  { 0,0,0,0,0,0,0,0,0,8,24,40,8,8,8,8 },
  { 0,0,0,0,0,0,0,0,0,28,34,2,28,32,32,62 },
  { 0,0,0,0,0,0,0,0,0,28,34,2,28,2,34,28 },
  { 0,0,0,0,0,0,0,0,0,4,12,20,36,62,4,4 },
  { 0,0,0,0,0,0,0,0,0,62,32,32,60,2,2,60 },
  { 0,0,0,0,0,0,0,0,0,28,34,32,60,34,34,28 },
  { 0,0,0,0,0,0,0,0,0,62,2,2,4,8,8,8 },
  { 0,0,0,0,0,0,0,0,0,28,34,34,28,34,34,28 },
  { 0,0,0,0,0,0,0,0,0,28,34,34,30,2,34,28 },
  { 0,0,0,0,0,0,0,0,0,0,8,8,62,8,8,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,62,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,62,0,62,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,8,8,8,8,8,4 },
  { 0,0,0,0,0,0,0,0,0,16,8,8,8,8,8,16 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,115,134,109,190,115,142,109,190,115,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,56,68,4,60,68,76,52 },
  { 0,0,0,0,0,0,0,0,0,56,68,68,124,64,68,56 },
  { 0,0,0,0,0,0,0,0,0,56,68,68,68,68,68,56 },
  { 0,0,0,0,0,0,0,0,0,0,66,36,24,24,36,66 },
  { 0,0,0,0,0,0,0,0,0,56,68,4,124,68,68,56 },
  { 0,0,0,0,0,0,0,0,0,64,64,64,112,72,72,72 },
  { 0,0,0,0,0,0,0,0,0,64,64,72,80,96,80,72 },
  { 0,0,0,0,0,0,0,0,0,48,16,16,16,16,16,56 },
  { 0,0,0,0,0,0,0,0,0,0,0,118,73,73,73,73 },
  { 0,0,0,0,0,0,0,0,0,0,0,88,100,68,68,68 },
  { 0,0,0,0,0,0,0,0,0,88,100,68,100,88,64,64 },
  { 0,0,0,0,0,0,0,0,0,0,48,72,32,16,72,48 },
  { 0,0,0,0,0,0,0,0,0,32,32,120,32,32,32,24 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,115,142,109,182,113,182,125,182,115,142,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,115,134,109,190,113,142,125,190,115,134,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,115,134,109,190,113,142,125,190,115,190,127,254,0,0 },
  { 0,0,0,0,60,64,64,94,80,80,60,16,16,30,0,0 },
  { 0,0,0,0,10,62,74,84,84,104,104,114,92,16,0,0 },
  { 0,0,0,0,28,34,66,64,86,88,80,80,50,28,0,0 },
  { 0,0,0,0,63,32,32,32,62,32,32,252,32,32,0,0 },
  { 0,0,0,0,14,16,16,126,16,126,16,16,62,97,0,0 },
  { 0,0,0,0,1,1,118,77,77,73,73,89,105,105,0,0 },
  { 0,0,0,0,34,34,50,127,42,127,38,38,34,34,0,0 },
  { 0,0,0,0,104,88,95,92,108,74,73,73,73,78,0,0 },
  { 0,0,0,0,112,72,75,76,116,84,82,73,73,78,0,0 },
  { 0,0,0,0,34,34,34,127,42,127,54,54,34,34,0,0 },
  { 0,0,0,0,0,0,122,74,90,90,90,90,82,94,0,0 },
  { 0,0,0,2,15,2,58,70,66,66,66,66,70,58,0,126 },
  { 0,0,0,0,12,18,32,124,32,124,32,32,18,12,0,0 },
  { 0,0,0,0,66,68,72,80,96,254,80,72,68,66,0,0 },
  { 0,0,0,0,127,8,8,14,56,14,56,8,8,8,0,0 },
  { 0,0,0,0,112,72,72,72,72,78,77,77,78,116,4,4 },
  { 0,0,0,0,28,34,34,34,20,12,42,50,49,33,2,4 },
  { 0,0,124,66,255,66,255,66,124,64,64,64,64,64,0,0 },
  { 0,0,16,16,60,82,82,80,80,86,82,82,86,58,16,16 },
  { 0,0,0,0,24,36,36,255,66,255,66,66,66,66,0,0 },
  { 0,0,0,0,60,66,2,2,255,48,255,64,66,60,0,0 },
  { 0,0,16,16,60,82,82,80,80,80,80,82,82,60,16,16 },
  { 0,0,0,0,40,40,40,126,40,40,40,40,41,38,0,0 },
  { 0,0,0,0,60,66,66,32,24,4,82,170,170,252,168,168 },
  { 0,0,0,0,0,0,254,0,254,16,16,16,16,16,0,0 },
  { 0,0,0,0,0,0,31,248,1,128,31,248,0,192,0,192,3,192,3,128,3,128,1,0,0,128,0,64,0,32,0,16 },
  { 0,32,32,40,48,96,168,48,98,162,36,56,0,0,0,0 },
  { 0,0,0,0,64,160,252,34,66,84,232,64,68,56,0,0 },
  { 0,0,0,0,0,0,0,16,16,56,84,84,84,84,0,0 },
  { 0,0,0,0,60,34,34,34,124,32,124,32,32,32,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,99,134,109,190,99,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,99,134,109,190,99,142,109,190,99,190,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,206,111,182,111,182,111,182,113,206,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,238,111,206,111,238,111,238,113,198,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,134,111,246,111,134,111,190,113,134,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,142,111,246,111,198,111,246,113,142,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,182,111,182,111,134,111,246,113,246,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,134,111,190,111,134,111,246,113,134,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,206,111,190,111,142,111,182,113,206,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,134,111,246,111,238,111,222,113,222,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,206,111,182,111,206,111,182,113,206,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,206,111,182,111,198,111,246,113,206,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,134,111,182,111,134,111,182,113,182,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,142,111,182,111,142,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,198,111,190,111,190,111,190,113,198,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,142,111,182,111,182,111,182,113,142,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,134,111,190,111,142,111,190,113,134,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,113,134,111,190,111,142,111,190,113,190,127,254,0,0 },
  { 0,16,32,126,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,8,4,126,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,16,16,16,16,16,16,16,16,16,16,0,0 },
  { 0,0,0,0,0,16,16,16,16,16,16,16,0,0,0,0 },
  { 0,76,82,96,120,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,50,74,6,30,0,0,0,0,0,0,0,0,0,0,0 },
  { 16,32,126,32,16,0,0,0,0,0,0,0,0,0,0,0 },
  { 8,4,126,4,8,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,24,36,36,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,56,52,36,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,28,44,36,24,0,0,0,0,0 },
  { 0,0,42,42,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,85,85,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,3,128,12,96,48,24,32,8,64,4,64,4,128,2,128,2,128,2,64,4,64,4,32,8,48,24,12,96,3,128 },
  { 0,0,127,254,64,2,64,2,64,2,64,2,64,2,64,2,64,2,64,2,64,2,64,2,64,2,64,2,127,254,0,0 },
  { 0,0,1,0,2,128,4,64,8,32,16,16,32,8,64,4,128,2,64,4,32,8,16,16,8,32,4,64,2,128,1,0 },
  { 0,0,3,128,12,96,48,24,48,8,88,4,76,4,134,2,131,2,129,130,64,196,64,100,32,56,48,24,12,96,3,128 },
  { 36,66,255,66,36,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,252,64,2,64,2,64,2,64,2,64,2,64,2,64,2,64,2,64,2,63,252,127,254,0,0 },
  { 0,0,63,252,96,6,95,250,80,10,80,10,80,10,80,10,80,10,80,10,80,10,80,10,95,250,96,6,63,252,0,0 },
  { 0,128,1,192,1,64,3,96,2,32,4,16,4,16,8,8,8,8,24,12,16,4,16,4,32,2,32,2,63,254,0,0 },
  { 0,0,32,32,32,16,16,16,16,16,8,8,8,8,0,0 },
  { 0,0,40,40,40,40,40,40,40,40,40,40,40,40,0,0 },
  { 0,0,63,254,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84 },
  { 0,255,129,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,4,0,8,0,31,252,8,0,4,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,10,10,10,20,20,20,20,20,40,40,40,40,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,126,4,8 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,126,32,16 },
  { 0,0,0,0,0,0,0,0,0,0,0,16,32,126,32,16 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,4,126,4,8 },
  { 36,24,126,24,36,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,238,111,206,99,238,111,238,111,198,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,134,111,246,99,134,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,142,111,246,99,198,111,246,111,142,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,182,111,182,99,134,111,246,111,246,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,134,111,190,99,134,111,246,111,134,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,97,206,125,182,97,182,111,182,97,206,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,0,0,0,48,81,82,52,8,19,36,68,3,0,0 },
  { 0,0,0,0,0,48,81,82,52,11,20,34,65,6,0,0 },
  { 0,0,0,0,30,49,80,80,80,80,80,80,49,30,0,0 },
  { 64,160,160,64,60,66,66,64,64,64,64,66,66,60,0,0 },
  { 0,0,0,0,16,16,60,80,80,80,80,60,16,30,0,0 },
  { 0,0,0,0,0,48,65,66,52,8,22,41,73,6,0,0 },
  { 0,0,0,0,0,48,65,66,52,8,16,41,73,6,0,0 },
  { 0,0,0,0,62,66,64,64,56,64,64,66,66,60,0,0 },
  { 0,0,0,0,124,66,2,18,30,18,2,2,66,60,0,0 },
  { 64,160,160,64,126,64,64,64,124,64,64,64,64,64,0,0 },
  { 0,0,0,0,0,0,58,70,66,66,62,2,63,66,60,0 },
  { 0,0,0,0,18,117,150,20,28,52,84,148,148,99,0,0 },
  { 0,0,0,0,119,183,182,182,54,62,54,54,118,103,0,0 },
  { 0,0,0,0,113,81,81,81,95,81,81,81,81,113,0,0 },
  { 0,0,0,0,64,64,64,88,100,68,68,68,68,70,0,0 },
  { 0,0,0,8,80,96,64,216,100,68,68,68,68,70,0,0 },
  { 0,0,0,0,12,20,36,4,4,6,12,20,36,40,48,0 },
  { 0,0,0,0,63,126,68,36,6,6,6,6,118,92,0,0 },
  { 0,0,0,12,18,18,60,16,16,16,16,112,153,102,0,0 },
  { 0,0,0,24,36,36,36,40,48,96,32,32,34,28,0,0 },
  { 0,0,0,0,72,72,254,72,74,77,73,73,73,54,0,0 },
  { 0,0,0,0,113,81,89,89,85,85,83,83,81,113,0,0 },
  { 0,0,0,0,146,149,149,210,208,183,176,144,144,144,0,0 },
  { 0,0,0,0,60,66,185,165,165,185,161,161,66,60,0,0 },
  { 0,0,0,0,0,0,32,76,82,34,34,42,84,80,80,32 },
  { 0,0,0,0,124,82,82,82,82,92,80,80,80,112,0,0 },
  { 0,0,0,0,28,50,81,81,81,81,81,81,54,30,1,0 },
  { 0,0,0,64,46,17,49,81,81,94,84,82,82,33,0,0 },
  { 0,0,0,0,68,110,178,51,54,60,54,54,162,195,0,0 },
  { 0,0,0,0,126,81,81,81,81,94,88,84,82,113,0,0 },
  { 0,0,0,0,124,66,66,66,124,80,74,68,74,80,0,0 },
  { 0,0,56,8,124,74,74,74,124,104,88,72,76,74,8,0 },
  { 0,0,0,0,113,155,85,49,209,0,0,0,0,0,0,0 },
  { 0,0,0,0,254,82,90,82,95,0,0,0,0,0,0,0 },
  { 0,0,0,0,241,91,85,81,81,0,0,0,0,0,0,0 },
  { 0,0,48,12,133,137,74,82,84,36,40,120,80,128,0,0 },
  { 0,0,0,0,126,10,10,18,20,36,40,72,80,126,0,0 },
  { 0,0,0,0,60,8,16,62,4,8,24,4,2,66,60,0 },
  { 0,0,0,0,62,65,65,65,65,65,34,20,85,119,0,0 },
  { 0,0,0,0,119,85,20,34,65,65,65,65,65,62,0,0 },
  { 0,0,0,0,60,126,6,60,38,6,6,102,60,0,0,0 },
  { 0,0,0,0,0,0,0,112,8,8,8,8,14,8,0,0 },
  { 0,0,0,0,0,0,68,72,80,96,96,80,72,68,0,0 },
  { 24,36,24,0,24,36,36,66,66,126,66,66,66,66,0,0 },
  { 0,0,0,0,46,81,81,81,94,81,81,81,81,46,0,0 },
  { 0,0,0,6,30,60,108,102,102,108,96,96,102,60,24,0 },
  { 0,0,0,0,0,0,60,102,102,126,96,96,102,60,0,0 },
  { 0,0,0,0,0,0,0,24,36,72,112,64,68,56,0,0 },
  { 0,0,0,0,14,18,32,32,28,32,64,68,66,60,0,0 },
  { 0,0,0,0,60,66,2,4,4,8,62,16,32,32,0,0 },
  { 0,0,0,0,2,2,2,2,2,62,2,2,2,126,0,0 },
  { 0,0,0,0,99,54,42,42,42,42,42,106,170,73,0,0 },
  { 0,0,0,0,0,0,24,36,83,78,66,66,36,24,0,0 },
  { 0,0,0,0,0,0,68,70,34,20,40,100,114,98,0,0 },
  { 0,0,0,0,0,16,62,2,2,2,2,2,63,126,0,0 },
  { 0,0,0,0,64,60,30,2,2,2,14,50,50,50,0,0 },
  { 0,0,0,0,0,64,62,31,2,2,2,2,3,2,0,0 },
  { 0,0,0,0,0,24,24,0,56,24,24,24,24,126,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,31,232,32,48,32,80,32,80,32,48,31,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,124,0,64,0,64,0,64,0,114,34,69,20,72,136,79,136,72,148,72,162,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,31,248,10,80,10,80,10,80,10,80,10,72,10,36,14,28,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,12,4,10,8,9,16,4,160,2,64,2,64,4,128,9,0,18,0,28,0 },
  { 0,0,0,0,127,85,83,81,80,80,80,80,80,112,0,0 },
  { 0,0,0,0,0,0,0,0,63,248,20,80,20,80,20,80,20,80,20,80,20,80,20,80,20,80,28,112,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,248,18,40,9,24,4,136,2,64,4,128,9,8,18,24,20,40,31,248,0,0,0,0 },
  { 0,0,0,0,124,66,66,66,114,2,2,2,66,60,0,0 },
  { 0,0,0,0,126,2,2,2,2,2,2,2,2,2,0,0 },
  { 0,0,0,0,2,2,2,2,2,2,2,2,2,126,0,0 },
  { 0,0,0,0,16,16,16,16,40,68,130,130,130,130,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,5,48,5,40,9,40,10,40,10,72,18,80,20,80,20,96,31,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,56,0,40,0,40,0,72,7,208,10,80,18,144,20,160,20,160,15,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,60,82,158,160,162,124,0,0 },
  { 0,0,0,0,0,4,4,0,62,18,20,36,40,124,0,0 },
  { 0,0,0,0,0,4,4,0,62,18,20,20,36,40,40,240 },
  { 0,0,16,16,124,82,82,82,82,92,16,16,16,30,0,0 },
  { 0,0,0,0,78,49,33,81,78,28,34,34,34,28,0,0 },
  { 0,0,0,0,0,0,0,0,52,192,77,32,37,32,5,32,31,248,37,36,31,196,5,8,5,0,2,0,0,0,0,0 },
  { 0,0,0,0,66,162,228,168,8,19,20,34,65,70,0,0 },
  { 0,0,0,0,0,0,0,4,4,4,60,4,4,124,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,16,42,168,42,168,42,168,17,16,110,236,0,0,0,0 },
  { 0,0,0,0,34,98,36,40,40,30,18,34,68,68,4,0 },
  { 0,0,0,0,34,98,36,40,40,30,26,46,66,76,0,0 },
  { 0,0,0,0,66,194,68,72,80,34,85,181,149,18,0,0 },
  { 0,0,0,0,34,98,36,40,40,28,18,36,66,76,0,0 },
  { 0,0,0,0,98,18,36,72,120,28,18,36,66,76,0,0 },
  { 0,0,0,0,34,98,36,40,40,30,24,44,66,76,0,0 },
  { 0,0,0,0,98,18,36,72,120,30,24,44,66,76,0,0 },
  { 0,0,0,0,98,18,36,24,104,30,24,44,66,76,0,0 },
  { 0,0,0,0,34,98,244,40,40,30,24,44,66,76,0,0 },
  { 0,0,0,0,34,98,36,40,40,22,24,46,74,78,0,0 },
  { 0,0,0,0,114,66,100,24,104,22,24,46,74,78,0,0 },
  { 0,0,0,0,34,98,36,40,40,20,26,36,74,78,0,0 },
  { 0,0,0,0,98,18,36,24,104,20,26,36,74,78,0,0 },
  { 0,0,0,0,114,66,100,24,104,20,26,36,74,78,0,0 },
  { 0,0,0,0,114,18,36,72,72,20,26,36,74,78,0,0 },
  { 0,0,0,0,34,98,36,40,40,16,16,32,64,64,0,0 },
  { 0,0,0,0,28,8,8,8,8,8,8,8,8,28,0,0 },
  { 0,0,0,0,126,36,36,36,36,36,36,36,36,126,0,0 },
  { 0,0,0,0,127,42,42,42,42,42,42,42,42,127,0,0 },
  { 0,0,0,0,127,41,41,41,41,41,38,38,38,127,0,0 },
  { 0,0,0,0,127,34,34,34,20,20,20,8,8,62,0,0 },
  { 0,0,0,0,255,74,74,74,74,74,50,50,50,127,0,0 },
  { 0,0,0,0,255,85,85,85,85,37,37,37,37,127,0,0 },
  { 0,0,0,0,255,181,181,181,181,85,85,85,85,255,0,0 },
  { 0,0,0,0,127,42,42,42,36,36,42,42,42,127,0,0 },
  { 0,0,0,0,127,34,34,20,8,8,20,34,34,127,0,0 },
  { 0,0,0,0,127,42,42,42,18,18,42,42,42,127,0,0 },
  { 0,0,0,0,127,85,85,85,37,37,85,85,85,127,0,0 },
  { 0,0,0,0,112,32,32,32,32,32,32,32,34,126,0,0 },
  { 0,0,0,0,26,38,64,64,64,64,64,64,34,28,0,0 },
  { 0,0,0,0,120,36,34,34,34,34,34,34,36,120,0,0 },
  { 0,0,0,0,99,34,54,54,54,42,42,42,42,127,0,0 },
  { 0,0,0,0,8,8,0,8,24,8,8,8,8,28,0,0 },
  { 0,0,0,0,36,36,0,36,108,36,36,36,36,126,0,0 },
  { 0,0,0,0,42,42,0,42,126,42,42,42,42,127,0,0 },
  { 0,0,0,0,32,32,0,59,105,41,41,38,38,127,0,0 },
  { 0,0,0,0,0,0,0,119,34,34,34,20,8,62,0,0 },
  { 0,0,0,0,2,2,0,90,78,74,74,50,50,127,0,0 },
  { 0,0,0,0,5,5,0,85,95,85,85,37,37,127,0,0 },
  { 0,0,0,0,21,21,0,181,191,181,85,85,85,255,0,0 },
  { 0,0,0,0,32,32,0,42,106,36,36,42,42,127,0,0 },
  { 0,0,0,0,0,0,0,119,34,20,8,20,34,119,0,0 },
  { 0,0,0,0,2,2,0,42,46,18,18,42,42,127,0,0 },
  { 0,0,0,0,5,5,0,85,95,37,37,85,85,127,0,0 },
  { 0,0,0,0,8,24,8,8,8,8,8,8,8,28,0,0 },
  { 0,0,0,0,0,0,0,26,38,64,64,64,34,28,0,0 },
  { 0,0,0,0,2,6,2,26,38,66,66,66,38,27,0,0 },
  { 0,0,0,0,0,0,116,42,42,42,42,42,42,127,0,0 },
  { 0,0,0,0,44,90,74,74,74,74,74,74,90,44,0,0 },
  { 0,0,0,0,120,36,50,42,42,42,42,50,36,120,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,9,32,19,144,21,80,21,80,21,80,21,80,19,144,9,32,7,192,0,0,0,0 },
  { 0,0,0,0,88,100,2,2,2,2,2,2,68,56,0,0 },
  { 0,0,0,0,0,0,0,56,68,2,2,2,100,88,0,0 },
  { 0,0,0,0,58,70,128,128,128,128,128,128,70,58,2,2 },
  { 0,0,0,0,16,16,16,16,16,16,146,84,56,16,0,0 },
  { 0,0,0,248,70,113,73,101,85,101,73,113,70,248,0,0 },
  { 0,0,0,0,0,0,15,224,49,24,71,196,73,36,83,148,85,84,83,148,73,36,71,196,49,24,15,224,0,0,0,0 },
  { 0,0,0,0,34,82,84,88,40,28,18,36,66,76,0,0 },
  { 0,0,127,254,97,238,125,206,97,238,111,238,97,198,127,254,127,254,115,134,109,182,115,134,109,182,115,182,127,254,0,0 },
  { 0,0,127,254,97,238,125,206,97,238,111,238,97,198,127,254,127,254,115,142,109,182,115,142,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,97,238,125,206,97,238,111,238,97,198,127,254,127,254,115,198,109,190,115,190,109,190,115,198,127,254,0,0 },
  { 0,0,127,254,97,238,125,206,97,238,111,238,97,198,127,254,127,254,115,142,109,182,115,182,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,97,238,125,206,97,238,111,238,97,198,127,254,127,254,115,134,109,190,115,142,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,97,238,125,206,97,238,111,238,97,198,127,254,127,254,115,134,109,190,115,142,109,190,115,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,16,32,127,32,16,0,0,0,0 },
  { 0,0,8,28,42,8,8,8,8,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,8,4,254,4,8,0,0,0,0 },
  { 8,8,8,8,8,8,8,8,8,8,8,42,28,8,0,0 },
  { 0,0,0,0,0,0,0,36,66,255,66,36,0,0,0,0 },
  { 0,0,8,28,42,8,8,8,8,8,8,42,28,8,0,0 },
  { 0,0,0,0,0,120,96,80,72,4,2,0,0,0,0,0 },
  { 0,0,0,0,0,30,6,10,18,32,64,0,0,0,0,0 },
  { 0,0,0,0,0,64,32,18,10,6,30,0,0,0,0,0 },
  { 0,0,0,0,0,0,2,4,72,80,96,120,0,0,0,0 },
  { 0,0,0,0,0,4,4,20,36,127,36,20,4,4,0,0 },
  { 0,0,0,0,0,32,32,40,36,254,36,40,32,32,0,0 },
  { 0,0,0,0,0,0,0,16,38,121,32,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,8,100,158,4,8,0,0,0,0 },
  { 0,0,0,0,0,0,36,72,255,72,36,0,0,0,0,0 },
  { 0,0,8,28,42,8,28,42,8,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,36,18,255,18,36,0,0,0,0 },
  { 8,8,8,8,8,8,8,8,8,42,28,8,42,28,8,0 },
  { 0,0,0,0,0,0,0,17,34,124,34,17,0,0,0,0 },
  { 0,0,0,0,0,0,0,136,68,62,68,136,0,0,0,0 },
  { 0,0,0,0,0,0,0,18,34,126,34,18,0,0,0,0 },
  { 0,0,8,28,42,8,8,8,8,8,8,8,8,62,0,0 },
  { 0,0,0,0,0,0,0,72,68,126,68,72,0,0,0,0 },
  { 0,0,62,8,8,8,8,8,8,8,8,42,28,8,0,0 },
  { 0,0,8,28,42,8,8,8,8,8,42,28,8,62,0,0 },
  { 0,0,0,0,0,0,2,17,33,126,32,16,0,0,0,0 },
  { 0,0,0,0,0,0,32,68,66,63,2,4,0,0,0,0 },
  { 0,0,0,0,0,0,2,21,37,126,36,20,0,0,0,0 },
  { 0,0,0,0,0,0,32,84,82,63,18,20,0,0,0,0 },
  { 0,0,0,0,0,0,0,36,90,231,66,36,0,0,0,0 },
  { 0,0,0,0,0,8,8,44,74,255,74,44,8,8,0,0 },
  { 0,0,64,64,64,72,88,104,72,8,8,42,28,8,0,0 },
  { 0,0,0,0,0,0,0,16,32,120,36,20,4,4,4,4 },
  { 0,0,0,0,0,0,0,8,4,30,36,40,32,32,32,32 },
  { 4,4,4,4,4,4,4,20,36,120,32,16,0,0,0,0 },
  { 32,32,32,32,32,32,32,40,36,30,4,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,252,4,21,14,4,0,0 },
  { 4,4,4,4,4,4,4,20,36,124,32,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,30,33,169,113,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,120,132,149,142,4,0,0,0 },
  { 0,0,0,126,0,120,96,80,72,4,2,0,0,0,0,0 },
  { 0,0,0,80,96,126,96,80,0,10,6,126,6,10,0,0 },
  { 0,0,0,0,0,0,0,46,76,74,66,66,60,0,0,0 },
  { 0,0,0,0,0,0,0,116,50,82,66,66,60,0,0,0 },
  { 0,0,0,0,0,0,0,16,32,127,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,127,32,16,0,0,0,0 },
  { 0,0,8,12,10,8,8,8,8,8,8,8,8,8,8,8 },
  { 0,0,8,24,40,8,8,8,8,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,8,4,254,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,254,4,8,0,0,0,0 },
  { 8,8,8,8,8,8,8,8,8,8,8,10,12,8,0,0 },
  { 8,8,8,8,8,8,8,8,8,8,8,40,24,8,0,0 },
  { 0,0,0,8,4,126,4,8,0,16,32,126,32,16,0,0 },
  { 0,0,36,116,172,36,36,36,36,36,36,53,46,36,0,0 },
  { 0,0,0,16,32,126,32,16,0,8,4,126,4,8,0,0 },
  { 0,0,0,16,32,126,32,16,0,16,32,126,32,16,0,0 },
  { 0,0,36,126,165,36,36,36,36,36,36,36,36,36,0,0 },
  { 0,0,0,8,4,126,4,8,0,8,4,126,4,8,0,0 },
  { 0,0,36,36,36,36,36,36,36,36,36,165,126,36,0,0 },
  { 0,0,0,0,0,0,16,32,126,0,126,4,8,0,0,0 },
  { 0,0,0,0,0,0,8,4,126,0,126,32,16,0,0,0 },
  { 0,0,0,0,0,8,8,40,126,136,126,40,8,8,0,0 },
  { 0,0,0,0,0,8,8,44,126,137,126,44,8,8,0,0 },
  { 0,0,0,0,0,16,16,20,126,17,126,20,16,16,0,0 },
  { 0,0,0,0,0,0,0,16,62,64,62,16,0,0,0,0 },
  { 0,0,8,20,54,20,20,20,20,20,20,20,20,20,0,0 },
  { 0,0,0,0,0,0,0,8,124,2,124,8,0,0,0,0 },
  { 0,0,20,20,20,20,20,20,20,20,20,54,20,8,0,0 },
  { 0,0,0,0,0,0,0,36,126,129,126,36,0,0,0,0 },
  { 0,0,8,20,54,20,20,20,20,20,20,54,20,8,0,0 },
  { 0,0,0,0,0,120,80,104,84,10,4,0,0,0,0,0 },
  { 0,0,0,0,0,30,10,22,42,80,32,0,0,0,0,0 },
  { 0,0,0,0,0,4,10,84,104,80,120,0,0,0,0,0 },
  { 0,0,0,0,0,32,80,42,22,10,30,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,62,64,254,64,62,16,0,0,0 },
  { 0,0,0,0,0,0,8,124,2,127,2,124,8,0,0,0 },
  { 0,0,0,0,0,0,0,32,66,245,72,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,4,66,175,18,4,0,0,0,0 },
  { 0,0,8,28,42,8,8,8,62,8,62,8,8,8,8,8 },
  { 8,8,8,8,8,62,8,62,8,8,8,42,28,8,0,0 },
  { 0,0,0,0,0,0,0,16,32,119,32,16,0,0,0,0 },
  { 0,0,8,28,42,8,8,0,8,8,8,8,0,8,8,8 },
  { 0,0,0,0,0,0,0,4,2,239,2,4,0,0,0,0 },
  { 8,8,8,0,8,8,8,8,0,8,8,42,28,8,0,0 },
  { 0,0,0,0,0,0,0,80,96,127,96,80,0,0,0,0 },
  { 0,0,0,0,0,0,0,10,6,254,6,10,0,0,0,0 },
  { 0,0,0,0,0,0,16,48,95,129,95,48,16,0,0,0 },
  { 0,0,8,20,34,119,20,20,20,20,20,20,20,28,0,0 },
  { 0,0,0,0,0,8,12,250,129,250,12,8,0,0,0,0 },
  { 0,0,28,20,20,20,20,20,20,20,119,34,20,8,0,0 },
  { 0,0,8,20,34,119,20,20,20,28,0,28,20,28,0,0 },
  { 0,0,8,20,34,99,34,34,34,34,34,99,65,127,0,0 },
  { 0,0,8,20,62,99,34,34,34,34,34,99,65,127,0,0 },
  { 0,0,8,28,42,107,42,42,42,42,42,107,73,127,0,0 },
  { 0,8,20,42,119,34,99,34,34,34,34,34,34,62,0,0 },
  { 0,8,20,42,119,34,99,34,34,34,34,99,65,127,0,0 },
  { 0,0,0,0,0,0,8,108,122,65,122,108,8,0,0,0 },
  { 0,0,0,0,0,127,64,92,88,84,66,65,64,64,0,0 },
  { 0,0,0,0,0,1,1,65,33,21,13,29,1,127,0,0 },
  { 0,0,8,20,54,20,20,20,20,20,20,54,20,8,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,16,8,136,127,252,8,136,7,16,0,0,0,0,0,0,0,0 },
  { 0,0,36,46,53,36,36,36,36,36,36,172,116,36,0,0 },
  { 0,4,2,255,2,4,4,2,255,2,4,4,2,255,2,4 },
  { 0,0,0,0,0,0,0,36,68,255,68,36,0,0,0,0 },
  { 0,0,0,0,0,0,0,36,34,255,34,36,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,32,17,16,63,248,17,16,9,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,64,33,64,127,255,33,64,17,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,136,2,132,255,254,2,132,2,136,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,144,34,136,127,252,34,136,18,144,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,32,96,191,96,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,4,6,253,6,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,16,24,24,47,244,24,24,8,16,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,65,65,62,34,34,20,20,20,8,8,0,0 },
  { 0,0,0,0,24,36,36,32,32,32,32,36,36,24,0,0 },
  { 0,0,0,0,28,34,2,2,30,34,66,68,68,56,0,0 },
  { 0,0,0,0,126,2,2,2,126,2,2,2,2,126,0,0 },
  { 0,0,16,16,126,18,18,18,126,18,18,18,18,126,16,0 },
  { 0,0,0,0,0,0,0,29,34,69,73,81,34,92,0,0 },
  { 0,0,0,0,8,8,20,20,20,34,34,34,65,127,0,0 },
  { 0,0,0,0,127,65,34,34,34,20,20,20,8,8,0,0 },
  { 0,0,0,0,0,0,0,62,64,64,126,64,64,62,0,0 },
  { 0,0,0,0,0,8,8,62,72,72,126,72,72,62,8,0 },
  { 0,0,0,0,0,0,0,0,0,62,64,126,64,62,0,0 },
  { 0,0,0,0,0,0,0,124,2,2,126,2,2,124,0,0 },
  { 0,0,0,0,0,16,16,124,18,18,126,18,18,124,16,0 },
  { 0,0,0,0,0,0,0,0,0,124,2,126,2,124,0,0 },
  { 0,0,0,0,126,126,126,126,126,126,126,126,126,126,0,0 },
  { 0,0,0,0,127,34,34,34,34,34,34,34,34,34,0,0 },
  { 0,0,0,0,34,34,34,34,34,34,34,34,34,127,0,0 },
  { 0,0,0,0,126,66,32,16,8,8,16,32,66,126,0,0 },
  { 0,0,0,0,0,0,0,0,0,126,0,0,0,0,0,0 },
  { 0,0,0,0,127,0,8,8,8,127,8,8,8,0,0,0 },
  { 0,0,8,28,8,0,8,8,8,127,8,8,8,0,0,0 },
  { 0,0,0,0,2,4,4,8,8,16,16,32,32,64,0,0 },
  { 0,0,0,0,64,32,32,16,16,8,8,4,4,2,0,0 },
  { 0,0,0,0,0,0,8,42,28,8,28,42,8,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,36,36,24,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,60,60,24,0,0,0,0 },
  { 0,0,7,4,4,4,4,4,116,20,20,12,12,4,4,0 },
  { 0,0,103,20,100,20,100,4,116,20,20,12,12,4,4,0 },
  { 0,0,87,84,116,20,20,4,116,20,20,12,12,4,4,0 },
  { 0,0,0,0,0,0,0,54,72,72,54,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,54,73,73,54,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,64,64,64,64,64,64,126,0,0 },
  { 0,0,0,0,0,0,0,0,2,4,8,16,32,126,0,0 },
  { 0,0,0,0,0,0,0,0,2,20,8,20,36,126,0,0 },
  { 0,0,0,0,0,0,0,10,12,20,100,20,12,10,0,0 },
  { 0,0,0,0,24,24,24,24,24,24,24,24,24,24,0,0 },
  { 0,0,0,0,24,24,26,28,24,24,56,88,24,24,0,0 },
  { 0,0,0,0,36,36,36,36,36,36,36,36,36,36,0,0 },
  { 0,0,0,0,36,36,38,36,44,52,36,100,36,36,0,0 },
  { 0,0,0,0,0,0,8,8,20,20,34,34,65,65,0,0 },
  { 0,0,0,0,0,0,65,65,34,34,20,20,8,8,0,0 },
  { 0,0,0,0,0,0,60,66,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,0,0,66,66,66,66,66,66,66,60,0,0 },
  { 0,6,10,8,8,8,8,8,8,8,8,8,8,40,48,0 },
  { 0,10,21,20,20,20,20,20,20,20,20,20,20,84,104,0 },
  { 0,21,42,42,42,42,42,42,42,42,42,42,42,170,212,0 },
  { 0,6,10,8,8,8,28,42,42,28,8,8,8,40,48,0 },
  { 0,10,21,20,20,20,62,85,85,62,20,20,20,84,104,0 },
  { 0,21,42,42,42,126,171,171,171,126,42,42,42,170,212,0 },
  { 0,6,10,8,8,8,29,43,47,8,8,8,8,40,48,0 },
  { 0,6,10,8,8,29,43,47,42,28,8,8,8,40,48,0 },
  { 0,6,10,8,8,8,92,106,122,42,28,8,8,40,48,0 },
  { 0,0,0,0,0,0,24,24,0,0,0,102,102,0,0,0 },
  { 0,0,0,0,0,0,102,102,0,0,0,24,24,0,0,0 },
  { 0,0,0,0,0,0,24,24,0,0,0,24,24,0,0,0 },
  { 0,0,0,0,0,0,102,102,0,0,0,102,102,0,0,0 },
  { 0,0,0,0,0,0,24,24,0,126,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,6,6,0,120,0,6,6,0,0,0 },
  { 0,0,0,0,0,0,102,102,0,126,0,102,102,0,0,0 },
  { 0,0,0,0,0,24,24,0,50,76,0,24,24,0,0,0 },
  { 0,0,0,0,0,0,0,0,50,76,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,76,50,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,50,73,38,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,48,72,73,9,6,0,0,0,0,0 },
  { 0,0,0,0,0,16,8,8,8,16,16,16,8,0,0,0 },
  { 0,0,0,0,8,8,8,58,76,8,8,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,126,0,0,50,76,0,0,0 },
  { 0,0,0,0,0,0,0,50,76,0,0,126,0,0,0,0 },
  { 0,0,0,0,0,8,8,58,76,8,8,126,8,8,0,0 },
  { 0,0,0,0,50,76,0,0,126,0,0,126,0,0,0,0 },
  { 0,0,0,0,0,50,76,8,126,8,8,126,8,8,0,0 },
  { 0,0,0,8,8,58,76,8,126,8,8,126,8,8,0,0 },
  { 0,0,0,0,0,0,0,50,76,0,50,76,0,0,0,0 },
  { 0,0,0,0,0,8,8,58,76,8,58,76,8,8,0,0 },
  { 0,0,0,0,0,50,76,0,50,76,0,126,0,0,0,0 },
  { 0,0,0,0,0,50,76,0,50,76,0,50,76,0,0,0 },
  { 0,0,0,0,48,73,6,0,126,0,0,126,0,0,0,0 },
  { 0,0,0,0,0,0,66,60,0,0,60,66,0,0,0,0 },
  { 0,0,0,0,0,0,24,102,0,0,102,24,0,0,0,0 },
  { 0,0,0,0,0,0,0,24,102,0,0,126,0,0,0,0 },
  { 0,0,0,0,24,24,0,0,126,0,0,126,0,0,0,0 },
  { 0,0,0,24,24,0,126,0,0,126,0,24,24,0,0,0 },
  { 0,0,0,96,96,0,126,0,0,126,0,6,6,0,0,0 },
  { 0,0,0,6,6,0,126,0,0,126,0,96,96,0,0,0 },
  { 0,0,0,0,0,0,0,94,0,0,94,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,122,0,0,122,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,126,36,36,126,0,0,0,0,0 },
  { 0,0,0,24,36,36,24,0,126,0,0,126,0,0,0,0 },
  { 0,0,0,0,60,66,0,0,126,0,0,126,0,0,0,0 },
  { 0,0,0,24,36,66,0,0,126,0,0,126,0,0,0,0 },
  { 0,0,0,66,36,24,0,0,126,0,0,126,0,0,0,0 },
  { 0,0,8,62,28,20,0,0,126,0,0,126,0,0,0,0 },
  { 0,0,8,20,34,62,0,0,126,0,0,126,0,0,0,0 },
  { 0,0,18,20,118,84,116,0,0,126,0,0,126,0,0,0 },
  { 0,0,0,104,84,84,84,0,126,0,0,126,0,0,0,0 },
  { 0,48,72,8,16,16,0,16,0,126,0,0,126,0,0,0 },
  { 0,0,0,0,0,0,2,4,126,8,16,126,32,64,0,0 },
  { 0,0,0,0,0,0,0,126,0,126,0,126,0,0,0,0 },
  { 0,0,0,0,0,2,4,126,8,126,16,126,32,64,0,0 },
  { 0,0,0,0,0,126,0,126,0,126,0,126,0,0,0,0 },
  { 0,0,0,0,0,0,6,24,96,24,6,0,126,0,0,0 },
  { 0,0,0,0,0,0,96,24,6,24,96,0,126,0,0,0 },
  { 0,0,0,6,24,96,24,6,0,126,0,0,126,0,0,0 },
  { 0,0,0,96,24,6,24,96,0,126,0,0,126,0,0,0 },
  { 0,0,0,6,24,96,24,22,16,126,16,16,126,16,16,0 },
  { 0,0,0,96,24,6,24,104,8,126,8,8,126,8,8,0 },
  { 0,0,0,0,0,9,18,36,72,144,72,36,18,9,0,0 },
  { 0,0,0,0,0,144,72,36,18,9,18,36,72,144,0,0 },
  { 0,0,0,0,36,24,24,36,36,36,36,24,24,36,0,0 },
  { 0,0,0,0,8,8,74,60,8,8,60,74,8,8,0,0 },
  { 0,0,0,0,8,10,12,8,24,40,24,8,12,10,8,0 },
  { 0,0,0,0,16,80,48,16,24,20,24,16,48,80,16,0 },
  { 0,0,0,0,8,8,14,24,104,24,14,8,126,8,8,0 },
  { 0,0,0,0,16,16,112,24,22,24,112,16,126,16,16,0 },
  { 0,0,0,0,0,0,6,24,96,24,6,0,50,76,0,0 },
  { 0,0,0,0,0,0,96,24,6,24,96,0,50,76,0,0 },
  { 0,0,0,0,8,8,14,24,104,24,14,8,58,76,8,0 },
  { 0,0,0,0,16,16,112,24,22,24,112,16,50,92,16,0 },
  { 0,0,0,0,6,24,96,24,6,96,24,6,24,96,0,0 },
  { 0,0,0,0,96,24,6,24,96,6,24,96,24,6,0,0 },
  { 0,0,8,8,14,24,104,24,14,104,24,14,24,104,8,0 },
  { 0,0,8,8,104,24,14,24,104,14,24,104,24,14,8,0 },
  { 0,0,0,0,2,2,4,24,96,24,4,2,2,0,0,0 },
  { 0,0,0,0,64,64,32,24,6,24,32,64,64,0,0,0 },
  { 0,0,0,0,2,2,4,24,96,24,4,2,0,126,0,0 },
  { 0,0,0,0,64,64,32,24,6,24,32,64,0,126,0,0 },
  { 0,0,0,0,2,2,4,24,96,24,4,2,50,76,0,0 },
  { 0,0,0,0,64,64,32,24,6,24,32,64,50,76,0,0 },
  { 0,0,0,0,2,18,20,24,112,24,20,18,2,0,0,0 },
  { 0,0,0,0,64,72,40,24,14,24,40,72,64,0,0,0 },
  { 0,0,0,0,0,0,62,64,64,64,64,62,0,0,0,0 },
  { 0,0,0,0,0,0,124,2,2,2,2,124,0,0,0,0 },
  { 0,0,0,0,8,8,62,72,72,72,72,62,8,8,0,0 },
  { 0,0,0,0,16,16,124,18,18,18,18,124,16,16,0,0 },
  { 0,0,0,0,0,0,62,64,64,64,64,62,0,126,0,0 },
  { 0,0,0,0,0,0,124,2,2,2,2,124,0,126,0,0 },
  { 0,0,0,0,8,8,62,72,72,72,72,62,8,126,8,0 },
  { 0,0,0,0,16,16,124,18,18,18,18,124,16,126,16,0 },
  { 0,0,0,0,0,0,62,64,64,64,64,62,8,126,8,0 },
  { 0,0,0,0,0,0,124,2,2,2,2,124,16,126,16,0 },
  { 0,0,0,0,66,66,66,74,82,126,82,74,66,60,0,0 },
  { 0,0,0,0,66,66,66,66,66,90,90,66,66,60,0,0 },
  { 0,0,0,0,66,66,66,82,82,122,82,82,66,60,0,0 },
  { 0,0,0,0,0,0,126,64,64,64,64,126,0,0,0,0 },
  { 0,0,0,0,0,0,126,2,2,2,2,126,0,0,0,0 },
  { 0,0,0,0,0,0,126,64,64,64,64,126,0,126,0,0 },
  { 0,0,0,0,0,0,126,2,2,2,2,126,0,126,0,0 },
  { 0,0,0,0,0,0,126,66,66,66,66,66,0,0,0,0 },
  { 0,0,0,0,0,0,66,66,66,66,66,126,0,0,0,0 },
  { 0,0,0,0,0,0,28,42,73,127,73,42,28,0,0,0 },
  { 0,0,0,0,0,0,28,34,65,127,65,34,28,0,0,0 },
  { 0,0,0,0,0,0,28,34,85,73,85,34,28,0,0,0 },
  { 0,0,0,0,0,0,28,34,69,73,81,34,28,0,0,0 },
  { 0,0,0,0,0,0,28,34,65,73,65,34,28,0,0,0 },
  { 0,0,0,0,0,0,28,34,73,85,73,34,28,0,0,0 },
  { 0,0,0,0,0,0,28,34,73,93,73,34,28,0,0,0 },
  { 0,0,0,0,0,0,28,34,93,65,93,34,28,0,0,0 },
  { 0,0,0,0,0,0,28,34,65,93,65,34,28,0,0,0 },
  { 0,0,0,0,0,0,127,73,73,127,73,73,127,0,0,0 },
  { 0,0,0,0,0,0,127,65,65,127,65,65,127,0,0,0 },
  { 0,0,0,0,0,0,127,99,85,73,85,99,127,0,0,0 },
  { 0,0,0,0,0,0,127,65,65,73,65,65,127,0,0,0 },
  { 0,0,0,0,0,0,64,64,64,126,64,64,64,0,0,0 },
  { 0,0,0,0,0,0,2,2,2,126,2,2,2,0,0,0 },
  { 0,0,0,0,0,0,127,8,8,8,8,8,8,0,0,0 },
  { 0,0,0,0,0,0,8,8,8,8,8,8,127,0,0,0 },
  { 0,0,0,32,32,32,32,32,60,32,32,32,32,32,0,0 },
  { 0,0,0,32,32,32,32,60,32,60,32,32,32,32,0,0 },
  { 0,0,0,64,64,64,64,126,64,126,64,64,64,64,0,0 },
  { 0,0,0,80,80,80,80,80,94,80,80,80,80,80,0,0 },
  { 0,0,0,84,84,84,84,84,87,84,84,84,84,84,0,0 },
  { 0,0,0,80,80,80,80,94,80,94,80,80,80,80,0,0 },
  { 0,0,0,64,64,72,72,72,126,72,72,72,64,64,0,0 },
  { 0,0,0,64,72,72,72,126,72,126,72,72,72,64,0,0 },
  { 0,0,0,80,80,84,84,84,94,84,84,84,80,80,0,0 },
  { 0,0,0,80,84,84,84,94,84,94,84,84,84,80,0,0 },
  { 0,0,0,0,12,2,4,24,96,24,4,2,12,0,0,0 },
  { 0,0,0,0,48,64,32,24,6,24,32,64,48,0,0,0 },
  { 0,0,0,0,0,0,0,6,26,98,26,6,0,0,0,0 },
  { 0,0,0,0,0,0,0,96,88,70,88,96,0,0,0,0 },
  { 0,0,0,0,0,0,0,6,26,98,26,6,0,126,0,0 },
  { 0,0,0,0,0,0,0,96,88,70,88,96,0,126,0,0 },
  { 0,0,0,0,0,0,0,0,34,95,34,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,34,125,34,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,125,2,0,0,0,0,0 },
  { 0,0,0,0,0,8,8,0,99,0,8,8,0,0,0,0 },
  { 0,0,0,0,62,8,8,8,8,8,8,8,8,8,0,0 },
  { 0,0,0,0,0,0,0,34,34,20,20,8,0,62,0,0 },
  { 0,0,0,0,0,62,0,8,20,20,34,34,0,0,0,0 },
  { 0,0,0,0,0,62,0,34,34,20,20,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,64,64,64,120,72,72,126,0,0 },
  { 0,0,0,0,0,0,0,0,2,6,10,18,34,126,0,0 },
  { 0,0,0,0,8,20,20,20,34,34,34,65,65,65,0,0 },
  { 0,0,0,0,65,65,65,34,34,34,20,20,20,8,0,0 },
  { 0,0,0,0,60,66,66,66,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,66,66,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,0,0,0,0,8,20,34,20,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,24,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,8,62,28,20,0,0,0,0,0 },
  { 0,0,0,0,0,8,34,20,62,20,34,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,34,54,42,54,34,0,0,0 },
  { 0,0,0,0,0,0,0,0,34,52,40,52,34,0,0,0 },
  { 0,0,0,0,0,0,0,0,34,22,10,22,34,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,16,8,20,34,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,4,8,20,34,0,0,0 },
  { 0,0,0,0,0,0,0,76,50,0,0,126,0,0,0,0 },
  { 0,0,0,0,0,0,65,34,34,20,20,20,8,0,0,0 },
  { 0,0,0,0,0,0,8,20,20,20,34,34,65,0,0,0 },
  { 0,0,0,0,0,0,62,64,94,80,80,94,64,62,0,0 },
  { 0,0,0,0,0,0,124,2,122,10,10,122,2,124,0,0 },
  { 0,0,0,0,0,0,0,62,65,93,85,85,85,0,0,0 },
  { 0,0,0,0,0,0,0,85,85,85,93,65,62,0,0,0 },
  { 0,0,0,0,8,8,8,28,42,42,42,42,42,42,0,0 },
  { 0,0,0,0,36,36,36,36,126,36,36,126,36,36,0,0 },
  { 0,0,0,0,0,2,4,8,16,34,16,8,4,2,0,0 },
  { 0,0,0,0,0,64,32,16,8,68,8,16,32,64,0,0 },
  { 0,0,0,0,0,0,0,21,42,84,42,21,0,0,0,0 },
  { 0,0,0,0,0,0,0,84,42,21,42,84,0,0,0,0 },
  { 0,6,24,96,24,6,0,126,0,96,24,6,24,96,0,0 },
  { 0,96,24,6,24,96,0,126,0,6,24,96,24,6,0,0 },
  { 0,0,0,0,0,126,0,6,24,96,24,6,0,0,0,0 },
  { 0,0,0,0,0,126,0,96,24,6,24,96,0,0,0,0 },
  { 0,0,0,0,126,2,2,4,24,96,24,4,2,2,0,0 },
  { 0,0,0,0,126,64,64,32,24,6,24,32,64,64,0,0 },
  { 0,0,0,8,10,10,12,24,104,24,12,10,10,126,8,0 },
  { 0,0,0,8,72,72,40,24,14,24,40,72,72,126,8,0 },
  { 0,0,0,8,8,8,126,72,72,72,72,126,8,126,8,0 },
  { 0,0,0,8,8,8,126,10,10,10,10,126,8,126,8,0 },
  { 0,0,0,0,0,0,126,64,64,64,64,126,8,126,8,0 },
  { 0,0,0,0,0,0,126,2,2,2,2,126,8,126,8,0 },
  { 0,0,0,0,0,6,24,96,24,6,8,58,76,8,8,0 },
  { 0,0,0,0,0,96,24,6,24,96,8,58,76,8,8,0 },
  { 0,0,0,2,2,4,24,96,24,4,10,58,76,8,8,0 },
  { 0,0,64,64,32,24,6,24,32,64,72,58,76,8,8,0 },
  { 0,0,0,0,0,8,8,14,26,106,26,14,8,8,0,0 },
  { 0,0,0,0,0,8,8,104,88,78,88,104,8,8,0,0 },
  { 0,0,0,0,0,8,8,14,26,106,26,14,8,126,8,0 },
  { 0,0,0,0,0,8,8,104,88,78,88,104,8,126,8,0 },
  { 0,0,0,0,24,24,0,0,24,24,0,0,24,24,0,0 },
  { 0,0,0,0,0,0,0,0,219,219,0,0,0,0,0,0 },
  { 0,0,0,0,3,3,0,0,24,24,0,0,192,192,0,0 },
  { 0,0,0,0,192,192,0,0,24,24,0,0,3,3,0,0 },
  { 0,0,0,0,0,0,7,240,8,0,16,0,16,0,127,240,16,0,16,0,8,0,7,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,240,8,0,16,0,16,16,31,240,16,16,16,0,8,0,7,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,62,64,66,126,66,64,62,0,0,0,0 },
  { 0,0,0,0,0,0,7,240,8,0,16,0,16,0,31,240,16,0,16,0,8,0,7,240,0,0,0,0,0,0,0,0 },
  { 0,0,31,240,0,0,7,240,8,0,16,0,16,0,31,240,16,0,16,0,8,0,7,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,126,0,62,64,64,126,64,64,62,0,0,0,0 },
  { 0,0,0,0,0,0,0,62,64,64,126,64,64,62,0,126 },
  { 0,0,0,0,0,0,31,192,32,0,64,0,127,192,64,0,127,192,64,0,32,0,31,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,128,0,64,0,32,0,32,63,248,0,32,0,32,0,64,63,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,128,0,64,0,32,32,32,63,224,32,32,0,32,0,64,63,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,124,2,66,126,66,2,124,0,0,0,0 },
  { 0,0,63,224,0,0,63,128,0,64,0,32,0,32,63,224,0,32,0,32,0,64,63,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,126,0,124,2,2,126,2,2,124,0,0,0,0 },
  { 0,0,0,0,0,0,15,248,8,0,8,0,8,0,15,248,8,0,8,0,8,0,15,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,29,34,69,73,81,34,92,0,0,0 },
  { 0,0,0,0,0,0,0,0,144,88,52,18,0,0,0,0 },
  { 0,0,0,0,0,0,24,36,66,66,66,66,66,126,0,0 },
  { 0,0,0,0,8,20,34,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,34,20,8,0,0 },
  { 0,0,0,0,62,0,8,20,34,0,0,0,0,0,0,0 },
  { 0,0,0,0,62,0,62,0,8,20,34,0,0,0,0,0 },
  { 0,0,0,16,8,4,8,16,8,4,8,16,8,4,0,0 },
  { 0,0,30,16,16,16,16,16,16,16,16,16,16,16,0,0 },
  { 0,0,120,8,8,8,8,8,8,8,8,8,8,8,0,0 },
  { 0,0,16,16,16,16,16,16,16,16,16,16,16,30,0,0 },
  { 0,0,8,8,8,8,8,8,8,8,8,8,8,120,0,0 },
  { 0,0,0,0,0,0,0,0,7,8,8,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,112,8,8,8,0,0,0,0 },
  { 0,0,0,0,0,8,8,8,7,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,8,8,8,112,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,126,64,64,64,0,0 },
  { 0,0,0,0,0,0,65,62,34,34,34,62,65,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,34,65,65,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,34,65,127,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,34,65,34,20,8,0,0 },
  { 0,0,0,0,0,0,0,28,34,65,65,81,34,92,0,0 },
  { 0,0,0,8,8,8,28,42,127,42,28,8,8,8,0,0 },
  { 0,0,0,0,36,36,255,36,36,255,36,36,0,0,0,0 },
  { 0,0,0,0,0,34,85,62,20,62,85,34,0,0,0,0 },
  { 0,0,0,0,0,0,0,64,64,64,126,0,0,0,0,0 },
  { 0,40,40,40,40,56,84,146,155,130,68,56,40,40,40,0 },
  { 0,0,0,0,126,36,36,36,24,24,36,36,60,126,0,0 },
  { 0,120,64,64,64,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,30,2,2,2,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,64,64,64,120,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,2,2,2,30,0 },
  { 0,0,0,0,6,10,8,8,8,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,8,8,8,8,40,48,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,60,66,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,66,60,0,0,0,0,0,0 },
  { 0,0,0,0,119,8,20,34,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,103,16,8,7,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,252,170,145,170,252,0,0,0,0,0 },
  { 0,0,0,0,0,0,127,85,73,85,127,0,0,0,0,0 },
  { 0,0,0,0,0,126,126,126,0,60,0,0,0,0,0,0 },
  { 0,0,8,8,16,16,32,32,64,32,32,16,16,8,8,0 },
  { 0,0,16,16,8,8,4,4,2,4,4,8,8,16,16,0 },
  { 0,0,0,0,0,0,63,85,137,85,63,0,0,0,0,0 },
  { 0,0,0,8,28,38,99,97,97,99,38,28,8,0,0,0 },
  { 0,0,0,0,0,0,8,24,37,102,156,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,36,47,56,96,96,0,0 },
  { 0,0,0,0,0,0,0,24,0,126,0,24,0,0,0,0 },
  { 0,0,0,0,9,27,18,18,36,36,36,72,72,120,0,0 },
  { 0,0,0,0,0,32,32,112,170,191,170,112,32,32,0,0 },
  { 0,0,0,0,0,0,96,88,70,127,70,88,96,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,96,88,70,127,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,66,66,66,126,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,66,36,24,0,0,0 },
  { 0,0,0,0,127,8,8,8,8,8,8,8,8,127,0,0 },
  { 0,0,0,0,62,34,34,34,34,34,34,34,34,62,0,0 },
  { 0,0,0,127,65,65,65,127,65,65,127,65,65,127,0,0 },
  { 0,0,0,127,65,73,73,65,127,65,73,73,65,127,0,0 },
  { 0,0,0,127,65,73,85,99,65,99,85,73,65,127,0,0 },
  { 0,0,0,127,65,65,65,73,85,85,73,65,65,127,0,0 },
  { 0,0,0,127,65,65,93,99,65,65,99,93,65,127,0,0 },
  { 0,0,0,8,8,28,42,73,73,73,42,28,8,8,0,0 },
  { 0,0,0,0,0,28,34,73,85,73,34,28,0,0,0,0 },
  { 0,0,0,0,2,4,4,8,8,255,16,32,32,64,0,0 },
  { 0,0,0,0,64,32,32,16,16,255,8,4,4,2,0,0 },
  { 0,0,0,127,65,67,69,69,73,81,81,97,65,127,0,0 },
  { 0,0,0,127,65,97,81,81,73,69,69,67,65,127,0,0 },
  { 0,0,0,127,65,65,71,89,97,89,71,65,65,127,0,0 },
  { 0,0,0,127,65,65,113,77,67,77,113,65,65,127,0,0 },
  { 0,0,0,8,8,8,8,40,127,40,8,8,8,8,0,0 },
  { 0,0,0,8,8,8,8,10,127,10,8,8,8,8,0,0 },
  { 0,0,0,127,65,65,73,81,127,81,73,65,65,127,0,0 },
  { 0,0,0,127,65,65,73,69,127,69,73,65,65,127,0,0 },
  { 0,0,0,0,0,0,0,92,34,81,73,69,34,29,0,0 },
  { 0,0,0,0,8,8,8,8,8,8,8,127,0,127,0,0 },
  { 0,0,0,0,8,8,8,28,28,42,42,62,8,8,0,0 },
  { 0,0,127,65,65,65,65,99,99,85,85,73,65,127,0,0 },
  { 0,0,127,65,65,73,73,85,85,99,99,127,65,127,0,0 },
  { 0,0,0,0,8,8,8,28,42,42,28,8,8,127,0,0 },
  { 0,0,0,0,8,28,42,8,127,8,8,8,8,8,0,0 },
  { 0,0,127,73,93,107,73,73,73,73,73,73,73,127,0,0 },
  { 0,0,0,0,62,0,62,8,8,8,8,8,8,8,0,0 },
  { 0,0,0,0,8,8,62,42,42,28,28,8,8,8,0,0 },
  { 0,0,127,65,73,85,85,99,99,65,65,65,65,127,0,0 },
  { 0,0,127,65,65,127,99,99,85,85,73,73,65,127,0,0 },
  { 0,0,0,0,127,8,8,28,42,42,28,8,8,8,0,0 },
  { 0,0,0,8,8,8,8,8,8,127,8,42,28,8,0,0 },
  { 0,0,127,73,73,73,73,73,73,73,107,93,73,127,0,0 },
  { 0,0,0,0,8,8,8,0,0,0,0,0,0,62,0,0 },
  { 0,0,0,0,0,8,8,20,20,34,34,62,0,62,0,0 },
  { 0,0,0,0,0,8,20,34,65,34,20,8,0,62,0,0 },
  { 0,0,0,0,0,0,0,24,36,36,24,0,0,62,0,0 },
  { 0,0,0,0,0,28,34,65,65,65,34,28,0,127,0,0 },
  { 0,0,0,0,28,34,73,85,73,65,65,65,65,65,0,0 },
  { 0,0,127,65,73,73,73,65,65,65,65,65,65,127,0,0 },
  { 0,0,0,0,28,34,73,127,93,85,34,28,0,0,0,0 },
  { 0,0,127,65,65,73,73,65,65,73,73,65,65,127,0,0 },
  { 0,36,36,0,127,8,8,8,8,8,8,8,8,8,0,0 },
  { 0,36,36,0,0,62,34,34,20,20,8,8,0,0,0,0 },
  { 0,36,36,0,0,8,62,28,20,0,0,0,0,0,0,0 },
  { 0,36,36,0,0,0,0,24,36,36,24,0,0,0,0,0 },
  { 0,36,36,0,0,0,0,28,34,65,65,65,34,28,0,0 },
  { 0,0,0,0,73,73,73,73,73,73,73,42,28,8,0,0 },
  { 0,0,0,8,8,31,40,72,72,72,40,31,8,8,0,0 },
  { 0,36,36,0,0,0,0,50,76,0,0,0,0,0,0,0 },
  { 0,36,36,0,64,32,16,8,4,2,4,8,16,32,64,0 },
  { 0,0,0,0,60,0,0,24,8,8,16,0,0,0,0,0 },
  { 0,0,0,0,0,62,34,34,20,20,57,78,0,0,0,0 },
  { 0,0,0,0,28,34,34,34,51,110,34,34,34,28,0,0 },
  { 0,0,0,0,8,8,8,8,8,58,76,8,8,8,0,0 },
  { 0,0,0,0,24,24,0,0,24,8,8,16,0,62,0,0 },
  { 0,0,127,65,67,69,127,73,127,81,97,65,65,127,0,0 },
  { 0,0,127,65,73,85,85,69,73,73,65,73,65,127,0,0 },
  { 0,0,0,0,50,76,0,34,34,20,20,8,0,0,0,0 },
  { 0,0,0,0,0,50,76,0,8,20,20,34,34,0,0,0 },
  { 0,0,0,0,0,0,0,24,8,8,8,8,8,6,0,0 },
  { 0,0,0,0,0,0,60,66,66,66,66,66,98,92,64,64 },
  { 0,0,0,0,0,0,20,34,73,73,73,73,73,54,0,0 },
  { 0,0,0,0,0,50,74,68,68,68,74,50,0,126,0,0 },
  { 0,0,0,0,0,62,64,64,124,64,64,62,0,126,0,0 },
  { 0,0,0,0,0,24,8,8,8,8,8,6,0,30,0,0 },
  { 0,0,0,0,0,34,65,73,73,73,73,54,0,127,0,0 },
  { 0,0,0,0,0,0,50,74,68,68,68,68,74,50,0,0 },
  { 0,0,0,0,0,0,0,2,0,4,0,8,0,16,1,252,0,64,0,128,65,0,34,0,20,0,8,0,0,0,0,0 },
  { 0,0,0,0,10,0,12,0,8,0,24,0,40,0,24,0,8,0,12,0,10,0,12,0,79,254,80,0,96,0,120,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,60,8,32,8,32,15,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,192,4,32,8,16,16,8,16,8,31,248,4,32,4,32,4,32,28,56,0,0,0,0 },
  { 0,0,8,8,8,8,8,28,62,28,8,8,8,8,0,0 },
  { 0,0,0,56,4,60,68,68,58,0,130,68,40,16,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,56,0,4,0,60,0,68,0,68,0,58,84,0,0,127,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,56,112,4,8,60,120,68,136,68,136,58,116,0,0,126,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,4,32,8,19,144,0,64,115,220,4,64,20,80,35,168,64,4,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,63,240,33,8,34,4,34,4,34,4,34,4,33,8,63,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,0,1,0,29,112,17,16,17,16,17,16,17,16,17,16,17,16,29,112,1,0,1,0 },
  { 0,0,1,0,2,128,4,64,8,32,18,16,3,8,126,132,64,66,126,132,3,8,18,16,8,32,4,64,2,128,1,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,48,0,232,1,48,2,32,4,0,120,254,0,0,0,0 },
  { 0,0,1,0,1,0,35,136,29,112,25,48,21,80,35,136,35,136,21,80,25,48,29,112,35,136,1,0,1,0,0,0 },
  { 0,0,0,0,15,128,48,96,64,16,64,16,128,8,128,8,240,120,136,136,136,136,69,16,69,16,50,96,15,128,0,0 },
  { 0,0,0,0,15,128,48,96,64,16,127,240,160,40,144,72,144,72,136,136,136,136,69,16,69,16,50,96,15,128,0,0 },
  { 0,0,0,0,1,128,124,96,72,16,80,16,104,8,68,8,2,8,129,8,128,136,64,80,64,16,48,96,15,128,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,8,16,16,8,124,8,40,8,16,8,56,28,68,34,68,34,56,28,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,60,60,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,252,2,16,4,32,4,32,4,32,4,32,4,32,4,32,8,64,63,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,31,240,2,128,4,64,8,32,16,16,8,32,4,64,2,128,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,0,2,128,4,64,8,32,16,16,8,32,4,64,2,128,31,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,31,240,2,128,4,64,8,32,31,240,8,32,4,64,2,128,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,0,2,128,4,64,8,32,31,240,8,32,4,64,2,128,31,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,127,252,0,0,115,156,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,224,8,16,16,8,32,4,64,2,32,4,16,8,8,16,7,224,0,0,0,0 },
  { 0,0,127,65,65,65,65,65,65,65,65,65,65,127,0,0 },
  { 0,0,0,0,0,0,0,0,124,120,112,112,96,96,64,0 },
  { 0,0,109,176,64,16,79,252,72,4,74,4,78,4,75,228,80,36,75,228,78,4,122,4,8,4,15,252,0,0,0,0 },
  { 0,0,127,240,64,16,78,220,72,4,73,4,73,132,95,64,80,36,95,68,73,128,121,4,8,4,12,220,0,0,0,0 },
  { 0,0,1,224,3,32,5,32,15,32,8,32,56,56,72,36,136,34,136,34,143,226,128,2,64,4,63,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,31,240,32,40,66,68,68,148,73,36,82,68,68,132,40,8,31,240,0,0,0,0 },
  { 0,14,24,48,48,48,48,48,48,48,48,48,48,48,48,48 },
  { 48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48 },
  { 48,48,48,48,48,48,48,48,48,48,48,48,48,48,24,14 },
  { 0,112,24,12,12,12,12,12,12,12,12,12,12,12,12,12 },
  { 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12 },
  { 12,12,12,12,12,12,12,12,12,12,12,12,12,12,24,112 },
  { 0,62,48,48,48,48,48,48,48,48,48,48,48,48,48,48 },
  { 48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48 },
  { 48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,62 },
  { 0,124,12,12,12,12,12,12,12,12,12,12,12,12,12,12 },
  { 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12 },
  { 12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,124 },
  { 0,6,12,24,24,24,24,24,24,24,24,24,24,24,24,24 },
  { 24,24,24,24,24,24,16,32,64,32,16,24,24,24,24,24 },
  { 24,24,24,24,24,24,24,24,24,24,24,24,24,24,12,6 },
  { 24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24 },
  { 0,96,48,24,24,24,24,24,24,24,24,24,24,24,24,24 },
  { 24,24,24,24,24,24,8,4,2,4,8,24,24,24,24,24 },
  { 24,24,24,24,24,24,24,24,24,24,24,24,24,24,48,96 },
  { 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0 },
  { 0,6,12,24,24,24,24,24,24,24,24,24,24,24,48,96 },
  { 0,96,48,24,24,24,24,24,24,24,24,24,24,24,12,6 },
  { 0,0,0,0,0,0,0,0,127,254,48,14,48,6,24,2,24,0,12,0,12,0,6,0,6,0,3,0,3,0,1,128 },
  { 1,128,3,0,3,0,6,0,6,0,12,0,12,0,24,0,24,2,48,6,48,14,127,254,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,127,254,64,2,64,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,2,64,2,127,254 },
  { 0,0,0,0,0,0,0,0,0,0,64,2,64,2,127,254,0,0,127,254,64,2,64,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,1,1,2,2,98,36,20,20,8,0,0 },
  { 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128 },
  { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
  { 255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255 },
  { 0,0,0,0,62,32,32,32,32,32,32,32,32,32,0,0 },
  { 0,0,0,0,32,32,32,32,32,32,32,32,32,62,0,0 },
  { 0,0,1,0,1,0,3,128,13,96,17,16,17,16,33,8,33,8,17,16,17,16,13,96,3,128,1,0,1,0,0,0 },
  { 0,0,63,248,1,0,3,128,13,96,17,16,17,16,33,8,33,8,17,16,17,16,13,96,3,128,1,0,1,0,0,0 },
  { 0,0,1,0,1,0,3,128,13,96,17,16,17,16,33,8,33,8,17,16,17,16,13,96,3,128,1,0,63,248,0,0 },
  { 0,0,0,0,1,0,1,0,3,128,5,64,5,64,9,32,9,32,17,16,17,16,33,8,63,248,1,0,1,0,0,0 },
  { 0,0,0,0,63,248,1,0,3,128,5,64,5,64,9,32,9,32,17,16,17,16,33,8,63,248,1,0,1,0,0,0 },
  { 0,0,0,0,1,0,1,0,3,128,5,64,5,64,9,32,9,32,17,16,17,16,33,8,63,248,1,0,63,248,0,0 },
  { 0,0,1,0,1,0,1,0,1,0,1,0,29,0,35,0,1,136,1,112,1,0,1,0,1,0,1,0,1,0,0,0 },
  { 0,0,63,248,1,0,1,0,1,0,1,0,29,0,35,0,1,136,1,112,1,0,1,0,1,0,1,0,1,0,0,0 },
  { 0,0,1,0,1,0,1,0,1,0,1,0,29,0,35,0,1,136,1,112,1,0,1,0,1,0,1,0,63,248,0,0 },
  { 0,0,63,248,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0 },
  { 0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,63,248,0,0 },
  { 0,63,1,1,1,1,1,1,1,1,1,1,1,1,1,0 },
  { 0,1,1,1,1,1,1,1,1,1,1,1,1,1,63,0 },
  { 0,0,0,128,121,60,66,4,68,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,127,252,0,0,0,0 },
  { 0,0,0,0,0,62,0,34,0,34,0,34,4,34,12,66,23,130,32,2,64,4,32,8,23,240,12,0,4,0,0,0 },
  { 0,0,0,0,0,0,16,56,124,254,0,254,254,254,0,0 },
  { 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,0,130,68,56,0,0,0,0,0 },
  { 0,0,0,0,0,0,254,0,130,68,56,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,130,68,56,0,254,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,255,254,0,0,130,130,68,68,56,56,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,130,68,68,56,56,0,0,255,254,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,130,68,68,56,56,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,2,0,2,0,2,0,2,0,2,127,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,64,2,64,2,64,2,64,2,64,2,127,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,65,2,65,2,65,2,65,2,65,2,127,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,8,8,8,8,8,127,0,28,0,8 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,31,248,16,8,16,8,255,255,16,8,16,8,31,248,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,224,56,28,64,2,128,1,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,128,1,64,2,56,28,7,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,128,60,120,64,4,128,2,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,128,2,64,4,60,120,2,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,240,16,8,32,4,64,2,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,2,32,4,16,8,15,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,127,192,64,32,64,32,64,16,64,16,64,8,64,8,64,4,127,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,128,1,64,2,32,4,16,9,200,10,40,10,40,10,40,9,200,4,16,2,32,1,64,0,128 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,252,16,8,16,8,32,16,32,16,127,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,24,0,36,0,66,0,127,252,0,132,0,72,0,48,0,0,0,0,0,0,0,0 },
  { 0,0,36,0,36,0,34,0,34,6,169,24,113,160,33,192,3,224,1,192,2,160,4,16,8,8,16,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,36,106,42,42,42,36,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,32,128,48,192,56,224,60,240,62,248,60,240,56,224,48,192,32,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,8,6,24,14,56,30,120,62,248,30,120,14,56,6,24,2,8,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,3,128,7,192,15,224,31,240,0,0,1,0,3,128,7,192,15,224,31,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,240,15,224,7,192,3,128,1,0,0,0,31,240,15,224,7,192,3,128,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,65,4,97,132,113,196,121,228,125,244,121,228,113,196,97,132,65,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,65,4,67,12,71,28,79,60,95,124,79,60,71,28,67,12,65,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,72,24,72,28,72,30,72,31,72,30,72,28,72,24,72,16,72,0,0,0,0 },
  { 0,0,1,0,25,48,55,216,40,40,17,16,33,8,33,8,33,8,34,8,36,8,16,16,8,32,15,224,28,112,0,0 },
  { 0,0,3,0,3,0,7,216,8,56,17,16,33,8,33,8,33,8,32,8,32,8,16,16,8,32,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,7,192,8,32,16,16,36,8,34,8,33,8,32,8,32,8,16,16,8,32,7,192,0,0,0,0 },
  { 0,0,127,252,16,16,16,16,18,144,13,96,6,192,2,128,6,192,8,32,17,16,26,176,21,80,127,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,64,0,192,1,192,3,192,7,192,15,192,7,192,3,192,1,192,0,192,0,64,0,0,0,0 },
  { 0,0,0,0,0,0,8,0,12,0,14,0,15,0,15,128,15,192,15,128,15,0,14,0,12,0,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,0,3,128,7,192,15,224,31,240,63,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,63,248,31,240,15,224,7,192,3,128,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,248,31,248,31,248,31,248,31,248,31,248,31,248,31,248,31,248,31,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,15,240,31,248,31,248,31,248,31,248,31,248,31,248,15,240,7,224,0,0,0,0 },
  { 0,0,127,254,97,142,125,246,97,198,111,246,97,142,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,246,97,198,111,246,97,142,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,97,142,125,246,97,198,111,246,97,142,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,246,97,198,111,246,97,142,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,97,142,125,246,97,198,111,246,97,142,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,74,80,106,80,90,80,73,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,57,146,66,82,50,94,10,82,113,146,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,59,164,65,36,49,24,9,36,113,36,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,123,164,65,36,121,24,65,36,121,36,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,121,190,66,72,122,72,66,72,121,136,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,122,76,66,82,123,82,66,214,122,78,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,49,164,74,40,122,48,74,40,73,164,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,115,208,74,16,115,208,74,16,115,222,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,30,56,17,64,30,48,17,8,30,112,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,34,248,34,32,62,32,34,32,34,32,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,32,248,32,128,32,248,32,128,62,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,34,248,34,32,34,32,20,32,8,32,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,62,248,32,128,62,248,32,128,32,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,30,240,32,136,32,240,32,144,30,136,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,30,112,32,136,28,136,2,136,60,112,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,30,248,32,32,28,32,2,32,60,248,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,57,28,37,16,37,28,37,16,57,220,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,113,136,74,24,74,8,74,8,113,156,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,113,152,74,4,74,8,74,16,113,156,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,113,152,74,4,74,24,74,4,113,152,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,113,132,74,12,74,20,74,28,113,132,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,73,146,106,84,106,88,91,212,74,82,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,52,82,66,154,49,22,9,18,113,18,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,123,184,65,36,121,56,65,36,121,56,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,51,36,68,180,71,172,68,164,52,164,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,62,136,32,216,62,168,32,136,62,136,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,58,92,66,82,50,92,10,82,113,156,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,121,206,66,16,121,144,64,80,123,142,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,30,112,16,128,30,96,16,16,16,224,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,14,112,16,128,22,96,18,16,14,224,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,28,112,18,128,28,96,20,16,18,224,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,18,112,18,128,18,96,18,16,12,224,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,59,128,66,64,51,128,10,0,114,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,115,208,74,16,75,208,74,16,115,222,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,20,24,16,48,92,18,18,18,18,28,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,66,126,0,0 },
  { 0,0,0,0,72,104,88,72,0,16,16,16,30,0,0,0 },
  { 0,0,0,0,0,1,10,21,42,84,40,64,0,0,0,0 },
  { 0,0,0,60,66,66,64,32,16,8,8,0,8,8,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,134,125,246,97,238,111,222,97,222,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,206,125,182,97,206,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,206,125,182,97,198,111,246,97,206,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,134,125,182,97,134,111,182,97,182,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,142,125,182,97,142,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,198,125,190,97,190,111,190,97,198,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,142,125,182,97,182,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,134,125,190,97,142,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,134,125,190,97,142,111,190,97,190,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,206,125,182,113,182,125,182,99,206,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,238,125,206,113,238,125,238,99,198,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,134,125,246,113,134,125,190,99,134,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,142,125,246,113,198,125,246,99,142,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,182,125,182,113,134,125,246,99,246,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,134,125,190,113,134,125,246,99,134,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,206,125,190,113,142,125,182,99,206,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,134,125,246,113,238,125,222,99,222,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,206,125,182,113,206,125,182,99,206,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,206,125,182,113,198,125,246,99,206,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,134,125,182,113,134,125,182,99,182,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,142,125,182,113,142,125,182,99,142,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,198,125,190,113,190,125,190,99,198,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,142,125,182,113,182,125,182,99,142,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,134,125,190,113,142,125,190,99,134,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,99,134,125,190,113,142,125,190,99,190,127,254,0,0 },
  { 0,0,0,0,14,10,10,10,8,8,40,40,40,56,0,0 },
  { 0,0,0,0,2,2,2,2,2,62,34,34,34,34,0,0 },
  { 0,0,0,0,34,34,34,34,34,62,8,8,8,8,0,0 },
  { 0,0,0,0,8,8,8,8,8,62,34,34,34,34,0,0 },
  { 0,0,0,0,62,42,42,42,8,8,42,42,42,62,0,0 },
  { 0,0,0,0,34,54,42,54,34,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,14,110,110,96,96,110,110,14,0,0,0 },
  { 0,0,0,0,3,3,3,27,24,24,216,192,192,192,0,0 },
  { 0,0,0,0,7,87,87,80,80,80,80,80,80,80,0,0 },
  { 0,0,0,0,0,109,109,109,109,109,109,109,109,109,0,0 },
  { 0,0,0,0,160,160,80,40,40,20,20,10,5,5,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,109,142,109,182,97,142,125,182,125,142,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,109,198,109,190,97,190,125,190,125,198,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,109,142,109,182,97,182,125,182,125,142,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,109,134,109,190,97,142,125,190,125,134,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,109,134,109,190,97,142,125,190,125,190,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,206,111,182,97,182,125,182,97,206,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,238,111,206,97,238,125,238,97,198,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,134,111,246,97,134,125,190,97,134,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,142,111,246,97,198,125,246,97,142,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,182,111,182,97,134,125,246,97,246,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,134,111,190,97,134,125,246,97,134,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,206,111,190,97,142,125,182,97,206,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,134,111,246,97,238,125,222,97,222,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,206,111,182,97,206,125,182,97,206,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,206,111,182,97,198,125,246,97,206,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,134,111,182,97,134,125,182,97,182,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,142,111,182,97,142,125,182,97,142,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,198,111,190,97,190,125,190,97,198,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,142,111,182,97,182,125,182,97,142,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,134,111,190,97,142,125,190,97,134,127,254,0,0 },
  { 0,0,127,254,97,182,125,182,97,134,111,246,97,246,127,254,127,254,97,134,111,190,97,142,125,190,97,190,127,254,0,0 },
  { 7,192,24,48,32,8,65,4,67,4,133,2,129,2,129,2,129,2,129,2,65,4,71,196,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,67,132,68,68,132,66,128,66,128,130,129,2,130,2,68,4,71,196,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,67,132,68,68,132,66,128,66,129,130,128,66,132,66,68,68,67,132,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,132,65,132,130,130,132,130,136,130,143,194,128,130,64,132,64,132,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,196,68,4,132,2,132,2,135,130,128,66,128,66,68,68,67,132,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,65,132,66,4,132,2,132,2,135,130,132,66,132,66,68,68,67,132,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,196,64,68,128,66,128,130,128,130,128,130,129,2,65,4,65,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,67,132,68,68,132,66,132,66,131,130,132,66,132,66,68,68,67,132,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,67,132,68,68,132,66,132,66,131,194,128,66,128,66,64,132,67,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,100,140,146,148,146,132,146,132,146,132,146,95,100,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,68,140,194,149,66,132,66,132,66,132,66,95,244,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,100,140,146,148,18,132,34,132,66,132,130,95,244,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,100,140,146,148,18,132,34,132,18,132,146,95,100,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,20,140,50,148,82,132,146,132,250,132,18,95,20,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,244,140,130,148,130,132,226,132,18,132,146,95,100,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,116,140,130,148,130,132,226,132,146,132,146,95,100,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,244,140,18,148,18,132,34,132,34,132,66,95,68,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,100,140,146,148,146,132,98,132,146,132,146,95,100,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,100,140,146,148,146,132,114,132,18,132,18,95,100,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,76,100,146,146,130,146,132,146,136,146,144,146,94,100,64,4,32,8,24,48,7,192,0,0 },
  { 0,0,0,0,16,8,32,132,33,132,66,130,64,130,64,130,64,130,64,130,64,130,32,132,35,228,16,8,0,0,0,0 },
  { 0,0,0,0,16,8,35,196,36,36,68,34,64,34,64,194,65,2,66,2,68,2,36,4,39,228,16,8,0,0,0,0 },
  { 0,0,0,0,16,8,35,196,36,36,68,34,64,34,65,194,64,34,64,34,68,34,36,36,35,196,16,8,0,0,0,0 },
  { 0,0,0,0,16,8,32,68,32,196,65,66,66,66,68,66,68,66,71,226,64,66,32,68,32,68,16,8,0,0,0,0 },
  { 0,0,0,0,16,8,39,228,36,4,68,2,68,2,71,194,64,34,64,34,64,34,36,36,35,196,16,8,0,0,0,0 },
  { 0,0,0,0,16,8,33,196,34,4,68,2,68,2,71,194,68,34,68,34,68,34,36,36,35,196,16,8,0,0,0,0 },
  { 0,0,0,0,16,8,39,228,32,36,64,34,64,66,64,66,64,66,64,130,64,130,32,132,32,132,16,8,0,0,0,0 },
  { 0,0,0,0,16,8,35,196,36,36,68,34,68,34,67,194,68,34,68,34,68,34,36,36,35,196,16,8,0,0,0,0 },
  { 0,0,0,0,16,8,35,196,36,36,68,34,68,34,67,226,64,34,64,34,64,34,32,68,35,132,16,8,0,0,0,0 },
  { 0,0,0,0,64,2,136,49,152,73,168,133,136,133,136,133,136,133,136,133,136,133,136,73,190,49,64,2,0,0,0,0 },
  { 0,0,0,0,64,2,136,17,152,49,168,81,136,17,136,17,136,17,136,17,136,17,136,17,190,125,64,2,0,0,0,0 },
  { 0,0,0,0,64,2,136,121,152,133,168,133,136,5,136,25,136,33,136,65,136,129,136,129,190,253,64,2,0,0,0,0 },
  { 0,0,0,0,64,2,136,121,152,133,168,133,136,5,136,57,136,5,136,5,136,133,136,133,190,121,64,2,0,0,0,0 },
  { 0,0,0,0,64,2,136,9,152,25,168,41,136,73,136,137,136,137,136,253,136,9,136,9,190,9,64,2,0,0,0,0 },
  { 0,0,0,0,64,2,136,253,152,129,168,129,136,129,136,249,136,5,136,5,136,5,136,133,190,121,64,2,0,0,0,0 },
  { 0,0,0,0,64,2,136,57,152,65,168,129,136,129,136,249,136,133,136,133,136,133,136,133,190,121,64,2,0,0,0,0 },
  { 0,0,0,0,64,2,137,249,152,9,168,9,136,17,136,17,136,17,136,33,136,33,136,33,190,33,64,2,0,0,0,0 },
  { 0,0,0,0,64,2,136,121,152,133,168,133,136,133,136,121,136,133,136,133,136,133,136,133,190,121,64,2,0,0,0,0 },
  { 0,0,0,0,64,2,136,121,152,133,168,133,136,133,136,125,136,5,136,5,136,5,136,9,190,113,64,2,0,0,0,0 },
  { 0,0,0,0,64,2,156,49,162,73,162,133,130,133,132,133,136,133,144,133,160,133,160,73,190,49,64,2,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,0,3,0,5,0,1,0,1,0,1,0,1,0,1,0,1,0,7,208,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,128,8,64,8,64,0,64,1,128,2,0,4,0,8,0,8,0,15,208,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,128,8,64,8,64,0,64,3,128,0,64,0,64,8,64,8,64,7,144,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,128,1,128,2,128,4,128,8,128,8,128,15,192,0,128,0,128,0,144,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,192,8,0,8,0,8,0,15,128,0,64,0,64,0,64,8,64,7,144,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,4,0,8,0,8,0,15,128,8,64,8,64,8,64,8,64,7,144,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,192,0,64,0,64,0,128,0,128,0,128,1,0,1,0,1,0,1,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,128,8,64,8,64,8,64,7,128,8,64,8,64,8,64,8,64,7,144,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,128,8,64,8,64,8,64,7,192,0,64,0,64,0,64,0,128,7,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,96,48,144,81,8,17,8,17,8,17,8,17,8,17,8,16,144,124,98,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,32,48,96,80,160,16,32,16,32,16,32,16,32,16,32,16,32,124,250,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,240,49,8,81,8,16,8,16,48,16,64,16,128,17,0,17,0,125,250,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,240,49,8,81,8,16,8,16,112,16,8,16,8,17,8,17,8,124,242,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,16,48,48,80,80,16,144,17,16,17,16,17,248,16,16,16,16,124,18,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,17,248,49,0,81,0,17,0,17,240,16,8,16,8,16,8,17,8,124,242,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,112,48,128,81,0,17,0,17,240,17,8,17,8,17,8,17,8,124,242,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,17,248,48,8,80,8,16,16,16,16,16,16,16,32,16,32,16,32,124,34,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,240,49,8,81,8,17,8,16,240,17,8,17,8,17,8,17,8,124,242,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,240,49,8,81,8,17,8,16,248,16,8,16,8,16,8,16,16,124,226,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,60,48,66,72,66,132,2,132,12,132,16,132,32,132,64,132,64,72,126,49,0,0,0,0 },
  { 0,0,0,0,16,8,32,4,35,196,68,34,64,34,67,226,68,34,68,34,68,98,35,164,32,4,16,8,0,0,0,0 },
  { 0,0,0,0,20,8,36,4,36,4,69,194,70,34,68,34,68,34,68,34,68,34,38,36,37,196,16,8,0,0,0,0 },
  { 0,0,0,0,16,8,32,4,35,196,68,34,68,2,68,2,68,2,68,2,68,34,35,196,32,4,16,8,0,0,0,0 },
  { 0,0,0,0,0,0,16,40,32,36,32,36,67,162,68,98,68,34,68,34,68,34,68,34,36,100,35,164,16,8,0,0 },
  { 0,0,0,0,16,8,32,4,35,196,68,34,68,34,71,226,68,2,68,2,68,34,35,196,32,4,16,8,0,0,0,0 },
  { 0,0,0,0,0,0,16,200,33,4,33,4,65,2,71,194,65,2,65,2,65,2,65,2,33,4,33,4,16,8,0,0 },
  { 0,0,0,0,16,8,32,36,35,164,68,66,68,66,68,66,67,130,66,2,67,194,36,36,36,36,19,200,0,0,0,0 },
  { 0,0,0,0,0,0,20,8,36,4,36,4,69,194,70,34,68,34,68,34,68,34,68,34,36,36,36,36,16,8,0,0 },
  { 0,0,0,0,17,16,33,8,32,8,67,4,65,4,65,4,65,4,65,4,65,4,33,8,39,200,16,16,0,0,0,0 },
  { 0,0,0,0,16,80,32,72,32,8,64,196,64,68,64,68,64,68,64,68,64,68,32,72,32,72,20,144,3,0,0,0 },
  { 0,0,0,0,0,0,16,8,36,4,36,4,68,66,68,130,69,2,70,2,69,2,68,130,36,68,36,36,16,8,0,0 },
  { 0,0,0,0,16,16,35,8,33,8,65,4,65,4,65,4,65,4,65,4,65,4,33,8,39,200,16,16,0,0,0,0 },
  { 0,0,0,0,16,4,32,2,39,98,68,145,68,145,68,145,68,145,68,145,68,145,36,146,32,2,16,4,0,0,0,0 },
  { 0,0,0,0,0,0,16,8,32,4,37,196,70,34,68,34,68,34,68,34,68,34,68,34,36,36,32,4,16,8,0,0 },
  { 0,0,0,0,16,8,32,4,35,196,68,34,68,34,68,34,68,34,68,34,68,34,35,196,32,4,16,8,0,0,0,0 },
  { 0,0,0,0,16,8,32,4,37,196,70,34,68,34,68,34,68,34,68,34,70,34,37,196,36,4,20,8,0,0,0,0 },
  { 0,0,0,0,0,0,16,8,32,4,35,164,68,98,68,34,68,34,68,34,68,34,68,98,35,164,32,36,16,40,0,0 },
  { 0,0,0,0,16,8,32,4,37,196,70,34,68,34,68,2,68,2,68,2,68,2,36,4,32,4,16,8,0,0,0,0 },
  { 0,0,0,0,16,8,32,4,35,196,68,34,68,2,67,2,64,194,64,34,68,34,35,196,32,4,16,8,0,0,0,0 },
  { 0,0,0,0,0,0,16,8,33,4,33,4,71,194,65,2,65,2,65,2,65,2,65,2,33,4,32,196,16,8,0,0 },
  { 0,0,0,0,16,8,32,4,36,36,68,34,68,34,68,34,68,34,68,34,68,98,35,164,32,4,16,8,0,0,0,0 },
  { 0,0,0,0,0,0,16,8,32,4,36,36,68,34,68,34,66,66,66,66,66,66,65,130,33,132,32,4,16,8,0,0 },
  { 0,0,0,0,16,4,32,2,36,18,68,145,68,145,68,145,68,145,68,145,68,145,35,98,32,2,16,4,0,0,0,0 },
  { 0,0,0,0,0,0,16,8,32,4,36,36,68,34,66,66,65,130,65,130,66,66,68,34,36,36,32,4,16,8,0,0 },
  { 0,0,0,0,16,8,32,4,36,36,68,34,68,34,68,34,68,34,66,98,65,162,32,36,32,36,19,200,0,0,0,0 },
  { 0,0,0,0,16,8,32,4,39,228,64,34,64,66,64,130,65,2,66,2,68,2,39,228,32,4,16,8,0,0,0,0 },
  { 7,192,24,48,32,8,65,4,66,132,130,130,132,66,132,66,135,194,132,66,68,68,68,68,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,132,68,68,132,66,132,66,135,130,132,66,132,66,68,68,71,132,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,67,132,68,68,132,66,132,2,132,2,132,2,132,66,68,68,67,132,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,4,68,132,132,66,132,66,132,66,132,66,132,66,68,132,71,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,196,68,4,132,2,132,2,135,130,132,2,132,2,68,4,71,196,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,196,68,4,132,2,132,2,135,130,132,2,132,2,68,4,68,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,67,132,68,68,132,66,132,2,133,194,132,66,132,66,68,196,67,68,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,68,68,68,68,132,66,132,66,135,194,132,66,132,66,68,68,68,68,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,196,65,4,129,2,129,2,129,2,129,2,129,2,65,4,71,196,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,67,228,64,132,128,130,128,130,128,130,128,130,132,130,68,132,67,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,68,68,68,68,132,130,133,2,134,2,133,2,132,130,68,68,68,68,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,68,4,68,4,132,2,132,2,132,2,132,2,132,2,68,4,71,196,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,68,68,68,68,134,194,134,194,133,66,133,66,132,66,68,68,68,68,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,68,134,66,134,66,133,66,133,66,132,194,68,196,68,68,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,67,132,68,68,132,66,132,66,132,66,132,66,132,66,68,68,67,132,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,132,68,68,132,66,132,66,135,130,132,2,132,2,68,4,68,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,67,132,68,68,132,66,132,66,132,66,132,66,133,66,70,196,67,132,32,104,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,132,68,68,132,66,132,66,135,130,133,2,132,130,68,132,68,68,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,67,132,68,68,132,66,132,2,131,130,128,66,132,66,68,68,67,132,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,79,228,65,4,129,2,129,2,129,2,129,2,129,2,65,4,65,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,68,68,68,68,132,66,132,66,132,66,132,66,132,66,68,68,67,132,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,72,36,72,36,132,66,132,66,132,66,130,130,130,130,65,4,65,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,68,68,68,68,132,66,133,66,133,66,134,194,134,194,68,68,68,68,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,68,68,68,68,130,130,130,130,129,2,130,130,130,130,68,68,68,68,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,72,36,72,36,132,66,132,66,130,130,129,2,129,2,65,4,65,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,196,64,68,128,66,128,130,129,2,130,2,132,2,68,4,71,196,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,67,132,132,66,128,66,131,194,132,66,132,194,67,68,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,36,8,68,4,68,4,133,130,134,66,132,66,132,66,132,66,70,68,69,132,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,67,132,132,66,132,2,132,2,132,2,132,66,67,132,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,72,64,68,64,68,131,66,132,194,132,66,132,66,132,66,68,196,67,68,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,67,132,132,66,132,66,135,194,132,2,132,66,67,132,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,196,65,4,129,2,129,2,135,194,129,2,129,2,65,4,65,4,33,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,68,67,68,132,130,132,130,131,2,130,2,131,130,68,68,68,68,35,136,24,48,7,192,0,0 },
  { 7,192,24,48,36,8,68,4,68,4,133,130,134,66,132,66,132,66,132,66,68,68,68,68,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,33,8,65,4,64,4,131,2,129,2,129,2,129,2,129,2,65,4,71,196,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,72,64,68,64,4,128,194,128,66,128,66,128,66,128,66,64,68,68,132,35,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,68,4,68,4,132,130,133,2,134,2,134,2,133,2,68,132,68,68,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,67,4,65,4,129,2,129,2,129,2,129,2,129,2,65,4,71,196,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,78,196,137,34,137,34,137,34,137,34,137,34,73,36,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,69,132,134,66,132,66,132,66,132,66,132,66,68,68,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,67,132,132,66,132,66,132,66,132,66,132,66,67,132,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,69,132,134,66,132,66,132,66,132,66,134,66,69,132,68,4,36,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,67,68,132,194,132,66,132,66,132,66,132,66,68,196,67,68,32,72,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,69,132,134,66,132,66,132,2,132,2,132,2,68,4,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,67,132,132,66,132,2,131,130,128,66,132,66,67,132,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,65,4,65,4,135,194,129,2,129,2,129,2,129,2,65,4,64,196,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,68,132,66,132,66,132,66,132,66,132,194,67,68,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,68,132,66,130,130,130,130,130,130,129,2,65,4,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,72,36,137,34,137,34,137,34,137,34,137,34,70,196,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,68,132,66,130,130,129,2,130,130,132,66,68,68,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,68,68,132,66,132,66,132,66,130,194,129,66,64,68,64,68,35,136,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,4,71,196,128,66,128,130,129,2,130,2,132,2,71,196,64,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,65,4,66,132,132,66,132,66,132,66,132,66,132,66,66,132,65,4,32,8,24,48,7,192,0,0 },
  { 7,192,31,240,63,248,127,252,123,188,243,62,234,190,251,190,251,190,251,190,96,12,127,252,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,127,252,123,156,243,110,235,238,251,222,251,190,251,126,96,12,127,252,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,127,252,123,156,243,110,235,238,251,222,251,238,251,110,96,156,127,252,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,127,252,123,236,243,206,235,174,251,110,251,6,251,238,96,236,127,252,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,127,252,123,12,243,126,235,126,251,30,251,238,251,110,96,156,127,252,63,248,31,240,7,192,0,0 },
  { 0,0,7,192,31,240,63,248,59,136,115,124,107,124,123,28,123,108,123,108,32,152,63,248,31,240,7,192,0,0,0,0 },
  { 0,0,7,192,31,240,63,248,59,8,115,236,107,236,123,220,123,220,123,188,32,184,63,248,31,240,7,192,0,0,0,0 },
  { 0,0,7,192,31,240,63,248,59,152,115,108,107,108,123,156,123,108,123,108,32,152,63,248,31,240,7,192,0,0,0,0 },
  { 7,192,31,240,63,248,127,252,123,156,243,110,235,110,251,142,251,238,251,238,96,156,127,252,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,127,252,115,156,237,110,253,110,251,110,247,110,239,110,97,156,127,252,63,248,31,240,7,192,0,0 },
  { 0,0,7,224,24,24,35,196,76,50,80,10,144,137,161,133,160,133,160,133,145,201,80,10,76,50,35,196,24,24,7,224 },
  { 0,0,7,224,24,24,35,196,76,50,80,10,145,137,160,69,160,133,161,5,145,201,80,10,76,50,35,196,24,24,7,224 },
  { 0,0,7,224,24,24,35,196,76,50,80,10,145,137,160,69,161,133,160,69,145,137,80,10,76,50,35,196,24,24,7,224 },
  { 0,0,7,224,24,24,35,196,76,50,80,10,146,137,162,133,163,197,160,133,144,137,80,10,76,50,35,196,24,24,7,224 },
  { 0,0,7,224,24,24,35,196,76,50,80,10,145,201,161,5,161,133,160,69,145,137,80,10,76,50,35,196,24,24,7,224 },
  { 0,0,7,224,24,24,35,196,76,50,80,10,145,137,162,5,163,133,162,69,145,137,80,10,76,50,35,196,24,24,7,224 },
  { 0,0,7,224,24,24,35,196,76,50,80,10,145,201,160,69,160,69,160,133,144,137,80,10,76,50,35,196,24,24,7,224 },
  { 0,0,7,224,24,24,35,196,76,50,80,10,145,137,162,69,161,133,162,69,145,137,80,10,76,50,35,196,24,24,7,224 },
  { 0,0,7,224,24,24,35,196,76,50,80,10,145,137,162,69,161,197,160,69,145,137,80,10,76,50,35,196,24,24,7,224 },
  { 0,0,7,224,24,24,35,196,76,50,80,10,146,105,166,149,162,149,162,149,151,105,80,10,76,50,35,196,24,24,7,224 },
  { 7,192,31,240,63,248,126,252,125,124,251,190,251,190,251,190,251,190,251,190,125,124,126,252,63,248,31,240,7,192,0,0 },
  { 0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8 },
  { 24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24 },
  { 0,0,0,0,0,0,0,219,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,219,219,0,0,0,0,0,0,0 },
  { 8,8,8,8,0,0,8,8,8,8,0,0,8,8,8,8 },
  { 24,24,24,24,0,0,24,24,24,24,0,0,24,24,24,24 },
  { 0,0,0,0,0,0,0,170,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,170,170,0,0,0,0,0,0,0 },
  { 8,8,8,0,8,8,8,0,8,8,8,0,8,8,8,0 },
  { 24,24,24,0,24,24,24,0,24,24,24,0,24,24,24,0 },
  { 0,0,0,0,0,0,0,15,8,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,15,15,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,31,24,24,24,24,24,24,24,24 },
  { 0,0,0,0,0,0,0,31,31,24,24,24,24,24,24,24 },
  { 0,0,0,0,0,0,0,248,8,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,248,248,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,248,24,24,24,24,24,24,24,24 },
  { 0,0,0,0,0,0,0,248,248,24,24,24,24,24,24,24 },
  { 8,8,8,8,8,8,8,15,0,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,8,15,15,0,0,0,0,0,0,0 },
  { 24,24,24,24,24,24,24,31,0,0,0,0,0,0,0,0 },
  { 24,24,24,24,24,24,24,31,31,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,8,248,0,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,8,248,248,0,0,0,0,0,0,0 },
  { 24,24,24,24,24,24,24,248,0,0,0,0,0,0,0,0 },
  { 24,24,24,24,24,24,24,248,248,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,8,15,8,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,8,15,15,8,8,8,8,8,8,8 },
  { 24,24,24,24,24,24,24,31,8,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,8,31,24,24,24,24,24,24,24,24 },
  { 24,24,24,24,24,24,24,31,24,24,24,24,24,24,24,24 },
  { 24,24,24,24,24,24,24,31,31,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,8,31,31,24,24,24,24,24,24,24 },
  { 24,24,24,24,24,24,24,31,31,24,24,24,24,24,24,24 },
  { 8,8,8,8,8,8,8,248,8,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,8,248,248,8,8,8,8,8,8,8 },
  { 24,24,24,24,24,24,24,248,8,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,8,248,24,24,24,24,24,24,24,24 },
  { 24,24,24,24,24,24,24,248,24,24,24,24,24,24,24,24 },
  { 24,24,24,24,24,24,24,248,248,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,8,248,248,24,24,24,24,24,24,24 },
  { 24,24,24,24,24,24,24,248,248,24,24,24,24,24,24,24 },
  { 0,0,0,0,0,0,0,255,8,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,255,248,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,255,15,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,255,255,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,255,24,24,24,24,24,24,24,24 },
  { 0,0,0,0,0,0,0,255,248,24,24,24,24,24,24,24 },
  { 0,0,0,0,0,0,0,255,31,24,24,24,24,24,24,24 },
  { 0,0,0,0,0,0,0,255,255,24,24,24,24,24,24,24 },
  { 8,8,8,8,8,8,8,255,0,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,8,255,248,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,8,255,15,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,8,255,255,0,0,0,0,0,0,0 },
  { 24,24,24,24,24,24,24,255,0,0,0,0,0,0,0,0 },
  { 24,24,24,24,24,24,24,255,248,0,0,0,0,0,0,0 },
  { 24,24,24,24,24,24,24,255,31,0,0,0,0,0,0,0 },
  { 24,24,24,24,24,24,24,255,255,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,8,255,8,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,8,255,248,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,8,255,15,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,8,255,255,8,8,8,8,8,8,8 },
  { 24,24,24,24,24,24,24,255,8,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,8,255,24,24,24,24,24,24,24,24 },
  { 24,24,24,24,24,24,24,255,24,24,24,24,24,24,24,24 },
  { 24,24,24,24,24,24,24,255,255,8,8,8,8,8,8,8 },
  { 24,24,24,24,24,24,24,255,31,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,8,255,248,24,24,24,24,24,24,24 },
  { 8,8,8,8,8,8,8,255,31,24,24,24,24,24,24,24 },
  { 24,24,24,24,24,24,24,255,255,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,8,255,255,24,24,24,24,24,24,24 },
  { 24,24,24,24,24,24,24,255,248,24,24,24,24,24,24,24 },
  { 24,24,24,24,24,24,24,255,31,24,24,24,24,24,24,24 },
  { 24,24,24,24,24,24,24,255,255,24,24,24,24,24,24,24 },
  { 0,0,0,0,0,0,0,238,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,238,238,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,0,0,8,8,8,8,8,8,0,0 },
  { 24,24,24,24,24,24,0,0,24,24,24,24,24,24,0,0 },
  { 0,0,0,0,0,0,255,0,255,0,0,0,0,0,0,0 },
  { 20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20 },
  { 0,0,0,0,0,0,15,8,15,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,31,20,20,20,20,20,20,20,20 },
  { 0,0,0,0,0,0,31,16,23,20,20,20,20,20,20,20 },
  { 0,0,0,0,0,0,248,8,248,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,252,20,20,20,20,20,20,20,20 },
  { 0,0,0,0,0,0,252,4,244,20,20,20,20,20,20,20 },
  { 8,8,8,8,8,8,15,8,15,0,0,0,0,0,0,0 },
  { 20,20,20,20,20,20,20,31,0,0,0,0,0,0,0,0 },
  { 20,20,20,20,20,20,23,16,31,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,248,8,248,0,0,0,0,0,0,0 },
  { 20,20,20,20,20,20,20,252,0,0,0,0,0,0,0,0 },
  { 20,20,20,20,20,20,244,4,252,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,15,8,15,8,8,8,8,8,8,8 },
  { 20,20,20,20,20,20,20,23,20,20,20,20,20,20,20,20 },
  { 20,20,20,20,20,20,23,16,23,20,20,20,20,20,20,20 },
  { 8,8,8,8,8,8,248,8,248,8,8,8,8,8,8,8 },
  { 20,20,20,20,20,20,20,244,20,20,20,20,20,20,20,20 },
  { 20,20,20,20,20,20,244,4,244,20,20,20,20,20,20,20 },
  { 0,0,0,0,0,0,255,0,255,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,255,20,20,20,20,20,20,20,20 },
  { 0,0,0,0,0,0,255,0,247,20,20,20,20,20,20,20 },
  { 8,8,8,8,8,8,255,0,255,0,0,0,0,0,0,0 },
  { 20,20,20,20,20,20,20,255,0,0,0,0,0,0,0,0 },
  { 20,20,20,20,20,20,247,0,255,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,255,8,255,8,8,8,8,8,8,8 },
  { 20,20,20,20,20,20,20,255,20,20,20,20,20,20,20,20 },
  { 20,20,20,20,20,20,247,0,247,20,20,20,20,20,20,20 },
  { 0,0,0,0,0,0,0,3,4,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,224,16,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,16,224,0,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,4,3,0,0,0,0,0,0,0,0 },
  { 1,1,2,2,4,4,8,8,16,16,32,32,64,64,128,128 },
  { 128,128,64,64,32,32,16,16,8,8,4,4,2,2,1,1 },
  { 129,129,66,66,36,36,24,24,24,24,36,36,66,66,129,129 },
  { 0,0,0,0,0,0,0,240,0,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,8,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8 },
  { 0,0,0,0,0,0,0,240,240,0,0,0,0,0,0,0 },
  { 24,24,24,24,24,24,24,24,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,15,15,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,24,24,24,24,24,24,24 },
  { 0,0,0,0,0,0,0,255,15,0,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,8,8,24,24,24,24,24,24,24,24 },
  { 0,0,0,0,0,0,0,255,240,0,0,0,0,0,0,0 },
  { 24,24,24,24,24,24,24,24,8,8,8,8,8,8,8,8 },
  { 255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255 },
  { 0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255 },
  { 0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255 },
  { 0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255 },
  { 0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255 },
  { 0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255 },
  { 255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255 },
  { 254,254,254,254,254,254,254,254,254,254,254,254,254,254,254,254 },
  { 252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252 },
  { 248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248 },
  { 240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240 },
  { 224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224 },
  { 192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192 },
  { 128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128 },
  { 15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15 },
  { 136,34,136,34,136,34,136,34,136,34,136,34,136,34,136,34 },
  { 170,85,170,85,170,85,170,85,170,85,170,85,170,85,170,85 },
  { 238,187,238,187,238,187,238,187,238,187,238,187,238,187,238,187 },
  { 255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1 },
  { 0,0,0,0,0,0,0,0,240,240,240,240,240,240,240,240 },
  { 0,0,0,0,0,0,0,0,15,15,15,15,15,15,15,15 },
  { 240,240,240,240,240,240,240,240,0,0,0,0,0,0,0,0 },
  { 240,240,240,240,240,240,240,240,255,255,255,255,255,255,255,255 },
  { 240,240,240,240,240,240,240,240,15,15,15,15,15,15,15,15 },
  { 255,255,255,255,255,255,255,255,240,240,240,240,240,240,240,240 },
  { 255,255,255,255,255,255,255,255,15,15,15,15,15,15,15,15 },
  { 15,15,15,15,15,15,15,15,0,0,0,0,0,0,0,0 },
  { 15,15,15,15,15,15,15,15,240,240,240,240,240,240,240,240 },
  { 15,15,15,15,15,15,15,15,255,255,255,255,255,255,255,255 },
  { 0,0,0,0,0,0,127,127,127,127,127,127,127,0,0,0 },
  { 0,0,0,0,0,0,127,65,65,65,65,65,127,0,0,0 },
  { 0,0,0,0,0,0,62,65,65,65,65,65,62,0,0,0 },
  { 0,0,0,0,0,0,127,65,93,93,93,65,127,0,0,0 },
  { 0,0,0,0,0,0,127,65,127,65,127,65,127,0,0,0 },
  { 0,0,0,0,0,0,127,85,85,85,85,85,127,0,0,0 },
  { 0,0,0,0,0,0,127,85,127,85,127,85,127,0,0,0 },
  { 0,0,0,0,0,0,127,83,73,101,83,73,127,0,0,0 },
  { 0,0,0,0,0,0,127,101,73,83,101,73,127,0,0,0 },
  { 0,0,0,0,0,0,127,85,107,85,107,85,127,0,0,0 },
  { 0,0,0,0,0,0,60,60,60,60,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,60,36,36,60,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,127,127,127,127,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,127,65,65,127,0,0,0,0,0,0 },
  { 0,0,0,0,0,60,60,60,60,60,60,60,0,0,0,0 },
  { 0,0,0,0,0,60,36,36,36,36,36,60,0,0,0,0 },
  { 0,0,0,0,0,0,0,63,126,252,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,63,66,252,0,0,0,0,0,0 },
  { 0,0,0,0,0,24,24,60,60,126,126,0,0,0,0,0 },
  { 0,0,0,0,0,24,24,36,36,66,126,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,60,126,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,36,126,0,0,0,0,0 },
  { 0,0,0,0,0,96,120,126,126,120,96,0,0,0,0,0 },
  { 0,0,0,0,0,96,88,70,70,88,96,0,0,0,0,0 },
  { 0,0,0,0,0,0,48,60,60,48,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,48,44,44,48,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,96,120,126,120,96,0,0,0,0,0 },
  { 0,0,0,0,0,0,96,88,70,88,96,0,0,0,0,0 },
  { 0,0,0,0,0,126,126,60,60,24,24,0,0,0,0,0 },
  { 0,0,0,0,0,126,66,36,36,24,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,126,60,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,126,36,24,0,0,0,0,0 },
  { 0,0,0,0,0,6,30,126,126,30,6,0,0,0,0,0 },
  { 0,0,0,0,0,6,26,98,98,26,6,0,0,0,0,0 },
  { 0,0,0,0,0,0,12,60,60,12,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,12,52,52,12,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,6,30,126,30,6,0,0,0,0,0 },
  { 0,0,0,0,0,0,6,26,98,26,6,0,0,0,0,0 },
  { 0,0,0,0,0,8,28,62,127,62,28,8,0,0,0,0 },
  { 0,0,0,0,0,8,20,34,65,34,20,8,0,0,0,0 },
  { 0,0,0,0,0,8,20,42,93,42,20,8,0,0,0,0 },
  { 0,0,0,0,0,28,34,89,93,77,34,28,0,0,0,0 },
  { 0,0,0,24,24,36,36,66,66,36,36,24,24,0,0,0 },
  { 0,0,0,0,0,28,34,65,65,65,34,28,0,0,0,0 },
  { 0,0,0,0,0,20,0,65,0,65,0,20,0,0,0,0 },
  { 0,0,0,0,0,28,54,85,85,85,54,28,0,0,0,0 },
  { 0,0,0,0,0,28,34,73,85,73,34,28,0,0,0,0 },
  { 0,0,0,0,0,28,62,127,127,127,62,28,0,0,0,0 },
  { 0,0,0,0,0,28,50,113,113,113,50,28,0,0,0,0 },
  { 0,0,0,0,0,28,38,71,71,71,38,28,0,0,0,0 },
  { 0,0,0,0,0,28,34,65,65,127,62,28,0,0,0,0 },
  { 0,0,0,0,0,28,62,127,65,65,34,28,0,0,0,0 },
  { 0,0,0,0,0,28,46,79,79,65,34,28,0,0,0,0 },
  { 0,0,0,0,0,28,38,71,71,127,62,28,0,0,0,0 },
  { 0,0,0,0,0,24,56,120,120,120,56,24,0,0,0,0 },
  { 0,0,0,0,0,12,14,15,15,15,14,12,0,0,0,0 },
  { 255,255,255,255,255,255,231,195,195,231,255,255,255,255,255,255 },
  { 255,255,255,255,255,231,219,189,189,219,231,255,255,255,255,255 },
  { 255,255,255,255,255,231,219,189,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,189,219,231,255,255,255,255,255 },
  { 0,0,0,0,0,24,32,64,64,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,12,2,1,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,1,2,12,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,64,32,24,0,0,0,0 },
  { 0,0,0,0,0,28,34,65,65,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,65,65,34,28,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,2,6,14,30,62,126,0 },
  { 0,0,0,0,0,0,0,0,0,64,96,112,120,124,126,0 },
  { 0,0,126,124,120,112,96,64,0,0,0,0,0,0,0,0 },
  { 0,0,126,62,30,14,6,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,56,68,68,68,56,0,0,0,0 },
  { 0,0,0,0,0,126,114,114,114,114,126,0,0,0,0,0 },
  { 0,0,0,0,0,126,78,78,78,78,126,0,0,0,0,0 },
  { 0,0,0,0,0,126,122,114,98,66,126,0,0,0,0,0 },
  { 0,0,0,0,0,126,66,70,78,94,126,0,0,0,0,0 },
  { 0,0,0,0,0,127,73,73,73,73,127,0,0,0,0,0 },
  { 0,0,0,0,0,8,20,20,34,42,65,127,0,0,0,0 },
  { 0,0,0,0,0,0,24,24,52,52,114,126,0,0,0,0 },
  { 0,0,0,0,0,24,24,44,44,78,78,126,0,0,0,0 },
  { 0,0,0,0,60,66,129,129,129,129,66,60,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,126,82,114,66,66,126,0,0 },
  { 0,0,0,0,0,0,0,0,126,66,66,114,82,126,0,0 },
  { 0,0,0,0,0,0,0,0,126,66,66,78,74,126,0,0 },
  { 0,0,0,0,0,0,0,0,126,74,78,66,66,126,0,0 },
  { 0,0,0,0,0,0,60,82,145,241,129,129,66,60,0,0 },
  { 0,0,0,0,0,0,60,66,129,129,241,145,82,60,0,0 },
  { 0,0,0,0,0,0,60,66,129,129,143,137,74,60,0,0 },
  { 0,0,0,0,0,0,60,74,137,143,129,129,66,60,0,0 },
  { 0,0,126,68,72,80,96,64,0,0,0,0,0,0,0,0 },
  { 0,0,126,34,18,10,6,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,64,96,80,72,68,126,0 },
  { 0,0,0,0,0,0,0,0,0,126,66,66,66,66,126,0 },
  { 0,0,0,0,0,0,0,0,0,126,126,126,126,126,126,0 },
  { 0,0,0,0,0,0,0,0,0,0,60,36,36,60,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,60,60,60,60,0,0 },
  { 0,0,0,0,0,0,0,0,0,2,6,10,18,34,126,0 },
  { 0,0,8,73,34,0,28,62,62,28,0,34,73,8,0,0 },
  { 0,0,0,0,32,118,255,126,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,28,62,127,8,8,8,8,16,0,0,0,0 },
  { 139,200,3,192,47,241,4,36,138,80,40,18,10,80,73,148,4,33,71,224,8,16,16,136,120,30,16,136,8,16,7,224 },
  { 0,0,0,34,34,36,36,40,41,2,48,72,72,48,0,0 },
  { 0,0,0,0,0,8,8,127,28,54,34,0,0,0,0,0 },
  { 0,0,0,0,8,8,119,34,42,54,34,0,0,0,0,0 },
  { 0,0,0,0,0,2,4,8,16,32,16,10,6,14,0,0 },
  { 0,0,0,0,0,0,126,66,68,72,80,74,70,78,0,0 },
  { 0,0,0,0,0,0,60,66,129,153,153,129,66,60,0,0 },
  { 0,0,0,0,0,0,24,36,36,102,165,66,0,0,0,0 },
  { 0,0,0,0,0,0,66,165,102,36,36,24,0,0,0,0 },
  { 0,0,0,0,0,0,4,8,48,72,72,48,0,0,0,0 },
  { 0,0,0,0,0,6,9,9,6,8,48,72,72,48,0,0 },
  { 0,0,0,0,0,0,0,62,99,0,42,99,127,0,0,0 },
  { 0,0,0,0,0,0,62,65,93,62,73,65,127,0,0,0 },
  { 0,0,0,0,0,0,0,127,65,65,65,65,65,127,0,0 },
  { 0,0,0,0,0,0,4,127,69,69,101,89,65,127,0,0 },
  { 0,0,0,0,0,0,0,127,65,85,73,85,65,127,0,0 },
  { 0,0,0,0,34,34,20,20,8,8,20,20,34,34,0,0 },
  { 5,80,4,65,28,62,127,8,8,8,8,16,0,0,0,0 },
  { 0,0,9,32,18,64,18,64,9,32,9,32,18,64,0,0,31,200,63,244,47,212,32,20,32,56,31,192,0,0,0,0 },
  { 0,0,1,0,2,128,4,64,8,32,16,16,32,8,32,8,32,8,32,8,32,8,32,8,32,8,63,248,0,0,0,0 },
  { 0,0,1,0,3,128,7,192,15,224,31,240,63,248,63,248,63,248,63,248,63,248,63,248,63,248,63,248,0,0,0,0 },
  { 0,0,0,0,2,128,7,192,7,192,51,152,121,60,63,248,121,60,49,24,2,0,2,0,2,0,4,0,8,0,0,0 },
  { 0,0,0,0,0,4,1,200,35,232,71,232,79,232,127,216,63,220,15,228,7,228,3,228,1,196,0,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,126,31,31,14,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,63,124,124,56,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,126,17,25,14,0,0,0,0 },
  { 0,0,0,0,0,4,4,28,52,36,36,24,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,63,68,76,56,0,0,0,0 },
  { 0,0,0,0,0,0,0,24,36,36,52,28,4,4,0,0 },
  { 0,0,231,165,126,129,165,165,129,90,90,66,189,231,0,0 },
  { 0,0,0,0,56,4,4,8,8,16,16,32,32,28,0,0 },
  { 7,224,24,24,36,36,92,58,92,58,190,125,190,125,190,125,129,129,129,129,131,193,67,194,71,226,35,196,24,24,7,224 },
  { 0,0,0,0,4,64,8,32,16,16,16,16,19,144,12,96,62,248,68,68,133,66,131,130,2,128,4,64,24,48,0,0 },
  { 0,0,3,0,1,0,127,252,35,136,31,240,1,0,13,96,17,16,15,224,9,32,7,192,5,64,3,128,5,64,1,0 },
  { 0,0,0,0,0,0,28,34,20,8,62,8,8,8,0,0 },
  { 0,0,0,0,0,8,28,8,62,8,24,12,8,8,0,0 },
  { 0,0,0,0,28,18,18,28,16,84,56,16,56,84,0,0 },
  { 0,0,0,0,0,8,28,8,62,8,8,8,8,8,0,0 },
  { 0,0,0,0,0,0,0,28,8,73,127,73,8,28,0,0 },
  { 0,0,0,0,30,33,64,194,199,194,64,33,30,0,0,0 },
  { 0,0,0,0,0,0,5,64,6,192,0,0,21,80,41,40,41,40,41,40,37,72,19,144,7,192,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,128,2,160,4,144,9,200,26,172,26,172,25,204,28,156,27,236,17,196,2,160,0,128,0,0 },
  { 0,0,0,0,0,0,12,2,57,121,13,62,99,193,0,0 },
  { 0,0,0,0,0,0,62,73,73,73,93,107,73,62,0,0 },
  { 7,224,24,24,32,4,64,2,64,2,156,49,190,49,255,3,231,131,231,199,255,255,127,254,127,254,63,252,31,248,7,224 },
  { 0,0,0,0,0,0,0,0,127,252,127,252,0,0,0,0,127,252,127,252,0,0,0,0,127,252,127,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,124,124,124,124,0,0,0,0,127,252,127,252,0,0,0,0,127,252,127,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,127,252,127,252,0,0,0,0,124,124,124,124,0,0,0,0,127,252,127,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,124,124,124,124,0,0,0,0,124,124,124,124,0,0,0,0,127,252,127,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,127,252,127,252,0,0,0,0,127,252,127,252,0,0,0,0,124,124,124,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,124,124,124,124,0,0,0,0,127,252,127,252,0,0,0,0,124,124,124,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,127,252,127,252,0,0,0,0,124,124,124,124,0,0,0,0,124,124,124,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,124,124,124,124,0,0,0,0,124,124,124,124,0,0,0,0,124,124,124,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,73,62,62,119,62,62,73,0,0 },
  { 0,0,0,60,66,129,165,129,153,165,129,66,60,0,0,0 },
  { 0,0,0,0,60,66,129,165,129,165,153,66,60,0,0,0 },
  { 0,0,0,0,60,126,255,219,255,219,231,126,60,0,0,0 },
  { 0,0,0,0,0,73,42,28,119,28,42,73,0,0,0,0 },
  { 0,0,0,0,56,12,6,5,5,5,5,6,12,56,0,0 },
  { 0,0,0,0,14,24,48,80,80,80,80,48,24,14,0,0 },
  { 0,0,0,34,34,28,34,34,34,28,8,62,8,8,0,0 },
  { 0,0,0,0,0,28,34,34,34,28,8,62,8,8,0,0 },
  { 0,0,0,8,8,62,8,8,28,34,34,34,28,0,0,0 },
  { 0,0,0,0,0,7,3,5,56,68,68,68,56,0,0,0 },
  { 0,0,0,0,2,2,2,58,70,6,10,126,2,2,0,0 },
  { 0,0,0,0,32,32,112,32,44,50,34,36,36,36,0,0 },
  { 0,0,0,0,0,107,42,62,42,107,8,28,20,28,0,0 },
  { 0,0,0,0,8,89,203,73,73,73,62,8,62,8,8,0 },
  { 0,0,0,0,124,66,66,66,124,64,64,64,64,126,0,0 },
  { 0,0,0,0,34,85,20,20,8,8,8,8,8,8,0,0 },
  { 0,0,0,0,0,0,0,65,34,28,34,34,34,28,0,0 },
  { 0,0,0,0,65,62,20,20,20,20,20,20,62,65,0,0 },
  { 0,0,0,0,0,0,62,73,72,48,6,9,73,62,0,0 },
  { 0,0,0,0,0,28,34,34,18,116,148,148,101,2,0,0 },
  { 0,0,0,0,84,124,85,87,85,85,85,85,6,124,0,0 },
  { 0,0,0,0,0,0,0,28,34,34,119,0,127,0,0,0 },
  { 0,0,0,0,84,124,84,84,84,84,84,84,85,3,0,0 },
  { 0,0,0,0,0,0,0,15,3,69,41,16,40,68,0,0 },
  { 0,0,0,0,49,78,132,8,16,60,98,162,162,28,0,0 },
  { 0,0,0,0,0,0,42,84,0,0,42,84,0,0,0,0 },
  { 0,0,0,0,0,66,66,36,36,126,36,36,66,66,0,0 },
  { 0,8,28,73,93,99,65,34,34,34,65,65,65,127,0,0 },
  { 0,0,0,8,28,99,65,34,34,34,65,65,65,127,0,0 },
  { 0,0,0,0,0,85,127,65,65,34,34,65,65,127,0,0 },
  { 0,0,0,0,8,20,34,34,34,34,20,119,65,127,0,0 },
  { 0,0,0,2,30,34,66,66,58,18,34,66,66,126,0,0 },
  { 0,0,0,0,0,0,24,36,36,24,36,36,66,126,0,0 },
  { 0,8,28,73,93,127,127,62,62,62,127,127,127,127,0,0 },
  { 0,0,0,8,28,127,119,62,62,62,127,127,127,127,0,0 },
  { 0,0,0,0,0,0,85,127,127,62,62,127,127,127,0,0 },
  { 0,0,0,0,8,28,54,34,54,62,28,127,127,127,0,0 },
  { 0,0,0,2,30,54,126,126,62,30,62,126,126,126,0,0 },
  { 0,0,0,0,0,0,24,60,60,24,60,60,126,126,0,0 },
  { 0,0,0,0,8,8,28,62,127,127,127,62,8,28,0,0 },
  { 0,0,0,0,0,54,73,65,65,65,34,20,8,8,0,0 },
  { 0,0,0,0,8,8,20,20,34,34,20,20,8,8,0,0 },
  { 0,0,0,0,28,28,28,8,127,127,107,8,8,28,0,0 },
  { 0,0,0,0,8,8,20,34,65,65,65,62,8,28,0,0 },
  { 0,0,0,0,0,54,127,127,127,127,62,28,8,8,0,0 },
  { 0,0,0,0,8,8,28,28,62,62,28,28,8,8,0,0 },
  { 0,0,0,0,28,20,28,8,119,93,107,8,8,28,0,0 },
  { 0,0,0,8,81,146,146,146,73,73,73,82,129,126,0,0 },
  { 0,0,0,0,8,8,8,8,8,8,8,56,120,112,0,0 },
  { 0,0,0,0,8,12,10,10,8,8,8,56,120,112,0,0 },
  { 0,0,0,28,23,17,17,17,17,113,241,231,15,14,0,0 },
  { 0,0,0,28,23,17,29,23,17,113,241,231,15,14,0,0 },
  { 0,0,64,64,64,64,64,92,102,70,68,72,80,96,0,0 },
  { 0,0,0,64,64,78,126,114,66,78,126,114,2,2,0,0 },
  { 0,0,4,36,38,62,124,100,36,38,62,124,100,36,32,0 },
  { 0,0,0,0,20,8,8,73,62,73,8,8,8,20,0,0 },
  { 0,0,0,0,28,20,8,107,93,107,8,8,20,8,0,0 },
  { 3,192,5,32,10,152,18,72,10,208,4,48,48,4,72,10,140,17,80,9,160,5,174,38,82,88,82,134,30,92,0,32 },
  { 3,128,4,64,4,64,8,32,0,40,57,24,27,56,41,0,33,8,67,132,64,4,128,34,128,66,126,252,0,64,0,32 },
  { 3,128,4,64,4,64,8,32,0,40,59,24,24,184,41,0,34,8,67,132,64,4,128,34,128,66,126,252,0,64,0,32 },
  { 3,128,4,64,4,64,8,32,0,40,57,24,24,184,43,0,32,136,67,4,64,4,128,34,128,66,126,252,0,64,0,32 },
  { 3,128,4,64,4,64,8,32,0,40,58,152,26,184,43,128,32,136,64,132,64,4,128,34,128,66,126,252,0,64,0,32 },
  { 3,128,4,64,4,64,8,32,0,40,59,152,26,56,43,0,32,136,67,4,64,4,128,34,128,66,126,252,0,64,0,32 },
  { 3,128,4,64,4,64,8,32,0,40,57,152,26,56,43,128,34,72,65,132,64,4,128,34,128,66,126,252,0,64,0,32 },
  { 3,128,4,64,4,64,8,32,0,40,59,152,24,184,41,0,33,8,65,4,64,4,128,34,128,66,126,252,0,64,0,32 },
  { 3,128,4,64,4,64,8,32,0,40,56,24,24,56,40,0,32,8,64,4,64,4,128,34,128,66,126,252,0,64,0,32 },
  { 3,192,5,224,14,248,30,120,14,240,4,48,48,4,120,14,252,31,112,15,224,7,238,38,94,120,94,254,30,124,0,32 },
  { 7,224,31,248,62,124,125,190,123,222,255,143,247,223,231,255,243,239,247,239,239,247,111,182,113,14,63,188,31,248,7,224 },
  { 7,224,24,24,33,132,66,66,68,34,128,113,136,33,152,1,140,17,136,17,144,9,80,74,78,242,32,68,24,24,7,224 },
  { 0,0,0,0,0,0,7,0,24,192,32,32,64,16,77,144,146,72,146,72,77,144,64,16,32,32,24,192,7,0,0,0 },
  { 0,0,0,0,0,0,6,0,6,0,4,0,7,128,4,0,23,224,32,32,32,16,32,80,16,140,15,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,240,16,16,16,16,16,16,17,16,16,16,16,16,16,16,31,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,240,16,16,16,16,20,16,16,16,16,80,16,16,16,16,31,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,240,16,16,20,16,16,16,17,16,16,16,16,80,16,16,31,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,240,16,16,20,80,16,16,16,16,16,16,20,80,16,16,31,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,240,16,16,20,80,16,16,17,16,16,16,20,80,16,16,31,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,240,16,16,20,80,16,16,20,80,16,16,20,80,16,16,31,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,0,24,192,32,32,64,16,64,16,128,200,128,200,64,16,64,16,32,32,24,192,7,0,0,0 },
  { 0,0,0,0,0,0,7,0,24,192,32,32,64,16,64,16,152,200,152,200,64,16,64,16,32,32,24,192,7,0,0,0 },
  { 0,0,0,0,0,0,7,0,31,192,63,224,127,240,127,240,255,56,255,56,127,240,127,240,63,224,15,128,7,0,0,0 },
  { 0,0,0,0,0,0,7,0,31,192,63,224,127,240,127,240,231,56,231,56,127,240,127,240,63,224,15,128,7,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,252,127,252,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,124,124,124,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,127,252,127,252,0,0,0,0,127,252,127,252,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,124,124,124,124,0,0,0,0,127,252,127,252,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,127,252,127,252,0,0,0,0,124,124,124,124,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,124,124,124,124,0,0,0,0,124,124,124,124,0,0,0,0,0,0,0,0 },
  { 0,0,0,112,78,66,66,114,78,64,64,64,64,64,0,0 },
  { 0,0,0,112,126,126,126,126,78,64,64,64,64,64,0,0 },
  { 0,0,7,50,95,124,62,126,124,31,248,39,116,67,34,129,1,0,2,128,4,64,8,32,16,16,32,8,64,4,0,0 },
  { 0,0,0,0,1,192,2,32,2,32,1,192,0,128,3,224,0,128,32,132,112,142,32,132,16,136,15,240,0,0,0,0 },
  { 0,0,64,4,32,8,16,16,8,32,4,64,2,128,1,0,2,128,4,64,40,40,16,16,40,40,64,4,0,0,0,0 },
  { 0,0,1,0,1,0,15,240,17,48,17,0,15,192,1,32,1,32,7,192,9,0,7,128,1,64,3,128,1,0,0,0 },
  { 0,0,0,0,0,0,1,0,17,16,127,252,57,56,84,84,84,84,146,146,146,146,254,254,124,124,56,56,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,15,224,23,240,35,240,33,224,32,0,3,224,4,144,8,136,0,0,0,0 },
  { 0,0,0,0,3,128,4,64,4,64,4,64,3,128,1,0,57,56,61,120,29,112,13,96,3,128,1,0,1,0,0,0 },
  { 0,0,0,0,1,0,33,8,23,208,8,32,16,16,16,16,113,28,16,16,16,16,8,32,23,208,33,8,1,0,0,0 },
  { 0,0,1,0,2,128,57,56,127,252,253,126,5,64,3,128,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0 },
  { 1,128,2,64,2,64,116,46,142,113,133,161,78,114,53,172,53,172,78,114,133,161,142,113,116,46,2,64,2,64,1,128 },
  { 1,0,2,128,4,64,52,88,76,100,132,66,178,154,202,166,26,176,16,16,27,176,10,160,58,184,38,200,25,48,1,0 },
  { 1,0,2,128,4,64,4,64,8,0,107,252,136,2,136,34,96,36,24,16,6,80,0,136,33,8,38,72,24,48,0,0 },
  { 48,0,12,0,3,0,0,192,0,48,0,12,0,0,63,252,0,0,0,12,0,48,0,192,3,0,12,0,48,0,0,0 },
  { 0,12,0,48,0,192,3,0,12,0,48,0,0,0,63,252,0,0,48,0,12,0,3,0,0,192,0,48,0,12,0,0 },
  { 0,0,1,0,2,128,2,128,4,64,4,64,9,32,9,32,17,16,17,16,33,8,32,8,65,4,64,4,127,252,0,0 },
  { 0,0,0,0,2,4,8,16,32,126,4,8,16,32,64,0 },
  { 0,0,0,0,0,0,0,0,0,0,14,224,17,16,34,136,34,136,17,16,14,224,4,64,14,224,4,64,0,0,0,0 },
  { 0,0,0,0,0,0,1,192,0,192,1,64,14,56,17,24,35,168,37,64,26,32,12,32,4,64,3,128,0,0,0,0 },
  { 0,0,0,56,0,24,0,40,1,192,2,32,7,16,10,144,17,96,16,192,8,128,7,0,2,0,7,0,2,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,112,0,48,0,80,3,128,4,64,8,32,8,32,4,64,3,128,1,0,3,128,1,0 },
  { 0,0,0,0,0,0,0,0,0,56,0,24,0,168,0,64,14,160,17,0,32,128,32,128,17,0,14,0,0,0,0,0 },
  { 0,0,0,0,0,0,224,14,192,6,168,10,16,16,43,160,4,64,8,32,8,32,4,64,3,128,1,0,3,128,1,0 },
  { 0,0,16,56,84,16,56,16,56,68,130,130,68,56,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,68,16,130,136,131,252,130,136,68,16,56,0,0,0 },
  { 0,0,0,0,0,0,0,0,56,68,130,130,130,68,56,0 },
  { 0,0,0,0,0,0,0,0,56,124,254,254,254,124,56,0 },
  { 0,0,0,0,0,0,0,0,0,28,34,34,34,28,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,224,17,16,34,136,34,136,17,16,14,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,14,184,17,196,17,196,17,196,14,184,0,128,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,56,68,68,71,196,68,68,56,56,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,0,9,224,16,31,32,0,32,0,32,0,32,0,16,31,9,224,6,0,0,0,0,0 },
  { 0,0,7,192,2,128,15,224,16,16,32,8,32,8,16,16,16,16,16,16,8,32,8,32,8,32,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,56,68,130,130,68,56,16,16,16 },
  { 0,0,0,0,0,0,0,112,136,4,4,8,48,32,248,32 },
  { 0,0,0,0,0,0,16,40,68,130,68,40,16,16,124,16 },
  { 0,0,0,0,0,0,146,84,56,254,56,84,146,16,124,16 },
  { 0,0,0,0,0,0,1,0,1,0,1,0,1,0,57,56,4,64,2,128,121,60,4,64,2,128,1,0,0,0,0,0 },
  { 0,0,0,18,20,24,20,18,16,56,68,68,68,56,0,0 },
  { 0,0,0,0,0,0,28,56,112,112,112,56,28,8,62,8 },
  { 0,0,0,0,66,36,24,255,24,36,66,0,0,0,0,0 },
  { 0,0,0,0,0,0,68,68,68,40,40,40,16,254,0,0 },
  { 0,0,0,0,0,0,254,16,40,40,40,68,68,68,0,0 },
  { 0,0,0,0,0,0,126,66,66,66,74,126,32,126,0,0 },
  { 0,0,0,0,7,0,28,192,60,224,92,240,64,16,135,8,143,136,231,56,112,112,96,48,39,32,31,192,7,0,0,0 },
  { 0,0,0,0,7,0,24,192,48,96,72,144,64,16,133,8,128,8,133,8,64,16,72,144,48,96,24,192,7,0,0,0 },
  { 0,0,0,0,127,252,64,4,67,132,68,68,68,68,67,132,65,4,65,4,65,4,65,196,65,4,64,4,127,252,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,224,24,24,33,132,33,132,56,28,47,244,42,84,26,88,7,224,0,0,0,0 },
  { 0,0,0,0,7,224,24,24,33,132,33,132,56,28,47,244,42,84,58,92,47,244,42,84,26,88,7,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,240,56,28,103,230,94,122,94,122,71,226,80,10,85,170,101,166,56,28,15,240,0,0 },
  { 0,0,15,240,56,28,103,230,94,122,94,122,71,226,80,10,85,170,69,162,80,10,85,170,101,166,56,28,15,240,0,0 },
  { 3,192,3,192,15,240,4,32,10,80,8,16,10,80,9,144,4,32,7,224,8,16,16,136,120,30,16,136,8,16,7,224 },
  { 0,0,0,0,0,0,1,32,1,72,0,16,0,192,7,44,9,160,16,96,32,16,32,16,16,96,15,128,0,0,0,0 },
  { 0,0,34,34,68,68,0,136,16,0,34,34,68,68,0,136,16,0,34,34,68,68,0,128,16,18,34,36,68,72,0,0 },
  { 139,200,3,192,47,241,7,228,141,176,47,242,13,176,78,116,7,225,71,224,15,240,31,120,127,254,31,120,15,240,7,224 },
  { 0,0,7,32,8,204,16,178,33,2,32,130,17,4,10,24,7,224,32,0,68,64,0,128,16,16,34,32,68,64,0,0 },
  { 0,0,0,0,0,0,63,248,63,248,32,8,32,8,32,8,32,8,32,8,32,8,32,8,48,24,12,96,3,128,1,0 },
  { 0,0,0,0,0,0,63,248,63,248,63,248,63,248,63,248,63,248,63,248,63,248,63,248,63,248,15,224,3,128,1,0 },
  { 0,0,0,0,0,0,127,240,69,16,72,144,80,80,96,48,64,16,96,48,80,80,72,144,69,16,127,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,32,16,64,8,128,4,0,2,0,1,0,8,128,16,64,32,32,0,0,0,0,0,0 },
  { 0,0,60,0,66,0,66,0,129,0,255,0,255,0,255,0,66,0,66,0,0,64,0,160,1,16,2,8,4,4,15,254 },
  { 0,0,0,0,0,0,0,0,0,0,4,64,4,64,4,80,30,72,37,72,36,240,20,64,4,64,6,96,0,0,0,0 },
  { 0,0,64,192,39,0,28,0,28,0,62,0,51,0,33,128,64,192,64,96,0,48,0,24,0,12,0,6,0,0,0,0 },
  { 0,0,0,224,3,16,5,200,3,248,4,232,0,48,0,64,28,0,33,128,34,0,26,192,2,32,60,32,0,0,0,0 },
  { 0,0,0,0,7,0,29,192,56,224,125,240,255,248,64,16,64,16,64,16,32,32,32,32,24,192,7,0,0,0,0,0 },
  { 0,0,0,0,7,0,24,192,32,32,80,80,72,144,129,8,130,8,132,8,72,144,80,80,32,32,24,192,7,0,0,0 },
  { 0,0,34,16,42,56,28,84,8,68,28,68,42,84,34,56,34,16,42,56,28,84,8,68,28,68,42,84,34,56,0,16 },
  { 0,0,0,0,0,0,7,0,31,192,63,224,127,240,127,240,192,24,192,24,127,240,127,240,63,224,31,192,7,0,0,0 },
  { 0,0,0,0,12,48,30,48,45,48,12,48,8,224,11,192,10,0,11,192,8,224,12,48,12,180,12,120,12,48,0,0 },
  { 0,0,0,0,1,128,3,192,7,224,11,208,17,216,42,220,123,222,59,84,27,136,15,208,7,224,3,192,1,128,0,0 },
  { 0,0,1,128,2,64,4,32,8,16,20,40,46,36,85,34,132,33,68,170,36,116,16,40,8,16,4,32,2,64,1,128 },
  { 0,0,0,0,7,252,7,252,7,252,15,252,31,252,63,252,63,252,63,252,63,252,63,252,63,252,63,252,0,0,0,0 },
  { 0,0,0,0,24,6,25,6,25,6,25,6,48,6,97,6,193,6,193,6,192,6,193,6,193,6,193,6,0,0,0,0 },
  { 0,0,0,0,120,30,120,30,112,14,96,6,0,0,0,0,0,0,0,0,96,6,112,14,120,30,120,30,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,240,24,48,12,96,12,96,6,192,7,192,3,128,3,128,1,0,1,0,0,0,0,0 },
  { 0,0,0,0,24,3,24,67,24,67,24,67,48,3,96,67,192,67,192,67,196,3,196,67,196,67,196,67,0,0,0,0 },
  { 0,0,0,0,0,0,63,248,48,24,40,40,36,72,34,136,33,8,34,136,36,72,40,40,48,24,63,248,0,0,0,0 },
  { 0,0,0,0,253,248,248,248,224,56,208,24,200,24,132,8,2,0,129,8,192,152,192,88,224,56,248,248,253,248,0,0 },
  { 0,0,0,0,127,240,127,240,127,252,127,242,127,242,127,254,127,254,127,254,111,246,87,234,56,28,16,8,0,0,0,0 },
  { 0,0,127,254,62,2,28,66,8,66,0,2,0,66,0,66,0,2,0,66,0,66,0,2,0,66,0,66,0,2,0,0 },
  { 0,0,64,0,96,0,112,0,120,0,112,0,96,0,64,0,64,128,64,64,66,32,70,16,78,8,94,4,127,254,0,0 },
  { 0,0,0,16,56,124,16,16,124,130,186,186,130,124,0,0 },
  { 0,0,1,0,25,48,25,48,1,0,1,0,3,128,12,96,8,32,16,16,16,16,16,16,8,32,12,96,3,128,0,0 },
  { 0,0,1,0,1,0,2,128,2,128,2,128,127,252,36,72,20,80,12,96,10,160,9,32,22,208,24,48,32,8,0,0 },
  { 0,0,1,0,1,0,2,128,2,128,0,128,127,92,32,72,20,16,8,96,10,0,9,32,20,208,24,48,32,8,0,0 },
  { 0,0,1,0,1,0,2,128,2,128,2,0,117,252,36,8,16,80,12,32,0,160,9,32,22,80,24,48,32,8,0,0 },
  { 0,0,32,8,24,48,22,208,9,32,10,160,12,96,20,80,36,72,127,252,2,128,2,128,2,128,1,0,1,0,0,0 },
  { 0,0,0,0,0,0,63,240,32,16,35,16,35,16,47,208,47,208,35,16,35,16,32,16,48,48,12,192,3,0,0,0 },
  { 0,0,0,0,255,254,16,16,16,16,16,16,31,240,16,16,16,16,16,16,16,16,16,16,16,16,16,16,0,0,0,0 },
  { 1,0,1,0,7,192,1,0,1,0,3,128,7,192,31,240,124,124,56,56,51,152,55,216,55,216,55,216,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,8,128,120,240,64,16,64,16,64,16,64,16,64,16,64,16,64,16,64,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,1,128,0,0,0,0,0,0,0,0,12,48,12,48,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,17,16,11,160,4,64,8,32,56,56,8,32,4,64,11,160,17,16,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,17,16,11,160,4,68,8,36,120,60,72,32,68,64,11,160,17,16,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,17,16,11,160,4,64,11,160,59,184,11,160,4,64,11,160,17,16,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,0,1,0,3,128,3,128,7,192,7,192,15,224,15,224,31,240,31,240,0,0,0,0 },
  { 0,0,7,224,24,24,40,36,71,226,121,30,65,2,2,0,2,0,2,0,4,0,4,0,4,0,127,254,127,254,0,0 },
  { 0,0,20,80,34,136,66,132,64,4,67,132,71,196,7,192,0,0,127,252,63,248,15,224,15,224,31,240,63,248,0,0 },
  { 0,0,1,128,1,224,1,248,1,0,1,0,1,0,1,0,1,0,61,120,125,124,252,126,126,252,63,248,7,192,0,0 },
  { 0,0,0,0,3,0,3,0,3,0,7,224,10,80,18,72,34,72,255,252,63,248,31,248,15,240,0,0,0,0,0,0 },
  { 0,0,1,0,1,128,1,64,5,64,13,32,21,32,37,16,69,16,253,248,1,0,255,252,63,248,31,248,15,240,0,0 },
  { 0,0,56,28,64,2,64,2,64,2,0,0,0,0,0,0,0,0,0,0,0,0,64,2,64,2,64,2,56,28,0,0 },
  { 0,0,0,0,56,0,56,0,56,0,6,0,14,32,127,240,28,32,28,12,14,48,15,192,3,0,28,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,240,0,240,0,240,0,240,31,240,63,240,63,224,8,64,63,248,0,0,0,0 },
  { 0,0,3,128,3,128,3,128,0,0,3,252,7,128,11,128,19,140,35,140,3,128,6,192,6,192,12,96,12,96,120,60 },
  { 0,0,6,0,5,0,14,128,14,64,14,32,31,16,31,8,31,4,63,130,63,132,49,136,113,200,113,208,113,224,0,0 },
  { 0,0,0,0,7,192,24,48,32,8,48,24,8,32,4,64,4,64,4,64,8,32,48,24,32,8,24,48,7,192,0,0 },
  { 0,0,0,0,1,0,1,0,1,0,1,0,7,192,0,0,0,0,16,16,16,16,16,16,16,16,124,124,0,0,0,0 },
  { 0,0,0,0,15,128,31,216,16,68,16,66,31,242,31,202,31,202,31,202,31,202,31,196,31,192,127,240,0,0,0,0 },
  { 0,0,127,254,127,254,112,6,112,26,112,26,112,26,112,6,120,14,124,30,79,242,71,226,96,6,120,30,127,254,0,0 },
  { 0,0,0,0,127,252,64,4,64,4,127,252,127,252,64,4,64,4,127,252,64,0,64,0,64,0,64,0,64,0,0,0 },
  { 0,0,0,0,112,8,248,60,216,120,254,240,127,224,7,192,127,224,254,240,216,120,248,60,112,8,0,0,0,0,0,0 },
  { 0,0,56,0,124,0,108,0,124,0,60,0,14,0,127,252,255,254,217,192,248,224,112,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,112,12,248,56,216,112,254,224,127,192,7,128,127,192,254,224,216,112,248,56,112,12,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,112,0,248,224,217,192,255,254,127,252,14,0,60,0,124,0,108,0,124,0,56,0,0,0 },
  { 0,0,0,0,112,12,136,50,174,68,129,136,121,16,6,32,120,80,129,136,174,68,136,50,112,12,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,0,10,0,18,0,36,32,72,80,144,81,32,42,64,36,128,17,0,14,0,0,0 },
  { 7,192,24,48,32,8,65,196,71,228,143,242,143,114,158,98,156,2,159,2,79,4,70,4,32,8,24,48,7,192,0,0 },
  { 7,192,25,48,35,136,67,132,65,4,131,130,135,194,135,194,135,194,139,162,92,116,88,52,32,8,24,48,7,192,0,0 },
  { 0,0,8,0,15,0,6,0,7,192,195,128,227,192,127,254,127,254,227,192,195,128,7,192,6,0,15,0,8,0,0,0 },
  { 0,0,0,0,0,0,0,0,127,254,96,6,88,26,70,98,89,154,96,6,127,254,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,96,12,144,20,144,53,248,85,4,84,228,84,196,55,4,40,8,16,16,15,224,0,0 },
  { 0,0,10,128,21,64,21,64,53,64,85,64,85,76,85,82,64,34,64,4,64,8,32,16,16,16,15,224,0,0,0,0 },
  { 24,48,36,72,34,136,18,144,17,16,9,32,8,32,124,252,146,130,146,114,146,34,146,66,124,4,32,8,31,240,0,0 },
  { 0,0,0,8,0,28,0,56,3,247,12,245,17,205,35,133,71,5,111,229,18,5,47,253,112,5,96,7,0,0,0,0 },
  { 0,0,0,0,24,0,38,0,85,0,74,128,113,64,40,160,20,80,10,40,5,40,2,200,1,24,0,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,63,240,80,40,143,244,168,22,143,244,80,40,63,240,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,248,1,24,2,200,5,40,10,40,20,80,40,160,113,64,74,128,85,0,38,0,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,240,121,8,134,108,128,254,134,108,121,8,0,240,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,224,121,240,255,56,255,14,255,56,121,240,0,224,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,4,0,8,0,16,64,32,64,64,32,128,33,0,18,0,20,0,8,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,0,14,64,28,224,56,224,112,112,224,113,192,59,128,63,0,30,0,12,0,0,0 },
  { 0,0,0,0,16,16,56,56,28,112,14,224,7,192,3,128,7,192,14,224,28,112,56,56,16,16,0,0,0,0,0,0 },
  { 16,16,56,56,124,124,254,254,127,252,63,248,31,240,15,224,31,240,63,248,127,252,254,254,124,124,56,56,16,16,0,0 },
  { 0,0,96,24,48,96,49,192,27,0,14,0,14,0,27,0,25,128,48,192,48,96,96,48,96,24,32,0,0,0,0,0 },
  { 0,0,96,24,112,112,49,224,59,128,31,0,14,0,31,0,27,128,57,192,48,224,112,112,96,56,96,16,32,0,0,0 },
  { 7,192,4,64,5,64,5,64,5,64,253,126,129,2,191,250,129,2,253,126,5,64,5,64,5,64,4,64,7,192,0,0 },
  { 7,192,7,192,7,192,7,192,7,192,255,254,255,254,255,254,255,254,255,254,7,192,7,192,7,192,7,192,7,192,0,0 },
  { 3,128,3,128,3,128,3,128,3,128,3,128,252,126,252,126,252,126,3,128,3,128,3,128,3,128,3,128,3,128,0,0 },
  { 7,192,7,192,7,192,7,192,7,192,248,62,248,62,248,62,248,62,248,62,7,192,7,192,7,192,7,192,7,192,0,0 },
  { 0,0,0,0,3,128,3,128,3,128,31,240,31,240,31,240,3,128,3,128,3,128,3,128,3,128,0,0,0,0,0,0 },
  { 7,128,4,192,4,192,4,192,124,248,64,12,64,12,124,252,60,252,4,192,4,192,4,192,4,192,7,192,3,192,0,0 },
  { 0,0,15,224,8,32,123,188,67,132,95,244,95,244,95,244,67,132,123,188,11,160,11,160,11,160,8,32,15,224,0,0 },
  { 31,240,7,192,3,128,131,130,131,130,195,134,255,254,255,254,255,254,195,134,131,130,131,130,3,128,7,192,31,240,0,0 },
  { 1,0,1,0,2,128,255,254,68,68,40,40,40,40,16,16,40,40,40,40,68,68,255,254,2,128,1,0,1,0,0,0 },
  { 3,128,7,192,7,192,3,128,3,128,97,12,249,62,255,254,249,62,97,12,3,128,3,128,7,192,7,192,3,128,0,0 },
  { 3,128,7,192,7,192,7,192,3,128,113,28,249,62,255,254,249,62,113,28,3,128,7,192,7,192,7,192,3,128,0,0 },
  { 7,192,15,224,15,224,7,192,99,140,243,158,255,254,255,254,255,254,243,158,99,140,7,192,15,224,15,224,7,192,0,0 },
  { 1,0,3,128,7,192,7,192,1,0,49,12,113,14,255,255,113,14,49,12,1,0,7,192,7,192,3,128,1,0,0,0 },
  { 1,0,3,128,3,128,7,192,7,192,31,240,127,252,255,254,127,252,31,240,7,192,7,192,3,128,3,128,1,0,0,0 },
  { 1,0,2,128,2,128,4,64,4,64,24,48,96,12,128,2,96,12,24,48,4,64,4,64,2,128,2,128,1,0,0,0 },
  { 0,0,4,0,4,0,10,0,17,0,96,192,17,16,10,16,4,40,4,198,0,40,0,16,1,16,2,128,1,0,0,0 },
  { 0,0,1,0,2,128,2,128,252,126,64,4,56,56,8,32,16,16,17,16,38,200,40,40,48,24,0,0,0,0,0,0 },
  { 7,192,31,240,62,248,126,252,124,124,192,6,240,30,248,62,240,30,241,30,103,204,111,236,63,248,31,240,7,192,0,0 },
  { 0,0,1,0,3,128,3,128,255,254,124,124,56,56,8,32,28,112,31,240,62,248,56,56,48,24,0,0,0,0,0,0 },
  { 0,0,1,0,2,128,2,128,252,126,67,132,39,200,23,208,19,144,16,16,39,200,40,40,48,24,0,0,0,0,0,0 },
  { 0,0,1,0,2,128,28,112,225,14,79,228,35,136,23,208,20,80,17,16,34,136,44,104,48,24,0,0,0,0,0,0 },
  { 0,0,1,0,2,128,29,112,227,142,95,244,47,232,23,208,22,208,21,80,34,136,44,104,48,24,0,0,0,0,0,0 },
  { 0,0,1,0,3,128,5,192,249,254,93,140,39,184,19,240,15,208,29,144,25,208,50,232,44,120,48,24,0,0,0,0 },
  { 0,0,1,0,2,128,2,192,255,254,68,71,56,62,8,60,22,208,17,24,39,200,47,44,60,28,24,12,0,0,0,0 },
  { 0,0,3,128,3,128,3,128,67,132,243,158,63,252,15,240,63,252,243,158,67,132,3,128,3,128,3,128,0,0,0,0 },
  { 0,0,3,128,3,128,3,128,67,132,243,158,60,124,8,48,60,124,243,158,67,132,3,128,3,128,3,128,0,0,0,0 },
  { 1,0,1,0,33,8,17,16,13,96,15,224,7,192,255,254,7,192,15,224,13,96,17,16,33,8,1,0,1,0,0,0 },
  { 1,0,1,0,33,8,27,176,31,240,15,224,31,224,255,254,31,240,15,224,31,240,27,176,33,8,1,0,1,0,0,0 },
  { 1,0,2,128,60,248,44,200,38,152,50,184,125,76,131,134,77,124,58,152,50,200,38,104,62,120,2,128,1,0,0,0 },
  { 0,0,1,0,1,0,1,0,67,132,59,184,31,240,15,224,31,240,59,184,67,132,1,0,1,0,1,0,0,0,0,0 },
  { 8,32,8,32,12,96,6,192,230,206,59,184,31,240,7,192,31,240,59,184,230,206,6,192,12,96,8,32,8,32,0,0 },
  { 8,32,12,96,14,224,15,224,255,254,127,252,63,248,31,240,63,248,127,252,255,254,15,224,14,224,12,96,8,32,0,0 },
  { 1,0,25,48,15,224,79,228,127,252,63,248,63,248,255,254,63,248,63,248,127,252,79,228,15,224,25,48,1,0,0,0 },
  { 9,32,73,36,37,72,21,80,203,166,55,216,15,224,255,254,15,224,55,216,203,166,21,80,37,72,73,36,9,32,0,0 },
  { 1,0,3,128,3,128,3,128,225,14,113,28,13,96,3,128,13,96,113,28,225,14,3,128,3,128,3,128,1,0,0,0 },
  { 3,128,7,192,7,192,99,140,241,30,243,158,60,120,8,32,60,120,243,158,241,30,99,140,7,192,7,192,3,128,0,0 },
  { 3,128,7,192,7,192,99,140,243,158,241,30,61,120,7,192,61,120,241,30,243,158,99,140,7,192,7,192,3,128,0,0 },
  { 3,128,4,64,4,64,116,92,252,126,254,254,127,252,33,8,67,132,135,194,143,226,119,220,7,192,7,192,3,128,0,0 },
  { 3,128,7,192,15,224,119,220,255,254,252,126,240,30,112,28,24,48,62,248,127,252,126,252,126,252,60,120,0,0,0,0 },
  { 3,128,4,64,9,32,121,60,133,66,179,154,143,226,111,236,23,208,39,200,73,36,82,148,66,132,60,120,0,0,0,0 },
  { 3,128,60,120,69,68,81,20,77,100,111,236,134,194,188,122,134,194,111,236,77,100,81,20,69,68,60,120,3,128,0,0 },
  { 7,192,30,240,62,248,92,116,103,204,252,126,232,46,136,34,232,46,252,126,103,204,92,116,62,248,30,240,7,192,0,0 },
  { 3,128,4,192,4,192,116,220,188,230,159,158,79,60,63,248,114,100,230,114,206,122,118,92,6,64,6,64,3,128,0,0 },
  { 0,0,1,0,5,64,3,128,201,38,49,24,77,100,3,128,77,100,49,24,201,38,3,128,5,64,1,0,0,0,0,0 },
  { 0,0,1,0,5,64,11,160,201,38,49,24,77,100,131,130,77,100,49,24,201,38,11,160,5,64,1,0,0,0,0,0 },
  { 9,32,13,96,7,192,19,144,201,38,49,24,237,110,3,128,237,110,49,24,201,38,17,16,7,192,13,96,9,32,0,0 },
  { 0,0,3,192,35,196,19,200,9,144,5,160,112,14,125,190,125,190,112,14,5,160,9,144,19,200,35,196,3,192,0,0 },
  { 7,192,71,196,39,200,19,144,11,160,224,14,251,190,251,190,251,190,224,14,11,160,19,144,39,200,71,196,7,192,0,0 },
  { 3,128,7,192,7,192,119,220,251,190,249,62,125,124,7,192,125,124,249,62,251,190,119,220,7,192,7,192,3,128,0,0 },
  { 1,0,3,128,51,152,49,24,9,32,5,64,99,140,255,254,99,140,5,64,9,32,49,24,51,152,3,128,1,0,0,0 },
  { 1,0,3,128,51,152,59,184,25,48,7,192,119,220,255,254,119,220,7,192,25,48,59,184,51,152,3,128,1,0,0,0 },
  { 0,0,0,0,24,48,60,120,30,240,15,224,7,192,7,192,15,224,30,240,60,120,56,56,16,16,0,0,0,0,0,0 },
  { 0,0,0,0,3,192,12,48,16,8,16,12,32,4,32,6,32,6,32,6,16,14,16,12,12,60,3,248,1,224,0,0 },
  { 0,0,255,248,223,216,143,136,199,24,226,56,240,120,248,248,240,120,226,56,199,24,143,136,223,216,255,248,0,0,0,0 },
  { 0,0,31,248,16,8,16,14,16,14,16,14,16,14,16,14,16,14,16,14,31,254,7,254,7,254,0,0,0,0,0,0 },
  { 0,0,7,254,7,254,31,254,16,14,16,14,16,14,16,14,16,14,16,14,16,14,16,8,31,248,0,0,0,0,0,0 },
  { 0,0,31,248,16,12,16,14,16,14,16,14,16,14,16,14,16,14,16,14,31,254,15,254,7,254,0,0,0,0,0,0 },
  { 0,0,7,254,15,254,31,254,16,14,16,14,16,14,16,14,16,14,16,14,16,14,16,12,31,248,0,0,0,0,0,0 },
  { 0,0,3,128,15,224,30,112,24,48,24,240,1,224,3,128,3,0,3,0,3,0,0,0,3,0,7,128,7,128,3,0 },
  { 7,192,8,32,19,144,20,80,8,80,0,144,1,32,2,64,2,128,2,128,3,128,0,0,3,128,4,64,4,64,3,128 },
  { 3,128,6,192,12,96,8,32,12,96,4,64,6,192,2,128,2,128,3,128,0,0,3,128,4,64,4,64,3,128,0,0 },
  { 0,0,1,0,3,128,7,192,3,128,17,16,56,56,124,124,56,56,17,16,3,128,7,192,3,128,1,0,0,0,0,0 },
  { 1,128,3,192,3,192,3,192,3,192,3,192,3,192,1,128,1,128,1,128,1,128,0,0,1,128,1,128,0,0,0,0 },
  { 1,128,1,128,1,128,1,128,1,128,1,128,1,128,1,128,1,128,1,128,1,128,1,128,1,128,1,128,1,128,0,0 },
  { 3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,0,0 },
  { 15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,0,0 },
  { 1,192,7,0,12,0,15,128,15,192,15,224,15,224,15,224,7,192,3,128,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 3,128,7,192,15,224,15,224,15,224,7,224,3,224,0,96,1,192,7,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 28,28,112,112,192,192,248,248,252,252,254,254,254,254,254,254,124,124,56,56,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 56,56,124,124,254,254,254,254,254,254,126,126,62,62,6,6,28,28,112,112,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,0,15,128,31,192,31,192,31,192,15,192,7,192,0,192,3,128,14,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,56,56,124,124,254,254,254,254,254,254,126,126,62,62,6,6,28,28,112,112,0,0,0,0 },
  { 0,0,0,16,0,16,15,254,63,248,126,16,126,16,63,16,15,240,0,16,48,48,120,32,120,96,49,192,31,0,0,0 },
  { 3,128,15,224,31,240,31,240,31,240,15,224,3,128,1,0,1,0,0,0,3,128,7,192,7,192,7,192,3,128,0,0 },
  { 0,0,14,224,31,240,31,240,31,240,15,224,3,128,1,0,0,0,3,128,7,192,7,192,7,192,3,128,0,0,0,0 },
  { 0,0,0,0,60,120,126,252,255,254,255,254,255,254,127,252,127,252,63,248,31,240,15,224,7,192,3,128,1,0,0,0 },
  { 28,0,63,0,127,128,127,192,127,224,127,240,63,248,31,252,63,248,127,240,127,224,127,192,127,128,63,0,28,0,0,0 },
  { 0,0,3,0,12,134,56,142,103,248,1,0,57,56,126,252,255,254,255,254,127,252,63,248,31,226,7,238,0,248,0,0 },
  { 0,0,48,204,49,228,27,246,11,242,11,254,9,254,57,254,78,252,73,252,41,252,51,248,19,248,27,240,9,224,0,192 },
  { 0,0,0,2,4,12,24,24,24,24,24,24,12,4,2,0 },
  { 0,0,0,32,16,24,12,12,12,12,12,12,24,16,32,0 },
  { 0,0,0,6,12,28,56,56,56,56,56,56,28,12,6,0 },
  { 0,0,0,48,24,28,14,14,14,14,14,14,28,24,48,0 },
  { 0,0,0,6,12,12,24,24,48,48,24,24,12,12,6,0 },
  { 0,0,0,48,24,24,12,12,6,6,12,12,24,24,48,0 },
  { 0,0,0,7,14,14,28,28,56,56,28,28,14,14,7,0 },
  { 0,0,0,112,56,56,28,28,14,14,28,28,56,56,112,0 },
  { 0,0,0,15,30,30,60,60,120,120,60,60,30,30,15,0 },
  { 0,0,0,240,120,120,60,60,30,30,60,60,120,120,240,0 },
  { 0,0,0,4,8,16,16,16,16,16,16,16,16,8,4,0 },
  { 0,0,0,32,16,8,8,8,8,8,8,8,8,16,32,0 },
  { 0,0,0,30,56,48,48,24,24,112,24,24,48,56,30,0 },
  { 0,0,0,120,28,12,12,24,24,14,24,24,12,28,120,0 },
  { 7,192,31,240,63,248,126,252,124,252,250,254,254,254,254,254,254,254,254,254,126,252,120,60,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,124,124,123,188,251,190,255,190,255,126,254,254,253,254,123,252,120,60,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,124,124,123,188,251,190,255,190,254,126,255,190,251,190,123,188,124,124,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,127,124,126,124,253,126,251,126,247,126,240,62,255,126,127,124,127,124,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,120,60,123,252,251,254,251,254,248,126,255,190,255,190,123,188,124,124,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,126,124,125,252,251,254,251,254,248,126,251,190,251,190,123,188,124,124,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,120,60,127,188,255,190,255,126,255,126,255,126,254,254,126,252,126,252,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,124,124,123,188,251,190,251,190,252,126,251,190,251,190,123,188,124,124,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,124,124,123,188,251,190,251,190,252,62,255,190,255,190,127,124,124,252,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,127,252,123,156,243,110,235,110,251,110,251,110,251,110,96,156,127,252,63,248,31,240,7,192,0,0 },
  { 7,192,24,48,32,8,64,132,65,132,131,130,129,130,129,130,129,130,129,130,65,132,65,132,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,196,79,228,140,98,128,98,129,194,135,2,140,2,79,228,79,228,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,196,79,228,140,98,128,98,129,194,128,98,140,98,79,228,71,196,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,64,228,65,228,131,98,134,98,140,98,159,242,159,242,64,100,64,100,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,79,228,79,228,140,2,143,194,143,226,128,98,140,98,79,228,71,196,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,196,79,228,140,2,143,194,143,226,140,98,140,98,79,228,71,196,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,79,228,79,228,128,98,128,98,128,194,131,130,134,2,70,4,70,4,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,196,79,228,140,98,140,98,135,194,140,98,140,98,79,228,71,196,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,71,196,79,228,140,98,140,98,143,226,135,226,128,98,79,228,71,196,32,8,24,48,7,192,0,0 },
  { 7,192,24,48,32,8,68,228,77,244,157,178,141,178,141,178,141,178,141,178,77,244,76,228,32,8,24,48,7,192,0,0 },
  { 7,192,31,240,63,248,127,124,126,124,252,126,254,126,254,126,254,126,254,126,126,124,126,124,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,120,60,112,28,243,158,255,158,254,62,248,254,243,254,112,28,112,28,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,120,60,112,28,243,158,255,158,254,62,255,158,243,158,112,28,120,60,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,127,28,126,28,252,158,249,158,243,158,224,14,224,14,127,156,127,156,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,112,28,112,28,243,254,240,62,240,30,255,158,243,158,112,28,120,60,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,120,60,112,28,243,254,240,62,240,30,243,158,243,158,112,28,120,60,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,112,28,112,28,255,158,255,158,255,62,252,126,249,254,121,252,121,252,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,120,60,112,28,243,158,243,158,248,62,243,158,243,158,112,28,120,60,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,120,60,112,28,243,158,243,158,240,30,248,30,255,158,112,28,120,60,63,248,31,240,7,192,0,0 },
  { 7,192,31,240,63,248,123,28,114,12,226,78,242,78,242,78,242,78,242,78,114,12,115,28,63,248,31,240,7,192,0,0 },
  { 0,0,31,128,15,192,7,224,3,240,255,248,255,252,255,254,255,252,255,248,3,240,7,224,15,192,31,128,0,0,0,0 },
  { 0,0,0,0,3,128,3,128,3,128,3,128,63,248,63,248,63,248,3,128,3,128,3,128,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,127,252,127,252,127,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,3,128,3,128,3,128,0,0,127,252,127,252,127,252,0,0,3,128,3,128,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,8,0,28,0,62,0,30,0,15,32,3,32,0,224,0,240,3,240,0,112,0,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,1,128,224,192,252,240,255,254,252,240,224,192,1,128,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,8,0,112,3,240,0,240,0,224,3,32,15,32,30,0,62,0,28,0,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,2,0,1,0,1,192,0,240,255,254,0,240,1,192,1,0,2,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,192,1,224,1,240,0,248,127,252,255,254,255,254,255,254,127,252,0,248,1,240,1,224,0,192,0,0,0,0 },
  { 0,0,0,0,0,16,0,16,0,24,0,24,255,252,255,254,255,252,0,24,0,24,0,16,0,16,0,0,0,0,0,0 },
  { 0,0,0,16,0,16,0,24,0,24,255,252,255,252,255,254,255,252,255,252,0,24,0,24,0,16,0,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,32,0,48,0,56,170,252,170,254,170,252,0,56,0,48,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,32,0,48,170,248,170,252,170,254,170,252,170,248,0,48,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,32,0,48,0,56,255,252,255,254,255,252,0,56,0,48,0,32,0,0,0,0,0,0,0,0 },
  { 64,0,112,0,44,0,35,0,16,192,16,48,8,12,7,254,15,252,31,240,31,192,63,0,60,0,112,0,64,0,0,0 },
  { 64,0,112,0,60,0,63,0,31,192,31,240,15,252,7,254,8,12,16,48,16,192,35,0,44,0,112,0,64,0,0,0 },
  { 64,0,112,0,60,0,63,0,31,192,31,240,15,252,7,254,15,252,31,240,31,192,63,0,60,0,112,0,64,0,0,0 },
  { 0,0,0,0,0,0,128,0,128,16,192,24,127,252,127,254,63,252,0,24,0,16,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,16,0,24,63,252,127,254,127,252,192,24,128,16,128,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,128,0,128,0,192,7,192,7,224,7,224,7,240,7,224,7,224,7,192,0,192,0,128,0,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,64,0,64,255,224,255,240,255,254,255,240,255,224,0,64,0,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,96,0,112,127,216,64,12,64,6,64,12,127,216,0,112,0,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,96,0,112,127,232,96,4,96,2,96,4,127,232,0,112,0,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,8,0,24,0,36,0,68,63,130,64,2,128,6,255,30,254,124,5,240,15,192,15,0,12,0,0,0 },
  { 0,0,12,0,15,0,15,192,5,240,254,124,255,30,128,6,64,2,63,130,0,68,0,36,0,24,0,8,0,0,0,0 },
  { 0,0,0,0,0,128,0,192,255,160,128,16,128,8,128,4,128,14,128,28,255,184,127,240,0,224,0,64,0,0,0,0 },
  { 0,0,0,64,0,224,127,240,255,184,128,28,128,14,128,4,128,8,128,16,255,160,0,192,0,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,64,0,96,0,80,255,200,64,4,64,2,64,7,255,206,127,220,0,120,0,112,0,32,0,0,0,0 },
  { 0,0,0,0,0,99,28,34,34,34,28,0,0,0,0,0 },
  { 0,0,0,32,0,112,0,120,127,220,255,206,64,7,64,2,64,4,255,200,0,80,0,96,0,64,0,0,0,0,0,0 },
  { 7,192,31,240,63,120,127,60,127,28,0,14,0,6,0,2,0,6,0,14,127,28,127,60,63,120,31,240,7,192,0,0 },
  { 0,0,0,0,0,0,0,0,254,0,73,8,36,140,31,254,36,140,73,8,254,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,4,0,6,0,7,0,63,0,31,0,15,8,0,136,0,88,0,56,0,120,1,248,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,124,8,62,12,31,254,62,12,124,8,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,248,0,120,0,56,0,88,0,136,15,8,31,0,63,0,7,0,6,0,4,0,0,0,0,0 },
  { 0,0,0,0,2,0,3,0,3,128,3,128,63,136,31,136,15,216,0,248,0,120,0,248,3,248,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,32,252,16,126,24,63,252,31,254,63,252,126,24,252,16,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,248,0,248,0,120,0,248,15,216,31,136,63,136,3,128,3,128,3,0,2,0,0,0,0,0 },
  { 0,0,0,0,0,96,0,240,0,240,120,56,255,12,255,254,255,12,120,56,0,240,0,240,0,96,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,64,96,224,120,240,252,120,255,254,252,120,120,240,96,224,0,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,248,16,124,24,62,28,31,254,62,28,124,24,248,16,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,248,96,252,112,126,120,127,252,63,254,127,252,126,120,252,112,248,96,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,2,32,1,16,0,136,255,196,0,2,255,196,0,136,1,16,2,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,227,199,28,56,34,68,34,68,34,68,28,56,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,68,72,80,96,126,0,0 },
  { 0,0,0,0,1,0,2,128,2,128,4,64,4,64,9,32,10,160,18,144,20,80,39,200,32,8,63,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,16,16,16,16,124,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,248,8,0,16,48,16,72,16,72,16,48,8,0,7,248,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,31,224,0,16,12,8,18,8,18,8,12,8,0,16,31,224,0,0,0,0,0,0 },
  { 0,0,0,0,28,34,34,4,4,8,8,16,16,14,0,0 },
  { 0,0,0,0,28,34,34,16,16,8,8,4,4,56,0,0 },
  { 0,0,0,0,0,0,130,130,84,68,40,40,16,16,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,64,254,65,0,34,0,34,0,18,0,18,0,9,0,8,254,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,127,2,0,130,0,68,0,68,0,72,0,72,0,144,127,16,0,0,0,0,0,0 },
  { 0,0,0,0,16,16,16,16,56,16,16,16,16,16,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,64,0,128,1,0,2,0,4,0,8,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,252,32,0,16,0,16,0,8,0,8,0,8,0,8,0,8,0,8,0,16,0,16,0,32,0,32,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,0,4,0,2,0,1,0,0,128,0,64,0,32,0,16,0,0,0,0,0,0 },
  { 0,0,127,252,65,4,65,4,66,132,66,132,68,68,68,68,72,36,72,36,80,20,80,20,96,12,127,252,0,0,0,0 },
  { 0,0,127,252,96,12,80,20,80,20,72,36,72,36,68,68,68,68,66,132,66,132,65,4,65,4,127,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,128,1,64,2,32,4,16,8,136,4,16,2,32,1,64,0,128,0,0,0,0 },
  { 0,0,0,0,0,0,16,16,40,40,68,84,130,130,0,0 },
  { 0,0,0,0,0,0,0,0,17,16,17,16,17,16,17,16,17,16,17,16,17,16,17,16,9,32,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,2,18,2,2,126,0,0 },
  { 0,0,0,0,0,0,0,0,126,64,64,72,64,64,0,0 },
  { 0,0,0,0,0,0,0,0,56,4,12,12,10,20,9,36,8,196,8,196,9,36,10,20,12,12,56,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,28,48,48,40,80,36,144,35,16,35,16,36,144,40,80,48,48,32,28,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,112,14,24,24,20,40,18,72,17,136,17,136,18,72,20,40,24,24,112,14,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,31,240,0,0,0,0 },
  { 0,0,0,0,31,240,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,128,2,128,126,252,2,128,126,252,2,128,2,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,128,2,128,2,128,126,252,2,128,2,128,2,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,95,254,32,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,127,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,127,254,0,2,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,128,1,64,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,1,192,0,0 },
  { 0,0,0,16,40,40,68,68,254,68,68,40,40,16,0,0 },
  { 0,0,1,0,2,128,2,128,4,64,8,32,48,24,64,4,48,24,8,32,4,64,2,128,2,128,1,0,0,0,0,0 },
  { 0,0,0,128,1,64,1,64,2,32,4,16,24,12,224,2,24,12,4,16,2,32,1,64,1,64,0,128,0,0,0,0 },
  { 0,0,1,0,2,128,2,128,4,64,8,32,48,24,64,7,48,24,8,32,4,64,2,128,2,128,1,0,0,0,0,0 },
  { 0,0,31,254,16,2,16,2,16,2,16,2,16,2,240,2,16,2,16,2,16,2,16,2,16,2,31,254,0,0,0,0 },
  { 0,0,127,248,64,8,64,8,64,8,64,8,64,8,64,15,64,8,64,8,64,8,64,8,64,8,127,248,0,0,0,0 },
  { 0,62,40,40,40,40,40,40,40,40,40,40,40,62,0,0 },
  { 0,124,20,20,20,20,20,20,20,20,20,20,20,124,0,0 },
  { 0,0,4,8,8,16,16,32,32,16,16,8,8,4,0,0 },
  { 0,0,32,16,16,8,8,4,4,8,8,16,16,32,0,0 },
  { 0,0,10,20,20,40,40,80,80,40,40,20,20,10,0,0 },
  { 0,0,80,40,40,20,20,10,10,20,20,40,40,80,0,0 },
  { 0,0,0,2,4,12,20,20,20,20,20,20,12,4,2,0 },
  { 0,0,0,64,32,48,40,40,40,40,40,40,48,32,64,0 },
  { 0,0,0,2,4,8,8,8,8,8,8,8,8,4,2,0 },
  { 0,0,0,64,32,16,16,16,16,16,16,16,16,32,64,0 },
  { 0,0,0,0,1,0,2,128,6,192,10,160,26,176,42,168,10,160,10,160,10,160,10,160,10,160,10,160,0,0,0,0 },
  { 0,0,0,0,10,160,10,160,10,160,10,160,10,160,10,160,42,168,26,176,10,160,6,192,2,128,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,224,2,16,4,8,8,4,42,4,28,4,8,4,0,8,2,16,1,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,128,8,64,16,32,32,16,32,84,32,56,32,16,16,0,8,64,7,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,128,5,72,9,36,255,254,9,36,5,72,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,127,255,32,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,4,255,254,0,4,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,8,32,4,127,254,32,4,16,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,127,254,128,0,127,254,32,0,16,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,8,255,252,0,2,255,252,0,8,0,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,16,16,8,63,252,64,2,63,252,16,8,8,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,2,32,2,127,254,32,2,16,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,8,64,4,127,254,64,4,64,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,2,16,2,63,254,64,2,63,254,16,2,8,2,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,64,16,64,8,127,252,64,2,127,252,64,8,64,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,34,36,213,94,8,132,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,34,0,0,34,0,0,34,0,0,34,0,0,0 },
  { 0,0,0,50,48,0,34,0,0,34,0,0,34,0,0,0 },
  { 0,0,0,34,0,0,50,48,0,34,0,0,34,0,0,0 },
  { 0,0,0,50,48,0,50,48,0,34,0,0,34,0,0,0 },
  { 0,0,0,34,0,0,34,0,0,50,48,0,34,0,0,0 },
  { 0,0,0,50,48,0,34,0,0,50,48,0,34,0,0,0 },
  { 0,0,0,34,0,0,50,48,0,50,48,0,34,0,0,0 },
  { 0,0,0,50,48,0,50,48,0,50,48,0,34,0,0,0 },
  { 0,0,0,38,6,0,34,0,0,34,0,0,34,0,0,0 },
  { 0,0,0,54,54,0,34,0,0,34,0,0,34,0,0,0 },
  { 0,0,0,38,6,0,50,48,0,34,0,0,34,0,0,0 },
  { 0,0,0,54,54,0,50,48,0,34,0,0,34,0,0,0 },
  { 0,0,0,38,6,0,34,0,0,50,48,0,34,0,0,0 },
  { 0,0,0,54,54,0,34,0,0,50,48,0,34,0,0,0 },
  { 0,0,0,38,6,0,50,48,0,50,48,0,34,0,0,0 },
  { 0,0,0,54,54,0,50,48,0,50,48,0,34,0,0,0 },
  { 0,0,0,34,0,0,38,6,0,34,0,0,34,0,0,0 },
  { 0,0,0,50,48,0,38,6,0,34,0,0,34,0,0,0 },
  { 0,0,0,34,0,0,54,54,0,34,0,0,34,0,0,0 },
  { 0,0,0,50,48,0,54,54,0,34,0,0,34,0,0,0 },
  { 0,0,0,34,0,0,38,6,0,50,48,0,34,0,0,0 },
  { 0,0,0,50,48,0,38,6,0,50,48,0,34,0,0,0 },
  { 0,0,0,34,0,0,54,54,0,50,48,0,34,0,0,0 },
  { 0,0,0,50,48,0,54,54,0,50,48,0,34,0,0,0 },
  { 0,0,0,38,6,0,38,6,0,34,0,0,34,0,0,0 },
  { 0,0,0,54,54,0,38,6,0,34,0,0,34,0,0,0 },
  { 0,0,0,38,6,0,54,54,0,34,0,0,34,0,0,0 },
  { 0,0,0,54,54,0,54,54,0,34,0,0,34,0,0,0 },
  { 0,0,0,38,6,0,38,6,0,50,48,0,34,0,0,0 },
  { 0,0,0,54,54,0,38,6,0,50,48,0,34,0,0,0 },
  { 0,0,0,38,6,0,54,54,0,50,48,0,34,0,0,0 },
  { 0,0,0,54,54,0,54,54,0,50,48,0,34,0,0,0 },
  { 0,0,0,34,0,0,34,0,0,38,6,0,34,0,0,0 },
  { 0,0,0,50,48,0,34,0,0,38,6,0,34,0,0,0 },
  { 0,0,0,34,0,0,50,48,0,38,6,0,34,0,0,0 },
  { 0,0,0,50,48,0,50,48,0,38,6,0,34,0,0,0 },
  { 0,0,0,34,0,0,34,0,0,54,54,0,34,0,0,0 },
  { 0,0,0,50,48,0,34,0,0,54,54,0,34,0,0,0 },
  { 0,0,0,34,0,0,50,48,0,54,54,0,34,0,0,0 },
  { 0,0,0,50,48,0,50,48,0,54,54,0,34,0,0,0 },
  { 0,0,0,38,6,0,34,0,0,38,6,0,34,0,0,0 },
  { 0,0,0,54,54,0,34,0,0,38,6,0,34,0,0,0 },
  { 0,0,0,38,6,0,50,48,0,38,6,0,34,0,0,0 },
  { 0,0,0,54,54,0,50,48,0,38,6,0,34,0,0,0 },
  { 0,0,0,38,6,0,34,0,0,54,54,0,34,0,0,0 },
  { 0,0,0,54,54,0,34,0,0,54,54,0,34,0,0,0 },
  { 0,0,0,38,6,0,50,48,0,54,54,0,34,0,0,0 },
  { 0,0,0,54,54,0,50,48,0,54,54,0,34,0,0,0 },
  { 0,0,0,34,0,0,38,6,0,38,6,0,34,0,0,0 },
  { 0,0,0,50,48,0,38,6,0,38,6,0,34,0,0,0 },
  { 0,0,0,34,0,0,54,54,0,38,6,0,34,0,0,0 },
  { 0,0,0,50,48,0,54,54,0,38,6,0,34,0,0,0 },
  { 0,0,0,34,0,0,38,6,0,54,54,0,34,0,0,0 },
  { 0,0,0,50,48,0,38,6,0,54,54,0,34,0,0,0 },
  { 0,0,0,34,0,0,54,54,0,54,54,0,34,0,0,0 },
  { 0,0,0,50,48,0,54,54,0,54,54,0,34,0,0,0 },
  { 0,0,0,38,6,0,38,6,0,38,6,0,34,0,0,0 },
  { 0,0,0,54,54,0,38,6,0,38,6,0,34,0,0,0 },
  { 0,0,0,38,6,0,54,54,0,38,6,0,34,0,0,0 },
  { 0,0,0,54,54,0,54,54,0,38,6,0,34,0,0,0 },
  { 0,0,0,38,6,0,38,6,0,54,54,0,34,0,0,0 },
  { 0,0,0,54,54,0,38,6,0,54,54,0,34,0,0,0 },
  { 0,0,0,38,6,0,54,54,0,54,54,0,34,0,0,0 },
  { 0,0,0,54,54,0,54,54,0,54,54,0,34,0,0,0 },
  { 0,0,0,34,0,0,34,0,0,34,0,0,50,48,0,0 },
  { 0,0,0,50,48,0,34,0,0,34,0,0,50,48,0,0 },
  { 0,0,0,34,0,0,50,48,0,34,0,0,50,48,0,0 },
  { 0,0,0,50,48,0,50,48,0,34,0,0,50,48,0,0 },
  { 0,0,0,34,0,0,34,0,0,50,48,0,50,48,0,0 },
  { 0,0,0,50,48,0,34,0,0,50,48,0,50,48,0,0 },
  { 0,0,0,34,0,0,50,48,0,50,48,0,50,48,0,0 },
  { 0,0,0,50,48,0,50,48,0,50,48,0,50,48,0,0 },
  { 0,0,0,38,6,0,34,0,0,34,0,0,50,48,0,0 },
  { 0,0,0,54,54,0,34,0,0,34,0,0,50,48,0,0 },
  { 0,0,0,38,6,0,50,48,0,34,0,0,50,48,0,0 },
  { 0,0,0,54,54,0,50,48,0,34,0,0,50,48,0,0 },
  { 0,0,0,38,6,0,34,0,0,50,48,0,50,48,0,0 },
  { 0,0,0,54,54,0,34,0,0,50,48,0,50,48,0,0 },
  { 0,0,0,38,6,0,50,48,0,50,48,0,50,48,0,0 },
  { 0,0,0,54,54,0,50,48,0,50,48,0,50,48,0,0 },
  { 0,0,0,34,0,0,38,6,0,34,0,0,50,48,0,0 },
  { 0,0,0,50,48,0,38,6,0,34,0,0,50,48,0,0 },
  { 0,0,0,34,0,0,54,54,0,34,0,0,50,48,0,0 },
  { 0,0,0,50,48,0,54,54,0,34,0,0,50,48,0,0 },
  { 0,0,0,34,0,0,38,6,0,50,48,0,50,48,0,0 },
  { 0,0,0,50,48,0,38,6,0,50,48,0,50,48,0,0 },
  { 0,0,0,34,0,0,54,54,0,50,48,0,50,48,0,0 },
  { 0,0,0,50,48,0,54,54,0,50,48,0,50,48,0,0 },
  { 0,0,0,38,6,0,38,6,0,34,0,0,50,48,0,0 },
  { 0,0,0,54,54,0,38,6,0,34,0,0,50,48,0,0 },
  { 0,0,0,38,6,0,54,54,0,34,0,0,50,48,0,0 },
  { 0,0,0,54,54,0,54,54,0,34,0,0,50,48,0,0 },
  { 0,0,0,38,6,0,38,6,0,50,48,0,50,48,0,0 },
  { 0,0,0,54,54,0,38,6,0,50,48,0,50,48,0,0 },
  { 0,0,0,38,6,0,54,54,0,50,48,0,50,48,0,0 },
  { 0,0,0,54,54,0,54,54,0,50,48,0,50,48,0,0 },
  { 0,0,0,34,0,0,34,0,0,38,6,0,50,48,0,0 },
  { 0,0,0,50,48,0,34,0,0,38,6,0,50,48,0,0 },
  { 0,0,0,34,0,0,50,48,0,38,6,0,50,48,0,0 },
  { 0,0,0,50,48,0,50,48,0,38,6,0,50,48,0,0 },
  { 0,0,0,34,0,0,34,0,0,54,54,0,50,48,0,0 },
  { 0,0,0,50,48,0,34,0,0,54,54,0,50,48,0,0 },
  { 0,0,0,34,0,0,50,48,0,54,54,0,50,48,0,0 },
  { 0,0,0,50,48,0,50,48,0,54,54,0,50,48,0,0 },
  { 0,0,0,38,6,0,34,0,0,38,6,0,50,48,0,0 },
  { 0,0,0,54,54,0,34,0,0,38,6,0,50,48,0,0 },
  { 0,0,0,38,6,0,50,48,0,38,6,0,50,48,0,0 },
  { 0,0,0,54,54,0,50,48,0,38,6,0,50,48,0,0 },
  { 0,0,0,38,6,0,34,0,0,54,54,0,50,48,0,0 },
  { 0,0,0,54,54,0,34,0,0,54,54,0,50,48,0,0 },
  { 0,0,0,38,6,0,50,48,0,54,54,0,50,48,0,0 },
  { 0,0,0,54,54,0,50,48,0,54,54,0,50,48,0,0 },
  { 0,0,0,34,0,0,38,6,0,38,6,0,50,48,0,0 },
  { 0,0,0,50,48,0,38,6,0,38,6,0,50,48,0,0 },
  { 0,0,0,34,0,0,54,54,0,38,6,0,50,48,0,0 },
  { 0,0,0,50,48,0,54,54,0,38,6,0,50,48,0,0 },
  { 0,0,0,34,0,0,38,6,0,54,54,0,50,48,0,0 },
  { 0,0,0,50,48,0,38,6,0,54,54,0,50,48,0,0 },
  { 0,0,0,34,0,0,54,54,0,54,54,0,50,48,0,0 },
  { 0,0,0,50,48,0,54,54,0,54,54,0,50,48,0,0 },
  { 0,0,0,38,6,0,38,6,0,38,6,0,50,48,0,0 },
  { 0,0,0,54,54,0,38,6,0,38,6,0,50,48,0,0 },
  { 0,0,0,38,6,0,54,54,0,38,6,0,50,48,0,0 },
  { 0,0,0,54,54,0,54,54,0,38,6,0,50,48,0,0 },
  { 0,0,0,38,6,0,38,6,0,54,54,0,50,48,0,0 },
  { 0,0,0,54,54,0,38,6,0,54,54,0,50,48,0,0 },
  { 0,0,0,38,6,0,54,54,0,54,54,0,50,48,0,0 },
  { 0,0,0,54,54,0,54,54,0,54,54,0,50,48,0,0 },
  { 0,0,0,34,0,0,34,0,0,34,0,0,38,6,0,0 },
  { 0,0,0,50,48,0,34,0,0,34,0,0,38,6,0,0 },
  { 0,0,0,34,0,0,50,48,0,34,0,0,38,6,0,0 },
  { 0,0,0,50,48,0,50,48,0,34,0,0,38,6,0,0 },
  { 0,0,0,34,0,0,34,0,0,50,48,0,38,6,0,0 },
  { 0,0,0,50,48,0,34,0,0,50,48,0,38,6,0,0 },
  { 0,0,0,34,0,0,50,48,0,50,48,0,38,6,0,0 },
  { 0,0,0,50,48,0,50,48,0,50,48,0,38,6,0,0 },
  { 0,0,0,38,6,0,34,0,0,34,0,0,38,6,0,0 },
  { 0,0,0,54,54,0,34,0,0,34,0,0,38,6,0,0 },
  { 0,0,0,38,6,0,50,48,0,34,0,0,38,6,0,0 },
  { 0,0,0,54,54,0,50,48,0,34,0,0,38,6,0,0 },
  { 0,0,0,38,6,0,34,0,0,50,48,0,38,6,0,0 },
  { 0,0,0,54,54,0,34,0,0,50,48,0,38,6,0,0 },
  { 0,0,0,38,6,0,50,48,0,50,48,0,38,6,0,0 },
  { 0,0,0,54,54,0,50,48,0,50,48,0,38,6,0,0 },
  { 0,0,0,34,0,0,38,6,0,34,0,0,38,6,0,0 },
  { 0,0,0,50,48,0,38,6,0,34,0,0,38,6,0,0 },
  { 0,0,0,34,0,0,54,54,0,34,0,0,38,6,0,0 },
  { 0,0,0,50,48,0,54,54,0,34,0,0,38,6,0,0 },
  { 0,0,0,34,0,0,38,6,0,50,48,0,38,6,0,0 },
  { 0,0,0,50,48,0,38,6,0,50,48,0,38,6,0,0 },
  { 0,0,0,34,0,0,54,54,0,50,48,0,38,6,0,0 },
  { 0,0,0,50,48,0,54,54,0,50,48,0,38,6,0,0 },
  { 0,0,0,38,6,0,38,6,0,34,0,0,38,6,0,0 },
  { 0,0,0,54,54,0,38,6,0,34,0,0,38,6,0,0 },
  { 0,0,0,38,6,0,54,54,0,34,0,0,38,6,0,0 },
  { 0,0,0,54,54,0,54,54,0,34,0,0,38,6,0,0 },
  { 0,0,0,38,6,0,38,6,0,50,48,0,38,6,0,0 },
  { 0,0,0,54,54,0,38,6,0,50,48,0,38,6,0,0 },
  { 0,0,0,38,6,0,54,54,0,50,48,0,38,6,0,0 },
  { 0,0,0,54,54,0,54,54,0,50,48,0,38,6,0,0 },
  { 0,0,0,34,0,0,34,0,0,38,6,0,38,6,0,0 },
  { 0,0,0,50,48,0,34,0,0,38,6,0,38,6,0,0 },
  { 0,0,0,34,0,0,50,48,0,38,6,0,38,6,0,0 },
  { 0,0,0,50,48,0,50,48,0,38,6,0,38,6,0,0 },
  { 0,0,0,34,0,0,34,0,0,54,54,0,38,6,0,0 },
  { 0,0,0,50,48,0,34,0,0,54,54,0,38,6,0,0 },
  { 0,0,0,34,0,0,50,48,0,54,54,0,38,6,0,0 },
  { 0,0,0,50,48,0,50,48,0,54,54,0,38,6,0,0 },
  { 0,0,0,38,6,0,34,0,0,38,6,0,38,6,0,0 },
  { 0,0,0,54,54,0,34,0,0,38,6,0,38,6,0,0 },
  { 0,0,0,38,6,0,50,48,0,38,6,0,38,6,0,0 },
  { 0,0,0,54,54,0,50,48,0,38,6,0,38,6,0,0 },
  { 0,0,0,38,6,0,34,0,0,54,54,0,38,6,0,0 },
  { 0,0,0,54,54,0,34,0,0,54,54,0,38,6,0,0 },
  { 0,0,0,38,6,0,50,48,0,54,54,0,38,6,0,0 },
  { 0,0,0,54,54,0,50,48,0,54,54,0,38,6,0,0 },
  { 0,0,0,34,0,0,38,6,0,38,6,0,38,6,0,0 },
  { 0,0,0,50,48,0,38,6,0,38,6,0,38,6,0,0 },
  { 0,0,0,34,0,0,54,54,0,38,6,0,38,6,0,0 },
  { 0,0,0,50,48,0,54,54,0,38,6,0,38,6,0,0 },
  { 0,0,0,34,0,0,38,6,0,54,54,0,38,6,0,0 },
  { 0,0,0,50,48,0,38,6,0,54,54,0,38,6,0,0 },
  { 0,0,0,34,0,0,54,54,0,54,54,0,38,6,0,0 },
  { 0,0,0,50,48,0,54,54,0,54,54,0,38,6,0,0 },
  { 0,0,0,38,6,0,38,6,0,38,6,0,38,6,0,0 },
  { 0,0,0,54,54,0,38,6,0,38,6,0,38,6,0,0 },
  { 0,0,0,38,6,0,54,54,0,38,6,0,38,6,0,0 },
  { 0,0,0,54,54,0,54,54,0,38,6,0,38,6,0,0 },
  { 0,0,0,38,6,0,38,6,0,54,54,0,38,6,0,0 },
  { 0,0,0,54,54,0,38,6,0,54,54,0,38,6,0,0 },
  { 0,0,0,38,6,0,54,54,0,54,54,0,38,6,0,0 },
  { 0,0,0,54,54,0,54,54,0,54,54,0,38,6,0,0 },
  { 0,0,0,34,0,0,34,0,0,34,0,0,54,54,0,0 },
  { 0,0,0,50,48,0,34,0,0,34,0,0,54,54,0,0 },
  { 0,0,0,34,0,0,50,48,0,34,0,0,54,54,0,0 },
  { 0,0,0,50,48,0,50,48,0,34,0,0,54,54,0,0 },
  { 0,0,0,34,0,0,34,0,0,50,48,0,54,54,0,0 },
  { 0,0,0,50,48,0,34,0,0,50,48,0,54,54,0,0 },
  { 0,0,0,34,0,0,50,48,0,50,48,0,54,54,0,0 },
  { 0,0,0,50,48,0,50,48,0,50,48,0,54,54,0,0 },
  { 0,0,0,38,6,0,34,0,0,34,0,0,54,54,0,0 },
  { 0,0,0,54,54,0,34,0,0,34,0,0,54,54,0,0 },
  { 0,0,0,38,6,0,50,48,0,34,0,0,54,54,0,0 },
  { 0,0,0,54,54,0,50,48,0,34,0,0,54,54,0,0 },
  { 0,0,0,38,6,0,34,0,0,50,48,0,54,54,0,0 },
  { 0,0,0,54,54,0,34,0,0,50,48,0,54,54,0,0 },
  { 0,0,0,38,6,0,50,48,0,50,48,0,54,54,0,0 },
  { 0,0,0,54,54,0,50,48,0,50,48,0,54,54,0,0 },
  { 0,0,0,34,0,0,38,6,0,34,0,0,54,54,0,0 },
  { 0,0,0,50,48,0,38,6,0,34,0,0,54,54,0,0 },
  { 0,0,0,34,0,0,54,54,0,34,0,0,54,54,0,0 },
  { 0,0,0,50,48,0,54,54,0,34,0,0,54,54,0,0 },
  { 0,0,0,34,0,0,38,6,0,50,48,0,54,54,0,0 },
  { 0,0,0,50,48,0,38,6,0,50,48,0,54,54,0,0 },
  { 0,0,0,34,0,0,54,54,0,50,48,0,54,54,0,0 },
  { 0,0,0,50,48,0,54,54,0,50,48,0,54,54,0,0 },
  { 0,0,0,38,6,0,38,6,0,34,0,0,54,54,0,0 },
  { 0,0,0,54,54,0,38,6,0,34,0,0,54,54,0,0 },
  { 0,0,0,38,6,0,54,54,0,34,0,0,54,54,0,0 },
  { 0,0,0,54,54,0,54,54,0,34,0,0,54,54,0,0 },
  { 0,0,0,38,6,0,38,6,0,50,48,0,54,54,0,0 },
  { 0,0,0,54,54,0,38,6,0,50,48,0,54,54,0,0 },
  { 0,0,0,38,6,0,54,54,0,50,48,0,54,54,0,0 },
  { 0,0,0,54,54,0,54,54,0,50,48,0,54,54,0,0 },
  { 0,0,0,34,0,0,34,0,0,38,6,0,54,54,0,0 },
  { 0,0,0,50,48,0,34,0,0,38,6,0,54,54,0,0 },
  { 0,0,0,34,0,0,50,48,0,38,6,0,54,54,0,0 },
  { 0,0,0,50,48,0,50,48,0,38,6,0,54,54,0,0 },
  { 0,0,0,34,0,0,34,0,0,54,54,0,54,54,0,0 },
  { 0,0,0,50,48,0,34,0,0,54,54,0,54,54,0,0 },
  { 0,0,0,34,0,0,50,48,0,54,54,0,54,54,0,0 },
  { 0,0,0,50,48,0,50,48,0,54,54,0,54,54,0,0 },
  { 0,0,0,38,6,0,34,0,0,38,6,0,54,54,0,0 },
  { 0,0,0,54,54,0,34,0,0,38,6,0,54,54,0,0 },
  { 0,0,0,38,6,0,50,48,0,38,6,0,54,54,0,0 },
  { 0,0,0,54,54,0,50,48,0,38,6,0,54,54,0,0 },
  { 0,0,0,38,6,0,34,0,0,54,54,0,54,54,0,0 },
  { 0,0,0,54,54,0,34,0,0,54,54,0,54,54,0,0 },
  { 0,0,0,38,6,0,50,48,0,54,54,0,54,54,0,0 },
  { 0,0,0,54,54,0,50,48,0,54,54,0,54,54,0,0 },
  { 0,0,0,34,0,0,38,6,0,38,6,0,54,54,0,0 },
  { 0,0,0,50,48,0,38,6,0,38,6,0,54,54,0,0 },
  { 0,0,0,34,0,0,54,54,0,38,6,0,54,54,0,0 },
  { 0,0,0,50,48,0,54,54,0,38,6,0,54,54,0,0 },
  { 0,0,0,34,0,0,38,6,0,54,54,0,54,54,0,0 },
  { 0,0,0,50,48,0,38,6,0,54,54,0,54,54,0,0 },
  { 0,0,0,34,0,0,54,54,0,54,54,0,54,54,0,0 },
  { 0,0,0,50,48,0,54,54,0,54,54,0,54,54,0,0 },
  { 0,0,0,38,6,0,38,6,0,38,6,0,54,54,0,0 },
  { 0,0,0,54,54,0,38,6,0,38,6,0,54,54,0,0 },
  { 0,0,0,38,6,0,54,54,0,38,6,0,54,54,0,0 },
  { 0,0,0,54,54,0,54,54,0,38,6,0,54,54,0,0 },
  { 0,0,0,38,6,0,38,6,0,54,54,0,54,54,0,0 },
  { 0,0,0,54,54,0,38,6,0,54,54,0,54,54,0,0 },
  { 0,0,0,38,6,0,54,54,0,54,54,0,54,54,0,0 },
  { 0,0,0,54,54,0,54,54,0,54,54,0,54,54,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,40,2,20,255,254,2,20,2,40,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,40,5,20,255,254,5,20,5,40,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,128,16,128,63,255,64,128,63,255,16,128,8,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,16,1,8,255,252,1,2,255,252,1,8,1,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,4,144,8,136,31,252,32,130,31,252,8,136,4,144,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,40,64,20,127,254,64,20,64,40,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,0,16,4,63,254,64,4,63,254,16,4,8,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,16,64,8,127,252,64,2,127,252,64,8,0,16,0,0,0,0,0,0 },
  { 8,8,8,8,8,8,62,8,8,8,8,42,28,8,0,0 },
  { 0,0,8,28,42,8,8,8,8,62,8,8,8,8,8,8 },
  { 0,0,0,0,1,0,3,128,5,64,13,96,21,80,5,64,5,64,5,64,5,64,5,64,5,64,5,64,0,0,0,0 },
  { 0,0,0,0,5,64,5,64,5,64,5,64,5,64,5,64,5,64,21,80,13,96,5,64,3,128,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,127,127,32,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,4,254,254,0,4,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,125,239,32,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,4,247,190,0,4,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,80,64,40,54,252,64,40,128,80,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,4,170,174,0,4,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,127,28,42,8,8,8,8,8,8,8,8,8,8,8 },
  { 8,8,8,8,8,8,8,8,8,8,8,42,28,127,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,8,33,4,31,254,33,4,65,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,66,136,34,132,31,254,34,132,66,136,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,40,32,20,31,254,32,20,64,40,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,40,33,20,31,254,33,20,65,40,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,40,37,20,31,254,37,20,69,40,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,4,127,248,0,4,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,32,0,31,254,32,0,64,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,36,127,248,0,36,0,18,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,0,36,0,31,254,36,0,72,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,58,0,127,255,58,0,17,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,0,46,127,255,0,46,0,68,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,2,58,2,127,254,58,2,17,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,136,64,92,127,254,64,92,64,136,0,0,0,0,0,0,0,0 },
  { 0,0,60,0,48,0,40,0,36,0,2,0,1,0,0,128,0,64,0,32,0,18,0,10,0,6,0,30,0,0,0,0 },
  { 0,0,0,30,0,6,0,10,0,18,0,32,0,64,0,128,1,0,2,0,36,0,40,0,48,0,60,0,0,0,0,0 },
  { 0,0,60,0,48,0,40,0,36,0,2,0,1,0,0,128,0,64,0,32,0,16,0,8,0,36,0,24,0,0,0,0 },
  { 0,0,0,120,0,24,0,40,0,72,0,128,1,0,2,0,4,0,8,0,16,0,32,0,72,0,48,0,0,0,0,0 },
  { 0,0,48,0,72,0,32,0,16,0,8,0,4,0,2,0,1,0,0,128,0,72,0,40,0,24,0,120,0,0,0,0 },
  { 0,0,0,48,0,72,0,16,0,32,0,64,0,128,1,0,2,0,4,0,72,0,80,0,96,0,120,0,0,0,0,0 },
  { 0,0,120,30,96,6,80,10,72,18,4,32,2,64,1,128,1,128,2,64,4,32,8,16,16,8,32,4,0,0,0,0 },
  { 0,0,0,30,32,6,16,10,8,18,4,32,2,64,1,128,1,128,2,64,4,32,8,18,16,10,32,6,0,30,0,0 },
  { 0,0,32,4,16,8,8,16,4,32,2,64,1,128,1,128,2,64,4,32,72,18,80,10,96,6,120,30,0,0,0,0 },
  { 0,0,120,0,96,4,80,8,72,16,4,32,2,64,1,128,1,128,2,64,4,32,72,16,80,8,96,4,120,0,0,0 },
  { 0,0,0,0,32,4,16,8,8,16,4,32,2,64,0,128,1,0,2,64,4,32,8,16,16,8,32,4,0,0,0,0 },
  { 0,0,0,0,32,4,16,8,8,16,4,32,2,64,1,0,0,128,2,64,4,32,8,16,16,8,32,4,0,0,0,0 },
  { 0,0,0,30,32,6,16,10,8,18,4,32,2,64,1,0,0,128,2,64,4,32,8,18,16,10,32,6,0,30,0,0 },
  { 0,0,0,30,32,6,16,10,8,18,4,32,2,64,0,128,1,0,2,64,4,32,8,18,16,10,32,6,0,30,0,0 },
  { 0,0,0,30,32,6,16,10,8,18,4,32,2,64,1,0,0,128,2,64,4,32,8,16,16,8,32,4,0,0,0,0 },
  { 0,0,32,4,16,8,8,16,4,32,2,64,0,128,1,0,2,64,4,32,8,18,16,10,32,6,0,30,0,0,0,0 },
  { 0,0,120,30,96,6,80,10,72,18,4,32,2,64,0,128,1,0,2,64,4,32,8,16,16,8,32,4,0,0,0,0 },
  { 0,0,120,30,96,6,80,10,72,18,4,32,2,64,1,0,0,128,2,64,4,32,8,16,16,8,32,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,28,0,34,8,65,4,64,254,0,4,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,16,0,56,0,84,0,16,0,16,0,16,0,32,255,192,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,255,192,0,32,0,16,0,16,0,16,0,84,0,56,0,16,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,8,0,8,0,8,0,8,0,8,0,8,0,8,4,8,8,16,31,224,8,0,4,0,0,0,0,0,0,0,0,0 },
  { 16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,32,8,16,7,248,0,16,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,32,16,8,8,4,4,4,4,40,40,48,60,0,0 },
  { 0,0,4,8,16,16,32,32,32,32,20,20,12,60,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,192,44,48,48,8,60,4,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,60,16,12,12,52,3,196,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,196,12,52,16,12,32,60,7,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,192,44,48,48,8,60,68,0,224,0,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,16,0,8,0,4,0,4,60,4,48,8,44,48,35,192,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,0,16,0,32,0,32,0,32,60,16,12,12,52,3,196,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,128,1,0,3,128,13,96,16,144,16,16,32,8,32,8,16,16,16,16,12,96,3,128,0,0,0,0 },
  { 0,0,0,0,2,0,1,0,3,128,13,96,18,16,16,16,32,8,32,8,16,16,16,16,12,96,3,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,8,0,4,127,254,0,4,0,8,16,0,32,0,126,0,32,0,16,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,0,32,0,127,254,32,0,16,0,0,8,0,4,0,126,0,4,0,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,8,0,4,0,126,0,4,0,8,16,0,32,0,127,254,32,0,16,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,4,255,254,0,4,8,8,8,0,62,0,8,0,8,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,32,0,64,0,255,255,64,0,32,32,0,32,0,248,0,32,0,32,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,16,17,8,10,4,255,254,10,4,17,8,0,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,16,16,35,136,68,68,255,254,68,68,35,136,16,16,0,0,0,0,0,0 },
  { 0,0,16,56,84,56,84,16,16,16,56,68,68,56,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,127,254,0,4,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,4,127,254,32,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,24,20,16,16,16,16,16,16,80,48,16,0,0 },
  { 0,0,16,48,80,16,16,16,16,16,16,20,24,16,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,8,32,4,127,254,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,32,48,40,32,32,32,32,32,32,40,48,32,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254,32,4,16,8,0,0,0,0,0,0,0,0 },
  { 0,0,8,24,40,8,8,8,8,8,8,40,24,8,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,0,80,0,127,255,64,0,64,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,10,255,254,0,2,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,62,8,12,10,8,8,8,8,8,8,8,8,8,8 },
  { 0,0,8,8,8,8,8,8,8,8,10,12,8,62,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,64,0,127,255,80,0,72,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,255,254,0,10,0,18,0,0,0,0,0,0,0,0 },
  { 0,0,62,8,24,40,8,8,8,8,8,8,8,8,8,8 },
  { 0,0,8,8,8,8,8,8,8,8,40,24,8,62,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,2,16,2,63,254,0,2,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,16,64,8,127,252,64,0,64,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,24,20,16,16,16,16,16,16,16,16,124,0,0 },
  { 0,0,124,16,16,16,16,16,16,16,16,20,24,16,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,63,254,16,2,8,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,64,0,127,252,64,8,64,16,0,0,0,0,0,0,0,0 },
  { 0,0,16,48,80,16,16,16,16,16,16,16,16,124,0,0 },
  { 0,0,124,16,16,16,16,16,16,16,16,80,48,16,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,0,32,0,127,254,0,0,0,0,0,0,127,254,32,0,16,0,0,0,0,0 },
  { 0,0,0,0,2,32,6,48,10,40,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,0,4,127,254,0,0,0,0,0,0,127,254,0,4,0,8,0,0,0,0 },
  { 0,0,0,0,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,2,32,10,40,6,48,2,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,0,32,0,127,254,0,0,0,8,0,4,127,254,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254,32,0,16,0,0,0,127,254,0,4,0,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,0,4,127,254,0,0,16,0,32,0,127,254,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254,0,4,0,8,0,0,127,254,32,0,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,127,254,0,0,127,254,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254,0,0,127,254,32,0,16,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,4,127,254,0,0,127,254,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254,0,0,127,254,0,4,0,8,0,0,0,0,0,0 },
  { 0,0,0,0,2,32,6,32,10,32,2,32,2,32,2,32,2,32,2,32,2,32,2,40,2,48,2,32,0,0,0,0 },
  { 0,0,0,0,2,32,2,48,2,40,2,32,2,32,2,32,2,32,2,32,2,32,10,32,6,32,2,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,252,0,2,0,2,127,252,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,31,128,0,0,31,136,0,4,255,254,0,4,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,56,0,68,64,3,136,0,4,255,254,0,4,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,127,255,32,0,17,192,2,34,0,28,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,4,255,254,0,4,56,8,68,64,3,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,4,255,254,56,4,68,72,3,128,56,0,68,64,3,128 },
  { 0,0,0,0,0,24,0,96,1,128,6,0,8,0,6,0,1,128,0,96,2,24,4,0,15,248,4,0,2,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,6,0,24,16,96,33,128,127,240,33,128,16,96,0,24,0,6,0,0,0,0 },
  { 0,0,0,0,12,0,3,0,0,192,0,48,0,8,0,48,0,192,3,0,12,32,0,16,15,248,0,16,0,32,0,0 },
  { 0,0,0,0,3,248,4,0,8,0,8,0,8,0,4,0,3,248,0,0,2,0,4,0,15,248,4,0,2,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,254,18,0,36,0,127,254,36,0,18,0,1,254,0,0,0,0,0,0 },
  { 0,0,0,0,15,224,0,16,0,8,0,8,0,8,0,16,15,224,0,0,2,0,4,0,15,248,4,0,2,0,0,0 },
  { 0,0,0,0,0,32,64,64,32,31,32,64,64,32,0,0 },
  { 0,0,0,0,0,2,1,1,2,124,2,1,1,2,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,12,96,18,144,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,18,144,12,96,0,0,0,0 },
  { 0,0,0,0,42,42,42,42,42,42,42,42,42,42,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,128,3,192,3,192,1,128,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,24,36,36,24,0,0,24,36,36,24,0,0 },
  { 0,0,30,36,36,20,20,36,68,36,20,20,36,36,30,0 },
  { 0,0,120,36,36,40,40,36,34,36,40,40,36,36,120,0 },
  { 0,0,0,12,24,24,40,40,40,40,40,40,24,24,12,0 },
  { 0,0,0,48,24,24,20,20,20,20,20,20,24,24,48,0 },
  { 0,0,0,12,20,20,36,36,36,36,36,36,20,20,12,0 },
  { 0,0,0,48,40,40,36,36,36,36,36,36,40,40,48,0 },
  { 0,0,0,4,12,12,20,20,36,36,20,20,12,12,4,0 },
  { 0,0,0,32,48,48,40,40,36,36,40,40,48,48,32,0 },
  { 0,0,0,14,8,8,8,8,8,8,8,8,8,14,0,14 },
  { 0,0,0,112,16,16,16,16,16,16,16,16,16,112,0,112 },
  { 0,0,0,30,24,20,18,16,16,16,16,16,16,16,30,0 },
  { 0,0,0,120,8,8,8,8,8,8,8,72,40,24,120,0 },
  { 0,0,0,30,16,16,16,16,16,16,16,18,20,24,30,0 },
  { 0,0,0,120,24,40,72,8,8,8,8,8,8,8,120,0 },
  { 0,0,0,4,8,8,16,16,38,38,16,16,8,8,4,0 },
  { 0,0,0,32,16,16,8,8,100,100,8,8,16,16,32,0 },
  { 0,0,0,0,0,0,0,64,0,140,0,240,1,128,3,0,13,0,17,0,13,0,3,0,1,128,0,240,0,140,0,64 },
  { 0,0,0,0,0,0,1,0,24,128,7,128,0,192,0,96,0,88,0,68,0,88,0,96,0,192,7,128,24,128,1,0 },
  { 0,0,0,0,0,0,0,160,25,64,7,64,3,128,2,224,2,152,2,132,2,152,2,96,1,192,7,64,24,160,0,0 },
  { 0,0,0,0,0,0,2,128,1,76,1,112,0,224,3,160,12,160,16,160,12,160,3,32,1,192,1,112,2,140,0,0 },
  { 0,0,0,12,24,56,56,56,56,56,56,56,56,24,12,0 },
  { 0,0,0,48,24,28,28,28,28,28,28,28,28,24,48,0 },
  { 0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,0 },
  { 0,0,2,0,1,0,0,128,1,0,2,0,1,0,0,128,1,0,2,0,1,0,0,128,1,0,2,0,1,0,0,128 },
  { 0,0,0,0,0,0,0,0,4,0,2,64,1,128,1,128,2,64,2,32,4,16,4,8,4,4,63,254,4,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,32,0,32,0,32,0,32,0,62,0,34,0,34,0,34,0,63,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,0,32,0,32,0,32,0,60,0,34,0,33,0,41,0,33,0,63,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,16,0,32,0,64,0,156,1,32,2,24,4,4,8,56,16,0,63,254,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,48,0,192,3,0,12,0,16,0,63,254,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,64,6,128,1,128,1,96,2,24,2,4,2,24,1,96,1,128,6,128,24,64,0,0 },
  { 0,0,0,0,0,0,0,0,16,4,16,4,8,8,9,200,6,48,12,24,18,36,2,32,1,64,1,64,0,128,0,0 },
  { 0,0,0,0,0,0,0,0,63,254,0,4,0,8,0,16,0,32,0,64,0,128,1,0,2,0,4,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,4,0,2,0,1,0,0,128,0,64,0,32,0,16,0,8,0,4,63,254,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,16,0,32,0,64,0,128,1,0,2,0,4,0,8,0,16,0,63,254,0,0,63,254 },
  { 0,0,0,0,0,0,0,0,4,0,2,0,1,0,0,128,0,64,0,32,0,16,0,8,0,4,63,254,0,0,63,254 },
  { 0,0,0,0,0,0,0,0,0,0,0,64,32,30,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,30,32,64,0,0 },
  { 0,0,0,0,0,0,0,120,0,24,1,40,0,200,0,192,1,32,2,32,4,16,8,16,16,16,63,254,0,16,0,0 },
  { 0,0,0,0,0,0,15,0,12,0,10,64,9,128,1,128,2,64,2,32,4,16,4,8,4,4,63,254,4,0,0,0 },
  { 0,0,0,0,0,0,0,16,63,254,16,16,8,16,4,16,2,32,1,32,0,192,0,200,1,40,0,24,0,120,0,0 },
  { 0,0,0,0,0,0,4,0,63,254,4,4,4,8,4,16,2,32,2,64,1,128,9,128,10,64,12,0,15,0,0,0 },
  { 0,0,0,0,0,0,16,0,16,0,16,60,62,12,17,148,16,100,16,96,16,144,17,0,18,0,20,0,24,0,16,0 },
  { 0,0,0,0,0,0,0,8,0,8,60,8,48,124,41,136,38,8,6,8,9,8,0,136,0,72,0,40,0,24,0,8 },
  { 0,0,0,0,0,0,16,0,24,0,20,0,18,0,17,0,16,144,16,96,16,100,17,148,62,12,16,60,16,0,16,0 },
  { 0,0,0,0,0,0,0,8,0,24,0,40,0,72,0,136,9,8,6,8,38,8,41,136,48,124,60,8,0,8,0,8 },
  { 0,0,0,0,0,0,0,0,0,0,23,192,8,32,20,16,18,16,17,16,16,144,16,80,8,32,7,208,0,0,0,0 },
  { 0,0,0,0,0,0,7,192,0,0,7,208,8,32,16,80,16,144,17,16,18,16,20,16,8,32,23,192,0,0,0,0 },
  { 0,0,1,0,2,128,1,0,0,0,7,208,8,32,16,80,16,144,17,16,18,16,20,16,8,32,23,192,0,0,0,0 },
  { 1,0,0,128,15,192,0,128,1,0,7,208,8,32,16,80,16,144,17,16,18,16,20,16,8,32,23,192,0,0,0,0 },
  { 2,0,4,0,15,192,4,0,2,0,7,208,8,32,16,80,16,144,17,16,18,16,20,16,8,32,23,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,8,32,16,16,16,16,63,248,16,16,16,16,8,32,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,9,32,17,16,17,16,17,16,17,16,17,16,9,32,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,8,32,18,144,18,144,18,144,18,144,18,144,8,32,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,8,32,20,16,18,16,17,16,16,144,16,80,8,32,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,8,32,17,16,17,16,17,16,17,16,23,208,8,32,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,192,9,32,17,16,17,16,31,240,16,16,16,16,8,32,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,23,208,8,32,20,80,18,144,17,16,18,144,20,80,8,32,23,208,0,0,0,0 },
  { 0,0,0,0,0,0,3,224,4,16,8,8,18,36,16,68,16,132,17,4,18,36,8,8,4,16,3,224,0,0,0,0 },
  { 0,0,1,0,3,128,5,0,1,0,7,192,9,32,17,16,17,16,17,16,17,16,17,16,9,32,7,192,1,0,0,0 },
  { 0,0,0,0,0,0,3,224,4,16,9,200,18,36,20,20,20,20,20,20,18,36,9,200,4,16,3,224,0,0,0,0 },
  { 0,0,0,0,0,0,3,224,4,16,9,200,19,228,23,244,23,244,23,244,19,228,9,200,4,16,3,224,0,0,0,0 },
  { 0,0,0,0,0,0,3,224,4,16,8,8,16,196,19,4,20,4,19,4,16,196,8,8,4,16,3,224,0,0,0,0 },
  { 0,0,0,0,0,0,3,224,4,16,8,8,17,132,16,100,16,20,16,100,17,132,8,8,4,16,3,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,31,64,32,128,65,64,66,72,68,84,72,72,80,64,32,128,95,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,160,16,64,32,160,33,60,34,32,36,60,40,32,16,64,47,128,0,0,0,0 },
  { 0,0,0,0,0,0,127,240,64,48,64,80,64,144,65,16,66,16,68,16,72,16,80,16,96,16,127,240,0,0,0,0 },
  { 0,0,0,0,0,0,127,240,96,16,80,16,72,16,68,16,66,16,65,16,64,144,64,80,64,48,127,240,0,0,0,0 },
  { 0,0,0,0,0,0,127,240,64,16,66,16,82,80,74,144,71,16,74,144,82,80,66,16,64,16,127,240,0,0,0,0 },
  { 0,0,0,0,0,0,127,240,64,16,64,16,71,16,72,144,72,144,72,144,71,16,64,16,64,16,127,240,0,0,0,0 },
  { 0,0,0,0,0,0,127,240,64,16,95,208,80,80,80,80,80,80,80,80,80,80,95,208,64,16,127,240,0,0,0,0 },
  { 0,0,0,0,63,192,32,64,32,64,32,64,35,252,34,68,34,68,63,196,2,4,2,4,2,4,3,252,0,0,0,0 },
  { 0,0,1,0,0,0,1,0,2,128,2,128,4,64,4,64,8,32,8,32,16,16,16,16,32,8,32,8,127,252,0,0 },
  { 0,0,0,0,1,0,2,128,2,128,4,64,4,64,8,32,8,32,16,16,16,16,32,8,32,8,127,252,0,0,127,252 },
  { 0,0,0,128,1,64,1,64,2,32,2,32,4,16,4,16,9,200,10,8,17,132,16,68,35,130,32,2,127,255,0,0 },
  { 0,0,0,0,1,0,2,128,2,128,4,64,4,64,8,32,8,32,16,16,16,16,32,8,32,8,255,254,0,0,0,0 },
  { 24,0,22,0,17,128,16,96,16,16,16,96,17,128,22,48,24,208,3,16,12,16,16,16,12,16,3,16,0,208,0,48 },
  { 0,0,0,0,0,0,0,0,0,0,0,104,1,168,6,40,24,40,32,40,24,40,6,40,1,168,0,104,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,44,0,43,0,40,192,40,48,40,8,40,48,40,192,43,0,44,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,130,198,234,242,234,198,130,0,0 },
  { 0,0,0,0,0,0,0,130,198,174,158,174,198,130,0,0 },
  { 0,0,0,0,0,0,0,130,198,238,254,238,198,130,0,0 },
  { 0,0,0,0,0,0,0,130,196,232,240,232,196,130,0,0 },
  { 0,0,0,0,0,0,0,130,70,46,30,46,70,130,0,0 },
  { 0,0,0,0,0,0,0,254,68,40,16,40,68,254,0,0 },
  { 0,0,0,0,0,0,0,254,124,56,16,56,124,254,0,0 },
  { 0,0,32,16,8,16,32,16,8,16,32,16,8,16,32,0 },
  { 0,0,8,16,32,16,8,16,32,16,8,16,32,16,8,0 },
  { 0,0,0,0,4,64,2,32,1,16,2,32,4,64,2,32,1,16,2,32,4,64,2,32,1,16,2,32,4,64,0,0 },
  { 0,0,0,0,1,16,2,32,4,64,2,32,1,16,2,32,4,64,2,32,1,16,2,32,4,64,2,32,1,16,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,0,33,0,34,136,28,112,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,4,64,4,64,14,224,17,16,17,16,14,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,29,112,35,136,35,136,29,112,1,0,1,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,48,12,72,18,79,242,72,18,48,12,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,248,63,252,48,4,48,4,48,4,48,4,48,4,48,4,48,4,48,4,48,4,63,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,48,0,192,3,0,12,0,16,0,63,254,0,0,63,254 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,8,33,8,33,8,33,8,33,8,63,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,18,0,36,0,72,0,144,127,254,2,64,127,254,9,0,18,0,36,0,72,0,0,0,0,0 },
  { 0,0,0,0,6,64,9,146,0,36,0,72,0,144,127,254,2,64,127,254,9,0,18,0,36,0,72,0,0,0,0,0 },
  { 0,0,0,0,0,18,0,36,0,72,127,254,1,32,127,254,4,128,127,254,18,0,36,0,72,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,2,64,2,127,254,64,2,64,2,127,254,64,2,64,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,0,1,0,31,240,1,0,1,0,31,240,1,0,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,127,252,63,8,63,8,31,16,31,16,15,32,15,32,7,64,7,64,3,128,3,128,1,0,0,0 },
  { 0,0,0,0,0,0,127,252,33,248,33,248,17,240,17,240,9,224,9,224,5,192,5,192,3,128,3,128,1,0,0,0 },
  { 0,0,0,0,0,0,1,0,3,128,7,192,15,224,31,240,15,224,7,192,3,128,1,0,5,64,3,128,1,0,0,0 },
  { 0,0,16,56,56,124,124,254,124,124,56,56,16,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,192,2,32,4,16,4,16,4,16,2,32,1,192,0,128,2,160,1,192,0,128,0,0 },
  { 0,0,0,0,0,0,0,0,1,192,3,224,7,240,7,240,7,240,3,224,1,192,0,128,2,160,1,192,0,128,0,0 },
  { 0,0,0,0,0,0,15,128,2,0,31,192,16,64,16,64,16,64,16,64,16,64,31,192,2,0,15,128,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,2,0,31,192,31,192,31,192,31,192,31,192,31,192,31,192,2,0,15,128,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,2,0,2,0,5,0,8,128,16,64,8,128,5,0,2,0,2,0,15,128,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,2,0,2,0,7,0,15,128,31,192,15,128,7,0,2,0,2,0,15,128,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,2,0,7,0,8,128,16,64,16,64,16,64,8,128,7,0,2,0,15,128,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,2,0,7,0,15,128,31,192,31,192,31,192,15,128,7,0,2,0,15,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,64,8,0,4,31,254,0,4,64,8,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,64,64,32,32,16,16,8,8,4,4,0,0 },
  { 0,0,120,0,4,4,8,8,16,16,32,32,64,64,0,0 },
  { 0,0,0,0,64,64,32,32,124,16,8,8,4,4,0,0 },
  { 1,1,2,2,4,4,8,8,16,16,32,32,64,64,0,0 },
  { 128,128,64,64,32,32,16,16,8,8,4,4,2,2,0,0 },
  { 0,0,0,0,0,0,40,40,254,40,40,0,0,0,0,0 },
  { 0,0,0,0,0,0,84,84,254,84,84,0,0,0,0,0 },
  { 0,0,0,2,2,4,24,96,128,96,24,4,2,2,0,0 },
  { 0,0,0,128,128,64,48,12,2,12,48,64,128,128,0,0 },
  { 0,0,0,0,0,0,7,192,7,192,3,128,97,12,121,60,127,252,121,60,97,12,3,128,3,128,7,192,7,192,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,96,12,120,60,127,252,120,60,96,12,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,3,224,4,16,8,8,16,4,16,4,16,132,16,4,16,4,8,8,4,16,3,224,0,0,0,0 },
  { 0,0,0,0,0,0,3,224,4,144,8,136,16,132,16,132,31,252,16,132,16,132,8,136,4,144,3,224,0,0,0,0 },
  { 0,0,0,0,0,0,3,224,4,16,12,24,18,36,17,68,16,132,17,68,18,36,12,24,4,16,3,224,0,0,0,0 },
  { 0,0,0,0,0,0,16,32,16,32,16,32,16,32,16,32,19,32,19,32,16,32,16,32,8,64,7,128,0,0,0,0 },
  { 0,0,0,0,0,0,16,16,16,16,16,16,16,16,17,16,17,16,23,208,17,16,17,16,8,32,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,31,240,0,0,0,0 },
  { 0,0,0,0,0,0,31,240,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,0,0,0,0 },
  { 0,0,0,0,0,0,2,64,5,160,5,160,9,144,9,144,18,72,18,72,36,36,36,36,72,18,72,18,0,0,0,0 },
  { 0,0,0,0,0,0,72,18,72,18,36,36,36,36,18,72,18,72,9,144,9,144,5,160,5,160,2,64,0,0,0,0 },
  { 0,0,0,0,0,0,32,8,16,16,8,32,4,64,2,128,1,0,2,128,4,64,8,32,16,16,32,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,240,16,0,11,0,4,128,10,64,10,64,4,128,11,0,16,0,31,240,0,0,0,0 },
  { 0,0,0,192,1,32,1,0,31,240,17,0,9,0,5,0,3,0,5,0,9,0,17,0,31,240,1,0,9,0,6,0 },
  { 0,0,0,0,0,0,18,72,45,180,36,144,36,144,36,144,36,144,36,144,36,144,36,144,182,208,73,32,0,0,0,0 },
  { 0,0,0,192,1,32,1,0,1,0,1,0,1,0,1,0,7,192,1,0,1,0,1,0,1,0,1,0,9,0,6,0 },
  { 0,0,0,192,1,32,1,0,1,0,1,0,1,0,7,192,1,0,7,192,1,0,1,0,1,0,1,0,9,0,6,0 },
  { 0,0,0,192,1,32,1,0,1,0,1,32,1,64,1,128,1,0,3,0,5,0,9,0,1,0,1,0,9,0,6,0 },
  { 0,0,0,192,1,32,1,0,1,0,1,0,3,128,5,64,5,0,5,0,3,128,1,0,1,0,1,0,9,0,6,0 },
  { 0,0,0,192,1,32,1,0,1,16,17,56,17,84,17,16,9,32,7,192,1,0,1,0,1,0,1,0,9,0,6,0 },
  { 0,0,0,192,1,32,1,0,1,0,1,0,1,192,0,64,1,64,0,64,1,192,1,0,1,0,1,0,9,0,6,0 },
  { 0,0,0,192,1,32,1,0,1,0,1,0,1,128,0,64,1,64,0,64,1,128,1,0,1,0,1,0,9,0,6,0 },
  { 0,0,0,192,1,32,1,0,1,0,1,96,1,144,0,16,1,16,0,16,1,144,1,96,1,0,1,0,9,0,6,0 },
  { 0,0,0,192,1,32,1,0,1,0,1,0,3,128,4,64,5,64,4,64,3,128,1,0,1,0,1,0,9,0,6,0 },
  { 0,0,0,192,1,32,1,0,1,0,1,0,7,192,4,64,5,64,4,64,7,192,1,0,1,0,1,0,9,0,6,0 },
  { 0,0,0,192,1,32,1,0,1,0,5,0,9,0,31,224,9,16,5,16,1,96,1,0,1,0,1,0,9,0,6,0 },
  { 0,0,0,192,1,32,1,0,1,0,9,32,5,64,3,128,1,0,3,128,5,64,9,32,1,0,1,0,9,0,6,0 },
  { 0,0,0,192,1,32,1,0,1,0,1,0,3,128,5,64,5,64,5,64,5,64,1,0,1,0,1,0,9,0,6,0 },
  { 0,0,0,192,1,32,1,0,1,0,1,0,5,64,5,64,5,64,5,64,3,128,1,0,1,0,1,0,9,0,6,0 },
  { 0,0,3,224,0,0,0,192,1,32,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,9,0,6,0 },
  { 0,0,0,192,1,32,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,9,0,6,0,0,0,15,192 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,32,8,56,56,38,200,33,8,38,200,56,56,32,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,2,14,50,66,50,14,2,0,0,0 },
  { 0,0,0,0,0,24,36,36,24,0,24,36,36,28,4,24 },
  { 0,0,0,0,0,0,17,0,8,128,4,64,2,32,1,16,0,136,1,16,2,32,4,64,8,128,17,0,0,0,0,0 },
  { 0,0,0,0,32,48,40,36,32,32,32,32,32,32,0,0 },
  { 0,0,0,0,16,40,16,0,16,16,124,16,16,0,0,0 },
  { 0,0,0,0,16,40,68,0,16,16,124,16,16,0,0,0 },
  { 0,0,0,0,100,152,0,0,16,16,124,16,16,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,16,124,16,16,0,16,0 },
  { 0,0,0,0,0,0,0,0,16,16,124,16,16,0,50,76 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,15,128,2,0,2,192,0,32,0,64,0,128,0,224 },
  { 0,0,0,0,0,0,0,0,16,16,124,16,56,124,16,0 },
  { 0,0,0,0,0,48,56,8,48,0,124,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,124,0,16,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,0,124,0,4,0,0,0 },
  { 0,0,0,0,0,0,0,0,4,0,124,0,64,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,4,0,8,128,8,128,11,224,8,128,8,128,4,0,3,128 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,0,64,2,32,2,32,15,160,2,32,2,32,0,64,3,128 },
  { 0,0,0,0,0,0,0,0,34,20,8,20,34,0,0,0 },
  { 0,0,0,0,0,0,16,0,68,40,16,40,68,0,0,0 },
  { 0,0,0,0,0,0,0,0,68,40,16,40,68,0,124,0 },
  { 0,0,0,0,0,0,0,0,68,40,16,40,68,124,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,64,2,128,17,16,10,160,4,64,10,160,17,16,2,128,4,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,128,4,0,9,16,8,160,8,64,8,160,9,16,4,0,3,128,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,192,0,32,8,144,5,16,2,16,5,16,8,144,0,32,1,192,0,0 },
  { 0,0,0,0,1,0,2,128,4,64,0,0,15,224,16,16,36,72,34,136,33,8,34,136,36,72,16,16,15,224,0,0 },
  { 0,0,0,0,0,0,31,240,32,8,79,228,144,18,164,74,162,138,161,10,162,138,164,74,144,18,79,228,32,8,31,240 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,62,0,65,0,136,128,128,128,190,128,128,128,136,128,65,0,62,0,0,0 },
  { 0,0,1,0,2,128,2,128,4,64,4,64,8,32,9,32,17,16,23,208,33,8,33,8,64,4,127,252,0,0,0,0 },
  { 0,0,1,0,2,128,2,128,4,64,4,64,8,32,8,32,16,16,23,208,32,8,32,8,64,4,127,252,0,0,0,0 },
  { 0,0,1,0,2,128,2,128,4,64,4,64,8,32,12,96,18,144,17,16,34,136,36,72,64,4,127,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,2,126,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,64,126,0,0,0,0,0 },
  { 0,0,0,0,0,8,20,20,8,0,8,20,20,12,4,24 },
  { 0,0,0,0,0,0,28,56,8,16,8,16,8,16,8,16,8,16,8,16,8,16,8,16,8,16,31,248,0,0,0,0 },
  { 0,0,0,0,0,0,3,192,4,32,8,16,9,144,9,144,8,16,8,16,8,16,8,16,8,16,8,16,0,0,0,0 },
  { 0,0,0,0,0,0,8,16,8,16,8,16,8,16,8,16,8,16,11,208,8,16,8,16,4,32,3,192,0,0,0,0 },
  { 0,0,0,0,15,240,0,0,8,16,8,16,8,16,8,16,8,16,8,16,8,16,8,16,4,32,3,192,0,0,0,0 },
  { 0,0,0,0,15,240,0,0,3,192,4,32,8,16,8,16,8,16,8,16,8,16,8,16,8,16,8,16,0,0,0,0 },
  { 0,0,0,0,0,0,7,192,8,32,16,16,16,16,16,16,16,16,16,16,16,16,17,16,18,144,20,80,0,0,0,0 },
  { 0,0,0,0,0,0,20,80,18,144,17,16,16,16,16,16,16,16,16,16,16,16,16,16,8,32,7,192,0,0,0,0 },
  { 0,0,0,0,0,36,36,36,24,0,24,36,36,36,0,0 },
  { 0,0,0,0,0,24,36,36,36,0,36,36,36,24,0,0 },
  { 0,0,0,36,36,36,24,0,60,0,24,36,36,36,0,0 },
  { 0,0,0,24,36,36,36,0,60,0,36,36,36,24,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,146,146,146,108,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,108,146,146,146,0,0 },
  { 0,0,0,0,0,0,15,240,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,2,64,1,128,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,2,64,4,32,4,32,4,32,4,32,4,32,4,32,4,32,15,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,240,16,16,23,208,20,80,20,80,20,80,20,80,20,80,20,80,20,80,20,80,0,0,0,0 },
  { 0,0,0,0,0,0,20,80,20,80,20,80,20,80,20,80,20,80,20,80,20,80,23,208,16,16,31,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,63,254,16,4,16,4,17,68,16,132,21,84,18,36,21,84,16,140,9,72,7,240,0,0 },
  { 0,0,0,0,0,0,1,0,0,0,1,0,2,128,2,128,4,64,4,64,8,32,8,32,16,16,16,16,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,0,0,16,16,16,16,8,32,8,32,4,64,4,64,2,128,2,128,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,2,128,2,128,4,64,4,64,8,32,9,32,18,144,18,144,36,72,36,72,0,0,0,0 },
  { 0,0,0,0,0,0,36,72,36,72,18,144,18,144,9,32,8,32,4,64,4,64,2,128,2,128,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,64,5,160,5,160,9,144,9,144,18,72,18,72,36,36,36,36,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,36,36,36,36,18,72,18,72,9,144,9,144,5,160,5,160,2,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,8,16,16,16,32,16,64,16,128,17,0,18,0,20,0,24,0,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,0,12,0,20,0,36,0,68,0,132,1,4,2,4,4,4,8,4,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,64,4,32,8,17,16,10,160,4,64,10,160,17,16,32,8,64,4,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,3,128,3,128,5,64,5,64,9,32,9,32,17,16,17,16,33,8,33,8,0,0,0,0 },
  { 0,0,0,0,0,0,33,8,33,8,17,16,17,16,9,32,9,32,5,64,5,64,3,128,3,128,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,2,128,2,128,4,64,4,64,63,248,8,32,16,16,16,16,32,8,32,8,0,0,0,0 },
  { 0,0,0,0,0,0,32,8,32,8,16,16,16,16,8,32,63,248,4,64,4,64,2,128,2,128,1,0,0,0,0,0 },
  { 0,0,31,240,0,0,31,240,0,0,1,0,2,128,2,128,4,64,4,64,8,32,8,32,16,16,16,16,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,2,128,2,128,4,64,4,64,8,32,8,32,16,16,16,16,0,0,31,240,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,2,128,2,128,4,64,4,64,8,32,8,32,16,16,16,16,0,0,31,240,0,0,31,240 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,64,2,128,1,0,0,0,31,240,0,0,0,0 },
  { 0,0,0,0,0,0,31,240,0,0,31,240,0,0,16,16,16,16,8,32,8,32,4,64,4,64,2,128,2,128,1,0 },
  { 0,0,0,0,0,0,16,16,16,16,8,32,8,32,4,64,4,64,2,128,2,128,1,0,0,0,31,240,0,0,31,240 },
  { 0,0,0,0,0,0,0,24,0,104,1,136,6,8,24,8,63,248,24,8,6,8,1,136,0,104,0,24,0,0,0,0 },
  { 0,0,0,0,0,0,48,0,44,0,35,0,32,192,32,48,63,248,32,48,32,192,35,0,44,0,48,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,127,0,127,0,8,0,0,0,0 },
  { 0,0,0,0,0,8,0,127,0,127,0,127,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,128,2,128,63,248,2,128,63,248,2,128,63,248,2,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,5,64,5,64,63,248,5,64,63,248,5,64,63,248,5,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,32,0,100,152,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,8,0,100,152,0,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,100,152,0,252,0,100,152,0,0 },
  { 0,0,0,0,0,32,0,100,152,0,252,0,252,0,0,0 },
  { 0,0,0,0,0,0,0,0,5,64,3,128,1,0,3,128,5,64,0,0,63,248,0,0,63,248,0,0,0,0,0,0 },
  { 0,0,0,48,72,132,0,100,152,0,100,152,0,0,0,0 },
  { 0,0,0,0,100,152,0,100,152,0,252,0,252,0,0,0 },
  { 0,0,0,0,0,252,0,252,0,16,16,124,16,16,0,0 },
  { 0,0,0,0,0,16,16,124,16,16,0,252,0,252,0,0 },
  { 0,0,0,0,0,0,0,252,0,252,0,152,100,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,248,0,0,43,248,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,252,0,0,126,252,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,222,0,0,123,222,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,72,0,252,0,252,0,72,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,72,0,0,63,252,0,0,63,252,0,0,63,252,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,48,0,192,3,0,12,64,16,160,12,64,3,0,0,192,0,48,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,0,6,0,1,128,4,96,10,16,4,96,1,128,6,0,24,0,0,0,0,0,0,0 },
  { 24,0,36,0,8,0,8,0,0,48,8,192,3,0,12,0,16,0,12,0,3,0,0,192,0,48,0,0,0,0,0,0 },
  { 0,48,0,72,0,16,0,16,24,0,6,16,1,128,0,96,0,16,0,96,1,128,6,0,24,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,96,1,128,6,0,8,0,6,0,1,128,8,96,6,0,1,128,0,96,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,12,0,3,0,0,192,0,32,0,192,3,0,12,32,0,192,3,0,12,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,96,1,128,6,0,8,64,6,0,1,128,8,96,6,0,1,128,0,96,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,12,0,3,0,0,192,8,32,0,192,3,0,12,32,0,192,3,0,12,0,0,0 },
  { 0,0,0,0,0,0,0,0,4,0,0,96,1,128,6,0,8,0,6,0,1,128,8,96,6,0,1,128,0,96,0,0 },
  { 0,0,0,0,0,0,0,0,0,64,12,0,3,0,0,192,0,32,0,192,3,0,12,32,0,192,3,0,12,0,0,0 },
  { 0,0,0,0,0,0,0,32,0,0,0,96,1,128,6,0,8,0,6,0,1,128,8,96,6,0,1,128,0,96,0,0 },
  { 0,0,0,0,0,0,8,0,0,0,12,0,3,0,0,192,0,32,0,192,3,0,12,32,0,192,3,0,12,0,0,0 },
  { 0,0,0,0,0,0,0,96,1,128,6,0,8,0,6,0,1,128,0,96,0,0,0,0,7,16,8,224,7,16,8,224 },
  { 0,0,0,0,0,0,12,0,3,0,0,192,0,32,0,192,3,0,12,0,0,0,0,0,14,32,17,192,14,32,17,192 },
  { 0,0,0,0,0,0,0,0,0,96,1,128,6,0,8,0,6,0,1,128,0,96,0,64,0,128,15,224,2,0,4,0 },
  { 0,0,0,0,0,0,0,0,12,0,3,0,0,192,0,32,0,192,3,0,12,0,4,0,2,0,15,224,0,128,0,64 },
  { 0,0,0,96,1,128,6,0,8,0,6,0,1,128,0,96,0,16,0,32,7,80,8,224,7,16,10,224,4,0,8,0 },
  { 0,0,12,0,3,0,0,192,0,32,0,192,3,0,12,0,0,32,0,64,14,160,17,192,14,32,21,192,8,0,16,0 },
  { 0,24,96,128,96,24,0,252,0,252,0,96,24,4,24,96 },
  { 0,96,24,4,24,96,0,252,0,252,0,24,96,128,96,24 },
  { 0,0,0,0,0,0,0,96,1,128,6,0,8,0,6,0,1,128,0,96,0,0,0,0,7,16,8,224,0,0,15,240 },
  { 0,0,0,0,0,0,12,0,3,0,0,192,0,32,0,192,3,0,12,0,0,0,0,0,14,32,17,192,0,0,31,224 },
  { 0,24,96,128,96,24,0,100,152,0,96,24,4,24,96,0 },
  { 0,96,24,4,24,96,0,152,100,0,24,96,128,96,24,0 },
  { 0,12,48,64,48,12,96,24,4,24,96,0,124,0,124,0 },
  { 0,96,24,4,24,96,12,48,64,48,12,0,124,0,124,0 },
  { 0,12,48,64,48,12,64,48,12,96,24,4,24,98,12,48 },
  { 0,48,12,2,12,48,2,12,48,6,24,32,24,70,48,12 },
  { 0,0,0,0,0,0,0,0,0,0,0,96,1,128,6,0,8,96,1,128,6,0,8,0,6,0,1,128,0,96,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,12,0,3,0,0,192,12,32,3,0,0,192,0,32,0,192,3,0,12,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,96,1,128,6,0,8,96,1,128,6,0,8,64,6,0,1,128,0,96,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,12,0,3,0,0,192,12,32,3,0,0,192,4,32,0,192,3,0,12,0,0,0 },
  { 0,0,0,0,0,0,0,0,15,224,0,0,15,224,0,0,0,96,1,128,6,0,8,0,6,0,1,128,0,96,0,0 },
  { 0,0,0,0,0,0,0,0,15,224,0,0,15,224,0,0,12,0,3,0,0,192,0,32,0,192,3,0,12,0,0,0 },
  { 0,0,0,0,0,96,1,128,6,0,8,96,1,128,6,0,8,96,1,128,6,0,8,0,6,0,1,128,0,96,0,0 },
  { 0,0,0,0,12,0,3,0,0,192,12,32,3,0,0,192,12,32,3,0,0,192,0,32,0,192,3,0,12,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,7,16,8,224,0,0,0,48,0,192,3,0,4,0,3,0,0,192,0,48,0,0 },
  { 0,0,0,0,0,0,0,0,7,16,8,224,0,0,0,0,12,0,3,0,0,192,0,32,0,192,3,0,12,0,0,0 },
  { 0,0,0,0,7,16,8,224,0,0,0,48,0,192,3,0,4,0,3,0,0,192,0,48,0,0,15,240,0,0,15,240 },
  { 0,0,0,0,8,224,7,16,0,0,12,0,3,0,0,192,0,32,0,192,3,0,12,0,0,0,15,240,0,0,15,240 },
  { 0,0,0,0,0,0,0,0,0,0,0,48,0,192,3,48,12,192,17,0,12,192,3,48,0,192,0,48,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,24,0,6,0,25,128,6,96,1,16,6,96,25,128,6,0,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,140,6,48,24,192,33,0,24,192,6,48,1,140,0,0,63,252,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,6,12,1,176,0,224,1,16,0,224,1,176,6,12,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,4,48,24,12,96,2,128,12,96,48,24,64,4,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,3,32,12,16,16,16,12,16,3,32,0,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,9,128,16,96,16,16,16,96,9,128,6,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,192,3,32,12,16,16,16,12,16,3,32,16,192,12,0,3,0,0,192,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,6,0,9,128,16,96,16,16,16,96,9,128,6,16,0,96,1,128,6,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,48,0,192,3,0,12,0,31,240,12,0,3,0,0,192,0,48,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,24,0,6,0,1,128,0,96,31,240,0,96,1,128,6,0,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,48,0,192,3,0,12,0,31,240,12,0,3,0,0,192,0,48,0,0,31,240,0,0,0,0 },
  { 0,0,0,0,0,0,24,0,6,0,1,128,0,96,31,240,0,96,1,128,6,0,24,0,0,0,31,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,128,4,64,60,120,0,0,63,248,0,0,63,248,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,16,0,32,0,192,3,0,28,0,3,0,0,192,0,32,0,16,0,0,31,240,0,0,0,0 },
  { 0,0,0,0,0,0,8,0,4,0,3,0,0,192,0,56,0,192,3,0,4,0,8,0,0,0,15,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,16,0,32,0,192,3,0,28,0,3,0,0,192,0,32,0,80,0,128,31,240,2,0,4,0 },
  { 0,0,0,0,0,0,16,0,8,0,6,0,1,128,0,112,1,128,6,0,8,0,16,128,1,0,31,240,4,0,8,0 },
  { 0,0,0,16,0,32,0,192,3,0,28,0,3,0,0,192,0,32,0,16,0,0,31,240,0,0,31,240,0,0,0,0 },
  { 0,0,16,0,8,0,6,0,1,128,0,112,1,128,6,0,8,0,16,0,0,0,31,240,0,0,31,240,0,0,0,0 },
  { 0,0,0,16,0,32,0,192,3,0,28,0,3,0,0,192,0,32,0,48,0,64,31,240,1,0,31,240,4,0,8,0 },
  { 0,0,16,0,8,0,6,0,1,128,0,112,1,128,6,0,8,0,16,64,0,128,31,240,2,0,31,240,8,0,16,0 },
  { 0,16,0,32,0,192,3,0,28,0,3,0,0,192,0,32,0,16,0,0,7,144,8,96,7,16,8,224,0,0,0,0 },
  { 16,0,8,0,6,0,1,128,0,112,1,128,6,0,8,0,16,0,0,0,14,32,17,192,14,32,17,192,0,0,0,0 },
  { 0,16,0,32,0,192,3,0,28,0,3,0,0,192,0,32,0,80,0,64,7,144,8,224,7,16,9,224,2,0,2,0 },
  { 16,0,8,0,6,0,1,128,0,112,1,128,6,0,8,0,16,128,0,128,15,32,17,192,14,32,19,192,4,0,4,0 },
  { 0,0,0,0,0,0,0,66,0,132,3,24,12,96,115,128,12,96,3,24,0,132,0,66,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,66,0,33,0,24,192,6,48,1,206,6,48,24,192,33,0,66,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,15,248,16,0,32,0,38,0,38,0,32,0,16,0,15,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,63,224,0,16,0,8,0,200,0,200,0,8,0,16,63,224,0,0,0,0 },
  { 0,0,0,62,64,64,64,62,0,8,8,62,8,8,0,0 },
  { 0,0,0,124,2,2,2,124,0,16,16,124,16,16,0,0 },
  { 0,0,0,62,64,64,64,62,0,34,20,8,20,34,0,0 },
  { 0,0,0,124,2,2,2,124,0,68,40,16,40,68,0,0 },
  { 0,0,0,0,24,24,0,62,64,64,64,62,0,126,0,0 },
  { 0,0,0,0,48,48,0,124,2,2,2,124,0,126,0,0 },
  { 0,0,0,0,0,62,64,64,64,62,0,126,0,126,0,0 },
  { 0,0,0,0,0,124,2,2,2,124,0,126,0,126,0,0 },
  { 0,0,0,0,0,0,0,0,15,248,16,0,32,0,32,0,32,0,32,0,16,0,15,248,0,0,7,16,8,224,0,0 },
  { 0,0,0,0,0,0,0,0,63,224,0,16,0,8,0,8,0,8,0,8,0,16,63,224,0,0,14,32,17,192,0,0 },
  { 0,0,0,0,0,62,64,64,64,62,0,50,76,50,76,0 },
  { 0,0,0,0,0,124,2,2,2,124,0,50,76,50,76,0 },
  { 0,0,0,0,62,64,64,64,62,0,4,126,8,126,16,0 },
  { 0,0,0,0,124,2,2,2,124,0,4,126,8,126,16,0 },
  { 0,0,0,0,0,0,0,0,127,254,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,127,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,127,254,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,254,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,7,240,8,16,16,16,16,16,16,16,16,16,8,16,7,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,31,192,16,32,16,16,16,16,16,16,16,16,16,32,31,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,240,8,16,16,16,16,16,16,16,16,16,8,16,7,240,0,0,31,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,192,16,32,16,16,16,16,16,16,16,16,16,32,31,192,0,0,31,240,0,0,0,0 },
  { 0,0,0,62,64,64,64,62,0,124,2,2,2,124,0,0 },
  { 0,0,0,124,2,2,2,124,0,62,64,64,64,62,0,0 },
  { 0,0,0,62,64,64,64,62,0,62,64,64,64,62,0,0 },
  { 0,0,0,124,2,2,2,124,0,124,2,2,2,124,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,124,2,128,2,128,2,128,124,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,124,2,128,15,224,2,128,124,124,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,192,9,32,17,16,17,16,17,16,17,16,17,16,17,16,17,16,17,16,0,0,0,0 },
  { 0,0,0,0,15,224,1,0,7,192,9,32,17,16,17,16,17,16,17,16,17,16,17,16,17,16,17,16,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,7,192,9,32,17,16,17,16,17,16,17,16,17,16,17,16,17,16,17,16,1,0,1,0 },
  { 0,0,0,0,0,0,0,0,1,0,1,16,1,32,1,64,1,128,17,16,19,16,21,16,9,32,23,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,1,0,17,16,17,16,17,16,9,32,7,192,0,0,0,0 },
  { 0,0,0,0,0,4,4,4,4,60,4,4,4,4,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,240,1,0,1,0,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,31,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,1,0,1,56,1,64,1,48,1,8,1,112,1,0,63,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,32,0,32,0,63,240,32,0,63,240,32,0,63,240,32,0,32,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,20,0,20,0,20,0,20,63,244,0,20,0,20,0,20,0,20,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,0,8,0,8,31,248,0,8,31,248,0,8,0,8,0,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,20,0,20,0,20,63,244,0,20,63,244,0,20,0,20,0,20,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,40,0,40,0,40,0,40,0,63,252,40,0,40,0,40,0,40,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,31,240,0,0,31,240,1,0,1,0,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,31,240,0,0,31,240,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,1,0,1,0,31,240,0,0,31,240,1,0,1,0,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,31,240,2,128,2,128,2,128,2,128,2,128,2,128,2,128,2,128,2,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,128,2,128,2,128,2,128,2,128,2,128,2,128,2,128,2,128,31,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,248,0,8,31,248,0,8,0,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,248,16,0,31,248,16,0,16,0,0,0,0,0,0,0 },
  { 0,0,0,0,16,16,16,80,48,16,24,20,16,16,0,0 },
  { 0,0,0,0,56,68,68,56,16,16,16,16,16,16,0,0 },
  { 0,0,0,0,16,16,16,16,16,16,56,68,68,56,0,0 },
  { 0,0,0,0,124,16,16,16,16,16,56,68,68,56,0,0 },
  { 0,0,0,0,40,40,40,40,40,254,40,40,40,40,0,0 },
  { 0,0,0,0,0,0,0,0,2,64,2,64,2,64,2,64,2,64,7,80,10,224,2,64,2,64,2,64,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,9,32,9,32,9,32,9,32,9,32,9,32,9,32,9,32,9,32,9,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,9,32,9,32,9,32,9,32,9,32,63,248,9,32,9,32,9,32,9,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,16,0,0,16,0,0,16,0,0 },
  { 0,0,0,0,0,0,0,24,0,96,1,152,6,96,25,152,34,32,25,152,6,96,1,152,0,96,0,24,0,0,0,0 },
  { 0,0,0,0,0,0,48,0,12,0,51,0,12,192,51,48,8,136,51,48,12,192,51,0,12,0,48,0,0,0,0,0 },
  { 0,0,0,0,0,96,1,128,6,0,8,0,6,0,1,128,8,96,6,0,1,128,8,96,6,0,1,128,0,96,0,0 },
  { 0,0,0,0,12,0,3,0,0,192,0,32,0,192,3,0,12,32,0,192,3,0,12,32,0,192,3,0,12,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,72,2,72,4,144,4,144,9,32,9,32,18,64,18,64,36,128,36,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,9,32,9,32,9,32,9,32,9,32,9,32,9,32,9,32,9,32,9,32,0,0 },
  { 0,0,0,0,0,0,0,0,0,144,0,144,1,32,1,32,2,64,2,64,4,128,4,128,9,0,9,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,56,40,40,40,40,56,0,0 },
  { 0,0,0,0,56,40,40,40,40,40,40,40,40,56,0,0 },
  { 0,0,0,0,0,0,1,248,1,8,0,136,1,8,2,40,4,88,8,128,17,0,34,0,20,0,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,0,33,0,34,0,33,0,40,128,52,64,2,32,1,16,0,136,0,80,0,32,0,0,0,0 },
  { 0,0,0,0,0,0,8,0,20,0,34,0,17,0,8,128,4,88,2,40,1,8,0,136,1,8,1,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,32,0,80,0,136,1,16,2,32,52,64,40,128,33,0,34,0,33,0,63,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,16,24,24,47,244,64,2,47,244,24,24,8,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,0,24,0,63,252,127,252,63,252,24,0,8,0,0,0,0,0,0,0 },
  { 0,0,16,56,124,254,56,56,56,56,56,56,56,56,0,0 },
  { 0,0,56,56,56,56,56,56,56,56,254,124,56,16,0,0 },
  { 0,0,0,0,0,0,1,248,1,248,0,248,1,248,3,248,7,216,15,128,31,0,62,0,28,0,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,63,0,63,0,62,0,63,0,63,128,55,192,3,224,1,240,0,248,0,112,0,32,0,0,0,0 },
  { 0,0,0,0,0,0,8,0,28,0,62,0,31,0,15,128,7,216,3,248,1,248,0,248,1,248,1,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,32,0,112,0,248,1,240,3,224,55,192,63,128,63,0,62,0,63,0,63,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,16,24,24,63,252,127,254,63,252,24,24,8,16,0,0,0,0,0,0 },
  { 0,0,16,56,124,254,56,56,56,56,254,124,56,16,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,248,0,8,0,42,0,28,0,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,0,28,0,42,0,8,255,248,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,16,0,84,0,56,0,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,0,56,0,84,0,16,0,31,255,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,31,248,31,248,31,248,31,248,31,248,16,8,16,8,16,8,16,8,31,248,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,31,248,16,8,16,8,16,8,16,8,31,248,31,248,31,248,31,248,31,248,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,31,248,31,248,23,248,19,248,17,248,16,248,16,120,16,56,16,24,31,248,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,31,248,24,8,28,8,30,8,31,8,31,136,31,200,31,232,31,248,31,248,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,3,64,7,32,15,16,31,8,31,8,15,16,7,32,3,64,1,128,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,2,192,4,224,8,240,16,248,16,248,8,240,4,224,2,192,1,128,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,3,192,7,224,15,240,31,248,16,8,8,16,4,32,2,64,1,128,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,128,2,64,4,32,8,16,16,8,31,248,15,240,7,224,3,192,1,128,0,0 },
  { 0,0,0,0,0,0,42,168,0,0,32,8,0,0,32,8,0,0,32,8,0,0,32,8,0,0,42,168,0,0,0,0 },
  { 0,0,127,254,127,254,127,254,127,254,127,254,127,254,127,254,127,254,127,254,127,254,127,254,127,254,127,254,127,254,0,0 },
  { 0,0,127,254,64,2,64,2,64,2,64,2,64,2,64,2,64,2,64,2,64,2,64,2,64,2,64,2,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,60,60,60,60,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,60,36,36,60,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,3,192,7,224,15,240,31,248,63,252,31,248,31,248,15,240,15,240,7,224,0,0,0,0 },
  { 0,0,0,0,0,0,1,128,2,64,4,32,8,16,16,8,32,4,16,8,16,8,8,16,8,16,7,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,0,6,192,24,48,32,8,32,8,32,8,32,8,32,8,24,48,6,192,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,0,7,192,31,240,63,248,63,248,63,248,63,248,63,248,31,240,7,192,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,7,224,15,240,31,248,63,252,127,254,127,254,63,252,31,248,15,240,7,224,0,0,0,0 },
  { 0,0,0,0,0,0,15,240,31,248,63,252,127,254,127,254,127,254,127,254,127,254,127,254,127,254,63,252,31,248,15,240 },
  { 0,0,0,0,0,0,0,16,56,124,254,124,56,16,0,0 },
  { 0,0,0,0,0,0,0,16,40,68,130,68,40,16,0,0 },
  { 0,0,0,16,56,56,124,124,254,124,124,56,56,16,0,0 },
  { 0,0,0,16,40,40,68,68,130,68,68,40,40,16,0,0 },
  { 0,0,0,0,0,0,16,56,124,56,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,16,56,56,124,56,56,16,0,0 },
  { 0,0,0,0,0,0,0,16,40,40,68,40,40,16,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,224,127,252,255,254,255,254,127,252,15,224,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,224,112,28,128,2,128,2,112,28,15,224,0,0,0,0 },
  { 0,24,60,60,60,126,126,126,126,126,60,60,60,24,0,0 },
  { 0,24,36,36,36,66,66,66,66,66,36,36,36,24,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,224,33,16,127,255,33,16,16,224,0,0,0,0,0,0,0,0 },
  { 0,0,16,0,32,0,127,254,32,0,16,0,16,0,32,0,127,254,32,0,16,0,16,0,32,0,127,254,32,0,16,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,224,33,80,127,255,33,80,16,224,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,16,34,168,122,175,36,64,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,32,40,32,127,255,40,32,20,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,80,40,80,127,255,40,80,20,80,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,2,40,2,127,254,40,2,20,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,2,40,4,126,216,40,4,20,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,106,170,32,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,66,32,68,127,248,32,68,16,66,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,162,32,164,127,248,32,164,16,162,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,2,40,4,127,248,40,4,20,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,66,40,68,127,248,40,68,20,66,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,162,40,164,127,248,40,164,20,162,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,72,40,48,127,255,40,48,20,72,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,60,32,66,127,129,32,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,248,0,0,17,248,32,0,127,255,32,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,28,2,34,17,192,32,0,127,255,32,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,127,255,32,28,18,34,1,192,0,28,2,34,1,192 },
  { 0,0,0,0,0,0,0,0,0,0,112,0,12,0,3,8,0,132,15,254,0,132,3,8,12,0,112,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,126,0,1,0,0,128,0,72,0,68,127,254,0,68,0,72,0,128,1,0,126,0,0,0 },
  { 0,0,0,0,0,0,0,0,4,0,8,0,31,254,32,0,127,254,128,0,127,254,32,0,31,254,8,0,4,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,64,0,32,255,240,0,8,255,252,0,2,255,252,0,8,255,240,0,32,0,64,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,3,128,68,64,56,8,0,4,255,254,0,4,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,4,255,254,3,132,68,72,56,0,3,128,68,64,56,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,192,2,34,16,28,32,0,127,255,32,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,127,255,33,192,18,34,0,28,1,192,2,34,0,28 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,127,255,32,0,16,28,2,34,1,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,4,255,254,0,4,3,136,68,64,56,0,0,0,0,0 },
  { 0,0,0,0,0,128,1,0,2,0,4,0,8,0,31,248,0,16,0,32,0,64,2,128,3,0,3,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,28,12,20,16,32,32,0,0 },
  { 0,0,0,0,0,0,0,0,32,32,16,20,12,28,0,0 },
  { 0,0,1,0,1,0,2,128,2,128,124,124,32,8,16,16,8,32,4,64,8,32,17,16,38,200,56,56,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,3,128,3,128,63,248,31,240,15,224,15,224,30,240,60,120,48,24,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,2,128,2,128,60,120,16,16,8,32,9,32,18,144,44,104,48,24,0,0,0,0,0,0 },
  { 0,0,0,0,0,128,3,192,15,224,31,240,31,248,31,252,31,252,31,248,31,240,15,224,3,192,0,128,0,0,0,0 },
  { 0,0,0,0,0,128,3,64,12,32,16,16,16,8,16,4,16,4,16,8,16,16,12,32,3,64,0,128,0,0,0,0 },
  { 0,0,7,192,15,224,24,48,48,24,96,12,96,12,96,12,96,12,96,12,48,24,24,48,15,224,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,15,224,31,240,48,24,103,204,104,44,104,44,103,204,48,24,31,240,15,224,0,0,0,0,0,0 },
  { 0,0,7,192,15,224,24,48,48,24,99,140,100,76,100,76,100,76,99,140,48,24,24,48,15,224,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,128,15,224,12,96,24,48,24,48,24,48,12,96,15,224,3,128,0,0,0,0,0,0 },
  { 0,0,7,192,15,224,24,48,56,56,100,76,98,140,97,12,98,140,100,76,56,56,24,48,15,224,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,3,192,4,32,4,32,8,64,9,80,8,224,16,64,16,0,16,0,32,0,32,0,0,0,0,0 },
  { 0,0,0,0,0,0,15,0,16,128,16,128,8,64,8,64,0,32,0,32,0,16,0,84,0,56,0,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,32,0,112,0,168,0,32,0,64,0,64,0,64,0,64,0,128,0,128,15,128,0,0,0,0 },
  { 0,0,0,0,0,0,15,128,0,128,0,128,0,64,0,64,0,64,0,64,0,32,0,168,0,112,0,32,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,1,0,1,0,1,0,2,0,2,0,2,32,2,16,4,120,5,144,6,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,32,4,16,4,120,5,144,6,32,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,48,0,127,254,48,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,3,128,7,192,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,12,127,254,0,12,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,7,192,3,128,1,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,8,96,12,255,254,96,12,32,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,3,128,7,192,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,7,192,3,128,1,0 },
  { 0,0,0,0,0,0,0,0,30,0,28,0,28,0,18,0,1,0,0,128,0,64,0,32,0,16,0,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,120,0,56,0,56,0,72,0,128,1,0,2,0,4,0,8,0,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,0,8,0,4,0,2,0,1,0,0,128,0,72,0,56,0,56,0,120,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,0,16,0,32,0,64,0,128,1,0,18,0,28,0,28,0,30,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,48,0,125,182,48,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,3,128,7,192,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,12,109,190,0,12,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,0,0,1,0,1,0,7,192,3,128,1,0 },
  { 0,0,0,0,0,0,0,0,28,0,12,16,20,8,32,4,32,4,32,4,32,4,32,4,16,8,8,16,7,224,0,0 },
  { 0,0,0,0,0,0,0,0,0,56,8,48,16,40,32,4,32,4,32,4,32,4,32,4,16,8,8,16,7,224,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,0,76,0,95,254,76,0,68,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,7,192,0,0,1,0,3,128,7,192,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,34,0,50,127,250,0,50,0,34,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,7,192,3,128,1,0,0,0,7,192 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,182,125,182,123,134,119,246,119,246,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,134,125,190,123,134,119,246,119,134,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,15,192,0,0,7,128,7,0,7,0,4,128,0,64,0,32,0,16,0,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,248,0,0,0,240,0,112,0,112,0,144,1,0,2,0,4,0,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,8,0,4,0,2,0,1,0,0,144,0,112,0,112,0,240,0,0,1,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,8,0,16,0,32,0,64,4,128,7,0,7,0,7,128,0,0,15,192,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,64,17,64,49,64,127,254,49,64,17,64,1,64,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,3,128,7,192,1,0,1,0,1,0,1,0,15,224,1,0,15,224,1,0,1,0,1,0,1,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,2,128,2,136,2,140,127,254,2,140,2,136,2,128,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,1,0,1,0,15,224,1,0,15,224,1,0,1,0,1,0,1,0,7,192,3,128,1,0 },
  { 0,0,0,0,0,0,0,0,68,0,76,0,95,254,76,0,68,0,0,34,0,50,127,250,0,50,0,34,0,0,0,0 },
  { 0,0,0,0,4,248,4,0,4,32,4,112,4,248,4,32,4,32,4,32,4,32,31,32,14,32,4,32,0,32,31,32 },
  { 0,0,0,0,0,0,0,0,16,0,48,0,127,254,48,0,16,0,0,8,0,12,127,254,0,12,0,8,0,0,0,0 },
  { 0,0,0,0,4,32,14,32,31,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,248,4,112,4,32 },
  { 0,0,0,0,0,0,0,0,0,8,0,12,127,254,0,12,0,8,16,0,48,0,127,254,48,0,16,0,0,0,0,0 },
  { 0,0,0,0,4,32,4,112,4,248,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,31,32,14,32,4,32 },
  { 0,0,0,0,0,0,16,0,48,0,127,254,48,0,16,0,0,0,16,0,48,0,127,254,48,0,16,0,0,0,0,0 },
  { 0,0,0,0,8,32,28,112,62,248,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32 },
  { 0,0,0,0,0,0,0,8,0,12,127,254,0,12,0,8,0,0,0,8,0,12,127,254,0,12,0,8,0,0,0,0 },
  { 0,0,0,0,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,62,248,28,112,8,32 },
  { 0,0,3,224,7,240,14,248,28,252,56,252,48,0,32,0,48,0,56,252,28,252,14,248,7,240,3,224,0,0,0,0 },
  { 0,0,0,0,3,224,7,112,14,56,28,28,56,14,48,6,62,62,62,62,62,62,30,60,14,56,6,48,0,0,0,0 },
  { 0,0,7,192,15,224,31,112,63,56,63,28,0,12,0,4,0,12,63,28,63,56,31,112,15,224,7,192,0,0,0,0 },
  { 0,0,0,0,6,48,14,56,30,60,62,62,62,62,62,62,48,6,56,14,28,28,14,56,7,112,3,224,0,0,0,0 },
  { 0,0,0,0,8,0,24,0,63,240,24,8,8,4,0,2,0,2,0,2,0,2,0,4,0,8,15,240,0,0,0,0 },
  { 0,0,0,0,0,0,0,8,0,28,16,62,16,8,16,8,16,8,16,8,16,8,16,8,8,16,4,32,3,192,0,0 },
  { 0,0,0,0,7,248,8,0,16,0,32,0,32,0,32,0,32,0,16,8,8,12,7,254,0,12,0,8,0,0,0,0 },
  { 0,0,0,0,0,0,0,240,1,8,2,4,4,2,4,2,4,2,4,2,4,2,4,2,31,2,14,0,4,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,30,0,2,0,4,16,4,48,8,127,248,48,0,16,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,120,0,64,0,32,0,32,8,16,12,31,254,0,12,0,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,127,126,0,2,0,2,2,2,6,2,111,254,6,0,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,126,254,64,0,64,0,64,64,64,96,127,246,0,96,0,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,32,0,64,62,252,32,68,32,36,168,0,112,4,32,14,0,21,36,4,34,4,63,124,2,0,4,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,48,127,248,127,252,127,248,0,48,0,32,0,0,0,0,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,115,206,109,190,113,142,125,182,115,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,115,134,109,246,113,238,125,222,115,222,127,254,0,0 },
  { 0,0,0,0,0,4,0,56,0,200,3,16,12,16,48,32,64,64,63,224,15,240,3,240,0,248,0,56,0,4,0,0 },
  { 0,0,0,0,1,0,2,128,2,128,6,64,6,64,14,32,14,32,30,16,31,16,62,136,60,104,48,24,64,4,0,0 },
  { 0,0,0,0,64,0,56,0,38,0,17,128,16,96,8,24,4,4,15,248,31,224,31,128,62,0,56,0,64,0,0,0 },
  { 0,0,0,0,64,4,48,24,44,120,34,248,17,240,16,240,8,224,8,224,4,192,4,192,2,128,2,128,1,0,0,0 },
  { 0,0,0,0,0,4,0,56,0,248,3,240,15,240,63,224,127,192,63,224,15,240,3,240,0,248,0,56,0,4,0,0 },
  { 0,0,0,0,1,0,3,128,3,128,7,192,7,192,15,224,15,224,31,240,31,240,62,248,60,120,48,24,64,4,0,0 },
  { 0,0,0,0,64,0,56,0,62,0,31,128,31,224,15,248,7,252,15,248,31,224,31,128,62,0,56,0,64,0,0,0 },
  { 0,0,0,0,64,4,48,24,60,120,62,248,31,240,31,240,15,224,15,224,7,192,7,192,3,128,3,128,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,2,0,2,0,2,0,2,16,2,48,2,127,254,48,0,16,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,0,64,0,64,0,64,0,64,8,64,12,127,254,0,12,0,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,0,48,0,127,254,48,2,16,2,0,2,0,2,0,2,0,2,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,0,12,127,254,64,12,64,8,64,0,64,0,64,0,64,0,0,0,0,0 },
  { 0,0,0,0,4,0,14,0,31,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,7,240,0,0 },
  { 0,0,0,0,0,64,0,224,1,240,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,31,192,0,0 },
  { 0,0,0,0,7,240,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,31,0,14,0,4,0,0,0 },
  { 0,0,0,0,31,192,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,1,240,0,224,0,64,0,0 },
  { 0,0,0,0,0,0,0,2,16,2,48,6,127,252,255,252,127,248,48,0,16,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,128,0,128,16,192,24,127,252,127,254,63,252,0,24,0,16,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,0,48,0,127,248,255,252,127,252,48,6,16,2,0,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,16,0,24,63,252,127,254,127,252,192,24,128,16,128,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,2,0,7,0,15,128,31,192,7,0,7,0,7,0,7,0,7,0,7,0,3,128,0,224,0,0 },
  { 0,0,0,0,0,0,1,0,3,128,7,192,15,224,3,128,3,128,3,128,3,128,3,128,3,128,7,0,28,0,0,0 },
  { 0,0,0,0,0,0,0,224,3,128,7,0,7,0,7,0,7,0,7,0,7,0,31,192,15,128,7,0,2,0,0,0 },
  { 0,0,0,0,0,0,28,0,7,0,3,128,3,128,3,128,3,128,3,128,3,128,15,224,7,192,3,128,1,0,0,0 },
  { 0,0,0,34,0,54,0,42,0,34,0,34,4,34,10,34,19,252,32,4,64,8,32,16,19,224,10,0,4,0,0,0 },
  { 0,0,68,0,108,0,84,0,68,0,68,0,68,32,68,80,63,200,32,4,16,2,8,4,7,200,0,80,0,32,0,0 },
  { 0,0,4,0,10,0,19,224,32,16,64,8,32,4,19,252,10,34,4,34,0,34,0,34,0,42,0,54,0,34,0,0 },
  { 0,0,0,32,0,80,7,200,8,4,16,2,32,4,63,200,68,80,68,32,68,0,68,0,84,0,108,0,68,0,0,0 },
  { 0,0,4,0,10,0,17,0,32,128,64,64,49,128,17,0,17,0,17,0,17,254,9,4,5,8,3,4,0,254,0,0 },
  { 0,0,0,32,0,80,0,136,1,4,2,2,1,140,0,136,0,136,0,136,127,136,32,144,16,160,32,192,127,0,0,0 },
  { 0,0,0,254,3,4,5,8,9,4,17,254,17,0,17,0,17,0,49,128,64,64,32,128,17,0,10,0,4,0,0,0 },
  { 0,0,127,0,32,192,16,160,32,144,127,136,0,136,0,136,0,136,1,140,2,2,1,4,0,136,0,80,0,32,0,0 },
  { 0,0,1,0,2,128,4,64,15,224,16,16,12,96,4,64,4,64,7,192,0,0,7,192,4,64,7,192,0,0,0,0 },
  { 0,0,0,0,0,0,127,252,64,4,65,4,66,132,68,68,72,36,80,20,64,4,64,4,64,4,127,252,0,0,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,134,109,182,99,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,142,109,182,99,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,198,109,190,99,190,109,190,99,198,127,254,0,0 },
  { 0,0,0,0,0,0,127,252,64,4,72,36,68,68,66,132,65,4,66,132,68,68,72,36,64,4,127,252,0,0,0,0 },
  { 0,0,0,0,7,192,8,32,16,16,32,8,36,72,66,132,65,4,66,132,36,72,32,8,16,16,8,32,7,192,0,0 },
  { 0,0,0,0,7,192,31,240,56,56,48,24,100,76,98,140,97,12,98,140,100,76,48,24,56,56,31,240,7,192,0,0 },
  { 0,0,0,0,0,0,127,252,127,252,127,252,127,252,127,252,127,252,127,252,127,252,127,252,127,252,127,252,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,3,128,7,192,15,224,31,240,63,248,31,240,15,224,7,192,3,128,1,0,0,0,0,0 },
  { 0,0,0,0,0,0,7,224,15,240,15,240,31,248,31,248,63,252,63,252,31,248,15,240,7,224,3,192,1,128,0,0 },
  { 0,0,0,0,7,192,15,224,31,240,63,248,127,252,127,252,127,252,127,252,127,252,63,248,31,240,15,224,7,192,0,0 },
  { 0,0,3,128,7,192,63,248,63,248,63,248,127,252,255,254,255,254,255,254,127,252,63,248,63,248,63,248,7,192,3,128 },
  { 0,0,0,0,1,0,3,128,3,128,7,192,7,192,15,224,15,224,31,240,31,240,63,248,63,248,127,252,0,0,0,0 },
  { 0,0,0,0,0,0,127,252,63,248,63,248,31,240,31,240,15,224,15,224,7,192,7,192,3,128,3,128,1,0,0,0 },
  { 0,0,0,0,0,8,0,56,0,248,3,248,15,248,63,248,127,248,63,248,15,248,3,248,0,248,0,56,0,8,0,0 },
  { 0,0,0,0,64,0,112,0,124,0,127,0,127,192,127,240,127,248,127,240,127,192,127,0,124,0,112,0,64,0,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,113,206,111,182,111,198,111,246,113,206,127,254,0,0 },
  { 0,0,0,0,7,192,15,224,31,240,63,248,63,248,127,252,127,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,252,127,252,63,248,63,248,31,240,15,224,7,192,0,0 },
  { 1,0,1,0,3,128,3,128,7,192,15,224,63,248,255,254,63,248,15,224,7,192,3,128,3,128,1,0,1,0,0,0 },
  { 0,0,0,0,0,0,32,8,16,16,12,96,15,224,7,192,7,192,7,192,15,224,12,96,16,16,32,8,0,0,0,0 },
  { 1,0,1,0,3,128,2,128,4,64,8,32,48,24,224,14,48,24,8,32,4,64,2,128,3,128,1,0,1,0,0,0 },
  { 0,0,0,0,64,2,56,28,36,36,35,196,16,8,8,16,8,16,8,16,8,16,16,8,35,196,36,36,56,28,64,2 },
  { 0,0,0,0,1,0,1,0,63,248,33,8,33,8,33,8,252,126,33,8,33,8,33,8,63,248,1,0,1,0,0,0 },
  { 0,0,0,0,1,0,2,128,4,64,11,160,20,80,32,72,65,132,33,8,16,16,9,32,4,64,2,128,1,0,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,134,109,246,109,134,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,142,109,246,109,198,109,246,99,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,182,109,182,109,134,109,246,99,246,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,134,109,190,109,134,109,246,99,134,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,206,109,190,109,142,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,134,109,246,109,238,109,222,99,222,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,206,109,182,109,206,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,206,109,182,109,198,109,246,99,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,134,109,182,109,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,142,109,182,109,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,198,109,190,109,190,109,190,99,198,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,142,109,182,109,182,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,134,109,190,109,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,99,134,109,190,109,142,109,190,99,190,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,206,111,182,99,182,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,238,111,206,99,238,111,238,97,198,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,134,111,246,99,134,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,142,111,246,99,198,111,246,97,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,182,111,182,99,134,111,246,97,246,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,134,111,190,99,134,111,246,97,134,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,206,111,190,99,142,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,134,111,246,99,238,111,222,97,222,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,206,111,182,99,206,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,206,111,182,99,198,111,246,97,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,134,111,182,99,134,111,182,97,182,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,142,111,182,99,142,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,198,111,190,99,190,111,190,97,198,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,142,111,182,99,182,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,134,111,190,99,142,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,134,111,190,99,142,111,190,97,190,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,206,111,182,99,182,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,238,111,206,99,238,111,238,111,198,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,134,111,246,99,134,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,142,111,246,99,198,111,246,111,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,182,111,182,99,134,111,246,111,246,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,134,111,190,99,134,111,246,111,134,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,142,111,182,97,142,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,0,0,16,16,16,16,124,84,84,16,16,16,0,0 },
  { 0,0,0,0,146,146,146,146,254,128,128,128,128,254,0,0 },
  { 0,0,0,0,68,170,108,40,68,68,68,68,68,56,0,0 },
  { 0,0,0,0,96,144,144,112,32,32,76,82,146,140,0,0 },
  { 0,0,0,0,56,68,68,68,68,68,40,108,170,68,0,0 },
  { 0,0,0,0,56,68,4,28,4,28,4,4,68,56,0,0 },
  { 0,0,0,0,0,0,130,68,40,40,108,146,146,108,0,0 },
  { 0,0,0,0,56,68,130,68,56,254,146,100,40,16,0,0 },
  { 0,0,0,0,0,32,80,136,136,255,141,141,85,34,0,0 },
  { 0,0,0,0,124,108,146,146,124,16,16,16,16,56,0,0 },
  { 0,0,0,0,124,108,146,146,108,40,68,68,130,254,0,0 },
  { 0,0,0,0,254,130,68,40,84,130,130,130,68,56,0,0 },
  { 0,0,0,0,98,101,101,102,150,150,150,153,145,0,0,0 },
  { 0,0,0,0,32,32,32,60,4,4,60,32,32,32,0,0 },
  { 0,0,0,0,56,68,68,68,68,124,170,170,170,68,0,0 },
  { 0,0,0,0,0,0,0,0,15,248,18,164,18,164,12,152,0,128,3,224,7,112,9,72,9,72,6,48,0,0,0,0 },
  { 0,0,0,0,60,34,34,34,252,160,160,32,32,32,0,0 },
  { 0,0,0,0,28,34,30,2,2,2,2,30,34,28,0,0 },
  { 0,0,0,0,62,42,42,42,228,32,32,32,32,32,0,0 },
  { 0,0,0,0,64,64,64,64,124,66,66,66,66,124,0,0 },
  { 0,0,0,0,56,68,130,130,130,84,40,68,130,254,0,0 },
  { 0,0,0,0,254,170,170,170,170,170,170,170,170,68,0,0 },
  { 0,0,0,0,72,180,108,36,39,36,36,108,180,72,0,0 },
  { 0,0,0,0,16,16,56,84,146,146,146,146,84,56,16,16 },
  { 0,0,0,0,32,32,32,32,32,32,44,50,82,140,0,0 },
  { 0,0,0,0,124,170,170,146,130,130,146,170,170,124,0,0 },
  { 0,0,0,0,30,18,18,18,114,146,146,146,146,114,0,0 },
  { 0,0,0,0,146,146,146,146,254,68,130,130,68,56,0,0 },
  { 0,0,0,0,113,145,145,106,10,10,10,4,4,4,0,0 },
  { 0,0,0,0,68,68,124,146,254,68,130,130,68,56,0,0 },
  { 0,0,0,0,146,146,146,146,146,146,146,146,146,254,0,0 },
  { 0,0,0,0,0,0,0,0,3,248,1,16,0,160,0,224,31,16,21,16,8,224,0,160,1,16,3,248,0,0,0,0 },
  { 0,0,0,0,126,66,36,24,248,152,164,36,66,126,0,0 },
  { 0,0,0,0,16,40,40,68,68,124,146,146,146,254,0,0 },
  { 0,0,32,144,120,108,68,130,130,130,130,68,108,60,18,8 },
  { 0,0,0,0,124,74,74,74,76,80,80,96,96,64,0,0 },
  { 0,0,0,0,28,34,32,96,184,96,32,32,34,28,0,0 },
  { 0,0,0,0,12,18,16,48,220,176,16,16,18,12,0,0 },
  { 0,0,0,0,16,40,76,146,254,68,68,68,68,124,0,0 },
  { 0,0,0,0,0,0,0,0,28,56,34,68,2,64,14,192,3,112,14,192,2,64,2,64,34,68,28,56,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,56,112,68,136,60,128,5,128,6,224,5,128,4,128,60,128,68,136,56,112,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,56,40,68,76,64,146,192,255,112,56,192,68,64,130,64,68,68,56,56,0,0,0,0 },
  { 0,0,0,0,24,36,36,36,255,165,36,36,36,24,0,0 },
  { 0,0,0,0,248,136,80,112,142,138,112,80,136,248,0,0 },
  { 0,0,0,0,28,4,4,4,4,4,4,4,8,16,0,0 },
  { 0,0,0,0,130,194,178,138,254,138,178,194,130,2,0,0 },
  { 0,0,0,0,36,84,86,82,82,82,86,90,82,82,0,0 },
  { 0,0,127,254,97,198,125,190,97,190,111,190,97,198,127,254,127,254,97,134,125,190,97,142,111,190,97,190,127,254,0,0 },
  { 0,0,0,0,0,0,16,16,16,124,84,84,16,16,0,0 },
  { 0,0,0,0,0,0,42,42,42,62,32,32,32,62,0,0 },
  { 0,0,0,0,0,0,68,170,108,40,68,68,68,56,0,0 },
  { 0,0,0,0,0,0,96,144,144,112,44,82,146,140,0,0 },
  { 0,0,0,0,0,0,56,68,68,68,40,108,170,68,0,0 },
  { 0,0,0,0,0,0,56,68,28,4,28,4,68,56,0,0 },
  { 0,0,0,0,0,0,0,0,198,40,108,146,146,108,0,0 },
  { 0,0,0,0,0,0,28,34,28,127,73,50,20,8,0,0 },
  { 0,0,0,0,0,0,0,32,80,136,255,141,85,34,0,0 },
  { 0,0,0,0,0,0,124,108,146,146,124,16,16,56,0,0 },
  { 0,0,0,0,0,0,124,108,146,146,108,68,130,254,0,0 },
  { 0,0,0,0,0,0,254,130,68,40,84,68,68,56,0,0 },
  { 0,0,0,0,0,0,68,74,74,172,172,178,162,0,0,0 },
  { 0,0,0,0,0,0,32,32,60,4,4,60,32,32,0,0 },
  { 0,0,0,0,0,0,24,36,36,36,60,90,90,36,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,31,240,37,72,25,48,1,0,7,192,14,224,18,144,12,96,0,0,0,0 },
  { 0,0,0,0,0,0,28,18,18,124,80,80,16,16,0,0 },
  { 0,0,0,0,0,0,28,34,30,2,2,30,34,28,0,0 },
  { 0,0,0,0,0,0,62,42,42,42,100,32,32,32,0,0 },
  { 0,0,0,0,0,0,64,64,64,120,68,68,68,120,0,0 },
  { 0,0,0,0,0,0,56,68,68,84,40,68,130,254,0,0 },
  { 0,0,0,0,0,0,254,170,170,170,170,170,170,68,0,0 },
  { 0,0,0,0,0,0,72,180,108,38,36,108,180,72,0,0 },
  { 0,0,0,0,0,0,16,16,56,84,146,146,84,56,16,16 },
  { 0,0,0,0,0,0,32,32,32,32,44,50,82,140,0,0 },
  { 0,0,0,0,0,0,124,170,146,130,130,146,170,124,0,0 },
  { 0,0,0,0,0,0,14,10,10,58,74,74,74,58,0,0 },
  { 0,0,0,0,0,0,42,42,42,62,20,34,34,28,0,0 },
  { 0,0,0,0,0,0,98,162,162,116,20,20,8,8,0,0 },
  { 0,0,0,0,0,0,68,124,146,254,68,68,68,56,0,0 },
  { 0,0,0,0,0,0,84,84,84,84,84,84,84,124,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,248,1,16,0,224,31,16,21,16,8,224,1,16,3,248,0,0,0,0 },
  { 0,0,0,0,0,0,62,34,20,120,72,84,34,62,0,0 },
  { 0,0,0,0,0,0,0,16,40,68,124,146,146,254,0,0 },
  { 0,0,0,0,32,144,120,108,68,130,130,68,108,60,18,8 },
  { 0,0,0,0,0,0,120,84,84,88,80,80,96,64,0,0 },
  { 0,0,0,0,0,0,12,18,48,92,48,16,18,12,0,0 },
  { 0,0,0,0,0,0,4,10,24,110,88,8,10,4,0,0 },
  { 0,0,0,0,0,0,16,40,76,146,254,68,68,124,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,28,56,34,68,14,192,3,112,14,192,2,64,34,68,28,56,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,28,56,34,68,30,192,3,112,2,192,30,64,34,68,28,56,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,28,20,34,38,96,73,184,127,96,28,32,34,34,28,28,0,0,0,0 },
  { 0,0,0,0,0,0,16,40,40,254,170,40,40,16,0,0 },
  { 0,0,0,0,0,0,120,72,48,78,74,48,72,120,0,0 },
  { 0,0,0,0,0,0,28,4,4,4,4,4,8,16,0,0 },
  { 0,0,0,0,0,0,2,98,82,74,126,74,82,98,0,0 },
  { 0,0,0,0,0,0,36,84,86,82,86,90,82,82,0,0 },
  { 0,0,127,254,97,198,125,190,97,190,111,190,97,198,127,254,127,254,97,134,111,190,97,142,125,190,97,190,127,254,0,0 },
  { 0,0,0,0,32,32,32,112,32,112,32,32,32,62,0,0 },
  { 0,0,0,48,16,16,16,56,16,56,16,16,16,124,0,0 },
  { 0,0,0,0,16,16,16,16,52,88,16,16,16,31,0,0 },
  { 0,0,0,0,60,34,114,34,60,32,32,32,32,32,0,0 },
  { 0,0,0,0,124,66,66,66,124,72,68,68,66,66,80,32 },
  { 0,0,0,0,0,0,57,70,4,60,84,100,76,180,0,0 },
  { 0,0,0,0,16,16,17,126,20,24,16,48,80,140,0,0 },
  { 0,0,0,0,68,68,68,68,124,68,68,68,68,70,2,2 },
  { 0,0,0,64,64,64,88,100,68,68,68,68,68,70,2,2 },
  { 0,0,0,0,66,68,72,80,96,96,80,72,68,67,1,1 },
  { 0,0,0,64,64,64,68,72,80,96,80,72,68,67,1,1 },
  { 0,0,0,0,126,2,2,4,8,16,32,64,64,126,2,2 },
  { 0,0,0,0,0,0,126,2,4,8,16,32,64,126,2,2 },
  { 0,0,0,0,26,38,66,66,66,66,66,66,38,26,0,0 },
  { 0,0,0,0,66,66,102,102,90,90,66,66,66,66,10,4 },
  { 0,0,0,0,66,66,66,66,126,66,66,36,36,24,0,0 },
  { 0,0,0,0,76,82,98,66,66,66,66,66,98,92,0,0 },
  { 0,0,0,0,0,0,130,133,133,72,72,72,48,48,0,0 },
  { 0,0,0,0,132,138,138,136,168,168,216,216,136,136,0,0 },
  { 0,0,0,0,0,0,66,85,85,84,84,84,84,40,0,0 },
  { 0,0,0,0,32,80,82,98,194,36,36,36,24,24,0,0 },
  { 0,0,0,0,112,32,32,32,60,32,32,32,32,112,0,0 },
  { 0,0,0,0,0,0,112,32,32,60,32,32,32,112,0,0 },
  { 0,0,0,0,0,38,73,73,73,73,73,73,73,62,0,0 },
  { 0,0,0,0,0,0,112,136,136,248,128,138,138,116,0,0 },
  { 0,0,0,24,36,36,4,4,4,4,4,4,76,54,0,0 },
  { 0,0,0,0,0,0,124,130,130,130,146,170,170,124,0,0 },
  { 0,0,0,0,0,0,62,2,2,2,30,2,2,62,0,0 },
  { 0,0,0,0,0,0,0,0,4,0,12,4,4,4,20,8 },
  { 0,68,68,40,40,16,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,60,66,64,64,48,12,2,2,66,60,9,6 },
  { 0,0,0,0,126,2,4,4,8,16,32,32,64,96,16,14 },
  { 0,0,0,0,192,32,16,16,56,72,68,68,74,49,0,0 },
  { 0,0,0,0,0,0,192,32,16,56,68,68,74,49,0,0 },
  { 0,0,0,0,120,68,68,72,120,68,68,66,66,124,0,0 },
  { 0,0,0,0,0,0,112,72,80,112,72,68,68,120,0,0 },
  { 0,0,0,0,126,64,64,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,0,0,0,124,64,64,64,64,64,64,64,0,0 },
  { 0,0,0,0,16,8,12,12,20,18,18,18,161,255,0,0 },
  { 0,0,0,0,0,0,32,16,24,24,20,20,162,254,0,0 },
  { 0,0,0,0,60,102,66,128,254,128,128,66,102,60,0,0 },
  { 0,0,0,0,0,0,60,66,128,254,128,128,66,60,0,0 },
  { 0,0,0,0,126,64,64,64,60,2,4,4,8,8,0,0 },
  { 0,0,0,0,0,0,126,64,64,64,60,2,4,8,0,0 },
  { 0,0,0,128,254,2,2,4,8,16,32,64,64,254,2,0 },
  { 0,0,0,0,0,128,254,2,4,8,16,32,64,254,2,0 },
  { 0,0,0,0,66,66,66,66,126,66,66,66,66,66,0,0 },
  { 0,0,0,0,0,0,66,66,66,126,66,66,66,66,0,0 },
  { 0,0,0,0,24,36,36,164,255,37,36,36,36,24,0,0 },
  { 0,0,0,0,0,0,24,36,164,255,37,36,36,24,0,0 },
  { 0,0,0,0,48,16,16,16,16,16,16,16,16,8,0,0 },
  { 0,0,0,0,0,0,48,16,16,16,16,16,16,8,0,0 },
  { 0,0,0,0,76,68,72,80,112,72,68,66,66,66,0,0 },
  { 0,0,0,0,0,0,76,68,72,80,112,72,68,66,0,0 },
  { 0,0,0,0,96,16,24,8,8,12,20,36,66,131,0,0 },
  { 0,0,0,0,0,0,192,32,16,16,24,40,68,134,0,0 },
  { 0,0,0,0,130,130,198,170,146,130,130,130,130,130,0,0 },
  { 0,0,0,0,0,0,68,108,84,68,68,68,68,68,0,0 },
  { 0,0,0,0,130,130,194,162,146,146,138,134,130,130,0,0 },
  { 0,0,0,0,0,0,68,100,100,84,84,76,76,68,0,0 },
  { 0,0,0,128,255,2,12,48,248,4,2,2,12,127,1,0 },
  { 0,0,0,0,0,128,252,4,24,96,240,8,24,126,2,0 },
  { 0,0,0,0,56,108,68,130,130,130,130,68,108,56,0,0 },
  { 0,0,0,0,0,0,56,108,68,130,130,68,108,56,0,0 },
  { 0,0,0,0,255,66,66,66,66,66,66,66,66,66,0,0 },
  { 0,0,0,0,0,0,126,36,36,36,36,36,36,36,0,0 },
  { 0,0,0,0,124,66,66,66,124,64,64,64,64,64,64,64 },
  { 0,0,0,0,0,0,124,66,66,66,124,64,64,64,64,64 },
  { 0,0,0,0,28,54,34,64,64,64,64,34,54,28,0,0 },
  { 0,0,0,0,0,0,28,54,34,64,64,34,54,28,0,0 },
  { 0,0,0,0,254,16,16,16,16,16,16,16,16,16,0,0 },
  { 0,0,0,0,0,0,254,16,16,16,16,16,16,16,0,0 },
  { 0,0,0,0,131,130,68,40,16,16,16,16,16,16,0,0 },
  { 0,0,0,0,0,0,131,68,40,16,16,16,16,16,0,0 },
  { 0,0,16,16,56,124,84,146,146,146,146,84,124,56,16,16 },
  { 0,0,0,0,16,16,56,124,84,146,146,84,124,56,16,16 },
  { 0,0,0,0,67,66,36,24,24,24,36,36,66,66,0,0 },
  { 0,0,0,0,0,0,67,36,24,24,36,36,66,66,0,0 },
  { 0,0,16,16,147,146,84,56,16,16,16,16,16,16,0,0 },
  { 0,0,0,0,16,16,147,84,56,16,16,16,16,16,0,0 },
  { 0,0,0,0,68,146,146,146,146,146,146,146,146,108,0,0 },
  { 0,0,0,0,0,0,68,146,146,146,146,146,146,108,0,0 },
  { 0,0,0,0,0,16,16,16,254,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,16,16,124,0,0,0,0,0 },
  { 0,0,0,0,4,8,16,32,70,32,16,8,4,0,0,0 },
  { 0,0,0,0,0,0,0,8,16,32,68,32,16,8,0,0 },
  { 0,0,0,0,2,254,0,0,2,254,0,0,2,254,0,0 },
  { 0,0,0,0,0,0,2,126,0,2,126,0,2,126,0,0 },
  { 0,0,0,64,64,32,16,8,4,8,16,32,124,0,0,0 },
  { 0,0,0,0,0,0,32,32,16,8,4,8,16,60,0,0 },
  { 0,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,2,126,0,0,0,0,0 },
  { 0,0,0,0,146,146,146,146,255,146,146,146,146,219,0,0 },
  { 0,0,0,0,0,0,146,146,146,255,146,146,146,219,0,0 },
  { 0,0,0,0,146,146,146,146,146,146,146,146,146,219,0,0 },
  { 0,0,0,0,0,0,146,146,146,146,146,146,146,219,0,0 },
  { 0,0,0,0,60,34,34,34,60,32,254,160,32,32,32,32 },
  { 0,0,0,0,0,0,60,34,34,34,60,32,254,160,32,32 },
  { 84,16,124,16,68,146,146,146,146,146,146,146,146,108,0,0 },
  { 0,0,84,16,124,16,68,146,146,146,146,146,146,108,0,0 },
  { 0,0,0,128,255,2,12,48,248,4,2,2,12,120,0,0 },
  { 0,0,0,0,0,128,252,4,24,96,240,8,24,112,0,0 },
  { 0,0,0,0,4,4,4,8,8,8,8,16,16,16,32,32 },
  { 0,0,0,0,0,0,4,4,8,8,8,16,16,16,32,32 },
  { 0,0,0,0,60,98,98,2,31,4,8,240,129,126,0,0 },
  { 0,0,0,0,0,0,60,98,2,31,8,240,129,126,0,0 },
  { 0,0,0,0,60,66,74,50,2,4,8,16,32,64,0,0 },
  { 0,0,0,0,0,0,60,66,74,50,4,8,16,32,0,0 },
  { 0,0,0,0,120,196,194,2,4,124,2,2,2,2,130,124 },
  { 0,0,0,0,0,0,120,196,194,2,60,4,2,2,130,124 },
  { 0,0,0,0,0,0,0,0,1,240,1,8,1,8,2,8,2,16,2,0,2,0,4,0,4,0,4,0,8,0,8,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,224,1,16,2,16,2,16,2,32,4,0,4,0,4,0,8,0,8,0 },
  { 0,0,0,0,64,64,64,64,64,64,64,64,66,126,0,0 },
  { 0,0,0,0,0,0,64,64,64,64,64,64,68,124,0,0 },
  { 0,0,0,0,2,4,8,16,32,64,76,82,66,60,0,0 },
  { 0,0,0,0,0,0,4,8,16,32,76,82,66,60,0,0 },
  { 0,12,16,32,24,8,8,8,8,8,8,8,8,24,0,0 },
  { 0,0,0,12,16,32,24,8,8,8,8,8,8,24,0,0 },
  { 0,0,0,0,32,32,32,32,32,32,32,32,34,126,160,64 },
  { 0,0,0,0,0,0,16,16,16,16,16,16,18,62,80,32 },
  { 0,0,0,0,66,66,66,66,66,66,66,66,66,255,0,0 },
  { 0,0,0,0,0,0,36,36,36,36,36,36,36,126,0,0 },
  { 0,0,0,0,16,8,12,12,84,50,26,22,163,255,0,0 },
  { 0,0,0,0,0,0,16,8,12,44,26,14,83,127,0,0 },
  { 0,60,64,64,56,108,68,130,130,130,130,68,108,56,0,0 },
  { 0,0,0,60,64,64,56,108,68,130,130,68,108,56,0,0 },
  { 0,0,0,0,126,34,32,32,32,32,32,32,34,62,0,0 },
  { 0,0,0,0,0,0,126,34,32,32,32,32,36,60,0,0 },
  { 0,0,0,0,16,38,73,81,98,36,88,64,128,128,0,0 },
  { 0,0,0,0,0,0,16,38,73,114,36,88,128,128,0,0 },
  { 0,0,0,0,252,32,60,34,34,34,60,32,32,32,32,32 },
  { 0,0,0,0,0,0,252,32,60,34,34,34,60,32,32,32 },
  { 0,0,0,0,0,0,76,68,72,80,112,72,68,66,2,28 },
  { 0,0,30,17,17,30,16,146,214,186,146,146,146,146,16,16 },
  { 0,30,17,17,30,16,254,84,84,84,84,84,84,84,16,16 },
  { 1,16,1,16,1,224,1,0,127,254,1,0,57,28,109,54,69,34,129,64,129,64,69,34,109,54,57,28,1,0,1,0 },
  { 0,30,17,17,30,16,126,16,16,16,16,16,16,16,16,16 },
  { 30,17,17,30,16,16,86,84,84,56,56,56,84,84,16,16 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,63,252,108,54,68,34,130,64,130,64,68,34,108,54,56,28,0,0,0,0 },
  { 0,0,0,0,48,192,73,32,73,32,73,32,73,32,48,192,0,0,0,32,0,112,255,240,255,240,224,0,64,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,49,128,74,64,74,64,49,128,0,0,0,64,0,224,255,224,224,0,64,0,0,0 },
  { 0,0,0,0,112,56,240,120,112,56,56,56,52,88,50,152,49,24,50,152,52,88,56,60,60,30,56,28,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,24,96,56,96,28,96,10,160,9,32,10,160,12,112,14,56,12,48,0,0,0,0 },
  { 0,0,0,0,6,0,7,254,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,96,112,62,112,96,0,0,0,0,0,0,0,0,0,0 },
  { 0,6,14,124,14,6,0,0,0,0,0,0,0,0,0,0 },
  { 0,8,16,32,60,130,66,66,66,66,66,66,66,60,0,0 },
  { 0,0,0,8,16,32,60,130,66,66,66,66,66,60,0,0 },
  { 0,0,127,254,97,198,125,190,97,190,111,190,97,198,127,254,127,254,97,182,111,182,99,134,111,246,111,246,127,254,0,0 },
  { 0,0,127,254,97,198,125,190,97,190,111,190,97,198,127,254,127,254,97,134,111,190,99,134,111,246,111,134,127,254,0,0 },
  { 0,0,127,254,97,198,125,190,97,190,111,190,97,198,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,97,198,125,190,97,190,111,190,97,198,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,97,198,125,190,97,190,111,190,97,198,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,0,0,216,216,72,36,36,36,36,18,18,18,0,0 },
  { 0,0,0,0,24,24,16,32,32,32,32,64,76,76,0,0 },
  { 0,0,0,0,48,48,16,8,8,8,8,4,100,100,0,0 },
  { 0,0,0,0,54,54,36,72,72,72,72,144,144,144,0,0 },
  { 0,0,0,0,0,0,0,4,8,16,16,8,4,56,0,0 },
  { 0,0,0,0,32,16,8,4,98,4,8,16,32,0,0,0 },
  { 0,48,8,4,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,126,34,32,32,32,62,2,0 },
  { 0,0,0,0,0,0,0,0,196,68,68,124,4,2,66,60 },
  { 0,0,0,0,0,0,0,0,252,68,68,68,68,66,2,60 },
  { 0,0,0,0,0,64,124,20,16,56,68,68,68,56,0,0 },
  { 0,0,0,0,0,0,0,0,252,68,68,68,68,70,2,2 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,240,17,16,17,16,17,16,17,16,17,16,1,0,0,128 },
  { 0,0,0,64,112,16,16,16,28,18,18,18,18,28,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,248,8,136,8,136,8,136,8,136,15,136,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,126,50,34,2,2,2,0,0 },
  { 0,0,0,0,32,32,32,56,36,36,36,36,28,4,4,4 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,248,8,136,8,136,8,136,8,136,8,248,0,0,0,0 },
  { 0,0,0,32,60,4,4,4,30,36,36,36,36,24,0,0 },
  { 0,0,0,0,124,68,64,64,124,68,68,68,68,68,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,16,17,16,17,16,17,16,17,16,31,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,178,210,18,18,18,31,0,0 },
  { 0,0,0,0,0,0,0,0,178,210,18,18,18,31,2,2 },
  { 0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,17,240,17,16,17,16,17,16,17,16,31,16,0,0,0,0 },
  { 0,0,0,0,64,64,64,64,72,72,72,72,72,124,4,0 },
  { 0,0,0,0,0,0,0,0,252,68,68,124,64,64,64,60 },
  { 0,0,0,0,0,0,0,0,0,8,0,8,0,8,0,8,24,136,8,136,8,136,8,136,8,136,15,248,0,8,0,8 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,248,8,136,8,136,8,136,8,136,15,248,0,128,0,128 },
  { 0,0,0,0,16,16,16,22,186,208,16,16,16,16,0,0 },
  { 0,0,0,0,0,0,0,0,252,68,68,68,68,70,0,0 },
  { 0,0,0,0,0,0,0,0,98,34,34,34,62,2,2,2 },
  { 0,0,0,0,0,0,0,98,34,34,34,62,2,2,66,60 },
  { 0,0,0,0,32,32,32,60,36,36,36,32,32,32,32,32 },
  { 0,0,0,0,0,0,0,0,252,68,68,68,68,68,64,56 },
  { 0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,0,31,240,17,16,17,16,17,16,17,16,31,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,248,8,136,8,136,8,136,8,136,8,152,8,0,8,0 },
  { 0,0,0,0,0,0,0,0,124,36,32,56,4,36,36,24 },
  { 0,0,0,0,0,0,0,0,102,34,34,34,34,62,32,32 },
  { 0,0,0,0,0,0,0,192,254,34,20,12,18,33,64,128 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,16,17,16,17,16,17,16,17,16,17,248,0,0,0,0 },
  { 0,0,0,0,64,64,64,120,76,64,64,64,64,64,0,0 },
  { 0,0,0,0,0,0,0,0,64,120,4,4,4,120,0,0 },
  { 0,0,0,0,4,4,4,4,100,36,36,60,4,4,4,4 },
  { 0,0,0,0,0,0,0,0,0,0,98,34,34,62,8,8 },
  { 0,0,0,0,0,0,0,0,0,240,1,16,1,0,1,0,31,240,17,16,17,16,17,16,17,16,31,16,0,0,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,206,125,190,97,142,111,182,97,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,24,36,4,8,48,64,68,56 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,206,125,182,97,206,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,206,125,182,97,198,111,246,97,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,134,125,182,97,134,111,182,97,182,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,142,125,182,97,142,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,198,125,190,97,190,111,190,97,198,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,60,4,8,16,32,60,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,134,125,190,97,142,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,134,125,190,97,142,111,190,97,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,24,36,36,24,0,0 },
  { 0,0,0,0,0,0,0,56,68,130,254,130,68,56,0,0 },
  { 0,0,0,0,0,0,0,56,84,146,254,146,84,56,0,0 },
  { 0,0,0,0,0,0,254,68,40,16,16,40,68,130,0,0 },
  { 0,0,0,0,0,0,130,68,40,16,16,40,68,254,0,0 },
  { 0,0,0,0,0,0,254,68,40,16,16,40,68,254,0,0 },
  { 0,0,0,0,0,0,214,214,16,16,16,16,16,16,0,0 },
  { 0,0,0,0,0,0,16,40,40,40,40,68,68,68,0,0 },
  { 0,0,0,0,0,0,68,68,68,40,40,40,40,16,0,0 },
  { 0,0,0,0,0,126,64,64,64,120,64,64,64,126,0,0 },
  { 0,0,0,0,0,126,2,2,2,126,2,2,2,126,0,0 },
  { 0,0,0,24,36,36,24,0,126,0,24,36,36,24,0,0 },
  { 0,0,0,0,0,0,238,40,40,40,56,40,40,40,238,0 },
  { 0,0,0,0,0,0,254,132,136,144,144,168,196,130,0,0 },
  { 0,0,0,0,0,96,96,0,0,12,12,0,0,96,96,0 },
  { 0,0,0,0,0,0,130,196,168,144,144,136,132,254,0,0 },
  { 0,0,0,0,0,0,0,56,84,146,146,146,84,56,0,0 },
  { 0,0,0,0,0,0,0,58,68,138,146,162,68,184,0,0 },
  { 0,0,24,24,0,0,24,24,0,0,24,24,0,0,24,24 },
  { 0,0,0,0,0,0,1,2,4,8,24,36,66,129,0,0 },
  { 0,0,0,0,0,0,16,16,16,124,68,68,68,68,0,0 },
  { 0,0,0,0,0,0,146,84,56,16,16,40,68,130,0,0 },
  { 0,0,0,0,0,0,0,0,102,102,0,0,102,102,0,0 },
  { 0,0,0,0,0,0,254,132,136,144,144,160,192,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,152,25,152,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,8,16,32,16,8,16,32,16,8,0,0 },
  { 0,0,0,0,0,124,16,16,16,16,16,16,16,124,0,0 },
  { 0,0,0,0,0,0,0,198,40,16,16,16,40,198,0,0 },
  { 0,0,0,0,0,0,40,40,40,254,40,254,40,40,40,0 },
  { 0,0,0,0,0,0,36,36,36,44,52,36,36,36,36,0 },
  { 0,0,0,0,0,126,64,64,64,64,64,64,64,126,0,0 },
  { 0,0,0,0,0,0,16,16,16,16,16,16,16,16,16,0 },
  { 0,0,0,0,0,0,16,16,16,254,16,254,16,16,16,0 },
  { 0,0,0,0,16,16,16,16,16,16,16,16,16,0,16,16 },
  { 0,0,0,0,0,0,0,60,4,8,24,36,36,24,0,0 },
  { 0,0,0,0,24,36,36,24,0,0,24,36,36,24,0,0 },
  { 0,0,0,0,0,0,0,56,68,130,130,130,68,56,0,0 },
  { 0,0,0,0,0,0,0,56,68,130,146,138,68,58,0,0 },
  { 0,0,0,0,0,0,68,68,68,68,124,16,16,16,0,0 },
  { 0,0,0,0,24,24,0,0,24,24,0,0,24,24,0,0 },
  { 0,0,0,0,0,195,195,0,0,24,24,0,0,195,195,0 },
  { 0,0,0,0,0,0,0,56,68,186,186,186,68,56,0,0 },
  { 0,0,0,0,0,0,0,58,68,138,146,130,68,56,0,0 },
  { 0,0,0,0,0,30,41,70,64,64,64,70,41,30,0,0 },
  { 0,0,0,0,0,0,16,16,16,16,124,16,16,16,16,0 },
  { 0,0,0,0,0,0,130,68,40,16,16,40,68,130,0,0 },
  { 0,0,0,0,0,30,41,70,80,120,80,70,41,30,0,0 },
  { 0,0,0,0,0,126,64,72,72,124,72,72,64,126,0,0 },
  { 0,0,0,0,0,0,16,40,40,40,40,68,68,124,0,0 },
  { 0,0,0,0,0,0,68,68,68,68,68,68,68,124,0,0 },
  { 0,0,0,0,0,0,0,8,16,32,16,8,16,32,0,0 },
  { 0,0,0,146,146,84,56,16,16,16,56,84,146,146,0,0 },
  { 0,0,0,0,0,0,48,40,36,32,32,32,32,32,0,0 },
  { 0,0,0,146,146,84,56,16,254,16,56,84,146,146,0,0 },
  { 0,0,0,0,0,4,8,16,32,64,32,16,8,4,0,0 },
  { 0,0,0,0,0,0,0,0,0,238,0,0,0,0,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,206,111,182,99,206,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,206,111,182,99,198,109,246,115,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,134,111,182,99,134,109,182,115,182,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,142,111,182,99,142,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,198,111,190,99,190,109,190,115,198,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,142,111,182,99,182,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,134,111,190,99,142,109,190,115,134,127,254,0,0 },
  { 0,36,36,36,60,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,2,2,2,2,4,4,8,16,96,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,238,125,206,123,238,119,238,119,198,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,134,125,246,123,134,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,142,125,246,123,198,119,246,119,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,182,125,182,123,134,119,246,119,246,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,134,125,190,123,134,119,246,119,134,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,206,125,190,123,142,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,134,125,246,123,238,119,222,119,222,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,206,125,182,123,206,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,206,125,182,123,198,119,246,119,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,134,125,182,123,134,119,182,119,182,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,142,125,182,123,142,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,198,125,190,123,190,119,190,119,198,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,142,125,182,123,182,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,134,125,190,123,142,119,190,119,134,127,254,0,0 },
  { 170,170,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,0,0,1,128,0,42,169,128,0,85,85 },
  { 0,0,0,0,6,0,6,0,6,0,15,0,15,128,25,192,216,192,248,252,216,214,24,220,24,192,24,192,0,0,0,0 },
  { 0,0,0,0,7,252,15,252,24,166,16,166,17,70,31,124,14,60,2,0,2,0,54,0,60,0,52,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,248,3,228,6,60,108,0,124,0,108,0,12,0,12,0,12,0,4,48,3,240,0,48,0,0 },
  { 0,0,0,0,6,0,6,0,6,0,15,0,15,128,25,192,216,192,248,0,216,0,24,0,24,0,24,0,0,0,0,0 },
  { 0,0,0,0,96,96,127,224,6,0,15,0,15,128,25,192,216,192,248,0,216,0,24,0,24,0,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,15,0,15,128,25,192,216,192,248,0,216,0,24,0,24,0,24,0,0,0,0,0 },
  { 0,0,0,0,3,128,6,192,12,96,12,96,12,96,12,96,14,192,7,128,63,240,51,48,3,0,63,0,48,0,0,0 },
  { 0,0,24,48,31,240,6,192,12,96,12,96,12,96,12,96,14,192,7,128,63,240,51,48,3,0,63,0,48,0,0,0 },
  { 0,0,0,0,7,248,15,204,24,120,24,0,28,0,12,0,7,192,0,192,0,192,12,192,15,192,12,0,0,0,0,0 },
  { 24,24,31,248,1,128,7,248,15,204,24,120,24,0,12,0,7,192,0,192,0,192,12,192,15,192,12,0,0,0,0,0 },
  { 0,0,0,0,3,0,3,0,3,0,3,192,0,192,1,192,49,224,63,112,55,48,6,48,6,48,6,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,1,128,49,128,177,128,255,128,177,128,49,128,48,0,48,0,48,0,48,0,0,0,0,0 },
  { 0,0,0,0,1,192,3,224,54,32,62,32,54,64,7,248,1,152,3,0,3,0,6,0,14,0,0,0,0,0,0,0 },
  { 1,128,1,128,1,192,3,224,54,32,62,32,54,64,7,248,1,152,3,0,3,0,6,0,14,0,0,0,0,0,0,0 },
  { 12,48,15,240,1,128,1,192,51,224,62,32,54,64,7,248,1,152,3,0,3,0,6,0,14,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,240,3,88,3,88,54,76,62,76,54,76,6,76,6,0,6,0,6,0,6,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,252,3,204,6,204,12,170,12,238,108,0,127,0,110,128,12,64,6,192,3,128,0,0,0,0 },
  { 0,0,0,0,1,192,3,224,2,48,3,48,1,240,0,96,0,192,7,240,6,24,126,24,99,0,3,0,0,0,0,0 },
  { 0,0,0,0,12,48,15,240,31,248,25,152,1,128,1,128,49,128,63,128,51,0,6,0,12,0,8,0,0,0,0,0 },
  { 1,192,99,192,126,0,12,0,28,0,51,0,99,128,97,192,96,192,0,252,0,212,0,220,0,192,0,192,7,248,14,28 },
  { 0,0,0,0,192,192,255,192,12,0,30,0,62,0,115,0,99,96,3,224,3,124,3,12,3,0,3,0,0,0,0,0 },
  { 0,0,0,0,96,96,127,224,6,0,15,0,31,0,57,128,49,128,1,128,1,128,1,240,1,144,15,240,12,0,0,0 },
  { 1,192,99,192,126,0,12,0,28,0,51,0,99,128,97,216,96,216,0,254,0,198,0,192,0,192,0,192,7,248,14,28 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,134,109,246,113,238,125,222,115,222,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,206,109,182,113,206,125,182,115,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,206,109,182,113,198,125,246,115,206,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,134,109,182,113,134,125,182,115,182,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,142,109,182,113,142,125,182,115,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,198,109,190,113,190,125,190,115,198,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,142,109,182,113,182,125,182,115,142,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,134,109,190,113,142,125,190,115,134,127,254,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,115,134,109,190,113,142,125,190,115,190,127,254,0,0 },
  { 0,0,0,0,31,248,25,152,1,128,3,192,3,224,6,112,54,48,62,48,54,48,6,48,6,48,6,48,0,0,0,0 },
  { 0,0,0,0,63,240,51,48,3,0,7,128,7,192,12,224,108,108,124,124,108,108,12,96,12,96,12,96,0,0,0,0 },
  { 0,0,0,0,63,240,51,48,3,0,7,128,7,192,12,224,108,96,124,96,108,96,12,96,12,108,12,124,0,12,0,0 },
  { 0,0,0,0,31,248,25,152,1,128,3,192,3,224,6,112,54,48,62,48,54,48,0,48,0,48,0,48,0,0,0,0 },
  { 0,0,0,0,63,240,51,48,3,0,7,128,7,192,12,224,108,96,124,96,108,96,12,124,12,100,12,124,0,0,0,0 },
  { 0,0,0,0,127,224,102,96,3,0,7,128,7,192,12,224,108,96,124,96,108,96,12,96,12,96,12,96,0,0,0,0 },
  { 0,0,0,0,15,252,12,204,0,192,1,224,3,224,7,48,54,48,62,48,54,48,6,0,6,0,6,0,0,0,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,134,109,246,97,238,109,222,109,222,127,254,0,0 },
  { 0,0,24,24,31,248,25,152,1,128,1,128,31,248,25,152,1,128,1,128,31,128,25,128,1,128,0,0,0,0,0,0 },
  { 0,0,24,24,31,248,25,152,1,128,1,128,31,248,25,152,1,128,1,152,31,248,25,152,1,128,0,0,0,0,0,0 },
  { 0,0,24,24,31,248,25,152,1,128,1,128,31,248,25,152,1,128,1,128,31,128,25,152,1,248,0,24,0,0,0,0 },
  { 0,0,24,24,31,248,25,152,1,128,1,128,31,248,25,152,1,128,1,128,31,128,25,128,3,128,7,0,24,0,24,0 },
  { 0,0,24,24,31,248,25,152,1,128,1,128,31,248,25,152,1,128,1,128,31,240,25,144,1,240,0,0,0,0,0,0 },
  { 0,0,48,48,63,240,51,48,1,128,1,128,31,248,25,152,1,128,1,128,31,128,25,128,1,128,0,0,0,0,0,0 },
  { 48,24,48,24,59,160,6,192,12,96,12,96,12,96,12,96,14,192,127,248,99,24,3,0,63,0,51,0,3,0,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,97,134,109,190,97,142,109,190,109,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,124,62,102,102,6,96,127,224,102,96,6,96,6,96,6,96,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,124,62,102,102,6,96,127,254,102,102,6,96,6,96,6,96,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,124,62,102,102,6,96,127,224,102,96,6,96,6,102,6,126,0,6,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,124,62,102,102,6,96,127,224,102,96,6,96,0,96,0,96,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,124,62,102,102,6,96,127,224,102,96,6,124,6,100,6,124,0,0,0,0,0,0 },
  { 97,128,127,128,12,0,12,0,124,62,102,102,6,96,127,224,102,96,6,96,6,96,6,96,6,96,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,124,62,102,102,6,96,127,224,102,96,6,96,6,0,6,0,0,0,0,0,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,99,134,109,246,99,238,109,222,99,222,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,3,224,7,240,12,152,24,140,248,140,200,140,28,206,26,173,26,173,30,239,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,224,7,240,12,152,24,143,248,139,200,136,28,204,26,170,26,170,30,238,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,224,7,240,12,152,24,140,248,140,200,140,28,204,26,172,26,172,30,239,0,3,0,0 },
  { 0,0,0,0,0,0,0,0,3,224,7,240,12,152,28,204,250,172,218,172,30,236,0,24,0,28,0,50,0,62,0,0 },
  { 0,0,0,0,0,0,0,0,3,240,7,248,12,155,24,142,248,139,200,136,28,204,26,170,26,170,30,238,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,240,7,248,12,216,28,204,250,234,218,106,30,110,0,80,0,80,0,112,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,240,7,248,12,152,24,204,248,170,200,170,28,238,26,0,26,0,30,0,0,0,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,99,134,109,190,99,142,109,190,99,190,127,254,0,0 },
  { 0,0,12,48,14,112,1,128,1,128,3,240,13,152,25,152,25,176,15,192,1,128,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,12,48,14,112,1,128,1,128,3,240,13,152,25,152,25,176,15,192,1,152,1,248,1,152,1,128,0,0,0,0 },
  { 0,0,12,48,14,112,1,128,1,128,3,240,13,152,25,152,25,176,15,192,1,128,1,128,1,152,1,248,0,24,0,0 },
  { 0,0,24,96,28,224,3,0,3,0,7,224,27,48,51,48,51,96,31,128,3,0,6,0,12,0,56,0,56,0,56,0 },
  { 0,0,12,48,14,112,1,128,1,128,3,240,13,152,25,152,25,176,15,192,1,128,1,240,1,144,1,240,0,0,0,0 },
  { 0,0,48,192,57,192,6,0,1,128,3,240,13,152,25,152,25,176,15,192,1,128,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,12,48,14,112,1,128,2,64,2,64,1,128,3,240,13,152,25,152,25,176,15,192,1,128,1,128,0,0,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,113,134,111,246,111,238,111,222,113,222,127,254,0,0 },
  { 0,0,0,0,0,0,13,152,13,216,15,240,14,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,0,0,0,0 },
  { 0,0,0,0,0,0,27,48,27,176,31,224,28,192,12,192,12,248,12,216,12,192,12,192,12,192,12,192,0,0,0,0 },
  { 0,0,0,0,0,0,27,48,27,176,31,224,28,192,12,192,12,192,12,192,12,192,12,192,12,192,12,248,0,24,0,0 },
  { 0,0,0,0,0,0,13,152,13,216,15,240,14,96,6,96,6,96,0,96,0,96,0,96,0,96,0,96,0,0,0,0 },
  { 0,0,0,0,0,0,27,48,27,176,31,224,28,192,12,192,12,192,12,192,12,192,12,248,12,200,12,248,0,0,0,0 },
  { 0,0,0,0,0,0,25,152,25,216,31,240,24,96,6,96,6,96,6,96,6,96,6,96,6,96,6,96,0,0,0,0 },
  { 0,0,0,0,0,0,13,152,13,216,15,240,14,96,6,96,6,96,6,96,6,0,6,0,6,0,6,0,0,0,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,113,134,111,190,111,142,111,190,113,190,127,254,0,0 },
  { 48,192,57,192,198,48,255,240,198,48,1,192,3,224,6,112,6,48,6,48,6,48,6,48,6,48,6,48,0,0,0,0 },
  { 48,192,57,192,198,48,255,240,198,48,1,192,3,224,6,112,6,54,6,62,6,54,6,48,6,48,6,48,0,0,0,0 },
  { 48,192,57,192,198,48,255,240,198,48,1,192,3,224,6,112,54,48,62,48,54,48,6,48,6,54,6,62,0,6,0,0 },
  { 48,192,57,192,198,48,255,240,198,48,1,192,3,224,6,112,6,48,6,48,0,48,0,48,0,48,0,48,0,0,0,0 },
  { 48,192,57,192,198,48,255,240,198,48,1,192,3,224,6,112,6,48,6,48,6,48,6,62,6,50,6,62,0,0,0,0 },
  { 48,192,57,192,198,48,255,240,198,48,3,192,15,224,24,112,6,48,6,48,6,48,6,48,6,48,6,48,0,0,0,0 },
  { 48,192,57,192,198,48,255,240,198,48,1,192,3,224,6,112,6,48,6,48,6,0,6,0,6,0,6,0,0,0,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,99,134,109,246,109,238,109,222,99,222,127,254,0,0 },
  { 0,0,0,0,24,96,28,224,15,192,7,128,63,128,48,192,0,192,0,192,0,192,0,192,0,192,0,192,0,0,0,0 },
  { 0,0,0,0,48,192,57,192,31,128,15,0,127,0,97,128,1,240,1,176,1,128,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,0,0,48,192,57,192,31,128,15,0,127,0,97,128,1,128,1,128,1,128,1,128,1,128,1,240,0,48,0,0 },
  { 0,0,0,0,48,192,57,192,31,128,15,0,127,0,97,128,1,128,1,128,1,128,3,128,7,0,124,0,96,0,0,0 },
  { 0,0,0,0,48,192,57,192,31,128,15,0,127,0,97,128,1,128,1,128,1,128,1,240,1,144,1,240,0,0,0,0 },
  { 0,0,0,0,48,192,57,192,31,128,15,0,63,0,37,128,61,128,1,128,1,128,1,128,1,128,1,128,0,0,0,0 },
  { 48,192,57,192,31,128,6,0,6,0,15,0,127,0,97,128,1,128,1,128,1,128,1,128,1,128,1,128,0,0,0,0 },
  { 0,0,127,254,97,142,125,182,97,182,111,182,97,142,127,254,127,254,99,134,109,190,109,142,109,190,99,190,127,254,0,0 },
  { 4,24,32,56,36,24,0,0,0,0,0,0,0,0,0,0 },
  { 56,36,56,36,56,0,0,0,0,0,0,0,0,0,0,0 },
  { 56,32,32,32,32,0,0,0,0,0,0,0,0,0,0,0 },
  { 28,20,20,36,62,66,0,0,0,0,0,0,0,0,0,0 },
  { 84,84,56,84,84,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,36,8,36,24,0,0,0,0,0,0,0,0,0,0,0 },
  { 36,40,48,40,36,0,0,0,0,0,0,0,0,0,0,0 },
  { 30,18,18,82,34,0,0,0,0,0,0,0,0,0,0,0 },
  { 68,108,84,68,68,0,0,0,0,0,0,0,0,0,0,0 },
  { 36,36,60,36,36,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,36,36,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 60,36,36,36,36,0,0,0,0,0,0,0,0,0,0,0 },
  { 56,36,56,32,32,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,32,32,24,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 124,16,16,16,16,0,0,0,0,0,0,0,0,0,0,0 },
  { 68,40,16,40,68,0,0,0,0,0,0,0,0,0,0,0 },
  { 36,36,36,36,62,2,0,0,0,0,0,0,0,0,0,0 },
  { 36,36,28,4,4,0,0,0,0,0,0,0,0,0,0,0 },
  { 84,84,84,84,124,0,0,0,0,0,0,0,0,0,0,0 },
  { 84,84,84,84,126,2,0,0,0,0,0,0,0,0,0,0 },
  { 24,36,60,36,24,0,0,0,0,0,0,0,0,0,0,0 },
  { 63,68,68,52,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,4,28,36,28,0,0,0,0,0,0,0,0,0,0,0 },
  { 24,36,60,32,28,0,0,0,0,0,0,0,0,0,0,0 },
  { 8,28,8,28,34,34,0,0,0,0,0,0,0,0,0,0 },
  { 4,40,16,40,40,16,0,0,0,0,0,0,0,0,0,0 },
  { 124,84,16,28,18,28,0,0,0,0,0,0,0,0,0,0 },
  { 76,82,114,82,76,0,0,0,0,0,0,0,0,0,0,0 },
  { 76,66,126,82,78,0,0,0,0,0,0,0,0,0,0,0 },
  { 16,40,56,84,84,0,0,0,0,0,0,0,0,0,0,0 },
  { 124,68,40,56,84,84,0,0,0,0,0,0,0,0,0,0 },
  { 124,68,40,248,84,84,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,60,32,32,32,32,32,0,0,0,0,0,0,0 },
  { 0,0,0,60,32,36,32,32,32,0,0,0,0,0,0,0 },
  { 0,0,0,4,8,16,32,32,32,32,0,0,0,0,0,0 },
  { 0,0,0,32,16,8,4,4,4,4,0,0,0,0,0,0 },
  { 0,0,0,4,8,16,32,36,32,32,0,0,0,0,0,0 },
  { 0,0,0,32,16,8,4,36,4,4,0,0,0,0,0,0 },
  { 0,0,0,124,16,16,16,16,16,0,0,0,0,0,0,0 },
  { 0,0,0,124,16,20,16,16,16,0,0,0,0,0,0,0 },
  { 0,0,0,56,68,64,36,16,136,72,48,0,0,0,0,0 },
  { 0,0,0,56,68,64,32,16,136,72,48,0,0,0,0,0 },
  { 0,0,0,112,136,8,16,32,68,72,48,0,0,0,0,0 },
  { 0,0,0,124,68,68,68,124,0,0,0,0,0,0,0,0 },
  { 0,0,0,64,32,16,8,4,0,0,0,0,0,0,0,0 },
  { 0,0,0,4,8,16,32,64,0,0,0,0,0,0,0,0 },
  { 0,0,0,128,1,0,3,128,0,0,15,224,1,0,2,128,127,252,2,128,1,0,15,224,0,0,3,128,1,0,2,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254,16,0,32,0,64,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,0,8,0,4,0,2 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,64,32,64 },
  { 0,0,0,0,0,0,0,8,0,16,0,32,4,64,0,128,1,0,2,0,4,64,8,0,16,0,32,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,8,0,16,0,32,0,64,0,128,1,0,34,0,36,0,40,0,16,0,14,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,224,0,16,0,40,0,72,0,136,1,0,2,0,4,0,8,0,16,0,32,0,0,0,0,0 },
  { 0,0,0,0,0,8,32,16,8,4,8,16,32,8,0,0 },
  { 0,0,0,0,0,0,0,0,6,24,96,6,24,96,0,0 },
  { 0,0,0,0,16,16,0,16,16,48,80,82,82,60,0,0 },
  { 0,0,0,0,0,0,10,43,172,175,176,126,224,220,0,0 },
  { 0,0,0,0,0,36,0,0,0,126,0,0,0,0,0,0 },
  { 0,0,24,36,36,24,0,49,73,70,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,64,32,16,8,4 },
  { 0,0,0,0,0,0,0,0,0,0,0,4,8,16,32,64 },
  { 0,0,0,24,24,0,0,49,73,70,0,0,0,0,0,0 },
  { 0,0,0,49,73,70,0,0,12,12,0,0,0,0,0,0 },
  { 0,0,0,48,48,48,48,48,60,48,48,48,48,48,0,0 },
  { 0,0,0,12,12,12,12,12,60,12,12,12,12,12,0,0 },
  { 0,0,0,60,48,48,48,48,48,0,0,0,0,0,0,0 },
  { 0,0,0,60,12,12,12,12,12,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,48,48,48,48,48,60,0,0 },
  { 0,0,0,0,0,0,0,0,12,12,12,12,12,60,0,0 },
  { 0,0,0,0,0,0,0,62,64,64,64,62,0,0,0,0 },
  { 0,0,0,0,0,0,0,124,2,2,2,124,0,0,0,0 },
  { 0,0,0,18,36,36,72,72,72,72,72,72,36,36,18,0 },
  { 0,0,0,144,72,72,36,36,36,36,36,36,72,72,144,0 },
  { 0,0,0,0,0,0,0,0,102,102,0,0,24,24,0,0 },
  { 0,0,0,0,0,0,0,0,24,24,0,0,102,102,0,0 },
  { 0,0,0,0,0,0,0,0,102,102,0,0,102,102,0,0 },
  { 0,0,0,0,0,0,24,24,0,219,219,0,24,24,0,0 },
  { 0,0,0,0,60,66,66,64,32,16,16,0,16,16,0,0 },
  { 8,16,16,8,8,16,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,24,36,36,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,24,60,60,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,8,16,24,24,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,24,24,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,24,8,8,16,0,0 },
  { 0,0,0,0,0,0,0,8,16,24,0,24,0,0,0,0 },
  { 0,0,8,24,8,40,120,40,8,24,8,8,8,8,0,0 },
  { 0,0,8,12,8,10,15,10,8,12,8,8,8,8,0,0 },
  { 0,0,8,8,8,8,28,8,42,127,42,8,28,8,0,0 },
  { 0,0,0,0,60,66,64,60,66,66,60,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,20,8,20,0,0 },
  { 0,0,0,8,0,8,0,8,0,8,0,8,0,8,0,0 },
  { 0,12,16,8,4,8,16,8,4,8,16,8,4,24,0,0 },
  { 0,10,127,138,138,255,138,127,10,10,10,10,10,10,0,0 },
  { 0,0,0,0,0,0,0,0,0,60,0,60,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,24,16,16,8 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,102,68,68,34 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,109,142,109,246,97,198,125,246,125,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,109,182,109,182,97,134,125,246,125,246,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,109,134,109,190,97,134,125,246,125,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,109,206,109,190,97,142,125,182,125,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,109,134,109,246,97,238,125,222,125,222,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,109,206,109,182,97,206,125,182,125,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,109,206,109,182,97,198,125,246,125,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,109,134,109,182,97,134,125,182,125,182,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,109,142,109,182,97,142,125,182,125,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,109,198,109,190,97,190,125,190,125,198,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,109,142,109,182,97,182,125,182,125,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,109,134,109,190,97,142,125,190,125,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,109,134,109,190,97,142,125,190,125,190,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,206,111,182,97,182,125,182,97,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,238,111,206,97,238,125,238,97,198,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,111,246,97,134,125,190,97,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,142,111,246,97,198,125,246,97,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,182,111,182,97,134,125,246,97,246,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,111,190,97,134,125,246,97,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,206,111,190,97,142,125,182,97,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,111,246,97,238,125,222,97,222,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,206,111,182,97,206,125,182,97,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,206,111,182,97,198,125,246,97,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,111,182,97,134,125,182,97,182,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,142,111,182,97,142,125,182,97,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,198,111,190,97,190,125,190,97,198,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,142,111,182,97,182,125,182,97,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,111,190,97,142,125,190,97,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,111,190,97,142,125,190,97,190,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,206,111,182,99,182,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,238,111,206,99,238,109,238,115,198,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,134,111,246,99,134,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,142,111,246,99,198,109,246,115,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,182,111,182,99,134,109,246,115,246,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,134,111,190,99,134,109,246,115,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,206,111,190,99,142,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,134,111,246,99,238,109,222,115,222,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,206,111,182,99,206,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,206,111,182,99,198,109,246,115,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,134,111,182,99,134,109,182,115,182,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,142,111,182,99,142,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,198,111,190,99,190,109,190,115,198,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,142,111,182,99,182,109,182,115,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,134,111,190,99,142,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,134,111,190,99,142,109,190,115,190,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,206,125,182,123,182,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,238,125,206,123,238,119,238,119,198,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,125,246,123,134,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,142,125,246,123,198,119,246,119,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,182,125,182,123,134,119,246,119,246,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,125,190,123,134,119,246,119,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,206,125,190,123,142,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,125,246,123,238,119,222,119,222,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,206,125,182,123,206,119,182,119,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,206,125,182,123,198,119,246,119,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,125,182,123,134,119,182,119,182,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,142,125,182,123,142,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,198,125,190,123,190,119,190,119,198,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,142,125,182,123,182,119,182,119,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,125,190,123,142,119,190,119,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,125,190,123,142,119,190,119,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,14,0,1,128,0,96,0,16,28,0,3,0,0,192,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,0,124,31,128,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,32,0,32,0,32,0,64,0,128,0 },
  { 0,0,0,0,0,0,0,0,0,0,63,248,0,8,0,8,0,16,0,16,0,32,0,32,0,0,0,0,0,0,0,0 },
  { 0,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,16,16,16,16,16,15,240 },
  { 0,0,0,0,255,224,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,16,0,18,0,10,0,6,0,2 },
  { 0,64,0,64,0,128,1,0,1,0,3,0,5,0,9,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0 },
  { 0,0,15,240,8,16,8,16,8,16,8,16,8,16,8,16,8,16,8,16,8,16,16,16,16,16,16,16,32,80,64,32 },
  { 0,0,31,240,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,32,8,32,10,32,10,64,6,128,2 },
  { 4,0,4,0,7,240,8,32,8,64,16,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,4,0,4,0,4,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,68,0,4,0,4,0,20,0,8 },
  { 4,0,4,0,4,0,4,0,4,0,4,0,4,0,7,240,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,240,32,16,32,16,32,16,32,80,32,32,32,4,32,4,31,252 },
  { 1,0,17,16,9,32,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 2,8,33,8,16,144,8,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,255,254,4,64,4,64,4,64,4,64,4,64,8,64,8,64,16,66,16,66,32,66,64,62,128,0 },
  { 2,32,2,16,4,8,8,4,16,2,100,34,4,32,4,32,4,32,4,32,4,32,4,32,8,34,8,34,16,34,96,30 },
  { 1,0,1,0,1,0,1,0,1,0,255,254,2,64,2,64,2,64,4,64,4,64,8,64,8,66,16,66,32,66,192,62 },
  { 2,32,2,16,4,8,8,4,16,2,103,226,4,32,4,32,4,32,4,32,4,32,4,32,8,34,8,34,16,34,96,30 },
  { 0,0,0,0,63,240,32,16,32,16,32,16,32,16,63,240,32,0,32,0,32,0,32,4,32,4,32,4,31,252,0,0 },
  { 0,0,1,0,1,0,2,16,4,16,8,32,16,64,31,128,1,0,2,0,4,32,8,16,16,8,63,252,0,4,0,4 },
  { 0,0,4,0,4,0,4,0,7,240,4,32,8,32,8,32,8,32,8,64,31,192,0,64,0,64,0,64,127,252,0,0 },
  { 0,0,0,0,0,0,0,0,63,248,0,8,0,8,63,248,0,8,0,8,0,8,63,248,0,8,0,0,0,0,0,0 },
  { 8,0,8,0,8,0,8,0,12,0,74,0,74,0,136,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,32,2,144,18,72,18,36,34,20,34,16,66,0,10,0,4,0 },
  { 1,0,1,0,1,0,31,192,1,0,1,0,1,0,1,192,7,0,25,0,1,0,1,0,1,0,1,0,5,0,2,0 },
  { 8,0,8,0,8,0,15,252,24,16,36,16,68,32,130,32,1,64,0,128,1,128,2,64,4,32,8,16,16,8,224,6 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,115,134,109,182,113,134,125,182,115,182,127,254,0,0 },
  { 63,240,2,0,2,0,66,0,66,0,127,252,4,128,4,128,4,128,8,128,8,128,16,132,32,132,64,124,128,0,0,0 },
  { 63,248,32,8,47,232,32,8,47,232,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,31,240,16,16,16,16,16,16,31,240,16,16,16,16,16,16,31,240,16,16,16,16,16,16,16,16,16,80,16,32 },
  { 0,128,0,128,0,254,8,128,8,128,15,248,16,8,20,16,34,16,65,32,1,64,0,128,1,0,2,0,12,0,112,0 },
  { 0,0,31,240,16,16,18,16,17,16,17,16,255,254,32,16,34,16,33,16,33,16,63,252,0,16,0,16,0,160,0,64 },
  { 0,0,0,16,63,248,32,8,32,8,32,8,63,248,32,0,32,136,63,252,32,128,32,64,32,32,32,16,56,14,48,4 },
  { 32,0,16,0,16,0,128,0,64,0,72,0,8,0,16,0,16,0,224,0,32,0,32,0,32,0,32,0,0,0,0,0 },
  { 1,0,1,0,1,0,33,8,17,16,9,32,1,0,1,64,5,32,9,16,17,8,225,4,65,4,1,0,5,0,2,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,136,34,68,66,68,128,4,0,0,0,0 },
  { 0,16,0,124,7,128,248,8,33,8,24,144,8,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,124,31,144,17,16,17,16,33,8,33,4,64,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 2,0,2,0,2,0,34,0,18,0,10,0,2,0,2,0,6,0,10,0,18,0,98,0,34,0,2,0,2,0,2,0 },
  { 1,0,17,0,31,248,33,0,1,0,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 68,0,40,0,16,0,40,0,72,0,136,0,8,0,24,0,40,0,72,0,136,0,8,0,8,0,80,0,32,0,0,0 },
  { 254,0,16,0,16,0,16,0,16,0,16,0,254,0,16,0,16,0,16,0,16,0,22,0,56,0,192,0,0,0,0,0 },
  { 0,0,0,0,252,0,8,0,16,0,16,0,16,0,92,0,80,0,80,0,80,0,80,0,92,0,240,0,64,0,0,0 },
  { 63,248,36,72,36,72,36,72,63,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,126,0,0,0,0,0,254,0,16,0,16,0,84,0,82,0,82,0,144,0,16,0,16,0,16,0,80,0,32,0 },
  { 32,0,16,0,16,0,248,0,8,0,16,0,16,0,56,0,84,0,148,0,16,0,16,0,16,0,16,0,16,0,16,0 },
  { 0,0,16,64,16,64,16,64,62,254,40,144,73,16,138,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 8,0,8,0,16,0,18,0,34,0,124,0,8,0,16,0,36,0,126,0,2,0,0,0,82,0,73,0,137,0,0,0 },
  { 16,0,16,0,32,0,36,0,68,0,248,0,16,0,32,0,64,0,252,0,64,0,0,0,28,0,224,0,64,0,0,0 },
  { 63,248,32,8,36,72,34,136,33,8,34,136,36,72,32,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 63,248,36,72,36,72,36,72,63,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,63,252,32,4,64,8,4,64,8,32,16,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,68,68,132,72,4,64,4,64,4,64,4,64,4,64,4,64,8,64,8,66,16,66,16,66,32,66,64,62 },
  { 0,0,0,0,0,0,63,252,34,68,34,68,34,68,34,68,34,68,34,68,34,68,34,68,34,68,32,4,0,0,0,0 },
  { 16,16,8,32,63,248,1,0,31,240,1,0,2,0,255,254,4,0,8,0,16,0,224,0,0,0,0,0,0,0,0,0 },
  { 8,32,4,64,127,252,1,0,31,240,1,0,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 4,64,4,64,4,64,124,124,4,64,4,64,0,0,255,254,1,0,1,0,63,248,1,0,1,0,1,0,1,0,1,0 },
  { 2,0,2,8,63,200,2,16,2,32,255,254,0,128,1,0,2,0,12,0,48,0,192,0,0,0,0,0,0,0,0,0 },
  { 1,0,1,0,63,248,1,8,255,254,1,8,63,248,1,8,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0 },
  { 1,0,1,0,31,248,1,8,255,254,1,8,31,248,1,0,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 7,248,4,8,5,8,4,136,4,72,4,104,4,8,4,24,4,40,4,72,5,136,8,136,8,8,16,8,32,40,64,16 },
  { 2,0,12,0,112,124,64,4,64,4,64,4,64,4,64,4,124,252,64,4,64,4,64,4,64,4,64,4,124,252,64,4 },
  { 8,32,8,32,255,254,8,32,8,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 8,32,8,32,254,254,8,32,8,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,8,32,8,32,8,32,8,32,8,32,8,32,248,62,8,32,8,32,8,32,8,32,8,32,8,32,8,32,0,0 },
  { 1,0,1,248,1,0,63,252,33,4,33,96,47,136,33,8,32,248,32,0,35,224,34,32,34,32,68,36,72,36,144,28 },
  { 32,0,16,0,0,0,252,0,8,0,16,0,16,0,52,0,88,0,148,0,20,0,16,0,16,0,16,0,16,0,16,0 },
  { 127,252,4,64,4,64,63,248,36,72,36,72,63,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,255,254,4,128,4,128,4,128,127,252,68,132,68,132,68,132,68,132,72,148,72,244,80,4,64,4,127,252 },
  { 31,240,16,16,16,16,17,16,17,16,17,16,17,16,17,16,18,144,18,144,4,128,4,128,8,130,48,130,192,126,0,0 },
  { 8,0,8,0,31,224,32,32,64,64,191,248,33,8,33,8,63,248,33,8,33,8,63,248,33,8,65,8,65,40,128,16 },
  { 4,0,4,0,7,240,8,32,16,64,63,248,81,8,17,136,18,72,21,40,25,136,18,72,20,40,24,8,16,40,16,16 },
  { 32,0,16,0,16,0,0,0,0,0,240,0,16,0,16,0,16,0,16,0,16,0,20,0,24,0,16,0,0,0,0,0 },
  { 31,240,16,16,16,16,16,16,17,16,17,16,17,16,17,16,17,16,18,16,2,128,4,64,8,32,16,16,32,8,0,0 },
  { 0,0,127,0,65,0,65,0,65,0,127,0,73,0,8,0,8,0,79,0,72,0,72,0,72,0,79,0,240,0,64,0 },
  { 2,0,2,0,2,0,127,252,4,0,9,0,17,0,33,0,63,248,1,0,1,0,255,254,1,0,1,0,1,0,1,0 },
  { 32,0,16,0,16,0,0,0,0,0,240,0,16,0,16,0,16,0,16,0,16,0,16,0,40,0,71,254,0,0,0,0 },
  { 32,0,16,0,8,0,64,0,32,0,16,0,0,0,240,0,16,0,16,0,16,0,16,0,16,0,40,0,68,0,131,254 },
  { 0,0,32,0,16,0,0,0,0,0,248,0,8,0,16,0,32,0,120,0,8,0,8,0,16,0,16,0,40,0,199,254 },
  { 0,0,0,60,0,36,0,40,0,40,0,48,0,40,0,36,0,36,0,36,0,52,0,40,0,32,0,32,0,32,0,32 },
  { 16,0,16,0,30,0,32,0,32,0,124,0,144,0,16,0,254,0,16,0,16,0,18,0,20,0,24,0,16,0,0,0 },
  { 15,248,8,0,15,240,8,0,15,240,8,0,255,254,18,0,17,16,16,160,16,64,18,32,20,24,24,6,16,0,0,0 },
  { 15,248,8,0,8,0,15,240,8,0,8,0,15,240,8,0,8,0,255,254,4,0,8,32,16,16,63,248,16,8,0,0 },
  { 8,0,8,16,8,32,8,64,8,128,9,0,8,0,255,254,10,0,9,0,8,128,8,64,9,32,10,24,12,6,8,0 },
  { 32,0,19,252,16,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,4,64,20,64,8 },
  { 2,0,4,0,31,240,16,16,16,16,31,240,16,0,31,248,16,8,16,8,31,248,16,0,31,248,16,8,16,8,31,248 },
  { 248,0,136,0,144,0,144,0,160,0,144,0,144,0,136,0,136,0,136,0,136,0,240,0,128,0,128,0,128,0,128,0 },
  { 127,252,1,0,255,254,145,18,141,98,1,0,29,112,97,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 2,0,2,0,127,248,2,0,63,240,2,0,255,252,0,0,31,224,16,32,31,224,16,32,31,224,16,32,16,32,16,192 },
  { 1,0,1,0,1,4,255,254,1,0,1,16,63,248,1,0,1,4,127,254,1,4,1,4,1,4,1,40,1,16,1,0 },
  { 127,252,2,0,4,0,31,240,16,16,17,16,17,16,17,16,17,16,17,16,18,144,2,64,4,32,24,16,96,8,0,0 },
  { 63,240,32,16,32,16,40,80,36,80,34,144,34,144,33,16,33,16,34,144,34,146,36,74,72,74,64,6,128,2,0,0 },
  { 255,192,0,64,0,68,0,72,0,80,0,96,0,80,0,72,0,68,0,32,0,32,0,18,0,10,0,6,0,2,0,0 },
  { 1,0,2,128,4,64,10,32,49,24,223,246,16,16,31,240,16,16,31,240,16,8,17,144,16,96,18,16,20,8,24,4 },
  { 8,0,8,0,20,0,18,0,41,0,126,0,162,0,62,0,34,0,62,0,32,0,62,0,32,0,32,0,62,0,32,0 },
  { 8,0,8,0,20,0,18,0,41,0,126,0,162,0,62,0,34,0,62,0,32,0,40,0,36,0,42,0,50,0,32,0 },
  { 32,0,32,0,32,0,62,0,68,0,72,0,128,0,16,0,16,0,16,0,16,0,18,0,20,0,24,0,16,0,0,0 },
  { 8,136,8,136,17,16,34,32,17,16,8,136,255,254,2,0,31,240,16,16,31,240,16,16,31,240,16,16,31,240,16,16 },
  { 127,224,0,32,0,32,16,32,16,32,16,32,31,252,0,4,0,4,0,4,255,228,0,4,0,4,0,40,0,16,0,0 },
  { 31,240,16,16,31,144,16,144,16,144,127,254,64,2,159,244,16,16,31,240,16,16,31,240,16,16,16,16,16,80,16,32 },
  { 2,0,4,0,63,248,33,8,33,8,63,248,34,8,34,8,63,248,5,16,9,32,9,72,17,124,33,2,65,2,128,254 },
  { 4,0,4,0,15,224,16,32,32,64,127,248,161,8,33,8,63,248,33,8,33,8,63,248,0,0,0,0,255,254,0,0 },
  { 1,0,2,0,31,240,16,16,18,16,17,16,17,80,16,32,16,0,31,252,0,4,0,4,127,228,0,4,0,40,0,16 },
  { 1,0,1,0,1,254,1,0,1,0,63,248,32,8,40,40,36,72,34,136,33,8,34,136,36,72,40,40,63,248,32,8 },
  { 1,0,1,0,127,252,1,0,1,0,63,248,1,0,1,0,255,254,8,0,31,240,40,32,68,64,3,128,28,112,224,14 },
  { 4,64,63,248,4,64,4,64,255,254,1,0,31,240,17,16,17,16,31,240,17,16,17,16,31,240,4,64,8,32,16,16 },
  { 31,240,16,16,16,16,31,240,1,0,63,248,33,8,33,8,63,248,33,8,33,8,63,248,33,10,1,2,1,2,0,254 },
  { 2,0,1,0,127,252,8,32,4,64,3,128,28,112,240,30,16,16,31,240,16,16,16,16,31,240,16,16,32,16,64,16 },
  { 2,0,1,0,127,252,8,32,4,64,3,128,12,96,48,24,200,38,8,32,8,32,8,32,8,32,16,32,16,32,32,32 },
  { 1,0,1,0,17,248,17,0,17,0,255,254,0,0,41,40,37,72,35,136,63,248,35,136,37,72,41,40,33,8,63,248 },
  { 1,0,1,0,17,248,17,0,17,0,17,0,255,254,0,0,33,8,33,8,34,136,36,72,40,40,32,8,63,248,0,8 },
  { 2,0,1,0,127,252,16,16,8,32,255,254,1,0,31,240,17,16,31,240,17,16,17,16,31,240,17,18,1,2,0,254 },
  { 4,32,4,16,4,16,4,0,255,254,4,128,4,136,4,136,4,144,8,160,8,192,16,130,17,130,34,130,68,126,128,0 },
  { 4,0,63,248,32,8,62,248,2,128,122,128,10,252,254,148,10,212,122,164,2,164,122,212,10,148,254,252,10,130,121,254 },
  { 4,0,15,192,16,128,63,240,209,16,31,240,17,16,31,240,1,0,63,248,33,8,63,248,33,8,63,248,1,2,0,254 },
  { 4,0,4,0,15,224,16,32,32,64,127,248,161,8,33,8,63,248,33,8,33,8,63,248,33,8,1,2,1,2,0,254 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,182,111,182,99,134,111,246,111,246,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,111,190,99,134,111,246,111,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,206,111,190,99,142,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,111,246,99,238,111,222,111,222,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,206,111,182,99,206,111,182,111,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,206,111,182,99,198,111,246,111,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,111,182,99,134,111,182,111,182,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,142,111,182,99,142,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,134,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,4,127,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,0,1,128,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0 },
  { 0,0,0,0,4,0,2,0,1,0,0,128,0,64,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,4,0,4,0,8,0,16,0,32,0,0,0 },
  { 0,64,63,224,0,64,0,128,1,0,2,0,4,0,8,0,16,0,32,4,32,4,32,6,31,252,0,0,0,0,0,0 },
  { 0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,3,192,0,64,0,0,0,0 },
  { 0,16,31,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,127,254,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,0,128,0,132,127,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,2,128,4,64,8,32,16,16,32,14,64,4,0,0 },
  { 8,64,12,96,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,16,64,16,68,32,68,64,70,128,60,0,0 },
  { 30,0,1,0,1,0,1,0,1,0,2,128,2,128,4,64,4,64,8,32,16,16,32,12,64,6,128,2,0,0,0,0 },
  { 0,192,0,64,0,64,6,64,4,64,4,64,4,32,8,32,8,32,8,16,16,16,16,8,32,4,64,6,128,2,0,0 },
  { 32,4,63,254,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,36,32,28,32,8,0,0 },
  { 0,0,0,0,0,0,32,2,63,254,32,4,64,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 4,0,3,0,1,0,0,0,0,64,0,128,0,128,1,0,1,0,6,0,2,0,2,0,2,0,2,0,0,0,0,0 },
  { 0,32,15,240,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,34,16,34,32,34,64,30,0,0 },
  { 32,4,48,6,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,63,252,32,4,0,0,0,0 },
  { 0,4,63,254,1,4,1,4,1,4,1,4,1,4,1,4,2,4,2,4,4,4,4,4,8,68,16,56,96,16,0,0 },
  { 1,0,1,0,1,0,1,8,63,252,1,8,1,8,1,8,1,8,2,8,2,8,4,8,8,136,16,112,96,32,0,0 },
  { 16,0,16,0,16,4,31,254,16,4,32,4,64,4,0,4,0,4,0,4,0,4,0,4,0,68,0,56,0,16,0,0 },
  { 8,0,12,0,8,0,8,16,8,32,8,64,9,128,10,0,12,0,56,0,200,0,8,4,8,4,8,6,7,252,0,0 },
  { 32,8,63,252,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,8,63,252,32,0,0,0,0,0 },
  { 127,252,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,8,63,252,0,0,0,0,0,0 },
  { 1,0,1,0,1,0,1,0,1,0,1,4,127,254,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0 },
  { 2,0,2,0,2,0,2,0,2,0,3,128,2,64,2,48,2,24,2,8,2,0,2,0,2,0,2,0,2,0,0,0 },
  { 4,32,7,240,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,224,4,64,4,0,4,0,4,0,4,0,0,0 },
  { 32,4,63,254,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,64,0,64,0,128,0,0,0 },
  { 1,128,1,0,1,0,2,0,2,0,4,0,4,0,8,32,8,16,16,8,17,252,254,4,64,4,0,0,0,0,0,0 },
  { 0,16,63,248,8,16,8,16,4,32,4,32,2,64,2,64,1,128,1,128,2,64,4,32,24,30,96,4,0,0,0,0 },
  { 16,8,31,252,16,8,16,8,16,8,16,8,16,8,16,8,16,8,16,8,16,8,31,248,16,8,0,0,0,0,0,0 },
  { 32,4,63,254,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,32,4,63,252,32,4,0,0,0,0 },
  { 1,0,1,128,1,0,1,0,1,0,1,8,63,252,1,0,1,0,1,0,1,0,1,0,1,0,1,4,127,254,0,0 },
  { 1,0,1,128,1,0,1,0,1,0,1,4,127,254,1,0,1,0,1,0,1,0,1,0,1,0,1,8,63,252,0,0 },
  { 4,0,4,16,7,248,12,16,18,32,33,64,1,128,14,112,112,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 2,0,2,0,18,16,11,248,4,16,4,16,10,32,10,32,17,64,33,64,64,128,1,64,6,32,24,24,224,6,0,0 },
  { 2,0,2,0,2,8,3,252,4,8,4,8,12,16,18,16,33,32,65,32,0,64,0,128,1,0,6,0,56,0,0,0 },
  { 1,0,1,128,1,0,1,0,1,4,127,254,1,0,1,0,1,0,2,128,4,64,8,32,16,16,32,14,64,4,0,0 },
  { 2,0,3,0,2,0,2,0,2,4,127,254,4,32,4,32,8,32,8,32,16,64,14,128,1,128,6,112,120,14,0,0 },
  { 0,8,63,252,0,16,0,32,0,192,0,128,0,132,127,254,0,128,0,128,0,128,0,128,4,128,3,128,1,0,0,0 },
  { 0,0,1,0,0,128,32,132,63,254,32,4,64,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,32,0,32,0,32,0,36,127,254,0,32,0,32,8,32,4,32,4,32,4,32,0,32,1,32,0,224,0,64,0,0 },
  { 0,128,0,128,0,128,0,128,0,128,12,144,8,136,16,132,16,134,32,130,64,130,0,128,4,128,3,128,1,0,0,0 },
  { 2,0,2,0,2,0,2,8,255,252,2,0,2,0,2,128,2,128,4,128,4,132,8,132,16,132,32,134,192,124,0,0 },
  { 16,8,31,252,16,8,16,8,16,8,31,248,16,8,16,0,16,0,16,0,16,0,32,0,32,0,64,0,128,0,0,0 },
  { 1,0,1,0,1,0,33,4,33,4,33,4,33,4,33,4,63,252,33,4,1,0,1,0,2,0,12,0,112,0,0,0 },
  { 1,0,1,0,1,0,1,0,65,4,65,4,65,4,65,4,65,4,65,4,65,4,65,4,65,4,127,252,64,4,0,0 },
  { 4,68,4,68,8,136,8,136,17,16,17,16,34,32,68,64,34,32,17,16,8,136,8,136,4,68,4,68,4,68,0,0 },
  { 0,8,63,252,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,4,127,254,0,0,0,0,0,0 },
  { 0,16,127,248,0,16,0,16,0,16,0,16,63,240,32,16,32,0,32,0,32,0,32,4,32,4,32,6,31,252,0,0 },
  { 0,128,0,128,0,128,16,132,31,254,16,132,16,132,16,132,16,132,16,132,16,132,16,188,16,136,0,128,0,128,0,0 },
  { 0,8,63,252,1,0,1,0,1,0,1,0,1,4,127,254,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0 },
  { 3,0,2,0,4,0,4,48,8,32,16,64,127,128,33,0,2,0,4,32,8,16,19,232,124,12,32,4,0,0,0,0 },
  { 1,0,0,128,0,132,31,254,16,0,16,0,16,0,16,0,16,0,16,0,16,0,32,0,32,0,64,0,128,0,0,0 },
  { 8,0,124,0,8,0,8,0,16,0,36,0,62,0,4,0,132,0,68,0,40,0,16,0,40,0,196,6,131,252,0,0 },
  { 4,16,4,16,4,16,4,16,4,16,4,16,127,254,4,16,4,16,4,16,4,16,8,16,8,16,16,16,32,16,0,0 },
  { 1,32,1,24,1,8,1,0,1,30,1,224,127,0,48,128,0,128,0,128,0,64,0,66,0,34,0,18,0,14,0,0 },
  { 0,16,63,248,0,16,0,16,0,16,31,240,16,0,16,8,63,252,0,8,0,8,0,8,1,8,0,240,0,32,0,0 },
  { 0,8,63,252,0,8,0,8,0,8,0,8,0,8,31,248,0,8,0,8,0,8,0,8,0,8,63,248,0,8,0,0 },
  { 0,192,0,128,1,0,2,0,4,0,0,192,0,128,1,0,2,0,4,96,0,64,0,128,1,0,2,0,4,0,0,0 },
  { 0,192,0,128,1,0,2,0,4,192,8,128,1,0,3,0,5,0,9,0,17,0,1,0,1,0,1,0,1,0,0,0 },
  { 1,0,0,128,0,192,0,64,4,0,4,0,36,8,36,4,36,6,36,2,68,0,132,16,4,16,4,24,3,240,0,0 },
  { 2,0,2,64,2,32,2,0,2,28,2,224,127,0,2,24,2,16,2,32,1,64,1,130,2,68,12,36,112,30,0,0 },
  { 0,16,16,56,31,192,16,8,31,252,16,8,16,8,16,8,31,248,16,8,16,0,32,0,32,0,64,0,128,0,0,0 },
  { 0,16,0,120,127,128,1,0,1,16,63,248,1,0,1,4,127,254,1,0,1,0,1,0,9,0,7,0,2,0,0,0 },
  { 0,128,0,128,0,132,127,254,0,128,0,144,31,248,4,16,4,16,2,32,1,64,0,128,1,64,6,48,56,14,0,0 },
  { 1,0,1,0,1,4,1,254,1,0,1,16,63,248,8,16,4,32,4,32,2,64,1,128,1,128,14,112,112,14,0,0 },
  { 1,0,0,128,0,132,127,254,8,32,8,32,8,32,4,64,4,64,2,64,2,128,1,128,6,96,24,24,96,6,0,0 },
  { 0,32,8,32,4,32,2,32,2,32,8,32,4,32,2,32,2,36,0,62,3,224,124,32,32,32,0,32,0,32,0,0 },
  { 0,32,16,112,31,128,16,0,16,0,16,4,31,254,16,64,16,64,16,64,16,64,32,64,32,64,64,64,128,64,0,0 },
  { 1,0,0,128,0,132,127,254,2,0,2,0,2,8,3,252,2,8,2,8,2,8,4,8,8,136,16,112,96,32,0,0 },
  { 0,8,31,252,1,0,1,0,1,0,1,4,127,254,2,64,2,64,2,64,2,64,4,66,8,66,16,66,96,62,0,0 },
  { 16,16,31,248,16,16,16,16,16,16,16,16,16,16,31,240,16,16,16,16,16,16,16,16,16,16,31,240,16,16,0,0 },
  { 32,8,63,252,32,8,32,8,32,8,32,8,63,248,32,8,32,8,32,8,32,8,63,248,32,8,0,0,0,0,0,0 },
  { 8,16,15,248,8,16,8,16,8,16,15,240,8,16,8,16,8,16,15,240,8,16,8,16,16,144,32,112,64,32,0,0 },
  { 0,128,0,128,0,128,0,132,127,254,0,128,2,128,2,160,4,160,4,144,8,144,8,136,16,134,96,132,0,128,0,0 },
  { 8,0,8,0,8,4,15,254,16,8,33,16,65,0,1,0,1,0,1,0,1,128,2,64,4,32,24,24,96,6,0,0 },
  { 0,128,0,128,0,128,0,128,0,128,8,136,8,252,8,128,8,128,8,128,8,128,8,128,8,128,8,132,127,254,0,0 },
  { 0,4,127,254,2,0,2,0,2,16,3,248,4,16,12,16,18,32,33,32,65,64,0,128,1,0,6,0,120,0,0,0 },
  { 4,32,7,240,4,32,4,32,4,32,8,32,16,28,32,0,31,248,8,16,4,32,2,64,1,128,14,112,112,12,0,0 },
  { 0,8,31,252,16,136,16,136,16,136,16,136,127,254,17,8,17,8,33,8,34,8,127,254,4,16,9,240,48,32,0,0 },
  { 0,64,16,64,16,64,16,64,16,76,18,72,31,80,16,96,16,64,16,64,16,64,16,68,19,68,60,70,16,60,0,0 },
  { 0,16,0,56,63,192,1,0,1,0,1,28,63,224,1,0,1,14,1,240,127,0,1,2,1,2,1,2,0,254,0,0 },
  { 0,16,16,56,31,192,16,128,16,128,16,136,31,252,16,128,16,128,16,128,16,128,18,66,20,34,120,18,32,14,0,0 },
  { 8,0,8,8,15,252,16,0,47,240,64,0,191,240,0,16,0,16,0,16,0,16,0,18,0,10,0,6,0,2,0,0 },
  { 1,0,1,0,1,0,1,24,1,16,125,32,5,64,5,128,9,64,9,32,17,16,33,12,73,6,135,2,2,0,0,0 },
  { 0,128,0,128,0,128,0,128,8,140,8,136,8,144,16,160,32,192,0,128,1,128,2,64,4,32,24,24,96,6,0,0 },
  { 0,16,16,56,31,224,17,32,17,32,17,32,17,32,17,32,17,16,17,16,17,16,33,8,33,8,65,6,129,2,0,0 },
  { 4,64,4,32,8,16,16,12,32,4,64,32,4,32,4,64,2,64,2,128,1,128,1,128,2,64,12,48,48,14,0,0 },
  { 0,24,24,16,6,32,1,192,2,48,12,12,48,36,4,32,4,64,2,64,2,128,1,128,2,192,12,48,48,14,0,0 },
  { 0,16,4,16,4,16,4,16,4,16,7,240,0,16,0,16,63,240,4,16,4,16,4,16,4,16,8,16,48,16,0,0 },
  { 16,64,16,64,16,64,16,64,16,68,31,254,16,0,16,32,31,240,16,32,16,32,16,32,16,32,32,32,64,32,0,0 },
  { 0,4,127,254,0,64,8,64,8,64,16,68,63,254,1,64,2,64,4,64,8,64,16,64,34,64,65,192,0,128,0,0 },
  { 0,128,0,128,16,128,16,136,31,252,16,128,32,128,64,128,0,132,127,254,0,128,0,128,0,128,0,128,0,128,0,0 },
  { 1,0,1,160,1,16,1,16,1,4,127,254,1,0,1,0,1,0,2,128,4,64,8,32,16,16,32,14,64,4,0,0 },
  { 1,0,0,128,0,132,127,254,1,0,1,0,2,48,5,224,30,64,8,128,1,0,2,16,5,248,30,12,8,4,0,0 },
  { 0,8,63,252,1,0,1,0,1,0,1,16,31,248,1,0,1,32,1,16,1,16,1,0,1,4,127,254,0,0,0,0 },
  { 0,8,16,60,31,224,17,32,17,32,17,32,17,32,17,32,17,16,17,16,17,80,17,72,33,72,67,166,129,34,0,0 },
  { 0,4,127,254,4,0,4,0,4,32,7,240,8,32,10,32,9,32,9,32,16,32,16,34,19,34,124,34,32,30,0,0 },
  { 8,16,8,16,8,20,127,254,8,16,8,16,8,16,8,16,15,240,8,16,8,16,8,16,8,16,15,240,8,16,0,0 },
  { 0,128,16,128,16,128,16,136,31,252,16,128,32,128,64,128,0,144,31,248,0,128,0,128,0,128,0,132,127,254,0,0 },
  { 16,4,31,254,16,132,16,132,16,132,31,252,16,132,16,132,16,132,31,252,16,132,32,132,32,164,64,156,128,136,0,0 },
  { 32,4,63,254,32,132,32,132,32,132,32,132,63,252,32,132,32,132,32,132,32,132,32,132,63,252,32,4,0,0,0,0 },
  { 0,4,127,254,0,132,0,136,0,128,16,128,16,136,16,252,16,128,16,128,24,128,20,128,34,128,193,128,128,254,0,0 },
  { 0,128,8,68,15,254,72,0,40,0,40,0,8,0,24,0,104,0,72,0,8,0,16,0,16,0,32,0,64,0,0,0 },
  { 0,8,127,16,2,162,34,68,20,40,8,16,16,8,32,4,64,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,0,1,0,18,8,31,252,16,8,16,8,16,8,16,8,31,248,16,8,16,8,16,8,16,8,31,248,16,8,0,0 },
  { 0,128,0,128,16,132,31,254,16,132,16,136,16,128,31,248,18,16,18,16,17,32,32,192,32,192,67,48,156,14,0,0 },
  { 16,8,31,252,18,72,18,72,18,72,18,72,18,72,18,72,18,72,18,72,18,72,18,72,127,254,0,0,0,0,0,0 },
  { 16,16,31,248,16,16,16,16,16,16,31,240,16,16,16,16,16,16,31,240,16,16,16,16,16,16,31,240,16,16,0,0 },
  { 0,16,31,248,0,32,3,64,0,128,0,132,127,254,1,136,2,144,4,128,8,128,16,128,36,128,67,128,1,0,0,0 },
  { 8,0,8,0,8,8,15,252,16,128,32,128,0,128,0,132,127,254,0,128,1,64,2,32,4,16,24,14,96,4,0,0 },
  { 0,4,127,254,1,0,1,0,2,0,4,8,15,252,20,8,36,8,68,8,4,8,4,8,7,248,4,8,0,0,0,0 },
  { 0,16,31,248,0,0,0,0,0,0,0,4,127,254,0,128,12,160,8,144,16,136,32,132,68,132,3,128,1,0,0,0 },
  { 1,0,1,0,33,4,63,254,33,4,34,4,34,68,34,36,36,244,63,20,40,20,32,4,32,4,32,60,32,8,0,0 },
  { 0,8,0,60,31,192,0,128,0,128,0,132,127,254,0,128,1,192,2,160,4,144,8,136,16,134,96,130,0,128,0,0 },
  { 1,0,0,128,32,130,63,254,32,4,64,8,4,64,4,64,4,64,4,32,8,32,8,16,16,8,32,12,64,6,0,0 },
  { 2,0,1,0,0,128,0,136,63,252,0,0,8,16,8,16,4,32,4,32,2,64,2,64,0,132,127,254,0,0,0,0 },
  { 16,0,16,96,16,64,18,68,31,126,40,144,73,16,138,16,8,16,8,16,8,16,8,16,8,144,8,112,8,32,0,0 },
  { 0,128,16,140,8,136,12,144,4,160,0,196,127,254,2,128,2,192,4,160,8,144,16,136,32,134,64,130,0,128,0,0 },
  { 1,128,1,0,2,48,4,32,31,192,8,128,1,32,2,16,63,252,16,132,0,128,12,144,8,136,16,134,32,130,0,0 },
  { 8,0,8,0,8,8,15,252,16,128,32,128,0,132,127,254,0,128,16,132,16,132,16,132,16,132,31,252,16,4,0,0 },
  { 32,4,63,254,32,4,33,20,33,20,42,148,36,100,34,36,37,36,41,84,48,148,33,4,32,36,32,28,32,8,0,0 },
  { 8,48,4,32,2,68,127,254,1,0,1,0,1,16,31,248,1,0,1,4,127,254,1,0,1,0,1,0,1,0,0,0 },
  { 2,4,127,254,2,4,34,68,18,36,18,36,2,4,6,12,26,52,98,196,2,4,2,4,18,36,14,28,4,8,0,0 },
  { 1,0,1,0,1,12,63,232,1,16,1,36,127,254,0,128,1,0,6,48,12,192,23,4,100,4,4,6,3,252,0,0 },
  { 0,4,127,254,0,128,0,128,33,4,63,254,34,68,34,68,34,68,34,68,34,68,34,68,34,68,34,92,32,8,0,0 },
  { 1,0,1,4,255,254,1,0,1,16,63,248,1,0,1,4,255,254,5,64,5,32,9,16,17,12,33,6,193,2,0,0 },
  { 0,4,127,254,8,32,8,32,15,224,8,32,8,32,8,32,15,224,8,36,8,62,15,224,120,32,0,32,0,32,0,0 },
  { 1,0,1,8,31,252,1,8,127,254,1,8,31,248,1,8,1,0,63,248,1,4,127,254,1,0,1,0,1,0,0,0 },
  { 1,0,1,0,33,4,63,254,33,4,33,132,34,68,36,52,41,20,33,4,33,132,34,68,36,36,40,28,32,8,0,0 },
  { 32,8,63,252,33,0,33,0,33,8,63,252,32,8,32,8,32,8,63,248,33,8,33,0,33,4,63,254,32,0,0,0 },
  { 1,128,1,0,2,8,31,252,16,8,16,8,31,248,16,8,16,8,16,8,31,248,16,8,16,8,31,248,16,8,0,0 },
  { 0,4,127,254,1,0,2,0,4,32,8,16,127,248,33,4,1,0,1,8,63,252,1,0,1,0,1,4,127,254,0,0 },
  { 2,0,39,4,56,126,32,4,32,4,32,4,32,4,62,124,32,4,32,4,32,4,32,4,32,4,63,252,32,4,0,0 },
  { 0,16,0,120,63,128,0,128,0,132,127,254,0,128,0,128,8,136,15,252,8,8,8,8,8,8,15,248,8,8,0,0 },
  { 16,16,16,16,16,16,18,20,31,126,18,16,34,80,82,80,10,144,10,254,4,16,8,16,16,16,32,16,64,16,0,0 },
  { 1,0,1,0,10,16,15,248,9,16,8,144,8,144,8,20,127,254,9,16,8,144,8,144,8,16,16,240,32,32,0,0 },
  { 16,16,31,248,16,16,16,16,31,240,16,16,16,16,31,240,18,0,17,12,17,48,16,192,22,96,120,24,32,6,0,0 },
  { 4,0,4,32,7,240,8,64,16,136,63,252,81,8,17,8,17,8,31,248,16,8,16,2,16,2,16,2,15,254,0,0 },
  { 8,16,8,16,8,16,42,84,42,84,42,84,42,84,42,84,42,84,62,124,42,84,8,16,16,16,32,16,64,16,0,0 },
  { 1,0,1,252,1,0,1,0,63,254,32,2,33,4,33,16,33,56,33,192,47,0,33,2,33,2,65,2,128,254,0,0 },
  { 0,128,0,128,0,128,16,136,31,252,16,136,16,136,16,136,31,248,16,136,0,128,0,136,0,132,127,254,48,2,0,0 },
  { 0,192,0,128,1,0,18,8,31,252,18,72,18,72,18,72,18,72,18,72,18,72,18,72,18,72,127,254,0,0,0,0 },
  { 24,8,17,252,32,0,64,0,12,4,11,254,16,16,48,16,80,16,144,16,16,16,16,16,16,144,16,112,16,32,0,0 },
  { 1,0,0,128,0,132,127,254,1,128,2,140,4,136,12,80,20,96,36,64,68,32,4,144,5,8,14,6,4,2,0,0 },
  { 0,4,127,254,2,32,2,32,34,36,63,254,34,36,34,36,34,36,34,36,35,228,34,36,32,4,32,4,32,4,0,0 },
  { 0,32,31,240,16,32,16,32,31,224,16,32,16,32,31,224,16,32,16,32,31,224,20,164,8,132,48,134,192,124,0,0 },
  { 4,32,7,240,4,32,8,68,31,254,40,132,72,132,15,252,8,132,8,132,15,252,16,132,16,132,32,156,64,136,0,0 },
  { 2,0,1,4,255,254,0,0,0,0,31,240,0,0,31,240,0,0,16,16,31,248,16,16,16,16,31,240,16,16,0,0 },
  { 4,64,4,32,8,16,16,12,33,132,2,64,4,32,24,24,96,6,15,240,8,16,8,16,8,16,15,240,8,16,0,0 },
  { 0,8,63,252,0,0,8,16,15,248,8,16,8,16,8,16,15,240,8,16,4,96,4,64,2,64,2,132,127,254,0,0 },
  { 0,4,127,254,1,0,2,0,4,12,26,8,99,16,4,160,25,192,98,160,4,144,24,142,96,132,4,128,3,0,0,0 },
  { 0,96,0,192,1,136,6,92,26,32,1,192,3,32,12,96,16,144,3,48,28,80,0,144,3,16,29,32,0,192,0,0 },
  { 8,8,15,252,8,8,8,8,15,248,8,8,8,8,15,248,8,8,8,8,15,248,8,8,3,96,12,24,48,6,0,0 },
  { 0,128,0,128,0,136,31,252,0,128,0,132,127,254,2,64,18,72,18,68,34,68,36,66,68,66,9,192,48,128,0,0 },
  { 1,0,1,0,1,16,31,248,1,0,1,4,127,254,1,0,9,0,9,8,9,252,9,0,21,0,35,0,64,254,0,0 },
  { 8,16,15,248,8,16,8,16,8,16,15,240,8,144,0,128,8,136,8,252,8,128,20,128,18,128,33,134,64,252,0,0 },
  { 0,128,9,16,15,248,8,16,15,240,8,16,8,22,15,244,8,24,127,240,0,80,1,144,6,16,24,240,96,32,0,0 },
  { 1,0,1,4,127,254,1,0,17,8,31,252,17,8,31,248,17,8,31,248,17,8,1,4,127,254,1,0,1,0,0,0 },
  { 1,0,0,136,63,252,8,32,4,32,2,64,2,68,127,254,1,0,1,8,63,252,1,0,1,0,1,0,1,0,0,0 },
  { 16,4,31,254,16,0,16,16,23,248,16,0,16,4,31,254,18,64,18,72,18,80,34,32,34,144,79,8,132,6,0,0 },
  { 0,96,1,128,30,56,0,192,31,24,0,96,31,128,0,128,16,128,16,136,24,252,20,128,34,128,65,128,128,126,0,0 },
  { 31,240,16,16,16,16,31,240,16,16,0,0,63,248,33,8,33,8,63,248,32,8,32,4,32,4,32,6,31,252,0,0 },
  { 0,4,127,254,2,64,18,68,31,254,18,68,18,68,18,68,20,60,24,4,16,4,31,252,16,4,31,252,16,4,0,0 },
  { 0,48,0,248,63,0,1,16,17,16,9,32,9,68,127,254,3,128,5,64,9,32,17,16,33,14,65,4,1,0,0,0 },
  { 16,8,31,252,17,8,17,8,31,248,17,8,17,8,31,248,17,8,1,0,1,8,63,252,1,0,1,4,127,254,0,0 },
  { 0,128,1,128,2,64,4,32,8,16,16,8,111,246,1,0,1,8,63,252,1,0,17,24,9,16,9,36,127,254,0,0 },
  { 8,16,15,248,8,0,15,240,8,0,15,240,8,0,8,4,127,254,8,136,8,80,8,32,9,144,14,14,56,4,0,0 },
  { 126,252,66,132,66,132,126,252,66,132,66,132,126,252,64,4,64,4,64,4,64,4,64,4,64,36,64,28,64,8,0,0 },
  { 1,0,18,16,31,248,16,16,31,240,16,0,31,248,16,8,31,248,16,136,0,132,127,254,0,128,0,128,0,128,0,0 },
  { 1,0,1,16,63,248,1,16,127,254,1,16,63,240,1,16,49,136,9,144,7,96,9,32,113,24,39,6,2,0,0,0 },
  { 4,128,4,64,4,68,15,254,8,64,24,64,40,72,79,252,8,64,8,72,15,252,8,64,8,68,15,254,8,0,0,0 },
  { 0,4,127,254,1,0,33,4,63,254,33,4,41,68,37,36,37,36,33,4,41,68,37,36,37,36,33,28,33,8,0,0 },
  { 1,4,255,254,1,0,63,248,1,4,255,254,0,0,63,248,33,8,33,8,33,8,63,248,32,8,32,120,32,16,0,0 },
  { 2,64,2,64,2,68,126,126,2,64,2,64,2,72,62,124,2,64,2,64,2,68,126,126,2,64,2,64,2,64,0,0 },
  { 0,4,127,254,0,128,33,4,63,254,34,68,34,68,35,196,34,68,34,68,35,196,34,68,34,68,63,252,32,4,0,0 },
  { 8,32,8,36,255,254,8,32,15,224,1,0,63,248,33,8,63,248,33,8,1,0,255,254,1,0,1,0,1,0,0,0 },
  { 2,0,2,32,31,240,4,36,127,254,0,0,15,240,8,16,15,240,0,128,63,252,16,128,63,252,0,128,0,128,0,0 },
  { 2,64,2,64,2,64,2,68,126,126,2,64,2,64,62,124,2,64,2,68,126,126,2,64,2,64,2,68,127,254,0,0 },
  { 3,0,1,8,127,252,16,32,8,32,4,64,255,254,0,0,16,16,31,248,16,16,31,240,16,16,31,240,16,16,0,0 },
  { 0,4,127,254,0,128,17,8,31,252,16,8,31,248,16,8,31,248,16,8,31,248,16,8,3,96,12,24,48,6,0,0 },
  { 32,8,63,252,32,72,33,232,47,8,33,8,47,232,41,40,41,40,47,232,41,40,33,74,33,234,79,38,132,2,0,0 },
  { 63,224,0,36,0,40,13,48,57,44,9,34,9,18,127,238,9,36,9,40,9,48,17,44,17,18,33,10,65,6,0,0 },
  { 0,128,1,128,2,64,5,32,24,152,111,246,8,16,15,240,8,16,15,240,8,8,9,144,10,96,60,24,16,6,0,0 },
  { 8,48,4,32,127,254,0,128,17,16,31,248,16,16,16,16,31,240,16,16,31,240,16,16,16,16,31,240,16,16,0,0 },
  { 0,32,0,112,63,128,1,4,127,254,5,64,9,32,49,24,200,22,15,248,8,16,15,240,8,16,15,240,8,16,0,0 },
  { 16,8,31,252,17,0,17,16,31,248,17,0,31,248,17,0,17,4,31,254,0,36,9,20,36,148,36,132,64,56,0,0 },
  { 8,16,15,248,8,16,9,240,41,18,63,254,32,4,79,244,8,16,15,240,8,16,15,240,8,16,8,112,8,32,0,0 },
  { 1,0,0,132,127,254,0,0,15,240,8,16,15,240,32,4,63,254,32,4,39,228,36,36,39,228,36,60,32,8,0,0 },
  { 34,0,63,12,32,8,32,16,63,38,32,68,63,136,32,16,127,38,16,68,16,8,34,16,255,32,65,64,1,128,0,0 },
  { 128,2,190,250,136,34,190,250,136,34,190,250,128,2,128,2,128,2,128,2,128,2,128,2,128,18,128,14,128,4,0,0 },
  { 2,16,41,36,36,68,50,164,41,148,34,68,36,164,63,252,32,4,16,48,16,192,23,0,24,4,16,4,15,252,0,0 },
  { 0,4,127,254,0,0,15,240,8,16,15,240,0,0,63,252,32,4,36,68,34,132,47,244,33,4,33,28,33,8,0,0 },
  { 1,0,18,8,31,252,17,8,17,8,31,248,17,8,17,8,31,248,16,136,1,144,2,168,4,254,24,130,96,126,0,0 },
  { 4,32,7,240,4,32,8,64,31,248,40,136,72,136,15,248,8,136,8,136,15,248,8,8,36,68,34,34,66,34,0,0 },
  { 1,0,10,16,15,248,8,16,15,240,8,16,15,240,8,8,15,252,8,0,15,252,41,36,36,148,68,148,0,24,0,0 },
  { 1,0,1,4,1,254,1,0,63,252,34,20,41,36,36,68,50,164,41,148,34,68,37,36,40,148,63,252,32,4,0,0 },
  { 1,0,32,132,63,254,34,32,34,36,63,254,34,36,63,252,40,4,40,32,47,164,40,56,41,162,94,34,136,62,0,0 },
  { 0,128,0,132,127,254,8,136,8,136,20,148,35,226,4,144,25,8,99,246,4,32,11,64,48,192,1,32,30,16,0,0 },
  { 1,0,64,132,127,254,68,16,68,16,127,126,68,16,85,84,85,84,85,84,85,84,85,84,100,148,164,150,132,16,0,0 },
  { 4,36,127,254,4,32,7,224,0,4,127,254,1,0,31,248,17,8,31,248,17,8,31,248,16,8,12,48,112,14,0,0 },
  { 0,112,31,128,1,8,127,254,1,0,7,224,25,24,98,134,13,96,113,30,13,100,3,128,5,96,25,24,99,6,0,0 },
  { 16,8,31,252,17,8,25,40,21,72,31,248,17,8,1,0,63,248,1,0,1,0,127,254,36,68,34,34,66,34,0,0 },
  { 18,72,18,72,10,80,10,80,127,254,16,136,32,132,95,254,16,132,17,132,18,196,20,164,24,148,16,156,16,136,0,0 },
  { 63,252,34,68,34,68,62,124,34,68,2,64,62,124,34,68,62,124,34,68,62,124,34,68,2,66,2,66,1,254,0,0 },
  { 7,224,4,32,39,228,36,36,39,228,36,36,39,228,36,36,62,124,2,64,126,126,18,72,18,72,34,72,66,72,0,0 },
  { 8,32,8,32,255,36,8,254,126,32,0,36,127,254,66,68,66,68,126,72,66,40,36,16,30,48,112,78,33,132,0,0 },
  { 6,8,56,252,32,8,62,248,32,8,63,248,32,8,9,64,37,40,33,8,41,72,37,42,33,10,41,70,115,130,0,0 },
  { 1,0,15,240,8,16,15,240,8,16,15,240,8,16,31,248,17,8,31,248,17,8,127,254,4,32,4,32,56,32,0,0 },
  { 2,0,1,4,127,254,2,72,62,176,21,40,21,40,37,52,89,34,8,16,15,240,8,16,15,240,16,16,96,16,0,0 },
  { 0,128,8,144,8,248,8,128,255,254,4,64,68,68,74,164,81,20,127,252,68,68,74,164,81,20,127,252,64,4,0,0 },
  { 16,64,8,68,127,126,34,64,20,124,127,4,0,124,62,64,34,124,62,64,34,124,62,64,34,126,46,66,36,62,0,0 },
  { 8,64,15,224,8,64,16,128,127,252,17,68,127,124,5,68,127,108,5,84,125,108,5,68,127,126,5,2,124,252,0,0 },
  { 1,128,6,96,24,24,99,198,0,0,123,222,74,82,123,222,0,0,63,252,34,68,63,252,34,68,34,92,34,72,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,99,206,109,190,109,142,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,99,134,109,246,109,238,109,222,99,222,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,99,206,109,182,109,206,109,182,99,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,99,206,109,182,109,198,109,246,99,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,99,134,109,182,109,134,109,182,99,182,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,99,142,109,182,109,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,99,198,109,190,109,190,109,190,99,198,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,99,142,109,182,109,182,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,99,134,109,190,109,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,99,134,109,190,109,142,109,190,99,190,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,206,111,182,99,182,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,238,111,206,99,238,111,238,97,198,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,134,111,246,99,134,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,142,111,246,99,198,111,246,97,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,182,111,182,99,134,111,246,97,246,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,134,111,190,99,134,111,246,97,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,206,111,190,99,142,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,134,111,246,99,238,111,222,97,222,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,206,111,182,99,206,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,206,111,182,99,198,111,246,97,206,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,134,111,182,99,134,111,182,97,182,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,142,111,182,99,142,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,198,111,190,99,190,111,190,97,198,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,142,111,182,99,182,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,134,111,190,99,142,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,134,111,190,99,142,111,190,97,190,127,254,0,0 },
  { 237,182,0,0,129,2,129,2,0,0,129,2,129,2,0,0,129,2,129,2,0,0,129,2,129,2,1,0,128,2,182,218 },
  { 237,182,0,0,128,2,128,2,128,2,0,0,128,2,128,2,54,216,128,2,128,2,0,0,128,2,128,2,0,0,237,182 },
  { 237,182,0,0,132,66,132,66,132,66,0,0,132,66,132,66,0,0,132,66,132,66,0,0,132,66,132,66,0,0,237,182 },
  { 237,182,0,0,128,2,128,2,128,2,54,216,128,2,128,2,0,0,128,2,182,218,0,0,128,2,128,2,0,0,237,182 },
  { 170,170,0,0,128,2,21,80,128,2,16,16,128,2,16,16,128,2,16,16,144,18,0,0,149,82,128,2,0,0,170,170 },
  { 219,107,0,0,128,1,155,105,16,8,128,1,144,9,16,8,128,1,144,9,16,8,128,1,144,9,16,8,128,1,219,109 },
  { 219,182,0,0,136,34,136,34,0,0,136,34,136,34,0,0,136,34,128,2,136,34,13,96,128,2,128,2,0,0,219,182 },
  { 219,109,0,1,128,0,128,1,11,109,136,0,128,1,8,1,136,0,128,1,8,1,139,108,128,1,0,1,128,0,182,219 },
  { 219,109,0,1,128,0,128,1,11,109,136,0,128,1,8,1,136,0,128,1,8,1,136,0,128,1,8,1,136,0,182,219 },
  { 182,219,128,0,0,1,128,1,139,108,8,1,128,1,136,0,8,1,128,1,136,0,11,109,128,1,128,0,0,1,219,109 },
  { 219,109,0,1,144,0,144,1,0,1,144,0,144,1,0,1,144,0,144,1,0,1,144,0,155,109,0,1,128,0,182,219 },
  { 0,0,219,96,128,32,0,0,155,108,144,36,0,0,144,36,144,36,0,0,144,36,219,100,0,0,16,4,27,108,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,198,111,190,99,190,111,190,111,198,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,142,111,182,99,182,111,182,111,142,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,134,111,190,99,142,111,190,111,134,127,254,0,0 },
  { 0,0,127,254,97,134,125,190,97,142,111,190,97,190,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,12,0,6,0,2,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,18,0,18,0,12,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,2,64,2,64,2,64,4,128,4,128,9,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,6,0,24,32,32,48,65,40,65,168,129,68,141,4,147,4,73,8,68,8,36,16,24,96,1,128,0,0,0,0 },
  { 0,0,0,0,2,0,1,0,1,0,2,48,3,200,4,16,8,32,18,64,33,128,0,128,0,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,16,0,8,0,16,6,32,9,64,8,128,9,64,18,32,20,16,24,0,48,0,32,0,0,0,0,0 },
  { 0,0,7,128,24,96,32,16,64,8,64,8,128,4,128,4,128,4,128,4,64,8,64,8,32,16,24,96,7,128,0,0 },
  { 0,8,0,8,0,16,0,16,0,32,0,32,0,64,0,64,0,64,0,32,0,32,0,16,0,16,0,8,0,8,0,0 },
  { 32,0,32,0,16,0,16,0,8,0,8,0,4,0,4,0,4,0,8,0,8,0,16,0,16,0,32,0,32,0,0,0 },
  { 0,18,0,18,0,36,0,36,0,72,0,72,0,144,0,144,0,72,0,72,0,36,0,36,0,18,0,18,0,0,0,0 },
  { 72,0,72,0,36,0,36,0,18,0,18,0,9,0,9,0,18,0,18,0,36,0,36,0,72,0,72,0,0,0,0,0 },
  { 0,124,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,62,0,0,0,0,0,0,0 },
  { 0,126,0,66,0,94,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,112,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,7,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,61,0,33,0,63,0,0,0,0,0,0,0 },
  { 0,124,0,120,0,112,0,112,0,112,0,96,0,96,0,96,0,96,0,96,0,96,0,112,0,112,0,120,0,124,0,0 },
  { 31,0,15,0,7,0,7,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,7,0,7,0,15,0,31,0,0,0 },
  { 127,254,0,0,0,0,127,254,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0 },
  { 63,254,63,254,63,254,63,254,63,254,0,0,0,0,0,0,63,254,63,254,63,254,63,254,63,254,0,0,0,0,0,0 },
  { 0,8,0,16,0,32,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,32,0,16,0,8 },
  { 16,0,8,0,4,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,4,0,8,0,16,0 },
  { 7,240,4,32,4,64,4,128,4,128,5,0,5,0,5,0,5,0,5,0,5,0,4,128,4,128,4,64,4,32,7,240 },
  { 31,192,8,64,4,64,2,64,2,64,1,64,1,64,1,64,1,64,1,64,1,64,2,64,2,64,4,64,8,64,31,192 },
  { 16,0,96,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,96,0,16,0 },
  { 128,0,96,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,96,0,128,0 },
  { 240,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,160,0,240,0 },
  { 240,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,80,0,240,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,248,131,4,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,72,0,36,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 18,0,36,0,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,36,0,72,0,216,0,144,0,0,0 },
  { 0,0,63,252,63,252,0,0,63,252,63,252,85,150,217,185,165,165,165,165,89,154,65,130,36,36,19,200,8,16,7,224 },
  { 192,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0 },
  { 0,96,0,64,12,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,8,64,0,64,0,64,0,64,0,0,0,0 },
  { 0,4,16,4,16,132,16,132,16,132,16,132,16,132,16,132,16,132,16,132,16,132,16,4,16,4,0,4,0,0,0,0 },
  { 0,16,0,16,16,32,8,32,4,64,2,64,1,128,0,192,1,32,2,16,4,8,8,8,48,0,0,0,0,0,0,0 },
  { 0,0,4,32,4,48,8,32,28,192,3,0,4,128,8,64,8,32,16,32,16,32,16,32,16,64,8,64,7,128,0,0 },
  { 0,0,1,0,0,128,0,132,127,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,0,4,0,4,0,4,0,255,240,0,0,0,0,0,0,255,240,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 1,0,1,0,1,0,127,254,0,0,0,0,0,0,63,252,0,0,0,0,0,0,0,0,127,254,0,0,0,0,0,0 },
  { 8,0,8,0,8,0,15,252,16,16,40,16,4,32,2,32,1,64,0,128,0,192,1,32,2,16,12,16,48,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,144,0,144,0,96,0 },
  { 0,0,96,0,144,0,144,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,6,0,9,0,9,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,0,9,0,9,0,6 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,192,0,192,0,0,0,192,0,192,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,112,112,136,136,7,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 8,0,12,0,8,0,16,0,16,0,32,0,64,0,128,0,128,0,64,0,32,0,16,0,8,0,8,0,4,0,4,0 },
  { 8,0,12,0,8,128,16,64,18,64,33,0,65,0,128,0,128,0,64,0,32,0,16,0,8,0,8,0,4,0,4,0 },
  { 4,0,6,0,4,0,8,0,8,0,8,0,16,0,16,0,16,0,32,0,32,0,32,0,64,0,64,0,128,0,128,0 },
  { 4,0,6,0,4,64,8,32,8,128,8,64,16,64,16,0,16,0,32,0,32,0,32,0,64,0,64,0,128,0,128,0 },
  { 0,0,128,0,64,0,32,0,32,0,16,0,16,0,8,0,8,0,4,0,4,0,2,0,2,0,1,0,1,0,1,0 },
  { 7,192,24,48,32,8,95,244,95,244,128,2,159,242,159,242,129,2,129,2,129,2,65,4,65,4,33,8,24,48,7,192 },
  { 130,130,130,130,130,130,68,68,68,68,40,40,40,40,16,16,16,16,40,40,40,40,68,68,68,68,130,130,130,130,130,130 },
  { 1,0,1,0,1,0,1,0,1,0,1,0,255,254,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0 },
  { 8,32,8,32,8,32,8,32,8,32,8,32,255,254,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32 },
  { 16,136,16,136,16,136,16,136,16,136,16,136,255,254,16,136,16,136,16,136,16,136,16,136,32,136,32,136,64,136,128,8 },
  { 0,0,0,0,2,0,1,0,0,128,0,64,0,128,1,0,0,128,0,64,0,32,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,127,240,64,48,64,80,64,144,65,16,66,16,68,16,72,16,80,16,96,16,127,240,0,0,0,0 },
  { 0,0,0,0,16,0,40,96,68,144,3,16,0,16,0,16,0,16,0,16,0,16,0,16,0,8,0,8,0,4,0,0 },
  { 219,109,128,1,14,0,145,137,128,113,0,0,128,17,128,33,31,248,128,129,129,1,31,248,132,1,136,0,0,1,219,109 },
  { 0,254,130,198,198,170,170,146,170,170,198,198,130,254,0,0 },
  { 0,0,127,254,99,206,125,182,113,182,125,182,99,206,127,254,127,254,109,206,109,182,97,182,125,182,125,206,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,4,0,2,0,19,128,14,0,4,128,7,224,13,16,22,16,38,16,42,32,16,192,0,0 },
  { 0,0,4,0,2,0,2,192,31,0,4,128,4,128,7,224,13,16,21,8,34,8,38,8,42,16,16,96,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,64,16,32,16,16,16,48,10,0,12,0,4,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,64,0,32,96,32,16,32,8,34,8,36,24,20,8,24,0,8,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,0,1,128,0,0,19,128,12,64,0,64,0,64,0,64,0,128,3,0,0,0 },
  { 0,0,2,0,1,192,0,0,0,0,3,192,28,32,0,32,0,32,0,32,0,32,0,64,0,64,0,128,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,0,1,128,0,0,1,192,14,128,1,0,2,0,7,0,9,0,16,240,0,0 },
  { 0,0,4,0,3,128,0,0,0,0,17,192,14,128,1,0,2,0,4,0,14,0,17,0,33,0,32,248,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,16,64,8,48,12,32,56,0,11,192,12,32,24,32,40,32,24,192,8,0,0,0 },
  { 0,0,0,0,8,0,4,48,5,8,6,12,28,0,4,96,5,144,6,8,12,8,52,136,12,112,4,0,0,0,0,0 },
  { 0,0,0,0,8,0,4,0,4,96,71,16,60,136,8,152,8,128,8,128,16,128,17,0,37,0,34,0,0,0,0,0 },
  { 0,0,0,8,8,36,4,16,4,64,71,32,60,144,8,136,8,152,8,128,16,128,17,0,37,0,34,0,0,0,0,0 },
  { 0,0,2,0,1,0,1,96,15,128,0,128,0,240,31,64,0,32,0,32,7,240,8,16,8,0,6,0,1,192,0,0 },
  { 0,0,4,8,2,36,2,208,31,0,1,0,1,224,62,128,0,64,0,64,15,224,16,32,16,0,12,0,3,128,0,0 },
  { 0,0,0,128,0,64,0,64,0,128,1,0,6,0,8,0,8,0,4,0,2,0,1,0,0,128,0,64,0,64,0,0 },
  { 0,0,0,128,0,64,0,64,0,136,1,36,6,16,8,0,8,0,4,0,2,0,1,0,0,128,0,64,0,64,0,0 },
  { 0,0,0,128,32,64,16,32,16,32,16,60,35,224,32,32,32,32,32,32,32,32,24,32,16,64,16,64,0,128,0,0 },
  { 0,0,1,8,64,164,32,80,32,64,32,120,71,192,64,64,64,64,64,64,64,64,48,64,32,128,32,128,1,0,0,0 },
  { 0,0,0,0,8,0,7,224,0,128,1,0,0,0,0,0,0,0,0,0,32,0,32,0,16,16,15,224,0,0,0,0 },
  { 0,0,0,8,8,4,7,240,0,136,1,0,0,0,0,0,0,0,0,0,32,0,32,0,16,16,15,224,0,0,0,0 },
  { 0,0,4,0,2,0,1,48,33,192,30,128,0,64,0,64,7,224,8,32,16,0,16,0,12,0,3,192,0,0,0,0 },
  { 0,0,4,8,2,4,1,48,33,200,30,128,0,64,0,64,7,224,8,32,16,0,16,0,12,0,3,192,0,0,0,0 },
  { 0,0,0,0,16,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,8,8,16,4,96,3,128,0,0,0,0 },
  { 0,0,0,0,16,32,8,144,8,64,8,0,8,0,8,0,8,0,8,0,8,8,8,16,4,96,3,128,0,0,0,0 },
  { 0,0,1,0,0,128,64,248,63,128,0,128,3,128,4,192,4,64,3,192,0,64,0,128,0,128,1,0,2,0,0,0 },
  { 0,0,1,40,0,148,64,248,63,128,0,128,3,128,4,192,4,64,3,192,0,64,0,128,0,128,1,0,2,0,0,0 },
  { 0,0,0,0,0,128,16,64,8,64,8,120,75,192,60,64,8,64,8,64,8,192,8,64,4,0,3,224,0,0,0,0 },
  { 0,0,0,8,0,132,16,80,8,72,8,120,75,192,60,64,8,64,8,64,8,192,8,64,4,0,3,224,0,0,0,0 },
  { 0,0,0,0,9,192,6,64,0,128,1,0,2,56,7,192,56,128,1,0,2,0,2,0,2,0,1,0,0,224,0,0 },
  { 0,0,0,0,9,200,6,100,0,144,1,0,2,56,7,192,56,128,1,0,2,0,2,0,2,0,1,0,0,224,0,0 },
  { 0,0,0,0,8,0,4,128,7,0,60,0,8,240,8,24,8,32,16,0,16,0,17,0,33,0,32,248,0,0,0,0 },
  { 0,0,0,8,8,36,4,144,7,0,60,0,8,240,8,24,8,32,16,0,16,0,17,0,33,0,32,248,0,0,0,0 },
  { 0,0,8,0,4,0,4,192,71,0,60,0,8,0,8,192,11,32,28,16,16,16,0,16,0,32,0,192,7,0,0,0 },
  { 0,0,8,0,4,8,4,196,71,16,60,8,8,0,8,192,11,32,28,16,16,16,0,16,0,32,0,192,7,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,192,6,32,56,16,0,16,0,16,0,32,0,192,7,0,0,0 },
  { 0,0,0,0,0,0,0,0,3,224,76,16,48,8,0,8,0,8,0,8,0,16,0,96,3,128,0,0,0,0,0,0 },
  { 0,0,0,8,0,36,0,16,3,224,76,16,48,8,0,8,0,8,0,8,0,16,0,96,3,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,56,67,192,60,128,1,0,1,0,2,0,2,0,2,0,2,0,2,0,1,0,0,224,0,0,0,0 },
  { 0,0,0,0,0,56,67,192,60,136,1,36,1,16,2,0,2,0,2,0,2,0,2,0,1,0,0,224,0,0,0,0 },
  { 0,0,0,0,4,0,2,0,2,0,2,0,2,112,3,128,6,0,8,0,16,0,16,0,8,0,7,240,0,0,0,0 },
  { 0,0,0,0,4,8,2,36,2,16,2,0,2,112,3,128,6,0,8,0,16,0,16,0,8,0,7,240,0,0,0,0 },
  { 0,0,4,0,2,0,2,128,63,0,4,112,8,24,8,32,16,64,16,64,32,64,3,192,4,96,4,80,3,128,0,0 },
  { 0,0,0,0,32,0,16,0,16,240,19,24,32,32,32,0,32,0,32,0,34,0,42,0,17,248,16,0,16,0,0,0 },
  { 0,0,0,0,1,0,0,128,0,128,19,224,21,16,25,8,18,8,42,8,76,8,76,104,84,144,32,104,0,0,0,0 },
  { 0,0,16,0,8,0,8,0,8,0,76,224,63,16,12,16,8,16,24,16,24,16,40,240,89,24,8,224,0,0,0,0 },
  { 0,0,0,0,0,0,3,192,13,32,17,16,17,8,34,8,34,8,36,8,36,16,40,16,16,96,1,128,0,0,0,0 },
  { 0,0,0,64,32,32,16,32,20,56,19,224,32,32,32,32,32,32,32,32,41,224,18,48,18,40,17,192,0,0,0,0 },
  { 0,0,0,136,64,68,32,80,40,120,39,192,64,64,64,64,64,64,64,64,83,192,36,96,36,80,35,128,0,0,0,0 },
  { 0,0,0,152,64,100,32,100,40,120,39,192,64,64,64,64,64,64,64,64,83,192,36,96,36,80,35,128,0,0,0,0 },
  { 0,0,0,0,0,64,4,64,60,32,8,32,8,48,16,40,16,32,16,32,16,64,16,64,8,128,7,0,0,0,0,0 },
  { 0,0,0,8,0,68,4,80,60,40,8,32,8,48,16,40,16,32,16,32,16,64,16,64,8,128,7,0,0,0,0,0 },
  { 0,0,0,48,0,72,4,72,60,48,8,32,8,48,16,40,16,32,16,32,16,64,16,64,8,128,7,0,0,0,0,0 },
  { 0,0,0,0,4,0,3,128,0,128,1,0,2,0,2,0,1,0,2,176,76,136,56,156,36,128,3,0,0,0,0,0 },
  { 0,0,0,0,4,0,3,136,0,164,1,16,2,0,2,0,1,0,2,176,76,136,56,156,36,128,3,0,0,0,0,0 },
  { 0,0,0,0,4,0,3,152,0,164,1,36,2,24,2,0,1,0,2,176,76,136,56,156,36,128,3,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,6,0,9,0,16,128,32,64,0,48,0,12,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,16,0,72,6,32,9,0,16,128,32,64,0,48,0,12,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,48,0,72,0,72,6,48,9,0,16,128,32,64,0,48,0,12,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,34,48,17,192,16,64,16,56,35,224,32,32,32,32,32,32,41,224,18,48,18,40,17,192,0,0,0,0 },
  { 0,0,0,0,68,104,35,132,32,144,32,120,71,192,64,64,64,64,64,64,83,192,36,96,36,80,35,128,0,0,0,0 },
  { 0,0,0,24,68,100,35,164,32,152,32,112,71,192,64,64,64,64,64,64,83,192,36,96,36,80,35,128,0,0,0,0 },
  { 0,0,1,0,0,128,16,240,15,128,0,128,16,224,15,128,0,128,0,128,15,128,16,224,16,144,15,0,0,0,0,0 },
  { 0,0,0,0,8,128,7,128,1,0,1,0,2,32,2,16,15,240,52,24,68,36,72,32,48,64,0,128,0,0,0,0 },
  { 0,0,8,0,4,0,39,0,28,48,4,8,28,12,36,0,36,0,44,32,24,16,8,16,8,16,7,224,0,0,0,0 },
  { 0,0,0,0,1,0,0,128,16,128,19,192,28,160,17,16,41,8,42,8,70,8,68,8,74,16,48,96,0,0,0,0 },
  { 0,0,2,0,1,0,17,0,14,0,3,128,18,0,36,32,28,32,7,16,4,16,4,16,4,16,2,32,1,192,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,0,8,128,9,224,14,16,60,16,4,96,2,0,2,0,1,0,1,0,0,0 },
  { 0,0,1,0,0,128,1,192,24,0,16,240,11,8,76,8,52,8,2,112,2,0,1,0,1,0,0,128,0,128,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,0,1,0,33,224,39,16,41,16,49,16,35,32,33,192,1,0,2,0,0,0 },
  { 0,0,0,0,3,0,64,128,33,224,34,144,36,136,40,136,48,136,52,136,34,144,33,224,0,128,1,0,2,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,0,1,0,1,32,1,192,1,0,1,0,1,0,15,0,17,192,17,32,14,0,0,0 },
  { 0,0,2,0,1,0,1,0,1,48,1,192,1,0,1,0,1,0,1,0,31,128,33,96,33,16,30,0,0,0,0,0 },
  { 0,0,2,0,1,0,1,192,6,0,8,0,8,0,8,0,9,224,14,16,8,16,8,16,0,32,0,192,3,0,0,0 },
  { 0,0,16,0,9,128,10,64,12,32,12,32,8,32,8,32,8,32,8,32,0,64,0,64,0,128,1,0,2,0,0,0 },
  { 0,0,0,0,8,192,7,64,0,128,1,0,2,0,7,192,12,32,16,16,32,16,3,144,4,96,4,64,3,128,0,0 },
  { 0,0,0,0,16,0,8,0,9,192,10,32,28,32,108,32,8,32,24,32,24,32,40,32,72,36,24,24,8,0,0,0 },
  { 0,0,0,0,17,128,14,128,1,0,2,0,4,0,15,192,8,32,16,16,32,16,0,16,0,32,0,192,7,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,0,4,0,4,0,6,224,29,16,6,16,12,16,12,16,20,32,4,64,0,0 },
  { 0,0,16,0,8,0,8,0,8,0,76,224,63,16,12,8,8,8,24,8,24,8,40,16,72,32,24,192,8,0,0,0 },
  { 0,0,0,0,9,128,6,128,1,0,1,0,3,224,14,16,18,8,36,8,36,8,40,200,25,48,16,224,0,0,0,0 },
  { 0,0,0,0,9,128,7,0,2,0,7,192,8,32,16,32,6,32,9,192,7,0,8,0,28,224,35,16,64,56,0,0 },
  { 0,0,4,0,2,0,18,192,15,0,4,0,4,32,15,56,24,192,33,128,2,128,4,128,8,0,8,0,7,224,0,0 },
  { 0,0,2,0,1,0,1,0,2,0,2,0,4,0,4,0,15,0,8,128,16,128,16,136,32,144,32,96,0,0,0,0 },
  { 0,0,2,0,1,200,0,4,0,16,3,200,28,32,0,32,0,32,0,32,0,32,0,64,0,64,0,128,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,4,0,4,96,63,16,4,136,8,152,16,128,17,0,37,0,34,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,128,0,64,8,32,8,32,8,56,17,224,16,32,16,32,20,32,20,64,8,64,0,128,0,0 },
  { 0,0,127,254,99,206,125,182,113,182,125,182,99,206,127,254,127,254,115,134,109,246,113,238,125,222,115,222,127,254,0,0 },
  { 0,0,127,254,99,206,125,182,113,182,125,182,99,206,127,254,127,254,115,206,109,182,113,206,125,182,115,206,127,254,0,0 },
  { 0,0,0,4,0,18,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,6,0,9,0,9,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,0,72,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,48,0,72,0,72,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,12,0,3,0,0,128,0,192,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,32,0,144,12,64,3,0,0,128,0,192,1,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,6,0,1,128,8,0,8,0,8,0,8,0,15,192,16,32,0,16,0,16,0,32,0,192,3,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,0,0,0,0,0,0,0,126,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,224,30,32,2,64,1,128,1,0,1,0,2,0,4,0,0,0 },
  { 0,0,0,0,0,0,33,240,30,16,0,32,2,64,1,128,1,0,1,0,1,0,2,0,2,0,4,0,8,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,32,0,64,0,128,3,128,28,128,0,128,0,128,0,128,0,128,0,128,0,0 },
  { 0,0,0,0,0,32,0,32,0,64,0,128,3,0,13,0,48,128,0,128,0,128,0,128,0,128,0,128,0,128,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,0,1,0,1,224,30,32,8,32,8,64,0,64,0,128,1,0,2,0,0,0 },
  { 0,0,0,0,2,0,1,0,1,0,1,240,62,16,16,16,16,32,8,32,8,64,0,64,0,128,1,0,2,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,15,0,1,0,1,0,1,0,1,224,30,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,112,31,128,2,0,1,0,1,0,1,0,1,0,3,240,60,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,1,0,0,128,16,224,15,128,1,128,2,128,4,128,8,128,17,128,0,128,0,0 },
  { 0,0,0,0,0,128,0,64,0,64,32,120,31,192,0,192,1,64,2,64,4,64,8,64,16,64,0,192,0,64,0,0 },
  { 0,0,0,0,2,0,1,0,1,0,33,240,31,16,2,16,2,16,4,32,4,32,8,32,17,64,32,192,0,128,0,0 },
  { 0,0,0,8,2,36,1,20,1,16,33,240,31,16,2,16,2,16,4,32,4,32,8,32,17,64,32,192,0,128,0,0 },
  { 0,0,0,0,4,0,2,0,2,112,3,128,29,0,1,0,1,120,3,128,60,128,0,128,0,64,0,64,0,64,0,0 },
  { 0,0,0,8,4,36,2,20,2,112,3,128,29,0,1,0,1,120,3,128,60,128,0,128,0,64,0,64,0,64,0,0 },
  { 0,0,0,0,4,0,2,112,3,144,2,32,4,32,4,64,8,64,16,128,0,128,1,0,2,0,4,0,8,0,0,0 },
  { 0,0,0,8,8,36,4,212,7,80,4,64,8,64,8,128,16,128,33,0,1,0,2,0,4,0,8,0,16,0,0,0 },
  { 0,0,0,0,8,0,4,0,4,0,4,56,15,192,9,0,16,128,32,128,0,128,1,0,1,0,2,0,4,0,0,0 },
  { 0,0,0,8,8,36,4,20,4,16,4,56,15,192,9,0,16,128,32,128,0,128,1,0,1,0,2,0,4,0,0,0 },
  { 0,0,0,0,0,0,0,0,33,240,30,16,0,16,0,16,0,16,0,32,0,32,3,224,28,32,0,0,0,0,0,0 },
  { 0,0,0,8,0,36,0,20,67,208,60,64,0,64,0,64,0,64,0,128,0,128,7,128,56,128,0,0,0,0,0,0 },
  { 0,0,0,0,0,128,8,64,4,64,4,64,36,248,31,64,4,64,4,64,4,64,0,128,0,128,1,0,2,0,0,0 },
  { 0,0,0,8,0,164,8,84,4,80,4,64,36,248,31,64,4,64,4,64,4,64,0,128,0,128,1,0,2,0,0,0 },
  { 0,0,0,0,0,0,12,0,2,0,0,0,24,0,4,8,0,16,0,32,0,64,0,128,19,0,12,0,0,0,0,0 },
  { 0,0,0,0,0,8,12,36,2,20,0,16,24,0,4,8,0,16,0,32,0,64,0,128,19,0,12,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,224,15,32,0,64,0,64,0,128,0,128,1,64,2,32,12,16,48,16,0,0,0,0,0,0 },
  { 0,0,0,8,0,36,33,212,30,80,0,128,0,128,1,0,1,0,2,128,4,64,24,32,96,32,0,0,0,0,0,0 },
  { 0,0,0,0,8,0,4,0,4,0,4,120,5,136,38,16,28,32,4,64,4,0,4,0,2,0,1,240,0,0,0,0 },
  { 0,0,0,8,8,36,4,20,4,16,4,120,5,136,38,16,28,32,4,64,4,0,4,0,2,0,1,248,0,0,0,0 },
  { 0,0,0,0,0,32,16,16,8,16,4,16,4,32,4,32,0,64,0,64,0,128,0,128,1,0,2,0,4,0,0,0 },
  { 0,0,0,8,0,164,32,84,16,80,8,64,8,64,8,64,0,128,0,128,1,0,1,0,2,0,4,0,8,0,0,0 },
  { 0,0,0,0,2,0,1,0,1,240,2,16,2,32,5,32,8,192,16,64,0,128,1,0,2,0,12,0,48,0,0,0 },
  { 0,0,0,8,4,36,2,20,3,240,4,32,4,32,10,64,17,64,32,128,1,0,2,0,4,0,24,0,96,0,0,0 },
  { 0,0,0,0,0,64,1,128,30,0,1,0,0,248,35,128,28,128,0,128,0,128,1,0,1,0,2,0,4,0,0,0 },
  { 0,0,0,8,0,100,1,148,30,16,1,0,0,248,35,128,28,128,0,128,0,128,1,0,1,0,2,0,4,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,64,18,32,10,32,8,64,0,64,0,128,1,0,2,0,0,0 },
  { 0,0,0,0,0,0,4,16,34,8,17,8,9,16,8,16,0,32,0,32,0,64,0,128,1,0,2,0,0,0,0,0 },
  { 0,0,0,8,0,36,16,148,8,80,68,64,36,64,16,64,16,128,0,128,1,0,2,0,4,0,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,17,224,14,0,0,0,0,120,35,128,28,128,0,128,1,0,1,0,2,0,4,0,8,0,0,0 },
  { 0,0,0,8,0,36,17,212,14,16,0,0,32,240,31,0,0,128,0,128,1,0,1,0,2,0,4,0,8,0,0,0 },
  { 0,0,0,0,8,0,4,0,4,0,4,0,4,0,7,0,4,192,4,32,4,0,4,0,4,0,4,0,4,0,0,0 },
  { 0,0,0,32,16,144,8,80,8,64,8,0,8,0,14,0,9,128,8,64,8,0,8,0,8,0,8,0,8,0,0,0 },
  { 0,0,0,0,1,0,0,128,0,128,32,248,31,128,0,128,0,128,0,128,1,0,1,0,2,0,4,0,8,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,224,31,0,0,0,0,0,0,0,0,0,1,240,62,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,240,15,16,0,32,0,32,14,64,1,192,0,192,1,32,2,16,12,16,48,0,0,0,0,0 },
  { 0,0,0,0,2,0,1,0,1,224,30,32,0,64,0,128,1,0,3,64,13,48,49,8,1,0,1,0,1,0,0,0 },
  { 0,0,0,0,0,64,0,32,0,32,0,32,0,64,0,64,0,128,0,128,1,0,2,0,4,0,8,0,16,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,8,128,4,64,4,32,8,16,8,16,16,8,32,8,64,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,8,0,36,0,20,8,144,4,64,4,32,8,16,8,16,16,8,32,8,64,8,0,0,0,0,0,0 },
  { 0,0,0,24,0,36,0,36,0,24,8,128,4,64,4,32,8,16,8,16,16,8,32,8,64,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,0,8,0,8,0,8,224,15,0,8,0,8,0,8,0,8,0,4,0,3,240,0,0,0,0 },
  { 0,0,0,0,0,16,16,72,8,40,8,32,8,0,8,224,15,0,8,0,8,0,8,0,4,0,3,240,0,0,0,0 },
  { 0,0,0,0,0,48,16,72,8,72,8,48,8,0,8,224,15,0,8,0,8,0,8,0,4,0,3,240,0,0,0,0 },
  { 0,0,0,0,0,0,16,240,15,16,0,16,0,32,0,32,0,64,0,64,0,128,1,0,2,0,4,0,0,0,0,0 },
  { 0,0,0,8,0,36,35,212,28,80,0,64,0,128,0,128,1,0,1,0,2,0,4,0,8,0,16,0,0,0,0,0 },
  { 0,0,0,24,0,36,35,228,28,88,0,64,0,128,0,128,1,0,1,0,2,0,4,0,8,0,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,2,0,5,0,72,128,48,64,0,48,0,12,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,32,0,144,0,80,2,64,5,0,72,128,48,64,0,48,0,12,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,96,0,144,0,144,2,96,5,0,72,128,48,64,0,48,0,12,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,2,0,1,0,1,0,33,240,31,0,1,0,1,64,9,32,9,16,17,16,33,0,3,0,1,0,0,0 },
  { 0,0,0,8,2,36,1,20,1,16,33,240,31,0,1,0,1,64,9,32,9,16,17,16,33,0,3,0,1,0,0,0 },
  { 0,0,0,24,2,36,1,36,1,24,33,240,31,0,1,0,1,64,9,32,9,16,17,16,33,0,3,0,1,0,0,0 },
  { 0,0,0,0,0,0,0,0,32,240,31,8,0,16,0,32,0,64,12,128,3,0,0,128,0,64,0,0,0,0,0,0 },
  { 0,0,0,0,4,0,3,0,0,192,0,32,8,0,6,0,1,128,0,64,16,0,12,0,3,0,0,192,0,32,0,0 },
  { 0,0,0,0,2,0,1,0,1,0,1,0,2,0,2,0,2,64,4,32,4,48,41,200,30,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,64,0,32,0,32,0,32,6,32,1,192,0,64,0,160,0,144,1,0,2,0,12,0,48,0,0,0 },
  { 0,0,0,0,0,0,16,224,15,0,2,0,2,0,35,248,30,0,2,0,2,0,2,0,1,240,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,4,0,2,112,3,144,30,32,1,64,1,0,0,128,0,128,0,128,0,0 },
  { 0,0,0,0,8,0,4,0,4,120,3,136,38,16,26,32,1,64,1,0,1,0,0,128,0,128,0,128,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,192,14,64,0,64,0,128,1,224,30,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,17,192,14,64,0,64,0,128,0,128,1,240,62,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,224,14,32,0,32,1,224,14,64,0,64,1,192,14,32,0,0,0,0 },
  { 0,0,0,0,0,0,1,240,30,16,0,16,0,16,1,224,14,32,0,32,0,32,0,32,1,224,14,16,0,0,0,0 },
  { 0,0,0,0,0,0,17,192,14,0,0,112,35,144,28,16,0,16,0,32,0,32,0,64,0,128,3,0,12,0,0,0 },
  { 0,0,0,0,0,64,8,32,4,32,4,32,4,32,4,32,4,32,4,32,0,64,0,64,0,128,1,0,2,0,0,0 },
  { 0,0,0,0,0,0,1,0,8,128,4,128,4,128,4,136,4,136,4,144,8,144,8,160,16,192,32,128,0,0,0,0 },
  { 0,0,0,0,16,0,8,0,8,0,8,0,8,0,8,0,8,16,8,32,8,64,8,128,11,0,12,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,33,240,30,16,16,16,16,16,8,32,8,32,9,224,14,16,8,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,240,15,16,8,32,4,32,4,64,0,64,0,128,1,0,0,0 },
  { 0,0,0,0,0,0,33,240,30,16,16,16,8,16,8,32,8,32,0,64,0,64,0,128,1,0,2,0,4,0,0,0 },
  { 0,0,0,0,1,0,0,128,0,128,1,240,30,128,8,128,4,128,5,240,62,136,0,128,0,128,0,128,0,128,0,0 },
  { 0,0,0,0,0,0,0,0,1,224,30,32,2,64,1,128,1,0,1,0,1,240,62,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,240,30,16,0,16,0,32,1,224,14,32,0,64,0,64,0,128,1,0,6,0,24,0,0,0 },
  { 0,0,0,0,0,0,0,0,24,0,4,8,2,8,0,16,0,16,0,32,0,64,0,128,19,0,12,0,0,0,0,0 },
  { 0,0,0,8,4,36,2,20,2,16,67,224,60,32,32,32,16,64,16,64,0,128,0,128,1,0,2,0,4,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,0,17,224,14,32,2,32,2,32,4,32,8,192,16,64,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,8,0,4,0,4,96,7,128,8,128,16,128,1,0,2,0,4,0,0,0 },
  { 0,4,0,18,0,8,33,240,30,16,16,16,8,16,8,32,8,32,0,64,0,64,0,128,1,0,2,0,4,0,0,0 },
  { 0,0,0,8,1,4,0,144,0,136,1,240,30,128,8,128,4,128,5,240,62,136,0,128,0,128,0,128,0,128,0,0 },
  { 0,0,0,8,0,4,0,16,1,232,30,32,2,64,1,128,1,0,1,0,1,240,62,8,0,0,0,0,0,0,0,0 },
  { 0,4,0,2,0,8,1,244,30,16,0,16,0,32,1,224,14,32,0,64,0,64,0,128,1,0,6,0,24,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,3,0,7,128,7,128,3,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,248,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,12,0,3,0,0,128,0,64,0,32,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,32,0,144,12,64,3,0,0,128,0,64,0,32,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,33,224,30,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,115,206,109,182,109,182,109,182,115,206,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,115,238,109,206,109,238,109,238,115,198,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,115,134,109,246,109,134,109,190,115,134,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,115,142,109,246,109,198,109,246,115,142,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,115,182,109,182,109,134,109,246,115,246,127,254,0,0 },
  { 4,0,4,0,8,0,17,240,62,16,0,16,0,16,0,32,0,32,0,64,0,64,2,128,1,0,0,0,0,0,0,0 },
  { 1,0,1,0,2,0,7,240,0,16,0,16,2,32,1,64,0,128,1,96,6,32,56,0,0,0,0,0,0,0,0,0 },
  { 0,24,63,236,16,8,16,8,16,8,16,8,16,8,16,8,16,8,16,8,16,8,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,48,31,248,16,0,16,0,16,0,16,0,16,0,16,0,16,0,15,252,0,0,0,0,0,0,0,0,0,0 },
  { 2,0,2,0,4,0,8,0,31,248,33,8,1,8,2,8,2,8,4,8,8,16,16,16,1,32,0,192,0,0,0,0 },
  { 0,192,0,192,0,128,0,128,67,254,61,0,1,0,1,0,2,32,2,16,5,240,6,8,0,8,0,0,0,0,0,0 },
  { 1,224,14,32,0,64,0,64,0,248,0,24,0,16,0,16,0,32,0,32,2,64,1,192,1,0,0,0,0,0,0,0 },
  { 0,128,0,128,4,128,4,128,8,248,15,136,0,136,1,8,1,8,2,16,2,16,4,16,8,160,16,64,0,0,0,0 },
  { 2,16,3,28,2,24,2,16,4,16,12,32,8,64,16,128,24,64,8,32,4,16,2,16,3,8,0,8,0,0,0,0 },
  { 0,8,63,254,3,0,2,0,7,248,4,24,0,16,0,16,0,48,0,32,1,96,1,192,0,128,0,0,0,0,0,0 },
  { 0,30,7,224,4,0,4,0,4,0,4,0,8,0,8,0,8,0,16,0,16,0,32,0,0,0,0,0,0,0,0,0 },
  { 0,64,0,32,0,32,0,32,6,32,4,32,4,32,4,96,5,160,14,32,8,32,0,32,0,32,0,32,0,32,0,0 },
  { 0,16,0,24,0,56,0,96,0,192,3,0,12,0,6,0,1,128,0,64,0,48,0,24,0,12,0,0,0,0,0,0 },
  { 63,254,28,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,0,0,0,0,0,0,0 },
  { 2,0,1,0,1,0,17,16,17,16,17,16,17,240,31,16,1,0,1,0,127,252,32,0,0,0,0,0,0,0,0,0 },
  { 0,64,0,48,0,96,0,128,1,24,6,48,0,96,0,192,3,64,4,64,24,64,0,64,0,64,0,64,0,64,0,0 },
  { 0,28,15,238,0,12,0,12,4,120,7,128,4,0,4,0,4,0,4,0,8,0,16,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,16,96,15,176,8,32,8,32,10,32,9,32,9,32,8,32,8,32,8,32,15,224,8,32,0,0,0,0 },
  { 0,252,31,4,1,4,1,4,1,8,1,8,1,56,1,16,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0 },
  { 1,128,0,128,0,128,1,0,63,254,1,0,1,0,2,0,3,240,2,48,0,32,0,64,0,192,0,128,0,0,0,0 },
  { 1,0,1,128,1,128,1,0,3,0,2,0,4,0,8,32,24,16,16,56,63,204,32,4,0,0,0,0,0,0,0,0 },
  { 32,48,16,32,12,64,4,128,3,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,0,0,0,0,0,0,0,0 },
  { 0,0,63,254,0,64,0,64,0,64,15,192,24,0,16,0,16,0,12,24,7,224,0,0,0,0,0,0,0,0,0,0 },
  { 1,0,0,128,0,128,0,128,3,252,60,128,0,128,7,128,8,0,16,0,16,0,16,0,8,16,7,224,0,0,0,0 },
  { 0,0,12,48,4,32,4,32,4,254,15,32,116,64,4,64,4,64,4,0,4,0,3,240,0,0,0,0,0,0,0,0 },
  { 31,252,8,128,8,128,25,144,31,248,1,24,2,24,2,16,4,16,8,32,16,32,0,64,0,0,0,0,0,0,0,0 },
  { 0,0,1,128,6,128,56,128,0,128,0,128,0,64,0,64,0,32,0,16,0,28,0,12,0,0,0,0,0,0,0,0 },
  { 1,128,1,128,1,16,2,24,2,24,4,48,15,224,56,192,1,128,2,32,4,48,31,200,16,8,0,0,0,0,0,0 },
  { 0,56,15,216,0,16,4,32,2,96,1,192,0,192,1,48,2,24,4,12,24,4,32,0,0,0,0,0,0,0,0,0 },
  { 15,240,0,16,4,32,8,32,8,64,31,252,48,12,0,8,0,16,0,48,0,32,0,64,0,0,0,0,0,0,0,0 },
  { 12,0,8,0,8,0,24,0,16,0,17,252,62,12,0,8,0,8,0,16,0,16,0,32,0,0,0,0,0,0,0,0 },
  { 0,128,0,128,0,128,1,0,1,248,31,128,2,128,2,128,6,128,4,128,8,128,16,128,32,126,0,0,0,0,0,0 },
  { 1,0,0,192,0,192,1,128,1,0,3,0,2,0,4,0,12,0,8,0,23,252,120,0,0,0,0,0,0,0,0,0 },
  { 0,64,6,96,4,64,4,64,4,64,4,64,4,64,8,64,8,64,8,64,16,64,32,62,0,0,0,0,0,0,0,0 },
  { 1,0,1,128,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0 },
  { 0,24,0,24,4,16,2,32,1,96,0,192,0,192,1,32,2,48,4,24,8,12,16,12,0,0,0,0,0,0,0,0 },
  { 16,16,24,24,8,8,8,8,8,8,8,8,8,8,8,8,16,8,16,8,31,248,0,8,0,0,0,0,0,0,0,0 },
  { 0,0,255,252,4,0,4,0,4,0,4,0,7,224,8,32,8,32,8,32,8,32,16,32,16,32,33,64,64,128,0,0 },
  { 0,0,255,248,8,128,8,128,8,128,8,128,8,128,8,128,16,128,16,128,16,128,32,128,32,128,64,128,128,120,0,0 },
  { 1,0,0,128,0,0,63,254,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,64,0,64,0,128,0 },
  { 0,0,0,0,127,252,1,0,1,0,1,0,63,248,33,8,33,8,33,8,33,8,33,8,33,8,1,0,1,0,1,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,97,134,125,190,97,142,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,97,134,125,190,97,142,111,190,97,190,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,99,206,125,182,113,182,125,182,99,206,127,254,0,0 },
  { 0,0,0,0,0,0,32,8,31,252,8,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,65,8,63,252,17,8,1,8,1,8,1,8,1,8,1,8,1,8,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,130,96,127,16,34,16,2,16,2,48,2,40,2,72,2,68,2,130,3,1,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,48,0,8,0,8,0,8,0,8,0,8,8,7,252,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,2,4,193,254,32,160,32,32,32,80,35,136,29,4,2,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,64,0,56,196,2,35,255,33,0,32,120,32,132,35,132,28,132,0,120,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,112,16,31,248,16,0,16,0,16,0,16,0,16,8,15,252,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,98,136,63,252,32,128,32,128,32,128,32,128,35,132,28,126,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,32,16,31,248,8,16,0,16,48,16,31,248,16,0,16,0,16,16,15,248,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,130,4,127,254,34,132,2,4,255,4,64,4,64,4,67,4,60,4,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,65,68,63,254,17,68,1,68,127,196,32,68,32,68,35,196,28,126,0,64,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,66,8,63,4,2,132,2,132,126,252,32,132,32,132,35,132,28,252,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,132,96,126,16,36,16,4,16,254,48,64,40,64,72,70,132,57,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,66,196,63,126,2,64,2,68,127,126,32,64,32,64,35,68,28,62,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,133,8,126,252,4,0,4,0,254,132,64,72,64,72,70,74,59,255,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,132,64,126,56,5,2,4,255,254,0,64,56,64,68,70,68,56,56,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,56,16,15,248,8,16,8,16,8,16,8,16,8,16,8,16,15,248,8,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,32,0,16,16,16,8,16,8,16,15,240,8,16,8,16,8,16,15,240,8,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,8,2,132,33,68,17,68,17,68,31,124,17,68,17,68,17,68,31,124,17,68,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,4,96,66,16,34,16,34,16,62,16,34,40,34,40,34,68,62,68,34,130,0,0,0,0,0,0 },
  { 0,0,0,0,2,0,1,128,0,128,0,128,0,128,1,64,1,64,2,32,4,16,8,8,48,4,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,8,64,4,32,4,32,4,32,10,32,10,80,17,72,32,132,195,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,2,0,1,0,7,192,8,32,16,16,16,16,16,16,16,16,8,32,7,192,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,32,16,31,248,9,0,1,0,1,0,2,128,4,64,8,32,16,16,96,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,129,4,127,254,36,32,4,32,10,80,9,80,16,136,33,4,198,2,0,0,0,0,0,0 },
  { 0,0,0,0,4,0,3,224,0,0,32,8,31,252,8,128,1,64,2,32,4,16,8,8,48,4,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,8,15,252,4,8,0,8,0,248,63,8,16,8,0,8,0,8,0,8,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,56,32,15,240,8,0,8,32,15,240,8,0,8,0,8,16,7,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,32,16,31,248,8,0,0,0,8,16,4,32,2,32,66,72,63,252,16,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,4,0,3,192,64,8,63,252,16,0,3,192,4,32,8,16,8,16,4,32,3,192,0,0,0,0 },
  { 0,64,0,48,0,16,0,16,0,16,0,18,0,31,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,0 },
  { 0,32,1,24,0,200,0,72,0,72,0,72,0,120,0,72,0,72,0,72,0,72,0,72,0,72,0,72,0,8,0,0 },
  { 0,64,0,48,0,16,0,16,0,18,0,31,0,16,0,18,0,31,0,16,0,16,0,16,0,16,0,16,0,16,0,0 },
  { 0,32,1,24,0,200,0,72,0,72,0,120,0,72,0,72,0,120,0,72,0,72,0,72,0,72,0,72,0,8,0,0 },
  { 0,64,0,48,0,16,0,16,0,16,0,16,0,16,3,240,1,16,0,16,0,16,0,16,0,16,0,16,0,16,0,0 },
  { 0,16,0,140,0,100,0,36,0,36,0,36,3,228,1,36,0,36,0,36,0,36,0,36,0,36,0,36,0,4,0,0 },
  { 0,64,0,48,0,16,0,16,0,16,3,240,1,16,0,16,3,240,1,16,0,16,0,16,0,16,0,16,0,16,0,0 },
  { 0,16,0,140,0,100,0,36,0,36,3,228,1,36,0,36,3,228,1,36,0,36,0,36,0,36,0,36,0,4,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,128,0,128,0,128,64,130,63,255,16,0,0,0,0,0,0,0 },
  { 0,64,0,48,0,16,0,16,0,16,0,16,8,16,4,18,4,31,5,240,126,16,32,16,0,16,0,16,0,16,0,0 },
  { 0,16,0,140,0,100,0,36,0,36,8,36,4,36,4,60,4,36,7,228,124,36,32,36,0,36,0,36,0,4,0,0 },
  { 0,32,0,24,0,8,0,8,0,8,4,8,2,8,2,8,2,8,3,248,126,8,32,8,0,8,0,8,0,8,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,64,4,32,2,32,2,32,66,34,63,255,16,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,64,2,63,255,16,128,0,128,0,128,0,128,0,128,0,128,0,128,0,0 },
  { 0,32,0,24,0,8,0,8,0,8,0,8,1,232,126,8,40,8,9,248,8,136,8,8,8,8,8,8,0,8,0,0 },
  { 0,32,0,152,0,72,0,72,0,72,0,72,0,72,3,200,124,72,40,72,11,200,8,72,8,72,8,72,0,8,0,0 },
  { 0,32,0,24,0,8,0,8,0,8,0,8,0,8,1,232,126,8,36,8,4,8,4,8,4,8,4,8,0,8,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,64,2,63,255,18,32,2,32,2,32,2,32,2,32,2,32,2,32,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,2,63,255,16,0,0,0,0,0,0,0,0,0 },
  { 0,32,0,24,0,8,0,8,0,8,0,8,0,8,0,8,1,248,126,8,32,8,0,8,0,8,0,8,0,8,0,0 },
  { 0,64,0,48,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,0 },
  { 170,170,0,1,128,0,0,1,128,0,0,1,145,60,17,33,159,56,17,33,145,32,0,1,128,0,0,1,128,0,85,85 },
  { 0,0,0,0,0,0,193,128,32,64,32,64,32,64,32,64,32,64,35,68,28,62,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,192,196,32,126,32,64,32,64,32,64,32,64,35,66,28,63,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,192,32,32,16,32,16,32,16,32,16,32,40,35,72,28,132,1,2,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,192,16,32,16,32,40,32,40,32,68,32,68,35,130,28,255,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,136,80,127,232,8,72,8,72,252,84,64,84,64,98,60,65,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,66,200,63,124,2,64,2,64,127,64,32,64,32,64,35,68,28,62,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,136,144,124,72,10,72,10,72,255,212,66,84,78,98,51,193,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,132,32,126,32,4,32,4,80,252,80,64,136,64,136,71,4,59,254,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,132,0,126,0,5,4,4,254,254,64,64,56,64,68,70,68,56,56,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,8,98,132,63,68,34,68,34,124,34,68,34,68,34,68,63,124,32,68,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,98,32,63,16,34,16,34,16,34,16,34,40,34,40,62,68,34,130,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,98,16,63,16,34,40,34,40,34,68,34,68,34,68,34,130,63,255,32,0,0,0,0,0,0,0 },
  { 0,0,48,8,31,252,16,8,16,8,16,8,31,252,17,0,0,128,7,224,8,16,16,8,16,8,8,16,7,224,0,0 },
  { 0,0,0,0,0,0,4,0,2,130,130,127,66,34,126,2,66,2,66,2,66,2,126,2,66,2,0,0,0,0,0,0 },
  { 0,0,0,0,4,0,2,200,130,124,66,64,66,64,126,64,66,64,66,64,66,68,126,62,66,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,17,66,136,191,72,130,72,130,121,130,73,66,74,66,122,34,76,18,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,17,50,136,159,72,144,72,144,121,144,73,80,74,80,122,82,76,47,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,8,0,134,4,69,254,68,160,124,32,68,32,68,80,124,136,71,6,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,4,0,2,196,130,126,66,64,66,68,126,126,66,64,66,64,66,68,126,62,66,0,0,0,0,0,0,0 },
  { 0,16,32,8,16,8,31,248,16,8,16,8,31,248,17,8,0,128,7,224,8,16,16,8,16,8,8,16,7,224,0,0 },
  { 0,16,36,136,18,72,30,120,18,72,18,72,30,120,18,72,0,128,7,224,8,16,16,8,16,8,8,16,7,224,0,0 },
  { 0,0,0,0,0,0,9,4,4,254,4,68,4,4,10,4,10,4,17,4,33,4,192,132,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,8,0,5,128,4,64,6,64,10,64,10,64,17,64,33,68,64,190,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,16,196,8,126,8,64,8,64,20,64,20,64,34,64,65,68,128,190,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,4,16,2,8,130,8,66,8,126,20,66,20,66,34,66,33,126,64,194,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,18,2,9,255,8,144,8,16,20,40,20,40,34,68,65,66,129,129,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,1,0,1,0,2,128,2,128,4,64,4,64,8,32,8,32,16,16,63,248,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,24,24,8,8,60,60,66,66,66,66,66,66,66,66,66,66,66,66,60,60,0,0,0,0,0,0,0,0 },
  { 0,0,3,0,1,0,15,224,16,16,32,8,32,8,32,8,32,8,32,8,32,8,16,16,15,224,0,0,0,0,0,0 },
  { 0,0,48,0,18,4,121,254,132,160,132,32,132,32,132,80,132,80,132,136,133,4,122,2,0,0,0,0,0,0,0,0 },
  { 0,0,48,0,16,32,120,32,132,80,132,80,132,136,132,136,132,136,133,4,133,4,123,254,0,0,0,0,0,0,0,0 },
  { 0,0,32,16,31,248,0,0,4,32,66,72,63,252,17,0,0,128,7,224,8,16,16,8,16,8,8,16,7,224,0,0 },
  { 0,0,0,0,32,64,28,56,129,2,127,255,32,0,28,56,34,68,34,68,34,68,28,56,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,64,8,63,252,18,0,1,0,7,192,8,32,8,32,8,32,8,32,7,192,0,0,0,0,0,0,0,0 },
  { 0,64,0,48,0,16,0,16,0,16,9,18,9,31,9,16,9,242,126,31,32,16,0,16,0,16,0,16,0,16,0,0 },
  { 0,32,1,24,0,200,0,72,0,72,4,120,2,72,34,72,18,120,19,200,124,72,32,72,0,72,0,72,0,8,0,0 },
  { 0,32,0,24,0,8,0,8,0,8,2,8,17,8,9,8,9,8,11,232,124,8,32,8,0,8,0,8,0,8,0,0 },
  { 0,32,0,24,0,8,0,8,0,8,0,8,1,232,127,8,41,120,9,8,9,120,9,8,9,8,9,8,0,8,0,0 },
  { 0,32,1,24,0,200,0,72,0,72,0,72,3,72,252,72,85,200,20,72,21,200,20,72,20,72,0,72,0,8,0,0 },
  { 0,32,0,24,0,8,0,8,0,8,0,8,0,8,1,232,127,8,41,8,9,8,9,8,9,8,9,8,0,8,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,1,0,3,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,32,0,24,0,8,0,8,0,8,0,8,0,8,0,8,2,8,7,8,2,8,0,8,0,8,0,8,0,8,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,115,134,109,190,115,142,109,190,115,190,127,254,0,0 },
  { 0,0,0,0,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,2,0,2,0,2,0,2,32,2,64,2,128,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,128,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,31,224,0,0,15,192,0,0,0,0,63,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,224,37,32,37,32,40,224,32,32,63,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,4,0,4,0,7,128,4,0,4,0,4,0,63,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,0,4,0,63,192,36,64,36,64,63,192,4,0,4,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,192,4,0,6,0,5,0,4,0,4,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,192,34,64,63,192,34,64,63,192,34,64,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,128,3,0,4,0,8,0,16,64,32,64,31,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,224,2,0,63,224,34,32,35,32,36,160,40,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,224,2,0,2,0,2,0,2,0,2,0,10,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,31,192,2,0,2,0,63,224,2,0,5,0,8,224,16,64,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,8,64,9,80,61,240,11,80,9,80,9,40,13,8,48,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,4,0,4,0,4,0,4,0,10,0,9,0,16,128,32,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,16,0,16,0,32,0,127,240,0,16,0,16,0,16,0,16,0,16,0,16,0,16,1,160,2,96,2,64,1,128 },
  { 0,0,0,0,63,240,4,16,4,16,4,16,4,16,4,16,4,32,5,32,4,192,4,0,52,0,76,0,76,0,52,0 },
  { 0,0,0,64,8,64,8,64,8,64,8,64,8,64,8,64,16,192,19,64,28,64,0,64,3,64,4,192,4,192,3,64 },
  { 0,0,0,0,8,128,8,128,17,0,17,0,34,0,34,0,68,0,34,0,34,0,17,48,17,72,8,200,8,176,0,0 },
  { 0,0,0,0,16,0,16,0,16,0,255,248,16,8,16,16,16,16,16,0,16,0,16,0,16,0,15,240,0,0,0,0 },
  { 0,0,0,0,16,0,16,0,16,0,255,248,16,8,16,16,16,16,16,0,16,48,16,72,16,72,15,240,0,16,0,0 },
  { 0,0,0,0,255,248,2,0,2,0,2,0,30,0,32,0,64,0,64,0,32,32,16,64,8,128,5,0,2,0,0,0 },
  { 0,0,0,0,255,248,2,0,2,0,2,0,30,0,32,0,64,96,64,144,64,144,64,80,32,96,31,144,0,0,0,0 },
  { 0,0,0,0,32,32,16,64,16,64,8,128,8,128,5,0,5,0,3,248,5,0,8,128,48,96,192,24,0,0,0,0 },
  { 0,0,32,16,16,32,8,64,4,128,1,0,2,0,2,0,2,0,2,0,2,0,2,0,26,0,38,0,38,0,26,0 },
  { 0,0,0,0,0,0,0,0,0,24,0,36,0,36,255,248,0,16,0,8,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,32,32,16,64,16,64,8,128,8,128,5,0,5,0,2,0,5,24,8,164,48,100,192,24,0,8,0,0 },
  { 0,0,0,0,0,0,255,248,33,8,33,8,33,8,33,8,33,8,33,8,33,8,33,8,33,40,0,16,0,0,0,0 },
  { 0,0,0,0,255,248,18,64,18,64,18,64,18,64,18,64,18,64,18,64,18,64,18,64,34,60,194,0,0,0,0,0 },
  { 0,0,0,0,255,248,18,0,18,0,34,0,63,240,2,16,2,16,2,16,4,16,100,16,152,32,144,32,104,64,0,0 },
  { 0,0,4,0,4,0,8,64,8,64,16,128,16,128,63,0,2,0,4,96,8,144,16,144,63,224,0,32,0,16,0,0 },
  { 0,0,48,96,8,128,5,0,255,248,130,8,130,8,130,8,130,8,130,8,130,8,130,8,130,8,130,8,130,40,0,16 },
  { 0,0,255,248,2,0,255,248,130,8,142,8,144,8,160,8,160,8,160,40,144,72,143,136,128,8,128,40,0,16,0,0 },
  { 0,0,0,0,255,248,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,255,248,0,0 },
  { 0,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,26,0,38,0,38,0,26,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,126,0,2,0,2,0,2,0,20,0,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,16,0,32,0,126,0,18,0,34,0,66,0,148,0,8,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,252,0,32,0,64,0,248,0,8,0,8,0,40,0,16,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,0,32,0,32,0,32,0,32,0,64,0,128,0,0,0,0,0 },
  { 0,0,0,0,127,240,0,32,0,64,0,128,1,0,2,0,4,0,8,0,16,0,32,0,127,240,0,0,0,0,0,0 },
  { 0,0,32,0,32,0,32,0,32,0,32,0,32,0,63,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,1,0,1,0,1,0,1,0,127,252,1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,99,142,109,182,99,142,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,99,198,109,190,99,190,109,190,99,198,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,99,142,109,182,99,182,109,182,99,142,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,99,134,109,190,99,142,109,190,99,134,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,99,134,109,190,99,142,109,190,99,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,64,1,128,6,0,56,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 4,0,2,0,2,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,5,0,2,0 },
  { 16,0,16,0,16,0,16,0,8,0,8,0,8,0,4,0,4,0,2,0,2,0,1,0,0,144,0,80,0,32,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,128,0,64,0,32,0,24,4,6,2,1,252,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,15,240,0,0,0,0 },
  { 0,0,0,0,63,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,240,0,0,0,0 },
  { 0,0,0,0,0,0,63,240,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,80,0,32,0,0 },
  { 0,0,0,0,63,240,0,16,0,16,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,1,0,2,0,4,0 },
  { 0,0,0,0,127,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,130,0,130,0,130,0,124 },
  { 0,0,32,0,32,0,32,0,32,0,32,0,32,0,63,248,0,8,0,8,0,8,0,8,0,16,0,16,0,160,0,64 },
  { 0,0,0,0,62,0,2,0,2,0,2,0,2,0,2,0,2,0,2,64,2,128,3,0,2,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,252,0,8,0,16,0,32,0,124,0,4,0,4,0,4,0,8,0,8,0,16,0,32,0,64,0,128 },
  { 0,0,3,224,0,32,0,64,0,128,0,128,0,64,0,64,0,32,0,32,0,32,0,32,1,64,0,128,0,0,0,0 },
  { 0,0,0,0,0,0,127,128,0,128,0,128,0,128,0,128,0,128,0,128,0,64,0,62,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,63,128,0,128,0,128,0,128,0,128,0,240,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,0 },
  { 0,0,8,0,8,0,8,0,8,0,4,0,4,0,2,0,2,0,1,0,1,0,0,128,0,64,0,32,0,28,0,8 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0 },
  { 0,0,0,0,0,32,0,32,0,64,0,64,0,128,1,0,2,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,64,0,64,0,64,0,64,0,64,0,64,0,64,0,128,0,128,1,0,1,0,2,0,4,0,8,0,0,0 },
  { 0,0,0,0,0,0,0,0,4,0,2,0,1,0,0,128,0,64,0,64,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,31,248,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,0,0,0 },
  { 0,0,0,0,0,0,127,252,0,8,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,0,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,31,252,0,0,0,0 },
  { 0,0,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,63,240,0,16,0,0,0,0 },
  { 0,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,32,4,64,4,128,5,0,6,0,4,0,0,0,0,0 },
  { 0,0,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,0,128,2,128,1,0,0,0 },
  { 0,0,0,64,0,64,0,128,0,128,1,0,2,0,4,0,2,0,1,0,0,128,0,64,0,32,0,0,0,0,0,0 },
  { 0,0,0,64,0,64,0,128,0,128,1,0,1,0,2,0,4,0,8,0,31,248,0,0,0,0,0,0,0,0,0,0 },
  { 0,0,8,0,8,0,20,0,36,0,2,0,2,0,1,0,1,0,0,128,0,64,0,32,0,16,0,14,0,4,0,0 },
  { 0,0,32,0,32,0,32,0,32,0,32,0,32,0,63,248,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,0 },
  { 0,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,8,8,8,8,8,7,248,0,0 },
  { 0,0,127,240,0,32,0,64,0,128,1,0,2,0,4,0,8,0,16,0,32,0,64,4,64,4,64,6,63,252,0,0 },
  { 0,0,0,0,63,248,0,16,0,16,0,32,0,124,0,4,0,4,0,4,0,4,0,4,0,8,0,40,0,16,0,0 },
  { 0,0,0,0,0,16,0,16,0,32,0,32,0,64,0,64,0,128,0,128,1,0,1,0,34,0,36,0,56,0,0,0 },
  { 0,0,0,0,0,0,31,240,32,8,64,4,64,4,64,4,64,4,64,4,32,8,31,240,0,0,0,0,0,0,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,97,182,111,182,99,134,111,246,97,246,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,97,134,111,190,99,134,111,246,97,134,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,97,206,111,190,99,142,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,97,134,111,246,99,238,111,222,97,222,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,97,206,111,182,99,206,111,182,97,206,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,97,206,111,182,99,198,111,246,97,206,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,97,134,111,182,99,134,111,182,97,182,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,97,142,111,182,99,142,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,97,198,111,190,99,190,111,190,97,198,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,97,142,111,182,99,182,111,182,97,142,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,97,134,111,190,99,142,111,190,97,134,127,254,0,0 },
  { 0,0,127,254,99,238,125,206,113,238,125,238,99,198,127,254,127,254,97,134,111,190,99,142,111,190,97,190,127,254,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,64,0,46,0,50,0,36,0,68,0,8,0,16,0,32,0,64,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,16,0,0,0,97,0,18,0,4,0,72,0,48,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,0,114,0,4,0,4,0,8,0,20,0,34,0,194,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,32,0,32,0,32,0,48,0,40,0,36,0,32,0,32,0,32,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,0,114,0,4,0,52,0,8,0,20,0,34,0,194,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,128,2,64,2,32,4,32,8,16,16,16,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,64,0,64,0,64,0,78,0,112,0,64,0,64,0,64,0,62,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,142,0,114,0,4,0,4,0,8,0,16,0,32,0,192,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,5,0,8,192,0,48,0,0,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,32,0,16,0,30,0,240,0,16,0,84,0,146,0,16,0,80,0,48,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,0,1,0,1,0,1,0,2,0,2,32,20,208,15,8,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,140,0,112,0,0,0,142,0,114,0,2,0,4,0,8,0,112,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,0,68,0,68,0,68,0,4,0,4,0,8,0,48,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,2,64,1,32,1,32,1,32,1,32,1,36,2,36,4,40,8,48,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,64,0,64,0,64,0,68,0,72,0,80,0,96,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,0,240,31,16,16,16,16,16,16,32,16,32,17,240,30,0,0,0,0,0 },
  { 0,0,24,24,32,4,64,2,79,242,64,18,64,18,64,18,64,18,64,18,64,18,64,18,64,2,32,4,24,24,0,0 },
  { 0,0,24,24,32,4,64,2,68,2,68,2,68,2,68,2,68,2,68,2,71,250,64,2,64,2,32,4,24,24,0,0 },
  { 0,0,24,24,32,4,64,2,64,2,79,242,72,2,72,2,72,2,72,2,72,2,79,242,64,2,32,4,24,24,0,0 },
  { 0,0,24,24,32,4,64,2,79,242,64,18,64,18,79,242,72,2,72,2,72,2,79,250,64,2,32,4,24,24,0,0 },
  { 0,0,24,24,32,4,64,2,64,2,79,242,72,18,72,18,72,18,72,18,79,242,64,2,64,2,32,4,24,24,0,0 },
  { 0,0,24,24,32,4,64,2,72,18,72,18,72,18,79,242,72,18,72,18,72,18,79,242,64,2,32,4,24,24,0,0 },
  { 0,0,24,24,32,4,64,130,64,130,64,130,65,66,65,66,66,34,68,18,72,10,64,2,64,2,32,4,24,24,0,0 },
  { 0,0,24,24,32,4,64,2,67,194,68,34,72,18,72,18,72,18,72,18,68,34,67,194,64,2,32,4,24,24,0,0 },
  { 0,0,24,24,32,4,64,2,95,242,65,2,65,2,66,130,66,130,68,66,72,34,80,18,64,2,32,4,24,24,0,0 },
  { 0,0,24,24,32,4,67,226,64,2,64,2,79,250,64,130,65,66,66,34,68,18,72,10,64,2,32,4,24,24,0,0 },
  { 0,0,24,24,32,4,64,2,79,242,64,18,64,18,95,242,64,18,64,18,64,18,64,18,64,18,32,4,24,24,0,0 },
  { 0,0,24,24,32,4,64,2,79,242,72,2,72,2,79,242,72,2,72,2,72,2,79,242,64,2,32,4,24,24,0,0 },
  { 0,0,24,24,32,4,64,2,64,2,79,242,64,2,68,34,68,34,66,66,66,66,95,250,64,2,32,4,24,24,0,0 },
  { 0,0,24,24,32,4,64,2,67,194,64,2,95,250,64,2,67,194,68,34,68,34,68,34,67,194,32,4,24,24,0,0 },
  { 0,0,24,24,32,36,64,34,95,162,64,162,65,62,66,34,68,34,72,34,80,34,96,34,64,34,32,36,24,24,0,0 },
  { 0,0,24,24,32,36,64,34,80,34,80,34,80,34,80,62,80,34,95,226,64,34,64,34,64,34,32,36,24,24,0,0 },
  { 0,0,24,24,32,36,64,34,95,162,80,34,80,34,80,62,80,34,95,162,64,34,64,34,64,34,32,36,24,24,0,0 },
  { 0,0,24,24,32,36,64,34,95,162,64,162,64,162,95,190,80,34,80,34,95,162,64,34,64,34,32,36,24,24,0,0 },
  { 0,0,24,24,32,36,64,34,64,34,95,34,81,34,81,62,81,34,95,34,64,34,64,34,64,34,32,36,24,24,0,0 },
  { 0,0,24,24,32,36,64,34,81,34,81,34,95,34,81,62,81,34,95,34,64,34,64,34,64,34,32,36,24,24,0,0 },
  { 0,0,24,24,32,36,64,34,68,34,68,34,74,34,74,62,81,34,96,162,64,34,64,34,64,34,32,36,24,24,0,0 },
  { 0,0,24,24,32,36,64,34,78,34,81,34,81,34,81,62,81,34,81,34,78,34,64,34,64,34,32,36,24,24,0,0 },
  { 0,0,24,24,32,36,64,34,95,226,66,34,66,34,69,62,69,34,72,162,80,98,64,34,64,34,32,36,24,24,0,0 },
  { 0,0,24,24,32,36,71,34,64,34,95,226,66,34,66,62,69,34,72,162,80,98,64,34,64,34,32,36,24,24,0,0 },
  { 0,0,24,24,32,36,64,34,95,162,64,162,127,34,66,62,68,34,72,34,80,34,96,34,64,34,32,36,24,24,0,0 },
  { 0,0,24,24,32,36,64,34,95,162,80,34,95,162,80,62,80,34,95,162,64,34,96,34,64,34,32,36,24,24,0,0 },
  { 0,0,24,24,32,36,64,34,95,162,64,34,80,162,73,62,73,34,75,226,124,34,64,34,64,34,32,36,24,24,0,0 },
  { 0,0,24,24,32,36,79,34,64,34,127,226,64,34,79,62,80,162,80,162,79,34,96,34,64,34,32,36,24,24,0,0 },
  { 0,0,48,24,64,4,159,242,129,2,130,130,140,98,176,26,128,2,191,250,129,2,129,2,129,2,65,4,49,24,0,0 },
  { 0,0,48,24,64,4,153,234,164,74,164,218,165,42,153,42,128,10,136,130,136,130,190,250,128,2,64,4,48,24,0,0 },
  { 48,24,64,4,128,98,153,250,164,98,164,146,164,146,152,98,128,2,136,250,136,34,190,34,128,34,64,4,48,24,0,0 },
  { 0,0,127,254,99,134,125,246,113,134,125,190,99,134,127,254,127,254,123,134,115,190,123,142,123,190,113,190,127,254,0,0 },
  { 0,0,32,8,64,4,128,2,128,2,128,2,128,18,191,250,128,2,128,2,128,2,128,2,128,2,64,4,32,8,0,0 },
  { 0,0,32,8,64,4,128,34,159,242,128,2,128,2,128,2,128,2,128,18,191,250,128,2,128,2,64,4,32,8,0,0 },
  { 0,0,32,8,64,36,159,242,128,2,128,2,128,66,143,226,128,2,128,2,128,18,191,250,128,2,64,4,32,8,0,0 },
  { 0,0,32,8,64,4,128,2,191,250,164,74,164,74,164,74,164,74,164,74,191,250,128,2,128,2,64,4,32,8,0,0 },
  { 0,0,32,8,64,36,159,242,130,2,130,2,130,34,159,242,132,34,132,34,132,34,132,34,191,250,64,4,32,8,0,0 },
  { 0,0,32,8,64,4,130,2,129,2,128,18,191,250,128,2,128,2,132,66,132,34,136,18,144,18,64,4,32,8,0,0 },
  { 0,0,32,8,66,4,130,2,130,2,130,18,130,122,131,130,190,2,130,2,130,2,130,34,130,34,65,228,32,8,0,0 },
  { 0,0,32,8,64,132,132,130,132,130,132,130,132,130,132,130,136,66,136,34,144,26,160,18,128,2,64,4,32,8,0,0 },
  { 0,0,32,8,66,4,130,2,130,66,159,226,130,66,130,66,130,66,132,66,132,74,136,74,144,58,64,4,32,8,0,0 },
  { 0,0,32,8,65,4,129,2,129,2,129,18,191,250,129,2,129,2,129,2,129,2,129,2,129,2,64,4,32,8,0,0 },
  { 0,0,48,24,71,244,132,18,132,18,135,242,132,18,132,18,135,242,132,18,132,18,136,82,144,34,64,4,48,24,0,0 },
  { 0,0,48,24,65,4,129,2,137,18,137,34,137,66,145,2,130,130,130,130,132,66,136,34,176,26,64,4,48,24,0,0 },
  { 0,0,48,24,65,4,129,2,129,18,189,162,133,66,133,66,137,34,137,34,145,18,165,10,130,2,64,4,48,24,0,0 },
  { 0,0,48,24,65,4,129,2,129,2,191,250,129,2,131,130,133,66,137,34,177,26,129,18,129,2,64,4,48,24,0,0 },
  { 0,0,48,24,65,4,130,130,132,66,136,34,183,218,129,2,159,242,129,2,137,34,133,66,191,250,64,4,48,24,0,0 },
  { 0,0,48,24,65,4,129,2,129,2,129,2,159,242,129,2,129,2,129,2,129,2,129,2,191,250,64,4,48,24,0,0 },
  { 0,0,48,24,64,4,143,226,136,34,136,34,136,34,143,226,136,34,136,34,136,34,143,226,136,34,64,4,48,24,0,0 },
  { 0,0,48,24,72,68,137,66,189,242,138,66,156,66,155,250,168,66,168,226,137,82,138,74,136,66,64,4,48,24,0,0 },
  { 0,0,48,24,66,4,191,250,132,2,135,226,140,34,151,226,164,34,135,226,132,34,132,34,132,98,64,4,48,24,0,0 },
  { 0,0,48,24,80,68,136,66,190,66,132,66,137,242,140,66,154,66,168,66,136,66,136,66,139,250,64,4,48,24,0,0 },
  { 0,0,48,24,68,4,135,242,132,34,138,66,145,130,129,2,135,242,188,18,132,18,132,18,135,242,64,4,48,24,0,0 },
  { 0,0,48,24,72,68,169,242,188,66,168,66,171,250,140,34,155,250,169,34,136,162,136,34,136,226,64,4,48,24,0,0 },
  { 0,0,48,24,64,20,158,18,147,250,158,18,146,50,158,82,146,146,159,18,128,18,146,82,161,34,64,4,48,24,0,0 },
  { 0,0,48,24,81,244,137,18,191,18,131,18,133,242,140,162,154,162,170,162,136,170,137,42,138,26,64,4,48,24,0,0 },
  { 0,0,48,24,82,20,137,18,137,34,159,250,145,10,161,2,159,242,129,18,130,18,132,18,152,98,64,4,48,24,0,0 },
  { 0,0,48,24,68,164,132,146,136,130,136,250,155,130,168,130,136,130,136,66,136,74,136,42,136,26,64,4,48,24,0,0 },
  { 0,0,48,24,64,52,187,194,168,74,170,74,169,82,175,250,184,66,168,66,128,66,128,66,129,194,64,4,48,24,0,0 },
  { 0,0,48,24,73,20,132,162,159,250,144,10,135,226,128,66,128,130,159,250,128,130,128,130,131,130,64,4,48,24,0,0 },
  { 0,0,48,24,95,36,148,34,159,58,145,66,159,82,148,10,159,130,128,2,159,242,146,146,191,250,64,4,48,24,0,0 },
  { 0,0,48,24,65,4,129,130,130,66,132,34,136,154,176,130,132,226,132,130,132,130,132,130,159,250,64,4,48,24,0,0 },
  { 0,0,48,24,81,4,139,250,132,74,159,226,140,58,135,226,132,34,135,226,132,34,135,226,156,58,64,4,48,24,0,0 },
  { 0,0,48,24,72,132,137,242,136,146,190,146,137,34,137,34,143,250,138,170,138,170,140,202,137,18,64,4,48,24,0,0 },
  { 0,0,48,24,72,252,143,146,146,162,170,66,148,34,139,210,144,10,175,242,132,162,138,146,177,10,64,4,48,24,0,0 },
  { 0,0,48,24,68,68,132,66,136,66,143,250,152,66,168,226,136,226,137,82,138,74,140,66,136,66,64,4,48,24,0,0 },
  { 0,0,48,24,66,4,132,2,143,226,136,34,136,34,143,226,136,34,143,226,136,34,136,34,143,226,64,4,48,24,0,0 },
  { 0,0,48,24,95,244,130,2,132,66,136,34,159,242,129,2,129,2,143,226,129,2,129,2,191,242,64,4,48,24,0,0 },
  { 0,0,63,248,64,4,190,250,162,138,190,250,162,138,190,250,160,10,167,202,164,74,164,74,167,202,160,26,64,4,63,248 },
  { 0,0,63,248,64,4,132,66,132,66,136,66,147,250,190,74,132,74,136,74,146,74,189,74,144,170,129,18,64,4,63,248 },
  { 0,0,63,248,64,4,130,2,129,2,191,250,132,66,132,66,132,66,130,130,130,130,129,2,134,194,184,58,64,4,63,248 },
  { 0,0,63,248,64,4,158,242,165,34,159,226,137,66,159,226,129,34,191,250,129,34,159,226,129,2,131,2,64,4,63,248 },
  { 0,0,252,126,224,14,192,6,136,114,152,138,8,136,8,136,8,136,136,138,136,138,190,114,192,6,224,14,252,126,0,0 },
  { 0,0,252,126,224,14,192,6,156,114,162,138,2,136,2,136,28,136,160,138,160,138,190,114,192,6,224,14,252,126,0,0 },
  { 0,0,252,126,224,14,192,6,156,114,162,138,2,136,12,136,2,136,130,138,162,138,156,114,192,6,224,14,252,126,0,0 },
  { 0,0,252,126,224,14,192,6,164,114,164,138,36,136,62,136,4,136,132,138,132,138,132,114,192,6,224,14,252,126,0,0 },
  { 0,0,252,126,224,14,192,6,190,114,160,138,32,136,28,136,2,136,130,138,162,138,156,114,192,6,224,14,252,126,0,0 },
  { 0,0,252,126,224,14,192,6,156,114,162,138,32,136,60,136,34,136,162,138,162,138,156,114,192,6,224,14,252,126,0,0 },
  { 0,0,252,126,224,14,192,6,190,114,162,138,2,136,4,136,4,136,136,138,136,138,136,114,192,6,224,14,252,126,0,0 },
  { 0,0,252,126,224,14,192,6,156,114,162,138,34,136,28,136,34,136,162,138,162,138,156,114,192,6,224,14,252,126,0,0 },
  { 0,0,0,0,0,0,0,0,119,222,73,16,73,16,73,16,113,30,65,16,65,16,65,16,65,16,65,30,0,0,0,0 },
  { 0,0,31,240,32,8,64,4,156,34,162,98,130,34,130,34,156,34,160,34,160,34,190,250,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,114,162,138,130,10,130,10,156,114,160,130,160,130,190,250,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,114,162,138,130,10,130,50,156,10,160,10,160,138,190,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,146,162,146,130,146,130,250,156,18,160,18,160,18,190,18,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,250,162,130,130,130,130,114,156,10,160,10,160,138,190,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,114,162,138,130,130,130,242,156,138,160,138,160,138,190,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,250,162,138,130,10,130,18,156,18,160,34,160,34,190,34,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,114,162,138,130,138,130,114,156,138,160,138,160,138,190,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,114,162,138,130,138,130,138,156,122,160,10,160,138,190,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,114,162,138,130,138,140,138,130,138,130,138,162,138,156,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,34,162,98,130,34,140,34,130,34,130,34,162,34,156,250,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,114,162,138,130,10,140,10,130,114,130,130,162,130,156,250,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,114,162,138,130,10,140,50,130,10,130,10,162,138,156,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,146,162,146,130,146,140,250,130,18,130,18,162,18,156,18,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,250,162,130,130,130,140,114,130,10,130,10,162,138,156,114,64,4,32,8,31,240,0,0 },
  { 0,0,15,240,16,8,32,4,64,2,95,242,64,18,64,18,64,18,64,18,64,18,64,18,32,4,16,8,15,240,0,0 },
  { 0,0,15,240,16,8,32,4,64,2,72,2,72,2,72,2,72,2,72,2,72,2,79,242,32,4,16,8,15,240,0,0 },
  { 0,0,15,240,16,8,32,4,79,242,72,2,72,2,72,2,72,2,72,2,79,242,64,2,32,4,16,8,15,240,0,0 },
  { 0,0,15,240,16,8,32,4,79,242,64,18,64,18,79,242,72,2,72,2,72,2,79,250,32,4,16,8,15,240,0,0 },
  { 0,0,15,240,16,8,32,4,79,242,72,18,72,18,72,18,72,18,72,18,79,242,64,2,32,4,16,8,15,240,0,0 },
  { 0,0,15,240,16,8,32,4,72,18,72,18,72,18,79,242,72,18,72,18,72,18,79,242,32,4,16,8,15,240,0,0 },
  { 0,0,15,240,16,8,32,132,64,130,64,130,65,66,65,66,66,34,66,34,68,18,72,10,32,4,16,8,15,240,0,0 },
  { 0,0,15,240,16,8,32,4,67,194,68,34,72,18,72,18,72,18,72,18,68,34,67,194,32,4,16,8,15,240,0,0 },
  { 0,0,15,240,16,8,32,4,64,2,79,250,64,130,64,130,65,66,66,34,68,18,72,10,32,4,16,8,15,240,0,0 },
  { 0,0,15,240,16,8,32,4,67,226,64,2,79,250,64,130,65,66,66,34,68,18,72,10,32,4,16,8,15,240,0,0 },
  { 0,0,15,240,16,8,32,4,79,242,64,18,64,18,95,242,64,18,64,18,64,18,64,18,32,4,16,8,15,240,0,0 },
  { 0,0,15,240,16,8,32,4,79,226,72,2,72,2,79,226,72,2,72,2,72,2,79,242,32,4,16,8,15,240,0,0 },
  { 0,0,15,240,16,8,32,4,64,2,79,242,64,2,68,34,66,34,66,66,66,66,95,250,32,4,16,8,15,240,0,0 },
  { 0,0,15,240,16,8,32,4,71,226,64,2,95,250,64,2,67,194,68,34,68,34,67,194,32,4,16,8,15,240,0,0 },
  { 0,0,15,240,16,40,32,36,95,162,64,162,65,62,65,34,66,34,68,34,72,34,80,34,32,36,16,40,15,240,0,0 },
  { 0,0,15,240,16,40,32,36,80,34,80,34,80,34,80,62,80,34,95,226,64,34,64,34,32,36,16,40,15,240,0,0 },
  { 0,0,15,240,16,40,32,36,95,162,80,34,80,34,80,62,80,34,95,162,64,34,64,34,32,36,16,40,15,240,0,0 },
  { 0,0,15,240,16,40,32,36,95,162,64,162,64,162,95,190,80,34,80,34,95,162,64,34,32,36,16,40,15,240,0,0 },
  { 0,0,15,240,16,40,32,36,64,34,95,34,81,34,81,62,81,34,81,34,95,34,64,34,32,36,16,40,15,240,0,0 },
  { 0,0,15,240,16,40,32,36,81,34,81,34,95,34,81,62,81,34,81,34,95,34,64,34,32,36,16,40,15,240,0,0 },
  { 0,0,15,240,16,40,34,36,66,34,68,34,70,34,73,62,80,162,96,34,64,34,64,34,32,36,16,40,15,240,0,0 },
  { 0,0,15,240,16,40,32,36,78,34,81,34,81,34,81,62,81,34,81,34,78,34,64,34,32,36,16,40,15,240,0,0 },
  { 0,0,15,240,16,40,32,36,95,226,66,34,66,34,69,62,72,162,80,98,96,34,64,34,32,36,16,40,15,240,0,0 },
  { 0,0,15,240,16,40,39,164,64,34,95,226,66,34,69,62,72,162,80,98,96,34,64,34,32,36,16,40,15,240,0,0 },
  { 0,0,15,240,16,40,32,36,95,162,64,162,65,34,94,62,68,34,72,34,80,34,96,34,32,36,16,40,15,240,0,0 },
  { 0,0,15,240,16,40,32,36,95,162,80,34,95,162,80,62,80,34,95,162,64,34,96,34,32,36,16,40,15,240,0,0 },
  { 0,0,15,240,16,40,32,36,95,162,64,34,80,162,73,62,73,34,75,226,124,34,64,34,32,36,16,40,15,240,0,0 },
  { 0,0,15,240,16,40,47,36,64,34,127,226,64,34,79,62,80,162,80,162,79,34,64,34,32,36,16,40,15,240,0,0 },
  { 0,0,15,240,16,8,46,132,64,186,94,138,68,234,74,138,81,170,64,170,94,34,82,34,62,252,16,8,15,240,0,0 },
  { 0,0,15,240,16,8,63,108,66,154,68,154,74,154,81,106,64,10,127,138,68,10,68,250,32,12,16,8,15,240,0,0 },
  { 0,0,15,224,16,16,35,136,68,68,68,68,68,68,67,132,64,4,79,228,65,4,65,4,33,8,16,16,15,224,0,0 },
  { 0,0,31,240,32,8,94,244,140,66,140,128,237,14,14,2,13,2,140,130,140,66,94,244,32,8,31,240,0,0,0,0 },
  { 0,0,31,240,32,8,64,4,128,2,128,2,128,18,191,250,128,2,128,2,128,2,128,2,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,36,159,242,128,2,128,2,128,2,128,2,128,18,191,250,128,2,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,36,159,242,128,2,128,66,143,226,128,2,128,18,191,250,128,2,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,95,244,146,146,146,146,146,146,146,146,148,242,152,18,144,18,159,242,80,20,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,159,242,129,2,129,2,143,226,130,34,130,34,130,34,130,34,127,252,32,8,31,240,0,0 },
  { 0,0,31,240,34,8,65,4,128,2,191,250,128,2,132,66,132,34,136,18,144,10,160,10,64,4,32,8,31,240,0,0 },
  { 0,0,15,240,16,8,34,4,66,2,66,50,67,194,94,2,66,2,66,2,66,18,66,18,33,244,16,8,15,240,0,0 },
  { 0,0,31,240,32,8,64,132,132,130,132,130,132,66,132,66,136,34,136,34,144,18,160,10,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,34,8,66,4,130,2,159,194,130,66,130,66,130,66,132,66,132,74,136,74,80,60,32,8,31,240,0,0 },
  { 0,0,15,224,16,16,33,8,65,4,65,4,95,244,65,4,65,4,65,4,65,4,65,4,32,8,16,16,15,224,0,0 },
  { 0,0,31,240,32,8,71,244,132,18,132,18,135,242,132,18,132,18,135,242,132,18,132,18,72,84,48,40,31,240,0,0 },
  { 0,0,31,240,32,8,65,4,137,18,137,34,137,66,145,2,130,130,130,130,132,66,136,34,112,28,32,8,31,240,0,0 },
  { 0,0,31,240,33,8,65,4,129,18,189,162,133,66,133,66,137,34,137,34,145,18,165,10,66,4,32,8,31,240,0,0 },
  { 0,0,31,240,33,8,65,4,129,2,191,250,129,2,131,130,133,66,137,34,177,26,129,18,65,4,32,8,31,240,0,0 },
  { 0,0,31,240,33,8,66,132,132,66,136,34,183,218,129,2,159,242,129,2,137,34,133,66,127,252,32,8,31,240,0,0 },
  { 0,0,31,240,33,8,65,4,129,2,129,2,159,242,129,2,129,2,129,2,129,2,129,2,127,252,32,8,31,240,0,0 },
  { 0,0,7,240,8,8,23,244,36,18,36,18,36,18,39,242,36,18,36,18,36,18,39,242,20,20,8,8,7,240,0,0 },
  { 0,0,31,240,40,72,73,68,189,242,138,66,156,66,155,250,168,66,168,226,137,82,138,74,72,68,32,8,31,240,0,0 },
  { 0,0,31,240,34,8,127,252,132,2,135,226,140,34,151,226,164,34,135,226,132,34,132,34,68,100,32,8,31,240,0,0 },
  { 0,0,31,240,48,72,72,68,190,66,132,66,137,242,140,66,154,66,168,66,136,66,136,66,75,252,32,8,31,240,0,0 },
  { 0,0,31,240,36,8,71,244,132,34,138,66,145,130,129,2,135,242,188,18,132,18,132,18,71,244,32,8,31,240,0,0 },
  { 0,0,31,240,40,72,105,244,188,66,168,66,171,250,140,34,155,250,169,34,136,162,136,34,72,228,32,8,31,240,0,0 },
  { 0,0,31,240,32,24,94,20,147,250,158,18,146,50,158,82,146,146,159,18,128,18,146,82,97,36,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,81,244,137,18,191,18,131,18,133,242,140,162,154,162,170,170,137,42,74,28,32,8,31,240,0,0 },
  { 0,0,31,240,50,24,73,20,137,34,159,250,145,10,161,2,159,242,129,18,130,18,132,18,88,100,32,8,31,240,0,0 },
  { 0,0,31,240,36,136,120,84,136,146,190,146,136,162,141,162,154,170,170,202,136,146,137,146,78,116,32,8,31,240,0,0 },
  { 0,0,15,240,16,8,63,252,73,18,79,242,73,18,79,242,65,2,95,250,65,10,66,10,36,76,24,56,15,240,0,0 },
  { 0,0,31,240,34,8,66,4,130,2,191,250,132,66,132,66,136,66,142,130,129,130,130,98,92,20,32,8,31,240,0,0 },
  { 0,0,31,240,48,72,75,252,136,162,131,250,186,74,139,250,138,170,138,234,138,26,148,2,99,252,32,8,31,240,0,0 },
  { 0,0,31,240,43,248,73,20,137,242,137,18,155,250,172,138,139,82,141,234,137,34,136,194,79,60,32,8,31,240,0,0 },
  { 0,0,15,240,18,8,60,252,80,138,80,138,94,138,80,138,80,138,82,138,92,178,80,130,32,132,16,8,15,240,0,0 },
  { 0,0,31,240,48,136,72,68,163,250,148,66,132,66,136,66,137,242,176,66,144,66,144,66,83,252,32,8,31,240,0,0 },
  { 0,0,31,248,32,4,65,250,190,65,137,249,137,9,137,249,137,9,143,249,177,9,129,249,64,146,35,12,31,248,0,0 },
  { 0,0,31,240,36,72,68,68,136,66,143,250,152,66,168,226,136,226,137,82,138,74,140,66,72,68,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,95,252,144,10,164,18,135,226,132,2,135,242,128,18,159,210,128,18,64,164,32,72,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,128,2,159,242,129,2,129,2,137,226,137,2,137,2,159,242,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,33,8,65,4,129,2,129,2,129,242,129,2,129,2,129,2,129,2,129,2,127,252,32,8,31,240,0,0 },
  { 0,0,7,240,8,136,16,132,47,250,40,138,40,138,40,138,47,250,40,138,32,130,32,130,16,132,8,8,7,240,0,0 },
  { 0,0,31,240,32,8,127,252,129,2,129,2,129,130,129,66,129,34,129,34,129,2,129,2,65,4,32,8,31,240,0,0 },
  { 0,0,31,240,34,8,66,4,191,250,130,2,132,2,135,242,136,130,136,130,144,130,160,130,79,252,32,8,31,240,0,0 },
  { 0,0,31,240,33,8,65,4,191,250,130,2,132,2,135,226,140,34,148,34,164,34,135,226,68,36,32,8,31,240,0,0 },
  { 0,0,15,240,16,8,63,252,82,2,83,242,84,130,95,250,80,130,81,66,82,34,84,18,63,252,16,8,15,240,0,0 },
  { 0,0,31,240,32,8,64,132,159,250,144,10,167,226,128,2,159,250,128,130,136,162,136,146,82,148,33,8,31,240,0,0 },
  { 0,0,15,240,25,24,36,164,95,250,80,10,71,226,64,66,64,130,95,250,64,130,64,130,35,132,16,8,15,240,0,0 },
  { 0,0,31,240,62,72,104,68,190,122,162,130,190,162,168,18,191,2,128,2,159,242,146,146,127,252,32,8,31,240,0,0 },
  { 0,0,31,240,33,8,65,132,130,66,132,34,136,154,176,130,132,226,132,130,132,130,132,130,95,252,32,8,31,240,0,0 },
  { 0,0,15,240,17,8,43,252,68,74,95,226,76,58,71,226,68,34,71,226,68,34,71,226,60,60,16,8,15,240,0,0 },
  { 0,0,15,240,24,136,41,244,72,146,126,146,73,34,73,34,79,250,74,170,74,170,76,202,41,20,16,8,15,240,0,0 },
  { 0,0,31,240,33,8,127,252,132,130,132,242,137,146,154,82,173,34,136,162,136,66,136,162,75,28,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,114,162,138,130,130,140,242,130,138,130,138,162,138,156,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,250,162,138,130,10,140,18,130,18,130,34,162,34,156,34,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,114,162,138,130,138,140,114,130,138,130,138,162,138,156,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,156,114,162,138,130,138,140,138,130,122,130,10,162,138,156,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,164,114,164,138,164,138,190,138,132,138,132,138,132,138,132,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,164,34,164,98,164,34,190,34,132,34,132,34,132,34,132,250,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,164,114,164,138,164,10,190,10,132,114,132,130,132,130,132,250,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,164,114,164,138,164,10,190,50,132,10,132,10,132,138,132,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,164,146,164,146,164,146,190,250,132,18,132,18,132,18,132,18,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,164,250,164,130,164,130,190,114,132,10,132,10,132,138,132,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,164,114,164,138,164,130,190,242,132,138,132,138,132,138,132,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,164,250,164,138,164,10,190,18,132,18,132,34,132,34,132,34,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,164,114,164,138,164,138,190,114,132,138,132,138,132,138,132,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,164,114,164,138,164,138,190,138,132,122,132,10,132,138,132,114,64,4,32,8,31,240,0,0 },
  { 0,0,31,240,32,8,64,4,190,114,160,138,160,138,156,138,130,138,130,138,162,138,156,114,64,4,32,8,31,240,0,0 },
  { 0,0,16,124,48,68,16,68,16,68,16,124,16,68,16,68,16,68,16,124,16,68,16,68,16,68,16,68,124,148,0,136 },
  { 0,0,0,124,24,68,36,68,36,68,4,124,4,68,8,68,8,68,8,124,16,68,16,68,16,68,32,68,32,148,60,136 },
  { 0,0,0,124,24,68,36,68,36,68,4,124,4,68,4,68,24,68,4,124,4,68,4,68,4,68,36,68,36,148,24,136 },
  { 0,0,0,124,36,68,36,68,36,68,36,124,36,68,36,68,60,68,4,124,4,68,4,68,4,68,4,68,4,148,4,136 },
  { 0,0,0,124,60,68,32,68,32,68,32,124,32,68,32,68,56,68,4,124,4,68,4,68,4,68,36,68,36,148,24,136 },
  { 0,0,0,124,24,68,36,68,36,68,32,124,32,68,32,68,56,68,36,124,36,68,36,68,36,68,36,68,36,148,24,136 },
  { 0,0,0,124,60,68,4,68,4,68,4,124,8,68,8,68,8,68,16,124,16,68,16,68,16,68,16,68,16,148,16,136 },
  { 0,0,0,124,24,68,36,68,36,68,36,124,36,68,36,68,24,68,36,124,36,68,36,68,36,68,36,68,36,148,24,136 },
  { 0,0,0,124,24,68,36,68,36,68,36,124,36,68,36,68,24,68,4,124,4,68,4,68,4,68,36,68,36,148,24,136 },
  { 0,0,0,62,35,34,100,162,36,162,36,190,36,162,36,162,36,162,36,190,36,162,36,162,36,162,36,162,36,202,115,68 },
  { 0,0,0,62,34,34,102,34,34,34,34,62,34,34,34,34,34,34,34,62,34,34,34,34,34,34,34,34,34,74,119,68 },
  { 0,0,0,62,35,34,100,162,36,162,32,190,32,162,33,34,33,34,33,62,34,34,34,34,34,34,36,34,36,74,119,196 },
  { 0,0,0,0,0,0,0,0,66,0,66,4,66,116,66,136,126,136,66,136,66,112,66,64,66,120,66,132,0,132,0,120 },
  { 0,0,0,0,0,0,0,0,0,0,0,2,101,26,150,164,148,164,244,36,132,24,132,16,148,28,100,34,0,34,0,28 },
  { 0,0,0,0,0,0,0,0,0,130,0,130,60,130,66,68,66,68,126,68,64,40,64,40,66,16,60,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,79,184,66,36,66,34,66,34,66,34,66,34,66,34,66,34,66,36,122,56,0,0,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,47,232,64,36,65,68,65,132,65,4,34,8,36,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,72,32,136,65,4,67,4,69,4,73,4,33,8,33,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,17,16,33,8,47,232,72,36,72,36,64,36,64,68,32,72,32,136,17,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,32,8,71,196,65,4,65,4,65,4,47,232,32,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,136,47,232,65,132,66,132,68,132,72,132,34,136,33,136,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,17,16,33,8,47,232,65,36,66,36,68,68,72,68,34,136,33,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,34,8,35,200,79,4,65,4,65,244,79,196,32,72,32,72,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,34,8,35,232,66,36,68,36,72,68,64,68,32,136,35,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,36,8,39,232,68,132,72,132,80,132,64,132,33,8,38,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,47,232,64,36,64,36,64,68,64,68,47,232,32,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,34,72,34,72,79,244,66,68,66,68,66,68,32,136,35,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,38,8,33,8,76,4,66,36,64,68,64,132,41,8,38,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,47,200,64,68,64,68,64,132,65,132,34,72,36,72,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,34,8,47,232,66,36,66,68,66,132,66,4,34,8,33,232,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,40,40,68,36,68,36,64,68,64,132,33,8,38,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,34,8,35,232,66,36,70,36,69,68,72,196,32,168,35,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,232,47,136,64,244,95,132,64,132,64,132,33,8,38,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,34,8,41,40,69,36,68,36,64,68,64,132,33,8,38,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,39,200,32,8,79,228,64,132,64,132,64,132,33,8,38,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,34,8,34,8,66,4,67,4,66,132,66,68,34,8,34,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,17,16,32,136,47,232,64,132,64,132,64,132,64,132,33,8,38,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,33,232,78,4,64,4,64,244,79,4,32,8,32,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,47,200,64,68,70,68,65,132,65,132,34,72,36,72,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,47,200,64,68,64,132,65,4,67,68,37,40,33,8,17,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,32,40,64,36,64,36,64,68,64,132,33,8,38,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,34,136,66,68,68,36,88,36,64,4,32,8,32,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,40,8,73,132,78,4,72,4,72,4,40,8,39,200,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,47,232,64,36,64,36,64,36,64,68,32,72,32,136,17,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,34,8,69,4,72,132,64,68,64,36,32,8,32,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,17,16,33,8,47,232,65,4,69,68,73,36,65,36,37,8,35,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,47,232,64,36,67,68,64,132,64,68,32,72,32,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,35,8,32,200,70,4,65,132,64,4,70,4,33,200,32,24,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,17,16,33,8,33,8,66,4,66,4,68,68,68,36,39,232,40,40,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,32,40,64,36,66,36,65,68,64,196,32,168,35,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,47,200,34,8,67,196,94,4,66,4,66,4,34,8,33,232,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,18,16,34,8,47,232,66,36,65,68,65,4,65,4,32,136,32,136,16,144,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,32,8,71,228,64,36,64,68,64,132,47,232,32,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,39,232,64,36,71,228,64,36,64,36,39,232,32,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,39,200,32,8,79,228,64,36,64,36,64,68,32,72,32,136,19,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,34,72,34,72,66,68,66,68,66,68,64,68,32,136,35,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,33,8,37,8,69,4,69,20,69,36,69,68,37,136,41,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,36,8,36,8,68,4,68,36,68,68,68,132,37,8,38,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,40,232,79,36,72,36,72,68,73,228,46,8,40,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,47,232,72,36,72,36,64,36,64,68,32,72,32,136,17,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,144,32,136,47,232,68,132,68,132,95,228,64,132,32,136,32,136,16,144,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,47,232,64,36,67,68,64,132,64,68,63,248,32,8,16,16,12,96,3,128,0,0 },
  { 0,0,3,128,12,96,16,16,32,8,47,232,64,36,71,228,64,36,64,68,32,136,35,8,16,16,12,96,3,128,0,0 },
  { 0,0,127,254,99,134,125,246,113,134,125,190,99,134,127,254,127,254,97,134,111,190,99,142,111,190,111,190,127,254,0,0 },
  { 124,4,4,10,21,74,25,36,17,32,18,32,32,0,0,0,0,64,0,64,0,64,124,96,0,80,0,64,0,64,0,0 },
  { 62,0,2,16,10,80,12,80,8,84,8,84,16,88,0,0,0,0,62,0,2,124,2,4,2,24,4,16,24,32,0,0 },
  { 62,0,2,64,10,32,12,4,8,24,8,96,16,0,0,0,1,62,34,130,82,138,9,12,4,8,0,8,0,16,0,0 },
  { 62,0,2,0,10,0,12,124,8,0,8,0,16,0,0,0,0,0,8,0,40,0,40,0,42,0,42,0,44,0,0,0 },
  { 2,0,4,56,8,0,24,0,40,0,8,124,8,0,0,0,1,2,129,233,65,36,10,32,48,32,192,64,1,128,0,0 },
  { 2,0,4,64,8,32,24,4,40,24,8,96,8,0,0,0,4,0,56,0,8,0,62,0,8,0,8,0,16,0,0,0 },
  { 8,0,62,0,34,8,34,124,2,24,4,40,8,72,0,0,0,0,32,0,16,0,2,0,12,0,48,0,0,0,0,0 },
  { 0,0,124,248,16,8,16,16,16,32,16,80,124,136,0,0,64,34,120,41,72,36,139,176,8,40,16,32,96,32,0,0 },
  { 0,0,62,0,8,0,8,124,8,0,8,0,62,0,0,0,16,0,62,0,18,0,18,124,18,0,18,0,36,0,0,0 },
  { 4,0,62,64,4,32,12,4,20,24,36,96,12,0,0,0,0,0,62,0,2,0,4,0,8,0,20,0,34,0,0,0 },
  { 4,0,62,0,4,0,12,124,20,0,36,0,12,0,0,0,8,0,8,0,16,0,32,0,34,0,62,0,2,0,0,0 },
  { 16,4,62,8,18,16,18,48,18,80,18,16,36,16,0,0,36,0,36,0,36,0,36,0,4,0,8,0,48,0,0,0 },
  { 16,56,62,0,18,124,18,4,18,4,18,8,36,48,0,0,0,32,0,32,42,32,42,48,2,40,4,32,24,32,0,0 },
  { 16,0,62,124,18,68,18,68,18,68,18,124,36,0,0,0,36,0,36,0,36,0,36,124,4,0,8,0,48,0,0,0 },
  { 65,0,252,190,74,34,72,34,72,34,72,62,144,0,0,0,0,0,64,0,32,0,4,0,24,0,96,0,0,0,0,0 },
  { 64,128,250,80,73,8,72,2,72,12,72,48,144,0,0,0,0,0,124,0,4,0,4,0,40,0,16,0,8,0,0,0 },
  { 32,64,125,32,16,128,124,0,16,0,8,0,8,0,0,0,2,4,7,210,2,72,2,64,2,64,2,64,4,128,0,0 },
  { 64,128,250,92,33,0,248,0,32,0,16,62,16,0,0,0,0,0,0,0,0,0,124,0,0,0,0,0,0,0,0,0 },
  { 16,0,62,0,8,0,62,56,8,8,4,124,4,0,0,0,36,0,36,0,36,0,36,124,4,0,8,0,48,0,0,0 },
  { 64,128,250,68,33,20,248,20,32,21,16,21,16,22,0,0,64,128,122,64,73,0,168,62,24,0,16,0,96,0,0,0 },
  { 16,0,62,0,8,0,62,0,8,0,4,0,4,0,0,0,0,0,0,124,0,68,0,68,0,68,0,124,0,0,0,0 },
  { 32,0,124,248,16,136,124,136,16,136,8,248,8,0,0,0,65,50,116,130,82,116,144,20,16,21,32,39,64,65,0,0 },
  { 64,2,251,194,34,66,250,84,34,72,19,212,16,32,0,0,2,0,2,8,2,40,251,40,2,170,2,42,2,44,0,0 },
  { 16,0,62,62,8,34,62,34,8,34,4,62,4,0,0,0,0,8,248,8,138,168,138,172,8,42,16,72,97,136,0,0 },
  { 64,140,122,64,73,30,136,2,8,2,16,4,96,8,0,0,16,0,16,0,32,0,64,0,68,0,124,0,4,0,0,0 },
  { 64,140,122,64,73,30,136,2,8,2,16,4,96,8,0,0,34,0,34,16,66,8,131,2,138,140,250,48,10,0,0,0 },
  { 32,0,60,32,36,160,68,160,4,168,8,168,48,176,0,0,65,16,252,175,74,73,80,201,65,73,64,73,56,79,0,0 },
  { 16,0,30,124,18,68,34,68,2,68,4,124,24,0,0,0,0,16,0,124,0,8,62,16,0,56,0,84,0,16,0,0 },
  { 16,0,30,0,36,0,4,124,4,0,4,0,8,0,0,0,0,0,62,0,2,0,4,0,8,0,20,0,34,0,0,0 },
  { 0,0,62,16,2,80,2,80,2,84,2,84,62,88,0,0,8,0,8,0,62,0,8,0,8,0,16,0,32,0,0,0 },
  { 0,0,62,0,2,0,2,124,2,0,2,0,62,0,0,0,8,64,62,160,8,160,42,64,42,0,8,0,24,0,0,0 },
  { 20,4,62,8,20,16,20,48,4,80,8,16,16,16,0,0,16,0,30,16,18,80,34,80,2,84,4,84,24,88,0,0 },
  { 20,0,62,64,20,32,20,4,4,24,8,96,16,0,0,0,16,8,224,8,32,16,251,160,32,34,32,62,64,2,0,0 },
  { 32,144,20,144,68,144,36,144,8,16,112,32,0,192,0,0,1,2,129,233,65,36,10,32,48,32,192,64,1,128,0,0 },
  { 16,0,62,64,18,32,20,4,16,24,16,96,14,0,0,0,4,0,56,0,8,0,62,0,8,0,8,0,16,0,0,0 },
  { 16,0,62,64,18,32,20,4,16,24,16,96,14,0,0,0,16,0,16,0,16,0,24,0,20,0,16,0,16,0,0,0 },
  { 64,128,122,64,73,0,168,62,24,0,16,0,96,0,0,0,0,0,124,0,4,0,8,0,16,0,40,0,68,0,0,0 },
  { 28,32,0,144,62,64,8,0,8,0,8,0,16,0,0,0,0,32,0,20,0,68,0,36,0,8,0,112,0,0,0,0 },
  { 33,0,36,128,34,0,48,0,40,0,32,0,32,0,0,0,0,0,0,16,0,80,0,80,0,84,0,84,0,88,0,0 },
  { 16,0,16,0,16,0,24,0,20,0,16,0,16,0,0,0,0,0,0,64,0,32,0,4,0,24,0,96,0,0,0,0 },
  { 8,0,8,0,62,0,8,0,8,0,16,0,32,0,0,0,0,0,0,8,0,8,0,8,0,8,0,16,0,32,0,0 },
  { 4,0,4,0,4,84,4,84,4,4,8,8,16,48,0,0,8,0,8,0,8,0,12,0,10,0,8,0,8,0,0,0 },
  { 0,4,0,8,20,16,18,48,18,80,34,16,0,16,0,0,0,0,42,0,42,0,2,0,2,0,4,0,24,0,0,0 },
  { 1,0,2,128,82,128,73,62,72,0,136,0,0,0,0,0,64,8,250,8,73,8,80,44,64,202,67,8,56,8,0,0 },
  { 1,0,2,128,82,128,73,62,72,0,136,0,0,0,0,0,0,0,84,0,84,0,4,0,4,0,8,0,48,0,0,0 },
  { 1,0,4,128,82,0,72,62,72,0,136,0,0,0,0,0,0,0,64,32,64,160,68,160,72,168,80,168,96,176,0,0 },
  { 129,62,154,130,226,138,129,12,128,8,128,8,120,16,0,0,2,0,250,8,10,40,19,40,34,170,82,42,138,44,0,0 },
  { 129,16,154,158,226,146,129,34,128,2,128,4,120,24,0,0,0,0,16,0,80,0,80,0,84,0,84,0,88,0,0,0 },
  { 32,64,38,160,56,160,32,64,32,0,32,0,30,0,0,0,0,0,0,124,0,4,0,4,0,4,0,4,0,124,0,0 },
  { 64,64,77,32,112,128,64,0,64,0,64,0,60,0,0,0,0,0,0,16,0,80,0,80,0,84,0,84,0,88,0,0 },
  { 0,0,124,0,4,248,4,8,4,48,8,32,48,64,0,0,224,34,0,41,234,164,42,176,32,168,65,32,134,32,0,0 },
  { 0,0,62,0,2,8,2,16,2,48,4,80,24,16,0,0,0,32,0,32,0,32,62,48,0,40,0,32,0,32,0,0 },
  { 1,0,244,128,18,42,16,42,16,2,32,4,192,24,0,0,64,0,40,4,136,20,79,212,17,21,225,21,7,214,0,0 },
  { 0,56,62,0,2,124,2,4,2,4,4,8,24,48,0,0,0,0,32,0,16,0,2,0,12,0,48,0,0,0,0,0 },
  { 0,64,32,120,80,72,8,136,4,8,0,16,0,96,0,0,64,0,120,4,72,20,171,212,24,21,16,21,96,22,0,0 },
  { 1,0,34,128,82,128,9,0,4,0,0,0,0,0,0,0,0,0,0,36,0,20,0,20,0,4,0,8,0,48,0,0 },
  { 1,0,34,156,82,128,9,0,4,0,0,62,0,0,0,0,32,0,38,0,56,0,32,0,32,0,32,0,30,0,0,0 },
  { 0,0,16,16,40,80,4,80,2,84,0,84,0,88,0,0,0,0,42,0,42,0,2,0,2,0,4,0,24,0,0,0 },
  { 1,0,34,160,82,144,9,2,4,12,0,48,0,0,0,0,0,0,62,0,2,0,4,0,8,0,20,0,34,0,0,0 },
  { 1,0,34,128,82,128,9,62,4,0,0,0,0,0,0,0,32,64,21,32,68,128,36,0,8,0,112,0,0,0,0,0 },
  { 1,0,36,128,82,0,8,62,4,0,0,0,0,0,0,0,16,0,30,0,18,0,42,0,6,0,4,0,24,0,0,0 },
  { 16,130,125,68,17,72,84,152,84,40,16,8,48,8,0,0,0,32,32,32,16,32,2,48,12,40,48,32,0,32,0,0 },
  { 16,64,125,36,16,148,84,20,84,21,16,21,48,22,0,0,16,0,16,0,16,0,24,0,20,0,16,0,16,0,0,0 },
  { 8,0,62,0,8,0,42,0,42,0,8,0,24,0,0,0,0,0,0,64,0,32,0,4,0,24,0,96,0,0,0,0 },
  { 16,128,125,80,17,72,84,130,84,12,16,48,48,0,0,0,16,128,18,64,17,0,24,0,20,0,16,0,16,0,0,0 },
  { 8,0,62,0,8,0,42,124,42,0,8,0,24,0,0,0,0,0,8,0,40,0,40,0,42,0,42,0,44,0,0,0 },
  { 8,0,62,0,8,0,42,124,42,0,8,0,24,0,0,0,0,0,32,0,16,0,2,0,12,0,48,0,0,0,0,0 },
  { 0,4,62,8,2,16,2,48,20,80,8,16,4,16,0,0,16,0,30,124,18,68,2,68,2,68,4,124,24,0,0,0 },
  { 0,4,62,8,2,16,2,48,20,80,8,16,4,16,0,0,0,0,8,0,40,0,40,0,42,0,42,0,44,0,0,0 },
  { 0,0,62,0,2,84,2,84,20,4,8,8,4,48,0,0,0,0,0,0,20,0,18,0,18,0,34,0,0,0,0,0 },
  { 0,0,62,16,2,80,2,80,20,84,8,84,4,88,0,0,16,0,30,0,18,0,34,0,2,0,4,0,24,0,0,0 },
  { 0,0,124,128,4,64,4,8,40,48,16,192,8,0,0,0,0,0,64,32,43,144,136,130,75,140,16,176,227,128,0,0 },
  { 24,32,4,60,48,36,8,68,0,4,48,8,12,48,0,0,0,0,62,64,34,32,34,4,34,24,62,96,0,0,0,0 },
  { 24,0,4,0,48,0,8,0,0,0,48,0,12,0,0,0,0,72,0,72,0,72,0,72,0,8,0,16,0,96,0,0 },
  { 24,72,4,72,48,72,8,72,0,8,48,16,12,96,0,0,1,0,4,132,82,20,72,20,73,213,136,21,0,22,0,0 },
  { 4,0,4,0,4,0,40,0,16,0,40,0,64,0,0,0,2,4,7,210,2,72,2,64,2,64,2,64,4,128,0,0 },
  { 9,2,11,233,9,36,81,32,33,32,81,32,130,64,0,0,32,0,32,128,32,64,48,8,40,48,32,192,32,0,0,0 },
  { 2,0,2,0,2,0,20,124,8,0,20,0,32,0,0,0,16,0,16,16,16,80,24,80,20,84,16,84,16,88,0,0 },
  { 16,0,16,0,62,0,18,124,20,0,16,0,16,0,0,0,33,0,36,128,34,0,48,0,40,0,32,0,32,0,0,0 },
  { 16,0,16,0,62,0,18,124,20,0,16,0,16,0,0,0,0,0,8,0,40,0,40,0,42,0,42,0,44,0,0,0 },
  { 0,124,28,4,4,20,4,24,4,16,62,16,0,32,0,0,0,0,32,0,16,0,2,0,12,0,48,0,0,0,0,0 },
  { 36,0,36,0,36,84,36,84,4,4,8,8,48,48,0,0,16,0,16,16,16,80,24,80,20,84,16,84,16,88,0,0 },
  { 36,0,36,0,36,0,36,0,4,0,8,0,48,0,0,0,0,56,0,0,0,124,0,4,0,4,0,8,0,48,0,0 },
  { 17,2,81,53,81,197,81,2,85,0,85,0,88,240,0,0,0,0,0,0,0,0,124,0,0,0,0,0,0,0,0,0 },
  { 0,0,8,0,40,0,40,124,42,0,42,0,44,0,0,0,0,128,250,68,9,20,8,20,8,21,16,21,96,22,0,0 },
  { 0,0,32,0,32,0,34,0,36,0,40,0,48,0,0,0,0,16,0,16,0,32,0,64,0,68,0,124,0,4,0,0 },
  { 0,0,64,128,64,64,68,8,72,48,80,192,96,0,0,0,136,32,142,148,148,66,196,0,164,1,132,6,136,24,0,0 },
  { 0,0,62,0,34,84,34,84,2,4,4,8,24,48,0,0,16,0,16,0,16,0,24,0,20,0,16,0,16,0,0,0 },
  { 0,16,24,16,36,16,36,30,36,16,36,16,36,124,36,68,36,68,36,68,36,124,36,68,36,0,36,84,24,170,0,170 },
  { 0,16,16,16,48,16,16,30,16,16,16,16,16,124,16,68,16,68,16,68,16,124,16,68,16,0,16,84,124,170,0,170 },
  { 0,16,24,16,36,16,36,30,4,16,4,16,8,124,8,68,8,68,16,68,16,124,16,68,32,0,32,84,60,170,0,170 },
  { 0,16,24,16,36,16,36,30,4,16,4,16,4,124,24,68,4,68,4,68,4,124,4,68,36,0,36,84,24,170,0,170 },
  { 0,16,36,16,36,16,36,30,36,16,36,16,36,124,60,68,4,68,4,68,4,124,4,68,4,0,4,84,4,170,0,170 },
  { 0,16,60,16,32,16,32,30,32,16,32,16,32,124,56,68,4,68,4,68,4,124,4,68,36,0,36,84,24,170,0,170 },
  { 0,16,24,16,36,16,36,30,32,16,32,16,32,124,56,68,36,68,36,68,36,124,36,68,36,0,36,84,24,170,0,170 },
  { 0,16,60,16,4,16,4,30,4,16,8,16,8,124,8,68,16,68,16,68,16,124,16,68,16,0,16,84,16,170,0,170 },
  { 0,16,24,16,36,16,36,30,36,16,36,16,36,124,24,68,36,68,36,68,36,124,36,68,36,0,36,84,24,170,0,170 },
  { 0,16,24,16,36,16,36,30,36,16,36,16,36,124,24,68,4,68,4,68,4,124,4,68,36,0,36,84,24,170,0,170 },
  { 0,16,38,16,105,16,41,30,41,16,41,16,41,124,41,68,41,68,41,68,41,124,41,68,41,0,41,84,118,170,0,170 },
  { 0,16,34,16,102,16,34,30,34,16,34,16,34,124,34,68,34,68,34,68,34,124,34,68,34,0,34,84,119,170,0,170 },
  { 0,16,38,16,105,16,41,30,33,16,33,16,34,124,34,68,34,68,36,68,36,124,36,68,40,0,40,84,127,170,0,170 },
  { 0,16,38,16,105,16,41,30,33,16,33,16,33,124,38,68,33,68,33,68,33,124,33,68,41,0,41,84,118,170,0,170 },
  { 0,16,41,16,105,16,41,30,41,16,41,16,41,124,47,68,33,68,33,68,33,124,33,68,33,0,33,84,113,170,0,170 },
  { 0,16,47,16,104,16,40,30,40,16,40,16,40,124,46,68,33,68,33,68,33,124,33,68,41,0,41,84,118,170,0,170 },
  { 0,16,38,16,105,16,41,30,40,16,40,16,40,124,46,68,41,68,41,68,41,124,41,68,41,0,41,84,118,170,0,170 },
  { 0,16,47,16,97,16,33,30,33,16,34,16,34,124,34,68,36,68,36,68,36,124,36,68,36,0,36,84,116,170,0,170 },
  { 0,16,38,16,105,16,41,30,41,16,41,16,41,124,38,68,41,68,41,68,41,124,41,68,41,0,41,84,118,170,0,170 },
  { 0,16,38,16,105,16,41,30,41,16,41,16,41,124,38,68,33,68,33,68,33,124,33,68,41,0,41,84,118,170,0,170 },
  { 0,8,99,8,148,136,148,143,20,136,20,136,36,190,36,162,36,162,68,162,68,190,68,162,132,128,132,170,243,85,0,85 },
  { 0,8,98,8,150,8,146,15,18,8,18,8,34,62,34,34,34,34,66,34,66,62,66,34,130,0,130,42,247,85,0,85 },
  { 0,8,99,8,148,136,148,143,16,136,16,136,33,62,33,34,33,34,66,34,66,62,66,34,132,0,132,42,247,213,0,85 },
  { 0,8,99,8,148,136,148,143,16,136,16,136,32,190,35,34,32,162,64,162,64,190,64,162,132,128,132,170,243,85,0,85 },
  { 0,8,100,136,148,136,148,143,20,136,20,136,36,190,39,162,32,162,64,162,64,190,64,162,128,128,128,170,240,213,0,85 },
  { 0,0,0,0,67,192,66,32,66,32,66,32,83,204,106,18,74,2,74,14,74,18,74,18,74,22,74,10,0,0,0,0 },
  { 0,0,0,0,2,0,2,0,2,0,2,0,58,60,70,66,66,2,66,62,66,66,66,66,70,70,58,58,0,0,0,0 },
  { 0,0,0,0,8,66,20,66,20,66,20,66,34,66,34,66,62,66,34,66,65,66,65,66,65,66,65,60,0,0,0,0 },
  { 0,0,0,0,64,0,64,0,64,0,64,0,113,148,74,90,72,82,73,208,74,80,74,80,74,208,113,80,0,0,0,0 },
  { 0,0,0,0,0,130,0,130,0,130,0,130,120,130,132,68,132,68,132,68,132,40,132,40,132,16,120,16,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,92,60,98,66,66,64,66,64,66,64,66,64,98,66,92,60,64,0,64,0 },
  { 0,0,0,0,1,0,1,0,1,0,1,0,29,104,35,84,65,84,65,84,65,84,65,84,35,84,29,84,0,0,0,0 },
  { 0,30,0,2,2,30,2,16,2,30,2,0,58,208,70,168,130,168,130,168,130,168,130,168,70,168,58,168,0,0,0,0 },
  { 0,30,0,2,2,14,2,2,2,30,2,0,58,208,70,168,130,168,130,168,130,168,130,168,70,168,58,168,0,0,0,0 },
  { 0,0,0,0,124,132,16,132,16,132,16,132,16,132,16,132,16,132,16,132,16,132,16,132,16,132,124,120,0,0,0,0 },
  { 0,0,0,10,0,9,254,9,16,8,146,127,82,72,84,72,16,120,254,85,16,85,16,149,16,214,16,181,17,10,0,16 },
  { 0,0,30,48,10,238,234,74,170,250,170,74,234,74,182,202,160,234,174,218,235,74,170,74,14,78,10,74,0,0,0,0 },
  { 0,0,0,0,16,254,16,16,16,16,254,80,16,80,16,80,40,94,40,80,40,80,68,80,68,80,68,80,130,254,0,0 },
  { 0,0,0,1,14,129,234,66,170,2,170,148,238,85,170,23,170,33,170,32,238,111,170,41,10,41,18,47,38,41,0,0 },
  { 42,5,127,132,42,63,119,2,162,58,39,18,42,185,0,0,16,68,40,244,68,30,186,36,0,212,254,68,36,68,122,95 },
  { 0,0,0,0,0,16,0,40,0,40,0,40,92,68,98,68,66,124,66,68,66,130,98,130,92,130,64,130,64,0,64,0 },
  { 0,0,0,0,0,16,0,40,0,40,0,40,88,68,100,68,68,124,68,68,68,130,68,130,68,130,68,130,0,0,0,0 },
  { 0,0,0,0,0,16,0,40,0,40,0,40,17,68,17,68,17,124,18,68,34,130,34,130,34,130,61,130,64,0,64,0 },
  { 0,0,0,0,0,16,0,40,0,40,0,40,104,68,84,68,84,124,84,68,84,130,84,130,84,130,84,130,0,0,0,0 },
  { 0,0,0,0,128,16,128,40,128,40,128,40,132,68,136,68,144,124,160,68,208,130,136,130,132,130,130,130,0,0,0,0 },
  { 0,0,0,0,64,124,64,66,64,66,64,66,66,66,68,124,72,66,80,66,104,66,68,66,66,66,65,124,0,0,0,0 },
  { 0,0,0,0,65,124,65,66,99,66,99,66,85,66,85,124,73,66,73,66,65,66,65,66,65,66,65,124,0,0,0,0 },
  { 0,0,0,0,60,124,66,66,66,66,64,66,64,66,78,124,66,66,66,66,66,66,66,66,70,66,58,124,0,0,0,0 },
  { 0,0,0,0,0,12,0,4,0,4,0,4,113,228,138,20,128,20,129,244,130,20,130,20,138,52,113,222,0,0,0,0 },
  { 0,0,0,0,128,12,128,4,128,4,128,4,147,100,148,148,164,20,196,116,164,148,148,148,140,180,143,94,0,0,0,0 },
  { 0,0,0,0,0,254,0,128,0,128,0,128,92,128,98,248,66,128,66,128,66,128,98,128,92,128,64,128,64,0,64,0 },
  { 0,0,0,0,0,254,0,128,0,128,0,128,88,248,100,128,68,128,68,128,68,128,68,128,68,128,68,128,0,0,0,0 },
  { 0,0,0,0,0,126,0,64,0,64,0,64,34,124,34,64,34,64,34,64,68,64,68,64,68,64,123,64,128,0,128,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,4,17,52,17,72,17,72,17,72,34,48,34,32,34,56,61,196,64,68,64,56 },
  { 0,0,0,0,0,0,0,0,0,0,0,8,104,104,84,144,84,144,84,144,84,96,84,64,84,112,84,136,0,136,0,112 },
  { 0,0,0,0,64,0,64,0,64,0,64,4,66,52,68,72,72,72,80,72,104,48,68,32,66,56,65,68,0,68,0,56 },
  { 0,0,65,0,65,0,65,0,65,0,65,0,65,62,127,2,65,4,65,8,65,16,65,32,65,64,65,126,0,0,0,0 },
  { 0,0,132,64,132,64,132,64,132,64,132,64,148,94,151,194,164,68,196,72,164,72,148,80,140,96,140,126,0,0,0,0 },
  { 0,0,138,64,138,64,218,64,218,64,170,64,170,94,139,194,138,68,138,68,138,72,138,72,138,80,138,94,0,0,0,0 },
  { 0,0,0,0,114,64,138,64,138,64,130,64,130,94,131,194,158,68,138,68,138,72,138,72,138,80,122,94,0,0,0,0 },
  { 0,0,0,0,252,128,36,128,36,128,36,128,36,190,39,130,36,132,36,136,36,136,36,144,36,160,36,190,0,0,0,0 },
  { 0,0,0,0,0,8,0,20,0,20,0,36,17,40,17,72,17,72,34,80,34,82,34,98,34,100,93,216,64,0,64,0 },
  { 0,0,0,0,0,8,0,20,0,20,0,36,118,40,73,72,73,72,73,80,73,82,73,98,73,100,72,216,0,0,0,0 },
  { 0,0,0,0,2,8,2,20,2,20,2,36,58,40,70,72,66,72,66,80,66,82,66,98,70,100,59,216,0,0,0,0 },
  { 0,0,0,0,64,8,64,20,64,20,64,36,66,40,68,72,72,72,80,80,104,82,68,98,66,100,65,216,0,0,0,0 },
  { 0,0,0,0,28,0,34,0,32,0,32,0,120,200,33,52,33,36,33,36,33,36,33,36,33,36,33,36,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,89,216,101,36,69,36,69,36,69,36,69,36,69,36,69,36,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,34,164,34,218,34,146,66,146,68,146,68,146,68,146,123,146,128,0,128,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,52,104,42,84,42,84,42,84,42,84,42,84,42,84,42,84,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,28,104,34,84,64,84,64,84,64,84,64,84,34,84,28,84,0,0,0,0 },
  { 0,0,0,0,64,0,64,0,64,0,64,0,66,104,68,84,72,84,80,84,104,84,68,84,66,84,65,84,0,0,0,0 },
  { 0,30,0,2,0,30,0,16,0,30,0,0,104,208,84,168,84,168,84,168,84,168,84,168,84,168,84,168,0,0,0,0 },
  { 0,30,0,2,0,30,0,16,0,30,0,0,56,208,68,168,128,168,128,168,128,168,128,168,68,168,56,168,0,0,0,0 },
  { 0,60,0,4,0,60,0,32,0,60,0,0,44,192,51,32,34,32,34,32,34,32,34,32,34,32,34,32,0,0,0,0 },
  { 0,30,0,2,128,30,128,16,128,30,128,0,132,208,136,168,144,168,160,168,208,168,136,168,132,168,130,168,0,0,0,0 },
  { 0,30,0,2,0,14,0,2,0,30,0,0,104,208,84,168,84,168,84,168,84,168,84,168,84,168,84,168,0,0,0,0 },
  { 0,30,0,2,0,14,0,2,0,30,0,0,56,208,68,168,128,168,128,168,128,168,128,168,68,168,56,168,0,0,0,0 },
  { 0,60,0,4,0,28,0,4,0,60,0,0,44,192,51,32,34,32,34,32,34,32,34,32,34,32,34,32,0,0,0,0 },
  { 0,30,0,2,128,14,128,2,128,30,128,0,132,208,136,168,144,168,160,168,208,168,136,168,132,168,130,168,0,0,0,0 },
  { 0,2,208,4,168,8,168,16,168,32,168,64,168,128,169,120,170,132,2,128,4,120,8,4,16,132,32,120,64,0,128,0 },
  { 0,16,208,46,168,34,168,78,168,136,168,142,169,0,170,120,172,132,4,128,8,120,16,4,16,132,32,120,64,0,128,0 },
  { 0,0,0,0,124,0,66,0,66,0,66,0,66,240,125,8,64,8,64,248,65,8,65,8,65,24,64,232,0,0,0,0 },
  { 0,0,0,0,129,192,129,32,129,32,129,32,133,60,137,194,145,2,161,30,209,34,137,34,133,38,131,26,0,0,0,0 },
  { 0,0,0,0,137,192,137,32,217,32,217,32,169,60,169,194,137,2,137,30,137,34,137,34,137,38,137,26,0,0,0,0 },
  { 0,0,0,0,113,192,137,32,137,32,129,32,129,60,129,194,157,2,137,30,137,34,137,34,137,38,121,26,0,0,0,0 },
  { 0,0,0,0,0,2,0,2,0,2,0,2,91,26,100,166,64,162,71,162,72,162,72,162,73,166,70,218,0,0,0,0 },
  { 0,130,0,132,0,132,177,136,202,136,154,144,170,144,170,160,170,172,157,210,0,144,1,12,1,2,2,18,4,12,8,0 },
  { 0,144,0,158,0,146,177,174,202,168,154,174,170,192,170,192,170,152,157,164,0,160,1,24,1,4,2,36,2,24,4,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,92,120,98,132,66,128,66,112,66,8,66,4,98,132,92,120,64,0,64,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,88,120,100,132,68,128,68,112,68,8,68,4,68,132,68,120,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,17,60,17,66,17,64,17,56,34,4,34,2,34,66,61,188,64,0,64,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,104,120,84,132,84,128,84,112,84,8,84,4,84,132,84,120,0,0,0,0 },
  { 0,0,0,0,1,4,1,4,1,4,1,4,185,4,196,136,132,136,132,136,132,80,196,80,184,32,128,32,128,0,128,0 },
  { 0,0,0,0,1,4,1,4,1,4,1,4,88,136,100,136,68,136,68,80,68,80,68,32,68,32,68,32,0,0,0,0 },
  { 0,0,0,0,0,130,0,130,0,130,0,130,34,130,34,68,34,68,34,68,68,40,68,40,68,16,123,16,128,0,128,0 },
  { 0,0,0,0,0,130,0,130,0,130,0,130,52,130,42,68,42,68,42,68,42,40,42,40,42,16,42,16,0,0,0,0 },
  { 0,0,0,0,129,4,129,4,129,4,129,4,133,4,136,136,144,136,160,136,208,80,136,80,132,32,130,32,0,0,0,0 },
  { 0,0,0,0,130,130,130,130,198,130,198,130,170,130,170,68,146,68,146,68,130,40,130,40,130,16,130,16,0,0,0,0 },
  { 0,0,0,0,2,34,2,34,2,34,1,34,89,20,101,20,68,148,68,148,68,180,100,200,88,72,64,72,64,0,64,0 },
  { 0,0,0,0,2,34,2,34,2,34,1,34,89,20,101,20,68,148,68,148,68,180,68,200,68,72,68,72,0,0,0,0 },
  { 0,0,0,0,2,34,2,34,2,34,1,34,37,20,37,20,36,148,36,148,72,180,72,200,72,72,118,72,128,0,128,0 },
  { 0,0,0,0,2,34,2,34,2,34,1,34,105,20,85,20,84,148,84,148,84,180,84,200,84,72,84,72,0,0,0,0 },
  { 0,0,0,0,130,34,130,34,130,34,129,34,133,20,137,20,144,148,160,148,208,180,136,200,132,72,131,72,0,0,0,0 },
  { 0,0,0,0,131,34,131,34,199,34,199,34,170,148,170,148,146,148,146,148,130,180,130,72,130,72,130,72,0,0,0,0 },
  { 0,0,0,0,64,112,64,136,65,4,65,4,73,4,73,4,81,4,97,4,80,136,72,136,70,82,71,222,0,0,0,0 },
  { 0,0,0,0,136,112,136,136,217,4,217,4,169,4,169,4,137,4,137,4,136,136,136,136,138,82,139,222,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,48,208,72,168,8,168,56,168,72,168,72,168,88,168,42,170,0,0,0,0 },
  { 0,0,0,0,60,0,34,0,34,0,34,0,34,52,60,76,34,68,33,68,33,68,33,76,34,52,60,4,0,4,0,4 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,28,56,34,68,64,128,64,128,64,128,64,128,34,68,28,56,0,0,0,0 },
  { 0,0,0,4,0,4,0,4,0,4,0,4,60,116,66,140,64,132,64,132,64,132,64,132,66,140,60,116,0,0,0,0 },
  { 0,16,112,32,136,64,128,128,129,0,138,0,118,1,10,77,18,82,34,146,67,18,130,140,2,72,2,78,0,17,0,14 },
  { 0,0,0,0,60,0,66,0,129,0,128,0,128,112,128,136,128,136,128,136,128,136,129,136,66,136,60,114,0,0,0,0 },
  { 0,0,0,0,4,248,4,132,4,132,4,132,116,132,140,248,132,132,132,130,132,130,132,130,140,132,116,248,0,0,0,0 },
  { 0,0,0,0,30,0,33,0,65,0,64,0,64,66,64,66,64,34,67,164,65,20,65,24,35,8,29,16,0,16,0,96 },
  { 0,0,0,0,32,0,32,0,32,0,32,0,44,120,50,132,34,4,34,124,34,132,34,132,34,140,34,116,0,0,0,0 },
  { 0,0,0,0,66,124,66,66,66,66,66,66,66,66,126,124,66,64,66,64,66,64,66,64,66,64,66,64,0,0,0,0 },
  { 0,0,0,0,0,0,16,0,16,0,0,0,48,184,16,196,16,132,16,132,16,132,16,132,16,132,124,132,0,0,0,0 },
  { 0,0,0,0,130,130,132,132,136,136,144,144,160,160,192,192,192,192,160,160,144,144,136,136,132,132,130,130,0,0,0,0 },
  { 0,0,0,0,69,4,69,4,69,140,73,140,81,84,97,84,81,36,73,36,69,4,69,4,69,4,69,4,0,0,0,0 },
  { 0,0,0,0,64,0,64,32,64,32,64,32,66,120,68,32,72,32,80,32,104,32,68,36,66,36,65,24,0,0,0,0 },
  { 0,0,0,0,96,0,32,0,32,0,32,0,32,0,33,216,33,36,33,36,33,36,33,36,33,36,249,36,0,0,0,0 },
  { 0,0,0,0,96,0,32,0,32,0,32,0,33,120,33,132,33,4,33,4,33,4,33,4,249,4,0,0,0,0,0,0 },
  { 0,0,0,0,96,0,32,0,32,0,32,2,39,26,40,164,40,164,40,164,40,152,40,144,40,156,247,34,0,34,0,28 },
  { 0,0,0,0,96,0,32,0,32,0,32,0,34,4,33,8,32,144,32,96,32,96,32,144,33,8,250,4,0,0,0,0 },
  { 0,0,0,0,0,128,0,128,0,128,0,128,52,184,42,196,42,132,42,132,42,132,42,132,42,196,42,184,0,0,0,0 },
  { 0,0,0,0,0,24,0,136,0,136,0,8,105,136,84,136,84,136,84,136,84,136,84,136,84,136,87,254,0,0,0,0 },
  { 0,0,0,0,0,12,0,4,0,4,0,4,209,196,170,36,170,36,170,36,170,36,170,36,170,36,169,223,0,0,0,0 },
  { 0,0,0,0,124,66,66,66,66,66,66,66,66,66,124,126,64,66,64,66,64,66,64,66,64,66,64,66,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,88,208,100,168,68,168,68,168,68,168,120,168,64,168,68,170,64,0,64,0 },
  { 0,0,0,0,231,34,148,162,148,182,148,182,148,170,231,42,132,34,132,34,132,34,132,34,132,34,132,34,0,0,0,0 },
  { 0,0,0,0,124,124,66,66,66,66,66,66,66,66,124,124,64,72,64,72,64,68,64,68,64,66,64,66,0,0,0,0 },
  { 0,0,0,0,0,0,0,0,0,0,0,0,60,44,66,50,64,32,56,32,4,32,2,32,66,32,60,32,0,0,0,0 },
  { 0,0,0,0,30,0,33,0,64,0,64,0,48,130,12,130,3,68,0,196,0,168,64,168,33,16,30,16,0,0,0,0 },
  { 0,0,0,0,136,160,136,160,136,160,136,160,68,188,69,34,77,34,77,34,85,34,34,34,34,34,34,60,0,0,0,0 },
  { 0,0,0,2,34,4,34,8,34,16,34,32,20,64,20,180,9,42,10,42,4,42,8,42,16,42,32,42,64,0,0,0 },
  { 0,0,8,2,20,4,34,8,62,16,34,32,34,64,34,180,1,42,2,42,4,42,8,42,16,42,32,42,64,0,0,0 },
  { 0,0,16,124,48,68,16,68,16,68,16,68,16,68,16,124,16,68,16,68,16,68,16,68,16,68,16,124,124,68,0,68 },
  { 0,0,24,124,36,68,36,68,4,68,4,68,8,68,8,124,8,68,16,68,16,68,16,68,32,68,32,124,60,68,0,68 },
  { 0,0,24,124,36,68,36,68,4,68,4,68,4,68,24,124,4,68,4,68,4,68,4,68,36,68,36,124,24,68,0,68 },
  { 0,0,36,124,36,68,36,68,36,68,36,68,36,68,60,124,4,68,4,68,4,68,4,68,4,68,4,124,4,68,0,68 },
  { 0,0,60,124,32,68,32,68,32,68,32,68,32,68,56,124,4,68,4,68,4,68,4,68,36,68,36,124,24,68,0,68 },
  { 0,0,24,124,36,68,36,68,32,68,32,68,32,68,56,124,36,68,36,68,36,68,36,68,36,68,36,124,24,68,0,68 },
  { 0,0,60,124,4,68,4,68,4,68,8,68,8,68,8,124,16,68,16,68,16,68,16,68,16,68,16,124,16,68,0,68 },
  { 0,0,24,124,36,68,36,68,36,68,36,68,36,68,24,124,36,68,36,68,36,68,36,68,36,68,36,124,24,68,0,68 },
  { 0,0,24,124,36,68,36,68,36,68,36,68,36,68,24,124,4,68,4,68,4,68,4,68,36,68,36,124,24,68,0,68 },
  { 0,0,38,124,105,68,41,68,41,68,41,68,41,68,41,124,41,68,41,68,41,68,41,68,41,68,41,124,118,68,0,68 },
  { 0,0,34,124,102,68,34,68,34,68,34,68,34,68,34,124,34,68,34,68,34,68,34,68,34,68,34,124,119,68,0,68 },
  { 0,0,38,124,105,68,41,68,33,68,33,68,34,68,34,124,34,68,36,68,36,68,36,68,40,68,40,124,127,68,0,68 },
  { 0,0,38,124,105,68,41,68,33,68,33,68,33,68,38,124,33,68,33,68,33,68,33,68,41,68,41,124,118,68,0,68 },
  { 0,0,41,124,105,68,41,68,41,68,41,68,41,68,47,124,33,68,33,68,33,68,33,68,33,68,33,124,113,68,0,68 },
  { 0,0,47,124,104,68,40,68,40,68,40,68,40,68,46,124,33,68,33,68,33,68,33,68,41,68,41,124,118,68,0,68 },
  { 0,0,38,124,105,68,41,68,40,68,40,68,40,68,46,124,41,68,41,68,41,68,41,68,41,68,41,124,118,68,0,68 },
  { 0,0,47,124,97,68,33,68,33,68,34,68,34,68,34,124,36,68,36,68,36,68,36,68,36,68,36,124,116,68,0,68 },
  { 0,0,38,124,105,68,41,68,41,68,41,68,41,68,38,124,41,68,41,68,41,68,41,68,41,68,41,124,118,68,0,68 },
  { 0,0,38,124,105,68,41,68,41,68,41,68,41,68,38,124,33,68,33,68,33,68,33,68,41,68,41,124,118,68,0,68 },
  { 0,0,99,60,148,164,148,164,20,164,20,164,36,164,36,188,36,164,68,164,68,164,68,164,132,164,132,188,243,36,0,36 },
  { 0,0,98,60,150,36,146,36,18,36,18,36,34,36,34,60,34,36,66,36,66,36,66,36,130,36,130,60,247,36,0,36 },
  { 0,0,99,60,148,164,148,164,16,164,16,164,33,36,33,60,33,36,66,36,66,36,66,36,132,36,132,60,247,164,0,36 },
  { 0,0,99,60,148,164,148,164,16,164,16,164,32,164,35,60,32,164,64,164,64,164,64,164,132,164,132,188,243,36,0,36 },
  { 0,0,100,188,148,164,148,164,20,164,20,164,36,164,39,188,32,164,64,164,64,164,64,164,128,164,128,188,240,164,0,36 },
  { 0,0,103,188,148,36,148,36,20,36,20,36,36,36,39,60,32,164,64,164,64,164,64,164,132,164,132,188,243,36,0,36 },
  { 0,0,99,60,148,164,148,164,20,36,20,36,36,36,39,60,36,164,68,164,68,164,68,164,132,164,132,188,243,36,0,36 },
  { 0,0,103,188,144,164,144,164,16,164,17,36,33,36,33,60,34,36,66,36,66,36,66,36,130,36,130,60,242,36,0,36 },
  { 0,0,99,60,148,164,148,164,20,164,20,164,36,164,35,60,36,164,68,164,68,164,68,164,132,164,132,188,243,36,0,36 },
  { 0,0,99,60,148,164,148,164,20,164,20,164,36,164,35,60,32,164,64,164,64,164,64,164,132,164,132,188,243,36,0,36 },
  { 0,0,99,60,148,164,148,164,20,164,20,164,20,164,100,188,20,164,20,164,20,164,20,164,148,164,148,188,99,36,0,36 },
  { 0,0,98,60,150,36,146,36,18,36,18,36,18,36,98,60,18,36,18,36,18,36,18,36,146,36,146,60,103,36,0,36 },
  { 0,0,0,0,0,12,0,4,0,4,8,4,105,196,146,36,144,36,145,228,98,36,66,36,114,100,137,174,136,0,112,0 },
  { 4,64,4,64,4,64,4,64,4,64,4,64,124,124,4,64,4,64,4,64,4,64,4,64,4,64,4,64,255,254,0,0 },
  { 0,0,255,254,1,0,1,0,63,248,33,8,33,8,33,8,34,136,34,72,36,40,40,40,32,8,32,8,63,248,32,8 },
  { 1,0,1,0,1,248,63,0,1,4,1,4,0,252,16,0,16,32,16,32,22,60,248,224,16,34,17,34,22,30,24,0 },
  { 1,0,2,128,4,64,8,32,16,16,32,8,64,4,255,254,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0 },
  { 1,0,1,0,1,0,1,0,63,248,1,0,33,0,33,0,65,0,127,254,1,0,1,0,1,0,1,0,1,0,1,0 },
  { 0,0,0,16,0,16,32,32,16,32,8,64,4,64,2,128,1,0,2,128,4,64,8,32,16,16,32,8,64,0,0,0 },
  { 0,16,0,248,31,0,16,0,31,248,16,8,31,248,16,8,31,248,16,0,31,252,16,4,32,4,32,4,64,40,128,16 },
  { 2,0,2,0,63,224,4,32,4,32,8,34,48,34,192,30,0,0,127,240,0,96,1,128,6,0,24,4,32,4,31,252 },
  { 6,0,1,0,2,128,4,64,8,32,48,24,192,6,63,248,0,16,0,96,1,128,6,0,24,4,32,4,31,252,0,0 },
  { 0,0,127,252,1,0,1,0,1,0,1,0,1,0,5,0,2,0,127,240,0,96,1,128,6,0,24,4,32,4,31,252 },
  { 1,0,1,0,1,0,255,254,1,0,1,0,63,248,0,0,0,0,127,240,0,96,1,128,6,0,24,4,32,4,31,252 },
  { 1,0,1,0,1,0,63,248,1,0,1,0,255,254,0,0,0,0,127,240,0,96,1,128,6,0,24,4,32,4,31,252 },
  { 8,0,8,0,31,252,32,0,65,0,129,0,17,112,19,144,29,16,241,16,17,80,17,34,17,2,16,2,15,254,0,0 },
  { 0,252,127,0,2,8,33,8,17,16,16,32,0,0,63,248,0,16,0,96,1,128,6,0,24,4,32,4,31,252,0,0 },
  { 2,0,1,0,127,252,8,32,4,64,3,128,28,112,224,14,0,0,63,248,0,16,0,96,3,128,28,4,32,4,31,252 },
  { 0,0,63,252,1,0,1,0,31,240,2,16,4,16,127,254,0,0,127,240,0,96,1,128,6,0,24,4,32,4,31,252 },
  { 16,0,16,0,254,252,34,132,68,136,40,80,16,32,40,88,197,134,0,0,127,240,0,96,3,128,28,4,32,4,31,252 },
  { 8,0,31,240,40,32,7,192,24,48,225,142,12,64,3,0,0,128,127,240,0,96,1,128,6,0,24,4,32,4,31,252 },
  { 0,0,127,248,4,8,8,80,48,32,223,248,16,8,16,8,31,248,0,0,127,240,0,96,3,128,28,4,32,4,31,252 },
  { 0,0,255,254,0,16,31,144,16,144,16,144,31,144,0,80,0,32,127,240,0,96,1,128,6,0,24,4,32,4,31,252 },
  { 2,0,1,0,255,254,0,0,31,240,16,16,16,16,31,240,0,0,127,240,0,96,1,128,6,0,24,4,32,4,31,252 },
  { 1,0,1,0,63,248,33,8,33,8,63,248,33,8,33,8,63,248,0,0,127,240,0,96,3,128,28,4,32,4,31,252 },
  { 8,32,8,32,8,32,255,160,8,32,8,32,127,32,0,32,0,32,127,32,65,32,65,34,65,34,127,34,65,30,0,0 },
  { 2,8,63,208,2,32,255,254,2,0,12,112,63,132,200,4,7,252,0,0,127,240,0,96,3,128,28,4,32,4,31,252 },
  { 1,0,17,16,9,32,255,254,5,64,9,32,49,24,193,6,0,0,127,240,0,96,1,128,6,0,24,4,32,4,31,252 },
  { 0,0,127,252,0,0,31,240,16,16,31,240,8,32,4,64,255,254,0,0,127,240,0,96,3,128,28,4,32,4,31,252 },
  { 127,252,2,0,63,240,4,16,255,254,0,0,31,240,16,16,31,240,0,0,127,240,0,96,3,128,28,4,32,4,31,252 },
  { 8,64,8,64,23,252,48,128,81,0,147,248,21,8,17,8,17,248,0,0,127,240,0,96,3,128,28,4,32,4,31,252 },
  { 16,64,20,64,18,64,16,64,254,248,16,72,16,72,146,72,84,72,16,72,56,72,84,138,146,138,17,10,82,6,36,0 },
  { 17,0,17,0,249,248,18,8,25,232,49,40,209,232,16,8,80,80,32,32,127,240,0,96,3,128,28,4,32,4,31,252 },
  { 8,32,8,32,127,252,8,32,15,224,8,32,15,224,8,32,255,254,16,16,47,232,64,68,131,130,12,8,16,8,15,248 },
  { 4,64,4,64,124,124,4,64,60,120,4,64,124,124,4,64,4,64,127,240,0,96,1,128,6,0,24,4,32,4,31,252 },
  { 7,160,248,32,72,160,37,32,127,32,2,32,7,162,252,34,68,34,12,30,0,0,63,240,1,192,30,4,32,4,31,252 },
  { 32,0,39,252,32,64,35,248,250,168,42,168,42,168,42,24,40,64,47,252,40,160,41,18,42,10,72,2,71,254,128,0 },
  { 32,60,23,192,130,68,73,40,19,248,224,16,39,254,32,32,32,160,0,64,127,240,0,96,3,128,28,4,32,4,31,252 },
  { 0,128,63,254,32,128,47,248,32,128,39,240,36,144,39,240,36,144,63,252,32,128,47,248,64,96,67,128,132,4,3,252 },
  { 32,64,35,248,32,64,33,240,249,16,41,240,41,16,41,240,41,16,41,240,41,16,43,250,40,162,73,18,71,254,128,0 },
  { 16,8,41,200,69,94,185,74,17,202,125,74,17,202,85,82,61,106,227,132,0,0,63,240,1,192,30,4,32,4,31,252 },
  { 59,184,34,8,59,184,36,136,255,254,16,80,39,136,193,6,31,240,1,0,3,0,63,240,1,192,30,4,32,4,31,252 },
  { 0,128,16,128,8,128,4,128,4,128,0,128,127,252,1,132,2,136,4,144,8,128,48,128,192,128,0,128,2,128,1,0 },
  { 0,0,124,252,4,4,40,40,16,16,8,8,254,254,18,18,20,20,16,16,16,16,16,16,16,16,16,16,80,80,32,32 },
  { 36,36,36,36,36,36,36,36,126,126,36,36,36,36,36,36,254,254,36,36,36,36,36,36,36,36,68,68,68,68,132,132 },
  { 2,0,1,0,1,0,255,254,0,0,1,0,33,8,33,8,33,8,33,8,63,248,2,136,4,64,8,32,48,24,192,6 },
  { 2,0,1,0,1,0,255,254,0,0,8,32,4,64,34,136,33,8,34,136,36,72,40,40,32,8,32,8,63,248,0,8 },
  { 2,0,1,0,255,254,4,0,8,32,16,16,63,248,16,8,0,0,17,16,17,16,17,16,33,16,33,18,65,18,128,14 },
  { 2,0,1,0,255,254,0,0,0,0,63,248,32,8,32,8,39,200,36,72,36,72,39,200,32,8,32,8,63,248,32,8 },
  { 2,0,1,0,255,254,16,16,36,72,68,68,31,240,4,64,31,240,4,64,127,252,4,144,12,96,53,24,198,6,4,0 },
  { 1,0,127,252,8,32,31,240,16,16,31,240,0,0,31,224,1,0,127,252,9,32,63,248,200,38,15,224,8,32,15,224 },
  { 8,0,9,252,9,4,17,4,17,4,49,4,49,4,81,4,145,4,17,4,17,4,17,4,17,4,17,252,17,4,16,0 },
  { 1,0,1,0,2,128,4,64,8,32,16,80,33,136,198,6,56,32,0,192,7,0,56,24,0,96,3,128,124,0,0,0 },
  { 8,64,8,64,8,64,16,64,16,64,55,254,48,64,80,64,144,64,16,160,16,160,16,144,17,16,17,8,18,4,20,2 },
  { 8,0,8,0,11,252,16,144,16,144,48,144,48,144,80,144,144,144,16,144,16,144,16,146,17,18,17,18,18,14,20,0 },
  { 8,128,8,128,8,128,16,252,17,4,49,4,50,132,84,72,144,40,16,16,16,16,16,32,16,64,16,128,17,0,22,0 },
  { 8,0,11,252,8,64,16,64,16,64,48,64,63,254,80,64,144,64,16,64,16,64,16,64,16,64,16,64,17,64,16,128 },
  { 8,0,8,0,11,252,18,4,18,4,50,4,50,4,83,252,146,4,18,0,18,0,18,2,18,2,18,2,17,254,16,0 },
  { 8,0,15,240,8,16,16,16,18,16,50,16,50,16,83,252,144,4,16,4,16,4,23,244,16,4,16,4,16,40,16,16 },
  { 8,128,8,128,8,128,16,252,17,4,49,8,50,64,84,64,144,64,16,160,16,160,16,144,17,16,17,8,18,4,20,2 },
  { 9,0,9,0,9,252,18,0,20,0,49,248,48,0,80,0,147,248,16,8,16,8,16,8,16,10,16,10,16,6,16,2 },
  { 17,32,17,32,17,32,34,32,34,32,102,32,102,32,170,32,34,32,34,80,34,80,34,80,34,72,34,136,34,132,35,2 },
  { 8,32,8,32,8,32,16,32,19,254,50,34,50,34,82,34,146,82,18,74,18,138,19,2,18,2,18,2,18,10,18,4 },
  { 8,8,8,104,11,136,16,136,16,136,48,136,48,136,83,254,144,136,16,136,16,136,16,136,17,8,17,8,18,8,20,8 },
  { 8,0,11,248,10,8,18,8,19,40,50,168,50,168,82,72,146,72,18,168,18,168,19,42,20,10,20,10,24,6,16,2 },
  { 8,0,8,0,11,248,16,0,16,0,48,0,55,252,81,32,145,32,17,32,17,32,17,32,18,34,18,34,20,30,24,0 },
  { 8,16,8,120,11,192,16,64,16,64,51,248,48,64,80,64,144,64,23,254,16,64,16,64,16,64,16,64,17,64,16,128 },
  { 8,64,8,64,8,64,16,64,23,254,48,64,48,64,80,160,144,160,16,160,17,16,17,16,18,136,18,72,20,68,24,2 },
  { 8,64,8,64,10,72,18,72,18,72,50,72,51,248,80,72,144,64,16,64,20,68,20,68,20,68,20,68,23,252,16,4 },
  { 16,0,23,252,16,64,32,64,32,64,103,252,100,68,164,68,36,164,36,148,37,20,38,4,36,4,36,4,36,20,36,8 },
  { 18,32,18,32,18,32,36,32,37,124,105,36,110,36,162,36,36,36,36,36,41,36,47,36,33,68,32,68,32,148,33,8 },
  { 8,0,9,248,9,8,17,72,17,40,49,40,55,254,82,8,146,72,18,40,18,40,19,254,16,8,16,8,16,80,16,32 },
  { 9,0,9,0,9,0,17,254,18,64,50,64,52,64,80,64,144,124,16,64,16,64,16,64,16,64,16,64,23,254,16,0 },
  { 8,0,11,252,10,4,18,4,18,4,50,4,51,252,80,144,144,144,16,144,16,144,17,18,17,18,18,18,20,14,24,0 },
  { 8,128,8,128,8,248,17,8,18,16,52,32,51,252,80,4,144,4,16,4,17,252,16,4,16,4,16,4,19,252,16,4 },
  { 8,64,8,64,8,64,23,254,16,128,49,32,49,32,82,32,147,252,16,32,17,40,17,36,18,34,20,34,16,160,16,64 },
  { 16,0,23,248,20,8,36,8,39,248,100,136,100,136,164,232,37,40,37,40,38,168,36,74,36,74,40,138,41,6,50,2 },
  { 8,64,8,32,8,32,23,254,16,144,48,144,48,144,82,148,146,146,18,146,20,146,16,144,17,16,17,16,18,80,20,32 },
  { 16,160,16,160,16,160,32,160,39,252,100,164,100,164,164,164,36,164,39,252,36,164,36,164,36,164,36,164,39,252,36,4 },
  { 8,0,11,254,10,0,18,0,19,252,50,32,50,32,82,248,146,32,18,32,18,32,19,252,18,0,18,0,19,254,16,0 },
  { 16,64,16,64,23,252,32,64,32,64,99,248,96,64,160,64,39,254,32,224,33,80,33,80,34,72,36,68,40,66,32,6