#version 460 core

/*
--------------------------------------------------------------------------------

	Revelation Shaders

	Copyright (C) 2024 HaringPro
	Apache License 2.0

--------------------------------------------------------------------------------
*/

//======// Output //==============================================================================//

/* RENDERTARGETS: 6 */
out vec4 albedoOut;

//======// Input //===============================================================================//

in vec3 vertColor;
in vec2 texCoord;

//======// Uniform //=============================================================================//

uniform sampler2D tex;

//======// Main //================================================================================//
void main() {
	vec4 albedo = texture(tex, texCoord);

	if (albedo.a < 0.1) { discard; return; }

	albedoOut = vec4(albedo.rgb * vertColor, 1.0);
}