/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.service.repository.CommonPersistService;
import com.alibaba.nacos.console.model.Namespace;
import com.alibaba.nacos.console.model.NamespaceAllInfo;
import com.alibaba.nacos.console.service.NamespaceOperationService;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/console/namespaces"})
public class NamespaceController {
    @Autowired
    private CommonPersistService commonPersistService;
    @Autowired
    private NamespaceOperationService namespaceOperationService;
    private final Pattern namespaceIdCheckPattern = Pattern.compile("^[\\w-]+");
    private static final int NAMESPACE_ID_MAX_LENGTH = 128;

    @GetMapping
    public RestResult<List<Namespace>> getNamespaces() {
        return RestResultUtils.success((Object)this.namespaceOperationService.getNamespaceList());
    }

    @GetMapping(params={"show=all"})
    public NamespaceAllInfo getNamespace(@RequestParam(value="namespaceId") String namespaceId) throws NacosException {
        return this.namespaceOperationService.getNamespace(namespaceId);
    }

    @PostMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE)
    public Boolean createNamespace(@RequestParam(value="customNamespaceId") String namespaceId, @RequestParam(value="namespaceName") String namespaceName, @RequestParam(value="namespaceDesc", required=false) String namespaceDesc) {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = UUID.randomUUID().toString();
        } else {
            if (!this.namespaceIdCheckPattern.matcher(namespaceId = namespaceId.trim()).matches()) {
                return false;
            }
            if (namespaceId.length() > 128) {
                return false;
            }
        }
        try {
            return this.namespaceOperationService.createNamespace(namespaceId, namespaceName, namespaceDesc);
        }
        catch (NacosException e) {
            return false;
        }
    }

    @GetMapping(params={"checkNamespaceIdExist=true"})
    public Boolean checkNamespaceIdExist(@RequestParam(value="customNamespaceId") String namespaceId) {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            return false;
        }
        return this.commonPersistService.tenantInfoCountByTenantId(namespaceId) > 0;
    }

    @PutMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE)
    public Boolean editNamespace(@RequestParam(value="namespace") String namespace, @RequestParam(value="namespaceShowName") String namespaceShowName, @RequestParam(value="namespaceDesc", required=false) String namespaceDesc) {
        return this.namespaceOperationService.editNamespace(namespace, namespaceShowName, namespaceDesc);
    }

    @DeleteMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE)
    public Boolean deleteNamespace(@RequestParam(value="namespaceId") String namespaceId) {
        return this.namespaceOperationService.removeNamespace(namespaceId);
    }
}

