/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#pragma once

// Anet ET4/ET5 Black Theme

#define COLOR_RED2              0xF003 // #F70019
#define COLOR_ORANGE2           0xFDE0 // #FFBE00
#define COLOR_LIME2             0xA7E0 // #A5FF00
#define COLOR_BLACK2            0x2124 // #212421

#define COLOR_BACKGROUND        COLOR_BLACK2
#define COLOR_SELECTION_BG      COLOR_ORANGE2
#define COLOR_COLD              COLOR_WHITE
#define COLOR_HOTEND            COLOR_RED2
#define COLOR_HEATED_BED        COLOR_RED2
#define COLOR_CHAMBER           COLOR_WHITE
#define COLOR_FAN               COLOR_WHITE
#define COLOR_AXIS_FRAME        COLOR_WHITE
#define COLOR_AXIS_HOMED        COLOR_ORANGE2
#define COLOR_AXIS_NOT_HOMED    COLOR_ORANGE2
#define COLOR_RATE_100          COLOR_LIME2
#define COLOR_RATE_ALTERED      COLOR_ORANGE2
#define COLOR_PRINT_TIME        COLOR_WHITE
#define COLOR_PROGRESS_BAR      COLOR_ORANGE2
#define COLOR_STATUS_MESSAGE    COLOR_ORANGE2
#define COLOR_SD_ENABLED        COLOR_CONTROL_ENABLED
#define COLOR_SD_DISABLED       COLOR_CONTROL_DISABLED
#define COLOR_MENU_TEXT         COLOR_WHITE
#define COLOR_MENU_STATIC_TEXT  COLOR_WHITE
#define COLOR_MENU_INVERT_TEXT  COLOR_YELLOW
#define COLOR_MENU_BACK_TEXT    COLOR_YELLOW
#define COLOR_MENU_EDIT_TEXT    COLOR_LIME2
#define COLOR_MENU_VALUE_FONT   COLOR_ORANGE2
#define COLOR_SLIDER            COLOR_ORANGE2
#define COLOR_INCREASE          COLOR_WHITE
#define COLOR_DECREASE          COLOR_WHITE
#define COLOR_TICK              COLOR_VIVID_GREEN
