/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Vietnamese 48pt, capital 'A' height: 30px, width: 100%, range: 0x0102-0x1ef9, glyphs: 107
extern const uint8_t Unifont_Vietnamese_30[12660] = {
  161,30,2,1,249,30,42,250, // unifont_t
  // 0x0102  Ă
  2,1,18,42,126,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0103  ă
  3,1,18,39,117,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x0110  Đ
  16,1,21,30,90,24,0,0,31,254,0,31,254,0,31,254,0,28,1,192,28,1,192,28,1,192,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,255,240,56,255,240,56,255,240,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,1,192,28,1,192,28,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0111  đ
  17,1,21,33,99,24,3,0,0,1,192,0,1,192,0,1,192,0,127,248,0,127,248,0,127,248,0,1,192,0,1,192,0,1,192,31,241,192,31,241,192,31,241,192,224,15,192,224,15,192,224,15,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x0128  Ĩ
  40,1,18,42,126,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,192,31,255,192,31,255,192,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,255,192,31,255,192,31,255,192,
  // 0x0129  ĩ
  41,1,18,36,108,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,240,0,3,240,0,3,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,255,192,31,255,192,31,255,192,
  // 0x0168  Ũ
  104,1,18,42,126,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0169  ũ
  105,1,18,36,108,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x01a0  Ơ
  160,1,18,33,99,24,3,0,0,1,192,0,1,192,0,1,192,31,241,192,31,241,192,31,241,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x01a1  ơ
  161,1,18,27,81,24,3,0,0,1,192,0,1,192,0,1,192,31,241,192,31,241,192,31,241,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x01af  Ư
  175,1,21,36,108,24,3,0,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x01b0  ư
  176,1,21,30,90,24,3,0,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,126,0,224,126,0,224,126,0,31,142,0,31,142,0,31,142,0,
  // 0x0303  ̃
  3,3,18,6,18,0,235,33,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,
  // 0x0309  ̉
  9,3,12,15,30,0,238,27,31,128,31,128,31,128,224,112,224,112,224,112,0,112,0,112,0,112,3,128,3,128,3,128,3,128,3,128,3,128,
  // 0x0323  ̣
  35,3,6,6,6,0,241,250,252,252,252,252,252,252,
  // 0x0340  ̀
  64,3,9,9,18,0,235,30,224,0,224,0,224,0,28,0,28,0,28,0,3,128,3,128,3,128,
  // 0x0341  ́
  65,3,9,9,18,0,244,30,3,128,3,128,3,128,28,0,28,0,28,0,224,0,224,0,224,0,
  // 0x1ea0  Ạ
  160,30,15,36,72,24,3,250,3,128,3,128,3,128,28,112,28,112,28,112,28,112,28,112,28,112,224,14,224,14,224,14,224,14,224,14,224,14,255,254,255,254,255,254,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,0,0,0,0,0,0,3,128,3,128,3,128,
  // 0x1ea1  ạ
  161,30,18,30,90,24,3,250,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,0,0,0,0,0,0,0,0,0,3,128,0,3,128,0,3,128,0,
  // 0x1ea2  Ả
  162,30,18,42,126,24,3,0,224,0,0,224,0,0,224,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x1ea3  ả
  163,30,18,39,117,24,3,0,0,112,0,0,112,0,0,112,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x1ea4  Ấ
  164,30,18,42,126,24,3,0,0,1,192,0,1,192,0,1,192,3,142,0,3,142,0,3,142,0,28,112,0,28,112,0,28,112,0,224,14,0,224,14,0,224,14,0,3,128,0,3,128,0,3,128,0,28,112,0,28,112,0,28,112,0,28,112,0,28,112,0,28,112,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,255,254,0,255,254,0,255,254,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,
  // 0x1ea5  ấ
  165,30,18,39,117,24,3,0,0,1,192,0,1,192,0,1,192,3,142,0,3,142,0,3,142,0,28,112,0,28,112,0,28,112,0,224,14,0,224,14,0,224,14,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x1ea6  Ầ
  166,30,18,42,126,24,3,0,224,0,0,224,0,0,224,0,0,28,112,0,28,112,0,28,112,0,3,142,0,3,142,0,3,142,0,28,1,192,28,1,192,28,1,192,0,112,0,0,112,0,0,112,0,3,142,0,3,142,0,3,142,0,3,142,0,3,142,0,3,142,0,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,31,255,192,31,255,192,31,255,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,
  // 0x1ea7  ầ
  167,30,18,39,117,24,3,0,224,0,0,224,0,0,224,0,0,28,112,0,28,112,0,28,112,0,3,142,0,3,142,0,3,142,0,28,1,192,28,1,192,28,1,192,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x1ea8  Ẩ
  168,30,18,42,126,24,3,0,0,14,0,0,14,0,0,14,0,0,1,192,0,1,192,0,1,192,3,142,0,3,142,0,3,142,0,28,112,0,28,112,0,28,112,0,227,142,0,227,142,0,227,142,0,28,112,0,28,112,0,28,112,0,28,112,0,28,112,0,28,112,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,255,254,0,255,254,0,255,254,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,
  // 0x1ea9  ẩ
  169,30,21,42,126,24,3,0,0,1,192,0,1,192,0,1,192,0,0,56,0,0,56,0,0,56,0,113,192,0,113,192,0,113,192,3,142,0,3,142,0,3,142,0,28,1,192,28,1,192,28,1,192,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x1eaa  Ẫ
  170,30,18,42,126,24,6,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,3,128,0,3,128,0,3,128,0,28,112,0,28,112,0,28,112,0,224,14,0,224,14,0,224,14,0,3,128,0,3,128,0,3,128,0,28,112,0,28,112,0,28,112,0,28,112,0,28,112,0,28,112,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,255,254,0,255,254,0,255,254,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,
  // 0x1eab  ẫ
  171,30,21,42,126,24,3,0,3,240,56,3,240,56,3,240,56,28,15,192,28,15,192,28,15,192,0,112,0,0,112,0,0,112,0,3,142,0,3,142,0,3,142,0,28,1,192,28,1,192,28,1,192,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x1eac  Ậ
  172,30,15,45,90,24,6,250,3,128,3,128,3,128,28,112,28,112,28,112,224,14,224,14,224,14,3,128,3,128,3,128,28,112,28,112,28,112,28,112,28,112,28,112,224,14,224,14,224,14,224,14,224,14,224,14,255,254,255,254,255,254,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,0,0,0,0,0,0,3,128,3,128,3,128,
  // 0x1ead  ậ
  173,30,18,42,126,24,3,250,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,0,0,0,0,0,0,0,0,0,0,112,0,0,112,0,0,112,0,
  // 0x1eae  Ắ
  174,30,15,42,84,24,3,0,0,112,0,112,0,112,3,128,3,128,3,128,224,14,224,14,224,14,31,240,31,240,31,240,3,128,3,128,3,128,28,112,28,112,28,112,28,112,28,112,28,112,224,14,224,14,224,14,224,14,224,14,224,14,255,254,255,254,255,254,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,
  // 0x1eaf  ắ
  175,30,18,42,126,24,3,0,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x1eb0  Ằ
  176,30,15,42,84,24,3,0,28,0,28,0,28,0,3,128,3,128,3,128,224,14,224,14,224,14,31,240,31,240,31,240,3,128,3,128,3,128,28,112,28,112,28,112,28,112,28,112,28,112,224,14,224,14,224,14,224,14,224,14,224,14,255,254,255,254,255,254,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,
  // 0x1eb1  ằ
  177,30,18,42,126,24,3,0,28,0,0,28,0,0,28,0,0,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,28,1,192,28,1,192,28,1,192,3,254,0,3,254,0,3,254,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x1eb2  Ẳ
  178,30,21,42,126,24,0,0,0,112,0,0,112,0,0,112,0,0,14,0,0,14,0,0,14,0,227,240,56,227,240,56,227,240,56,31,255,192,31,255,192,31,255,192,0,112,0,0,112,0,0,112,0,3,142,0,3,142,0,3,142,0,3,142,0,3,142,0,3,142,0,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,31,255,192,31,255,192,31,255,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,
  // 0x1eb3  ẳ
  179,30,18,42,126,24,3,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x1eb4  Ẵ
  180,30,21,42,126,24,0,0,3,240,56,3,240,56,3,240,56,28,15,192,28,15,192,28,15,192,224,0,56,224,0,56,224,0,56,31,255,192,31,255,192,31,255,192,0,112,0,0,112,0,0,112,0,3,142,0,3,142,0,3,142,0,3,142,0,3,142,0,3,142,0,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,31,255,192,31,255,192,31,255,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,
  // 0x1eb5  ẵ
  181,30,18,42,126,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x1eb6  Ặ
  182,30,15,42,84,24,3,250,224,14,224,14,224,14,31,240,31,240,31,240,3,128,3,128,3,128,28,112,28,112,28,112,28,112,28,112,28,112,224,14,224,14,224,14,224,14,224,14,224,14,255,254,255,254,255,254,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,0,0,0,0,0,0,3,128,3,128,3,128,
  // 0x1eb7  ặ
  183,30,18,39,117,24,3,250,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,0,0,0,0,0,0,0,0,0,3,128,0,3,128,0,3,128,0,
  // 0x1eb8  Ẹ
  184,30,18,36,108,24,3,250,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,0,0,0,0,0,0,0,0,0,3,128,0,3,128,0,3,128,0,
  // 0x1eb9  ẹ
  185,30,18,30,90,24,3,250,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,3,128,0,3,128,0,3,128,0,
  // 0x1eba  Ẻ
  186,30,18,42,126,24,3,0,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x1ebb  ẻ
  187,30,18,42,126,24,3,0,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ebc  Ẽ
  188,30,18,39,117,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x1ebd  ẽ
  189,30,18,33,99,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ebe  Ế
  190,30,18,42,126,24,3,0,0,1,192,0,1,192,0,1,192,3,142,0,3,142,0,3,142,0,28,112,0,28,112,0,28,112,0,224,14,0,224,14,0,224,14,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x1ebf  ế
  191,30,18,39,117,24,3,0,0,1,192,0,1,192,0,1,192,3,142,0,3,142,0,3,142,0,28,112,0,28,112,0,28,112,0,224,14,0,224,14,0,224,14,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ec0  Ề
  192,30,18,42,126,24,3,0,224,0,0,224,0,0,224,0,0,28,112,0,28,112,0,28,112,0,3,142,0,3,142,0,3,142,0,28,1,192,28,1,192,28,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x1ec1  ề
  193,30,18,39,117,24,3,0,224,0,0,224,0,0,224,0,0,28,112,0,28,112,0,28,112,0,3,142,0,3,142,0,3,142,0,28,1,192,28,1,192,28,1,192,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ec2  Ể
  194,30,18,42,126,24,3,0,0,14,0,0,14,0,0,14,0,3,129,192,3,129,192,3,129,192,28,113,192,28,113,192,28,113,192,224,14,0,224,14,0,224,14,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x1ec3  ể
  195,30,18,42,126,24,3,0,0,14,0,0,14,0,0,14,0,0,1,192,0,1,192,0,1,192,3,129,192,3,129,192,3,129,192,28,126,0,28,126,0,28,126,0,224,14,0,224,14,0,224,14,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ec4  Ễ
  196,30,18,42,126,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,3,128,0,3,128,0,3,128,0,28,112,0,28,112,0,28,112,0,224,14,0,224,14,0,224,14,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x1ec5  ễ
  197,30,18,42,126,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,3,128,0,3,128,0,3,128,0,28,112,0,28,112,0,28,112,0,224,14,0,224,14,0,224,14,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ec6  Ệ
  198,30,18,45,135,24,3,250,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,0,0,0,0,0,0,0,0,0,0,112,0,0,112,0,0,112,0,
  // 0x1ec7  ệ
  199,30,18,42,126,24,3,250,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,112,0,0,112,0,0,112,0,
  // 0x1ec8  Ỉ
  200,30,15,42,84,24,6,0,3,128,3,128,3,128,0,112,0,112,0,112,0,112,0,112,0,112,3,128,3,128,3,128,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x1ec9  ỉ
  201,30,15,39,78,24,6,0,28,0,28,0,28,0,3,128,3,128,3,128,3,128,3,128,3,128,28,0,28,0,28,0,0,0,0,0,0,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x1eca  Ị
  202,30,15,36,72,24,6,250,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,0,0,0,0,0,0,3,128,3,128,3,128,
  // 0x1ecb  ị
  203,30,15,39,78,24,6,250,3,128,3,128,3,128,3,128,3,128,3,128,0,0,0,0,0,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,0,0,0,0,0,0,3,128,3,128,3,128,
  // 0x1ecc  Ọ
  204,30,18,36,108,24,3,250,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,112,0,0,112,0,0,112,0,
  // 0x1ecd  ọ
  205,30,18,30,90,24,3,250,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,112,0,0,112,0,0,112,0,
  // 0x1ece  Ỏ
  206,30,18,42,126,24,3,0,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ecf  ỏ
  207,30,18,39,117,24,3,0,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ed0  Ố
  208,30,18,42,126,24,3,0,0,1,192,0,1,192,0,1,192,3,142,0,3,142,0,3,142,0,28,112,0,28,112,0,28,112,0,224,14,0,224,14,0,224,14,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ed1  ố
  209,30,18,39,117,24,3,0,0,1,192,0,1,192,0,1,192,3,142,0,3,142,0,3,142,0,28,112,0,28,112,0,28,112,0,224,14,0,224,14,0,224,14,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ed2  Ồ
  210,30,18,42,126,24,3,0,224,0,0,224,0,0,224,0,0,28,112,0,28,112,0,28,112,0,3,142,0,3,142,0,3,142,0,28,1,192,28,1,192,28,1,192,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ed3  ồ
  211,30,18,39,117,24,3,0,224,0,0,224,0,0,224,0,0,28,112,0,28,112,0,28,112,0,3,142,0,3,142,0,3,142,0,28,1,192,28,1,192,28,1,192,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ed4  Ổ
  212,30,18,42,126,24,3,0,0,14,0,0,14,0,0,14,0,3,129,192,3,129,192,3,129,192,28,113,192,28,113,192,28,113,192,224,14,0,224,14,0,224,14,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ed5  ổ
  213,30,18,42,126,24,3,0,0,14,0,0,14,0,0,14,0,0,1,192,0,1,192,0,1,192,3,129,192,3,129,192,3,129,192,28,126,0,28,126,0,28,126,0,224,14,0,224,14,0,224,14,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ed6  Ỗ
  214,30,18,42,126,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,3,128,0,3,128,0,3,128,0,28,112,0,28,112,0,28,112,0,224,14,0,224,14,0,224,14,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ed7  ỗ
  215,30,18,42,126,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,3,128,0,3,128,0,3,128,0,28,112,0,28,112,0,28,112,0,224,14,0,224,14,0,224,14,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ed8  Ộ
  216,30,18,45,135,24,3,250,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,112,0,0,112,0,0,112,0,
  // 0x1ed9  ộ
  217,30,18,42,126,24,3,250,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,112,0,0,112,0,0,112,0,
  // 0x1eda  Ớ
  218,30,21,42,126,24,3,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,28,1,192,28,1,192,28,1,192,0,0,56,0,0,56,0,0,56,31,240,56,31,240,56,31,240,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x1edb  ớ
  219,30,21,36,108,24,3,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,28,1,192,28,1,192,28,1,192,0,0,56,0,0,56,0,0,56,31,240,56,31,240,56,31,240,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x1edc  Ờ
  220,30,21,42,126,24,3,0,28,0,0,28,0,0,28,0,0,3,128,0,3,128,0,3,128,0,0,113,192,0,113,192,0,113,192,0,0,56,0,0,56,0,0,56,31,240,56,31,240,56,31,240,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x1edd  ờ
  221,30,21,36,108,24,3,0,28,0,0,28,0,0,28,0,0,3,128,0,3,128,0,3,128,0,0,113,192,0,113,192,0,113,192,0,0,56,0,0,56,0,0,56,31,240,56,31,240,56,31,240,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x1ede  Ở
  222,30,21,42,126,24,3,0,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,0,113,192,0,113,192,0,113,192,3,128,56,3,128,56,3,128,56,31,240,56,31,240,56,31,240,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x1edf  ở
  223,30,21,39,117,24,3,0,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,129,192,3,129,192,3,129,192,0,0,56,0,0,56,0,0,56,31,240,56,31,240,56,31,240,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x1ee0  Ỡ
  224,30,21,39,117,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,1,192,0,1,192,0,1,192,31,240,56,31,240,56,31,240,56,224,14,56,224,14,56,224,14,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x1ee1  ỡ
  225,30,21,39,117,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,1,192,0,1,192,0,1,192,0,0,56,0,0,56,0,0,56,31,240,56,31,240,56,31,240,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x1ee2  Ợ
  226,30,21,42,126,24,3,250,0,1,192,0,1,192,0,1,192,0,0,56,0,0,56,0,0,56,31,240,56,31,240,56,31,240,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,0,0,0,0,0,0,0,0,0,3,128,0,3,128,0,3,128,0,
  // 0x1ee3  ợ
  227,30,21,36,108,24,3,250,0,1,192,0,1,192,0,1,192,0,0,56,0,0,56,0,0,56,31,240,56,31,240,56,31,240,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,0,0,0,0,0,0,0,0,0,3,128,0,3,128,0,3,128,0,
  // 0x1ee4  Ụ
  228,30,18,36,108,24,3,250,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,112,0,0,112,0,0,112,0,
  // 0x1ee5  ụ
  229,30,18,30,90,24,3,250,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,0,0,0,0,0,0,0,0,0,0,112,0,0,112,0,0,112,0,
  // 0x1ee6  Ủ
  230,30,18,42,126,24,3,0,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ee7  ủ
  231,30,18,39,117,24,3,0,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x1ee8  Ứ
  232,30,21,42,126,24,3,0,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,3,129,192,3,129,192,3,129,192,0,0,56,0,0,56,0,0,56,224,14,56,224,14,56,224,14,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x1ee9  ứ
  233,30,21,36,108,24,3,0,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,3,129,192,3,129,192,3,129,192,0,0,56,0,0,56,0,0,56,224,14,56,224,14,56,224,14,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,126,0,224,126,0,224,126,0,31,142,0,31,142,0,31,142,0,
  // 0x1eea  Ừ
  234,30,21,42,126,24,3,0,224,0,0,224,0,0,224,0,0,28,0,0,28,0,0,28,0,0,3,129,192,3,129,192,3,129,192,0,0,56,0,0,56,0,0,56,224,14,56,224,14,56,224,14,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x1eeb  ừ
  235,30,21,36,108,24,3,0,224,0,0,224,0,0,224,0,0,28,0,0,28,0,0,28,0,0,3,129,192,3,129,192,3,129,192,0,0,56,0,0,56,0,0,56,224,14,56,224,14,56,224,14,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,126,0,224,126,0,224,126,0,31,142,0,31,142,0,31,142,0,
  // 0x1eec  Ử
  236,30,21,42,126,24,3,0,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,0,113,192,0,113,192,0,113,192,3,128,56,3,128,56,3,128,56,224,14,56,224,14,56,224,14,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x1eed  ử
  237,30,21,39,117,24,3,0,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,129,192,3,129,192,3,129,192,0,0,56,0,0,56,0,0,56,224,14,56,224,14,56,224,14,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,126,0,224,126,0,224,126,0,31,142,0,31,142,0,31,142,0,
  // 0x1eee  Ữ
  238,30,21,42,126,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,1,192,0,1,192,0,1,192,0,0,56,0,0,56,0,0,56,224,14,56,224,14,56,224,14,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x1eef  ữ
  239,30,21,39,117,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,1,192,0,1,192,0,1,192,0,0,56,0,0,56,0,0,56,224,14,56,224,14,56,224,14,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,126,0,224,126,0,224,126,0,31,142,0,31,142,0,31,142,0,
  // 0x1ef0  Ự
  240,30,21,42,126,24,3,250,0,1,192,0,1,192,0,1,192,0,0,56,0,0,56,0,0,56,224,14,56,224,14,56,224,14,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,0,0,0,0,0,0,0,0,0,3,128,0,3,128,0,3,128,0,
  // 0x1ef1  ự
  241,30,21,36,108,24,3,250,0,1,192,0,1,192,0,1,192,0,0,56,0,0,56,0,0,56,224,14,56,224,14,56,224,14,56,224,15,192,224,15,192,224,15,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,126,0,224,126,0,224,126,0,31,142,0,31,142,0,31,142,0,0,0,0,0,0,0,0,0,0,3,128,0,3,128,0,3,128,0,
  // 0x1ef2  Ỳ
  242,30,21,42,126,24,3,0,28,0,0,28,0,0,28,0,0,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,0,0,0,0,0,0,0,0,0,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,3,142,0,3,142,0,3,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x1ef3  ỳ
  243,30,18,45,135,24,3,250,28,0,0,28,0,0,28,0,0,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,28,15,192,28,15,192,28,15,192,3,241,192,3,241,192,3,241,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ef4  Ỵ
  244,30,21,36,108,24,3,250,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,3,142,0,3,142,0,3,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,0,0,0,0,0,0,0,0,0,112,0,0,112,0,0,112,0,
  // 0x1ef5  ỵ
  245,30,18,30,90,24,3,250,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,28,15,192,28,15,192,28,15,192,3,241,192,3,241,192,3,241,192,0,1,192,0,1,192,0,1,192,31,254,0,31,254,0,31,254,0,0,112,0,0,112,0,0,112,0,
  // 0x1ef6  Ỷ
  246,30,21,42,126,24,3,0,0,112,0,0,112,0,0,112,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,3,142,0,3,142,0,3,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x1ef7  ỷ
  247,30,18,45,135,24,3,250,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,28,15,192,28,15,192,28,15,192,3,241,192,3,241,192,3,241,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,31,254,0,31,254,0,31,254,0,
  // 0x1ef8  Ỹ
  248,30,21,39,117,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,3,142,0,3,142,0,3,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x1ef9  ỹ
  249,30,18,42,126,24,3,250,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,28,15,192,28,15,192,28,15,192,3,241,192,3,241,192,3,241,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,31,254,0,31,254,0,31,254,0,
};

#endif // HAS_GRAPHICAL_TFT
