/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Traditional Chinese 48pt, capital 'A' height: 30px, width: 100%, range: 0x22bf-0xff1a, glyphs: 307
extern const uint8_t Unifont_Traditional_Chinese_30[18862] = {
  161,30,191,34,26,255,42,250, // unifont_t
  // 0x22bf  ⊿
  191,34,18,18,54,24,3,0,0,1,192,0,1,192,0,1,192,0,15,192,0,15,192,0,15,192,0,113,192,0,113,192,0,113,192,3,129,192,3,129,192,3,129,192,28,1,192,28,1,192,28,1,192,255,255,192,255,255,192,255,255,192,
  // 0x4e00  一
  0,78,45,3,18,48,0,18,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x4e09  三
  9,78,45,36,216,48,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x4e0a  上
  10,78,45,45,14,48,0,253,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x4e0b  下
  11,78,45,45,14,48,0,250,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x4e0d  不
  13,78,42,45,14,48,0,250,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,63,28,0,0,0,0,63,28,0,0,0,0,63,28,0,0,0,1,199,3,128,0,0,1,199,3,128,0,0,1,199,3,128,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,28,0,7,0,1,192,28,0,7,0,1,192,28,0,7,0,1,192,224,0,7,0,0,0,224,0,7,0,0,0,224,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x4e26  並
  38,78,45,45,14,48,0,253,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,0,113,192,28,14,0,0,113,192,28,14,0,0,113,192,28,14,0,0,113,192,28,112,0,0,113,192,28,112,0,0,113,192,28,112,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x4e2d  中
  45,78,33,48,240,48,6,250,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,
  // 0x4e3b  主
  59,78,45,45,14,48,0,253,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x4e4b  之
  75,78,42,45,14,48,3,253,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,240,0,255,255,255,255,240,0,255,255,255,255,240,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,224,1,255,255,255,192,224,1,255,255,255,192,224,1,255,255,255,192,
  // 0x4ea4  交
  164,78,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,15,192,28,0,0,0,15,192,28,0,0,0,15,192,28,0,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,252,0,0,0,15,248,252,0,0,0,15,248,252,0,0,0,15,248,
  // 0x4eae  亮
  174,78,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,1,255,252,1,192,224,1,255,252,1,192,224,1,255,252,1,192,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,3,240,0,28,0,56,3,240,0,28,0,56,3,240,0,28,0,56,252,0,0,3,255,248,252,0,0,3,255,248,252,0,0,3,255,248,
  // 0x4ee4  令
  228,78,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,56,3,128,0,0,14,56,3,128,0,0,14,56,3,128,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,
  // 0x4ef6  件
  246,78,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,
  // 0x4efd  份
  253,78,45,48,32,48,0,250,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,224,112,0,0,14,0,224,112,0,0,14,0,224,112,0,0,14,0,224,112,0,0,14,0,224,112,0,0,14,0,224,112,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,3,240,7,0,1,192,3,240,7,0,1,192,3,240,7,0,1,192,3,240,56,0,1,192,3,240,56,0,1,192,3,240,56,0,1,192,28,113,199,255,254,56,28,113,199,255,254,56,28,113,199,255,254,56,224,112,0,224,14,0,224,112,0,224,14,0,224,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,0,113,192,0,112,0,0,113,192,0,112,0,0,113,192,0,112,0,
  // 0x4f11  休
  17,79,45,48,32,48,0,250,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,3,240,0,28,0,0,3,240,0,28,0,0,3,240,0,28,0,0,3,240,0,255,128,0,3,240,0,255,128,0,3,240,0,255,128,0,28,112,0,255,128,0,28,112,0,255,128,0,28,112,0,255,128,0,224,112,7,28,112,0,224,112,7,28,112,0,224,112,7,28,112,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,126,0,28,0,56,0,126,0,28,0,56,0,126,0,28,0,56,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,
  // 0x4f4d  位
  77,79,45,48,32,48,0,250,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,14,0,3,240,0,0,14,0,3,240,0,0,14,0,28,112,56,0,14,0,28,112,56,0,14,0,28,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,127,255,255,255,248,0,127,255,255,255,248,0,127,255,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x4f4e  低
  78,79,45,48,32,48,0,250,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,3,255,192,0,14,0,3,255,192,0,14,0,3,255,192,0,14,63,255,128,0,0,14,63,255,128,0,0,14,63,255,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,28,112,63,255,255,248,28,112,63,255,255,248,28,112,63,255,255,248,224,112,56,3,128,0,224,112,56,3,128,0,224,112,56,3,128,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,56,0,112,56,0,112,56,0,112,56,0,112,56,0,112,56,0,14,56,0,112,56,0,14,56,0,112,56,0,14,56,0,112,56,224,14,56,0,112,56,224,14,56,0,112,56,224,14,56,0,112,63,3,129,248,0,112,63,3,129,248,0,112,63,3,129,248,0,112,56,0,112,56,0,112,56,0,112,56,0,112,56,0,112,56,
  // 0x4f5c  作
  92,79,45,48,32,48,0,250,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,112,7,255,255,248,0,112,7,255,255,248,0,112,7,255,255,248,0,112,56,224,0,0,0,112,56,224,0,0,0,112,56,224,0,0,3,240,56,224,0,0,3,240,56,224,0,0,3,240,56,224,0,0,3,241,192,224,0,0,3,241,192,224,0,0,3,241,192,224,0,0,28,112,0,255,254,0,28,112,0,255,254,0,28,112,0,255,254,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,
  // 0x4f9b  供
  155,79,45,48,32,48,0,250,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,3,240,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,28,112,7,0,112,0,28,112,7,0,112,0,28,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,113,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,0,126,0,0,1,192,0,126,0,0,1,192,0,126,0,0,1,192,
  // 0x4fdd  保
  221,79,45,48,32,48,0,250,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,63,255,254,0,0,14,63,255,254,0,0,14,63,255,254,0,0,14,56,0,14,0,0,14,56,0,14,0,0,14,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,3,240,63,255,254,0,3,240,63,255,254,0,3,240,63,255,254,0,3,240,0,28,0,0,3,240,0,28,0,0,3,240,0,28,0,0,28,112,0,28,0,0,28,112,0,28,0,0,28,112,0,28,0,0,224,113,255,255,255,192,224,113,255,255,255,192,224,113,255,255,255,192,0,112,0,255,128,0,0,112,0,255,128,0,0,112,0,255,128,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,126,0,28,0,56,0,126,0,28,0,56,0,126,0,28,0,56,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,
  // 0x4fe1  信
  225,79,45,48,32,48,0,250,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,63,255,255,248,0,14,63,255,255,248,0,14,63,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,240,7,255,255,192,3,240,7,255,255,192,3,240,7,255,255,192,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,224,112,7,255,255,192,224,112,7,255,255,192,224,112,7,255,255,192,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,
  // 0x500b  個
  11,80,42,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,31,129,192,28,1,192,31,129,192,28,1,192,31,129,192,28,1,192,31,129,192,28,1,192,31,129,192,28,1,192,31,129,192,28,1,192,227,129,199,255,241,192,227,129,199,255,241,192,227,129,199,255,241,192,3,129,199,0,113,192,3,129,199,0,113,192,3,129,199,0,113,192,3,129,199,0,113,192,3,129,199,0,113,192,3,129,199,0,113,192,3,129,199,0,113,192,3,129,199,0,113,192,3,129,199,0,113,192,3,129,199,255,241,192,3,129,199,255,241,192,3,129,199,255,241,192,3,129,199,0,113,192,3,129,199,0,113,192,3,129,199,0,113,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,
  // 0x503c  值
  60,80,45,48,32,48,0,250,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,15,255,255,255,192,0,15,255,255,255,192,0,15,255,255,255,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,240,63,255,254,0,3,240,63,255,254,0,3,240,63,255,254,0,3,240,56,0,14,0,3,240,56,0,14,0,3,240,56,0,14,0,28,112,63,255,254,0,28,112,63,255,254,0,28,112,63,255,254,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,127,255,255,255,248,0,127,255,255,255,248,0,127,255,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x504f  偏
  79,80,42,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,31,129,255,255,255,192,31,129,255,255,255,192,31,129,255,255,255,192,31,129,192,0,0,0,31,129,192,0,0,0,31,129,192,0,0,0,227,129,192,0,0,0,227,129,192,0,0,0,227,129,192,0,0,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,248,227,129,192,3,129,248,227,129,192,3,129,248,227,129,192,3,142,56,227,129,192,3,142,56,227,129,192,3,142,56,227,129,192,3,142,63,255,255,192,3,142,63,255,255,192,3,142,63,255,255,192,3,142,56,227,129,192,3,142,56,227,129,192,3,142,56,227,129,192,3,142,56,227,129,192,3,142,56,227,129,192,3,142,56,227,129,192,3,240,56,227,129,192,3,240,56,227,129,192,3,240,56,227,129,192,3,128,56,0,15,192,3,128,56,0,15,192,3,128,56,0,15,192,
  // 0x505c  停
  92,80,45,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,31,128,56,0,14,0,31,128,56,0,14,0,31,128,56,0,14,0,31,128,63,255,254,0,31,128,63,255,254,0,31,128,63,255,254,0,227,128,0,0,0,0,227,128,0,0,0,0,227,128,0,0,0,0,3,143,255,255,255,248,3,143,255,255,255,248,3,143,255,255,255,248,3,142,0,0,0,56,3,142,0,0,0,56,3,142,0,0,0,56,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,7,28,0,0,3,128,7,28,0,0,3,128,7,28,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,
  // 0x5075  偵
  117,80,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,31,255,248,0,112,0,31,255,248,0,112,0,31,255,248,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,31,129,192,0,1,192,31,129,192,0,1,192,31,129,192,0,1,192,31,129,192,0,1,192,31,129,192,0,1,192,31,129,192,0,1,192,227,129,255,255,255,192,227,129,255,255,255,192,227,129,255,255,255,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,
  // 0x5099  備
  153,80,45,48,32,48,0,250,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,63,255,255,248,0,14,63,255,255,248,0,14,63,255,255,248,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,3,241,255,255,255,248,3,241,255,255,255,248,3,241,255,255,255,248,3,240,0,224,0,0,3,240,0,224,0,0,3,240,0,224,0,0,28,112,7,255,255,192,28,112,7,255,255,192,28,112,7,255,255,192,224,112,63,3,129,192,224,112,63,3,129,192,224,112,63,3,129,192,0,113,199,255,255,192,0,113,199,255,255,192,0,113,199,255,255,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,0,15,192,0,112,7,0,15,192,0,112,7,0,15,192,
  // 0x50b3  傳
  179,80,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,127,255,255,255,248,0,127,255,255,255,248,0,127,255,255,255,248,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,31,129,255,255,255,192,31,129,255,255,255,192,31,129,255,255,255,192,31,129,192,28,1,192,31,129,192,28,1,192,31,129,192,28,1,192,227,129,255,255,255,192,227,129,255,255,255,192,227,129,255,255,255,192,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,143,255,255,255,248,3,143,255,255,255,248,3,143,255,255,255,248,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,143,255,255,255,248,3,143,255,255,255,248,3,143,255,255,255,248,3,128,56,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,28,112,0,3,128,7,28,112,0,3,128,7,28,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,
  // 0x50be  傾
  190,80,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,255,255,248,0,112,7,255,255,248,0,112,7,255,255,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,255,255,192,3,129,192,255,255,192,3,129,192,255,255,192,31,129,192,224,1,192,31,129,192,224,1,192,31,129,192,224,1,192,31,129,255,224,1,192,31,129,255,224,1,192,31,129,255,224,1,192,227,129,192,255,255,192,227,129,192,255,255,192,227,129,192,255,255,192,3,129,192,224,1,192,3,129,192,224,1,192,3,129,192,224,1,192,3,129,192,255,255,192,3,129,192,255,255,192,3,129,192,255,255,192,3,129,199,224,1,192,3,129,199,224,1,192,3,129,199,224,1,192,3,129,248,224,1,192,3,129,248,224,1,192,3,129,248,224,1,192,3,129,192,255,255,192,3,129,192,255,255,192,3,129,192,255,255,192,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,7,0,0,56,3,128,7,0,0,56,3,128,7,0,0,56,
  // 0x5132  儲
  50,81,45,48,32,48,0,250,0,113,192,0,112,0,0,113,192,0,112,0,0,113,192,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,31,254,56,0,112,56,31,254,56,0,112,56,31,254,56,3,143,255,0,112,56,3,143,255,0,112,56,3,143,255,0,112,56,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,31,143,255,31,255,248,31,143,255,31,255,248,31,143,255,31,255,248,31,128,0,0,14,0,31,128,0,0,14,0,31,128,0,0,14,0,227,143,255,0,112,0,227,143,255,0,112,0,227,143,255,0,112,0,3,128,0,3,255,192,3,128,0,3,255,192,3,128,0,3,255,192,3,143,255,31,129,192,3,143,255,31,129,192,3,143,255,31,129,192,3,142,7,227,129,192,3,142,7,227,129,192,3,142,7,227,129,192,3,142,7,3,255,192,3,142,7,3,255,192,3,142,7,3,255,192,3,142,7,3,129,192,3,142,7,3,129,192,3,142,7,3,129,192,3,143,255,3,129,192,3,143,255,3,129,192,3,143,255,3,129,192,3,142,7,3,255,192,3,142,7,3,255,192,3,142,7,3,255,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,
  // 0x5145  充
  69,81,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,1,192,28,14,0,0,1,192,28,14,0,0,1,192,28,14,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,31,128,0,3,255,192,31,128,0,3,255,192,31,128,0,3,255,192,
  // 0x5148  先
  72,81,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,127,255,255,254,0,0,127,255,255,254,0,0,127,255,255,254,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,28,0,7,0,0,0,28,0,7,0,0,0,28,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,3,128,0,3,255,248,3,128,0,3,255,248,3,128,0,3,255,248,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,
  // 0x5149  光
  73,81,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,3,128,0,3,255,248,3,128,0,3,255,248,3,128,0,3,255,248,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,
  // 0x5165  入
  101,81,45,48,32,48,0,250,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,224,0,0,0,1,248,224,0,0,0,1,248,224,0,0,0,1,248,
  // 0x5168  全
  104,81,45,45,14,48,0,253,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,143,255,255,142,0,3,143,255,255,142,0,3,143,255,255,142,0,252,0,7,0,1,248,252,0,7,0,1,248,252,0,7,0,1,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,
  // 0x5171  共
  113,81,42,48,32,48,3,250,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,31,255,255,255,254,0,31,255,255,255,254,0,31,255,255,255,254,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,255,255,255,255,255,192,255,255,255,255,255,192,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,
  // 0x5177  具
  119,81,45,45,14,48,0,250,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,
  // 0x5197  冗
  151,81,45,42,252,48,0,250,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,252,0,0,0,15,255,252,0,0,0,15,255,252,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,28,0,0,3,255,248,28,0,0,3,255,248,28,0,0,3,255,248,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,
  // 0x51b7  冷
  183,81,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,56,28,14,0,0,0,56,28,14,0,0,0,56,28,14,0,0,113,192,3,129,248,0,113,192,3,129,248,0,113,192,3,129,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,255,128,0,0,14,0,255,128,0,0,14,0,255,128,0,0,14,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0x51c6  准
  198,81,45,48,32,48,0,250,0,0,7,28,0,0,0,0,7,28,0,0,0,0,7,28,0,0,28,0,7,3,128,0,28,0,7,3,128,0,28,0,7,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,3,128,63,255,255,248,3,128,63,255,255,248,3,128,63,255,255,248,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,3,128,0,0,113,248,3,128,0,0,113,248,3,128,0,0,113,248,3,128,0,0,126,63,255,255,192,0,126,63,255,255,192,0,126,63,255,255,192,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,63,255,255,192,3,128,63,255,255,192,3,128,63,255,255,192,255,128,56,3,128,0,255,128,56,3,128,0,255,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,63,255,255,248,3,128,63,255,255,248,3,128,63,255,255,248,3,128,56,0,0,0,3,128,56,0,0,0,3,128,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x51fa  出
  250,81,39,48,240,48,3,250,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,
  // 0x5206  分
  6,82,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,224,127,255,255,128,56,224,127,255,255,128,56,224,127,255,255,128,56,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,7,28,0,0,3,128,7,28,0,0,3,128,7,28,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,
  // 0x5217  列
  23,82,42,48,32,48,0,250,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,31,255,255,224,1,192,31,255,255,224,1,192,31,255,255,224,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,127,255,3,129,192,0,127,255,3,129,192,0,127,255,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,28,112,56,3,129,192,28,112,56,3,129,192,28,112,56,3,129,192,224,14,56,3,129,192,224,14,56,3,129,192,224,14,56,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,
  // 0x521d  初
  29,82,42,48,32,48,0,250,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,0,7,255,255,192,0,0,7,255,255,192,0,0,7,255,255,192,255,255,192,28,1,192,255,255,192,28,1,192,255,255,192,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,3,241,192,28,1,192,3,241,192,28,1,192,3,241,192,28,1,192,28,126,0,28,1,192,28,126,0,28,1,192,28,126,0,28,1,192,224,113,192,28,1,192,224,113,192,28,1,192,224,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,0,113,192,0,112,0,0,113,192,0,112,0,0,113,192,0,112,0,
  // 0x5230  到
  48,82,42,48,32,48,0,250,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,255,255,255,224,1,192,255,255,255,224,1,192,255,255,255,224,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,28,0,7,3,129,192,28,0,7,3,129,192,28,0,7,3,129,192,255,255,255,227,129,192,255,255,255,227,129,192,255,255,255,227,129,192,0,14,0,227,129,192,0,14,0,227,129,192,0,14,0,227,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,15,255,224,1,192,0,15,255,224,1,192,0,15,255,224,1,192,255,254,0,0,113,192,255,254,0,0,113,192,255,254,0,0,113,192,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,
  // 0x5236  制
  54,82,42,48,32,48,0,250,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,255,255,227,129,192,3,255,255,227,129,192,3,255,255,227,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,255,255,255,255,129,192,255,255,255,255,129,192,255,255,255,255,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,3,255,255,227,129,192,3,255,255,227,129,192,3,255,255,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,248,224,1,192,3,129,248,224,1,192,3,129,248,224,1,192,3,129,199,0,1,192,3,129,199,0,1,192,3,129,199,0,1,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,
  // 0x5237  刷
  55,82,45,48,32,48,0,250,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,3,255,255,252,0,56,3,255,255,252,0,56,3,255,255,252,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,255,255,252,112,56,3,255,255,252,112,56,3,255,255,252,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,255,255,252,112,56,3,255,255,252,112,56,3,255,255,252,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,224,112,63,28,0,56,224,112,63,28,0,56,224,112,63,28,0,56,0,112,56,224,0,56,0,112,56,224,0,56,0,112,56,224,0,56,0,0,56,0,14,56,0,0,56,0,14,56,0,0,56,0,14,56,0,0,56,0,1,192,0,0,56,0,1,192,0,0,56,0,1,192,
  // 0x5275  創
  117,82,42,48,32,48,0,250,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,15,192,0,1,192,0,15,192,0,1,192,0,15,192,0,1,192,0,112,56,0,1,192,0,112,56,0,1,192,0,112,56,0,1,192,3,142,7,3,129,192,3,142,7,3,129,192,3,142,7,3,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,227,129,192,227,255,255,3,129,192,227,255,255,3,129,192,227,255,255,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,255,255,3,129,192,3,255,255,3,129,192,3,255,255,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,255,255,3,129,192,3,255,255,3,129,192,3,255,255,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,255,255,3,129,192,3,255,255,3,129,192,3,255,255,3,129,192,28,112,7,0,1,192,28,112,7,0,1,192,28,112,7,0,1,192,28,112,7,0,1,192,28,112,7,0,1,192,28,112,7,0,1,192,224,127,255,0,113,192,224,127,255,0,113,192,224,127,255,0,113,192,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,
  // 0x529b  力
  155,82,36,48,240,48,3,250,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,255,255,255,255,240,255,255,255,255,240,255,255,255,255,240,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,112,0,0,112,0,112,0,0,112,0,112,0,0,112,0,112,0,0,112,0,112,0,0,112,0,112,0,0,112,3,128,7,0,112,3,128,7,0,112,3,128,7,0,112,28,0,0,227,128,28,0,0,227,128,28,0,0,227,128,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,
  // 0x52a0  加
  160,82,42,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,31,255,192,0,112,0,31,255,192,0,112,0,31,255,192,255,255,248,28,1,192,255,255,248,28,1,192,255,255,248,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,31,255,192,3,128,56,31,255,192,3,128,56,31,255,192,28,14,56,28,1,192,28,14,56,28,1,192,28,14,56,28,1,192,224,1,192,0,0,0,224,1,192,0,0,0,224,1,192,0,0,0,
  // 0x52d5  動
  213,82,42,48,32,48,0,250,0,15,255,3,128,0,0,15,255,3,128,0,0,15,255,3,128,0,31,254,0,3,128,0,31,254,0,3,128,0,31,254,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,255,255,255,227,128,0,255,255,255,227,128,0,255,255,255,227,128,0,0,14,0,31,255,192,0,14,0,31,255,192,0,14,0,31,255,192,31,255,255,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,28,14,7,3,129,192,28,14,7,3,129,192,28,14,7,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,28,14,7,3,129,192,28,14,7,3,129,192,28,14,7,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,15,255,252,1,192,0,15,255,252,1,192,0,15,255,252,1,192,255,254,0,224,113,192,255,254,0,224,113,192,255,254,0,224,113,192,28,0,7,0,14,0,28,0,7,0,14,0,28,0,7,0,14,0,
  // 0x5316  化
  22,83,45,48,32,48,0,250,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,1,192,0,14,0,224,1,192,0,14,0,224,1,192,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,3,240,0,227,128,0,3,240,0,227,128,0,3,240,0,227,128,0,3,240,0,252,0,0,3,240,0,252,0,0,3,240,0,252,0,0,28,112,0,224,0,0,28,112,0,224,0,0,28,112,0,224,0,0,224,112,7,224,0,0,224,112,7,224,0,0,224,112,7,224,0,0,0,112,56,224,0,0,0,112,56,224,0,0,0,112,56,224,0,0,0,113,192,224,0,0,0,113,192,224,0,0,0,113,192,224,0,0,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,31,255,248,0,112,0,31,255,248,0,112,0,31,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x534a  半
  74,83,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x5354  協
  84,83,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,63,255,255,192,3,128,63,255,255,192,3,128,63,255,255,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,192,255,254,0,224,1,192,255,254,0,224,1,192,255,254,0,224,1,192,3,128,7,0,113,192,3,128,7,0,113,192,3,128,7,0,113,192,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,143,255,227,255,248,3,143,255,227,255,248,3,143,255,227,255,248,3,129,192,224,112,56,3,129,192,224,112,56,3,129,192,224,112,56,3,129,192,224,112,56,3,129,192,224,112,56,3,129,192,224,112,56,3,129,192,224,112,56,3,129,192,224,112,56,3,129,192,224,112,56,3,142,0,227,128,56,3,142,0,227,128,56,3,142,0,227,128,56,3,142,56,227,142,56,3,142,56,227,142,56,3,142,56,227,142,56,3,240,7,28,1,192,3,240,7,28,1,192,3,240,7,28,1,192,
  // 0x5361  卡
  97,83,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x5370  印
  112,83,39,45,225,48,3,250,0,15,192,0,0,0,15,192,0,0,0,15,192,0,0,255,240,7,255,254,255,240,7,255,254,255,240,7,255,254,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,255,255,199,0,14,255,255,199,0,14,255,255,199,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,127,199,28,112,224,127,199,28,112,224,127,199,28,112,255,128,7,3,128,255,128,7,3,128,255,128,7,3,128,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,
  // 0x5378  卸
  120,83,42,48,32,48,0,250,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,255,255,31,255,192,3,255,255,31,255,192,3,255,255,31,255,192,28,14,0,28,1,192,28,14,0,28,1,192,28,14,0,28,1,192,224,14,0,28,1,192,224,14,0,28,1,192,224,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,31,255,255,28,1,192,31,255,255,28,1,192,31,255,255,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,3,143,248,28,1,192,3,143,248,28,1,192,3,143,248,28,1,192,3,142,0,28,1,192,3,142,0,28,1,192,3,142,0,28,1,192,3,142,0,28,113,192,3,142,0,28,113,192,3,142,0,28,113,192,3,143,255,28,14,0,3,143,255,28,14,0,3,143,255,28,14,0,255,240,0,28,0,0,255,240,0,28,0,0,255,240,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x537b  卻
  123,83,42,48,32,48,0,250,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,112,56,0,0,0,0,112,56,0,0,0,0,112,56,0,0,0,3,128,7,31,255,192,3,128,7,31,255,192,3,128,7,31,255,192,28,14,7,28,1,192,28,14,7,28,1,192,28,14,7,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,28,0,7,28,1,192,28,0,7,28,1,192,28,0,7,28,1,192,227,255,248,28,1,192,227,255,248,28,1,192,227,255,248,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,113,192,3,128,56,28,113,192,3,128,56,28,113,192,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,3,255,248,28,0,0,3,255,248,28,0,0,3,255,248,28,0,0,3,128,56,28,0,0,3,128,56,28,0,0,3,128,56,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x539f  原
  159,83,45,45,14,48,0,250,3,255,255,255,255,248,3,255,255,255,255,248,3,255,255,255,255,248,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,3,129,255,255,240,0,3,129,255,255,240,0,3,129,255,255,240,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,255,255,240,0,3,129,255,255,240,0,3,129,255,255,240,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,255,255,240,0,3,129,255,255,240,0,3,129,255,255,240,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,129,192,224,112,0,3,129,192,224,112,0,3,129,192,224,112,0,28,14,0,224,14,0,28,14,0,224,14,0,28,14,0,224,14,0,28,112,56,224,1,192,28,112,56,224,1,192,28,112,56,224,1,192,224,0,7,0,0,0,224,0,7,0,0,0,224,0,7,0,0,0,
  // 0x53cd  反
  205,83,45,48,32,48,0,250,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,255,254,0,0,0,0,255,254,0,0,0,0,255,254,0,3,255,255,0,0,0,3,255,255,0,0,0,3,255,255,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,7,28,0,0,3,128,7,28,0,0,3,128,7,28,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,28,0,7,28,0,0,28,0,7,28,0,0,28,0,7,28,0,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,224,15,192,0,126,0,224,15,192,0,126,0,224,15,192,0,126,0,3,240,0,0,1,248,3,240,0,0,1,248,3,240,0,0,1,248,
  // 0x53d6  取
  214,83,45,45,14,48,0,250,255,255,255,224,0,0,255,255,255,224,0,0,255,255,255,224,0,0,3,128,56,255,255,192,3,128,56,255,255,192,3,128,56,255,255,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,129,255,227,142,0,3,129,255,227,142,0,3,129,255,227,142,0,255,254,56,0,112,0,255,254,56,0,112,0,255,254,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,0,0,56,3,142,0,0,0,56,3,142,0,0,0,56,3,142,0,0,0,56,28,1,192,0,0,56,28,1,192,0,0,56,28,1,192,0,0,56,224,0,56,0,0,56,224,0,56,0,0,56,224,0,56,
  // 0x53f0  台
  240,83,39,48,240,48,3,250,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,28,0,0,0,14,28,0,0,0,14,28,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,
  // 0x5408  合
  8,84,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,3,240,0,0,126,0,3,240,0,0,126,0,3,240,0,0,126,0,252,15,255,255,129,248,252,15,255,255,129,248,252,15,255,255,129,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x5426  否
  38,84,45,45,14,48,0,250,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,1,199,31,128,0,0,1,199,31,128,0,0,1,199,31,128,0,0,14,7,0,126,0,0,14,7,0,126,0,0,14,7,0,126,0,3,240,7,0,1,192,3,240,7,0,1,192,3,240,7,0,1,192,252,0,7,0,0,56,252,0,7,0,0,56,252,0,7,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x544a  告
  74,84,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,127,255,255,254,0,0,127,255,255,254,0,0,127,255,255,254,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,28,0,7,0,0,0,28,0,7,0,0,0,28,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x547d  命
  125,84,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,3,241,255,252,126,0,3,241,255,252,126,0,3,241,255,252,126,0,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,248,255,254,0,3,255,248,255,254,0,3,255,248,255,254,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,255,248,227,142,0,3,255,248,227,142,0,3,255,248,227,142,0,3,128,56,224,112,0,3,128,56,224,112,0,3,128,56,224,112,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,
  // 0x548c  和
  140,84,42,48,32,48,0,250,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,15,248,0,0,0,0,15,248,0,0,0,0,15,248,0,0,0,31,254,0,0,0,0,31,254,0,0,0,0,31,254,0,0,0,0,0,14,0,31,255,192,0,14,0,31,255,192,0,14,0,31,255,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,255,255,255,28,1,192,255,255,255,28,1,192,255,255,255,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,126,0,28,1,192,0,126,0,28,1,192,0,126,0,28,1,192,0,127,192,28,1,192,0,127,192,28,1,192,0,127,192,28,1,192,3,142,56,28,1,192,3,142,56,28,1,192,3,142,56,28,1,192,3,142,56,28,1,192,3,142,56,28,1,192,3,142,56,28,1,192,28,14,0,28,1,192,28,14,0,28,1,192,28,14,0,28,1,192,224,14,0,31,255,192,224,14,0,31,255,192,224,14,0,31,255,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,
  // 0x555f  啟
  95,85,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,3,255,255,3,128,0,3,255,255,3,128,0,3,255,255,3,128,0,3,128,7,3,255,248,3,128,7,3,255,248,3,128,7,3,255,248,3,128,7,28,1,192,3,128,7,28,1,192,3,128,7,28,1,192,3,128,7,28,1,192,3,128,7,28,1,192,3,128,7,28,1,192,3,255,255,28,1,192,3,255,255,28,1,192,3,255,255,28,1,192,3,128,0,227,129,192,3,128,0,227,129,192,3,128,0,227,129,192,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,255,255,3,142,0,3,255,255,3,142,0,3,255,255,3,142,0,3,240,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,28,112,7,0,112,0,28,112,7,0,112,0,28,112,7,0,112,0,28,112,7,3,142,0,28,112,7,3,142,0,28,112,7,3,142,0,224,127,255,3,142,0,224,127,255,3,142,0,224,127,255,3,142,0,0,112,7,28,1,192,0,112,7,28,1,192,0,112,7,28,1,192,0,0,0,224,0,56,0,0,0,224,0,56,0,0,0,224,0,56,
  // 0x55ae  單
  174,85,45,45,14,48,0,250,31,255,248,255,255,192,31,255,248,255,255,192,31,255,248,255,255,192,28,0,56,224,1,192,28,0,56,224,1,192,28,0,56,224,1,192,28,0,56,224,1,192,28,0,56,224,1,192,28,0,56,224,1,192,31,255,248,255,255,192,31,255,248,255,255,192,31,255,248,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x5634  嘴
  52,86,45,48,32,48,0,250,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,0,0,56,224,113,192,0,0,56,224,113,192,0,0,56,224,113,192,255,240,56,252,126,0,255,240,56,252,126,0,255,240,56,252,126,0,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,252,112,56,224,112,56,252,112,56,224,112,56,252,112,56,224,113,255,0,15,248,224,113,255,0,15,248,224,113,255,0,15,248,224,112,7,255,240,0,224,112,7,255,240,0,224,112,7,255,240,0,224,112,56,0,112,0,224,112,56,0,112,0,224,112,56,0,112,0,224,113,255,255,255,192,224,113,255,255,255,192,224,113,255,255,255,192,224,126,56,28,1,192,224,126,56,28,1,192,224,126,56,28,1,192,255,240,63,255,255,192,255,240,63,255,255,192,255,240,63,255,255,192,224,112,56,28,1,192,224,112,56,28,1,192,224,112,56,28,1,192,0,0,63,255,255,192,0,0,63,255,255,192,0,0,63,255,255,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,28,113,192,0,1,192,28,113,192,0,1,192,28,113,192,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,
  // 0x5668  器
  104,86,45,45,14,48,0,250,3,255,248,31,255,192,3,255,248,31,255,192,3,255,248,31,255,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,255,248,31,255,192,3,255,248,31,255,192,3,255,248,31,255,192,0,0,7,3,128,0,0,0,7,3,128,0,0,0,7,3,128,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,15,192,31,128,0,0,15,192,31,128,0,0,15,192,31,128,0,3,240,0,0,126,0,3,240,0,0,126,0,3,240,0,0,126,0,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,3,255,248,31,255,192,3,255,248,31,255,192,3,255,248,31,255,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,255,248,31,255,192,3,255,248,31,255,192,3,255,248,31,255,192,
  // 0x5674  噴
  116,86,42,48,32,48,3,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,255,240,0,28,0,0,255,240,0,28,0,0,255,240,0,28,0,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,113,255,255,255,192,224,113,255,255,255,192,224,113,255,255,255,192,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,63,255,254,0,224,112,63,255,254,0,224,112,63,255,254,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,63,255,254,0,224,112,63,255,254,0,224,112,63,255,254,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,255,240,63,255,254,0,255,240,63,255,254,0,255,240,63,255,254,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,
  // 0x56de  回
  222,86,36,42,210,48,6,253,255,255,255,255,240,255,255,255,255,240,255,255,255,255,240,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,127,255,224,112,224,127,255,224,112,224,127,255,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,127,255,224,112,224,127,255,224,112,224,127,255,224,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,255,255,255,255,240,255,255,255,255,240,255,255,255,255,240,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x56e0  因
  224,86,39,45,225,48,3,250,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,227,255,255,255,142,227,255,255,255,142,227,255,255,255,142,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,1,192,224,14,224,1,192,224,14,224,1,192,224,14,224,14,0,28,14,224,14,0,28,14,224,14,0,28,14,224,112,0,3,142,224,112,0,3,142,224,112,0,3,142,227,128,0,3,142,227,128,0,3,142,227,128,0,3,142,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,
  // 0x56fa  固
  250,86,39,45,225,48,3,250,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,227,255,255,255,142,227,255,255,255,142,227,255,255,255,142,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,127,255,252,14,224,127,255,252,14,224,127,255,252,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,127,255,252,14,224,127,255,252,14,224,127,255,252,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,
  // 0x5716  圖
  22,87,39,48,240,48,3,250,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,127,255,252,14,224,127,255,252,14,224,127,255,252,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,127,255,252,14,224,127,255,252,14,224,127,255,252,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,227,255,255,255,142,227,255,255,255,142,227,255,255,255,142,227,128,0,3,142,227,128,0,3,142,227,128,0,3,142,227,143,255,227,142,227,143,255,227,142,227,143,255,227,142,227,142,0,227,142,227,142,0,227,142,227,142,0,227,142,227,255,255,255,142,227,255,255,255,142,227,255,255,255,142,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,
  // 0x5728  在
  40,87,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,240,0,28,0,0,3,240,0,28,0,0,3,240,0,28,0,0,28,113,255,255,255,192,28,113,255,255,255,192,28,113,255,255,255,192,224,112,0,28,0,0,224,112,0,28,0,0,224,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,127,255,255,255,248,0,127,255,255,255,248,0,127,255,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x578b  型
  139,87,45,45,14,48,0,253,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,31,255,255,224,1,192,31,255,255,224,1,192,31,255,255,224,1,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,255,255,255,227,129,192,255,255,255,227,129,192,255,255,255,227,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,3,128,56,0,1,192,3,128,56,0,1,192,3,128,56,0,1,192,3,128,56,0,113,192,3,128,56,0,113,192,3,128,56,0,113,192,28,0,7,0,14,0,28,0,7,0,14,0,28,0,7,0,14,0,224,0,7,0,0,0,224,0,7,0,0,0,224,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x57f7  執
  247,87,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,31,255,192,28,0,0,31,255,192,28,0,0,31,255,192,28,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,255,255,248,28,14,0,255,255,248,28,14,0,255,255,248,28,14,0,28,1,192,28,14,0,28,1,192,28,14,0,28,1,192,28,14,0,3,142,7,28,14,0,3,142,7,28,14,0,3,142,7,28,14,0,31,255,192,252,14,0,31,255,192,252,14,0,31,255,192,252,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,227,142,0,0,112,0,227,142,0,0,112,0,227,142,0,255,255,248,227,142,0,255,255,248,227,142,0,255,255,248,227,142,0,0,112,0,224,14,56,0,112,0,224,14,56,0,112,0,224,14,56,0,112,7,0,14,56,0,112,7,0,14,56,0,112,7,0,14,56,0,112,7,0,1,248,0,112,7,0,1,248,0,112,7,0,1,248,0,112,56,0,0,56,0,112,56,0,0,56,0,112,56,0,0,56,
  // 0x584a  塊
  74,88,45,48,32,48,0,250,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,63,255,255,192,3,128,63,255,255,192,3,128,63,255,255,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,255,254,63,255,255,192,255,254,63,255,255,192,255,254,63,255,255,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,63,255,255,192,3,128,63,255,255,192,3,128,63,255,255,192,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,227,142,0,3,128,0,227,142,0,3,128,0,227,142,0,3,254,0,227,241,192,3,254,0,227,241,192,3,254,0,227,241,192,255,128,7,3,255,192,255,128,7,3,255,192,255,128,7,3,255,192,28,0,7,3,128,56,28,0,7,3,128,56,28,0,7,3,128,56,0,0,56,3,128,56,0,0,56,3,128,56,0,0,56,3,128,56,0,1,192,0,127,248,0,1,192,0,127,248,0,1,192,0,127,248,
  // 0x586b  填
  107,88,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,255,254,56,0,14,0,255,254,56,0,14,0,255,254,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,254,56,0,14,0,3,254,56,0,14,0,3,254,56,0,14,0,255,143,255,255,255,248,255,143,255,255,255,248,255,143,255,255,255,248,28,0,7,0,112,0,28,0,7,0,112,0,28,0,7,0,112,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,
  // 0x588a  墊
  138,88,45,45,14,48,0,253,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,31,255,248,3,128,0,31,255,248,3,128,0,31,255,248,3,128,0,0,14,0,255,254,0,0,14,0,255,254,0,0,14,0,255,254,0,255,255,255,3,142,0,255,255,255,3,142,0,255,255,255,3,142,0,0,113,192,3,142,0,0,113,192,3,142,0,0,113,192,3,142,0,31,255,255,31,142,56,31,255,255,31,142,56,31,255,255,31,142,56,0,14,0,3,142,56,0,14,0,3,142,56,0,14,0,3,142,56,255,255,255,28,113,248,255,255,255,28,113,248,255,255,255,28,113,248,0,14,0,224,0,56,0,14,0,224,0,56,0,14,0,224,0,56,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x5916  外
  22,89,42,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,255,248,28,0,0,3,255,248,28,0,0,3,255,248,28,0,0,3,128,56,31,128,0,3,128,56,31,128,0,3,128,56,31,128,0,28,0,56,28,112,0,28,0,56,28,112,0,28,0,56,28,112,0,28,0,56,28,14,0,28,0,56,28,14,0,28,0,56,28,14,0,227,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,
  // 0x591a  多
  26,89,36,48,240,48,3,250,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,15,255,255,128,0,15,255,255,128,0,15,255,255,128,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,31,240,0,224,0,31,240,0,224,0,31,240,0,224,0,0,14,7,0,0,0,14,7,0,0,0,14,7,0,0,0,1,248,224,0,0,1,248,224,0,0,1,248,224,0,0,126,7,0,0,0,126,7,0,0,0,126,7,0,0,255,128,63,255,240,255,128,63,255,240,255,128,63,255,240,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,126,0,3,128,0,126,0,3,128,0,126,0,3,128,31,129,192,28,0,31,129,192,28,0,31,129,192,28,0,0,0,56,224,0,0,0,56,224,0,0,0,56,224,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,127,192,0,0,0,127,192,0,0,0,127,192,0,0,255,128,0,0,0,255,128,0,0,0,255,128,0,0,0,
  // 0x5920  夠
  32,89,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,255,248,28,0,0,3,255,248,28,0,0,3,255,248,28,0,0,28,0,56,31,255,248,28,0,56,31,255,248,28,0,56,31,255,248,227,129,192,224,0,56,227,129,192,224,0,56,227,129,192,224,0,56,0,126,7,0,0,56,0,126,7,0,0,56,0,126,7,0,0,56,0,112,0,31,254,56,0,112,0,31,254,56,0,112,0,31,254,56,3,142,0,28,14,56,3,142,0,28,14,56,3,142,0,28,14,56,252,15,255,28,14,56,252,15,255,28,14,56,252,15,255,28,14,56,0,112,7,28,14,56,0,112,7,28,14,56,0,112,7,28,14,56,3,240,56,31,254,56,3,240,56,31,254,56,3,240,56,31,254,56,28,14,56,28,14,56,28,14,56,28,14,56,28,14,56,28,14,56,0,1,192,0,0,56,0,1,192,0,0,56,0,1,192,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,3,240,0,0,113,192,3,240,0,0,113,192,3,240,0,0,113,192,252,0,0,0,14,0,252,0,0,0,14,0,252,0,0,0,14,0,
  // 0x5927  大
  39,89,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,
  // 0x5929  天
  41,89,45,45,14,48,0,250,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,
  // 0x5931  失
  49,89,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,127,255,255,254,0,0,127,255,255,254,0,0,127,255,255,254,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,28,0,7,0,0,0,28,0,7,0,0,0,28,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,128,0,0,15,192,31,128,0,0,15,192,31,128,0,0,15,192,
  // 0x59cb  始
  203,89,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,255,255,192,28,14,0,255,255,192,28,14,0,255,255,192,28,14,0,3,129,192,224,1,192,3,129,192,224,1,192,3,129,192,224,1,192,3,129,199,255,255,248,3,129,199,255,255,248,3,129,199,255,255,248,3,129,192,224,0,56,3,129,192,224,0,56,3,129,192,224,0,56,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,28,14,0,255,255,192,28,14,0,255,255,192,28,14,0,255,255,192,3,142,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,224,0,0,255,255,192,224,0,0,255,255,192,224,0,0,255,255,192,0,0,0,224,1,192,0,0,0,224,1,192,0,0,0,224,1,192,
  // 0x5a92  媒
  146,90,45,48,32,48,0,250,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,255,254,7,0,112,0,255,254,7,0,112,0,255,254,7,0,112,0,3,142,7,255,240,0,3,142,7,255,240,0,3,142,7,255,240,0,3,142,7,0,112,0,3,142,7,0,112,0,3,142,7,0,112,0,3,142,7,255,240,0,3,142,7,255,240,0,3,142,7,255,240,0,28,14,0,28,0,0,28,14,0,28,0,0,28,14,0,28,0,0,28,15,255,255,255,248,28,15,255,255,255,248,28,15,255,255,255,248,3,142,0,28,0,0,3,142,0,28,0,0,3,142,0,28,0,0,0,112,0,255,128,0,0,112,0,255,128,0,0,112,0,255,128,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,7,28,112,0,3,142,56,28,15,248,3,142,56,28,15,248,3,142,56,28,15,248,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,
  // 0x5b50  子
  80,91,45,45,14,48,0,250,31,255,255,255,254,0,31,255,255,255,254,0,31,255,255,255,254,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x5b58  存
  88,91,45,48,32,48,0,250,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,240,0,3,128,0,3,240,0,3,128,0,3,240,0,3,128,0,28,112,0,28,0,0,28,112,0,28,0,0,28,112,0,28,0,0,224,113,255,255,255,248,224,113,255,255,255,248,224,113,255,255,255,248,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,7,28,0,0,0,112,7,28,0,0,0,112,7,28,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,
  // 0x5b89  安
  137,91,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,255,192,3,255,255,255,255,192,3,255,255,255,255,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,126,0,28,0,0,0,126,0,28,0,0,0,126,0,28,0,0,0,1,248,28,0,0,0,1,248,28,0,0,0,1,248,28,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,56,31,128,0,0,0,56,31,128,0,0,0,56,31,128,0,0,15,192,0,112,0,0,15,192,0,112,0,0,15,192,0,112,0,31,240,0,0,14,0,31,240,0,0,14,0,31,240,0,0,14,0,
  // 0x5b8c  完
  140,91,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,31,128,0,3,255,192,31,128,0,3,255,192,31,128,0,3,255,192,
  // 0x5b9a  定
  154,91,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,3,142,7,0,0,0,3,142,7,0,0,0,3,142,7,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,
  // 0x5ba2  客
  162,91,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,14,0,0,1,192,224,14,0,0,1,192,224,14,0,0,1,192,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,143,192,28,0,0,3,143,192,28,0,0,3,143,192,28,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,127,192,31,240,0,0,127,192,31,240,0,0,127,192,31,240,0,255,128,0,0,15,248,255,128,0,0,15,248,255,128,0,0,15,248,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x5bb9  容
  185,91,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,3,240,0,0,126,0,3,240,0,0,126,0,3,240,0,0,126,0,252,127,255,255,241,248,252,127,255,255,241,248,252,127,255,255,241,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x5c0d  對
  13,92,45,48,32,48,0,250,0,113,192,0,14,0,0,113,192,0,14,0,0,113,192,0,14,0,0,113,192,0,14,0,0,113,192,0,14,0,0,113,192,0,14,0,28,113,199,0,14,0,28,113,199,0,14,0,28,113,199,0,14,0,3,241,248,0,14,0,3,241,248,0,14,0,3,241,248,0,14,0,0,113,192,31,255,248,0,113,192,31,255,248,0,113,192,31,255,248,255,255,255,0,14,0,255,255,255,0,14,0,255,255,255,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,0,113,192,3,142,0,0,113,192,3,142,0,0,113,192,3,142,0,31,255,255,3,142,0,31,255,255,3,142,0,31,255,255,3,142,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,3,255,248,0,14,0,3,255,248,0,14,0,3,255,248,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,15,255,0,14,0,0,15,255,0,14,0,0,15,255,0,14,0,31,254,0,3,142,0,31,254,0,3,142,0,31,254,0,3,142,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,
  // 0x5c0f  小
  15,92,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,0,56,3,128,7,0,0,56,3,128,7,0,0,56,28,0,7,0,0,56,28,0,7,0,0,56,28,0,7,0,0,56,224,0,7,0,0,56,224,0,7,0,0,56,224,0,7,0,0,56,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x5c31  就
  49,92,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,255,255,248,28,14,0,255,255,248,28,14,0,255,255,248,28,14,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,31,255,199,255,255,248,31,255,199,255,255,248,31,255,199,255,255,248,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,31,255,192,28,112,0,31,255,192,28,112,0,31,255,192,28,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,28,113,192,224,112,0,28,113,192,224,112,0,28,113,192,224,112,0,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,0,112,7,0,112,56,0,112,7,0,112,56,0,112,7,0,112,56,28,112,7,0,15,248,28,112,7,0,15,248,28,112,7,0,15,248,3,128,56,0,0,0,3,128,56,0,0,0,3,128,56,0,0,0,
  // 0x5de5  工
  229,93,45,36,216,48,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x5dee  差
  238,93,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,113,255,255,254,0,0,113,255,255,254,0,0,113,255,255,254,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,0,127,255,255,255,192,0,127,255,255,255,192,0,127,255,255,255,192,
  // 0x5df2  已
  242,93,36,42,210,48,6,253,255,255,255,252,0,255,255,255,252,0,255,255,255,252,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,255,255,255,252,0,255,255,255,252,0,255,255,255,252,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,
  // 0x5e73  平
  115,94,45,45,14,48,0,250,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x5e8a  床
  138,94,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,3,255,255,255,255,248,3,255,255,255,255,248,3,255,255,255,255,248,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,143,255,255,255,192,3,143,255,255,255,192,3,143,255,255,255,192,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,7,252,0,0,3,128,7,252,0,0,3,128,7,252,0,0,3,128,56,227,128,0,3,128,56,227,128,0,3,128,56,227,128,0,3,128,56,227,128,0,3,128,56,227,128,0,3,128,56,227,128,0,3,129,192,224,112,0,3,129,192,224,112,0,3,129,192,224,112,0,28,14,0,224,14,0,28,14,0,224,14,0,28,14,0,224,14,0,28,112,0,224,1,248,28,112,0,224,1,248,28,112,0,224,1,248,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,
  // 0x5ea6  度
  166,94,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,3,255,255,255,255,248,3,255,255,255,255,248,3,255,255,255,255,248,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,255,255,255,255,192,3,255,255,255,255,192,3,255,255,255,255,192,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,63,255,128,0,3,128,63,255,128,0,3,128,63,255,128,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,143,255,255,240,0,3,143,255,255,240,0,3,143,255,255,240,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,7,252,0,0,28,0,7,252,0,0,28,0,7,252,0,0,224,1,248,3,240,0,224,1,248,3,240,0,224,1,248,3,240,0,3,254,0,0,15,248,3,254,0,0,15,248,3,254,0,0,15,248,
  // 0x5ee2  廢
  226,94,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,3,255,255,255,255,248,3,255,255,255,255,248,3,255,255,255,255,248,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,143,255,28,112,0,3,143,255,28,112,0,3,143,255,28,112,0,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,142,56,0,126,0,3,142,56,0,126,0,3,142,56,0,126,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,254,63,31,241,248,3,254,63,31,241,248,3,254,63,31,241,248,3,128,7,28,112,0,3,128,7,28,112,0,3,128,7,28,112,0,3,143,255,224,15,192,3,143,255,224,15,192,3,143,255,224,15,192,3,142,0,31,254,0,3,142,0,31,254,0,3,142,0,31,254,0,3,143,255,28,14,0,3,143,255,28,14,0,3,143,255,28,14,0,28,0,7,3,240,0,28,0,7,3,240,0,28,0,7,3,240,0,28,1,199,28,14,0,28,1,199,28,14,0,28,1,199,28,14,0,224,0,56,224,1,192,224,0,56,224,1,192,224,0,56,224,1,192,
  // 0x5efa  建
  250,94,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,254,63,255,254,0,255,254,63,255,254,0,255,254,63,255,254,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,31,254,0,28,0,0,31,254,0,28,0,0,31,254,0,28,0,0,0,14,63,255,254,0,0,14,63,255,254,0,0,14,63,255,254,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,28,14,0,28,0,0,28,14,0,28,0,0,28,14,0,28,0,0,3,241,255,255,255,192,3,241,255,255,255,192,3,241,255,255,255,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,143,192,28,0,0,3,143,192,28,0,0,3,143,192,28,0,0,28,0,63,255,255,248,28,0,63,255,255,248,28,0,63,255,255,248,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,
  // 0x5f15  引
  21,95,36,48,240,48,3,250,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,248,0,112,255,255,248,0,112,255,255,248,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,31,255,248,0,112,31,255,248,0,112,31,255,248,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,255,255,248,0,112,255,255,248,0,112,255,255,248,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,113,192,0,112,0,113,192,0,112,0,113,192,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,
  // 0x5f85  待
  133,95,45,48,32,48,0,250,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,63,255,255,192,3,128,63,255,255,192,3,128,63,255,255,192,28,14,0,28,0,0,28,14,0,28,0,0,28,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,3,240,0,0,112,0,3,240,0,0,112,0,3,240,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,224,113,255,255,255,248,224,113,255,255,255,248,224,113,255,255,255,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,
  // 0x5f8c  後
  140,95,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,28,14,63,255,128,0,28,14,63,255,128,0,28,14,63,255,128,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,3,240,63,255,255,192,3,240,63,255,255,192,3,240,63,255,255,192,28,112,0,224,1,192,28,112,0,224,1,192,28,112,0,224,1,192,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,63,0,14,0,0,112,63,0,14,0,0,112,63,0,14,0,0,113,192,224,112,0,0,113,192,224,112,0,0,113,192,224,112,0,0,112,0,31,128,0,0,112,0,31,128,0,0,112,0,31,128,0,0,112,7,224,126,0,0,112,7,224,126,0,0,112,7,224,126,0,0,113,248,0,1,248,0,113,248,0,1,248,0,113,248,0,1,248,
  // 0x5f91  徑
  145,95,45,48,32,48,0,250,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,63,255,255,192,0,14,63,255,255,192,0,14,63,255,255,192,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,28,14,56,28,14,0,28,14,56,28,14,0,28,14,56,28,14,0,0,15,192,224,112,0,0,15,192,224,112,0,0,15,192,224,112,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,3,240,7,3,129,192,3,240,7,3,129,192,3,240,7,3,129,192,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,224,112,63,255,255,192,224,112,63,255,255,192,224,112,63,255,255,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x5f9e  從
  158,95,45,48,32,48,0,250,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,28,14,7,28,113,192,28,14,7,28,113,192,28,14,7,28,113,192,0,14,56,3,128,56,0,14,56,3,128,56,0,14,56,3,128,56,0,113,192,28,0,56,0,113,192,28,0,56,0,113,192,28,0,56,3,240,0,3,128,0,3,240,0,3,128,0,3,240,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,224,112,7,3,128,0,224,112,7,3,128,0,224,112,7,3,128,0,0,112,7,3,255,192,0,112,7,3,255,192,0,112,7,3,255,192,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,56,227,128,0,0,112,56,227,128,0,0,112,56,227,128,0,0,112,56,31,128,0,0,112,56,31,128,0,0,112,56,31,128,0,0,113,192,3,255,248,0,113,192,3,255,248,0,113,192,3,255,248,0,126,0,0,0,0,0,126,0,0,0,0,0,126,0,0,0,0,
  // 0x5fa9  復
  169,95,45,48,32,48,0,250,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,112,7,255,255,248,0,112,7,255,255,248,0,112,7,255,255,248,3,128,56,0,0,0,3,128,56,0,0,0,3,128,56,0,0,0,28,15,199,255,255,192,28,15,199,255,255,192,28,15,199,255,255,192,0,14,7,0,1,192,0,14,7,0,1,192,0,14,7,0,1,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,3,240,7,0,1,192,3,240,7,0,1,192,3,240,7,0,1,192,28,112,7,255,255,192,28,112,7,255,255,192,28,112,7,255,255,192,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,56,224,112,0,0,112,56,224,112,0,0,112,56,224,112,0,0,112,0,31,128,0,0,112,0,31,128,0,0,112,0,31,128,0,0,112,7,224,126,0,0,112,7,224,126,0,0,112,7,224,126,0,0,113,248,0,1,248,0,113,248,0,1,248,0,113,248,0,1,248,
  // 0x5fae  微
  174,95,45,48,32,48,0,250,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,113,199,28,14,0,0,113,199,28,14,0,0,113,199,28,14,0,3,129,199,28,14,0,3,129,199,28,14,0,3,129,199,28,14,0,28,1,199,28,112,0,28,1,199,28,112,0,28,1,199,28,112,0,224,113,255,252,127,248,224,113,255,252,127,248,224,113,255,252,127,248,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,31,143,255,252,113,192,31,143,255,252,113,192,31,143,255,252,113,192,227,128,0,0,113,192,227,128,0,0,113,192,227,128,0,0,113,192,3,129,255,224,113,192,3,129,255,224,113,192,3,129,255,224,113,192,3,129,192,224,113,192,3,129,192,224,113,192,3,129,192,224,113,192,3,129,192,227,142,0,3,129,192,227,142,0,3,129,192,227,142,0,3,129,192,252,14,0,3,129,192,252,14,0,3,129,192,252,14,0,3,129,192,224,113,192,3,129,192,224,113,192,3,129,192,224,113,192,3,142,0,0,113,192,3,142,0,0,113,192,3,142,0,0,113,192,3,240,0,3,128,56,3,240,0,3,128,56,3,240,0,3,128,56,
  // 0x5fc3  心
  195,95,45,42,252,48,0,253,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,0,56,3,129,192,0,0,56,3,129,192,0,0,56,28,1,192,0,0,56,28,1,192,0,0,56,28,1,192,0,0,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,0,63,255,240,0,0,0,63,255,240,0,0,0,63,255,240,0,
  // 0x6027  性
  39,96,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,126,7,255,255,192,0,126,7,255,255,192,0,126,7,255,255,192,28,113,199,3,128,0,28,113,199,3,128,0,28,113,199,3,128,0,28,112,56,3,128,0,28,112,56,3,128,0,28,112,56,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x6062  恢
  98,96,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,126,0,224,0,0,0,126,0,224,0,0,0,126,0,224,0,0,28,113,192,224,112,0,28,113,192,224,112,0,28,113,192,224,112,0,28,112,0,224,112,0,28,112,0,224,112,0,28,112,0,224,112,0,28,112,7,0,112,56,28,112,7,0,112,56,28,112,7,0,112,56,224,112,7,28,112,56,224,112,7,28,112,56,224,112,7,28,112,56,0,112,7,28,113,192,0,112,7,28,113,192,0,112,7,28,113,192,0,112,56,224,112,0,0,112,56,224,112,0,0,112,56,224,112,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,0,113,192,3,142,0,0,113,192,3,142,0,0,113,192,3,142,0,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,7,0,0,56,0,112,7,0,0,56,0,112,7,0,0,56,
  // 0x606f  息
  111,96,45,45,14,48,0,253,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,14,0,224,1,192,0,14,0,224,1,192,0,14,0,224,1,192,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,224,1,255,255,240,0,224,1,255,255,240,0,224,1,255,255,240,0,
  // 0x61b6  憶
  182,97,45,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,0,126,7,0,14,0,0,126,7,0,14,0,0,126,7,0,14,0,28,113,192,224,112,0,28,113,192,224,112,0,28,113,192,224,112,0,28,113,255,255,255,248,28,113,255,255,255,248,28,113,255,255,255,248,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,224,112,63,255,255,192,224,112,63,255,255,192,224,112,63,255,255,192,0,112,56,0,1,192,0,112,56,0,1,192,0,112,56,0,1,192,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,0,112,56,0,1,192,0,112,56,0,1,192,0,112,56,0,1,192,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,199,3,129,192,0,113,199,3,129,192,0,113,199,3,129,192,0,113,199,0,14,56,0,113,199,0,14,56,0,113,199,0,14,56,0,126,0,255,254,56,0,126,0,255,254,56,0,126,0,255,254,56,
  // 0x61c9  應
  201,97,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,3,255,255,255,255,248,3,255,255,255,255,248,3,255,255,255,255,248,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,3,129,192,255,255,248,3,129,192,255,255,248,3,129,192,255,255,248,3,143,199,224,112,0,3,143,199,224,112,0,3,143,199,224,112,0,3,241,192,255,255,192,3,241,192,255,255,192,3,241,192,255,255,192,3,129,192,224,112,0,3,129,192,224,112,0,3,129,192,224,112,0,3,129,192,255,255,192,3,129,192,255,255,192,3,129,192,255,255,192,3,129,192,224,112,0,3,129,192,224,112,0,3,129,192,224,112,0,3,129,192,255,255,248,3,129,192,255,255,248,3,129,192,255,255,248,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,28,0,56,28,1,192,28,0,56,28,1,192,28,0,56,28,1,192,28,112,56,28,14,56,28,112,56,28,14,56,28,112,56,28,14,56,224,112,56,0,14,56,224,112,56,0,14,56,224,112,56,0,14,56,3,128,7,255,254,0,3,128,7,255,254,0,3,128,7,255,254,0,
  // 0x6210  成
  16,98,45,48,32,48,0,250,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,255,255,255,255,248,3,255,255,255,255,248,3,255,255,255,255,248,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,142,56,3,240,56,3,142,56,3,240,56,3,142,56,3,240,56,28,1,192,28,14,56,28,1,192,28,14,56,28,1,192,28,14,56,28,0,0,224,1,248,28,0,0,224,1,248,28,0,0,224,1,248,224,0,7,0,0,56,224,0,7,0,0,56,224,0,7,0,0,56,
  // 0x6236  戶
  54,98,39,48,240,48,0,250,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,255,254,0,0,0,255,254,0,0,0,255,254,0,127,255,0,0,0,127,255,0,0,0,127,255,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,127,255,255,254,0,127,255,255,254,0,127,255,255,254,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,0,127,255,255,254,0,127,255,255,254,0,127,255,255,254,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,
  // 0x6240  所
  64,98,45,48,32,48,0,250,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,1,255,0,127,192,0,1,255,0,127,192,0,1,255,0,127,192,3,254,0,255,128,0,3,254,0,255,128,0,3,254,0,255,128,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,255,248,224,0,0,3,255,248,224,0,0,3,255,248,224,0,0,3,128,56,255,255,248,3,128,56,255,255,248,3,128,56,255,255,248,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,255,248,224,14,0,3,255,248,224,14,0,3,255,248,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,28,0,7,0,14,0,28,0,7,0,14,0,28,0,7,0,14,0,28,0,7,0,14,0,28,0,7,0,14,0,28,0,7,0,14,0,224,0,56,0,14,0,224,0,56,0,14,0,224,0,56,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,
  // 0x6247  扇
  71,98,42,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,255,192,3,255,255,255,255,192,3,255,255,255,255,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,255,255,255,255,192,3,255,255,255,255,192,3,255,255,255,255,192,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,255,255,31,255,192,3,255,255,31,255,192,3,255,255,31,255,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,3,142,7,3,129,192,3,142,7,3,129,192,3,142,7,3,129,192,3,129,199,0,113,192,3,129,199,0,113,192,3,129,199,0,113,192,28,14,7,3,129,192,28,14,7,3,129,192,28,14,7,3,129,192,28,112,7,28,1,192,28,112,7,28,1,192,28,112,7,28,1,192,224,1,199,0,113,192,224,1,199,0,113,192,224,1,199,0,113,192,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,
  // 0x624b  手
  75,98,45,48,32,48,0,250,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,255,254,0,0,0,0,255,254,0,0,0,0,255,254,0,3,255,255,0,0,0,3,255,255,0,0,0,3,255,255,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x6253  打
  83,98,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,126,0,3,128,0,0,126,0,3,128,0,0,126,0,3,128,0,3,240,0,3,128,0,3,240,0,3,128,0,3,240,0,3,128,0,252,112,0,3,128,0,252,112,0,3,128,0,252,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,28,112,0,227,128,0,28,112,0,227,128,0,28,112,0,227,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,
  // 0x6279  批
  121,98,45,48,32,48,0,250,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,56,0,112,7,0,112,56,0,112,7,0,112,56,255,255,199,0,112,56,255,255,199,0,112,56,255,255,199,0,112,56,0,112,7,0,113,192,0,112,7,0,113,192,0,112,7,0,113,192,0,112,7,252,126,0,0,112,7,252,126,0,0,112,7,252,126,0,0,113,199,0,112,0,0,113,199,0,112,0,0,113,199,0,112,0,0,126,7,0,112,0,0,126,7,0,112,0,0,126,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,252,112,7,0,112,0,252,112,7,0,112,0,252,112,7,0,112,0,0,112,7,0,112,56,0,112,7,0,112,56,0,112,7,0,112,56,0,112,7,28,112,56,0,112,7,28,112,56,0,112,7,28,112,56,0,112,7,224,112,56,0,112,7,224,112,56,0,112,7,224,112,56,28,112,7,0,15,248,28,112,7,0,15,248,28,112,7,0,15,248,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,
  // 0x6296  抖
  150,98,45,48,32,48,0,250,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,113,192,224,112,0,0,113,192,224,112,0,0,113,192,224,112,0,0,126,0,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,3,240,0,0,127,248,3,240,0,0,127,248,3,240,0,0,127,248,252,112,63,255,240,0,252,112,63,255,240,0,252,112,63,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,
  // 0x62bd  抽
  189,98,42,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,255,255,199,255,255,192,255,255,199,255,255,192,255,255,199,255,255,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,113,199,3,129,192,0,113,199,3,129,192,0,113,199,3,129,192,0,126,7,3,129,192,0,126,7,3,129,192,0,126,7,3,129,192,3,240,7,255,255,192,3,240,7,255,255,192,3,240,7,255,255,192,252,112,7,3,129,192,252,112,7,3,129,192,252,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,28,112,7,255,255,192,28,112,7,255,255,192,28,112,7,255,255,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,
  // 0x62d4  拔
  212,98,45,48,32,48,0,250,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,255,254,63,255,255,248,255,254,63,255,255,248,255,254,63,255,255,248,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,113,192,224,0,0,0,113,192,224,0,0,0,113,192,224,0,0,0,126,0,255,255,192,0,126,0,255,255,192,0,126,0,255,255,192,3,240,7,28,1,192,3,240,7,28,1,192,3,240,7,28,1,192,252,112,7,28,1,192,252,112,7,28,1,192,252,112,7,28,1,192,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,28,113,192,28,1,192,28,113,192,28,1,192,28,113,192,28,1,192,3,128,7,224,0,56,3,128,7,224,0,56,3,128,7,224,0,56,
  // 0x6309  按
  9,99,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,255,254,56,0,0,56,255,254,56,0,0,56,255,254,56,0,0,56,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,126,63,255,255,248,0,126,63,255,255,248,0,126,63,255,255,248,3,240,0,224,14,0,3,240,0,224,14,0,3,240,0,224,14,0,252,112,0,224,14,0,252,112,0,224,14,0,252,112,0,224,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,0,252,112,0,0,112,0,252,112,0,0,112,0,252,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,28,112,0,224,14,0,28,112,0,224,14,0,28,112,0,224,14,0,3,128,63,0,1,192,3,128,63,0,1,192,3,128,63,0,1,192,
  // 0x6389  掉
  137,99,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,255,248,0,112,0,3,255,248,0,112,0,3,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,255,255,199,255,255,192,255,255,199,255,255,192,255,255,199,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,113,199,255,255,192,0,113,199,255,255,192,0,113,199,255,255,192,0,126,7,0,1,192,0,126,7,0,1,192,0,126,7,0,1,192,3,240,7,255,255,192,3,240,7,255,255,192,3,240,7,255,255,192,252,112,7,3,129,192,252,112,7,3,129,192,252,112,7,3,129,192,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,
  // 0x63a2  探
  162,99,45,48,32,48,0,250,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,255,254,7,0,112,0,255,254,7,0,112,0,255,254,7,0,112,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,142,0,28,0,0,3,142,0,28,0,0,3,142,0,28,0,0,3,241,255,255,255,192,3,241,255,255,255,192,3,241,255,255,255,192,255,128,0,28,0,0,255,128,0,28,0,0,255,128,0,28,0,0,3,128,0,255,128,0,3,128,0,255,128,0,3,128,0,255,128,0,3,128,7,28,112,0,3,128,7,28,112,0,3,128,7,28,112,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,3,143,192,28,1,248,3,143,192,28,1,248,3,143,192,28,1,248,227,128,0,28,0,0,227,128,0,28,0,0,227,128,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,
  // 0x63a5  接
  165,99,45,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,255,255,199,0,14,0,255,255,199,0,14,0,255,255,199,0,14,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,126,0,28,0,0,0,126,0,28,0,0,0,126,0,28,0,0,3,241,255,255,255,248,3,241,255,255,255,248,3,241,255,255,255,248,252,112,0,224,14,0,252,112,0,224,14,0,252,112,0,224,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,31,128,0,0,112,0,31,128,0,0,112,0,31,128,0,28,112,7,224,126,0,28,112,7,224,126,0,28,112,7,224,126,0,3,129,248,0,1,192,3,129,248,0,1,192,3,129,248,0,1,192,
  // 0x63a7  控
  167,99,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,255,254,56,0,0,56,255,254,56,0,0,56,255,254,56,0,0,56,0,113,192,224,113,192,0,113,192,224,113,192,0,113,192,224,113,192,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,126,56,0,1,192,0,126,56,0,1,192,0,126,56,0,1,192,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,252,112,7,255,255,192,252,112,7,255,255,192,252,112,7,255,255,192,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,28,113,255,255,255,248,28,113,255,255,255,248,28,113,255,255,255,248,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,
  // 0x63d0  提
  208,99,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,255,255,199,255,255,192,255,255,199,255,255,192,255,255,199,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,113,199,255,255,192,0,113,199,255,255,192,0,113,199,255,255,192,0,126,0,0,0,0,0,126,0,0,0,0,0,126,0,0,0,0,3,240,63,255,255,248,3,240,63,255,255,248,3,240,63,255,255,248,252,112,0,3,128,0,252,112,0,3,128,0,252,112,0,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,255,192,0,112,7,3,255,192,0,112,7,3,255,192,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,28,112,56,227,128,0,28,112,56,227,128,0,28,112,56,227,128,0,3,129,192,31,255,248,3,129,192,31,255,248,3,129,192,31,255,248,
  // 0x63d2  插
  210,99,45,48,32,48,0,250,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,3,255,192,3,128,0,3,255,192,3,128,0,3,255,192,3,129,255,252,0,0,3,129,255,252,0,0,3,129,255,252,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,255,254,0,28,0,0,255,254,0,28,0,0,255,254,0,28,0,0,3,143,255,255,255,248,3,143,255,255,255,248,3,143,255,255,255,248,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,142,7,28,0,0,3,142,7,28,0,0,3,142,7,28,0,0,3,241,248,28,127,192,3,241,248,28,127,192,3,241,248,28,127,192,255,129,192,28,1,192,255,129,192,28,1,192,255,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,255,28,127,192,3,129,255,28,127,192,3,129,255,28,127,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,227,129,255,255,255,192,227,129,255,255,255,192,227,129,255,255,255,192,28,1,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,
  // 0x63db  換
  219,99,45,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,56,0,0,56,0,112,56,0,0,56,0,112,56,0,0,56,0,126,56,28,112,56,0,126,56,28,112,56,0,126,56,28,112,56,3,240,56,224,14,56,3,240,56,224,14,56,3,240,56,224,14,56,252,112,56,3,128,56,252,112,56,3,128,56,252,112,56,3,128,56,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,28,112,7,0,1,192,28,112,7,0,1,192,28,112,7,0,1,192,3,129,248,0,0,56,3,129,248,0,0,56,3,129,248,0,0,56,
  // 0x64c7  擇
  199,100,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,56,28,112,56,0,112,56,28,112,56,0,112,56,28,112,56,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,126,63,255,255,248,0,126,63,255,255,248,0,126,63,255,255,248,3,240,0,224,14,0,3,240,0,224,14,0,3,240,0,224,14,0,252,112,0,28,112,0,252,112,0,28,112,0,252,112,0,28,112,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,
  // 0x64ca  擊
  202,100,45,48,32,48,0,250,0,14,0,3,255,192,0,14,0,3,255,192,0,14,0,3,255,192,31,255,255,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,3,142,56,3,129,192,3,142,56,3,129,192,3,142,56,3,129,192,3,255,248,28,0,56,3,255,248,28,0,56,3,255,248,28,0,56,3,142,56,3,255,192,3,142,56,3,255,192,3,142,56,3,255,192,255,255,255,227,129,192,255,255,255,227,129,192,255,255,255,227,129,192,28,14,7,0,126,0,28,14,7,0,126,0,28,14,7,0,126,0,31,255,255,31,129,248,31,255,255,31,129,248,31,255,255,31,129,248,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,127,255,252,0,0,0,127,255,252,0,0,0,127,255,252,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,
  // 0x64cb  擋
  203,100,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,7,28,112,0,3,128,7,28,112,0,3,128,7,28,112,0,3,129,255,255,255,248,3,129,255,255,255,248,3,129,255,255,255,248,255,241,192,0,0,56,255,241,192,0,0,56,255,241,192,0,0,56,3,142,0,0,1,192,3,142,0,0,1,192,3,142,0,0,1,192,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,240,63,255,254,0,3,240,63,255,254,0,3,240,63,255,254,0,255,128,0,0,0,0,255,128,0,0,0,0,255,128,0,0,0,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,227,129,255,255,255,192,227,129,255,255,255,192,227,129,255,255,255,192,28,1,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,
  // 0x64e0  擠
  224,100,45,48,32,48,0,250,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,255,240,0,227,129,192,255,240,0,227,129,192,255,240,0,227,129,192,3,143,255,28,126,0,3,143,255,28,126,0,3,143,255,28,126,0,3,129,199,28,113,192,3,129,199,28,113,192,3,129,199,28,113,192,3,129,199,28,112,56,3,129,199,28,112,56,3,129,199,28,112,56,3,254,63,28,126,0,3,254,63,28,126,0,3,254,63,28,126,0,255,128,0,0,0,0,255,128,0,0,0,0,255,128,0,0,0,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,227,128,56,0,14,0,227,128,56,0,14,0,227,128,56,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,
  // 0x6536  收
  54,101,42,48,32,48,3,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,7,0,0,0,224,112,7,0,0,0,224,112,7,0,0,0,224,112,7,255,255,192,224,112,7,255,255,192,224,112,7,255,255,192,224,112,56,0,112,0,224,112,56,0,112,0,224,112,56,0,112,0,224,113,199,0,112,0,224,113,199,0,112,0,224,113,199,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,227,240,0,227,128,0,227,240,0,227,128,0,227,240,0,227,128,0,252,112,0,227,128,0,252,112,0,227,128,0,252,112,0,227,128,0,224,112,0,28,0,0,224,112,0,28,0,0,224,112,0,28,0,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,113,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,
  // 0x653e  放
  62,101,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,255,248,224,0,0,255,255,248,224,0,0,255,255,248,224,0,0,3,128,0,255,255,248,3,128,0,255,255,248,3,128,0,255,255,248,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,248,224,14,0,3,255,248,224,14,0,3,255,248,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,113,192,224,14,0,28,113,192,224,14,0,28,113,192,224,14,0,224,14,7,0,1,192,224,14,7,0,1,192,224,14,7,0,1,192,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,
  // 0x6557  敗
  87,101,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,31,255,192,28,0,0,31,255,192,28,0,0,31,255,192,28,0,0,28,1,192,224,0,0,28,1,192,224,0,0,28,1,192,224,0,0,28,1,192,255,255,248,28,1,192,255,255,248,28,1,192,255,255,248,31,255,199,0,14,0,31,255,199,0,14,0,31,255,199,0,14,0,28,1,199,0,14,0,28,1,199,0,14,0,28,1,199,0,14,0,28,1,248,224,14,0,28,1,248,224,14,0,28,1,248,224,14,0,31,255,192,224,14,0,31,255,192,224,14,0,31,255,192,224,14,0,28,1,192,224,14,0,28,1,192,224,14,0,28,1,192,224,14,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,31,255,192,28,112,0,31,255,192,28,112,0,31,255,192,28,112,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,3,142,0,28,112,0,3,142,0,28,112,0,3,142,0,28,112,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,28,1,199,0,1,192,28,1,199,0,1,192,28,1,199,0,1,192,224,0,56,0,0,56,224,0,56,0,0,56,224,0,56,0,0,56,
  // 0x6574  整
  116,101,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,255,255,255,227,255,248,255,255,255,227,255,248,255,255,255,227,255,248,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,31,255,255,227,129,192,31,255,255,227,129,192,31,255,255,227,129,192,28,14,7,3,129,192,28,14,7,3,129,192,28,14,7,3,129,192,31,255,255,3,142,0,31,255,255,3,142,0,31,255,255,3,142,0,3,142,56,0,112,0,3,142,56,0,112,0,3,142,56,0,112,0,28,14,7,3,142,0,28,14,7,3,142,0,28,14,7,3,142,0,224,14,0,28,1,248,224,14,0,28,1,248,224,14,0,28,1,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x6578  數
  120,101,45,48,32,48,0,250,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,31,255,255,0,112,0,31,255,255,0,112,0,31,255,255,0,112,0,28,14,7,0,112,0,28,14,7,0,112,0,28,14,7,0,112,0,255,255,255,227,128,0,255,255,255,227,128,0,255,255,255,227,128,0,28,14,7,3,255,248,28,14,7,3,255,248,28,14,7,3,255,248,31,255,255,28,1,192,31,255,255,28,1,192,31,255,255,28,1,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,28,14,7,3,129,192,28,14,7,3,129,192,28,14,7,3,129,192,31,255,255,3,142,0,31,255,255,3,142,0,31,255,255,3,142,0,0,112,0,3,142,0,0,112,0,3,142,0,0,112,0,3,142,0,255,255,255,0,112,0,255,255,255,0,112,0,255,255,255,0,112,0,3,128,7,3,142,0,3,128,7,3,142,0,3,128,7,3,142,0,31,240,56,3,142,0,31,240,56,3,142,0,31,240,56,3,142,0,0,15,192,28,1,192,0,15,192,28,1,192,0,15,192,28,1,192,255,240,63,224,0,56,255,240,63,224,0,56,255,240,63,224,0,56,
  // 0x6599  料
  153,101,45,48,32,48,0,250,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,28,14,56,28,14,0,28,14,56,28,14,0,28,14,56,28,14,0,3,142,56,28,14,0,3,142,56,28,14,0,3,142,56,28,14,0,3,143,192,0,14,0,3,143,192,0,14,0,3,143,192,0,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,255,255,248,28,14,0,255,255,248,28,14,0,255,255,248,28,14,0,0,126,0,28,14,0,0,126,0,28,14,0,0,126,0,28,14,0,0,127,192,0,14,0,0,127,192,0,14,0,0,127,192,0,14,0,3,142,56,0,15,248,3,142,56,0,15,248,3,142,56,0,15,248,3,142,56,255,254,0,3,142,56,255,254,0,3,142,56,255,254,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,
  // 0x659c  斜
  156,101,45,48,32,48,0,250,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,113,192,3,142,0,0,113,192,3,142,0,0,113,192,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,28,0,7,0,14,0,28,0,7,0,14,0,28,0,7,0,14,0,227,255,248,28,14,0,227,255,248,28,14,0,227,255,248,28,14,0,0,14,0,3,142,0,0,14,0,3,142,0,0,14,0,3,142,0,0,14,0,3,142,0,0,14,0,3,142,0,0,14,0,3,142,0,31,255,255,0,15,248,31,255,255,0,15,248,31,255,255,0,15,248,0,14,0,31,254,0,0,14,0,31,254,0,0,14,0,31,254,0,3,142,56,0,14,0,3,142,56,0,14,0,3,142,56,0,14,0,3,142,7,0,14,0,3,142,7,0,14,0,3,142,7,0,14,0,28,14,7,0,14,0,28,14,7,0,14,0,28,14,7,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,3,142,0,0,14,0,3,142,0,0,14,0,3,142,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,
  // 0x65b0  新
  176,101,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,31,255,255,31,254,0,31,255,255,31,254,0,31,255,255,31,254,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,128,56,28,0,0,3,128,56,28,0,0,3,128,56,28,0,0,0,113,192,28,0,0,0,113,192,28,0,0,0,113,192,28,0,0,255,255,255,31,255,248,255,255,255,31,255,248,255,255,255,31,255,248,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,31,255,255,28,14,0,31,255,255,28,14,0,31,255,255,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,3,142,56,28,14,0,3,142,56,28,14,0,3,142,56,28,14,0,28,14,7,28,14,0,28,14,7,28,14,0,28,14,7,28,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,3,142,0,224,14,0,3,142,0,224,14,0,3,142,0,224,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,
  // 0x65b7  斷
  183,101,42,48,32,48,3,250,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,227,128,7,3,254,0,227,128,7,3,254,0,227,128,7,3,254,0,227,254,56,227,128,0,227,254,56,227,128,0,227,254,56,227,128,0,224,112,63,227,128,0,224,112,63,227,128,0,224,112,63,227,128,0,227,142,7,3,128,0,227,142,7,3,128,0,227,142,7,3,128,0,227,254,63,227,255,192,227,254,63,227,255,192,227,254,63,227,255,192,224,14,0,227,142,0,224,14,0,227,142,0,224,14,0,227,142,0,255,255,255,227,142,0,255,255,255,227,142,0,255,255,255,227,142,0,224,112,7,3,142,0,224,112,7,3,142,0,224,112,7,3,142,0,227,128,7,3,142,0,227,128,7,3,142,0,227,128,7,3,142,0,227,254,56,227,142,0,227,254,56,227,142,0,227,254,56,227,142,0,224,112,63,227,142,0,224,112,63,227,142,0,224,112,63,227,142,0,227,142,7,3,142,0,227,142,7,3,142,0,227,142,7,3,142,0,227,254,63,227,142,0,227,254,63,227,142,0,227,254,63,227,142,0,224,14,0,252,14,0,224,14,0,252,14,0,224,14,0,252,14,0,255,255,255,224,14,0,255,255,255,224,14,0,255,255,255,224,14,0,
  // 0x65bc  於
  188,101,45,45,14,48,0,253,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,255,255,248,28,112,0,255,255,248,28,112,0,255,255,248,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,255,199,0,1,192,3,255,199,0,1,192,3,255,199,0,1,192,3,129,248,0,0,56,3,129,248,0,0,56,3,129,248,0,0,56,3,129,192,31,128,0,3,129,192,31,128,0,3,129,192,31,128,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,252,0,0,3,129,192,252,0,0,3,129,192,252,0,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,113,192,0,112,0,28,113,192,0,112,0,28,113,192,0,112,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,
  // 0x6607  昇
  7,102,45,45,14,48,0,250,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,3,128,0,0,1,255,3,128,0,0,1,255,3,128,0,31,254,0,3,128,0,31,254,0,3,128,0,31,254,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,
  // 0x660e  明
  14,102,39,45,225,48,3,250,0,0,7,255,254,0,0,7,255,254,0,0,7,255,254,255,254,7,0,14,255,254,7,0,14,255,254,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,255,254,224,14,7,255,254,224,14,7,255,254,255,254,7,0,14,255,254,7,0,14,255,254,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,255,254,224,14,7,255,254,224,14,7,255,254,255,254,7,0,14,255,254,7,0,14,255,254,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,1,192,3,142,0,1,192,3,142,0,1,192,3,142,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,
  // 0x662f  是
  47,102,45,48,32,48,0,250,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,3,142,7,0,0,0,3,142,7,0,0,0,3,142,7,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,224,0,63,255,255,248,224,0,63,255,255,248,224,0,63,255,255,248,
  // 0x6642  時
  66,102,42,48,32,48,3,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,254,0,28,0,0,255,254,0,28,0,0,255,254,0,28,0,0,224,14,63,255,254,0,224,14,63,255,254,0,224,14,63,255,254,0,224,14,0,28,0,0,224,14,0,28,0,0,224,14,0,28,0,0,224,14,0,28,0,0,224,14,0,28,0,0,224,14,0,28,0,0,224,15,255,255,255,192,224,15,255,255,255,192,224,15,255,255,255,192,255,254,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,63,255,255,192,224,14,63,255,255,192,224,14,63,255,255,192,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,7,0,112,0,224,14,7,0,112,0,224,14,7,0,112,0,255,254,0,224,112,0,255,254,0,224,112,0,255,254,0,224,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0x66ab  暫
  171,102,42,48,32,48,3,250,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,255,255,248,255,240,0,255,255,248,255,240,0,255,255,248,255,240,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,255,255,248,224,0,0,255,255,248,224,0,0,255,255,248,224,0,0,224,112,56,255,255,192,224,112,56,255,255,192,224,112,56,255,255,192,255,255,248,224,112,0,255,255,248,224,112,0,255,255,248,224,112,0,224,112,56,224,112,0,224,112,56,224,112,0,224,112,56,224,112,0,255,255,248,224,112,0,255,255,248,224,112,0,255,255,248,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,255,255,248,224,112,0,255,255,248,224,112,0,255,255,248,224,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,3,255,255,255,128,0,3,255,255,255,128,0,3,255,255,255,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,255,255,255,128,0,3,255,255,255,128,0,3,255,255,255,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,255,255,255,128,0,3,255,255,255,128,0,3,255,255,255,128,0,
  // 0x66f4  更
  244,102,45,45,14,48,0,250,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,14,56,0,0,0,0,14,56,0,0,0,0,14,56,0,0,0,0,1,248,0,0,0,0,1,248,0,0,0,0,1,248,0,0,0,0,126,7,252,0,0,0,126,7,252,0,0,0,126,7,252,0,0,255,128,0,3,255,248,255,128,0,3,255,248,255,128,0,3,255,248,
  // 0x6700  最
  0,103,45,48,32,48,0,250,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,3,128,56,0,0,0,3,128,56,0,0,0,3,128,56,0,0,0,3,255,248,255,254,0,3,255,248,255,254,0,3,255,248,255,254,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,255,248,224,112,0,3,255,248,224,112,0,3,255,248,224,112,0,3,128,56,28,112,0,3,128,56,28,112,0,3,128,56,28,112,0,3,143,255,3,128,0,3,143,255,3,128,0,3,143,255,3,128,0,255,240,56,28,112,0,255,240,56,28,112,0,255,240,56,28,112,0,28,0,56,224,14,0,28,0,56,224,14,0,28,0,56,224,14,0,0,0,63,0,1,248,0,0,63,0,1,248,0,0,63,0,1,248,
  // 0x6709  有
  9,103,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,3,143,255,255,240,0,3,143,255,255,240,0,3,143,255,255,240,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,28,112,0,0,14,0,28,112,0,0,14,0,28,112,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,
  // 0x677f  板
  127,103,45,48,32,48,0,250,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,127,192,0,112,0,0,127,192,0,112,0,0,127,192,0,112,7,255,128,0,0,112,7,255,128,0,0,112,7,255,128,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,255,255,199,0,0,0,255,255,199,0,0,0,255,255,199,0,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,3,240,7,28,1,192,3,240,7,28,1,192,3,240,7,28,1,192,3,254,7,28,1,192,3,254,7,28,1,192,3,254,7,28,1,192,28,113,199,28,1,192,28,113,199,28,1,192,28,113,199,28,1,192,28,113,199,3,142,0,28,113,199,3,142,0,28,113,199,3,142,0,224,112,7,3,142,0,224,112,7,3,142,0,224,112,7,3,142,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,113,192,224,0,56,0,113,192,224,0,56,0,113,192,224,0,56,
  // 0x67f1  柱
  241,103,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,240,0,3,128,0,3,240,0,3,128,0,3,240,0,3,128,0,3,254,0,3,128,0,3,254,0,3,128,0,3,254,0,3,128,0,28,113,199,255,255,192,28,113,199,255,255,192,28,113,199,255,255,192,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x6821  校
  33,104,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,7,255,255,248,0,112,7,255,255,248,0,112,7,255,255,248,255,255,192,0,0,0,255,255,192,0,0,0,255,255,192,0,0,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,3,240,7,0,1,192,3,240,7,0,1,192,3,240,7,0,1,192,3,254,56,0,0,56,3,254,56,0,0,56,3,254,56,0,0,56,28,113,192,224,14,0,28,113,192,224,14,0,28,113,192,224,14,0,28,112,0,224,14,0,28,112,0,224,14,0,28,112,0,224,14,0,224,112,0,28,112,0,224,112,0,28,112,0,224,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,63,0,1,248,0,112,63,0,1,248,0,112,63,0,1,248,
  // 0x683c  格
  60,104,45,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,255,254,63,0,112,0,255,254,63,0,112,0,255,254,63,0,112,0,0,113,192,227,128,0,0,113,192,227,128,0,0,113,192,227,128,0,3,240,0,28,0,0,3,240,0,28,0,0,3,240,0,28,0,0,3,254,0,227,128,0,3,254,0,227,128,0,3,254,0,227,128,0,28,113,199,0,126,0,28,113,199,0,126,0,28,113,199,0,126,0,28,112,56,0,1,248,28,112,56,0,1,248,28,112,56,0,1,248,224,113,199,255,254,0,224,113,199,255,254,0,224,113,199,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,
  // 0x689d  條
  157,104,45,48,32,48,0,250,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,3,241,199,28,112,0,3,241,199,28,112,0,3,241,199,28,112,0,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,224,113,192,252,126,0,224,113,192,252,126,0,224,113,192,252,126,0,0,113,255,3,129,248,0,113,255,3,129,248,0,113,255,3,129,248,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,113,199,255,255,192,0,113,199,255,255,192,0,113,199,255,255,192,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,227,142,0,0,113,192,227,142,0,0,113,192,227,142,0,0,113,199,3,129,192,0,113,199,3,129,192,0,113,199,3,129,192,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,
  // 0x68c4  棄
  196,104,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,14,0,0,0,7,0,14,0,0,0,7,0,14,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,1,199,28,0,0,0,1,199,28,0,0,0,1,199,28,0,0,0,126,7,3,240,0,0,126,7,3,240,0,0,126,7,3,240,0,255,128,7,0,15,248,255,128,7,0,15,248,255,128,7,0,15,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x69fd  槽
  253,105,45,48,32,48,0,250,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,255,254,63,255,255,192,255,254,63,255,255,192,255,254,63,255,255,192,0,112,56,224,113,192,0,112,56,224,113,192,0,112,56,224,113,192,3,240,63,255,255,192,3,240,63,255,255,192,3,240,63,255,255,192,3,254,56,224,113,192,3,254,56,224,113,192,3,254,56,224,113,192,28,113,255,255,255,192,28,113,255,255,255,192,28,113,255,255,255,192,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,224,112,7,255,254,0,224,112,7,255,254,0,224,112,7,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,
  // 0x6a59  橙
  89,106,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,113,255,227,129,192,0,113,255,227,129,192,0,113,255,227,129,192,0,112,0,227,142,0,0,112,0,227,142,0,0,112,0,227,142,0,0,112,56,224,112,56,0,112,56,224,112,56,0,112,56,224,112,56,255,254,7,0,113,192,255,254,7,0,113,192,255,254,7,0,113,192,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,3,241,199,255,241,192,3,241,199,255,241,192,3,241,199,255,241,192,3,254,0,0,0,56,3,254,0,0,0,56,3,254,0,0,0,56,28,113,255,255,254,0,28,113,255,255,254,0,28,113,255,255,254,0,28,112,56,0,14,0,28,112,56,0,14,0,28,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,255,248,0,127,255,255,255,248,0,127,255,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x6a5f  機
  95,106,45,48,32,48,0,250,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,56,227,142,56,0,112,56,227,142,56,0,112,56,227,142,56,0,112,63,227,143,248,0,112,63,227,143,248,0,112,63,227,143,248,255,254,7,3,129,192,255,254,7,3,129,192,255,254,7,3,129,192,0,112,56,227,142,56,0,112,56,227,142,56,0,112,56,227,142,56,3,240,63,227,143,248,3,240,63,227,143,248,3,240,63,227,143,248,3,254,7,3,129,192,3,254,7,3,129,192,3,254,7,3,129,192,28,113,255,255,255,248,28,113,255,255,255,248,28,113,255,255,255,248,28,112,7,0,112,0,28,112,7,0,112,0,28,112,7,0,112,0,224,112,7,0,113,192,224,112,7,0,113,192,224,112,7,0,113,192,0,112,7,0,113,192,0,112,7,0,113,192,0,112,7,0,113,192,0,112,56,224,14,56,0,112,56,224,14,56,0,112,56,224,14,56,0,112,56,28,14,56,0,112,56,28,14,56,0,112,56,28,14,56,0,112,56,0,113,248,0,112,56,0,113,248,0,112,56,0,113,248,0,113,192,3,128,56,0,113,192,3,128,56,0,113,192,3,128,56,
  // 0x6aa2  檢
  162,106,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,255,255,199,0,1,192,255,255,199,0,1,192,255,255,199,0,1,192,0,112,56,255,254,56,0,112,56,255,254,56,0,112,56,255,254,56,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,3,254,0,0,0,0,3,254,0,0,0,0,3,254,0,0,0,0,28,113,199,252,127,192,28,113,199,252,127,192,28,113,199,252,127,192,28,113,199,28,113,192,28,113,199,28,113,192,28,113,199,28,113,192,224,112,7,28,113,192,224,112,7,28,113,192,224,112,7,28,113,192,0,112,7,252,127,192,0,112,7,252,127,192,0,112,7,252,127,192,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,7,28,113,192,0,112,7,28,113,192,0,112,7,28,113,192,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,
  // 0x6b62  止
  98,107,45,45,14,48,0,253,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x6b63  正
  99,107,45,42,252,48,0,253,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x6b65  步
  101,107,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,3,128,7,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,28,0,0,252,0,0,28,0,0,252,0,0,28,0,0,252,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,255,128,0,0,0,0,255,128,0,0,0,0,255,128,0,0,0,0,
  // 0x6b78  歸
  120,107,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,31,255,199,255,255,192,31,255,199,255,255,192,31,255,199,255,255,192,28,1,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,31,255,192,255,255,192,31,255,192,255,255,192,31,255,192,255,255,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,31,255,199,255,255,192,31,255,199,255,255,192,31,255,199,255,255,192,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,28,127,199,255,255,192,28,127,199,255,255,192,28,127,199,255,255,192,28,112,7,3,129,192,28,112,7,3,129,192,28,112,7,3,129,192,28,112,7,3,129,192,28,112,7,3,129,192,28,112,7,3,129,192,28,127,199,3,241,192,28,127,199,3,241,192,28,127,199,3,241,192,255,128,7,3,142,0,255,128,7,3,142,0,255,128,7,3,142,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0x6bbc  殼
  188,107,45,48,32,48,0,250,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,31,254,0,0,14,0,31,254,0,0,14,0,31,254,0,31,255,255,28,14,0,31,255,255,28,14,0,31,255,255,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,3,255,248,28,14,0,3,255,248,28,14,0,3,255,248,28,14,0,0,0,0,224,1,248,0,0,0,224,1,248,0,0,0,224,1,248,31,255,255,0,0,0,31,255,255,0,0,0,31,255,255,0,0,0,28,0,7,255,255,192,28,0,7,255,255,192,28,0,7,255,255,192,227,255,248,28,1,192,227,255,248,28,1,192,227,255,248,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,3,255,192,3,142,0,3,255,192,3,142,0,3,255,192,3,142,0,3,129,192,3,142,0,3,129,192,3,142,0,3,129,192,3,142,0,3,129,199,0,112,0,3,129,199,0,112,0,3,129,199,0,112,0,3,129,248,3,142,0,3,129,248,3,142,0,3,129,248,3,142,0,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,224,0,7,224,0,56,224,0,7,224,0,56,224,0,7,224,0,56,
  // 0x6bd4  比
  212,107,39,45,225,48,6,253,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,112,224,0,56,0,112,224,0,56,0,112,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,255,254,56,224,0,255,254,56,224,0,255,254,56,224,0,224,0,63,0,0,224,0,63,0,0,224,0,63,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,126,56,0,14,224,126,56,0,14,224,126,56,0,14,255,128,56,0,14,255,128,56,0,14,255,128,56,0,14,224,0,7,255,254,224,0,7,255,254,224,0,7,255,254,
  // 0x6c92  沒
  146,108,45,48,32,48,0,250,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,224,0,7,0,1,192,224,0,7,0,1,192,224,0,7,0,1,192,28,0,56,3,142,0,28,0,56,3,142,0,28,0,56,3,142,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,0,14,63,255,255,192,0,14,63,255,255,192,0,14,63,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,255,128,0,224,14,0,255,128,0,224,14,0,255,128,0,224,14,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,7,224,14,0,3,128,7,224,14,0,3,128,7,224,14,0,0,1,248,0,1,248,0,1,248,0,1,248,0,1,248,0,1,248,
  // 0x6d88  消
  136,109,39,48,240,48,0,250,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,3,128,56,28,14,3,128,56,28,14,3,128,56,28,14,0,112,7,28,14,0,112,7,28,14,0,112,7,28,14,0,112,7,28,112,0,112,7,28,112,0,112,7,28,112,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,28,0,63,255,254,28,0,63,255,254,28,0,63,255,254,28,14,56,0,14,28,14,56,0,14,28,14,56,0,14,0,14,56,0,14,0,14,56,0,14,0,14,56,0,14,0,112,63,255,254,0,112,63,255,254,0,112,63,255,254,0,112,56,0,14,0,112,56,0,14,0,112,56,0,14,255,128,56,0,14,255,128,56,0,14,255,128,56,0,14,3,128,63,255,254,3,128,63,255,254,3,128,63,255,254,3,128,56,0,14,3,128,56,0,14,3,128,56,0,14,3,128,56,0,14,3,128,56,0,14,3,128,56,0,14,3,128,56,3,142,3,128,56,3,142,3,128,56,3,142,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,
  // 0x6de1  淡
  225,109,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,113,192,28,14,0,0,113,192,28,14,0,0,113,192,28,14,0,224,0,0,227,128,0,224,0,0,227,128,0,224,0,0,227,128,0,28,0,7,0,112,0,28,0,7,0,112,0,28,0,7,0,112,0,28,1,248,0,14,0,28,1,248,0,14,0,28,1,248,0,14,0,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,255,128,56,28,14,0,255,128,56,28,14,0,255,128,56,28,14,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,0,15,192,0,1,248,0,15,192,0,1,248,0,15,192,0,1,248,
  // 0x6e05  清
  5,110,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,224,0,63,255,254,0,224,0,63,255,254,0,224,0,63,255,254,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,15,255,255,255,248,28,15,255,255,255,248,28,15,255,255,255,248,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,255,128,56,0,14,0,255,128,56,0,14,0,255,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,
  // 0x6e2c  測
  44,110,45,48,32,48,0,250,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,3,129,255,252,0,56,3,129,255,252,0,56,3,129,255,252,0,56,0,113,192,28,0,56,0,113,192,28,0,56,0,113,192,28,0,56,0,113,192,28,112,56,0,113,192,28,112,56,0,113,192,28,112,56,224,1,255,252,112,56,224,1,255,252,112,56,224,1,255,252,112,56,28,1,192,28,112,56,28,1,192,28,112,56,28,1,192,28,112,56,28,1,192,28,112,56,28,1,192,28,112,56,28,1,192,28,112,56,0,113,255,252,112,56,0,113,255,252,112,56,0,113,255,252,112,56,0,113,192,28,112,56,0,113,192,28,112,56,0,113,192,28,112,56,3,129,192,28,112,56,3,129,192,28,112,56,3,129,192,28,112,56,255,129,255,252,112,56,255,129,255,252,112,56,255,129,255,252,112,56,3,128,0,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,3,128,56,224,0,56,3,128,56,224,0,56,3,128,56,224,0,56,3,128,56,28,0,56,3,128,56,28,0,56,3,128,56,28,0,56,3,129,192,28,14,56,3,129,192,28,14,56,3,129,192,28,14,56,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,
  // 0x6e90  源
  144,110,45,45,14,48,0,250,3,129,255,255,255,248,3,129,255,255,255,248,3,129,255,255,255,248,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,28,0,0,0,113,192,28,0,0,0,113,192,28,0,0,224,1,199,255,255,192,224,1,199,255,255,192,224,1,199,255,255,192,28,1,199,0,1,192,28,1,199,0,1,192,28,1,199,0,1,192,28,1,199,255,255,192,28,1,199,255,255,192,28,1,199,255,255,192,0,113,199,0,1,192,0,113,199,0,1,192,0,113,199,0,1,192,0,113,199,255,255,192,0,113,199,255,255,192,0,113,199,255,255,192,3,129,199,3,129,192,3,129,199,3,129,192,3,129,199,3,129,192,255,129,192,3,128,0,255,129,192,3,128,0,255,129,192,3,128,0,3,129,192,227,142,0,3,129,192,227,142,0,3,129,192,227,142,0,3,142,7,3,129,192,3,142,7,3,129,192,3,142,7,3,129,192,3,142,56,3,128,56,3,142,56,3,128,56,3,142,56,3,128,56,3,240,0,227,128,0,3,240,0,227,128,0,3,240,0,227,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x6e96  準
  150,110,45,48,32,48,0,250,3,128,7,28,0,0,3,128,7,28,0,0,3,128,7,28,0,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,224,0,63,255,255,192,224,0,63,255,255,192,224,0,63,255,255,192,28,112,56,28,0,0,28,112,56,28,0,0,28,112,56,28,0,0,0,113,255,255,254,0,0,113,255,255,254,0,0,113,255,255,254,0,3,142,56,28,0,0,3,142,56,28,0,0,3,142,56,28,0,0,255,128,63,255,254,0,255,128,63,255,254,0,255,128,63,255,254,0,3,128,56,28,0,0,3,128,56,28,0,0,3,128,56,28,0,0,3,128,63,255,255,192,3,128,63,255,255,192,3,128,63,255,255,192,3,128,56,0,0,0,3,128,56,0,0,0,3,128,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x6eab  溫
  171,110,45,45,14,48,0,253,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,0,14,56,28,14,0,0,14,56,28,14,0,0,14,56,28,14,0,224,14,56,227,142,0,224,14,56,227,142,0,224,14,56,227,142,0,28,112,63,0,14,0,28,112,63,0,14,0,28,112,63,0,14,0,28,112,63,255,254,0,28,112,63,255,254,0,28,112,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,252,1,255,255,255,192,252,1,255,255,255,192,252,1,255,255,255,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,15,255,255,255,248,28,15,255,255,255,248,28,15,255,255,255,248,
  // 0x6fc0  激
  192,111,45,48,32,48,0,250,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,3,143,255,224,112,0,3,143,255,224,112,0,3,143,255,224,112,0,3,142,0,224,112,0,3,142,0,224,112,0,3,142,0,224,112,0,0,15,255,227,255,248,0,15,255,227,255,248,0,15,255,227,255,248,224,14,0,227,129,192,224,14,0,227,129,192,224,14,0,227,129,192,28,15,255,252,113,192,28,15,255,252,113,192,28,15,255,252,113,192,28,113,192,0,113,192,28,113,192,0,113,192,28,113,192,0,113,192,0,112,56,0,113,192,0,112,56,0,113,192,0,112,56,0,113,192,3,143,255,252,113,192,3,143,255,252,113,192,3,143,255,252,113,192,255,129,192,0,113,192,255,129,192,0,113,192,255,129,192,0,113,192,3,129,255,224,14,0,3,129,255,224,14,0,3,129,255,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,142,0,224,113,192,3,142,0,224,113,192,3,142,0,224,113,192,3,142,56,224,113,192,3,142,56,224,113,192,3,142,56,224,113,192,0,112,7,3,128,56,0,112,7,3,128,56,0,112,7,3,128,56,
  // 0x7121  無
  33,113,42,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,127,255,255,255,192,0,127,255,255,255,192,0,127,255,255,255,192,3,142,56,227,128,0,3,142,56,227,128,0,3,142,56,227,128,0,28,14,56,227,128,0,28,14,56,227,128,0,28,14,56,227,128,0,0,14,56,227,128,0,0,14,56,227,128,0,0,14,56,227,128,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,14,56,227,128,0,0,14,56,227,128,0,0,14,56,227,128,0,0,14,56,227,128,0,0,14,56,227,128,0,0,14,56,227,128,0,0,14,56,227,128,0,0,14,56,227,128,0,0,14,56,227,128,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,28,0,56,28,1,192,28,0,56,28,1,192,28,0,56,28,1,192,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,
  // 0x71b1  熱
  177,113,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,31,255,192,28,0,0,31,255,192,28,0,0,31,255,192,28,0,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,255,254,0,255,255,248,28,14,0,255,255,248,28,14,0,255,255,248,28,14,0,28,1,192,28,14,0,28,1,192,28,14,0,28,1,192,28,14,0,224,112,56,252,14,0,224,112,56,252,14,0,224,112,56,252,14,0,31,255,192,28,14,0,31,255,192,28,14,0,31,255,192,28,14,0,0,112,0,227,142,56,0,112,0,227,142,56,0,112,0,227,142,56,0,127,192,227,142,56,0,127,192,227,142,56,0,127,192,227,142,56,255,128,7,0,1,248,255,128,7,0,1,248,255,128,7,0,1,248,28,0,56,0,0,56,28,0,56,0,0,56,28,0,56,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,14,0,224,14,0,28,14,0,224,14,0,28,14,0,224,14,0,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,28,1,192,
  // 0x71c8  燈
  200,113,45,48,32,48,0,250,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,129,255,227,129,192,3,129,255,227,129,192,3,129,255,227,129,192,3,128,0,227,142,0,3,128,0,227,142,0,3,128,0,227,142,0,3,142,56,224,112,56,3,142,56,224,112,56,3,142,56,224,112,56,227,240,7,0,113,192,227,240,7,0,113,192,227,240,7,0,113,192,227,128,56,0,14,0,227,128,56,0,14,0,227,128,56,0,14,0,227,129,199,255,241,192,227,129,199,255,241,192,227,129,199,255,241,192,227,142,0,0,0,56,227,142,0,0,0,56,227,142,0,0,0,56,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,28,112,56,0,14,0,28,112,56,0,14,0,28,112,56,0,14,0,28,14,7,0,112,0,28,14,7,0,112,0,28,14,7,0,112,0,28,15,255,255,255,248,28,15,255,255,255,248,28,15,255,255,255,248,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,
  // 0x7247  片
  71,114,39,48,240,48,3,250,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,252,0,3,255,255,252,0,3,255,255,252,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,
  // 0x7269  物
  105,114,42,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,28,112,0,224,0,0,28,112,0,224,0,0,28,112,0,224,0,0,28,112,0,255,255,192,28,112,0,255,255,192,28,112,0,255,255,192,31,255,199,28,113,192,31,255,199,28,113,192,31,255,199,28,113,192,28,112,56,28,113,192,28,112,56,28,113,192,28,112,56,28,113,192,224,112,0,28,113,192,224,112,0,28,113,192,224,112,0,28,113,192,0,112,0,224,113,192,0,112,0,224,113,192,0,112,0,224,113,192,0,127,192,224,113,192,0,127,192,224,113,192,0,127,192,224,113,192,255,240,7,3,129,192,255,240,7,3,129,192,255,240,7,3,129,192,28,112,56,3,129,192,28,112,56,3,129,192,28,112,56,3,129,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x7387  率
  135,115,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,3,143,255,224,14,0,3,143,255,224,14,0,3,143,255,224,14,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,28,15,255,255,129,192,28,15,255,255,129,192,28,15,255,255,129,192,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x7528  用
  40,117,39,45,225,48,0,250,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,28,0,7,0,14,28,0,7,0,14,28,0,7,0,14,28,0,7,3,142,28,0,7,3,142,28,0,7,3,142,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x754c  界
  76,117,45,45,14,48,0,250,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,15,192,31,128,0,0,15,192,31,128,0,0,15,192,31,128,0,3,241,192,28,126,0,3,241,192,28,126,0,3,241,192,28,126,0,252,1,192,28,1,248,252,1,192,28,1,248,252,1,192,28,1,248,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,
  // 0x767d  白
  125,118,33,48,240,48,6,250,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,
  // 0x7684  的
  132,118,39,48,240,48,3,250,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,28,0,0,224,0,28,0,0,224,0,28,0,0,224,0,255,255,192,255,254,255,255,192,255,254,255,255,192,255,254,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,1,248,0,14,224,1,248,0,14,224,1,248,0,14,224,1,192,224,14,224,1,192,224,14,224,1,192,224,14,255,255,192,28,14,255,255,192,28,14,255,255,192,28,14,224,1,192,28,14,224,1,192,28,14,224,1,192,28,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,255,255,192,0,14,255,255,192,0,14,255,255,192,0,14,224,1,192,28,112,224,1,192,28,112,224,1,192,28,112,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,
  // 0x76e3  監
  227,118,45,42,252,48,0,253,3,255,255,3,128,0,3,255,255,3,128,0,3,255,255,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,255,255,3,255,248,3,255,255,3,255,248,3,255,255,3,255,248,3,128,7,28,0,0,3,128,7,28,0,0,3,128,7,28,0,0,3,255,255,28,112,0,3,255,255,28,112,0,3,255,255,28,112,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,255,255,0,14,0,3,255,255,0,14,0,3,255,255,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x76f4  直
  244,118,45,45,14,48,0,253,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x7720  眠
  32,119,42,45,14,48,3,250,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,255,254,56,0,14,0,255,254,56,0,14,0,255,254,56,0,14,0,224,14,56,0,14,0,224,14,56,0,14,0,224,14,56,0,14,0,224,14,56,0,14,0,224,14,56,0,14,0,224,14,56,0,14,0,255,254,63,255,254,0,255,254,63,255,254,0,255,254,63,255,254,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,255,254,63,255,255,192,255,254,63,255,255,192,255,254,63,255,255,192,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,3,128,0,224,14,56,3,128,0,224,14,56,3,128,0,255,254,56,3,129,192,255,254,56,3,129,192,255,254,56,3,129,192,224,14,56,224,113,192,224,14,56,224,113,192,224,14,56,224,113,192,0,0,63,0,15,192,0,0,63,0,15,192,0,0,63,0,15,192,0,0,56,0,1,192,0,0,56,0,1,192,0,0,56,0,1,192,
  // 0x780d  砍
  13,120,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,255,192,28,0,0,255,255,192,28,0,0,255,255,192,28,0,0,0,112,0,31,255,192,0,112,0,31,255,192,0,112,0,31,255,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,255,199,3,128,0,3,255,199,3,128,0,3,255,199,3,128,0,31,129,192,3,128,0,31,129,192,3,128,0,31,129,192,3,128,0,31,129,192,3,128,0,31,129,192,3,128,0,31,129,192,3,128,0,227,129,192,28,112,0,227,129,192,28,112,0,227,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,255,192,224,14,0,3,255,192,224,14,0,3,255,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,
  // 0x78ba  確
  186,120,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,254,63,255,255,248,255,254,63,255,255,248,255,254,63,255,255,248,3,128,56,227,128,56,3,128,56,227,128,56,3,128,56,227,128,56,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,28,0,7,255,255,248,28,0,7,255,255,248,28,0,7,255,255,248,31,254,7,0,112,0,31,254,7,0,112,0,31,254,7,0,112,0,28,14,63,0,112,0,28,14,63,0,112,0,28,14,63,0,112,0,252,15,199,255,255,248,252,15,199,255,255,248,252,15,199,255,255,248,28,14,7,0,112,0,28,14,7,0,112,0,28,14,7,0,112,0,28,14,7,0,112,0,28,14,7,0,112,0,28,14,7,0,112,0,28,14,7,255,255,248,28,14,7,255,255,248,28,14,7,255,255,248,31,254,7,0,112,0,31,254,7,0,112,0,31,254,7,0,112,0,28,14,7,0,112,0,28,14,7,0,112,0,28,14,7,0,112,0,0,0,7,255,255,248,0,0,7,255,255,248,0,0,7,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x79fb  移
  251,121,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,127,192,3,128,0,0,127,192,3,128,0,0,127,192,3,128,0,255,240,0,31,255,192,255,240,0,31,255,192,255,240,0,31,255,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,7,28,14,0,0,112,7,28,14,0,0,112,7,28,14,0,255,255,192,3,240,0,255,255,192,3,240,0,255,255,192,3,240,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,240,0,28,14,0,3,240,0,28,14,0,3,240,0,28,14,0,3,254,7,224,112,0,3,254,7,224,112,0,3,254,7,224,112,0,28,113,192,3,255,248,28,113,192,3,255,248,28,113,192,3,255,248,28,113,192,28,0,56,28,113,192,28,0,56,28,113,192,28,0,56,224,112,7,227,129,192,224,112,7,227,129,192,224,112,7,227,129,192,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,128,0,0,112,0,31,128,0,0,112,0,31,128,0,0,112,7,224,0,0,0,112,7,224,0,0,0,112,7,224,0,0,
  // 0x7a4d  積
  77,122,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,127,199,255,255,248,0,127,199,255,255,248,0,127,199,255,255,248,255,240,0,3,128,0,255,240,0,3,128,0,255,240,0,3,128,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,255,255,199,255,255,248,255,255,199,255,255,248,255,255,199,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,240,7,255,255,192,3,240,7,255,255,192,3,240,7,255,255,192,3,254,7,0,1,192,3,254,7,0,1,192,3,254,7,0,1,192,28,113,199,255,255,192,28,113,199,255,255,192,28,113,199,255,255,192,28,113,199,0,1,192,28,113,199,0,1,192,28,113,199,0,1,192,224,112,7,255,255,192,224,112,7,255,255,192,224,112,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,
  // 0x7aef  端
  239,122,45,48,32,48,0,250,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,255,255,199,3,129,192,255,255,199,3,129,192,255,255,199,3,129,192,0,0,7,255,255,192,0,0,7,255,255,192,0,0,7,255,255,192,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,224,14,63,255,255,248,224,14,63,255,255,248,224,14,63,255,255,248,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,28,14,0,28,0,0,28,14,0,28,0,0,28,14,0,28,0,0,28,14,7,255,255,192,28,14,7,255,255,192,28,14,7,255,255,192,28,112,7,28,113,192,28,112,7,28,113,192,28,112,7,28,113,192,28,112,7,28,113,192,28,112,7,28,113,192,28,112,7,28,113,192,0,127,199,28,113,192,0,127,199,28,113,192,0,127,199,28,113,192,255,128,7,28,113,192,255,128,7,28,113,192,255,128,7,28,113,192,28,0,7,28,113,192,28,0,7,28,113,192,28,0,7,28,113,192,0,0,7,0,15,192,0,0,7,0,15,192,0,0,7,0,15,192,
  // 0x7b49  等
  73,123,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,255,255,31,255,248,3,255,255,31,255,248,3,255,255,31,255,248,28,14,0,224,112,0,28,14,0,224,112,0,28,14,0,224,112,0,224,1,199,0,14,0,224,1,199,0,14,0,224,1,199,0,14,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,227,128,0,0,1,192,227,128,0,0,1,192,227,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x7ba1  管
  161,123,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,255,255,31,255,248,3,255,255,31,255,248,3,255,255,31,255,248,28,14,0,224,112,0,28,14,0,224,112,0,28,14,0,224,112,0,224,1,199,0,14,0,224,1,199,0,14,0,224,1,199,0,14,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,127,255,255,129,192,224,127,255,255,129,192,224,127,255,255,129,192,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,127,255,255,128,0,0,127,255,255,128,0,0,127,255,255,128,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x7bb1  箱
  177,123,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,255,255,31,255,248,3,255,255,31,255,248,3,255,255,31,255,248,3,142,0,224,112,0,3,142,0,224,112,0,3,142,0,224,112,0,28,1,199,0,14,0,28,1,199,0,14,0,28,1,199,0,14,0,224,14,0,0,0,0,224,14,0,0,0,0,224,14,0,0,0,0,0,14,0,255,255,192,0,14,0,255,255,192,0,14,0,255,255,192,31,255,248,224,1,192,31,255,248,224,1,192,31,255,248,224,1,192,0,14,0,224,1,192,0,14,0,224,1,192,0,14,0,224,1,192,0,126,0,255,255,192,0,126,0,255,255,192,0,126,0,255,255,192,0,127,192,224,1,192,0,127,192,224,1,192,0,127,192,224,1,192,3,142,56,224,1,192,3,142,56,224,1,192,3,142,56,224,1,192,3,142,56,255,255,192,3,142,56,255,255,192,3,142,56,255,255,192,28,14,0,224,1,192,28,14,0,224,1,192,28,14,0,224,1,192,224,14,0,224,1,192,224,14,0,224,1,192,224,14,0,224,1,192,0,14,0,255,255,192,0,14,0,255,255,192,0,14,0,255,255,192,
  // 0x7cfb  系
  251,124,39,48,240,48,3,250,0,0,7,255,240,0,0,7,255,240,0,0,7,255,240,31,255,248,0,0,31,255,248,0,0,31,255,248,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,31,255,255,0,0,31,255,255,0,0,31,255,255,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,15,192,3,128,0,15,192,3,128,0,15,192,3,128,3,240,0,0,112,3,240,0,0,112,3,240,0,0,112,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,112,56,28,0,0,112,56,28,0,0,112,56,28,0,3,128,56,3,128,3,128,56,3,128,3,128,56,3,128,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,224,14,56,0,14,224,14,56,0,14,224,14,56,0,14,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,
  // 0x7d05  紅
  5,125,45,45,14,48,0,253,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,128,7,255,255,192,3,128,7,255,255,192,3,128,7,255,255,192,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,255,254,0,3,128,0,255,254,0,3,128,0,255,254,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,224,0,63,255,255,248,224,0,63,255,255,248,224,0,63,255,255,248,
  // 0x7d22  索
  34,125,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,56,0,0,56,28,0,56,0,0,56,28,0,56,0,0,56,224,1,192,3,129,192,224,1,192,3,129,192,224,1,192,3,129,192,0,127,255,252,0,0,0,127,255,252,0,0,0,127,255,252,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,1,248,0,112,0,0,1,248,0,112,0,0,1,248,0,112,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,14,0,0,0,7,0,14,0,0,0,7,0,14,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,3,129,199,0,112,0,3,129,199,0,112,0,3,129,199,0,112,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,
  // 0x7d2b  紫
  43,125,42,48,32,48,0,250,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,3,142,0,224,14,0,3,142,0,224,14,0,3,142,0,224,14,0,3,143,248,255,240,0,3,143,248,255,240,0,3,143,248,255,240,0,3,142,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,3,143,248,224,1,192,3,143,248,224,1,192,3,143,248,224,1,192,255,240,0,31,255,192,255,240,0,31,255,192,255,240,0,31,255,192,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,127,255,252,0,0,0,127,255,252,0,0,0,127,255,252,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,1,248,0,112,0,0,1,248,0,112,0,0,1,248,0,112,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,14,0,0,0,7,0,14,0,0,0,7,0,14,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,3,129,199,0,112,0,3,129,199,0,112,0,3,129,199,0,112,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,
  // 0x7d30  細
  48,125,42,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,128,7,255,255,192,3,128,7,255,255,192,3,128,7,255,255,192,3,129,199,3,129,192,3,129,199,3,129,192,3,129,199,3,129,192,28,1,199,3,129,192,28,1,199,3,129,192,28,1,199,3,129,192,255,254,7,3,129,192,255,254,7,3,129,192,255,254,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,28,14,7,255,255,192,28,14,7,255,255,192,28,14,7,255,255,192,255,255,199,3,129,192,255,255,199,3,129,192,255,255,199,3,129,192,0,1,199,3,129,192,0,1,199,3,129,192,0,1,199,3,129,192,0,0,7,3,129,192,0,0,7,3,129,192,0,0,7,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,224,0,7,255,255,192,224,0,7,255,255,192,224,0,7,255,255,192,0,0,7,0,1,192,0,0,7,0,1,192,0,0,7,0,1,192,
  // 0x7d42  終
  66,125,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,0,31,255,192,3,128,0,31,255,192,3,128,0,31,255,192,3,142,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,28,14,7,224,14,0,28,14,7,224,14,0,28,14,7,224,14,0,255,240,56,28,112,0,255,240,56,28,112,0,255,240,56,28,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,28,14,0,224,14,0,28,14,0,224,14,0,28,14,0,224,14,0,255,254,63,0,1,248,255,254,63,0,1,248,255,254,63,0,1,248,0,14,0,31,128,0,0,14,0,31,128,0,0,14,0,31,128,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,227,142,0,0,14,0,227,142,0,0,14,0,227,142,0,0,14,0,227,142,0,252,0,0,227,142,0,252,0,0,227,142,0,252,0,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,
  // 0x7d71  統
  113,125,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,142,63,255,255,248,3,142,63,255,255,248,3,142,63,255,255,248,28,14,0,28,0,0,28,14,0,28,0,0,28,14,0,28,0,0,255,240,0,224,14,0,255,240,0,224,14,0,255,240,0,224,14,0,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,3,128,63,255,255,248,3,128,63,255,255,248,3,128,63,255,255,248,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,224,112,56,255,255,192,224,112,0,255,255,192,224,112,0,255,255,192,224,112,0,0,1,192,224,112,0,0,1,192,224,112,0,0,1,192,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,28,113,199,0,112,56,28,113,199,0,112,56,28,113,199,0,112,56,28,113,199,0,112,56,28,113,199,0,112,56,28,113,199,0,112,56,224,0,56,0,15,248,224,0,56,0,15,248,224,0,56,0,15,248,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,
  // 0x7d72  絲
  114,125,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,28,1,199,255,240,0,28,1,199,255,240,0,28,1,199,255,240,0,255,254,0,3,128,0,255,254,0,3,128,0,255,254,0,3,128,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,28,14,7,255,255,192,28,14,7,255,255,192,28,14,7,255,255,192,255,255,192,3,129,192,255,255,192,3,129,192,255,255,192,3,129,192,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,0,0,227,142,0,0,0,0,227,142,0,0,0,0,227,142,0,28,113,199,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,28,113,248,3,128,56,28,113,248,3,128,56,28,113,248,3,128,56,224,0,0,227,128,0,224,0,0,227,128,0,224,0,0,227,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x7da0  綠
  160,125,45,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,255,254,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,142,7,0,14,0,3,142,7,0,14,0,3,142,7,0,14,0,28,14,7,255,240,0,28,14,7,255,240,0,28,14,7,255,240,0,255,240,0,0,112,0,255,240,0,0,112,0,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,63,255,255,248,3,128,63,255,255,248,3,128,63,255,255,248,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,255,254,56,3,128,56,255,254,56,3,128,56,255,254,56,3,128,56,0,14,7,31,241,192,0,14,7,31,241,192,0,14,7,31,241,192,0,0,0,227,142,0,0,0,0,227,142,0,0,0,0,227,142,0,227,142,7,3,129,192,227,142,7,3,129,192,227,142,7,3,129,192,227,142,56,3,128,56,227,142,56,3,128,56,227,142,56,3,128,56,224,0,0,227,128,0,224,0,0,227,128,0,224,0,0,227,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x7db2  網
  178,125,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,255,255,248,0,112,7,255,255,248,0,112,7,255,255,248,3,128,7,0,0,56,3,128,7,0,0,56,3,128,7,0,0,56,3,128,7,224,14,56,3,128,7,224,14,56,3,128,7,224,14,56,28,14,7,28,112,56,28,14,7,28,112,56,28,14,7,28,112,56,255,254,7,255,255,248,255,254,7,255,255,248,255,254,7,255,255,248,0,112,7,3,128,56,0,112,7,3,128,56,0,112,7,3,128,56,3,128,7,0,112,56,3,128,7,0,112,56,3,128,7,0,112,56,3,128,7,255,255,248,3,128,7,255,255,248,3,128,7,255,255,248,28,14,7,28,0,56,28,14,7,28,0,56,28,14,7,28,0,56,255,241,199,28,0,56,255,241,199,28,0,56,255,241,199,28,0,56,0,0,7,31,254,56,0,0,7,31,254,56,0,0,7,31,254,56,28,113,199,0,0,56,28,113,199,0,0,56,28,113,199,0,0,56,28,113,199,0,0,56,28,113,199,0,0,56,28,113,199,0,0,56,28,113,199,0,14,56,28,113,199,0,14,56,28,113,199,0,14,56,224,0,7,0,1,192,224,0,7,0,1,192,224,0,7,0,1,192,
  // 0x7dd2  緒
  210,125,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,3,128,56,3,128,7,255,254,56,3,128,7,255,254,56,3,128,7,255,254,56,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,28,1,192,3,142,0,28,1,192,3,142,0,28,1,192,3,142,0,255,254,63,255,255,248,255,254,63,255,255,248,255,254,63,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,28,14,0,255,255,192,28,14,0,255,255,192,28,14,0,255,255,192,255,255,199,224,1,192,255,255,199,224,1,192,255,255,199,224,1,192,0,1,248,224,1,192,0,1,248,224,1,192,0,1,248,224,1,192,0,0,0,255,255,192,0,0,0,255,255,192,0,0,0,255,255,192,28,113,192,224,1,192,28,113,192,224,1,192,28,113,192,224,1,192,28,113,192,224,1,192,28,113,192,224,1,192,28,113,192,224,1,192,224,0,0,255,255,192,224,0,0,255,255,192,224,0,0,255,255,192,0,0,0,224,1,192,0,0,0,224,1,192,0,0,0,224,1,192,
  // 0x7dda  線
  218,125,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,3,128,7,255,255,192,3,128,7,255,255,192,3,128,7,255,255,192,3,142,7,0,1,192,3,142,7,0,1,192,3,142,7,0,1,192,28,14,7,255,255,192,28,14,7,255,255,192,28,14,7,255,255,192,255,240,7,0,1,192,255,240,7,0,1,192,255,240,7,0,1,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,28,14,0,3,240,56,28,14,0,3,240,56,28,14,0,3,240,56,255,254,63,227,241,192,255,254,63,227,241,192,255,254,63,227,241,192,0,14,0,227,142,0,0,14,0,227,142,0,0,14,0,227,142,0,0,0,7,3,142,0,0,0,7,3,142,0,0,0,7,3,142,0,227,142,7,3,129,192,227,142,7,3,129,192,227,142,7,3,129,192,227,142,56,3,129,192,227,142,56,3,129,192,227,142,56,3,129,192,224,1,192,227,128,56,224,1,192,227,128,56,224,1,192,227,128,56,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x7de8  編
  232,125,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,7,255,255,248,3,128,7,255,255,248,3,128,7,255,255,248,3,129,199,0,0,56,3,129,199,0,0,56,3,129,199,0,0,56,28,1,199,0,0,56,28,1,199,0,0,56,28,1,199,0,0,56,255,254,7,255,255,248,255,254,7,255,255,248,255,254,7,255,255,248,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,28,14,7,255,255,248,28,14,7,255,255,248,28,14,7,255,255,248,255,255,199,227,142,56,255,255,199,227,142,56,255,255,199,227,142,56,0,1,199,227,142,56,0,1,199,227,142,56,0,1,199,227,142,56,0,0,56,255,255,248,0,0,56,255,255,248,0,0,56,255,255,248,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,224,1,192,227,128,56,224,1,192,227,128,56,224,1,192,227,128,56,0,0,0,224,1,248,0,0,0,224,1,248,0,0,0,224,1,248,
  // 0x7e2e  縮
  46,126,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,63,255,255,248,3,128,63,255,255,248,3,128,63,255,255,248,3,142,56,0,0,56,3,142,56,0,0,56,3,142,56,0,0,56,28,14,0,224,0,0,28,14,0,224,0,0,28,14,0,224,0,0,255,240,0,255,255,248,255,240,0,255,255,248,255,240,0,255,255,248,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,3,128,63,3,128,0,3,128,63,3,128,0,3,128,63,3,128,0,28,15,199,31,255,192,28,15,199,31,255,192,28,15,199,31,255,192,255,254,7,28,1,192,255,254,7,28,1,192,255,254,7,28,1,192,0,14,7,28,1,192,0,14,7,28,1,192,0,14,7,28,1,192,0,0,7,31,255,192,0,0,7,31,255,192,0,0,7,31,255,192,227,142,7,28,1,192,227,142,7,28,1,192,227,142,7,28,1,192,227,142,7,28,1,192,227,142,7,28,1,192,227,142,7,28,1,192,224,0,7,31,255,192,224,0,7,31,255,192,224,0,7,31,255,192,0,0,7,28,1,192,0,0,7,28,1,192,0,0,7,28,1,192,
  // 0x7e3d  總
  61,126,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,7,255,255,192,3,128,7,255,255,192,3,128,7,255,255,192,3,129,199,3,129,192,3,129,199,3,129,192,3,129,199,3,129,192,28,1,199,31,255,192,28,1,199,31,255,192,28,1,199,31,255,192,255,254,7,224,15,192,255,254,7,224,15,192,255,254,7,224,15,192,0,112,7,28,113,192,0,112,7,28,113,192,0,112,7,28,113,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,28,14,7,28,113,192,28,14,7,28,113,192,28,14,7,28,113,192,255,255,199,255,255,192,255,255,199,255,255,192,255,255,199,255,255,192,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,28,113,199,28,113,192,28,113,199,28,113,192,28,113,199,28,113,192,28,113,199,28,0,56,28,113,199,28,0,56,28,113,199,28,0,56,224,0,7,28,14,56,224,0,7,28,14,56,224,0,7,28,14,56,0,0,56,3,254,0,0,0,56,3,254,0,0,0,56,3,254,0,
  // 0x7e7c  繼
  124,126,45,48,32,48,0,250,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,56,224,1,192,0,112,56,224,1,192,0,112,56,224,1,192,3,128,56,255,142,56,3,128,56,255,142,56,3,128,56,255,142,56,3,142,56,28,15,248,3,142,56,28,15,248,3,142,56,28,15,248,28,14,56,227,129,192,28,14,56,227,129,192,28,14,56,227,129,192,255,240,56,255,143,248,255,240,56,255,143,248,255,240,56,255,143,248,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,3,128,63,255,255,248,3,128,63,255,255,248,3,128,63,255,255,248,28,14,56,28,1,192,28,14,56,28,1,192,28,14,56,28,1,192,255,254,56,224,1,192,255,254,56,224,1,192,255,254,56,224,1,192,0,14,56,255,142,56,0,14,56,255,142,56,0,14,56,255,142,56,0,0,56,28,15,248,0,0,56,28,15,248,0,0,56,28,15,248,227,142,56,227,129,192,227,142,56,227,129,192,227,142,56,227,129,192,227,142,56,255,143,248,227,142,56,255,143,248,227,142,56,255,143,248,224,0,56,3,128,56,224,0,56,3,128,56,224,0,56,3,128,56,0,0,63,255,255,248,0,0,63,255,255,248,0,0,63,255,255,248,
  // 0x7e8c  續
  140,126,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,142,7,255,255,192,3,142,7,255,255,192,3,142,7,255,255,192,28,14,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,255,240,63,255,255,248,255,240,63,255,255,248,255,240,63,255,255,248,0,112,56,28,112,56,0,112,56,28,112,56,0,112,56,28,112,56,3,128,63,255,255,248,3,128,63,255,255,248,3,128,63,255,255,248,28,14,7,0,1,192,28,14,7,0,1,192,28,14,7,0,1,192,255,255,199,255,255,192,255,255,199,255,255,192,255,255,199,255,255,192,0,1,199,0,1,192,0,1,199,0,1,192,0,1,199,0,1,192,0,0,7,255,255,192,0,0,7,255,255,192,0,0,7,255,255,192,28,113,199,0,1,192,28,113,199,0,1,192,28,113,199,0,1,192,28,113,199,255,255,192,28,113,199,255,255,192,28,113,199,255,255,192,224,0,0,224,14,0,224,0,0,224,14,0,224,0,0,224,14,0,0,0,7,0,1,192,0,0,7,0,1,192,0,0,7,0,1,192,
  // 0x7ea2  红
  162,126,45,45,14,48,0,253,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,128,7,255,255,192,3,128,7,255,255,192,3,128,7,255,255,192,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,255,254,0,3,128,0,255,254,0,3,128,0,255,254,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,127,192,3,128,0,0,127,192,3,128,0,0,127,192,3,128,0,255,128,0,3,128,0,255,128,0,3,128,0,255,128,0,3,128,0,28,0,63,255,255,248,28,0,63,255,255,248,28,0,63,255,255,248,
  // 0x7f6e  置
  110,127,45,48,32,48,0,250,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x7f72  署
  114,127,45,45,14,48,0,250,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,127,255,252,112,0,0,127,255,252,112,0,0,127,255,252,112,0,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,3,128,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,63,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,3,254,0,0,112,0,3,254,0,0,112,0,3,254,0,0,112,0,252,15,255,255,240,0,252,15,255,255,240,0,252,15,255,255,240,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,
  // 0x8070  聰
  112,128,45,48,32,48,0,250,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,255,255,192,28,0,0,255,255,192,28,0,0,255,255,192,28,0,0,28,14,7,255,255,192,28,14,7,255,255,192,28,14,7,255,255,192,28,14,7,3,129,192,28,14,7,3,129,192,28,14,7,3,129,192,31,254,7,31,255,192,31,254,7,31,255,192,31,254,7,31,255,192,28,14,7,224,15,192,28,14,7,224,15,192,28,14,7,224,15,192,28,14,7,28,113,192,28,14,7,28,113,192,28,14,7,28,113,192,31,254,7,3,129,192,31,254,7,3,129,192,31,254,7,3,129,192,28,14,7,28,113,192,28,14,7,28,113,192,28,14,7,28,113,192,28,14,7,255,255,192,28,14,7,255,255,192,28,14,7,255,255,192,28,15,192,28,0,0,28,15,192,28,0,0,28,15,192,28,0,0,31,254,0,3,129,192,31,254,0,3,129,192,31,254,0,3,129,192,252,14,56,227,128,56,252,14,56,227,128,56,252,14,56,227,128,56,0,14,56,224,14,56,0,14,56,224,14,56,0,14,56,224,14,56,0,15,192,224,14,0,0,15,192,224,14,0,0,15,192,224,14,0,0,14,0,31,254,0,0,14,0,31,254,0,0,14,0,31,254,0,
  // 0x81ea  自
  234,129,27,48,192,48,9,250,0,14,0,0,0,14,0,0,0,14,0,0,0,112,0,0,0,112,0,0,0,112,0,0,3,128,0,0,3,128,0,0,3,128,0,0,255,255,255,224,255,255,255,224,255,255,255,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,255,255,255,224,255,255,255,224,255,255,255,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,255,255,255,224,255,255,255,224,255,255,255,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,255,255,255,224,255,255,255,224,255,255,255,224,224,0,0,224,224,0,0,224,224,0,0,224,
  // 0x85cd  藍
  205,133,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,3,128,0,3,255,255,3,128,0,3,255,255,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,255,255,3,255,248,3,255,255,3,255,248,3,255,255,3,255,248,3,128,7,28,0,0,3,128,7,28,0,0,3,128,7,28,0,0,3,255,255,28,112,0,3,255,255,28,112,0,3,255,255,28,112,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,255,255,0,14,0,3,255,255,0,14,0,3,255,255,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x884c  行
  76,136,45,48,32,48,0,250,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,7,255,255,192,0,14,7,255,255,192,0,14,7,255,255,192,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,3,240,0,3,128,0,3,240,0,3,128,0,3,240,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,
  // 0x8868  表
  104,136,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,199,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,126,0,28,112,0,0,126,0,28,112,0,0,126,0,28,112,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,252,14,7,0,126,0,252,14,7,0,126,0,252,14,7,0,126,0,0,14,56,0,1,248,0,14,56,0,1,248,0,14,56,0,1,248,0,15,192,0,0,0,0,15,192,0,0,0,0,15,192,0,0,0,
  // 0x88ab  被
  171,136,45,48,32,48,0,250,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,254,7,255,255,248,255,254,7,255,255,248,255,254,7,255,255,248,0,14,7,0,112,56,0,14,7,0,112,56,0,14,7,0,112,56,0,112,7,0,113,192,0,112,7,0,113,192,0,112,7,0,113,192,0,113,199,0,112,0,0,113,199,0,112,0,0,113,199,0,112,0,3,254,7,255,255,192,3,254,7,255,255,192,3,254,7,255,255,192,28,113,199,28,1,192,28,113,199,28,1,192,28,113,199,28,1,192,224,112,7,28,1,192,224,112,7,28,1,192,224,112,7,28,1,192,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,113,192,224,0,56,0,113,192,224,0,56,0,113,192,224,0,56,
  // 0x88c5  装
  197,136,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,3,142,63,255,255,248,3,142,63,255,255,248,3,142,63,255,255,248,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,126,0,3,128,0,0,126,0,3,128,0,0,126,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,252,14,7,255,255,192,252,14,7,255,255,192,252,14,7,255,255,192,0,14,56,0,0,0,0,14,56,0,0,0,0,14,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,199,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,15,192,224,14,0,0,15,192,224,14,0,0,15,192,224,14,0,3,241,192,28,112,0,3,241,192,28,112,0,3,241,192,28,112,0,252,1,199,3,240,0,252,1,199,3,240,0,252,1,199,3,240,0,0,1,248,0,15,248,0,1,248,0,15,248,0,1,248,0,15,248,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,
  // 0x88dd  裝
  221,136,45,48,32,48,0,250,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,255,192,3,128,0,3,255,192,3,128,0,3,255,192,3,128,0,0,1,199,255,255,192,0,1,199,255,255,192,0,1,199,255,255,192,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,255,254,0,3,129,192,255,254,0,3,129,192,255,254,0,28,1,248,0,0,0,28,1,248,0,0,0,28,1,248,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,199,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,15,192,224,14,0,0,15,192,224,14,0,0,15,192,224,14,0,3,241,192,28,112,0,3,241,192,28,112,0,3,241,192,28,112,0,252,1,199,3,240,0,252,1,199,3,240,0,252,1,199,3,240,0,0,1,248,0,15,248,0,1,248,0,15,248,0,1,248,0,15,248,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,
  // 0x8907  複
  7,137,45,48,32,48,0,250,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,0,7,255,255,248,0,0,7,255,255,248,0,0,7,255,255,248,255,254,56,0,0,0,255,254,56,0,0,0,255,254,56,0,0,0,0,15,199,255,255,192,0,15,199,255,255,192,0,15,199,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,3,241,199,0,1,192,3,241,199,0,1,192,3,241,199,0,1,192,28,126,7,255,255,192,28,126,7,255,255,192,28,126,7,255,255,192,224,113,192,224,0,0,224,113,192,224,0,0,224,113,192,224,0,0,0,113,192,255,255,192,0,113,192,255,255,192,0,113,192,255,255,192,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,56,224,112,0,0,112,56,224,112,0,0,112,56,224,112,0,0,112,0,31,128,0,0,112,0,31,128,0,0,112,0,31,128,0,0,112,7,224,126,0,0,112,7,224,126,0,0,112,7,224,126,0,0,113,248,0,1,248,0,113,248,0,1,248,0,113,248,0,1,248,
  // 0x89d2  角
  210,137,39,48,240,48,0,250,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,127,255,255,128,0,127,255,255,128,0,127,255,255,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,227,255,255,255,254,227,255,255,255,254,227,255,255,255,254,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,28,0,7,0,14,28,0,7,0,14,28,0,7,0,14,28,0,7,3,142,28,0,7,3,142,28,0,7,3,142,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x8a08  計
  8,138,45,48,32,48,0,250,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,255,255,248,3,128,0,255,255,248,3,128,0,255,255,248,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,31,255,192,3,128,0,31,255,192,3,128,0,31,255,192,3,128,0,0,0,63,255,255,248,0,0,63,255,255,248,0,0,63,255,255,248,31,255,192,3,128,0,31,255,192,3,128,0,31,255,192,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,31,255,192,3,128,0,31,255,192,3,128,0,31,255,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,31,255,192,3,128,0,31,255,192,3,128,0,31,255,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0x8a0a  訊
  10,138,45,48,32,48,0,250,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,0,112,63,255,240,0,0,112,63,255,240,0,0,112,63,255,240,0,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,255,255,192,224,112,0,255,255,192,224,112,0,255,255,192,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,31,254,0,224,112,0,31,254,0,224,112,0,31,254,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,31,254,63,255,240,0,31,254,63,255,240,0,31,254,63,255,240,0,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,31,254,0,224,112,0,31,254,0,224,112,0,31,254,0,224,112,0,28,14,0,224,112,0,28,14,0,224,112,0,28,14,0,224,112,0,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,224,14,56,28,14,0,224,14,56,28,14,0,224,14,56,31,254,0,224,14,56,31,254,0,224,14,56,31,254,0,224,14,56,28,14,0,224,1,248,28,14,0,224,1,248,28,14,0,224,1,248,0,0,0,224,0,56,0,0,0,224,0,56,0,0,0,224,0,56,
  // 0x8a18  記
  24,138,45,45,14,48,0,253,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,255,255,248,0,1,192,255,255,248,0,1,192,255,255,248,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,31,255,192,0,1,192,31,255,192,0,1,192,31,255,192,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,31,255,192,255,255,192,31,255,192,255,255,192,31,255,192,255,255,192,0,0,0,224,1,192,0,0,0,224,1,192,0,0,0,224,1,192,31,255,192,224,0,0,31,255,192,224,0,0,31,255,192,224,0,0,28,1,192,224,0,0,28,1,192,224,0,0,28,1,192,224,0,0,28,1,192,224,0,0,28,1,192,224,0,0,28,1,192,224,0,0,28,1,192,224,0,56,28,1,192,224,0,56,28,1,192,224,0,56,31,255,192,224,0,56,31,255,192,224,0,56,31,255,192,224,0,56,28,1,192,31,255,248,28,1,192,31,255,248,28,1,192,31,255,248,
  // 0x8a2d  設
  45,138,45,48,32,48,0,250,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,255,255,248,224,14,0,255,255,248,224,14,0,255,255,248,224,14,0,0,0,0,224,14,0,0,0,0,224,14,0,0,0,0,224,14,0,31,255,199,0,1,248,31,255,199,0,1,248,31,255,199,0,1,248,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,31,255,199,255,255,192,31,255,199,255,255,192,31,255,199,255,255,192,0,0,0,224,1,192,0,0,0,224,1,192,0,0,0,224,1,192,31,255,192,224,1,192,31,255,192,224,1,192,31,255,192,224,1,192,28,1,192,28,14,0,28,1,192,28,14,0,28,1,192,28,14,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,31,255,192,28,112,0,31,255,192,28,112,0,31,255,192,28,112,0,28,1,192,224,14,0,28,1,192,224,14,0,28,1,192,224,14,0,0,0,63,0,1,248,0,0,63,0,1,248,0,0,63,0,1,248,
  // 0x8a66  試
  102,138,45,48,32,48,0,250,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,0,112,0,0,113,192,0,112,0,0,113,192,0,112,0,0,113,192,0,0,0,0,112,56,0,0,0,0,112,56,0,0,0,0,112,56,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,0,0,63,255,255,248,0,0,63,255,255,248,0,0,63,255,255,248,31,254,0,0,112,0,31,254,0,0,112,0,31,254,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,31,254,7,252,112,0,31,254,7,252,112,0,31,254,7,252,112,0,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,31,254,0,224,112,0,31,254,0,224,112,0,31,254,0,224,112,0,28,14,0,224,112,0,28,14,0,224,112,0,28,14,0,224,112,0,28,14,0,224,14,0,28,14,0,224,14,0,28,14,0,224,14,0,28,14,0,255,142,56,28,14,0,255,142,56,28,14,0,255,142,56,31,254,63,224,14,56,31,254,63,224,14,56,31,254,63,224,14,56,28,14,0,0,1,248,28,14,0,0,1,248,28,14,0,0,1,248,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,
  // 0x8a8d  認
  141,138,45,45,14,48,0,253,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,255,255,199,28,1,192,255,255,199,28,1,192,255,255,199,28,1,192,0,0,7,28,1,192,0,0,7,28,1,192,0,0,7,28,1,192,31,254,56,224,1,192,31,254,56,224,1,192,31,254,56,224,1,192,0,0,0,224,113,192,0,0,0,224,113,192,0,0,0,224,113,192,31,254,7,0,14,0,31,254,7,0,14,0,31,254,7,0,14,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,31,254,0,3,128,0,31,254,0,3,128,0,31,254,0,3,128,0,28,14,0,227,129,192,28,14,0,227,129,192,28,14,0,227,129,192,28,14,56,224,0,56,28,14,56,224,0,56,28,14,56,224,0,56,28,14,56,224,14,56,28,14,56,224,14,56,28,14,56,224,14,56,31,254,56,224,14,56,31,254,56,224,14,56,31,254,56,224,14,56,28,1,192,31,254,0,28,1,192,31,254,0,28,1,192,31,254,0,
  // 0x8aa4  誤
  164,138,45,48,32,48,0,250,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,0,7,0,1,192,0,0,7,0,1,192,0,0,7,0,1,192,255,255,199,0,1,192,255,255,199,0,1,192,255,255,199,0,1,192,0,0,7,255,255,192,0,0,7,255,255,192,0,0,7,255,255,192,31,254,0,0,0,0,31,254,0,0,0,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,7,255,255,192,31,254,7,255,255,192,31,254,7,255,255,192,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,31,254,0,3,128,0,31,254,0,3,128,0,31,254,0,3,128,0,28,14,63,255,255,248,28,14,63,255,255,248,28,14,63,255,255,248,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,28,112,0,28,14,0,28,112,0,28,14,0,28,112,0,31,254,0,224,14,0,31,254,0,224,14,0,31,254,0,224,14,0,28,14,7,0,1,192,28,14,7,0,1,192,28,14,7,0,1,192,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,
  // 0x8abf  調
  191,138,42,48,32,48,0,250,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,0,7,3,129,192,0,0,7,3,129,192,0,0,7,3,129,192,255,255,199,3,129,192,255,255,199,3,129,192,255,255,199,3,129,192,0,0,7,31,241,192,0,0,7,31,241,192,0,0,7,31,241,192,31,254,7,3,129,192,31,254,7,3,129,192,31,254,7,3,129,192,0,0,7,255,255,192,0,0,7,255,255,192,0,0,7,255,255,192,31,254,7,0,1,192,31,254,7,0,1,192,31,254,7,0,1,192,0,0,7,31,241,192,0,0,7,31,241,192,0,0,7,31,241,192,31,254,7,28,113,192,31,254,7,28,113,192,31,254,7,28,113,192,28,14,7,28,113,192,28,14,7,28,113,192,28,14,7,28,113,192,28,14,7,31,241,192,28,14,7,31,241,192,28,14,7,31,241,192,28,14,7,0,1,192,28,14,7,0,1,192,28,14,7,0,1,192,31,254,56,0,1,192,31,254,56,0,1,192,31,254,56,0,1,192,28,14,56,0,113,192,28,14,56,0,113,192,28,14,56,0,113,192,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,
  // 0x8acb  請
  203,138,45,48,32,48,0,250,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,0,63,255,255,248,0,0,63,255,255,248,0,0,63,255,255,248,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,0,0,7,255,255,192,0,0,7,255,255,192,0,0,7,255,255,192,31,254,0,3,128,0,31,254,0,3,128,0,31,254,0,3,128,0,0,0,63,255,255,248,0,0,63,255,255,248,0,0,63,255,255,248,31,254,0,0,0,0,31,254,0,0,0,0,31,254,0,0,0,0,0,0,7,255,255,192,0,0,7,255,255,192,0,0,7,255,255,192,31,254,7,0,1,192,31,254,7,0,1,192,31,254,7,0,1,192,28,14,7,255,255,192,28,14,7,255,255,192,28,14,7,255,255,192,28,14,7,0,1,192,28,14,7,0,1,192,28,14,7,0,1,192,28,14,7,255,255,192,28,14,7,255,255,192,28,14,7,255,255,192,31,254,7,0,1,192,31,254,7,0,1,192,31,254,7,0,1,192,28,14,7,0,113,192,28,14,7,0,113,192,28,14,7,0,113,192,0,0,7,0,14,0,0,0,7,0,14,0,0,0,7,0,14,0,
  // 0x8b70  議
  112,139,45,48,32,48,0,250,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,0,63,255,255,248,0,0,63,255,255,248,0,0,63,255,255,248,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,0,0,7,255,255,192,0,0,7,255,255,192,0,0,7,255,255,192,31,254,0,3,128,0,31,254,0,3,128,0,31,254,0,3,128,0,0,0,63,255,255,248,0,0,63,255,255,248,0,0,63,255,255,248,31,254,0,28,113,192,31,254,0,28,113,192,31,254,0,28,113,192,0,0,7,224,112,56,0,0,7,224,112,56,0,0,7,224,112,56,31,254,0,224,112,0,31,254,0,224,112,0,31,254,0,224,112,0,28,14,63,255,255,248,28,14,63,255,255,248,28,14,63,255,255,248,28,14,0,224,112,0,28,14,0,224,112,0,28,14,0,224,112,0,28,14,0,252,113,192,28,14,0,252,113,192,28,14,0,252,113,192,31,254,63,224,14,56,31,254,63,224,14,56,31,254,63,224,14,56,28,14,0,224,113,248,28,14,0,224,113,248,28,14,0,224,113,248,0,0,7,227,128,56,0,0,7,227,128,56,0,0,7,227,128,56,
  // 0x8b80  讀
  128,139,45,48,32,48,0,250,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,255,255,199,255,255,192,255,255,199,255,255,192,255,255,199,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,63,255,255,248,31,254,63,255,255,248,31,254,63,255,255,248,0,0,56,28,112,56,0,0,56,28,112,56,0,0,56,28,112,56,31,254,63,255,255,248,31,254,63,255,255,248,31,254,63,255,255,248,0,0,7,0,1,192,0,0,7,0,1,192,0,0,7,0,1,192,31,254,7,255,255,192,31,254,7,255,255,192,31,254,7,255,255,192,28,14,7,0,1,192,28,14,7,0,1,192,28,14,7,0,1,192,28,14,7,255,255,192,28,14,7,255,255,192,28,14,7,255,255,192,28,14,7,0,1,192,28,14,7,0,1,192,28,14,7,0,1,192,31,254,7,255,255,192,31,254,7,255,255,192,31,254,7,255,255,192,28,14,0,224,14,0,28,14,0,224,14,0,28,14,0,224,14,0,0,0,7,0,1,192,0,0,7,0,1,192,0,0,7,0,1,192,
  // 0x8b8a  變
  138,139,45,48,32,48,0,250,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,28,1,255,252,14,0,28,1,255,252,14,0,28,1,255,252,14,0,224,14,0,0,112,56,224,14,0,0,112,56,224,14,0,0,112,56,255,240,63,227,255,192,255,240,63,227,255,192,255,240,63,227,255,192,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,28,14,63,224,112,56,28,14,63,224,112,56,28,14,63,224,112,56,255,254,0,3,255,248,255,254,0,3,255,248,255,254,0,3,255,248,0,0,63,224,0,0,0,0,63,224,0,0,0,0,63,224,0,0,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,63,227,142,56,227,142,63,227,142,56,227,142,63,227,142,56,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,127,255,255,254,0,0,127,255,255,254,0,0,127,255,255,254,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,0,1,255,252,0,0,0,1,255,252,0,0,0,1,255,252,0,0,0,126,0,3,240,0,0,126,0,3,240,0,0,126,0,3,240,0,255,128,0,0,15,248,255,128,0,0,15,248,255,128,0,0,15,248,
  // 0x8cc7  資
  199,140,45,48,32,48,0,250,28,0,7,0,0,0,28,0,7,0,0,0,28,0,7,0,0,0,3,128,7,255,255,192,3,128,7,255,255,192,3,128,7,255,255,192,0,14,56,28,1,192,0,14,56,28,1,192,0,14,56,28,1,192,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,255,128,0,227,128,0,255,128,0,227,128,0,255,128,0,227,128,0,3,128,7,0,126,0,3,128,7,0,126,0,3,128,7,0,126,0,3,129,248,0,1,248,3,129,248,0,1,248,3,129,248,0,1,248,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x8ddd  距
  221,141,45,42,252,48,0,253,31,255,199,255,255,248,31,255,199,255,255,248,31,255,199,255,255,248,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,31,255,199,255,255,192,31,255,199,255,255,192,31,255,199,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,28,127,199,0,1,192,28,127,199,0,1,192,28,127,199,0,1,192,28,112,7,0,1,192,28,112,7,0,1,192,28,112,7,0,1,192,28,112,7,255,255,192,28,112,7,255,255,192,28,112,7,255,255,192,28,112,7,0,0,0,28,112,7,0,0,0,28,112,7,0,0,0,28,127,199,0,0,0,28,127,199,0,0,0,28,127,199,0,0,0,255,128,7,0,0,0,255,128,7,0,0,0,255,128,7,0,0,0,0,0,7,255,255,248,0,0,7,255,255,248,0,0,7,255,255,248,
  // 0x8eca  車
  202,142,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x8edf  軟
  223,142,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,255,255,248,31,255,192,255,255,248,31,255,192,255,255,248,31,255,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,31,255,192,224,14,0,31,255,192,224,14,0,31,255,192,224,14,0,28,113,199,3,128,0,28,113,199,3,128,0,28,113,199,3,128,0,31,255,192,3,128,0,31,255,192,3,128,0,31,255,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,31,255,192,28,112,0,31,255,192,28,112,0,31,255,192,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,255,255,248,28,112,0,255,255,248,28,112,0,255,255,248,28,112,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,56,0,0,56,0,112,56,0,0,56,0,112,56,0,0,56,
  // 0x8ef8  軸
  248,142,42,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,255,255,248,3,128,0,255,255,248,3,128,0,255,255,248,3,128,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,31,255,199,3,129,192,31,255,199,3,129,192,31,255,199,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,31,255,199,3,129,192,31,255,199,3,129,192,31,255,199,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,31,255,199,255,255,192,31,255,199,255,255,192,31,255,199,255,255,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,255,255,255,3,129,192,255,255,255,3,129,192,255,255,255,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,
  // 0x8f09  載
  9,143,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,31,255,255,3,142,0,31,255,255,3,142,0,31,255,255,3,142,0,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,255,255,255,227,128,0,255,255,255,227,128,0,255,255,255,227,128,0,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,28,14,7,3,129,192,28,14,7,3,129,192,28,14,7,3,129,192,31,255,255,3,142,0,31,255,255,3,142,0,31,255,255,3,142,0,28,14,7,3,142,0,28,14,7,3,142,0,28,14,7,3,142,0,31,255,255,0,112,0,31,255,255,0,112,0,31,255,255,0,112,0,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,255,255,255,227,142,56,255,255,255,227,142,56,255,255,255,227,142,56,0,14,0,28,1,248,0,14,0,28,1,248,0,14,0,28,1,248,0,14,0,224,0,56,0,14,0,224,0,56,0,14,0,224,0,56,
  // 0x8f2f  輯
  47,143,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,255,255,248,224,14,0,255,255,248,224,14,0,255,255,248,224,14,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,255,254,0,31,255,192,0,0,0,31,255,192,0,0,0,31,255,192,0,0,0,28,113,199,255,255,248,28,113,199,255,255,248,28,113,199,255,255,248,31,255,192,224,14,0,31,255,192,224,14,0,31,255,192,224,14,0,28,113,192,255,254,0,28,113,192,255,254,0,28,113,192,255,254,0,31,255,192,224,14,0,31,255,192,224,14,0,31,255,192,224,14,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,255,254,0,255,255,248,224,14,0,255,255,248,224,14,0,255,255,248,224,14,0,0,112,0,224,127,248,0,112,0,224,127,248,0,112,0,224,127,248,0,112,63,255,142,0,0,112,63,255,142,0,0,112,63,255,142,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,
  // 0x8f38  輸
  56,143,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,255,254,56,0,14,0,255,254,56,0,14,0,255,254,56,0,14,0,3,129,199,255,241,248,3,129,199,255,241,248,3,129,199,255,241,248,255,254,0,0,0,0,255,254,0,0,0,0,255,254,0,0,0,0,227,142,63,252,1,192,227,142,63,252,1,192,227,142,63,252,1,192,255,254,56,28,113,192,255,254,56,28,113,192,255,254,56,28,113,192,227,142,56,28,113,192,227,142,56,28,113,192,227,142,56,28,113,192,255,254,63,252,113,192,255,254,63,252,113,192,255,254,63,252,113,192,3,128,56,28,113,192,3,128,56,28,113,192,3,128,56,28,113,192,255,254,56,28,113,192,255,254,56,28,113,192,255,254,56,28,113,192,3,128,63,252,113,192,3,128,63,252,113,192,3,128,63,252,113,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,113,192,3,128,56,28,113,192,3,128,56,28,113,192,3,128,56,252,14,0,3,128,56,252,14,0,3,128,56,252,14,0,
  // 0x8f49  轉
  73,143,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,255,255,199,255,255,192,255,255,199,255,255,192,255,255,199,255,255,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,31,255,199,255,255,192,31,255,199,255,255,192,31,255,199,255,255,192,28,113,199,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,31,255,199,255,255,192,31,255,199,255,255,192,31,255,199,255,255,192,28,113,192,3,128,56,28,113,192,3,128,56,28,113,192,3,128,56,31,255,199,255,255,248,31,255,199,255,255,248,31,255,199,255,255,248,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,255,255,199,255,255,248,255,255,199,255,255,248,255,255,199,255,255,248,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,3,142,0,0,112,0,3,142,0,0,112,0,3,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x8fd1  近
  209,143,45,45,14,48,0,253,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,3,128,0,0,127,192,3,128,0,0,127,192,3,128,0,0,127,192,0,112,7,255,128,0,0,112,7,255,128,0,0,112,7,255,128,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,255,255,248,0,0,7,255,255,248,0,0,7,255,255,248,255,240,7,0,112,0,255,240,7,0,112,0,255,240,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,113,192,0,112,0,0,113,192,0,112,0,0,113,192,0,112,0,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x8fd4  返
  212,143,45,45,14,48,0,253,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,3,128,0,3,255,192,3,128,0,3,255,192,3,128,0,3,255,192,0,112,63,252,0,0,0,112,63,252,0,0,0,112,63,252,0,0,0,112,56,0,0,0,0,112,56,0,0,0,0,112,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,63,255,255,192,0,0,63,255,255,192,0,0,63,255,255,192,255,240,56,0,1,192,255,240,56,0,1,192,255,240,56,0,1,192,0,112,56,224,14,0,0,112,56,224,14,0,0,112,56,224,14,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,28,112,0,0,113,192,224,14,0,0,113,192,224,14,0,0,113,192,224,14,0,0,113,199,0,1,192,0,113,199,0,1,192,0,113,199,0,1,192,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x9000  退
  0,144,45,45,14,48,0,253,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,255,240,63,255,254,0,255,240,63,255,254,0,255,240,63,255,254,0,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,224,14,0,0,112,56,224,14,0,0,112,56,224,14,0,0,112,63,0,1,192,0,112,63,0,1,192,0,112,63,0,1,192,0,112,56,0,1,192,0,112,56,0,1,192,0,112,56,0,1,192,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x901f  速
  31,144,45,45,14,48,0,253,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,56,28,14,0,0,0,56,28,14,0,0,0,56,28,14,0,255,240,56,28,14,0,255,240,56,28,14,0,255,240,56,28,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,0,255,128,0,0,112,0,255,128,0,0,112,0,255,128,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x9023  連
  35,144,45,45,14,48,0,253,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,3,143,255,255,255,248,3,143,255,255,255,248,3,143,255,255,255,248,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,1,255,255,255,192,0,1,255,255,255,192,0,1,255,255,255,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,28,1,192,255,129,255,255,255,192,255,129,255,255,255,192,255,129,255,255,255,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,143,255,255,255,248,3,143,255,255,255,248,3,143,255,255,255,248,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,28,112,0,28,0,0,28,112,0,28,0,0,28,112,0,28,0,0,224,15,255,255,255,248,224,15,255,255,255,248,224,15,255,255,255,248,
  // 0x9032  進
  50,144,45,45,14,48,0,253,0,0,7,28,0,0,0,0,7,28,0,0,0,0,7,28,0,0,3,128,7,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,1,248,3,128,0,0,1,248,3,128,0,0,1,248,3,128,0,0,14,63,255,255,192,0,14,63,255,255,192,0,14,63,255,255,192,255,240,56,3,128,0,255,240,56,3,128,0,255,240,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,56,0,0,0,0,112,56,0,0,0,0,112,56,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x904b  運
  75,144,45,42,252,48,0,253,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,255,240,56,28,14,0,255,240,56,28,14,0,255,240,56,28,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,142,0,28,0,0,3,142,0,28,0,0,3,142,0,28,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x9054  達
  84,144,45,45,14,48,0,253,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,1,255,255,255,192,0,1,255,255,255,192,0,1,255,255,255,192,0,0,7,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,255,240,0,227,128,0,255,240,0,227,128,0,255,240,0,227,128,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,142,0,28,0,0,3,142,0,28,0,0,3,142,0,28,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x9078  選
  120,144,45,45,14,48,0,253,0,15,255,3,255,192,0,15,255,3,255,192,0,15,255,3,255,192,28,14,7,3,129,192,28,14,7,3,129,192,28,14,7,3,129,192,3,143,255,3,255,192,3,143,255,3,255,192,3,143,255,3,255,192,3,142,0,227,128,56,3,142,0,227,128,56,3,142,0,227,128,56,0,1,255,224,127,248,0,1,255,224,127,248,0,1,255,224,127,248,0,0,7,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,255,129,255,255,255,192,255,129,255,255,255,192,255,129,255,255,255,192,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,143,255,255,255,248,3,143,255,255,255,248,3,143,255,255,255,248,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,224,15,255,255,255,248,224,15,255,255,255,248,224,15,255,255,255,248,
  // 0x9084  還
  132,144,45,42,252,48,0,253,28,1,255,255,255,192,28,1,255,255,255,192,28,1,255,255,255,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,248,0,15,255,255,255,248,0,15,255,255,255,248,255,128,0,0,0,0,255,128,0,0,0,0,255,128,0,0,0,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,7,28,1,192,3,128,7,28,1,192,3,128,7,28,1,192,3,128,63,3,142,0,3,128,63,3,142,0,3,128,63,3,142,0,3,143,199,224,112,0,3,143,199,224,112,0,3,143,199,224,112,0,28,112,7,0,14,0,28,112,7,0,14,0,28,112,7,0,14,0,224,15,255,255,255,248,224,15,255,255,255,248,224,15,255,255,255,248,
  // 0x908a  邊
  138,144,45,48,32,48,0,250,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,28,1,255,255,254,0,28,1,255,255,254,0,28,1,255,255,254,0,3,129,199,28,14,0,3,129,199,28,14,0,3,129,199,28,14,0,3,129,192,227,142,0,3,129,192,227,142,0,3,129,192,227,142,0,0,1,255,255,254,0,0,1,255,255,254,0,0,1,255,255,254,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,143,255,255,255,192,255,143,255,255,255,192,255,143,255,255,255,192,3,142,56,0,113,192,3,142,56,0,113,192,3,142,56,0,113,192,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,142,63,255,241,192,3,142,63,255,241,192,3,142,63,255,241,192,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,255,240,0,3,128,7,255,240,0,3,128,7,255,240,0,3,128,56,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,3,129,192,3,240,0,3,129,192,3,240,0,3,129,192,3,240,0,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,224,15,255,255,255,248,224,15,255,255,255,248,224,15,255,255,255,248,
  // 0x90e8  部
  232,144,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,14,0,3,255,248,0,14,0,3,255,248,0,14,0,3,255,248,31,255,255,227,128,56,31,255,255,227,128,56,31,255,255,227,128,56,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,255,255,255,255,129,192,255,255,255,255,129,192,255,255,255,255,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,128,56,0,0,0,3,128,56,0,0,0,3,128,56,3,255,255,3,128,56,3,255,255,3,128,56,3,255,255,3,128,56,3,128,7,3,128,56,3,128,7,3,128,56,3,128,7,3,128,56,3,128,7,3,241,192,3,128,7,3,241,192,3,128,7,3,241,192,3,128,7,3,142,0,3,128,7,3,142,0,3,128,7,3,142,0,3,255,255,3,128,0,3,255,255,3,128,0,3,255,255,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0x91cb  釋
  203,145,45,48,32,48,0,250,0,15,192,0,0,0,0,15,192,0,0,0,0,15,192,0,0,0,255,240,7,255,255,192,255,240,7,255,255,192,255,240,7,255,255,192,0,112,7,28,113,192,0,112,7,28,113,192,0,112,7,28,113,192,28,113,199,255,255,192,28,113,199,255,255,192,28,113,199,255,255,192,3,254,0,3,128,0,3,254,0,3,128,0,3,254,0,3,128,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,3,240,0,224,14,0,3,240,0,224,14,0,3,240,0,224,14,0,3,254,0,28,112,0,3,254,0,28,112,0,3,254,0,28,112,0,28,113,199,255,255,192,28,113,199,255,255,192,28,113,199,255,255,192,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,224,112,63,255,255,248,224,112,63,255,255,248,224,112,63,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,
  // 0x91cd  重
  205,145,45,45,14,48,0,253,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,255,254,0,0,0,0,255,254,0,0,0,0,255,254,0,3,255,255,0,0,0,3,255,255,0,0,0,3,255,255,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x91cf  量
  207,145,45,45,14,48,0,250,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,
  // 0x91dd  針
  221,145,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,227,255,192,3,128,0,227,255,192,3,128,0,227,255,192,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,255,255,248,3,128,0,255,255,248,3,128,0,255,255,248,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,224,113,192,3,128,0,224,113,192,3,128,0,224,113,192,3,128,0,28,126,0,3,128,0,28,126,0,3,128,0,28,126,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,0,127,248,3,128,0,0,127,248,3,128,0,0,127,248,3,128,0,255,240,0,3,128,0,255,240,0,3,128,0,255,240,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,
  // 0x9215  鈕
  21,146,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,3,142,0,28,14,0,3,142,0,28,14,0,3,142,0,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,28,0,0,28,14,0,28,0,0,28,14,0,28,0,0,28,14,0,227,254,0,28,14,0,227,254,0,28,14,0,227,254,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,255,255,192,224,14,0,255,255,192,224,14,0,255,255,192,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,224,113,192,224,14,0,224,113,192,224,14,0,224,113,192,224,14,0,28,126,0,224,14,0,28,126,0,224,14,0,28,126,0,224,14,0,28,112,0,224,14,0,28,112,0,224,14,0,28,112,0,224,14,0,0,127,192,224,14,0,0,127,192,224,14,0,0,127,192,224,14,0,255,128,63,255,255,248,255,128,63,255,255,248,255,128,63,255,255,248,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,
  // 0x932f  錯
  47,147,45,48,32,48,0,250,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,3,142,0,28,14,0,3,142,0,28,14,0,3,142,0,28,14,0,3,129,199,255,255,248,3,129,199,255,255,248,3,129,199,255,255,248,28,0,56,28,14,0,28,0,56,28,14,0,28,0,56,28,14,0,227,255,192,28,14,0,227,255,192,28,14,0,227,255,192,28,14,0,0,112,7,255,255,248,0,112,7,255,255,248,0,112,7,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,255,255,248,255,255,192,255,255,248,255,255,192,255,255,248,255,255,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,224,113,192,224,1,192,224,113,192,224,1,192,224,113,192,224,1,192,28,126,0,255,255,192,28,126,0,255,255,192,28,126,0,255,255,192,28,112,0,224,1,192,28,112,0,224,1,192,28,112,0,224,1,192,0,127,248,224,1,192,0,127,248,224,1,192,0,127,248,224,1,192,255,240,0,255,255,192,255,240,0,255,255,192,255,240,0,255,255,192,28,0,0,224,1,192,28,0,0,224,1,192,28,0,0,224,1,192,
  // 0x9375  鍵
  117,147,45,45,14,48,0,253,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,28,113,255,31,255,192,28,113,255,31,255,192,28,113,255,31,255,192,28,14,7,0,113,192,28,14,7,0,113,192,28,14,7,0,113,192,224,0,7,255,255,248,224,0,7,255,255,248,224,0,7,255,255,248,31,240,56,0,113,192,31,240,56,0,113,192,31,240,56,0,113,192,3,128,56,31,255,192,3,128,56,31,255,192,3,128,56,31,255,192,3,129,255,0,112,0,3,129,255,0,112,0,3,129,255,0,112,0,255,240,7,31,255,192,255,240,7,31,255,192,255,240,7,31,255,192,3,129,199,0,112,0,3,129,199,0,112,0,3,129,199,0,112,0,227,129,199,255,255,248,227,129,199,255,255,248,227,129,199,255,255,248,31,240,56,0,112,0,31,240,56,0,112,0,31,240,56,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,3,241,199,0,0,0,3,241,199,0,0,0,3,241,199,0,0,0,252,14,0,255,255,248,252,14,0,255,255,248,252,14,0,255,255,248,
  // 0x9577  長
  119,149,45,45,14,48,0,250,0,15,255,255,254,0,0,15,255,255,254,0,0,15,255,255,254,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,112,56,0,0,0,0,112,56,0,0,0,0,112,56,0,0,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,113,192,0,126,0,0,113,192,0,126,0,0,113,192,0,126,0,0,126,0,0,1,248,0,126,0,0,1,248,0,126,0,0,1,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x9589  閉
  137,149,39,45,225,48,3,250,255,254,0,255,254,255,254,0,255,254,255,254,0,255,254,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,255,254,0,255,254,255,254,0,255,254,255,254,0,255,254,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,255,254,0,255,254,255,254,0,255,254,255,254,0,255,254,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,127,255,255,142,224,127,255,255,142,224,127,255,255,142,224,0,63,0,14,224,0,63,0,14,224,0,63,0,14,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,112,7,0,14,224,112,7,0,14,224,112,7,0,14,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x958b  開
  139,149,36,45,225,48,3,250,255,254,7,255,240,255,254,7,255,240,255,254,7,255,240,224,14,7,0,112,224,14,7,0,112,224,14,7,0,112,255,254,7,255,240,255,254,7,255,240,255,254,7,255,240,224,14,7,0,112,224,14,7,0,112,224,14,7,0,112,255,254,7,255,240,255,254,7,255,240,255,254,7,255,240,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,127,255,224,112,224,127,255,224,112,224,127,255,224,112,224,14,7,0,112,224,14,7,0,112,224,14,7,0,112,224,14,7,0,112,224,14,7,0,112,224,14,7,0,112,227,255,255,252,112,227,255,255,252,112,227,255,255,252,112,224,14,7,0,112,224,14,7,0,112,224,14,7,0,112,224,14,7,0,112,224,14,7,0,112,224,14,7,0,112,224,112,7,0,112,224,112,7,0,112,224,112,7,0,112,227,128,7,28,112,227,128,7,28,112,227,128,7,28,112,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,
  // 0x9593  間
  147,149,36,45,225,48,3,250,255,254,7,255,240,255,254,7,255,240,255,254,7,255,240,224,14,7,0,112,224,14,7,0,112,224,14,7,0,112,255,254,7,255,240,255,254,7,255,240,255,254,7,255,240,224,14,7,0,112,224,14,7,0,112,224,14,7,0,112,255,254,7,255,240,255,254,7,255,240,255,254,7,255,240,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,127,255,224,112,224,127,255,224,112,224,127,255,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,127,255,224,112,224,127,255,224,112,224,127,255,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,127,255,224,112,224,127,255,224,112,224,127,255,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,28,112,224,0,0,28,112,224,0,0,28,112,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,
  // 0x95dc  關
  220,149,39,48,240,48,3,250,255,254,0,255,254,255,254,0,255,254,255,254,0,255,254,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,255,254,0,255,254,255,254,0,255,254,255,254,0,255,254,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,255,254,0,255,254,255,254,0,255,254,255,254,0,255,254,224,112,0,224,14,224,112,0,224,14,224,112,0,224,14,227,129,199,3,142,227,129,199,3,142,227,129,199,3,142,227,254,7,252,14,227,254,7,252,14,227,254,7,252,14,224,113,192,227,142,224,113,192,227,142,224,113,192,227,142,227,255,199,255,142,227,255,199,255,142,227,255,199,255,142,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,227,129,199,3,142,227,129,199,3,142,227,129,199,3,142,227,255,199,255,142,227,255,199,255,142,227,255,199,255,142,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,14,7,3,142,224,14,7,3,142,224,14,7,3,142,224,112,7,0,112,224,112,7,0,112,224,112,7,0,112,
  // 0x964d  降
  77,150,42,48,32,48,3,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,254,7,0,0,0,255,254,7,0,0,0,255,254,7,0,0,0,224,14,7,255,254,0,224,14,7,255,254,0,224,14,7,255,254,0,224,112,56,0,112,0,224,112,56,0,112,0,224,112,56,0,112,0,224,113,199,3,128,0,224,113,199,3,128,0,224,113,199,3,128,0,227,128,0,252,0,0,227,128,0,252,0,0,227,128,0,252,0,0,224,112,63,3,240,0,224,112,63,3,240,0,224,112,63,3,240,0,224,127,192,28,15,192,224,127,192,28,15,192,224,127,192,28,15,192,224,14,0,28,0,0,224,14,0,28,0,0,224,14,0,28,0,0,224,14,63,255,254,0,224,14,63,255,254,0,224,14,63,255,254,0,224,14,0,28,0,0,224,14,0,28,0,0,224,14,0,28,0,0,252,113,192,28,0,0,252,113,192,28,0,0,252,113,192,28,0,0,227,129,255,255,255,192,227,129,255,255,255,192,227,129,255,255,255,192,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,
  // 0x9664  除
  100,150,42,45,14,48,3,250,255,240,0,224,0,0,255,240,0,224,0,0,255,240,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,227,128,7,28,0,0,227,128,7,28,0,0,227,128,7,28,0,0,227,128,56,3,128,0,227,128,56,3,128,0,227,128,56,3,128,0,252,1,192,0,112,0,252,1,192,0,112,0,252,1,192,0,112,0,227,142,63,255,143,192,227,142,63,255,143,192,227,142,63,255,143,192,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,113,255,255,254,0,224,113,255,255,254,0,224,113,255,255,254,0,252,112,0,224,0,0,252,112,0,224,0,0,252,112,0,224,0,0,227,128,56,227,128,0,227,128,56,227,128,0,227,128,56,227,128,0,224,1,192,224,112,0,224,1,192,224,112,0,224,1,192,224,112,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,0,56,224,14,0,224,0,56,224,14,0,224,0,56,224,14,0,224,0,7,0,0,0,224,0,7,0,0,0,224,0,7,0,0,0,
  // 0x968e  階
  142,150,42,48,32,48,3,250,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,3,128,0,255,254,56,3,129,192,255,254,56,3,129,192,255,254,56,3,129,192,224,14,63,227,142,0,224,14,63,227,142,0,224,14,63,227,142,0,224,112,56,3,240,0,224,112,56,3,240,0,224,112,56,3,240,0,224,112,56,227,129,192,224,112,56,227,129,192,224,112,56,227,129,192,227,128,63,3,129,192,227,128,63,3,129,192,227,128,63,3,129,192,224,112,56,28,127,192,224,112,56,28,127,192,224,112,56,28,127,192,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,14,63,255,254,0,224,14,63,255,254,0,224,14,63,255,254,0,224,14,56,0,14,0,224,14,56,0,14,0,224,14,56,0,14,0,224,14,56,0,14,0,224,14,56,0,14,0,224,14,56,0,14,0,252,112,63,255,254,0,252,112,63,255,254,0,252,112,63,255,254,0,227,128,56,0,14,0,227,128,56,0,14,0,227,128,56,0,14,0,224,0,56,0,14,0,224,0,56,0,14,0,224,0,56,0,14,0,224,0,63,255,254,0,224,0,63,255,254,0,224,0,63,255,254,0,224,0,56,0,14,0,224,0,56,0,14,0,224,0,56,0,14,0,
  // 0x96d9  雙
  217,150,45,48,32,48,0,250,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,255,255,31,255,248,3,255,255,31,255,248,3,255,255,31,255,248,31,129,192,252,14,0,31,129,192,252,14,0,31,129,192,252,14,0,227,255,255,31,255,248,227,255,255,31,255,248,227,255,255,31,255,248,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,255,255,31,255,248,3,255,255,31,255,248,3,255,255,31,255,248,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,255,255,31,255,248,3,255,255,31,255,248,3,255,255,31,255,248,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,127,192,31,240,0,0,127,192,31,240,0,0,127,192,31,240,0,255,128,0,0,15,248,255,128,0,0,15,248,255,128,0,0,15,248,
  // 0x96e2  離
  226,150,42,48,32,48,3,250,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,255,255,248,224,0,0,255,255,248,224,0,0,255,255,248,224,0,0,3,142,0,255,255,192,3,142,0,255,255,192,3,142,0,255,255,192,224,112,63,224,112,0,224,112,63,224,112,0,224,112,63,224,112,0,227,142,56,224,112,0,227,142,56,224,112,0,227,142,56,224,112,0,224,0,56,255,255,192,224,0,56,255,255,192,224,0,56,255,255,192,255,255,248,224,112,0,255,255,248,224,112,0,255,255,248,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,255,255,248,255,255,192,255,255,248,255,255,192,255,255,248,255,255,192,227,128,56,224,112,0,227,128,56,224,112,0,227,128,56,224,112,0,227,142,56,224,112,0,227,142,56,224,112,0,227,142,56,224,112,0,227,254,56,224,112,0,227,254,56,224,112,0,227,254,56,224,112,0,224,0,56,255,255,192,224,0,56,255,255,192,224,0,56,255,255,192,224,14,56,224,0,0,224,14,56,224,0,0,224,14,56,224,0,0,224,1,192,224,0,0,224,1,192,224,0,0,224,1,192,224,0,0,
  // 0x96fb  電
  251,150,45,48,32,48,0,250,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,7,0,0,56,28,0,7,0,0,56,28,0,7,0,0,56,224,127,199,31,241,192,224,127,199,31,241,192,224,127,199,31,241,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,127,199,31,240,0,0,127,199,31,240,0,0,127,199,31,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,56,0,0,7,0,0,56,0,0,7,0,0,56,0,0,7,0,0,56,0,0,7,0,0,56,0,0,7,0,0,56,0,0,0,255,255,248,0,0,0,255,255,248,0,0,0,255,255,248,
  // 0x9752  青
  82,151,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,
  // 0x975e  非
  94,151,45,48,32,48,0,250,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,255,255,192,31,255,248,255,255,192,31,255,248,255,255,192,31,255,248,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,31,255,192,31,255,192,31,255,192,31,255,192,31,255,192,31,255,192,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,255,255,192,31,255,248,255,255,192,31,255,248,255,255,192,31,255,248,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,
  // 0x9762  面
  98,151,45,45,14,48,0,250,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,255,252,14,0,3,129,255,252,14,0,3,129,255,252,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,255,252,14,0,3,129,255,252,14,0,3,129,255,252,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,
  // 0x9805  項
  5,152,45,45,14,48,0,250,0,0,7,255,255,248,0,0,7,255,255,248,0,0,7,255,255,248,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,255,255,192,28,0,0,255,255,192,28,0,0,255,255,192,28,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,127,199,0,1,192,0,127,199,0,1,192,0,127,199,0,1,192,255,128,7,255,255,192,255,128,7,255,255,192,255,128,7,255,255,192,28,0,0,224,14,0,28,0,0,224,14,0,28,0,0,224,14,0,0,0,7,0,1,192,0,0,7,0,1,192,0,0,7,0,1,192,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,
  // 0x9810  預
  16,152,45,45,14,48,0,250,31,255,192,255,255,248,31,255,192,255,255,248,31,255,192,255,255,248,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,14,0,224,1,192,0,14,0,224,1,192,0,14,0,224,1,192,255,255,248,224,1,192,255,255,248,224,1,192,255,255,248,224,1,192,0,112,56,255,255,192,0,112,56,255,255,192,0,112,56,255,255,192,0,113,192,224,1,192,0,113,192,224,1,192,0,113,192,224,1,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,28,112,0,224,1,192,28,112,0,224,1,192,28,112,0,224,1,192,3,128,7,0,0,56,3,128,7,0,0,56,3,128,7,0,0,56,
  // 0x984d  額
  77,152,45,48,32,48,0,250,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,0,112,0,255,255,248,0,112,0,255,255,248,0,112,0,255,255,248,255,255,248,0,112,0,255,255,248,0,112,0,255,255,248,0,112,0,224,0,56,3,128,0,224,0,56,3,128,0,224,0,56,3,128,0,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,255,192,224,1,192,3,255,192,224,1,192,3,255,192,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,227,142,0,255,255,192,227,142,0,255,255,192,227,142,0,255,255,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,3,142,0,255,255,192,3,142,0,255,255,192,3,142,0,255,255,192,28,1,192,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,255,255,248,224,1,192,255,255,248,224,1,192,255,255,248,224,1,192,28,1,192,255,255,192,28,1,192,255,255,192,28,1,192,255,255,192,28,1,192,28,14,0,28,1,192,28,14,0,28,1,192,28,14,0,31,255,192,224,1,192,31,255,192,224,1,192,31,255,192,224,1,192,28,1,199,0,0,56,28,1,199,0,0,56,28,1,199,0,0,56,
  // 0x985e  類
  94,152,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,224,112,56,255,255,248,224,112,56,255,255,248,224,112,56,255,255,248,28,113,192,0,112,0,28,113,192,0,112,0,28,113,192,0,112,0,255,255,248,3,128,0,255,255,248,3,128,0,255,255,248,3,128,0,3,240,0,255,255,192,3,240,0,255,255,192,3,240,0,255,255,192,28,113,192,224,1,192,28,113,192,224,1,192,28,113,192,224,1,192,224,112,56,224,1,192,224,112,56,224,1,192,224,112,56,224,1,192,0,0,0,255,255,192,0,0,0,255,255,192,0,0,0,255,255,192,0,113,192,224,1,192,0,113,192,224,1,192,0,113,192,224,1,192,0,112,56,255,255,192,0,112,56,255,255,192,0,112,56,255,255,192,255,255,248,224,1,192,255,255,248,224,1,192,255,255,248,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,3,142,0,255,255,192,3,142,0,255,255,192,3,142,0,255,255,192,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,28,1,192,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,224,0,7,0,0,56,224,0,7,0,0,56,224,0,7,0,0,56,
  // 0x98a8  風
  168,152,45,45,14,48,0,250,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,255,142,0,3,128,0,255,142,0,3,128,0,255,142,0,3,143,255,0,14,0,3,143,255,0,14,0,3,143,255,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,143,255,255,142,0,3,143,255,255,142,0,3,143,255,255,142,0,3,142,7,3,142,0,3,142,7,3,142,0,3,142,7,3,142,0,3,142,7,3,142,0,3,142,7,3,142,0,3,142,7,3,142,0,3,143,255,255,142,0,3,143,255,255,142,0,3,143,255,255,142,0,3,142,7,0,14,0,3,142,7,0,14,0,3,142,7,0,14,0,3,128,7,28,14,56,3,128,7,28,14,56,3,128,7,28,14,56,3,128,7,255,142,56,3,128,7,255,142,56,3,128,7,255,142,56,28,127,248,3,142,56,28,127,248,3,142,56,28,127,248,3,142,56,28,14,0,0,1,248,28,14,0,0,1,248,28,14,0,0,1,248,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,
  // 0x98fd  飽
  253,152,45,48,32,48,0,250,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,113,192,255,255,192,0,113,192,255,255,192,0,113,192,255,255,192,0,112,56,224,1,192,0,112,56,224,1,192,0,112,56,224,1,192,3,142,7,0,1,192,3,142,7,0,1,192,3,142,7,0,1,192,31,255,248,255,241,192,31,255,248,255,241,192,31,255,248,255,241,192,227,128,56,224,113,192,227,128,56,224,113,192,227,128,56,224,113,192,3,255,248,224,113,192,3,255,248,224,113,192,3,255,248,224,113,192,3,128,56,255,241,192,3,128,56,255,241,192,3,128,56,255,241,192,3,255,248,224,1,192,3,255,248,224,1,192,3,255,248,224,1,192,3,128,0,224,113,192,3,128,0,224,113,192,3,128,0,224,113,192,3,142,0,224,14,0,3,142,0,224,14,0,3,142,0,224,14,0,3,129,192,224,0,56,3,129,192,224,0,56,3,129,192,224,0,56,3,142,56,224,0,56,3,142,56,224,0,56,3,142,56,224,0,56,3,240,56,31,255,248,3,240,56,31,255,248,3,240,56,31,255,248,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,
  // 0x9918  餘
  24,153,45,48,32,48,0,250,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,113,192,3,142,0,0,113,192,3,142,0,0,113,192,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,3,142,7,28,1,192,3,142,7,28,1,192,3,142,7,28,1,192,31,255,248,227,254,56,31,255,248,227,254,56,31,255,248,227,254,56,227,128,56,0,112,0,227,128,56,0,112,0,227,128,56,0,112,0,3,255,248,0,112,0,3,255,248,0,112,0,3,255,248,0,112,0,3,128,56,255,255,248,3,128,56,255,255,248,3,128,56,255,255,248,3,255,248,0,112,0,3,255,248,0,112,0,3,255,248,0,112,0,3,128,0,28,126,0,3,128,0,28,126,0,3,128,0,28,126,0,3,142,0,28,113,192,3,142,0,28,113,192,3,142,0,28,113,192,3,129,192,224,112,56,3,129,192,224,112,56,3,129,192,224,112,56,3,142,63,0,112,56,3,142,63,0,112,56,3,142,63,0,112,56,3,240,56,28,112,0,3,240,56,28,112,0,3,240,56,28,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,
  // 0x99ac  馬
  172,153,39,45,225,48,0,250,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,3,255,255,255,240,3,255,255,255,240,3,255,255,255,240,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,3,255,255,255,240,3,255,255,255,240,3,255,255,255,240,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,112,56,28,14,0,112,56,28,14,0,112,56,28,14,28,14,7,3,142,28,14,7,3,142,28,14,7,3,142,28,14,7,3,142,28,14,7,3,142,28,14,7,3,142,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,0,0,0,28,112,0,0,0,28,112,0,0,0,28,112,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,
  // 0x9a45  驅
  69,154,45,45,14,48,0,250,255,254,63,255,255,248,255,254,63,255,255,248,255,254,63,255,255,248,227,128,56,0,0,0,227,128,56,0,0,0,227,128,56,0,0,0,255,254,56,31,255,192,255,254,56,31,255,192,255,254,56,31,255,192,227,128,56,28,1,192,227,128,56,28,1,192,227,128,56,28,1,192,255,254,56,28,1,192,255,254,56,28,1,192,255,254,56,28,1,192,227,128,56,31,255,192,227,128,56,31,255,192,227,128,56,31,255,192,227,128,56,0,0,0,227,128,56,0,0,0,227,128,56,0,0,0,255,254,56,255,143,248,255,254,56,255,143,248,255,254,56,255,143,248,0,14,56,227,142,56,0,14,56,227,142,56,0,14,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,255,143,248,227,142,56,255,143,248,227,142,56,255,143,248,224,14,56,0,0,0,224,14,56,0,0,0,224,14,56,0,0,0,0,14,63,255,255,248,0,14,63,255,255,248,0,14,63,255,255,248,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,
  // 0x9ad4  體
  212,154,45,48,32,48,0,250,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,31,255,199,255,255,192,31,255,199,255,255,192,31,255,199,255,255,192,28,1,199,28,113,192,28,1,199,28,113,192,28,1,199,28,113,192,31,241,199,255,255,192,31,241,199,255,255,192,31,241,199,255,255,192,28,113,199,28,113,192,28,113,199,28,113,192,28,113,199,28,113,192,255,255,255,255,255,192,255,255,255,255,255,192,255,255,255,255,255,192,224,0,56,0,0,0,224,0,56,0,0,0,224,0,56,0,0,0,31,255,199,255,255,192,31,255,199,255,255,192,31,255,199,255,255,192,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,31,255,199,255,255,192,31,255,199,255,255,192,31,255,199,255,255,192,28,1,199,0,1,192,28,1,199,0,1,192,28,1,199,0,1,192,31,255,199,255,255,192,31,255,199,255,255,192,31,255,199,255,255,192,28,1,192,224,14,0,28,1,192,224,14,0,28,1,192,224,14,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,113,255,255,255,248,28,113,255,255,255,248,28,113,255,255,255,248,28,14,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,
  // 0x9ad8  高
  216,154,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,15,255,255,129,192,28,15,255,255,129,192,28,15,255,255,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,15,255,255,129,192,28,15,255,255,129,192,28,15,255,255,129,192,28,0,0,0,15,192,28,0,0,0,15,192,28,0,0,0,15,192,
  // 0x9ec3  黃
  195,158,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x9ede  點
  222,158,45,48,32,48,0,250,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,255,248,0,112,0,255,255,248,0,112,0,255,255,248,0,112,0,224,112,56,0,112,0,224,112,56,0,112,0,224,112,56,0,112,0,252,113,248,0,112,0,252,113,248,0,112,0,252,113,248,0,112,0,227,254,56,0,127,248,227,254,56,0,127,248,227,254,56,0,127,248,224,112,56,0,112,0,224,112,56,0,112,0,224,112,56,0,112,0,255,255,248,0,112,0,255,255,248,0,112,0,255,255,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,255,255,248,255,255,248,255,255,248,255,255,248,255,255,248,255,255,248,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,127,248,224,0,56,0,127,248,224,0,56,0,127,248,224,0,56,255,128,0,224,0,56,255,128,0,224,0,56,255,128,0,224,0,56,0,0,56,224,0,56,0,0,56,224,0,56,0,0,56,224,0,56,227,142,56,224,0,56,227,142,56,224,0,56,227,142,56,224,0,56,227,142,0,255,255,248,227,142,0,255,255,248,227,142,0,255,255,248,224,0,0,224,0,56,224,0,0,224,0,56,224,0,0,224,0,56,
  // 0x9f4a  齊
  74,159,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,0,56,224,15,192,0,0,56,224,15,192,0,0,56,224,15,192,31,255,199,31,240,0,31,255,199,31,240,0,31,255,199,31,240,0,3,129,199,28,112,0,3,129,199,28,112,0,3,129,199,28,112,0,3,129,199,28,112,0,3,129,199,28,112,0,3,129,199,28,112,0,28,1,199,28,14,0,28,1,199,28,14,0,28,1,199,28,14,0,224,15,199,31,129,248,224,15,199,31,129,248,224,15,199,31,129,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,
  // 0xff1a  ：
  26,255,12,21,42,48,18,3,255,240,255,240,255,240,255,240,255,240,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,240,255,240,255,240,255,240,255,240,255,240,
};

#endif // HAS_GRAPHICAL_TFT
