/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Simplified Chinese 48pt, capital 'A' height: 30px, width: 100%, range: 0x201c-0xff1a, glyphs: 373
extern const uint8_t Unifont_Simplified_Chinese_30[23990] = {
  161,30,28,32,26,255,42,250, // unifont_t
  // 0x201c  “
  28,32,18,12,36,24,3,24,28,1,192,28,1,192,28,1,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,252,15,192,252,15,192,252,15,192,
  // 0x201d  ”
  29,32,18,12,36,24,3,24,252,15,192,252,15,192,252,15,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,224,14,0,224,14,0,224,14,0,
  // 0x22bf  ⊿
  191,34,18,18,54,24,3,0,0,1,192,0,1,192,0,1,192,0,15,192,0,15,192,0,15,192,0,113,192,0,113,192,0,113,192,3,129,192,3,129,192,3,129,192,28,1,192,28,1,192,28,1,192,255,255,192,255,255,192,255,255,192,
  // 0x4e00  一
  0,78,45,3,18,48,0,18,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x4e09  三
  9,78,45,36,216,48,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x4e0a  上
  10,78,45,45,14,48,0,253,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x4e0b  下
  11,78,45,45,14,48,0,250,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x4e0d  不
  13,78,42,45,14,48,0,250,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,63,28,0,0,0,0,63,28,0,0,0,0,63,28,0,0,0,1,199,3,128,0,0,1,199,3,128,0,0,1,199,3,128,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,28,0,7,0,1,192,28,0,7,0,1,192,28,0,7,0,1,192,224,0,7,0,0,0,224,0,7,0,0,0,224,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x4e13  专
  19,78,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,1,248,28,0,0,0,1,248,28,0,0,0,1,248,28,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0x4e1d  丝
  29,78,45,45,14,48,0,253,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,28,0,56,224,1,192,28,0,56,224,1,192,28,0,56,224,1,192,31,255,192,255,254,0,31,255,192,255,254,0,31,255,192,255,254,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,31,255,248,255,255,192,31,255,248,255,255,192,31,255,248,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x4e2a  个
  42,78,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,252,0,7,0,1,248,252,0,7,0,1,248,252,0,7,0,1,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x4e2d  中
  45,78,33,48,240,48,6,250,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,
  // 0x4e3a  为
  58,78,39,48,240,48,0,250,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,31,255,255,255,254,31,255,255,255,254,31,255,255,255,254,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,224,14,0,0,56,224,14,0,0,56,224,14,0,1,192,28,14,0,1,192,28,14,0,1,192,28,14,0,1,192,28,14,0,1,192,28,14,0,1,192,28,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,3,128,0,0,14,3,128,0,0,14,3,128,0,0,14,28,0,0,28,112,28,0,0,28,112,28,0,0,28,112,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,
  // 0x4e3b  主
  59,78,45,45,14,48,0,253,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x4e49  义
  73,78,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,3,240,0,0,126,0,3,240,0,0,126,0,3,240,0,0,126,0,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,
  // 0x4e4b  之
  75,78,42,45,14,48,3,253,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,240,0,255,255,255,255,240,0,255,255,255,255,240,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,224,1,255,255,255,192,224,1,255,255,255,192,224,1,255,255,255,192,
  // 0x4e86  了
  134,78,36,45,225,48,3,250,255,255,255,255,240,255,255,255,255,240,255,255,255,255,240,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,14,56,0,0,0,14,56,0,0,0,14,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,
  // 0x4e8c  二
  140,78,45,30,180,48,0,3,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x4e8e  于
  142,78,45,45,14,48,0,250,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x4ea4  交
  164,78,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,15,192,28,0,0,0,15,192,28,0,0,0,15,192,28,0,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,252,0,0,0,15,248,252,0,0,0,15,248,252,0,0,0,15,248,
  // 0x4eae  亮
  174,78,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,1,255,252,1,192,224,1,255,252,1,192,224,1,255,252,1,192,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,3,240,0,28,0,56,3,240,0,28,0,56,3,240,0,28,0,56,252,0,0,3,255,248,252,0,0,3,255,248,252,0,0,3,255,248,
  // 0x4ece  从
  206,78,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,28,112,0,0,14,0,28,112,0,0,14,0,28,112,0,0,113,192,28,112,0,0,113,192,28,112,0,0,113,192,28,112,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,224,14,0,0,112,56,224,14,0,0,112,56,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,28,0,56,0,1,192,28,0,56,0,1,192,28,0,56,0,1,192,224,1,192,0,0,56,224,1,192,0,0,56,224,1,192,0,0,56,
  // 0x4ee4  令
  228,78,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,56,3,128,0,0,14,56,3,128,0,0,14,56,3,128,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,
  // 0x4ee5  以
  229,78,39,48,240,48,6,250,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,224,14,0,28,0,224,14,0,28,0,224,14,0,28,0,224,1,192,28,0,224,1,192,28,0,224,1,192,28,0,224,1,192,28,0,224,1,192,28,0,224,1,192,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,224,0,224,0,0,224,0,224,0,0,224,0,224,0,0,224,0,224,0,0,224,0,224,0,0,224,0,224,0,0,224,0,224,0,0,224,0,224,0,0,224,0,224,112,7,0,0,224,112,7,0,0,224,112,7,0,0,227,128,7,28,0,227,128,7,28,0,227,128,7,28,0,252,0,56,3,128,252,0,56,3,128,252,0,56,3,128,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,
  // 0x4ef6  件
  246,78,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,
  // 0x4efd  份
  253,78,45,48,32,48,0,250,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,224,112,0,0,14,0,224,112,0,0,14,0,224,112,0,0,14,0,224,112,0,0,14,0,224,112,0,0,14,0,224,112,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,3,240,7,0,1,192,3,240,7,0,1,192,3,240,7,0,1,192,3,240,56,0,1,192,3,240,56,0,1,192,3,240,56,0,1,192,28,113,199,255,254,56,28,113,199,255,254,56,28,113,199,255,254,56,224,112,0,224,14,0,224,112,0,224,14,0,224,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,0,113,192,0,112,0,0,113,192,0,112,0,0,113,192,0,112,0,
  // 0x4f11  休
  17,79,45,48,32,48,0,250,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,3,240,0,28,0,0,3,240,0,28,0,0,3,240,0,28,0,0,3,240,0,255,128,0,3,240,0,255,128,0,3,240,0,255,128,0,28,112,0,255,128,0,28,112,0,255,128,0,28,112,0,255,128,0,224,112,7,28,112,0,224,112,7,28,112,0,224,112,7,28,112,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,126,0,28,0,56,0,126,0,28,0,56,0,126,0,28,0,56,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,
  // 0x4f20  传
  32,79,45,48,32,48,0,250,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,240,0,224,0,0,3,240,0,224,0,0,3,240,0,224,0,0,3,241,255,255,255,248,3,241,255,255,255,248,3,241,255,255,255,248,28,112,0,224,0,0,28,112,0,224,0,0,28,112,0,224,0,0,224,112,7,0,0,0,224,112,7,0,0,0,224,112,7,0,0,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,
  // 0x4f4d  位
  77,79,45,48,32,48,0,250,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,14,0,3,240,0,0,14,0,3,240,0,0,14,0,28,112,56,0,14,0,28,112,56,0,14,0,28,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,127,255,255,255,248,0,127,255,255,255,248,0,127,255,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x4f4e  低
  78,79,45,48,32,48,0,250,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,3,255,192,0,14,0,3,255,192,0,14,0,3,255,192,0,14,63,255,128,0,0,14,63,255,128,0,0,14,63,255,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,3,240,56,3,128,0,28,112,63,255,255,248,28,112,63,255,255,248,28,112,63,255,255,248,224,112,56,3,128,0,224,112,56,3,128,0,224,112,56,3,128,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,56,0,112,56,0,112,56,0,112,56,0,112,56,0,112,56,0,14,56,0,112,56,0,14,56,0,112,56,0,14,56,0,112,56,224,14,56,0,112,56,224,14,56,0,112,56,224,14,56,0,112,63,3,129,248,0,112,63,3,129,248,0,112,63,3,129,248,0,112,56,0,112,56,0,112,56,0,112,56,0,112,56,0,112,56,
  // 0x4f53  体
  83,79,45,48,32,48,0,250,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,3,240,0,28,0,0,3,240,0,28,0,0,3,240,0,28,0,0,3,240,0,255,128,0,3,240,0,255,128,0,3,240,0,255,128,0,28,112,0,255,128,0,28,112,0,255,128,0,28,112,0,255,128,0,224,112,7,28,112,0,224,112,7,28,112,0,224,112,7,28,112,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,113,199,255,241,192,0,113,199,255,241,192,0,113,199,255,241,192,0,126,0,28,0,56,0,126,0,28,0,56,0,126,0,28,0,56,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,
  // 0x4f59  余
  89,79,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,143,255,255,142,0,3,143,255,255,142,0,3,143,255,255,142,0,252,0,7,0,1,248,252,0,7,0,1,248,252,0,7,0,1,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,28,1,199,0,1,192,28,1,199,0,1,192,28,1,199,0,1,192,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x4f5c  作
  92,79,45,48,32,48,0,250,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,112,7,255,255,248,0,112,7,255,255,248,0,112,7,255,255,248,0,112,56,224,0,0,0,112,56,224,0,0,0,112,56,224,0,0,3,240,56,224,0,0,3,240,56,224,0,0,3,240,56,224,0,0,3,241,192,224,0,0,3,241,192,224,0,0,3,241,192,224,0,0,28,112,0,255,254,0,28,112,0,255,254,0,28,112,0,255,254,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,
  // 0x4f7f  使
  127,79,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,127,255,255,255,248,0,127,255,255,255,248,0,127,255,255,255,248,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,31,129,255,255,255,192,31,129,255,255,255,192,31,129,255,255,255,192,31,129,192,28,1,192,31,129,192,28,1,192,31,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,56,28,0,0,3,128,56,28,0,0,3,128,56,28,0,0,3,128,7,28,0,0,3,128,7,28,0,0,3,128,7,28,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,7,28,0,0,3,128,7,28,0,0,3,128,7,28,0,0,3,128,56,3,240,0,3,128,56,3,240,0,3,128,56,3,240,0,3,143,192,0,15,248,3,143,192,0,15,248,3,143,192,0,15,248,
  // 0x4f9b  供
  155,79,45,48,32,48,0,250,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,3,240,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,28,112,7,0,112,0,28,112,7,0,112,0,28,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,113,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,0,126,0,0,1,192,0,126,0,0,1,192,0,126,0,0,1,192,
  // 0x4fb5  侵
  181,79,45,48,32,48,0,250,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,63,255,254,0,0,14,63,255,254,0,0,14,63,255,254,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,3,240,63,255,254,0,3,240,63,255,254,0,3,240,63,255,254,0,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,28,113,255,255,255,192,28,113,255,255,255,192,28,113,255,255,255,192,224,113,192,0,1,192,224,113,192,0,1,192,224,113,192,0,1,192,0,112,63,255,240,0,0,112,63,255,240,0,0,112,63,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,7,227,240,0,0,112,7,227,240,0,0,112,7,227,240,0,0,113,248,0,15,248,0,113,248,0,15,248,0,113,248,0,15,248,
  // 0x4fdd  保
  221,79,45,48,32,48,0,250,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,63,255,254,0,0,14,63,255,254,0,0,14,63,255,254,0,0,14,56,0,14,0,0,14,56,0,14,0,0,14,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,3,240,63,255,254,0,3,240,63,255,254,0,3,240,63,255,254,0,3,240,0,28,0,0,3,240,0,28,0,0,3,240,0,28,0,0,28,112,0,28,0,0,28,112,0,28,0,0,28,112,0,28,0,0,224,113,255,255,255,192,224,113,255,255,255,192,224,113,255,255,255,192,0,112,0,255,128,0,0,112,0,255,128,0,0,112,0,255,128,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,126,0,28,0,56,0,126,0,28,0,56,0,126,0,28,0,56,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,
  // 0x4fe1  信
  225,79,45,48,32,48,0,250,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,63,255,255,248,0,14,63,255,255,248,0,14,63,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,240,7,255,255,192,3,240,7,255,255,192,3,240,7,255,255,192,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,224,112,7,255,255,192,224,112,7,255,255,192,224,112,7,255,255,192,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,
  // 0x503c  值
  60,80,45,48,32,48,0,250,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,15,255,255,255,192,0,15,255,255,255,192,0,15,255,255,255,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,240,63,255,254,0,3,240,63,255,254,0,3,240,63,255,254,0,3,240,56,0,14,0,3,240,56,0,14,0,3,240,56,0,14,0,28,112,63,255,254,0,28,112,63,255,254,0,28,112,63,255,254,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,127,255,255,255,248,0,127,255,255,255,248,0,127,255,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x503e  倾
  62,80,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,255,248,0,112,0,255,255,248,0,112,0,255,255,248,0,113,192,0,112,0,0,113,192,0,112,0,0,113,192,0,112,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,31,255,192,3,129,192,31,255,192,3,129,192,31,255,192,31,129,192,28,1,192,31,129,192,28,1,192,31,129,192,28,1,192,31,129,255,28,113,192,31,129,255,28,113,192,31,129,255,28,113,192,227,129,192,28,113,192,227,129,192,28,113,192,227,129,192,28,113,192,3,129,192,28,113,192,3,129,192,28,113,192,3,129,192,28,113,192,3,129,192,28,113,192,3,129,192,28,113,192,3,129,192,28,113,192,3,129,199,28,113,192,3,129,199,28,113,192,3,129,199,28,113,192,3,129,248,28,113,192,3,129,248,28,113,192,3,129,248,28,113,192,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,224,0,56,3,128,0,224,0,56,3,128,0,224,0,56,
  // 0x504f  偏
  79,80,42,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,31,129,255,255,255,192,31,129,255,255,255,192,31,129,255,255,255,192,31,129,192,0,0,0,31,129,192,0,0,0,31,129,192,0,0,0,227,129,192,0,0,0,227,129,192,0,0,0,227,129,192,0,0,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,248,227,129,192,3,129,248,227,129,192,3,129,248,227,129,192,3,142,56,227,129,192,3,142,56,227,129,192,3,142,56,227,129,192,3,142,63,255,255,192,3,142,63,255,255,192,3,142,63,255,255,192,3,142,56,227,129,192,3,142,56,227,129,192,3,142,56,227,129,192,3,142,56,227,129,192,3,142,56,227,129,192,3,142,56,227,129,192,3,240,56,227,129,192,3,240,56,227,129,192,3,240,56,227,129,192,3,128,56,0,15,192,3,128,56,0,15,192,3,128,56,0,15,192,
  // 0x505c  停
  92,80,45,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,31,128,56,0,14,0,31,128,56,0,14,0,31,128,56,0,14,0,31,128,63,255,254,0,31,128,63,255,254,0,31,128,63,255,254,0,227,128,0,0,0,0,227,128,0,0,0,0,227,128,0,0,0,0,3,143,255,255,255,248,3,143,255,255,255,248,3,143,255,255,255,248,3,142,0,0,0,56,3,142,0,0,0,56,3,142,0,0,0,56,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,7,28,0,0,3,128,7,28,0,0,3,128,7,28,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,
  // 0x50a8  储
  168,80,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,126,0,255,254,56,0,126,0,255,254,56,0,126,0,255,254,56,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,3,142,0,3,129,192,3,142,0,3,129,192,3,142,0,31,128,7,255,255,248,31,128,7,255,255,248,31,128,7,255,255,248,31,128,0,3,128,0,31,128,0,3,128,0,31,128,0,3,128,0,227,255,192,28,0,0,227,255,192,28,0,0,227,255,192,28,0,0,3,129,192,255,255,192,3,129,192,255,255,192,3,129,192,255,255,192,3,129,199,28,1,192,3,129,199,28,1,192,3,129,199,28,1,192,3,129,248,28,1,192,3,129,248,28,1,192,3,129,248,28,1,192,3,129,192,31,255,192,3,129,192,31,255,192,3,129,192,31,255,192,3,129,199,28,1,192,3,129,199,28,1,192,3,129,199,28,1,192,3,129,248,28,1,192,3,129,248,28,1,192,3,129,248,28,1,192,3,129,192,31,255,192,3,129,192,31,255,192,3,129,192,31,255,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,
  // 0x50cf  像
  207,80,45,48,32,48,0,250,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,255,240,0,0,14,7,255,240,0,0,14,7,255,240,0,0,14,56,0,112,0,0,14,56,0,112,0,0,14,56,0,112,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,0,126,56,3,129,192,0,126,56,3,129,192,0,126,56,3,129,192,3,240,56,28,1,192,3,240,56,28,1,192,3,240,56,28,1,192,3,240,63,255,255,192,3,240,63,255,255,192,3,240,63,255,255,192,28,112,0,224,0,0,28,112,0,224,0,0,28,112,0,224,0,0,224,112,7,28,1,192,224,112,7,28,1,192,224,112,7,28,1,192,0,113,248,227,142,0,0,113,248,227,142,0,0,113,248,227,142,0,0,112,7,3,240,0,0,112,7,3,240,0,0,112,7,3,240,0,0,113,248,31,142,0,0,113,248,31,142,0,0,113,248,31,142,0,0,112,0,227,142,0,0,112,0,227,142,0,0,112,0,227,142,0,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,113,248,227,128,56,0,113,248,227,128,56,0,113,248,227,128,56,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,
  // 0x5145  充
  69,81,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,1,192,28,14,0,0,1,192,28,14,0,0,1,192,28,14,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,31,128,0,3,255,192,31,128,0,3,255,192,31,128,0,3,255,192,
  // 0x5148  先
  72,81,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,127,255,255,254,0,0,127,255,255,254,0,0,127,255,255,254,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,28,0,7,0,0,0,28,0,7,0,0,0,28,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,3,128,0,3,255,248,3,128,0,3,255,248,3,128,0,3,255,248,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,
  // 0x5149  光
  73,81,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,3,128,0,3,255,248,3,128,0,3,255,248,3,128,0,3,255,248,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,
  // 0x5165  入
  101,81,45,48,32,48,0,250,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,224,0,0,0,1,248,224,0,0,0,1,248,224,0,0,0,1,248,
  // 0x5168  全
  104,81,45,45,14,48,0,253,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,143,255,255,142,0,3,143,255,255,142,0,3,143,255,255,142,0,252,0,7,0,1,248,252,0,7,0,1,248,252,0,7,0,1,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,
  // 0x5171  共
  113,81,42,48,32,48,3,250,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,31,255,255,255,254,0,31,255,255,255,254,0,31,255,255,255,254,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,255,255,255,255,255,192,255,255,255,255,255,192,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,
  // 0x5173  关
  115,81,45,48,32,48,0,250,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,3,240,0,0,126,0,3,240,0,0,126,0,3,240,0,0,126,0,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,
  // 0x5177  具
  119,81,45,45,14,48,0,250,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,
  // 0x5197  冗
  151,81,45,42,252,48,0,250,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,252,0,0,0,15,255,252,0,0,0,15,255,252,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,28,0,0,3,255,248,28,0,0,3,255,248,28,0,0,3,255,248,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,
  // 0x51b7  冷
  183,81,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,56,28,14,0,0,0,56,28,14,0,0,0,56,28,14,0,0,113,192,3,129,248,0,113,192,3,129,248,0,113,192,3,129,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,255,128,0,0,14,0,255,128,0,0,14,0,255,128,0,0,14,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0x51c6  准
  198,81,45,48,32,48,0,250,0,0,7,28,0,0,0,0,7,28,0,0,0,0,7,28,0,0,28,0,7,3,128,0,28,0,7,3,128,0,28,0,7,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,3,128,63,255,255,248,3,128,63,255,255,248,3,128,63,255,255,248,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,3,128,0,0,113,248,3,128,0,0,113,248,3,128,0,0,113,248,3,128,0,0,126,63,255,255,192,0,126,63,255,255,192,0,126,63,255,255,192,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,63,255,255,192,3,128,63,255,255,192,3,128,63,255,255,192,255,128,56,3,128,0,255,128,56,3,128,0,255,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,63,255,255,248,3,128,63,255,255,248,3,128,63,255,255,248,3,128,56,0,0,0,3,128,56,0,0,0,3,128,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x51fa  出
  250,81,39,48,240,48,3,250,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,
  // 0x51fb  击
  251,81,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,
  // 0x5206  分
  6,82,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,224,127,255,255,128,56,224,127,255,255,128,56,224,127,255,255,128,56,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,7,28,0,0,3,128,7,28,0,0,3,128,7,28,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,
  // 0x5207  切
  7,82,42,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,127,248,28,1,192,0,127,248,28,1,192,0,127,248,28,1,192,255,240,0,28,1,192,255,240,0,28,1,192,255,240,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,126,0,224,1,192,0,126,0,224,1,192,0,126,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,0,7,0,1,192,0,0,7,0,1,192,0,0,7,0,1,192,0,0,56,3,142,0,0,0,56,3,142,0,0,0,56,3,142,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,
  // 0x521b  创
  27,82,42,48,32,48,0,250,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,28,0,0,227,129,192,28,0,0,227,129,192,28,0,0,227,129,192,227,255,248,3,129,192,227,255,248,3,129,192,227,255,248,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,142,56,3,129,192,3,142,56,3,129,192,3,142,56,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,192,0,127,255,224,113,192,0,127,255,224,113,192,0,127,255,224,113,192,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,
  // 0x521d  初
  29,82,42,48,32,48,0,250,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,0,7,255,255,192,0,0,7,255,255,192,0,0,7,255,255,192,255,255,192,28,1,192,255,255,192,28,1,192,255,255,192,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,3,241,192,28,1,192,3,241,192,28,1,192,3,241,192,28,1,192,28,126,0,28,1,192,28,126,0,28,1,192,28,126,0,28,1,192,224,113,192,28,1,192,224,113,192,28,1,192,224,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,0,113,192,0,112,0,0,113,192,0,112,0,0,113,192,0,112,0,
  // 0x522b  别
  43,82,42,48,32,48,0,250,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,31,255,255,0,1,192,31,255,255,0,1,192,31,255,255,0,1,192,28,0,7,0,1,192,28,0,7,0,1,192,28,0,7,0,1,192,28,0,7,3,129,192,28,0,7,3,129,192,28,0,7,3,129,192,28,0,7,3,129,192,28,0,7,3,129,192,28,0,7,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,255,255,255,3,129,192,255,255,255,3,129,192,255,255,255,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,28,14,56,0,113,192,28,14,56,0,113,192,28,14,56,0,113,192,224,1,192,0,14,0,224,1,192,0,14,0,224,1,192,0,14,0,
  // 0x5230  到
  48,82,42,48,32,48,0,250,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,255,255,255,224,1,192,255,255,255,224,1,192,255,255,255,224,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,28,0,7,3,129,192,28,0,7,3,129,192,28,0,7,3,129,192,255,255,255,227,129,192,255,255,255,227,129,192,255,255,255,227,129,192,0,14,0,227,129,192,0,14,0,227,129,192,0,14,0,227,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,15,255,224,1,192,0,15,255,224,1,192,0,15,255,224,1,192,255,254,0,0,113,192,255,254,0,0,113,192,255,254,0,0,113,192,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,
  // 0x5236  制
  54,82,42,48,32,48,0,250,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,255,255,227,129,192,3,255,255,227,129,192,3,255,255,227,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,255,255,255,255,129,192,255,255,255,255,129,192,255,255,255,255,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,3,255,255,227,129,192,3,255,255,227,129,192,3,255,255,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,248,224,1,192,3,129,248,224,1,192,3,129,248,224,1,192,3,129,199,0,1,192,3,129,199,0,1,192,3,129,199,0,1,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,
  // 0x5237  刷
  55,82,45,48,32,48,0,250,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,3,255,255,252,0,56,3,255,255,252,0,56,3,255,255,252,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,255,255,252,112,56,3,255,255,252,112,56,3,255,255,252,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,255,255,252,112,56,3,255,255,252,112,56,3,255,255,252,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,224,112,63,28,0,56,224,112,63,28,0,56,224,112,63,28,0,56,0,112,56,224,0,56,0,112,56,224,0,56,0,112,56,224,0,56,0,0,56,0,14,56,0,0,56,0,14,56,0,0,56,0,14,56,0,0,56,0,1,192,0,0,56,0,1,192,0,0,56,0,1,192,
  // 0x5272  割
  114,82,42,48,32,48,0,250,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,255,255,255,224,1,192,255,255,255,224,1,192,255,255,255,224,1,192,224,0,0,227,129,192,224,0,0,227,129,192,224,0,0,227,129,192,0,14,7,3,129,192,0,14,7,3,129,192,0,14,7,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,255,255,255,227,129,192,255,255,255,227,129,192,255,255,255,227,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,28,0,7,0,1,192,28,0,7,0,1,192,28,0,7,0,1,192,28,0,7,0,1,192,28,0,7,0,1,192,28,0,7,0,1,192,31,255,255,0,113,192,31,255,255,0,113,192,31,255,255,0,113,192,28,0,7,0,14,0,28,0,7,0,14,0,28,0,7,0,14,0,
  // 0x529b  力
  155,82,36,48,240,48,3,250,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,255,255,255,255,240,255,255,255,255,240,255,255,255,255,240,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,112,0,0,112,0,112,0,0,112,0,112,0,0,112,0,112,0,0,112,0,112,0,0,112,0,112,0,0,112,3,128,7,0,112,3,128,7,0,112,3,128,7,0,112,28,0,0,227,128,28,0,0,227,128,28,0,0,227,128,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,
  // 0x529f  功
  159,82,42,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,255,248,28,0,0,255,255,248,28,0,0,255,255,248,28,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,127,248,224,1,192,0,127,248,224,1,192,0,127,248,224,1,192,255,240,7,0,1,192,255,240,7,0,1,192,255,240,7,0,1,192,28,0,7,0,1,192,28,0,7,0,1,192,28,0,7,0,1,192,0,0,56,3,142,0,0,0,56,3,142,0,0,0,56,3,142,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,
  // 0x52a0  加
  160,82,42,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,31,255,192,0,112,0,31,255,192,0,112,0,31,255,192,255,255,248,28,1,192,255,255,248,28,1,192,255,255,248,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,31,255,192,3,128,56,31,255,192,3,128,56,31,255,192,28,14,56,28,1,192,28,14,56,28,1,192,28,14,56,28,1,192,224,1,192,0,0,0,224,1,192,0,0,0,224,1,192,0,0,0,
  // 0x52a8  动
  168,82,42,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,31,255,192,28,0,0,31,255,192,28,0,0,31,255,192,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,7,255,255,192,0,0,7,255,255,192,0,0,7,255,255,192,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,255,255,248,28,1,192,255,255,248,28,1,192,255,255,248,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,192,28,14,0,224,1,192,28,14,0,224,1,192,28,14,0,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,255,255,199,0,1,192,255,255,199,0,1,192,255,255,199,0,1,192,28,1,199,0,1,192,28,1,199,0,1,192,28,1,199,0,1,192,0,0,56,3,142,0,0,0,56,3,142,0,0,0,56,3,142,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,
  // 0x5316  化
  22,83,45,48,32,48,0,250,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,1,192,0,14,0,224,1,192,0,14,0,224,1,192,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,3,240,0,227,128,0,3,240,0,227,128,0,3,240,0,227,128,0,3,240,0,252,0,0,3,240,0,252,0,0,3,240,0,252,0,0,28,112,0,224,0,0,28,112,0,224,0,0,28,112,0,224,0,0,224,112,7,224,0,0,224,112,7,224,0,0,224,112,7,224,0,0,0,112,56,224,0,0,0,112,56,224,0,0,0,112,56,224,0,0,0,113,192,224,0,0,0,113,192,224,0,0,0,113,192,224,0,0,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,31,255,248,0,112,0,31,255,248,0,112,0,31,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x5347  升
  71,83,45,48,32,48,0,250,0,0,7,3,128,0,0,0,7,3,128,0,0,0,7,3,128,0,0,1,255,227,128,0,0,1,255,227,128,0,0,1,255,227,128,0,3,255,192,3,128,0,3,255,192,3,128,0,3,255,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,
  // 0x534a  半
  74,83,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x534f  协
  79,83,45,48,32,48,0,250,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,255,254,63,255,240,0,255,254,63,255,240,0,255,254,63,255,240,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,56,224,126,0,3,128,56,224,126,0,3,128,56,224,126,0,3,128,56,224,113,192,3,128,56,224,113,192,3,128,56,224,113,192,3,129,192,224,112,56,3,129,192,224,112,56,3,129,192,224,112,56,3,142,0,224,112,56,3,142,0,224,112,56,3,142,0,224,112,56,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,56,28,112,0,3,128,56,28,112,0,3,128,56,28,112,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,
  // 0x5355  单
  85,83,45,48,32,48,0,250,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x5361  卡
  97,83,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x5370  印
  112,83,39,45,225,48,3,250,0,15,192,0,0,0,15,192,0,0,0,15,192,0,0,255,240,7,255,254,255,240,7,255,254,255,240,7,255,254,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,255,255,199,0,14,255,255,199,0,14,255,255,199,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,127,199,28,112,224,127,199,28,112,224,127,199,28,112,255,128,7,3,128,255,128,7,3,128,255,128,7,3,128,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,
  // 0x5371  危
  113,83,42,48,32,48,0,250,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,28,127,255,255,255,192,28,127,255,255,255,192,28,127,255,255,255,192,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,63,255,240,0,0,112,63,255,240,0,0,112,63,255,240,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,3,128,56,0,1,192,3,128,56,0,1,192,3,128,56,0,1,192,3,128,56,0,1,192,3,128,56,0,1,192,3,128,56,0,1,192,28,0,7,255,255,192,28,0,7,255,255,192,28,0,7,255,255,192,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,
  // 0x5374  却
  116,83,42,48,32,48,0,250,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,31,255,192,0,14,0,31,255,192,0,14,0,31,255,192,31,255,255,28,1,192,31,255,255,28,1,192,31,255,255,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,255,255,255,252,1,192,255,255,255,252,1,192,255,255,255,252,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,28,0,56,28,113,192,28,0,56,28,113,192,28,0,56,28,113,192,255,255,255,28,14,0,255,255,255,28,14,0,255,255,255,28,14,0,28,0,7,28,0,0,28,0,7,28,0,0,28,0,7,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x5378  卸
  120,83,42,48,32,48,0,250,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,255,255,31,255,192,3,255,255,31,255,192,3,255,255,31,255,192,28,14,0,28,1,192,28,14,0,28,1,192,28,14,0,28,1,192,224,14,0,28,1,192,224,14,0,28,1,192,224,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,31,255,255,28,1,192,31,255,255,28,1,192,31,255,255,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,3,143,248,28,1,192,3,143,248,28,1,192,3,143,248,28,1,192,3,142,0,28,1,192,3,142,0,28,1,192,3,142,0,28,1,192,3,142,0,28,113,192,3,142,0,28,113,192,3,142,0,28,113,192,3,143,255,28,14,0,3,143,255,28,14,0,3,143,255,28,14,0,255,240,0,28,0,0,255,240,0,28,0,0,255,240,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x538b  压
  139,83,45,45,14,48,0,250,3,255,255,255,255,248,3,255,255,255,255,248,3,255,255,255,255,248,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,143,255,255,255,192,3,143,255,255,255,192,3,143,255,255,255,192,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,127,255,255,255,248,28,127,255,255,255,248,28,127,255,255,255,248,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,
  // 0x539f  原
  159,83,45,45,14,48,0,250,3,255,255,255,255,248,3,255,255,255,255,248,3,255,255,255,255,248,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,3,129,255,255,240,0,3,129,255,255,240,0,3,129,255,255,240,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,255,255,240,0,3,129,255,255,240,0,3,129,255,255,240,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,255,255,240,0,3,129,255,255,240,0,3,129,255,255,240,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,129,192,224,112,0,3,129,192,224,112,0,3,129,192,224,112,0,28,14,0,224,14,0,28,14,0,224,14,0,28,14,0,224,14,0,28,112,56,224,1,192,28,112,56,224,1,192,28,112,56,224,1,192,224,0,7,0,0,0,224,0,7,0,0,0,224,0,7,0,0,0,
  // 0x53cc  双
  204,83,45,42,252,48,0,250,255,255,199,255,255,192,255,255,199,255,255,192,255,255,199,255,255,192,0,1,192,224,1,192,0,1,192,224,1,192,0,1,192,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,3,142,0,224,14,0,3,142,0,224,14,0,3,142,0,224,14,0,3,142,0,224,14,0,3,142,0,224,14,0,3,142,0,224,14,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,224,14,0,28,1,192,224,14,0,28,1,192,224,14,0,224,0,7,0,1,192,224,0,7,0,1,192,224,0,7,0,1,192,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,
  // 0x53cd  反
  205,83,45,48,32,48,0,250,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,255,254,0,0,0,0,255,254,0,0,0,0,255,254,0,3,255,255,0,0,0,3,255,255,0,0,0,3,255,255,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,7,28,0,0,3,128,7,28,0,0,3,128,7,28,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,28,0,7,28,0,0,28,0,7,28,0,0,28,0,7,28,0,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,224,15,192,0,126,0,224,15,192,0,126,0,224,15,192,0,126,0,3,240,0,0,1,248,3,240,0,0,1,248,3,240,0,0,1,248,
  // 0x53d6  取
  214,83,45,45,14,48,0,250,255,255,255,224,0,0,255,255,255,224,0,0,255,255,255,224,0,0,3,128,56,255,255,192,3,128,56,255,255,192,3,128,56,255,255,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,129,255,227,142,0,3,129,255,227,142,0,3,129,255,227,142,0,255,254,56,0,112,0,255,254,56,0,112,0,255,254,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,0,0,56,3,142,0,0,0,56,3,142,0,0,0,56,3,142,0,0,0,56,28,1,192,0,0,56,28,1,192,0,0,56,28,1,192,0,0,56,224,0,56,0,0,56,224,0,56,0,0,56,224,0,56,
  // 0x53d8  变
  216,83,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,113,192,28,112,0,0,113,192,28,112,0,0,113,192,28,112,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,240,0,3,255,255,255,240,0,3,255,255,255,240,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,126,0,3,240,0,0,126,0,3,240,0,0,126,0,3,240,0,255,128,0,0,15,248,255,128,0,0,15,248,255,128,0,0,15,248,
  // 0x53f0  台
  240,83,39,48,240,48,3,250,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,28,0,0,0,14,28,0,0,0,14,28,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,
  // 0x5403  吃
  3,84,42,45,14,48,3,253,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,240,56,0,0,0,255,240,56,0,0,0,255,240,56,0,0,0,224,112,63,255,255,192,224,112,63,255,255,192,224,112,63,255,255,192,224,113,192,0,0,0,224,113,192,0,0,0,224,113,192,0,0,0,224,126,0,0,0,0,224,126,0,0,0,0,224,126,0,0,0,0,224,112,63,255,240,0,224,112,63,255,240,0,224,112,63,255,240,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,252,0,0,224,112,0,252,0,0,224,112,0,252,0,0,255,240,7,0,0,0,255,240,7,0,0,0,255,240,7,0,0,0,224,112,56,0,0,0,224,112,56,0,0,0,224,112,56,0,0,0,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,0,63,255,255,192,0,0,63,255,255,192,0,0,63,255,255,192,
  // 0x5408  合
  8,84,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,3,240,0,0,126,0,3,240,0,0,126,0,3,240,0,0,126,0,252,15,255,255,129,248,252,15,255,255,129,248,252,15,255,255,129,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x540d  名
  13,84,39,48,240,48,0,250,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,255,255,240,0,1,255,255,240,0,1,255,255,240,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,113,192,3,128,0,113,192,3,128,0,113,192,3,128,31,128,56,28,0,31,128,56,28,0,31,128,56,28,0,0,0,56,224,0,0,0,56,224,0,0,0,56,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,1,248,0,0,0,1,248,0,0,0,1,248,0,0,0,127,255,255,254,0,127,255,255,254,0,127,255,255,254,255,142,0,0,14,255,142,0,0,14,255,142,0,0,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,15,255,255,254,0,15,255,255,254,0,15,255,255,254,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,
  // 0x540e  后
  14,84,45,48,32,48,0,250,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,255,254,0,0,0,0,255,254,0,0,0,0,255,254,0,0,127,255,0,0,0,0,127,255,0,0,0,0,127,255,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,127,255,255,255,248,0,127,255,255,255,248,0,127,255,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,113,255,255,254,0,0,113,255,255,254,0,0,113,255,255,254,0,0,113,192,0,14,0,0,113,192,0,14,0,0,113,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,224,1,255,255,254,0,224,1,255,255,254,0,224,1,255,255,254,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,
  // 0x5411  向
  17,84,39,48,240,48,3,250,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,15,255,224,14,224,15,255,224,14,224,15,255,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,15,255,224,14,224,15,255,224,14,224,15,255,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x5426  否
  38,84,45,45,14,48,0,250,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,1,199,31,128,0,0,1,199,31,128,0,0,1,199,31,128,0,0,14,7,0,126,0,0,14,7,0,126,0,0,14,7,0,126,0,3,240,7,0,1,192,3,240,7,0,1,192,3,240,7,0,1,192,252,0,7,0,0,56,252,0,7,0,0,56,252,0,7,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x542f  启
  47,84,42,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,127,255,255,255,192,0,127,255,255,255,192,0,127,255,255,255,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,127,255,255,255,192,0,127,255,255,255,192,0,127,255,255,255,192,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,224,1,255,255,255,192,224,1,255,255,255,192,224,1,255,255,255,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,
  // 0x544a  告
  74,84,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,127,255,255,254,0,0,127,255,255,254,0,0,127,255,255,254,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,28,0,7,0,0,0,28,0,7,0,0,0,28,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x5468  周
  104,84,39,45,225,48,0,250,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,143,255,255,142,3,143,255,255,142,3,143,255,255,142,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,0,0,14,3,128,0,0,14,3,128,0,0,14,3,129,255,252,14,3,129,255,252,14,3,129,255,252,14,3,129,192,28,14,3,129,192,28,14,3,129,192,28,14,3,129,192,28,14,3,129,192,28,14,3,129,192,28,14,3,129,255,252,14,3,129,255,252,14,3,129,255,252,14,28,0,0,0,14,28,0,0,0,14,28,0,0,0,14,28,0,0,3,142,28,0,0,3,142,28,0,0,3,142,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x547d  命
  125,84,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,3,241,255,252,126,0,3,241,255,252,126,0,3,241,255,252,126,0,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,248,255,254,0,3,255,248,255,254,0,3,255,248,255,254,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,255,248,227,142,0,3,255,248,227,142,0,3,255,248,227,142,0,3,128,56,224,112,0,3,128,56,224,112,0,3,128,56,224,112,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,
  // 0x548c  和
  140,84,42,48,32,48,0,250,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,15,248,0,0,0,0,15,248,0,0,0,0,15,248,0,0,0,31,254,0,0,0,0,31,254,0,0,0,0,31,254,0,0,0,0,0,14,0,31,255,192,0,14,0,31,255,192,0,14,0,31,255,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,255,255,255,28,1,192,255,255,255,28,1,192,255,255,255,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,126,0,28,1,192,0,126,0,28,1,192,0,126,0,28,1,192,0,127,192,28,1,192,0,127,192,28,1,192,0,127,192,28,1,192,3,142,56,28,1,192,3,142,56,28,1,192,3,142,56,28,1,192,3,142,56,28,1,192,3,142,56,28,1,192,3,142,56,28,1,192,28,14,0,28,1,192,28,14,0,28,1,192,28,14,0,28,1,192,224,14,0,31,255,192,224,14,0,31,255,192,224,14,0,31,255,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,
  // 0x54cd  响
  205,84,39,48,240,48,3,250,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,255,240,7,0,0,255,240,7,0,0,255,240,7,0,0,224,113,255,255,254,224,113,255,255,254,224,113,255,255,254,224,113,192,0,14,224,113,192,0,14,224,113,192,0,14,224,113,192,0,14,224,113,192,0,14,224,113,192,0,14,224,113,199,255,142,224,113,199,255,142,224,113,199,255,142,224,113,199,3,142,224,113,199,3,142,224,113,199,3,142,224,113,199,3,142,224,113,199,3,142,224,113,199,3,142,224,113,199,3,142,224,113,199,3,142,224,113,199,3,142,255,241,199,3,142,255,241,199,3,142,255,241,199,3,142,224,113,199,255,142,224,113,199,255,142,224,113,199,255,142,0,1,192,0,14,0,1,192,0,14,0,1,192,0,14,0,1,192,0,14,0,1,192,0,14,0,1,192,0,14,0,1,192,3,142,0,1,192,3,142,0,1,192,3,142,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,
  // 0x55b7  喷
  183,85,42,48,32,48,3,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,255,240,0,28,0,0,255,240,0,28,0,0,255,240,0,28,0,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,113,255,255,255,192,224,113,255,255,255,192,224,113,255,255,255,192,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,63,255,254,0,224,112,63,255,254,0,224,112,63,255,254,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,56,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,255,240,56,28,14,0,255,240,56,28,14,0,255,240,56,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,0,0,56,28,14,0,0,0,56,28,14,0,0,0,56,28,14,0,0,0,0,227,128,0,0,0,0,227,128,0,0,0,0,227,128,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,0,1,248,0,14,0,0,1,248,0,14,0,0,1,248,0,14,0,
  // 0x5634  嘴
  52,86,45,48,32,48,0,250,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,0,0,56,224,113,192,0,0,56,224,113,192,0,0,56,224,113,192,255,240,56,252,126,0,255,240,56,252,126,0,255,240,56,252,126,0,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,252,112,56,224,112,56,252,112,56,224,112,56,252,112,56,224,113,255,0,15,248,224,113,255,0,15,248,224,113,255,0,15,248,224,112,7,255,240,0,224,112,7,255,240,0,224,112,7,255,240,0,224,112,56,0,112,0,224,112,56,0,112,0,224,112,56,0,112,0,224,113,255,255,255,192,224,113,255,255,255,192,224,113,255,255,255,192,224,126,56,28,1,192,224,126,56,28,1,192,224,126,56,28,1,192,255,240,63,255,255,192,255,240,63,255,255,192,255,240,63,255,255,192,224,112,56,28,1,192,224,112,56,28,1,192,224,112,56,28,1,192,0,0,63,255,255,192,0,0,63,255,255,192,0,0,63,255,255,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,28,113,192,0,1,192,28,113,192,0,1,192,28,113,192,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,
  // 0x5668  器
  104,86,45,45,14,48,0,250,3,255,248,31,255,192,3,255,248,31,255,192,3,255,248,31,255,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,255,248,31,255,192,3,255,248,31,255,192,3,255,248,31,255,192,0,0,7,3,128,0,0,0,7,3,128,0,0,0,7,3,128,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,15,192,31,128,0,0,15,192,31,128,0,0,15,192,31,128,0,3,240,0,0,126,0,3,240,0,0,126,0,3,240,0,0,126,0,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,3,255,248,31,255,192,3,255,248,31,255,192,3,255,248,31,255,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,255,248,31,255,192,3,255,248,31,255,192,3,255,248,31,255,192,
  // 0x5674  噴
  116,86,42,48,32,48,3,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,255,240,0,28,0,0,255,240,0,28,0,0,255,240,0,28,0,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,113,255,255,255,192,224,113,255,255,255,192,224,113,255,255,255,192,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,63,255,254,0,224,112,63,255,254,0,224,112,63,255,254,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,63,255,254,0,224,112,63,255,254,0,224,112,63,255,254,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,255,240,63,255,254,0,255,240,63,255,254,0,255,240,63,255,254,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,
  // 0x56de  回
  222,86,36,42,210,48,6,253,255,255,255,255,240,255,255,255,255,240,255,255,255,255,240,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,127,255,224,112,224,127,255,224,112,224,127,255,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,112,0,224,112,224,127,255,224,112,224,127,255,224,112,224,127,255,224,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,255,255,255,255,240,255,255,255,255,240,255,255,255,255,240,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x56e0  因
  224,86,39,45,225,48,3,250,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,227,255,255,255,142,227,255,255,255,142,227,255,255,255,142,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,1,192,224,14,224,1,192,224,14,224,1,192,224,14,224,14,0,28,14,224,14,0,28,14,224,14,0,28,14,224,112,0,3,142,224,112,0,3,142,224,112,0,3,142,227,128,0,3,142,227,128,0,3,142,227,128,0,3,142,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,
  // 0x56fa  固
  250,86,39,45,225,48,3,250,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,227,255,255,255,142,227,255,255,255,142,227,255,255,255,142,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,127,255,252,14,224,127,255,252,14,224,127,255,252,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,127,255,252,14,224,127,255,252,14,224,127,255,252,14,224,112,0,28,14,224,112,0,28,14,224,112,0,28,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,
  // 0x56fe  图
  254,86,39,45,225,48,3,250,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,15,255,252,14,224,15,255,252,14,224,15,255,252,14,224,126,0,224,14,224,126,0,224,14,224,126,0,224,14,227,129,199,0,14,227,129,199,0,14,227,129,199,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,15,199,224,14,224,15,199,224,14,224,15,199,224,14,255,240,0,31,254,255,240,0,31,254,255,240,0,31,254,224,1,248,0,14,224,1,248,0,14,224,1,248,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,15,192,0,14,224,15,192,0,14,224,15,192,0,14,224,0,63,0,14,224,0,63,0,14,224,0,63,0,14,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,
  // 0x5728  在
  40,87,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,240,0,28,0,0,3,240,0,28,0,0,3,240,0,28,0,0,28,113,255,255,255,192,28,113,255,255,255,192,28,113,255,255,255,192,224,112,0,28,0,0,224,112,0,28,0,0,224,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,127,255,255,255,248,0,127,255,255,255,248,0,127,255,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x574f  坏
  79,87,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,31,142,0,0,112,0,31,142,0,0,112,0,31,142,0,0,112,0,31,129,192,0,112,0,31,129,192,0,112,0,31,129,192,0,112,0,227,129,192,0,112,0,227,129,192,0,112,0,227,129,192,0,127,199,3,128,56,0,127,199,3,128,56,0,127,199,3,128,56,255,128,56,3,128,56,255,128,56,3,128,56,255,128,56,3,128,56,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0x5757  块
  87,87,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,255,255,192,28,1,192,255,255,192,28,1,192,255,255,192,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,127,192,227,128,0,0,127,192,227,128,0,0,127,192,227,128,0,255,128,7,0,112,0,255,128,7,0,112,0,255,128,7,0,112,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,
  // 0x578b  型
  139,87,45,45,14,48,0,253,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,31,255,255,224,1,192,31,255,255,224,1,192,31,255,255,224,1,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,255,255,255,227,129,192,255,255,255,227,129,192,255,255,255,227,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,3,128,56,0,1,192,3,128,56,0,1,192,3,128,56,0,1,192,3,128,56,0,113,192,3,128,56,0,113,192,3,128,56,0,113,192,28,0,7,0,14,0,28,0,7,0,14,0,28,0,7,0,14,0,224,0,7,0,0,0,224,0,7,0,0,0,224,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x57ab  垫
  171,87,45,45,14,48,0,253,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,31,255,199,255,254,0,31,255,199,255,254,0,31,255,199,255,254,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,15,192,28,14,0,0,15,192,28,14,0,0,15,192,28,14,0,0,126,7,252,14,0,0,126,7,252,14,0,0,126,7,252,14,0,31,142,0,28,14,56,31,142,0,28,14,56,31,142,0,28,14,56,0,14,0,227,142,56,0,14,0,227,142,56,0,14,0,227,142,56,3,142,0,224,1,248,3,142,0,224,1,248,3,142,0,224,1,248,0,112,7,0,0,56,0,112,7,0,0,56,0,112,7,0,0,56,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x586b  填
  107,88,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,255,254,56,0,14,0,255,254,56,0,14,0,255,254,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,254,56,0,14,0,3,254,56,0,14,0,3,254,56,0,14,0,255,143,255,255,255,248,255,143,255,255,255,248,255,143,255,255,255,248,28,0,7,0,112,0,28,0,7,0,112,0,28,0,7,0,112,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,
  // 0x58f3  壳
  243,88,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,0,15,255,255,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,252,0,0,0,127,248,252,0,0,0,127,248,252,0,0,0,127,248,
  // 0x5907  备
  7,89,45,48,32,48,0,250,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,126,0,3,128,0,0,126,0,3,128,0,0,126,0,3,128,0,31,129,192,28,0,0,31,129,192,28,0,0,31,129,192,28,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,127,192,31,240,0,0,127,192,31,240,0,0,127,192,31,240,0,255,128,0,0,15,248,255,128,0,0,15,248,255,128,0,0,15,248,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x590d  复
  13,89,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,127,255,255,255,192,0,127,255,255,255,192,0,127,255,255,255,192,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,28,127,255,255,240,0,28,127,255,255,240,0,28,127,255,255,240,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,126,0,3,128,0,0,126,0,3,128,0,0,126,0,3,128,0,31,129,192,28,0,0,31,129,192,28,0,0,31,129,192,28,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,127,192,31,240,0,0,127,192,31,240,0,0,127,192,31,240,0,255,128,0,0,15,248,255,128,0,0,15,248,255,128,0,0,15,248,
  // 0x5916  外
  22,89,42,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,255,248,28,0,0,3,255,248,28,0,0,3,255,248,28,0,0,3,128,56,31,128,0,3,128,56,31,128,0,3,128,56,31,128,0,28,0,56,28,112,0,28,0,56,28,112,0,28,0,56,28,112,0,28,0,56,28,14,0,28,0,56,28,14,0,28,0,56,28,14,0,227,129,192,28,1,192,227,129,192,28,1,192,227,129,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,
  // 0x591a  多
  26,89,36,48,240,48,3,250,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,15,255,255,128,0,15,255,255,128,0,15,255,255,128,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,31,240,0,224,0,31,240,0,224,0,31,240,0,224,0,0,14,7,0,0,0,14,7,0,0,0,14,7,0,0,0,1,248,224,0,0,1,248,224,0,0,1,248,224,0,0,126,7,0,0,0,126,7,0,0,0,126,7,0,0,255,128,63,255,240,255,128,63,255,240,255,128,63,255,240,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,126,0,3,128,0,126,0,3,128,0,126,0,3,128,31,129,192,28,0,31,129,192,28,0,31,129,192,28,0,0,0,56,224,0,0,0,56,224,0,0,0,56,224,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,127,192,0,0,0,127,192,0,0,0,127,192,0,0,255,128,0,0,0,255,128,0,0,0,255,128,0,0,0,
  // 0x5927  大
  39,89,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,
  // 0x5929  天
  41,89,45,45,14,48,0,250,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,
  // 0x592a  太
  42,89,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,56,3,128,0,0,14,56,3,128,0,0,14,56,3,128,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,
  // 0x5931  失
  49,89,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,127,255,255,254,0,0,127,255,255,254,0,0,127,255,255,254,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,28,0,7,0,0,0,28,0,7,0,0,0,28,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,128,0,0,15,192,31,128,0,0,15,192,31,128,0,0,15,192,
  // 0x5934  头
  52,89,45,48,32,48,0,250,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,28,0,0,0,0,7,28,0,0,0,0,7,28,0,0,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,3,128,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,3,240,0,0,1,192,3,240,0,0,1,192,3,240,0,0,1,192,252,0,0,0,1,192,252,0,0,0,1,192,252,0,0,0,1,192,
  // 0x597d  好
  125,89,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,199,255,255,248,3,129,199,255,255,248,3,129,199,255,255,248,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,224,1,192,227,128,0,224,1,192,227,128,0,224,1,192,227,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x59cb  始
  203,89,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,255,255,192,28,14,0,255,255,192,28,14,0,255,255,192,28,14,0,3,129,192,224,1,192,3,129,192,224,1,192,3,129,192,224,1,192,3,129,199,255,255,248,3,129,199,255,255,248,3,129,199,255,255,248,3,129,192,224,0,56,3,129,192,224,0,56,3,129,192,224,0,56,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,28,14,0,255,255,192,28,14,0,255,255,192,28,14,0,255,255,192,3,142,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,224,0,0,255,255,192,224,0,0,255,255,192,224,0,0,255,255,192,0,0,0,224,1,192,0,0,0,224,1,192,0,0,0,224,1,192,
  // 0x5b50  子
  80,91,45,45,14,48,0,250,31,255,255,255,254,0,31,255,255,255,254,0,31,255,255,255,254,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x5b58  存
  88,91,45,48,32,48,0,250,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,240,0,3,128,0,3,240,0,3,128,0,3,240,0,3,128,0,28,112,0,28,0,0,28,112,0,28,0,0,28,112,0,28,0,0,224,113,255,255,255,248,224,113,255,255,255,248,224,113,255,255,255,248,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,7,28,0,0,0,112,7,28,0,0,0,112,7,28,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,
  // 0x5b89  安
  137,91,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,255,192,3,255,255,255,255,192,3,255,255,255,255,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,126,0,28,0,0,0,126,0,28,0,0,0,126,0,28,0,0,0,1,248,28,0,0,0,1,248,28,0,0,0,1,248,28,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,56,31,128,0,0,0,56,31,128,0,0,0,56,31,128,0,0,15,192,0,112,0,0,15,192,0,112,0,0,15,192,0,112,0,31,240,0,0,14,0,31,240,0,0,14,0,31,240,0,0,14,0,
  // 0x5b8c  完
  140,91,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,31,128,0,3,255,192,31,128,0,3,255,192,31,128,0,3,255,192,
  // 0x5b9a  定
  154,91,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,3,142,7,0,0,0,3,142,7,0,0,0,3,142,7,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,
  // 0x5ba2  客
  162,91,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,14,0,0,1,192,224,14,0,0,1,192,224,14,0,0,1,192,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,143,192,28,0,0,3,143,192,28,0,0,3,143,192,28,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,127,192,31,240,0,0,127,192,31,240,0,0,127,192,31,240,0,255,128,0,0,15,248,255,128,0,0,15,248,255,128,0,0,15,248,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x5bab  宫
  171,91,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,
  // 0x5bf9  对
  249,91,42,48,32,48,3,250,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,0,1,199,255,255,192,0,1,199,255,255,192,0,1,199,255,255,192,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,3,142,7,3,128,0,3,142,7,3,128,0,3,142,7,3,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,0,0,0,227,128,0,0,0,0,227,128,0,0,0,0,227,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x5c06  将
  6,92,45,48,32,48,0,250,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,255,254,0,0,14,0,255,254,0,0,14,0,255,254,0,0,14,7,0,14,0,0,14,7,0,14,0,0,14,7,0,14,0,28,14,56,0,112,0,28,14,56,0,112,0,28,14,56,0,112,0,3,142,0,227,128,0,3,142,0,227,128,0,3,142,0,227,128,0,3,142,0,28,0,0,3,142,0,28,0,0,3,142,0,28,0,0,0,14,0,224,112,0,0,14,0,224,112,0,0,14,0,224,112,0,0,14,63,0,112,0,0,14,63,0,112,0,0,14,63,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,3,142,63,255,255,248,3,142,63,255,255,248,3,142,63,255,255,248,252,14,0,0,112,0,252,14,0,0,112,0,252,14,0,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,0,224,112,0,0,14,0,224,112,0,0,14,0,224,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,28,112,0,0,14,0,28,112,0,0,14,0,28,112,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,
  // 0x5c0f  小
  15,92,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,0,56,3,128,7,0,0,56,3,128,7,0,0,56,28,0,7,0,0,56,28,0,7,0,0,56,28,0,7,0,0,56,224,0,7,0,0,56,224,0,7,0,0,56,224,0,7,0,0,56,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x5c31  就
  49,92,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,255,255,248,28,14,0,255,255,248,28,14,0,255,255,248,28,14,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,31,255,199,255,255,248,31,255,199,255,255,248,31,255,199,255,255,248,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,31,255,192,28,112,0,31,255,192,28,112,0,31,255,192,28,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,28,113,192,224,112,0,28,113,192,224,112,0,28,113,192,224,112,0,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,0,112,7,0,112,56,0,112,7,0,112,56,0,112,7,0,112,56,28,112,7,0,15,248,28,112,7,0,15,248,28,112,7,0,15,248,3,128,56,0,0,0,3,128,56,0,0,0,3,128,56,0,0,0,
  // 0x5c4f  屏
  79,92,42,45,14,48,0,250,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,143,255,255,254,0,3,143,255,255,254,0,3,143,255,255,254,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,255,255,255,255,192,3,255,255,255,255,192,3,255,255,255,255,192,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,
  // 0x5de5  工
  229,93,45,36,216,48,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x5dee  差
  238,93,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,113,255,255,254,0,0,113,255,255,254,0,0,113,255,255,254,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,0,127,255,255,255,192,0,127,255,255,255,192,0,127,255,255,255,192,
  // 0x5df2  已
  242,93,36,42,210,48,6,253,255,255,255,252,0,255,255,255,252,0,255,255,255,252,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,255,255,255,252,0,255,255,255,252,0,255,255,255,252,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,
  // 0x5e73  平
  115,94,45,45,14,48,0,250,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x5e76  并
  118,94,45,48,32,48,0,250,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,
  // 0x5e8a  床
  138,94,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,3,255,255,255,255,248,3,255,255,255,255,248,3,255,255,255,255,248,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,143,255,255,255,192,3,143,255,255,255,192,3,143,255,255,255,192,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,7,252,0,0,3,128,7,252,0,0,3,128,7,252,0,0,3,128,56,227,128,0,3,128,56,227,128,0,3,128,56,227,128,0,3,128,56,227,128,0,3,128,56,227,128,0,3,128,56,227,128,0,3,129,192,224,112,0,3,129,192,224,112,0,3,129,192,224,112,0,28,14,0,224,14,0,28,14,0,224,14,0,28,14,0,224,14,0,28,112,0,224,1,248,28,112,0,224,1,248,28,112,0,224,1,248,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,
  // 0x5e94  应
  148,94,45,45,14,48,0,253,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,3,255,255,255,255,248,3,255,255,255,255,248,3,255,255,255,255,248,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,3,142,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,3,129,192,224,1,192,3,129,192,224,1,192,3,129,192,224,1,192,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,224,127,255,255,255,248,224,127,255,255,255,248,224,127,255,255,255,248,
  // 0x5e9f  废
  159,94,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,3,255,255,255,255,248,3,255,255,255,255,248,3,255,255,255,255,248,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,129,192,224,112,0,3,129,192,224,112,0,3,129,192,224,112,0,3,142,0,224,14,0,3,142,0,224,14,0,3,142,0,224,14,0,3,143,255,255,255,248,3,143,255,255,255,248,3,143,255,255,255,248,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,255,255,192,3,128,7,255,255,192,3,128,7,255,255,192,3,128,56,224,1,192,3,128,56,224,1,192,3,128,56,224,1,192,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,28,14,0,28,112,0,28,14,0,28,112,0,28,14,0,28,112,0,28,112,7,224,14,0,28,112,7,224,14,0,28,112,7,224,14,0,224,1,248,0,1,248,224,1,248,0,1,248,224,1,248,0,1,248,
  // 0x5ea6  度
  166,94,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,3,255,255,255,255,248,3,255,255,255,255,248,3,255,255,255,255,248,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,255,255,255,255,192,3,255,255,255,255,192,3,255,255,255,255,192,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,63,255,128,0,3,128,63,255,128,0,3,128,63,255,128,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,143,255,255,240,0,3,143,255,255,240,0,3,143,255,255,240,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,56,3,128,0,28,0,7,252,0,0,28,0,7,252,0,0,28,0,7,252,0,0,224,1,248,3,240,0,224,1,248,3,240,0,224,1,248,3,240,0,3,254,0,0,15,248,3,254,0,0,15,248,3,254,0,0,15,248,
  // 0x5f00  开
  0,95,45,45,14,48,0,250,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,
  // 0x5f03  弃
  3,95,42,48,32,48,3,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,254,0,31,255,255,255,254,0,31,255,255,255,254,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,255,255,255,240,0,3,255,255,255,240,0,3,255,255,255,240,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,255,255,255,255,255,192,255,255,255,255,255,192,255,255,255,255,255,192,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,
  // 0x5f0f  式
  15,95,45,48,32,48,0,250,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,255,248,28,0,0,3,255,248,28,0,0,3,255,248,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,15,255,0,112,56,0,15,255,0,112,56,0,15,255,0,112,56,31,254,0,0,14,56,31,254,0,0,14,56,31,254,0,0,14,56,3,128,0,0,1,248,3,128,0,0,1,248,3,128,0,0,1,248,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,
  // 0x5f15  引
  21,95,36,48,240,48,3,250,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,248,0,112,255,255,248,0,112,255,255,248,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,31,255,248,0,112,31,255,248,0,112,31,255,248,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,255,255,248,0,112,255,255,248,0,112,255,255,248,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,113,192,0,112,0,113,192,0,112,0,113,192,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,
  // 0x5f39  弹
  57,95,45,48,32,48,0,250,0,0,7,0,1,192,0,0,7,0,1,192,0,0,7,0,1,192,255,254,0,224,14,0,255,254,0,224,14,0,255,254,0,224,14,0,0,14,0,28,112,0,0,14,0,28,112,0,0,14,0,28,112,0,0,14,7,255,255,192,0,14,7,255,255,192,0,14,7,255,255,192,0,14,7,3,129,192,0,14,7,3,129,192,0,14,7,3,129,192,31,254,7,3,129,192,31,254,7,3,129,192,31,254,7,3,129,192,28,0,7,255,255,192,28,0,7,255,255,192,28,0,7,255,255,192,28,0,7,3,129,192,28,0,7,3,129,192,28,0,7,3,129,192,28,0,7,3,129,192,28,0,7,3,129,192,28,0,7,3,129,192,31,254,7,255,255,192,31,254,7,255,255,192,31,254,7,255,255,192,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,63,255,255,248,0,14,63,255,255,248,0,14,63,255,255,248,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,
  // 0x5f52  归
  82,95,39,48,240,48,3,250,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,224,113,255,255,254,224,113,255,255,254,224,113,255,255,254,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,63,255,254,224,112,63,255,254,224,112,63,255,254,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,224,112,0,0,14,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,3,128,0,0,14,3,128,0,0,14,3,128,0,0,14,3,129,255,255,254,3,129,255,255,254,3,129,255,255,254,28,0,0,0,14,28,0,0,0,14,28,0,0,0,14,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,
  // 0x5f84  径
  132,95,45,48,32,48,0,250,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,63,255,254,0,0,14,63,255,254,0,0,14,63,255,254,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,28,14,0,31,128,0,28,14,0,31,128,0,28,14,0,31,128,0,0,14,0,224,126,0,0,14,0,224,126,0,0,14,0,224,126,0,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,3,241,248,0,0,56,3,241,248,0,0,56,3,241,248,0,0,56,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,224,112,63,255,255,192,224,112,63,255,255,192,224,112,63,255,255,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x5f85  待
  133,95,45,48,32,48,0,250,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,63,255,255,192,3,128,63,255,255,192,3,128,63,255,255,192,28,14,0,28,0,0,28,14,0,28,0,0,28,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,3,240,0,0,112,0,3,240,0,0,112,0,3,240,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,224,113,255,255,255,248,224,113,255,255,255,248,224,113,255,255,255,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,
  // 0x5faa  循
  170,95,45,48,32,48,0,250,0,112,0,3,255,192,0,112,0,3,255,192,0,112,0,3,255,192,0,113,255,255,128,0,0,113,255,255,128,0,0,113,255,255,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,224,113,255,255,255,248,224,113,255,255,255,248,224,113,255,255,255,248,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,3,129,199,255,255,192,3,129,199,255,255,192,3,129,199,255,255,192,31,129,199,0,1,192,31,129,199,0,1,192,31,129,199,0,1,192,227,129,199,0,1,192,227,129,199,0,1,192,227,129,199,0,1,192,3,129,199,255,255,192,3,129,199,255,255,192,3,129,199,255,255,192,3,129,199,0,1,192,3,129,199,0,1,192,3,129,199,0,1,192,3,129,199,255,255,192,3,129,199,255,255,192,3,129,199,255,255,192,3,142,7,0,1,192,3,142,7,0,1,192,3,142,7,0,1,192,3,142,7,0,1,192,3,142,7,0,1,192,3,142,7,0,1,192,3,240,7,255,255,192,3,240,7,255,255,192,3,240,7,255,255,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,
  // 0x5fae  微
  174,95,45,48,32,48,0,250,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,113,199,28,14,0,0,113,199,28,14,0,0,113,199,28,14,0,3,129,199,28,14,0,3,129,199,28,14,0,3,129,199,28,14,0,28,1,199,28,112,0,28,1,199,28,112,0,28,1,199,28,112,0,224,113,255,252,127,248,224,113,255,252,127,248,224,113,255,252,127,248,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,31,143,255,252,113,192,31,143,255,252,113,192,31,143,255,252,113,192,227,128,0,0,113,192,227,128,0,0,113,192,227,128,0,0,113,192,3,129,255,224,113,192,3,129,255,224,113,192,3,129,255,224,113,192,3,129,192,224,113,192,3,129,192,224,113,192,3,129,192,224,113,192,3,129,192,227,142,0,3,129,192,227,142,0,3,129,192,227,142,0,3,129,192,252,14,0,3,129,192,252,14,0,3,129,192,252,14,0,3,129,192,224,113,192,3,129,192,224,113,192,3,129,192,224,113,192,3,142,0,0,113,192,3,142,0,0,113,192,3,142,0,0,113,192,3,240,0,3,128,56,3,240,0,3,128,56,3,240,0,3,128,56,
  // 0x5fc3  心
  195,95,45,42,252,48,0,253,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,0,56,3,129,192,0,0,56,3,129,192,0,0,56,28,1,192,0,0,56,28,1,192,0,0,56,28,1,192,0,0,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,0,63,255,240,0,0,0,63,255,240,0,0,0,63,255,240,0,
  // 0x5ffd  忽
  253,95,45,45,14,48,0,253,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,127,255,255,254,0,0,127,255,255,254,0,0,127,255,255,254,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,28,1,192,224,14,0,28,1,192,224,14,0,28,1,192,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,14,0,224,1,192,0,14,0,224,1,192,0,14,0,224,1,192,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,224,1,255,255,240,0,224,1,255,255,240,0,224,1,255,255,240,0,
  // 0x6027  性
  39,96,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,126,7,255,255,192,0,126,7,255,255,192,0,126,7,255,255,192,28,113,199,3,128,0,28,113,199,3,128,0,28,113,199,3,128,0,28,112,56,3,128,0,28,112,56,3,128,0,28,112,56,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x603b  总
  59,96,45,45,14,48,0,253,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,14,0,224,1,192,0,14,0,224,1,192,0,14,0,224,1,192,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,224,1,255,255,240,0,224,1,255,255,240,0,224,1,255,255,240,0,
  // 0x6062  恢
  98,96,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,126,0,224,0,0,0,126,0,224,0,0,0,126,0,224,0,0,28,113,192,224,112,0,28,113,192,224,112,0,28,113,192,224,112,0,28,112,0,224,112,0,28,112,0,224,112,0,28,112,0,224,112,0,28,112,7,0,112,56,28,112,7,0,112,56,28,112,7,0,112,56,224,112,7,28,112,56,224,112,7,28,112,56,224,112,7,28,112,56,0,112,7,28,113,192,0,112,7,28,113,192,0,112,7,28,113,192,0,112,56,224,112,0,0,112,56,224,112,0,0,112,56,224,112,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,0,113,192,3,142,0,0,113,192,3,142,0,0,113,192,3,142,0,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,7,0,0,56,0,112,7,0,0,56,0,112,7,0,0,56,
  // 0x606f  息
  111,96,45,45,14,48,0,253,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,14,0,224,1,192,0,14,0,224,1,192,0,14,0,224,1,192,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,224,1,255,255,240,0,224,1,255,255,240,0,224,1,255,255,240,0,
  // 0x611f  感
  31,97,45,48,32,48,0,250,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,3,255,255,255,255,248,3,255,255,255,255,248,3,255,255,255,255,248,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,143,255,227,129,192,3,143,255,227,129,192,3,143,255,227,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,143,255,227,142,0,3,143,255,227,142,0,3,143,255,227,142,0,3,142,0,224,126,0,3,142,0,224,126,0,3,142,0,224,126,0,3,142,0,224,112,56,3,142,0,224,112,56,3,142,0,224,112,56,28,15,255,227,142,56,28,15,255,227,142,56,28,15,255,227,142,56,28,0,0,28,1,248,28,0,0,28,1,248,28,0,0,28,1,248,224,0,0,224,0,56,224,0,0,224,0,56,224,0,0,224,0,56,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,28,14,0,224,1,192,28,14,0,224,1,192,28,14,0,224,1,192,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,224,1,255,255,240,56,224,1,255,255,240,56,224,1,255,255,240,56,
  // 0x620f  戏
  15,98,42,48,32,48,3,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,14,0,255,255,192,28,14,0,255,255,192,28,14,0,255,255,192,28,14,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,31,255,192,0,1,192,31,255,192,0,1,192,31,255,192,28,14,63,252,0,0,28,14,63,252,0,0,28,14,63,252,0,0,3,142,0,28,14,0,3,142,0,28,14,0,3,142,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,3,142,0,28,112,0,3,142,0,28,112,0,3,142,0,28,112,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,28,1,192,31,129,192,28,1,192,31,129,192,28,1,192,31,129,192,224,0,0,224,113,192,224,0,0,224,113,192,224,0,0,224,113,192,0,0,7,0,15,192,0,0,7,0,15,192,0,0,7,0,15,192,0,0,56,0,1,192,0,0,56,0,1,192,0,0,56,0,1,192,
  // 0x6210  成
  16,98,45,48,32,48,0,250,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,255,255,255,255,248,3,255,255,255,255,248,3,255,255,255,255,248,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,142,56,3,240,56,3,142,56,3,240,56,3,142,56,3,240,56,28,1,192,28,14,56,28,1,192,28,14,56,28,1,192,28,14,56,28,0,0,224,1,248,28,0,0,224,1,248,28,0,0,224,1,248,224,0,7,0,0,56,224,0,7,0,0,56,224,0,7,0,0,56,
  // 0x6237  户
  55,98,36,48,240,48,3,250,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,3,255,255,255,240,3,255,255,255,240,3,255,255,255,240,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,3,255,255,255,240,3,255,255,255,240,3,255,255,255,240,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,
  // 0x6240  所
  64,98,45,48,32,48,0,250,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,1,255,0,127,192,0,1,255,0,127,192,0,1,255,0,127,192,3,254,0,255,128,0,3,254,0,255,128,0,3,254,0,255,128,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,255,248,224,0,0,3,255,248,224,0,0,3,255,248,224,0,0,3,128,56,255,255,248,3,128,56,255,255,248,3,128,56,255,255,248,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,255,248,224,14,0,3,255,248,224,14,0,3,255,248,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,28,0,7,0,14,0,28,0,7,0,14,0,28,0,7,0,14,0,28,0,7,0,14,0,28,0,7,0,14,0,28,0,7,0,14,0,224,0,56,0,14,0,224,0,56,0,14,0,224,0,56,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,
  // 0x6247  扇
  71,98,42,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,255,192,3,255,255,255,255,192,3,255,255,255,255,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,255,255,255,255,192,3,255,255,255,255,192,3,255,255,255,255,192,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,255,255,31,255,192,3,255,255,31,255,192,3,255,255,31,255,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,3,142,7,3,129,192,3,142,7,3,129,192,3,142,7,3,129,192,3,129,199,0,113,192,3,129,199,0,113,192,3,129,199,0,113,192,28,14,7,3,129,192,28,14,7,3,129,192,28,14,7,3,129,192,28,112,7,28,1,192,28,112,7,28,1,192,28,112,7,28,1,192,224,1,199,0,113,192,224,1,199,0,113,192,224,1,199,0,113,192,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,
  // 0x624b  手
  75,98,45,48,32,48,0,250,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,255,254,0,0,0,0,255,254,0,0,0,0,255,254,0,3,255,255,0,0,0,3,255,255,0,0,0,3,255,255,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x6253  打
  83,98,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,126,0,3,128,0,0,126,0,3,128,0,0,126,0,3,128,0,3,240,0,3,128,0,3,240,0,3,128,0,3,240,0,3,128,0,252,112,0,3,128,0,252,112,0,3,128,0,252,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,28,112,0,227,128,0,28,112,0,227,128,0,28,112,0,227,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,
  // 0x6267  执
  103,98,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,255,255,199,255,254,0,255,255,199,255,254,0,255,255,199,255,254,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,113,192,28,14,0,0,113,192,28,14,0,0,113,192,28,14,0,0,126,7,28,14,0,0,126,7,28,14,0,0,126,7,28,14,0,3,240,0,252,14,0,3,240,0,252,14,0,3,240,0,252,14,0,252,112,0,28,14,0,252,112,0,28,14,0,252,112,0,28,14,0,0,112,0,227,142,0,0,112,0,227,142,0,0,112,0,227,142,0,0,112,0,227,142,56,0,112,0,227,142,56,0,112,0,227,142,56,0,112,7,0,14,56,0,112,7,0,14,56,0,112,7,0,14,56,28,112,56,0,1,248,28,112,56,0,1,248,28,112,56,0,1,248,3,129,192,0,0,56,3,129,192,0,0,56,3,129,192,0,0,56,
  // 0x6279  批
  121,98,45,48,32,48,0,250,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,56,0,112,7,0,112,56,0,112,7,0,112,56,255,255,199,0,112,56,255,255,199,0,112,56,255,255,199,0,112,56,0,112,7,0,113,192,0,112,7,0,113,192,0,112,7,0,113,192,0,112,7,252,126,0,0,112,7,252,126,0,0,112,7,252,126,0,0,113,199,0,112,0,0,113,199,0,112,0,0,113,199,0,112,0,0,126,7,0,112,0,0,126,7,0,112,0,0,126,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,252,112,7,0,112,0,252,112,7,0,112,0,252,112,7,0,112,0,0,112,7,0,112,56,0,112,7,0,112,56,0,112,7,0,112,56,0,112,7,28,112,56,0,112,7,28,112,56,0,112,7,28,112,56,0,112,7,224,112,56,0,112,7,224,112,56,0,112,7,224,112,56,28,112,7,0,15,248,28,112,7,0,15,248,28,112,7,0,15,248,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,
  // 0x6296  抖
  150,98,45,48,32,48,0,250,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,113,192,224,112,0,0,113,192,224,112,0,0,113,192,224,112,0,0,126,0,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,3,240,0,0,127,248,3,240,0,0,127,248,3,240,0,0,127,248,252,112,63,255,240,0,252,112,63,255,240,0,252,112,63,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,
  // 0x62a5  报
  165,98,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,255,255,199,0,113,192,255,255,199,0,113,192,255,255,199,0,113,192,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,113,199,255,255,192,0,113,199,255,255,192,0,113,199,255,255,192,0,126,7,28,1,192,0,126,7,28,1,192,0,126,7,28,1,192,3,240,7,28,1,192,3,240,7,28,1,192,3,240,7,28,1,192,252,112,7,3,142,0,252,112,7,3,142,0,252,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,28,112,7,28,1,192,28,112,7,28,1,192,28,112,7,28,1,192,3,128,7,224,0,56,3,128,7,224,0,56,3,128,7,224,0,56,
  // 0x62ac  抬
  172,98,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,255,255,199,0,1,192,255,255,199,0,1,192,255,255,199,0,1,192,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,126,7,255,255,192,0,126,7,255,255,192,0,126,7,255,255,192,3,240,7,0,1,192,3,240,7,0,1,192,3,240,7,0,1,192,252,112,7,0,1,192,252,112,7,0,1,192,252,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,28,112,7,255,255,192,28,112,7,255,255,192,28,112,7,255,255,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,
  // 0x62bd  抽
  189,98,42,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,255,255,199,255,255,192,255,255,199,255,255,192,255,255,199,255,255,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,113,199,3,129,192,0,113,199,3,129,192,0,113,199,3,129,192,0,126,7,3,129,192,0,126,7,3,129,192,0,126,7,3,129,192,3,240,7,255,255,192,3,240,7,255,255,192,3,240,7,255,255,192,252,112,7,3,129,192,252,112,7,3,129,192,252,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,28,112,7,255,255,192,28,112,7,255,255,192,28,112,7,255,255,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,
  // 0x62d4  拔
  212,98,45,48,32,48,0,250,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,255,254,63,255,255,248,255,254,63,255,255,248,255,254,63,255,255,248,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,113,192,224,0,0,0,113,192,224,0,0,0,113,192,224,0,0,0,126,0,255,255,192,0,126,0,255,255,192,0,126,0,255,255,192,3,240,7,28,1,192,3,240,7,28,1,192,3,240,7,28,1,192,252,112,7,28,1,192,252,112,7,28,1,192,252,112,7,28,1,192,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,28,113,192,28,1,192,28,113,192,28,1,192,28,113,192,28,1,192,3,128,7,224,0,56,3,128,7,224,0,56,3,128,7,224,0,56,
  // 0x62e9  择
  233,98,45,48,32,48,0,250,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,129,255,255,254,0,3,129,255,255,254,0,3,129,255,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,255,240,0,227,128,0,255,240,0,227,128,0,255,240,0,227,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,7,227,240,0,3,128,7,227,240,0,3,128,7,227,240,0,3,129,248,28,15,248,3,129,248,28,15,248,3,129,248,28,15,248,3,240,0,28,0,0,3,240,0,28,0,0,3,240,0,28,0,0,255,128,63,255,254,0,255,128,63,255,254,0,255,128,63,255,254,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,227,128,0,28,0,0,227,128,0,28,0,0,227,128,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,
  // 0x6309  按
  9,99,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,255,254,56,0,0,56,255,254,56,0,0,56,255,254,56,0,0,56,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,126,63,255,255,248,0,126,63,255,255,248,0,126,63,255,255,248,3,240,0,224,14,0,3,240,0,224,14,0,3,240,0,224,14,0,252,112,0,224,14,0,252,112,0,224,14,0,252,112,0,224,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,0,252,112,0,0,112,0,252,112,0,0,112,0,252,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,28,112,0,224,14,0,28,112,0,224,14,0,28,112,0,224,14,0,3,128,63,0,1,192,3,128,63,0,1,192,3,128,63,0,1,192,
  // 0x6321  挡
  33,99,42,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,7,28,1,192,0,112,7,28,1,192,0,112,7,28,1,192,0,112,7,28,1,192,0,112,7,28,1,192,0,112,7,28,1,192,255,255,199,28,14,0,255,255,199,28,14,0,255,255,199,28,14,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,126,0,0,1,192,0,126,0,0,1,192,0,126,0,0,1,192,3,240,0,0,1,192,3,240,0,0,1,192,3,240,0,0,1,192,252,112,63,255,255,192,252,112,63,255,255,192,252,112,63,255,255,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,28,113,255,255,255,192,28,113,255,255,255,192,28,113,255,255,255,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,
  // 0x6324  挤
  36,99,45,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,255,255,199,0,112,0,255,255,199,0,112,0,255,255,199,0,112,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,113,192,28,0,0,0,113,192,28,0,0,0,113,192,28,0,0,0,126,7,227,240,0,0,126,7,227,240,0,0,126,7,227,240,0,3,241,248,0,15,248,3,241,248,0,15,248,3,241,248,0,15,248,252,112,7,0,112,0,252,112,7,0,112,0,252,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,28,112,56,0,112,0,28,112,56,0,112,0,28,112,56,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,
  // 0x635f  损
  95,99,42,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,255,255,192,255,254,0,255,255,192,255,254,0,255,255,192,255,254,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,113,199,0,1,192,0,113,199,0,1,192,0,113,199,0,1,192,0,126,7,3,129,192,0,126,7,3,129,192,0,126,7,3,129,192,3,240,7,3,129,192,3,240,7,3,129,192,3,240,7,3,129,192,252,112,7,3,129,192,252,112,7,3,129,192,252,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,28,112,0,224,1,192,28,112,0,224,1,192,28,112,0,224,1,192,3,128,63,0,1,192,3,128,63,0,1,192,3,128,63,0,1,192,
  // 0x6362  换
  98,99,45,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,255,254,56,0,112,0,255,254,56,0,112,0,255,254,56,0,112,0,0,113,199,255,255,192,0,113,199,255,255,192,0,113,199,255,255,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,126,7,3,129,192,0,126,7,3,129,192,0,126,7,3,129,192,3,240,7,3,129,192,3,240,7,3,129,192,3,240,7,3,129,192,252,112,7,3,129,192,252,112,7,3,129,192,252,112,7,3,129,192,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,28,112,7,0,1,192,28,112,7,0,1,192,28,112,7,0,1,192,3,129,248,0,0,56,3,129,248,0,0,56,3,129,248,0,0,56,
  // 0x6389  掉
  137,99,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,255,248,0,112,0,3,255,248,0,112,0,3,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,255,255,199,255,255,192,255,255,199,255,255,192,255,255,199,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,113,199,255,255,192,0,113,199,255,255,192,0,113,199,255,255,192,0,126,7,0,1,192,0,126,7,0,1,192,0,126,7,0,1,192,3,240,7,255,255,192,3,240,7,255,255,192,3,240,7,255,255,192,252,112,7,3,129,192,252,112,7,3,129,192,252,112,7,3,129,192,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,
  // 0x63a2  探
  162,99,45,48,32,48,0,250,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,255,254,7,0,112,0,255,254,7,0,112,0,255,254,7,0,112,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,142,0,28,0,0,3,142,0,28,0,0,3,142,0,28,0,0,3,241,255,255,255,192,3,241,255,255,255,192,3,241,255,255,255,192,255,128,0,28,0,0,255,128,0,28,0,0,255,128,0,28,0,0,3,128,0,255,128,0,3,128,0,255,128,0,3,128,0,255,128,0,3,128,7,28,112,0,3,128,7,28,112,0,3,128,7,28,112,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,3,143,192,28,1,248,3,143,192,28,1,248,3,143,192,28,1,248,227,128,0,28,0,0,227,128,0,28,0,0,227,128,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,
  // 0x63a5  接
  165,99,45,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,255,255,199,0,14,0,255,255,199,0,14,0,255,255,199,0,14,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,126,0,28,0,0,0,126,0,28,0,0,0,126,0,28,0,0,3,241,255,255,255,248,3,241,255,255,255,248,3,241,255,255,255,248,252,112,0,224,14,0,252,112,0,224,14,0,252,112,0,224,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,31,128,0,0,112,0,31,128,0,0,112,0,31,128,0,28,112,7,224,126,0,28,112,7,224,126,0,28,112,7,224,126,0,3,129,248,0,1,192,3,129,248,0,1,192,3,129,248,0,1,192,
  // 0x63a7  控
  167,99,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,255,254,56,0,0,56,255,254,56,0,0,56,255,254,56,0,0,56,0,113,192,224,113,192,0,113,192,224,113,192,0,113,192,224,113,192,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,126,56,0,1,192,0,126,56,0,1,192,0,126,56,0,1,192,3,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,252,112,7,255,255,192,252,112,7,255,255,192,252,112,7,255,255,192,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,28,113,255,255,255,248,28,113,255,255,255,248,28,113,255,255,255,248,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,
  // 0x63d0  提
  208,99,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,255,255,199,255,255,192,255,255,199,255,255,192,255,255,199,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,113,199,255,255,192,0,113,199,255,255,192,0,113,199,255,255,192,0,126,0,0,0,0,0,126,0,0,0,0,0,126,0,0,0,0,3,240,63,255,255,248,3,240,63,255,255,248,3,240,63,255,255,248,252,112,0,3,128,0,252,112,0,3,128,0,252,112,0,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,255,192,0,112,7,3,255,192,0,112,7,3,255,192,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,28,112,56,227,128,0,28,112,56,227,128,0,28,112,56,227,128,0,3,129,192,31,255,248,3,129,192,31,255,248,3,129,192,31,255,248,
  // 0x63d2  插
  210,99,45,48,32,48,0,250,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,3,255,192,3,128,0,3,255,192,3,128,0,3,255,192,3,129,255,252,0,0,3,129,255,252,0,0,3,129,255,252,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,255,254,0,28,0,0,255,254,0,28,0,0,255,254,0,28,0,0,3,143,255,255,255,248,3,143,255,255,255,248,3,143,255,255,255,248,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,142,7,28,0,0,3,142,7,28,0,0,3,142,7,28,0,0,3,241,248,28,127,192,3,241,248,28,127,192,3,241,248,28,127,192,255,129,192,28,1,192,255,129,192,28,1,192,255,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,255,28,127,192,3,129,255,28,127,192,3,129,255,28,127,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,227,129,255,255,255,192,227,129,255,255,255,192,227,129,255,255,255,192,28,1,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,
  // 0x6536  收
  54,101,42,48,32,48,3,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,7,0,0,0,224,112,7,0,0,0,224,112,7,0,0,0,224,112,7,255,255,192,224,112,7,255,255,192,224,112,7,255,255,192,224,112,56,0,112,0,224,112,56,0,112,0,224,112,56,0,112,0,224,113,199,0,112,0,224,113,199,0,112,0,224,113,199,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,227,240,0,227,128,0,227,240,0,227,128,0,227,240,0,227,128,0,252,112,0,227,128,0,252,112,0,227,128,0,252,112,0,227,128,0,224,112,0,28,0,0,224,112,0,28,0,0,224,112,0,28,0,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,113,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,
  // 0x653e  放
  62,101,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,255,248,224,0,0,255,255,248,224,0,0,255,255,248,224,0,0,3,128,0,255,255,248,3,128,0,255,255,248,3,128,0,255,255,248,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,248,224,14,0,3,255,248,224,14,0,3,255,248,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,28,1,192,28,112,0,28,1,192,28,112,0,28,1,192,28,112,0,28,113,192,224,14,0,28,113,192,224,14,0,28,113,192,224,14,0,224,14,7,0,1,192,224,14,7,0,1,192,224,14,7,0,1,192,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,
  // 0x6570  数
  112,101,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,28,14,7,3,128,0,28,14,7,3,128,0,28,14,7,3,128,0,3,142,56,3,128,0,3,142,56,3,128,0,3,142,56,3,128,0,0,14,0,3,255,248,0,14,0,3,255,248,0,14,0,3,255,248,255,255,255,28,1,192,255,255,255,28,1,192,255,255,255,28,1,192,3,142,56,28,1,192,3,142,56,28,1,192,3,142,56,28,1,192,28,14,7,28,1,192,28,14,7,28,1,192,28,14,7,28,1,192,224,14,0,227,129,192,224,14,0,227,129,192,224,14,0,227,129,192,0,112,0,3,142,0,0,112,0,3,142,0,0,112,0,3,142,0,255,255,248,3,142,0,255,255,248,3,142,0,255,255,248,3,142,0,3,128,56,0,112,0,3,128,56,0,112,0,3,128,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,31,129,192,3,142,0,31,129,192,3,142,0,31,129,192,3,142,0,0,126,0,3,142,0,0,126,0,3,142,0,0,126,0,3,142,0,3,241,192,28,1,192,3,241,192,28,1,192,3,241,192,28,1,192,252,0,56,224,0,56,252,0,56,224,0,56,252,0,56,224,0,56,
  // 0x6572  敲
  114,101,45,48,32,48,0,250,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,255,255,255,0,112,0,255,255,255,0,112,0,255,255,255,0,112,0,0,0,0,0,127,248,0,0,0,0,127,248,0,0,0,0,127,248,31,255,248,0,112,0,31,255,248,0,112,0,31,255,248,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,31,255,248,255,255,192,31,255,248,255,255,192,31,255,248,255,255,192,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,255,255,255,28,1,192,255,255,255,28,1,192,255,255,255,28,1,192,224,0,7,28,1,192,224,0,7,28,1,192,224,0,7,28,1,192,227,255,199,3,142,0,227,255,199,3,142,0,227,255,199,3,142,0,227,129,199,3,142,0,227,129,199,3,142,0,227,129,199,3,142,0,227,255,199,0,112,0,227,255,199,0,112,0,227,255,199,0,112,0,224,0,7,3,142,0,224,0,7,3,142,0,224,0,7,3,142,0,224,1,199,28,1,192,224,1,199,28,1,192,224,1,199,28,1,192,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,
  // 0x6574  整
  116,101,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,255,255,255,227,255,248,255,255,255,227,255,248,255,255,255,227,255,248,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,31,255,255,227,129,192,31,255,255,227,129,192,31,255,255,227,129,192,28,14,7,3,129,192,28,14,7,3,129,192,28,14,7,3,129,192,31,255,255,3,142,0,31,255,255,3,142,0,31,255,255,3,142,0,3,142,56,0,112,0,3,142,56,0,112,0,3,142,56,0,112,0,28,14,7,3,142,0,28,14,7,3,142,0,28,14,7,3,142,0,224,14,0,28,1,248,224,14,0,28,1,248,224,14,0,28,1,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x6599  料
  153,101,45,48,32,48,0,250,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,28,14,56,28,14,0,28,14,56,28,14,0,28,14,56,28,14,0,3,142,56,28,14,0,3,142,56,28,14,0,3,142,56,28,14,0,3,143,192,0,14,0,3,143,192,0,14,0,3,143,192,0,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,255,255,248,28,14,0,255,255,248,28,14,0,255,255,248,28,14,0,0,126,0,28,14,0,0,126,0,28,14,0,0,126,0,28,14,0,0,127,192,0,14,0,0,127,192,0,14,0,0,127,192,0,14,0,3,142,56,0,15,248,3,142,56,0,15,248,3,142,56,0,15,248,3,142,56,255,254,0,3,142,56,255,254,0,3,142,56,255,254,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,
  // 0x659c  斜
  156,101,45,48,32,48,0,250,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,113,192,3,142,0,0,113,192,3,142,0,0,113,192,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,28,0,7,0,14,0,28,0,7,0,14,0,28,0,7,0,14,0,227,255,248,28,14,0,227,255,248,28,14,0,227,255,248,28,14,0,0,14,0,3,142,0,0,14,0,3,142,0,0,14,0,3,142,0,0,14,0,3,142,0,0,14,0,3,142,0,0,14,0,3,142,0,31,255,255,0,15,248,31,255,255,0,15,248,31,255,255,0,15,248,0,14,0,31,254,0,0,14,0,31,254,0,0,14,0,31,254,0,3,142,56,0,14,0,3,142,56,0,14,0,3,142,56,0,14,0,3,142,7,0,14,0,3,142,7,0,14,0,3,142,7,0,14,0,28,14,7,0,14,0,28,14,7,0,14,0,28,14,7,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,3,142,0,0,14,0,3,142,0,0,14,0,3,142,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,
  // 0x65ad  断
  173,101,42,48,32,48,3,250,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,227,142,56,255,240,0,227,142,56,255,240,0,227,142,56,255,240,0,224,127,192,224,0,0,224,127,192,224,0,0,224,127,192,224,0,0,224,14,0,224,0,0,224,14,0,224,0,0,224,14,0,224,0,0,255,255,248,224,0,0,255,255,248,224,0,0,255,255,248,224,0,0,224,14,0,255,255,192,224,14,0,255,255,192,224,14,0,255,255,192,224,127,192,224,112,0,224,127,192,224,112,0,224,127,192,224,112,0,227,142,56,224,112,0,227,142,56,224,112,0,227,142,56,224,112,0,252,14,56,224,112,0,252,14,56,224,112,0,252,14,56,224,112,0,224,14,0,224,112,0,224,14,0,224,112,0,224,14,0,224,112,0,224,14,0,224,112,0,224,14,0,224,112,0,224,14,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,255,255,255,0,112,0,255,255,255,0,112,0,255,255,255,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,
  // 0x65b0  新
  176,101,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,14,0,0,1,192,0,14,0,0,1,192,0,14,0,0,1,192,31,255,255,31,254,0,31,255,255,31,254,0,31,255,255,31,254,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,128,56,28,0,0,3,128,56,28,0,0,3,128,56,28,0,0,0,113,192,28,0,0,0,113,192,28,0,0,0,113,192,28,0,0,255,255,255,31,255,248,255,255,255,31,255,248,255,255,255,31,255,248,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,31,255,255,28,14,0,31,255,255,28,14,0,31,255,255,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,3,142,56,28,14,0,3,142,56,28,14,0,3,142,56,28,14,0,28,14,7,28,14,0,28,14,7,28,14,0,28,14,7,28,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,3,142,0,224,14,0,3,142,0,224,14,0,3,142,0,224,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,
  // 0x65b9  方
  185,101,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,255,255,240,0,0,1,255,255,240,0,0,1,255,255,240,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,
  // 0x65e0  无
  224,101,42,45,14,48,0,250,3,255,255,255,240,0,3,255,255,255,240,0,3,255,255,255,240,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,192,28,0,0,31,255,192,28,0,0,31,255,192,28,0,0,31,255,192,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,
  // 0x65f6  时
  246,101,42,48,32,48,3,250,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,63,255,255,192,224,14,63,255,255,192,224,14,63,255,255,192,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,224,14,7,0,112,0,224,14,7,0,112,0,224,14,7,0,112,0,224,14,0,224,112,0,224,14,0,224,112,0,224,14,0,224,112,0,224,14,0,224,112,0,224,14,0,224,112,0,224,14,0,224,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0x660e  明
  14,102,39,45,225,48,3,250,0,0,7,255,254,0,0,7,255,254,0,0,7,255,254,255,254,7,0,14,255,254,7,0,14,255,254,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,255,254,224,14,7,255,254,224,14,7,255,254,255,254,7,0,14,255,254,7,0,14,255,254,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,255,254,224,14,7,255,254,224,14,7,255,254,255,254,7,0,14,255,254,7,0,14,255,254,7,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,1,192,3,142,0,1,192,3,142,0,1,192,3,142,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,
  // 0x662f  是
  47,102,45,48,32,48,0,250,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,3,142,7,0,0,0,3,142,7,0,0,0,3,142,7,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,224,0,63,255,255,248,224,0,63,255,255,248,224,0,63,255,255,248,
  // 0x6682  暂
  130,102,45,48,32,48,0,250,0,112,0,0,15,192,0,112,0,0,15,192,0,112,0,0,15,192,255,255,248,255,240,0,255,255,248,255,240,0,255,255,248,255,240,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,28,14,0,224,0,0,28,14,0,224,0,0,28,14,0,224,0,0,31,255,248,255,255,248,31,255,248,255,255,248,31,255,248,255,255,248,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,15,248,224,14,0,0,15,248,224,14,0,0,15,248,224,14,0,255,254,7,0,14,0,255,254,7,0,14,0,255,254,7,0,14,0,28,14,56,0,14,0,28,14,56,0,14,0,28,14,56,0,14,0,0,127,255,255,254,0,0,127,255,255,254,0,0,127,255,255,254,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,
  // 0x66ab  暫
  171,102,42,48,32,48,3,250,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,255,255,248,255,240,0,255,255,248,255,240,0,255,255,248,255,240,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,255,255,248,224,0,0,255,255,248,224,0,0,255,255,248,224,0,0,224,112,56,255,255,192,224,112,56,255,255,192,224,112,56,255,255,192,255,255,248,224,112,0,255,255,248,224,112,0,255,255,248,224,112,0,224,112,56,224,112,0,224,112,56,224,112,0,224,112,56,224,112,0,255,255,248,224,112,0,255,255,248,224,112,0,255,255,248,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,255,255,248,224,112,0,255,255,248,224,112,0,255,255,248,224,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,3,255,255,255,128,0,3,255,255,255,128,0,3,255,255,255,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,255,255,255,128,0,3,255,255,255,128,0,3,255,255,255,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,255,255,255,128,0,3,255,255,255,128,0,3,255,255,255,128,0,
  // 0x66f4  更
  244,102,45,45,14,48,0,250,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,14,56,0,0,0,0,14,56,0,0,0,0,14,56,0,0,0,0,1,248,0,0,0,0,1,248,0,0,0,0,1,248,0,0,0,0,126,7,252,0,0,0,126,7,252,0,0,0,126,7,252,0,0,255,128,0,3,255,248,255,128,0,3,255,248,255,128,0,3,255,248,
  // 0x6700  最
  0,103,45,48,32,48,0,250,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,3,128,56,0,0,0,3,128,56,0,0,0,3,128,56,0,0,0,3,255,248,255,254,0,3,255,248,255,254,0,3,255,248,255,254,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,255,248,224,112,0,3,255,248,224,112,0,3,255,248,224,112,0,3,128,56,28,112,0,3,128,56,28,112,0,3,128,56,28,112,0,3,143,255,3,128,0,3,143,255,3,128,0,3,143,255,3,128,0,255,240,56,28,112,0,255,240,56,28,112,0,255,240,56,28,112,0,28,0,56,224,14,0,28,0,56,224,14,0,28,0,56,224,14,0,0,0,63,0,1,248,0,0,63,0,1,248,0,0,63,0,1,248,
  // 0x6709  有
  9,103,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,3,143,255,255,240,0,3,143,255,255,240,0,3,143,255,255,240,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,28,112,0,0,14,0,28,112,0,0,14,0,28,112,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,
  // 0x671f  期
  31,103,42,48,32,48,0,250,3,128,56,0,0,0,3,128,56,0,0,0,3,128,56,0,0,0,3,128,56,31,255,192,3,128,56,31,255,192,3,128,56,31,255,192,31,255,255,28,1,192,31,255,255,28,1,192,31,255,255,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,255,248,31,255,192,3,255,248,31,255,192,3,255,248,31,255,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,128,56,31,255,192,3,128,56,31,255,192,3,128,56,31,255,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,255,255,255,28,1,192,255,255,255,28,1,192,255,255,255,28,1,192,0,1,192,224,1,192,0,1,192,224,1,192,0,1,192,224,1,192,3,128,56,224,1,192,3,128,56,224,1,192,3,128,56,224,1,192,28,0,7,0,113,192,28,0,7,0,113,192,28,0,7,0,113,192,224,0,56,0,14,0,224,0,56,0,14,0,224,0,56,0,14,0,
  // 0x673a  机
  58,103,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,255,240,0,0,112,7,255,240,0,0,112,7,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,255,255,199,0,112,0,255,255,199,0,112,0,255,255,199,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,3,254,7,0,112,0,3,254,7,0,112,0,3,254,7,0,112,0,28,113,199,0,112,0,28,113,199,0,112,0,28,113,199,0,112,0,28,113,199,0,112,0,28,113,199,0,112,0,28,113,199,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,0,112,7,0,112,56,0,112,7,0,112,56,0,112,7,0,112,56,0,112,7,0,112,56,0,112,7,0,112,56,0,112,7,0,112,56,0,112,56,0,112,56,0,112,56,0,112,56,0,112,56,0,112,56,0,112,56,0,15,248,0,112,56,0,15,248,0,112,56,0,15,248,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,
  // 0x6740  杀
  64,103,45,48,32,48,0,250,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,126,0,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,0,1,248,31,128,0,0,1,248,31,128,0,0,1,248,31,128,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,1,248,31,128,0,0,1,248,31,128,0,0,1,248,31,128,0,0,126,0,0,126,0,0,126,0,0,126,0,0,126,0,0,126,0,31,128,7,0,1,192,31,128,7,0,1,192,31,128,7,0,1,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,28,1,199,0,1,192,28,1,199,0,1,192,28,1,199,0,1,192,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x675f  束
  95,103,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,63,224,14,0,3,128,63,224,14,0,3,128,63,224,14,0,0,1,199,28,0,0,0,1,199,28,0,0,0,1,199,28,0,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,3,240,7,0,126,0,3,240,7,0,126,0,3,240,7,0,126,0,252,0,7,0,1,248,252,0,7,0,1,248,252,0,7,0,1,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x6761  条
  97,103,45,48,32,48,0,250,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,126,0,3,128,0,0,126,0,3,128,0,0,126,0,3,128,0,31,129,192,28,0,0,31,129,192,28,0,0,31,129,192,28,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,127,199,31,240,0,0,127,199,31,240,0,0,127,199,31,240,0,255,128,7,0,15,248,255,128,7,0,15,248,255,128,7,0,15,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,28,1,199,0,1,192,28,1,199,0,1,192,28,1,199,0,1,192,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x6765  来
  101,103,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,0,112,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,63,224,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,1,199,28,0,0,0,1,199,28,0,0,0,1,199,28,0,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,3,240,7,0,126,0,3,240,7,0,126,0,3,240,7,0,126,0,252,0,7,0,1,248,252,0,7,0,1,248,252,0,7,0,1,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x677f  板
  127,103,45,48,32,48,0,250,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,127,192,0,112,0,0,127,192,0,112,0,0,127,192,0,112,7,255,128,0,0,112,7,255,128,0,0,112,7,255,128,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,255,255,199,0,0,0,255,255,199,0,0,0,255,255,199,0,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,3,240,7,28,1,192,3,240,7,28,1,192,3,240,7,28,1,192,3,254,7,28,1,192,3,254,7,28,1,192,3,254,7,28,1,192,28,113,199,28,1,192,28,113,199,28,1,192,28,113,199,28,1,192,28,113,199,3,142,0,28,113,199,3,142,0,28,113,199,3,142,0,224,112,7,3,142,0,224,112,7,3,142,0,224,112,7,3,142,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,113,192,224,0,56,0,113,192,224,0,56,0,113,192,224,0,56,
  // 0x6797  林
  151,103,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,255,255,199,255,255,248,255,255,199,255,255,248,255,255,199,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,240,0,31,240,0,3,240,0,31,240,0,3,240,0,31,240,0,3,254,0,31,240,0,3,254,0,31,240,0,3,254,0,31,240,0,28,113,192,227,142,0,28,113,192,227,142,0,28,113,192,227,142,0,28,112,0,227,142,0,28,112,0,227,142,0,28,112,0,227,142,0,224,112,7,3,129,192,224,112,7,3,129,192,224,112,7,3,129,192,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,
  // 0x67f1  柱
  241,103,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,240,0,3,128,0,3,240,0,3,128,0,3,240,0,3,128,0,3,254,0,3,128,0,3,254,0,3,128,0,3,254,0,3,128,0,28,113,199,255,255,192,28,113,199,255,255,192,28,113,199,255,255,192,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x6821  校
  33,104,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,7,255,255,248,0,112,7,255,255,248,0,112,7,255,255,248,255,255,192,0,0,0,255,255,192,0,0,0,255,255,192,0,0,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,3,240,7,0,1,192,3,240,7,0,1,192,3,240,7,0,1,192,3,254,56,0,0,56,3,254,56,0,0,56,3,254,56,0,0,56,28,113,192,224,14,0,28,113,192,224,14,0,28,113,192,224,14,0,28,112,0,224,14,0,28,112,0,224,14,0,28,112,0,224,14,0,224,112,0,28,112,0,224,112,0,28,112,0,224,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,63,0,1,248,0,112,63,0,1,248,0,112,63,0,1,248,
  // 0x683c  格
  60,104,45,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,0,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,255,254,63,0,112,0,255,254,63,0,112,0,255,254,63,0,112,0,0,113,192,227,128,0,0,113,192,227,128,0,0,113,192,227,128,0,3,240,0,28,0,0,3,240,0,28,0,0,3,240,0,28,0,0,3,254,0,227,128,0,3,254,0,227,128,0,3,254,0,227,128,0,28,113,199,0,126,0,28,113,199,0,126,0,28,113,199,0,126,0,28,112,56,0,1,248,28,112,56,0,1,248,28,112,56,0,1,248,224,113,199,255,254,0,224,113,199,255,254,0,224,113,199,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,
  // 0x68af  梯
  175,104,45,48,32,48,0,250,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,255,255,192,3,129,192,255,255,192,3,129,192,255,255,192,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,3,240,7,255,255,192,3,240,7,255,255,192,3,240,7,255,255,192,3,254,7,3,128,0,3,254,7,3,128,0,3,254,7,3,128,0,28,113,199,3,128,0,28,113,199,3,128,0,28,113,199,3,128,0,28,112,7,255,255,248,28,112,7,255,255,248,28,112,7,255,255,248,224,112,0,31,128,56,224,112,0,31,128,56,224,112,0,31,128,56,0,112,0,227,128,56,0,112,0,227,128,56,0,112,0,227,128,56,0,112,7,3,142,56,0,112,7,3,142,56,0,112,7,3,142,56,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,
  // 0x68c0  检
  192,104,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,255,255,199,0,112,0,255,255,199,0,112,0,255,255,199,0,112,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,3,241,199,255,241,248,3,241,199,255,241,248,3,241,199,255,241,248,3,254,0,0,0,0,3,254,0,0,0,0,3,254,0,0,0,0,28,113,192,224,14,0,28,113,192,224,14,0,28,113,192,224,14,0,28,112,0,28,14,0,28,112,0,28,14,0,28,112,0,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,224,112,56,28,14,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x69fd  槽
  253,105,45,48,32,48,0,250,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,255,254,63,255,255,192,255,254,63,255,255,192,255,254,63,255,255,192,0,112,56,224,113,192,0,112,56,224,113,192,0,112,56,224,113,192,3,240,63,255,255,192,3,240,63,255,255,192,3,240,63,255,255,192,3,254,56,224,113,192,3,254,56,224,113,192,3,254,56,224,113,192,28,113,255,255,255,192,28,113,255,255,255,192,28,113,255,255,255,192,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,224,112,7,255,254,0,224,112,7,255,254,0,224,112,7,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,
  // 0x6a21  模
  33,106,45,48,32,48,0,250,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,255,255,192,0,0,0,255,255,192,0,0,0,255,255,192,0,0,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,3,240,56,0,14,0,3,240,56,0,14,0,3,240,56,0,14,0,3,254,63,255,254,0,3,254,63,255,254,0,3,254,63,255,254,0,28,113,248,0,14,0,28,113,248,0,14,0,28,113,248,0,14,0,28,112,63,255,254,0,28,112,63,255,254,0,28,112,63,255,254,0,224,112,0,28,0,0,224,112,0,28,0,0,224,112,0,28,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,113,192,0,1,248,0,113,192,0,1,248,0,113,192,0,1,248,
  // 0x6a59  橙
  89,106,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,113,255,227,129,192,0,113,255,227,129,192,0,113,255,227,129,192,0,112,0,227,142,0,0,112,0,227,142,0,0,112,0,227,142,0,0,112,56,224,112,56,0,112,56,224,112,56,0,112,56,224,112,56,255,254,7,0,113,192,255,254,7,0,113,192,255,254,7,0,113,192,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,3,241,199,255,241,192,3,241,199,255,241,192,3,241,199,255,241,192,3,254,0,0,0,56,3,254,0,0,0,56,3,254,0,0,0,56,28,113,255,255,254,0,28,113,255,255,254,0,28,113,255,255,254,0,28,112,56,0,14,0,28,112,56,0,14,0,28,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,224,112,56,0,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,255,248,0,127,255,255,255,248,0,127,255,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x6b62  止
  98,107,45,45,14,48,0,253,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x6b63  正
  99,107,45,42,252,48,0,253,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x6b65  步
  101,107,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,3,128,7,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,28,0,0,252,0,0,28,0,0,252,0,0,28,0,0,252,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,255,128,0,0,0,0,255,128,0,0,0,0,255,128,0,0,0,0,
  // 0x6bd4  比
  212,107,39,45,225,48,6,253,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,112,224,0,56,0,112,224,0,56,0,112,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,255,254,56,224,0,255,254,56,224,0,255,254,56,224,0,224,0,63,0,0,224,0,63,0,0,224,0,63,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,126,56,0,14,224,126,56,0,14,224,126,56,0,14,255,128,56,0,14,255,128,56,0,14,255,128,56,0,14,224,0,7,255,254,224,0,7,255,254,224,0,7,255,254,
  // 0x6ca1  没
  161,108,45,45,14,48,0,250,3,128,7,255,240,0,3,128,7,255,240,0,3,128,7,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,224,0,7,0,112,0,224,0,7,0,112,0,224,0,7,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,0,56,0,112,0,28,113,192,0,15,248,28,113,192,0,15,248,28,113,192,0,15,248,0,126,0,0,0,0,0,126,0,0,0,0,0,126,0,0,0,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,255,128,7,0,14,0,255,128,7,0,14,0,255,128,7,0,14,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,7,227,240,0,3,128,7,227,240,0,3,128,7,227,240,0,0,15,248,0,15,248,0,15,248,0,15,248,0,15,248,0,15,248,
  // 0x6ce2  波
  226,108,45,48,32,48,0,250,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,224,0,56,3,128,56,224,0,56,3,128,56,224,0,56,3,128,56,28,0,56,3,129,192,28,0,56,3,129,192,28,0,56,3,129,192,28,14,56,3,128,0,28,14,56,3,128,0,28,14,56,3,128,0,0,14,63,255,255,192,0,14,63,255,255,192,0,14,63,255,255,192,0,112,56,224,1,192,0,112,56,224,1,192,0,112,56,224,1,192,0,112,56,224,14,0,0,112,56,224,14,0,0,112,56,224,14,0,255,128,56,28,14,0,255,128,56,28,14,0,255,128,56,28,14,0,3,128,56,28,112,0,3,128,56,28,112,0,3,128,56,28,112,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,0,14,7,0,1,248,0,14,7,0,1,248,0,14,7,0,1,248,
  // 0x6ce8  注
  232,108,45,45,14,48,0,253,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,255,128,0,28,0,0,255,128,0,28,0,0,255,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,143,255,255,255,248,3,143,255,255,255,248,3,143,255,255,255,248,
  // 0x6d17  洗
  23,109,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,128,56,28,0,0,3,128,56,28,0,0,3,128,56,28,0,0,0,112,56,28,0,0,0,112,56,28,0,0,0,112,56,28,0,0,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,224,1,192,28,0,0,224,1,192,28,0,0,224,1,192,28,0,0,28,14,0,28,0,0,28,14,0,28,0,0,28,14,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,255,128,7,3,128,0,255,128,7,3,128,0,255,128,7,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,3,128,56,3,128,56,3,128,56,3,128,56,3,128,56,3,128,56,3,128,56,3,128,56,3,128,56,3,128,56,3,128,56,3,128,56,3,129,192,0,127,248,3,129,192,0,127,248,3,129,192,0,127,248,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,
  // 0x6d3b  活
  59,109,45,48,32,48,0,250,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,3,128,0,31,254,0,3,128,0,31,254,0,3,128,0,31,254,0,0,112,63,252,0,0,0,112,63,252,0,0,0,112,63,252,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,255,128,56,0,14,0,255,128,56,0,14,0,255,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,
  // 0x6d41  流
  65,109,45,48,32,48,0,250,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,224,0,7,0,112,0,224,0,7,0,112,0,224,0,7,0,112,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,1,255,255,255,192,28,1,255,255,255,192,28,1,255,255,255,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,255,128,56,28,14,0,255,128,56,28,14,0,255,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,56,3,128,56,28,14,56,3,128,56,28,14,56,3,129,192,28,14,56,3,129,192,28,14,56,3,129,192,28,14,56,0,14,0,28,1,248,0,14,0,28,1,248,0,14,0,28,1,248,
  // 0x6d4b  测
  75,109,42,48,32,48,0,250,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,3,129,255,252,1,192,3,129,255,252,1,192,3,129,255,252,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,113,192,0,113,192,28,113,192,0,113,192,28,113,192,224,1,199,28,113,192,224,1,199,28,113,192,224,1,199,28,113,192,28,1,199,28,113,192,28,1,199,28,113,192,28,1,199,28,113,192,28,1,199,28,113,192,28,1,199,28,113,192,28,1,199,28,113,192,0,113,199,28,113,192,0,113,199,28,113,192,0,113,199,28,113,192,0,113,199,28,113,192,0,113,199,28,113,192,0,113,199,28,113,192,3,129,199,28,113,192,3,129,199,28,113,192,3,129,199,28,113,192,255,129,199,28,113,192,255,129,199,28,113,192,255,129,199,28,113,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,56,224,1,192,3,128,56,224,1,192,3,128,56,224,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,3,129,192,0,113,192,3,129,192,0,113,192,3,129,192,0,113,192,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,
  // 0x6d88  消
  136,109,39,48,240,48,0,250,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,3,128,56,28,14,3,128,56,28,14,3,128,56,28,14,0,112,7,28,14,0,112,7,28,14,0,112,7,28,14,0,112,7,28,112,0,112,7,28,112,0,112,7,28,112,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,28,0,63,255,254,28,0,63,255,254,28,0,63,255,254,28,14,56,0,14,28,14,56,0,14,28,14,56,0,14,0,14,56,0,14,0,14,56,0,14,0,14,56,0,14,0,112,63,255,254,0,112,63,255,254,0,112,63,255,254,0,112,56,0,14,0,112,56,0,14,0,112,56,0,14,255,128,56,0,14,255,128,56,0,14,255,128,56,0,14,3,128,63,255,254,3,128,63,255,254,3,128,63,255,254,3,128,56,0,14,3,128,56,0,14,3,128,56,0,14,3,128,56,0,14,3,128,56,0,14,3,128,56,0,14,3,128,56,3,142,3,128,56,3,142,3,128,56,3,142,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,
  // 0x6de1  淡
  225,109,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,113,192,28,14,0,0,113,192,28,14,0,0,113,192,28,14,0,224,0,0,227,128,0,224,0,0,227,128,0,224,0,0,227,128,0,28,0,7,0,112,0,28,0,7,0,112,0,28,0,7,0,112,0,28,1,248,0,14,0,28,1,248,0,14,0,28,1,248,0,14,0,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,255,128,56,28,14,0,255,128,56,28,14,0,255,128,56,28,14,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,0,15,192,0,1,248,0,15,192,0,1,248,0,15,192,0,1,248,
  // 0x6df7  混
  247,109,45,45,14,48,0,250,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,0,113,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,224,1,255,255,255,192,224,1,255,255,255,192,224,1,255,255,255,192,28,1,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,255,129,192,3,128,56,255,129,192,3,128,56,255,129,192,3,128,56,3,129,255,227,143,192,3,129,255,227,143,192,3,129,255,227,143,192,3,129,192,3,240,0,3,129,192,3,240,0,3,129,192,3,240,0,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,199,227,128,56,3,129,199,227,128,56,3,129,199,227,128,56,0,1,248,0,127,248,0,1,248,0,127,248,0,1,248,0,127,248,
  // 0x6e05  清
  5,110,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,224,0,63,255,254,0,224,0,63,255,254,0,224,0,63,255,254,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,15,255,255,255,248,28,15,255,255,255,248,28,15,255,255,255,248,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,255,128,56,0,14,0,255,128,56,0,14,0,255,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,
  // 0x6e29  温
  41,110,45,42,252,48,0,253,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,224,0,63,255,254,0,224,0,63,255,254,0,224,0,63,255,254,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,255,129,192,227,129,192,255,129,192,227,129,192,255,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,129,192,227,129,192,3,143,255,255,255,248,3,143,255,255,255,248,3,143,255,255,255,248,
  // 0x6e38  游
  56,110,45,48,32,48,0,250,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,113,255,227,255,248,0,113,255,227,255,248,0,113,255,227,255,248,224,0,56,3,128,0,224,0,56,3,128,0,224,0,56,3,128,0,28,0,56,28,0,0,28,0,56,28,0,0,28,0,56,28,0,0,28,0,63,227,255,192,28,0,63,227,255,192,28,0,63,227,255,192,0,112,56,224,1,192,0,112,56,224,1,192,0,112,56,224,1,192,0,112,56,224,14,0,0,112,56,224,14,0,0,112,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,255,128,56,227,255,248,255,128,56,227,255,248,255,128,56,227,255,248,3,128,56,224,14,0,3,128,56,224,14,0,3,128,56,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,142,7,227,142,0,3,142,7,227,142,0,3,142,7,227,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x6e90  源
  144,110,45,45,14,48,0,250,3,129,255,255,255,248,3,129,255,255,255,248,3,129,255,255,255,248,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,28,0,0,0,113,192,28,0,0,0,113,192,28,0,0,224,1,199,255,255,192,224,1,199,255,255,192,224,1,199,255,255,192,28,1,199,0,1,192,28,1,199,0,1,192,28,1,199,0,1,192,28,1,199,255,255,192,28,1,199,255,255,192,28,1,199,255,255,192,0,113,199,0,1,192,0,113,199,0,1,192,0,113,199,0,1,192,0,113,199,255,255,192,0,113,199,255,255,192,0,113,199,255,255,192,3,129,199,3,129,192,3,129,199,3,129,192,3,129,199,3,129,192,255,129,192,3,128,0,255,129,192,3,128,0,255,129,192,3,128,0,3,129,192,227,142,0,3,129,192,227,142,0,3,129,192,227,142,0,3,142,7,3,129,192,3,142,7,3,129,192,3,142,7,3,129,192,3,142,56,3,128,56,3,142,56,3,128,56,3,142,56,3,128,56,3,240,0,227,128,0,3,240,0,227,128,0,3,240,0,227,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x6ea2  溢
  162,110,45,45,14,48,0,253,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,224,1,255,255,255,192,224,1,255,255,255,192,224,1,255,255,255,192,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,7,0,112,0,28,0,7,0,112,0,28,0,7,0,112,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,113,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,255,128,56,227,142,0,255,128,56,227,142,0,255,128,56,227,142,0,3,128,56,227,142,0,3,128,56,227,142,0,3,128,56,227,142,0,3,128,56,227,142,0,3,128,56,227,142,0,3,128,56,227,142,0,3,128,56,227,142,0,3,128,56,227,142,0,3,128,56,227,142,0,3,143,255,255,255,248,3,143,255,255,255,248,3,143,255,255,255,248,
  // 0x6ed1  滑
  209,110,45,45,14,48,0,250,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,63,252,14,0,0,112,63,252,14,0,0,112,63,252,14,0,224,0,56,28,14,0,224,0,56,28,14,0,224,0,56,28,14,0,28,15,255,255,255,248,28,15,255,255,255,248,28,15,255,255,255,248,28,14,0,0,0,56,28,14,0,0,0,56,28,14,0,0,0,56,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,255,128,56,0,14,0,255,128,56,0,14,0,255,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,
  // 0x6f0f  漏
  15,111,45,45,14,48,0,250,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,3,129,192,0,0,56,3,129,192,0,0,56,3,129,192,0,0,56,3,129,192,0,0,56,3,129,192,0,0,56,3,129,192,0,0,56,0,1,255,255,255,248,0,1,255,255,255,248,0,1,255,255,255,248,224,1,192,0,0,0,224,1,192,0,0,0,224,1,192,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,3,129,248,3,128,56,3,129,248,3,128,56,3,129,248,3,128,56,255,129,248,227,142,56,255,129,248,227,142,56,255,129,248,227,142,56,3,142,56,3,128,56,3,142,56,3,128,56,3,142,56,3,128,56,3,142,56,227,142,56,3,142,56,227,142,56,3,142,56,227,142,56,3,240,56,3,128,56,3,240,56,3,128,56,3,240,56,3,128,56,3,128,56,3,142,56,3,128,56,3,142,56,3,128,56,3,142,56,0,0,56,0,1,192,0,0,56,0,1,192,0,0,56,0,1,192,
  // 0x6fc0  激
  192,111,45,48,32,48,0,250,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,3,143,255,224,112,0,3,143,255,224,112,0,3,143,255,224,112,0,3,142,0,224,112,0,3,142,0,224,112,0,3,142,0,224,112,0,0,15,255,227,255,248,0,15,255,227,255,248,0,15,255,227,255,248,224,14,0,227,129,192,224,14,0,227,129,192,224,14,0,227,129,192,28,15,255,252,113,192,28,15,255,252,113,192,28,15,255,252,113,192,28,113,192,0,113,192,28,113,192,0,113,192,28,113,192,0,113,192,0,112,56,0,113,192,0,112,56,0,113,192,0,112,56,0,113,192,3,143,255,252,113,192,3,143,255,252,113,192,3,143,255,252,113,192,255,129,192,0,113,192,255,129,192,0,113,192,255,129,192,0,113,192,3,129,255,224,14,0,3,129,255,224,14,0,3,129,255,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,142,0,224,113,192,3,142,0,224,113,192,3,142,0,224,113,192,3,142,56,224,113,192,3,142,56,224,113,192,3,142,56,224,113,192,0,112,7,3,128,56,0,112,7,3,128,56,0,112,7,3,128,56,
  // 0x706f  灯
  111,112,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,28,126,0,3,128,0,28,126,0,3,128,0,28,126,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,0,0,227,128,0,28,0,0,227,128,0,28,0,0,227,128,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,
  // 0x70b9  点
  185,112,42,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,63,255,255,192,0,0,63,255,255,192,0,0,63,255,255,192,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,3,255,255,255,240,0,3,255,255,255,240,0,3,255,255,255,240,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,255,255,255,240,0,3,255,255,255,240,0,3,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,128,56,28,1,192,3,128,56,28,1,192,3,128,56,28,1,192,28,0,56,28,1,192,28,0,56,28,1,192,28,0,56,28,1,192,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,
  // 0x70ed  热
  237,112,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,255,255,199,255,254,0,255,255,199,255,254,0,255,255,199,255,254,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,127,192,252,14,0,0,127,192,252,14,0,0,127,192,252,14,0,3,240,0,28,14,0,3,240,0,28,14,0,3,240,0,28,14,0,252,112,0,227,142,56,252,112,0,227,142,56,252,112,0,227,142,56,0,112,0,227,142,56,0,112,0,227,142,56,0,112,0,227,142,56,28,112,7,0,1,248,28,112,7,0,1,248,28,112,7,0,1,248,3,128,56,0,0,56,3,128,56,0,0,56,3,128,56,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,14,0,224,14,0,28,14,0,224,14,0,28,14,0,224,14,0,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,224,1,192,28,1,192,224,1,192,28,1,192,224,1,192,28,1,192,
  // 0x7247  片
  71,114,39,48,240,48,3,250,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,252,0,3,255,255,252,0,3,255,255,252,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,
  // 0x7269  物
  105,114,42,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,28,112,0,224,0,0,28,112,0,224,0,0,28,112,0,224,0,0,28,112,0,255,255,192,28,112,0,255,255,192,28,112,0,255,255,192,31,255,199,28,113,192,31,255,199,28,113,192,31,255,199,28,113,192,28,112,56,28,113,192,28,112,56,28,113,192,28,112,56,28,113,192,224,112,0,28,113,192,224,112,0,28,113,192,224,112,0,28,113,192,0,112,0,224,113,192,0,112,0,224,113,192,0,112,0,224,113,192,0,127,192,224,113,192,0,127,192,224,113,192,0,127,192,224,113,192,255,240,7,3,129,192,255,240,7,3,129,192,255,240,7,3,129,192,28,112,56,3,129,192,28,112,56,3,129,192,28,112,56,3,129,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x7279  特
  121,114,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,7,255,255,192,28,112,7,255,255,192,28,112,7,255,255,192,31,255,192,3,128,0,31,255,192,3,128,0,31,255,192,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,224,112,63,255,255,248,224,112,63,255,255,248,224,112,63,255,255,248,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,127,192,0,14,0,0,127,192,0,14,0,0,127,192,0,14,0,255,240,7,255,255,248,255,240,7,255,255,248,255,240,7,255,255,248,28,112,0,0,14,0,28,112,0,0,14,0,28,112,0,0,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,3,142,0,0,112,0,3,142,0,0,112,0,3,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x7387  率
  135,115,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,3,143,255,224,14,0,3,143,255,224,14,0,3,143,255,224,14,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,28,15,255,255,129,192,28,15,255,255,129,192,28,15,255,255,129,192,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x73af  环
  175,115,45,42,252,48,0,250,255,255,199,255,255,248,255,255,199,255,255,248,255,255,199,255,255,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,31,255,192,31,142,0,31,255,192,31,142,0,31,255,192,31,142,0,0,112,0,227,129,192,0,112,0,227,129,192,0,112,0,227,129,192,0,112,7,3,128,56,0,112,7,3,128,56,0,112,7,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,56,3,128,56,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,127,192,3,128,0,0,127,192,3,128,0,0,127,192,3,128,0,255,128,0,3,128,0,255,128,0,3,128,0,255,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0x7528  用
  40,117,39,45,225,48,0,250,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,28,0,7,0,14,28,0,7,0,14,28,0,7,0,14,28,0,7,3,142,28,0,7,3,142,28,0,7,3,142,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x7535  电
  53,117,39,48,240,48,6,250,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,224,1,192,3,142,224,1,192,3,142,224,1,192,3,142,0,1,192,0,14,0,1,192,0,14,0,1,192,0,14,0,1,192,0,14,0,1,192,0,14,0,1,192,0,14,0,0,63,255,254,0,0,63,255,254,0,0,63,255,254,
  // 0x7565  略
  101,117,45,48,32,48,0,250,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,255,254,0,227,142,7,0,14,0,227,142,7,0,14,0,227,142,7,0,14,0,227,142,63,0,112,0,227,142,63,0,112,0,227,142,63,0,112,0,227,143,192,227,128,0,227,143,192,227,128,0,227,143,192,227,128,0,255,254,0,28,0,0,255,254,0,28,0,0,255,254,0,28,0,0,227,142,0,227,128,0,227,142,0,227,128,0,227,142,0,227,128,0,227,142,7,0,126,0,227,142,7,0,126,0,227,142,7,0,126,0,227,142,56,0,1,248,227,142,56,0,1,248,227,142,56,0,1,248,227,143,199,255,254,0,227,143,199,255,254,0,227,143,199,255,254,0,255,254,7,0,14,0,255,254,7,0,14,0,255,254,7,0,14,0,224,14,7,0,14,0,224,14,7,0,14,0,224,14,7,0,14,0,0,0,7,0,14,0,0,0,7,0,14,0,0,0,7,0,14,0,0,0,7,255,254,0,0,0,7,255,254,0,0,0,7,255,254,0,0,0,7,0,14,0,0,0,7,0,14,0,0,0,7,0,14,0,
  // 0x767d  白
  125,118,33,48,240,48,6,250,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,
  // 0x7684  的
  132,118,39,48,240,48,3,250,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,28,0,0,224,0,28,0,0,224,0,28,0,0,224,0,255,255,192,255,254,255,255,192,255,254,255,255,192,255,254,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,1,248,0,14,224,1,248,0,14,224,1,248,0,14,224,1,192,224,14,224,1,192,224,14,224,1,192,224,14,255,255,192,28,14,255,255,192,28,14,255,255,192,28,14,224,1,192,28,14,224,1,192,28,14,224,1,192,28,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,255,255,192,0,14,255,255,192,0,14,255,255,192,0,14,224,1,192,28,112,224,1,192,28,112,224,1,192,28,112,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,
  // 0x76d1  监
  209,118,45,45,14,48,0,253,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,3,129,192,28,0,0,3,129,192,28,0,0,3,129,192,28,0,0,3,129,192,31,255,192,3,129,192,31,255,192,3,129,192,31,255,192,3,129,192,28,0,0,3,129,192,28,0,0,3,129,192,28,0,0,3,129,192,224,112,0,3,129,192,224,112,0,3,129,192,224,112,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,199,0,14,0,3,129,199,0,14,0,3,129,199,0,14,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x76f4  直
  244,118,45,45,14,48,0,253,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x7701  省
  1,119,42,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,28,0,0,252,0,0,28,0,0,252,0,0,28,0,0,252,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,15,192,0,0,0,0,15,192,0,0,0,0,15,192,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,252,112,0,0,14,0,252,112,0,0,14,0,252,112,0,0,14,0,0,127,255,255,254,0,0,127,255,255,254,0,0,127,255,255,254,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,127,255,255,254,0,0,127,255,255,254,0,0,127,255,255,254,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,127,255,255,254,0,0,127,255,255,254,0,0,127,255,255,254,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,
  // 0x7720  眠
  32,119,42,45,14,48,3,250,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,255,254,56,0,14,0,255,254,56,0,14,0,255,254,56,0,14,0,224,14,56,0,14,0,224,14,56,0,14,0,224,14,56,0,14,0,224,14,56,0,14,0,224,14,56,0,14,0,224,14,56,0,14,0,255,254,63,255,254,0,255,254,63,255,254,0,255,254,63,255,254,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,255,254,63,255,255,192,255,254,63,255,255,192,255,254,63,255,255,192,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,28,0,0,224,14,56,3,128,0,224,14,56,3,128,0,224,14,56,3,128,0,255,254,56,3,129,192,255,254,56,3,129,192,255,254,56,3,129,192,224,14,56,224,113,192,224,14,56,224,113,192,224,14,56,224,113,192,0,0,63,0,15,192,0,0,63,0,15,192,0,0,63,0,15,192,0,0,56,0,1,192,0,0,56,0,1,192,0,0,56,0,1,192,
  // 0x786e  确
  110,120,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,255,192,31,255,192,255,255,192,31,255,192,255,255,192,31,255,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,3,128,56,255,255,248,3,128,56,255,255,248,3,128,56,255,255,248,3,255,192,224,112,56,3,255,192,224,112,56,3,255,192,224,112,56,31,129,192,224,112,56,31,129,192,224,112,56,31,129,192,224,112,56,31,129,192,255,255,248,31,129,192,255,255,248,31,129,192,255,255,248,227,129,192,224,112,56,227,129,192,224,112,56,227,129,192,224,112,56,3,129,192,224,112,56,3,129,192,224,112,56,3,129,192,224,112,56,3,129,192,255,255,248,3,129,192,255,255,248,3,129,192,255,255,248,3,255,192,224,112,56,3,255,192,224,112,56,3,255,192,224,112,56,3,129,199,0,112,56,3,129,199,0,112,56,3,129,199,0,112,56,3,128,7,0,14,56,3,128,7,0,14,56,3,128,7,0,14,56,0,0,56,0,1,192,0,0,56,0,1,192,0,0,56,0,1,192,
  // 0x79bb  离
  187,121,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,113,192,28,112,0,0,113,192,28,112,0,0,113,192,28,112,0,0,112,63,224,112,0,0,112,63,224,112,0,0,112,63,224,112,0,0,113,192,28,112,0,0,113,192,28,112,0,0,113,192,28,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,28,0,56,0,1,192,28,0,56,0,1,192,28,0,56,0,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,15,255,255,129,192,28,15,255,255,129,192,28,15,255,255,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,0,0,0,113,192,28,0,0,0,113,192,28,0,0,0,113,192,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,
  // 0x79fb  移
  251,121,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,127,192,3,128,0,0,127,192,3,128,0,0,127,192,3,128,0,255,240,0,31,255,192,255,240,0,31,255,192,255,240,0,31,255,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,7,28,14,0,0,112,7,28,14,0,0,112,7,28,14,0,255,255,192,3,240,0,255,255,192,3,240,0,255,255,192,3,240,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,240,0,28,14,0,3,240,0,28,14,0,3,240,0,28,14,0,3,254,7,224,112,0,3,254,7,224,112,0,3,254,7,224,112,0,28,113,192,3,255,248,28,113,192,3,255,248,28,113,192,3,255,248,28,113,192,28,0,56,28,113,192,28,0,56,28,113,192,28,0,56,224,112,7,227,129,192,224,112,7,227,129,192,224,112,7,227,129,192,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,128,0,0,112,0,31,128,0,0,112,0,31,128,0,0,112,7,224,0,0,0,112,7,224,0,0,0,112,7,224,0,0,
  // 0x7a7a  空
  122,122,45,45,14,48,0,253,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,
  // 0x7aef  端
  239,122,45,48,32,48,0,250,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,255,255,199,3,129,192,255,255,199,3,129,192,255,255,199,3,129,192,0,0,7,255,255,192,0,0,7,255,255,192,0,0,7,255,255,192,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,224,14,63,255,255,248,224,14,63,255,255,248,224,14,63,255,255,248,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,28,14,0,28,0,0,28,14,0,28,0,0,28,14,0,28,0,0,28,14,7,255,255,192,28,14,7,255,255,192,28,14,7,255,255,192,28,112,7,28,113,192,28,112,7,28,113,192,28,112,7,28,113,192,28,112,7,28,113,192,28,112,7,28,113,192,28,112,7,28,113,192,0,127,199,28,113,192,0,127,199,28,113,192,0,127,199,28,113,192,255,128,7,28,113,192,255,128,7,28,113,192,255,128,7,28,113,192,28,0,7,28,113,192,28,0,7,28,113,192,28,0,7,28,113,192,0,0,7,0,15,192,0,0,7,0,15,192,0,0,7,0,15,192,
  // 0x7b2c  第
  44,123,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,255,255,31,255,248,3,255,255,31,255,248,3,255,255,31,255,248,28,14,0,224,112,0,28,14,0,224,112,0,28,14,0,224,112,0,224,1,199,0,14,0,224,1,199,0,14,0,224,1,199,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,14,0,0,0,7,0,14,0,0,0,7,0,14,0,0,0,7,0,14,0,0,0,7,0,14,0,0,0,7,0,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,3,255,255,255,255,192,3,255,255,255,255,192,3,255,255,255,255,192,0,0,63,0,1,192,0,0,63,0,1,192,0,0,63,0,1,192,0,1,199,0,1,192,0,1,199,0,1,192,0,1,199,0,1,192,0,126,7,3,142,0,0,126,7,3,142,0,0,126,7,3,142,0,255,128,7,0,112,0,255,128,7,0,112,0,255,128,7,0,112,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x7b49  等
  73,123,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,255,255,31,255,248,3,255,255,31,255,248,3,255,255,31,255,248,28,14,0,224,112,0,28,14,0,224,112,0,28,14,0,224,112,0,224,1,199,0,14,0,224,1,199,0,14,0,224,1,199,0,14,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,227,128,0,0,1,192,227,128,0,0,1,192,227,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x7bb1  箱
  177,123,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,255,255,31,255,248,3,255,255,31,255,248,3,255,255,31,255,248,3,142,0,224,112,0,3,142,0,224,112,0,3,142,0,224,112,0,28,1,199,0,14,0,28,1,199,0,14,0,28,1,199,0,14,0,224,14,0,0,0,0,224,14,0,0,0,0,224,14,0,0,0,0,0,14,0,255,255,192,0,14,0,255,255,192,0,14,0,255,255,192,31,255,248,224,1,192,31,255,248,224,1,192,31,255,248,224,1,192,0,14,0,224,1,192,0,14,0,224,1,192,0,14,0,224,1,192,0,126,0,255,255,192,0,126,0,255,255,192,0,126,0,255,255,192,0,127,192,224,1,192,0,127,192,224,1,192,0,127,192,224,1,192,3,142,56,224,1,192,3,142,56,224,1,192,3,142,56,224,1,192,3,142,56,255,255,192,3,142,56,255,255,192,3,142,56,255,255,192,28,14,0,224,1,192,28,14,0,224,1,192,28,14,0,224,1,192,224,14,0,224,1,192,224,14,0,224,1,192,224,14,0,224,1,192,0,14,0,255,255,192,0,14,0,255,255,192,0,14,0,255,255,192,
  // 0x7c7b  类
  123,124,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,1,199,28,0,0,0,1,199,28,0,0,0,1,199,28,0,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,31,128,0,0,14,0,31,128,0,0,14,0,31,128,0,0,14,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,3,240,0,0,126,0,3,240,0,0,126,0,3,240,0,0,126,0,252,0,0,0,1,248,252,0,0,0,1,248,252,0,0,0,1,248,
  // 0x7d22  索
  34,125,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,56,0,0,56,28,0,56,0,0,56,28,0,56,0,0,56,224,1,192,3,129,192,224,1,192,3,129,192,224,1,192,3,129,192,0,127,255,252,0,0,0,127,255,252,0,0,0,127,255,252,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,1,248,0,112,0,0,1,248,0,112,0,0,1,248,0,112,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,14,0,0,0,7,0,14,0,0,0,7,0,14,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,3,129,199,0,112,0,3,129,199,0,112,0,3,129,199,0,112,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,
  // 0x7d2b  紫
  43,125,42,48,32,48,0,250,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,3,142,0,224,14,0,3,142,0,224,14,0,3,142,0,224,14,0,3,143,248,255,240,0,3,143,248,255,240,0,3,143,248,255,240,0,3,142,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,3,143,248,224,1,192,3,143,248,224,1,192,3,143,248,224,1,192,255,240,0,31,255,192,255,240,0,31,255,192,255,240,0,31,255,192,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,127,255,252,0,0,0,127,255,252,0,0,0,127,255,252,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,1,248,0,112,0,0,1,248,0,112,0,0,1,248,0,112,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,14,0,0,0,7,0,14,0,0,0,7,0,14,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,3,129,199,0,112,0,3,129,199,0,112,0,3,129,199,0,112,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,
  // 0x7ea2  红
  162,126,45,45,14,48,0,253,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,128,7,255,255,192,3,128,7,255,255,192,3,128,7,255,255,192,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,255,254,0,3,128,0,255,254,0,3,128,0,255,254,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,127,192,3,128,0,0,127,192,3,128,0,0,127,192,3,128,0,255,128,0,3,128,0,255,128,0,3,128,0,255,128,0,3,128,0,28,0,63,255,255,248,28,0,63,255,255,248,28,0,63,255,255,248,
  // 0x7ea7  级
  167,126,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,28,14,0,224,14,0,28,14,0,224,14,0,28,14,0,224,14,0,255,254,0,224,112,0,255,254,0,224,112,0,255,254,0,224,112,0,0,112,0,224,127,192,0,112,0,224,127,192,0,112,0,224,127,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,192,28,0,7,28,1,192,28,0,7,28,1,192,28,0,7,28,1,192,255,254,7,28,1,192,255,254,7,28,1,192,255,254,7,28,1,192,28,0,7,3,142,0,28,0,7,3,142,0,28,0,7,3,142,0,0,0,7,3,142,0,0,0,7,3,142,0,0,0,7,3,142,0,0,126,56,0,112,0,0,126,56,0,112,0,0,126,56,0,112,0,255,128,56,3,142,0,255,128,56,3,142,0,255,128,56,3,142,0,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,0,0,7,224,0,56,0,0,7,224,0,56,0,0,7,224,0,56,
  // 0x7ebf  线
  191,126,45,48,32,48,0,250,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,129,192,28,127,192,3,129,192,28,127,192,3,129,192,28,127,192,28,1,199,255,128,0,28,1,199,255,128,0,28,1,199,255,128,0,255,254,0,28,0,0,255,254,0,28,0,0,255,254,0,28,0,0,0,112,0,28,127,248,0,112,0,28,127,248,0,112,0,28,127,248,3,128,63,255,128,0,3,128,63,255,128,0,3,128,63,255,128,0,28,0,0,28,1,192,28,0,0,28,1,192,28,0,0,28,1,192,255,255,192,28,14,0,255,255,192,28,14,0,255,255,192,28,14,0,28,0,0,3,240,0,28,0,0,3,240,0,28,0,0,3,240,0,0,0,0,3,128,56,0,0,0,3,128,56,0,0,0,3,128,56,0,127,192,28,112,56,0,127,192,28,112,56,0,127,192,28,112,56,255,128,0,224,14,56,255,128,0,224,14,56,255,128,0,224,14,56,28,0,63,0,1,248,28,0,63,0,1,248,28,0,63,0,1,248,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,
  // 0x7ec6  细
  198,126,42,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,128,7,255,255,192,3,128,7,255,255,192,3,128,7,255,255,192,3,129,199,3,129,192,3,129,199,3,129,192,3,129,199,3,129,192,28,1,199,3,129,192,28,1,199,3,129,192,28,1,199,3,129,192,255,254,7,3,129,192,255,254,7,3,129,192,255,254,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,28,0,7,255,255,192,28,0,7,255,255,192,28,0,7,255,255,192,255,255,199,3,129,192,255,255,199,3,129,192,255,255,199,3,129,192,28,0,7,3,129,192,28,0,7,3,129,192,28,0,7,3,129,192,0,0,7,3,129,192,0,0,7,3,129,192,0,0,7,3,129,192,0,127,199,3,129,192,0,127,199,3,129,192,0,127,199,3,129,192,255,128,7,3,129,192,255,128,7,3,129,192,255,128,7,3,129,192,28,0,7,255,255,192,28,0,7,255,255,192,28,0,7,255,255,192,0,0,7,0,1,192,0,0,7,0,1,192,0,0,7,0,1,192,
  // 0x7ec8  终
  200,126,45,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,3,128,0,255,254,0,3,128,0,255,254,0,3,128,0,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,28,14,63,0,112,0,28,14,63,0,112,0,28,14,63,0,112,0,255,255,192,227,128,0,255,255,192,227,128,0,255,255,192,227,128,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,28,0,63,0,126,0,28,0,63,0,126,0,28,0,63,0,126,0,255,255,192,0,1,248,255,255,192,0,1,248,255,255,192,0,1,248,28,0,0,252,0,0,28,0,0,252,0,0,28,0,0,252,0,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,126,0,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,255,128,7,224,0,0,255,128,7,224,0,0,255,128,7,224,0,0,28,0,0,31,128,0,28,0,0,31,128,0,28,0,0,31,128,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,
  // 0x7ed3  结
  211,126,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,129,255,255,255,248,3,129,255,255,255,248,3,129,255,255,255,248,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,255,254,0,3,128,0,255,254,0,3,128,0,255,254,0,3,128,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,255,255,199,255,255,192,255,255,199,255,255,192,255,255,199,255,255,192,28,0,7,0,1,192,28,0,7,0,1,192,28,0,7,0,1,192,0,0,7,0,1,192,0,0,7,0,1,192,0,0,7,0,1,192,0,127,199,0,1,192,0,127,199,0,1,192,0,127,199,0,1,192,255,128,7,0,1,192,255,128,7,0,1,192,255,128,7,0,1,192,28,0,7,255,255,192,28,0,7,255,255,192,28,0,7,255,255,192,0,0,7,0,1,192,0,0,7,0,1,192,0,0,7,0,1,192,
  // 0x7ed9  给
  217,126,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,28,14,56,0,14,0,28,14,56,0,14,0,28,14,56,0,14,0,255,241,192,0,1,248,255,241,192,0,1,248,255,241,192,0,1,248,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,255,254,63,255,254,0,255,254,63,255,254,0,255,254,63,255,254,0,28,0,56,0,14,0,28,0,56,0,14,0,28,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,126,56,0,14,0,0,126,56,0,14,0,0,126,56,0,14,0,255,128,56,0,14,0,255,128,56,0,14,0,255,128,56,0,14,0,28,0,63,255,254,0,28,0,63,255,254,0,28,0,63,255,254,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,
  // 0x7edf  统
  223,126,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,63,255,255,248,3,128,63,255,255,248,3,128,63,255,255,248,28,14,0,28,0,0,28,14,0,28,0,0,28,14,0,28,0,0,255,254,0,224,14,0,255,254,0,224,14,0,255,254,0,224,14,0,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,3,128,63,255,255,248,3,128,63,255,255,248,3,128,63,255,255,248,28,0,0,224,112,56,28,0,0,224,112,56,28,0,0,224,112,56,255,254,0,224,112,0,255,254,0,224,112,0,255,254,0,224,112,0,28,0,0,224,112,0,28,0,0,224,112,0,28,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,0,126,7,0,112,56,0,126,7,0,112,56,0,126,7,0,112,56,255,128,7,0,112,56,255,128,7,0,112,56,255,128,7,0,112,56,28,0,56,0,15,248,28,0,56,0,15,248,28,0,56,0,15,248,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,
  // 0x7ee7  继
  231,126,45,45,14,48,0,253,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,63,3,129,192,3,128,63,3,129,192,3,128,63,3,129,192,28,14,56,227,142,0,28,14,56,227,142,0,28,14,56,227,142,0,255,240,56,3,128,0,255,240,56,3,128,0,255,240,56,3,128,0,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,28,0,56,31,240,0,28,0,56,31,240,0,28,0,56,31,240,0,255,254,56,227,142,0,255,254,56,227,142,0,255,254,56,227,142,0,28,0,63,3,129,192,28,0,63,3,129,192,28,0,63,3,129,192,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,3,128,0,0,126,56,3,128,0,0,126,56,3,128,0,0,126,56,3,128,0,255,128,56,3,128,0,255,128,56,3,128,0,255,128,56,3,128,0,28,0,63,255,255,248,28,0,63,255,255,248,28,0,63,255,255,248,
  // 0x7eea  绪
  234,126,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,3,128,63,255,241,192,3,128,63,255,241,192,3,128,63,255,241,192,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,28,14,0,28,112,0,28,14,0,28,112,0,28,14,0,28,112,0,255,241,255,255,255,248,255,241,255,255,255,248,255,241,255,255,255,248,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,28,0,7,255,254,0,28,0,7,255,254,0,28,0,7,255,254,0,255,254,63,0,14,0,255,254,63,0,14,0,255,254,63,0,14,0,28,1,199,0,14,0,28,1,199,0,14,0,28,1,199,0,14,0,0,0,7,255,254,0,0,0,7,255,254,0,0,0,7,255,254,0,0,126,7,0,14,0,0,126,7,0,14,0,0,126,7,0,14,0,255,128,7,0,14,0,255,128,7,0,14,0,255,128,7,0,14,0,28,0,7,255,254,0,28,0,7,255,254,0,28,0,7,255,254,0,0,0,7,0,14,0,0,0,7,0,14,0,0,0,7,0,14,0,
  // 0x7eed  续
  237,126,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,7,255,255,192,3,128,7,255,255,192,3,128,7,255,255,192,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,28,1,192,3,128,0,255,254,63,255,255,248,255,254,63,255,255,248,255,254,63,255,255,248,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,3,128,0,224,113,192,3,128,0,224,113,192,3,128,0,224,113,192,28,0,0,28,112,0,28,0,0,28,112,0,28,0,0,28,112,0,255,255,199,0,112,0,255,255,199,0,112,0,255,255,199,0,112,0,28,0,0,224,112,0,28,0,0,224,112,0,28,0,0,224,112,0,0,0,63,255,255,248,0,0,63,255,255,248,0,0,63,255,255,248,0,127,192,3,142,0,0,127,192,3,142,0,0,127,192,3,142,0,255,128,0,28,1,192,255,128,0,28,1,192,255,128,0,28,1,192,28,0,0,224,0,56,28,0,0,224,0,56,28,0,0,224,0,56,0,0,63,0,0,56,0,0,63,0,0,56,0,0,63,0,0,56,
  // 0x7eff  绿
  255,126,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,28,14,7,255,254,0,28,14,7,255,254,0,28,14,7,255,254,0,255,254,0,0,14,0,255,254,0,0,14,0,255,254,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,3,128,63,255,255,248,3,128,63,255,255,248,3,128,63,255,255,248,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,255,254,56,3,128,56,255,254,56,3,128,56,255,254,56,3,128,56,28,0,7,31,241,192,28,0,7,31,241,192,28,0,7,31,241,192,0,0,0,227,142,0,0,0,0,227,142,0,0,0,0,227,142,0,0,126,7,3,129,192,0,126,7,3,129,192,0,126,7,3,129,192,255,128,56,3,128,56,255,128,56,3,128,56,255,128,56,3,128,56,28,0,0,227,128,0,28,0,0,227,128,0,28,0,0,227,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x7f16  编
  22,127,42,48,32,48,0,250,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,128,63,255,255,192,3,128,63,255,255,192,3,128,63,255,255,192,3,128,56,0,1,192,3,128,56,0,1,192,3,128,56,0,1,192,28,14,56,0,1,192,28,14,56,0,1,192,28,14,56,0,1,192,255,254,63,255,255,192,255,254,63,255,255,192,255,254,63,255,255,192,0,112,56,0,0,0,0,112,56,0,0,0,0,112,56,0,0,0,3,128,56,0,0,0,3,128,56,0,0,0,3,128,56,0,0,0,28,0,63,255,255,192,28,0,63,255,255,192,28,0,63,255,255,192,255,254,63,28,113,192,255,254,63,28,113,192,255,254,63,28,113,192,28,0,63,28,113,192,28,0,63,28,113,192,28,0,63,28,113,192,0,1,199,255,255,192,0,1,199,255,255,192,0,1,199,255,255,192,0,127,199,28,113,192,0,127,199,28,113,192,0,127,199,28,113,192,255,129,199,28,113,192,255,129,199,28,113,192,255,129,199,28,113,192,28,14,7,28,1,192,28,14,7,28,1,192,28,14,7,28,1,192,0,0,7,0,15,192,0,0,7,0,15,192,0,0,7,0,15,192,
  // 0x7f3a  缺
  58,127,45,48,32,48,0,250,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,255,192,3,128,0,3,255,192,3,128,0,3,255,192,3,128,0,28,112,7,255,255,192,28,112,7,255,255,192,28,112,7,255,255,192,224,112,0,3,129,192,224,112,0,3,129,192,224,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,255,255,248,3,129,192,255,255,248,3,129,192,255,255,248,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,28,112,0,28,113,192,28,112,0,28,113,192,28,112,0,28,113,192,28,112,0,28,113,192,28,112,0,28,113,192,28,112,0,28,127,192,224,14,0,28,127,192,224,14,0,28,127,192,224,14,0,31,129,192,224,14,0,31,129,192,224,14,0,31,129,192,224,14,0,0,1,199,0,1,192,0,1,199,0,1,192,0,1,199,0,1,192,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,
  // 0x7f51  网
  81,127,39,45,225,48,3,250,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,1,192,3,142,224,1,192,3,142,224,1,192,3,142,227,129,199,3,142,227,129,199,3,142,227,129,199,3,142,224,113,192,227,142,224,113,192,227,142,224,113,192,227,142,224,14,0,28,14,224,14,0,28,14,224,14,0,28,14,224,14,0,28,14,224,14,0,28,14,224,14,0,28,14,224,113,192,227,142,224,113,192,227,142,224,113,192,227,142,224,113,192,227,142,224,113,192,227,142,224,113,192,227,142,227,129,199,3,142,227,129,199,3,142,227,129,199,3,142,252,0,56,0,14,252,0,56,0,14,252,0,56,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x7f6e  置
  110,127,45,48,32,48,0,250,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x7f72  署
  114,127,45,45,14,48,0,250,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,127,255,252,112,0,0,127,255,252,112,0,0,127,255,252,112,0,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,3,128,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,63,0,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,3,254,0,0,112,0,3,254,0,0,112,0,3,254,0,0,112,0,252,15,255,255,240,0,252,15,255,255,240,0,252,15,255,255,240,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,
  // 0x8005  者
  5,128,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,3,255,255,252,112,0,3,255,255,252,112,0,3,255,255,252,112,0,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,3,128,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,126,0,0,112,0,0,126,0,0,112,0,0,126,0,0,112,0,3,142,0,0,112,0,3,142,0,0,112,0,3,142,0,0,112,0,28,15,255,255,240,0,28,15,255,255,240,0,28,15,255,255,240,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,
  // 0x806a  聪
  106,128,45,48,32,48,0,250,0,0,0,224,14,0,0,0,0,224,14,0,0,0,0,224,14,0,255,255,192,28,14,0,255,255,192,28,14,0,255,255,192,28,14,0,28,14,0,28,112,0,28,14,0,28,112,0,28,14,0,28,112,0,28,14,7,255,255,192,28,14,7,255,255,192,28,14,7,255,255,192,31,254,7,0,1,192,31,254,7,0,1,192,31,254,7,0,1,192,28,14,7,0,1,192,28,14,7,0,1,192,28,14,7,0,1,192,28,14,7,0,1,192,28,14,7,0,1,192,28,14,7,0,1,192,31,254,7,255,255,192,31,254,7,255,255,192,31,254,7,255,255,192,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,15,192,28,113,192,28,15,192,28,113,192,28,15,192,28,113,192,31,254,7,28,0,56,31,254,7,28,0,56,31,254,7,28,0,56,252,14,7,28,0,56,252,14,7,28,0,56,252,14,7,28,0,56,0,14,7,28,14,56,0,14,7,28,14,56,0,14,7,28,14,56,0,14,56,3,254,0,0,14,56,3,254,0,0,14,56,3,254,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,
  // 0x80fd  能
  253,128,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,28,0,56,28,14,0,28,0,56,28,14,0,28,0,56,28,14,0,255,255,255,31,240,0,255,255,255,31,240,0,255,255,255,31,240,0,0,0,7,28,0,0,0,0,7,28,0,0,0,0,7,28,0,0,0,0,0,28,0,56,0,0,0,28,0,56,0,0,0,28,0,56,31,255,248,28,0,56,31,255,248,28,0,56,31,255,248,28,0,56,28,0,56,3,255,248,28,0,56,3,255,248,28,0,56,3,255,248,28,0,56,0,0,0,28,0,56,0,0,0,28,0,56,0,0,0,31,255,248,28,1,192,31,255,248,28,1,192,31,255,248,28,1,192,28,0,56,28,14,0,28,0,56,28,14,0,28,0,56,28,14,0,28,0,56,31,240,0,28,0,56,31,240,0,28,0,56,31,240,0,31,255,248,28,0,0,31,255,248,28,0,0,31,255,248,28,0,0,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,14,56,28,0,56,28,14,56,28,0,56,28,14,56,28,0,56,28,1,192,3,255,248,28,1,192,3,255,248,28,1,192,3,255,248,
  // 0x81ea  自
  234,129,27,48,192,48,9,250,0,14,0,0,0,14,0,0,0,14,0,0,0,112,0,0,0,112,0,0,0,112,0,0,3,128,0,0,3,128,0,0,3,128,0,0,255,255,255,224,255,255,255,224,255,255,255,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,255,255,255,224,255,255,255,224,255,255,255,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,255,255,255,224,255,255,255,224,255,255,255,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,224,0,0,224,255,255,255,224,255,255,255,224,255,255,255,224,224,0,0,224,224,0,0,224,224,0,0,224,
  // 0x81f3  至
  243,129,45,42,252,48,0,253,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x83dc  菜
  220,131,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,255,254,0,0,0,0,255,254,0,0,0,0,255,254,0,3,255,255,0,0,0,3,255,255,0,0,0,3,255,255,0,0,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,1,199,28,0,0,0,1,199,28,0,0,0,1,199,28,0,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,3,240,7,0,126,0,3,240,7,0,126,0,3,240,7,0,126,0,252,0,7,0,1,248,252,0,7,0,1,248,252,0,7,0,1,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,
  // 0x84dd  蓝
  221,132,45,45,14,48,0,253,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,255,255,192,3,129,192,255,255,192,3,129,192,255,255,192,3,129,192,227,128,0,3,129,192,227,128,0,3,129,192,227,128,0,3,129,199,0,112,0,3,129,199,0,112,0,3,129,199,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x86c7  蛇
  199,134,45,45,14,48,0,253,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,255,199,255,255,248,31,255,199,255,255,248,31,255,199,255,255,248,28,113,199,0,0,56,28,113,199,0,0,56,28,113,199,0,0,56,28,113,248,0,1,192,28,113,248,0,1,192,28,113,248,0,1,192,28,113,192,224,0,0,28,113,192,224,0,0,28,113,192,224,0,0,28,113,192,224,14,0,28,113,192,224,14,0,28,113,192,224,14,0,31,255,192,224,112,0,31,255,192,224,112,0,31,255,192,224,112,0,28,112,0,227,128,0,28,112,0,227,128,0,28,112,0,227,128,0,0,112,0,252,0,0,0,112,0,252,0,0,0,112,0,252,0,0,0,113,192,224,0,56,0,113,192,224,0,56,0,113,192,224,0,56,0,127,248,224,0,56,0,127,248,224,0,56,0,127,248,224,0,56,255,128,56,224,0,56,255,128,56,224,0,56,255,128,56,224,0,56,28,0,0,31,255,248,28,0,0,31,255,248,28,0,0,31,255,248,
  // 0x884c  行
  76,136,45,48,32,48,0,250,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,7,255,255,192,0,14,7,255,255,192,0,14,7,255,255,192,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,28,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,3,240,0,3,128,0,3,240,0,3,128,0,3,240,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,
  // 0x88ab  被
  171,136,45,48,32,48,0,250,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,254,7,255,255,248,255,254,7,255,255,248,255,254,7,255,255,248,0,14,7,0,112,56,0,14,7,0,112,56,0,14,7,0,112,56,0,112,7,0,113,192,0,112,7,0,113,192,0,112,7,0,113,192,0,113,199,0,112,0,0,113,199,0,112,0,0,113,199,0,112,0,3,254,7,255,255,192,3,254,7,255,255,192,3,254,7,255,255,192,28,113,199,28,1,192,28,113,199,28,1,192,28,113,199,28,1,192,224,112,7,28,1,192,224,112,7,28,1,192,224,112,7,28,1,192,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,3,142,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,113,192,224,0,56,0,113,192,224,0,56,0,113,192,224,0,56,
  // 0x88c5  装
  197,136,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,3,142,63,255,255,248,3,142,63,255,255,248,3,142,63,255,255,248,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,126,0,3,128,0,0,126,0,3,128,0,0,126,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,252,14,7,255,255,192,252,14,7,255,255,192,252,14,7,255,255,192,0,14,56,0,0,0,0,14,56,0,0,0,0,14,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,199,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,15,192,224,14,0,0,15,192,224,14,0,0,15,192,224,14,0,3,241,192,28,112,0,3,241,192,28,112,0,3,241,192,28,112,0,252,1,199,3,240,0,252,1,199,3,240,0,252,1,199,3,240,0,0,1,248,0,15,248,0,1,248,0,15,248,0,1,248,0,15,248,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,
  // 0x8981  要
  129,137,39,45,225,48,3,250,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,28,14,0,224,112,28,14,0,224,112,28,14,0,224,112,28,14,0,224,112,28,14,0,224,112,28,14,0,224,112,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,14,0,28,0,0,14,0,28,0,0,14,0,28,0,0,112,0,224,0,0,112,0,224,0,0,112,0,224,0,3,254,7,0,0,3,254,7,0,0,3,254,7,0,0,0,1,255,0,0,0,1,255,0,0,0,1,255,0,0,0,15,192,255,128,0,15,192,255,128,0,15,192,255,128,31,240,0,0,112,31,240,0,0,112,31,240,0,0,112,
  // 0x89d2  角
  210,137,39,48,240,48,0,250,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,127,255,255,128,0,127,255,255,128,0,127,255,255,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,227,255,255,255,254,227,255,255,255,254,227,255,255,255,254,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,7,0,14,3,128,7,0,14,3,128,7,0,14,28,0,7,0,14,28,0,7,0,14,28,0,7,0,14,28,0,7,3,142,28,0,7,3,142,28,0,7,3,142,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x8ba1  计
  161,139,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,241,255,255,255,248,255,241,255,255,255,248,255,241,255,255,255,248,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,192,28,0,0,0,113,192,28,0,0,0,113,192,28,0,0,0,126,0,28,0,0,0,126,0,28,0,0,0,126,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x8bae  议
  174,139,45,48,32,48,0,250,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,255,240,7,0,112,0,255,240,7,0,112,0,255,240,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,113,192,28,0,0,0,113,192,28,0,0,0,113,192,28,0,0,0,126,0,227,128,0,0,126,0,227,128,0,0,126,0,227,128,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,15,192,0,1,248,0,15,192,0,1,248,0,15,192,0,1,248,
  // 0x8bbe  设
  190,139,45,45,14,48,0,250,3,128,7,255,240,0,3,128,7,255,240,0,3,128,7,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,7,0,112,0,0,0,56,0,15,248,0,0,56,0,15,248,0,0,56,0,15,248,255,241,192,0,0,0,255,241,192,0,0,0,255,241,192,0,0,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,113,192,227,128,0,0,113,192,227,128,0,0,113,192,227,128,0,0,126,0,28,0,0,0,126,0,28,0,0,0,126,0,28,0,0,0,112,0,227,128,0,0,112,0,227,128,0,0,112,0,227,128,0,0,0,63,0,126,0,0,0,63,0,126,0,0,0,63,0,126,0,0,15,192,0,1,248,0,15,192,0,1,248,0,15,192,0,1,248,
  // 0x8bd5  试
  213,139,45,48,32,48,0,250,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,1,255,255,255,248,0,1,255,255,255,248,0,1,255,255,255,248,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,255,240,0,3,128,0,255,240,0,3,128,0,255,240,0,3,128,0,0,113,255,255,128,0,0,113,255,255,128,0,0,113,255,255,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,113,199,0,112,0,0,113,199,0,112,0,0,113,199,0,112,0,0,126,7,252,14,56,0,126,7,252,14,56,0,126,7,252,14,56,0,113,255,0,14,56,0,113,255,0,14,56,0,113,255,0,14,56,0,0,56,0,1,248,0,0,56,0,1,248,0,0,56,0,1,248,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,
  // 0x8bef  误
  239,139,45,45,14,48,0,250,28,0,63,255,254,0,28,0,63,255,254,0,28,0,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,129,255,255,255,192,255,129,255,255,255,192,255,129,255,255,255,192,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,143,255,255,255,248,3,143,255,255,255,248,3,143,255,255,255,248,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,142,0,227,128,0,3,142,0,227,128,0,3,142,0,227,128,0,3,240,7,0,112,0,3,240,7,0,112,0,3,240,7,0,112,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,0,1,192,0,1,248,0,1,192,0,1,248,0,1,192,0,1,248,
  // 0x8bf7  请
  247,139,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,129,255,255,255,248,255,129,255,255,255,248,255,129,255,255,255,248,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,142,63,255,254,0,3,142,63,255,254,0,3,142,63,255,254,0,3,240,56,0,14,0,3,240,56,0,14,0,3,240,56,0,14,0,3,128,56,3,142,0,3,128,56,3,142,0,3,128,56,3,142,0,0,0,56,0,112,0,0,0,56,0,112,0,0,0,56,0,112,0,
  // 0x8bfb  读
  251,139,45,48,32,48,0,250,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,63,255,255,248,0,0,63,255,255,248,0,0,63,255,255,248,255,240,0,0,0,56,255,240,0,0,0,56,255,240,0,0,0,56,0,112,0,224,113,192,0,112,0,224,113,192,0,112,0,224,113,192,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,0,113,192,3,142,0,0,113,192,3,142,0,0,113,192,3,142,0,0,126,0,28,1,192,0,126,0,28,1,192,0,126,0,28,1,192,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,0,63,0,0,56,0,0,63,0,0,56,0,0,63,0,0,56,
  // 0x8c03  调
  3,140,42,45,14,48,0,250,28,1,255,255,255,192,28,1,255,255,255,192,28,1,255,255,255,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,3,129,192,28,1,192,0,1,199,255,241,192,0,1,199,255,241,192,0,1,199,255,241,192,0,1,192,28,1,192,0,1,192,28,1,192,0,1,192,28,1,192,255,129,192,28,1,192,255,129,192,28,1,192,255,129,192,28,1,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,199,255,241,192,3,129,199,255,241,192,3,129,199,255,241,192,3,129,199,0,113,192,3,129,199,0,113,192,3,129,199,0,113,192,3,143,199,0,113,192,3,143,199,0,113,192,3,143,199,0,113,192,3,241,199,255,241,192,3,241,199,255,241,192,3,241,199,255,241,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,0,1,192,0,113,192,0,1,192,0,113,192,0,1,192,0,113,192,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,
  // 0x8d25  败
  37,141,45,48,32,48,0,250,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,31,255,192,28,0,0,31,255,192,28,0,0,31,255,192,28,0,0,28,1,192,28,0,0,28,1,192,28,0,0,28,1,192,28,0,0,28,113,192,224,0,0,28,113,192,224,0,0,28,113,192,224,0,0,28,113,192,255,255,248,28,113,192,255,255,248,28,113,192,255,255,248,28,113,199,0,14,0,28,113,199,0,14,0,28,113,199,0,14,0,28,113,248,224,14,0,28,113,248,224,14,0,28,113,248,224,14,0,28,113,192,224,14,0,28,113,192,224,14,0,28,113,192,224,14,0,28,113,192,224,14,0,28,113,192,224,14,0,28,113,192,224,14,0,28,113,192,28,112,0,28,113,192,28,112,0,28,113,192,28,112,0,28,113,192,28,112,0,28,113,192,28,112,0,28,113,192,28,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,142,0,28,112,0,3,142,0,28,112,0,3,142,0,28,112,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,28,1,199,0,1,192,28,1,199,0,1,192,28,1,199,0,1,192,224,0,56,0,0,56,224,0,56,0,0,56,224,0,56,0,0,56,
  // 0x8d2a  贪
  42,141,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,3,240,0,224,126,0,3,240,0,224,126,0,3,240,0,224,126,0,252,15,255,255,129,248,252,15,255,255,129,248,252,15,255,255,129,248,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,0,56,31,128,0,0,0,56,31,128,0,0,0,56,31,128,0,0,15,192,0,126,0,0,15,192,0,126,0,0,15,192,0,126,0,31,240,0,0,1,192,31,240,0,0,1,192,31,240,0,0,1,192,
  // 0x8d77  起
  119,141,45,48,32,48,0,250,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,255,254,0,0,14,0,255,254,0,0,14,0,255,254,0,31,255,248,0,14,0,31,255,248,0,14,0,31,255,248,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,255,255,248,255,254,0,255,255,248,255,254,0,255,255,248,255,254,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,3,142,0,224,0,0,3,142,0,224,0,0,3,142,0,224,0,0,3,142,0,224,0,0,3,142,0,224,0,0,3,142,0,224,0,0,3,143,248,224,1,192,3,143,248,224,1,192,3,143,248,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,3,142,0,31,255,192,3,142,0,31,255,192,3,142,0,31,255,192,28,126,0,0,0,0,28,126,0,0,0,0,28,126,0,0,0,0,28,15,255,255,255,248,28,15,255,255,255,248,28,15,255,255,255,248,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,
  // 0x8d85  超
  133,141,45,48,32,48,0,250,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,7,255,255,192,0,14,7,255,255,192,0,14,7,255,255,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,31,255,248,28,1,192,31,255,248,28,1,192,31,255,248,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,28,1,192,0,14,0,224,113,192,0,14,0,224,113,192,0,14,0,224,113,192,255,255,255,0,14,0,255,255,255,0,14,0,255,255,255,0,14,0,0,14,0,255,255,192,0,14,0,255,255,192,0,14,0,255,255,192,3,142,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,3,142,0,224,1,192,3,143,248,224,1,192,3,143,248,224,1,192,3,143,248,224,1,192,3,142,0,255,255,192,3,142,0,255,255,192,3,142,0,255,255,192,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,126,0,0,0,0,28,126,0,0,0,0,28,126,0,0,0,0,28,15,255,255,255,248,28,15,255,255,255,248,28,15,255,255,255,248,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,
  // 0x8ddd  距
  221,141,45,42,252,48,0,253,31,255,199,255,255,248,31,255,199,255,255,248,31,255,199,255,255,248,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,28,1,199,0,0,0,31,255,199,255,255,192,31,255,199,255,255,192,31,255,199,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,28,127,199,0,1,192,28,127,199,0,1,192,28,127,199,0,1,192,28,112,7,0,1,192,28,112,7,0,1,192,28,112,7,0,1,192,28,112,7,255,255,192,28,112,7,255,255,192,28,112,7,255,255,192,28,112,7,0,0,0,28,112,7,0,0,0,28,112,7,0,0,0,28,127,199,0,0,0,28,127,199,0,0,0,28,127,199,0,0,0,255,128,7,0,0,0,255,128,7,0,0,0,255,128,7,0,0,0,0,0,7,255,255,248,0,0,7,255,255,248,0,0,7,255,255,248,
  // 0x8f6c  转
  108,143,45,48,32,48,0,250,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,255,255,199,255,255,192,255,255,199,255,255,192,255,255,199,255,255,192,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,112,0,28,0,0,28,112,0,28,0,0,28,112,0,28,0,0,224,112,63,255,255,248,224,112,63,255,255,248,224,112,63,255,255,248,255,255,192,28,0,0,255,255,192,28,0,0,255,255,192,28,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,127,192,0,1,192,0,127,192,0,1,192,0,127,192,0,1,192,255,240,0,224,14,0,255,240,0,224,14,0,255,240,0,224,14,0,28,112,0,28,112,0,28,112,0,28,112,0,28,112,0,28,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x8f6f  软
  111,143,45,48,32,48,0,250,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,255,255,248,31,255,192,255,255,248,31,255,192,255,255,248,31,255,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,192,3,142,0,224,14,0,3,142,0,224,14,0,3,142,0,224,14,0,28,14,7,3,128,0,28,14,7,3,128,0,28,14,7,3,128,0,31,255,248,3,128,0,31,255,248,3,128,0,31,255,248,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,28,112,0,0,14,0,28,112,0,0,14,0,28,112,0,0,15,248,28,112,0,0,15,248,28,112,0,0,15,248,28,112,0,255,254,0,28,112,0,255,254,0,28,112,0,255,254,0,28,112,0,28,14,0,224,14,0,28,14,0,224,14,0,28,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,7,0,1,192,0,14,7,0,1,192,0,14,7,0,1,192,0,14,56,0,0,56,0,14,56,0,0,56,0,14,56,0,0,56,
  // 0x8f74  轴
  116,143,42,48,32,48,0,250,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,255,255,192,3,128,0,28,0,7,255,255,192,28,0,7,255,255,192,28,0,7,255,255,192,28,112,7,3,129,192,28,112,7,3,129,192,28,112,7,3,129,192,224,112,7,3,129,192,224,112,7,3,129,192,224,112,7,3,129,192,255,255,199,3,129,192,255,255,199,3,129,192,255,255,199,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,127,199,3,129,192,0,127,199,3,129,192,0,127,199,3,129,192,255,240,7,3,129,192,255,240,7,3,129,192,255,240,7,3,129,192,28,112,7,3,129,192,28,112,7,3,129,192,28,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,
  // 0x8f7d  载
  125,143,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,142,0,0,14,0,3,142,0,0,14,0,3,142,0,31,255,255,3,129,192,31,255,255,3,129,192,31,255,255,3,129,192,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,255,255,255,3,129,192,255,255,255,3,129,192,255,255,255,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,3,128,0,3,129,192,28,14,0,3,142,0,28,14,0,3,142,0,28,14,0,3,142,0,31,255,255,3,142,0,31,255,255,3,142,0,31,255,255,3,142,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,15,255,0,112,56,0,15,255,0,112,56,0,15,255,0,112,56,255,254,0,3,142,56,255,254,0,3,142,56,255,254,0,3,142,56,0,14,0,28,1,248,0,14,0,28,1,248,0,14,0,28,1,248,0,14,0,224,0,56,0,14,0,224,0,56,0,14,0,224,0,56,
  // 0x8f91  辑
  145,143,45,48,32,48,0,250,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,7,255,254,0,3,128,7,255,254,0,3,128,7,255,254,0,3,128,7,0,14,0,3,128,7,0,14,0,3,128,7,0,14,0,255,255,199,0,14,0,255,255,199,0,14,0,255,255,199,0,14,0,28,0,7,255,254,0,28,0,7,255,254,0,28,0,7,255,254,0,28,112,0,0,0,0,28,112,0,0,0,0,28,112,0,0,0,0,224,113,255,255,255,248,224,113,255,255,255,248,224,113,255,255,255,248,255,255,199,0,14,0,255,255,199,0,14,0,255,255,199,0,14,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,0,127,199,255,254,0,0,127,199,255,254,0,0,127,199,255,254,0,255,240,7,0,14,0,255,240,7,0,14,0,255,240,7,0,14,0,28,112,7,3,255,248,28,112,7,3,255,248,28,112,7,3,255,248,0,113,255,252,14,0,0,113,255,252,14,0,0,113,255,252,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,
  // 0x8f93  输
  147,143,45,48,32,48,0,250,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,0,227,128,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,255,254,56,0,14,0,255,254,56,0,14,0,255,254,56,0,14,0,3,129,199,255,241,248,3,129,199,255,241,248,3,129,199,255,241,248,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,112,63,252,1,192,28,112,63,252,1,192,28,112,63,252,1,192,224,112,56,28,113,192,224,112,56,28,113,192,224,112,56,28,113,192,255,254,56,28,113,192,255,254,56,28,113,192,255,254,56,28,113,192,0,112,63,252,113,192,0,112,63,252,113,192,0,112,63,252,113,192,0,126,56,28,113,192,0,126,56,28,113,192,0,126,56,28,113,192,255,240,56,28,113,192,255,240,56,28,113,192,255,240,56,28,113,192,28,112,63,252,113,192,28,112,63,252,113,192,28,112,63,252,113,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,113,192,0,112,56,28,113,192,0,112,56,28,113,192,0,112,56,252,14,0,0,112,56,252,14,0,0,112,56,252,14,0,
  // 0x8fb9  边
  185,143,45,45,14,48,0,253,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,0,0,0,28,1,192,255,240,0,28,1,192,255,240,0,28,1,192,255,240,0,28,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,0,224,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,0,113,192,0,112,0,0,113,192,0,112,0,0,113,192,0,112,0,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x8fc1  迁
  193,143,45,45,14,48,0,253,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,3,128,0,31,254,0,3,128,0,31,254,0,3,128,0,31,254,0,0,112,63,252,0,0,0,112,63,252,0,0,0,112,63,252,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,241,255,255,255,248,255,241,255,255,255,248,255,241,255,255,255,248,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x8fd0  运
  208,143,45,42,252,48,0,253,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,255,192,0,1,255,255,255,192,0,1,255,255,255,192,255,240,0,28,0,0,255,240,0,28,0,0,255,240,0,28,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,0,112,56,0,1,192,0,112,56,0,1,192,0,112,56,0,1,192,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x8fd1  近
  209,143,45,45,14,48,0,253,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,3,128,0,0,127,192,3,128,0,0,127,192,3,128,0,0,127,192,0,112,7,255,128,0,0,112,7,255,128,0,0,112,7,255,128,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,255,255,248,0,0,7,255,255,248,0,0,7,255,255,248,255,240,7,0,112,0,255,240,7,0,112,0,255,240,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,113,192,0,112,0,0,113,192,0,112,0,0,113,192,0,112,0,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x8fd4  返
  212,143,45,45,14,48,0,253,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,3,128,0,3,255,192,3,128,0,3,255,192,3,128,0,3,255,192,0,112,63,252,0,0,0,112,63,252,0,0,0,112,63,252,0,0,0,112,56,0,0,0,0,112,56,0,0,0,0,112,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,63,255,255,192,0,0,63,255,255,192,0,0,63,255,255,192,255,240,56,0,1,192,255,240,56,0,1,192,255,240,56,0,1,192,0,112,56,224,14,0,0,112,56,224,14,0,0,112,56,224,14,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,28,112,0,0,113,192,224,14,0,0,113,192,224,14,0,0,113,192,224,14,0,0,113,199,0,1,192,0,113,199,0,1,192,0,113,199,0,1,192,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x8fd8  还
  216,143,45,42,252,48,0,253,3,128,63,255,255,192,3,128,63,255,255,192,3,128,63,255,255,192,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,240,0,252,112,0,255,240,0,252,112,0,255,240,0,252,112,0,0,112,7,28,14,0,0,112,7,28,14,0,0,112,7,28,14,0,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x8fdb  进
  219,143,45,45,14,48,0,253,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,3,128,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,63,255,255,192,0,112,63,255,255,192,0,112,63,255,255,192,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,255,240,0,224,112,0,255,240,0,224,112,0,255,240,0,224,112,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,0,224,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x8fde  连
  222,143,45,45,14,48,0,253,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,0,0,227,128,0,0,0,0,227,128,0,0,0,0,227,128,0,0,0,7,3,128,0,0,0,7,3,128,0,0,0,7,3,128,0,255,240,63,255,255,192,255,240,63,255,255,192,255,240,63,255,255,192,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,113,255,255,255,248,0,113,255,255,255,248,0,113,255,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x8ff7  迷
  247,143,45,45,14,48,0,253,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,128,56,28,14,0,3,128,56,28,14,0,3,128,56,28,14,0,0,112,7,28,14,0,0,112,7,28,14,0,0,112,7,28,14,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,7,28,112,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,1,255,255,255,192,0,1,255,255,255,192,0,1,255,255,255,192,255,240,0,28,0,0,255,240,0,28,0,0,255,240,0,28,0,0,0,112,0,255,128,0,0,112,0,255,128,0,0,112,0,255,128,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x9000  退
  0,144,45,45,14,48,0,253,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,56,0,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,255,240,63,255,254,0,255,240,63,255,254,0,255,240,63,255,254,0,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,28,1,192,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,0,112,0,0,112,56,224,14,0,0,112,56,224,14,0,0,112,56,224,14,0,0,112,63,0,1,192,0,112,63,0,1,192,0,112,63,0,1,192,0,112,56,0,1,192,0,112,56,0,1,192,0,112,56,0,1,192,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x9009  选
  9,144,45,45,14,48,0,253,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,128,56,28,0,0,3,128,56,28,0,0,3,128,56,28,0,0,0,112,56,28,0,0,0,112,56,28,0,0,0,112,56,28,0,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,255,241,255,255,255,192,255,241,255,255,255,192,255,241,255,255,255,192,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,7,3,128,0,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,112,56,3,129,192,0,113,192,0,127,192,0,113,192,0,127,192,0,113,192,0,127,192,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x901f  速
  31,144,45,45,14,48,0,253,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,0,113,255,255,255,192,0,113,255,255,255,192,0,113,255,255,255,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,63,255,254,0,0,0,56,28,14,0,0,0,56,28,14,0,0,0,56,28,14,0,255,240,56,28,14,0,255,240,56,28,14,0,255,240,56,28,14,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,63,255,254,0,0,112,0,255,128,0,0,112,0,255,128,0,0,112,0,255,128,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,7,28,112,0,0,112,56,28,14,0,0,112,56,28,14,0,0,112,56,28,14,0,0,113,192,28,1,192,0,113,192,28,1,192,0,113,192,28,1,192,0,112,0,28,0,0,0,112,0,28,0,0,0,112,0,28,0,0,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,
  // 0x90e8  部
  232,144,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,14,0,3,255,248,0,14,0,3,255,248,0,14,0,3,255,248,31,255,255,227,128,56,31,255,255,227,128,56,31,255,255,227,128,56,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,0,112,56,3,142,0,0,112,56,3,142,0,0,112,56,3,142,0,255,255,255,255,129,192,255,255,255,255,129,192,255,255,255,255,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,128,56,0,0,0,3,128,56,0,0,0,3,128,56,3,255,255,3,128,56,3,255,255,3,128,56,3,255,255,3,128,56,3,128,7,3,128,56,3,128,7,3,128,56,3,128,7,3,128,56,3,128,7,3,241,192,3,128,7,3,241,192,3,128,7,3,241,192,3,128,7,3,142,0,3,128,7,3,142,0,3,128,7,3,142,0,3,255,255,3,128,0,3,255,255,3,128,0,3,255,255,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,3,128,7,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0x914d  配
  77,145,45,45,14,48,0,250,255,255,248,0,0,0,255,255,248,0,0,0,255,255,248,0,0,0,3,142,0,255,254,0,3,142,0,255,254,0,3,142,0,255,254,0,3,142,0,0,14,0,3,142,0,0,14,0,3,142,0,0,14,0,255,255,248,0,14,0,255,255,248,0,14,0,255,255,248,0,14,0,227,142,56,0,14,0,227,142,56,0,14,0,227,142,56,0,14,0,227,142,56,0,14,0,227,142,56,0,14,0,227,142,56,0,14,0,227,142,56,255,254,0,227,142,56,255,254,0,227,142,56,255,254,0,227,143,248,224,14,0,227,143,248,224,14,0,227,143,248,224,14,0,252,0,56,224,0,0,252,0,56,224,0,0,252,0,56,224,0,0,224,0,56,224,0,0,224,0,56,224,0,0,224,0,56,224,0,0,255,255,248,224,0,0,255,255,248,224,0,0,255,255,248,224,0,0,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,255,255,248,31,255,248,255,255,248,31,255,248,255,255,248,31,255,248,224,0,56,0,0,0,224,0,56,0,0,0,224,0,56,0,0,0,
  // 0x91ca  释
  202,145,45,48,32,48,0,250,0,15,192,0,0,0,0,15,192,0,0,0,0,15,192,0,0,0,255,240,63,255,255,192,255,240,63,255,255,192,255,240,63,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,28,113,192,224,14,0,28,113,192,224,14,0,28,113,192,224,14,0,3,254,0,28,112,0,3,254,0,28,112,0,3,254,0,28,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,255,255,192,252,126,0,255,255,192,252,126,0,255,255,192,252,126,0,0,112,63,3,129,248,0,112,63,3,129,248,0,112,63,3,129,248,3,240,0,3,128,0,3,240,0,3,128,0,3,240,0,3,128,0,3,254,7,255,255,192,3,254,7,255,255,192,3,254,7,255,255,192,28,113,192,3,128,0,28,113,192,3,128,0,28,113,192,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,224,112,63,255,255,248,224,112,63,255,255,248,224,112,63,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,
  // 0x91cd  重
  205,145,45,45,14,48,0,253,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,255,254,0,0,0,0,255,254,0,0,0,0,255,254,0,3,255,255,0,0,0,3,255,255,0,0,0,3,255,255,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,
  // 0x91cf  量
  207,145,45,45,14,48,0,250,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,
  // 0x9488  针
  136,148,45,48,32,48,0,250,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,127,248,3,128,0,0,127,248,3,128,0,0,127,248,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,31,255,192,3,128,0,31,255,192,3,128,0,31,255,192,3,128,0,224,112,63,255,255,248,224,112,63,255,255,248,224,112,63,255,255,248,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,255,255,248,3,128,0,255,255,248,3,128,0,255,255,248,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,0,126,0,3,128,0,0,126,0,3,128,0,0,126,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0x94ae  钮
  174,148,45,45,14,48,0,253,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,3,255,192,28,14,0,3,255,192,28,14,0,3,255,192,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,3,128,0,28,14,0,28,0,0,28,14,0,28,0,0,28,14,0,28,0,0,28,14,0,227,255,192,28,14,0,227,255,192,28,14,0,227,255,192,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,0,28,14,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,255,255,192,224,14,0,255,255,192,224,14,0,255,255,192,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,112,0,224,14,0,0,113,192,224,14,0,0,113,192,224,14,0,0,113,192,224,14,0,0,126,0,224,14,0,0,126,0,224,14,0,0,126,0,224,14,0,0,112,63,255,255,248,0,112,63,255,255,248,0,112,63,255,255,248,
  // 0x9519  错
  25,149,45,48,32,48,0,250,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,254,7,0,112,0,3,254,7,0,112,0,3,254,7,0,112,0,3,129,255,255,255,192,3,129,255,255,255,192,3,129,255,255,255,192,28,0,7,0,112,0,28,0,7,0,112,0,28,0,7,0,112,0,31,254,7,0,112,0,31,254,7,0,112,0,31,254,7,0,112,0,227,143,255,255,255,248,227,143,255,255,255,248,227,143,255,255,255,248,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,255,254,63,255,254,0,255,254,63,255,254,0,255,254,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,142,56,0,14,0,3,142,56,0,14,0,3,142,56,0,14,0,3,240,56,0,14,0,3,240,56,0,14,0,3,240,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,0,0,56,0,14,0,0,0,56,0,14,0,0,0,56,0,14,0,
  // 0x955c  镜
  92,149,45,48,32,48,0,250,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,128,0,28,0,0,3,254,63,255,254,0,3,254,63,255,254,0,3,254,63,255,254,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,28,0,0,227,128,0,28,0,0,227,128,0,28,0,0,227,128,0,31,241,255,255,255,248,31,241,255,255,255,248,31,241,255,255,255,248,227,128,0,0,0,0,227,128,0,0,0,0,227,128,0,0,0,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,255,254,56,0,14,0,255,254,56,0,14,0,255,254,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,56,0,14,0,3,128,63,255,254,0,3,128,63,255,254,0,3,128,63,255,254,0,3,142,7,3,128,0,3,142,7,3,128,0,3,142,7,3,128,0,3,240,7,3,128,56,3,240,7,3,128,56,3,240,7,3,128,56,3,128,56,3,128,56,3,128,56,3,128,56,3,128,56,3,128,56,0,15,192,0,127,248,0,15,192,0,127,248,0,15,192,0,127,248,
  // 0x957f  长
  127,149,45,48,32,48,0,250,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,14,56,0,0,0,0,14,56,0,0,0,0,14,56,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,224,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,0,28,0,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,7,3,128,0,0,14,56,0,126,0,0,14,56,0,126,0,0,14,56,0,126,0,0,15,192,0,1,248,0,15,192,0,1,248,0,15,192,0,1,248,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,
  // 0x95ed  闭
  237,149,39,48,240,48,3,250,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,3,143,255,255,254,3,143,255,255,254,3,143,255,255,254,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,227,255,255,255,142,227,255,255,255,142,227,255,255,255,142,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,0,63,0,14,224,0,63,0,14,224,0,63,0,14,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,14,7,0,14,224,14,7,0,14,224,14,7,0,14,224,112,7,0,14,224,112,7,0,14,224,112,7,0,14,227,128,7,0,14,227,128,7,0,14,227,128,7,0,14,224,1,199,0,14,224,1,199,0,14,224,1,199,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x95f2  闲
  242,149,39,48,240,48,3,250,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,3,143,255,255,254,3,143,255,255,254,3,143,255,255,254,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,227,255,255,255,142,227,255,255,255,142,227,255,255,255,142,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,1,255,0,14,224,1,255,0,14,224,1,255,0,14,224,14,56,224,14,224,14,56,224,14,224,14,56,224,14,224,112,56,28,14,224,112,56,28,14,224,112,56,28,14,227,128,56,3,142,227,128,56,3,142,227,128,56,3,142,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x95f4  间
  244,149,39,48,240,48,3,250,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,3,129,255,255,254,3,129,255,255,254,3,129,255,255,254,3,128,0,0,14,3,128,0,0,14,3,128,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,15,255,224,14,224,15,255,224,14,224,15,255,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,15,255,224,14,224,15,255,224,14,224,15,255,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,14,0,224,14,224,15,255,224,14,224,15,255,224,14,224,15,255,224,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x9608  阈
  8,150,39,48,240,48,3,250,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,3,143,255,255,254,3,143,255,255,254,3,143,255,255,254,0,0,7,0,14,0,0,7,0,14,0,0,7,0,14,224,0,7,28,14,224,0,7,28,14,224,0,7,28,14,224,0,7,3,142,224,0,7,3,142,224,0,7,3,142,227,255,255,255,142,227,255,255,255,142,227,255,255,255,142,224,0,7,0,14,224,0,7,0,14,224,0,7,0,14,224,127,199,28,14,224,127,199,28,14,224,127,199,28,14,224,113,199,28,14,224,113,199,28,14,224,113,199,28,14,224,127,199,28,14,224,127,199,28,14,224,127,199,28,14,224,0,7,224,14,224,0,7,224,14,224,0,7,224,14,224,15,192,227,142,224,15,192,227,142,224,15,192,227,142,227,240,7,31,142,227,240,7,31,142,227,240,7,31,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,224,1,192,0,14,224,1,192,0,14,224,1,192,0,14,224,0,0,0,126,224,0,0,0,126,224,0,0,0,126,
  // 0x964d  降
  77,150,42,48,32,48,3,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,254,7,0,0,0,255,254,7,0,0,0,255,254,7,0,0,0,224,14,7,255,254,0,224,14,7,255,254,0,224,14,7,255,254,0,224,112,56,0,112,0,224,112,56,0,112,0,224,112,56,0,112,0,224,113,199,3,128,0,224,113,199,3,128,0,224,113,199,3,128,0,227,128,0,252,0,0,227,128,0,252,0,0,227,128,0,252,0,0,224,112,63,3,240,0,224,112,63,3,240,0,224,112,63,3,240,0,224,127,192,28,15,192,224,127,192,28,15,192,224,127,192,28,15,192,224,14,0,28,0,0,224,14,0,28,0,0,224,14,0,28,0,0,224,14,63,255,254,0,224,14,63,255,254,0,224,14,63,255,254,0,224,14,0,28,0,0,224,14,0,28,0,0,224,14,0,28,0,0,252,113,192,28,0,0,252,113,192,28,0,0,252,113,192,28,0,0,227,129,255,255,255,192,227,129,255,255,255,192,227,129,255,255,255,192,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,
  // 0x9650  限
  80,150,42,45,14,48,3,250,255,241,255,255,240,0,255,241,255,255,240,0,255,241,255,255,240,0,224,113,192,0,112,0,224,113,192,0,112,0,224,113,192,0,112,0,227,129,192,0,112,0,227,129,192,0,112,0,227,129,192,0,112,0,227,129,255,255,240,0,227,129,255,255,240,0,227,129,255,255,240,0,252,1,192,0,112,0,252,1,192,0,112,0,252,1,192,0,112,0,227,129,192,0,112,0,227,129,192,0,112,0,227,129,192,0,112,0,224,113,255,255,240,0,224,113,255,255,240,0,224,113,255,255,240,0,224,113,192,224,14,0,224,113,192,224,14,0,224,113,192,224,14,0,224,113,192,224,112,0,224,113,192,224,112,0,224,113,192,224,112,0,252,113,192,31,128,0,252,113,192,31,128,0,252,113,192,31,128,0,227,129,192,28,0,0,227,129,192,28,0,0,227,129,192,28,0,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,192,3,128,0,224,1,199,0,112,0,224,1,199,0,112,0,224,1,199,0,112,0,224,1,248,0,15,192,224,1,248,0,15,192,224,1,248,0,15,192,224,1,192,0,0,0,224,1,192,0,0,0,224,1,192,0,0,0,
  // 0x9664  除
  100,150,42,45,14,48,3,250,255,240,0,224,0,0,255,240,0,224,0,0,255,240,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,227,128,7,28,0,0,227,128,7,28,0,0,227,128,7,28,0,0,227,128,56,3,128,0,227,128,56,3,128,0,227,128,56,3,128,0,252,1,192,0,112,0,252,1,192,0,112,0,252,1,192,0,112,0,227,142,63,255,143,192,227,142,63,255,143,192,227,142,63,255,143,192,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,112,0,224,0,0,224,113,255,255,254,0,224,113,255,255,254,0,224,113,255,255,254,0,252,112,0,224,0,0,252,112,0,224,0,0,252,112,0,224,0,0,227,128,56,227,128,0,227,128,56,227,128,0,227,128,56,227,128,0,224,1,192,224,112,0,224,1,192,224,112,0,224,1,192,224,112,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,0,56,224,14,0,224,0,56,224,14,0,224,0,56,224,14,0,224,0,7,0,0,0,224,0,7,0,0,0,224,0,7,0,0,0,
  // 0x9669  险
  105,150,42,48,32,48,3,250,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,255,240,0,224,0,0,255,240,0,224,0,0,255,240,0,224,0,0,224,112,7,28,0,0,224,112,7,28,0,0,224,112,7,28,0,0,227,128,7,28,0,0,227,128,7,28,0,0,227,128,7,28,0,0,227,128,56,3,128,0,227,128,56,3,128,0,227,128,56,3,128,0,252,1,192,0,112,0,252,1,192,0,112,0,252,1,192,0,112,0,227,142,63,255,143,192,227,142,63,255,143,192,227,142,63,255,143,192,224,112,0,0,0,0,224,112,0,0,0,0,224,112,0,0,0,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,7,0,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,252,113,192,224,112,0,252,113,192,224,112,0,252,113,192,224,112,0,227,128,56,227,128,0,227,128,56,227,128,0,227,128,56,227,128,0,224,0,56,3,128,0,224,0,56,3,128,0,224,0,56,3,128,0,224,0,0,28,0,0,224,0,0,28,0,0,224,0,0,28,0,0,224,15,255,255,255,192,224,15,255,255,255,192,224,15,255,255,255,192,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,
  // 0x96f6  零
  246,150,45,48,32,48,0,250,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,7,0,0,56,28,0,7,0,0,56,28,0,7,0,0,56,224,127,199,31,241,192,224,127,199,31,241,192,224,127,199,31,241,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,127,199,31,240,0,0,127,199,31,240,0,0,127,199,31,240,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,15,192,31,128,0,0,15,192,31,128,0,0,15,192,31,128,0,3,240,56,0,126,0,3,240,56,0,126,0,3,240,56,0,126,0,252,0,7,0,1,248,252,0,7,0,1,248,252,0,7,0,1,248,0,127,255,255,128,0,0,127,255,255,128,0,0,127,255,255,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,1,248,28,0,0,0,1,248,28,0,0,0,1,248,28,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,7,224,0,0,0,0,0,28,0,0,0,0,0,28,0,0,0,0,0,28,0,0,
  // 0x9700  需
  0,151,45,45,14,48,0,250,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,7,0,0,56,28,0,7,0,0,56,28,0,7,0,0,56,224,127,199,31,241,192,224,127,199,31,241,192,224,127,199,31,241,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,127,199,31,240,0,0,127,199,31,240,0,0,127,199,31,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,224,14,0,3,129,192,227,142,0,3,129,192,227,142,0,3,129,192,227,142,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,
  // 0x9752  青
  82,151,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,28,112,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,
  // 0x975e  非
  94,151,45,48,32,48,0,250,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,255,255,192,31,255,248,255,255,192,31,255,248,255,255,192,31,255,248,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,31,255,192,31,255,192,31,255,192,31,255,192,31,255,192,31,255,192,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,255,255,192,31,255,248,255,255,192,31,255,248,255,255,192,31,255,248,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,
  // 0x9760  靠
  96,151,45,48,32,48,0,250,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,3,128,7,0,0,0,3,128,7,0,0,0,3,128,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,31,255,192,31,255,192,31,255,192,31,255,192,31,255,192,31,255,192,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,3,255,192,31,254,0,3,255,192,31,254,0,3,255,192,31,254,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,31,255,192,31,255,192,31,255,192,31,255,192,31,255,192,31,255,192,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,
  // 0x9762  面
  98,151,45,45,14,48,0,250,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,255,252,14,0,3,129,255,252,14,0,3,129,255,252,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,255,252,14,0,3,129,255,252,14,0,3,129,255,252,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,
  // 0x9875  页
  117,152,39,45,225,48,3,250,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,56,3,128,3,128,56,3,128,3,128,56,3,128,3,128,56,3,128,3,128,56,3,128,3,128,56,3,128,3,128,56,3,128,3,128,56,3,128,3,128,56,3,128,3,128,56,3,128,3,128,56,3,128,3,128,56,3,128,3,128,56,3,128,3,128,56,3,128,3,128,56,3,128,3,129,199,3,128,3,129,199,3,128,3,129,199,3,128,0,1,192,224,0,0,1,192,224,0,0,1,192,224,0,0,14,0,28,0,0,14,0,28,0,0,14,0,28,0,3,240,0,3,128,3,240,0,3,128,3,240,0,3,128,252,0,0,0,112,252,0,0,0,112,252,0,0,0,112,
  // 0x9879  项
  121,152,45,45,14,48,0,250,0,0,7,255,255,248,0,0,7,255,255,248,0,0,7,255,255,248,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,255,255,192,28,0,0,255,255,192,28,0,0,255,255,192,28,0,0,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,127,199,28,1,192,0,127,199,28,1,192,0,127,199,28,1,192,255,128,0,28,112,0,255,128,0,28,112,0,255,128,0,28,112,0,28,0,0,224,14,0,28,0,0,224,14,0,28,0,0,224,14,0,0,0,7,0,1,192,0,0,7,0,1,192,0,0,7,0,1,192,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,
  // 0x9884  预
  132,152,45,45,14,48,0,250,255,254,7,255,255,248,255,254,7,255,255,248,255,254,7,255,255,248,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,28,112,0,28,0,0,28,112,0,28,0,0,28,112,0,28,0,0,3,128,7,255,255,192,3,128,7,255,255,192,3,128,7,255,255,192,0,112,7,0,1,192,0,112,7,0,1,192,0,112,7,0,1,192,255,255,199,3,129,192,255,255,199,3,129,192,255,255,199,3,129,192,3,129,199,3,129,192,3,129,199,3,129,192,3,129,199,3,129,192,3,142,7,3,129,192,3,142,7,3,129,192,3,142,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,3,129,192,3,128,7,28,1,192,3,128,7,28,1,192,3,128,7,28,1,192,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,224,14,0,3,128,0,224,14,0,3,128,0,224,14,0,227,128,7,0,1,192,227,128,7,0,1,192,227,128,7,0,1,192,28,0,56,0,0,56,28,0,56,0,0,56,28,0,56,0,0,56,
  // 0x9891  频
  145,152,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,7,255,255,248,0,112,7,255,255,248,0,112,7,255,255,248,28,112,0,3,128,0,28,112,0,3,128,0,28,112,0,3,128,0,28,127,192,28,0,0,28,127,192,28,0,0,28,127,192,28,0,0,28,112,7,255,255,192,28,112,7,255,255,192,28,112,7,255,255,192,28,112,7,0,1,192,28,112,7,0,1,192,28,112,7,0,1,192,255,255,255,3,129,192,255,255,255,3,129,192,255,255,255,3,129,192,0,0,7,3,129,192,0,0,7,3,129,192,0,0,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,0,112,7,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,28,113,199,3,129,192,28,113,199,28,1,192,28,113,199,28,1,192,28,113,199,28,1,192,224,1,192,28,112,0,224,1,192,28,112,0,224,1,192,28,112,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,3,240,7,0,1,192,3,240,7,0,1,192,3,240,7,0,1,192,252,0,56,0,0,56,252,0,56,0,0,56,252,0,56,0,0,56,
  // 0x989d  额
  157,152,45,48,32,48,0,250,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,14,0,255,255,248,0,14,0,255,255,248,0,14,0,255,255,248,31,255,255,0,112,0,31,255,255,0,112,0,31,255,255,0,112,0,28,0,7,3,128,0,28,0,7,3,128,0,28,0,7,3,128,0,0,112,0,31,255,192,0,112,0,31,255,192,0,112,0,31,255,192,0,127,248,28,1,192,0,127,248,28,1,192,0,127,248,28,1,192,3,128,56,28,113,192,3,128,56,28,113,192,3,128,56,28,113,192,28,113,192,28,113,192,28,113,192,28,113,192,28,113,192,28,113,192,0,14,0,28,113,192,0,14,0,28,113,192,0,14,0,28,113,192,0,113,192,28,113,192,0,113,192,28,113,192,0,113,192,28,113,192,3,128,56,28,113,192,3,128,56,28,113,192,3,128,56,28,113,192,31,255,255,28,113,192,31,255,255,28,113,192,31,255,255,28,113,192,227,128,56,3,142,0,227,128,56,3,142,0,227,128,56,3,142,0,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,255,248,28,0,56,3,255,248,28,0,56,3,255,248,28,0,56,3,128,56,224,0,56,3,128,56,224,0,56,3,128,56,224,0,56,
  // 0x98ce  风
  206,152,45,45,14,48,0,250,3,255,255,255,240,0,3,255,255,255,240,0,3,255,255,255,240,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,142,0,28,112,0,3,142,0,28,112,0,3,142,0,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,129,192,28,112,0,3,128,56,224,112,0,3,128,56,224,112,0,3,128,56,224,112,0,3,128,56,224,112,0,3,128,56,224,112,0,3,128,56,224,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,7,0,112,0,3,128,56,224,112,0,3,128,56,224,112,0,3,128,56,224,112,0,3,128,56,224,112,56,3,128,56,224,112,56,3,128,56,224,112,56,3,129,192,28,14,56,3,129,192,28,14,56,3,129,192,28,14,56,28,14,0,28,14,56,28,14,0,28,14,56,28,14,0,28,14,56,28,0,0,0,1,248,28,0,0,0,1,248,28,0,0,0,1,248,224,0,0,0,0,56,224,0,0,0,0,56,224,0,0,0,0,56,
  // 0x9971  饱
  113,153,45,45,14,48,0,253,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,7,255,255,192,3,128,7,255,255,192,3,128,7,255,255,192,3,254,7,0,1,192,3,254,7,0,1,192,3,254,7,0,1,192,28,14,56,0,1,192,28,14,56,0,1,192,28,14,56,0,1,192,28,113,199,255,241,192,28,113,199,255,241,192,28,113,199,255,241,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,3,128,7,0,113,192,3,128,7,0,113,192,3,128,7,0,113,192,3,128,7,0,113,192,3,128,7,0,113,192,3,128,7,0,113,192,3,128,7,255,241,192,3,128,7,255,241,192,3,128,7,255,241,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,3,142,0,3,128,7,3,142,0,3,128,7,3,142,0,3,142,7,0,112,56,3,142,7,0,112,56,3,142,7,0,112,56,3,240,7,0,0,56,3,240,7,0,0,56,3,240,7,0,0,56,3,128,0,255,255,248,3,128,0,255,255,248,3,128,0,255,255,248,
  // 0x9a6c  马
  108,154,42,45,14,48,0,250,31,255,255,255,128,0,31,255,255,255,128,0,31,255,255,255,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,127,255,255,255,192,0,127,255,255,255,192,0,127,255,255,255,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,255,255,255,255,129,192,255,255,255,255,129,192,255,255,255,255,129,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,3,142,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,
  // 0x9a71  驱
  113,154,45,45,14,48,0,250,255,254,7,255,255,248,255,254,7,255,255,248,255,254,7,255,255,248,0,14,7,0,0,0,0,14,7,0,0,0,0,14,7,0,0,0,28,14,7,0,1,192,28,14,7,0,1,192,28,14,7,0,1,192,28,14,7,28,1,192,28,14,7,28,1,192,28,14,7,28,1,192,28,14,7,3,142,0,28,14,7,3,142,0,28,14,7,3,142,0,28,14,7,3,142,0,28,14,7,3,142,0,28,14,7,3,142,0,31,255,199,0,112,0,31,255,199,0,112,0,31,255,199,0,112,0,0,1,199,0,112,0,0,1,199,0,112,0,0,1,199,0,112,0,0,1,199,3,142,0,0,1,199,3,142,0,0,1,199,3,142,0,0,127,199,3,142,0,0,127,199,3,142,0,0,127,199,3,142,0,255,129,199,28,1,192,255,129,199,28,1,192,255,129,199,28,1,192,28,1,199,224,1,192,28,1,199,224,1,192,28,1,199,224,1,192,0,1,199,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,3,142,7,255,255,248,3,142,7,255,255,248,3,142,7,255,255,248,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,
  // 0x9ad8  高
  216,154,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,15,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,15,255,255,129,192,28,15,255,255,129,192,28,15,255,255,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,14,0,3,129,192,28,15,255,255,129,192,28,15,255,255,129,192,28,15,255,255,129,192,28,0,0,0,15,192,28,0,0,0,15,192,28,0,0,0,15,192,
  // 0x9ec4  黄
  196,158,45,48,32,48,0,250,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,128,0,0,15,192,31,128,0,0,15,192,31,128,0,0,15,192,
  // 0x9ede  點
  222,158,45,48,32,48,0,250,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,255,248,0,112,0,255,255,248,0,112,0,255,255,248,0,112,0,224,112,56,0,112,0,224,112,56,0,112,0,224,112,56,0,112,0,252,113,248,0,112,0,252,113,248,0,112,0,252,113,248,0,112,0,227,254,56,0,127,248,227,254,56,0,127,248,227,254,56,0,127,248,224,112,56,0,112,0,224,112,56,0,112,0,224,112,56,0,112,0,255,255,248,0,112,0,255,255,248,0,112,0,255,255,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,255,255,248,255,255,248,255,255,248,255,255,248,255,255,248,255,255,248,0,112,0,224,0,56,0,112,0,224,0,56,0,112,0,224,0,56,0,127,248,224,0,56,0,127,248,224,0,56,0,127,248,224,0,56,255,128,0,224,0,56,255,128,0,224,0,56,255,128,0,224,0,56,0,0,56,224,0,56,0,0,56,224,0,56,0,0,56,224,0,56,227,142,56,224,0,56,227,142,56,224,0,56,227,142,56,224,0,56,227,142,0,255,255,248,227,142,0,255,255,248,227,142,0,255,255,248,224,0,0,224,0,56,224,0,0,224,0,56,224,0,0,224,0,56,
  // 0x9f50  齐
  80,159,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,0,63,224,0,0,0,15,192,31,128,0,0,15,192,31,128,0,0,15,192,31,128,0,3,240,0,0,126,0,3,240,0,0,126,0,3,240,0,0,126,0,252,14,0,3,129,248,252,14,0,3,129,248,252,14,0,3,129,248,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,0,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,
  // 0xff1a  ：
  26,255,12,21,42,48,18,3,255,240,255,240,255,240,255,240,255,240,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,240,255,240,255,240,255,240,255,240,255,240,
};

#endif // HAS_GRAPHICAL_TFT
