/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Latin Extended-A 48pt, capital 'A' height: 30px, width: 100%, range: 0x0100-0x017f
extern const uint8_t Unifont_Latin_Extended_A_30[14555] = {
  129,30,0,1,127,1,42,250, // unifont_t
  // 0x0100  Ā
  18,39,117,24,3,0,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0101  ā
  18,33,99,24,3,0,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x0102  Ă
  18,42,126,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0103  ă
  18,39,117,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x0104  Ą
  21,36,108,24,3,250,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,0,14,0,0,14,0,0,14,0,0,1,248,0,1,248,0,1,248,
  // 0x0105  ą
  21,30,90,24,3,250,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,0,14,0,0,14,0,0,14,0,0,1,248,0,1,248,0,1,248,
  // 0x0106  Ć
  18,42,126,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0107  ć
  18,36,108,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0108  Ĉ
  18,42,126,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0109  ĉ
  18,36,108,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x010a  Ċ
  18,42,126,24,3,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x010b  ċ
  18,36,108,24,3,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x010c  Č
  18,42,126,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x010d  č
  18,36,108,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x010e  Ď
  18,42,126,24,3,0,224,112,0,224,112,0,224,112,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,240,0,255,240,0,255,240,0,224,14,0,224,14,0,224,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,14,0,224,14,0,224,14,0,255,240,0,255,240,0,255,240,0,
  // 0x010f  ď
  18,42,126,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,31,241,192,31,241,192,31,241,192,224,15,192,224,15,192,224,15,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x0110  Đ
  21,30,90,24,0,0,31,254,0,31,254,0,31,254,0,28,1,192,28,1,192,28,1,192,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,255,240,56,255,240,56,255,240,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,1,192,28,1,192,28,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0111  đ
  21,33,99,24,3,0,0,1,192,0,1,192,0,1,192,0,127,248,0,127,248,0,127,248,0,1,192,0,1,192,0,1,192,31,241,192,31,241,192,31,241,192,224,15,192,224,15,192,224,15,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x0112  Ē
  18,39,117,24,3,0,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x0113  ē
  18,33,99,24,3,0,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0114  Ĕ
  18,42,126,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x0115  ĕ
  18,36,108,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0116  Ė
  18,42,126,24,3,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x0117  ė
  18,36,108,24,3,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0118  Ę
  18,36,108,24,3,250,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,0,112,0,0,112,0,0,112,0,0,15,192,0,15,192,0,15,192,
  // 0x0119  ę
  18,30,90,24,3,250,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,3,128,0,3,128,0,3,128,0,0,126,0,0,126,0,0,126,0,
  // 0x011a  Ě
  18,42,126,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x011b  ě
  18,36,108,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x011c  Ĝ
  18,42,126,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,127,192,224,127,192,224,127,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x011d  ĝ
  18,42,126,24,3,250,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,1,192,0,1,192,0,1,192,31,241,192,31,241,192,31,241,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,28,0,0,28,0,0,28,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x011e  Ğ
  18,42,126,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,127,192,224,127,192,224,127,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x011f  ğ
  18,45,135,24,3,250,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,1,192,0,1,192,0,1,192,31,241,192,31,241,192,31,241,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,28,0,0,28,0,0,28,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0120  Ġ
  18,42,126,24,3,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,127,192,224,127,192,224,127,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x0121  ġ
  18,42,126,24,3,250,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,0,0,0,0,0,0,0,0,0,1,192,0,1,192,0,1,192,31,241,192,31,241,192,31,241,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,28,0,0,28,0,0,28,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0122  Ģ
  18,36,108,24,3,250,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,127,192,224,127,192,224,127,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,0,112,0,0,112,0,0,112,0,31,128,0,31,128,0,31,128,0,
  // 0x0123  ģ
  18,42,126,24,3,250,0,126,0,0,126,0,0,126,0,3,128,0,3,128,0,3,128,0,0,0,0,0,0,0,0,0,0,0,1,192,0,1,192,0,1,192,31,241,192,31,241,192,31,241,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,28,0,0,28,0,0,28,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0124  Ĥ
  18,42,126,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0125  ĥ
  18,42,126,24,3,0,31,128,0,31,128,0,31,128,0,224,112,0,224,112,0,224,112,0,0,0,0,0,0,0,0,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0126  Ħ
  24,30,90,24,0,0,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,255,255,255,255,255,255,255,255,255,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,31,255,248,31,255,248,31,255,248,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,
  // 0x0127  ħ
  21,33,99,24,0,0,28,0,0,28,0,0,28,0,0,255,240,0,255,240,0,255,240,0,28,0,0,28,0,0,28,0,0,28,127,192,28,127,192,28,127,192,31,128,56,31,128,56,31,128,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,
  // 0x0128  Ĩ
  18,42,126,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,192,31,255,192,31,255,192,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,255,192,31,255,192,31,255,192,
  // 0x0129  ĩ
  18,36,108,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,240,0,3,240,0,3,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,255,192,31,255,192,31,255,192,
  // 0x012a  Ī
  15,39,78,24,6,0,255,240,255,240,255,240,0,0,0,0,0,0,0,0,0,0,0,0,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x012b  ī
  15,33,66,24,6,0,255,240,255,240,255,240,0,0,0,0,0,0,0,0,0,0,0,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x012c  Ĭ
  18,42,126,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,31,255,192,31,255,192,31,255,192,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,255,192,31,255,192,31,255,192,
  // 0x012d  ĭ
  18,36,108,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,3,240,0,3,240,0,3,240,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,255,192,31,255,192,31,255,192,
  // 0x012e  Į
  15,36,72,24,6,250,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,3,128,3,128,3,128,0,126,0,126,0,126,
  // 0x012f  į
  15,39,78,24,6,250,3,128,3,128,3,128,3,128,3,128,3,128,0,0,0,0,0,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,3,128,3,128,3,128,0,126,0,126,0,126,
  // 0x0130  İ
  15,42,84,24,6,0,3,128,3,128,3,128,3,128,3,128,3,128,0,0,0,0,0,0,0,0,0,0,0,0,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x0131  ı
  15,24,48,24,6,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x0132  Ĳ
  18,30,90,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0133  ĳ
  15,42,84,24,6,250,224,14,224,14,224,14,224,14,224,14,224,14,0,0,0,0,0,0,0,0,0,0,0,0,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,31,142,31,142,31,142,0,14,0,14,0,14,224,14,224,14,224,14,31,240,31,240,31,240,
  // 0x0134  Ĵ
  21,42,126,24,3,0,0,126,0,0,126,0,0,126,0,3,129,192,3,129,192,3,129,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,248,3,255,248,3,255,248,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x0135  ĵ
  18,42,126,24,3,250,0,126,0,0,126,0,0,126,0,3,129,192,3,129,192,3,129,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,126,0,0,126,0,0,126,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,224,112,0,224,112,0,224,112,0,31,128,0,31,128,0,31,128,0,
  // 0x0136  Ķ
  21,36,108,24,0,250,28,0,56,28,0,56,28,0,56,28,1,192,28,1,192,28,1,192,28,14,0,28,14,0,28,14,0,28,112,0,28,112,0,28,112,0,31,128,0,31,128,0,31,128,0,31,128,0,31,128,0,31,128,0,28,112,0,28,112,0,28,112,0,28,14,0,28,14,0,28,14,0,28,1,192,28,1,192,28,1,192,28,0,56,28,0,56,28,0,56,3,128,0,3,128,0,3,128,0,252,0,0,252,0,0,252,0,0,
  // 0x0137  ķ
  21,39,117,24,0,250,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,1,192,28,1,192,28,1,192,28,14,0,28,14,0,28,14,0,28,112,0,28,112,0,28,112,0,31,128,0,31,128,0,31,128,0,28,112,0,28,112,0,28,112,0,28,14,0,28,14,0,28,14,0,28,1,192,28,1,192,28,1,192,28,0,56,28,0,56,28,0,56,3,128,0,3,128,0,3,128,0,252,0,0,252,0,0,252,0,0,
  // 0x0138  ĸ
  18,24,72,24,3,0,224,1,192,224,1,192,224,1,192,224,14,0,224,14,0,224,14,0,224,112,0,224,112,0,224,112,0,255,128,0,255,128,0,255,128,0,255,128,0,255,128,0,255,128,0,224,112,0,224,112,0,224,112,0,224,14,0,224,14,0,224,14,0,224,1,192,224,1,192,224,1,192,
  // 0x0139  Ĺ
  18,42,126,24,3,0,3,240,0,3,240,0,3,240,0,252,0,0,252,0,0,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x013a  ĺ
  15,42,84,24,6,0,3,240,3,240,3,240,252,0,252,0,252,0,0,0,0,0,0,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x013b  Ļ
  18,36,108,24,3,250,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,0,112,0,0,112,0,0,112,0,31,128,0,31,128,0,31,128,0,
  // 0x013c  ļ
  15,39,78,24,6,250,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,3,128,3,128,3,128,252,0,252,0,252,0,
  // 0x013d  Ľ
  18,42,126,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x013e  ľ
  15,42,84,24,6,0,224,112,224,112,224,112,31,128,31,128,31,128,0,0,0,0,0,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x013f  Ŀ
  18,30,90,24,3,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x0140  ŀ
  15,33,66,24,3,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,142,3,142,3,142,3,142,3,142,3,142,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x0141  Ł
  21,30,90,24,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,14,0,28,14,0,28,14,0,28,112,0,28,112,0,28,112,0,31,128,0,31,128,0,31,128,0,252,0,0,252,0,0,252,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,31,255,248,31,255,248,31,255,248,
  // 0x0142  ł
  15,33,66,24,6,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,142,3,142,3,142,3,240,3,240,3,240,31,128,31,128,31,128,227,128,227,128,227,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x0143  Ń
  18,42,126,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,252,1,192,252,1,192,252,1,192,252,1,192,252,1,192,252,1,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,224,113,192,224,113,192,224,113,192,224,113,192,224,113,192,224,113,192,224,15,192,224,15,192,224,15,192,224,15,192,224,15,192,224,15,192,224,1,192,224,1,192,224,1,192,
  // 0x0144  ń
  18,36,108,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0145  Ņ
  21,36,108,24,0,250,28,0,56,28,0,56,28,0,56,31,128,56,31,128,56,31,128,56,31,128,56,31,128,56,31,128,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,14,56,28,14,56,28,14,56,28,14,56,28,14,56,28,14,56,28,1,248,28,1,248,28,1,248,28,1,248,28,1,248,28,1,248,28,0,56,28,0,56,28,0,56,3,128,0,3,128,0,3,128,0,252,0,0,252,0,0,252,0,0,
  // 0x0146  ņ
  21,30,90,24,0,250,28,127,192,28,127,192,28,127,192,31,128,56,31,128,56,31,128,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,3,128,0,3,128,0,3,128,0,252,0,0,252,0,0,252,0,0,
  // 0x0147  Ň
  18,42,126,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,252,1,192,252,1,192,252,1,192,252,1,192,252,1,192,252,1,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,224,113,192,224,113,192,224,113,192,224,113,192,224,113,192,224,113,192,224,15,192,224,15,192,224,15,192,224,15,192,224,15,192,224,15,192,224,1,192,224,1,192,224,1,192,
  // 0x0148  ň
  18,36,108,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0149  ŉ
  18,39,117,24,3,0,252,0,0,252,0,0,252,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,0,0,0,0,0,0,0,0,0,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x014a  Ŋ
  18,30,90,24,3,0,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,126,0,224,126,0,224,126,0,
  // 0x014b  ŋ
  18,30,90,24,3,250,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,0,126,0,0,126,0,0,126,0,
  // 0x014c  Ō
  18,39,117,24,3,0,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x014d  ō
  18,33,99,24,3,0,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x014e  Ŏ
  18,42,126,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x014f  ŏ
  18,36,108,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0150  Ő
  21,42,126,24,3,0,31,129,248,31,129,248,31,129,248,224,14,0,224,14,0,224,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0151  ő
  21,36,108,24,3,0,31,129,248,31,129,248,31,129,248,224,14,0,224,14,0,224,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0152  Œ
  21,30,90,24,3,0,31,143,248,31,143,248,31,143,248,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,127,192,224,127,192,224,127,192,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,31,143,248,31,143,248,31,143,248,
  // 0x0153  œ
  21,24,72,24,3,0,31,143,192,31,143,192,31,143,192,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,127,248,224,127,248,224,127,248,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,56,224,112,56,224,112,56,31,143,192,31,143,192,31,143,192,
  // 0x0154  Ŕ
  18,42,126,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,254,0,255,254,0,255,254,0,224,112,0,224,112,0,224,112,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0155  ŕ
  18,36,108,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,
  // 0x0156  Ŗ
  21,36,108,24,0,250,31,255,192,31,255,192,31,255,192,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,31,255,192,31,255,192,31,255,192,28,14,0,28,14,0,28,14,0,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,3,128,0,3,128,0,3,128,0,252,0,0,252,0,0,252,0,0,
  // 0x0157  ŗ
  21,30,90,24,0,250,28,127,192,28,127,192,28,127,192,31,128,56,31,128,56,31,128,56,28,0,56,28,0,56,28,0,56,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,3,128,0,3,128,0,3,128,0,252,0,0,252,0,0,252,0,0,
  // 0x0158  Ř
  18,42,126,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,254,0,255,254,0,255,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,254,0,255,254,0,255,254,0,224,112,0,224,112,0,224,112,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0159  ř
  18,36,108,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,
  // 0x015a  Ś
  18,42,126,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,1,192,0,1,192,0,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x015b  ś
  18,36,108,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x015c  Ŝ
  18,42,126,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,1,192,0,1,192,0,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x015d  ŝ
  18,36,108,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,1,192,0,1,192,0,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x015e  Ş
  18,36,108,24,3,250,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,1,192,0,1,192,0,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,112,0,0,112,0,0,112,0,31,128,0,31,128,0,31,128,0,
  // 0x015f  ş
  18,30,90,24,3,250,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,1,192,0,1,192,0,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,112,0,0,112,0,0,112,0,31,128,0,31,128,0,31,128,0,
  // 0x0160  Š
  18,42,126,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,1,192,0,1,192,0,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0161  š
  18,36,108,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,1,192,0,1,192,0,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0162  Ţ
  21,36,108,24,3,250,255,255,248,255,255,248,255,255,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,128,0,31,128,0,31,128,0,
  // 0x0163  ţ
  15,36,72,24,3,250,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,0,126,0,126,0,126,0,112,0,112,0,112,31,128,31,128,31,128,
  // 0x0164  Ť
  21,42,126,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,248,255,255,248,255,255,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x0165  ť
  15,42,84,24,3,0,28,14,28,14,28,14,3,240,3,240,3,240,0,0,0,0,0,0,0,0,0,0,0,0,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,0,126,0,126,0,126,
  // 0x0166  Ŧ
  21,30,90,24,3,0,255,255,248,255,255,248,255,255,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,255,192,31,255,192,31,255,192,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x0167  ŧ
  15,30,60,24,3,0,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,0,126,0,126,0,126,
  // 0x0168  Ũ
  18,42,126,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0169  ũ
  18,36,108,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x016a  Ū
  18,39,117,24,3,0,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x016b  ū
  18,33,99,24,3,0,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x016c  Ŭ
  18,42,126,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x016d  ŭ
  18,39,117,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x016e  Ů
  18,42,126,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x016f  ů
  18,36,108,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x0170  Ű
  21,42,126,24,3,0,31,129,248,31,129,248,31,129,248,224,14,0,224,14,0,224,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0171  ű
  21,36,108,24,3,0,31,129,248,31,129,248,31,129,248,224,14,0,224,14,0,224,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x0172  Ų
  18,36,108,24,3,250,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,3,128,0,3,128,0,3,128,0,0,126,0,0,126,0,0,126,0,
  // 0x0173  ų
  21,30,90,24,3,250,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,0,14,0,0,14,0,0,14,0,0,1,248,0,1,248,0,1,248,
  // 0x0174  Ŵ
  18,42,126,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,227,241,192,227,241,192,227,241,192,227,241,192,227,241,192,227,241,192,252,15,192,252,15,192,252,15,192,252,15,192,252,15,192,252,15,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0175  ŵ
  21,36,108,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,56,224,0,56,224,0,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,31,143,192,31,143,192,31,143,192,
  // 0x0176  Ŷ
  21,42,126,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,3,142,0,3,142,0,3,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x0177  ŷ
  18,42,126,24,3,250,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,28,15,192,28,15,192,28,15,192,3,241,192,3,241,192,3,241,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0178  Ÿ
  21,42,126,24,3,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,3,142,0,3,142,0,3,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x0179  Ź
  18,42,126,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x017a  ź
  18,36,108,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x017b  Ż
  18,42,126,24,3,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x017c  ż
  18,36,108,24,3,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x017d  Ž
  18,42,126,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x017e  ž
  18,36,108,24,3,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x017f  ſ
  15,33,66,24,3,0,0,126,0,126,0,126,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,128,255,128,255,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,
};

#endif // HAS_GRAPHICAL_TFT
