/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Korean 48pt, capital 'A' height: 30px, width: 100%, range: 0xac70-0xd788, glyphs: 110
extern const uint8_t Unifont_Korean_30[23235] = {
  161,30,112,172,136,215,42,250, // unifont_t
  // 0xac70  거
  112,172,36,39,195,48,9,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,192,0,112,255,255,192,0,112,255,255,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,255,240,0,1,192,255,240,0,1,192,255,240,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,112,0,0,112,0,112,0,0,112,0,112,0,0,112,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,252,0,0,0,112,252,0,0,0,112,252,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,
  // 0xace0  고
  224,172,39,30,150,48,3,0,31,255,255,255,128,31,255,255,255,128,31,255,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,1,192,3,128,0,1,192,3,128,0,1,192,3,128,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xadf8  그
  248,173,39,24,120,48,3,6,31,255,255,255,128,31,255,255,255,128,31,255,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xae09  급
  9,174,39,39,195,48,3,253,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,
  // 0xae30  기
  48,174,30,39,156,48,9,253,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,255,255,192,28,255,255,192,28,255,255,192,28,0,1,192,28,0,1,192,28,0,1,192,28,0,1,192,28,0,1,192,28,0,1,192,28,0,1,192,28,0,1,192,28,0,1,192,28,0,14,0,28,0,14,0,28,0,14,0,28,0,14,0,28,0,14,0,28,0,14,0,28,0,112,0,28,0,112,0,28,0,112,0,28,3,128,0,28,3,128,0,28,3,128,0,28,252,0,0,28,252,0,0,28,252,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,
  // 0xae45  깅
  69,174,33,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,255,254,0,3,128,255,254,0,3,128,255,254,0,3,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,252,0,0,3,128,252,0,0,3,128,252,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,252,0,0,15,255,252,0,0,15,255,252,0,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,15,255,252,0,0,15,255,252,0,0,15,255,252,0,
  // 0xb044  끄
  68,176,39,24,120,48,3,6,31,255,199,255,240,31,255,199,255,240,31,255,199,255,240,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xb0b4  내
  180,176,42,39,234,48,3,253,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,255,192,224,0,0,3,255,192,224,0,0,3,255,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,224,0,0,3,129,192,255,255,255,3,129,192,255,255,255,3,129,192,255,255,255,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,
  // 0xb178  노
  120,177,39,36,180,48,3,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xb204  누
  4,178,33,39,195,48,6,253,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,
  // 0xb274  뉴
  116,178,39,39,195,48,3,253,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,
  // 0xb2c8  니
  200,178,36,39,195,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,255,255,255,0,112,255,255,255,0,112,255,255,255,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,
  // 0xb2e4  다
  228,178,42,39,234,48,3,253,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,255,255,255,3,128,0,255,255,255,3,128,0,255,255,255,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,255,192,224,0,0,3,255,192,224,0,0,3,255,192,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,224,0,0,3,128,0,255,255,255,3,128,0,255,255,255,3,128,0,255,255,255,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0xb2f9  당
  249,178,42,42,252,48,3,253,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,127,192,224,0,0,0,127,192,224,0,0,0,127,192,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,128,0,0,1,255,255,128,0,0,1,255,255,128,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,1,255,255,128,0,0,1,255,255,128,0,0,1,255,255,128,0,
  // 0xb3c4  도
  196,179,39,36,180,48,3,0,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xb3cc  돌
  204,179,39,39,195,48,3,253,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,
  // 0xb3d9  동
  217,179,39,39,195,48,3,253,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,224,0,0,15,255,224,0,0,15,255,224,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,15,255,224,0,0,15,255,224,0,0,15,255,224,0,
  // 0xb418  되
  24,180,36,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,255,0,112,255,255,255,0,112,255,255,255,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,255,255,255,0,112,255,255,255,0,112,255,255,255,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,255,255,255,252,112,255,255,255,252,112,255,255,255,252,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,
  // 0xb41c  된
  28,180,36,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,31,255,255,0,112,31,255,255,0,112,31,255,255,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,31,255,255,0,112,31,255,255,0,112,31,255,255,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,255,255,255,252,112,255,255,255,252,112,255,255,255,252,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,127,255,255,240,0,127,255,255,240,0,127,255,255,240,
  // 0xb428  됨
  40,180,36,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,31,255,255,0,112,31,255,255,0,112,31,255,255,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,31,255,255,0,112,31,255,255,0,112,31,255,255,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,255,255,255,252,112,255,255,255,252,112,255,255,255,252,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,240,0,1,255,255,240,0,1,255,255,240,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,255,255,240,0,1,255,255,240,0,1,255,255,240,
  // 0xb4a4  뒤
  164,180,36,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,255,224,112,255,255,255,224,112,255,255,255,224,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,255,255,255,224,112,255,255,255,224,112,255,255,255,224,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,255,252,112,255,255,255,252,112,255,255,255,252,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,
  // 0xb4dc  드
  220,180,39,30,150,48,3,6,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xb514  디
  20,181,36,39,195,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,255,0,112,255,255,255,0,112,255,255,255,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,255,255,255,0,112,255,255,255,0,112,255,255,255,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,
  // 0xb77c  라
  124,183,39,39,195,48,6,253,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,255,255,248,28,0,255,255,248,28,0,255,255,248,28,0,0,0,56,28,0,0,0,56,28,0,0,0,56,28,0,0,0,56,28,0,0,0,56,28,0,0,0,56,28,0,255,255,248,31,254,255,255,248,31,254,255,255,248,31,254,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,255,255,248,28,0,255,255,248,28,0,255,255,248,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,
  // 0xb7ec  러
  236,183,39,39,195,48,6,253,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,255,255,248,0,14,255,255,248,0,14,255,255,248,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,0,0,56,0,14,255,255,248,31,254,255,255,248,31,254,255,255,248,31,254,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,255,255,248,0,14,255,255,248,0,14,255,255,248,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,
  // 0xb808  레
  8,184,39,39,195,48,6,253,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,255,255,248,3,142,255,255,248,3,142,255,255,248,3,142,0,0,56,3,142,0,0,56,3,142,0,0,56,3,142,0,0,56,3,142,0,0,56,3,142,0,0,56,3,142,255,255,248,255,142,255,255,248,255,142,255,255,248,255,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,255,255,248,3,142,255,255,248,3,142,255,255,248,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,
  // 0xb825  력
  37,184,33,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,255,255,192,3,128,255,255,192,3,128,255,255,192,3,128,0,1,192,255,128,0,1,192,255,128,0,1,192,255,128,255,255,192,3,128,255,255,192,3,128,255,255,192,3,128,224,0,0,255,128,224,0,0,255,128,224,0,0,255,128,255,255,192,3,128,255,255,192,3,128,255,255,192,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,128,0,127,255,255,128,0,127,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,
  // 0xb85c  로
  92,184,39,36,180,48,3,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xb8cc  료
  204,184,39,36,180,48,3,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xb974  르
  116,185,39,30,150,48,3,6,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xb9ac  리
  172,185,33,39,195,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,255,255,248,3,128,255,255,248,3,128,255,255,248,3,128,0,0,56,3,128,0,0,56,3,128,0,0,56,3,128,0,0,56,3,128,0,0,56,3,128,0,0,56,3,128,255,255,248,3,128,255,255,248,3,128,255,255,248,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,255,255,248,3,128,255,255,248,3,128,255,255,248,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,
  // 0xb9b0  린
  176,185,33,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,255,255,192,3,128,255,255,192,3,128,255,255,192,3,128,0,1,192,3,128,0,1,192,3,128,0,1,192,3,128,255,255,192,3,128,255,255,192,3,128,255,255,192,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,255,255,192,3,128,255,255,192,3,128,255,255,192,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,31,255,255,255,128,31,255,255,255,128,31,255,255,255,128,
  // 0xb9bd  립
  189,185,33,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,255,255,192,3,128,255,255,192,3,128,255,255,192,3,128,0,1,192,3,128,0,1,192,3,128,0,1,192,3,128,255,255,192,3,128,255,255,192,3,128,255,255,192,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,255,255,192,3,128,255,255,192,3,128,255,255,192,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,15,255,255,128,0,15,255,255,128,0,15,255,255,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,15,255,255,128,0,15,255,255,128,0,15,255,255,128,
  // 0xb9c1  링
  193,185,33,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,255,255,192,3,128,255,255,192,3,128,255,255,192,3,128,0,1,192,3,128,0,1,192,3,128,0,1,192,3,128,255,255,192,3,128,255,255,192,3,128,255,255,192,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,255,255,192,3,128,255,255,192,3,128,255,255,192,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,252,0,0,15,255,252,0,0,15,255,252,0,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,15,255,252,0,0,15,255,252,0,0,15,255,252,0,
  // 0xba48  멈
  72,186,36,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,192,0,112,255,255,192,0,112,255,255,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,31,240,224,1,192,31,240,224,1,192,31,240,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,255,255,192,0,112,255,255,192,0,112,255,255,192,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,240,0,1,255,255,240,0,1,255,255,240,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,255,255,240,0,1,255,255,240,0,1,255,255,240,
  // 0xba54  메
  84,186,42,39,234,48,3,253,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,255,255,255,0,113,192,255,255,255,0,113,192,255,255,255,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,31,241,192,224,0,7,31,241,192,224,0,7,31,241,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,255,255,255,0,113,192,255,255,255,0,113,192,255,255,255,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,
  // 0xba74  면
  116,186,36,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,192,0,112,255,255,192,0,112,255,255,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,31,240,224,1,192,31,240,224,1,192,31,240,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,31,240,224,1,192,31,240,224,1,192,31,240,255,255,192,0,112,255,255,192,0,112,255,255,192,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,240,3,255,255,255,240,3,255,255,255,240,
  // 0xbaa8  모
  168,186,39,36,180,48,3,0,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xbabb  못
  187,186,39,42,210,48,3,253,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,199,0,0,0,1,199,0,0,0,1,199,0,0,0,126,0,224,0,0,126,0,224,0,0,126,0,224,0,
  // 0xbbf8  미
  248,187,36,39,195,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,255,0,112,255,255,255,0,112,255,255,255,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,255,255,255,0,112,255,255,255,0,112,255,255,255,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,
  // 0xbc00  밀
  0,188,36,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,192,0,112,255,255,192,0,112,255,255,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,224,1,192,0,112,255,255,192,0,112,255,255,192,0,112,255,255,192,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,240,0,15,255,255,240,0,15,255,255,240,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,15,255,255,240,0,15,255,255,240,0,15,255,255,240,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,15,255,255,240,0,15,255,255,240,0,15,255,255,240,
  // 0xbc14  바
  20,188,39,39,195,48,6,253,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,255,255,248,31,254,255,255,248,31,254,255,255,248,31,254,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,255,255,248,28,0,255,255,248,28,0,255,255,248,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,
  // 0xbc84  버
  132,188,39,39,195,48,6,253,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,255,255,248,31,254,255,255,248,31,254,255,255,248,31,254,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,224,0,56,0,14,255,255,248,0,14,255,255,248,0,14,255,255,248,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,
  // 0xbca0  베
  160,188,39,39,195,48,6,253,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,255,255,248,255,142,255,255,248,255,142,255,255,248,255,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,224,0,56,3,142,255,255,248,3,142,255,255,248,3,142,255,255,248,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,
  // 0xbca8  벨
  168,188,36,42,210,48,3,253,0,0,0,28,112,0,0,0,28,112,0,0,0,28,112,0,0,0,28,112,0,0,0,28,112,0,0,0,28,112,224,1,192,28,112,224,1,192,28,112,224,1,192,28,112,224,1,192,28,112,224,1,192,28,112,224,1,192,28,112,255,255,199,252,112,255,255,199,252,112,255,255,199,252,112,224,1,192,28,112,224,1,192,28,112,224,1,192,28,112,255,255,192,28,112,255,255,192,28,112,255,255,192,28,112,0,0,0,28,112,0,0,0,28,112,0,0,0,28,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,240,0,15,255,255,240,0,15,255,255,240,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,15,255,255,240,0,15,255,255,240,0,15,255,255,240,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,15,255,255,240,0,15,255,255,240,0,15,255,255,240,
  // 0xbcf8  본
  248,188,39,42,210,48,3,253,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,
  // 0xbe44  비
  68,190,33,39,195,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,255,255,248,3,128,255,255,248,3,128,255,255,248,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,255,255,248,3,128,255,255,248,3,128,255,255,248,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,
  // 0xc0ac  사
  172,192,42,39,234,48,3,253,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,1,192,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,255,192,0,14,0,3,255,192,0,14,0,3,255,192,0,113,192,3,128,0,0,113,192,3,128,0,0,113,192,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,3,128,56,3,128,0,252,0,7,3,128,0,252,0,7,3,128,0,252,0,7,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0xc0bd  삽
  189,192,42,42,252,48,3,253,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,126,0,0,127,192,0,126,0,0,127,192,0,126,0,0,127,192,3,129,192,0,112,0,3,129,192,0,112,0,3,129,192,0,112,0,252,0,56,0,112,0,252,0,56,0,112,0,252,0,56,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,255,255,240,0,0,1,255,255,240,0,0,1,255,255,240,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,255,255,240,0,0,1,255,255,240,0,0,1,255,255,240,0,
  // 0xc0c8  새
  200,192,42,39,234,48,3,253,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,1,192,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,129,192,0,14,0,3,255,192,0,14,0,3,255,192,0,14,0,3,255,192,0,113,192,3,129,192,0,113,192,3,129,192,0,113,192,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,3,128,56,3,129,192,252,0,7,3,129,192,252,0,7,3,129,192,252,0,7,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,0,0,0,3,129,192,
  // 0xc124  설
  36,193,36,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,126,0,31,240,0,126,0,31,240,0,126,0,31,240,3,129,192,0,112,3,129,192,0,112,3,129,192,0,112,252,0,56,0,112,252,0,56,0,112,252,0,56,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,240,0,15,255,255,240,0,15,255,255,240,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,15,255,255,240,0,15,255,255,240,0,15,255,255,240,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,15,255,255,240,0,15,255,255,240,0,15,255,255,240,
  // 0xc18c  소
  140,193,39,36,180,48,3,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,199,0,0,0,1,199,0,0,0,1,199,0,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,3,240,0,28,0,3,240,0,28,0,3,240,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xc18d  속
  141,193,39,42,210,48,3,253,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,1,192,224,0,0,1,192,224,0,0,1,192,224,0,0,126,0,28,0,0,126,0,28,0,0,126,0,28,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,
  // 0xc2a4  스
  164,194,39,30,150,48,3,6,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,199,0,0,0,1,199,0,0,0,1,199,0,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,3,240,0,28,0,3,240,0,28,0,3,240,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xc2ac  슬
  172,194,39,42,210,48,3,253,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,1,192,224,0,0,1,192,224,0,0,1,192,224,0,0,126,0,28,0,0,126,0,28,0,0,126,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,
  // 0xc2dc  시
  220,194,36,39,195,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,113,192,0,112,0,113,192,0,112,0,113,192,0,112,3,128,56,0,112,3,128,56,0,112,3,128,56,0,112,252,0,7,0,112,252,0,7,0,112,252,0,7,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,
  // 0xc2dd  식
  221,194,36,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,126,0,0,112,0,126,0,0,112,0,126,0,0,112,3,129,192,0,112,3,129,192,0,112,3,129,192,0,112,252,0,56,0,112,252,0,56,0,112,252,0,56,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,240,0,15,255,255,240,0,15,255,255,240,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,
  // 0xc5b4  어
  180,197,42,39,234,48,3,253,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,3,255,192,0,1,192,3,255,192,0,1,192,3,255,192,0,1,192,28,0,56,0,1,192,28,0,56,0,1,192,28,0,56,0,1,192,224,0,7,0,1,192,224,0,7,0,1,192,224,0,7,0,1,192,224,0,7,3,255,192,224,0,7,3,255,192,224,0,7,3,255,192,224,0,7,0,1,192,224,0,7,0,1,192,224,0,7,0,1,192,28,0,56,0,1,192,28,0,56,0,1,192,28,0,56,0,1,192,3,255,192,0,1,192,3,255,192,0,1,192,3,255,192,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,0,0,0,0,1,192,
  // 0xc5c6  없
  198,197,39,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,31,254,0,3,128,31,254,0,3,128,31,254,0,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,255,128,224,1,192,255,128,224,1,192,255,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,31,254,0,3,128,31,254,0,3,128,31,254,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,255,255,192,3,128,255,255,192,3,128,255,255,192,3,128,224,1,192,28,112,224,1,192,28,112,224,1,192,28,112,255,255,199,224,14,255,255,199,224,14,255,255,199,224,14,
  // 0xc5d1  엑
  209,197,33,42,210,48,6,253,0,0,0,227,128,0,0,0,227,128,0,0,0,227,128,31,254,0,227,128,31,254,0,227,128,31,254,0,227,128,224,1,192,227,128,224,1,192,227,128,224,1,192,227,128,224,1,192,227,128,224,1,192,227,128,224,1,192,227,128,224,1,255,227,128,224,1,255,227,128,224,1,255,227,128,224,1,192,227,128,224,1,192,227,128,224,1,192,227,128,31,254,0,227,128,31,254,0,227,128,31,254,0,227,128,0,0,0,227,128,0,0,0,227,128,0,0,0,227,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,128,0,127,255,255,128,0,127,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,
  // 0xc5d4  엔
  212,197,33,42,210,48,6,253,0,0,0,227,128,0,0,0,227,128,0,0,0,227,128,31,254,0,227,128,31,254,0,227,128,31,254,0,227,128,224,1,192,227,128,224,1,192,227,128,224,1,192,227,128,224,1,192,227,128,224,1,192,227,128,224,1,192,227,128,224,1,255,227,128,224,1,255,227,128,224,1,255,227,128,224,1,192,227,128,224,1,192,227,128,224,1,192,227,128,31,254,0,227,128,31,254,0,227,128,31,254,0,227,128,0,0,0,227,128,0,0,0,227,128,0,0,0,227,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,
  // 0xc5f4  열
  244,197,33,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,31,254,0,3,128,31,254,0,3,128,31,254,0,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,255,128,224,1,192,255,128,224,1,192,255,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,255,128,224,1,192,255,128,224,1,192,255,128,31,254,0,3,128,31,254,0,3,128,31,254,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,128,0,127,255,255,128,0,127,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,127,255,255,128,0,127,255,255,128,0,127,255,255,128,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,127,255,255,128,0,127,255,255,128,0,127,255,255,128,
  // 0xc608  예
  8,198,42,39,234,48,3,253,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,3,255,192,0,113,192,3,255,192,0,113,192,3,255,192,0,113,192,28,0,56,0,113,192,28,0,56,0,113,192,28,0,56,0,113,192,224,0,7,31,241,192,224,0,7,31,241,192,224,0,7,31,241,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,224,0,7,0,113,192,28,0,56,31,241,192,28,0,56,31,241,192,28,0,56,31,241,192,3,255,192,0,113,192,3,255,192,0,113,192,3,255,192,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,0,0,0,0,113,192,
  // 0xc624  오
  36,198,39,39,195,48,3,0,0,15,255,224,0,0,15,255,224,0,0,15,255,224,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,15,255,224,0,0,15,255,224,0,0,15,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xc628  온
  40,198,39,42,210,48,3,253,0,15,255,224,0,0,15,255,224,0,0,15,255,224,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,15,255,224,0,0,15,255,224,0,0,15,255,224,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,
  // 0xc644  완
  68,198,42,42,252,48,3,253,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,3,255,248,0,112,0,3,255,248,0,112,0,3,255,248,0,112,0,28,0,7,0,112,0,28,0,7,0,112,0,28,0,7,0,112,0,28,0,7,0,127,192,28,0,7,0,127,192,28,0,7,0,127,192,28,0,7,0,112,0,28,0,7,0,112,0,28,0,7,0,112,0,3,255,248,0,112,0,3,255,248,0,112,0,3,255,248,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,255,255,255,252,112,0,255,255,255,252,112,0,255,255,255,252,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,0,127,255,255,240,0,
  // 0xc6d0  원
  208,198,36,45,225,48,3,253,3,255,248,0,112,3,255,248,0,112,3,255,248,0,112,28,0,7,0,112,28,0,7,0,112,28,0,7,0,112,28,0,7,0,112,28,0,7,0,112,28,0,7,0,112,28,0,7,0,112,28,0,7,0,112,28,0,7,0,112,3,255,248,0,112,3,255,248,0,112,3,255,248,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,255,252,112,255,255,255,252,112,255,255,255,252,112,0,1,192,255,240,0,1,192,255,240,0,1,192,255,240,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,240,3,255,255,255,240,3,255,255,255,240,
  // 0xc704  위
  4,199,36,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,3,255,248,0,112,3,255,248,0,112,3,255,248,0,112,28,0,7,0,112,28,0,7,0,112,28,0,7,0,112,224,0,0,224,112,224,0,0,224,112,224,0,0,224,112,224,0,0,224,112,224,0,0,224,112,224,0,0,224,112,224,0,0,224,112,224,0,0,224,112,224,0,0,224,112,28,0,7,0,112,28,0,7,0,112,28,0,7,0,112,3,255,248,0,112,3,255,248,0,112,3,255,248,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,255,252,112,255,255,255,252,112,255,255,255,252,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,
  // 0xc73c  으
  60,199,39,33,165,48,3,6,0,15,255,224,0,0,15,255,224,0,0,15,255,224,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,15,255,224,0,0,15,255,224,0,0,15,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xc74c  음
  76,199,39,42,210,48,3,253,0,15,255,224,0,0,15,255,224,0,0,15,255,224,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,15,255,224,0,0,15,255,224,0,0,15,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,
  // 0xc774  이
  116,199,36,39,195,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,3,255,192,0,112,3,255,192,0,112,3,255,192,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,224,0,7,0,112,28,0,56,0,112,28,0,56,0,112,28,0,56,0,112,3,255,192,0,112,3,255,192,0,112,3,255,192,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,
  // 0xc77c  일
  124,199,33,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,31,254,0,3,128,31,254,0,3,128,31,254,0,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,31,254,0,3,128,31,254,0,3,128,31,254,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,128,0,127,255,255,128,0,127,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,127,255,255,128,0,127,255,255,128,0,127,255,255,128,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,127,255,255,128,0,127,255,255,128,0,127,255,255,128,
  // 0xc77d  읽
  125,199,33,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,31,254,0,3,128,31,254,0,3,128,31,254,0,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,31,254,0,3,128,31,254,0,3,128,31,254,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,254,63,255,128,255,254,63,255,128,255,254,63,255,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,255,254,0,3,128,255,254,0,3,128,255,254,0,3,128,224,0,0,3,128,224,0,0,3,128,224,0,0,3,128,255,254,0,3,128,255,254,0,3,128,255,254,0,3,128,
  // 0xc785  입
  133,199,33,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,31,254,0,3,128,31,254,0,3,128,31,254,0,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,224,1,192,3,128,31,254,0,3,128,31,254,0,3,128,31,254,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,15,255,255,128,0,15,255,255,128,0,15,255,255,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,15,255,255,128,0,15,255,255,128,0,15,255,255,128,
  // 0xc790  자
  144,199,39,39,195,48,6,253,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,255,255,248,28,0,255,255,248,28,0,255,255,248,28,0,0,1,192,28,0,0,1,192,28,0,0,1,192,28,0,0,1,192,28,0,0,1,192,28,0,0,1,192,28,0,0,14,0,31,254,0,14,0,31,254,0,14,0,31,254,0,126,0,28,0,0,126,0,28,0,0,126,0,28,0,3,129,192,28,0,3,129,192,28,0,3,129,192,28,0,252,0,56,28,0,252,0,56,28,0,252,0,56,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,
  // 0xc791  작
  145,199,42,42,252,48,3,253,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,127,192,0,14,0,0,127,192,0,14,0,0,127,192,3,241,192,0,112,0,3,241,192,0,112,0,3,241,192,0,112,0,252,0,56,0,112,0,252,0,56,0,112,0,252,0,56,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,
  // 0xc798  잘
  152,199,42,42,252,48,3,253,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,127,192,0,14,0,0,127,192,0,14,0,0,127,192,3,241,192,0,112,0,3,241,192,0,112,0,3,241,192,0,112,0,252,0,56,0,112,0,252,0,56,0,112,0,252,0,56,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,0,14,0,0,0,0,0,14,0,0,0,0,0,14,0,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,255,255,240,0,
  // 0xc7a5  장
  165,199,42,42,252,48,3,253,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,127,192,0,14,0,0,127,192,0,14,0,0,127,192,3,241,192,0,112,0,3,241,192,0,112,0,3,241,192,0,112,0,252,0,56,0,112,0,252,0,56,0,112,0,252,0,56,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,128,0,0,1,255,255,128,0,0,1,255,255,128,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,14,0,0,112,0,0,1,255,255,128,0,0,1,255,255,128,0,0,1,255,255,128,0,
  // 0xc7ac  재
  172,199,39,39,195,48,6,253,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,255,255,248,28,14,255,255,248,28,14,255,255,248,28,14,0,1,192,28,14,0,1,192,28,14,0,1,192,28,14,0,1,192,28,14,0,1,192,28,14,0,1,192,28,14,0,14,0,31,254,0,14,0,31,254,0,14,0,31,254,0,126,0,28,14,0,126,0,28,14,0,126,0,28,14,3,129,192,28,14,3,129,192,28,14,3,129,192,28,14,252,0,56,28,14,252,0,56,28,14,252,0,56,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,
  // 0xc800  저
  0,200,39,39,195,48,6,253,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,255,255,248,0,14,255,255,248,0,14,255,255,248,0,14,0,1,192,0,14,0,1,192,0,14,0,1,192,0,14,0,1,192,0,14,0,1,192,0,14,0,1,192,0,14,0,14,0,31,254,0,14,0,31,254,0,14,0,31,254,0,126,0,0,14,0,126,0,0,14,0,126,0,0,14,3,129,192,0,14,3,129,192,0,14,3,129,192,0,14,252,0,56,0,14,252,0,56,0,14,252,0,56,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,
  // 0xc804  전
  4,200,36,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,192,0,112,255,255,192,0,112,255,255,192,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,31,240,0,14,0,31,240,0,14,0,31,240,3,241,192,0,112,3,241,192,0,112,3,241,192,0,112,252,0,56,0,112,252,0,56,0,112,252,0,56,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,240,3,255,255,255,240,3,255,255,255,240,
  // 0xc815  정
  21,200,36,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,192,0,112,255,255,192,0,112,255,255,192,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,31,240,0,14,0,31,240,0,14,0,31,240,3,241,192,0,112,3,241,192,0,112,3,241,192,0,112,252,0,56,0,112,252,0,56,0,112,252,0,56,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,128,0,1,255,255,128,0,1,255,255,128,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,1,255,255,128,0,1,255,255,128,0,1,255,255,128,
  // 0xc81c  제
  28,200,39,39,195,48,6,253,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,255,255,248,3,142,255,255,248,3,142,255,255,248,3,142,0,1,192,3,142,0,1,192,3,142,0,1,192,3,142,0,1,192,3,142,0,1,192,3,142,0,1,192,3,142,0,14,0,255,142,0,14,0,255,142,0,14,0,255,142,0,126,0,3,142,0,126,0,3,142,0,126,0,3,142,3,129,192,3,142,3,129,192,3,142,3,129,192,3,142,252,0,56,3,142,252,0,56,3,142,252,0,56,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,
  // 0xc8fd  죽
  253,200,39,42,210,48,3,253,0,127,255,224,0,0,127,255,224,0,0,127,255,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,1,248,224,0,0,1,248,224,0,0,1,248,224,0,0,126,0,28,0,0,126,0,28,0,0,126,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,
  // 0xc900  준
  0,201,39,42,210,48,3,253,0,127,255,224,0,0,127,255,224,0,0,127,255,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,1,248,224,0,0,1,248,224,0,0,1,248,224,0,0,126,0,28,0,0,126,0,28,0,0,126,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,3,128,56,0,0,3,128,56,0,0,3,128,56,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,
  // 0xc911  중
  17,201,39,42,210,48,3,253,0,127,255,224,0,0,127,255,224,0,0,127,255,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,1,248,224,0,0,1,248,224,0,0,1,248,224,0,0,126,0,28,0,0,126,0,28,0,0,126,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,224,0,0,15,255,224,0,0,15,255,224,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,15,255,224,0,0,15,255,224,0,0,15,255,224,0,
  // 0xc990  즐
  144,201,39,42,210,48,3,253,0,127,255,224,0,0,127,255,224,0,0,127,255,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,1,248,224,0,0,1,248,224,0,0,1,248,224,0,0,126,0,28,0,0,126,0,28,0,0,126,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,
  // 0xc9c0  지
  192,201,33,39,195,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,255,255,248,3,128,255,255,248,3,128,255,255,248,3,128,0,1,192,3,128,0,1,192,3,128,0,1,192,3,128,0,1,192,3,128,0,1,192,3,128,0,1,192,3,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,126,0,3,128,0,126,0,3,128,0,126,0,3,128,3,129,192,3,128,3,129,192,3,128,3,129,192,3,128,252,0,56,3,128,252,0,56,3,128,252,0,56,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,
  // 0xcc98  처
  152,204,39,39,195,48,6,253,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,0,112,0,0,14,255,255,248,0,14,255,255,248,0,14,255,255,248,0,14,0,1,192,0,14,0,1,192,0,14,0,1,192,0,14,0,14,0,31,254,0,14,0,31,254,0,14,0,31,254,0,126,0,0,14,0,126,0,0,14,0,126,0,0,14,3,129,192,0,14,3,129,192,0,14,3,129,192,0,14,252,0,56,0,14,252,0,56,0,14,252,0,56,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,
  // 0xcd08  초
  8,205,39,39,195,48,3,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,127,255,252,0,0,127,255,252,0,0,127,255,252,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,1,192,224,0,0,1,192,224,0,0,1,192,224,0,0,126,0,28,0,0,126,0,28,0,0,126,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xcd95  축
  149,205,39,42,210,48,3,253,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,127,255,224,0,0,127,255,224,0,0,127,255,224,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,199,0,0,0,1,199,0,0,0,1,199,0,0,0,126,0,224,0,0,126,0,224,0,0,126,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,
  // 0xcd9c  출
  156,205,39,42,210,48,3,253,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,127,255,224,0,0,127,255,224,0,0,127,255,224,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,199,0,0,0,1,199,0,0,0,1,199,0,0,0,126,0,224,0,0,126,0,224,0,0,126,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,
  // 0xcda4  춤
  164,205,39,42,210,48,3,253,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,127,255,224,0,0,127,255,224,0,0,127,255,224,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,199,0,0,0,1,199,0,0,0,1,199,0,0,0,126,0,224,0,0,126,0,224,0,0,126,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,
  // 0xcde8  취
  232,205,36,42,210,48,3,253,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,31,255,255,0,112,31,255,255,0,112,31,255,255,0,112,0,0,56,0,112,0,0,56,0,112,0,0,56,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,15,192,0,112,0,15,192,0,112,0,15,192,0,112,0,112,56,0,112,0,112,56,0,112,0,112,56,0,112,31,128,7,0,112,31,128,7,0,112,31,128,7,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,255,252,112,255,255,255,252,112,255,255,255,252,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,
  // 0xce58  치
  88,206,33,39,195,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,255,255,248,3,128,255,255,248,3,128,255,255,248,3,128,0,1,192,3,128,0,1,192,3,128,0,1,192,3,128,0,14,0,3,128,0,14,0,3,128,0,14,0,3,128,0,126,0,3,128,0,126,0,3,128,0,126,0,3,128,3,129,192,3,128,3,129,192,3,128,3,129,192,3,128,252,0,56,3,128,252,0,56,3,128,252,0,56,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,
  // 0xce68  침
  104,206,36,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,112,0,0,112,0,112,0,0,112,0,112,0,0,112,255,255,192,0,112,255,255,192,0,112,255,255,192,0,112,0,112,0,0,112,0,112,0,0,112,0,112,0,0,112,3,142,0,0,112,3,142,0,0,112,3,142,0,0,112,252,1,192,0,112,252,1,192,0,112,252,1,192,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,240,0,1,255,255,240,0,1,255,255,240,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,255,255,240,0,1,255,255,240,0,1,255,255,240,
  // 0xce74  카
  116,206,36,39,195,48,9,253,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,255,255,192,224,0,255,255,192,224,0,255,255,192,224,0,0,1,192,224,0,0,1,192,224,0,0,1,192,224,0,0,1,192,224,0,0,1,192,224,0,0,1,192,224,0,0,1,192,255,240,0,1,192,255,240,0,1,192,255,240,255,254,0,224,0,255,254,0,224,0,255,254,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,112,0,224,0,0,112,0,224,0,0,112,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,252,0,0,224,0,252,0,0,224,0,252,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,
  // 0xcf1c  켜
  28,207,36,39,195,48,9,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,255,255,192,0,112,255,255,192,0,112,255,255,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,1,192,255,240,0,1,192,255,240,0,1,192,255,240,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,255,254,0,0,112,255,254,0,0,112,255,254,0,0,112,0,14,0,255,240,0,14,0,255,240,0,14,0,255,240,0,112,0,0,112,0,112,0,0,112,0,112,0,0,112,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,252,0,0,0,112,252,0,0,0,112,252,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,
  // 0xd0d1  탑
  209,208,42,42,252,48,3,253,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,255,255,192,0,127,192,255,255,192,0,127,192,255,255,192,0,127,192,224,0,0,0,112,0,224,0,0,0,112,0,224,0,0,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,255,255,192,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,255,255,240,0,0,1,255,255,240,0,0,1,255,255,240,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,255,255,240,0,0,1,255,255,240,0,0,1,255,255,240,0,
  // 0xd130  터
  48,209,39,39,195,48,6,253,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,255,255,248,0,14,255,255,248,0,14,255,255,248,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,255,255,248,31,254,255,255,248,31,254,255,255,248,31,254,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,224,0,0,0,14,255,255,248,0,14,255,255,248,0,14,255,255,248,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,
  // 0xd14c  테
  76,209,39,39,195,48,6,253,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,255,255,248,3,142,255,255,248,3,142,255,255,248,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,255,255,248,255,142,255,255,248,255,142,255,255,248,255,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,224,0,0,3,142,255,255,248,3,142,255,255,248,3,142,255,255,248,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,
  // 0xd1a0  토
  160,209,39,39,195,48,3,0,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xd2b8  트
  184,210,39,33,165,48,3,6,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xd39c  펜
  156,211,36,42,210,48,3,253,0,0,0,28,112,0,0,0,28,112,0,0,0,28,112,0,0,0,28,112,0,0,0,28,112,0,0,0,28,112,255,255,255,28,112,255,255,255,28,112,255,255,255,28,112,3,129,192,28,112,3,129,192,28,112,3,129,192,28,112,3,129,199,252,112,3,129,199,252,112,3,129,199,252,112,3,129,192,28,112,3,129,192,28,112,3,129,192,28,112,255,255,255,28,112,255,255,255,28,112,255,255,255,28,112,0,0,0,28,112,0,0,0,28,112,0,0,0,28,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,127,255,255,240,0,127,255,255,240,0,127,255,255,240,
  // 0xd504  프
  4,213,39,30,150,48,3,6,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,
  // 0xd558  하
  88,213,39,39,195,48,6,253,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,255,255,248,28,0,255,255,248,28,0,255,255,248,28,0,3,254,0,28,0,3,254,0,28,0,3,254,0,28,0,28,1,192,28,0,28,1,192,28,0,28,1,192,28,0,224,0,56,31,254,224,0,56,31,254,224,0,56,31,254,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,224,0,56,28,0,28,1,192,28,0,28,1,192,28,0,28,1,192,28,0,3,254,0,28,0,3,254,0,28,0,3,254,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,
  // 0xd569  합
  105,213,42,42,252,48,3,253,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,255,255,248,0,112,0,255,255,248,0,112,0,255,255,248,0,112,0,3,254,0,0,112,0,3,254,0,0,112,0,3,254,0,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,127,192,28,1,192,0,127,192,28,1,192,0,127,192,28,1,192,0,112,0,28,1,192,0,112,0,28,1,192,0,112,0,3,254,0,0,112,0,3,254,0,0,112,0,3,254,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,255,255,240,0,0,1,255,255,240,0,0,1,255,255,240,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,192,0,112,0,0,1,255,255,240,0,0,1,255,255,240,0,0,1,255,255,240,0,
  // 0xd648  홈
  72,214,39,45,225,48,3,253,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,127,255,252,0,0,127,255,252,0,0,127,255,252,0,0,15,255,224,0,0,15,255,224,0,0,15,255,224,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,15,255,224,0,0,15,255,224,0,0,15,255,224,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,255,255,255,255,254,255,255,255,255,254,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,128,0,3,128,3,255,255,255,128,3,255,255,255,128,3,255,255,255,128,
  // 0xd654  화
  84,214,42,42,252,48,3,253,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,31,255,255,3,128,0,31,255,255,3,128,0,31,255,255,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,3,255,248,3,128,0,3,255,248,3,128,0,3,255,248,3,128,0,28,0,7,3,255,192,28,0,7,3,255,192,28,0,7,3,255,192,28,0,7,3,128,0,28,0,7,3,128,0,28,0,7,3,128,0,3,255,248,3,128,0,3,255,248,3,128,0,3,255,248,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,255,255,255,227,128,0,255,255,255,227,128,0,255,255,255,227,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,0,0,0,3,128,0,
  // 0xd788  히
  136,215,33,39,195,48,6,253,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,255,255,248,3,128,255,255,248,3,128,255,255,248,3,128,3,254,0,3,128,3,254,0,3,128,3,254,0,3,128,28,1,192,3,128,28,1,192,3,128,28,1,192,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,224,0,56,3,128,28,1,192,3,128,28,1,192,3,128,28,1,192,3,128,3,254,0,3,128,3,254,0,3,128,3,254,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,
};

#endif // HAS_GRAPHICAL_TFT
