/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont 48pt, capital 'A' height: 30px, width: 100%, range: 0x0020-0x00ff
extern const uint8_t Unifont_30[16801] = {
  129,30,32,0,255,0,42,250, // unifont_t
  // 0x0020 " "
  0,0,0,24,0,0,
  // 0x0021  !
  3,30,30,24,12,0,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,0,0,0,224,224,224,224,224,224,
  // 0x0022  "
  15,12,24,24,6,24,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,
  // 0x0023  #
  18,30,90,24,3,0,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,255,255,192,255,255,192,255,255,192,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,255,255,192,255,255,192,255,255,192,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,
  // 0x0024  $
  21,30,90,24,3,0,0,112,0,0,112,0,0,112,0,31,255,192,31,255,192,31,255,192,224,112,56,224,112,56,224,112,56,224,112,0,224,112,0,224,112,0,31,240,0,31,240,0,31,240,0,0,127,192,0,127,192,0,127,192,0,112,56,0,112,56,0,112,56,224,112,56,224,112,56,224,112,56,31,255,192,31,255,192,31,255,192,0,112,0,0,112,0,0,112,0,
  // 0x0025  %
  21,30,90,24,3,0,31,128,56,31,128,56,31,128,56,224,113,192,224,113,192,224,113,192,224,113,192,224,113,192,224,113,192,31,142,0,31,142,0,31,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,143,192,3,143,192,3,143,192,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,28,112,56,224,15,192,224,15,192,224,15,192,
  // 0x0026  &
  21,30,90,24,3,0,3,254,0,3,254,0,3,254,0,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,3,142,0,3,142,0,3,142,0,3,240,0,3,240,0,3,240,0,28,112,56,28,112,56,28,112,56,224,14,56,224,14,56,224,14,56,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,240,56,31,240,56,31,240,56,
  // 0x0027  '
  3,12,12,24,12,24,224,224,224,224,224,224,224,224,224,224,224,224,
  // 0x0028  (
  9,36,72,24,9,253,3,128,3,128,3,128,28,0,28,0,28,0,28,0,28,0,28,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,28,0,28,0,28,0,28,0,28,0,28,0,3,128,3,128,3,128,
  // 0x0029  )
  9,36,72,24,6,253,224,0,224,0,224,0,28,0,28,0,28,0,28,0,28,0,28,0,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,28,0,28,0,28,0,28,0,28,0,28,0,224,0,224,0,224,0,
  // 0x002a  *
  21,21,63,24,3,3,0,112,0,0,112,0,0,112,0,224,112,56,224,112,56,224,112,56,28,113,192,28,113,192,28,113,192,3,254,0,3,254,0,3,254,0,28,113,192,28,113,192,28,113,192,224,112,56,224,112,56,224,112,56,0,112,0,0,112,0,0,112,0,
  // 0x002b  +
  21,21,63,24,3,3,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,255,255,248,255,255,248,255,255,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x002c  ,
  6,12,12,24,9,250,252,252,252,28,28,28,28,28,28,224,224,224,
  // 0x002d  -
  12,3,6,24,6,12,255,240,255,240,255,240,
  // 0x002e  .
  6,6,6,24,9,0,252,252,252,252,252,252,
  // 0x002f  /
  18,30,90,24,3,0,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,
  // 0x0030  0
  18,30,90,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,224,113,192,224,113,192,224,113,192,227,129,192,227,129,192,227,129,192,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,
  // 0x0031  1
  15,30,60,24,6,0,3,128,3,128,3,128,31,128,31,128,31,128,227,128,227,128,227,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x0032  2
  18,30,90,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,0,126,0,0,126,0,0,126,0,3,128,0,3,128,0,3,128,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x0033  3
  18,30,90,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,3,254,0,3,254,0,3,254,0,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0034  4
  18,30,90,24,3,0,0,14,0,0,14,0,0,14,0,0,126,0,0,126,0,0,126,0,3,142,0,3,142,0,3,142,0,28,14,0,28,14,0,28,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,255,255,192,255,255,192,255,255,192,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,
  // 0x0035  5
  18,30,90,24,3,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0036  6
  18,30,90,24,3,0,3,254,0,3,254,0,3,254,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0037  7
  18,30,90,24,3,0,255,255,192,255,255,192,255,255,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x0038  8
  18,30,90,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0039  9
  18,30,90,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,255,192,31,255,192,31,255,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,31,240,0,31,240,0,31,240,0,
  // 0x003a  :
  6,21,21,24,9,3,252,252,252,252,252,252,0,0,0,0,0,0,0,0,0,252,252,252,252,252,252,
  // 0x003b  ;
  6,27,27,24,9,253,252,252,252,252,252,252,0,0,0,0,0,0,0,0,0,252,252,252,28,28,28,28,28,28,224,224,224,
  // 0x003c  <
  15,27,54,24,6,0,0,14,0,14,0,14,0,112,0,112,0,112,3,128,3,128,3,128,28,0,28,0,28,0,224,0,224,0,224,0,28,0,28,0,28,0,3,128,3,128,3,128,0,112,0,112,0,112,0,14,0,14,0,14,
  // 0x003d  =
  18,15,45,24,3,6,255,255,192,255,255,192,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,
  // 0x003e  >
  15,27,54,24,3,0,224,0,224,0,224,0,28,0,28,0,28,0,3,128,3,128,3,128,0,112,0,112,0,112,0,14,0,14,0,14,0,112,0,112,0,112,3,128,3,128,3,128,28,0,28,0,28,0,224,0,224,0,224,0,
  // 0x003f  ?
  18,30,90,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,0,0,0,0,0,0,0,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x0040  @
  18,30,90,24,3,0,3,254,0,3,254,0,3,254,0,28,1,192,28,1,192,28,1,192,224,113,192,224,113,192,224,113,192,227,143,192,227,143,192,227,143,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,224,127,192,224,127,192,224,127,192,28,0,0,28,0,0,28,0,0,3,255,192,3,255,192,3,255,192,
  // 0x0041  A
  18,30,90,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0042  B
  18,30,90,24,3,0,255,254,0,255,254,0,255,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,254,0,255,254,0,255,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,254,0,255,254,0,255,254,0,
  // 0x0043  C
  18,30,90,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0044  D
  18,30,90,24,3,0,255,240,0,255,240,0,255,240,0,224,14,0,224,14,0,224,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,14,0,224,14,0,224,14,0,255,240,0,255,240,0,255,240,0,
  // 0x0045  E
  18,30,90,24,3,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x0046  F
  18,30,90,24,3,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,
  // 0x0047  G
  18,30,90,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,127,192,224,127,192,224,127,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x0048  H
  18,30,90,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0049  I
  15,30,60,24,6,0,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x004a  J
  21,30,90,24,3,0,3,255,248,3,255,248,3,255,248,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,
  // 0x004b  K
  18,30,90,24,3,0,224,1,192,224,1,192,224,1,192,224,14,0,224,14,0,224,14,0,224,112,0,224,112,0,224,112,0,227,128,0,227,128,0,227,128,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,252,0,0,227,128,0,227,128,0,227,128,0,224,112,0,224,112,0,224,112,0,224,14,0,224,14,0,224,14,0,224,1,192,224,1,192,224,1,192,
  // 0x004c  L
  18,30,90,24,3,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x004d  M
  18,30,90,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,252,15,192,252,15,192,252,15,192,252,15,192,252,15,192,252,15,192,227,241,192,227,241,192,227,241,192,227,241,192,227,241,192,227,241,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x004e  N
  18,30,90,24,3,0,224,1,192,224,1,192,224,1,192,252,1,192,252,1,192,252,1,192,252,1,192,252,1,192,252,1,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,224,113,192,224,113,192,224,113,192,224,113,192,224,113,192,224,113,192,224,15,192,224,15,192,224,15,192,224,15,192,224,15,192,224,15,192,224,1,192,224,1,192,224,1,192,
  // 0x004f  O
  18,30,90,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0050  P
  18,30,90,24,3,0,255,254,0,255,254,0,255,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,
  // 0x0051  Q
  21,33,99,24,3,253,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,227,241,192,227,241,192,227,241,192,252,15,192,252,15,192,252,15,192,31,254,0,31,254,0,31,254,0,0,1,248,0,1,248,0,1,248,
  // 0x0052  R
  18,30,90,24,3,0,255,254,0,255,254,0,255,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,254,0,255,254,0,255,254,0,224,112,0,224,112,0,224,112,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0053  S
  18,30,90,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,1,192,0,1,192,0,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0054  T
  21,30,90,24,3,0,255,255,248,255,255,248,255,255,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x0055  U
  18,30,90,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0056  V
  21,30,90,24,3,0,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,3,142,0,3,142,0,3,142,0,3,142,0,3,142,0,3,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x0057  W
  18,30,90,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,227,241,192,227,241,192,227,241,192,227,241,192,227,241,192,227,241,192,252,15,192,252,15,192,252,15,192,252,15,192,252,15,192,252,15,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0058  X
  18,30,90,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0059  Y
  21,30,90,24,3,0,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,3,142,0,3,142,0,3,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x005a  Z
  18,30,90,24,3,0,255,255,192,255,255,192,255,255,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x005b  [
  9,36,72,24,12,253,255,128,255,128,255,128,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,224,0,255,128,255,128,255,128,
  // 0x005c "\"
  18,30,90,24,3,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,28,0,0,28,0,0,28,0,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,14,0,0,14,0,0,14,0,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,
  // 0x005d  ]
  9,36,72,24,3,253,255,128,255,128,255,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,128,255,128,255,128,
  // 0x005e  ^
  18,9,27,24,3,27,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,
  // 0x005f  _
  21,3,9,24,3,253,255,255,248,255,255,248,255,255,248,
  // 0x0060  `
  9,9,18,24,6,30,224,0,224,0,224,0,28,0,28,0,28,0,3,128,3,128,3,128,
  // 0x0061  a
  18,24,72,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x0062  b
  18,33,99,24,3,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,252,1,192,252,1,192,252,1,192,227,254,0,227,254,0,227,254,0,
  // 0x0063  c
  18,24,72,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0064  d
  18,33,99,24,3,0,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,31,241,192,31,241,192,31,241,192,224,15,192,224,15,192,224,15,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x0065  e
  18,24,72,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0066  f
  15,33,66,24,3,0,0,126,0,126,0,126,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,
  // 0x0067  g
  18,33,99,24,3,250,0,1,192,0,1,192,0,1,192,31,241,192,31,241,192,31,241,192,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,31,240,0,31,240,0,31,240,0,28,0,0,28,0,0,28,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0068  h
  18,33,99,24,3,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0069  i
  15,33,66,24,6,0,3,128,3,128,3,128,3,128,3,128,3,128,0,0,0,0,0,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x006a  j
  15,39,78,24,3,250,0,14,0,14,0,14,0,14,0,14,0,14,0,0,0,0,0,0,0,126,0,126,0,126,0,14,0,14,0,14,0,14,0,14,0,14,0,14,0,14,0,14,0,14,0,14,0,14,0,14,0,14,0,14,0,14,0,14,0,14,0,14,0,14,0,14,224,112,224,112,224,112,31,128,31,128,31,128,
  // 0x006b  k
  18,33,99,24,3,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,14,0,224,14,0,224,14,0,224,112,0,224,112,0,224,112,0,227,128,0,227,128,0,227,128,0,252,0,0,252,0,0,252,0,0,227,128,0,227,128,0,227,128,0,224,112,0,224,112,0,224,112,0,224,14,0,224,14,0,224,14,0,224,1,192,224,1,192,224,1,192,
  // 0x006c  l
  15,33,66,24,6,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x006d  m
  21,24,72,24,3,0,255,143,192,255,143,192,255,143,192,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,
  // 0x006e  n
  18,24,72,24,3,0,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x006f  o
  18,24,72,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0070  p
  18,30,90,24,3,250,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,252,1,192,252,1,192,252,1,192,227,254,0,227,254,0,227,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,
  // 0x0071  q
  18,30,90,24,3,250,31,241,192,31,241,192,31,241,192,224,15,192,224,15,192,224,15,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,
  // 0x0072  r
  18,24,72,24,3,0,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,
  // 0x0073  s
  18,24,72,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,1,192,0,1,192,0,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x0074  t
  15,30,60,24,3,0,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,0,126,0,126,0,126,
  // 0x0075  u
  18,24,72,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x0076  v
  18,24,72,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,
  // 0x0077  w
  21,24,72,24,3,0,224,0,56,224,0,56,224,0,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,224,112,56,31,143,192,31,143,192,31,143,192,
  // 0x0078  x
  18,24,72,24,3,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x0079  y
  18,30,90,24,3,250,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,28,15,192,28,15,192,28,15,192,3,241,192,3,241,192,3,241,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,31,254,0,31,254,0,31,254,0,
  // 0x007a  z
  18,24,72,24,3,0,255,255,192,255,255,192,255,255,192,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x007b  {
  12,39,78,24,6,250,3,240,3,240,3,240,28,0,28,0,28,0,28,0,28,0,28,0,3,128,3,128,3,128,3,128,3,128,3,128,28,0,28,0,28,0,224,0,224,0,224,0,28,0,28,0,28,0,3,128,3,128,3,128,3,128,3,128,3,128,28,0,28,0,28,0,28,0,28,0,28,0,3,240,3,240,3,240,
  // 0x007c  |
  3,42,42,24,12,250,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
  // 0x007d  }
  12,39,78,24,6,250,252,0,252,0,252,0,3,128,3,128,3,128,3,128,3,128,3,128,28,0,28,0,28,0,28,0,28,0,28,0,3,128,3,128,3,128,0,112,0,112,0,112,3,128,3,128,3,128,28,0,28,0,28,0,28,0,28,0,28,0,3,128,3,128,3,128,3,128,3,128,3,128,252,0,252,0,252,0,
  // 0x007e  ~
  21,9,27,24,3,24,31,128,56,31,128,56,31,128,56,224,112,56,224,112,56,224,112,56,224,15,192,224,15,192,224,15,192,
  // 0x007f - 0x009a  Control Characters
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x00a0 "�"
  0,0,0,24,0,0,
  // 0x00a1  ¡
  3,30,30,24,12,0,224,224,224,224,224,224,0,0,0,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,224,
  // 0x00a2  ¢
  21,30,90,24,3,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,31,255,192,31,255,192,31,255,192,224,112,56,224,112,56,224,112,56,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,56,224,112,56,224,112,56,31,255,192,31,255,192,31,255,192,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x00a3  £
  21,30,90,24,3,0,0,127,192,0,127,192,0,127,192,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,255,254,0,255,254,0,255,254,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,31,255,192,31,255,192,31,255,192,252,0,56,252,0,56,252,0,56,
  // 0x00a4  ¤
  18,24,72,24,3,3,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,28,14,0,28,14,0,28,14,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,
  // 0x00a5  ¥
  21,30,90,24,3,0,224,0,56,224,0,56,224,0,56,28,1,192,28,1,192,28,1,192,3,142,0,3,142,0,3,142,0,0,112,0,0,112,0,0,112,0,255,255,248,255,255,248,255,255,248,0,112,0,0,112,0,0,112,0,255,255,248,255,255,248,255,255,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x00a6  ¦
  3,30,30,24,12,0,224,224,224,224,224,224,224,224,224,224,224,224,0,0,0,0,0,0,224,224,224,224,224,224,224,224,224,224,224,224,
  // 0x00a7  §
  18,30,90,24,3,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,1,192,0,1,192,0,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00a8  ¨
  12,6,12,24,6,36,224,112,224,112,224,112,224,112,224,112,224,112,
  // 0x00a9  ©
  24,30,90,24,0,0,3,255,192,3,255,192,3,255,192,28,0,56,28,0,56,28,0,56,224,126,7,224,126,7,224,126,7,227,129,199,227,129,199,227,129,199,227,128,7,227,128,7,227,128,7,227,128,7,227,128,7,227,128,7,227,129,199,227,129,199,227,129,199,224,126,7,224,126,7,224,126,7,28,0,56,28,0,56,28,0,56,3,255,192,3,255,192,3,255,192,
  // 0x00aa  ª
  15,21,42,24,6,15,31,240,31,240,31,240,0,14,0,14,0,14,31,254,31,254,31,254,224,14,224,14,224,14,31,254,31,254,31,254,0,0,0,0,0,0,255,254,255,254,255,254,
  // 0x00ab  «
  18,27,81,24,3,0,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,112,0,224,112,0,224,112,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,3,129,192,
  // 0x00ac  ¬
  18,12,36,24,3,0,255,255,192,255,255,192,255,255,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,
  // 0x00ad  ­
  48,48,32,48,0,250,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,227,142,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,3,254,56,31,128,63,3,254,56,31,128,63,3,254,56,31,128,63,252,0,56,28,113,192,252,0,56,28,113,192,252,0,56,28,113,192,3,240,63,252,14,7,3,240,63,252,14,7,3,240,63,252,14,7,224,14,56,28,14,0,224,14,56,28,14,0,224,14,56,28,14,0,31,240,56,28,14,7,31,240,56,28,14,7,31,240,56,28,14,7,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,0,0,63,252,0,7,0,0,63,252,0,7,0,0,63,252,0,7,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,28,113,199,28,113,199,28,113,199,28,113,199,28,113,199,28,113,199,
  // 0x00ae  ®
  24,30,90,24,0,0,3,255,192,3,255,192,3,255,192,28,0,56,28,0,56,28,0,56,227,254,7,227,254,7,227,254,7,227,129,199,227,129,199,227,129,199,227,129,199,227,129,199,227,129,199,227,254,7,227,254,7,227,254,7,227,142,7,227,142,7,227,142,7,227,129,199,227,129,199,227,129,199,28,0,56,28,0,56,28,0,56,3,255,192,3,255,192,3,255,192,
  // 0x00af  ¯
  18,3,9,24,3,33,255,255,192,255,255,192,255,255,192,
  // 0x00b0  °
  12,12,24,24,6,18,31,128,31,128,31,128,224,112,224,112,224,112,224,112,224,112,224,112,31,128,31,128,31,128,
  // 0x00b1  ±
  21,27,81,24,3,3,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,255,255,248,255,255,248,255,255,248,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,0,0,0,0,0,0,0,0,255,255,248,255,255,248,255,255,248,
  // 0x00b2  ²
  15,21,42,24,3,12,31,240,31,240,31,240,224,14,224,14,224,14,0,14,0,14,0,14,3,240,3,240,3,240,28,0,28,0,28,0,224,0,224,0,224,0,255,254,255,254,255,254,
  // 0x00b3  ³
  15,21,42,24,3,12,31,240,31,240,31,240,224,14,224,14,224,14,0,14,0,14,0,14,31,240,31,240,31,240,0,14,0,14,0,14,224,14,224,14,224,14,31,240,31,240,31,240,
  // 0x00b4  ´
  9,9,18,24,9,30,3,128,3,128,3,128,28,0,28,0,28,0,224,0,224,0,224,0,
  // 0x00b5  µ
  24,30,90,24,0,250,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,31,129,248,31,129,248,31,129,248,28,126,7,28,126,7,28,126,7,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,
  // 0x00b6  ¶
  21,33,99,24,3,253,31,255,248,31,255,248,31,255,248,255,241,192,255,241,192,255,241,192,255,241,192,255,241,192,255,241,192,255,241,192,255,241,192,255,241,192,31,241,192,31,241,192,31,241,192,0,113,192,0,113,192,0,113,192,0,113,192,0,113,192,0,113,192,0,113,192,0,113,192,0,113,192,0,113,192,0,113,192,0,113,192,0,113,192,0,113,192,0,113,192,0,113,192,0,113,192,0,113,192,
  // 0x00b7  ·
  6,6,6,24,9,12,252,252,252,252,252,252,
  // 0x00b8  ¸
  9,6,12,24,6,250,3,128,3,128,3,128,252,0,252,0,252,0,
  // 0x00b9  ¹
  15,21,42,24,3,12,3,128,3,128,3,128,31,128,31,128,31,128,227,128,227,128,227,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x00ba  º
  15,21,42,24,6,15,31,240,31,240,31,240,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,224,14,31,240,31,240,31,240,0,0,0,0,0,0,255,254,255,254,255,254,
  // 0x00bb  »
  18,27,81,24,3,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,3,129,192,3,129,192,3,129,192,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,
  // 0x00bc  ¼
  18,30,90,24,3,0,28,1,192,28,1,192,28,1,192,252,1,192,252,1,192,252,1,192,28,14,0,28,14,0,28,14,0,28,112,0,28,112,0,28,112,0,28,112,0,28,112,0,28,112,0,3,129,192,3,129,192,3,129,192,3,143,192,3,143,192,3,143,192,28,113,192,28,113,192,28,113,192,224,127,192,224,127,192,224,127,192,224,1,192,224,1,192,224,1,192,
  // 0x00bd  ½
  18,30,90,24,3,0,28,1,192,28,1,192,28,1,192,252,1,192,252,1,192,252,1,192,28,14,0,28,14,0,28,14,0,28,112,0,28,112,0,28,112,0,28,112,0,28,112,0,28,112,0,3,142,0,3,142,0,3,142,0,3,241,192,3,241,192,3,241,192,28,1,192,28,1,192,28,1,192,224,14,0,224,14,0,224,14,0,224,127,192,224,127,192,224,127,192,
  // 0x00be  ¾
  18,30,90,24,3,0,252,1,192,252,1,192,252,1,192,3,129,192,3,129,192,3,129,192,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,252,112,0,252,112,0,252,112,0,3,129,192,3,129,192,3,129,192,3,143,192,3,143,192,3,143,192,28,113,192,28,113,192,28,113,192,224,127,192,224,127,192,224,127,192,224,1,192,224,1,192,224,1,192,
  // 0x00bf  ¿
  18,30,90,24,3,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,0,0,0,0,0,0,0,0,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,3,128,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00c0  À
  18,42,126,24,3,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x00c1  Á
  18,42,126,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x00c2  Â
  18,42,126,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x00c3  Ã
  18,42,126,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x00c4  Ä
  18,42,126,24,3,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x00c5  Å
  18,42,126,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x00c6  Æ
  21,30,90,24,3,0,3,255,248,3,255,248,3,255,248,28,112,0,28,112,0,28,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,255,255,248,255,255,248,255,255,248,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,127,248,224,127,248,224,127,248,
  // 0x00c7  Ç
  18,36,108,24,3,250,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,112,0,0,112,0,0,112,0,31,128,0,31,128,0,31,128,0,
  // 0x00c8  È
  18,42,126,24,3,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x00c9  É
  18,42,126,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x00ca  Ê
  18,42,126,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x00cb  Ë
  18,42,126,24,3,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,254,0,255,254,0,255,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,255,192,255,255,192,255,255,192,
  // 0x00cc  Ì
  15,42,84,24,6,0,31,128,31,128,31,128,0,126,0,126,0,126,0,0,0,0,0,0,0,0,0,0,0,0,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x00cd  Í
  15,42,84,24,6,0,3,240,3,240,3,240,252,0,252,0,252,0,0,0,0,0,0,0,0,0,0,0,0,0,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x00ce  Î
  15,42,84,24,6,0,31,128,31,128,31,128,224,112,224,112,224,112,0,0,0,0,0,0,0,0,0,0,0,0,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x00cf  Ï
  15,42,84,24,6,0,224,112,224,112,224,112,224,112,224,112,224,112,0,0,0,0,0,0,0,0,0,0,0,0,255,254,255,254,255,254,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x00d0  Ð
  21,30,90,24,0,0,31,254,0,31,254,0,31,254,0,28,1,192,28,1,192,28,1,192,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,255,240,56,255,240,56,255,240,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,1,192,28,1,192,28,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00d1  Ñ
  18,42,126,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,252,1,192,252,1,192,252,1,192,252,1,192,252,1,192,252,1,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,224,113,192,224,113,192,224,113,192,224,113,192,224,113,192,224,113,192,224,15,192,224,15,192,224,15,192,224,15,192,224,15,192,224,15,192,224,1,192,224,1,192,224,1,192,
  // 0x00d2  Ò
  18,42,126,24,3,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00d3  Ó
  18,42,126,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00d4  Ô
  18,42,126,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00d5  Õ
  18,42,126,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00d6  Ö
  18,42,126,24,3,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00d7  ×
  18,15,45,24,3,6,224,1,192,224,1,192,224,1,192,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,224,1,192,224,1,192,224,1,192,
  // 0x00d8  Ø
  18,36,108,24,3,253,0,1,192,0,1,192,0,1,192,31,241,192,31,241,192,31,241,192,224,14,0,224,14,0,224,14,0,224,15,192,224,15,192,224,15,192,224,113,192,224,113,192,224,113,192,224,113,192,224,113,192,224,113,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,252,1,192,252,1,192,252,1,192,28,1,192,28,1,192,28,1,192,227,254,0,227,254,0,227,254,0,224,0,0,224,0,0,224,0,0,
  // 0x00d9  Ù
  18,42,126,24,3,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00da  Ú
  18,42,126,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00db  Û
  18,42,126,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00dc  Ü
  18,42,126,24,3,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00dd  Ý
  21,42,126,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,224,0,56,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,28,1,192,3,142,0,3,142,0,3,142,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,0,112,0,
  // 0x00de  Þ
  18,33,99,24,3,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,255,240,0,255,240,0,255,240,0,224,14,0,224,14,0,224,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,14,0,224,14,0,224,14,0,255,240,0,255,240,0,255,240,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,
  // 0x00df  ß
  18,30,90,24,3,0,31,240,0,31,240,0,31,240,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,14,0,224,112,0,224,112,0,224,112,0,227,240,0,227,240,0,227,240,0,224,14,0,224,14,0,224,14,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,227,129,192,227,129,192,227,129,192,224,126,0,224,126,0,224,126,0,
  // 0x00e0  à
  18,36,108,24,3,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x00e1  á
  18,36,108,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x00e2  â
  18,36,108,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x00e3  ã
  18,36,108,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x00e4  ä
  18,36,108,24,3,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x00e5  å
  18,39,117,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x00e6  æ
  21,24,72,24,3,0,31,255,192,31,255,192,31,255,192,224,112,56,224,112,56,224,112,56,0,112,56,0,112,56,0,112,56,31,255,248,31,255,248,31,255,248,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,0,224,112,56,224,112,56,224,112,56,31,255,192,31,255,192,31,255,192,
  // 0x00e7  ç
  18,30,90,24,3,250,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,0,112,0,0,112,0,0,112,0,31,128,0,31,128,0,31,128,0,
  // 0x00e8  è
  18,36,108,24,3,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00e9  é
  18,36,108,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00ea  ê
  18,36,108,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00eb  ë
  18,36,108,24,3,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,255,255,192,255,255,192,255,255,192,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00ec  ì
  15,36,72,24,6,0,252,0,252,0,252,0,3,240,3,240,3,240,0,0,0,0,0,0,0,0,0,0,0,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x00ed  í
  15,36,72,24,6,0,3,240,3,240,3,240,252,0,252,0,252,0,0,0,0,0,0,0,0,0,0,0,0,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x00ee  î
  15,36,72,24,6,0,31,128,31,128,31,128,224,112,224,112,224,112,0,0,0,0,0,0,0,0,0,0,0,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x00ef  ï
  15,36,72,24,6,0,224,112,224,112,224,112,224,112,224,112,224,112,0,0,0,0,0,0,0,0,0,0,0,0,31,128,31,128,31,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,3,128,255,254,255,254,255,254,
  // 0x00f0  ð
  18,36,108,24,3,0,31,129,192,31,129,192,31,129,192,0,126,0,0,126,0,0,126,0,3,142,0,3,142,0,3,142,0,28,1,192,28,1,192,28,1,192,0,1,192,0,1,192,0,1,192,31,255,192,31,255,192,31,255,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00f1  ñ
  18,36,108,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,
  // 0x00f2  ò
  18,36,108,24,3,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00f3  ó
  18,36,108,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00f4  ô
  18,36,108,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00f5  õ
  18,36,108,24,3,0,31,129,192,31,129,192,31,129,192,224,126,0,224,126,0,224,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00f6  ö
  18,36,108,24,3,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,254,0,31,254,0,31,254,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00f7  ÷
  18,21,63,24,3,3,3,240,0,3,240,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,240,0,3,240,0,3,240,0,
  // 0x00f8  ø
  18,30,90,24,3,253,0,1,192,0,1,192,0,1,192,31,254,0,31,254,0,31,254,0,224,15,192,224,15,192,224,15,192,224,113,192,224,113,192,224,113,192,224,113,192,224,113,192,224,113,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,227,129,192,252,1,192,252,1,192,252,1,192,31,254,0,31,254,0,31,254,0,224,0,0,224,0,0,224,0,0,
  // 0x00f9  ù
  18,36,108,24,3,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x00fa  ú
  18,36,108,24,3,0,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x00fb  û
  18,36,108,24,3,0,3,240,0,3,240,0,3,240,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x00fc  ü
  18,36,108,24,3,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,15,192,224,15,192,224,15,192,31,241,192,31,241,192,31,241,192,
  // 0x00fd  ý
  18,42,126,24,3,250,0,126,0,0,126,0,0,126,0,31,128,0,31,128,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,28,15,192,28,15,192,28,15,192,3,241,192,3,241,192,3,241,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,31,254,0,31,254,0,31,254,0,
  // 0x00fe  þ
  18,39,117,24,3,250,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,227,254,0,227,254,0,227,254,0,252,1,192,252,1,192,252,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,252,1,192,252,1,192,252,1,192,227,254,0,227,254,0,227,254,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,224,0,0,
  // 0x00ff  ÿ
  18,42,126,24,3,250,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,28,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,224,1,192,28,15,192,28,15,192,28,15,192,3,241,192,3,241,192,3,241,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,31,254,0,31,254,0,31,254,0,
};

#endif // HAS_GRAPHICAL_TFT
