/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Traditional Chinese 32pt, capital 'A' height: 20px, width: 100%, range: 0x22bf-0xff1a, glyphs: 307
extern const uint8_t Unifont_Traditional_Chinese_20[40418] = {
  161,20,191,34,26,255,28,252, // unifont_t
  // 0x22bf  ⊿
  191,34,12,12,24,16,2,0,0,48,0,48,0,240,0,240,3,48,3,48,12,48,12,48,48,48,48,48,255,240,255,240,
  // 0x4e00  一
  0,78,30,2,8,32,0,12,255,255,255,252,255,255,255,252,
  // 0x4e09  三
  9,78,30,24,96,32,0,0,63,255,255,240,63,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,192,15,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,252,255,255,255,252,
  // 0x4e0a  上
  10,78,30,30,120,32,0,254,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,15,255,192,0,15,255,192,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,255,255,255,252,255,255,255,252,
  // 0x4e0b  下
  11,78,30,30,120,32,0,252,255,255,255,252,255,255,255,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,48,0,0,12,48,0,0,12,12,0,0,12,12,0,0,12,3,0,0,12,3,0,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,
  // 0x4e0d  不
  13,78,28,30,120,32,0,252,63,255,255,240,63,255,255,240,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,15,48,0,0,15,48,0,0,51,12,0,0,51,12,0,0,195,3,0,0,195,3,0,3,3,0,192,3,3,0,192,12,3,0,48,12,3,0,48,48,3,0,48,48,3,0,48,192,3,0,0,192,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x4e26  並
  38,78,30,30,120,32,0,254,3,0,3,0,3,0,3,0,0,192,12,0,0,192,12,0,0,48,48,0,0,48,48,0,63,255,255,240,63,255,255,240,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,48,48,48,48,48,48,48,48,12,48,48,48,12,48,48,48,3,48,48,192,3,48,48,192,3,48,51,0,3,48,51,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,255,255,255,252,255,255,255,252,
  // 0x4e2d  中
  45,78,22,32,96,32,4,252,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,255,255,252,255,255,252,192,48,12,192,48,12,192,48,12,192,48,12,192,48,12,192,48,12,192,48,12,192,48,12,192,48,12,192,48,12,255,255,252,255,255,252,192,48,12,192,48,12,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,
  // 0x4e3b  主
  59,78,30,30,120,32,0,254,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,
  // 0x4e4b  之
  75,78,28,30,120,32,2,254,0,48,0,0,0,48,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,0,0,0,0,0,0,0,255,255,255,0,255,255,255,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,15,0,0,0,15,0,0,0,48,192,0,0,48,192,0,0,192,63,255,240,192,63,255,240,
  // 0x4ea4  交
  164,78,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,0,0,0,0,0,0,0,3,0,3,0,3,0,3,0,3,0,0,192,3,0,0,192,12,0,12,48,12,0,12,48,48,192,12,48,48,192,12,48,0,48,48,0,0,48,48,0,0,12,192,0,0,12,192,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,240,48,0,0,240,48,0,15,0,15,0,15,0,15,0,240,0,0,252,240,0,0,252,
  // 0x4eae  亮
  174,78,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,0,0,0,0,0,0,0,0,255,252,0,0,255,252,0,0,192,12,0,0,192,12,0,0,255,252,0,0,255,252,0,0,0,0,0,0,0,0,0,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,63,240,48,192,63,240,48,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,48,12,0,192,48,12,15,0,48,12,15,0,48,12,240,0,15,252,240,0,15,252,
  // 0x4ee4  令
  228,78,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,204,12,0,0,204,12,0,3,3,3,0,3,3,3,0,12,3,0,192,12,3,0,192,240,0,0,60,240,0,0,60,3,255,255,0,3,255,255,0,0,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,48,48,0,0,48,48,0,0,12,192,0,0,12,192,0,0,3,0,0,0,3,0,0,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,
  // 0x4ef6  件
  246,78,30,32,128,32,0,252,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,195,12,0,0,195,12,0,3,3,12,0,3,3,12,0,3,3,255,240,3,3,255,240,15,12,12,0,15,12,12,0,15,12,12,0,15,12,12,0,51,48,12,0,51,48,12,0,195,0,12,0,195,0,12,0,3,63,255,252,3,63,255,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,
  // 0x4efd  份
  253,78,30,32,128,32,0,252,0,192,3,0,0,192,3,0,0,192,195,0,0,192,195,0,0,192,195,0,0,192,195,0,3,0,192,192,3,0,192,192,3,3,0,192,3,3,0,192,15,3,0,48,15,3,0,48,15,12,0,48,15,12,0,48,51,51,255,204,51,51,255,204,195,0,192,192,195,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,3,0,192,3,3,0,192,3,3,0,192,3,3,0,192,3,12,12,192,3,12,12,192,3,48,3,0,3,48,3,0,
  // 0x4f11  休
  17,79,30,32,128,32,0,252,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,0,48,0,3,0,48,0,3,63,255,252,3,63,255,252,15,0,48,0,15,0,48,0,15,0,252,0,15,0,252,0,51,0,252,0,51,0,252,0,195,3,51,0,195,3,51,0,3,3,51,0,3,3,51,0,3,12,48,192,3,12,48,192,3,48,48,48,3,48,48,48,3,192,48,12,3,192,48,12,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,
  // 0x4f4d  位
  77,79,30,32,128,32,0,252,0,192,192,0,0,192,192,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,0,0,0,3,0,0,0,3,63,255,240,3,63,255,240,15,0,0,0,15,0,0,0,15,0,0,192,15,0,0,192,51,12,0,192,51,12,0,192,195,12,0,192,195,12,0,192,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,12,0,3,3,12,0,3,0,12,0,3,0,12,0,3,255,255,252,3,255,255,252,3,0,0,0,3,0,0,0,
  // 0x4f4e  低
  78,79,30,32,128,32,0,252,0,192,0,192,0,192,0,192,0,192,15,240,0,192,15,240,0,207,252,0,0,207,252,0,3,12,12,0,3,12,12,0,3,12,12,0,3,12,12,0,15,12,12,0,15,12,12,0,15,12,12,0,15,12,12,0,51,15,255,252,51,15,255,252,195,12,12,0,195,12,12,0,3,12,3,0,3,12,3,0,3,12,3,0,3,12,3,0,3,12,3,12,3,12,3,12,3,12,0,204,3,12,0,204,3,12,192,204,3,12,192,204,3,15,12,60,3,15,12,60,3,12,3,12,3,12,3,12,
  // 0x4f5c  作
  92,79,30,32,128,32,0,252,0,195,0,0,0,195,0,0,0,195,0,0,0,195,0,0,0,195,0,0,0,195,0,0,3,3,255,252,3,3,255,252,3,12,192,0,3,12,192,0,15,12,192,0,15,12,192,0,15,48,192,0,15,48,192,0,51,0,255,192,51,0,255,192,195,0,192,0,195,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,255,240,3,0,255,240,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,
  // 0x4f9b  供
  155,79,30,32,128,32,0,252,0,195,3,0,0,195,3,0,0,195,3,0,0,195,3,0,0,195,3,0,0,195,3,0,3,3,3,0,3,3,3,0,3,15,255,240,3,15,255,240,15,3,3,0,15,3,3,0,15,3,3,0,15,3,3,0,51,3,3,0,51,3,3,0,195,3,3,0,195,3,3,0,3,63,255,252,3,63,255,252,3,0,0,0,3,0,0,0,3,3,3,0,3,3,3,0,3,3,0,192,3,3,0,192,3,12,0,192,3,12,0,192,3,48,0,48,3,48,0,48,3,192,0,48,3,192,0,48,
  // 0x4fdd  保
  221,79,30,32,128,32,0,252,0,192,0,0,0,192,0,0,0,207,255,192,0,207,255,192,0,204,0,192,0,204,0,192,3,12,0,192,3,12,0,192,3,12,0,192,3,12,0,192,15,15,255,192,15,15,255,192,15,0,48,0,15,0,48,0,51,0,48,0,51,0,48,0,195,63,255,240,195,63,255,240,3,0,252,0,3,0,252,0,3,3,51,0,3,3,51,0,3,12,48,192,3,12,48,192,3,48,48,48,3,48,48,48,3,192,48,12,3,192,48,12,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,
  // 0x4fe1  信
  225,79,30,32,128,32,0,252,0,192,48,0,0,192,48,0,0,192,12,0,0,192,12,0,0,207,255,252,0,207,255,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,15,3,255,240,15,3,255,240,15,0,0,0,15,0,0,0,51,0,0,0,51,0,0,0,195,3,255,240,195,3,255,240,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,3,255,240,3,3,255,240,3,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,3,3,255,240,3,3,255,240,3,3,0,48,3,3,0,48,
  // 0x500b  個
  11,80,28,32,128,32,0,252,3,0,0,0,3,0,0,0,3,63,255,240,3,63,255,240,3,48,48,48,3,48,48,48,12,48,48,48,12,48,48,48,12,63,255,240,12,63,255,240,60,48,48,48,60,48,48,48,60,48,48,48,60,48,48,48,204,51,255,48,204,51,255,48,12,51,3,48,12,51,3,48,12,51,3,48,12,51,3,48,12,51,3,48,12,51,3,48,12,51,255,48,12,51,255,48,12,51,3,48,12,51,3,48,12,48,0,48,12,48,0,48,12,63,255,240,12,63,255,240,12,48,0,48,12,48,0,48,
  // 0x503c  值
  60,80,30,32,128,32,0,252,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,255,255,240,0,255,255,240,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,15,15,255,192,15,15,255,192,15,12,0,192,15,12,0,192,51,15,255,192,51,15,255,192,195,12,0,192,195,12,0,192,3,15,255,192,3,15,255,192,3,12,0,192,3,12,0,192,3,15,255,192,3,15,255,192,3,12,0,192,3,12,0,192,3,12,0,192,3,12,0,192,3,255,255,252,3,255,255,252,3,0,0,0,3,0,0,0,
  // 0x504f  偏
  79,80,28,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,48,0,3,0,48,0,3,63,255,240,3,63,255,240,12,48,0,48,12,48,0,48,12,48,0,48,12,48,0,48,60,63,255,240,60,63,255,240,60,48,0,0,60,48,0,0,204,48,0,0,204,48,0,0,12,63,255,240,12,63,255,240,12,60,204,48,12,60,204,48,12,204,204,48,12,204,204,48,12,207,255,240,12,207,255,240,12,204,204,48,12,204,204,48,12,204,204,48,12,204,204,48,15,12,204,48,15,12,204,48,12,12,0,240,12,12,0,240,
  // 0x505c  停
  92,80,30,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,48,0,3,0,48,0,3,63,255,240,3,63,255,240,12,0,0,0,12,0,0,0,12,15,255,192,12,15,255,192,60,12,0,192,60,12,0,192,60,15,255,192,60,15,255,192,204,0,0,0,204,0,0,0,12,255,255,252,12,255,255,252,12,192,0,12,12,192,0,12,12,15,255,192,12,15,255,192,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,3,48,0,12,3,48,0,12,0,192,0,12,0,192,0,
  // 0x5075  偵
  117,80,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,63,252,3,0,63,252,3,0,48,0,3,0,48,0,12,0,48,0,12,0,48,0,12,63,255,240,12,63,255,240,60,48,0,48,60,48,0,48,60,48,0,48,60,48,0,48,204,63,255,240,204,63,255,240,12,48,0,48,12,48,0,48,12,63,255,240,12,63,255,240,12,48,0,48,12,48,0,48,12,48,0,48,12,48,0,48,12,63,255,240,12,63,255,240,12,3,3,0,12,3,3,0,12,12,0,192,12,12,0,192,12,48,0,48,12,48,0,48,
  // 0x5099  備
  153,80,30,32,128,32,0,252,0,192,192,192,0,192,192,192,0,192,192,192,0,192,192,192,0,207,255,252,0,207,255,252,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,15,63,255,252,15,63,255,252,15,0,192,0,15,0,192,0,51,3,255,240,51,3,255,240,195,15,12,48,195,15,12,48,3,51,255,240,3,51,255,240,3,3,12,48,3,3,12,48,3,3,255,240,3,3,255,240,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,0,240,3,3,0,240,
  // 0x50b3  傳
  179,80,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,255,255,252,3,255,255,252,3,0,48,0,3,0,48,0,12,63,255,240,12,63,255,240,12,48,48,48,12,48,48,48,60,63,255,240,60,63,255,240,60,48,48,48,60,48,48,48,204,63,255,240,204,63,255,240,12,0,48,12,12,0,48,12,12,255,255,252,12,255,255,252,12,0,3,0,12,0,3,0,12,255,255,252,12,255,255,252,12,12,3,0,12,12,3,0,12,3,3,0,12,3,3,0,12,3,51,0,12,3,51,0,12,0,12,0,12,0,12,0,
  // 0x50be  傾
  190,80,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,3,255,252,3,3,255,252,3,0,3,0,3,0,3,0,12,48,12,0,12,48,12,0,12,48,255,240,12,48,255,240,60,48,192,48,60,48,192,48,60,63,192,48,60,63,192,48,204,48,255,240,204,48,255,240,12,48,192,48,12,48,192,48,12,48,255,240,12,48,255,240,12,51,192,48,12,51,192,48,12,60,192,48,12,60,192,48,12,48,255,240,12,48,255,240,12,0,48,192,12,0,48,192,12,0,192,48,12,0,192,48,12,3,0,12,12,3,0,12,
  // 0x5132  儲
  50,81,30,32,128,32,0,252,3,48,3,0,3,48,3,0,3,12,3,0,3,12,3,0,3,12,63,204,3,12,63,204,12,255,3,12,12,255,3,12,12,0,3,48,12,0,3,48,60,255,63,252,60,255,63,252,60,0,0,192,60,0,0,192,204,255,3,0,204,255,3,0,12,0,15,240,12,0,15,240,12,255,60,48,12,255,60,48,12,195,204,48,12,195,204,48,12,195,15,240,12,195,15,240,12,195,12,48,12,195,12,48,12,255,12,48,12,255,12,48,12,195,15,240,12,195,15,240,12,0,12,48,12,0,12,48,
  // 0x5145  充
  69,81,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,15,255,255,192,15,255,255,192,0,48,48,192,0,48,48,192,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,48,48,0,192,48,48,0,192,48,48,0,192,48,48,3,0,48,48,3,0,48,48,60,0,15,240,60,0,15,240,
  // 0x5148  先
  72,81,30,32,128,32,0,252,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,255,255,192,3,255,255,192,12,3,0,0,12,3,0,0,48,3,0,0,48,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,48,0,0,192,48,0,0,192,48,12,0,192,48,12,3,0,48,12,3,0,48,12,12,0,15,252,12,0,15,252,240,0,0,0,240,0,0,0,
  // 0x5149  光
  73,81,30,32,128,32,0,252,0,3,0,0,0,3,0,0,12,3,0,192,12,3,0,192,3,3,0,192,3,3,0,192,0,195,3,0,0,195,3,0,0,195,12,0,0,195,12,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,48,12,0,192,48,12,0,192,48,12,0,192,48,12,3,0,48,12,3,0,48,12,12,0,15,252,12,0,15,252,240,0,0,0,240,0,0,0,
  // 0x5165  入
  101,81,30,32,128,32,0,252,0,48,0,0,0,48,0,0,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,12,192,0,0,12,192,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,12,0,3,0,12,0,3,0,48,0,0,192,48,0,0,192,192,0,0,60,192,0,0,60,
  // 0x5168  全
  104,81,30,30,120,32,0,254,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,12,255,252,192,12,255,252,192,240,3,0,60,240,3,0,60,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,255,255,0,3,255,255,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,
  // 0x5171  共
  113,81,28,32,128,32,2,252,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,63,255,255,192,63,255,255,192,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,255,255,255,240,255,255,255,240,0,0,0,0,0,0,0,0,0,192,48,0,0,192,48,0,3,0,12,0,3,0,12,0,12,0,3,0,12,0,3,0,48,0,0,192,48,0,0,192,
  // 0x5177  具
  119,81,30,30,120,32,0,252,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,255,255,255,252,255,255,255,252,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,12,0,0,192,12,0,0,192,
  // 0x5197  冗
  151,81,30,28,112,32,0,252,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,0,0,48,192,0,0,48,0,0,0,0,0,0,0,0,0,255,240,0,0,255,240,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,0,48,12,3,0,48,12,3,0,48,12,3,0,48,12,12,0,48,12,12,0,48,12,48,0,15,252,48,0,15,252,192,0,0,0,192,0,0,0,
  // 0x51b7  冷
  183,81,30,32,128,32,0,252,0,0,48,0,0,0,48,0,48,0,48,0,48,0,48,0,12,0,204,0,12,0,204,0,12,0,204,0,12,0,204,0,0,3,3,0,0,3,3,0,0,12,48,192,0,12,48,192,3,48,12,60,3,48,12,60,3,0,12,0,3,0,12,0,12,15,255,192,12,15,255,192,252,0,0,192,252,0,0,192,12,0,3,0,12,0,3,0,12,3,3,0,12,3,3,0,12,0,204,0,12,0,204,0,12,0,48,0,12,0,48,0,12,0,12,0,12,0,12,0,0,0,12,0,0,0,12,0,
  // 0x51c6  准
  198,81,30,32,128,32,0,252,0,3,48,0,0,3,48,0,48,3,12,0,48,3,12,0,12,3,12,0,12,3,12,0,12,15,255,252,12,15,255,252,0,12,12,0,0,12,12,0,3,60,12,0,3,60,12,0,3,207,255,240,3,207,255,240,3,12,12,0,3,12,12,0,12,12,12,0,12,12,12,0,12,15,255,240,12,15,255,240,252,12,12,0,252,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,12,15,255,252,12,15,255,252,12,12,0,0,12,12,0,0,0,12,0,0,0,12,0,0,
  // 0x51fa  出
  250,81,26,32,128,32,2,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,48,12,3,0,48,12,3,0,48,12,3,0,48,12,3,0,48,12,3,0,48,12,3,0,48,12,3,0,48,12,3,0,63,255,255,0,63,255,255,0,0,12,3,0,0,12,3,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,255,255,255,192,255,255,255,192,0,0,0,192,0,0,0,192,
  // 0x5206  分
  6,82,30,32,128,32,0,252,0,0,48,0,0,0,48,0,0,48,48,0,0,48,48,0,0,48,12,0,0,48,12,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,12,0,0,192,12,0,0,192,48,0,0,48,48,0,0,48,195,255,252,12,195,255,252,12,0,48,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,3,0,12,0,3,0,12,0,12,3,48,0,12,3,48,0,48,0,192,0,48,0,192,0,
  // 0x5217  列
  23,82,28,32,128,32,0,252,0,0,0,48,0,0,0,48,63,255,192,48,63,255,192,48,0,192,0,48,0,192,0,48,0,192,12,48,0,192,12,48,3,255,12,48,3,255,12,48,3,3,12,48,3,3,12,48,12,3,12,48,12,3,12,48,12,3,12,48,12,3,12,48,51,12,12,48,51,12,12,48,192,204,12,48,192,204,12,48,0,48,12,48,0,48,12,48,0,48,12,48,0,48,12,48,0,192,0,48,0,192,0,48,3,0,0,48,3,0,0,48,12,0,3,48,12,0,3,48,48,0,0,192,48,0,0,192,
  // 0x521d  初
  29,82,28,32,128,32,0,252,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,0,0,3,255,240,0,3,255,240,255,240,48,48,255,240,48,48,0,192,48,48,0,192,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,48,48,15,48,48,48,15,48,48,48,51,192,48,48,51,192,48,48,195,48,48,48,195,48,48,48,3,48,48,48,3,48,48,48,3,0,192,48,3,0,192,48,3,0,192,48,3,0,192,48,3,3,0,48,3,3,0,48,3,12,12,192,3,12,12,192,3,48,3,0,3,48,3,0,
  // 0x5230  到
  48,82,28,32,128,32,0,252,0,0,0,48,0,0,0,48,255,255,192,48,255,255,192,48,0,192,0,48,0,192,0,48,3,0,12,48,3,0,12,48,12,12,12,48,12,12,12,48,48,3,12,48,48,3,12,48,255,255,204,48,255,255,204,48,0,192,204,48,0,192,204,48,0,192,12,48,0,192,12,48,0,192,12,48,0,192,12,48,63,255,12,48,63,255,12,48,0,192,12,48,0,192,12,48,0,192,0,48,0,192,0,48,0,255,192,48,0,255,192,48,255,192,3,48,255,192,3,48,48,0,0,192,48,0,0,192,
  // 0x5236  制
  54,82,28,32,128,32,0,252,0,48,0,48,0,48,0,48,12,48,0,48,12,48,0,48,12,48,0,48,12,48,0,48,15,255,204,48,15,255,204,48,48,48,12,48,48,48,12,48,0,48,12,48,0,48,12,48,255,255,252,48,255,255,252,48,0,48,12,48,0,48,12,48,0,48,12,48,0,48,12,48,15,255,204,48,15,255,204,48,12,48,204,48,12,48,204,48,12,48,204,48,12,48,204,48,12,60,192,48,12,60,192,48,12,51,0,48,12,51,0,48,0,48,3,48,0,48,3,48,0,48,0,192,0,48,0,192,
  // 0x5237  刷
  55,82,30,32,128,32,0,252,0,0,0,12,0,0,0,12,15,255,240,12,15,255,240,12,12,0,48,12,12,0,48,12,12,0,48,12,12,0,48,12,15,255,243,12,15,255,243,12,12,12,3,12,12,12,3,12,12,12,3,12,12,12,3,12,12,12,3,12,12,12,3,12,15,255,243,12,15,255,243,12,51,12,51,12,51,12,51,12,51,12,51,12,51,12,51,12,51,12,51,12,51,12,51,12,195,15,48,12,195,15,48,12,3,12,192,12,3,12,192,12,0,12,0,204,0,12,0,204,0,12,0,48,0,12,0,48,
  // 0x5275  創
  117,82,28,32,128,32,0,252,0,192,0,48,0,192,0,48,0,240,0,48,0,240,0,48,3,12,0,48,3,12,0,48,12,195,12,48,12,195,12,48,48,48,204,48,48,48,204,48,207,255,12,48,207,255,12,48,12,3,12,48,12,3,12,48,15,255,12,48,15,255,12,48,12,3,12,48,12,3,12,48,15,255,12,48,15,255,12,48,12,0,12,48,12,0,12,48,15,255,12,48,15,255,12,48,51,3,0,48,51,3,0,48,51,3,0,48,51,3,0,48,195,255,3,48,195,255,3,48,3,3,0,192,3,3,0,192,
  // 0x529b  力
  155,82,24,32,96,32,2,252,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,255,255,255,255,255,255,0,48,3,0,48,3,0,48,3,0,48,3,0,48,3,0,48,3,0,48,3,0,48,3,0,192,3,0,192,3,0,192,3,0,192,3,3,0,3,3,0,3,3,0,3,3,0,3,12,3,3,12,3,3,48,0,204,48,0,204,192,0,48,192,0,48,
  // 0x52a0  加
  160,82,28,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,63,240,3,0,63,240,255,252,48,48,255,252,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,12,12,48,48,12,12,48,48,12,12,63,240,12,12,63,240,48,204,48,48,48,204,48,48,192,48,0,0,192,48,0,0,
  // 0x52d5  動
  213,82,28,32,128,32,0,252,0,255,12,0,0,255,12,0,63,192,12,0,63,192,12,0,0,192,12,0,0,192,12,0,255,255,204,0,255,255,204,0,0,192,63,240,0,192,63,240,63,255,12,48,63,255,12,48,48,195,12,48,48,195,12,48,63,255,12,48,63,255,12,48,48,195,12,48,48,195,12,48,63,255,12,48,63,255,12,48,0,192,12,48,0,192,12,48,63,255,12,48,63,255,12,48,0,192,48,48,0,192,48,48,0,255,240,48,0,255,240,48,255,192,195,48,255,192,195,48,48,3,0,192,48,3,0,192,
  // 0x5316  化
  22,83,30,32,128,32,0,252,0,192,192,0,0,192,192,0,0,192,192,0,0,192,192,0,0,192,192,48,0,192,192,48,3,0,192,192,3,0,192,192,3,0,195,0,3,0,195,0,15,0,204,0,15,0,204,0,15,0,240,0,15,0,240,0,51,0,192,0,51,0,192,0,195,3,192,0,195,3,192,0,3,12,192,0,3,12,192,0,3,48,192,0,3,48,192,0,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,63,252,3,0,63,252,3,0,0,0,3,0,0,0,
  // 0x534a  半
  74,83,30,32,128,32,0,252,0,3,0,0,0,3,0,0,12,3,0,192,12,3,0,192,3,3,0,192,3,3,0,192,0,195,3,0,0,195,3,0,0,195,12,0,0,195,12,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x5354  協
  84,83,30,32,128,32,0,252,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,15,255,240,12,15,255,240,12,0,192,48,12,0,192,48,255,192,192,48,255,192,192,48,12,3,3,48,12,3,3,48,12,12,0,192,12,12,0,192,12,0,3,0,12,0,3,0,12,48,3,0,12,48,3,0,12,255,207,252,12,255,207,252,12,48,195,12,12,48,195,12,12,48,195,12,12,48,195,12,12,48,195,12,12,48,195,12,12,192,204,12,12,192,204,12,12,204,204,204,12,204,204,204,15,3,48,48,15,3,48,48,
  // 0x5361  卡
  97,83,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,15,255,192,0,15,255,192,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,255,255,255,252,255,255,255,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,48,0,0,12,48,0,0,12,12,0,0,12,12,0,0,12,3,0,0,12,3,0,0,12,0,192,0,12,0,192,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,
  // 0x5370  印
  112,83,26,30,120,32,2,252,0,240,0,0,0,240,0,0,255,3,255,192,255,3,255,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,255,243,0,192,255,243,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,195,243,51,0,195,243,51,0,252,3,12,0,252,3,12,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x5378  卸
  120,83,28,32,128,32,0,252,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,15,255,63,240,15,255,63,240,48,192,48,48,48,192,48,48,192,192,48,48,192,192,48,48,0,192,48,48,0,192,48,48,63,255,48,48,63,255,48,48,0,192,48,48,0,192,48,48,0,192,48,48,0,192,48,48,12,252,48,48,12,252,48,48,12,192,48,48,12,192,48,48,12,192,51,48,12,192,51,48,12,255,48,192,12,255,48,192,255,0,48,0,255,0,48,0,48,0,48,0,48,0,48,0,0,0,48,0,0,0,48,0,
  // 0x537b  卻
  123,83,28,32,128,32,0,252,3,48,0,0,3,48,0,0,3,12,0,0,3,12,0,0,12,3,63,240,12,3,63,240,48,195,48,48,48,195,48,48,0,192,48,48,0,192,48,48,3,48,48,48,3,48,48,48,12,12,48,48,12,12,48,48,48,3,48,48,48,3,48,48,207,252,48,48,207,252,48,48,12,12,48,48,12,12,48,48,12,12,48,48,12,12,48,48,12,12,51,48,12,12,51,48,12,12,48,192,12,12,48,192,15,252,48,0,15,252,48,0,12,12,48,0,12,12,48,0,0,0,48,0,0,0,48,0,
  // 0x539f  原
  159,83,30,30,120,32,0,252,15,255,255,252,15,255,255,252,12,0,192,0,12,0,192,0,12,3,0,0,12,3,0,0,12,63,255,0,12,63,255,0,12,48,3,0,12,48,3,0,12,48,3,0,12,48,3,0,12,63,255,0,12,63,255,0,12,48,3,0,12,48,3,0,12,48,3,0,12,48,3,0,12,63,255,0,12,63,255,0,12,0,192,0,12,0,192,0,12,48,195,0,12,48,195,0,48,192,192,192,48,192,192,192,51,12,192,48,51,12,192,48,192,3,0,0,192,3,0,0,
  // 0x53cd  反
  205,83,30,32,128,32,0,252,0,0,3,0,0,0,3,0,0,0,255,192,0,0,255,192,15,255,0,0,15,255,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,15,255,255,192,15,255,255,192,12,48,0,192,12,48,0,192,12,48,3,0,12,48,3,0,12,12,3,0,12,12,3,0,12,12,12,0,12,12,12,0,12,3,48,0,12,3,48,0,12,0,192,0,12,0,192,0,48,3,48,0,48,3,48,0,48,12,12,0,48,12,12,0,192,240,3,192,192,240,3,192,15,0,0,60,15,0,0,60,
  // 0x53d6  取
  214,83,30,30,120,32,0,252,255,255,192,0,255,255,192,0,12,12,255,240,12,12,255,240,12,12,48,48,12,12,48,48,15,252,48,48,15,252,48,48,12,12,48,48,12,12,48,48,12,12,48,48,12,12,48,48,15,252,48,48,15,252,48,48,12,12,12,192,12,12,12,192,12,12,12,192,12,12,12,192,12,63,204,192,12,63,204,192,255,204,3,0,255,204,3,0,48,12,3,0,48,12,3,0,0,12,12,192,0,12,12,192,0,12,48,48,0,12,48,48,0,12,192,12,0,12,192,12,
  // 0x53f0  台
  240,83,26,32,128,32,2,252,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,3,0,48,0,3,0,48,0,12,0,12,0,12,0,12,0,48,0,3,0,48,0,3,0,255,255,255,192,255,255,255,192,48,0,0,192,48,0,0,192,0,0,0,0,0,0,0,0,15,255,252,0,15,255,252,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,15,255,252,0,15,255,252,0,12,0,12,0,12,0,12,0,
  // 0x5408  合
  8,84,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,15,0,3,192,15,0,3,192,240,255,252,60,240,255,252,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,
  // 0x5426  否
  38,84,30,30,120,32,0,252,63,255,255,240,63,255,255,240,0,0,192,0,0,0,192,0,0,3,0,0,0,3,0,0,0,15,0,0,0,15,0,0,0,51,60,0,0,51,60,0,0,195,3,192,0,195,3,192,15,3,0,48,15,3,0,48,240,3,0,12,240,3,0,12,0,0,0,0,0,0,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,
  // 0x544a  告
  74,84,30,32,128,32,0,252,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,255,255,192,3,255,255,192,12,3,0,0,12,3,0,0,48,3,0,0,48,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,
  // 0x547d  命
  125,84,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,15,63,243,192,15,63,243,192,240,0,0,60,240,0,0,60,0,0,0,0,0,0,0,0,15,252,255,192,15,252,255,192,12,12,192,192,12,12,192,192,12,12,192,192,12,12,192,192,12,12,192,192,12,12,192,192,15,252,204,192,15,252,204,192,12,12,195,0,12,12,195,0,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,
  // 0x548c  和
  140,84,28,32,128,32,0,252,0,48,0,0,0,48,0,0,0,252,0,0,0,252,0,0,63,192,0,0,63,192,0,0,0,192,63,240,0,192,63,240,0,192,48,48,0,192,48,48,255,255,48,48,255,255,48,48,0,192,48,48,0,192,48,48,3,192,48,48,3,192,48,48,3,240,48,48,3,240,48,48,12,204,48,48,12,204,48,48,12,204,48,48,12,204,48,48,48,192,48,48,48,192,48,48,192,192,63,240,192,192,63,240,0,192,48,48,0,192,48,48,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,
  // 0x555f  啟
  95,85,30,32,128,32,0,252,0,192,12,0,0,192,12,0,0,48,12,0,0,48,12,0,15,255,12,0,15,255,12,0,12,3,15,252,12,3,15,252,12,3,48,48,12,3,48,48,12,3,48,48,12,3,48,48,15,255,48,48,15,255,48,48,12,0,204,48,12,0,204,48,12,0,12,192,12,0,12,192,15,255,12,192,15,255,12,192,15,3,3,0,15,3,3,0,51,3,3,0,51,3,3,0,51,3,12,192,51,3,12,192,195,255,12,192,195,255,12,192,3,3,48,48,3,3,48,48,0,0,192,12,0,0,192,12,
  // 0x55ae  單
  174,85,30,30,120,32,0,252,63,252,255,240,63,252,255,240,48,12,192,48,48,12,192,48,48,12,192,48,48,12,192,48,63,252,255,240,63,252,255,240,0,0,0,0,0,0,0,0,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x5634  嘴
  52,86,30,32,128,32,0,252,0,0,195,0,0,0,195,0,0,12,195,48,0,12,195,48,255,12,243,192,255,12,243,192,195,12,195,12,195,12,195,12,195,12,243,12,195,12,243,12,195,63,0,252,195,63,0,252,195,3,255,0,195,3,255,0,195,12,3,0,195,12,3,0,195,63,255,240,195,63,255,240,195,204,48,48,195,204,48,48,255,15,255,240,255,15,255,240,195,12,48,48,195,12,48,48,0,15,255,240,0,15,255,240,0,48,48,48,0,48,48,48,0,48,51,48,0,48,51,48,0,192,0,192,0,192,0,192,
  // 0x5668  器
  104,86,30,30,120,32,0,252,15,252,63,240,15,252,63,240,12,12,48,48,12,12,48,48,12,12,48,48,12,12,48,48,15,252,63,240,15,252,63,240,0,3,12,0,0,3,12,0,0,3,3,0,0,3,3,0,255,255,255,252,255,255,255,252,0,12,192,0,0,12,192,0,0,240,60,0,0,240,60,0,15,0,3,192,15,0,3,192,240,0,0,60,240,0,0,60,15,252,63,240,15,252,63,240,12,12,48,48,12,12,48,48,12,12,48,48,12,12,48,48,15,252,63,240,15,252,63,240,
  // 0x5674  噴
  116,86,28,32,128,32,2,252,0,0,48,0,0,0,48,0,0,15,255,192,0,15,255,192,255,0,48,0,255,0,48,0,195,3,3,0,195,3,3,0,195,63,255,240,195,63,255,240,195,3,3,0,195,3,3,0,195,15,255,192,195,15,255,192,195,12,0,192,195,12,0,192,195,15,255,192,195,15,255,192,195,12,0,192,195,12,0,192,255,15,255,192,255,15,255,192,195,12,0,192,195,12,0,192,0,15,255,192,0,15,255,192,0,3,3,0,0,3,3,0,0,12,0,192,0,12,0,192,0,48,0,48,0,48,0,48,
  // 0x56de  回
  222,86,24,28,84,32,4,254,255,255,255,255,255,255,192,0,3,192,0,3,192,0,3,192,0,3,195,255,195,195,255,195,195,0,195,195,0,195,195,0,195,195,0,195,195,0,195,195,0,195,195,0,195,195,0,195,195,0,195,195,0,195,195,255,195,195,255,195,192,0,3,192,0,3,192,0,3,192,0,3,255,255,255,255,255,255,192,0,3,192,0,3,
  // 0x56e0  因
  224,86,26,30,120,32,2,252,255,255,255,192,255,255,255,192,192,0,0,192,192,0,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,207,255,252,192,207,255,252,192,192,12,0,192,192,12,0,192,192,51,0,192,192,51,0,192,192,48,192,192,192,48,192,192,192,192,48,192,192,192,48,192,195,0,12,192,195,0,12,192,204,0,12,192,204,0,12,192,192,0,0,192,192,0,0,192,255,255,255,192,255,255,255,192,192,0,0,192,192,0,0,192,
  // 0x56fa  固
  250,86,26,30,120,32,2,252,255,255,255,192,255,255,255,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,207,255,252,192,207,255,252,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,195,255,240,192,195,255,240,192,195,0,48,192,195,0,48,192,195,0,48,192,195,0,48,192,195,0,48,192,195,0,48,192,195,255,240,192,195,255,240,192,195,0,48,192,195,0,48,192,192,0,0,192,192,0,0,192,255,255,255,192,255,255,255,192,192,0,0,192,192,0,0,192,
  // 0x5716  圖
  22,87,26,32,128,32,2,252,255,255,255,192,255,255,255,192,192,0,0,192,192,0,0,192,195,255,240,192,195,255,240,192,195,0,48,192,195,0,48,192,195,255,240,192,195,255,240,192,192,12,0,192,192,12,0,192,255,255,255,192,255,255,255,192,192,12,0,192,192,12,0,192,207,255,252,192,207,255,252,192,204,0,12,192,204,0,12,192,204,255,204,192,204,255,204,192,204,192,204,192,204,192,204,192,207,255,252,192,207,255,252,192,192,0,0,192,192,0,0,192,255,255,255,192,255,255,255,192,192,0,0,192,192,0,0,192,
  // 0x5728  在
  40,87,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,255,255,255,252,255,255,255,252,0,192,0,0,0,192,0,0,0,192,48,0,0,192,48,0,3,0,48,0,3,0,48,0,15,0,48,0,15,0,48,0,51,63,255,240,51,63,255,240,195,0,48,0,195,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,255,255,252,3,255,255,252,3,0,0,0,3,0,0,0,
  // 0x578b  型
  139,87,30,30,120,32,0,254,0,0,0,48,0,0,0,48,63,255,192,48,63,255,192,48,3,12,12,48,3,12,12,48,3,12,12,48,3,12,12,48,3,12,12,48,3,12,12,48,255,255,204,48,255,255,204,48,3,12,12,48,3,12,12,48,12,12,0,48,12,12,0,48,12,12,3,48,12,12,3,48,48,3,0,192,48,3,0,192,192,3,0,0,192,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,
  // 0x57f7  執
  247,87,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,63,240,48,0,63,240,48,0,3,3,255,192,3,3,255,192,3,0,48,192,3,0,48,192,255,252,48,192,255,252,48,192,48,48,48,192,48,48,48,192,12,195,48,192,12,195,48,192,63,240,240,192,63,240,240,192,3,0,48,192,3,0,48,192,3,0,204,192,3,0,204,192,255,252,204,192,255,252,204,192,3,0,192,204,3,0,192,204,3,3,0,204,3,3,0,204,3,3,0,60,3,3,0,60,3,12,0,12,3,12,0,12,
  // 0x584a  塊
  74,88,30,32,128,32,0,252,12,0,12,0,12,0,12,0,12,0,48,0,12,0,48,0,12,15,255,240,12,15,255,240,12,12,12,48,12,12,12,48,12,12,12,48,12,12,12,48,255,207,255,240,255,207,255,240,12,12,12,48,12,12,12,48,12,12,48,48,12,12,48,48,12,15,255,240,12,15,255,240,12,0,48,0,12,0,48,0,12,0,204,192,12,0,204,192,15,192,207,48,15,192,207,48,252,3,15,240,252,3,15,240,48,3,12,12,48,3,12,12,0,12,12,12,0,12,12,12,0,48,3,252,0,48,3,252,
  // 0x586b  填
  107,88,30,32,128,32,0,252,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,63,255,240,12,63,255,240,12,0,48,0,12,0,48,0,12,15,255,192,12,15,255,192,255,204,0,192,255,204,0,192,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,15,255,192,12,15,255,192,15,204,0,192,15,204,0,192,252,255,255,252,252,255,255,252,48,3,3,0,48,3,3,0,0,12,0,192,0,12,0,192,0,48,0,48,0,48,0,48,
  // 0x588a  墊
  138,88,30,30,120,32,0,254,0,192,12,0,0,192,12,0,63,252,12,0,63,252,12,0,0,192,255,192,0,192,255,192,255,255,12,192,255,255,12,192,3,48,12,192,3,48,12,192,63,255,60,204,63,255,60,204,0,192,12,204,0,192,12,204,255,255,51,60,255,255,51,60,0,192,192,12,0,192,192,12,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,
  // 0x5916  外
  22,89,28,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,15,252,48,0,15,252,48,0,12,12,60,0,12,12,60,0,48,12,51,0,48,12,51,0,48,12,48,192,48,12,48,192,204,48,48,48,204,48,48,48,3,48,48,48,3,48,48,48,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,0,48,0,3,0,48,0,12,0,48,0,12,0,48,0,48,0,48,0,48,0,48,0,192,0,48,0,192,0,48,0,
  // 0x591a  多
  26,89,24,32,96,32,2,252,0,48,0,0,48,0,0,48,0,0,48,0,0,255,252,0,255,252,3,0,48,3,0,48,63,0,192,63,0,192,0,195,0,0,195,0,0,60,192,0,60,192,3,195,0,3,195,0,252,15,255,252,15,255,0,48,3,0,48,3,3,192,12,3,192,12,60,48,48,60,48,48,0,12,192,0,12,192,0,15,0,0,15,0,3,240,0,3,240,0,252,0,0,252,0,0,
  // 0x5920  夠
  32,89,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,15,252,48,0,15,252,48,0,48,12,63,252,48,12,63,252,204,48,192,12,204,48,192,12,3,195,0,12,3,195,0,12,3,0,63,204,3,0,63,204,12,192,48,204,12,192,48,204,240,255,48,204,240,255,48,204,3,3,48,204,3,3,48,204,15,12,63,204,15,12,63,204,48,204,48,204,48,204,48,204,0,48,0,12,0,48,0,12,0,192,0,12,0,192,0,12,15,0,3,48,15,0,3,48,240,0,0,192,240,0,0,192,
  // 0x5927  大
  39,89,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,12,0,0,192,12,0,0,192,240,0,0,60,240,0,0,60,
  // 0x5929  天
  41,89,30,30,120,32,0,252,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,12,0,0,192,12,0,0,192,240,0,0,60,240,0,0,60,
  // 0x5931  失
  49,89,30,32,128,32,0,252,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,255,255,192,3,255,255,192,12,3,0,0,12,3,0,0,48,3,0,0,48,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,60,0,0,240,60,0,0,240,
  // 0x59cb  始
  203,89,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,48,0,3,0,48,0,255,240,48,192,255,240,48,192,12,48,192,48,12,48,192,48,12,51,255,252,12,51,255,252,12,48,192,12,12,48,192,12,12,48,0,0,12,48,0,0,48,192,255,240,48,192,255,240,12,192,192,48,12,192,192,48,3,0,192,48,3,0,192,48,12,192,192,48,12,192,192,48,48,48,192,48,48,48,192,48,192,0,255,240,192,0,255,240,0,0,192,48,0,0,192,48,
  // 0x5a92  媒
  146,90,30,32,128,32,0,252,12,3,3,0,12,3,3,0,12,3,3,0,12,3,3,0,12,3,3,0,12,3,3,0,12,63,255,240,12,63,255,240,255,195,3,0,255,195,3,0,12,195,255,0,12,195,255,0,12,195,3,0,12,195,3,0,12,195,255,0,12,195,255,0,48,192,48,0,48,192,48,0,48,255,255,252,48,255,255,252,12,192,48,0,12,192,48,0,3,0,252,0,3,0,252,0,3,3,51,0,3,3,51,0,12,204,48,252,12,204,48,252,48,48,48,48,48,48,48,48,192,0,48,0,192,0,48,0,
  // 0x5b50  子
  80,91,30,30,120,32,0,252,63,255,255,192,63,255,255,192,0,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,3,192,0,0,3,192,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,51,0,0,0,51,0,0,0,12,0,0,0,12,0,0,
  // 0x5b58  存
  88,91,30,32,128,32,0,252,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,255,255,255,252,255,255,255,252,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,3,15,255,192,3,15,255,192,3,0,3,0,3,0,3,0,15,0,12,0,15,0,12,0,51,0,48,0,51,0,48,0,195,63,255,252,195,63,255,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,3,48,0,3,3,48,0,3,0,192,0,3,0,192,0,
  // 0x5b89  安
  137,91,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,15,255,255,240,15,255,255,240,12,0,0,48,12,0,0,48,48,12,0,192,48,12,0,192,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,255,255,255,252,255,255,255,252,0,48,12,0,0,48,12,0,0,192,12,0,0,192,12,0,3,192,48,0,3,192,48,0,0,60,48,0,0,60,48,0,0,3,192,0,0,3,192,0,0,12,60,0,0,12,60,0,0,240,3,0,0,240,3,0,63,0,0,192,63,0,0,192,
  // 0x5b8c  完
  140,91,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,0,0,48,192,0,0,48,3,255,255,0,3,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,240,63,255,255,240,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,48,48,0,192,48,48,0,192,48,48,0,192,48,48,3,0,48,48,3,0,48,48,60,0,15,240,60,0,15,240,
  // 0x5b9a  定
  154,91,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,0,0,48,192,0,0,48,0,0,0,0,0,0,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,255,192,3,3,255,192,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,12,195,0,0,12,195,0,0,48,63,255,252,48,63,255,252,192,0,0,0,192,0,0,0,
  // 0x5ba2  客
  162,91,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,192,0,48,192,192,0,48,0,255,255,0,0,255,255,0,3,0,12,0,3,0,12,0,12,240,48,0,12,240,48,0,0,15,192,0,0,15,192,0,3,240,63,0,3,240,63,0,252,0,0,252,252,0,0,252,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,
  // 0x5bb9  容
  185,91,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,192,12,48,192,192,12,48,3,3,3,0,3,3,3,0,12,12,192,192,12,12,192,192,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,15,0,3,192,15,0,3,192,243,255,255,60,243,255,255,60,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,
  // 0x5c0d  對
  13,92,30,32,128,32,0,252,3,48,0,192,3,48,0,192,3,48,0,192,3,48,0,192,51,51,0,192,51,51,0,192,15,60,0,192,15,60,0,192,3,48,63,252,3,48,63,252,255,255,0,192,255,255,0,192,0,0,0,192,0,0,0,192,12,12,48,192,12,12,48,192,3,48,12,192,3,48,12,192,63,255,12,192,63,255,12,192,0,192,0,192,0,192,0,192,15,252,0,192,15,252,0,192,0,192,0,192,0,192,0,192,0,255,0,192,0,255,0,192,63,192,12,192,63,192,12,192,12,0,3,0,12,0,3,0,
  // 0x5c0f  小
  15,92,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,3,0,3,3,3,0,3,3,0,192,3,3,0,192,3,3,0,48,3,3,0,48,12,3,0,48,12,3,0,48,12,3,0,12,12,3,0,12,48,3,0,12,48,3,0,12,192,3,0,12,192,3,0,12,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,51,0,0,0,51,0,0,0,12,0,0,0,12,0,0,
  // 0x5c31  就
  49,92,30,32,128,32,0,252,12,0,48,0,12,0,48,0,3,0,51,0,3,0,51,0,255,252,48,192,255,252,48,192,0,0,48,192,0,0,48,192,0,0,48,0,0,0,48,0,63,243,255,252,63,243,255,252,48,48,51,0,48,48,51,0,48,48,51,0,48,48,51,0,48,48,51,0,48,48,51,0,63,240,51,0,63,240,51,0,3,0,195,0,3,0,195,0,51,48,195,0,51,48,195,0,195,12,195,12,195,12,195,12,3,3,3,12,3,3,3,12,51,3,0,252,51,3,0,252,12,12,0,0,12,12,0,0,
  // 0x5de5  工
  229,93,30,24,96,32,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,
  // 0x5dee  差
  238,93,30,32,128,32,0,252,0,192,12,0,0,192,12,0,0,48,48,0,0,48,48,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,255,255,255,252,255,255,255,252,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,3,63,255,192,3,63,255,192,12,0,192,0,12,0,192,0,48,0,192,0,48,0,192,0,192,0,192,0,192,0,192,0,3,255,255,240,3,255,255,240,
  // 0x5df2  已
  242,93,24,28,84,32,4,254,255,255,240,255,255,240,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,192,0,48,192,0,48,192,0,48,192,0,48,255,255,240,255,255,240,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,3,192,0,3,192,0,3,192,0,3,192,0,3,192,0,3,63,255,255,63,255,255,
  // 0x5e73  平
  115,94,30,30,120,32,0,252,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,3,0,3,3,3,0,0,195,3,0,0,195,3,0,0,195,12,0,0,195,12,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x5e8a  床
  138,94,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,0,192,0,0,0,192,0,15,255,255,252,15,255,255,252,12,0,0,0,12,0,0,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,255,255,240,12,255,255,240,12,0,192,0,12,0,192,0,12,3,240,0,12,3,240,0,12,12,204,0,12,12,204,0,12,12,204,0,12,12,204,0,12,48,195,0,12,48,195,0,48,192,192,192,48,192,192,192,51,0,192,60,51,0,192,60,192,0,192,0,192,0,192,0,0,0,192,0,0,0,192,0,
  // 0x5ea6  度
  166,94,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,0,192,0,0,0,192,0,15,255,255,252,15,255,255,252,12,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,15,255,255,240,15,255,255,240,12,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,12,15,252,0,12,15,252,0,12,0,0,0,12,0,0,0,12,255,255,0,12,255,255,0,12,48,3,0,12,48,3,0,48,12,12,0,48,12,12,0,48,3,240,0,48,3,240,0,192,60,15,0,192,60,15,0,15,192,0,252,15,192,0,252,
  // 0x5ee2  廢
  226,94,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,0,192,0,0,0,192,0,15,255,255,252,15,255,255,252,12,0,48,0,12,0,48,0,12,255,51,0,12,255,51,0,12,3,12,48,12,3,12,48,12,204,3,192,12,204,3,192,12,48,0,192,12,48,0,192,15,207,63,60,15,207,63,60,12,3,51,0,12,3,51,0,12,255,192,240,12,255,192,240,12,192,63,192,12,192,63,192,12,255,48,192,12,255,48,192,48,3,15,0,48,3,15,0,48,51,48,192,48,51,48,192,192,12,192,48,192,12,192,48,
  // 0x5efa  建
  250,94,30,32,128,32,0,252,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,255,207,255,192,255,207,255,192,0,192,48,192,0,192,48,192,3,63,255,252,3,63,255,252,3,0,48,192,3,0,48,192,12,15,255,192,12,15,255,192,63,192,48,0,63,192,48,0,0,207,255,192,0,207,255,192,0,192,48,0,0,192,48,0,48,192,48,0,48,192,48,0,15,63,255,240,15,63,255,240,3,0,48,0,3,0,48,0,12,240,48,0,12,240,48,0,48,15,255,252,48,15,255,252,192,0,0,0,192,0,0,0,
  // 0x5f15  引
  21,95,24,32,96,32,2,252,0,0,3,0,0,3,255,252,3,255,252,3,0,12,3,0,12,3,0,12,3,0,12,3,0,12,3,0,12,3,63,252,3,63,252,3,48,0,3,48,0,3,48,0,3,48,0,3,192,0,3,192,0,3,255,252,3,255,252,3,0,12,3,0,12,3,0,12,3,0,12,3,0,12,3,0,12,3,0,12,3,0,12,3,3,48,3,3,48,3,0,192,3,0,192,3,
  // 0x5f85  待
  133,95,30,32,128,32,0,252,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,0,48,0,3,0,48,0,12,15,255,240,12,15,255,240,48,192,48,0,48,192,48,0,0,192,48,0,0,192,48,0,3,63,255,252,3,63,255,252,15,0,3,0,15,0,3,0,51,0,3,0,51,0,3,0,195,63,255,252,195,63,255,252,3,0,3,0,3,0,3,0,3,12,3,0,3,12,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,0,51,0,3,0,51,0,3,0,12,0,3,0,12,0,
  // 0x5f8c  後
  140,95,30,32,128,32,0,252,0,192,12,0,0,192,12,0,0,192,48,0,0,192,48,0,3,0,192,192,3,0,192,192,12,3,3,0,12,3,3,0,48,207,252,0,48,207,252,0,0,192,48,0,0,192,48,0,3,0,192,192,3,0,192,192,15,15,255,240,15,15,255,240,51,0,192,48,51,0,192,48,195,0,192,0,195,0,192,0,3,3,255,192,3,3,255,192,3,15,0,192,3,15,0,192,3,48,195,0,3,48,195,0,3,0,60,0,3,0,60,0,3,3,195,192,3,3,195,192,3,60,0,60,3,60,0,60,
  // 0x5f91  徑
  145,95,30,32,128,32,0,252,0,192,0,0,0,192,0,0,0,207,255,240,0,207,255,240,3,0,0,0,3,0,0,0,12,3,12,48,12,3,12,48,48,204,48,192,48,204,48,192,0,240,195,0,0,240,195,0,3,12,48,192,3,12,48,192,15,3,12,48,15,3,12,48,51,0,0,0,51,0,0,0,195,15,255,240,195,15,255,240,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,63,255,252,3,63,255,252,3,0,0,0,3,0,0,0,
  // 0x5f9e  從
  158,95,30,32,128,32,0,252,0,192,192,192,0,192,192,192,0,192,192,192,0,192,192,192,3,0,192,192,3,0,192,192,12,0,192,192,12,0,192,192,48,195,51,48,48,195,51,48,0,204,12,12,0,204,12,12,3,48,48,12,3,48,48,12,15,0,12,0,15,0,12,0,51,0,12,0,51,0,12,0,195,3,12,0,195,3,12,0,3,3,15,240,3,3,15,240,3,3,12,0,3,3,12,0,3,12,204,0,3,12,204,0,3,12,60,0,3,12,60,0,3,48,15,252,3,48,15,252,3,192,0,0,3,192,0,0,
  // 0x5fa9  復
  169,95,30,32,128,32,0,252,0,195,0,0,0,195,0,0,0,195,0,0,0,195,0,0,3,3,255,252,3,3,255,252,12,12,0,0,12,12,0,0,48,243,255,240,48,243,255,240,0,195,0,48,0,195,0,48,3,3,255,240,3,3,255,240,15,3,0,48,15,3,0,48,51,3,255,240,51,3,255,240,195,0,192,0,195,0,192,0,3,0,255,240,3,0,255,240,3,3,0,192,3,3,0,192,3,12,195,0,3,12,195,0,3,0,60,0,3,0,60,0,3,3,195,192,3,3,195,192,3,60,0,60,3,60,0,60,
  // 0x5fae  微
  174,95,30,32,128,32,0,252,3,3,0,192,3,3,0,192,3,51,48,192,3,51,48,192,12,51,48,192,12,51,48,192,48,51,51,0,48,51,51,0,195,63,243,252,195,63,243,252,3,0,12,48,3,0,12,48,12,0,3,48,12,0,3,48,60,255,243,48,60,255,243,48,204,0,3,48,204,0,3,48,12,63,195,48,12,63,195,48,12,48,195,48,12,48,195,48,12,48,204,192,12,48,204,192,12,48,240,192,12,48,240,192,12,48,195,48,12,48,195,48,12,192,3,48,12,192,3,48,15,0,12,12,15,0,12,12,
  // 0x5fc3  心
  195,95,30,28,112,32,0,254,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,48,0,0,0,48,0,0,0,48,0,192,0,48,0,192,12,48,0,48,12,48,0,48,12,48,0,48,12,48,0,48,12,48,0,12,12,48,0,12,48,48,0,12,48,48,0,12,48,48,3,12,48,48,3,12,192,48,3,0,192,48,3,0,0,48,3,0,0,48,3,0,0,15,255,0,0,15,255,0,
  // 0x6027  性
  39,96,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,3,12,0,3,3,12,0,3,3,12,0,3,3,12,0,3,195,255,240,3,195,255,240,51,51,12,0,51,51,12,0,51,12,12,0,51,12,12,0,51,0,12,0,51,0,12,0,195,0,12,0,195,0,12,0,3,3,255,240,3,3,255,240,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,15,255,252,3,15,255,252,3,0,0,0,3,0,0,0,
  // 0x6062  恢
  98,96,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,15,255,252,3,15,255,252,3,192,192,0,3,192,192,0,51,48,195,0,51,48,195,0,51,0,195,0,51,0,195,0,51,3,3,12,51,3,3,12,195,3,51,12,195,3,51,12,3,3,51,48,3,3,51,48,3,12,195,0,3,12,195,0,3,12,12,192,3,12,12,192,3,48,12,192,3,48,12,192,3,0,48,48,3,0,48,48,3,0,192,48,3,0,192,48,3,3,0,12,3,3,0,12,
  // 0x606f  息
  111,96,30,30,120,32,0,254,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,0,3,0,0,0,3,0,0,0,192,192,48,0,192,192,48,48,192,195,12,48,192,195,12,48,192,3,12,48,192,3,12,192,63,255,0,192,63,255,0,
  // 0x61b6  憶
  182,97,30,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,48,0,3,0,48,0,3,15,255,240,3,15,255,240,3,195,0,192,3,195,0,192,51,48,195,0,51,48,195,0,51,63,255,252,51,63,255,252,51,0,0,0,51,0,0,0,195,15,255,240,195,15,255,240,3,12,0,48,3,12,0,48,3,15,255,240,3,15,255,240,3,12,0,48,3,12,0,48,3,15,255,240,3,15,255,240,3,0,48,0,3,0,48,0,3,51,12,48,3,51,12,48,3,51,0,204,3,51,0,204,3,192,255,204,3,192,255,204,
  // 0x61c9  應
  201,97,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,0,192,0,0,0,192,0,15,255,255,252,15,255,255,252,12,12,48,192,12,12,48,192,12,48,255,252,12,48,255,252,12,243,195,0,12,243,195,0,15,48,255,240,15,48,255,240,12,48,195,0,12,48,195,0,12,48,255,240,12,48,255,240,12,48,195,0,12,48,195,0,12,48,255,252,12,48,255,252,12,48,192,0,12,48,192,0,48,12,48,48,48,12,48,48,51,12,48,204,51,12,48,204,195,12,0,204,195,12,0,204,12,3,255,192,12,3,255,192,
  // 0x6210  成
  16,98,30,32,128,32,0,252,0,0,51,0,0,0,51,0,0,0,48,192,0,0,48,192,0,0,48,0,0,0,48,0,15,255,255,252,15,255,255,252,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,48,12,0,48,48,15,252,48,48,15,252,48,48,12,12,48,48,12,12,48,48,12,12,12,192,12,12,12,192,12,12,12,192,12,12,12,192,12,12,3,12,12,12,3,12,12,204,15,12,12,204,15,12,48,48,48,204,48,48,48,204,48,0,192,60,48,0,192,60,192,3,0,12,192,3,0,12,
  // 0x6236  戶
  54,98,26,32,128,32,0,252,0,0,3,0,0,0,3,0,0,0,255,192,0,0,255,192,3,255,0,0,3,255,0,0,3,0,0,0,3,0,0,0,3,255,255,192,3,255,255,192,3,0,0,192,3,0,0,192,3,0,0,192,3,0,0,192,3,0,0,192,3,0,0,192,3,255,255,192,3,255,255,192,3,0,0,192,3,0,0,192,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,0,
  // 0x6240  所
  64,98,30,32,128,32,0,252,0,12,0,192,0,12,0,192,0,63,3,240,0,63,3,240,15,192,252,0,15,192,252,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,15,252,192,0,15,252,192,0,12,12,255,252,12,12,255,252,12,12,192,192,12,12,192,192,12,12,192,192,12,12,192,192,15,252,192,192,15,252,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,48,3,0,192,48,3,0,192,48,3,0,192,48,3,0,192,192,12,0,192,192,12,0,192,0,48,0,192,0,48,0,192,
  // 0x6247  扇
  71,98,28,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,15,255,255,240,15,255,255,240,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,48,15,255,255,240,15,255,255,240,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,15,255,63,240,15,255,63,240,12,3,0,48,12,3,0,48,12,195,12,48,12,195,12,48,12,51,3,48,12,51,3,48,48,195,12,48,48,195,12,48,51,3,48,48,51,3,48,48,192,51,3,48,192,51,3,48,0,12,0,192,0,12,0,192,
  // 0x624b  手
  75,98,30,32,128,32,0,252,0,0,3,0,0,0,3,0,0,0,255,192,0,0,255,192,15,255,0,0,15,255,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,51,0,0,0,51,0,0,0,12,0,0,0,12,0,0,
  // 0x6253  打
  83,98,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,15,255,252,3,15,255,252,3,0,12,0,3,0,12,0,255,240,12,0,255,240,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,48,12,0,3,48,12,0,3,192,12,0,3,192,12,0,15,0,12,0,15,0,12,0,243,0,12,0,243,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,51,0,204,0,51,0,204,0,12,0,48,0,12,0,48,0,
  // 0x6279  批
  121,98,30,32,128,32,0,252,3,0,3,0,3,0,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,12,3,3,3,12,255,243,3,12,255,243,3,12,3,3,3,48,3,3,3,48,3,3,243,192,3,3,243,192,3,51,3,0,3,51,3,0,3,195,3,0,3,195,3,0,15,3,3,0,15,3,3,0,243,3,3,0,243,3,3,0,3,3,3,12,3,3,3,12,3,3,51,12,3,3,51,12,3,3,195,12,3,3,195,12,51,3,0,252,51,3,0,252,12,0,0,0,12,0,0,0,
  // 0x6296  抖
  150,98,30,32,128,32,0,252,3,0,3,0,3,0,3,0,3,3,3,0,3,3,3,0,3,0,195,0,3,0,195,0,3,0,195,0,3,0,195,0,255,240,3,0,255,240,3,0,3,3,3,0,3,3,3,0,3,0,195,0,3,0,195,0,3,48,195,0,3,48,195,0,3,192,3,0,3,192,3,0,15,0,3,252,15,0,3,252,243,15,255,0,243,15,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,51,0,3,0,51,0,3,0,12,0,3,0,12,0,3,0,
  // 0x62bd  抽
  189,98,28,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,255,243,255,240,255,243,255,240,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,51,12,48,3,51,12,48,3,195,12,48,3,195,12,48,15,3,255,240,15,3,255,240,243,3,12,48,243,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,51,3,255,240,51,3,255,240,12,3,0,48,12,3,0,48,
  // 0x62d4  拔
  212,98,30,32,128,32,0,252,3,0,51,0,3,0,51,0,3,0,48,192,3,0,48,192,3,0,48,192,3,0,48,192,3,0,48,0,3,0,48,0,255,207,255,252,255,207,255,252,3,0,192,0,3,0,192,0,3,48,192,0,3,48,192,0,3,192,255,240,3,192,255,240,15,3,48,48,15,3,48,48,243,3,48,48,243,3,48,48,3,3,12,192,3,3,12,192,3,3,12,192,3,3,12,192,3,12,3,0,3,12,3,0,3,12,12,192,3,12,12,192,51,48,48,48,51,48,48,48,12,3,192,12,12,3,192,12,
  // 0x6309  按
  9,99,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,15,255,252,3,15,255,252,255,204,0,12,255,204,0,12,3,48,48,48,3,48,48,48,3,0,48,0,3,0,48,0,3,207,255,252,3,207,255,252,15,0,192,192,15,0,192,192,243,0,192,192,243,0,192,192,3,3,0,192,3,3,0,192,3,0,243,0,3,0,243,0,3,0,12,0,3,0,12,0,3,0,51,0,3,0,51,0,51,0,192,192,51,0,192,192,12,15,0,48,12,15,0,48,
  // 0x6389  掉
  137,99,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,15,252,3,0,15,252,3,0,12,0,3,0,12,0,255,243,255,240,255,243,255,240,3,3,0,48,3,3,0,48,3,51,255,240,3,51,255,240,3,195,0,48,3,195,0,48,15,3,255,240,15,3,255,240,243,3,12,48,243,3,12,48,3,0,12,0,3,0,12,0,3,15,255,252,3,15,255,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,51,0,12,0,51,0,12,0,12,0,12,0,12,0,12,0,
  // 0x63a2  探
  162,99,30,32,128,32,0,252,12,0,0,0,12,0,0,0,12,63,255,240,12,63,255,240,12,48,0,48,12,48,0,48,12,48,204,48,12,48,204,48,255,195,3,0,255,195,3,0,12,12,0,192,12,12,0,192,12,0,48,0,12,0,48,0,12,192,48,0,12,192,48,0,15,63,255,240,15,63,255,240,252,0,48,0,252,0,48,0,12,0,252,0,12,0,252,0,12,3,51,0,12,3,51,0,12,12,48,192,12,12,48,192,12,240,48,60,12,240,48,60,204,0,48,0,204,0,48,0,48,0,48,0,48,0,48,0,
  // 0x63a5  接
  165,99,30,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,48,0,3,0,48,0,3,15,255,240,3,15,255,240,3,0,0,0,3,0,0,0,255,243,0,192,255,243,0,192,3,0,195,0,3,0,195,0,3,63,255,252,3,63,255,252,3,0,48,0,3,0,48,0,3,192,48,0,3,192,48,0,15,63,255,252,15,63,255,252,243,0,192,192,243,0,192,192,3,3,0,192,3,3,0,192,3,0,195,0,3,0,195,0,3,0,60,0,3,0,60,0,51,3,195,192,51,3,195,192,12,60,0,48,12,60,0,48,
  // 0x63a7  控
  167,99,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,15,255,252,3,15,255,252,255,204,0,12,255,204,0,12,3,48,195,48,3,48,195,48,3,3,0,192,3,3,0,192,3,204,0,48,3,204,0,48,15,0,0,0,15,0,0,0,243,3,255,240,243,3,255,240,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,51,63,255,252,51,63,255,252,12,0,0,0,12,0,0,0,
  // 0x63d0  提
  208,99,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,3,255,240,3,3,255,240,3,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,255,243,255,240,255,243,255,240,3,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,3,51,255,240,3,51,255,240,3,192,0,0,3,192,0,0,15,15,255,252,15,15,255,252,243,0,12,0,243,0,12,0,3,3,12,0,3,3,12,0,3,3,15,240,3,3,15,240,3,3,12,0,3,3,12,0,51,12,204,0,51,12,204,0,12,48,63,252,12,48,63,252,
  // 0x63d2  插
  210,99,30,32,128,32,0,252,12,0,0,192,12,0,0,192,12,0,15,240,12,0,15,240,12,63,240,0,12,63,240,0,12,0,48,0,12,0,48,0,255,192,48,0,255,192,48,0,12,255,255,252,12,255,255,252,12,0,48,0,12,0,48,0,12,195,48,0,12,195,48,0,15,60,51,240,15,60,51,240,252,48,48,48,252,48,48,48,12,48,48,48,12,48,48,48,12,63,51,240,12,63,51,240,12,48,48,48,12,48,48,48,12,48,48,48,12,48,48,48,204,63,255,240,204,63,255,240,48,48,0,48,48,48,0,48,
  // 0x63db  換
  219,99,30,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,3,255,192,3,3,255,192,3,12,0,192,3,12,0,192,255,240,3,0,255,240,3,0,3,15,255,252,3,15,255,252,3,12,0,12,3,12,0,12,3,204,51,12,3,204,51,12,15,12,192,204,15,12,192,204,243,12,12,12,243,12,12,12,3,0,12,0,3,0,12,0,3,63,255,252,3,63,255,252,3,0,51,0,3,0,51,0,3,0,192,192,3,0,192,192,51,3,0,48,51,3,0,48,12,60,0,12,12,60,0,12,
  // 0x64c7  擇
  199,100,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,15,255,252,3,15,255,252,3,12,51,12,3,12,51,12,3,15,255,252,3,15,255,252,255,240,12,0,255,240,12,0,3,3,255,240,3,3,255,240,3,48,12,0,3,48,12,0,3,207,255,252,3,207,255,252,15,0,192,192,15,0,192,192,243,0,51,0,243,0,51,0,3,3,255,240,3,3,255,240,3,0,12,0,3,0,12,0,3,63,255,252,3,63,255,252,3,0,12,0,3,0,12,0,51,0,12,0,51,0,12,0,12,0,12,0,12,0,12,0,
  // 0x64ca  擊
  202,100,30,32,128,32,0,252,0,192,15,240,0,192,15,240,63,255,12,48,63,255,12,48,12,204,12,48,12,204,12,48,15,252,48,12,15,252,48,12,12,204,15,240,12,204,15,240,255,255,204,48,255,255,204,48,48,195,3,192,48,195,3,192,63,255,60,60,63,255,60,60,0,0,12,0,0,0,12,0,3,255,240,0,3,255,240,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,15,0,0,0,15,0,0,
  // 0x64cb  擋
  203,100,30,32,128,32,0,252,12,0,48,0,12,0,48,0,12,12,48,192,12,12,48,192,12,3,51,0,12,3,51,0,12,63,255,252,12,63,255,252,255,48,0,12,255,48,0,12,12,192,0,48,12,192,0,48,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,15,15,255,192,15,15,255,192,252,0,0,0,252,0,0,0,12,63,255,240,12,63,255,240,12,48,48,48,12,48,48,48,12,63,255,240,12,63,255,240,12,48,48,48,12,48,48,48,204,63,255,240,204,63,255,240,48,48,0,48,48,48,0,48,
  // 0x64e0  擠
  224,100,30,32,128,32,0,252,12,0,192,0,12,0,192,0,12,0,48,0,12,0,48,0,12,63,255,240,12,63,255,240,12,3,3,0,12,3,3,0,255,0,204,48,255,0,204,48,12,255,51,192,12,255,51,192,12,51,51,48,12,51,51,48,12,51,51,12,12,51,51,12,15,207,51,192,15,207,51,192,252,0,0,0,252,0,0,0,12,12,0,192,12,12,0,192,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,15,255,192,12,15,255,192,204,12,0,192,204,12,0,192,48,48,0,192,48,48,0,192,
  // 0x6536  收
  54,101,28,32,128,32,2,252,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,195,0,192,0,195,0,192,0,195,3,0,0,195,3,0,0,195,3,255,240,195,3,255,240,195,12,3,0,195,12,3,0,195,51,3,0,195,51,3,0,195,3,3,0,195,3,3,0,195,3,3,0,195,3,3,0,207,0,204,0,207,0,204,0,243,0,204,0,243,0,204,0,195,0,48,0,195,0,48,0,3,0,204,0,3,0,204,0,3,3,3,0,3,3,3,0,3,12,0,192,3,12,0,192,3,48,0,48,3,48,0,48,
  // 0x653e  放
  62,101,30,32,128,32,0,252,12,0,48,0,12,0,48,0,3,0,48,0,3,0,48,0,0,0,48,0,0,0,48,0,255,252,192,0,255,252,192,0,12,0,255,252,12,0,255,252,12,3,0,192,12,3,0,192,15,252,192,192,15,252,192,192,12,48,192,192,12,48,192,192,12,48,192,192,12,48,192,192,12,48,51,0,12,48,51,0,12,48,51,0,12,48,51,0,12,48,12,0,12,48,12,0,48,48,51,0,48,48,51,0,51,48,192,192,51,48,192,192,192,195,0,48,192,195,0,48,0,12,0,12,0,12,0,12,
  // 0x6557  敗
  87,101,30,32,128,32,0,252,0,0,48,0,0,0,48,0,63,240,48,0,63,240,48,0,48,48,192,0,48,48,192,0,48,48,255,252,48,48,255,252,63,243,0,192,63,243,0,192,48,51,0,192,48,51,0,192,48,60,192,192,48,60,192,192,63,240,192,192,63,240,192,192,48,48,192,192,48,48,192,192,48,48,51,0,48,48,51,0,63,240,51,0,63,240,51,0,0,0,12,0,0,0,12,0,12,192,51,0,12,192,51,0,12,48,192,192,12,48,192,192,48,51,0,48,48,51,0,48,192,12,0,12,192,12,0,12,
  // 0x6574  整
  116,101,30,32,128,32,0,252,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,255,255,207,252,255,255,207,252,0,192,48,48,0,192,48,48,63,255,204,48,63,255,204,48,48,195,12,48,48,195,12,48,63,255,12,192,63,255,12,192,12,204,3,0,12,204,3,0,48,195,12,192,48,195,12,192,192,192,48,60,192,192,48,60,0,0,0,0,0,0,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,3,3,255,192,3,3,255,192,3,3,0,0,3,3,0,0,255,255,255,252,255,255,255,252,
  // 0x6578  數
  120,101,30,32,128,32,0,252,0,192,3,0,0,192,3,0,63,255,3,0,63,255,3,0,48,195,3,0,48,195,3,0,255,255,204,0,255,255,204,0,48,195,15,252,48,195,15,252,63,255,48,48,63,255,48,48,0,192,12,48,0,192,12,48,63,255,12,48,63,255,12,48,48,195,12,48,48,195,12,48,63,255,12,192,63,255,12,192,3,0,12,192,3,0,12,192,255,255,3,0,255,255,3,0,12,3,12,192,12,3,12,192,63,12,12,192,63,12,12,192,0,240,48,48,0,240,48,48,255,15,192,12,255,15,192,12,
  // 0x6599  料
  153,101,30,32,128,32,0,252,0,192,0,192,0,192,0,192,0,192,192,192,0,192,192,192,48,204,48,192,48,204,48,192,12,204,48,192,12,204,48,192,12,240,0,192,12,240,0,192,0,192,192,192,0,192,192,192,255,252,48,192,255,252,48,192,3,192,48,192,3,192,48,192,3,240,0,192,3,240,0,192,12,204,0,252,12,204,0,252,12,204,255,192,12,204,255,192,48,192,0,192,48,192,0,192,192,192,0,192,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,
  // 0x659c  斜
  156,101,30,32,128,32,0,252,0,192,0,192,0,192,0,192,0,192,48,192,0,192,48,192,3,48,12,192,3,48,12,192,12,12,12,192,12,12,12,192,48,3,0,192,48,3,0,192,207,252,48,192,207,252,48,192,0,192,12,192,0,192,12,192,0,192,12,192,0,192,12,192,63,255,0,252,63,255,0,252,0,192,63,192,0,192,63,192,12,204,0,192,12,204,0,192,12,195,0,192,12,195,0,192,48,195,0,192,48,195,0,192,192,192,0,192,192,192,0,192,12,192,0,192,12,192,0,192,3,0,0,192,3,0,0,192,
  // 0x65b0  新
  176,101,30,32,128,32,0,252,3,0,0,0,3,0,0,0,0,192,0,48,0,192,0,48,63,255,63,192,63,255,63,192,0,0,48,0,0,0,48,0,12,12,48,0,12,12,48,0,3,48,48,0,3,48,48,0,255,255,63,252,255,255,63,252,0,192,48,192,0,192,48,192,0,192,48,192,0,192,48,192,63,255,48,192,63,255,48,192,0,192,48,192,0,192,48,192,12,204,48,192,12,204,48,192,48,195,48,192,48,195,48,192,192,192,192,192,192,192,192,192,12,192,192,192,12,192,192,192,3,3,0,192,3,3,0,192,
  // 0x65b7  斷
  183,101,28,32,128,32,2,252,3,3,0,48,3,3,0,48,204,3,15,192,204,3,15,192,207,204,204,0,207,204,204,0,195,15,204,0,195,15,204,0,204,195,12,0,204,195,12,0,207,207,207,240,207,207,207,240,192,192,204,192,192,192,204,192,255,255,204,192,255,255,204,192,195,3,12,192,195,3,12,192,204,3,12,192,204,3,12,192,207,204,204,192,207,204,204,192,195,15,204,192,195,15,204,192,204,195,12,192,204,195,12,192,207,207,204,192,207,207,204,192,192,192,240,192,192,192,240,192,255,255,192,192,255,255,192,192,
  // 0x65bc  於
  188,101,30,30,120,32,0,254,12,0,12,0,12,0,12,0,3,0,12,0,3,0,12,0,0,0,12,0,0,0,12,0,255,252,51,0,255,252,51,0,12,0,51,0,12,0,51,0,12,0,192,192,12,0,192,192,15,243,0,48,15,243,0,48,12,60,0,12,12,60,0,12,12,48,60,0,12,48,60,0,12,48,3,0,12,48,3,0,12,48,0,0,12,48,0,0,12,48,240,0,12,48,240,0,48,48,12,0,48,48,12,0,51,48,3,0,51,48,3,0,192,192,0,192,192,192,0,192,
  // 0x6607  昇
  7,102,30,30,120,32,0,252,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,0,0,0,0,0,0,0,0,0,63,12,0,0,63,12,0,63,192,12,0,63,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,255,255,255,252,255,255,255,252,0,192,12,0,0,192,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,12,0,12,0,12,0,12,0,
  // 0x660e  明
  14,102,26,30,120,32,2,252,0,3,255,192,0,3,255,192,255,195,0,192,255,195,0,192,192,195,0,192,192,195,0,192,192,195,0,192,192,195,0,192,192,195,255,192,192,195,255,192,255,195,0,192,255,195,0,192,192,195,0,192,192,195,0,192,192,195,0,192,192,195,0,192,192,195,255,192,192,195,255,192,255,195,0,192,255,195,0,192,192,195,0,192,192,195,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,48,12,192,0,48,12,192,0,192,3,0,0,192,3,0,
  // 0x662f  是
  47,102,30,32,128,32,0,252,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,0,0,0,0,0,0,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,255,192,3,3,255,192,3,3,0,0,3,3,0,0,12,195,0,0,12,195,0,0,48,51,0,0,48,51,0,0,192,15,255,252,192,15,255,252,
  // 0x6642  時
  66,102,28,32,128,32,2,252,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,255,192,48,0,255,192,48,0,192,207,255,192,192,207,255,192,192,192,48,0,192,192,48,0,192,192,48,0,192,192,48,0,192,255,255,240,192,255,255,240,255,192,3,0,255,192,3,0,192,192,3,0,192,192,3,0,192,207,255,240,192,207,255,240,192,192,3,0,192,192,3,0,192,195,3,0,192,195,3,0,255,192,195,0,255,192,195,0,192,192,3,0,192,192,3,0,0,0,51,0,0,0,51,0,0,0,12,0,0,0,12,0,
  // 0x66ab  暫
  171,102,28,32,128,32,2,252,3,0,0,192,3,0,0,192,255,252,255,0,255,252,255,0,3,0,192,0,3,0,192,0,255,252,192,0,255,252,192,0,195,12,255,240,195,12,255,240,255,252,195,0,255,252,195,0,195,12,195,0,195,12,195,0,255,252,195,0,255,252,195,0,3,0,195,0,3,0,195,0,255,252,195,0,255,252,195,0,3,3,3,0,3,3,3,0,15,255,252,0,15,255,252,0,12,0,12,0,12,0,12,0,15,255,252,0,15,255,252,0,12,0,12,0,12,0,12,0,15,255,252,0,15,255,252,0,
  // 0x66f4  更
  244,102,30,30,120,32,0,252,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,3,3,0,0,3,3,0,0,0,204,0,0,0,204,0,0,0,60,0,0,0,60,0,0,3,195,240,0,3,195,240,0,252,0,15,252,252,0,15,252,
  // 0x6700  最
  0,103,30,32,128,32,0,252,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,0,0,0,0,0,0,0,0,255,255,255,252,255,255,255,252,12,12,0,0,12,12,0,0,15,252,255,192,15,252,255,192,12,12,192,192,12,12,192,192,15,252,195,0,15,252,195,0,12,12,51,0,12,12,51,0,12,255,12,0,12,255,12,0,255,12,51,0,255,12,51,0,48,12,192,192,48,12,192,192,0,15,0,60,0,15,0,60,
  // 0x6709  有
  9,103,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,255,255,255,252,255,255,255,252,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,255,255,0,0,255,255,0,0,192,3,0,0,192,3,0,3,192,3,0,3,192,3,0,12,255,255,0,12,255,255,0,48,192,3,0,48,192,3,0,192,192,3,0,192,192,3,0,0,255,255,0,0,255,255,0,0,192,3,0,0,192,3,0,0,192,3,0,0,192,3,0,0,192,51,0,0,192,51,0,0,192,12,0,0,192,12,0,
  // 0x677f  板
  127,103,30,32,128,32,0,252,3,0,0,192,3,0,0,192,3,0,3,240,3,0,3,240,3,3,252,0,3,3,252,0,3,3,0,0,3,3,0,0,255,243,0,0,255,243,0,0,3,3,255,240,3,3,255,240,15,3,48,48,15,3,48,48,15,195,48,48,15,195,48,48,51,51,48,48,51,51,48,48,51,51,12,192,51,51,12,192,195,3,12,192,195,3,12,192,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,12,12,192,3,12,12,192,3,12,48,48,3,12,48,48,3,48,192,12,3,48,192,12,
  // 0x67f1  柱
  241,103,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,12,0,3,0,12,0,3,0,0,0,3,0,0,0,3,15,255,252,3,15,255,252,255,240,12,0,255,240,12,0,3,0,12,0,3,0,12,0,15,0,12,0,15,0,12,0,15,192,12,0,15,192,12,0,51,51,255,240,51,51,255,240,51,48,12,0,51,48,12,0,195,0,12,0,195,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,15,255,252,3,15,255,252,3,0,0,0,3,0,0,0,
  // 0x6821  校
  33,104,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,3,255,252,3,3,255,252,255,240,0,0,255,240,0,0,3,0,192,192,3,0,192,192,15,3,0,48,15,3,0,48,15,204,0,12,15,204,0,12,51,48,192,192,51,48,192,192,51,0,192,192,51,0,192,192,195,0,51,0,195,0,51,0,3,0,51,0,3,0,51,0,3,0,12,0,3,0,12,0,3,0,51,0,3,0,51,0,3,0,192,192,3,0,192,192,3,15,0,60,3,15,0,60,
  // 0x683c  格
  60,104,30,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,255,192,3,0,255,192,3,3,0,192,3,3,0,192,255,207,3,0,255,207,3,0,3,48,204,0,3,48,204,0,15,0,48,0,15,0,48,0,15,192,204,0,15,192,204,0,51,51,3,192,51,51,3,192,51,12,0,60,51,12,0,60,195,51,255,192,195,51,255,192,3,3,0,192,3,3,0,192,3,3,0,192,3,3,0,192,3,3,0,192,3,3,0,192,3,3,255,192,3,3,255,192,3,3,0,192,3,3,0,192,
  // 0x689d  條
  157,104,30,32,128,32,0,252,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,0,255,240,3,0,255,240,3,0,192,192,3,0,192,192,15,51,51,0,15,51,51,0,51,48,12,0,51,48,12,0,195,48,243,192,195,48,243,192,3,63,12,60,3,63,12,60,3,48,12,0,3,48,12,0,3,51,255,240,3,51,255,240,3,48,12,0,3,48,12,0,3,48,204,192,3,48,204,192,3,51,12,48,3,51,12,48,3,12,12,12,3,12,12,12,3,0,204,0,3,0,204,0,3,0,48,0,3,0,48,0,
  // 0x68c4  棄
  196,104,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,3,0,3,0,3,0,3,0,15,255,255,192,15,255,255,192,0,3,0,192,0,3,0,192,3,3,3,0,3,3,3,0,255,255,255,252,255,255,255,252,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,51,48,0,0,51,48,0,3,195,15,0,3,195,15,0,252,3,0,252,252,3,0,252,0,3,0,0,0,3,0,0,
  // 0x69fd  槽
  253,105,30,32,128,32,0,252,3,0,195,0,3,0,195,0,3,0,195,0,3,0,195,0,3,63,255,252,3,63,255,252,3,0,195,0,3,0,195,0,255,207,255,240,255,207,255,240,3,12,195,48,3,12,195,48,15,15,255,240,15,15,255,240,15,204,195,48,15,204,195,48,51,63,255,240,51,63,255,240,51,0,0,0,51,0,0,0,195,3,255,192,195,3,255,192,3,3,0,192,3,3,0,192,3,3,255,192,3,3,255,192,3,3,0,192,3,3,0,192,3,3,255,192,3,3,255,192,3,3,0,192,3,3,0,192,
  // 0x6a59  橙
  89,106,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,63,204,48,3,63,204,48,3,0,204,192,3,0,204,192,3,12,195,12,3,12,195,12,255,195,3,48,255,195,3,48,3,12,0,192,3,12,0,192,15,51,255,48,15,51,255,48,15,192,0,12,15,192,0,12,51,63,255,192,51,63,255,192,51,12,0,192,51,12,0,192,195,12,0,192,195,12,0,192,3,15,255,192,3,15,255,192,3,12,0,192,3,12,0,192,3,3,3,0,3,3,3,0,3,255,255,252,3,255,255,252,3,0,0,0,3,0,0,0,
  // 0x6a5f  機
  95,106,30,32,128,32,0,252,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,12,204,204,3,12,204,204,3,15,204,252,3,15,204,252,255,195,12,48,255,195,12,48,3,12,204,204,3,12,204,204,15,15,204,252,15,15,204,252,15,195,12,48,15,195,12,48,51,63,255,252,51,63,255,252,51,3,3,0,51,3,3,0,195,3,3,48,195,3,3,48,3,3,3,48,3,3,3,48,3,12,192,204,3,12,192,204,3,12,48,204,3,12,48,204,3,12,3,60,3,12,3,60,3,48,12,12,3,48,12,12,
  // 0x6aa2  檢
  162,106,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,51,0,3,0,51,0,3,0,192,192,3,0,192,192,255,243,0,48,255,243,0,48,3,12,255,204,3,12,255,204,15,0,0,0,15,0,0,0,15,192,0,0,15,192,0,0,51,51,243,240,51,51,243,240,51,51,51,48,51,51,51,48,195,3,51,48,195,3,51,48,3,3,243,240,3,3,243,240,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,3,51,48,3,3,51,48,3,12,12,12,3,12,12,12,
  // 0x6b62  止
  98,107,30,30,120,32,0,254,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,255,192,3,3,255,192,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,255,255,255,252,255,255,255,252,
  // 0x6b63  正
  99,107,30,28,112,32,0,254,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,255,192,3,3,255,192,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,255,255,255,252,255,255,255,252,
  // 0x6b65  步
  101,107,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,255,192,3,3,255,192,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,0,192,3,3,0,192,3,3,3,0,3,3,3,0,12,3,12,0,12,3,12,0,48,0,240,0,48,0,240,0,0,15,0,0,0,15,0,0,3,240,0,0,3,240,0,0,252,0,0,0,252,0,0,0,
  // 0x6b78  歸
  120,107,30,32,128,32,0,252,3,0,0,0,3,0,0,0,63,243,255,240,63,243,255,240,48,48,0,48,48,48,0,48,63,240,255,240,63,240,255,240,48,0,0,48,48,0,0,48,63,243,255,240,63,243,255,240,48,48,0,0,48,48,0,0,63,255,255,252,63,255,255,252,3,12,12,12,3,12,12,12,3,0,12,0,3,0,12,0,51,243,255,240,51,243,255,240,51,3,12,48,51,3,12,48,51,3,12,48,51,3,12,48,51,243,15,48,51,243,15,48,252,3,12,192,252,3,12,192,0,0,12,0,0,0,12,0,
  // 0x6bbc  殼
  188,107,30,32,128,32,0,252,0,192,0,0,0,192,0,0,0,192,63,192,0,192,63,192,63,255,48,192,63,255,48,192,0,192,48,192,0,192,48,192,15,252,48,192,15,252,48,192,0,0,192,60,0,0,192,60,63,255,0,0,63,255,0,0,48,3,255,240,48,3,255,240,207,252,48,48,207,252,48,48,0,0,48,48,0,0,48,48,15,240,12,192,15,240,12,192,12,48,12,192,12,48,12,192,12,51,3,0,12,51,3,0,12,60,12,192,12,60,12,192,48,48,48,48,48,48,48,48,192,3,192,12,192,3,192,12,
  // 0x6bd4  比
  212,107,26,30,120,32,4,254,0,12,0,0,0,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,3,0,192,12,3,0,192,12,12,0,192,12,12,0,192,12,48,0,192,12,48,0,255,204,192,0,255,204,192,0,192,15,0,0,192,15,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,192,192,12,0,192,195,204,0,192,195,204,0,192,252,12,0,192,252,12,0,192,192,3,255,192,192,3,255,192,
  // 0x6c92  沒
  146,108,30,32,128,32,0,252,0,0,192,0,0,0,192,0,12,0,192,0,12,0,192,0,3,0,255,240,3,0,255,240,3,3,0,48,3,3,0,48,192,3,0,48,192,3,0,48,48,12,12,192,48,12,12,192,48,192,3,0,48,192,3,0,0,207,255,240,0,207,255,240,3,3,0,48,3,3,0,48,3,0,192,192,3,0,192,192,252,0,192,192,252,0,192,192,12,0,51,0,12,0,51,0,12,0,12,0,12,0,12,0,12,0,51,0,12,0,51,0,12,3,192,192,12,3,192,192,0,60,0,60,0,60,0,60,
  // 0x6d88  消
  136,109,26,32,128,32,0,252,0,0,48,0,0,0,48,0,12,12,48,192,12,12,48,192,3,3,48,192,3,3,48,192,3,3,51,0,3,3,51,0,192,0,48,0,192,0,48,0,48,15,255,192,48,15,255,192,48,204,0,192,48,204,0,192,0,204,0,192,0,204,0,192,3,15,255,192,3,15,255,192,3,12,0,192,3,12,0,192,252,12,0,192,252,12,0,192,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,12,0,192,12,12,0,192,12,12,12,192,12,12,12,192,0,12,3,0,0,12,3,0,
  // 0x6de1  淡
  225,109,30,32,128,32,0,252,0,0,48,0,0,0,48,0,12,12,48,48,12,12,48,48,3,12,48,48,3,12,48,48,3,48,48,192,3,48,48,192,192,0,204,0,192,0,204,0,48,3,3,0,48,3,3,0,48,60,0,192,48,60,0,192,3,0,48,48,3,0,48,48,3,0,48,0,3,0,48,0,12,12,48,192,12,12,48,192,252,12,48,192,252,12,48,192,12,48,51,0,12,48,51,0,12,0,204,0,12,0,204,0,12,3,3,0,12,3,3,0,12,12,0,192,12,12,0,192,0,240,0,60,0,240,0,60,
  // 0x6e05  清
  5,110,30,32,128,32,0,252,12,0,48,0,12,0,48,0,3,0,48,0,3,0,48,0,3,63,255,240,3,63,255,240,0,0,48,0,0,0,48,0,192,15,255,192,192,15,255,192,48,0,48,0,48,0,48,0,48,255,255,252,48,255,255,252,0,192,0,0,0,192,0,0,3,15,255,192,3,15,255,192,3,12,0,192,3,12,0,192,3,15,255,192,3,15,255,192,252,12,0,192,252,12,0,192,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,12,12,192,12,12,12,192,0,12,3,0,0,12,3,0,
  // 0x6e2c  測
  44,110,30,32,128,32,0,252,0,0,0,12,0,0,0,12,12,63,240,12,12,63,240,12,3,48,48,12,3,48,48,12,3,48,51,12,3,48,51,12,192,63,243,12,192,63,243,12,48,48,51,12,48,48,51,12,48,48,51,12,48,48,51,12,3,63,243,12,3,63,243,12,3,48,51,12,3,48,51,12,12,48,51,12,12,48,51,12,252,63,243,12,252,63,243,12,12,0,0,12,12,0,0,12,12,12,192,12,12,12,192,12,12,12,48,12,12,12,48,12,12,48,48,204,12,48,48,204,0,192,0,48,0,192,0,48,
  // 0x6e90  源
  144,110,30,30,120,32,0,252,12,63,255,252,12,63,255,252,3,48,12,0,3,48,12,0,3,48,48,0,3,48,48,0,192,51,255,240,192,51,255,240,48,51,0,48,48,51,0,48,48,51,255,240,48,51,255,240,3,51,0,48,3,51,0,48,3,51,255,240,3,51,255,240,12,51,12,48,12,51,12,48,252,48,12,0,252,48,12,0,12,48,204,192,12,48,204,192,12,195,12,48,12,195,12,48,12,204,12,12,12,204,12,12,15,0,204,0,15,0,204,0,0,0,48,0,0,0,48,0,
  // 0x6e96  準
  150,110,30,32,128,32,0,252,12,3,48,0,12,3,48,0,3,3,12,0,3,3,12,0,192,15,255,240,192,15,255,240,51,12,48,0,51,12,48,0,3,63,255,192,3,63,255,192,12,204,48,0,12,204,48,0,252,15,255,192,252,15,255,192,12,12,48,0,12,12,48,0,12,15,255,240,12,15,255,240,12,12,0,0,12,12,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x6eab  溫
  171,110,30,30,120,32,0,254,48,0,0,0,48,0,0,0,12,15,255,192,12,15,255,192,12,12,48,192,12,12,48,192,0,204,48,192,0,204,48,192,192,204,204,192,192,204,204,192,51,15,0,192,51,15,0,192,51,15,255,192,51,15,255,192,12,12,0,192,12,12,0,192,12,0,0,0,12,0,0,0,240,63,255,240,240,63,255,240,48,48,204,48,48,48,204,48,48,48,204,48,48,48,204,48,48,48,204,48,48,48,204,48,48,48,204,48,48,48,204,48,48,255,255,252,48,255,255,252,
  // 0x6fc0  激
  192,111,30,32,128,32,0,252,0,12,3,0,0,12,3,0,48,48,3,0,48,48,3,0,12,255,195,0,12,255,195,0,12,192,195,0,12,192,195,0,0,255,207,252,0,255,207,252,192,192,204,48,192,192,204,48,48,255,243,48,48,255,243,48,51,48,3,48,51,48,3,48,3,12,3,48,3,12,3,48,12,255,243,48,12,255,243,48,252,48,3,48,252,48,3,48,12,63,192,192,12,63,192,192,12,48,192,192,12,48,192,192,12,192,195,48,12,192,195,48,12,204,195,48,12,204,195,48,3,3,12,12,3,3,12,12,
  // 0x7121  無
  33,113,28,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,255,255,240,3,255,255,240,12,204,204,0,12,204,204,0,48,204,204,0,48,204,204,0,0,204,204,0,0,204,204,0,63,255,255,240,63,255,255,240,0,204,204,0,0,204,204,0,0,204,204,0,0,204,204,0,0,204,204,0,0,204,204,0,63,255,255,240,63,255,255,240,0,0,0,0,0,0,0,0,12,48,192,192,12,48,192,192,12,12,48,48,12,12,48,48,48,12,48,48,48,12,48,48,192,0,0,48,192,0,0,48,
  // 0x71b1  熱
  177,113,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,63,240,48,0,63,240,48,0,3,0,255,192,3,0,255,192,255,252,48,192,255,252,48,192,48,48,48,192,48,48,48,192,195,12,240,192,195,12,240,192,63,240,48,192,63,240,48,192,3,0,204,204,3,0,204,204,3,240,204,204,3,240,204,204,252,3,0,60,252,3,0,60,48,12,0,12,48,12,0,12,0,0,0,0,0,0,0,0,48,192,192,192,48,192,192,192,48,48,48,48,48,48,48,48,192,48,48,48,192,48,48,48,
  // 0x71c8  燈
  200,113,30,32,128,32,0,252,12,0,12,0,12,0,12,0,12,63,204,48,12,63,204,48,12,0,204,192,12,0,204,192,12,204,195,12,12,204,195,12,207,3,3,48,207,3,3,48,204,12,0,192,204,12,0,192,204,51,255,48,204,51,255,48,204,192,0,12,204,192,0,12,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,12,0,192,12,12,0,192,12,15,255,192,12,15,255,192,51,12,0,192,51,12,0,192,48,195,3,0,48,195,3,0,48,255,255,252,48,255,255,252,192,0,0,0,192,0,0,0,
  // 0x7247  片
  71,114,26,32,128,32,2,252,0,0,192,0,0,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,15,255,255,192,15,255,255,192,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,15,255,240,0,15,255,240,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,192,0,48,0,192,0,48,0,
  // 0x7269  物
  105,114,28,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,51,0,192,0,51,0,192,0,51,0,255,240,51,0,255,240,63,243,51,48,63,243,51,48,51,12,51,48,51,12,51,48,195,0,51,48,195,0,51,48,3,0,195,48,3,0,195,48,3,240,195,48,3,240,195,48,255,3,12,48,255,3,12,48,51,12,12,48,51,12,12,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,192,48,3,0,192,48,3,3,12,192,3,3,12,192,3,0,3,0,3,0,3,0,
  // 0x7387  率
  135,115,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,12,0,0,0,12,0,0,48,48,48,48,48,48,48,48,12,255,192,192,12,255,192,192,3,3,3,0,3,3,3,0,12,12,48,192,12,12,48,192,48,255,252,48,48,255,252,48,0,0,12,0,0,0,12,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x7528  用
  40,117,26,30,120,32,0,252,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,48,3,0,192,48,3,0,192,48,3,12,192,48,3,12,192,192,0,3,0,192,0,3,0,
  // 0x754c  界
  76,117,30,30,120,32,0,252,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,0,12,192,0,0,12,192,0,0,240,60,0,0,240,60,0,15,48,51,192,15,48,51,192,240,48,48,60,240,48,48,60,0,48,48,0,0,48,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,0,48,0,3,0,48,0,
  // 0x767d  白
  125,118,22,32,96,32,4,252,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,255,255,252,255,255,252,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,255,255,252,255,255,252,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,255,255,252,255,255,252,192,0,12,192,0,12,
  // 0x7684  的
  132,118,26,32,128,32,2,252,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,48,0,192,0,48,0,192,0,255,240,255,192,255,240,255,192,192,51,0,192,192,51,0,192,192,51,0,192,192,51,0,192,192,60,0,192,192,60,0,192,192,48,192,192,192,48,192,192,255,240,48,192,255,240,48,192,192,48,48,192,192,48,48,192,192,48,0,192,192,48,0,192,192,48,0,192,192,48,0,192,192,48,0,192,192,48,0,192,255,240,0,192,255,240,0,192,192,48,51,0,192,48,51,0,0,0,12,0,0,0,12,0,
  // 0x76e3  監
  227,118,30,28,112,32,0,254,15,255,12,0,15,255,12,0,12,48,12,0,12,48,12,0,15,255,15,252,15,255,15,252,12,3,48,0,12,3,48,0,15,255,51,0,15,255,51,0,12,48,192,192,12,48,192,192,15,255,0,192,15,255,0,192,0,0,0,0,0,0,0,0,15,255,255,192,15,255,255,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,255,255,255,252,255,255,255,252,
  // 0x76f4  直
  244,118,30,30,120,32,0,254,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,255,255,255,252,255,255,255,252,
  // 0x7720  眠
  32,119,28,30,120,32,2,252,0,15,255,192,0,15,255,192,255,204,0,192,255,204,0,192,192,204,0,192,192,204,0,192,192,204,0,192,192,204,0,192,255,207,255,192,255,207,255,192,192,204,48,0,192,204,48,0,192,204,48,0,192,204,48,0,255,207,255,240,255,207,255,240,192,204,48,0,192,204,48,0,192,204,48,0,192,204,48,0,192,204,12,0,192,204,12,0,255,204,12,48,255,204,12,48,192,204,195,48,192,204,195,48,0,15,0,240,0,15,0,240,0,12,0,48,0,12,0,48,
  // 0x780d  砍
  13,120,30,32,128,32,0,252,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,255,240,48,0,255,240,48,0,3,0,63,240,3,0,63,240,3,0,192,48,3,0,192,48,12,0,192,192,12,0,192,192,15,243,12,0,15,243,12,0,60,48,12,0,60,48,12,0,60,48,12,0,60,48,12,0,204,48,51,0,204,48,51,0,12,48,51,0,12,48,51,0,12,48,51,0,12,48,51,0,15,240,192,192,15,240,192,192,12,48,192,192,12,48,192,192,12,3,0,48,12,3,0,48,0,12,0,12,0,12,0,12,
  // 0x78ba  確
  186,120,30,32,128,32,0,252,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,255,207,255,252,255,207,255,252,12,12,204,12,12,12,204,12,12,0,195,0,12,0,195,0,48,3,255,252,48,3,255,252,63,195,3,0,63,195,3,0,48,207,3,0,48,207,3,0,240,243,255,252,240,243,255,252,48,195,3,0,48,195,3,0,48,195,3,0,48,195,3,0,48,195,255,252,48,195,255,252,63,195,3,0,63,195,3,0,48,195,3,0,48,195,3,0,0,3,255,252,0,3,255,252,0,3,0,0,0,3,0,0,
  // 0x79fb  移
  251,121,30,32,128,32,0,252,0,192,12,0,0,192,12,0,3,240,12,0,3,240,12,0,255,0,63,240,255,0,63,240,3,0,192,48,3,0,192,48,3,3,48,192,3,3,48,192,255,240,15,0,255,240,15,0,3,0,12,0,3,0,12,0,15,0,48,192,15,0,48,192,15,195,195,0,15,195,195,0,51,48,15,252,51,48,15,252,51,48,48,12,51,48,48,12,195,3,204,48,195,3,204,48,3,0,3,192,3,0,3,192,3,0,3,0,3,0,3,0,3,0,60,0,3,0,60,0,3,3,192,0,3,3,192,0,
  // 0x7a4d  積
  77,122,30,32,128,32,0,252,0,192,12,0,0,192,12,0,3,243,255,252,3,243,255,252,255,0,12,0,255,0,12,0,3,3,255,240,3,3,255,240,3,0,12,0,3,0,12,0,255,243,255,252,255,243,255,252,3,0,0,0,3,0,0,0,15,3,255,240,15,3,255,240,15,195,0,48,15,195,0,48,51,51,255,240,51,51,255,240,51,51,0,48,51,51,0,48,195,3,255,240,195,3,255,240,3,3,0,48,3,3,0,48,3,3,255,240,3,3,255,240,3,0,192,192,3,0,192,192,3,3,0,48,3,3,0,48,
  // 0x7aef  端
  239,122,30,32,128,32,0,252,12,0,12,0,12,0,12,0,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,255,243,12,48,255,243,12,48,0,3,255,240,0,3,255,240,0,192,0,0,0,192,0,0,192,207,255,252,192,207,255,252,192,192,12,0,192,192,12,0,48,192,48,0,48,192,48,0,48,195,255,240,48,195,255,240,51,3,51,48,51,3,51,48,51,3,51,48,51,3,51,48,3,243,51,48,3,243,51,48,252,3,51,48,252,3,51,48,48,3,51,48,48,3,51,48,0,3,0,240,0,3,0,240,
  // 0x7b49  等
  73,123,30,32,128,32,0,252,12,0,48,0,12,0,48,0,15,255,63,252,15,255,63,252,48,192,195,0,48,192,195,0,192,51,0,192,192,51,0,192,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,0,0,0,0,0,0,0,0,0,12,0,0,0,12,0,63,255,255,240,63,255,255,240,0,192,12,0,0,192,12,0,0,48,12,0,0,48,12,0,0,48,204,0,0,48,204,0,0,0,48,0,0,0,48,0,
  // 0x7ba1  管
  161,123,30,32,128,32,0,252,12,0,48,0,12,0,48,0,15,255,63,252,15,255,63,252,48,192,195,0,48,192,195,0,192,51,0,192,192,51,0,192,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,195,255,252,48,195,255,252,48,3,0,12,0,3,0,12,0,3,255,252,0,3,255,252,0,3,0,0,0,3,0,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,
  // 0x7bb1  箱
  177,123,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,15,255,63,252,15,255,63,252,12,192,195,0,12,192,195,0,48,51,0,192,48,51,0,192,192,192,0,0,192,192,0,0,0,192,255,240,0,192,255,240,63,252,192,48,63,252,192,48,0,192,192,48,0,192,192,48,3,192,255,240,3,192,255,240,3,240,192,48,3,240,192,48,12,204,192,48,12,204,192,48,12,204,255,240,12,204,255,240,48,192,192,48,48,192,192,48,192,192,192,48,192,192,192,48,0,192,255,240,0,192,255,240,
  // 0x7cfb  系
  251,124,26,32,128,32,2,252,0,3,255,0,0,3,255,0,63,252,0,0,63,252,0,0,0,192,0,0,0,192,0,0,3,0,48,0,3,0,48,0,12,0,192,0,12,0,192,0,63,255,0,0,63,255,0,0,0,12,0,0,0,12,0,0,0,240,12,0,0,240,12,0,15,0,3,0,15,0,3,0,255,255,255,192,255,255,255,192,0,12,0,192,0,12,0,192,3,12,48,0,3,12,48,0,12,12,12,0,12,12,12,0,48,12,3,0,48,12,3,0,192,204,0,192,192,204,0,192,0,48,0,0,0,48,0,0,
  // 0x7d05  紅
  5,125,30,30,120,32,0,254,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,3,255,240,12,3,255,240,12,48,12,0,12,48,12,0,48,48,12,0,48,48,12,0,255,192,12,0,255,192,12,0,3,0,12,0,3,0,12,0,12,0,12,0,12,0,12,0,48,192,12,0,48,192,12,0,255,240,12,0,255,240,12,0,0,48,12,0,0,48,12,0,0,0,12,0,0,0,12,0,51,48,12,0,51,48,12,0,51,48,12,0,51,48,12,0,192,15,255,252,192,15,255,252,
  // 0x7d22  索
  34,125,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,12,0,12,48,12,0,12,192,48,12,48,192,48,12,48,3,255,240,0,3,255,240,0,0,3,192,0,0,3,192,0,0,60,3,0,0,60,3,0,15,255,255,192,15,255,255,192,0,3,0,192,0,3,0,192,3,3,12,0,3,3,12,0,12,51,3,0,12,51,3,0,48,12,0,192,48,12,0,192,
  // 0x7d2b  紫
  43,125,28,32,128,32,0,252,0,192,192,0,0,192,192,0,12,192,192,192,12,192,192,192,12,252,255,0,12,252,255,0,12,192,192,48,12,192,192,48,12,252,192,48,12,252,192,48,255,0,63,240,255,0,63,240,0,12,0,0,0,12,0,0,0,48,12,0,0,48,12,0,3,255,240,0,3,255,240,0,0,3,192,0,0,3,192,0,0,60,3,0,0,60,3,0,15,255,255,192,15,255,255,192,0,3,0,192,0,3,0,192,3,3,12,0,3,3,12,0,12,51,3,0,12,51,3,0,48,12,0,192,48,12,0,192,
  // 0x7d30  細
  48,125,28,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,3,255,240,12,3,255,240,12,51,12,48,12,51,12,48,48,51,12,48,48,51,12,48,255,195,12,48,255,195,12,48,3,3,12,48,3,3,12,48,12,3,12,48,12,3,12,48,48,195,255,240,48,195,255,240,255,243,12,48,255,243,12,48,0,51,12,48,0,51,12,48,0,3,12,48,0,3,12,48,51,51,12,48,51,51,12,48,51,51,12,48,51,51,12,48,192,3,255,240,192,3,255,240,0,3,0,48,0,3,0,48,
  // 0x7d42  終
  66,125,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,12,0,63,240,12,0,63,240,12,192,192,48,12,192,192,48,48,195,192,192,48,195,192,192,255,12,51,0,255,12,51,0,3,0,12,0,3,0,12,0,12,0,51,0,12,0,51,0,48,192,192,192,48,192,192,192,255,207,0,60,255,207,0,60,0,192,60,0,0,192,60,0,0,0,3,0,0,0,3,0,204,192,0,192,204,192,0,192,204,192,240,0,204,192,240,0,192,0,12,0,192,0,12,0,0,0,3,0,0,0,3,0,
  // 0x7d71  統
  113,125,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,12,0,3,0,12,0,12,0,12,0,12,0,12,0,12,207,255,252,12,207,255,252,48,192,48,0,48,192,48,0,255,0,192,192,255,0,192,192,3,3,0,48,3,3,0,48,12,15,255,252,12,15,255,252,48,192,195,12,48,192,195,12,255,240,195,0,255,240,195,0,0,48,195,0,0,48,195,0,0,0,195,0,0,0,195,0,51,51,3,12,51,51,3,12,51,51,3,12,51,51,3,12,192,12,0,252,192,12,0,252,0,48,0,0,0,48,0,0,
  // 0x7d72  絲
  114,125,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,12,0,48,192,12,0,48,192,12,48,192,192,12,48,192,192,48,51,255,0,48,51,255,0,255,192,12,0,255,192,12,0,3,0,48,0,3,0,48,0,12,0,192,192,12,0,192,192,48,195,255,240,48,195,255,240,255,240,12,48,255,240,12,48,0,48,12,0,0,48,12,0,0,0,204,192,0,0,204,192,51,51,12,48,51,51,12,48,51,60,12,12,51,60,12,12,192,0,204,0,192,0,204,0,0,0,48,0,0,0,48,0,
  // 0x7da0  綠
  160,125,30,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,255,192,3,0,255,192,12,0,192,192,12,0,192,192,12,195,0,192,12,195,0,192,48,195,255,0,48,195,255,0,255,0,3,0,255,0,3,0,3,0,3,0,3,0,3,0,12,15,255,252,12,15,255,252,48,192,12,0,48,192,12,0,255,204,12,12,255,204,12,12,0,195,63,48,0,195,63,48,0,0,204,192,0,0,204,192,204,195,12,48,204,195,12,48,204,204,12,12,204,204,12,12,192,0,204,0,192,0,204,0,0,0,48,0,0,0,48,0,
  // 0x7db2  網
  178,125,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,3,255,252,3,3,255,252,12,3,0,12,12,3,0,12,12,3,192,204,12,3,192,204,48,195,51,12,48,195,51,12,255,195,255,252,255,195,255,252,3,3,12,12,3,3,12,12,12,3,3,12,12,3,3,12,12,3,255,252,12,3,255,252,48,195,48,12,48,195,48,12,255,51,48,12,255,51,48,12,0,3,63,204,0,3,63,204,51,51,0,12,51,51,0,12,51,51,0,12,51,51,0,12,51,51,0,204,51,51,0,204,192,3,0,48,192,3,0,48,
  // 0x7dd2  緒
  210,125,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,12,3,0,12,12,12,3,255,204,12,3,255,204,12,48,12,48,12,48,12,48,48,48,12,192,48,48,12,192,255,207,255,252,255,207,255,252,3,0,12,0,3,0,12,0,12,0,48,0,12,0,48,0,48,192,255,240,48,192,255,240,255,243,192,48,255,243,192,48,0,60,192,48,0,60,192,48,0,0,255,240,0,0,255,240,51,48,192,48,51,48,192,48,51,48,192,48,51,48,192,48,192,0,255,240,192,0,255,240,0,0,192,48,0,0,192,48,
  // 0x7dda  線
  218,125,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,192,0,3,0,192,0,12,3,255,240,12,3,255,240,12,195,0,48,12,195,0,48,48,195,255,240,48,195,255,240,255,3,0,48,255,3,0,48,3,3,255,240,3,3,255,240,12,0,12,0,12,0,12,0,48,192,15,12,48,192,15,12,255,207,207,48,255,207,207,48,0,192,204,192,0,192,204,192,0,3,12,192,0,3,12,192,204,195,12,48,204,195,12,48,204,204,12,48,204,204,12,48,192,48,204,12,192,48,204,12,0,0,48,0,0,0,48,0,
  // 0x7de8  編
  232,125,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,12,0,3,0,12,0,12,3,255,252,12,3,255,252,12,51,0,12,12,51,0,12,48,51,0,12,48,51,0,12,255,195,255,252,255,195,255,252,3,3,0,0,3,3,0,0,12,3,0,0,12,3,0,0,48,195,255,252,48,195,255,252,255,243,204,204,255,243,204,204,0,51,204,204,0,51,204,204,0,12,255,252,0,12,255,252,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,192,48,204,12,192,48,204,12,0,0,192,60,0,0,192,60,
  // 0x7e2e  縮
  46,126,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,3,0,3,0,3,0,12,15,255,252,12,15,255,252,12,204,0,12,12,204,0,12,48,192,192,0,48,192,192,0,255,0,255,252,255,0,255,252,3,3,3,0,3,3,3,0,12,15,12,0,12,15,12,0,48,243,63,240,48,243,63,240,255,195,48,48,255,195,48,48,0,195,48,48,0,195,48,48,0,3,63,240,0,3,63,240,204,195,48,48,204,195,48,48,204,195,48,48,204,195,48,48,192,3,63,240,192,3,63,240,0,3,48,48,0,3,48,48,
  // 0x7e3d  總
  61,126,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,48,0,3,0,48,0,12,3,255,240,12,3,255,240,12,51,12,48,12,51,12,48,48,51,63,240,48,51,63,240,255,195,192,240,255,195,192,240,3,3,51,48,3,3,51,48,12,3,12,48,12,3,12,48,48,195,51,48,48,195,51,48,255,243,255,240,255,243,255,240,0,48,12,0,0,48,12,0,0,0,3,0,0,0,3,0,51,51,51,48,51,51,51,48,51,51,48,12,51,51,48,12,192,3,48,204,192,3,48,204,0,12,15,192,0,12,15,192,
  // 0x7e7c  繼
  124,126,30,32,128,32,0,252,3,0,48,48,3,0,48,48,3,12,192,48,3,12,192,48,12,12,252,204,12,12,252,204,12,204,48,252,12,204,48,252,48,204,204,48,48,204,204,48,255,12,252,252,255,12,252,252,3,12,12,12,3,12,12,12,12,15,255,252,12,15,255,252,48,204,48,48,48,204,48,48,255,204,192,48,255,204,192,48,0,204,252,204,0,204,252,204,0,12,48,252,0,12,48,252,204,204,204,48,204,204,204,48,204,204,252,252,204,204,252,252,192,12,12,12,192,12,12,12,0,15,255,252,0,15,255,252,
  // 0x7e8c  續
  140,126,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,15,255,252,3,15,255,252,12,0,12,0,12,0,12,0,12,195,255,240,12,195,255,240,48,192,0,0,48,192,0,0,255,15,255,252,255,15,255,252,3,12,51,12,3,12,51,12,12,15,255,252,12,15,255,252,48,195,0,48,48,195,0,48,255,243,255,240,255,243,255,240,0,51,0,48,0,51,0,48,0,3,255,240,0,3,255,240,51,51,0,48,51,51,0,48,51,51,255,240,51,51,255,240,192,0,192,192,192,0,192,192,0,3,0,48,0,3,0,48,
  // 0x7ea2  红
  162,126,30,30,120,32,0,254,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,3,255,240,12,3,255,240,12,48,12,0,12,48,12,0,48,48,12,0,48,48,12,0,255,192,12,0,255,192,12,0,3,0,12,0,3,0,12,0,12,0,12,0,12,0,12,0,48,0,12,0,48,0,12,0,255,240,12,0,255,240,12,0,48,0,12,0,48,0,12,0,0,0,12,0,0,0,12,0,3,240,12,0,3,240,12,0,252,0,12,0,252,0,12,0,48,15,255,252,48,15,255,252,
  // 0x7f6e  置
  110,127,30,32,128,32,0,252,63,255,255,240,63,255,255,240,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,12,0,0,0,12,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,255,255,255,252,255,255,255,252,
  // 0x7f72  署
  114,127,30,30,120,32,0,252,15,255,255,192,15,255,255,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,15,255,255,192,15,255,255,192,0,12,0,0,0,12,0,0,3,255,243,0,3,255,243,0,0,12,12,0,0,12,12,0,255,255,255,252,255,255,255,252,0,15,0,0,0,15,0,0,0,255,255,0,0,255,255,0,15,192,3,0,15,192,3,0,240,255,255,0,240,255,255,0,0,192,3,0,0,192,3,0,0,255,255,0,0,255,255,0,0,192,3,0,0,192,3,0,
  // 0x8070  聰
  112,128,30,32,128,32,0,252,0,0,12,0,0,0,12,0,255,240,48,0,255,240,48,0,48,195,255,240,48,195,255,240,48,195,12,48,48,195,12,48,63,195,63,240,63,195,63,240,48,195,192,240,48,195,192,240,48,195,51,48,48,195,51,48,63,195,12,48,63,195,12,48,48,195,51,48,48,195,51,48,48,195,255,240,48,195,255,240,48,240,48,0,48,240,48,0,63,192,12,48,63,192,12,48,240,204,204,12,240,204,204,12,0,204,192,204,0,204,192,204,0,240,192,192,0,240,192,192,0,192,63,192,0,192,63,192,
  // 0x81ea  自
  234,129,18,32,96,32,6,252,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,255,255,192,255,255,192,192,0,192,192,0,192,192,0,192,192,0,192,192,0,192,192,0,192,255,255,192,255,255,192,192,0,192,192,0,192,192,0,192,192,0,192,255,255,192,255,255,192,192,0,192,192,0,192,192,0,192,192,0,192,192,0,192,192,0,192,255,255,192,255,255,192,192,0,192,192,0,192,
  // 0x85cd  藍
  205,133,30,32,128,32,0,252,0,192,12,0,0,192,12,0,255,255,255,252,255,255,255,252,0,192,12,0,0,192,12,0,0,0,0,0,0,0,0,0,15,255,12,0,15,255,12,0,12,48,12,0,12,48,12,0,15,255,15,252,15,255,15,252,12,3,48,0,12,3,48,0,15,255,51,0,15,255,51,0,12,48,192,192,12,48,192,192,15,255,0,192,15,255,0,192,0,0,0,0,0,0,0,0,15,255,255,192,15,255,255,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,255,255,255,252,255,255,255,252,
  // 0x884c  行
  76,136,30,32,128,32,0,252,0,192,0,0,0,192,0,0,0,195,255,240,0,195,255,240,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,0,48,192,0,0,48,192,0,0,0,192,0,0,0,192,0,0,3,15,255,252,3,15,255,252,15,0,12,0,15,0,12,0,51,0,12,0,51,0,12,0,195,0,12,0,195,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,204,0,3,0,204,0,3,0,48,0,3,0,48,0,
  // 0x8868  表
  104,136,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,51,0,0,0,51,0,0,0,192,192,192,0,192,192,192,3,192,51,0,3,192,51,0,12,192,12,0,12,192,12,0,240,195,3,192,240,195,3,192,0,204,0,60,0,204,0,60,0,240,0,0,0,240,0,0,
  // 0x88ab  被
  171,136,30,32,128,32,0,252,12,0,3,0,12,0,3,0,3,0,3,0,3,0,3,0,0,0,3,0,0,0,3,0,255,195,255,252,255,195,255,252,0,195,3,12,0,195,3,12,3,3,3,48,3,3,3,48,3,51,3,0,3,51,3,0,15,195,255,240,15,195,255,240,51,51,48,48,51,51,48,48,195,3,48,48,195,3,48,48,3,3,12,192,3,3,12,192,3,3,12,192,3,3,12,192,3,3,3,0,3,3,3,0,3,12,12,192,3,12,12,192,3,12,48,48,3,12,48,48,3,48,192,12,3,48,192,12,
  // 0x88c5  装
  197,136,30,32,128,32,0,252,0,192,12,0,0,192,12,0,48,192,12,0,48,192,12,0,12,207,255,252,12,207,255,252,0,192,12,0,0,192,12,0,3,192,12,0,3,192,12,0,12,192,12,0,12,192,12,0,240,195,255,240,240,195,255,240,0,204,0,0,0,204,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,51,0,0,0,51,0,0,0,240,192,192,0,240,192,192,15,48,51,0,15,48,51,0,240,51,15,0,240,51,15,0,0,60,0,252,0,60,0,252,0,48,0,0,0,48,0,0,
  // 0x88dd  裝
  221,136,30,32,128,32,0,252,12,48,12,0,12,48,12,0,12,48,12,0,12,48,12,0,15,240,12,0,15,240,12,0,0,51,255,240,0,51,255,240,255,240,12,0,255,240,12,0,12,48,12,0,12,48,12,0,12,48,255,192,12,48,255,192,48,60,0,0,48,60,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,51,0,0,0,51,0,0,0,240,192,192,0,240,192,192,15,48,51,0,15,48,51,0,240,51,15,0,240,51,15,0,0,60,0,252,0,60,0,252,0,48,0,0,0,48,0,0,
  // 0x8907  複
  7,137,30,32,128,32,0,252,12,3,0,0,12,3,0,0,3,3,0,0,3,3,0,0,0,3,255,252,0,3,255,252,255,204,0,0,255,204,0,0,0,243,255,240,0,243,255,240,3,3,0,48,3,3,0,48,3,3,255,240,3,3,255,240,15,51,0,48,15,51,0,48,51,195,255,240,51,195,255,240,195,48,192,0,195,48,192,0,3,48,255,240,3,48,255,240,3,3,0,192,3,3,0,192,3,12,195,0,3,12,195,0,3,0,60,0,3,0,60,0,3,3,195,192,3,3,195,192,3,60,0,60,3,60,0,60,
  // 0x89d2  角
  210,137,26,32,128,32,0,252,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,3,255,252,0,3,255,252,0,12,0,12,0,12,0,12,0,48,0,48,0,48,0,48,0,207,255,255,192,207,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,48,3,0,192,48,3,0,192,48,3,12,192,48,3,12,192,192,0,3,0,192,0,3,0,
  // 0x8a08  計
  8,138,30,32,128,32,0,252,12,0,12,0,12,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,255,252,12,0,255,252,12,0,0,0,12,0,0,0,12,0,63,240,12,0,63,240,12,0,0,15,255,252,0,15,255,252,63,240,12,0,63,240,12,0,0,0,12,0,0,0,12,0,63,240,12,0,63,240,12,0,48,48,12,0,48,48,12,0,48,48,12,0,48,48,12,0,48,48,12,0,48,48,12,0,63,240,12,0,63,240,12,0,48,48,12,0,48,48,12,0,0,0,12,0,0,0,12,0,
  // 0x8a0a  訊
  10,138,30,32,128,32,0,252,12,0,0,0,12,0,0,0,3,15,255,0,3,15,255,0,0,0,195,0,0,0,195,0,255,240,195,0,255,240,195,0,0,0,195,0,0,0,195,0,63,192,195,0,63,192,195,0,0,0,195,0,0,0,195,0,63,207,255,0,63,207,255,0,0,0,195,0,0,0,195,0,63,192,195,0,63,192,195,0,48,192,195,0,48,192,195,0,48,192,195,12,48,192,195,12,48,192,192,204,48,192,192,204,63,192,192,204,63,192,192,204,48,192,192,60,48,192,192,60,0,0,192,12,0,0,192,12,
  // 0x8a18  記
  24,138,30,30,120,32,0,254,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,0,3,0,255,240,3,0,255,240,255,252,0,48,255,252,0,48,0,0,0,48,0,0,0,48,63,240,0,48,63,240,0,48,0,0,0,48,0,0,0,48,63,240,255,240,63,240,255,240,0,0,192,48,0,0,192,48,63,240,192,0,63,240,192,0,48,48,192,0,48,48,192,0,48,48,192,0,48,48,192,0,48,48,192,12,48,48,192,12,63,240,192,12,63,240,192,12,48,48,63,252,48,48,63,252,
  // 0x8a2d  設
  45,138,30,32,128,32,0,252,12,0,0,0,12,0,0,0,3,0,255,192,3,0,255,192,3,0,192,192,3,0,192,192,255,252,192,192,255,252,192,192,0,0,192,192,0,0,192,192,63,243,0,60,63,243,0,60,0,12,0,0,0,12,0,0,63,243,255,240,63,243,255,240,0,0,192,48,0,0,192,48,63,240,192,48,63,240,192,48,48,48,48,192,48,48,48,192,48,48,51,0,48,48,51,0,48,48,12,0,48,48,12,0,63,240,51,0,63,240,51,0,48,48,192,192,48,48,192,192,0,15,0,60,0,15,0,60,
  // 0x8a66  試
  102,138,30,32,128,32,0,252,12,0,3,0,12,0,3,0,3,0,3,48,3,0,3,48,0,0,3,12,0,0,3,12,255,240,3,0,255,240,3,0,0,15,255,252,0,15,255,252,63,192,3,0,63,192,3,0,0,0,3,0,0,0,3,0,63,195,243,0,63,195,243,0,0,0,195,0,0,0,195,0,63,192,195,0,63,192,195,0,48,192,195,0,48,192,195,0,48,192,192,192,48,192,192,192,48,192,252,204,48,192,252,204,63,207,192,204,63,207,192,204,48,192,0,60,48,192,0,60,0,0,0,12,0,0,0,12,
  // 0x8a8d  認
  141,138,30,30,120,32,0,254,12,0,0,0,12,0,0,0,3,15,255,240,3,15,255,240,0,0,48,48,0,0,48,48,255,243,48,48,255,243,48,48,0,3,48,48,0,3,48,48,63,204,192,48,63,204,192,48,0,0,195,48,0,0,195,48,63,195,0,192,63,195,0,192,0,12,48,0,0,12,48,0,63,192,12,0,63,192,12,0,48,192,204,48,48,192,204,48,48,204,192,12,48,204,192,12,48,204,192,204,48,204,192,204,63,204,192,204,63,204,192,204,48,48,63,192,48,48,63,192,
  // 0x8aa4  誤
  164,138,30,32,128,32,0,252,12,0,0,0,12,0,0,0,3,3,255,240,3,3,255,240,0,3,0,48,0,3,0,48,255,243,0,48,255,243,0,48,0,3,255,240,0,3,255,240,63,192,0,0,63,192,0,0,0,0,0,0,0,0,0,0,63,195,255,240,63,195,255,240,0,0,12,0,0,0,12,0,63,192,12,0,63,192,12,0,48,207,255,252,48,207,255,252,48,192,12,0,48,192,12,0,48,192,51,0,48,192,51,0,63,192,192,192,63,192,192,192,48,195,0,48,48,195,0,48,0,12,0,12,0,12,0,12,
  // 0x8abf  調
  191,138,28,32,128,32,0,252,12,0,0,0,12,0,0,0,3,3,255,240,3,3,255,240,0,3,12,48,0,3,12,48,255,243,12,48,255,243,12,48,0,3,63,48,0,3,63,48,63,195,12,48,63,195,12,48,0,3,255,240,0,3,255,240,63,195,0,48,63,195,0,48,0,3,63,48,0,3,63,48,63,195,51,48,63,195,51,48,48,195,51,48,48,195,51,48,48,195,63,48,48,195,63,48,48,195,0,48,48,195,0,48,63,204,0,48,63,204,0,48,48,204,3,48,48,204,3,48,0,48,0,192,0,48,0,192,
  // 0x8acb  請
  203,138,30,32,128,32,0,252,12,0,12,0,12,0,12,0,3,0,12,0,3,0,12,0,0,15,255,252,0,15,255,252,255,240,12,0,255,240,12,0,0,3,255,240,0,3,255,240,63,192,12,0,63,192,12,0,0,15,255,252,0,15,255,252,63,192,0,0,63,192,0,0,0,3,255,240,0,3,255,240,63,195,0,48,63,195,0,48,48,195,255,240,48,195,255,240,48,195,0,48,48,195,0,48,48,195,255,240,48,195,255,240,63,195,0,48,63,195,0,48,48,195,3,48,48,195,3,48,0,3,0,192,0,3,0,192,
  // 0x8b70  議
  112,139,30,32,128,32,0,252,12,3,0,48,12,3,0,48,3,0,192,192,3,0,192,192,0,15,255,252,0,15,255,252,255,240,12,0,255,240,12,0,0,3,255,240,0,3,255,240,63,192,12,0,63,192,12,0,0,15,255,252,0,15,255,252,63,192,51,48,63,192,51,48,0,3,195,12,0,3,195,12,63,192,195,0,63,192,195,0,48,207,255,252,48,207,255,252,48,192,195,0,48,192,195,0,48,192,243,48,48,192,243,48,63,207,192,204,63,207,192,204,48,192,195,60,48,192,195,60,0,3,204,12,0,3,204,12,
  // 0x8b80  讀
  128,139,30,32,128,32,0,252,12,0,12,0,12,0,12,0,3,15,255,252,3,15,255,252,0,0,12,0,0,0,12,0,255,243,255,240,255,243,255,240,0,0,0,0,0,0,0,0,63,207,255,252,63,207,255,252,0,12,51,12,0,12,51,12,63,207,255,252,63,207,255,252,0,3,0,48,0,3,0,48,63,195,255,240,63,195,255,240,48,195,0,48,48,195,0,48,48,195,255,240,48,195,255,240,48,195,0,48,48,195,0,48,63,195,255,240,63,195,255,240,48,192,192,192,48,192,192,192,0,3,0,48,0,3,0,48,
  // 0x8b8a  變
  138,139,30,32,128,32,0,252,12,3,0,48,12,3,0,48,48,63,240,192,48,63,240,192,192,192,3,12,192,192,3,12,255,15,207,240,255,15,207,240,12,0,0,192,12,0,0,192,48,207,195,12,48,207,195,12,255,192,15,252,255,192,15,252,0,15,192,0,0,15,192,0,204,204,204,204,204,204,204,204,204,207,204,204,204,207,204,204,0,192,0,0,0,192,0,0,3,255,255,192,3,255,255,192,12,192,12,0,12,192,12,0,0,63,240,0,0,63,240,0,3,192,15,0,3,192,15,0,252,0,0,252,252,0,0,252,
  // 0x8cc7  資
  199,140,30,32,128,32,0,252,48,3,0,0,48,3,0,0,12,3,255,240,12,3,255,240,0,204,48,48,0,204,48,48,3,0,48,192,3,0,48,192,252,0,204,0,252,0,204,0,12,3,3,192,12,3,3,192,12,60,0,60,12,60,0,60,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,
  // 0x8ddd  距
  221,141,30,28,112,32,0,254,63,243,255,252,63,243,255,252,48,51,0,0,48,51,0,0,48,51,0,0,48,51,0,0,48,51,0,0,48,51,0,0,63,243,255,240,63,243,255,240,3,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,51,243,0,48,51,243,0,48,51,3,0,48,51,3,0,48,51,3,255,240,51,3,255,240,51,3,0,0,51,3,0,0,51,243,0,0,51,243,0,0,252,3,0,0,252,3,0,0,0,3,255,252,0,3,255,252,
  // 0x8eca  車
  202,142,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x8edf  軟
  223,142,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,255,252,63,240,255,252,63,240,3,0,192,48,3,0,192,48,63,240,192,192,63,240,192,192,51,51,12,0,51,51,12,0,63,240,12,0,63,240,12,0,51,48,12,0,51,48,12,0,63,240,51,0,63,240,51,0,3,0,51,0,3,0,51,0,255,252,51,0,255,252,51,0,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,3,0,48,3,3,0,48,3,12,0,12,3,12,0,12,
  // 0x8ef8  軸
  248,142,28,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,255,252,12,0,255,252,12,0,3,3,255,240,3,3,255,240,63,243,12,48,63,243,12,48,51,51,12,48,51,51,12,48,63,243,12,48,63,243,12,48,51,51,12,48,51,51,12,48,63,243,255,240,63,243,255,240,3,3,12,48,3,3,12,48,255,255,12,48,255,255,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,255,240,3,3,255,240,3,3,0,48,3,3,0,48,
  // 0x8f09  載
  9,143,30,32,128,32,0,252,0,192,12,0,0,192,12,0,63,255,12,192,63,255,12,192,0,192,12,48,0,192,12,48,255,255,255,252,255,255,255,252,0,192,12,0,0,192,12,0,255,255,204,0,255,255,204,0,0,192,12,48,0,192,12,48,63,255,12,48,63,255,12,48,48,195,12,48,48,195,12,48,63,255,12,192,63,255,12,192,48,195,12,192,48,195,12,192,63,255,3,0,63,255,3,0,0,192,3,12,0,192,3,12,255,255,204,204,255,255,204,204,0,192,48,60,0,192,48,60,0,192,192,12,0,192,192,12,
  // 0x8f2f  輯
  47,143,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,255,192,3,0,255,192,3,0,192,192,3,0,192,192,255,252,192,192,255,252,192,192,3,0,255,192,3,0,255,192,63,240,0,0,63,240,0,0,51,51,255,252,51,51,255,252,63,240,192,192,63,240,192,192,51,48,255,192,51,48,255,192,63,240,192,192,63,240,192,192,3,0,255,192,3,0,255,192,255,252,192,192,255,252,192,192,3,0,195,252,3,0,195,252,3,15,252,192,3,15,252,192,3,0,0,192,3,0,0,192,3,0,0,192,3,0,0,192,
  // 0x8f38  輸
  56,143,30,32,128,32,0,252,12,0,48,0,12,0,48,0,12,0,204,0,12,0,204,0,12,3,3,0,12,3,3,0,255,204,0,192,255,204,0,192,12,51,255,60,12,51,255,60,255,192,0,0,255,192,0,0,204,207,240,48,204,207,240,48,255,204,51,48,255,204,51,48,204,204,51,48,204,204,51,48,255,207,243,48,255,207,243,48,12,12,51,48,12,12,51,48,255,204,51,48,255,204,51,48,12,15,243,48,12,15,243,48,12,12,48,48,12,12,48,48,12,12,51,48,12,12,51,48,12,12,240,192,12,12,240,192,
  // 0x8f49  轉
  73,143,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,15,255,252,3,15,255,252,3,0,12,0,3,0,12,0,255,243,255,240,255,243,255,240,3,3,12,48,3,3,12,48,63,243,255,240,63,243,255,240,51,51,12,48,51,51,12,48,63,243,255,240,63,243,255,240,51,48,12,12,51,48,12,12,63,243,255,252,63,243,255,252,3,0,0,192,3,0,0,192,255,243,255,252,255,243,255,252,3,3,0,192,3,3,0,192,3,0,192,192,3,0,192,192,3,0,12,192,3,0,12,192,3,0,3,0,3,0,3,0,
  // 0x8fd1  近
  209,143,30,30,120,32,0,254,0,0,0,192,0,0,0,192,12,0,3,240,12,0,3,240,3,3,252,0,3,3,252,0,3,3,0,0,3,3,0,0,0,3,0,0,0,3,0,0,0,3,255,252,0,3,255,252,255,3,3,0,255,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,12,3,0,3,12,3,0,3,12,3,0,3,12,3,0,3,48,3,0,3,48,3,0,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x8fd4  返
  212,143,30,30,120,32,0,254,0,0,0,192,0,0,0,192,12,0,15,240,12,0,15,240,3,15,240,0,3,15,240,0,3,12,0,0,3,12,0,0,0,12,0,0,0,12,0,0,0,15,255,240,0,15,255,240,255,12,0,48,255,12,0,48,3,12,192,192,3,12,192,192,3,12,51,0,3,12,51,0,3,12,12,0,3,12,12,0,3,12,51,0,3,12,51,0,3,48,192,192,3,48,192,192,3,51,0,48,3,51,0,48,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x9000  退
  0,144,30,30,120,32,0,254,0,15,255,192,0,15,255,192,12,12,0,192,12,12,0,192,3,12,0,192,3,12,0,192,3,15,255,192,3,15,255,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,255,15,255,192,255,15,255,192,3,12,48,48,3,12,48,48,3,12,12,192,3,12,12,192,3,12,3,0,3,12,3,0,3,12,192,192,3,12,192,192,3,15,0,48,3,15,0,48,3,12,0,48,3,12,0,48,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x901f  速
  31,144,30,30,120,32,0,254,0,0,48,0,0,0,48,0,12,0,48,0,12,0,48,0,3,63,255,240,3,63,255,240,3,0,48,0,3,0,48,0,0,15,255,192,0,15,255,192,0,12,48,192,0,12,48,192,255,12,48,192,255,12,48,192,3,15,255,192,3,15,255,192,3,0,252,0,3,0,252,0,3,3,51,0,3,3,51,0,3,12,48,192,3,12,48,192,3,48,48,48,3,48,48,48,3,0,48,0,3,0,48,0,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x9023  連
  35,144,30,30,120,32,0,254,0,0,48,0,0,0,48,0,48,0,48,0,48,0,48,0,12,255,255,252,12,255,255,252,12,0,48,0,12,0,48,0,0,63,255,240,0,63,255,240,0,48,48,48,0,48,48,48,252,63,255,240,252,63,255,240,12,48,48,48,12,48,48,48,12,63,255,240,12,63,255,240,12,0,48,0,12,0,48,0,12,255,255,252,12,255,255,252,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,51,0,48,0,51,0,48,0,192,255,255,252,192,255,255,252,
  // 0x9032  進
  50,144,30,30,120,32,0,254,0,3,48,0,0,3,48,0,12,3,12,0,12,3,12,0,3,15,255,252,3,15,255,252,3,12,12,0,3,12,12,0,0,60,12,0,0,60,12,0,0,207,255,240,0,207,255,240,255,12,12,0,255,12,12,0,3,12,12,0,3,12,12,0,3,15,255,240,3,15,255,240,3,12,12,0,3,12,12,0,3,12,12,0,3,12,12,0,3,15,255,252,3,15,255,252,3,12,0,0,3,12,0,0,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x904b  運
  75,144,30,28,112,32,0,254,12,63,255,240,12,63,255,240,3,48,48,48,3,48,48,48,3,15,255,192,3,15,255,192,0,0,48,0,0,0,48,0,0,15,255,192,0,15,255,192,255,12,48,192,255,12,48,192,3,15,255,192,3,15,255,192,3,12,48,192,3,12,48,192,3,15,255,192,3,15,255,192,3,0,48,0,3,0,48,0,3,63,255,240,3,63,255,240,3,0,48,0,3,0,48,0,12,192,48,0,12,192,48,0,48,63,255,252,48,63,255,252,
  // 0x9054  達
  84,144,30,30,120,32,0,254,0,0,48,0,0,0,48,0,12,0,48,0,12,0,48,0,3,15,255,192,3,15,255,192,3,0,48,0,3,0,48,0,0,63,255,240,0,63,255,240,0,3,3,0,0,3,3,0,255,0,204,0,255,0,204,0,3,63,255,240,3,63,255,240,3,0,48,0,3,0,48,0,3,15,255,192,3,15,255,192,3,0,48,0,3,0,48,0,3,63,255,240,3,63,255,240,3,0,48,0,3,0,48,0,12,192,48,0,12,192,48,0,48,63,255,252,48,63,255,252,
  // 0x9078  選
  120,144,30,30,120,32,0,254,0,255,15,240,0,255,15,240,48,195,12,48,48,195,12,48,12,255,15,240,12,255,15,240,12,192,204,12,12,192,204,12,0,63,195,252,0,63,195,252,0,3,3,0,0,3,3,0,252,63,255,240,252,63,255,240,12,3,3,0,12,3,3,0,12,3,3,0,12,3,3,0,12,255,255,252,12,255,255,252,12,3,3,0,12,3,3,0,12,12,0,192,12,12,0,192,12,48,0,48,12,48,0,48,51,0,0,0,51,0,0,0,192,255,255,252,192,255,255,252,
  // 0x9084  還
  132,144,30,28,112,32,0,254,48,63,255,240,48,63,255,240,12,48,204,48,12,48,204,48,12,63,255,240,12,63,255,240,0,0,0,0,0,0,0,0,0,255,255,252,0,255,255,252,252,0,0,0,252,0,0,0,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,15,255,192,12,15,255,192,12,3,48,48,12,3,48,48,12,15,12,192,12,15,12,192,12,243,195,0,12,243,195,0,51,3,0,192,51,3,0,192,192,255,255,252,192,255,255,252,
  // 0x908a  邊
  138,144,30,32,128,32,0,252,0,0,192,0,0,0,192,0,48,63,255,192,48,63,255,192,12,51,48,192,12,51,48,192,12,48,204,192,12,48,204,192,0,63,255,192,0,63,255,192,0,0,48,0,0,0,48,0,252,255,255,240,252,255,255,240,12,204,3,48,12,204,3,48,12,48,192,192,12,48,192,192,12,207,255,48,12,207,255,48,12,3,0,0,12,3,0,0,12,3,255,0,12,3,255,0,12,12,3,0,12,12,3,0,12,48,15,0,12,48,15,0,51,0,0,0,51,0,0,0,192,255,255,252,192,255,255,252,
  // 0x90e8  部
  232,144,30,32,128,32,0,252,3,0,0,0,3,0,0,0,0,192,15,252,0,192,15,252,63,255,204,12,63,255,204,12,0,0,12,48,0,0,12,48,12,3,12,48,12,3,12,48,3,12,12,192,3,12,12,192,255,255,252,48,255,255,252,48,0,0,12,48,0,0,12,48,0,0,12,12,0,0,12,12,15,255,12,12,15,255,12,12,12,3,12,12,12,3,12,12,12,3,15,48,12,3,15,48,12,3,12,192,12,3,12,192,15,255,12,0,15,255,12,0,12,3,12,0,12,3,12,0,0,0,12,0,0,0,12,0,
  // 0x91cb  釋
  203,145,30,32,128,32,0,252,0,240,0,0,0,240,0,0,255,3,255,240,255,3,255,240,3,3,51,48,3,3,51,48,51,51,255,240,51,51,255,240,15,192,12,0,15,192,12,0,3,3,255,240,3,3,255,240,255,240,12,0,255,240,12,0,3,15,255,252,3,15,255,252,15,0,192,192,15,0,192,192,15,192,51,0,15,192,51,0,51,51,255,240,51,51,255,240,51,0,12,0,51,0,12,0,195,15,255,252,195,15,255,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,
  // 0x91cd  重
  205,145,30,30,120,32,0,254,0,0,3,0,0,0,3,0,0,0,255,192,0,0,255,192,15,255,0,0,15,255,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,
  // 0x91cf  量
  207,145,30,30,120,32,0,252,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,255,255,255,252,255,255,255,252,0,0,0,0,0,0,0,0,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,0,3,0,0,0,3,0,0,3,255,255,0,3,255,255,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,
  // 0x91dd  針
  221,145,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,12,192,12,0,12,192,12,0,12,48,12,0,12,48,12,0,48,12,12,0,48,12,12,0,207,240,12,0,207,240,12,0,3,15,255,252,3,15,255,252,3,0,12,0,3,0,12,0,255,252,12,0,255,252,12,0,3,0,12,0,3,0,12,0,195,48,12,0,195,48,12,0,51,192,12,0,51,192,12,0,51,0,12,0,51,0,12,0,3,252,12,0,3,252,12,0,255,0,12,0,255,0,12,0,48,0,12,0,48,0,12,0,
  // 0x9215  鈕
  21,146,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,3,255,192,3,3,255,192,12,192,48,192,12,192,48,192,12,48,48,192,12,48,48,192,48,0,48,192,48,0,48,192,207,192,48,192,207,192,48,192,3,0,48,192,3,0,48,192,3,3,255,192,3,3,255,192,255,240,192,192,255,240,192,192,3,0,192,192,3,0,192,192,195,48,192,192,195,48,192,192,51,192,192,192,51,192,192,192,51,0,192,192,51,0,192,192,3,240,192,192,3,240,192,192,252,15,255,252,252,15,255,252,48,0,0,0,48,0,0,0,
  // 0x932f  錯
  47,147,30,32,128,32,0,252,3,0,48,192,3,0,48,192,3,0,48,192,3,0,48,192,12,192,48,192,12,192,48,192,12,51,255,252,12,51,255,252,48,12,48,192,48,12,48,192,207,240,48,192,207,240,48,192,3,3,255,252,3,3,255,252,3,0,0,0,3,0,0,0,255,252,255,240,255,252,255,240,3,0,192,48,3,0,192,48,195,48,192,48,195,48,192,48,51,192,255,240,51,192,255,240,51,0,192,48,51,0,192,48,3,252,192,48,3,252,192,48,255,0,255,240,255,0,255,240,48,0,192,48,48,0,192,48,
  // 0x9375  鍵
  117,147,30,30,120,32,0,254,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,51,63,63,240,51,63,63,240,48,195,3,48,48,195,3,48,192,3,255,252,192,3,255,252,63,12,3,48,63,12,3,48,12,12,63,240,12,12,63,240,12,63,3,0,12,63,3,0,255,3,63,240,255,3,63,240,12,51,3,0,12,51,3,0,204,51,255,252,204,51,255,252,63,12,3,0,63,12,3,0,12,12,3,0,12,12,3,0,15,51,0,0,15,51,0,0,240,192,255,252,240,192,255,252,
  // 0x9577  長
  119,149,30,30,120,32,0,252,0,255,255,192,0,255,255,192,0,192,0,0,0,192,0,0,0,255,255,0,0,255,255,0,0,192,0,0,0,192,0,0,0,255,255,0,0,255,255,0,0,192,0,0,0,192,0,0,255,255,255,252,255,255,255,252,3,12,0,0,3,12,0,0,3,3,3,0,3,3,3,0,3,0,204,0,3,0,204,0,3,0,48,0,3,0,48,0,3,12,12,0,3,12,12,0,3,48,3,192,3,48,3,192,3,192,0,60,3,192,0,60,3,0,0,0,3,0,0,0,
  // 0x9589  閉
  137,149,26,30,120,32,2,252,255,192,255,192,255,192,255,192,192,192,192,192,192,192,192,192,255,192,255,192,255,192,255,192,192,192,192,192,192,192,192,192,255,192,255,192,255,192,255,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,195,255,252,192,195,255,252,192,192,15,0,192,192,15,0,192,192,51,0,192,192,51,0,192,192,195,0,192,192,195,0,192,195,3,0,192,195,3,0,192,192,51,0,192,192,51,0,192,192,12,12,192,192,12,12,192,192,0,3,0,192,0,3,0,
  // 0x958b  開
  139,149,24,30,90,32,2,252,255,195,255,255,195,255,192,195,3,192,195,3,255,195,255,255,195,255,192,195,3,192,195,3,255,195,255,255,195,255,192,0,3,192,0,3,195,255,195,195,255,195,192,195,3,192,195,3,192,195,3,192,195,3,207,255,243,207,255,243,192,195,3,192,195,3,192,195,3,192,195,3,195,3,3,195,3,3,204,3,51,204,3,51,192,0,12,192,0,12,
  // 0x9593  間
  147,149,24,30,90,32,2,252,255,195,255,255,195,255,192,195,3,192,195,3,255,195,255,255,195,255,192,195,3,192,195,3,255,195,255,255,195,255,192,0,3,192,0,3,195,255,195,195,255,195,195,0,195,195,0,195,195,255,195,195,255,195,195,0,195,195,0,195,195,255,195,195,255,195,195,0,195,195,0,195,192,0,3,192,0,3,192,0,51,192,0,51,192,0,12,192,0,12,
  // 0x95dc  關
  220,149,26,32,128,32,2,252,255,192,255,192,255,192,255,192,192,192,192,192,192,192,192,192,255,192,255,192,255,192,255,192,192,192,192,192,192,192,192,192,255,192,255,192,255,192,255,192,195,0,192,192,195,0,192,192,204,51,12,192,204,51,12,192,207,195,240,192,207,195,240,192,195,48,204,192,195,48,204,192,207,243,252,192,207,243,252,192,192,51,0,192,192,51,0,192,204,51,12,192,204,51,12,192,207,243,252,192,207,243,252,192,192,51,0,192,192,51,0,192,192,195,12,192,192,195,12,192,195,3,3,0,195,3,3,0,
  // 0x964d  降
  77,150,28,32,128,32,2,252,0,3,0,0,0,3,0,0,255,195,0,0,255,195,0,0,192,195,255,192,192,195,255,192,195,12,3,0,195,12,3,0,195,51,12,0,195,51,12,0,204,0,240,0,204,0,240,0,195,15,15,0,195,15,15,0,195,240,48,240,195,240,48,240,192,192,48,0,192,192,48,0,192,207,255,192,192,207,255,192,192,192,48,0,192,192,48,0,243,48,48,0,243,48,48,0,204,63,255,240,204,63,255,240,192,0,48,0,192,0,48,0,192,0,48,0,192,0,48,0,192,0,48,0,192,0,48,0,
  // 0x9664  除
  100,150,28,30,120,32,2,252,255,0,192,0,255,0,192,0,195,0,192,0,195,0,192,0,204,3,48,0,204,3,48,0,204,12,12,0,204,12,12,0,240,48,3,0,240,48,3,0,204,207,252,240,204,207,252,240,195,0,192,0,195,0,192,0,195,0,192,0,195,0,192,0,195,63,255,192,195,63,255,192,243,0,192,0,243,0,192,0,204,12,204,0,204,12,204,0,192,48,195,0,192,48,195,0,192,192,192,192,192,192,192,192,192,12,192,192,192,12,192,192,192,3,0,0,192,3,0,0,
  // 0x968e  階
  142,150,28,32,128,32,2,252,0,12,12,0,0,12,12,0,255,204,12,48,255,204,12,48,192,207,204,192,192,207,204,192,195,12,15,0,195,12,15,0,195,12,204,48,195,12,204,48,204,15,12,48,204,15,12,48,195,12,51,240,195,12,51,240,195,0,192,0,195,0,192,0,192,207,255,192,192,207,255,192,192,204,0,192,192,204,0,192,192,204,0,192,192,204,0,192,243,15,255,192,243,15,255,192,204,12,0,192,204,12,0,192,192,12,0,192,192,12,0,192,192,15,255,192,192,15,255,192,192,12,0,192,192,12,0,192,
  // 0x96d9  雙
  217,150,30,32,128,32,0,252,0,192,3,0,0,192,3,0,12,48,48,192,12,48,48,192,15,255,63,252,15,255,63,252,60,48,240,192,60,48,240,192,207,255,63,252,207,255,63,252,12,48,48,192,12,48,48,192,15,255,63,252,15,255,63,252,12,48,48,192,12,48,48,192,15,255,63,252,15,255,63,252,12,0,48,0,12,0,48,0,3,255,255,0,3,255,255,0,0,192,12,0,0,192,12,0,0,48,48,0,0,48,48,0,0,15,192,0,0,15,192,0,3,240,63,0,3,240,63,0,252,0,0,252,252,0,0,252,
  // 0x96e2  離
  226,150,28,32,128,32,2,252,12,0,51,0,12,0,51,0,3,0,48,192,3,0,48,192,255,252,192,0,255,252,192,0,12,192,255,240,12,192,255,240,195,15,195,0,195,15,195,0,204,204,195,0,204,204,195,0,192,12,255,240,192,12,255,240,255,252,195,0,255,252,195,0,3,0,195,0,3,0,195,0,255,252,255,240,255,252,255,240,204,12,195,0,204,12,195,0,204,204,195,0,204,204,195,0,207,204,195,0,207,204,195,0,192,12,255,240,192,12,255,240,192,204,192,0,192,204,192,0,192,48,192,0,192,48,192,0,
  // 0x96fb  電
  251,150,30,32,128,32,0,252,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,3,0,12,48,3,0,12,195,243,63,48,195,243,63,48,0,3,0,0,0,3,0,0,3,243,63,0,3,243,63,0,0,0,0,0,0,0,0,0,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,0,255,252,0,0,255,252,
  // 0x9752  青
  82,151,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,0,0,0,0,0,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,51,0,3,0,51,0,3,0,12,0,3,0,12,0,
  // 0x975e  非
  94,151,30,32,128,32,0,252,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,255,240,63,252,255,240,63,252,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,63,240,63,240,63,240,63,240,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,255,240,63,252,255,240,63,252,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,
  // 0x9762  面
  98,151,30,30,120,32,0,252,255,255,255,252,255,255,255,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,15,255,255,192,15,255,255,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,63,240,192,12,63,240,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,63,240,192,12,63,240,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,15,255,255,192,15,255,255,192,12,0,0,192,12,0,0,192,
  // 0x9805  項
  5,152,30,30,120,32,0,252,0,3,255,252,0,3,255,252,0,0,12,0,0,0,12,0,255,240,48,0,255,240,48,0,3,3,255,240,3,3,255,240,3,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,3,3,255,240,3,3,255,240,3,3,0,48,3,3,0,48,3,3,255,240,3,3,255,240,3,3,0,48,3,3,0,48,3,243,0,48,3,243,0,48,252,3,255,240,252,3,255,240,48,0,192,192,48,0,192,192,0,3,0,48,0,3,0,48,0,12,0,12,0,12,0,12,
  // 0x9810  預
  16,152,30,30,120,32,0,252,63,240,255,252,63,240,255,252,0,48,3,0,0,48,3,0,12,192,12,0,12,192,12,0,3,0,255,240,3,0,255,240,0,192,192,48,0,192,192,48,255,252,192,48,255,252,192,48,3,12,255,240,3,12,255,240,3,48,192,48,3,48,192,48,3,0,255,240,3,0,255,240,3,0,192,48,3,0,192,48,3,0,192,48,3,0,192,48,3,0,255,240,3,0,255,240,3,0,48,192,3,0,48,192,51,0,192,48,51,0,192,48,12,3,0,12,12,3,0,12,
  // 0x984d  額
  77,152,30,32,128,32,0,252,12,0,0,0,12,0,0,0,3,0,255,252,3,0,255,252,255,252,3,0,255,252,3,0,192,12,12,0,192,12,12,0,12,0,255,240,12,0,255,240,15,240,192,48,15,240,192,48,48,48,192,48,48,48,192,48,204,192,255,240,204,192,255,240,3,0,192,48,3,0,192,48,12,192,255,240,12,192,255,240,48,48,192,48,48,48,192,48,255,252,192,48,255,252,192,48,48,48,255,240,48,48,255,240,48,48,48,192,48,48,48,192,63,240,192,48,63,240,192,48,48,51,0,12,48,51,0,12,
  // 0x985e  類
  94,152,30,32,128,32,0,252,3,0,0,0,3,0,0,0,195,12,255,252,195,12,255,252,51,48,3,0,51,48,3,0,255,252,12,0,255,252,12,0,15,0,255,240,15,0,255,240,51,48,192,48,51,48,192,48,195,12,192,48,195,12,192,48,0,0,255,240,0,0,255,240,3,48,192,48,3,48,192,48,3,12,255,240,3,12,255,240,255,252,192,48,255,252,192,48,3,0,192,48,3,0,192,48,12,192,255,240,12,192,255,240,12,48,48,192,12,48,48,192,48,48,192,48,48,48,192,48,192,3,0,12,192,3,0,12,
  // 0x98a8  風
  168,152,30,30,120,32,0,252,15,255,255,192,15,255,255,192,12,0,0,192,12,0,0,192,12,0,252,192,12,0,252,192,12,255,0,192,12,255,0,192,12,3,0,192,12,3,0,192,12,255,252,192,12,255,252,192,12,195,12,192,12,195,12,192,12,195,12,192,12,195,12,192,12,255,252,192,12,255,252,192,12,195,0,192,12,195,0,192,12,3,48,204,12,3,48,204,12,3,252,204,12,3,252,204,51,252,12,204,51,252,12,204,48,192,0,60,48,192,0,60,192,0,0,12,192,0,0,12,
  // 0x98fd  飽
  253,152,30,32,128,32,0,252,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,48,255,240,3,48,255,240,3,12,192,48,3,12,192,48,12,195,0,48,12,195,0,48,63,252,255,48,63,252,255,48,204,12,195,48,204,12,195,48,15,252,195,48,15,252,195,48,12,12,255,48,12,12,255,48,15,252,192,48,15,252,192,48,12,0,195,48,12,0,195,48,12,192,192,192,12,192,192,192,12,48,192,12,12,48,192,12,12,204,192,12,12,204,192,12,15,12,63,252,15,12,63,252,12,0,0,0,12,0,0,0,
  // 0x9918  餘
  24,153,30,32,128,32,0,252,0,192,3,0,0,192,3,0,0,192,3,0,0,192,3,0,3,48,12,192,3,48,12,192,3,12,12,192,3,12,12,192,12,195,48,48,12,195,48,48,63,252,207,204,63,252,207,204,204,12,3,0,204,12,3,0,15,252,3,0,15,252,3,0,12,12,255,252,12,12,255,252,15,252,3,0,15,252,3,0,12,0,51,192,12,0,51,192,12,192,51,48,12,192,51,48,12,48,195,12,12,48,195,12,12,207,3,12,12,207,3,12,15,12,51,0,15,12,51,0,12,0,12,0,12,0,12,0,
  // 0x99ac  馬
  172,153,26,30,120,32,0,252,15,255,255,192,15,255,255,192,12,3,0,0,12,3,0,0,15,255,255,0,15,255,255,0,12,3,0,0,12,3,0,0,15,255,255,0,15,255,255,0,12,3,0,0,12,3,0,0,12,3,0,0,12,3,0,0,15,255,255,192,15,255,255,192,0,0,0,192,0,0,0,192,3,12,48,192,3,12,48,192,48,195,12,192,48,195,12,192,48,195,12,192,48,195,12,192,192,0,0,192,192,0,0,192,0,0,51,0,0,0,51,0,0,0,12,0,0,0,12,0,
  // 0x9a45  驅
  69,154,30,30,120,32,0,252,255,207,255,252,255,207,255,252,204,12,0,0,204,12,0,0,255,204,63,240,255,204,63,240,204,12,48,48,204,12,48,48,255,204,48,48,255,204,48,48,204,12,63,240,204,12,63,240,204,12,0,0,204,12,0,0,255,204,252,252,255,204,252,252,0,204,204,204,0,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,252,252,204,204,252,252,192,204,0,0,192,204,0,0,0,207,255,252,0,207,255,252,15,0,0,0,15,0,0,0,
  // 0x9ad4  體
  212,154,30,32,128,32,0,252,0,0,51,0,0,0,51,0,63,243,255,240,63,243,255,240,48,51,51,48,48,51,51,48,63,51,255,240,63,51,255,240,51,51,51,48,51,51,51,48,255,255,255,240,255,255,255,240,192,12,0,0,192,12,0,0,63,243,255,240,63,243,255,240,48,48,0,0,48,48,0,0,63,243,255,240,63,243,255,240,48,51,0,48,48,51,0,48,63,243,255,240,63,243,255,240,48,48,192,192,48,48,192,192,48,48,51,0,48,48,51,0,51,63,255,252,51,63,255,252,48,192,0,0,48,192,0,0,
  // 0x9ad8  高
  216,154,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,0,0,0,0,0,0,0,0,255,252,0,0,255,252,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,255,252,0,0,255,252,0,0,0,0,0,0,0,0,0,63,255,255,240,63,255,255,240,48,0,0,48,48,0,0,48,48,255,252,48,48,255,252,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,255,252,48,48,255,252,48,48,0,0,240,48,0,0,240,
  // 0x9ec3  黃
  195,158,30,32,128,32,0,252,0,192,12,0,0,192,12,0,63,255,255,240,63,255,255,240,0,192,12,0,0,192,12,0,0,255,252,0,0,255,252,0,0,0,0,0,0,0,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,
  // 0x9ede  點
  222,158,30,32,128,32,0,252,0,0,3,0,0,0,3,0,255,252,3,0,255,252,3,0,195,12,3,0,195,12,3,0,243,60,3,0,243,60,3,0,207,204,3,252,207,204,3,252,195,12,3,0,195,12,3,0,255,252,3,0,255,252,3,0,3,0,3,0,3,0,3,0,255,252,255,252,255,252,255,252,3,0,192,12,3,0,192,12,3,252,192,12,3,252,192,12,252,0,192,12,252,0,192,12,0,12,192,12,0,12,192,12,204,204,192,12,204,204,192,12,204,192,255,252,204,192,255,252,192,0,192,12,192,0,192,12,
  // 0x9f4a  齊
  74,159,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,48,48,0,0,48,48,0,0,12,192,240,0,12,192,240,63,243,63,0,63,243,63,0,12,51,51,0,12,51,51,0,12,51,51,0,12,51,51,0,48,51,48,192,48,51,48,192,192,243,60,60,192,243,60,60,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,12,0,3,0,12,0,3,0,
  // 0xff1a  ：
  26,255,8,14,14,32,12,2,255,255,255,255,0,0,0,0,0,0,255,255,255,255,
};

#endif // HAS_GRAPHICAL_TFT
