/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Simplified Chinese 32pt, capital 'A' height: 20px, width: 100%, range: 0x201c-0xff1a, glyphs: 373
extern const uint8_t Unifont_Simplified_Chinese_20[48888] = {
  161,20,28,32,26,255,28,252, // unifont_t
  // 0x201c  “
  28,32,12,8,16,16,2,16,48,48,48,48,192,192,192,192,192,192,192,192,240,240,240,240,
  // 0x201d  ”
  29,32,12,8,16,16,2,16,240,240,240,240,48,48,48,48,48,48,48,48,192,192,192,192,
  // 0x22bf  ⊿
  191,34,12,12,24,16,2,0,0,48,0,48,0,240,0,240,3,48,3,48,12,48,12,48,48,48,48,48,255,240,255,240,
  // 0x4e00  一
  0,78,30,2,8,32,0,12,255,255,255,252,255,255,255,252,
  // 0x4e09  三
  9,78,30,24,96,32,0,0,63,255,255,240,63,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,192,15,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,252,255,255,255,252,
  // 0x4e0a  上
  10,78,30,30,120,32,0,254,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,15,255,192,0,15,255,192,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,255,255,255,252,255,255,255,252,
  // 0x4e0b  下
  11,78,30,30,120,32,0,252,255,255,255,252,255,255,255,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,48,0,0,12,48,0,0,12,12,0,0,12,12,0,0,12,3,0,0,12,3,0,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,
  // 0x4e0d  不
  13,78,28,30,120,32,0,252,63,255,255,240,63,255,255,240,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,15,48,0,0,15,48,0,0,51,12,0,0,51,12,0,0,195,3,0,0,195,3,0,3,3,0,192,3,3,0,192,12,3,0,48,12,3,0,48,48,3,0,48,48,3,0,48,192,3,0,0,192,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x4e13  专
  19,78,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,255,255,255,252,255,255,255,252,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,0,255,255,0,0,255,255,0,0,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,60,48,0,0,60,48,0,0,3,192,0,0,3,192,0,0,0,48,0,0,0,48,0,0,0,12,0,0,0,12,0,
  // 0x4e1d  丝
  29,78,30,30,120,32,0,254,0,192,3,0,0,192,3,0,0,192,3,0,0,192,3,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,12,12,48,48,12,12,48,48,48,12,192,48,48,12,192,48,63,240,255,192,63,240,255,192,0,48,0,192,0,48,0,192,0,192,3,0,0,192,3,0,3,0,12,0,3,0,12,0,12,0,48,0,12,0,48,0,63,252,255,240,63,252,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,252,255,255,255,252,
  // 0x4e2a  个
  42,78,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,12,3,0,192,12,3,0,192,240,3,0,60,240,3,0,60,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x4e2d  中
  45,78,22,32,96,32,4,252,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,255,255,252,255,255,252,192,48,12,192,48,12,192,48,12,192,48,12,192,48,12,192,48,12,192,48,12,192,48,12,192,48,12,192,48,12,255,255,252,255,255,252,192,48,12,192,48,12,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,
  // 0x4e3a  为
  58,78,26,32,128,32,0,252,0,3,0,0,0,3,0,0,12,3,0,0,12,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,0,3,0,0,0,3,0,0,63,255,255,192,63,255,255,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,192,192,0,12,192,192,0,48,48,192,0,48,48,192,0,48,48,192,0,48,48,192,0,192,0,192,0,192,0,192,3,0,0,192,3,0,0,192,12,0,0,192,12,0,0,192,48,0,51,0,48,0,51,0,192,0,12,0,192,0,12,0,
  // 0x4e3b  主
  59,78,30,30,120,32,0,254,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,
  // 0x4e49  义
  73,78,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,3,0,0,3,3,0,12,3,3,0,12,3,3,0,12,0,3,0,12,0,3,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,0,192,12,0,0,192,12,0,0,192,48,0,0,192,48,0,0,48,48,0,0,48,48,0,0,12,192,0,0,12,192,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,15,0,3,192,15,0,3,192,240,0,0,60,240,0,0,60,
  // 0x4e4b  之
  75,78,28,30,120,32,2,254,0,48,0,0,0,48,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,0,0,0,0,0,0,0,255,255,255,0,255,255,255,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,15,0,0,0,15,0,0,0,48,192,0,0,48,192,0,0,192,63,255,240,192,63,255,240,
  // 0x4e86  了
  134,78,24,30,90,32,2,252,255,255,255,255,255,255,0,0,12,0,0,12,0,0,48,0,0,48,0,0,192,0,0,192,0,15,0,0,15,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,204,0,0,204,0,0,48,0,0,48,0,
  // 0x4e8c  二
  140,78,30,20,80,32,0,2,15,255,255,192,15,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,252,255,255,255,252,
  // 0x4e8e  于
  142,78,30,30,120,32,0,252,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,51,0,0,0,51,0,0,0,12,0,0,0,12,0,0,
  // 0x4ea4  交
  164,78,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,0,0,0,0,0,0,0,3,0,3,0,3,0,3,0,3,0,0,192,3,0,0,192,12,0,12,48,12,0,12,48,48,192,12,48,48,192,12,48,0,48,48,0,0,48,48,0,0,12,192,0,0,12,192,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,240,48,0,0,240,48,0,15,0,15,0,15,0,15,0,240,0,0,252,240,0,0,252,
  // 0x4eae  亮
  174,78,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,0,0,0,0,0,0,0,0,255,252,0,0,255,252,0,0,192,12,0,0,192,12,0,0,255,252,0,0,255,252,0,0,0,0,0,0,0,0,0,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,63,240,48,192,63,240,48,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,48,12,0,192,48,12,15,0,48,12,15,0,48,12,240,0,15,252,240,0,15,252,
  // 0x4ece  从
  206,78,30,32,128,32,0,252,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,51,0,0,192,51,0,3,48,51,0,3,48,51,0,3,12,51,0,3,12,51,0,3,12,192,192,3,12,192,192,12,0,192,192,12,0,192,192,12,3,0,48,12,3,0,48,48,12,0,48,48,12,0,48,192,48,0,12,192,48,0,12,
  // 0x4ee4  令
  228,78,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,204,12,0,0,204,12,0,3,3,3,0,3,3,3,0,12,3,0,192,12,3,0,192,240,0,0,60,240,0,0,60,3,255,255,0,3,255,255,0,0,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,48,48,0,0,48,48,0,0,12,192,0,0,12,192,0,0,3,0,0,0,3,0,0,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,
  // 0x4ee5  以
  229,78,26,32,128,32,4,252,0,0,48,0,0,0,48,0,3,0,48,0,3,0,48,0,192,192,48,0,192,192,48,0,192,48,48,0,192,48,48,0,192,48,48,0,192,48,48,0,192,0,48,0,192,0,48,0,192,0,48,0,192,0,48,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,195,3,0,0,195,3,0,0,204,3,48,0,204,3,48,0,240,12,12,0,240,12,12,0,192,48,3,0,192,48,3,0,0,192,0,192,0,192,0,192,3,0,0,192,3,0,0,192,
  // 0x4ef6  件
  246,78,30,32,128,32,0,252,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,195,12,0,0,195,12,0,3,3,12,0,3,3,12,0,3,3,255,240,3,3,255,240,15,12,12,0,15,12,12,0,15,12,12,0,15,12,12,0,51,48,12,0,51,48,12,0,195,0,12,0,195,0,12,0,3,63,255,252,3,63,255,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,
  // 0x4efd  份
  253,78,30,32,128,32,0,252,0,192,3,0,0,192,3,0,0,192,195,0,0,192,195,0,0,192,195,0,0,192,195,0,3,0,192,192,3,0,192,192,3,3,0,192,3,3,0,192,15,3,0,48,15,3,0,48,15,12,0,48,15,12,0,48,51,51,255,204,51,51,255,204,195,0,192,192,195,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,3,0,192,3,3,0,192,3,3,0,192,3,3,0,192,3,12,12,192,3,12,12,192,3,48,3,0,3,48,3,0,
  // 0x4f11  休
  17,79,30,32,128,32,0,252,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,0,48,0,3,0,48,0,3,63,255,252,3,63,255,252,15,0,48,0,15,0,48,0,15,0,252,0,15,0,252,0,51,0,252,0,51,0,252,0,195,3,51,0,195,3,51,0,3,3,51,0,3,3,51,0,3,12,48,192,3,12,48,192,3,48,48,48,3,48,48,48,3,192,48,12,3,192,48,12,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,
  // 0x4f20  传
  32,79,30,32,128,32,0,252,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,15,255,192,3,15,255,192,3,0,48,0,3,0,48,0,15,0,192,0,15,0,192,0,15,63,255,252,15,63,255,252,51,0,192,0,51,0,192,0,195,3,0,0,195,3,0,0,3,15,255,192,3,15,255,192,3,0,0,192,3,0,0,192,3,3,3,0,3,3,3,0,3,0,204,0,3,0,204,0,3,0,48,0,3,0,48,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,
  // 0x4f4d  位
  77,79,30,32,128,32,0,252,0,192,192,0,0,192,192,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,0,0,0,3,0,0,0,3,63,255,240,3,63,255,240,15,0,0,0,15,0,0,0,15,0,0,192,15,0,0,192,51,12,0,192,51,12,0,192,195,12,0,192,195,12,0,192,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,12,0,3,3,12,0,3,0,12,0,3,0,12,0,3,255,255,252,3,255,255,252,3,0,0,0,3,0,0,0,
  // 0x4f4e  低
  78,79,30,32,128,32,0,252,0,192,0,192,0,192,0,192,0,192,15,240,0,192,15,240,0,207,252,0,0,207,252,0,3,12,12,0,3,12,12,0,3,12,12,0,3,12,12,0,15,12,12,0,15,12,12,0,15,12,12,0,15,12,12,0,51,15,255,252,51,15,255,252,195,12,12,0,195,12,12,0,3,12,3,0,3,12,3,0,3,12,3,0,3,12,3,0,3,12,3,12,3,12,3,12,3,12,0,204,3,12,0,204,3,12,192,204,3,12,192,204,3,15,12,60,3,15,12,60,3,12,3,12,3,12,3,12,
  // 0x4f53  体
  83,79,30,32,128,32,0,252,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,0,48,0,3,0,48,0,3,63,255,240,3,63,255,240,15,0,48,0,15,0,48,0,15,0,252,0,15,0,252,0,51,0,252,0,51,0,252,0,195,3,51,0,195,3,51,0,3,3,51,0,3,3,51,0,3,12,48,192,3,12,48,192,3,51,255,48,3,51,255,48,3,192,48,12,3,192,48,12,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,
  // 0x4f59  余
  89,79,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,12,255,252,192,12,255,252,192,240,3,0,60,240,3,0,60,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,3,3,3,0,3,3,3,0,3,3,0,192,3,3,0,192,12,3,0,48,12,3,0,48,48,51,0,48,48,51,0,48,0,12,0,0,0,12,0,0,
  // 0x4f5c  作
  92,79,30,32,128,32,0,252,0,195,0,0,0,195,0,0,0,195,0,0,0,195,0,0,0,195,0,0,0,195,0,0,3,3,255,252,3,3,255,252,3,12,192,0,3,12,192,0,15,12,192,0,15,12,192,0,15,48,192,0,15,48,192,0,51,0,255,192,51,0,255,192,195,0,192,0,195,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,255,240,3,0,255,240,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,
  // 0x4f7f  使
  127,79,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,255,255,252,3,255,255,252,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,60,63,255,240,60,63,255,240,60,48,48,48,60,48,48,48,204,48,48,48,204,48,48,48,12,63,255,240,12,63,255,240,12,0,48,0,12,0,48,0,12,12,48,0,12,12,48,0,12,3,48,0,12,3,48,0,12,0,192,0,12,0,192,0,12,3,48,0,12,3,48,0,12,12,15,0,12,12,15,0,12,240,0,252,12,240,0,252,
  // 0x4f9b  供
  155,79,30,32,128,32,0,252,0,195,3,0,0,195,3,0,0,195,3,0,0,195,3,0,0,195,3,0,0,195,3,0,3,3,3,0,3,3,3,0,3,15,255,240,3,15,255,240,15,3,3,0,15,3,3,0,15,3,3,0,15,3,3,0,51,3,3,0,51,3,3,0,195,3,3,0,195,3,3,0,3,63,255,252,3,63,255,252,3,0,0,0,3,0,0,0,3,3,3,0,3,3,3,0,3,3,0,192,3,3,0,192,3,12,0,192,3,12,0,192,3,48,0,48,3,48,0,48,3,192,0,48,3,192,0,48,
  // 0x4fb5  侵
  181,79,30,32,128,32,0,252,0,192,0,0,0,192,0,0,0,207,255,192,0,207,255,192,0,192,0,192,0,192,0,192,3,3,255,192,3,3,255,192,3,0,0,192,3,0,0,192,15,15,255,192,15,15,255,192,15,0,0,0,15,0,0,0,51,63,255,240,51,63,255,240,195,48,0,48,195,48,0,48,3,15,255,0,3,15,255,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,0,204,0,3,0,204,0,3,0,48,0,3,0,48,0,3,3,207,0,3,3,207,0,3,60,0,252,3,60,0,252,
  // 0x4fdd  保
  221,79,30,32,128,32,0,252,0,192,0,0,0,192,0,0,0,207,255,192,0,207,255,192,0,204,0,192,0,204,0,192,3,12,0,192,3,12,0,192,3,12,0,192,3,12,0,192,15,15,255,192,15,15,255,192,15,0,48,0,15,0,48,0,51,0,48,0,51,0,48,0,195,63,255,240,195,63,255,240,3,0,252,0,3,0,252,0,3,3,51,0,3,3,51,0,3,12,48,192,3,12,48,192,3,48,48,48,3,48,48,48,3,192,48,12,3,192,48,12,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,
  // 0x4fe1  信
  225,79,30,32,128,32,0,252,0,192,48,0,0,192,48,0,0,192,12,0,0,192,12,0,0,207,255,252,0,207,255,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,15,3,255,240,15,3,255,240,15,0,0,0,15,0,0,0,51,0,0,0,51,0,0,0,195,3,255,240,195,3,255,240,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,3,255,240,3,3,255,240,3,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,3,3,255,240,3,3,255,240,3,3,0,48,3,3,0,48,
  // 0x503c  值
  60,80,30,32,128,32,0,252,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,255,255,240,0,255,255,240,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,15,15,255,192,15,15,255,192,15,12,0,192,15,12,0,192,51,15,255,192,51,15,255,192,195,12,0,192,195,12,0,192,3,15,255,192,3,15,255,192,3,12,0,192,3,12,0,192,3,15,255,192,3,15,255,192,3,12,0,192,3,12,0,192,3,12,0,192,3,12,0,192,3,255,255,252,3,255,255,252,3,0,0,0,3,0,0,0,
  // 0x503e  倾
  62,80,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,255,252,3,0,255,252,3,48,3,0,3,48,3,0,12,48,12,0,12,48,12,0,12,48,63,240,12,48,63,240,60,48,48,48,60,48,48,48,60,63,51,48,60,63,51,48,204,48,51,48,204,48,51,48,12,48,51,48,12,48,51,48,12,48,51,48,12,48,51,48,12,51,51,48,12,51,51,48,12,60,51,48,12,60,51,48,12,48,12,0,12,48,12,0,12,0,12,192,12,0,12,192,12,0,48,48,12,0,48,48,12,0,192,12,12,0,192,12,
  // 0x504f  偏
  79,80,28,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,48,0,3,0,48,0,3,63,255,240,3,63,255,240,12,48,0,48,12,48,0,48,12,48,0,48,12,48,0,48,60,63,255,240,60,63,255,240,60,48,0,0,60,48,0,0,204,48,0,0,204,48,0,0,12,63,255,240,12,63,255,240,12,60,204,48,12,60,204,48,12,204,204,48,12,204,204,48,12,207,255,240,12,207,255,240,12,204,204,48,12,204,204,48,12,204,204,48,12,204,204,48,15,12,204,48,15,12,204,48,12,12,0,240,12,12,0,240,
  // 0x505c  停
  92,80,30,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,48,0,3,0,48,0,3,63,255,240,3,63,255,240,12,0,0,0,12,0,0,0,12,15,255,192,12,15,255,192,60,12,0,192,60,12,0,192,60,15,255,192,60,15,255,192,204,0,0,0,204,0,0,0,12,255,255,252,12,255,255,252,12,192,0,12,12,192,0,12,12,15,255,192,12,15,255,192,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,3,48,0,12,3,48,0,12,0,192,0,12,0,192,0,
  // 0x50a8  储
  168,80,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,192,255,204,3,192,255,204,12,48,12,48,12,48,12,48,12,48,12,192,12,48,12,192,60,3,255,252,60,3,255,252,60,0,12,0,60,0,12,0,207,240,48,0,207,240,48,0,12,48,255,240,12,48,255,240,12,51,48,48,12,51,48,48,12,60,48,48,12,60,48,48,12,48,63,240,12,48,63,240,12,51,48,48,12,51,48,48,12,60,48,48,12,60,48,48,12,48,63,240,12,48,63,240,12,0,48,48,12,0,48,48,
  // 0x50cf  像
  207,80,30,32,128,32,0,252,0,195,0,0,0,195,0,0,0,195,255,0,0,195,255,0,0,204,3,0,0,204,3,0,3,63,255,240,3,63,255,240,3,204,12,48,3,204,12,48,15,12,48,48,15,12,48,48,15,15,255,240,15,15,255,240,51,0,192,0,51,0,192,0,195,3,48,48,195,3,48,48,3,60,204,192,3,60,204,192,3,3,15,0,3,3,15,0,3,60,60,192,3,60,60,192,3,0,204,192,3,0,204,192,3,3,12,48,3,3,12,48,3,60,204,12,3,60,204,12,3,0,48,0,3,0,48,0,
  // 0x5145  充
  69,81,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,15,255,255,192,15,255,255,192,0,48,48,192,0,48,48,192,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,48,48,0,192,48,48,0,192,48,48,0,192,48,48,3,0,48,48,3,0,48,48,60,0,15,240,60,0,15,240,
  // 0x5148  先
  72,81,30,32,128,32,0,252,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,255,255,192,3,255,255,192,12,3,0,0,12,3,0,0,48,3,0,0,48,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,48,0,0,192,48,0,0,192,48,12,0,192,48,12,3,0,48,12,3,0,48,12,12,0,15,252,12,0,15,252,240,0,0,0,240,0,0,0,
  // 0x5149  光
  73,81,30,32,128,32,0,252,0,3,0,0,0,3,0,0,12,3,0,192,12,3,0,192,3,3,0,192,3,3,0,192,0,195,3,0,0,195,3,0,0,195,12,0,0,195,12,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,48,12,0,192,48,12,0,192,48,12,0,192,48,12,3,0,48,12,3,0,48,12,12,0,15,252,12,0,15,252,240,0,0,0,240,0,0,0,
  // 0x5165  入
  101,81,30,32,128,32,0,252,0,48,0,0,0,48,0,0,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,12,192,0,0,12,192,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,12,0,3,0,12,0,3,0,48,0,0,192,48,0,0,192,192,0,0,60,192,0,0,60,
  // 0x5168  全
  104,81,30,30,120,32,0,254,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,12,255,252,192,12,255,252,192,240,3,0,60,240,3,0,60,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,255,255,0,3,255,255,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,
  // 0x5171  共
  113,81,28,32,128,32,2,252,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,63,255,255,192,63,255,255,192,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,255,255,255,240,255,255,255,240,0,0,0,0,0,0,0,0,0,192,48,0,0,192,48,0,3,0,12,0,3,0,12,0,12,0,3,0,12,0,3,0,48,0,0,192,48,0,0,192,
  // 0x5173  关
  115,81,30,32,128,32,0,252,3,0,3,0,3,0,3,0,0,192,3,0,0,192,3,0,0,192,12,0,0,192,12,0,0,0,0,0,0,0,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,15,0,3,192,15,0,3,192,240,0,0,60,240,0,0,60,
  // 0x5177  具
  119,81,30,30,120,32,0,252,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,255,255,255,252,255,255,255,252,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,12,0,0,192,12,0,0,192,
  // 0x5197  冗
  151,81,30,28,112,32,0,252,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,0,0,48,192,0,0,48,0,0,0,0,0,0,0,0,0,255,240,0,0,255,240,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,0,48,12,3,0,48,12,3,0,48,12,3,0,48,12,12,0,48,12,12,0,48,12,48,0,15,252,48,0,15,252,192,0,0,0,192,0,0,0,
  // 0x51b7  冷
  183,81,30,32,128,32,0,252,0,0,48,0,0,0,48,0,48,0,48,0,48,0,48,0,12,0,204,0,12,0,204,0,12,0,204,0,12,0,204,0,0,3,3,0,0,3,3,0,0,12,48,192,0,12,48,192,3,48,12,60,3,48,12,60,3,0,12,0,3,0,12,0,12,15,255,192,12,15,255,192,252,0,0,192,252,0,0,192,12,0,3,0,12,0,3,0,12,3,3,0,12,3,3,0,12,0,204,0,12,0,204,0,12,0,48,0,12,0,48,0,12,0,12,0,12,0,12,0,0,0,12,0,0,0,12,0,
  // 0x51c6  准
  198,81,30,32,128,32,0,252,0,3,48,0,0,3,48,0,48,3,12,0,48,3,12,0,12,3,12,0,12,3,12,0,12,15,255,252,12,15,255,252,0,12,12,0,0,12,12,0,3,60,12,0,3,60,12,0,3,207,255,240,3,207,255,240,3,12,12,0,3,12,12,0,12,12,12,0,12,12,12,0,12,15,255,240,12,15,255,240,252,12,12,0,252,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,12,15,255,252,12,15,255,252,12,12,0,0,12,12,0,0,0,12,0,0,0,12,0,0,
  // 0x51fa  出
  250,81,26,32,128,32,2,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,48,12,3,0,48,12,3,0,48,12,3,0,48,12,3,0,48,12,3,0,48,12,3,0,48,12,3,0,48,12,3,0,63,255,255,0,63,255,255,0,0,12,3,0,0,12,3,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,255,255,255,192,255,255,255,192,0,0,0,192,0,0,0,192,
  // 0x51fb  击
  251,81,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,0,0,0,192,0,0,0,192,
  // 0x5206  分
  6,82,30,32,128,32,0,252,0,0,48,0,0,0,48,0,0,48,48,0,0,48,48,0,0,48,12,0,0,48,12,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,12,0,0,192,12,0,0,192,48,0,0,48,48,0,0,48,195,255,252,12,195,255,252,12,0,48,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,3,0,12,0,3,0,12,0,12,3,48,0,12,3,48,0,48,0,192,0,48,0,192,0,
  // 0x5207  切
  7,82,28,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,3,255,240,3,3,255,240,3,0,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,252,48,48,3,252,48,48,255,0,48,48,255,0,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,12,48,48,3,12,48,48,3,48,48,48,3,48,48,48,3,192,192,48,3,192,192,48,3,0,192,48,3,0,192,48,0,3,0,48,0,3,0,48,0,12,12,192,0,12,12,192,0,48,3,0,0,48,3,0,
  // 0x521b  创
  27,82,28,32,128,32,0,252,0,192,0,48,0,192,0,48,0,192,0,48,0,192,0,48,3,48,0,48,3,48,0,48,3,12,12,48,3,12,12,48,12,3,12,48,12,3,12,48,48,0,204,48,48,0,204,48,207,252,12,48,207,252,12,48,12,12,12,48,12,12,12,48,12,12,12,48,12,12,12,48,12,12,12,48,12,12,12,48,12,204,12,48,12,204,12,48,12,48,12,48,12,48,12,48,12,0,192,48,12,0,192,48,12,0,192,48,12,0,192,48,3,255,195,48,3,255,195,48,0,0,0,192,0,0,0,192,
  // 0x521d  初
  29,82,28,32,128,32,0,252,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,0,0,3,255,240,0,3,255,240,255,240,48,48,255,240,48,48,0,192,48,48,0,192,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,48,48,15,48,48,48,15,48,48,48,51,192,48,48,51,192,48,48,195,48,48,48,195,48,48,48,3,48,48,48,3,48,48,48,3,0,192,48,3,0,192,48,3,0,192,48,3,0,192,48,3,3,0,48,3,3,0,48,3,12,12,192,3,12,12,192,3,48,3,0,3,48,3,0,
  // 0x522b  别
  43,82,28,32,128,32,0,252,0,0,0,48,0,0,0,48,63,255,0,48,63,255,0,48,48,3,0,48,48,3,0,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,63,255,12,48,63,255,12,48,3,0,12,48,3,0,12,48,3,0,12,48,3,0,12,48,255,255,12,48,255,255,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,12,3,0,48,12,3,0,48,12,3,0,48,12,3,0,48,48,204,3,48,48,204,3,48,192,48,0,192,192,48,0,192,
  // 0x5230  到
  48,82,28,32,128,32,0,252,0,0,0,48,0,0,0,48,255,255,192,48,255,255,192,48,0,192,0,48,0,192,0,48,3,0,12,48,3,0,12,48,12,12,12,48,12,12,12,48,48,3,12,48,48,3,12,48,255,255,204,48,255,255,204,48,0,192,204,48,0,192,204,48,0,192,12,48,0,192,12,48,0,192,12,48,0,192,12,48,63,255,12,48,63,255,12,48,0,192,12,48,0,192,12,48,0,192,0,48,0,192,0,48,0,255,192,48,0,255,192,48,255,192,3,48,255,192,3,48,48,0,0,192,48,0,0,192,
  // 0x5236  制
  54,82,28,32,128,32,0,252,0,48,0,48,0,48,0,48,12,48,0,48,12,48,0,48,12,48,0,48,12,48,0,48,15,255,204,48,15,255,204,48,48,48,12,48,48,48,12,48,0,48,12,48,0,48,12,48,255,255,252,48,255,255,252,48,0,48,12,48,0,48,12,48,0,48,12,48,0,48,12,48,15,255,204,48,15,255,204,48,12,48,204,48,12,48,204,48,12,48,204,48,12,48,204,48,12,60,192,48,12,60,192,48,12,51,0,48,12,51,0,48,0,48,3,48,0,48,3,48,0,48,0,192,0,48,0,192,
  // 0x5237  刷
  55,82,30,32,128,32,0,252,0,0,0,12,0,0,0,12,15,255,240,12,15,255,240,12,12,0,48,12,12,0,48,12,12,0,48,12,12,0,48,12,15,255,243,12,15,255,243,12,12,12,3,12,12,12,3,12,12,12,3,12,12,12,3,12,12,12,3,12,12,12,3,12,15,255,243,12,15,255,243,12,51,12,51,12,51,12,51,12,51,12,51,12,51,12,51,12,51,12,51,12,51,12,51,12,195,15,48,12,195,15,48,12,3,12,192,12,3,12,192,12,0,12,0,204,0,12,0,204,0,12,0,48,0,12,0,48,
  // 0x5272  割
  114,82,28,32,128,32,0,252,3,0,0,48,3,0,0,48,0,192,0,48,0,192,0,48,255,255,192,48,255,255,192,48,192,0,204,48,192,0,204,48,0,195,12,48,0,195,12,48,63,255,12,48,63,255,12,48,0,192,12,48,0,192,12,48,63,255,12,48,63,255,12,48,0,192,12,48,0,192,12,48,255,255,204,48,255,255,204,48,0,192,12,48,0,192,12,48,63,255,12,48,63,255,12,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,48,63,255,3,48,63,255,3,48,48,3,0,192,48,3,0,192,
  // 0x529b  力
  155,82,24,32,96,32,2,252,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,255,255,255,255,255,255,0,48,3,0,48,3,0,48,3,0,48,3,0,48,3,0,48,3,0,48,3,0,48,3,0,192,3,0,192,3,0,192,3,0,192,3,3,0,3,3,0,3,3,0,3,3,0,3,12,3,3,12,3,3,48,0,204,48,0,204,192,0,48,192,0,48,
  // 0x529f  功
  159,82,28,32,128,32,0,252,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,255,252,48,0,255,252,48,0,3,3,255,240,3,3,255,240,3,0,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,192,48,3,0,192,48,3,0,192,48,3,0,192,48,3,252,192,48,3,252,192,48,255,3,0,48,255,3,0,48,48,3,0,48,48,3,0,48,0,12,12,192,0,12,12,192,0,48,3,0,0,48,3,0,
  // 0x52a0  加
  160,82,28,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,63,240,3,0,63,240,255,252,48,48,255,252,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,48,12,12,48,48,12,12,48,48,12,12,63,240,12,12,63,240,48,204,48,48,48,204,48,48,192,48,0,0,192,48,0,0,
  // 0x52a8  动
  168,82,28,32,128,32,0,252,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,63,240,48,0,63,240,48,0,0,0,48,0,0,0,48,0,0,3,255,240,0,3,255,240,0,0,48,48,0,0,48,48,255,252,48,48,255,252,48,48,12,0,48,48,12,0,48,48,12,0,48,48,12,0,48,48,12,0,192,48,12,0,192,48,48,192,192,48,48,192,192,48,48,48,192,48,48,48,192,48,255,243,0,48,255,243,0,48,48,51,0,48,48,51,0,48,0,12,12,192,0,12,12,192,0,48,3,0,0,48,3,0,
  // 0x5316  化
  22,83,30,32,128,32,0,252,0,192,192,0,0,192,192,0,0,192,192,0,0,192,192,0,0,192,192,48,0,192,192,48,3,0,192,192,3,0,192,192,3,0,195,0,3,0,195,0,15,0,204,0,15,0,204,0,15,0,240,0,15,0,240,0,51,0,192,0,51,0,192,0,195,3,192,0,195,3,192,0,3,12,192,0,3,12,192,0,3,48,192,0,3,48,192,0,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,63,252,3,0,63,252,3,0,0,0,3,0,0,0,
  // 0x5347  升
  71,83,30,32,128,32,0,252,0,3,12,0,0,3,12,0,0,63,204,0,0,63,204,0,15,240,12,0,15,240,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,48,12,0,255,255,255,252,255,255,255,252,0,48,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,3,0,12,0,3,0,12,0,12,0,12,0,12,0,12,0,48,0,12,0,48,0,12,0,
  // 0x534a  半
  74,83,30,32,128,32,0,252,0,3,0,0,0,3,0,0,12,3,0,192,12,3,0,192,3,3,0,192,3,3,0,192,0,195,3,0,0,195,3,0,0,195,12,0,0,195,12,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x534f  协
  79,83,30,32,128,32,0,252,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,255,207,255,0,255,207,255,0,12,0,195,0,12,0,195,0,12,0,195,0,12,0,195,0,12,12,195,192,12,12,195,192,12,12,195,48,12,12,195,48,12,48,195,12,12,48,195,12,12,192,195,12,12,192,195,12,12,0,195,0,12,0,195,0,12,3,3,0,12,3,3,0,12,3,3,0,12,3,3,0,12,12,51,0,12,12,51,0,12,48,12,0,12,48,12,0,
  // 0x5355  单
  85,83,30,32,128,32,0,252,3,0,3,0,3,0,3,0,0,192,12,0,0,192,12,0,0,48,48,0,0,48,48,0,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x5361  卡
  97,83,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,15,255,192,0,15,255,192,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,255,255,255,252,255,255,255,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,48,0,0,12,48,0,0,12,12,0,0,12,12,0,0,12,3,0,0,12,3,0,0,12,0,192,0,12,0,192,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,
  // 0x5370  印
  112,83,26,30,120,32,2,252,0,240,0,0,0,240,0,0,255,3,255,192,255,3,255,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,255,243,0,192,255,243,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,195,243,51,0,195,243,51,0,252,3,12,0,252,3,12,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x5371  危
  113,83,28,32,128,32,0,252,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,255,255,0,0,255,255,0,3,0,3,0,3,0,3,0,12,0,12,0,12,0,12,0,51,255,255,240,51,255,255,240,3,0,0,0,3,0,0,0,3,15,255,0,3,15,255,0,3,12,3,0,3,12,3,0,3,12,3,0,3,12,3,0,3,12,51,0,3,12,51,0,3,12,12,0,3,12,12,0,12,12,0,48,12,12,0,48,12,12,0,48,12,12,0,48,48,3,255,240,48,3,255,240,192,0,0,0,192,0,0,0,
  // 0x5374  却
  116,83,28,32,128,32,0,252,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,63,240,0,192,63,240,63,255,48,48,63,255,48,48,0,192,48,48,0,192,48,48,0,192,48,48,0,192,48,48,0,192,48,48,0,192,48,48,255,255,240,48,255,255,240,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,48,48,12,48,48,48,12,48,48,48,48,12,51,48,48,12,51,48,255,255,48,192,255,255,48,192,48,3,48,0,48,3,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,
  // 0x5378  卸
  120,83,28,32,128,32,0,252,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,15,255,63,240,15,255,63,240,48,192,48,48,48,192,48,48,192,192,48,48,192,192,48,48,0,192,48,48,0,192,48,48,63,255,48,48,63,255,48,48,0,192,48,48,0,192,48,48,0,192,48,48,0,192,48,48,12,252,48,48,12,252,48,48,12,192,48,48,12,192,48,48,12,192,51,48,12,192,51,48,12,255,48,192,12,255,48,192,255,0,48,0,255,0,48,0,48,0,48,0,48,0,48,0,0,0,48,0,0,0,48,0,
  // 0x538b  压
  139,83,30,30,120,32,0,252,15,255,255,252,15,255,255,252,12,0,0,0,12,0,0,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,255,255,240,12,255,255,240,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,195,0,12,0,195,0,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,48,0,192,0,48,0,192,0,51,255,255,252,51,255,255,252,192,0,0,0,192,0,0,0,
  // 0x539f  原
  159,83,30,30,120,32,0,252,15,255,255,252,15,255,255,252,12,0,192,0,12,0,192,0,12,3,0,0,12,3,0,0,12,63,255,0,12,63,255,0,12,48,3,0,12,48,3,0,12,48,3,0,12,48,3,0,12,63,255,0,12,63,255,0,12,48,3,0,12,48,3,0,12,48,3,0,12,48,3,0,12,63,255,0,12,63,255,0,12,0,192,0,12,0,192,0,12,48,195,0,12,48,195,0,48,192,192,192,48,192,192,192,51,12,192,48,51,12,192,48,192,3,0,0,192,3,0,0,
  // 0x53cc  双
  204,83,30,28,112,32,0,252,255,243,255,240,255,243,255,240,0,48,192,48,0,48,192,48,48,48,192,48,48,48,192,48,48,48,192,48,48,48,192,48,12,192,192,192,12,192,192,192,12,192,192,192,12,192,192,192,3,0,51,0,3,0,51,0,3,0,51,0,3,0,51,0,12,192,12,0,12,192,12,0,12,192,12,0,12,192,12,0,48,48,51,0,48,48,51,0,48,48,192,192,48,48,192,192,192,3,0,48,192,3,0,48,0,12,0,12,0,12,0,12,
  // 0x53cd  反
  205,83,30,32,128,32,0,252,0,0,3,0,0,0,3,0,0,0,255,192,0,0,255,192,15,255,0,0,15,255,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,15,255,255,192,15,255,255,192,12,48,0,192,12,48,0,192,12,48,3,0,12,48,3,0,12,12,3,0,12,12,3,0,12,12,12,0,12,12,12,0,12,3,48,0,12,3,48,0,12,0,192,0,12,0,192,0,48,3,48,0,48,3,48,0,48,12,12,0,48,12,12,0,192,240,3,192,192,240,3,192,15,0,0,60,15,0,0,60,
  // 0x53d6  取
  214,83,30,30,120,32,0,252,255,255,192,0,255,255,192,0,12,12,255,240,12,12,255,240,12,12,48,48,12,12,48,48,15,252,48,48,15,252,48,48,12,12,48,48,12,12,48,48,12,12,48,48,12,12,48,48,15,252,48,48,15,252,48,48,12,12,12,192,12,12,12,192,12,12,12,192,12,12,12,192,12,63,204,192,12,63,204,192,255,204,3,0,255,204,3,0,48,12,3,0,48,12,3,0,0,12,12,192,0,12,12,192,0,12,48,48,0,12,48,48,0,12,192,12,0,12,192,12,
  // 0x53d8  变
  216,83,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,48,48,0,0,48,48,0,3,48,51,0,3,48,51,0,12,48,48,192,12,48,48,192,48,48,48,48,48,48,48,48,0,0,0,0,0,0,0,0,15,255,255,0,15,255,255,0,0,192,12,0,0,192,12,0,0,48,48,0,0,48,48,0,0,12,192,0,0,12,192,0,0,3,0,0,0,3,0,0,0,60,240,0,0,60,240,0,3,192,15,0,3,192,15,0,252,0,0,252,252,0,0,252,
  // 0x53f0  台
  240,83,26,32,128,32,2,252,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,3,0,48,0,3,0,48,0,12,0,12,0,12,0,12,0,48,0,3,0,48,0,3,0,255,255,255,192,255,255,255,192,48,0,0,192,48,0,0,192,0,0,0,0,0,0,0,0,15,255,252,0,15,255,252,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,15,255,252,0,15,255,252,0,12,0,12,0,12,0,12,0,
  // 0x5403  吃
  3,84,28,30,120,32,2,254,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,12,0,0,255,12,0,0,195,15,255,240,195,15,255,240,195,48,0,0,195,48,0,0,195,192,0,0,195,192,0,0,195,15,255,0,195,15,255,0,195,0,3,0,195,0,3,0,195,0,12,0,195,0,12,0,195,0,240,0,195,0,240,0,255,3,0,0,255,3,0,0,195,12,0,0,195,12,0,0,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,15,255,240,0,15,255,240,
  // 0x5408  合
  8,84,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,15,0,3,192,15,0,3,192,240,255,252,60,240,255,252,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,
  // 0x540d  名
  13,84,26,32,128,32,0,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,63,255,0,0,63,255,0,0,192,3,0,0,192,3,0,3,48,12,0,3,48,12,0,60,12,48,0,60,12,48,0,0,12,192,0,0,12,192,0,0,3,0,0,0,3,0,0,0,60,0,0,0,60,0,0,3,255,255,192,3,255,255,192,252,192,0,192,252,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,255,192,0,255,255,192,0,192,0,192,0,192,0,192,
  // 0x540e  后
  14,84,30,32,128,32,0,252,0,0,3,0,0,0,3,0,0,0,255,192,0,0,255,192,3,255,0,0,3,255,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,255,255,252,3,255,255,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,63,255,192,3,63,255,192,3,48,0,192,3,48,0,192,12,48,0,192,12,48,0,192,12,48,0,192,12,48,0,192,48,48,0,192,48,48,0,192,192,63,255,192,192,63,255,192,0,48,0,192,0,48,0,192,
  // 0x5411  向
  17,84,26,32,128,32,2,252,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,3,0,0,0,3,0,0,0,255,255,255,192,255,255,255,192,192,0,0,192,192,0,0,192,192,0,0,192,192,0,0,192,192,255,192,192,192,255,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,255,192,192,192,255,192,192,192,192,192,192,192,192,192,192,192,0,0,192,192,0,0,192,192,0,12,192,192,0,12,192,192,0,3,0,192,0,3,0,
  // 0x5426  否
  38,84,30,30,120,32,0,252,63,255,255,240,63,255,255,240,0,0,192,0,0,0,192,0,0,3,0,0,0,3,0,0,0,15,0,0,0,15,0,0,0,51,60,0,0,51,60,0,0,195,3,192,0,195,3,192,15,3,0,48,15,3,0,48,240,3,0,12,240,3,0,12,0,0,0,0,0,0,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,
  // 0x542f  启
  47,84,28,32,128,32,0,252,0,3,0,0,0,3,0,0,0,0,192,0,0,0,192,0,3,255,255,240,3,255,255,240,3,0,0,48,3,0,0,48,3,0,0,48,3,0,0,48,3,0,0,48,3,0,0,48,3,255,255,240,3,255,255,240,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,63,255,240,3,63,255,240,12,48,0,48,12,48,0,48,12,48,0,48,12,48,0,48,48,48,0,48,48,48,0,48,192,63,255,240,192,63,255,240,0,48,0,48,0,48,0,48,
  // 0x544a  告
  74,84,30,32,128,32,0,252,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,255,255,192,3,255,255,192,12,3,0,0,12,3,0,0,48,3,0,0,48,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,
  // 0x5468  周
  104,84,26,30,120,32,0,252,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,255,252,192,12,255,252,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,0,0,192,12,0,0,192,12,63,240,192,12,63,240,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,63,240,192,12,63,240,192,48,0,0,192,48,0,0,192,48,0,12,192,48,0,12,192,192,0,3,0,192,0,3,0,
  // 0x547d  命
  125,84,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,15,63,243,192,15,63,243,192,240,0,0,60,240,0,0,60,0,0,0,0,0,0,0,0,15,252,255,192,15,252,255,192,12,12,192,192,12,12,192,192,12,12,192,192,12,12,192,192,12,12,192,192,12,12,192,192,15,252,204,192,15,252,204,192,12,12,195,0,12,12,195,0,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,
  // 0x548c  和
  140,84,28,32,128,32,0,252,0,48,0,0,0,48,0,0,0,252,0,0,0,252,0,0,63,192,0,0,63,192,0,0,0,192,63,240,0,192,63,240,0,192,48,48,0,192,48,48,255,255,48,48,255,255,48,48,0,192,48,48,0,192,48,48,3,192,48,48,3,192,48,48,3,240,48,48,3,240,48,48,12,204,48,48,12,204,48,48,12,204,48,48,12,204,48,48,48,192,48,48,48,192,48,48,192,192,63,240,192,192,63,240,0,192,48,48,0,192,48,48,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,
  // 0x54cd  响
  205,84,26,32,128,32,2,252,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,255,3,0,0,255,3,0,0,195,63,255,192,195,63,255,192,195,48,0,192,195,48,0,192,195,48,0,192,195,48,0,192,195,51,252,192,195,51,252,192,195,51,12,192,195,51,12,192,195,51,12,192,195,51,12,192,195,51,12,192,195,51,12,192,255,51,12,192,255,51,12,192,195,51,252,192,195,51,252,192,0,48,0,192,0,48,0,192,0,48,0,192,0,48,0,192,0,48,12,192,0,48,12,192,0,48,3,0,0,48,3,0,
  // 0x55b7  喷
  183,85,28,32,128,32,2,252,0,0,48,0,0,0,48,0,0,15,255,192,0,15,255,192,255,0,48,0,255,0,48,0,195,3,3,0,195,3,3,0,195,63,255,240,195,63,255,240,195,3,3,0,195,3,3,0,195,0,0,0,195,0,0,0,195,15,255,192,195,15,255,192,195,12,0,192,195,12,0,192,195,12,48,192,195,12,48,192,255,12,48,192,255,12,48,192,195,12,48,192,195,12,48,192,0,12,48,192,0,12,48,192,0,0,204,0,0,0,204,0,0,3,3,0,0,3,3,0,0,60,0,192,0,60,0,192,
  // 0x5634  嘴
  52,86,30,32,128,32,0,252,0,0,195,0,0,0,195,0,0,12,195,48,0,12,195,48,255,12,243,192,255,12,243,192,195,12,195,12,195,12,195,12,195,12,243,12,195,12,243,12,195,63,0,252,195,63,0,252,195,3,255,0,195,3,255,0,195,12,3,0,195,12,3,0,195,63,255,240,195,63,255,240,195,204,48,48,195,204,48,48,255,15,255,240,255,15,255,240,195,12,48,48,195,12,48,48,0,15,255,240,0,15,255,240,0,48,48,48,0,48,48,48,0,48,51,48,0,48,51,48,0,192,0,192,0,192,0,192,
  // 0x5668  器
  104,86,30,30,120,32,0,252,15,252,63,240,15,252,63,240,12,12,48,48,12,12,48,48,12,12,48,48,12,12,48,48,15,252,63,240,15,252,63,240,0,3,12,0,0,3,12,0,0,3,3,0,0,3,3,0,255,255,255,252,255,255,255,252,0,12,192,0,0,12,192,0,0,240,60,0,0,240,60,0,15,0,3,192,15,0,3,192,240,0,0,60,240,0,0,60,15,252,63,240,15,252,63,240,12,12,48,48,12,12,48,48,12,12,48,48,12,12,48,48,15,252,63,240,15,252,63,240,
  // 0x5674  噴
  116,86,28,32,128,32,2,252,0,0,48,0,0,0,48,0,0,15,255,192,0,15,255,192,255,0,48,0,255,0,48,0,195,3,3,0,195,3,3,0,195,63,255,240,195,63,255,240,195,3,3,0,195,3,3,0,195,15,255,192,195,15,255,192,195,12,0,192,195,12,0,192,195,15,255,192,195,15,255,192,195,12,0,192,195,12,0,192,255,15,255,192,255,15,255,192,195,12,0,192,195,12,0,192,0,15,255,192,0,15,255,192,0,3,3,0,0,3,3,0,0,12,0,192,0,12,0,192,0,48,0,48,0,48,0,48,
  // 0x56de  回
  222,86,24,28,84,32,4,254,255,255,255,255,255,255,192,0,3,192,0,3,192,0,3,192,0,3,195,255,195,195,255,195,195,0,195,195,0,195,195,0,195,195,0,195,195,0,195,195,0,195,195,0,195,195,0,195,195,0,195,195,0,195,195,255,195,195,255,195,192,0,3,192,0,3,192,0,3,192,0,3,255,255,255,255,255,255,192,0,3,192,0,3,
  // 0x56e0  因
  224,86,26,30,120,32,2,252,255,255,255,192,255,255,255,192,192,0,0,192,192,0,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,207,255,252,192,207,255,252,192,192,12,0,192,192,12,0,192,192,51,0,192,192,51,0,192,192,48,192,192,192,48,192,192,192,192,48,192,192,192,48,192,195,0,12,192,195,0,12,192,204,0,12,192,204,0,12,192,192,0,0,192,192,0,0,192,255,255,255,192,255,255,255,192,192,0,0,192,192,0,0,192,
  // 0x56fa  固
  250,86,26,30,120,32,2,252,255,255,255,192,255,255,255,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,207,255,252,192,207,255,252,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,195,255,240,192,195,255,240,192,195,0,48,192,195,0,48,192,195,0,48,192,195,0,48,192,195,0,48,192,195,0,48,192,195,255,240,192,195,255,240,192,195,0,48,192,195,0,48,192,192,0,0,192,192,0,0,192,255,255,255,192,255,255,255,192,192,0,0,192,192,0,0,192,
  // 0x56fe  图
  254,86,26,30,120,32,2,252,255,255,255,192,255,255,255,192,192,48,0,192,192,48,0,192,192,48,0,192,192,48,0,192,192,255,240,192,192,255,240,192,195,192,192,192,195,192,192,192,204,51,0,192,204,51,0,192,192,12,0,192,192,12,0,192,192,243,192,192,192,243,192,192,255,0,63,192,255,0,63,192,192,60,0,192,192,60,0,192,192,3,0,192,192,3,0,192,192,240,0,192,192,240,0,192,192,15,0,192,192,15,0,192,255,255,255,192,255,255,255,192,192,0,0,192,192,0,0,192,
  // 0x5728  在
  40,87,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,255,255,255,252,255,255,255,252,0,192,0,0,0,192,0,0,0,192,48,0,0,192,48,0,3,0,48,0,3,0,48,0,15,0,48,0,15,0,48,0,51,63,255,240,51,63,255,240,195,0,48,0,195,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,255,255,252,3,255,255,252,3,0,0,0,3,0,0,0,
  // 0x574f  坏
  79,87,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,15,255,252,3,15,255,252,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,255,240,12,0,255,240,12,0,3,0,12,0,3,0,12,0,3,0,60,192,3,0,60,192,3,0,60,48,3,0,60,48,3,0,204,48,3,0,204,48,3,243,12,12,3,243,12,12,252,12,12,12,252,12,12,12,48,48,12,0,48,48,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,
  // 0x5757  块
  87,87,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,15,255,240,3,15,255,240,3,0,48,48,3,0,48,48,255,240,48,48,255,240,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,15,255,252,3,15,255,252,3,0,48,0,3,0,48,0,3,0,204,0,3,0,204,0,3,240,204,0,3,240,204,0,252,3,3,0,252,3,3,0,48,12,0,192,48,12,0,192,0,48,0,48,0,48,0,48,0,192,0,12,0,192,0,12,
  // 0x578b  型
  139,87,30,30,120,32,0,254,0,0,0,48,0,0,0,48,63,255,192,48,63,255,192,48,3,12,12,48,3,12,12,48,3,12,12,48,3,12,12,48,3,12,12,48,3,12,12,48,255,255,204,48,255,255,204,48,3,12,12,48,3,12,12,48,12,12,0,48,12,12,0,48,12,12,3,48,12,12,3,48,48,3,0,192,48,3,0,192,192,3,0,0,192,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,
  // 0x57ab  垫
  171,87,30,30,120,32,0,254,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,63,243,255,192,63,243,255,192,0,192,48,192,0,192,48,192,0,240,48,192,0,240,48,192,3,195,240,192,3,195,240,192,60,192,48,204,60,192,48,204,0,192,204,204,0,192,204,204,12,192,192,60,12,192,192,60,3,3,0,12,3,3,0,12,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,
  // 0x586b  填
  107,88,30,32,128,32,0,252,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,63,255,240,12,63,255,240,12,0,48,0,12,0,48,0,12,15,255,192,12,15,255,192,255,204,0,192,255,204,0,192,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,15,255,192,12,15,255,192,15,204,0,192,15,204,0,192,252,255,255,252,252,255,255,252,48,3,3,0,48,3,3,0,0,12,0,192,0,12,0,192,0,48,0,48,0,48,0,48,
  // 0x58f3  壳
  243,88,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,255,255,0,3,255,255,0,0,0,0,0,0,0,0,0,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,0,0,48,192,0,0,48,0,255,252,0,0,255,252,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,3,0,12,12,3,0,12,12,12,0,12,12,12,0,12,12,240,0,3,252,240,0,3,252,
  // 0x5907  备
  7,89,30,32,128,32,0,252,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,255,255,0,0,255,255,0,3,192,12,0,3,192,12,0,60,48,48,0,60,48,48,0,0,15,192,0,0,15,192,0,3,240,63,0,3,240,63,0,252,0,0,252,252,0,0,252,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,
  // 0x590d  复
  13,89,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,255,255,240,3,255,255,240,12,0,0,0,12,0,0,0,51,255,255,0,51,255,255,0,195,0,3,0,195,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,0,48,0,0,0,48,0,0,0,255,255,0,0,255,255,0,3,192,12,0,3,192,12,0,60,48,48,0,60,48,48,0,0,15,192,0,0,15,192,0,3,240,63,0,3,240,63,0,252,0,0,252,252,0,0,252,
  // 0x5916  外
  22,89,28,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,15,252,48,0,15,252,48,0,12,12,60,0,12,12,60,0,48,12,51,0,48,12,51,0,48,12,48,192,48,12,48,192,204,48,48,48,204,48,48,48,3,48,48,48,3,48,48,48,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,0,48,0,3,0,48,0,12,0,48,0,12,0,48,0,48,0,48,0,48,0,48,0,192,0,48,0,192,0,48,0,
  // 0x591a  多
  26,89,24,32,96,32,2,252,0,48,0,0,48,0,0,48,0,0,48,0,0,255,252,0,255,252,3,0,48,3,0,48,63,0,192,63,0,192,0,195,0,0,195,0,0,60,192,0,60,192,3,195,0,3,195,0,252,15,255,252,15,255,0,48,3,0,48,3,3,192,12,3,192,12,60,48,48,60,48,48,0,12,192,0,12,192,0,15,0,0,15,0,3,240,0,3,240,0,252,0,0,252,0,0,
  // 0x5927  大
  39,89,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,12,0,0,192,12,0,0,192,240,0,0,60,240,0,0,60,
  // 0x5929  天
  41,89,30,30,120,32,0,252,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,12,0,0,192,12,0,0,192,240,0,0,60,240,0,0,60,
  // 0x592a  太
  42,89,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,204,12,0,0,204,12,0,3,3,3,0,3,3,3,0,12,3,0,192,12,3,0,192,240,0,0,60,240,0,0,60,
  // 0x5931  失
  49,89,30,32,128,32,0,252,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,255,255,192,3,255,255,192,12,3,0,0,12,3,0,0,48,3,0,0,48,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,60,0,0,240,60,0,0,240,
  // 0x5934  头
  52,89,30,32,128,32,0,252,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,192,192,0,0,192,192,0,0,48,192,0,0,48,192,0,12,48,192,0,12,48,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,0,0,192,0,0,0,192,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,48,0,0,3,48,0,0,12,12,0,0,12,12,0,0,48,3,0,0,48,3,0,0,192,0,192,0,192,0,192,15,0,0,48,15,0,0,48,240,0,0,48,240,0,0,48,
  // 0x597d  好
  125,89,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,255,240,3,0,255,240,3,0,0,48,3,0,0,48,3,0,0,192,3,0,0,192,255,240,3,0,255,240,3,0,12,48,12,0,12,48,12,0,12,48,12,0,12,48,12,0,12,51,255,252,12,51,255,252,12,48,12,0,12,48,12,0,48,192,12,0,48,192,12,0,12,192,12,0,12,192,12,0,3,0,12,0,3,0,12,0,12,192,12,0,12,192,12,0,48,48,12,0,48,48,12,0,192,48,204,0,192,48,204,0,0,0,48,0,0,0,48,0,
  // 0x59cb  始
  203,89,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,48,0,3,0,48,0,255,240,48,192,255,240,48,192,12,48,192,48,12,48,192,48,12,51,255,252,12,51,255,252,12,48,192,12,12,48,192,12,12,48,0,0,12,48,0,0,48,192,255,240,48,192,255,240,12,192,192,48,12,192,192,48,3,0,192,48,3,0,192,48,12,192,192,48,12,192,192,48,48,48,192,48,48,48,192,48,192,0,255,240,192,0,255,240,0,0,192,48,0,0,192,48,
  // 0x5b50  子
  80,91,30,30,120,32,0,252,63,255,255,192,63,255,255,192,0,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,3,192,0,0,3,192,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,51,0,0,0,51,0,0,0,12,0,0,0,12,0,0,
  // 0x5b58  存
  88,91,30,32,128,32,0,252,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,255,255,255,252,255,255,255,252,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,3,15,255,192,3,15,255,192,3,0,3,0,3,0,3,0,15,0,12,0,15,0,12,0,51,0,48,0,51,0,48,0,195,63,255,252,195,63,255,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,3,48,0,3,3,48,0,3,0,192,0,3,0,192,0,
  // 0x5b89  安
  137,91,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,15,255,255,240,15,255,255,240,12,0,0,48,12,0,0,48,48,12,0,192,48,12,0,192,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,255,255,255,252,255,255,255,252,0,48,12,0,0,48,12,0,0,192,12,0,0,192,12,0,3,192,48,0,3,192,48,0,0,60,48,0,0,60,48,0,0,3,192,0,0,3,192,0,0,12,60,0,0,12,60,0,0,240,3,0,0,240,3,0,63,0,0,192,63,0,0,192,
  // 0x5b8c  完
  140,91,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,0,0,48,192,0,0,48,3,255,255,0,3,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,240,63,255,255,240,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,192,48,48,0,192,48,48,0,192,48,48,0,192,48,48,3,0,48,48,3,0,48,48,60,0,15,240,60,0,15,240,
  // 0x5b9a  定
  154,91,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,0,0,48,192,0,0,48,0,0,0,0,0,0,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,255,192,3,3,255,192,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,12,195,0,0,12,195,0,0,48,63,255,252,48,63,255,252,192,0,0,0,192,0,0,0,
  // 0x5ba2  客
  162,91,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,192,0,48,192,192,0,48,0,255,255,0,0,255,255,0,3,0,12,0,3,0,12,0,12,240,48,0,12,240,48,0,0,15,192,0,0,15,192,0,3,240,63,0,3,240,63,0,252,0,0,252,252,0,0,252,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,
  // 0x5bab  宫
  171,91,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,0,0,48,192,0,0,48,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,0,0,0,0,0,0,0,0,15,255,255,192,15,255,255,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,15,255,255,192,15,255,255,192,12,0,0,192,12,0,0,192,
  // 0x5bf9  对
  249,91,28,32,128,32,2,252,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,255,240,12,0,255,240,12,0,0,51,255,240,0,51,255,240,0,48,12,0,0,48,12,0,48,192,12,0,48,192,12,0,12,195,12,0,12,195,12,0,3,0,204,0,3,0,204,0,3,0,204,0,3,0,204,0,12,192,12,0,12,192,12,0,12,48,12,0,12,48,12,0,48,48,12,0,48,48,12,0,192,0,12,0,192,0,12,0,0,0,204,0,0,0,204,0,0,0,48,0,0,0,48,0,
  // 0x5c06  将
  6,92,30,32,128,32,0,252,0,192,192,0,0,192,192,0,0,192,255,192,0,192,255,192,0,195,0,192,0,195,0,192,48,204,3,0,48,204,3,0,12,192,204,0,12,192,204,0,12,192,48,0,12,192,48,0,0,192,195,0,0,192,195,0,0,207,3,0,0,207,3,0,3,192,3,0,3,192,3,0,12,207,255,252,12,207,255,252,240,192,3,0,240,192,3,0,0,195,3,0,0,195,3,0,0,192,195,0,0,192,195,0,0,192,3,0,0,192,3,0,0,192,51,0,0,192,51,0,0,192,12,0,0,192,12,0,
  // 0x5c0f  小
  15,92,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,3,0,3,3,3,0,3,3,0,192,3,3,0,192,3,3,0,48,3,3,0,48,12,3,0,48,12,3,0,48,12,3,0,12,12,3,0,12,48,3,0,12,48,3,0,12,192,3,0,12,192,3,0,12,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,51,0,0,0,51,0,0,0,12,0,0,0,12,0,0,
  // 0x5c31  就
  49,92,30,32,128,32,0,252,12,0,48,0,12,0,48,0,3,0,51,0,3,0,51,0,255,252,48,192,255,252,48,192,0,0,48,192,0,0,48,192,0,0,48,0,0,0,48,0,63,243,255,252,63,243,255,252,48,48,51,0,48,48,51,0,48,48,51,0,48,48,51,0,48,48,51,0,48,48,51,0,63,240,51,0,63,240,51,0,3,0,195,0,3,0,195,0,51,48,195,0,51,48,195,0,195,12,195,12,195,12,195,12,3,3,3,12,3,3,3,12,51,3,0,252,51,3,0,252,12,12,0,0,12,12,0,0,
  // 0x5c4f  屏
  79,92,28,30,120,32,0,252,15,255,255,192,15,255,255,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,15,255,255,192,15,255,255,192,12,48,3,0,12,48,3,0,12,12,12,0,12,12,12,0,12,255,255,192,12,255,255,192,12,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,15,255,255,240,15,255,255,240,12,12,12,0,12,12,12,0,48,12,12,0,48,12,12,0,48,48,12,0,48,48,12,0,192,48,12,0,192,48,12,0,0,192,12,0,0,192,12,0,
  // 0x5de5  工
  229,93,30,24,96,32,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,
  // 0x5dee  差
  238,93,30,32,128,32,0,252,0,192,12,0,0,192,12,0,0,48,48,0,0,48,48,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,255,255,255,252,255,255,255,252,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,3,63,255,192,3,63,255,192,12,0,192,0,12,0,192,0,48,0,192,0,48,0,192,0,192,0,192,0,192,0,192,0,3,255,255,240,3,255,255,240,
  // 0x5df2  已
  242,93,24,28,84,32,4,254,255,255,240,255,255,240,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,192,0,48,192,0,48,192,0,48,192,0,48,255,255,240,255,255,240,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,3,192,0,3,192,0,3,192,0,3,192,0,3,192,0,3,63,255,255,63,255,255,
  // 0x5e73  平
  115,94,30,30,120,32,0,252,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,3,0,3,3,3,0,0,195,3,0,0,195,3,0,0,195,12,0,0,195,12,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x5e76  并
  118,94,30,32,128,32,0,252,3,0,3,0,3,0,3,0,0,192,3,0,0,192,3,0,0,192,12,0,0,192,12,0,0,0,0,0,0,0,0,0,63,255,255,240,63,255,255,240,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,255,255,255,252,255,255,255,252,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,12,0,12,0,12,0,12,0,48,0,12,0,48,0,12,0,
  // 0x5e8a  床
  138,94,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,0,192,0,0,0,192,0,15,255,255,252,15,255,255,252,12,0,0,0,12,0,0,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,255,255,240,12,255,255,240,12,0,192,0,12,0,192,0,12,3,240,0,12,3,240,0,12,12,204,0,12,12,204,0,12,12,204,0,12,12,204,0,12,48,195,0,12,48,195,0,48,192,192,192,48,192,192,192,51,0,192,60,51,0,192,60,192,0,192,0,192,0,192,0,0,0,192,0,0,0,192,0,
  // 0x5e94  应
  148,94,30,30,120,32,0,254,0,3,0,0,0,3,0,0,0,0,192,0,0,0,192,0,15,255,255,252,15,255,255,252,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,3,0,48,12,3,0,48,12,192,192,48,12,192,192,48,12,48,192,48,12,48,192,48,12,48,48,192,12,48,48,192,12,12,48,192,12,12,48,192,12,12,3,0,12,12,3,0,12,12,3,0,12,12,3,0,48,0,12,0,48,0,12,0,48,0,48,0,48,0,48,0,195,255,255,252,195,255,255,252,
  // 0x5e9f  废
  159,94,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,0,192,0,0,0,192,0,15,255,255,252,15,255,255,252,12,0,192,0,12,0,192,0,12,48,195,0,12,48,195,0,12,192,192,192,12,192,192,192,12,255,255,252,12,255,255,252,12,3,0,0,12,3,0,0,12,3,255,240,12,3,255,240,12,12,192,48,12,12,192,48,12,12,192,192,12,12,192,192,12,48,51,0,12,48,51,0,12,48,12,0,12,48,12,0,48,192,51,0,48,192,51,0,51,3,192,192,51,3,192,192,192,60,0,60,192,60,0,60,
  // 0x5ea6  度
  166,94,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,0,192,0,0,0,192,0,15,255,255,252,15,255,255,252,12,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,15,255,255,240,15,255,255,240,12,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,12,15,252,0,12,15,252,0,12,0,0,0,12,0,0,0,12,255,255,0,12,255,255,0,12,48,3,0,12,48,3,0,48,12,12,0,48,12,12,0,48,3,240,0,48,3,240,0,192,60,15,0,192,60,15,0,15,192,0,252,15,192,0,252,
  // 0x5f00  开
  0,95,30,30,120,32,0,252,63,255,255,240,63,255,255,240,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,255,255,255,252,255,255,255,252,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,12,0,12,0,12,0,12,0,48,0,12,0,48,0,12,0,
  // 0x5f03  弃
  3,95,28,32,128,32,2,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,192,63,255,255,192,0,48,0,0,0,48,0,0,0,192,48,0,0,192,48,0,3,0,12,0,3,0,12,0,15,255,255,0,15,255,255,0,0,0,3,0,0,0,3,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,255,255,255,240,255,255,255,240,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,0,48,0,3,0,48,0,12,0,48,0,12,0,48,0,48,0,48,0,48,0,48,0,
  // 0x5f0f  式
  15,95,30,32,128,32,0,252,0,0,48,192,0,0,48,192,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,0,0,0,48,0,255,255,255,252,255,255,255,252,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,15,252,48,0,15,252,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,12,0,0,192,12,0,0,192,12,12,0,192,12,12,0,255,3,12,0,255,3,12,63,192,0,204,63,192,0,204,12,0,0,60,12,0,0,60,0,0,0,12,0,0,0,12,
  // 0x5f15  引
  21,95,24,32,96,32,2,252,0,0,3,0,0,3,255,252,3,255,252,3,0,12,3,0,12,3,0,12,3,0,12,3,0,12,3,0,12,3,63,252,3,63,252,3,48,0,3,48,0,3,48,0,3,48,0,3,192,0,3,192,0,3,255,252,3,255,252,3,0,12,3,0,12,3,0,12,3,0,12,3,0,12,3,0,12,3,0,12,3,0,12,3,3,48,3,3,48,3,0,192,3,0,192,3,
  // 0x5f39  弹
  57,95,30,32,128,32,0,252,0,3,0,48,0,3,0,48,255,192,192,192,255,192,192,192,0,192,51,0,0,192,51,0,0,195,255,240,0,195,255,240,0,195,12,48,0,195,12,48,63,195,12,48,63,195,12,48,48,3,255,240,48,3,255,240,48,3,12,48,48,3,12,48,48,3,12,48,48,3,12,48,63,195,255,240,63,195,255,240,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,207,255,252,0,207,255,252,0,192,12,0,0,192,12,0,51,0,12,0,51,0,12,0,12,0,12,0,12,0,12,0,
  // 0x5f52  归
  82,95,26,32,128,32,2,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,195,63,255,192,195,63,255,192,195,0,0,192,195,0,0,192,195,0,0,192,195,0,0,192,195,0,0,192,195,0,0,192,195,0,0,192,195,0,0,192,195,15,255,192,195,15,255,192,195,0,0,192,195,0,0,192,195,0,0,192,195,0,0,192,195,0,0,192,195,0,0,192,3,0,0,192,3,0,0,192,12,0,0,192,12,0,0,192,12,63,255,192,12,63,255,192,48,0,0,192,48,0,0,192,192,0,0,0,192,0,0,0,
  // 0x5f84  径
  132,95,30,32,128,32,0,252,0,192,0,0,0,192,0,0,0,207,255,192,0,207,255,192,3,0,3,0,3,0,3,0,12,0,12,0,12,0,12,0,48,192,60,0,48,192,60,0,0,192,195,192,0,192,195,192,3,3,0,48,3,3,0,48,15,60,0,12,15,60,0,12,51,0,0,0,51,0,0,0,195,15,255,240,195,15,255,240,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,63,255,252,3,63,255,252,3,0,0,0,3,0,0,0,
  // 0x5f85  待
  133,95,30,32,128,32,0,252,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,0,48,0,3,0,48,0,12,15,255,240,12,15,255,240,48,192,48,0,48,192,48,0,0,192,48,0,0,192,48,0,3,63,255,252,3,63,255,252,15,0,3,0,15,0,3,0,51,0,3,0,51,0,3,0,195,63,255,252,195,63,255,252,3,0,3,0,3,0,3,0,3,12,3,0,3,12,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,0,51,0,3,0,51,0,3,0,12,0,3,0,12,0,
  // 0x5faa  循
  170,95,30,32,128,32,0,252,3,0,15,240,3,0,15,240,3,63,252,0,3,63,252,0,12,48,12,0,12,48,12,0,48,48,12,0,48,48,12,0,195,63,255,252,195,63,255,252,3,48,12,0,3,48,12,0,12,51,255,240,12,51,255,240,60,51,0,48,60,51,0,48,204,51,0,48,204,51,0,48,12,51,255,240,12,51,255,240,12,51,0,48,12,51,0,48,12,51,255,240,12,51,255,240,12,195,0,48,12,195,0,48,12,195,0,48,12,195,0,48,15,3,255,240,15,3,255,240,12,3,0,48,12,3,0,48,
  // 0x5fae  微
  174,95,30,32,128,32,0,252,3,3,0,192,3,3,0,192,3,51,48,192,3,51,48,192,12,51,48,192,12,51,48,192,48,51,51,0,48,51,51,0,195,63,243,252,195,63,243,252,3,0,12,48,3,0,12,48,12,0,3,48,12,0,3,48,60,255,243,48,60,255,243,48,204,0,3,48,204,0,3,48,12,63,195,48,12,63,195,48,12,48,195,48,12,48,195,48,12,48,204,192,12,48,204,192,12,48,240,192,12,48,240,192,12,48,195,48,12,48,195,48,12,192,3,48,12,192,3,48,15,0,12,12,15,0,12,12,
  // 0x5fc3  心
  195,95,30,28,112,32,0,254,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,48,0,0,0,48,0,0,0,48,0,192,0,48,0,192,12,48,0,48,12,48,0,48,12,48,0,48,12,48,0,48,12,48,0,12,12,48,0,12,48,48,0,12,48,48,0,12,48,48,3,12,48,48,3,12,192,48,3,0,192,48,3,0,0,48,3,0,0,48,3,0,0,15,255,0,0,15,255,0,
  // 0x5ffd  忽
  253,95,30,30,120,32,0,254,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,3,255,255,192,3,255,255,192,3,12,48,192,3,12,48,192,12,12,48,192,12,12,48,192,48,48,192,192,48,48,192,192,0,192,192,192,0,192,192,192,3,3,0,192,3,3,0,192,12,12,12,192,12,12,12,192,0,48,3,0,0,48,3,0,0,3,0,0,0,3,0,0,0,192,192,48,0,192,192,48,48,192,195,12,48,192,195,12,48,192,3,12,48,192,3,12,192,63,255,0,192,63,255,0,
  // 0x6027  性
  39,96,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,3,12,0,3,3,12,0,3,3,12,0,3,3,12,0,3,195,255,240,3,195,255,240,51,51,12,0,51,51,12,0,51,12,12,0,51,12,12,0,51,0,12,0,51,0,12,0,195,0,12,0,195,0,12,0,3,3,255,240,3,3,255,240,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,15,255,252,3,15,255,252,3,0,0,0,3,0,0,0,
  // 0x603b  总
  59,96,30,30,120,32,0,254,3,0,3,0,3,0,3,0,0,192,12,0,0,192,12,0,0,48,48,0,0,48,48,0,0,0,0,0,0,0,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,0,3,0,0,0,3,0,0,0,192,192,48,0,192,192,48,48,192,195,12,48,192,195,12,48,192,3,12,48,192,3,12,192,63,255,0,192,63,255,0,
  // 0x6062  恢
  98,96,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,15,255,252,3,15,255,252,3,192,192,0,3,192,192,0,51,48,195,0,51,48,195,0,51,0,195,0,51,0,195,0,51,3,3,12,51,3,3,12,195,3,51,12,195,3,51,12,3,3,51,48,3,3,51,48,3,12,195,0,3,12,195,0,3,12,12,192,3,12,12,192,3,48,12,192,3,48,12,192,3,0,48,48,3,0,48,48,3,0,192,48,3,0,192,48,3,3,0,12,3,3,0,12,
  // 0x606f  息
  111,96,30,30,120,32,0,254,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,0,3,0,0,0,3,0,0,0,192,192,48,0,192,192,48,48,192,195,12,48,192,195,12,48,192,3,12,48,192,3,12,192,63,255,0,192,63,255,0,
  // 0x611f  感
  31,97,30,32,128,32,0,252,0,0,12,192,0,0,12,192,0,0,12,48,0,0,12,48,15,255,255,252,15,255,255,252,12,0,12,0,12,0,12,0,12,255,204,48,12,255,204,48,12,0,12,48,12,0,12,48,12,255,204,192,12,255,204,192,12,192,195,192,12,192,195,192,12,192,195,12,12,192,195,12,48,255,204,204,48,255,204,204,48,0,48,60,48,0,48,60,192,0,192,12,192,0,192,12,0,3,0,0,0,3,0,0,48,192,192,48,48,192,192,48,48,192,3,12,48,192,3,12,192,63,255,12,192,63,255,12,
  // 0x620f  戏
  15,98,28,32,128,32,2,252,0,0,48,0,0,0,48,0,0,0,51,0,0,0,51,0,0,0,48,192,0,0,48,192,255,240,48,192,255,240,48,192,0,48,48,0,0,48,48,0,0,48,63,240,0,48,63,240,48,207,240,0,48,207,240,0,12,192,48,192,12,192,48,192,3,0,48,192,3,0,48,192,3,0,51,0,3,0,51,0,12,192,51,0,12,192,51,0,12,48,12,0,12,48,12,0,48,48,60,48,48,48,60,48,192,0,195,48,192,0,195,48,0,3,0,240,0,3,0,240,0,12,0,48,0,12,0,48,
  // 0x6210  成
  16,98,30,32,128,32,0,252,0,0,51,0,0,0,51,0,0,0,48,192,0,0,48,192,0,0,48,0,0,0,48,0,15,255,255,252,15,255,255,252,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,48,12,0,48,48,15,252,48,48,15,252,48,48,12,12,48,48,12,12,48,48,12,12,12,192,12,12,12,192,12,12,12,192,12,12,12,192,12,12,3,12,12,12,3,12,12,204,15,12,12,204,15,12,48,48,48,204,48,48,48,204,48,0,192,60,48,0,192,60,192,3,0,12,192,3,0,12,
  // 0x6237  户
  55,98,24,32,96,32,2,252,0,48,0,0,48,0,0,12,0,0,12,0,0,12,0,0,12,0,15,255,255,15,255,255,12,0,3,12,0,3,12,0,3,12,0,3,12,0,3,12,0,3,12,0,3,12,0,3,15,255,255,15,255,255,12,0,3,12,0,3,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,0,
  // 0x6240  所
  64,98,30,32,128,32,0,252,0,12,0,192,0,12,0,192,0,63,3,240,0,63,3,240,15,192,252,0,15,192,252,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,15,252,192,0,15,252,192,0,12,12,255,252,12,12,255,252,12,12,192,192,12,12,192,192,12,12,192,192,12,12,192,192,15,252,192,192,15,252,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,48,3,0,192,48,3,0,192,48,3,0,192,48,3,0,192,192,12,0,192,192,12,0,192,0,48,0,192,0,48,0,192,
  // 0x6247  扇
  71,98,28,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,15,255,255,240,15,255,255,240,12,0,0,48,12,0,0,48,12,0,0,48,12,0,0,48,15,255,255,240,15,255,255,240,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,15,255,63,240,15,255,63,240,12,3,0,48,12,3,0,48,12,195,12,48,12,195,12,48,12,51,3,48,12,51,3,48,48,195,12,48,48,195,12,48,51,3,48,48,51,3,48,48,192,51,3,48,192,51,3,48,0,12,0,192,0,12,0,192,
  // 0x624b  手
  75,98,30,32,128,32,0,252,0,0,3,0,0,0,3,0,0,0,255,192,0,0,255,192,15,255,0,0,15,255,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,51,0,0,0,51,0,0,0,12,0,0,0,12,0,0,
  // 0x6253  打
  83,98,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,15,255,252,3,15,255,252,3,0,12,0,3,0,12,0,255,240,12,0,255,240,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,48,12,0,3,48,12,0,3,192,12,0,3,192,12,0,15,0,12,0,15,0,12,0,243,0,12,0,243,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,51,0,204,0,51,0,204,0,12,0,48,0,12,0,48,0,
  // 0x6267  执
  103,98,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,255,243,255,192,255,243,255,192,3,0,48,192,3,0,48,192,3,0,48,192,3,0,48,192,3,48,48,192,3,48,48,192,3,195,48,192,3,195,48,192,15,0,240,192,15,0,240,192,243,0,48,192,243,0,48,192,3,0,204,192,3,0,204,192,3,0,204,204,3,0,204,204,3,3,0,204,3,3,0,204,51,12,0,60,51,12,0,60,12,48,0,12,12,48,0,12,
  // 0x6279  批
  121,98,30,32,128,32,0,252,3,0,3,0,3,0,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,12,3,3,3,12,255,243,3,12,255,243,3,12,3,3,3,48,3,3,3,48,3,3,243,192,3,3,243,192,3,51,3,0,3,51,3,0,3,195,3,0,3,195,3,0,15,3,3,0,15,3,3,0,243,3,3,0,243,3,3,0,3,3,3,12,3,3,3,12,3,3,51,12,3,3,51,12,3,3,195,12,3,3,195,12,51,3,0,252,51,3,0,252,12,0,0,0,12,0,0,0,
  // 0x6296  抖
  150,98,30,32,128,32,0,252,3,0,3,0,3,0,3,0,3,3,3,0,3,3,3,0,3,0,195,0,3,0,195,0,3,0,195,0,3,0,195,0,255,240,3,0,255,240,3,0,3,3,3,0,3,3,3,0,3,0,195,0,3,0,195,0,3,48,195,0,3,48,195,0,3,192,3,0,3,192,3,0,15,0,3,252,15,0,3,252,243,15,255,0,243,15,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,51,0,3,0,51,0,3,0,12,0,3,0,12,0,3,0,
  // 0x62a5  报
  165,98,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,3,255,240,3,3,255,240,3,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,255,243,3,48,255,243,3,48,3,3,0,192,3,3,0,192,3,3,0,0,3,3,0,0,3,51,255,240,3,51,255,240,3,195,48,48,3,195,48,48,15,3,48,48,15,3,48,48,243,3,12,192,243,3,12,192,3,3,12,192,3,3,12,192,3,3,3,0,3,3,3,0,3,3,12,192,3,3,12,192,51,3,48,48,51,3,48,48,12,3,192,12,12,3,192,12,
  // 0x62ac  抬
  172,98,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,48,0,3,0,48,0,3,0,192,192,3,0,192,192,255,243,0,48,255,243,0,48,3,15,255,252,3,15,255,252,3,0,0,12,3,0,0,12,3,48,0,0,3,48,0,0,3,195,255,240,3,195,255,240,15,3,0,48,15,3,0,48,243,3,0,48,243,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,51,3,255,240,51,3,255,240,12,3,0,48,12,3,0,48,
  // 0x62bd  抽
  189,98,28,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,255,243,255,240,255,243,255,240,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,51,12,48,3,51,12,48,3,195,12,48,3,195,12,48,15,3,255,240,15,3,255,240,243,3,12,48,243,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,51,3,255,240,51,3,255,240,12,3,0,48,12,3,0,48,
  // 0x62d4  拔
  212,98,30,32,128,32,0,252,3,0,51,0,3,0,51,0,3,0,48,192,3,0,48,192,3,0,48,192,3,0,48,192,3,0,48,0,3,0,48,0,255,207,255,252,255,207,255,252,3,0,192,0,3,0,192,0,3,48,192,0,3,48,192,0,3,192,255,240,3,192,255,240,15,3,48,48,15,3,48,48,243,3,48,48,243,3,48,48,3,3,12,192,3,3,12,192,3,3,12,192,3,3,12,192,3,12,3,0,3,12,3,0,3,12,12,192,3,12,12,192,51,48,48,48,51,48,48,48,12,3,192,12,12,3,192,12,
  // 0x62e9  择
  233,98,30,32,128,32,0,252,12,0,0,0,12,0,0,0,12,63,255,192,12,63,255,192,12,12,0,192,12,12,0,192,12,3,3,0,12,3,3,0,255,0,204,0,255,0,204,0,12,0,48,0,12,0,48,0,12,3,207,0,12,3,207,0,12,60,48,252,12,60,48,252,15,0,48,0,15,0,48,0,252,15,255,192,252,15,255,192,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,63,255,240,12,63,255,240,12,0,48,0,12,0,48,0,204,0,48,0,204,0,48,0,48,0,48,0,48,0,48,0,
  // 0x6309  按
  9,99,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,15,255,252,3,15,255,252,255,204,0,12,255,204,0,12,3,48,48,48,3,48,48,48,3,0,48,0,3,0,48,0,3,207,255,252,3,207,255,252,15,0,192,192,15,0,192,192,243,0,192,192,243,0,192,192,3,3,0,192,3,3,0,192,3,0,243,0,3,0,243,0,3,0,12,0,3,0,12,0,3,0,51,0,3,0,51,0,51,0,192,192,51,0,192,192,12,15,0,48,12,15,0,48,
  // 0x6321  挡
  33,99,28,32,128,32,0,252,3,0,48,0,3,0,48,0,3,12,48,48,3,12,48,48,3,3,48,48,3,3,48,48,3,3,48,48,3,3,48,48,255,243,48,192,255,243,48,192,3,0,48,0,3,0,48,0,3,63,255,240,3,63,255,240,3,0,0,48,3,0,0,48,3,192,0,48,3,192,0,48,15,0,0,48,15,0,0,48,243,15,255,240,243,15,255,240,3,0,0,48,3,0,0,48,3,0,0,48,3,0,0,48,3,0,0,48,3,0,0,48,51,63,255,240,51,63,255,240,12,0,0,48,12,0,0,48,
  // 0x6324  挤
  36,99,30,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,48,0,3,0,48,0,3,63,255,252,3,63,255,252,3,12,0,192,3,12,0,192,255,243,3,0,255,243,3,0,3,0,204,0,3,0,204,0,3,48,48,0,3,48,48,0,3,195,207,0,3,195,207,0,15,60,0,252,15,60,0,252,243,3,3,0,243,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,12,3,0,3,12,3,0,51,12,3,0,51,12,3,0,12,48,3,0,12,48,3,0,
  // 0x635f  损
  95,99,28,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,255,192,3,0,255,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,255,240,255,192,255,240,255,192,3,0,0,0,3,0,0,0,3,3,255,240,3,3,255,240,3,51,0,48,3,51,0,48,3,195,12,48,3,195,12,48,15,3,12,48,15,3,12,48,243,3,12,48,243,3,12,48,3,3,12,48,3,3,12,48,3,0,51,0,3,0,51,0,3,0,48,192,3,0,48,192,51,0,192,48,51,0,192,48,12,15,0,48,12,15,0,48,
  // 0x6362  换
  98,99,30,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,255,192,3,0,255,192,3,3,0,192,3,3,0,192,255,204,3,0,255,204,3,0,3,51,255,240,3,51,255,240,3,3,12,48,3,3,12,48,3,195,12,48,3,195,12,48,15,3,12,48,15,3,12,48,243,3,12,48,243,3,12,48,3,63,255,252,3,63,255,252,3,0,51,0,3,0,51,0,3,0,51,0,3,0,51,0,3,0,192,192,3,0,192,192,51,3,0,48,51,3,0,48,12,60,0,12,12,60,0,12,
  // 0x6389  掉
  137,99,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,15,252,3,0,15,252,3,0,12,0,3,0,12,0,255,243,255,240,255,243,255,240,3,3,0,48,3,3,0,48,3,51,255,240,3,51,255,240,3,195,0,48,3,195,0,48,15,3,255,240,15,3,255,240,243,3,12,48,243,3,12,48,3,0,12,0,3,0,12,0,3,15,255,252,3,15,255,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,51,0,12,0,51,0,12,0,12,0,12,0,12,0,12,0,
  // 0x63a2  探
  162,99,30,32,128,32,0,252,12,0,0,0,12,0,0,0,12,63,255,240,12,63,255,240,12,48,0,48,12,48,0,48,12,48,204,48,12,48,204,48,255,195,3,0,255,195,3,0,12,12,0,192,12,12,0,192,12,0,48,0,12,0,48,0,12,192,48,0,12,192,48,0,15,63,255,240,15,63,255,240,252,0,48,0,252,0,48,0,12,0,252,0,12,0,252,0,12,3,51,0,12,3,51,0,12,12,48,192,12,12,48,192,12,240,48,60,12,240,48,60,204,0,48,0,204,0,48,0,48,0,48,0,48,0,48,0,
  // 0x63a5  接
  165,99,30,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,48,0,3,0,48,0,3,15,255,240,3,15,255,240,3,0,0,0,3,0,0,0,255,243,0,192,255,243,0,192,3,0,195,0,3,0,195,0,3,63,255,252,3,63,255,252,3,0,48,0,3,0,48,0,3,192,48,0,3,192,48,0,15,63,255,252,15,63,255,252,243,0,192,192,243,0,192,192,3,3,0,192,3,3,0,192,3,0,195,0,3,0,195,0,3,0,60,0,3,0,60,0,51,3,195,192,51,3,195,192,12,60,0,48,12,60,0,48,
  // 0x63a7  控
  167,99,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,15,255,252,3,15,255,252,255,204,0,12,255,204,0,12,3,48,195,48,3,48,195,48,3,3,0,192,3,3,0,192,3,204,0,48,3,204,0,48,15,0,0,0,15,0,0,0,243,3,255,240,243,3,255,240,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,51,63,255,252,51,63,255,252,12,0,0,0,12,0,0,0,
  // 0x63d0  提
  208,99,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,3,255,240,3,3,255,240,3,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,255,243,255,240,255,243,255,240,3,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,3,51,255,240,3,51,255,240,3,192,0,0,3,192,0,0,15,15,255,252,15,15,255,252,243,0,12,0,243,0,12,0,3,3,12,0,3,3,12,0,3,3,15,240,3,3,15,240,3,3,12,0,3,3,12,0,51,12,204,0,51,12,204,0,12,48,63,252,12,48,63,252,
  // 0x63d2  插
  210,99,30,32,128,32,0,252,12,0,0,192,12,0,0,192,12,0,15,240,12,0,15,240,12,63,240,0,12,63,240,0,12,0,48,0,12,0,48,0,255,192,48,0,255,192,48,0,12,255,255,252,12,255,255,252,12,0,48,0,12,0,48,0,12,195,48,0,12,195,48,0,15,60,51,240,15,60,51,240,252,48,48,48,252,48,48,48,12,48,48,48,12,48,48,48,12,63,51,240,12,63,51,240,12,48,48,48,12,48,48,48,12,48,48,48,12,48,48,48,204,63,255,240,204,63,255,240,48,48,0,48,48,48,0,48,
  // 0x6536  收
  54,101,28,32,128,32,2,252,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,195,0,192,0,195,0,192,0,195,3,0,0,195,3,0,0,195,3,255,240,195,3,255,240,195,12,3,0,195,12,3,0,195,51,3,0,195,51,3,0,195,3,3,0,195,3,3,0,195,3,3,0,195,3,3,0,207,0,204,0,207,0,204,0,243,0,204,0,243,0,204,0,195,0,48,0,195,0,48,0,3,0,204,0,3,0,204,0,3,3,3,0,3,3,3,0,3,12,0,192,3,12,0,192,3,48,0,48,3,48,0,48,
  // 0x653e  放
  62,101,30,32,128,32,0,252,12,0,48,0,12,0,48,0,3,0,48,0,3,0,48,0,0,0,48,0,0,0,48,0,255,252,192,0,255,252,192,0,12,0,255,252,12,0,255,252,12,3,0,192,12,3,0,192,15,252,192,192,15,252,192,192,12,48,192,192,12,48,192,192,12,48,192,192,12,48,192,192,12,48,51,0,12,48,51,0,12,48,51,0,12,48,51,0,12,48,12,0,12,48,12,0,48,48,51,0,48,48,51,0,51,48,192,192,51,48,192,192,192,195,0,48,192,195,0,48,0,12,0,12,0,12,0,12,
  // 0x6570  数
  112,101,30,32,128,32,0,252,0,192,12,0,0,192,12,0,48,195,12,0,48,195,12,0,12,204,12,0,12,204,12,0,0,192,15,252,0,192,15,252,255,255,48,48,255,255,48,48,12,204,48,48,12,204,48,48,48,195,48,48,48,195,48,48,192,192,204,48,192,192,204,48,3,0,12,192,3,0,12,192,255,252,12,192,255,252,12,192,12,12,3,0,12,12,3,0,48,12,3,0,48,12,3,0,60,48,12,192,60,48,12,192,3,192,12,192,3,192,12,192,15,48,48,48,15,48,48,48,240,12,192,12,240,12,192,12,
  // 0x6572  敲
  114,101,30,32,128,32,0,252,3,0,3,0,3,0,3,0,0,192,3,0,0,192,3,0,255,255,3,0,255,255,3,0,0,0,3,252,0,0,3,252,63,252,3,0,63,252,3,0,48,12,3,0,48,12,3,0,63,252,255,240,63,252,255,240,0,0,48,48,0,0,48,48,255,255,48,48,255,255,48,48,192,3,48,48,192,3,48,48,207,243,12,192,207,243,12,192,204,51,12,192,204,51,12,192,207,243,3,0,207,243,3,0,192,3,12,192,192,3,12,192,192,51,48,48,192,51,48,48,192,12,192,12,192,12,192,12,
  // 0x6574  整
  116,101,30,32,128,32,0,252,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,255,255,207,252,255,255,207,252,0,192,48,48,0,192,48,48,63,255,204,48,63,255,204,48,48,195,12,48,48,195,12,48,63,255,12,192,63,255,12,192,12,204,3,0,12,204,3,0,48,195,12,192,48,195,12,192,192,192,48,60,192,192,48,60,0,0,0,0,0,0,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,3,3,255,192,3,3,255,192,3,3,0,0,3,3,0,0,255,255,255,252,255,255,255,252,
  // 0x6599  料
  153,101,30,32,128,32,0,252,0,192,0,192,0,192,0,192,0,192,192,192,0,192,192,192,48,204,48,192,48,204,48,192,12,204,48,192,12,204,48,192,12,240,0,192,12,240,0,192,0,192,192,192,0,192,192,192,255,252,48,192,255,252,48,192,3,192,48,192,3,192,48,192,3,240,0,192,3,240,0,192,12,204,0,252,12,204,0,252,12,204,255,192,12,204,255,192,48,192,0,192,48,192,0,192,192,192,0,192,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,
  // 0x659c  斜
  156,101,30,32,128,32,0,252,0,192,0,192,0,192,0,192,0,192,48,192,0,192,48,192,3,48,12,192,3,48,12,192,12,12,12,192,12,12,12,192,48,3,0,192,48,3,0,192,207,252,48,192,207,252,48,192,0,192,12,192,0,192,12,192,0,192,12,192,0,192,12,192,63,255,0,252,63,255,0,252,0,192,63,192,0,192,63,192,12,204,0,192,12,204,0,192,12,195,0,192,12,195,0,192,48,195,0,192,48,195,0,192,192,192,0,192,192,192,0,192,12,192,0,192,12,192,0,192,3,0,0,192,3,0,0,192,
  // 0x65ad  断
  173,101,28,32,128,32,2,252,0,192,0,0,0,192,0,0,0,192,0,192,0,192,0,192,204,204,255,0,204,204,255,0,195,240,192,0,195,240,192,0,192,192,192,0,192,192,192,0,255,252,192,0,255,252,192,0,192,192,255,240,192,192,255,240,195,240,195,0,195,240,195,0,204,204,195,0,204,204,195,0,240,204,195,0,240,204,195,0,192,192,195,0,192,192,195,0,192,192,195,0,192,192,195,0,192,0,195,0,192,0,195,0,255,255,3,0,255,255,3,0,0,3,3,0,0,3,3,0,0,12,3,0,0,12,3,0,
  // 0x65b0  新
  176,101,30,32,128,32,0,252,3,0,0,0,3,0,0,0,0,192,0,48,0,192,0,48,63,255,63,192,63,255,63,192,0,0,48,0,0,0,48,0,12,12,48,0,12,12,48,0,3,48,48,0,3,48,48,0,255,255,63,252,255,255,63,252,0,192,48,192,0,192,48,192,0,192,48,192,0,192,48,192,63,255,48,192,63,255,48,192,0,192,48,192,0,192,48,192,12,204,48,192,12,204,48,192,48,195,48,192,48,195,48,192,192,192,192,192,192,192,192,192,12,192,192,192,12,192,192,192,3,3,0,192,3,3,0,192,
  // 0x65b9  方
  185,101,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,63,255,0,0,63,255,0,0,48,3,0,0,48,3,0,0,48,3,0,0,48,3,0,0,48,3,0,0,48,3,0,0,192,3,0,0,192,3,0,0,192,3,0,0,192,3,0,3,0,3,0,3,0,3,0,12,0,204,0,12,0,204,0,48,0,48,0,48,0,48,0,
  // 0x65e0  无
  224,101,28,30,120,32,0,252,15,255,255,0,15,255,255,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,63,255,255,240,63,255,255,240,0,48,192,0,0,48,192,0,0,48,192,0,0,48,192,0,0,48,192,0,0,48,192,0,0,192,192,0,0,192,192,0,0,192,192,0,0,192,192,0,3,0,192,48,3,0,192,48,12,0,192,48,12,0,192,48,48,0,63,240,48,0,63,240,192,0,0,0,192,0,0,0,
  // 0x65f6  时
  246,101,28,32,128,32,2,252,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,255,192,3,0,255,192,3,0,192,192,3,0,192,192,3,0,192,207,255,240,192,207,255,240,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,255,192,3,0,255,192,3,0,192,195,3,0,192,195,3,0,192,192,195,0,192,192,195,0,192,192,195,0,192,192,195,0,192,192,3,0,192,192,3,0,255,192,3,0,255,192,3,0,192,192,3,0,192,192,3,0,0,0,51,0,0,0,51,0,0,0,12,0,0,0,12,0,
  // 0x660e  明
  14,102,26,30,120,32,2,252,0,3,255,192,0,3,255,192,255,195,0,192,255,195,0,192,192,195,0,192,192,195,0,192,192,195,0,192,192,195,0,192,192,195,255,192,192,195,255,192,255,195,0,192,255,195,0,192,192,195,0,192,192,195,0,192,192,195,0,192,192,195,0,192,192,195,255,192,192,195,255,192,255,195,0,192,255,195,0,192,192,195,0,192,192,195,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,48,12,192,0,48,12,192,0,192,3,0,0,192,3,0,
  // 0x662f  是
  47,102,30,32,128,32,0,252,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,0,0,0,0,0,0,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,255,192,3,3,255,192,3,3,0,0,3,3,0,0,12,195,0,0,12,195,0,0,48,51,0,0,48,51,0,0,192,15,255,252,192,15,255,252,
  // 0x6682  暂
  130,102,30,32,128,32,0,252,3,0,0,240,3,0,0,240,255,252,255,0,255,252,255,0,12,0,192,0,12,0,192,0,48,192,192,0,48,192,192,0,63,252,255,252,63,252,255,252,0,192,192,192,0,192,192,192,0,252,192,192,0,252,192,192,255,195,0,192,255,195,0,192,48,204,0,192,48,204,0,192,3,255,255,192,3,255,255,192,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,
  // 0x66ab  暫
  171,102,28,32,128,32,2,252,3,0,0,192,3,0,0,192,255,252,255,0,255,252,255,0,3,0,192,0,3,0,192,0,255,252,192,0,255,252,192,0,195,12,255,240,195,12,255,240,255,252,195,0,255,252,195,0,195,12,195,0,195,12,195,0,255,252,195,0,255,252,195,0,3,0,195,0,3,0,195,0,255,252,195,0,255,252,195,0,3,3,3,0,3,3,3,0,15,255,252,0,15,255,252,0,12,0,12,0,12,0,12,0,15,255,252,0,15,255,252,0,12,0,12,0,12,0,12,0,15,255,252,0,15,255,252,0,
  // 0x66f4  更
  244,102,30,30,120,32,0,252,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,3,3,0,0,3,3,0,0,0,204,0,0,0,204,0,0,0,60,0,0,0,60,0,0,3,195,240,0,3,195,240,0,252,0,15,252,252,0,15,252,
  // 0x6700  最
  0,103,30,32,128,32,0,252,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,0,0,0,0,0,0,0,0,255,255,255,252,255,255,255,252,12,12,0,0,12,12,0,0,15,252,255,192,15,252,255,192,12,12,192,192,12,12,192,192,15,252,195,0,15,252,195,0,12,12,51,0,12,12,51,0,12,255,12,0,12,255,12,0,255,12,51,0,255,12,51,0,48,12,192,192,48,12,192,192,0,15,0,60,0,15,0,60,
  // 0x6709  有
  9,103,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,255,255,255,252,255,255,255,252,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,255,255,0,0,255,255,0,0,192,3,0,0,192,3,0,3,192,3,0,3,192,3,0,12,255,255,0,12,255,255,0,48,192,3,0,48,192,3,0,192,192,3,0,192,192,3,0,0,255,255,0,0,255,255,0,0,192,3,0,0,192,3,0,0,192,3,0,0,192,3,0,0,192,51,0,0,192,51,0,0,192,12,0,0,192,12,0,
  // 0x671f  期
  31,103,28,32,128,32,0,252,12,12,0,0,12,12,0,0,12,12,63,240,12,12,63,240,63,255,48,48,63,255,48,48,12,12,48,48,12,12,48,48,12,12,48,48,12,12,48,48,15,252,63,240,15,252,63,240,12,12,48,48,12,12,48,48,12,12,48,48,12,12,48,48,15,252,48,48,15,252,48,48,12,12,63,240,12,12,63,240,12,12,48,48,12,12,48,48,255,255,48,48,255,255,48,48,0,48,192,48,0,48,192,48,12,12,192,48,12,12,192,48,48,3,3,48,48,3,3,48,192,12,0,192,192,12,0,192,
  // 0x673a  机
  58,103,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,3,255,0,3,3,255,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,255,243,3,0,255,243,3,0,3,3,3,0,3,3,3,0,15,3,3,0,15,3,3,0,15,195,3,0,15,195,3,0,51,51,3,0,51,51,3,0,51,51,3,0,51,51,3,0,195,3,3,0,195,3,3,0,3,3,3,12,3,3,3,12,3,3,3,12,3,3,3,12,3,12,3,12,3,12,3,12,3,12,0,252,3,12,0,252,3,48,0,0,3,48,0,0,
  // 0x6740  杀
  64,103,30,32,128,32,0,252,0,0,0,192,0,0,0,192,3,192,3,0,3,192,3,0,0,60,60,0,0,60,60,0,0,3,192,0,0,3,192,0,0,60,60,0,0,60,60,0,3,192,3,192,3,192,3,192,60,3,0,48,60,3,0,48,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,3,3,12,0,3,3,12,0,3,3,3,0,3,3,3,0,12,3,0,192,12,3,0,192,12,3,0,48,12,3,0,48,48,51,0,48,48,51,0,48,0,12,0,0,0,12,0,0,
  // 0x675f  束
  95,103,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,15,192,192,12,15,192,192,0,51,48,0,0,51,48,0,0,195,12,0,0,195,12,0,15,3,3,192,15,3,3,192,240,3,0,60,240,3,0,60,0,3,0,0,0,3,0,0,
  // 0x6761  条
  97,103,30,32,128,32,0,252,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,255,255,0,0,255,255,0,3,192,12,0,3,192,12,0,60,48,48,0,60,48,48,0,0,15,192,0,0,15,192,0,3,243,63,0,3,243,63,0,252,3,0,252,252,3,0,252,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,195,12,0,0,195,12,0,3,3,3,0,3,3,3,0,12,3,0,192,12,3,0,192,48,51,0,48,48,51,0,48,0,12,0,0,0,12,0,0,
  // 0x6765  来
  101,103,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,3,3,3,0,3,3,3,0,0,195,3,0,0,195,3,0,0,195,12,0,0,195,12,0,255,255,255,252,255,255,255,252,0,15,192,0,0,15,192,0,0,51,48,0,0,51,48,0,0,195,12,0,0,195,12,0,15,3,3,192,15,3,3,192,240,3,0,60,240,3,0,60,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x677f  板
  127,103,30,32,128,32,0,252,3,0,0,192,3,0,0,192,3,0,3,240,3,0,3,240,3,3,252,0,3,3,252,0,3,3,0,0,3,3,0,0,255,243,0,0,255,243,0,0,3,3,255,240,3,3,255,240,15,3,48,48,15,3,48,48,15,195,48,48,15,195,48,48,51,51,48,48,51,51,48,48,51,51,12,192,51,51,12,192,195,3,12,192,195,3,12,192,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,12,12,192,3,12,12,192,3,12,48,48,3,12,48,48,3,48,192,12,3,48,192,12,
  // 0x6797  林
  151,103,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,255,243,255,252,255,243,255,252,3,0,12,0,3,0,12,0,15,0,63,0,15,0,63,0,15,192,63,0,15,192,63,0,51,48,204,192,51,48,204,192,51,0,204,192,51,0,204,192,195,3,12,48,195,3,12,48,3,12,12,12,3,12,12,12,3,48,12,0,3,48,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,
  // 0x67f1  柱
  241,103,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,12,0,3,0,12,0,3,0,0,0,3,0,0,0,3,15,255,252,3,15,255,252,255,240,12,0,255,240,12,0,3,0,12,0,3,0,12,0,15,0,12,0,15,0,12,0,15,192,12,0,15,192,12,0,51,51,255,240,51,51,255,240,51,48,12,0,51,48,12,0,195,0,12,0,195,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,15,255,252,3,15,255,252,3,0,0,0,3,0,0,0,
  // 0x6821  校
  33,104,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,3,255,252,3,3,255,252,255,240,0,0,255,240,0,0,3,0,192,192,3,0,192,192,15,3,0,48,15,3,0,48,15,204,0,12,15,204,0,12,51,48,192,192,51,48,192,192,51,0,192,192,51,0,192,192,195,0,51,0,195,0,51,0,3,0,51,0,3,0,51,0,3,0,12,0,3,0,12,0,3,0,51,0,3,0,51,0,3,0,192,192,3,0,192,192,3,15,0,60,3,15,0,60,
  // 0x683c  格
  60,104,30,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,255,192,3,0,255,192,3,3,0,192,3,3,0,192,255,207,3,0,255,207,3,0,3,48,204,0,3,48,204,0,15,0,48,0,15,0,48,0,15,192,204,0,15,192,204,0,51,51,3,192,51,51,3,192,51,12,0,60,51,12,0,60,195,51,255,192,195,51,255,192,3,3,0,192,3,3,0,192,3,3,0,192,3,3,0,192,3,3,0,192,3,3,0,192,3,3,255,192,3,3,255,192,3,3,0,192,3,3,0,192,
  // 0x68af  梯
  175,104,30,32,128,32,0,252,3,3,0,192,3,3,0,192,3,0,192,192,3,0,192,192,3,0,195,0,3,0,195,0,3,3,255,240,3,3,255,240,255,240,12,48,255,240,12,48,3,0,12,48,3,0,12,48,15,3,255,240,15,3,255,240,15,195,12,0,15,195,12,0,51,51,12,0,51,51,12,0,51,3,255,252,51,3,255,252,195,0,60,12,195,0,60,12,3,0,204,12,3,0,204,12,3,3,12,204,3,3,12,204,3,12,12,48,3,12,12,48,3,48,12,0,3,48,12,0,3,0,12,0,3,0,12,0,
  // 0x68c0  检
  192,104,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,204,0,3,0,204,0,3,0,204,0,3,0,204,0,255,243,3,0,255,243,3,0,3,12,0,192,3,12,0,192,15,51,255,60,15,51,255,60,15,192,0,0,15,192,0,0,51,48,192,192,51,48,192,192,51,0,48,192,51,0,48,192,195,12,48,192,195,12,48,192,3,3,51,0,3,3,51,0,3,3,3,0,3,3,3,0,3,0,12,0,3,0,12,0,3,63,255,252,3,63,255,252,3,0,0,0,3,0,0,0,
  // 0x69fd  槽
  253,105,30,32,128,32,0,252,3,0,195,0,3,0,195,0,3,0,195,0,3,0,195,0,3,63,255,252,3,63,255,252,3,0,195,0,3,0,195,0,255,207,255,240,255,207,255,240,3,12,195,48,3,12,195,48,15,15,255,240,15,15,255,240,15,204,195,48,15,204,195,48,51,63,255,240,51,63,255,240,51,0,0,0,51,0,0,0,195,3,255,192,195,3,255,192,3,3,0,192,3,3,0,192,3,3,255,192,3,3,255,192,3,3,0,192,3,3,0,192,3,3,255,192,3,3,255,192,3,3,0,192,3,3,0,192,
  // 0x6a21  模
  33,106,30,32,128,32,0,252,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,63,255,240,3,63,255,240,3,3,3,0,3,3,3,0,255,240,0,0,255,240,0,0,3,15,255,192,3,15,255,192,15,12,0,192,15,12,0,192,15,207,255,192,15,207,255,192,51,60,0,192,51,60,0,192,51,15,255,192,51,15,255,192,195,0,48,0,195,0,48,0,3,63,255,240,3,63,255,240,3,0,204,0,3,0,204,0,3,3,3,0,3,3,3,0,3,12,0,192,3,12,0,192,3,48,0,60,3,48,0,60,
  // 0x6a59  橙
  89,106,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,63,204,48,3,63,204,48,3,0,204,192,3,0,204,192,3,12,195,12,3,12,195,12,255,195,3,48,255,195,3,48,3,12,0,192,3,12,0,192,15,51,255,48,15,51,255,48,15,192,0,12,15,192,0,12,51,63,255,192,51,63,255,192,51,12,0,192,51,12,0,192,195,12,0,192,195,12,0,192,3,15,255,192,3,15,255,192,3,12,0,192,3,12,0,192,3,3,3,0,3,3,3,0,3,255,255,252,3,255,255,252,3,0,0,0,3,0,0,0,
  // 0x6b62  止
  98,107,30,30,120,32,0,254,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,255,192,3,3,255,192,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,255,255,255,252,255,255,255,252,
  // 0x6b63  正
  99,107,30,28,112,32,0,254,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,255,192,3,3,255,192,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,255,255,255,252,255,255,255,252,
  // 0x6b65  步
  101,107,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,255,192,3,3,255,192,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,0,192,3,3,0,192,3,3,3,0,3,3,3,0,12,3,12,0,12,3,12,0,48,0,240,0,48,0,240,0,0,15,0,0,0,15,0,0,3,240,0,0,3,240,0,0,252,0,0,0,252,0,0,0,
  // 0x6bd4  比
  212,107,26,30,120,32,4,254,0,12,0,0,0,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,3,0,192,12,3,0,192,12,12,0,192,12,12,0,192,12,48,0,192,12,48,0,255,204,192,0,255,204,192,0,192,15,0,0,192,15,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,192,192,12,0,192,195,204,0,192,195,204,0,192,252,12,0,192,252,12,0,192,192,3,255,192,192,3,255,192,
  // 0x6ca1  没
  161,108,30,30,120,32,0,252,12,3,255,0,12,3,255,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,192,3,3,0,192,3,3,0,48,12,3,0,48,12,3,0,51,48,0,252,51,48,0,252,3,192,0,0,3,192,0,0,3,15,255,192,3,15,255,192,12,12,0,192,12,12,0,192,252,3,0,192,252,3,0,192,12,3,3,0,12,3,3,0,12,0,204,0,12,0,204,0,12,0,48,0,12,0,48,0,12,3,207,0,12,3,207,0,0,252,0,252,0,252,0,252,
  // 0x6ce2  波
  226,108,30,32,128,32,0,252,0,0,12,0,0,0,12,0,12,0,12,0,12,0,12,0,3,0,12,0,3,0,12,0,3,15,255,252,3,15,255,252,192,12,12,12,192,12,12,12,48,12,12,48,48,12,12,48,48,204,12,0,48,204,12,0,0,207,255,240,0,207,255,240,3,12,192,48,3,12,192,48,3,12,192,192,3,12,192,192,252,12,48,192,252,12,48,192,12,12,51,0,12,12,51,0,12,12,12,0,12,12,12,0,12,48,51,0,12,48,51,0,12,48,192,192,12,48,192,192,0,195,0,60,0,195,0,60,
  // 0x6ce8  注
  232,108,30,30,120,32,0,254,0,0,192,0,0,0,192,0,12,0,48,0,12,0,48,0,3,0,0,0,3,0,0,0,3,63,255,240,3,63,255,240,192,0,48,0,192,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,3,0,48,0,3,0,48,0,3,15,255,240,3,15,255,240,12,0,48,0,12,0,48,0,252,0,48,0,252,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,255,255,252,12,255,255,252,
  // 0x6d17  洗
  23,109,30,32,128,32,0,252,0,0,48,0,0,0,48,0,12,12,48,0,12,12,48,0,3,12,48,0,3,12,48,0,3,15,255,240,3,15,255,240,192,48,48,0,192,48,48,0,48,192,48,0,48,192,48,0,48,0,48,0,48,0,48,0,3,63,255,252,3,63,255,252,3,3,12,0,3,3,12,0,12,3,12,0,12,3,12,0,252,3,12,0,252,3,12,0,12,3,12,0,12,3,12,0,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,48,3,252,12,48,3,252,0,192,0,0,0,192,0,0,
  // 0x6d3b  活
  59,109,30,32,128,32,0,252,0,0,3,0,0,0,3,0,12,0,63,192,12,0,63,192,3,15,240,0,3,15,240,0,3,0,48,0,3,0,48,0,192,0,48,0,192,0,48,0,48,63,255,252,48,63,255,252,48,0,48,0,48,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,12,15,255,192,12,15,255,192,252,12,0,192,252,12,0,192,12,12,0,192,12,12,0,192,12,12,0,192,12,12,0,192,12,12,0,192,12,12,0,192,12,15,255,192,12,15,255,192,0,12,0,192,0,12,0,192,
  // 0x6d41  流
  65,109,30,32,128,32,0,252,0,0,192,0,0,0,192,0,12,0,48,0,12,0,48,0,3,63,255,252,3,63,255,252,3,0,192,0,3,0,192,0,192,3,3,0,192,3,3,0,48,12,0,192,48,12,0,192,48,63,255,240,48,63,255,240,3,0,0,48,3,0,0,48,3,0,0,0,3,0,0,0,12,12,48,192,12,12,48,192,252,12,48,192,252,12,48,192,12,12,48,192,12,12,48,192,12,12,48,192,12,12,48,192,12,12,48,204,12,12,48,204,12,48,48,204,12,48,48,204,0,192,48,60,0,192,48,60,
  // 0x6d4b  测
  75,109,28,32,128,32,0,252,0,0,0,48,0,0,0,48,12,63,240,48,12,63,240,48,3,48,48,48,3,48,48,48,3,48,51,48,3,48,51,48,192,51,51,48,192,51,51,48,48,51,51,48,48,51,51,48,48,51,51,48,48,51,51,48,3,51,51,48,3,51,51,48,3,51,51,48,3,51,51,48,12,51,51,48,12,51,51,48,252,51,51,48,252,51,51,48,12,3,0,48,12,3,0,48,12,12,192,48,12,12,192,48,12,12,48,48,12,12,48,48,12,48,3,48,12,48,3,48,0,192,0,192,0,192,0,192,
  // 0x6d88  消
  136,109,26,32,128,32,0,252,0,0,48,0,0,0,48,0,12,12,48,192,12,12,48,192,3,3,48,192,3,3,48,192,3,3,51,0,3,3,51,0,192,0,48,0,192,0,48,0,48,15,255,192,48,15,255,192,48,204,0,192,48,204,0,192,0,204,0,192,0,204,0,192,3,15,255,192,3,15,255,192,3,12,0,192,3,12,0,192,252,12,0,192,252,12,0,192,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,12,0,192,12,12,0,192,12,12,12,192,12,12,12,192,0,12,3,0,0,12,3,0,
  // 0x6de1  淡
  225,109,30,32,128,32,0,252,0,0,48,0,0,0,48,0,12,12,48,48,12,12,48,48,3,12,48,48,3,12,48,48,3,48,48,192,3,48,48,192,192,0,204,0,192,0,204,0,48,3,3,0,48,3,3,0,48,60,0,192,48,60,0,192,3,0,48,48,3,0,48,48,3,0,48,0,3,0,48,0,12,12,48,192,12,12,48,192,252,12,48,192,252,12,48,192,12,48,51,0,12,48,51,0,12,0,204,0,12,0,204,0,12,3,3,0,12,3,3,0,12,12,0,192,12,12,0,192,0,240,0,60,0,240,0,60,
  // 0x6df7  混
  247,109,30,30,120,32,0,252,12,63,255,240,12,63,255,240,3,48,0,48,3,48,0,48,3,48,0,48,3,48,0,48,192,63,255,240,192,63,255,240,48,48,0,48,48,48,0,48,48,48,0,48,48,48,0,48,3,63,255,240,3,63,255,240,3,0,0,0,3,0,0,0,12,48,12,0,12,48,12,0,252,48,12,12,252,48,12,12,12,63,204,240,12,63,204,240,12,48,15,0,12,48,15,0,12,48,12,12,12,48,12,12,12,51,204,12,12,51,204,12,0,60,3,252,0,60,3,252,
  // 0x6e05  清
  5,110,30,32,128,32,0,252,12,0,48,0,12,0,48,0,3,0,48,0,3,0,48,0,3,63,255,240,3,63,255,240,0,0,48,0,0,0,48,0,192,15,255,192,192,15,255,192,48,0,48,0,48,0,48,0,48,255,255,252,48,255,255,252,0,192,0,0,0,192,0,0,3,15,255,192,3,15,255,192,3,12,0,192,3,12,0,192,3,15,255,192,3,15,255,192,252,12,0,192,252,12,0,192,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,12,12,192,12,12,12,192,0,12,3,0,0,12,3,0,
  // 0x6e29  温
  41,110,30,28,112,32,0,254,12,15,255,192,12,15,255,192,3,12,0,192,3,12,0,192,3,12,0,192,3,12,0,192,192,15,255,192,192,15,255,192,48,12,0,192,48,12,0,192,48,12,0,192,48,12,0,192,3,15,255,192,3,15,255,192,3,0,0,0,3,0,0,0,12,63,255,240,12,63,255,240,252,48,204,48,252,48,204,48,12,48,204,48,12,48,204,48,12,48,204,48,12,48,204,48,12,48,204,48,12,48,204,48,12,255,255,252,12,255,255,252,
  // 0x6e38  游
  56,110,30,32,128,32,0,252,0,12,3,0,0,12,3,0,12,3,3,0,12,3,3,0,3,3,3,0,3,3,3,0,3,63,207,252,3,63,207,252,192,12,12,0,192,12,12,0,48,12,48,0,48,12,48,0,48,15,207,240,48,15,207,240,3,12,192,48,3,12,192,48,3,12,192,192,3,12,192,192,12,12,192,192,12,12,192,192,252,12,207,252,252,12,207,252,12,12,192,192,12,12,192,192,12,48,192,192,12,48,192,192,12,48,192,192,12,48,192,192,12,195,204,192,12,195,204,192,3,0,3,0,3,0,3,0,
  // 0x6e90  源
  144,110,30,30,120,32,0,252,12,63,255,252,12,63,255,252,3,48,12,0,3,48,12,0,3,48,48,0,3,48,48,0,192,51,255,240,192,51,255,240,48,51,0,48,48,51,0,48,48,51,255,240,48,51,255,240,3,51,0,48,3,51,0,48,3,51,255,240,3,51,255,240,12,51,12,48,12,51,12,48,252,48,12,0,252,48,12,0,12,48,204,192,12,48,204,192,12,195,12,48,12,195,12,48,12,204,12,12,12,204,12,12,15,0,204,0,15,0,204,0,0,0,48,0,0,0,48,0,
  // 0x6ea2  溢
  162,110,30,30,120,32,0,254,0,12,0,192,0,12,0,192,12,3,0,192,12,3,0,192,3,3,3,0,3,3,3,0,3,0,0,0,3,0,0,0,192,63,255,240,192,63,255,240,48,0,0,0,48,0,0,0,48,3,3,0,48,3,3,0,3,12,0,192,3,12,0,192,3,48,0,48,3,48,0,48,12,15,255,192,12,15,255,192,252,12,204,192,252,12,204,192,12,12,204,192,12,12,204,192,12,12,204,192,12,12,204,192,12,12,204,192,12,12,204,192,12,255,255,252,12,255,255,252,
  // 0x6ed1  滑
  209,110,30,30,120,32,0,252,12,15,255,192,12,15,255,192,3,12,0,192,3,12,0,192,3,15,240,192,3,15,240,192,192,12,48,192,192,12,48,192,48,255,255,252,48,255,255,252,48,192,0,12,48,192,0,12,3,15,255,192,3,15,255,192,3,12,0,192,3,12,0,192,12,15,255,192,12,15,255,192,252,12,0,192,252,12,0,192,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,12,0,192,12,12,0,192,12,12,12,192,12,12,12,192,0,12,3,0,0,12,3,0,
  // 0x6f0f  漏
  15,111,30,30,120,32,0,252,48,63,255,252,48,63,255,252,12,48,0,12,12,48,0,12,12,48,0,12,12,48,0,12,0,63,255,252,0,63,255,252,192,48,0,0,192,48,0,0,48,63,255,252,48,63,255,252,51,48,12,0,51,48,12,0,3,63,255,252,3,63,255,252,12,60,12,12,12,60,12,12,252,60,204,204,252,60,204,204,12,204,12,12,12,204,12,12,12,204,204,204,12,204,204,204,15,12,12,12,15,12,12,12,12,12,12,204,12,12,12,204,0,12,0,48,0,12,0,48,
  // 0x6fc0  激
  192,111,30,32,128,32,0,252,0,12,3,0,0,12,3,0,48,48,3,0,48,48,3,0,12,255,195,0,12,255,195,0,12,192,195,0,12,192,195,0,0,255,207,252,0,255,207,252,192,192,204,48,192,192,204,48,48,255,243,48,48,255,243,48,51,48,3,48,51,48,3,48,3,12,3,48,3,12,3,48,12,255,243,48,12,255,243,48,252,48,3,48,252,48,3,48,12,63,192,192,12,63,192,192,12,48,192,192,12,48,192,192,12,192,195,48,12,192,195,48,12,204,195,48,12,204,195,48,3,3,12,12,3,3,12,12,
  // 0x706f  灯
  111,112,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,15,255,252,3,15,255,252,3,0,12,0,3,0,12,0,51,48,12,0,51,48,12,0,51,192,12,0,51,192,12,0,51,0,12,0,51,0,12,0,195,0,12,0,195,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,12,192,12,0,12,192,12,0,12,48,12,0,12,48,12,0,48,48,12,0,48,48,12,0,48,0,204,0,48,0,204,0,192,0,48,0,192,0,48,0,
  // 0x70b9  点
  185,112,28,32,128,32,0,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,15,255,240,0,15,255,240,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,15,255,255,0,15,255,255,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,15,255,255,0,15,255,255,0,0,0,0,0,0,0,0,0,12,48,192,192,12,48,192,192,12,12,48,48,12,12,48,48,48,12,48,48,48,12,48,48,192,0,0,48,192,0,0,48,
  // 0x70ed  热
  237,112,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,255,243,255,192,255,243,255,192,3,0,48,192,3,0,48,192,3,0,48,192,3,0,48,192,3,240,240,192,3,240,240,192,15,0,48,192,15,0,48,192,243,0,204,204,243,0,204,204,3,0,204,204,3,0,204,204,51,3,0,60,51,3,0,60,12,12,0,12,12,12,0,12,0,0,0,0,0,0,0,0,48,192,192,192,48,192,192,192,48,48,48,48,48,48,48,48,192,48,48,48,192,48,48,48,
  // 0x7247  片
  71,114,26,32,128,32,2,252,0,0,192,0,0,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,15,255,255,192,15,255,255,192,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,15,255,240,0,15,255,240,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,192,0,48,0,192,0,48,0,
  // 0x7269  物
  105,114,28,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,51,0,192,0,51,0,192,0,51,0,255,240,51,0,255,240,63,243,51,48,63,243,51,48,51,12,51,48,51,12,51,48,195,0,51,48,195,0,51,48,3,0,195,48,3,0,195,48,3,240,195,48,3,240,195,48,255,3,12,48,255,3,12,48,51,12,12,48,51,12,12,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,48,48,3,0,192,48,3,0,192,48,3,3,12,192,3,3,12,192,3,0,3,0,3,0,3,0,
  // 0x7279  特
  121,114,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,51,0,12,0,51,0,12,0,51,3,255,240,51,3,255,240,63,240,12,0,63,240,12,0,51,0,12,0,51,0,12,0,195,15,255,252,195,15,255,252,3,0,0,192,3,0,0,192,3,240,0,192,3,240,0,192,255,3,255,252,255,3,255,252,51,0,0,192,51,0,0,192,3,0,192,192,3,0,192,192,3,0,48,192,3,0,48,192,3,0,0,192,3,0,0,192,3,0,12,192,3,0,12,192,3,0,3,0,3,0,3,0,
  // 0x7387  率
  135,115,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,12,0,0,0,12,0,0,48,48,48,48,48,48,48,48,12,255,192,192,12,255,192,192,3,3,3,0,3,3,3,0,12,12,48,192,12,12,48,192,48,255,252,48,48,255,252,48,0,0,12,0,0,0,12,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,
  // 0x73af  环
  175,115,30,28,112,32,0,252,255,243,255,252,255,243,255,252,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,63,240,60,192,63,240,60,192,3,0,204,48,3,0,204,48,3,3,12,12,3,3,12,12,3,12,12,12,3,12,12,12,3,0,12,0,3,0,12,0,3,240,12,0,3,240,12,0,252,0,12,0,252,0,12,0,48,0,12,0,48,0,12,0,0,0,12,0,0,0,12,0,
  // 0x7528  用
  40,117,26,30,120,32,0,252,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,48,3,0,192,48,3,0,192,48,3,12,192,48,3,12,192,192,0,3,0,192,0,3,0,
  // 0x7535  电
  53,117,26,32,128,32,4,252,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,255,255,252,0,255,255,252,0,192,48,12,0,192,48,12,0,192,48,12,0,192,48,12,0,192,48,12,0,192,48,12,0,255,255,252,0,255,255,252,0,192,48,12,0,192,48,12,0,192,48,12,0,192,48,12,0,192,48,12,0,192,48,12,0,255,255,252,0,255,255,252,0,192,48,12,192,192,48,12,192,0,48,0,192,0,48,0,192,0,48,0,192,0,48,0,192,0,15,255,192,0,15,255,192,
  // 0x7565  略
  101,117,30,32,128,32,0,252,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,255,192,255,192,255,192,255,192,204,195,0,192,204,195,0,192,204,207,3,0,204,207,3,0,204,240,204,0,204,240,204,0,255,192,48,0,255,192,48,0,204,192,204,0,204,192,204,0,204,195,3,192,204,195,3,192,204,204,0,60,204,204,0,60,204,243,255,192,204,243,255,192,255,195,0,192,255,195,0,192,192,195,0,192,192,195,0,192,0,3,0,192,0,3,0,192,0,3,255,192,0,3,255,192,0,3,0,192,0,3,0,192,
  // 0x767d  白
  125,118,22,32,96,32,4,252,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,255,255,252,255,255,252,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,255,255,252,255,255,252,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,192,0,12,255,255,252,255,255,252,192,0,12,192,0,12,
  // 0x7684  的
  132,118,26,32,128,32,2,252,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,48,0,192,0,48,0,192,0,255,240,255,192,255,240,255,192,192,51,0,192,192,51,0,192,192,51,0,192,192,51,0,192,192,60,0,192,192,60,0,192,192,48,192,192,192,48,192,192,255,240,48,192,255,240,48,192,192,48,48,192,192,48,48,192,192,48,0,192,192,48,0,192,192,48,0,192,192,48,0,192,192,48,0,192,192,48,0,192,255,240,0,192,255,240,0,192,192,48,51,0,192,48,51,0,0,0,12,0,0,0,12,0,
  // 0x76d1  监
  209,118,30,30,120,32,0,254,0,48,48,0,0,48,48,0,12,48,48,0,12,48,48,0,12,48,63,240,12,48,63,240,12,48,48,0,12,48,48,0,12,48,195,0,12,48,195,0,12,48,192,192,12,48,192,192,12,51,0,192,12,51,0,192,0,48,0,0,0,48,0,0,0,0,0,0,0,0,0,0,15,255,255,192,15,255,255,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,255,255,255,252,255,255,255,252,
  // 0x76f4  直
  244,118,30,30,120,32,0,254,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,255,255,255,252,255,255,255,252,
  // 0x7701  省
  1,119,28,32,128,32,0,252,0,3,0,0,0,3,0,0,3,3,3,0,3,3,3,0,3,3,0,192,3,3,0,192,12,3,12,48,12,3,12,48,48,0,240,0,48,0,240,0,0,15,0,0,0,15,0,0,0,240,0,0,0,240,0,0,15,255,255,192,15,255,255,192,243,0,0,192,243,0,0,192,3,255,255,192,3,255,255,192,3,0,0,192,3,0,0,192,3,255,255,192,3,255,255,192,3,0,0,192,3,0,0,192,3,0,0,192,3,0,0,192,3,255,255,192,3,255,255,192,3,0,0,192,3,0,0,192,
  // 0x7720  眠
  32,119,28,30,120,32,2,252,0,15,255,192,0,15,255,192,255,204,0,192,255,204,0,192,192,204,0,192,192,204,0,192,192,204,0,192,192,204,0,192,255,207,255,192,255,207,255,192,192,204,48,0,192,204,48,0,192,204,48,0,192,204,48,0,255,207,255,240,255,207,255,240,192,204,48,0,192,204,48,0,192,204,48,0,192,204,48,0,192,204,12,0,192,204,12,0,255,204,12,48,255,204,12,48,192,204,195,48,192,204,195,48,0,15,0,240,0,15,0,240,0,12,0,48,0,12,0,48,
  // 0x786e  确
  110,120,30,32,128,32,0,252,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,255,240,63,240,255,240,63,240,3,0,192,48,3,0,192,48,3,3,0,192,3,3,0,192,12,12,255,252,12,12,255,252,15,240,195,12,15,240,195,12,60,48,195,12,60,48,195,12,60,48,255,252,60,48,255,252,204,48,195,12,204,48,195,12,12,48,195,12,12,48,195,12,12,48,255,252,12,48,255,252,15,240,195,12,15,240,195,12,12,51,3,12,12,51,3,12,12,3,0,204,12,3,0,204,0,12,0,48,0,12,0,48,
  // 0x79bb  离
  187,121,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,0,0,0,0,0,0,0,3,48,51,0,3,48,51,0,3,15,195,0,3,15,195,0,3,48,51,0,3,48,51,0,3,255,255,0,3,255,255,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,48,12,0,48,48,12,0,48,48,48,48,48,48,48,48,48,48,255,252,48,48,255,252,48,48,48,12,48,48,48,12,48,48,0,3,48,48,0,3,48,48,0,0,192,48,0,0,192,
  // 0x79fb  移
  251,121,30,32,128,32,0,252,0,192,12,0,0,192,12,0,3,240,12,0,3,240,12,0,255,0,63,240,255,0,63,240,3,0,192,48,3,0,192,48,3,3,48,192,3,3,48,192,255,240,15,0,255,240,15,0,3,0,12,0,3,0,12,0,15,0,48,192,15,0,48,192,15,195,195,0,15,195,195,0,51,48,15,252,51,48,15,252,51,48,48,12,51,48,48,12,195,3,204,48,195,3,204,48,3,0,3,192,3,0,3,192,3,0,3,0,3,0,3,0,3,0,60,0,3,0,60,0,3,3,192,0,3,3,192,0,
  // 0x7a7a  空
  122,122,30,30,120,32,0,254,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,192,12,48,192,192,12,48,3,0,3,0,3,0,3,0,12,0,0,192,12,0,0,192,0,0,0,0,0,0,0,0,3,255,255,0,3,255,255,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,
  // 0x7aef  端
  239,122,30,32,128,32,0,252,12,0,12,0,12,0,12,0,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,255,243,12,48,255,243,12,48,0,3,255,240,0,3,255,240,0,192,0,0,0,192,0,0,192,207,255,252,192,207,255,252,192,192,12,0,192,192,12,0,48,192,48,0,48,192,48,0,48,195,255,240,48,195,255,240,51,3,51,48,51,3,51,48,51,3,51,48,51,3,51,48,3,243,51,48,3,243,51,48,252,3,51,48,252,3,51,48,48,3,51,48,48,3,51,48,0,3,0,240,0,3,0,240,
  // 0x7b2c  第
  44,123,30,32,128,32,0,252,12,0,48,0,12,0,48,0,15,255,63,252,15,255,63,252,48,192,195,0,48,192,195,0,192,51,0,192,192,51,0,192,15,255,255,192,15,255,255,192,0,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,15,255,255,192,15,255,255,192,12,3,0,0,12,3,0,0,12,3,0,0,12,3,0,0,15,255,255,240,15,255,255,240,0,15,0,48,0,15,0,48,0,51,0,48,0,51,0,48,3,195,12,192,3,195,12,192,252,3,3,0,252,3,3,0,0,3,0,0,0,3,0,0,
  // 0x7b49  等
  73,123,30,32,128,32,0,252,12,0,48,0,12,0,48,0,15,255,63,252,15,255,63,252,48,192,195,0,48,192,195,0,192,51,0,192,192,51,0,192,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,0,0,0,0,0,0,0,0,0,12,0,0,0,12,0,63,255,255,240,63,255,255,240,0,192,12,0,0,192,12,0,0,48,12,0,0,48,12,0,0,48,204,0,0,48,204,0,0,0,48,0,0,0,48,0,
  // 0x7bb1  箱
  177,123,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,15,255,63,252,15,255,63,252,12,192,195,0,12,192,195,0,48,51,0,192,48,51,0,192,192,192,0,0,192,192,0,0,0,192,255,240,0,192,255,240,63,252,192,48,63,252,192,48,0,192,192,48,0,192,192,48,3,192,255,240,3,192,255,240,3,240,192,48,3,240,192,48,12,204,192,48,12,204,192,48,12,204,255,240,12,204,255,240,48,192,192,48,48,192,192,48,192,192,192,48,192,192,192,48,0,192,255,240,0,192,255,240,
  // 0x7c7b  类
  123,124,30,32,128,32,0,252,0,3,0,0,0,3,0,0,3,3,3,0,3,3,3,0,0,195,12,0,0,195,12,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,51,48,0,0,51,48,0,0,195,12,0,0,195,12,0,3,3,3,0,3,3,3,0,60,0,0,192,60,0,0,192,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,192,12,0,0,192,12,0,15,0,3,192,15,0,3,192,240,0,0,60,240,0,0,60,
  // 0x7d22  索
  34,125,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,12,0,12,48,12,0,12,192,48,12,48,192,48,12,48,3,255,240,0,3,255,240,0,0,3,192,0,0,3,192,0,0,60,3,0,0,60,3,0,15,255,255,192,15,255,255,192,0,3,0,192,0,3,0,192,3,3,12,0,3,3,12,0,12,51,3,0,12,51,3,0,48,12,0,192,48,12,0,192,
  // 0x7d2b  紫
  43,125,28,32,128,32,0,252,0,192,192,0,0,192,192,0,12,192,192,192,12,192,192,192,12,252,255,0,12,252,255,0,12,192,192,48,12,192,192,48,12,252,192,48,12,252,192,48,255,0,63,240,255,0,63,240,0,12,0,0,0,12,0,0,0,48,12,0,0,48,12,0,3,255,240,0,3,255,240,0,0,3,192,0,0,3,192,0,0,60,3,0,0,60,3,0,15,255,255,192,15,255,255,192,0,3,0,192,0,3,0,192,3,3,12,0,3,3,12,0,12,51,3,0,12,51,3,0,48,12,0,192,48,12,0,192,
  // 0x7ea2  红
  162,126,30,30,120,32,0,254,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,3,255,240,12,3,255,240,12,48,12,0,12,48,12,0,48,48,12,0,48,48,12,0,255,192,12,0,255,192,12,0,3,0,12,0,3,0,12,0,12,0,12,0,12,0,12,0,48,0,12,0,48,0,12,0,255,240,12,0,255,240,12,0,48,0,12,0,48,0,12,0,0,0,12,0,0,0,12,0,3,240,12,0,3,240,12,0,252,0,12,0,252,0,12,0,48,15,255,252,48,15,255,252,
  // 0x7ea7  级
  167,126,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,15,255,240,3,15,255,240,12,0,192,48,12,0,192,48,12,0,192,192,12,0,192,192,48,192,192,192,48,192,192,192,255,192,195,0,255,192,195,0,3,0,195,240,3,0,195,240,12,0,192,48,12,0,192,48,48,3,48,48,48,3,48,48,255,195,48,48,255,195,48,48,48,3,12,192,48,3,12,192,0,3,12,192,0,3,12,192,3,204,3,0,3,204,3,0,252,12,12,192,252,12,12,192,48,48,48,48,48,48,48,48,0,3,192,12,0,3,192,12,
  // 0x7ebf  线
  191,126,30,32,128,32,0,252,3,0,51,0,3,0,51,0,3,0,48,192,3,0,48,192,12,0,48,0,12,0,48,0,12,48,51,240,12,48,51,240,48,51,252,0,48,51,252,0,255,192,48,0,255,192,48,0,3,0,51,252,3,0,51,252,12,15,252,0,12,15,252,0,48,0,48,48,48,0,48,48,255,240,48,192,255,240,48,192,48,0,15,0,48,0,15,0,0,0,12,12,0,0,12,12,3,240,51,12,3,240,51,12,252,0,192,204,252,0,192,204,48,15,0,60,48,15,0,60,0,0,0,12,0,0,0,12,
  // 0x7ec6  细
  198,126,28,32,128,32,0,252,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,3,255,240,12,3,255,240,12,51,12,48,12,51,12,48,48,51,12,48,48,51,12,48,255,195,12,48,255,195,12,48,3,3,12,48,3,3,12,48,12,3,12,48,12,3,12,48,48,3,255,240,48,3,255,240,255,243,12,48,255,243,12,48,48,3,12,48,48,3,12,48,0,3,12,48,0,3,12,48,3,243,12,48,3,243,12,48,252,3,12,48,252,3,12,48,48,3,255,240,48,3,255,240,0,3,0,48,0,3,0,48,
  // 0x7ec8  终
  200,126,30,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,192,0,3,0,192,0,12,0,255,192,12,0,255,192,12,3,0,192,12,3,0,192,48,207,3,0,48,207,3,0,255,240,204,0,255,240,204,0,3,0,48,0,3,0,48,0,12,0,204,0,12,0,204,0,48,15,3,192,48,15,3,192,255,240,0,60,255,240,0,60,48,0,240,0,48,0,240,0,0,0,12,0,0,0,12,0,3,192,3,0,3,192,3,0,252,3,192,0,252,3,192,0,48,0,60,0,48,0,60,0,0,0,3,0,0,0,3,0,
  // 0x7ed3  结
  211,126,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,12,0,12,0,12,0,12,0,12,63,255,252,12,63,255,252,48,48,12,0,48,48,12,0,255,192,12,0,255,192,12,0,3,3,255,240,3,3,255,240,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,0,255,243,255,240,255,243,255,240,48,3,0,48,48,3,0,48,0,3,0,48,0,3,0,48,3,243,0,48,3,243,0,48,252,3,0,48,252,3,0,48,48,3,255,240,48,3,255,240,0,3,0,48,0,3,0,48,
  // 0x7ed9  给
  217,126,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,12,0,204,0,12,0,204,0,12,3,3,0,12,3,3,0,48,204,0,192,48,204,0,192,255,48,0,60,255,48,0,60,3,15,255,192,3,15,255,192,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,0,255,207,255,192,255,207,255,192,48,12,0,192,48,12,0,192,0,12,0,192,0,12,0,192,3,204,0,192,3,204,0,192,252,12,0,192,252,12,0,192,48,15,255,192,48,15,255,192,0,12,0,192,0,12,0,192,
  // 0x7edf  统
  223,126,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,12,0,3,0,12,0,12,0,12,0,12,0,12,0,12,15,255,252,12,15,255,252,48,192,48,0,48,192,48,0,255,192,192,192,255,192,192,192,3,3,0,48,3,3,0,48,12,15,255,252,12,15,255,252,48,0,195,12,48,0,195,12,255,192,195,0,255,192,195,0,48,0,195,0,48,0,195,0,0,0,195,0,0,0,195,0,3,195,3,12,3,195,3,12,252,3,3,12,252,3,3,12,48,12,0,252,48,12,0,252,0,48,0,0,0,48,0,0,
  // 0x7ee7  继
  231,126,30,30,120,32,0,254,3,0,12,0,3,0,12,0,3,12,12,0,3,12,12,0,12,12,12,0,12,12,12,0,12,15,12,48,12,15,12,48,48,204,204,192,48,204,204,192,255,12,12,0,255,12,12,0,3,15,255,240,3,15,255,240,12,12,12,0,12,12,12,0,48,12,63,0,48,12,63,0,255,204,204,192,255,204,204,192,48,15,12,48,48,15,12,48,0,12,12,0,0,12,12,0,3,204,12,0,3,204,12,0,252,12,12,0,252,12,12,0,48,15,255,252,48,15,255,252,
  // 0x7eea  绪
  234,126,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,48,3,0,48,48,12,15,255,48,12,15,255,48,12,0,48,192,12,0,48,192,48,192,51,0,48,192,51,0,255,63,255,252,255,63,255,252,3,0,48,0,3,0,48,0,12,0,192,0,12,0,192,0,48,3,255,192,48,3,255,192,255,207,0,192,255,207,0,192,48,51,0,192,48,51,0,192,0,3,255,192,0,3,255,192,3,195,0,192,3,195,0,192,252,3,0,192,252,3,0,192,48,3,255,192,48,3,255,192,0,3,0,192,0,3,0,192,
  // 0x7eed  续
  237,126,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,12,3,255,240,12,3,255,240,12,48,12,0,12,48,12,0,48,48,12,0,48,48,12,0,255,207,255,252,255,207,255,252,3,0,0,12,3,0,0,12,12,0,195,48,12,0,195,48,48,0,51,0,48,0,51,0,255,243,3,0,255,243,3,0,48,0,195,0,48,0,195,0,0,15,255,252,0,15,255,252,3,240,12,192,3,240,12,192,252,0,48,48,252,0,48,48,48,0,192,12,48,0,192,12,0,15,0,12,0,15,0,12,
  // 0x7eff  绿
  255,126,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,3,255,192,3,3,255,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,48,195,255,192,48,195,255,192,255,192,0,192,255,192,0,192,3,0,0,192,3,0,0,192,12,15,255,252,12,15,255,252,48,0,12,0,48,0,12,0,255,204,12,12,255,204,12,12,48,3,63,48,48,3,63,48,0,0,204,192,0,0,204,192,3,195,12,48,3,195,12,48,252,12,12,12,252,12,12,12,48,0,204,0,48,0,204,0,0,0,48,0,0,0,48,0,
  // 0x7f16  编
  22,127,28,32,128,32,0,252,3,0,192,0,3,0,192,0,3,0,48,0,3,0,48,0,12,15,255,240,12,15,255,240,12,12,0,48,12,12,0,48,48,204,0,48,48,204,0,48,255,207,255,240,255,207,255,240,3,12,0,0,3,12,0,0,12,12,0,0,12,12,0,0,48,15,255,240,48,15,255,240,255,207,51,48,255,207,51,48,48,15,51,48,48,15,51,48,0,51,255,240,0,51,255,240,3,243,51,48,3,243,51,48,252,51,51,48,252,51,51,48,48,195,48,48,48,195,48,48,0,3,0,240,0,3,0,240,
  // 0x7f3a  缺
  58,127,30,32,128,32,0,252,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,15,240,12,0,15,240,12,0,51,3,255,240,51,3,255,240,195,0,12,48,195,0,12,48,3,0,12,48,3,0,12,48,255,252,12,48,255,252,12,48,3,0,12,48,3,0,12,48,3,15,255,252,3,15,255,252,51,48,12,0,51,48,12,0,51,48,51,0,51,48,51,0,51,48,51,0,51,48,51,0,51,240,192,192,51,240,192,192,60,48,192,192,60,48,192,192,0,51,0,48,0,51,0,48,0,12,0,12,0,12,0,12,
  // 0x7f51  网
  81,127,26,30,120,32,2,252,255,255,255,192,255,255,255,192,192,0,0,192,192,0,0,192,192,0,0,192,192,0,0,192,192,48,12,192,192,48,12,192,204,51,12,192,204,51,12,192,195,48,204,192,195,48,204,192,192,192,48,192,192,192,48,192,192,192,48,192,192,192,48,192,195,48,204,192,195,48,204,192,195,48,204,192,195,48,204,192,204,51,12,192,204,51,12,192,240,12,0,192,240,12,0,192,192,0,0,192,192,0,0,192,192,0,12,192,192,0,12,192,192,0,3,0,192,0,3,0,
  // 0x7f6e  置
  110,127,30,32,128,32,0,252,63,255,255,240,63,255,255,240,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,12,0,0,0,12,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,255,255,255,252,255,255,255,252,
  // 0x7f72  署
  114,127,30,30,120,32,0,252,15,255,255,192,15,255,255,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,15,255,255,192,15,255,255,192,0,12,0,0,0,12,0,0,3,255,243,0,3,255,243,0,0,12,12,0,0,12,12,0,255,255,255,252,255,255,255,252,0,15,0,0,0,15,0,0,0,255,255,0,0,255,255,0,15,192,3,0,15,192,3,0,240,255,255,0,240,255,255,0,0,192,3,0,0,192,3,0,0,255,255,0,0,255,255,0,0,192,3,0,0,192,3,0,
  // 0x8005  者
  5,128,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,12,0,192,0,12,0,192,15,255,243,0,15,255,243,0,0,12,12,0,0,12,12,0,0,12,48,0,0,12,48,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,0,255,255,0,0,255,255,0,3,192,3,0,3,192,3,0,12,192,3,0,12,192,3,0,48,255,255,0,48,255,255,0,192,192,3,0,192,192,3,0,0,192,3,0,0,192,3,0,0,255,255,0,0,255,255,0,0,192,3,0,0,192,3,0,
  // 0x806a  聪
  106,128,30,32,128,32,0,252,0,0,192,192,0,0,192,192,255,240,48,192,255,240,48,192,48,192,51,0,48,192,51,0,48,195,255,240,48,195,255,240,63,195,0,48,63,195,0,48,48,195,0,48,48,195,0,48,48,195,0,48,48,195,0,48,63,195,255,240,63,195,255,240,48,192,12,0,48,192,12,0,48,192,3,0,48,192,3,0,48,240,51,48,48,240,51,48,63,195,48,12,63,195,48,12,240,195,48,12,240,195,48,12,0,195,48,204,0,195,48,204,0,204,15,192,0,204,15,192,0,192,0,0,0,192,0,0,
  // 0x80fd  能
  253,128,30,32,128,32,0,252,3,0,48,0,3,0,48,0,12,48,48,48,12,48,48,48,48,12,48,192,48,12,48,192,255,255,63,0,255,255,63,0,0,3,48,0,0,3,48,0,0,0,48,12,0,0,48,12,63,252,48,12,63,252,48,12,48,12,15,252,48,12,15,252,48,12,0,0,48,12,0,0,63,252,48,48,63,252,48,48,48,12,48,192,48,12,48,192,48,12,63,0,48,12,63,0,63,252,48,0,63,252,48,0,48,12,48,12,48,12,48,12,48,204,48,12,48,204,48,12,48,48,15,252,48,48,15,252,
  // 0x81ea  自
  234,129,18,32,96,32,6,252,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,255,255,192,255,255,192,192,0,192,192,0,192,192,0,192,192,0,192,192,0,192,192,0,192,255,255,192,255,255,192,192,0,192,192,0,192,192,0,192,192,0,192,255,255,192,255,255,192,192,0,192,192,0,192,192,0,192,192,0,192,192,0,192,192,0,192,255,255,192,255,255,192,192,0,192,192,0,192,
  // 0x81f3  至
  243,129,30,28,112,32,0,254,63,255,255,240,63,255,255,240,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,15,255,255,192,15,255,255,192,0,0,0,192,0,0,0,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,
  // 0x83dc  菜
  220,131,30,32,128,32,0,252,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,255,255,255,252,255,255,255,252,0,192,12,0,0,192,12,0,0,0,3,0,0,0,3,0,0,0,255,192,0,0,255,192,15,255,0,0,15,255,0,0,3,3,3,0,3,3,3,0,0,192,12,0,0,192,12,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,51,48,0,0,51,48,0,0,195,12,0,0,195,12,0,15,3,3,192,15,3,3,192,240,3,0,60,240,3,0,60,0,3,0,0,0,3,0,0,
  // 0x84dd  蓝
  221,132,30,30,120,32,0,254,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,255,255,255,252,255,255,255,252,0,192,12,0,0,192,12,0,0,48,192,0,0,48,192,0,12,48,192,0,12,48,192,0,12,48,255,240,12,48,255,240,12,48,204,0,12,48,204,0,12,51,3,0,12,51,3,0,0,0,0,0,0,0,0,0,15,255,255,192,15,255,255,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,255,255,255,252,255,255,255,252,
  // 0x86c7  蛇
  199,134,30,30,120,32,0,254,3,0,12,0,3,0,12,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,63,243,255,252,63,243,255,252,51,51,0,12,51,51,0,12,51,60,0,48,51,60,0,48,51,48,192,0,51,48,192,0,51,48,192,192,51,48,192,192,63,240,195,0,63,240,195,0,51,0,204,0,51,0,204,0,3,0,240,0,3,0,240,0,3,48,192,12,3,48,192,12,3,252,192,12,3,252,192,12,252,12,192,12,252,12,192,12,48,0,63,252,48,0,63,252,
  // 0x884c  行
  76,136,30,32,128,32,0,252,0,192,0,0,0,192,0,0,0,195,255,240,0,195,255,240,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,0,48,192,0,0,48,192,0,0,0,192,0,0,0,192,0,0,3,15,255,252,3,15,255,252,15,0,12,0,15,0,12,0,51,0,12,0,51,0,12,0,195,0,12,0,195,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,204,0,3,0,204,0,3,0,48,0,3,0,48,0,
  // 0x88ab  被
  171,136,30,32,128,32,0,252,12,0,3,0,12,0,3,0,3,0,3,0,3,0,3,0,0,0,3,0,0,0,3,0,255,195,255,252,255,195,255,252,0,195,3,12,0,195,3,12,3,3,3,48,3,3,3,48,3,51,3,0,3,51,3,0,15,195,255,240,15,195,255,240,51,51,48,48,51,51,48,48,195,3,48,48,195,3,48,48,3,3,12,192,3,3,12,192,3,3,12,192,3,3,12,192,3,3,3,0,3,3,3,0,3,12,12,192,3,12,12,192,3,12,48,48,3,12,48,48,3,48,192,12,3,48,192,12,
  // 0x88c5  装
  197,136,30,32,128,32,0,252,0,192,12,0,0,192,12,0,48,192,12,0,48,192,12,0,12,207,255,252,12,207,255,252,0,192,12,0,0,192,12,0,3,192,12,0,3,192,12,0,12,192,12,0,12,192,12,0,240,195,255,240,240,195,255,240,0,204,0,0,0,204,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,51,0,0,0,51,0,0,0,240,192,192,0,240,192,192,15,48,51,0,15,48,51,0,240,51,15,0,240,51,15,0,0,60,0,252,0,60,0,252,0,48,0,0,0,48,0,0,
  // 0x8981  要
  129,137,26,30,120,32,2,252,255,255,255,192,255,255,255,192,0,192,192,0,0,192,192,0,0,192,192,0,0,192,192,0,63,255,255,0,63,255,255,0,48,192,195,0,48,192,195,0,48,192,195,0,48,192,195,0,63,255,255,0,63,255,255,0,0,48,0,0,0,48,0,0,255,255,255,192,255,255,255,192,0,192,48,0,0,192,48,0,3,0,192,0,3,0,192,0,15,195,0,0,15,195,0,0,0,63,0,0,0,63,0,0,0,240,252,0,0,240,252,0,63,0,3,0,63,0,3,0,
  // 0x89d2  角
  210,137,26,32,128,32,0,252,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,3,255,252,0,3,255,252,0,12,0,12,0,12,0,12,0,48,0,48,0,48,0,48,0,207,255,255,192,207,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,12,3,0,192,12,3,0,192,15,255,255,192,15,255,255,192,12,3,0,192,12,3,0,192,48,3,0,192,48,3,0,192,48,3,12,192,48,3,12,192,192,0,3,0,192,0,3,0,
  // 0x8ba1  计
  161,139,30,32,128,32,0,252,0,0,48,0,0,0,48,0,12,0,48,0,12,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,255,63,255,252,255,63,255,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,48,48,0,3,48,48,0,3,192,48,0,3,192,48,0,3,0,48,0,3,0,48,0,0,0,48,0,0,0,48,0,
  // 0x8bae  议
  174,139,30,32,128,32,0,252,0,0,192,0,0,0,192,0,12,0,48,192,12,0,48,192,3,12,48,192,3,12,48,192,3,12,0,192,3,12,0,192,0,12,0,192,0,12,0,192,0,3,3,0,0,3,3,0,255,3,3,0,255,3,3,0,3,3,3,0,3,3,3,0,3,0,204,0,3,0,204,0,3,0,204,0,3,0,204,0,3,0,48,0,3,0,48,0,3,48,48,0,3,48,48,0,3,192,204,0,3,192,204,0,3,3,3,0,3,3,3,0,0,12,0,192,0,12,0,192,0,240,0,60,0,240,0,60,
  // 0x8bbe  设
  190,139,30,30,120,32,0,252,12,3,255,0,12,3,255,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,0,3,3,0,0,3,3,0,0,12,0,252,0,12,0,252,255,48,0,0,255,48,0,0,3,15,255,192,3,15,255,192,3,3,0,192,3,3,0,192,3,3,3,0,3,3,3,0,3,0,195,0,3,0,195,0,3,48,204,0,3,48,204,0,3,192,48,0,3,192,48,0,3,0,204,0,3,0,204,0,0,15,3,192,0,15,3,192,0,240,0,60,0,240,0,60,
  // 0x8bd5  试
  213,139,30,32,128,32,0,252,0,0,12,192,0,0,12,192,12,0,12,48,12,0,12,48,3,0,12,48,3,0,12,48,3,0,12,0,3,0,12,0,0,63,255,252,0,63,255,252,0,0,12,0,0,0,12,0,255,0,12,0,255,0,12,0,3,63,252,0,3,63,252,0,3,3,12,0,3,3,12,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,51,3,0,3,51,3,0,3,195,240,204,3,195,240,204,3,63,0,204,3,63,0,204,0,12,0,60,0,12,0,60,0,0,0,12,0,0,0,12,
  // 0x8bef  误
  239,139,30,30,120,32,0,252,48,15,255,192,48,15,255,192,12,12,0,192,12,12,0,192,12,12,0,192,12,12,0,192,0,15,255,192,0,15,255,192,0,0,0,0,0,0,0,0,252,63,255,240,252,63,255,240,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,255,255,252,12,255,255,252,12,0,48,0,12,0,48,0,12,0,204,0,12,0,204,0,12,192,204,0,12,192,204,0,15,3,3,0,15,3,3,0,12,12,0,192,12,12,0,192,0,48,0,60,0,48,0,60,
  // 0x8bf7  请
  247,139,30,32,128,32,0,252,0,0,48,0,0,0,48,0,48,0,48,0,48,0,48,0,12,63,255,240,12,63,255,240,12,0,48,0,12,0,48,0,0,15,255,192,0,15,255,192,0,0,48,0,0,0,48,0,252,63,255,252,252,63,255,252,12,0,0,0,12,0,0,0,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,207,255,192,12,207,255,192,15,12,0,192,15,12,0,192,12,12,12,192,12,12,12,192,0,12,3,0,0,12,3,0,
  // 0x8bfb  读
  251,139,30,32,128,32,0,252,0,0,12,0,0,0,12,0,12,0,12,0,12,0,12,0,3,3,255,240,3,3,255,240,3,0,12,0,3,0,12,0,0,0,12,0,0,0,12,0,0,15,255,252,0,15,255,252,255,0,0,12,255,0,0,12,3,0,195,48,3,0,195,48,3,0,51,0,3,0,51,0,3,3,3,0,3,3,3,0,3,0,195,0,3,0,195,0,3,15,255,252,3,15,255,252,3,48,12,192,3,48,12,192,3,192,48,48,3,192,48,48,3,0,192,12,3,0,192,12,0,15,0,12,0,15,0,12,
  // 0x8c03  调
  3,140,28,30,120,32,0,252,48,63,255,240,48,63,255,240,12,48,48,48,12,48,48,48,12,48,48,48,12,48,48,48,0,51,255,48,0,51,255,48,0,48,48,48,0,48,48,48,252,48,48,48,252,48,48,48,12,63,255,240,12,63,255,240,12,48,0,48,12,48,0,48,12,51,255,48,12,51,255,48,12,51,3,48,12,51,3,48,12,243,3,48,12,243,3,48,15,51,255,48,15,51,255,48,12,48,0,48,12,48,0,48,0,48,3,48,0,48,3,48,0,192,0,192,0,192,0,192,
  // 0x8d25  败
  37,141,30,32,128,32,0,252,0,0,48,0,0,0,48,0,63,240,48,0,63,240,48,0,48,48,48,0,48,48,48,0,51,48,192,0,51,48,192,0,51,48,255,252,51,48,255,252,51,51,0,192,51,51,0,192,51,60,192,192,51,60,192,192,51,48,192,192,51,48,192,192,51,48,192,192,51,48,192,192,51,48,51,0,51,48,51,0,51,48,51,0,51,48,51,0,3,0,12,0,3,0,12,0,12,192,51,0,12,192,51,0,12,48,192,192,12,48,192,192,48,51,0,48,48,51,0,48,192,12,0,12,192,12,0,12,
  // 0x8d2a  贪
  42,141,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,48,48,0,0,48,48,0,0,195,12,0,0,195,12,0,15,0,195,192,15,0,195,192,240,255,252,60,240,255,252,60,0,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,0,12,60,0,0,12,60,0,0,240,3,192,0,240,3,192,63,0,0,48,63,0,0,48,
  // 0x8d77  起
  119,141,30,32,128,32,0,252,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,255,192,0,192,255,192,63,252,0,192,63,252,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,255,252,255,192,255,252,255,192,0,192,192,192,0,192,192,192,12,192,192,0,12,192,192,0,12,192,192,0,12,192,192,0,12,252,192,48,12,252,192,48,12,192,192,48,12,192,192,48,12,192,63,240,12,192,63,240,51,192,0,0,51,192,0,0,48,255,255,252,48,255,255,252,192,0,0,0,192,0,0,0,
  // 0x8d85  超
  133,141,30,32,128,32,0,252,0,192,0,0,0,192,0,0,0,195,255,240,0,195,255,240,0,192,48,48,0,192,48,48,63,252,48,48,63,252,48,48,0,192,48,48,0,192,48,48,0,192,195,48,0,192,195,48,255,255,0,192,255,255,0,192,0,192,255,240,0,192,255,240,12,192,192,48,12,192,192,48,12,192,192,48,12,192,192,48,12,252,192,48,12,252,192,48,12,192,255,240,12,192,255,240,12,192,0,0,12,192,0,0,51,192,0,0,51,192,0,0,48,255,255,252,48,255,255,252,192,0,0,0,192,0,0,0,
  // 0x8ddd  距
  221,141,30,28,112,32,0,254,63,243,255,252,63,243,255,252,48,51,0,0,48,51,0,0,48,51,0,0,48,51,0,0,48,51,0,0,48,51,0,0,63,243,255,240,63,243,255,240,3,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,51,243,0,48,51,243,0,48,51,3,0,48,51,3,0,48,51,3,255,240,51,3,255,240,51,3,0,0,51,3,0,0,51,243,0,0,51,243,0,0,252,3,0,0,252,3,0,0,0,3,255,252,0,3,255,252,
  // 0x8f6c  转
  108,143,30,32,128,32,0,252,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,243,255,240,255,243,255,240,48,0,12,0,48,0,12,0,51,0,48,0,51,0,48,0,195,15,255,252,195,15,255,252,255,240,48,0,255,240,48,0,3,0,192,0,3,0,192,0,3,3,255,240,3,3,255,240,3,240,0,48,3,240,0,48,255,0,192,192,255,0,192,192,51,0,51,0,51,0,51,0,3,0,12,0,3,0,12,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x8f6f  软
  111,143,30,32,128,32,0,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,255,252,63,240,255,252,63,240,12,0,192,48,12,0,192,48,12,192,192,192,12,192,192,192,48,195,12,0,48,195,12,0,63,252,12,0,63,252,12,0,0,192,12,0,0,192,12,0,0,192,51,0,0,192,51,0,0,252,51,0,0,252,51,0,255,192,51,0,255,192,51,0,48,192,192,192,48,192,192,192,0,192,192,192,0,192,192,192,0,195,0,48,0,195,0,48,0,204,0,12,0,204,0,12,
  // 0x8f74  轴
  116,143,28,32,128,32,0,252,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,240,12,0,255,240,12,0,48,3,255,240,48,3,255,240,51,3,12,48,51,3,12,48,195,3,12,48,195,3,12,48,255,243,12,48,255,243,12,48,3,3,12,48,3,3,12,48,3,3,255,240,3,3,255,240,3,243,12,48,3,243,12,48,255,3,12,48,255,3,12,48,51,3,12,48,51,3,12,48,3,3,12,48,3,3,12,48,3,3,255,240,3,3,255,240,3,3,0,48,3,3,0,48,
  // 0x8f7d  载
  125,143,30,32,128,32,0,252,0,192,12,0,0,192,12,0,0,192,12,192,0,192,12,192,63,255,12,48,63,255,12,48,0,192,12,0,0,192,12,0,255,255,255,252,255,255,255,252,3,0,12,0,3,0,12,0,3,0,12,48,3,0,12,48,255,255,12,48,255,255,12,48,12,0,12,48,12,0,12,48,48,192,12,192,48,192,12,192,63,255,12,192,63,255,12,192,0,192,3,0,0,192,3,0,0,255,3,12,0,255,3,12,255,192,12,204,255,192,12,204,0,192,48,60,0,192,48,60,0,192,192,12,0,192,192,12,
  // 0x8f91  辑
  145,143,30,32,128,32,0,252,12,0,0,0,12,0,0,0,12,3,255,192,12,3,255,192,12,3,0,192,12,3,0,192,255,243,0,192,255,243,0,192,48,3,255,192,48,3,255,192,51,0,0,0,51,0,0,0,195,63,255,252,195,63,255,252,255,243,0,192,255,243,0,192,3,3,255,192,3,3,255,192,3,3,0,192,3,3,0,192,3,243,255,192,3,243,255,192,255,3,0,192,255,3,0,192,51,3,15,252,51,3,15,252,3,63,240,192,3,63,240,192,3,0,0,192,3,0,0,192,3,0,0,192,3,0,0,192,
  // 0x8f93  输
  147,143,30,32,128,32,0,252,12,0,48,0,12,0,48,0,12,0,204,0,12,0,204,0,12,3,3,0,12,3,3,0,255,204,0,192,255,204,0,192,12,51,255,60,12,51,255,60,48,0,0,0,48,0,0,0,51,15,240,48,51,15,240,48,195,12,51,48,195,12,51,48,255,204,51,48,255,204,51,48,3,15,243,48,3,15,243,48,3,204,51,48,3,204,51,48,255,12,51,48,255,12,51,48,51,15,243,48,51,15,243,48,3,12,48,48,3,12,48,48,3,12,51,48,3,12,51,48,3,12,240,192,3,12,240,192,
  // 0x8fb9  边
  185,143,30,30,120,32,0,254,0,0,48,0,0,0,48,0,12,0,48,0,12,0,48,0,3,0,48,0,3,0,48,0,3,15,255,240,3,15,255,240,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,255,0,48,48,255,0,48,48,3,0,192,48,3,0,192,48,3,0,192,48,3,0,192,48,3,3,0,48,3,3,0,48,3,3,0,48,3,3,0,48,3,12,12,192,3,12,12,192,3,48,3,0,3,48,3,0,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x8fc1  迁
  193,143,30,30,120,32,0,254,0,0,3,0,0,0,3,0,12,0,63,192,12,0,63,192,3,15,240,0,3,15,240,0,3,0,48,0,3,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,255,63,255,252,255,63,255,252,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x8fd0  运
  208,143,30,28,112,32,0,254,12,15,255,192,12,15,255,192,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,63,255,240,0,63,255,240,255,0,48,0,255,0,48,0,3,0,192,0,3,0,192,0,3,3,3,0,3,3,3,0,3,12,0,192,3,12,0,192,3,63,255,240,3,63,255,240,3,12,0,48,3,12,0,48,3,0,0,0,3,0,0,0,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x8fd1  近
  209,143,30,30,120,32,0,254,0,0,0,192,0,0,0,192,12,0,3,240,12,0,3,240,3,3,252,0,3,3,252,0,3,3,0,0,3,3,0,0,0,3,0,0,0,3,0,0,0,3,255,252,0,3,255,252,255,3,3,0,255,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,12,3,0,3,12,3,0,3,12,3,0,3,12,3,0,3,48,3,0,3,48,3,0,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x8fd4  返
  212,143,30,30,120,32,0,254,0,0,0,192,0,0,0,192,12,0,15,240,12,0,15,240,3,15,240,0,3,15,240,0,3,12,0,0,3,12,0,0,0,12,0,0,0,12,0,0,0,15,255,240,0,15,255,240,255,12,0,48,255,12,0,48,3,12,192,192,3,12,192,192,3,12,51,0,3,12,51,0,3,12,12,0,3,12,12,0,3,12,51,0,3,12,51,0,3,48,192,192,3,48,192,192,3,51,0,48,3,51,0,48,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x8fd8  还
  216,143,30,28,112,32,0,254,12,15,255,240,12,15,255,240,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,255,0,243,0,255,0,243,0,3,3,48,192,3,3,48,192,3,12,48,48,3,12,48,48,3,48,48,48,3,48,48,48,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x8fdb  进
  219,143,30,30,120,32,0,254,0,0,195,0,0,0,195,0,12,0,195,0,12,0,195,0,3,0,195,0,3,0,195,0,3,15,255,240,3,15,255,240,0,0,195,0,0,0,195,0,0,0,195,0,0,0,195,0,255,0,195,0,255,0,195,0,3,63,255,252,3,63,255,252,3,0,195,0,3,0,195,0,3,0,195,0,3,0,195,0,3,3,3,0,3,3,3,0,3,3,3,0,3,3,3,0,3,12,3,0,3,12,3,0,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x8fde  连
  222,143,30,30,120,32,0,254,0,0,48,0,0,0,48,0,12,0,48,0,12,0,48,0,3,63,255,252,3,63,255,252,3,0,192,0,3,0,192,0,0,0,204,0,0,0,204,0,0,3,12,0,0,3,12,0,255,15,255,240,255,15,255,240,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,63,255,252,3,63,255,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,12,192,12,0,12,192,12,0,48,63,255,252,48,63,255,252,
  // 0x8ff7  迷
  247,143,30,30,120,32,0,254,0,0,48,0,0,0,48,0,12,12,48,192,12,12,48,192,3,3,48,192,3,3,48,192,3,3,51,0,3,3,51,0,0,0,48,0,0,0,48,0,0,63,255,240,0,63,255,240,255,0,48,0,255,0,48,0,3,0,252,0,3,0,252,0,3,3,51,0,3,3,51,0,3,12,48,192,3,12,48,192,3,48,48,48,3,48,48,48,3,0,48,0,3,0,48,0,3,0,48,0,3,0,48,0,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x9000  退
  0,144,30,30,120,32,0,254,0,15,255,192,0,15,255,192,12,12,0,192,12,12,0,192,3,12,0,192,3,12,0,192,3,15,255,192,3,15,255,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,255,15,255,192,255,15,255,192,3,12,48,48,3,12,48,48,3,12,12,192,3,12,12,192,3,12,3,0,3,12,3,0,3,12,192,192,3,12,192,192,3,15,0,48,3,15,0,48,3,12,0,48,3,12,0,48,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x9009  选
  9,144,30,30,120,32,0,254,0,0,48,0,0,0,48,0,12,12,48,0,12,12,48,0,3,12,48,0,3,12,48,0,3,15,255,192,3,15,255,192,0,48,48,0,0,48,48,0,0,0,48,0,0,0,48,0,255,63,255,240,255,63,255,240,3,3,12,0,3,3,12,0,3,3,12,0,3,3,12,0,3,3,12,0,3,3,12,0,3,12,12,48,3,12,12,48,3,12,12,48,3,12,12,48,3,48,3,240,3,48,3,240,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x901f  速
  31,144,30,30,120,32,0,254,0,0,48,0,0,0,48,0,12,0,48,0,12,0,48,0,3,63,255,240,3,63,255,240,3,0,48,0,3,0,48,0,0,15,255,192,0,15,255,192,0,12,48,192,0,12,48,192,255,12,48,192,255,12,48,192,3,15,255,192,3,15,255,192,3,0,252,0,3,0,252,0,3,3,51,0,3,3,51,0,3,12,48,192,3,12,48,192,3,48,48,48,3,48,48,48,3,0,48,0,3,0,48,0,12,192,0,0,12,192,0,0,48,63,255,252,48,63,255,252,
  // 0x90e8  部
  232,144,30,32,128,32,0,252,3,0,0,0,3,0,0,0,0,192,15,252,0,192,15,252,63,255,204,12,63,255,204,12,0,0,12,48,0,0,12,48,12,3,12,48,12,3,12,48,3,12,12,192,3,12,12,192,255,255,252,48,255,255,252,48,0,0,12,48,0,0,12,48,0,0,12,12,0,0,12,12,15,255,12,12,15,255,12,12,12,3,12,12,12,3,12,12,12,3,15,48,12,3,15,48,12,3,12,192,12,3,12,192,15,255,12,0,15,255,12,0,12,3,12,0,12,3,12,0,0,0,12,0,0,0,12,0,
  // 0x914d  配
  77,145,30,30,120,32,0,252,255,252,0,0,255,252,0,0,12,192,255,192,12,192,255,192,12,192,0,192,12,192,0,192,255,252,0,192,255,252,0,192,204,204,0,192,204,204,0,192,204,204,0,192,204,204,0,192,204,204,255,192,204,204,255,192,204,252,192,192,204,252,192,192,240,12,192,0,240,12,192,0,192,12,192,0,192,12,192,0,255,252,192,0,255,252,192,0,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,255,252,63,252,255,252,63,252,192,12,0,0,192,12,0,0,
  // 0x91ca  释
  202,145,30,32,128,32,0,252,0,240,0,0,0,240,0,0,255,15,255,240,255,15,255,240,3,3,0,48,3,3,0,48,51,48,192,192,51,48,192,192,15,192,51,0,15,192,51,0,3,0,12,0,3,0,12,0,255,240,243,192,255,240,243,192,3,15,12,60,3,15,12,60,15,0,12,0,15,0,12,0,15,195,255,240,15,195,255,240,51,48,12,0,51,48,12,0,51,0,12,0,51,0,12,0,195,15,255,252,195,15,255,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,
  // 0x91cd  重
  205,145,30,30,120,32,0,254,0,0,3,0,0,0,3,0,0,0,255,192,0,0,255,192,15,255,0,0,15,255,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,
  // 0x91cf  量
  207,145,30,30,120,32,0,252,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,255,255,255,252,255,255,255,252,0,0,0,0,0,0,0,0,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,0,3,0,0,0,3,0,0,3,255,255,0,3,255,255,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,
  // 0x9488  针
  136,148,30,32,128,32,0,252,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,252,12,0,3,252,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,63,240,12,0,63,240,12,0,195,15,255,252,195,15,255,252,3,0,12,0,3,0,12,0,255,252,12,0,255,252,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,12,12,0,3,12,12,0,3,48,12,0,3,48,12,0,3,192,12,0,3,192,12,0,3,0,12,0,3,0,12,0,0,0,12,0,0,0,12,0,
  // 0x94ae  钮
  174,148,30,30,120,32,0,254,3,0,0,0,3,0,0,0,3,3,255,192,3,3,255,192,15,240,48,192,15,240,48,192,12,0,48,192,12,0,48,192,48,0,48,192,48,0,48,192,207,240,48,192,207,240,48,192,3,0,48,192,3,0,48,192,3,3,255,192,3,3,255,192,255,240,192,192,255,240,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,48,192,192,3,48,192,192,3,192,192,192,3,192,192,192,3,15,255,252,3,15,255,252,
  // 0x9519  错
  25,149,30,32,128,32,0,252,12,3,3,0,12,3,3,0,12,3,3,0,12,3,3,0,15,195,3,0,15,195,3,0,12,63,255,240,12,63,255,240,48,3,3,0,48,3,3,0,63,195,3,0,63,195,3,0,204,255,255,252,204,255,255,252,12,0,0,0,12,0,0,0,255,207,255,192,255,207,255,192,12,12,0,192,12,12,0,192,12,12,0,192,12,12,0,192,12,15,255,192,12,15,255,192,12,204,0,192,12,204,0,192,15,12,0,192,15,12,0,192,12,15,255,192,12,15,255,192,0,12,0,192,0,12,0,192,
  // 0x955c  镜
  92,149,30,32,128,32,0,252,12,0,192,0,12,0,192,0,12,0,48,0,12,0,48,0,15,207,255,192,15,207,255,192,12,3,3,0,12,3,3,0,48,0,204,0,48,0,204,0,63,63,255,252,63,63,255,252,204,0,0,0,204,0,0,0,12,15,255,192,12,15,255,192,255,204,0,192,255,204,0,192,12,15,255,192,12,15,255,192,12,12,0,192,12,12,0,192,12,15,255,192,12,15,255,192,12,195,12,0,12,195,12,0,15,3,12,12,15,3,12,12,12,12,12,12,12,12,12,12,0,240,3,252,0,240,3,252,
  // 0x957f  长
  127,149,30,32,128,32,0,252,0,192,0,0,0,192,0,0,0,192,3,0,0,192,3,0,0,192,12,0,0,192,12,0,0,192,48,0,0,192,48,0,0,192,192,0,0,192,192,0,0,195,0,0,0,195,0,0,0,192,0,0,0,192,0,0,255,255,255,252,255,255,255,252,0,204,0,0,0,204,0,0,0,195,0,0,0,195,0,0,0,192,192,0,0,192,192,0,0,192,48,0,0,192,48,0,0,195,12,0,0,195,12,0,0,204,3,192,0,204,3,192,0,240,0,60,0,240,0,60,0,192,0,0,0,192,0,0,
  // 0x95ed  闭
  237,149,26,32,128,32,2,252,48,0,0,0,48,0,0,0,12,255,255,192,12,255,255,192,0,0,0,192,0,0,0,192,192,3,0,192,192,3,0,192,192,3,0,192,192,3,0,192,207,255,252,192,207,255,252,192,192,3,0,192,192,3,0,192,192,15,0,192,192,15,0,192,192,51,0,192,192,51,0,192,192,195,0,192,192,195,0,192,195,3,0,192,195,3,0,192,204,3,0,192,204,3,0,192,192,51,0,192,192,51,0,192,192,12,0,192,192,12,0,192,192,0,12,192,192,0,12,192,192,0,3,0,192,0,3,0,
  // 0x95f2  闲
  242,149,26,32,128,32,2,252,48,0,0,0,48,0,0,0,12,255,255,192,12,255,255,192,0,0,0,192,0,0,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,207,255,252,192,207,255,252,192,192,12,0,192,192,12,0,192,192,63,0,192,192,63,0,192,192,204,192,192,192,204,192,192,195,12,48,192,195,12,48,192,204,12,12,192,204,12,12,192,192,12,0,192,192,12,0,192,192,12,0,192,192,12,0,192,192,0,12,192,192,0,12,192,192,0,3,0,192,0,3,0,
  // 0x95f4  间
  244,149,26,32,128,32,2,252,48,0,0,0,48,0,0,0,12,63,255,192,12,63,255,192,12,0,0,192,12,0,0,192,192,0,0,192,192,0,0,192,192,255,192,192,192,255,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,255,192,192,192,255,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,255,192,192,192,255,192,192,192,0,0,192,192,0,0,192,192,0,12,192,192,0,12,192,192,0,3,0,192,0,3,0,
  // 0x9608  阈
  8,150,26,32,128,32,2,252,48,0,0,0,48,0,0,0,12,255,255,192,12,255,255,192,0,3,0,192,0,3,0,192,192,3,48,192,192,3,48,192,192,3,12,192,192,3,12,192,207,255,252,192,207,255,252,192,192,3,0,192,192,3,0,192,195,243,48,192,195,243,48,192,195,51,48,192,195,51,48,192,195,243,48,192,195,243,48,192,192,3,192,192,192,3,192,192,192,240,204,192,192,240,204,192,207,3,60,192,207,3,60,192,192,12,12,192,192,12,12,192,192,48,0,192,192,48,0,192,192,0,3,192,192,0,3,192,
  // 0x964d  降
  77,150,28,32,128,32,2,252,0,3,0,0,0,3,0,0,255,195,0,0,255,195,0,0,192,195,255,192,192,195,255,192,195,12,3,0,195,12,3,0,195,51,12,0,195,51,12,0,204,0,240,0,204,0,240,0,195,15,15,0,195,15,15,0,195,240,48,240,195,240,48,240,192,192,48,0,192,192,48,0,192,207,255,192,192,207,255,192,192,192,48,0,192,192,48,0,243,48,48,0,243,48,48,0,204,63,255,240,204,63,255,240,192,0,48,0,192,0,48,0,192,0,48,0,192,0,48,0,192,0,48,0,192,0,48,0,
  // 0x9650  限
  80,150,28,30,120,32,2,252,255,63,255,0,255,63,255,0,195,48,3,0,195,48,3,0,204,48,3,0,204,48,3,0,204,63,255,0,204,63,255,0,240,48,3,0,240,48,3,0,204,48,3,0,204,48,3,0,195,63,255,0,195,63,255,0,195,48,192,192,195,48,192,192,195,48,195,0,195,48,195,0,243,48,60,0,243,48,60,0,204,48,48,0,204,48,48,0,192,48,12,0,192,48,12,0,192,51,3,0,192,51,3,0,192,60,0,240,192,60,0,240,192,48,0,0,192,48,0,0,
  // 0x9664  除
  100,150,28,30,120,32,2,252,255,0,192,0,255,0,192,0,195,0,192,0,195,0,192,0,204,3,48,0,204,3,48,0,204,12,12,0,204,12,12,0,240,48,3,0,240,48,3,0,204,207,252,240,204,207,252,240,195,0,192,0,195,0,192,0,195,0,192,0,195,0,192,0,195,63,255,192,195,63,255,192,243,0,192,0,243,0,192,0,204,12,204,0,204,12,204,0,192,48,195,0,192,48,195,0,192,192,192,192,192,192,192,192,192,12,192,192,192,12,192,192,192,3,0,0,192,3,0,0,
  // 0x9669  险
  105,150,28,32,128,32,2,252,0,0,192,0,0,0,192,0,255,0,192,0,255,0,192,0,195,3,48,0,195,3,48,0,204,3,48,0,204,3,48,0,204,12,12,0,204,12,12,0,240,48,3,0,240,48,3,0,204,207,252,240,204,207,252,240,195,0,0,0,195,0,0,0,195,3,3,0,195,3,3,0,195,0,195,0,195,0,195,0,243,48,195,0,243,48,195,0,204,12,204,0,204,12,204,0,192,12,12,0,192,12,12,0,192,0,48,0,192,0,48,0,192,255,255,240,192,255,255,240,192,0,0,0,192,0,0,0,
  // 0x96f6  零
  246,150,30,32,128,32,0,252,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,3,0,12,48,3,0,12,195,243,63,48,195,243,63,48,0,3,0,0,0,3,0,0,3,243,63,0,3,243,63,0,0,12,192,0,0,12,192,0,0,240,60,0,0,240,60,0,15,12,3,192,15,12,3,192,240,3,0,60,240,3,0,60,3,255,252,0,3,255,252,0,0,0,12,0,0,0,12,0,0,60,48,0,0,60,48,0,0,3,192,0,0,3,192,0,0,0,48,0,0,0,48,0,
  // 0x9700  需
  0,151,30,30,120,32,0,252,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,3,0,12,48,3,0,12,195,243,63,48,195,243,63,48,0,3,0,0,0,3,0,0,3,243,63,0,3,243,63,0,0,0,0,0,0,0,0,0,255,255,255,252,255,255,255,252,0,12,0,0,0,12,0,0,15,255,255,192,15,255,255,192,12,48,192,192,12,48,192,192,12,48,192,192,12,48,192,192,12,48,204,192,12,48,204,192,12,0,3,0,12,0,3,0,
  // 0x9752  青
  82,151,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,0,0,0,0,0,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,0,51,0,3,0,51,0,3,0,12,0,3,0,12,0,
  // 0x975e  非
  94,151,30,32,128,32,0,252,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,255,240,63,252,255,240,63,252,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,63,240,63,240,63,240,63,240,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,255,240,63,252,255,240,63,252,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,
  // 0x9760  靠
  96,151,30,32,128,32,0,252,3,3,0,0,3,3,0,0,3,255,255,0,3,255,255,0,12,3,0,0,12,3,0,0,255,255,255,252,255,255,255,252,0,0,0,0,0,0,0,0,3,255,255,0,3,255,255,0,3,0,3,0,3,0,3,0,3,255,255,0,3,255,255,0,0,48,48,0,0,48,48,0,63,240,63,240,63,240,63,240,0,48,48,0,0,48,48,0,15,240,63,192,15,240,63,192,0,48,48,0,0,48,48,0,63,240,63,240,63,240,63,240,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,
  // 0x9762  面
  98,151,30,30,120,32,0,252,255,255,255,252,255,255,255,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,15,255,255,192,15,255,255,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,63,240,192,12,63,240,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,63,240,192,12,63,240,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,15,255,255,192,15,255,255,192,12,0,0,192,12,0,0,192,
  // 0x9875  页
  117,152,26,30,120,32,2,252,255,255,255,192,255,255,255,192,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,15,255,252,0,15,255,252,0,12,0,12,0,12,0,12,0,12,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,12,12,12,0,12,51,12,0,12,51,12,0,0,48,192,0,0,48,192,0,0,192,48,0,0,192,48,0,15,0,12,0,15,0,12,0,240,0,3,0,240,0,3,0,
  // 0x9879  项
  121,152,30,30,120,32,0,252,0,3,255,252,0,3,255,252,0,0,12,0,0,0,12,0,255,240,48,0,255,240,48,0,3,3,255,240,3,3,255,240,3,3,0,48,3,3,0,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,3,12,48,3,243,48,48,3,243,48,48,252,0,51,0,252,0,51,0,48,0,192,192,48,0,192,192,0,3,0,48,0,3,0,48,0,12,0,12,0,12,0,12,
  // 0x9884  预
  132,152,30,30,120,32,0,252,255,195,255,252,255,195,255,252,0,192,12,0,0,192,12,0,51,0,48,0,51,0,48,0,12,3,255,240,12,3,255,240,3,3,0,48,3,3,0,48,255,243,12,48,255,243,12,48,12,51,12,48,12,51,12,48,12,195,12,48,12,195,12,48,12,3,12,48,12,3,12,48,12,3,12,48,12,3,12,48,12,3,48,48,12,3,48,48,12,0,51,0,12,0,51,0,12,0,192,192,12,0,192,192,204,3,0,48,204,3,0,48,48,12,0,12,48,12,0,12,
  // 0x9891  频
  145,152,30,32,128,32,0,252,3,0,0,0,3,0,0,0,3,3,255,252,3,3,255,252,51,0,12,0,51,0,12,0,51,240,48,0,51,240,48,0,51,3,255,240,51,3,255,240,51,3,0,48,51,3,0,48,255,255,12,48,255,255,12,48,0,3,12,48,0,3,12,48,3,3,12,48,3,3,12,48,51,51,12,48,51,51,12,48,51,51,12,48,51,51,12,48,51,51,48,48,51,51,48,48,192,48,51,0,192,48,51,0,0,192,192,192,0,192,192,192,15,3,0,48,15,3,0,48,240,12,0,12,240,12,0,12,
  // 0x989d  额
  157,152,30,32,128,32,0,252,3,0,0,0,3,0,0,0,0,192,255,252,0,192,255,252,63,255,3,0,63,255,3,0,48,3,12,0,48,3,12,0,3,0,63,240,3,0,63,240,3,252,48,48,3,252,48,48,12,12,51,48,12,12,51,48,51,48,51,48,51,48,51,48,0,192,51,48,0,192,51,48,3,48,51,48,3,48,51,48,12,12,51,48,12,12,51,48,63,255,51,48,63,255,51,48,204,12,12,192,204,12,12,192,12,12,12,48,12,12,12,48,15,252,48,12,15,252,48,12,12,12,192,12,12,12,192,12,
  // 0x98ce  风
  206,152,30,30,120,32,0,252,15,255,255,0,15,255,255,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,192,51,0,12,192,51,0,12,48,51,0,12,48,51,0,12,12,195,0,12,12,195,0,12,12,195,0,12,12,195,0,12,3,3,0,12,3,3,0,12,3,3,0,12,3,3,0,12,12,195,0,12,12,195,0,12,12,195,12,12,12,195,12,12,48,48,204,12,48,48,204,48,192,48,204,48,192,48,204,48,0,0,60,48,0,0,60,192,0,0,12,192,0,0,12,
  // 0x9971  饱
  113,153,30,30,120,32,0,254,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,3,255,240,12,3,255,240,15,195,0,48,15,195,0,48,48,204,0,48,48,204,0,48,51,51,255,48,51,51,255,48,192,3,3,48,192,3,3,48,12,3,3,48,12,3,3,48,12,3,3,48,12,3,3,48,12,3,255,48,12,3,255,48,12,3,0,48,12,3,0,48,12,3,12,192,12,3,12,192,12,195,3,12,12,195,3,12,15,3,0,12,15,3,0,12,12,0,255,252,12,0,255,252,
  // 0x9a6c  马
  108,154,28,30,120,32,0,252,63,255,252,0,63,255,252,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,255,255,240,3,255,255,240,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,255,255,252,48,255,255,252,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,0,48,0,0,12,192,0,0,12,192,0,0,3,0,0,0,3,0,
  // 0x9a71  驱
  113,154,30,30,120,32,0,252,255,195,255,252,255,195,255,252,0,195,0,0,0,195,0,0,48,195,0,48,48,195,0,48,48,195,48,48,48,195,48,48,48,195,12,192,48,195,12,192,48,195,12,192,48,195,12,192,63,243,3,0,63,243,3,0,0,51,3,0,0,51,3,0,0,51,12,192,0,51,12,192,3,243,12,192,3,243,12,192,252,51,48,48,252,51,48,48,48,51,192,48,48,51,192,48,0,51,0,0,0,51,0,0,12,195,255,252,12,195,255,252,3,0,0,0,3,0,0,0,
  // 0x9ad8  高
  216,154,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,0,0,0,0,0,0,0,0,255,252,0,0,255,252,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,255,252,0,0,255,252,0,0,0,0,0,0,0,0,0,63,255,255,240,63,255,255,240,48,0,0,48,48,0,0,48,48,255,252,48,48,255,252,48,48,192,12,48,48,192,12,48,48,192,12,48,48,192,12,48,48,255,252,48,48,255,252,48,48,0,0,240,48,0,0,240,
  // 0x9ec4  黄
  196,158,30,32,128,32,0,252,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,15,255,255,192,15,255,255,192,0,48,48,0,0,48,48,0,0,48,48,0,0,48,48,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,3,3,3,0,3,3,3,0,3,255,255,0,3,255,255,0,0,0,0,0,0,0,0,0,0,192,12,0,0,192,12,0,3,0,3,0,3,0,3,0,60,0,0,240,60,0,0,240,
  // 0x9ede  點
  222,158,30,32,128,32,0,252,0,0,3,0,0,0,3,0,255,252,3,0,255,252,3,0,195,12,3,0,195,12,3,0,243,60,3,0,243,60,3,0,207,204,3,252,207,204,3,252,195,12,3,0,195,12,3,0,255,252,3,0,255,252,3,0,3,0,3,0,3,0,3,0,255,252,255,252,255,252,255,252,3,0,192,12,3,0,192,12,3,252,192,12,3,252,192,12,252,0,192,12,252,0,192,12,0,12,192,12,0,12,192,12,204,204,192,12,204,204,192,12,204,192,255,252,204,192,255,252,192,0,192,12,192,0,192,12,
  // 0x9f50  齐
  80,159,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,192,12,0,0,192,12,0,0,48,48,0,0,48,48,0,0,15,192,0,0,15,192,0,0,240,60,0,0,240,60,0,15,0,3,192,15,0,3,192,240,192,12,60,240,192,12,60,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,0,192,12,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,12,0,12,0,12,0,12,0,
  // 0xff1a  ：
  26,255,8,14,14,32,12,2,255,255,255,255,0,0,0,0,0,0,255,255,255,255,
};

#endif // HAS_GRAPHICAL_TFT
