/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Katakana 32pt, capital 'A' height: 20px, width: 100%, range: 0x30a0-0x8868, glyphs: 103
extern const uint8_t Unifont_Katakana_20[8142] = {
  161,20,160,48,104,136,28,252, // unifont_t
  // 0x30a0  ゠
  160,48,12,10,20,32,10,4,255,240,255,240,0,0,0,0,0,0,0,0,0,0,0,0,255,240,255,240,
  // 0x30a1  ァ
  161,48,18,16,48,32,4,254,192,63,192,192,63,192,63,192,192,63,192,192,0,195,0,0,195,0,0,60,0,0,60,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,
  // 0x30a2  ア
  162,48,20,24,72,32,4,254,192,63,240,192,63,240,63,192,48,63,192,48,0,0,192,0,0,192,0,195,0,0,195,0,0,60,0,0,60,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,
  // 0x30a3  ィ
  163,48,16,20,40,32,6,254,0,3,0,3,0,12,0,12,0,48,0,48,3,240,3,240,252,48,252,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,
  // 0x30a4  イ
  164,48,18,26,78,32,4,254,0,0,192,0,0,192,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,240,0,0,240,0,15,48,0,15,48,0,240,12,0,240,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,
  // 0x30a5  ゥ
  165,48,16,20,40,32,6,254,3,0,3,0,0,192,0,192,0,255,0,255,255,3,255,3,48,3,48,3,48,12,48,12,0,12,0,12,0,48,0,48,0,192,0,192,3,0,3,0,
  // 0x30a6  ウ
  166,48,20,26,78,32,4,254,0,192,0,0,192,0,0,48,0,0,48,0,0,48,0,0,48,0,0,63,240,0,63,240,255,192,48,255,192,48,48,0,48,48,0,48,48,0,192,48,0,192,12,0,192,12,0,192,12,3,0,12,3,0,0,3,0,0,3,0,0,12,0,0,12,0,0,48,0,0,48,0,0,192,0,0,192,0,
  // 0x30a7  ェ
  167,48,18,14,42,32,6,0,0,63,0,0,63,0,63,192,0,63,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,255,0,0,255,0,255,0,192,255,0,192,
  // 0x30a8  エ
  168,48,22,18,54,32,4,2,0,3,240,0,3,240,63,252,0,63,252,0,0,192,0,0,192,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,255,240,0,255,240,255,0,12,255,0,12,
  // 0x30a9  ォ
  169,48,16,20,40,32,6,254,0,192,0,192,0,48,0,48,192,63,192,63,63,240,63,240,0,240,0,240,3,48,3,48,12,48,12,48,48,48,48,48,192,240,192,240,0,48,0,48,
  // 0x30aa  オ
  170,48,22,26,78,32,4,254,0,12,0,0,12,0,0,3,0,0,3,0,0,3,0,0,3,0,192,3,252,192,3,252,63,255,0,63,255,0,0,15,0,0,15,0,0,51,0,0,51,0,0,195,0,0,195,0,3,3,0,3,3,0,12,3,0,12,3,0,48,3,0,48,3,0,0,15,0,0,15,0,0,3,0,0,3,0,
  // 0x30ab  カ
  171,48,20,26,78,32,4,254,0,192,0,0,192,0,0,48,0,0,48,0,0,48,0,0,48,0,192,63,240,192,63,240,63,240,48,63,240,48,0,192,48,0,192,48,0,192,48,0,192,48,3,0,192,3,0,192,3,0,192,3,0,192,12,0,192,12,0,192,48,51,0,48,51,0,192,15,0,192,15,0,0,12,0,0,12,0,
  // 0x30ac  ガ
  172,48,24,28,84,32,4,254,0,0,12,0,0,12,0,192,195,0,192,195,0,48,51,0,48,51,0,48,48,0,48,48,192,63,240,192,63,240,63,240,48,63,240,48,0,192,48,0,192,48,0,192,48,0,192,48,3,0,192,3,0,192,3,0,192,3,0,192,12,0,192,12,0,192,48,51,0,48,51,0,192,15,0,192,15,0,0,12,0,0,12,0,
  // 0x30ad  キ
  173,48,22,26,78,32,4,254,3,0,0,3,0,0,0,192,0,0,192,0,0,195,240,0,195,240,0,252,0,0,252,0,63,48,0,63,48,0,0,48,0,0,48,0,0,51,252,0,51,252,0,252,0,0,252,0,255,12,0,255,12,0,0,12,0,0,12,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,
  // 0x30ae  ギ
  174,48,24,28,84,32,4,254,0,0,12,0,0,12,3,0,195,3,0,195,0,192,51,0,192,51,0,195,240,0,195,240,0,252,0,0,252,0,63,48,0,63,48,0,0,48,0,0,48,0,0,51,252,0,51,252,0,252,0,0,252,0,255,12,0,255,12,0,0,12,0,0,12,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,
  // 0x30af  ク
  175,48,18,26,78,32,6,254,12,0,0,12,0,0,3,15,192,3,15,192,3,240,192,3,240,192,3,3,0,3,3,0,12,3,0,12,3,0,12,12,0,12,12,0,48,12,0,48,12,0,192,48,0,192,48,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,48,0,0,48,0,0,
  // 0x30b0  グ
  176,48,24,28,84,32,4,254,0,0,12,0,0,12,12,0,195,12,0,195,3,15,51,3,15,51,3,243,48,3,243,48,3,3,0,3,3,0,12,3,0,12,3,0,12,12,0,12,12,0,48,12,0,48,12,0,192,48,0,192,48,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,48,0,0,48,0,0,
  // 0x30b1  ケ
  177,48,22,26,78,32,4,254,12,0,0,12,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,252,3,0,252,15,255,0,15,255,0,12,48,0,12,48,0,48,12,0,48,12,0,192,12,0,192,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,
  // 0x30b2  ゲ
  178,48,24,28,84,32,4,254,0,0,12,0,0,12,12,0,195,12,0,195,3,0,51,3,0,51,3,0,48,3,0,48,3,0,252,3,0,252,15,255,0,15,255,0,12,48,0,12,48,0,48,12,0,48,12,0,192,12,0,192,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,
  // 0x30b3  コ
  179,48,20,18,54,32,4,2,192,63,240,192,63,240,63,192,48,63,192,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,0,192,0,0,192,0,255,192,0,255,192,63,0,192,63,0,192,
  // 0x30b4  ゴ
  180,48,26,24,96,32,2,2,0,0,3,0,0,0,3,0,0,0,48,192,0,0,48,192,0,0,12,192,0,0,12,192,192,63,204,0,192,63,204,0,63,192,192,0,63,192,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,0,192,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,255,0,0,0,255,0,0,63,3,0,0,63,3,0,0,
  // 0x30b5  サ
  181,48,22,26,78,32,4,254,0,12,0,0,12,0,12,3,0,12,3,0,3,3,0,3,3,0,3,3,0,3,3,0,195,15,252,195,15,252,63,243,0,63,243,0,3,3,0,3,3,0,3,3,0,3,3,0,3,3,0,3,3,0,0,12,0,0,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,192,0,0,192,0,
  // 0x30b6  ザ
  182,48,24,28,84,32,4,254,0,0,12,0,0,12,0,12,195,0,12,195,12,3,51,12,3,51,3,3,48,3,3,48,3,3,0,3,3,0,195,15,252,195,15,252,63,243,0,63,243,0,3,3,0,3,3,0,3,3,0,3,3,0,3,3,0,3,3,0,0,12,0,0,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,192,0,0,192,0,
  // 0x30b7  シ
  183,48,20,22,66,32,6,0,60,0,0,60,0,0,3,0,0,3,0,0,0,0,0,0,0,0,240,0,0,240,0,0,12,0,48,12,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,48,0,0,48,0,195,192,0,195,192,0,60,0,0,60,0,0,
  // 0x30b8  ジ
  184,48,22,24,72,32,6,0,0,0,48,0,0,48,60,3,12,60,3,12,3,0,204,3,0,204,0,0,192,0,0,192,240,0,0,240,0,0,12,0,48,12,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,48,0,0,48,0,195,192,0,195,192,0,60,0,0,60,0,0,
  // 0x30b9  ス
  185,48,20,20,60,32,4,2,48,15,192,48,15,192,15,240,192,15,240,192,0,3,0,0,3,0,0,3,0,0,3,0,0,12,0,0,12,0,0,12,0,0,12,0,0,51,0,0,51,0,0,192,192,0,192,192,15,0,48,15,0,48,240,0,48,240,0,48,
  // 0x30ba  ズ
  186,48,26,24,96,32,2,2,0,0,3,0,0,0,3,0,0,0,48,192,0,0,48,192,48,15,204,192,48,15,204,192,15,240,204,0,15,240,204,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,51,0,0,0,51,0,0,0,192,192,0,0,192,192,0,15,0,48,0,15,0,48,0,240,0,48,0,240,0,48,0,
  // 0x30bb  セ
  187,48,22,24,72,32,4,0,12,0,0,12,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,3,252,3,3,252,3,60,12,3,60,12,195,192,48,195,192,48,63,0,192,63,0,192,3,3,0,3,3,0,3,0,0,3,0,0,3,0,0,3,0,0,0,192,0,0,192,0,0,63,240,0,63,240,
  // 0x30bc  ゼ
  188,48,24,26,78,32,4,0,0,0,12,0,0,12,12,0,195,12,0,195,3,0,51,3,0,51,3,0,48,3,0,48,3,3,252,3,3,252,3,60,12,3,60,12,195,192,48,195,192,48,63,0,192,63,0,192,3,3,0,3,3,0,3,0,0,3,0,0,3,0,0,3,0,0,0,192,0,0,192,0,0,63,252,0,63,252,
  // 0x30bd  ソ
  189,48,18,26,78,32,6,254,0,3,0,0,3,0,192,0,192,192,0,192,48,0,192,48,0,192,12,0,192,12,0,192,12,3,0,12,3,0,12,3,0,12,3,0,0,12,0,0,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,
  // 0x30be  ゾ
  190,48,24,28,84,32,4,254,0,0,12,0,0,12,0,12,195,0,12,195,192,3,51,192,3,51,48,3,48,48,3,48,12,3,0,12,3,0,12,3,0,12,3,0,12,3,0,12,3,0,0,12,0,0,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,
  // 0x30bf  タ
  191,48,20,26,78,32,4,254,0,192,0,0,192,0,0,48,0,0,48,0,0,63,240,0,63,240,0,192,48,0,192,48,0,192,192,0,192,192,3,48,192,3,48,192,12,15,0,12,15,0,48,3,0,48,3,0,0,12,0,0,12,0,0,48,0,0,48,0,0,192,0,0,192,0,15,0,0,15,0,0,240,0,0,240,0,0,
  // 0x30c0  ダ
  192,48,26,28,112,32,2,254,0,0,3,0,0,0,3,0,0,192,48,192,0,192,48,192,0,48,12,192,0,48,12,192,0,63,252,0,0,63,252,0,0,192,48,0,0,192,48,0,0,192,48,0,0,192,48,0,3,48,192,0,3,48,192,0,12,12,192,0,12,12,192,0,48,3,0,0,48,3,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,15,0,0,0,15,0,0,0,240,0,0,0,240,0,0,0,
  // 0x30c1  チ
  193,48,22,26,78,32,4,254,0,3,0,0,3,0,0,60,0,0,60,0,63,192,0,63,192,0,0,48,0,0,48,0,0,15,252,0,15,252,192,252,0,192,252,0,63,12,0,63,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,
  // 0x30c2  ヂ
  194,48,24,28,84,32,4,254,0,0,12,0,0,12,0,3,195,0,3,195,0,60,51,0,60,51,63,192,48,63,192,48,0,48,0,0,48,0,0,15,252,0,15,252,192,252,0,192,252,0,63,12,0,63,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,
  // 0x30c3  ッ
  195,48,16,16,32,32,6,254,12,12,12,12,195,3,195,3,51,3,51,3,48,12,48,12,0,12,0,12,0,48,0,48,0,192,0,192,3,0,3,0,
  // 0x30c4  ツ
  196,48,22,22,66,32,4,0,3,0,48,3,0,48,192,192,12,192,192,12,48,48,12,48,48,12,12,48,48,12,48,48,12,0,48,12,0,48,0,0,192,0,0,192,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,48,0,0,48,0,0,192,0,0,192,0,
  // 0x30c5  ヅ
  197,48,26,26,104,32,2,0,0,0,3,0,0,0,3,0,0,0,48,192,0,0,48,192,12,3,12,192,12,3,12,192,3,0,204,0,3,0,204,0,192,192,192,0,192,192,192,0,48,192,192,0,48,192,192,0,12,0,192,0,12,0,192,0,12,3,0,0,12,3,0,0,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,3,0,0,0,3,0,0,0,
  // 0x30c6  テ
  198,48,22,24,72,32,4,254,48,63,192,48,63,192,15,192,0,15,192,0,0,0,0,0,0,0,0,3,252,0,3,252,192,252,0,192,252,0,63,12,0,63,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,
  // 0x30c7  デ
  199,48,24,28,84,32,4,254,0,0,12,0,0,12,0,0,195,0,0,195,48,63,51,48,63,51,15,192,48,15,192,48,0,0,0,0,0,0,192,15,240,192,15,240,63,240,0,63,240,0,0,12,0,0,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,
  // 0x30c8  ト
  200,48,14,26,52,32,8,254,192,0,192,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,63,0,63,0,48,240,48,240,48,12,48,12,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,
  // 0x30c9  ド
  201,48,18,28,84,32,6,254,0,3,0,0,3,0,192,48,192,192,48,192,48,12,192,48,12,192,48,12,0,48,12,0,48,0,0,48,0,0,48,0,0,48,0,0,63,0,0,63,0,0,48,240,0,48,240,0,48,12,0,48,12,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,
  // 0x30ca  ナ
  202,48,22,26,78,32,4,254,0,48,0,0,48,0,0,12,0,0,12,0,0,12,0,0,12,0,192,15,252,192,15,252,63,252,0,63,252,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,
  // 0x30cb  ニ
  203,48,22,16,48,32,4,4,0,15,192,0,15,192,63,240,0,63,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,240,0,63,240,255,192,12,255,192,12,
  // 0x30cc  ヌ
  204,48,20,22,66,32,4,0,48,15,240,48,15,240,15,240,48,15,240,48,0,0,192,0,0,192,0,0,192,0,0,192,15,195,0,15,195,0,0,63,0,0,63,0,0,15,0,0,15,0,0,48,192,0,48,192,0,192,48,0,192,48,15,0,48,15,0,48,240,0,0,240,0,0,
  // 0x30cd  ネ
  205,48,22,26,78,32,4,254,0,192,0,0,192,0,0,48,0,0,48,0,0,63,192,0,63,192,63,192,192,63,192,192,0,3,0,0,3,0,0,12,0,0,12,0,0,48,0,0,48,0,0,243,0,0,243,0,15,48,240,15,48,240,240,48,12,240,48,12,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,
  // 0x30ce  ノ
  206,48,16,26,52,32,6,254,0,12,0,12,0,3,0,3,0,3,0,3,0,3,0,3,0,12,0,12,0,12,0,12,0,48,0,48,0,48,0,48,0,192,0,192,3,0,3,0,12,0,12,0,48,0,48,0,192,0,192,0,
  // 0x30cf  ハ
  207,48,24,16,48,32,2,2,3,3,0,3,3,0,0,192,192,0,192,192,0,192,48,0,192,48,3,0,12,3,0,12,3,0,12,3,0,12,12,0,3,12,0,3,48,0,3,48,0,3,192,0,3,192,0,3,
  // 0x30d0  バ
  208,48,26,22,88,32,2,2,0,0,3,0,0,0,3,0,0,0,48,192,0,0,48,192,0,0,12,192,0,0,12,192,3,3,12,0,3,3,12,0,0,192,192,0,0,192,192,0,0,192,48,0,0,192,48,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,12,0,3,0,12,0,3,0,48,0,3,0,48,0,3,0,192,0,3,0,192,0,3,0,
  // 0x30d1  パ
  209,48,26,24,96,32,2,2,0,0,15,0,0,0,15,0,0,0,48,192,0,0,48,192,0,0,48,192,0,0,48,192,0,0,15,0,0,0,15,0,3,3,0,0,3,3,0,0,0,192,192,0,0,192,192,0,0,192,48,0,0,192,48,0,3,0,12,0,3,0,12,0,3,0,12,0,3,0,12,0,12,0,3,0,12,0,3,0,48,0,3,0,48,0,3,0,192,0,3,0,192,0,3,0,
  // 0x30d2  ヒ
  210,48,18,22,66,32,6,0,192,0,0,192,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,63,0,48,63,0,63,192,0,63,192,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,12,0,0,12,0,0,3,255,192,3,255,192,
  // 0x30d3  ビ
  211,48,20,24,72,32,6,0,0,0,192,0,0,192,192,12,48,192,12,48,48,3,48,48,3,48,48,3,0,48,3,0,48,0,0,48,0,0,48,63,0,48,63,0,63,192,0,63,192,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,12,0,0,12,0,0,3,255,192,3,255,192,
  // 0x30d4  ピ
  212,48,20,24,72,32,6,0,0,3,192,0,3,192,192,12,48,192,12,48,48,12,48,48,12,48,48,3,192,48,3,192,48,0,0,48,0,0,48,63,0,48,63,0,63,192,0,63,192,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,12,0,0,12,0,0,3,255,192,3,255,192,
  // 0x30d5  フ
  213,48,18,22,66,32,6,0,192,63,192,192,63,192,63,192,192,63,192,192,0,0,192,0,0,192,0,3,0,0,3,0,0,3,0,0,3,0,0,12,0,0,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,
  // 0x30d6  ブ
  214,48,24,26,78,32,4,0,0,0,12,0,0,12,0,0,195,0,0,195,192,255,51,192,255,51,63,3,48,63,3,48,0,3,0,0,3,0,0,12,0,0,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,48,0,0,48,0,0,
  // 0x30d7  プ
  215,48,24,26,78,32,4,0,0,0,60,0,0,60,0,0,195,0,0,195,192,255,195,192,255,195,63,3,60,63,3,60,0,3,0,0,3,0,0,12,0,0,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,48,0,0,48,0,0,
  // 0x30d8  ヘ
  216,48,26,12,48,32,2,6,0,48,0,0,0,48,0,0,0,204,0,0,0,204,0,0,195,3,0,0,195,3,0,0,60,0,192,0,60,0,192,0,0,0,60,0,0,0,60,0,0,0,3,192,0,0,3,192,
  // 0x30d9  ベ
  217,48,26,18,72,32,2,6,0,0,48,0,0,0,48,0,0,3,12,0,0,3,12,0,0,0,204,0,0,0,204,0,0,48,192,0,0,48,192,0,0,204,0,0,0,204,0,0,195,3,0,0,195,3,0,0,60,0,192,0,60,0,192,0,0,0,60,0,0,0,60,0,0,0,3,192,0,0,3,192,
  // 0x30da  ペ
  218,48,26,18,72,32,2,6,0,0,240,0,0,0,240,0,0,3,12,0,0,3,12,0,0,3,12,0,0,3,12,0,0,48,240,0,0,48,240,0,0,204,0,0,0,204,0,0,195,3,0,0,195,3,0,0,60,0,192,0,60,0,192,0,0,0,60,0,0,0,60,0,0,0,3,192,0,0,3,192,
  // 0x30db  ホ
  219,48,20,26,78,32,4,254,0,192,0,0,192,0,0,48,0,0,48,0,0,48,0,0,48,0,192,63,240,192,63,240,63,240,0,63,240,0,0,48,0,0,48,0,0,51,0,0,51,0,12,48,192,12,48,192,12,48,48,12,48,48,48,48,48,48,48,48,192,48,0,192,48,0,0,240,0,0,240,0,0,48,0,0,48,0,
  // 0x30dc  ボ
  220,48,24,28,84,32,4,254,0,0,12,0,0,12,0,192,195,0,192,195,0,48,51,0,48,51,0,48,48,0,48,48,192,63,240,192,63,240,63,240,0,63,240,0,0,48,0,0,48,0,0,51,0,0,51,0,12,48,192,12,48,192,12,48,48,12,48,48,48,48,48,48,48,48,192,48,0,192,48,0,0,240,0,0,240,0,0,48,0,0,48,0,
  // 0x30dd  ポ
  221,48,24,28,84,32,4,254,0,0,60,0,0,60,0,192,195,0,192,195,0,48,195,0,48,195,0,48,60,0,48,60,192,63,240,192,63,240,63,240,0,63,240,0,0,48,0,0,48,0,0,51,0,0,51,0,12,48,192,12,48,192,12,48,48,12,48,48,48,48,48,48,48,48,192,48,0,192,48,0,0,240,0,0,240,0,0,48,0,0,48,0,
  // 0x30de  マ
  222,48,22,18,54,32,4,2,192,15,240,192,15,240,63,240,12,63,240,12,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,15,12,0,15,12,0,0,240,0,0,240,0,0,12,0,0,12,0,0,3,0,0,3,0,
  // 0x30df  ミ
  223,48,16,26,52,32,6,254,12,0,12,0,3,192,3,192,0,60,0,60,0,3,0,3,48,0,48,0,15,0,15,0,0,240,0,240,0,12,0,12,192,0,192,0,60,0,60,0,3,192,3,192,0,60,0,60,0,3,0,3,
  // 0x30e0  ム
  224,48,22,22,66,32,4,2,0,192,0,0,192,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,0,192,0,0,192,0,0,195,0,0,195,0,3,0,192,3,0,192,3,0,240,3,0,240,204,63,12,204,63,12,63,192,12,63,192,12,
  // 0x30e1  メ
  225,48,20,26,78,32,4,254,0,3,0,0,3,0,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,3,192,192,3,192,192,0,63,0,0,63,0,0,3,0,0,3,0,0,12,192,0,12,192,0,12,48,0,12,48,0,48,0,0,48,0,0,192,0,0,192,0,15,0,0,15,0,0,240,0,0,240,0,0,
  // 0x30e2  モ
  226,48,22,20,60,32,4,2,48,15,192,48,15,192,15,240,0,15,240,0,0,192,0,0,192,0,0,192,0,0,192,0,192,255,252,192,255,252,63,192,0,63,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,0,63,240,0,63,240,
  // 0x30e3  ャ
  227,48,18,18,54,32,6,254,12,0,0,12,0,0,3,15,192,3,15,192,3,240,192,3,240,192,255,3,0,255,3,0,0,204,0,0,204,0,0,192,0,0,192,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,
  // 0x30e4  ヤ
  228,48,22,24,72,32,4,0,12,0,0,12,0,0,3,0,0,3,0,0,3,3,252,3,3,252,0,252,12,0,252,12,195,192,48,195,192,48,60,192,192,60,192,192,0,51,0,0,51,0,0,48,0,0,48,0,0,48,0,0,48,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,
  // 0x30e5  ュ
  229,48,18,12,36,32,6,2,0,252,0,0,252,0,63,12,0,63,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,255,0,0,255,0,255,0,192,255,0,192,
  // 0x30e6  ユ
  230,48,22,14,42,32,4,4,48,63,0,48,63,0,15,195,0,15,195,0,0,3,0,0,3,0,0,12,0,0,12,0,0,12,0,0,12,0,0,63,240,0,63,240,255,192,12,255,192,12,
  // 0x30e7  ョ
  231,48,14,16,32,32,8,0,3,252,3,252,252,12,252,12,0,12,0,12,3,252,3,252,252,48,252,48,0,48,0,48,3,240,3,240,252,12,252,12,
  // 0x30e8  ヨ
  232,48,18,22,66,32,6,0,0,255,192,0,255,192,255,0,192,255,0,192,0,0,192,0,0,192,0,0,192,0,0,192,0,255,0,0,255,0,63,3,0,63,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,3,0,0,255,0,0,255,0,63,0,192,63,0,192,
  // 0x30e9  ラ
  233,48,20,24,72,32,4,254,48,63,0,48,63,0,15,192,0,15,192,0,0,3,240,0,3,240,192,252,48,192,252,48,63,0,48,63,0,48,0,0,48,0,0,48,0,0,192,0,0,192,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,240,0,0,240,0,15,0,0,15,0,0,
  // 0x30ea  リ
  234,48,14,26,52,32,8,254,0,48,0,48,192,12,192,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,0,48,0,48,0,48,0,48,0,192,0,192,3,0,3,0,12,0,12,0,
  // 0x30eb  ル
  235,48,22,22,66,32,4,0,0,48,0,0,48,0,12,12,0,12,12,0,3,12,0,3,12,0,3,12,0,3,12,0,3,12,12,3,12,12,3,12,12,3,12,12,3,12,48,3,12,48,12,12,48,12,12,48,12,12,192,12,12,192,48,15,0,48,15,0,192,12,0,192,12,0,
  // 0x30ec  レ
  236,48,18,24,72,32,6,0,192,0,0,192,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,192,48,0,192,48,3,0,48,3,0,48,12,0,48,12,0,48,48,0,48,48,0,51,192,0,51,192,0,60,0,0,60,0,0,
  // 0x30ed  ロ
  237,48,20,18,54,32,4,2,192,63,240,192,63,240,63,192,48,63,192,48,48,0,48,48,0,48,48,0,48,48,0,48,12,0,192,12,0,192,12,0,192,12,0,192,12,63,192,12,63,192,15,192,48,15,192,48,12,0,0,12,0,0,
  // 0x30ee  ヮ
  238,48,18,16,48,32,6,254,192,63,192,192,63,192,63,192,192,63,192,192,48,3,0,48,3,0,12,3,0,12,3,0,12,12,0,12,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,192,0,0,192,0,
  // 0x30ef  ワ
  239,48,20,24,72,32,4,254,192,63,240,192,63,240,63,192,48,63,192,48,48,0,48,48,0,48,12,0,48,12,0,48,12,0,192,12,0,192,12,0,192,12,0,192,0,3,0,0,3,0,0,3,0,0,3,0,0,12,0,0,12,0,0,48,0,0,48,0,0,192,0,0,192,0,3,0,0,3,0,0,
  // 0x30f0  ヰ
  240,48,22,26,78,32,4,254,0,48,0,0,48,0,0,12,0,0,12,0,0,12,0,0,12,0,0,63,240,0,63,240,63,204,0,63,204,0,12,12,0,12,12,0,3,12,0,3,12,0,3,63,240,3,63,240,255,204,12,255,204,12,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,
  // 0x30f1  ヱ
  241,48,22,16,48,32,4,4,0,63,192,0,63,192,63,192,192,63,192,192,0,195,0,0,195,0,0,60,0,0,60,0,0,48,0,0,48,0,0,48,0,0,48,0,0,63,240,0,63,240,255,192,12,255,192,12,
  // 0x30f2  ヲ
  242,48,18,24,72,32,6,254,0,255,192,0,255,192,255,0,192,255,0,192,0,0,192,0,0,192,0,3,0,0,3,0,0,255,0,0,255,0,63,3,0,63,3,0,0,12,0,0,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,192,0,0,192,0,15,0,0,15,0,0,240,0,0,240,0,0,
  // 0x30f3  ン
  243,48,20,20,60,32,6,0,240,0,0,240,0,0,12,0,48,12,0,48,3,0,48,3,0,48,0,0,192,0,0,192,0,0,192,0,0,192,0,3,0,0,3,0,0,12,0,0,12,0,0,48,0,0,48,0,195,192,0,195,192,0,60,0,0,60,0,0,
  // 0x30f4  ヴ
  244,48,26,28,112,32,2,254,0,0,3,0,0,0,3,0,0,192,48,192,0,192,48,192,0,48,12,192,0,48,12,192,0,48,12,0,0,48,12,0,192,63,240,0,192,63,240,0,63,192,48,0,63,192,48,0,48,0,48,0,48,0,48,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,
  // 0x30f5  ヵ
  245,48,16,18,36,32,6,254,3,0,3,0,0,192,0,192,192,255,192,255,63,3,63,3,3,3,3,3,3,3,3,3,12,3,12,3,48,60,48,60,192,12,192,12,
  // 0x30f6  ヶ
  246,48,16,18,36,32,6,254,48,0,48,0,12,0,12,0,12,15,12,15,15,240,15,240,48,48,48,48,192,48,192,48,0,192,0,192,3,0,3,0,12,0,12,0,
  // 0x30f7  ヷ
  247,48,26,30,120,32,4,254,0,0,3,0,0,0,3,0,0,0,48,192,0,0,48,192,0,0,12,0,0,0,12,0,192,63,240,0,192,63,240,0,63,192,48,0,63,192,48,0,48,0,48,0,48,0,48,0,12,0,48,0,12,0,48,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,12,0,0,0,12,0,0,0,48,0,0,0,48,0,0,0,192,0,0,0,192,0,0,3,0,0,0,3,0,0,0,
  // 0x30f8  ヸ
  248,48,24,28,84,32,4,254,0,0,12,0,0,12,0,48,3,0,48,3,0,12,48,0,12,48,0,12,12,0,12,12,0,63,240,0,63,240,63,204,0,63,204,0,12,12,0,12,12,0,3,12,0,3,12,0,3,63,240,3,63,240,255,204,12,255,204,12,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,0,12,0,
  // 0x30f9  ヹ
  249,48,24,22,66,32,4,4,0,0,12,0,0,12,0,0,3,0,0,3,0,0,48,0,0,48,0,63,204,0,63,204,63,192,192,63,192,192,0,195,0,0,195,0,0,60,0,0,60,0,0,48,0,0,48,0,0,48,0,0,48,0,0,63,240,0,63,240,255,192,12,255,192,12,
  // 0x30fa  ヺ
  250,48,24,30,90,32,6,254,0,0,12,0,0,12,0,0,3,0,0,3,0,0,48,0,0,48,0,255,204,0,255,204,255,0,192,255,0,192,0,0,192,0,0,192,0,3,0,0,3,0,0,255,0,0,255,0,63,3,0,63,3,0,0,12,0,0,12,0,0,12,0,0,12,0,0,48,0,0,48,0,0,192,0,0,192,0,15,0,0,15,0,0,240,0,0,240,0,0,
  // 0x30fb  ・
  251,48,8,8,8,32,10,8,60,60,255,255,255,255,60,60,
  // 0x30fc  ー
  252,48,24,4,12,32,2,10,192,3,255,192,3,255,63,252,0,63,252,0,
  // 0x30fd  ヽ
  253,48,14,10,20,32,8,8,240,0,240,0,15,0,15,0,0,192,0,192,0,48,0,48,0,12,0,12,
  // 0x30fe  ヾ
  254,48,16,14,28,32,8,8,0,12,0,12,0,195,0,195,240,48,240,48,15,0,15,0,0,192,0,192,0,48,0,48,0,12,0,12,
  // 0x30ff  ヿ
  255,48,20,26,78,32,4,254,192,63,192,192,63,192,63,192,48,63,192,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,0,0,48,
  // 0x4eee  仮
  238,78,30,32,128,32,0,252,0,192,0,192,0,192,0,192,0,192,15,240,0,192,15,240,0,207,240,0,0,207,240,0,3,12,0,0,3,12,0,0,3,12,0,0,3,12,0,0,15,12,0,0,15,12,0,0,15,15,255,192,15,15,255,192,51,12,192,192,51,12,192,192,195,12,192,192,195,12,192,192,3,12,192,192,3,12,192,192,3,12,51,0,3,12,51,0,3,12,51,0,3,12,51,0,3,12,12,0,3,12,12,0,3,48,51,0,3,48,51,0,3,48,192,192,3,48,192,192,3,195,0,60,3,195,0,60,
  // 0x540d  名
  13,84,26,32,128,32,0,252,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,63,255,0,0,63,255,0,0,192,3,0,0,192,3,0,3,48,12,0,3,48,12,0,60,12,48,0,60,12,48,0,0,12,192,0,0,12,192,0,0,3,0,0,0,3,0,0,0,60,0,0,0,60,0,0,3,255,255,192,3,255,255,192,252,192,0,192,252,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,255,192,0,255,255,192,0,192,0,192,0,192,0,192,
  // 0x5b9a  定
  154,91,30,32,128,32,0,252,0,12,0,0,0,12,0,0,0,3,0,0,0,3,0,0,63,255,255,252,63,255,255,252,48,0,0,12,48,0,0,12,192,0,0,48,192,0,0,48,0,0,0,0,0,0,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,0,0,3,3,0,0,3,3,255,192,3,3,255,192,3,3,0,0,3,3,0,0,3,3,0,0,3,3,0,0,12,195,0,0,12,195,0,0,48,63,255,252,48,63,255,252,192,0,0,0,192,0,0,0,
  // 0x7247  片
  71,114,26,32,128,32,2,252,0,0,192,0,0,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,12,0,192,0,15,255,255,192,15,255,255,192,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,12,0,0,0,15,255,240,0,15,255,240,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,12,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,48,0,192,0,48,0,192,0,48,0,
  // 0x793a  示
  58,121,30,30,120,32,0,252,15,255,255,192,15,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,252,255,255,255,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,3,3,3,0,3,3,3,0,3,3,0,192,3,3,0,192,12,3,0,48,12,3,0,48,48,3,0,12,48,3,0,12,192,3,0,12,192,3,0,12,0,51,0,0,0,51,0,0,0,12,0,0,0,12,0,0,
  // 0x7fa9  義
  169,127,30,32,128,32,0,252,0,192,12,0,0,192,12,0,0,48,48,0,0,48,48,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,12,48,0,0,12,48,0,15,240,51,0,15,240,51,0,0,192,48,192,0,192,48,192,255,255,255,252,255,255,255,252,0,192,48,192,0,192,48,192,0,252,51,0,0,252,51,0,63,192,12,48,63,192,12,48,0,192,51,48,0,192,51,48,3,195,192,240,3,195,192,240,
  // 0x8868  表
  104,136,30,32,128,32,0,252,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,63,255,255,240,63,255,255,240,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,15,255,255,192,15,255,255,192,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,255,255,255,252,255,255,255,252,0,51,0,0,0,51,0,0,0,192,192,192,0,192,192,192,3,192,51,0,3,192,51,0,12,192,12,0,12,192,12,0,240,195,3,192,240,195,3,192,0,204,0,60,0,204,0,60,0,240,0,0,0,240,0,0,
};

#endif // HAS_GRAPHICAL_TFT
