/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Vietnamese 16pt, capital 'A' height: 10px, width: 100%, range: 0x0102-0x1ef9, glyphs: 107
extern const uint8_t Unifont_Vietnamese_10[2220] = {
  161,10,2,1,249,30,14,254, // unifont_t
  // 0x0102  Ă
  2,1,6,14,14,8,1,0,132,132,120,0,48,72,72,132,132,252,132,132,132,132,
  // 0x0103  ă
  3,1,6,13,13,8,1,0,132,132,120,0,0,120,132,4,124,132,132,140,116,
  // 0x0110  Đ
  16,1,7,10,10,8,0,0,120,68,66,66,242,66,66,66,68,120,
  // 0x0111  đ
  17,1,7,11,11,8,1,0,4,30,4,116,140,132,132,132,132,140,116,
  // 0x0128  Ĩ
  40,1,6,14,14,8,1,0,100,152,0,0,124,16,16,16,16,16,16,16,16,124,
  // 0x0129  ĩ
  41,1,6,12,12,8,1,0,100,152,0,0,48,16,16,16,16,16,16,124,
  // 0x0168  Ũ
  104,1,6,14,14,8,1,0,100,152,0,0,132,132,132,132,132,132,132,132,132,120,
  // 0x0169  ũ
  105,1,6,12,12,8,1,0,100,152,0,0,132,132,132,132,132,132,140,116,
  // 0x01a0  Ơ
  160,1,6,11,11,8,1,0,4,116,136,136,136,136,136,136,136,136,112,
  // 0x01a1  ơ
  161,1,6,9,9,8,1,0,4,116,136,136,136,136,136,136,112,
  // 0x01af  Ư
  175,1,7,12,12,8,1,0,2,2,140,136,136,136,136,136,136,136,136,112,
  // 0x01b0  ư
  176,1,7,10,10,8,1,0,2,2,140,136,136,136,136,136,152,104,
  // 0x0303  ̃
  3,3,6,2,2,0,249,11,100,152,
  // 0x0309  ̉
  9,3,4,5,5,0,250,9,96,144,16,32,32,
  // 0x0323  ̣
  35,3,2,2,2,0,251,254,192,192,
  // 0x0340  ̀
  64,3,3,3,3,0,249,10,128,64,32,
  // 0x0341  ́
  65,3,3,3,3,0,252,10,32,64,128,
  // 0x1ea0  Ạ
  160,30,5,12,12,8,1,254,32,80,80,136,136,248,136,136,136,136,0,32,
  // 0x1ea1  ạ
  161,30,6,10,10,8,1,254,120,132,4,124,132,132,140,116,0,32,
  // 0x1ea2  Ả
  162,30,6,14,14,8,1,0,128,64,64,128,48,72,72,132,132,252,132,132,132,132,
  // 0x1ea3  ả
  163,30,6,13,13,8,1,0,16,8,8,16,0,120,132,4,124,132,132,140,116,
  // 0x1ea4  Ấ
  164,30,6,14,14,8,1,0,4,40,80,136,32,80,80,136,136,248,136,136,136,136,
  // 0x1ea5  ấ
  165,30,6,13,13,8,1,0,4,40,80,136,0,120,132,4,124,132,132,140,116,
  // 0x1ea6  Ầ
  166,30,6,14,14,8,1,0,128,80,40,68,16,40,40,68,68,124,68,68,68,68,
  // 0x1ea7  ầ
  167,30,6,13,13,8,1,0,128,80,40,68,0,120,132,4,124,132,132,140,116,
  // 0x1ea8  Ẩ
  168,30,6,14,14,8,1,0,8,4,40,80,168,80,80,136,136,248,136,136,136,136,
  // 0x1ea9  ẩ
  169,30,7,14,14,8,1,0,4,2,20,40,68,0,120,132,4,124,132,132,140,116,
  // 0x1eaa  Ẫ
  170,30,6,14,14,8,2,0,100,152,32,80,136,32,80,80,136,136,248,136,136,136,
  // 0x1eab  ẫ
  171,30,7,14,14,8,1,0,50,76,16,40,68,0,120,132,4,124,132,132,140,116,
  // 0x1eac  Ậ
  172,30,5,15,15,8,2,254,32,80,136,32,80,80,136,136,248,136,136,136,136,0,32,
  // 0x1ead  ậ
  173,30,6,14,14,8,1,254,48,72,0,0,120,132,4,124,132,132,140,116,0,16,
  // 0x1eae  Ắ
  174,30,5,14,14,8,1,0,16,32,136,112,32,80,80,136,136,248,136,136,136,136,
  // 0x1eaf  ắ
  175,30,6,14,14,8,1,0,8,16,32,136,112,0,120,132,4,124,132,132,140,116,
  // 0x1eb0  Ằ
  176,30,5,14,14,8,1,0,64,32,136,112,32,80,80,136,136,248,136,136,136,136,
  // 0x1eb1  ằ
  177,30,6,14,14,8,1,0,64,32,16,68,56,0,120,132,4,124,132,132,140,116,
  // 0x1eb2  Ẳ
  178,30,7,14,14,8,0,0,16,8,178,124,16,40,40,68,68,124,68,68,68,68,
  // 0x1eb3  ẳ
  179,30,6,14,14,8,1,0,16,16,32,136,112,0,120,132,4,124,132,132,140,116,
  // 0x1eb4  Ẵ
  180,30,7,14,14,8,0,0,50,76,130,124,16,40,40,68,68,124,68,68,68,68,
  // 0x1eb5  ẵ
  181,30,6,14,14,8,1,0,100,152,0,132,120,0,120,132,4,124,132,132,140,116,
  // 0x1eb6  Ặ
  182,30,5,14,14,8,1,254,136,112,32,80,80,136,136,248,136,136,136,136,0,32,
  // 0x1eb7  ặ
  183,30,6,13,13,8,1,254,72,48,0,120,132,4,124,132,132,140,116,0,32,
  // 0x1eb8  Ẹ
  184,30,6,12,12,8,1,254,252,128,128,128,248,128,128,128,128,252,0,32,
  // 0x1eb9  ẹ
  185,30,6,10,10,8,1,254,120,132,132,252,128,128,132,120,0,32,
  // 0x1eba  Ẻ
  186,30,6,14,14,8,1,0,32,16,16,32,252,128,128,128,248,128,128,128,128,252,
  // 0x1ebb  ẻ
  187,30,6,14,14,8,1,0,32,16,16,32,0,0,120,132,132,252,128,128,132,120,
  // 0x1ebc  Ẽ
  188,30,6,13,13,8,1,0,100,152,0,252,128,128,128,248,128,128,128,128,252,
  // 0x1ebd  ẽ
  189,30,6,11,11,8,1,0,100,152,0,120,132,132,252,128,128,132,120,
  // 0x1ebe  Ế
  190,30,6,14,14,8,1,0,4,40,80,136,252,128,128,128,248,128,128,128,128,252,
  // 0x1ebf  ế
  191,30,6,13,13,8,1,0,4,40,80,136,0,120,132,132,252,128,128,132,120,
  // 0x1ec0  Ề
  192,30,6,14,14,8,1,0,128,80,40,68,252,128,128,128,248,128,128,128,128,252,
  // 0x1ec1  ề
  193,30,6,13,13,8,1,0,128,80,40,68,0,120,132,132,252,128,128,132,120,
  // 0x1ec2  Ể
  194,30,6,14,14,8,1,0,8,36,84,136,252,128,128,128,248,128,128,128,128,252,
  // 0x1ec3  ể
  195,30,6,14,14,8,1,0,8,4,36,88,136,0,120,132,132,252,128,128,132,120,
  // 0x1ec4  Ễ
  196,30,6,14,14,8,1,0,100,152,32,80,136,252,128,128,248,128,128,128,128,252,
  // 0x1ec5  ễ
  197,30,6,14,14,8,1,0,100,152,32,80,136,0,120,132,132,252,128,128,132,120,
  // 0x1ec6  Ệ
  198,30,6,15,15,8,1,254,48,72,0,252,128,128,128,248,128,128,128,128,252,0,16,
  // 0x1ec7  ệ
  199,30,6,14,14,8,1,254,48,72,0,0,120,132,132,252,128,128,132,120,0,16,
  // 0x1ec8  Ỉ
  200,30,5,14,14,8,2,0,32,16,16,32,248,32,32,32,32,32,32,32,32,248,
  // 0x1ec9  ỉ
  201,30,5,13,13,8,2,0,64,32,32,64,0,96,32,32,32,32,32,32,248,
  // 0x1eca  Ị
  202,30,5,12,12,8,2,254,248,32,32,32,32,32,32,32,32,248,0,32,
  // 0x1ecb  ị
  203,30,5,13,13,8,2,254,32,32,0,96,32,32,32,32,32,32,248,0,32,
  // 0x1ecc  Ọ
  204,30,6,12,12,8,1,254,120,132,132,132,132,132,132,132,132,120,0,16,
  // 0x1ecd  ọ
  205,30,6,10,10,8,1,254,120,132,132,132,132,132,132,120,0,16,
  // 0x1ece  Ỏ
  206,30,6,14,14,8,1,0,32,16,16,32,120,132,132,132,132,132,132,132,132,120,
  // 0x1ecf  ỏ
  207,30,6,13,13,8,1,0,32,16,16,32,0,120,132,132,132,132,132,132,120,
  // 0x1ed0  Ố
  208,30,6,14,14,8,1,0,4,40,80,136,120,132,132,132,132,132,132,132,132,120,
  // 0x1ed1  ố
  209,30,6,13,13,8,1,0,4,40,80,136,0,120,132,132,132,132,132,132,120,
  // 0x1ed2  Ồ
  210,30,6,14,14,8,1,0,128,80,40,68,120,132,132,132,132,132,132,132,132,120,
  // 0x1ed3  ồ
  211,30,6,13,13,8,1,0,128,80,40,68,0,120,132,132,132,132,132,132,120,
  // 0x1ed4  Ổ
  212,30,6,14,14,8,1,0,8,36,84,136,120,132,132,132,132,132,132,132,132,120,
  // 0x1ed5  ổ
  213,30,6,14,14,8,1,0,8,4,36,88,136,0,120,132,132,132,132,132,132,120,
  // 0x1ed6  Ỗ
  214,30,6,14,14,8,1,0,100,152,32,80,136,120,132,132,132,132,132,132,132,120,
  // 0x1ed7  ỗ
  215,30,6,14,14,8,1,0,100,152,32,80,136,0,120,132,132,132,132,132,132,120,
  // 0x1ed8  Ộ
  216,30,6,15,15,8,1,254,48,72,0,120,132,132,132,132,132,132,132,132,120,0,16,
  // 0x1ed9  ộ
  217,30,6,14,14,8,1,254,48,72,0,0,120,132,132,132,132,132,132,120,0,16,
  // 0x1eda  Ớ
  218,30,7,14,14,8,1,0,16,32,68,2,114,140,136,136,136,136,136,136,136,112,
  // 0x1edb  ớ
  219,30,7,12,12,8,1,0,16,32,68,2,114,140,136,136,136,136,136,112,
  // 0x1edc  Ờ
  220,30,7,14,14,8,1,0,64,32,20,2,114,140,136,136,136,136,136,136,136,112,
  // 0x1edd  ờ
  221,30,7,12,12,8,1,0,64,32,20,2,114,140,136,136,136,136,136,112,
  // 0x1ede  Ở
  222,30,7,14,14,8,1,0,32,16,20,34,114,140,136,136,136,136,136,136,136,112,
  // 0x1edf  ở
  223,30,7,13,13,8,1,0,32,16,16,36,2,114,140,136,136,136,136,136,112,
  // 0x1ee0  Ỡ
  224,30,7,13,13,8,1,0,100,152,4,114,138,140,136,136,136,136,136,136,112,
  // 0x1ee1  ỡ
  225,30,7,13,13,8,1,0,100,152,0,4,2,114,140,136,136,136,136,136,112,
  // 0x1ee2  Ợ
  226,30,7,14,14,8,1,254,4,2,114,140,136,136,136,136,136,136,136,112,0,32,
  // 0x1ee3  ợ
  227,30,7,12,12,8,1,254,4,2,114,140,136,136,136,136,136,112,0,32,
  // 0x1ee4  Ụ
  228,30,6,12,12,8,1,254,132,132,132,132,132,132,132,132,132,120,0,16,
  // 0x1ee5  ụ
  229,30,6,10,10,8,1,254,132,132,132,132,132,132,140,116,0,16,
  // 0x1ee6  Ủ
  230,30,6,14,14,8,1,0,32,16,16,32,132,132,132,132,132,132,132,132,132,120,
  // 0x1ee7  ủ
  231,30,6,13,13,8,1,0,32,16,16,32,0,132,132,132,132,132,132,140,116,
  // 0x1ee8  Ứ
  232,30,7,14,14,8,1,0,8,16,36,2,138,140,136,136,136,136,136,136,136,112,
  // 0x1ee9  ứ
  233,30,7,12,12,8,1,0,8,16,36,2,138,140,136,136,136,136,152,104,
  // 0x1eea  Ừ
  234,30,7,14,14,8,1,0,128,64,36,2,138,140,136,136,136,136,136,136,136,112,
  // 0x1eeb  ừ
  235,30,7,12,12,8,1,0,128,64,36,2,138,140,136,136,136,136,152,104,
  // 0x1eec  Ử
  236,30,7,14,14,8,1,0,32,16,20,34,138,140,136,136,136,136,136,136,136,112,
  // 0x1eed  ử
  237,30,7,13,13,8,1,0,32,16,16,36,2,138,140,136,136,136,136,152,104,
  // 0x1eee  Ữ
  238,30,7,14,14,8,1,0,100,152,4,2,138,140,136,136,136,136,136,136,136,112,
  // 0x1eef  ữ
  239,30,7,13,13,8,1,0,100,152,0,4,2,138,140,136,136,136,136,152,104,
  // 0x1ef0  Ự
  240,30,7,14,14,8,1,254,4,2,138,140,136,136,136,136,136,136,136,112,0,32,
  // 0x1ef1  ự
  241,30,7,12,12,8,1,254,4,2,138,140,136,136,136,136,152,104,0,32,
  // 0x1ef2  Ỳ
  242,30,7,14,14,8,1,0,64,32,16,0,130,130,68,68,40,16,16,16,16,16,
  // 0x1ef3  ỳ
  243,30,6,15,15,8,1,254,64,32,16,0,0,132,132,132,132,132,76,52,4,4,120,
  // 0x1ef4  Ỵ
  244,30,7,12,12,8,1,254,130,130,68,68,40,16,16,16,16,16,0,16,
  // 0x1ef5  ỵ
  245,30,6,10,10,8,1,254,132,132,132,132,132,76,52,4,120,16,
  // 0x1ef6  Ỷ
  246,30,7,14,14,8,1,0,16,8,8,16,130,130,68,68,40,16,16,16,16,16,
  // 0x1ef7  ỷ
  247,30,6,15,15,8,1,254,32,16,16,32,0,132,132,132,132,132,76,52,4,4,120,
  // 0x1ef8  Ỹ
  248,30,7,13,13,8,1,0,100,152,0,130,130,68,68,40,16,16,16,16,16,
  // 0x1ef9  ỹ
  249,30,6,14,14,8,1,254,100,152,0,0,132,132,132,132,132,76,52,4,4,120,
};

#endif // HAS_GRAPHICAL_TFT
