/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Traditional Chinese 16pt, capital 'A' height: 10px, width: 100%, range: 0x22bf-0xff1a, glyphs: 307
extern const uint8_t Unifont_Traditional_Chinese_10[12033] = {
  161,10,191,34,26,255,14,254, // unifont_t
  // 0x22bf  ⊿
  191,34,6,6,6,8,1,0,4,12,20,36,68,252,
  // 0x4e00  一
  0,78,15,1,2,16,0,6,255,254,
  // 0x4e09  三
  9,78,15,12,24,16,0,0,127,252,0,0,0,0,0,0,0,0,63,248,0,0,0,0,0,0,0,0,0,0,255,254,
  // 0x4e0a  上
  10,78,15,15,30,16,0,255,2,0,2,0,2,0,2,0,2,0,2,0,3,248,2,0,2,0,2,0,2,0,2,0,2,0,2,0,255,254,
  // 0x4e0b  下
  11,78,15,15,30,16,0,254,255,254,2,0,2,0,2,0,2,0,2,64,2,32,2,16,2,8,2,8,2,0,2,0,2,0,2,0,2,0,
  // 0x4e0d  不
  13,78,14,15,30,16,0,254,127,252,0,128,0,128,1,0,1,0,3,64,5,32,9,16,17,8,33,4,65,4,129,0,1,0,1,0,1,0,
  // 0x4e26  並
  38,78,15,15,30,16,0,255,16,16,8,32,4,64,127,252,4,64,4,64,4,64,68,68,36,68,20,72,20,80,4,64,4,64,4,64,255,254,
  // 0x4e2d  中
  45,78,11,16,32,16,2,254,4,0,4,0,4,0,4,0,255,224,132,32,132,32,132,32,132,32,132,32,255,224,132,32,4,0,4,0,4,0,4,0,
  // 0x4e3b  主
  59,78,15,15,30,16,0,255,2,0,1,0,0,0,127,252,1,0,1,0,1,0,1,0,63,248,1,0,1,0,1,0,1,0,1,0,255,254,
  // 0x4e4b  之
  75,78,14,15,30,16,1,255,4,0,2,0,2,0,0,0,255,240,0,32,0,64,0,128,1,0,2,0,4,0,8,0,48,0,72,0,135,252,
  // 0x4ea4  交
  164,78,15,16,32,16,0,254,2,0,1,0,1,0,255,254,0,0,16,16,16,8,32,36,72,36,4,64,2,128,1,0,2,128,12,64,48,48,192,14,
  // 0x4eae  亮
  174,78,15,16,32,16,0,254,2,0,1,0,127,252,0,0,15,224,8,32,15,224,0,0,127,254,64,2,135,196,4,64,4,64,8,66,48,66,192,62,
  // 0x4ee4  令
  228,78,15,16,32,16,0,254,1,0,1,0,2,128,4,64,10,32,17,16,33,8,192,6,31,240,0,16,0,32,4,64,2,128,1,0,0,128,0,128,
  // 0x4ef6  件
  246,78,15,16,32,16,0,254,8,32,8,32,9,32,17,32,17,252,50,32,50,32,84,32,144,32,23,254,16,32,16,32,16,32,16,32,16,32,16,32,
  // 0x4efd  份
  253,78,15,16,32,16,0,254,8,16,8,144,8,144,16,136,17,8,49,4,50,4,85,250,144,136,16,136,16,136,16,136,17,8,17,8,18,40,20,16,
  // 0x4f11  休
  17,79,15,16,32,16,0,254,8,64,8,64,8,64,16,64,23,254,48,64,48,224,80,224,145,80,17,80,18,72,20,68,24,66,16,64,16,64,16,64,
  // 0x4f4d  位
  77,79,15,16,32,16,0,254,8,128,8,64,8,64,16,0,23,252,48,0,48,8,82,8,146,8,17,16,17,16,17,16,17,32,16,32,31,254,16,0,
  // 0x4f4e  低
  78,79,15,16,32,16,0,254,8,8,8,60,11,224,18,32,18,32,50,32,50,32,83,254,146,32,18,16,18,16,18,18,18,10,18,138,19,38,18,18,
  // 0x4f5c  作
  92,79,15,16,32,16,0,254,9,0,9,0,9,0,17,254,18,128,50,128,52,128,80,248,144,128,16,128,16,128,16,252,16,128,16,128,16,128,16,128,
  // 0x4f9b  供
  155,79,15,16,32,16,0,254,9,16,9,16,9,16,17,16,19,252,49,16,49,16,81,16,145,16,23,254,16,0,17,16,17,8,18,8,20,4,24,4,
  // 0x4fdd  保
  221,79,15,16,32,16,0,254,8,0,11,248,10,8,18,8,18,8,51,248,48,64,80,64,151,252,16,224,17,80,18,72,20,68,24,66,16,64,16,64,
  // 0x4fe1  信
  225,79,15,16,32,16,0,254,8,64,8,32,11,254,16,0,16,0,49,252,48,0,80,0,145,252,16,0,16,0,17,252,17,4,17,4,17,252,17,4,
  // 0x500b  個
  11,80,14,16,32,16,0,254,16,0,23,252,20,68,36,68,39,252,100,68,100,68,165,244,37,20,37,20,37,20,37,244,37,20,36,4,39,252,36,4,
  // 0x503c  值
  60,80,15,16,32,16,0,254,8,64,8,64,15,252,16,64,16,64,51,248,50,8,83,248,146,8,19,248,18,8,19,248,18,8,18,8,31,254,16,0,
  // 0x504f  偏
  79,80,14,16,32,16,0,254,16,128,16,64,23,252,36,4,36,4,103,252,100,0,164,0,39,252,38,164,42,164,43,252,42,164,42,164,50,164,34,12,
  // 0x505c  停
  92,80,15,16,32,16,0,254,16,128,16,64,23,252,32,0,35,248,98,8,99,248,160,0,47,254,40,2,35,248,32,64,32,64,32,64,33,64,32,128,
  // 0x5075  偵
  117,80,15,16,32,16,0,254,16,64,16,126,16,64,32,64,39,252,100,4,100,4,167,252,36,4,39,252,36,4,36,4,39,252,33,16,34,8,36,4,
  // 0x5099  備
  153,80,15,16,32,16,0,254,8,136,8,136,11,254,16,136,16,136,55,254,48,128,81,252,147,36,21,252,17,36,17,252,17,36,17,36,17,36,17,12,
  // 0x50b3  傳
  179,80,15,16,32,16,0,254,16,64,31,254,16,64,39,252,36,68,103,252,100,68,167,252,32,66,47,254,32,16,47,254,34,16,33,16,33,80,32,32,
  // 0x50be  傾
  190,80,15,16,32,16,0,254,16,0,17,254,16,16,36,32,36,252,100,132,103,132,164,252,36,132,36,252,37,132,38,132,36,252,32,72,32,132,33,2,
  // 0x5132  儲
  50,81,15,16,32,16,0,254,20,16,18,16,18,122,47,18,32,20,111,126,96,8,175,16,32,60,47,100,41,164,41,60,41,36,47,36,41,60,32,36,
  // 0x5145  充
  69,81,15,16,32,16,0,254,2,0,1,0,255,254,4,0,4,0,8,32,16,16,63,248,4,72,4,64,4,64,4,64,8,68,8,68,16,68,96,60,
  // 0x5148  先
  72,81,15,16,32,16,0,254,1,0,17,0,17,0,31,248,33,0,65,0,1,0,255,254,4,64,4,64,4,64,8,64,8,66,16,66,32,62,192,0,
  // 0x5149  光
  73,81,15,16,32,16,0,254,1,0,33,8,17,8,9,16,9,32,1,0,255,254,4,64,4,64,4,64,4,64,8,66,8,66,16,66,32,62,192,0,
  // 0x5165  入
  101,81,15,16,32,16,0,254,4,0,2,0,1,0,1,0,1,0,2,128,2,128,2,128,4,64,4,64,8,32,8,32,16,16,32,16,64,8,128,6,
  // 0x5168  全
  104,81,15,15,30,16,0,255,1,0,1,0,2,128,4,64,8,32,16,16,47,232,193,6,1,0,1,0,31,240,1,0,1,0,1,0,127,252,
  // 0x5171  共
  113,81,14,16,32,16,1,254,8,64,8,64,8,64,8,64,127,248,8,64,8,64,8,64,8,64,8,64,255,252,0,0,8,64,16,32,32,16,64,8,
  // 0x5177  具
  119,81,15,15,30,16,0,254,31,240,16,16,16,16,31,240,16,16,31,240,16,16,31,240,16,16,16,16,255,254,4,64,8,32,16,16,32,8,
  // 0x5197  冗
  151,81,15,14,28,16,0,254,127,254,64,2,128,4,0,0,15,192,8,64,8,64,8,64,8,64,16,66,16,66,32,66,64,62,128,0,
  // 0x51b7  冷
  183,81,15,16,32,16,0,254,0,64,64,64,32,160,32,160,1,16,2,72,20,38,16,32,35,248,224,8,32,16,33,16,32,160,32,64,32,32,0,32,
  // 0x51c6  准
  198,81,15,16,32,16,0,254,1,64,65,32,33,32,35,254,2,32,22,32,27,252,18,32,34,32,35,252,226,32,34,32,34,32,35,254,34,0,2,0,
  // 0x51fa  出
  250,81,13,16,32,16,1,254,2,0,2,0,66,16,66,16,66,16,66,16,127,240,2,16,2,0,2,0,130,8,130,8,130,8,130,8,255,248,0,8,
  // 0x5206  分
  6,82,15,16,32,16,0,254,0,64,4,64,4,32,8,32,16,16,32,8,64,4,159,226,4,32,4,32,4,32,8,32,8,32,16,32,33,64,64,128,
  // 0x5217  列
  23,82,14,16,32,16,0,254,0,4,127,132,8,4,8,36,31,36,17,36,33,36,33,36,82,36,138,36,4,36,4,36,8,4,16,4,32,20,64,8,
  // 0x521d  初
  29,82,14,16,32,16,0,254,32,0,16,0,1,252,252,68,8,68,16,68,16,68,52,68,88,68,148,68,20,68,16,132,16,132,17,4,18,40,20,16,
  // 0x5230  到
  48,82,14,16,32,16,0,254,0,4,255,132,8,4,16,36,34,36,65,36,255,164,8,164,8,36,8,36,127,36,8,36,8,4,15,132,248,20,64,8,
  // 0x5236  制
  54,82,14,16,32,16,0,254,4,4,36,4,36,4,63,164,68,36,4,36,255,228,4,36,4,36,63,164,36,164,36,164,38,132,37,4,4,20,4,8,
  // 0x5237  刷
  55,82,15,16,32,16,0,254,0,2,63,194,32,66,32,66,63,210,34,18,34,18,34,18,63,210,82,82,82,82,82,82,147,66,18,130,2,10,2,4,
  // 0x5275  創
  117,82,14,16,32,16,0,254,8,4,12,4,18,4,41,36,68,164,191,36,33,36,63,36,33,36,63,36,32,36,63,36,81,4,81,4,159,20,17,8,
  // 0x529b  力
  155,82,12,16,32,16,1,254,4,0,4,0,4,0,4,0,255,240,4,16,4,16,4,16,4,16,8,16,8,16,16,16,16,16,33,16,64,160,128,64,
  // 0x52a0  加
  160,82,14,16,32,16,0,254,16,0,16,0,16,0,16,124,254,68,18,68,18,68,18,68,18,68,18,68,18,68,18,68,34,68,34,124,74,68,132,0,
  // 0x52d5  動
  213,82,14,16,32,16,0,254,15,32,120,32,8,32,255,160,8,124,127,36,73,36,127,36,73,36,127,36,8,36,127,36,8,68,15,196,248,148,65,8,
  // 0x5316  化
  22,83,15,16,32,16,0,254,8,128,8,128,8,132,16,136,16,144,48,160,48,192,80,128,145,128,18,128,20,128,16,130,16,130,16,130,16,126,16,0,
  // 0x534a  半
  74,83,15,16,32,16,0,254,1,0,33,8,17,8,9,16,9,32,1,0,63,248,1,0,1,0,1,0,255,254,1,0,1,0,1,0,1,0,1,0,
  // 0x5354  協
  84,83,15,16,32,16,0,254,32,64,32,64,35,252,32,132,248,132,33,20,34,8,32,16,36,16,47,190,36,146,36,146,36,146,40,162,42,170,49,68,
  // 0x5361  卡
  97,83,15,16,32,16,0,254,2,0,2,0,3,248,2,0,2,0,2,0,255,254,2,0,2,0,2,64,2,32,2,16,2,8,2,0,2,0,2,0,
  // 0x5370  印
  112,83,13,15,30,16,1,254,12,0,241,248,129,8,129,8,129,8,253,8,129,8,129,8,129,8,129,8,157,80,225,32,1,0,1,0,1,0,
  // 0x5378  卸
  120,83,14,16,32,16,0,254,32,0,32,0,63,124,72,68,136,68,8,68,127,68,8,68,8,68,46,68,40,68,40,84,47,72,240,64,64,64,0,64,
  // 0x537b  卻
  123,83,14,16,32,16,0,254,20,0,18,0,33,124,73,68,8,68,20,68,34,68,65,68,190,68,34,68,34,68,34,84,34,72,62,64,34,64,0,64,
  // 0x539f  原
  159,83,15,15,30,16,0,254,63,254,32,128,33,0,39,240,36,16,36,16,39,240,36,16,36,16,39,240,32,128,36,144,72,136,82,132,129,0,
  // 0x53cd  反
  205,83,15,16,32,16,0,254,0,16,0,248,63,0,32,0,32,0,63,248,36,8,36,16,34,16,34,32,33,64,32,128,65,64,66,32,140,24,48,6,
  // 0x53d6  取
  214,83,15,15,30,16,0,254,255,128,34,252,34,68,62,68,34,68,34,68,62,68,34,40,34,40,39,168,250,16,66,16,2,40,2,68,2,130,
  // 0x53f0  台
  240,83,13,16,32,16,1,254,4,0,4,0,8,0,16,64,32,32,64,16,255,248,64,8,0,0,63,224,32,32,32,32,32,32,32,32,63,224,32,32,
  // 0x5408  合
  8,84,15,16,32,16,0,254,1,0,1,0,2,128,4,64,8,32,48,24,207,230,0,0,0,0,31,240,16,16,16,16,16,16,16,16,31,240,16,16,
  // 0x5426  否
  38,84,15,15,30,16,0,254,127,252,0,128,1,0,3,0,5,96,9,24,49,4,193,2,0,0,31,240,16,16,16,16,16,16,31,240,16,16,
  // 0x544a  告
  74,84,15,16,32,16,0,254,1,0,17,0,17,0,31,248,33,0,65,0,1,0,255,254,0,0,0,0,31,240,16,16,16,16,16,16,31,240,16,16,
  // 0x547d  命
  125,84,15,16,32,16,0,254,1,0,1,0,2,128,4,64,8,32,55,216,192,6,0,0,62,248,34,136,34,136,34,136,62,168,34,144,0,128,0,128,
  // 0x548c  和
  140,84,14,16,32,16,0,254,4,0,14,0,120,0,8,124,8,68,255,68,8,68,24,68,28,68,42,68,42,68,72,68,136,124,8,68,8,0,8,0,
  // 0x555f  啟
  95,85,15,16,32,16,0,254,8,32,4,32,63,32,33,62,33,68,33,68,63,68,32,164,32,40,63,40,49,16,81,16,81,40,159,40,17,68,0,130,
  // 0x55ae  單
  174,85,15,15,30,16,0,254,126,252,66,132,66,132,126,252,0,0,63,248,33,8,63,248,33,8,63,248,1,0,255,254,1,0,1,0,1,0,
  // 0x5634  嘴
  52,86,15,16,32,16,0,254,0,144,2,148,242,216,146,146,146,210,151,14,145,240,146,16,151,252,154,68,243,252,146,68,3,252,4,68,4,84,8,8,
  // 0x5668  器
  104,86,15,15,30,16,0,254,62,124,34,68,34,68,62,124,1,32,1,16,255,254,2,128,12,96,48,24,192,6,62,124,34,68,34,68,62,124,
  // 0x5674  噴
  116,86,14,16,32,16,1,254,0,64,3,248,240,64,145,16,151,252,145,16,147,248,146,8,147,248,146,8,243,248,146,8,3,248,1,16,2,8,4,4,
  // 0x56de  回
  222,86,12,14,28,16,2,255,255,240,128,16,128,16,159,144,144,144,144,144,144,144,144,144,144,144,159,144,128,16,128,16,255,240,128,16,
  // 0x56e0  因
  224,86,13,15,30,16,1,254,255,248,128,8,130,8,130,8,130,8,191,232,130,8,133,8,132,136,136,72,144,40,160,40,128,8,255,248,128,8,
  // 0x56fa  固
  250,86,13,15,30,16,1,254,255,248,130,8,130,8,191,232,130,8,130,8,159,200,144,72,144,72,144,72,159,200,144,72,128,8,255,248,128,8,
  // 0x5716  圖
  22,87,13,16,32,16,1,254,255,248,128,8,159,200,144,72,159,200,130,8,255,248,130,8,191,232,160,40,175,168,168,168,191,232,128,8,255,248,128,8,
  // 0x5728  在
  40,87,15,16,32,16,0,254,2,0,2,0,4,0,255,254,8,0,8,64,16,64,48,64,87,252,144,64,16,64,16,64,16,64,16,64,31,254,16,0,
  // 0x578b  型
  139,87,15,15,30,16,0,255,0,4,127,132,18,36,18,36,18,36,255,164,18,36,34,4,34,20,65,8,129,0,63,248,1,0,1,0,255,254,
  // 0x57f7  執
  247,87,15,16,32,16,0,254,16,64,16,64,124,64,17,248,16,72,254,72,68,72,41,72,124,200,16,72,16,168,254,168,16,138,17,10,17,6,18,2,
  // 0x584a  塊
  74,88,15,16,32,16,0,254,32,32,32,64,35,252,34,36,34,36,251,252,34,36,34,68,35,252,32,64,32,168,56,180,225,60,65,34,2,34,4,30,
  // 0x586b  填
  107,88,15,16,32,16,0,254,32,64,32,64,39,252,32,64,35,248,250,8,35,248,34,8,35,248,34,8,35,248,58,8,239,254,65,16,2,8,4,4,
  // 0x588a  墊
  138,88,15,15,30,16,0,255,8,32,126,32,8,248,255,40,20,40,127,106,8,42,255,86,8,130,1,0,1,0,63,248,1,0,1,0,255,254,
  // 0x5916  外
  22,89,14,16,32,16,0,254,16,64,16,64,16,64,16,64,62,64,34,96,66,80,66,72,164,68,20,68,8,64,8,64,16,64,32,64,64,64,128,64,
  // 0x591a  多
  26,89,12,16,32,16,1,254,4,0,4,0,15,224,16,64,112,128,9,0,6,128,25,0,227,240,4,16,24,32,100,64,2,128,3,0,28,0,224,0,
  // 0x5920  夠
  32,89,15,16,32,16,0,254,16,32,16,32,62,64,66,126,164,130,25,2,16,122,40,74,207,74,17,74,50,122,74,74,4,2,8,2,48,20,192,8,
  // 0x5927  大
  39,89,15,16,32,16,0,254,1,0,1,0,1,0,1,0,1,0,255,254,1,0,1,0,2,128,2,128,4,64,4,64,8,32,16,16,32,8,192,6,
  // 0x5929  天
  41,89,15,15,30,16,0,254,63,248,1,0,1,0,1,0,1,0,255,254,1,0,2,128,2,128,4,64,4,64,8,32,16,16,32,8,192,6,
  // 0x5931  失
  49,89,15,16,32,16,0,254,1,0,17,0,17,0,17,0,31,248,33,0,65,0,1,0,255,254,1,0,2,128,2,128,4,64,8,32,16,16,96,12,
  // 0x59cb  始
  203,89,15,16,32,16,0,254,16,32,16,32,16,32,16,64,252,72,36,132,37,254,36,130,36,0,72,252,40,132,16,132,40,132,68,132,128,252,0,132,
  // 0x5a92  媒
  146,90,15,16,32,16,0,254,33,16,33,16,33,16,39,252,249,16,41,240,41,16,41,240,72,64,79,254,40,64,16,224,17,80,42,78,68,68,128,64,
  // 0x5b50  子
  80,91,15,15,30,16,0,254,127,248,0,16,0,32,0,64,1,128,1,0,255,254,1,0,1,0,1,0,1,0,1,0,1,0,5,0,2,0,
  // 0x5b58  存
  88,91,15,16,32,16,0,254,4,0,4,0,255,254,8,0,8,0,19,248,16,16,48,32,80,64,151,254,16,64,16,64,16,64,16,64,17,64,16,128,
  // 0x5b89  安
  137,91,15,16,32,16,0,254,2,0,1,0,63,252,32,4,66,8,2,0,2,0,255,254,4,32,8,32,24,64,6,64,1,128,2,96,12,16,112,8,
  // 0x5b8c  完
  140,91,15,16,32,16,0,254,2,0,1,0,127,254,64,2,128,4,31,240,0,0,0,0,127,252,4,64,4,64,4,64,8,68,8,68,16,68,96,60,
  // 0x5b9a  定
  154,91,15,16,32,16,0,254,2,0,1,0,127,254,64,2,128,4,0,0,63,248,1,0,1,0,17,0,17,248,17,0,17,0,41,0,71,254,128,0,
  // 0x5ba2  客
  162,91,15,16,32,16,0,254,2,0,1,0,127,254,64,2,136,4,15,240,16,32,44,64,3,128,28,112,224,14,31,240,16,16,16,16,31,240,16,16,
  // 0x5bb9  容
  185,91,15,16,32,16,0,254,2,0,1,0,127,254,64,2,136,36,17,16,34,136,4,64,8,32,48,24,223,246,16,16,16,16,16,16,31,240,16,16,
  // 0x5c0d  對
  13,92,15,16,32,16,0,254,20,8,20,8,85,8,54,8,20,126,255,8,0,8,34,72,20,40,127,40,8,8,62,8,8,8,15,8,120,40,32,16,
  // 0x5c0f  小
  15,92,15,16,32,16,0,254,1,0,1,0,1,0,1,0,1,0,17,16,17,8,17,4,33,4,33,2,65,2,129,2,1,0,1,0,5,0,2,0,
  // 0x5c31  就
  49,92,15,16,32,16,0,254,32,64,16,80,254,72,0,72,0,64,125,254,68,80,68,80,68,80,124,80,16,144,84,144,146,146,17,18,81,14,34,0,
  // 0x5de5  工
  229,93,15,12,24,16,0,0,127,252,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,255,254,
  // 0x5dee  差
  238,93,15,16,32,16,0,254,8,32,4,64,127,252,1,0,1,0,63,248,2,0,2,0,255,254,4,0,8,0,23,248,32,128,64,128,128,128,31,252,
  // 0x5df2  已
  242,93,12,14,28,16,2,255,255,192,0,64,0,64,0,64,128,64,128,64,255,192,128,0,128,0,128,0,128,16,128,16,128,16,127,240,
  // 0x5e73  平
  115,94,15,15,30,16,0,254,127,252,1,0,1,0,17,16,9,16,9,32,1,0,255,254,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
  // 0x5e8a  床
  138,94,15,16,32,16,0,254,1,0,0,128,63,254,32,0,32,128,32,128,47,252,32,128,33,192,34,160,34,160,36,144,72,136,80,134,128,128,0,128,
  // 0x5ea6  度
  166,94,15,16,32,16,0,254,1,0,0,128,63,254,34,32,34,32,63,252,34,32,34,32,35,224,32,0,47,240,36,16,66,32,65,192,134,48,56,14,
  // 0x5ee2  廢
  226,94,15,16,32,16,0,254,1,0,0,128,63,254,32,64,47,80,33,36,42,24,36,8,59,118,33,80,47,140,40,120,47,72,65,48,69,72,130,132,
  // 0x5efa  建
  250,94,15,16,32,16,0,254,0,64,0,64,251,248,8,72,23,254,16,72,35,248,120,64,11,248,8,64,72,64,55,252,16,64,44,64,67,254,128,0,
  // 0x5f15  引
  21,95,12,16,32,16,1,254,0,16,254,16,2,16,2,16,2,16,126,16,64,16,64,16,128,16,254,16,2,16,2,16,2,16,2,16,20,16,8,16,
  // 0x5f85  待
  133,95,15,16,32,16,0,254,8,64,8,64,16,64,35,252,72,64,8,64,23,254,48,16,80,16,151,254,16,16,18,16,17,16,17,16,16,80,16,32,
  // 0x5f8c  後
  140,95,15,16,32,16,0,254,8,32,8,64,16,136,33,16,75,224,8,64,16,136,51,252,80,132,144,128,17,248,19,8,20,144,16,96,17,152,22,6,
  // 0x5f91  徑
  145,95,15,16,32,16,0,254,8,0,11,252,16,0,33,36,74,72,12,144,18,72,49,36,80,0,147,252,16,64,16,64,16,64,16,64,23,254,16,0,
  // 0x5f9e  從
  158,95,15,16,32,16,0,254,8,136,8,136,16,136,32,136,73,84,10,34,20,66,48,32,80,32,145,32,17,60,17,32,18,160,18,96,20,62,24,0,
  // 0x5fa9  復
  169,95,15,16,32,16,0,254,9,0,9,0,17,254,34,0,77,252,9,4,17,252,49,4,81,252,144,128,16,252,17,8,18,144,16,96,17,152,22,6,
  // 0x5fae  微
  174,95,15,16,32,16,0,254,17,8,21,72,37,72,69,80,151,222,16,36,32,20,111,212,160,20,39,148,36,148,36,168,36,200,36,148,40,20,48,34,
  // 0x5fc3  心
  195,95,15,14,28,16,0,255,2,0,1,0,0,128,0,128,4,0,4,8,36,4,36,4,36,2,68,2,68,18,132,16,4,16,3,240,
  // 0x6027  性
  39,96,15,16,32,16,0,254,16,32,16,32,17,32,17,32,25,252,85,32,82,32,80,32,144,32,17,252,16,32,16,32,16,32,16,32,19,254,16,0,
  // 0x6062  恢
  98,96,15,16,32,16,0,254,16,64,16,64,16,64,19,254,24,128,84,144,80,144,81,18,145,82,17,84,18,144,18,40,20,40,16,68,16,132,17,2,
  // 0x606f  息
  111,96,15,15,30,16,0,255,1,0,2,0,31,240,16,16,31,240,16,16,31,240,16,16,31,240,16,16,1,0,8,132,72,146,72,18,135,240,
  // 0x61b6  憶
  182,97,15,16,32,16,0,254,16,128,16,64,19,252,25,8,84,144,87,254,80,0,147,252,18,4,19,252,18,4,19,252,16,64,21,36,21,10,24,250,
  // 0x61c9  應
  201,97,15,16,32,16,0,254,1,0,0,128,63,254,34,72,36,254,45,144,52,252,36,144,36,252,36,144,36,254,36,128,66,68,82,74,146,10,33,248,
  // 0x6210  成
  16,98,15,16,32,16,0,254,0,80,0,72,0,64,63,254,32,64,32,64,32,68,62,68,34,68,34,40,34,40,34,18,42,50,68,74,64,134,129,2,
  // 0x6236  戶
  54,98,13,16,32,16,0,254,0,16,0,248,31,0,16,0,31,248,16,8,16,8,16,8,31,248,16,8,16,0,16,0,32,0,32,0,64,0,128,0,
  // 0x6240  所
  64,98,15,16,32,16,0,254,2,8,7,28,56,224,32,128,32,128,62,128,34,254,34,136,34,136,62,136,32,136,32,136,65,8,65,8,130,8,4,8,
  // 0x6247  扇
  71,98,14,16,32,16,0,254,2,0,1,0,63,252,32,4,32,4,63,252,32,0,32,0,63,124,33,4,41,36,37,20,73,36,81,68,133,20,2,8,
  // 0x624b  手
  75,98,15,16,32,16,0,254,0,16,0,248,63,0,1,0,1,0,63,248,1,0,1,0,1,0,255,254,1,0,1,0,1,0,1,0,5,0,2,0,
  // 0x6253  打
  83,98,15,16,32,16,0,254,16,0,16,0,19,254,16,32,252,32,16,32,16,32,20,32,24,32,48,32,208,32,16,32,16,32,16,32,80,160,32,64,
  // 0x6279  批
  121,98,15,16,32,16,0,254,16,16,17,16,17,16,17,18,253,18,17,20,17,216,21,16,25,16,49,16,209,16,17,18,17,82,17,146,81,14,32,0,
  // 0x6296  抖
  150,98,15,16,32,16,0,254,16,16,17,16,16,144,16,144,252,16,17,16,16,144,20,144,24,16,48,30,211,240,16,16,16,16,16,16,80,16,32,16,
  // 0x62bd  抽
  189,98,14,16,32,16,0,254,16,32,16,32,16,32,16,32,253,252,17,36,17,36,21,36,25,36,49,252,209,36,17,36,17,36,17,36,81,252,33,4,
  // 0x62d4  拔
  212,98,15,16,32,16,0,254,16,80,16,72,16,72,16,64,251,254,16,128,20,128,24,252,49,68,209,68,17,40,17,40,18,16,18,40,84,68,33,130,
  // 0x6309  按
  9,99,15,16,32,16,0,254,16,64,16,32,16,32,19,254,250,2,20,68,16,64,27,254,48,136,208,136,17,8,16,208,16,32,16,80,80,136,35,4,
  // 0x6389  掉
  137,99,15,16,32,16,0,254,16,32,16,32,16,62,16,32,253,252,17,4,21,252,25,4,49,252,209,36,16,32,19,254,16,32,16,32,80,32,32,32,
  // 0x63a2  探
  162,99,15,16,32,16,0,254,32,0,39,252,36,4,36,164,249,16,34,8,32,64,40,64,55,252,224,64,32,224,33,80,34,72,44,70,160,64,64,64,
  // 0x63a5  接
  165,99,15,16,32,16,0,254,16,128,16,64,19,252,16,0,253,8,16,144,23,254,16,64,24,64,55,254,208,136,17,8,16,144,16,96,81,152,38,4,
  // 0x63a7  控
  167,99,15,16,32,16,0,254,16,64,16,32,16,32,19,254,250,2,20,148,17,8,26,4,48,0,209,252,16,32,16,32,16,32,16,32,87,254,32,0,
  // 0x63d0  提
  208,99,15,16,32,16,0,254,16,0,17,252,17,4,17,4,253,252,17,4,17,4,21,252,24,0,51,254,208,32,17,32,17,60,17,32,82,160,36,126,
  // 0x63d2  插
  210,99,15,16,32,16,0,254,32,8,32,60,39,192,32,64,248,64,47,254,32,64,41,64,54,92,228,68,36,68,39,92,36,68,36,68,167,252,68,4,
  // 0x63db  換
  219,99,15,16,32,16,0,254,16,128,16,128,17,248,18,8,252,16,19,254,18,2,26,82,50,138,210,34,16,32,23,254,16,80,16,136,81,4,38,2,
  // 0x64c7  擇
  199,100,15,16,32,16,0,254,16,0,19,254,18,82,19,254,252,32,17,252,20,32,27,254,48,136,208,80,17,252,16,32,23,254,16,32,80,32,32,32,
  // 0x64ca  擊
  202,100,15,16,32,16,0,254,8,60,127,36,42,36,62,66,42,60,255,164,73,24,127,102,0,32,31,192,1,0,63,248,1,0,127,252,1,0,3,0,
  // 0x64cb  擋
  203,100,15,16,32,16,0,254,32,64,34,72,33,80,39,254,244,2,40,4,35,248,34,8,51,248,224,0,39,252,36,68,39,252,36,68,167,252,68,4,
  // 0x64e0  擠
  224,100,15,16,32,16,0,254,32,128,32,64,39,252,33,16,240,164,47,88,37,84,37,82,59,88,224,0,34,8,35,248,34,8,35,248,162,8,68,8,
  // 0x6536  收
  54,101,14,16,32,16,1,254,16,128,16,128,144,128,145,0,145,252,146,16,149,16,145,16,145,16,176,160,208,160,144,64,16,160,17,16,18,8,20,4,
  // 0x653e  放
  62,101,15,16,32,16,0,254,32,64,16,64,0,64,254,128,32,254,33,8,62,136,36,136,36,136,36,80,36,80,36,32,68,80,84,136,137,4,2,2,
  // 0x6557  敗
  87,101,15,16,32,16,0,254,0,64,124,64,68,128,68,254,125,8,69,8,70,136,124,136,68,136,68,80,124,80,0,32,40,80,36,136,69,4,130,2,
  // 0x6574  整
  116,101,15,16,32,16,0,254,8,32,8,32,255,190,8,68,127,164,73,36,127,40,42,16,73,40,136,70,0,0,127,252,1,0,17,248,17,0,255,254,
  // 0x6578  數
  120,101,15,16,32,16,0,254,8,16,127,16,73,16,255,160,73,62,127,68,8,36,127,36,73,36,127,40,16,40,255,16,33,40,114,40,12,68,243,130,
  // 0x6599  料
  153,101,15,16,32,16,0,254,8,8,8,136,74,72,42,72,44,8,8,136,254,72,24,72,28,8,42,14,42,248,72,8,136,8,8,8,8,8,8,8,
  // 0x659c  斜
  156,101,15,16,32,16,0,254,8,8,8,72,20,40,34,40,65,8,190,72,8,40,8,40,127,14,8,120,42,8,41,8,73,8,136,8,40,8,16,8,
  // 0x65b0  新
  176,101,15,16,32,16,0,254,16,0,8,4,127,120,0,64,34,64,20,64,255,126,8,72,8,72,127,72,8,72,42,72,73,72,136,136,40,136,17,8,
  // 0x65b7  斷
  183,101,14,16,32,16,1,254,17,4,161,56,186,160,147,160,169,32,187,188,136,168,255,168,145,40,161,40,186,168,147,168,169,40,187,168,136,200,255,136,
  // 0x65bc  於
  188,101,15,15,30,16,0,255,32,32,16,32,0,32,254,80,32,80,32,136,61,4,38,2,36,96,36,16,36,0,36,192,68,32,84,16,136,8,
  // 0x6607  昇
  7,102,15,15,30,16,0,254,31,240,16,16,31,240,16,16,31,240,0,0,7,32,120,32,8,32,8,32,255,254,8,32,16,32,16,32,32,32,
  // 0x660e  明
  14,102,13,15,30,16,1,254,1,248,249,8,137,8,137,8,137,248,249,8,137,8,137,8,137,248,249,8,137,8,2,8,2,8,4,40,8,16,
  // 0x662f  是
  47,102,15,16,32,16,0,254,31,240,16,16,16,16,31,240,16,16,16,16,31,240,0,0,255,254,1,0,17,0,17,248,17,0,41,0,69,0,131,254,
  // 0x6642  時
  66,102,14,16,32,16,1,254,0,64,0,64,248,64,139,248,136,64,136,64,143,252,248,16,136,16,139,252,136,16,137,16,248,144,136,16,0,80,0,32,
  // 0x66ab  暫
  171,102,14,16,32,16,1,254,16,8,254,240,16,128,254,128,146,252,254,144,146,144,254,144,16,144,254,144,17,16,63,224,32,32,63,224,32,32,63,224,
  // 0x66f4  更
  244,102,15,15,30,16,0,254,255,254,1,0,1,0,63,248,33,8,33,8,63,248,33,8,33,8,63,248,17,0,10,0,6,0,25,192,224,62,
  // 0x6700  最
  0,103,15,16,32,16,0,254,31,240,16,16,31,240,16,16,31,240,0,0,255,254,34,0,62,248,34,136,62,144,34,80,47,32,242,80,66,136,3,6,
  // 0x6709  有
  9,103,15,16,32,16,0,254,2,0,2,0,255,254,4,0,4,0,15,240,8,16,24,16,47,240,72,16,136,16,15,240,8,16,8,16,8,80,8,32,
  // 0x677f  板
  127,103,15,16,32,16,0,254,16,8,16,28,17,224,17,0,253,0,17,252,49,68,57,68,85,68,85,40,145,40,17,16,17,16,18,40,18,68,20,130,
  // 0x67f1  柱
  241,103,15,16,32,16,0,254,16,64,16,32,16,0,19,254,252,32,16,32,48,32,56,32,85,252,84,32,144,32,16,32,16,32,16,32,19,254,16,0,
  // 0x6821  校
  33,104,15,16,32,16,0,254,16,64,16,32,16,32,17,254,252,0,16,136,49,4,58,2,84,136,80,136,144,80,16,80,16,32,16,80,16,136,19,6,
  // 0x683c  格
  60,104,15,16,32,16,0,254,16,128,16,128,16,248,17,8,251,16,20,160,48,64,56,160,85,24,82,6,149,248,17,8,17,8,17,8,17,248,17,8,
  // 0x689d  條
  157,104,15,16,32,16,0,254,8,64,8,64,16,252,16,136,53,80,84,32,148,216,23,38,20,32,21,252,20,32,20,168,21,36,18,34,16,160,16,64,
  // 0x68c4  棄
  196,104,15,16,32,16,0,254,2,0,1,0,127,252,16,16,63,248,1,8,17,16,255,254,17,16,31,240,1,0,127,252,5,64,25,48,225,14,1,0,
  // 0x69fd  槽
  253,105,15,16,32,16,0,254,16,144,16,144,23,254,16,144,251,252,18,148,51,252,58,148,87,252,80,0,145,248,17,8,17,248,17,8,17,248,17,8,
  // 0x6a59  橙
  89,106,15,16,32,16,0,254,16,32,23,164,16,168,18,146,249,20,18,8,53,244,56,2,87,248,82,8,146,8,19,248,18,8,17,16,31,254,16,0,
  // 0x6a5f  機
  95,106,15,16,32,16,0,254,17,36,17,36,18,170,19,174,249,36,18,170,51,174,57,36,87,254,81,16,145,20,17,20,18,138,18,74,18,22,20,34,
  // 0x6aa2  檢
  162,106,15,16,32,16,0,254,16,32,16,32,16,80,16,136,253,4,18,250,48,0,56,0,85,220,85,84,145,84,17,220,16,136,16,136,17,84,18,34,
  // 0x6b62  止
  98,107,15,15,30,16,0,255,1,0,1,0,1,0,1,0,17,0,17,0,17,248,17,0,17,0,17,0,17,0,17,0,17,0,17,0,255,254,
  // 0x6b63  正
  99,107,15,14,28,16,0,255,127,252,1,0,1,0,1,0,1,0,17,0,17,248,17,0,17,0,17,0,17,0,17,0,17,0,255,254,
  // 0x6b65  步
  101,107,15,16,32,16,0,254,1,0,1,0,17,248,17,0,17,0,17,0,255,254,1,0,1,0,17,8,17,16,33,32,64,192,3,0,28,0,224,0,
  // 0x6b78  歸
  120,107,15,16,32,16,0,254,16,0,125,252,68,4,124,252,64,4,125,252,68,0,127,254,18,34,16,32,93,252,81,36,81,36,93,52,225,40,0,32,
  // 0x6bbc  殼
  188,107,15,16,32,16,0,254,8,0,8,120,127,72,8,72,62,72,0,134,127,0,65,252,190,68,0,68,60,40,36,40,37,16,38,40,68,68,129,130,
  // 0x6bd4  比
  212,107,13,15,30,16,2,255,2,0,130,0,130,0,130,16,130,32,130,64,250,128,131,0,130,0,130,0,130,0,130,8,154,8,226,8,129,248,
  // 0x6c92  沒
  146,108,15,16,32,16,0,254,0,128,32,128,16,252,17,4,129,4,66,40,72,16,11,252,17,4,16,136,224,136,32,80,32,32,32,80,33,136,6,6,
  // 0x6d88  消
  136,109,13,16,32,16,0,254,0,64,34,72,17,72,17,80,128,64,67,248,74,8,10,8,19,248,18,8,226,8,35,248,34,8,34,8,34,40,2,16,
  // 0x6de1  淡
  225,109,15,16,32,16,0,254,0,64,34,68,18,68,20,72,128,160,65,16,70,8,16,68,16,64,34,72,226,72,36,80,32,160,33,16,34,8,12,6,
  // 0x6e05  清
  5,110,15,16,32,16,0,254,32,64,16,64,23,252,0,64,131,248,64,64,79,254,8,0,19,248,18,8,19,248,226,8,35,248,34,8,34,40,2,16,
  // 0x6e2c  測
  44,110,15,16,32,16,0,254,0,2,39,194,20,66,20,82,135,210,68,82,68,82,23,210,20,82,36,82,231,210,32,2,34,130,34,66,36,74,8,4,
  // 0x6e90  源
  144,110,15,15,30,16,0,254,39,254,20,32,20,64,133,252,69,4,69,252,21,4,21,252,37,36,228,32,36,168,41,36,42,34,48,160,0,64,
  // 0x6e96  準
  150,110,15,16,32,16,0,254,33,64,17,32,131,252,82,64,23,248,42,64,227,248,34,64,35,252,34,0,1,0,255,254,1,0,1,0,1,0,1,0,
  // 0x6eab  溫
  171,110,15,15,30,16,0,255,64,0,35,248,34,72,10,72,138,168,83,8,83,248,34,8,32,0,199,252,68,164,68,164,68,164,68,164,79,254,
  // 0x6fc0  激
  192,111,15,16,32,16,0,254,2,16,68,16,47,144,40,144,15,190,136,164,79,212,84,20,18,20,47,212,228,20,39,136,36,136,40,148,42,148,17,34,
  // 0x7121  無
  33,113,14,16,32,16,0,254,16,0,16,0,31,252,42,160,74,160,10,160,127,252,10,160,10,160,10,160,127,252,0,0,36,136,34,68,66,68,128,4,
  // 0x71b1  熱
  177,113,15,16,32,16,0,254,16,64,16,64,124,64,16,248,254,72,68,72,146,200,124,72,16,170,28,170,225,6,66,2,0,0,72,136,68,68,132,68,
  // 0x71c8  燈
  200,113,15,16,32,16,0,254,32,32,39,164,32,168,42,146,177,20,162,8,165,244,168,2,35,248,34,8,34,8,35,248,82,8,73,16,79,254,128,0,
  // 0x7247  片
  71,114,13,16,32,16,1,254,0,128,32,128,32,128,32,128,32,128,63,248,32,0,32,0,32,0,63,192,32,64,32,64,32,64,64,64,64,64,128,64,
  // 0x7269  物
  105,114,14,16,32,16,0,254,16,128,16,128,80,128,80,252,125,84,82,84,144,84,16,148,28,148,241,36,82,36,16,68,16,68,16,132,17,40,16,16,
  // 0x7387  率
  135,115,15,16,32,16,0,254,2,0,1,0,127,252,2,0,68,68,47,136,17,16,34,72,79,228,0,32,1,0,255,254,1,0,1,0,1,0,1,0,
  // 0x7528  用
  40,117,13,15,30,16,0,254,63,248,33,8,33,8,33,8,63,248,33,8,33,8,33,8,63,248,33,8,33,8,33,8,65,8,65,40,128,16,
  // 0x754c  界
  76,117,15,15,30,16,0,254,31,240,17,16,17,16,31,240,17,16,17,16,31,240,2,128,12,96,52,88,196,70,4,64,8,64,8,64,16,64,
  // 0x767d  白
  125,118,11,16,32,16,2,254,4,0,8,0,16,0,255,224,128,32,128,32,128,32,128,32,255,224,128,32,128,32,128,32,128,32,128,32,255,224,128,32,
  // 0x7684  的
  132,118,13,16,32,16,1,254,32,128,32,128,64,128,252,248,133,8,133,8,134,8,132,136,252,72,132,72,132,8,132,8,132,8,252,8,132,80,0,32,
  // 0x76e3  監
  227,118,15,14,28,16,0,255,63,32,36,32,63,62,33,64,63,80,36,136,63,8,0,0,63,248,36,72,36,72,36,72,36,72,255,254,
  // 0x76f4  直
  244,118,15,15,30,16,0,255,1,0,1,0,127,252,1,0,31,240,16,16,16,16,31,240,16,16,31,240,16,16,31,240,16,16,16,16,255,254,
  // 0x7720  眠
  32,119,14,15,30,16,1,254,3,248,250,8,138,8,138,8,251,248,138,64,138,64,251,252,138,64,138,64,138,32,250,36,138,148,3,12,2,4,
  // 0x780d  砍
  13,120,15,16,32,16,0,254,0,64,0,64,252,64,16,124,16,132,32,136,61,32,100,32,100,32,164,80,36,80,36,80,60,136,36,136,33,4,2,2,
  // 0x78ba  確
  186,120,15,16,32,16,0,254,0,64,0,64,251,254,34,162,32,144,65,254,121,16,75,16,205,254,73,16,73,16,73,254,121,16,73,16,1,254,1,0,
  // 0x79fb  移
  251,121,15,16,32,16,0,254,8,32,28,32,240,124,16,132,17,72,252,48,16,32,48,72,57,144,84,62,84,66,145,164,16,24,16,16,16,96,17,128,
  // 0x7a4d  積
  77,122,15,16,32,16,0,254,8,32,29,254,240,32,17,252,16,32,253,254,16,0,49,252,57,4,85,252,85,4,145,252,17,4,17,252,16,136,17,4,
  // 0x7aef  端
  239,122,15,16,32,16,0,254,32,32,17,36,17,36,253,36,1,252,8,0,139,254,136,32,72,64,73,252,81,84,81,84,29,84,225,84,65,84,1,12,
  // 0x7b49  等
  73,123,15,16,32,16,0,254,32,64,63,126,72,144,133,8,1,0,63,248,1,0,1,0,255,254,0,0,0,32,127,252,8,32,4,32,4,160,0,64,
  // 0x7ba1  管
  161,123,15,16,32,16,0,254,32,64,63,126,72,144,133,8,1,0,127,254,64,2,159,228,16,32,31,224,16,0,31,240,16,16,16,16,31,240,16,16,
  // 0x7bb1  箱
  177,123,15,16,32,16,0,254,16,64,16,64,63,126,40,144,69,8,136,0,8,252,126,132,8,132,24,252,28,132,42,132,42,252,72,132,136,132,8,252,
  // 0x7cfb  系
  251,124,13,16,32,16,1,254,1,240,126,0,8,0,16,64,32,128,127,0,2,0,12,32,48,16,255,248,2,8,18,64,34,32,66,16,138,8,4,0,
  // 0x7d05  紅
  5,125,15,15,30,16,0,255,16,0,16,0,33,252,36,32,68,32,248,32,16,32,32,32,72,32,252,32,4,32,0,32,84,32,84,32,131,254,
  // 0x7d22  索
  34,125,15,16,32,16,0,254,1,0,1,0,63,248,1,0,1,0,127,254,66,2,132,36,31,192,1,128,6,16,63,248,1,8,17,32,37,16,66,8,
  // 0x7d2b  紫
  43,125,14,16,32,16,0,254,8,128,40,136,46,240,40,132,46,132,240,124,2,0,4,32,31,192,1,128,6,16,63,248,1,8,17,32,37,16,66,8,
  // 0x7d30  細
  48,125,14,16,32,16,0,254,16,0,16,0,33,252,37,36,69,36,249,36,17,36,33,36,73,252,253,36,5,36,1,36,85,36,85,36,129,252,1,4,
  // 0x7d42  終
  66,125,15,16,32,16,0,254,16,64,16,64,32,124,40,132,73,136,242,80,16,32,32,80,72,136,251,6,8,96,0,16,168,8,168,192,128,32,0,16,
  // 0x7d71  統
  113,125,15,16,32,16,0,254,16,64,16,32,32,32,43,254,72,64,240,136,17,4,35,254,72,146,252,144,4,144,0,144,85,18,85,18,130,14,4,0,
  // 0x7d72  絲
  114,125,15,16,32,16,0,254,16,32,16,32,32,72,36,136,69,240,248,32,16,64,32,136,73,252,252,36,4,32,0,168,85,36,86,34,128,160,0,64,
  // 0x7da0  綠
  160,125,15,16,32,16,0,254,16,128,16,248,32,136,41,8,73,240,240,16,16,16,35,254,72,32,250,34,9,116,0,168,169,36,170,34,128,160,0,64,
  // 0x7db2  網
  178,125,15,16,32,16,0,254,16,0,17,254,33,2,33,138,73,82,249,254,17,34,33,18,33,254,73,66,245,66,1,122,85,2,85,2,85,10,129,4,
  // 0x7dd2  緒
  210,125,15,16,32,16,0,254,16,32,16,34,33,250,36,36,68,40,251,254,16,32,32,64,72,252,253,132,6,132,0,252,84,132,84,132,128,252,0,132,
  // 0x7dda  線
  218,125,15,16,32,16,0,254,16,64,16,128,33,252,41,4,73,252,241,4,17,252,32,32,72,50,251,180,8,168,1,40,169,36,170,36,132,162,0,64,
  // 0x7de8  編
  232,125,15,16,32,16,0,254,16,64,16,32,33,254,37,2,69,2,249,254,17,0,33,0,73,254,253,170,5,170,2,254,170,170,170,170,132,162,0,134,
  // 0x7e2e  縮
  46,126,15,16,32,16,0,254,16,32,16,16,35,254,42,2,72,128,240,254,17,16,35,32,77,124,249,68,9,68,1,124,169,68,169,68,129,124,1,68,
  // 0x7e3d  總
  61,126,15,16,32,16,0,254,16,32,16,64,33,252,37,36,69,124,249,140,17,84,33,36,73,84,253,252,4,32,0,16,85,84,85,66,129,74,2,56,
  // 0x7e7c  繼
  124,126,15,16,32,16,0,254,16,68,18,132,34,234,42,78,74,164,242,238,18,34,35,254,74,68,250,132,10,234,2,78,170,164,170,238,130,34,3,254,
  // 0x7e8c  續
  140,126,15,16,32,16,0,254,16,32,19,254,32,32,41,252,72,0,243,254,18,82,35,254,73,4,253,252,5,4,1,252,85,4,85,252,128,136,1,4,
  // 0x7ea2  红
  162,126,15,15,30,16,0,255,16,0,16,0,33,252,36,32,68,32,248,32,16,32,32,32,64,32,252,32,64,32,0,32,28,32,224,32,67,254,
  // 0x7f6e  置
  110,127,15,16,32,16,0,254,127,252,68,68,68,68,127,252,1,0,255,254,2,0,31,240,16,16,31,240,16,16,31,240,16,16,31,240,16,16,255,254,
  // 0x7f72  署
  114,127,15,15,30,16,0,254,63,248,36,72,36,72,63,248,2,0,31,208,2,32,255,254,3,0,15,240,56,16,207,240,8,16,15,240,8,16,
  // 0x8070  聰
  112,128,15,16,32,16,0,254,0,32,252,64,73,252,73,36,121,124,73,140,73,84,121,36,73,84,73,252,76,64,120,36,202,162,10,138,12,136,8,120,
  // 0x81ea  自
  234,129,9,16,32,16,3,254,8,0,16,0,32,0,255,128,128,128,128,128,128,128,255,128,128,128,128,128,255,128,128,128,128,128,128,128,255,128,128,128,
  // 0x85cd  藍
  205,133,15,16,32,16,0,254,8,32,255,254,8,32,0,0,63,32,36,32,63,62,33,64,63,80,36,136,63,8,0,0,63,248,36,72,36,72,255,254,
  // 0x884c  行
  76,136,15,16,32,16,0,254,8,0,9,252,16,0,32,0,72,0,8,0,19,254,48,32,80,32,144,32,16,32,16,32,16,32,16,32,16,160,16,64,
  // 0x8868  表
  104,136,15,16,32,16,0,254,1,0,1,0,127,252,1,0,1,0,63,248,1,0,1,0,255,254,5,0,8,136,24,80,40,32,201,24,10,6,12,0,
  // 0x88ab  被
  171,136,15,16,32,16,0,254,32,16,16,16,0,16,249,254,9,18,17,20,21,16,57,252,85,68,145,68,17,40,17,40,17,16,18,40,18,68,20,130,
  // 0x88c5  装
  197,136,15,16,32,16,0,254,8,32,72,32,43,254,8,32,24,32,40,32,201,252,10,0,1,0,255,254,5,0,12,136,52,80,197,48,6,14,4,0,
  // 0x88dd  裝
  221,136,15,16,32,16,0,254,36,32,36,32,60,32,5,252,252,32,36,32,36,248,70,0,1,0,255,254,5,0,12,136,52,80,197,48,6,14,4,0,
  // 0x8907  複
  7,137,15,16,32,16,0,254,33,0,17,0,1,254,250,0,13,252,17,4,17,252,53,4,89,252,148,128,20,252,17,8,18,144,16,96,17,152,22,6,
  // 0x89d2  角
  210,137,13,16,32,16,0,254,8,0,8,0,31,224,32,32,64,64,191,248,33,8,33,8,63,248,33,8,33,8,63,248,33,8,65,8,65,40,128,16,
  // 0x8a08  計
  8,138,15,16,32,16,0,254,32,32,16,32,16,32,254,32,0,32,124,32,3,254,124,32,0,32,124,32,68,32,68,32,68,32,124,32,68,32,0,32,
  // 0x8a0a  訊
  10,138,15,16,32,16,0,254,32,0,19,240,0,144,252,144,0,144,120,144,0,144,123,240,0,144,120,144,72,144,72,146,72,138,120,138,72,134,0,130,
  // 0x8a18  記
  24,138,15,15,30,16,0,255,32,0,16,0,16,252,254,4,0,4,124,4,0,4,124,252,0,132,124,128,68,128,68,128,68,130,124,130,68,126,
  // 0x8a2d  設
  45,138,15,16,32,16,0,254,32,0,16,248,16,136,254,136,0,136,125,6,2,0,125,252,0,132,124,132,68,72,68,80,68,32,124,80,68,136,3,6,
  // 0x8a66  試
  102,138,15,16,32,16,0,254,32,16,16,20,0,18,252,16,3,254,120,16,0,16,121,208,0,144,120,144,72,144,72,136,72,234,123,138,72,6,0,2,
  // 0x8a8d  認
  141,138,15,15,30,16,0,255,32,0,19,252,0,68,253,68,1,68,122,132,0,148,121,8,2,64,120,32,72,164,74,130,74,138,122,138,68,120,
  // 0x8aa4  誤
  164,138,15,16,32,16,0,254,32,0,17,252,1,4,253,4,1,252,120,0,0,0,121,252,0,32,120,32,75,254,72,32,72,80,120,136,73,4,2,2,
  // 0x8abf  調
  191,138,14,16,32,16,0,254,32,0,17,252,1,36,253,36,1,116,121,36,1,252,121,4,1,116,121,84,73,84,73,116,73,4,122,4,74,20,4,8,
  // 0x8acb  請
  203,138,15,16,32,16,0,254,32,32,16,32,3,254,252,32,1,252,120,32,3,254,120,0,1,252,121,4,73,252,73,4,73,252,121,4,73,20,1,8,
  // 0x8b70  議
  112,139,15,16,32,16,0,254,33,4,16,136,3,254,252,32,1,252,120,32,3,254,120,84,1,146,120,144,75,254,72,144,72,212,123,138,72,150,1,162,
  // 0x8b80  讀
  128,139,15,16,32,16,0,254,32,32,19,254,0,32,253,252,0,0,123,254,2,82,123,254,1,4,121,252,73,4,73,252,73,4,121,252,72,136,1,4,
  // 0x8b8a  變
  138,139,15,16,32,16,0,254,33,4,71,200,136,18,243,188,32,8,75,146,248,62,3,128,170,170,171,170,8,0,31,248,40,32,7,192,24,48,224,14,
  // 0x8cc7  資
  199,140,15,16,32,16,0,254,65,0,33,252,10,68,16,72,224,160,33,24,38,6,31,240,16,16,31,240,16,16,31,240,16,16,31,240,8,32,16,16,
  // 0x8ddd  距
  221,141,15,14,28,16,0,255,125,254,69,0,69,0,69,0,125,252,17,4,17,4,93,4,81,4,81,252,81,0,93,0,225,0,1,254,
  // 0x8eca  車
  202,142,15,16,32,16,0,254,1,0,1,0,127,252,1,0,63,248,33,8,33,8,63,248,33,8,33,8,63,248,1,0,255,254,1,0,1,0,1,0,
  // 0x8edf  軟
  223,142,15,16,32,16,0,254,16,64,16,64,16,64,254,124,16,132,124,136,85,32,124,32,84,32,124,80,16,80,254,80,16,136,16,136,17,4,18,2,
  // 0x8ef8  軸
  248,142,14,16,32,16,0,254,16,32,16,32,16,32,254,32,17,252,125,36,85,36,125,36,85,36,125,252,17,36,255,36,17,36,17,36,17,252,17,4,
  // 0x8f09  載
  9,143,15,16,32,16,0,254,8,32,127,40,8,36,255,254,8,32,255,160,8,36,127,36,73,36,127,40,73,40,127,16,8,18,255,170,8,70,8,130,
  // 0x8f2f  輯
  47,143,15,16,32,16,0,254,16,0,16,248,16,136,254,136,16,248,124,0,85,254,124,136,84,248,124,136,16,248,254,136,16,158,19,232,16,8,16,8,
  // 0x8f38  輸
  56,143,15,16,32,16,0,254,32,64,32,160,33,16,250,8,37,246,248,0,171,196,250,84,170,84,251,212,34,84,250,84,35,212,34,68,34,84,34,200,
  // 0x8f49  轉
  73,143,15,16,32,16,0,254,16,32,19,254,16,32,253,252,17,36,125,252,85,36,125,252,84,34,125,254,16,8,253,254,17,8,16,136,16,40,16,16,
  // 0x8fd1  近
  209,143,15,15,30,16,0,255,0,8,32,28,17,224,17,0,1,0,1,254,241,16,17,16,17,16,17,16,18,16,18,16,20,16,40,0,71,254,
  // 0x8fd4  返
  212,143,15,15,30,16,0,255,0,8,32,60,19,192,18,0,2,0,3,252,242,4,18,136,18,80,18,32,18,80,20,136,21,4,40,0,71,254,
  // 0x9000  退
  0,144,15,15,30,16,0,255,3,248,34,8,18,8,19,248,2,8,2,8,243,248,18,68,18,40,18,16,18,136,19,4,18,4,40,0,71,254,
  // 0x901f  速
  31,144,15,15,30,16,0,255,0,64,32,64,23,252,16,64,3,248,2,72,242,72,19,248,16,224,17,80,18,72,20,68,16,64,40,0,71,254,
  // 0x9023  連
  35,144,15,15,30,16,0,255,0,64,64,64,47,254,32,64,7,252,4,68,231,252,36,68,39,252,32,64,47,254,32,64,32,64,80,64,143,254,
  // 0x9032  進
  50,144,15,15,30,16,0,255,1,64,33,32,19,254,18,32,6,32,11,252,242,32,18,32,19,252,18,32,18,32,19,254,18,0,40,0,71,254,
  // 0x904b  運
  75,144,15,14,28,16,0,255,39,252,20,68,19,248,0,64,3,248,242,72,19,248,18,72,19,248,16,64,23,252,16,64,40,64,71,254,
  // 0x9054  達
  84,144,15,15,30,16,0,255,0,64,32,64,19,248,16,64,7,252,1,16,240,160,23,252,16,64,19,248,16,64,23,252,16,64,40,64,71,254,
  // 0x9078  選
  120,144,15,15,30,16,0,255,15,60,73,36,47,60,40,162,7,158,1,16,231,252,33,16,33,16,47,254,33,16,34,8,36,4,80,0,143,254,
  // 0x9084  還
  132,144,15,14,28,16,0,255,71,252,36,164,39,252,0,0,15,254,224,0,35,248,34,8,35,248,33,68,35,40,45,144,81,8,143,254,
  // 0x908a  邊
  138,144,15,16,32,16,0,254,0,128,71,248,37,72,36,168,7,248,0,64,239,252,42,20,36,136,43,244,33,0,33,240,34,16,36,48,80,0,143,254,
  // 0x90e8  部
  232,144,15,16,32,16,0,254,16,0,8,62,127,162,0,36,33,36,18,40,255,228,0,36,0,34,63,34,33,34,33,52,33,40,63,32,33,32,0,32,
  // 0x91cb  釋
  203,145,15,16,32,16,0,254,12,0,241,252,17,84,85,252,56,32,17,252,252,32,19,254,48,136,56,80,85,252,80,32,147,254,16,32,16,32,16,32,
  // 0x91cd  重
  205,145,15,15,30,16,0,255,0,16,0,248,63,0,1,0,255,254,1,0,31,240,17,16,31,240,17,16,31,240,1,0,63,248,1,0,255,254,
  // 0x91cf  量
  207,145,15,15,30,16,0,254,31,240,16,16,31,240,16,16,255,254,0,0,31,240,17,16,31,240,17,16,31,240,1,0,31,240,1,0,127,252,
  // 0x91dd  針
  221,145,15,16,32,16,0,254,16,32,16,32,40,32,36,32,66,32,188,32,19,254,16,32,254,32,16,32,148,32,88,32,80,32,30,32,240,32,64,32,
  // 0x9215  鈕
  21,146,15,16,32,16,0,254,16,0,17,248,40,72,36,72,64,72,184,72,16,72,17,248,252,136,16,136,148,136,88,136,80,136,28,136,227,254,64,0,
  // 0x932f  錯
  47,147,15,16,32,16,0,254,16,72,16,72,40,72,37,254,66,72,188,72,17,254,16,0,254,252,16,132,148,132,88,252,80,132,30,132,240,252,64,132,
  // 0x9375  鍵
  117,147,15,15,30,16,0,255,32,16,32,16,87,124,73,20,129,254,114,20,34,124,39,16,241,124,37,16,165,254,114,16,34,16,53,0,200,254,
  // 0x9577  長
  119,149,15,15,30,16,0,254,15,248,8,0,15,240,8,0,15,240,8,0,255,254,18,0,17,16,16,160,16,64,18,32,20,24,24,6,16,0,
  // 0x9589  閉
  137,149,13,15,30,16,1,254,248,248,136,136,248,248,136,136,248,248,129,8,129,8,159,232,131,8,133,8,137,8,145,8,133,8,130,40,128,16,
  // 0x958b  開
  139,149,12,15,30,16,1,254,249,240,137,16,249,240,137,16,249,240,128,16,159,144,137,16,137,16,191,208,137,16,137,16,145,16,161,80,128,32,
  // 0x9593  間
  147,149,12,15,30,16,1,254,249,240,137,16,249,240,137,16,249,240,128,16,159,144,144,144,159,144,144,144,159,144,144,144,128,16,128,80,128,32,
  // 0x95dc  關
  220,149,13,16,32,16,1,254,248,248,136,136,248,248,136,136,248,248,144,136,165,40,185,200,148,168,189,232,133,8,165,40,189,232,133,8,137,40,145,16,
  // 0x964d  降
  77,150,14,16,32,16,1,254,1,0,249,0,137,248,146,16,149,32,160,192,147,48,156,76,136,64,139,248,136,64,212,64,167,252,128,64,128,64,128,64,
  // 0x9664  除
  100,150,14,15,30,16,1,254,240,128,144,128,161,64,162,32,196,16,171,236,144,128,144,128,151,248,208,128,162,160,132,144,136,136,130,136,129,0,
  // 0x968e  階
  142,150,14,16,32,16,1,254,2,32,250,36,139,168,146,48,146,164,163,36,146,92,144,128,139,248,138,8,138,8,211,248,162,8,130,8,131,248,130,8,
  // 0x96d9  雙
  217,150,15,16,32,16,0,254,8,16,36,72,63,126,100,200,191,126,36,72,63,126,36,72,63,126,32,64,31,240,8,32,4,64,3,128,28,112,224,14,
  // 0x96e2  離
  226,150,14,16,32,16,1,254,32,80,16,72,254,128,40,252,147,144,170,144,130,252,254,144,16,144,254,252,162,144,170,144,186,144,130,252,138,128,132,128,
  // 0x96fb  電
  251,150,15,16,32,16,0,254,63,248,1,0,127,254,65,2,157,116,1,0,29,112,0,0,63,248,33,8,63,248,33,8,63,248,1,2,1,2,0,254,
  // 0x9752  青
  82,151,15,16,32,16,0,254,1,0,1,0,127,252,1,0,63,248,1,0,255,254,0,0,31,240,16,16,31,240,16,16,31,240,16,16,16,80,16,32,
  // 0x975e  非
  94,151,15,16,32,16,0,254,4,64,4,64,4,64,252,126,4,64,4,64,4,64,124,124,4,64,4,64,4,64,4,64,252,126,4,64,4,64,4,64,
  // 0x9762  面
  98,151,15,15,30,16,0,254,255,254,2,0,2,0,4,0,63,248,36,72,36,72,39,200,36,72,36,72,39,200,36,72,36,72,63,248,32,8,
  // 0x9805  項
  5,152,15,15,30,16,0,254,1,254,0,32,252,64,17,252,17,4,17,4,17,252,17,4,17,252,17,4,29,4,225,252,64,136,1,4,2,2,
  // 0x9810  預
  16,152,15,15,30,16,0,254,124,254,4,16,40,32,16,252,8,132,254,132,18,252,20,132,16,252,16,132,16,132,16,252,16,72,80,132,33,2,
  // 0x984d  額
  77,152,15,16,32,16,0,254,32,0,16,254,254,16,130,32,32,252,60,132,68,132,168,252,16,132,40,252,68,132,254,132,68,252,68,72,124,132,69,2,
  // 0x985e  類
  94,152,15,16,32,16,0,254,16,0,146,254,84,16,254,32,48,252,84,132,146,132,0,252,20,132,18,252,254,132,16,132,40,252,36,72,68,132,129,2,
  // 0x98a8  風
  168,152,15,15,30,16,0,254,63,248,32,8,32,232,47,8,33,8,47,232,41,40,41,40,47,232,41,8,33,74,33,234,94,42,72,6,128,2,
  // 0x98fd  飽
  253,152,15,16,32,16,0,254,8,64,8,64,20,252,18,132,41,4,126,244,162,148,62,148,34,244,62,132,32,148,40,136,36,130,42,130,50,126,32,0,
  // 0x9918  餘
  24,153,15,16,32,16,0,254,8,16,8,16,20,40,18,40,41,68,126,186,162,16,62,16,34,254,62,16,32,88,40,84,36,146,43,18,50,80,32,32,
  // 0x99ac  馬
  172,153,13,15,30,16,0,254,63,248,33,0,63,240,33,0,63,240,33,0,33,0,63,248,0,8,18,72,73,40,73,40,128,8,0,80,0,32,
  // 0x9a45  驅
  69,154,15,15,30,16,0,254,251,254,162,0,250,124,162,68,250,68,162,124,162,0,250,238,10,170,170,170,170,170,170,238,138,0,11,254,48,0,
  // 0x9ad4  體
  212,154,15,16,32,16,0,254,0,80,125,252,69,84,117,252,85,84,255,252,130,0,125,252,68,0,125,252,69,4,125,252,68,136,68,80,87,254,72,0,
  // 0x9ad8  高
  216,154,15,16,32,16,0,254,2,0,1,0,255,254,0,0,15,224,8,32,8,32,15,224,0,0,127,252,64,4,79,228,72,36,72,36,79,228,64,12,
  // 0x9ec3  黃
  195,158,15,16,32,16,0,254,8,32,127,252,8,32,15,224,0,0,255,254,1,0,31,240,17,16,17,16,31,240,17,16,17,16,31,240,8,32,16,16,
  // 0x9ede  點
  222,158,15,16,32,16,0,254,0,16,254,16,146,16,214,16,186,30,146,16,254,16,16,16,254,254,16,130,30,130,224,130,2,130,170,130,168,254,128,130,
  // 0x9f4a  齊
  74,159,15,16,32,16,0,254,2,0,1,0,127,252,4,64,2,140,125,112,37,80,37,80,69,72,141,102,16,16,31,240,16,16,31,240,16,16,32,16,
  // 0xff1a  ：
  26,255,4,7,7,16,6,1,240,240,0,0,0,240,240,
};

#endif // HAS_GRAPHICAL_TFT
