/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Simplified Chinese 16pt, capital 'A' height: 10px, width: 100%, range: 0x201c-0xff1a, glyphs: 373
extern const uint8_t Unifont_Simplified_Chinese_10[14547] = {
  161,10,28,32,26,255,14,254, // unifont_t
  // 0x201c  “
  28,32,6,4,4,8,1,8,68,136,136,204,
  // 0x201d  ”
  29,32,6,4,4,8,1,8,204,68,68,136,
  // 0x22bf  ⊿
  191,34,6,6,6,8,1,0,4,12,20,36,68,252,
  // 0x4e00  一
  0,78,15,1,2,16,0,6,255,254,
  // 0x4e09  三
  9,78,15,12,24,16,0,0,127,252,0,0,0,0,0,0,0,0,63,248,0,0,0,0,0,0,0,0,0,0,255,254,
  // 0x4e0a  上
  10,78,15,15,30,16,0,255,2,0,2,0,2,0,2,0,2,0,2,0,3,248,2,0,2,0,2,0,2,0,2,0,2,0,2,0,255,254,
  // 0x4e0b  下
  11,78,15,15,30,16,0,254,255,254,2,0,2,0,2,0,2,0,2,64,2,32,2,16,2,8,2,8,2,0,2,0,2,0,2,0,2,0,
  // 0x4e0d  不
  13,78,14,15,30,16,0,254,127,252,0,128,0,128,1,0,1,0,3,64,5,32,9,16,17,8,33,4,65,4,129,0,1,0,1,0,1,0,
  // 0x4e13  专
  19,78,15,16,32,16,0,254,1,0,1,0,1,0,63,248,2,0,2,0,255,254,4,0,8,0,15,240,0,16,0,32,6,64,1,128,0,64,0,32,
  // 0x4e1d  丝
  29,78,15,15,30,16,0,255,8,16,8,16,16,32,16,32,34,68,66,132,124,248,4,8,8,16,16,32,32,64,126,252,0,0,0,0,255,254,
  // 0x4e2a  个
  42,78,15,16,32,16,0,254,1,0,1,0,2,128,4,64,8,32,16,16,33,8,193,6,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
  // 0x4e2d  中
  45,78,11,16,32,16,2,254,4,0,4,0,4,0,4,0,255,224,132,32,132,32,132,32,132,32,132,32,255,224,132,32,4,0,4,0,4,0,4,0,
  // 0x4e3a  为
  58,78,13,16,32,16,0,254,1,0,33,0,17,0,17,0,1,0,127,248,2,8,2,8,2,136,4,72,4,72,8,8,16,8,32,8,64,80,128,32,
  // 0x4e3b  主
  59,78,15,15,30,16,0,255,2,0,1,0,0,0,127,252,1,0,1,0,1,0,1,0,63,248,1,0,1,0,1,0,1,0,1,0,255,254,
  // 0x4e49  义
  73,78,15,16,32,16,0,254,2,0,1,16,33,16,32,16,16,32,16,32,8,32,8,64,4,64,2,128,1,0,2,128,4,64,8,32,48,24,192,6,
  // 0x4e4b  之
  75,78,14,15,30,16,1,255,4,0,2,0,2,0,0,0,255,240,0,32,0,64,0,128,1,0,2,0,4,0,8,0,48,0,72,0,135,252,
  // 0x4e86  了
  134,78,12,15,30,16,1,254,255,240,0,32,0,64,0,128,3,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,10,0,4,0,
  // 0x4e8c  二
  140,78,15,10,20,16,0,1,63,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,254,
  // 0x4e8e  于
  142,78,15,15,30,16,0,254,63,248,1,0,1,0,1,0,1,0,255,254,1,0,1,0,1,0,1,0,1,0,1,0,1,0,5,0,2,0,
  // 0x4ea4  交
  164,78,15,16,32,16,0,254,2,0,1,0,1,0,255,254,0,0,16,16,16,8,32,36,72,36,4,64,2,128,1,0,2,128,12,64,48,48,192,14,
  // 0x4eae  亮
  174,78,15,16,32,16,0,254,2,0,1,0,127,252,0,0,15,224,8,32,15,224,0,0,127,254,64,2,135,196,4,64,4,64,8,66,48,66,192,62,
  // 0x4ece  从
  206,78,15,16,32,16,0,254,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,32,8,80,20,80,18,80,18,136,32,136,33,4,66,4,132,2,
  // 0x4ee4  令
  228,78,15,16,32,16,0,254,1,0,1,0,2,128,4,64,10,32,17,16,33,8,192,6,31,240,0,16,0,32,4,64,2,128,1,0,0,128,0,128,
  // 0x4ee5  以
  229,78,13,16,32,16,2,254,0,64,16,64,136,64,132,64,132,64,128,64,128,64,128,128,128,128,128,128,145,0,161,64,194,32,132,16,8,8,16,8,
  // 0x4ef6  件
  246,78,15,16,32,16,0,254,8,32,8,32,9,32,17,32,17,252,50,32,50,32,84,32,144,32,23,254,16,32,16,32,16,32,16,32,16,32,16,32,
  // 0x4efd  份
  253,78,15,16,32,16,0,254,8,16,8,144,8,144,16,136,17,8,49,4,50,4,85,250,144,136,16,136,16,136,16,136,17,8,17,8,18,40,20,16,
  // 0x4f11  休
  17,79,15,16,32,16,0,254,8,64,8,64,8,64,16,64,23,254,48,64,48,224,80,224,145,80,17,80,18,72,20,68,24,66,16,64,16,64,16,64,
  // 0x4f20  传
  32,79,15,16,32,16,0,254,8,64,8,64,8,64,19,248,16,64,48,128,55,254,80,128,145,0,19,248,16,8,17,16,16,160,16,64,16,32,16,32,
  // 0x4f4d  位
  77,79,15,16,32,16,0,254,8,128,8,64,8,64,16,0,23,252,48,0,48,8,82,8,146,8,17,16,17,16,17,16,17,32,16,32,31,254,16,0,
  // 0x4f4e  低
  78,79,15,16,32,16,0,254,8,8,8,60,11,224,18,32,18,32,50,32,50,32,83,254,146,32,18,16,18,16,18,18,18,10,18,138,19,38,18,18,
  // 0x4f53  体
  83,79,15,16,32,16,0,254,8,64,8,64,8,64,16,64,23,252,48,64,48,224,80,224,145,80,17,80,18,72,21,244,24,66,16,64,16,64,16,64,
  // 0x4f59  余
  89,79,15,16,32,16,0,254,1,0,1,0,2,128,4,64,8,32,16,16,47,232,193,6,1,0,63,248,1,0,17,16,17,8,33,4,69,4,2,0,
  // 0x4f5c  作
  92,79,15,16,32,16,0,254,9,0,9,0,9,0,17,254,18,128,50,128,52,128,80,248,144,128,16,128,16,128,16,252,16,128,16,128,16,128,16,128,
  // 0x4f7f  使
  127,79,15,16,32,16,0,254,16,64,16,64,31,254,32,64,32,64,103,252,100,68,164,68,39,252,32,64,34,64,33,64,32,128,33,64,34,48,44,14,
  // 0x4f9b  供
  155,79,15,16,32,16,0,254,9,16,9,16,9,16,17,16,19,252,49,16,49,16,81,16,145,16,23,254,16,0,17,16,17,8,18,8,20,4,24,4,
  // 0x4fb5  侵
  181,79,15,16,32,16,0,254,8,0,11,248,8,8,17,248,16,8,51,248,48,0,87,252,148,4,19,240,17,16,17,16,16,160,16,64,17,176,22,14,
  // 0x4fdd  保
  221,79,15,16,32,16,0,254,8,0,11,248,10,8,18,8,18,8,51,248,48,64,80,64,151,252,16,224,17,80,18,72,20,68,24,66,16,64,16,64,
  // 0x4fe1  信
  225,79,15,16,32,16,0,254,8,64,8,32,11,254,16,0,16,0,49,252,48,0,80,0,145,252,16,0,16,0,17,252,17,4,17,4,17,252,17,4,
  // 0x503c  值
  60,80,15,16,32,16,0,254,8,64,8,64,15,252,16,64,16,64,51,248,50,8,83,248,146,8,19,248,18,8,19,248,18,8,18,8,31,254,16,0,
  // 0x503e  倾
  62,80,15,16,32,16,0,254,16,0,16,254,20,16,36,32,36,124,100,68,103,84,164,84,36,84,36,84,37,84,38,84,36,32,32,40,32,68,32,130,
  // 0x504f  偏
  79,80,14,16,32,16,0,254,16,128,16,64,23,252,36,4,36,4,103,252,100,0,164,0,39,252,38,164,42,164,43,252,42,164,42,164,50,164,34,12,
  // 0x505c  停
  92,80,15,16,32,16,0,254,16,128,16,64,23,252,32,0,35,248,98,8,99,248,160,0,47,254,40,2,35,248,32,64,32,64,32,64,33,64,32,128,
  // 0x50a8  储
  168,80,15,16,32,16,0,254,16,32,16,32,24,250,36,36,36,40,97,254,96,32,188,64,36,252,37,68,38,68,36,124,37,68,38,68,36,124,32,68,
  // 0x50cf  像
  207,80,15,16,32,16,0,254,9,0,9,240,10,16,23,252,26,36,50,68,51,252,80,128,145,68,22,168,17,48,22,104,16,168,17,36,22,162,16,64,
  // 0x5145  充
  69,81,15,16,32,16,0,254,2,0,1,0,255,254,4,0,4,0,8,32,16,16,63,248,4,72,4,64,4,64,4,64,8,68,8,68,16,68,96,60,
  // 0x5148  先
  72,81,15,16,32,16,0,254,1,0,17,0,17,0,31,248,33,0,65,0,1,0,255,254,4,64,4,64,4,64,8,64,8,66,16,66,32,62,192,0,
  // 0x5149  光
  73,81,15,16,32,16,0,254,1,0,33,8,17,8,9,16,9,32,1,0,255,254,4,64,4,64,4,64,4,64,8,66,8,66,16,66,32,62,192,0,
  // 0x5165  入
  101,81,15,16,32,16,0,254,4,0,2,0,1,0,1,0,1,0,2,128,2,128,2,128,4,64,4,64,8,32,8,32,16,16,32,16,64,8,128,6,
  // 0x5168  全
  104,81,15,15,30,16,0,255,1,0,1,0,2,128,4,64,8,32,16,16,47,232,193,6,1,0,1,0,31,240,1,0,1,0,1,0,127,252,
  // 0x5171  共
  113,81,14,16,32,16,1,254,8,64,8,64,8,64,8,64,127,248,8,64,8,64,8,64,8,64,8,64,255,252,0,0,8,64,16,32,32,16,64,8,
  // 0x5173  关
  115,81,15,16,32,16,0,254,16,16,8,16,8,32,0,0,63,248,1,0,1,0,1,0,255,254,1,0,2,128,2,128,4,64,8,32,48,24,192,6,
  // 0x5177  具
  119,81,15,15,30,16,0,254,31,240,16,16,16,16,31,240,16,16,31,240,16,16,31,240,16,16,16,16,255,254,4,64,8,32,16,16,32,8,
  // 0x5197  冗
  151,81,15,14,28,16,0,254,127,254,64,2,128,4,0,0,15,192,8,64,8,64,8,64,8,64,16,66,16,66,32,66,64,62,128,0,
  // 0x51b7  冷
  183,81,15,16,32,16,0,254,0,64,64,64,32,160,32,160,1,16,2,72,20,38,16,32,35,248,224,8,32,16,33,16,32,160,32,64,32,32,0,32,
  // 0x51c6  准
  198,81,15,16,32,16,0,254,1,64,65,32,33,32,35,254,2,32,22,32,27,252,18,32,34,32,35,252,226,32,34,32,34,32,35,254,34,0,2,0,
  // 0x51fa  出
  250,81,13,16,32,16,1,254,2,0,2,0,66,16,66,16,66,16,66,16,127,240,2,16,2,0,2,0,130,8,130,8,130,8,130,8,255,248,0,8,
  // 0x51fb  击
  251,81,15,16,32,16,0,254,1,0,1,0,1,0,63,248,1,0,1,0,1,0,255,254,1,0,1,0,33,8,33,8,33,8,33,8,63,248,0,8,
  // 0x5206  分
  6,82,15,16,32,16,0,254,0,64,4,64,4,32,8,32,16,16,32,8,64,4,159,226,4,32,4,32,4,32,8,32,8,32,16,32,33,64,64,128,
  // 0x5207  切
  7,82,14,16,32,16,0,254,16,0,16,0,17,252,16,68,16,68,30,68,240,68,16,68,16,68,18,68,20,68,24,132,16,132,1,4,2,40,4,16,
  // 0x521b  创
  27,82,14,16,32,16,0,254,8,4,8,4,20,4,18,36,33,36,64,164,190,36,34,36,34,36,34,36,42,36,36,36,32,132,32,132,31,148,0,8,
  // 0x521d  初
  29,82,14,16,32,16,0,254,32,0,16,0,1,252,252,68,8,68,16,68,16,68,52,68,88,68,148,68,20,68,16,132,16,132,17,4,18,40,20,16,
  // 0x522b  别
  43,82,14,16,32,16,0,254,0,4,127,4,65,4,65,36,65,36,127,36,16,36,16,36,255,36,17,36,17,36,17,36,33,4,33,4,74,20,132,8,
  // 0x5230  到
  48,82,14,16,32,16,0,254,0,4,255,132,8,4,16,36,34,36,65,36,255,164,8,164,8,36,8,36,127,36,8,36,8,4,15,132,248,20,64,8,
  // 0x5236  制
  54,82,14,16,32,16,0,254,4,4,36,4,36,4,63,164,68,36,4,36,255,228,4,36,4,36,63,164,36,164,36,164,38,132,37,4,4,20,4,8,
  // 0x5237  刷
  55,82,15,16,32,16,0,254,0,2,63,194,32,66,32,66,63,210,34,18,34,18,34,18,63,210,82,82,82,82,82,82,147,66,18,130,2,10,2,4,
  // 0x5272  割
  114,82,14,16,32,16,0,254,16,4,8,4,255,132,128,164,9,36,127,36,8,36,127,36,8,36,255,164,8,36,127,36,65,4,65,4,127,20,65,8,
  // 0x529b  力
  155,82,12,16,32,16,1,254,4,0,4,0,4,0,4,0,255,240,4,16,4,16,4,16,4,16,8,16,8,16,16,16,16,16,33,16,64,160,128,64,
  // 0x529f  功
  159,82,14,16,32,16,0,254,0,64,0,64,0,64,254,64,17,252,16,68,16,68,16,68,16,68,16,132,16,132,30,132,241,4,65,4,2,40,4,16,
  // 0x52a0  加
  160,82,14,16,32,16,0,254,16,0,16,0,16,0,16,124,254,68,18,68,18,68,18,68,18,68,18,68,18,68,18,68,34,68,34,124,74,68,132,0,
  // 0x52a8  动
  168,82,14,16,32,16,0,254,0,64,0,64,124,64,0,64,1,252,0,68,254,68,32,68,32,68,32,132,72,132,68,132,253,4,69,4,2,40,4,16,
  // 0x5316  化
  22,83,15,16,32,16,0,254,8,128,8,128,8,132,16,136,16,144,48,160,48,192,80,128,145,128,18,128,20,128,16,130,16,130,16,130,16,126,16,0,
  // 0x5347  升
  71,83,15,16,32,16,0,254,1,32,7,160,60,32,4,32,4,32,4,32,4,32,255,254,4,32,4,32,4,32,8,32,8,32,16,32,32,32,64,32,
  // 0x534a  半
  74,83,15,16,32,16,0,254,1,0,33,8,17,8,9,16,9,32,1,0,63,248,1,0,1,0,1,0,255,254,1,0,1,0,1,0,1,0,1,0,
  // 0x534f  协
  79,83,15,16,32,16,0,254,32,128,32,128,32,128,32,128,251,240,32,144,32,144,34,152,34,148,36,146,40,146,32,144,33,16,33,16,34,80,36,32,
  // 0x5355  单
  85,83,15,16,32,16,0,254,16,16,8,32,4,64,63,248,33,8,33,8,63,248,33,8,33,8,63,248,1,0,1,0,255,254,1,0,1,0,1,0,
  // 0x5361  卡
  97,83,15,16,32,16,0,254,2,0,2,0,3,248,2,0,2,0,2,0,255,254,2,0,2,0,2,64,2,32,2,16,2,8,2,0,2,0,2,0,
  // 0x5370  印
  112,83,13,15,30,16,1,254,12,0,241,248,129,8,129,8,129,8,253,8,129,8,129,8,129,8,129,8,157,80,225,32,1,0,1,0,1,0,
  // 0x5371  危
  113,83,14,16,32,16,0,254,4,0,4,0,15,240,16,16,32,32,95,252,16,0,19,240,18,16,18,16,18,80,18,32,34,4,34,4,65,252,128,0,
  // 0x5374  却
  116,83,14,16,32,16,0,254,8,0,8,0,8,124,127,68,8,68,8,68,8,68,255,196,16,68,16,68,36,68,66,84,255,72,65,64,0,64,0,64,
  // 0x5378  卸
  120,83,14,16,32,16,0,254,32,0,32,0,63,124,72,68,136,68,8,68,127,68,8,68,8,68,46,68,40,68,40,84,47,72,240,64,64,64,0,64,
  // 0x538b  压
  139,83,15,15,30,16,0,254,63,254,32,0,32,128,32,128,32,128,32,128,47,252,32,128,32,128,32,144,32,136,32,136,64,128,95,254,128,0,
  // 0x539f  原
  159,83,15,15,30,16,0,254,63,254,32,128,33,0,39,240,36,16,36,16,39,240,36,16,36,16,39,240,32,128,36,144,72,136,82,132,129,0,
  // 0x53cc  双
  204,83,15,14,28,16,0,254,253,252,4,132,68,132,68,132,40,136,40,136,16,80,16,80,40,32,40,32,68,80,68,136,129,4,2,2,
  // 0x53cd  反
  205,83,15,16,32,16,0,254,0,16,0,248,63,0,32,0,32,0,63,248,36,8,36,16,34,16,34,32,33,64,32,128,65,64,66,32,140,24,48,6,
  // 0x53d6  取
  214,83,15,15,30,16,0,254,255,128,34,252,34,68,62,68,34,68,34,68,62,68,34,40,34,40,39,168,250,16,66,16,2,40,2,68,2,130,
  // 0x53d8  变
  216,83,15,16,32,16,0,254,2,0,1,0,255,254,4,64,20,80,36,72,68,68,0,0,63,240,8,32,4,64,2,128,1,0,6,192,24,48,224,14,
  // 0x53f0  台
  240,83,13,16,32,16,1,254,4,0,4,0,8,0,16,64,32,32,64,16,255,248,64,8,0,0,63,224,32,32,32,32,32,32,32,32,63,224,32,32,
  // 0x5403  吃
  3,84,14,15,30,16,1,255,1,0,1,0,242,0,147,252,148,0,152,0,147,240,144,16,144,32,144,192,241,0,146,0,4,4,4,4,3,252,
  // 0x5408  合
  8,84,15,16,32,16,0,254,1,0,1,0,2,128,4,64,8,32,48,24,207,230,0,0,0,0,31,240,16,16,16,16,16,16,16,16,31,240,16,16,
  // 0x540d  名
  13,84,13,16,32,16,0,254,2,0,2,0,7,240,8,16,20,32,98,64,2,128,1,0,6,0,31,248,232,8,8,8,8,8,8,8,15,248,8,8,
  // 0x540e  后
  14,84,15,16,32,16,0,254,0,16,0,248,31,0,16,0,16,0,31,254,16,0,16,0,16,0,23,248,20,8,36,8,36,8,68,8,135,248,4,8,
  // 0x5411  向
  17,84,13,16,32,16,1,254,4,0,8,0,16,0,255,248,128,8,128,8,143,136,136,136,136,136,136,136,136,136,143,136,136,136,128,8,128,40,128,16,
  // 0x5426  否
  38,84,15,15,30,16,0,254,127,252,0,128,1,0,3,0,5,96,9,24,49,4,193,2,0,0,31,240,16,16,16,16,16,16,31,240,16,16,
  // 0x542f  启
  47,84,14,16,32,16,0,254,1,0,0,128,31,252,16,4,16,4,16,4,31,252,16,0,16,0,16,0,23,252,36,4,36,4,68,4,135,252,4,4,
  // 0x544a  告
  74,84,15,16,32,16,0,254,1,0,17,0,17,0,31,248,33,0,65,0,1,0,255,254,0,0,0,0,31,240,16,16,16,16,16,16,31,240,16,16,
  // 0x5468  周
  104,84,13,15,30,16,0,254,63,248,33,8,33,8,47,232,33,8,33,8,63,248,32,8,39,200,36,72,36,72,39,200,64,8,64,40,128,16,
  // 0x547d  命
  125,84,15,16,32,16,0,254,1,0,1,0,2,128,4,64,8,32,55,216,192,6,0,0,62,248,34,136,34,136,34,136,62,168,34,144,0,128,0,128,
  // 0x548c  和
  140,84,14,16,32,16,0,254,4,0,14,0,120,0,8,124,8,68,255,68,8,68,24,68,28,68,42,68,42,68,72,68,136,124,8,68,8,0,8,0,
  // 0x54cd  响
  205,84,13,16,32,16,1,254,0,128,0,128,241,0,151,248,148,8,148,8,149,232,149,40,149,40,149,40,245,40,149,232,4,8,4,8,4,40,4,16,
  // 0x55b7  喷
  183,85,14,16,32,16,1,254,0,64,3,248,240,64,145,16,151,252,145,16,144,0,147,248,146,8,146,72,242,72,146,72,2,72,0,160,1,16,6,8,
  // 0x5634  嘴
  52,86,15,16,32,16,0,254,0,144,2,148,242,216,146,146,146,210,151,14,145,240,146,16,151,252,154,68,243,252,146,68,3,252,4,68,4,84,8,8,
  // 0x5668  器
  104,86,15,15,30,16,0,254,62,124,34,68,34,68,62,124,1,32,1,16,255,254,2,128,12,96,48,24,192,6,62,124,34,68,34,68,62,124,
  // 0x5674  噴
  116,86,14,16,32,16,1,254,0,64,3,248,240,64,145,16,151,252,145,16,147,248,146,8,147,248,146,8,243,248,146,8,3,248,1,16,2,8,4,4,
  // 0x56de  回
  222,86,12,14,28,16,2,255,255,240,128,16,128,16,159,144,144,144,144,144,144,144,144,144,144,144,159,144,128,16,128,16,255,240,128,16,
  // 0x56e0  因
  224,86,13,15,30,16,1,254,255,248,128,8,130,8,130,8,130,8,191,232,130,8,133,8,132,136,136,72,144,40,160,40,128,8,255,248,128,8,
  // 0x56fa  固
  250,86,13,15,30,16,1,254,255,248,130,8,130,8,191,232,130,8,130,8,159,200,144,72,144,72,144,72,159,200,144,72,128,8,255,248,128,8,
  // 0x56fe  图
  254,86,13,15,30,16,1,254,255,248,132,8,132,8,143,200,152,136,165,8,130,8,141,136,240,120,134,8,129,8,140,8,131,8,255,248,128,8,
  // 0x5728  在
  40,87,15,16,32,16,0,254,2,0,2,0,4,0,255,254,8,0,8,64,16,64,48,64,87,252,144,64,16,64,16,64,16,64,16,64,31,254,16,0,
  // 0x574f  坏
  79,87,15,16,32,16,0,254,16,0,16,0,19,254,16,16,16,16,252,32,16,32,16,104,16,100,16,164,29,34,226,34,68,32,0,32,0,32,0,32,
  // 0x5757  块
  87,87,15,16,32,16,0,254,16,64,16,64,16,64,19,252,16,68,252,68,16,68,16,68,19,254,16,64,16,160,28,160,225,16,66,8,4,4,8,2,
  // 0x578b  型
  139,87,15,15,30,16,0,255,0,4,127,132,18,36,18,36,18,36,255,164,18,36,34,4,34,20,65,8,129,0,63,248,1,0,1,0,255,254,
  // 0x57ab  垫
  171,87,15,15,30,16,0,255,8,64,8,64,125,248,8,72,12,72,25,200,104,74,8,170,40,134,17,2,1,0,63,248,1,0,1,0,255,254,
  // 0x586b  填
  107,88,15,16,32,16,0,254,32,64,32,64,39,252,32,64,35,248,250,8,35,248,34,8,35,248,34,8,35,248,58,8,239,254,65,16,2,8,4,4,
  // 0x58f3  壳
  243,88,15,16,32,16,0,254,1,0,1,0,127,252,1,0,1,0,31,240,0,0,127,254,64,2,128,4,15,224,8,32,8,32,16,34,32,34,192,30,
  // 0x5907  备
  7,89,15,16,32,16,0,254,4,0,4,0,15,240,24,32,100,64,3,128,28,112,224,14,31,240,17,16,17,16,31,240,17,16,17,16,31,240,16,16,
  // 0x590d  复
  13,89,15,16,32,16,0,254,16,0,16,0,31,252,32,0,95,240,144,16,31,240,16,16,31,240,4,0,15,240,24,32,100,64,3,128,28,112,224,14,
  // 0x5916  外
  22,89,14,16,32,16,0,254,16,64,16,64,16,64,16,64,62,64,34,96,66,80,66,72,164,68,20,68,8,64,8,64,16,64,32,64,64,64,128,64,
  // 0x591a  多
  26,89,12,16,32,16,1,254,4,0,4,0,15,224,16,64,112,128,9,0,6,128,25,0,227,240,4,16,24,32,100,64,2,128,3,0,28,0,224,0,
  // 0x5927  大
  39,89,15,16,32,16,0,254,1,0,1,0,1,0,1,0,1,0,255,254,1,0,1,0,2,128,2,128,4,64,4,64,8,32,16,16,32,8,192,6,
  // 0x5929  天
  41,89,15,15,30,16,0,254,63,248,1,0,1,0,1,0,1,0,255,254,1,0,2,128,2,128,4,64,4,64,8,32,16,16,32,8,192,6,
  // 0x592a  太
  42,89,15,16,32,16,0,254,1,0,1,0,1,0,1,0,1,0,255,254,1,0,1,0,2,128,2,128,4,64,4,64,10,32,17,16,33,8,192,6,
  // 0x5931  失
  49,89,15,16,32,16,0,254,1,0,17,0,17,0,17,0,31,248,33,0,65,0,1,0,255,254,1,0,2,128,2,128,4,64,8,32,16,16,96,12,
  // 0x5934  头
  52,89,15,16,32,16,0,254,0,128,0,128,8,128,4,128,36,128,16,128,16,128,0,128,255,254,1,0,1,64,2,32,4,16,8,8,48,4,192,4,
  // 0x597d  好
  125,89,15,16,32,16,0,254,16,0,16,252,16,4,16,8,252,16,36,32,36,32,37,254,36,32,72,32,40,32,16,32,40,32,68,32,132,160,0,64,
  // 0x59cb  始
  203,89,15,16,32,16,0,254,16,32,16,32,16,32,16,64,252,72,36,132,37,254,36,130,36,0,72,252,40,132,16,132,40,132,68,132,128,252,0,132,
  // 0x5b50  子
  80,91,15,15,30,16,0,254,127,248,0,16,0,32,0,64,1,128,1,0,255,254,1,0,1,0,1,0,1,0,1,0,1,0,5,0,2,0,
  // 0x5b58  存
  88,91,15,16,32,16,0,254,4,0,4,0,255,254,8,0,8,0,19,248,16,16,48,32,80,64,151,254,16,64,16,64,16,64,16,64,17,64,16,128,
  // 0x5b89  安
  137,91,15,16,32,16,0,254,2,0,1,0,63,252,32,4,66,8,2,0,2,0,255,254,4,32,8,32,24,64,6,64,1,128,2,96,12,16,112,8,
  // 0x5b8c  完
  140,91,15,16,32,16,0,254,2,0,1,0,127,254,64,2,128,4,31,240,0,0,0,0,127,252,4,64,4,64,4,64,8,68,8,68,16,68,96,60,
  // 0x5b9a  定
  154,91,15,16,32,16,0,254,2,0,1,0,127,254,64,2,128,4,0,0,63,248,1,0,1,0,17,0,17,248,17,0,17,0,41,0,71,254,128,0,
  // 0x5ba2  客
  162,91,15,16,32,16,0,254,2,0,1,0,127,254,64,2,136,4,15,240,16,32,44,64,3,128,28,112,224,14,31,240,16,16,16,16,31,240,16,16,
  // 0x5bab  宫
  171,91,15,16,32,16,0,254,2,0,1,0,127,254,64,2,128,4,31,240,16,16,16,16,31,240,0,0,63,248,32,8,32,8,32,8,63,248,32,8,
  // 0x5bf9  对
  249,91,14,16,32,16,1,254,0,32,0,32,0,32,252,32,5,252,4,32,72,32,41,32,16,160,16,160,40,32,36,32,68,32,128,32,0,160,0,64,
  // 0x5c06  将
  6,92,15,16,32,16,0,254,8,128,8,248,9,8,74,16,40,160,40,64,8,144,11,16,24,16,43,254,200,16,9,16,8,144,8,16,8,80,8,32,
  // 0x5c0f  小
  15,92,15,16,32,16,0,254,1,0,1,0,1,0,1,0,1,0,17,16,17,8,17,4,33,4,33,2,65,2,129,2,1,0,1,0,5,0,2,0,
  // 0x5c31  就
  49,92,15,16,32,16,0,254,32,64,16,80,254,72,0,72,0,64,125,254,68,80,68,80,68,80,124,80,16,144,84,144,146,146,17,18,81,14,34,0,
  // 0x5c4f  屏
  79,92,14,15,30,16,0,254,63,248,32,8,32,8,63,248,36,16,34,32,47,248,34,32,34,32,63,252,34,32,66,32,68,32,132,32,8,32,
  // 0x5de5  工
  229,93,15,12,24,16,0,0,127,252,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,255,254,
  // 0x5dee  差
  238,93,15,16,32,16,0,254,8,32,4,64,127,252,1,0,1,0,63,248,2,0,2,0,255,254,4,0,8,0,23,248,32,128,64,128,128,128,31,252,
  // 0x5df2  已
  242,93,12,14,28,16,2,255,255,192,0,64,0,64,0,64,128,64,128,64,255,192,128,0,128,0,128,0,128,16,128,16,128,16,127,240,
  // 0x5e73  平
  115,94,15,15,30,16,0,254,127,252,1,0,1,0,17,16,9,16,9,32,1,0,255,254,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
  // 0x5e76  并
  118,94,15,16,32,16,0,254,16,16,8,16,8,32,0,0,127,252,8,32,8,32,8,32,8,32,255,254,8,32,8,32,16,32,16,32,32,32,64,32,
  // 0x5e8a  床
  138,94,15,16,32,16,0,254,1,0,0,128,63,254,32,0,32,128,32,128,47,252,32,128,33,192,34,160,34,160,36,144,72,136,80,134,128,128,0,128,
  // 0x5e94  应
  148,94,15,15,30,16,0,255,1,0,0,128,63,254,32,0,32,0,33,4,40,132,36,132,36,72,34,72,34,16,34,16,64,32,64,64,159,254,
  // 0x5e9f  废
  159,94,15,16,32,16,0,254,1,0,0,128,63,254,32,128,36,144,40,136,47,254,33,0,33,252,34,132,34,136,36,80,36,32,72,80,81,136,134,6,
  // 0x5ea6  度
  166,94,15,16,32,16,0,254,1,0,0,128,63,254,34,32,34,32,63,252,34,32,34,32,35,224,32,0,47,240,36,16,66,32,65,192,134,48,56,14,
  // 0x5f00  开
  0,95,15,15,30,16,0,254,127,252,8,32,8,32,8,32,8,32,8,32,255,254,8,32,8,32,8,32,8,32,16,32,16,32,32,32,64,32,
  // 0x5f03  弃
  3,95,14,16,32,16,1,254,2,0,1,0,127,248,4,0,8,64,16,32,63,240,0,16,8,64,8,64,255,252,8,64,8,64,16,64,32,64,64,64,
  // 0x5f0f  式
  15,95,15,16,32,16,0,254,0,72,0,68,0,68,0,64,255,254,0,64,0,64,62,64,8,64,8,64,8,32,8,34,15,18,120,10,32,6,0,2,
  // 0x5f15  引
  21,95,12,16,32,16,1,254,0,16,254,16,2,16,2,16,2,16,126,16,64,16,64,16,128,16,254,16,2,16,2,16,2,16,2,16,20,16,8,16,
  // 0x5f39  弹
  57,95,15,16,32,16,0,254,1,4,248,136,8,80,9,252,9,36,121,36,65,252,65,36,65,36,121,252,8,32,8,32,11,254,8,32,80,32,32,32,
  // 0x5f52  归
  82,95,13,16,32,16,1,254,16,0,16,0,151,248,144,8,144,8,144,8,144,8,147,248,144,8,144,8,144,8,16,8,32,8,39,248,64,8,128,0,
  // 0x5f84  径
  132,95,15,16,32,16,0,254,8,0,11,248,16,16,32,32,72,96,8,152,17,4,54,2,80,0,147,252,16,64,16,64,16,64,16,64,23,254,16,0,
  // 0x5f85  待
  133,95,15,16,32,16,0,254,8,64,8,64,16,64,35,252,72,64,8,64,23,254,48,16,80,16,151,254,16,16,18,16,17,16,17,16,16,80,16,32,
  // 0x5faa  循
  170,95,15,16,32,16,0,254,16,60,23,224,36,32,68,32,151,254,20,32,37,252,101,4,165,4,37,252,37,4,37,252,41,4,41,4,49,252,33,4,
  // 0x5fae  微
  174,95,15,16,32,16,0,254,17,8,21,72,37,72,69,80,151,222,16,36,32,20,111,212,160,20,39,148,36,148,36,168,36,200,36,148,40,20,48,34,
  // 0x5fc3  心
  195,95,15,14,28,16,0,255,2,0,1,0,0,128,0,128,4,0,4,8,36,4,36,4,36,2,68,2,68,18,132,16,4,16,3,240,
  // 0x5ffd  忽
  253,95,15,15,30,16,0,255,8,0,8,0,31,248,18,72,34,72,68,136,8,136,17,8,34,40,4,16,1,0,8,132,72,146,72,18,135,240,
  // 0x6027  性
  39,96,15,16,32,16,0,254,16,32,16,32,17,32,17,32,25,252,85,32,82,32,80,32,144,32,17,252,16,32,16,32,16,32,16,32,19,254,16,0,
  // 0x603b  总
  59,96,15,15,30,16,0,255,16,16,8,32,4,64,0,0,31,240,16,16,16,16,16,16,31,240,16,16,1,0,8,132,72,146,72,18,135,240,
  // 0x6062  恢
  98,96,15,16,32,16,0,254,16,64,16,64,16,64,19,254,24,128,84,144,80,144,81,18,145,82,17,84,18,144,18,40,20,40,16,68,16,132,17,2,
  // 0x606f  息
  111,96,15,15,30,16,0,255,1,0,2,0,31,240,16,16,31,240,16,16,31,240,16,16,31,240,16,16,1,0,8,132,72,146,72,18,135,240,
  // 0x611f  感
  31,97,15,16,32,16,0,254,0,40,0,36,63,254,32,32,47,164,32,36,47,168,40,152,40,146,79,170,64,70,128,130,1,0,72,132,72,18,135,242,
  // 0x620f  戏
  15,98,14,16,32,16,1,254,0,64,0,80,0,72,252,72,4,64,4,124,75,192,40,72,16,72,16,80,40,80,36,32,68,100,128,148,1,12,2,4,
  // 0x6210  成
  16,98,15,16,32,16,0,254,0,80,0,72,0,64,63,254,32,64,32,64,32,68,62,68,34,68,34,40,34,40,34,18,42,50,68,74,64,134,129,2,
  // 0x6237  户
  55,98,12,16,32,16,1,254,4,0,2,0,2,0,63,240,32,16,32,16,32,16,32,16,63,240,32,16,32,0,32,0,32,0,64,0,64,0,128,0,
  // 0x6240  所
  64,98,15,16,32,16,0,254,2,8,7,28,56,224,32,128,32,128,62,128,34,254,34,136,34,136,62,136,32,136,32,136,65,8,65,8,130,8,4,8,
  // 0x6247  扇
  71,98,14,16,32,16,0,254,2,0,1,0,63,252,32,4,32,4,63,252,32,0,32,0,63,124,33,4,41,36,37,20,73,36,81,68,133,20,2,8,
  // 0x624b  手
  75,98,15,16,32,16,0,254,0,16,0,248,63,0,1,0,1,0,63,248,1,0,1,0,1,0,255,254,1,0,1,0,1,0,1,0,5,0,2,0,
  // 0x6253  打
  83,98,15,16,32,16,0,254,16,0,16,0,19,254,16,32,252,32,16,32,16,32,20,32,24,32,48,32,208,32,16,32,16,32,16,32,80,160,32,64,
  // 0x6267  执
  103,98,15,16,32,16,0,254,16,64,16,64,16,64,16,64,253,248,16,72,16,72,20,72,25,72,48,200,208,72,16,168,16,170,17,10,82,6,36,2,
  // 0x6279  批
  121,98,15,16,32,16,0,254,16,16,17,16,17,16,17,18,253,18,17,20,17,216,21,16,25,16,49,16,209,16,17,18,17,82,17,146,81,14,32,0,
  // 0x6296  抖
  150,98,15,16,32,16,0,254,16,16,17,16,16,144,16,144,252,16,17,16,16,144,20,144,24,16,48,30,211,240,16,16,16,16,16,16,80,16,32,16,
  // 0x62a5  报
  165,98,15,16,32,16,0,254,16,0,17,252,17,4,17,4,253,20,17,8,17,0,21,252,25,68,49,68,209,40,17,40,17,16,17,40,81,68,33,130,
  // 0x62ac  抬
  172,98,15,16,32,16,0,254,16,32,16,32,16,64,16,136,253,4,19,254,16,2,20,0,25,252,49,4,209,4,17,4,17,4,17,4,81,252,33,4,
  // 0x62bd  抽
  189,98,14,16,32,16,0,254,16,32,16,32,16,32,16,32,253,252,17,36,17,36,21,36,25,36,49,252,209,36,17,36,17,36,17,36,81,252,33,4,
  // 0x62d4  拔
  212,98,15,16,32,16,0,254,16,80,16,72,16,72,16,64,251,254,16,128,20,128,24,252,49,68,209,68,17,40,17,40,18,16,18,40,84,68,33,130,
  // 0x62e9  择
  233,98,15,16,32,16,0,254,32,0,39,248,34,8,33,16,240,160,32,64,33,176,38,78,48,64,227,248,32,64,32,64,39,252,32,64,160,64,64,64,
  // 0x6309  按
  9,99,15,16,32,16,0,254,16,64,16,32,16,32,19,254,250,2,20,68,16,64,27,254,48,136,208,136,17,8,16,208,16,32,16,80,80,136,35,4,
  // 0x6321  挡
  33,99,14,16,32,16,0,254,16,64,18,68,17,68,17,68,253,72,16,64,23,252,16,4,24,4,48,4,211,252,16,4,16,4,16,4,87,252,32,4,
  // 0x6324  挤
  36,99,15,16,32,16,0,254,16,128,16,64,23,254,18,8,253,16,16,160,20,64,25,176,54,14,209,16,17,16,17,16,17,16,18,16,82,16,36,16,
  // 0x635f  损
  95,99,14,16,32,16,0,254,16,0,16,248,16,136,16,136,252,248,16,0,17,252,21,4,25,36,49,36,209,36,17,36,16,80,16,72,80,132,35,4,
  // 0x6362  换
  98,99,15,16,32,16,0,254,16,128,16,128,16,248,17,8,250,16,21,252,17,36,25,36,49,36,209,36,23,254,16,80,16,80,16,136,81,4,38,2,
  // 0x6389  掉
  137,99,15,16,32,16,0,254,16,32,16,32,16,62,16,32,253,252,17,4,21,252,25,4,49,252,209,36,16,32,19,254,16,32,16,32,80,32,32,32,
  // 0x63a2  探
  162,99,15,16,32,16,0,254,32,0,39,252,36,4,36,164,249,16,34,8,32,64,40,64,55,252,224,64,32,224,33,80,34,72,44,70,160,64,64,64,
  // 0x63a5  接
  165,99,15,16,32,16,0,254,16,128,16,64,19,252,16,0,253,8,16,144,23,254,16,64,24,64,55,254,208,136,17,8,16,144,16,96,81,152,38,4,
  // 0x63a7  控
  167,99,15,16,32,16,0,254,16,64,16,32,16,32,19,254,250,2,20,148,17,8,26,4,48,0,209,252,16,32,16,32,16,32,16,32,87,254,32,0,
  // 0x63d0  提
  208,99,15,16,32,16,0,254,16,0,17,252,17,4,17,4,253,252,17,4,17,4,21,252,24,0,51,254,208,32,17,32,17,60,17,32,82,160,36,126,
  // 0x63d2  插
  210,99,15,16,32,16,0,254,32,8,32,60,39,192,32,64,248,64,47,254,32,64,41,64,54,92,228,68,36,68,39,92,36,68,36,68,167,252,68,4,
  // 0x6536  收
  54,101,14,16,32,16,1,254,16,128,16,128,144,128,145,0,145,252,146,16,149,16,145,16,145,16,176,160,208,160,144,64,16,160,17,16,18,8,20,4,
  // 0x653e  放
  62,101,15,16,32,16,0,254,32,64,16,64,0,64,254,128,32,254,33,8,62,136,36,136,36,136,36,80,36,80,36,32,68,80,84,136,137,4,2,2,
  // 0x6570  数
  112,101,15,16,32,16,0,254,8,32,73,32,42,32,8,62,255,68,42,68,73,68,136,164,16,40,254,40,34,16,66,16,100,40,24,40,52,68,194,130,
  // 0x6572  敲
  114,101,15,16,32,16,0,254,16,16,8,16,255,16,0,30,126,16,66,16,126,252,0,68,255,68,129,68,189,40,165,40,189,16,129,40,133,68,130,130,
  // 0x6574  整
  116,101,15,16,32,16,0,254,8,32,8,32,255,190,8,68,127,164,73,36,127,40,42,16,73,40,136,70,0,0,127,252,1,0,17,248,17,0,255,254,
  // 0x6599  料
  153,101,15,16,32,16,0,254,8,8,8,136,74,72,42,72,44,8,8,136,254,72,24,72,28,8,42,14,42,248,72,8,136,8,8,8,8,8,8,8,
  // 0x659c  斜
  156,101,15,16,32,16,0,254,8,8,8,72,20,40,34,40,65,8,190,72,8,40,8,40,127,14,8,120,42,8,41,8,73,8,136,8,40,8,16,8,
  // 0x65ad  断
  173,101,14,16,32,16,1,254,8,0,8,8,170,240,156,128,136,128,254,128,136,252,156,144,170,144,202,144,136,144,136,144,128,144,255,16,1,16,2,16,
  // 0x65b0  新
  176,101,15,16,32,16,0,254,16,0,8,4,127,120,0,64,34,64,20,64,255,126,8,72,8,72,127,72,8,72,42,72,73,72,136,136,40,136,17,8,
  // 0x65b9  方
  185,101,15,16,32,16,0,254,2,0,1,0,1,0,255,254,4,0,4,0,4,0,7,240,4,16,4,16,4,16,8,16,8,16,16,16,32,160,64,64,
  // 0x65e0  无
  224,101,14,15,30,16,0,254,63,240,2,0,2,0,2,0,2,0,127,252,4,128,4,128,4,128,8,128,8,128,16,132,32,132,64,124,128,0,
  // 0x65f6  时
  246,101,14,16,32,16,1,254,0,16,0,16,248,16,136,16,139,252,136,16,136,16,248,16,137,16,136,144,136,144,136,16,248,16,136,16,0,80,0,32,
  // 0x660e  明
  14,102,13,15,30,16,1,254,1,248,249,8,137,8,137,8,137,248,249,8,137,8,137,8,137,248,249,8,137,8,2,8,2,8,4,40,8,16,
  // 0x662f  是
  47,102,15,16,32,16,0,254,31,240,16,16,16,16,31,240,16,16,16,16,31,240,0,0,255,254,1,0,17,0,17,248,17,0,41,0,69,0,131,254,
  // 0x6682  暂
  130,102,15,16,32,16,0,254,16,12,254,240,32,128,72,128,126,254,8,136,14,136,249,8,74,8,31,248,16,16,16,16,31,240,16,16,16,16,31,240,
  // 0x66ab  暫
  171,102,14,16,32,16,1,254,16,8,254,240,16,128,254,128,146,252,254,144,146,144,254,144,16,144,254,144,17,16,63,224,32,32,63,224,32,32,63,224,
  // 0x66f4  更
  244,102,15,15,30,16,0,254,255,254,1,0,1,0,63,248,33,8,33,8,63,248,33,8,33,8,63,248,17,0,10,0,6,0,25,192,224,62,
  // 0x6700  最
  0,103,15,16,32,16,0,254,31,240,16,16,31,240,16,16,31,240,0,0,255,254,34,0,62,248,34,136,62,144,34,80,47,32,242,80,66,136,3,6,
  // 0x6709  有
  9,103,15,16,32,16,0,254,2,0,2,0,255,254,4,0,4,0,15,240,8,16,24,16,47,240,72,16,136,16,15,240,8,16,8,16,8,80,8,32,
  // 0x671f  期
  31,103,14,16,32,16,0,254,34,0,34,124,127,68,34,68,34,68,62,124,34,68,34,68,62,68,34,124,34,68,255,68,4,132,34,132,65,20,130,8,
  // 0x673a  机
  58,103,15,16,32,16,0,254,16,0,17,240,17,16,17,16,253,16,17,16,49,16,57,16,85,16,85,16,145,16,17,18,17,18,18,18,18,14,20,0,
  // 0x6740  杀
  64,103,15,16,32,16,0,254,0,8,24,16,6,96,1,128,6,96,24,24,97,4,1,0,255,254,1,0,17,32,17,16,33,8,33,4,69,4,2,0,
  // 0x675f  束
  95,103,15,16,32,16,0,254,1,0,1,0,255,254,1,0,1,0,63,248,33,8,33,8,33,8,63,248,35,136,5,64,9,32,49,24,193,6,1,0,
  // 0x6761  条
  97,103,15,16,32,16,0,254,4,0,4,0,15,240,24,32,100,64,3,128,29,112,225,14,1,0,127,252,1,0,9,32,17,16,33,8,69,4,2,0,
  // 0x6765  来
  101,103,15,16,32,16,0,254,1,0,1,0,1,0,127,252,1,0,17,16,9,16,9,32,255,254,3,128,5,64,9,32,49,24,193,6,1,0,1,0,
  // 0x677f  板
  127,103,15,16,32,16,0,254,16,8,16,28,17,224,17,0,253,0,17,252,49,68,57,68,85,68,85,40,145,40,17,16,17,16,18,40,18,68,20,130,
  // 0x6797  林
  151,103,15,16,32,16,0,254,16,32,16,32,16,32,16,32,253,254,16,32,48,112,56,112,84,168,80,168,145,36,18,34,20,32,16,32,16,32,16,32,
  // 0x67f1  柱
  241,103,15,16,32,16,0,254,16,64,16,32,16,0,19,254,252,32,16,32,48,32,56,32,85,252,84,32,144,32,16,32,16,32,16,32,19,254,16,0,
  // 0x6821  校
  33,104,15,16,32,16,0,254,16,64,16,32,16,32,17,254,252,0,16,136,49,4,58,2,84,136,80,136,144,80,16,80,16,32,16,80,16,136,19,6,
  // 0x683c  格
  60,104,15,16,32,16,0,254,16,128,16,128,16,248,17,8,251,16,20,160,48,64,56,160,85,24,82,6,149,248,17,8,17,8,17,8,17,248,17,8,
  // 0x68af  梯
  175,104,15,16,32,16,0,254,17,8,16,136,16,144,17,252,252,36,16,36,49,252,57,32,85,32,81,254,144,98,16,162,17,42,18,36,20,32,16,32,
  // 0x68c0  检
  192,104,15,16,32,16,0,254,16,64,16,64,16,160,16,160,253,16,18,8,53,246,56,0,84,136,80,72,146,72,17,80,17,16,16,32,23,254,16,0,
  // 0x69fd  槽
  253,105,15,16,32,16,0,254,16,144,16,144,23,254,16,144,251,252,18,148,51,252,58,148,87,252,80,0,145,248,17,8,17,248,17,8,17,248,17,8,
  // 0x6a21  模
  33,106,15,16,32,16,0,254,17,16,17,16,23,252,17,16,252,0,19,248,50,8,59,248,86,8,83,248,144,64,23,252,16,160,17,16,18,8,20,6,
  // 0x6a59  橙
  89,106,15,16,32,16,0,254,16,32,23,164,16,168,18,146,249,20,18,8,53,244,56,2,87,248,82,8,146,8,19,248,18,8,17,16,31,254,16,0,
  // 0x6b62  止
  98,107,15,15,30,16,0,255,1,0,1,0,1,0,1,0,17,0,17,0,17,248,17,0,17,0,17,0,17,0,17,0,17,0,17,0,255,254,
  // 0x6b63  正
  99,107,15,14,28,16,0,255,127,252,1,0,1,0,1,0,1,0,17,0,17,248,17,0,17,0,17,0,17,0,17,0,17,0,255,254,
  // 0x6b65  步
  101,107,15,16,32,16,0,254,1,0,1,0,17,248,17,0,17,0,17,0,255,254,1,0,1,0,17,8,17,16,33,32,64,192,3,0,28,0,224,0,
  // 0x6bd4  比
  212,107,13,15,30,16,2,255,2,0,130,0,130,0,130,16,130,32,130,64,250,128,131,0,130,0,130,0,130,0,130,8,154,8,226,8,129,248,
  // 0x6ca1  没
  161,108,15,15,30,16,0,254,33,240,17,16,17,16,129,16,66,16,84,14,24,0,19,248,34,8,225,8,33,16,32,160,32,64,33,176,14,14,
  // 0x6ce2  波
  226,108,15,16,32,16,0,254,0,32,32,32,16,32,19,254,130,34,66,36,74,32,11,252,18,132,18,136,226,72,34,80,34,32,36,80,36,136,9,6,
  // 0x6ce8  注
  232,108,15,15,30,16,0,255,0,128,32,64,16,0,23,252,128,64,64,64,64,64,16,64,19,252,32,64,224,64,32,64,32,64,32,64,47,254,
  // 0x6d17  洗
  23,109,15,16,32,16,0,254,0,64,34,64,18,64,19,252,132,64,72,64,64,64,23,254,17,32,33,32,225,32,33,32,34,34,34,34,36,30,8,0,
  // 0x6d3b  活
  59,109,15,16,32,16,0,254,0,16,32,120,19,192,16,64,128,64,71,254,64,64,16,64,16,64,35,248,226,8,34,8,34,8,34,8,35,248,2,8,
  // 0x6d41  流
  65,109,15,16,32,16,0,254,0,128,32,64,23,254,16,128,129,16,66,8,71,252,16,4,16,0,34,72,226,72,34,72,34,72,34,74,36,74,8,70,
  // 0x6d4b  测
  75,109,14,16,32,16,0,254,0,4,39,196,20,68,20,84,133,84,69,84,69,84,21,84,21,84,37,84,229,84,33,4,34,132,34,68,36,20,8,8,
  // 0x6d88  消
  136,109,13,16,32,16,0,254,0,64,34,72,17,72,17,80,128,64,67,248,74,8,10,8,19,248,18,8,226,8,35,248,34,8,34,8,34,40,2,16,
  // 0x6de1  淡
  225,109,15,16,32,16,0,254,0,64,34,68,18,68,20,72,128,160,65,16,70,8,16,68,16,64,34,72,226,72,36,80,32,160,33,16,34,8,12,6,
  // 0x6df7  混
  247,109,15,15,30,16,0,254,39,252,20,4,20,4,135,252,68,4,68,4,23,252,16,0,36,32,228,34,39,172,36,48,36,34,37,162,6,30,
  // 0x6e05  清
  5,110,15,16,32,16,0,254,32,64,16,64,23,252,0,64,131,248,64,64,79,254,8,0,19,248,18,8,19,248,226,8,35,248,34,8,34,40,2,16,
  // 0x6e29  温
  41,110,15,14,28,16,0,255,35,248,18,8,18,8,131,248,66,8,66,8,19,248,16,0,39,252,228,164,36,164,36,164,36,164,47,254,
  // 0x6e38  游
  56,110,15,16,32,16,0,254,2,16,33,16,17,16,23,190,130,32,66,64,67,188,18,132,18,136,34,136,226,190,34,136,36,136,36,136,41,168,16,16,
  // 0x6e90  源
  144,110,15,15,30,16,0,254,39,254,20,32,20,64,133,252,69,4,69,252,21,4,21,252,37,36,228,32,36,168,41,36,42,34,48,160,0,64,
  // 0x6ea2  溢
  162,110,15,15,30,16,0,255,2,8,33,8,17,16,16,0,135,252,64,0,65,16,18,8,20,4,35,248,226,168,34,168,34,168,34,168,47,254,
  // 0x6ed1  滑
  209,110,15,15,30,16,0,254,35,248,18,8,19,200,130,72,79,254,72,2,19,248,18,8,35,248,226,8,35,248,34,8,34,8,34,40,2,16,
  // 0x6f0f  漏
  15,111,15,15,30,16,0,254,71,254,36,2,36,2,7,254,132,0,71,254,84,32,23,254,38,34,230,170,42,34,42,170,50,34,34,42,2,4,
  // 0x6fc0  激
  192,111,15,16,32,16,0,254,2,16,68,16,47,144,40,144,15,190,136,164,79,212,84,20,18,20,47,212,228,20,39,136,36,136,40,148,42,148,17,34,
  // 0x706f  灯
  111,112,15,16,32,16,0,254,16,0,16,0,19,254,16,32,84,32,88,32,80,32,144,32,16,32,16,32,16,32,40,32,36,32,68,32,64,160,128,64,
  // 0x70b9  点
  185,112,14,16,32,16,0,254,2,0,2,0,2,0,3,252,2,0,2,0,63,240,32,16,32,16,32,16,63,240,0,0,36,136,34,68,66,68,128,4,
  // 0x70ed  热
  237,112,15,16,32,16,0,254,16,64,16,64,16,64,253,248,16,72,16,72,28,200,48,72,208,170,16,170,81,6,34,2,0,0,72,136,68,68,132,68,
  // 0x7247  片
  71,114,13,16,32,16,1,254,0,128,32,128,32,128,32,128,32,128,63,248,32,0,32,0,32,0,63,192,32,64,32,64,32,64,64,64,64,64,128,64,
  // 0x7269  物
  105,114,14,16,32,16,0,254,16,128,16,128,80,128,80,252,125,84,82,84,144,84,16,148,28,148,241,36,82,36,16,68,16,68,16,132,17,40,16,16,
  // 0x7279  特
  121,114,15,16,32,16,0,254,16,32,16,32,80,32,81,252,124,32,80,32,147,254,16,8,28,8,241,254,80,8,16,136,16,72,16,8,16,40,16,16,
  // 0x7387  率
  135,115,15,16,32,16,0,254,2,0,1,0,127,252,2,0,68,68,47,136,17,16,34,72,79,228,0,32,1,0,255,254,1,0,1,0,1,0,1,0,
  // 0x73af  环
  175,115,15,14,28,16,0,254,253,254,16,16,16,16,16,32,16,32,124,104,16,164,17,34,18,34,16,32,28,32,224,32,64,32,0,32,
  // 0x7528  用
  40,117,13,15,30,16,0,254,63,248,33,8,33,8,33,8,63,248,33,8,33,8,33,8,63,248,33,8,33,8,33,8,65,8,65,40,128,16,
  // 0x7535  电
  53,117,13,16,32,16,2,254,4,0,4,0,4,0,255,224,132,32,132,32,132,32,255,224,132,32,132,32,132,32,255,224,132,40,4,8,4,8,3,248,
  // 0x7565  略
  101,117,15,16,32,16,0,254,0,128,0,128,248,248,169,8,171,16,172,160,248,64,168,160,169,24,170,6,173,248,249,8,137,8,1,8,1,248,1,8,
  // 0x767d  白
  125,118,11,16,32,16,2,254,4,0,8,0,16,0,255,224,128,32,128,32,128,32,128,32,255,224,128,32,128,32,128,32,128,32,128,32,255,224,128,32,
  // 0x7684  的
  132,118,13,16,32,16,1,254,32,128,32,128,64,128,252,248,133,8,133,8,134,8,132,136,252,72,132,72,132,8,132,8,132,8,252,8,132,80,0,32,
  // 0x76d1  监
  209,118,15,15,30,16,0,255,4,64,36,64,36,124,36,64,36,144,36,136,37,8,4,0,0,0,63,248,36,72,36,72,36,72,36,72,255,254,
  // 0x76f4  直
  244,118,15,15,30,16,0,255,1,0,1,0,127,252,1,0,31,240,16,16,16,16,31,240,16,16,31,240,16,16,31,240,16,16,16,16,255,254,
  // 0x7701  省
  1,119,14,16,32,16,0,254,1,0,17,16,17,8,33,36,64,192,3,0,12,0,63,248,208,8,31,248,16,8,31,248,16,8,16,8,31,248,16,8,
  // 0x7720  眠
  32,119,14,15,30,16,1,254,3,248,250,8,138,8,138,8,251,248,138,64,138,64,251,252,138,64,138,64,138,32,250,36,138,148,3,12,2,4,
  // 0x786e  确
  110,120,15,16,32,16,0,254,0,64,0,64,252,124,16,132,17,8,34,254,60,146,100,146,100,254,164,146,36,146,36,254,60,146,37,18,33,10,2,4,
  // 0x79bb  离
  187,121,15,16,32,16,0,254,2,0,1,0,255,254,0,0,20,80,19,144,20,80,31,240,1,0,127,252,66,4,68,68,79,228,68,36,64,20,64,8,
  // 0x79fb  移
  251,121,15,16,32,16,0,254,8,32,28,32,240,124,16,132,17,72,252,48,16,32,48,72,57,144,84,62,84,66,145,164,16,24,16,16,16,96,17,128,
  // 0x7a7a  空
  122,122,15,15,30,16,0,255,2,0,1,0,127,254,64,2,136,36,16,16,32,8,0,0,31,240,1,0,1,0,1,0,1,0,1,0,127,252,
  // 0x7aef  端
  239,122,15,16,32,16,0,254,32,32,17,36,17,36,253,36,1,252,8,0,139,254,136,32,72,64,73,252,81,84,81,84,29,84,225,84,65,84,1,12,
  // 0x7b2c  第
  44,123,15,16,32,16,0,254,32,64,63,126,72,144,133,8,63,248,1,8,1,8,63,248,33,0,33,0,63,252,3,4,5,4,25,40,225,16,1,0,
  // 0x7b49  等
  73,123,15,16,32,16,0,254,32,64,63,126,72,144,133,8,1,0,63,248,1,0,1,0,255,254,0,0,0,32,127,252,8,32,4,32,4,160,0,64,
  // 0x7bb1  箱
  177,123,15,16,32,16,0,254,16,64,16,64,63,126,40,144,69,8,136,0,8,252,126,132,8,132,24,252,28,132,42,132,42,252,72,132,136,132,8,252,
  // 0x7c7b  类
  123,124,15,16,32,16,0,254,1,0,17,16,9,32,1,0,127,252,5,64,9,32,17,16,96,8,1,0,255,254,2,128,4,64,8,32,48,24,192,6,
  // 0x7d22  索
  34,125,15,16,32,16,0,254,1,0,1,0,63,248,1,0,1,0,127,254,66,2,132,36,31,192,1,128,6,16,63,248,1,8,17,32,37,16,66,8,
  // 0x7d2b  紫
  43,125,14,16,32,16,0,254,8,128,40,136,46,240,40,132,46,132,240,124,2,0,4,32,31,192,1,128,6,16,63,248,1,8,17,32,37,16,66,8,
  // 0x7ea2  红
  162,126,15,15,30,16,0,255,16,0,16,0,33,252,36,32,68,32,248,32,16,32,32,32,64,32,252,32,64,32,0,32,28,32,224,32,67,254,
  // 0x7ea7  级
  167,126,15,16,32,16,0,254,16,0,19,252,32,132,32,136,72,136,248,144,16,156,32,132,65,68,249,68,65,40,1,40,26,16,226,40,68,68,1,130,
  // 0x7ebf  线
  191,126,15,16,32,16,0,254,16,80,16,72,32,64,36,92,69,224,248,64,16,94,35,224,64,68,252,72,64,48,0,34,28,82,224,138,67,6,0,2,
  // 0x7ec6  细
  198,126,14,16,32,16,0,254,16,0,16,0,33,252,37,36,69,36,249,36,17,36,33,36,65,252,253,36,65,36,1,36,29,36,225,36,65,252,1,4,
  // 0x7ec8  终
  200,126,15,16,32,16,0,254,16,128,16,128,32,248,33,8,75,16,252,160,16,64,32,160,67,24,252,6,64,192,0,32,24,16,225,128,64,96,0,16,
  // 0x7ed3  结
  211,126,15,16,32,16,0,254,16,32,16,32,32,32,39,254,68,32,248,32,17,252,32,0,64,0,253,252,65,4,1,4,29,4,225,4,65,252,1,4,
  // 0x7ed9  给
  217,126,15,16,32,16,0,254,16,64,16,64,32,160,33,16,74,8,244,6,19,248,32,0,64,0,251,248,66,8,2,8,26,8,226,8,67,248,2,8,
  // 0x7edf  统
  223,126,15,16,32,16,0,254,16,64,16,32,32,32,35,254,72,64,248,136,17,4,35,254,64,146,248,144,64,144,0,144,25,18,225,18,66,14,4,0,
  // 0x7ee7  继
  231,126,15,15,30,16,0,255,16,32,18,32,34,32,35,36,74,168,242,32,19,252,34,32,66,112,250,168,67,36,2,32,26,32,226,32,67,254,
  // 0x7eea  绪
  234,126,15,16,32,16,0,254,16,64,16,68,35,244,32,72,72,80,247,254,16,64,32,128,65,248,251,8,69,8,1,248,25,8,225,8,65,248,1,8,
  // 0x7eed  续
  237,126,15,16,32,16,0,254,16,32,16,32,33,252,36,32,68,32,251,254,16,2,32,148,64,80,253,16,64,144,3,254,28,40,224,68,64,130,3,2,
  // 0x7eff  绿
  255,126,15,16,32,16,0,254,16,0,17,248,32,8,32,8,73,248,248,8,16,8,35,254,64,32,250,34,65,116,0,168,25,36,226,34,64,160,0,64,
  // 0x7f16  编
  22,127,14,16,32,16,0,254,16,128,16,64,35,252,34,4,74,4,251,252,18,0,34,0,67,252,251,84,67,84,5,252,29,84,229,84,73,68,1,12,
  // 0x7f3a  缺
  58,127,15,16,32,16,0,254,32,32,32,32,60,32,81,252,144,36,16,36,254,36,16,36,19,254,84,32,84,80,84,80,92,136,100,136,5,4,2,2,
  // 0x7f51  网
  81,127,13,15,30,16,1,254,255,248,128,8,128,8,132,40,165,40,148,168,136,72,136,72,148,168,148,168,165,40,194,8,128,8,128,40,128,16,
  // 0x7f6e  置
  110,127,15,16,32,16,0,254,127,252,68,68,68,68,127,252,1,0,255,254,2,0,31,240,16,16,31,240,16,16,31,240,16,16,31,240,16,16,255,254,
  // 0x7f72  署
  114,127,15,15,30,16,0,254,63,248,36,72,36,72,63,248,2,0,31,208,2,32,255,254,3,0,15,240,56,16,207,240,8,16,15,240,8,16,
  // 0x8005  者
  5,128,15,16,32,16,0,254,2,0,2,8,63,208,2,32,2,64,255,254,1,0,2,0,15,240,24,16,40,16,79,240,136,16,8,16,15,240,8,16,
  // 0x806a  聪
  106,128,15,16,32,16,0,254,0,136,252,72,72,80,73,252,121,4,73,4,73,4,121,252,72,32,72,16,76,84,121,66,201,66,9,74,10,56,8,0,
  // 0x80fd  能
  253,128,15,16,32,16,0,254,16,64,36,68,66,72,255,112,1,64,0,66,126,66,66,62,66,0,126,68,66,72,66,112,126,64,66,66,74,66,68,62,
  // 0x81ea  自
  234,129,9,16,32,16,3,254,8,0,16,0,32,0,255,128,128,128,128,128,128,128,255,128,128,128,128,128,255,128,128,128,128,128,128,128,255,128,128,128,
  // 0x81f3  至
  243,129,15,14,28,16,0,255,127,252,2,0,4,0,8,32,16,16,63,248,0,8,1,0,1,0,63,248,1,0,1,0,1,0,255,254,
  // 0x83dc  菜
  220,131,15,16,32,16,0,254,8,32,8,32,255,254,8,32,0,16,0,248,63,0,17,16,8,32,1,0,127,252,5,64,9,32,49,24,193,6,1,0,
  // 0x84dd  蓝
  221,132,15,15,30,16,0,255,8,32,8,32,255,254,8,32,4,128,36,128,36,252,36,160,37,16,0,0,63,248,36,72,36,72,36,72,255,254,
  // 0x86c7  蛇
  199,134,15,15,30,16,0,255,16,32,16,16,16,16,125,254,85,2,86,4,84,128,84,136,124,144,80,160,16,192,20,130,30,130,226,130,64,126,
  // 0x884c  行
  76,136,15,16,32,16,0,254,8,0,9,252,16,0,32,0,72,0,8,0,19,254,48,32,80,32,144,32,16,32,16,32,16,32,16,32,16,160,16,64,
  // 0x88ab  被
  171,136,15,16,32,16,0,254,32,16,16,16,0,16,249,254,9,18,17,20,21,16,57,252,85,68,145,68,17,40,17,40,17,16,18,40,18,68,20,130,
  // 0x88c5  装
  197,136,15,16,32,16,0,254,8,32,72,32,43,254,8,32,24,32,40,32,201,252,10,0,1,0,255,254,5,0,12,136,52,80,197,48,6,14,4,0,
  // 0x8981  要
  129,137,13,15,30,16,1,254,255,248,8,128,8,128,127,240,72,144,72,144,127,240,4,0,255,248,8,64,16,128,57,0,7,0,12,224,112,16,
  // 0x89d2  角
  210,137,13,16,32,16,0,254,8,0,8,0,31,224,32,32,64,64,191,248,33,8,33,8,63,248,33,8,33,8,63,248,33,8,65,8,65,40,128,16,
  // 0x8ba1  计
  161,139,15,16,32,16,0,254,0,64,32,64,16,64,16,64,0,64,0,64,247,254,16,64,16,64,16,64,16,64,16,64,20,64,24,64,16,64,0,64,
  // 0x8bae  议
  174,139,15,16,32,16,0,254,0,128,32,72,18,72,18,8,2,8,1,16,241,16,17,16,16,160,16,160,16,64,20,64,24,160,17,16,2,8,12,6,
  // 0x8bbe  设
  190,139,15,15,30,16,0,254,33,240,17,16,17,16,1,16,2,14,244,0,19,248,17,8,17,16,16,144,20,160,24,64,16,160,3,24,12,6,
  // 0x8bd5  试
  213,139,15,16,32,16,0,254,0,40,32,36,16,36,16,32,7,254,0,32,240,32,23,224,17,32,17,16,17,16,21,16,25,202,23,10,2,6,0,2,
  // 0x8bef  误
  239,139,15,15,30,16,0,254,67,248,34,8,34,8,3,248,0,0,231,252,32,64,32,64,47,254,32,64,32,160,40,160,49,16,34,8,4,6,
  // 0x8bf7  请
  247,139,15,16,32,16,0,254,0,64,64,64,39,252,32,64,3,248,0,64,231,254,32,0,35,248,34,8,35,248,34,8,43,248,50,8,34,40,2,16,
  // 0x8bfb  读
  251,139,15,16,32,16,0,254,0,32,32,32,17,252,16,32,0,32,3,254,240,2,16,148,16,80,17,16,16,144,19,254,20,40,24,68,16,130,3,2,
  // 0x8c03  调
  3,140,14,15,30,16,0,254,71,252,36,68,36,68,5,244,4,68,228,68,39,252,36,4,37,244,37,20,45,20,53,244,36,4,4,20,8,8,
  // 0x8d25  败
  37,141,15,16,32,16,0,254,0,64,124,64,68,64,84,128,84,254,85,8,86,136,84,136,84,136,84,80,84,80,16,32,40,80,36,136,69,4,130,2,
  // 0x8d2a  贪
  42,141,15,16,32,16,0,254,1,0,2,128,4,64,9,32,48,152,207,230,0,64,0,128,31,240,16,16,17,16,17,16,17,16,2,96,12,24,112,4,
  // 0x8d77  起
  119,141,15,16,32,16,0,254,8,0,8,0,8,248,126,8,8,8,8,8,254,248,8,136,40,128,40,128,46,132,40,132,40,124,88,0,79,254,128,0,
  // 0x8d85  超
  133,141,15,16,32,16,0,254,8,0,9,252,8,68,126,68,8,68,8,148,255,8,8,252,40,132,40,132,46,132,40,252,40,0,88,0,79,254,128,0,
  // 0x8ddd  距
  221,141,15,14,28,16,0,255,125,254,69,0,69,0,69,0,125,252,17,4,17,4,93,4,81,4,81,252,81,0,93,0,225,0,1,254,
  // 0x8f6c  转
  108,143,15,16,32,16,0,254,32,32,32,32,32,32,253,252,64,32,80,64,147,254,252,64,16,128,17,252,28,4,240,136,80,80,16,32,16,16,16,16,
  // 0x8f6f  软
  111,143,15,16,32,16,0,254,16,64,16,64,16,64,254,124,32,132,40,136,73,32,126,32,8,32,8,80,14,80,248,80,72,136,8,136,9,4,10,2,
  // 0x8f74  轴
  116,143,14,16,32,16,0,254,32,32,32,32,32,32,252,32,65,252,81,36,145,36,253,36,17,36,17,252,29,36,241,36,81,36,17,36,17,252,17,4,
  // 0x8f7d  载
  125,143,15,16,32,16,0,254,8,32,8,40,127,36,8,32,255,254,16,32,16,36,255,36,32,36,72,40,127,40,8,16,15,18,248,42,8,70,8,130,
  // 0x8f91  辑
  145,143,15,16,32,16,0,254,32,0,33,248,33,8,253,8,65,248,80,0,151,254,253,8,17,248,17,8,29,248,241,8,81,62,23,200,16,8,16,8,
  // 0x8f93  输
  147,143,15,16,32,16,0,254,32,64,32,160,33,16,250,8,37,246,64,0,83,196,146,84,250,84,19,212,26,84,242,84,83,212,18,68,18,84,18,200,
  // 0x8fb9  边
  185,143,15,15,30,16,0,255,0,64,32,64,16,64,19,252,0,68,0,68,240,68,16,132,16,132,17,4,17,4,18,40,20,16,40,0,71,254,
  // 0x8fc1  迁
  193,143,15,15,30,16,0,255,0,16,32,120,19,192,16,64,0,64,0,64,247,254,16,64,16,64,16,64,16,64,16,64,16,64,40,0,71,254,
  // 0x8fd0  运
  208,143,15,14,28,16,0,255,35,248,16,0,16,0,0,0,7,252,240,64,16,128,17,16,18,8,23,252,18,4,16,0,40,0,71,254,
  // 0x8fd1  近
  209,143,15,15,30,16,0,255,0,8,32,28,17,224,17,0,1,0,1,254,241,16,17,16,17,16,17,16,18,16,18,16,20,16,40,0,71,254,
  // 0x8fd4  返
  212,143,15,15,30,16,0,255,0,8,32,60,19,192,18,0,2,0,3,252,242,4,18,136,18,80,18,32,18,80,20,136,21,4,40,0,71,254,
  // 0x8fd8  还
  216,143,15,14,28,16,0,255,35,252,16,32,16,32,0,64,0,64,240,208,17,72,18,68,20,68,16,64,16,64,16,64,40,0,71,254,
  // 0x8fdb  进
  219,143,15,15,30,16,0,255,0,144,32,144,16,144,19,252,0,144,0,144,240,144,23,254,16,144,16,144,17,16,17,16,18,16,40,0,71,254,
  // 0x8fde  连
  222,143,15,15,30,16,0,255,0,64,32,64,23,254,16,128,0,160,1,32,243,252,16,32,16,32,16,32,23,254,16,32,16,32,40,32,71,254,
  // 0x8ff7  迷
  247,143,15,15,30,16,0,255,0,64,34,72,17,72,17,80,0,64,7,252,240,64,16,224,17,80,18,72,20,68,16,64,16,64,40,0,71,254,
  // 0x9000  退
  0,144,15,15,30,16,0,255,3,248,34,8,18,8,19,248,2,8,2,8,243,248,18,68,18,40,18,16,18,136,19,4,18,4,40,0,71,254,
  // 0x9009  选
  9,144,15,15,30,16,0,255,0,64,34,64,18,64,19,248,4,64,0,64,247,252,17,32,17,32,17,32,18,36,18,36,20,28,40,0,71,254,
  // 0x901f  速
  31,144,15,15,30,16,0,255,0,64,32,64,23,252,16,64,3,248,2,72,242,72,19,248,16,224,17,80,18,72,20,68,16,64,40,0,71,254,
  // 0x90e8  部
  232,144,15,16,32,16,0,254,16,0,8,62,127,162,0,36,33,36,18,40,255,228,0,36,0,34,63,34,33,34,33,52,33,40,63,32,33,32,0,32,
  // 0x914d  配
  77,145,15,15,30,16,0,254,254,0,40,248,40,8,254,8,170,8,170,8,170,248,174,136,194,128,130,128,254,128,130,130,130,130,254,126,130,0,
  // 0x91ca  释
  202,145,15,16,32,16,0,254,12,0,243,252,17,4,84,136,56,80,16,32,252,216,19,38,48,32,57,252,84,32,80,32,147,254,16,32,16,32,16,32,
  // 0x91cd  重
  205,145,15,15,30,16,0,255,0,16,0,248,63,0,1,0,255,254,1,0,31,240,17,16,31,240,17,16,31,240,1,0,63,248,1,0,255,254,
  // 0x91cf  量
  207,145,15,15,30,16,0,254,31,240,16,16,31,240,16,16,255,254,0,0,31,240,17,16,31,240,17,16,31,240,1,0,31,240,1,0,127,252,
  // 0x9488  针
  136,148,15,16,32,16,0,254,16,32,16,32,30,32,32,32,32,32,124,32,147,254,16,32,254,32,16,32,16,32,18,32,20,32,24,32,16,32,0,32,
  // 0x94ae  钮
  174,148,15,15,30,16,0,255,16,0,17,248,60,72,32,72,64,72,188,72,16,72,17,248,252,136,16,136,16,136,16,136,20,136,24,136,19,254,
  // 0x9519  错
  25,149,15,16,32,16,0,254,33,16,33,16,57,16,39,252,65,16,121,16,175,254,32,0,251,248,34,8,34,8,35,248,42,8,50,8,35,248,2,8,
  // 0x955c  镜
  92,149,15,16,32,16,0,254,32,128,32,64,59,248,33,16,64,160,119,254,160,0,35,248,250,8,35,248,34,8,35,248,41,32,49,34,34,34,12,30,
  // 0x957f  长
  127,149,15,16,32,16,0,254,8,0,8,16,8,32,8,64,8,128,9,0,8,0,255,254,10,0,9,0,8,128,8,64,9,32,10,24,12,6,8,0,
  // 0x95ed  闭
  237,149,13,16,32,16,1,254,64,0,47,248,0,8,129,8,129,8,191,232,129,8,131,8,133,8,137,8,145,8,161,8,133,8,130,8,128,40,128,16,
  // 0x95f2  闲
  242,149,13,16,32,16,1,254,64,0,47,248,0,8,130,8,130,8,130,8,191,232,130,8,135,8,138,136,146,72,162,40,130,8,130,8,128,40,128,16,
  // 0x95f4  间
  244,149,13,16,32,16,1,254,64,0,39,248,32,8,128,8,143,136,136,136,136,136,136,136,143,136,136,136,136,136,136,136,143,136,128,8,128,40,128,16,
  // 0x9608  阈
  8,150,13,16,32,16,1,254,64,0,47,248,1,8,129,72,129,40,191,232,129,8,157,72,149,72,157,72,129,136,140,168,177,104,130,40,132,8,128,24,
  // 0x964d  降
  77,150,14,16,32,16,1,254,1,0,249,0,137,248,146,16,149,32,160,192,147,48,156,76,136,64,139,248,136,64,212,64,167,252,128,64,128,64,128,64,
  // 0x9650  限
  80,150,14,15,30,16,1,254,247,240,148,16,164,16,167,240,196,16,164,16,151,240,148,136,148,144,212,96,164,64,132,32,133,16,134,12,132,0,
  // 0x9664  除
  100,150,14,15,30,16,1,254,240,128,144,128,161,64,162,32,196,16,171,236,144,128,144,128,151,248,208,128,162,160,132,144,136,136,130,136,129,0,
  // 0x9669  险
  105,150,14,16,32,16,1,254,0,128,240,128,145,64,161,64,162,32,196,16,171,236,144,0,145,16,144,144,212,144,162,160,130,32,128,64,143,252,128,0,
  // 0x96f6  零
  246,150,15,16,32,16,0,254,63,248,1,0,127,254,65,2,157,116,1,0,29,112,2,128,12,96,50,24,193,6,31,224,0,32,6,64,1,128,0,64,
  // 0x9700  需
  0,151,15,15,30,16,0,254,63,248,1,0,127,254,65,2,157,116,1,0,29,112,0,0,255,254,2,0,63,248,36,136,36,136,36,168,32,16,
  // 0x9752  青
  82,151,15,16,32,16,0,254,1,0,1,0,127,252,1,0,63,248,1,0,255,254,0,0,31,240,16,16,31,240,16,16,31,240,16,16,16,80,16,32,
  // 0x975e  非
  94,151,15,16,32,16,0,254,4,64,4,64,4,64,252,126,4,64,4,64,4,64,124,124,4,64,4,64,4,64,4,64,252,126,4,64,4,64,4,64,
  // 0x9760  靠
  96,151,15,16,32,16,0,254,17,0,31,240,33,0,255,254,0,0,31,240,16,16,31,240,4,64,124,124,4,64,60,120,4,64,124,124,4,64,4,64,
  // 0x9762  面
  98,151,15,15,30,16,0,254,255,254,2,0,2,0,4,0,63,248,36,72,36,72,39,200,36,72,36,72,39,200,36,72,36,72,63,248,32,8,
  // 0x9875  页
  117,152,13,15,30,16,1,254,255,248,4,0,8,0,63,224,32,32,34,32,34,32,34,32,34,32,34,32,37,32,4,128,8,64,48,32,192,16,
  // 0x9879  项
  121,152,15,15,30,16,0,254,1,254,0,32,252,64,17,252,17,4,17,36,17,36,17,36,17,36,17,36,29,68,224,80,64,136,1,4,2,2,
  // 0x9884  预
  132,152,15,15,30,16,0,254,249,254,8,32,80,64,33,252,17,4,253,36,37,36,41,36,33,36,33,36,33,68,32,80,32,136,161,4,66,2,
  // 0x9891  频
  145,152,15,16,32,16,0,254,16,0,17,254,80,32,92,64,81,252,81,4,255,36,1,36,17,36,85,36,85,36,85,68,132,80,8,136,49,4,194,2,
  // 0x989d  额
  157,152,15,16,32,16,0,254,16,0,8,254,127,16,65,32,16,124,30,68,34,84,84,84,8,84,20,84,34,84,127,84,162,40,34,36,62,66,34,130,
  // 0x98ce  风
  206,152,15,15,30,16,0,254,63,240,32,16,32,16,40,80,36,80,34,144,34,144,33,16,33,16,34,144,34,146,36,74,72,74,64,6,128,2,
  // 0x9971  饱
  113,153,15,15,30,16,0,255,32,128,32,128,33,252,57,4,74,4,85,244,129,20,33,20,33,20,33,244,33,4,33,40,41,18,49,2,32,254,
  // 0x9a6c  马
  108,154,14,15,30,16,0,254,127,224,0,32,0,32,16,32,16,32,16,32,31,252,0,4,0,4,0,4,255,228,0,4,0,4,0,40,0,16,
  // 0x9a71  驱
  113,154,15,15,30,16,0,254,249,254,9,0,73,4,73,68,73,40,73,40,125,16,5,16,5,40,29,40,229,68,69,132,5,0,41,254,16,0,
  // 0x9ad8  高
  216,154,15,16,32,16,0,254,2,0,1,0,255,254,0,0,15,224,8,32,8,32,15,224,0,0,127,252,64,4,79,228,72,36,72,36,79,228,64,12,
  // 0x9ec4  黄
  196,158,15,16,32,16,0,254,4,64,4,64,63,248,4,64,4,64,255,254,1,0,31,240,17,16,31,240,17,16,31,240,0,0,8,32,16,16,96,12,
  // 0x9ede  點
  222,158,15,16,32,16,0,254,0,16,254,16,146,16,214,16,186,30,146,16,254,16,16,16,254,254,16,130,30,130,224,130,2,130,170,130,168,254,128,130,
  // 0x9f50  齐
  80,159,15,16,32,16,0,254,2,0,1,0,127,252,8,32,4,64,3,128,12,96,48,24,200,38,8,32,8,32,8,32,8,32,16,32,16,32,32,32,
  // 0xff1a  ：
  26,255,4,7,7,16,6,1,240,240,0,0,0,240,240,
};

#endif // HAS_GRAPHICAL_TFT
