/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Latin Extended-A 16pt, capital 'A' height: 10px, width: 100%, range: 0x0100-0x017f
extern const uint8_t Unifont_Latin_Extended_A_10[2372] = {
  129,10,0,1,127,1,14,254, // unifont_t
  // 0x0100  Ā
  6,13,13,8,1,0,120,0,0,48,72,72,132,132,252,132,132,132,132,
  // 0x0101  ā
  6,11,11,8,1,0,120,0,0,120,132,4,124,132,132,140,116,
  // 0x0102  Ă
  6,14,14,8,1,0,132,132,120,0,48,72,72,132,132,252,132,132,132,132,
  // 0x0103  ă
  6,13,13,8,1,0,132,132,120,0,0,120,132,4,124,132,132,140,116,
  // 0x0104  Ą
  7,12,12,8,1,254,48,72,72,132,132,252,132,132,132,132,8,6,
  // 0x0105  ą
  7,10,10,8,1,254,120,132,4,124,132,132,140,116,8,6,
  // 0x0106  Ć
  6,14,14,8,1,0,24,96,0,0,120,132,132,128,128,128,128,132,132,120,
  // 0x0107  ć
  6,12,12,8,1,0,24,96,0,0,120,132,128,128,128,128,132,120,
  // 0x0108  Ĉ
  6,14,14,8,1,0,48,72,0,0,120,132,132,128,128,128,128,132,132,120,
  // 0x0109  ĉ
  6,12,12,8,1,0,48,72,0,0,120,132,128,128,128,128,132,120,
  // 0x010a  Ċ
  6,14,14,8,1,0,32,32,0,0,120,132,132,128,128,128,128,132,132,120,
  // 0x010b  ċ
  6,12,12,8,1,0,32,32,0,0,120,132,128,128,128,128,132,120,
  // 0x010c  Č
  6,14,14,8,1,0,72,48,0,0,120,132,132,128,128,128,128,132,132,120,
  // 0x010d  č
  6,12,12,8,1,0,72,48,0,0,120,132,128,128,128,128,132,120,
  // 0x010e  Ď
  6,14,14,8,1,0,144,96,0,0,240,136,132,132,132,132,132,132,136,240,
  // 0x010f  ď
  6,14,14,8,1,0,72,48,0,4,4,4,116,140,132,132,132,132,140,116,
  // 0x0110  Đ
  7,10,10,8,0,0,120,68,66,66,242,66,66,66,68,120,
  // 0x0111  đ
  7,11,11,8,1,0,4,30,4,116,140,132,132,132,132,140,116,
  // 0x0112  Ē
  6,13,13,8,1,0,120,0,0,252,128,128,128,248,128,128,128,128,252,
  // 0x0113  ē
  6,11,11,8,1,0,120,0,0,120,132,132,252,128,128,132,120,
  // 0x0114  Ĕ
  6,14,14,8,1,0,132,132,120,0,252,128,128,128,248,128,128,128,128,252,
  // 0x0115  ĕ
  6,12,12,8,1,0,132,132,120,0,120,132,132,252,128,128,132,120,
  // 0x0116  Ė
  6,14,14,8,1,0,32,32,0,0,252,128,128,128,248,128,128,128,128,252,
  // 0x0117  ė
  6,12,12,8,1,0,32,32,0,0,120,132,132,252,128,128,132,120,
  // 0x0118  Ę
  6,12,12,8,1,254,252,128,128,128,248,128,128,128,128,252,16,12,
  // 0x0119  ę
  6,10,10,8,1,254,120,132,132,252,128,128,132,120,32,24,
  // 0x011a  Ě
  6,14,14,8,1,0,72,48,0,0,252,128,128,128,248,128,128,128,128,252,
  // 0x011b  ě
  6,12,12,8,1,0,72,48,0,0,120,132,132,252,128,128,132,120,
  // 0x011c  Ĝ
  6,14,14,8,1,0,48,72,0,0,120,132,132,128,128,156,132,132,140,116,
  // 0x011d  ĝ
  6,14,14,8,1,254,48,72,0,4,116,136,136,136,112,64,120,132,132,120,
  // 0x011e  Ğ
  6,14,14,8,1,0,132,132,120,0,120,132,132,128,128,156,132,132,140,116,
  // 0x011f  ğ
  6,15,15,8,1,254,132,132,120,0,4,116,136,136,136,112,64,120,132,132,120,
  // 0x0120  Ġ
  6,14,14,8,1,0,32,32,0,0,120,132,132,128,128,156,132,132,140,116,
  // 0x0121  ġ
  6,14,14,8,1,254,32,32,0,4,116,136,136,136,112,64,120,132,132,120,
  // 0x0122  Ģ
  6,12,12,8,1,254,120,132,132,128,128,156,132,132,140,116,16,96,
  // 0x0123  ģ
  6,14,14,8,1,254,24,32,0,4,116,136,136,136,112,64,120,132,132,120,
  // 0x0124  Ĥ
  6,14,14,8,1,0,48,72,0,0,132,132,132,132,252,132,132,132,132,132,
  // 0x0125  ĥ
  6,14,14,8,1,0,96,144,0,128,128,128,184,196,132,132,132,132,132,132,
  // 0x0126  Ħ
  8,10,10,8,0,0,66,66,255,66,66,126,66,66,66,66,
  // 0x0127  ħ
  7,11,11,8,0,0,64,240,64,92,98,66,66,66,66,66,66,
  // 0x0128  Ĩ
  6,14,14,8,1,0,100,152,0,0,124,16,16,16,16,16,16,16,16,124,
  // 0x0129  ĩ
  6,12,12,8,1,0,100,152,0,0,48,16,16,16,16,16,16,124,
  // 0x012a  Ī
  5,13,13,8,2,0,240,0,0,248,32,32,32,32,32,32,32,32,248,
  // 0x012b  ī
  5,11,11,8,2,0,240,0,0,96,32,32,32,32,32,32,248,
  // 0x012c  Ĭ
  6,14,14,8,1,0,132,132,120,0,124,16,16,16,16,16,16,16,16,124,
  // 0x012d  ĭ
  6,12,12,8,1,0,132,132,120,0,48,16,16,16,16,16,16,124,
  // 0x012e  Į
  5,12,12,8,2,254,248,32,32,32,32,32,32,32,32,248,32,24,
  // 0x012f  į
  5,13,13,8,2,254,32,32,0,96,32,32,32,32,32,32,248,32,24,
  // 0x0130  İ
  5,14,14,8,2,0,32,32,0,0,248,32,32,32,32,32,32,32,32,248,
  // 0x0131  ı
  5,8,8,8,2,0,96,32,32,32,32,32,32,248,
  // 0x0132  Ĳ
  6,10,10,8,1,0,132,132,132,132,132,132,4,4,132,120,
  // 0x0133  ĳ
  5,14,14,8,2,254,136,136,0,0,136,136,136,136,136,136,104,8,136,112,
  // 0x0134  Ĵ
  7,14,14,8,1,0,24,36,0,0,62,8,8,8,8,8,8,136,136,112,
  // 0x0135  ĵ
  6,14,14,8,1,254,24,36,0,0,24,8,8,8,8,8,8,8,144,96,
  // 0x0136  Ķ
  7,12,12,8,0,254,66,68,72,80,96,96,80,72,68,66,32,192,
  // 0x0137  ķ
  7,13,13,8,0,254,64,64,64,68,72,80,96,80,72,68,66,32,192,
  // 0x0138  ĸ
  6,8,8,8,1,0,132,136,144,224,224,144,136,132,
  // 0x0139  Ĺ
  6,14,14,8,1,0,48,192,0,0,128,128,128,128,128,128,128,128,128,252,
  // 0x013a  ĺ
  5,14,14,8,2,0,48,192,0,96,32,32,32,32,32,32,32,32,32,248,
  // 0x013b  Ļ
  6,12,12,8,1,254,128,128,128,128,128,128,128,128,128,252,16,96,
  // 0x013c  ļ
  5,13,13,8,2,254,96,32,32,32,32,32,32,32,32,32,248,32,192,
  // 0x013d  Ľ
  6,14,14,8,1,0,72,48,0,0,128,128,128,128,128,128,128,128,128,252,
  // 0x013e  ľ
  5,14,14,8,2,0,144,96,0,96,32,32,32,32,32,32,32,32,32,248,
  // 0x013f  Ŀ
  6,10,10,8,1,0,128,128,128,128,136,136,128,128,128,252,
  // 0x0140  ŀ
  5,11,11,8,1,0,96,32,32,32,32,40,40,32,32,32,248,
  // 0x0141  Ł
  7,10,10,8,0,0,64,64,72,80,96,192,64,64,64,126,
  // 0x0142  ł
  5,11,11,8,2,0,96,32,32,40,48,96,160,32,32,32,248,
  // 0x0143  Ń
  6,14,14,8,1,0,24,96,0,0,132,196,196,164,164,148,148,140,140,132,
  // 0x0144  ń
  6,12,12,8,1,0,24,96,0,0,184,196,132,132,132,132,132,132,
  // 0x0145  Ņ
  7,12,12,8,0,254,66,98,98,82,82,74,74,70,70,66,32,192,
  // 0x0146  ņ
  7,10,10,8,0,254,92,98,66,66,66,66,66,66,32,192,
  // 0x0147  Ň
  6,14,14,8,1,0,72,48,0,0,132,196,196,164,164,148,148,140,140,132,
  // 0x0148  ň
  6,12,12,8,1,0,72,48,0,0,184,196,132,132,132,132,132,132,
  // 0x0149  ŉ
  6,13,13,8,1,0,192,64,64,128,0,184,196,132,132,132,132,132,132,
  // 0x014a  Ŋ
  6,10,10,8,1,0,184,196,132,132,132,132,132,132,132,152,
  // 0x014b  ŋ
  6,10,10,8,1,254,184,196,132,132,132,132,132,132,4,24,
  // 0x014c  Ō
  6,13,13,8,1,0,120,0,0,120,132,132,132,132,132,132,132,132,120,
  // 0x014d  ō
  6,11,11,8,1,0,120,0,0,120,132,132,132,132,132,132,120,
  // 0x014e  Ŏ
  6,14,14,8,1,0,132,132,120,0,120,132,132,132,132,132,132,132,132,120,
  // 0x014f  ŏ
  6,12,12,8,1,0,132,132,120,0,120,132,132,132,132,132,132,120,
  // 0x0150  Ő
  7,14,14,8,1,0,102,136,0,0,120,132,132,132,132,132,132,132,132,120,
  // 0x0151  ő
  7,12,12,8,1,0,102,136,0,0,120,132,132,132,132,132,132,120,
  // 0x0152  Œ
  7,10,10,8,1,0,110,144,144,144,156,144,144,144,144,110,
  // 0x0153  œ
  7,8,8,8,1,0,108,146,146,158,144,144,146,108,
  // 0x0154  Ŕ
  6,14,14,8,1,0,24,96,0,0,248,132,132,132,248,144,136,136,132,132,
  // 0x0155  ŕ
  6,12,12,8,1,0,24,96,0,0,184,196,132,128,128,128,128,128,
  // 0x0156  Ŗ
  7,12,12,8,0,254,124,66,66,66,124,72,68,68,66,66,32,192,
  // 0x0157  ŗ
  7,10,10,8,0,254,92,98,66,64,64,64,64,64,32,192,
  // 0x0158  Ř
  6,14,14,8,1,0,72,48,0,0,248,132,132,132,248,144,136,136,132,132,
  // 0x0159  ř
  6,12,12,8,1,0,72,48,0,0,184,196,132,128,128,128,128,128,
  // 0x015a  Ś
  6,14,14,8,1,0,24,96,0,0,120,132,132,128,96,24,4,132,132,120,
  // 0x015b  ś
  6,12,12,8,1,0,24,96,0,0,120,132,128,96,24,132,132,120,
  // 0x015c  Ŝ
  6,14,14,8,1,0,48,72,0,0,120,132,132,128,96,24,4,132,132,120,
  // 0x015d  ŝ
  6,12,12,8,1,0,48,72,0,0,120,132,128,96,24,4,132,120,
  // 0x015e  Ş
  6,12,12,8,1,254,120,132,132,128,96,24,4,132,132,120,16,96,
  // 0x015f  ş
  6,10,10,8,1,254,120,132,128,96,24,4,132,120,16,96,
  // 0x0160  Š
  6,14,14,8,1,0,72,48,0,0,120,132,132,128,96,24,4,132,132,120,
  // 0x0161  š
  6,12,12,8,1,0,72,48,0,0,120,132,128,96,24,4,132,120,
  // 0x0162  Ţ
  7,12,12,8,1,254,254,16,16,16,16,16,16,16,16,16,16,96,
  // 0x0163  ţ
  5,12,12,8,1,254,32,32,32,248,32,32,32,32,32,24,16,96,
  // 0x0164  Ť
  7,14,14,8,1,0,72,48,0,0,254,16,16,16,16,16,16,16,16,16,
  // 0x0165  ť
  5,14,14,8,1,0,72,48,0,0,32,32,32,248,32,32,32,32,32,24,
  // 0x0166  Ŧ
  7,10,10,8,1,0,254,16,16,16,124,16,16,16,16,16,
  // 0x0167  ŧ
  5,10,10,8,1,0,32,32,32,248,32,32,248,32,32,24,
  // 0x0168  Ũ
  6,14,14,8,1,0,100,152,0,0,132,132,132,132,132,132,132,132,132,120,
  // 0x0169  ũ
  6,12,12,8,1,0,100,152,0,0,132,132,132,132,132,132,140,116,
  // 0x016a  Ū
  6,13,13,8,1,0,120,0,0,132,132,132,132,132,132,132,132,132,120,
  // 0x016b  ū
  6,11,11,8,1,0,120,0,0,132,132,132,132,132,132,140,116,
  // 0x016c  Ŭ
  6,14,14,8,1,0,132,132,120,0,132,132,132,132,132,132,132,132,132,120,
  // 0x016d  ŭ
  6,13,13,8,1,0,132,132,120,0,0,132,132,132,132,132,132,140,116,
  // 0x016e  Ů
  6,14,14,8,1,0,48,72,48,0,132,132,132,132,132,132,132,132,132,120,
  // 0x016f  ů
  6,12,12,8,1,0,48,72,48,0,132,132,132,132,132,132,140,116,
  // 0x0170  Ű
  7,14,14,8,1,0,102,136,0,0,132,132,132,132,132,132,132,132,132,120,
  // 0x0171  ű
  7,12,12,8,1,0,102,136,0,0,132,132,132,132,132,132,140,116,
  // 0x0172  Ų
  6,12,12,8,1,254,132,132,132,132,132,132,132,132,132,120,32,24,
  // 0x0173  ų
  7,10,10,8,1,254,132,132,132,132,132,132,140,116,8,6,
  // 0x0174  Ŵ
  6,14,14,8,1,0,48,72,0,0,132,132,132,132,180,180,204,204,132,132,
  // 0x0175  ŵ
  7,12,12,8,1,0,48,72,0,0,130,146,146,146,146,146,146,108,
  // 0x0176  Ŷ
  7,14,14,8,1,0,48,72,0,0,130,130,68,68,40,16,16,16,16,16,
  // 0x0177  ŷ
  6,14,14,8,1,254,48,72,0,0,132,132,132,132,132,76,52,4,4,120,
  // 0x0178  Ÿ
  7,14,14,8,1,0,72,72,0,0,130,130,68,68,40,16,16,16,16,16,
  // 0x0179  Ź
  6,14,14,8,1,0,24,96,0,0,252,4,4,8,16,32,64,128,128,252,
  // 0x017a  ź
  6,12,12,8,1,0,24,96,0,0,252,4,8,16,32,64,128,252,
  // 0x017b  Ż
  6,14,14,8,1,0,32,32,0,0,252,4,4,8,16,32,64,128,128,252,
  // 0x017c  ż
  6,12,12,8,1,0,32,32,0,0,252,4,8,16,32,64,128,252,
  // 0x017d  Ž
  6,14,14,8,1,0,72,48,0,0,252,4,4,8,16,32,64,128,128,252,
  // 0x017e  ž
  6,12,12,8,1,0,72,48,0,0,252,4,8,16,32,64,128,252,
  // 0x017f  ſ
  5,11,11,8,1,0,24,32,32,32,224,32,32,32,32,32,32,
};

#endif // HAS_GRAPHICAL_TFT
