/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Korean 16pt, capital 'A' height: 10px, width: 100%, range: 0xac70-0xd788, glyphs: 110
extern const uint8_t Unifont_Korean_10[3786] = {
  161,10,112,172,136,215,14,254, // unifont_t
  // 0xac70  거
  112,172,12,13,26,16,3,255,0,16,0,16,252,16,4,16,4,16,4,240,8,16,8,16,16,16,32,16,192,16,0,16,0,16,
  // 0xace0  고
  224,172,13,10,20,16,1,0,127,224,0,32,0,32,0,32,0,32,4,32,4,0,4,0,4,0,255,248,
  // 0xadf8  그
  248,173,13,8,16,16,1,2,127,224,0,32,0,32,0,32,0,32,0,32,0,0,255,248,
  // 0xae09  급
  9,174,13,13,26,16,1,255,63,224,0,32,0,32,0,32,0,32,0,0,255,248,0,0,32,32,32,32,63,224,32,32,63,224,
  // 0xae30  기
  48,174,10,13,26,16,3,255,0,64,0,64,252,64,4,64,4,64,4,64,8,64,8,64,16,64,32,64,192,64,0,64,0,64,
  // 0xae45  깅
  69,174,11,14,28,16,2,255,0,32,248,32,8,32,8,32,16,32,32,32,192,32,0,32,0,0,0,0,15,192,16,32,16,32,15,192,
  // 0xb044  끄
  68,176,13,8,16,16,1,2,125,240,4,16,4,16,4,16,4,16,0,0,0,0,255,248,
  // 0xb0b4  내
  180,176,14,13,26,16,1,255,0,36,0,36,0,36,128,36,128,36,128,60,128,36,128,36,128,36,255,36,0,36,0,36,0,36,
  // 0xb178  노
  120,177,13,12,24,16,1,0,64,0,64,0,64,0,64,0,64,0,127,240,0,0,0,0,2,0,2,0,2,0,255,248,
  // 0xb204  누
  4,178,11,13,26,16,2,255,128,0,128,0,128,0,128,0,128,0,255,224,0,0,0,0,255,224,4,0,4,0,4,0,4,0,
  // 0xb274  뉴
  116,178,13,13,26,16,1,255,64,0,64,0,64,0,64,0,64,0,127,240,0,0,0,0,255,248,8,128,8,128,8,128,8,128,
  // 0xb2c8  니
  200,178,12,13,26,16,1,255,0,16,0,16,0,16,128,16,128,16,128,16,128,16,128,16,128,16,255,16,0,16,0,16,0,16,
  // 0xb2e4  다
  228,178,14,13,26,16,1,255,0,32,0,32,255,32,128,32,128,32,128,60,128,32,128,32,255,32,0,32,0,32,0,32,0,32,
  // 0xb2f9  당
  249,178,14,14,28,16,1,255,0,16,0,16,252,16,128,16,128,28,128,16,252,16,0,16,0,0,0,0,7,224,8,16,8,16,7,224,
  // 0xb3c4  도
  196,179,13,12,24,16,1,0,127,240,64,0,64,0,64,0,64,0,127,240,0,0,0,0,2,0,2,0,2,0,255,248,
  // 0xb3cc  돌
  204,179,13,13,26,16,1,255,63,224,32,0,32,0,63,224,2,0,2,0,255,248,0,0,63,224,0,32,63,224,32,0,63,224,
  // 0xb3d9  동
  217,179,13,13,26,16,1,255,63,224,32,0,32,0,63,224,2,0,2,0,255,248,0,0,0,0,15,128,16,64,16,64,15,128,
  // 0xb418  되
  24,180,12,14,28,16,1,255,0,16,0,16,255,16,128,16,128,16,128,16,255,16,0,16,0,16,8,16,8,16,255,208,0,16,0,16,
  // 0xb41c  된
  28,180,12,14,28,16,1,255,0,16,127,16,64,16,64,16,127,16,8,16,8,16,255,208,0,0,16,0,16,0,16,0,16,0,31,240,
  // 0xb428  됨
  40,180,12,14,28,16,1,255,0,16,127,16,64,16,64,16,127,16,8,16,8,16,255,208,0,0,7,240,4,16,4,16,4,16,7,240,
  // 0xb4a4  뒤
  164,180,12,14,28,16,1,255,0,16,0,16,255,144,128,16,128,16,128,16,255,144,0,16,0,16,255,208,8,16,8,16,8,16,8,16,
  // 0xb4dc  드
  220,180,13,10,20,16,1,2,127,240,64,0,64,0,64,0,64,0,127,240,0,0,0,0,0,0,255,248,
  // 0xb514  디
  20,181,12,13,26,16,1,255,0,16,0,16,255,16,128,16,128,16,128,16,128,16,128,16,255,16,0,16,0,16,0,16,0,16,
  // 0xb77c  라
  124,183,13,13,26,16,2,255,0,64,0,64,254,64,2,64,2,64,254,120,128,64,128,64,128,64,254,64,0,64,0,64,0,64,
  // 0xb7ec  러
  236,183,13,13,26,16,2,255,0,8,0,8,254,8,2,8,2,8,254,120,128,8,128,8,128,8,254,8,0,8,0,8,0,8,
  // 0xb808  레
  8,184,13,13,26,16,2,255,0,40,0,40,254,40,2,40,2,40,254,232,128,40,128,40,128,40,254,40,0,40,0,40,0,40,
  // 0xb825  력
  37,184,11,14,28,16,2,255,0,32,0,32,252,32,4,224,252,32,128,224,252,32,0,32,0,0,0,0,31,224,0,32,0,32,0,32,
  // 0xb85c  로
  92,184,13,12,24,16,1,0,63,224,0,32,0,32,63,224,32,0,32,0,63,224,0,0,2,0,2,0,2,0,255,248,
  // 0xb8cc  료
  204,184,13,12,24,16,1,0,63,224,0,32,0,32,63,224,32,0,32,0,63,224,8,128,8,128,8,128,8,128,255,248,
  // 0xb974  르
  116,185,13,10,20,16,1,2,63,224,0,32,0,32,63,224,32,0,32,0,63,224,0,0,0,0,255,248,
  // 0xb9ac  리
  172,185,11,13,26,16,2,255,0,32,0,32,254,32,2,32,2,32,254,32,128,32,128,32,128,32,254,32,0,32,0,32,0,32,
  // 0xb9b0  린
  176,185,11,14,28,16,2,255,0,32,0,32,252,32,4,32,252,32,128,32,252,32,0,32,0,32,0,0,64,0,64,0,64,0,127,224,
  // 0xb9bd  립
  189,185,11,14,28,16,2,255,0,32,0,32,252,32,4,32,252,32,128,32,252,32,0,32,0,0,8,32,8,32,15,224,8,32,15,224,
  // 0xb9c1  링
  193,185,11,14,28,16,2,255,0,32,0,32,252,32,4,32,252,32,128,32,252,32,0,32,0,0,0,0,15,192,16,32,16,32,15,192,
  // 0xba48  멈
  72,186,12,14,28,16,1,255,0,16,252,16,132,16,132,16,132,112,132,16,252,16,0,16,0,0,7,240,4,16,4,16,4,16,7,240,
  // 0xba54  메
  84,186,14,13,26,16,1,255,0,20,0,20,255,20,129,20,129,20,129,116,129,20,129,20,129,20,255,20,0,20,0,20,0,20,
  // 0xba74  면
  116,186,12,14,28,16,1,255,0,16,252,16,132,16,132,112,132,16,132,112,252,16,0,16,0,16,0,0,32,0,32,0,32,0,63,240,
  // 0xbaa8  모
  168,186,13,12,24,16,1,0,127,240,64,16,64,16,64,16,64,16,127,240,0,0,0,0,2,0,2,0,2,0,255,248,
  // 0xbabb  못
  187,186,13,14,28,16,1,255,63,224,32,32,32,32,32,32,63,224,2,0,2,0,255,248,0,0,0,0,2,0,2,0,5,0,24,128,
  // 0xbbf8  미
  248,187,12,13,26,16,1,255,0,16,0,16,255,16,129,16,129,16,129,16,129,16,129,16,129,16,255,16,0,16,0,16,0,16,
  // 0xbc00  밀
  0,188,12,14,28,16,1,255,0,16,252,16,132,16,132,16,132,16,132,16,252,16,0,16,0,0,15,240,0,16,15,240,8,0,15,240,
  // 0xbc14  바
  20,188,13,13,26,16,2,255,0,64,0,64,130,64,130,64,130,64,254,120,130,64,130,64,130,64,254,64,0,64,0,64,0,64,
  // 0xbc84  버
  132,188,13,13,26,16,2,255,0,8,0,8,130,8,130,8,130,8,254,120,130,8,130,8,130,8,254,8,0,8,0,8,0,8,
  // 0xbca0  베
  160,188,13,13,26,16,2,255,0,40,0,40,130,40,130,40,130,40,254,232,130,40,130,40,130,40,254,40,0,40,0,40,0,40,
  // 0xbca8  벨
  168,188,12,14,28,16,1,255,0,80,0,80,132,80,132,80,253,208,132,80,252,80,0,80,0,0,15,240,0,16,15,240,8,0,15,240,
  // 0xbcf8  본
  248,188,13,14,28,16,1,255,32,32,32,32,63,224,32,32,63,224,2,0,2,0,255,248,0,0,0,0,32,0,32,0,32,0,63,224,
  // 0xbe44  비
  68,190,11,13,26,16,2,255,0,32,0,32,130,32,130,32,130,32,254,32,130,32,130,32,130,32,254,32,0,32,0,32,0,32,
  // 0xc0ac  사
  172,192,14,13,26,16,1,255,0,32,0,32,4,32,4,32,8,32,8,60,20,32,34,32,193,32,0,32,0,32,0,32,0,32,
  // 0xc0bd  삽
  189,192,14,14,28,16,1,255,0,16,0,16,8,16,8,16,24,28,36,16,194,16,0,16,0,0,4,16,4,16,7,240,4,16,7,240,
  // 0xc0c8  새
  200,192,14,13,26,16,1,255,0,36,0,36,4,36,4,36,8,36,8,60,20,36,34,36,193,36,0,36,0,36,0,36,0,36,
  // 0xc124  설
  36,193,12,14,28,16,1,255,0,16,0,16,8,16,8,16,24,112,36,16,194,16,0,16,0,0,15,240,0,16,15,240,8,0,15,240,
  // 0xc18c  소
  140,193,13,12,24,16,1,0,1,0,1,0,2,0,2,0,5,0,8,128,48,64,0,0,2,0,2,0,2,0,255,248,
  // 0xc18d  속
  141,193,13,14,28,16,1,255,1,0,1,0,3,0,4,128,24,64,2,0,2,0,255,248,0,0,63,224,0,32,0,32,0,32,0,32,
  // 0xc2a4  스
  164,194,13,10,20,16,1,2,1,0,1,0,2,0,2,0,5,0,8,128,48,64,0,0,0,0,255,248,
  // 0xc2ac  슬
  172,194,13,14,28,16,1,255,1,0,1,0,3,0,4,128,24,64,0,0,0,0,255,248,0,0,63,224,0,32,63,224,32,0,63,224,
  // 0xc2dc  시
  220,194,12,13,26,16,1,255,0,16,0,16,4,16,4,16,8,16,8,16,20,16,34,16,193,16,0,16,0,16,0,16,0,16,
  // 0xc2dd  식
  221,194,12,14,28,16,1,255,0,16,0,16,8,16,8,16,24,16,36,16,194,16,0,16,0,0,0,0,15,240,0,16,0,16,0,16,
  // 0xc5b4  어
  180,197,14,13,26,16,1,255,0,4,0,4,60,4,66,4,129,4,129,60,129,4,66,4,60,4,0,4,0,4,0,4,0,4,
  // 0xc5c6  없
  198,197,13,14,28,16,2,255,0,32,120,32,132,32,132,32,132,224,132,32,120,32,0,32,0,0,132,32,132,32,252,32,132,80,253,136,
  // 0xc5d1  엑
  209,197,11,14,28,16,2,255,0,160,120,160,132,160,132,160,135,160,132,160,120,160,0,160,0,0,31,224,0,32,0,32,0,32,0,32,
  // 0xc5d4  엔
  212,197,11,14,28,16,2,255,0,160,120,160,132,160,132,160,135,160,132,160,120,160,0,160,0,0,32,0,32,0,32,0,32,0,63,224,
  // 0xc5f4  열
  244,197,11,14,28,16,2,255,0,32,120,32,132,32,132,224,132,32,132,224,120,32,0,32,0,0,31,224,0,32,31,224,16,0,31,224,
  // 0xc608  예
  8,198,14,13,26,16,1,255,0,20,0,20,60,20,66,20,129,116,129,20,129,20,66,116,60,20,0,20,0,20,0,20,0,20,
  // 0xc624  오
  36,198,13,13,26,16,1,0,15,128,16,64,32,32,32,32,32,32,16,64,15,128,0,0,0,0,2,0,2,0,2,0,255,248,
  // 0xc628  온
  40,198,13,14,28,16,1,255,15,128,16,64,16,64,16,64,15,128,2,0,2,0,255,248,0,0,0,0,32,0,32,0,32,0,63,224,
  // 0xc644  완
  68,198,14,14,28,16,1,255,0,16,62,16,65,16,65,28,65,16,62,16,8,16,255,208,0,0,16,0,16,0,16,0,16,0,31,240,
  // 0xc6d0  원
  208,198,12,15,30,16,1,255,62,16,65,16,65,16,65,16,62,16,0,16,0,16,255,208,4,240,4,16,4,16,32,0,32,0,32,0,63,240,
  // 0xc704  위
  4,199,12,14,28,16,1,255,0,16,62,16,65,16,128,144,128,144,128,144,65,16,62,16,0,16,255,208,8,16,8,16,8,16,8,16,
  // 0xc73c  으
  60,199,13,11,22,16,1,2,15,128,16,64,32,32,32,32,32,32,16,64,15,128,0,0,0,0,0,0,255,248,
  // 0xc74c  음
  76,199,13,14,28,16,1,255,15,128,16,64,16,64,16,64,15,128,0,0,0,0,255,248,0,0,63,224,32,32,32,32,32,32,63,224,
  // 0xc774  이
  116,199,12,13,26,16,1,255,0,16,0,16,60,16,66,16,129,16,129,16,129,16,66,16,60,16,0,16,0,16,0,16,0,16,
  // 0xc77c  일
  124,199,11,14,28,16,2,255,0,32,120,32,132,32,132,32,132,32,132,32,120,32,0,32,0,0,31,224,0,32,31,224,16,0,31,224,
  // 0xc77d  읽
  125,199,11,14,28,16,2,255,0,32,120,32,132,32,132,32,132,32,132,32,120,32,0,32,0,0,251,224,8,32,248,32,128,32,248,32,
  // 0xc785  입
  133,199,11,14,28,16,2,255,0,32,120,32,132,32,132,32,132,32,132,32,120,32,0,32,0,0,8,32,8,32,15,224,8,32,15,224,
  // 0xc790  자
  144,199,13,13,26,16,2,255,0,64,0,64,254,64,4,64,4,64,8,120,24,64,36,64,194,64,0,64,0,64,0,64,0,64,
  // 0xc791  작
  145,199,14,14,28,16,1,255,0,16,0,16,252,16,8,16,8,28,52,16,194,16,0,16,0,0,15,240,0,16,0,16,0,16,0,16,
  // 0xc798  잘
  152,199,14,14,28,16,1,255,0,16,0,16,252,16,8,16,8,28,52,16,194,16,0,16,0,0,15,240,0,16,15,240,8,0,15,240,
  // 0xc7a5  장
  165,199,14,14,28,16,1,255,0,16,0,16,252,16,8,16,8,28,52,16,194,16,0,16,0,0,0,0,7,224,8,16,8,16,7,224,
  // 0xc7ac  재
  172,199,13,13,26,16,2,255,0,72,0,72,254,72,4,72,4,72,8,120,24,72,36,72,194,72,0,72,0,72,0,72,0,72,
  // 0xc800  저
  0,200,13,13,26,16,2,255,0,8,0,8,254,8,4,8,4,8,8,120,24,8,36,8,194,8,0,8,0,8,0,8,0,8,
  // 0xc804  전
  4,200,12,14,28,16,1,255,0,16,0,16,252,16,8,16,8,112,52,16,194,16,0,16,0,0,0,0,32,0,32,0,32,0,63,240,
  // 0xc815  정
  21,200,12,14,28,16,1,255,0,16,0,16,252,16,8,16,8,112,52,16,194,16,0,16,0,0,0,0,7,224,8,16,8,16,7,224,
  // 0xc81c  제
  28,200,13,13,26,16,2,255,0,40,0,40,254,40,4,40,4,40,8,232,24,40,36,40,194,40,0,40,0,40,0,40,0,40,
  // 0xc8fd  죽
  253,200,13,14,28,16,1,255,31,128,1,0,1,0,6,128,24,64,0,0,255,248,2,0,2,0,63,224,0,32,0,32,0,32,0,32,
  // 0xc900  준
  0,201,13,14,28,16,1,255,31,128,1,0,1,0,6,128,24,64,0,0,0,0,255,248,2,0,2,0,34,0,32,0,32,0,63,224,
  // 0xc911  중
  17,201,13,14,28,16,1,255,31,128,1,0,1,0,6,128,24,64,0,0,255,248,2,0,2,0,0,0,15,128,16,64,16,64,15,128,
  // 0xc990  즐
  144,201,13,14,28,16,1,255,31,128,1,0,6,128,24,64,0,0,0,0,0,0,255,248,0,0,63,224,0,32,63,224,32,0,63,224,
  // 0xc9c0  지
  192,201,11,13,26,16,2,255,0,32,0,32,254,32,4,32,4,32,8,32,24,32,36,32,194,32,0,32,0,32,0,32,0,32,
  // 0xcc98  처
  152,204,13,13,26,16,2,255,0,8,16,8,16,8,254,8,4,8,8,120,24,8,36,8,194,8,0,8,0,8,0,8,0,8,
  // 0xcd08  초
  8,205,13,13,26,16,1,0,2,0,2,0,31,192,0,128,1,0,3,0,4,128,24,64,0,0,2,0,2,0,2,0,255,248,
  // 0xcd95  축
  149,205,13,14,28,16,1,255,2,0,31,128,2,0,5,0,24,128,0,0,255,248,2,0,2,0,63,224,0,32,0,32,0,32,0,32,
  // 0xcd9c  출
  156,205,13,14,28,16,1,255,2,0,31,128,2,0,5,0,24,128,0,0,255,248,2,0,2,0,63,224,0,32,63,224,32,0,63,224,
  // 0xcda4  춤
  164,205,13,14,28,16,1,255,2,0,31,128,2,0,5,0,24,128,0,0,255,248,2,0,2,0,63,224,32,32,32,32,32,32,63,224,
  // 0xcde8  취
  232,205,12,14,28,16,1,255,8,16,8,16,127,16,2,16,4,16,12,16,18,16,97,16,0,16,255,208,8,16,8,16,8,16,8,16,
  // 0xce58  치
  88,206,11,13,26,16,2,255,0,32,16,32,16,32,254,32,4,32,8,32,24,32,36,32,194,32,0,32,0,32,0,32,0,32,
  // 0xce68  침
  104,206,12,14,28,16,1,255,0,16,0,16,16,16,252,16,16,16,40,16,196,16,0,16,0,0,7,240,4,16,4,16,4,16,7,240,
  // 0xce74  카
  116,206,12,13,26,16,3,255,0,128,0,128,252,128,4,128,4,128,4,240,248,128,8,128,16,128,32,128,192,128,0,128,0,128,
  // 0xcf1c  켜
  28,207,12,13,26,16,3,255,0,16,0,16,252,16,4,16,4,240,4,16,248,16,8,240,16,16,32,16,192,16,0,16,0,16,
  // 0xd0d1  탑
  209,208,14,14,28,16,1,255,0,16,0,16,252,16,128,16,252,28,128,16,252,16,0,16,0,0,4,16,4,16,7,240,4,16,7,240,
  // 0xd130  터
  48,209,13,13,26,16,2,255,0,8,0,8,254,8,128,8,128,8,254,120,128,8,128,8,254,8,0,8,0,8,0,8,0,8,
  // 0xd14c  테
  76,209,13,13,26,16,2,255,0,40,0,40,254,40,128,40,128,40,254,232,128,40,128,40,254,40,0,40,0,40,0,40,0,40,
  // 0xd1a0  토
  160,209,13,13,26,16,1,0,127,240,64,0,64,0,127,240,64,0,64,0,127,240,0,0,0,0,2,0,2,0,2,0,255,248,
  // 0xd2b8  트
  184,210,13,11,22,16,1,2,127,240,64,0,64,0,127,240,64,0,64,0,127,240,0,0,0,0,0,0,255,248,
  // 0xd39c  펜
  156,211,12,14,28,16,1,255,0,80,0,80,255,80,36,80,37,208,36,80,255,80,0,80,0,0,16,0,16,0,16,0,16,0,31,240,
  // 0xd504  프
  4,213,13,10,20,16,1,2,127,240,16,64,16,64,16,64,16,64,127,240,0,0,0,0,0,0,255,248,
  // 0xd558  하
  88,213,13,13,26,16,2,255,16,64,16,64,254,64,56,64,68,64,130,120,130,64,130,64,68,64,56,64,0,64,0,64,0,64,
  // 0xd569  합
  105,213,14,14,28,16,1,255,16,16,254,16,56,16,68,16,68,28,68,16,56,16,0,16,0,0,4,16,4,16,7,240,4,16,7,240,
  // 0xd648  홈
  72,214,13,15,30,16,1,255,2,0,31,192,15,128,16,64,16,64,15,128,2,0,2,0,255,248,0,0,63,224,32,32,32,32,32,32,63,224,
  // 0xd654  화
  84,214,14,14,28,16,1,255,0,32,8,32,8,32,127,32,0,32,62,32,65,60,65,32,62,32,8,32,8,32,255,160,0,32,0,32,
  // 0xd788  히
  136,215,11,13,26,16,2,255,16,32,16,32,254,32,56,32,68,32,130,32,130,32,130,32,68,32,56,32,0,32,0,32,0,32,
};

#endif // HAS_GRAPHICAL_TFT
