/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Vietnamese 40pt, capital 'A' height: 29px, width: 100%, range: 0x0102-0x1ef9, glyphs: 107
extern const uint8_t NotoSans_Medium_Vietnamese_29[15205] = {
  162,29,2,1,249,30,38,246, // unifont_t
  // 0x0102  Ă
  2,1,26,37,3,26,0,0,0,11,192,0,62,0,0,0,7,208,0,189,0,0,0,3,254,171,252,0,0,0,1,255,255,244,0,0,0,0,127,255,208,0,0,0,0,6,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x0103  ă
  3,1,18,31,155,23,2,255,3,208,0,47,0,3,240,0,63,0,2,254,171,253,0,0,255,255,252,0,0,63,255,224,0,0,6,170,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x0110  Đ
  16,1,26,29,203,29,1,0,2,170,170,148,0,0,0,3,255,255,255,224,0,0,3,255,255,255,255,0,0,3,255,255,255,255,208,0,3,253,0,6,255,244,0,3,253,0,0,47,253,0,3,253,0,0,7,255,0,3,253,0,0,2,255,128,3,253,0,0,0,255,192,3,253,0,0,0,127,208,3,253,0,0,0,63,224,3,253,0,0,0,63,224,3,253,0,0,0,47,240,255,255,255,224,0,47,240,255,255,255,224,0,47,240,255,255,255,224,0,47,240,171,255,170,160,0,47,240,3,253,0,0,0,63,224,3,253,0,0,0,63,224,3,253,0,0,0,127,192,3,253,0,0,0,255,192,3,253,0,0,1,255,128,3,253,0,0,3,255,0,3,253,0,0,31,253,0,3,253,0,1,255,248,0,3,255,170,255,255,224,0,3,255,255,255,255,64,0,3,255,255,255,244,0,0,3,255,255,249,0,0,0,
  // 0x0111  đ
  17,1,23,32,192,25,2,255,0,0,0,1,84,0,0,0,0,3,253,0,0,0,0,3,253,0,0,0,0,3,253,0,0,2,255,255,255,244,0,2,255,255,255,248,0,2,255,255,255,248,0,0,0,3,254,0,0,0,0,3,253,0,0,1,84,3,253,0,0,127,255,130,253,0,2,255,255,246,253,0,11,255,255,254,253,0,31,253,0,191,253,0,63,240,0,15,253,0,127,208,0,11,253,0,127,192,0,3,253,0,191,192,0,3,253,0,255,128,0,2,253,0,255,64,0,2,253,0,255,64,0,2,253,0,255,64,0,2,253,0,255,128,0,2,253,0,191,128,0,3,253,0,127,192,0,3,253,0,63,208,0,7,253,0,63,240,0,15,253,0,31,254,1,191,253,0,11,255,255,254,253,0,2,255,255,241,253,0,0,127,255,128,253,0,0,1,80,0,0,0,
  // 0x0128  Ĩ
  40,1,16,37,148,14,255,0,0,164,0,25,11,255,64,61,31,255,249,252,63,175,255,248,61,1,255,240,120,0,26,64,0,0,0,0,0,0,0,0,6,170,170,144,7,255,255,224,7,255,255,224,0,191,254,64,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,31,248,0,7,255,255,208,7,255,255,224,7,255,255,224,
  // 0x0129  ĩ
  41,1,15,30,120,11,254,0,1,144,0,104,31,254,0,188,63,255,230,248,191,191,255,240,248,7,255,208,240,0,106,0,0,0,0,0,0,0,0,0,0,26,144,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,
  // 0x0168  Ũ
  104,1,23,38,228,30,3,255,0,1,164,0,40,0,0,15,255,64,124,0,0,63,255,246,252,0,0,63,175,255,244,0,0,188,2,255,224,0,0,180,0,42,64,0,0,0,0,0,0,0,0,0,0,0,0,0,42,64,0,0,2,168,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,63,208,0,0,11,248,63,224,0,0,15,244,47,244,0,0,47,240,15,253,0,0,191,224,7,255,229,91,255,192,2,255,255,255,255,0,0,127,255,255,248,0,0,11,255,255,144,0,0,0,21,80,0,0,
  // 0x0169  ũ
  105,1,19,31,155,25,3,255,0,25,0,2,128,0,255,224,11,192,3,255,254,111,128,7,250,255,255,0,15,192,47,253,0,11,64,2,160,0,0,0,0,0,0,0,0,0,0,0,106,0,0,2,164,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,11,252,255,64,0,11,252,255,128,0,15,252,191,192,0,31,252,191,208,0,63,252,63,248,6,255,252,47,255,255,247,252,15,255,255,211,252,1,255,254,2,252,0,5,80,0,0,
  // 0x01a0  Ơ
  160,1,31,32,0,32,2,255,0,0,0,0,0,0,5,84,0,0,0,0,0,0,15,248,0,0,27,255,228,0,15,244,0,7,255,255,255,64,15,240,0,47,255,255,255,240,47,224,0,191,255,239,255,252,127,192,2,255,224,0,31,255,255,64,7,255,0,0,2,255,253,0,15,252,0,0,0,255,224,0,31,248,0,0,0,63,224,0,47,240,0,0,0,47,240,0,63,224,0,0,0,31,244,0,63,208,0,0,0,15,248,0,127,192,0,0,0,15,252,0,127,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,127,192,0,0,0,15,252,0,127,208,0,0,0,15,248,0,63,224,0,0,0,15,244,0,63,240,0,0,0,47,240,0,31,244,0,0,0,63,240,0,15,252,0,0,0,127,208,0,11,254,0,0,1,255,192,0,3,255,192,0,11,255,64,0,0,255,254,85,191,254,0,0,0,63,255,255,255,244,0,0,0,11,255,255,255,208,0,0,0,0,191,255,249,0,0,0,0,0,1,85,0,0,0,0,
  // 0x01a1  ơ
  161,1,25,26,182,25,2,255,0,0,0,0,0,255,128,0,0,0,0,0,255,128,0,0,0,0,0,255,0,0,6,255,144,1,255,0,0,127,255,254,3,253,0,2,255,255,255,223,252,0,11,255,234,255,255,240,0,31,248,0,31,255,128,0,63,240,0,7,252,0,0,63,192,0,3,254,0,0,127,192,0,2,255,0,0,191,128,0,1,255,0,0,255,128,0,0,255,0,0,255,64,0,0,255,64,0,255,64,0,0,255,64,0,255,64,0,0,255,0,0,255,128,0,0,255,0,0,191,192,0,1,255,0,0,127,192,0,2,254,0,0,63,224,0,3,253,0,0,31,244,0,15,252,0,0,15,254,64,127,244,0,0,3,255,255,255,208,0,0,0,255,255,255,64,0,0,0,31,255,248,0,0,0,0,0,85,0,0,0,0,
  // 0x01af  Ư
  175,1,31,32,0,32,3,255,0,0,0,0,0,0,5,80,0,0,0,0,0,0,15,248,42,64,0,0,2,168,15,244,127,192,0,0,7,252,31,240,127,192,0,0,7,252,47,224,127,192,0,0,7,252,127,192,127,192,0,0,7,255,255,64,127,192,0,0,7,255,252,0,127,192,0,0,7,255,144,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,63,192,0,0,11,248,0,0,63,224,0,0,15,244,0,0,47,244,0,0,47,240,0,0,15,253,0,0,191,224,0,0,7,255,229,91,255,192,0,0,2,255,255,255,255,0,0,0,0,127,255,255,252,0,0,0,0,7,255,255,144,0,0,0,0,0,5,80,0,0,0,0,
  // 0x01b0  ư
  176,1,27,26,182,28,3,255,0,0,0,0,0,15,244,0,0,0,0,0,31,244,0,0,0,0,0,31,240,106,0,0,2,164,47,224,255,64,0,7,252,63,192,255,64,0,7,253,255,128,255,64,0,7,255,254,0,255,64,0,7,255,244,0,255,64,0,7,253,64,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,11,252,0,0,255,64,0,11,252,0,0,255,128,0,15,252,0,0,191,192,0,31,252,0,0,191,208,0,63,252,0,0,63,248,6,255,252,0,0,47,255,255,247,252,0,0,15,255,255,211,252,0,0,1,255,254,2,252,0,0,0,5,80,0,0,0,0,
  // 0x0303  ̃
  3,3,15,6,24,0,236,24,1,144,0,40,15,254,0,188,63,255,230,248,127,175,255,244,188,2,255,224,180,0,42,0,
  // 0x0309  ̉
  9,3,8,10,20,0,241,23,255,144,255,248,171,253,0,254,0,253,2,252,47,244,47,128,31,0,5,0,
  // 0x0323  ̣
  35,3,5,6,12,0,241,248,5,0,63,192,127,192,127,192,63,192,5,0,
  // 0x0340  ̀
  64,3,9,7,21,0,249,24,170,128,0,127,224,0,47,240,0,11,252,0,1,254,0,0,127,64,0,31,128,
  // 0x0341  ́
  65,3,9,7,21,0,254,24,0,170,128,2,255,64,3,254,0,15,248,0,47,224,0,127,64,0,189,0,0,
  // 0x1ea0  Ạ
  160,30,26,37,3,26,0,248,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,0,3,252,0,0,0,0,0,3,253,0,0,0,0,0,3,253,0,0,0,0,0,3,252,0,0,0,0,0,0,80,0,0,0,
  // 0x1ea1  ạ
  161,30,18,30,150,23,2,248,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,0,0,0,0,0,0,0,16,0,0,0,2,253,0,0,0,3,255,0,0,0,3,255,0,0,0,2,253,0,0,0,0,16,0,0,
  // 0x1ea2  Ả
  162,30,26,40,24,26,0,0,0,0,31,249,0,0,0,0,0,31,255,64,0,0,0,0,26,191,192,0,0,0,0,0,15,208,0,0,0,0,0,15,192,0,0,0,0,0,127,192,0,0,0,0,3,255,0,0,0,0,0,3,244,0,0,0,0,0,2,240,0,0,0,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x1ea3  ả
  163,30,18,34,170,23,2,255,0,11,253,0,0,0,15,255,192,0,0,10,191,224,0,0,0,11,224,0,0,0,11,224,0,0,0,47,208,0,0,1,255,64,0,0,1,248,0,0,0,1,244,0,0,0,0,80,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x1ea4  Ấ
  164,30,26,39,17,26,0,0,0,0,0,0,0,255,0,0,0,0,0,1,252,0,0,0,2,169,3,244,0,0,0,15,255,15,192,0,0,0,47,255,197,0,0,0,0,191,95,224,0,0,0,1,252,3,244,0,0,0,3,224,0,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x1ea5  ấ
  165,30,21,34,204,23,2,255,0,0,0,0,21,64,0,0,0,0,255,0,0,0,0,1,253,0,0,3,255,3,244,0,0,15,255,139,192,0,0,47,239,208,0,0,0,191,71,244,0,0,1,252,1,252,0,0,2,224,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,0,6,255,255,253,0,0,11,255,255,255,64,0,7,254,91,255,192,0,2,128,0,127,208,0,0,0,0,63,224,0,0,0,0,47,224,0,0,0,0,31,240,0,0,0,0,31,240,0,0,27,255,255,240,0,3,255,255,255,240,0,31,255,250,191,240,0,127,244,0,31,240,0,255,192,0,31,240,0,255,64,0,47,240,0,255,0,0,47,240,0,255,64,0,63,240,0,255,128,0,255,240,0,255,208,7,255,240,0,127,255,255,223,240,0,47,255,255,75,240,0,7,255,248,7,240,0,0,21,64,0,0,0,
  // 0x1ea6  Ầ
  166,30,26,39,17,26,0,0,15,240,0,0,0,0,0,3,244,0,0,0,0,0,1,252,2,168,0,0,0,0,63,15,255,0,0,0,0,5,47,255,192,0,0,0,0,191,95,224,0,0,0,1,252,3,244,0,0,0,3,224,0,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x1ea7  ầ
  167,30,20,34,170,23,0,255,85,0,0,0,0,127,128,0,0,0,31,192,0,0,0,7,240,63,240,0,0,248,255,252,0,0,2,254,254,0,0,7,244,127,64,0,31,192,15,208,0,46,0,2,224,0,0,0,0,0,0,0,0,0,0,0,1,191,249,0,0,111,255,255,208,0,191,255,255,244,0,127,229,191,252,0,40,0,7,253,0,0,0,3,254,0,0,0,2,254,0,0,0,1,255,0,0,0,1,255,0,1,191,255,255,0,63,255,255,255,1,255,255,171,255,7,255,64,1,255,15,252,0,1,255,15,244,0,2,255,15,240,0,2,255,15,244,0,3,255,15,248,0,15,255,15,253,0,127,255,7,255,255,253,255,2,255,255,244,191,0,127,255,128,127,0,1,84,0,0,
  // 0x1ea8  Ẩ
  168,30,26,42,38,26,0,0,0,0,0,0,5,0,0,0,0,0,0,47,240,0,0,0,0,0,22,248,0,0,0,0,0,0,188,0,0,0,0,0,1,248,0,0,0,6,168,15,224,0,0,0,15,255,11,64,0,0,0,63,255,133,0,0,0,0,191,95,208,0,0,0,2,252,7,244,0,0,0,7,224,0,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x1ea9  ẩ
  169,30,20,36,180,23,2,255,0,0,0,15,160,0,0,0,15,252,0,0,0,0,125,0,0,0,0,61,0,0,0,2,252,0,3,255,3,208,0,11,255,195,192,0,47,239,224,0,0,127,71,244,0,1,252,0,253,0,2,224,0,46,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x1eaa  Ẫ
  170,30,26,42,38,26,0,0,0,0,127,64,30,0,0,0,1,255,248,125,0,0,0,3,251,255,252,0,0,0,3,192,127,240,0,0,0,1,64,1,64,0,0,0,0,1,84,0,0,0,0,0,11,255,0,0,0,0,0,31,255,128,0,0,0,0,127,159,208,0,0,0,1,253,3,244,0,0,0,3,224,0,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x1eab  ẫ
  171,30,18,37,185,23,2,255,0,5,0,5,0,0,127,224,31,0,0,255,254,190,0,2,245,191,252,0,3,192,11,224,0,0,0,0,0,0,0,2,254,0,0,0,11,255,128,0,0,31,255,208,0,0,127,71,240,0,1,252,1,252,0,2,224,0,46,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x1eac  Ậ
  172,30,26,46,66,26,0,248,0,0,6,169,0,0,0,0,0,15,255,0,0,0,0,0,63,255,192,0,0,0,0,191,175,240,0,0,0,1,254,11,248,0,0,0,7,244,1,254,0,0,0,15,128,0,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,0,3,252,0,0,0,0,0,3,254,0,0,0,0,0,3,254,0,0,0,0,0,3,252,0,0,0,0,0,0,80,0,0,0,
  // 0x1ead  ậ
  173,30,18,39,195,23,2,248,0,2,170,0,0,0,11,255,128,0,0,31,255,208,0,0,63,223,244,0,0,255,3,252,0,3,252,0,255,0,11,224,0,47,128,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,0,0,0,0,0,0,0,80,0,0,0,3,252,0,0,0,3,253,0,0,0,3,253,0,0,0,3,252,0,0,0,0,80,0,0,
  // 0x1eae  Ắ
  174,30,26,41,31,26,0,0,0,0,0,5,80,0,0,0,0,0,31,208,0,0,0,0,0,63,64,0,0,0,0,0,190,0,0,0,0,1,65,244,20,0,0,0,3,208,0,124,0,0,0,2,244,0,252,0,0,0,1,255,175,244,0,0,0,0,191,255,224,0,0,0,0,31,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x1eaf  ắ
  175,30,18,35,175,23,2,255,0,0,11,224,0,0,0,31,208,0,0,0,63,64,0,0,0,189,0,0,2,224,164,46,0,2,240,0,61,0,1,253,1,252,0,0,191,255,244,0,0,63,255,224,0,0,6,169,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x1eb0  Ằ
  176,30,26,41,31,26,0,0,0,0,85,0,0,0,0,0,0,127,64,0,0,0,0,0,31,192,0,0,0,0,0,7,224,0,0,0,0,1,65,244,20,0,0,0,3,208,0,124,0,0,0,3,240,0,252,0,0,0,1,255,175,244,0,0,0,0,191,255,224,0,0,0,0,31,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x1eb1  ằ
  177,30,18,35,175,23,2,255,0,127,64,0,0,0,47,192,0,0,0,11,224,0,0,0,2,240,0,0,2,224,164,62,0,2,240,0,125,0,1,253,1,252,0,0,255,255,244,0,0,63,255,224,0,0,6,169,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x1eb2  Ẳ
  178,30,26,42,38,26,0,0,0,0,6,160,0,0,0,0,0,7,253,0,0,0,0,0,0,47,0,0,0,0,0,0,31,0,0,0,0,0,0,253,0,0,0,0,1,65,240,20,0,0,0,3,208,64,124,0,0,0,3,240,0,252,0,0,0,1,255,175,244,0,0,0,0,191,255,224,0,0,0,0,31,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x1eb3  ẳ
  179,30,18,36,180,23,2,255,0,3,253,0,0,0,2,191,0,0,0,0,15,64,0,0,0,31,0,0,0,0,253,0,0,2,224,240,46,0,2,240,0,62,0,0,253,1,252,0,0,191,255,248,0,0,47,255,224,0,0,2,170,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x1eb4  Ẵ
  180,30,26,42,38,26,0,0,0,0,127,64,30,0,0,0,1,255,248,125,0,0,0,3,251,255,252,0,0,0,3,192,127,244,0,0,0,1,64,1,64,0,0,0,0,0,0,0,0,0,0,3,208,0,124,0,0,0,3,240,0,252,0,0,0,1,255,175,244,0,0,0,0,191,255,224,0,0,0,0,31,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x1eb5  ẵ
  181,30,18,37,185,23,2,255,0,4,0,5,0,0,127,224,15,0,0,255,254,190,0,2,245,191,252,0,3,192,11,240,0,0,0,0,0,0,1,144,0,25,0,2,240,0,61,0,1,249,1,252,0,0,255,255,248,0,0,63,255,224,0,0,6,186,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x1eb6  Ặ
  182,30,26,45,59,26,0,248,0,7,192,0,63,0,0,0,3,224,0,126,0,0,0,3,254,171,252,0,0,0,0,255,255,244,0,0,0,0,127,255,208,0,0,0,0,6,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,0,3,252,0,0,0,0,0,3,254,0,0,0,0,0,3,254,0,0,0,0,0,3,252,0,0,0,0,0,0,80,0,0,0,
  // 0x1eb7  ặ
  183,30,18,38,190,23,2,248,3,224,0,31,0,2,240,0,63,0,1,254,170,254,0,0,255,255,252,0,0,47,255,240,0,0,2,170,64,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,0,0,0,0,0,0,0,80,0,0,0,3,248,0,0,0,11,252,0,0,0,11,252,0,0,0,3,248,0,0,0,0,80,0,0,
  // 0x1eb8  Ẹ
  184,30,16,37,148,22,4,248,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,1,64,0,0,15,240,0,0,31,244,0,0,31,244,0,0,15,240,0,0,1,64,0,
  // 0x1eb9  ẹ
  185,30,19,30,150,23,2,248,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,0,0,0,0,0,0,0,20,0,0,0,0,255,0,0,0,1,255,64,0,0,1,255,64,0,0,0,255,0,0,0,0,20,0,0,
  // 0x1eba  Ẻ
  186,30,16,40,160,22,4,0,0,63,228,0,0,127,254,0,0,42,255,0,0,0,63,64,0,0,63,64,0,1,255,0,0,15,252,0,0,11,208,0,0,11,192,0,0,1,64,0,0,0,0,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x1ebb  ẻ
  187,30,19,34,170,23,2,255,0,3,254,64,0,0,3,255,224,0,0,2,175,244,0,0,0,3,248,0,0,0,3,244,0,0,0,11,240,0,0,0,191,208,0,0,0,190,0,0,0,0,124,0,0,0,0,20,0,0,0,0,0,0,0,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x1ebc  Ẽ
  188,30,16,37,148,22,4,0,0,164,0,25,11,255,64,61,31,255,249,252,63,175,255,248,61,1,255,240,120,0,26,64,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x1ebd  ẽ
  189,30,19,31,155,23,2,255,0,25,0,2,128,1,255,224,11,192,3,255,254,111,128,11,251,255,255,0,15,192,63,253,0,15,64,6,160,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x1ebe  Ế
  190,30,19,39,195,22,4,0,0,0,0,3,252,0,0,0,11,240,0,26,160,31,192,0,63,252,63,0,0,255,254,20,0,2,253,127,64,0,11,240,31,208,0,31,128,3,240,0,0,0,0,0,0,0,0,0,0,0,170,170,170,169,0,255,255,255,255,0,255,255,255,255,0,255,255,255,255,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,234,170,168,0,255,255,255,252,0,255,255,255,252,0,255,255,255,252,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,234,170,170,0,255,255,255,255,0,255,255,255,255,0,255,255,255,255,0,
  // 0x1ebf  ế
  191,30,21,34,204,23,2,255,0,0,0,0,21,64,0,0,0,0,127,64,0,0,0,0,254,0,0,2,255,66,248,0,0,11,255,199,208,0,0,31,255,240,0,0,0,63,131,248,0,0,0,253,0,254,0,0,1,224,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,0,127,255,252,0,0,2,255,255,255,64,0,11,255,86,255,192,0,31,244,0,63,224,0,63,224,0,15,240,0,63,192,0,11,244,0,127,192,0,7,248,0,191,128,0,7,252,0,255,255,255,255,252,0,255,255,255,255,252,0,255,255,255,255,252,0,255,128,0,0,0,0,255,128,0,0,0,0,191,192,0,0,0,0,127,192,0,0,0,0,63,224,0,0,0,0,47,248,0,0,16,0,15,255,64,22,240,0,3,255,255,255,240,0,0,255,255,255,240,0,0,27,255,255,64,0,0,0,21,64,0,0,
  // 0x1ec0  Ề
  192,30,19,39,195,22,1,0,255,0,0,0,0,63,64,0,0,0,31,192,42,128,0,3,240,255,240,0,0,82,255,248,0,0,11,245,254,0,0,31,192,63,64,0,62,0,11,192,0,0,0,0,0,0,0,0,0,0,2,170,170,170,164,3,255,255,255,252,3,255,255,255,252,3,255,255,255,252,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,255,170,170,160,3,255,255,255,240,3,255,255,255,240,3,255,255,255,240,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,255,170,170,168,3,255,255,255,252,3,255,255,255,252,3,255,255,255,252,
  // 0x1ec1  ề
  193,30,20,34,170,23,1,255,85,0,0,0,0,255,0,0,0,0,63,128,0,0,0,15,208,191,208,0,2,241,255,240,0,0,3,255,252,0,0,15,224,255,0,0,63,64,47,128,0,120,0,7,192,0,0,0,0,0,0,0,0,0,0,0,1,191,228,0,0,31,255,255,0,0,191,255,255,208,2,255,213,191,240,7,253,0,15,248,15,248,0,3,252,15,240,0,2,253,31,240,0,1,254,47,224,0,1,255,63,255,255,255,255,63,255,255,255,255,63,255,255,255,255,63,224,0,0,0,63,224,0,0,0,47,240,0,0,0,31,240,0,0,0,15,248,0,0,0,11,254,0,0,4,3,255,208,5,188,0,255,255,255,252,0,63,255,255,252,0,6,255,255,208,0,0,5,80,0,
  // 0x1ec2  Ể
  194,30,18,42,210,22,4,0,0,0,0,84,0,0,0,0,191,192,0,0,0,91,224,0,0,0,2,240,0,0,0,7,224,0,26,160,63,128,0,63,252,61,0,0,255,254,20,0,2,252,127,64,0,11,240,31,208,0,31,128,3,240,0,0,0,0,0,0,0,0,0,0,0,170,170,170,169,0,255,255,255,255,0,255,255,255,255,0,255,255,255,255,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,234,170,168,0,255,255,255,252,0,255,255,255,252,0,255,255,255,252,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,234,170,170,0,255,255,255,255,0,255,255,255,255,0,255,255,255,255,0,
  // 0x1ec3  ể
  195,30,20,36,180,23,2,255,0,0,0,11,224,0,0,0,15,252,0,0,0,0,62,0,0,0,0,61,0,0,0,2,252,0,3,255,3,224,0,11,255,195,192,0,31,239,224,0,0,127,71,248,0,0,253,0,253,0,2,224,0,46,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x1ec4  Ễ
  196,30,16,42,168,22,4,0,1,253,0,180,11,255,209,240,15,239,255,224,31,1,255,192,20,0,21,0,0,5,80,0,0,63,248,0,0,191,253,0,2,253,191,64,7,240,31,192,31,128,2,240,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x1ec5  ễ
  197,30,19,37,185,23,2,255,0,5,0,5,0,0,127,224,15,0,0,255,255,191,0,1,245,191,252,0,2,208,11,244,0,0,0,0,0,0,0,2,255,0,0,0,7,255,128,0,0,15,255,224,0,0,63,135,244,0,0,253,0,253,0,2,224,0,31,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x1ec6  Ệ
  198,30,16,46,184,22,4,248,0,10,164,0,0,63,253,0,0,191,255,0,2,255,191,192,7,248,31,240,31,224,7,248,47,64,0,189,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,1,64,0,0,15,240,0,0,31,244,0,0,31,244,0,0,15,240,0,0,1,64,0,
  // 0x1ec7  ệ
  199,30,19,39,195,23,2,248,0,2,170,0,0,0,11,255,128,0,0,31,255,208,0,0,63,223,244,0,0,255,3,252,0,3,252,0,255,0,7,224,0,31,128,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,0,0,0,0,0,0,0,20,0,0,0,0,255,0,0,0,1,255,64,0,0,1,255,64,0,0,0,255,0,0,0,0,20,0,0,
  // 0x1ec8  Ỉ
  200,30,12,40,120,14,1,0,1,169,0,3,255,208,3,255,244,0,3,248,0,2,248,0,3,244,0,127,240,0,127,64,0,125,0,0,61,0,0,0,0,106,170,169,127,255,254,127,255,254,11,255,228,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,1,255,128,127,255,253,127,255,254,127,255,254,
  // 0x1ec9  ỉ
  201,30,8,33,66,11,2,0,127,224,191,253,106,255,0,127,0,127,1,254,15,248,15,192,15,192,5,64,0,0,26,144,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,
  // 0x1eca  Ị
  202,30,12,37,111,14,1,248,106,170,169,127,255,254,127,255,254,11,255,228,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,1,255,128,127,255,253,127,255,254,127,255,254,0,0,0,0,0,0,0,20,0,0,255,0,1,255,64,1,255,64,0,255,0,0,20,0,
  // 0x1ecb  ị
  203,30,5,38,76,11,3,248,42,0,191,128,255,192,255,128,127,0,0,0,0,0,0,0,106,64,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,0,0,0,0,4,0,191,64,255,192,255,192,127,64,4,0,
  // 0x1ecc  Ọ
  204,30,27,37,3,31,2,248,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,0,0,1,254,0,0,0,0,0,2,255,0,0,0,0,0,2,255,0,0,0,0,0,1,254,0,0,0,0,0,0,20,0,0,0,
  // 0x1ecd  ọ
  205,30,21,30,180,24,2,248,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,0,0,255,0,0,0,0,1,255,64,0,0,0,1,255,64,0,0,0,0,255,0,0,0,0,0,20,0,0,0,
  // 0x1ece  Ỏ
  206,30,27,41,31,31,2,255,0,0,1,165,0,0,0,0,0,7,255,192,0,0,0,0,7,255,240,0,0,0,0,0,7,244,0,0,0,0,0,3,244,0,0,0,0,0,7,240,0,0,0,0,0,191,208,0,0,0,0,0,254,64,0,0,0,0,0,188,0,0,0,0,0,0,124,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x1ecf  ỏ
  207,30,21,34,204,24,2,255,0,2,255,64,0,0,0,3,255,240,0,0,0,2,175,248,0,0,0,0,2,252,0,0,0,0,2,248,0,0,0,0,11,244,0,0,0,0,127,224,0,0,0,0,126,0,0,0,0,0,61,0,0,0,0,0,20,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x1ed0  Ố
  208,30,27,40,24,31,2,255,0,0,0,0,0,127,128,0,0,0,0,0,255,0,0,0,1,170,2,252,0,0,0,7,255,131,224,0,0,0,15,255,209,64,0,0,0,63,203,240,0,0,0,0,254,1,252,0,0,0,2,244,0,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x1ed1  ố
  209,30,21,34,204,24,2,255,0,0,0,0,21,64,0,0,0,0,63,192,0,0,0,0,191,0,0,1,255,129,252,0,0,3,255,211,224,0,0,15,255,240,0,0,0,63,194,252,0,0,0,190,0,191,0,0,0,244,0,31,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x1ed2  Ồ
  210,30,27,40,24,31,2,255,7,248,0,0,0,0,0,1,252,0,0,0,0,0,0,127,1,170,0,0,0,0,31,135,255,128,0,0,0,1,79,255,208,0,0,0,0,63,203,244,0,0,0,0,191,1,252,0,0,0,2,248,0,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x1ed3  ồ
  211,30,22,34,204,24,1,255,85,0,0,0,0,0,191,64,0,0,0,0,47,192,0,0,0,0,11,224,127,224,0,0,1,244,255,244,0,0,0,3,255,253,0,0,0,11,240,191,0,0,0,47,128,31,192,0,0,61,0,2,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,191,228,0,0,0,31,255,255,128,0,0,191,255,255,240,0,2,255,250,191,252,0,7,255,0,11,254,0,15,252,0,2,255,0,15,244,0,0,255,128,31,240,0,0,191,192,47,224,0,0,127,192,63,224,0,0,63,192,63,208,0,0,63,208,63,208,0,0,63,208,63,224,0,0,63,192,63,224,0,0,63,192,47,240,0,0,127,192,31,240,0,0,191,128,15,248,0,0,255,64,7,253,0,3,255,0,3,255,144,31,253,0,0,255,255,255,244,0,0,63,255,255,208,0,0,7,255,254,0,0,0,0,21,64,0,0,
  // 0x1ed4  Ổ
  212,30,27,43,45,31,2,255,0,0,0,0,5,64,0,0,0,0,0,15,248,0,0,0,0,0,5,189,0,0,0,0,0,0,62,0,0,0,0,0,0,125,0,0,0,1,170,3,244,0,0,0,7,255,131,192,0,0,0,15,255,209,64,0,0,0,63,203,240,0,0,0,0,254,1,252,0,0,0,2,244,0,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x1ed5  ổ
  213,30,21,36,216,24,2,255,0,0,0,7,228,0,0,0,0,7,254,0,0,0,0,0,47,0,0,0,0,0,31,0,0,0,0,1,190,0,0,1,255,130,244,0,0,3,255,209,224,0,0,15,255,240,0,0,0,63,194,252,0,0,0,190,0,191,0,0,0,244,0,31,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x1ed6  Ỗ
  214,30,27,43,45,31,2,255,0,0,47,144,15,0,0,0,0,191,253,47,0,0,0,1,250,255,253,0,0,0,2,224,31,248,0,0,0,1,64,1,64,0,0,0,0,0,85,0,0,0,0,0,3,255,64,0,0,0,0,15,255,208,0,0,0,0,47,219,240,0,0,0,0,190,1,252,0,0,0,2,244,0,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x1ed7  ỗ
  215,30,21,37,222,24,2,255,0,1,0,1,64,0,0,47,244,11,128,0,0,127,255,175,64,0,0,248,127,254,0,0,0,240,7,248,0,0,0,0,0,0,0,0,0,0,255,64,0,0,0,3,255,192,0,0,0,11,255,240,0,0,0,47,194,252,0,0,0,190,0,127,0,0,0,244,0,11,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x1ed8  Ộ
  216,30,27,46,66,31,2,248,0,0,1,170,0,0,0,0,0,7,255,192,0,0,0,0,15,255,224,0,0,0,0,63,223,244,0,0,0,0,255,67,253,0,0,0,2,252,0,191,64,0,0,7,224,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,0,0,1,254,0,0,0,0,0,2,255,0,0,0,0,0,2,255,0,0,0,0,0,1,254,0,0,0,0,0,0,20,0,0,0,
  // 0x1ed9  ộ
  217,30,21,39,234,24,2,248,0,0,170,64,0,0,0,3,255,208,0,0,0,11,255,240,0,0,0,31,251,252,0,0,0,127,129,255,0,0,1,254,0,127,128,0,2,244,0,11,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,0,0,255,0,0,0,0,1,255,64,0,0,0,1,255,64,0,0,0,0,255,0,0,0,0,0,20,0,0,0,
  // 0x1eda  Ớ
  218,30,31,39,56,32,2,255,0,0,0,2,170,0,0,0,0,0,0,11,253,0,0,0,0,0,0,31,244,0,0,0,0,0,0,63,208,0,0,0,0,0,0,191,64,0,0,0,0,0,1,253,0,0,0,0,0,0,2,224,0,0,0,0,0,0,0,0,0,0,5,84,0,0,0,0,0,0,15,248,0,0,27,255,228,0,15,244,0,7,255,255,255,64,15,240,0,47,255,255,255,240,47,224,0,191,255,239,255,252,127,192,2,255,224,0,31,255,255,64,7,255,0,0,2,255,253,0,15,252,0,0,0,255,224,0,31,248,0,0,0,63,224,0,47,240,0,0,0,47,240,0,63,224,0,0,0,31,244,0,63,208,0,0,0,15,248,0,127,192,0,0,0,15,252,0,127,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,127,192,0,0,0,15,252,0,127,208,0,0,0,15,248,0,63,224,0,0,0,15,244,0,63,240,0,0,0,47,240,0,31,244,0,0,0,63,240,0,15,252,0,0,0,127,208,0,11,254,0,0,1,255,192,0,3,255,192,0,11,255,64,0,0,255,254,85,191,254,0,0,0,63,255,255,255,244,0,0,0,11,255,255,255,208,0,0,0,0,191,255,249,0,0,0,0,0,1,85,0,0,0,0,
  // 0x1edb  ớ
  219,30,25,32,224,25,2,255,0,0,1,170,64,0,0,0,0,3,255,0,0,0,0,0,15,252,0,0,0,0,0,47,240,0,0,0,0,0,63,192,0,0,0,0,0,254,0,0,0,0,0,1,248,0,0,255,128,0,0,0,0,0,255,128,0,0,0,0,0,255,0,0,6,255,144,1,255,0,0,127,255,254,3,253,0,2,255,255,255,223,252,0,11,255,234,255,255,240,0,31,248,0,31,255,128,0,63,240,0,7,252,0,0,63,192,0,3,254,0,0,127,192,0,2,255,0,0,191,128,0,1,255,0,0,255,128,0,0,255,0,0,255,64,0,0,255,64,0,255,64,0,0,255,64,0,255,64,0,0,255,0,0,255,128,0,0,255,0,0,191,192,0,1,255,0,0,127,192,0,2,254,0,0,63,224,0,3,253,0,0,31,244,0,15,252,0,0,15,254,64,127,244,0,0,3,255,255,255,208,0,0,0,255,255,255,64,0,0,0,31,255,248,0,0,0,0,0,85,0,0,0,0,
  // 0x1edc  Ờ
  220,30,31,39,56,32,2,255,0,0,170,128,0,0,0,0,0,0,191,208,0,0,0,0,0,0,47,240,0,0,0,0,0,0,11,248,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,31,128,0,0,0,0,0,0,0,0,0,5,84,0,0,0,0,0,0,15,248,0,0,27,255,228,0,15,244,0,7,255,255,255,64,15,240,0,47,255,255,255,240,47,224,0,191,255,239,255,252,127,192,2,255,224,0,31,255,255,64,7,255,0,0,2,255,253,0,15,252,0,0,0,255,224,0,31,248,0,0,0,63,224,0,47,240,0,0,0,47,240,0,63,224,0,0,0,31,244,0,63,208,0,0,0,15,248,0,127,192,0,0,0,15,252,0,127,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,127,192,0,0,0,15,252,0,127,208,0,0,0,15,248,0,63,224,0,0,0,15,244,0,63,240,0,0,0,47,240,0,31,244,0,0,0,63,240,0,15,252,0,0,0,127,208,0,11,254,0,0,1,255,192,0,3,255,192,0,11,255,64,0,0,255,254,85,191,254,0,0,0,63,255,255,255,244,0,0,0,11,255,255,255,208,0,0,0,0,191,255,249,0,0,0,0,0,1,85,0,0,0,0,
  // 0x1edd  ờ
  221,30,25,32,224,25,2,255,0,106,128,0,0,0,0,0,63,240,0,0,0,0,0,31,244,0,0,0,0,0,7,252,0,0,0,0,0,1,255,0,0,0,0,0,0,63,128,0,0,0,0,0,11,192,0,255,128,0,0,0,0,0,255,128,0,0,0,0,0,255,0,0,6,255,144,1,255,0,0,127,255,254,3,253,0,2,255,255,255,223,252,0,11,255,234,255,255,240,0,31,248,0,31,255,128,0,63,240,0,7,252,0,0,63,192,0,3,254,0,0,127,192,0,2,255,0,0,191,128,0,1,255,0,0,255,128,0,0,255,0,0,255,64,0,0,255,64,0,255,64,0,0,255,64,0,255,64,0,0,255,0,0,255,128,0,0,255,0,0,191,192,0,1,255,0,0,127,192,0,2,254,0,0,63,224,0,3,253,0,0,31,244,0,15,252,0,0,15,254,64,127,244,0,0,3,255,255,255,208,0,0,0,255,255,255,64,0,0,0,31,255,248,0,0,0,0,0,85,0,0,0,0,
  // 0x1ede  Ở
  222,30,31,41,72,32,2,255,0,0,11,254,0,0,0,0,0,0,11,255,192,0,0,0,0,0,10,175,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,31,224,0,0,0,0,0,0,255,128,0,0,0,0,0,0,252,0,0,0,0,0,0,0,248,0,0,0,0,0,0,0,80,0,0,5,84,0,0,0,0,0,0,15,248,0,0,27,255,228,0,15,244,0,7,255,255,255,64,15,240,0,47,255,255,255,240,47,224,0,191,255,239,255,252,127,192,2,255,224,0,31,255,255,64,7,255,0,0,2,255,253,0,15,252,0,0,0,255,224,0,31,248,0,0,0,63,224,0,47,240,0,0,0,47,240,0,63,224,0,0,0,31,244,0,63,208,0,0,0,15,248,0,127,192,0,0,0,15,252,0,127,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,127,192,0,0,0,15,252,0,127,208,0,0,0,15,248,0,63,224,0,0,0,15,244,0,63,240,0,0,0,47,240,0,31,244,0,0,0,63,240,0,15,252,0,0,0,127,208,0,11,254,0,0,1,255,192,0,3,255,192,0,11,255,64,0,0,255,254,85,191,254,0,0,0,63,255,255,255,244,0,0,0,11,255,255,255,208,0,0,0,0,191,255,249,0,0,0,0,0,1,85,0,0,0,0,
  // 0x1edf  ở
  223,30,25,34,238,25,2,255,0,3,254,64,0,0,0,0,3,255,224,0,0,0,0,2,175,240,0,0,0,0,0,3,244,0,0,0,0,0,3,244,0,0,0,0,0,11,240,0,0,0,0,0,191,208,0,0,0,0,0,189,0,0,0,0,0,0,188,0,0,255,128,0,0,20,0,0,255,128,0,0,0,0,0,255,0,0,6,255,144,1,255,0,0,127,255,254,3,253,0,2,255,255,255,223,252,0,11,255,234,255,255,240,0,31,248,0,31,255,128,0,63,240,0,7,252,0,0,63,192,0,3,254,0,0,127,192,0,2,255,0,0,191,128,0,1,255,0,0,255,128,0,0,255,0,0,255,64,0,0,255,64,0,255,64,0,0,255,64,0,255,64,0,0,255,0,0,255,128,0,0,255,0,0,191,192,0,1,255,0,0,127,192,0,2,254,0,0,63,224,0,3,253,0,0,31,244,0,15,252,0,0,15,254,64,127,244,0,0,3,255,255,255,208,0,0,0,255,255,255,64,0,0,0,31,255,248,0,0,0,0,0,85,0,0,0,0,
  // 0x1ee0  Ỡ
  224,30,31,38,48,32,2,255,0,0,26,0,2,128,0,0,0,0,255,240,11,192,0,0,0,3,255,254,111,192,0,0,0,7,250,255,255,64,0,0,0,11,192,47,254,0,0,0,0,11,64,2,164,0,0,0,0,0,0,0,0,0,5,84,0,0,0,0,0,0,15,248,0,0,27,255,228,0,15,244,0,7,255,255,255,64,15,240,0,47,255,255,255,240,47,224,0,191,255,239,255,252,127,192,2,255,224,0,31,255,255,64,7,255,0,0,2,255,253,0,15,252,0,0,0,255,224,0,31,248,0,0,0,63,224,0,47,240,0,0,0,47,240,0,63,224,0,0,0,31,244,0,63,208,0,0,0,15,248,0,127,192,0,0,0,15,252,0,127,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,127,192,0,0,0,15,252,0,127,208,0,0,0,15,248,0,63,224,0,0,0,15,244,0,63,240,0,0,0,47,240,0,31,244,0,0,0,63,240,0,15,252,0,0,0,127,208,0,11,254,0,0,1,255,192,0,3,255,192,0,11,255,64,0,0,255,254,85,191,254,0,0,0,63,255,255,255,244,0,0,0,11,255,255,255,208,0,0,0,0,191,255,249,0,0,0,0,0,1,85,0,0,0,0,
  // 0x1ee1  ỡ
  225,30,25,31,217,25,2,255,0,10,64,1,144,0,0,0,191,244,3,224,0,0,1,255,255,159,208,0,0,3,250,255,255,192,0,0,3,208,31,255,0,0,0,7,128,1,164,0,255,128,0,0,0,0,0,255,128,0,0,0,0,0,255,0,0,6,255,144,1,255,0,0,127,255,254,3,253,0,2,255,255,255,223,252,0,11,255,234,255,255,240,0,31,248,0,31,255,128,0,63,240,0,7,252,0,0,63,192,0,3,254,0,0,127,192,0,2,255,0,0,191,128,0,1,255,0,0,255,128,0,0,255,0,0,255,64,0,0,255,64,0,255,64,0,0,255,64,0,255,64,0,0,255,0,0,255,128,0,0,255,0,0,191,192,0,1,255,0,0,127,192,0,2,254,0,0,63,224,0,3,253,0,0,31,244,0,15,252,0,0,15,254,64,127,244,0,0,3,255,255,255,208,0,0,0,255,255,255,64,0,0,0,31,255,248,0,0,0,0,0,85,0,0,0,0,
  // 0x1ee2  Ợ
  226,30,31,39,56,32,2,248,0,0,0,0,0,0,5,84,0,0,0,0,0,0,15,248,0,0,27,255,228,0,15,244,0,7,255,255,255,64,15,240,0,47,255,255,255,240,47,224,0,191,255,239,255,252,127,192,2,255,224,0,31,255,255,64,7,255,0,0,2,255,253,0,15,252,0,0,0,255,224,0,31,248,0,0,0,63,224,0,47,240,0,0,0,47,240,0,63,224,0,0,0,31,244,0,63,208,0,0,0,15,248,0,127,192,0,0,0,15,252,0,127,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,191,192,0,0,0,11,252,0,127,192,0,0,0,15,252,0,127,208,0,0,0,15,248,0,63,224,0,0,0,15,244,0,63,240,0,0,0,47,240,0,31,244,0,0,0,63,240,0,15,252,0,0,0,127,208,0,11,254,0,0,1,255,192,0,3,255,192,0,11,255,64,0,0,255,254,85,191,254,0,0,0,63,255,255,255,244,0,0,0,11,255,255,255,208,0,0,0,0,191,255,249,0,0,0,0,0,1,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,0,0,0,1,254,0,0,0,0,0,0,2,255,0,0,0,0,0,0,2,255,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,20,0,0,0,0,
  // 0x1ee3  ợ
  227,30,25,33,231,25,2,248,0,0,0,0,0,255,128,0,0,0,0,0,255,128,0,0,0,0,0,255,0,0,6,255,144,1,255,0,0,127,255,254,3,253,0,2,255,255,255,223,252,0,11,255,234,255,255,240,0,31,248,0,31,255,128,0,63,240,0,7,252,0,0,63,192,0,3,254,0,0,127,192,0,2,255,0,0,191,128,0,1,255,0,0,255,128,0,0,255,0,0,255,64,0,0,255,64,0,255,64,0,0,255,64,0,255,64,0,0,255,0,0,255,128,0,0,255,0,0,191,192,0,1,255,0,0,127,192,0,2,254,0,0,63,224,0,3,253,0,0,31,244,0,15,252,0,0,15,254,64,127,244,0,0,3,255,255,255,208,0,0,0,255,255,255,64,0,0,0,31,255,248,0,0,0,0,0,85,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,0,0,0,255,0,0,0,0,0,0,255,64,0,0,0,0,0,255,64,0,0,0,0,0,255,0,0,0,0,0,0,20,0,0,0,0,
  // 0x1ee4  Ụ
  228,30,23,37,222,30,3,248,42,64,0,0,2,168,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,63,208,0,0,11,248,63,224,0,0,15,244,47,244,0,0,47,240,15,253,0,0,191,224,7,255,229,91,255,192,2,255,255,255,255,0,0,127,255,255,248,0,0,11,255,255,144,0,0,0,21,80,0,0,0,0,0,0,0,0,0,0,1,64,0,0,0,0,31,224,0,0,0,0,47,240,0,0,0,0,47,240,0,0,0,0,31,224,0,0,0,0,1,64,0,0,
  // 0x1ee5  ụ
  229,30,19,30,150,25,3,248,106,0,0,2,164,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,11,252,255,64,0,11,252,255,128,0,15,252,191,192,0,31,252,191,208,0,63,252,63,248,6,255,252,47,255,255,247,252,15,255,255,211,252,1,255,254,2,252,0,5,80,0,0,0,0,0,0,0,0,0,80,0,0,0,3,252,0,0,0,7,253,0,0,0,7,253,0,0,0,3,252,0,0,0,0,80,0,0,
  // 0x1ee6  Ủ
  230,30,23,41,246,30,3,255,0,0,26,64,0,0,0,0,127,252,0,0,0,0,127,255,0,0,0,0,0,191,0,0,0,0,0,63,0,0,0,0,0,191,0,0,0,0,11,253,0,0,0,0,15,224,0,0,0,0,15,192,0,0,0,0,11,128,0,0,0,0,0,0,0,0,42,64,0,0,2,168,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,63,208,0,0,11,248,63,224,0,0,15,244,47,244,0,0,47,240,15,253,0,0,191,224,7,255,229,91,255,192,2,255,255,255,255,0,0,127,255,255,248,0,0,11,255,255,144,0,0,0,21,80,0,0,
  // 0x1ee7  ủ
  231,30,19,34,170,25,3,255,0,11,254,0,0,0,15,255,192,0,0,10,175,224,0,0,0,11,240,0,0,0,7,240,0,0,0,31,224,0,0,1,255,128,0,0,0,252,0,0,0,0,248,0,0,0,0,80,0,0,0,0,0,0,0,106,0,0,2,164,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,11,252,255,64,0,11,252,255,128,0,15,252,191,192,0,31,252,191,208,0,63,252,63,248,6,255,252,47,255,255,247,252,15,255,255,211,252,1,255,254,2,252,0,5,80,0,0,
  // 0x1ee8  Ứ
  232,30,31,39,56,32,3,255,0,0,0,42,160,0,0,0,0,0,0,191,208,0,0,0,0,0,0,255,64,0,0,0,0,0,3,253,0,0,0,0,0,0,11,244,0,0,0,0,0,0,31,208,0,0,0,0,0,0,47,64,0,0,0,0,0,0,0,0,0,0,5,80,0,0,0,0,0,0,15,248,42,64,0,0,2,168,15,244,127,192,0,0,7,252,31,240,127,192,0,0,7,252,47,224,127,192,0,0,7,252,127,192,127,192,0,0,7,255,255,64,127,192,0,0,7,255,252,0,127,192,0,0,7,255,144,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,63,192,0,0,11,248,0,0,63,224,0,0,15,244,0,0,47,244,0,0,47,240,0,0,15,253,0,0,191,224,0,0,7,255,229,91,255,192,0,0,2,255,255,255,255,0,0,0,0,127,255,255,252,0,0,0,0,7,255,255,144,0,0,0,0,0,5,80,0,0,0,0,
  // 0x1ee9  ứ
  233,30,27,32,224,28,3,255,0,0,2,170,0,0,0,0,0,15,252,0,0,0,0,0,31,244,0,0,0,0,0,63,208,0,0,0,0,0,255,64,0,0,0,0,2,252,0,0,0,0,0,3,224,0,0,15,244,0,0,0,0,0,31,244,0,0,0,0,0,31,240,106,0,0,2,164,47,224,255,64,0,7,252,63,192,255,64,0,7,253,255,128,255,64,0,7,255,254,0,255,64,0,7,255,244,0,255,64,0,7,253,64,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,11,252,0,0,255,64,0,11,252,0,0,255,128,0,15,252,0,0,191,192,0,31,252,0,0,191,208,0,63,252,0,0,63,248,6,255,252,0,0,47,255,255,247,252,0,0,15,255,255,211,252,0,0,1,255,254,2,252,0,0,0,5,80,0,0,0,0,
  // 0x1eea  Ừ
  234,30,31,39,56,32,3,255,0,10,168,0,0,0,0,0,0,11,253,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,47,208,0,0,0,0,0,0,11,240,0,0,0,0,0,0,1,248,0,0,0,0,0,0,0,0,0,0,5,80,0,0,0,0,0,0,15,248,42,64,0,0,2,168,15,244,127,192,0,0,7,252,31,240,127,192,0,0,7,252,47,224,127,192,0,0,7,252,127,192,127,192,0,0,7,255,255,64,127,192,0,0,7,255,252,0,127,192,0,0,7,255,144,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,63,192,0,0,11,248,0,0,63,224,0,0,15,244,0,0,47,244,0,0,47,240,0,0,15,253,0,0,191,224,0,0,7,255,229,91,255,192,0,0,2,255,255,255,255,0,0,0,0,127,255,255,252,0,0,0,0,7,255,255,144,0,0,0,0,0,5,80,0,0,0,0,
  // 0x1eeb  ừ
  235,30,27,32,224,28,3,255,0,170,64,0,0,0,0,0,191,208,0,0,0,0,0,63,240,0,0,0,0,0,15,248,0,0,0,0,0,3,253,0,0,0,0,0,0,191,0,0,0,0,0,0,47,64,0,15,244,0,0,0,0,0,31,244,0,0,0,0,0,31,240,106,0,0,2,164,47,224,255,64,0,7,252,63,192,255,64,0,7,253,255,128,255,64,0,7,255,254,0,255,64,0,7,255,244,0,255,64,0,7,253,64,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,11,252,0,0,255,64,0,11,252,0,0,255,128,0,15,252,0,0,191,192,0,31,252,0,0,191,208,0,63,252,0,0,63,248,6,255,252,0,0,47,255,255,247,252,0,0,15,255,255,211,252,0,0,1,255,254,2,252,0,0,0,5,80,0,0,0,0,
  // 0x1eec  Ử
  236,30,31,41,72,32,3,255,0,0,26,80,0,0,0,0,0,0,127,253,0,0,0,0,0,0,127,255,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,127,0,0,0,0,0,0,7,254,0,0,0,0,0,0,11,244,0,0,0,0,0,0,11,192,0,0,0,0,0,0,7,192,0,0,5,80,0,0,0,0,0,0,15,248,42,64,0,0,2,168,15,244,127,192,0,0,7,252,31,240,127,192,0,0,7,252,47,224,127,192,0,0,7,252,127,192,127,192,0,0,7,255,255,64,127,192,0,0,7,255,252,0,127,192,0,0,7,255,144,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,63,192,0,0,11,248,0,0,63,224,0,0,15,244,0,0,47,244,0,0,47,240,0,0,15,253,0,0,191,224,0,0,7,255,229,91,255,192,0,0,2,255,255,255,255,0,0,0,0,127,255,255,252,0,0,0,0,7,255,255,144,0,0,0,0,0,5,80,0,0,0,0,
  // 0x1eed  ử
  237,30,27,34,238,28,3,255,0,7,254,0,0,0,0,0,11,255,208,0,0,0,0,6,175,240,0,0,0,0,0,7,240,0,0,0,0,0,7,240,0,0,0,0,0,31,224,0,0,0,0,0,255,128,0,0,0,0,0,252,0,0,0,0,0,0,248,0,0,15,244,0,0,80,0,0,31,244,0,0,0,0,0,31,240,106,0,0,2,164,47,224,255,64,0,7,252,63,192,255,64,0,7,253,255,128,255,64,0,7,255,254,0,255,64,0,7,255,244,0,255,64,0,7,253,64,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,11,252,0,0,255,64,0,11,252,0,0,255,128,0,15,252,0,0,191,192,0,31,252,0,0,191,208,0,63,252,0,0,63,248,6,255,252,0,0,47,255,255,247,252,0,0,15,255,255,211,252,0,0,1,255,254,2,252,0,0,0,5,80,0,0,0,0,
  // 0x1eee  Ữ
  238,30,31,38,48,32,3,255,0,1,164,0,40,0,0,0,0,15,255,64,124,0,0,0,0,63,255,246,252,0,0,0,0,127,175,255,244,0,0,0,0,188,2,255,224,0,0,0,0,180,0,42,64,0,0,0,0,0,0,0,0,0,5,80,0,0,0,0,0,0,15,248,42,64,0,0,2,168,15,244,127,192,0,0,7,252,31,240,127,192,0,0,7,252,47,224,127,192,0,0,7,252,127,192,127,192,0,0,7,255,255,64,127,192,0,0,7,255,252,0,127,192,0,0,7,255,144,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,63,192,0,0,11,248,0,0,63,224,0,0,15,244,0,0,47,244,0,0,47,240,0,0,15,253,0,0,191,224,0,0,7,255,229,91,255,192,0,0,2,255,255,255,255,0,0,0,0,127,255,255,252,0,0,0,0,7,255,255,144,0,0,0,0,0,5,80,0,0,0,0,
  // 0x1eef  ữ
  239,30,27,31,217,28,3,255,0,25,0,2,128,0,0,0,255,224,11,192,0,0,3,255,254,111,128,0,0,7,250,255,255,0,0,0,15,192,47,253,0,0,0,11,64,2,160,0,15,244,0,0,0,0,0,31,244,0,0,0,0,0,31,240,106,0,0,2,164,47,224,255,64,0,7,252,63,192,255,64,0,7,253,255,128,255,64,0,7,255,254,0,255,64,0,7,255,244,0,255,64,0,7,253,64,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,11,252,0,0,255,64,0,11,252,0,0,255,128,0,15,252,0,0,191,192,0,31,252,0,0,191,208,0,63,252,0,0,63,248,6,255,252,0,0,47,255,255,247,252,0,0,15,255,255,211,252,0,0,1,255,254,2,252,0,0,0,5,80,0,0,0,0,
  // 0x1ef0  Ự
  240,30,31,39,56,32,3,248,0,0,0,0,0,0,5,80,0,0,0,0,0,0,15,248,42,64,0,0,2,168,15,244,127,192,0,0,7,252,31,240,127,192,0,0,7,252,47,224,127,192,0,0,7,252,127,192,127,192,0,0,7,255,255,64,127,192,0,0,7,255,252,0,127,192,0,0,7,255,144,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,127,192,0,0,7,252,0,0,63,192,0,0,11,248,0,0,63,224,0,0,15,244,0,0,47,244,0,0,47,240,0,0,15,253,0,0,191,224,0,0,7,255,229,91,255,192,0,0,2,255,255,255,255,0,0,0,0,127,255,255,252,0,0,0,0,7,255,255,144,0,0,0,0,0,5,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,64,0,0,0,0,0,0,15,240,0,0,0,0,0,0,47,240,0,0,0,0,0,0,47,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,1,64,0,0,0,0,
  // 0x1ef1  ự
  241,30,27,33,231,28,3,248,0,0,0,0,0,15,244,0,0,0,0,0,31,244,0,0,0,0,0,31,240,106,0,0,2,164,47,224,255,64,0,7,252,63,192,255,64,0,7,253,255,128,255,64,0,7,255,254,0,255,64,0,7,255,244,0,255,64,0,7,253,64,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,7,252,0,0,255,64,0,11,252,0,0,255,64,0,11,252,0,0,255,128,0,15,252,0,0,191,192,0,31,252,0,0,191,208,0,63,252,0,0,63,248,6,255,252,0,0,47,255,255,247,252,0,0,15,255,255,211,252,0,0,1,255,254,2,252,0,0,0,5,80,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,0,3,252,0,0,0,0,0,7,253,0,0,0,0,0,7,253,0,0,0,0,0,3,252,0,0,0,0,0,0,80,0,0,0,0,
  // 0x1ef2  Ỳ
  242,30,23,38,228,23,0,0,0,10,168,0,0,0,0,11,253,0,0,0,0,2,255,0,0,0,0,0,191,192,0,0,0,0,47,208,0,0,0,0,7,244,0,0,0,0,1,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,0,6,168,127,192,0,0,15,248,63,240,0,0,31,240,31,244,0,0,63,224,15,252,0,0,127,192,7,253,0,0,255,128,2,255,0,1,255,0,0,255,64,3,253,0,0,191,192,11,252,0,0,63,208,15,244,0,0,47,240,47,240,0,0,15,244,63,208,0,0,7,252,191,128,0,0,3,254,255,0,0,0,1,255,254,0,0,0,0,255,252,0,0,0,0,127,248,0,0,0,0,63,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,
  // 0x1ef3  ỳ
  243,30,21,41,246,21,0,246,0,42,160,0,0,0,0,47,244,0,0,0,0,11,252,0,0,0,0,2,254,0,0,0,0,0,191,64,0,0,0,0,47,192,0,0,0,0,7,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,0,106,128,191,192,0,0,255,128,63,208,0,0,255,64,47,224,0,2,255,0,31,240,0,3,254,0,15,244,0,3,252,0,11,252,0,11,252,0,3,252,0,15,244,0,2,254,0,31,240,0,1,255,0,47,224,0,0,255,64,63,208,0,0,191,128,127,192,0,0,63,192,191,128,0,0,47,208,255,0,0,0,31,225,255,0,0,0,15,242,253,0,0,0,11,243,252,0,0,0,3,251,248,0,0,0,2,255,244,0,0,0,1,255,240,0,0,0,0,255,224,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,255,64,0,0,0,1,255,0,0,0,0,3,254,0,0,0,0,7,252,0,0,0,0,47,248,0,0,0,127,255,240,0,0,0,127,255,192,0,0,0,127,254,0,0,0,0,26,144,0,0,0,0,
  // 0x1ef4  Ỵ
  244,30,23,37,222,23,0,248,106,64,0,0,6,168,127,192,0,0,15,248,63,240,0,0,31,240,31,244,0,0,63,224,15,252,0,0,127,192,7,253,0,0,255,128,2,255,0,1,255,0,0,255,64,3,253,0,0,191,192,11,252,0,0,63,208,15,244,0,0,47,240,47,240,0,0,15,244,63,208,0,0,7,252,191,128,0,0,3,254,255,0,0,0,1,255,254,0,0,0,0,255,252,0,0,0,0,127,248,0,0,0,0,63,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,31,224,0,0,0,0,63,240,0,0,0,0,63,240,0,0,0,0,31,224,0,0,0,0,1,0,0,0,
  // 0x1ef5  ỵ
  245,30,21,32,192,21,0,246,106,64,0,0,106,128,191,192,0,0,255,128,63,208,0,0,255,64,47,224,0,2,255,0,31,240,0,3,254,0,15,244,0,3,252,0,11,252,0,11,252,0,3,252,0,15,244,0,2,254,0,31,240,0,1,255,0,47,224,0,0,255,64,63,208,0,0,191,128,127,192,0,0,63,192,191,128,0,0,47,208,255,0,0,0,31,225,255,0,0,0,15,242,253,0,0,0,11,243,252,0,0,0,3,251,248,0,0,0,2,255,244,0,0,0,1,255,240,0,0,0,0,255,224,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,255,64,0,0,0,1,255,1,64,0,0,3,254,11,240,0,0,7,252,15,248,0,0,47,248,15,248,0,127,255,240,11,240,0,127,255,192,1,64,0,127,254,0,0,0,0,26,144,0,0,0,0,
  // 0x1ef6  Ỷ
  246,30,23,40,240,23,0,0,0,0,26,64,0,0,0,0,191,252,0,0,0,0,191,255,0,0,0,0,0,191,0,0,0,0,0,63,0,0,0,0,0,191,0,0,0,0,11,253,0,0,0,0,15,224,0,0,0,0,15,192,0,0,0,0,11,128,0,0,0,0,0,0,0,0,106,64,0,0,6,168,127,192,0,0,15,248,63,240,0,0,31,240,31,244,0,0,63,224,15,252,0,0,127,192,7,253,0,0,255,128,2,255,0,1,255,0,0,255,64,3,253,0,0,191,192,11,252,0,0,63,208,15,244,0,0,47,240,47,240,0,0,15,244,63,208,0,0,7,252,191,128,0,0,3,254,255,0,0,0,1,255,254,0,0,0,0,255,252,0,0,0,0,127,248,0,0,0,0,63,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,
  // 0x1ef7  ỷ
  247,30,21,43,2,21,0,246,0,2,255,128,0,0,0,2,255,240,0,0,0,2,171,252,0,0,0,0,1,252,0,0,0,0,1,252,0,0,0,0,7,248,0,0,0,0,63,224,0,0,0,0,63,0,0,0,0,0,62,0,0,0,0,0,20,0,0,0,0,0,0,0,0,0,106,64,0,0,106,128,191,192,0,0,255,128,63,208,0,0,255,64,47,224,0,2,255,0,31,240,0,3,254,0,15,244,0,3,252,0,11,252,0,11,252,0,3,252,0,15,244,0,2,254,0,31,240,0,1,255,0,47,224,0,0,255,64,63,208,0,0,191,128,127,192,0,0,63,192,191,128,0,0,47,208,255,0,0,0,31,225,255,0,0,0,15,242,253,0,0,0,11,243,252,0,0,0,3,251,248,0,0,0,2,255,244,0,0,0,1,255,240,0,0,0,0,255,224,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,255,64,0,0,0,1,255,0,0,0,0,3,254,0,0,0,0,7,252,0,0,0,0,47,248,0,0,0,127,255,240,0,0,0,127,255,192,0,0,0,127,254,0,0,0,0,26,144,0,0,0,0,
  // 0x1ef8  Ỹ
  248,30,23,37,222,23,0,0,0,1,144,0,40,0,0,15,254,0,188,0,0,63,255,230,248,0,0,127,175,255,244,0,0,188,2,255,224,0,0,180,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,0,6,168,127,192,0,0,15,248,63,240,0,0,31,240,31,244,0,0,63,224,15,252,0,0,127,192,7,253,0,0,255,128,2,255,0,1,255,0,0,255,64,3,253,0,0,191,192,11,252,0,0,63,208,15,244,0,0,47,240,47,240,0,0,15,244,63,208,0,0,7,252,191,128,0,0,3,254,255,0,0,0,1,255,254,0,0,0,0,255,252,0,0,0,0,127,248,0,0,0,0,63,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,
  // 0x1ef9  ỹ
  249,30,21,40,240,21,0,246,0,6,64,0,160,0,0,127,248,2,240,0,0,255,255,155,224,0,2,254,255,255,192,0,3,240,15,255,64,0,3,208,1,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,0,106,128,191,192,0,0,255,128,63,208,0,0,255,64,47,224,0,2,255,0,31,240,0,3,254,0,15,244,0,3,252,0,11,252,0,11,252,0,3,252,0,15,244,0,2,254,0,31,240,0,1,255,0,47,224,0,0,255,64,63,208,0,0,191,128,127,192,0,0,63,192,191,128,0,0,47,208,255,0,0,0,31,225,255,0,0,0,15,242,253,0,0,0,11,243,252,0,0,0,3,251,248,0,0,0,2,255,244,0,0,0,1,255,240,0,0,0,0,255,224,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,255,64,0,0,0,1,255,0,0,0,0,3,254,0,0,0,0,7,252,0,0,0,0,47,248,0,0,0,127,255,240,0,0,0,127,255,192,0,0,0,127,254,0,0,0,0,26,144,0,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
