/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Simplified Chinese 40pt, capital 'A' height: 29px, width: 100%, range: 0x201c-0xff1a, glyphs: 373
extern const uint8_t NotoSans_Medium_Simplified_Chinese_29[41075] = {
  162,29,28,32,26,255,38,246, // unifont_t
  // 0x201c  “
  28,32,15,11,44,15,0,18,0,168,0,164,2,248,2,248,3,248,3,244,7,244,11,240,15,240,15,240,15,240,31,224,31,224,47,224,63,208,63,208,63,208,127,192,127,192,191,192,0,0,0,0,
  // 0x201d  ”
  29,32,15,11,44,15,0,18,6,164,6,164,11,252,15,248,15,248,15,244,15,240,15,240,31,240,31,240,31,208,47,208,47,192,63,192,63,128,63,128,63,64,127,0,127,0,191,0,0,0,0,0,
  // 0x22bf  ⊿
  191,34,31,32,0,40,4,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,184,0,0,0,0,0,0,2,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,47,248,0,0,0,0,0,0,191,248,0,0,0,0,0,2,255,248,0,0,0,0,0,11,255,248,0,0,0,0,0,47,242,248,0,0,0,0,0,191,194,248,0,0,0,0,2,255,2,248,0,0,0,0,11,252,2,248,0,0,0,0,47,240,2,248,0,0,0,0,191,192,2,248,0,0,0,1,255,0,2,248,0,0,0,7,252,0,2,248,0,0,0,31,240,0,2,248,0,0,0,127,192,0,2,248,0,0,1,255,64,0,2,248,0,0,7,253,0,0,2,248,0,0,31,244,0,0,2,248,0,0,127,208,0,0,2,248,0,1,255,64,0,0,2,248,0,7,253,0,0,0,2,248,0,31,244,0,0,0,2,248,0,127,208,0,0,0,2,248,1,255,64,0,0,0,2,248,3,254,85,85,85,85,87,248,15,255,255,255,255,255,255,248,63,255,255,255,255,255,255,248,255,255,255,255,255,255,255,248,
  // 0x4e00  一
  0,78,37,4,40,40,2,13,255,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,255,64,
  // 0x4e09  三
  9,78,34,31,23,40,3,255,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,128,0,0,127,255,255,255,255,255,192,0,0,127,255,255,255,255,255,192,0,0,127,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,160,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x4e0a  上
  10,78,36,35,59,40,2,254,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,255,255,255,255,192,0,0,0,7,255,255,255,255,192,0,0,0,7,255,255,255,255,192,0,0,0,7,254,170,170,170,128,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,254,
  // 0x4e0b  下
  11,78,36,35,59,40,2,252,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,254,128,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,3,255,255,64,0,0,0,0,0,3,255,255,240,0,0,0,0,0,3,253,255,254,0,0,0,0,0,3,252,47,255,208,0,0,0,0,3,252,3,255,252,0,0,0,0,3,252,0,127,255,64,0,0,0,3,252,0,11,255,208,0,0,0,3,252,0,1,255,192,0,0,0,3,252,0,0,63,0,0,0,0,3,252,0,0,9,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,2,168,0,0,0,0,
  // 0x4e0d  不
  13,78,36,35,59,40,2,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,0,0,47,240,0,0,0,0,0,0,0,127,224,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,2,255,64,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,31,255,0,0,0,0,0,0,0,63,255,10,0,0,0,0,0,0,255,255,47,192,0,0,0,0,3,255,255,191,244,0,0,0,0,15,254,255,47,254,0,0,0,0,63,248,255,7,255,192,0,0,1,255,240,255,0,255,244,0,0,11,255,192,255,0,47,253,0,0,47,254,0,255,0,11,255,128,1,255,248,0,255,0,1,255,240,15,255,208,0,255,0,0,127,252,191,255,0,0,255,0,0,15,255,191,248,0,0,255,0,0,3,255,63,208,0,0,255,0,0,0,248,14,0,0,0,255,0,0,0,32,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,
  // 0x4e13  专
  19,78,35,38,86,40,2,252,0,0,0,11,160,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,31,224,0,0,0,0,0,170,170,191,234,170,170,170,0,1,255,255,255,255,255,255,255,64,1,255,255,255,255,255,255,255,64,1,255,255,255,255,255,255,255,64,0,0,0,191,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,2,253,0,0,0,0,0,106,170,171,254,170,170,170,170,168,191,255,255,255,255,255,255,255,252,191,255,255,255,255,255,255,255,252,191,255,255,255,255,255,255,255,252,0,0,15,240,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,255,255,255,255,252,0,0,0,191,255,255,255,255,255,64,0,0,255,255,255,255,255,254,0,0,0,85,85,85,85,127,252,0,0,0,0,0,0,0,127,240,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,7,255,0,0,0,0,4,0,0,31,252,0,0,0,0,31,208,0,127,240,0,0,0,0,63,255,129,255,192,0,0,0,0,127,255,255,255,0,0,0,0,0,1,255,255,252,0,0,0,0,0,0,11,255,255,64,0,0,0,0,0,0,111,255,244,0,0,0,0,0,0,2,255,255,64,0,0,0,0,0,0,31,255,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,24,0,0,
  // 0x4e1d  丝
  29,78,36,36,68,40,2,254,0,0,20,0,0,0,8,0,0,0,0,63,64,0,0,31,128,0,0,0,191,64,0,0,63,192,0,0,0,255,0,0,0,127,128,0,0,1,254,0,0,0,191,0,0,0,3,252,0,0,0,254,0,0,0,7,248,0,0,2,252,0,0,0,15,240,1,0,3,248,0,0,0,31,224,11,208,11,240,1,224,0,63,192,15,240,31,224,3,252,0,127,64,63,224,63,192,11,248,0,255,0,127,192,127,64,31,240,2,252,0,255,0,254,0,63,208,7,244,2,254,3,252,0,191,128,47,255,255,252,15,255,255,255,0,31,255,255,244,15,255,255,252,0,15,255,255,224,11,255,255,244,0,10,149,127,192,7,149,47,224,0,0,0,255,0,0,0,63,192,0,0,2,253,0,0,0,255,0,0,0,11,248,0,0,3,253,0,0,0,31,224,0,0,11,244,0,0,0,127,192,0,0,47,208,0,0,0,255,0,0,0,191,128,0,0,7,255,255,255,195,255,255,255,248,15,255,255,255,207,255,255,255,248,11,255,255,255,199,255,255,255,248,7,255,169,80,3,255,170,84,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,85,85,85,85,85,85,
  // 0x4e2a  个
  42,78,38,37,114,40,1,252,0,0,0,0,191,192,0,0,0,0,0,0,0,1,255,240,0,0,0,0,0,0,0,3,255,248,0,0,0,0,0,0,0,11,255,253,0,0,0,0,0,0,0,47,246,255,0,0,0,0,0,0,0,191,224,255,192,0,0,0,0,0,1,255,192,63,240,0,0,0,0,0,7,255,0,15,253,0,0,0,0,0,31,252,0,7,255,64,0,0,0,0,191,240,0,0,255,208,0,0,0,2,255,192,0,0,63,248,0,0,0,15,255,0,0,0,15,255,0,0,0,63,252,0,0,0,3,255,208,0,2,255,224,0,63,128,0,191,253,0,31,255,64,0,63,192,0,31,255,192,191,253,0,0,63,192,0,3,255,240,191,224,0,0,63,192,0,0,191,208,47,64,0,0,63,192,0,0,15,128,8,0,0,0,63,192,0,0,1,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,42,128,0,0,0,0,
  // 0x4e2d  中
  45,78,32,38,48,40,4,252,0,0,0,15,224,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,170,170,170,175,250,170,170,170,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,175,250,170,170,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,191,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,224,0,0,0,
  // 0x4e3a  为
  58,78,34,38,86,40,2,252,0,0,0,10,160,0,0,0,0,0,5,0,15,240,0,0,0,0,0,127,64,15,240,0,0,0,0,0,127,192,15,240,0,0,0,0,0,47,240,15,240,0,0,0,0,0,15,244,15,240,0,0,0,0,0,7,252,15,240,0,0,0,0,0,2,253,15,224,0,0,0,0,0,0,208,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,47,255,255,255,255,255,255,255,240,47,255,255,255,255,255,255,255,240,47,255,255,255,255,255,255,255,240,42,170,170,191,250,170,170,175,240,0,0,0,47,192,0,0,15,240,0,0,0,63,192,0,0,15,240,0,0,0,63,192,0,0,15,240,0,0,0,127,128,0,0,15,240,0,0,0,191,64,128,0,15,240,0,0,0,255,11,224,0,15,224,0,0,1,255,15,244,0,15,224,0,0,2,254,3,252,0,31,224,0,0,3,252,2,255,0,31,224,0,0,11,252,0,255,128,31,208,0,0,15,244,0,63,192,31,208,0,0,47,240,0,47,224,47,208,0,0,127,208,0,15,208,47,208,0,0,255,192,0,5,0,47,192,0,3,255,0,0,0,0,63,192,0,11,253,0,0,0,0,63,192,0,47,248,0,0,0,0,63,192,0,191,240,0,0,0,0,127,192,2,255,192,0,0,0,0,191,128,15,255,0,0,0,0,1,255,64,127,252,0,0,0,191,255,255,0,47,224,0,0,0,63,255,254,0,11,128,0,0,0,63,255,248,0,0,0,0,0,0,26,250,64,0,
  // 0x4e3b  主
  59,78,36,37,77,40,2,253,0,0,0,2,0,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,63,248,0,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,2,255,192,0,0,0,0,0,0,0,191,240,0,0,0,0,0,0,0,47,248,0,0,0,0,0,0,0,11,224,0,0,0,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,10,170,170,170,255,170,170,170,160,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,170,170,170,255,170,170,170,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,106,170,170,170,170,170,170,170,170,
  // 0x4e49  义
  73,78,36,37,77,40,2,253,0,0,0,0,144,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,3,252,0,0,36,0,0,0,0,1,253,0,0,63,192,0,25,0,0,255,0,0,191,128,0,255,0,0,191,64,0,255,64,0,191,0,0,63,128,0,255,0,0,127,128,0,63,192,2,254,0,0,63,192,0,31,208,3,252,0,0,31,208,0,13,0,11,248,0,0,15,240,0,0,0,15,240,0,0,11,248,0,0,0,47,224,0,0,3,252,0,0,0,63,192,0,0,1,254,0,0,0,191,128,0,0,0,255,64,0,0,255,0,0,0,0,127,192,0,3,254,0,0,0,0,63,240,0,11,252,0,0,0,0,15,244,0,15,244,0,0,0,0,7,253,0,63,224,0,0,0,0,2,255,0,255,192,0,0,0,0,0,255,195,255,0,0,0,0,0,0,63,251,253,0,0,0,0,0,0,31,255,244,0,0,0,0,0,0,7,255,224,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,31,255,248,0,0,0,0,0,0,127,255,255,0,0,0,0,0,3,255,215,255,208,0,0,0,0,47,255,0,255,252,0,0,0,2,255,248,0,63,255,128,0,0,47,255,208,0,7,255,248,0,6,255,254,0,0,0,191,255,208,191,255,224,0,0,0,31,255,255,255,254,0,0,0,0,1,255,254,127,208,0,0,0,0,0,27,252,40,0,0,0,0,0,0,0,112,
  // 0x4e4b  之
  75,78,37,38,124,40,1,252,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,3,255,255,255,255,255,255,255,224,0,3,255,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,255,248,0,2,170,170,170,170,170,170,191,240,0,0,0,0,0,0,0,0,127,208,0,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,0,11,253,0,0,0,0,0,0,0,0,47,244,0,0,0,0,0,0,0,0,127,224,0,0,0,0,0,0,0,1,255,128,0,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,0,63,240,0,0,0,0,2,224,0,0,255,192,0,0,0,0,3,252,0,7,255,0,0,0,0,0,11,248,0,31,252,0,0,0,0,0,15,244,0,127,240,0,0,0,0,0,31,248,2,255,192,0,0,0,0,0,63,252,15,255,0,0,0,0,0,0,127,255,127,248,0,0,0,0,0,0,255,255,255,224,0,0,0,0,0,1,255,63,255,64,0,0,0,0,0,3,253,15,255,64,0,0,0,0,0,11,252,3,255,249,0,0,0,0,0,31,244,0,255,255,255,170,170,170,128,63,240,0,31,255,255,255,255,255,192,127,192,0,1,191,255,255,255,255,128,15,128,0,0,5,175,255,255,255,0,1,0,0,0,0,0,0,0,0,0,
  // 0x4e86  了
  134,78,32,35,24,40,4,252,170,170,170,170,170,170,170,208,255,255,255,255,255,255,255,248,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,248,0,0,0,0,0,0,255,224,0,0,0,0,0,3,255,128,0,0,0,0,0,15,254,0,0,0,0,0,0,63,248,0,0,0,0,0,1,255,224,0,0,0,0,0,11,255,128,0,0,0,0,0,47,253,0,0,0,0,0,15,255,240,0,0,0,0,0,15,255,128,0,0,0,0,0,15,253,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,15,255,255,240,0,0,0,0,7,255,255,224,0,0,0,0,3,255,255,128,0,0,0,0,2,170,164,0,0,0,0,
  // 0x4e8c  二
  140,78,36,28,252,40,2,0,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,
  // 0x4e8e  于
  142,78,36,35,59,40,2,252,3,255,255,255,255,255,255,255,192,3,255,255,255,255,255,255,255,192,3,255,255,255,255,255,255,255,192,2,170,170,170,255,234,170,170,128,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,106,170,170,170,255,234,170,170,169,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,191,255,255,0,0,0,0,0,0,63,255,255,0,0,0,0,0,0,63,255,252,0,0,0,0,0,0,31,254,144,0,0,0,0,
  // 0x4ea4  交
  164,78,36,38,86,40,2,252,0,0,0,0,170,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,106,170,170,170,255,170,170,170,169,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,15,64,0,0,248,0,0,0,0,63,240,0,7,255,0,0,0,0,255,208,0,3,255,208,0,0,3,255,64,0,0,191,248,0,0,15,254,0,0,0,31,254,0,0,127,248,0,0,0,3,255,192,2,255,224,0,0,0,0,255,240,31,255,66,192,0,3,224,63,252,191,253,31,224,0,11,252,11,254,47,240,15,240,0,15,244,3,248,11,128,11,248,0,31,240,0,208,0,0,3,252,0,63,208,0,0,0,0,2,255,0,191,192,0,0,0,0,0,255,130,255,64,0,0,0,0,0,127,215,254,0,0,0,0,0,0,47,255,252,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,11,255,224,0,0,0,0,0,0,127,255,253,0,0,0,0,0,7,255,255,255,208,0,0,0,0,127,255,130,255,253,0,0,0,27,255,253,0,127,255,228,0,6,255,255,224,0,11,255,255,144,255,255,254,0,0,0,255,255,255,191,255,208,0,0,0,11,255,253,63,248,0,0,0,0,0,111,252,30,0,0,0,0,0,0,0,96,
  // 0x4eae  亮
  174,78,36,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,250,170,170,170,175,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,10,170,170,170,170,170,160,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,0,0,0,0,0,0,0,252,63,0,1,80,0,0,0,0,252,63,0,7,244,0,191,64,0,252,63,0,11,244,0,191,64,0,252,63,0,11,240,0,191,64,0,252,0,0,15,240,0,191,64,0,0,0,0,31,240,0,191,64,0,0,0,0,47,208,0,191,64,0,0,0,0,127,192,0,191,64,0,184,0,1,255,128,0,191,64,0,191,0,15,255,0,0,191,64,0,254,2,255,252,0,0,191,128,1,254,255,255,224,0,0,127,255,255,253,191,255,64,0,0,63,255,255,252,63,224,0,0,0,31,255,255,240,20,0,0,0,0,0,21,84,0,
  // 0x4ece  从
  206,78,38,36,104,40,1,252,0,0,63,192,0,1,254,0,0,0,0,0,63,192,0,1,254,0,0,0,0,0,63,192,0,1,254,0,0,0,0,0,63,192,0,2,253,0,0,0,0,0,63,192,0,2,253,0,0,0,0,0,63,192,0,2,253,0,0,0,0,0,127,192,0,2,253,0,0,0,0,0,127,128,0,2,253,0,0,0,0,0,127,128,0,3,253,0,0,0,0,0,191,64,0,3,254,0,0,0,0,0,191,64,0,3,255,0,0,0,0,0,255,64,0,3,255,0,0,0,0,0,255,0,0,7,255,0,0,0,0,0,255,0,0,7,255,64,0,0,0,0,255,0,0,11,255,64,0,0,0,1,255,192,0,15,255,192,0,0,0,1,255,240,0,15,255,192,0,0,0,2,255,248,0,31,255,208,0,0,0,3,255,253,0,47,255,224,0,0,0,3,255,255,64,63,223,240,0,0,0,7,252,255,192,63,203,240,0,0,0,11,248,127,224,191,135,248,0,0,0,15,244,47,240,255,67,252,0,0,0,15,240,15,250,255,3,253,0,0,0,47,240,7,243,254,1,255,0,0,0,63,208,2,199,252,0,255,64,0,0,127,192,0,15,248,0,191,192,0,0,255,128,0,63,240,0,63,224,0,1,255,64,0,191,224,0,47,248,0,3,255,0,1,255,192,0,15,253,0,11,253,0,7,255,64,0,7,255,64,47,252,0,31,254,0,0,2,255,208,127,240,0,63,248,0,0,0,255,128,31,208,0,11,224,0,0,0,63,0,3,192,0,1,192,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,
  // 0x4ee4  令
  228,78,37,38,124,40,2,252,0,0,0,1,254,0,0,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,0,15,255,208,0,0,0,0,0,0,0,47,255,244,0,0,0,0,0,0,0,191,219,252,0,0,0,0,0,0,2,255,131,255,64,0,0,0,0,0,11,254,0,255,208,0,0,0,0,0,47,252,0,63,244,0,0,0,0,0,191,240,0,15,253,0,0,0,0,2,255,192,0,3,255,128,0,0,0,15,254,0,0,0,191,244,0,0,0,127,248,0,0,0,47,254,0,0,2,255,255,255,255,255,255,255,208,0,31,255,95,255,255,255,245,255,248,0,255,252,31,255,255,255,244,63,255,64,255,224,5,85,85,85,80,11,255,0,127,64,0,0,0,0,0,1,253,0,40,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,255,255,255,255,255,255,254,0,0,2,255,255,255,255,255,255,254,0,0,2,255,255,255,255,255,255,254,0,0,1,85,85,127,213,85,85,254,0,0,0,0,0,47,192,0,0,254,0,0,0,0,0,47,192,0,0,254,0,0,0,0,0,47,192,0,0,254,0,0,0,0,0,47,192,0,0,254,0,0,0,0,0,47,192,0,0,254,0,0,0,0,0,47,192,0,0,254,0,0,0,0,0,47,192,0,0,254,0,0,0,0,0,47,192,10,170,254,0,0,0,0,0,47,192,11,255,253,0,0,0,0,0,47,192,3,255,252,0,0,0,0,0,47,192,3,255,144,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,
  // 0x4ee5  以
  229,78,38,35,94,40,1,252,0,47,192,0,0,0,0,47,144,0,0,63,192,0,0,0,0,63,208,0,0,63,192,0,0,0,0,63,192,0,0,63,192,2,208,0,0,63,192,0,0,63,192,31,240,0,0,63,192,0,0,47,192,11,252,0,0,127,192,0,0,47,192,3,254,0,0,127,128,0,0,47,192,1,255,64,0,191,64,0,0,47,192,0,191,192,0,255,64,0,0,47,208,0,63,224,0,255,0,0,0,47,208,0,31,240,0,255,0,0,0,47,208,0,15,248,1,254,0,0,0,31,208,0,7,248,2,253,0,0,0,31,208,0,3,128,3,252,0,0,0,31,208,0,0,0,7,252,0,0,0,31,208,0,0,0,11,248,0,0,0,31,208,0,0,0,15,240,0,0,0,31,224,0,0,0,47,240,0,0,0,31,224,0,0,0,63,208,0,0,0,31,224,0,0,0,127,192,0,0,0,15,224,7,192,0,255,128,0,0,0,15,224,191,192,2,255,192,0,0,0,15,251,255,208,7,255,240,0,0,0,15,255,255,128,15,255,252,0,0,0,111,255,248,0,63,251,255,0,0,7,255,255,128,0,255,210,255,128,0,127,255,244,0,3,255,128,255,224,0,63,254,64,0,31,255,0,63,248,0,63,224,0,0,191,252,0,15,253,0,29,0,0,7,255,224,0,3,255,0,0,0,0,191,255,128,0,1,255,192,0,0,7,255,252,0,0,0,191,224,0,0,2,255,224,0,0,0,63,128,0,0,0,190,0,0,0,0,14,0,0,0,0,32,0,0,0,0,0,0,
  // 0x4ef6  件
  246,78,37,38,124,40,1,252,0,0,20,0,0,1,80,0,0,0,0,0,63,128,0,3,248,0,0,0,0,0,127,64,144,3,248,0,0,0,0,0,255,0,254,3,248,0,0,0,0,1,254,1,253,3,248,0,0,0,0,2,253,2,252,3,248,0,0,0,0,7,252,3,252,3,248,0,0,0,0,15,244,3,248,3,248,0,0,0,0,31,240,7,254,171,254,170,168,0,0,63,208,11,255,255,255,255,253,0,0,191,192,15,255,255,255,255,253,0,0,255,192,31,255,255,255,255,253,0,3,255,192,63,192,3,248,0,0,0,11,255,192,127,128,3,248,0,0,0,31,255,192,255,0,3,248,0,0,0,63,255,193,254,0,3,248,0,0,0,191,239,192,188,0,3,248,0,0,0,63,111,192,24,0,3,248,0,0,0,30,47,192,0,0,3,248,0,0,0,12,47,192,0,0,3,248,0,0,0,0,47,192,170,170,171,254,170,170,128,0,47,192,255,255,255,255,255,255,192,0,47,192,255,255,255,255,255,255,192,0,47,192,255,255,255,255,255,255,192,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,31,128,0,0,3,244,0,0,0,
  // 0x4efd  份
  253,78,38,38,124,40,1,252,0,0,36,0,0,0,0,0,0,0,0,0,127,128,3,255,255,244,0,0,0,0,191,0,3,255,255,248,0,0,0,0,254,0,3,255,255,252,0,0,0,2,253,0,65,85,87,252,0,0,0,3,252,0,254,0,1,253,0,0,0,11,244,1,254,0,0,254,0,0,0,15,240,2,252,0,0,255,0,0,0,47,208,3,248,0,0,127,128,0,0,127,192,11,244,0,0,63,192,0,0,255,128,15,240,0,0,47,224,0,2,255,128,31,208,0,0,15,240,0,3,255,128,63,192,0,0,11,252,0,15,255,128,191,64,0,0,3,254,0,63,255,129,254,0,0,0,2,255,64,191,255,131,252,0,0,0,0,255,224,255,191,143,249,85,85,85,85,191,208,191,63,143,235,255,255,255,255,223,64,60,63,131,203,255,255,255,255,198,0,20,63,128,11,255,255,255,255,192,0,0,63,128,0,2,252,0,63,192,0,0,63,128,0,3,252,0,63,192,0,0,63,128,0,3,248,0,63,192,0,0,63,128,0,3,244,0,63,128,0,0,63,128,0,7,244,0,63,128,0,0,63,128,0,11,240,0,63,128,0,0,63,128,0,15,240,0,63,128,0,0,63,128,0,15,224,0,63,128,0,0,63,128,0,47,192,0,63,128,0,0,63,128,0,63,192,0,127,64,0,0,63,128,0,191,64,0,127,64,0,0,63,128,1,255,0,0,191,64,0,0,63,128,7,252,0,0,191,0,0,0,63,128,47,244,0,0,255,0,0,0,63,128,255,224,3,255,255,0,0,0,63,129,255,128,1,255,253,0,0,0,63,128,125,0,0,255,248,0,0,0,47,128,32,0,0,106,64,0,0,
  // 0x4f11  休
  17,79,38,38,124,40,1,252,0,0,4,0,0,0,0,0,0,0,0,0,15,224,0,11,240,0,0,0,0,0,47,224,0,11,240,0,0,0,0,0,63,192,0,11,240,0,0,0,0,0,127,192,0,11,240,0,0,0,0,0,255,64,0,11,240,0,0,0,0,1,255,0,0,11,240,0,0,0,0,3,253,0,0,11,240,0,0,0,0,11,252,0,0,11,240,0,0,0,0,31,244,0,0,11,240,0,0,0,0,63,241,170,170,175,250,170,170,128,0,191,241,255,255,255,255,255,255,192,1,255,241,255,255,255,255,255,255,192,7,255,241,255,255,255,255,255,255,192,31,255,240,0,0,191,255,0,0,0,127,255,240,0,0,255,255,128,0,0,255,239,240,0,2,255,255,192,0,0,127,143,240,0,3,255,255,208,0,0,63,15,240,0,7,255,251,240,0,0,28,15,240,0,15,255,247,244,0,0,0,15,240,0,47,219,243,252,0,0,0,15,240,0,63,203,241,254,0,0,0,15,240,0,191,75,240,255,0,0,0,15,240,1,255,11,240,127,192,0,0,15,240,3,253,11,240,63,224,0,0,15,240,15,248,11,240,15,244,0,0,15,240,47,240,11,240,11,252,0,0,15,240,127,208,11,240,3,255,0,0,15,242,255,128,11,240,1,255,192,0,15,251,255,0,11,240,0,191,240,0,15,251,252,0,11,240,0,47,208,0,15,242,240,0,11,240,0,15,64,0,15,240,128,0,11,240,0,1,0,0,15,240,0,0,11,240,0,0,0,0,15,240,0,0,11,240,0,0,0,0,15,240,0,0,11,240,0,0,0,0,15,240,0,0,11,240,0,0,0,0,10,160,0,0,11,240,0,0,0,
  // 0x4f20  传
  32,79,37,38,124,40,1,252,0,0,20,0,0,21,0,0,0,0,0,0,63,128,0,63,192,0,0,0,0,0,191,64,0,63,192,0,0,0,0,0,255,0,0,127,128,0,0,0,0,1,253,21,85,191,149,85,84,0,0,3,252,63,255,255,255,255,252,0,0,7,248,63,255,255,255,255,252,0,0,15,240,63,255,255,255,255,252,0,0,47,224,0,2,252,0,0,0,0,0,63,192,0,3,252,0,0,0,0,0,255,192,0,3,252,0,0,0,0,1,255,192,0,7,248,0,0,0,0,3,255,193,85,91,249,85,85,85,64,15,255,195,255,255,255,255,255,255,192,47,255,195,255,255,255,255,255,255,192,191,255,195,255,255,255,255,255,255,192,255,191,192,0,47,192,0,0,0,0,127,63,192,0,63,192,0,0,0,0,60,63,192,0,127,128,0,0,0,0,16,63,192,0,191,64,0,0,0,0,0,63,192,0,255,255,255,255,224,0,0,63,192,1,255,255,255,255,252,0,0,63,192,2,255,255,255,255,244,0,0,63,192,1,85,85,85,191,224,0,0,63,192,0,0,0,0,255,128,0,0,63,192,0,0,0,3,255,0,0,0,63,192,0,0,0,11,252,0,0,0,63,192,0,1,128,47,240,0,0,0,63,192,0,11,244,191,192,0,0,0,63,192,0,31,255,255,64,0,0,0,63,192,0,3,255,253,0,0,0,0,63,192,0,0,127,252,0,0,0,0,63,192,0,0,15,255,0,0,0,0,63,192,0,0,3,255,192,0,0,0,63,192,0,0,0,191,240,0,0,0,63,192,0,0,0,31,240,0,0,0,63,192,0,0,0,7,208,0,0,0,47,128,0,0,0,1,64,0,0,
  // 0x4f4d  位
  77,79,38,38,124,40,1,252,0,0,4,0,0,1,80,0,0,0,0,0,47,192,0,11,240,0,0,0,0,0,63,192,0,11,240,0,0,0,0,0,191,64,0,11,240,0,0,0,0,0,255,0,0,11,240,0,0,0,0,2,254,0,0,11,240,0,0,0,0,3,252,0,0,11,240,0,0,0,0,11,244,0,0,11,240,0,0,0,0,31,240,191,255,255,255,255,255,128,0,63,208,191,255,255,255,255,255,128,0,191,208,191,255,255,255,255,255,128,1,255,208,106,170,170,170,170,170,64,3,255,208,0,0,0,0,0,0,0,15,255,208,0,0,0,0,0,0,0,63,255,208,0,188,0,0,47,208,0,191,239,208,1,253,0,0,63,192,0,255,207,208,0,253,0,0,63,192,0,127,15,208,0,254,0,0,63,128,0,60,15,208,0,191,0,0,127,64,0,20,15,208,0,127,0,0,191,64,0,0,15,208,0,63,64,0,255,0,0,0,15,208,0,63,128,0,255,0,0,0,15,208,0,63,192,1,254,0,0,0,15,208,0,47,192,2,253,0,0,0,15,208,0,47,192,3,252,0,0,0,15,208,0,31,208,3,248,0,0,0,15,208,0,31,208,7,244,0,0,0,15,208,0,15,224,11,240,0,0,0,15,208,0,15,224,15,240,0,0,0,15,208,0,15,240,15,224,0,0,0,15,208,0,15,144,31,208,0,0,0,15,208,0,0,0,47,192,0,0,0,15,208,170,170,170,191,234,170,144,0,15,209,255,255,255,255,255,255,224,0,15,209,255,255,255,255,255,255,224,0,15,209,255,255,255,255,255,255,224,0,15,208,0,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,
  // 0x4f4e  低
  78,79,38,38,124,40,1,252,0,0,36,0,0,0,0,0,0,0,0,0,127,64,0,0,0,0,64,0,0,0,191,0,0,0,0,111,240,0,0,0,255,0,0,1,175,255,248,0,0,2,253,25,26,255,255,255,248,0,0,3,252,31,255,255,255,249,0,0,0,11,244,31,255,255,255,0,0,0,0,15,240,31,250,80,191,0,0,0,0,47,208,31,192,0,191,0,0,0,0,127,192,31,192,0,191,0,0,0,0,255,128,31,192,0,127,64,0,0,2,255,128,31,192,0,127,64,0,0,7,255,128,31,192,0,127,64,0,0,15,255,128,31,192,0,127,64,0,0,63,255,128,31,255,255,255,255,255,208,255,255,128,31,255,255,255,255,255,208,255,127,128,31,255,255,255,255,255,208,126,63,128,31,229,85,127,213,85,64,60,63,128,31,192,0,47,192,0,0,16,63,128,31,192,0,47,192,0,0,0,63,128,31,192,0,31,192,0,0,0,63,128,31,192,0,31,208,0,0,0,63,128,31,192,0,15,224,0,0,0,63,128,31,192,0,15,240,0,0,0,63,128,31,192,0,11,240,0,0,0,63,128,31,192,0,71,244,0,0,0,63,128,31,209,175,227,248,0,0,0,63,128,47,255,255,227,252,2,0,0,63,131,255,255,255,226,252,3,224,0,63,130,255,255,250,65,254,3,240,0,63,130,255,228,0,0,255,3,240,0,63,128,144,0,0,0,127,135,224,0,63,128,0,0,0,0,63,255,224,0,63,128,21,85,85,85,31,255,192,0,63,128,255,255,255,255,135,255,128,0,63,128,255,255,255,255,129,190,0,0,63,128,255,255,255,255,128,0,0,0,63,128,0,0,0,0,0,0,0,
  // 0x4f53  体
  83,79,38,38,124,40,1,252,0,0,80,0,0,10,144,0,0,0,0,0,254,0,0,15,224,0,0,0,0,0,254,0,0,15,224,0,0,0,0,2,253,0,0,15,224,0,0,0,0,3,252,0,0,15,224,0,0,0,0,7,248,0,0,15,224,0,0,0,0,15,240,0,0,15,224,0,0,0,0,31,224,0,0,15,224,0,0,0,0,63,211,255,255,255,255,255,255,192,0,127,195,255,255,255,255,255,255,192,0,255,131,255,255,255,255,255,255,192,2,255,129,170,170,255,255,170,170,128,3,255,128,0,1,255,255,0,0,0,15,255,128,0,3,255,255,64,0,0,47,255,128,0,3,255,255,192,0,0,127,255,128,0,11,239,239,208,0,0,191,191,128,0,15,223,235,224,0,0,63,63,128,0,47,207,227,240,0,0,29,63,128,0,63,79,227,252,0,0,4,63,128,0,191,15,225,253,0,0,0,63,128,0,253,15,224,255,0,0,0,63,128,3,252,15,224,127,64,0,0,63,128,7,244,15,224,63,192,0,0,63,128,15,240,15,224,31,240,0,0,63,128,63,208,15,224,15,248,0,0,63,128,191,128,15,224,3,253,0,0,63,130,255,0,15,224,2,255,0,0,63,135,253,255,255,255,254,255,192,0,63,159,248,255,255,255,253,63,224,0,63,135,224,255,255,255,253,31,128,0,63,130,192,85,95,229,84,6,0,0,63,128,0,0,15,224,0,0,0,0,63,128,0,0,15,224,0,0,0,0,63,128,0,0,15,224,0,0,0,0,63,128,0,0,15,224,0,0,0,0,63,128,0,0,15,224,0,0,0,0,63,128,0,0,15,224,0,0,0,0,42,128,0,0,10,144,0,0,0,
  // 0x4f59  余
  89,79,38,39,134,40,1,251,0,0,0,0,106,128,0,0,0,0,0,0,0,0,255,224,0,0,0,0,0,0,0,3,255,248,0,0,0,0,0,0,0,15,255,253,0,0,0,0,0,0,0,63,246,255,64,0,0,0,0,0,0,255,208,255,224,0,0,0,0,0,3,255,128,63,248,0,0,0,0,0,31,254,0,15,255,0,0,0,0,0,191,248,0,2,255,208,0,0,0,3,255,208,0,0,191,248,0,0,0,31,255,64,0,0,31,255,64,0,1,255,252,0,0,0,3,255,244,0,11,255,245,85,85,85,85,255,255,64,127,254,191,255,255,255,255,223,255,208,47,244,127,255,255,255,255,194,255,128,15,128,127,255,255,255,255,192,47,0,0,0,0,0,63,192,0,0,1,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,1,170,170,170,191,234,170,170,168,0,3,255,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,255,252,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,36,0,63,192,7,64,0,0,0,0,255,64,63,192,47,224,0,0,0,2,255,0,63,192,47,248,0,0,0,11,252,0,63,192,11,255,0,0,0,47,244,0,63,192,2,255,192,0,0,191,208,0,63,192,0,127,240,0,3,255,64,0,63,192,0,31,252,0,47,253,0,0,63,192,0,7,255,0,63,244,2,170,191,192,0,1,255,64,11,192,2,255,255,128,0,0,188,0,1,0,0,255,255,0,0,0,16,0,0,0,0,255,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x4f5c  作
  92,79,38,38,124,40,1,252,0,0,4,0,0,0,0,0,0,0,0,0,47,192,1,248,0,0,0,0,0,0,63,192,3,252,0,0,0,0,0,0,127,128,3,248,0,0,0,0,0,0,255,64,11,244,0,0,0,0,0,0,255,0,15,240,0,0,0,0,0,3,253,0,31,224,0,0,0,0,0,7,252,0,63,255,255,255,255,208,0,15,244,0,127,255,255,255,255,208,0,31,240,0,255,255,255,255,255,208,0,63,224,2,254,175,250,170,170,128,0,191,224,3,252,15,224,0,0,0,1,255,224,15,244,15,224,0,0,0,3,255,224,31,240,15,224,0,0,0,15,255,224,127,208,15,224,0,0,0,63,255,224,255,128,15,224,0,0,0,127,255,226,255,0,15,255,255,255,64,63,207,224,125,0,15,255,255,255,64,31,15,224,20,0,15,255,255,255,64,12,15,224,0,0,15,245,85,85,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,245,85,85,64,0,15,224,0,0,15,255,255,255,192,0,15,224,0,0,15,255,255,255,192,0,15,224,0,0,15,255,255,255,192,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,10,144,0,0,10,144,0,0,0,
  // 0x4f7f  使
  127,79,38,38,124,40,1,252,0,0,25,0,0,2,160,0,0,0,0,0,63,192,0,7,244,0,0,0,0,0,63,192,0,7,244,0,0,0,0,0,191,64,0,7,244,0,0,0,0,0,255,85,85,91,249,85,85,64,0,2,253,255,255,255,255,255,255,208,0,3,252,255,255,255,255,255,255,208,0,11,244,255,255,255,255,255,255,208,0,15,240,0,0,7,244,0,0,0,0,63,208,0,0,7,244,0,0,0,0,191,208,0,0,7,244,0,0,0,0,255,208,0,0,7,244,0,0,0,3,255,208,63,255,255,255,255,255,0,11,255,208,63,255,255,255,255,255,0,47,255,208,63,255,255,255,255,255,0,191,255,208,63,128,7,244,0,127,0,255,207,208,63,128,7,244,0,127,0,63,15,208,63,128,7,244,0,127,0,44,15,208,63,128,7,244,0,127,0,0,15,208,63,128,7,244,0,127,0,0,15,208,63,255,255,255,255,255,0,0,15,208,63,255,255,255,255,255,0,0,15,208,63,255,255,255,255,255,0,0,15,208,0,0,11,240,0,0,0,0,15,208,31,128,15,240,0,0,0,0,15,208,31,208,15,224,0,0,0,0,15,208,11,244,31,208,0,0,0,0,15,208,3,253,63,192,0,0,0,0,15,208,0,255,191,128,0,0,0,0,15,208,0,63,255,0,0,0,0,0,15,208,0,15,255,0,0,0,0,0,15,208,0,31,255,224,0,0,0,0,15,208,0,191,255,255,128,0,0,0,15,208,11,255,219,255,254,64,0,0,15,210,255,255,1,255,255,255,144,0,15,211,255,244,0,11,255,255,192,0,15,208,255,64,0,0,111,255,64,0,15,208,100,0,0,0,0,90,0,
  // 0x4f9b  供
  155,79,38,38,124,40,1,252,0,0,20,0,21,64,0,84,0,0,0,0,63,128,47,192,0,253,0,0,0,0,191,64,47,192,0,253,0,0,0,0,255,0,47,192,0,253,0,0,0,1,254,0,47,192,0,253,0,0,0,3,252,0,47,192,0,253,0,0,0,7,248,0,47,192,0,253,0,0,0,15,240,0,47,192,0,253,0,0,0,47,224,42,191,234,170,255,170,128,0,63,192,127,255,255,255,255,255,192,0,255,192,127,255,255,255,255,255,192,1,255,192,127,255,255,255,255,255,192,3,255,192,0,47,192,0,253,0,0,15,255,192,0,47,192,0,253,0,0,63,255,192,0,47,192,0,253,0,0,191,255,192,0,47,192,0,253,0,0,191,175,192,0,47,192,0,253,0,0,63,47,192,0,47,192,0,253,0,0,44,47,192,0,47,192,0,253,0,0,4,47,192,0,47,192,0,253,0,0,0,47,192,0,47,192,0,253,0,0,0,47,193,170,191,234,170,255,170,128,0,47,193,255,255,255,255,255,255,208,0,47,193,255,255,255,255,255,255,208,0,47,193,255,255,255,255,255,255,208,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,14,64,0,36,0,0,0,47,192,0,47,224,1,253,0,0,0,47,192,0,127,192,1,255,64,0,0,47,192,0,255,64,0,127,192,0,0,47,192,3,254,0,0,47,240,0,0,47,192,15,252,0,0,11,248,0,0,47,192,63,240,0,0,3,254,0,0,47,192,255,192,0,0,1,255,0,0,47,194,255,64,0,0,0,191,192,0,47,192,125,0,0,0,0,62,0,0,47,128,4,0,0,0,0,20,0,
  // 0x4fb5  侵
  181,79,38,38,124,40,1,252,0,0,16,0,0,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,0,191,79,255,255,255,255,244,0,0,0,255,15,255,255,255,255,244,0,0,1,253,15,255,255,255,255,244,0,0,3,252,0,0,0,0,3,244,0,0,11,248,0,0,0,0,3,244,0,0,15,240,2,170,170,170,175,244,0,0,47,224,3,255,255,255,255,244,0,0,127,192,3,255,255,255,255,244,0,0,255,192,0,0,0,0,3,244,0,2,255,128,0,0,0,0,3,244,0,7,255,128,31,255,255,255,255,244,0,31,255,128,31,255,255,255,255,244,0,63,255,128,31,255,255,255,255,244,0,255,255,128,0,0,0,0,0,0,0,255,127,128,0,0,0,0,0,0,0,61,63,129,255,255,255,255,255,255,192,40,63,129,255,255,255,255,255,255,192,0,63,129,255,255,255,255,255,255,192,0,63,129,252,0,0,0,0,47,192,0,63,129,252,0,0,0,0,47,192,0,63,129,252,0,0,0,0,47,192,0,63,129,255,255,255,255,255,255,192,0,63,128,171,255,255,255,255,250,64,0,63,128,7,255,255,255,255,208,0,0,63,128,0,111,0,0,127,192,0,0,63,128,0,127,192,1,255,0,0,0,63,128,0,47,240,7,253,0,0,0,63,128,0,11,253,47,244,0,0,0,63,128,0,2,255,255,208,0,0,0,63,128,0,0,191,255,64,0,0,0,63,128,0,1,255,255,144,0,0,0,63,128,0,127,255,255,254,64,0,0,63,129,191,255,254,111,255,255,144,0,63,129,255,255,208,2,255,255,192,0,63,128,255,248,0,0,27,255,64,0,42,128,121,0,0,0,0,26,0,
  // 0x4fdd  保
  221,79,38,38,124,40,1,252,0,0,20,0,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,63,203,255,255,255,255,252,0,0,0,191,75,255,255,255,255,252,0,0,0,255,11,255,255,255,255,252,0,0,2,253,11,245,85,85,87,252,0,0,3,252,11,240,0,0,2,252,0,0,11,244,11,240,0,0,2,252,0,0,15,240,11,240,0,0,2,252,0,0,63,208,11,240,0,0,2,252,0,0,191,208,11,240,0,0,2,252,0,1,255,208,11,240,0,0,2,252,0,3,255,208,11,255,255,255,255,252,0,15,255,208,11,255,255,255,255,252,0,47,255,208,11,255,255,255,255,252,0,191,255,208,1,85,91,249,85,84,0,191,207,208,0,0,7,244,0,0,0,63,15,208,0,0,7,244,0,0,0,45,15,208,0,0,7,244,0,0,0,4,15,208,0,0,7,244,0,0,0,0,15,209,255,255,255,255,255,255,192,0,15,209,255,255,255,255,255,255,192,0,15,209,255,255,255,255,255,255,192,0,15,208,85,85,255,255,149,85,64,0,15,208,0,0,255,255,192,0,0,0,15,208,0,3,255,255,240,0,0,0,15,208,0,11,255,251,248,0,0,0,15,208,0,47,231,246,253,0,0,0,15,208,0,191,199,244,255,64,0,0,15,208,2,255,7,244,127,208,0,0,15,208,15,253,7,244,31,244,0,0,15,208,127,244,7,244,11,254,0,0,15,210,255,208,7,244,2,255,208,0,15,215,255,64,7,244,0,191,240,0,15,209,252,0,7,244,0,47,192,0,15,208,160,0,7,244,0,7,0,0,15,208,0,0,7,244,0,0,0,0,10,144,0,0,7,244,0,0,0,
  // 0x4fe1  信
  225,79,38,38,124,40,1,252,0,0,4,0,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,63,193,255,255,255,255,240,0,0,0,191,65,255,255,255,255,240,0,0,0,255,1,255,255,255,255,240,0,0,2,254,0,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,0,31,240,255,255,255,255,255,255,208,0,63,224,255,255,255,255,255,255,208,0,191,208,255,255,255,255,255,255,208,1,255,208,0,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,0,15,255,208,3,255,255,255,255,244,0,63,255,208,3,255,255,255,255,244,0,255,223,208,3,255,255,255,255,244,0,191,79,208,0,0,0,0,0,0,0,62,15,208,0,0,0,0,0,0,0,44,15,208,0,0,0,0,0,0,0,0,15,208,3,255,255,255,255,244,0,0,15,208,3,255,255,255,255,244,0,0,15,208,3,255,255,255,255,244,0,0,15,208,0,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,0,15,208,7,255,255,255,255,252,0,0,15,208,7,255,255,255,255,252,0,0,15,208,7,255,255,255,255,252,0,0,15,208,7,240,0,0,3,252,0,0,15,208,7,240,0,0,3,252,0,0,15,208,7,240,0,0,3,252,0,0,15,208,7,240,0,0,3,252,0,0,15,208,7,240,0,0,3,252,0,0,15,208,7,255,255,255,255,252,0,0,15,208,7,255,255,255,255,252,0,0,15,208,7,255,255,255,255,252,0,0,15,208,7,240,0,0,3,252,0,0,10,128,7,240,0,0,2,168,0,
  // 0x503c  值
  60,80,37,38,124,40,1,252,0,0,36,0,0,7,164,0,0,0,0,0,127,64,0,7,244,0,0,0,0,0,191,0,0,11,240,0,0,0,0,0,254,0,0,11,240,0,0,0,0,2,253,191,255,255,255,255,255,0,0,3,252,191,255,255,255,255,255,0,0,7,244,191,255,255,255,255,255,0,0,15,240,0,0,31,208,0,0,0,0,31,224,0,0,31,192,0,0,0,0,63,192,0,0,47,192,0,0,0,0,191,128,0,0,63,128,0,0,0,1,255,128,11,255,255,255,255,240,0,3,255,128,11,255,255,255,255,240,0,11,255,128,11,255,255,255,255,240,0,47,255,128,11,224,0,0,7,240,0,127,255,128,11,224,0,0,7,240,0,127,191,128,11,250,170,170,175,240,0,47,63,128,11,255,255,255,255,240,0,28,63,128,11,255,255,255,255,240,0,4,63,128,11,224,0,0,7,240,0,0,63,128,11,224,0,0,7,240,0,0,63,128,11,224,0,0,7,240,0,0,63,128,11,250,170,170,175,240,0,0,63,128,11,255,255,255,255,240,0,0,63,128,11,255,255,255,255,240,0,0,63,128,11,224,0,0,7,240,0,0,63,128,11,224,0,0,7,240,0,0,63,128,11,224,0,0,7,240,0,0,63,128,11,255,255,255,255,240,0,0,63,128,11,255,255,255,255,240,0,0,63,128,11,250,170,170,175,240,0,0,63,128,11,224,0,0,7,240,0,0,63,128,11,224,0,0,7,240,0,0,63,128,15,224,0,0,11,240,0,0,63,135,255,255,255,255,255,255,192,0,63,135,255,255,255,255,255,255,192,0,63,135,255,255,255,255,255,255,192,0,63,128,0,0,0,0,0,0,0,
  // 0x503e  倾
  62,80,37,38,124,40,1,252,0,1,0,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,0,11,240,0,3,255,255,255,255,192,0,15,224,0,3,255,255,255,255,192,0,31,194,244,3,255,255,255,255,192,0,63,194,244,0,0,15,240,0,0,0,63,66,244,0,0,15,224,0,0,0,191,2,244,0,0,31,192,0,0,0,255,2,244,0,0,47,192,0,0,2,255,2,244,0,127,255,255,253,0,3,255,2,244,0,127,255,255,253,0,11,255,2,255,252,127,255,255,253,0,31,255,2,255,252,126,0,0,253,0,63,255,2,255,252,126,1,64,253,0,191,255,2,248,0,126,11,208,253,0,255,191,2,244,0,126,11,208,253,0,190,127,2,244,0,126,11,208,253,0,60,127,2,244,0,126,11,208,253,0,48,127,2,244,0,126,11,208,253,0,0,127,2,244,0,126,11,208,253,0,0,127,2,244,0,126,11,208,253,0,0,127,2,244,0,126,11,208,253,0,0,127,2,244,0,126,11,208,253,0,0,127,2,244,44,126,11,192,253,0,0,127,2,250,252,126,15,192,253,0,0,127,3,255,252,126,15,192,253,0,0,127,7,255,244,126,31,192,253,0,0,127,15,255,64,106,47,128,169,0,0,127,7,244,0,0,63,68,0,0,0,127,3,128,0,0,191,62,0,0,0,127,0,0,0,1,253,191,192,0,0,127,0,0,0,7,252,47,244,0,0,127,0,0,0,47,240,11,254,0,0,127,0,0,1,255,192,1,255,128,0,127,0,0,15,255,0,0,63,192,0,127,0,0,11,248,0,0,15,64,0,127,0,0,2,128,0,0,1,0,
  // 0x504f  偏
  79,80,38,39,134,40,1,251,0,0,144,0,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,0,2,252,255,255,255,255,255,255,208,0,3,248,255,255,255,255,255,255,208,0,7,244,255,255,255,255,255,255,208,0,15,240,0,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,47,255,255,255,255,254,0,0,255,64,47,255,255,255,255,254,0,1,255,64,47,255,255,255,255,254,0,3,255,64,47,192,0,0,0,254,0,7,255,64,47,192,0,0,0,254,0,15,255,64,47,192,0,0,0,254,0,63,255,64,47,255,255,255,255,254,0,191,255,64,47,255,255,255,255,254,0,255,127,64,47,255,255,255,255,254,0,190,63,64,47,128,0,0,0,0,0,60,63,64,47,128,0,0,0,0,0,36,63,64,63,128,0,0,0,0,0,0,63,64,63,255,255,255,255,255,64,0,63,64,63,255,255,255,255,255,64,0,63,64,63,255,255,255,255,255,64,0,63,64,63,248,31,66,240,63,64,0,63,64,127,248,31,66,240,63,64,0,63,64,191,248,31,66,240,63,64,0,63,64,255,248,31,66,240,63,64,0,63,64,255,255,255,255,255,255,64,0,63,65,253,255,255,255,255,255,64,0,63,67,253,255,255,255,255,255,64,0,63,67,249,248,31,66,240,63,64,0,63,75,245,248,31,66,240,63,64,0,63,79,241,248,31,66,240,63,64,0,63,127,209,248,31,66,240,63,64,0,63,95,193,248,31,66,240,63,64,0,63,71,1,248,31,66,247,255,64,0,63,64,1,248,31,66,243,255,0,0,63,64,1,248,31,66,242,248,0,0,0,0,0,0,0,0,0,0,0,
  // 0x505c  停
  92,80,38,38,124,40,1,252,0,0,36,0,0,6,160,0,0,0,0,0,127,64,0,11,240,0,0,0,0,0,191,0,0,11,240,0,0,0,0,0,255,0,0,11,240,0,0,0,0,2,254,255,255,255,255,255,255,192,0,3,252,255,255,255,255,255,255,192,0,11,244,255,255,255,255,255,255,192,0,15,240,0,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,0,127,192,7,255,255,255,255,244,0,0,255,128,7,255,255,255,255,244,0,2,255,128,7,250,170,170,171,244,0,7,255,128,7,240,0,0,7,244,0,15,255,128,7,240,0,0,7,244,0,63,255,128,7,240,0,0,7,244,0,191,255,128,7,255,255,255,255,244,0,255,191,128,7,255,255,255,255,244,0,127,63,128,2,170,170,170,170,160,0,60,63,128,0,0,0,0,0,0,0,20,63,131,255,255,255,255,255,255,224,0,63,131,255,255,255,255,255,255,224,0,63,131,255,255,255,255,255,255,224,0,63,131,244,0,0,0,0,15,224,0,63,131,244,0,0,0,0,15,224,0,63,131,244,0,0,0,0,15,224,0,63,131,244,255,255,255,255,207,224,0,63,131,244,255,255,255,255,207,224,0,63,128,0,255,255,255,255,192,0,0,63,128,0,0,11,240,0,0,0,0,63,128,0,0,11,240,0,0,0,0,63,128,0,0,11,240,0,0,0,0,63,128,0,0,11,240,0,0,0,0,63,128,0,0,11,240,0,0,0,0,63,128,0,0,11,240,0,0,0,0,63,128,0,21,95,240,0,0,0,0,63,128,0,63,255,240,0,0,0,0,63,128,0,47,255,224,0,0,0,0,47,128,0,31,254,64,0,0,0,
  // 0x50a8  储
  168,80,38,38,124,40,1,252,0,2,64,0,0,0,168,0,0,0,0,3,240,0,0,1,252,0,4,0,0,7,240,0,0,1,252,0,47,128,0,15,224,224,0,1,252,0,63,128,0,15,215,248,0,1,252,0,191,0,0,31,194,253,3,255,255,253,254,0,0,63,128,255,67,255,255,255,252,0,0,63,64,63,195,255,255,255,248,0,0,191,0,15,208,1,252,11,240,0,0,254,0,7,0,1,252,31,208,0,2,254,0,0,0,1,252,63,192,0,3,254,0,0,0,1,252,255,0,0,11,254,0,0,15,255,255,255,255,208,31,254,63,255,15,255,255,255,255,208,63,254,63,255,15,255,255,255,255,208,191,254,63,255,5,85,191,213,85,64,191,190,42,191,0,1,255,64,0,0,125,190,0,127,0,7,254,0,0,0,60,190,0,127,0,31,252,0,0,0,16,190,0,127,0,191,240,0,0,0,0,190,0,127,7,255,255,255,254,0,0,190,0,127,47,255,255,255,254,0,0,190,0,127,63,255,255,255,254,0,0,190,0,127,31,255,128,0,190,0,0,190,0,127,11,111,128,0,190,0,0,190,0,127,0,47,128,0,190,0,0,190,0,127,0,47,234,170,254,0,0,190,0,127,0,47,255,255,254,0,0,190,0,127,5,47,255,255,254,0,0,190,0,127,46,47,128,0,190,0,0,190,0,127,255,47,128,0,190,0,0,190,0,191,255,47,128,0,190,0,0,190,0,255,248,47,128,0,190,0,0,190,2,255,192,47,255,255,254,0,0,190,1,253,0,47,255,255,254,0,0,190,0,176,0,47,255,255,254,0,0,190,0,0,0,47,128,0,190,0,0,189,0,0,0,31,128,0,105,0,
  // 0x50cf  像
  207,80,38,38,124,40,1,252,0,0,64,0,21,0,0,0,0,0,0,1,252,0,63,192,0,0,0,0,0,2,252,0,191,64,0,0,0,0,0,3,248,0,255,255,255,128,0,0,0,7,244,3,255,255,255,240,0,0,0,11,240,11,255,255,255,208,0,0,0,15,224,47,224,0,127,128,0,0,0,47,192,191,192,0,255,0,0,0,0,63,194,255,170,171,255,170,170,0,0,191,79,255,255,255,255,255,255,0,0,255,79,255,255,255,255,255,255,0,2,255,66,255,0,15,224,0,191,0,7,255,64,191,0,15,224,0,191,0,15,255,64,191,0,15,224,0,191,0,47,255,64,191,0,15,224,0,191,0,127,255,64,191,255,255,255,255,255,0,255,191,64,191,255,255,255,255,255,0,191,63,64,106,171,255,191,170,169,0,61,63,64,0,31,252,47,64,0,0,56,63,64,1,255,240,31,192,30,0,0,63,64,47,255,252,15,192,127,128,0,63,71,255,245,254,15,209,255,128,0,63,67,255,64,191,75,251,253,0,0,63,65,228,3,255,199,255,240,0,0,63,64,0,47,255,227,255,128,0,0,63,64,2,255,135,242,253,0,0,0,63,64,111,252,3,244,254,0,0,0,63,67,255,208,31,248,191,0,0,0,63,66,253,0,127,252,63,192,0,0,63,64,208,2,255,252,47,224,0,0,63,64,0,31,249,252,15,244,0,0,63,64,1,255,209,252,7,253,0,0,63,64,31,255,1,252,2,255,64,0,63,66,255,244,3,252,0,255,208,0,63,79,255,128,11,244,0,63,128,0,63,67,248,31,255,240,0,11,0,0,63,65,128,15,255,192,0,0,0,0,63,64,0,15,254,0,0,0,0,
  // 0x5145  充
  69,81,37,38,124,40,2,252,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,63,255,255,255,255,255,255,255,253,0,63,255,255,255,255,255,255,255,253,0,63,255,255,255,255,255,255,255,253,0,42,170,171,255,170,170,170,170,168,0,0,0,3,253,0,0,208,0,0,0,0,0,7,252,0,11,244,0,0,0,0,0,11,244,0,11,254,0,0,0,0,0,15,240,0,2,255,128,0,0,0,0,47,208,0,0,191,224,0,0,0,0,63,128,0,0,31,248,0,0,0,0,127,170,175,255,255,254,0,0,15,255,255,255,255,255,255,255,128,0,15,255,255,255,255,255,255,255,224,0,15,255,255,255,255,234,165,111,244,0,15,234,85,0,0,0,0,15,248,0,0,0,1,84,0,42,128,3,208,0,0,0,7,248,0,63,192,0,0,0,0,0,7,248,0,63,192,0,0,0,0,0,7,244,0,63,192,0,0,0,0,0,11,244,0,63,192,0,0,0,0,0,15,240,0,63,192,0,0,0,0,0,15,240,0,63,192,0,0,0,0,0,31,224,0,63,192,0,32,0,0,0,63,208,0,63,192,0,62,0,0,0,191,192,0,63,192,0,63,64,0,1,255,64,0,63,192,0,63,64,0,7,255,0,0,63,192,0,127,0,0,63,252,0,0,63,192,0,127,0,6,255,240,0,0,47,192,0,255,0,191,255,192,0,0,47,255,255,254,0,191,253,0,0,0,31,255,255,252,0,63,224,0,0,0,11,255,255,248,0,24,0,0,0,0,0,106,170,64,0,
  // 0x5148  先
  72,81,36,38,86,40,2,252,0,0,0,0,191,0,0,0,0,0,2,228,0,255,0,0,0,0,0,3,252,0,255,0,0,0,0,0,3,248,0,255,0,0,0,0,0,7,244,0,255,0,0,0,0,0,15,240,0,255,0,0,0,0,0,15,255,255,255,255,255,255,128,0,47,255,255,255,255,255,255,128,0,63,255,255,255,255,255,255,128,0,127,170,170,255,170,170,170,64,0,255,0,0,255,0,0,0,0,2,254,0,0,255,0,0,0,0,3,252,0,0,255,0,0,0,0,15,248,0,0,255,0,0,0,0,2,240,0,0,255,0,0,0,0,0,80,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,106,170,170,170,255,170,170,170,169,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,0,0,11,244,0,63,192,0,0,0,0,15,240,0,63,192,0,0,0,0,15,240,0,63,192,0,0,0,0,15,224,0,63,192,0,0,0,0,31,224,0,63,192,0,0,0,0,47,208,0,63,192,0,0,0,0,63,192,0,63,192,0,0,0,0,191,128,0,63,192,0,116,0,1,255,0,0,63,192,0,127,0,3,254,0,0,63,192,0,191,0,31,252,0,0,63,192,0,191,0,191,244,0,0,63,192,0,254,7,255,208,0,0,63,234,170,253,191,255,64,0,0,47,255,255,252,127,252,0,0,0,15,255,255,248,47,208,0,0,0,2,255,255,224,13,0,0,0,0,0,0,0,0,
  // 0x5149  光
  73,81,38,38,124,40,1,252,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,7,0,0,63,128,0,15,64,0,0,127,128,0,63,128,0,31,240,0,0,63,192,0,63,128,0,63,208,0,0,47,224,0,63,128,0,127,192,0,0,15,240,0,63,128,0,191,64,0,0,11,248,0,63,128,0,255,0,0,0,3,252,0,63,128,2,253,0,0,0,2,254,0,63,128,3,252,0,0,0,0,255,0,63,128,11,244,0,0,0,0,255,64,63,128,31,224,0,0,0,0,125,0,63,128,7,192,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,26,170,170,170,191,234,170,170,170,64,47,255,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,255,192,0,0,2,253,0,15,240,0,0,0,0,0,2,252,0,15,240,0,0,0,0,0,3,252,0,15,240,0,0,0,0,0,3,252,0,15,240,0,0,0,0,0,3,252,0,15,240,0,0,0,0,0,7,248,0,15,240,0,0,0,0,0,11,244,0,15,240,0,0,0,0,0,15,240,0,15,240,0,0,0,0,0,31,240,0,15,240,0,4,0,0,0,63,208,0,15,240,0,14,64,0,0,191,192,0,15,240,0,15,208,0,2,255,64,0,15,240,0,31,192,0,11,254,0,0,15,240,0,31,192,0,127,252,0,0,15,240,0,47,192,7,255,240,0,0,15,240,0,63,192,127,255,128,0,0,11,255,255,255,128,47,253,0,0,0,7,255,255,255,0,15,208,0,0,0,2,255,255,253,0,5,0,0,0,0,0,21,85,80,0,
  // 0x5165  入
  101,81,37,36,104,40,2,252,0,2,170,170,170,64,0,0,0,0,0,3,255,255,255,64,0,0,0,0,0,3,255,255,255,64,0,0,0,0,0,3,255,255,255,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,1,63,192,0,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,0,7,255,224,0,0,0,0,0,0,0,11,255,240,0,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,0,31,251,244,0,0,0,0,0,0,0,47,231,252,0,0,0,0,0,0,0,63,211,252,0,0,0,0,0,0,0,127,194,254,0,0,0,0,0,0,0,255,128,255,0,0,0,0,0,0,1,255,0,255,128,0,0,0,0,0,3,255,0,127,192,0,0,0,0,0,7,253,0,63,224,0,0,0,0,0,15,252,0,31,244,0,0,0,0,0,47,244,0,15,252,0,0,0,0,0,127,224,0,7,254,0,0,0,0,0,255,192,0,2,255,128,0,0,0,3,255,64,0,0,255,208,0,0,0,15,254,0,0,0,127,244,0,0,0,47,252,0,0,0,47,253,0,0,0,255,240,0,0,0,11,255,128,0,7,255,192,0,0,0,2,255,240,0,47,255,64,0,0,0,0,191,253,0,255,252,0,0,0,0,0,47,255,64,127,224,0,0,0,0,0,7,253,0,31,64,0,0,0,0,0,0,248,0,5,0,0,0,0,0,0,0,16,0,
  // 0x5168  全
  104,81,37,37,114,40,1,253,0,0,0,0,191,192,0,0,0,0,0,0,0,0,255,224,0,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,0,11,255,253,0,0,0,0,0,0,0,31,246,255,0,0,0,0,0,0,0,127,224,255,192,0,0,0,0,0,1,255,192,63,240,0,0,0,0,0,7,255,0,15,253,0,0,0,0,0,31,252,0,3,255,64,0,0,0,0,191,240,0,0,255,224,0,0,0,2,255,192,0,0,63,248,0,0,0,15,255,0,0,0,15,255,64,0,0,127,252,0,0,0,3,255,224,0,2,255,224,0,0,0,0,191,253,0,31,255,64,0,0,0,0,31,255,192,127,255,255,255,255,255,255,255,255,192,47,226,255,255,255,255,255,252,127,64,15,2,255,255,255,255,255,252,10,0,0,0,85,85,127,213,85,80,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,47,255,255,255,255,255,255,64,0,0,47,255,255,255,255,255,255,64,0,0,47,255,255,255,255,255,255,64,0,0,0,0,0,127,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,5,85,85,85,127,213,85,85,85,0,15,255,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,255,0,
  // 0x5171  共
  113,81,36,38,86,40,2,252,0,0,21,64,0,1,84,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,10,170,191,234,170,171,254,170,164,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,15,128,0,7,224,0,0,0,0,63,244,0,31,252,0,0,0,0,255,224,0,11,255,64,0,0,3,255,128,0,1,255,224,0,0,15,254,0,0,0,63,248,0,0,127,248,0,0,0,15,255,0,2,255,208,0,0,0,2,255,208,31,255,64,0,0,0,0,191,244,63,252,0,0,0,0,0,47,252,15,208,0,0,0,0,0,7,240,2,0,0,0,0,0,0,1,64,
  // 0x5173  关
  115,81,28,38,10,40,6,252,0,0,0,0,0,96,0,0,45,0,0,0,191,64,0,255,0,0,0,255,0,0,191,128,0,2,254,0,0,63,208,0,3,252,0,0,31,240,0,11,248,0,0,11,244,0,15,240,0,0,3,248,0,47,208,0,0,3,208,0,7,128,0,6,170,170,170,170,170,144,15,255,255,255,255,255,240,15,255,255,255,255,255,240,15,255,255,255,255,255,240,0,0,0,254,0,0,0,0,0,0,254,0,0,0,0,0,0,254,0,0,0,0,0,0,254,0,0,0,0,0,0,254,0,0,0,0,0,0,254,0,0,0,63,255,255,255,255,255,252,63,255,255,255,255,255,252,63,255,255,255,255,255,252,42,170,171,255,234,170,168,0,0,3,255,192,0,0,0,0,3,255,208,0,0,0,0,7,255,240,0,0,0,0,15,255,244,0,0,0,0,31,243,252,0,0,0,0,63,209,255,0,0,0,0,255,192,255,128,0,0,3,255,0,127,224,0,0,31,253,0,47,252,0,0,191,244,0,11,255,64,7,255,208,0,2,255,244,191,255,0,0,0,191,255,255,248,0,0,0,31,253,63,128,0,0,0,2,248,24,0,0,0,0,0,32,
  // 0x5177  具
  119,81,36,36,68,40,2,252,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,250,170,170,170,175,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,250,170,170,170,175,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,85,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,11,208,0,3,208,0,0,0,0,127,248,0,31,254,0,0,0,11,255,248,0,47,255,244,0,1,191,255,128,0,2,255,255,128,47,255,248,0,0,0,31,255,248,127,255,128,0,0,0,0,191,254,31,244,0,0,0,0,0,11,244,10,0,0,0,0,0,0,1,128,
  // 0x5197  冗
  151,81,37,35,94,40,2,252,47,255,255,255,255,255,255,255,252,0,47,255,255,255,255,255,255,255,252,0,47,255,255,255,255,255,255,255,252,0,47,234,170,170,170,170,170,171,252,0,47,192,0,0,0,0,0,3,252,0,47,192,0,0,0,0,0,3,252,0,47,192,0,0,0,0,0,3,252,0,47,192,0,0,0,0,0,3,252,0,47,192,0,0,0,0,0,3,252,0,47,192,0,0,0,0,0,3,252,0,21,64,63,255,255,255,248,1,84,0,0,0,63,255,255,255,248,0,0,0,0,0,63,255,255,255,248,0,0,0,0,0,63,229,85,91,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,127,128,0,3,248,0,0,0,0,0,191,64,0,3,248,0,16,0,0,0,255,0,0,3,248,0,61,0,0,2,254,0,0,3,248,0,63,64,0,7,253,0,0,3,248,0,127,64,0,31,248,0,0,3,248,0,127,0,0,127,240,0,0,3,248,0,127,0,3,255,208,0,0,3,252,0,191,0,47,255,64,0,0,3,255,170,255,0,255,253,0,0,0,3,255,255,253,0,127,224,0,0,0,1,255,255,252,0,47,64,0,0,0,0,127,255,224,0,4,0,0,0,0,0,0,0,0,0,
  // 0x51b7  冷
  183,81,37,38,124,40,2,252,0,0,0,0,0,170,0,0,0,0,0,0,0,0,2,255,64,0,0,0,4,0,0,0,7,255,192,0,0,0,31,0,0,0,15,255,240,0,0,0,127,208,0,0,47,255,248,0,0,0,191,248,0,0,191,195,254,0,0,0,31,254,0,1,255,65,255,128,0,0,7,255,128,7,255,0,191,208,0,0,0,255,208,31,252,0,47,248,0,0,0,63,128,127,240,0,11,254,0,0,0,14,1,255,208,0,3,255,192,0,0,0,7,255,64,0,0,191,244,0,0,0,47,254,85,85,85,111,254,0,0,1,255,243,255,255,255,203,255,128,0,2,255,195,255,255,255,193,255,0,0,0,254,3,255,255,255,192,61,0,0,0,116,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,66,255,255,255,255,255,208,0,0,15,210,255,255,255,255,255,208,0,0,47,226,255,255,255,255,255,208,0,0,63,193,85,95,245,85,111,208,0,0,191,128,0,15,240,0,15,208,0,1,255,0,0,15,240,0,15,208,0,3,254,0,0,15,240,0,15,208,0,11,252,0,0,15,240,0,15,208,0,15,244,0,0,15,240,0,15,208,0,63,240,0,0,15,240,0,15,208,0,127,208,0,0,15,240,42,175,208,0,255,128,0,0,15,240,63,255,208,0,255,0,0,0,15,240,31,255,192,0,45,0,0,0,15,240,15,253,0,0,4,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,10,160,0,0,0,0,
  // 0x51c6  准
  198,81,37,38,124,40,2,252,0,0,0,0,36,0,5,0,0,0,0,0,0,0,191,64,11,240,0,0,0,0,0,0,255,0,15,240,0,0,15,64,0,1,254,0,15,224,0,0,63,224,0,3,252,0,47,192,0,0,63,252,0,7,248,0,63,192,0,0,11,255,64,15,244,0,63,64,0,0,1,255,208,31,240,0,191,0,0,0,0,63,240,63,255,255,255,255,253,0,0,15,192,127,255,255,255,255,253,0,0,3,0,255,255,255,255,255,253,0,0,0,2,255,213,86,253,85,84,0,0,0,7,255,192,1,252,0,0,0,0,0,15,255,192,1,252,0,0,0,0,0,63,255,192,1,252,0,0,0,0,0,255,239,192,1,252,0,0,0,0,0,127,159,255,255,255,255,244,0,0,0,30,31,255,255,255,255,244,0,0,0,4,31,255,255,255,255,244,0,0,0,0,31,213,86,253,85,80,0,0,0,0,31,192,1,252,0,0,0,0,11,0,31,192,1,252,0,0,0,0,31,208,31,192,1,252,0,0,0,0,63,208,31,192,1,252,0,0,0,0,127,192,31,255,255,255,255,244,0,0,255,0,31,255,255,255,255,244,0,2,254,0,31,255,255,255,255,244,0,7,252,0,31,213,86,253,85,80,0,15,248,0,31,192,1,252,0,0,0,47,240,0,31,192,1,252,0,0,0,127,208,0,31,192,1,252,0,0,0,255,128,0,31,192,1,252,0,0,0,255,0,0,31,229,86,254,85,85,0,61,0,0,31,255,255,255,255,255,64,8,0,0,31,255,255,255,255,255,64,0,0,0,31,255,255,255,255,255,64,0,0,0,31,192,0,0,0,0,0,0,0,0,31,192,0,0,0,0,0,
  // 0x51fa  出
  250,81,32,38,48,40,4,252,0,0,0,10,144,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,250,170,175,250,170,175,240,15,255,255,255,255,255,255,240,15,255,255,255,255,255,255,240,15,255,255,255,255,255,255,240,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,106,0,0,15,224,0,0,169,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,170,170,175,250,170,170,254,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,191,0,0,0,0,0,0,254,191,0,0,0,0,0,0,254,106,0,0,0,0,0,0,169,
  // 0x51fb  击
  251,81,36,38,86,40,2,252,0,0,0,0,170,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,1,170,170,170,255,170,170,170,128,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,106,170,170,170,255,170,170,170,169,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,85,0,0,255,0,0,106,0,0,254,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,170,170,170,170,170,170,255,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,
  // 0x5206  分
  6,82,38,37,114,40,1,252,0,0,1,228,0,0,180,0,0,0,0,0,3,254,0,7,252,0,0,0,0,0,7,252,0,3,254,0,0,0,0,0,15,248,0,1,255,0,0,0,0,0,31,240,0,0,255,192,0,0,0,0,63,224,0,0,63,224,0,0,0,0,255,192,0,0,47,244,0,0,0,1,255,64,0,0,15,252,0,0,0,3,255,0,0,0,3,255,0,0,0,15,252,0,0,0,1,255,192,0,0,63,244,0,0,0,0,255,224,0,0,191,224,0,0,0,0,63,248,0,2,255,192,0,0,0,0,15,254,0,15,255,0,0,0,0,0,7,255,192,63,255,170,170,170,170,170,171,255,224,191,251,255,255,255,255,255,253,191,192,47,195,255,255,255,255,255,253,47,0,11,3,255,255,255,255,255,253,4,0,0,0,0,15,240,0,2,253,0,0,0,0,0,15,240,0,2,253,0,0,0,0,0,31,240,0,2,253,0,0,0,0,0,31,224,0,2,252,0,0,0,0,0,47,208,0,2,252,0,0,0,0,0,63,192,0,3,252,0,0,0,0,0,127,192,0,3,252,0,0,0,0,0,255,128,0,3,252,0,0,0,0,1,255,0,0,3,252,0,0,0,0,3,254,0,0,3,252,0,0,0,0,15,252,0,0,3,248,0,0,0,0,47,248,0,0,7,248,0,0,0,0,255,224,0,0,11,244,0,0,0,7,255,192,0,0,15,244,0,0,0,127,255,0,0,0,47,240,0,0,7,255,248,0,7,255,255,224,0,0,3,255,208,0,3,255,255,208,0,0,1,254,0,0,2,255,255,64,0,0,0,224,0,0,0,170,148,0,0,0,
  // 0x5207  切
  7,82,37,38,124,40,1,251,0,42,64,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,2,170,170,170,170,170,64,0,63,128,3,255,255,255,255,255,128,0,63,128,3,255,255,255,255,255,128,0,63,128,3,255,255,255,255,255,128,0,63,128,0,0,31,208,0,127,64,0,63,128,0,0,31,192,0,127,64,0,63,128,1,128,47,192,0,127,64,0,63,133,191,192,47,192,0,127,64,0,63,255,255,208,47,192,0,127,64,27,255,255,255,224,47,192,0,127,64,191,255,255,249,0,47,192,0,127,64,191,255,228,0,0,47,192,0,127,64,127,191,128,0,0,63,192,0,191,64,16,63,128,0,0,63,192,0,191,0,0,63,128,0,0,63,128,0,191,0,0,63,128,0,0,63,128,0,191,0,0,63,128,0,0,63,64,0,191,0,0,63,128,0,0,127,64,0,191,0,0,63,128,24,0,191,0,0,255,0,0,63,128,31,128,255,0,0,255,0,0,63,128,31,192,254,0,0,255,0,0,63,128,47,193,253,0,0,255,0,0,63,128,47,131,252,0,0,255,0,0,63,234,191,67,252,0,0,255,0,0,63,255,255,11,244,0,0,254,0,0,31,255,254,15,240,0,1,254,0,0,7,255,248,47,224,0,1,254,0,0,0,0,0,127,192,0,2,253,0,0,0,0,1,255,128,0,3,253,0,0,0,0,3,255,0,0,3,252,0,0,0,0,31,252,0,0,11,252,0,0,0,0,191,244,0,255,255,248,0,0,0,1,255,208,0,127,255,240,0,0,0,0,127,64,0,63,255,208,0,0,0,0,28,0,0,42,169,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x521b  创
  27,82,36,38,86,40,1,252,0,0,2,64,0,0,0,0,0,0,0,7,248,0,0,0,0,254,0,0,15,240,0,0,0,0,254,0,0,31,244,0,0,0,0,254,0,0,63,253,0,0,0,0,254,0,0,191,255,0,0,254,0,254,0,0,255,127,192,0,254,0,254,0,3,253,47,240,0,254,0,254,0,11,248,11,252,0,254,0,254,0,47,240,3,254,0,254,0,254,0,127,208,0,255,128,254,0,254,1,255,128,0,127,208,254,0,254,11,254,0,0,31,240,254,0,254,47,248,0,0,11,248,254,0,254,191,240,0,0,3,240,254,0,254,63,255,255,255,255,192,254,0,254,14,127,255,255,254,0,254,0,254,0,127,255,255,254,0,254,0,254,0,127,64,1,253,0,254,0,254,0,127,64,0,253,0,254,0,254,0,127,64,1,253,0,254,0,254,0,127,64,1,252,0,254,0,254,0,127,64,1,252,0,254,0,254,0,127,64,2,252,0,254,0,254,0,127,64,3,252,0,254,0,254,0,127,71,255,248,0,254,0,254,0,127,67,255,240,0,254,0,254,0,127,66,255,128,0,20,0,254,0,127,64,0,2,0,0,0,254,0,127,64,0,3,224,0,0,254,0,127,64,0,3,240,0,0,254,0,127,64,0,3,240,0,0,254,0,127,64,0,7,240,0,0,254,0,63,128,0,15,240,0,1,254,0,63,255,255,255,208,63,255,253,0,47,255,255,255,192,47,255,252,0,7,255,255,255,0,31,255,244,0,0,0,0,0,0,10,165,0,
  // 0x521d  初
  29,82,37,39,134,40,1,251,0,3,244,0,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,0,7,244,0,170,170,170,170,170,64,0,7,244,1,255,255,255,255,255,128,0,7,244,1,255,255,255,255,255,128,0,7,244,1,255,255,255,255,255,128,21,91,249,80,0,15,224,0,127,64,63,255,255,253,0,15,224,0,127,64,63,255,255,253,0,15,224,0,127,64,63,255,255,252,0,31,224,0,127,64,0,0,3,248,0,31,208,0,127,64,0,0,11,240,0,31,208,0,127,64,0,0,31,224,0,31,208,0,127,64,0,0,63,192,0,31,208,0,127,64,0,0,191,70,0,47,192,0,191,64,0,1,255,15,128,47,192,0,191,64,0,3,252,47,192,47,192,0,191,0,0,11,252,127,0,63,192,0,191,0,0,47,255,252,0,63,192,0,191,0,0,191,255,244,0,63,128,0,191,0,1,255,255,240,0,127,64,0,191,0,11,255,251,252,0,191,0,0,255,0,47,255,245,255,0,255,0,0,255,0,191,231,244,191,64,255,0,0,255,0,63,199,244,62,2,253,0,0,255,0,46,7,244,12,3,252,0,0,255,0,8,7,244,0,7,252,0,0,255,0,0,7,244,0,15,244,0,0,254,0,0,7,244,0,31,240,0,1,254,0,0,7,244,0,63,208,0,1,253,0,0,7,244,0,191,192,0,2,253,0,0,7,244,2,255,64,0,3,252,0,0,7,244,11,254,0,0,11,252,0,0,7,244,47,252,0,191,255,248,0,0,7,244,63,240,0,63,255,240,0,0,7,244,15,192,0,63,255,208,0,0,3,244,2,0,0,42,169,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x522b  别
  43,82,36,37,77,40,1,252,0,0,0,0,0,0,0,0,254,7,255,255,255,248,0,0,0,254,7,255,255,255,248,0,0,0,254,7,255,255,255,248,0,0,0,254,7,245,85,87,248,1,252,0,254,7,240,0,3,248,1,252,0,254,7,240,0,3,248,1,252,0,254,7,240,0,3,248,1,252,0,254,7,240,0,3,248,1,252,0,254,7,240,0,3,248,1,252,0,254,7,240,0,3,248,1,252,0,254,7,255,255,255,248,1,252,0,254,7,255,255,255,248,1,252,0,254,7,255,255,255,248,1,252,0,254,1,85,85,85,80,1,252,0,254,0,0,169,0,0,1,252,0,254,0,0,253,0,0,1,252,0,254,0,0,253,0,0,1,252,0,254,5,85,254,85,84,1,252,0,254,47,255,255,255,254,1,252,0,254,47,255,255,255,253,1,252,0,254,47,255,255,255,253,1,252,0,254,0,2,252,0,253,1,252,0,254,0,3,252,0,253,1,252,0,254,0,3,248,1,253,1,252,0,254,0,3,244,1,253,1,252,0,254,0,7,240,1,252,1,168,0,254,0,15,240,1,252,0,0,0,254,0,31,208,2,252,0,0,0,254,0,63,192,2,252,0,0,0,254,0,191,128,3,252,0,0,0,254,1,255,0,3,248,0,0,0,254,7,254,0,11,248,0,0,1,254,47,248,15,255,244,0,31,255,253,127,224,11,255,240,0,15,255,252,31,128,7,255,192,0,11,255,244,9,0,1,84,0,0,6,170,64,
  // 0x5230  到
  48,82,36,37,77,40,1,252,0,0,0,0,0,0,0,0,170,0,0,0,0,0,0,0,0,254,63,255,255,255,255,208,0,0,254,63,255,255,255,255,208,0,0,254,63,255,255,255,255,211,244,0,254,21,87,253,85,85,67,244,0,254,0,7,248,0,0,3,244,0,254,0,11,244,7,192,3,244,0,254,0,15,240,31,224,3,244,0,254,0,31,208,11,244,3,244,0,254,0,47,192,3,252,3,244,0,254,0,63,128,0,255,3,244,0,254,42,255,255,255,255,67,244,0,254,63,255,255,255,255,195,244,0,254,63,255,255,255,255,227,244,0,254,63,254,170,85,11,243,244,0,254,0,0,21,64,3,131,244,0,254,0,0,47,192,0,3,244,0,254,0,0,47,192,0,3,244,0,254,0,0,47,192,0,3,244,0,254,0,0,47,192,0,3,244,0,254,11,255,255,255,255,3,244,0,254,11,255,255,255,255,3,244,0,254,11,255,255,255,255,3,244,0,254,1,85,111,213,85,3,244,0,254,0,0,47,192,0,3,244,0,254,0,0,47,192,0,2,164,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,5,144,0,0,254,0,0,47,239,255,208,0,0,254,5,175,255,255,255,208,0,0,254,127,255,255,255,255,208,0,0,254,63,255,255,254,148,0,31,255,254,63,255,165,0,0,0,15,255,253,41,0,0,0,0,0,11,255,248,0,0,0,0,0,0,7,170,64,
  // 0x5236  制
  54,82,36,38,86,40,1,252,0,0,6,144,0,0,0,0,0,0,164,11,240,0,0,0,0,191,0,254,11,240,0,0,0,0,191,1,253,11,240,0,0,0,0,191,2,252,11,240,0,0,47,192,191,3,252,11,240,0,0,47,192,191,3,255,255,255,255,208,47,192,191,7,255,255,255,255,208,47,192,191,15,255,255,255,255,208,47,192,191,31,229,95,245,85,64,47,192,191,63,192,11,240,0,0,47,192,191,127,128,11,240,0,0,47,192,191,7,0,11,240,0,0,47,192,191,63,255,255,255,255,252,47,192,191,63,255,255,255,255,252,47,192,191,63,255,255,255,255,252,47,192,191,21,85,95,245,85,84,47,192,191,0,0,11,240,0,0,47,192,191,0,0,11,240,0,0,47,192,191,0,0,11,240,0,0,47,192,191,7,255,255,255,255,240,47,192,191,7,255,255,255,255,240,47,192,191,7,255,255,255,255,240,47,192,191,7,245,95,245,91,240,47,192,191,7,240,11,240,11,240,47,192,191,7,240,11,240,11,240,47,192,191,7,240,11,240,11,240,21,64,191,7,240,11,240,11,240,0,0,191,7,240,11,240,11,240,0,0,191,7,240,11,240,11,240,0,0,191,7,240,11,240,11,240,0,0,191,7,240,11,240,11,240,0,0,191,7,240,11,243,255,224,0,0,191,7,240,11,241,255,208,0,0,191,7,224,11,240,254,64,7,255,255,0,0,11,240,0,0,3,255,254,0,0,11,240,0,0,2,255,252,0,0,11,240,0,0,1,250,144,
  // 0x5237  刷
  55,82,36,37,77,40,1,252,0,0,0,0,0,0,0,0,190,1,85,85,85,85,80,0,0,191,3,255,255,255,255,240,0,0,191,3,255,255,255,255,240,21,0,191,3,255,255,255,255,240,191,0,191,3,244,0,0,11,240,191,0,191,3,244,0,0,11,240,191,0,191,3,244,0,0,11,240,191,0,191,3,244,0,0,11,240,191,0,191,3,255,255,255,255,240,191,0,191,3,255,255,255,255,240,191,0,191,3,255,255,255,255,240,191,0,191,3,249,85,191,85,80,191,0,191,3,244,0,127,0,0,191,0,191,3,244,0,127,0,0,191,0,191,3,244,0,127,0,0,191,0,191,3,244,0,127,0,0,191,0,191,3,251,255,255,255,240,191,0,191,3,251,255,255,255,240,191,0,191,3,251,255,255,255,240,191,0,191,3,251,224,127,3,240,191,0,191,3,247,224,127,3,240,191,0,191,3,247,224,127,3,240,191,0,191,3,247,224,127,3,240,191,0,191,7,243,224,127,3,240,191,0,191,7,243,224,127,3,240,191,0,191,11,227,224,127,3,240,21,0,191,15,227,224,127,3,240,0,0,191,15,211,224,127,3,240,0,0,191,15,195,224,127,191,240,0,0,191,47,195,224,127,63,224,0,0,191,63,131,224,127,63,128,0,0,191,63,65,64,127,0,0,0,0,255,191,0,0,127,0,0,7,255,255,62,0,0,127,0,0,3,255,254,8,0,0,127,0,0,2,255,252,0,0,0,126,0,0,1,234,80,
  // 0x5272  割
  114,82,35,38,86,40,2,252,0,0,42,0,0,0,0,0,0,0,0,127,64,0,0,0,2,252,0,0,127,64,0,0,0,2,252,0,0,127,64,0,0,0,2,252,255,255,255,255,255,192,0,2,252,255,255,255,255,255,195,248,2,252,255,255,255,255,255,195,248,2,252,253,0,0,0,31,195,248,2,252,253,0,63,0,31,195,248,2,252,253,0,63,0,31,195,248,2,252,111,170,255,234,190,131,248,2,252,15,255,255,255,252,3,248,2,252,15,255,255,255,252,3,248,2,252,0,0,63,0,0,3,248,2,252,0,0,63,0,0,3,248,2,252,6,170,191,170,160,3,248,2,252,7,255,255,255,244,3,248,2,252,7,255,255,255,244,3,248,2,252,0,0,63,0,0,3,248,2,252,0,0,63,0,0,3,248,2,252,191,255,255,255,255,131,248,2,252,255,255,255,255,255,131,248,2,252,255,255,255,255,255,131,248,2,252,0,0,0,0,0,3,248,2,252,0,0,0,0,0,3,248,2,252,7,255,255,255,248,3,248,2,252,11,255,255,255,252,3,248,2,252,11,255,255,255,252,0,0,2,252,11,240,0,2,252,0,0,2,252,11,240,0,2,252,0,0,2,252,11,240,0,2,252,0,0,2,252,11,240,0,2,252,0,0,2,252,11,240,0,2,252,0,0,2,252,11,255,255,255,252,0,0,3,252,11,255,255,255,252,0,63,255,252,11,255,255,255,252,0,31,255,248,11,240,0,2,252,0,15,255,240,7,224,0,0,84,0,15,250,64,
  // 0x529b  力
  155,82,34,39,95,40,2,251,0,0,0,10,160,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,47,255,255,255,255,255,255,255,240,47,255,255,255,255,255,255,255,240,47,255,255,255,255,255,255,255,240,47,255,255,255,255,255,255,255,240,0,0,0,31,224,0,0,15,240,0,0,0,31,224,0,0,15,240,0,0,0,47,208,0,0,15,240,0,0,0,47,208,0,0,15,240,0,0,0,63,192,0,0,15,240,0,0,0,63,192,0,0,15,224,0,0,0,127,128,0,0,15,224,0,0,0,255,64,0,0,15,224,0,0,0,255,0,0,0,31,224,0,0,1,255,0,0,0,31,208,0,0,3,253,0,0,0,31,208,0,0,7,252,0,0,0,47,208,0,0,15,248,0,0,0,47,192,0,0,47,240,0,0,0,63,192,0,0,63,224,0,0,0,63,192,0,0,255,192,0,0,0,63,192,0,3,255,64,0,0,0,127,128,0,11,254,0,0,0,0,127,128,0,63,252,0,0,0,0,191,64,0,255,240,0,0,0,0,255,0,7,255,192,0,0,0,3,255,0,47,255,0,0,0,255,255,254,0,127,252,0,0,0,255,255,252,0,31,208,0,0,0,127,255,240,0,11,0,0,0,0,42,170,64,0,0,0,0,0,0,0,0,0,0,
  // 0x529f  功
  159,82,37,37,114,40,1,252,0,0,0,0,0,11,240,0,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,0,11,240,0,0,0,63,255,255,254,0,11,240,0,0,0,63,255,255,254,0,11,240,0,0,0,63,255,255,254,0,11,240,0,0,0,42,171,250,169,0,11,240,0,0,0,0,7,244,0,106,175,250,170,170,0,0,7,244,0,255,255,255,255,255,64,0,7,244,0,255,255,255,255,255,64,0,7,244,0,255,255,255,255,255,64,0,7,244,0,0,15,240,0,127,64,0,7,244,0,0,15,224,0,127,64,0,7,244,0,0,15,224,0,127,64,0,7,244,0,0,31,208,0,127,0,0,7,244,0,0,31,208,0,127,0,0,7,244,0,0,31,208,0,191,0,0,7,244,0,0,47,192,0,191,0,0,7,244,0,0,63,192,0,191,0,0,7,244,0,0,63,192,0,191,0,0,7,244,0,0,63,128,0,191,0,0,7,244,111,64,191,64,0,255,0,0,7,255,255,128,255,0,0,255,0,0,31,255,255,128,255,0,0,255,0,27,255,255,254,66,253,0,0,254,0,127,255,255,144,3,252,0,0,254,0,63,255,144,0,11,248,0,0,254,0,63,228,0,0,31,240,0,1,253,0,20,0,0,0,63,224,0,1,253,0,0,0,0,0,255,192,0,2,252,0,0,0,0,3,255,0,0,3,252,0,0,0,0,31,253,0,0,11,252,0,0,0,0,255,244,0,255,255,244,0,0,0,0,255,208,0,191,255,240,0,0,0,0,63,64,0,127,255,192,0,0,0,0,24,0,0,22,148,0,0,
  // 0x52a0  加
  160,82,36,37,77,40,1,252,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,31,255,255,253,0,11,240,0,0,31,255,255,253,0,11,240,0,0,31,255,255,253,47,255,255,255,252,31,234,170,253,47,255,255,255,252,31,192,0,253,47,255,255,255,252,31,192,0,253,26,175,250,171,248,31,192,0,253,0,11,240,3,248,31,192,0,253,0,15,240,3,248,31,192,0,253,0,15,240,3,248,31,192,0,253,0,15,224,3,248,31,192,0,253,0,15,224,3,248,31,192,0,253,0,15,224,3,248,31,192,0,253,0,15,224,3,248,31,192,0,253,0,15,208,3,248,31,192,0,253,0,31,208,3,248,31,192,0,253,0,31,192,3,248,31,192,0,253,0,47,192,3,244,31,192,0,253,0,63,192,3,244,31,192,0,253,0,63,128,3,244,31,192,0,253,0,63,128,7,244,31,192,0,253,0,127,64,7,244,31,192,0,253,0,191,0,7,244,31,192,0,253,0,255,0,7,240,31,192,0,253,1,254,0,11,240,31,192,0,253,3,252,0,11,240,31,234,170,253,7,248,0,15,240,31,255,255,253,15,244,0,15,240,31,255,255,253,47,240,106,191,224,31,255,255,253,127,208,63,255,208,31,192,0,253,127,128,63,255,128,31,192,0,253,15,0,47,253,0,31,192,0,169,4,0,0,0,0,0,0,0,0,
  // 0x52a8  动
  168,82,36,37,77,40,2,252,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,5,85,85,85,64,2,252,0,0,31,255,255,255,192,2,252,0,0,31,255,255,255,192,2,252,0,0,31,255,255,255,192,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,6,171,254,170,169,0,0,0,0,15,255,255,255,254,0,0,0,0,15,255,255,255,254,0,0,0,0,15,255,255,255,254,255,255,255,255,224,3,252,0,254,255,255,255,255,224,3,248,0,254,255,255,255,255,224,3,248,0,254,85,127,229,85,80,3,248,0,254,0,63,192,0,0,3,244,0,253,0,63,128,0,0,7,244,0,253,0,127,64,4,0,7,244,0,253,0,191,0,252,0,11,240,1,253,0,255,0,254,0,11,240,1,253,0,254,0,127,0,15,240,1,253,1,252,0,63,64,15,224,1,252,2,252,0,47,128,31,208,1,252,3,248,0,31,192,47,192,2,252,7,240,0,111,208,63,192,2,252,15,240,111,255,224,63,128,2,252,31,255,255,255,240,191,64,3,252,63,255,255,251,244,255,0,3,252,63,255,249,3,249,254,0,3,248,63,249,0,2,147,252,0,3,248,46,64,0,0,11,252,0,7,244,0,0,0,0,31,244,0,15,240,0,0,0,0,127,224,255,255,240,0,0,0,0,191,192,191,255,208,0,0,0,0,31,0,127,255,128,0,0,0,0,9,0,26,164,0,
  // 0x5316  化
  22,83,38,37,114,40,1,252,0,0,3,144,11,240,0,0,0,0,0,0,11,248,11,240,0,0,0,0,0,0,15,240,11,240,0,0,0,0,0,0,47,224,11,240,0,0,0,0,0,0,63,192,11,240,0,0,0,0,0,0,255,128,11,240,0,0,0,0,0,1,255,0,11,240,0,0,0,0,0,3,254,0,11,240,0,0,160,0,0,11,252,0,11,240,0,2,244,0,0,31,244,0,11,240,0,15,253,0,0,63,244,0,11,240,0,127,253,0,0,255,244,0,11,240,2,255,240,0,2,255,244,0,11,240,31,255,128,0,11,255,244,0,11,240,255,252,0,0,47,255,244,0,11,251,255,208,0,0,191,247,244,0,11,255,254,0,0,0,255,215,244,0,11,255,224,0,0,0,63,71,244,0,11,255,64,0,0,0,45,7,244,0,11,244,0,0,0,0,4,7,244,0,11,240,0,0,0,0,0,7,244,0,11,240,0,0,0,0,0,7,244,0,11,240,0,0,0,0,0,7,244,0,11,240,0,0,0,0,0,7,244,0,11,240,0,0,0,0,0,7,244,0,11,240,0,0,0,0,0,7,244,0,11,240,0,0,4,0,0,7,244,0,11,240,0,0,15,128,0,7,244,0,11,240,0,0,15,224,0,7,244,0,11,240,0,0,15,208,0,7,244,0,11,240,0,0,15,208,0,7,244,0,11,240,0,0,31,192,0,7,244,0,11,244,0,0,63,192,0,7,244,0,7,254,85,86,255,128,0,7,244,0,3,255,255,255,255,64,0,7,244,0,2,255,255,255,254,0,0,7,244,0,0,111,255,255,244,0,0,2,160,0,0,0,0,0,0,0,
  // 0x5347  升
  71,83,36,37,77,40,2,252,0,0,0,1,244,0,254,0,0,0,0,0,31,252,0,254,0,0,0,0,2,255,255,0,254,0,0,0,0,127,255,248,0,254,0,0,0,31,255,255,128,0,254,0,0,27,255,255,228,0,0,254,0,0,127,255,255,128,0,0,254,0,0,63,254,127,128,0,0,254,0,0,30,64,63,128,0,0,254,0,0,0,0,63,128,0,0,254,0,0,0,0,63,128,0,0,254,0,0,0,0,63,128,0,0,254,0,0,0,0,63,128,0,0,254,0,0,0,0,63,128,0,0,254,0,0,0,0,63,128,0,0,254,0,0,170,170,191,234,170,170,255,170,170,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,127,64,0,0,254,0,0,0,0,127,64,0,0,254,0,0,0,0,191,0,0,0,254,0,0,0,0,191,0,0,0,254,0,0,0,0,255,0,0,0,254,0,0,0,0,255,0,0,0,254,0,0,0,2,253,0,0,0,254,0,0,0,3,252,0,0,0,254,0,0,0,11,252,0,0,0,254,0,0,0,15,244,0,0,0,254,0,0,0,63,240,0,0,0,254,0,0,0,255,192,0,0,0,254,0,0,3,255,128,0,0,0,254,0,0,15,254,0,0,0,0,254,0,0,191,248,0,0,0,0,254,0,0,191,224,0,0,0,0,254,0,0,47,64,0,0,0,0,254,0,0,8,0,0,0,0,0,253,0,0,
  // 0x534a  半
  74,83,36,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,9,0,0,255,0,0,164,0,0,191,0,0,255,0,0,255,64,0,255,64,0,255,0,1,255,0,0,127,192,0,255,0,3,253,0,0,47,224,0,255,0,7,252,0,0,15,240,0,255,0,15,244,0,0,11,248,0,255,0,31,240,0,0,3,252,0,255,0,63,208,0,0,3,253,0,255,0,191,128,0,0,1,253,0,255,0,191,0,0,0,0,128,0,255,0,5,0,0,0,0,0,0,255,0,0,0,0,2,170,170,170,255,170,170,170,144,7,255,255,255,255,255,255,255,224,7,255,255,255,255,255,255,255,224,7,255,255,255,255,255,255,255,224,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,171,255,170,170,170,170,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,
  // 0x534f  协
  79,83,37,38,124,40,2,252,0,190,0,0,0,84,0,0,0,0,0,254,0,0,1,252,0,0,0,0,0,254,0,0,1,252,0,0,0,0,0,254,0,0,1,252,0,0,0,0,0,254,0,0,1,252,0,0,0,0,0,254,0,0,1,252,0,0,0,0,0,254,0,0,1,252,0,0,0,0,0,254,0,0,1,252,0,0,0,0,0,254,0,63,255,255,255,253,0,0,85,255,85,63,255,255,255,253,0,0,255,255,255,63,255,255,255,253,0,0,255,255,255,42,171,254,170,253,0,0,255,255,255,0,2,252,1,252,0,0,0,254,0,0,2,252,1,252,0,0,0,254,0,0,3,248,1,252,0,0,0,254,0,62,3,248,1,254,176,0,0,254,0,127,3,248,1,255,244,0,0,254,0,191,3,244,1,254,252,0,0,254,0,254,7,244,1,253,252,0,0,254,0,253,7,240,2,252,253,0,0,254,1,252,11,240,2,252,254,0,0,254,3,252,15,240,2,252,191,0,0,254,3,244,31,224,2,252,127,0,0,254,11,240,47,192,2,252,63,0,0,254,31,224,63,192,2,252,63,64,0,254,15,192,127,128,3,252,63,128,0,254,2,128,255,0,3,248,47,128,0,254,0,1,255,0,3,248,24,0,0,254,0,3,253,0,3,248,0,0,0,254,0,11,252,0,3,248,0,0,0,254,0,31,244,0,3,244,0,0,0,254,0,63,224,0,7,244,0,0,0,254,0,255,192,0,11,240,0,0,0,254,3,255,64,0,31,240,0,0,0,254,15,253,0,255,255,224,0,0,0,254,31,248,0,191,255,192,0,0,0,254,7,224,0,127,255,64,0,0,0,190,1,128,0,21,80,0,0,0,
  // 0x5355  单
  85,83,36,38,86,40,2,252,0,0,20,0,0,0,4,0,0,0,1,253,0,0,0,47,208,0,0,1,255,0,0,0,63,208,0,0,0,191,192,0,0,255,128,0,0,0,63,224,0,1,255,0,0,0,0,15,240,0,3,253,0,0,0,0,11,224,0,11,248,0,0,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,254,0,0,255,0,0,127,64,0,254,0,0,255,0,0,127,64,0,254,0,0,255,0,0,127,64,0,254,0,0,255,0,0,127,64,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,254,0,0,255,0,0,127,64,0,254,0,0,255,0,0,127,64,0,254,0,0,255,0,0,127,64,0,254,0,0,255,0,0,127,64,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,85,255,85,85,85,85,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,170,0,0,0,0,
  // 0x5361  卡
  97,83,36,38,86,40,2,252,0,0,0,2,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,254,170,170,169,0,0,0,0,3,255,255,255,254,0,0,0,0,3,255,255,255,254,0,0,0,0,3,255,255,255,254,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,171,254,170,170,170,170,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,64,0,0,0,0,0,0,3,255,249,0,0,0,0,0,0,3,255,255,228,0,0,0,0,0,3,255,255,255,144,0,0,0,0,3,252,111,255,253,0,0,0,0,3,252,1,255,255,192,0,0,0,3,252,0,11,255,128,0,0,0,3,252,0,0,127,0,0,0,0,3,252,0,0,5,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,2,252,0,0,0,0,
  // 0x5370  印
  112,83,33,38,86,40,4,252,0,0,1,64,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,2,255,244,0,0,0,0,0,0,127,255,248,63,255,255,255,192,251,255,255,128,63,255,255,255,192,255,255,228,0,63,255,255,255,192,255,249,0,0,63,234,170,191,192,255,64,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,255,255,244,63,128,0,63,192,255,255,255,244,63,128,0,63,192,255,255,255,244,63,128,0,63,192,255,170,170,160,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,255,255,244,63,128,0,63,192,255,255,255,244,63,129,255,255,128,255,255,255,244,63,128,255,255,128,255,170,170,164,63,128,191,255,0,255,0,0,0,63,128,63,228,0,255,0,0,0,63,128,0,0,0,255,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,42,64,0,0,0,
  // 0x5371  危
  113,83,37,38,124,40,1,252,0,0,3,148,0,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,0,47,255,255,255,208,0,0,0,0,0,63,255,255,255,248,0,0,0,0,0,255,255,255,255,244,0,0,0,0,2,255,0,0,47,240,0,0,0,0,7,253,0,0,63,192,0,0,0,0,31,248,0,0,255,128,0,0,0,0,127,245,85,86,255,85,85,85,0,1,255,255,255,255,255,255,255,255,64,11,255,255,255,255,255,255,255,255,64,47,255,255,255,255,255,255,255,255,64,127,255,208,0,0,0,0,0,0,0,31,223,208,0,0,0,0,0,0,0,7,31,208,0,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,0,31,208,63,255,255,255,253,0,0,0,31,208,63,255,255,255,253,0,0,0,31,208,63,255,255,255,253,0,0,0,31,208,63,128,0,1,253,0,0,0,31,192,63,128,0,1,252,0,0,0,47,192,63,128,0,2,252,0,0,0,47,192,63,128,0,2,252,0,0,0,63,192,63,128,0,3,252,0,0,0,63,128,63,128,0,7,248,0,0,0,63,64,63,128,31,255,244,0,0,0,127,64,63,128,15,255,240,0,0,0,191,0,63,128,15,255,128,8,0,0,255,0,63,128,0,0,0,31,192,2,253,0,63,128,0,0,0,31,192,3,252,0,63,128,0,0,0,47,192,11,248,0,63,128,0,0,0,63,192,15,240,0,63,208,0,0,0,191,128,63,224,0,47,255,255,255,255,255,64,127,192,0,15,255,255,255,255,255,0,15,64,0,7,255,255,255,255,248,0,1,0,0,0,21,85,85,85,64,0,
  // 0x5374  却
  116,83,36,38,86,40,1,252,0,0,42,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,10,170,170,169,0,0,63,64,0,31,255,255,254,0,0,63,64,0,31,255,255,254,0,0,63,64,0,31,255,255,254,5,85,127,149,84,31,192,0,254,15,255,255,255,252,31,192,0,254,15,255,255,255,252,31,192,0,254,15,255,255,255,252,31,192,0,254,0,0,63,64,0,31,192,0,254,0,0,63,64,0,31,192,0,254,0,0,63,64,0,31,192,0,254,0,0,63,64,0,31,192,0,254,0,0,63,64,0,31,192,0,254,0,0,63,64,0,31,192,0,254,127,255,255,255,255,95,192,0,254,127,255,255,255,255,95,192,0,254,127,255,255,255,255,95,192,0,254,21,91,253,85,85,31,192,0,254,0,11,248,0,0,31,192,0,254,0,15,240,0,0,31,192,0,254,0,15,240,0,0,31,192,0,254,0,31,224,27,0,31,192,0,254,0,47,192,127,64,31,192,0,254,0,63,192,63,192,31,192,0,254,0,127,64,31,224,31,192,0,254,0,191,0,11,240,31,193,255,254,0,254,0,3,248,31,192,255,253,1,254,106,255,252,31,192,255,252,127,255,255,255,254,31,192,191,208,63,255,255,255,255,31,192,0,0,63,255,255,165,191,95,192,0,0,62,165,0,0,63,159,192,0,0,0,0,0,0,46,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,
  // 0x5378  卸
  120,83,36,38,86,40,1,252,0,10,64,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,47,192,0,0,5,85,85,85,0,63,128,0,0,15,255,255,255,0,127,149,85,84,15,255,255,255,0,255,255,255,254,15,255,255,255,1,255,255,255,254,15,208,0,191,3,255,255,255,254,15,208,0,191,11,244,31,192,0,15,208,0,191,31,240,31,192,0,15,208,0,191,63,208,31,192,0,15,208,0,191,11,128,31,192,0,15,208,0,191,1,0,31,192,0,15,208,0,191,63,255,255,255,255,79,208,0,191,63,255,255,255,255,79,208,0,191,63,255,255,255,255,79,208,0,191,21,85,111,213,85,15,208,0,191,0,0,31,192,0,15,208,0,191,0,0,31,192,0,15,208,0,191,2,244,31,192,0,15,208,0,191,3,244,31,192,0,15,208,0,191,3,244,31,255,252,15,208,0,191,3,244,31,255,252,15,208,0,191,3,244,31,255,252,15,208,0,191,3,244,31,192,0,15,208,0,191,3,244,31,192,0,15,208,0,191,3,244,31,192,0,15,208,0,191,3,244,31,192,0,15,208,0,255,3,244,31,192,0,15,208,255,255,3,244,31,192,26,79,208,191,254,3,244,31,255,255,79,208,127,252,3,255,255,255,255,79,208,62,144,127,255,255,255,255,79,208,0,0,127,255,255,249,64,15,208,0,0,127,255,148,0,0,15,208,0,0,57,64,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,
  // 0x538b  压
  139,83,37,36,104,40,1,252,1,255,255,255,255,255,255,255,255,192,1,255,255,255,255,255,255,255,255,192,1,255,255,255,255,255,255,255,255,192,1,254,170,170,170,170,170,170,170,128,1,252,0,0,0,0,0,0,0,0,1,252,0,0,0,85,0,0,0,0,1,252,0,0,0,254,0,0,0,0,1,252,0,0,0,254,0,0,0,0,1,252,0,0,0,254,0,0,0,0,1,252,0,0,0,254,0,0,0,0,1,252,0,0,0,254,0,0,0,0,1,252,0,0,0,254,0,0,0,0,1,252,0,0,0,254,0,0,0,0,1,252,0,0,0,254,0,0,0,0,1,252,47,255,255,255,255,255,252,0,1,252,47,255,255,255,255,255,252,0,1,252,47,255,255,255,255,255,252,0,1,252,26,170,170,255,170,170,168,0,2,252,0,0,0,254,0,0,0,0,2,252,0,0,0,254,0,0,0,0,2,252,0,0,0,254,1,224,0,0,2,248,0,0,0,254,7,248,0,0,3,248,0,0,0,254,3,254,0,0,3,248,0,0,0,254,0,255,128,0,3,244,0,0,0,254,0,63,224,0,7,244,0,0,0,254,0,15,244,0,7,240,0,0,0,254,0,3,224,0,11,240,0,0,0,254,0,1,64,0,15,224,0,0,0,254,0,0,0,0,15,224,0,0,0,254,0,0,0,0,47,210,170,170,170,255,170,170,170,64,63,195,255,255,255,255,255,255,255,192,127,131,255,255,255,255,255,255,255,192,127,67,255,255,255,255,255,255,255,192,31,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
  // 0x539f  原
  159,83,37,36,104,40,1,252,0,255,255,255,255,255,255,255,255,128,0,255,255,255,255,255,255,255,255,128,0,255,255,255,255,255,255,255,255,128,0,255,85,85,86,255,85,85,85,64,0,254,0,0,1,255,0,0,0,0,0,254,0,0,2,254,0,0,0,0,0,254,0,0,3,253,0,0,0,0,0,254,3,255,255,255,255,255,224,0,0,254,3,255,255,255,255,255,224,0,0,254,3,255,255,255,255,255,224,0,0,254,3,248,0,0,0,15,224,0,0,254,3,248,0,0,0,15,224,0,0,254,3,248,0,0,0,15,224,0,0,254,3,254,170,170,170,191,224,0,0,254,3,255,255,255,255,255,224,0,0,254,3,255,255,255,255,255,224,0,0,254,3,248,0,0,0,15,224,0,0,254,3,248,0,0,0,15,224,0,0,254,3,248,0,0,0,15,224,0,0,253,3,255,255,255,255,255,224,0,1,253,3,255,255,255,255,255,224,0,1,253,3,255,255,255,255,255,224,0,1,252,0,0,0,191,0,0,0,0,2,252,0,0,0,191,0,0,0,0,3,252,0,62,64,191,0,184,0,0,3,248,0,127,192,191,3,254,0,0,3,248,0,255,0,191,1,255,128,0,7,244,3,254,0,191,0,63,224,0,11,240,11,252,0,191,0,31,248,0,15,240,47,240,0,191,0,7,253,0,15,224,191,208,0,191,0,1,255,0,47,211,255,64,0,191,0,0,191,192,63,195,253,1,65,255,0,0,63,128,127,128,180,3,255,255,0,0,13,0,47,0,0,1,255,253,0,0,0,0,2,0,0,0,255,228,0,0,0,0,
  // 0x53cc  双
  204,83,37,35,94,40,1,252,10,170,170,169,2,170,170,170,164,0,31,255,255,255,199,255,255,255,255,0,31,255,255,255,199,255,255,255,254,0,31,255,255,255,199,255,255,255,253,0,0,0,0,63,194,252,0,1,253,0,0,0,0,63,129,252,0,2,252,0,0,0,0,63,128,253,0,2,252,0,0,0,0,127,64,254,0,3,252,0,1,192,0,191,0,255,0,3,248,0,11,240,0,191,0,191,0,7,244,0,15,248,0,255,0,127,0,11,240,0,3,254,0,254,0,63,64,15,240,0,1,255,65,253,0,63,128,15,224,0,0,127,195,252,0,63,192,47,208,0,0,47,243,252,0,47,192,63,192,0,0,15,255,248,0,15,208,127,128,0,0,3,255,244,0,15,240,191,64,0,0,1,255,240,0,11,240,255,0,0,0,0,255,224,0,7,250,254,0,0,0,0,63,224,0,3,255,252,0,0,0,0,127,240,0,2,255,248,0,0,0,0,191,252,0,0,255,240,0,0,0,0,255,254,0,0,191,224,0,0,0,2,255,255,0,0,191,192,0,0,0,7,252,255,128,1,255,224,0,0,0,15,248,63,208,7,255,244,0,0,0,47,240,47,240,31,255,252,0,0,0,127,208,15,192,127,247,255,0,0,1,255,128,11,1,255,208,255,192,0,3,255,0,0,11,255,64,127,240,0,15,253,0,0,127,253,0,47,254,0,127,244,0,2,255,244,0,11,255,192,63,224,0,0,255,128,0,1,255,64,15,64,0,0,125,0,0,0,62,0,1,0,0,0,32,0,0,0,8,0,
  // 0x53cd  反
  205,83,36,36,68,40,2,252,0,42,170,170,170,170,170,170,160,0,127,255,255,255,255,255,255,240,0,127,255,255,255,255,255,255,240,0,127,255,255,255,255,255,255,240,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,255,255,255,255,255,253,0,0,127,255,255,255,255,255,255,0,0,127,255,255,255,255,255,254,0,0,127,239,254,170,170,171,253,0,0,127,67,252,0,0,3,252,0,0,127,66,253,0,0,11,248,0,0,127,1,255,0,0,15,240,0,0,191,0,255,64,0,47,224,0,0,191,0,127,192,0,63,208,0,0,255,0,63,208,0,255,192,0,0,255,0,31,244,2,255,0,0,0,254,0,11,252,11,254,0,0,0,253,0,3,255,31,252,0,0,1,253,0,1,255,255,240,0,0,2,252,0,0,191,255,208,0,0,3,252,0,0,47,255,64,0,0,3,248,0,0,47,255,64,0,0,11,244,0,1,255,255,240,0,0,15,240,0,15,255,255,254,0,0,31,224,1,255,254,31,255,228,0,63,208,111,255,244,3,255,255,144,127,195,255,255,128,0,127,255,253,191,65,255,248,0,0,7,255,252,31,0,191,64,0,0,0,111,240,0,0,32,0,0,0,0,1,144,
  // 0x53d6  取
  214,83,38,36,104,40,1,252,21,85,85,85,85,64,0,0,0,0,63,255,255,255,255,128,0,0,0,0,63,255,255,255,255,128,0,0,0,0,63,255,255,255,255,234,170,170,169,0,0,254,0,11,241,255,255,255,255,64,0,254,0,11,241,255,255,255,255,0,0,254,0,11,241,255,255,255,255,0,0,254,0,11,240,26,0,0,255,0,0,254,0,11,240,255,0,0,254,0,0,255,255,255,240,191,0,0,254,0,0,255,255,255,240,127,64,1,253,0,0,255,255,255,240,63,128,2,252,0,0,254,85,95,240,63,192,3,252,0,0,254,0,11,240,47,192,3,248,0,0,254,0,11,240,31,208,7,244,0,0,254,0,11,240,15,224,11,240,0,0,254,0,11,240,15,240,15,240,0,0,254,85,95,240,11,244,31,224,0,0,255,255,255,240,3,248,47,192,0,0,255,255,255,240,3,252,63,192,0,0,255,255,255,240,1,253,191,128,0,0,254,0,11,240,0,255,255,0,0,0,254,0,11,240,0,191,254,0,0,0,254,0,11,240,0,63,252,0,0,0,254,0,11,240,0,47,248,0,0,0,254,0,111,240,0,47,244,0,0,0,255,255,255,240,0,127,253,0,0,191,255,255,255,240,0,255,255,0,0,191,255,255,255,240,3,255,255,192,0,127,255,229,11,240,15,252,127,240,0,62,80,0,11,240,127,240,31,252,0,0,0,0,11,242,255,192,11,255,128,0,0,0,11,255,255,64,2,255,224,0,0,0,11,243,248,0,0,127,192,0,0,0,11,241,208,0,0,15,0,0,0,0,11,224,0,0,0,0,0,
  // 0x53d8  变
  216,83,36,38,86,40,2,252,0,0,0,1,188,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,191,192,0,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,21,85,86,253,85,127,149,85,84,0,0,2,252,0,127,64,0,0,0,15,146,252,0,127,66,128,0,0,31,210,252,0,127,95,224,0,0,63,194,252,0,127,79,248,0,0,191,66,252,0,127,67,254,0,0,255,2,252,0,127,64,255,128,3,253,2,252,0,127,64,63,208,15,248,2,252,0,127,64,31,240,31,240,2,252,0,127,64,7,248,7,192,2,252,0,127,64,2,208,0,0,2,252,0,127,64,0,0,0,0,1,168,0,42,64,0,0,0,0,0,0,0,0,0,64,0,2,255,255,255,255,255,255,244,0,2,255,255,255,255,255,255,252,0,2,255,255,255,255,255,255,244,0,0,3,252,0,0,0,63,224,0,0,1,255,0,0,0,255,192,0,0,0,127,192,0,3,255,0,0,0,0,47,244,0,31,252,0,0,0,0,11,255,0,191,240,0,0,0,0,1,255,235,255,128,0,0,0,0,0,63,255,253,0,0,0,0,0,0,31,255,244,0,0,0,0,0,27,255,255,255,208,0,0,0,26,255,255,235,255,255,148,0,111,255,255,253,0,191,255,255,249,127,255,255,64,0,6,255,255,253,63,254,144,0,0,0,6,255,252,30,64,0,0,0,0,0,5,176,
  // 0x53f0  台
  240,83,36,38,86,40,2,252,0,0,0,120,0,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,253,0,0,16,0,0,0,0,11,252,0,0,184,0,0,0,0,15,244,0,3,254,0,0,0,0,47,224,0,2,255,192,0,0,0,63,192,0,0,191,240,0,0,0,255,64,0,0,31,252,0,0,1,255,0,0,0,7,255,0,0,3,254,86,170,191,255,255,128,127,255,255,255,255,255,255,255,224,127,255,255,255,255,255,255,255,244,63,255,255,255,255,255,234,175,252,63,250,169,85,0,0,0,3,255,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,0,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,170,170,170,170,170,164,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,234,170,170,170,171,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,192,0,0,0,3,252,0,0,42,128,0,0,0,2,168,0,
  // 0x5403  吃
  3,84,36,37,77,40,3,253,0,0,0,0,9,64,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,255,255,252,0,191,64,0,0,0,255,255,252,0,255,0,0,0,0,255,255,252,1,255,255,255,255,248,255,170,252,3,255,255,255,255,248,253,1,252,7,255,255,255,255,248,253,1,252,15,249,85,85,85,84,253,1,252,47,224,0,0,0,0,253,1,252,127,192,0,0,0,0,253,1,253,255,128,0,0,0,0,253,1,254,255,0,0,0,0,0,253,1,252,189,85,85,85,84,0,253,1,252,20,255,255,255,255,64,253,1,252,0,255,255,255,255,64,253,1,252,0,255,255,255,253,0,253,1,252,0,0,0,191,240,0,253,1,252,0,0,2,255,192,0,253,1,252,0,0,11,254,0,0,253,1,252,0,0,63,248,0,0,253,1,252,0,0,255,208,0,0,253,1,252,0,3,255,64,0,0,255,255,252,0,15,252,0,0,0,255,255,252,0,63,240,0,0,0,255,255,252,0,255,192,0,0,0,255,170,168,2,255,0,0,0,64,253,0,0,7,252,0,0,0,249,253,0,0,15,240,0,0,0,254,253,0,0,31,208,0,0,0,253,0,0,0,47,192,0,0,0,253,0,0,0,63,192,0,0,1,252,0,0,0,47,254,170,170,171,252,0,0,0,31,255,255,255,255,248,0,0,0,7,255,255,255,255,240,0,0,0,0,191,255,255,255,128,
  // 0x5408  合
  8,84,38,38,124,40,1,252,0,0,0,0,106,128,0,0,0,0,0,0,0,0,255,224,0,0,0,0,0,0,0,2,255,244,0,0,0,0,0,0,0,7,255,252,0,0,0,0,0,0,0,31,251,255,0,0,0,0,0,0,0,63,240,255,192,0,0,0,0,0,0,255,192,127,240,0,0,0,0,0,3,255,64,31,252,0,0,0,0,0,15,253,0,7,255,64,0,0,0,0,127,244,0,1,255,208,0,0,0,1,255,208,0,0,127,248,0,0,0,11,255,64,0,0,15,255,64,0,0,63,253,0,0,0,3,255,224,0,2,255,249,85,85,85,85,255,254,0,31,255,127,255,255,255,255,223,255,208,127,252,63,255,255,255,255,195,255,208,47,208,63,255,255,255,255,192,127,128,15,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,85,85,85,85,85,84,0,0,0,3,255,255,255,255,255,253,0,0,0,3,255,255,255,255,255,253,0,0,0,3,255,255,255,255,255,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,255,255,255,255,255,253,0,0,0,3,255,255,255,255,255,253,0,0,0,3,255,255,255,255,255,253,0,0,0,3,249,85,85,85,86,253,0,0,0,3,244,0,0,0,1,253,0,0,
  // 0x540d  名
  13,84,35,38,86,40,1,252,0,0,0,46,144,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,7,255,255,255,255,0,0,0,0,31,255,255,255,255,192,0,0,0,63,255,255,255,255,128,0,0,1,255,213,85,85,255,0,0,0,7,255,0,0,2,255,0,0,0,31,252,0,0,3,253,0,0,0,191,253,0,0,15,248,0,0,7,255,255,128,0,31,240,0,0,47,255,255,240,0,63,208,0,0,63,248,63,252,0,255,192,0,0,15,208,11,255,3,255,0,0,0,6,0,2,255,203,253,0,0,0,0,0,0,127,255,244,0,0,0,0,0,0,31,255,224,0,0,0,0,0,0,11,255,128,0,0,0,0,0,0,31,254,0,0,0,0,0,0,0,191,255,255,255,255,244,0,0,7,255,255,255,255,255,244,0,0,63,255,255,255,255,255,244,0,2,255,254,85,85,85,91,244,0,111,255,254,0,0,0,7,244,11,255,254,254,0,0,0,7,244,127,255,224,254,0,0,0,7,244,47,254,0,254,0,0,0,7,244,15,208,0,254,0,0,0,7,244,5,0,0,254,0,0,0,7,244,0,0,0,254,0,0,0,7,244,0,0,0,254,0,0,0,7,244,0,0,0,254,85,85,85,91,244,0,0,0,255,255,255,255,255,244,0,0,0,255,255,255,255,255,244,0,0,0,255,255,255,255,255,244,0,0,0,254,0,0,0,7,244,0,0,0,169,0,0,0,7,244,
  // 0x540e  后
  14,84,38,38,124,40,1,252,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,26,255,64,0,0,0,0,0,5,175,255,255,208,0,0,41,21,175,255,255,255,255,224,0,0,63,255,255,255,255,255,228,0,0,0,63,255,255,255,250,80,0,0,0,0,63,255,233,80,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,234,170,170,170,170,170,170,144,0,63,255,255,255,255,255,255,255,208,0,63,255,255,255,255,255,255,255,208,0,63,255,255,255,255,255,255,255,208,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,0,127,64,85,85,85,85,85,80,0,0,127,65,255,255,255,255,255,240,0,0,191,1,255,255,255,255,255,240,0,0,191,1,255,255,255,255,255,240,0,0,255,1,252,0,0,0,11,240,0,0,255,1,252,0,0,0,11,240,0,0,254,1,252,0,0,0,11,240,0,1,254,1,252,0,0,0,11,240,0,2,253,1,252,0,0,0,11,240,0,3,252,1,252,0,0,0,11,240,0,3,248,1,252,0,0,0,11,240,0,11,244,1,252,0,0,0,11,240,0,15,240,1,254,85,85,85,95,240,0,47,224,1,255,255,255,255,255,240,0,63,192,1,255,255,255,255,255,240,0,127,128,1,255,255,255,255,255,240,0,31,0,1,252,0,0,0,11,240,0,5,0,1,252,0,0,0,11,240,0,
  // 0x5411  向
  17,84,33,38,86,40,4,252,0,0,0,58,64,0,0,0,0,0,0,0,127,224,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,3,252,0,0,0,0,0,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,255,170,170,170,170,170,170,255,64,254,0,0,0,0,0,0,127,64,254,0,0,0,0,0,0,127,64,254,0,0,0,0,0,0,127,64,254,0,0,0,0,0,0,127,64,254,0,21,85,85,84,0,127,64,254,0,255,255,255,254,0,127,64,254,0,255,255,255,254,0,127,64,254,0,255,255,255,254,0,127,64,254,0,254,0,0,190,0,127,64,254,0,254,0,0,190,0,127,64,254,0,254,0,0,190,0,127,64,254,0,254,0,0,190,0,127,64,254,0,254,0,0,190,0,127,64,254,0,254,0,0,190,0,127,64,254,0,254,0,0,190,0,127,64,254,0,255,255,255,254,0,127,64,254,0,255,255,255,254,0,127,64,254,0,255,255,255,254,0,127,64,254,0,254,85,85,84,0,127,64,254,0,254,0,0,0,0,127,64,254,0,254,0,0,0,0,127,64,254,0,0,0,0,0,0,127,64,254,0,0,0,0,0,0,191,0,254,0,0,0,0,31,255,255,0,254,0,0,0,0,15,255,255,0,254,0,0,0,0,11,255,253,0,253,0,0,0,0,7,250,144,0,
  // 0x5426  否
  38,84,37,36,104,40,1,252,5,85,85,85,85,85,85,85,85,0,15,255,255,255,255,255,255,255,255,64,15,255,255,255,255,255,255,255,255,64,15,255,255,255,255,255,255,255,255,64,0,0,0,0,15,252,0,0,0,0,0,0,0,0,127,244,0,0,0,0,0,0,0,1,255,208,0,0,0,0,0,0,0,11,255,192,0,0,0,0,0,0,0,127,255,193,253,0,0,0,0,0,2,255,255,199,255,208,0,0,0,0,47,255,191,194,255,248,0,0,0,2,255,252,63,192,47,255,128,0,0,47,255,224,63,192,2,255,244,0,7,255,255,0,63,192,0,63,255,0,127,255,244,0,63,192,0,7,255,192,47,255,64,0,63,192,0,0,191,64,15,244,0,0,63,192,0,0,29,0,2,0,0,0,63,192,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,255,64,0,0,15,255,255,255,255,255,255,64,0,0,15,255,255,255,255,255,255,64,0,0,15,240,0,0,0,0,255,64,0,0,15,240,0,0,0,0,191,64,0,0,15,240,0,0,0,0,191,64,0,0,15,240,0,0,0,0,191,64,0,0,15,240,0,0,0,0,191,64,0,0,15,240,0,0,0,0,191,64,0,0,15,240,0,0,0,0,191,64,0,0,15,240,0,0,0,0,255,64,0,0,15,255,255,255,255,255,255,64,0,0,15,255,255,255,255,255,255,64,0,0,15,255,255,255,255,255,255,64,0,0,15,240,0,0,0,0,191,64,0,0,15,224,0,0,0,0,170,0,0,
  // 0x542f  启
  47,84,34,38,86,40,2,252,0,0,0,0,0,0,0,80,0,0,0,0,0,0,5,191,244,0,0,0,0,1,107,255,255,253,0,0,69,175,255,255,255,255,249,0,1,255,255,255,255,255,228,0,0,1,255,255,255,234,80,0,0,0,1,255,169,64,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,255,255,255,255,255,255,255,192,1,255,255,255,255,255,255,255,192,1,255,255,255,255,255,255,255,192,1,253,0,0,0,0,0,63,192,1,253,0,0,0,0,0,63,192,1,253,0,0,0,0,0,63,192,1,253,0,0,0,0,0,63,192,1,253,0,0,0,0,0,63,192,1,255,255,255,255,255,255,255,192,1,255,255,255,255,255,255,255,192,1,255,255,255,255,255,255,255,192,1,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,63,255,255,255,255,255,208,3,248,63,255,255,255,255,255,208,3,248,63,255,255,255,255,255,208,7,244,63,64,0,0,0,31,208,11,240,63,64,0,0,0,31,208,15,240,63,64,0,0,0,31,208,15,224,63,64,0,0,0,31,208,47,208,63,64,0,0,0,31,208,63,192,63,64,0,0,0,31,208,191,128,63,255,255,255,255,255,208,255,0,63,255,255,255,255,255,208,190,0,63,255,255,255,255,255,208,28,0,63,64,0,0,0,31,208,4,0,63,64,0,0,0,26,144,
  // 0x544a  告
  74,84,36,39,95,40,2,251,0,0,0,0,42,128,0,0,0,0,3,248,0,63,192,0,0,0,0,3,252,0,63,192,0,0,0,0,11,248,0,63,192,0,0,0,0,15,240,0,63,192,0,0,0,0,31,224,0,63,192,0,0,0,0,63,255,255,255,255,255,255,128,0,191,255,255,255,255,255,255,128,0,255,255,255,255,255,255,255,128,3,254,85,85,127,213,85,85,64,11,252,0,0,63,192,0,0,0,31,244,0,0,63,192,0,0,0,63,224,0,0,63,192,0,0,0,7,192,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,21,85,85,85,85,85,85,85,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,252,0,0,47,255,255,255,255,255,252,0,0,47,255,255,255,255,255,252,0,0,47,229,85,85,85,87,252,0,0,47,192,0,0,0,2,252,0,0,47,192,0,0,0,2,252,0,0,47,192,0,0,0,2,252,0,0,47,192,0,0,0,2,252,0,0,47,192,0,0,0,2,252,0,0,47,192,0,0,0,2,252,0,0,47,213,85,85,85,87,252,0,0,47,255,255,255,255,255,252,0,0,47,255,255,255,255,255,252,0,0,47,255,255,255,255,255,252,0,0,47,192,0,0,0,2,252,0,0,47,192,0,0,0,2,252,0,0,0,0,0,0,0,0,0,0,
  // 0x5468  周
  104,84,35,37,77,40,1,251,0,127,255,255,255,255,255,255,244,0,127,255,255,255,255,255,255,244,0,127,255,255,255,255,255,255,244,0,127,149,85,85,85,85,91,244,0,127,64,0,26,128,0,7,244,0,127,64,0,47,192,0,7,244,0,127,64,0,47,192,0,7,244,0,127,64,0,47,192,0,7,244,0,127,67,255,255,255,255,7,244,0,127,67,255,255,255,255,7,244,0,127,67,255,255,255,255,7,244,0,127,64,0,47,192,0,7,244,0,127,64,0,47,192,0,7,244,0,127,64,0,47,192,0,7,244,0,127,79,255,255,255,255,135,244,0,127,79,255,255,255,255,135,244,0,127,79,255,255,255,255,135,244,0,127,64,0,0,0,0,7,244,0,127,0,0,0,0,0,7,244,0,127,0,0,0,0,0,7,244,0,191,1,255,255,255,252,7,244,0,191,1,255,255,255,252,7,244,0,255,1,255,255,255,252,7,244,0,254,1,252,0,1,252,7,244,0,254,1,252,0,1,252,7,244,1,253,1,252,0,1,252,7,244,2,252,1,252,0,1,252,7,244,3,252,1,252,0,1,252,7,244,3,248,1,255,255,255,252,7,244,7,244,1,255,255,255,252,7,244,15,240,1,255,255,255,252,7,244,31,240,1,252,0,0,0,7,244,63,208,1,252,0,0,85,95,244,127,192,0,84,0,0,127,255,240,47,64,0,0,0,0,63,255,224,11,0,0,0,0,0,47,254,64,0,0,0,0,0,0,0,0,0,
  // 0x547d  命
  125,84,38,38,124,40,1,252,0,0,0,0,191,192,0,0,0,0,0,0,0,1,255,240,0,0,0,0,0,0,0,3,255,252,0,0,0,0,0,0,0,15,255,255,0,0,0,0,0,0,0,63,241,255,192,0,0,0,0,0,1,255,208,191,240,0,0,0,0,0,7,255,64,47,253,0,0,0,0,0,47,253,0,7,255,128,0,0,0,0,255,240,0,1,255,244,0,0,0,7,255,192,0,0,63,254,0,0,0,47,255,85,85,85,95,255,208,0,2,255,247,255,255,255,253,255,253,0,47,255,131,255,255,255,252,47,255,224,255,253,3,255,255,255,252,3,255,224,63,224,0,0,0,0,0,0,127,192,30,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,192,255,255,255,240,0,0,191,255,255,192,255,255,255,240,0,0,191,255,255,192,255,255,255,240,0,0,191,0,47,192,254,85,91,240,0,0,190,0,31,192,254,0,7,240,0,0,190,0,31,192,254,0,7,240,0,0,190,0,31,192,254,0,7,240,0,0,190,0,31,192,254,0,7,240,0,0,190,0,31,192,254,0,7,240,0,0,190,0,31,192,254,0,7,240,0,0,190,0,31,192,254,0,7,240,0,0,191,255,255,192,254,0,7,240,0,0,191,255,255,192,254,0,11,240,0,0,191,255,255,192,254,15,255,240,0,0,191,0,0,0,254,15,255,240,0,0,190,0,0,0,254,11,255,192,0,0,190,0,0,0,254,1,80,0,0,0,106,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,
  // 0x548c  和
  140,84,35,37,77,40,1,252,0,0,0,31,192,0,0,0,0,0,0,27,255,240,0,0,0,0,1,175,255,255,244,0,0,0,0,31,255,255,254,64,255,255,255,252,15,255,255,64,0,255,255,255,252,11,164,191,64,0,255,255,255,252,0,0,127,64,0,255,170,171,252,0,0,127,64,0,254,0,2,252,0,0,127,64,0,254,0,2,252,0,0,127,64,0,254,0,2,252,0,0,127,64,0,254,0,2,252,63,255,255,255,248,254,0,2,252,63,255,255,255,248,254,0,2,252,63,255,255,255,248,254,0,2,252,21,86,255,149,84,254,0,2,252,0,3,255,64,0,254,0,2,252,0,3,255,208,0,254,0,2,252,0,11,255,240,0,254,0,2,252,0,15,255,252,0,254,0,2,252,0,31,255,255,0,254,0,2,252,0,63,255,191,128,254,0,2,252,0,127,127,111,208,254,0,2,252,0,253,127,79,240,254,0,2,252,2,252,127,71,244,254,0,2,252,7,248,127,66,224,254,0,2,252,15,240,127,64,192,254,0,2,252,47,208,127,64,0,254,0,2,252,191,192,127,64,0,254,0,2,252,127,64,127,64,0,255,255,255,252,62,0,127,64,0,255,255,255,252,28,0,127,64,0,255,255,255,252,0,0,127,64,0,255,170,171,252,0,0,127,64,0,254,0,2,252,0,0,127,64,0,254,0,2,252,0,0,127,64,0,254,0,1,168,0,0,127,64,0,0,0,0,0,0,0,106,0,0,0,0,0,0,
  // 0x54cd  响
  205,84,35,39,95,40,3,251,0,0,0,0,0,41,64,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,192,0,0,255,255,244,0,0,255,64,0,0,255,255,244,0,0,255,0,0,0,255,255,244,0,1,253,0,0,0,254,87,244,63,255,255,255,255,244,253,3,244,63,255,255,255,255,244,253,3,244,63,255,255,255,255,244,253,3,244,63,128,0,0,7,244,253,3,244,63,64,0,0,3,244,253,3,244,63,64,0,0,3,244,253,3,244,63,64,0,0,3,244,253,3,244,63,66,170,170,3,244,253,3,244,63,67,255,255,3,244,253,3,244,63,67,255,255,3,244,253,3,244,63,67,224,31,3,244,253,3,244,63,67,224,31,3,244,253,3,244,63,67,224,31,3,244,253,3,244,63,67,224,31,3,244,253,3,244,63,67,224,31,3,244,253,3,244,63,67,224,31,3,244,254,87,244,63,67,224,31,3,244,255,255,244,63,67,224,31,3,244,255,255,244,63,67,250,191,3,244,255,255,244,63,67,255,255,3,244,253,0,0,63,67,255,255,3,244,253,0,0,63,67,224,0,3,244,253,0,0,63,67,224,0,3,244,253,0,0,63,65,80,0,3,244,0,0,0,63,64,0,0,3,244,0,0,0,63,64,0,0,3,244,0,0,0,63,64,0,0,7,244,0,0,0,63,64,0,1,91,244,0,0,0,63,64,0,7,255,240,0,0,0,63,64,0,3,255,240,0,0,0,63,64,0,2,254,64,0,0,0,0,0,0,0,0,0,
  // 0x55b7  喷
  183,85,36,38,86,40,3,252,0,0,0,0,0,21,0,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,255,255,208,255,255,255,255,255,208,255,255,208,255,255,255,255,255,208,255,255,208,255,255,255,255,255,208,253,95,208,0,0,63,64,0,0,252,11,208,3,244,63,66,244,0,252,11,208,3,244,0,3,248,0,252,11,208,3,244,0,3,248,0,252,11,215,255,255,255,255,255,252,252,11,215,255,255,255,255,255,252,252,11,215,255,255,255,255,255,252,252,11,208,3,244,0,3,248,0,252,11,208,3,244,0,3,248,0,252,11,208,1,80,0,1,80,0,252,11,208,47,255,255,255,255,64,252,11,208,47,255,255,255,255,64,252,11,208,47,255,255,255,255,64,252,11,208,47,128,0,0,63,64,252,11,208,47,128,0,0,63,64,252,11,208,47,128,21,0,63,64,253,95,208,47,128,63,64,63,64,255,255,208,47,128,63,64,63,64,255,255,208,47,128,63,64,63,64,255,255,208,47,128,63,64,63,64,252,0,0,47,128,63,64,63,64,252,0,0,47,128,63,64,63,64,252,0,0,47,128,191,0,63,64,248,0,0,26,65,254,24,42,0,0,0,0,0,7,252,63,128,0,0,0,0,0,127,244,127,249,0,0,0,0,11,255,208,7,255,208,0,0,6,255,254,0,0,191,253,0,0,47,255,224,0,0,11,254,0,0,11,249,0,0,0,0,252,0,0,1,0,0,0,0,0,20,
  // 0x5634  嘴
  52,86,36,38,86,40,3,252,0,0,0,0,252,0,248,0,0,0,0,0,0,252,0,252,0,0,0,0,0,80,252,0,252,0,0,85,85,65,240,252,0,252,11,192,255,255,209,240,254,168,252,127,240,255,255,209,240,255,252,255,255,64,255,255,209,240,255,252,255,248,0,248,11,209,240,252,0,255,64,0,248,11,209,240,252,0,252,0,0,248,11,209,240,252,0,252,0,116,248,11,209,240,253,188,252,0,125,248,11,210,251,255,252,252,0,188,248,11,239,255,255,252,255,255,252,248,11,239,255,255,64,191,255,244,248,11,223,148,255,0,26,170,144,248,11,208,2,255,255,248,0,0,248,11,208,7,255,255,254,0,0,248,11,208,15,245,87,252,0,0,248,11,208,63,192,7,244,0,0,248,11,209,255,213,95,245,85,64,248,11,219,255,255,255,255,255,192,248,11,255,255,255,255,255,255,192,253,91,239,255,128,47,64,31,192,255,255,215,127,128,47,64,31,192,255,255,208,63,128,47,128,31,192,255,255,208,63,255,255,255,255,192,248,0,0,63,255,255,255,255,192,248,0,0,63,64,47,64,31,192,248,0,0,63,64,47,64,31,192,84,0,0,127,149,127,149,111,192,0,0,0,191,255,255,255,255,192,0,0,0,255,255,255,255,255,192,0,0,1,253,0,0,0,31,192,0,0,7,252,0,0,0,31,192,0,0,31,244,0,0,0,31,192,0,0,191,224,0,0,127,255,192,0,0,63,128,0,0,63,255,128,0,0,9,0,0,0,31,169,0,
  // 0x5668  器
  104,86,38,36,104,40,1,252,0,255,255,255,192,63,255,255,244,0,0,255,255,255,192,63,255,255,244,0,0,255,255,255,192,63,255,255,244,0,0,252,0,47,192,63,64,7,244,0,0,252,0,47,192,63,64,7,244,0,0,252,0,47,192,63,64,7,244,0,0,252,0,47,192,63,64,7,244,0,0,252,0,47,192,63,64,7,244,0,0,255,255,255,192,63,255,255,244,0,0,255,255,255,192,63,255,255,244,0,0,255,255,255,253,63,255,255,244,0,0,0,0,0,255,0,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,0,7,252,0,0,0,0,0,63,255,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,255,192,5,85,91,255,85,95,253,85,85,64,0,0,47,252,0,3,255,64,0,0,0,0,255,240,0,1,255,224,0,0,0,11,255,208,0,0,127,253,0,0,1,191,255,0,0,0,15,255,224,0,31,255,248,0,0,0,3,255,255,64,191,255,255,255,192,127,255,255,255,224,47,255,255,255,192,127,255,255,255,192,14,191,255,255,192,127,255,255,235,0,0,190,0,15,192,127,0,15,224,0,0,190,0,15,192,127,0,15,224,0,0,190,0,15,192,127,0,15,224,0,0,190,0,15,192,127,0,15,224,0,0,190,0,15,192,127,0,15,224,0,0,191,255,255,192,127,255,255,224,0,0,191,255,255,192,127,255,255,224,0,0,191,255,255,192,127,255,255,224,0,0,190,0,31,192,127,0,15,224,0,0,106,0,15,192,127,0,10,144,0,
  // 0x5674  噴
  116,86,36,38,86,40,3,252,0,0,0,0,0,47,128,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,47,128,0,0,0,0,0,191,255,255,255,255,224,85,85,80,191,255,255,255,255,224,255,255,240,106,170,191,234,170,144,255,255,240,0,0,47,128,0,0,255,255,240,2,248,47,130,244,0,252,3,240,2,248,47,130,244,0,252,3,246,171,254,170,171,254,168,252,3,247,255,255,255,255,255,253,252,3,247,255,255,255,255,255,253,252,3,240,2,248,0,2,244,0,252,3,240,2,248,0,2,244,0,252,3,240,0,0,0,0,0,0,252,3,240,63,255,255,255,255,128,252,3,240,63,255,255,255,255,128,252,3,240,63,128,0,0,63,128,252,3,240,63,128,0,0,63,128,252,3,240,63,128,0,0,63,128,252,3,240,63,255,255,255,255,128,252,3,240,63,255,255,255,255,128,252,3,240,63,128,0,0,63,128,255,255,240,63,128,0,0,63,128,255,255,240,63,128,0,0,63,128,255,255,240,63,255,255,255,255,128,253,85,80,63,255,255,255,255,128,252,0,0,63,128,0,0,63,128,252,0,0,63,128,0,0,63,128,168,0,0,63,255,255,255,255,128,0,0,0,63,255,255,255,255,128,0,0,0,0,185,0,31,144,0,0,0,0,2,255,64,63,244,0,0,0,0,111,253,0,31,255,0,0,0,27,255,240,0,1,255,224,0,0,127,255,64,0,0,47,253,0,0,31,228,0,0,0,7,248,0,0,10,0,0,0,0,0,128,
  // 0x56de  回
  222,86,34,36,68,40,3,252,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,63,255,255,255,128,31,224,191,0,63,255,255,255,128,31,224,191,0,63,255,255,255,128,31,224,191,0,63,149,85,127,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,255,255,255,128,31,224,191,0,63,255,255,255,128,31,224,191,0,63,255,255,255,128,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,149,85,85,85,85,85,111,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,15,224,
  // 0x56e0  因
  224,86,34,36,68,40,3,252,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,170,170,170,170,170,170,175,240,191,0,0,0,0,0,0,15,240,191,0,0,3,248,0,0,15,240,191,0,0,3,248,0,0,15,240,191,0,0,3,244,0,0,15,240,191,0,0,3,244,0,0,15,240,191,0,0,3,244,0,0,15,240,191,0,0,3,244,0,0,15,240,191,15,255,255,255,255,255,15,240,191,15,255,255,255,255,255,15,240,191,15,255,255,255,255,255,15,240,191,5,85,95,254,85,85,15,240,191,0,0,15,254,0,0,15,240,191,0,0,15,255,0,0,15,240,191,0,0,31,255,0,0,15,240,191,0,0,63,255,128,0,15,240,191,0,0,127,159,208,0,15,240,191,0,0,255,15,240,0,15,240,191,0,1,255,11,248,0,15,240,191,0,7,252,3,254,0,15,240,191,0,31,244,0,255,128,15,240,191,0,255,224,0,191,244,15,240,191,11,255,128,0,47,255,15,240,191,15,254,0,0,7,254,15,240,191,7,224,0,0,0,252,15,240,191,2,64,0,0,0,20,15,240,191,0,0,0,0,0,0,15,240,191,170,170,170,170,170,170,175,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,0,0,0,0,0,0,15,240,191,0,0,0,0,0,0,15,224,
  // 0x56fa  固
  250,86,34,36,68,40,3,252,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,149,85,85,85,85,85,111,224,191,0,0,0,0,0,0,15,224,191,0,0,3,248,0,0,15,224,191,0,0,3,248,0,0,15,224,191,0,0,3,248,0,0,15,224,191,0,0,3,248,0,0,15,224,191,11,255,255,255,255,255,15,224,191,11,255,255,255,255,255,15,224,191,11,255,255,255,255,255,15,224,191,0,0,3,248,0,0,15,224,191,0,0,3,248,0,0,15,224,191,0,0,3,248,0,0,15,224,191,0,0,3,248,0,0,15,224,191,0,0,3,248,0,0,15,224,191,0,127,255,255,255,224,15,224,191,0,127,255,255,255,224,15,224,191,0,127,255,255,255,224,15,224,191,0,127,0,0,15,224,15,224,191,0,127,0,0,15,224,15,224,191,0,127,0,0,15,224,15,224,191,0,127,0,0,15,224,15,224,191,0,127,255,255,255,224,15,224,191,0,127,255,255,255,224,15,224,191,0,127,255,255,255,224,15,224,191,0,0,0,0,0,0,15,224,191,0,0,0,0,0,0,15,224,191,0,0,0,0,0,0,15,224,191,149,85,85,85,85,85,111,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,0,0,0,0,0,0,15,224,127,0,0,0,0,0,0,15,224,
  // 0x56fe  图
  254,86,34,36,68,40,3,252,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,85,85,85,85,85,85,95,224,191,0,0,61,0,0,0,15,224,191,0,0,255,0,0,0,15,224,191,0,2,253,0,0,0,15,224,191,0,11,255,255,255,244,15,224,191,0,47,255,255,255,252,15,224,191,0,191,255,255,255,244,15,224,191,3,255,208,0,47,208,15,224,191,31,255,244,0,255,128,15,224,191,47,226,254,7,253,0,15,224,191,7,64,191,255,240,0,15,224,191,0,0,31,255,192,0,15,224,191,0,0,127,255,224,0,15,224,191,0,27,255,255,255,64,15,224,191,7,255,254,7,255,254,79,224,191,191,255,224,0,127,255,223,224,191,63,254,41,0,2,255,79,224,191,31,64,191,228,0,6,15,224,191,0,0,191,255,208,0,15,224,191,0,0,1,255,248,0,15,224,191,0,0,0,7,240,0,15,224,191,0,46,144,0,80,0,15,224,191,0,127,255,228,0,0,15,224,191,0,191,255,255,228,0,15,224,191,0,0,107,255,255,208,15,224,191,0,0,0,27,255,192,15,224,191,0,0,0,0,31,128,15,224,191,0,0,0,0,0,0,15,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,85,85,85,85,85,85,95,224,191,0,0,0,0,0,0,15,224,
  // 0x5728  在
  40,87,37,38,124,40,1,252,0,0,0,10,64,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,127,128,0,0,0,0,0,31,255,255,255,255,255,255,255,255,64,31,255,255,255,255,255,255,255,255,64,31,255,255,255,255,255,255,255,255,64,26,170,171,254,170,170,170,170,170,64,0,0,15,244,0,0,0,0,0,0,0,0,31,240,0,1,80,0,0,0,0,0,63,208,0,7,244,0,0,0,0,0,127,192,0,7,244,0,0,0,0,0,255,64,0,7,244,0,0,0,0,3,254,0,0,7,244,0,0,0,0,11,252,0,0,7,244,0,0,0,0,31,244,0,0,7,244,0,0,0,0,127,240,0,0,7,244,0,0,0,1,255,240,15,255,255,255,255,252,0,7,255,240,15,255,255,255,255,252,0,47,255,240,15,255,255,255,255,252,0,127,251,240,5,85,91,249,85,84,0,63,203,240,0,0,7,244,0,0,0,31,11,240,0,0,7,244,0,0,0,8,11,240,0,0,7,244,0,0,0,0,11,240,0,0,7,244,0,0,0,0,11,240,0,0,7,244,0,0,0,0,11,240,0,0,7,244,0,0,0,0,11,240,0,0,7,244,0,0,0,0,11,240,0,0,7,244,0,0,0,0,11,240,0,0,7,244,0,0,0,0,11,240,0,0,7,244,0,0,0,0,11,240,21,85,91,249,85,85,0,0,11,240,127,255,255,255,255,255,64,0,11,240,127,255,255,255,255,255,64,0,11,240,127,255,255,255,255,255,64,0,11,240,0,0,0,0,0,0,0,
  // 0x574f  坏
  79,87,38,38,124,40,1,252,0,5,64,0,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,0,15,208,26,170,170,170,170,170,128,0,15,208,63,255,255,255,255,255,192,0,15,208,63,255,255,255,255,255,192,0,15,208,63,255,255,255,255,255,192,0,15,208,0,0,0,127,192,0,0,0,15,208,0,0,0,255,64,0,0,0,15,208,0,0,2,255,0,0,0,0,15,208,0,0,3,253,0,0,0,63,255,255,208,0,11,252,0,0,0,63,255,255,208,0,47,244,0,0,0,63,255,255,208,0,127,244,64,0,0,26,175,234,128,0,255,246,240,0,0,0,15,208,0,3,255,255,253,0,0,0,15,208,0,31,255,251,255,128,0,0,15,208,0,127,251,244,191,224,0,0,15,208,2,255,195,244,47,248,0,0,15,208,15,255,3,244,7,255,0,0,15,208,191,252,3,244,1,255,192,0,15,209,255,240,3,244,0,127,224,0,15,208,127,128,3,244,0,31,192,0,15,208,29,0,3,244,0,7,0,0,15,208,80,0,3,244,0,0,0,0,15,219,240,0,3,244,0,0,0,0,15,255,240,0,3,244,0,0,0,0,127,255,240,0,3,244,0,0,0,31,255,255,128,0,3,244,0,0,0,127,255,244,0,0,3,244,0,0,0,63,254,0,0,0,3,244,0,0,0,63,144,0,0,0,3,244,0,0,0,20,0,0,0,0,3,244,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,2,164,0,0,0,
  // 0x5757  块
  87,87,37,38,124,40,1,252,0,0,0,0,0,5,64,0,0,0,0,31,192,0,0,31,208,0,0,0,0,31,192,0,0,31,208,0,0,0,0,31,192,0,0,31,208,0,0,0,0,31,192,0,0,31,208,0,0,0,0,31,192,0,0,31,208,0,0,0,0,31,192,0,0,31,208,0,0,0,0,31,192,3,255,255,255,255,240,0,0,31,192,3,255,255,255,255,240,0,0,31,192,3,255,255,255,255,240,0,63,255,255,209,85,111,229,91,240,0,63,255,255,208,0,31,208,7,240,0,63,255,255,208,0,31,208,7,240,0,26,175,234,128,0,31,208,7,240,0,0,31,192,0,0,31,208,7,240,0,0,31,192,0,0,31,208,7,240,0,0,31,192,0,0,31,192,7,240,0,0,31,192,0,0,31,192,7,240,0,0,31,192,10,170,175,234,171,250,64,0,31,192,15,255,255,255,255,255,192,0,31,192,15,255,255,255,255,255,192,0,31,192,15,255,255,255,255,255,192,0,31,193,208,0,63,253,0,0,0,0,31,239,224,0,127,255,0,0,0,0,31,255,240,0,255,127,64,0,0,0,127,255,208,0,255,63,128,0,0,11,255,253,0,2,253,47,192,0,0,127,255,208,0,7,252,15,240,0,0,63,253,0,0,15,248,11,248,0,0,47,208,0,0,47,240,3,252,0,0,13,0,0,0,127,208,2,255,0,0,0,0,0,2,255,192,0,255,192,0,0,0,0,11,255,0,0,127,244,0,0,0,0,127,252,0,0,31,255,0,0,0,2,255,240,0,0,7,255,192,0,0,3,255,128,0,0,1,255,128,0,0,0,253,0,0,0,0,63,0,0,0,0,80,0,0,0,0,8,0,
  // 0x578b  型
  139,87,36,37,77,40,2,253,0,0,0,0,0,0,0,5,80,5,85,85,85,85,0,0,11,240,15,255,255,255,255,2,160,11,240,15,255,255,255,255,3,244,11,240,15,255,255,255,255,3,244,11,240,0,31,192,63,128,3,244,11,240,0,31,192,63,128,3,244,11,240,0,31,192,63,128,3,244,11,240,0,31,192,63,128,3,244,11,240,0,31,192,63,128,3,244,11,240,127,255,255,255,255,195,244,11,240,127,255,255,255,255,195,244,11,240,127,255,255,255,255,195,244,11,240,21,127,149,127,213,67,244,11,240,0,63,64,63,128,3,244,11,240,0,191,0,63,128,3,244,11,240,0,255,0,63,128,0,0,11,240,2,253,0,63,128,0,0,11,240,11,252,0,63,128,0,0,15,240,47,244,0,63,128,0,63,255,224,191,224,0,63,128,0,31,255,208,47,64,0,63,234,0,15,255,64,9,0,0,0,255,0,5,64,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,85,85,85,255,85,85,85,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,85,85,85,85,85,85,
  // 0x57ab  垫
  171,87,37,37,114,40,2,253,0,11,224,0,0,127,0,0,0,0,0,15,224,0,0,127,0,0,0,0,0,15,224,0,0,127,0,0,0,0,0,15,224,0,0,127,0,0,0,0,191,255,255,245,255,255,255,255,0,0,191,255,255,245,255,255,255,255,0,0,191,255,255,245,255,255,255,255,0,0,21,95,245,80,0,255,0,191,0,0,0,15,224,0,0,254,0,127,0,0,0,15,224,0,16,254,0,127,0,0,0,15,224,100,253,253,0,127,0,0,0,15,255,249,255,252,0,127,0,0,6,255,255,248,255,252,0,127,0,0,255,255,255,228,31,254,0,127,0,0,191,255,244,0,7,255,192,127,0,0,191,159,224,0,11,255,244,127,0,0,16,15,224,0,15,255,254,63,13,0,0,15,224,0,63,194,253,63,15,192,0,15,224,0,255,128,120,63,79,192,0,15,224,7,255,0,16,47,239,128,15,255,224,31,252,0,0,31,255,64,15,255,208,11,240,0,0,11,255,0,11,255,64,3,233,0,0,2,248,0,1,64,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,255,255,255,255,255,255,255,0,0,0,255,255,255,255,255,255,255,0,0,0,255,255,255,255,255,255,255,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,191,255,255,255,255,255,255,255,255,0,191,255,255,255,255,255,255,255,255,0,191,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,
  // 0x586b  填
  107,88,38,38,124,40,1,252,0,0,0,0,0,3,248,0,0,0,0,31,192,0,0,3,248,0,0,0,0,31,192,0,0,3,248,0,0,0,0,31,192,63,255,255,255,255,255,192,0,31,192,63,255,255,255,255,255,192,0,31,192,63,255,255,255,255,255,192,0,31,192,0,0,3,248,0,0,0,0,31,192,0,0,3,248,0,0,0,0,31,192,0,0,3,248,0,0,0,0,31,192,0,255,255,255,255,240,0,63,255,255,192,255,255,255,255,240,0,63,255,255,192,254,85,85,95,240,0,63,255,255,192,253,0,0,11,240,0,26,175,234,128,253,85,85,91,240,0,0,31,192,0,255,255,255,255,240,0,0,31,192,0,255,255,255,255,240,0,0,31,192,0,253,0,0,11,240,0,0,31,192,0,253,0,0,11,240,0,0,31,192,0,255,255,255,255,240,0,0,31,192,0,255,255,255,255,240,0,0,31,192,0,254,85,85,95,240,0,0,31,192,0,253,0,0,11,240,0,0,31,192,0,254,85,85,95,240,0,0,31,199,208,255,255,255,255,240,0,0,31,255,224,255,255,255,255,240,0,0,47,255,240,0,0,0,0,0,0,2,255,255,128,0,0,0,0,0,0,127,255,249,255,255,255,255,255,255,208,127,255,64,255,255,255,255,255,255,208,63,244,0,255,255,255,255,255,255,208,46,64,0,0,1,0,0,96,0,0,0,0,0,0,15,228,1,252,0,0,0,0,0,0,127,240,3,255,128,0,0,0,0,7,255,128,0,191,244,0,0,0,0,191,253,0,0,15,254,0,0,0,3,255,224,0,0,2,255,192,0,0,0,255,64,0,0,0,127,128,0,0,0,36,0,0,0,0,8,0,
  // 0x58f3  壳
  243,88,36,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,255,255,248,63,255,255,255,255,255,255,255,248,63,255,255,255,255,255,255,255,248,63,128,0,0,0,0,0,3,248,63,128,0,0,0,0,0,3,248,63,130,170,170,170,170,170,131,248,63,135,255,255,255,255,255,195,248,0,7,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,248,0,0,0,0,255,255,255,255,248,0,0,0,0,255,255,255,255,248,0,0,0,0,255,0,0,3,248,0,0,0,0,255,0,0,3,248,0,0,0,0,254,0,0,3,248,0,0,0,1,254,0,0,3,248,0,64,0,3,252,0,0,3,248,0,185,0,15,252,0,0,3,248,0,190,0,127,240,0,0,3,248,0,253,6,255,208,0,0,3,253,86,253,127,255,64,0,0,3,255,255,252,63,252,0,0,0,1,255,255,248,31,208,0,0,0,0,127,255,224,9,0,0,0,0,0,0,0,0,
  // 0x5907  备
  7,89,38,38,124,40,1,252,0,0,0,41,64,0,0,0,0,0,0,0,0,127,208,0,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,3,255,64,0,0,64,0,0,0,0,15,255,255,255,255,248,0,0,0,0,63,255,255,255,255,253,0,0,0,0,255,255,255,255,255,248,0,0,0,7,255,128,0,0,63,240,0,0,0,63,255,240,0,1,255,192,0,0,2,255,255,252,0,11,255,0,0,0,11,255,67,255,128,127,248,0,0,0,2,252,0,255,250,255,208,0,0,0,0,144,0,47,255,255,0,0,0,0,0,0,0,11,255,254,0,0,0,0,0,0,1,255,255,255,249,0,0,0,0,1,191,255,251,255,255,249,64,0,6,191,255,255,128,47,255,255,255,144,191,255,255,228,0,1,191,255,255,192,63,255,249,0,0,0,6,255,255,64,47,249,0,0,0,0,0,1,191,0,5,31,255,255,255,255,255,255,0,0,0,31,255,255,255,255,255,255,0,0,0,31,255,255,255,255,255,255,0,0,0,31,224,0,63,192,0,255,0,0,0,31,208,0,63,192,0,255,0,0,0,31,208,0,63,192,0,255,0,0,0,31,208,0,63,192,0,255,0,0,0,31,255,255,255,255,255,255,0,0,0,31,255,255,255,255,255,255,0,0,0,31,255,255,255,255,255,255,0,0,0,31,208,0,63,192,0,255,0,0,0,31,208,0,63,192,0,255,0,0,0,31,208,0,63,192,0,255,0,0,0,31,255,255,255,255,255,255,0,0,0,31,255,255,255,255,255,255,0,0,0,31,255,255,255,255,255,255,0,0,0,31,224,0,0,0,0,255,0,0,0,26,144,0,0,0,0,106,0,0,
  // 0x590d  复
  13,89,27,38,10,40,6,252,0,1,144,0,0,0,0,0,3,252,0,0,0,0,0,7,248,0,0,0,0,0,15,240,0,0,0,0,0,47,255,255,255,255,192,0,63,255,255,255,255,192,0,255,255,255,255,255,192,2,255,0,0,0,0,0,11,252,0,0,0,0,0,47,253,85,85,85,84,0,127,255,255,255,255,252,0,47,239,255,255,255,252,0,10,47,192,0,2,252,0,0,47,192,0,2,252,0,0,47,255,255,255,252,0,0,47,255,255,255,252,0,0,47,213,85,86,252,0,0,47,192,0,2,252,0,0,47,192,0,2,252,0,0,47,255,255,255,252,0,0,47,255,255,255,252,0,0,21,127,229,85,84,0,0,0,127,192,0,0,0,0,0,255,234,170,160,0,0,7,255,255,255,253,0,0,31,255,255,255,248,0,0,255,240,0,15,240,0,7,255,252,0,63,208,0,63,253,255,64,255,192,0,31,224,63,227,255,0,0,7,64,15,255,248,0,0,0,0,3,255,240,0,0,0,0,47,255,254,0,0,0,7,255,255,255,245,0,6,255,255,146,255,255,248,47,255,248,0,31,255,240,15,254,64,0,1,191,224,6,64,0,0,0,1,128,
  // 0x5916  外
  22,89,38,38,124,40,1,252,0,0,25,0,0,0,26,144,0,0,0,0,63,192,0,0,31,208,0,0,0,0,63,192,0,0,31,208,0,0,0,0,127,64,0,0,31,208,0,0,0,0,191,0,0,0,31,208,0,0,0,0,255,0,0,0,31,208,0,0,0,1,255,170,169,0,31,208,0,0,0,3,255,255,255,192,31,208,0,0,0,7,255,255,255,192,31,208,0,0,0,11,255,255,255,192,31,208,0,0,0,15,240,0,63,228,31,208,0,0,0,63,208,0,127,252,31,208,0,0,0,127,192,0,127,254,31,208,0,0,0,255,64,0,191,191,95,208,0,0,2,255,0,0,255,63,239,208,0,0,7,255,0,0,253,31,255,208,0,0,15,255,208,2,252,11,255,208,0,0,63,255,252,3,252,3,255,208,0,0,191,223,255,71,248,0,255,208,0,0,47,66,255,235,240,0,127,240,0,0,6,0,63,255,240,0,31,252,0,0,0,0,11,255,208,0,31,255,64,0,0,0,2,255,192,0,31,255,224,0,0,0,0,255,64,0,31,255,252,0,0,0,1,255,0,0,31,239,255,128,0,0,3,253,0,0,31,211,255,240,0,0,11,252,0,0,31,208,191,192,0,0,31,244,0,0,31,208,15,64,0,0,63,224,0,0,31,208,1,0,0,0,255,192,0,0,31,208,0,0,0,3,255,0,0,0,31,208,0,0,0,31,253,0,0,0,31,208,0,0,0,127,244,0,0,0,31,208,0,0,3,255,208,0,0,0,31,208,0,0,31,255,64,0,0,0,31,208,0,0,15,252,0,0,0,0,31,208,0,0,3,224,0,0,0,0,31,208,0,0,0,64,0,0,0,0,26,144,0,0,
  // 0x591a  多
  26,89,34,38,86,40,3,252,0,0,0,6,64,0,0,0,0,0,0,0,31,248,0,0,0,0,0,0,0,127,240,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,11,255,255,255,254,0,0,0,0,63,255,255,255,255,128,0,0,2,255,255,255,255,255,0,0,0,47,255,0,0,3,252,0,0,2,255,252,0,0,15,248,0,0,127,255,255,128,0,63,224,0,0,127,249,191,244,1,255,128,0,0,31,128,31,255,11,254,0,0,0,4,0,2,255,255,248,0,0,0,0,0,0,63,255,208,0,0,0,0,0,0,47,255,121,0,0,0,0,0,7,255,244,255,192,0,0,0,0,191,255,131,255,0,0,0,0,111,255,248,31,253,0,0,0,111,255,255,128,191,255,255,255,208,255,255,228,7,255,255,255,255,240,127,249,0,63,255,255,255,255,224,62,64,2,255,224,0,0,127,192,0,0,111,255,64,0,0,255,128,0,7,255,255,128,0,2,255,0,0,191,255,255,244,0,11,252,0,0,63,248,31,254,0,47,244,0,0,31,128,3,255,192,191,224,0,0,4,0,0,127,247,255,128,0,0,0,0,0,15,255,253,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,31,255,192,0,0,0,0,0,2,255,253,0,0,0,0,0,1,191,255,224,0,0,0,0,1,191,255,254,0,0,0,0,3,255,255,255,208,0,0,0,0,2,255,255,248,0,0,0,0,0,0,255,249,0,0,0,0,0,0,0,165,0,0,0,0,0,0,0,
  // 0x5927  大
  39,89,36,38,86,40,2,252,0,0,0,0,170,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,253,0,0,0,0,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,253,0,0,0,7,255,192,0,0,0,0,0,0,11,255,224,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,31,255,244,0,0,0,0,0,0,47,231,252,0,0,0,0,0,0,63,211,253,0,0,0,0,0,0,127,193,255,0,0,0,0,0,0,255,128,255,128,0,0,0,0,2,255,0,191,192,0,0,0,0,3,254,0,63,240,0,0,0,0,15,252,0,31,244,0,0,0,0,47,244,0,11,253,0,0,0,0,127,224,0,3,255,0,0,0,1,255,192,0,1,255,192,0,0,11,255,0,0,0,191,244,0,0,47,253,0,0,0,63,253,0,1,255,244,0,0,0,15,255,192,31,255,208,0,0,0,3,255,248,191,255,0,0,0,0,0,191,255,127,248,0,0,0,0,0,31,252,31,128,0,0,0,0,0,2,244,5,0,0,0,0,0,0,0,32,
  // 0x5929  天
  41,89,37,35,94,40,2,252,127,255,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,255,253,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,31,255,255,255,255,255,255,255,244,0,31,255,255,255,255,255,255,255,244,0,31,255,255,255,255,255,255,255,244,0,15,255,255,255,255,255,255,255,244,0,0,0,0,3,255,192,0,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,0,11,255,240,0,0,0,0,0,0,0,15,255,244,0,0,0,0,0,0,0,31,247,252,0,0,0,0,0,0,0,63,227,253,0,0,0,0,0,0,0,191,193,255,0,0,0,0,0,0,2,255,128,255,192,0,0,0,0,0,11,255,0,63,240,0,0,0,0,0,47,252,0,31,252,0,0,0,0,0,255,244,0,11,255,64,0,0,0,7,255,208,0,2,255,224,0,0,0,127,255,0,0,0,255,254,0,0,11,255,248,0,0,0,47,255,228,0,255,255,208,0,0,0,7,255,255,64,191,254,0,0,0,0,0,191,254,0,63,224,0,0,0,0,0,11,252,0,25,0,0,0,0,0,0,0,100,0,
  // 0x592a  太
  42,89,37,38,124,40,2,252,0,0,0,1,253,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,0,3,252,0,0,0,0,0,127,255,255,255,255,255,255,255,254,0,127,255,255,255,255,255,255,255,254,0,127,255,255,255,255,255,255,255,254,0,127,255,255,255,255,255,255,255,254,0,0,0,0,11,255,224,0,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,0,15,255,244,0,0,0,0,0,0,0,31,247,248,0,0,0,0,0,0,0,47,227,252,0,0,0,0,0,0,0,63,194,254,0,0,0,0,0,0,0,127,192,255,0,0,0,0,0,0,0,255,128,191,128,0,0,0,0,0,1,255,0,127,192,0,0,0,0,0,3,254,0,63,240,0,0,0,0,0,11,252,0,31,244,0,0,0,0,0,15,248,0,15,252,0,0,0,0,0,63,242,192,3,255,0,0,0,0,0,255,239,244,1,255,128,0,0,0,3,255,159,253,0,255,224,0,0,0,15,255,7,255,64,63,248,0,0,0,127,252,1,255,208,15,255,0,0,2,255,240,0,127,244,7,255,208,0,31,255,192,0,31,253,1,255,253,0,255,254,0,0,7,254,0,63,255,64,191,244,0,0,2,248,0,15,254,0,47,128,0,0,0,144,0,1,252,0,8,0,0,0,0,0,0,0,32,0,
  // 0x5931  失
  49,89,37,38,124,40,2,252,0,0,0,0,254,0,0,0,0,0,0,3,228,0,254,0,0,0,0,0,0,11,248,0,254,0,0,0,0,0,0,15,244,0,254,0,0,0,0,0,0,15,240,0,254,0,0,0,0,0,0,47,224,0,254,0,0,0,0,0,0,63,208,0,254,0,0,0,0,0,0,127,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,255,64,0,1,255,255,255,255,255,255,255,64,0,3,255,255,255,255,255,255,255,64,0,7,252,0,0,254,0,0,0,0,0,15,248,0,0,254,0,0,0,0,0,63,240,0,0,254,0,0,0,0,0,127,208,0,0,254,0,0,0,0,0,31,128,0,1,254,0,0,0,0,0,2,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,170,170,170,171,255,170,170,170,170,0,255,255,255,255,255,255,255,255,254,0,255,255,255,255,255,255,255,255,254,0,255,255,255,255,255,255,255,255,254,0,0,0,0,11,255,208,0,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,0,47,251,248,0,0,0,0,0,0,0,63,211,252,0,0,0,0,0,0,0,255,193,255,0,0,0,0,0,0,2,255,64,255,192,0,0,0,0,0,11,254,0,127,240,0,0,0,0,0,63,252,0,47,252,0,0,0,0,1,255,240,0,11,255,64,0,0,0,11,255,192,0,2,255,224,0,0,0,191,255,0,0,0,255,254,0,0,27,255,248,0,0,0,31,255,248,0,255,255,208,0,0,0,3,255,255,64,191,253,0,0,0,0,0,127,255,0,63,208,0,0,0,0,0,7,252,0,8,0,0,0,0,0,0,0,36,0,
  // 0x5934  头
  52,89,36,38,86,40,2,252,0,0,0,0,1,84,0,0,0,0,0,0,0,3,248,0,0,0,0,3,208,0,3,248,0,0,0,0,15,254,0,3,248,0,0,0,0,15,255,224,3,248,0,0,0,0,1,255,253,3,248,0,0,0,0,0,31,255,67,248,0,0,0,0,0,1,255,3,248,0,0,0,0,0,0,44,3,248,0,0,0,0,128,0,0,3,248,0,0,0,3,248,0,0,7,248,0,0,0,11,255,128,0,7,244,0,0,0,7,255,248,0,7,244,0,0,0,0,127,255,64,7,244,0,0,0,0,7,255,192,11,244,0,0,0,0,0,127,64,11,240,0,0,0,0,0,13,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,85,85,85,85,95,245,85,85,85,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,0,0,0,0,127,128,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,3,253,16,0,0,0,0,0,0,11,252,126,0,0,0,0,0,0,31,244,255,224,0,0,0,0,0,127,224,191,253,0,0,0,0,2,255,192,15,255,192,0,0,0,15,255,0,1,255,248,0,0,0,191,252,0,0,47,255,64,0,27,255,224,0,0,3,255,224,2,255,255,64,0,0,0,127,248,127,255,248,0,0,0,0,15,254,63,255,128,0,0,0,0,2,252,31,228,0,0,0,0,0,0,176,9,0,0,0,0,0,0,0,0,
  // 0x597d  好
  125,89,37,38,124,40,2,252,0,46,128,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,63,128,0,255,255,255,255,240,0,0,63,64,0,255,255,255,255,253,0,0,127,64,0,255,255,255,255,252,0,0,127,0,0,85,85,85,111,244,0,0,191,0,0,0,0,0,63,224,0,0,254,0,0,0,0,0,191,192,0,85,255,85,80,0,0,1,255,0,0,255,255,255,252,0,0,7,252,0,0,255,255,255,252,0,0,31,244,0,0,255,255,255,248,0,1,191,208,0,0,3,248,3,248,0,1,255,64,0,0,3,244,3,248,0,1,253,0,0,0,3,240,3,244,0,1,253,0,0,0,7,240,3,244,0,1,253,0,0,0,11,240,7,246,170,170,254,170,170,0,15,224,11,247,255,255,255,255,255,64,15,208,15,247,255,255,255,255,255,64,31,192,15,231,255,255,255,255,255,64,47,192,31,208,0,1,253,0,0,0,63,128,47,192,0,1,253,0,0,0,63,224,63,192,0,1,253,0,0,0,127,253,63,128,0,1,253,0,0,0,191,255,255,0,0,1,253,0,0,0,126,255,255,0,0,1,253,0,0,0,5,47,254,0,0,1,253,0,0,0,0,7,255,64,0,1,253,0,0,0,0,11,255,224,0,1,253,0,0,0,0,15,255,248,0,1,253,0,0,0,0,63,219,253,0,1,253,0,0,0,0,255,194,253,0,1,253,0,0,0,2,255,0,184,0,1,253,0,0,0,15,253,0,32,0,2,252,0,0,0,127,244,0,0,15,255,252,0,0,0,127,208,0,0,15,255,252,0,0,0,31,64,0,0,7,255,240,0,0,0,8,0,0,0,2,169,0,0,0,0,
  // 0x59cb  始
  203,89,37,38,124,40,2,252,0,26,64,0,0,10,64,0,0,0,0,47,192,0,0,15,240,0,0,0,0,63,128,0,0,31,240,0,0,0,0,63,128,0,0,47,224,0,0,0,0,63,64,0,0,63,192,0,0,0,0,127,0,0,0,63,192,0,0,0,0,191,0,0,0,127,128,0,0,0,0,254,0,0,0,191,0,125,0,0,85,254,85,144,0,255,0,255,0,0,255,255,255,252,1,253,0,127,192,0,255,255,255,252,2,252,0,47,208,0,255,255,255,248,3,248,0,15,240,0,3,248,3,248,7,244,0,7,248,0,3,244,3,244,11,245,170,255,252,0,7,240,3,247,255,255,255,255,254,0,11,240,7,243,255,255,255,255,255,0,15,224,7,243,255,255,255,234,191,128,15,208,11,241,165,64,0,0,63,128,31,192,15,224,0,0,0,0,44,0,47,192,15,208,0,0,0,0,0,0,63,128,31,192,0,0,0,0,0,0,63,128,47,192,31,255,255,255,248,0,127,240,63,192,31,255,255,255,248,0,191,253,127,64,31,255,255,255,248,0,255,255,255,0,31,213,85,87,248,0,45,191,255,0,31,192,0,3,248,0,4,31,254,0,31,192,0,3,248,0,0,7,255,128,31,192,0,3,248,0,0,11,255,224,31,192,0,3,248,0,0,31,255,248,31,192,0,3,248,0,0,63,219,253,31,192,0,3,248,0,0,255,194,253,31,192,0,3,248,0,3,255,0,184,31,213,85,87,248,0,15,253,0,32,31,255,255,255,248,0,127,244,0,0,31,255,255,255,248,0,127,208,0,0,31,255,255,255,248,0,47,64,0,0,31,192,0,3,248,0,8,0,0,0,31,192,0,2,164,0,
  // 0x5b50  子
  80,91,36,35,59,40,2,252,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,170,170,170,170,170,191,252,0,0,0,0,0,0,0,191,240,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,31,254,0,0,0,0,0,0,0,191,244,0,0,0,0,0,0,87,255,192,0,0,0,0,0,0,255,254,0,0,0,0,0,0,0,255,244,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,170,170,170,170,255,170,170,170,170,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,191,255,255,0,0,0,0,0,0,63,255,254,0,0,0,0,0,0,47,255,248,0,0,0,0,0,0,31,234,64,0,0,0,0,
  // 0x5b58  存
  88,91,37,38,124,40,1,252,0,0,0,10,64,0,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,26,170,170,255,234,170,170,170,170,64,31,255,255,255,255,255,255,255,255,64,31,255,255,255,255,255,255,255,255,64,31,255,255,255,255,255,255,255,255,64,0,0,7,252,0,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,0,191,192,255,255,255,255,208,0,0,0,255,64,255,255,255,255,248,0,0,3,254,0,255,255,255,255,240,0,0,11,252,0,85,85,85,255,192,0,0,31,244,0,0,0,2,255,0,0,0,127,240,0,0,0,11,252,0,0,0,255,240,0,0,0,63,240,0,0,7,255,240,0,0,2,255,128,0,0,31,255,240,0,0,2,254,0,0,0,127,255,240,0,0,2,252,0,0,0,63,219,240,42,170,171,254,170,170,128,47,75,240,127,255,255,255,255,255,192,12,11,240,127,255,255,255,255,255,192,0,11,240,127,255,255,255,255,255,192,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,47,255,252,0,0,0,0,11,240,0,31,255,252,0,0,0,0,11,240,0,15,255,240,0,0,0,0,5,80,0,5,85,0,0,0,0,
  // 0x5b89  安
  137,91,36,38,86,40,2,252,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,47,229,85,85,85,85,85,91,248,47,192,0,0,0,0,0,3,248,47,192,0,10,80,0,0,3,248,47,192,0,31,240,0,0,3,248,47,192,0,47,224,0,0,3,248,47,192,0,63,192,0,0,3,248,0,0,0,191,128,0,0,0,0,0,0,0,255,0,0,0,0,0,106,170,171,255,170,170,170,170,169,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,47,224,0,0,191,64,0,0,0,63,192,0,0,255,0,0,0,0,191,128,0,1,255,0,0,0,0,255,0,0,3,253,0,0,0,3,254,0,0,7,252,0,0,0,7,252,0,0,15,244,0,0,0,15,255,144,0,47,240,0,0,0,31,255,254,64,127,208,0,0,0,63,255,255,249,255,128,0,0,0,47,198,255,255,255,0,0,0,0,0,0,27,255,254,0,0,0,0,0,0,2,255,255,224,0,0,0,0,0,47,255,255,254,64,0,0,0,7,255,253,47,255,244,0,0,22,255,255,224,2,255,254,0,31,255,255,254,0,0,47,255,208,15,255,255,144,0,0,2,255,192,3,255,228,0,0,0,0,127,0,2,148,0,0,0,0,0,9,0,
  // 0x5b8c  完
  140,91,37,38,124,40,1,252,0,0,0,0,42,128,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,6,170,170,170,191,234,170,170,169,0,15,255,255,255,255,255,255,255,254,0,15,255,255,255,255,255,255,255,254,0,15,255,255,255,255,255,255,255,254,0,15,240,0,0,0,0,0,0,254,0,15,240,0,0,0,0,0,0,254,0,15,240,0,0,0,0,0,0,254,0,15,240,0,0,0,0,0,0,254,0,15,240,191,255,255,255,255,208,254,0,6,160,191,255,255,255,255,208,169,0,0,0,191,255,255,255,255,208,0,0,0,0,21,85,85,85,85,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,170,170,170,170,170,170,170,170,64,47,255,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,255,128,0,0,3,252,0,31,208,0,0,0,0,0,3,252,0,31,208,0,0,0,0,0,3,252,0,31,208,0,0,0,0,0,7,248,0,31,208,0,0,0,0,0,15,244,0,31,208,0,0,0,0,0,15,240,0,31,208,0,0,0,0,0,63,224,0,31,208,0,30,64,0,0,191,192,0,31,208,0,31,192,0,2,255,128,0,31,208,0,31,192,0,31,255,0,0,31,208,0,47,192,1,255,252,0,0,31,245,85,191,128,127,255,224,0,0,15,255,255,255,64,63,255,64,0,0,11,255,255,255,0,15,244,0,0,0,1,255,255,248,0,5,0,0,0,0,0,0,0,0,0,
  // 0x5b9a  定
  154,91,37,38,124,40,1,252,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,6,170,170,170,191,234,170,170,169,0,11,255,255,255,255,255,255,255,254,0,11,255,255,255,255,255,255,255,254,0,11,255,255,255,255,255,255,255,254,0,11,240,0,0,0,0,0,0,254,0,11,240,0,0,0,0,0,0,254,0,11,240,0,0,0,0,0,0,254,0,11,240,0,0,0,0,0,0,254,0,11,240,170,170,170,170,170,160,254,0,11,240,255,255,255,255,255,244,254,0,0,0,255,255,255,255,255,244,0,0,0,0,255,255,255,255,255,244,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,1,253,0,63,192,0,0,0,0,0,2,253,0,63,192,0,0,0,0,0,3,252,0,63,192,0,0,0,0,0,3,252,0,63,255,255,255,64,0,0,3,248,0,63,255,255,255,64,0,0,7,248,0,63,255,255,255,64,0,0,11,252,0,63,213,85,85,0,0,0,15,253,0,63,192,0,0,0,0,0,31,255,0,63,192,0,0,0,0,0,47,255,128,63,192,0,0,0,0,0,127,255,224,63,192,0,0,0,0,0,255,143,248,63,192,0,0,0,0,1,255,7,255,127,192,0,0,0,0,3,254,1,255,255,192,0,0,0,0,15,252,0,127,255,255,234,170,170,128,63,244,0,15,255,255,255,255,255,128,127,208,0,0,191,255,255,255,255,0,15,128,0,0,5,175,255,255,255,0,2,0,0,0,0,0,0,0,0,0,
  // 0x5ba2  客
  162,91,36,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,21,85,85,85,255,85,85,85,84,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,192,0,36,0,0,0,3,252,63,192,0,255,128,0,0,3,252,63,192,2,255,0,0,0,3,252,63,192,11,255,255,255,253,3,252,63,192,47,255,255,255,255,131,252,0,0,255,255,255,255,255,64,0,0,11,255,192,0,3,254,0,0,0,127,255,240,0,15,248,0,0,7,255,239,252,0,127,240,0,0,11,255,67,255,66,255,128,0,0,3,248,0,255,255,254,0,0,0,0,128,0,47,255,244,0,0,0,0,0,0,15,255,244,0,0,0,0,0,1,191,255,255,144,0,0,0,0,47,255,255,255,254,64,0,0,6,255,255,65,255,255,255,148,6,255,255,244,0,27,255,255,255,255,255,254,0,0,0,127,255,253,191,255,255,255,255,255,255,255,252,63,231,255,255,255,255,255,208,96,20,3,255,255,255,255,255,208,0,0,3,248,0,0,0,47,208,0,0,3,248,0,0,0,47,208,0,0,3,248,0,0,0,47,208,0,0,3,248,0,0,0,47,208,0,0,3,248,0,0,0,47,208,0,0,3,255,255,255,255,255,208,0,0,3,255,255,255,255,255,208,0,0,3,255,255,255,255,255,208,0,0,3,248,0,0,0,47,208,0,0,2,164,0,0,0,21,64,0,
  // 0x5bab  宫
  171,91,34,38,86,40,3,252,0,0,0,6,224,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,7,252,0,0,0,0,106,170,170,171,255,170,170,170,144,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,0,0,0,0,0,0,15,224,191,0,0,0,0,0,0,15,224,191,0,0,0,0,0,0,15,224,191,31,255,255,255,255,255,79,224,191,31,255,255,255,255,255,79,224,0,31,255,255,255,255,255,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,255,255,255,255,255,64,0,0,31,255,255,255,255,255,64,0,0,31,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,255,255,255,255,255,255,252,0,2,255,255,255,255,255,255,252,0,2,255,255,255,255,255,255,252,0,2,252,0,0,0,0,2,252,0,2,252,0,0,0,0,2,252,0,2,252,0,0,0,0,2,252,0,2,252,0,0,0,0,2,252,0,2,252,0,0,0,0,2,252,0,2,255,255,255,255,255,255,252,0,2,255,255,255,255,255,255,252,0,2,255,255,255,255,255,255,252,0,2,252,0,0,0,0,2,252,0,2,168,0,0,0,0,1,168,0,
  // 0x5bf9  对
  249,91,37,38,124,40,2,252,0,0,0,0,0,0,0,170,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,42,170,170,169,0,0,0,254,0,0,63,255,255,255,128,0,0,254,0,0,63,255,255,255,64,0,0,254,0,0,63,255,255,255,64,0,0,254,0,0,0,0,0,191,0,0,0,254,0,0,0,0,0,191,47,255,255,255,255,64,0,0,0,255,47,255,255,255,255,64,0,0,0,254,47,255,255,255,255,64,0,0,1,253,26,170,170,255,170,0,2,128,1,253,0,0,0,254,0,0,11,224,2,252,0,0,0,254,0,0,31,248,3,252,0,0,0,254,0,0,7,254,7,248,0,128,0,254,0,0,1,255,139,244,11,208,0,254,0,0,0,127,239,240,15,240,0,254,0,0,0,31,255,224,7,248,0,254,0,0,0,7,255,208,3,252,0,254,0,0,0,2,255,192,0,254,0,254,0,0,0,0,191,208,0,191,0,254,0,0,0,0,255,240,0,127,128,254,0,0,0,1,255,252,0,63,192,254,0,0,0,3,255,255,0,47,64,254,0,0,0,11,253,255,128,4,0,254,0,0,0,15,244,191,192,0,0,254,0,0,0,63,240,63,240,0,0,254,0,0,0,191,192,15,224,0,0,254,0,0,2,255,64,11,128,0,0,254,0,0,7,254,0,2,0,0,0,254,0,0,47,252,0,0,0,0,0,254,0,0,191,240,0,0,0,15,255,254,0,0,191,192,0,0,0,11,255,253,0,0,47,0,0,0,0,3,255,248,0,0,8,0,0,0,0,3,254,144,0,0,
  // 0x5c06  将
  6,92,38,38,124,40,1,252,0,0,253,0,0,0,0,2,128,0,0,1,253,0,0,0,6,191,224,0,0,1,253,0,0,90,255,255,248,0,0,1,253,22,255,255,255,255,228,0,0,1,253,63,255,255,255,164,0,0,1,1,253,63,255,250,80,0,0,0,63,1,253,30,80,0,0,0,36,0,63,193,253,0,0,31,192,0,191,0,47,209,253,6,192,31,192,0,255,0,15,241,253,15,208,15,224,2,254,0,11,245,253,11,240,11,240,7,252,0,3,253,253,3,244,7,240,15,240,0,2,254,253,3,252,3,244,47,224,0,0,255,253,1,252,3,244,127,192,0,0,245,253,0,253,2,64,255,0,0,0,1,253,0,249,0,3,253,0,0,0,1,253,0,64,0,2,253,0,0,0,1,253,0,0,0,0,191,0,0,0,1,253,0,0,0,0,191,0,0,0,1,253,21,85,85,85,255,85,64,0,1,253,63,255,255,255,255,255,208,0,1,253,63,255,255,255,255,255,208,0,7,253,63,255,255,255,255,255,208,0,47,253,0,0,0,0,191,0,0,1,255,253,0,24,0,0,191,0,0,15,255,253,0,191,0,0,191,0,0,191,254,253,0,191,128,0,191,0,0,127,241,253,0,63,224,0,191,0,0,63,129,253,0,15,244,0,191,0,0,45,1,253,0,7,252,0,191,0,0,0,1,253,0,2,254,0,191,0,0,0,1,253,0,0,253,0,191,0,0,0,1,253,0,0,144,0,191,0,0,0,1,253,0,0,0,0,191,0,0,0,1,253,0,0,7,255,255,0,0,0,1,253,0,0,3,255,254,0,0,0,1,253,0,0,3,255,252,0,0,0,0,168,0,0,1,170,64,0,0,
  // 0x5c0f  小
  15,92,38,37,114,40,1,252,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,6,80,0,63,192,0,120,0,0,0,11,252,0,63,192,3,252,0,0,0,11,248,0,63,192,2,254,0,0,0,15,244,0,63,192,0,255,0,0,0,15,240,0,63,192,0,191,192,0,0,31,240,0,63,192,0,63,192,0,0,63,224,0,63,192,0,47,224,0,0,63,192,0,63,192,0,31,240,0,0,127,192,0,63,192,0,15,248,0,0,191,128,0,63,192,0,7,252,0,0,255,64,0,63,192,0,3,253,0,2,255,0,0,63,192,0,2,255,0,3,253,0,0,63,192,0,1,255,0,7,252,0,0,63,192,0,0,255,128,15,248,0,0,63,192,0,0,191,192,47,240,0,0,63,192,0,0,63,192,127,208,0,0,63,192,0,0,63,224,47,192,0,0,63,192,0,0,47,240,3,64,0,0,63,192,0,0,31,144,0,0,0,0,63,192,0,0,8,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,31,255,255,192,0,0,0,0,0,0,15,255,255,128,0,0,0,0,0,0,7,255,255,0,0,0,0,0,0,0,3,255,164,0,0,0,0,0,
  // 0x5c31  就
  49,92,38,38,124,40,1,252,0,0,63,128,0,0,63,128,0,0,0,0,63,128,0,0,63,129,128,0,0,0,63,128,0,0,63,143,224,0,0,0,63,128,0,0,63,139,244,0,0,0,63,128,0,0,63,131,253,0,63,255,255,255,255,0,63,128,255,0,63,255,255,255,255,0,63,128,127,64,63,255,255,255,255,0,63,128,63,192,21,85,85,85,85,0,63,128,29,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,170,191,234,170,128,3,255,255,255,244,255,255,255,255,192,3,255,255,255,244,255,255,255,255,192,3,255,255,255,244,255,255,255,255,192,3,248,0,7,244,0,63,128,0,0,3,248,0,3,244,0,63,128,0,0,3,248,0,3,244,0,127,252,0,0,3,248,0,3,244,0,127,252,0,0,3,248,0,3,244,0,191,252,0,0,3,255,255,255,244,0,191,252,0,0,3,255,255,255,244,0,255,252,0,0,3,255,255,255,244,0,255,252,0,0,0,0,63,128,0,1,255,252,0,0,0,0,63,128,0,2,254,252,0,0,1,228,63,135,208,3,253,252,0,0,2,252,63,139,240,3,249,252,0,0,3,248,63,131,244,11,245,252,0,0,7,244,63,130,252,15,241,252,0,0,11,240,63,129,252,31,225,252,2,0,15,224,63,128,254,63,209,252,3,208,31,208,63,128,190,191,193,252,3,224,63,192,63,128,80,255,65,252,3,224,191,64,63,128,3,254,1,252,3,224,47,0,63,128,11,252,1,252,11,208,9,63,255,64,47,244,1,255,255,208,0,31,255,64,127,224,0,255,255,192,0,15,254,0,31,128,0,191,255,64,0,5,64,0,2,0,0,22,164,0,
  // 0x5c4f  屏
  79,92,37,36,104,40,1,252,0,127,255,255,255,255,255,255,244,0,0,127,255,255,255,255,255,255,244,0,0,127,255,255,255,255,255,255,244,0,0,127,64,0,0,0,0,7,244,0,0,127,64,0,0,0,0,7,244,0,0,127,64,0,0,0,0,7,244,0,0,127,64,0,0,0,0,7,244,0,0,127,255,255,255,255,255,255,244,0,0,127,255,255,255,255,255,255,244,0,0,127,255,255,255,255,255,255,244,0,0,127,64,27,128,0,1,253,0,0,0,127,64,47,208,0,2,253,0,0,0,127,64,15,240,0,7,252,0,0,0,127,64,7,244,0,15,240,0,0,0,127,64,3,248,0,15,208,0,0,0,127,31,255,255,255,255,255,254,0,0,191,31,255,255,255,255,255,254,0,0,191,31,255,255,255,255,255,254,0,0,191,0,3,252,0,31,208,0,0,0,191,0,3,252,0,31,208,0,0,0,255,0,3,252,0,31,208,0,0,0,255,0,3,252,0,31,208,0,0,0,254,0,3,252,0,31,208,0,0,0,254,191,255,255,255,255,255,255,192,1,253,191,255,255,255,255,255,255,192,2,252,191,255,255,255,255,255,255,192,3,252,0,11,244,0,31,208,0,0,3,248,0,15,240,0,31,208,0,0,7,244,0,31,240,0,31,208,0,0,11,240,0,63,208,0,31,208,0,0,15,240,0,255,128,0,31,208,0,0,47,224,7,255,0,0,31,208,0,0,63,192,127,252,0,0,31,208,0,0,127,192,127,240,0,0,31,208,0,0,31,64,47,192,0,0,31,208,0,0,2,0,9,0,0,0,31,192,0,0,
  // 0x5de5  工
  229,93,36,30,14,40,2,255,11,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,224,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,170,170,170,170,170,170,
  // 0x5dee  差
  238,93,36,38,86,40,2,252,0,0,4,0,0,0,36,0,0,0,0,189,0,0,0,191,128,0,0,0,255,0,0,0,255,64,0,0,0,191,128,0,1,254,0,0,0,0,63,192,0,3,252,0,0,0,0,47,224,0,11,248,0,0,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,21,85,255,85,85,85,85,85,84,0,1,254,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,3,253,255,255,255,255,255,0,0,7,252,255,255,255,255,255,0,0,11,244,255,255,255,255,255,0,0,15,240,0,2,253,0,0,0,0,47,224,0,2,252,0,0,0,0,127,192,0,2,252,0,0,0,0,255,128,0,2,252,0,0,0,2,255,0,0,2,252,0,0,0,7,253,0,0,2,252,0,0,0,31,248,85,85,86,253,85,85,80,191,240,255,255,255,255,255,255,252,255,192,255,255,255,255,255,255,252,63,0,255,255,255,255,255,255,252,8,0,0,0,0,0,0,0,0,
  // 0x5df2  已
  242,93,34,34,50,40,4,253,255,255,255,255,255,255,255,192,0,255,255,255,255,255,255,255,192,0,255,255,255,255,255,255,255,192,0,170,170,170,170,170,170,191,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,10,144,0,0,0,0,63,192,0,31,224,0,0,0,0,63,192,0,31,224,0,0,0,0,63,192,0,31,224,0,0,0,0,63,192,0,31,224,0,0,0,0,63,192,0,31,224,0,0,0,0,63,192,0,31,250,170,170,170,170,191,192,0,31,255,255,255,255,255,255,192,0,31,255,255,255,255,255,255,192,0,31,255,255,255,255,255,255,192,0,31,224,0,0,0,0,63,192,0,31,224,0,0,0,0,63,192,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,4,0,31,224,0,0,0,0,0,15,128,31,224,0,0,0,0,0,15,240,31,224,0,0,0,0,0,15,240,31,224,0,0,0,0,0,15,240,15,224,0,0,0,0,0,47,224,15,240,0,0,0,0,0,63,208,15,249,0,0,0,0,1,255,192,11,255,255,255,255,255,255,255,128,3,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,248,0,0,6,170,170,170,170,170,64,0,
  // 0x5e73  平
  115,94,36,35,59,40,2,252,11,255,255,255,255,255,255,255,224,11,255,255,255,255,255,255,255,224,11,255,255,255,255,255,255,255,224,6,170,170,170,255,170,170,170,144,0,0,0,0,255,0,0,0,0,0,1,64,0,255,0,1,144,0,0,63,192,0,255,0,3,253,0,0,47,192,0,255,0,7,252,0,0,15,224,0,255,0,11,248,0,0,15,240,0,255,0,15,240,0,0,7,248,0,255,0,31,224,0,0,3,252,0,255,0,63,192,0,0,2,253,0,255,0,127,128,0,0,1,254,0,255,0,255,0,0,0,0,248,0,255,0,189,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,254,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,
  // 0x5e76  并
  118,94,36,39,95,40,2,251,0,0,96,0,0,0,29,0,0,0,3,252,0,0,0,63,240,0,0,2,253,0,0,0,127,208,0,0,0,255,0,0,0,255,128,0,0,0,191,128,0,1,255,0,0,0,0,63,208,0,3,253,0,0,0,0,31,224,0,11,248,0,0,0,0,15,208,0,7,240,0,0,10,170,175,170,170,170,170,170,164,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,106,170,191,234,170,171,254,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,127,128,0,3,252,0,0,0,0,191,64,0,3,252,0,0,0,0,255,0,0,3,252,0,0,0,0,255,0,0,3,252,0,0,0,2,254,0,0,3,252,0,0,0,3,252,0,0,3,252,0,0,0,15,252,0,0,3,252,0,0,0,47,240,0,0,3,252,0,0,0,191,224,0,0,3,252,0,0,3,255,128,0,0,3,252,0,0,31,255,0,0,0,3,252,0,0,127,248,0,0,0,3,252,0,0,47,208,0,0,0,3,252,0,0,10,0,0,0,0,2,248,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5e8a  床
  138,94,38,38,124,40,1,252,0,0,0,0,5,80,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,170,170,170,175,250,170,170,170,128,0,255,255,255,255,255,255,255,255,192,0,255,255,255,255,255,255,255,255,192,0,255,255,255,255,255,255,255,255,192,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,127,64,0,0,0,0,254,0,0,0,127,64,0,0,0,0,254,0,0,0,127,64,0,0,0,0,254,0,0,0,127,64,0,0,0,0,254,0,0,0,127,64,0,0,0,0,254,26,170,170,191,170,170,170,64,0,254,47,255,255,255,255,255,255,192,0,254,47,255,255,255,255,255,255,192,0,253,47,255,255,255,255,255,255,192,1,253,0,0,3,255,240,0,0,0,1,253,0,0,15,255,248,0,0,0,1,253,0,0,31,255,253,0,0,0,1,252,0,0,63,255,255,0,0,0,2,252,0,0,255,255,191,192,0,0,2,252,0,2,255,127,111,224,0,0,2,252,0,7,252,127,79,248,0,0,3,252,0,31,244,127,71,254,0,0,3,248,0,127,224,127,65,255,128,0,7,244,1,255,192,127,64,191,224,0,11,240,7,255,0,127,64,47,252,0,11,240,47,252,0,127,64,11,255,64,15,240,255,240,0,127,64,2,255,208,31,224,255,192,0,127,64,0,191,128,47,192,63,0,0,127,64,0,31,0,63,192,8,0,0,127,64,0,4,0,127,128,0,0,0,127,64,0,0,0,31,0,0,0,0,127,64,0,0,0,1,0,0,0,0,127,0,0,0,0,
  // 0x5e94  应
  148,94,37,39,134,40,1,251,0,0,0,0,11,224,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,0,3,253,0,0,0,0,0,255,255,255,255,255,255,255,255,128,0,255,255,255,255,255,255,255,255,128,0,255,255,255,255,255,255,255,255,128,0,255,170,170,170,170,170,170,170,64,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,2,208,0,3,144,0,0,254,0,0,15,224,0,3,252,0,0,254,1,192,11,240,0,7,248,0,0,254,31,208,7,240,0,11,244,0,0,254,15,224,3,244,0,15,240,0,0,254,11,240,3,252,0,31,240,0,0,254,7,244,2,252,0,47,208,0,1,253,3,252,1,253,0,63,192,0,1,253,2,252,0,254,0,127,128,0,1,253,1,253,0,254,0,191,64,0,1,253,0,254,0,255,0,255,0,0,1,253,0,255,0,191,1,254,0,0,2,252,0,127,64,127,66,252,0,0,2,252,0,63,128,63,131,248,0,0,2,252,0,63,192,57,11,244,0,0,3,252,0,47,192,0,15,240,0,0,3,252,0,31,64,0,31,208,0,0,3,248,0,4,0,0,63,192,0,0,7,244,0,0,0,0,127,64,0,0,11,240,0,0,0,0,255,0,0,0,15,240,0,0,0,2,253,0,0,0,15,240,170,170,170,171,254,170,170,128,47,225,255,255,255,255,255,255,255,192,63,193,255,255,255,255,255,255,255,192,127,193,255,255,255,255,255,255,255,192,47,64,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5e9f  废
  159,94,37,39,134,40,1,251,0,0,0,0,6,224,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,0,3,252,0,0,0,0,1,255,255,255,255,255,255,255,255,192,1,255,255,255,255,255,255,255,255,192,1,255,255,255,255,255,255,255,255,192,1,254,170,170,170,170,170,170,170,128,1,253,0,0,0,164,0,0,0,0,1,253,0,255,0,254,0,240,0,0,1,253,0,255,1,253,3,252,0,0,1,253,2,253,2,252,2,255,0,0,1,253,3,252,3,252,0,191,128,0,1,253,7,248,3,248,0,63,208,0,1,253,15,244,7,244,0,15,0,0,1,253,47,255,255,255,255,255,255,0,1,253,31,255,255,255,255,255,255,0,1,253,15,255,255,255,255,255,255,0,2,253,10,85,127,213,85,85,85,0,2,252,0,0,63,192,0,0,0,0,2,252,0,0,191,64,0,0,0,0,2,252,0,0,255,0,0,0,0,0,2,252,0,1,255,255,255,255,64,0,3,252,0,3,255,255,255,255,192,0,3,252,0,11,255,255,255,255,128,0,3,252,0,31,253,0,2,255,0,0,3,248,0,63,255,0,3,253,0,0,7,248,0,255,255,192,15,252,0,0,7,244,3,255,47,240,63,240,0,0,11,240,15,252,11,254,255,192,0,0,15,240,127,240,2,255,255,0,0,0,15,242,255,208,0,255,253,0,0,0,31,231,255,0,7,255,255,208,0,0,47,210,248,0,127,255,255,254,64,0,63,192,224,111,255,248,47,255,254,64,127,128,0,255,255,128,2,255,255,64,31,64,0,63,244,0,0,27,254,0,2,0,0,46,0,0,0,0,108,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5ea6  度
  166,94,37,38,124,40,1,252,0,0,0,0,11,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,255,255,255,255,255,255,255,255,128,0,255,255,255,255,255,255,255,255,128,0,255,255,255,255,255,255,255,255,128,0,254,85,85,85,85,85,85,85,0,0,253,0,6,160,0,2,160,0,0,0,253,0,11,240,0,7,244,0,0,0,253,0,11,240,0,7,244,0,0,0,253,0,11,240,0,7,244,0,0,0,253,127,255,255,255,255,255,255,64,0,253,127,255,255,255,255,255,255,64,0,253,127,255,255,255,255,255,255,64,0,253,0,11,240,0,7,244,0,0,0,253,0,11,240,0,7,244,0,0,0,253,0,11,240,0,7,244,0,0,0,253,0,11,255,255,255,244,0,0,1,253,0,11,255,255,255,244,0,0,1,253,0,11,255,255,255,244,0,0,1,252,0,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,0,2,252,63,255,255,255,255,255,128,0,2,252,63,255,255,255,255,255,224,0,2,252,63,255,255,255,255,255,192,0,3,248,0,11,208,0,0,255,128,0,3,244,0,15,244,0,3,255,0,0,7,244,0,3,253,0,15,252,0,0,11,240,0,1,255,192,191,240,0,0,11,240,0,0,127,251,255,192,0,0,15,224,0,0,15,255,254,0,0,0,31,208,0,0,31,255,254,0,0,0,47,192,0,27,255,255,255,249,64,0,63,129,191,255,255,230,255,255,255,128,127,64,255,255,254,0,31,255,255,128,31,0,191,254,64,0,0,111,255,0,1,0,41,0,0,0,0,0,105,0,
  // 0x5f00  开
  0,95,36,35,59,40,2,252,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,10,170,191,234,170,171,254,170,164,0,0,47,192,0,2,253,0,0,0,0,47,192,0,2,253,0,0,0,0,47,192,0,2,253,0,0,0,0,47,192,0,2,253,0,0,0,0,47,192,0,2,253,0,0,0,0,47,192,0,2,253,0,0,0,0,47,192,0,2,253,0,0,0,0,47,192,0,2,253,0,0,0,0,47,192,0,2,253,0,0,0,0,47,192,0,2,253,0,0,106,170,191,234,170,171,254,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,63,192,0,2,253,0,0,0,0,63,128,0,2,253,0,0,0,0,127,128,0,2,253,0,0,0,0,191,64,0,2,253,0,0,0,0,255,0,0,2,253,0,0,0,1,255,0,0,2,253,0,0,0,3,254,0,0,2,253,0,0,0,3,252,0,0,2,253,0,0,0,15,252,0,0,2,253,0,0,0,47,244,0,0,2,253,0,0,0,127,224,0,0,2,253,0,0,1,255,192,0,0,2,253,0,0,11,255,64,0,0,2,253,0,0,47,253,0,0,0,2,253,0,0,127,244,0,0,0,2,253,0,0,31,208,0,0,0,2,253,0,0,6,0,0,0,0,1,253,0,0,
  // 0x5f03  弃
  3,95,36,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,21,85,85,85,255,85,85,85,84,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,1,255,0,0,0,0,0,0,0,3,253,0,0,244,0,0,0,0,11,248,0,7,254,0,0,0,0,15,240,0,1,255,208,0,0,0,63,192,0,0,47,248,0,26,170,191,234,255,255,255,255,0,47,255,255,255,255,255,255,255,208,47,255,255,255,255,255,255,255,244,31,255,254,170,169,85,80,11,252,0,0,0,0,0,1,84,2,244,0,0,63,128,0,3,248,0,128,0,0,63,128,0,3,248,0,0,0,0,63,128,0,3,248,0,0,0,0,63,128,0,3,248,0,0,0,0,63,128,0,3,248,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,191,149,85,87,253,85,85,0,0,255,0,0,3,248,0,0,0,0,255,0,0,3,248,0,0,0,3,254,0,0,3,248,0,0,0,11,252,0,0,3,248,0,0,0,47,248,0,0,3,248,0,0,0,191,240,0,0,3,248,0,0,7,255,192,0,0,3,248,0,0,191,254,0,0,0,3,248,0,0,255,248,0,0,0,3,248,0,0,63,128,0,0,0,3,248,0,0,24,0,0,0,0,2,168,0,0,
  // 0x5f0f  式
  15,95,37,38,124,40,2,252,0,0,0,0,0,170,0,64,0,0,0,0,0,0,0,255,2,244,0,0,0,0,0,0,0,255,7,254,0,0,0,0,0,0,0,191,1,255,192,0,0,0,0,0,0,191,0,63,240,0,0,0,0,0,0,191,0,15,240,0,0,0,0,0,0,191,64,3,128,0,106,170,170,170,170,255,170,171,169,0,191,255,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,255,254,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,15,255,255,255,252,63,192,0,0,0,15,255,255,255,252,47,208,0,0,0,15,255,255,255,252,47,208,0,0,0,10,170,255,170,168,31,224,0,0,0,0,0,191,0,0,15,224,0,0,0,0,0,191,0,0,15,240,0,0,0,0,0,191,0,0,15,240,0,0,0,0,0,191,0,0,11,244,0,0,0,0,0,191,0,0,7,248,0,0,0,0,0,191,0,0,3,252,0,0,0,0,0,191,0,0,3,252,0,40,0,0,0,191,0,0,2,253,0,63,64,0,0,191,0,27,1,255,0,63,128,0,0,191,111,255,64,255,0,63,64,0,1,255,255,255,64,191,192,63,64,6,255,255,255,254,0,63,208,127,0,127,255,255,254,64,0,47,244,191,0,63,255,254,64,0,0,15,255,254,0,63,249,0,0,0,0,3,255,252,0,25,0,0,0,0,0,0,255,248,0,0,0,0,0,0,0,0,47,144,0,
  // 0x5f15  引
  21,95,31,37,40,40,3,252,0,0,0,0,0,0,3,252,63,255,255,255,192,0,3,252,63,255,255,255,192,0,3,252,63,255,255,255,192,0,3,252,21,85,85,111,192,0,3,252,0,0,0,31,192,0,3,252,0,0,0,31,192,0,3,252,0,0,0,31,192,0,3,252,0,0,0,31,192,0,3,252,0,0,0,31,192,0,3,252,15,255,255,255,192,0,3,252,15,255,255,255,192,0,3,252,15,255,255,255,192,0,3,252,31,229,85,85,64,0,3,252,31,192,0,0,0,0,3,252,47,192,0,0,0,0,3,252,63,192,0,0,0,0,3,252,63,192,0,0,0,0,3,252,63,128,0,0,0,0,3,252,127,255,255,255,208,0,3,252,191,255,255,255,208,0,3,252,191,255,255,255,192,0,3,252,255,85,85,127,192,0,3,252,254,0,0,47,192,0,3,252,0,0,0,63,192,0,3,252,0,0,0,63,192,0,3,252,0,0,0,63,192,0,3,252,0,0,0,63,128,0,3,252,0,0,0,127,128,0,3,252,0,0,0,127,64,0,3,252,0,0,0,191,0,0,3,252,0,0,0,255,0,0,3,252,0,0,2,255,0,0,3,252,0,255,255,253,0,0,3,252,0,191,255,252,0,0,3,252,0,127,255,240,0,0,3,252,0,42,170,64,0,0,2,252,
  // 0x5f39  弹
  57,95,37,38,124,40,2,252,0,0,0,0,4,0,0,20,0,0,0,0,0,0,126,0,0,63,192,0,191,255,255,0,191,64,0,127,192,0,191,255,255,0,63,192,0,255,64,0,191,255,255,0,31,224,0,254,0,0,21,85,255,0,11,240,2,252,0,0,0,0,191,0,3,248,3,248,0,0,0,0,191,0,2,208,11,240,0,0,0,0,191,0,0,0,31,208,0,0,0,0,191,11,255,255,255,255,252,0,0,0,191,11,255,255,255,255,252,0,63,255,255,11,255,255,255,255,252,0,63,255,255,11,240,7,244,3,252,0,63,255,255,11,240,7,244,3,252,0,63,85,85,11,240,7,244,3,252,0,63,0,0,11,255,255,255,255,252,0,63,0,0,11,255,255,255,255,252,0,63,0,0,11,255,255,255,255,252,0,63,0,0,11,240,7,244,3,252,0,63,0,0,11,240,7,244,3,252,0,63,255,255,11,240,7,244,3,252,0,127,255,255,11,255,255,255,255,252,0,127,255,254,11,255,255,255,255,252,0,0,0,254,11,255,255,255,255,252,0,0,0,254,0,0,7,244,0,0,0,0,0,254,0,0,7,244,0,0,0,0,0,253,0,0,7,244,0,0,0,0,0,253,255,255,255,255,255,255,64,0,0,253,255,255,255,255,255,255,64,0,0,253,255,255,255,255,255,255,64,0,1,252,21,85,91,249,85,85,0,0,1,252,0,0,7,244,0,0,0,0,2,252,0,0,7,244,0,0,0,0,7,248,0,0,7,244,0,0,0,47,255,244,0,0,7,244,0,0,0,15,255,240,0,0,7,244,0,0,0,15,255,208,0,0,7,244,0,0,0,5,149,0,0,0,7,244,0,0,0,
  // 0x5f52  归
  82,95,34,39,95,40,3,251,0,0,170,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,2,170,170,170,170,144,0,0,191,3,255,255,255,255,224,191,0,191,3,255,255,255,255,224,191,0,191,3,255,255,255,255,224,191,0,191,0,0,0,0,15,224,191,0,191,0,0,0,0,15,224,191,0,191,0,0,0,0,15,224,191,0,191,0,0,0,0,15,224,191,0,191,0,0,0,0,15,224,191,0,191,0,0,0,0,15,224,191,0,191,0,0,0,0,15,224,191,0,191,0,0,0,0,15,224,191,0,191,0,0,0,0,15,224,191,0,191,0,0,0,0,15,224,191,0,191,0,255,255,255,255,224,191,0,255,0,255,255,255,255,224,191,0,255,0,255,255,255,255,224,191,0,255,0,170,170,170,191,224,191,0,255,0,0,0,0,15,224,191,0,255,0,0,0,0,15,224,191,0,254,0,0,0,0,15,224,191,1,254,0,0,0,0,15,224,85,1,253,0,0,0,0,15,224,0,2,252,0,0,0,0,15,224,0,3,252,0,0,0,0,15,224,0,7,248,0,0,0,0,15,224,0,15,244,0,0,0,0,15,224,0,31,240,0,0,0,0,15,224,0,63,224,15,255,255,255,255,224,0,191,192,15,255,255,255,255,224,2,255,64,15,255,255,255,255,224,11,254,0,10,170,170,170,175,224,31,252,0,0,0,0,0,15,224,7,240,0,0,0,0,0,15,224,1,192,0,0,0,0,0,5,64,0,0,0,0,0,0,0,0,0,
  // 0x5f84  径
  132,95,38,38,124,40,1,252,0,0,36,0,0,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,3,255,11,255,255,255,255,248,0,0,11,252,11,255,255,255,255,252,0,0,47,240,11,255,255,255,255,248,0,0,255,208,0,27,64,0,15,244,0,3,255,64,0,63,192,0,31,224,0,31,253,0,0,31,208,0,63,192,0,127,244,9,0,15,240,0,255,128,0,63,208,31,208,7,252,2,255,0,0,15,0,63,192,2,255,11,252,0,0,4,0,191,128,0,191,239,244,0,0,0,2,255,0,0,63,255,208,0,0,0,7,253,0,0,15,255,64,0,0,0,15,248,0,0,127,255,224,0,0,0,63,240,0,7,255,255,254,0,0,0,255,240,0,111,255,95,255,228,0,3,255,240,27,255,248,2,255,255,144,31,255,240,191,255,128,0,47,255,208,191,255,240,63,248,1,84,2,255,128,191,219,240,46,64,2,252,0,27,0,63,75,240,0,0,2,252,0,0,0,29,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,3,252,0,0,0,0,11,240,7,255,255,255,255,252,0,0,11,240,7,255,255,255,255,252,0,0,11,240,7,255,255,255,255,252,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,255,255,255,255,255,255,208,0,11,240,255,255,255,255,255,255,208,0,11,240,255,255,255,255,255,255,208,0,11,240,21,85,85,85,85,85,64,0,11,240,0,0,0,0,0,0,0,
  // 0x5f85  待
  133,95,38,38,124,40,1,252,0,0,96,0,0,2,164,0,0,0,0,0,254,0,0,3,248,0,0,0,0,2,255,0,0,3,248,0,0,0,0,11,252,0,0,3,248,0,0,0,0,47,244,0,0,3,248,0,0,0,0,191,208,11,255,255,255,255,253,0,3,255,64,11,255,255,255,255,253,0,31,253,0,11,255,255,255,255,253,0,63,244,0,1,85,87,253,85,84,0,31,192,41,0,0,3,248,0,0,0,15,0,63,128,0,3,248,0,0,0,0,0,255,64,0,3,248,0,0,0,0,2,254,0,0,3,248,0,0,0,0,7,252,255,255,255,255,255,255,208,0,15,244,255,255,255,255,255,255,208,0,63,240,255,255,255,255,255,255,208,0,255,240,85,85,85,85,255,85,64,3,255,240,0,0,0,0,191,0,0,15,255,240,0,0,0,0,191,0,0,127,255,240,0,0,0,0,191,0,0,191,239,240,21,85,85,85,255,85,64,63,143,240,127,255,255,255,255,255,192,46,15,240,127,255,255,255,255,255,192,4,15,240,127,255,255,255,255,255,192,0,15,240,0,0,0,0,191,0,0,0,15,240,0,124,0,0,191,0,0,0,15,240,1,254,0,0,191,0,0,0,15,240,0,255,64,0,191,0,0,0,15,240,0,63,192,0,191,0,0,0,15,240,0,31,240,0,191,0,0,0,15,240,0,15,244,0,191,0,0,0,15,240,0,3,252,0,191,0,0,0,15,240,0,2,224,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,0,3,255,255,0,0,0,15,240,0,0,3,255,254,0,0,0,15,240,0,0,2,255,252,0,0,0,6,144,0,0,0,169,64,0,0,
  // 0x5faa  循
  170,95,38,38,124,40,1,252,0,0,144,0,0,0,0,0,0,0,0,1,253,0,0,0,0,27,224,0,0,3,252,0,0,0,91,255,248,0,0,15,244,25,22,255,255,255,252,0,0,63,224,31,255,255,255,250,64,0,0,255,192,31,255,255,255,192,0,0,3,255,0,31,233,64,47,192,0,0,15,252,0,31,192,0,47,192,0,0,127,240,0,31,192,0,47,192,0,0,63,192,56,31,192,0,47,192,0,0,30,0,191,95,255,255,255,255,255,208,4,1,255,31,255,255,255,255,255,208,0,3,252,31,255,255,255,255,255,208,0,15,244,31,192,0,63,128,0,0,0,63,224,31,192,0,63,64,0,0,0,255,208,31,192,0,63,64,0,0,3,255,208,31,195,255,255,255,254,0,15,255,208,31,195,255,255,255,254,0,127,255,208,31,195,255,255,255,254,0,255,223,208,31,195,244,0,0,254,0,127,79,208,31,195,244,0,0,254,0,62,15,208,47,195,244,0,0,254,0,24,15,208,47,195,250,170,170,254,0,0,15,208,47,131,255,255,255,254,0,0,15,208,63,131,255,255,255,254,0,0,15,208,63,131,244,0,0,254,0,0,15,208,63,67,244,0,0,254,0,0,15,208,127,3,244,0,0,254,0,0,15,208,191,3,255,255,255,254,0,0,15,208,191,3,255,255,255,254,0,0,15,208,254,3,250,170,170,254,0,0,15,209,253,3,244,0,0,254,0,0,15,210,252,3,244,0,0,254,0,0,15,211,252,3,250,170,170,254,0,0,15,215,244,3,255,255,255,254,0,0,15,211,240,3,255,255,255,254,0,0,15,208,160,3,244,0,0,254,0,0,10,144,0,2,160,0,0,85,0,
  // 0x5fae  微
  174,95,38,38,124,40,1,252,0,6,64,1,244,0,2,144,0,0,0,15,240,1,244,0,3,244,0,0,0,47,208,1,244,0,7,240,0,0,0,191,193,65,244,20,7,240,0,0,1,255,3,209,244,62,11,240,0,0,7,252,3,209,244,62,15,224,0,0,31,244,3,209,244,62,15,208,0,0,127,224,3,209,244,62,15,192,0,0,127,129,67,209,244,62,47,255,255,208,46,3,251,209,244,62,63,255,255,208,4,11,247,209,244,62,63,255,255,208,0,15,227,255,255,254,127,64,190,0,0,47,195,255,255,254,255,64,190,0,0,127,131,255,255,255,255,64,253,0,0,255,0,0,0,3,255,128,253,0,2,255,0,0,0,7,255,128,252,0,7,255,0,0,0,15,255,192,252,0,31,255,0,0,0,3,235,193,252,0,63,255,15,255,255,255,199,210,248,0,255,255,15,255,255,255,7,227,244,0,191,127,15,255,255,255,3,243,240,0,60,63,0,127,11,224,3,247,240,0,20,63,0,126,7,224,2,255,224,0,0,63,0,126,7,224,1,255,208,0,0,63,0,126,7,224,0,255,192,0,0,63,0,126,7,224,0,255,192,0,0,63,0,189,7,224,0,191,64,0,0,63,0,253,7,224,64,191,0,0,0,63,0,252,7,251,192,255,128,0,0,63,1,252,11,255,211,255,192,0,0,63,2,248,63,255,139,255,240,0,0,63,3,244,47,248,15,247,248,0,0,63,11,240,14,64,63,195,253,0,0,63,31,208,0,1,255,64,255,64,0,63,47,192,0,11,254,0,191,224,0,63,11,0,0,11,244,0,47,208,0,63,1,0,0,3,208,0,11,128,0,63,0,0,0,1,64,0,1,0,
  // 0x5fc3  心
  195,95,38,38,124,40,1,252,0,0,0,20,0,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,255,248,0,0,0,0,0,0,0,0,255,255,128,0,0,0,0,0,0,0,11,255,248,0,0,0,0,0,0,0,0,191,255,64,0,0,0,0,0,0,0,11,255,240,0,0,0,0,0,0,0,0,255,252,0,0,0,0,0,0,0,0,31,244,0,0,0,0,0,0,0,0,2,224,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,1,84,0,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,0,3,252,0,0,0,4,0,0,0,0,3,252,0,0,0,189,0,0,0,249,3,252,0,0,1,255,0,0,0,255,3,252,0,0,0,255,128,0,0,254,3,252,0,0,0,63,208,0,0,254,3,252,0,0,0,47,240,0,1,253,3,252,0,0,0,15,244,0,2,252,3,252,0,0,0,11,252,0,3,252,3,252,0,0,0,3,253,0,3,252,3,252,0,0,0,1,255,0,7,248,3,252,0,0,0,0,255,64,11,244,3,252,0,0,0,0,191,192,15,240,3,252,0,0,0,0,63,192,31,224,3,252,0,0,6,0,63,208,63,208,3,252,0,0,7,240,47,224,127,192,3,252,0,0,7,240,15,224,191,128,3,252,0,0,7,240,14,0,31,0,3,252,0,0,11,240,0,0,0,0,3,252,0,0,11,240,0,0,0,0,3,252,0,0,15,224,0,0,0,0,2,254,0,0,47,208,0,0,0,0,2,255,255,255,255,192,0,0,0,0,0,255,255,255,255,128,0,0,0,0,0,127,255,255,254,0,0,0,0,0,0,1,85,85,80,0,0,0,
  // 0x5ffd  忽
  253,95,36,38,86,40,2,252,0,0,9,0,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,2,255,85,85,85,85,85,64,0,7,255,255,255,255,255,255,192,0,15,255,255,255,255,255,255,192,0,63,255,255,255,255,255,255,192,0,255,192,63,208,31,208,63,192,3,255,0,127,128,63,192,63,192,15,252,0,255,0,127,64,63,128,127,244,3,253,0,255,0,63,128,191,208,15,248,2,253,0,63,128,31,0,63,240,7,252,0,127,64,0,0,191,192,15,240,0,127,64,0,3,255,0,47,224,0,127,64,0,31,252,0,191,192,0,191,0,0,191,240,2,255,0,0,255,0,7,255,192,11,253,0,0,255,0,11,254,0,47,244,0,2,254,0,2,244,0,255,208,15,255,253,0,0,64,11,255,64,11,255,248,0,0,0,11,253,0,7,255,224,0,0,0,2,240,224,0,16,0,0,0,0,0,71,254,0,0,0,0,0,0,0,7,255,192,0,80,0,0,57,11,224,191,244,2,244,0,0,191,15,240,15,252,7,253,0,0,255,15,240,2,240,2,255,64,1,253,15,240,0,128,0,191,192,3,252,15,240,0,0,116,47,240,11,248,15,240,0,0,127,15,248,31,240,15,240,0,0,191,3,253,127,208,15,240,0,0,255,2,255,255,192,11,255,255,255,254,0,255,63,0,7,255,255,255,252,0,120,4,0,1,255,255,255,240,0,0,0,0,0,5,85,85,0,0,0,
  // 0x6027  性
  39,96,37,38,124,40,1,252,0,31,208,0,0,1,168,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,62,65,253,0,0,0,0,31,208,0,127,65,253,0,0,0,0,31,208,0,191,1,253,0,0,0,0,31,208,0,191,1,253,0,0,0,0,31,208,0,255,1,253,0,0,0,0,31,239,0,254,1,253,0,0,0,15,159,255,129,254,170,254,170,169,0,15,159,223,194,255,255,255,255,255,0,15,159,219,211,255,255,255,255,255,0,31,159,215,247,255,255,255,255,255,0,31,95,211,255,240,1,253,0,0,0,47,31,210,255,240,1,253,0,0,0,63,31,208,95,208,1,253,0,0,0,63,31,208,63,192,1,253,0,0,0,126,31,208,63,128,1,253,0,0,0,189,31,208,7,0,1,253,0,0,0,188,31,208,0,0,1,253,0,0,0,4,31,208,0,0,1,253,0,0,0,0,31,208,2,255,255,255,255,252,0,0,31,208,2,255,255,255,255,252,0,0,31,208,2,255,255,255,255,252,0,0,31,208,1,85,86,254,85,84,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,191,255,255,255,255,255,192,0,31,208,191,255,255,255,255,255,192,0,31,208,191,255,255,255,255,255,192,0,31,208,106,170,170,170,170,170,128,0,31,208,0,0,0,0,0,0,0,
  // 0x603b  总
  59,96,36,38,86,40,2,252,0,0,4,0,0,0,80,0,0,0,0,127,0,0,0,190,0,0,0,0,191,128,0,0,255,64,0,0,0,63,208,0,2,255,0,0,0,0,31,240,0,3,252,0,0,0,0,11,248,0,11,248,0,0,0,0,3,252,0,15,240,0,0,0,0,2,252,0,47,224,0,0,0,21,86,245,85,127,229,84,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,21,85,85,165,85,85,84,0,0,0,0,0,244,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,21,65,255,192,0,8,0,3,228,63,192,63,240,0,127,0,3,248,63,192,15,252,0,191,128,7,244,63,192,3,255,0,63,208,15,240,63,192,0,253,0,15,240,15,240,63,192,0,52,0,7,248,31,224,63,192,0,0,9,3,253,63,192,63,192,0,0,15,208,254,127,192,63,192,0,0,15,224,191,255,64,63,208,0,0,47,208,62,127,0,47,255,255,255,255,192,36,4,0,15,255,255,255,255,128,0,0,0,7,255,255,255,254,0,0,0,0,0,21,85,85,64,0,0,
  // 0x6062  恢
  98,96,38,38,124,40,1,252,0,10,128,1,160,0,0,0,0,0,0,31,192,3,244,0,0,0,0,0,0,31,192,3,244,0,0,0,0,0,0,31,192,3,244,0,0,0,0,0,0,31,192,87,249,85,85,85,85,64,0,31,192,255,255,255,255,255,255,192,0,31,192,255,255,255,255,255,255,192,0,31,233,255,255,255,255,255,255,192,10,95,255,3,244,0,0,0,0,0,15,159,239,3,244,0,15,192,0,0,15,95,207,131,244,0,15,192,0,0,15,95,203,195,244,0,15,192,0,0,31,95,199,211,244,0,15,192,0,0,31,31,195,227,244,0,15,192,9,0,47,31,195,227,244,184,15,192,31,192,63,31,194,67,244,252,15,192,47,128,62,31,192,3,244,248,15,192,63,64,125,31,192,3,240,248,15,192,63,0,188,31,192,3,240,244,15,192,190,0,20,31,192,3,241,244,31,192,252,0,0,31,192,3,242,240,31,193,248,0,0,31,192,7,243,240,31,210,244,0,0,31,192,7,251,208,47,211,240,0,0,31,192,11,225,192,63,224,0,0,0,31,192,11,224,0,63,240,0,0,0,31,192,15,208,0,127,244,0,0,0,31,192,15,208,0,254,248,0,0,0,31,192,31,192,1,252,252,0,0,0,31,192,47,192,3,248,190,0,0,0,31,192,63,128,11,240,63,64,0,0,31,192,127,64,31,224,63,192,0,0,31,192,191,0,127,192,31,240,0,0,31,192,254,1,255,64,11,252,0,0,31,194,252,11,254,0,3,255,0,0,31,199,248,63,248,0,1,255,208,0,31,203,240,127,224,0,0,127,208,0,31,193,224,47,64,0,0,31,128,0,31,192,64,8,0,0,0,2,0,
  // 0x606f  息
  111,96,37,39,134,40,2,252,0,0,0,0,64,0,0,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,15,255,255,255,255,255,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,250,170,170,170,171,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,250,170,170,170,175,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,255,255,255,255,255,248,0,0,0,0,0,0,144,0,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,0,7,254,0,0,16,0,0,0,228,10,129,255,128,0,248,0,0,1,253,15,208,127,224,3,254,0,0,3,252,15,208,31,244,1,255,128,0,3,248,15,208,7,240,0,127,224,0,15,244,15,208,2,128,64,31,244,0,31,240,15,208,0,0,185,11,252,0,63,208,15,208,0,0,254,3,255,0,255,128,15,224,0,1,254,0,255,64,255,0,15,255,255,255,252,0,127,0,28,0,11,255,255,255,252,0,56,0,0,0,2,255,255,255,224,0,0,0,0,0,0,5,85,84,0,0,0,0,
  // 0x611f  感
  31,97,38,38,124,40,1,252,0,0,0,0,0,127,2,224,0,0,0,0,0,0,0,127,11,254,0,0,0,0,0,0,0,127,2,255,208,0,0,0,0,0,0,63,64,47,192,0,0,255,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,255,64,0,253,0,0,0,47,192,0,0,0,0,253,0,0,0,31,192,4,0,0,0,253,21,85,85,79,208,31,192,0,0,253,127,255,255,143,224,63,192,0,0,253,127,255,255,139,240,127,64,0,0,253,0,0,0,7,240,255,0,0,0,253,0,0,0,3,249,254,0,0,0,252,26,170,170,3,255,252,0,0,1,252,63,255,255,1,255,248,0,0,2,252,63,255,255,0,255,240,0,0,2,248,63,0,63,0,191,208,5,0,3,248,63,0,63,0,255,192,11,192,7,240,63,0,63,3,255,224,11,208,11,240,63,170,191,15,255,244,15,192,15,224,63,255,255,127,251,254,31,192,47,208,63,255,255,255,193,255,255,192,127,192,0,0,128,127,0,127,255,64,63,64,0,2,248,24,0,15,253,0,14,0,0,7,255,64,0,0,80,0,0,0,0,1,255,208,0,4,0,0,0,29,3,248,47,248,0,126,0,0,0,63,195,248,7,248,0,255,128,0,0,63,131,248,1,224,0,63,224,0,0,255,3,248,0,0,36,15,244,0,1,255,3,248,0,0,47,135,253,0,3,253,3,248,0,0,63,130,255,0,15,248,3,252,0,0,127,64,255,128,63,240,3,255,255,255,255,0,63,192,47,208,2,255,255,255,255,0,47,64,3,64,0,191,255,255,248,0,4,0,0,0,0,1,85,85,0,0,0,0,
  // 0x620f  戏
  15,98,37,39,134,40,1,251,0,0,0,0,0,42,0,16,0,0,0,0,0,0,0,127,64,188,0,0,0,0,0,0,0,127,130,255,0,0,0,0,0,0,0,127,128,255,192,0,5,85,85,80,0,127,128,63,240,0,63,255,255,255,0,63,128,15,252,0,63,255,255,255,0,63,128,3,244,0,63,255,255,255,0,63,192,0,192,0,0,0,0,255,0,63,192,0,0,0,0,0,0,254,0,63,192,0,90,64,2,0,1,253,0,63,218,255,255,128,11,192,1,252,107,255,255,255,255,128,47,224,2,252,255,255,255,255,255,128,15,244,3,252,191,255,255,165,0,0,3,252,7,248,127,191,208,0,0,0,1,255,11,240,0,31,208,0,224,0,0,255,143,240,0,31,224,2,252,0,0,63,223,224,0,31,224,3,252,0,0,31,255,208,0,15,240,7,244,0,0,11,255,192,0,15,240,15,240,0,0,3,255,128,0,15,240,47,224,0,0,1,255,64,0,11,244,63,192,0,0,1,255,128,0,11,248,255,64,0,0,3,255,208,0,7,250,255,0,0,0,11,255,240,0,3,255,252,0,0,0,15,255,248,0,3,255,244,0,0,0,63,243,253,0,2,255,224,0,0,0,191,194,255,0,1,255,192,8,0,1,255,128,255,64,2,255,64,15,64,7,255,0,127,64,11,255,128,15,192,31,252,0,61,0,63,255,192,31,192,127,244,0,20,0,255,255,224,31,192,63,208,0,0,11,255,159,248,63,128,15,64,0,0,127,253,15,255,191,64,5,0,0,0,191,244,7,255,255,0,0,0,0,0,31,128,1,255,254,0,0,0,0,0,9,0,0,127,252,0,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6210  成
  16,98,37,39,134,40,1,251,0,0,0,0,0,170,1,64,0,0,0,0,0,0,0,255,7,244,0,0,0,0,0,0,0,191,15,254,0,0,0,0,0,0,0,191,2,255,192,0,0,0,0,0,0,191,0,127,244,0,0,0,0,0,0,191,0,15,244,0,0,0,0,0,0,191,0,2,208,0,0,255,255,255,255,255,255,255,255,192,0,255,255,255,255,255,255,255,255,192,0,255,255,255,255,255,255,255,255,192,0,255,170,170,170,255,234,170,170,128,0,255,0,0,0,127,128,0,0,0,0,255,0,0,0,63,128,0,0,0,0,255,0,0,0,63,128,1,0,0,0,255,0,0,0,63,192,7,244,0,0,255,85,85,80,63,192,15,240,0,0,255,255,255,240,63,192,15,240,0,0,255,255,255,240,47,192,47,208,0,0,255,255,255,240,31,208,63,192,0,0,255,0,15,240,31,224,127,128,0,0,255,0,15,240,15,240,255,0,0,0,254,0,15,224,15,242,255,0,0,0,254,0,15,224,15,247,253,0,0,0,254,0,15,224,11,255,248,0,0,1,254,0,15,224,7,255,240,0,0,1,253,0,15,224,3,255,224,0,0,2,253,0,15,224,3,255,192,0,0,2,252,0,31,208,2,255,0,13,0,3,252,85,127,208,7,255,0,15,192,3,252,127,255,192,31,255,64,15,192,7,248,63,255,128,127,255,192,15,192,11,244,47,253,2,255,255,208,31,192,15,240,0,0,15,255,31,240,47,192,31,240,0,0,127,252,15,253,63,128,63,208,0,2,255,240,7,255,255,64,127,192,0,2,255,192,1,255,255,0,47,128,0,0,189,0,0,127,253,0,7,0,0,0,32,0,0,10,160,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6237  户
  55,98,33,39,95,40,1,251,0,0,0,0,27,0,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,15,240,0,0,0,0,5,85,85,95,229,85,85,64,0,31,255,255,255,255,255,255,192,0,31,255,255,255,255,255,255,192,0,31,255,255,255,255,255,255,192,0,31,208,0,0,0,0,63,192,0,31,208,0,0,0,0,63,192,0,31,208,0,0,0,0,63,192,0,31,208,0,0,0,0,63,192,0,31,208,0,0,0,0,63,192,0,31,208,0,0,0,0,63,192,0,47,208,0,0,0,0,63,192,0,47,229,85,85,85,85,127,192,0,47,255,255,255,255,255,255,192,0,47,255,255,255,255,255,255,192,0,47,255,255,255,255,255,255,192,0,63,192,0,0,0,0,63,192,0,63,192,0,0,0,0,63,192,0,63,192,0,0,0,0,21,64,0,63,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,31,128,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6240  所
  64,98,38,37,114,40,1,252,0,0,0,0,0,0,0,0,180,0,5,85,85,85,84,0,0,11,254,0,31,255,255,255,252,0,1,255,255,128,31,255,255,255,252,80,191,255,253,0,31,255,255,255,252,191,255,255,128,0,0,0,0,0,0,191,255,228,0,0,0,0,0,0,0,191,228,0,0,0,0,0,0,0,0,191,0,0,0,0,1,85,85,85,80,191,0,0,0,0,3,255,255,255,240,191,0,0,0,0,3,255,255,255,240,191,0,0,0,0,3,255,255,255,240,191,0,0,0,0,3,244,0,15,240,191,0,0,0,0,3,244,0,15,240,191,255,255,255,208,3,244,0,15,240,191,255,255,255,208,3,244,0,15,240,191,255,255,255,208,3,244,0,15,240,255,170,175,250,144,3,244,0,15,240,255,0,15,208,0,3,255,255,255,240,254,0,15,208,0,3,255,255,255,240,254,0,15,208,0,3,255,255,255,240,254,0,15,208,0,3,249,85,85,81,253,0,15,208,0,3,244,0,0,1,253,0,15,208,0,7,240,0,0,2,252,0,15,208,0,7,240,0,0,3,252,0,15,208,0,7,240,0,0,3,248,0,15,208,0,11,240,0,0,7,244,0,15,208,0,11,240,0,0,15,240,0,15,208,0,15,224,0,0,15,240,0,15,208,0,15,208,0,0,47,208,0,15,208,0,31,192,0,0,63,192,0,15,208,0,63,192,0,0,255,128,0,15,208,0,63,128,0,2,255,0,0,15,208,0,191,64,0,7,253,0,0,15,208,0,255,0,0,7,248,0,0,15,208,0,45,0,0,0,240,0,0,15,208,0,4,0,0,0,0,0,0,15,208,0,
  // 0x6247  扇
  71,98,36,36,68,40,1,252,15,255,255,255,255,255,255,255,255,15,255,255,255,255,255,255,255,255,15,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,255,224,0,63,255,255,255,255,255,255,224,0,63,255,255,255,255,255,255,224,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,15,224,0,63,255,255,255,255,255,255,224,0,127,255,255,255,255,255,255,224,0,127,255,255,255,255,255,255,224,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,127,255,255,15,255,255,244,0,127,127,255,255,15,255,255,244,0,191,63,255,255,15,255,255,244,0,191,1,0,127,0,80,3,244,0,255,15,192,127,3,244,3,244,0,254,15,224,127,3,253,3,244,0,254,7,248,127,0,255,3,244,1,253,1,252,127,0,63,67,244,2,252,0,240,127,0,28,3,244,3,252,0,0,127,0,0,99,244,3,248,0,47,127,0,11,243,244,7,244,7,255,127,1,191,243,244,15,241,191,254,127,47,255,131,244,31,241,255,224,127,47,248,3,244,63,208,253,0,127,31,128,3,244,127,192,144,0,127,4,0,3,244,191,64,0,63,255,0,3,255,244,31,0,0,47,254,0,2,255,240,0,0,0,31,228,0,1,255,128,
  // 0x624b  手
  75,98,36,38,86,40,2,252,0,0,0,0,0,0,0,96,0,0,0,0,0,0,1,175,248,0,0,0,0,1,90,255,255,253,0,1,86,175,255,255,255,255,254,0,3,255,255,255,255,255,254,64,0,3,255,255,255,255,165,0,0,0,2,255,170,85,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,2,170,170,170,255,170,170,170,144,3,255,255,255,255,255,255,255,224,3,255,255,255,255,255,255,255,224,3,255,255,255,255,255,255,255,224,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,170,255,170,170,170,170,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,191,255,253,0,0,0,0,0,0,63,255,248,0,0,0,0,0,0,42,169,0,0,0,0,0,
  // 0x6253  打
  83,98,37,38,124,40,2,252,0,31,208,0,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,0,31,208,2,170,170,170,170,170,64,0,31,208,3,255,255,255,255,255,64,0,31,208,3,255,255,255,255,255,64,0,31,208,3,255,255,255,255,255,64,0,31,208,0,0,0,31,224,0,0,255,255,255,244,0,0,31,224,0,0,255,255,255,244,0,0,31,224,0,0,255,255,255,244,0,0,31,224,0,0,170,175,234,160,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,20,0,0,31,224,0,0,0,31,235,248,0,0,31,224,0,0,0,47,255,248,0,0,31,224,0,0,27,255,255,252,0,0,31,224,0,0,255,255,255,144,0,0,31,224,0,0,255,255,224,0,0,0,31,224,0,0,191,255,208,0,0,0,31,224,0,0,120,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,47,208,0,0,0,47,224,0,0,63,255,208,0,11,255,255,208,0,0,31,255,192,0,3,255,255,192,0,0,15,255,64,0,3,255,255,64,0,0,5,80,0,0,2,255,228,0,0,0,
  // 0x6267  执
  103,98,38,38,124,40,1,252,0,15,192,0,1,252,0,0,0,0,0,31,192,0,1,252,0,0,0,0,0,31,192,0,1,252,0,0,0,0,0,31,192,0,1,252,0,0,0,0,0,31,192,0,1,252,0,0,0,0,0,31,192,0,1,252,0,0,0,0,0,31,192,0,1,252,0,0,0,0,0,31,192,0,1,252,0,0,0,0,21,111,229,69,86,254,85,85,0,0,63,255,255,207,255,255,255,255,0,0,63,255,255,207,255,255,255,255,0,0,63,255,255,207,255,255,255,255,0,0,0,31,192,0,1,252,0,191,0,0,0,31,192,0,1,252,0,191,0,0,0,31,192,0,2,252,0,191,0,0,0,31,192,0,2,252,0,191,0,0,0,31,192,0,2,252,0,191,0,0,0,31,192,67,195,248,0,191,0,0,0,31,235,219,251,248,0,255,0,0,0,31,255,239,255,244,0,255,0,0,1,191,255,226,255,244,0,191,0,0,127,255,254,64,47,254,0,191,0,0,127,255,224,0,15,255,208,191,0,0,63,255,192,0,15,255,248,191,0,0,57,31,192,0,31,239,255,255,0,0,0,31,192,0,47,195,255,255,0,0,0,31,192,0,63,192,188,191,0,0,0,31,192,0,191,64,20,191,0,0,0,31,192,0,255,0,0,191,0,0,0,31,192,2,254,0,0,127,4,0,0,31,192,7,252,0,0,127,11,128,0,31,192,15,248,0,0,127,11,208,0,31,192,63,240,0,0,63,75,208,0,31,193,255,192,0,0,63,143,192,31,255,199,255,64,0,0,47,239,192,15,255,195,253,0,0,0,15,255,128,11,255,1,244,0,0,0,11,255,0,6,144,0,64,0,0,0,2,252,0,
  // 0x6279  批
  121,98,38,38,124,40,1,252,0,31,128,1,80,0,21,64,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,63,255,255,199,240,0,47,192,0,0,63,255,255,199,240,0,47,192,4,0,63,255,255,199,240,0,47,192,45,0,21,127,213,71,240,0,47,192,191,64,0,47,192,7,240,0,47,194,255,128,0,47,192,7,255,255,47,207,254,0,0,47,192,7,255,255,47,255,244,0,0,47,192,7,255,255,47,255,192,0,0,47,192,7,250,169,47,253,0,0,0,47,193,71,240,0,47,240,0,0,0,47,255,135,240,0,47,192,0,0,0,127,255,199,240,0,47,192,0,0,27,255,255,199,240,0,47,192,0,0,191,255,249,7,240,0,47,192,0,0,127,255,192,7,240,0,47,192,0,0,63,175,192,7,240,0,47,192,0,0,16,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,9,0,0,47,192,7,240,0,47,192,15,208,0,47,192,7,240,0,47,192,15,208,0,47,192,7,240,27,47,192,15,208,0,47,192,7,255,255,47,192,15,192,0,47,194,255,255,255,47,192,31,192,21,127,195,255,255,254,31,255,255,192,31,255,130,255,249,0,15,255,255,64,15,255,1,249,0,0,7,255,254,0,15,248,0,0,0,0,0,21,80,0,
  // 0x6296  抖
  150,98,38,38,124,40,1,252,0,11,224,0,0,0,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,3,128,0,191,0,0,0,15,240,0,15,248,0,191,0,0,0,15,240,0,15,255,0,191,0,0,0,15,240,0,1,255,208,191,0,0,0,15,240,0,0,63,244,191,0,0,63,255,255,248,0,11,240,191,0,0,63,255,255,248,0,1,192,191,0,0,63,255,255,248,0,0,0,191,0,0,21,95,245,80,0,0,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,61,0,0,191,0,0,0,15,240,0,191,208,0,191,0,0,0,15,240,0,255,248,0,191,0,0,0,15,240,0,31,255,64,191,0,0,0,15,240,20,2,255,192,191,0,0,0,15,251,248,0,127,64,191,0,0,0,15,255,248,0,14,0,191,0,0,6,255,255,252,0,0,0,191,0,0,127,255,255,144,0,0,0,191,0,0,63,255,240,0,0,0,0,191,107,192,63,239,240,0,0,0,6,255,255,192,24,15,240,0,0,107,255,255,255,208,0,15,240,2,191,255,255,255,255,144,0,15,240,7,255,255,255,255,64,0,0,15,240,3,255,255,164,191,0,0,0,15,240,3,250,64,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,0,0,0,191,0,0,31,255,224,0,0,0,0,191,0,0,15,255,208,0,0,0,0,191,0,0,11,255,64,0,0,0,0,191,0,0,1,80,0,0,0,0,0,106,0,0,
  // 0x62a5  报
  165,98,37,38,124,40,1,252,0,11,240,0,0,0,0,0,0,0,0,11,240,0,85,85,85,85,84,0,0,11,240,0,255,255,255,255,252,0,0,11,240,0,255,255,255,255,252,0,0,11,240,0,255,255,255,255,252,0,0,11,240,0,253,0,0,3,252,0,0,11,240,0,253,0,0,3,252,0,0,11,240,0,253,0,0,3,248,0,42,175,250,160,253,0,0,3,248,0,63,255,255,244,253,0,0,11,244,0,63,255,255,244,253,3,255,255,240,0,63,255,255,244,253,1,255,255,224,0,0,11,240,0,253,0,255,255,128,0,0,11,240,0,253,0,0,0,0,0,0,11,240,0,253,0,0,0,0,0,0,11,240,0,254,85,85,85,84,0,0,11,240,0,255,255,255,255,255,0,0,11,240,0,255,255,255,255,255,0,0,11,246,244,255,255,255,255,254,0,0,15,255,244,253,191,0,1,253,0,1,191,255,248,253,63,64,2,252,0,127,255,255,228,253,47,192,3,252,0,127,255,249,0,253,31,208,7,244,0,63,255,240,0,253,15,240,15,240,0,62,75,240,0,253,11,248,31,224,0,0,11,240,0,253,3,252,63,192,0,0,11,240,0,253,1,255,127,128,0,0,11,240,0,253,0,255,255,0,0,0,11,240,0,253,0,63,254,0,0,0,11,240,0,253,0,47,252,0,0,0,11,240,0,253,0,31,253,0,0,0,11,240,0,253,0,191,255,128,0,0,11,240,0,253,2,255,255,224,0,0,15,240,0,253,31,254,63,254,0,41,111,240,0,254,191,248,15,255,192,63,255,240,0,255,255,208,2,255,128,47,255,208,0,253,127,0,0,127,0,15,254,0,0,169,36,0,0,4,0,
  // 0x62ac  抬
  172,98,38,39,134,40,1,251,0,11,224,0,0,25,0,0,0,0,0,15,240,0,0,63,224,0,0,0,0,15,240,0,0,63,208,0,0,0,0,15,240,0,0,127,192,0,0,0,0,15,240,0,0,191,64,0,0,0,0,15,240,0,0,255,0,0,0,0,0,15,240,0,1,254,0,8,0,0,0,15,240,0,2,253,0,190,0,0,63,255,255,240,3,252,0,255,64,0,63,255,255,240,7,244,0,127,192,0,63,255,255,240,15,240,0,47,224,0,21,95,245,80,15,224,0,15,244,0,0,15,240,0,47,192,0,7,252,0,0,15,240,0,63,214,171,255,254,0,0,15,240,31,255,255,255,255,255,64,0,15,240,15,255,255,255,255,255,192,0,15,240,15,255,255,255,169,127,208,0,15,240,30,149,64,0,0,31,224,0,15,247,244,0,0,0,0,15,64,0,15,255,248,0,0,0,0,0,0,6,255,255,248,0,0,0,0,0,0,191,255,255,64,255,255,255,255,248,0,127,255,240,0,255,255,255,255,248,0,63,223,240,0,255,255,255,255,248,0,36,15,240,0,255,85,85,91,248,0,0,15,240,0,254,0,0,3,248,0,0,15,240,0,254,0,0,3,248,0,0,15,240,0,254,0,0,3,248,0,0,15,240,0,254,0,0,3,248,0,0,15,240,0,254,0,0,3,248,0,0,15,240,0,254,0,0,3,248,0,0,15,240,0,254,0,0,3,248,0,0,15,240,0,255,85,85,87,248,0,0,15,240,0,255,255,255,255,248,0,5,95,240,0,255,255,255,255,248,0,15,255,224,0,255,255,255,255,248,0,11,255,208,0,254,0,0,3,248,0,7,254,0,0,190,0,0,2,164,0,0,0,0,0,0,0,0,0,0,0,
  // 0x62bd  抽
  189,98,37,39,134,40,1,251,0,15,208,0,0,0,168,0,0,0,0,15,224,0,0,0,253,0,0,0,0,15,224,0,0,0,253,0,0,0,0,15,224,0,0,0,253,0,0,0,0,15,224,0,0,0,253,0,0,0,0,15,224,0,0,0,253,0,0,0,0,15,224,0,0,0,253,0,0,0,0,15,224,0,0,0,253,0,0,0,63,255,255,224,0,0,253,0,0,0,63,255,255,226,170,170,254,170,170,64,63,255,255,227,255,255,255,255,255,128,21,95,245,83,255,255,255,255,255,128,0,15,224,3,255,255,255,255,255,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,231,243,244,0,253,0,63,128,0,15,255,243,244,0,253,0,63,128,1,191,255,243,255,255,255,255,255,128,127,255,255,147,255,255,255,255,255,128,127,255,244,3,255,255,255,255,255,128,127,255,224,3,249,86,254,85,191,128,61,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,250,170,254,170,191,128,0,15,224,3,255,255,255,255,255,128,0,15,224,3,255,255,255,255,255,128,5,95,224,3,255,255,255,255,255,128,31,255,208,3,244,0,0,0,63,128,15,255,192,3,244,0,0,0,63,128,11,254,0,3,244,0,0,0,42,64,0,0,0,0,0,0,0,0,0,0,
  // 0x62d4  拔
  212,98,38,39,134,40,1,251,0,15,208,0,0,253,0,0,0,0,0,15,224,0,1,253,0,244,0,0,0,15,224,0,1,253,3,254,0,0,0,15,224,0,1,253,2,255,208,0,0,15,224,0,1,253,0,127,244,0,0,15,224,0,1,252,0,11,254,0,0,15,224,0,1,252,0,1,252,0,0,15,224,0,1,252,0,0,116,0,63,255,255,224,1,252,0,0,0,0,63,255,255,235,255,255,255,255,255,192,63,255,255,235,255,255,255,255,255,192,63,255,255,235,255,255,255,255,255,192,0,15,224,0,2,252,0,0,0,0,0,15,224,0,2,252,0,0,0,0,0,15,224,0,3,253,0,0,0,0,0,15,224,0,3,254,0,6,160,0,0,15,224,0,3,255,0,11,240,0,0,15,224,0,3,255,0,15,240,0,0,15,225,160,3,255,64,15,224,0,0,15,255,240,7,255,128,31,208,0,0,111,255,240,11,255,192,31,192,0,111,255,255,224,15,239,224,47,192,0,191,255,248,0,15,231,240,63,128,0,127,255,224,0,31,211,244,127,64,0,62,79,224,0,47,194,252,255,0,0,0,15,224,0,63,192,254,254,0,0,0,15,224,0,127,64,191,252,0,0,0,15,224,0,191,0,63,248,0,0,0,15,224,0,254,0,47,240,0,0,0,15,224,2,253,0,47,244,0,0,0,15,224,3,252,0,127,253,0,0,0,15,224,15,244,1,255,255,64,0,0,15,224,31,240,3,254,255,208,0,0,15,224,127,192,31,248,63,248,0,5,95,224,255,128,191,240,11,255,64,31,255,211,255,3,255,192,2,255,224,15,255,193,252,1,254,0,0,127,128,11,254,0,112,0,116,0,0,7,0,0,0,0,0,0,0,0,0,0,0,
  // 0x62e9  择
  233,98,38,38,124,40,1,252,0,15,208,0,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,0,15,208,3,255,255,255,255,244,0,0,15,208,3,255,255,255,255,252,0,0,15,208,3,255,255,255,255,248,0,0,15,208,1,111,213,85,95,240,0,0,15,208,0,15,240,0,47,208,0,0,15,208,0,3,248,0,191,128,0,63,255,255,240,2,254,2,255,0,0,63,255,255,240,0,191,143,252,0,0,63,255,255,240,0,47,255,240,0,0,21,111,229,80,0,15,255,192,0,0,0,15,208,0,0,31,255,208,0,0,0,15,208,0,1,255,255,253,0,0,0,15,208,0,31,255,159,255,208,0,0,15,208,7,255,253,2,255,255,64,0,15,208,47,255,208,0,47,255,224,0,15,208,95,253,1,84,2,255,128,0,15,255,231,128,2,252,0,27,0,0,31,255,224,0,2,252,0,0,0,6,255,255,224,0,2,252,0,0,0,127,255,254,65,255,255,255,255,244,0,63,255,224,1,255,255,255,255,244,0,63,239,208,1,255,255,255,255,244,0,20,15,208,0,85,86,253,85,80,0,0,15,208,0,0,2,252,0,0,0,0,15,208,0,0,2,252,0,0,0,0,15,208,0,0,2,252,0,0,0,0,15,208,31,255,255,255,255,255,192,0,15,208,31,255,255,255,255,255,192,0,15,208,31,255,255,255,255,255,192,0,15,208,5,85,86,253,85,85,64,0,15,208,0,0,2,252,0,0,0,0,31,208,0,0,2,252,0,0,0,15,255,208,0,0,2,252,0,0,0,15,255,192,0,0,2,252,0,0,0,11,255,64,0,0,2,252,0,0,0,1,80,0,0,0,1,168,0,0,0,
  // 0x6309  按
  9,99,38,39,134,40,1,251,0,15,208,0,0,1,168,0,0,0,0,15,224,0,0,2,252,0,0,0,0,15,224,0,0,2,252,0,0,0,0,15,224,0,0,2,252,0,0,0,0,15,224,0,0,2,252,0,0,0,0,15,224,1,85,87,253,85,85,64,0,15,224,11,255,255,255,255,255,192,0,15,224,11,255,255,255,255,255,192,63,255,255,235,255,255,255,255,255,192,63,255,255,235,240,0,0,0,47,192,63,255,255,235,240,15,144,0,47,192,21,95,245,91,240,31,224,0,47,192,0,15,224,11,240,47,208,0,47,192,0,15,224,11,240,63,192,0,47,192,0,15,224,0,0,63,128,0,0,0,0,15,224,0,0,127,64,0,0,0,0,15,224,5,85,255,85,85,85,64,0,15,224,15,255,255,255,255,255,208,0,15,225,175,255,255,255,255,255,208,0,15,255,255,255,255,255,255,255,208,1,191,255,240,3,248,0,31,224,0,111,255,255,224,7,244,0,47,208,0,191,255,244,0,15,240,0,63,192,0,127,255,224,0,15,224,0,63,192,0,62,79,224,0,31,192,0,127,64,0,0,15,224,0,63,208,0,255,0,0,0,15,224,0,63,253,2,254,0,0,0,15,224,0,191,255,227,252,0,0,0,15,224,0,255,255,255,248,0,0,0,15,224,0,9,31,255,240,0,0,0,15,224,0,0,1,255,253,0,0,0,15,224,0,0,7,255,255,192,0,0,15,224,0,0,111,254,255,244,0,0,15,224,0,11,255,240,63,254,0,5,95,224,22,255,255,128,7,255,192,31,255,208,63,255,248,0,0,255,192,15,255,192,31,254,64,0,0,47,0,11,254,0,15,144,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6321  挡
  33,99,36,38,86,40,1,252,0,15,208,0,0,1,168,0,0,0,15,208,0,0,1,252,0,0,0,15,208,0,0,1,252,0,0,0,15,208,1,180,1,252,0,185,0,15,208,3,248,1,252,0,255,0,15,208,2,252,1,252,0,254,0,15,208,0,253,1,252,1,252,0,15,208,0,255,1,252,3,252,63,255,255,240,127,1,252,3,244,63,255,255,240,63,129,252,7,240,63,255,255,240,63,193,252,15,224,42,175,250,144,47,193,252,15,208,0,15,208,0,30,1,252,31,192,0,15,208,0,0,1,252,1,64,0,15,208,0,0,1,252,0,0,0,15,208,2,170,170,254,170,169,0,15,208,7,255,255,255,255,254,0,15,208,7,255,255,255,255,254,0,15,230,231,255,255,255,255,254,0,15,255,240,0,0,0,0,254,1,191,255,240,0,0,0,0,254,127,255,255,224,0,0,0,0,254,191,255,248,0,0,0,0,0,254,127,255,208,1,85,85,85,85,254,62,95,208,3,255,255,255,255,254,0,15,208,3,255,255,255,255,254,0,15,208,3,255,255,255,255,254,0,15,208,0,0,0,0,0,254,0,15,208,0,0,0,0,0,254,0,15,208,0,0,0,0,0,254,0,15,208,0,0,0,0,0,254,0,15,208,10,170,170,170,170,254,0,15,208,15,255,255,255,255,254,0,31,208,15,255,255,255,255,254,31,255,208,15,255,255,255,255,254,15,255,192,0,0,0,0,0,254,15,255,64,0,0,0,0,0,254,1,80,0,0,0,0,0,0,84,
  // 0x6324  挤
  36,99,38,38,124,40,1,252,0,47,128,0,0,6,192,0,0,0,0,63,128,0,0,31,208,0,0,0,0,63,128,0,0,15,240,0,0,0,0,63,128,0,0,11,244,0,0,0,0,63,128,21,85,87,253,85,85,0,0,63,128,63,255,255,255,255,255,128,0,63,128,63,255,255,255,255,255,128,0,63,128,63,255,255,255,255,255,128,63,255,255,64,63,64,0,63,192,0,63,255,255,64,47,192,0,191,128,0,63,255,255,64,15,224,0,255,0,0,21,127,213,0,11,244,2,253,0,0,0,63,128,0,3,253,11,252,0,0,0,63,128,0,0,255,175,240,0,0,0,63,128,0,0,127,255,192,0,0,0,63,128,0,0,31,255,64,0,0,0,63,128,0,1,255,255,244,0,0,0,63,129,1,111,255,255,255,164,0,0,63,239,127,255,254,31,255,255,208,0,63,255,63,255,208,1,191,255,192,6,255,255,47,249,0,0,6,255,64,127,255,248,9,31,192,0,190,5,0,127,255,192,0,31,192,0,254,0,0,63,255,128,0,31,192,0,254,0,0,41,63,128,0,31,192,0,254,0,0,0,63,128,0,31,192,0,254,0,0,0,63,128,0,31,192,0,254,0,0,0,63,128,0,47,192,0,254,0,0,0,63,128,0,47,192,0,254,0,0,0,63,128,0,63,192,0,254,0,0,0,63,128,0,127,128,0,254,0,0,0,63,128,0,255,0,0,254,0,0,0,63,128,3,255,0,0,254,0,0,0,63,128,15,252,0,0,254,0,0,47,255,128,127,244,0,0,254,0,0,31,255,65,255,208,0,0,254,0,0,15,254,0,126,0,0,0,254,0,0,10,144,0,0,0,0,0,105,0,0,
  // 0x635f  损
  95,99,38,39,134,40,1,251,0,31,192,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,255,255,255,255,224,0,0,47,192,0,255,255,255,255,224,0,0,47,192,0,255,255,255,255,224,0,0,47,192,0,255,0,0,15,224,0,0,47,192,0,255,0,0,15,224,0,0,47,192,0,255,0,0,15,224,0,63,255,255,224,255,0,0,15,224,0,63,255,255,224,255,255,255,255,224,0,63,255,255,224,255,255,255,255,224,0,21,111,229,64,255,255,255,255,224,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,3,255,255,255,255,252,0,0,47,192,3,255,255,255,255,252,0,0,47,192,3,255,255,255,255,252,0,0,47,192,67,248,0,0,3,252,0,0,47,219,227,248,0,0,3,252,0,0,47,255,227,248,1,84,3,252,0,6,255,255,243,248,3,252,3,252,0,191,255,254,67,248,3,252,3,252,0,191,255,208,3,248,3,252,3,252,0,127,255,192,3,248,3,252,3,252,0,36,47,192,3,248,3,248,3,252,0,0,47,192,3,248,3,248,3,252,0,0,47,192,3,248,7,244,3,252,0,0,47,192,3,248,15,240,3,252,0,0,47,192,2,164,47,240,65,84,0,0,47,192,0,0,191,193,244,0,0,0,47,192,0,2,255,71,254,0,0,0,47,192,0,47,254,2,255,208,0,0,47,192,6,255,244,0,127,252,0,47,255,192,191,255,192,0,11,255,64,31,255,192,191,253,0,0,1,255,208,15,255,0,63,144,0,0,0,47,128,10,164,0,20,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6362  换
  98,99,38,38,124,40,1,252,0,26,128,0,0,164,0,0,0,0,0,47,192,0,1,255,0,0,0,0,0,47,192,0,3,253,0,0,0,0,0,47,192,0,7,252,0,0,0,0,0,47,192,0,15,255,255,255,64,0,0,47,192,0,47,255,255,255,208,0,0,47,192,0,127,255,255,255,192,0,0,47,192,0,255,0,0,255,0,0,63,255,255,67,253,0,3,253,0,0,63,255,255,79,244,0,15,244,0,0,63,255,255,191,255,255,255,255,244,0,21,127,213,127,255,255,255,255,244,0,0,47,192,15,255,255,255,255,244,0,0,47,192,7,248,3,248,3,244,0,0,47,192,3,248,3,248,3,244,0,0,47,192,3,248,3,248,3,244,0,0,47,192,3,248,3,248,3,244,0,0,47,192,3,248,3,248,3,244,0,0,47,199,131,248,3,248,3,244,0,0,47,255,131,248,3,248,3,244,0,1,191,255,195,248,3,248,3,244,0,111,255,255,195,248,3,248,3,244,0,127,255,244,3,252,7,248,7,248,0,63,255,192,191,255,255,255,255,255,192,62,111,192,191,255,255,255,255,255,192,0,47,192,191,255,255,255,255,255,192,0,47,192,0,0,47,252,0,0,0,0,47,192,0,0,127,255,0,0,0,0,47,192,0,0,255,127,128,0,0,0,47,192,0,3,253,31,224,0,0,0,47,192,0,15,252,15,248,0,0,0,47,192,0,127,240,3,254,0,0,0,47,192,2,255,192,0,255,208,0,0,63,192,31,254,0,0,63,249,0,31,255,193,255,244,0,0,11,255,208,15,255,135,255,192,0,0,1,255,192,15,254,1,253,0,0,0,0,47,0,6,144,0,80,0,0,0,0,1,0,
  // 0x6389  掉
  137,99,38,38,124,40,1,252,0,26,128,0,0,2,160,0,0,0,0,47,192,0,0,3,244,0,0,0,0,47,192,0,0,3,244,0,0,0,0,47,192,0,0,3,244,0,0,0,0,47,192,0,0,3,255,255,255,128,0,47,192,0,0,3,255,255,255,128,0,47,192,0,0,3,255,255,255,128,0,47,192,0,0,3,244,0,0,0,63,255,255,192,0,3,244,0,0,0,63,255,255,192,0,3,244,0,0,0,63,255,255,203,255,255,255,255,252,0,21,127,229,75,255,255,255,255,252,0,0,47,192,11,255,255,255,255,252,0,0,47,192,11,240,0,0,3,252,0,0,47,192,11,240,0,0,3,252,0,0,47,192,11,240,0,0,3,252,0,0,47,192,11,255,255,255,255,252,0,0,47,192,11,255,255,255,255,252,0,0,47,219,203,255,255,255,255,252,0,0,47,255,203,240,0,0,3,252,0,1,255,255,219,240,0,0,3,252,0,127,255,255,139,240,0,0,3,252,0,63,255,224,11,255,255,255,255,252,0,63,255,192,11,255,255,255,255,252,0,41,47,192,11,255,255,255,255,252,0,0,47,192,0,0,3,244,0,0,0,0,47,192,0,0,3,244,0,0,0,0,47,192,0,0,3,244,0,0,0,0,47,192,255,255,255,255,255,255,208,0,47,192,255,255,255,255,255,255,208,0,47,192,255,255,255,255,255,255,208,0,47,192,85,85,87,249,85,85,64,0,47,192,0,0,3,244,0,0,0,0,47,192,0,0,3,244,0,0,0,63,255,192,0,0,3,244,0,0,0,47,255,128,0,0,3,244,0,0,0,31,254,0,0,0,3,244,0,0,0,5,64,0,0,0,2,164,0,0,0,
  // 0x63a2  探
  162,99,38,38,124,40,1,252,0,47,128,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,15,255,255,255,255,255,128,0,47,192,15,255,255,255,255,255,128,0,47,192,15,255,255,255,255,255,128,0,47,192,15,192,0,0,0,47,128,0,47,192,15,192,84,0,0,47,128,0,47,192,15,192,253,11,224,47,128,63,255,255,207,192,253,11,224,47,128,63,255,255,207,193,252,11,224,47,128,63,255,255,192,2,252,11,224,0,0,21,127,213,64,3,248,11,224,9,0,0,47,192,0,11,244,11,224,11,208,0,47,192,0,47,240,11,240,15,192,0,47,192,2,255,192,11,255,255,192,0,47,192,47,255,0,3,255,255,128,0,47,192,15,248,0,1,255,254,0,0,47,198,135,64,3,252,0,0,0,0,47,255,128,0,3,252,0,0,0,0,127,255,192,0,3,252,0,0,0,47,255,255,128,0,3,252,0,0,0,191,255,244,47,255,255,255,255,255,192,127,255,192,47,255,255,255,255,255,192,62,111,192,47,255,255,255,255,255,192,0,47,192,5,85,191,255,213,85,64,0,47,192,0,0,255,255,240,0,0,0,47,192,0,2,255,255,244,0,0,0,47,192,0,7,251,255,253,0,0,0,47,192,0,31,243,252,255,0,0,0,47,192,0,63,211,252,127,192,0,0,47,192,1,255,131,252,47,244,0,0,47,192,11,254,3,252,15,253,0,0,47,192,63,252,3,252,3,255,128,0,47,194,255,224,3,252,0,255,224,21,127,192,255,128,3,252,0,63,192,31,255,128,124,0,3,252,0,11,0,15,255,0,16,0,3,252,0,0,0,15,248,0,0,0,3,252,0,0,0,
  // 0x63a5  接
  165,99,37,38,124,40,1,252,0,15,208,0,0,3,252,0,0,0,0,15,224,0,0,3,252,0,0,0,0,15,224,0,0,3,252,0,0,0,0,15,224,0,0,3,252,0,0,0,0,15,224,15,255,255,255,255,255,0,0,15,224,15,255,255,255,255,255,0,0,15,224,15,255,255,255,255,255,0,0,15,224,0,11,208,0,63,128,0,63,255,255,192,15,208,0,127,64,0,63,255,255,192,15,224,0,191,0,0,63,255,255,192,11,240,0,254,0,0,21,95,245,64,7,240,0,253,0,0,0,15,224,0,3,244,1,252,0,0,0,15,224,0,7,248,3,248,0,0,0,15,224,127,255,255,255,255,255,192,0,15,224,127,255,255,255,255,255,192,0,15,224,127,255,255,255,255,255,192,0,15,224,0,0,63,192,0,0,0,0,15,226,192,0,127,128,0,0,0,0,15,255,192,0,255,0,0,0,0,0,111,255,208,1,255,0,0,0,0,27,255,255,255,255,255,255,255,255,192,191,255,249,127,255,255,255,255,255,192,127,255,224,63,255,255,255,255,255,192,62,79,224,0,15,240,0,127,64,0,16,15,224,0,47,208,0,191,0,0,0,15,224,0,63,192,0,254,0,0,0,15,224,0,191,64,2,253,0,0,0,15,224,0,255,249,7,252,0,0,0,15,224,2,255,255,239,240,0,0,0,15,224,1,186,255,255,224,0,0,0,15,224,0,0,27,255,244,0,0,0,15,224,0,0,47,255,255,128,0,0,15,224,0,27,255,251,255,244,0,31,255,208,175,255,255,128,127,255,0,15,255,192,255,255,244,0,7,255,0,11,255,64,127,249,0,0,0,188,0,6,148,0,36,0,0,0,0,0,0,
  // 0x63a7  控
  167,99,38,38,124,40,1,252,0,31,128,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,63,255,255,255,255,255,192,0,47,192,63,255,255,255,255,255,192,0,47,192,63,255,255,255,255,255,192,0,47,192,63,65,253,11,240,31,192,63,255,255,191,64,252,11,240,31,192,63,255,255,191,65,252,11,240,31,192,63,255,255,191,65,252,11,240,31,192,21,127,213,64,2,252,11,240,0,0,0,47,192,0,3,248,11,240,4,0,0,47,192,0,7,244,11,240,15,64,0,47,192,0,15,240,11,240,15,192,0,47,192,0,63,208,11,240,15,192,0,47,192,1,255,192,11,255,255,128,0,47,199,175,255,0,3,255,255,64,0,47,255,143,248,0,1,255,253,0,0,127,255,203,128,0,0,0,0,0,27,255,255,64,0,0,0,0,0,0,191,255,224,0,0,0,0,0,0,0,127,255,192,7,255,255,255,255,253,0,62,111,192,7,255,255,255,255,253,0,16,47,192,7,255,255,255,255,253,0,0,47,192,1,85,87,253,85,84,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,255,255,255,255,255,255,208,21,127,192,255,255,255,255,255,255,208,31,255,128,255,255,255,255,255,255,208,15,255,0,85,85,85,85,85,85,64,15,248,0,0,0,0,0,0,0,0,
  // 0x63d0  提
  208,99,38,38,124,40,1,252,0,47,128,0,0,0,0,0,0,0,0,47,128,1,170,170,170,170,164,0,0,47,128,2,255,255,255,255,244,0,0,47,128,2,255,255,255,255,244,0,0,47,128,2,252,0,0,3,244,0,0,47,128,2,252,0,0,3,244,0,0,47,128,2,252,0,0,3,244,0,0,47,128,2,255,255,255,255,244,0,127,255,255,194,255,255,255,255,244,0,127,255,255,194,254,170,170,171,244,0,127,255,255,194,252,0,0,3,244,0,21,127,213,66,252,0,0,3,244,0,0,47,128,2,254,170,170,175,244,0,0,47,128,2,255,255,255,255,244,0,0,47,128,2,255,255,255,255,244,0,0,47,128,0,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,0,47,134,95,255,255,255,255,255,128,0,47,255,223,255,255,255,255,255,128,1,191,255,223,255,255,255,255,255,128,111,255,255,128,0,3,248,0,0,0,191,255,224,0,80,3,248,0,0,0,127,255,128,0,253,3,248,0,0,0,57,47,128,1,252,3,248,0,0,0,0,47,128,1,252,3,255,255,248,0,0,47,128,2,248,3,255,255,248,0,0,47,128,3,252,3,255,255,248,0,0,47,128,7,253,3,248,0,0,0,0,47,128,11,255,3,248,0,0,0,0,47,128,15,255,67,248,0,0,0,0,47,128,47,223,211,248,0,0,0,0,47,128,63,139,251,248,0,0,0,0,63,128,255,2,255,248,0,0,0,47,255,131,254,0,191,255,255,255,224,31,255,71,252,0,31,255,255,255,192,15,253,1,240,0,1,191,255,255,192,5,64,0,64,0,0,0,0,0,0,
  // 0x63d2  插
  210,99,37,38,124,40,1,252,0,31,128,0,0,0,0,0,0,0,0,47,192,0,0,0,0,91,240,0,0,47,192,0,5,106,255,255,252,0,0,47,192,15,255,255,255,255,253,0,0,47,192,11,255,255,255,233,64,0,0,47,192,7,254,171,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,63,255,255,192,0,3,248,0,0,0,63,255,255,213,85,87,253,85,85,64,63,255,255,255,255,255,255,255,255,192,21,127,213,63,255,255,255,255,255,192,0,47,192,63,255,255,255,255,255,192,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,67,248,0,0,0,0,47,192,0,7,243,248,0,0,0,0,47,192,15,191,255,248,255,255,0,0,47,223,143,255,251,248,255,255,0,0,47,255,143,254,3,248,255,255,0,6,255,255,207,208,3,248,0,127,0,191,255,253,15,208,3,248,0,127,0,127,255,192,15,208,3,248,0,127,0,63,175,192,15,208,3,248,0,127,0,16,47,192,15,255,227,248,191,255,0,0,47,192,15,255,227,248,191,255,0,0,47,192,15,255,227,248,191,255,0,0,47,192,15,208,3,248,0,127,0,0,47,192,15,208,3,248,0,127,0,0,47,192,15,208,3,248,0,127,0,0,47,192,15,208,3,248,0,127,0,0,47,192,15,208,3,248,0,127,0,0,47,192,15,208,3,248,0,127,0,0,47,192,15,255,255,255,255,255,0,21,127,192,15,255,255,255,255,255,0,31,255,128,15,255,255,255,255,255,0,15,255,0,15,208,0,0,0,127,0,15,248,0,15,208,0,0,0,127,0,
  // 0x6536  收
  54,101,38,38,124,40,1,252,0,0,2,164,0,41,0,0,0,0,0,0,3,248,0,63,192,0,0,0,0,0,3,248,0,63,192,0,0,0,0,0,3,248,0,127,128,0,0,0,0,0,3,248,0,191,0,0,0,0,3,248,3,248,0,255,0,0,0,0,3,248,3,248,1,254,0,0,0,0,3,248,3,248,2,254,170,170,170,144,3,248,3,248,3,255,255,255,255,208,3,248,3,248,7,255,255,255,255,208,3,248,3,248,15,255,255,255,255,208,3,248,3,248,31,244,0,3,252,0,3,248,3,248,63,252,0,3,252,0,3,248,3,248,127,252,0,3,248,0,3,248,3,248,255,253,0,7,244,0,3,248,3,251,255,254,0,15,240,0,3,248,3,255,253,255,0,15,240,0,3,248,3,255,248,127,0,31,208,0,3,248,3,249,240,63,128,63,192,0,3,248,3,248,144,63,192,63,192,0,3,248,3,248,0,31,208,191,64,0,3,248,3,248,0,15,240,255,0,0,3,248,3,248,0,11,246,254,0,0,3,248,27,248,0,3,255,252,0,0,3,254,255,248,0,3,255,248,0,0,7,255,255,248,0,1,255,240,0,0,127,255,255,248,0,0,255,208,0,0,63,255,211,248,0,0,255,208,0,0,63,228,3,248,0,3,255,240,0,0,25,0,3,248,0,15,255,252,0,0,0,0,3,248,0,63,251,255,0,0,0,0,3,248,1,255,209,255,192,0,0,0,3,248,11,255,64,127,244,0,0,0,3,248,191,253,0,47,254,0,0,0,3,251,255,244,0,11,255,224,0,0,3,250,255,128,0,1,255,192,0,0,3,248,253,0,0,0,63,64,0,0,3,244,96,0,0,0,6,0,
  // 0x653e  放
  62,101,38,38,124,40,1,252,0,0,253,0,0,3,144,0,0,0,0,1,253,0,0,7,248,0,0,0,0,1,253,0,0,11,244,0,0,0,0,1,253,0,0,15,240,0,0,0,0,1,253,0,0,15,240,0,0,0,0,1,253,0,0,15,224,0,0,0,21,86,254,85,80,31,208,0,0,0,63,255,255,255,244,47,229,85,85,64,63,255,255,255,244,63,255,255,255,208,63,255,255,255,244,127,255,255,255,208,0,63,128,0,0,191,255,255,255,208,0,63,128,0,0,255,0,7,244,0,0,63,128,0,1,255,64,7,240,0,0,63,128,0,3,255,64,11,240,0,0,63,128,0,7,255,128,15,240,0,0,63,255,255,207,255,192,15,224,0,0,63,255,255,223,255,192,31,208,0,0,63,255,255,255,239,208,47,192,0,0,63,213,127,255,207,240,63,192,0,0,63,128,63,203,71,240,63,128,0,0,63,128,63,129,3,248,127,64,0,0,63,128,63,128,3,252,255,0,0,0,63,128,63,128,2,254,254,0,0,0,63,64,63,128,0,255,252,0,0,0,127,64,63,128,0,191,248,0,0,0,127,0,63,128,0,63,240,0,0,0,191,0,63,128,0,63,240,0,0,0,255,0,63,128,0,127,240,0,0,0,254,0,63,64,0,255,252,0,0,2,253,0,63,64,3,255,254,0,0,3,252,0,63,64,15,254,255,128,0,11,248,0,127,0,127,240,191,224,0,15,240,0,191,2,255,208,47,252,0,63,224,0,255,47,255,0,15,255,128,191,192,255,255,191,252,0,3,255,208,127,64,255,253,63,224,0,0,191,64,13,0,191,244,47,0,0,0,30,0,0,0,21,0,4,0,0,0,0,0,
  // 0x6570  数
  112,101,38,38,124,40,1,252,0,0,63,0,0,0,228,0,0,0,1,192,63,64,228,1,253,0,0,0,11,240,63,66,252,2,252,0,0,0,3,244,63,67,244,3,252,0,0,0,1,252,63,75,224,3,252,0,0,0,0,253,63,95,192,3,248,0,0,0,0,164,63,70,0,7,244,0,0,0,63,255,255,255,255,11,250,170,170,128,63,255,255,255,255,15,255,255,255,208,63,255,255,255,255,31,255,255,255,208,0,2,255,208,0,47,255,255,255,208,0,7,255,248,0,63,208,3,252,0,0,31,255,255,64,127,208,3,248,0,0,127,255,191,224,255,224,7,248,0,2,255,127,95,252,255,240,7,244,0,31,252,63,67,250,255,240,11,240,0,127,240,63,64,247,255,244,15,240,0,63,128,63,64,15,251,248,15,240,0,13,0,191,64,31,243,252,31,224,0,0,2,252,0,11,226,252,47,208,0,0,3,252,0,2,192,253,63,192,0,0,7,244,0,0,0,255,127,128,0,127,255,255,255,255,64,191,191,64,0,127,255,255,255,255,64,127,255,0,0,127,255,255,255,255,64,63,254,0,0,0,127,64,47,192,0,47,252,0,0,0,255,0,63,128,0,15,248,0,0,1,253,0,127,64,0,31,248,0,0,3,255,128,255,0,0,63,252,0,0,11,255,250,253,0,0,255,255,0,0,11,255,255,252,0,3,255,255,128,0,0,65,255,252,0,15,253,127,224,0,0,0,255,255,128,127,248,47,248,0,0,31,255,255,247,255,224,11,255,0,27,255,252,63,255,255,64,3,255,208,63,255,208,7,255,252,0,0,191,192,15,249,0,0,139,224,0,0,47,0,10,64,0,0,3,0,0,0,5,0,
  // 0x6572  敲
  114,101,37,38,124,40,2,252,0,1,252,0,0,0,253,0,0,0,0,1,252,0,0,0,254,0,0,0,0,1,252,0,0,0,254,0,0,0,0,1,252,0,0,0,254,0,0,0,0,1,252,0,0,0,254,0,0,0,255,255,255,255,252,0,254,85,85,0,255,255,255,255,252,0,255,255,255,0,255,255,255,255,252,0,255,255,255,0,0,0,0,0,0,0,255,255,255,0,1,170,170,169,0,0,254,0,0,0,3,255,255,255,0,0,254,0,0,0,3,255,255,255,0,0,254,0,0,0,3,244,0,191,0,0,254,0,0,0,3,244,0,191,0,0,254,0,0,0,3,244,0,191,15,255,255,255,248,0,3,250,170,255,15,255,255,255,252,0,3,255,255,255,15,255,255,255,248,0,3,255,255,255,5,89,85,91,244,0,0,0,0,0,0,253,0,11,240,0,0,0,0,0,0,254,0,15,240,0,63,255,255,255,240,127,0,31,224,0,63,255,255,255,240,63,64,47,208,0,63,170,170,175,240,63,128,63,192,0,63,0,0,3,240,31,192,127,128,0,63,0,0,3,240,15,224,255,0,0,63,15,255,195,240,11,241,255,0,0,63,15,255,195,240,3,255,253,0,0,63,15,3,195,240,2,255,252,0,0,63,15,3,195,240,0,255,240,0,0,63,15,3,195,240,0,191,224,0,0,63,15,3,195,240,1,255,240,0,0,63,15,255,195,240,7,255,253,0,0,63,15,255,195,240,31,255,255,64,0,63,15,0,3,241,255,240,255,244,0,63,10,0,7,255,255,192,63,255,64,63,0,2,255,251,254,0,11,255,0,63,0,0,255,211,224,0,0,252,0,63,0,0,169,1,64,0,0,20,0,
  // 0x6574  整
  116,101,36,37,77,40,2,253,0,0,252,0,0,2,64,0,0,0,0,252,0,0,3,244,0,0,106,170,254,170,164,7,240,0,0,191,255,255,255,248,15,240,0,0,191,255,255,255,248,31,224,0,0,0,0,252,0,0,63,255,255,255,0,0,252,0,0,191,255,255,255,47,255,255,255,240,255,255,255,255,47,255,255,255,243,255,0,31,192,47,149,253,87,255,255,192,63,128,47,64,252,3,255,255,208,127,0,47,64,252,3,243,195,244,254,0,47,255,255,255,240,2,255,252,0,47,255,255,255,240,0,255,244,0,5,95,255,149,80,0,127,224,0,0,47,255,240,0,0,255,244,0,0,255,255,254,0,7,255,254,0,7,253,253,191,224,47,254,255,208,47,240,252,31,231,255,224,127,253,255,192,252,3,223,255,64,31,255,127,0,252,0,11,248,0,2,253,40,0,252,0,3,128,0,0,44,0,0,0,0,0,0,0,0,0,7,255,255,255,255,255,255,255,208,7,255,255,255,255,255,255,255,208,7,255,255,255,255,255,255,255,208,0,0,0,0,254,0,0,0,0,0,6,144,0,254,0,0,0,0,0,11,240,0,255,255,255,248,0,0,11,240,0,255,255,255,248,0,0,11,240,0,255,255,255,248,0,0,11,240,0,254,0,0,0,0,0,11,240,0,254,0,0,0,0,0,15,240,0,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x6599  料
  153,101,38,38,124,40,1,252,0,2,164,0,0,0,0,42,64,0,0,3,248,0,0,0,0,63,128,0,0,3,248,0,0,0,0,63,128,0,47,3,248,31,192,52,0,63,128,0,47,3,248,31,128,254,0,63,128,0,31,131,248,47,65,255,192,63,128,0,15,195,248,63,0,127,240,63,128,0,15,195,248,63,0,15,252,63,128,0,11,211,248,125,0,2,252,63,128,0,7,227,248,188,0,0,184,63,128,0,7,227,248,252,0,0,32,63,128,0,3,243,249,244,0,0,0,63,128,0,3,67,248,96,0,0,0,63,128,0,0,3,248,0,2,0,0,63,128,0,63,255,255,255,203,208,0,63,128,0,63,255,255,255,223,252,0,63,128,0,63,255,255,255,203,255,64,63,128,0,21,111,253,85,64,255,224,63,128,0,0,31,252,0,0,47,208,63,128,0,0,47,255,0,0,7,192,63,128,0,0,63,255,128,0,1,0,63,128,0,0,191,255,208,0,0,0,63,128,0,0,255,255,244,0,0,0,63,134,128,1,251,250,252,0,0,0,63,255,192,3,243,248,255,0,1,111,255,255,208,7,243,248,127,70,255,255,255,255,208,15,211,248,62,63,255,255,255,208,0,47,195,248,28,63,255,250,127,128,0,127,131,248,0,63,229,0,63,128,0,191,3,248,0,16,0,0,63,128,0,62,3,248,0,0,0,0,63,128,0,44,3,248,0,0,0,0,63,128,0,4,3,248,0,0,0,0,63,128,0,0,3,248,0,0,0,0,63,128,0,0,3,248,0,0,0,0,63,128,0,0,3,248,0,0,0,0,63,128,0,0,3,248,0,0,0,0,63,128,0,0,2,244,0,0,0,0,47,128,0,
  // 0x659c  斜
  156,101,38,38,124,40,1,252,0,0,127,64,0,0,0,11,224,0,0,0,255,224,0,0,0,15,224,0,0,1,255,248,0,0,0,15,224,0,0,3,255,254,0,2,64,15,224,0,0,11,250,255,128,15,208,15,224,0,0,31,240,191,224,31,248,15,224,0,0,63,208,47,248,7,254,15,224,0,0,191,128,15,253,0,255,143,224,0,2,255,0,3,255,0,63,223,224,0,7,252,0,0,252,0,15,207,224,0,31,244,0,0,112,0,7,15,224,0,127,255,255,255,224,0,0,15,224,0,255,255,255,255,224,0,0,15,224,0,62,255,255,255,224,8,0,15,224,0,8,21,127,213,64,127,64,15,224,0,0,0,63,128,0,191,224,15,224,0,0,0,63,128,0,31,248,15,224,0,0,0,63,128,0,7,255,15,224,0,63,255,255,255,254,0,255,143,224,0,63,255,255,255,254,0,62,15,224,0,63,255,255,255,254,0,8,15,224,0,21,85,127,213,84,0,0,15,224,0,0,0,63,128,0,0,0,15,251,192,0,64,63,128,128,0,0,95,255,208,2,252,63,139,224,0,111,255,255,224,3,248,63,135,240,111,255,255,255,144,3,244,63,131,244,255,255,255,240,0,7,240,63,130,252,255,255,159,224,0,11,240,63,128,252,254,64,15,224,0,15,208,63,128,254,0,0,15,224,0,47,192,63,128,191,0,0,15,224,0,63,128,63,128,63,0,0,15,224,0,127,0,63,128,52,0,0,15,224,0,30,0,63,128,0,0,0,15,224,0,0,21,127,128,0,0,0,15,224,0,0,63,255,128,0,0,0,15,224,0,0,31,255,0,0,0,0,15,224,0,0,15,248,0,0,0,0,15,224,0,
  // 0x65ad  断
  173,101,36,38,86,40,3,252,0,0,5,64,0,0,0,0,0,84,0,31,128,0,0,0,11,192,253,0,31,128,0,0,1,191,240,253,44,31,131,144,0,191,255,248,253,61,31,131,242,255,255,255,128,253,62,31,135,226,255,255,224,0,253,47,31,139,194,255,148,0,0,253,31,95,143,130,252,0,0,0,253,15,95,159,66,252,0,0,0,253,15,159,175,2,252,0,0,0,253,9,31,137,2,252,0,0,0,253,0,31,128,2,252,0,0,0,253,191,255,255,242,252,0,0,0,253,191,255,255,242,253,85,85,85,253,191,255,255,242,255,255,255,254,253,0,63,128,2,255,255,255,254,253,0,127,192,2,255,255,255,254,253,0,255,240,2,252,0,254,0,253,1,255,252,2,252,0,254,0,253,3,255,255,2,252,0,254,0,253,11,255,175,194,252,0,254,0,253,31,223,143,226,252,0,254,0,253,63,95,131,195,252,0,254,0,254,255,31,129,67,248,0,254,0,254,252,31,128,3,244,0,254,0,253,180,31,128,3,244,0,254,0,253,96,31,128,7,240,0,254,0,253,0,31,128,11,240,0,254,0,253,0,31,128,15,240,0,254,0,253,0,0,0,31,208,0,254,0,255,255,255,255,255,192,0,254,0,255,255,255,255,255,192,0,254,0,255,255,255,255,255,64,0,254,0,254,0,0,2,255,0,0,254,0,253,0,0,3,253,0,0,254,0,253,0,0,7,252,0,0,254,0,84,0,0,0,240,0,0,254,0,0,0,0,0,80,0,0,169,0,
  // 0x65b0  新
  176,101,38,38,124,40,1,252,0,0,106,0,0,0,0,0,16,0,0,0,127,0,0,0,0,1,252,0,0,0,127,0,0,0,0,127,255,64,0,0,127,0,0,36,111,255,254,64,31,255,255,255,252,63,255,255,144,0,31,255,255,255,252,63,255,228,0,0,31,255,255,255,252,63,208,0,0,0,0,104,0,30,64,63,64,0,0,0,0,252,0,47,192,63,64,0,0,0,0,253,0,63,64,63,64,0,0,0,0,190,0,63,0,63,64,0,0,0,0,127,0,191,0,63,64,0,0,0,0,63,0,253,0,63,64,0,0,0,0,62,0,108,0,63,64,0,0,0,63,255,255,255,254,63,255,255,255,208,63,255,255,255,254,63,255,255,255,208,63,255,255,255,254,63,255,255,255,208,0,0,127,0,0,63,149,111,229,64,0,0,127,0,0,63,64,31,192,0,0,0,127,0,0,63,64,31,192,0,0,0,191,0,0,127,64,31,192,0,63,255,255,255,252,127,0,31,192,0,63,255,255,255,252,127,0,31,192,0,63,255,255,255,252,191,0,31,192,0,0,2,255,0,0,191,0,31,192,0,0,3,255,208,0,255,0,31,192,0,0,15,255,244,0,254,0,31,192,0,0,47,255,254,0,253,0,31,192,0,0,191,255,191,193,252,0,31,192,0,1,254,127,47,243,252,0,31,192,0,7,252,127,11,211,248,0,31,192,0,47,240,127,2,139,240,0,31,192,0,191,208,127,0,31,240,0,31,192,0,63,64,127,0,63,208,0,31,192,0,13,0,127,0,191,192,0,31,192,0,0,0,127,0,255,0,0,31,192,0,0,0,127,0,61,0,0,31,192,0,0,0,127,0,24,0,0,26,128,0,
  // 0x65b9  方
  185,101,36,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,106,170,170,255,170,170,170,170,169,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,2,255,255,255,255,252,0,0,0,2,255,255,255,255,252,0,0,0,3,255,255,255,255,252,0,0,0,3,254,170,170,171,252,0,0,0,7,248,0,0,3,252,0,0,0,11,244,0,0,3,252,0,0,0,15,240,0,0,3,248,0,0,0,31,240,0,0,3,248,0,0,0,63,224,0,0,3,248,0,0,0,127,192,0,0,7,244,0,0,0,255,128,0,0,7,244,0,0,2,255,0,0,0,11,240,0,0,7,254,0,0,0,15,240,0,0,31,252,0,0,0,15,240,0,0,127,240,0,0,0,15,224,0,2,255,208,0,0,0,47,208,0,31,255,64,0,0,0,127,192,0,255,253,0,0,127,255,255,192,0,191,240,0,0,63,255,255,64,0,47,128,0,0,47,255,253,0,0,8,0,0,0,5,85,64,0,0,
  // 0x65e0  无
  224,101,37,36,104,40,2,251,7,255,255,255,255,255,255,255,224,0,7,255,255,255,255,255,255,255,224,0,7,255,255,255,255,255,255,255,224,0,2,170,170,171,254,170,170,170,144,0,0,0,0,2,252,0,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,0,3,252,0,0,0,0,0,106,170,170,171,254,170,170,170,169,0,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,0,0,0,0,7,244,0,0,0,0,0,0,0,0,11,245,80,0,0,0,0,0,0,0,15,251,240,0,0,0,0,0,0,0,15,235,240,0,0,0,0,0,0,0,47,219,240,0,0,0,0,0,0,0,63,203,240,0,0,0,0,0,0,0,127,203,240,0,0,0,0,0,0,0,255,75,240,0,0,0,0,0,0,1,255,11,240,0,0,0,0,0,0,3,254,11,240,0,0,0,0,0,0,15,252,11,240,0,0,56,0,0,0,63,244,11,240,0,0,63,64,0,0,255,224,11,240,0,0,63,64,0,7,255,128,11,240,0,0,127,64,0,47,255,0,11,244,0,0,191,0,2,255,248,0,11,248,0,0,255,0,127,255,208,0,7,255,255,255,254,0,255,254,0,0,3,255,255,255,253,0,63,224,0,0,1,255,255,255,248,0,30,0,0,0,0,26,170,170,128,0,0,0,0,0,0,0,0,0,0,0,
  // 0x65f6  时
  246,101,36,38,86,40,3,252,0,0,0,0,0,0,1,168,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,85,85,85,64,0,0,3,252,0,255,255,255,192,0,0,3,252,0,255,255,255,192,0,0,3,252,0,255,255,255,192,0,0,3,252,0,254,0,31,192,0,0,3,252,0,254,0,31,195,255,255,255,255,253,254,0,31,195,255,255,255,255,253,254,0,31,195,255,255,255,255,253,254,0,31,194,170,170,171,254,169,254,0,31,192,0,0,3,252,0,254,0,31,192,0,0,3,252,0,254,0,31,192,0,0,3,252,0,255,255,255,192,44,0,3,252,0,255,255,255,192,255,0,3,252,0,255,255,255,192,191,128,3,252,0,255,85,111,192,63,208,3,252,0,254,0,31,192,31,240,3,252,0,254,0,31,192,11,248,3,252,0,254,0,31,192,3,252,3,252,0,254,0,31,192,1,255,3,252,0,254,0,31,192,0,255,67,252,0,254,0,31,192,0,127,67,252,0,254,0,31,192,0,56,3,252,0,254,0,31,192,0,0,3,252,0,255,255,255,192,0,0,3,252,0,255,255,255,192,0,0,3,252,0,255,255,255,192,0,0,3,252,0,255,85,85,64,0,0,3,252,0,254,0,0,0,0,0,3,252,0,254,0,0,0,0,0,3,252,0,84,0,0,0,1,170,175,252,0,0,0,0,0,0,255,255,248,0,0,0,0,0,0,255,255,240,0,0,0,0,0,0,191,254,64,0,0,0,0,0,0,0,0,0,0,
  // 0x660e  明
  14,102,34,36,68,40,3,252,85,85,85,64,63,255,255,255,240,255,255,255,224,63,255,255,255,240,255,255,255,224,63,255,255,255,240,255,255,255,224,63,149,85,91,240,254,0,15,224,63,64,0,11,240,254,0,15,224,63,64,0,11,240,254,0,15,224,63,64,0,11,240,254,0,15,224,63,64,0,11,240,254,0,15,224,63,64,0,11,240,254,0,15,224,63,149,85,91,240,254,0,15,224,63,255,255,255,240,255,255,255,224,63,255,255,255,240,255,255,255,224,63,255,255,255,240,255,255,255,224,63,64,0,11,240,255,85,95,224,63,64,0,11,240,254,0,15,224,63,64,0,11,240,254,0,15,224,127,64,0,11,240,254,0,15,224,127,64,0,11,240,254,0,15,224,127,64,0,11,240,254,0,15,224,127,149,85,91,240,254,0,15,224,191,255,255,255,240,255,85,95,224,191,255,255,255,240,255,255,255,224,255,255,255,255,240,255,255,255,224,254,0,0,11,240,255,255,255,225,253,0,0,11,240,254,0,0,3,252,0,0,11,240,254,0,0,3,252,0,0,11,240,254,0,0,11,244,0,0,11,240,169,0,0,15,240,0,0,11,240,0,0,0,63,224,0,0,11,240,0,0,0,191,192,0,0,11,240,0,0,1,255,64,0,0,11,240,0,0,11,254,0,0,255,255,240,0,0,15,252,0,0,127,255,224,0,0,3,224,0,0,63,255,128,0,0,0,128,0,0,26,148,0,
  // 0x662f  是
  47,102,36,36,68,40,2,252,0,191,255,255,255,255,255,253,0,0,191,255,255,255,255,255,253,0,0,191,255,255,255,255,255,253,0,0,191,0,0,0,0,1,253,0,0,191,0,0,0,0,1,253,0,0,191,170,170,170,170,170,253,0,0,191,255,255,255,255,255,253,0,0,191,255,255,255,255,255,253,0,0,191,0,0,0,0,1,253,0,0,191,0,0,0,0,1,253,0,0,191,0,0,0,0,1,253,0,0,191,255,255,255,255,255,253,0,0,191,255,255,255,255,255,253,0,0,127,255,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,21,85,85,85,191,85,85,85,84,0,2,80,0,127,0,0,0,0,0,7,248,0,127,0,0,0,0,0,11,244,0,127,0,0,0,0,0,15,240,0,127,255,255,255,192,0,15,240,0,127,255,255,255,192,0,47,240,0,127,255,255,255,192,0,63,252,0,127,64,0,0,0,0,127,254,0,127,0,0,0,0,0,255,255,64,127,0,0,0,0,3,254,127,240,127,0,0,0,0,11,252,31,254,191,0,0,0,0,47,244,7,255,255,170,85,85,85,191,224,0,255,255,255,255,255,255,255,128,0,31,255,255,255,255,254,62,0,0,0,27,255,255,255,253,8,0,0,0,0,0,0,0,0,
  // 0x6682  暂
  130,102,36,39,95,40,2,251,0,2,64,0,0,0,0,0,0,0,7,248,0,0,0,0,6,224,0,15,240,0,0,1,107,255,244,255,255,255,255,248,127,255,255,252,255,255,255,255,248,127,255,254,64,191,255,255,255,248,127,148,0,0,0,254,0,0,0,127,0,0,0,3,252,26,128,0,127,0,0,0,11,240,47,192,0,127,0,0,0,31,208,47,192,0,191,255,255,255,127,255,255,255,252,191,255,255,255,63,255,255,255,252,191,255,255,255,47,255,255,255,252,190,0,254,0,0,0,47,192,0,253,0,254,0,0,0,47,192,0,253,0,254,0,0,1,111,255,245,252,0,254,0,127,255,255,255,246,252,0,254,0,191,255,255,255,167,248,0,254,0,191,250,175,192,11,240,0,254,0,16,0,47,192,15,224,0,254,0,0,0,47,192,2,192,0,254,0,0,0,26,128,0,0,0,20,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,64,0,0,0,1,252,0,0,63,64,0,0,0,1,252,0,0,63,64,0,0,0,1,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,234,170,170,170,171,252,0,0,63,64,0,0,0,1,252,0,0,63,64,0,0,0,1,252,0,0,63,64,0,0,0,1,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,64,0,0,0,1,252,0,0,0,0,0,0,0,0,0,0,
  // 0x66ab  暫
  171,102,36,38,86,40,2,252,0,0,252,0,0,0,0,1,64,0,0,252,0,0,0,0,111,208,21,85,253,85,80,229,175,255,244,127,255,255,255,244,255,255,255,144,127,255,255,255,244,255,255,144,0,0,0,252,0,0,254,64,0,0,26,171,255,170,144,252,0,0,0,31,255,255,255,224,252,0,0,0,31,64,252,7,224,252,0,0,0,31,64,252,7,224,255,255,255,255,31,255,255,255,224,255,255,255,255,31,234,254,175,225,255,255,255,255,31,64,252,7,225,252,0,253,0,31,255,255,255,226,252,0,253,0,31,255,255,255,227,248,0,253,0,0,0,252,0,3,244,0,253,0,0,1,253,0,11,240,0,253,0,255,255,255,255,255,224,0,253,0,255,255,255,255,255,192,0,253,0,0,0,252,0,191,64,0,253,0,0,0,252,0,62,0,0,253,0,0,0,168,0,8,0,0,84,0,0,31,255,255,255,255,255,244,0,0,31,255,255,255,255,255,244,0,0,31,255,255,255,255,255,244,0,0,31,208,0,0,0,7,244,0,0,31,208,0,0,0,7,244,0,0,31,208,0,0,0,7,244,0,0,31,255,255,255,255,255,244,0,0,31,255,255,255,255,255,244,0,0,31,234,170,170,170,175,244,0,0,31,208,0,0,0,7,244,0,0,31,208,0,0,0,7,244,0,0,31,255,255,255,255,255,244,0,0,31,255,255,255,255,255,244,0,0,31,255,255,255,255,255,244,0,0,31,208,0,0,0,7,244,0,0,10,128,0,0,0,2,164,0,
  // 0x66f4  更
  244,102,37,36,104,40,2,252,127,255,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,255,253,0,21,85,85,85,255,149,85,85,84,0,0,0,0,0,191,0,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,0,191,64,0,0,0,0,0,255,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,255,192,0,0,254,0,0,191,0,0,63,192,0,0,254,0,0,191,0,0,63,192,0,0,254,0,0,191,0,0,63,192,0,0,255,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,255,192,0,0,254,0,0,191,0,0,63,192,0,0,254,0,0,191,0,0,63,192,0,0,254,0,0,191,0,0,63,192,0,0,255,0,0,191,0,0,63,192,0,0,255,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,255,192,0,0,1,128,1,254,0,0,0,0,0,0,31,224,3,252,0,0,0,0,0,0,15,244,7,252,0,0,0,0,0,0,7,254,15,244,0,0,0,0,0,0,1,255,191,240,0,0,0,0,0,0,0,127,255,192,0,0,0,0,0,0,0,47,255,192,0,0,0,0,0,0,1,191,255,254,64,0,0,0,0,0,111,255,255,255,255,165,64,0,0,111,255,255,71,255,255,255,255,255,64,127,255,244,0,47,255,255,255,255,0,47,254,0,0,0,27,255,255,254,0,14,64,0,0,0,0,0,86,168,0,
  // 0x6700  最
  0,103,36,37,77,40,2,252,0,26,170,170,170,170,170,168,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,128,0,0,0,2,252,0,0,63,128,0,0,0,2,252,0,0,63,213,85,85,85,87,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,128,0,0,0,2,252,0,0,63,128,0,0,0,2,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,21,85,85,85,85,85,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,253,191,255,255,255,255,255,255,255,253,191,255,255,255,255,255,255,255,253,1,252,0,47,192,0,0,0,0,1,252,0,47,192,0,0,0,0,1,255,255,255,207,255,255,255,224,1,255,255,255,207,255,255,255,240,1,254,170,191,203,255,255,255,224,1,252,0,47,192,188,0,47,208,1,252,0,47,192,254,0,63,192,1,254,170,191,192,127,0,255,64,1,255,255,255,192,63,194,255,0,1,255,255,255,192,31,231,252,0,1,252,0,47,192,11,255,244,0,1,252,0,47,192,3,255,224,0,1,252,21,191,192,2,255,192,0,191,255,255,255,192,31,255,244,0,255,255,255,255,193,255,255,254,0,191,255,165,111,239,255,210,255,248,84,0,0,47,239,254,0,127,255,0,0,0,47,207,224,0,11,252,0,0,0,47,198,0,0,0,104,
  // 0x6709  有
  9,103,36,38,86,40,2,252,0,0,0,36,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,0,0,0,0,0,21,85,86,255,85,85,85,85,84,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,0,0,31,240,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,2,255,255,255,255,255,252,0,0,7,255,255,255,255,255,252,0,0,15,255,255,255,255,255,252,0,0,63,254,0,0,0,3,252,0,0,255,254,0,0,0,2,252,0,2,255,254,0,0,0,2,252,0,11,254,254,0,0,0,3,252,0,63,248,255,255,255,255,255,252,0,255,224,255,255,255,255,255,252,0,255,128,255,255,255,255,255,252,0,61,0,254,0,0,0,2,252,0,20,0,254,0,0,0,2,252,0,0,0,254,0,0,0,2,252,0,0,0,254,0,0,0,3,252,0,0,0,255,255,255,255,255,252,0,0,0,255,255,255,255,255,252,0,0,0,255,255,255,255,255,252,0,0,0,254,0,0,0,2,252,0,0,0,254,0,0,0,2,252,0,0,0,254,0,0,0,2,252,0,0,0,254,0,0,0,3,252,0,0,0,254,0,0,63,255,252,0,0,0,254,0,0,31,255,248,0,0,0,254,0,0,15,255,224,0,0,0,169,0,0,10,149,0,0,
  // 0x671f  期
  31,103,36,37,77,40,1,252,0,190,0,15,208,0,0,0,0,0,190,0,15,208,15,255,255,255,0,190,0,15,208,15,255,255,255,0,190,0,15,208,15,255,255,255,0,191,0,31,224,15,229,85,191,63,255,255,255,255,79,208,0,191,63,255,255,255,255,79,208,0,191,63,255,255,255,255,79,208,0,191,0,190,0,15,208,15,208,0,191,0,190,0,15,208,15,208,0,191,0,190,0,15,208,15,229,85,191,0,191,255,255,208,15,255,255,255,0,191,255,255,208,15,255,255,255,0,191,255,255,208,15,255,255,255,0,190,0,15,208,15,208,0,191,0,190,0,15,208,15,208,0,191,0,190,0,15,208,15,208,0,191,0,191,255,255,208,15,208,0,191,0,191,255,255,208,15,208,0,191,0,191,255,255,208,15,229,85,191,0,190,0,15,208,15,255,255,255,0,190,0,15,208,31,255,255,255,0,190,0,15,208,31,255,255,255,0,191,0,31,224,31,192,0,191,127,255,255,255,255,47,192,0,191,127,255,255,255,255,47,192,0,191,127,255,255,255,255,63,128,0,191,0,0,0,0,0,63,128,0,191,0,47,128,124,0,127,64,0,191,0,63,192,255,0,127,0,0,191,0,255,64,127,192,191,0,0,191,1,255,0,47,224,254,0,0,191,7,252,0,15,242,253,0,0,191,31,244,0,7,251,252,2,255,255,63,224,0,2,215,248,0,255,254,31,192,0,0,1,240,0,255,248,2,0,0,0,0,16,0,85,64,
  // 0x673a  机
  58,103,38,38,124,40,1,252,0,1,252,0,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,0,2,252,0,2,170,170,170,0,0,0,2,252,0,7,255,255,255,64,0,0,2,252,0,7,255,255,255,64,0,0,2,252,0,7,255,255,255,64,0,0,2,252,0,7,244,0,63,64,0,0,2,252,0,7,244,0,63,64,0,0,2,252,0,7,244,0,63,64,0,63,255,255,255,135,244,0,63,64,0,63,255,255,255,135,244,0,63,64,0,63,255,255,255,135,244,0,63,64,0,26,171,254,170,71,244,0,63,64,0,0,7,252,0,7,244,0,63,64,0,0,11,252,0,7,244,0,63,64,0,0,15,252,0,7,244,0,63,64,0,0,31,254,0,7,244,0,63,64,0,0,47,255,128,7,244,0,63,64,0,0,63,255,224,7,240,0,63,64,0,0,127,255,244,7,240,0,63,64,0,0,254,254,253,7,240,0,63,64,0,1,250,252,255,11,240,0,63,64,0,3,246,252,63,139,240,0,63,64,0,7,242,252,47,15,240,0,63,64,0,15,210,252,13,15,224,0,63,64,0,47,194,252,0,15,208,0,63,64,0,127,130,252,0,31,208,0,63,64,0,191,2,252,0,47,192,0,63,66,128,61,2,252,0,63,192,0,63,66,240,28,2,252,0,127,128,0,63,66,240,0,2,252,0,255,0,0,63,66,240,0,2,252,1,255,0,0,63,67,240,0,2,252,3,253,0,0,63,67,240,0,2,252,11,252,0,0,63,131,240,0,2,252,31,244,0,0,63,255,224,0,2,252,63,224,0,0,63,255,208,0,2,252,11,192,0,0,31,255,128,0,1,252,1,0,0,0,1,84,0,
  // 0x6740  杀
  64,103,36,38,86,40,2,252,0,0,0,0,0,0,2,128,0,0,20,0,0,0,0,15,244,0,0,127,128,0,0,0,127,248,0,0,255,253,0,0,2,255,224,0,0,47,255,224,0,31,255,64,0,0,2,255,254,0,191,248,0,0,0,0,31,255,235,255,208,0,0,0,0,1,191,255,254,0,0,0,0,0,0,15,255,248,0,0,0,0,0,0,191,255,255,64,0,0,0,0,11,255,251,255,244,0,0,0,1,255,255,128,191,255,64,0,0,111,255,244,0,11,255,244,0,27,255,255,64,0,0,191,255,0,127,255,228,0,0,0,31,255,128,31,254,0,0,191,0,1,254,0,7,144,0,0,255,0,0,44,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,21,85,85,85,255,85,85,85,84,191,255,255,255,255,255,255,255,253,191,255,255,255,255,255,255,255,253,191,255,255,255,255,255,255,255,253,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,228,0,255,0,29,0,0,0,3,254,0,255,0,191,128,0,0,11,252,0,255,0,127,224,0,0,47,240,0,255,0,31,248,0,0,191,208,0,255,0,7,255,0,2,255,64,0,255,0,1,255,192,11,254,0,0,255,0,0,127,224,63,248,0,0,255,0,0,31,248,255,224,0,0,255,0,0,7,253,127,128,2,170,255,0,0,2,248,29,0,2,255,255,0,0,0,144,0,0,1,255,253,0,0,0,0,0,0,0,255,224,0,0,0,0,
  // 0x675f  束
  95,103,36,38,86,40,2,252,0,0,0,0,170,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,21,85,85,85,255,85,85,85,84,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,85,85,85,255,85,85,85,0,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,253,0,0,255,0,0,127,64,0,253,0,0,255,0,0,127,64,0,253,0,0,255,0,0,127,64,0,253,0,0,255,0,0,127,64,0,253,0,0,255,0,0,127,64,0,254,85,85,255,85,85,191,64,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,0,0,31,255,244,0,0,0,0,0,0,191,255,254,0,0,0,0,0,2,255,255,255,128,0,0,0,0,11,253,255,127,240,0,0,0,0,127,244,255,31,253,0,0,0,2,255,208,255,7,255,128,0,0,31,255,0,255,0,255,244,0,1,255,252,0,255,0,63,255,64,31,255,224,0,255,0,11,255,248,255,255,0,0,255,0,0,255,255,127,244,0,0,255,0,0,31,253,47,128,0,0,255,0,0,2,248,4,0,0,0,255,0,0,0,32,0,0,0,0,254,0,0,0,0,
  // 0x6761  条
  97,103,36,38,86,40,2,252,0,0,0,105,0,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,11,253,0,0,4,0,0,0,0,47,255,255,255,255,64,0,0,0,127,255,255,255,255,192,0,0,2,255,255,255,255,255,128,0,0,15,255,128,0,2,255,0,0,0,127,255,224,0,11,253,0,0,3,255,239,248,0,47,244,0,0,47,255,3,255,0,255,208,0,0,15,248,1,255,215,255,64,0,0,3,208,0,63,255,253,0,0,0,0,0,0,11,255,240,0,0,0,0,0,0,47,255,253,0,0,0,0,0,6,255,255,255,228,0,0,0,1,191,255,210,255,255,229,0,1,191,255,253,0,47,255,255,250,127,255,255,144,0,1,255,255,254,63,255,248,0,255,0,6,255,252,31,249,0,0,255,0,0,6,244,9,0,0,0,255,0,0,0,0,21,85,85,85,255,85,85,85,84,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,0,127,255,253,0,0,0,0,0,2,255,255,255,128,0,0,0,0,11,252,255,63,224,0,0,0,0,127,240,255,15,253,0,0,0,2,255,192,255,3,255,192,0,0,47,254,0,255,0,191,248,0,1,255,244,0,255,0,31,255,144,111,255,192,0,255,0,3,255,254,255,253,0,0,255,0,0,127,255,63,224,0,0,255,0,0,7,252,30,0,0,0,255,0,0,0,116,0,0,0,0,254,0,0,0,0,
  // 0x6765  来
  101,103,36,38,86,40,2,252,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,6,170,170,170,255,170,170,170,160,0,2,128,0,255,0,1,224,0,0,47,208,0,255,0,3,253,0,0,15,240,0,255,0,7,252,0,0,11,244,0,255,0,15,244,0,0,3,252,0,255,0,15,240,0,0,2,253,0,255,0,47,208,0,0,0,255,0,255,0,127,128,0,0,0,254,0,255,0,255,0,0,0,0,96,0,255,0,25,0,0,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,106,170,170,191,255,254,170,170,169,0,0,0,63,255,252,0,0,0,0,0,0,255,255,255,0,0,0,0,0,3,254,255,191,192,0,0,0,0,15,248,255,47,240,0,0,0,0,63,240,255,15,252,0,0,0,0,255,192,255,3,255,0,0,0,7,255,0,255,0,255,208,0,0,47,252,0,255,0,63,248,0,0,255,240,0,255,0,15,255,0,11,255,192,0,255,0,3,255,224,191,254,0,0,255,0,0,191,254,255,244,0,0,255,0,0,31,255,63,128,0,0,255,0,0,3,253,29,0,0,0,255,0,0,0,120,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,
  // 0x677f  板
  127,103,38,38,124,40,1,252,0,3,240,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,3,244,0,21,85,85,85,85,64,0,3,244,0,63,255,255,255,255,128,0,3,244,0,63,255,255,255,255,128,0,3,244,0,63,255,255,255,255,128,0,3,244,0,63,128,0,0,0,0,0,3,244,0,63,128,0,0,0,0,0,3,244,0,63,128,0,0,0,0,63,255,255,252,63,128,0,0,0,0,63,255,255,252,63,128,0,0,0,0,63,255,255,252,63,128,0,0,0,0,21,95,249,84,63,128,0,0,0,0,0,15,244,0,63,255,255,255,254,0,0,15,244,0,63,255,255,255,255,0,0,31,248,0,63,255,255,255,255,0,0,63,253,0,63,255,85,85,254,0,0,63,255,0,63,255,0,0,253,0,0,191,255,192,63,191,64,2,252,0,0,255,255,224,63,127,128,3,252,0,1,255,247,244,63,95,192,3,248,0,3,247,246,252,127,79,208,11,240,0,7,243,244,253,127,11,240,15,240,0,11,211,244,124,191,7,244,47,208,0,31,195,244,48,191,3,252,63,192,0,63,131,244,0,254,1,254,191,128,0,191,3,244,0,254,0,255,255,0,0,126,3,244,1,253,0,127,253,0,0,60,3,244,2,252,0,47,248,0,0,24,3,244,3,252,0,47,248,0,0,0,3,244,7,244,0,191,254,0,0,0,3,244,11,240,2,255,255,128,0,0,3,244,15,240,11,254,191,224,0,0,3,244,47,208,127,248,47,254,0,0,3,244,127,195,255,208,11,255,208,0,3,244,191,67,255,64,2,255,192,0,3,244,31,0,248,0,0,63,0,0,3,240,4,0,80,0,0,5,0,
  // 0x6797  林
  151,103,38,38,124,40,1,252,0,0,254,0,0,0,31,192,0,0,0,0,254,0,0,0,31,192,0,0,0,0,254,0,0,0,31,192,0,0,0,0,254,0,0,0,31,192,0,0,0,0,254,0,0,0,31,192,0,0,0,0,254,0,0,0,31,192,0,0,0,0,254,0,0,0,31,192,0,0,0,0,254,0,0,0,31,192,0,0,0,0,254,0,0,0,31,192,0,0,47,255,255,255,199,255,255,255,255,128,47,255,255,255,199,255,255,255,255,128,47,255,255,255,199,255,255,255,255,128,26,171,255,170,130,170,191,250,170,64,0,3,255,0,0,0,191,244,0,0,0,3,255,128,0,0,255,252,0,0,0,11,255,224,0,1,255,252,0,0,0,15,255,248,0,2,255,253,0,0,0,31,255,253,0,3,255,255,0,0,0,47,254,255,64,11,255,255,0,0,0,63,254,127,192,15,255,255,128,0,0,190,254,47,240,47,239,239,192,0,0,252,254,15,208,63,159,223,224,0,2,248,254,3,128,191,31,203,240,0,7,244,254,1,1,254,31,195,248,0,15,240,254,0,3,252,31,194,252,0,47,208,254,0,11,248,31,193,255,0,127,192,254,0,31,240,31,192,255,128,127,64,254,0,127,208,31,192,127,208,62,0,254,0,255,128,31,192,47,208,28,0,254,0,191,0,31,192,15,64,0,0,254,0,60,0,31,192,5,0,0,0,254,0,20,0,31,192,0,0,0,0,254,0,0,0,31,192,0,0,0,0,254,0,0,0,31,192,0,0,0,0,254,0,0,0,31,192,0,0,0,0,254,0,0,0,31,192,0,0,0,0,254,0,0,0,31,192,0,0,0,0,170,0,0,0,26,128,0,0,
  // 0x67f1  柱
  241,103,38,38,124,40,1,252,0,2,248,0,0,2,0,0,0,0,0,2,252,0,0,15,208,0,0,0,0,2,252,0,0,63,248,0,0,0,0,2,252,0,0,15,255,0,0,0,0,2,252,0,0,2,255,192,0,0,0,2,252,0,0,0,127,240,0,0,0,2,252,0,0,0,31,248,0,0,0,2,252,0,0,0,7,240,0,0,0,2,252,0,42,170,171,234,170,64,63,255,255,255,63,255,255,255,255,192,63,255,255,255,63,255,255,255,255,192,63,255,255,255,63,255,255,255,255,192,26,171,254,170,0,0,63,192,0,0,0,7,252,0,0,0,63,192,0,0,0,15,252,0,0,0,63,192,0,0,0,15,252,0,0,0,63,192,0,0,0,31,254,0,0,0,63,192,0,0,0,63,255,128,0,0,63,192,0,0,0,63,255,208,0,0,63,192,0,0,0,191,255,244,0,0,63,192,0,0,0,254,254,252,15,255,255,255,255,64,2,250,252,255,15,255,255,255,255,64,3,242,252,127,79,255,255,255,255,64,11,226,252,46,5,85,191,213,85,0,15,210,252,12,0,0,63,192,0,0,63,194,252,0,0,0,63,192,0,0,127,66,252,0,0,0,63,192,0,0,127,2,252,0,0,0,63,192,0,0,61,2,252,0,0,0,63,192,0,0,24,2,252,0,0,0,63,192,0,0,0,2,252,0,0,0,63,192,0,0,0,2,252,0,0,0,63,192,0,0,0,2,252,0,0,0,63,192,0,0,0,2,252,3,255,255,255,255,255,224,0,2,252,3,255,255,255,255,255,224,0,2,252,3,255,255,255,255,255,224,0,2,252,2,170,170,170,170,170,144,0,2,248,0,0,0,0,0,0,0,
  // 0x6821  校
  33,104,38,38,124,40,1,252,0,7,240,0,0,0,255,0,0,0,0,7,240,0,0,0,255,0,0,0,0,7,240,0,0,0,255,0,0,0,0,7,240,0,0,0,255,0,0,0,0,7,240,0,0,0,255,0,0,0,0,7,240,0,0,0,255,0,0,0,0,7,240,3,255,255,255,255,255,192,0,7,240,3,255,255,255,255,255,192,0,7,240,3,255,255,255,255,255,192,63,255,255,250,255,255,255,255,255,128,63,255,255,248,0,0,0,0,0,0,63,255,255,248,1,244,0,47,0,0,21,95,249,84,3,252,0,127,192,0,0,15,240,0,11,248,0,47,224,0,0,31,240,0,15,240,0,15,248,0,0,47,244,0,63,208,0,3,253,0,0,63,252,0,191,128,0,0,255,0,0,63,255,2,255,0,0,0,127,128,0,191,255,139,253,176,0,62,127,208,0,255,255,195,247,248,0,191,79,128,1,255,251,240,210,252,0,255,9,0,2,251,243,244,0,254,0,254,0,0,3,247,241,252,0,191,2,253,0,0,11,215,240,244,0,127,131,252,0,0,15,199,240,96,0,47,219,244,0,0,47,135,240,0,0,15,255,240,0,0,127,71,240,0,0,11,255,192,0,0,127,7,240,0,0,3,255,128,0,0,61,7,240,0,0,2,255,128,0,0,24,7,240,0,0,11,255,224,0,0,0,7,240,0,0,47,255,248,0,0,0,7,240,0,0,255,223,255,0,0,0,7,240,0,11,255,66,255,208,0,0,7,240,0,127,253,0,191,253,0,0,7,240,11,255,224,0,47,255,208,0,7,240,15,255,64,0,7,255,192,0,7,240,7,248,0,0,0,191,0,0,7,240,3,64,0,0,0,9,0,
  // 0x683c  格
  60,104,38,38,124,40,1,252,0,2,160,0,0,9,0,0,0,0,0,3,244,0,0,31,208,0,0,0,0,3,244,0,0,63,192,0,0,0,0,3,244,0,0,127,128,0,0,0,0,3,244,0,0,255,64,0,64,0,0,3,244,0,1,255,255,255,244,0,0,3,244,0,3,255,255,255,244,0,0,3,244,0,15,255,255,255,240,0,0,3,244,0,31,240,0,31,224,0,63,255,255,252,127,244,0,63,192,0,63,255,255,253,255,252,0,127,128,0,63,255,255,255,255,255,0,255,0,0,21,95,249,111,252,127,131,253,0,0,0,15,244,11,240,63,219,248,0,0,0,15,252,1,192,15,255,240,0,0,0,31,254,0,0,3,255,192,0,0,0,47,255,128,0,3,255,192,0,0,0,63,255,208,0,31,255,244,0,0,0,127,251,240,0,191,255,254,0,0,0,255,247,252,3,255,195,255,208,0,0,255,244,248,127,254,0,191,254,64,2,247,244,183,255,244,0,31,255,224,3,243,244,63,255,208,0,3,255,192,11,211,244,31,255,255,255,255,255,64,15,195,244,15,175,255,255,255,245,0,63,131,244,0,47,255,255,255,244,0,127,3,244,0,47,192,0,3,244,0,127,3,244,0,47,192,0,3,244,0,60,3,244,0,47,192,0,3,244,0,24,3,244,0,47,192,0,3,244,0,0,3,244,0,47,192,0,3,244,0,0,3,244,0,47,192,0,3,244,0,0,3,244,0,47,192,0,3,244,0,0,3,244,0,47,255,255,255,244,0,0,3,244,0,47,255,255,255,244,0,0,3,244,0,47,255,255,255,244,0,0,3,244,0,47,192,0,7,244,0,0,3,240,0,31,128,0,2,160,0,
  // 0x68af  梯
  175,104,37,38,124,40,1,252,0,7,240,0,0,64,0,5,0,0,0,7,240,0,15,208,0,15,240,0,0,7,240,0,15,240,0,15,240,0,0,7,240,0,7,244,0,47,208,0,0,7,240,0,3,248,0,63,192,0,0,7,240,0,2,252,0,127,0,0,0,7,240,0,1,244,0,110,0,0,0,7,240,1,255,255,255,255,254,0,0,7,240,1,255,255,255,255,254,0,63,255,255,249,255,255,255,255,254,0,63,255,255,248,0,1,253,0,254,0,63,255,255,248,0,0,253,0,190,0,21,95,249,84,0,0,253,0,190,0,0,15,240,0,0,0,253,0,190,0,0,15,240,0,21,85,253,85,254,0,0,47,248,0,191,255,255,255,254,0,0,63,253,0,255,255,255,255,254,0,0,63,255,0,255,255,255,255,254,0,0,191,255,128,253,0,253,0,0,0,0,255,255,209,252,0,253,0,0,0,1,255,247,242,252,0,253,0,0,0,2,251,242,250,252,1,253,0,0,0,3,247,240,247,255,255,255,255,255,192,11,215,240,163,255,255,255,255,255,192,15,199,240,7,255,255,255,255,255,192,63,135,240,11,240,15,253,0,63,128,127,7,240,0,0,47,253,0,63,128,126,7,240,0,0,127,253,0,63,128,60,7,240,0,1,255,253,0,63,64,24,7,240,0,11,253,253,0,63,64,0,7,240,0,47,240,253,0,127,64,0,7,240,1,255,192,253,17,255,0,0,7,240,11,255,0,253,63,255,0,0,7,240,63,252,0,253,63,253,0,0,7,240,31,224,0,253,47,244,0,0,7,240,11,64,0,253,0,0,0,0,7,240,0,0,0,253,0,0,0,0,7,240,0,0,0,252,0,0,0,
  // 0x68c0  检
  192,104,38,38,124,40,1,252,0,10,128,0,0,2,208,0,0,0,0,15,208,0,0,7,248,0,0,0,0,15,208,0,0,15,244,0,0,0,0,15,208,0,0,47,252,0,0,0,0,15,208,0,0,127,254,0,0,0,0,15,208,0,0,255,255,128,0,0,0,15,208,0,3,254,63,224,0,0,0,15,208,0,11,252,15,248,0,0,63,255,255,192,47,240,7,254,0,0,63,255,255,192,191,208,1,255,192,0,63,255,255,195,255,64,0,127,244,0,21,111,229,79,253,0,0,15,254,0,0,47,208,127,248,0,0,7,255,208,0,63,225,255,239,255,255,253,191,192,0,63,244,255,31,255,255,253,31,128,0,127,252,56,31,255,255,253,3,0,0,191,254,16,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,1,255,239,192,0,0,64,0,0,0,2,255,223,208,16,7,224,0,248,0,3,255,215,211,240,3,240,1,252,0,11,239,211,131,244,3,240,2,248,0,15,207,209,2,248,3,240,3,244,0,31,207,208,0,252,2,244,7,240,0,63,79,208,0,252,2,248,15,208,0,127,15,208,0,189,1,248,15,192,0,62,15,208,0,126,0,252,47,128,0,44,15,208,0,63,0,252,63,0,0,8,15,208,0,63,0,144,126,0,0,0,15,208,0,57,0,0,252,0,0,0,15,208,0,0,0,1,248,0,0,0,15,208,0,0,0,3,240,0,0,0,15,208,21,85,85,87,245,85,0,0,15,208,63,255,255,255,255,255,64,0,15,208,63,255,255,255,255,255,64,0,15,208,63,255,255,255,255,255,64,0,15,208,0,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,
  // 0x69fd  槽
  253,105,38,38,124,40,1,252,0,15,224,0,0,127,3,240,0,0,0,15,224,0,0,127,3,240,0,0,0,15,224,0,0,127,3,240,0,0,0,15,224,31,255,255,255,255,255,208,0,15,224,31,255,255,255,255,255,208,0,15,224,31,255,255,255,255,255,208,0,15,224,0,0,127,3,240,0,0,0,15,224,0,0,127,3,240,0,0,0,15,224,2,170,191,171,250,170,0,63,255,255,227,255,255,255,255,255,0,63,255,255,227,255,255,255,255,255,0,63,255,255,227,240,63,3,224,63,0,21,111,245,83,240,63,3,224,63,0,0,31,224,3,240,63,3,224,63,0,0,47,224,3,255,255,255,255,255,0,0,63,240,3,255,255,255,255,255,0,0,63,244,3,245,127,87,245,127,0,0,191,252,3,240,63,3,224,63,0,0,255,255,3,240,63,3,224,63,0,0,255,255,67,255,255,255,255,255,0,2,255,239,195,255,255,255,255,255,0,3,255,231,226,170,170,170,170,170,0,7,223,227,240,0,0,0,0,0,0,15,207,225,192,127,255,255,255,248,0,31,207,224,64,191,255,255,255,248,0,63,79,224,0,191,255,255,255,248,0,127,15,224,0,191,0,0,3,248,0,126,15,224,0,191,0,0,3,248,0,60,15,224,0,191,170,170,171,248,0,20,15,224,0,191,255,255,255,248,0,0,15,224,0,191,255,255,255,248,0,0,15,224,0,191,0,0,3,248,0,0,15,224,0,191,0,0,3,248,0,0,15,224,0,191,0,0,3,248,0,0,15,224,0,191,255,255,255,248,0,0,15,224,0,191,255,255,255,248,0,0,15,224,0,191,255,255,255,248,0,0,15,208,0,191,0,0,3,248,0,
  // 0x6a21  模
  33,106,38,38,124,40,1,252,0,15,192,0,3,244,0,253,0,0,0,15,208,0,3,248,0,254,0,0,0,15,208,0,3,248,0,254,0,0,0,15,208,31,255,255,255,255,255,128,0,15,208,31,255,255,255,255,255,128,0,15,208,31,255,255,255,255,255,128,0,15,208,0,3,248,0,254,0,0,0,15,208,0,3,248,0,254,0,0,63,255,255,192,3,248,0,254,0,0,63,255,255,192,0,0,0,0,0,0,63,255,255,195,255,255,255,255,248,0,21,111,229,67,255,255,255,255,248,0,0,31,208,3,254,170,170,171,248,0,0,47,224,3,248,0,0,3,248,0,0,63,240,3,248,0,0,3,248,0,0,63,252,3,255,255,255,255,248,0,0,127,253,3,255,255,255,255,248,0,0,255,255,3,254,170,170,171,248,0,0,255,239,131,248,0,0,3,248,0,1,255,223,195,248,0,0,3,248,0,3,255,219,243,254,170,170,171,248,0,7,255,211,227,255,255,255,255,248,0,11,239,210,131,255,255,255,255,248,0,15,223,208,0,0,3,248,0,0,0,47,143,208,0,0,7,244,0,0,0,127,79,208,0,0,11,244,0,0,0,191,15,208,63,255,255,255,255,255,128,61,15,208,63,255,255,255,255,255,128,28,15,208,63,255,255,255,255,255,128,4,15,208,0,0,63,255,192,0,0,0,15,208,0,0,191,143,240,0,0,0,15,208,0,2,255,11,252,0,0,0,15,208,0,31,253,3,255,64,0,0,15,208,1,255,244,0,255,244,0,0,15,208,111,255,208,0,63,255,144,0,15,208,255,254,0,0,11,255,192,0,15,208,63,224,0,0,0,191,0,0,15,192,41,0,0,0,0,5,0,
  // 0x6a59  橙
  89,106,38,38,124,40,1,252,0,6,160,0,0,0,0,0,0,0,0,11,240,0,0,0,11,192,0,0,0,11,240,3,255,254,15,192,208,0,0,11,240,3,255,255,75,227,240,0,0,11,240,3,255,255,7,255,244,0,0,11,240,0,0,190,3,255,128,0,0,11,240,1,0,253,2,253,2,0,0,11,240,7,226,252,1,252,15,128,0,11,240,15,255,244,0,255,127,192,63,255,255,242,255,240,0,127,254,0,63,255,255,240,127,224,0,63,244,0,63,255,255,240,63,255,255,255,240,0,21,95,245,80,255,255,255,255,252,0,0,15,240,3,254,191,255,247,255,0,0,31,240,15,248,0,0,0,255,208,0,47,240,127,240,0,0,0,63,224,0,63,252,63,192,0,0,0,15,128,0,127,254,30,127,255,255,255,242,0,0,191,255,68,127,255,255,255,240,0,0,255,255,192,127,234,170,175,240,0,1,255,251,240,127,0,0,7,240,0,3,251,243,248,127,0,0,7,240,0,3,251,241,240,127,0,0,7,240,0,11,219,240,208,127,0,0,7,240,0,15,203,240,0,127,255,255,255,240,0,47,139,240,0,127,255,255,255,240,0,127,75,240,0,63,255,255,255,240,0,191,11,240,0,1,144,0,61,0,0,61,11,240,0,15,224,0,127,128,0,28,11,240,0,7,240,0,191,0,0,0,11,240,0,3,244,0,254,0,0,0,11,240,0,3,248,1,252,0,0,0,11,240,0,2,252,2,248,0,0,0,11,240,0,1,228,1,244,0,0,0,11,240,47,255,255,255,255,255,208,0,11,240,47,255,255,255,255,255,208,0,11,240,47,255,255,255,255,255,208,0,11,240,0,0,0,0,0,0,0,
  // 0x6b62  止
  98,107,36,36,68,40,2,254,0,0,0,0,26,144,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,250,170,170,160,0,47,192,0,31,255,255,255,240,0,47,192,0,31,255,255,255,240,0,47,192,0,31,255,255,255,240,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,170,170,170,170,170,170,
  // 0x6b63  正
  99,107,36,33,41,40,2,254,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,26,170,170,170,191,234,170,170,164,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,255,255,255,192,0,47,192,0,63,255,255,255,192,0,47,192,0,63,255,255,255,192,0,47,192,0,63,234,170,170,128,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,170,191,234,170,191,234,170,170,170,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x6b65  步
  101,107,36,38,86,40,2,252,0,0,0,0,191,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,15,224,0,255,0,0,0,0,0,15,224,0,255,170,170,169,0,0,15,224,0,255,255,255,254,0,0,15,224,0,255,255,255,254,0,0,15,224,0,255,255,255,254,0,0,15,224,0,255,0,0,0,0,0,15,224,0,255,0,0,0,0,0,15,224,0,255,0,0,0,0,0,15,224,0,255,0,0,0,0,255,255,255,255,255,255,255,255,254,255,255,255,255,255,255,255,255,254,255,255,255,255,255,255,255,255,254,106,170,170,170,255,170,170,170,169,0,0,0,0,255,0,0,0,0,0,1,248,0,255,0,0,0,0,0,3,254,0,255,0,0,228,0,0,15,252,0,255,0,2,254,0,0,63,240,0,255,0,3,253,0,0,255,208,0,255,0,7,252,0,3,255,64,0,255,0,15,244,0,31,254,0,0,255,0,47,240,0,191,248,0,0,255,0,127,208,0,63,208,3,255,255,0,255,128,0,11,64,1,255,254,3,255,0,0,0,0,0,255,248,15,253,0,0,0,0,0,85,0,127,244,0,0,0,0,0,0,2,255,208,0,0,0,0,0,0,47,255,64,0,0,0,0,0,6,255,252,0,0,0,0,0,1,191,255,224,0,0,0,0,5,191,255,254,0,0,0,0,2,255,255,255,224,0,0,0,0,0,255,255,249,0,0,0,0,0,0,191,254,64,0,0,0,0,0,0,57,0,0,0,0,0,0,0,
  // 0x6bd4  比
  212,107,37,37,114,40,2,253,0,21,64,0,0,85,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,192,0,0,63,128,0,0,254,0,11,240,0,0,63,128,0,0,254,0,127,252,0,0,63,234,170,128,254,7,255,248,0,0,63,255,255,192,254,63,255,208,0,0,63,255,255,192,255,255,253,0,0,0,63,255,255,192,255,255,144,0,0,0,63,128,0,0,255,248,0,0,0,0,63,128,0,0,255,128,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,32,0,0,63,128,0,0,254,0,0,62,0,0,63,128,0,0,254,0,0,63,128,0,63,128,1,176,254,0,0,63,128,0,63,134,255,240,254,0,0,63,64,0,63,255,255,244,254,0,0,127,64,27,255,255,255,244,255,0,0,191,0,255,255,255,249,0,255,234,170,255,0,255,255,249,0,0,191,255,255,254,0,191,249,0,0,0,63,255,255,252,0,101,0,0,0,0,11,255,255,224,0,
  // 0x6ca1  没
  161,108,37,38,124,40,2,252,0,64,0,0,0,0,0,0,0,0,3,244,0,1,85,85,85,80,0,0,11,255,0,3,255,255,255,224,0,0,11,255,224,3,255,255,255,224,0,0,0,191,252,3,255,255,255,224,0,0,0,15,248,3,248,0,15,224,0,0,0,2,240,3,248,0,15,224,0,0,0,0,80,3,248,0,15,224,0,0,0,0,0,3,244,0,15,224,36,0,0,0,0,7,244,0,15,224,47,64,0,0,0,15,240,0,15,224,47,64,16,0,0,31,224,0,15,224,47,64,126,0,0,63,208,0,15,240,127,64,255,224,0,255,192,0,15,255,255,0,191,254,7,255,0,0,11,255,254,0,15,255,139,253,0,0,1,255,248,0,1,255,66,244,0,0,0,0,0,0,0,46,0,128,0,0,0,0,0,0,0,4,0,255,255,255,255,255,64,0,0,0,0,255,255,255,255,255,192,0,0,0,0,255,255,255,255,255,192,0,0,0,0,86,249,85,85,255,64,0,0,1,128,3,248,0,1,255,0,0,0,3,240,3,253,0,3,253,0,0,0,7,248,0,255,0,11,252,0,0,0,15,240,0,191,128,31,244,0,0,0,31,224,0,63,224,127,224,0,0,0,63,192,0,15,249,255,192,0,0,0,127,128,0,7,255,255,0,0,0,0,255,0,0,2,255,252,0,0,0,2,254,0,0,2,255,248,0,0,0,3,252,0,0,31,255,255,128,0,0,11,248,0,2,255,255,255,248,0,0,31,240,1,191,255,224,191,255,228,0,63,224,63,255,254,0,15,255,255,64,31,192,47,255,224,0,1,255,255,0,3,128,15,249,0,0,0,11,252,0,0,0,6,64,0,0,0,0,36,0,
  // 0x6ce2  波
  226,108,36,38,86,40,2,252,0,0,0,0,0,31,192,0,0,3,208,0,0,0,31,192,0,0,11,253,0,0,0,31,192,0,0,15,255,128,0,0,31,192,0,0,1,255,244,0,0,31,192,0,0,0,47,244,0,0,31,192,0,0,0,7,224,255,255,255,255,255,254,0,0,128,255,255,255,255,255,255,0,0,0,255,255,255,255,255,254,0,0,0,255,85,111,229,87,252,0,0,0,254,0,31,192,3,252,0,0,0,254,0,31,192,3,244,61,0,0,254,0,31,192,11,240,255,208,0,254,0,31,192,15,224,255,253,0,254,0,31,192,1,192,31,255,64,254,0,31,192,0,0,2,255,0,255,255,255,255,255,128,0,61,0,255,255,255,255,255,208,0,4,0,255,255,255,255,255,192,0,0,0,254,255,85,85,127,192,0,0,0,254,127,0,0,127,128,0,0,0,253,63,128,0,255,0,0,6,0,253,31,192,1,254,0,0,11,129,253,15,224,3,252,0,0,15,225,252,11,244,7,248,0,0,47,210,252,3,252,15,240,0,0,63,194,252,1,255,63,224,0,0,191,67,248,0,191,255,192,0,0,255,3,248,0,63,255,0,0,2,254,7,244,0,15,253,0,0,3,252,15,240,0,63,255,64,0,11,248,15,224,1,255,255,224,0,15,240,47,208,15,255,191,253,0,47,224,63,193,191,252,15,255,224,127,192,191,159,255,224,1,255,255,63,128,255,15,255,64,0,63,254,7,0,125,7,244,0,0,2,252,0,0,8,2,64,0,0,0,36,
  // 0x6ce8  注
  232,108,37,38,124,40,2,252,0,64,0,0,6,0,0,0,0,0,3,244,0,0,15,224,0,0,0,0,7,255,64,0,63,253,0,0,0,0,7,255,240,0,47,255,128,0,0,0,0,191,253,0,3,255,240,0,0,0,0,11,252,0,0,127,253,0,0,0,0,1,244,0,0,15,255,0,0,0,0,0,16,0,0,2,253,0,0,0,0,0,0,0,0,0,184,0,0,0,0,0,0,255,255,255,255,255,254,0,0,0,0,255,255,255,255,255,254,0,16,0,0,255,255,255,255,255,254,0,127,64,0,170,170,175,234,170,169,0,255,244,0,0,0,31,208,0,0,0,191,255,64,0,0,31,208,0,0,0,11,255,192,0,0,31,208,0,0,0,0,191,64,0,0,31,208,0,0,0,0,30,0,0,0,31,208,0,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,26,170,175,234,170,160,0,0,0,0,47,255,255,255,255,240,0,0,0,208,47,255,255,255,255,240,0,0,1,248,47,255,255,255,255,240,0,0,3,252,0,0,31,208,0,0,0,0,7,248,0,0,31,208,0,0,0,0,15,240,0,0,31,208,0,0,0,0,31,224,0,0,31,208,0,0,0,0,63,192,0,0,31,208,0,0,0,0,191,128,0,0,31,208,0,0,0,0,255,0,0,0,31,208,0,0,0,3,254,0,0,0,31,208,0,0,0,7,252,0,0,0,31,208,0,0,0,15,248,7,255,255,255,255,255,255,64,47,240,7,255,255,255,255,255,255,64,15,208,7,255,255,255,255,255,255,64,2,128,6,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6d17  洗
  23,109,37,38,124,40,2,252,0,0,0,0,0,15,208,0,0,0,3,208,0,3,248,15,208,0,0,0,15,248,0,3,248,15,208,0,0,0,15,255,64,7,244,15,208,0,0,0,1,255,224,11,240,15,208,0,0,0,0,63,240,15,240,15,208,0,0,0,0,11,208,15,245,111,229,85,84,0,0,1,128,47,255,255,255,255,248,0,0,0,0,63,255,255,255,255,248,0,0,0,0,127,255,255,255,255,248,0,0,0,0,191,64,15,208,0,0,0,20,0,0,255,0,15,208,0,0,0,126,0,3,254,0,15,208,0,0,0,255,224,7,252,0,15,208,0,0,0,191,252,3,248,0,15,208,0,0,0,31,255,64,176,0,15,208,0,0,0,2,255,64,0,0,15,208,0,0,0,0,126,7,255,255,255,255,255,255,64,0,8,7,255,255,255,255,255,255,64,0,0,7,255,255,255,255,255,255,64,0,0,6,170,191,234,191,234,170,0,0,0,0,0,63,128,63,192,0,0,0,2,0,0,63,128,63,192,0,0,0,11,192,0,63,64,63,192,0,0,0,15,224,0,127,64,63,192,0,0,0,47,208,0,127,0,63,192,0,0,0,63,192,0,191,0,63,192,0,0,0,127,64,0,255,0,63,192,0,0,0,255,0,1,254,0,63,192,24,0,1,254,0,3,252,0,63,192,31,128,3,252,0,7,252,0,63,192,31,192,7,248,0,31,244,0,63,192,31,192,15,244,0,127,224,0,63,192,47,128,31,240,2,255,192,0,47,192,63,128,63,208,47,255,0,0,47,255,255,64,47,192,63,248,0,0,31,255,255,0,7,64,15,208,0,0,11,255,253,0,0,0,5,0,0,0,0,21,64,0,
  // 0x6d3b  活
  59,109,36,38,86,40,2,252,0,0,0,0,0,0,0,6,0,3,208,0,0,0,0,1,191,192,11,253,0,0,0,22,255,255,240,15,255,128,1,175,255,255,255,224,2,255,248,63,255,255,255,248,0,0,47,248,47,255,255,244,0,0,0,7,240,31,250,95,224,0,0,0,0,144,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,45,0,3,255,255,255,255,255,255,127,208,3,255,255,255,255,255,255,255,252,3,255,255,255,255,255,255,47,255,130,170,170,175,250,170,170,2,255,128,0,0,15,224,0,0,0,127,0,0,0,15,224,0,0,0,9,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,128,31,255,255,255,255,240,0,3,224,31,255,255,255,255,240,0,7,248,31,255,255,255,255,240,0,15,240,31,213,85,85,95,240,0,31,224,31,192,0,0,11,240,0,63,192,31,192,0,0,11,240,0,191,128,31,192,0,0,11,240,0,255,0,31,192,0,0,11,240,2,254,0,31,192,0,0,11,240,7,252,0,31,192,0,0,11,240,15,244,0,31,213,85,85,95,240,47,240,0,31,255,255,255,255,240,63,208,0,31,255,255,255,255,240,47,128,0,31,255,255,255,255,240,7,0,0,31,192,0,0,11,240,0,0,0,10,128,0,0,6,144,
  // 0x6d41  流
  65,109,37,38,124,40,2,252,0,0,0,0,0,42,128,0,0,0,3,224,0,0,0,63,192,0,0,0,11,253,0,0,0,63,192,0,0,0,15,255,192,0,0,63,192,0,0,0,1,255,244,0,0,63,192,0,0,0,0,47,249,85,85,127,213,85,85,0,0,7,243,255,255,255,255,255,255,0,0,0,195,255,255,255,255,255,255,0,0,0,3,255,255,255,255,255,255,0,0,0,0,0,15,244,0,0,0,0,0,0,0,0,15,240,1,240,0,0,16,0,0,0,47,208,7,252,0,0,62,0,0,0,63,128,1,255,0,0,255,240,0,0,191,0,0,127,192,0,191,254,1,170,255,175,255,255,240,0,11,255,130,255,255,255,255,255,248,0,0,255,2,255,255,255,255,255,253,0,0,45,1,255,250,170,85,64,255,0,0,0,0,0,0,0,0,0,190,0,0,0,0,6,144,0,0,168,32,0,0,0,0,15,224,63,64,253,0,0,0,0,0,15,224,63,64,253,0,0,0,2,128,15,224,63,64,253,0,0,0,3,240,15,224,63,64,253,0,0,0,11,244,15,224,63,64,253,0,0,0,15,240,15,208,63,64,253,0,0,0,47,208,15,208,63,64,253,0,0,0,63,192,15,208,63,64,253,0,0,0,191,64,31,192,63,64,253,0,0,0,255,0,47,192,63,64,253,13,0,3,253,0,63,128,63,64,253,15,128,7,252,0,191,64,63,64,253,15,128,15,244,1,255,0,63,64,253,15,128,31,240,3,253,0,63,64,253,15,64,63,208,15,248,0,63,64,255,255,64,31,192,47,240,0,63,64,191,255,0,3,64,7,192,0,0,0,47,248,0,0,0,1,0,0,0,0,0,0,0,
  // 0x6d4b  测
  75,109,35,39,95,40,2,251,0,0,0,0,0,0,0,0,84,3,128,0,0,0,0,0,0,252,15,244,6,170,170,170,0,0,252,47,254,11,255,255,255,1,64,252,7,255,219,255,255,255,7,224,252,0,191,235,208,0,63,7,224,252,0,31,203,208,0,63,7,224,252,0,3,11,208,80,63,7,224,252,0,0,11,209,244,63,7,224,252,0,0,11,209,244,63,7,224,252,0,0,11,209,244,63,7,224,252,0,0,11,209,244,63,7,224,252,60,0,11,209,244,63,7,224,252,191,128,11,209,244,63,7,224,252,255,248,11,209,244,63,7,224,252,47,255,11,209,244,63,7,224,252,3,254,11,209,244,63,7,224,252,0,188,11,209,244,63,7,224,252,0,16,11,209,244,63,7,224,252,0,0,11,209,244,63,7,224,252,0,0,11,209,244,63,7,224,252,0,0,11,209,244,63,7,224,252,0,0,11,209,244,63,7,224,252,0,60,11,209,244,63,7,224,252,0,63,75,209,244,63,7,224,252,0,191,11,209,244,63,7,224,252,0,255,11,210,240,63,7,224,252,1,253,11,210,240,63,7,224,252,2,252,6,131,240,26,3,208,252,3,252,0,7,224,0,0,0,252,11,244,0,15,215,64,0,0,252,15,240,0,31,223,192,0,0,252,31,224,0,63,75,240,0,0,252,63,192,0,254,2,252,0,0,252,127,192,7,252,0,254,0,0,252,127,64,63,240,0,63,67,255,252,11,0,63,128,0,31,130,255,248,0,0,13,0,0,9,0,255,144,0,0,0,0,0,0,0,0,0,
  // 0x6d88  消
  136,109,35,38,86,40,2,252,0,0,0,0,0,15,208,0,0,3,208,0,0,0,15,224,0,128,15,248,0,127,0,15,224,2,252,15,255,64,191,64,15,224,3,252,2,255,224,63,192,15,224,7,248,0,63,244,31,224,15,224,15,240,0,11,224,15,240,15,224,47,224,0,1,128,7,248,15,224,63,192,0,0,0,3,252,15,224,191,64,0,0,0,2,224,15,224,30,0,0,0,0,0,0,15,224,0,0,20,0,0,21,85,111,245,85,80,127,0,0,63,255,255,255,255,240,255,224,0,63,255,255,255,255,240,127,253,0,63,255,255,255,255,240,11,255,64,63,192,0,0,11,240,1,255,64,63,192,0,0,11,240,0,62,0,63,192,0,0,11,240,0,8,0,63,192,0,0,11,240,0,0,0,63,255,255,255,255,240,0,0,0,63,255,255,255,255,240,0,0,0,63,255,255,255,255,240,0,2,64,63,192,0,0,11,240,0,7,208,63,192,0,0,11,240,0,11,240,63,192,0,0,11,240,0,15,224,63,192,0,0,11,240,0,47,192,63,255,255,255,255,240,0,63,192,63,255,255,255,255,240,0,191,64,63,255,255,255,255,240,0,255,0,63,192,0,0,11,240,2,253,0,63,192,0,0,11,240,7,252,0,63,192,0,0,11,240,15,244,0,63,192,0,0,11,240,31,240,0,63,192,0,0,15,240,63,224,0,63,192,0,63,255,240,47,192,0,63,192,0,47,255,224,7,64,0,63,192,0,31,255,128,0,0,0,42,128,0,10,84,0,
  // 0x6de1  淡
  225,109,37,37,114,40,2,253,0,0,0,0,0,26,128,0,0,0,2,128,0,0,0,47,192,0,0,0,11,248,0,0,0,47,192,0,0,0,15,255,64,11,224,47,192,11,208,0,2,255,224,15,224,47,192,15,240,0,0,127,248,31,192,63,192,47,224,0,0,11,240,47,192,63,128,63,192,0,0,1,192,127,64,63,128,191,0,0,0,0,0,255,0,127,65,254,0,0,0,0,1,253,0,191,131,252,0,0,0,0,0,40,0,255,244,96,0,0,0,0,0,0,2,255,255,0,0,0,61,0,0,0,11,255,255,224,0,0,255,208,0,0,47,244,127,253,0,0,255,248,0,1,255,224,11,255,192,0,31,255,64,111,255,128,0,255,244,0,2,255,67,255,253,0,0,31,252,0,0,126,0,255,208,47,192,3,244,0,0,4,0,185,0,47,192,0,144,0,0,0,0,0,0,63,192,0,0,0,0,0,0,14,64,63,192,3,208,0,0,1,0,15,208,63,128,11,252,0,0,11,128,47,192,63,128,15,240,0,0,15,224,63,128,63,192,47,224,0,0,47,224,127,64,127,208,63,192,0,0,63,192,255,0,191,240,255,64,0,0,191,130,253,0,255,241,254,0,0,0,255,3,252,1,255,253,252,0,0,2,255,0,116,3,255,254,0,0,0,3,253,0,0,15,248,255,64,0,0,11,252,0,0,63,240,127,208,0,0,15,244,0,1,255,208,47,248,0,0,63,240,0,47,255,64,11,255,128,0,127,208,27,255,253,0,2,255,254,64,47,128,31,255,224,0,0,127,255,0,7,0,11,254,0,0,0,11,253,0,0,0,3,144,0,0,0,0,40,0,
  // 0x6df7  混
  247,109,37,37,114,40,2,252,3,224,0,0,0,0,0,0,0,0,15,253,0,255,255,255,255,255,208,0,15,255,192,255,255,255,255,255,208,0,1,255,240,255,255,255,255,255,208,0,0,47,240,254,0,0,0,15,208,0,0,7,192,254,0,0,0,15,208,0,0,0,64,254,0,0,0,15,208,0,0,0,0,255,255,255,255,255,208,0,0,0,0,255,255,255,255,255,208,0,0,0,0,255,255,255,255,255,208,0,20,0,0,254,0,0,0,15,208,0,127,64,0,254,0,0,0,15,208,0,255,240,0,254,0,0,0,15,208,0,191,254,0,255,255,255,255,255,208,0,11,255,0,255,255,255,255,255,208,0,0,254,0,255,255,255,255,255,208,0,0,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,0,1,253,0,0,0,0,0,0,191,0,1,253,0,0,0,0,0,0,191,0,1,253,0,0,0,0,7,0,191,0,1,253,1,240,0,0,11,192,191,85,81,253,11,252,0,0,15,224,191,255,249,253,191,253,0,0,47,208,191,255,249,255,255,224,0,0,63,192,191,255,249,255,254,0,0,0,191,64,191,0,1,255,208,0,0,0,255,0,191,0,1,253,0,0,0,1,254,0,191,0,1,253,0,16,0,3,252,0,191,0,1,253,0,46,0,11,248,0,191,1,101,253,0,47,64,15,240,0,191,255,249,253,0,63,64,47,240,47,255,255,248,254,85,127,0,63,208,63,255,255,228,255,255,255,0,47,192,63,255,148,0,191,255,253,0,7,64,26,64,0,0,47,255,244,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6e05  清
  5,110,37,38,124,40,2,252,0,0,0,0,0,47,192,0,0,0,3,208,0,0,0,47,192,0,0,0,11,253,0,170,170,191,234,170,168,0,15,255,128,255,255,255,255,255,252,0,2,255,240,255,255,255,255,255,252,0,0,47,244,0,0,47,192,0,0,0,0,3,224,0,0,47,192,0,0,0,0,0,64,42,170,191,234,170,160,0,0,0,0,63,255,255,255,255,240,0,0,0,0,63,255,255,255,255,240,0,0,0,0,0,0,47,192,0,0,0,36,0,0,0,0,47,192,0,0,0,127,64,6,170,170,191,234,170,170,64,255,244,7,255,255,255,255,255,255,64,127,255,7,255,255,255,255,255,255,64,11,255,128,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,45,0,11,255,255,255,255,208,0,0,0,0,15,255,255,255,255,208,0,0,0,0,15,255,255,255,255,208,0,0,0,0,15,224,0,0,15,208,0,0,0,0,15,224,0,0,15,208,0,0,2,192,15,229,85,85,111,208,0,0,3,240,15,255,255,255,255,208,0,0,11,244,15,255,255,255,255,208,0,0,15,240,15,224,0,0,15,208,0,0,47,208,15,224,0,0,15,208,0,0,63,192,15,224,0,0,15,208,0,0,191,64,15,255,255,255,255,208,0,0,255,0,15,255,255,255,255,208,0,3,253,0,15,250,170,170,175,208,0,7,252,0,15,224,0,0,15,208,0,15,244,0,15,224,0,0,15,208,0,47,240,0,15,224,0,0,15,208,0,63,208,0,15,224,0,63,255,192,0,15,128,0,15,224,0,47,255,192,0,2,0,0,15,224,0,31,254,0,0,0,0,0,5,64,0,0,0,0,0,
  // 0x6e29  温
  41,110,37,37,114,40,2,252,2,224,0,0,0,0,0,0,0,0,7,254,0,63,255,255,255,255,128,0,11,255,208,63,255,255,255,255,128,0,0,191,252,63,255,255,255,255,128,0,0,15,248,63,128,0,0,63,128,0,0,1,240,63,128,0,0,63,128,0,0,0,0,63,128,0,0,63,128,0,0,0,0,63,255,255,255,255,128,0,0,0,0,63,255,255,255,255,128,0,0,0,0,63,255,255,255,255,128,0,16,0,0,63,128,0,0,63,128,0,61,0,0,63,128,0,0,63,128,0,191,208,0,63,128,0,0,63,128,0,255,248,0,63,128,0,0,63,128,0,47,255,64,63,255,255,255,255,128,0,3,255,128,63,255,255,255,255,128,0,0,127,0,63,255,255,255,255,128,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,240,0,0,3,64,255,255,255,255,255,240,0,0,7,224,255,255,255,255,255,240,0,0,15,240,252,11,192,188,11,240,0,0,31,208,252,11,192,188,11,240,0,0,63,192,252,11,192,188,11,240,0,0,127,128,252,11,192,188,11,240,0,0,255,0,252,11,192,188,11,240,0,2,254,0,252,11,192,188,11,240,0,3,252,0,252,11,192,188,11,240,0,11,248,0,252,11,192,188,11,240,0,15,240,0,252,11,192,188,11,240,0,63,224,127,255,255,255,255,255,255,64,127,192,127,255,255,255,255,255,255,64,31,128,127,255,255,255,255,255,255,64,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6e38  游
  56,110,37,39,134,40,2,251,0,0,0,15,208,0,37,0,0,0,7,128,0,15,208,0,127,64,0,0,15,248,0,15,208,0,191,0,0,0,47,255,0,15,208,0,191,0,0,0,7,255,192,15,208,0,255,0,0,0,0,191,192,15,208,0,255,170,170,0,0,47,170,175,234,162,255,255,255,64,0,6,191,255,255,247,255,255,255,64,0,0,191,255,255,251,255,255,255,64,0,0,191,255,255,255,240,0,0,0,0,0,1,252,0,15,224,0,0,0,0,0,1,252,0,63,208,0,0,0,62,0,1,252,0,63,192,0,16,0,255,224,1,252,0,11,255,255,253,0,191,253,1,252,0,1,255,255,255,0,15,255,1,253,85,64,255,255,253,0,1,252,1,255,255,224,0,7,248,0,0,52,2,255,255,224,0,15,240,0,0,0,2,255,255,208,0,63,208,0,0,0,2,248,15,208,1,255,64,0,0,0,3,248,15,208,1,254,0,0,0,0,3,244,15,208,1,252,0,0,0,0,3,244,15,213,86,253,85,0,0,120,3,240,15,223,255,255,255,64,0,191,7,240,15,223,255,255,255,64,0,254,11,240,15,207,255,255,255,64,1,253,11,224,15,192,1,252,0,0,2,252,15,208,15,192,1,252,0,0,3,248,15,192,31,192,1,252,0,0,7,244,47,192,31,192,1,252,0,0,15,240,63,128,31,192,1,252,0,0,15,224,127,0,47,192,1,252,0,0,47,208,255,0,47,192,1,252,0,0,63,193,253,0,63,128,1,252,0,0,127,131,252,16,191,65,86,252,0,0,191,11,244,63,255,3,255,252,0,0,31,2,224,63,254,2,255,248,0,0,0,0,128,47,248,1,255,144,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6e90  源
  144,110,37,39,134,40,2,251,1,0,0,0,0,0,0,0,0,0,7,224,0,0,0,0,0,0,0,0,15,254,2,255,255,255,255,255,255,0,11,255,194,255,255,255,255,255,255,0,0,255,242,255,255,255,255,255,255,0,0,47,226,253,85,86,255,85,85,0,0,7,194,252,0,1,254,0,0,0,0,1,2,252,0,2,253,0,0,0,0,0,2,252,0,2,252,0,0,0,0,0,2,252,0,3,252,0,0,0,0,0,2,252,63,255,255,255,248,0,0,0,2,252,63,255,255,255,248,0,61,0,2,252,63,255,255,255,248,0,255,208,2,252,63,64,0,3,248,0,255,252,2,252,63,64,0,3,248,0,31,255,2,252,63,170,170,171,248,0,1,253,2,252,63,255,255,255,248,0,0,56,2,252,63,255,255,255,248,0,0,0,2,252,63,64,0,3,248,0,0,0,2,252,63,64,0,3,248,0,0,0,3,252,63,64,0,3,248,0,0,0,3,248,63,234,170,171,248,0,0,8,3,248,63,255,255,255,248,0,0,31,3,244,63,255,255,255,248,0,0,63,199,244,0,0,253,0,0,0,0,127,135,240,0,0,253,0,0,0,0,191,11,240,14,64,253,11,192,0,0,255,15,240,47,192,253,31,224,0,2,253,15,224,63,128,253,15,240,0,3,252,31,208,191,0,253,7,252,0,7,248,47,192,254,0,253,2,253,0,15,240,63,131,252,0,253,0,255,0,31,224,191,75,248,0,253,0,191,64,63,208,255,15,240,0,253,0,127,128,127,194,254,7,208,1,253,0,61,0,127,67,252,0,65,255,252,0,0,0,11,1,248,0,0,255,252,0,0,0,0,0,32,0,0,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6ea2  溢
  162,110,37,37,114,40,2,253,1,0,0,0,0,0,0,0,0,0,7,224,0,0,3,255,255,192,0,0,31,254,0,1,67,255,255,208,0,0,11,255,192,3,247,255,255,240,0,0,1,255,240,11,240,0,11,244,0,0,0,47,208,31,240,0,3,252,0,0,0,11,128,63,208,0,2,255,0,0,0,2,0,191,128,0,0,255,192,0,0,0,1,255,0,0,0,127,244,0,0,0,7,254,255,255,255,223,254,0,0,0,31,249,255,255,255,199,253,0,0,0,11,225,255,255,255,192,244,0,61,0,2,128,0,0,0,0,0,0,191,208,0,0,0,0,0,0,0,0,255,252,0,0,3,255,255,224,0,0,31,255,0,1,3,255,255,240,0,0,2,253,0,7,247,255,255,244,0,0,0,56,0,15,240,0,3,252,0,0,0,0,0,47,224,0,1,254,0,0,0,0,0,127,192,0,0,255,64,0,0,0,0,255,64,0,0,127,192,0,0,0,3,254,0,0,0,31,244,0,0,0,15,252,0,0,0,11,254,0,0,45,63,255,255,255,255,255,255,64,0,63,175,255,255,255,255,255,254,0,0,127,75,191,255,255,255,255,216,0,0,255,0,126,11,192,248,47,128,0,1,254,0,126,11,192,248,31,128,0,2,253,0,126,11,192,248,31,128,0,3,252,0,126,11,192,248,31,128,0,11,244,0,126,11,192,248,31,128,0,15,240,0,126,11,192,248,31,128,0,31,224,0,126,11,192,248,31,128,0,63,192,127,255,255,255,255,255,255,64,127,192,127,255,255,255,255,255,255,64,47,64,127,255,255,255,255,255,255,64,2,0,21,85,85,85,85,85,85,0,
  // 0x6ed1  滑
  209,110,36,37,77,40,2,252,3,208,0,0,0,0,0,0,0,11,253,0,15,255,255,255,255,0,15,255,128,15,255,255,255,255,0,1,255,244,15,255,255,255,255,0,0,47,248,15,224,0,0,127,0,0,3,240,15,224,0,0,127,0,0,0,64,15,224,63,255,255,0,0,0,0,15,224,63,255,255,0,0,0,0,15,224,63,85,191,0,0,0,0,15,224,63,0,127,0,0,0,0,15,224,63,0,127,0,61,0,0,15,224,63,0,127,0,191,208,11,255,255,255,255,255,255,255,252,11,255,255,255,255,255,255,47,255,75,255,255,255,255,255,255,2,255,75,224,0,0,0,0,191,0,46,11,224,0,0,0,0,191,0,4,11,239,255,255,255,255,191,0,0,6,159,255,255,255,255,106,0,0,0,15,255,255,255,255,0,0,0,0,15,224,0,0,127,0,0,2,128,15,224,0,0,127,0,0,3,240,15,250,170,170,255,0,0,11,244,15,255,255,255,255,0,0,15,240,15,255,255,255,255,0,0,47,208,15,224,0,0,127,0,0,63,192,15,224,0,0,127,0,0,191,64,15,250,170,170,255,0,1,255,0,15,255,255,255,255,0,3,253,0,15,255,255,255,255,0,7,252,0,15,224,0,0,127,0,15,244,0,15,224,0,0,127,0,31,240,0,15,224,0,0,127,0,63,208,0,15,224,0,0,127,0,47,192,0,15,224,0,255,255,0,7,64,0,15,224,0,191,254,0,0,0,0,15,208,0,127,228,0,
  // 0x6f0f  漏
  15,111,36,37,77,40,2,252,7,64,0,0,0,0,0,0,0,15,240,3,255,255,255,255,255,248,47,254,3,255,255,255,255,255,248,7,255,211,255,255,255,255,255,248,0,191,195,240,0,0,0,3,248,0,31,67,240,0,0,0,3,248,0,1,3,240,0,0,0,3,248,0,0,3,255,255,255,255,255,248,0,0,3,255,255,255,255,255,248,0,0,3,255,255,255,255,255,248,0,0,3,240,0,0,0,0,0,61,0,3,240,0,0,0,0,0,191,208,3,240,0,0,0,0,0,255,248,3,255,255,255,255,255,254,47,255,67,255,255,255,255,255,254,2,255,3,255,255,255,255,255,254,0,124,7,240,0,3,240,0,0,0,0,7,240,0,3,240,0,0,0,0,7,255,255,255,255,255,252,0,0,7,255,255,255,255,255,252,0,0,11,255,255,255,255,255,252,0,52,11,255,192,3,240,0,252,0,126,11,239,193,3,241,64,252,0,191,15,223,207,131,243,224,252,0,255,15,223,223,243,243,248,252,1,253,31,207,195,247,240,189,252,2,252,31,207,192,179,240,40,252,3,252,47,207,192,3,240,0,252,7,244,63,143,197,3,243,64,252,15,240,63,79,223,131,251,224,252,31,224,191,15,223,227,243,252,252,47,208,254,15,195,247,240,188,252,63,193,253,15,192,243,240,32,252,191,131,252,15,192,3,240,0,252,255,3,244,15,192,3,240,42,252,30,0,240,15,192,3,240,63,252,0,0,16,15,192,2,240,63,224,
  // 0x6fc0  激
  192,111,37,38,124,40,2,252,1,0,0,6,144,0,25,64,0,0,7,208,0,11,244,0,47,192,0,0,31,248,0,15,240,0,63,128,0,0,31,255,64,15,224,0,63,128,0,0,2,255,218,175,250,164,63,64,0,0,0,63,207,255,255,244,127,0,0,0,0,11,15,255,255,244,127,0,0,0,0,0,15,192,2,244,191,0,0,0,0,0,15,192,2,244,255,255,255,64,0,0,15,234,171,244,255,255,255,64,0,0,15,255,255,245,255,255,255,64,40,0,15,255,255,246,253,87,249,0,127,64,15,192,2,247,252,3,244,0,255,244,15,192,2,255,252,3,244,0,127,253,15,192,2,255,252,3,240,0,7,254,15,255,255,255,253,7,240,0,0,252,15,255,255,255,254,7,240,0,0,32,10,175,250,191,190,11,224,0,0,0,0,11,224,15,47,11,224,0,0,0,0,11,224,1,31,15,208,0,0,0,191,255,255,255,31,143,192,0,0,0,191,255,255,255,15,223,192,0,0,36,191,255,255,255,15,239,128,0,0,62,0,190,0,0,7,255,64,0,0,63,64,126,0,0,3,255,0,0,0,191,0,190,0,0,3,254,0,0,0,255,0,191,255,240,2,253,0,0,1,253,0,191,255,240,2,252,0,0,2,252,0,255,255,240,3,254,0,0,3,252,1,252,3,240,11,255,64,0,11,244,2,252,7,240,31,255,192,0,15,240,3,248,7,240,63,223,224,0,31,224,15,240,7,240,255,11,248,0,63,192,47,224,11,227,253,3,254,0,127,192,191,203,255,239,248,1,255,128,127,66,255,3,255,239,224,0,127,0,11,0,252,3,255,75,128,0,28,0,0,0,32,0,0,1,0,0,0,0,
  // 0x706f  灯
  111,112,37,39,134,40,2,251,0,2,160,0,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,0,7,240,0,170,170,170,170,170,0,0,7,240,0,255,255,255,255,255,64,0,7,240,0,255,255,255,255,255,64,0,7,240,0,255,255,255,255,255,64,0,7,240,0,0,0,15,240,0,0,4,7,240,57,0,0,15,240,0,0,31,71,240,127,0,0,15,240,0,0,31,71,240,189,0,0,15,240,0,0,47,71,240,252,0,0,15,240,0,0,47,71,241,248,0,0,15,240,0,0,63,7,242,244,0,0,15,240,0,0,63,11,243,240,0,0,15,240,0,0,63,11,247,208,0,0,15,240,0,0,126,11,247,192,0,0,15,240,0,0,190,11,240,0,0,0,15,240,0,0,253,11,240,0,0,0,15,240,0,0,28,11,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,224,0,0,0,15,240,0,0,0,15,224,0,0,0,15,240,0,0,0,31,240,0,0,0,15,240,0,0,0,31,252,0,0,0,15,240,0,0,0,47,255,0,0,0,15,240,0,0,0,63,255,192,0,0,15,240,0,0,0,127,175,240,0,0,15,240,0,0,0,191,79,248,0,0,15,240,0,0,0,255,3,254,0,0,15,240,0,0,2,254,1,254,0,0,15,240,0,0,7,252,0,124,0,0,15,240,0,0,15,248,0,32,0,0,15,240,0,0,47,240,0,0,0,0,31,224,0,0,191,208,0,0,7,255,255,224,0,0,255,128,0,0,3,255,255,208,0,0,63,0,0,0,2,255,255,128,0,0,12,0,0,0,1,255,232,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x70b9  点
  185,112,36,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,255,255,255,255,244,0,0,0,0,255,255,255,255,244,0,0,0,0,255,255,255,255,244,0,0,0,0,255,85,85,85,80,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,21,85,86,255,85,85,84,0,0,127,255,255,255,255,255,253,0,0,127,255,255,255,255,255,253,0,0,127,255,255,255,255,255,253,0,0,127,0,0,0,0,1,253,0,0,127,0,0,0,0,1,253,0,0,127,0,0,0,0,1,253,0,0,127,0,0,0,0,1,253,0,0,127,0,0,0,0,1,253,0,0,127,0,0,0,0,1,253,0,0,127,85,85,85,85,86,253,0,0,127,255,255,255,255,255,253,0,0,127,255,255,255,255,255,253,0,0,127,255,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,0,0,0,4,0,109,0,0,255,1,252,1,252,0,255,0,1,254,2,252,0,254,0,127,192,3,252,1,253,0,191,0,63,208,7,248,0,253,0,127,128,15,240,15,240,0,254,0,63,192,11,248,63,224,0,254,0,47,208,3,253,255,192,0,255,0,15,224,1,255,127,0,0,255,0,15,208,0,249,5,0,0,80,0,0,0,0,64,
  // 0x70ed  热
  237,112,37,39,134,40,2,251,0,6,160,0,0,190,0,0,0,0,0,11,224,0,0,254,0,0,0,0,0,11,224,0,0,254,0,0,0,0,0,11,224,0,0,254,0,0,0,0,0,11,224,0,0,254,0,0,0,0,0,11,224,0,0,254,0,0,0,0,127,255,255,243,255,255,255,254,0,0,127,255,255,243,255,255,255,254,0,0,127,255,255,243,255,255,255,254,0,0,21,95,245,80,0,254,0,254,0,0,0,11,224,0,0,253,0,253,0,0,0,11,224,0,0,252,0,253,0,0,0,11,224,0,1,252,0,253,0,0,0,11,246,244,1,252,0,253,0,0,0,11,255,244,226,252,0,253,0,0,6,255,255,251,255,248,0,253,0,0,255,255,255,147,255,248,0,253,0,0,255,255,240,0,191,248,0,253,0,0,191,239,224,0,15,255,64,253,0,0,100,11,224,0,15,255,224,253,0,0,0,11,224,0,47,255,252,190,4,0,0,11,224,0,127,203,252,190,14,0,0,11,224,0,255,65,244,190,15,128,0,15,224,3,254,0,32,127,31,128,15,255,224,31,252,0,0,63,175,64,11,255,208,63,240,0,0,47,255,0,7,255,64,15,192,0,0,15,254,0,1,64,0,6,0,0,0,3,248,0,0,16,0,0,0,0,0,8,0,0,0,255,0,104,0,173,0,191,0,0,1,254,1,252,0,254,0,191,128,0,3,252,0,253,0,191,0,63,208,0,7,248,0,253,0,127,64,31,240,0,15,240,0,254,0,63,128,11,248,0,63,224,0,255,0,63,192,3,252,0,191,192,0,255,0,47,208,2,255,0,191,64,0,191,0,31,208,0,254,0,10,0,0,80,0,4,0,0,96,0,0,0,0,0,0,0,0,0,0,0,
  // 0x7247  片
  71,114,34,38,86,40,2,252,0,0,0,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,255,255,255,255,255,255,224,0,63,255,255,255,255,255,255,240,0,63,255,255,255,255,255,255,240,0,63,255,255,255,255,255,255,240,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,191,255,255,255,255,255,64,0,0,191,255,255,255,255,255,64,0,0,255,0,0,0,0,191,64,0,0,255,0,0,0,0,191,64,0,0,255,0,0,0,0,191,64,0,2,254,0,0,0,0,191,64,0,3,253,0,0,0,0,191,64,0,7,252,0,0,0,0,191,64,0,11,248,0,0,0,0,191,64,0,15,244,0,0,0,0,191,64,0,63,240,0,0,0,0,191,64,0,191,208,0,0,0,0,191,64,0,255,192,0,0,0,0,191,64,0,191,0,0,0,0,0,191,64,0,45,0,0,0,0,0,191,64,0,8,0,0,0,0,0,191,64,0,
  // 0x7269  物
  105,114,37,38,124,40,1,252,0,0,252,0,0,148,0,0,0,0,0,0,252,0,1,253,0,0,0,0,1,0,252,0,2,252,0,0,0,0,7,240,252,0,3,248,0,0,0,0,11,224,252,0,3,244,0,0,0,0,11,224,252,0,7,240,0,0,0,0,15,208,252,0,11,240,0,0,0,0,15,208,252,0,15,255,255,255,255,192,15,234,254,164,31,255,255,255,255,192,15,255,255,252,63,255,255,255,255,192,31,255,255,252,127,151,249,127,191,192,47,255,255,252,255,3,240,63,47,192,47,64,252,1,253,7,224,127,47,192,63,0,252,3,252,15,208,190,47,192,127,0,252,15,244,15,192,253,63,128,190,0,252,31,240,47,193,252,63,128,45,0,252,11,192,63,66,252,63,128,4,0,252,2,64,127,3,248,63,128,0,0,252,5,0,254,3,244,63,64,0,0,254,254,1,252,11,240,63,64,0,1,255,254,3,248,15,224,63,64,0,127,255,254,11,240,31,192,63,64,47,255,255,144,31,224,47,192,127,0,63,255,252,0,63,192,63,64,127,0,63,250,252,0,255,64,191,0,127,0,46,64,252,3,254,0,254,0,191,0,0,0,252,11,252,2,252,0,191,0,0,0,252,2,240,3,248,0,255,0,0,0,252,0,64,15,240,0,254,0,0,0,252,0,0,31,224,0,254,0,0,0,252,0,0,63,192,1,253,0,0,0,252,0,0,255,64,2,252,0,0,0,252,0,3,254,0,3,252,0,0,0,252,0,15,252,0,11,252,0,0,0,252,0,63,240,31,255,244,0,0,0,252,0,47,208,15,255,240,0,0,0,252,0,7,0,15,255,192,0,0,0,252,0,0,0,6,164,0,0,
  // 0x7279  特
  121,114,38,38,124,40,1,252,0,0,252,0,0,0,254,0,0,0,0,0,252,0,0,0,255,0,0,0,6,144,252,0,0,0,255,0,0,0,7,240,252,0,0,0,255,0,0,0,11,224,252,0,127,255,255,255,253,0,11,208,252,0,127,255,255,255,253,0,15,208,252,0,127,255,255,255,253,0,15,192,252,0,21,85,255,85,84,0,15,255,255,252,0,0,255,0,0,0,15,255,255,252,0,0,255,0,0,0,31,255,255,252,0,0,255,0,0,0,47,170,254,164,0,0,255,0,0,0,63,64,252,11,255,255,255,255,255,208,63,0,252,11,255,255,255,255,255,208,191,0,252,11,255,255,255,255,255,208,189,0,252,5,85,85,85,127,213,64,28,0,252,0,0,0,0,63,128,0,0,0,252,0,0,0,0,63,128,0,0,0,253,126,0,0,0,63,128,0,0,1,255,254,0,0,0,63,128,0,0,27,255,255,255,255,255,255,255,192,27,255,255,247,255,255,255,255,255,192,127,255,254,3,255,255,255,255,255,192,63,255,252,1,85,85,85,127,213,64,63,144,252,0,2,0,0,63,128,0,20,0,252,0,47,192,0,63,128,0,0,0,252,0,47,224,0,63,128,0,0,0,252,0,15,248,0,63,128,0,0,0,252,0,3,253,0,63,128,0,0,0,252,0,1,255,0,63,128,0,0,0,252,0,0,191,64,63,128,0,0,0,252,0,0,60,0,63,128,0,0,0,252,0,0,0,0,63,128,0,0,0,252,0,0,0,0,63,128,0,0,0,252,0,0,2,255,255,128,0,0,0,252,0,0,1,255,255,64,0,0,0,252,0,0,0,255,254,0,0,0,0,168,0,0,0,170,144,0,0,
  // 0x7387  率
  135,115,36,38,86,40,2,252,0,0,0,0,169,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,5,85,85,85,255,85,85,85,80,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,0,0,0,7,244,0,0,0,0,1,0,0,15,224,0,0,7,64,11,224,0,47,192,36,0,31,240,31,252,2,127,0,191,0,127,208,7,255,75,253,1,253,2,255,64,0,191,239,252,7,244,15,252,0,0,31,210,255,79,224,31,224,0,0,7,0,127,255,128,1,64,0,0,0,0,31,255,28,0,0,0,0,0,0,3,252,191,11,64,0,0,1,240,7,240,63,191,240,0,0,31,244,31,192,31,255,254,0,6,255,248,127,255,255,242,255,208,191,255,175,255,255,255,244,127,248,127,248,31,255,255,234,252,11,253,63,64,30,149,64,0,252,1,244,4,0,0,0,255,0,80,0,16,0,0,0,0,255,0,0,0,0,85,85,85,85,255,85,85,85,85,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,
  // 0x73af  环
  175,115,37,36,104,40,1,252,0,0,0,2,170,170,170,170,170,64,127,255,255,199,255,255,255,255,255,192,127,255,255,199,255,255,255,255,255,192,127,255,255,199,255,255,255,255,255,192,21,127,213,64,0,0,255,0,0,0,0,63,128,0,0,1,255,0,0,0,0,63,128,0,0,2,253,0,0,0,0,63,128,0,0,3,252,0,0,0,0,63,128,0,0,11,248,0,0,0,0,63,128,0,0,15,244,0,0,0,0,63,128,0,0,47,244,0,0,0,0,63,128,0,0,63,244,208,0,0,21,127,213,0,0,191,255,240,0,0,47,255,255,0,0,255,255,252,0,0,47,255,255,0,3,255,246,255,0,0,47,255,255,0,11,255,244,255,128,0,0,63,128,0,31,251,244,63,208,0,0,63,128,0,63,231,244,31,240,0,0,63,128,0,255,195,244,11,252,0,0,63,128,3,255,67,244,3,254,0,0,63,128,15,254,3,244,1,255,64,0,63,128,47,248,3,244,0,191,128,0,63,128,11,224,3,244,0,62,0,0,63,128,3,192,3,244,0,20,0,0,63,139,128,0,3,244,0,0,0,0,63,255,128,0,3,244,0,0,0,0,127,255,192,0,3,244,0,0,0,31,255,255,64,0,3,244,0,0,0,127,255,224,0,0,3,244,0,0,0,63,249,0,0,0,3,244,0,0,0,62,64,0,0,0,3,244,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,2,164,0,0,0,
  // 0x7528  用
  40,117,35,35,59,40,1,252,0,63,255,255,255,255,255,255,248,0,63,255,255,255,255,255,255,248,0,63,255,255,255,255,255,255,248,0,63,234,170,191,234,170,171,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,213,85,127,229,85,91,248,0,63,255,255,255,255,255,255,248,0,63,255,255,255,255,255,255,248,0,63,255,255,255,255,255,255,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,255,255,255,255,255,255,248,0,63,255,255,255,255,255,255,248,0,127,255,255,255,255,255,255,248,0,127,170,170,191,234,170,171,248,0,191,0,0,47,192,0,3,248,0,255,0,0,47,192,0,3,248,0,254,0,0,47,192,0,3,248,1,253,0,0,47,192,0,3,248,3,252,0,0,47,192,0,3,248,3,252,0,0,47,192,0,3,248,11,244,0,0,47,192,0,3,248,15,240,0,0,47,192,0,7,248,63,224,0,0,47,192,255,255,244,127,192,0,0,47,192,127,255,240,31,64,0,0,47,192,63,255,208,6,0,0,0,5,64,42,84,0,
  // 0x7535  电
  53,117,34,37,77,40,5,253,0,0,0,42,64,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,255,255,255,255,255,255,255,224,0,255,255,255,255,255,255,255,224,0,255,255,255,255,255,255,255,224,0,255,170,170,191,234,170,175,224,0,255,0,0,127,128,0,15,224,0,255,0,0,127,128,0,15,224,0,255,0,0,127,128,0,15,224,0,255,0,0,127,128,0,15,224,0,255,0,0,127,128,0,15,224,0,255,255,255,255,255,255,255,224,0,255,255,255,255,255,255,255,224,0,255,255,255,255,255,255,255,224,0,255,85,85,191,213,85,111,224,0,255,0,0,127,128,0,15,224,0,255,0,0,127,128,0,15,224,0,255,0,0,127,128,0,15,224,0,255,0,0,127,128,0,15,224,0,255,170,170,191,234,170,175,224,0,255,255,255,255,255,255,255,224,0,255,255,255,255,255,255,255,224,0,255,255,255,255,255,255,255,224,0,255,0,0,127,128,0,0,8,0,255,0,0,127,128,0,0,31,128,85,0,0,127,128,0,0,31,208,0,0,0,127,128,0,0,47,208,0,0,0,127,128,0,0,63,192,0,0,0,63,192,0,0,127,192,0,0,0,63,254,170,171,255,128,0,0,0,47,255,255,255,255,0,0,0,0,15,255,255,255,254,0,0,0,0,2,255,255,255,228,0,
  // 0x7565  略
  101,117,36,38,86,40,3,252,0,0,0,0,0,121,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,255,255,255,224,3,252,0,0,0,255,255,255,224,7,255,255,255,128,255,255,255,224,15,255,255,255,224,252,31,7,224,63,255,255,255,192,252,31,7,224,191,192,0,127,128,252,31,7,226,255,192,0,255,0,252,31,7,235,255,240,2,254,0,252,31,7,255,255,248,3,252,0,252,31,7,255,243,253,15,244,0,252,31,7,255,193,255,127,224,0,252,31,7,235,0,191,255,192,0,255,255,255,224,0,47,255,0,0,255,255,255,224,0,15,253,0,0,255,255,255,224,0,47,255,64,0,252,47,7,224,0,255,255,224,0,252,31,7,224,7,255,191,252,0,252,31,7,224,47,253,15,255,128,252,31,7,226,255,240,2,255,248,252,31,7,255,255,128,0,127,255,252,31,7,255,253,0,0,15,252,252,31,7,239,255,255,255,255,244,252,31,7,229,255,255,255,255,192,252,31,7,224,255,255,255,255,192,255,255,255,224,255,85,85,111,192,255,255,255,224,254,0,0,47,192,255,255,255,224,254,0,0,47,192,252,0,0,0,254,0,0,47,192,252,0,0,0,254,0,0,47,192,252,0,0,0,254,0,0,47,192,252,0,0,0,254,0,0,47,192,0,0,0,0,255,255,255,255,192,0,0,0,0,255,255,255,255,192,0,0,0,0,255,255,255,255,192,0,0,0,0,255,85,85,111,192,0,0,0,0,169,0,0,26,128,
  // 0x767d  白
  125,118,30,38,48,40,5,252,0,0,0,249,64,0,0,0,0,0,0,255,192,0,0,0,0,0,1,255,64,0,0,0,0,0,2,255,0,0,0,0,0,0,3,253,0,0,0,0,0,0,7,252,0,0,0,0,106,170,175,254,170,170,170,144,127,255,255,255,255,255,255,208,127,255,255,255,255,255,255,208,127,255,255,255,255,255,255,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,255,255,255,255,255,255,208,127,255,255,255,255,255,255,208,127,255,255,255,255,255,255,208,127,234,170,170,170,170,191,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,234,170,170,170,170,191,208,127,255,255,255,255,255,255,208,127,255,255,255,255,255,255,208,127,255,255,255,255,255,255,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,0,0,0,0,0,26,144,
  // 0x7684  的
  132,118,34,38,86,40,3,252,0,10,144,0,0,100,0,0,0,0,15,240,0,0,191,0,0,0,0,15,240,0,0,255,0,0,0,0,31,208,0,1,253,0,0,0,0,47,192,0,2,252,0,0,0,0,63,128,0,3,252,0,0,0,0,127,128,0,7,253,85,85,80,191,255,255,248,11,255,255,255,240,191,255,255,248,15,255,255,255,240,191,255,255,248,31,255,255,255,240,191,0,2,248,63,192,0,7,240,191,0,2,248,127,128,0,7,240,191,0,2,248,255,0,0,7,240,191,0,2,250,254,0,0,7,240,191,0,2,255,252,0,0,7,240,191,0,2,249,244,0,0,11,240,191,0,2,248,48,112,0,11,240,191,0,2,248,2,248,0,11,240,191,255,255,248,2,253,0,11,240,191,255,255,248,0,255,0,11,224,191,255,255,248,0,127,192,15,224,191,0,3,248,0,47,224,15,224,191,0,2,248,0,15,240,15,224,191,0,2,248,0,7,252,15,224,191,0,2,248,0,3,253,15,208,191,0,2,248,0,1,253,15,208,191,0,2,248,0,0,224,15,208,191,0,2,248,0,0,0,31,208,191,0,2,248,0,0,0,31,192,191,0,2,248,0,0,0,47,192,191,255,255,248,0,0,0,47,192,191,255,255,248,0,0,0,63,192,191,255,255,248,0,0,0,63,128,191,85,85,80,0,0,0,255,64,191,0,0,0,0,63,255,255,0,191,0,0,0,0,31,255,253,0,105,0,0,0,0,15,255,244,0,0,0,0,0,0,5,85,0,0,
  // 0x76d1  监
  209,118,36,37,77,40,2,253,0,0,6,160,0,5,0,0,0,0,0,7,240,0,15,224,0,0,3,244,7,240,0,31,208,0,0,3,244,7,240,0,47,192,0,0,3,244,7,240,0,63,192,0,0,3,244,7,240,0,127,128,0,0,3,244,7,240,0,191,255,255,254,3,244,7,240,0,255,255,255,254,3,244,7,240,1,255,255,255,254,3,244,7,240,3,253,85,85,85,3,244,7,240,11,244,0,0,0,3,244,7,240,15,240,4,0,0,3,244,7,240,47,208,125,0,0,3,244,7,240,127,193,255,128,0,3,244,7,240,255,64,127,240,0,3,244,7,241,254,0,31,252,0,3,244,7,240,124,0,3,255,64,3,244,7,240,0,0,0,255,192,2,164,7,240,0,0,0,63,192,0,0,7,240,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,191,0,191,0,191,0,0,191,0,190,0,190,0,191,0,0,191,0,190,0,190,0,191,0,0,191,0,190,0,190,0,191,0,0,191,0,190,0,190,0,191,0,0,191,0,190,0,190,0,191,0,0,191,0,190,0,190,0,191,0,0,191,0,190,0,190,0,191,0,85,255,85,255,85,255,85,191,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x76f4  直
  244,118,36,38,86,40,2,252,0,0,0,0,127,192,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,127,128,0,0,0,21,85,85,85,191,213,85,85,84,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,15,255,255,255,255,252,0,7,240,15,255,255,255,255,252,0,7,240,15,250,170,170,171,252,0,7,240,15,224,0,0,1,252,0,7,240,15,224,0,0,1,252,0,7,240,15,250,170,170,171,252,0,7,240,15,255,255,255,255,252,0,7,240,15,255,255,255,255,252,0,7,240,15,224,0,0,1,252,0,7,240,15,224,0,0,1,252,0,7,240,15,224,0,0,1,252,0,7,240,15,255,255,255,255,252,0,7,240,15,255,255,255,255,252,0,7,240,15,250,170,170,170,252,0,7,240,15,224,0,0,1,252,0,7,240,15,224,0,0,1,252,0,7,240,15,250,170,170,171,252,0,7,240,15,255,255,255,255,252,0,7,240,15,255,255,255,255,252,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,249,85,85,85,85,85,85,85,7,255,255,255,255,255,255,255,255,7,255,255,255,255,255,255,255,255,7,255,255,255,255,255,255,255,255,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,
  // 0x7701  省
  1,119,36,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,160,0,255,0,11,64,0,0,2,255,0,255,0,63,224,0,0,7,253,0,255,0,31,252,0,0,31,248,0,255,0,7,255,0,0,127,224,0,255,0,0,255,208,2,255,192,0,255,0,0,63,244,11,255,0,0,255,0,126,15,253,127,248,0,0,255,1,255,131,255,63,224,7,255,254,11,254,0,248,15,64,3,255,253,127,248,0,16,0,0,2,255,231,255,208,0,0,0,0,0,0,127,255,0,0,0,0,0,0,27,255,244,0,0,0,0,0,6,255,255,128,0,0,0,0,22,255,255,244,0,0,0,0,107,255,255,255,255,255,255,252,0,255,255,255,255,255,255,255,252,0,63,255,255,255,255,255,255,252,0,46,145,252,0,0,0,2,252,0,0,1,252,0,0,0,2,252,0,0,1,254,170,170,170,171,252,0,0,1,255,255,255,255,255,252,0,0,1,255,255,255,255,255,252,0,0,1,252,0,0,0,2,252,0,0,1,252,0,0,0,2,252,0,0,1,252,0,0,0,2,252,0,0,1,255,255,255,255,255,252,0,0,1,255,255,255,255,255,252,0,0,1,254,170,170,170,171,252,0,0,1,252,0,0,0,2,252,0,0,1,252,0,0,0,2,252,0,0,1,255,255,255,255,255,252,0,0,1,255,255,255,255,255,252,0,0,1,255,255,255,255,255,252,0,0,1,252,0,0,0,2,252,0,0,0,168,0,0,0,0,84,0,
  // 0x7720  眠
  32,119,36,36,68,40,3,252,255,255,254,3,255,255,255,255,240,255,255,254,3,255,255,255,255,240,255,255,254,3,255,255,255,255,240,254,85,254,3,249,85,85,91,240,253,0,254,3,244,0,0,7,240,253,0,254,3,244,0,0,7,240,253,0,254,3,244,0,0,7,240,253,0,254,3,244,0,0,7,240,253,0,254,3,249,85,85,91,240,255,255,254,3,255,255,255,255,240,255,255,254,3,255,255,255,255,240,255,255,254,3,255,255,255,255,240,253,0,254,3,244,1,252,0,0,253,0,254,3,244,0,253,0,0,253,0,254,3,244,0,253,0,0,253,0,254,3,244,0,253,0,0,253,0,254,3,244,0,253,0,0,255,255,254,3,255,255,255,255,252,255,255,254,3,255,255,255,255,252,255,255,254,3,255,255,255,255,252,253,0,254,3,249,85,255,85,84,253,0,254,3,244,0,127,0,0,253,0,254,3,244,0,127,0,0,253,0,254,3,244,0,63,64,0,253,0,254,3,244,0,63,128,0,254,85,254,3,244,0,63,192,0,255,255,254,3,244,0,47,192,16,255,255,254,3,244,0,31,208,61,255,255,254,3,244,0,15,224,63,253,0,0,3,244,22,219,240,63,253,0,0,3,255,255,211,244,63,253,0,1,191,255,255,227,253,126,84,0,2,255,255,255,144,255,253,0,0,1,255,254,64,0,191,252,0,0,0,249,64,0,0,47,244,0,0,0,0,0,0,0,1,64,
  // 0x786e  确
  110,120,36,39,95,40,1,251,0,0,0,0,0,20,0,0,0,0,0,0,0,0,63,192,0,0,21,85,85,85,0,127,128,0,0,63,255,255,255,0,191,64,0,0,63,255,255,255,0,255,255,252,0,63,255,255,255,2,255,255,255,0,0,31,192,0,3,255,255,255,0,0,47,192,0,11,244,2,252,0,0,47,192,0,31,224,3,248,0,0,63,128,0,63,192,15,240,0,0,63,64,0,191,128,31,224,0,0,127,0,2,255,255,255,255,255,0,191,0,7,255,255,255,255,255,0,255,0,1,255,255,255,255,255,0,254,85,80,127,192,63,0,127,1,255,255,252,47,192,63,0,127,2,255,255,252,47,192,63,0,127,3,255,255,252,47,192,63,0,127,7,253,2,252,47,255,255,255,255,11,253,2,252,47,255,255,255,255,15,253,2,252,47,255,255,255,255,63,253,2,252,47,192,63,0,127,127,253,2,252,47,192,63,0,127,191,253,2,252,47,192,63,0,127,63,253,2,252,47,192,63,64,191,28,253,2,252,63,255,255,255,255,4,253,2,252,63,255,255,255,255,0,253,2,252,63,255,255,255,255,0,253,2,252,63,0,0,0,127,0,255,255,252,191,0,0,0,127,0,255,255,252,255,0,0,0,127,0,255,255,252,254,0,0,0,127,0,253,0,2,252,0,0,0,127,0,253,0,3,252,0,0,0,191,0,253,0,15,244,0,0,85,255,0,168,0,31,240,0,0,255,255,0,0,0,11,192,0,0,255,253,0,0,0,2,64,0,0,191,228,0,0,0,0,0,0,0,0,0,
  // 0x79bb  离
  187,121,36,38,86,40,2,252,0,0,0,0,170,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,0,0,0,16,0,0,0,0,42,64,100,0,191,1,168,0,0,63,128,255,130,253,2,252,0,0,63,128,191,255,240,2,252,0,0,63,128,7,255,224,2,252,0,0,63,128,31,255,253,2,252,0,0,63,134,255,210,255,66,252,0,0,63,139,253,0,63,2,252,0,0,63,129,128,0,4,2,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,0,0,7,252,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,11,244,0,0,0,0,7,255,255,255,255,255,255,255,208,7,255,255,255,255,255,255,255,208,7,255,255,255,255,255,255,255,208,7,244,0,47,192,11,0,47,208,7,244,0,63,192,63,128,31,208,7,244,0,63,128,31,208,31,208,7,244,0,127,0,11,240,31,208,7,244,1,191,171,255,248,31,208,7,245,255,255,255,255,252,31,208,7,244,255,255,255,255,254,31,208,7,244,254,165,80,0,127,31,208,7,244,0,0,0,0,32,31,208,7,244,0,0,0,0,20,111,208,7,244,0,0,0,0,63,255,208,7,244,0,0,0,0,47,255,192,7,244,0,0,0,0,31,254,0,
  // 0x79fb  移
  251,121,37,38,124,40,1,252,0,0,0,0,0,0,148,0,0,0,0,0,2,224,0,2,254,0,0,0,0,1,191,248,0,3,252,0,0,0,1,191,255,253,0,15,244,0,0,0,63,255,255,228,0,63,255,255,248,0,63,255,252,0,0,255,255,255,252,0,31,151,248,0,7,255,255,255,248,0,0,3,248,0,47,248,0,15,240,0,0,3,248,1,255,248,0,47,224,0,0,3,248,7,255,255,64,127,192,0,0,3,248,2,252,191,209,255,64,0,42,171,254,168,144,31,255,253,0,0,63,255,255,253,0,3,255,244,0,0,63,255,255,253,0,1,255,208,0,0,63,255,255,253,0,11,255,64,0,0,0,11,248,0,0,191,253,0,0,0,0,15,252,0,111,255,255,224,0,0,0,31,253,2,255,253,63,192,0,0,0,63,255,128,255,208,255,64,0,0,0,127,255,224,120,2,255,255,255,64,0,255,255,244,0,11,255,255,255,192,1,255,250,253,0,63,255,255,255,192,3,247,248,255,1,255,192,0,191,64,7,243,248,60,11,255,0,0,255,0,15,211,248,36,127,255,64,3,253,0,63,195,248,2,255,255,224,11,252,0,127,131,248,0,255,31,252,31,240,0,127,3,248,0,52,3,255,127,224,0,61,3,248,0,0,0,255,255,128,0,24,3,248,0,0,0,47,255,0,0,0,3,248,0,0,0,63,248,0,0,0,3,248,0,0,2,255,224,0,0,0,3,248,0,0,111,255,64,0,0,0,3,248,0,27,255,252,0,0,0,0,3,248,7,255,255,208,0,0,0,0,3,248,3,255,253,0,0,0,0,0,3,248,1,255,128,0,0,0,0,0,2,168,0,144,0,0,0,0,0,
  // 0x7a7a  空
  122,122,36,37,77,40,2,253,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,213,86,254,85,191,85,87,252,63,192,2,253,0,191,0,3,252,63,192,3,252,0,191,0,3,252,63,192,3,252,0,191,0,3,252,63,192,7,248,0,191,0,3,252,21,64,15,244,0,191,0,0,0,0,0,47,240,0,191,0,1,128,0,0,127,208,0,191,0,2,248,0,2,255,128,0,191,64,3,248,0,111,255,0,0,127,255,255,244,47,255,248,0,0,63,255,255,240,47,255,208,0,0,31,255,255,192,15,253,0,0,0,0,0,0,0,11,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,85,85,85,85,85,85,0,0,63,255,255,255,255,255,255,0,0,63,255,255,255,255,255,255,0,0,63,255,255,255,255,255,255,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,21,85,85,85,85,85,85,85,84,
  // 0x7aef  端
  239,122,38,38,124,40,1,252,0,5,64,0,0,0,169,0,0,0,0,15,192,0,0,0,253,0,0,0,0,15,192,0,168,0,253,0,106,0,0,15,192,1,252,0,253,0,191,0,0,15,192,1,252,0,253,0,191,0,0,15,192,1,252,0,253,0,191,0,0,15,192,1,252,0,253,0,191,0,0,15,192,1,252,0,253,0,191,0,63,255,255,225,253,1,253,0,191,0,63,255,255,225,255,255,255,255,255,0,63,255,255,225,255,255,255,255,255,0,21,85,85,81,255,255,255,255,255,0,0,0,4,0,0,0,0,0,0,0,15,128,31,192,0,0,0,0,0,0,15,192,47,193,85,85,85,85,85,64,15,192,47,143,255,255,255,255,255,208,11,208,63,143,255,255,255,255,255,208,11,208,63,79,255,255,255,255,255,208,7,224,63,0,0,2,253,0,0,0,7,224,63,0,0,3,252,0,0,0,3,240,127,0,0,3,248,0,0,0,3,240,126,0,0,7,248,0,0,0,3,240,189,3,255,255,255,255,255,64,3,240,253,3,255,255,255,255,255,64,3,240,252,3,255,255,255,255,255,64,3,240,252,3,248,47,2,240,63,64,0,1,248,99,248,47,2,240,63,64,0,1,255,247,248,47,2,240,63,64,1,175,255,251,248,47,2,240,63,64,127,255,255,247,248,47,2,240,63,64,127,255,249,3,248,47,2,240,63,64,63,249,0,3,248,47,2,240,63,64,57,0,0,3,248,47,2,240,63,64,0,0,0,3,248,47,2,240,63,64,0,0,0,3,248,47,2,240,63,64,0,0,0,3,248,47,2,247,255,64,0,0,0,3,248,47,2,243,255,0,0,0,0,2,244,21,1,82,248,0,
  // 0x7b2c  第
  44,123,37,38,124,40,1,252,0,10,64,0,0,14,64,0,0,0,0,31,224,0,0,31,224,0,0,0,0,47,208,0,0,63,192,0,0,0,0,63,192,0,0,127,128,0,0,0,0,191,255,255,244,255,255,255,255,192,1,255,255,255,246,255,255,255,255,192,3,255,255,255,251,255,255,255,255,192,15,248,191,0,31,244,47,208,0,0,63,224,63,128,127,208,15,240,0,0,127,192,47,192,127,64,3,252,0,0,11,0,9,0,9,0,1,144,0,0,0,191,255,255,255,255,255,255,208,0,0,191,255,255,255,255,255,255,208,0,0,191,255,255,255,255,255,255,208,0,0,0,0,0,63,192,0,31,208,0,0,0,0,0,63,128,0,15,208,0,0,0,0,0,63,128,0,15,208,0,0,0,0,0,63,192,0,31,208,0,0,15,255,255,255,255,255,255,208,0,0,31,255,255,255,255,255,255,208,0,0,47,255,255,255,255,255,255,208,0,0,63,192,0,63,128,0,0,0,0,0,63,128,0,63,128,0,0,0,0,0,63,128,0,63,128,0,0,0,0,0,127,255,255,255,255,255,255,254,0,0,255,255,255,255,255,255,255,254,0,0,255,255,255,255,255,255,255,254,0,1,254,0,47,255,192,0,1,253,0,0,4,0,191,255,128,0,1,253,0,0,0,3,255,127,128,0,2,252,0,0,0,47,252,63,128,0,2,252,0,0,1,255,240,63,128,0,3,252,0,0,31,255,128,63,128,20,11,248,0,2,255,252,0,63,128,63,255,244,0,47,255,208,0,63,128,31,255,240,0,15,253,0,0,63,128,15,255,128,0,3,208,0,0,63,128,0,0,0,0,0,0,0,0,47,128,0,0,0,0,
  // 0x7b49  等
  73,123,37,38,124,40,1,252,0,15,144,0,0,15,144,0,0,0,0,31,224,0,0,47,208,0,0,0,0,63,192,0,0,63,192,0,0,0,0,127,255,255,248,191,255,255,255,128,0,255,255,255,249,255,255,255,255,128,3,255,255,255,251,255,255,255,255,128,11,252,191,0,15,248,47,208,0,0,31,240,63,64,63,240,15,240,0,0,127,224,63,192,63,192,7,244,0,0,63,192,31,192,47,192,3,248,0,0,11,0,8,0,63,192,1,128,0,0,0,0,0,0,63,192,0,0,0,0,0,63,255,255,255,255,255,255,208,0,0,63,255,255,255,255,255,255,208,0,0,63,255,255,255,255,255,255,208,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,63,255,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,255,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,11,255,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,255,0,0,0,47,0,0,0,63,192,0,0,0,0,191,192,0,0,63,192,0,0,0,0,127,244,0,0,63,192,0,0,0,0,15,253,0,0,63,192,0,0,0,0,3,255,0,0,63,192,0,0,0,0,0,255,192,0,63,192,0,0,0,0,0,63,65,85,191,192,0,0,0,0,0,28,3,255,255,128,0,0,0,0,0,0,1,255,255,0,0,0,0,0,0,0,0,255,232,0,0,0,
  // 0x7bb1  箱
  177,123,37,38,124,40,1,252,0,10,64,0,0,14,64,0,0,0,0,15,240,0,0,31,224,0,0,0,0,31,208,0,0,63,192,0,0,0,0,63,192,0,0,63,192,0,0,0,0,127,255,255,248,191,255,255,255,192,0,255,255,255,249,255,255,255,255,192,1,255,255,255,251,255,255,255,255,192,3,252,191,64,11,252,63,208,0,0,15,244,63,128,31,240,15,240,0,0,47,240,47,192,127,208,7,244,0,0,127,192,15,208,63,128,3,252,0,0,15,64,15,64,11,0,1,224,0,0,1,0,191,0,0,0,0,0,0,0,0,0,191,0,3,255,255,255,254,0,0,0,191,0,3,255,255,255,254,0,0,0,191,0,3,255,255,255,254,0,31,255,255,255,227,249,85,85,254,0,31,255,255,255,227,244,0,0,254,0,31,255,255,255,227,244,0,0,254,0,5,87,255,85,83,244,0,0,254,0,0,3,255,0,3,255,255,255,254,0,0,7,255,128,3,255,255,255,254,0,0,15,255,240,3,255,255,255,254,0,0,47,255,252,3,244,0,0,254,0,0,63,255,255,3,244,0,0,254,0,0,191,255,191,195,244,0,0,254,0,1,254,191,47,243,255,255,255,254,0,3,252,191,15,211,255,255,255,254,0,15,244,191,3,131,255,255,255,254,0,63,224,191,1,3,244,0,0,254,0,127,192,191,0,3,244,0,0,254,0,47,64,191,0,3,244,0,0,254,0,13,0,191,0,3,244,0,0,254,0,0,0,191,0,3,255,255,255,254,0,0,0,191,0,3,255,255,255,254,0,0,0,191,0,3,255,255,255,254,0,0,0,191,0,3,244,0,0,254,0,0,0,190,0,2,164,0,0,85,0,
  // 0x7c7b  类
  123,124,36,38,86,40,2,252,0,0,0,0,190,0,0,0,0,0,1,64,0,255,0,3,144,0,0,31,208,0,255,0,11,252,0,0,31,244,0,255,0,15,244,0,0,7,252,0,255,0,63,224,0,0,2,255,0,255,0,191,192,0,0,0,255,64,255,1,255,0,0,0,0,126,0,255,1,252,0,0,63,255,255,255,255,255,255,255,253,63,255,255,255,255,255,255,255,253,63,255,255,255,255,255,255,255,253,21,85,85,191,255,254,85,85,84,0,0,1,255,255,255,64,0,0,0,0,11,254,255,191,224,0,0,0,0,127,244,255,31,253,0,0,0,7,255,208,255,7,255,208,0,0,127,255,0,255,0,191,254,64,31,255,248,0,255,0,31,255,254,191,255,128,0,255,0,1,255,253,47,248,0,0,0,1,64,31,248,15,64,0,0,255,7,248,0,96,0,0,0,0,255,7,255,128,0,0,0,0,0,254,0,127,244,0,0,0,0,1,254,0,7,224,0,63,255,255,255,255,255,255,255,254,63,255,255,255,255,255,255,255,254,63,255,255,255,255,255,255,255,254,21,85,85,95,255,245,85,85,84,0,0,0,47,255,244,0,0,0,0,0,0,127,231,253,0,0,0,0,0,2,255,194,255,128,0,0,0,0,31,255,0,255,244,0,0,0,1,255,252,0,63,255,128,0,1,191,255,240,0,11,255,254,80,255,255,255,64,0,1,255,255,255,127,255,244,0,0,0,31,255,253,63,253,0,0,0,0,0,191,252,25,64,0,0,0,0,0,1,164,
  // 0x7d22  索
  34,125,35,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,5,85,85,85,255,85,85,85,80,63,255,255,255,255,255,255,255,248,63,255,255,255,255,255,255,255,248,63,255,255,255,255,255,255,255,248,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,128,0,47,224,0,0,2,252,63,128,0,127,208,0,0,2,252,63,128,1,255,64,7,64,2,252,63,129,11,253,0,47,240,2,252,63,139,239,240,0,191,224,2,252,0,47,255,192,3,255,64,0,0,0,11,255,64,31,253,0,0,0,0,1,255,224,191,240,36,0,0,0,0,47,254,255,128,254,0,0,0,0,7,255,253,1,255,192,0,0,0,1,255,224,0,63,244,0,0,0,11,255,64,0,11,254,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,252,21,85,16,0,255,0,0,2,244,0,0,121,0,254,0,56,0,64,0,2,255,64,254,2,255,64,0,0,15,253,0,254,1,255,244,0,0,191,244,0,254,0,31,254,0,11,255,192,0,254,0,2,255,208,191,254,0,0,254,0,0,127,248,127,240,0,0,254,0,0,11,252,15,64,0,0,254,0,0,1,224,0,0,0,0,254,0,0,0,0,
  // 0x7d2b  紫
  43,125,36,38,86,40,2,252,0,0,127,0,1,168,0,0,0,0,0,127,0,1,252,0,0,0,0,0,127,0,1,252,0,2,64,11,208,127,0,1,252,0,111,208,11,224,127,255,241,252,27,255,244,11,224,127,255,241,255,255,255,208,11,224,127,255,241,255,255,244,0,11,224,127,0,1,255,249,0,0,11,224,127,0,1,253,0,0,0,11,224,127,0,1,252,0,0,120,11,224,127,0,81,252,0,0,127,11,224,191,255,241,253,0,0,255,95,255,255,255,241,255,255,255,254,255,255,255,255,160,255,255,255,252,255,255,233,79,144,47,255,255,244,250,80,0,63,240,0,0,0,0,0,0,0,255,192,2,64,0,0,0,1,3,254,0,31,244,0,0,0,31,239,248,0,127,240,0,0,0,127,255,208,2,255,128,0,0,0,31,255,192,15,253,0,0,0,0,1,255,244,127,240,31,64,0,0,0,31,255,255,128,127,224,0,0,0,2,255,252,0,15,252,0,0,0,1,255,224,0,3,255,0,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,255,253,85,85,80,0,255,0,0,2,255,0,0,0,0,255,0,4,0,248,0,1,253,0,255,0,127,0,0,0,7,255,0,255,1,255,224,0,0,63,248,0,255,0,63,253,0,2,255,224,0,255,0,7,255,128,47,255,64,0,255,0,0,191,244,127,248,0,0,255,0,0,31,253,31,192,0,0,255,0,0,3,240,1,0,0,0,254,0,0,0,64,
  // 0x7ea2  红
  162,126,37,36,104,40,1,254,0,0,144,0,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,0,7,248,0,255,255,255,255,255,64,0,15,240,0,255,255,255,255,255,64,0,31,224,0,255,255,255,255,255,64,0,63,192,0,170,170,255,234,170,0,0,191,128,0,0,0,255,0,0,0,0,255,0,244,0,0,255,0,0,0,3,253,2,254,0,0,255,0,0,0,7,248,3,253,0,0,255,0,0,0,15,240,11,248,0,0,255,0,0,0,127,255,255,240,0,0,255,0,0,0,127,255,255,208,0,0,255,0,0,0,63,255,255,128,0,0,255,0,0,0,47,167,255,0,0,0,255,0,0,0,0,7,252,0,0,0,255,0,0,0,0,15,244,0,0,0,255,0,0,0,0,63,224,0,0,0,255,0,0,0,0,191,128,0,0,0,255,0,0,0,2,255,0,88,0,0,255,0,0,0,11,254,191,252,0,0,255,0,0,0,63,255,255,252,0,0,255,0,0,0,63,255,255,252,0,0,255,0,0,0,63,255,233,0,0,0,255,0,0,0,31,144,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,20,0,0,255,0,0,0,0,0,107,248,0,0,255,0,0,0,0,111,255,253,170,170,255,234,170,128,127,255,255,254,255,255,255,255,255,192,127,255,255,146,255,255,255,255,255,192,63,254,64,2,255,255,255,255,255,192,58,64,0,0,0,0,0,0,0,0,
  // 0x7ea7  级
  167,126,38,38,124,40,1,252,0,0,128,0,0,0,0,0,0,0,0,1,248,0,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,0,3,248,3,255,255,255,255,128,0,0,11,240,3,255,255,255,255,64,0,0,15,224,3,255,255,255,255,0,0,0,47,192,1,87,253,85,255,0,0,0,63,128,0,3,252,0,254,0,0,0,191,0,0,3,252,1,253,0,0,0,254,1,208,3,252,2,252,0,0,2,252,3,248,3,248,3,252,0,0,7,244,11,248,3,248,3,248,0,0,15,224,15,240,3,248,7,244,0,0,63,234,191,208,3,244,11,240,16,0,191,255,255,128,7,244,15,255,254,0,63,255,255,0,7,248,15,255,255,0,63,235,253,0,7,252,47,255,254,0,16,7,248,0,11,253,0,0,253,0,0,15,240,0,11,254,0,2,252,0,0,47,192,0,15,255,0,3,252,0,0,127,64,180,15,255,128,3,248,0,1,255,111,244,15,255,192,11,240,0,7,255,255,244,31,223,224,15,240,0,31,255,255,224,47,203,240,47,208,0,127,255,228,0,63,195,252,63,192,0,63,249,0,0,63,130,253,191,64,0,46,64,0,0,127,64,255,255,0,0,0,0,0,116,191,0,127,253,0,0,0,0,27,248,255,0,63,248,0,0,0,2,255,253,253,0,47,248,0,0,0,127,255,247,252,0,191,254,0,0,27,255,254,7,248,2,255,255,192,0,63,255,208,15,244,15,254,191,240,0,63,249,0,47,240,127,248,47,254,0,47,64,0,63,211,255,208,7,255,208,4,0,0,255,199,255,64,1,255,192,0,0,0,47,1,248,0,0,47,0,0,0,0,5,0,144,0,0,5,0,
  // 0x7ebf  线
  191,126,37,38,124,40,2,252,0,1,0,0,0,63,128,0,0,0,0,3,224,0,0,63,193,208,0,0,0,7,248,0,0,63,203,253,0,0,0,15,240,0,0,63,194,255,128,0,0,15,224,0,0,63,192,127,208,0,0,47,192,0,0,63,192,15,128,0,0,63,128,0,0,63,192,1,0,0,0,191,0,0,0,47,192,90,240,0,0,254,0,0,0,47,255,255,244,0,2,252,3,128,107,255,255,255,244,0,3,244,11,242,255,255,255,255,144,0,15,240,15,241,255,255,233,0,0,0,47,192,47,208,254,111,192,0,0,0,191,239,255,128,0,31,208,0,0,0,255,255,255,0,0,31,208,0,4,0,191,255,253,0,0,15,224,26,253,0,63,171,252,0,0,15,251,255,253,0,0,15,240,0,1,191,255,255,254,0,0,47,208,2,255,255,255,254,144,0,0,127,128,7,255,255,250,64,0,0,0,255,0,3,255,239,240,0,80,0,3,252,6,211,148,7,244,0,253,0,15,255,255,208,0,3,248,3,253,0,127,255,255,208,0,3,248,11,248,0,191,255,254,64,0,3,252,47,240,0,63,254,64,0,0,2,252,191,192,0,57,0,0,0,0,1,255,255,0,0,0,0,0,0,0,0,255,252,0,0,0,0,1,160,0,0,255,240,0,0,0,0,127,240,0,3,255,192,0,0,0,111,255,240,0,47,255,192,24,0,27,255,255,144,2,255,255,208,31,0,191,255,228,0,111,255,159,240,47,64,127,249,0,11,255,253,11,252,63,0,62,64,0,31,255,208,3,255,255,0,16,0,0,11,253,0,1,255,254,0,0,0,0,3,128,0,0,127,252,0,0,0,0,0,0,0,0,6,144,0,
  // 0x7ec6  细
  198,126,36,38,86,40,1,252,0,0,96,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,255,0,170,170,170,170,170,0,3,253,0,255,255,255,255,255,0,7,252,0,255,255,255,255,255,0,15,244,0,255,255,255,255,255,0,31,240,0,254,0,191,0,127,0,63,192,0,254,0,191,0,127,0,127,128,0,254,0,191,0,127,0,255,0,16,254,0,191,0,127,2,253,0,248,254,0,191,0,127,7,248,1,255,254,0,191,0,127,15,240,3,253,254,0,191,0,127,127,255,255,248,254,0,191,0,127,127,255,255,240,254,0,191,0,127,63,255,255,192,254,0,191,0,127,47,165,255,64,254,0,191,0,127,0,2,254,0,255,255,255,255,255,0,11,248,0,255,255,255,255,255,0,31,224,0,255,255,255,255,255,0,127,192,0,255,85,255,85,191,1,255,1,104,254,0,191,0,127,7,255,255,252,254,0,191,0,127,63,255,255,252,254,0,191,0,127,63,255,255,232,254,0,191,0,127,47,254,144,0,254,0,191,0,127,30,64,0,0,254,0,191,0,127,0,0,0,0,254,0,191,0,127,0,0,0,0,254,0,191,0,127,0,0,0,24,254,0,191,0,127,0,1,111,252,254,0,191,0,127,22,255,255,253,255,255,255,255,255,127,255,255,252,255,255,255,255,255,63,255,249,0,255,255,255,255,255,63,228,0,0,255,85,85,85,191,16,0,0,0,254,0,0,0,127,0,0,0,0,254,0,0,0,106,0,0,0,0,0,0,0,0,0,
  // 0x7ec8  终
  200,126,38,38,124,40,1,252,0,1,144,0,0,14,80,0,0,0,0,3,252,0,0,47,208,0,0,0,0,3,252,0,0,63,192,0,0,0,0,11,244,0,0,255,64,0,0,0,0,15,240,0,1,255,255,255,240,0,0,31,208,0,3,255,255,255,252,0,0,63,192,0,15,255,255,255,248,0,0,127,64,0,47,249,85,95,240,0,0,255,0,0,191,252,0,47,224,0,2,253,2,209,255,254,0,63,192,0,3,252,7,255,254,191,64,255,64,0,15,240,15,255,248,63,195,254,0,0,47,224,31,227,224,15,251,252,0,0,127,255,255,192,128,7,255,240,0,0,127,255,255,64,0,2,255,192,0,0,63,255,254,0,0,7,255,224,0,0,42,67,252,0,0,47,255,252,0,0,0,11,244,0,1,255,251,255,128,0,0,31,224,0,31,255,129,255,244,0,0,63,128,1,255,253,0,63,255,64,0,255,0,11,255,224,0,11,255,224,3,252,5,179,255,65,0,0,255,192,15,255,255,240,244,7,228,0,31,0,63,255,255,240,0,31,255,64,0,0,63,255,255,224,0,7,255,240,0,0,47,254,80,0,0,0,127,254,0,0,25,0,0,0,0,0,7,253,0,0,0,0,0,0,0,0,0,184,0,0,0,0,0,0,1,0,0,16,0,0,0,0,1,108,11,248,0,0,0,0,0,5,191,252,31,255,208,0,0,0,26,255,255,252,27,255,254,64,0,0,127,255,255,248,0,111,255,244,0,0,127,255,229,0,0,1,255,255,64,0,63,228,0,0,0,0,11,255,244,0,16,0,0,0,0,0,0,191,240,0,0,0,0,0,0,0,0,11,208,0,0,0,0,0,0,0,0,0,64,0,
  // 0x7ed3  结
  211,126,37,38,124,40,1,252,0,1,64,0,0,0,191,0,0,0,0,2,244,0,0,0,255,0,0,0,0,3,252,0,0,0,255,0,0,0,0,11,248,0,0,0,255,0,0,0,0,15,240,0,0,0,255,0,0,0,0,31,224,1,170,170,255,170,170,64,0,63,192,2,255,255,255,255,255,128,0,127,128,2,255,255,255,255,255,128,0,255,0,66,255,255,255,255,255,128,2,254,1,240,0,0,255,0,0,0,3,252,3,253,0,0,255,0,0,0,15,244,11,252,0,0,255,0,0,0,47,224,95,244,0,0,255,0,0,0,191,255,255,224,0,0,255,0,0,0,127,255,255,192,106,170,255,170,169,0,63,255,255,64,191,255,255,255,255,0,42,83,254,0,191,255,255,255,255,0,0,11,252,0,191,255,255,255,255,0,0,31,240,0,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,3,254,5,188,0,0,0,0,0,0,11,255,255,252,47,255,255,255,252,0,63,255,255,252,47,255,255,255,252,0,63,255,255,228,47,255,255,255,252,0,63,255,144,0,47,213,85,87,252,0,30,64,0,0,47,192,0,2,252,0,0,0,0,0,47,192,0,2,252,0,0,0,0,0,47,192,0,2,252,0,0,0,0,105,47,192,0,2,252,0,0,1,175,253,47,192,0,2,252,0,6,191,255,253,47,192,0,2,252,0,127,255,255,253,47,213,85,87,252,0,127,255,254,64,47,255,255,255,252,0,63,249,0,0,47,255,255,255,252,0,41,0,0,0,47,255,255,255,252,0,0,0,0,0,47,192,0,2,252,0,0,0,0,0,31,192,0,1,168,0,
  // 0x7ed9  给
  217,126,37,38,124,40,1,252,0,1,64,0,0,0,144,0,0,0,0,2,244,0,0,2,253,0,0,0,0,3,252,0,0,3,252,0,0,0,0,7,248,0,0,7,254,0,0,0,0,15,240,0,0,15,255,0,0,0,0,31,224,0,0,31,255,128,0,0,0,63,192,0,0,63,239,208,0,0,0,63,128,0,0,191,143,240,0,0,0,191,0,0,1,255,7,248,0,0,0,254,2,208,3,254,2,254,0,0,3,252,3,248,15,252,0,255,128,0,7,244,11,244,63,240,0,127,224,0,15,240,31,240,255,208,0,31,248,0,63,234,255,195,255,213,85,95,255,0,127,255,255,159,255,255,255,255,255,192,63,255,255,15,247,255,255,254,191,64,47,235,253,3,211,255,255,254,46,0,0,11,248,0,0,0,0,0,4,0,0,15,240,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,2,254,1,176,63,255,255,255,208,0,11,255,255,240,63,255,255,255,208,0,47,255,255,240,63,255,255,255,208,0,63,255,255,144,63,149,85,111,208,0,47,254,64,0,63,64,0,31,208,0,30,64,0,0,63,64,0,31,208,0,0,0,0,0,63,64,0,31,208,0,0,0,0,0,63,64,0,31,208,0,0,0,0,100,63,64,0,31,208,0,0,1,111,244,63,64,0,31,208,0,1,191,255,248,63,64,0,31,208,0,63,255,255,244,63,149,85,111,208,0,63,255,249,0,63,255,255,255,208,0,63,249,0,0,63,255,255,255,208,0,41,0,0,0,63,255,255,255,208,0,0,0,0,0,63,64,0,31,208,0,0,0,0,0,63,64,0,31,208,0,
  // 0x7edf  统
  223,126,38,38,124,40,1,252,0,1,128,0,0,0,96,0,0,0,0,2,248,0,0,7,248,0,0,0,0,3,253,0,0,3,252,0,0,0,0,7,252,0,0,2,253,0,0,0,0,15,244,0,0,0,255,0,0,0,0,31,240,0,0,0,249,0,0,0,0,63,208,3,255,255,255,255,255,192,0,127,192,3,255,255,255,255,255,192,0,255,64,3,255,255,255,255,255,192,1,254,3,209,85,111,245,85,85,64,3,252,7,248,0,63,208,0,0,0,11,244,15,244,0,191,128,31,0,0,31,240,31,240,1,255,0,127,128,0,127,255,255,192,3,253,0,63,192,0,127,255,255,128,15,248,0,15,240,0,63,255,255,0,63,240,0,27,248,0,47,235,253,1,255,235,255,255,252,0,0,11,248,11,255,255,255,255,255,0,0,31,240,3,255,255,255,254,255,64,0,63,192,3,255,233,80,0,63,192,0,255,64,1,66,164,6,160,46,0,2,254,27,240,3,248,7,240,0,0,11,255,255,240,3,248,7,240,0,0,47,255,255,240,3,248,7,240,0,0,63,255,254,64,3,244,7,240,0,0,47,254,64,0,7,244,7,240,0,0,30,64,0,0,7,240,7,240,0,0,0,0,0,0,11,240,7,240,0,0,0,0,1,176,15,240,7,240,8,0,0,0,111,240,31,224,7,240,15,192,0,27,255,244,63,192,7,240,15,208,11,255,255,208,191,192,7,240,15,192,63,255,248,2,255,64,7,240,15,192,63,254,64,11,254,0,7,244,31,192,47,208,0,191,252,0,7,255,255,128,20,0,0,127,224,0,3,255,255,64,0,0,0,47,128,0,0,191,253,0,0,0,0,8,0,0,0,0,0,0,
  // 0x7ee7  继
  231,126,37,36,104,40,1,254,0,2,64,0,0,0,1,80,0,0,0,3,244,0,80,0,7,224,0,0,0,7,244,2,248,0,7,224,0,0,0,15,240,2,248,40,7,224,41,0,0,15,224,2,248,188,7,224,63,0,0,47,192,2,248,125,7,224,126,0,0,63,128,2,248,63,7,224,188,0,0,127,64,2,248,47,7,224,252,0,0,254,0,2,248,31,71,225,244,0,1,252,3,210,248,15,135,227,240,0,3,248,7,246,248,15,135,227,208,0,11,240,15,242,248,0,7,224,64,0,31,208,47,210,248,0,11,224,0,0,127,239,255,130,249,255,255,255,255,128,127,255,255,2,249,255,255,255,255,128,63,255,254,2,249,255,255,255,255,128,46,83,252,2,248,0,63,244,0,0,0,11,240,2,248,0,127,252,0,0,0,31,208,2,248,0,255,255,0,0,0,63,128,2,248,1,255,255,128,0,0,255,0,2,248,3,251,239,224,0,2,253,6,162,248,7,231,227,244,0,7,255,255,226,248,15,199,225,252,0,47,255,255,226,248,63,135,224,255,0,63,255,255,146,248,191,7,224,63,64,47,254,64,2,248,254,7,224,47,0,30,64,0,2,248,188,7,224,13,0,0,0,0,2,248,112,7,224,0,0,0,0,0,2,248,0,7,224,0,0,0,0,1,178,248,0,7,224,0,0,0,6,255,242,248,0,7,224,0,0,6,255,255,242,248,0,1,80,0,0,63,255,255,146,252,0,0,0,0,0,63,255,144,2,255,255,255,255,255,192,63,144,0,2,255,255,255,255,255,192,0,0,0,2,255,255,255,255,255,192,
  // 0x7eea  绪
  234,126,38,38,124,40,1,252,0,1,64,0,0,11,224,0,0,0,0,3,244,0,0,15,224,0,0,0,0,3,248,0,0,15,224,0,36,0,0,7,244,0,0,15,224,0,127,64,0,15,240,0,0,15,240,0,255,0,0,31,208,0,255,255,255,254,253,0,0,47,192,0,255,255,255,255,252,0,0,63,64,0,255,255,255,255,244,0,0,191,0,0,0,15,224,31,240,0,0,253,1,208,0,15,224,63,192,0,2,248,3,248,0,15,224,255,64,0,7,240,11,244,0,15,226,255,0,0,15,224,15,229,85,95,247,253,85,64,47,234,255,207,255,255,255,255,255,208,127,255,255,79,255,255,255,255,255,208,63,255,255,15,255,255,255,255,255,208,47,167,253,0,0,11,254,0,0,0,0,3,248,0,0,47,248,0,0,0,0,15,240,0,0,255,224,0,0,0,0,47,192,0,7,255,192,0,0,0,0,127,64,0,47,255,255,255,252,0,0,254,0,66,255,255,255,255,252,0,3,254,191,239,255,255,255,255,252,0,31,255,255,239,255,240,0,1,252,0,63,255,254,135,215,240,0,1,252,0,47,249,64,1,7,240,0,1,252,0,25,0,0,0,7,255,255,255,252,0,0,0,0,0,7,255,255,255,252,0,0,0,0,16,7,255,255,255,252,0,0,0,6,248,7,240,0,1,252,0,0,6,255,248,7,240,0,1,252,0,6,255,255,252,7,240,0,1,252,0,63,255,255,144,7,240,0,1,252,0,63,255,208,0,7,255,255,255,252,0,47,228,0,0,7,255,255,255,252,0,20,0,0,0,7,255,255,255,252,0,0,0,0,0,7,244,0,2,252,0,0,0,0,0,2,160,0,0,84,0,
  // 0x7eed  续
  237,126,37,38,124,40,1,252,0,0,64,0,0,1,168,0,0,0,0,2,248,0,0,2,252,0,0,0,0,3,252,0,0,2,252,0,0,0,0,7,244,0,0,2,252,0,0,0,0,11,240,0,127,255,255,255,244,0,0,15,208,0,127,255,255,255,244,0,0,47,192,0,127,255,255,255,244,0,0,63,128,0,0,2,252,0,0,0,0,191,0,0,0,2,252,0,0,0,0,253,3,128,0,2,252,0,0,0,2,252,11,243,255,255,255,255,255,64,3,240,15,227,255,255,255,255,255,0,15,224,47,195,255,255,255,255,255,0,47,234,255,64,0,0,0,0,254,0,127,255,255,0,2,0,21,0,253,0,63,255,253,0,11,208,127,1,252,0,47,235,248,0,11,248,127,2,248,0,0,11,240,0,1,255,191,3,244,0,0,15,208,0,224,62,127,0,16,0,0,63,128,3,253,4,127,0,0,0,0,191,0,64,255,64,191,0,0,0,1,254,191,192,47,208,191,0,0,0,3,255,255,192,7,192,190,0,0,0,15,255,255,192,1,0,254,0,0,0,63,255,228,15,255,255,255,255,255,64,47,249,0,15,255,255,255,255,255,64,29,0,0,15,255,255,255,255,255,64,0,0,0,64,0,11,248,0,0,0,0,0,27,208,0,15,240,64,0,0,0,6,255,208,0,47,226,244,0,0,0,191,255,208,0,191,199,253,0,0,31,255,249,0,2,255,1,255,128,0,63,255,128,0,15,253,0,63,240,0,63,228,0,0,191,244,0,11,252,0,46,0,0,7,255,208,0,2,255,0,0,0,0,31,255,0,0,0,191,192,0,0,0,7,244,0,0,0,31,64,0,0,0,2,64,0,0,0,9,0,
  // 0x7eff  绿
  255,126,38,38,124,40,1,252,0,1,0,0,0,0,0,0,0,0,0,3,224,0,0,0,0,0,64,0,0,11,248,0,127,255,255,255,248,0,0,15,240,0,127,255,255,255,248,0,0,31,224,0,127,255,255,255,248,0,0,47,192,0,0,0,0,3,248,0,0,63,192,0,0,0,0,3,248,0,0,191,64,0,0,0,0,3,244,0,0,255,0,0,47,255,255,255,244,0,1,253,7,64,47,255,255,255,244,0,3,248,15,224,47,255,255,255,244,0,11,240,31,224,0,0,0,3,244,0,31,208,63,192,0,0,0,7,240,0,127,255,255,64,0,0,0,7,240,0,127,255,255,2,255,255,255,255,255,208,63,255,253,2,255,255,255,255,255,208,46,87,248,2,255,255,255,255,255,208,0,15,240,0,85,85,255,85,85,64,0,47,208,0,0,0,254,0,0,0,0,127,128,0,60,0,254,0,45,0,0,255,0,0,255,0,254,0,191,128,2,253,6,128,191,192,254,2,255,0,11,255,255,192,47,240,255,11,252,0,47,255,255,192,11,244,255,111,240,0,63,255,255,128,3,240,255,255,128,0,47,254,64,0,0,131,255,253,0,0,30,64,0,0,0,31,255,248,0,0,0,0,0,0,0,255,255,253,0,0,0,0,0,64,7,255,254,255,64,0,0,0,31,192,63,248,254,63,224,0,0,11,255,210,255,208,254,15,252,0,6,255,255,223,255,0,254,7,255,128,63,255,253,7,248,0,254,0,255,208,63,255,128,3,208,0,254,0,47,128,63,224,0,0,0,0,254,0,6,0,41,0,0,0,0,191,254,0,0,0,0,0,0,0,0,63,252,0,0,0,0,0,0,0,0,63,224,0,0,0,
  // 0x7f16  编
  22,127,36,38,86,40,1,252,0,2,64,0,0,0,104,0,0,0,3,244,0,0,3,252,0,0,0,7,244,0,0,2,254,0,0,0,15,240,0,0,0,255,0,0,0,15,208,0,0,0,255,64,0,0,47,192,2,255,255,255,255,254,0,63,128,2,255,255,255,255,254,0,127,0,2,255,255,255,255,254,0,254,0,2,252,0,0,0,190,1,252,11,66,252,0,0,0,190,3,244,15,226,252,0,0,0,190,11,240,47,194,255,255,255,255,254,31,208,127,130,255,255,255,255,254,127,255,255,2,255,255,255,255,254,127,255,254,2,252,0,0,0,0,63,255,252,2,252,0,0,0,0,47,251,244,2,248,0,0,0,0,20,11,240,2,248,0,0,0,0,0,31,208,2,255,255,255,255,255,0,63,128,3,255,255,255,255,255,0,191,0,3,255,255,255,255,255,1,253,1,3,255,208,244,124,47,3,254,191,67,255,208,244,124,47,15,255,255,131,255,208,244,124,47,63,255,254,71,251,208,244,124,47,47,254,64,11,251,208,244,124,47,30,64,0,11,235,255,255,255,255,0,0,0,15,235,255,255,255,255,0,0,31,79,219,255,255,255,255,0,2,255,159,203,208,244,124,47,0,127,255,175,203,208,244,124,47,27,255,248,63,139,208,244,124,47,127,255,64,127,11,208,244,124,47,63,228,0,255,11,208,244,124,47,62,0,1,254,11,208,244,124,47,0,0,0,252,11,208,244,125,255,0,0,0,40,11,208,240,104,255,0,0,0,0,6,128,0,0,164,
  // 0x7f3a  缺
  58,127,38,38,124,40,1,252,1,228,0,0,0,0,253,0,0,0,2,252,0,0,0,0,253,0,0,0,3,252,0,0,0,0,253,0,0,0,3,252,0,0,0,0,253,0,0,0,3,248,0,0,0,0,253,0,0,0,7,255,255,255,192,0,253,0,0,0,11,255,255,255,197,86,254,85,84,0,15,255,255,255,203,255,255,255,248,0,15,230,253,85,75,255,255,255,248,0,47,193,252,0,11,255,255,255,248,0,63,193,252,0,0,0,253,3,248,0,127,65,252,0,0,0,253,3,248,0,47,1,252,0,0,0,253,3,248,0,6,1,252,0,0,0,253,3,248,0,127,255,255,255,224,0,253,3,248,0,127,255,255,255,224,0,253,3,248,0,127,255,255,255,224,0,253,3,248,0,21,86,253,85,64,0,253,3,248,0,0,1,252,0,15,255,255,255,255,208,5,65,252,0,15,255,255,255,255,208,15,193,252,15,207,255,255,255,255,208,15,193,252,15,197,87,255,213,85,64,15,193,252,15,192,3,255,208,0,0,15,193,252,15,192,3,255,224,0,0,15,193,252,15,192,7,255,240,0,0,15,193,252,15,192,11,251,244,0,0,15,193,252,15,192,15,243,252,0,0,15,193,252,15,192,31,226,253,0,0,15,214,253,95,192,63,192,255,0,0,15,255,255,255,192,191,128,191,128,0,15,255,255,255,193,255,0,63,208,0,15,255,255,255,195,254,0,47,240,0,15,192,0,15,207,252,0,15,252,0,15,192,0,15,255,240,0,7,255,64,15,192,0,1,255,208,0,1,255,208,5,64,0,3,255,64,0,0,191,192,0,0,0,0,189,0,0,0,31,0,0,0,0,0,32,0,0,0,5,0,
  // 0x7f51  网
  81,127,34,36,68,40,3,252,42,170,170,170,170,170,170,170,144,127,255,255,255,255,255,255,255,224,127,255,255,255,255,255,255,255,224,127,255,255,255,255,255,255,255,224,127,0,3,244,0,47,192,15,224,127,0,3,244,0,47,192,15,224,127,0,3,244,0,47,128,15,224,127,0,3,244,0,47,128,15,224,127,0,3,240,0,47,128,15,224,127,0,3,240,0,63,128,15,224,127,9,3,240,120,63,64,15,224,127,31,135,240,254,63,64,15,224,127,47,231,240,191,255,64,15,224,127,11,255,224,47,255,0,15,224,127,2,255,224,11,255,0,15,224,127,0,255,224,3,255,0,15,224,127,0,63,224,0,255,128,15,224,127,0,15,244,0,191,208,15,224,127,0,31,252,0,255,244,15,224,127,0,31,255,0,255,252,15,224,127,0,47,255,129,254,255,15,224,127,0,63,111,194,252,191,79,224,127,0,127,15,131,248,63,15,224,127,0,191,3,3,244,13,15,224,127,0,254,0,11,240,4,15,224,127,1,252,0,15,224,0,15,224,127,3,252,0,47,208,0,15,224,127,11,244,0,63,192,0,15,224,127,15,240,0,255,64,0,15,224,127,63,208,2,255,0,0,15,224,127,15,128,0,252,0,0,15,224,127,2,0,0,36,0,0,15,224,127,0,0,0,0,0,255,255,224,127,0,0,0,0,0,127,255,208,127,0,0,0,0,0,63,255,64,106,0,0,0,0,0,42,84,0,
  // 0x7f6e  置
  110,127,35,36,68,40,3,252,31,255,255,255,255,255,255,255,128,31,255,255,255,255,255,255,255,128,31,234,175,250,170,254,170,191,128,31,192,7,240,0,252,0,63,128,31,192,7,240,0,252,0,63,128,31,234,171,250,170,254,170,191,128,31,255,255,255,255,255,255,255,128,31,255,255,255,255,255,255,255,128,0,0,0,2,253,0,0,0,0,0,0,0,2,252,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,3,244,0,0,0,0,0,0,0,7,244,0,0,0,0,5,80,63,255,255,255,255,252,0,15,224,63,255,255,255,255,252,0,15,224,63,128,0,0,2,252,0,15,224,63,128,0,0,1,252,0,15,224,63,255,255,255,255,252,0,15,224,63,255,255,255,255,252,0,15,224,63,128,0,0,1,252,0,15,224,63,128,0,0,1,252,0,15,224,63,255,255,255,255,252,0,15,224,63,255,255,255,255,252,0,15,224,63,128,0,0,1,252,0,15,224,63,128,0,0,1,252,0,15,224,63,255,255,255,255,252,0,15,224,63,255,255,255,255,252,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,255,255,255,255,255,255,255,252,15,255,255,255,255,255,255,255,252,15,255,255,255,255,255,255,255,252,15,224,0,0,0,0,0,0,0,10,144,0,0,0,0,0,0,0,
  // 0x7f72  署
  114,127,37,36,104,40,1,252,1,255,255,255,255,255,255,255,248,0,1,255,255,255,255,255,255,255,248,0,1,254,170,255,170,175,234,171,248,0,1,252,0,127,0,15,192,3,248,0,1,252,0,127,0,15,192,3,248,0,1,252,0,127,0,15,192,3,248,0,1,255,255,255,255,255,255,255,248,0,1,255,255,255,255,255,255,255,248,0,1,170,170,170,255,170,170,170,164,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,2,208,0,0,47,255,255,255,255,255,15,248,0,0,47,255,255,255,255,255,127,240,0,0,31,255,255,255,255,255,255,192,0,0,0,0,0,254,0,15,254,0,0,0,0,0,0,254,0,191,240,0,0,47,255,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,255,128,0,0,0,1,255,254,0,0,0,0,0,0,0,111,255,240,0,0,0,0,0,0,11,255,255,64,0,0,0,0,0,6,255,255,255,255,255,255,192,0,1,255,255,255,255,255,255,255,192,0,127,255,255,234,170,170,170,191,192,0,63,255,255,192,0,0,0,31,192,0,31,248,31,192,0,0,0,31,192,0,9,0,31,255,255,255,255,255,192,0,0,0,31,255,255,255,255,255,192,0,0,0,31,213,85,85,85,111,192,0,0,0,31,192,0,0,0,31,192,0,0,0,31,192,0,0,0,31,192,0,0,0,31,255,255,255,255,255,192,0,0,0,31,255,255,255,255,255,192,0,0,0,31,234,170,170,170,191,192,0,0,0,31,192,0,0,0,26,128,0,
  // 0x8005  者
  5,128,37,38,124,40,1,252,0,0,0,7,240,0,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,0,7,240,0,0,3,224,0,0,0,0,7,240,0,0,11,252,0,0,0,0,7,240,0,0,31,240,0,0,63,255,255,255,255,253,127,192,0,0,63,255,255,255,255,255,255,64,0,0,63,255,255,255,255,255,254,0,0,0,0,0,11,244,0,47,248,0,0,0,0,0,7,240,0,127,224,0,0,0,0,0,7,240,1,255,128,0,0,0,0,0,7,240,11,254,0,0,0,0,0,0,7,240,47,248,0,0,0,47,255,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,255,128,5,85,85,87,255,229,85,85,85,0,0,0,0,31,255,64,0,0,0,0,0,0,1,255,248,0,0,0,0,0,0,0,15,255,208,0,0,0,0,0,0,0,191,255,255,255,255,255,0,0,0,31,255,255,255,255,255,255,0,0,2,255,255,255,255,255,255,255,0,0,127,255,255,192,0,0,0,255,0,0,63,255,111,192,0,0,0,255,0,0,47,244,47,192,0,0,0,255,0,0,15,64,47,192,0,0,0,255,0,0,0,0,47,255,255,255,255,255,0,0,0,0,47,255,255,255,255,255,0,0,0,0,47,255,255,255,255,255,0,0,0,0,47,192,0,0,0,255,0,0,0,0,47,192,0,0,0,255,0,0,0,0,47,192,0,0,0,255,0,0,0,0,47,255,255,255,255,255,0,0,0,0,47,255,255,255,255,255,0,0,0,0,47,255,255,255,255,255,0,0,0,0,47,192,0,0,0,255,0,0,0,0,26,128,0,0,0,85,0,0,
  // 0x806a  聪
  106,128,38,38,124,40,1,252,0,0,0,0,0,80,0,6,0,0,0,0,0,0,3,244,0,15,224,0,63,255,255,255,3,252,0,31,224,0,63,255,255,255,1,253,0,47,192,0,63,255,255,255,0,191,0,63,128,0,7,244,11,224,0,63,64,191,0,0,3,240,11,224,0,63,192,254,0,0,3,240,11,224,0,29,1,252,0,0,3,240,11,224,47,255,255,255,253,0,3,240,11,224,47,255,255,255,253,0,3,255,255,224,47,255,255,255,253,0,3,255,255,224,47,128,0,0,253,0,3,255,255,224,47,128,0,0,253,0,3,240,11,224,47,128,0,0,253,0,3,240,11,224,47,128,0,0,253,0,3,240,11,224,47,128,0,0,253,0,3,240,11,224,47,128,0,0,253,0,3,240,11,224,47,128,0,0,253,0,3,240,11,224,47,255,255,255,253,0,3,255,255,224,47,255,255,255,253,0,3,255,255,224,47,255,255,255,253,0,3,255,255,224,0,0,16,0,0,0,3,240,11,224,0,1,248,0,0,0,3,240,11,224,0,0,253,0,0,0,3,240,11,224,0,126,127,64,16,0,3,240,11,249,57,126,47,193,248,0,3,240,31,254,62,126,15,224,252,0,3,251,255,254,125,126,3,240,189,0,47,255,255,253,189,126,2,208,63,0,127,255,255,224,252,126,0,0,63,64,63,254,75,224,252,126,0,14,31,192,62,64,11,225,248,126,0,15,207,192,0,0,11,226,244,126,0,15,203,208,0,0,11,227,240,127,0,31,135,208,0,0,11,225,224,63,255,255,130,0,0,0,11,224,0,63,255,255,0,0,0,0,11,224,0,11,255,248,0,0,0,0,7,224,0,0,0,0,0,0,
  // 0x80fd  能
  253,128,38,38,124,40,1,252,0,3,144,0,0,42,64,0,0,0,0,11,248,0,0,63,128,0,0,0,0,15,240,0,0,63,128,0,0,0,0,15,224,30,0,63,128,0,144,0,0,47,208,191,0,63,128,31,244,0,0,63,192,63,192,63,129,255,252,0,0,191,64,31,224,63,239,255,224,0,0,255,0,15,240,63,255,253,0,0,42,255,255,255,248,63,255,64,0,0,127,255,255,255,252,63,208,0,0,0,63,255,255,255,254,63,128,0,4,0,63,234,149,64,255,63,128,0,15,128,0,0,0,0,121,63,128,0,31,192,0,0,0,0,0,63,128,0,31,192,0,0,0,0,0,63,213,85,127,192,3,255,255,255,224,63,255,255,255,128,3,255,255,255,224,31,255,255,255,0,3,255,255,255,224,6,255,255,248,0,3,244,0,15,224,0,0,0,0,0,3,244,0,15,224,63,128,0,0,0,3,244,0,15,224,63,128,0,0,0,3,255,255,255,224,63,128,0,96,0,3,255,255,255,224,63,128,7,248,0,3,255,255,255,224,63,128,127,253,0,3,244,0,15,224,63,139,255,244,0,3,244,0,15,224,63,255,255,64,0,3,244,0,15,224,63,255,228,0,0,3,255,255,255,224,63,249,0,0,0,3,255,255,255,224,63,128,0,0,0,3,255,255,255,224,63,128,0,10,0,3,244,0,15,224,63,128,0,11,224,3,244,0,15,224,63,128,0,15,224,3,244,0,15,224,63,128,0,15,208,3,244,0,31,224,63,192,0,47,192,3,244,31,255,208,63,255,255,255,192,3,244,15,255,192,31,255,255,255,64,3,244,11,255,64,7,255,255,253,0,1,80,1,64,0,0,0,0,0,0,
  // 0x81ea  自
  234,129,28,38,10,40,6,252,0,0,1,233,0,0,0,0,0,2,255,0,0,0,0,0,3,253,0,0,0,0,0,3,252,0,0,0,0,0,7,248,0,0,0,106,170,175,250,170,170,170,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,85,85,85,85,85,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,85,85,85,85,85,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,85,85,85,85,85,255,191,0,0,0,0,0,191,191,0,0,0,0,0,106,
  // 0x81f3  至
  243,129,36,34,50,40,2,254,21,85,85,85,85,85,85,85,84,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,2,255,0,0,0,0,0,0,0,3,253,0,2,224,0,0,0,0,11,252,0,15,248,0,0,0,0,15,244,0,11,255,0,0,0,0,47,240,0,1,255,208,0,0,0,63,208,0,0,127,244,0,0,0,191,192,0,0,31,254,0,15,255,255,255,255,255,255,255,128,15,255,255,255,255,255,255,255,224,15,255,255,255,255,255,255,255,248,15,255,255,170,165,85,0,15,252,0,0,0,0,0,0,0,3,240,0,0,0,0,254,0,0,1,128,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,85,85,85,255,85,85,85,0,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,85,85,85,85,255,85,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x83dc  菜
  220,131,36,38,86,40,2,252,0,0,26,128,0,2,164,0,0,0,0,31,208,0,3,244,0,0,0,0,31,208,0,3,244,0,0,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,21,85,111,213,85,87,249,85,84,0,0,31,208,0,3,244,0,0,0,0,31,208,0,2,165,100,0,0,0,0,0,0,90,255,253,0,0,85,90,175,255,255,255,255,64,15,255,255,255,255,255,255,254,64,15,255,255,255,255,255,165,0,0,11,255,254,169,84,0,0,20,0,0,0,0,1,176,0,0,63,192,0,124,0,7,244,0,0,127,192,1,254,0,3,252,0,0,255,64,0,191,64,1,253,0,1,254,0,0,63,192,0,254,0,3,252,0,0,31,224,0,254,0,11,244,0,0,15,240,0,165,0,15,224,0,0,11,64,0,255,0,7,192,0,0,0,0,0,255,0,0,0,0,21,85,85,85,255,85,85,85,84,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,0,255,255,254,0,0,0,0,0,7,255,255,255,192,0,0,0,0,47,252,255,63,244,0,0,0,2,255,224,255,11,255,64,0,0,47,255,64,255,2,255,244,0,6,255,252,0,255,0,63,255,144,191,255,208,0,255,0,11,255,254,255,254,0,0,255,0,0,191,254,63,224,0,0,255,0,0,11,252,29,0,0,0,255,0,0,0,96,0,0,0,0,254,0,0,0,0,
  // 0x84dd  蓝
  221,132,36,37,77,40,2,253,0,0,47,128,0,2,248,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,5,64,0,17,84,0,0,0,0,6,160,0,127,64,0,0,1,84,7,240,0,191,0,0,0,3,248,7,240,0,255,0,0,0,3,248,7,240,1,255,255,255,240,3,248,7,240,2,255,255,255,240,3,248,7,240,3,255,255,255,240,3,248,7,240,11,244,8,0,0,3,248,7,240,15,240,126,0,0,3,248,7,240,47,208,191,64,0,3,248,7,240,127,192,63,192,0,3,248,7,240,255,0,15,240,0,3,248,7,240,46,0,7,244,0,3,248,7,240,4,0,3,252,0,0,0,7,240,0,0,1,248,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,190,0,126,0,190,0,191,0,0,190,0,126,0,190,0,191,0,0,190,0,126,0,190,0,191,0,0,190,0,126,0,190,0,191,0,0,190,0,126,0,190,0,191,0,0,191,0,190,0,190,0,191,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x86c7  蛇
  199,134,37,37,114,40,1,253,0,0,80,0,0,0,42,64,0,0,0,3,244,0,0,0,63,64,0,0,0,3,244,0,0,0,63,64,0,0,0,3,244,0,0,0,63,64,0,0,0,3,244,0,0,0,63,64,0,0,0,3,244,0,0,0,63,64,0,0,0,3,244,0,63,255,255,255,255,192,0,3,244,0,63,255,255,255,255,192,15,255,255,254,63,255,255,255,255,192,15,255,255,254,63,64,0,0,47,192,15,255,255,254,63,0,0,0,47,192,15,130,240,62,63,0,0,0,47,192,15,130,240,62,63,0,0,0,47,192,15,130,240,62,63,253,0,0,47,192,15,130,240,62,0,253,0,0,0,0,15,130,240,62,0,253,0,0,0,0,15,130,240,62,0,253,0,0,224,0,15,130,240,62,0,253,0,7,244,0,15,130,240,62,0,253,0,63,252,0,15,130,240,126,0,253,2,255,248,0,15,255,255,254,0,253,111,255,192,0,15,255,255,254,0,255,255,248,0,0,15,255,255,254,0,255,255,128,0,0,15,131,244,0,0,255,228,0,0,0,15,131,244,0,0,254,0,0,0,0,0,3,244,44,0,253,0,0,0,0,0,3,244,189,0,253,0,0,0,0,0,3,244,126,0,253,0,0,0,0,0,3,244,63,0,253,0,0,8,0,0,3,244,47,64,253,0,0,15,128,0,3,250,191,128,253,0,0,15,192,5,175,255,255,192,253,0,0,31,192,127,255,255,255,192,253,0,0,47,192,63,255,254,155,208,255,85,85,127,128,63,249,0,7,224,255,255,255,255,0,20,0,0,7,128,127,255,255,254,0,0,0,0,0,0,11,255,255,248,0,
  // 0x884c  行
  76,136,37,38,124,40,1,252,0,0,40,0,0,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,0,1,255,64,42,170,170,170,170,0,0,7,254,0,127,255,255,255,255,0,0,31,248,0,127,255,255,255,255,0,0,127,224,0,127,255,255,255,255,0,2,255,192,0,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,0,63,248,0,0,0,0,0,0,0,0,63,224,7,128,0,0,0,0,0,0,31,128,15,244,0,0,0,0,0,0,13,0,47,240,0,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,3,255,3,255,255,255,255,255,192,0,11,252,3,255,255,255,255,255,192,0,47,244,3,255,255,255,255,255,192,0,191,244,2,170,170,171,254,170,128,2,255,244,0,0,0,1,253,0,0,11,255,244,0,0,0,1,253,0,0,63,255,244,0,0,0,1,253,0,0,191,251,244,0,0,0,1,253,0,0,63,199,244,0,0,0,1,253,0,0,14,7,244,0,0,0,1,253,0,0,4,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,2,253,0,0,0,7,244,0,0,63,255,252,0,0,0,7,244,0,0,63,255,252,0,0,0,7,244,0,0,47,255,244,0,0,0,7,240,0,0,10,169,64,0,0,
  // 0x88ab  被
  171,136,38,38,124,40,1,252,0,10,144,0,0,0,63,64,0,0,0,15,224,0,0,0,63,64,0,0,0,15,224,0,0,0,63,64,0,0,0,15,224,0,0,0,63,64,0,0,0,15,224,0,0,0,63,64,0,0,0,15,224,0,0,0,63,64,0,0,0,15,224,0,127,255,255,255,255,128,21,95,245,64,127,255,255,255,255,192,63,255,255,244,127,255,255,255,255,192,63,255,255,248,127,85,127,149,127,128,63,255,255,240,127,0,63,64,63,64,0,0,15,224,127,0,63,64,127,0,0,0,31,192,127,0,63,64,191,0,0,0,63,128,127,0,63,64,253,0,0,0,191,0,127,0,63,64,108,0,0,1,253,24,127,0,63,64,0,0,0,3,252,63,191,255,255,255,253,0,0,15,244,189,191,255,255,255,254,0,0,63,253,248,191,255,255,255,253,0,0,191,255,240,191,254,85,87,252,0,2,255,255,192,191,254,0,3,252,0,15,255,255,208,190,127,0,11,244,0,63,255,231,244,254,63,128,15,240,0,191,223,226,252,254,47,192,31,224,0,63,79,224,248,253,31,224,63,192,0,45,15,224,96,253,15,244,191,128,0,0,15,224,1,252,3,253,255,0,0,0,15,224,2,252,2,255,254,0,0,0,15,224,3,248,0,255,252,0,0,0,15,224,3,244,0,127,240,0,0,0,15,224,7,240,0,191,248,0,0,0,15,224,15,240,3,255,255,0,0,0,15,224,31,224,31,255,255,208,0,0,15,224,63,193,255,244,191,254,0,0,15,224,127,143,255,192,31,255,208,0,15,224,255,15,254,0,3,255,192,0,15,224,62,3,240,0,0,127,64,0,11,224,4,1,64,0,0,6,0,
  // 0x88c5  装
  197,136,36,38,86,40,2,252,0,0,191,0,0,3,244,0,0,0,0,191,0,0,3,244,0,0,9,0,191,0,0,3,244,0,0,47,128,191,0,0,3,244,0,0,63,240,191,0,0,3,244,0,0,11,252,191,0,0,7,248,0,0,2,253,191,15,255,255,255,255,255,0,116,191,15,255,255,255,255,255,0,0,191,15,255,255,255,255,255,0,0,191,0,0,3,244,0,0,0,0,191,0,0,3,244,0,0,0,10,191,0,0,3,244,0,0,0,191,191,0,0,3,244,0,0,11,255,191,0,0,3,244,0,0,255,254,191,0,0,7,248,0,0,255,224,191,3,255,255,255,255,248,190,0,191,3,255,255,255,255,248,80,0,191,3,255,255,255,255,248,0,0,191,0,0,0,0,0,0,0,0,106,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,1,255,207,224,0,6,0,0,0,31,254,7,244,0,47,192,0,2,255,240,2,252,1,255,208,1,191,255,128,0,255,15,254,0,191,255,255,64,0,127,255,244,0,191,254,127,64,0,31,255,64,0,63,128,63,64,0,11,254,0,0,0,0,63,64,90,194,255,224,0,0,0,127,255,255,192,127,254,64,0,191,255,255,255,192,11,255,249,0,191,255,255,249,64,1,255,255,0,127,254,80,0,0,0,27,253,0,20,0,0,0,0,0,0,104,
  // 0x8981  要
  129,137,36,38,86,40,2,251,21,85,85,85,85,85,85,85,84,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,2,252,0,127,0,0,0,0,0,2,252,0,127,0,0,0,0,0,2,252,0,127,0,0,0,7,255,255,255,255,255,255,255,224,7,255,255,255,255,255,255,255,224,7,255,255,255,255,255,255,255,224,7,240,2,252,0,127,0,15,224,7,240,2,252,0,127,0,15,224,7,240,2,252,0,127,0,15,224,7,240,2,252,0,127,0,15,224,7,240,2,252,0,127,0,15,224,7,255,255,255,255,255,255,255,224,7,255,255,255,255,255,255,255,224,7,255,255,255,255,255,255,255,224,0,0,0,127,192,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,3,253,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,191,192,0,0,255,0,0,0,0,255,0,0,3,254,0,0,0,3,254,0,0,11,252,0,0,0,7,255,144,0,31,244,0,0,0,15,255,255,144,191,224,0,0,0,63,255,255,255,255,128,0,0,0,6,198,255,255,255,64,0,0,0,0,0,15,255,255,253,0,0,0,0,6,255,255,255,255,244,0,21,171,255,255,249,27,255,255,208,63,255,255,255,128,0,111,255,244,47,255,255,144,0,0,1,191,240,15,169,64,0,0,0,0,6,192,0,0,0,0,0,0,0,0,0,
  // 0x89d2  角
  210,137,34,39,95,40,1,251,0,0,0,164,0,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,15,255,255,255,224,0,0,0,0,31,255,255,255,252,0,0,0,0,63,255,255,255,244,0,0,0,0,255,128,0,31,240,0,0,0,3,255,0,0,63,192,0,0,0,15,252,0,0,191,64,0,0,0,47,249,85,85,255,85,85,80,0,255,255,255,255,255,255,255,240,7,255,255,255,255,255,255,255,240,31,255,255,255,255,255,255,255,240,15,251,240,0,15,224,0,11,240,3,199,240,0,15,224,0,11,240,0,7,240,0,15,224,0,11,240,0,7,240,0,15,224,0,11,240,0,7,244,0,15,240,0,15,240,0,7,255,255,255,255,255,255,240,0,7,255,255,255,255,255,255,240,0,7,255,255,255,255,255,255,240,0,7,240,0,15,224,0,11,240,0,7,240,0,15,224,0,11,240,0,11,240,0,15,224,0,11,240,0,11,240,0,15,224,0,11,240,0,15,245,85,95,245,85,95,240,0,15,255,255,255,255,255,255,240,0,31,255,255,255,255,255,255,240,0,47,255,255,255,255,255,255,240,0,63,192,0,0,0,0,11,240,0,127,64,0,0,0,0,11,240,0,255,0,0,0,0,0,11,240,2,254,0,0,0,0,0,11,240,11,252,0,0,0,0,0,15,240,47,244,0,0,0,6,149,111,240,127,224,0,0,0,7,255,255,224,47,192,0,0,0,3,255,255,192,10,0,0,0,0,2,255,249,0,0,0,0,0,0,0,0,0,0,
  // 0x8ba1  计
  161,139,37,38,124,40,2,252,0,0,0,0,0,2,164,0,0,0,0,56,0,0,0,7,248,0,0,0,0,254,0,0,0,7,248,0,0,0,1,255,192,0,0,7,248,0,0,0,0,127,240,0,0,7,248,0,0,0,0,15,252,0,0,7,248,0,0,0,0,3,255,0,0,7,248,0,0,0,0,0,253,0,0,7,248,0,0,0,0,0,52,0,0,7,248,0,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,0,7,248,0,0,0,255,255,224,63,255,255,255,255,255,64,255,255,224,63,255,255,255,255,255,64,255,255,224,63,255,255,255,255,255,64,170,175,224,63,255,255,255,255,255,64,0,15,224,0,0,7,248,0,0,0,0,15,224,0,0,7,248,0,0,0,0,15,224,0,0,7,248,0,0,0,0,15,224,0,0,7,248,0,0,0,0,15,224,0,0,7,248,0,0,0,0,15,224,0,0,7,248,0,0,0,0,15,224,0,0,7,248,0,0,0,0,15,224,0,0,7,248,0,0,0,0,15,224,0,0,7,248,0,0,0,0,15,224,0,0,7,248,0,0,0,0,15,224,120,0,7,248,0,0,0,0,15,227,252,0,7,248,0,0,0,0,15,255,253,0,7,248,0,0,0,0,15,255,244,0,7,248,0,0,0,0,31,255,192,0,7,248,0,0,0,0,63,254,0,0,7,248,0,0,0,0,191,244,0,0,7,248,0,0,0,0,191,192,0,0,7,248,0,0,0,0,62,0,0,0,7,248,0,0,0,0,40,0,0,0,7,248,0,0,0,0,0,0,0,0,7,244,0,0,0,
  // 0x8bae  议
  174,139,37,38,124,40,2,251,0,80,0,0,0,124,0,0,0,0,2,240,0,0,1,253,0,0,0,0,7,252,0,22,0,255,0,7,224,0,2,255,0,63,64,127,64,11,244,0,0,255,128,63,128,63,192,15,240,0,0,63,192,63,128,47,208,15,240,0,0,31,224,47,192,15,224,15,224,0,0,15,128,31,192,15,240,31,208,0,0,2,0,15,208,7,240,47,208,0,0,0,0,15,224,3,64,63,192,0,0,0,0,11,240,0,0,63,192,0,0,0,0,7,240,0,0,127,128,0,255,255,128,3,248,0,0,191,0,0,255,255,128,3,252,0,0,255,0,0,255,255,128,2,252,0,1,254,0,0,170,191,128,0,254,0,2,253,0,0,0,63,128,0,255,0,3,252,0,0,0,63,128,0,127,64,7,248,0,0,0,63,128,0,63,192,15,240,0,0,0,63,128,0,47,208,31,224,0,0,0,63,128,0,15,240,63,208,0,0,0,63,128,0,15,248,127,192,0,0,0,63,128,0,7,252,255,64,0,0,0,63,128,0,2,255,254,0,0,0,0,63,128,0,0,255,252,0,0,0,0,63,128,0,0,127,244,0,0,0,0,63,128,224,0,63,240,0,0,0,0,63,135,240,0,255,252,0,0,0,0,63,255,240,3,255,255,64,0,0,0,63,255,208,15,254,255,208,0,0,0,63,255,0,127,244,191,248,0,0,0,127,248,2,255,208,31,255,64,0,0,255,208,31,255,64,7,255,244,0,1,255,1,255,252,0,0,255,255,64,0,188,3,255,208,0,0,31,255,64,0,32,1,255,0,0,0,2,253,0,0,0,0,180,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8bbe  设
  190,139,36,37,77,40,2,252,0,176,0,0,21,85,85,80,0,2,252,0,0,47,255,255,248,0,3,255,0,0,47,255,255,248,0,0,255,192,0,47,255,255,248,0,0,47,240,0,47,128,3,248,0,0,11,252,0,63,128,3,248,0,0,2,248,0,63,128,3,248,0,0,0,224,0,63,64,3,248,0,0,0,0,0,191,0,3,248,0,0,0,0,0,255,0,3,248,0,0,0,0,3,254,0,3,248,0,0,0,0,15,252,0,3,255,254,255,255,128,191,244,0,1,255,255,255,255,128,255,208,0,0,191,255,255,255,128,127,64,0,0,0,0,170,191,128,40,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,47,255,255,255,255,208,0,63,128,47,255,255,255,255,240,0,63,128,47,255,255,255,255,208,0,63,128,27,249,85,85,127,192,0,63,128,3,252,0,0,127,128,0,63,128,1,253,0,0,255,0,0,63,128,0,255,0,2,254,0,0,63,128,0,127,128,3,252,0,0,63,128,64,47,224,15,244,0,0,63,131,192,15,248,63,224,0,0,63,159,208,3,254,255,192,0,0,63,255,224,0,255,255,0,0,0,63,255,128,0,127,252,0,0,0,63,253,0,2,255,255,64,0,0,191,244,0,47,255,255,244,0,2,255,192,7,255,253,191,255,144,2,254,1,255,255,208,15,255,254,0,248,0,255,253,0,1,255,254,0,96,0,191,144,0,0,27,252,0,0,0,36,0,0,0,0,100,
  // 0x8bd5  试
  213,139,37,38,124,40,2,252,0,0,0,0,0,0,106,1,0,0,0,240,0,0,0,0,127,79,64,0,3,252,0,0,0,0,127,95,208,0,3,255,0,0,0,0,127,79,240,0,0,255,192,0,0,0,127,67,252,0,0,63,240,0,0,0,127,65,253,0,0,15,252,0,0,0,127,64,189,0,0,3,244,0,0,0,127,64,48,0,0,1,208,170,170,170,191,170,170,0,0,0,0,255,255,255,255,255,255,64,0,0,0,255,255,255,255,255,255,64,0,0,0,255,255,255,255,255,255,64,0,0,0,0,0,0,63,128,0,0,255,255,192,0,0,0,63,128,0,0,255,255,192,0,0,0,63,128,0,0,255,255,192,0,0,0,63,192,0,0,106,191,192,0,0,0,63,192,0,0,0,47,192,21,85,85,63,192,0,0,0,47,192,63,255,255,47,192,0,0,0,47,192,63,255,255,47,192,0,0,0,47,192,63,255,255,47,192,0,0,0,47,192,0,63,64,31,208,0,0,0,47,192,0,63,64,31,208,0,0,0,47,192,0,63,64,15,208,0,0,0,47,192,0,63,64,15,224,0,0,0,47,192,0,63,64,15,240,0,0,0,47,192,0,63,64,15,240,0,0,0,47,192,64,63,64,11,240,20,0,0,47,194,192,63,65,71,244,30,0,0,47,223,208,63,175,199,248,47,128,0,47,255,224,127,255,195,252,47,64,0,63,255,239,255,255,195,252,63,64,0,191,253,127,255,248,1,255,63,0,1,255,224,63,249,0,0,255,255,0,0,255,64,46,64,0,0,191,253,0,0,124,0,0,0,0,0,63,252,0,0,32,0,0,0,0,0,31,248,0,0,0,0,0,0,0,0,6,224,0,
  // 0x8bef  误
  239,139,37,37,114,40,2,252,0,128,0,0,0,0,0,0,0,0,3,240,0,3,255,255,255,255,240,0,11,253,0,3,255,255,255,255,240,0,3,255,64,3,255,255,255,255,240,0,0,191,208,3,244,0,0,15,240,0,0,47,244,3,244,0,0,15,240,0,0,15,244,3,244,0,0,15,240,0,0,3,208,3,244,0,0,15,240,0,0,0,64,3,244,0,0,15,240,0,0,0,0,3,255,255,255,255,240,0,0,0,0,3,255,255,255,255,240,0,0,0,0,3,255,255,255,255,240,0,255,255,128,0,0,0,0,0,0,0,255,255,128,0,0,0,0,0,0,0,255,255,128,0,0,0,0,0,0,0,170,191,128,5,85,85,85,85,80,0,0,63,128,15,255,255,255,255,252,0,0,63,128,15,255,255,255,255,252,0,0,63,128,15,255,255,255,255,252,0,0,63,128,0,0,11,240,0,0,0,0,63,128,0,0,11,240,0,0,0,0,63,128,0,0,15,224,0,0,0,0,63,128,0,0,15,224,0,0,0,0,63,128,127,255,255,255,255,255,64,0,63,128,127,255,255,255,255,255,64,0,63,128,127,255,255,255,255,255,64,0,63,128,85,85,127,253,85,85,0,0,63,130,192,0,127,253,0,0,0,0,63,223,192,0,255,255,0,0,0,0,63,255,208,3,254,127,192,0,0,0,63,255,128,11,252,47,240,0,0,0,191,253,0,127,244,15,254,0,0,1,255,224,2,255,208,3,255,208,0,0,255,64,191,255,64,0,255,254,64,0,60,0,255,248,0,0,47,255,0,0,32,0,63,208,0,0,3,252,0,0,0,0,40,0,0,0,0,40,0,
  // 0x8bf7  请
  247,139,37,39,134,40,2,251,0,0,0,0,0,11,224,0,0,0,0,192,0,0,0,15,240,0,0,0,3,240,0,0,0,15,240,0,0,0,11,252,0,42,170,175,250,170,168,0,2,255,64,47,255,255,255,255,252,0,0,191,192,47,255,255,255,255,252,0,0,47,240,0,0,15,240,0,0,0,0,15,240,0,0,15,240,0,0,0,0,3,208,6,170,175,250,170,160,0,0,1,64,11,255,255,255,255,240,0,0,0,0,11,255,255,255,255,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,255,255,192,170,170,175,250,170,170,0,255,255,192,255,255,255,255,255,255,64,255,255,192,255,255,255,255,255,255,64,170,191,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,3,255,255,255,255,208,0,0,63,192,3,255,255,255,255,208,0,0,63,192,3,255,255,255,255,208,0,0,63,192,3,244,0,0,15,208,0,0,63,192,3,244,0,0,15,208,0,0,63,192,3,250,170,170,175,208,0,0,63,192,3,255,255,255,255,208,0,0,63,192,3,255,255,255,255,208,0,0,63,192,3,244,0,0,15,208,0,0,63,194,195,244,0,0,15,208,0,0,63,207,195,244,0,0,15,208,0,0,63,255,227,255,255,255,255,208,0,0,63,255,195,255,255,255,255,208,0,0,63,255,3,250,170,170,175,208,0,0,127,248,3,244,0,0,15,208,0,0,255,224,3,244,0,0,15,208,0,2,255,64,3,244,0,0,31,208,0,0,253,0,3,244,0,63,255,192,0,0,112,0,3,244,0,47,255,192,0,0,0,0,3,244,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8bfb  读
  251,139,37,39,134,40,1,251,0,0,0,0,0,2,164,0,0,0,0,32,0,0,0,3,248,0,0,0,0,252,0,0,0,3,248,0,0,0,3,255,0,0,0,3,248,0,0,0,0,255,208,3,255,255,255,255,248,0,0,63,244,3,255,255,255,255,248,0,0,15,253,3,255,255,255,255,248,0,0,3,253,0,0,3,248,0,0,0,0,0,244,0,0,3,248,0,0,0,0,0,16,0,0,3,248,0,0,0,0,0,0,31,255,255,255,255,255,64,0,0,0,31,255,255,255,255,255,0,0,0,0,31,255,255,255,255,255,0,127,255,224,0,0,0,0,0,254,0,127,255,224,0,4,0,0,0,253,0,127,255,224,0,63,64,254,1,252,0,42,175,224,0,63,224,254,2,248,0,0,15,224,0,11,252,254,3,244,0,0,15,224,2,0,254,254,0,80,0,0,15,224,15,224,44,254,0,0,0,0,15,224,11,252,0,254,0,0,0,0,15,224,1,255,64,253,0,0,0,0,15,224,0,47,192,253,0,0,0,0,15,224,0,7,1,253,0,0,0,0,15,224,63,255,255,255,255,255,128,0,15,224,63,255,255,255,255,255,128,0,15,224,127,255,255,255,255,255,128,0,15,225,192,0,31,244,0,0,0,0,15,235,208,0,47,224,128,0,0,0,15,255,240,0,127,195,244,0,0,0,15,255,208,1,255,139,254,0,0,0,15,255,64,7,254,1,255,192,0,0,31,252,0,63,252,0,63,240,0,0,63,240,2,255,240,0,11,253,0,0,191,128,47,255,128,0,2,255,64,0,62,0,191,253,0,0,0,127,192,0,24,0,47,224,0,0,0,31,64,0,0,0,14,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8c03  调
  3,140,35,38,86,40,2,251,0,128,0,0,0,0,0,0,0,3,240,0,63,255,255,255,255,252,11,252,0,63,255,255,255,255,252,2,255,0,63,255,255,255,255,252,0,191,192,63,128,0,0,2,252,0,47,240,63,64,6,144,1,252,0,11,240,63,64,11,208,1,252,0,3,192,63,64,11,208,1,252,0,0,0,63,66,175,250,145,252,0,0,0,63,71,255,255,209,252,0,0,0,63,71,255,255,209,252,0,0,0,63,64,11,208,1,252,255,255,128,63,64,11,208,1,252,255,255,128,63,64,11,208,1,252,255,255,128,63,64,11,208,1,252,170,191,128,63,79,255,255,245,252,0,63,128,63,79,255,255,245,252,0,63,128,63,79,255,255,245,252,0,63,128,63,64,0,0,1,252,0,63,128,63,64,0,0,1,252,0,63,128,63,70,170,170,129,252,0,63,128,63,75,255,255,193,252,0,63,128,63,11,255,255,193,252,0,63,128,63,11,208,11,193,252,0,63,128,127,11,208,11,193,252,0,63,128,127,11,208,11,193,252,0,63,137,190,11,208,11,193,252,0,63,191,254,11,250,175,193,252,0,63,255,253,11,255,255,193,252,0,63,255,252,11,255,255,193,252,0,127,250,252,11,208,0,1,252,0,255,227,248,11,208,0,1,252,1,255,135,244,0,0,0,1,252,3,254,15,240,0,0,1,86,252,2,248,31,208,0,0,3,255,248,0,160,15,192,0,0,2,255,244,0,0,2,64,0,0,1,255,128,0,0,0,0,0,0,0,0,0,
  // 0x8d25  败
  37,141,36,38,86,40,2,252,0,0,0,0,0,1,0,0,0,0,0,0,0,0,11,240,0,0,31,255,255,255,0,15,224,0,0,31,255,255,255,0,15,208,0,0,31,255,255,255,0,31,192,0,0,31,149,85,127,0,47,192,0,0,31,128,0,63,0,63,128,0,0,31,128,0,63,0,63,149,85,84,31,130,164,63,0,127,255,255,255,31,131,244,63,0,255,255,255,255,31,131,244,63,0,255,255,255,255,31,131,244,63,2,252,0,15,192,31,131,244,63,3,248,0,15,192,31,131,244,63,7,244,0,31,192,31,131,244,63,15,240,0,31,128,31,131,244,63,47,244,0,47,128,31,131,244,63,127,252,0,63,64,31,131,244,63,127,252,0,63,0,31,131,244,63,31,253,0,63,0,31,131,244,63,12,127,0,126,0,31,131,244,63,0,63,0,253,0,31,131,244,63,0,47,128,252,0,31,131,244,63,0,31,193,252,0,31,131,240,63,0,15,227,248,0,31,131,240,63,0,7,247,240,0,31,135,240,63,0,3,255,240,0,31,139,224,63,0,1,255,208,0,0,15,208,0,0,0,255,192,0,0,31,194,128,0,0,191,192,0,0,47,207,208,0,0,255,240,0,0,127,75,240,0,3,255,248,0,0,255,3,252,0,15,251,254,0,3,252,1,253,0,63,224,255,128,15,248,0,191,1,255,192,63,240,127,224,0,63,203,255,0,31,254,255,192,0,31,95,248,0,3,255,62,0,0,8,11,208,0,0,188,20,0,0,0,2,0,0,0,20,
  // 0x8d2a  贪
  42,141,37,38,124,40,2,252,0,0,0,0,29,0,0,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,7,255,208,0,0,0,0,0,0,0,127,255,252,0,0,0,0,0,0,3,255,231,255,208,0,0,0,0,0,127,255,0,191,254,0,0,0,0,11,255,244,176,11,255,248,0,0,6,255,255,131,253,0,191,255,228,0,191,255,248,1,255,64,11,255,255,64,255,255,64,0,63,192,0,127,254,0,63,224,0,0,31,128,0,2,252,0,24,47,255,255,255,255,255,192,0,0,0,47,255,255,255,255,255,240,0,0,0,47,255,255,255,255,255,208,0,0,0,0,0,0,0,1,255,64,0,0,0,0,0,0,0,7,254,0,0,0,0,0,0,0,0,31,248,0,0,0,0,0,0,0,0,31,224,0,0,0,0,63,255,255,255,255,255,248,0,0,0,63,255,255,255,255,255,248,0,0,0,63,255,255,255,255,255,248,0,0,0,63,213,85,85,85,87,248,0,0,0,63,128,0,85,0,3,248,0,0,0,63,128,0,255,0,3,248,0,0,0,63,128,0,255,0,3,248,0,0,0,63,128,0,255,0,3,248,0,0,0,63,128,0,255,0,3,248,0,0,0,63,128,1,254,0,3,248,0,0,0,63,128,3,253,0,3,248,0,0,0,63,128,11,252,80,3,248,0,0,0,21,64,47,244,254,64,0,0,0,0,0,1,255,226,255,249,0,0,0,0,0,31,255,65,191,255,224,0,0,0,6,255,253,0,6,255,254,64,0,6,255,255,208,0,0,47,255,244,0,31,255,253,0,0,0,1,255,240,0,7,255,144,0,0,0,0,11,224,0,2,224,0,0,0,0,0,0,128,0,
  // 0x8d77  起
  119,141,38,39,134,40,1,251,0,0,85,0,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,0,191,0,0,191,255,255,252,0,0,0,191,0,0,191,255,255,252,0,1,85,191,85,80,191,255,255,252,0,15,255,255,255,240,21,85,86,252,0,15,255,255,255,240,0,0,1,252,0,15,255,255,255,240,0,0,1,252,0,0,0,191,0,0,0,0,1,252,0,0,0,191,0,0,0,0,1,252,0,0,0,191,0,0,0,0,1,252,0,0,0,191,0,0,0,0,1,252,0,21,85,191,85,84,0,0,1,252,0,63,255,255,255,252,63,255,255,252,0,63,255,255,255,252,63,255,255,252,0,63,255,255,255,252,63,255,255,252,0,0,0,63,128,0,63,149,86,252,0,0,0,63,128,0,63,64,0,84,0,1,0,63,128,0,63,64,0,0,0,7,240,63,128,0,63,64,0,0,0,7,240,63,128,0,63,64,0,0,0,7,240,63,255,248,63,64,0,0,0,7,240,63,255,248,63,64,0,14,0,7,240,63,255,248,63,64,0,15,208,7,240,63,128,0,63,64,0,15,208,11,244,63,128,0,63,64,0,15,192,11,252,63,128,0,63,64,0,31,192,11,252,63,128,0,63,213,85,127,192,15,255,63,128,0,63,255,255,255,128,15,255,127,128,0,31,255,255,255,0,15,255,255,128,0,6,255,255,248,0,31,223,255,128,0,0,0,0,0,0,47,199,255,233,0,0,0,0,0,0,63,128,255,255,255,255,255,255,255,208,63,64,47,255,255,255,255,255,255,192,191,0,1,255,255,255,255,255,255,128,191,0,0,1,106,170,170,170,170,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8d85  超
  133,141,38,38,124,40,1,252,0,0,189,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,3,255,255,255,255,0,0,0,254,0,3,255,255,255,255,0,0,0,254,0,3,255,255,255,255,0,15,255,255,255,224,1,252,0,191,0,15,255,255,255,224,2,252,0,191,0,15,255,255,255,224,3,248,0,191,0,0,0,254,0,0,3,244,0,255,0,0,0,254,0,0,11,240,0,254,0,0,0,254,0,0,15,224,0,254,0,0,0,254,0,0,63,192,2,253,0,21,85,254,85,80,191,67,255,252,0,63,255,255,255,247,254,2,255,248,0,63,255,255,255,255,252,1,255,224,0,63,255,255,255,251,240,0,0,0,0,0,0,127,0,1,128,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,0,127,0,0,255,255,255,253,0,7,240,127,0,0,255,255,255,253,0,7,240,127,0,0,255,255,255,253,0,7,240,127,64,0,253,0,1,253,0,7,240,127,255,240,253,0,1,253,0,7,240,127,255,240,253,0,1,253,0,11,240,127,255,240,253,0,1,253,0,11,240,127,0,0,253,0,1,253,0,11,248,127,0,0,253,0,1,253,0,15,252,127,0,0,255,255,255,253,0,15,255,127,0,0,255,255,255,253,0,15,255,255,0,0,255,255,255,253,0,15,255,255,0,0,0,0,0,0,0,31,207,255,0,0,0,0,0,0,0,47,135,255,249,0,0,0,0,0,0,63,129,255,255,255,255,255,255,255,208,127,64,47,255,255,255,255,255,255,192,255,0,1,255,255,255,255,255,255,128,46,0,0,1,106,170,170,170,170,0,4,0,0,0,0,0,0,0,0,0,
  // 0x8ddd  距
  221,141,38,36,104,40,1,252,7,255,255,255,7,255,255,255,255,192,7,255,255,255,7,255,255,255,255,192,7,255,255,255,7,255,255,255,255,192,7,240,0,127,7,249,85,85,85,64,7,240,0,127,7,240,0,0,0,0,7,240,0,127,7,240,0,0,0,0,7,240,0,127,7,240,0,0,0,0,7,240,0,127,7,240,0,0,0,0,7,240,0,127,7,240,0,0,0,0,7,240,0,191,7,249,85,85,84,0,7,255,255,255,7,255,255,255,253,0,7,255,255,255,7,255,255,255,253,0,7,255,255,255,7,255,255,255,253,0,0,0,253,0,7,240,0,1,253,0,0,0,253,0,7,240,0,1,253,0,0,0,253,0,7,240,0,1,253,0,7,208,253,0,7,240,0,1,253,0,11,224,253,0,7,240,0,1,253,0,11,224,255,255,135,240,0,1,253,0,11,224,255,255,135,240,0,1,253,0,11,224,255,255,135,249,85,86,253,0,11,224,253,85,7,255,255,255,253,0,11,224,253,0,7,255,255,255,253,0,11,224,253,0,7,255,255,255,253,0,11,224,253,0,7,240,0,0,0,0,11,224,253,0,7,240,0,0,0,0,11,224,253,0,71,240,0,0,0,0,11,224,253,111,199,240,0,0,0,0,11,224,255,255,199,240,0,0,0,0,11,255,255,255,199,240,0,0,0,0,111,255,255,254,71,249,85,85,85,64,191,255,254,64,7,255,255,255,255,208,127,254,64,0,7,255,255,255,255,208,62,64,0,0,7,255,255,255,255,208,0,0,0,0,7,240,0,0,0,0,0,0,0,0,7,240,0,0,0,0,
  // 0x8f6c  转
  108,143,36,38,86,40,2,252,0,10,64,0,0,0,101,0,0,0,31,208,0,0,0,255,0,0,0,31,192,0,0,0,255,0,0,0,47,192,0,0,0,254,0,0,85,127,213,84,0,1,253,0,0,255,255,255,252,127,255,255,255,252,255,255,255,252,127,255,255,255,252,255,255,255,252,127,255,255,255,252,0,253,0,0,21,91,249,85,84,0,252,0,0,0,11,240,0,0,1,252,0,0,0,15,224,0,0,2,249,168,0,0,31,208,0,0,3,241,252,1,85,111,229,85,85,7,241,252,3,255,255,255,255,255,11,209,252,3,255,255,255,255,255,15,193,252,3,255,255,255,255,255,31,129,252,0,0,191,0,0,0,63,150,253,80,0,255,0,0,0,191,255,255,248,1,254,0,0,0,127,255,255,248,2,253,0,0,0,63,255,255,248,3,255,255,255,224,16,1,252,0,7,255,255,255,252,0,1,252,0,11,255,255,255,240,0,1,252,0,5,85,85,191,208,0,1,252,1,0,0,0,191,128,0,1,254,255,0,0,1,255,0,0,27,255,255,0,0,3,253,0,191,255,255,255,0,180,15,248,0,255,255,255,229,2,254,31,224,0,255,255,252,0,3,255,255,192,0,250,65,252,0,0,127,255,64,0,0,1,252,0,0,15,255,64,0,0,1,252,0,0,2,255,224,0,0,1,252,0,0,0,127,252,0,0,1,252,0,0,0,15,255,0,0,1,252,0,0,0,2,255,0,0,1,252,0,0,0,0,189,0,0,1,252,0,0,0,0,20,0,
  // 0x8f6f  软
  111,143,37,38,124,40,2,252,0,1,64,0,0,42,64,0,0,0,0,3,252,0,0,63,128,0,0,0,0,3,248,0,0,63,64,0,0,0,0,7,244,0,0,127,64,0,0,0,0,11,240,0,0,127,0,0,0,0,255,255,255,255,192,191,0,0,0,0,255,255,255,255,192,255,255,255,254,0,255,255,255,255,192,255,255,255,255,0,170,191,234,170,129,255,255,255,255,0,0,63,64,0,2,253,85,85,254,0,0,127,0,0,3,248,0,0,254,0,0,254,42,0,7,244,0,0,253,0,0,253,63,64,15,240,0,1,252,0,2,252,63,64,31,224,20,1,252,0,3,248,63,64,63,208,254,2,248,0,7,240,63,64,127,192,254,3,244,0,15,240,63,64,191,64,254,3,240,0,31,229,127,149,95,0,254,2,240,0,63,255,255,255,192,0,254,0,0,0,63,255,255,255,192,0,254,0,0,0,47,255,255,255,192,0,255,0,0,0,4,0,63,64,0,1,255,0,0,0,0,0,63,64,0,1,255,64,0,0,0,0,63,64,0,2,255,128,0,0,0,0,63,64,0,3,255,192,0,0,0,0,63,171,192,7,255,208,0,0,0,26,255,255,192,11,255,240,0,0,191,255,255,255,208,15,247,240,0,0,255,255,255,254,128,47,211,248,0,0,255,255,255,64,0,63,194,253,0,0,254,144,63,64,0,255,64,255,0,0,0,0,63,64,2,255,0,191,192,0,0,0,63,64,11,253,0,63,224,0,0,0,63,64,47,244,0,31,248,0,0,0,63,64,191,224,0,11,255,64,0,0,63,65,255,128,0,2,255,0,0,0,63,64,62,0,0,0,188,0,0,0,42,0,8,0,0,0,20,0,
  // 0x8f74  轴
  116,143,35,38,86,40,2,252,0,26,64,0,0,0,253,0,0,0,31,192,0,0,0,254,0,0,0,47,192,0,0,0,254,0,0,0,63,128,0,0,0,254,0,0,85,127,213,84,0,0,254,0,0,255,255,255,248,0,0,254,0,0,255,255,255,248,0,0,254,0,0,255,255,255,248,0,0,254,0,0,0,253,0,0,0,0,254,0,0,0,252,0,0,191,255,255,255,252,1,252,0,0,191,255,255,255,252,3,248,252,0,191,255,255,255,252,3,244,252,0,191,85,254,86,252,7,240,252,0,190,0,253,0,252,11,224,252,0,190,0,253,0,252,15,208,252,0,190,0,253,0,252,31,192,252,0,190,0,253,0,252,63,213,254,84,190,0,253,0,252,191,255,255,248,190,0,253,0,252,127,255,255,248,190,0,253,0,252,63,255,255,248,191,255,255,255,252,16,0,252,0,191,255,255,255,252,0,0,252,0,191,255,255,255,252,0,0,252,0,191,85,254,85,252,0,0,252,4,190,0,253,0,252,0,0,255,252,190,0,253,0,252,0,107,255,252,190,0,253,0,252,255,255,255,252,190,0,253,0,252,255,255,255,148,190,0,253,0,252,255,254,252,0,190,0,253,0,252,185,0,252,0,190,0,253,0,252,0,0,252,0,190,0,253,0,252,0,0,252,0,191,255,255,255,252,0,0,252,0,191,255,255,255,252,0,0,252,0,191,255,255,255,252,0,0,252,0,191,85,85,85,252,0,0,252,0,190,0,0,0,252,0,0,168,0,190,0,0,0,84,
  // 0x8f7d  载
  125,143,37,39,134,40,2,251,0,0,47,192,0,15,224,0,0,0,0,0,47,192,0,15,224,120,0,0,0,0,47,192,0,15,225,255,0,0,11,255,255,255,254,15,224,191,192,0,15,255,255,255,254,15,224,47,224,0,15,255,255,255,254,15,224,15,248,0,0,0,47,192,0,15,240,3,240,0,0,0,47,192,0,15,240,1,128,0,0,0,47,192,0,15,240,0,0,0,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,0,0,2,228,0,0,11,240,0,0,0,0,3,252,0,0,11,240,0,0,0,0,7,248,0,0,7,240,2,64,0,0,11,244,0,0,7,240,7,240,0,63,255,255,255,255,199,240,11,240,0,63,255,255,255,255,195,244,15,224,0,63,255,255,255,255,195,244,31,192,0,0,127,0,0,0,3,248,47,192,0,0,254,3,244,0,3,248,63,128,0,2,252,3,244,0,3,252,191,0,0,7,244,3,244,0,2,252,255,0,0,31,255,255,255,255,65,254,253,0,0,15,255,255,255,255,65,255,252,0,0,11,255,255,255,255,64,255,244,0,0,5,0,3,244,0,0,255,240,0,0,0,0,3,244,0,0,191,208,0,0,0,0,3,244,0,0,127,192,24,0,0,0,3,255,255,192,255,128,47,64,21,106,255,255,255,195,255,192,47,64,127,255,255,255,255,203,255,208,63,0,63,255,255,249,0,47,255,240,63,0,63,234,87,244,0,191,199,252,127,0,0,0,3,244,2,255,67,255,254,0,0,0,3,244,11,254,0,255,252,0,0,0,3,244,2,244,0,63,248,0,0,0,3,244,0,208,0,6,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8f91  辑
  145,143,38,38,124,40,1,252,0,6,64,0,0,0,0,0,0,0,0,11,240,0,10,170,170,170,164,0,0,15,240,0,15,255,255,255,248,0,0,15,224,0,15,255,255,255,248,0,0,15,224,0,15,208,0,3,248,0,63,255,255,254,15,208,0,3,248,0,63,255,255,254,15,208,0,3,248,0,63,255,255,254,15,250,170,171,248,0,42,191,170,169,15,255,255,255,248,0,0,127,0,0,15,255,255,255,248,0,0,191,0,0,0,0,0,0,0,0,0,254,127,0,0,0,0,0,0,0,0,253,127,0,0,0,0,0,0,0,1,252,127,0,255,255,255,255,255,192,2,248,127,0,255,255,255,255,255,192,3,244,127,0,255,255,255,255,255,192,7,240,127,0,15,224,0,3,244,0,15,229,191,84,15,224,0,3,244,0,47,255,255,252,15,250,170,175,244,0,31,255,255,252,15,255,255,255,244,0,15,255,255,252,15,255,255,255,244,0,4,0,127,0,15,224,0,3,244,0,0,0,127,0,15,224,0,3,244,0,0,0,127,0,15,224,0,3,244,0,0,0,127,0,15,250,170,171,244,0,0,0,127,111,15,255,255,255,244,0,0,91,255,255,15,255,255,255,244,0,127,255,255,255,15,224,0,3,244,0,63,255,255,229,15,224,0,3,244,0,63,255,255,0,15,224,0,3,244,0,46,80,127,0,15,246,175,255,255,208,0,0,127,3,255,255,255,255,255,208,0,0,127,3,255,255,255,255,255,192,0,0,127,2,255,250,149,3,244,0,0,0,127,0,64,0,0,3,244,0,0,0,127,0,0,0,0,3,244,0,0,0,127,0,0,0,0,3,244,0,0,0,106,0,0,0,0,3,240,0,
  // 0x8f93  输
  147,143,37,39,134,40,2,251,0,100,0,0,0,0,208,0,0,0,0,254,0,0,0,3,252,0,0,0,0,254,0,0,0,11,248,0,0,0,0,253,0,0,0,47,252,0,0,0,0,252,0,0,0,191,255,64,0,0,255,255,255,128,3,255,127,208,0,0,255,255,255,128,31,252,15,248,0,0,255,255,255,128,191,240,3,255,128,0,87,249,85,7,255,192,0,191,248,0,3,240,0,63,254,0,0,47,255,64,7,240,0,255,255,255,255,255,255,64,11,225,80,63,255,255,255,255,125,0,11,215,240,12,63,255,255,255,4,0,15,199,240,0,0,0,0,0,0,0,15,135,240,0,0,0,0,0,84,0,47,71,240,11,255,255,192,0,252,0,63,7,240,11,255,255,194,224,252,0,127,91,245,11,255,255,195,240,252,0,255,255,255,139,208,15,195,240,252,0,255,255,255,139,208,15,195,240,252,0,127,255,255,139,208,15,195,240,252,0,16,7,240,11,250,175,195,240,252,0,0,7,240,11,255,255,195,240,252,0,0,7,240,11,255,255,195,240,252,0,0,7,240,11,208,15,195,240,252,0,0,7,255,139,208,15,195,240,252,0,0,111,255,203,208,15,195,240,252,0,175,255,255,203,255,255,195,240,252,0,255,255,249,11,255,255,195,240,252,0,255,255,240,11,255,255,195,240,252,0,185,7,240,11,208,15,195,224,252,0,0,7,240,11,208,15,192,0,252,0,0,7,240,11,208,15,192,0,252,0,0,7,240,11,208,15,192,0,252,0,0,7,240,11,208,15,192,255,252,0,0,7,240,11,210,255,192,255,248,0,0,7,240,11,209,255,192,191,144,0,0,7,224,11,208,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8fb9  边
  185,143,38,38,124,40,1,251,0,240,0,0,0,127,128,0,0,0,7,252,0,0,0,127,128,0,0,0,3,255,0,0,0,127,128,0,0,0,0,255,192,0,0,127,128,0,0,0,0,127,224,0,0,127,128,0,0,0,0,31,244,0,0,127,64,0,0,0,0,11,252,42,170,255,234,170,170,0,0,3,240,127,255,255,255,255,255,0,0,0,128,127,255,255,255,255,255,0,0,0,0,127,255,255,255,255,255,0,0,0,0,0,0,255,0,0,254,0,0,0,0,0,0,255,0,0,254,0,0,0,0,0,0,255,0,0,254,0,127,255,208,0,1,254,0,0,254,0,127,255,208,0,1,253,0,0,254,0,127,255,208,0,2,253,0,1,254,0,42,191,208,0,3,252,0,1,253,0,0,31,208,0,7,252,0,1,253,0,0,31,208,0,11,248,0,1,253,0,0,31,208,0,15,240,0,2,253,0,0,31,208,0,31,240,0,2,252,0,0,31,208,0,63,208,0,2,252,0,0,31,208,0,127,192,0,3,252,0,0,31,208,0,255,64,0,3,252,0,0,31,208,3,255,0,0,3,252,0,0,31,208,15,252,0,0,11,248,0,0,31,208,127,244,1,170,175,244,0,0,31,208,255,208,0,255,255,240,0,0,47,208,127,64,0,255,255,208,0,0,191,244,28,0,0,191,254,0,0,3,255,254,0,0,0,0,0,0,0,15,255,255,208,0,0,0,0,0,0,63,244,127,254,80,0,0,5,106,224,255,208,15,255,255,255,255,255,255,208,127,128,2,255,255,255,255,255,255,192,47,0,0,31,255,255,255,255,255,192,12,0,0,0,90,170,170,169,85,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8fc1  迁
  193,143,38,37,114,40,1,252,0,184,0,0,0,0,0,111,192,0,2,255,64,0,0,1,175,255,240,0,1,255,224,0,91,255,255,255,244,0,0,63,248,63,255,255,255,249,0,0,0,11,254,63,255,255,245,0,0,0,0,1,248,47,250,95,240,0,0,0,0,0,96,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,3,192,0,0,0,15,240,0,0,0,15,248,0,0,0,15,240,0,0,0,15,255,64,0,0,15,240,0,0,0,1,255,224,0,0,15,240,0,0,0,0,63,244,0,0,15,240,0,0,0,0,11,225,255,255,255,255,255,255,192,0,1,129,255,255,255,255,255,255,192,0,0,1,255,255,255,255,255,255,192,0,0,0,85,85,95,245,85,85,64,0,0,0,0,0,15,240,0,0,0,63,255,240,0,0,15,240,0,0,0,63,255,240,0,0,15,240,0,0,0,63,255,240,0,0,15,240,0,0,0,21,95,240,0,0,15,240,0,0,0,0,11,240,0,0,15,240,0,0,0,0,11,240,0,0,15,240,0,0,0,0,11,240,0,0,15,240,0,0,0,0,11,240,0,0,15,240,0,0,0,0,11,240,0,0,15,240,0,0,0,0,11,240,0,0,15,240,0,0,0,0,15,244,0,0,15,240,0,0,0,0,63,252,0,0,15,240,0,0,0,1,255,255,64,0,15,240,0,0,0,11,255,191,244,0,0,0,0,0,0,127,252,47,255,234,85,85,90,170,144,63,240,7,255,255,255,255,255,255,192,47,128,0,191,255,255,255,255,255,128,13,0,0,2,191,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,
  // 0x8fd0  运
  208,143,38,37,114,40,1,252,0,180,0,0,0,0,0,0,0,0,2,255,0,1,85,85,85,85,84,0,2,255,208,7,255,255,255,255,248,0,0,127,248,7,255,255,255,255,248,0,0,11,253,7,255,255,255,255,248,0,0,2,248,0,0,0,0,0,0,0,0,0,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,128,0,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,0,47,254,0,85,85,85,85,85,85,64,7,255,192,255,255,255,255,255,255,208,0,191,240,255,255,255,255,255,255,208,0,31,224,255,255,255,255,255,255,208,0,3,128,0,3,254,0,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,0,7,248,0,32,0,0,0,0,0,0,11,244,2,252,0,0,63,255,224,0,15,240,2,254,0,0,63,255,224,0,31,224,0,255,64,0,63,255,224,0,47,192,0,63,192,0,21,111,224,0,63,128,0,31,224,0,0,15,224,0,127,64,0,15,244,0,0,15,224,0,255,0,0,27,252,0,0,15,224,0,254,107,255,255,253,0,0,15,224,191,255,255,255,255,255,0,0,15,224,191,255,255,255,255,255,64,0,15,224,127,255,255,233,80,63,192,0,15,224,122,148,0,0,0,47,128,0,127,248,0,0,0,0,0,24,0,1,255,254,0,0,0,0,0,0,0,15,255,255,224,0,0,0,0,0,0,127,248,63,255,169,85,85,85,170,144,63,224,11,255,255,255,255,255,255,192,47,64,1,255,255,255,255,255,255,128,13,0,0,6,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,
  // 0x8fd1  近
  209,143,38,38,124,40,1,252,0,0,0,0,0,0,0,2,0,0,1,64,0,0,0,0,1,191,208,0,11,224,0,0,0,5,191,255,244,0,31,252,0,2,234,255,255,255,228,0,7,255,0,2,255,255,255,249,0,0,1,255,192,2,255,255,229,0,0,0,0,63,240,2,254,80,0,0,0,0,0,15,248,2,252,0,0,0,0,0,0,3,224,2,252,0,0,0,0,0,0,1,128,2,252,0,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,0,2,255,255,255,255,255,192,0,0,0,2,255,255,255,255,255,192,0,0,0,2,255,255,255,255,255,192,0,0,0,2,253,85,95,245,85,64,63,255,240,3,252,0,15,240,0,0,63,255,240,3,248,0,15,240,0,0,63,255,240,3,248,0,15,240,0,0,21,95,240,3,244,0,15,240,0,0,0,15,240,7,240,0,15,240,0,0,0,15,240,11,240,0,15,240,0,0,0,15,240,15,224,0,15,240,0,0,0,15,240,31,208,0,15,240,0,0,0,15,240,63,192,0,15,240,0,0,0,15,240,127,128,0,15,240,0,0,0,15,240,255,0,0,15,240,0,0,0,15,243,254,0,0,15,240,0,0,0,15,242,252,0,0,15,240,0,0,0,15,240,180,0,0,15,240,0,0,0,127,252,16,0,0,15,240,0,0,2,255,255,64,0,0,6,144,0,0,15,255,191,244,0,0,0,0,0,0,127,252,47,255,250,170,170,170,171,208,63,224,11,255,255,255,255,255,255,192,47,128,0,191,255,255,255,255,255,128,13,0,0,6,191,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,
  // 0x8fd4  返
  212,143,38,37,114,40,1,252,1,64,0,0,0,0,0,0,0,0,11,224,0,11,255,255,255,255,255,0,31,252,0,11,255,255,255,255,255,0,7,255,0,11,255,255,255,255,255,0,1,255,192,11,245,85,85,85,85,0,0,127,224,11,240,0,0,0,0,0,0,31,244,11,240,0,0,0,0,0,0,11,224,11,240,0,0,0,0,0,0,3,64,11,240,0,0,0,0,0,0,0,0,11,245,85,85,85,64,0,0,0,0,11,255,255,255,255,248,0,0,0,0,15,255,255,255,255,244,0,0,0,0,15,255,255,255,255,240,0,0,0,0,15,251,240,0,15,240,0,0,0,0,15,243,248,0,31,208,0,63,255,208,15,226,252,0,63,192,0,63,255,208,15,225,253,0,127,128,0,63,255,208,15,208,255,0,255,0,0,21,111,208,31,208,127,194,254,0,0,0,15,208,31,192,47,215,252,0,0,0,15,208,63,192,15,255,244,0,0,0,15,208,63,192,7,255,224,0,0,0,15,208,127,64,3,255,192,0,0,0,15,208,191,0,7,255,208,0,0,0,15,208,255,0,47,255,248,0,0,0,15,209,253,0,255,255,255,64,0,0,15,211,252,27,255,195,255,248,0,0,15,219,244,255,254,0,191,255,128,0,31,242,240,127,244,0,31,255,128,0,191,248,80,47,64,0,1,255,0,2,255,255,0,4,0,0,0,29,0,15,254,255,228,0,0,0,0,0,0,127,248,63,255,234,149,86,170,170,208,63,224,11,255,255,255,255,255,255,192,47,64,1,255,255,255,255,255,255,128,13,0,0,6,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,
  // 0x8fd8  还
  216,143,38,38,124,40,1,251,0,240,0,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,0,3,255,0,255,255,255,255,255,255,0,1,255,192,255,255,255,255,255,255,0,0,127,224,255,255,255,255,255,255,0,0,31,248,170,170,171,255,170,170,0,0,11,252,0,0,3,252,0,0,0,0,3,240,0,0,11,248,0,0,0,0,0,128,0,0,15,240,0,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,0,127,208,0,0,0,0,0,0,0,1,255,208,0,0,0,0,0,0,0,3,255,208,128,0,0,127,255,208,0,15,255,211,240,0,0,127,255,208,0,47,255,223,252,0,0,127,255,208,0,191,255,211,255,0,0,42,191,208,2,255,159,208,255,192,0,0,31,208,11,254,31,208,127,240,0,0,31,208,63,248,31,208,31,252,0,0,31,209,255,240,31,208,7,254,0,0,31,219,255,128,31,208,2,255,128,0,31,211,254,0,31,208,0,191,64,0,31,208,244,0,31,208,0,61,0,0,31,208,80,0,31,208,0,4,0,0,31,208,0,0,31,208,0,0,0,0,31,208,0,0,31,208,0,0,0,0,31,208,0,0,31,208,0,0,0,0,31,208,0,0,31,208,0,0,0,0,31,208,0,0,31,208,0,0,0,0,191,240,0,0,31,208,0,0,0,3,255,253,0,0,31,208,0,0,0,15,255,255,208,0,0,0,0,0,0,63,244,127,254,80,0,0,1,90,224,255,208,15,255,255,255,255,255,255,208,127,128,2,255,255,255,255,255,255,192,47,0,0,31,255,255,255,255,255,192,12,0,0,0,90,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8fdb  进
  219,143,36,37,77,40,2,252,2,64,0,0,63,128,11,240,0,15,208,0,0,63,128,11,240,0,47,244,0,0,63,128,11,240,0,11,253,0,0,63,128,11,240,0,2,255,0,0,63,128,11,240,0,0,191,192,0,63,128,11,240,0,0,63,224,170,191,234,175,250,164,0,15,193,255,255,255,255,255,252,0,2,1,255,255,255,255,255,252,0,0,1,255,255,255,255,255,252,0,0,0,0,63,128,11,240,0,0,0,0,0,63,128,11,240,0,0,0,0,0,63,128,11,240,0,0,0,0,0,63,128,11,240,0,255,255,192,0,63,128,11,240,0,255,255,192,0,63,128,11,240,0,255,255,193,170,191,234,175,250,169,85,127,194,255,255,255,255,255,254,0,63,194,255,255,255,255,255,254,0,63,194,255,255,255,255,255,254,0,63,192,0,191,0,11,240,0,0,63,192,0,255,0,11,240,0,0,63,192,1,254,0,11,240,0,0,63,192,3,253,0,11,240,0,0,63,192,7,252,0,11,240,0,0,63,192,15,248,0,11,240,0,0,63,192,47,240,0,11,240,0,0,63,192,191,208,0,11,240,0,0,63,192,127,128,0,11,240,0,1,255,224,31,0,0,11,240,0,11,255,253,4,0,0,1,80,0,63,250,255,208,0,0,0,0,0,255,208,127,255,234,85,170,175,255,255,64,11,255,255,255,255,255,255,125,0,0,191,255,255,255,255,254,56,0,0,6,191,255,255,255,169,0,0,0,0,0,0,0,0,0,
  // 0x8fde  连
  222,143,38,39,134,40,1,251,0,0,0,0,2,144,0,0,0,0,1,240,0,0,3,253,0,0,0,0,7,252,0,0,3,252,0,0,0,0,2,255,0,0,11,248,0,0,0,0,0,255,128,255,255,255,255,255,255,0,0,63,208,255,255,255,255,255,255,0,0,31,240,255,255,255,255,255,255,0,0,11,244,0,127,192,0,0,0,0,0,3,208,0,127,64,0,0,0,0,0,1,0,0,255,1,253,0,0,0,0,0,0,1,254,1,253,0,0,0,0,0,0,3,252,1,253,0,0,0,0,0,0,7,248,1,253,0,0,0,0,0,0,15,240,1,253,0,0,0,63,255,208,63,255,255,255,255,248,0,63,255,208,63,255,255,255,255,248,0,63,255,208,31,255,255,255,255,248,0,21,111,208,14,149,86,254,85,84,0,0,15,208,0,0,1,253,0,0,0,0,15,208,0,0,1,253,0,0,0,0,15,208,0,0,1,253,0,0,0,0,15,208,0,0,1,253,0,0,0,0,15,208,170,170,170,254,170,170,64,0,15,209,255,255,255,255,255,255,64,0,15,209,255,255,255,255,255,255,64,0,15,209,255,255,255,255,255,255,64,0,15,208,0,0,1,253,0,0,0,0,15,208,0,0,1,253,0,0,0,0,15,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,191,240,0,0,1,253,0,0,0,3,255,253,0,0,1,253,0,0,0,15,255,255,208,0,1,253,0,0,0,63,244,127,254,80,0,0,5,90,224,191,208,15,255,255,255,255,255,255,208,127,128,2,255,255,255,255,255,255,192,31,0,0,31,255,255,255,255,255,192,9,0,0,0,90,170,170,170,85,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8ff7  迷
  247,143,38,37,114,40,1,252,1,64,0,0,0,15,224,0,0,0,7,224,0,6,0,15,224,0,224,0,31,252,0,63,128,15,224,2,253,0,11,255,0,47,192,15,224,3,252,0,1,255,192,15,224,15,224,7,244,0,0,63,240,11,240,15,224,15,240,0,0,15,248,3,248,15,224,31,208,0,0,7,224,3,252,15,224,63,192,0,0,1,128,1,253,15,224,127,64,0,0,0,0,0,244,15,224,126,0,0,0,0,0,0,64,15,224,0,0,0,0,0,0,0,0,15,224,0,0,0,0,0,2,255,255,255,255,255,255,128,0,0,2,255,255,255,255,255,255,128,0,0,2,255,255,255,255,255,255,128,63,255,240,85,86,255,255,85,85,0,63,255,240,0,2,255,255,64,0,0,63,255,240,0,3,255,255,192,0,0,21,95,240,0,15,255,255,224,0,0,0,15,240,0,47,223,231,244,0,0,0,15,240,0,127,143,227,253,0,0,0,15,240,1,255,15,224,255,0,0,0,15,240,7,253,15,224,127,208,0,0,15,240,31,248,15,224,47,244,0,0,15,240,191,240,15,224,15,254,0,0,15,243,255,192,15,224,3,255,192,0,15,242,255,0,15,224,0,255,64,0,15,240,184,0,15,224,0,45,0,0,15,240,32,0,15,224,0,4,0,0,127,252,0,0,15,224,0,0,0,2,255,255,64,0,15,224,0,0,0,15,255,191,244,0,0,0,0,0,0,127,252,47,255,250,170,170,170,171,208,63,224,11,255,255,255,255,255,255,192,47,128,0,191,255,255,255,255,255,128,13,0,0,6,191,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,
  // 0x9000  退
  0,144,38,37,114,40,1,252,0,64,0,0,0,0,0,0,0,0,3,224,0,3,255,255,255,255,208,0,15,252,0,3,255,255,255,255,208,0,7,255,64,3,255,255,255,255,208,0,0,255,208,3,248,0,0,15,208,0,0,63,244,3,248,0,0,15,208,0,0,15,252,3,248,0,0,15,208,0,0,3,240,3,255,255,255,255,208,0,0,0,128,3,255,255,255,255,208,0,0,0,0,3,255,255,255,255,208,0,0,0,0,3,248,0,0,15,208,0,0,0,0,3,248,0,0,15,208,0,0,0,0,3,248,0,0,15,208,0,0,0,0,3,255,255,255,255,208,0,0,0,0,3,255,255,255,255,208,0,63,255,240,3,255,255,255,255,224,0,63,255,240,3,248,7,244,0,120,0,63,255,240,3,248,3,248,1,255,0,21,95,240,3,248,1,252,11,255,0,0,15,240,3,248,0,254,63,244,0,0,15,240,3,248,0,191,255,192,0,0,15,240,3,248,0,63,253,0,0,0,15,240,3,248,0,47,240,0,0,0,15,240,3,248,0,15,248,0,0,0,15,240,3,248,27,231,255,0,0,0,15,240,3,255,255,241,255,208,0,0,15,240,111,255,255,240,127,253,0,0,15,240,191,255,254,64,31,255,192,0,15,240,127,254,64,0,7,255,0,0,127,252,62,64,0,0,0,125,0,2,255,255,64,0,0,0,0,4,0,15,255,191,244,0,0,0,0,0,0,127,252,47,255,250,170,170,170,171,208,63,224,11,255,255,255,255,255,255,192,47,128,0,191,255,255,255,255,255,128,13,0,0,6,191,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,
  // 0x9009  选
  9,144,37,39,134,40,2,251,0,0,0,0,0,10,144,0,0,0,0,0,0,0,0,15,224,0,0,0,15,0,0,3,248,15,224,0,0,0,127,208,0,3,248,15,224,0,0,0,63,244,0,7,244,15,224,0,0,0,15,253,0,15,240,31,224,0,0,0,3,255,0,31,255,255,255,255,244,0,0,255,192,63,255,255,255,255,244,0,0,63,192,127,255,255,255,255,244,0,0,30,0,255,0,15,224,0,0,0,0,0,3,253,0,15,224,0,0,0,0,0,1,252,0,15,224,0,0,0,0,0,0,32,0,15,224,0,0,0,0,0,0,0,0,15,224,0,0,0,0,0,3,255,255,255,255,255,255,0,0,0,3,255,255,255,255,255,255,0,255,255,67,255,255,255,255,255,255,0,255,255,64,0,47,224,127,128,0,0,255,255,64,0,47,192,63,128,0,0,85,191,64,0,63,192,63,128,0,0,0,63,64,0,63,192,63,128,0,0,0,63,64,0,127,128,63,128,0,0,0,63,64,0,191,64,63,128,0,0,0,63,64,0,255,0,63,128,52,0,0,63,64,3,254,0,63,128,63,64,0,63,64,11,252,0,63,128,63,64,0,63,64,47,244,0,63,128,63,0,0,63,65,255,224,0,63,213,191,0,0,63,79,255,128,0,63,255,254,0,0,63,67,253,0,0,47,255,253,0,0,63,225,224,0,0,11,255,244,0,0,255,253,0,0,0,0,0,0,0,11,255,255,128,0,0,0,0,0,0,47,253,127,254,64,0,0,5,90,64,255,224,11,255,255,255,255,255,255,0,191,128,1,255,255,255,255,255,255,0,62,0,0,27,255,255,255,255,254,0,8,0,0,0,5,85,85,85,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x901f  速
  31,144,38,38,124,40,1,252,0,0,0,0,0,11,224,0,0,0,1,128,0,0,0,15,224,0,0,0,11,240,0,0,0,15,224,0,0,0,31,253,0,0,0,15,224,0,0,0,7,255,64,255,255,255,255,255,255,128,0,255,208,255,255,255,255,255,255,128,0,63,244,255,255,255,255,255,255,128,0,15,248,0,0,15,240,0,0,0,0,3,208,0,0,15,224,0,0,0,0,1,64,0,0,15,224,0,0,0,0,0,0,47,255,255,255,255,252,0,0,0,0,47,255,255,255,255,252,0,0,0,0,47,255,255,255,255,252,0,0,0,0,47,128,15,224,2,252,0,0,0,0,47,128,15,224,2,252,0,0,0,0,47,128,15,224,2,252,0,63,255,240,47,128,15,224,2,252,0,63,255,240,47,128,15,224,2,252,0,63,255,240,47,255,255,255,255,252,0,21,95,240,47,255,255,255,255,252,0,0,15,240,47,255,255,255,255,252,0,0,15,240,0,0,255,254,0,0,0,0,15,240,0,3,255,255,128,0,0,0,15,240,0,15,255,255,224,0,0,0,15,240,0,63,223,231,252,0,0,0,15,240,1,255,79,225,255,64,0,0,15,240,11,253,15,224,127,240,0,0,15,240,127,244,15,224,31,254,0,0,15,242,255,208,15,224,7,255,128,0,15,240,255,0,15,224,0,254,0,0,127,252,52,0,15,224,0,28,0,2,255,255,64,0,15,224,0,0,0,15,255,191,244,0,0,0,0,0,0,127,252,47,255,250,170,170,170,171,208,63,224,11,255,255,255,255,255,255,192,47,128,0,191,255,255,255,255,255,128,13,0,0,6,191,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,
  // 0x90e8  部
  232,144,38,38,124,40,1,252,0,0,21,64,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,1,85,85,88,0,0,0,47,192,0,7,255,255,255,128,0,0,47,192,0,7,255,255,255,208,31,255,255,255,255,135,255,255,255,192,31,255,255,255,255,135,244,0,191,64,31,255,255,255,255,135,244,0,255,0,0,4,0,1,64,7,244,1,254,0,0,189,0,3,244,7,244,2,252,0,0,191,0,7,240,7,244,3,252,0,0,63,0,15,224,7,244,7,244,0,0,63,64,15,208,7,244,15,240,0,0,47,128,31,192,7,244,15,224,0,0,47,128,47,64,7,244,47,192,0,21,105,85,86,85,71,244,63,128,0,127,255,255,255,255,199,244,127,128,0,127,255,255,255,255,199,244,63,208,0,127,255,255,255,255,199,244,15,240,0,0,0,0,0,0,7,244,3,252,0,0,0,0,0,0,7,244,1,253,0,0,0,0,0,0,7,244,0,255,0,0,85,85,85,84,7,244,0,127,0,3,255,255,255,252,7,244,0,63,128,3,255,255,255,252,7,244,0,63,128,3,255,255,255,252,7,244,0,63,192,3,248,0,1,252,7,244,0,63,192,3,248,0,1,252,7,244,0,63,128,3,248,0,1,252,7,244,0,255,128,3,248,0,1,252,7,244,255,255,64,3,248,0,1,252,7,244,191,255,0,3,248,0,1,252,7,244,127,252,0,3,255,255,255,252,7,244,42,144,0,3,255,255,255,252,7,244,0,0,0,3,255,255,255,252,7,244,0,0,0,3,252,0,2,252,7,244,0,0,0,3,248,0,1,252,7,244,0,0,0,2,164,0,0,84,7,240,0,0,0,
  // 0x914d  配
  77,145,37,37,114,40,2,252,21,85,85,85,80,0,0,0,0,0,255,255,255,255,240,255,255,255,252,0,255,255,255,255,240,255,255,255,252,0,255,255,255,255,240,255,255,255,252,0,0,15,75,192,0,170,170,171,252,0,0,15,75,192,0,0,0,1,252,0,0,15,75,192,0,0,0,1,252,0,0,15,75,192,0,0,0,1,252,0,63,255,255,255,208,0,0,1,252,0,63,255,255,255,208,0,0,1,252,0,63,255,255,255,208,0,0,1,252,0,63,11,79,15,208,0,0,1,252,0,63,11,15,11,208,0,0,1,252,0,63,11,15,11,208,170,170,171,252,0,63,11,15,11,208,255,255,255,252,0,63,11,15,11,208,255,255,255,252,0,63,15,15,11,208,255,255,255,252,0,63,15,15,11,208,254,0,1,252,0,63,30,15,11,208,254,0,1,252,0,63,60,15,255,208,254,0,1,252,0,63,184,7,255,208,254,0,0,0,0,63,112,0,11,208,254,0,0,0,0,63,0,0,11,208,254,0,0,0,0,63,0,0,11,208,254,0,0,0,0,63,170,170,175,208,254,0,0,0,0,63,255,255,255,208,254,0,0,0,0,63,255,255,255,208,254,0,0,16,0,63,0,0,11,208,254,0,0,62,0,63,0,0,11,208,254,0,0,63,128,63,0,0,11,208,254,0,0,63,64,63,0,0,11,208,254,0,0,63,64,63,255,255,255,208,254,0,0,127,0,63,255,255,255,208,255,0,0,255,0,63,255,255,255,208,255,255,255,254,0,63,0,0,11,208,127,255,255,253,0,63,0,0,11,208,47,255,255,248,0,42,0,0,0,0,1,85,85,64,0,
  // 0x91ca  释
  202,145,38,37,114,40,1,252,0,0,5,189,0,0,0,0,0,0,1,107,255,255,47,255,255,255,254,0,63,255,255,254,47,255,255,255,255,128,63,255,253,0,47,255,255,255,255,0,26,151,248,0,6,253,85,86,254,0,0,3,248,0,0,253,0,7,252,0,11,3,248,31,64,127,0,15,240,0,31,131,248,63,64,63,192,63,208,0,15,195,248,63,0,15,241,255,64,0,7,227,248,189,0,7,255,253,0,0,3,243,248,252,0,2,255,248,0,0,2,243,249,240,0,1,255,240,0,0,0,3,248,0,0,31,255,253,0,0,0,3,248,0,1,255,255,255,208,0,63,255,255,254,111,255,208,255,254,64,63,255,255,255,255,253,0,31,255,224,63,255,255,254,255,208,0,2,255,192,0,11,252,0,56,0,127,64,27,64,0,15,255,0,0,0,127,64,0,0,0,47,255,192,0,0,127,64,0,0,0,63,255,240,15,255,255,255,252,0,0,191,251,252,15,255,255,255,252,0,1,255,249,255,15,255,255,255,252,0,3,247,248,127,5,85,127,149,84,0,11,243,248,44,0,0,127,64,0,0,31,211,248,4,0,0,127,64,0,0,63,195,248,0,0,0,127,64,0,0,127,67,248,0,255,255,255,255,255,192,63,3,248,0,255,255,255,255,255,192,28,3,248,0,255,255,255,255,255,192,4,3,248,0,85,85,191,149,85,64,0,3,248,0,0,0,127,64,0,0,0,3,248,0,0,0,127,64,0,0,0,3,248,0,0,0,127,64,0,0,0,3,248,0,0,0,127,64,0,0,0,3,248,0,0,0,127,64,0,0,0,2,248,0,0,0,127,64,0,0,
  // 0x91cd  重
  205,145,36,37,77,40,2,253,0,0,0,0,0,0,21,180,0,0,0,0,85,170,255,255,252,0,1,255,255,255,255,255,255,254,0,0,255,255,255,255,255,250,80,0,0,255,255,255,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,106,170,170,255,170,170,169,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,0,254,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,85,85,255,85,85,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,0,254,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,170,170,255,170,170,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x91cf  量
  207,145,36,36,68,40,2,253,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,192,0,0,0,3,252,0,0,63,128,0,0,0,3,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,128,0,0,0,3,252,0,0,63,128,0,0,0,3,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,0,255,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,0,255,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,1,170,170,170,255,170,170,170,64,2,255,255,255,255,255,255,255,128,2,255,255,255,255,255,255,255,128,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x9488  针
  136,148,37,38,124,40,1,252,0,9,0,0,0,0,42,64,0,0,0,15,208,0,0,0,63,128,0,0,0,47,192,0,0,0,63,128,0,0,0,63,128,0,0,0,63,128,0,0,0,191,149,85,0,0,63,128,0,0,1,255,255,255,0,0,63,128,0,0,3,255,255,255,0,0,63,128,0,0,15,255,255,255,0,0,63,128,0,0,47,240,0,0,0,0,63,128,0,0,127,192,0,0,0,0,63,128,0,0,127,128,0,0,0,0,63,128,0,0,63,0,0,0,0,0,63,128,0,0,30,255,255,252,0,0,63,128,0,0,2,255,255,252,255,255,255,255,255,192,2,255,255,252,255,255,255,255,255,192,0,3,248,0,255,255,255,255,255,192,0,3,248,0,255,255,255,255,255,192,0,3,248,0,0,0,63,128,0,0,0,3,248,0,0,0,63,128,0,0,0,3,248,0,0,0,63,128,0,0,31,255,255,254,0,0,63,128,0,0,31,255,255,254,0,0,63,128,0,0,31,255,255,254,0,0,63,128,0,0,5,87,253,84,0,0,63,128,0,0,0,3,248,0,0,0,63,128,0,0,0,3,248,0,0,0,63,128,0,0,0,3,248,0,0,0,63,128,0,0,0,3,248,0,0,0,63,128,0,0,0,3,248,0,0,0,63,128,0,0,0,3,248,7,64,0,63,128,0,0,0,3,248,127,64,0,63,128,0,0,0,3,255,255,128,0,63,128,0,0,0,3,255,255,0,0,63,128,0,0,0,15,255,244,0,0,63,128,0,0,0,47,255,64,0,0,63,128,0,0,0,15,244,0,0,0,63,128,0,0,0,11,128,0,0,0,63,128,0,0,0,1,0,0,0,0,42,128,0,0,
  // 0x94ae  钮
  174,148,38,38,124,40,1,252,0,36,0,0,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,0,191,0,0,191,255,255,255,254,0,0,255,0,0,191,255,255,255,254,0,1,253,0,0,191,255,255,255,254,0,2,255,255,253,85,91,249,85,253,0,3,255,255,253,0,7,244,0,253,0,11,255,255,253,0,7,240,0,253,0,31,208,0,0,0,11,240,1,253,0,63,192,0,0,0,11,240,1,252,0,191,64,0,0,0,15,240,1,252,0,127,0,0,0,0,15,240,2,252,0,63,255,255,244,0,15,224,2,252,0,23,255,255,244,0,15,224,2,252,0,3,255,255,244,0,15,208,2,252,0,1,91,245,80,0,15,208,3,252,0,0,7,240,0,127,255,255,255,248,0,0,7,240,0,127,255,255,255,248,0,0,7,240,0,127,255,255,255,248,0,0,7,240,0,106,191,234,171,248,0,63,255,255,253,0,63,192,3,244,0,63,255,255,253,0,63,128,3,244,0,63,255,255,253,0,63,128,7,244,0,21,91,245,84,0,63,64,7,240,0,0,7,240,0,0,127,64,11,240,0,0,7,240,0,0,127,0,11,240,0,0,7,240,0,0,191,0,11,240,0,0,7,240,0,0,191,0,15,240,0,0,7,240,4,0,255,0,15,224,0,0,7,240,184,0,254,0,15,224,0,0,7,247,252,0,253,0,15,224,0,0,7,255,252,1,253,0,15,208,0,0,11,255,224,1,252,0,31,208,0,0,15,255,95,255,255,255,255,255,208,0,63,248,31,255,255,255,255,255,208,0,127,192,31,255,255,255,255,255,208,0,30,0,26,170,170,170,170,170,128,0,4,0,0,0,0,0,0,0,0,
  // 0x9519  错
  25,149,37,38,124,40,1,252,0,8,0,0,0,190,0,127,0,0,0,31,192,0,0,190,0,127,0,0,0,63,128,0,0,190,0,127,0,0,0,127,64,0,0,190,0,127,0,0,0,255,0,0,0,190,0,127,0,0,1,255,255,252,127,255,255,255,255,64,3,255,255,252,127,255,255,255,255,64,11,255,255,252,127,255,255,255,255,64,31,250,170,168,0,191,0,191,0,0,127,192,0,0,0,190,0,127,0,0,127,64,0,0,0,190,0,127,0,0,47,0,0,0,0,190,0,127,0,0,30,255,255,248,0,190,0,127,0,0,2,255,255,248,85,255,85,191,85,64,2,255,255,249,255,255,255,255,255,192,0,91,245,81,255,255,255,255,255,192,0,3,240,1,255,255,255,255,255,192,0,3,240,0,0,0,0,0,0,0,0,3,240,0,0,0,0,0,0,0,0,3,240,0,0,0,0,0,0,0,31,255,255,253,15,255,255,255,248,0,31,255,255,253,15,255,255,255,248,0,31,255,255,253,15,255,255,255,248,0,5,87,245,84,15,208,0,2,248,0,0,3,240,0,15,208,0,2,248,0,0,3,240,0,15,208,0,2,248,0,0,3,240,0,15,255,255,255,248,0,0,3,240,0,15,255,255,255,248,0,0,3,240,0,15,255,255,255,248,0,0,3,240,40,15,208,0,2,248,0,0,3,246,252,15,208,0,2,248,0,0,7,255,252,15,208,0,2,248,0,0,11,255,248,15,208,0,2,248,0,0,31,255,128,15,255,255,255,248,0,0,63,252,0,15,255,255,255,248,0,0,31,208,0,15,255,255,255,248,0,0,14,0,0,15,208,0,2,248,0,0,0,0,0,10,144,0,1,84,0,
  // 0x955c  镜
  92,149,38,38,124,40,1,252,0,4,0,0,0,0,109,0,0,0,0,47,192,0,0,0,255,0,0,0,0,63,192,0,0,0,127,64,0,0,0,127,64,0,63,255,255,255,255,0,0,255,85,80,63,255,255,255,255,0,1,255,255,248,63,255,255,255,255,0,3,255,255,248,0,108,0,10,64,0,11,255,255,248,0,253,0,47,192,0,31,240,0,0,0,191,0,63,128,0,127,192,0,0,0,63,0,127,0,0,127,128,0,1,255,255,255,255,255,192,63,0,0,1,255,255,255,255,255,192,31,255,255,241,255,255,255,255,255,192,2,255,255,240,0,0,0,0,0,0,2,255,255,240,0,0,0,0,0,0,0,91,245,80,47,255,255,255,253,0,0,11,240,0,47,255,255,255,253,0,0,11,240,0,47,213,85,85,253,0,0,11,240,0,47,128,0,0,253,0,0,11,240,0,47,128,0,0,253,0,47,255,255,252,47,255,255,255,253,0,47,255,255,252,47,255,255,255,253,0,47,255,255,252,47,213,85,85,253,0,5,91,245,84,47,128,0,0,253,0,0,11,240,0,47,213,85,85,253,0,0,11,240,0,47,255,255,255,253,0,0,11,240,0,47,255,255,255,253,0,0,11,240,0,0,63,65,252,0,0,0,11,240,24,0,127,1,252,0,0,0,11,241,252,0,127,1,252,0,0,0,11,251,252,0,255,1,252,0,0,0,15,255,252,1,254,1,252,7,208,0,31,255,208,7,252,1,252,7,224,0,63,254,0,47,244,1,252,11,208,0,127,244,11,255,224,1,255,191,192,0,63,128,15,255,64,0,255,255,192,0,29,0,7,248,0,0,127,255,0,0,0,0,2,64,0,0,0,0,0,
  // 0x957f  长
  127,149,36,38,86,40,2,252,0,0,169,0,0,0,0,0,0,0,1,253,0,0,0,0,208,0,0,1,253,0,0,0,3,253,0,0,1,253,0,0,0,15,253,0,0,1,253,0,0,0,127,244,0,0,1,253,0,0,2,255,208,0,0,1,253,0,0,15,255,64,0,0,1,253,0,0,191,252,0,0,0,1,253,0,7,255,224,0,0,0,1,253,0,127,255,64,0,0,0,1,253,7,255,252,0,0,0,0,1,253,11,255,208,0,0,0,0,1,253,2,254,0,0,0,0,0,1,253,0,160,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,106,171,255,170,191,234,170,170,169,0,1,253,0,31,208,0,0,0,0,1,253,0,15,240,0,0,0,0,1,253,0,7,248,0,0,0,0,1,253,0,3,252,0,0,0,0,1,253,0,1,255,0,0,0,0,1,253,0,0,255,128,0,0,0,1,253,0,0,127,224,0,0,0,1,253,0,0,47,248,0,0,0,1,253,0,0,15,254,0,0,0,1,253,0,0,3,255,208,0,0,1,253,0,27,128,255,248,0,0,1,253,27,255,128,63,255,128,0,2,255,255,255,192,11,255,253,0,7,255,255,255,128,1,255,255,0,15,255,255,144,0,0,47,253,0,7,255,144,0,0,0,2,248,0,3,228,0,0,0,0,0,16,0,1,0,0,0,0,0,0,0,
  // 0x95ed  闭
  237,149,34,37,77,40,3,252,7,128,0,0,0,0,0,0,0,47,224,1,85,85,85,85,85,80,15,248,3,255,255,255,255,255,224,7,253,3,255,255,255,255,255,224,1,255,3,255,255,255,255,255,224,0,191,128,0,0,0,0,15,224,0,62,0,0,0,0,0,15,224,0,4,0,0,2,252,0,15,224,21,0,0,0,3,252,0,15,224,191,0,0,0,3,252,0,15,224,191,0,0,0,3,252,0,15,224,191,0,0,0,3,252,0,15,224,191,2,170,170,171,254,170,15,224,191,3,255,255,255,255,255,15,224,191,3,255,255,255,255,255,15,224,191,3,255,255,255,255,255,15,224,191,0,0,0,127,252,0,15,224,191,0,0,0,255,252,0,15,224,191,0,0,3,255,252,0,15,224,191,0,0,15,255,252,0,15,224,191,0,0,63,243,252,0,15,224,191,0,0,255,195,252,0,15,224,191,0,3,255,67,252,0,15,224,191,0,31,253,3,252,0,15,224,191,0,191,244,3,252,0,15,224,191,7,255,192,3,252,0,15,224,191,47,254,0,3,252,0,15,224,191,15,244,0,3,252,0,15,224,191,3,128,0,3,252,0,15,224,191,0,0,26,171,252,0,15,224,191,0,0,31,255,248,0,15,224,191,0,0,15,255,244,0,15,224,191,0,0,11,254,128,0,15,224,191,0,0,0,0,0,47,255,224,191,0,0,0,0,0,31,255,208,191,0,0,0,0,0,15,255,64,106,0,0,0,0,0,5,80,0,
  // 0x95f2  闲
  242,149,34,37,77,40,3,252,3,208,0,0,0,0,0,0,0,15,240,2,255,255,255,255,255,224,7,252,2,255,255,255,255,255,224,2,255,2,255,255,255,255,255,224,0,191,193,85,85,85,85,95,224,0,63,224,0,0,0,0,15,224,0,15,240,0,0,0,0,15,224,0,7,208,0,0,0,0,15,224,170,2,0,2,248,0,0,15,224,254,0,0,2,248,0,0,15,224,254,0,0,2,248,0,0,15,224,254,0,0,2,248,0,0,15,224,254,0,0,2,248,0,0,15,224,254,7,255,255,255,255,255,15,224,254,7,255,255,255,255,255,15,224,254,7,255,255,255,255,255,15,224,254,0,0,31,255,64,0,15,224,254,0,0,63,255,192,0,15,224,254,0,0,127,255,240,0,15,224,254,0,0,255,255,252,0,15,224,254,0,2,255,250,254,0,15,224,254,0,7,246,248,255,128,15,224,254,0,31,226,248,63,208,15,224,254,0,127,194,248,15,240,15,224,254,1,255,66,248,7,252,15,224,254,7,254,2,248,2,254,15,224,254,31,248,2,248,0,252,15,224,254,11,224,2,248,0,112,15,224,254,3,128,2,248,0,0,15,224,254,0,0,2,248,0,0,15,224,254,0,0,2,248,0,0,15,224,254,0,0,2,248,0,0,15,224,254,0,0,2,248,0,0,15,224,254,0,0,1,84,2,255,255,224,254,0,0,0,0,1,255,255,192,254,0,0,0,0,0,255,255,64,254,0,0,0,0,0,106,148,0,
  // 0x95f4  间
  244,149,34,37,77,40,3,252,7,128,0,0,0,0,0,0,0,47,224,1,85,85,85,85,85,80,15,248,3,255,255,255,255,255,224,7,253,3,255,255,255,255,255,224,1,255,3,255,255,255,255,255,224,0,191,128,0,0,0,0,15,224,0,62,0,0,0,0,0,15,224,0,20,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,191,64,0,0,0,0,0,15,224,191,64,0,0,0,0,0,15,224,191,64,47,255,255,255,192,15,224,191,64,47,255,255,255,192,15,224,191,64,47,255,255,255,192,15,224,191,64,47,128,0,47,192,15,224,191,64,47,128,0,47,192,15,224,191,64,47,128,0,47,192,15,224,191,64,47,128,0,47,192,15,224,191,64,47,128,0,47,192,15,224,191,64,47,255,255,255,192,15,224,191,64,47,255,255,255,192,15,224,191,64,47,255,255,255,192,15,224,191,64,47,128,0,47,192,15,224,191,64,47,128,0,47,192,15,224,191,64,47,128,0,47,192,15,224,191,64,47,128,0,47,192,15,224,191,64,47,128,0,47,192,15,224,191,64,47,255,255,255,192,15,224,191,64,47,255,255,255,192,15,224,191,64,47,255,255,255,192,15,224,191,64,0,0,0,0,0,15,224,191,64,0,0,0,0,0,15,224,191,64,0,0,0,0,0,15,224,191,64,0,0,0,0,15,255,224,191,64,0,0,0,0,11,255,208,191,64,0,0,0,0,7,255,64,106,0,0,0,0,0,1,64,0,
  // 0x9608  阈
  8,150,34,38,86,40,3,252,0,144,0,0,0,0,0,0,0,3,240,0,85,85,85,85,85,64,7,252,2,255,255,255,255,255,208,2,255,2,255,255,255,255,255,208,0,255,130,255,255,255,255,255,208,0,63,208,0,0,0,0,15,208,0,31,240,0,0,0,0,15,208,0,11,244,0,31,130,0,15,208,0,3,192,0,31,143,192,15,208,191,0,0,0,31,139,240,15,208,191,0,0,0,31,130,244,15,208,191,0,0,0,15,128,128,15,208,191,15,255,255,255,255,255,15,208,191,15,255,255,255,255,255,15,208,191,15,255,255,255,255,255,15,208,191,0,0,0,15,192,0,15,208,191,0,0,0,15,192,144,15,208,191,3,255,255,15,192,252,15,208,191,3,255,255,11,193,248,15,208,191,3,224,31,11,210,240,15,208,191,3,224,31,7,211,240,15,208,191,3,224,31,7,231,224,15,208,191,3,224,31,3,255,192,15,208,191,3,255,255,3,255,128,15,208,191,3,255,255,3,255,0,15,208,191,0,0,0,2,254,0,15,208,191,0,0,0,1,253,11,15,208,191,0,0,107,194,252,11,143,208,191,6,255,255,199,254,15,143,208,191,15,255,255,223,255,79,79,208,191,15,255,144,127,175,255,15,208,191,10,64,1,254,15,254,15,208,191,0,0,3,248,3,252,15,208,191,0,0,0,224,0,80,31,208,191,0,0,0,0,1,255,255,208,191,0,0,0,0,0,255,255,192,191,0,0,0,0,0,191,254,0,106,0,0,0,0,0,20,0,0,
  // 0x964d  降
  77,150,36,38,86,40,3,252,0,0,0,0,0,148,0,0,0,0,0,0,0,1,254,0,0,0,191,255,248,0,3,252,0,0,0,191,255,255,0,7,248,0,0,0,191,255,254,0,15,255,255,254,0,190,86,253,0,63,255,255,255,64,190,1,252,0,255,255,255,255,0,190,3,248,3,255,64,1,253,0,190,3,244,15,255,192,3,252,0,190,7,240,127,255,240,15,244,0,190,11,224,255,135,248,63,208,0,190,15,208,61,1,255,255,128,0,190,31,192,4,0,191,254,0,0,190,47,128,0,0,63,252,0,0,190,63,64,0,1,255,255,128,0,190,31,192,0,31,255,255,248,0,190,11,240,6,255,248,47,255,228,190,3,244,191,255,192,7,255,253,190,2,252,191,253,0,254,111,248,190,0,252,63,128,0,254,1,176,190,0,253,20,0,0,254,0,0,190,0,253,31,255,255,255,255,224,190,0,254,31,255,255,255,255,224,190,0,253,31,255,255,255,255,224,190,1,253,0,254,0,254,0,0,190,191,252,0,254,0,254,0,0,190,63,248,0,254,0,254,0,0,190,63,208,0,254,0,254,0,0,190,0,0,0,254,0,254,0,0,190,0,1,255,255,255,255,255,252,190,0,1,255,255,255,255,255,252,190,0,1,255,255,255,255,255,252,190,0,0,0,0,0,254,0,0,190,0,0,0,0,0,254,0,0,190,0,0,0,0,0,254,0,0,190,0,0,0,0,0,254,0,0,190,0,0,0,0,0,254,0,0,189,0,0,0,0,0,254,0,0,
  // 0x9650  限
  80,150,35,36,68,40,3,252,191,255,254,7,255,255,255,255,192,191,255,255,199,255,255,255,255,192,191,255,255,135,255,255,255,255,192,191,85,191,7,244,0,0,63,192,191,0,191,7,244,0,0,63,192,191,0,254,7,244,0,0,63,192,191,1,252,7,244,0,0,63,192,191,2,252,7,244,0,0,63,192,191,3,244,7,255,255,255,255,192,191,3,240,7,255,255,255,255,192,191,11,224,7,255,255,255,255,192,191,15,208,7,244,0,0,63,192,191,31,192,7,244,0,0,63,192,191,15,240,7,244,0,0,63,192,191,3,248,7,244,0,0,63,192,191,1,252,7,255,255,255,255,192,191,0,254,7,255,255,255,255,192,191,0,127,7,255,255,255,255,192,191,0,63,7,244,15,208,0,0,191,0,63,71,244,11,224,3,64,191,0,63,71,244,7,240,15,224,191,0,63,71,244,3,244,47,240,191,0,127,71,244,2,248,255,192,191,21,255,7,244,1,255,255,0,191,63,255,7,244,0,255,248,0,191,47,253,7,244,0,191,208,0,191,31,224,7,244,0,63,192,0,191,0,0,7,244,0,47,224,0,191,0,0,7,244,0,15,248,0,191,0,0,7,245,111,199,253,0,191,0,0,11,255,255,195,255,64,191,0,6,255,255,255,208,255,224,191,0,7,255,255,249,0,63,252,191,0,3,255,249,0,0,15,248,191,0,2,249,0,0,0,2,240,190,0,0,0,0,0,0,0,64,
  // 0x9664  除
  100,150,36,38,86,40,3,252,0,0,0,0,0,42,64,0,0,0,0,0,0,0,191,208,0,0,191,255,248,0,1,255,240,0,0,191,255,255,0,3,255,252,0,0,191,255,254,0,15,246,254,0,0,190,86,253,0,47,224,255,128,0,190,1,252,0,191,192,63,224,0,190,3,248,2,255,0,15,248,0,190,3,244,11,252,0,7,255,0,190,7,240,47,240,0,0,255,208,190,11,225,255,192,0,0,63,248,190,15,219,255,0,0,0,15,254,190,31,195,255,255,255,255,255,252,190,47,129,226,255,255,255,248,116,190,63,128,66,255,255,255,248,0,190,31,192,0,0,63,128,0,0,190,11,240,0,0,63,128,0,0,190,3,244,0,0,63,128,0,0,190,2,252,0,0,63,128,0,0,190,0,252,0,0,63,192,0,0,190,0,253,63,255,255,255,255,224,190,0,253,63,255,255,255,255,224,190,0,254,63,255,255,255,255,224,190,0,253,0,0,63,128,0,0,190,1,253,0,0,63,128,0,0,190,191,252,7,224,63,129,244,0,190,63,248,15,240,63,130,252,0,190,63,208,15,208,63,128,255,0,190,0,0,63,192,63,128,127,64,190,0,0,127,64,63,128,63,192,190,0,0,255,0,63,128,31,224,190,0,2,253,0,63,128,11,240,190,0,7,252,0,63,128,3,248,190,0,15,240,0,63,128,3,252,190,0,3,208,21,127,128,1,224,190,0,0,64,63,255,128,0,0,190,0,0,0,31,255,0,0,0,190,0,0,0,15,248,0,0,0,
  // 0x9669  险
  105,150,36,38,86,40,3,252,0,0,0,0,0,14,0,0,0,0,0,0,0,0,47,192,0,0,191,255,248,0,0,127,192,0,0,191,255,255,0,0,255,208,0,0,191,255,254,0,2,255,244,0,0,190,86,253,0,7,255,253,0,0,190,1,252,0,15,241,255,64,0,190,3,248,0,63,208,127,208,0,190,3,244,0,255,128,47,244,0,190,7,240,2,255,0,11,254,0,190,11,224,11,252,0,2,255,128,190,15,208,63,240,0,0,191,244,190,31,193,255,208,0,0,47,254,190,47,135,255,255,255,255,231,254,190,47,131,252,255,255,255,224,252,190,15,209,240,255,255,255,224,40,190,7,240,64,0,0,0,0,0,190,3,248,0,0,0,0,0,0,190,1,252,0,0,0,0,0,0,190,0,252,0,64,47,64,11,208,190,0,253,15,192,31,128,15,224,190,0,190,15,192,31,128,31,192,190,0,190,11,224,15,192,47,128,190,0,254,7,240,15,192,63,64,190,1,253,3,240,11,208,127,0,190,127,252,2,244,11,208,253,0,190,63,248,2,248,7,224,252,0,190,63,224,1,252,7,242,248,0,190,0,0,0,252,2,67,240,0,190,0,0,0,224,0,7,224,0,190,0,0,0,0,0,15,192,0,190,0,0,0,0,0,31,128,0,190,0,0,85,85,85,127,85,84,190,0,0,255,255,255,255,255,252,190,0,0,255,255,255,255,255,252,190,0,0,255,255,255,255,255,252,190,0,0,0,0,0,0,0,0,105,0,0,0,0,0,0,0,0,
  // 0x96f6  零
  246,150,37,36,104,40,2,252,2,255,255,255,255,255,255,255,64,0,2,255,255,255,255,255,255,255,64,0,1,255,255,255,255,255,255,255,64,0,0,0,0,0,254,0,0,0,0,0,21,85,85,85,255,85,85,85,84,0,63,255,255,255,255,255,255,255,252,0,63,255,255,255,255,255,255,255,252,0,63,64,0,0,254,0,0,1,252,0,63,64,0,0,254,0,0,1,252,0,63,79,255,244,254,47,255,241,252,0,63,79,255,244,254,47,255,241,252,0,63,0,0,0,254,0,0,1,252,0,0,0,0,0,254,0,0,0,0,0,0,63,255,244,84,47,255,252,0,0,0,63,255,251,255,111,255,252,0,0,0,0,0,31,255,224,0,0,0,0,0,0,0,191,255,253,0,0,0,0,0,0,7,255,131,255,208,0,0,0,0,0,127,253,0,191,253,0,0,0,0,11,255,240,0,15,255,228,0,0,1,255,255,234,170,171,255,255,144,0,191,255,231,255,255,255,219,255,255,64,255,253,3,255,255,255,208,127,255,0,127,144,0,0,0,0,0,1,253,0,36,0,0,0,0,0,0,0,4,0,0,255,255,255,255,255,255,248,0,0,0,255,255,255,255,255,255,248,0,0,0,106,170,191,234,170,171,248,0,0,0,0,0,31,192,0,3,248,0,0,0,0,0,31,192,0,3,248,0,0,0,0,0,31,192,0,3,248,0,0,0,0,0,31,192,11,255,244,0,0,0,0,0,31,192,7,255,240,0,0,0,0,0,31,192,3,254,64,0,0,0,0,0,31,192,0,0,0,0,0,0,0,0,31,192,0,0,0,0,0,
  // 0x9700  需
  0,151,36,36,68,40,2,252,2,255,255,255,255,255,255,255,64,2,255,255,255,255,255,255,255,64,2,255,255,255,255,255,255,255,64,0,0,0,0,254,0,0,0,0,42,170,170,170,255,170,170,170,168,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,64,0,0,254,0,0,1,252,63,64,0,0,254,0,0,1,252,63,79,255,244,254,47,255,241,252,63,79,255,244,254,47,255,241,252,63,69,85,80,254,5,85,81,252,21,0,0,0,254,0,0,0,84,0,21,85,80,254,5,85,84,0,0,63,255,244,254,47,255,252,0,0,63,255,244,254,47,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,0,0,0,1,253,0,0,0,0,0,0,0,2,252,0,0,0,0,1,255,255,255,255,255,255,255,208,1,255,255,255,255,255,255,255,208,1,255,255,255,255,255,255,255,208,1,252,0,254,0,63,64,31,208,1,252,0,254,0,63,64,31,208,1,252,0,254,0,63,64,31,208,1,252,0,254,0,63,64,31,208,1,252,0,254,0,63,64,31,208,1,252,0,254,0,63,64,31,208,1,252,0,254,0,63,64,31,208,1,252,0,254,0,63,79,255,192,1,252,0,254,0,63,71,255,192,1,252,0,169,0,42,3,254,0,
  // 0x9752  青
  82,151,36,39,95,40,2,251,0,0,0,0,170,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,191,255,255,255,255,255,254,0,0,191,255,255,255,255,255,254,0,0,106,170,170,255,170,170,170,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,224,0,0,0,7,244,0,0,15,224,0,0,0,7,244,0,0,15,250,170,170,170,171,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,224,0,0,0,7,244,0,0,15,224,0,0,0,7,244,0,0,15,224,0,0,0,7,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,250,170,170,170,171,244,0,0,15,224,0,0,0,7,244,0,0,15,224,0,0,0,7,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,127,255,244,0,0,15,224,0,0,63,255,240,0,0,15,224,0,0,47,254,64,0,0,0,0,0,0,0,0,0,0,
  // 0x975e  非
  94,151,38,39,134,40,1,251,0,0,0,170,0,10,144,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,15,255,255,255,0,31,255,255,255,128,15,255,255,255,0,31,255,255,255,128,15,255,255,255,0,31,255,255,255,128,5,85,85,255,0,31,229,85,85,64,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,7,255,255,255,0,31,255,255,254,0,7,255,255,255,0,31,255,255,254,0,7,255,255,255,0,31,255,255,254,0,1,85,85,255,0,31,229,85,85,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,254,0,31,208,0,0,0,0,0,0,254,84,31,208,0,0,0,0,0,6,255,252,31,208,0,0,0,0,107,255,255,252,31,229,85,85,64,127,255,255,255,252,31,255,255,255,208,63,255,255,253,0,31,255,255,255,208,63,255,159,244,0,31,255,255,255,208,41,64,31,240,0,31,208,0,0,0,0,0,63,208,0,31,208,0,0,0,0,0,191,192,0,31,208,0,0,0,0,2,255,0,0,31,208,0,0,0,0,11,254,0,0,31,208,0,0,0,0,63,248,0,0,31,208,0,0,0,2,255,224,0,0,31,208,0,0,0,15,255,128,0,0,31,208,0,0,0,3,253,0,0,0,31,208,0,0,0,0,224,0,0,0,15,208,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9760  靠
  96,151,36,39,95,40,2,251,0,2,80,0,254,0,0,0,0,0,11,240,0,254,0,0,0,0,0,31,245,85,255,85,85,85,0,0,63,255,255,255,255,255,255,64,0,191,255,255,255,255,255,255,64,2,254,0,0,254,0,0,0,0,3,252,0,0,254,0,0,0,0,42,254,170,170,255,170,170,170,168,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,0,0,0,0,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,255,0,0,63,255,255,255,255,255,255,0,0,63,149,85,85,85,85,255,0,0,63,64,0,0,0,0,255,0,0,63,64,0,0,0,0,255,0,0,63,255,255,255,255,255,255,0,0,63,255,255,255,255,255,255,0,0,21,86,253,85,191,149,85,0,0,0,1,252,0,63,64,0,0,63,255,255,252,0,63,255,255,252,63,255,255,252,0,63,255,255,252,21,85,86,252,0,63,149,85,84,0,0,1,252,0,63,64,0,0,5,85,86,252,0,63,149,85,80,15,255,255,252,0,63,255,255,244,15,255,255,252,0,63,255,255,244,0,0,2,252,0,63,64,0,0,0,0,6,252,0,63,64,0,0,255,255,255,248,0,63,255,255,255,255,255,255,244,0,63,255,255,255,169,84,31,240,0,63,234,170,170,0,0,191,192,0,63,64,0,0,0,31,255,64,0,63,64,0,0,3,255,252,0,0,63,64,0,0,1,255,208,0,0,63,64,0,0,0,184,0,0,0,42,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9762  面
  98,151,36,35,59,40,2,252,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,106,170,170,171,255,170,170,170,169,0,0,0,3,253,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,244,0,0,0,0,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,245,91,245,85,111,213,95,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,255,255,255,192,15,240,15,224,7,255,255,255,192,15,240,15,224,7,255,255,255,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,255,255,255,192,15,240,15,224,7,255,255,255,192,15,240,15,224,7,255,255,255,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,245,85,85,85,85,85,95,240,15,224,0,0,0,0,0,15,240,10,160,0,0,0,0,0,10,160,
  // 0x9875  页
  117,152,36,36,68,40,2,252,21,85,85,85,85,85,85,85,84,63,255,255,255,255,255,255,255,253,63,255,255,255,255,255,255,255,253,63,255,255,255,255,255,255,255,253,0,0,0,3,253,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,127,255,255,255,255,255,255,0,0,127,255,255,255,255,255,255,0,0,127,255,255,255,255,255,255,0,0,127,149,85,85,85,86,255,0,0,127,64,0,0,0,0,255,0,0,127,64,0,85,0,0,255,0,0,127,64,0,255,0,0,255,0,0,127,64,0,255,0,0,255,0,0,127,64,0,255,0,0,255,0,0,127,64,0,255,0,0,255,0,0,127,64,0,255,0,0,255,0,0,127,64,0,255,0,0,255,0,0,127,64,0,255,0,0,255,0,0,127,64,0,255,0,0,255,0,0,127,64,0,255,0,0,255,0,0,127,64,0,255,0,0,255,0,0,127,64,1,254,0,0,255,0,0,127,64,3,253,0,0,255,0,0,127,64,15,252,62,0,255,0,0,0,0,47,244,255,240,0,0,0,0,0,255,224,191,254,0,0,0,0,11,255,128,11,255,224,0,0,1,191,253,0,0,191,254,0,0,111,255,244,0,0,11,255,208,111,255,255,64,0,0,1,255,248,127,255,244,0,0,0,0,31,252,47,253,0,0,0,0,0,3,240,10,64,0,0,0,0,0,0,80,
  // 0x9879  项
  121,152,37,36,104,40,1,252,0,0,0,11,255,255,255,255,255,192,0,0,0,11,255,255,255,255,255,192,0,0,0,11,255,255,255,255,255,192,63,255,255,230,170,171,253,85,85,64,63,255,255,224,0,7,252,0,0,0,63,255,255,224,0,15,244,0,0,0,0,31,208,0,0,15,240,0,0,0,0,31,208,1,255,255,255,255,252,0,0,31,208,1,255,255,255,255,252,0,0,31,208,1,255,255,255,255,252,0,0,31,208,1,253,85,85,87,252,0,0,31,208,1,252,0,0,3,252,0,0,31,208,1,252,1,168,3,252,0,0,31,208,1,252,2,252,3,252,0,0,31,208,1,252,2,252,3,252,0,0,31,208,1,252,2,252,3,252,0,0,31,208,1,252,2,252,3,252,0,0,31,208,1,252,2,252,3,252,0,0,31,208,1,252,2,252,3,252,0,0,31,208,1,252,2,252,3,252,0,0,31,208,17,252,2,252,3,252,0,0,31,231,241,252,2,252,3,252,0,0,31,255,241,252,3,252,3,252,0,1,191,255,245,252,3,252,3,252,0,127,255,255,65,252,3,248,3,252,0,191,255,224,1,252,11,244,3,252,0,127,248,0,0,0,15,240,0,0,0,62,64,0,0,0,47,224,240,0,0,16,0,0,0,0,191,195,253,0,0,0,0,0,0,3,255,67,255,192,0,0,0,0,0,47,253,0,191,244,0,0,0,0,2,255,244,0,15,254,0,0,0,0,127,255,192,0,2,255,192,0,0,0,255,253,0,0,0,127,192,0,0,0,63,208,0,0,0,31,0,0,0,0,24,0,0,0,0,0,0,
  // 0x9884  预
  132,152,38,36,104,40,1,252,47,255,255,253,47,255,255,255,255,208,47,255,255,255,111,255,255,255,255,208,47,255,255,255,47,255,255,255,255,208,0,0,7,253,5,85,111,229,85,64,0,0,7,248,0,0,47,192,0,0,0,0,15,240,0,0,63,192,0,0,0,208,63,192,0,0,63,128,0,0,3,248,255,64,3,255,255,255,254,0,7,255,253,0,3,255,255,255,254,0,0,191,248,0,3,255,255,255,254,0,0,31,253,0,3,245,85,85,254,0,0,2,255,192,3,240,0,0,254,0,0,0,127,192,3,240,26,64,254,0,127,255,255,255,211,240,47,192,254,0,127,255,255,255,211,240,47,192,254,0,127,255,255,255,195,240,47,192,254,0,21,87,249,111,195,240,47,192,254,0,0,3,244,47,131,240,47,192,254,0,0,3,244,63,3,240,47,192,254,0,0,3,244,63,3,240,47,192,254,0,0,3,244,190,3,240,47,192,254,0,0,3,244,252,3,240,47,192,254,0,0,3,244,20,3,240,63,128,254,0,0,3,244,0,3,240,63,128,254,0,0,3,244,0,3,240,63,64,254,0,0,3,244,0,3,240,191,0,254,0,0,3,244,0,0,0,255,0,0,0,0,3,244,0,0,2,253,44,0,0,0,3,244,0,0,11,252,191,64,0,0,3,244,0,0,47,240,191,224,0,0,3,244,0,0,255,208,31,248,0,0,7,244,0,11,255,64,7,254,0,15,255,244,0,191,252,0,1,255,192,11,255,240,0,255,224,0,0,127,192,7,255,208,0,62,0,0,0,31,0,2,149,0,0,0,0,0,0,4,0,
  // 0x9891  频
  145,152,38,38,124,40,1,252,0,0,31,128,0,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,0,47,128,1,255,255,255,255,192,2,244,47,128,1,255,255,255,255,192,2,244,47,255,241,255,255,255,255,192,2,244,47,255,240,0,3,240,0,0,2,244,47,255,240,0,11,240,0,0,2,244,47,128,0,0,15,208,0,0,2,244,47,128,0,0,31,192,0,0,2,244,47,128,0,127,255,255,255,0,2,244,47,128,0,127,255,255,255,0,22,245,111,213,84,127,255,255,255,0,127,255,255,255,252,126,0,0,127,0,127,255,255,255,252,126,1,80,127,0,127,255,255,255,252,126,7,224,127,0,0,0,127,0,0,126,7,224,127,0,0,0,127,0,0,126,7,224,127,0,0,144,127,0,0,126,7,224,127,0,1,252,127,2,248,126,7,224,127,0,3,248,127,3,248,126,7,224,127,0,3,240,127,3,244,126,7,224,127,0,7,240,127,7,240,126,11,224,127,0,15,208,127,15,224,126,11,208,127,0,47,192,127,31,208,126,11,208,127,0,63,128,127,63,192,126,15,192,127,0,47,0,127,191,64,126,15,192,127,0,5,0,127,255,0,126,31,192,127,0,0,0,3,253,0,105,47,128,42,0,0,0,15,248,0,0,63,104,0,0,0,0,63,240,0,0,191,191,0,0,0,1,255,192,0,1,254,191,192,0,0,11,255,0,0,7,252,31,244,0,0,191,248,0,0,47,244,7,254,0,27,255,208,0,6,255,208,0,255,128,63,254,0,0,63,255,0,0,63,208,15,244,0,0,15,244,0,0,15,128,10,0,0,0,10,64,0,0,2,0,
  // 0x989d  额
  157,152,37,38,124,40,2,252,0,0,96,0,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,0,2,253,0,7,255,255,255,255,0,191,255,255,255,247,255,255,255,255,0,191,255,255,255,247,255,255,255,255,0,191,255,255,255,240,0,47,128,0,0,190,0,0,7,240,0,63,64,0,0,190,10,64,7,240,0,127,0,0,0,190,31,208,7,240,0,190,0,0,0,189,63,128,7,243,255,255,255,248,0,0,191,255,254,3,255,255,255,248,0,2,255,255,255,131,255,255,255,248,0,7,255,255,255,3,240,0,1,248,0,47,240,1,254,3,240,5,1,248,0,191,192,3,252,3,240,47,129,248,0,255,46,15,244,3,240,47,129,248,0,56,191,255,208,3,240,47,129,248,0,0,127,255,128,3,240,47,65,248,0,0,15,255,224,3,240,47,65,248,0,0,191,255,253,3,240,63,65,248,0,11,255,219,255,195,240,63,65,248,0,255,254,1,255,243,240,63,1,248,0,255,244,0,31,211,240,63,1,248,0,191,64,0,3,67,240,63,1,248,0,55,255,255,255,3,240,127,1,248,0,3,255,255,255,3,240,190,1,248,0,3,255,255,255,3,240,253,1,248,0,3,244,0,191,2,240,252,1,168,0,3,244,0,191,0,2,252,48,0,0,3,244,0,191,0,3,244,253,0,0,3,244,0,191,0,15,241,255,128,0,3,244,0,191,0,63,208,63,240,0,3,255,255,255,2,255,128,11,253,0,3,255,255,255,47,254,0,1,255,64,3,255,255,255,127,244,0,0,127,0,3,244,0,191,47,128,0,0,29,0,1,80,0,0,8,0,0,0,0,0,
  // 0x98ce  风
  206,152,37,36,104,40,2,252,0,191,255,255,255,255,255,253,0,0,0,191,255,255,255,255,255,253,0,0,0,191,255,255,255,255,255,253,0,0,0,191,170,170,170,170,170,253,0,0,0,191,0,0,0,0,1,253,0,0,0,191,0,0,0,0,1,253,0,0,0,191,0,0,0,9,1,253,0,0,0,191,0,0,0,47,193,253,0,0,0,191,7,192,0,63,129,253,0,0,0,191,31,240,0,127,65,253,0,0,0,191,11,248,0,191,1,253,0,0,0,191,3,253,0,254,1,253,0,0,0,255,0,255,66,252,1,253,0,0,0,255,0,127,195,248,1,253,0,0,0,255,0,47,251,244,1,253,0,0,0,255,0,15,255,240,0,253,0,0,0,255,0,3,255,208,0,253,0,0,0,255,0,1,255,192,0,253,0,0,0,255,0,0,255,192,0,253,0,0,0,254,0,2,255,224,0,253,0,0,1,254,0,3,255,240,0,253,0,0,1,253,0,15,255,252,0,253,0,0,1,253,0,47,243,254,0,254,0,0,2,252,0,191,193,255,64,254,0,0,3,252,1,255,64,191,192,254,0,0,3,252,7,254,0,63,224,190,4,0,7,248,31,252,0,31,240,191,10,0,11,244,191,240,0,15,252,127,11,64,15,240,191,192,0,3,248,127,11,192,31,224,47,0,0,2,128,63,79,128,63,208,8,0,0,0,0,63,207,128,191,192,0,0,0,0,0,31,255,64,255,64,0,0,0,0,0,15,255,0,191,0,0,0,0,0,0,7,254,0,29,0,0,0,0,0,0,1,248,0,4,0,0,0,0,0,0,0,0,0,
  // 0x9971  饱
  113,153,37,38,124,40,1,252,0,37,0,0,0,144,0,0,0,0,0,127,0,0,1,252,0,0,0,0,0,191,0,0,2,252,0,0,0,0,0,190,0,0,3,244,0,0,0,0,0,253,0,0,11,244,0,0,0,0,0,253,0,0,15,255,255,255,252,0,1,255,255,248,31,255,255,255,252,0,2,255,255,252,63,255,255,255,252,0,3,255,255,248,191,0,0,1,252,0,3,244,3,244,254,0,0,1,252,0,11,240,7,243,252,0,0,1,252,0,15,224,11,235,248,0,0,1,252,0,15,208,15,239,255,255,255,129,252,0,47,192,31,207,255,255,255,129,252,0,63,133,111,75,191,255,255,129,252,0,191,31,193,2,63,128,47,129,252,0,62,31,192,0,63,128,47,129,252,0,12,31,192,0,63,128,47,129,252,0,0,31,192,0,63,128,47,129,252,0,0,31,192,0,63,128,47,129,252,0,0,31,192,0,63,128,47,129,252,0,0,31,192,0,63,128,47,129,252,0,0,31,192,0,63,255,255,130,252,0,0,31,192,0,63,255,255,130,252,0,0,31,192,0,63,255,255,135,252,0,0,31,192,0,63,128,11,255,248,0,0,31,192,0,63,128,3,255,240,0,0,31,192,64,63,128,3,255,128,0,0,31,193,224,63,128,0,0,0,0,0,31,203,240,63,128,0,0,8,0,0,31,255,240,63,128,0,0,15,128,0,31,255,192,63,128,0,0,15,192,0,47,254,0,63,128,0,0,31,192,0,63,244,0,63,212,0,1,127,192,0,191,208,0,47,255,255,255,255,128,0,191,0,0,15,255,255,255,255,0,0,60,0,0,2,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9a6c  马
  108,154,35,37,77,40,2,251,1,170,170,170,170,170,170,128,0,2,255,255,255,255,255,255,208,0,2,255,255,255,255,255,255,208,0,2,255,255,255,255,255,255,208,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,1,64,0,0,0,63,192,0,0,3,248,0,0,0,63,192,0,0,3,244,0,0,0,63,192,0,0,7,244,0,0,0,63,128,0,0,7,244,0,0,0,63,128,0,0,11,240,0,0,0,127,64,0,0,11,240,0,0,0,127,64,0,0,11,240,0,0,0,127,0,0,0,15,240,0,0,0,191,0,0,0,15,240,0,0,0,191,0,0,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,248,0,31,255,255,255,255,255,255,248,0,5,85,85,85,85,85,91,248,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,191,255,255,255,255,255,244,15,240,191,255,255,255,255,255,244,15,240,191,255,255,255,255,255,244,15,240,106,170,170,170,170,170,160,15,224,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,192,0,0,0,0,0,101,85,255,64,0,0,0,0,0,63,255,255,0,0,0,0,0,0,47,255,253,0,0,0,0,0,0,47,255,224,0,0,0,0,0,0,0,0,0,0,
  // 0x9a71  驱
  113,154,38,36,104,40,1,252,31,255,255,240,21,85,85,85,85,0,31,255,255,240,63,255,255,255,255,128,31,255,255,240,63,255,255,255,255,128,0,0,11,240,63,255,255,255,255,128,0,0,11,224,63,128,0,0,0,0,0,0,11,224,63,128,0,0,0,0,3,240,11,224,63,128,0,1,228,0,3,240,11,208,63,130,128,2,252,0,3,240,15,208,63,143,208,3,248,0,3,240,15,208,63,143,240,7,244,0,7,240,15,192,63,131,252,15,240,0,7,240,15,192,63,129,254,15,224,0,7,224,15,192,63,128,191,95,192,0,11,224,15,192,63,128,63,255,192,0,11,208,31,192,63,128,31,255,64,0,11,208,31,192,63,128,11,255,0,0,15,208,47,128,63,128,3,254,0,0,15,255,255,253,63,128,3,254,0,0,15,255,255,253,63,128,7,255,64,0,15,255,255,253,63,128,15,255,192,0,0,0,0,253,63,128,47,255,208,0,0,0,0,252,63,128,63,207,240,0,0,0,0,252,63,128,191,71,248,0,0,0,16,252,63,130,254,3,252,0,0,27,244,252,63,135,252,0,255,0,27,255,249,252,63,143,244,0,191,0,191,255,229,252,63,175,240,0,127,0,127,244,2,248,63,139,192,0,56,0,121,0,2,248,63,130,64,0,0,0,0,0,3,244,63,128,0,0,0,0,0,0,3,244,63,213,85,85,85,64,0,0,11,240,63,255,255,255,255,208,0,63,255,224,63,255,255,255,255,208,0,47,255,192,63,255,255,255,255,208,0,47,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9ad8  高
  216,154,35,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,254,0,0,0,0,127,255,255,255,255,255,255,255,252,127,255,255,255,255,255,255,255,252,127,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,255,255,128,0,0,3,255,255,255,255,255,128,0,0,3,254,170,170,170,191,128,0,0,3,252,0,0,0,63,128,0,0,3,252,0,0,0,63,128,0,0,3,252,0,0,0,63,128,0,0,3,255,255,255,255,255,128,0,0,3,255,255,255,255,255,128,0,0,1,170,170,170,170,170,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,240,11,240,0,0,0,0,0,15,240,11,240,0,0,0,0,0,15,240,11,240,6,170,170,170,144,15,240,11,240,11,255,255,255,224,15,240,11,240,11,255,255,255,224,15,240,11,240,11,224,0,15,224,15,240,11,240,11,224,0,15,224,15,240,11,240,11,224,0,15,224,15,240,11,240,11,250,170,175,224,15,240,11,240,11,255,255,255,224,15,240,11,240,11,255,255,255,224,15,240,11,240,11,224,0,0,127,255,240,11,240,11,224,0,0,63,255,208,11,240,0,0,0,0,63,255,128,7,240,0,0,0,0,21,84,0,
  // 0x9ec4  黄
  196,158,36,38,86,40,2,252,0,0,10,144,0,6,160,0,0,0,0,15,224,0,11,240,0,0,0,0,15,224,0,11,240,0,0,0,85,95,245,85,91,245,85,64,3,255,255,255,255,255,255,255,192,3,255,255,255,255,255,255,255,192,3,255,255,255,255,255,255,255,192,0,0,15,224,0,11,240,0,0,0,0,15,224,0,11,240,0,0,0,0,15,224,0,11,240,0,0,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,85,85,85,85,255,85,85,85,85,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,106,170,170,255,170,170,170,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,0,255,0,0,255,0,0,191,0,0,255,0,0,255,0,0,191,0,0,255,0,0,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,170,170,255,170,170,255,0,0,191,0,0,255,0,0,255,0,0,191,0,0,255,0,0,255,0,0,191,170,170,255,170,170,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,0,1,64,0,2,64,0,0,0,0,31,224,0,11,248,0,0,0,1,255,252,0,31,255,208,0,0,47,255,224,0,2,255,254,0,11,255,254,0,0,0,31,255,244,127,255,224,0,0,0,0,191,252,31,249,0,0,0,0,0,11,240,6,64,0,0,0,0,0,0,128,
  // 0x9ede  點
  222,158,38,38,124,40,1,252,0,0,0,0,0,0,26,128,0,0,10,170,170,170,160,0,31,192,0,0,15,255,255,255,240,0,31,192,0,0,15,255,255,255,240,0,31,192,0,0,15,192,60,2,240,0,31,192,0,0,15,196,60,18,240,0,31,192,0,0,15,236,60,63,240,0,31,192,0,0,15,221,60,122,240,0,31,192,0,0,15,206,60,182,240,0,31,192,0,0,15,207,60,242,240,0,31,255,255,208,15,207,125,226,240,0,31,255,255,208,15,202,125,210,240,0,31,255,255,208,15,192,60,2,240,0,31,229,85,64,15,234,190,171,240,0,31,192,0,0,15,255,255,255,240,0,31,192,0,0,15,255,255,255,240,0,31,192,0,0,0,0,190,0,0,0,31,192,0,0,0,0,190,0,0,0,31,192,0,0,0,0,190,0,0,0,31,192,0,0,15,255,255,255,244,85,111,229,85,0,15,255,255,255,244,255,255,255,255,0,15,255,255,255,244,255,255,255,255,0,0,0,190,0,0,255,255,255,255,0,0,0,190,0,0,253,0,0,191,0,1,85,255,175,252,253,0,0,191,0,63,255,255,255,252,253,0,0,191,0,63,255,255,255,252,253,0,0,191,0,63,250,165,80,0,253,0,0,191,0,0,0,0,7,128,253,0,0,191,0,2,6,139,203,208,253,0,0,191,0,7,215,199,195,240,253,0,0,191,0,11,199,195,209,248,253,0,0,191,0,11,195,210,240,252,254,85,85,255,0,15,195,225,240,125,255,255,255,255,0,31,131,224,244,52,255,255,255,255,0,63,3,224,144,0,255,255,255,255,0,126,1,64,0,0,253,0,0,191,0,8,0,0,0,0,189,0,0,106,0,
  // 0x9f50  齐
  80,159,37,39,134,40,2,251,0,0,0,0,254,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,127,255,255,255,255,255,255,255,254,0,127,255,255,255,255,255,255,255,254,0,127,255,255,255,255,255,255,255,254,0,0,2,254,0,0,0,255,192,0,0,0,0,255,64,0,1,255,0,0,0,0,0,63,208,0,7,253,0,0,0,0,0,15,244,0,31,248,0,0,0,0,0,7,255,0,191,240,0,0,0,0,0,0,255,211,255,128,0,0,0,0,0,0,63,255,254,0,0,0,0,0,0,0,11,255,244,0,0,0,0,0,0,0,47,255,254,0,0,0,0,0,0,11,255,255,255,249,0,0,0,0,22,255,255,210,255,255,250,64,0,111,255,255,249,0,31,255,255,255,64,255,255,255,64,0,1,191,255,255,0,63,255,229,0,0,0,22,255,252,0,47,144,255,0,0,0,127,65,104,0,0,0,255,0,0,0,127,64,0,0,0,0,255,0,0,0,127,64,0,0,0,0,255,0,0,0,127,64,0,0,0,0,255,0,0,0,127,64,0,0,0,0,255,0,0,0,127,64,0,0,0,0,255,0,0,0,127,64,0,0,0,1,254,0,0,0,127,64,0,0,0,2,254,0,0,0,127,64,0,0,0,3,253,0,0,0,127,64,0,0,0,11,252,0,0,0,127,64,0,0,0,31,248,0,0,0,127,64,0,0,0,191,240,0,0,0,127,64,0,0,3,255,192,0,0,0,127,64,0,0,15,255,64,0,0,0,127,64,0,0,3,253,0,0,0,0,127,64,0,0,0,224,0,0,0,0,127,64,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0xff1a  ：
  26,255,8,27,54,40,16,1,11,224,47,248,63,252,127,253,63,252,47,248,6,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,224,63,248,63,252,127,253,63,252,47,244,6,128,
};

#endif // HAS_GRAPHICAL_TFT
