/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Latin Extended-A 40pt, capital 'A' height: 29px, width: 100%, range: 0x0100-0x017f
extern const uint8_t NotoSans_Medium_Latin_Extended_A_29[22499] = {
  130,29,0,1,127,1,38,246, // unifont_t
  // 0x0100  Ā
  26,35,245,26,0,0,0,1,85,85,84,0,0,0,3,255,255,252,0,0,0,3,255,255,252,0,0,0,3,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x0101  ā
  18,29,145,23,2,255,1,85,85,85,0,2,255,255,254,0,2,255,255,254,0,2,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x0102  Ă
  26,37,3,26,0,0,0,11,192,0,62,0,0,0,7,208,0,189,0,0,0,3,254,171,252,0,0,0,1,255,255,244,0,0,0,0,127,255,208,0,0,0,0,6,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x0103  ă
  18,31,155,23,2,255,3,208,0,47,0,3,240,0,63,0,2,254,171,253,0,0,255,255,252,0,0,63,255,224,0,0,6,170,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x0104  Ą
  26,39,17,26,0,246,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,0,0,0,0,0,47,64,0,0,0,0,0,190,0,0,0,0,0,1,252,0,0,0,0,0,3,244,0,0,0,0,0,3,240,0,0,0,0,0,3,244,0,0,0,0,0,3,255,176,0,0,0,0,1,255,240,0,0,0,0,0,127,224,0,0,0,0,0,0,0,
  // 0x0105  ą
  19,32,160,23,2,246,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,15,192,0,0,0,63,64,0,0,0,190,0,0,0,0,252,0,0,0,1,252,0,0,0,1,252,0,0,0,0,255,184,0,0,0,191,248,0,0,0,31,244,0,0,0,0,0,
  // 0x0106  Ć
  22,39,234,25,2,255,0,0,0,2,170,0,0,0,0,15,252,0,0,0,0,31,244,0,0,0,0,63,208,0,0,0,0,255,64,0,0,0,2,252,0,0,0,0,3,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,2,255,255,255,208,0,31,255,255,255,224,0,127,255,255,255,208,1,255,244,0,27,192,3,255,128,0,0,0,11,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,63,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,127,192,0,0,0,0,127,208,0,0,0,0,63,224,0,0,0,0,63,240,0,0,0,0,47,244,0,0,0,0,15,252,0,0,0,0,11,255,0,0,0,0,3,255,208,0,0,64,1,255,254,85,175,192,0,127,255,255,255,192,0,15,255,255,255,192,0,1,191,255,254,64,0,0,1,85,0,0,
  // 0x0107  ć
  16,32,128,20,2,255,0,0,2,170,0,0,11,253,0,0,15,248,0,0,63,224,0,0,191,128,0,1,253,0,0,2,244,0,0,0,0,0,0,0,0,0,0,6,255,228,0,127,255,255,2,255,255,255,11,255,234,253,31,253,0,8,63,240,0,0,127,208,0,0,191,192,0,0,191,128,0,0,255,128,0,0,255,64,0,0,255,64,0,0,255,64,0,0,255,128,0,0,191,192,0,0,127,192,0,0,63,224,0,0,47,244,0,1,15,254,64,111,7,255,255,255,1,255,255,255,0,47,255,248,0,0,85,0,
  // 0x0108  Ĉ
  22,39,234,25,2,255,0,0,2,169,0,0,0,0,15,255,0,0,0,0,47,255,192,0,0,0,191,175,240,0,0,1,254,7,248,0,0,7,248,1,254,0,0,15,128,0,47,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,2,255,255,255,208,0,31,255,255,255,224,0,127,255,255,255,208,1,255,244,0,27,192,3,255,128,0,0,0,11,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,63,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,127,192,0,0,0,0,127,208,0,0,0,0,63,224,0,0,0,0,63,240,0,0,0,0,47,244,0,0,0,0,15,252,0,0,0,0,11,255,0,0,0,0,3,255,208,0,0,64,1,255,254,85,175,192,0,127,255,255,255,192,0,15,255,255,255,192,0,1,191,255,254,64,0,0,1,85,0,0,
  // 0x0109  ĉ
  17,32,160,20,2,255,0,2,170,0,0,0,11,255,64,0,0,47,255,192,0,0,127,223,240,0,0,255,7,252,0,3,248,0,255,0,11,208,0,47,64,0,0,0,0,0,0,0,0,0,0,0,6,255,228,0,0,127,255,255,0,2,255,255,255,0,11,255,234,253,0,31,253,0,8,0,63,240,0,0,0,127,208,0,0,0,191,192,0,0,0,191,128,0,0,0,255,128,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,244,0,1,0,15,254,64,111,0,7,255,255,255,0,1,255,255,255,0,0,47,255,248,0,0,0,85,0,0,
  // 0x010a  Ċ
  22,38,228,25,2,255,0,0,0,164,0,0,0,0,3,253,0,0,0,0,3,254,0,0,0,0,3,253,0,0,0,0,1,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,2,255,255,255,208,0,31,255,255,255,224,0,127,255,255,255,208,1,255,244,0,27,192,3,255,128,0,0,0,11,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,63,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,127,192,0,0,0,0,127,208,0,0,0,0,63,224,0,0,0,0,63,240,0,0,0,0,47,244,0,0,0,0,15,252,0,0,0,0,11,255,0,0,0,0,3,255,208,0,0,64,1,255,254,85,175,192,0,127,255,255,255,192,0,15,255,255,255,192,0,1,191,255,254,64,0,0,1,85,0,0,
  // 0x010b  ċ
  16,31,124,20,2,255,0,0,168,0,0,2,254,0,0,3,255,0,0,3,254,0,0,1,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,228,0,127,255,255,2,255,255,255,11,255,234,253,31,253,0,8,63,240,0,0,127,208,0,0,191,192,0,0,191,128,0,0,255,128,0,0,255,64,0,0,255,64,0,0,255,64,0,0,255,128,0,0,191,192,0,0,127,192,0,0,63,224,0,0,47,244,0,1,15,254,64,111,7,255,255,255,1,255,255,255,0,47,255,248,0,0,85,0,
  // 0x010c  Č
  22,39,234,25,2,255,0,10,128,0,42,64,0,11,244,0,255,0,0,2,254,7,252,0,0,0,191,159,240,0,0,0,63,255,192,0,0,0,15,255,64,0,0,0,7,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,2,255,255,255,208,0,31,255,255,255,224,0,127,255,255,255,208,1,255,244,0,27,192,3,255,128,0,0,0,11,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,63,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,127,192,0,0,0,0,127,208,0,0,0,0,63,224,0,0,0,0,63,240,0,0,0,0,47,244,0,0,0,0,15,252,0,0,0,0,11,255,0,0,0,0,3,255,208,0,0,64,1,255,254,85,175,192,0,127,255,255,255,192,0,15,255,255,255,192,0,1,191,255,254,64,0,0,1,85,0,0,
  // 0x010d  č
  17,32,160,20,2,255,10,144,0,26,64,7,248,0,191,0,1,254,3,252,0,0,127,223,240,0,0,47,255,208,0,0,15,255,64,0,0,3,254,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,228,0,0,127,255,255,0,2,255,255,255,0,11,255,234,253,0,31,253,0,8,0,63,240,0,0,0,127,208,0,0,0,191,192,0,0,0,191,128,0,0,0,255,128,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,244,0,1,0,15,254,64,111,0,7,255,255,255,0,1,255,255,255,0,0,47,255,248,0,0,0,85,0,0,
  // 0x010e  Ď
  23,38,228,29,4,0,1,164,0,6,160,0,0,254,0,47,208,0,0,63,192,255,64,0,0,31,247,253,0,0,0,7,255,244,0,0,0,2,255,224,0,0,0,0,191,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,165,0,0,0,255,255,255,248,0,0,255,255,255,255,192,0,255,255,255,255,244,0,255,0,1,191,253,0,255,0,0,11,255,64,255,0,0,1,255,192,255,0,0,0,191,224,255,0,0,0,63,240,255,0,0,0,31,244,255,0,0,0,15,248,255,0,0,0,15,248,255,0,0,0,11,252,255,0,0,0,11,252,255,0,0,0,11,252,255,0,0,0,11,252,255,0,0,0,11,252,255,0,0,0,15,248,255,0,0,0,15,248,255,0,0,0,31,244,255,0,0,0,63,240,255,0,0,0,127,224,255,0,0,0,255,192,255,0,0,7,255,64,255,0,0,127,254,0,255,170,191,255,248,0,255,255,255,255,208,0,255,255,255,253,0,0,255,255,254,64,0,0,
  // 0x010f  ď
  26,32,224,25,2,255,0,0,0,1,84,5,80,0,0,0,3,253,15,240,0,0,0,3,253,15,224,0,0,0,3,253,15,208,0,0,0,3,253,31,192,0,0,0,3,253,47,64,0,0,0,3,253,62,0,0,0,0,3,253,0,0,0,0,0,3,253,0,0,0,27,254,2,253,0,0,0,255,255,226,253,0,0,3,255,255,250,253,0,0,15,255,170,255,253,0,0,47,248,0,47,253,0,0,63,240,0,15,253,0,0,127,208,0,7,253,0,0,191,192,0,3,253,0,0,191,128,0,3,253,0,0,255,128,0,2,253,0,0,255,64,0,2,253,0,0,255,64,0,2,253,0,0,255,64,0,2,253,0,0,255,128,0,2,253,0,0,191,192,0,3,253,0,0,127,192,0,3,253,0,0,63,224,0,7,253,0,0,63,244,0,15,253,0,0,31,254,1,191,253,0,0,11,255,255,254,253,0,0,2,255,255,240,253,0,0,0,127,255,128,253,0,0,0,1,80,0,0,0,0,
  // 0x0110  Đ
  26,29,203,29,1,0,2,170,170,148,0,0,0,3,255,255,255,224,0,0,3,255,255,255,255,0,0,3,255,255,255,255,208,0,3,253,0,6,255,244,0,3,253,0,0,47,253,0,3,253,0,0,7,255,0,3,253,0,0,2,255,128,3,253,0,0,0,255,192,3,253,0,0,0,127,208,3,253,0,0,0,63,224,3,253,0,0,0,63,224,3,253,0,0,0,47,240,255,255,255,224,0,47,240,255,255,255,224,0,47,240,255,255,255,224,0,47,240,171,255,170,160,0,47,240,3,253,0,0,0,63,224,3,253,0,0,0,63,224,3,253,0,0,0,127,192,3,253,0,0,0,255,192,3,253,0,0,1,255,128,3,253,0,0,3,255,0,3,253,0,0,31,253,0,3,253,0,1,255,248,0,3,255,170,255,255,224,0,3,255,255,255,255,64,0,3,255,255,255,244,0,0,3,255,255,249,0,0,0,
  // 0x0111  đ
  23,32,192,25,2,255,0,0,0,1,84,0,0,0,0,3,253,0,0,0,0,3,253,0,0,0,0,3,253,0,0,2,255,255,255,244,0,2,255,255,255,248,0,2,255,255,255,248,0,0,0,3,254,0,0,0,0,3,253,0,0,1,84,3,253,0,0,127,255,130,253,0,2,255,255,246,253,0,11,255,255,254,253,0,31,253,0,191,253,0,63,240,0,15,253,0,127,208,0,11,253,0,127,192,0,3,253,0,191,192,0,3,253,0,255,128,0,2,253,0,255,64,0,2,253,0,255,64,0,2,253,0,255,64,0,2,253,0,255,128,0,2,253,0,191,128,0,3,253,0,127,192,0,3,253,0,63,208,0,7,253,0,63,240,0,15,253,0,31,254,1,191,253,0,11,255,255,254,253,0,2,255,255,241,253,0,0,127,255,128,253,0,0,1,80,0,0,0,
  // 0x0112  Ē
  16,35,140,22,4,0,5,85,85,80,15,255,255,244,15,255,255,244,15,255,255,240,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x0113  ē
  19,29,145,23,2,255,1,85,85,85,0,2,255,255,254,0,2,255,255,254,0,1,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x0114  Ĕ
  16,37,148,22,4,0,31,0,0,248,31,128,1,244,15,250,175,240,7,255,255,208,1,255,255,64,0,26,164,0,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x0115  ĕ
  19,31,155,23,2,255,3,208,0,31,0,3,240,0,63,0,2,254,170,253,0,0,255,255,252,0,0,63,255,224,0,0,6,170,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x0116  Ė
  16,37,148,22,4,0,0,2,144,0,0,15,244,0,0,15,248,0,0,15,244,0,0,7,224,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x0117  ė
  19,31,155,23,2,255,0,0,168,0,0,0,2,254,0,0,0,3,255,0,0,0,2,255,0,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x0118  Ę
  16,39,156,22,4,246,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,0,0,2,244,0,0,11,208,0,0,31,128,0,0,63,0,0,0,63,0,0,0,63,64,0,0,63,234,0,0,47,255,0,0,7,254,0,0,0,0,
  // 0x0119  ę
  19,32,160,23,2,246,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,208,0,0,21,127,0,0,0,0,252,0,0,0,2,244,0,0,0,3,240,0,0,0,7,240,0,0,0,7,240,0,0,0,3,254,224,0,0,2,255,224,0,0,0,191,208,0,0,0,0,0,
  // 0x011a  Ě
  16,38,152,22,4,0,42,0,0,169,47,208,3,252,11,248,31,240,2,254,127,192,0,255,255,0,0,63,253,0,0,31,244,0,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x011b  ě
  19,32,160,23,2,255,6,144,0,26,128,3,248,0,191,64,0,255,3,253,0,0,127,223,244,0,0,31,255,208,0,0,11,255,128,0,0,2,254,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x011c  Ĝ
  24,39,234,29,2,255,0,0,0,170,64,0,0,0,3,255,192,0,0,0,11,255,240,0,0,0,47,235,252,0,0,0,127,129,254,0,0,1,254,0,127,128,0,3,224,0,11,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,250,64,0,1,191,255,255,249,0,11,255,255,255,253,0,63,255,255,255,252,0,255,249,0,1,184,3,255,192,0,0,0,11,255,0,0,0,0,15,252,0,0,0,0,47,244,0,0,0,0,63,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,192,0,5,85,85,191,192,0,31,255,255,191,192,0,31,255,255,127,192,0,31,255,255,127,192,0,5,86,255,127,208,0,0,0,255,63,224,0,0,0,255,63,240,0,0,0,255,31,244,0,0,0,255,15,252,0,0,0,255,11,255,0,0,0,255,3,255,208,0,0,255,0,255,254,85,91,255,0,63,255,255,255,255,0,11,255,255,255,255,0,0,191,255,255,228,0,0,0,85,64,0,
  // 0x011d  ĝ
  20,41,205,25,2,246,0,1,170,64,0,0,3,255,192,0,0,15,255,240,0,0,47,235,248,0,0,191,130,254,0,1,253,0,127,128,3,224,0,11,192,0,0,0,0,0,0,0,0,0,0,0,27,254,0,169,0,255,255,224,253,3,255,255,249,253,15,255,171,255,253,31,248,0,63,253,63,240,0,15,253,127,208,0,7,253,191,192,0,3,253,191,128,0,3,253,255,128,0,2,253,255,64,0,2,253,255,64,0,2,253,255,64,0,2,253,255,128,0,2,253,191,192,0,3,253,127,192,0,3,253,63,208,0,7,253,63,240,0,15,253,15,253,0,191,253,11,255,255,254,253,2,255,255,242,253,0,127,255,130,253,0,1,80,2,253,0,0,0,3,253,0,0,0,3,253,0,0,0,7,252,0,0,0,15,252,30,64,0,127,244,31,255,255,255,224,31,255,255,255,128,11,255,255,253,0,0,22,169,64,0,
  // 0x011e  Ğ
  24,38,228,29,2,255,0,1,240,0,15,128,0,1,248,0,31,64,0,0,255,170,255,0,0,0,127,255,253,0,0,0,31,255,244,0,0,0,1,170,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,250,64,0,1,191,255,255,249,0,11,255,255,255,253,0,63,255,255,255,252,0,255,249,0,1,184,3,255,192,0,0,0,11,255,0,0,0,0,15,252,0,0,0,0,47,244,0,0,0,0,63,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,192,0,5,85,85,191,192,0,31,255,255,191,192,0,31,255,255,127,192,0,31,255,255,127,192,0,5,86,255,127,208,0,0,0,255,63,224,0,0,0,255,63,240,0,0,0,255,31,244,0,0,0,255,15,252,0,0,0,255,11,255,0,0,0,255,3,255,208,0,0,255,0,255,254,85,91,255,0,63,255,255,255,255,0,11,255,255,255,255,0,0,191,255,255,228,0,0,0,85,64,0,
  // 0x011f  ğ
  20,40,200,25,2,246,2,240,0,15,128,1,244,0,47,64,0,255,170,255,0,0,127,255,253,0,0,31,255,244,0,0,1,170,64,0,0,0,0,0,0,0,0,0,0,0,0,27,254,0,169,0,255,255,224,253,3,255,255,249,253,15,255,171,255,253,31,248,0,63,253,63,240,0,15,253,127,208,0,7,253,191,192,0,3,253,191,128,0,3,253,255,128,0,2,253,255,64,0,2,253,255,64,0,2,253,255,64,0,2,253,255,128,0,2,253,191,192,0,3,253,127,192,0,3,253,63,208,0,7,253,63,240,0,15,253,15,253,0,191,253,11,255,255,254,253,2,255,255,242,253,0,127,255,130,253,0,1,80,2,253,0,0,0,3,253,0,0,0,3,253,0,0,0,7,252,0,0,0,15,252,30,64,0,127,244,31,255,255,255,224,31,255,255,255,128,11,255,255,253,0,0,22,169,64,0,
  // 0x0120  Ġ
  24,38,228,29,2,255,0,0,0,41,0,0,0,0,0,255,64,0,0,0,0,255,128,0,0,0,0,255,64,0,0,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,250,64,0,1,191,255,255,249,0,11,255,255,255,253,0,63,255,255,255,252,0,255,249,0,1,184,3,255,192,0,0,0,11,255,0,0,0,0,15,252,0,0,0,0,47,244,0,0,0,0,63,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,192,0,5,85,85,191,192,0,31,255,255,191,192,0,31,255,255,127,192,0,31,255,255,127,192,0,5,86,255,127,208,0,0,0,255,63,224,0,0,0,255,63,240,0,0,0,255,31,244,0,0,0,255,15,252,0,0,0,255,11,255,0,0,0,255,3,255,208,0,0,255,0,255,254,85,91,255,0,63,255,255,255,255,0,11,255,255,255,255,0,0,191,255,255,228,0,0,0,85,64,0,
  // 0x0121  ġ
  20,40,200,25,2,246,0,0,41,0,0,0,0,255,0,0,0,1,255,64,0,0,0,255,64,0,0,0,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,254,0,169,0,255,255,224,253,3,255,255,249,253,15,255,171,255,253,31,248,0,63,253,63,240,0,15,253,127,208,0,7,253,191,192,0,3,253,191,128,0,3,253,255,128,0,2,253,255,64,0,2,253,255,64,0,2,253,255,64,0,2,253,255,128,0,2,253,191,192,0,3,253,127,192,0,3,253,63,208,0,7,253,63,240,0,15,253,15,253,0,191,253,11,255,255,254,253,2,255,255,242,253,0,127,255,130,253,0,1,80,2,253,0,0,0,3,253,0,0,0,3,253,0,0,0,7,252,0,0,0,15,252,30,64,0,127,244,31,255,255,255,224,31,255,255,255,128,11,255,255,253,0,0,22,169,64,0,
  // 0x0122  Ģ
  24,38,228,29,2,247,0,0,6,255,250,64,0,1,191,255,255,249,0,11,255,255,255,253,0,63,255,255,255,252,0,255,249,0,1,184,3,255,192,0,0,0,11,255,0,0,0,0,15,252,0,0,0,0,47,244,0,0,0,0,63,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,192,0,5,85,85,191,192,0,31,255,255,191,192,0,31,255,255,127,192,0,31,255,255,127,192,0,5,86,255,127,208,0,0,0,255,63,224,0,0,0,255,63,240,0,0,0,255,31,244,0,0,0,255,15,252,0,0,0,255,11,255,0,0,0,255,3,255,208,0,0,255,0,255,254,85,91,255,0,63,255,255,255,255,0,11,255,255,255,255,0,0,191,255,255,228,0,0,0,85,64,0,0,0,0,0,0,0,0,0,0,42,64,0,0,0,0,191,64,0,0,0,0,191,0,0,0,0,0,254,0,0,0,0,1,252,0,0,0,0,2,244,0,0,0,0,2,224,0,0,
  // 0x0123  ģ
  20,41,205,25,2,246,0,0,6,128,0,0,0,31,128,0,0,0,63,64,0,0,0,127,0,0,0,0,255,0,0,0,1,254,0,0,0,2,253,0,0,0,0,0,0,0,0,0,0,0,0,0,27,254,0,169,0,255,255,224,253,3,255,255,249,253,15,255,171,255,253,31,248,0,63,253,63,240,0,15,253,127,208,0,7,253,191,192,0,3,253,191,128,0,3,253,255,128,0,2,253,255,64,0,2,253,255,64,0,2,253,255,64,0,2,253,255,128,0,2,253,191,192,0,3,253,127,192,0,3,253,63,208,0,7,253,63,240,0,15,253,15,253,0,191,253,11,255,255,254,253,2,255,255,242,253,0,127,255,130,253,0,1,80,2,253,0,0,0,3,253,0,0,0,3,253,0,0,0,7,252,0,0,0,15,252,30,64,0,127,244,31,255,255,255,224,31,255,255,255,128,11,255,255,253,0,0,22,169,64,0,
  // 0x0124  Ĥ
  22,38,228,30,4,0,0,0,106,144,0,0,0,0,255,240,0,0,0,3,255,252,0,0,0,11,250,254,0,0,0,47,224,191,128,0,0,191,64,31,208,0,0,248,0,2,240,0,0,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,10,160,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,234,170,170,191,240,255,255,255,255,255,240,255,255,255,255,255,240,255,255,255,255,255,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,
  // 0x0125  ĥ
  24,40,240,25,254,0,0,42,160,0,0,0,0,191,248,0,0,0,1,255,253,0,0,0,7,253,255,0,0,0,15,240,63,192,0,0,63,192,15,240,0,0,189,0,2,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,64,0,0,0,0,47,224,0,0,0,0,47,224,0,0,0,0,47,224,0,0,0,0,47,224,0,0,0,0,47,224,0,0,0,0,47,224,0,0,0,0,47,224,0,0,0,0,47,224,0,0,0,0,47,224,27,249,0,0,47,210,255,255,208,0,47,219,255,255,244,0,47,255,234,191,252,0,47,254,0,11,253,0,47,252,0,3,254,0,47,244,0,1,255,0,47,240,0,1,255,0,47,240,0,0,255,0,47,224,0,0,255,0,47,224,0,0,255,0,47,224,0,0,255,0,47,224,0,0,255,0,47,224,0,0,255,0,47,224,0,0,255,0,47,224,0,0,255,0,47,224,0,0,255,0,47,224,0,0,255,0,47,224,0,0,255,0,47,224,0,0,255,0,47,224,0,0,255,0,47,224,0,0,255,
  // 0x0126  Ħ
  30,29,232,30,0,0,0,170,0,0,0,10,160,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,1,255,0,0,0,31,240,0,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,1,255,0,0,0,31,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,0,255,234,170,170,191,240,0,0,255,255,255,255,255,240,0,0,255,255,255,255,255,240,0,0,255,255,255,255,255,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,0,255,0,0,0,15,240,0,
  // 0x0127  ħ
  22,31,186,25,0,0,1,84,0,0,0,0,2,254,0,0,0,0,2,254,0,0,0,0,2,254,0,0,0,0,191,255,255,253,0,0,191,255,255,253,0,0,191,255,255,253,0,0,2,254,0,0,0,0,2,254,0,0,0,0,2,254,0,0,0,0,2,254,2,255,224,0,2,253,47,255,254,0,2,253,255,255,255,128,2,255,254,155,255,192,2,255,224,0,191,224,2,255,192,0,63,240,2,255,64,0,31,240,2,255,0,0,31,240,2,255,0,0,15,240,2,254,0,0,15,240,2,254,0,0,15,240,2,254,0,0,15,240,2,254,0,0,15,240,2,254,0,0,15,240,2,254,0,0,15,240,2,254,0,0,15,240,2,254,0,0,15,240,2,254,0,0,15,240,2,254,0,0,15,240,2,254,0,0,15,240,2,254,0,0,15,240,
  // 0x0128  Ĩ
  16,37,148,14,255,0,0,164,0,25,11,255,64,61,31,255,249,252,63,175,255,248,61,1,255,240,120,0,26,64,0,0,0,0,0,0,0,0,6,170,170,144,7,255,255,224,7,255,255,224,0,191,254,64,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,31,248,0,7,255,255,208,7,255,255,224,7,255,255,224,
  // 0x0129  ĩ
  15,30,120,11,254,0,1,144,0,104,31,254,0,188,63,255,230,248,191,191,255,240,248,7,255,208,240,0,106,0,0,0,0,0,0,0,0,0,0,26,144,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,
  // 0x012a  Ī
  12,35,105,14,1,0,85,85,85,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,106,170,169,127,255,254,127,255,254,11,255,228,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,1,255,128,127,255,253,127,255,254,127,255,254,
  // 0x012b  ī
  13,28,112,11,255,0,85,85,85,0,191,255,255,128,191,255,255,128,191,255,255,64,0,0,0,0,0,0,0,0,0,106,64,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,
  // 0x012c  Ĭ
  14,37,148,14,0,0,124,0,3,224,125,0,7,208,63,234,191,192,31,255,255,64,7,255,253,0,0,106,144,0,0,0,0,0,0,0,0,0,26,170,170,64,31,255,255,128,31,255,255,128,2,255,249,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,127,224,0,31,255,255,64,31,255,255,128,31,255,255,128,
  // 0x012d  ĭ
  13,30,120,11,255,0,244,0,11,192,252,0,15,192,191,170,255,64,63,255,254,0,15,255,248,0,1,170,64,0,0,0,0,0,0,0,0,0,0,106,64,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,
  // 0x012e  Į
  12,39,117,14,1,246,106,170,169,127,255,254,127,255,254,11,255,228,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,1,255,128,127,255,253,127,255,254,127,255,254,0,3,240,0,15,192,0,47,64,0,63,0,0,127,0,0,127,0,0,127,237,0,63,254,0,11,253,0,0,0,
  // 0x012f  į
  8,40,80,11,1,246,2,160,11,248,15,252,15,248,7,240,0,0,0,0,0,0,6,164,11,248,11,248,11,248,11,248,11,248,11,248,11,248,11,248,11,248,11,248,11,248,11,248,11,248,11,248,11,248,11,248,11,248,11,248,11,248,11,248,11,248,7,240,15,192,63,0,126,0,190,0,191,0,127,237,63,253,11,252,0,0,
  // 0x0130  İ
  12,37,111,14,1,0,0,41,0,0,255,64,0,255,64,0,255,64,0,190,0,0,0,0,0,0,0,0,0,0,106,170,169,127,255,254,127,255,254,11,255,228,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,1,255,128,127,255,253,127,255,254,127,255,254,
  // 0x0131  ı
  5,22,44,11,3,0,106,64,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,
  // 0x0132  Ĳ
  21,37,222,26,1,248,106,170,169,0,42,128,127,255,254,0,63,192,127,255,254,0,63,192,11,255,228,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,0,255,0,0,63,192,1,255,128,0,63,192,127,255,253,0,63,192,127,255,254,0,63,192,127,255,254,0,63,192,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,255,128,0,0,0,3,255,64,0,0,15,255,255,0,0,0,15,255,252,0,0,0,15,255,240,0,0,0,6,250,64,0,
  // 0x0133  ĳ
  16,40,160,22,3,246,42,0,0,164,191,128,3,253,255,192,3,254,255,128,3,254,127,0,1,252,0,0,0,0,0,0,0,0,0,0,0,0,106,64,1,168,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,191,128,3,253,0,0,3,253,0,0,3,253,0,0,3,253,0,0,3,253,0,0,3,253,0,0,11,252,0,31,255,248,0,31,255,240,0,31,255,192,0,5,164,0,
  // 0x0134  Ĵ
  16,46,184,12,253,248,0,6,168,0,0,31,255,0,0,63,255,128,0,255,127,208,2,253,15,244,11,244,2,253,31,128,0,126,0,0,0,0,0,0,0,0,0,2,168,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,7,252,0,0,11,252,0,0,15,248,0,0,63,240,0,255,255,224,0,255,255,192,0,255,254,0,0,111,160,0,0,
  // 0x0135  ĵ
  16,41,164,11,253,246,0,10,168,0,0,47,253,0,0,127,255,64,1,255,127,192,3,252,31,240,15,224,3,252,47,64,0,189,0,0,0,0,0,0,0,0,0,6,164,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,15,244,0,0,47,240,0,127,255,240,0,127,255,192,0,127,255,64,0,22,148,0,0,
  // 0x0136  Ķ
  21,38,228,25,4,247,170,0,0,0,170,64,255,0,0,3,255,0,255,0,0,15,252,0,255,0,0,47,244,0,255,0,0,127,208,0,255,0,1,255,128,0,255,0,3,254,0,0,255,0,15,252,0,0,255,0,63,240,0,0,255,0,255,192,0,0,255,2,255,0,0,0,255,11,253,0,0,0,255,31,244,0,0,0,255,127,244,0,0,0,255,255,252,0,0,0,255,255,255,0,0,0,255,242,255,128,0,0,255,192,255,208,0,0,255,0,63,240,0,0,255,0,31,248,0,0,255,0,15,253,0,0,255,0,3,255,0,0,255,0,1,255,128,0,255,0,0,191,208,0,255,0,0,63,240,0,255,0,0,15,252,0,255,0,0,11,254,0,255,0,0,3,255,0,255,0,0,0,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,0,0,255,0,0,0,0,1,254,0,0,0,0,2,252,0,0,0,0,3,244,0,0,0,0,3,240,0,0,0,0,7,192,0,0,0,
  // 0x0137  ķ
  19,40,200,22,3,247,85,0,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,26,160,191,128,0,127,224,191,128,1,255,128,191,128,3,254,0,191,128,15,248,0,191,128,63,240,0,191,128,255,192,0,191,67,255,0,0,191,79,252,0,0,191,111,240,0,0,191,191,244,0,0,191,255,252,0,0,191,255,255,0,0,191,224,255,128,0,191,128,127,208,0,191,128,47,244,0,191,128,15,252,0,191,128,3,254,0,191,128,1,255,64,191,128,0,191,208,191,128,0,63,240,191,128,0,31,248,0,0,0,0,0,0,0,0,0,0,0,2,168,0,0,0,7,248,0,0,0,7,244,0,0,0,11,240,0,0,0,15,208,0,0,0,31,128,0,0,0,31,0,0,0,
  // 0x0138  ĸ
  19,22,110,22,3,0,106,64,0,26,160,191,128,0,127,224,191,128,0,255,128,191,128,3,255,0,191,128,15,252,0,191,128,47,240,0,191,128,191,208,0,191,129,255,64,0,191,131,254,0,0,191,143,248,0,0,191,191,248,0,0,191,255,253,0,0,191,255,255,0,0,191,244,255,192,0,191,192,127,224,0,191,128,47,244,0,191,128,15,252,0,191,128,3,255,0,191,128,1,255,128,191,128,0,191,208,191,128,0,63,240,191,128,0,15,248,
  // 0x0139  Ĺ
  18,38,190,21,3,0,0,106,144,0,0,0,255,192,0,0,2,255,0,0,0,7,252,0,0,0,15,240,0,0,0,63,192,0,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,128,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,250,170,170,128,63,255,255,255,208,63,255,255,255,208,63,255,255,255,208,
  // 0x013a  ĺ
  9,40,120,11,3,0,0,170,128,2,255,64,3,254,0,15,248,0,47,224,0,127,64,0,189,0,0,0,0,0,0,0,0,85,0,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,
  // 0x013b  Ļ
  17,38,190,21,4,247,170,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,234,170,170,0,255,255,255,255,64,255,255,255,255,64,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,2,164,0,0,0,7,248,0,0,0,11,240,0,0,0,15,224,0,0,0,15,192,0,0,0,31,128,0,0,0,47,0,0,0,
  // 0x013c  ļ
  6,40,80,11,2,247,21,64,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,47,224,0,0,0,0,10,160,15,240,15,224,31,192,63,128,63,0,125,0,
  // 0x013d  Ľ
  17,29,145,21,4,0,170,0,0,106,64,255,0,0,191,64,255,0,0,255,0,255,0,0,254,0,255,0,0,252,0,255,0,1,244,0,255,0,2,240,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,234,170,170,0,255,255,255,255,64,255,255,255,255,64,255,255,255,255,64,
  // 0x013e  ľ
  12,31,93,11,3,0,85,1,84,191,130,253,191,131,252,191,131,244,191,135,240,191,139,208,191,143,192,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,
  // 0x013f  Ŀ
  17,29,145,21,4,0,170,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,6,144,0,255,0,15,240,0,255,0,31,244,0,255,0,31,240,0,255,0,11,224,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,234,170,170,0,255,255,255,255,64,255,255,255,255,64,255,255,255,255,64,
  // 0x0140  ŀ
  11,31,93,12,3,0,85,0,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,130,144,191,143,244,191,143,248,191,143,248,191,135,240,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,
  // 0x0141  Ł
  21,29,174,21,0,0,0,170,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,192,0,0,0,255,11,224,0,0,0,255,191,240,0,0,0,255,255,208,0,0,0,255,254,0,0,0,2,255,240,0,0,0,31,255,64,0,0,0,127,255,0,0,0,0,63,255,0,0,0,0,30,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,234,170,170,0,0,255,255,255,255,64,0,255,255,255,255,64,0,255,255,255,255,64,
  // 0x0142  ł
  11,31,93,11,0,0,1,84,0,3,253,0,3,253,0,3,253,0,3,253,0,3,253,0,3,253,0,3,253,0,3,253,0,3,253,0,3,253,0,3,253,0,3,253,32,3,254,244,3,255,252,3,255,244,7,255,192,47,254,0,255,253,0,255,253,0,59,253,0,3,253,0,3,253,0,3,253,0,3,253,0,3,253,0,3,253,0,3,253,0,3,253,0,3,253,0,3,253,0,
  // 0x0143  Ń
  23,38,228,31,4,0,0,0,0,42,160,0,0,0,0,127,224,0,0,0,0,255,128,0,0,0,3,254,0,0,0,0,7,248,0,0,0,0,15,224,0,0,0,0,47,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,128,0,0,1,168,255,224,0,0,3,252,255,244,0,0,3,252,255,252,0,0,3,252,255,254,0,0,3,252,255,255,0,0,3,252,254,255,192,0,3,252,253,127,208,0,3,252,254,63,240,0,3,252,254,15,248,0,3,252,254,11,253,0,3,252,254,3,255,0,3,252,254,1,255,128,3,252,254,0,191,192,3,252,254,0,63,240,3,252,254,0,31,244,3,252,254,0,15,252,2,252,254,0,3,254,2,252,254,0,2,255,66,252,254,0,0,255,194,252,254,0,0,127,226,252,254,0,0,47,242,252,254,0,0,15,254,252,254,0,0,7,255,252,254,0,0,3,255,252,254,0,0,0,255,252,254,0,0,0,191,252,254,0,0,0,63,252,254,0,0,0,31,252,
  // 0x0144  ń
  19,31,155,25,3,0,0,0,2,170,0,0,0,7,254,0,0,0,15,248,0,0,0,47,224,0,0,0,127,128,0,0,0,254,0,0,0,2,244,0,0,0,0,0,0,0,0,0,0,0,0,105,0,191,228,0,191,11,255,255,64,191,63,255,255,208,191,255,170,255,240,191,248,0,47,248,191,240,0,15,252,191,208,0,7,252,191,192,0,7,252,191,192,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,
  // 0x0145  Ņ
  23,38,228,31,4,247,170,128,0,0,1,168,255,224,0,0,3,252,255,244,0,0,3,252,255,252,0,0,3,252,255,254,0,0,3,252,255,255,0,0,3,252,254,255,192,0,3,252,253,127,208,0,3,252,254,63,240,0,3,252,254,15,248,0,3,252,254,11,253,0,3,252,254,3,255,0,3,252,254,1,255,128,3,252,254,0,191,192,3,252,254,0,63,240,3,252,254,0,31,244,3,252,254,0,15,252,2,252,254,0,3,254,2,252,254,0,2,255,66,252,254,0,0,255,194,252,254,0,0,127,226,252,254,0,0,47,242,252,254,0,0,15,254,252,254,0,0,7,255,252,254,0,0,3,255,252,254,0,0,0,255,252,254,0,0,0,191,252,254,0,0,0,63,252,254,0,0,0,31,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,160,0,0,0,0,15,240,0,0,0,0,15,224,0,0,0,0,31,192,0,0,0,0,47,128,0,0,0,0,63,0,0,0,0,0,61,0,0,0,
  // 0x0146  ņ
  19,31,155,25,3,247,105,0,191,228,0,191,11,255,255,64,191,63,255,255,208,191,255,170,255,240,191,248,0,47,248,191,240,0,15,252,191,208,0,7,252,191,192,0,7,252,191,192,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,0,0,0,0,0,0,0,0,0,0,0,0,106,0,0,0,0,255,0,0,0,0,254,0,0,0,1,252,0,0,0,2,248,0,0,0,3,240,0,0,0,3,208,0,0,
  // 0x0147  Ň
  23,38,228,31,4,0,0,105,0,1,164,0,0,63,128,11,240,0,0,31,240,63,208,0,0,7,253,255,64,0,0,1,255,253,0,0,0,0,191,248,0,0,0,0,47,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,128,0,0,1,168,255,224,0,0,3,252,255,244,0,0,3,252,255,252,0,0,3,252,255,254,0,0,3,252,255,255,0,0,3,252,254,255,192,0,3,252,253,127,208,0,3,252,254,63,240,0,3,252,254,15,248,0,3,252,254,11,253,0,3,252,254,3,255,0,3,252,254,1,255,128,3,252,254,0,191,192,3,252,254,0,63,240,3,252,254,0,31,244,3,252,254,0,15,252,2,252,254,0,3,254,2,252,254,0,2,255,66,252,254,0,0,255,194,252,254,0,0,127,226,252,254,0,0,47,242,252,254,0,0,15,254,252,254,0,0,7,255,252,254,0,0,3,255,252,254,0,0,0,255,252,254,0,0,0,191,252,254,0,0,0,63,252,254,0,0,0,31,252,
  // 0x0148  ň
  19,31,155,25,3,0,6,144,0,26,128,3,248,0,191,64,0,255,3,253,0,0,127,223,244,0,0,31,255,208,0,0,11,255,128,0,0,2,254,0,0,0,0,0,0,0,0,0,0,0,0,105,0,191,228,0,191,11,255,255,64,191,63,255,255,208,191,255,170,255,240,191,248,0,47,248,191,240,0,15,252,191,208,0,7,252,191,192,0,7,252,191,192,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,
  // 0x0149  ŉ
  26,29,203,28,0,0,10,164,0,0,0,0,0,15,244,0,0,0,0,0,31,240,0,0,0,0,0,47,240,0,0,0,0,0,47,208,0,0,0,0,0,63,192,0,0,0,0,0,63,128,0,0,0,0,0,127,66,160,6,255,128,0,191,7,240,127,255,248,0,253,7,245,255,255,255,0,0,7,255,254,175,255,64,0,7,255,192,1,255,192,0,7,255,0,0,191,192,0,7,254,0,0,63,192,0,7,253,0,0,63,208,0,7,252,0,0,63,208,0,7,252,0,0,63,208,0,7,252,0,0,63,208,0,7,252,0,0,63,208,0,7,252,0,0,63,208,0,7,252,0,0,63,208,0,7,252,0,0,63,208,0,7,252,0,0,63,208,0,7,252,0,0,63,208,0,7,252,0,0,63,208,0,7,252,0,0,63,208,0,7,252,0,0,63,208,0,7,252,0,0,63,208,0,7,252,0,0,63,208,
  // 0x014a  Ŋ
  23,37,222,31,4,248,170,128,0,0,1,168,255,224,0,0,3,252,255,244,0,0,3,252,255,252,0,0,3,252,255,254,0,0,3,252,255,255,64,0,3,252,254,255,192,0,3,252,254,127,240,0,3,252,254,47,244,0,3,252,254,15,252,0,3,252,254,7,255,0,3,252,254,2,255,64,3,252,254,0,255,192,3,252,254,0,127,240,3,252,254,0,47,244,3,252,254,0,15,252,2,252,254,0,3,255,2,252,254,0,2,255,130,252,254,0,0,255,194,252,254,0,0,63,242,252,254,0,0,31,250,252,254,0,0,15,254,252,254,0,0,3,255,252,254,0,0,1,255,252,254,0,0,0,191,252,254,0,0,0,63,252,254,0,0,0,31,252,254,0,0,0,11,252,254,0,0,0,3,252,0,0,0,0,2,252,0,0,0,0,3,252,0,0,0,0,7,252,0,0,0,0,31,248,0,0,0,255,255,240,0,0,0,255,255,208,0,0,0,255,255,64,0,0,0,111,228,0,
  // 0x014b  ŋ
  19,32,160,25,3,246,105,0,191,228,0,191,11,255,255,64,191,47,255,255,224,191,255,234,255,240,191,248,0,47,248,191,240,0,15,252,191,208,0,7,252,191,192,0,7,252,191,192,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,7,252,0,0,0,7,252,0,0,0,15,248,0,0,15,255,244,0,0,15,255,224,0,0,15,255,128,0,0,5,164,0,
  // 0x014c  Ō
  27,36,252,31,2,255,0,0,85,85,85,0,0,0,1,255,255,255,0,0,0,1,255,255,255,0,0,0,1,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x014d  ō
  21,29,174,24,2,255,0,85,85,85,0,0,0,255,255,255,64,0,0,255,255,255,64,0,0,191,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x014e  Ŏ
  27,38,10,31,2,255,0,3,224,0,31,64,0,0,2,240,0,63,0,0,0,1,254,170,254,0,0,0,0,191,255,252,0,0,0,0,47,255,240,0,0,0,0,2,170,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x014f  ŏ
  21,31,186,24,2,255,1,240,0,15,128,0,0,248,0,31,128,0,0,255,170,255,0,0,0,127,255,253,0,0,0,31,255,244,0,0,0,1,170,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x0150  Ő
  27,39,17,31,2,255,0,0,26,160,42,128,0,0,0,63,224,191,192,0,0,0,191,128,255,0,0,0,0,255,3,252,0,0,0,2,252,7,240,0,0,0,7,240,15,192,0,0,0,11,128,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x0151  ő
  21,32,192,24,2,255,0,10,164,42,160,0,0,31,240,63,208,0,0,63,208,255,64,0,0,191,65,254,0,0,1,253,3,248,0,0,3,244,11,224,0,0,7,208,15,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x0152  Œ
  34,30,14,38,2,255,0,0,107,255,170,170,170,170,128,0,7,255,255,255,255,255,255,208,0,47,255,255,255,255,255,255,208,0,255,255,239,255,255,255,255,208,2,255,224,0,47,240,0,0,0,7,255,0,0,31,240,0,0,0,15,252,0,0,31,240,0,0,0,31,244,0,0,31,240,0,0,0,47,240,0,0,31,240,0,0,0,63,224,0,0,31,240,0,0,0,63,208,0,0,31,240,0,0,0,127,192,0,0,31,240,0,0,0,127,192,0,0,31,250,170,170,64,191,192,0,0,31,255,255,255,128,191,192,0,0,31,255,255,255,128,191,192,0,0,31,255,255,255,64,191,192,0,0,31,240,0,0,0,127,192,0,0,31,240,0,0,0,127,208,0,0,31,240,0,0,0,63,208,0,0,31,240,0,0,0,63,240,0,0,31,240,0,0,0,47,244,0,0,31,240,0,0,0,15,252,0,0,31,240,0,0,0,11,254,0,0,31,240,0,0,0,3,255,128,0,31,240,0,0,0,1,255,253,85,191,250,170,170,128,0,127,255,255,255,255,255,255,208,0,11,255,255,255,255,255,255,208,0,1,191,255,255,255,255,255,208,0,0,1,85,0,0,0,0,0,
  // 0x0153  œ
  34,23,207,38,2,255,0,6,255,144,0,10,254,64,0,0,127,255,252,0,191,255,244,0,2,255,255,255,67,255,255,254,0,11,255,171,255,223,254,91,255,64,31,248,0,47,255,240,0,191,192,63,240,0,15,255,192,0,63,208,127,192,0,3,255,128,0,31,240,191,192,0,3,255,0,0,15,240,191,128,0,2,255,0,0,15,240,255,128,0,2,255,255,255,255,240,255,64,0,1,255,255,255,255,240,255,64,0,1,255,255,255,255,240,255,64,0,1,255,0,0,0,0,255,128,0,2,255,0,0,0,0,191,192,0,2,255,0,0,0,0,127,192,0,3,255,128,0,0,0,63,224,0,7,255,192,0,0,0,47,244,0,15,255,240,0,0,64,15,254,64,191,255,254,0,27,192,3,255,255,255,199,255,255,255,192,0,255,255,254,0,255,255,255,192,0,31,255,244,0,31,255,254,0,0,0,85,0,0,0,85,64,0,
  // 0x0154  Ŕ
  21,38,228,25,4,0,0,0,6,169,0,0,0,0,15,252,0,0,0,0,63,240,0,0,0,0,191,192,0,0,0,0,255,0,0,0,0,3,248,0,0,0,0,7,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,148,0,0,0,255,255,255,228,0,0,255,255,255,254,0,0,255,255,255,255,192,0,255,0,22,255,224,0,255,0,0,127,240,0,255,0,0,31,244,0,255,0,0,15,244,0,255,0,0,15,244,0,255,0,0,15,244,0,255,0,0,15,244,0,255,0,0,47,240,0,255,0,0,127,224,0,255,64,23,255,192,0,255,255,255,255,0,0,255,255,255,248,0,0,255,255,255,192,0,0,255,149,127,224,0,0,255,0,31,244,0,0,255,0,11,252,0,0,255,0,3,254,0,0,255,0,2,255,0,0,255,0,0,255,192,0,255,0,0,127,208,0,255,0,0,47,240,0,255,0,0,15,248,0,255,0,0,11,253,0,255,0,0,3,255,0,255,0,0,1,255,128,
  // 0x0155  ŕ
  14,31,124,17,3,0,0,0,106,144,0,0,255,192,0,3,255,0,0,11,252,0,0,15,240,0,0,63,128,0,0,126,0,0,0,0,0,0,0,0,0,0,105,0,127,192,191,3,255,192,191,15,255,192,191,63,255,192,191,255,64,0,191,248,0,0,191,240,0,0,191,192,0,0,191,192,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,
  // 0x0156  Ŗ
  21,38,228,25,4,247,170,170,148,0,0,0,255,255,255,228,0,0,255,255,255,254,0,0,255,255,255,255,192,0,255,0,22,255,224,0,255,0,0,127,240,0,255,0,0,31,244,0,255,0,0,15,244,0,255,0,0,15,244,0,255,0,0,15,244,0,255,0,0,15,244,0,255,0,0,47,240,0,255,0,0,127,224,0,255,64,23,255,192,0,255,255,255,255,0,0,255,255,255,248,0,0,255,255,255,192,0,0,255,149,127,224,0,0,255,0,31,244,0,0,255,0,11,252,0,0,255,0,3,254,0,0,255,0,2,255,0,0,255,0,0,255,192,0,255,0,0,127,208,0,255,0,0,47,240,0,255,0,0,15,248,0,255,0,0,11,253,0,255,0,0,3,255,0,255,0,0,1,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,0,0,0,0,0,255,0,0,0,0,0,254,0,0,0,0,1,252,0,0,0,0,2,248,0,0,0,0,3,240,0,0,0,0,3,208,0,0,0,
  // 0x0157  ŗ
  14,31,124,17,2,247,26,64,31,240,47,192,255,240,47,195,255,240,47,207,255,240,47,255,208,0,47,254,0,0,47,252,0,0,47,240,0,0,47,240,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,0,0,0,0,0,0,0,0,10,160,0,0,15,240,0,0,31,224,0,0,47,192,0,0,63,64,0,0,63,0,0,0,124,0,0,0,
  // 0x0158  Ř
  21,38,228,25,4,0,26,64,0,42,0,0,15,240,1,253,0,0,3,252,11,244,0,0,0,255,127,224,0,0,0,127,255,128,0,0,0,31,255,0,0,0,0,11,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,148,0,0,0,255,255,255,228,0,0,255,255,255,254,0,0,255,255,255,255,192,0,255,0,22,255,224,0,255,0,0,127,240,0,255,0,0,31,244,0,255,0,0,15,244,0,255,0,0,15,244,0,255,0,0,15,244,0,255,0,0,15,244,0,255,0,0,47,240,0,255,0,0,127,224,0,255,64,23,255,192,0,255,255,255,255,0,0,255,255,255,248,0,0,255,255,255,192,0,0,255,149,127,224,0,0,255,0,31,244,0,0,255,0,11,252,0,0,255,0,3,254,0,0,255,0,2,255,0,0,255,0,0,255,192,0,255,0,0,127,208,0,255,0,0,47,240,0,255,0,0,15,248,0,255,0,0,11,253,0,255,0,0,3,255,0,255,0,0,1,255,128,
  // 0x0159  ř
  15,31,124,17,2,0,105,0,0,168,63,192,7,244,15,240,47,208,3,253,255,128,1,255,254,0,0,127,252,0,0,47,240,0,0,0,0,0,0,0,0,0,26,64,31,240,47,192,255,240,47,195,255,240,47,207,255,240,47,255,208,0,47,254,0,0,47,252,0,0,47,240,0,0,47,240,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,
  // 0x015a  Ś
  18,39,195,22,2,255,0,0,2,170,0,0,0,11,253,0,0,0,15,244,0,0,0,63,208,0,0,0,191,64,0,0,1,253,0,0,0,2,244,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,164,0,1,255,255,255,128,11,255,255,255,208,31,255,255,255,192,63,244,0,27,128,127,208,0,0,0,191,192,0,0,0,191,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,240,0,0,0,47,253,0,0,0,15,255,224,0,0,3,255,254,0,0,0,191,255,224,0,0,11,255,253,0,0,0,127,255,64,0,0,7,255,192,0,0,0,191,224,0,0,0,47,240,0,0,0,31,240,0,0,0,15,240,0,0,0,15,240,0,0,0,47,240,224,0,0,127,224,255,165,91,255,192,255,255,255,255,0,255,255,255,252,0,47,255,255,144,0,0,21,80,0,0,
  // 0x015b  ś
  16,32,128,19,2,255,0,0,42,160,0,0,127,224,0,0,255,192,0,2,255,0,0,7,248,0,0,15,224,0,0,31,64,0,0,0,0,0,0,0,0,0,0,111,254,64,11,255,255,248,63,255,255,252,191,249,91,244,255,128,0,96,255,0,0,0,255,64,0,0,255,208,0,0,127,253,0,0,47,255,208,0,7,255,254,0,0,191,255,208,0,7,255,244,0,0,127,252,0,0,7,253,0,0,2,254,0,0,2,254,64,0,3,253,249,0,11,252,255,255,255,248,255,255,255,224,111,255,254,0,0,85,64,0,
  // 0x015c  Ŝ
  18,39,195,22,2,255,0,2,170,0,0,0,11,255,64,0,0,47,255,192,0,0,127,223,240,0,0,255,7,252,0,3,248,0,255,0,11,208,0,47,64,0,0,0,0,0,0,0,0,0,0,0,27,255,164,0,1,255,255,255,128,11,255,255,255,208,31,255,255,255,192,63,244,0,27,128,127,208,0,0,0,191,192,0,0,0,191,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,240,0,0,0,47,253,0,0,0,15,255,224,0,0,3,255,254,0,0,0,191,255,224,0,0,11,255,253,0,0,0,127,255,64,0,0,7,255,192,0,0,0,191,224,0,0,0,47,240,0,0,0,31,240,0,0,0,15,240,0,0,0,15,240,0,0,0,47,240,224,0,0,127,224,255,165,91,255,192,255,255,255,255,0,255,255,255,252,0,47,255,255,144,0,0,21,80,0,0,
  // 0x015d  ŝ
  16,32,128,19,2,255,0,42,160,0,0,127,248,0,0,255,254,0,3,253,255,64,15,244,63,208,63,192,11,240,126,0,1,248,0,0,0,0,0,0,0,0,0,111,254,64,11,255,255,248,63,255,255,252,191,249,91,244,255,128,0,96,255,0,0,0,255,64,0,0,255,208,0,0,127,253,0,0,47,255,208,0,7,255,254,0,0,191,255,208,0,7,255,244,0,0,127,252,0,0,7,253,0,0,2,254,0,0,2,254,64,0,3,253,249,0,11,252,255,255,255,248,255,255,255,224,111,255,254,0,0,85,64,0,
  // 0x015e  Ş
  18,39,195,22,2,246,0,27,255,164,0,1,255,255,255,128,11,255,255,255,208,31,255,255,255,192,63,244,0,27,128,127,208,0,0,0,191,192,0,0,0,191,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,240,0,0,0,47,253,0,0,0,15,255,224,0,0,3,255,254,0,0,0,191,255,224,0,0,11,255,253,0,0,0,127,255,64,0,0,7,255,192,0,0,0,191,224,0,0,0,47,240,0,0,0,31,240,0,0,0,15,240,0,0,0,15,240,0,0,0,47,240,224,0,0,127,224,255,165,91,255,192,255,255,255,255,0,255,255,255,252,0,47,255,255,144,0,0,23,240,0,0,0,7,208,0,0,0,15,248,0,0,0,7,255,0,0,0,0,127,64,0,0,0,63,128,0,0,0,127,64,0,0,191,255,0,0,0,191,252,0,0,0,106,64,0,0,
  // 0x015f  ş
  16,32,128,19,2,246,0,111,254,64,11,255,255,248,63,255,255,252,191,249,91,244,255,128,0,96,255,0,0,0,255,64,0,0,255,208,0,0,127,253,0,0,47,255,208,0,7,255,254,0,0,191,255,208,0,7,255,244,0,0,127,252,0,0,7,253,0,0,2,254,0,0,2,254,64,0,3,253,249,0,11,252,255,255,255,248,255,255,255,224,111,255,254,0,0,95,208,0,0,15,128,0,0,47,224,0,0,27,252,0,0,0,254,0,0,0,191,0,0,0,254,0,1,255,253,0,1,255,244,0,0,169,64,0,
  // 0x0160  Š
  18,39,195,22,2,255,10,144,0,26,64,7,248,0,191,0,1,254,3,252,0,0,127,223,240,0,0,47,255,208,0,0,15,255,64,0,0,3,254,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,164,0,1,255,255,255,128,11,255,255,255,208,31,255,255,255,192,63,244,0,27,128,127,208,0,0,0,191,192,0,0,0,191,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,240,0,0,0,47,253,0,0,0,15,255,224,0,0,3,255,254,0,0,0,191,255,224,0,0,11,255,253,0,0,0,127,255,64,0,0,7,255,192,0,0,0,191,224,0,0,0,47,240,0,0,0,31,240,0,0,0,15,240,0,0,0,15,240,0,0,0,47,240,224,0,0,127,224,255,165,91,255,192,255,255,255,255,0,255,255,255,252,0,47,255,255,144,0,0,21,80,0,0,
  // 0x0161  š
  16,32,128,19,2,255,105,0,0,168,63,192,11,244,15,240,47,208,3,253,255,128,1,255,254,0,0,127,252,0,0,47,240,0,0,0,0,0,0,0,0,0,0,111,254,64,11,255,255,248,63,255,255,252,191,249,91,244,255,128,0,96,255,0,0,0,255,64,0,0,255,208,0,0,127,253,0,0,47,255,208,0,7,255,254,0,0,191,255,208,0,7,255,244,0,0,127,252,0,0,7,253,0,0,2,254,0,0,2,254,64,0,3,253,249,0,11,252,255,255,255,248,255,255,255,224,111,255,254,0,0,85,64,0,
  // 0x0162  Ţ
  22,39,234,23,0,246,106,170,170,170,170,160,127,255,255,255,255,240,127,255,255,255,255,240,127,255,255,255,255,240,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,15,128,0,0,0,0,47,64,0,0,0,0,63,224,0,0,0,0,31,252,0,0,0,0,1,253,0,0,0,0,0,253,0,0,0,0,1,253,0,0,0,2,255,252,0,0,0,2,255,240,0,0,0,1,169,0,0,0,
  // 0x0163  ţ
  15,37,148,15,0,246,0,21,0,0,0,63,0,0,0,127,0,0,0,191,0,0,0,255,0,0,2,255,170,160,47,255,255,240,127,255,255,240,43,255,170,160,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,0,255,0,0,0,255,64,0,0,255,208,16,0,191,255,244,0,63,255,244,0,11,255,240,0,1,249,0,0,3,240,0,0,7,253,0,0,6,255,128,0,0,47,192,0,0,31,192,0,0,47,192,0,63,255,128,0,63,254,0,0,26,144,0,
  // 0x0164  Ť
  22,38,228,23,0,0,0,168,0,2,164,0,0,127,64,15,240,0,0,31,224,63,192,0,0,11,249,255,0,0,0,2,255,252,0,0,0,0,255,244,0,0,0,0,63,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,170,170,170,170,160,127,255,255,255,255,240,127,255,255,255,255,240,127,255,255,255,255,240,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,
  // 0x0165  ť
  20,32,160,15,0,255,0,0,0,0,85,0,0,0,0,255,0,0,0,1,253,0,0,0,2,252,0,21,0,3,244,0,63,0,3,240,0,127,0,7,208,0,191,0,0,0,0,255,0,0,0,2,255,170,160,0,47,255,255,240,0,127,255,255,240,0,43,255,170,160,0,1,255,0,0,0,1,255,0,0,0,1,255,0,0,0,1,255,0,0,0,1,255,0,0,0,1,255,0,0,0,1,255,0,0,0,1,255,0,0,0,1,255,0,0,0,1,255,0,0,0,1,255,0,0,0,1,255,0,0,0,0,255,0,0,0,0,255,64,0,0,0,255,208,16,0,0,191,255,244,0,0,63,255,244,0,0,11,255,240,0,0,0,21,0,0,
  // 0x0166  Ŧ
  22,29,174,23,0,0,106,170,170,170,170,160,127,255,255,255,255,240,127,255,255,255,255,240,127,255,255,255,255,240,0,0,63,224,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,2,255,255,255,252,0,2,255,255,255,252,0,2,255,255,255,252,0,0,85,127,229,84,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,
  // 0x0167  ŧ
  15,28,112,15,0,255,0,21,0,0,0,63,0,0,0,127,0,0,0,191,0,0,0,255,0,0,2,255,170,160,47,255,255,240,127,255,255,240,43,255,170,160,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,47,255,255,224,63,255,255,224,63,255,255,224,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,0,255,0,0,0,255,64,0,0,255,208,16,0,191,255,244,0,63,255,244,0,11,255,240,0,0,21,0,
  // 0x0168  Ũ
  23,38,228,30,3,255,0,1,164,0,40,0,0,15,255,64,124,0,0,63,255,246,252,0,0,63,175,255,244,0,0,188,2,255,224,0,0,180,0,42,64,0,0,0,0,0,0,0,0,0,0,0,0,0,42,64,0,0,2,168,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,63,208,0,0,11,248,63,224,0,0,15,244,47,244,0,0,47,240,15,253,0,0,191,224,7,255,229,91,255,192,2,255,255,255,255,0,0,127,255,255,248,0,0,11,255,255,144,0,0,0,21,80,0,0,
  // 0x0169  ũ
  19,31,155,25,3,255,0,25,0,2,128,0,255,224,11,192,3,255,254,111,128,7,250,255,255,0,15,192,47,253,0,11,64,2,160,0,0,0,0,0,0,0,0,0,0,0,106,0,0,2,164,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,11,252,255,64,0,11,252,255,128,0,15,252,191,192,0,31,252,191,208,0,63,252,63,248,6,255,252,47,255,255,247,252,15,255,255,211,252,1,255,254,2,252,0,5,80,0,0,
  // 0x016a  Ū
  23,36,216,30,3,255,0,5,85,85,80,0,0,31,255,255,240,0,0,31,255,255,240,0,0,31,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,42,64,0,0,2,168,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,63,208,0,0,11,248,63,224,0,0,15,244,47,244,0,0,47,240,15,253,0,0,191,224,7,255,229,91,255,192,2,255,255,255,255,0,0,127,255,255,248,0,0,11,255,255,144,0,0,0,21,80,0,0,
  // 0x016b  ū
  19,29,145,25,3,255,0,85,85,85,0,2,255,255,254,0,2,255,255,254,0,1,255,255,254,0,0,0,0,0,0,0,0,0,0,0,106,0,0,2,164,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,11,252,255,64,0,11,252,255,128,0,15,252,191,192,0,31,252,191,208,0,63,252,63,248,6,255,252,47,255,255,247,252,15,255,255,211,252,1,255,254,2,252,0,5,80,0,0,
  // 0x016c  Ŭ
  23,38,228,30,3,255,0,62,0,0,244,0,0,47,0,2,240,0,0,31,234,175,224,0,0,11,255,255,192,0,0,2,255,255,0,0,0,0,42,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,64,0,0,2,168,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,63,208,0,0,11,248,63,224,0,0,15,244,47,244,0,0,47,240,15,253,0,0,191,224,7,255,229,91,255,192,2,255,255,255,255,0,0,127,255,255,248,0,0,11,255,255,144,0,0,0,21,80,0,0,
  // 0x016d  ŭ
  19,31,155,25,3,255,3,224,0,31,0,3,240,0,63,0,1,254,170,254,0,0,255,255,252,0,0,63,255,224,0,0,6,170,0,0,0,0,0,0,0,0,0,0,0,0,106,0,0,2,164,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,11,252,255,64,0,11,252,255,128,0,15,252,191,192,0,31,252,191,208,0,63,252,63,248,6,255,252,47,255,255,247,252,15,255,255,211,252,1,255,254,2,252,0,5,80,0,0,
  // 0x016e  Ů
  23,41,246,30,3,255,0,0,31,224,0,0,0,0,191,253,0,0,0,1,249,127,0,0,0,2,240,31,0,0,0,2,224,15,64,0,0,2,240,31,0,0,0,1,253,191,0,0,0,0,191,252,0,0,0,0,26,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,64,0,0,2,168,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,63,208,0,0,11,248,63,224,0,0,15,244,47,244,0,0,47,240,15,253,0,0,191,224,7,255,229,91,255,192,2,255,255,255,255,0,0,127,255,255,248,0,0,11,255,255,144,0,0,0,21,80,0,0,
  // 0x016f  ů
  19,34,170,25,3,255,0,2,254,0,0,0,15,255,192,0,0,47,155,224,0,0,62,2,240,0,0,61,1,240,0,0,62,2,240,0,0,47,155,224,0,0,15,255,192,0,0,1,169,0,0,0,0,0,0,0,0,0,0,0,0,106,0,0,2,164,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,11,252,255,64,0,11,252,255,128,0,15,252,191,192,0,31,252,191,208,0,63,252,63,248,6,255,252,47,255,255,247,252,15,255,255,211,252,1,255,254,2,252,0,5,80,0,0,
  // 0x0170  Ű
  23,39,234,30,3,255,0,1,170,2,168,0,0,3,254,11,252,0,0,7,252,15,240,0,0,15,240,63,192,0,0,47,192,127,0,0,0,127,0,252,0,0,0,184,1,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,64,0,0,2,168,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,63,208,0,0,11,248,63,224,0,0,15,244,47,244,0,0,47,240,15,253,0,0,191,224,7,255,229,91,255,192,2,255,255,255,255,0,0,127,255,255,248,0,0,11,255,255,144,0,0,0,21,80,0,0,
  // 0x0171  ű
  19,32,160,25,3,255,0,26,160,42,128,0,63,208,255,128,0,191,129,255,0,0,254,3,252,0,3,248,11,240,0,11,224,31,192,0,15,128,46,0,0,0,0,0,0,0,0,0,0,0,0,106,0,0,2,164,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,11,252,255,64,0,11,252,255,128,0,15,252,191,192,0,31,252,191,208,0,63,252,63,248,6,255,252,47,255,255,247,252,15,255,255,211,252,1,255,254,2,252,0,5,80,0,0,
  // 0x0172  Ų
  23,39,234,30,3,246,42,64,0,0,2,168,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,63,208,0,0,11,248,63,224,0,0,15,244,47,244,0,0,47,240,15,253,0,0,191,224,7,255,229,91,255,192,2,255,255,255,255,0,0,127,255,255,252,0,0,11,255,255,240,0,0,0,21,91,208,0,0,0,0,31,128,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,0,127,0,0,0,0,0,127,0,0,0,0,0,63,238,0,0,0,0,47,254,0,0,0,0,7,253,0,0,0,0,0,0,0,
  // 0x0173  ų
  19,32,160,25,3,246,106,0,0,2,164,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,11,252,255,64,0,11,252,255,128,0,15,252,191,192,0,31,252,191,208,0,63,252,63,248,6,255,252,47,255,255,247,252,15,255,255,211,252,1,255,254,3,252,0,5,80,11,224,0,0,0,31,128,0,0,0,63,0,0,0,0,189,0,0,0,0,253,0,0,0,0,254,0,0,0,0,255,236,0,0,0,127,252,0,0,0,31,252,0,0,0,0,0,
  // 0x0174  Ŵ
  37,38,124,38,0,0,0,0,0,0,106,128,0,0,0,0,0,0,0,1,255,240,0,0,0,0,0,0,0,3,255,248,0,0,0,0,0,0,0,15,247,253,0,0,0,0,0,0,0,47,208,255,64,0,0,0,0,0,0,191,64,47,208,0,0,0,0,0,1,248,0,7,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,0,106,128,0,0,42,128,127,192,0,0,191,192,0,0,127,192,63,208,0,0,255,208,0,0,191,128,63,224,0,1,255,240,0,0,255,64,47,240,0,2,255,240,0,0,255,0,31,240,0,3,255,244,0,1,255,0,15,244,0,3,251,248,0,2,254,0,15,248,0,7,247,252,0,3,253,0,11,252,0,11,242,252,0,3,252,0,7,252,0,15,241,254,0,7,252,0,3,253,0,31,224,255,0,11,248,0,3,254,0,47,208,255,0,15,244,0,2,255,0,63,192,191,64,15,240,0,1,255,0,63,192,127,128,31,240,0,0,255,64,127,128,63,192,47,224,0,0,191,128,191,0,47,192,63,208,0,0,127,192,255,0,31,224,63,192,0,0,63,193,254,0,15,240,127,192,0,0,63,194,253,0,15,240,191,128,0,0,47,211,252,0,11,244,255,64,0,0,31,227,252,0,7,248,255,0,0,0,15,243,248,0,3,252,254,0,0,0,15,247,240,0,2,253,253,0,0,0,11,255,240,0,1,254,252,0,0,0,7,255,224,0,0,255,252,0,0,0,3,255,208,0,0,255,248,0,0,0,3,255,192,0,0,191,244,0,0,0,2,255,192,0,0,127,240,0,0,0,1,255,128,0,0,63,240,0,0,
  // 0x0175  ŵ
  32,31,248,32,0,0,0,0,0,10,164,0,0,0,0,0,0,63,252,0,0,0,0,0,0,191,255,0,0,0,0,0,2,254,191,192,0,0,0,0,7,248,31,224,0,0,0,0,31,224,7,248,0,0,0,0,62,0,0,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,10,164,0,1,169,127,192,0,31,252,0,2,254,63,208,0,63,252,0,3,253,47,224,0,63,253,0,7,252,31,240,0,127,254,0,11,248,15,240,0,191,191,0,15,244,15,244,0,254,127,0,15,240,11,248,1,253,63,128,31,240,7,252,2,252,63,192,47,224,3,252,3,252,47,192,63,208,3,253,3,248,31,208,63,192,1,254,7,240,15,224,127,128,0,255,11,240,15,240,191,64,0,255,15,224,7,240,255,0,0,191,79,208,3,244,255,0,0,127,95,192,3,249,254,0,0,63,175,128,2,253,253,0,0,63,255,64,1,254,252,0,0,47,255,0,0,255,252,0,0,31,255,0,0,255,244,0,0,15,254,0,0,127,240,0,0,11,253,0,0,63,240,0,
  // 0x0176  Ŷ
  23,38,228,23,0,0,0,0,42,160,0,0,0,0,127,248,0,0,0,1,255,253,0,0,0,3,253,255,64,0,0,15,240,63,208,0,0,63,192,11,240,0,0,126,0,1,248,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,0,6,168,127,192,0,0,15,248,63,240,0,0,31,240,31,244,0,0,63,224,15,252,0,0,127,192,7,253,0,0,255,128,2,255,0,1,255,0,0,255,64,3,253,0,0,191,192,11,252,0,0,63,208,15,244,0,0,47,240,47,240,0,0,15,244,63,208,0,0,7,252,191,128,0,0,3,254,255,0,0,0,1,255,254,0,0,0,0,255,252,0,0,0,0,127,248,0,0,0,0,63,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,
  // 0x0177  ŷ
  21,41,246,21,0,246,0,0,170,128,0,0,0,2,255,224,0,0,0,7,255,244,0,0,0,15,247,253,0,0,0,63,192,255,0,0,0,255,0,63,192,0,2,248,0,11,224,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,0,106,128,191,192,0,0,255,128,63,208,0,0,255,64,47,224,0,2,255,0,31,240,0,3,254,0,15,244,0,3,252,0,11,252,0,11,252,0,3,252,0,15,244,0,2,254,0,31,240,0,1,255,0,47,224,0,0,255,64,63,208,0,0,191,128,127,192,0,0,63,192,191,128,0,0,47,208,255,0,0,0,31,225,255,0,0,0,15,242,253,0,0,0,11,243,252,0,0,0,3,251,248,0,0,0,2,255,244,0,0,0,1,255,240,0,0,0,0,255,224,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,255,64,0,0,0,1,255,0,0,0,0,3,254,0,0,0,0,7,252,0,0,0,0,47,248,0,0,0,127,255,240,0,0,0,127,255,192,0,0,0,127,254,0,0,0,0,26,144,0,0,0,0,
  // 0x0178  Ÿ
  23,37,222,23,0,0,0,1,64,1,0,0,0,15,224,31,208,0,0,15,240,47,224,0,0,15,240,31,208,0,0,7,128,11,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,0,6,168,127,192,0,0,15,248,63,240,0,0,31,240,31,244,0,0,63,224,15,252,0,0,127,192,7,253,0,0,255,128,2,255,0,1,255,0,0,255,64,3,253,0,0,191,192,11,252,0,0,63,208,15,244,0,0,47,240,47,240,0,0,15,244,63,208,0,0,7,252,191,128,0,0,3,254,255,0,0,0,1,255,254,0,0,0,0,255,252,0,0,0,0,127,248,0,0,0,0,63,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,
  // 0x0179  Ź
  21,38,228,23,1,0,0,0,0,170,128,0,0,0,1,255,128,0,0,0,3,254,0,0,0,0,11,248,0,0,0,0,31,224,0,0,0,0,63,128,0,0,0,0,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,170,170,170,170,0,63,255,255,255,255,0,63,255,255,255,255,0,63,255,255,255,255,0,0,0,0,7,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,224,0,0,0,0,255,192,0,0,0,2,255,0,0,0,0,7,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,208,0,0,0,0,255,192,0,0,0,2,255,0,0,0,0,7,253,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,208,0,0,0,0,255,192,0,0,0,2,255,0,0,0,0,7,253,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,250,170,170,170,64,191,255,255,255,255,128,191,255,255,255,255,128,191,255,255,255,255,128,
  // 0x017a  ź
  17,31,155,19,1,0,0,0,10,168,0,0,0,31,248,0,0,0,63,224,0,0,0,255,128,0,0,2,254,0,0,0,7,248,0,0,0,11,208,0,0,0,0,0,0,0,0,0,0,0,0,42,170,170,170,0,63,255,255,255,0,63,255,255,255,0,42,170,171,255,0,0,0,3,253,0,0,0,11,252,0,0,0,31,240,0,0,0,63,208,0,0,0,255,128,0,0,2,255,0,0,0,7,252,0,0,0,15,244,0,0,0,47,240,0,0,0,127,192,0,0,0,255,64,0,0,3,254,0,0,0,11,252,0,0,0,31,240,0,0,0,63,229,85,85,0,191,255,255,255,128,191,255,255,255,128,191,255,255,255,128,
  // 0x017b  Ż
  21,37,222,23,1,0,0,0,26,0,0,0,0,0,127,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,63,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,170,170,170,170,0,63,255,255,255,255,0,63,255,255,255,255,0,63,255,255,255,255,0,0,0,0,7,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,224,0,0,0,0,255,192,0,0,0,2,255,0,0,0,0,7,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,208,0,0,0,0,255,192,0,0,0,2,255,0,0,0,0,7,253,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,208,0,0,0,0,255,192,0,0,0,2,255,0,0,0,0,7,253,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,250,170,170,170,64,191,255,255,255,255,128,191,255,255,255,255,128,191,255,255,255,255,128,
  // 0x017c  ż
  17,30,150,19,1,0,0,2,160,0,0,0,11,248,0,0,0,15,252,0,0,0,11,252,0,0,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,170,170,170,0,63,255,255,255,0,63,255,255,255,0,42,170,171,255,0,0,0,3,253,0,0,0,11,252,0,0,0,31,240,0,0,0,63,208,0,0,0,255,128,0,0,2,255,0,0,0,7,252,0,0,0,15,244,0,0,0,47,240,0,0,0,127,192,0,0,0,255,64,0,0,3,254,0,0,0,11,252,0,0,0,31,240,0,0,0,63,229,85,85,0,191,255,255,255,128,191,255,255,255,128,191,255,255,255,128,
  // 0x017d  Ž
  21,38,228,23,1,0,1,164,0,6,160,0,0,254,0,47,208,0,0,63,192,191,64,0,0,15,247,253,0,0,0,7,255,248,0,0,0,2,255,240,0,0,0,0,191,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,170,170,170,170,0,63,255,255,255,255,0,63,255,255,255,255,0,63,255,255,255,255,0,0,0,0,7,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,224,0,0,0,0,255,192,0,0,0,2,255,0,0,0,0,7,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,208,0,0,0,0,255,192,0,0,0,2,255,0,0,0,0,7,253,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,208,0,0,0,0,255,192,0,0,0,2,255,0,0,0,0,7,253,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,250,170,170,170,64,191,255,255,255,255,128,191,255,255,255,255,128,191,255,255,255,255,128,
  // 0x017e  ž
  17,31,155,19,1,0,26,64,0,105,0,15,224,2,252,0,7,252,15,244,0,1,255,127,208,0,0,127,255,64,0,0,47,254,0,0,0,11,248,0,0,0,0,0,0,0,0,0,0,0,0,42,170,170,170,0,63,255,255,255,0,63,255,255,255,0,42,170,171,255,0,0,0,3,253,0,0,0,11,252,0,0,0,31,240,0,0,0,63,208,0,0,0,255,128,0,0,2,255,0,0,0,7,252,0,0,0,15,244,0,0,0,47,240,0,0,0,127,192,0,0,0,255,64,0,0,3,254,0,0,0,11,252,0,0,0,31,240,0,0,0,63,229,85,85,0,191,255,255,255,128,191,255,255,255,128,191,255,255,255,128,
  // 0x017f  ſ
  12,31,93,14,3,0,0,26,148,2,255,255,15,255,254,63,255,252,63,224,4,127,192,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,
};

#endif // HAS_GRAPHICAL_TFT
