/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Korean 40pt, capital 'A' height: 29px, width: 100%, range: 0xac70-0xd788, glyphs: 110
extern const uint8_t NotoSans_Medium_Korean_29[6128] = {
  162,29,112,172,136,215,38,246, // unifont_t
  // 0xac70  거
  112,172,30,38,48,37,2,252,0,0,0,0,0,0,5,80,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,5,85,85,85,80,0,15,240,47,255,255,255,240,0,15,240,47,255,255,255,240,0,15,240,47,255,255,255,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,31,224,0,15,240,0,0,0,47,224,0,15,240,0,0,0,63,208,0,15,240,0,0,0,63,192,0,15,240,0,0,0,127,192,0,15,240,0,0,0,191,133,85,111,240,0,0,0,255,15,255,255,240,0,0,2,254,15,255,255,240,0,0,7,253,15,255,255,240,0,0,15,252,0,0,15,240,0,0,47,240,0,0,15,240,0,0,127,224,0,0,15,240,0,1,255,192,0,0,15,240,0,11,255,0,0,0,15,240,0,47,252,0,0,0,15,240,1,255,240,0,0,0,15,240,11,255,192,0,0,0,15,240,127,254,0,0,0,0,15,240,191,244,0,0,0,0,15,240,63,128,0,0,0,0,15,240,29,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,
  // 0xace0  고
  224,172,33,29,5,37,2,1,2,255,255,255,255,255,255,192,0,2,255,255,255,255,255,255,192,0,2,255,255,255,255,255,255,192,0,0,85,85,85,85,85,127,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,170,0,0,127,192,0,0,0,0,255,64,0,127,192,0,0,0,0,255,64,0,191,128,0,0,0,0,255,64,0,191,128,0,0,0,0,255,64,0,191,64,0,0,0,0,255,64,0,255,64,0,0,0,0,255,64,0,255,0,0,0,0,0,255,64,0,255,0,0,0,0,0,255,64,1,255,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,85,85,85,255,149,85,85,85,64,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,
  // 0xadf8  그
  248,173,33,29,5,37,2,1,0,85,85,85,85,85,85,0,0,1,255,255,255,255,255,255,64,0,1,255,255,255,255,255,255,64,0,1,255,255,255,255,255,255,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,85,85,85,85,85,64,
  // 0xae09  급
  9,174,33,36,68,37,2,252,0,85,85,85,85,85,85,0,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,85,85,85,85,85,86,255,85,64,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,64,0,0,0,191,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,85,85,85,85,85,85,0,0,
  // 0xae30  기
  48,174,30,38,48,37,2,252,0,0,0,0,0,0,5,64,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,5,85,85,85,84,0,31,240,15,255,255,255,252,0,31,240,15,255,255,255,252,0,31,240,15,255,255,255,252,0,31,240,0,0,0,3,252,0,31,240,0,0,0,7,252,0,31,240,0,0,0,7,248,0,31,240,0,0,0,11,244,0,31,240,0,0,0,15,244,0,31,240,0,0,0,15,240,0,31,240,0,0,0,47,224,0,31,240,0,0,0,63,208,0,31,240,0,0,0,127,192,0,31,240,0,0,0,255,128,0,31,240,0,0,2,255,0,0,31,240,0,0,7,254,0,0,31,240,0,0,15,252,0,0,31,240,0,0,63,240,0,0,31,240,0,0,255,224,0,0,31,240,0,3,255,128,0,0,31,240,0,31,254,0,0,0,31,240,0,191,248,0,0,0,31,240,7,255,224,0,0,0,31,240,127,255,64,0,0,0,31,240,127,252,0,0,0,0,31,240,47,208,0,0,0,0,31,240,14,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,10,160,
  // 0xae45  깅
  69,174,30,37,40,37,2,252,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,1,85,85,85,84,0,31,224,11,255,255,255,252,0,31,224,11,255,255,255,248,0,31,224,11,255,255,255,248,0,31,224,0,0,0,11,244,0,31,224,0,0,0,15,240,0,31,224,0,0,0,15,240,0,31,224,0,0,0,47,224,0,31,224,0,0,0,63,192,0,31,224,0,0,0,255,128,0,31,224,0,0,2,255,0,0,31,224,0,0,11,252,0,0,31,224,0,0,63,244,0,0,31,224,0,1,255,208,0,0,31,224,0,31,255,64,0,0,31,224,1,255,252,0,0,0,31,224,111,255,224,0,0,0,31,224,127,254,0,0,0,0,31,224,63,224,0,0,0,0,31,224,25,0,0,0,0,0,26,144,0,0,0,111,255,233,0,0,0,0,31,255,255,255,224,0,0,0,255,255,255,255,253,0,0,3,255,249,85,175,255,64,0,15,254,0,0,1,255,192,0,15,244,0,0,0,63,224,0,31,224,0,0,0,31,240,0,47,224,0,0,0,31,240,0,31,224,0,0,0,31,240,0,15,244,0,0,0,63,224,0,15,254,0,0,1,255,192,0,3,255,249,85,111,255,64,0,0,255,255,255,255,253,0,0,0,31,255,255,255,224,0,0,0,0,111,255,233,0,0,
  // 0xb044  끄
  68,176,33,29,5,37,2,1,1,85,85,80,21,85,85,64,0,11,255,255,244,63,255,255,192,0,11,255,255,244,63,255,255,192,0,11,255,255,244,63,255,255,192,0,0,0,11,244,0,0,63,192,0,0,0,11,244,0,0,63,192,0,0,0,11,244,0,0,63,192,0,0,0,15,244,0,0,63,192,0,0,0,15,240,0,0,63,192,0,0,0,15,240,0,0,63,192,0,0,0,15,240,0,0,63,192,0,0,0,15,240,0,0,63,192,0,0,0,31,240,0,0,127,192,0,0,0,47,224,0,0,127,128,0,0,0,47,208,0,0,127,128,0,0,0,63,192,0,0,191,128,0,0,0,63,192,0,0,191,64,0,0,0,127,192,0,0,255,0,0,0,0,191,128,0,0,255,0,0,0,0,255,64,0,1,255,0,0,0,0,255,0,0,1,254,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,85,85,85,85,85,64,
  // 0xb0b4  내
  180,176,30,38,48,37,3,252,0,0,0,0,0,0,5,64,0,0,0,0,10,144,15,224,0,0,0,0,31,224,15,224,0,0,0,0,31,224,15,224,0,0,0,0,31,224,15,224,127,128,0,0,31,224,15,224,127,128,0,0,31,224,15,224,127,128,0,0,31,224,15,224,127,128,0,0,31,224,15,224,127,128,0,0,31,224,15,224,127,128,0,0,31,224,15,224,127,128,0,0,31,224,15,224,127,128,0,0,31,224,15,224,127,128,0,0,31,224,15,224,127,128,0,0,31,224,15,224,127,128,0,0,31,229,95,224,127,128,0,0,31,255,255,224,127,128,0,0,31,255,255,224,127,128,0,0,31,255,255,224,127,128,0,0,31,224,15,224,127,128,0,0,31,224,15,224,127,128,0,0,31,224,15,224,127,128,0,0,31,224,15,224,127,128,0,0,31,224,15,224,127,192,22,189,31,224,15,224,127,255,255,254,31,224,15,224,127,255,255,254,31,224,15,224,127,255,255,233,31,224,15,224,42,85,80,0,31,224,15,224,0,0,0,0,31,224,15,224,0,0,0,0,31,224,15,224,0,0,0,0,31,224,15,224,0,0,0,0,31,224,15,224,0,0,0,0,31,224,15,224,0,0,0,0,31,224,15,224,0,0,0,0,31,224,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,
  // 0xb178  노
  120,177,33,31,23,37,2,0,0,85,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,85,85,95,249,85,85,64,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,85,85,85,85,85,64,
  // 0xb204  누
  4,178,33,36,68,37,2,252,0,106,0,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,85,85,85,85,85,64,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,95,249,85,85,85,64,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,11,240,0,0,0,0,
  // 0xb274  뉴
  116,178,33,36,68,37,2,252,0,85,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,85,85,85,85,85,85,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,255,85,85,191,213,85,64,0,0,255,0,0,127,128,0,0,0,0,255,0,0,127,128,0,0,0,0,255,0,0,127,128,0,0,0,0,255,0,0,127,128,0,0,0,0,255,0,0,127,128,0,0,0,0,255,0,0,127,128,0,0,0,0,255,0,0,127,128,0,0,0,0,255,0,0,127,128,0,0,0,0,255,0,0,127,128,0,0,0,0,255,0,0,127,128,0,0,0,0,255,0,0,127,128,0,0,0,0,255,0,0,127,128,0,0,0,0,255,0,0,127,128,0,0,
  // 0xb2c8  니
  200,178,28,37,3,37,4,252,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,170,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,0,0,255,255,0,0,0,6,64,255,255,0,21,107,255,128,255,255,255,255,255,255,128,255,255,255,255,255,255,128,255,255,255,255,254,144,0,255,106,85,80,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,254,
  // 0xb2e4  다
  228,178,33,38,86,37,3,252,0,0,0,0,0,1,84,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,191,255,255,255,208,3,252,0,0,191,255,255,255,208,3,252,0,0,191,255,255,255,208,3,252,0,0,191,149,85,85,64,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,255,255,128,191,128,0,0,0,3,255,255,128,191,128,0,0,0,3,255,255,128,191,128,0,0,0,3,253,85,64,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,86,191,3,252,0,0,191,255,255,255,255,3,252,0,0,191,255,255,255,255,3,252,0,0,191,255,255,255,233,3,252,0,0,21,85,85,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,2,168,0,0,
  // 0xb2f9  당
  249,178,33,37,77,37,3,252,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,253,0,0,21,85,85,85,0,3,253,0,0,191,255,255,255,128,3,253,0,0,191,255,255,255,128,3,253,0,0,191,255,255,255,128,3,253,0,0,191,128,0,0,0,3,253,0,0,191,128,0,0,0,3,253,0,0,191,128,0,0,0,3,253,0,0,191,128,0,0,0,3,255,255,64,191,128,0,0,0,3,255,255,64,191,128,0,0,0,3,255,255,64,191,128,0,0,0,3,254,85,0,191,128,0,0,0,3,253,0,0,191,128,0,0,5,3,253,0,0,191,149,86,175,255,3,253,0,0,191,255,255,255,255,3,253,0,0,191,255,255,255,255,3,253,0,0,191,255,255,234,80,3,253,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,1,84,0,0,0,0,6,255,254,128,0,0,0,0,1,255,255,255,253,0,0,0,0,15,255,255,255,255,192,0,0,0,63,255,149,91,255,240,0,0,0,191,224,0,0,31,252,0,0,0,255,64,0,0,3,253,0,0,1,255,0,0,0,2,253,0,0,1,254,0,0,0,1,254,0,0,1,255,0,0,0,2,253,0,0,0,255,64,0,0,3,253,0,0,0,191,224,0,0,47,252,0,0,0,63,255,165,107,255,240,0,0,0,15,255,255,255,255,192,0,0,0,1,255,255,255,253,0,0,0,0,0,6,255,254,128,0,0,0,
  // 0xb3c4  도
  196,179,33,31,23,37,2,0,0,85,85,85,85,85,85,0,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,85,85,85,85,85,64,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,85,85,85,85,85,64,
  // 0xb3cc  돌
  204,179,33,36,68,37,2,252,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,255,149,85,85,85,85,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,21,85,95,249,85,85,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,85,85,85,95,249,85,85,85,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,
  // 0xb3d9  동
  217,179,33,36,68,37,2,252,0,21,85,85,85,85,85,0,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,85,85,85,85,85,64,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,85,85,85,95,249,85,85,85,64,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,191,255,164,0,0,0,0,1,255,255,255,255,128,0,0,0,15,255,255,255,255,244,0,0,0,63,255,148,21,191,253,0,0,0,191,224,0,0,3,255,0,0,0,255,128,0,0,0,255,64,0,0,255,0,0,0,0,191,128,0,0,255,0,0,0,0,191,128,0,0,255,128,0,0,0,255,64,0,0,191,224,0,0,3,255,0,0,0,63,255,148,21,191,253,0,0,0,15,255,255,255,255,244,0,0,0,1,255,255,255,255,128,0,0,0,0,6,255,255,164,0,0,0,
  // 0xb418  되
  24,180,30,38,48,37,2,252,0,0,0,0,0,0,5,80,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,7,255,255,255,255,192,31,224,7,255,255,255,255,192,31,224,7,255,255,255,255,192,31,224,7,253,85,85,85,64,31,224,7,252,0,0,0,0,31,224,7,252,0,0,0,0,31,224,7,252,0,0,0,0,31,224,7,252,0,0,0,0,31,224,7,252,0,0,0,0,31,224,7,252,0,0,0,0,31,224,7,252,0,0,0,0,31,224,7,252,0,0,0,0,31,224,7,255,255,255,255,208,31,224,7,255,255,255,255,208,31,224,7,255,255,255,255,208,31,224,1,85,95,245,85,64,31,224,0,0,15,240,0,0,31,224,0,0,15,240,0,0,31,224,0,0,15,240,0,0,31,224,0,0,15,240,0,0,31,224,0,0,15,240,0,0,31,224,0,0,15,240,0,20,31,224,85,85,111,251,255,253,31,224,191,255,255,255,255,254,31,224,191,255,255,255,255,253,31,224,127,255,255,234,148,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,
  // 0xb41c  된
  28,180,31,37,40,37,2,253,0,0,0,0,0,0,5,80,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,2,255,255,255,255,128,31,240,2,255,255,255,255,128,31,240,2,255,255,255,255,128,31,240,2,254,85,85,85,0,31,240,2,253,0,0,0,0,31,240,2,253,0,0,0,0,31,240,2,253,0,0,0,0,31,240,2,253,0,0,0,0,31,240,2,253,0,0,0,0,31,240,2,254,85,85,85,64,31,240,2,255,255,255,255,192,31,240,2,255,255,255,255,192,31,240,2,255,255,255,255,192,31,240,0,0,15,240,0,0,31,240,0,0,15,240,0,0,31,240,0,0,15,240,0,0,31,240,0,0,15,240,0,0,31,240,85,85,95,250,255,252,31,240,191,255,255,255,255,253,31,240,191,255,255,255,255,253,31,240,127,255,255,170,84,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,5,80,0,0,0,31,240,0,15,240,0,0,0,31,240,0,15,240,0,0,0,10,144,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,245,85,85,85,85,84,0,15,255,255,255,255,255,252,0,15,255,255,255,255,255,252,0,15,255,255,255,255,255,252,
  // 0xb428  됨
  40,180,30,38,48,37,2,252,0,0,0,0,0,0,5,80,0,0,0,0,0,0,15,240,0,85,85,85,85,64,15,240,2,255,255,255,255,128,15,240,2,255,255,255,255,128,15,240,2,255,255,255,255,128,15,240,2,253,0,0,0,0,15,240,2,253,0,0,0,0,15,240,2,253,0,0,0,0,15,240,2,253,0,0,0,0,15,240,2,253,0,0,0,0,15,240,2,255,255,255,255,192,15,240,2,255,255,255,255,192,15,240,2,255,255,255,255,192,15,240,0,85,95,245,85,64,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,20,15,240,0,21,95,250,255,253,15,240,191,255,255,255,255,253,15,240,127,255,255,255,255,249,15,240,127,255,255,169,80,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,5,80,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,240,0,15,255,255,255,255,255,240,0,15,255,255,255,255,255,240,0,15,245,85,85,85,95,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,15,240,0,15,255,255,255,255,255,240,0,15,255,255,255,255,255,240,0,15,255,255,255,255,255,240,0,5,85,85,85,85,85,80,
  // 0xb4a4  뒤
  164,180,30,38,48,37,2,252,0,0,0,0,0,0,5,80,0,0,0,0,0,0,15,240,1,85,85,85,85,0,15,240,3,255,255,255,255,128,15,240,3,255,255,255,255,128,15,240,3,255,255,255,255,128,15,240,3,253,0,0,0,0,15,240,3,253,0,0,0,0,15,240,3,253,0,0,0,0,15,240,3,253,0,0,0,0,15,240,3,253,0,0,0,0,15,240,3,253,0,0,0,0,15,240,3,253,0,0,0,0,15,240,3,255,255,255,255,192,15,240,3,255,255,255,255,192,15,240,3,255,255,255,255,192,15,240,1,85,85,85,85,64,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,85,106,254,15,240,255,255,255,255,255,254,15,240,255,255,255,255,255,254,15,240,191,255,255,255,169,64,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,10,160,0,0,15,240,0,0,0,0,0,0,15,224,
  // 0xb4dc  드
  220,180,33,29,5,37,2,1,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,85,85,85,85,85,64,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,85,85,85,85,85,85,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0xb514  디
  20,181,28,38,10,37,4,252,0,0,0,0,0,0,85,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,191,255,255,255,208,1,254,191,255,255,255,208,1,254,191,255,255,255,208,1,254,191,149,85,85,64,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,0,0,1,254,191,64,0,22,191,65,254,191,255,255,255,255,65,254,191,255,255,255,255,129,254,191,255,255,255,249,1,254,85,85,85,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,
  // 0xb77c  라
  124,183,33,38,86,37,3,252,0,0,0,0,0,1,84,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,191,255,255,255,192,3,252,0,0,191,255,255,255,192,3,252,0,0,191,255,255,255,192,3,252,0,0,21,85,85,127,192,3,252,0,0,0,0,0,63,192,3,252,0,0,0,0,0,63,192,3,252,0,0,0,0,0,63,192,3,252,0,0,0,0,0,63,192,3,252,0,0,0,0,0,63,192,3,252,0,0,0,0,0,63,192,3,252,0,0,21,85,85,127,192,3,252,0,0,191,255,255,255,192,3,255,255,128,191,255,255,255,192,3,255,255,128,191,255,255,255,192,3,255,255,128,191,128,0,0,0,3,253,85,64,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,0,0,3,252,0,0,191,128,0,0,22,3,252,0,0,191,149,106,191,255,3,252,0,0,191,255,255,255,255,67,252,0,0,191,255,255,255,255,67,252,0,0,191,255,255,169,64,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,
  // 0xb7ec  러
  236,183,29,38,48,37,3,252,0,0,0,0,0,0,21,64,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,255,255,255,255,64,0,63,192,255,255,255,255,64,0,63,192,255,255,255,255,64,0,63,192,85,85,85,191,64,0,63,192,0,0,0,191,64,0,63,192,0,0,0,191,64,0,63,192,0,0,0,191,64,0,63,192,0,0,0,191,64,0,63,192,0,0,0,191,64,0,63,192,0,0,0,191,64,0,63,192,191,255,255,255,65,85,127,192,191,255,255,255,71,255,255,192,191,255,255,255,71,255,255,192,191,149,85,85,7,255,255,192,191,64,0,0,0,0,63,192,191,64,0,0,0,0,63,192,191,64,0,0,0,0,63,192,191,64,0,0,0,0,63,192,191,64,0,0,0,0,63,192,191,64,0,0,0,0,63,192,191,64,0,0,20,0,63,192,191,149,106,191,253,0,63,192,191,255,255,255,253,0,63,192,191,255,255,255,253,0,63,192,191,255,255,165,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,128,
  // 0xb808  레
  8,184,30,37,40,37,3,252,0,0,0,0,1,80,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,85,85,85,64,7,244,15,240,255,255,255,192,7,244,15,240,255,255,255,192,7,244,15,240,255,255,255,192,7,244,15,240,0,0,63,192,7,244,15,240,0,0,63,192,7,244,15,240,0,0,63,192,7,244,15,240,0,0,63,192,7,244,15,240,0,0,63,192,7,244,15,240,0,0,63,193,91,244,15,240,85,85,127,199,255,244,15,240,255,255,255,199,255,244,15,240,255,255,255,199,255,244,15,240,255,255,255,192,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,5,7,244,15,240,255,86,171,255,7,244,15,240,255,255,255,255,7,244,15,240,255,255,255,255,7,244,15,240,255,255,250,80,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,224,
  // 0xb825  력
  37,184,29,38,48,37,3,252,0,0,0,0,0,0,1,64,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,191,255,255,255,0,0,63,192,191,255,255,255,0,0,63,192,191,255,255,255,0,0,63,192,21,85,85,255,11,255,255,192,0,0,0,255,11,255,255,192,0,0,0,255,11,255,255,192,0,0,0,255,1,85,127,192,0,0,0,255,0,0,63,192,191,255,255,255,0,0,63,192,191,255,255,255,0,0,63,192,191,255,255,255,1,85,127,192,191,128,0,0,11,255,255,192,191,128,0,0,11,255,255,192,191,128,0,0,11,255,255,192,191,128,0,0,0,0,63,192,191,149,86,175,240,0,63,192,191,255,255,255,240,0,63,192,191,255,255,255,240,0,63,192,191,255,255,234,64,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,42,128,0,0,0,0,0,0,0,0,0,21,85,85,85,85,85,64,0,127,255,255,255,255,255,192,0,127,255,255,255,255,255,192,0,127,255,255,255,255,255,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,
  // 0xb85c  로
  92,184,33,31,23,37,2,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,85,85,85,85,85,127,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,85,85,85,85,85,127,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,85,85,95,249,85,85,64,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,85,85,85,85,85,64,
  // 0xb8cc  료
  204,184,33,31,23,37,2,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,85,85,85,85,85,127,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,85,85,85,85,85,127,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,85,127,213,85,255,149,64,0,0,0,63,192,0,191,64,0,0,0,0,63,192,0,191,64,0,0,0,0,63,192,0,191,64,0,0,0,0,63,192,0,191,64,0,0,0,0,63,192,0,191,64,0,0,0,0,63,192,0,191,64,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,85,85,85,85,85,64,
  // 0xb974  르
  116,185,33,31,23,37,2,0,0,85,85,85,85,85,85,64,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,85,85,85,85,85,127,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,85,85,85,85,85,85,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,85,85,85,85,85,64,
  // 0xb9ac  리
  172,185,28,38,10,37,4,252,0,0,0,0,0,0,85,0,0,0,0,0,1,255,0,0,0,0,0,1,255,0,0,0,0,0,1,255,255,255,255,255,192,1,255,255,255,255,255,192,1,255,255,255,255,255,192,1,255,85,85,85,191,192,1,255,0,0,0,127,192,1,255,0,0,0,127,192,1,255,0,0,0,127,192,1,255,0,0,0,127,192,1,255,0,0,0,127,192,1,255,0,0,0,127,192,1,255,85,85,85,191,192,1,255,255,255,255,255,192,1,255,255,255,255,255,192,1,255,255,255,255,255,192,1,255,255,0,0,0,0,1,255,255,0,0,0,0,1,255,255,0,0,0,0,1,255,255,0,0,0,0,1,255,255,0,0,0,0,1,255,255,0,0,0,0,1,255,255,0,0,0,21,65,255,255,150,170,191,255,193,255,255,255,255,255,255,193,255,255,255,255,255,255,193,255,255,255,255,169,80,1,255,0,0,0,0,0,1,255,0,0,0,0,0,1,255,0,0,0,0,0,1,255,0,0,0,0,0,1,255,0,0,0,0,0,1,255,0,0,0,0,0,1,255,0,0,0,0,0,1,255,0,0,0,0,0,1,255,0,0,0,0,0,1,254,
  // 0xb9b0  린
  176,185,29,37,40,37,4,253,0,0,0,0,0,0,85,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,255,255,255,255,64,1,255,0,255,255,255,255,64,1,255,0,255,255,255,255,64,1,255,0,85,85,85,255,64,1,255,0,0,0,0,191,64,1,255,0,0,0,0,191,64,1,255,0,0,0,0,191,64,1,255,0,0,0,0,191,64,1,255,0,255,255,255,255,64,1,255,0,255,255,255,255,64,1,255,0,255,255,255,255,64,1,255,0,255,0,0,0,0,1,255,0,255,0,0,0,0,1,255,0,255,0,0,0,0,1,255,0,255,0,0,0,0,1,255,0,255,0,0,0,6,1,255,0,255,85,90,175,255,1,255,0,255,255,255,255,255,1,255,0,255,255,255,255,255,65,255,0,255,255,255,234,80,1,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,0,255,0,0,0,1,255,0,0,255,0,0,0,1,255,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,85,85,85,85,85,64,0,255,255,255,255,255,255,128,0,255,255,255,255,255,255,128,0,255,255,255,255,255,255,128,
  // 0xb9bd  립
  189,185,28,37,3,37,4,252,0,0,0,0,0,1,255,85,85,85,85,0,1,255,255,255,255,255,64,1,255,255,255,255,255,64,1,255,255,255,255,255,64,1,255,0,0,0,191,64,1,255,0,0,0,191,64,1,255,0,0,0,191,64,1,255,0,0,0,255,64,1,255,255,255,255,255,64,1,255,255,255,255,255,64,1,255,255,255,255,255,64,1,255,255,0,0,0,0,1,255,255,0,0,0,0,1,255,255,0,0,0,0,1,255,255,0,0,22,191,1,255,255,255,255,255,255,1,255,255,255,255,255,255,65,255,255,255,255,255,165,1,255,85,85,80,0,0,1,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,1,255,0,255,0,0,0,1,255,0,255,0,0,0,1,255,0,255,64,0,0,1,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,0,0,0,1,255,0,255,0,0,0,1,255,0,255,0,0,0,1,255,0,255,0,0,0,1,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,255,255,255,255,255,255,0,85,85,85,85,85,85,
  // 0xb9c1  링
  193,185,28,38,10,37,4,252,0,0,0,0,0,0,84,0,0,0,0,0,1,255,0,0,0,0,0,1,255,255,255,255,255,64,1,255,255,255,255,255,64,1,255,255,255,255,255,64,1,255,85,85,85,255,64,1,255,0,0,0,191,64,1,255,0,0,0,191,64,1,255,0,0,0,191,64,1,255,0,0,0,255,64,1,255,255,255,255,255,64,1,255,255,255,255,255,64,1,255,255,255,255,255,64,1,255,255,0,0,0,0,1,255,255,0,0,0,0,1,255,255,0,0,0,0,1,255,255,0,0,22,191,1,255,255,255,255,255,255,1,255,255,255,255,255,255,65,255,255,255,255,255,165,1,255,85,85,80,0,0,1,255,0,0,0,0,0,1,255,0,0,0,0,0,0,84,0,0,6,255,254,144,0,0,1,255,255,255,254,64,0,15,255,255,255,255,224,0,63,254,85,86,255,248,0,255,208,0,0,11,253,0,255,0,0,0,2,255,1,255,0,0,0,0,255,1,255,0,0,0,0,255,0,255,0,0,0,2,255,0,255,208,0,0,11,253,0,63,254,149,86,255,248,0,15,255,255,255,255,224,0,1,255,255,255,255,64,0,0,6,255,254,144,0,
  // 0xba48  멈
  72,186,29,38,48,37,3,252,0,0,0,0,0,0,21,64,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,127,255,255,255,208,0,63,192,127,255,255,255,208,0,63,192,127,255,255,255,208,0,63,192,127,149,85,127,208,0,63,192,127,128,0,47,208,0,63,192,127,128,0,47,208,0,63,192,127,128,0,47,229,85,127,192,127,128,0,47,255,255,255,192,127,128,0,47,255,255,255,192,127,128,0,47,255,255,255,192,127,128,0,47,208,0,63,192,127,128,0,47,208,0,63,192,127,128,0,47,208,0,63,192,127,149,85,127,208,0,63,192,127,255,255,255,208,0,63,192,127,255,255,255,208,0,63,192,127,255,255,255,208,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,0,5,85,85,85,85,85,64,0,63,255,255,255,255,255,192,0,63,255,255,255,255,255,192,0,63,255,255,255,255,255,192,0,63,208,0,0,0,63,192,0,63,208,0,0,0,63,192,0,63,208,0,0,0,63,192,0,63,208,0,0,0,63,192,0,63,208,0,0,0,63,192,0,63,208,0,0,0,63,192,0,63,208,0,0,0,63,192,0,63,255,255,255,255,255,192,0,63,255,255,255,255,255,192,0,63,255,255,255,255,255,192,0,5,85,85,85,85,85,64,
  // 0xba54  메
  84,186,30,38,48,37,3,252,0,0,0,0,0,0,5,80,0,0,0,0,2,164,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,248,15,240,21,85,85,80,7,248,15,240,255,255,255,240,7,248,15,240,255,255,255,240,7,248,15,240,255,255,255,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,245,91,248,15,240,255,0,11,255,255,248,15,240,255,0,11,255,255,248,15,240,255,0,11,255,255,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,85,95,240,7,248,15,240,255,255,255,240,7,248,15,240,255,255,255,240,7,248,15,240,255,255,255,240,7,248,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,248,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,10,160,
  // 0xba74  면
  116,186,30,36,32,37,3,253,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,21,85,85,85,64,0,63,192,127,255,255,255,208,0,63,192,127,255,255,255,208,0,63,192,127,255,255,255,208,0,63,192,127,128,0,47,255,255,255,192,127,128,0,47,255,255,255,192,127,128,0,47,255,255,255,192,127,128,0,47,229,85,127,192,127,128,0,47,208,0,63,192,127,128,0,47,208,0,63,192,127,128,0,47,208,0,63,192,127,128,0,47,208,0,63,192,127,128,0,47,255,255,255,192,127,128,0,47,255,255,255,192,127,128,0,47,255,255,255,192,127,255,255,255,229,85,127,192,127,255,255,255,208,0,63,192,127,255,255,255,208,0,63,192,21,85,85,85,64,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,26,144,0,0,0,63,192,0,47,224,0,0,0,63,192,0,47,224,0,0,0,63,192,0,47,224,0,0,0,0,0,0,47,224,0,0,0,0,0,0,47,224,0,0,0,0,0,0,47,224,0,0,0,0,0,0,47,224,0,0,0,0,0,0,47,229,85,85,85,85,80,0,47,255,255,255,255,255,240,0,47,255,255,255,255,255,240,0,47,255,255,255,255,255,240,
  // 0xbaa8  모
  168,186,33,30,14,37,2,1,0,85,85,85,85,85,85,64,0,1,255,255,255,255,255,255,192,0,1,255,255,255,255,255,255,192,0,1,255,255,255,255,255,255,192,0,1,254,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,255,255,255,255,255,255,192,0,1,255,255,255,255,255,255,192,0,1,255,255,255,255,255,255,192,0,0,85,85,95,249,85,85,64,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,85,85,85,95,249,85,85,85,64,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,
  // 0xbabb  못
  187,186,33,36,68,37,2,252,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,255,85,85,85,85,191,64,0,0,255,0,0,0,0,191,64,0,0,255,0,0,0,0,191,64,0,0,255,0,0,0,0,191,64,0,0,255,0,0,0,0,191,64,0,0,255,0,0,0,0,191,64,0,0,255,85,85,85,85,191,64,0,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,85,85,85,95,249,85,85,85,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,63,253,0,0,0,0,0,0,0,191,255,0,0,0,0,0,0,2,255,191,192,0,0,0,0,0,11,253,63,244,0,0,0,0,0,191,248,15,255,64,0,0,0,27,255,224,3,255,249,0,0,7,255,255,64,0,127,255,240,0,3,255,244,0,0,11,255,224,0,2,254,64,0,0,0,127,208,0,0,64,0,0,0,0,0,64,0,
  // 0xbbf8  미
  248,187,28,38,10,37,4,252,0,0,0,0,0,0,85,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,255,255,255,255,192,1,254,255,255,255,255,192,1,254,255,255,255,255,192,1,254,255,85,85,127,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,0,0,63,192,1,254,255,255,255,255,192,1,254,255,255,255,255,192,1,254,255,255,255,255,192,1,254,85,85,85,85,64,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,
  // 0xbc00  밀
  0,188,29,38,48,37,4,252,0,0,0,0,0,0,84,0,0,0,0,0,0,1,255,0,85,85,85,85,64,1,255,0,255,255,255,255,192,1,255,0,255,255,255,255,192,1,255,0,255,255,255,255,192,1,255,0,255,0,0,63,192,1,255,0,255,0,0,63,192,1,255,0,255,0,0,63,192,1,255,0,255,0,0,63,192,1,255,0,255,0,0,63,192,1,255,0,255,0,0,63,192,1,255,0,255,0,0,63,192,1,255,0,255,0,0,63,192,1,255,0,255,85,85,127,192,1,255,0,255,255,255,255,192,1,255,0,255,255,255,255,192,1,255,0,255,255,255,255,192,1,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,255,255,255,255,255,255,0,0,255,255,255,255,255,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,0,255,255,255,255,255,255,0,0,255,255,255,255,255,255,0,0,255,255,255,255,255,255,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,255,255,255,255,255,192,0,255,255,255,255,255,255,192,0,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,
  // 0xbc14  바
  20,188,33,38,86,37,3,252,0,0,0,0,0,1,84,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,21,0,0,5,64,3,252,0,0,191,64,0,47,208,3,252,0,0,191,64,0,47,208,3,252,0,0,191,64,0,47,208,3,252,0,0,191,64,0,47,208,3,252,0,0,191,64,0,47,208,3,252,0,0,191,64,0,47,208,3,252,0,0,191,64,0,47,208,3,252,0,0,191,64,0,47,208,3,252,0,0,191,64,0,47,208,3,252,0,0,191,255,255,255,208,3,252,0,0,191,255,255,255,208,3,252,0,0,191,255,255,255,208,3,255,255,128,191,149,85,127,208,3,255,255,128,191,64,0,47,208,3,255,255,128,191,64,0,47,208,3,253,85,64,191,64,0,47,208,3,252,0,0,191,64,0,47,208,3,252,0,0,191,64,0,47,208,3,252,0,0,191,64,0,47,208,3,252,0,0,191,64,0,47,208,3,252,0,0,191,64,0,47,208,3,252,0,0,191,149,85,127,208,3,252,0,0,191,255,255,255,208,3,252,0,0,191,255,255,255,208,3,252,0,0,191,255,255,255,208,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,
  // 0xbc84  버
  132,188,29,38,48,37,3,252,0,0,0,0,0,0,21,64,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,21,0,0,21,64,0,63,192,191,64,0,47,208,0,63,192,191,64,0,47,208,0,63,192,191,64,0,47,208,0,63,192,191,64,0,47,208,0,63,192,191,64,0,47,208,0,63,192,191,64,0,47,208,0,63,192,191,64,0,47,208,0,63,192,191,64,0,47,208,0,63,192,191,64,0,47,208,0,63,192,191,255,255,255,208,0,63,192,191,255,255,255,255,255,255,192,191,255,255,255,255,255,255,192,191,128,0,63,255,255,255,192,191,64,0,47,229,85,127,192,191,64,0,47,208,0,63,192,191,64,0,47,208,0,63,192,191,64,0,47,208,0,63,192,191,64,0,47,208,0,63,192,191,64,0,47,208,0,63,192,191,64,0,47,208,0,63,192,191,64,0,47,208,0,63,192,191,149,85,127,208,0,63,192,191,255,255,255,208,0,63,192,191,255,255,255,208,0,63,192,191,255,255,255,208,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,
  // 0xbca0  베
  160,188,30,38,48,37,3,252,0,0,0,0,0,0,5,64,0,0,0,0,2,164,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,248,15,240,170,0,6,160,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,255,255,240,7,248,15,240,255,255,255,249,91,248,15,240,255,255,255,255,255,248,15,240,255,85,91,255,255,248,15,240,255,0,11,255,255,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,0,11,240,7,248,15,240,255,255,255,240,7,248,15,240,255,255,255,240,7,248,15,240,255,255,255,240,7,248,15,240,85,85,85,80,7,248,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,248,15,240,0,0,0,0,7,244,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,10,160,
  // 0xbca8  벨
  168,188,31,38,48,37,3,252,0,0,0,0,0,0,5,64,0,0,0,0,6,160,31,224,21,0,0,0,7,244,31,224,191,64,3,248,7,244,31,224,191,64,3,248,7,244,31,224,191,64,3,248,7,244,31,224,191,64,3,248,7,244,31,224,191,255,255,248,7,244,31,224,191,255,255,249,91,244,31,224,191,255,255,255,255,244,31,224,191,64,7,255,255,244,31,224,191,64,3,255,255,244,31,224,191,64,3,248,7,244,31,224,191,64,3,248,7,244,31,224,191,64,3,248,7,244,31,224,191,255,255,248,7,244,31,224,191,255,255,248,7,244,31,224,191,255,255,248,7,244,31,224,0,0,0,0,7,244,31,224,0,0,0,0,6,164,31,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,224,0,47,255,255,255,255,255,224,0,47,255,255,255,255,255,224,0,0,0,0,0,0,47,224,0,0,0,0,0,0,47,224,0,0,0,0,0,0,47,224,0,31,255,255,255,255,255,224,0,31,255,255,255,255,255,224,0,31,255,255,255,255,255,224,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,255,255,255,255,255,252,0,31,255,255,255,255,255,252,0,31,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xbcf8  본
  248,188,33,35,59,37,2,253,0,255,64,0,0,0,191,64,0,0,255,64,0,0,0,191,64,0,0,255,64,0,0,0,191,64,0,0,255,64,0,0,0,191,64,0,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,255,64,0,0,0,191,64,0,0,255,64,0,0,0,191,64,0,0,255,64,0,0,0,191,64,0,0,255,64,0,0,0,191,64,0,0,255,85,85,85,85,191,64,0,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,85,85,85,95,249,85,85,85,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,149,85,85,85,85,64,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,
  // 0xbe44  비
  68,190,28,38,10,37,4,252,0,0,0,0,0,0,85,0,0,0,0,0,1,254,0,0,0,0,0,1,254,85,0,0,21,64,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,255,255,255,208,1,254,255,255,255,255,208,1,254,255,255,255,255,208,1,254,255,85,85,127,208,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,0,0,63,208,1,254,255,85,85,127,208,1,254,255,255,255,255,208,1,254,255,255,255,255,208,1,254,255,255,255,255,208,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,
  // 0xc0ac  사
  172,192,35,37,77,37,1,252,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,31,224,0,0,63,192,0,0,0,31,224,0,0,63,192,0,0,0,31,224,0,0,63,192,0,0,0,31,224,0,0,63,192,0,0,0,31,224,0,0,63,192,0,0,0,31,224,0,0,63,192,0,0,0,31,224,0,0,63,192,0,0,0,47,240,0,0,63,192,0,0,0,47,240,0,0,63,192,0,0,0,63,240,0,0,63,192,0,0,0,63,240,0,0,63,192,0,0,0,63,244,0,0,63,213,80,0,0,191,252,0,0,63,255,248,0,0,255,252,0,0,63,255,248,0,1,255,254,0,0,63,255,248,0,3,253,255,0,0,63,192,0,0,7,252,191,192,0,63,192,0,0,15,244,63,224,0,63,192,0,0,47,240,47,240,0,63,192,0,0,191,208,15,252,0,63,192,0,2,255,128,7,255,64,63,192,0,11,255,0,2,255,224,63,192,0,127,252,0,0,191,240,63,192,0,63,244,0,0,47,208,63,192,0,15,192,0,0,7,128,63,192,0,6,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,42,128,0,
  // 0xc0bd  삽
  189,192,34,38,86,37,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,0,0,255,0,0,0,0,106,64,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,191,192,0,0,255,0,0,0,0,191,192,0,0,255,0,0,0,0,255,192,0,0,255,0,0,0,0,255,208,0,0,255,255,208,0,1,255,240,0,0,255,255,208,0,3,255,244,0,0,255,255,208,0,11,251,252,0,0,255,149,64,0,31,242,255,0,0,255,0,0,0,63,224,255,192,0,255,0,0,1,255,192,127,248,0,255,0,0,15,255,0,31,255,128,255,0,0,191,253,0,7,255,192,255,0,0,191,244,0,0,255,0,255,0,0,63,192,0,0,29,0,255,0,0,29,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,192,0,0,0,255,0,0,0,63,192,0,0,0,255,0,0,0,63,192,0,0,0,255,0,0,0,63,208,0,0,0,255,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,192,0,0,0,255,0,0,0,63,192,0,0,0,255,0,0,0,63,192,0,0,0,255,0,0,0,63,192,0,0,0,255,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,21,85,85,85,85,85,0,0,
  // 0xc0c8  새
  200,192,31,37,40,37,2,252,0,0,0,0,2,164,3,252,0,0,0,0,3,252,3,252,0,0,0,0,3,252,3,252,0,2,252,0,3,252,3,252,0,3,252,0,3,252,3,252,0,3,252,0,3,252,3,252,0,3,252,0,3,252,3,252,0,3,252,0,3,252,3,252,0,3,252,0,3,252,3,252,0,3,252,0,3,252,3,252,0,3,252,0,3,252,3,252,0,3,253,0,3,252,3,252,0,3,253,0,3,252,3,252,0,3,254,0,3,252,3,252,0,7,254,0,3,253,87,252,0,11,255,0,3,255,255,252,0,15,255,64,3,255,255,252,0,15,255,128,3,255,255,252,0,31,255,192,3,252,3,252,0,63,239,224,3,252,3,252,0,191,143,240,3,252,3,252,0,255,11,252,3,252,3,252,3,254,3,254,3,252,3,252,11,252,2,255,131,252,3,252,47,248,0,255,243,252,3,252,191,240,0,63,243,252,3,252,255,192,0,15,195,252,3,252,127,0,0,2,67,252,3,252,28,0,0,0,3,252,3,252,0,0,0,0,3,252,3,252,0,0,0,0,3,252,3,252,0,0,0,0,3,252,3,252,0,0,0,0,3,252,3,252,0,0,0,0,3,252,3,252,0,0,0,0,3,252,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,248,
  // 0xc124  설
  36,193,31,38,48,37,2,252,0,0,0,0,0,0,5,80,0,0,0,0,0,0,15,240,0,0,127,192,0,0,15,240,0,0,127,192,0,0,15,240,0,0,127,192,0,0,15,240,0,0,127,192,0,0,15,240,0,0,127,192,0,0,15,240,0,0,191,192,7,255,255,240,0,0,255,208,7,255,255,240,0,0,255,240,7,255,255,240,0,2,255,244,1,85,95,240,0,3,255,252,0,0,15,240,0,15,246,255,0,0,15,240,0,63,240,255,192,0,15,240,0,255,208,127,244,0,15,240,11,255,128,47,255,64,15,240,191,254,0,11,255,192,15,240,191,248,0,1,255,64,15,240,63,208,0,0,46,0,15,240,29,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,255,255,255,255,255,240,0,11,255,255,255,255,255,240,0,11,255,255,255,255,255,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,7,255,255,255,255,255,240,0,7,255,255,255,255,255,240,0,7,255,255,255,255,255,240,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,255,255,255,255,255,252,0,7,255,255,255,255,255,252,0,7,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xc18c  소
  140,193,33,30,14,37,2,1,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,63,253,0,0,0,0,0,0,0,127,255,0,0,0,0,0,0,0,255,255,64,0,0,0,0,0,2,255,127,192,0,0,0,0,0,11,252,47,240,0,0,0,0,0,47,248,15,253,0,0,0,0,1,255,240,7,255,128,0,0,0,11,255,128,1,255,244,0,0,1,255,254,0,0,63,255,144,0,47,255,244,0,0,11,255,252,0,15,255,128,0,0,1,255,248,0,11,248,0,0,0,0,27,240,0,2,0,0,15,244,0,0,80,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,85,85,85,95,249,85,85,85,64,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,
  // 0xc18d  속
  141,193,33,37,77,37,2,252,0,0,0,10,164,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,63,254,0,0,0,0,0,0,0,255,255,64,0,0,0,0,0,3,255,127,208,0,0,0,0,0,15,252,47,248,0,0,0,0,0,191,244,15,255,64,0,0,0,27,255,208,2,255,248,0,0,11,255,255,0,0,127,255,244,0,11,255,244,0,0,11,255,244,0,3,254,64,15,244,0,127,240,0,2,64,0,15,244,0,1,144,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,0,0,1,255,255,255,255,255,255,128,0,1,255,255,255,255,255,255,128,0,1,255,255,255,255,255,255,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,
  // 0xc2a4  스
  164,194,33,30,14,37,2,1,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,63,254,0,0,0,0,0,0,0,191,255,0,0,0,0,0,0,1,255,191,192,0,0,0,0,0,3,253,63,224,0,0,0,0,0,31,252,31,248,0,0,0,0,0,127,240,11,255,0,0,0,0,2,255,192,2,255,208,0,0,0,47,255,0,0,191,253,0,0,7,255,252,0,0,47,255,228,0,47,255,224,0,0,7,255,252,0,15,255,0,0,0,0,127,248,0,11,224,0,0,0,0,6,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,64,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,
  // 0xc2ac  슬
  172,194,33,37,77,37,2,252,0,0,0,15,244,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,63,254,0,0,0,0,0,0,0,255,255,128,0,0,0,0,0,3,255,63,224,0,0,0,0,0,47,252,31,253,0,0,0,0,2,255,240,7,255,208,0,0,5,191,255,128,0,255,255,148,0,15,255,253,0,0,47,255,248,0,11,255,144,0,0,1,255,244,0,3,164,0,0,0,0,6,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,
  // 0xc2dc  시
  220,194,30,37,40,37,2,252,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,47,208,0,0,31,224,0,0,63,208,0,0,31,224,0,0,63,208,0,0,31,224,0,0,63,208,0,0,31,224,0,0,63,208,0,0,31,224,0,0,63,208,0,0,31,224,0,0,63,208,0,0,31,224,0,0,63,208,0,0,31,224,0,0,63,224,0,0,31,224,0,0,63,224,0,0,31,224,0,0,127,240,0,0,31,224,0,0,191,240,0,0,31,224,0,0,255,248,0,0,31,224,0,1,255,252,0,0,31,224,0,2,255,253,0,0,31,224,0,3,252,255,0,0,31,224,0,15,244,191,128,0,31,224,0,31,240,63,208,0,31,224,0,127,208,47,244,0,31,224,0,255,192,15,253,0,31,224,7,255,0,7,255,64,31,224,47,254,0,1,255,244,31,224,255,248,0,0,127,240,31,224,191,224,0,0,31,208,31,224,63,64,0,0,2,128,31,224,8,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,0,
  // 0xc2dd  식
  221,194,30,38,48,37,2,252,0,0,0,0,0,0,5,64,0,0,0,0,0,0,31,240,0,0,42,128,0,0,31,240,0,0,63,192,0,0,31,240,0,0,63,192,0,0,31,240,0,0,63,192,0,0,31,240,0,0,63,192,0,0,31,240,0,0,63,208,0,0,31,240,0,0,127,208,0,0,31,240,0,0,191,224,0,0,31,240,0,0,255,240,0,0,31,240,0,1,255,248,0,0,31,240,0,3,255,252,0,0,31,240,0,11,253,255,0,0,31,240,0,31,244,255,192,0,31,240,0,127,224,127,240,0,31,240,2,255,192,31,254,0,31,240,31,255,0,11,255,224,31,240,191,252,0,1,255,208,31,240,63,240,0,0,47,128,31,240,31,64,0,0,2,0,31,240,4,0,0,0,0,0,31,240,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,0,0,5,85,85,85,85,85,64,0,47,255,255,255,255,255,240,0,47,255,255,255,255,255,240,0,47,255,255,255,255,255,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,10,160,
  // 0xc5b4  어
  180,197,30,38,48,37,2,252,0,0,0,0,0,0,5,80,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,1,169,0,0,0,15,240,0,31,255,224,0,0,15,240,0,191,255,252,0,0,15,240,2,255,255,255,0,0,15,240,3,255,65,255,128,0,15,240,11,248,0,127,192,0,15,240,15,240,0,47,224,0,15,240,47,224,0,15,240,0,15,240,63,192,0,11,244,0,15,240,63,192,0,7,248,0,15,240,63,192,0,7,248,0,15,240,127,128,0,3,253,85,95,240,127,128,0,3,255,255,255,240,127,128,0,3,255,255,255,240,127,128,0,3,255,255,255,240,127,128,0,3,252,0,15,240,63,192,0,7,248,0,15,240,63,192,0,7,248,0,15,240,63,192,0,11,244,0,15,240,47,224,0,15,240,0,15,240,15,240,0,31,224,0,15,240,15,248,0,63,208,0,15,240,3,255,1,255,128,0,15,240,2,255,255,255,0,0,15,240,0,191,255,252,0,0,15,240,0,31,255,224,0,0,15,240,0,1,169,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,
  // 0xc5c6  없
  198,197,34,37,77,37,2,252,0,0,0,0,0,0,15,240,0,0,0,84,0,0,0,15,240,0,0,31,255,244,0,0,15,240,0,1,255,255,255,0,0,15,240,0,7,255,255,255,192,0,15,240,0,15,253,0,191,240,0,15,240,0,47,240,0,15,248,0,15,240,0,63,192,0,7,252,0,15,240,0,127,128,0,3,255,255,255,240,0,127,128,0,2,255,255,255,240,0,127,128,0,3,255,255,255,240,0,127,192,0,3,253,85,111,240,0,63,208,0,7,252,0,15,240,0,47,240,0,31,244,0,15,240,0,15,254,1,191,240,0,15,240,0,7,255,255,255,192,0,15,240,0,1,255,255,255,0,0,15,240,0,0,31,255,244,0,0,15,240,0,0,0,84,0,0,0,15,240,0,0,0,0,0,0,0,5,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,84,0,0,0,255,0,63,192,3,253,0,0,0,255,0,63,192,3,253,0,0,0,255,0,63,192,3,253,0,0,0,255,0,63,192,3,253,0,0,0,255,255,255,192,3,254,0,0,0,255,255,255,192,7,255,0,0,0,255,255,255,192,15,255,64,0,0,255,0,63,192,31,255,128,0,0,255,0,63,192,63,255,224,0,0,255,0,63,192,255,143,244,0,0,255,0,63,203,255,11,254,0,0,255,255,255,255,252,2,255,208,0,255,255,255,223,240,0,191,192,0,255,255,255,203,128,0,31,64,0,0,0,0,1,0,0,1,0,
  // 0xc5d1  엑
  209,197,31,38,48,37,2,252,0,0,0,0,0,0,1,80,0,0,0,0,0,169,7,248,0,0,0,0,0,254,7,248,0,31,249,0,0,254,7,248,1,255,255,208,0,254,7,248,7,255,255,244,0,254,7,248,15,254,175,252,0,254,7,248,63,224,2,255,0,254,7,248,63,192,0,255,0,254,7,248,127,64,0,127,64,254,7,248,191,0,0,63,255,254,7,248,191,0,0,63,255,254,7,248,191,0,0,63,255,254,7,248,191,0,0,63,150,254,7,248,127,128,0,191,64,254,7,248,63,192,0,255,0,254,7,248,47,240,3,254,0,254,7,248,15,254,111,252,0,254,7,248,7,255,255,240,0,254,7,248,1,255,255,192,0,254,7,248,0,31,249,0,0,254,7,248,0,0,0,0,0,254,7,248,0,0,0,0,0,253,7,248,0,0,0,0,0,0,0,0,0,5,85,85,85,85,85,80,0,15,255,255,255,255,255,248,0,15,255,255,255,255,255,248,0,15,255,255,255,255,255,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,7,248,
  // 0xc5d4  엔
  212,197,32,37,40,37,2,253,0,0,0,0,0,0,1,80,0,0,0,0,0,169,7,248,0,0,0,0,0,254,7,248,0,5,80,0,0,254,7,248,0,127,255,64,0,254,7,248,3,255,255,224,0,254,7,248,15,255,255,248,0,254,7,248,31,248,11,253,0,254,7,248,63,208,1,255,0,254,7,248,127,128,0,255,0,254,7,248,191,64,0,127,64,254,7,248,191,0,0,63,255,254,7,248,191,0,0,63,255,254,7,248,191,0,0,63,255,254,7,248,191,0,0,127,150,254,7,248,127,128,0,191,0,254,7,248,63,208,1,255,0,254,7,248,47,248,11,253,0,254,7,248,15,255,255,248,0,254,7,248,3,255,255,240,0,254,7,248,0,127,255,64,0,254,7,248,0,5,148,0,0,254,7,248,0,0,0,0,0,254,7,248,0,0,0,0,0,254,7,248,0,1,84,0,0,254,7,248,0,7,252,0,0,254,7,248,0,7,252,0,0,254,7,248,0,7,252,0,0,0,7,248,0,7,252,0,0,0,1,80,0,7,252,0,0,0,0,0,0,7,252,0,0,0,0,0,0,7,252,0,0,0,0,0,0,7,252,0,0,0,0,0,0,7,253,85,85,85,85,84,0,7,255,255,255,255,255,254,0,7,255,255,255,255,255,254,0,7,255,255,255,255,255,254,
  // 0xc5f4  열
  244,197,31,38,48,37,2,252,0,0,0,0,0,0,5,80,0,0,0,0,0,0,15,240,0,6,255,144,0,0,15,240,0,191,255,254,0,0,15,240,3,255,255,255,208,0,31,240,15,255,154,255,255,255,255,240,31,248,0,47,255,255,255,240,63,208,0,11,255,255,255,240,63,192,0,3,252,0,15,240,127,128,0,3,252,0,15,240,127,64,0,2,253,0,15,240,127,128,0,3,252,0,15,240,63,192,0,3,253,0,31,240,63,208,0,11,255,255,255,240,31,244,0,47,255,255,255,240,15,255,150,255,255,255,255,240,3,255,255,255,128,0,15,240,0,191,255,253,0,0,15,240,0,6,255,144,0,0,15,240,0,0,0,0,0,0,5,80,0,0,0,0,0,0,0,0,0,11,255,255,255,255,255,240,0,11,255,255,255,255,255,240,0,11,255,255,255,255,255,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,11,255,255,255,255,255,240,0,11,255,255,255,255,255,240,0,11,255,255,255,255,255,240,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,255,255,255,255,255,252,0,11,255,255,255,255,255,252,0,11,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0xc608  예
  8,198,31,37,40,37,2,252,0,0,0,0,0,84,3,252,0,0,0,0,0,254,3,252,0,0,0,0,0,254,3,252,0,27,244,0,0,254,3,252,0,191,255,0,0,254,3,252,3,255,255,192,0,254,3,252,7,255,255,240,0,254,3,252,15,248,31,244,0,254,3,252,31,224,7,253,86,254,3,252,63,192,3,255,255,254,3,252,63,192,1,255,255,254,3,252,63,128,0,255,255,254,3,252,127,64,0,254,0,254,3,252,127,64,0,254,0,254,3,252,191,0,0,255,0,254,3,252,191,0,0,255,0,254,3,252,191,0,0,255,0,254,3,252,191,0,0,255,0,254,3,252,127,64,0,254,0,254,3,252,127,64,0,255,85,254,3,252,63,128,1,255,255,254,3,252,63,192,2,255,255,254,3,252,47,192,3,255,255,254,3,252,31,224,7,248,0,254,3,252,15,248,31,240,0,254,3,252,7,255,255,224,0,254,3,252,2,255,255,192,0,254,3,252,0,191,255,0,0,254,3,252,0,11,228,0,0,254,3,252,0,0,0,0,0,254,3,252,0,0,0,0,0,254,3,252,0,0,0,0,0,254,3,252,0,0,0,0,0,254,3,252,0,0,0,0,0,254,3,252,0,0,0,0,0,254,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,2,168,
  // 0xc624  오
  36,198,33,30,14,37,2,1,0,0,1,191,254,144,0,0,0,0,0,111,255,255,254,0,0,0,0,2,255,255,255,255,224,0,0,0,15,255,233,90,255,248,0,0,0,63,249,0,0,31,254,0,0,0,191,208,0,0,2,255,64,0,0,255,64,0,0,0,191,192,0,2,254,0,0,0,0,63,192,0,2,253,0,0,0,0,47,208,0,3,252,0,0,0,0,31,224,0,3,252,0,0,0,0,31,224,0,3,253,0,0,0,0,47,208,0,2,254,0,0,0,0,63,208,0,0,255,64,0,0,0,191,192,0,0,191,192,0,0,2,255,64,0,0,63,248,0,0,31,255,0,0,0,15,255,229,90,255,252,0,0,0,3,255,255,255,255,224,0,0,0,0,127,255,255,254,0,0,0,0,0,2,191,255,144,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,85,85,85,95,249,85,85,85,64,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,
  // 0xc628  온
  40,198,33,36,68,37,2,253,0,0,0,1,80,0,0,0,0,0,0,27,255,255,249,0,0,0,0,2,255,255,255,255,208,0,0,0,15,255,255,255,255,248,0,0,0,63,254,64,1,127,255,0,0,0,255,208,0,0,2,255,64,0,0,255,64,0,0,0,191,192,0,1,255,0,0,0,0,63,192,0,1,254,0,0,0,0,63,192,0,1,255,0,0,0,0,127,192,0,0,255,128,0,0,0,255,192,0,0,191,224,0,0,7,255,64,0,0,63,255,149,85,191,254,0,0,0,15,255,255,255,255,248,0,0,0,1,255,255,255,255,128,0,0,0,0,6,255,255,228,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,149,85,85,85,85,64,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,
  // 0xc644  완
  68,198,34,37,77,37,2,253,0,0,0,0,0,0,85,0,0,0,0,0,0,0,0,255,64,0,0,2,255,228,0,0,255,64,0,0,47,255,255,64,0,255,64,0,0,255,255,255,224,0,255,64,0,3,255,144,127,248,0,255,64,0,7,252,0,7,252,0,255,64,0,15,244,0,2,253,0,255,64,0,15,240,0,1,254,0,255,64,0,15,240,0,0,254,0,255,64,0,15,240,0,0,254,0,255,64,0,15,240,0,1,253,0,255,64,0,7,252,0,3,252,0,255,64,0,3,255,64,47,248,0,255,255,208,0,255,255,255,240,0,255,255,208,0,63,255,255,128,0,255,255,208,0,6,255,248,0,0,255,149,64,0,0,63,192,0,0,255,64,0,0,0,63,192,0,0,255,64,0,0,0,63,192,1,96,255,64,0,85,85,191,239,255,240,255,64,0,255,255,255,255,255,244,255,64,0,255,255,255,255,255,224,255,64,0,191,255,254,165,64,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,63,192,0,0,0,255,64,0,0,63,192,0,0,0,255,64,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,213,85,85,85,85,64,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,
  // 0xc6d0  원
  208,198,31,37,40,37,2,253,0,0,0,0,0,0,5,80,0,0,0,0,0,0,15,240,0,1,175,233,0,0,15,240,0,31,255,255,208,0,15,240,0,191,255,255,248,0,15,240,2,255,144,27,254,0,15,240,3,253,0,1,255,0,15,240,7,252,0,0,191,64,15,240,7,248,0,0,191,64,15,240,7,252,0,0,191,64,15,240,3,253,0,1,255,0,15,240,2,255,144,27,254,0,15,240,0,191,255,255,252,0,15,240,0,31,255,255,224,0,15,240,0,1,191,249,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,88,15,240,85,85,106,175,255,252,15,240,255,255,255,255,255,252,15,240,255,255,255,255,255,252,15,240,191,255,255,255,169,64,15,240,0,0,15,240,0,0,15,240,0,0,15,240,3,255,255,240,0,0,15,240,3,255,255,240,0,0,15,240,3,255,255,240,0,0,15,240,0,0,15,240,0,127,207,240,0,0,15,240,0,127,202,160,0,0,15,240,0,127,192,0,0,0,10,160,0,127,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,213,85,85,85,85,84,0,127,255,255,255,255,255,252,0,127,255,255,255,255,255,252,0,127,255,255,255,255,255,252,
  // 0xc704  위
  4,199,30,37,40,37,2,252,0,0,0,0,0,0,15,240,0,0,5,80,0,0,15,240,0,2,255,255,64,0,15,240,0,31,255,255,240,0,15,240,0,191,255,255,253,0,15,240,1,255,208,11,255,0,15,240,3,254,0,0,255,128,15,240,7,252,0,0,127,192,15,240,7,248,0,0,63,192,15,240,11,248,0,0,63,192,15,240,7,248,0,0,63,192,15,240,3,252,0,0,191,128,15,240,3,255,64,2,255,64,15,240,0,255,249,111,254,0,15,240,0,127,255,255,252,0,15,240,0,11,255,255,208,0,15,240,0,0,191,249,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,89,15,240,85,85,170,175,255,254,15,240,255,255,255,255,255,254,15,240,191,255,255,255,255,233,15,240,191,255,255,249,80,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,10,160,0,0,15,240,0,0,0,0,0,0,15,224,
  // 0xc73c  으
  60,199,33,30,14,37,2,1,0,0,1,191,254,80,0,0,0,0,0,47,255,255,254,0,0,0,0,2,255,255,255,255,208,0,0,0,15,255,250,107,255,248,0,0,0,63,253,0,0,47,254,0,0,0,191,208,0,0,2,255,0,0,0,255,64,0,0,0,191,192,0,1,254,0,0,0,0,63,192,0,2,253,0,0,0,0,47,208,0,3,252,0,0,0,0,31,224,0,3,252,0,0,0,0,31,224,0,3,252,0,0,0,0,47,208,0,2,254,0,0,0,0,63,208,0,1,255,0,0,0,0,127,192,0,0,255,192,0,0,1,255,128,0,0,63,244,0,0,11,255,0,0,0,31,255,144,5,191,252,0,0,0,7,255,255,255,255,240,0,0,0,0,191,255,255,255,64,0,0,0,0,7,255,255,228,0,0,0,0,0,0,5,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,64,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,
  // 0xc74c  음
  76,199,33,36,68,37,2,252,0,0,27,255,255,228,0,0,0,0,2,255,255,255,255,208,0,0,0,31,255,255,255,255,252,0,0,0,127,254,64,0,111,255,0,0,0,255,208,0,0,2,255,128,0,1,255,0,0,0,0,191,192,0,1,255,0,0,0,0,63,192,0,1,255,0,0,0,0,63,192,0,1,255,64,0,0,0,191,192,0,0,255,224,0,0,2,255,128,0,0,63,255,149,85,191,255,0,0,0,15,255,255,255,255,248,0,0,0,1,255,255,255,255,128,0,0,0,0,6,191,255,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,85,85,85,85,191,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,85,85,85,85,85,85,0,0,
  // 0xc774  이
  116,199,29,38,48,37,3,252,0,0,0,0,0,0,21,64,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,1,169,0,0,0,127,128,0,47,255,224,0,0,127,128,0,255,255,252,0,0,127,128,3,255,255,255,0,0,127,128,11,254,2,255,128,0,127,128,15,244,0,127,192,0,127,128,47,224,0,47,224,0,127,128,63,192,0,15,240,0,127,128,63,192,0,15,240,0,127,128,127,128,0,11,244,0,127,128,191,64,0,7,248,0,127,128,191,64,0,7,248,0,127,128,191,64,0,3,252,0,127,128,255,0,0,3,252,0,127,128,191,64,0,3,252,0,127,128,191,64,0,7,248,0,127,128,191,64,0,7,248,0,127,128,127,128,0,11,244,0,127,128,63,192,0,15,240,0,127,128,63,192,0,15,240,0,127,128,47,224,0,47,224,0,127,128,15,244,0,127,192,0,127,128,11,254,2,255,128,0,127,128,3,255,255,255,0,0,127,128,0,255,255,252,0,0,127,128,0,47,255,224,0,0,127,128,0,1,169,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,
  // 0xc77c  일
  124,199,30,37,40,37,3,252,0,0,0,0,0,0,127,192,0,27,254,128,0,0,127,192,1,255,255,248,0,0,127,192,11,255,255,255,0,0,127,192,47,254,155,255,192,0,127,192,127,224,0,127,224,0,127,192,255,128,0,31,240,0,127,192,255,0,0,11,244,0,127,192,255,0,0,7,248,0,127,192,255,0,0,7,248,0,127,192,255,0,0,11,248,0,127,192,255,64,0,15,244,0,127,192,191,192,0,47,240,0,127,192,63,249,1,255,208,0,127,192,15,255,255,255,128,0,127,192,3,255,255,253,0,0,127,192,0,127,255,224,0,0,127,192,0,0,84,0,0,0,127,192,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,192,0,63,255,255,255,255,255,192,0,63,255,255,255,255,255,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,192,0,63,255,255,255,255,255,192,0,63,255,255,255,255,255,192,0,63,255,255,255,255,255,192,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,255,255,255,255,255,240,0,63,255,255,255,255,255,240,0,63,255,255,255,255,255,240,0,0,0,0,0,0,0,0,
  // 0xc77d  읽
  125,199,29,37,40,37,3,252,0,0,0,0,0,0,127,192,0,0,84,0,0,0,127,192,0,127,255,224,0,0,127,192,3,255,255,253,0,0,127,192,15,255,255,255,64,0,127,192,63,249,1,255,208,0,127,192,191,192,0,63,240,0,127,192,255,64,0,15,244,0,127,192,255,0,0,11,248,0,127,192,255,0,0,7,248,0,127,192,255,0,0,7,248,0,127,192,255,0,0,11,244,0,127,192,255,128,0,31,240,0,127,192,127,224,0,127,224,0,127,192,47,254,91,255,192,0,127,192,11,255,255,255,0,0,127,192,1,255,255,248,0,0,127,192,0,27,255,128,0,0,127,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,0,0,85,85,84,21,85,85,0,2,255,255,254,63,255,255,192,2,255,255,254,63,255,255,192,2,255,255,254,63,255,255,192,0,0,1,254,0,0,127,192,0,0,1,254,0,0,127,192,0,0,1,254,0,0,127,192,2,255,255,254,0,0,127,192,2,255,255,254,0,0,127,192,2,255,255,253,0,0,127,192,2,253,0,0,0,0,127,192,2,253,0,0,0,0,127,192,2,253,0,5,160,0,127,192,2,255,255,255,240,0,127,192,2,255,255,255,240,0,127,192,2,255,255,254,144,0,127,192,0,0,0,0,0,0,21,64,
  // 0xc785  입
  133,199,29,37,40,37,3,252,0,0,0,0,0,0,127,192,0,0,84,0,0,0,127,192,0,127,255,224,0,0,127,192,3,255,255,254,0,0,127,192,15,255,255,255,128,0,127,192,63,249,1,255,208,0,127,192,127,208,0,47,240,0,127,192,255,64,0,15,244,0,127,192,255,0,0,7,248,0,127,192,255,0,0,3,252,0,127,192,255,0,0,3,252,0,127,192,255,0,0,7,248,0,127,192,255,64,0,15,244,0,127,192,127,208,0,47,240,0,127,192,63,249,1,255,224,0,127,192,15,255,255,255,128,0,127,192,3,255,255,254,0,0,127,192,0,127,255,224,0,0,127,192,0,1,84,0,0,0,127,192,0,0,0,0,0,0,21,64,0,0,0,0,0,0,0,0,0,42,128,0,0,0,42,128,0,63,208,0,0,0,127,192,0,63,208,0,0,0,127,192,0,63,208,0,0,0,127,192,0,63,208,0,0,0,127,192,0,63,255,255,255,255,255,192,0,63,255,255,255,255,255,192,0,63,255,255,255,255,255,192,0,63,208,0,0,0,127,192,0,63,208,0,0,0,127,192,0,63,208,0,0,0,127,192,0,63,208,0,0,0,127,192,0,63,255,255,255,255,255,192,0,63,255,255,255,255,255,192,0,63,255,255,255,255,255,192,0,21,85,85,85,85,85,64,
  // 0xc790  자
  144,199,35,37,77,37,1,252,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,5,85,85,85,85,64,63,192,0,31,255,255,255,255,208,63,192,0,31,255,255,255,255,208,63,192,0,31,255,255,255,255,208,63,192,0,0,0,31,224,0,0,63,192,0,0,0,31,224,0,0,63,192,0,0,0,31,224,0,0,63,192,0,0,0,31,224,0,0,63,192,0,0,0,47,224,0,0,63,192,0,0,0,47,240,0,0,63,192,0,0,0,47,240,0,0,63,192,0,0,0,63,240,0,0,63,213,80,0,0,63,244,0,0,63,255,248,0,0,191,252,0,0,63,255,248,0,0,255,252,0,0,63,255,248,0,1,254,254,0,0,63,192,0,0,3,252,255,64,0,63,192,0,0,7,248,127,192,0,63,192,0,0,15,244,63,240,0,63,192,0,0,63,240,15,248,0,63,192,0,0,191,192,11,254,0,63,192,0,2,255,128,3,255,192,63,192,0,15,255,0,0,255,244,63,192,0,127,252,0,0,63,240,63,192,0,63,240,0,0,11,208,63,192,0,15,128,0,0,1,128,63,192,0,5,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,
  // 0xc791  작
  145,199,34,38,86,37,2,252,0,0,0,0,0,0,85,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,63,255,255,255,255,64,255,0,0,63,255,255,255,255,64,255,0,0,63,255,255,255,255,64,255,0,0,21,85,191,213,85,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,191,192,0,0,255,0,0,0,0,191,192,0,0,255,0,0,0,0,255,208,0,0,255,255,208,0,1,255,224,0,0,255,255,208,0,3,255,240,0,0,255,255,208,0,7,255,252,0,0,255,149,64,0,15,243,254,0,0,255,0,0,0,63,225,255,128,0,255,0,0,0,255,192,191,240,0,255,0,0,7,255,64,63,254,0,255,0,0,127,254,0,15,255,192,255,0,0,255,248,0,2,255,64,255,0,0,127,208,0,0,127,0,255,0,0,46,0,0,0,4,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,0,0,0,191,255,255,255,255,255,0,0,0,191,255,255,255,255,255,0,0,0,21,85,85,85,85,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,191,0,0,
  // 0xc798  잘
  152,199,34,37,77,37,2,252,0,0,0,0,0,0,255,0,0,21,85,85,85,85,0,255,0,0,63,255,255,255,255,0,255,0,0,63,255,255,255,255,0,255,0,0,63,255,255,255,255,0,255,0,0,0,0,191,128,0,0,255,0,0,0,0,191,192,0,0,255,0,0,0,0,255,192,0,0,255,149,64,0,0,255,208,0,0,255,255,208,0,2,255,240,0,0,255,255,208,0,3,255,248,0,0,255,255,208,0,15,251,253,0,0,255,0,0,0,47,242,255,64,0,255,0,0,0,255,208,255,244,0,255,0,0,11,255,64,63,255,64,255,0,0,191,254,0,11,255,192,255,0,0,255,244,0,1,255,64,255,0,0,127,128,0,0,26,0,255,0,0,36,0,0,0,0,0,85,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,255,255,255,255,255,208,0,0,63,255,255,255,255,255,208,0,0,63,255,255,255,255,255,208,0,0,0,0,0,0,0,0,0,0,
  // 0xc7a5  장
  165,199,34,37,77,37,2,252,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,21,85,85,85,85,0,255,0,0,63,255,255,255,255,64,255,0,0,63,255,255,255,255,64,255,0,0,63,255,255,255,255,64,255,0,0,0,0,127,128,0,0,255,0,0,0,0,191,192,0,0,255,0,0,0,0,191,192,0,0,255,149,64,0,0,255,192,0,0,255,255,208,0,0,255,224,0,0,255,255,208,0,2,255,240,0,0,255,255,208,0,3,255,248,0,0,255,0,0,0,15,247,254,0,0,255,0,0,0,47,241,255,128,0,255,0,0,0,191,208,191,244,0,255,0,0,7,255,128,47,255,64,255,0,0,47,255,0,11,255,192,255,0,0,255,252,0,1,255,64,255,0,0,191,224,0,0,47,0,255,0,0,63,64,0,0,0,0,255,0,0,4,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,255,248,0,0,0,0,0,191,255,255,255,208,0,0,0,7,255,255,255,255,248,0,0,0,31,255,64,0,111,254,0,0,0,63,240,0,0,3,255,0,0,0,127,192,0,0,0,255,64,0,0,127,128,0,0,0,191,128,0,0,127,128,0,0,0,191,128,0,0,63,192,0,0,0,255,64,0,0,63,244,0,0,7,255,0,0,0,15,255,149,85,191,253,0,0,0,3,255,255,255,255,244,0,0,0,0,127,255,255,255,128,0,0,0,0,2,191,255,164,0,0,0,
  // 0xc7ac  재
  172,199,31,37,40,37,2,252,0,0,0,0,1,168,3,252,0,0,0,0,2,252,3,252,0,0,0,0,2,252,3,252,0,0,0,0,2,252,3,252,127,255,255,255,194,252,3,252,127,255,255,255,194,252,3,252,127,255,255,255,194,252,3,252,21,87,253,85,66,252,3,252,0,3,252,0,2,252,3,252,0,3,252,0,2,252,3,252,0,3,252,0,2,252,3,252,0,3,252,0,2,252,3,252,0,3,253,0,2,252,3,252,0,7,253,0,2,252,3,252,0,7,254,0,2,253,87,252,0,11,255,0,2,255,255,252,0,15,255,0,2,255,255,252,0,15,255,64,2,255,255,252,0,31,255,192,2,252,3,252,0,63,239,192,2,252,3,252,0,127,143,240,2,252,3,252,0,255,79,248,2,252,3,252,1,255,7,253,2,252,3,252,3,253,2,255,66,252,3,252,15,252,0,255,226,252,3,252,127,240,0,63,242,252,3,252,255,208,0,15,210,252,3,252,191,64,0,2,130,252,3,252,45,0,0,0,2,252,3,252,0,0,0,0,2,252,3,252,0,0,0,0,2,252,3,252,0,0,0,0,2,252,3,252,0,0,0,0,2,252,3,252,0,0,0,0,2,252,3,252,0,0,0,0,2,252,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,2,252,
  // 0xc800  저
  0,200,30,37,40,37,2,252,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,21,85,85,85,85,64,15,240,63,255,255,255,255,192,15,240,63,255,255,255,255,192,15,240,63,255,255,255,255,192,15,240,0,0,63,192,0,0,15,240,0,0,63,192,0,0,15,240,0,0,63,192,0,0,15,240,0,0,63,192,0,0,15,240,0,0,127,192,0,0,15,240,0,0,127,192,0,0,15,240,0,0,191,208,3,255,255,240,0,0,191,224,3,255,255,240,0,0,255,240,3,255,255,240,0,1,255,244,1,85,95,240,0,2,255,248,0,0,15,240,0,3,250,252,0,0,15,240,0,11,245,255,0,0,15,240,0,31,240,255,128,0,15,240,0,63,208,127,208,0,15,240,0,191,192,63,240,0,15,240,2,255,64,15,252,0,15,240,11,254,0,7,255,64,15,240,63,252,0,2,255,240,15,240,255,240,0,0,191,224,15,240,191,192,0,0,31,192,15,240,62,0,0,0,2,0,15,240,4,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,
  // 0xc804  전
  4,200,31,36,32,37,2,253,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,5,85,85,85,85,0,15,240,63,255,255,255,255,128,15,240,63,255,255,255,255,128,15,240,63,255,255,255,255,128,15,240,0,0,63,192,0,0,15,240,0,0,63,192,0,0,15,240,0,0,63,192,0,0,15,240,0,0,127,208,1,85,95,240,0,0,191,224,2,255,255,240,0,0,255,240,2,255,255,240,0,1,255,248,2,255,255,240,0,3,255,252,0,0,15,240,0,11,249,255,0,0,15,240,0,47,240,255,192,0,15,240,0,191,208,127,244,0,15,240,7,255,128,31,255,64,15,240,127,255,0,7,255,208,15,240,191,248,0,1,255,128,15,240,63,224,0,0,47,0,15,240,30,0,0,0,1,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,2,164,0,0,0,15,240,0,7,248,0,0,0,15,240,0,7,248,0,0,0,15,240,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,253,85,85,85,85,84,0,7,255,255,255,255,255,252,0,7,255,255,255,255,255,252,0,7,255,255,255,255,255,252,
  // 0xc815  정
  21,200,30,38,48,37,2,252,0,0,0,0,0,0,5,80,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,63,255,255,255,255,128,15,240,63,255,255,255,255,128,15,240,63,255,255,255,255,128,15,240,21,85,127,213,85,0,15,240,0,0,63,192,0,0,15,240,0,0,127,192,0,0,15,240,0,0,127,208,0,0,15,240,0,0,191,224,2,255,255,240,0,0,255,240,2,255,255,240,0,1,255,248,2,255,255,240,0,3,255,252,0,85,95,240,0,11,249,255,0,0,15,240,0,31,240,255,192,0,15,240,0,191,224,127,244,0,15,240,2,255,192,31,255,64,15,240,47,255,0,11,255,208,15,240,191,252,0,1,255,128,15,240,63,240,0,0,47,0,15,240,47,64,0,0,1,0,15,240,4,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,0,0,1,191,255,254,64,0,0,0,47,255,255,255,244,0,0,0,255,255,255,255,255,0,0,3,255,228,0,27,255,192,0,11,253,0,0,0,127,224,0,15,244,0,0,0,31,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,15,240,0,15,244,0,0,0,47,240,0,11,253,0,0,0,191,208,0,3,255,229,65,95,255,192,0,0,255,255,255,255,254,0,0,0,31,255,255,255,244,0,0,0,0,111,255,249,0,0,
  // 0xc81c  제
  28,200,32,38,48,37,1,252,0,0,0,0,0,0,0,85,0,0,0,0,0,42,64,255,0,0,0,0,0,127,128,255,0,0,0,0,0,127,128,255,5,85,85,85,80,127,128,255,31,255,255,255,240,127,128,255,31,255,255,255,240,127,128,255,31,255,255,255,240,127,128,255,0,0,255,0,0,127,128,255,0,0,255,0,0,127,128,255,0,0,255,0,0,127,128,255,0,0,255,0,0,127,128,255,0,0,255,0,0,127,128,255,0,1,255,0,85,191,128,255,0,1,255,66,255,255,128,255,0,1,255,66,255,255,128,255,0,2,255,130,255,255,128,255,0,3,255,192,0,127,128,255,0,7,255,208,0,127,128,255,0,11,255,224,0,127,128,255,0,15,235,240,0,127,128,255,0,47,211,252,0,127,128,255,0,63,195,253,0,127,128,255,0,191,129,255,0,127,128,255,1,255,0,255,192,127,128,255,7,254,0,63,240,127,128,255,31,252,0,31,252,127,128,255,127,240,0,11,248,127,128,255,47,208,0,1,240,127,128,255,15,0,0,0,64,127,128,255,0,0,0,0,0,127,128,255,0,0,0,0,0,127,128,255,0,0,0,0,0,127,128,255,0,0,0,0,0,127,128,255,0,0,0,0,0,127,128,255,0,0,0,0,0,127,64,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,170,
  // 0xc8fd  죽
  253,200,33,36,68,37,2,252,3,255,255,255,255,255,255,224,0,3,255,255,255,255,255,255,224,0,3,255,255,255,255,255,255,224,0,1,85,85,111,253,85,85,64,0,0,0,0,63,254,0,0,0,0,0,0,0,127,255,0,0,0,0,0,0,1,255,255,192,0,0,0,0,0,7,255,63,240,0,0,0,0,0,127,252,31,254,0,0,0,0,7,255,240,7,255,228,0,0,11,255,255,128,0,255,255,228,0,15,255,253,0,0,47,255,248,0,11,255,144,0,0,1,255,240,0,3,164,0,0,0,0,6,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,95,249,85,85,85,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,85,85,95,249,85,85,0,0,1,255,255,255,255,255,255,128,0,1,255,255,255,255,255,255,128,0,1,255,255,255,255,255,255,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,
  // 0xc900  준
  0,201,33,35,59,37,2,253,1,85,85,85,85,85,85,64,0,3,255,255,255,255,255,255,224,0,3,255,255,255,255,255,255,224,0,3,255,255,255,255,255,255,224,0,0,0,0,47,252,0,0,0,0,0,0,0,63,254,0,0,0,0,0,0,0,127,255,0,0,0,0,0,0,0,255,255,192,0,0,0,0,0,3,255,63,224,0,0,0,0,0,47,252,31,253,0,0,0,0,1,255,240,11,255,208,0,0,1,191,255,192,1,255,254,144,0,15,255,254,0,0,63,255,248,0,11,255,224,0,0,7,255,244,0,3,249,0,0,0,0,47,240,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,85,0,7,248,0,0,0,0,0,255,0,7,248,0,0,0,0,0,255,0,7,248,0,0,0,0,0,255,0,7,248,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,85,85,85,85,85,64,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,
  // 0xc911  중
  17,201,33,36,68,37,2,252,1,85,85,85,85,85,85,64,0,3,255,255,255,255,255,255,224,0,3,255,255,255,255,255,255,224,0,3,255,255,255,255,255,255,224,0,0,0,0,47,253,0,0,0,0,0,0,0,63,255,0,0,0,0,0,0,0,255,255,128,0,0,0,0,0,3,255,127,224,0,0,0,0,0,47,253,47,253,0,0,0,0,6,255,244,11,255,224,0,0,6,255,255,192,1,255,255,228,0,15,255,253,0,0,47,255,248,0,11,255,144,0,0,1,255,240,0,3,148,0,0,0,0,6,160,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,27,255,255,232,0,0,0,0,2,255,255,255,255,208,0,0,0,31,255,255,255,255,248,0,0,0,63,254,64,0,111,254,0,0,0,255,192,0,0,2,255,64,0,0,255,64,0,0,0,191,128,0,0,255,0,0,0,0,127,128,0,0,255,64,0,0,0,255,128,0,0,191,208,0,0,2,255,0,0,0,63,254,84,5,191,254,0,0,0,15,255,255,255,255,248,0,0,0,1,255,255,255,255,128,0,0,0,0,6,255,255,164,0,0,0,
  // 0xc990  즐
  144,201,33,36,68,37,2,252,3,255,255,255,255,255,255,224,0,3,255,255,255,255,255,255,224,0,3,255,255,255,255,255,255,224,0,0,0,0,31,253,0,0,0,0,0,0,0,47,253,0,0,0,0,0,0,0,127,255,0,0,0,0,0,0,1,255,255,192,0,0,0,0,0,11,254,63,248,0,0,0,0,1,191,252,15,255,128,0,0,5,191,255,224,2,255,254,144,0,15,255,255,0,0,127,255,252,0,11,255,224,0,0,6,255,244,0,7,229,0,0,0,0,22,240,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,
  // 0xc9c0  지
  192,201,30,37,40,37,2,252,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,21,85,85,85,85,64,31,224,63,255,255,255,255,208,31,224,63,255,255,255,255,208,31,224,63,255,255,255,255,208,31,224,0,0,63,208,0,0,31,224,0,0,63,208,0,0,31,224,0,0,63,208,0,0,31,224,0,0,63,208,0,0,31,224,0,0,63,208,0,0,31,224,0,0,63,208,0,0,31,224,0,0,63,224,0,0,31,224,0,0,127,240,0,0,31,224,0,0,191,240,0,0,31,224,0,0,255,248,0,0,31,224,0,1,255,252,0,0,31,224,0,2,254,253,0,0,31,224,0,3,248,255,0,0,31,224,0,15,244,191,128,0,31,224,0,47,240,63,208,0,31,224,0,127,208,31,244,0,31,224,0,255,128,15,254,0,31,224,7,255,0,3,255,192,31,224,47,253,0,0,255,244,31,224,255,244,0,0,63,240,31,224,127,208,0,0,11,208,31,224,47,0,0,0,0,64,31,224,4,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,26,160,
  // 0xcc98  처
  152,204,30,38,48,37,2,252,0,0,0,0,0,0,5,80,0,0,42,128,0,0,15,240,0,0,63,192,0,0,15,240,0,0,63,192,0,0,15,240,0,0,63,192,0,0,15,240,0,0,63,192,0,0,15,240,0,0,63,192,0,0,15,240,63,255,255,255,255,128,15,240,63,255,255,255,255,128,15,240,63,255,255,255,255,128,15,240,21,85,127,213,85,0,15,240,0,0,63,192,0,0,15,240,0,0,63,192,0,0,15,240,0,0,63,192,0,0,15,240,0,0,127,192,0,0,15,240,0,0,127,208,7,255,255,240,0,0,191,224,7,255,255,240,0,0,255,240,7,255,255,240,0,1,255,244,1,85,95,240,0,3,255,252,0,0,15,240,0,7,250,253,0,0,15,240,0,15,240,255,0,0,15,240,0,47,224,191,192,0,15,240,0,127,192,63,224,0,15,240,1,255,128,31,248,0,15,240,7,255,0,15,255,0,15,240,47,253,0,3,255,208,15,240,255,244,0,0,255,208,15,240,63,208,0,0,47,128,15,240,47,0,0,0,2,0,15,240,4,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,
  // 0xcd08  초
  8,205,33,33,41,37,2,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,3,255,255,255,255,255,255,224,0,3,255,255,255,255,255,255,224,0,3,255,255,255,255,255,255,224,0,1,85,85,95,249,85,85,80,0,0,0,0,15,248,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,47,253,0,0,0,0,0,0,0,63,255,0,0,0,0,0,0,0,255,255,128,0,0,0,0,0,2,255,127,208,0,0,0,0,0,15,253,47,248,0,0,0,0,0,127,248,15,255,64,0,0,0,11,255,224,2,255,244,0,0,6,255,255,64,0,191,255,164,0,15,255,248,0,0,31,255,252,0,15,255,128,0,0,1,255,248,0,7,228,0,11,244,0,6,240,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,85,85,85,85,85,64,
  // 0xcd95  축
  149,205,33,38,86,37,2,252,0,0,0,5,80,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,3,255,255,255,255,255,255,208,0,3,255,255,255,255,255,255,208,0,3,255,255,255,255,255,255,208,0,0,0,0,31,252,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,63,254,0,0,0,0,0,0,0,255,255,128,0,0,0,0,0,7,255,127,240,0,0,0,0,0,127,252,31,254,64,0,0,0,111,255,240,7,255,249,64,0,15,255,255,64,0,191,255,248,0,11,255,244,0,0,11,255,244,0,7,233,0,0,0,0,27,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,95,249,85,85,85,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,1,255,255,255,255,255,255,128,0,1,255,255,255,255,255,255,128,0,1,255,255,255,255,255,255,128,0,0,85,85,85,85,85,191,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,106,64,0,
  // 0xcd9c  출
  156,205,33,38,86,37,2,252,0,0,0,5,80,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,15,244,0,0,0,0,2,255,255,255,255,255,255,208,0,2,255,255,255,255,255,255,208,0,2,255,255,255,255,255,255,208,0,0,0,0,31,252,0,0,0,0,0,0,0,63,254,0,0,0,0,0,0,0,255,255,128,0,0,0,0,0,7,254,63,244,0,0,0,0,1,191,248,15,255,144,0,0,10,255,255,128,1,255,255,164,0,15,255,248,0,0,27,255,248,0,11,233,0,0,0,0,107,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,127,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,
  // 0xcda4  춤
  164,205,33,38,86,37,2,252,0,0,0,5,80,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,2,255,255,255,255,255,255,208,0,2,255,255,255,255,255,255,208,0,2,255,255,255,255,255,255,208,0,0,0,0,31,252,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,63,254,0,0,0,0,0,0,0,255,255,128,0,0,0,0,0,7,255,127,240,0,0,0,0,0,191,252,31,255,64,0,0,1,111,255,240,7,255,254,80,0,15,255,255,64,0,191,255,248,0,11,255,228,0,0,7,255,244,0,7,229,0,0,0,0,26,240,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,85,85,95,249,85,85,0,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,85,85,85,85,85,85,0,0,
  // 0xcde8  취
  232,205,30,37,40,37,2,252,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,31,244,0,0,15,240,11,255,255,255,255,224,15,240,11,255,255,255,255,224,15,240,11,255,255,255,255,224,15,240,0,0,15,240,0,0,15,240,0,0,31,244,0,0,15,240,0,0,47,248,0,0,15,240,0,0,63,253,0,0,15,240,0,0,255,255,0,0,15,240,0,3,255,191,224,0,15,240,0,31,252,63,253,0,15,240,2,255,244,15,255,240,15,240,31,255,208,2,255,240,15,240,15,254,0,0,127,208,15,240,7,224,0,0,1,128,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,85,15,240,85,85,106,175,255,254,15,240,255,255,255,255,255,254,15,240,191,255,255,255,255,249,15,240,191,255,255,249,80,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,10,160,0,0,15,240,0,0,0,0,0,0,15,224,
  // 0xce58  치
  88,206,30,38,48,37,2,252,0,0,0,0,0,0,5,64,0,0,10,144,0,0,31,240,0,0,31,224,0,0,31,240,0,0,31,224,0,0,31,240,0,0,31,224,0,0,31,240,0,0,31,224,0,0,31,240,0,0,31,224,0,0,31,240,31,255,255,255,255,224,31,240,31,255,255,255,255,224,31,240,31,255,255,255,255,224,31,240,5,85,111,245,85,64,31,240,0,0,31,224,0,0,31,240,0,0,31,224,0,0,31,240,0,0,47,224,0,0,31,240,0,0,47,240,0,0,31,240,0,0,63,240,0,0,31,240,0,0,63,240,0,0,31,240,0,0,127,248,0,0,31,240,0,0,191,252,0,0,31,240,0,0,255,253,0,0,31,240,0,1,253,255,0,0,31,240,0,3,252,191,128,0,31,240,0,11,248,63,208,0,31,240,0,31,240,47,244,0,31,240,0,127,208,15,253,0,31,240,2,255,128,3,255,64,31,240,11,255,0,1,255,244,31,240,127,252,0,0,127,244,31,240,63,240,0,0,15,224,31,240,15,128,0,0,1,192,31,240,4,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,26,160,
  // 0xce68  침
  104,206,30,38,48,37,2,252,0,0,5,64,0,0,0,0,0,0,47,224,0,0,31,240,0,0,47,224,0,0,31,240,0,0,47,224,0,0,31,240,5,85,111,229,85,64,31,240,31,255,255,255,255,208,31,240,31,255,255,255,255,208,31,240,31,255,255,255,255,208,31,240,0,0,47,224,0,0,31,240,0,0,47,224,0,0,31,240,0,0,63,240,0,0,31,240,0,0,63,240,0,0,31,240,0,0,191,248,0,0,31,240,0,0,255,253,0,0,31,240,0,3,255,255,0,0,31,240,0,11,252,255,192,0,31,240,0,47,244,63,244,0,31,240,1,255,224,31,255,64,31,240,31,255,128,7,255,240,31,240,127,254,0,0,255,240,31,240,47,244,0,0,47,192,31,240,15,128,0,0,1,128,31,240,4,0,0,0,0,0,31,224,0,0,0,0,0,0,0,0,0,1,85,85,85,85,85,64,0,15,255,255,255,255,255,240,0,15,255,255,255,255,255,240,0,15,255,255,255,255,255,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,15,240,0,15,255,255,255,255,255,240,0,15,255,255,255,255,255,240,0,15,255,255,255,255,255,240,0,1,85,85,85,85,85,64,
  // 0xce74  카
  116,206,34,37,77,37,2,252,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,5,85,85,85,80,0,255,0,0,15,255,255,255,248,0,255,0,0,15,255,255,255,248,0,255,0,0,15,255,255,255,248,0,255,0,0,0,0,0,7,248,0,255,0,0,0,0,0,11,244,0,255,0,0,0,0,0,15,244,0,255,0,0,0,0,0,15,240,0,255,0,0,0,0,0,15,240,0,255,0,0,0,0,0,31,224,0,255,0,0,21,170,255,255,208,0,255,0,0,127,255,255,255,192,0,255,85,64,127,255,255,255,192,0,255,255,208,63,254,149,255,128,0,255,255,208,16,0,1,255,0,0,255,255,208,0,0,3,254,0,0,255,0,0,0,0,11,252,0,0,255,0,0,0,0,31,244,0,0,255,0,0,0,0,127,240,0,0,255,0,0,0,1,255,192,0,0,255,0,0,0,7,255,64,0,0,255,0,0,0,47,253,0,0,0,255,0,0,0,255,244,0,0,0,255,0,0,11,255,192,0,0,0,255,0,0,127,255,0,0,0,0,255,0,0,127,248,0,0,0,0,255,0,0,47,128,0,0,0,0,255,0,0,13,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,170,0,0,
  // 0xcf1c  켜
  28,207,30,37,40,37,2,252,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,5,85,85,85,80,0,15,240,15,255,255,255,244,0,15,240,15,255,255,255,240,0,15,240,15,255,255,255,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,15,240,0,15,240,0,0,0,31,255,255,255,240,0,0,0,31,255,255,255,240,0,0,0,63,255,255,255,240,90,175,255,255,213,85,95,240,255,255,255,255,192,0,15,240,191,255,255,255,64,0,15,240,127,169,81,255,0,0,15,240,0,0,3,254,0,0,15,240,0,0,11,252,0,0,15,240,0,0,15,248,21,85,95,240,0,0,63,240,127,255,255,240,0,0,255,208,127,255,255,240,0,3,255,128,127,255,255,240,0,15,254,0,0,0,15,240,0,127,248,0,0,0,15,240,2,255,224,0,0,0,15,240,31,255,128,0,0,0,15,240,255,253,0,0,0,0,15,240,127,240,0,0,0,0,15,240,47,64,0,0,0,0,15,240,8,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,10,160,
  // 0xd0d1  탑
  209,208,33,38,86,37,3,252,0,0,0,0,0,1,84,0,0,0,0,0,0,0,3,252,0,0,21,85,85,85,64,3,252,0,0,127,255,255,255,192,3,252,0,0,127,255,255,255,192,3,252,0,0,127,255,255,255,192,3,252,0,0,127,128,0,0,0,3,252,0,0,127,128,0,0,0,3,252,0,0,127,128,0,0,0,3,252,0,0,127,149,85,85,0,3,255,255,64,127,255,255,255,128,3,255,255,64,127,255,255,255,128,3,255,255,64,127,255,255,255,128,3,254,85,0,127,128,0,0,0,3,252,0,0,127,128,0,0,0,3,252,0,0,127,128,0,0,0,3,252,0,0,127,128,0,22,189,3,252,0,0,127,255,255,255,254,3,252,0,0,127,255,255,255,254,3,252,0,0,127,255,255,255,165,3,252,0,0,21,85,80,0,0,3,252,0,0,0,0,0,0,0,1,84,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,0,3,252,0,0,0,255,0,0,0,3,252,0,0,0,255,0,0,0,3,252,0,0,0,255,64,0,0,3,252,0,0,0,255,255,255,255,255,252,0,0,0,255,255,255,255,255,252,0,0,0,255,255,255,255,255,252,0,0,0,255,0,0,0,3,252,0,0,0,255,0,0,0,3,252,0,0,0,255,0,0,0,3,252,0,0,0,255,0,0,0,3,252,0,0,0,255,255,255,255,255,252,0,0,0,255,255,255,255,255,252,0,0,0,255,255,255,255,255,252,0,0,0,85,85,85,85,85,84,0,0,
  // 0xd130  터
  48,209,29,38,48,37,3,252,0,0,0,0,0,0,21,64,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,127,255,255,255,208,0,63,192,127,255,255,255,208,0,63,192,127,255,255,255,208,0,63,192,127,213,85,85,64,0,63,192,127,128,0,0,0,0,63,192,127,128,0,0,0,0,63,192,127,128,0,0,0,0,63,192,127,128,0,0,0,0,63,192,127,128,0,0,0,0,63,192,127,128,0,0,0,0,63,192,127,213,85,85,15,255,255,192,127,255,255,255,15,255,255,192,127,255,255,255,15,255,255,192,127,255,255,255,15,255,255,192,127,128,0,0,0,0,63,192,127,128,0,0,0,0,63,192,127,128,0,0,0,0,63,192,127,128,0,0,0,0,63,192,127,128,0,0,0,0,63,192,127,128,0,0,0,0,63,192,127,128,0,0,4,0,63,192,127,213,86,175,253,0,63,192,127,255,255,255,254,0,63,192,127,255,255,255,254,0,63,192,127,255,255,233,64,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,
  // 0xd14c  테
  76,209,30,38,48,37,3,252,0,0,0,0,0,0,5,80,0,0,0,0,1,80,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,255,255,255,224,7,244,15,240,255,255,255,224,7,244,15,240,255,255,255,224,7,244,15,240,255,85,85,64,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,5,91,244,15,240,255,255,255,15,255,244,15,240,255,255,255,15,255,244,15,240,255,255,255,15,255,244,15,240,255,64,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,0,0,0,7,244,15,240,255,85,106,253,7,244,15,240,255,255,255,253,7,244,15,240,255,255,255,254,7,244,15,240,255,255,254,148,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,7,244,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,10,160,
  // 0xd1a0  토
  160,209,33,31,23,37,2,0,0,85,85,85,85,85,85,64,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,255,255,255,255,255,255,0,0,0,255,255,255,255,255,255,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,85,85,85,85,85,64,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,85,85,85,85,85,85,85,85,64,
  // 0xd2b8  트
  184,210,33,30,14,37,2,1,0,85,85,85,85,85,85,64,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,0,255,255,255,255,255,255,0,0,0,255,255,255,255,255,255,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,85,85,85,85,85,85,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0xd39c  펜
  156,211,32,37,40,37,2,253,0,0,0,0,0,0,1,84,0,0,0,0,0,170,3,248,0,0,0,0,0,255,3,248,0,0,0,0,0,255,3,248,191,255,255,255,192,255,3,248,191,255,255,255,192,255,3,248,191,255,255,255,192,255,3,248,23,253,91,249,64,255,3,248,3,252,7,244,0,255,3,248,3,252,7,244,0,255,3,248,3,252,7,244,0,255,3,248,3,252,7,244,255,255,3,248,3,252,7,244,255,255,3,248,3,252,7,244,255,255,3,248,3,252,7,244,85,255,3,248,3,252,7,244,0,255,3,248,3,252,7,244,0,255,3,248,3,252,7,244,0,255,3,248,3,252,7,250,160,255,3,248,255,255,255,255,240,255,3,248,255,255,255,255,240,255,3,248,255,255,255,254,80,255,3,248,85,85,0,0,0,255,3,248,0,0,0,0,0,255,3,248,0,0,0,0,0,255,3,248,0,3,252,0,0,255,3,248,0,3,252,0,0,255,3,248,0,3,252,0,0,105,3,248,0,3,252,0,0,0,1,80,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,253,85,85,85,85,85,0,3,255,255,255,255,255,254,0,3,255,255,255,255,255,254,0,3,255,255,255,255,255,254,
  // 0xd504  프
  4,213,33,29,5,37,2,1,7,255,255,255,255,255,255,240,0,7,255,255,255,255,255,255,240,0,7,255,255,255,255,255,255,240,0,1,85,255,85,85,191,149,80,0,0,0,255,0,0,191,128,0,0,0,0,255,0,0,191,128,0,0,0,0,255,0,0,191,128,0,0,0,0,255,0,0,191,128,0,0,0,0,255,0,0,191,128,0,0,0,0,255,0,0,191,128,0,0,0,0,255,0,0,191,128,0,0,0,0,255,0,0,191,128,0,0,0,0,255,0,0,191,128,0,0,0,0,255,0,0,191,128,0,0,0,0,255,0,0,191,128,0,0,1,85,255,85,85,191,149,80,0,3,255,255,255,255,255,255,240,0,3,255,255,255,255,255,255,240,0,3,255,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0xd558  하
  88,213,34,37,77,37,2,252,0,0,21,0,0,0,255,0,0,0,0,191,128,0,0,255,0,0,0,0,191,128,0,0,255,0,0,0,0,191,128,0,0,255,0,0,0,0,191,128,0,0,255,0,0,85,85,191,149,85,64,255,0,0,255,255,255,255,255,192,255,0,0,255,255,255,255,255,192,255,0,0,255,255,255,255,255,192,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,21,0,0,0,255,0,0,0,11,255,248,0,0,255,0,0,0,127,255,255,64,0,255,0,0,1,255,255,255,208,0,255,85,80,3,255,64,127,240,0,255,255,224,11,252,0,15,248,0,255,255,224,15,244,0,3,252,0,255,255,224,15,240,0,2,253,0,255,0,0,31,224,0,2,253,0,255,0,0,31,224,0,1,253,0,255,0,0,31,224,0,2,253,0,255,0,0,15,240,0,3,252,0,255,0,0,15,248,0,7,252,0,255,0,0,7,253,0,31,244,0,255,0,0,3,255,230,255,240,0,255,0,0,0,255,255,255,192,0,255,0,0,0,47,255,254,0,0,255,0,0,0,2,255,224,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,
  // 0xd569  합
  105,213,34,38,86,37,2,252,0,0,42,128,0,0,0,0,0,0,0,127,192,0,0,255,0,0,0,0,127,192,0,0,255,0,0,0,0,127,192,0,0,255,0,0,255,255,255,255,255,208,255,0,0,255,255,255,255,255,208,255,0,0,255,255,255,255,255,208,255,0,0,85,85,85,85,85,64,255,0,0,0,0,0,0,0,0,255,0,0,0,2,191,228,0,0,255,0,0,0,127,255,255,64,0,255,255,208,1,255,255,255,240,0,255,255,208,3,255,64,111,248,0,255,255,208,11,248,0,7,252,0,255,149,64,15,240,0,2,253,0,255,0,0,15,240,0,2,253,0,255,0,0,15,240,0,2,253,0,255,0,0,11,248,0,7,252,0,255,0,0,3,255,64,111,248,0,255,0,0,1,255,255,255,240,0,255,0,0,0,127,255,255,64,0,255,0,0,0,2,191,228,0,0,255,0,0,0,0,0,0,0,0,85,0,0,0,21,64,0,0,0,85,0,0,0,63,192,0,0,0,255,0,0,0,63,192,0,0,0,255,0,0,0,63,192,0,0,0,255,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,208,0,0,0,255,0,0,0,63,192,0,0,0,255,0,0,0,63,192,0,0,0,255,0,0,0,63,192,0,0,0,255,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,5,85,85,85,85,85,0,0,
  // 0xd648  홈
  72,214,33,38,86,37,2,252,0,0,0,6,164,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,15,248,0,0,0,0,31,255,255,255,255,255,255,252,0,31,255,255,255,255,255,255,252,0,31,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,26,255,255,228,0,0,0,0,2,255,255,255,255,208,0,0,0,15,255,255,255,255,252,0,0,0,63,249,0,0,31,254,0,0,0,127,208,0,0,2,255,0,0,0,127,192,0,0,1,255,0,0,0,127,208,0,0,2,255,0,0,0,63,253,64,0,111,254,0,0,0,15,255,255,255,255,248,0,0,0,1,255,255,255,255,144,0,0,0,0,6,175,254,148,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,0,0,0,0,127,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,
  // 0xd654  화
  84,214,35,37,77,37,1,252,0,0,15,240,0,0,63,208,0,0,0,15,240,0,0,63,208,0,0,0,15,240,0,0,63,208,0,0,0,15,240,0,0,63,208,0,63,255,255,255,255,248,63,208,0,63,255,255,255,255,248,63,208,0,63,255,255,255,255,248,63,208,0,21,85,85,85,85,80,63,208,0,0,0,0,0,0,0,63,208,0,0,0,111,249,0,0,63,208,0,0,7,255,255,224,0,63,208,0,0,63,255,255,252,0,63,208,0,0,191,228,27,254,0,63,208,0,0,255,64,1,255,0,63,208,0,1,254,0,0,191,64,63,208,0,2,253,0,0,127,128,63,255,244,2,253,0,0,127,128,63,255,244,1,254,0,0,191,64,63,255,244,0,255,64,1,255,0,63,229,80,0,191,224,11,254,0,63,208,0,0,63,255,255,252,0,63,208,0,0,11,255,255,224,0,63,208,0,0,0,191,254,64,0,63,208,0,0,0,15,240,0,0,63,208,0,0,0,15,240,0,0,63,208,0,0,0,15,240,0,20,63,208,0,21,85,111,251,255,252,63,208,0,127,255,255,255,255,253,63,208,0,63,255,255,255,255,248,63,208,0,63,255,255,170,80,0,63,208,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,42,128,0,
  // 0xd788  히
  136,215,29,37,40,37,3,252,0,0,21,64,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,85,85,191,213,85,64,127,128,255,255,255,255,255,208,127,128,255,255,255,255,255,208,127,128,255,255,255,255,255,208,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,21,0,0,0,127,128,0,11,255,248,0,0,127,128,0,127,255,255,64,0,127,128,1,255,255,255,224,0,127,128,3,255,64,127,244,0,127,128,11,252,0,11,252,0,127,128,15,244,0,3,252,0,127,128,31,240,0,2,254,0,127,128,31,224,0,1,254,0,127,128,31,224,0,1,254,0,127,128,31,224,0,1,254,0,127,128,15,240,0,2,253,0,127,128,15,248,0,7,252,0,127,128,7,253,0,31,248,0,127,128,3,255,230,255,240,0,127,128,0,255,255,255,192,0,127,128,0,47,255,255,0,0,127,128,0,2,255,228,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,
};

#endif // HAS_GRAPHICAL_TFT
