/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Cyrillic 40pt, capital 'A' height: 29px, width: 100%, range: 0x0401-0x0491, glyphs: 74
extern const uint8_t NotoSans_Medium_Cyrillic_29[10751] = {
  130,29,1,4,145,4,38,246, // unifont_t
  // 0x0401  Ё
  16,37,148,22,4,0,1,64,1,64,7,240,15,224,15,244,15,240,11,244,15,240,2,224,7,208,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x0402  Ђ
  255,
  // 0x0403  Ѓ
  255,
  // 0x0404  Є
  23,30,180,26,2,255,0,0,26,255,249,0,0,1,255,255,255,228,0,31,255,255,255,248,0,127,255,255,255,240,1,255,244,0,7,224,3,255,128,0,0,0,11,253,0,0,0,0,15,248,0,0,0,0,47,240,0,0,0,0,63,224,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,234,170,170,164,0,191,255,255,255,244,0,191,255,255,255,244,0,191,255,255,255,244,0,191,192,0,0,0,0,127,192,0,0,0,0,127,208,0,0,0,0,63,224,0,0,0,0,63,240,0,0,0,0,47,244,0,0,0,0,15,252,0,0,0,0,11,255,0,0,0,0,3,255,208,0,0,16,0,255,254,85,111,240,0,127,255,255,255,240,0,11,255,255,255,240,0,0,191,255,255,128,0,0,1,85,64,0,
  // 0x0405  Ѕ
  255,
  // 0x0406  І
  12,29,87,14,1,0,106,170,169,127,255,254,127,255,254,11,255,228,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,1,255,128,127,255,253,127,255,254,127,255,254,
  // 0x0407  Ї
  12,37,111,14,1,0,20,0,20,191,0,254,255,64,255,191,64,255,45,0,124,0,0,0,0,0,0,0,0,0,106,170,169,127,255,254,127,255,254,11,255,228,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,1,255,128,127,255,253,127,255,254,127,255,254,
  // 0x0408  Ј
  255,
  // 0x0409  Љ
  255,
  // 0x040a  Њ
  255,
  // 0x040b  Ћ
  255,
  // 0x040c  Ќ
  255,
  // 0x040d  Ѝ
  255,
  // 0x040e  Ў
  255,
  // 0x040f  Џ
  255,
  // 0x0410  А
  26,29,203,26,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x0411  Б
  19,29,145,25,4,0,170,170,170,170,128,255,255,255,255,192,255,255,255,255,192,255,255,255,255,192,255,64,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,255,234,64,0,255,255,255,248,0,255,255,255,255,64,255,255,255,255,208,255,0,1,191,240,255,0,0,47,244,255,0,0,15,248,255,0,0,11,252,255,0,0,11,252,255,0,0,11,252,255,0,0,15,248,255,0,0,31,244,255,0,0,191,240,255,170,175,255,208,255,255,255,255,128,255,255,255,253,0,255,255,254,144,0,
  // 0x0412  В
  20,29,145,26,4,0,170,170,165,0,0,255,255,255,249,0,255,255,255,255,192,255,255,255,255,240,255,0,1,191,248,255,0,0,31,252,255,0,0,11,252,255,0,0,7,252,255,0,0,7,252,255,0,0,7,252,255,0,0,15,248,255,0,0,47,240,255,170,171,255,192,255,255,255,249,0,255,255,255,254,0,255,255,255,255,224,255,0,0,111,248,255,0,0,11,253,255,0,0,3,255,255,0,0,2,255,255,0,0,1,255,255,0,0,2,255,255,0,0,3,255,255,0,0,7,254,255,0,0,31,253,255,170,171,255,248,255,255,255,255,224,255,255,255,255,64,255,255,255,228,0,
  // 0x0413  Г
  17,29,145,21,4,0,170,170,170,170,64,255,255,255,255,64,255,255,255,255,64,255,255,255,255,64,255,64,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,
  // 0x0414  Д
  28,37,3,29,0,248,0,0,10,170,170,170,0,0,0,31,255,255,255,0,0,0,31,255,255,255,0,0,0,47,255,255,255,0,0,0,47,208,1,255,0,0,0,63,192,1,255,0,0,0,63,192,1,255,0,0,0,127,192,1,255,0,0,0,127,192,1,255,0,0,0,191,128,1,255,0,0,0,255,64,1,255,0,0,0,255,0,1,255,0,0,1,255,0,1,255,0,0,2,254,0,1,255,0,0,3,253,0,1,255,0,0,7,252,0,1,255,0,0,11,248,0,1,255,0,0,15,240,0,1,255,0,0,31,240,0,1,255,0,0,63,224,0,1,255,0,0,127,192,0,1,255,0,0,191,192,0,1,255,0,0,255,64,0,1,255,0,2,255,0,0,1,255,0,3,253,0,0,1,255,0,191,255,255,255,255,255,253,255,255,255,255,255,255,254,255,255,255,255,255,255,254,255,255,255,255,255,255,254,255,64,0,0,0,2,254,255,64,0,0,0,2,254,255,64,0,0,0,2,254,255,64,0,0,0,2,254,255,64,0,0,0,2,254,255,64,0,0,0,2,254,255,64,0,0,0,2,254,191,64,0,0,0,1,253,
  // 0x0415  Е
  16,29,116,22,4,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x0416  Ж
  35,29,5,35,0,0,42,128,0,0,169,0,0,10,164,47,240,0,1,254,0,0,47,240,15,248,0,1,254,0,0,127,192,3,253,0,1,254,0,0,255,64,1,255,0,1,254,0,3,254,0,0,191,192,1,254,0,11,252,0,0,63,224,1,254,0,31,240,0,0,15,244,1,254,0,127,208,0,0,7,252,1,254,0,255,64,0,0,2,255,1,254,2,254,0,0,0,0,255,129,254,11,252,0,0,0,0,63,209,254,31,240,0,0,0,0,31,241,254,63,208,0,0,0,0,7,254,254,255,128,0,0,0,0,3,255,255,255,64,0,0,0,0,15,253,254,191,192,0,0,0,0,47,241,254,63,240,0,0,0,0,127,209,254,15,248,0,0,0,0,255,129,254,7,253,0,0,0,3,255,1,254,2,255,0,0,0,11,252,1,254,0,255,192,0,0,31,244,1,254,0,63,224,0,0,63,224,1,254,0,31,244,0,0,255,192,1,254,0,11,252,0,2,255,0,1,254,0,3,255,0,7,253,0,1,254,0,1,255,128,15,248,0,1,254,0,0,191,208,63,240,0,1,254,0,0,63,240,191,192,0,1,254,0,0,15,252,
  // 0x0417  З
  21,30,180,24,1,255,0,6,255,233,0,0,1,255,255,255,208,0,31,255,255,255,244,0,63,255,170,255,253,0,31,224,0,11,255,0,9,0,0,2,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,1,255,0,0,0,0,3,254,0,0,0,0,47,252,0,0,106,171,255,224,0,0,255,255,249,0,0,0,255,255,254,64,0,0,255,255,255,244,0,0,0,0,127,253,0,0,0,0,3,255,0,0,0,0,0,255,128,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,192,0,0,0,0,255,128,96,0,0,3,255,64,127,148,1,111,254,0,127,255,255,255,252,0,127,255,255,255,224,0,11,255,255,253,0,0,0,5,85,0,0,0,
  // 0x0418  И
  24,29,174,31,4,0,169,0,0,0,6,169,255,0,0,0,15,254,255,0,0,0,47,254,255,0,0,0,127,254,255,0,0,0,255,254,255,0,0,2,255,254,255,0,0,7,253,254,255,0,0,15,248,254,255,0,0,47,240,254,255,0,0,63,208,254,255,0,0,255,193,254,255,0,2,255,1,254,255,0,3,253,1,254,255,0,15,252,1,254,255,0,31,240,1,254,255,0,63,224,1,254,255,0,255,192,1,254,255,1,255,0,1,254,254,3,254,0,1,254,254,11,252,0,1,254,254,31,244,0,1,254,254,63,224,0,1,254,254,191,192,0,1,254,255,255,64,0,1,254,255,254,0,0,1,254,255,252,0,0,1,254,255,244,0,0,1,254,255,240,0,0,1,254,255,192,0,0,1,254,
  // 0x0419  Й
  24,38,228,31,4,0,0,106,0,0,106,0,0,191,64,0,255,0,0,127,128,1,255,0,0,63,224,7,253,0,0,31,255,255,248,0,0,7,255,255,224,0,0,0,106,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,169,0,0,0,6,169,255,0,0,0,15,254,255,0,0,0,47,254,255,0,0,0,127,254,255,0,0,0,255,254,255,0,0,2,255,254,255,0,0,7,253,254,255,0,0,15,248,254,255,0,0,47,240,254,255,0,0,63,208,254,255,0,0,255,193,254,255,0,2,255,1,254,255,0,3,253,1,254,255,0,15,252,1,254,255,0,31,240,1,254,255,0,63,224,1,254,255,0,255,192,1,254,255,1,255,0,1,254,254,3,254,0,1,254,254,11,252,0,1,254,254,31,244,0,1,254,254,63,224,0,1,254,254,191,192,0,1,254,255,255,64,0,1,254,255,254,0,0,1,254,255,252,0,0,1,254,255,244,0,0,1,254,255,240,0,0,1,254,255,192,0,0,1,254,
  // 0x041a  К
  21,29,174,25,4,0,170,0,0,0,170,64,255,0,0,3,255,0,255,0,0,11,252,0,255,0,0,47,240,0,255,0,0,127,208,0,255,0,1,255,64,0,255,0,3,254,0,0,255,0,15,252,0,0,255,0,63,240,0,0,255,0,191,192,0,0,255,2,255,0,0,0,255,7,253,0,0,0,255,31,248,0,0,0,255,127,224,0,0,0,255,255,192,0,0,0,255,127,240,0,0,0,255,15,252,0,0,0,255,7,254,0,0,0,255,2,255,128,0,0,255,0,191,208,0,0,255,0,63,240,0,0,255,0,15,252,0,0,255,0,3,255,0,0,255,0,1,255,128,0,255,0,0,127,224,0,255,0,0,47,244,0,255,0,0,15,253,0,255,0,0,3,255,0,255,0,0,0,255,192,
  // 0x041b  Л
  25,30,210,29,0,255,0,0,42,170,170,170,128,0,0,191,255,255,255,192,0,0,191,255,255,255,192,0,0,255,255,255,255,192,0,0,255,64,0,127,192,0,0,255,0,0,127,192,0,0,255,0,0,127,192,0,1,255,0,0,127,192,0,1,254,0,0,127,192,0,2,254,0,0,127,192,0,2,253,0,0,127,192,0,3,252,0,0,127,192,0,3,252,0,0,127,192,0,3,252,0,0,127,192,0,7,252,0,0,127,192,0,7,248,0,0,127,192,0,11,248,0,0,127,192,0,15,244,0,0,127,192,0,15,240,0,0,127,192,0,15,240,0,0,127,192,0,31,240,0,0,127,192,0,47,224,0,0,127,192,0,63,208,0,0,127,192,0,63,192,0,0,127,192,0,191,192,0,0,127,192,66,255,64,0,0,127,192,255,255,0,0,0,127,192,255,253,0,0,0,127,192,255,244,0,0,0,127,192,21,0,0,0,0,0,0,
  // 0x041c  М
  29,29,232,37,4,0,170,160,0,0,0,2,170,128,255,244,0,0,0,11,255,192,255,248,0,0,0,15,255,192,255,252,0,0,0,31,255,192,255,253,0,0,0,47,255,192,254,255,0,0,0,63,191,192,254,255,0,0,0,127,127,192,254,127,64,0,0,255,63,192,254,63,192,0,0,253,63,192,254,47,192,0,2,252,63,192,254,31,224,0,3,248,63,192,254,15,240,0,7,244,127,192,254,11,244,0,11,240,127,192,254,7,248,0,15,224,127,192,254,3,252,0,31,208,127,192,254,2,253,0,63,192,127,192,254,0,254,0,63,128,127,192,254,0,255,0,191,0,127,192,254,0,191,64,255,0,127,192,254,0,63,193,253,0,127,192,254,0,63,194,252,0,127,192,254,0,31,211,248,0,127,192,254,0,15,247,244,0,127,192,254,0,11,255,240,0,127,192,254,0,7,255,224,0,127,192,254,0,3,255,192,0,127,192,254,0,2,255,192,0,127,192,254,0,1,255,128,0,127,192,254,0,0,255,0,0,127,192,
  // 0x041d  Н
  22,29,174,30,4,0,170,0,0,0,10,160,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,234,170,170,191,240,255,255,255,255,255,240,255,255,255,255,255,240,255,255,255,255,255,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,
  // 0x041e  О
  27,30,210,31,2,255,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x041f  П
  22,29,174,29,4,0,170,170,170,170,170,144,255,255,255,255,255,224,255,255,255,255,255,224,255,255,255,255,255,224,255,64,0,0,63,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,255,0,0,0,47,224,
  // 0x0420  Р
  19,29,145,24,4,0,170,170,148,0,0,255,255,255,224,0,255,255,255,254,0,255,255,255,255,128,255,0,7,255,208,255,0,0,127,240,255,0,0,47,240,255,0,0,15,244,255,0,0,15,244,255,0,0,15,244,255,0,0,15,244,255,0,0,31,240,255,0,0,63,240,255,0,1,255,208,255,150,175,255,192,255,255,255,255,0,255,255,255,248,0,255,255,254,64,0,255,64,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,
  // 0x0421  С
  22,30,180,25,2,255,0,0,27,255,228,0,0,2,255,255,255,208,0,31,255,255,255,224,0,127,255,255,255,208,1,255,244,0,27,192,3,255,128,0,0,0,11,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,63,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,127,192,0,0,0,0,127,208,0,0,0,0,63,224,0,0,0,0,63,240,0,0,0,0,47,244,0,0,0,0,15,252,0,0,0,0,11,255,0,0,0,0,3,255,208,0,0,64,1,255,254,85,175,192,0,127,255,255,255,192,0,15,255,255,255,192,0,1,191,255,254,64,0,0,1,85,0,0,
  // 0x0422  Т
  22,29,174,23,0,0,106,170,170,170,170,160,127,255,255,255,255,240,127,255,255,255,255,240,127,255,255,255,255,240,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,
  // 0x0423  У
  24,30,180,25,1,255,170,0,0,0,0,170,255,128,0,0,2,255,191,192,0,0,3,254,63,224,0,0,7,252,47,240,0,0,15,248,15,248,0,0,31,240,11,252,0,0,47,224,3,254,0,0,63,208,1,255,0,0,191,192,0,255,128,0,255,64,0,127,192,1,255,0,0,63,224,3,254,0,0,31,240,7,252,0,0,15,244,11,248,0,0,7,252,15,240,0,0,3,253,47,240,0,0,1,255,63,208,0,0,0,255,191,192,0,0,0,127,255,64,0,0,0,63,255,0,0,0,0,31,254,0,0,0,0,15,252,0,0,0,0,31,248,0,0,0,0,63,240,0,0,0,0,255,208,0,0,58,175,255,192,0,0,63,255,255,0,0,0,63,255,252,0,0,0,63,255,208,0,0,0,1,84,0,0,0,0,
  // 0x0424  Ф
  29,30,240,33,2,255,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,5,255,148,0,0,0,0,11,255,255,255,244,0,0,0,191,255,255,255,255,64,0,3,255,255,255,255,255,224,0,15,255,148,191,69,255,248,0,47,252,0,191,64,15,253,0,63,240,0,191,64,3,255,0,127,192,0,191,64,0,255,64,191,128,0,191,64,0,255,128,255,64,0,191,64,0,191,128,255,64,0,191,64,0,127,192,255,0,0,191,64,0,127,192,255,64,0,191,64,0,191,128,255,128,0,191,64,0,191,128,191,192,0,191,64,0,255,64,63,208,0,191,64,2,255,0,63,244,0,191,64,7,254,0,15,254,0,191,64,47,252,0,7,255,250,255,171,255,240,0,1,255,255,255,255,255,192,0,0,47,255,255,255,253,0,0,0,1,191,255,254,144,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,85,0,0,0,0,
  // 0x0425  Х
  24,29,174,24,0,0,42,144,0,0,2,168,47,240,0,0,11,252,15,252,0,0,31,244,7,253,0,0,63,224,2,255,0,0,191,192,0,255,128,0,255,64,0,127,192,3,254,0,0,47,240,7,252,0,0,15,244,15,244,0,0,7,252,47,224,0,0,3,254,63,192,0,0,0,255,255,64,0,0,0,127,255,0,0,0,0,63,252,0,0,0,0,47,252,0,0,0,0,127,254,0,0,0,0,255,255,0,0,0,2,255,191,192,0,0,3,252,63,208,0,0,15,248,31,240,0,0,31,240,15,252,0,0,63,208,3,253,0,0,191,128,2,255,0,1,255,0,0,255,128,3,253,0,0,127,208,11,252,0,0,63,240,31,244,0,0,15,248,63,224,0,0,11,253,191,192,0,0,3,255,
  // 0x0426  Ц
  26,37,3,30,4,248,170,0,0,0,26,144,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,0,0,0,47,224,0,255,255,255,255,255,250,128,255,255,255,255,255,255,208,255,255,255,255,255,255,208,255,255,255,255,255,255,208,0,0,0,0,0,63,208,0,0,0,0,0,63,208,0,0,0,0,0,63,208,0,0,0,0,0,63,208,0,0,0,0,0,63,208,0,0,0,0,0,63,208,0,0,0,0,0,63,208,0,0,0,0,0,47,192,
  // 0x0427  Ч
  22,29,174,28,3,0,170,0,0,0,26,144,255,0,0,0,63,208,255,0,0,0,63,208,255,0,0,0,63,208,255,0,0,0,63,208,255,0,0,0,63,208,255,0,0,0,63,208,255,0,0,0,63,208,255,0,0,0,63,208,255,0,0,0,63,208,255,0,0,0,63,208,255,0,0,0,63,208,255,64,0,0,63,208,255,128,0,0,63,208,191,208,0,2,255,208,127,254,90,255,255,208,47,255,255,255,255,208,11,255,255,255,191,208,1,191,255,228,63,208,0,0,64,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,
  // 0x0428  Ш
  34,29,5,42,4,0,170,0,0,2,168,0,0,10,160,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,0,0,3,252,0,0,15,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x0429  Щ
  38,37,114,43,4,248,170,0,0,2,168,0,0,26,144,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,0,0,7,252,0,0,47,240,0,255,255,255,255,255,255,255,255,250,144,255,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,255,208,0,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,0,47,208,
  // 0x042a  Ъ
  26,29,203,28,0,0,106,170,168,0,0,0,0,255,255,253,0,0,0,0,255,255,253,0,0,0,0,255,255,253,0,0,0,0,0,3,253,0,0,0,0,0,3,253,0,0,0,0,0,3,253,0,0,0,0,0,3,253,0,0,0,0,0,3,253,0,0,0,0,0,3,253,0,0,0,0,0,3,253,0,0,0,0,0,3,253,0,0,0,0,0,3,255,255,169,0,0,0,3,255,255,255,224,0,0,3,255,255,255,254,0,0,3,255,255,255,255,128,0,3,253,0,6,255,192,0,3,253,0,0,127,224,0,3,253,0,0,47,240,0,3,253,0,0,31,240,0,3,253,0,0,31,240,0,3,253,0,0,31,240,0,3,253,0,0,47,240,0,3,253,0,0,127,224,0,3,253,0,1,255,192,0,3,255,170,191,255,128,0,3,255,255,255,254,0,0,3,255,255,255,244,0,0,3,255,255,254,64,0,
  // 0x042b  Ы
  27,29,203,35,4,0,170,0,0,0,0,2,168,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,255,233,64,0,3,252,255,255,255,244,0,3,252,255,255,255,255,0,3,252,255,255,255,255,192,3,252,255,0,1,255,224,3,252,255,0,0,63,240,3,252,255,0,0,15,244,3,252,255,0,0,15,248,3,252,255,0,0,15,248,3,252,255,0,0,15,248,3,252,255,0,0,15,244,3,252,255,0,0,47,240,3,252,255,0,0,255,224,3,252,255,170,175,255,192,3,252,255,255,255,255,64,3,252,255,255,255,248,0,3,252,255,255,254,64,0,3,252,
  // 0x042c  Ь
  20,29,145,26,4,0,170,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,255,250,64,0,255,255,255,253,0,255,255,255,255,192,255,255,255,255,240,255,0,0,127,248,255,0,0,15,252,255,0,0,3,253,255,0,0,3,254,255,0,0,3,254,255,0,0,3,254,255,0,0,3,253,255,0,0,11,252,255,0,0,127,248,255,170,175,255,240,255,255,255,255,208,255,255,255,254,0,255,255,255,144,0,
  // 0x042d  Э
  22,30,180,26,1,255,1,175,254,144,0,0,111,255,255,254,0,0,127,255,255,255,192,0,63,255,255,255,244,0,46,64,0,127,252,0,0,0,0,11,255,0,0,0,0,2,255,64,0,0,0,0,255,192,0,0,0,0,127,208,0,0,0,0,63,224,0,0,0,0,47,240,0,0,0,0,31,240,0,106,170,170,191,240,0,255,255,255,255,240,0,255,255,255,255,240,0,255,255,255,255,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,47,240,0,0,0,0,63,224,0,0,0,0,63,208,0,0,0,0,191,192,0,0,0,1,255,128,0,0,0,7,255,0,16,0,0,47,253,0,127,149,91,255,248,0,127,255,255,255,224,0,127,255,255,255,64,0,27,255,255,228,0,0,0,21,84,0,0,0,
  // 0x042e  Ю
  36,30,14,42,4,255,170,0,0,0,6,255,249,0,0,255,0,0,0,127,255,255,224,0,255,0,0,2,255,255,255,252,0,255,0,0,15,255,255,255,255,0,255,0,0,47,253,0,7,255,192,255,0,0,127,240,0,0,191,224,255,0,0,255,192,0,0,47,240,255,0,1,255,64,0,0,15,248,255,0,2,255,0,0,0,11,252,255,0,3,254,0,0,0,7,252,255,0,3,253,0,0,0,3,253,255,0,7,252,0,0,0,3,254,255,234,175,252,0,0,0,3,254,255,255,255,252,0,0,0,2,255,255,255,255,252,0,0,0,2,255,255,255,255,252,0,0,0,2,255,255,0,7,252,0,0,0,2,255,255,0,7,252,0,0,0,3,254,255,0,3,253,0,0,0,3,254,255,0,3,254,0,0,0,3,253,255,0,3,255,0,0,0,11,252,255,0,1,255,64,0,0,15,252,255,0,0,255,192,0,0,31,244,255,0,0,191,224,0,0,127,240,255,0,0,63,248,0,1,255,208,255,0,0,15,255,149,111,255,128,255,0,0,7,255,255,255,254,0,255,0,0,0,255,255,255,244,0,255,0,0,0,27,255,255,64,0,0,0,0,0,0,21,64,0,0,
  // 0x042f  Я
  21,29,174,26,1,0,0,0,21,170,170,128,0,7,255,255,255,192,0,127,255,255,255,192,1,255,255,255,255,192,3,255,228,0,127,192,11,254,0,0,63,192,15,252,0,0,63,192,15,248,0,0,63,192,15,244,0,0,63,192,15,244,0,0,63,192,15,248,0,0,63,192,11,252,0,0,63,192,3,255,0,0,63,192,2,255,228,0,127,192,0,191,255,255,255,192,0,31,255,255,255,192,0,2,255,255,255,192,0,3,254,85,191,192,0,11,252,0,63,192,0,31,244,0,63,192,0,63,240,0,63,192,0,191,192,0,63,192,1,255,128,0,63,192,3,255,0,0,63,192,11,253,0,0,63,192,15,248,0,0,63,192,63,240,0,0,63,192,127,208,0,0,63,192,255,192,0,0,63,192,
  // 0x0430  а
  18,23,115,23,2,255,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x0431  б
  20,32,160,24,2,255,0,0,0,0,21,0,0,1,111,254,0,1,191,255,254,0,15,255,255,255,0,127,255,255,148,1,255,249,64,0,3,255,64,0,0,15,252,0,0,0,31,240,0,0,0,47,224,0,0,0,63,192,0,0,0,63,192,127,249,0,127,199,255,255,192,191,159,255,255,240,191,255,213,191,248,255,253,0,15,252,255,240,0,3,254,255,192,0,2,255,255,128,0,1,255,255,128,0,1,255,191,128,0,1,255,191,128,0,1,255,127,192,0,1,255,127,192,0,1,255,63,224,0,2,254,47,240,0,3,253,15,252,0,15,252,7,255,64,127,244,2,255,255,255,224,0,191,255,255,64,0,11,255,248,0,0,0,85,0,0,
  // 0x0432  в
  19,22,110,24,3,0,106,170,169,64,0,191,255,255,253,0,191,255,255,255,192,191,234,175,255,224,191,128,0,63,240,191,128,0,31,240,191,128,0,15,240,191,128,0,31,240,191,128,0,127,208,191,255,255,255,64,191,255,255,244,0,191,255,255,255,64,191,149,86,255,224,191,128,0,31,244,191,128,0,11,248,191,128,0,11,252,191,128,0,11,252,191,128,0,15,248,191,128,5,191,240,191,255,255,255,208,191,255,255,255,64,191,255,255,228,0,
  // 0x0433  г
  14,22,88,18,3,0,106,170,170,160,191,255,255,240,191,255,255,240,191,255,255,240,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,
  // 0x0434  д
  24,30,180,24,0,248,0,0,170,170,170,0,0,0,255,255,255,64,0,1,255,255,255,64,0,1,255,170,255,64,0,2,253,0,255,64,0,2,253,0,255,64,0,3,252,0,255,64,0,3,252,0,255,64,0,3,252,0,255,64,0,7,248,0,255,64,0,15,244,0,255,64,0,15,240,0,255,64,0,31,224,0,255,64,0,63,208,0,255,64,0,63,192,0,255,64,0,191,128,0,255,64,0,255,0,0,255,64,3,254,0,0,255,64,27,253,85,85,255,148,127,255,255,255,255,253,127,255,255,255,255,253,127,255,255,255,255,253,127,128,0,0,1,253,127,128,0,0,1,253,127,128,0,0,1,253,127,128,0,0,1,253,127,128,0,0,1,253,127,128,0,0,1,253,127,128,0,0,1,253,42,64,0,0,1,169,
  // 0x0435  е
  19,23,115,23,2,255,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x0436  ж
  31,22,176,31,0,0,42,144,0,10,144,0,10,160,31,240,0,31,224,0,47,224,11,252,0,31,224,0,191,192,2,254,0,31,224,1,255,0,0,255,128,31,224,3,253,0,0,63,208,31,224,15,244,0,0,15,240,31,224,47,224,0,0,7,252,31,224,191,192,0,0,2,255,31,225,255,0,0,0,0,191,159,227,252,0,0,0,0,63,239,255,244,0,0,0,0,63,239,255,248,0,0,0,0,255,159,227,253,0,0,0,3,254,31,225,255,0,0,0,11,252,31,224,127,192,0,0,31,240,31,224,47,240,0,0,127,208,31,224,15,248,0,0,255,64,31,224,3,254,0,3,254,0,31,224,0,255,64,15,252,0,31,224,0,127,208,47,240,0,31,224,0,47,240,191,192,0,31,224,0,11,252,
  // 0x0437  з
  18,23,115,20,1,255,1,175,254,64,0,63,255,255,248,0,63,255,255,254,0,47,233,91,255,64,8,0,0,191,192,0,0,0,63,192,0,0,0,63,192,0,0,0,127,128,0,0,2,255,0,0,127,255,252,0,0,127,255,208,0,0,127,255,248,0,0,21,107,255,64,0,0,0,191,192,0,0,0,63,208,0,0,0,47,224,0,0,0,47,224,64,0,0,63,208,190,64,6,255,192,191,255,255,255,64,191,255,255,253,0,31,255,255,224,0,0,21,84,0,0,
  // 0x0438  и
  21,22,132,27,3,0,106,0,0,2,170,0,191,64,0,11,255,64,191,64,0,15,255,64,191,64,0,63,255,64,191,64,0,127,255,64,191,64,0,255,191,64,191,64,3,253,191,64,191,64,7,252,191,64,191,64,15,240,191,64,191,64,47,224,191,64,191,64,127,192,191,64,191,64,255,64,191,64,191,66,254,0,191,64,191,71,252,0,191,64,191,79,244,0,191,64,191,47,224,0,191,64,191,127,192,0,191,64,191,255,64,0,191,64,191,255,0,0,191,64,191,252,0,0,191,64,191,244,0,0,191,64,191,240,0,0,191,64,
  // 0x0439  й
  21,31,186,27,3,0,2,164,0,2,164,0,3,248,0,7,248,0,3,252,0,15,244,0,2,255,64,127,240,0,0,255,255,255,192,0,0,47,255,255,0,0,0,1,174,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,0,0,2,170,0,191,64,0,11,255,64,191,64,0,15,255,64,191,64,0,63,255,64,191,64,0,127,255,64,191,64,0,255,191,64,191,64,3,253,191,64,191,64,7,252,191,64,191,64,15,240,191,64,191,64,47,224,191,64,191,64,127,192,191,64,191,64,255,64,191,64,191,66,254,0,191,64,191,71,252,0,191,64,191,79,244,0,191,64,191,47,224,0,191,64,191,127,192,0,191,64,191,255,64,0,191,64,191,255,0,0,191,64,191,252,0,0,191,64,191,244,0,0,191,64,191,240,0,0,191,64,
  // 0x043a  к
  19,22,110,22,3,0,106,64,0,26,144,191,128,0,127,192,191,128,1,255,64,191,128,3,253,0,191,128,15,248,0,191,128,63,224,0,191,128,191,192,0,191,130,255,0,0,191,135,252,0,0,191,159,244,0,0,191,191,208,0,0,191,191,224,0,0,191,143,248,0,0,191,135,253,0,0,191,129,255,64,0,191,128,191,192,0,191,128,47,240,0,191,128,15,252,0,191,128,3,255,0,191,128,0,255,128,191,128,0,127,224,191,128,0,31,244,
  // 0x043b  л
  21,23,138,24,0,255,0,2,170,170,170,64,0,7,255,255,255,128,0,11,255,255,255,128,0,11,255,255,255,128,0,11,240,0,191,128,0,15,240,0,191,128,0,15,240,0,191,128,0,15,240,0,191,128,0,15,240,0,191,128,0,31,224,0,191,128,0,31,224,0,191,128,0,47,208,0,191,128,0,63,192,0,191,128,0,63,192,0,191,128,0,127,192,0,191,128,0,191,128,0,191,128,0,255,64,0,191,128,2,255,0,0,191,128,7,254,0,0,191,128,255,252,0,0,191,128,255,244,0,0,191,128,255,208,0,0,191,128,4,0,0,0,0,0,
  // 0x043c  м
  25,22,154,31,3,0,106,160,0,0,2,170,64,191,248,0,0,7,255,128,191,252,0,0,15,255,128,191,253,0,0,15,255,128,191,254,0,0,47,255,128,191,191,0,0,63,191,128,191,127,64,0,127,127,128,191,63,192,0,255,63,128,191,31,192,0,253,63,128,191,15,224,2,252,63,128,191,11,240,3,248,63,128,191,7,244,7,244,63,128,191,3,252,15,240,63,128,191,2,252,15,208,63,128,191,0,254,47,192,63,128,191,0,255,63,128,63,128,191,0,127,191,64,63,128,191,0,63,255,0,63,128,191,0,47,254,0,63,128,191,0,15,252,0,63,128,191,0,15,248,0,63,128,191,0,7,244,0,63,128,
  // 0x043d  н
  20,22,110,26,3,0,106,64,0,1,168,191,128,0,3,253,191,128,0,3,253,191,128,0,3,253,191,128,0,3,253,191,128,0,3,253,191,128,0,3,253,191,128,0,3,253,191,128,0,3,253,191,255,255,255,253,191,255,255,255,253,191,255,255,255,253,191,234,170,171,253,191,128,0,3,253,191,128,0,3,253,191,128,0,3,253,191,128,0,3,253,191,128,0,3,253,191,128,0,3,253,191,128,0,3,253,191,128,0,3,253,191,128,0,3,253,
  // 0x043e  о
  21,23,138,24,2,255,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x043f  п
  19,22,110,25,3,0,106,170,170,170,168,191,255,255,255,252,191,255,255,255,252,191,255,255,255,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,191,128,0,7,252,
  // 0x0440  р
  20,32,160,25,3,246,105,0,191,228,0,191,11,255,254,0,191,47,255,255,192,191,255,170,255,240,191,248,0,63,244,191,224,0,15,252,191,192,0,7,252,191,192,0,3,253,191,128,0,3,254,191,128,0,2,254,191,128,0,2,254,191,128,0,2,254,191,128,0,2,254,191,128,0,3,254,191,192,0,3,253,191,192,0,7,252,191,224,0,15,252,191,244,0,47,248,191,254,65,191,240,191,191,255,255,208,191,95,255,255,64,191,130,255,248,0,191,128,21,64,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,106,64,0,0,0,
  // 0x0441  с
  16,23,92,20,2,255,0,6,255,228,0,127,255,255,2,255,255,255,11,255,234,253,31,253,0,8,63,240,0,0,127,208,0,0,191,192,0,0,191,128,0,0,255,128,0,0,255,64,0,0,255,64,0,0,255,64,0,0,255,128,0,0,191,192,0,0,127,192,0,0,63,224,0,0,47,244,0,1,15,254,64,111,7,255,255,255,1,255,255,255,0,47,255,248,0,0,85,0,
  // 0x0442  т
  18,22,110,20,1,0,170,170,170,170,160,255,255,255,255,240,255,255,255,255,240,255,255,255,255,240,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,
  // 0x0443  у
  21,32,192,21,0,246,106,64,0,0,106,128,191,192,0,0,255,128,63,208,0,0,255,64,47,224,0,2,255,0,31,240,0,3,254,0,15,244,0,3,252,0,11,252,0,11,252,0,3,252,0,15,244,0,2,254,0,31,240,0,1,255,0,47,224,0,0,255,64,63,208,0,0,191,128,127,192,0,0,63,192,191,128,0,0,47,208,255,0,0,0,31,225,255,0,0,0,15,242,253,0,0,0,11,243,252,0,0,0,3,251,248,0,0,0,2,255,244,0,0,0,1,255,240,0,0,0,0,255,224,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,255,64,0,0,0,1,255,0,0,0,0,3,254,0,0,0,0,7,252,0,0,0,0,47,248,0,0,0,127,255,240,0,0,0,127,255,192,0,0,0,127,254,0,0,0,0,26,144,0,0,0,0,
  // 0x0444  ф
  26,41,31,30,2,246,0,0,1,84,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,107,254,144,0,0,0,31,255,255,254,0,0,0,255,255,255,255,224,0,3,255,251,254,255,252,0,15,254,3,252,15,255,0,47,248,3,252,2,255,64,63,224,3,252,0,191,192,127,192,3,252,0,63,208,191,192,3,252,0,63,224,255,128,3,252,0,47,240,255,64,3,252,0,31,240,255,64,3,252,0,31,240,255,128,3,252,0,31,240,191,128,3,252,0,47,240,191,192,3,252,0,63,224,63,208,3,252,0,127,192,63,240,3,252,0,255,192,15,252,3,252,3,255,0,7,255,147,252,111,253,0,1,255,255,255,255,244,0,0,47,255,255,255,192,0,0,2,255,255,249,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,2,168,0,0,0,
  // 0x0445  х
  20,22,110,22,1,0,106,128,0,2,169,127,208,0,11,252,47,240,0,31,244,15,252,0,63,224,7,253,0,191,192,2,255,1,255,64,0,255,131,254,0,0,63,219,252,0,0,31,255,240,0,0,15,255,224,0,0,3,255,192,0,0,3,255,192,0,0,15,255,224,0,0,47,255,240,0,0,63,219,252,0,0,255,131,254,0,2,255,1,255,64,7,253,0,191,192,15,248,0,63,224,47,240,0,31,244,127,208,0,11,252,255,128,0,3,255,
  // 0x0446  ц
  23,30,180,26,3,248,106,64,0,2,168,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,128,0,3,252,0,191,149,85,87,253,80,191,255,255,255,255,244,191,255,255,255,255,244,191,255,255,255,255,244,0,0,0,0,11,244,0,0,0,0,11,244,0,0,0,0,11,244,0,0,0,0,11,244,0,0,0,0,11,244,0,0,0,0,11,244,0,0,0,0,11,244,0,0,0,0,6,160,
  // 0x0447  ч
  19,22,110,25,3,0,170,0,0,6,164,255,0,0,11,248,255,0,0,11,248,255,0,0,11,248,255,0,0,11,248,255,0,0,11,248,255,0,0,11,248,255,0,0,11,248,255,0,0,11,248,255,0,0,11,248,255,128,0,127,248,191,245,91,255,248,63,255,255,255,248,15,255,255,203,248,1,255,248,11,248,0,0,0,11,248,0,0,0,11,248,0,0,0,11,248,0,0,0,11,248,0,0,0,11,248,0,0,0,11,248,0,0,0,11,248,
  // 0x0448  ш
  31,22,176,37,3,0,106,64,0,26,144,0,6,160,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,128,0,63,208,0,15,244,191,149,85,127,229,85,95,244,191,255,255,255,255,255,255,244,191,255,255,255,255,255,255,244,191,255,255,255,255,255,255,244,
  // 0x0449  щ
  34,30,14,37,3,248,106,64,0,26,144,0,6,160,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,128,0,63,208,0,15,244,0,191,149,85,127,229,85,95,249,64,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,26,144,
  // 0x044a  ъ
  26,22,154,28,0,0,106,170,169,0,0,0,0,127,255,254,0,0,0,0,127,255,254,0,0,0,0,127,255,254,0,0,0,0,0,2,254,0,0,0,0,0,2,254,0,0,0,0,0,2,254,0,0,0,0,0,2,254,0,0,0,0,0,2,254,0,0,0,0,0,2,255,255,254,144,0,0,2,255,255,255,254,0,0,2,255,255,255,255,128,0,2,255,85,90,255,208,0,2,254,0,0,63,240,0,2,254,0,0,31,240,0,2,254,0,0,15,240,0,2,254,0,0,31,240,0,2,254,0,0,63,224,0,2,254,0,6,255,208,0,2,255,255,255,255,128,0,2,255,255,255,253,0,0,2,255,255,255,144,0,
  // 0x044b  ы
  26,22,154,32,3,0,106,64,0,0,0,26,144,191,128,0,0,0,47,224,191,128,0,0,0,47,224,191,128,0,0,0,47,224,191,128,0,0,0,47,224,191,128,0,0,0,47,224,191,128,0,0,0,47,224,191,128,0,0,0,47,224,191,128,0,0,0,47,224,191,255,254,144,0,47,224,191,255,255,254,0,47,224,191,255,255,255,128,47,224,191,149,90,255,208,47,224,191,128,0,63,224,47,224,191,128,0,31,240,47,224,191,128,0,31,240,47,224,191,128,0,31,240,47,224,191,128,0,63,224,47,224,191,128,22,255,192,47,224,191,255,255,255,128,47,224,191,255,255,253,0,47,224,191,255,255,144,0,47,224,
  // 0x044c  ь
  19,22,110,24,3,0,106,64,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,255,255,164,0,191,255,255,255,128,191,255,255,255,224,191,149,86,191,244,191,128,0,15,252,191,128,0,7,252,191,128,0,3,252,191,128,0,7,252,191,128,0,15,248,191,128,1,191,244,191,255,255,255,224,191,255,255,255,64,191,255,255,228,0,
  // 0x044d  э
  17,23,115,20,1,255,6,255,228,0,0,127,255,255,128,0,63,255,255,240,0,63,170,191,252,0,20,0,11,253,0,0,0,2,255,0,0,0,0,255,64,0,0,0,255,128,0,0,0,191,128,2,170,170,255,192,7,255,255,255,192,7,255,255,255,192,2,170,170,255,192,0,0,0,191,128,0,0,0,255,128,0,0,0,255,64,0,0,2,255,0,0,0,7,254,0,249,0,127,252,0,255,255,255,240,0,255,255,255,192,0,111,255,249,0,0,0,85,0,0,0,
  // 0x044e  ю
  29,23,184,34,3,255,106,64,0,1,191,228,0,0,191,128,0,31,255,255,64,0,191,128,0,127,255,255,224,0,191,128,1,255,250,191,248,0,191,128,3,255,0,11,253,0,191,128,7,252,0,3,255,0,191,128,15,248,0,1,255,0,191,128,15,244,0,0,255,64,191,128,31,240,0,0,191,128,191,255,255,240,0,0,191,192,191,255,255,240,0,0,191,192,191,255,255,240,0,0,191,192,191,234,191,240,0,0,191,192,191,128,31,240,0,0,191,128,191,128,15,240,0,0,255,128,191,128,15,244,0,0,255,64,191,128,11,252,0,2,255,0,191,128,3,254,0,3,254,0,191,128,2,255,208,47,252,0,191,128,0,255,255,255,240,0,191,128,0,47,255,255,192,0,191,128,0,7,255,253,0,0,0,0,0,0,21,64,0,0,
  // 0x044f  я
  19,22,110,23,1,0,0,5,170,170,160,1,255,255,255,244,11,255,255,255,244,31,255,170,175,244,63,240,0,15,244,63,192,0,15,244,63,192,0,15,244,63,192,0,15,244,63,192,0,15,244,63,244,0,15,244,31,255,234,175,244,7,255,255,255,244,0,191,255,255,244,0,63,250,175,244,0,127,192,15,244,0,255,64,15,244,3,254,0,15,244,7,252,0,15,244,15,244,0,15,244,63,240,0,15,244,191,192,0,15,244,255,128,0,15,244,
  // 0x0450  ѐ
  255,
  // 0x0451  ё
  19,31,155,23,2,255,0,20,0,80,0,0,253,1,252,0,1,255,3,253,0,1,254,2,253,0,0,184,0,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x0452  ђ
  255,
  // 0x0453  ѓ
  255,
  // 0x0454  є
  17,23,115,20,2,255,0,6,255,228,0,0,127,255,255,128,2,255,255,255,64,11,255,170,191,0,31,248,0,5,0,63,240,0,0,0,127,192,0,0,0,191,192,0,0,0,191,128,0,0,0,255,234,170,160,0,255,255,255,244,0,255,255,255,244,0,255,234,170,160,0,255,128,0,0,0,191,128,0,0,0,127,192,0,0,0,63,224,0,0,0,47,244,0,0,0,15,254,64,27,64,7,255,255,255,64,1,255,255,255,64,0,31,255,254,0,0,0,85,64,0,
  // 0x0455  ѕ
  255,
  // 0x0456  і
  5,30,60,11,3,0,42,0,191,128,255,192,255,128,127,0,0,0,0,0,0,0,106,64,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,
  // 0x0457  ї
  13,30,120,11,255,0,4,0,20,0,63,64,191,0,127,128,255,64,127,128,191,0,46,0,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,
  // 0x0458  ј
  255,
  // 0x0459  љ
  255,
  // 0x045a  њ
  255,
  // 0x045b  ћ
  255,
  // 0x045c  ќ
  255,
  // 0x045d  ѝ
  255,
  // 0x045e  ў
  255,
  // 0x045f  џ
  255,
  // 0x0460  Ѡ
  255,
  // 0x0461  ѡ
  255,
  // 0x0462  Ѣ
  255,
  // 0x0463  ѣ
  255,
  // 0x0464  Ѥ
  255,
  // 0x0465  ѥ
  255,
  // 0x0466  Ѧ
  255,
  // 0x0467  ѧ
  255,
  // 0x0468  Ѩ
  255,
  // 0x0469  ѩ
  255,
  // 0x046a  Ѫ
  255,
  // 0x046b  ѫ
  255,
  // 0x046c  Ѭ
  255,
  // 0x046d  ѭ
  255,
  // 0x046e  Ѯ
  255,
  // 0x046f  ѯ
  255,
  // 0x0470  Ѱ
  255,
  // 0x0471  ѱ
  255,
  // 0x0472  Ѳ
  255,
  // 0x0473  ѳ
  255,
  // 0x0474  Ѵ
  255,
  // 0x0475  ѵ
  255,
  // 0x0476  Ѷ
  255,
  // 0x0477  ѷ
  255,
  // 0x0478  Ѹ
  255,
  // 0x0479  ѹ
  255,
  // 0x047a  Ѻ
  255,
  // 0x047b  ѻ
  255,
  // 0x047c  Ѽ
  255,
  // 0x047d  ѽ
  255,
  // 0x047e  Ѿ
  255,
  // 0x047f  ѿ
  255,
  // 0x0480  Ҁ
  255,
  // 0x0481  ҁ
  255,
  // 0x0482  ҂
  255,
  // 0x0483  ҃
  255,
  // 0x0484  ҄
  255,
  // 0x0485  ҅
  255,
  // 0x0486  ҆
  255,
  // 0x0487  ҇
  255,
  // 0x0488  ҈
  255,
  // 0x0489  ҉
  255,
  // 0x048a  Ҋ
  255,
  // 0x048b  ҋ
  255,
  // 0x048c  Ҍ
  255,
  // 0x048d  ҍ
  255,
  // 0x048e  Ҏ
  255,
  // 0x048f  ҏ
  255,
  // 0x0490  Ґ
  17,35,175,22,4,0,0,0,0,21,64,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,170,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,255,255,255,192,255,64,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,
  // 0x0491  ґ
  15,28,112,18,3,0,0,0,10,160,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,0,0,11,244,106,170,175,244,191,255,255,244,191,255,255,244,191,234,170,160,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,
};

#endif // HAS_GRAPHICAL_TFT
