/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Traditional Chinese 38pt, capital 'A' height: 28px, width: 100%, range: 0x22bf-0xff1a, glyphs: 307
extern const uint8_t NotoSans_Medium_Traditional_Chinese_28[22554] = {
  162,28,191,34,26,255,37,246, // unifont_t
  // 0x22bf  ⊿
  191,34,29,31,248,38,4,255,0,0,0,0,0,0,0,128,0,0,0,0,0,0,2,192,0,0,0,0,0,0,11,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,191,192,0,0,0,0,0,2,255,192,0,0,0,0,0,11,255,192,0,0,0,0,0,47,255,192,0,0,0,0,0,191,223,192,0,0,0,0,2,255,31,192,0,0,0,0,11,252,31,192,0,0,0,0,31,240,31,192,0,0,0,0,127,192,31,192,0,0,0,1,255,0,31,192,0,0,0,7,252,0,31,192,0,0,0,31,240,0,31,192,0,0,0,127,192,0,31,192,0,0,1,255,0,0,31,192,0,0,7,252,0,0,31,192,0,0,31,240,0,0,31,192,0,0,127,192,0,0,31,192,0,1,255,0,0,0,31,192,0,7,252,0,0,0,31,192,0,31,240,0,0,0,31,192,0,127,192,0,0,0,31,192,1,255,0,0,0,0,31,192,7,252,0,0,0,0,31,192,15,255,255,255,255,255,255,192,63,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,
  // 0x4e00  一
  0,78,35,4,36,38,2,12,255,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,255,244,
  // 0x4e09  三
  9,78,34,29,5,38,2,255,3,255,255,255,255,255,255,253,0,3,255,255,255,255,255,255,253,0,3,255,255,255,255,255,255,253,0,2,170,170,170,170,170,170,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,170,170,170,170,170,0,0,0,47,255,255,255,255,255,64,0,0,47,255,255,255,255,255,64,0,0,47,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,170,170,170,170,170,170,170,128,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,
  // 0x4e0a  上
  10,78,34,34,50,38,2,254,0,0,0,5,64,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,250,170,170,168,0,0,0,0,15,255,255,255,253,0,0,0,0,15,255,255,255,253,0,0,0,0,15,255,255,255,253,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,170,170,170,175,250,170,170,170,160,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x4e0b  下
  11,78,34,33,41,38,2,252,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,106,170,170,175,250,170,170,170,144,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,255,128,0,0,0,0,0,0,11,255,248,0,0,0,0,0,0,11,255,255,64,0,0,0,0,0,11,251,255,244,0,0,0,0,0,11,240,191,254,0,0,0,0,0,11,240,31,255,208,0,0,0,0,11,240,2,255,248,0,0,0,0,11,240,0,63,254,0,0,0,0,11,240,0,11,252,0,0,0,0,11,240,0,1,244,0,0,0,0,11,240,0,0,16,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,
  // 0x4e0d  不
  13,78,34,33,41,38,2,252,127,255,255,255,255,255,255,255,192,127,255,255,255,255,255,255,255,192,127,255,255,255,255,255,255,255,192,42,170,170,170,255,234,170,170,128,0,0,0,0,255,192,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,191,252,0,0,0,0,0,0,1,255,252,124,0,0,0,0,0,7,255,254,255,64,0,0,0,0,31,255,252,255,240,0,0,0,0,127,243,252,47,253,0,0,0,2,255,195,252,7,255,64,0,0,11,255,3,252,1,255,224,0,0,63,252,3,252,0,63,252,0,2,255,240,3,252,0,11,255,0,31,255,128,3,252,0,2,255,192,191,253,0,3,252,0,0,191,240,191,240,0,3,252,0,0,31,224,63,128,0,3,252,0,0,7,128,8,0,0,3,252,0,0,1,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,
  // 0x4e26  並
  38,78,34,34,50,38,2,254,0,0,144,0,0,0,100,0,0,0,11,240,0,0,0,255,64,0,0,7,248,0,0,1,255,0,0,0,2,253,0,0,2,253,0,0,0,0,255,0,0,7,252,0,0,0,0,191,64,0,15,240,0,0,0,0,63,128,0,31,224,0,0,21,85,126,85,85,127,229,85,64,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,3,248,3,248,0,0,0,0,0,3,248,3,248,0,0,0,0,0,3,248,3,248,0,0,0,0,96,3,248,3,248,0,228,0,3,244,3,248,3,248,1,253,0,3,248,3,248,3,248,2,252,0,1,252,3,248,3,248,3,252,0,0,253,3,248,3,248,7,244,0,0,191,3,248,3,248,11,240,0,0,127,3,248,3,248,15,240,0,0,63,67,248,3,248,15,208,0,0,63,131,248,3,248,47,192,0,0,47,195,248,3,248,63,128,0,0,31,195,248,3,248,127,64,0,0,15,211,248,3,248,191,0,0,0,15,131,248,3,248,109,0,0,0,0,3,248,3,248,0,0,0,0,0,3,248,3,248,0,0,0,0,0,3,248,3,248,0,0,0,170,170,171,254,171,254,170,170,160,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x4e2d  中
  45,78,32,36,32,38,3,252,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,149,85,95,245,85,86,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,149,85,95,245,85,86,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,0,168,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,
  // 0x4e3b  主
  59,78,34,35,59,38,2,253,0,0,0,9,0,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,191,224,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,0,63,208,0,0,0,5,85,85,85,111,149,85,85,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,255,255,255,255,255,255,244,0,0,255,255,255,255,255,255,244,0,0,255,255,255,255,255,255,244,0,0,85,85,87,253,85,85,80,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,85,85,85,85,85,85,80,
  // 0x4e4b  之
  75,78,35,36,68,38,1,252,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,1,85,85,85,255,85,85,89,0,3,255,255,255,255,255,255,255,128,3,255,255,255,255,255,255,255,192,3,255,255,255,255,255,255,255,128,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,11,253,0,0,0,0,0,0,0,31,244,0,0,0,0,0,0,0,127,224,0,0,0,1,0,0,1,255,128,0,0,0,3,224,0,7,254,0,0,0,0,11,244,0,47,248,0,0,0,0,15,240,0,191,224,0,0,0,0,31,224,2,255,128,0,0,0,0,63,240,15,253,0,0,0,0,0,127,252,127,244,0,0,0,0,0,255,255,255,192,0,0,0,0,2,254,255,254,0,0,0,0,0,3,252,63,252,0,0,0,0,0,11,248,15,255,144,0,0,0,0,31,240,3,255,255,250,165,85,88,63,208,0,127,255,255,255,255,252,191,192,0,6,255,255,255,255,248,31,64,0,0,6,191,255,255,244,1,0,0,0,0,0,0,0,0,
  // 0x4ea4  交
  164,78,34,37,77,38,2,251,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,85,85,85,85,85,85,85,85,80,0,0,20,0,0,2,128,0,0,0,0,63,128,0,15,240,0,0,0,0,255,192,0,47,253,0,0,0,3,255,0,0,7,255,128,0,0,15,252,0,0,0,255,240,0,0,127,240,0,0,0,47,252,0,2,255,192,0,0,0,11,255,0,31,255,6,64,0,30,65,255,192,191,248,63,192,0,47,224,127,224,63,224,47,208,0,63,192,31,128,15,0,15,240,0,191,128,9,0,0,0,11,244,0,255,0,0,0,0,0,3,252,3,254,0,0,0,0,0,2,255,11,252,0,0,0,0,0,0,255,175,240,0,0,0,0,0,0,63,255,208,0,0,0,0,0,0,31,255,128,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,127,255,208,0,0,0,0,0,2,255,255,248,0,0,0,0,0,47,255,95,255,128,0,0,0,7,255,252,3,255,249,0,0,1,191,255,208,0,191,255,228,0,191,255,253,0,0,11,255,255,240,255,255,208,0,0,0,191,255,240,63,248,0,0,0,0,6,255,192,46,0,0,0,0,0,0,6,64,0,0,0,0,0,0,0,0,0,
  // 0x4eae  亮
  174,78,34,37,77,38,2,251,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,85,85,85,85,85,64,0,0,47,255,255,255,255,255,128,0,0,47,255,255,255,255,255,128,0,0,47,192,0,0,0,63,128,0,0,47,192,0,0,0,63,128,0,0,47,192,0,0,0,63,128,0,0,47,255,255,255,255,255,128,0,0,47,255,255,255,255,255,128,0,0,5,85,85,85,85,85,64,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,0,0,0,0,0,0,15,208,127,0,0,0,0,0,0,15,208,127,0,15,224,3,252,0,15,208,127,0,15,224,3,252,0,15,208,127,0,31,208,3,252,0,15,208,0,0,47,192,3,252,0,0,0,0,0,63,192,3,252,0,0,0,0,0,127,128,3,252,0,0,0,0,0,255,64,3,252,0,7,128,0,3,254,0,3,252,0,7,240,0,47,252,0,3,252,0,11,240,6,255,240,0,2,253,0,15,224,255,255,128,0,2,255,255,255,208,191,249,0,0,0,255,255,255,192,62,64,0,0,0,47,255,254,0,0,0,0,0,0,0,0,0,0,
  // 0x4ee4  令
  228,78,36,36,68,38,1,252,0,0,0,1,254,0,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,11,255,208,0,0,0,0,0,0,47,255,240,0,0,0,0,0,0,127,219,252,0,0,0,0,0,1,255,131,255,0,0,0,0,0,7,254,0,255,192,0,0,0,0,31,252,0,63,244,0,0,0,0,127,240,0,15,253,0,0,0,2,255,192,0,3,255,128,0,0,11,255,0,0,0,255,240,0,0,63,253,0,0,0,127,253,0,1,255,223,255,255,255,247,255,208,15,255,79,255,255,255,240,255,248,127,252,15,255,255,255,240,47,253,63,208,0,0,0,0,0,7,248,15,0,0,0,0,0,0,0,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,0,0,47,208,0,2,252,0,0,0,0,31,192,0,2,252,0,0,0,0,31,192,0,2,252,0,0,0,0,31,192,0,2,252,0,0,0,0,31,192,0,2,252,0,0,0,0,31,192,0,2,252,0,0,0,0,31,192,0,2,252,0,0,0,0,31,192,0,2,252,0,0,0,0,31,192,15,255,252,0,0,0,0,31,192,11,255,248,0,0,0,0,31,192,7,255,224,0,0,0,0,31,192,1,84,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,
  // 0x4ef6  件
  246,78,35,36,68,38,1,252,0,0,32,0,0,5,64,0,0,0,0,191,0,0,31,192,0,0,0,0,254,2,144,31,192,0,0,0,1,253,3,244,31,192,0,0,0,3,252,7,240,31,192,0,0,0,7,248,11,240,31,192,0,0,0,15,240,15,224,31,192,0,0,0,31,224,15,208,31,192,0,0,0,63,192,31,255,255,255,255,224,0,127,128,47,255,255,255,255,224,0,255,64,63,255,255,255,255,224,3,255,64,127,149,111,229,85,64,7,255,64,255,0,31,192,0,0,31,255,65,253,0,31,192,0,0,63,255,67,252,0,31,192,0,0,191,255,66,244,0,31,192,0,0,63,63,64,32,0,31,192,0,0,44,63,64,0,0,31,192,0,0,4,63,64,0,0,31,192,0,0,0,63,67,255,255,255,255,255,252,0,63,67,255,255,255,255,255,252,0,63,67,255,255,255,255,255,252,0,63,65,85,85,111,229,85,84,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,47,64,0,0,31,192,0,0,
  // 0x4efd  份
  253,78,36,36,68,38,1,252,0,0,100,0,0,0,0,0,0,0,0,255,0,15,255,255,128,0,0,1,253,0,15,255,255,192,0,0,2,252,0,15,255,255,208,0,0,3,248,1,64,0,15,224,0,0,11,240,3,248,0,15,240,0,0,15,224,3,244,0,7,240,0,0,47,192,11,240,0,3,248,0,0,63,128,15,224,0,3,252,0,0,255,64,47,192,0,1,254,0,1,255,64,63,128,0,0,255,0,3,255,64,191,0,0,0,127,192,15,255,64,254,0,0,0,63,224,47,255,67,252,0,0,0,31,248,127,255,75,244,0,0,0,11,254,255,191,95,240,0,0,0,7,253,190,63,111,239,255,255,255,253,248,60,63,71,95,255,255,255,252,32,32,63,64,31,255,255,255,252,0,0,63,64,0,11,224,1,252,0,0,63,64,0,15,224,1,252,0,0,63,64,0,15,208,1,252,0,0,63,64,0,15,208,1,252,0,0,63,64,0,31,192,2,252,0,0,63,64,0,47,192,2,252,0,0,63,64,0,63,64,2,252,0,0,63,64,0,127,0,2,252,0,0,63,64,0,255,0,3,252,0,0,63,64,1,253,0,3,248,0,0,63,64,3,252,0,3,248,0,0,63,64,15,244,0,3,248,0,0,63,64,63,224,0,11,244,0,0,63,66,255,128,15,255,240,0,0,63,67,254,0,11,255,240,0,0,63,64,244,0,7,255,192,0,0,42,0,64,0,1,84,0,0,
  // 0x4f11  休
  17,79,36,36,68,38,1,252,0,0,4,0,0,0,0,0,0,0,0,47,128,0,63,128,0,0,0,0,63,192,0,63,128,0,0,0,0,191,64,0,63,128,0,0,0,0,255,0,0,63,128,0,0,0,1,254,0,0,63,128,0,0,0,3,252,0,0,63,128,0,0,0,11,248,0,0,63,128,0,0,0,15,240,0,0,63,128,0,0,0,63,224,0,0,63,128,0,0,0,191,211,255,255,255,255,255,252,1,255,211,255,255,255,255,255,252,3,255,211,255,255,255,255,255,252,15,255,209,85,87,255,253,85,84,63,255,208,0,3,255,252,0,0,255,239,208,0,7,255,253,0,0,191,143,208,0,15,255,255,0,0,63,15,208,0,31,255,255,0,0,44,15,208,0,63,255,175,192,0,0,15,208,0,127,127,159,208,0,0,15,208,0,255,63,143,240,0,0,15,208,2,253,63,135,248,0,0,15,208,7,252,63,130,252,0,0,15,208,15,240,63,128,255,0,0,15,208,47,224,63,128,191,128,0,15,208,191,192,63,128,63,208,0,15,209,255,0,63,128,31,244,0,15,219,253,0,63,128,11,253,0,15,239,248,0,63,128,3,255,0,15,219,240,0,63,128,0,252,0,15,210,192,0,63,128,0,48,0,15,208,0,0,63,128,0,0,0,15,208,0,0,63,128,0,0,0,15,208,0,0,63,128,0,0,0,15,208,0,0,63,128,0,0,0,15,192,0,0,63,128,0,0,
  // 0x4f4d  位
  77,79,36,36,68,38,1,252,0,0,36,0,0,21,64,0,0,0,0,127,64,0,63,128,0,0,0,0,191,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,2,252,0,0,63,128,0,0,0,3,252,0,0,63,128,0,0,0,11,244,0,0,63,128,0,0,0,31,224,85,85,127,213,85,80,0,63,192,255,255,255,255,255,248,0,191,192,255,255,255,255,255,248,1,255,192,255,255,255,255,255,248,3,255,192,0,0,0,0,0,0,11,255,192,0,0,0,0,0,0,47,255,192,1,96,0,0,249,0,191,255,192,3,240,0,1,254,0,255,175,192,3,244,0,1,253,0,127,47,192,2,248,0,2,252,0,60,47,192,1,252,0,3,252,0,16,47,192,1,252,0,3,248,0,0,47,192,0,253,0,7,244,0,0,47,192,0,254,0,11,240,0,0,47,192,0,190,0,15,240,0,0,47,192,0,191,0,15,224,0,0,47,192,0,127,0,15,208,0,0,47,192,0,127,0,47,192,0,0,47,192,0,63,64,63,192,0,0,47,192,0,63,128,63,64,0,0,47,192,0,63,128,127,0,0,0,47,192,0,63,128,191,0,0,0,47,192,0,16,0,254,0,0,0,47,193,85,85,85,253,85,84,0,47,195,255,255,255,255,255,254,0,47,195,255,255,255,255,255,254,0,47,195,255,255,255,255,255,254,0,47,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,
  // 0x4f4e  低
  78,79,36,36,68,38,1,252,0,0,80,0,0,0,0,0,0,0,0,254,0,0,0,0,4,0,0,0,254,0,0,0,6,255,0,0,2,252,0,0,22,255,255,192,0,3,252,53,111,255,255,255,128,0,7,244,63,255,255,255,144,0,0,15,240,63,255,255,248,0,0,0,47,208,63,229,3,248,0,0,0,63,192,63,64,3,248,0,0,0,191,64,63,64,3,252,0,0,1,255,64,63,64,2,252,0,0,3,255,64,63,64,2,252,0,0,11,255,64,63,64,2,252,0,0,31,255,64,63,64,2,252,0,0,127,255,64,63,255,255,255,255,253,255,255,64,63,255,255,255,255,253,255,63,64,63,255,255,255,255,253,60,63,64,63,64,0,253,0,0,36,63,64,63,64,0,254,0,0,0,63,64,63,64,0,254,0,0,0,63,64,63,64,0,191,0,0,0,63,64,63,64,0,191,0,0,0,63,64,63,64,0,127,0,0,0,63,64,63,64,0,63,64,0,0,63,64,63,64,5,63,128,0,0,63,64,63,155,255,111,192,0,0,63,65,191,255,255,95,208,32,0,63,71,255,255,255,79,224,46,0,63,67,255,250,64,11,240,63,0,63,67,229,0,0,7,248,63,0,63,64,0,0,0,3,253,127,0,63,64,0,0,0,1,255,254,0,63,65,255,255,255,252,191,252,0,63,65,255,255,255,252,47,248,0,63,65,255,255,255,252,6,144,0,63,64,0,0,0,0,0,0,
  // 0x4f5c  作
  92,79,36,36,68,38,1,252,0,0,20,0,0,0,0,0,0,0,0,63,64,11,224,0,0,0,0,0,191,64,15,240,0,0,0,0,0,255,0,31,208,0,0,0,0,1,253,0,47,192,0,0,0,0,3,252,0,63,128,0,0,0,0,7,248,0,191,149,85,85,84,0,15,240,0,255,255,255,255,253,0,31,224,2,255,255,255,255,253,0,63,192,3,255,255,255,255,253,0,255,192,15,240,127,64,0,0,1,255,192,31,224,127,64,0,0,3,255,192,63,192,127,64,0,0,15,255,192,255,64,127,64,0,0,63,255,194,255,0,127,64,0,0,127,255,195,252,0,127,255,255,248,63,111,192,244,0,127,255,255,248,30,47,192,16,0,127,255,255,248,8,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,85,85,84,0,47,192,0,0,127,255,255,252,0,47,192,0,0,127,255,255,252,0,47,192,0,0,127,255,255,252,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,31,192,0,0,127,0,0,0,
  // 0x4f9b  供
  155,79,36,36,68,38,1,252,0,0,36,0,105,0,6,160,0,0,0,191,0,191,0,11,240,0,0,0,254,0,191,0,11,240,0,0,1,253,0,191,0,11,240,0,0,3,252,0,191,0,11,240,0,0,7,244,0,191,0,11,240,0,0,15,240,0,191,0,11,240,0,0,47,208,0,191,0,11,240,0,0,63,192,255,255,255,255,255,252,0,191,64,255,255,255,255,255,252,1,255,64,255,255,255,255,255,252,3,255,64,85,191,85,91,245,84,15,255,64,0,191,0,11,240,0,47,255,64,0,191,0,11,240,0,127,255,64,0,191,0,11,240,0,255,191,64,0,191,0,11,240,0,127,63,64,0,191,0,11,240,0,60,63,64,0,191,0,11,240,0,20,63,64,0,191,0,11,240,0,0,63,64,0,191,0,11,240,0,0,63,65,85,255,85,95,245,84,0,63,67,255,255,255,255,255,253,0,63,67,255,255,255,255,255,253,0,63,67,255,255,255,255,255,253,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,61,0,1,192,0,0,63,64,0,191,64,15,240,0,0,63,64,1,254,0,7,252,0,0,63,64,7,252,0,2,254,0,0,63,64,15,244,0,0,191,128,0,63,64,63,208,0,0,63,208,0,63,65,255,128,0,0,15,240,0,63,67,254,0,0,0,7,252,0,63,65,248,0,0,0,2,244,0,63,64,32,0,0,0,0,128,
  // 0x4fdd  保
  221,79,36,36,68,38,1,252,0,0,36,0,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,191,31,255,255,255,255,192,0,0,254,31,255,255,255,255,192,0,2,252,31,255,255,255,255,192,0,3,248,31,192,0,0,31,192,0,15,240,31,192,0,0,31,192,0,31,224,31,192,0,0,31,192,0,63,192,31,192,0,0,31,192,0,191,192,31,192,0,0,31,192,1,255,192,31,192,0,0,31,192,3,255,192,31,255,255,255,255,192,15,255,192,31,255,255,255,255,192,63,255,192,31,255,255,255,255,192,191,239,192,0,0,47,192,0,0,191,111,192,0,0,47,192,0,0,62,47,192,0,0,47,192,0,0,44,47,192,0,0,47,192,0,0,0,47,192,0,0,47,192,0,0,0,47,195,255,255,255,255,255,252,0,47,195,255,255,255,255,255,252,0,47,195,255,255,255,255,255,252,0,47,192,0,3,255,252,0,0,0,47,192,0,11,255,255,0,0,0,47,192,0,31,255,255,128,0,0,47,192,0,63,239,223,208,0,0,47,192,0,255,47,207,244,0,0,47,192,3,253,47,195,253,0,0,47,192,31,248,47,193,255,64,0,47,192,127,224,47,192,127,208,0,47,195,255,128,47,192,47,248,0,47,207,254,0,47,192,11,255,0,47,199,248,0,47,192,2,253,0,47,193,208,0,47,192,0,116,0,47,192,0,0,47,192,0,0,0,31,128,0,0,47,192,0,0,
  // 0x4fe1  信
  225,79,36,36,68,38,1,252,0,0,36,0,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,191,7,255,255,255,255,0,0,0,254,7,255,255,255,255,0,0,2,252,3,255,255,255,255,0,0,3,248,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,31,227,255,255,255,255,255,253,0,63,195,255,255,255,255,255,253,0,191,195,255,255,255,255,255,253,0,255,192,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,11,255,192,0,0,0,0,0,0,47,255,192,15,255,255,255,255,128,127,255,192,15,255,255,255,255,128,255,175,192,11,255,255,255,255,128,191,47,192,0,0,0,0,0,0,60,47,192,0,0,0,0,0,0,16,47,192,11,255,255,255,255,64,0,47,192,15,255,255,255,255,128,0,47,192,15,255,255,255,255,128,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,15,255,255,255,255,192,0,47,192,31,255,255,255,255,192,0,47,192,31,255,255,255,255,192,0,47,192,31,192,0,0,31,192,0,47,192,31,192,0,0,31,192,0,47,192,31,192,0,0,31,192,0,47,192,31,192,0,0,31,192,0,47,192,31,192,0,0,31,192,0,47,192,31,255,255,255,255,192,0,47,192,31,255,255,255,255,192,0,47,192,31,255,255,255,255,192,0,47,192,31,192,0,0,31,192,0,26,128,15,192,0,0,26,128,
  // 0x500b  個
  11,80,34,36,68,38,1,252,0,1,144,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,3,244,255,255,255,255,255,240,0,7,240,255,255,255,255,255,240,0,15,240,255,255,255,255,255,240,0,31,208,253,0,0,0,3,240,0,63,192,252,0,10,64,3,240,0,63,128,252,0,31,64,3,240,0,191,0,252,0,31,64,3,240,0,255,0,252,0,31,64,3,240,3,255,0,252,0,31,64,3,240,7,255,0,252,127,255,255,243,240,15,255,0,252,127,255,255,243,240,47,255,0,252,106,175,234,147,240,127,255,0,252,0,31,64,3,240,255,191,0,252,0,31,64,3,240,190,127,0,252,0,31,64,3,240,124,127,0,252,10,175,234,67,240,48,127,0,252,15,255,255,131,240,0,127,0,252,15,255,255,131,240,0,127,0,252,15,64,15,131,240,0,127,0,252,15,64,15,131,240,0,127,0,252,15,64,15,131,240,0,127,0,252,15,64,15,131,240,0,127,0,252,15,64,15,131,240,0,127,0,252,15,255,255,131,240,0,127,0,252,15,255,255,131,240,0,127,0,252,10,170,170,67,240,0,127,0,252,0,0,0,3,240,0,127,0,252,0,0,0,3,240,0,127,0,255,255,255,255,255,240,0,127,0,255,255,255,255,255,240,0,127,0,255,255,255,255,255,240,0,127,0,253,0,0,0,3,240,0,127,0,252,0,0,0,3,240,0,127,0,168,0,0,0,1,80,
  // 0x503c  值
  60,80,36,36,68,38,1,252,0,0,96,0,0,30,128,0,0,0,0,254,0,0,47,192,0,0,0,0,253,0,0,63,192,0,0,0,2,252,0,0,63,128,0,0,0,3,249,255,255,255,255,255,244,0,7,241,255,255,255,255,255,244,0,15,241,255,255,255,255,255,244,0,31,208,0,0,127,0,0,0,0,63,192,0,0,190,0,0,0,0,191,64,0,0,253,0,0,0,0,255,0,26,170,254,170,170,0,3,255,0,31,255,255,255,255,0,11,255,0,31,255,255,255,255,0,31,255,0,31,128,0,0,63,0,63,255,0,31,128,0,0,63,0,191,255,0,31,128,0,0,63,0,63,127,0,31,255,255,255,255,0,45,63,0,31,255,255,255,255,0,8,63,0,31,234,170,170,191,0,0,63,0,31,128,0,0,63,0,0,63,0,31,128,0,0,63,0,0,63,0,31,255,255,255,255,0,0,63,0,31,255,255,255,255,0,0,63,0,31,213,85,85,191,0,0,63,0,31,128,0,0,63,0,0,63,0,31,128,0,0,63,0,0,63,0,31,213,85,85,191,0,0,63,0,31,255,255,255,255,0,0,63,0,31,255,255,255,255,0,0,63,0,31,128,0,0,63,0,0,63,0,31,128,0,0,63,0,0,63,0,31,128,0,0,63,0,0,63,15,255,255,255,255,255,253,0,63,15,255,255,255,255,255,253,0,63,15,255,255,255,255,255,253,0,63,0,0,0,0,0,0,0,
  // 0x504f  偏
  79,80,36,36,68,38,1,252,0,1,128,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,246,255,255,255,255,255,253,0,11,243,255,255,255,255,255,253,0,15,227,255,255,255,255,255,253,0,31,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,64,42,170,170,170,170,160,0,191,0,127,255,255,255,255,240,0,255,0,127,255,255,255,255,240,3,255,0,127,0,0,0,11,240,7,255,0,127,0,0,0,11,240,15,255,0,127,0,0,0,11,240,47,255,0,127,0,0,0,11,240,127,255,0,127,255,255,255,255,240,255,255,0,127,255,255,255,255,240,255,127,0,127,170,170,170,170,160,124,127,0,127,0,0,0,0,0,52,127,0,127,0,0,0,0,0,0,127,0,191,255,255,255,255,248,0,127,0,191,255,255,255,255,248,0,127,0,255,255,255,255,255,248,0,127,0,255,240,124,15,66,248,0,127,0,255,240,124,15,66,248,0,127,1,255,240,124,15,66,248,0,127,2,255,240,124,15,66,248,0,127,3,251,255,255,255,255,248,0,127,3,247,255,255,255,255,248,0,127,7,243,250,255,191,235,248,0,127,15,227,240,124,15,66,248,0,127,31,211,240,124,15,66,248,0,127,63,195,240,124,15,66,248,0,127,127,67,240,124,15,66,248,0,127,30,3,240,124,15,127,244,0,127,0,3,240,124,15,95,240,0,127,0,3,240,124,15,79,208,
  // 0x505c  停
  92,80,36,36,68,38,1,252,0,0,80,0,0,42,128,0,0,0,0,255,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,2,252,0,0,63,192,0,0,0,3,251,255,255,255,255,255,252,0,11,243,255,255,255,255,255,252,0,15,243,255,255,255,255,255,252,0,47,192,0,0,0,0,0,0,0,63,128,5,85,85,85,85,0,0,255,64,15,255,255,255,255,64,2,255,64,15,255,255,255,255,64,7,255,64,15,192,0,0,63,64,15,255,64,15,192,0,0,63,64,63,255,64,15,192,0,0,63,64,191,255,64,15,255,255,255,255,64,255,127,64,15,255,255,255,255,64,125,63,64,5,85,85,85,85,0,56,63,64,0,0,0,0,0,0,16,63,71,255,255,255,255,255,254,0,63,75,255,255,255,255,255,254,0,63,75,255,255,255,255,255,254,0,63,75,224,0,0,0,0,190,0,63,75,224,0,0,0,0,190,0,63,75,226,255,255,255,252,190,0,63,75,227,255,255,255,252,190,0,63,75,227,255,255,255,252,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,255,255,128,0,0,0,63,64,0,191,255,64,0,0,0,63,0,0,127,249,0,0,0,
  // 0x5075  偵
  117,80,35,37,77,38,1,251,0,0,36,0,0,63,128,0,0,0,0,127,64,0,63,128,0,0,0,0,255,0,0,63,128,0,0,0,0,254,0,0,63,255,255,248,0,2,252,0,0,63,255,255,248,0,7,248,0,0,63,255,255,248,0,15,240,0,0,63,128,0,0,0,31,224,0,0,63,128,0,0,0,63,192,0,0,63,128,0,0,0,191,192,42,170,191,234,170,128,1,255,192,47,255,255,255,255,192,3,255,192,47,255,255,255,255,192,15,255,192,47,128,0,0,47,192,63,255,192,47,128,0,0,47,192,191,239,192,47,234,170,170,191,192,255,111,192,47,255,255,255,255,192,126,47,192,47,255,255,255,255,192,56,47,192,47,128,0,0,47,192,0,47,192,47,128,0,0,47,192,0,47,192,47,128,0,0,47,192,0,47,192,47,255,255,255,255,192,0,47,192,47,255,255,255,255,192,0,47,192,47,234,170,170,191,192,0,47,192,47,128,0,0,47,192,0,47,192,47,128,0,0,47,192,0,47,192,47,234,170,170,191,192,0,47,192,47,255,255,255,255,192,0,47,192,47,255,255,255,255,192,0,47,192,0,0,0,0,0,0,0,47,192,0,62,64,7,208,0,0,47,192,1,255,192,47,252,0,0,47,192,11,255,0,11,255,64,0,47,192,191,248,0,0,255,224,0,47,199,255,208,0,0,47,252,0,47,194,255,0,0,0,7,248,0,31,128,116,0,0,0,1,192,0,0,0,0,0,0,0,0,0,
  // 0x5099  備
  153,80,36,37,77,38,1,251,0,1,64,0,21,0,5,80,0,0,3,248,0,127,0,11,224,0,0,3,248,0,127,0,11,224,0,0,7,240,0,127,0,11,240,0,0,15,243,255,255,255,255,255,253,0,15,211,255,255,255,255,255,253,0,47,195,255,255,255,255,255,253,0,63,128,0,127,0,11,224,0,0,191,0,0,127,0,11,224,0,0,255,0,0,127,0,11,224,0,2,255,0,0,0,0,0,0,0,3,255,2,255,255,255,255,255,253,11,255,2,255,255,255,255,255,253,31,255,2,255,255,255,255,255,253,63,255,2,248,0,0,0,0,0,255,255,2,248,0,0,0,0,0,255,127,2,248,106,170,170,170,164,124,127,2,248,127,255,255,255,248,52,127,2,248,127,255,255,255,248,16,127,2,248,125,0,252,1,248,0,127,2,248,125,0,252,1,248,0,127,2,248,125,0,252,1,248,0,127,2,248,127,255,255,255,248,0,127,3,244,127,255,255,255,248,0,127,3,244,126,85,253,86,248,0,127,3,240,125,0,252,1,248,0,127,3,240,125,0,252,1,248,0,127,7,240,127,255,255,255,248,0,127,11,240,127,255,255,255,248,0,127,15,224,126,85,253,86,248,0,127,15,208,125,0,252,1,248,0,127,31,192,125,0,252,1,248,0,127,63,128,125,0,252,1,248,0,127,127,0,125,0,252,171,244,0,127,46,0,125,0,252,127,240,0,127,9,0,105,0,164,63,144,0,0,0,0,0,0,0,0,0,
  // 0x50b3  傳
  179,80,36,36,68,38,1,252,0,0,80,0,0,26,64,0,0,0,0,255,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,2,255,255,255,255,255,255,252,0,3,254,255,255,255,255,255,252,0,11,245,170,170,191,234,170,168,0,15,240,0,0,47,192,0,0,0,47,208,0,0,47,192,0,0,0,63,192,63,255,255,255,255,224,0,191,64,63,255,255,255,255,224,1,255,64,63,0,47,192,11,224,3,255,64,63,0,47,192,11,224,15,255,64,63,255,255,255,255,224,47,255,64,63,255,255,255,255,224,191,255,64,63,0,47,192,11,224,255,191,64,63,0,47,192,11,224,190,63,64,63,255,255,255,255,224,60,63,64,63,255,255,255,255,224,32,63,64,0,0,47,192,255,0,0,63,64,0,0,47,192,63,192,0,63,67,255,255,255,255,255,240,0,63,67,255,255,255,255,255,252,0,63,66,254,170,165,87,249,253,0,63,64,0,0,0,3,244,32,0,63,64,0,0,0,3,244,0,0,63,75,255,255,255,255,255,253,0,63,75,255,255,255,255,255,253,0,63,75,255,255,255,255,255,253,0,63,64,7,240,0,3,244,0,0,63,64,11,252,0,3,244,0,0,63,64,2,255,0,3,244,0,0,63,64,0,191,128,3,244,0,0,63,64,0,47,192,3,244,0,0,63,64,0,14,15,255,244,0,0,63,64,0,0,15,255,240,0,0,63,0,0,0,7,255,128,0,
  // 0x50be  傾
  190,80,36,37,77,38,1,251,0,1,0,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,15,224,0,63,255,255,255,253,0,15,208,0,63,255,255,255,253,0,31,202,128,63,255,255,255,253,0,63,143,208,0,0,127,0,0,0,63,15,208,0,0,191,0,0,0,191,15,208,0,0,254,0,0,0,254,15,208,3,255,255,255,240,2,253,15,208,3,255,255,255,240,3,253,15,208,227,250,170,171,240,11,253,15,211,251,240,0,3,240,15,253,15,223,247,240,0,3,240,47,253,15,255,195,240,0,3,240,127,253,15,255,3,255,255,255,240,255,253,15,252,3,255,255,255,240,253,189,15,240,3,250,170,171,240,124,189,15,208,3,240,0,3,240,48,189,15,208,3,240,0,3,240,0,189,15,208,3,250,170,171,240,0,189,15,208,3,255,255,255,240,0,189,15,208,3,255,255,255,240,0,189,15,208,183,240,0,3,240,0,189,15,208,191,240,0,3,240,0,189,15,208,255,240,0,3,240,0,189,15,208,255,250,170,171,240,0,189,15,208,255,255,255,255,240,0,189,11,255,251,255,255,255,240,0,189,7,255,240,0,0,0,0,0,189,2,255,208,28,0,24,0,0,189,0,0,0,191,128,191,0,0,189,0,0,3,255,64,191,208,0,189,0,0,47,252,0,31,244,0,189,0,2,255,224,0,7,253,0,189,0,1,255,64,0,0,253,0,189,0,0,116,0,0,0,48,0,0,0,0,0,0,0,0,0,
  // 0x5132  儲
  50,81,36,36,68,38,1,252,0,1,0,0,0,0,252,0,0,0,7,224,0,0,0,252,0,228,0,11,231,255,252,0,252,0,252,0,15,215,255,252,0,252,2,248,0,31,195,255,252,0,252,3,240,0,63,128,0,0,63,255,247,240,0,63,0,0,0,63,255,255,208,0,191,47,255,255,111,255,255,192,0,254,47,255,255,64,252,47,128,2,253,47,255,255,64,252,63,0,3,253,0,0,0,0,252,190,0,15,253,0,0,0,0,253,252,0,31,253,7,255,253,191,255,255,253,63,253,7,255,253,191,255,255,253,255,253,6,170,169,191,255,255,253,255,189,0,0,0,0,127,142,0,124,189,0,0,0,0,254,47,192,52,189,6,170,169,3,252,11,224,16,189,7,255,253,31,240,2,192,0,189,7,255,253,191,255,255,240,0,189,0,0,3,255,255,255,240,0,189,0,0,1,255,255,255,240,0,189,11,255,254,99,240,3,240,0,189,15,255,255,3,240,3,240,0,189,15,255,255,3,240,3,240,0,189,15,192,63,3,250,171,240,0,189,15,192,63,3,255,255,240,0,189,15,192,63,3,255,255,240,0,189,15,192,63,3,240,3,240,0,189,15,192,63,3,240,3,240,0,189,15,192,63,3,240,3,240,0,189,15,255,255,3,255,255,240,0,189,15,255,255,3,255,255,240,0,189,15,255,255,3,255,255,240,0,189,15,192,0,3,240,3,240,0,189,10,128,0,1,160,1,80,
  // 0x5145  充
  69,81,35,36,68,38,2,252,0,0,0,2,164,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,21,85,85,87,253,85,85,85,64,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,0,0,7,248,0,1,0,0,0,0,0,15,240,0,31,128,0,0,0,0,15,224,0,63,224,0,0,0,0,47,192,0,15,252,0,0,0,0,63,128,0,3,255,0,0,0,0,191,0,0,0,255,192,0,0,0,255,170,191,255,255,240,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,255,0,15,255,255,255,234,149,80,255,128,14,149,0,0,0,0,0,63,128,0,0,10,160,0,254,0,28,0,0,0,15,240,0,254,0,0,0,0,0,15,224,0,254,0,0,0,0,0,15,224,0,254,0,0,0,0,0,31,208,0,254,0,0,0,0,0,47,192,0,254,0,0,0,0,0,63,192,0,254,0,0,0,0,0,127,128,0,254,0,3,144,0,0,255,64,0,254,0,3,244,0,2,255,0,0,254,0,3,244,0,11,252,0,0,254,0,3,244,0,127,244,0,0,254,0,3,240,7,255,224,0,0,255,0,11,240,191,255,64,0,0,255,255,255,224,191,248,0,0,0,127,255,255,208,63,128,0,0,0,47,255,255,128,20,0,0,0,0,0,85,80,0,
  // 0x5148  先
  72,81,34,37,77,38,2,251,0,0,0,2,248,0,0,0,0,0,3,160,3,252,0,0,0,0,0,7,244,3,252,0,0,0,0,0,11,240,3,252,0,0,0,0,0,15,240,3,252,0,0,0,0,0,31,208,3,252,0,0,0,0,0,47,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,127,255,255,255,255,255,252,0,0,255,85,87,253,85,85,84,0,1,253,0,3,252,0,0,0,0,3,252,0,3,252,0,0,0,0,11,244,0,3,252,0,0,0,0,11,240,0,3,252,0,0,0,0,1,208,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,21,85,85,87,253,85,85,85,80,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,15,208,0,254,0,0,0,0,0,31,208,0,254,0,0,0,0,0,47,192,0,254,0,0,0,0,0,63,192,0,254,0,0,0,0,0,63,128,0,254,0,0,0,0,0,127,128,0,254,0,0,0,0,0,255,0,0,254,0,1,0,0,1,255,0,0,254,0,3,208,0,3,253,0,0,254,0,3,240,0,15,252,0,0,254,0,7,240,0,63,240,0,0,254,0,7,240,2,255,208,0,0,254,0,15,224,47,255,64,0,0,255,255,255,208,191,252,0,0,0,191,255,255,192,63,224,0,0,0,47,255,255,64,30,0,0,0,0,1,85,80,0,0,0,0,0,0,0,0,0,0,
  // 0x5149  光
  73,81,36,37,77,38,1,251,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,30,0,0,254,0,0,189,0,0,191,0,0,254,0,0,255,0,0,63,128,0,254,0,1,254,0,0,47,208,0,254,0,3,252,0,0,15,240,0,254,0,7,248,0,0,11,244,0,254,0,15,240,0,0,3,248,0,254,0,31,224,0,0,3,252,0,254,0,63,192,0,0,1,253,0,254,0,127,64,0,0,0,253,0,254,0,127,0,0,0,0,80,0,254,0,4,0,0,0,0,0,0,254,0,0,0,0,21,85,85,85,255,85,85,85,84,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,3,248,0,63,64,0,0,0,0,7,244,0,63,64,0,0,0,0,7,244,0,63,64,0,0,0,0,11,240,0,63,64,0,0,0,0,11,240,0,63,64,0,0,0,0,15,240,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,47,208,0,63,64,0,0,0,0,63,192,0,63,64,0,64,0,0,191,128,0,63,64,0,248,0,1,255,0,0,63,64,0,253,0,7,254,0,0,63,64,0,253,0,31,252,0,0,63,64,0,252,0,255,240,0,0,63,128,1,252,31,255,192,0,0,63,213,87,252,127,254,0,0,0,63,255,255,248,47,244,0,0,0,31,255,255,240,14,64,0,0,0,7,255,255,128,0,0,0,0,0,0,0,0,0,
  // 0x5165  入
  101,81,35,34,50,38,2,252,0,2,170,170,168,0,0,0,0,0,3,255,255,253,0,0,0,0,0,3,255,255,253,0,0,0,0,0,3,255,255,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,5,255,0,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,31,255,128,0,0,0,0,0,0,47,255,192,0,0,0,0,0,0,63,255,192,0,0,0,0,0,0,127,223,208,0,0,0,0,0,0,191,79,240,0,0,0,0,0,0,255,11,244,0,0,0,0,0,2,254,7,248,0,0,0,0,0,3,253,3,252,0,0,0,0,0,7,252,2,254,0,0,0,0,0,15,244,0,255,64,0,0,0,0,47,240,0,191,192,0,0,0,0,127,192,0,63,224,0,0,0,0,255,128,0,31,244,0,0,0,3,255,0,0,15,253,0,0,0,11,253,0,0,3,255,0,0,0,47,248,0,0,1,255,192,0,0,191,224,0,0,0,127,244,0,3,255,192,0,0,0,47,254,0,31,255,0,0,0,0,11,255,192,255,252,0,0,0,0,1,255,244,255,224,0,0,0,0,0,127,224,47,64,0,0,0,0,0,15,192,8,0,0,0,0,0,0,1,0,
  // 0x5168  全
  104,81,36,35,59,38,1,253,0,0,0,1,255,0,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,15,255,224,0,0,0,0,0,0,47,255,244,0,0,0,0,0,0,191,199,253,0,0,0,0,0,2,255,66,255,64,0,0,0,0,7,254,0,191,208,0,0,0,0,31,248,0,47,244,0,0,0,0,191,224,0,11,254,0,0,0,2,255,128,0,2,255,192,0,0,15,254,0,0,0,191,244,0,0,127,244,0,0,0,31,254,0,2,255,208,0,0,0,3,255,208,31,255,0,0,0,0,0,255,253,127,251,255,255,255,255,255,239,252,47,211,255,255,255,255,255,195,244,14,3,255,255,255,255,255,192,176,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,
  // 0x5171  共
  113,81,34,36,68,38,2,252,0,0,106,0,0,10,144,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,21,85,191,85,85,95,245,85,64,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,85,85,85,85,85,85,80,0,0,0,0,0,0,0,0,0,0,0,4,0,0,5,0,0,0,0,0,63,144,0,63,128,0,0,0,0,191,208,0,191,240,0,0,0,3,255,64,0,31,253,0,0,0,15,253,0,0,3,255,128,0,0,127,244,0,0,0,255,240,0,2,255,208,0,0,0,47,252,0,31,255,0,0,0,0,7,255,0,127,248,0,0,0,0,1,255,192,31,208,0,0,0,0,0,127,64,6,0,0,0,0,0,0,24,0,
  // 0x5177  具
  119,81,34,34,50,38,2,252,0,31,255,255,255,255,255,128,0,0,31,255,255,255,255,255,128,0,0,31,250,170,170,170,191,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,234,170,170,170,191,128,0,0,31,255,255,255,255,255,128,0,0,31,255,255,255,255,255,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,234,170,170,170,191,128,0,0,31,255,255,255,255,255,128,0,0,31,255,255,255,255,255,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,255,255,255,255,255,128,0,0,31,255,255,255,255,255,128,0,0,31,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,21,85,85,85,85,85,85,85,64,0,0,11,0,0,9,0,0,0,0,0,127,208,0,63,224,0,0,0,11,255,240,0,255,255,64,0,0,191,255,64,0,31,255,244,0,47,255,244,0,0,1,191,255,128,191,255,64,0,0,0,11,255,240,47,228,0,0,0,0,0,191,128,9,0,0,0,0,0,0,9,0,
  // 0x5197  冗
  151,81,35,34,50,38,2,252,21,85,85,85,85,85,85,85,64,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,128,0,0,0,0,0,47,192,63,128,0,0,0,0,0,47,192,63,128,0,0,0,0,0,47,192,63,128,0,0,0,0,0,47,192,63,128,0,0,0,0,0,47,192,63,128,0,0,0,0,0,47,192,63,128,21,85,85,85,64,47,192,0,0,127,255,255,255,208,0,0,0,0,127,255,255,255,208,0,0,0,0,127,255,255,255,208,0,0,0,0,127,64,0,31,208,0,0,0,0,127,64,0,31,208,0,0,0,0,127,64,0,31,208,0,0,0,0,127,64,0,31,208,0,0,0,0,127,64,0,31,208,0,0,0,0,191,0,0,31,208,0,0,0,0,191,0,0,31,208,0,0,0,0,191,0,0,31,208,0,0,0,0,255,0,0,31,208,0,0,0,0,254,0,0,31,208,1,0,0,2,253,0,0,31,208,3,208,0,3,252,0,0,31,208,3,244,0,15,248,0,0,31,208,3,244,0,63,240,0,0,31,208,3,244,1,255,208,0,0,31,208,3,240,11,255,64,0,0,31,224,11,240,191,253,0,0,0,31,255,255,240,255,244,0,0,0,15,255,255,208,63,128,0,0,0,7,255,255,128,40,0,0,0,0,0,85,84,0,
  // 0x51b7  冷
  183,81,36,36,68,38,1,252,0,0,0,0,0,169,0,0,0,0,0,0,0,3,255,64,0,0,2,0,0,0,7,255,192,0,0,15,192,0,0,15,255,224,0,0,47,244,0,0,63,223,248,0,0,31,254,0,0,191,131,254,0,0,3,255,128,1,255,1,255,64,0,0,191,224,7,253,0,127,208,0,0,47,208,31,244,0,47,248,0,0,11,64,127,224,0,11,254,0,0,1,1,255,128,0,2,255,192,0,0,11,255,85,85,85,191,248,0,0,63,250,255,255,255,95,254,0,0,255,226,255,255,255,67,252,0,0,191,66,255,255,255,64,180,0,0,60,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,0,0,3,129,255,255,255,255,255,128,0,7,241,255,255,255,255,255,128,0,15,241,255,255,255,255,255,128,0,47,224,0,15,224,0,63,128,0,63,192,0,15,224,0,63,128,0,191,64,0,15,224,0,63,128,1,255,0,0,15,224,0,63,128,3,253,0,0,15,224,0,63,128,11,252,0,0,15,224,0,63,128,15,244,0,0,15,224,0,63,128,63,224,0,0,15,224,127,255,128,127,192,0,0,15,224,63,255,64,31,64,0,0,15,224,47,254,0,2,0,0,0,15,224,5,64,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,11,224,0,0,0,
  // 0x51c6  准
  198,81,36,36,68,38,1,252,0,0,0,0,36,0,5,0,0,0,0,0,0,191,0,15,224,0,0,0,0,0,255,0,31,208,0,3,192,0,1,253,0,47,192,0,15,244,0,2,252,0,63,128,0,15,254,0,3,248,0,127,0,0,2,255,192,11,240,0,191,0,0,0,127,240,15,240,0,254,0,0,0,31,240,47,255,255,255,255,248,0,3,208,127,255,255,255,255,248,0,0,64,255,255,255,255,255,248,0,0,2,255,192,2,248,0,0,0,0,11,255,192,2,248,0,0,0,0,31,255,192,2,248,0,0,0,0,127,239,192,2,248,0,0,0,0,63,143,255,255,255,255,224,0,0,15,15,255,255,255,255,224,0,0,0,15,255,255,255,255,224,0,0,0,15,208,3,248,0,0,0,1,0,15,192,2,248,0,0,0,3,128,15,192,2,248,0,0,0,15,224,15,192,2,248,0,0,0,31,240,15,192,2,248,0,0,0,63,192,15,255,255,255,255,224,0,191,128,15,255,255,255,255,224,0,255,0,15,255,255,255,255,224,3,253,0,15,208,3,248,0,0,7,252,0,15,192,2,248,0,0,15,240,0,15,192,2,248,0,0,63,224,0,15,192,2,248,0,0,127,192,0,15,213,87,253,85,84,31,64,0,15,255,255,255,255,253,6,0,0,15,255,255,255,255,253,0,0,0,15,255,255,255,255,253,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,
  // 0x51fa  出
  250,81,30,36,32,38,4,252,0,0,0,42,64,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,255,255,255,255,255,255,64,31,255,255,255,255,255,255,64,31,255,255,255,255,255,255,64,5,85,85,127,213,85,85,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,255,255,255,255,255,255,240,191,255,255,255,255,255,255,240,191,255,255,255,255,255,255,240,191,85,85,85,85,85,95,240,191,0,0,0,0,0,11,240,190,0,0,0,0,0,11,224,
  // 0x5206  分
  6,82,36,35,59,38,1,252,0,0,3,224,0,7,192,0,0,0,0,11,248,0,31,224,0,0,0,0,15,240,0,15,244,0,0,0,0,47,224,0,7,252,0,0,0,0,63,192,0,3,254,0,0,0,0,255,128,0,0,255,64,0,0,2,255,0,0,0,191,192,0,0,3,253,0,0,0,63,240,0,0,15,252,0,0,0,15,248,0,0,63,240,0,0,0,7,254,0,0,255,208,0,0,0,3,255,128,2,255,128,0,0,0,0,255,224,15,254,0,0,0,0,0,63,248,63,254,85,85,85,85,85,111,254,191,235,255,255,255,255,255,247,252,47,139,255,255,255,255,255,241,240,10,11,255,255,255,255,255,240,80,0,0,0,47,192,0,15,224,0,0,0,0,63,192,0,15,224,0,0,0,0,63,192,0,15,224,0,0,0,0,127,128,0,15,224,0,0,0,0,127,64,0,15,224,0,0,0,0,255,0,0,15,208,0,0,0,0,255,0,0,31,208,0,0,0,3,253,0,0,31,208,0,0,0,7,252,0,0,31,192,0,0,0,15,244,0,0,47,192,0,0,0,63,240,0,0,47,192,0,0,0,255,192,0,0,63,192,0,0,11,255,64,0,0,63,128,0,0,127,253,0,0,0,191,64,0,11,255,244,0,31,255,255,0,0,7,255,128,0,15,255,254,0,0,2,253,0,0,11,255,248,0,0,0,128,0,0,1,85,64,0,0,
  // 0x5217  列
  23,82,34,37,77,38,1,251,0,0,0,0,0,0,0,1,64,0,0,0,0,0,0,0,11,240,47,255,255,255,255,0,0,11,240,47,255,255,255,255,0,0,11,240,47,255,255,255,255,47,128,11,240,5,86,253,85,85,47,128,11,240,0,3,252,0,0,47,128,11,240,0,3,248,0,0,47,128,11,240,0,7,244,0,0,47,128,11,240,0,11,240,0,0,47,128,11,240,0,15,240,0,64,47,128,11,240,0,31,255,255,252,47,128,11,240,0,63,255,255,252,47,128,11,240,0,63,255,255,248,47,128,11,240,0,191,0,3,244,47,128,11,240,0,254,0,7,240,47,128,11,240,3,252,0,11,240,47,128,11,240,7,252,0,15,224,47,128,11,240,15,255,64,15,208,47,128,11,240,63,255,240,31,192,47,128,11,240,191,159,253,63,192,47,128,11,240,127,3,255,255,64,47,128,11,240,28,0,191,255,0,47,128,11,240,0,0,31,254,0,47,128,11,240,0,0,3,252,0,47,128,11,240,0,0,7,248,0,47,128,11,240,0,0,15,240,0,0,0,11,240,0,0,47,208,0,0,0,11,240,0,0,191,192,0,0,0,11,240,0,2,255,0,0,0,0,11,240,0,11,253,0,0,0,0,11,240,0,47,244,0,0,0,0,11,240,1,255,224,0,0,0,149,111,224,7,255,64,0,0,0,191,255,224,2,253,0,0,0,0,127,255,192,0,160,0,0,0,0,63,249,0,0,0,0,0,0,0,0,0,0,
  // 0x521d  初
  29,82,35,36,68,38,1,252,0,11,224,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,1,85,85,85,85,80,0,11,240,3,255,255,255,255,248,0,11,240,3,255,255,255,255,248,0,11,240,3,255,255,255,255,248,63,255,255,240,0,127,64,3,248,63,255,255,248,0,127,64,3,248,63,255,255,244,0,127,0,3,248,0,0,15,240,0,127,0,3,248,0,0,15,208,0,127,0,3,248,0,0,63,192,0,191,0,3,248,0,0,127,64,0,191,0,3,244,0,0,255,0,0,191,0,3,244,0,2,253,29,0,191,0,3,244,0,7,248,63,0,254,0,3,244,0,15,244,254,0,254,0,7,244,0,63,254,248,0,253,0,7,244,0,255,255,224,1,253,0,7,244,3,255,255,208,2,252,0,7,240,15,255,251,240,2,252,0,7,240,127,255,243,252,3,248,0,7,240,191,203,240,253,7,244,0,11,240,63,11,240,120,11,240,0,11,240,44,11,240,16,15,240,0,11,240,0,11,240,0,47,208,0,15,240,0,11,240,0,63,192,0,15,240,0,11,240,0,191,64,0,15,224,0,11,240,1,255,0,0,15,224,0,11,240,7,253,0,0,31,208,0,11,240,31,248,0,0,63,192,0,11,240,127,240,3,255,255,192,0,11,240,191,192,2,255,255,64,0,11,240,47,0,1,255,254,0,0,11,224,8,0,0,106,80,0,
  // 0x5230  到
  48,82,34,35,59,38,1,252,0,0,0,0,0,0,0,6,160,0,0,0,0,0,0,0,11,240,63,255,255,255,255,0,0,11,240,63,255,255,255,255,0,0,11,240,63,255,255,255,255,31,192,11,240,0,11,244,0,0,31,192,11,240,0,15,240,1,0,31,192,11,240,0,15,208,47,0,31,192,11,240,0,47,192,47,192,31,192,11,240,0,63,128,15,240,31,192,11,240,0,127,0,3,248,31,192,11,240,21,255,175,255,253,31,192,11,240,63,255,255,255,255,31,192,11,240,63,255,255,255,255,95,192,11,240,63,250,165,64,47,223,192,11,240,0,0,42,0,14,31,192,11,240,0,0,63,64,0,31,192,11,240,0,0,63,64,0,31,192,11,240,0,0,63,64,0,31,192,11,240,0,0,63,64,0,31,192,11,240,15,255,255,255,252,31,192,11,240,15,255,255,255,252,31,192,11,240,15,255,255,255,252,31,192,11,240,0,0,127,64,0,31,192,11,240,0,0,63,64,0,31,192,11,240,0,0,63,64,0,5,64,11,240,0,0,63,64,0,0,0,11,240,0,0,63,64,0,0,0,11,240,0,0,63,70,191,64,0,11,240,0,5,191,255,255,64,0,11,240,111,255,255,255,255,64,0,11,240,127,255,255,255,233,0,106,175,240,63,255,250,80,0,0,127,255,224,62,148,0,0,0,0,63,255,192,0,0,0,0,0,0,63,250,0,
  // 0x5236  制
  54,82,34,36,68,38,1,252,0,0,10,128,0,0,0,1,80,0,228,31,192,0,0,0,3,240,1,252,31,192,0,0,0,3,240,2,252,31,192,0,0,0,3,240,3,248,31,192,0,0,253,3,240,3,248,31,192,0,0,253,3,240,7,255,255,255,255,64,253,3,240,11,255,255,255,255,64,253,3,240,15,255,255,255,255,64,253,3,240,47,192,31,192,0,0,253,3,240,63,128,31,192,0,0,253,3,240,127,0,31,192,0,0,253,3,240,11,0,31,208,0,0,253,3,240,63,255,255,255,255,240,253,3,240,63,255,255,255,255,240,253,3,240,63,255,255,255,255,240,253,3,240,0,0,31,192,0,0,253,3,240,0,0,31,192,0,0,253,3,240,0,0,31,192,0,0,253,3,240,11,255,255,255,255,128,253,3,240,11,255,255,255,255,128,253,3,240,11,255,255,255,255,128,253,3,240,11,224,31,192,47,128,253,3,240,11,224,31,192,47,128,253,3,240,11,224,31,192,47,128,253,3,240,11,224,31,192,47,128,0,3,240,11,224,31,192,47,128,0,3,240,11,224,31,192,47,128,0,3,240,11,224,31,192,47,128,0,3,240,11,224,31,192,47,128,0,3,240,11,224,31,203,255,128,0,3,240,11,224,31,199,255,64,0,7,240,11,224,31,195,249,0,47,255,240,0,0,31,192,0,0,15,255,240,0,0,31,192,0,0,15,255,192,0,0,31,192,0,0,6,148,0,
  // 0x5237  刷
  55,82,34,36,68,38,1,252,0,0,0,0,0,0,0,1,80,0,0,0,0,0,0,0,7,240,3,255,255,255,255,192,0,7,240,3,255,255,255,255,192,0,7,240,3,255,255,255,255,195,244,7,240,3,240,0,0,47,195,244,7,240,3,240,0,0,47,195,244,7,240,3,240,0,0,47,195,244,7,240,3,240,0,0,47,195,244,7,240,3,240,0,0,47,195,244,7,240,3,255,255,255,255,195,244,7,240,3,255,255,255,255,195,244,7,240,3,255,255,255,255,195,244,7,240,3,240,0,252,0,3,244,7,240,3,240,0,252,0,3,244,7,240,3,240,0,252,0,3,244,7,240,3,240,0,252,0,3,244,7,240,3,251,255,255,255,195,244,7,240,3,251,255,255,255,195,244,7,240,3,251,255,255,255,195,244,7,240,3,251,192,252,15,195,244,7,240,7,251,192,252,15,195,244,7,240,7,235,192,252,15,195,244,7,240,7,235,192,252,15,195,244,7,240,11,235,192,252,15,195,244,7,240,11,219,192,252,15,194,244,7,240,15,219,192,252,15,192,0,7,240,15,203,192,252,15,192,0,7,240,31,203,192,253,255,192,0,7,240,47,139,192,252,255,128,0,7,240,63,75,192,252,254,0,0,7,240,127,1,64,252,0,0,0,7,240,190,0,0,252,0,0,63,255,240,61,0,0,252,0,0,31,255,224,8,0,0,252,0,0,15,255,192,0,0,0,168,0,0,10,148,0,
  // 0x5275  創
  117,82,34,37,77,38,1,251,0,0,5,64,0,0,0,0,0,0,0,47,244,0,0,0,11,240,0,0,127,254,0,0,0,11,240,0,0,255,255,128,0,0,11,240,0,3,253,63,240,0,0,11,240,0,15,248,15,252,15,208,11,240,0,63,224,3,255,15,208,11,240,0,255,213,86,255,207,208,11,240,7,255,255,255,255,143,208,11,240,47,249,255,255,143,15,208,11,240,127,224,0,0,0,15,208,11,240,47,64,0,0,0,15,208,11,240,8,255,255,255,253,15,208,11,240,0,255,255,255,253,15,208,11,240,0,254,170,170,253,15,208,11,240,0,252,0,0,253,15,208,11,240,0,255,255,255,253,15,208,11,240,0,255,255,255,253,15,208,11,240,0,253,0,0,253,15,208,11,240,0,252,0,0,253,15,208,11,240,0,254,170,170,253,15,208,11,240,0,255,255,255,253,15,208,11,240,0,255,255,255,253,15,208,11,240,0,252,0,0,0,15,208,11,240,1,252,0,0,0,15,208,11,240,2,254,170,170,170,15,208,11,240,3,255,255,255,255,0,0,11,240,3,255,255,255,255,0,0,11,240,7,255,192,0,63,0,0,11,240,15,239,192,0,63,0,0,11,240,31,207,192,0,63,0,0,11,240,63,207,192,0,63,0,0,11,240,127,79,255,255,255,0,105,111,240,62,15,255,255,255,0,127,255,224,12,15,234,170,191,0,63,255,192,0,15,192,0,42,0,63,254,0,0,0,0,0,0,0,0,0,0,
  // 0x529b  力
  155,82,33,37,77,38,2,251,0,0,0,47,128,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,26,170,170,191,234,170,170,170,64,63,255,255,255,255,255,255,255,64,63,255,255,255,255,255,255,255,64,63,255,255,255,255,255,255,255,64,0,0,0,63,128,0,0,127,0,0,0,0,63,128,0,0,127,0,0,0,0,127,64,0,0,191,0,0,0,0,191,64,0,0,191,0,0,0,0,191,0,0,0,191,0,0,0,0,255,0,0,0,191,0,0,0,0,254,0,0,0,255,0,0,0,2,253,0,0,0,255,0,0,0,3,252,0,0,0,254,0,0,0,7,252,0,0,0,254,0,0,0,15,244,0,0,0,254,0,0,0,31,240,0,0,0,253,0,0,0,63,224,0,0,1,253,0,0,0,191,192,0,0,1,253,0,0,1,255,64,0,0,2,252,0,0,3,255,0,0,0,3,252,0,0,15,252,0,0,0,3,252,0,0,63,244,0,0,0,3,248,0,1,255,224,0,0,0,11,244,0,11,255,128,0,0,0,31,240,0,63,253,0,0,7,255,255,240,0,191,244,0,0,3,255,255,192,0,47,192,0,0,2,255,255,64,0,10,0,0,0,0,90,80,0,0,0,0,0,0,0,0,0,0,0,
  // 0x52a0  加
  160,82,34,36,68,38,1,252,0,1,64,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,21,85,85,80,0,15,224,0,0,127,255,255,224,0,15,224,0,0,127,255,255,224,21,95,245,85,80,127,255,255,224,63,255,255,255,240,127,0,15,224,63,255,255,255,240,127,0,15,224,63,255,255,255,240,127,0,15,224,0,15,208,11,240,127,0,15,224,0,15,208,11,224,127,0,15,224,0,15,208,11,224,127,0,15,224,0,15,192,11,224,127,0,15,224,0,31,192,11,224,127,0,15,224,0,31,192,15,224,127,0,15,224,0,31,192,15,224,127,0,15,224,0,47,192,15,224,127,0,15,224,0,47,192,15,224,127,0,15,224,0,63,128,15,224,127,0,15,224,0,63,64,15,208,127,0,15,224,0,63,64,15,208,127,0,15,224,0,127,0,15,208,127,0,15,224,0,191,0,15,208,127,0,15,224,0,255,0,15,208,127,0,15,224,1,253,0,15,208,127,0,15,224,2,252,0,31,192,127,0,15,224,3,252,0,31,192,127,0,15,224,7,244,0,47,192,127,255,255,224,15,240,0,63,192,127,255,255,224,47,224,85,191,128,127,255,255,224,127,192,191,255,64,127,85,95,224,127,128,127,255,0,127,0,15,224,31,0,63,248,0,127,0,15,224,4,0,0,0,0,0,0,0,0,
  // 0x52d5  動
  213,82,35,37,77,38,1,251,0,0,0,0,64,0,84,0,0,0,0,22,191,240,2,252,0,0,43,255,255,255,244,2,252,0,0,47,255,255,255,164,2,252,0,0,31,250,255,0,0,2,252,0,0,0,0,127,0,0,2,252,0,0,0,0,127,0,0,2,252,0,0,127,255,255,255,253,2,252,0,0,127,255,255,255,253,2,252,0,0,42,170,255,85,87,255,255,255,248,0,0,127,0,2,255,255,255,248,5,85,191,255,250,255,255,255,248,31,255,255,255,252,2,249,87,248,31,255,255,255,252,3,248,3,248,31,128,127,0,252,3,244,3,244,31,128,127,0,252,3,244,3,244,31,255,255,255,252,3,244,3,244,31,255,255,255,252,3,240,3,244,31,128,191,1,252,7,240,3,244,31,128,127,0,252,7,240,3,244,31,149,191,85,252,11,240,3,244,31,255,255,255,252,11,224,3,244,31,255,255,255,252,15,208,3,240,0,0,127,0,0,31,192,3,240,0,0,127,0,0,47,192,7,240,10,170,255,170,168,63,128,7,240,31,255,255,255,252,63,64,7,240,31,255,255,255,252,255,0,7,240,0,0,127,0,1,254,0,11,240,0,0,127,0,3,252,0,11,240,0,21,191,107,255,244,0,15,224,127,255,255,255,255,240,0,15,208,63,255,255,234,255,192,16,47,208,63,165,64,0,255,64,127,255,192,0,0,0,0,61,0,63,255,64,0,0,0,0,20,0,63,253,0,0,0,0,0,0,0,0,0,0,
  // 0x5316  化
  22,83,36,35,59,38,1,252,0,0,15,144,47,192,0,0,0,0,0,31,224,47,192,0,0,0,0,0,63,192,47,192,0,0,0,0,0,127,128,47,192,0,0,0,0,0,255,64,47,192,0,0,0,0,1,255,0,47,192,0,0,0,0,3,252,0,47,192,0,0,0,0,11,248,0,47,192,0,11,64,0,31,240,0,47,192,0,63,192,0,63,240,0,47,192,1,255,224,0,255,240,0,47,192,11,255,128,2,255,240,0,47,192,127,253,0,11,255,240,0,47,194,255,240,0,47,255,240,0,47,223,255,64,0,191,251,240,0,47,255,248,0,0,255,203,240,0,47,255,128,0,0,127,75,240,0,47,253,0,0,0,61,11,240,0,47,208,0,0,0,20,11,240,0,47,192,0,0,0,0,11,240,0,47,192,0,0,0,0,11,240,0,47,192,0,0,0,0,11,240,0,47,192,0,0,0,0,11,240,0,47,192,0,0,0,0,11,240,0,47,192,0,0,0,0,11,240,0,47,192,0,0,80,0,11,240,0,47,192,0,0,189,0,11,240,0,47,192,0,0,254,0,11,240,0,47,192,0,0,254,0,11,240,0,47,192,0,0,253,0,11,240,0,47,192,0,1,252,0,11,240,0,47,208,0,3,252,0,11,240,0,31,255,255,255,248,0,11,240,0,15,255,255,255,240,0,11,240,0,2,255,255,255,208,0,11,224,0,0,5,85,84,0,
  // 0x534a  半
  74,83,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,24,0,3,248,0,3,144,0,1,253,0,3,248,0,11,248,0,0,255,0,3,248,0,15,240,0,0,127,128,3,248,0,47,224,0,0,63,192,3,248,0,63,192,0,0,31,224,3,248,0,127,128,0,0,15,240,3,248,0,255,0,0,0,7,248,3,248,2,253,0,0,0,3,248,3,248,3,252,0,0,0,2,128,3,248,0,112,0,0,0,0,0,3,248,0,0,0,0,5,85,85,87,253,85,85,85,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,106,170,170,171,254,170,170,170,144,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,
  // 0x5354  協
  84,83,35,36,68,38,1,252,0,63,64,0,0,31,128,0,0,0,63,64,0,0,47,128,0,0,0,63,64,0,0,47,128,0,0,0,63,64,0,0,63,64,0,0,0,63,64,15,255,255,255,255,208,0,63,64,15,255,255,255,255,208,0,63,64,15,255,255,255,255,208,0,63,64,0,0,253,0,15,208,0,63,64,0,2,252,0,15,192,0,63,64,0,3,248,0,15,192,127,255,255,128,15,240,0,31,192,127,255,255,128,127,192,0,47,192,127,255,255,130,255,64,0,63,128,0,63,128,111,252,0,191,255,64,0,63,64,63,224,0,63,254,0,0,63,64,14,0,0,63,244,0,0,63,64,10,128,0,6,144,0,0,63,64,15,192,0,11,224,0,0,63,64,15,192,0,11,224,0,0,63,64,15,192,0,11,224,0,0,63,70,175,234,162,175,250,168,0,63,71,255,255,243,255,255,252,0,63,71,255,255,243,255,255,252,0,63,64,15,131,240,15,192,252,0,63,64,31,131,240,15,192,252,0,63,64,47,67,240,15,192,252,0,63,64,47,3,240,31,128,248,0,63,64,63,3,240,63,64,248,0,63,64,126,3,240,63,1,248,0,63,64,189,3,240,126,1,248,0,63,64,252,3,224,253,1,244,0,63,66,248,7,226,252,2,244,0,63,75,240,11,215,244,3,244,0,63,95,209,255,223,224,255,240,0,63,75,128,255,199,128,191,224,0,42,66,0,249,1,0,122,64,
  // 0x5361  卡
  97,83,34,36,68,38,2,252,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,245,85,85,80,0,0,0,0,11,255,255,255,240,0,0,0,0,11,255,255,255,240,0,0,0,0,11,255,255,255,240,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,85,95,249,85,85,85,80,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,246,64,0,0,0,0,0,0,11,255,249,0,0,0,0,0,0,11,255,255,224,0,0,0,0,0,11,251,255,255,64,0,0,0,0,11,240,111,255,248,0,0,0,0,11,240,1,255,252,0,0,0,0,11,240,0,11,248,0,0,0,0,11,240,0,0,176,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,
  // 0x5370  印
  112,83,31,36,32,38,4,252,0,0,6,0,0,0,0,0,0,0,127,128,0,0,0,0,0,7,255,224,0,0,0,0,0,191,255,145,255,255,255,252,255,255,248,1,255,255,255,252,255,255,64,1,255,255,255,252,255,208,0,1,254,85,87,252,254,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,254,85,85,65,253,0,2,252,255,255,255,209,253,0,2,252,255,255,255,209,253,0,2,252,255,255,255,209,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,254,85,85,65,253,0,2,252,255,255,255,225,253,10,171,252,255,255,255,225,253,7,255,248,255,255,255,225,253,3,255,244,253,0,0,1,253,2,255,128,253,0,0,1,253,0,0,0,253,0,0,1,253,0,0,0,0,0,0,1,253,0,0,0,0,0,0,1,253,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,168,0,0,0,
  // 0x5378  卸
  120,83,34,36,68,38,1,252,0,30,64,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,64,0,0,21,85,85,80,0,191,0,0,0,127,255,255,240,0,255,255,255,248,127,255,255,240,1,255,255,255,248,127,255,255,240,3,255,255,255,248,127,0,7,240,11,240,63,64,0,127,0,7,240,31,224,63,64,0,127,0,7,240,63,192,63,64,0,127,0,7,240,15,64,63,64,0,127,0,7,240,1,0,63,64,0,127,0,7,240,63,255,255,255,253,127,0,7,240,63,255,255,255,253,127,0,7,240,63,255,255,255,253,127,0,7,240,0,0,63,64,0,127,0,7,240,0,0,63,64,0,127,0,7,240,0,0,63,64,0,127,0,7,240,3,240,63,64,0,127,0,7,240,3,240,63,64,0,127,0,7,240,3,240,63,255,240,127,0,7,240,3,240,63,255,240,127,0,7,240,3,240,63,255,240,127,0,7,240,3,240,63,64,0,127,0,7,240,3,240,63,64,0,127,0,7,240,3,240,63,64,0,127,0,7,240,3,240,63,64,0,127,6,175,240,3,240,63,64,4,127,7,255,240,3,240,63,171,253,127,3,255,208,3,246,255,255,253,127,2,254,64,111,255,255,255,253,127,0,0,0,191,255,255,249,64,127,0,0,0,127,255,164,0,0,127,0,0,0,58,64,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,
  // 0x537b  卻
  123,83,34,36,68,38,1,252,0,0,21,0,0,0,0,0,0,0,0,127,208,0,0,0,0,0,0,0,255,248,0,127,255,255,240,0,3,255,255,0,127,255,255,240,0,11,248,255,192,127,255,255,240,0,47,224,63,240,127,85,91,240,0,255,192,15,252,127,0,7,240,7,255,0,3,254,127,0,7,240,47,248,0,0,252,127,0,7,240,31,224,0,0,48,127,0,7,240,7,64,63,192,0,127,0,7,240,0,0,255,240,0,127,0,7,240,0,1,255,252,0,127,0,7,240,0,3,254,255,0,127,0,7,240,0,15,240,127,192,127,0,7,240,0,63,208,47,240,127,0,7,240,0,255,128,11,248,127,0,7,240,3,254,0,2,253,127,0,7,240,15,248,0,0,255,127,0,7,240,127,224,0,0,60,127,0,7,240,127,255,255,255,244,127,0,7,240,46,255,255,255,208,127,0,7,240,4,255,255,255,208,127,0,7,240,0,253,0,15,208,127,0,7,240,0,253,0,15,208,127,0,7,240,0,253,0,15,208,127,6,175,240,0,253,0,15,208,127,7,255,240,0,253,0,15,208,127,3,255,208,0,253,0,15,208,127,3,254,64,0,253,0,15,208,127,0,0,0,0,255,255,255,208,127,0,0,0,0,255,255,255,208,127,0,0,0,0,255,255,255,208,127,0,0,0,0,253,0,15,208,127,0,0,0,0,253,0,11,208,127,0,0,0,0,20,0,0,0,63,0,0,0,
  // 0x539f  原
  159,83,35,34,50,38,1,252,0,255,255,255,255,255,255,255,252,0,255,255,255,255,255,255,255,252,0,255,255,255,255,255,255,255,252,0,253,0,0,11,252,0,0,0,0,253,0,0,11,248,0,0,0,0,253,0,0,11,244,0,0,0,0,253,0,0,15,240,0,0,0,0,253,11,255,255,255,255,255,0,0,253,11,255,255,255,255,255,0,0,253,11,250,170,170,170,255,0,0,253,11,240,0,0,0,255,0,0,253,11,240,0,0,0,255,0,0,253,11,250,170,170,170,255,0,0,253,11,255,255,255,255,255,0,0,253,11,255,255,255,255,255,0,1,252,11,240,0,0,0,255,0,1,252,11,240,0,0,0,255,0,1,252,11,240,0,0,0,255,0,1,252,11,255,255,255,255,255,0,2,252,11,255,255,255,255,255,0,2,252,6,170,171,254,170,170,0,2,248,0,0,2,248,0,0,0,3,248,0,16,2,248,1,64,0,3,244,0,191,2,248,11,208,0,7,244,1,254,2,248,15,244,0,7,240,3,252,2,248,3,253,0,11,240,15,244,2,248,0,255,64,15,224,63,224,2,248,0,63,208,15,208,255,192,2,248,0,31,240,47,199,255,0,2,248,0,7,252,63,203,252,0,3,248,0,2,252,127,65,240,11,255,248,0,0,208,47,0,0,3,255,240,0,0,0,5,0,0,3,255,128,0,0,0,
  // 0x53cd  反
  205,83,34,34,50,38,2,252,0,85,85,85,85,85,85,85,0,0,191,255,255,255,255,255,255,64,0,191,255,255,255,255,255,255,64,0,191,255,255,255,255,255,255,64,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,255,255,255,255,255,224,0,0,191,255,255,255,255,255,244,0,0,191,255,255,255,255,255,240,0,0,191,95,245,85,85,111,224,0,0,191,11,240,0,0,63,208,0,0,190,7,248,0,0,127,192,0,0,254,3,252,0,0,255,64,0,0,254,1,254,0,0,255,0,0,0,254,0,255,0,2,254,0,0,0,253,0,127,192,7,252,0,0,1,252,0,63,224,31,244,0,0,1,252,0,15,244,63,224,0,0,2,252,0,11,253,255,192,0,0,3,252,0,3,255,255,64,0,0,3,248,0,0,255,253,0,0,0,7,244,0,0,127,252,0,0,0,11,240,0,2,255,255,0,0,0,15,224,0,31,255,255,224,0,0,31,208,1,255,253,191,254,0,0,63,192,111,255,224,31,255,244,0,191,135,255,255,0,2,255,255,208,255,3,255,244,0,0,127,255,192,46,1,254,0,0,0,2,255,64,4,0,144,0,0,0,0,26,0,
  // 0x53d6  取
  214,83,36,34,50,38,1,252,21,85,85,85,84,0,0,0,0,63,255,255,255,254,0,0,0,0,63,255,255,255,254,0,0,0,0,63,255,255,255,255,170,170,170,144,1,252,0,31,199,255,255,255,244,1,252,0,31,199,255,255,255,240,1,252,0,31,199,255,255,255,240,1,252,0,31,194,180,0,11,240,1,255,255,255,195,252,0,15,240,1,255,255,255,193,252,0,15,224,1,255,255,255,192,253,0,31,208,1,252,0,47,192,254,0,31,192,1,252,0,31,192,191,0,47,192,1,252,0,31,192,127,0,63,128,1,252,0,31,192,63,64,127,64,1,252,0,31,192,63,192,191,0,1,255,255,255,192,47,192,254,0,1,255,255,255,192,15,225,253,0,1,255,255,255,192,15,243,252,0,1,253,0,47,192,7,255,248,0,1,252,0,31,192,3,255,240,0,1,252,0,31,192,2,255,224,0,1,252,0,31,192,0,255,192,0,1,252,0,111,192,0,255,192,0,1,254,191,255,192,1,255,224,0,175,255,255,255,192,7,255,244,0,191,255,255,255,192,15,255,252,0,191,255,229,31,192,127,243,255,0,126,144,0,31,193,255,192,255,208,0,0,0,31,203,255,0,63,248,0,0,0,31,255,252,0,31,254,0,0,0,31,207,224,0,3,252,0,0,0,31,199,64,0,0,180,0,0,0,31,192,0,0,0,0,
  // 0x53f0  台
  240,83,34,36,68,38,2,252,0,0,0,228,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,244,0,0,64,0,0,0,0,31,240,0,11,208,0,0,0,0,63,208,0,31,244,0,0,0,0,191,192,0,11,254,0,0,0,0,255,0,0,2,255,128,0,0,2,254,0,0,0,191,224,0,0,7,252,0,0,0,63,244,0,106,175,254,255,255,255,255,253,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,192,127,255,254,170,149,84,0,63,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,11,128,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,149,85,85,85,111,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,149,85,85,85,111,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,64,0,0,0,47,192,0,0,42,64,0,0,0,26,128,0,
  // 0x5408  合
  8,84,36,36,68,38,1,252,0,0,0,1,254,0,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,11,255,208,0,0,0,0,0,0,31,255,244,0,0,0,0,0,0,127,219,252,0,0,0,0,0,1,255,131,255,0,0,0,0,0,3,255,0,255,208,0,0,0,0,15,252,0,63,244,0,0,0,0,127,240,0,15,254,0,0,0,1,255,192,0,3,255,192,0,0,11,255,0,0,0,255,244,0,0,63,252,0,0,0,47,254,0,2,255,240,0,0,0,11,255,224,31,254,191,255,255,255,254,191,253,127,244,127,255,255,255,253,31,253,63,192,127,255,255,255,253,2,248,13,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,240,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,240,0,0,0,15,240,0,0,7,224,0,0,0,11,224,0,
  // 0x5426  否
  38,84,35,34,50,38,1,252,31,255,255,255,255,255,255,255,244,31,255,255,255,255,255,255,255,244,31,255,255,255,255,255,255,255,244,5,85,85,85,127,245,85,85,80,0,0,0,0,255,208,0,0,0,0,0,0,3,255,64,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,191,254,7,208,0,0,0,0,3,255,254,31,253,0,0,0,0,47,255,254,31,255,192,0,0,2,255,248,254,1,255,248,0,0,47,255,192,254,0,31,255,64,7,255,254,0,254,0,2,255,240,127,255,224,0,254,0,0,127,252,63,254,0,0,254,0,0,11,248,15,224,0,0,254,0,0,1,224,6,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,255,248,0,0,31,255,255,255,255,255,248,0,0,31,255,255,255,255,255,248,0,0,31,208,0,0,0,7,248,0,0,31,208,0,0,0,3,248,0,0,31,208,0,0,0,3,248,0,0,31,208,0,0,0,3,248,0,0,31,208,0,0,0,3,248,0,0,31,208,0,0,0,3,248,0,0,31,208,0,0,0,3,248,0,0,31,255,255,255,255,255,248,0,0,31,255,255,255,255,255,248,0,0,31,255,255,255,255,255,248,0,0,31,208,0,0,0,7,248,0,0,31,192,0,0,0,3,248,0,
  // 0x544a  告
  74,84,34,37,77,38,2,251,0,1,0,0,190,0,0,0,0,0,7,244,0,255,0,0,0,0,0,11,240,0,255,0,0,0,0,0,15,240,0,255,0,0,0,0,0,31,208,0,255,0,0,0,0,0,63,208,0,255,0,0,0,0,0,127,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,2,255,255,255,255,255,255,252,0,7,252,0,0,255,0,0,0,0,31,240,0,0,255,0,0,0,0,63,208,0,0,255,0,0,0,0,11,128,0,0,255,0,0,0,0,1,0,0,0,255,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,21,85,85,85,85,85,85,85,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,149,85,85,85,95,224,0,0,63,128,0,0,0,15,224,0,0,63,128,0,0,0,15,224,0,0,63,128,0,0,0,15,224,0,0,63,128,0,0,0,15,224,0,0,63,128,0,0,0,15,224,0,0,63,149,85,85,85,95,224,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,128,0,0,0,15,224,0,0,63,128,0,0,0,15,224,0,0,0,0,0,0,0,0,0,0,
  // 0x547d  命
  125,84,36,37,77,38,1,251,0,0,0,2,255,0,0,0,0,0,0,0,7,255,192,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,63,255,248,0,0,0,0,0,1,255,199,255,0,0,0,0,0,7,255,1,255,192,0,0,0,0,31,252,0,127,244,0,0,0,0,191,240,0,15,254,0,0,0,7,255,128,0,3,255,208,0,0,47,254,0,0,0,191,248,0,1,255,255,255,255,255,255,255,128,31,255,139,255,255,255,226,255,248,255,253,11,255,255,255,224,127,255,127,224,0,0,0,0,0,7,252,46,0,0,0,0,0,0,0,116,0,0,0,0,0,0,0,0,0,0,255,255,255,3,255,255,255,64,0,255,255,255,3,255,255,255,64,0,255,255,255,3,255,255,255,64,0,253,0,63,3,244,0,63,64,0,253,0,63,3,244,0,63,64,0,253,0,63,3,244,0,63,64,0,253,0,63,3,244,0,63,64,0,253,0,63,3,244,0,63,64,0,253,0,63,3,244,0,63,64,0,253,0,63,3,244,0,63,64,0,253,0,63,3,244,0,63,64,0,255,255,255,3,244,0,63,64,0,255,255,255,3,244,0,127,64,0,255,255,255,3,244,127,255,0,0,253,0,0,3,244,63,255,0,0,253,0,0,3,244,63,248,0,0,253,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x548c  和
  140,84,34,36,68,38,1,252,0,0,0,5,0,0,0,0,0,0,0,1,191,0,0,0,0,0,0,5,191,255,192,0,0,0,0,26,255,255,255,129,85,85,85,64,31,255,255,144,3,255,255,255,208,15,254,254,0,3,255,255,255,208,4,0,254,0,3,255,255,255,208,0,0,254,0,3,244,0,15,208,0,0,254,0,3,244,0,15,208,0,0,254,0,3,244,0,15,208,0,0,254,0,3,244,0,15,208,21,85,254,85,67,244,0,15,208,63,255,255,255,227,244,0,15,208,63,255,255,255,227,244,0,15,208,63,255,255,255,227,244,0,15,208,0,3,254,0,3,244,0,15,208,0,7,255,0,3,244,0,15,208,0,15,255,192,3,244,0,15,208,0,15,255,240,3,244,0,15,208,0,47,255,252,3,244,0,15,208,0,63,254,254,3,244,0,15,208,0,189,254,127,67,244,0,15,208,1,252,254,47,211,244,0,15,208,3,248,254,15,211,244,0,15,208,11,240,254,7,131,244,0,15,208,31,224,254,2,3,244,0,15,208,63,192,254,0,3,244,0,15,208,191,64,254,0,3,249,85,111,208,126,0,254,0,3,255,255,255,208,44,0,254,0,3,255,255,255,208,0,0,254,0,3,255,255,255,208,0,0,254,0,3,244,0,15,208,0,0,254,0,3,244,0,15,208,0,0,254,0,3,244,0,15,208,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,
  // 0x555f  啟
  95,85,36,36,68,38,1,252,0,0,108,0,0,0,164,0,0,0,0,254,0,0,0,253,0,0,0,0,191,0,0,0,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,128,0,2,252,0,0,3,255,255,255,240,2,248,0,0,3,255,255,255,240,3,244,0,0,3,255,255,255,240,3,245,85,84,3,244,0,3,240,11,255,255,253,3,244,0,3,240,15,255,255,253,3,244,0,3,240,15,255,255,253,3,244,0,3,240,47,192,15,208,3,244,0,3,240,63,192,15,208,3,244,0,3,240,127,208,15,192,3,255,255,255,240,255,224,31,192,3,255,255,255,241,255,240,47,192,3,255,255,255,247,255,240,47,128,3,244,0,0,2,247,240,63,64,3,244,0,0,0,178,248,63,0,3,240,0,0,0,0,252,127,0,3,240,0,0,0,0,252,190,0,3,247,255,255,248,0,190,253,0,7,247,255,255,248,0,127,252,0,7,247,255,255,248,0,63,248,0,11,231,224,1,248,0,47,244,0,11,231,224,1,248,0,31,240,0,15,215,224,1,248,0,31,240,0,15,199,224,1,248,0,63,244,0,31,199,224,1,248,0,255,252,0,47,199,224,1,248,2,255,255,0,63,135,255,255,248,11,252,127,128,127,7,255,255,248,47,240,47,224,191,7,255,255,249,255,208,15,252,45,7,224,1,249,255,64,3,253,4,7,224,1,164,188,0,0,244,0,1,80,0,0,32,0,0,16,
  // 0x55ae  單
  174,85,34,35,59,38,2,252,1,85,85,84,1,85,85,84,0,3,255,255,254,11,255,255,253,0,3,255,255,254,11,255,255,253,0,3,240,0,190,11,224,0,253,0,3,240,0,190,11,224,0,253,0,3,240,0,190,11,224,0,253,0,3,255,255,254,11,255,255,253,0,3,255,255,254,11,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,244,0,0,255,255,255,255,255,255,244,0,0,255,255,255,255,255,255,244,0,0,253,0,3,248,0,3,244,0,0,253,0,3,248,0,3,244,0,0,255,170,171,254,170,171,244,0,0,255,255,255,255,255,255,244,0,0,255,255,255,255,255,255,244,0,0,253,0,3,248,0,3,244,0,0,253,0,3,248,0,3,244,0,0,253,0,3,248,0,3,244,0,0,255,255,255,255,255,255,244,0,0,255,255,255,255,255,255,244,0,0,255,255,255,255,255,255,244,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,
  // 0x5634  嘴
  52,86,34,37,77,38,3,251,0,0,0,2,224,11,208,0,0,0,0,0,3,240,11,208,0,0,0,0,0,3,240,11,208,24,0,255,255,131,195,240,11,209,255,0,255,255,131,195,250,155,239,253,0,255,255,131,195,255,235,255,208,0,248,31,131,195,255,235,253,0,0,244,15,131,195,240,11,224,0,0,244,15,131,195,240,11,208,1,0,244,15,131,195,240,11,208,3,208,244,15,131,195,251,235,208,7,208,244,15,155,255,255,247,250,175,192,244,15,191,255,255,147,255,255,128,244,15,191,255,252,1,255,254,0,244,15,153,3,253,85,64,0,0,244,15,128,11,255,255,224,0,0,244,15,128,47,255,255,240,0,0,244,15,128,191,64,31,192,0,0,244,15,130,255,85,127,149,84,0,244,15,159,255,255,255,255,253,0,244,15,255,255,255,255,255,253,0,255,255,159,254,0,252,0,253,0,255,255,128,190,0,252,0,253,0,255,255,128,191,255,255,255,253,0,248,0,0,191,255,255,255,253,0,244,0,0,190,0,252,0,253,0,244,0,0,253,0,252,0,253,0,244,0,0,253,0,252,0,253,0,0,0,0,255,255,255,255,253,0,0,0,2,255,255,255,255,253,0,0,0,3,249,85,85,85,253,0,0,0,11,240,0,0,0,253,0,0,0,47,224,0,0,0,253,0,0,0,191,192,0,1,170,253,0,0,0,255,0,0,1,255,252,0,0,0,44,0,0,0,255,224,0,0,0,0,0,0,0,0,0,0,
  // 0x5668  器
  104,86,36,35,59,38,1,251,1,255,255,255,0,255,255,255,64,1,255,255,255,0,255,255,255,64,1,255,255,255,0,255,255,255,64,1,252,0,127,0,252,0,63,64,1,252,0,127,0,252,0,63,64,1,252,0,127,0,252,0,63,64,1,252,0,127,0,252,0,63,64,1,252,0,127,0,252,0,63,64,1,255,255,255,0,255,255,255,64,1,255,255,255,64,255,255,255,64,1,255,255,255,248,255,255,255,64,0,0,0,7,252,0,0,0,0,0,0,0,15,240,0,0,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,31,252,0,63,224,0,0,0,0,191,240,0,15,252,0,0,0,3,255,192,0,3,255,64,0,0,47,254,0,0,0,255,240,0,6,255,244,0,0,0,47,255,64,127,255,255,255,65,255,255,255,249,191,255,255,255,65,255,255,255,254,63,255,255,255,65,255,255,255,252,30,253,0,63,65,248,0,127,112,0,253,0,63,65,248,0,127,0,0,253,0,63,65,248,0,127,0,0,253,0,63,65,248,0,127,0,0,253,0,63,65,248,0,127,0,0,253,0,63,65,248,0,127,0,0,255,255,255,65,255,255,255,0,0,255,255,255,65,255,255,255,0,0,255,255,255,65,255,255,255,0,0,253,0,63,65,248,0,127,0,0,0,0,0,0,0,0,0,0,
  // 0x5674  噴
  116,86,34,37,77,38,3,251,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,1,255,255,255,255,255,0,255,255,225,255,255,255,255,255,0,255,255,224,85,85,254,85,85,0,255,255,224,6,144,253,10,128,0,252,11,224,11,208,253,15,192,0,252,11,224,11,208,0,15,192,0,252,11,239,255,255,255,255,255,208,252,11,239,255,255,255,255,255,208,252,11,229,95,229,85,111,213,64,252,11,224,11,208,0,15,192,0,252,11,224,5,64,0,5,64,0,252,11,224,191,255,255,255,252,0,252,11,224,191,255,255,255,252,0,252,11,224,190,0,0,1,252,0,252,11,224,190,0,0,1,252,0,252,11,224,190,0,0,1,252,0,252,11,224,191,255,255,255,252,0,252,11,224,191,255,255,255,252,0,252,11,224,190,0,0,1,252,0,255,255,224,190,0,0,1,252,0,255,255,224,191,255,255,255,252,0,255,255,224,191,255,255,255,252,0,252,0,0,190,0,0,1,252,0,252,0,0,190,0,0,1,252,0,252,0,0,190,0,0,1,252,0,84,0,0,191,255,255,255,252,0,0,0,0,191,255,255,255,252,0,0,0,0,2,228,0,125,0,0,0,0,0,47,252,1,255,208,0,0,0,6,255,224,0,47,253,0,0,0,191,255,0,0,3,255,128,0,0,127,224,0,0,0,127,192,0,0,29,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,
  // 0x56de  回
  222,86,32,35,24,38,3,252,170,170,170,170,170,170,170,170,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,191,255,255,253,0,255,255,0,191,255,255,253,0,255,255,0,191,255,255,253,0,255,255,0,190,0,0,253,0,255,255,0,190,0,0,253,0,255,255,0,190,0,0,253,0,255,255,0,190,0,0,253,0,255,255,0,190,0,0,253,0,255,255,0,190,0,0,253,0,255,255,0,190,0,0,253,0,255,255,0,191,0,0,253,0,255,255,0,191,255,255,253,0,255,255,0,191,255,255,253,0,255,255,0,191,255,255,253,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,85,85,85,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,
  // 0x56e0  因
  224,86,32,34,16,38,3,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,85,85,85,255,254,0,0,5,64,0,0,191,254,0,0,15,208,0,0,191,254,0,0,15,208,0,0,191,254,0,0,15,208,0,0,191,254,0,0,15,208,0,0,191,254,0,0,15,208,0,0,191,254,47,255,255,255,255,248,191,254,47,255,255,255,255,248,191,254,47,255,255,255,255,248,191,254,0,0,47,244,0,0,191,254,0,0,63,244,0,0,191,254,0,0,63,252,0,0,191,254,0,0,127,252,0,0,191,254,0,0,255,190,0,0,191,254,0,1,253,63,64,0,191,254,0,3,252,63,192,0,191,254,0,11,248,31,224,0,191,254,0,47,240,11,252,0,191,254,0,191,208,3,255,64,191,254,7,255,64,0,255,224,191,254,63,252,0,0,63,248,191,254,15,224,0,0,11,224,191,254,7,0,0,0,1,192,191,254,0,0,0,0,0,0,191,255,85,85,85,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,0,0,0,0,0,0,191,190,0,0,0,0,0,0,190,
  // 0x56fa  固
  250,86,32,35,24,38,3,251,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,85,85,85,85,85,85,255,191,0,0,0,0,0,0,255,191,0,0,11,224,0,0,255,191,0,0,11,224,0,0,255,191,0,0,11,224,0,0,255,191,0,0,11,224,0,0,255,191,15,255,255,255,255,244,255,191,15,255,255,255,255,244,255,191,15,255,255,255,255,240,255,191,0,0,11,224,0,0,255,191,0,0,11,224,0,0,255,191,0,0,11,224,0,0,255,191,0,170,175,250,170,0,255,191,0,255,255,255,255,0,255,191,0,255,255,255,255,0,255,191,0,252,0,0,63,0,255,191,0,252,0,0,63,0,255,191,0,252,0,0,63,0,255,191,0,252,0,0,63,0,255,191,0,252,0,0,63,0,255,191,0,255,255,255,255,0,255,191,0,255,255,255,255,0,255,191,0,170,170,170,170,0,255,191,0,0,0,0,0,0,255,191,0,0,0,0,0,0,255,191,0,0,0,0,0,0,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,85,85,85,85,85,85,255,191,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,
  // 0x5716  圖
  22,87,32,34,16,38,3,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,0,0,0,0,0,0,127,253,0,191,255,255,253,0,127,253,0,191,255,255,253,0,127,253,0,189,0,0,189,0,127,253,0,189,0,0,189,0,127,253,0,191,255,255,253,0,127,253,0,191,255,255,253,0,127,253,0,0,11,208,0,0,127,253,0,0,11,208,0,0,127,253,63,255,255,255,255,252,127,253,63,255,255,255,255,252,127,253,0,0,0,0,0,0,127,253,3,255,255,255,255,128,127,253,3,255,255,255,255,128,127,253,3,240,0,0,15,128,127,253,3,240,0,0,15,128,127,253,3,240,255,255,15,128,127,253,3,240,250,191,15,128,127,253,3,240,240,31,15,128,127,253,3,240,250,191,15,128,127,253,3,240,255,255,15,128,127,253,3,240,0,0,15,128,127,253,3,240,0,0,15,128,127,253,3,255,255,255,255,128,127,253,3,255,255,255,255,128,127,253,0,0,0,0,0,0,127,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,0,0,0,0,0,0,127,169,0,0,0,0,0,0,106,
  // 0x5728  在
  40,87,35,36,68,38,1,252,0,0,0,25,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,5,85,95,245,85,85,85,85,80,0,0,31,224,0,0,0,0,0,0,0,63,192,0,31,192,0,0,0,0,191,64,0,47,192,0,0,0,1,255,0,0,47,192,0,0,0,3,253,0,0,47,192,0,0,0,11,248,0,0,47,192,0,0,0,47,240,0,0,47,192,0,0,0,191,224,0,0,47,192,0,0,1,255,224,47,255,255,255,255,192,11,255,224,47,255,255,255,255,192,63,255,224,47,255,255,255,255,192,127,239,224,5,85,111,213,85,64,63,79,224,0,0,47,192,0,0,29,15,224,0,0,47,192,0,0,4,15,224,0,0,47,192,0,0,0,15,224,0,0,47,192,0,0,0,15,224,0,0,47,192,0,0,0,15,224,0,0,47,192,0,0,0,15,224,0,0,47,192,0,0,0,15,224,0,0,47,192,0,0,0,15,224,0,0,47,192,0,0,0,15,224,85,85,111,213,85,80,0,15,224,255,255,255,255,255,248,0,15,224,255,255,255,255,255,248,0,15,224,255,255,255,255,255,248,0,15,224,0,0,0,0,0,0,
  // 0x578b  型
  139,87,34,35,59,38,2,253,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,127,0,15,255,255,255,252,5,64,127,0,15,255,255,255,252,31,192,127,0,15,255,255,255,252,31,192,127,0,0,63,64,190,0,31,192,127,0,0,63,64,190,0,31,192,127,0,0,63,64,190,0,31,192,127,0,0,63,64,190,0,31,192,127,0,0,63,64,191,0,31,192,127,0,127,255,255,255,254,31,192,127,0,127,255,255,255,254,31,192,127,0,127,255,255,255,254,31,192,127,0,0,127,0,190,0,31,192,127,0,0,191,0,190,0,31,192,127,0,0,253,0,190,0,5,64,127,0,3,252,0,190,0,0,0,127,0,11,248,0,190,0,0,0,127,0,63,240,0,190,0,0,255,255,0,191,192,0,190,0,0,255,254,0,47,0,0,107,252,0,191,248,0,4,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,85,85,85,85,85,85,80,
  // 0x57f7  執
  247,87,36,37,77,38,1,251,0,1,252,0,0,15,192,0,0,0,1,252,0,0,15,192,0,0,0,1,252,0,0,15,192,0,0,0,1,252,0,0,15,192,0,0,15,255,255,255,0,15,192,0,0,15,255,255,255,0,15,192,0,0,15,255,255,255,0,15,192,0,0,0,1,252,0,21,95,213,85,0,0,1,252,0,63,255,255,255,0,0,1,252,0,63,255,255,255,0,127,255,255,255,255,255,255,255,0,127,255,255,255,224,15,192,63,0,127,255,255,255,224,15,192,63,0,2,240,0,189,0,31,192,63,0,2,244,0,253,0,31,192,63,0,1,248,0,252,0,31,192,63,0,0,252,1,248,12,31,192,63,0,0,188,2,240,47,159,192,63,0,0,189,3,240,127,255,128,63,0,63,255,255,255,223,255,128,63,0,63,255,255,255,194,255,192,63,0,63,255,255,255,192,127,240,63,0,0,1,252,0,0,127,252,63,0,0,1,252,0,0,191,255,127,0,0,1,252,0,0,254,191,191,0,31,255,255,255,65,252,31,63,0,31,255,255,255,67,252,4,63,8,31,255,255,255,71,244,0,63,78,0,1,252,0,15,240,0,63,79,0,1,252,0,47,208,0,47,79,0,1,252,0,127,192,0,31,143,0,1,252,1,255,0,0,31,223,0,1,252,7,253,0,0,15,254,0,1,252,31,248,0,0,11,253,0,1,252,11,224,0,0,3,252,0,1,248,1,128,0,0,0,244,0,0,0,0,0,0,0,0,0,
  // 0x584a  塊
  74,88,36,36,68,38,1,252,0,26,64,0,0,46,144,0,0,0,47,128,0,0,63,192,0,0,0,47,128,0,0,127,128,0,0,0,47,128,0,0,191,0,0,0,0,47,128,47,255,255,255,255,240,0,47,128,47,255,255,255,255,240,0,47,128,47,255,255,255,255,240,0,47,128,47,128,31,192,11,240,21,127,149,47,128,31,192,11,240,63,255,255,47,128,31,192,11,240,63,255,255,47,234,191,234,175,240,63,255,255,47,255,255,255,255,240,0,47,128,47,255,255,255,255,240,0,47,128,47,128,31,192,11,240,0,47,128,47,128,31,192,11,240,0,47,128,47,128,31,192,11,240,0,47,128,47,128,31,192,11,240,0,47,128,47,255,255,255,255,240,0,47,128,47,255,255,255,255,240,0,47,128,47,255,255,255,255,240,0,47,128,64,127,11,224,80,0,0,47,159,128,127,11,224,248,0,0,47,255,192,127,11,224,244,64,0,127,255,192,191,11,225,242,224,27,255,254,0,254,11,226,225,240,191,255,208,0,254,11,227,225,248,127,249,0,1,253,11,239,255,252,63,128,0,2,252,11,239,255,252,36,0,0,7,248,11,230,80,36,0,0,0,15,244,11,224,0,16,0,0,0,63,224,11,224,0,125,0,0,2,255,192,11,240,0,189,0,0,47,255,0,7,255,255,253,0,0,63,252,0,3,255,255,252,0,0,31,208,0,1,255,255,240,0,0,9,0,0,0,0,0,0,
  // 0x586b  填
  107,88,36,36,68,38,1,252,0,5,0,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,191,255,255,255,255,252,0,63,64,255,255,255,255,255,252,0,63,64,255,255,255,255,255,252,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,31,208,0,0,21,127,149,3,255,255,255,255,0,63,255,255,3,255,255,255,255,0,63,255,255,3,244,0,0,63,0,63,255,255,3,244,0,0,127,0,0,63,64,3,255,255,255,255,0,0,63,64,3,255,255,255,255,0,0,63,64,3,244,0,0,63,0,0,63,64,3,244,0,0,63,0,0,63,64,3,255,255,255,255,0,0,63,64,3,255,255,255,255,0,0,63,64,3,244,0,0,127,0,0,63,64,3,244,0,0,63,0,0,63,64,3,245,85,85,127,0,0,63,75,131,255,255,255,255,0,0,63,255,195,255,255,255,255,0,0,127,255,192,0,0,0,0,0,11,255,253,0,0,0,0,0,0,127,255,211,255,255,255,255,255,253,127,253,3,255,255,255,255,255,253,63,128,3,255,255,255,255,255,253,24,0,0,0,30,0,3,128,0,0,0,0,0,191,192,31,244,0,0,0,0,7,255,0,11,255,0,0,0,0,191,248,0,0,255,208,0,0,11,255,208,0,0,47,248,0,0,3,254,0,0,0,7,253,0,0,0,160,0,0,0,0,144,
  // 0x588a  墊
  138,88,36,35,59,38,1,253,0,1,252,0,0,6,144,0,0,0,1,252,0,0,11,208,0,0,5,86,253,85,0,11,208,0,0,15,255,255,255,64,11,208,0,0,15,255,255,255,64,11,208,0,0,0,1,252,0,11,255,255,255,0,0,1,252,0,11,255,255,255,0,21,86,255,255,245,95,255,255,0,127,255,255,255,240,11,208,126,0,127,255,255,255,240,15,208,126,0,1,244,0,252,2,15,192,126,0,0,252,2,244,15,239,192,126,0,21,254,87,245,111,255,192,126,0,63,255,255,255,242,255,192,127,0,63,255,255,255,240,63,244,127,0,0,1,252,0,0,127,253,63,0,0,1,252,0,0,255,255,127,4,5,86,253,85,65,252,62,63,13,15,255,255,255,131,248,8,63,31,15,255,255,255,143,240,0,63,30,0,1,252,0,63,208,0,47,174,0,1,252,0,191,64,0,15,253,0,1,252,0,126,0,0,11,252,0,1,252,0,254,0,0,2,244,0,0,0,0,254,0,0,0,0,0,127,255,255,255,255,255,253,0,0,127,255,255,255,255,255,253,0,0,127,255,255,255,255,255,253,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,
  // 0x5916  外
  22,89,36,36,68,38,1,252,0,0,57,0,0,0,191,0,0,0,0,127,64,0,0,191,0,0,0,0,191,0,0,0,191,0,0,0,0,254,0,0,0,191,0,0,0,1,253,0,0,0,191,0,0,0,2,252,0,0,0,191,0,0,0,3,255,255,254,0,191,0,0,0,11,255,255,255,0,191,0,0,0,15,255,255,255,0,191,0,0,0,31,229,85,255,64,191,0,0,0,63,192,0,255,224,191,0,0,0,191,64,1,255,244,191,0,0,0,255,0,2,255,252,191,0,0,2,253,0,3,252,254,191,0,0,7,253,0,3,244,191,255,0,0,31,255,128,7,240,63,255,0,0,63,255,244,11,240,15,255,0,0,191,223,254,15,224,7,255,0,0,47,2,255,239,192,1,255,64,0,5,0,127,255,192,0,255,224,0,0,0,15,255,64,0,191,252,0,0,0,3,255,0,0,191,255,64,0,0,1,253,0,0,191,255,224,0,0,3,252,0,0,191,127,254,0,0,15,244,0,0,191,15,254,0,0,31,240,0,0,191,2,252,0,0,127,192,0,0,191,0,48,0,0,255,128,0,0,191,0,0,0,3,255,0,0,0,191,0,0,0,15,252,0,0,0,191,0,0,0,127,240,0,0,0,191,0,0,2,255,192,0,0,0,191,0,0,31,255,0,0,0,0,191,0,0,31,252,0,0,0,0,191,0,0,7,224,0,0,0,0,191,0,0,1,0,0,0,0,0,190,0,0,
  // 0x591a  多
  26,89,33,36,68,38,3,252,0,0,0,46,64,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,15,255,255,255,240,0,0,0,0,127,255,255,255,252,0,0,0,3,255,255,255,255,244,0,0,0,47,253,0,0,31,240,0,0,6,255,244,0,0,127,192,0,0,127,255,254,0,1,255,64,0,0,191,250,255,208,7,253,0,0,0,47,64,47,252,47,244,0,0,0,4,0,7,255,255,208,0,0,0,0,0,0,255,255,64,0,0,0,0,0,0,127,249,144,0,0,0,0,0,7,255,215,254,0,0,0,0,0,191,254,15,248,0,0,0,0,47,255,224,127,224,0,0,0,91,255,254,2,255,255,255,253,0,255,255,208,15,255,255,255,255,64,191,248,0,191,255,255,255,255,0,57,0,11,255,128,0,3,252,0,0,0,191,253,0,0,11,248,0,0,31,255,255,0,0,31,240,0,0,255,254,255,224,0,63,208,0,0,127,208,63,252,1,255,128,0,0,45,0,7,255,75,254,0,0,0,0,0,0,255,255,248,0,0,0,0,0,0,47,255,224,0,0,0,0,0,0,31,255,64,0,0,0,0,0,2,255,248,0,0,0,0,0,0,127,255,208,0,0,0,0,0,111,255,253,0,0,0,0,2,191,255,255,144,0,0,0,0,3,255,255,244,0,0,0,0,0,2,255,249,0,0,0,0,0,0,0,229,0,0,0,0,0,0,0,
  // 0x5920  夠
  32,89,34,36,68,38,2,252,0,6,64,0,0,100,0,0,0,0,15,224,0,0,254,0,0,0,0,31,192,0,0,252,0,0,0,0,63,128,0,2,252,0,0,0,0,191,255,248,3,248,0,0,0,2,255,255,253,7,244,0,0,0,7,255,255,252,15,255,255,255,208,31,224,2,248,15,255,255,255,208,191,128,7,240,63,255,255,255,208,255,16,15,224,127,64,0,15,208,56,252,47,192,255,0,0,15,208,0,255,255,66,253,0,0,15,208,0,63,254,7,248,0,0,15,208,0,15,248,11,251,255,255,15,208,0,127,224,2,219,255,255,15,208,2,255,254,0,11,255,255,15,192,47,254,253,0,11,208,63,15,192,191,243,248,0,11,208,63,15,192,63,75,255,255,75,208,63,15,192,20,47,255,255,203,208,63,15,192,0,127,255,255,139,208,63,15,192,2,254,0,63,11,208,63,15,192,11,248,0,191,11,208,63,15,192,127,224,0,253,11,208,63,15,192,255,74,2,252,11,255,255,15,192,124,63,199,244,11,255,255,31,192,16,31,255,224,11,255,254,31,192,0,3,255,192,11,208,0,31,192,0,1,255,0,11,208,0,47,128,0,11,253,0,6,128,0,47,128,0,63,244,0,0,0,0,63,64,6,255,192,0,0,0,0,127,64,191,254,0,0,0,1,255,255,0,255,244,0,0,0,0,255,254,0,127,64,0,0,0,0,255,248,0,36,0,0,0,0,0,0,0,0,
  // 0x5927  大
  39,89,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,106,170,170,175,255,170,170,170,144,0,0,0,31,255,0,0,0,0,0,0,0,47,255,128,0,0,0,0,0,0,63,255,192,0,0,0,0,0,0,63,239,208,0,0,0,0,0,0,191,79,240,0,0,0,0,0,0,255,15,240,0,0,0,0,0,1,254,7,252,0,0,0,0,0,3,253,3,253,0,0,0,0,0,11,252,1,255,0,0,0,0,0,15,244,0,255,192,0,0,0,0,63,240,0,63,208,0,0,0,0,191,192,0,47,244,0,0,0,2,255,128,0,15,252,0,0,0,11,254,0,0,7,255,64,0,0,47,252,0,0,1,255,208,0,1,255,240,0,0,0,127,248,0,11,255,192,0,0,0,31,255,128,191,254,0,0,0,0,7,255,240,191,244,0,0,0,0,0,255,208,47,128,0,0,0,0,0,47,128,8,0,0,0,0,0,0,2,0,
  // 0x5929  天
  41,89,35,33,41,38,2,252,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,106,170,170,171,254,170,170,170,144,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,31,255,255,255,255,255,255,255,128,31,255,255,255,255,255,255,255,128,31,255,255,255,255,255,255,255,128,26,170,170,175,255,170,170,170,64,0,0,0,15,255,0,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,47,255,192,0,0,0,0,0,0,63,255,208,0,0,0,0,0,0,127,223,240,0,0,0,0,0,0,255,75,248,0,0,0,0,0,3,255,3,253,0,0,0,0,0,11,253,2,255,0,0,0,0,0,47,248,0,255,192,0,0,0,0,255,224,0,63,244,0,0,0,7,255,192,0,31,254,0,0,0,127,254,0,0,7,255,208,0,7,255,248,0,0,1,255,253,0,191,255,192,0,0,0,47,255,244,255,253,0,0,0,0,7,255,240,63,208,0,0,0,0,0,191,192,41,0,0,0,0,0,0,6,128,
  // 0x5931  失
  49,89,35,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,11,240,3,248,0,0,0,0,0,15,240,3,248,0,0,0,0,0,31,224,3,248,0,0,0,0,0,47,192,3,248,0,0,0,0,0,63,192,3,248,0,0,0,0,0,191,234,171,254,170,170,164,0,0,255,255,255,255,255,255,248,0,1,255,255,255,255,255,255,248,0,3,255,255,255,255,255,255,248,0,7,248,0,3,248,0,0,0,0,15,240,0,3,248,0,0,0,0,63,224,0,3,248,0,0,0,0,191,192,0,3,248,0,0,0,0,47,128,0,3,248,0,0,0,0,6,0,0,3,244,0,0,0,0,0,0,0,7,244,0,0,0,0,106,170,170,171,250,170,170,170,144,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,47,255,64,0,0,0,0,0,0,63,255,192,0,0,0,0,0,0,191,239,224,0,0,0,0,0,0,255,79,240,0,0,0,0,0,3,255,7,252,0,0,0,0,0,11,253,3,255,0,0,0,0,0,47,248,0,255,192,0,0,0,0,255,224,0,127,240,0,0,0,7,255,192,0,31,254,0,0,0,127,254,0,0,7,255,208,0,7,255,248,0,0,1,255,254,0,191,255,192,0,0,0,47,255,244,255,253,0,0,0,0,7,255,240,63,208,0,0,0,0,0,127,208,24,0,0,0,0,0,0,6,128,
  // 0x59cb  始
  203,89,35,36,68,38,2,252,0,62,64,0,0,57,0,0,0,0,63,64,0,0,127,192,0,0,0,127,0,0,0,127,64,0,0,0,127,0,0,0,255,0,0,0,0,190,0,0,0,254,0,0,0,0,254,0,0,1,253,0,0,0,0,253,0,0,2,252,0,144,0,0,252,0,0,3,248,7,240,0,255,255,255,240,7,244,3,248,0,255,255,255,240,11,240,1,253,0,255,255,255,240,15,224,0,255,0,87,245,91,240,31,192,0,63,128,7,240,11,224,47,213,170,191,192,11,240,15,239,255,255,255,255,240,15,224,15,223,255,255,255,255,244,15,208,15,203,255,255,234,151,248,15,192,31,197,80,0,0,2,248,31,192,31,192,0,0,0,1,128,47,128,47,128,0,0,0,0,0,63,64,63,64,0,0,0,0,0,63,64,127,0,127,255,255,255,192,127,224,191,0,127,255,255,255,192,191,253,254,0,127,255,255,255,192,255,255,253,0,127,0,0,47,192,44,191,252,0,127,0,0,47,192,0,31,252,0,127,0,0,47,192,0,15,255,64,127,0,0,47,192,0,31,255,208,127,0,0,47,192,0,63,255,240,127,0,0,47,192,0,255,139,252,127,0,0,47,192,2,255,2,240,127,0,0,47,192,11,252,0,208,127,255,255,255,192,127,244,0,0,127,255,255,255,192,191,192,0,0,127,255,255,255,192,63,0,0,0,127,0,0,47,192,8,0,0,0,127,0,0,26,128,
  // 0x5a92  媒
  146,90,36,36,68,38,1,252,0,46,64,0,63,0,0,254,0,0,63,128,0,63,0,0,254,0,0,63,64,0,63,0,0,254,0,0,63,0,0,63,0,0,254,0,0,127,0,47,255,255,255,255,252,0,127,0,47,255,255,255,255,252,0,190,0,47,255,255,255,255,252,0,254,0,0,63,0,0,254,0,127,255,255,224,63,0,0,254,0,127,255,255,224,63,0,0,254,0,127,255,255,224,63,170,170,254,0,22,253,95,208,63,255,255,254,0,3,248,15,208,63,255,255,254,0,3,244,15,208,63,0,0,254,0,3,240,15,192,63,0,0,254,0,7,240,15,192,63,0,0,254,0,11,224,31,192,63,255,255,254,0,11,224,31,192,63,255,255,254,0,15,208,47,128,63,255,255,254,0,15,192,63,64,0,7,240,0,0,31,192,127,0,0,7,240,0,0,47,240,191,0,0,7,240,0,0,63,253,254,47,255,255,255,255,252,63,255,253,47,255,255,255,255,252,11,127,252,47,255,255,255,255,252,0,15,252,0,0,255,255,0,0,0,7,254,0,2,255,255,192,0,0,15,255,128,11,255,255,240,0,0,47,255,208,47,231,243,252,0,0,127,207,224,191,199,240,255,0,0,255,3,195,255,7,240,127,208,3,254,1,111,252,7,240,47,252,31,248,0,255,240,7,240,11,253,63,224,0,63,128,7,240,1,244,15,128,0,13,0,7,240,0,32,5,0,0,0,0,7,240,0,0,
  // 0x5b50  子
  80,91,34,35,59,38,2,251,0,85,85,85,85,85,85,128,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,240,0,0,0,0,0,0,2,255,192,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,127,244,0,0,0,0,0,0,2,255,208,0,0,0,0,0,0,31,254,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,170,170,170,171,254,170,170,170,160,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,170,171,252,0,0,0,0,0,0,255,255,248,0,0,0,0,0,0,127,255,240,0,0,0,0,0,0,63,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5b58  存
  88,91,35,36,68,38,1,252,0,0,0,41,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,255,0,0,0,0,0,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,5,85,95,249,85,85,85,85,84,0,0,15,240,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,191,128,0,0,0,4,0,0,1,255,3,255,255,255,255,0,0,3,253,3,255,255,255,255,128,0,11,252,3,255,255,255,255,0,0,47,240,0,0,0,11,252,0,0,127,224,0,0,0,47,224,0,1,255,224,0,0,0,255,128,0,7,255,224,0,0,15,253,0,0,47,255,224,0,0,15,240,0,0,191,239,224,0,0,15,224,0,0,63,143,224,255,255,255,255,255,252,29,15,224,255,255,255,255,255,252,0,15,224,255,255,255,255,255,252,0,15,224,85,85,95,245,85,84,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,85,95,224,0,0,0,15,224,0,127,255,224,0,0,0,15,224,0,63,255,192,0,0,0,15,224,0,63,254,0,0,0,
  // 0x5b89  安
  137,91,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,213,85,85,85,85,85,127,192,63,192,0,0,0,0,0,63,192,63,192,0,63,128,0,0,63,192,63,192,0,127,192,0,0,63,192,63,192,0,255,64,0,0,63,192,21,64,0,255,0,0,0,21,64,0,0,2,253,0,0,0,0,0,85,85,87,253,85,85,85,85,80,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,63,192,0,3,252,0,0,0,0,255,64,0,7,248,0,0,0,1,255,0,0,11,244,0,0,0,3,253,0,0,15,240,0,0,0,7,252,0,0,47,208,0,0,0,15,248,0,0,127,192,0,0,0,31,255,144,0,255,64,0,0,0,63,255,254,67,254,0,0,0,0,191,175,255,255,252,0,0,0,0,11,1,255,255,240,0,0,0,0,0,0,11,255,254,0,0,0,0,0,0,47,255,255,224,0,0,0,0,6,255,250,255,254,0,0,0,6,191,255,192,47,255,224,0,26,255,255,253,0,2,255,253,0,15,255,255,128,0,0,47,254,0,11,255,228,0,0,0,2,248,0,3,148,0,0,0,0,0,96,0,
  // 0x5b8c  完
  140,91,34,36,68,38,2,252,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,213,85,85,85,85,85,127,192,63,128,0,0,0,0,0,63,192,63,128,0,0,0,0,0,63,192,63,128,0,0,0,0,0,63,192,63,131,255,255,255,255,252,63,192,21,67,255,255,255,255,252,21,64,0,3,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,255,224,85,85,111,229,87,253,85,85,80,0,0,47,208,2,252,0,0,0,0,0,47,192,2,252,0,0,0,0,0,63,192,2,252,0,0,0,0,0,63,128,2,252,0,0,0,0,0,191,64,2,252,0,0,0,0,0,255,0,2,252,0,3,64,0,3,254,0,2,252,0,3,240,0,11,252,0,2,252,0,3,240,0,63,244,0,2,252,0,3,240,2,255,224,0,2,252,0,11,240,191,255,128,0,1,255,255,255,224,255,253,0,0,0,255,255,255,192,127,208,0,0,0,127,255,255,64,57,0,0,0,0,1,85,80,0,
  // 0x5b9a  定
  154,91,35,37,77,38,1,251,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,5,85,85,85,255,85,85,85,80,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,224,0,0,0,0,0,11,240,15,224,0,0,0,0,0,11,240,15,224,0,0,0,0,0,11,240,15,224,0,0,0,0,0,11,240,15,226,255,255,255,255,255,139,240,5,66,255,255,255,255,255,133,80,0,2,255,255,255,255,255,128,0,0,1,85,85,255,85,85,64,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,2,164,0,255,0,0,0,0,0,3,248,0,255,0,0,0,0,0,3,244,0,255,0,0,0,0,0,7,244,0,255,255,255,248,0,0,11,240,0,255,255,255,248,0,0,15,240,0,255,255,255,248,0,0,15,244,0,255,85,85,80,0,0,31,252,0,255,0,0,0,0,0,63,253,0,255,0,0,0,0,0,63,255,0,255,0,0,0,0,0,191,191,192,255,0,0,0,0,0,255,31,244,255,0,0,0,0,3,253,11,255,255,0,0,0,0,11,252,2,255,255,64,0,0,0,47,244,0,191,255,255,255,255,252,127,224,0,11,255,255,255,255,248,47,192,0,0,127,255,255,255,244,11,0,0,0,0,85,85,85,80,0,0,0,0,0,0,0,0,0,
  // 0x5ba2  客
  162,91,35,37,77,38,1,251,0,0,0,0,190,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,208,0,36,0,0,0,11,240,15,208,0,191,128,0,0,11,240,15,208,1,255,0,0,0,11,240,15,208,7,255,255,255,253,11,240,0,0,47,255,255,255,255,0,0,0,0,255,234,170,171,253,0,0,0,7,255,208,0,11,248,0,0,0,127,255,248,0,47,240,0,0,3,255,231,254,0,255,192,0,0,1,255,0,255,215,255,0,0,0,0,180,0,63,255,248,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,127,255,254,64,0,0,0,0,11,255,255,255,249,0,0,0,1,255,255,65,255,255,250,64,1,191,255,248,0,31,255,255,252,127,255,255,64,0,0,191,255,248,63,255,255,255,255,255,255,255,240,31,230,255,255,255,255,255,129,80,4,1,255,255,255,255,255,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,255,255,255,255,255,128,0,0,1,255,255,255,255,255,128,0,0,1,255,255,255,255,255,128,0,0,1,252,0,0,0,63,128,0,0,0,0,0,0,0,0,0,0,
  // 0x5bb9  容
  185,91,35,37,77,38,2,251,0,0,0,2,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,252,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,128,0,0,0,0,0,47,192,63,128,9,0,0,8,0,47,192,63,128,47,208,0,127,64,47,192,63,128,191,192,0,191,240,47,192,0,2,255,0,0,31,253,0,0,0,15,252,1,84,3,255,128,0,0,127,240,11,254,0,191,240,0,7,255,192,31,255,64,31,252,0,15,254,0,63,255,208,3,254,0,3,244,0,255,175,244,0,252,0,1,192,7,255,11,254,0,32,0,0,0,31,252,2,255,128,0,0,0,0,191,240,0,191,240,0,0,0,3,255,128,0,31,254,0,0,0,31,254,0,0,3,255,208,0,0,191,248,0,0,0,255,249,0,11,255,255,255,255,255,255,255,208,191,255,255,255,255,255,255,255,244,191,251,255,255,255,255,254,127,224,63,71,240,0,0,0,254,7,192,24,7,240,0,0,0,254,0,64,0,7,240,0,0,0,254,0,0,0,7,240,0,0,0,254,0,0,0,7,240,0,0,0,254,0,0,0,7,240,0,0,0,254,0,0,0,7,255,255,255,255,254,0,0,0,7,255,255,255,255,254,0,0,0,7,255,255,255,255,254,0,0,0,7,240,0,0,0,254,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5c0d  對
  13,92,36,37,77,38,1,251,0,6,129,164,0,0,0,169,0,10,11,193,244,41,0,0,254,0,63,11,193,244,63,64,0,254,0,31,139,193,244,191,0,0,254,0,15,203,193,244,252,0,0,254,0,7,235,193,246,248,0,0,254,0,3,251,193,251,240,0,0,254,0,2,75,193,244,144,0,0,254,0,127,255,255,255,255,0,0,254,0,127,255,255,255,255,0,0,254,0,127,255,255,255,255,255,255,255,253,0,120,0,15,129,255,255,255,253,0,252,0,31,193,255,255,255,253,0,190,0,47,128,85,85,254,84,0,127,0,63,0,0,0,254,0,0,63,0,127,0,0,0,254,0,0,46,0,125,0,1,0,254,0,15,255,255,255,248,47,0,254,0,15,255,255,255,248,63,128,254,0,15,255,255,255,248,31,192,254,0,0,0,63,0,0,15,224,254,0,0,0,63,0,0,11,240,254,0,0,0,63,0,0,3,244,254,0,3,255,255,255,240,3,248,254,0,3,255,255,255,240,2,252,254,0,3,255,255,255,240,1,144,254,0,0,0,63,0,0,0,0,254,0,0,0,63,0,0,0,0,254,0,0,0,63,0,0,0,0,254,0,0,0,63,107,254,0,0,254,0,1,107,255,255,254,0,0,254,0,63,255,255,255,255,0,0,254,0,63,255,255,250,80,1,85,254,0,63,254,148,0,0,3,255,253,0,20,0,0,0,0,2,255,252,0,0,0,0,0,0,1,255,224,0,0,0,0,0,0,0,0,0,0,
  // 0x5c0f  小
  15,92,36,36,68,38,1,252,0,0,0,0,85,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,4,0,0,255,0,1,128,0,0,15,240,0,255,0,31,208,0,0,15,240,0,255,0,15,240,0,0,31,240,0,255,0,11,244,0,0,31,224,0,255,0,3,252,0,0,63,208,0,255,0,2,254,0,0,63,192,0,255,0,0,255,0,0,127,128,0,255,0,0,255,64,0,191,64,0,255,0,0,127,192,0,255,0,0,255,0,0,63,208,1,254,0,0,255,0,0,47,224,3,253,0,0,255,0,0,15,240,7,252,0,0,255,0,0,15,248,15,244,0,0,255,0,0,7,252,47,240,0,0,255,0,0,3,252,63,208,0,0,255,0,0,2,253,127,192,0,0,255,0,0,1,254,11,0,0,0,255,0,0,0,254,0,0,0,0,255,0,0,0,208,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,63,255,255,0,0,0,0,0,0,31,255,254,0,0,0,0,0,0,15,255,248,0,0,0,0,0,0,6,170,64,0,0,0,0,
  // 0x5c31  就
  49,92,36,36,68,38,1,252,0,0,190,0,0,0,252,0,0,0,0,191,0,0,0,252,8,0,0,0,191,0,0,0,252,191,0,0,0,191,0,0,0,252,63,192,0,0,191,0,0,0,252,31,224,63,255,255,255,252,0,252,11,240,63,255,255,255,252,0,252,3,248,63,255,255,255,252,0,252,1,248,0,0,0,0,0,0,252,0,128,0,0,0,0,0,0,252,0,0,0,0,0,0,3,255,255,255,253,3,255,255,255,211,255,255,255,253,3,255,255,255,211,255,255,255,253,3,255,255,255,209,86,253,85,84,3,240,0,15,208,1,252,0,0,3,240,0,15,208,2,255,208,0,3,240,0,15,208,2,255,208,0,3,240,0,15,208,3,255,208,0,3,255,255,255,208,3,255,208,0,3,255,255,255,208,3,255,208,0,3,255,255,255,208,7,255,208,0,0,0,127,0,0,11,255,208,0,0,0,127,0,0,15,255,208,0,2,228,127,31,128,15,223,208,0,3,244,127,15,192,31,207,208,0,7,240,127,15,208,63,207,208,0,11,240,127,7,240,127,79,208,16,15,208,127,3,240,255,15,208,61,31,192,127,2,249,254,15,208,62,63,192,127,1,247,252,15,208,62,127,64,127,0,75,248,15,208,62,127,0,127,0,31,240,15,224,126,13,0,191,0,127,208,15,255,253,0,63,255,0,255,128,11,255,252,0,47,253,0,126,0,3,255,244,0,31,228,0,8,0,0,85,64,
  // 0x5de5  工
  229,93,34,29,5,38,2,255,10,170,170,170,170,170,170,170,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,170,170,170,171,254,170,170,170,160,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x5dee  差
  238,93,35,36,68,38,1,252,0,0,8,0,0,0,164,0,0,0,0,191,0,0,0,255,0,0,0,0,127,128,0,1,254,0,0,0,0,47,192,0,3,252,0,0,0,0,15,224,0,11,240,0,0,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,63,255,255,255,255,255,253,0,0,63,255,255,255,255,255,253,0,0,63,255,255,255,255,255,253,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,0,0,191,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,253,255,255,255,255,253,0,0,3,252,255,255,255,255,253,0,0,7,248,255,255,255,255,253,0,0,15,240,0,2,252,0,0,0,0,31,224,0,2,252,0,0,0,0,63,208,0,2,252,0,0,0,0,191,192,0,2,252,0,0,0,1,255,0,0,2,252,0,0,0,7,253,0,0,2,252,0,0,0,47,248,191,255,255,255,255,255,240,127,240,191,255,255,255,255,255,240,31,192,191,255,255,255,255,255,240,2,0,0,0,0,0,0,0,0,
  // 0x5df2  已
  242,93,33,33,41,38,3,253,21,85,85,85,85,85,85,0,0,127,255,255,255,255,255,255,64,0,127,255,255,255,255,255,255,64,0,127,255,255,255,255,255,255,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,5,80,0,0,0,0,127,64,0,11,240,0,0,0,0,127,64,0,11,240,0,0,0,0,127,64,0,11,240,0,0,0,0,127,64,0,11,240,0,0,0,0,127,64,0,11,240,0,0,0,0,127,64,0,11,245,85,85,85,85,191,64,0,11,255,255,255,255,255,255,64,0,11,255,255,255,255,255,255,64,0,11,255,255,255,255,255,255,64,0,11,240,0,0,0,0,127,64,0,11,240,0,0,0,0,127,64,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,20,0,11,240,0,0,0,0,0,47,128,11,240,0,0,0,0,0,47,192,11,240,0,0,0,0,0,63,192,11,240,0,0,0,0,0,63,192,11,240,0,0,0,0,0,127,128,7,248,0,0,0,0,0,255,64,3,255,165,85,85,85,107,255,0,3,255,255,255,255,255,255,253,0,0,255,255,255,255,255,255,244,0,0,27,255,255,255,255,255,128,0,
  // 0x5e73  平
  115,94,34,34,50,38,2,252,5,85,85,85,85,85,85,85,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,4,0,0,0,47,0,3,252,0,15,208,0,0,63,128,3,252,0,47,208,0,0,47,192,3,252,0,63,192,0,0,31,208,3,252,0,127,128,0,0,15,240,3,252,0,191,0,0,0,7,240,3,252,0,254,0,0,0,3,248,3,252,2,252,0,0,0,3,252,3,252,3,248,0,0,0,2,228,3,252,3,240,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,170,170,170,171,254,170,170,170,160,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,248,0,0,0,0,
  // 0x5e8a  床
  138,94,36,36,68,38,1,252,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,1,255,255,255,255,255,255,255,252,1,255,255,255,255,255,255,255,252,1,255,255,255,255,255,255,255,252,1,253,85,85,85,85,85,85,84,1,252,0,0,0,84,0,0,0,1,252,0,0,1,252,0,0,0,1,252,0,0,1,252,0,0,0,1,252,0,0,1,252,0,0,0,1,252,0,0,1,252,0,0,0,1,252,0,0,1,252,0,0,0,1,252,63,255,255,255,255,255,252,1,252,63,255,255,255,255,255,252,1,252,63,255,255,255,255,255,252,1,252,21,85,95,255,149,85,84,2,252,0,0,47,255,192,0,0,2,252,0,0,127,255,240,0,0,2,252,0,0,255,255,244,0,0,3,248,0,2,255,255,253,0,0,3,248,0,7,249,252,255,0,0,3,248,0,15,241,252,127,192,0,3,244,0,63,209,252,47,240,0,7,240,0,255,129,252,11,253,0,11,240,3,255,1,252,3,255,64,15,240,31,252,1,252,0,255,224,15,224,191,240,1,252,0,63,253,31,210,255,192,1,252,0,15,253,63,192,254,0,1,252,0,2,244,63,128,56,0,1,252,0,0,96,191,0,0,0,1,252,0,0,0,47,0,0,0,1,252,0,0,0,5,0,0,0,1,252,0,0,0,
  // 0x5ea6  度
  166,94,35,36,68,38,1,252,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,63,192,0,0,0,1,255,255,255,255,255,255,255,252,1,255,255,255,255,255,255,255,252,1,255,255,255,255,255,255,255,252,1,252,0,0,0,0,0,0,0,1,252,0,31,192,0,47,128,0,1,252,0,31,192,0,47,128,0,1,252,0,31,192,0,47,128,0,1,252,255,255,255,255,255,255,248,1,252,255,255,255,255,255,255,248,1,252,255,255,255,255,255,255,244,1,252,0,31,192,0,47,128,0,1,252,0,31,192,0,47,128,0,1,252,0,31,192,0,47,128,0,1,252,0,31,234,170,191,128,0,1,252,0,31,255,255,255,128,0,2,252,0,31,255,255,255,128,0,2,252,0,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,3,248,127,255,255,255,255,248,0,3,244,191,255,255,255,255,255,0,3,244,191,255,255,255,255,253,0,3,244,0,47,64,0,7,252,0,7,240,0,47,224,0,31,240,0,11,240,0,15,248,0,191,192,0,15,224,0,3,255,71,255,0,0,15,208,0,0,191,255,248,0,0,31,192,0,0,47,255,224,0,0,63,192,0,6,255,255,254,64,0,63,64,91,255,255,255,255,254,148,191,2,255,255,249,1,255,255,252,46,0,255,254,64,0,11,255,244,5,0,185,0,0,0,0,6,224,
  // 0x5ee2  廢
  226,94,36,37,77,38,1,251,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,3,255,255,255,255,255,255,255,252,3,255,255,255,255,255,255,255,252,3,255,255,255,255,255,255,255,252,3,244,0,0,0,0,0,0,0,3,244,0,0,0,27,0,64,0,3,244,63,255,253,31,130,244,0,3,244,63,255,253,15,223,240,0,3,244,21,86,252,3,255,128,0,3,244,24,3,244,2,253,2,224,3,244,191,79,224,0,255,31,240,3,244,47,255,192,0,63,255,64,3,244,7,255,0,0,15,252,0,3,244,15,253,80,21,91,255,128,3,245,191,255,240,127,255,255,253,3,255,255,255,240,127,255,219,252,3,247,228,2,240,124,11,192,180,3,241,0,2,240,188,11,193,64,3,240,21,87,240,252,11,194,224,3,240,63,255,247,248,7,231,208,3,240,63,255,251,240,7,255,192,7,240,125,0,2,192,2,255,64,7,240,188,0,1,85,85,84,0,11,224,253,85,83,255,255,255,0,11,224,255,255,243,255,255,253,0,15,209,255,255,240,108,0,252,0,15,193,160,3,240,126,2,248,0,31,192,0,7,224,63,139,240,0,47,128,0,7,224,15,255,192,0,63,128,0,11,208,3,255,64,0,127,0,0,15,208,31,255,228,0,191,0,41,111,198,255,255,255,228,125,0,47,255,143,254,2,255,244,12,0,31,254,7,144,0,27,224,0,0,0,0,0,0,0,0,0,
  // 0x5efa  建
  250,94,36,37,77,38,1,251,0,0,0,0,0,42,0,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,127,255,248,31,255,255,255,255,128,127,255,244,31,255,255,255,255,128,127,255,240,31,255,255,255,255,128,0,15,208,0,0,63,64,63,128,0,31,192,0,0,63,64,63,128,0,63,131,255,255,255,255,255,253,0,127,3,255,255,255,255,255,253,0,254,3,255,255,255,255,255,253,1,252,0,0,0,63,64,63,128,3,248,0,0,0,63,64,63,128,7,255,254,31,255,255,255,255,128,15,255,255,47,255,255,255,255,128,31,255,255,47,255,255,255,255,128,63,128,190,0,0,63,64,0,0,2,0,254,0,0,63,64,0,0,0,0,253,42,170,191,234,170,128,1,64,253,63,255,255,255,255,192,31,193,252,63,255,255,255,255,192,15,193,252,0,0,63,64,0,0,11,211,248,0,0,63,64,0,0,7,243,244,0,0,63,64,0,0,3,251,241,255,255,255,255,255,248,1,255,241,255,255,255,255,255,248,0,255,225,255,255,255,255,255,244,0,127,192,0,0,63,64,0,0,0,63,244,0,0,63,64,0,0,0,255,254,0,0,63,64,0,0,1,255,255,244,0,21,0,0,0,7,252,127,255,250,85,85,85,84,31,244,11,255,255,255,255,255,252,127,224,0,127,255,255,255,255,252,47,128,0,1,111,255,255,255,244,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5f15  引
  21,95,30,37,40,38,3,251,0,0,0,0,0,0,5,64,21,85,85,85,0,0,31,208,63,255,255,255,0,0,31,208,63,255,255,255,0,0,31,208,63,255,255,255,0,0,31,208,0,0,0,127,0,0,31,208,0,0,0,127,0,0,31,208,0,0,0,127,0,0,31,208,0,0,0,127,0,0,31,208,0,0,0,127,0,0,31,208,5,85,85,127,0,0,31,208,15,255,255,255,0,0,31,208,31,255,255,255,0,0,31,208,47,255,255,255,0,0,31,208,47,192,0,0,0,0,31,208,63,128,0,0,0,0,31,208,63,128,0,0,0,0,31,208,63,64,0,0,0,0,31,208,127,85,85,85,0,0,31,208,191,255,255,255,64,0,31,208,191,255,255,255,64,0,31,208,255,255,255,255,0,0,31,208,253,0,0,127,0,0,31,208,109,0,0,191,0,0,31,208,0,0,0,191,0,0,31,208,0,0,0,255,0,0,31,208,0,0,0,255,0,0,31,208,0,0,0,254,0,0,31,208,0,0,0,254,0,0,31,208,0,0,1,253,0,0,31,208,0,0,2,252,0,0,31,208,0,0,3,252,0,0,31,208,2,170,175,248,0,0,31,208,1,255,255,244,0,0,31,208,0,255,255,224,0,0,31,208,0,191,254,64,0,0,31,208,0,0,0,0,0,0,0,0,
  // 0x5f85  待
  133,95,36,36,68,38,1,252,0,0,144,0,0,10,128,0,0,0,1,253,0,0,31,192,0,0,0,3,252,0,0,31,192,0,0,0,15,244,0,0,31,192,0,0,0,63,224,0,0,31,192,0,0,0,255,128,31,255,255,255,255,224,7,255,0,31,255,255,255,255,224,47,252,0,31,255,255,255,255,224,63,224,0,0,0,31,208,0,0,31,128,56,0,0,31,192,0,0,13,0,255,0,0,31,192,0,0,0,1,253,0,0,31,192,0,0,0,3,252,0,0,31,208,0,0,0,15,241,255,255,255,255,255,253,0,47,225,255,255,255,255,255,253,0,191,209,255,255,255,255,255,253,2,255,192,0,0,0,3,244,0,11,255,192,0,0,0,3,244,0,63,255,192,0,0,0,3,244,0,191,239,192,0,0,0,7,248,0,63,79,192,255,255,255,255,255,252,45,15,192,255,255,255,255,255,252,4,15,192,255,255,255,255,255,252,0,15,192,0,0,0,3,244,0,0,15,192,1,240,0,3,244,0,0,15,192,7,248,0,3,244,0,0,15,192,2,253,0,3,244,0,0,15,192,0,255,0,3,244,0,0,15,192,0,127,192,3,244,0,0,15,192,0,47,208,3,244,0,0,15,192,0,15,208,3,244,0,0,15,192,0,10,0,3,244,0,0,15,192,0,0,5,87,244,0,0,15,192,0,0,15,255,244,0,0,15,192,0,0,15,255,240,0,0,15,192,0,0,11,254,64,0,
  // 0x5f8c  後
  140,95,36,37,77,38,1,251,0,1,144,0,0,208,0,0,0,0,3,252,0,2,252,0,0,0,0,11,244,0,7,252,0,0,0,0,47,224,0,15,240,3,128,0,0,191,128,16,63,192,11,244,0,2,255,0,125,191,0,47,240,0,11,252,0,255,253,0,127,192,0,63,240,0,127,248,1,255,0,0,127,192,96,31,253,7,252,0,0,46,0,254,3,255,95,240,0,0,4,2,252,0,255,255,192,184,0,0,7,248,0,63,255,2,253,0,0,15,240,0,15,252,0,255,0,0,63,208,0,15,224,0,63,192,0,191,192,0,63,234,171,255,224,2,255,199,255,255,255,255,255,244,11,255,195,255,255,255,255,255,252,63,255,195,255,255,253,64,1,254,255,255,192,0,7,244,0,0,253,191,95,192,0,15,224,0,0,96,61,31,192,0,63,250,170,168,0,20,31,192,1,255,255,255,255,0,0,31,192,7,255,255,255,253,0,0,31,192,47,252,0,3,252,0,0,31,193,255,255,0,11,244,0,0,31,203,255,127,128,47,224,0,0,31,195,252,31,224,191,192,0,0,31,192,208,11,255,255,0,0,0,31,192,0,2,255,252,0,0,0,31,192,0,0,255,244,0,0,0,31,192,0,31,255,255,64,0,0,31,192,1,255,255,255,248,0,0,31,193,191,255,208,127,255,228,0,31,203,255,253,0,7,255,253,0,31,195,255,144,0,0,111,248,0,31,193,224,0,0,0,1,176,0,0,0,0,0,0,0,0,0,
  // 0x5f91  徑
  145,95,36,36,68,38,1,252,0,1,144,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,11,244,127,255,255,255,255,252,0,47,224,127,255,255,255,255,252,0,191,128,127,255,255,255,255,252,2,254,0,0,0,0,0,0,0,15,252,0,0,144,2,64,9,0,63,224,0,2,252,11,240,31,192,127,128,96,3,244,15,208,63,128,45,0,254,11,240,47,128,191,0,0,2,253,15,192,127,0,253,0,0,7,248,63,128,253,3,248,0,0,15,240,127,2,252,11,240,0,0,63,208,190,3,248,15,224,0,0,255,192,63,65,253,3,244,0,3,255,192,31,192,191,1,252,0,15,255,192,15,224,63,128,191,0,63,255,192,3,244,15,208,63,192,255,239,192,2,252,11,240,15,224,127,31,192,0,253,3,248,11,240,44,31,192,0,164,1,144,2,64,0,31,192,0,0,0,0,0,0,0,31,192,63,255,255,255,255,224,0,31,192,63,255,255,255,255,224,0,31,192,63,255,255,255,255,224,0,31,192,0,0,47,192,0,0,0,31,192,0,0,31,192,0,0,0,31,192,0,0,31,192,0,0,0,31,192,0,0,31,192,0,0,0,31,192,0,0,31,192,0,0,0,31,192,0,0,31,192,0,0,0,31,192,0,0,47,192,0,0,0,31,199,255,255,255,255,255,253,0,31,199,255,255,255,255,255,253,0,31,199,255,255,255,255,255,253,0,31,192,0,0,0,0,0,0,
  // 0x5f9e  從
  158,95,36,36,68,38,1,252,0,1,144,0,41,64,1,164,0,0,3,252,0,63,128,2,248,0,0,11,244,0,63,64,3,248,0,0,47,224,0,127,0,3,244,0,0,127,192,0,191,0,7,240,0,1,255,0,0,254,0,11,240,0,11,252,0,1,253,0,15,224,0,47,240,0,2,255,64,31,240,0,127,192,16,3,255,224,63,252,0,47,0,254,11,255,248,127,255,0,8,1,253,31,227,252,255,191,192,0,3,248,63,192,246,253,47,224,0,15,240,191,128,39,252,11,248,0,47,210,255,0,31,244,3,253,0,127,195,252,0,47,208,0,252,1,255,192,244,0,11,128,0,48,7,255,192,16,0,15,208,0,0,31,255,192,0,0,15,208,0,0,191,255,192,1,64,15,208,0,0,191,159,192,7,240,15,208,0,0,63,31,192,7,240,15,208,0,0,40,31,192,11,240,15,208,0,0,0,31,192,11,240,15,255,255,208,0,31,192,11,224,15,255,255,208,0,31,192,15,224,15,255,255,208,0,31,192,15,240,15,208,0,0,0,31,192,31,244,15,208,0,0,0,31,192,47,252,15,208,0,0,0,31,192,63,254,15,208,0,0,0,31,192,191,127,143,208,0,0,0,31,192,254,47,239,208,0,0,0,31,195,252,15,255,224,0,0,0,31,207,248,2,255,255,255,252,0,31,207,240,0,127,255,255,252,0,31,195,192,0,2,255,255,248,0,31,128,0,0,0,0,0,0,
  // 0x5fa9  復
  169,95,36,36,68,38,1,252,0,0,128,0,100,0,0,0,0,0,3,252,0,255,0,0,0,0,0,11,244,1,254,0,0,0,0,0,47,224,3,252,0,0,0,0,0,127,192,3,255,255,255,255,252,2,255,0,11,255,255,255,255,252,11,252,0,31,255,255,255,255,252,63,240,0,63,192,0,0,0,0,127,192,100,255,64,0,0,0,0,46,0,255,255,255,255,255,255,128,4,2,255,255,255,255,255,255,128,0,7,248,182,249,85,85,127,128,0,15,240,2,244,0,0,47,128,0,63,208,2,248,0,0,63,128,0,255,192,2,255,255,255,255,128,2,255,192,2,255,255,255,255,128,11,255,192,2,244,0,0,47,128,63,255,192,2,244,0,0,47,128,255,239,192,2,255,255,255,255,128,127,31,192,2,255,255,255,255,128,60,31,192,0,87,249,85,85,0,16,31,192,0,15,240,0,0,0,0,31,192,0,47,208,0,0,0,0,31,192,0,191,255,255,254,0,0,31,192,2,255,255,255,255,64,0,31,192,11,255,85,86,254,0,0,31,192,63,255,128,3,252,0,0,31,194,255,159,224,15,244,0,0,31,192,253,7,252,127,208,0,0,31,192,32,1,255,255,64,0,0,31,192,0,0,191,253,0,0,0,31,192,0,31,255,255,224,0,0,31,192,107,255,254,255,255,228,0,31,195,255,255,208,31,255,253,0,31,193,255,248,0,0,191,248,0,31,192,164,0,0,0,1,160,
  // 0x5fae  微
  174,95,36,36,68,38,1,252,0,9,0,3,208,0,26,64,0,0,31,208,3,208,0,31,192,0,0,63,192,3,208,0,47,128,0,0,255,69,67,208,80,63,64,0,2,254,15,131,208,244,63,64,0,7,252,15,131,208,244,63,0,0,31,240,15,131,208,244,127,0,0,127,192,15,131,208,244,190,0,0,127,66,15,131,208,244,255,255,253,61,7,255,131,208,244,255,255,253,4,15,239,131,208,245,255,255,253,0,47,207,255,255,247,248,7,240,0,63,143,255,255,251,252,7,224,0,255,11,255,255,255,252,11,224,2,254,0,0,0,15,252,11,208,7,254,0,0,0,63,253,15,192,15,254,0,0,0,47,126,15,192,63,254,31,255,255,254,63,15,192,255,254,31,255,255,248,47,31,128,190,190,31,255,255,248,31,111,64,60,126,0,252,31,128,31,191,0,16,126,0,252,31,128,15,255,0,0,126,0,252,31,128,15,254,0,0,126,0,252,31,128,7,253,0,0,126,0,248,31,128,3,252,0,0,126,1,248,31,128,3,248,0,0,126,2,244,31,138,7,248,0,0,126,3,244,31,255,15,252,0,0,126,3,240,127,255,47,255,0,0,126,11,224,191,244,127,191,64,0,126,15,208,126,0,255,47,208,0,126,47,192,16,3,252,15,244,0,126,63,64,0,31,244,7,253,0,126,30,0,0,63,208,2,254,0,126,8,0,0,31,0,0,184,0,126,0,0,0,4,0,0,16,
  // 0x5fc3  心
  195,95,36,36,68,38,1,252,0,0,0,32,0,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,1,255,255,64,0,0,0,0,0,0,11,255,244,0,0,0,0,0,0,0,191,254,0,0,0,0,0,0,0,11,255,208,0,0,0,0,0,0,1,255,208,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,2,224,0,0,248,7,240,0,0,15,244,0,0,253,7,240,0,0,7,252,0,1,252,7,240,0,0,2,254,0,1,252,7,240,0,0,0,255,0,2,252,7,240,0,0,0,127,192,3,252,7,240,0,0,0,63,208,3,248,7,240,0,0,0,31,240,7,244,7,240,0,0,0,15,240,11,240,7,240,0,0,0,11,248,15,240,7,240,0,0,0,3,252,31,224,7,240,0,0,16,2,253,63,192,7,240,0,0,46,1,254,127,192,7,240,0,0,47,128,255,255,64,7,240,0,0,63,128,244,47,0,7,240,0,0,63,64,0,0,0,7,240,0,0,63,64,0,0,0,7,240,0,0,127,0,0,0,0,7,248,0,0,255,0,0,0,0,3,255,255,255,254,0,0,0,0,2,255,255,255,252,0,0,0,0,0,191,255,255,240,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6027  性
  39,96,35,36,68,38,1,252,0,47,192,0,0,7,224,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,253,11,240,0,0,0,47,192,1,253,11,240,0,0,0,47,192,1,252,11,240,0,0,0,47,192,2,252,11,240,0,0,0,47,196,3,248,11,240,0,0,9,47,254,3,244,11,240,0,0,15,111,255,7,255,255,255,255,240,31,111,223,139,255,255,255,255,240,31,111,207,207,255,255,255,255,240,47,47,203,239,229,95,245,85,80,47,47,199,255,192,11,240,0,0,63,47,194,127,128,11,240,0,0,62,47,192,191,64,11,240,0,0,125,47,192,255,0,11,240,0,0,189,47,192,29,0,11,240,0,0,188,47,192,0,0,11,240,0,0,4,47,192,0,0,11,240,0,0,0,47,192,7,255,255,255,255,208,0,47,192,7,255,255,255,255,208,0,47,192,7,255,255,255,255,208,0,47,192,1,85,95,245,85,64,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,255,255,255,255,255,252,0,47,192,255,255,255,255,255,252,0,47,192,255,255,255,255,255,252,0,47,192,85,85,85,85,85,84,0,42,128,0,0,0,0,0,0,
  // 0x6062  恢
  98,96,36,36,68,38,1,252,0,47,128,11,208,0,0,0,0,0,47,128,11,208,0,0,0,0,0,47,128,11,208,0,0,0,0,0,47,128,11,208,0,0,0,0,0,47,130,255,255,255,255,255,253,0,47,130,255,255,255,255,255,253,0,47,150,255,255,255,255,255,253,5,47,253,95,229,85,85,85,84,15,47,189,11,208,0,105,0,0,15,47,175,11,208,0,190,0,0,31,47,159,11,208,0,190,0,0,31,47,143,139,208,0,190,0,0,31,47,139,203,208,0,190,0,80,47,47,135,203,211,208,190,0,252,62,47,129,15,211,224,190,1,248,61,47,128,15,211,224,190,2,244,188,47,128,15,211,208,190,3,240,184,47,128,15,199,208,190,7,224,0,47,128,15,203,192,190,11,192,0,47,128,15,207,192,190,15,192,0,47,128,15,207,128,255,31,64,0,47,128,31,223,0,255,27,0,0,47,128,31,129,0,255,0,0,0,47,128,47,128,2,255,128,0,0,47,128,63,64,3,255,192,0,0,47,128,63,64,7,235,208,0,0,47,128,63,0,15,215,240,0,0,47,128,191,0,47,195,244,0,0,47,128,254,0,127,65,252,0,0,47,129,252,0,255,0,255,0,0,47,130,252,3,252,0,127,192,0,47,131,244,31,248,0,47,240,0,47,139,240,191,224,0,15,253,0,47,143,225,255,128,0,3,254,0,47,135,192,190,0,0,0,252,0,47,128,64,32,0,0,0,32,
  // 0x606f  息
  111,96,36,36,68,38,1,252,0,0,0,0,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,2,253,0,0,0,0,0,7,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,240,0,0,0,11,240,0,0,11,240,0,0,0,11,240,0,0,11,250,170,170,170,175,240,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,240,0,0,0,11,240,0,0,11,240,0,0,0,11,240,0,0,11,240,0,0,0,11,240,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,250,170,170,170,175,240,0,0,11,240,0,0,0,11,240,0,0,11,240,0,0,0,11,240,0,0,11,250,170,170,170,175,240,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,0,0,0,144,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,7,254,0,0,0,0,0,120,5,81,255,128,1,240,0,0,191,15,224,63,208,7,252,0,0,254,15,224,15,240,3,255,0,2,252,15,224,7,224,0,255,128,3,252,15,224,2,64,64,63,224,11,244,15,224,0,0,248,15,244,31,240,15,224,0,0,252,7,252,127,208,11,244,0,2,252,2,253,47,128,11,255,255,255,248,0,252,6,0,3,255,255,255,240,0,144,0,0,0,191,255,255,128,0,0,
  // 0x61b6  憶
  182,97,36,36,68,38,1,252,0,47,128,0,0,15,208,0,0,0,47,128,0,0,15,224,0,0,0,47,128,0,0,15,224,0,0,0,47,128,47,255,255,255,255,240,0,47,128,47,255,255,255,255,240,0,47,128,26,191,170,171,254,160,0,47,132,0,63,0,2,248,0,4,47,252,0,47,128,3,240,0,15,47,190,0,15,192,7,224,0,15,47,175,127,255,255,255,255,253,31,47,159,255,255,255,255,255,253,31,47,143,255,255,255,255,255,253,31,47,139,192,0,0,0,0,0,47,47,135,192,0,0,0,0,0,62,47,129,3,255,255,255,255,208,61,47,128,3,255,255,255,255,208,124,47,128,3,240,0,0,15,208,188,47,128,3,240,0,0,15,208,0,47,128,3,255,255,255,255,208,0,47,128,3,255,255,255,255,208,0,47,128,3,240,0,0,15,208,0,47,128,3,240,0,0,15,208,0,47,128,3,255,255,255,255,208,0,47,128,3,255,255,255,255,208,0,47,128,0,0,127,64,0,0,0,47,128,0,0,191,128,0,0,0,47,128,0,0,47,240,4,0,0,47,128,30,75,215,248,62,0,0,47,128,47,139,208,244,127,64,0,47,128,63,75,208,16,47,192,0,47,128,127,11,208,0,79,240,0,47,128,254,11,208,0,247,248,0,47,130,252,11,224,2,245,252,0,47,135,248,11,255,255,244,253,0,47,129,240,7,255,255,240,116,0,47,128,0,1,191,255,128,0,
  // 0x61c9  應
  201,97,35,36,68,38,1,252,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,3,255,255,255,255,255,255,255,252,3,255,255,255,255,255,255,255,252,3,255,255,255,255,255,255,255,252,3,244,0,164,3,144,9,0,0,3,244,1,252,7,240,31,192,0,3,244,3,244,15,224,63,128,0,3,244,11,240,31,208,127,64,0,3,244,15,208,63,255,255,255,240,3,244,63,192,255,255,255,255,240,3,244,255,194,255,64,189,0,0,3,247,255,203,255,255,255,255,192,3,255,255,223,255,255,255,255,192,3,255,239,195,175,64,189,0,0,3,247,143,192,47,64,189,0,0,3,244,15,192,47,255,255,255,192,3,240,15,192,47,255,255,255,192,3,240,15,192,47,64,189,0,0,3,240,15,192,47,64,189,0,0,3,240,15,192,47,255,255,255,244,3,240,15,192,47,255,255,255,244,7,240,15,192,14,85,85,85,80,7,240,0,0,47,208,0,0,0,11,224,0,0,47,248,0,0,0,11,224,0,0,7,255,64,16,0,15,208,31,71,240,191,193,252,0,15,192,47,71,240,31,0,255,0,31,192,63,7,240,0,0,127,128,47,128,190,7,240,0,13,47,208,63,65,253,7,240,0,15,143,240,127,3,252,7,240,0,47,131,248,191,15,240,3,255,255,255,66,252,45,2,208,3,255,255,255,0,244,8,0,0,0,111,255,248,0,0,
  // 0x6210  成
  16,98,36,37,77,38,1,251,0,0,0,0,2,248,9,0,0,0,0,0,0,3,252,63,128,0,0,0,0,0,3,252,127,244,0,0,0,0,0,3,252,11,254,0,0,0,0,0,2,252,1,255,192,0,0,0,0,2,252,0,63,0,0,85,85,85,87,253,85,110,84,1,255,255,255,255,255,255,255,252,1,255,255,255,255,255,255,255,252,1,255,255,255,255,255,255,255,252,1,253,0,0,1,252,0,0,0,1,253,0,0,1,253,0,0,0,1,253,0,0,0,253,0,0,0,1,253,0,0,0,254,0,63,64,1,254,0,0,0,254,0,127,128,1,255,255,255,192,255,0,191,0,1,255,255,255,192,191,0,254,0,1,255,255,255,192,191,1,253,0,1,253,0,47,192,127,3,252,0,1,253,0,47,192,127,75,244,0,1,253,0,47,192,63,143,240,0,1,252,0,47,192,63,239,208,0,1,252,0,47,128,47,255,192,0,2,252,0,47,128,31,255,0,0,2,252,0,63,128,15,254,0,0,3,252,0,63,128,15,252,0,128,3,248,0,127,64,31,244,0,248,3,248,255,255,0,127,248,0,253,7,244,127,255,1,255,252,0,252,11,240,127,248,7,255,255,0,252,15,240,0,0,47,252,255,65,252,47,224,0,1,255,240,127,210,248,63,192,0,11,255,192,47,255,244,127,128,0,7,254,0,15,255,240,47,0,0,1,244,0,2,255,208,6,0,0,0,64,0,0,25,0,0,0,0,0,0,0,0,0,0,
  // 0x6236  戶
  54,98,30,36,32,38,2,252,0,0,0,0,0,0,100,0,0,0,0,0,0,111,254,0,0,0,0,1,111,255,255,128,0,16,22,255,255,255,228,0,0,127,255,255,255,229,0,0,0,127,255,255,148,0,0,0,0,127,233,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,255,255,255,255,255,240,0,127,255,255,255,255,255,240,0,127,255,255,255,255,255,240,0,127,149,85,85,85,91,240,0,127,64,0,0,0,11,240,0,127,64,0,0,0,11,240,0,127,64,0,0,0,11,240,0,127,64,0,0,0,11,240,0,127,0,0,0,0,11,240,0,127,0,0,0,0,11,240,0,191,85,85,85,85,91,240,0,191,255,255,255,255,255,240,0,255,255,255,255,255,255,240,0,255,255,255,255,255,255,240,0,254,0,0,0,0,11,240,1,253,0,0,0,0,11,240,2,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,7,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,63,192,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,0,0,0,0,0,0,0,61,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,
  // 0x6240  所
  64,98,36,36,68,38,1,252,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,31,192,47,255,255,255,240,0,2,255,244,47,255,255,255,241,1,191,255,244,47,255,255,255,242,255,255,254,0,0,0,0,0,2,255,255,144,0,0,0,0,0,2,255,208,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,248,0,0,0,7,255,255,255,194,248,0,0,0,7,255,255,255,194,248,0,0,0,7,255,255,255,194,248,0,0,0,7,240,0,47,194,248,0,0,0,7,240,0,47,194,255,255,255,254,7,240,0,47,195,255,255,255,254,7,240,0,47,195,255,255,255,254,7,240,0,47,195,253,85,255,84,7,240,0,47,195,248,0,191,0,7,255,255,255,195,244,0,191,0,7,255,255,255,195,244,0,191,0,7,255,255,255,195,244,0,191,0,7,240,0,0,7,240,0,191,0,7,240,0,0,7,240,0,191,0,7,240,0,0,11,240,0,191,0,11,240,0,0,15,224,0,191,0,11,224,0,0,15,208,0,191,0,15,224,0,0,47,192,0,191,0,15,208,0,0,63,192,0,191,0,15,192,0,0,127,64,0,191,0,31,192,0,0,255,0,0,191,0,47,192,0,1,254,0,0,191,0,63,64,0,3,252,0,0,191,0,191,0,0,15,244,0,0,191,0,255,0,0,15,240,0,0,191,0,61,0,0,3,192,0,0,191,0,8,0,0,0,64,0,0,190,0,
  // 0x6247  扇
  71,98,34,34,50,38,1,252,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,170,170,170,170,170,170,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,0,0,0,0,127,0,0,191,0,0,0,0,0,127,0,0,191,0,0,0,0,0,127,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,170,170,170,170,170,170,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,191,255,252,127,255,255,128,0,190,191,255,252,127,255,255,128,0,254,106,171,252,42,170,191,128,0,254,5,0,252,2,0,47,128,0,253,63,64,252,31,192,47,128,0,252,31,208,252,11,240,47,128,1,252,11,240,252,3,248,47,128,2,252,3,240,252,0,244,47,128,3,248,0,64,252,0,64,47,128,3,244,0,44,252,0,27,111,128,11,240,6,253,252,2,255,175,128,15,241,191,253,252,127,254,47,128,31,211,255,208,252,255,224,47,128,63,194,249,0,252,126,0,47,128,127,128,128,0,252,16,0,63,128,191,0,0,255,252,0,31,255,128,29,0,0,127,248,0,15,255,0,0,0,0,62,144,0,11,232,0,
  // 0x624b  手
  75,98,34,37,77,38,2,251,0,0,0,0,0,0,27,64,0,0,0,0,0,5,175,255,208,0,0,5,106,191,255,255,255,240,0,7,255,255,255,255,255,249,64,0,3,255,255,255,255,164,0,0,0,3,255,250,151,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,7,255,255,255,255,255,255,255,0,7,255,255,255,255,255,255,255,0,7,255,255,255,255,255,255,255,0,1,85,85,87,253,85,85,85,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,85,87,253,85,85,85,80,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,1,85,91,252,0,0,0,0,0,1,255,255,248,0,0,0,0,0,0,255,255,240,0,0,0,0,0,0,191,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6253  打
  83,98,36,36,68,38,1,252,0,11,224,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,2,170,170,170,170,168,0,11,240,3,255,255,255,255,253,0,11,240,3,255,255,255,255,253,0,11,240,3,255,255,255,255,253,21,95,245,80,0,0,63,192,0,63,255,255,248,0,0,63,192,0,63,255,255,248,0,0,63,192,0,63,255,255,248,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,4,0,0,63,192,0,0,11,246,252,0,0,63,192,0,0,15,255,252,0,0,63,192,0,6,255,255,252,0,0,63,192,0,127,255,255,64,0,0,63,192,0,63,255,240,0,0,0,63,192,0,47,239,240,0,0,0,63,192,0,20,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,15,240,0,0,0,63,192,0,15,255,224,0,11,255,255,192,0,11,255,208,0,3,255,255,128,0,7,255,64,0,3,255,254,0,0,1,64,0,0,1,234,144,0,0,
  // 0x6279  批
  121,98,36,36,68,38,1,252,0,63,64,5,64,0,168,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,21,127,149,15,208,0,253,0,0,127,255,255,15,208,0,253,0,0,127,255,255,15,208,0,253,0,128,127,255,255,15,208,0,253,2,240,0,63,64,15,208,0,253,11,248,0,63,64,15,229,80,253,63,244,0,63,64,15,255,248,254,255,208,0,63,64,15,255,248,255,255,0,0,63,64,15,255,248,255,244,0,0,63,64,15,208,0,255,192,0,0,63,175,15,208,0,254,0,0,0,63,255,15,208,0,253,0,0,27,255,255,15,208,0,253,0,0,191,255,248,15,208,0,253,0,0,127,255,64,15,208,0,253,0,0,62,127,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,64,0,63,64,15,208,0,253,0,184,0,63,64,15,208,0,253,0,190,0,63,64,15,208,20,253,0,189,0,63,64,15,235,252,253,0,253,0,63,70,255,255,252,254,0,252,0,127,75,255,255,228,255,255,252,47,255,3,255,228,0,127,255,248,31,254,3,148,0,0,47,255,224,15,244,0,0,0,0,0,0,0,
  // 0x6296  抖
  150,98,36,36,68,38,1,252,0,15,192,0,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,15,0,3,244,0,0,15,192,0,63,224,3,244,0,0,15,192,0,47,252,3,244,0,0,15,192,0,7,255,67,244,0,21,95,213,64,0,191,195,244,0,63,255,255,240,0,31,67,244,0,63,255,255,240,0,6,3,244,0,63,255,255,240,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,144,0,3,244,0,0,15,192,1,253,0,3,244,0,0,15,192,3,255,192,3,244,0,0,15,192,0,191,248,3,244,0,0,15,192,16,15,254,3,244,0,0,15,235,240,1,252,3,244,0,0,31,255,240,0,52,3,244,0,27,255,255,240,0,0,3,244,0,127,255,254,64,0,0,3,244,0,63,255,208,0,0,0,3,250,252,63,159,192,0,0,1,175,255,253,16,15,192,0,26,255,255,255,254,0,15,192,15,255,255,255,254,144,0,15,192,15,255,255,235,244,0,0,15,192,15,254,144,3,244,0,0,15,192,5,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,31,192,0,0,0,3,244,0,31,255,192,0,0,0,3,244,0,15,255,192,0,0,0,3,244,0,15,254,0,0,0,0,3,244,0,0,0,0,0,0,0,1,80,0,
  // 0x62bd  抽
  189,98,35,37,77,38,1,251,0,31,192,0,0,7,224,0,0,0,31,192,0,0,7,240,0,0,0,31,192,0,0,7,240,0,0,0,31,192,0,0,7,240,0,0,0,31,192,0,0,7,240,0,0,0,31,192,0,0,7,240,0,0,0,31,192,0,0,7,240,0,0,21,111,213,64,0,7,240,0,0,127,255,255,192,0,7,240,0,0,127,255,255,207,255,255,255,255,248,127,255,255,207,255,255,255,255,248,0,31,192,15,255,255,255,255,248,0,31,192,15,229,91,245,87,248,0,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,219,207,208,7,240,3,248,0,31,255,207,208,7,240,3,248,2,255,255,223,255,255,255,255,248,191,255,254,79,255,255,255,255,248,191,255,208,15,255,255,255,255,248,127,255,192,15,229,91,245,87,248,52,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,192,15,229,91,245,87,248,0,31,192,15,255,255,255,255,248,0,31,192,15,255,255,255,255,248,0,47,192,15,255,255,255,255,248,31,255,192,15,208,0,0,3,248,15,255,64,15,208,0,0,3,248,15,249,0,11,208,0,0,1,164,0,0,0,0,0,0,0,0,0,
  // 0x62d4  拔
  212,98,36,37,77,38,1,251,0,31,192,0,7,240,1,0,0,0,31,192,0,7,240,15,128,0,0,31,192,0,7,240,47,244,0,0,31,192,0,7,240,11,255,0,0,31,192,0,7,240,0,255,208,0,31,192,0,7,240,0,47,224,0,31,192,0,7,240,0,7,192,21,111,213,64,7,240,0,1,0,127,255,255,218,175,250,170,170,168,127,255,255,223,255,255,255,255,252,127,255,255,223,255,255,255,255,252,0,31,192,0,11,240,0,0,0,0,31,192,0,11,240,0,0,0,0,31,192,0,15,240,0,0,0,0,31,192,0,15,244,0,42,0,0,31,192,0,15,248,0,63,0,0,31,192,0,15,252,0,127,0,0,31,199,192,15,252,0,191,0,0,31,255,192,31,253,0,254,0,2,255,255,208,47,255,0,253,0,191,255,254,64,63,191,65,252,0,191,255,208,0,63,111,194,252,0,127,255,192,0,127,15,195,244,0,56,31,192,0,191,11,231,240,0,0,31,192,0,254,7,255,240,0,0,31,192,1,252,2,255,208,0,0,31,192,3,252,0,255,192,0,0,31,192,3,244,0,255,128,0,0,31,192,15,240,1,255,208,0,0,31,192,31,224,7,255,244,0,0,31,192,63,192,15,255,253,0,0,31,192,191,64,127,226,255,128,0,47,194,255,2,255,128,191,244,31,255,203,252,15,254,0,31,254,15,255,67,240,7,248,0,3,252,15,249,0,208,1,208,0,0,112,0,0,0,0,0,0,0,0,0,
  // 0x6309  按
  9,99,36,37,77,38,1,251,0,31,192,0,0,15,224,0,0,0,31,192,0,0,15,224,0,0,0,31,192,0,0,15,224,0,0,0,31,192,0,0,15,224,0,0,0,31,192,0,0,15,224,0,0,0,31,192,31,255,255,255,255,252,0,31,192,31,255,255,255,255,252,21,111,213,95,255,255,255,255,252,127,255,255,223,192,0,0,1,252,127,255,255,223,192,16,0,1,252,127,255,255,223,192,127,64,1,252,0,31,192,31,192,191,0,1,252,0,31,192,31,192,255,0,1,252,0,31,192,0,0,253,0,0,0,0,31,192,0,1,252,0,0,0,0,31,192,0,3,252,0,0,0,0,31,192,47,255,255,255,255,253,0,31,198,239,255,255,255,255,253,0,31,255,255,255,255,255,255,253,1,191,255,208,15,208,0,255,0,127,255,255,128,31,192,0,254,0,191,255,208,0,63,128,1,253,0,127,255,192,0,63,64,2,252,0,57,31,192,0,191,0,3,248,0,0,31,192,0,255,128,11,244,0,0,31,192,1,255,249,15,240,0,0,31,192,2,255,255,255,208,0,0,31,192,1,185,255,255,192,0,0,31,192,0,0,31,255,192,0,0,31,192,0,0,11,255,248,0,0,31,192,0,0,127,255,255,64,0,31,192,0,27,255,194,255,224,0,47,192,22,255,254,0,127,252,31,255,192,191,255,224,0,11,252,15,255,64,63,253,0,0,1,244,15,249,0,46,64,0,0,0,96,0,0,0,0,0,0,0,0,0,
  // 0x6389  掉
  137,99,36,37,77,38,1,251,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,255,255,252,0,63,128,0,0,31,255,255,252,0,63,128,0,0,31,255,255,252,0,63,128,0,0,31,192,0,0,21,127,149,0,0,31,192,0,0,127,255,255,64,0,31,192,0,0,127,255,255,95,255,255,255,255,192,127,255,255,95,255,255,255,255,192,0,63,128,31,255,255,255,255,192,0,63,128,31,192,0,0,31,192,0,63,128,31,192,0,0,31,192,0,63,128,31,192,0,0,31,192,0,63,128,31,255,255,255,255,192,0,63,128,31,255,255,255,255,192,0,63,175,95,234,170,170,191,192,0,63,255,159,192,0,0,31,192,6,255,255,159,192,0,0,31,192,127,255,254,31,192,0,0,31,192,127,255,208,31,255,255,255,255,192,63,255,128,31,255,255,255,255,192,36,63,128,31,255,255,255,255,192,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,130,255,255,255,255,255,253,0,63,130,255,255,255,255,255,253,0,63,130,255,255,255,255,255,253,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,127,128,0,0,31,192,0,0,63,255,64,0,0,31,192,0,0,47,255,0,0,0,31,192,0,0,31,248,0,0,0,31,192,0,0,0,0,0,0,0,0,0,0,0,
  // 0x63a2  探
  162,99,36,36,68,38,1,252,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,63,255,255,255,255,248,0,63,64,63,255,255,255,255,248,0,63,64,63,255,255,255,255,248,0,63,64,63,0,0,0,1,248,0,63,64,63,2,160,63,1,248,21,127,149,63,3,240,63,1,248,127,255,255,63,7,240,63,1,248,127,255,255,42,7,240,63,0,0,127,255,255,0,15,224,63,0,80,0,63,64,0,31,208,63,0,125,0,63,64,0,127,192,63,64,189,0,63,64,6,255,0,63,255,252,0,63,64,127,253,0,47,255,248,0,63,64,63,224,0,11,255,224,0,63,91,14,0,15,208,0,0,0,63,255,0,0,15,208,0,0,0,127,255,0,0,15,208,0,0,111,255,255,0,0,15,208,0,0,191,255,224,127,255,255,255,255,252,127,255,64,127,255,255,255,255,252,57,63,64,127,255,255,255,255,252,0,63,64,0,2,255,255,0,0,0,63,64,0,3,255,255,64,0,0,63,64,0,15,255,255,192,0,0,63,64,0,47,223,223,240,0,0,63,64,0,191,143,215,252,0,0,63,64,2,255,15,210,255,0,0,63,64,15,252,15,208,191,192,0,63,64,127,240,15,208,63,244,0,63,67,255,192,15,208,15,254,0,127,67,255,0,15,208,3,252,47,255,0,244,0,15,208,0,180,31,254,0,0,0,15,208,0,0,15,244,0,0,0,15,208,0,0,
  // 0x63a5  接
  165,99,36,37,77,38,1,251,0,31,192,0,0,15,208,0,0,0,31,192,0,0,15,208,0,0,0,31,192,0,0,15,208,0,0,0,31,192,0,0,15,208,0,0,0,31,192,63,255,255,255,255,244,0,31,192,63,255,255,255,255,244,0,31,192,63,255,255,255,255,244,21,111,213,0,63,0,2,252,0,63,255,255,64,63,64,3,248,0,63,255,255,64,47,128,3,240,0,63,255,255,64,31,192,7,240,0,0,31,192,0,15,192,15,208,0,0,31,192,0,15,192,15,192,0,0,31,192,255,255,255,255,255,253,0,31,192,255,255,255,255,255,253,0,31,192,255,255,255,255,255,253,0,31,192,0,0,254,0,0,0,0,31,219,64,2,252,0,0,0,0,47,255,128,3,248,0,0,0,27,255,255,255,255,255,255,255,252,255,255,248,255,255,255,255,255,252,191,255,192,255,255,255,255,255,252,127,111,192,0,63,128,3,252,0,16,31,192,0,127,0,3,244,0,0,31,192,0,254,0,7,240,0,0,31,192,1,253,0,15,240,0,0,31,192,3,255,144,47,208,0,0,31,192,7,255,253,127,192,0,0,31,192,7,255,255,255,64,0,0,31,192,0,81,255,255,0,0,0,31,192,0,0,47,255,224,0,0,31,192,0,6,255,255,254,0,21,111,192,6,191,255,75,255,208,31,255,194,255,255,244,0,191,244,15,255,64,255,254,64,0,15,224,15,249,0,250,64,0,0,1,192,0,0,0,0,0,0,0,0,0,
  // 0x63a7  控
  167,99,36,36,68,38,1,252,0,47,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,191,255,255,255,255,252,0,63,64,191,255,255,255,255,252,0,63,64,191,255,255,255,255,252,21,127,149,190,3,240,63,0,252,127,255,255,190,7,240,63,0,252,127,255,255,190,7,240,63,0,252,127,255,255,190,11,224,63,0,168,0,63,64,0,15,224,63,0,0,0,63,64,0,15,208,63,0,160,0,63,64,0,47,192,63,0,188,0,63,64,0,191,64,63,64,252,0,63,64,7,255,0,63,255,252,0,63,91,127,252,0,47,255,244,0,63,255,63,208,0,11,255,208,1,191,255,29,0,0,0,0,0,47,255,253,0,0,0,0,0,0,191,255,128,0,0,0,0,0,0,127,255,64,15,255,255,255,255,224,57,63,64,15,255,255,255,255,224,0,63,64,15,255,255,255,255,224,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,31,208,0,0,0,127,65,255,255,255,255,255,253,47,255,1,255,255,255,255,255,253,31,254,1,255,255,255,255,255,253,15,244,0,0,0,0,0,0,0,
  // 0x63d0  提
  208,99,36,36,68,38,1,252,0,63,0,0,0,0,0,0,0,0,63,0,6,170,170,170,170,64,0,63,0,7,255,255,255,255,128,0,63,0,7,255,255,255,255,128,0,63,0,7,240,0,0,47,128,0,63,0,7,240,0,0,47,128,0,63,0,7,245,85,85,127,128,21,127,85,7,255,255,255,255,128,127,255,255,7,255,255,255,255,128,127,255,255,7,240,0,0,47,128,127,255,255,7,240,0,0,47,128,0,63,0,7,250,170,170,191,128,0,63,0,7,255,255,255,255,128,0,63,0,7,255,255,255,255,128,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,6,63,255,255,255,255,248,0,63,255,127,255,255,255,255,248,1,191,255,127,255,255,255,255,248,127,255,254,0,0,15,192,0,0,191,255,144,1,80,15,192,0,0,127,255,0,3,244,15,192,0,0,57,63,0,3,240,15,192,0,0,0,63,0,7,240,15,255,255,192,0,63,0,11,224,15,255,255,192,0,63,0,15,240,15,255,255,128,0,63,0,15,244,15,192,0,0,0,63,0,47,252,15,192,0,0,0,63,0,63,191,15,192,0,0,0,63,0,191,47,223,192,0,0,0,63,1,253,15,255,208,0,0,63,255,7,252,3,255,255,255,254,31,255,15,240,0,191,255,255,252,15,248,3,208,0,6,255,255,252,0,0,0,64,0,0,0,0,0,
  // 0x63d2  插
  210,99,35,36,68,38,1,252,0,47,64,0,0,0,0,0,0,0,63,64,0,0,0,1,111,64,0,63,64,0,1,90,255,255,192,0,63,64,47,255,255,255,255,224,0,63,64,31,255,255,255,164,0,0,63,64,15,250,175,208,0,0,0,63,64,0,0,15,208,0,0,21,127,149,0,0,15,208,0,0,127,255,255,0,0,15,208,0,0,127,255,255,191,255,255,255,255,252,127,255,255,191,255,255,255,255,252,0,63,64,191,255,255,255,255,252,0,63,64,0,0,15,208,0,0,0,63,64,0,0,15,208,0,0,0,63,64,0,1,15,208,0,0,0,63,64,0,15,143,208,0,0,0,63,64,57,191,255,215,255,240,0,63,175,63,255,239,215,255,240,0,63,255,63,249,15,215,255,240,11,255,255,63,128,15,208,3,240,191,255,248,63,64,15,208,3,240,191,255,64,63,64,15,208,3,240,127,127,64,63,64,15,208,3,240,16,63,64,63,255,143,211,255,240,0,63,64,63,255,143,211,255,240,0,63,64,63,255,143,211,255,240,0,63,64,63,64,15,208,3,240,0,63,64,63,64,15,208,3,240,0,63,64,63,64,15,208,3,240,0,63,64,63,64,15,208,3,240,0,63,64,63,64,15,208,3,240,0,63,64,63,255,255,255,255,240,0,127,64,63,255,255,255,255,240,47,255,0,63,255,255,255,255,240,31,254,0,63,64,0,0,3,240,15,244,0,47,64,0,0,3,240,
  // 0x63db  換
  219,99,35,37,77,38,1,251,0,47,64,0,15,144,0,0,0,0,63,64,0,31,192,0,0,0,0,63,64,0,63,192,0,0,0,0,63,64,0,127,255,254,0,0,0,63,64,0,255,255,255,128,0,0,63,64,2,255,255,255,64,0,0,63,64,7,244,0,255,0,0,21,127,149,31,224,1,253,0,0,127,255,255,191,192,3,248,0,0,127,255,255,255,255,255,255,255,224,127,255,255,255,255,255,255,255,224,0,63,64,63,255,255,255,255,224,0,63,64,31,129,244,188,7,224,0,63,64,31,129,240,188,7,224,0,63,64,31,131,240,188,7,224,0,63,64,31,135,224,124,7,224,0,63,65,31,143,192,127,255,224,0,63,191,31,255,64,63,255,224,0,127,255,31,173,0,1,91,224,111,255,255,31,128,0,0,7,224,191,255,224,31,128,31,192,7,224,127,255,64,15,128,31,192,6,144,57,63,64,0,0,47,128,0,0,0,63,64,255,255,255,255,255,252,0,63,64,255,255,255,255,255,252,0,63,64,255,255,255,255,255,252,0,63,64,0,0,191,244,0,0,0,63,64,0,0,255,252,0,0,0,63,64,0,2,253,254,0,0,0,63,64,0,11,248,191,128,0,0,63,64,0,47,240,63,224,0,0,63,64,1,255,192,31,253,0,0,127,64,47,255,0,7,255,228,47,255,7,255,248,0,0,255,252,31,254,3,255,128,0,0,31,244,15,244,1,228,0,0,0,0,160,0,0,0,0,0,0,0,0,0,
  // 0x64c7  擇
  199,100,36,37,77,38,1,251,0,63,64,0,0,0,0,0,0,0,63,64,5,85,85,85,85,80,0,63,64,31,255,255,255,255,244,0,63,64,31,255,255,255,255,244,0,63,64,31,129,244,47,2,244,0,63,64,31,129,244,47,2,244,0,63,64,31,129,244,47,2,244,21,127,149,31,214,249,111,151,244,127,255,255,31,255,255,255,255,244,127,255,255,31,255,255,255,255,244,127,255,255,0,0,15,208,0,0,0,63,64,0,0,15,208,0,0,0,63,64,15,255,255,255,255,224,0,63,64,15,255,255,255,255,224,0,63,64,6,170,175,250,170,144,0,63,64,0,0,15,208,0,0,0,63,65,0,0,15,208,0,0,0,63,255,191,255,255,255,255,253,0,127,255,255,255,255,255,255,253,111,255,255,170,255,234,171,255,169,191,255,224,0,63,64,2,252,0,127,255,64,0,47,128,3,244,0,62,127,64,0,31,192,7,240,0,16,63,64,42,175,234,175,250,168,0,63,64,127,255,255,255,255,252,0,63,64,127,255,255,255,255,252,0,63,64,0,0,15,208,0,0,0,63,64,0,0,15,208,0,0,0,63,64,26,170,175,250,170,160,0,63,64,31,255,255,255,255,240,0,63,64,31,255,255,255,255,240,0,63,64,0,0,15,208,0,0,0,127,64,0,0,15,208,0,0,47,255,0,0,0,15,208,0,0,31,254,0,0,0,15,208,0,0,15,244,0,0,0,15,208,0,0,0,0,0,0,0,0,0,0,0,
  // 0x64ca  擊
  202,100,34,36,68,38,2,252,0,3,240,0,0,0,0,0,0,0,3,240,0,2,255,255,208,0,127,255,255,255,194,255,255,208,0,127,255,255,255,194,249,95,208,0,0,3,240,0,2,244,11,208,224,31,255,255,254,3,240,11,225,240,31,87,245,126,11,240,7,255,240,31,87,245,126,63,208,3,255,208,31,255,255,254,47,128,0,105,64,31,3,240,62,14,85,85,84,0,31,255,255,254,31,255,255,255,0,5,87,245,85,31,255,255,253,0,0,3,240,0,1,244,1,252,0,255,255,255,255,192,253,7,240,0,255,255,255,255,192,127,175,192,0,15,67,240,61,0,31,255,0,0,15,67,240,61,6,191,255,128,0,15,255,255,253,63,255,255,254,64,15,255,255,253,31,228,11,255,240,0,0,0,0,26,106,252,111,208,0,255,255,255,255,255,255,0,64,0,255,255,255,254,165,64,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,7,255,255,255,255,255,255,254,0,7,255,255,255,255,255,255,254,0,0,0,0,3,252,0,0,0,0,0,0,0,3,248,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,85,85,85,87,253,85,85,85,80,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,10,171,248,0,0,0,0,0,0,15,255,244,0,0,0,0,0,0,7,255,144,0,0,0,0,
  // 0x64cb  擋
  203,100,35,36,68,38,1,252,0,63,64,0,64,15,192,4,0,0,63,64,7,224,15,192,31,192,0,63,64,3,244,15,192,63,128,0,63,64,2,252,15,192,127,0,0,63,64,0,252,15,192,254,0,0,63,64,0,253,15,192,252,0,0,63,64,63,255,255,255,255,248,21,127,149,63,255,255,255,255,252,127,255,255,127,255,255,255,255,252,127,255,255,127,0,0,0,1,252,127,255,255,127,0,0,0,1,252,0,63,64,63,85,85,85,86,252,0,63,64,63,255,255,255,255,252,0,63,64,0,255,255,255,253,0,0,63,64,0,253,0,0,253,0,0,63,64,0,253,0,0,253,0,0,63,65,0,253,0,0,253,0,0,63,255,0,255,255,255,253,0,0,127,255,0,255,255,255,253,0,47,255,255,0,85,85,85,84,0,191,255,228,0,0,0,0,0,0,127,255,64,10,170,170,170,170,144,61,63,64,15,255,255,255,255,224,0,63,64,15,255,255,255,255,224,0,63,64,15,192,15,192,11,224,0,63,64,15,192,15,192,11,224,0,63,64,15,229,95,229,95,224,0,63,64,15,255,255,255,255,224,0,63,64,15,255,255,255,255,224,0,63,64,15,192,15,192,11,224,0,63,64,15,192,15,192,11,224,0,63,64,15,192,15,192,11,224,0,127,64,15,255,255,255,255,224,47,255,0,15,255,255,255,255,224,31,254,0,15,234,170,170,175,224,15,244,0,15,192,0,0,11,224,
  // 0x64e0  擠
  224,100,36,37,77,38,1,251,0,63,0,0,0,15,192,0,0,0,63,0,0,0,15,192,0,0,0,63,0,0,0,15,192,0,0,0,63,1,255,255,255,255,255,252,0,63,1,255,255,255,255,255,252,0,63,1,255,255,255,255,255,252,0,63,0,0,2,208,30,0,0,21,127,84,0,2,240,63,0,0,127,255,253,0,0,244,61,2,240,127,255,253,255,255,248,190,47,244,127,255,253,255,255,224,119,255,192,0,63,0,95,159,143,135,215,192,0,63,0,31,15,79,135,195,208,0,63,0,47,15,79,135,194,240,0,63,0,62,15,79,135,193,240,0,63,0,125,31,79,135,234,252,0,63,94,249,255,15,159,254,126,0,63,255,240,254,15,143,228,44,2,255,254,128,80,10,64,0,0,127,255,248,7,240,0,0,47,128,191,255,64,7,240,0,0,47,128,127,255,0,7,255,255,255,255,128,56,63,0,7,255,255,255,255,128,0,63,0,7,255,255,255,255,128,0,63,0,7,240,0,0,47,128,0,63,0,7,240,0,0,47,128,0,63,0,11,240,0,0,47,128,0,63,0,11,255,255,255,255,128,0,63,0,15,255,255,255,255,128,0,63,0,15,255,255,255,255,128,0,63,0,47,192,0,0,47,128,0,63,0,63,128,0,0,47,128,0,127,0,191,0,0,0,47,128,63,255,2,254,0,0,0,47,128,31,254,2,252,0,0,0,47,128,15,228,0,112,0,0,0,47,128,0,0,0,0,0,0,0,0,0,
  // 0x6536  收
  54,101,36,36,68,38,1,252,0,0,6,160,0,169,0,0,0,0,0,11,240,0,254,0,0,0,0,0,11,240,1,253,0,0,0,0,0,11,240,2,252,0,0,0,1,80,11,240,3,252,0,0,0,3,240,11,240,3,248,0,0,0,3,240,11,240,11,244,0,0,0,3,240,11,240,15,255,255,255,254,3,240,11,240,31,255,255,255,254,3,240,11,240,47,255,255,255,254,3,240,11,240,63,229,85,111,228,3,240,11,240,191,208,0,47,192,3,240,11,240,255,240,0,63,192,3,240,11,243,255,240,0,63,128,3,240,11,251,255,244,0,127,64,3,240,11,255,247,248,0,191,0,3,240,11,255,226,252,0,254,0,3,240,11,247,192,253,1,253,0,3,240,11,241,64,254,3,252,0,3,240,11,240,0,191,3,248,0,3,240,11,240,0,63,139,240,0,3,240,11,240,0,63,207,240,0,3,240,111,240,0,31,255,208,0,3,255,255,240,0,15,255,192,0,47,255,255,240,0,7,255,64,0,127,255,255,240,0,3,254,0,0,63,253,11,240,0,11,255,0,0,63,64,11,240,0,47,255,192,0,0,0,11,240,0,191,255,240,0,0,0,11,240,2,255,143,252,0,0,0,11,240,31,253,7,255,64,0,0,11,240,191,244,1,255,224,0,0,11,251,255,208,0,127,253,0,0,11,251,255,0,0,31,253,0,0,11,243,248,0,0,2,248,0,0,11,225,128,0,0,0,96,
  // 0x653e  放
  62,101,36,37,77,38,1,251,0,2,248,0,0,30,128,0,0,0,2,252,0,0,47,192,0,0,0,2,252,0,0,63,192,0,0,0,2,252,0,0,63,128,0,0,0,2,252,0,0,63,64,0,0,0,2,252,0,0,127,0,0,0,63,255,255,255,208,191,0,0,0,63,255,255,255,208,255,255,255,253,63,255,255,255,209,255,255,255,253,21,127,85,85,66,255,255,255,253,0,63,0,0,3,253,85,127,212,0,63,0,0,7,252,0,63,128,0,63,0,0,15,252,0,63,64,0,63,0,0,15,253,0,127,0,0,63,255,255,63,254,0,191,0,0,63,255,255,127,255,0,254,0,0,63,255,255,255,191,0,253,0,0,63,64,191,191,63,65,252,0,0,63,0,127,45,47,195,252,0,0,63,0,127,4,31,195,248,0,0,63,0,191,0,15,231,240,0,0,127,0,191,0,11,255,240,0,0,127,0,191,0,7,255,208,0,0,191,0,190,0,3,255,192,0,0,190,0,190,0,1,255,128,0,0,253,0,190,0,0,255,0,0,0,253,0,190,0,2,255,128,0,1,252,0,254,0,7,255,208,0,3,252,0,254,0,31,255,240,0,7,248,0,253,0,127,239,252,0,15,240,0,253,2,255,131,255,0,31,224,0,253,15,254,1,255,208,63,192,2,252,191,248,0,127,252,255,130,255,254,255,224,0,31,253,63,1,255,244,255,0,0,3,244,12,0,255,208,116,0,0,0,160,0,0,0,0,0,0,0,0,0,
  // 0x6557  敗
  87,101,36,36,68,38,1,252,0,0,0,0,0,21,0,0,0,0,0,0,0,0,63,192,0,0,11,255,255,255,0,63,128,0,0,11,255,255,255,0,127,64,0,0,11,255,255,255,0,191,0,0,0,11,240,0,127,0,255,0,0,0,11,240,0,127,0,254,0,0,0,11,240,0,127,2,255,255,255,253,11,240,0,127,3,255,255,255,253,11,255,255,255,7,255,255,255,253,11,255,255,255,11,249,85,127,148,11,250,170,255,15,248,0,127,64,11,240,0,127,47,252,0,127,0,11,240,0,127,127,252,0,191,0,11,240,0,127,255,253,0,255,0,11,240,0,127,255,254,0,254,0,11,255,255,255,253,191,1,253,0,11,255,255,255,248,127,2,252,0,11,250,170,255,32,63,131,252,0,11,240,0,127,0,63,199,248,0,11,240,0,127,0,31,219,240,0,11,240,0,127,0,15,239,240,0,11,240,0,127,0,11,255,208,0,11,255,255,255,0,3,255,192,0,11,255,255,255,0,3,255,64,0,7,255,255,255,0,1,255,0,0,0,16,0,64,0,3,255,128,0,0,191,7,240,0,15,255,208,0,0,255,7,248,0,63,255,244,0,1,253,2,253,0,255,223,253,0,3,252,0,255,7,255,67,255,64,11,244,0,127,175,253,0,255,224,31,224,0,47,255,244,0,63,254,127,192,0,9,255,208,0,15,252,47,64,0,0,126,0,0,2,244,5,0,0,0,36,0,0,0,96,
  // 0x6574  整
  116,101,34,35,59,38,2,253,0,2,244,0,0,14,64,0,0,0,2,244,0,0,31,192,0,0,85,87,249,85,80,63,128,0,0,191,255,255,255,224,63,64,0,0,191,255,255,255,224,191,255,255,240,0,2,244,0,0,255,255,255,240,0,2,248,0,2,255,255,255,240,47,255,255,255,199,252,0,253,0,47,255,255,255,223,253,1,252,0,47,2,244,15,255,255,2,248,0,47,2,244,15,255,127,67,240,0,47,66,248,31,206,31,207,240,0,47,255,255,255,192,11,255,192,0,47,255,255,255,192,3,255,64,0,0,47,255,64,0,2,255,0,0,0,255,255,244,0,31,255,224,0,7,254,250,255,64,191,239,253,0,111,226,244,127,159,255,67,255,224,255,130,244,11,63,248,0,191,240,60,2,244,0,31,128,0,11,208,0,0,80,0,4,0,0,0,64,11,255,255,255,255,255,255,254,0,11,255,255,255,255,255,255,254,0,11,255,255,255,255,255,255,254,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,15,192,3,248,0,0,0,0,0,15,192,3,255,255,255,192,0,0,15,192,3,255,255,255,192,0,0,15,192,3,254,170,170,128,0,0,15,192,3,248,0,0,0,0,0,15,192,3,248,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x6578  數
  120,101,36,36,68,38,1,252,0,0,63,0,0,1,232,0,0,0,0,63,0,0,2,252,0,0,3,255,255,255,248,2,252,0,0,3,255,255,255,248,3,248,0,0,3,245,127,86,248,3,244,0,0,3,240,63,2,248,7,240,0,0,107,240,63,66,254,135,240,0,0,127,255,255,255,255,203,255,255,253,127,255,255,255,255,207,255,255,253,3,240,63,2,248,15,255,255,253,3,245,127,86,248,31,213,95,212,3,255,255,255,248,47,192,15,192,3,255,255,255,248,63,208,31,192,0,0,63,0,0,127,224,31,192,1,85,127,85,84,255,224,47,128,15,255,255,255,254,255,240,63,128,15,255,255,255,255,255,240,63,64,15,192,63,0,191,251,244,127,0,15,192,63,0,190,242,248,191,0,15,255,255,255,253,81,252,254,0,15,255,255,255,253,0,253,253,0,1,86,253,85,84,0,255,252,0,0,3,244,0,0,0,127,248,0,106,175,250,170,170,128,63,240,0,127,255,255,255,255,192,63,240,0,127,255,255,255,255,192,31,208,0,0,63,0,15,192,0,63,240,0,0,191,0,47,192,0,127,244,0,1,255,224,127,64,0,255,252,0,3,255,255,254,0,3,254,255,0,0,97,255,252,0,15,244,191,128,0,0,191,255,64,127,208,63,224,0,111,255,255,226,255,128,31,252,15,255,248,31,247,254,0,7,252,11,255,128,2,209,244,0,1,244,7,144,0,0,0,144,0,0,16,
  // 0x6599  料
  153,101,36,36,68,38,1,252,0,2,160,0,0,0,1,252,0,0,7,240,0,0,0,1,252,0,0,7,240,20,0,0,1,252,0,63,7,240,63,2,208,1,252,0,47,7,240,126,3,252,1,252,0,31,71,240,189,3,255,65,252,0,15,135,240,252,0,191,209,252,0,15,199,240,252,0,31,241,252,0,11,199,241,244,0,3,209,252,0,7,215,242,240,0,0,129,252,0,7,215,243,224,0,0,1,252,0,3,71,241,208,0,0,1,252,0,0,7,240,0,8,0,1,252,0,63,255,255,255,47,64,1,252,0,63,255,255,255,127,240,1,252,0,63,255,255,255,31,253,1,252,0,21,111,245,85,2,255,65,252,0,0,63,248,0,0,127,1,252,0,0,63,253,0,0,29,1,252,0,0,191,255,64,0,0,1,252,0,0,255,255,192,0,0,1,252,0,1,251,251,240,0,0,1,253,188,3,247,243,248,0,0,27,255,253,7,231,241,253,0,111,255,255,254,15,215,240,253,191,255,255,255,228,31,199,240,116,255,255,255,252,0,63,71,240,16,255,249,65,252,0,191,7,240,0,164,0,1,252,0,126,7,240,0,0,0,1,252,0,60,7,240,0,0,0,1,252,0,20,7,240,0,0,0,1,252,0,0,7,240,0,0,0,1,252,0,0,7,240,0,0,0,1,252,0,0,7,240,0,0,0,1,252,0,0,7,240,0,0,0,1,252,0,0,7,240,0,0,0,1,252,0,
  // 0x659c  斜
  156,101,36,36,68,38,1,252,0,0,255,0,0,0,0,127,0,0,2,255,192,0,0,0,127,0,0,3,255,240,0,0,0,127,0,0,11,255,253,0,30,0,127,0,0,31,227,255,64,191,128,127,0,0,63,192,255,208,63,240,127,0,0,191,64,63,240,11,252,127,0,2,254,0,15,252,2,254,127,0,7,252,0,3,240,0,190,191,0,31,240,0,1,208,0,56,127,0,127,255,255,255,128,0,0,127,0,255,255,255,255,128,0,0,127,0,61,255,255,255,128,112,0,127,0,20,0,127,0,1,253,0,127,0,0,0,127,0,2,255,64,127,0,0,0,127,0,0,127,208,127,0,0,0,127,0,0,31,244,127,0,63,255,255,255,248,7,252,127,0,63,255,255,255,248,1,240,127,0,63,255,255,255,248,0,64,127,0,0,0,127,0,0,0,0,127,0,0,0,127,0,0,0,0,127,253,1,144,127,7,64,0,6,255,254,3,248,127,31,192,27,255,255,254,3,240,127,15,199,255,255,255,228,7,240,127,11,227,255,255,255,0,11,224,127,3,243,255,144,127,0,15,208,127,3,246,144,0,127,0,47,192,127,2,252,0,0,127,0,63,64,127,0,252,0,0,127,0,191,0,127,0,244,0,0,127,0,45,0,127,0,0,0,0,127,0,4,0,191,0,0,0,0,127,0,0,63,255,0,0,0,0,127,0,0,63,253,0,0,0,0,127,0,0,47,228,0,0,0,0,127,0,
  // 0x65b0  新
  176,101,36,36,68,38,1,252,0,0,169,0,0,0,0,0,0,0,0,253,0,0,0,0,27,208,0,0,253,0,0,0,6,255,244,0,0,253,0,0,145,191,255,244,47,255,255,255,241,255,255,254,0,47,255,255,255,241,255,254,64,0,47,255,255,255,241,254,64,0,0,0,180,0,57,1,252,0,0,0,1,248,0,127,1,252,0,0,0,0,252,0,189,1,252,0,0,0,0,189,0,252,1,252,0,0,0,0,126,1,248,1,252,0,0,0,0,121,1,180,1,252,0,0,0,63,255,255,255,249,255,255,255,253,63,255,255,255,249,255,255,255,253,63,255,255,255,249,255,255,255,253,0,0,253,0,1,253,85,254,84,0,0,253,0,1,252,0,253,0,0,0,253,0,1,252,0,253,0,63,255,255,255,241,252,0,253,0,63,255,255,255,241,252,0,253,0,63,255,255,255,242,252,0,253,0,0,3,254,0,2,248,0,253,0,0,11,255,64,3,248,0,253,0,0,15,255,224,3,244,0,253,0,0,63,255,252,3,240,0,253,0,0,255,255,255,7,240,0,253,0,2,252,253,127,207,240,0,253,0,11,244,253,31,79,208,0,253,0,47,240,253,10,47,192,0,253,0,191,192,253,0,63,128,0,253,0,63,0,253,0,255,0,0,253,0,12,0,253,2,254,0,0,253,0,0,0,253,3,252,0,0,253,0,0,0,253,0,244,0,0,253,0,0,0,253,0,32,0,0,169,0,
  // 0x65b7  斷
  183,101,34,36,68,38,3,252,0,4,0,16,0,0,0,16,0,164,30,0,60,0,0,1,252,0,252,60,0,184,0,0,31,255,64,252,184,65,241,1,7,255,254,0,254,242,231,211,194,255,255,208,0,254,243,199,203,130,255,248,0,0,252,255,130,255,2,253,0,0,0,252,63,0,253,2,244,0,0,0,252,45,64,125,130,244,0,0,0,252,60,224,178,210,244,0,0,0,252,186,240,246,242,244,0,0,0,255,255,255,255,242,244,0,0,0,254,148,59,148,114,244,0,0,0,252,0,0,0,2,255,255,255,208,255,255,255,255,226,255,255,255,208,255,255,255,255,226,255,255,255,208,254,175,170,190,146,248,7,240,0,252,45,0,124,3,244,7,240,0,252,60,0,244,3,244,7,240,0,253,244,67,226,67,244,7,240,0,255,243,219,199,195,244,7,240,0,252,251,195,239,67,244,7,240,0,252,127,64,254,3,240,7,240,0,252,46,0,124,3,240,7,240,0,252,61,208,182,199,240,7,240,0,252,180,241,241,231,240,7,240,0,255,255,255,255,251,240,7,240,0,255,250,127,233,191,224,7,240,0,252,0,0,0,127,208,7,240,0,252,0,0,0,31,192,7,240,0,255,255,255,255,255,128,7,240,0,255,255,255,255,255,64,7,240,0,255,255,255,255,255,0,7,240,0,252,0,0,0,254,0,7,240,0,252,0,0,0,124,0,7,240,0,84,0,0,0,20,0,7,240,0,
  // 0x65bc  於
  188,101,36,37,77,38,1,251,0,3,248,0,0,2,252,0,0,0,3,248,0,0,3,254,0,0,0,3,248,0,0,7,255,0,0,0,3,248,0,0,11,255,64,0,0,3,248,0,0,15,239,192,0,0,3,248,0,0,47,207,208,0,63,255,255,255,192,63,75,240,0,63,255,255,255,192,191,3,248,0,63,255,255,255,193,254,2,252,0,21,191,85,85,67,252,0,255,0,0,127,0,0,11,244,0,191,128,0,127,0,0,31,240,0,63,208,0,127,0,0,63,208,0,31,244,0,127,0,0,255,128,0,11,253,0,127,0,2,255,0,0,3,253,0,127,255,253,252,2,0,0,252,0,191,255,253,176,15,208,0,52,0,191,255,253,0,47,248,0,0,0,191,0,253,0,7,255,0,0,0,254,0,252,0,1,255,192,0,0,254,0,252,0,0,63,240,0,0,254,0,252,0,0,15,240,0,0,253,0,252,0,0,3,192,0,0,253,0,252,0,0,0,0,0,1,252,0,252,0,0,0,0,0,2,252,1,252,0,128,0,0,0,2,248,1,252,3,249,0,0,0,3,248,1,252,11,255,128,0,0,7,244,1,252,2,255,248,0,0,11,240,2,252,0,47,255,64,0,15,224,2,252,0,7,255,224,0,31,208,3,248,0,0,127,253,0,63,192,7,248,0,0,15,255,64,191,67,255,244,0,0,2,255,128,63,3,255,240,0,0,0,63,0,12,2,255,128,0,0,0,12,0,0,0,0,0,0,0,0,0,0,
  // 0x6607  昇
  7,102,34,34,50,38,2,252,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,253,0,0,0,0,11,240,0,0,253,0,0,0,0,11,240,0,0,254,170,170,170,170,175,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,253,0,0,0,0,11,240,0,0,253,0,0,0,0,11,240,0,0,253,0,0,0,0,11,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,0,1,128,0,0,0,0,0,0,1,191,240,7,244,0,0,0,91,255,255,252,7,244,0,0,15,255,255,255,144,7,244,0,0,11,255,255,208,0,7,244,0,0,7,165,31,192,0,7,244,0,0,0,0,31,192,0,7,244,0,0,0,0,31,192,0,7,244,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,63,128,0,7,244,0,0,0,0,191,64,0,7,244,0,0,0,1,255,0,0,7,244,0,0,0,7,254,0,0,7,244,0,0,0,47,252,0,0,7,244,0,0,2,255,240,0,0,7,244,0,0,31,255,128,0,0,7,244,0,0,11,248,0,0,0,7,244,0,0,3,128,0,0,0,7,244,0,0,
  // 0x660e  明
  14,102,33,36,68,38,3,251,0,0,0,0,85,85,85,85,0,0,0,0,0,255,255,255,255,64,255,255,255,128,255,255,255,255,64,255,255,255,128,255,255,255,255,64,255,255,255,128,253,0,0,63,64,253,0,47,128,253,0,0,63,64,253,0,47,128,253,0,0,63,64,253,0,47,128,253,0,0,63,64,253,0,47,128,253,0,0,63,64,253,0,47,128,253,0,0,63,64,253,0,47,128,255,255,255,255,64,255,255,255,128,255,255,255,255,64,255,255,255,128,255,255,255,255,64,255,255,255,128,253,0,0,127,64,253,0,47,128,253,0,0,63,64,253,0,47,128,253,0,0,63,64,253,0,47,128,252,0,0,63,64,253,0,47,129,252,0,0,63,64,253,0,47,129,252,0,0,63,64,253,0,47,129,255,255,255,255,64,253,0,47,130,255,255,255,255,64,255,255,255,130,255,255,255,255,64,255,255,255,131,248,0,0,127,64,255,255,255,131,244,0,0,63,64,254,85,85,7,240,0,0,63,64,253,0,0,15,240,0,0,63,64,253,0,0,15,208,0,0,63,64,253,0,0,63,192,0,0,63,64,0,0,0,127,128,0,0,63,64,0,0,0,255,64,0,0,63,64,0,0,2,254,0,0,0,63,64,0,0,11,252,0,1,85,191,0,0,0,47,244,0,3,255,255,0,0,0,31,208,0,2,255,254,0,0,0,7,64,0,1,255,228,0,0,0,0,0,0,0,0,0,0,
  // 0x662f  是
  47,102,36,36,68,38,1,251,0,42,170,170,170,170,170,164,0,0,63,255,255,255,255,255,248,0,0,63,255,255,255,255,255,248,0,0,63,128,0,0,0,3,248,0,0,63,128,0,0,0,3,248,0,0,63,128,0,0,0,3,248,0,0,63,255,255,255,255,255,248,0,0,63,255,255,255,255,255,248,0,0,63,213,85,85,85,87,248,0,0,63,128,0,0,0,3,248,0,0,63,128,0,0,0,3,248,0,0,63,255,255,255,255,255,248,0,0,63,255,255,255,255,255,248,0,0,42,170,170,170,170,170,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,0,0,0,0,127,0,0,0,0,0,1,164,0,127,0,0,0,0,0,3,252,0,127,0,0,0,0,0,3,248,0,127,0,0,0,0,0,7,244,0,127,255,255,255,0,0,11,240,0,127,255,255,255,0,0,15,248,0,127,255,255,255,0,0,47,253,0,127,0,0,0,0,0,63,255,0,127,0,0,0,0,0,191,191,208,127,0,0,0,0,1,255,31,248,127,0,0,0,0,7,252,11,255,255,0,0,0,0,31,248,1,255,255,255,255,255,253,127,224,0,47,255,255,255,255,252,47,128,0,1,191,255,255,255,248,10,0,0,0,0,5,85,85,80,0,0,0,0,0,0,0,0,0,
  // 0x6642  時
  66,102,34,36,68,38,3,252,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,255,255,252,0,0,127,64,0,0,255,255,252,0,0,127,64,0,0,255,255,252,63,255,255,255,255,0,252,1,252,63,255,255,255,255,0,252,1,252,63,255,255,255,255,0,252,1,252,0,0,127,64,0,0,252,1,252,0,0,127,64,0,0,252,1,252,0,0,127,64,0,0,252,1,252,0,0,127,64,0,0,252,1,253,255,255,255,255,255,208,252,1,253,255,255,255,255,255,208,255,255,253,255,255,255,255,255,208,255,255,252,0,0,0,31,192,0,255,255,252,0,0,0,31,192,0,252,1,252,0,0,0,31,192,0,252,1,252,0,0,0,31,192,0,252,1,252,255,255,255,255,255,192,252,1,252,255,255,255,255,255,192,252,1,252,255,255,255,255,255,192,252,1,252,0,0,0,31,192,0,252,1,252,0,128,0,31,192,0,252,1,252,11,240,0,31,192,0,255,255,252,11,248,0,31,192,0,255,255,252,3,253,0,31,192,0,255,255,252,0,255,0,31,192,0,253,0,0,0,127,192,31,192,0,252,0,0,0,63,192,31,192,0,252,0,0,0,15,64,31,192,0,252,0,0,0,4,0,31,192,0,0,0,0,0,0,80,47,192,0,0,0,0,0,0,191,255,192,0,0,0,0,0,0,63,255,128,0,0,0,0,0,0,63,249,0,0,
  // 0x66ab  暫
  171,102,34,36,68,38,2,252,0,1,244,0,0,0,0,4,0,0,2,244,0,0,0,6,254,0,0,2,248,0,3,150,255,255,128,191,255,255,255,211,255,255,253,0,191,255,255,255,211,255,250,64,0,0,2,244,0,3,245,0,0,0,47,255,255,255,131,240,0,0,0,47,171,254,175,131,240,0,0,0,47,2,244,15,131,240,0,0,0,47,171,254,175,131,255,255,255,240,47,255,255,255,135,255,255,255,240,47,2,244,15,135,255,255,255,240,47,171,254,191,139,224,11,224,0,47,255,255,255,143,208,11,224,0,0,2,244,0,15,192,11,224,0,0,2,248,0,47,192,11,224,0,255,255,255,255,255,64,11,224,0,255,255,255,255,255,0,11,224,0,0,2,244,2,253,0,11,224,0,0,2,244,0,180,0,11,224,0,0,1,80,0,16,0,1,80,0,0,42,170,170,170,170,170,128,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,128,0,0,0,63,192,0,0,47,128,0,0,0,63,192,0,0,47,213,85,85,85,127,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,128,0,0,0,63,192,0,0,47,128,0,0,0,63,192,0,0,47,128,0,0,0,63,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,128,0,0,0,47,128,0,
  // 0x66f4  更
  244,102,35,34,50,38,2,252,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,0,0,0,2,253,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,253,0,2,252,0,1,252,0,0,253,0,2,252,0,1,252,0,0,253,0,2,252,0,1,252,0,0,255,170,171,255,170,171,252,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,253,0,2,252,0,1,252,0,0,253,0,2,252,0,1,252,0,0,253,0,2,252,0,1,252,0,0,253,0,2,252,0,1,252,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,7,64,7,244,0,0,0,0,0,63,192,15,240,0,0,0,0,0,15,244,31,224,0,0,0,0,0,7,253,127,192,0,0,0,0,0,1,255,255,64,0,0,0,0,0,0,127,255,0,0,0,0,0,0,1,191,255,228,0,0,0,0,0,111,255,255,255,250,84,0,0,111,255,254,27,255,255,255,255,244,191,255,208,0,111,255,255,255,240,63,249,0,0,0,107,255,255,224,9,0,0,0,0,0,0,85,64,
  // 0x6700  最
  0,103,34,35,59,38,2,252,0,21,85,85,85,85,85,64,0,0,63,255,255,255,255,255,208,0,0,63,255,255,255,255,255,208,0,0,63,0,0,0,0,15,208,0,0,63,0,0,0,0,15,208,0,0,63,255,255,255,255,255,208,0,0,63,255,255,255,255,255,208,0,0,63,64,0,0,0,31,208,0,0,63,0,0,0,0,15,208,0,0,63,85,85,85,85,95,208,0,0,63,255,255,255,255,255,208,0,0,63,255,255,255,255,255,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,2,248,0,127,0,0,0,0,0,2,248,0,127,0,0,0,0,0,2,255,255,255,63,255,255,254,0,2,255,255,255,63,255,255,255,0,2,254,170,191,43,250,170,255,0,2,248,0,127,3,240,0,253,0,2,248,0,127,3,244,3,252,0,2,255,255,255,1,252,7,244,0,2,255,255,255,0,255,31,240,0,2,254,170,191,0,63,191,192,0,2,248,0,127,0,47,255,64,0,2,248,0,191,0,15,254,0,0,6,255,255,255,0,47,255,64,0,255,255,255,255,1,255,255,224,0,255,255,255,255,31,255,111,254,64,254,148,0,127,255,248,3,255,240,0,0,0,127,63,128,0,127,208,0,0,0,127,24,0,0,6,128,
  // 0x6709  有
  9,103,34,37,77,38,2,251,0,0,0,164,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,21,85,127,213,85,85,85,85,64,0,0,127,128,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,3,255,255,255,255,255,208,0,0,15,255,255,255,255,255,208,0,0,31,255,255,255,255,255,208,0,0,63,252,0,0,0,31,208,0,0,255,252,0,0,0,15,208,0,3,255,252,0,0,0,15,208,0,15,254,252,0,0,0,15,208,0,63,242,255,255,255,255,255,208,0,255,210,255,255,255,255,255,208,0,255,2,255,255,255,255,255,208,0,60,2,252,0,0,0,15,208,0,0,2,252,0,0,0,15,208,0,0,2,252,0,0,0,15,208,0,0,2,255,255,255,255,255,208,0,0,2,255,255,255,255,255,208,0,0,2,255,255,255,255,255,208,0,0,2,252,0,0,0,15,208,0,0,2,252,0,0,0,15,208,0,0,2,252,0,0,0,15,208,0,0,2,252,0,0,0,15,208,0,0,2,252,0,0,85,111,192,0,0,2,252,0,0,255,255,192,0,0,2,252,0,0,127,255,128,0,0,2,252,0,0,63,249,0,0,0,0,0,0,0,0,0,0,0,
  // 0x677f  板
  127,103,36,36,68,38,1,252,0,7,224,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,11,224,0,21,85,85,85,80,0,11,224,0,255,255,255,255,252,0,11,224,0,255,255,255,255,252,0,11,224,0,255,255,255,255,252,0,11,224,0,254,0,0,0,0,0,11,224,0,254,0,0,0,0,63,255,255,244,254,0,0,0,0,63,255,255,244,254,0,0,0,0,63,255,255,244,254,0,0,0,0,21,95,245,80,254,0,0,0,0,0,31,224,0,255,255,255,255,224,0,47,224,0,255,255,255,255,244,0,63,240,0,255,255,255,255,240,0,63,252,0,255,248,0,11,240,0,191,254,0,255,252,0,15,224,0,255,255,64,254,252,0,31,208,1,255,255,192,253,254,0,47,192,2,251,235,240,253,127,0,63,128,3,235,227,249,252,63,64,127,64,11,219,225,245,252,47,192,255,0,15,203,224,225,252,31,209,254,0,47,139,224,66,252,15,243,252,0,127,11,224,3,248,7,251,248,0,190,11,224,3,244,3,255,240,0,60,11,224,7,240,0,255,208,0,40,11,224,11,240,0,255,192,0,0,11,224,15,224,2,255,224,0,0,11,224,31,208,11,255,248,0,0,11,224,63,192,47,251,254,0,0,11,224,127,129,255,209,255,208,0,11,224,255,11,255,64,127,253,0,11,225,254,15,253,0,31,253,0,11,224,124,7,224,0,2,244,0,11,224,4,2,64,0,0,96,
  // 0x67f1  柱
  241,103,36,36,68,38,1,252,0,3,240,0,0,28,0,0,0,0,3,240,0,0,191,64,0,0,0,3,240,0,0,255,224,0,0,0,3,240,0,0,47,252,0,0,0,3,240,0,0,7,255,0,0,0,3,240,0,0,0,255,192,0,0,3,240,0,0,0,63,128,0,0,3,240,0,85,85,95,85,84,63,255,255,252,255,255,255,255,252,63,255,255,252,255,255,255,255,252,63,255,255,252,255,255,255,255,252,21,95,245,84,0,1,253,0,0,0,15,240,0,0,1,253,0,0,0,15,240,0,0,1,253,0,0,0,47,244,0,0,1,253,0,0,0,63,252,0,0,1,253,0,0,0,63,255,0,0,1,253,0,0,0,191,255,192,0,1,253,0,0,0,255,255,224,0,1,253,0,0,1,251,247,244,63,255,255,255,248,3,243,242,253,63,255,255,255,248,7,227,240,253,63,255,255,255,248,15,211,240,120,21,86,254,85,80,47,195,240,32,0,1,253,0,0,63,67,240,0,0,1,253,0,0,191,3,240,0,0,1,253,0,0,61,3,240,0,0,1,253,0,0,40,3,240,0,0,1,253,0,0,0,3,240,0,0,1,253,0,0,0,3,240,0,0,1,253,0,0,0,3,240,0,0,1,253,0,0,0,3,240,15,255,255,255,255,254,0,3,240,15,255,255,255,255,254,0,3,240,15,255,255,255,255,254,0,3,240,5,85,85,85,85,84,0,2,160,0,0,0,0,0,0,
  // 0x6821  校
  33,104,36,36,68,38,1,252,0,6,144,0,0,2,160,0,0,0,11,224,0,0,3,244,0,0,0,11,224,0,0,3,244,0,0,0,11,224,0,0,3,244,0,0,0,11,224,0,0,3,244,0,0,0,11,224,1,85,87,249,85,84,0,11,224,11,255,255,255,255,252,0,11,224,11,255,255,255,255,252,63,255,250,171,255,255,255,255,252,63,255,255,240,0,0,0,0,0,63,255,255,240,7,128,0,180,0,21,95,229,80,15,240,3,252,0,0,31,224,0,31,208,0,255,0,0,47,224,0,63,192,0,127,192,0,63,240,0,255,64,0,47,224,0,63,248,2,254,0,0,15,244,0,191,253,11,252,0,1,67,252,0,255,255,31,251,192,3,253,253,1,255,255,139,207,224,3,248,248,2,255,239,210,7,240,7,244,64,3,235,231,240,3,248,15,240,0,11,219,226,240,2,252,31,224,0,15,203,224,208,0,254,63,192,0,47,139,224,64,0,191,191,64,0,63,11,224,0,0,63,255,0,0,190,11,224,0,0,31,253,0,0,61,11,224,0,0,15,252,0,0,40,11,224,0,0,47,254,0,0,0,11,224,0,0,191,255,128,0,0,11,224,0,2,255,191,240,0,0,11,224,0,31,253,31,253,0,0,11,224,0,191,244,7,255,208,0,11,224,27,255,192,1,255,253,0,11,224,63,253,0,0,63,252,0,11,224,31,224,0,0,11,244,0,11,208,10,0,0,0,0,160,
  // 0x683c  格
  60,104,36,36,68,38,1,252,0,11,224,0,0,121,0,0,0,0,11,224,0,0,255,0,0,0,0,11,224,0,0,254,0,0,0,0,11,224,0,3,252,0,0,0,0,11,224,0,7,255,255,255,64,0,11,224,0,15,255,255,255,128,0,11,224,0,47,255,255,255,64,0,11,224,0,127,192,0,255,0,63,255,255,245,255,208,1,253,0,63,255,255,251,255,240,3,252,0,63,255,255,255,251,248,7,244,0,21,95,245,127,225,253,31,240,0,0,31,224,15,192,255,63,192,0,0,47,244,3,0,63,255,64,0,0,63,252,0,0,31,254,0,0,0,63,255,0,0,15,253,0,0,0,127,255,128,0,127,255,128,0,0,191,255,208,2,255,255,240,0,0,255,231,240,15,255,47,254,0,1,255,227,240,191,248,7,255,224,3,251,225,219,255,208,0,255,254,7,235,224,255,255,0,0,47,252,15,203,224,127,255,255,255,255,248,31,203,224,47,191,255,255,255,144,63,75,224,0,127,255,255,255,128,191,11,224,0,127,0,0,63,128,125,11,224,0,127,0,0,63,128,56,11,224,0,127,0,0,63,128,16,11,224,0,127,0,0,63,128,0,11,224,0,127,0,0,63,128,0,11,224,0,127,0,0,63,128,0,11,224,0,127,255,255,255,128,0,11,224,0,127,255,255,255,128,0,11,224,0,127,255,255,255,128,0,11,224,0,127,0,0,63,128,0,6,144,0,106,0,0,42,64,
  // 0x689d  條
  157,104,36,36,68,38,1,252,0,1,64,0,0,164,0,0,0,0,3,248,0,0,254,0,0,0,0,3,244,0,1,252,0,0,0,0,11,240,0,3,248,0,0,0,0,15,224,0,11,255,255,255,252,0,31,199,224,31,255,255,255,252,0,63,199,224,63,255,255,255,252,0,127,71,224,255,192,0,255,0,0,191,7,227,255,224,1,253,0,1,255,7,255,255,244,3,248,0,3,255,7,235,226,253,15,240,0,7,255,7,226,128,191,191,192,0,15,255,7,224,0,47,255,64,0,63,255,7,224,0,15,254,0,0,191,255,7,224,1,191,255,224,0,255,191,7,224,31,255,191,255,64,190,127,7,235,255,248,7,255,253,60,127,7,231,255,128,0,127,252,32,127,7,225,244,3,248,1,244,0,127,7,224,0,3,248,0,0,0,127,7,224,0,3,248,0,0,0,127,7,227,255,255,255,255,252,0,127,7,227,255,255,255,255,252,0,127,7,227,255,255,255,255,252,0,127,7,224,0,31,255,0,0,0,127,7,224,0,63,255,192,0,0,127,7,224,0,255,255,224,0,0,127,7,224,3,255,255,248,0,0,127,7,224,15,247,249,253,0,0,127,0,0,127,211,248,191,128,0,127,0,2,255,67,248,63,224,0,127,0,31,253,3,248,15,253,0,127,0,47,244,3,248,3,253,0,127,0,15,192,3,248,0,184,0,127,0,1,0,3,248,0,16,0,126,0,0,0,3,244,0,0,
  // 0x68c4  棄
  196,104,34,36,68,38,2,252,0,0,0,2,248,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,127,255,255,255,255,255,255,255,224,0,0,47,208,0,47,240,0,0,0,0,63,128,0,15,254,0,0,0,0,255,0,5,86,255,208,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,255,64,15,255,170,169,85,80,0,127,0,0,5,64,2,164,0,21,8,0,0,15,192,3,248,0,127,0,0,0,15,192,3,248,0,127,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,106,175,234,171,254,170,255,170,160,0,15,192,3,248,0,127,0,0,0,15,192,3,248,0,127,0,0,0,15,255,255,255,255,255,0,0,0,15,255,255,255,255,255,0,0,0,10,170,171,254,170,170,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,7,255,255,253,0,0,0,0,0,47,243,249,255,144,0,0,0,7,255,131,248,47,253,0,0,0,191,252,3,248,7,255,228,0,111,255,208,3,248,0,127,255,224,255,253,0,3,248,0,7,255,240,63,144,0,3,248,0,0,47,192,20,0,0,3,248,0,0,1,64,
  // 0x69fd  槽
  253,105,36,36,68,38,1,252,0,15,192,0,1,248,31,128,0,0,15,192,0,1,248,31,128,0,0,15,192,0,1,248,31,128,0,0,15,192,63,255,255,255,255,253,0,15,192,63,255,255,255,255,253,0,15,192,63,255,255,255,255,253,0,15,192,0,1,248,31,128,0,0,15,192,0,1,248,31,128,0,21,95,213,15,255,255,255,255,244,63,255,255,207,255,255,255,255,244,63,255,255,207,213,253,111,151,244,63,255,255,207,192,248,31,2,244,0,47,192,15,192,248,31,2,244,0,63,192,15,255,255,255,255,244,0,63,192,15,255,255,255,255,244,0,127,224,15,213,249,111,87,244,0,191,244,15,192,248,31,2,244,0,255,252,15,192,248,31,2,244,1,255,254,15,255,255,255,255,244,3,255,239,79,255,255,255,255,244,3,239,207,197,85,85,85,85,80,11,223,199,192,0,0,0,0,0,15,207,195,1,255,255,255,255,192,47,79,192,1,255,255,255,255,192,63,15,192,1,254,170,170,191,192,190,15,192,1,252,0,0,47,192,60,15,192,1,252,0,0,47,192,40,15,192,1,255,255,255,255,192,0,15,192,1,255,255,255,255,192,0,15,192,1,253,85,85,127,192,0,15,192,1,252,0,0,47,192,0,15,192,1,252,0,0,47,192,0,15,192,1,255,255,255,255,192,0,15,192,1,255,255,255,255,192,0,15,192,1,254,170,170,191,192,0,15,192,1,252,0,0,31,192,
  // 0x6a59  橙
  89,106,36,36,68,38,1,252,0,15,208,0,0,0,25,0,0,0,15,208,11,255,244,126,5,0,0,15,208,15,255,252,63,31,64,0,15,208,15,255,252,63,191,128,0,15,208,0,2,244,47,253,0,0,15,208,4,3,240,15,224,32,0,15,208,15,75,240,15,224,248,0,15,208,47,255,208,7,247,253,63,255,255,219,255,192,3,255,244,63,255,255,209,255,64,1,255,192,63,255,255,208,255,255,255,255,0,21,95,229,66,255,255,255,255,128,0,47,208,11,255,255,255,239,224,0,63,208,47,240,0,0,15,252,0,63,224,255,192,0,0,3,255,0,127,244,255,0,0,0,0,252,0,191,252,61,255,255,255,255,96,0,255,255,0,255,255,255,255,64,1,255,255,128,254,170,170,191,64,2,255,223,208,252,0,0,63,64,3,239,215,240,252,0,0,63,64,11,223,210,192,252,0,0,63,64,15,207,208,64,254,170,170,191,64,47,143,208,0,255,255,255,255,64,127,15,208,0,255,255,255,255,64,190,15,208,0,1,0,1,144,0,60,15,208,0,47,64,2,252,0,40,15,208,0,31,192,3,248,0,0,15,208,0,15,192,7,240,0,0,15,208,0,15,208,11,224,0,0,15,208,0,11,224,15,192,0,0,15,208,0,7,128,11,128,0,0,15,208,127,255,255,255,255,253,0,15,208,127,255,255,255,255,253,0,15,208,127,255,255,255,255,253,0,15,208,0,0,0,0,0,0,
  // 0x6a5f  機
  95,106,36,36,68,38,1,252,0,31,128,0,64,31,128,16,0,0,47,128,2,244,31,128,189,0,0,47,128,3,240,31,128,252,0,0,47,128,7,208,31,129,244,0,0,47,128,15,194,31,131,240,128,0,47,128,127,75,239,175,195,240,0,47,128,255,15,223,255,135,224,0,47,128,191,47,15,239,207,192,63,255,255,95,254,15,199,255,128,63,255,255,71,252,15,193,255,0,63,255,255,66,244,15,192,253,16,0,63,192,3,231,79,192,248,240,0,63,128,11,203,207,195,240,248,0,127,192,31,71,223,199,225,252,0,191,208,191,255,239,255,255,253,0,255,240,255,255,255,255,255,254,0,255,248,255,166,251,233,180,46,1,255,252,0,0,75,208,252,0,2,255,190,0,0,7,224,191,0,3,255,159,64,0,7,224,47,128,7,239,143,255,255,255,255,255,252,11,239,139,191,255,255,255,255,252,15,175,128,191,255,255,255,255,252,47,47,128,7,240,2,244,9,0,63,47,128,7,240,1,248,47,192,189,47,128,11,248,0,252,63,64,124,47,128,11,255,64,252,254,0,56,47,128,15,255,224,191,252,0,16,47,128,31,207,244,127,244,0,0,47,128,47,130,240,63,208,20,0,47,128,127,64,128,255,192,46,0,47,128,255,0,7,255,208,62,0,47,131,253,0,127,251,244,126,0,47,139,248,7,255,131,255,252,0,47,131,224,3,253,0,255,252,0,31,128,128,0,144,0,31,224,
  // 0x6aa2  檢
  162,106,36,37,77,38,1,251,0,15,192,0,0,15,224,0,0,0,15,208,0,0,47,248,0,0,0,15,208,0,0,63,253,0,0,0,15,208,0,0,255,255,64,0,0,15,208,0,3,252,63,192,0,0,15,208,0,11,244,31,240,0,0,15,208,0,47,224,7,253,0,0,15,208,0,191,128,1,255,128,5,95,213,67,254,0,0,127,240,63,255,255,223,255,255,255,255,254,63,255,255,255,239,255,255,247,253,63,255,255,255,79,255,255,240,252,0,31,208,28,0,0,0,0,32,0,47,208,0,0,0,0,0,0,0,63,224,5,85,84,21,85,80,0,63,240,11,255,253,63,255,240,0,191,252,11,255,253,63,255,240,0,255,254,11,192,125,62,2,240,1,255,255,75,192,125,62,2,240,2,255,223,203,192,125,62,2,240,3,239,215,235,192,125,62,2,240,11,207,211,203,255,253,63,255,240,15,207,209,75,255,253,63,255,240,47,143,208,6,170,168,42,170,160,63,15,208,0,25,0,1,164,0,190,15,208,0,63,128,2,248,0,60,15,208,0,63,64,3,244,0,40,15,208,0,127,0,3,240,0,0,15,208,0,255,0,11,244,0,0,15,208,1,255,208,15,253,0,0,15,208,3,255,244,47,255,128,0,15,208,15,242,252,191,191,224,0,15,208,63,208,250,254,15,252,0,15,208,255,128,43,252,2,254,0,15,208,189,0,3,224,0,188,0,15,192,36,0,0,64,0,32,0,0,0,0,0,0,0,0,0,
  // 0x6b62  止
  98,107,34,34,50,38,2,254,0,0,0,0,106,0,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,21,0,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,255,255,255,0,0,63,128,0,127,255,255,255,0,0,63,128,0,127,255,255,255,0,0,63,128,0,127,170,170,170,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,170,191,234,170,191,170,170,170,160,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x6b63  正
  99,107,34,32,32,38,2,253,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,21,85,85,85,255,85,85,85,64,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,255,255,252,0,0,63,128,0,255,255,255,252,0,0,63,128,0,255,255,255,252,0,0,63,128,0,255,85,85,84,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,85,85,85,85,85,85,80,
  // 0x6b65  步
  101,107,34,36,68,38,2,252,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,5,64,2,252,0,0,0,0,0,31,192,2,252,0,0,0,0,0,31,192,2,255,255,255,240,0,0,31,192,2,255,255,255,240,0,0,31,192,2,255,255,255,240,0,0,31,192,2,253,85,85,80,0,0,31,192,2,252,0,0,0,0,0,31,192,2,252,0,0,0,0,0,31,192,2,252,0,0,0,0,85,111,213,87,253,85,85,85,80,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,2,252,0,0,0,0,0,2,144,2,252,0,0,0,0,0,7,252,2,252,0,6,0,0,0,15,244,2,252,0,15,240,0,0,63,224,2,252,0,31,224,0,0,255,192,2,252,0,63,208,0,7,255,0,2,252,0,127,192,0,47,252,0,2,252,0,255,64,0,191,240,0,3,252,2,254,0,0,47,192,7,255,248,11,252,0,0,10,0,3,255,244,47,244,0,0,0,0,2,255,144,191,224,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,47,254,0,0,0,0,0,0,2,255,244,0,0,0,0,0,0,127,255,192,0,0,0,0,0,111,255,253,0,0,0,0,2,191,255,255,208,0,0,0,0,2,255,255,249,0,0,0,0,0,0,255,254,64,0,0,0,0,0,0,185,64,0,0,0,0,0,0,
  // 0x6b78  歸
  120,107,36,36,68,38,1,252,0,10,144,0,0,0,0,0,0,0,15,224,0,6,170,170,170,0,0,15,192,0,15,255,255,255,64,6,175,234,164,15,255,255,255,64,11,255,255,248,0,0,0,63,64,11,255,255,248,0,0,0,63,64,11,208,1,249,255,255,255,255,253,11,208,1,249,255,255,255,255,253,11,229,86,248,170,170,170,191,168,11,255,255,248,0,0,0,63,64,11,255,255,248,5,85,85,127,64,11,208,0,0,15,255,255,255,64,11,234,170,164,15,255,255,255,64,11,255,255,252,0,0,0,0,0,11,255,255,252,170,170,170,170,164,11,208,0,252,255,255,255,255,248,11,208,0,252,255,255,255,255,248,11,234,170,252,252,1,252,1,248,11,255,255,252,252,1,252,1,248,11,255,255,252,188,1,252,1,248,0,3,240,0,0,1,252,0,0,0,3,240,0,47,255,255,255,208,11,195,240,0,47,255,255,255,208,15,195,255,252,47,255,255,255,208,15,195,255,252,47,65,252,11,208,15,195,255,252,47,65,252,11,208,15,195,240,0,47,65,252,11,208,15,195,240,0,47,65,252,11,208,15,195,240,0,47,65,252,11,208,15,195,245,174,47,65,252,11,208,15,219,255,254,47,65,252,255,208,127,255,255,254,47,65,252,255,192,127,255,255,148,31,65,252,105,0,63,249,64,0,0,1,252,0,0,36,0,0,0,0,1,252,0,0,0,0,0,0,0,0,168,0,0,
  // 0x6bbc  殼
  188,107,35,36,68,38,2,252,0,3,240,0,0,0,0,0,0,0,3,240,0,0,0,0,0,0,0,3,240,0,1,255,255,244,0,255,255,255,255,193,255,255,244,0,255,255,255,255,193,255,255,244,0,170,171,250,170,65,248,3,244,0,0,3,240,0,1,248,3,244,0,0,3,240,0,1,248,3,244,0,47,255,255,254,1,248,3,244,0,47,255,255,254,2,248,3,244,180,26,170,170,169,3,244,3,244,188,0,0,0,0,7,240,3,244,188,106,170,170,170,79,240,3,255,248,255,255,255,255,255,208,2,255,244,255,255,255,255,255,192,0,191,224,252,0,0,15,239,0,0,0,0,252,0,0,15,136,0,0,0,0,254,255,255,239,143,255,255,255,64,22,255,255,229,15,255,255,255,128,1,170,170,144,15,255,255,255,64,0,0,0,0,1,180,0,127,0,0,0,0,0,3,248,0,255,0,3,255,255,240,1,252,1,253,0,3,255,255,240,0,253,2,252,0,3,250,175,240,0,191,7,244,0,3,240,7,240,0,63,143,240,0,3,240,7,240,0,31,255,208,0,3,240,7,240,0,15,255,128,0,7,240,7,241,128,7,255,0,0,7,240,7,255,208,31,255,64,0,15,224,47,255,208,191,255,224,0,47,192,63,254,11,255,175,254,0,127,128,47,145,255,253,7,255,224,255,0,4,3,255,224,0,255,244,60,0,0,1,254,0,0,31,208,4,0,0,0,208,0,0,1,128,
  // 0x6bd4  比
  212,107,36,35,59,38,1,253,0,26,128,0,0,168,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,7,128,0,47,192,0,1,253,0,47,208,0,47,192,0,1,253,1,255,244,0,47,255,255,193,253,31,255,208,0,47,255,255,193,254,255,254,0,0,47,255,255,193,255,255,224,0,0,47,229,85,65,255,253,0,0,0,47,192,0,1,255,144,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,160,0,47,192,0,1,253,0,0,190,0,47,192,0,17,253,0,0,190,0,47,192,91,241,253,0,0,254,0,47,239,255,245,253,0,0,253,1,191,255,255,244,253,0,0,253,127,255,255,254,64,255,85,87,252,63,255,254,64,0,255,255,255,248,63,254,64,0,0,127,255,255,240,25,0,0,0,0,11,255,255,128,
  // 0x6c92  沒
  146,108,35,36,68,38,2,252,1,0,0,0,169,0,0,0,0,3,224,0,0,255,0,0,0,0,15,253,0,0,254,0,0,0,0,11,255,192,0,254,0,0,0,0,1,255,240,1,255,255,255,255,0,0,31,240,2,255,255,255,255,0,0,3,192,3,255,255,255,255,0,0,0,64,7,248,0,0,191,0,0,0,0,11,240,0,0,191,0,0,0,0,15,240,0,0,254,0,16,0,0,47,208,0,0,254,0,125,0,0,127,192,0,0,253,0,255,224,0,255,64,0,2,252,0,191,253,3,254,0,15,255,252,0,11,255,15,252,0,11,255,244,0,0,254,7,244,0,7,255,208,0,0,44,0,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,254,0,0,0,0,255,255,255,255,255,0,0,0,0,255,255,255,255,254,0,0,3,128,6,244,0,3,252,0,0,11,224,7,248,0,7,248,0,0,15,240,2,253,0,15,240,0,0,47,208,0,255,0,63,224,0,0,63,192,0,127,192,255,192,0,0,191,64,0,47,247,255,0,0,0,255,0,0,11,255,252,0,0,2,253,0,0,3,255,240,0,0,3,252,0,0,11,255,244,0,0,15,244,0,0,191,255,255,128,0,31,240,0,111,255,247,255,249,0,63,208,31,255,255,64,127,255,244,47,192,15,255,244,0,11,255,240,7,0,11,254,0,0,0,127,192,0,0,2,64,0,0,0,2,128,
  // 0x6d88  消
  136,109,34,37,77,38,2,251,1,0,0,0,0,127,0,0,0,7,192,0,20,0,127,0,9,0,31,248,1,252,0,127,0,31,208,15,255,64,254,0,127,0,63,192,1,255,208,191,64,127,0,63,128,0,63,224,63,192,127,0,191,0,0,11,128,47,208,127,1,254,0,0,1,0,15,240,127,3,252,0,0,0,0,11,224,127,3,244,0,0,0,0,2,0,127,0,96,0,0,0,0,0,0,127,0,0,0,56,0,0,191,255,255,255,255,0,255,128,0,191,255,255,255,255,0,255,244,0,191,255,255,255,255,0,31,254,0,191,85,85,85,191,0,2,255,0,191,0,0,0,127,0,0,125,0,191,0,0,0,127,0,0,24,0,191,0,0,0,127,0,0,0,0,191,255,255,255,255,0,0,0,0,191,255,255,255,255,0,0,0,0,191,255,255,255,255,0,0,7,0,191,0,0,0,127,0,0,15,192,191,0,0,0,127,0,0,15,208,191,0,0,0,127,0,0,47,192,191,0,0,0,127,0,0,63,128,191,255,255,255,255,0,0,191,0,191,255,255,255,255,0,0,254,0,191,255,255,255,255,0,2,253,0,191,0,0,0,127,0,3,252,0,191,0,0,0,127,0,11,244,0,191,0,0,0,127,0,15,240,0,191,0,0,0,127,0,63,208,0,191,0,0,80,191,0,63,192,0,191,0,1,255,255,0,15,64,0,191,0,0,255,254,0,2,0,0,191,0,0,191,228,0,0,0,0,0,0,0,0,0,0,
  // 0x6de1  淡
  225,109,36,35,59,38,1,253,0,0,0,0,0,47,128,0,0,0,224,0,0,0,47,128,0,0,3,254,0,1,0,63,128,4,0,7,255,208,11,240,63,128,31,208,0,191,248,15,208,63,128,63,192,0,15,252,31,192,63,64,127,128,0,1,240,47,128,63,64,255,0,0,0,64,127,64,127,2,252,0,0,0,0,255,0,191,3,244,0,0,0,0,124,0,255,209,224,0,0,0,0,0,2,255,252,0,0,14,0,0,0,7,255,255,128,0,63,208,0,0,31,244,255,248,0,127,253,0,0,191,224,31,255,0,11,255,128,31,255,128,2,255,224,0,255,194,255,253,0,0,63,240,0,31,0,255,208,63,128,11,208,0,0,0,121,0,63,128,1,128,0,0,0,0,0,63,128,0,0,0,0,0,11,144,63,64,15,144,0,2,0,15,208,63,64,31,240,0,3,208,31,192,63,64,63,192,0,11,240,63,128,127,192,127,128,0,15,240,127,64,191,192,255,0,0,47,208,255,0,255,226,253,0,0,63,194,253,1,255,247,248,0,0,191,64,184,3,255,252,160,0,0,255,0,0,11,250,254,0,0,2,254,0,0,31,240,255,64,0,7,252,0,0,191,208,127,224,0,15,244,0,11,255,128,31,253,0,31,240,6,255,253,0,7,255,228,15,208,15,255,240,0,0,255,253,2,192,7,255,64,0,0,31,244,0,0,2,144,0,0,0,0,160,
  // 0x6e05  清
  5,110,36,37,77,38,1,251,0,128,0,0,0,47,128,0,0,2,253,0,0,0,63,128,0,0,7,255,192,106,170,191,234,170,160,0,255,244,255,255,255,255,255,240,0,31,252,255,255,255,255,255,240,0,3,240,0,0,63,128,0,0,0,0,160,0,0,63,128,0,0,0,0,0,63,255,255,255,255,208,0,0,0,63,255,255,255,255,208,0,0,0,21,85,127,213,85,64,0,0,0,0,0,63,128,0,0,14,0,0,0,0,63,128,0,0,63,224,3,255,255,255,255,255,253,127,254,3,255,255,255,255,255,253,11,255,194,170,170,170,170,170,169,0,191,192,0,0,0,0,0,0,0,31,0,6,170,170,170,170,64,0,1,0,11,255,255,255,255,128,0,0,0,11,255,255,255,255,128,0,0,0,11,224,0,0,47,128,0,0,0,11,224,0,0,47,128,0,0,208,11,229,85,85,127,128,0,2,244,11,255,255,255,255,128,0,3,248,11,255,255,255,255,128,0,11,244,11,224,0,0,47,128,0,15,240,11,224,0,0,47,128,0,47,208,11,229,85,85,127,128,0,63,192,11,255,255,255,255,128,0,191,64,11,255,255,255,255,128,0,255,0,11,224,0,0,47,128,2,253,0,11,224,0,0,47,128,7,252,0,11,224,0,0,47,128,15,244,0,11,224,0,0,63,128,15,240,0,11,224,0,127,255,128,3,208,0,11,224,0,63,255,0,0,64,0,11,224,0,47,249,0,0,0,0,0,0,0,0,0,0,
  // 0x6e2c  測
  44,110,34,37,77,38,1,251,0,0,0,0,0,0,0,3,240,2,224,0,0,0,0,0,3,240,7,253,3,255,255,240,0,3,240,11,255,131,255,255,240,0,3,240,0,255,243,255,255,240,125,3,240,0,31,211,240,3,240,190,3,240,0,3,131,240,3,240,190,3,240,0,0,3,240,3,240,190,3,240,0,0,3,240,3,240,190,3,240,0,0,3,255,255,240,190,3,240,0,0,3,255,255,240,190,3,240,14,0,3,255,255,240,190,3,240,47,224,3,240,3,240,190,3,240,127,253,3,240,3,240,190,3,240,11,255,67,240,3,240,190,3,240,0,255,3,240,3,240,190,3,240,0,44,3,255,255,240,190,3,240,0,0,3,255,255,240,190,3,240,0,0,3,255,255,240,190,3,240,0,0,3,240,3,240,190,3,240,0,0,3,240,3,240,190,3,240,0,4,3,240,3,240,190,3,240,0,15,67,240,3,240,190,3,240,0,47,195,255,255,240,190,3,240,0,63,131,255,255,240,190,3,240,0,127,67,255,255,240,189,3,240,0,191,0,0,1,0,0,3,240,0,254,0,248,7,128,0,3,240,2,252,2,252,31,208,0,3,240,3,252,3,248,15,240,0,3,240,7,244,11,240,3,252,0,3,240,15,240,31,224,1,253,0,3,240,31,224,63,192,0,255,5,91,240,47,192,255,64,0,125,31,255,240,7,128,254,0,0,16,15,255,208,0,0,40,0,0,0,11,254,64,0,0,0,0,0,0,0,0,0,
  // 0x6e90  源
  144,110,35,37,77,38,2,251,1,0,0,0,0,0,0,0,0,11,208,0,0,0,0,0,0,0,31,253,3,255,255,255,255,255,240,11,255,131,255,255,255,255,255,240,1,255,211,255,255,255,255,255,240,0,47,131,244,0,11,244,0,0,0,7,3,240,0,11,240,0,0,0,0,3,240,0,15,240,0,0,0,0,3,240,0,15,208,0,0,0,0,3,240,255,255,255,255,192,0,0,3,240,255,255,255,255,192,61,0,3,240,254,170,170,191,192,255,192,3,240,252,0,0,47,192,255,248,7,240,252,0,0,47,192,31,254,7,240,254,85,85,127,192,2,252,7,240,255,255,255,255,192,0,116,7,240,255,255,255,255,192,0,0,7,240,252,0,0,47,192,0,0,7,240,252,0,0,47,192,0,0,11,240,252,0,0,47,192,0,0,11,240,255,255,255,255,192,0,40,15,224,255,255,255,255,192,0,63,15,224,170,175,250,170,64,0,127,15,208,0,11,240,0,0,0,255,15,208,16,11,240,24,0,1,253,31,192,127,11,240,254,0,2,252,47,192,254,11,240,191,0,3,248,63,129,252,11,240,63,192,11,244,63,67,252,11,240,47,208,15,240,191,7,244,11,240,15,240,31,208,255,15,224,11,240,11,244,63,193,253,63,192,11,240,3,248,127,131,252,31,64,11,240,2,224,191,11,244,2,11,255,224,0,0,14,7,240,0,3,255,208,0,0,0,0,80,0,3,254,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6e96  準
  150,110,34,36,68,38,2,252,0,128,0,7,144,7,144,0,0,3,253,0,15,240,11,244,0,0,7,255,208,47,208,15,224,0,0,1,191,240,63,192,47,192,0,0,0,15,192,255,255,255,255,255,64,0,1,66,255,255,255,255,255,64,16,0,11,255,255,255,255,255,64,126,64,31,253,0,63,0,0,0,255,244,127,253,0,63,0,0,0,127,254,255,255,170,191,170,168,0,7,244,254,255,255,255,255,252,0,0,96,40,255,255,255,255,252,0,0,0,0,253,0,63,0,0,0,0,2,128,253,0,63,0,0,0,0,11,208,255,170,191,170,168,0,0,31,224,255,255,255,255,253,0,0,127,192,255,255,255,255,253,0,1,255,0,253,0,63,0,0,0,7,252,0,253,0,63,0,0,0,31,244,0,255,255,255,255,255,208,63,208,0,255,255,255,255,255,208,47,128,0,255,255,255,255,255,208,11,0,0,0,0,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,
  // 0x6eab  溫
  171,110,35,36,68,38,2,252,1,0,0,0,0,0,0,0,0,7,208,0,0,0,0,0,0,0,15,253,0,191,255,255,255,248,0,15,255,128,191,255,255,255,248,0,1,255,224,191,170,170,171,248,0,0,47,192,190,0,104,2,248,0,0,7,64,190,0,248,2,248,0,0,0,0,190,0,244,2,248,0,0,0,0,190,2,248,2,248,0,0,0,0,190,3,254,2,248,0,0,0,0,190,15,223,194,248,0,61,0,0,190,127,7,242,248,0,255,208,0,190,189,1,242,248,0,255,252,0,190,16,0,66,248,0,31,254,0,191,170,170,171,248,0,1,252,0,191,255,255,255,248,0,0,52,0,191,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,255,255,0,0,8,3,255,255,255,255,255,0,0,31,67,255,255,255,255,255,0,0,63,195,240,63,3,224,127,0,0,63,131,240,63,3,224,127,0,0,191,3,240,63,3,224,127,0,0,254,3,240,63,3,224,127,0,2,253,3,240,63,3,224,127,0,3,252,3,240,63,3,224,127,0,11,244,3,240,63,3,224,127,0,15,240,3,240,63,3,224,127,0,47,208,3,244,63,3,224,127,0,63,192,255,255,255,255,255,255,248,191,64,255,255,255,255,255,255,248,31,0,255,255,255,255,255,255,248,1,0,0,0,0,0,0,0,0,
  // 0x6fc0  激
  192,111,35,37,77,38,2,251,0,0,0,14,128,0,248,0,0,11,128,0,31,208,0,253,0,0,31,244,0,47,192,0,252,0,0,31,254,0,63,128,1,252,0,0,2,255,175,255,255,194,252,0,0,0,127,47,255,255,194,248,0,0,0,13,47,170,175,195,244,0,0,0,0,47,0,15,195,255,255,248,0,0,47,0,15,199,255,255,248,0,0,47,255,255,203,255,255,248,0,0,47,255,255,207,224,47,192,61,0,47,149,95,223,224,47,128,255,192,47,0,15,255,224,47,64,255,244,47,0,15,255,240,63,64,31,252,47,255,255,255,240,63,0,2,248,47,255,255,255,240,63,0,0,112,26,191,234,254,244,63,0,0,0,0,31,192,56,248,126,0,0,0,0,31,192,0,252,190,0,0,0,255,255,255,244,188,253,0,0,0,255,255,255,244,125,252,0,0,52,255,255,255,244,63,252,0,0,126,0,252,0,0,63,248,0,0,191,0,252,0,0,47,240,0,0,253,1,255,255,192,15,240,0,2,252,1,255,255,192,15,208,0,3,252,2,255,255,192,31,240,0,7,244,3,244,15,192,63,244,0,11,240,3,240,31,192,191,252,0,15,224,11,240,31,129,254,254,0,47,208,15,208,31,135,252,191,64,63,192,63,192,47,159,244,63,208,127,128,191,64,63,191,224,31,240,191,2,254,31,255,255,192,11,248,14,3,252,15,255,191,0,2,240,0,0,224,10,164,28,0,0,128,0,0,0,0,0,0,0,0,0,
  // 0x7121  無
  33,113,34,36,68,38,2,252,0,3,144,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,127,255,255,255,255,255,255,64,1,255,255,255,255,255,255,255,64,3,255,255,255,255,255,255,255,64,15,255,128,252,7,224,47,192,0,63,255,128,252,7,224,47,192,0,255,255,128,252,7,224,47,192,0,191,47,128,252,7,224,47,192,0,29,47,128,252,7,224,47,192,0,0,47,128,252,7,224,47,192,0,0,47,128,252,7,240,47,192,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,47,128,252,7,224,47,192,0,0,47,128,252,7,224,47,192,0,0,47,128,252,7,224,47,192,0,0,47,128,252,7,224,47,192,0,0,47,128,252,7,224,47,192,0,0,47,128,252,7,240,47,192,0,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,0,0,0,0,0,0,0,0,0,0,144,0,0,0,0,0,160,0,0,254,2,244,2,240,11,244,0,2,252,3,244,3,244,3,252,0,3,248,2,248,2,252,1,255,0,11,240,2,252,1,252,0,191,128,31,224,1,252,0,254,0,63,192,63,192,1,252,0,255,0,31,240,255,64,1,252,0,191,0,15,240,26,0,0,80,0,16,0,7,64,
  // 0x71b1  熱
  177,113,35,37,77,38,2,251,0,2,240,0,0,47,128,0,0,0,3,240,0,0,47,128,0,0,5,87,249,85,0,47,128,0,0,15,255,255,254,0,47,128,0,0,15,255,255,254,0,47,128,0,0,0,3,240,0,31,255,255,248,0,0,3,240,0,31,255,255,248,0,106,171,250,170,95,255,255,248,0,191,255,255,255,223,255,66,248,0,191,255,255,255,192,63,66,248,0,0,188,15,64,0,63,2,248,0,0,252,15,66,0,63,2,248,0,3,248,15,71,206,63,2,248,0,31,240,15,255,239,255,2,248,0,255,192,11,255,111,255,2,248,0,125,3,240,84,3,255,130,248,0,0,3,240,0,0,255,242,248,0,26,171,250,169,0,255,254,248,16,47,255,255,255,1,254,254,248,120,47,255,255,255,3,248,182,248,124,0,3,240,0,3,244,18,248,124,0,3,240,0,11,240,2,248,124,0,3,245,171,159,208,2,248,184,106,255,255,255,255,128,2,255,248,255,255,255,255,255,0,1,255,244,255,255,233,64,189,0,0,127,224,85,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,253,0,0,0,80,2,240,0,2,253,3,244,7,240,11,252,0,3,252,3,244,3,248,3,253,0,11,244,3,248,2,252,0,255,0,31,240,2,252,1,252,0,127,192,63,192,2,252,0,254,0,63,208,191,64,2,252,0,255,0,15,240,9,0,1,148,0,80,0,11,64,0,0,0,0,0,0,0,0,0,
  // 0x71c8  燈
  200,113,36,36,68,38,1,252,0,0,0,0,0,0,96,0,0,0,15,192,0,0,2,244,24,0,0,15,192,15,255,249,248,127,0,0,15,192,15,255,252,253,254,0,0,15,192,10,171,248,191,244,0,0,15,192,0,3,240,63,192,80,0,15,194,135,71,240,47,129,248,0,15,195,255,239,208,15,215,244,10,79,203,231,255,192,11,255,208,15,143,207,193,255,64,3,255,0,15,143,223,64,255,0,1,255,0,15,79,255,3,255,255,255,255,192,15,79,253,15,251,255,255,239,244,31,15,196,127,199,255,255,203,255,47,15,195,255,0,0,0,2,253,63,15,194,252,0,0,0,0,56,125,15,192,210,255,255,255,255,0,124,15,192,2,255,255,255,255,0,0,15,192,2,254,170,170,255,0,0,31,192,2,248,0,0,127,0,0,31,192,2,248,0,0,127,0,0,47,128,2,248,0,0,127,0,0,47,192,2,254,170,170,255,0,0,63,224,2,255,255,255,255,0,0,63,244,2,255,255,255,255,0,0,127,252,0,1,0,2,64,0,0,191,255,0,63,0,3,244,0,0,253,63,128,47,128,7,240,0,1,252,31,208,31,192,11,224,0,3,248,15,224,15,208,15,208,0,11,240,3,128,11,224,31,192,0,15,224,1,0,7,128,27,64,0,63,192,0,255,255,255,255,255,252,127,128,0,255,255,255,255,255,252,30,0,0,255,255,255,255,255,252,4,0,0,0,0,0,0,0,0,
  // 0x7247  片
  71,114,32,37,40,38,2,251,0,0,0,0,7,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,234,170,170,170,170,170,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,0,0,0,0,0,0,0,191,170,170,170,170,168,0,0,191,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,254,0,0,0,3,252,0,1,254,0,0,0,3,252,0,2,253,0,0,0,3,252,0,3,252,0,0,0,3,252,0,7,252,0,0,0,3,252,0,11,244,0,0,0,3,252,0,15,240,0,0,0,3,252,0,47,224,0,0,0,3,252,0,127,192,0,0,0,3,252,0,255,128,0,0,0,3,252,0,255,0,0,0,0,3,252,0,61,0,0,0,0,3,252,0,24,0,0,0,0,3,252,0,0,0,0,0,0,0,0,0,
  // 0x7269  物
  105,114,35,36,68,38,1,252,0,2,244,0,2,144,0,0,0,0,2,248,0,7,240,0,0,0,5,66,248,0,11,240,0,0,0,11,210,248,0,15,224,0,0,0,11,210,248,0,15,192,0,0,0,15,194,248,0,31,192,0,0,0,15,194,248,0,63,213,85,85,84,15,194,248,0,63,255,255,255,252,15,255,255,240,191,255,255,255,252,31,255,255,240,255,255,255,255,252,47,255,255,242,252,15,194,249,252,63,87,249,83,248,31,131,245,252,63,2,248,11,240,63,3,241,252,126,2,248,31,224,63,7,241,252,189,2,248,63,192,190,11,226,252,124,2,248,47,64,252,15,210,248,4,2,248,6,2,252,15,194,248,0,2,248,4,3,244,47,130,248,0,2,254,248,7,240,63,67,248,0,7,255,252,15,208,127,3,244,1,191,255,248,63,192,190,3,244,127,255,254,64,127,64,252,3,244,127,255,248,0,254,2,252,3,240,63,230,248,3,252,3,244,3,240,40,2,248,15,244,11,240,7,240,0,2,248,15,224,15,224,7,240,0,2,248,2,128,47,192,11,240,0,2,248,0,0,127,128,11,224,0,2,248,0,0,255,0,15,224,0,2,248,0,3,253,0,15,208,0,2,248,0,15,248,0,31,192,0,2,248,0,47,240,0,63,192,0,2,248,0,255,192,191,255,128,0,2,248,0,127,0,127,255,0,0,2,248,0,12,0,63,253,0,0,2,248,0,0,0,21,64,0,
  // 0x7387  率
  135,115,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,0,0,0,31,208,0,0,0,0,1,0,0,47,192,0,0,52,0,11,208,0,127,0,64,0,255,0,47,248,5,253,2,244,3,254,0,7,255,31,248,7,240,31,244,0,0,191,239,240,31,208,191,192,0,0,31,67,253,63,128,62,0,0,0,5,0,191,254,0,0,0,0,0,0,0,31,248,96,0,0,0,0,0,144,15,243,244,56,0,0,0,31,224,63,192,253,255,64,0,2,255,240,191,0,191,255,244,0,127,255,191,255,255,255,159,254,0,191,244,63,255,255,255,194,255,192,63,64,63,255,250,159,224,63,208,20,0,0,3,248,3,208,11,64,0,0,0,3,248,1,0,0,0,0,0,0,3,248,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,21,85,85,87,253,85,85,85,80,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,
  // 0x7528  用
  40,117,33,34,50,38,1,252,0,21,85,85,85,85,85,85,64,0,63,255,255,255,255,255,255,192,0,63,255,255,255,255,255,255,192,0,63,255,255,255,255,255,255,192,0,63,64,0,127,0,0,63,192,0,63,64,0,127,0,0,63,192,0,63,64,0,127,0,0,63,192,0,63,64,0,127,0,0,63,192,0,63,64,0,127,0,0,63,192,0,63,85,85,191,85,85,127,192,0,63,255,255,255,255,255,255,192,0,63,255,255,255,255,255,255,192,0,63,255,255,255,255,255,255,192,0,63,64,0,127,0,0,63,192,0,63,64,0,127,0,0,63,192,0,127,0,0,127,0,0,63,192,0,127,0,0,127,0,0,63,192,0,127,0,0,127,0,0,63,192,0,127,0,0,127,0,0,63,192,0,127,255,255,255,255,255,255,192,0,191,255,255,255,255,255,255,192,0,191,255,255,255,255,255,255,192,0,255,85,85,191,85,85,127,192,0,254,0,0,127,0,0,63,192,1,253,0,0,127,0,0,63,192,2,252,0,0,127,0,0,63,192,3,252,0,0,127,0,0,63,192,7,248,0,0,127,0,0,63,192,11,240,0,0,127,0,0,63,192,31,224,0,0,127,0,0,63,128,63,192,0,0,127,3,255,255,128,127,128,0,0,127,2,255,255,64,31,0,0,0,127,1,255,253,0,5,0,0,0,0,0,85,0,0,
  // 0x754c  界
  76,117,34,36,68,38,2,251,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,253,0,3,248,0,7,240,0,0,253,0,3,248,0,7,240,0,0,253,0,3,248,0,7,240,0,0,253,0,3,248,0,7,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,170,171,254,170,175,240,0,0,253,0,3,248,0,7,240,0,0,253,0,3,248,0,7,240,0,0,253,0,3,248,0,7,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,11,248,1,255,0,0,0,0,0,63,240,0,191,192,0,0,0,1,255,192,0,63,244,0,0,0,11,254,0,0,15,254,0,0,0,191,248,0,0,2,255,224,0,27,255,239,192,0,26,255,254,0,255,254,31,192,0,47,223,255,240,127,244,31,192,0,47,193,255,224,47,64,31,192,0,47,192,31,192,0,0,47,192,0,47,192,1,0,0,0,63,192,0,47,192,0,0,0,0,127,128,0,47,192,0,0,0,0,255,64,0,47,192,0,0,0,3,255,0,0,47,192,0,0,0,31,252,0,0,47,192,0,0,1,255,244,0,0,47,192,0,0,3,255,208,0,0,47,192,0,0,1,255,0,0,0,47,192,0,0,0,180,0,0,0,47,192,0,0,0,0,0,0,0,0,0,0,0,
  // 0x767d  白
  125,118,28,36,252,38,5,252,0,0,2,233,0,0,0,0,0,3,254,0,0,0,0,0,3,252,0,0,0,0,0,11,248,0,0,0,0,0,15,244,0,0,0,0,0,15,240,0,0,0,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,170,170,170,170,170,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,85,85,85,85,85,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,170,170,170,170,170,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,190,0,0,0,0,0,170,
  // 0x7684  的
  132,118,33,36,68,38,3,252,0,31,144,0,2,228,0,0,0,0,31,208,0,3,248,0,0,0,0,47,192,0,3,244,0,0,0,0,63,128,0,7,240,0,0,0,0,63,64,0,15,240,0,0,0,0,127,0,0,15,208,0,0,0,191,255,255,240,47,255,255,255,64,191,255,255,240,63,255,255,255,64,191,255,255,240,127,255,255,255,64,190,0,7,240,255,0,0,127,0,189,0,7,241,253,0,0,63,0,189,0,7,243,252,0,0,63,0,189,0,7,251,248,0,0,63,0,189,0,7,255,240,0,0,63,0,189,0,7,247,208,0,0,63,0,189,0,7,240,129,128,0,127,0,190,0,7,240,15,208,0,127,0,191,255,255,240,15,240,0,127,0,191,255,255,240,3,252,0,127,0,191,255,255,240,1,254,0,127,0,189,0,7,240,0,191,64,191,0,189,0,7,240,0,63,192,190,0,189,0,7,240,0,31,224,190,0,189,0,7,240,0,15,240,190,0,189,0,7,240,0,7,192,254,0,189,0,7,240,0,1,0,253,0,189,0,7,240,0,0,0,253,0,189,0,7,240,0,0,0,253,0,190,0,7,240,0,0,1,252,0,191,255,255,240,0,0,1,252,0,191,255,255,240,0,0,3,252,0,191,255,255,240,0,0,7,248,0,189,0,0,0,0,255,255,244,0,189,0,0,0,0,191,255,224,0,189,0,0,0,0,127,255,128,0,0,0,0,0,0,5,80,0,0,
  // 0x76e3  監
  227,118,34,35,59,38,2,253,0,0,0,0,0,26,64,0,0,42,170,170,170,128,63,64,0,0,63,255,255,255,192,63,0,0,0,63,255,255,255,192,127,0,0,0,63,0,252,0,0,190,0,0,0,63,0,252,0,0,253,0,0,0,63,85,253,85,1,255,255,255,224,63,255,255,255,67,255,255,255,224,63,255,255,255,71,255,255,255,224,63,0,0,47,79,224,0,0,0,63,0,0,47,111,192,0,0,0,63,0,0,47,191,128,0,0,0,63,255,255,255,95,0,0,0,0,63,255,255,255,64,0,0,0,0,63,85,253,85,0,0,0,0,0,63,0,252,0,0,255,255,255,128,63,0,252,0,0,255,255,255,128,63,255,255,255,208,255,255,255,128,63,255,255,255,208,0,0,0,0,63,255,255,255,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,253,1,252,3,244,7,240,0,0,253,1,252,3,244,7,240,0,0,253,1,252,3,244,7,240,0,0,253,1,252,3,244,7,240,0,0,253,1,252,3,244,7,240,0,0,253,1,252,3,244,7,240,0,0,253,2,252,3,244,7,244,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x76f4  直
  244,118,34,36,68,38,2,252,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,21,85,85,86,254,85,85,85,64,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,0,3,252,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,26,171,254,170,170,144,0,5,80,31,255,255,255,255,224,0,11,240,31,255,255,255,255,224,0,11,240,31,192,0,0,15,224,0,11,240,31,192,0,0,15,224,0,11,240,31,192,0,0,15,224,0,11,240,31,255,255,255,255,224,0,11,240,31,255,255,255,255,224,0,11,240,31,213,85,85,95,224,0,11,240,31,192,0,0,15,224,0,11,240,31,192,0,0,15,224,0,11,240,31,255,255,255,255,224,0,11,240,31,255,255,255,255,224,0,11,240,31,213,85,85,95,224,0,11,240,31,192,0,0,15,224,0,11,240,31,192,0,0,15,224,0,11,240,31,255,255,255,255,224,0,11,240,31,255,255,255,255,224,0,11,240,26,170,170,170,170,144,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,245,85,85,85,85,85,85,80,11,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,240,11,240,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,
  // 0x7720  眠
  32,119,34,34,50,38,3,252,255,255,252,15,255,255,255,255,0,255,255,252,15,255,255,255,255,0,255,255,252,15,255,255,255,255,0,252,2,252,15,208,0,0,63,0,252,1,252,15,208,0,0,63,0,252,1,252,15,208,0,0,63,0,252,1,252,15,208,0,0,63,0,252,1,252,15,208,0,0,63,0,255,255,252,15,255,255,255,255,0,255,255,252,15,255,255,255,255,0,255,255,252,15,255,255,255,255,0,252,1,252,15,208,11,224,0,0,252,1,252,15,208,11,224,0,0,252,1,252,15,208,11,240,0,0,252,1,252,15,208,7,240,0,0,252,1,252,15,208,7,240,0,0,255,255,252,15,255,255,255,255,208,255,255,252,15,255,255,255,255,208,255,255,252,15,255,255,255,255,208,252,1,252,15,229,87,249,85,64,252,1,252,15,208,3,248,0,0,252,1,252,15,208,2,248,0,0,252,1,252,15,208,2,252,0,0,252,1,252,15,208,1,252,0,0,255,255,252,15,208,0,252,0,0,255,255,252,15,208,0,253,1,64,255,255,252,15,208,0,191,2,224,253,0,0,15,208,0,127,2,240,252,0,0,15,209,191,63,67,240,252,0,0,31,255,255,47,195,240,84,0,7,255,255,255,15,251,224,0,0,7,255,255,228,11,255,208,0,0,3,255,144,0,2,255,192,0,0,1,64,0,0,0,190,0,
  // 0x780d  砍
  13,120,36,36,68,38,1,252,0,0,0,0,6,80,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,63,255,255,254,15,240,0,0,0,63,255,255,254,15,224,0,0,0,63,255,255,254,15,208,0,0,0,0,63,128,0,31,192,0,0,0,0,63,64,0,47,255,255,255,248,0,63,0,0,63,255,255,255,253,0,127,0,0,63,255,255,255,252,0,190,0,0,191,91,245,87,252,0,254,0,0,255,7,240,3,248,0,253,0,0,254,7,240,3,244,0,252,0,2,252,7,240,7,240,2,255,255,247,252,7,240,11,240,3,255,255,255,244,7,240,15,224,7,255,255,255,240,7,240,15,192,11,248,3,246,208,11,240,31,192,15,248,3,240,64,11,240,1,64,47,248,3,240,0,15,244,0,0,63,248,3,240,0,15,248,0,0,191,248,3,240,0,31,252,0,0,191,248,3,240,0,47,252,0,0,61,248,3,240,0,63,190,0,0,5,248,3,240,0,126,63,0,0,1,248,3,240,0,253,63,128,0,1,248,3,240,2,252,31,192,0,1,255,255,240,7,248,15,240,0,1,255,255,240,15,240,7,248,0,1,255,255,240,63,208,3,254,0,1,252,0,0,255,128,0,255,128,1,248,0,7,255,0,0,127,240,1,248,0,63,252,0,0,47,254,0,164,0,63,240,0,0,7,252,0,0,0,15,128,0,0,1,248,0,0,0,5,0,0,0,0,32,
  // 0x78ba  確
  186,120,36,36,68,38,1,252,0,0,0,0,0,2,144,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,7,240,0,0,63,255,255,244,0,11,240,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,63,64,11,255,255,255,255,252,0,63,0,11,208,127,64,0,252,0,127,0,11,208,254,3,160,252,0,127,0,11,209,252,3,240,252,0,190,0,6,147,248,11,224,168,0,253,0,0,11,240,15,192,0,0,252,0,0,31,255,255,255,244,1,252,0,0,127,255,255,255,244,2,255,255,225,255,255,255,255,244,3,255,255,231,255,64,63,0,0,7,255,255,255,255,64,63,0,0,11,248,7,255,255,64,63,0,0,15,248,7,231,191,64,63,0,0,31,248,7,224,63,255,255,255,224,63,248,7,224,63,255,255,255,224,191,248,7,224,63,234,191,170,144,255,248,7,224,63,64,63,0,0,126,248,7,224,63,64,63,0,0,61,248,7,224,63,64,63,0,0,17,248,7,224,63,255,255,255,224,1,248,7,224,63,255,255,255,224,1,248,7,224,63,234,191,170,144,1,255,255,224,63,64,63,0,0,1,255,255,224,63,64,63,0,0,1,255,255,224,63,64,63,0,0,1,248,0,0,63,255,255,255,253,1,248,0,0,63,255,255,255,253,1,248,0,0,63,255,255,255,253,0,0,0,0,63,64,0,0,0,0,0,0,0,47,64,0,0,0,
  // 0x79fb  移
  251,121,35,36,68,38,1,252,0,0,0,64,0,7,224,0,0,0,0,111,208,0,15,240,0,0,0,111,255,244,0,63,192,0,0,63,255,255,208,0,255,255,255,128,63,255,244,0,2,255,255,255,208,47,151,240,0,15,255,255,255,192,0,3,240,0,127,224,0,127,128,0,3,240,2,255,208,0,255,0,0,3,240,15,255,248,2,253,0,0,3,240,11,247,254,7,252,0,0,3,240,3,192,191,223,240,0,63,255,255,248,0,47,255,192,0,63,255,255,248,0,11,255,64,0,63,255,255,248,0,47,253,0,0,21,95,245,80,2,255,240,0,0,0,15,240,0,127,255,255,0,0,0,47,248,7,255,245,254,0,0,0,63,254,2,255,67,252,0,0,0,191,255,128,224,15,255,255,248,0,255,255,224,0,63,255,255,252,2,251,247,248,0,255,255,255,252,3,247,241,252,7,254,0,7,244,11,211,240,240,47,248,0,15,240,31,195,240,18,255,253,0,47,208,63,131,240,7,255,255,192,127,192,191,3,240,1,244,127,240,255,64,125,3,240,0,128,11,255,253,0,60,3,240,0,0,2,255,248,0,16,3,240,0,0,0,255,224,0,0,3,240,0,0,7,255,128,0,0,3,240,0,0,127,253,0,0,0,3,240,0,27,255,240,0,0,0,3,240,11,255,255,64,0,0,0,3,240,15,255,244,0,0,0,0,3,240,7,254,64,0,0,0,0,3,240,2,144,0,0,0,0,
  // 0x7a4d  積
  77,122,36,36,68,38,1,252,0,0,0,0,0,7,240,0,0,0,0,111,192,0,7,240,0,0,0,111,255,243,255,255,255,255,244,63,255,255,231,255,255,255,255,244,63,255,249,1,85,91,245,85,80,47,239,240,0,0,7,240,0,0,0,11,240,1,255,255,255,255,224,0,11,240,1,255,255,255,255,224,0,11,240,0,0,7,244,0,0,0,11,240,0,0,7,240,0,0,0,11,240,31,255,255,255,255,253,63,255,255,255,255,255,255,255,253,63,255,255,245,85,85,85,85,84,63,255,255,240,0,0,0,0,0,0,15,240,0,255,255,255,255,208,0,31,240,0,255,255,255,255,208,0,47,244,0,254,85,85,95,208,0,63,253,0,253,0,0,15,208,0,191,255,64,253,0,0,15,208,0,255,255,192,255,255,255,255,208,1,255,251,240,255,255,255,255,208,3,251,243,248,253,0,0,15,208,11,235,241,240,253,0,0,15,208,15,203,240,128,255,255,255,255,208,63,139,240,0,255,255,255,255,208,191,11,240,0,253,0,0,15,208,190,11,240,0,253,0,0,15,208,60,11,240,0,255,255,255,255,208,36,11,240,0,255,255,255,255,208,0,11,240,0,21,213,85,213,64,0,11,240,0,7,244,3,244,0,0,11,240,0,127,248,7,255,0,0,11,240,7,255,208,0,191,224,0,11,240,191,254,0,0,31,252,0,11,240,63,224,0,0,3,252,0,7,240,14,0,0,0,0,144,
  // 0x7aef  端
  239,122,36,36,68,38,1,252,0,5,0,0,0,7,240,0,0,0,31,128,0,0,7,240,0,0,0,31,128,3,240,7,240,7,240,0,31,128,3,240,7,240,7,240,0,31,128,3,240,7,240,7,240,0,31,128,3,240,7,240,7,240,0,31,128,3,240,7,240,7,240,0,47,128,3,240,7,240,7,240,63,255,255,195,255,255,255,255,240,63,255,255,195,255,255,255,255,240,63,255,255,195,255,255,255,255,240,0,0,0,0,0,0,0,0,0,6,64,58,0,0,0,0,0,0,15,128,63,0,0,0,0,0,0,15,128,63,47,255,255,255,255,253,15,192,127,47,255,255,255,255,253,11,192,126,47,255,255,255,255,253,11,192,189,0,0,15,240,0,0,7,208,189,0,0,15,224,0,0,7,224,252,0,0,31,192,0,0,3,224,252,11,255,255,255,255,248,3,224,248,11,255,255,255,255,248,3,241,244,11,255,255,255,255,248,3,226,244,11,224,188,15,130,248,1,2,240,91,224,188,15,130,248,0,2,255,235,224,188,15,130,248,1,191,255,251,224,188,15,130,248,127,255,255,235,224,188,15,130,248,127,255,248,11,224,188,15,130,248,127,249,0,11,224,188,15,130,248,57,0,0,11,224,188,15,130,248,0,0,0,11,224,188,15,130,248,0,0,0,11,224,188,15,130,248,0,0,0,11,224,188,15,191,248,0,0,0,11,224,188,15,159,240,0,0,0,6,144,20,0,14,128,
  // 0x7b49  等
  73,123,35,36,68,38,1,252,0,14,64,0,0,126,0,0,0,0,47,192,0,0,255,0,0,0,0,63,128,0,0,254,0,0,0,0,255,255,255,227,255,255,255,252,1,255,255,255,231,255,255,255,252,3,255,255,255,255,255,255,255,252,15,244,253,0,63,208,255,0,0,63,224,191,0,255,128,63,128,0,127,192,63,64,191,0,47,192,0,31,0,57,0,255,0,15,64,0,0,0,0,0,255,0,0,0,0,0,127,255,255,255,255,255,254,0,0,127,255,255,255,255,255,254,0,0,127,255,255,255,255,255,254,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,0,0,61,0,0,1,253,0,0,0,0,255,64,0,1,253,0,0,0,0,255,208,0,1,253,0,0,0,0,47,244,0,1,253,0,0,0,0,11,252,0,1,253,0,0,0,0,2,255,0,1,253,0,0,0,0,0,254,5,6,253,0,0,0,0,0,52,15,255,252,0,0,0,0,0,0,11,255,248,0,0,0,0,0,0,3,255,144,0,0,
  // 0x7ba1  管
  161,123,35,36,68,38,2,252,0,121,0,0,1,228,0,0,0,0,255,0,0,3,252,0,0,0,1,253,0,0,7,248,0,0,0,3,255,255,255,79,255,255,255,244,11,255,255,255,127,255,255,255,244,31,255,255,255,255,255,255,255,244,63,195,248,2,255,2,253,0,0,255,66,252,7,252,0,255,0,0,190,0,253,3,248,0,127,64,0,24,0,160,3,248,0,41,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,64,0,0,0,0,0,15,192,63,64,0,0,0,0,0,15,192,63,71,255,255,255,255,254,15,192,63,71,255,255,255,255,254,15,192,26,7,250,170,170,170,254,10,128,0,7,240,0,0,0,254,0,0,0,7,240,0,0,0,254,0,0,0,7,250,170,170,170,254,0,0,0,7,255,255,255,255,254,0,0,0,7,255,255,255,255,254,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,250,170,170,170,170,160,0,0,7,255,255,255,255,255,240,0,0,7,255,255,255,255,255,240,0,0,7,240,0,0,0,7,240,0,0,7,240,0,0,0,7,240,0,0,7,240,0,0,0,7,240,0,0,7,255,255,255,255,255,240,0,0,7,255,255,255,255,255,240,0,0,7,250,170,170,170,175,240,0,0,3,240,0,0,0,7,240,0,
  // 0x7bb1  箱
  177,123,35,36,68,38,1,252,0,14,64,0,0,57,0,0,0,0,31,192,0,0,191,0,0,0,0,63,192,0,0,255,0,0,0,0,127,128,0,1,254,0,0,0,0,191,255,255,227,255,255,255,252,0,255,255,255,231,255,255,255,252,3,255,255,255,239,255,255,255,252,7,248,254,0,47,224,254,0,0,15,240,127,0,127,192,127,64,0,63,208,63,129,255,64,47,192,0,47,64,47,64,190,0,15,208,0,6,0,252,0,24,0,10,64,0,0,0,252,0,0,0,0,0,0,0,0,252,0,15,255,255,255,224,0,0,252,0,15,255,255,255,224,47,255,255,255,207,255,255,255,224,47,255,255,255,207,192,0,15,224,47,255,255,255,207,192,0,15,224,0,7,253,0,15,192,0,15,224,0,7,253,0,15,255,255,255,224,0,15,255,64,15,255,255,255,224,0,31,255,208,15,250,170,175,224,0,63,255,244,15,192,0,15,224,0,191,255,253,15,192,0,15,224,1,254,252,255,143,192,0,15,224,3,252,252,63,207,255,255,255,224,11,240,252,31,15,255,255,255,224,47,224,252,9,15,250,170,175,224,127,192,252,0,15,192,0,15,224,63,64,252,0,15,192,0,15,224,30,0,252,0,15,192,0,15,224,4,0,252,0,15,255,255,255,224,0,0,252,0,15,255,255,255,224,0,0,252,0,15,255,255,255,224,0,0,252,0,15,192,0,15,224,0,0,252,0,10,128,0,5,80,
  // 0x7cfb  系
  251,124,34,36,68,38,2,252,0,0,0,0,0,0,0,64,0,0,0,0,0,0,22,191,224,0,0,5,86,170,255,255,255,248,0,47,255,255,255,255,255,255,252,0,15,255,255,255,255,255,165,0,0,15,255,255,255,212,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,7,252,0,15,128,0,0,0,0,31,244,0,63,240,0,0,0,16,63,208,0,191,208,0,0,0,189,255,64,2,255,64,0,0,2,255,253,0,11,253,0,0,0,0,191,248,0,47,244,0,0,0,0,31,253,0,191,208,0,0,0,0,2,255,131,255,64,0,0,0,0,0,127,255,252,0,180,0,0,0,0,15,255,240,3,253,0,0,0,0,3,255,192,2,255,64,0,0,0,15,254,0,0,191,224,0,0,0,127,244,0,0,31,248,0,255,255,255,251,255,255,255,254,0,191,255,255,255,255,255,255,255,64,191,255,255,255,255,255,255,255,208,106,149,85,83,253,85,80,47,240,0,0,0,3,252,0,0,15,224,0,0,64,3,252,0,80,3,64,0,3,248,3,252,3,244,0,0,0,15,252,3,252,11,254,0,0,0,63,240,3,252,2,255,192,0,0,255,208,3,252,0,127,244,0,7,255,64,3,252,0,15,254,0,47,253,0,3,252,0,3,255,128,255,240,0,3,252,0,0,191,224,191,192,0,3,252,0,0,47,208,30,0,0,3,252,0,0,10,0,0,0,0,3,248,0,0,0,0,
  // 0x7d05  紅
  5,125,36,36,68,38,1,252,0,3,64,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,63,128,64,127,255,255,255,252,0,191,1,244,127,255,255,255,252,13,253,3,252,127,255,255,255,252,63,248,11,244,21,86,254,85,84,63,240,31,224,0,1,253,0,0,15,244,63,192,0,1,253,0,0,3,253,191,0,0,1,253,0,0,0,255,253,0,0,1,253,0,0,0,63,248,20,0,1,253,0,0,0,31,240,188,0,1,253,0,0,0,47,208,254,0,1,253,0,0,0,127,128,127,64,1,253,0,0,1,255,0,63,192,1,253,0,0,191,255,255,255,208,1,253,0,0,127,255,255,255,240,1,253,0,0,127,255,255,251,244,1,253,0,0,0,1,252,2,248,1,253,0,0,0,1,252,0,128,1,253,0,0,1,1,252,4,0,1,253,0,0,7,241,252,126,0,1,253,0,0,11,241,252,127,0,1,253,0,0,15,225,252,63,128,1,253,0,0,15,209,252,31,192,1,253,0,0,15,193,252,15,208,1,253,0,0,47,193,252,11,224,1,253,0,0,63,129,252,7,240,1,253,0,0,127,1,252,3,64,1,253,0,0,127,1,252,3,255,255,255,255,253,5,1,252,3,255,255,255,255,253,0,1,252,3,255,255,255,255,253,0,1,252,1,85,85,85,85,84,0,1,248,0,0,0,0,0,0,
  // 0x7d22  索
  34,125,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,208,63,255,255,255,255,255,255,255,208,63,255,255,255,255,255,255,255,208,63,0,0,127,128,0,0,15,208,63,0,1,255,0,4,0,15,208,63,0,11,252,0,127,64,15,208,63,10,47,224,2,255,128,15,208,0,47,255,64,15,253,0,0,0,0,47,254,0,127,240,0,0,0,0,7,255,210,255,129,192,0,0,0,0,191,255,252,11,248,0,0,0,0,31,255,208,3,255,0,0,0,0,3,254,0,0,191,224,0,0,0,31,254,170,170,255,252,0,127,255,255,255,255,255,255,255,0,127,255,255,255,255,255,255,255,192,63,255,255,255,248,0,0,31,128,0,0,0,3,248,1,208,5,0,0,1,249,3,248,11,248,0,0,0,11,253,3,248,7,255,64,0,0,127,244,3,248,0,191,240,0,2,255,192,3,248,0,31,253,0,47,254,0,3,248,0,2,255,128,191,244,0,3,248,0,0,127,208,47,64,0,3,248,0,0,15,0,4,0,0,3,248,0,0,0,0,
  // 0x7d2b  紫
  43,125,35,36,68,38,1,252,0,0,47,64,2,252,0,0,0,0,0,63,64,2,252,0,0,0,0,0,63,64,2,252,0,6,0,3,240,63,64,2,252,0,191,128,3,240,63,255,242,252,31,255,224,3,240,63,255,242,255,255,255,64,3,240,63,255,242,255,255,208,0,3,240,63,64,2,255,228,0,0,3,240,63,64,2,252,0,0,0,3,240,63,64,2,252,0,0,228,3,240,63,65,162,252,0,0,252,3,240,127,255,241,253,0,2,252,27,255,255,255,241,255,255,255,248,127,255,255,255,144,255,255,255,240,63,255,165,15,208,47,255,255,208,41,64,0,63,224,0,0,0,0,0,0,0,255,128,11,128,0,0,0,3,135,253,0,63,240,0,0,0,31,255,240,1,255,192,0,0,0,31,255,192,11,254,0,0,0,0,1,255,244,63,244,30,0,0,0,0,31,255,255,128,191,192,0,0,0,2,255,253,0,47,240,0,0,0,0,255,224,0,11,253,0,63,255,255,255,255,255,255,255,64,63,255,255,255,255,255,255,255,224,63,255,255,255,255,255,255,175,248,4,0,0,0,254,0,0,7,252,0,0,32,0,254,0,36,1,208,0,0,255,64,254,1,255,0,0,0,11,254,0,254,1,255,224,0,0,127,248,0,254,0,47,253,0,7,255,208,0,254,0,3,255,192,47,254,0,0,254,0,0,127,244,11,244,0,0,254,0,0,15,224,1,64,0,0,254,0,0,2,0,
  // 0x7d30  細
  48,125,35,36,68,38,1,252,0,10,0,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,63,64,0,255,255,255,255,244,0,191,0,0,255,255,255,255,244,0,253,11,128,255,255,255,255,244,5,248,15,224,254,86,249,87,244,63,240,47,192,253,1,248,3,244,127,224,63,64,253,1,248,3,244,47,224,254,0,253,1,248,3,244,15,245,252,0,253,1,248,3,244,3,255,244,0,253,1,248,3,244,0,255,224,64,253,1,248,3,244,0,127,203,208,253,1,248,3,244,0,63,7,240,253,1,248,3,244,0,189,3,244,253,1,248,3,244,1,254,175,252,254,2,248,3,244,191,255,255,253,255,255,255,255,244,191,255,255,254,255,255,255,255,244,127,255,240,63,255,255,255,255,244,16,7,240,62,253,1,248,3,244,0,7,240,16,253,1,248,3,244,0,7,240,64,253,1,248,3,244,15,199,243,224,253,1,248,3,244,15,199,243,240,253,1,248,3,244,15,199,242,244,253,1,248,3,244,31,135,240,252,253,1,248,3,244,47,71,240,252,253,1,248,3,244,63,71,240,189,253,1,248,3,244,63,7,240,126,253,1,248,3,244,126,7,240,32,255,255,255,255,244,189,7,240,0,255,255,255,255,244,8,7,240,0,255,255,255,255,244,0,7,240,0,254,85,85,87,244,0,7,240,0,253,0,0,3,244,0,7,224,0,84,0,0,0,0,
  // 0x7d42  終
  66,125,36,37,77,38,1,251,0,9,0,0,0,57,0,0,0,0,31,192,0,0,191,0,0,0,0,47,192,0,0,254,0,0,0,0,63,64,0,2,252,0,0,0,0,191,0,0,7,255,255,255,64,0,252,15,64,15,255,255,255,192,6,248,31,192,47,255,255,255,128,47,240,63,128,127,192,0,191,0,127,208,127,1,255,224,0,254,0,47,208,253,7,255,244,3,252,0,15,246,248,31,246,252,11,248,0,3,255,240,63,208,255,31,224,0,0,255,208,15,64,63,191,192,0,0,127,139,1,0,31,255,0,0,0,63,31,128,0,15,253,0,0,0,253,15,192,0,47,255,0,0,2,248,7,224,0,255,255,208,0,127,255,255,240,7,255,127,248,0,191,255,255,244,127,252,11,255,64,127,255,255,255,255,224,1,255,248,16,11,224,255,255,64,0,63,254,0,11,224,83,244,31,64,7,252,4,11,225,128,64,127,244,0,112,15,203,235,208,0,47,254,0,0,15,203,227,224,0,2,255,208,0,15,203,227,240,0,0,47,224,0,31,139,226,244,0,0,7,192,0,47,75,224,248,4,0,0,0,0,63,11,224,252,47,208,0,0,0,63,11,224,180,127,254,64,0,0,190,11,224,0,31,255,248,0,0,189,11,224,0,0,127,255,144,0,24,11,224,0,0,6,255,253,0,0,11,224,0,0,0,47,255,64,0,11,224,0,0,0,1,255,0,0,11,208,0,0,0,0,44,0,0,0,0,0,0,0,0,0,0,
  // 0x7d71  統
  113,125,36,37,77,38,1,251,0,9,0,0,0,7,240,0,0,0,31,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,63,64,0,0,11,240,0,0,0,127,0,0,0,11,240,0,0,0,252,15,75,255,255,255,255,252,5,248,31,203,255,255,255,255,252,47,240,63,139,255,255,255,255,252,127,208,127,0,1,255,0,0,0,47,208,253,0,1,253,0,32,0,15,246,248,0,3,252,2,248,0,3,255,240,0,3,248,2,253,0,0,255,208,0,7,240,0,255,0,0,127,139,0,15,224,0,63,128,0,63,31,128,31,234,175,255,208,0,253,15,203,255,255,255,255,240,2,248,7,231,255,255,255,255,248,127,255,255,247,255,250,165,66,252,191,255,255,249,0,0,0,0,252,127,255,255,252,1,80,5,64,144,16,11,224,252,3,240,15,192,0,0,11,224,160,3,240,15,192,0,4,11,225,128,3,240,15,192,0,15,203,235,192,7,240,15,192,0,15,203,231,224,7,240,15,192,0,15,203,227,240,11,240,15,192,0,31,139,226,244,15,224,15,192,0,47,75,225,248,15,208,15,192,0,63,11,224,252,31,192,15,192,32,63,11,224,188,63,192,15,192,62,190,11,224,0,191,64,15,192,63,189,11,224,1,255,0,15,192,126,24,11,224,11,252,0,15,208,190,0,11,224,127,244,0,15,255,253,0,11,224,127,192,0,11,255,252,0,11,208,30,0,0,2,255,240,0,0,0,0,0,0,0,0,0,
  // 0x7d72  絲
  114,125,36,36,68,38,1,252,0,3,64,0,0,0,208,0,0,0,11,240,0,0,2,252,0,0,0,15,224,0,0,3,248,0,0,0,31,192,0,0,11,240,0,0,0,63,64,0,0,15,208,16,0,0,191,3,244,0,47,192,125,0,8,252,7,248,5,127,0,255,0,63,248,15,240,15,254,2,253,0,127,240,47,208,47,252,7,248,0,47,240,63,128,11,248,15,240,0,11,248,255,0,2,254,47,208,0,2,255,252,0,0,191,255,128,0,0,191,244,0,0,47,255,8,0,0,47,225,240,0,11,252,127,0,0,47,194,248,0,11,240,63,64,0,191,0,252,0,47,208,47,192,1,253,0,191,0,127,128,31,240,191,255,255,255,111,255,255,255,244,127,255,255,255,159,255,255,255,252,127,255,255,255,223,255,255,255,252,20,2,248,15,213,64,254,0,253,0,1,248,6,0,0,254,0,112,2,65,248,4,0,0,254,0,0,7,241,248,252,2,248,254,47,0,11,225,248,254,3,248,254,63,64,11,225,248,127,3,244,254,47,192,15,209,248,63,71,240,254,15,208,15,193,248,47,139,224,254,11,240,47,193,248,15,207,208,254,3,244,63,129,248,14,47,192,254,2,252,127,1,248,0,127,128,254,1,253,191,1,248,0,191,0,254,0,254,9,1,248,0,29,0,254,0,160,0,1,248,0,0,0,254,0,0,0,1,248,0,0,0,254,0,0,0,1,248,0,0,0,189,0,0,
  // 0x7da0  綠
  160,125,36,36,68,38,1,252,0,9,0,0,3,160,0,0,0,0,15,192,0,7,240,0,0,0,0,47,192,0,11,240,0,0,0,0,63,64,0,11,255,255,255,0,0,127,0,0,15,255,255,255,0,0,253,15,64,15,250,170,255,0,5,248,31,192,31,192,0,191,0,47,240,63,128,47,128,0,190,0,127,224,127,0,63,64,0,253,0,63,208,253,0,63,255,255,253,0,15,242,248,0,127,255,255,252,0,3,255,240,0,255,170,171,252,0,1,255,208,0,105,0,2,248,0,0,191,155,0,0,0,3,244,0,0,127,47,139,255,255,255,255,252,0,252,15,203,255,255,255,255,252,3,248,11,235,255,255,255,255,252,191,255,255,240,0,3,244,0,0,191,255,255,244,0,3,248,0,64,191,255,255,252,116,3,252,2,224,0,15,208,254,253,3,253,7,248,0,15,208,160,255,67,254,31,240,5,15,208,64,63,195,255,191,128,15,207,219,192,15,227,255,254,0,15,207,215,208,7,131,255,244,0,31,143,211,224,1,3,255,224,0,31,79,211,240,0,179,247,244,0,47,79,210,244,7,247,246,253,0,63,15,209,248,63,247,244,255,0,63,15,208,230,255,195,244,127,192,190,15,208,31,254,3,244,47,248,252,15,208,47,244,3,244,11,254,24,15,208,15,192,3,244,2,252,0,15,208,6,2,255,240,0,112,0,15,208,0,1,255,240,0,0,0,11,192,0,0,254,128,0,0,
  // 0x7db2  網
  178,125,35,37,77,38,1,251,0,9,0,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,47,192,7,255,255,255,255,244,0,63,0,7,255,255,255,255,244,0,190,0,7,255,255,255,255,244,0,252,15,135,240,0,0,2,244,9,248,47,199,240,80,3,146,244,63,240,63,71,242,240,7,226,244,127,208,191,7,240,244,11,194,244,47,208,252,7,240,248,15,130,244,15,243,244,7,240,188,31,2,244,3,255,240,7,240,120,31,2,244,0,255,193,7,243,255,255,242,244,0,127,175,7,243,255,255,242,244,0,127,31,199,242,171,250,162,244,0,252,15,215,240,3,240,2,244,3,248,11,231,240,3,240,2,244,191,255,255,251,240,3,240,2,244,191,255,255,255,242,175,250,162,244,191,255,255,255,243,255,255,242,244,0,15,208,255,243,255,255,242,244,0,15,208,171,240,252,0,2,244,10,79,209,135,240,252,0,2,244,15,207,219,199,240,252,0,2,244,15,207,215,231,240,252,0,2,244,31,143,211,247,240,252,0,2,244,47,79,210,247,240,189,0,2,244,47,15,209,251,240,191,255,226,244,63,15,209,255,240,127,255,226,244,63,15,208,235,240,31,255,226,244,190,15,208,7,240,0,0,2,244,252,15,208,7,240,0,0,2,244,24,15,208,7,240,0,0,3,244,0,15,208,7,240,0,3,255,244,0,15,208,7,240,0,2,255,240,0,15,208,7,240,0,1,255,128,0,0,0,0,0,0,0,0,0,
  // 0x7dd2  緒
  210,125,36,36,68,38,1,252,0,9,0,0,0,63,0,0,0,0,15,192,0,0,63,0,2,228,0,47,192,0,0,63,0,3,248,0,63,64,0,0,63,0,7,240,0,127,0,3,255,255,255,207,224,0,253,15,67,255,255,255,239,192,5,248,31,195,255,255,255,255,128,47,240,63,128,0,63,0,191,0,127,224,127,0,0,63,1,254,0,63,192,253,0,0,63,3,252,0,15,242,248,0,0,63,7,248,0,7,251,240,0,0,63,15,240,0,2,255,208,31,255,255,255,255,253,0,255,139,31,255,255,255,255,253,0,127,47,95,255,255,255,255,253,0,253,15,192,0,15,248,0,0,2,248,11,224,0,127,208,0,0,191,255,255,240,1,255,64,0,0,191,255,255,244,11,255,255,255,192,191,255,255,252,127,255,255,255,192,0,15,208,255,255,255,255,255,192,0,15,208,191,255,192,0,31,192,4,15,208,95,255,192,0,31,192,15,207,219,202,31,192,0,31,192,15,207,215,208,31,192,0,31,192,31,143,211,224,31,255,255,255,192,31,143,211,240,31,255,255,255,192,47,79,210,244,31,255,255,255,192,63,15,209,248,31,192,0,31,192,63,15,208,228,31,192,0,31,192,189,15,208,0,31,192,0,31,192,188,15,208,0,31,255,255,255,192,4,15,208,0,31,255,255,255,192,0,15,208,0,31,255,255,255,192,0,15,208,0,31,192,0,31,192,0,11,192,0,10,128,0,10,128,
  // 0x7dda  線
  218,125,36,36,68,38,1,252,0,9,0,0,0,3,164,0,0,0,15,192,0,0,7,252,0,0,0,47,192,0,0,11,240,0,0,0,63,64,0,0,15,224,0,0,0,127,0,1,255,255,255,255,240,0,253,15,65,255,255,255,255,240,5,248,31,193,255,255,255,255,240,47,240,63,129,252,0,0,11,240,127,224,127,1,252,0,0,11,240,63,208,253,1,254,170,170,175,240,15,242,248,1,255,255,255,255,240,3,255,240,1,255,255,255,255,240,1,255,208,1,252,0,0,11,240,0,191,155,1,252,0,0,11,240,0,127,47,129,252,0,0,11,240,0,252,15,193,255,255,255,255,240,3,248,11,225,255,255,255,255,240,191,255,255,241,255,255,255,255,240,191,255,255,244,0,3,244,0,0,191,255,255,252,0,3,248,0,64,0,15,208,252,0,3,252,2,240,0,15,208,171,255,231,253,7,252,5,15,209,71,255,251,255,31,244,15,207,219,199,255,243,255,191,192,15,207,215,208,3,243,255,255,0,31,143,211,240,11,227,255,248,0,31,79,210,240,15,195,251,240,0,47,79,210,244,63,131,247,252,0,63,15,209,248,191,3,245,255,0,63,15,208,145,254,3,244,191,128,190,15,208,7,252,3,244,63,244,252,15,208,63,240,3,244,15,254,24,15,208,47,192,3,244,3,253,0,15,208,15,2,255,240,0,184,0,15,208,0,1,255,240,0,0,0,11,192,0,0,255,128,0,0,
  // 0x7de8  編
  232,125,35,36,68,38,1,252,0,9,0,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,47,128,15,255,255,255,255,252,0,63,0,15,255,255,255,255,252,0,126,0,15,255,255,255,255,252,0,252,14,0,0,0,0,0,0,5,248,47,192,0,0,0,0,0,47,240,63,64,0,0,0,0,0,127,224,190,2,255,255,255,255,240,63,208,252,2,255,255,255,255,240,15,242,244,2,255,255,255,255,240,3,255,240,2,244,0,0,11,240,0,255,208,2,244,0,0,11,240,0,127,159,2,244,0,0,11,240,0,127,47,2,255,255,255,255,240,0,253,15,130,255,255,255,255,240,2,248,15,195,255,255,255,255,240,191,255,255,227,244,0,0,0,0,191,255,255,243,244,0,0,0,0,191,255,255,243,254,170,170,170,164,0,15,193,247,255,255,255,255,248,0,15,192,211,255,255,255,255,248,5,15,194,3,255,11,131,208,248,15,207,207,131,255,11,131,208,248,15,143,207,199,255,11,131,208,248,31,79,203,203,255,11,131,208,248,47,79,195,219,255,255,255,255,248,47,15,195,239,239,255,255,255,248,63,15,195,255,223,175,235,234,248,62,15,194,255,159,11,131,208,248,189,15,192,63,95,11,131,208,248,188,15,192,127,31,11,131,208,248,4,15,192,254,31,11,131,209,248,0,15,193,252,31,11,131,223,248,0,15,192,56,31,11,131,223,244,0,15,192,0,31,5,65,70,144,
  // 0x7e2e  縮
  46,126,35,36,68,38,1,252,0,9,0,0,0,7,240,0,0,0,15,192,0,0,11,240,0,0,0,47,128,0,0,11,240,0,0,0,63,0,0,0,11,240,0,0,0,126,0,15,255,255,255,255,252,0,252,14,79,255,255,255,255,252,5,248,47,207,255,255,255,255,252,63,240,63,15,192,0,0,1,252,127,208,190,15,192,0,0,1,252,47,209,252,15,206,64,0,1,168,11,247,244,5,95,192,0,0,0,3,255,240,0,47,191,255,255,252,0,255,193,0,63,127,255,255,252,0,127,111,0,63,63,255,255,252,0,127,31,128,190,0,15,208,0,0,252,15,192,253,0,15,192,0,2,248,11,209,252,0,31,192,0,191,255,255,227,252,31,255,255,240,191,255,255,247,252,31,255,255,244,191,255,255,255,252,31,255,255,244,0,15,193,255,252,31,128,3,244,0,15,192,63,252,31,128,3,244,9,15,193,46,252,31,128,3,244,15,207,207,72,252,31,128,3,244,15,143,207,192,252,31,255,255,244,31,79,203,192,252,31,255,255,244,47,79,199,208,252,31,255,255,244,47,15,195,224,252,31,128,3,244,63,15,195,240,252,31,128,3,244,62,15,194,224,252,31,128,3,244,189,15,192,0,252,31,128,3,244,188,15,192,0,252,31,255,255,244,4,15,192,0,252,31,255,255,244,0,15,192,0,252,31,255,255,244,0,15,192,0,252,31,128,3,244,0,15,192,0,252,26,64,1,80,
  // 0x7e3d  總
  61,126,36,36,68,38,1,252,0,9,0,0,0,3,164,0,0,0,15,192,0,0,3,252,0,0,0,47,128,0,0,7,244,0,0,0,63,0,0,0,15,240,0,0,0,126,0,3,255,255,255,255,240,0,252,14,3,255,255,255,255,240,5,248,47,195,250,171,234,171,240,47,240,63,67,240,3,224,3,240,127,224,190,3,240,7,255,227,240,63,208,252,3,242,223,255,243,240,15,242,244,3,247,255,3,227,240,3,255,240,3,240,255,139,195,240,0,255,208,3,242,255,255,67,240,0,127,159,3,247,209,255,3,240,0,127,47,3,241,65,255,195,240,0,253,15,131,240,11,251,243,240,2,248,15,195,240,127,193,195,240,191,255,255,227,240,190,0,3,240,191,255,255,243,250,190,170,171,240,191,255,255,243,255,255,255,255,240,0,15,193,247,255,255,255,255,240,0,15,192,208,0,63,0,0,0,0,15,193,0,0,191,208,0,0,15,207,207,64,0,31,248,0,0,15,143,207,192,0,3,254,0,0,31,143,203,192,65,248,191,11,0,31,79,199,209,245,248,40,47,128,47,15,195,226,245,248,0,15,208,63,15,195,243,241,248,0,11,240,62,15,194,227,241,248,0,3,244,189,15,192,7,225,248,0,209,252,252,15,192,15,209,248,1,244,253,24,15,192,47,193,248,2,244,190,0,15,192,63,65,255,255,240,126,0,15,192,10,0,255,255,224,32,0,15,192,0,0,47,255,128,0,
  // 0x7e7c  繼
  124,126,35,37,77,38,1,251,0,36,0,63,0,0,0,0,0,0,63,0,63,0,240,0,124,0,0,126,0,63,2,224,0,248,0,0,253,0,63,3,194,1,240,128,0,252,0,63,47,139,207,210,240,2,244,57,63,63,15,47,135,192,27,240,190,63,31,126,11,223,64,63,208,252,63,7,252,2,254,0,127,194,244,63,2,246,0,253,128,47,195,240,63,3,219,65,243,208,11,251,208,63,11,131,195,208,240,3,255,192,63,127,255,255,255,248,1,255,0,63,127,255,255,255,252,0,190,184,63,0,0,128,0,20,0,252,252,63,234,170,170,170,168,2,244,126,63,255,255,255,255,252,3,240,63,63,255,255,255,255,252,255,255,255,127,0,208,0,52,0,191,255,255,191,1,240,0,188,0,191,255,239,255,3,208,0,244,0,0,47,75,255,7,195,133,240,224,0,47,69,63,63,75,159,195,224,9,47,68,63,63,31,31,135,192,31,111,126,63,15,189,7,223,64,31,111,127,63,3,252,1,254,0,47,47,95,127,1,247,0,254,192,47,47,79,191,3,219,128,243,224,63,47,79,255,11,131,195,208,240,62,47,75,255,127,255,255,255,248,125,47,75,255,127,255,255,255,252,188,47,64,63,20,0,149,0,40,188,47,64,63,0,0,0,0,0,4,47,64,63,255,255,255,255,252,0,47,64,63,255,255,255,255,252,0,47,64,63,234,170,170,170,168,0,47,64,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x7e8c  續
  140,126,35,36,68,38,1,252,0,9,0,0,0,11,240,0,0,0,31,192,0,0,11,240,0,0,0,47,128,31,255,255,255,255,252,0,63,0,31,255,255,255,255,252,0,190,0,5,85,91,245,85,84,0,252,31,64,0,11,240,0,0,6,244,63,130,255,255,255,255,224,47,240,127,2,255,255,255,255,224,127,208,253,0,0,0,0,0,0,63,209,252,0,0,0,0,0,0,15,243,244,7,255,255,255,255,244,3,255,224,7,255,255,255,255,244,1,255,192,7,208,124,47,2,244,0,191,126,7,219,244,31,255,244,0,127,47,7,223,128,5,87,244,0,252,31,135,255,255,255,255,244,2,244,15,199,255,255,255,255,244,111,255,255,208,0,0,0,0,0,127,255,255,240,0,0,0,0,0,127,255,251,240,255,255,255,255,192,16,15,194,240,255,255,255,255,192,0,15,192,0,252,0,0,15,192,14,79,193,0,254,170,170,175,192,15,207,207,64,255,255,255,255,192,31,143,207,192,252,0,0,15,192,31,79,203,192,254,170,170,175,192,47,79,195,208,255,255,255,255,192,47,15,195,224,252,0,0,15,192,63,15,195,224,252,0,0,15,192,126,15,193,0,255,255,255,255,192,189,15,192,0,255,255,255,255,192,188,15,192,0,11,224,7,244,0,4,15,192,1,191,244,11,255,64,0,15,192,111,255,64,0,191,244,0,15,192,127,228,0,0,11,252,0,15,192,29,0,0,0,1,208,
  // 0x7ea2  红
  162,126,35,34,50,38,1,254,0,1,144,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,11,244,1,170,170,170,170,160,0,15,240,3,255,255,255,255,244,0,47,208,3,255,255,255,255,244,0,63,192,3,255,255,255,255,244,0,191,0,0,0,3,248,0,0,1,254,1,192,0,3,248,0,0,3,252,3,248,0,3,248,0,0,11,244,11,248,0,3,248,0,0,31,224,31,240,0,3,248,0,0,127,255,255,208,0,3,248,0,0,127,255,255,128,0,3,248,0,0,63,255,255,0,0,3,248,0,0,62,87,252,0,0,3,248,0,0,0,15,244,0,0,3,248,0,0,0,47,224,0,0,3,248,0,0,0,127,192,0,0,3,248,0,0,1,255,0,0,0,3,248,0,0,7,253,26,240,0,3,248,0,0,31,255,255,240,0,3,248,0,0,127,255,255,244,0,3,248,0,0,63,255,254,80,0,3,248,0,0,47,229,0,0,0,3,248,0,0,20,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,16,0,3,248,0,0,0,0,107,240,0,3,248,0,0,0,111,255,240,0,3,248,0,0,127,255,255,251,255,255,255,255,252,127,255,254,71,255,255,255,255,252,63,254,64,7,255,255,255,255,252,57,0,0,6,170,170,170,170,168,
  // 0x7f6e  置
  110,127,35,35,59,38,2,252,5,85,85,85,85,85,85,85,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,0,11,224,3,240,1,252,0,191,0,11,224,3,240,1,252,0,191,0,11,224,3,240,1,252,0,191,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,0,5,85,85,86,254,85,85,85,0,0,0,0,1,252,0,0,0,0,42,170,170,171,254,170,170,170,128,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,1,80,31,255,255,255,255,244,0,7,240,31,255,255,255,255,244,0,7,240,31,192,0,0,3,244,0,7,240,31,192,0,0,3,244,0,7,240,31,255,255,255,255,244,0,7,240,31,255,255,255,255,244,0,7,240,31,192,0,0,3,244,0,7,240,31,192,0,0,3,244,0,7,240,31,255,255,255,255,244,0,7,240,31,255,255,255,255,244,0,7,240,31,192,0,0,3,244,0,7,240,31,192,0,0,3,244,0,7,240,31,255,255,255,255,244,0,7,240,31,255,255,255,255,244,0,7,240,0,0,0,0,0,0,0,7,255,255,255,255,255,255,255,240,7,255,255,255,255,255,255,255,244,7,255,255,255,255,255,255,255,244,7,240,0,0,0,0,0,0,0,2,160,0,0,0,0,0,0,0,
  // 0x7f72  署
  114,127,35,35,59,38,1,252,1,85,85,85,85,85,85,85,64,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,248,0,252,0,127,0,47,192,2,248,0,252,0,127,0,47,192,2,248,0,252,0,127,0,47,192,2,253,86,254,85,191,85,127,192,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,13,0,0,47,255,255,255,255,248,127,128,0,63,255,255,255,255,249,255,128,0,63,255,255,255,255,255,253,0,0,0,0,3,248,0,127,244,0,0,0,0,3,248,3,255,128,0,47,255,255,255,255,255,255,255,248,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,0,7,255,244,0,0,0,0,0,1,191,255,64,0,0,0,0,0,47,255,254,170,170,169,0,0,27,255,255,255,255,255,253,0,27,255,255,255,255,255,255,253,0,127,255,255,64,0,0,0,253,0,47,254,63,64,0,0,0,253,0,14,64,63,149,85,85,85,253,0,0,0,63,255,255,255,255,253,0,0,0,63,255,255,255,255,253,0,0,0,63,64,0,0,0,253,0,0,0,63,64,0,0,0,253,0,0,0,63,255,255,255,255,253,0,0,0,63,255,255,255,255,253,0,0,0,63,170,170,170,170,253,0,0,0,63,0,0,0,0,169,0,
  // 0x8070  聰
  112,128,36,37,77,38,1,251,0,0,0,0,0,1,148,0,0,0,0,0,0,0,3,252,0,0,63,255,255,255,0,3,248,0,0,63,255,255,255,0,7,240,0,0,63,255,255,255,255,255,255,255,240,3,240,7,224,255,255,255,255,240,3,240,7,224,254,171,250,171,240,3,240,7,224,252,1,224,3,240,3,240,7,224,252,3,250,163,240,3,240,7,224,252,175,255,227,240,3,255,255,224,252,255,3,211,240,3,255,255,224,252,191,199,195,240,3,255,255,224,253,247,255,3,240,3,240,7,224,252,128,191,3,240,3,240,7,224,252,0,255,195,240,3,240,7,224,252,7,231,211,240,3,240,7,224,252,63,129,131,240,3,240,7,224,252,61,0,3,240,3,255,255,224,255,255,255,255,240,3,255,255,224,255,255,255,255,240,3,255,255,224,170,175,234,170,160,3,240,7,224,0,31,224,0,0,3,240,7,224,0,31,253,0,0,3,240,7,224,0,2,255,64,0,3,240,7,224,0,189,127,129,0,3,240,31,224,125,189,15,31,64,3,255,255,224,189,189,0,31,192,191,255,255,224,252,189,0,15,208,127,255,255,224,252,189,0,7,240,63,250,75,225,248,189,0,67,244,41,0,7,226,244,189,0,249,252,0,0,7,227,240,189,0,252,252,0,0,7,239,224,189,0,248,253,0,0,7,235,192,191,255,244,126,0,0,7,225,64,63,255,240,32,0,0,7,224,0,10,255,128,0,0,0,0,0,0,0,0,0,0,
  // 0x81ea  自
  234,129,27,37,3,38,6,251,0,0,3,164,0,0,0,0,0,7,252,0,0,0,0,0,11,244,0,0,0,0,0,15,240,0,0,0,0,0,15,224,0,0,0,85,85,111,229,85,85,80,255,255,255,255,255,255,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,85,85,85,85,87,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,254,85,85,85,85,87,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,85,85,85,85,87,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,254,0,0,0,0,3,248,254,0,0,0,0,3,244,0,0,0,0,0,0,0,
  // 0x85cd  藍
  205,133,34,35,59,38,2,253,0,0,63,64,0,47,192,0,0,0,0,63,64,0,47,192,0,0,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,0,0,63,64,0,47,192,0,0,0,0,63,64,0,47,192,0,0,0,0,0,0,0,20,0,0,0,15,255,255,255,224,63,64,0,0,15,255,255,255,224,127,0,0,0,15,192,190,0,0,191,0,0,0,15,192,126,0,1,255,255,255,208,15,255,255,255,131,255,255,255,208,15,255,255,255,139,255,255,255,208,15,192,0,15,159,224,0,0,0,15,192,0,15,191,192,0,0,0,15,255,255,255,143,0,0,0,0,15,255,255,255,128,0,0,0,0,15,192,126,0,0,191,255,255,64,15,192,126,0,0,255,255,255,64,15,255,255,255,240,255,255,255,64,15,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,244,0,0,255,255,255,255,255,255,244,0,0,255,170,254,171,254,171,244,0,0,253,0,252,2,244,3,244,0,0,253,0,252,2,244,3,244,0,0,253,0,252,2,244,3,244,0,0,253,0,252,2,244,3,244,0,0,253,0,252,2,244,3,244,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x884c  行
  76,136,35,36,68,38,1,252,0,0,32,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,2,254,0,85,85,85,85,80,0,11,252,1,255,255,255,255,240,0,47,240,1,255,255,255,255,240,0,191,192,1,255,255,255,255,240,3,255,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,127,240,4,0,0,0,0,0,0,63,192,15,144,0,0,0,0,0,14,0,63,208,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,3,253,15,255,255,255,255,252,0,15,248,15,255,255,255,255,252,0,63,240,15,255,255,255,255,252,0,255,224,5,85,85,95,245,84,3,255,224,0,0,0,15,224,0,31,255,224,0,0,0,15,224,0,127,255,224,0,0,0,15,224,0,191,207,224,0,0,0,15,224,0,47,15,224,0,0,0,15,224,0,12,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,1,255,255,224,0,0,15,224,0,0,255,255,208,0,0,15,224,0,0,191,255,128,0,0,10,160,0,0,21,84,0,0,
  // 0x8868  表
  104,136,36,36,68,38,1,252,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,127,255,255,255,255,255,255,0,0,127,255,255,255,255,255,255,0,0,127,255,255,255,255,255,254,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,47,255,255,255,255,255,255,255,244,47,255,255,255,255,255,255,255,244,47,255,255,255,255,255,255,255,244,0,0,0,47,255,240,0,0,0,0,0,1,255,199,240,0,10,0,0,0,11,255,3,248,0,47,192,0,0,191,244,2,252,0,255,208,0,11,255,192,0,254,7,255,0,1,255,255,192,0,191,47,248,0,111,255,255,192,0,127,255,208,0,127,254,47,192,0,47,254,0,0,31,224,47,192,0,15,244,0,0,9,0,47,192,0,7,252,0,0,0,0,47,192,0,18,255,64,0,0,0,47,192,27,240,255,208,0,0,0,47,239,255,240,63,252,0,0,0,127,255,255,240,15,255,128,0,111,255,255,249,0,2,255,253,0,191,255,249,0,0,0,127,252,0,63,249,0,0,0,0,11,244,0,41,0,0,0,0,0,0,96,
  // 0x88ab  被
  171,136,36,36,68,38,1,252,0,15,192,0,0,1,252,0,0,0,31,192,0,0,1,252,0,0,0,31,192,0,0,1,252,0,0,0,31,192,0,0,1,252,0,0,0,31,192,0,0,1,252,0,0,0,31,192,0,0,1,252,0,0,0,31,192,1,255,255,255,255,252,63,255,255,193,255,255,255,255,252,63,255,255,241,255,255,255,255,252,63,255,255,209,252,2,252,3,248,0,0,47,193,252,1,252,3,244,0,0,63,129,252,1,252,3,240,0,0,127,1,252,1,252,11,240,0,0,253,1,252,1,252,6,208,0,3,252,33,252,1,252,0,0,0,11,244,189,255,255,255,255,208,0,31,241,249,255,255,255,255,240,0,127,251,225,255,255,255,255,208,0,255,255,193,255,244,0,31,192,3,255,255,66,255,248,0,63,192,31,255,239,194,249,252,0,63,128,191,255,207,226,248,253,0,191,0,191,143,195,243,244,191,0,255,0,62,15,193,211,244,63,130,253,0,40,15,192,67,240,47,199,252,0,0,15,192,7,240,15,255,244,0,0,15,192,11,240,7,255,224,0,0,15,192,15,224,3,255,192,0,0,15,192,15,208,2,255,128,0,0,15,192,31,192,15,255,240,0,0,15,192,63,128,127,255,253,0,0,15,192,127,66,255,215,255,208,0,15,192,255,47,255,1,255,253,0,15,194,253,63,248,0,63,253,0,15,192,188,31,208,0,7,244,0,15,192,20,9,0,0,0,96,
  // 0x88c5  装
  197,136,36,37,77,38,1,251,0,0,63,0,0,7,240,0,0,0,0,63,0,0,7,240,0,0,3,64,63,0,0,7,240,0,0,15,224,63,0,0,7,240,0,0,15,252,63,0,0,7,240,0,0,2,255,63,15,255,255,255,255,252,0,190,63,15,255,255,255,255,252,0,40,63,15,255,255,255,255,252,0,0,63,0,0,7,240,0,0,0,0,63,0,0,7,240,0,0,0,1,63,0,0,7,240,0,0,0,31,127,0,0,7,240,0,0,2,255,191,0,0,7,240,0,0,47,255,191,0,0,7,240,0,0,127,248,63,3,255,255,255,255,240,63,64,63,3,255,255,255,255,240,20,0,63,3,255,255,255,255,240,0,0,63,0,0,0,0,0,0,0,0,42,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,47,255,255,255,255,255,255,255,252,0,0,1,255,143,224,0,29,0,0,0,31,253,3,244,0,191,128,0,6,255,224,2,252,7,255,64,6,255,255,128,0,255,127,244,0,127,255,255,128,0,63,255,128,0,31,249,47,128,0,15,252,0,0,9,0,47,128,1,67,255,64,0,0,0,47,218,255,192,255,244,0,0,26,255,255,255,192,47,255,144,0,63,255,255,254,128,3,255,253,0,63,255,165,0,0,0,111,248,0,25,64,0,0,0,0,1,176,0,0,0,0,0,0,0,0,0,
  // 0x88dd  裝
  221,136,35,37,77,38,2,251,5,64,31,128,0,15,208,0,0,15,192,31,192,0,15,224,0,0,15,192,31,192,0,15,224,0,0,15,192,31,192,0,15,224,0,0,15,192,31,192,0,15,224,0,0,15,255,255,207,255,255,255,255,224,15,255,255,207,255,255,255,255,224,15,255,255,207,255,255,255,255,224,10,128,31,192,0,15,224,0,0,0,0,31,192,0,15,224,0,0,170,170,191,192,0,15,224,0,0,255,255,255,192,0,15,224,0,0,255,255,255,192,0,15,224,0,0,7,240,31,192,0,15,224,0,0,11,224,31,195,255,255,255,255,128,15,208,31,195,255,255,255,255,128,63,192,31,195,255,255,255,255,128,255,64,31,192,0,0,0,0,0,254,0,31,194,252,0,0,0,0,116,0,5,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,0,0,11,254,63,128,0,52,0,0,1,191,244,15,208,2,254,0,0,111,255,64,11,240,31,253,0,111,255,254,0,3,253,255,224,0,255,254,254,0,0,255,254,0,0,127,144,190,0,0,63,240,0,0,16,0,190,0,22,15,253,0,0,0,0,255,191,255,3,255,208,0,0,175,255,255,255,0,191,254,64,1,255,255,255,229,0,15,255,244,0,255,233,64,0,0,1,191,224,0,80,0,0,0,0,0,6,192,0,0,0,0,0,0,0,0,0,
  // 0x8907  複
  7,137,36,36,68,38,1,252,0,26,64,0,10,64,0,0,0,0,47,128,0,15,208,0,0,0,0,47,128,0,47,192,0,0,0,0,47,128,0,63,128,0,0,0,0,47,128,0,191,255,255,255,252,0,47,128,0,255,255,255,255,252,0,47,128,3,255,255,255,255,252,0,47,128,7,244,0,0,0,0,63,255,255,79,224,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,95,191,255,255,255,192,0,0,63,5,127,85,85,111,192,0,0,190,0,126,0,0,31,192,0,0,252,0,127,0,0,47,192,0,2,248,0,127,255,255,255,192,0,7,240,224,127,255,255,255,192,0,15,225,244,126,0,0,31,192,0,47,227,224,126,0,0,31,192,0,127,255,192,127,255,255,255,192,0,255,255,64,127,255,255,255,192,3,255,255,0,21,255,85,85,64,15,255,175,128,1,254,0,0,0,63,255,143,208,7,254,170,169,0,191,159,135,192,31,255,255,255,192,62,31,130,0,191,255,255,255,64,40,31,128,7,255,192,0,254,0,0,31,128,47,255,240,3,252,0,0,31,128,63,211,252,31,244,0,0,31,128,14,0,255,191,208,0,0,31,128,0,0,127,255,64,0,0,31,128,0,0,127,255,64,0,0,31,128,0,31,255,255,249,0,0,31,128,27,255,254,127,255,249,0,31,128,127,255,224,7,255,253,0,31,128,63,249,0,0,111,248,0,31,128,30,64,0,0,0,176,
  // 0x89d2  角
  210,137,32,37,40,38,1,251,0,0,3,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,15,255,255,255,64,0,0,0,63,255,255,255,208,0,0,0,191,255,255,255,192,0,0,0,255,0,0,191,128,0,0,3,253,0,0,255,0,0,0,15,248,0,2,253,0,0,0,63,240,0,3,248,0,0,0,255,255,255,255,255,255,255,3,255,255,255,255,255,255,255,31,255,255,255,255,255,255,255,15,255,224,0,63,128,0,127,3,139,224,0,63,128,0,127,0,11,224,0,63,128,0,127,0,11,224,0,63,128,0,127,0,11,224,0,63,128,0,127,0,11,255,255,255,255,255,255,0,15,255,255,255,255,255,255,0,15,255,255,255,255,255,255,0,15,224,0,63,128,0,127,0,15,224,0,63,128,0,127,0,15,208,0,63,128,0,127,0,15,208,0,63,128,0,127,0,31,255,255,255,255,255,255,0,47,255,255,255,255,255,255,0,63,255,255,255,255,255,255,0,63,64,0,0,0,0,127,0,191,0,0,0,0,0,127,0,254,0,0,0,0,0,127,3,253,0,0,0,0,0,127,11,248,0,0,0,0,0,127,31,240,0,0,0,21,85,191,127,208,0,0,0,47,255,255,47,128,0,0,0,15,255,253,10,0,0,0,0,15,255,224,0,0,0,0,0,0,0,0,
  // 0x8a08  計
  8,138,36,36,68,38,1,252,0,0,0,0,0,0,253,0,0,7,255,255,240,0,0,254,0,0,7,255,255,244,0,0,254,0,0,7,255,255,244,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,127,255,255,254,0,0,254,0,0,127,255,255,254,0,0,254,0,0,127,255,255,254,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,11,255,255,240,0,0,254,0,0,11,255,255,241,255,255,255,255,255,10,170,170,161,255,255,255,255,255,0,0,0,1,255,255,255,255,255,0,0,0,0,85,85,255,85,85,11,255,255,240,0,0,254,0,0,11,255,255,240,0,0,254,0,0,11,255,255,240,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,11,255,255,240,0,0,254,0,0,15,255,255,240,0,0,254,0,0,15,255,255,240,0,0,254,0,0,15,208,3,240,0,0,254,0,0,15,208,3,240,0,0,254,0,0,15,208,3,240,0,0,254,0,0,15,208,3,240,0,0,254,0,0,15,208,3,240,0,0,254,0,0,15,208,3,240,0,0,254,0,0,15,255,255,240,0,0,254,0,0,15,255,255,240,0,0,254,0,0,15,255,255,240,0,0,254,0,0,15,208,0,0,0,0,254,0,0,5,64,0,0,0,0,254,0,0,
  // 0x8a0a  訊
  10,138,37,36,104,38,1,251,7,255,255,192,0,0,0,0,0,0,11,255,255,211,255,255,255,254,0,0,11,255,255,211,255,255,255,254,0,0,0,0,0,3,255,255,255,254,0,0,0,0,0,1,87,253,85,254,0,0,127,255,255,248,2,248,0,254,0,0,127,255,255,248,2,248,0,254,0,0,127,255,255,248,2,248,0,254,0,0,0,0,0,0,2,248,0,254,0,0,0,0,0,0,2,248,0,254,0,0,0,0,0,0,2,248,0,254,0,0,11,255,255,208,2,248,0,254,0,0,11,255,255,208,2,248,0,254,0,0,10,170,170,144,2,248,0,254,0,0,0,0,0,7,255,255,252,254,0,0,0,0,0,7,255,255,252,254,0,0,11,255,255,215,255,255,252,254,0,0,11,255,255,209,87,249,84,254,0,0,11,255,255,208,3,244,0,254,0,0,0,0,0,0,3,244,0,254,0,0,0,0,0,0,3,240,0,254,0,0,11,255,255,208,7,240,0,190,0,0,15,255,255,208,11,240,0,191,0,0,15,255,255,208,15,224,0,191,0,0,15,208,11,208,15,208,0,127,0,0,15,208,11,208,47,192,0,127,0,0,15,208,11,208,63,192,0,63,8,0,15,208,11,208,127,128,0,63,79,0,15,208,11,208,255,0,0,63,79,64,15,208,11,210,254,0,0,47,143,0,15,255,255,215,252,0,0,31,223,0,15,255,255,239,244,0,0,15,255,0,15,255,255,255,240,0,0,15,254,0,15,208,0,11,192,0,0,3,252,0,5,64,0,2,0,0,0,1,244,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8a18  記
  24,138,36,35,59,38,1,252,7,255,255,244,0,0,0,0,0,7,255,255,244,47,255,255,255,224,7,255,255,244,47,255,255,255,224,0,0,0,0,47,255,255,255,224,0,0,0,0,21,85,85,95,224,127,255,255,254,0,0,0,15,224,127,255,255,254,0,0,0,15,224,127,255,255,254,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,11,255,255,240,0,0,0,15,224,11,255,255,240,0,0,0,15,224,10,170,170,160,5,85,85,95,224,0,0,0,0,31,255,255,255,224,0,0,0,0,31,255,255,255,224,11,255,255,240,31,255,255,255,224,11,255,255,240,31,192,0,15,224,11,255,255,240,31,192,0,15,224,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,11,255,255,240,31,192,0,0,0,15,255,255,240,31,192,0,0,0,15,255,255,240,31,192,0,0,0,15,208,3,240,31,192,0,0,0,15,208,3,240,31,192,0,0,144,15,208,3,240,31,192,0,0,253,15,208,3,240,31,192,0,0,253,15,208,3,240,31,192,0,0,253,15,208,3,240,31,192,0,0,252,15,255,255,240,31,224,0,3,252,15,255,255,240,15,255,255,255,248,15,255,255,240,11,255,255,255,240,15,208,0,0,2,255,255,255,208,5,64,0,0,0,21,85,84,0,
  // 0x8a2d  設
  45,138,36,35,59,38,1,252,7,255,255,208,31,255,255,240,0,11,255,255,224,31,255,255,240,0,11,255,255,224,31,255,255,240,0,0,0,0,0,31,192,11,240,0,0,0,0,0,31,192,7,240,0,127,255,255,252,31,192,7,240,0,127,255,255,252,31,192,7,240,0,127,255,255,252,47,192,7,240,120,0,0,0,0,63,128,7,240,126,0,0,0,0,127,64,7,240,126,0,0,0,0,255,0,7,240,189,11,255,255,225,253,0,7,255,252,11,255,255,231,252,0,3,255,252,10,170,170,171,244,0,1,255,240,0,0,0,2,208,0,0,0,0,0,0,0,0,64,0,0,0,0,11,255,255,226,255,255,255,255,208,11,255,255,226,255,255,255,255,192,11,255,255,226,255,255,255,255,192,0,0,0,0,6,128,0,63,128,0,0,0,0,47,192,0,191,0,11,255,255,224,15,224,1,254,0,15,255,255,224,7,244,3,252,0,15,255,255,224,3,252,11,248,0,15,208,7,224,1,255,31,240,0,15,208,7,224,0,191,255,208,0,15,208,7,224,0,63,255,128,0,15,208,7,224,0,15,255,0,0,15,208,7,224,0,63,255,64,0,15,208,7,224,2,255,255,240,0,15,255,255,224,47,255,191,254,64,15,255,255,231,255,252,11,255,248,15,255,255,239,255,208,0,255,252,15,208,0,3,253,0,0,27,244,5,64,0,2,128,0,0,0,160,
  // 0x8a66  試
  102,138,36,37,77,38,1,251,0,0,0,0,0,0,15,209,0,11,255,255,128,0,0,15,223,192,11,255,255,192,0,0,15,219,240,11,255,255,192,0,0,15,211,248,0,0,0,0,0,0,15,208,252,0,0,0,0,0,0,15,208,188,127,255,255,240,0,0,15,208,16,127,255,255,240,0,0,15,208,0,127,255,255,247,255,255,255,255,252,106,170,170,167,255,255,255,255,252,0,0,0,7,255,255,255,255,252,0,0,0,0,0,0,15,208,0,15,255,255,192,0,0,15,208,0,15,255,255,192,0,0,15,208,0,10,170,170,128,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,7,255,255,203,224,0,15,255,255,199,255,255,203,224,0,15,255,255,199,255,255,203,224,0,11,255,255,192,11,224,11,224,0,0,0,0,0,11,224,7,224,0,0,0,0,0,11,224,7,240,0,11,255,255,192,11,224,7,240,0,15,255,255,192,11,224,3,240,0,15,255,255,192,11,224,3,240,0,15,192,15,192,11,224,3,240,0,15,192,15,192,11,224,3,244,0,15,192,15,192,11,224,2,248,36,15,192,15,192,11,230,242,252,46,15,192,15,192,31,255,241,252,47,15,192,15,207,255,255,240,253,63,15,255,255,203,255,254,64,255,190,15,255,255,199,249,0,0,127,253,15,255,255,193,0,0,0,63,252,15,192,0,0,0,0,0,31,244,5,64,0,0,0,0,0,7,224,0,0,0,0,0,0,0,0,0,
  // 0x8a8d  認
  141,138,36,35,59,38,1,252,11,255,255,128,0,0,0,0,0,11,255,255,192,255,255,255,255,240,11,255,255,192,255,255,255,255,240,0,0,0,0,255,255,255,255,240,0,0,0,0,0,15,192,3,240,127,255,255,240,16,31,128,7,240,127,255,255,240,189,47,64,7,240,127,255,255,241,255,255,64,7,240,0,0,0,0,127,255,64,7,240,0,0,0,0,6,255,240,11,240,0,0,0,0,1,255,254,11,224,15,255,255,192,3,254,254,15,224,15,255,255,192,15,240,124,15,208,10,170,170,128,63,208,4,31,208,0,0,0,1,255,128,63,255,192,0,0,0,11,254,0,31,255,128,15,255,255,195,244,13,31,253,0,15,255,255,192,128,63,128,0,0,11,255,255,192,0,63,244,0,0,0,0,0,0,0,11,254,0,0,0,0,0,0,0,1,255,128,0,11,255,255,192,0,84,63,128,0,15,255,255,192,65,252,14,2,0,15,255,255,192,249,252,0,47,64,15,192,15,193,249,252,0,47,192,15,192,15,194,245,252,0,15,224,15,192,15,195,241,252,0,11,240,15,192,15,195,241,252,0,3,248,15,192,15,199,241,252,0,226,252,15,192,15,207,209,252,0,252,253,15,255,255,223,193,252,1,248,254,15,255,255,223,129,252,2,248,191,15,255,255,194,0,255,255,244,116,15,192,0,0,0,255,255,240,0,5,64,0,0,0,47,255,192,0,
  // 0x8aa4  誤
  164,138,36,35,59,38,1,252,7,255,255,64,0,63,255,255,224,11,255,255,64,0,63,255,255,224,11,255,255,64,0,63,255,255,224,0,0,0,2,248,63,64,11,224,0,0,0,2,248,63,64,11,224,127,255,255,210,248,63,64,11,224,127,255,255,226,248,63,64,11,224,127,255,255,226,248,63,64,11,224,0,0,0,2,248,63,64,11,224,0,0,0,2,248,63,255,255,224,0,0,0,2,248,63,255,255,224,15,255,255,66,248,63,255,255,224,15,255,255,66,248,0,0,0,0,10,170,170,66,248,0,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,2,255,255,255,255,128,15,255,255,66,255,255,255,255,128,15,255,255,66,255,255,255,255,128,11,255,255,66,248,0,0,63,128,0,0,0,0,80,0,0,63,128,0,0,0,0,0,0,0,63,128,15,255,255,64,0,0,0,63,128,15,255,255,79,255,255,255,255,254,15,255,255,79,255,255,255,255,254,15,192,31,79,255,255,255,255,254,15,192,31,64,0,64,0,16,0,15,192,31,64,3,240,1,244,0,15,192,31,64,11,252,3,253,0,15,192,31,64,31,240,1,255,0,15,192,31,64,127,208,0,127,192,15,255,255,65,255,128,0,47,240,15,255,255,75,254,0,0,15,248,15,255,255,111,248,0,0,3,253,15,192,0,15,208,0,0,1,253,5,64,0,2,0,0,0,0,144,
  // 0x8abf  調
  191,138,35,36,68,38,1,251,11,255,254,0,0,0,0,0,0,11,255,255,7,255,255,255,255,244,11,255,255,7,255,255,255,255,244,0,0,0,7,255,255,255,255,244,0,0,0,7,224,2,144,3,244,127,255,255,135,224,3,224,3,244,127,255,255,199,224,3,224,3,244,127,255,255,199,225,171,250,131,244,0,0,0,7,226,255,255,211,244,0,0,0,7,226,255,255,211,244,0,0,0,7,224,3,224,3,244,15,255,255,7,224,3,224,3,244,15,255,255,7,224,3,224,3,244,10,170,170,7,226,171,250,147,244,0,0,0,7,227,255,255,227,244,0,0,0,7,227,255,255,227,244,15,255,255,11,224,0,0,3,244,15,255,255,11,224,0,0,3,244,11,255,254,11,225,170,170,131,244,0,0,0,11,225,255,255,195,244,0,0,0,11,225,255,255,195,244,15,255,254,11,209,240,11,195,244,15,255,255,15,209,240,11,195,244,15,255,255,15,209,240,11,195,244,15,192,63,15,193,240,11,195,244,15,192,63,15,193,240,11,195,244,15,192,63,31,193,255,255,195,244,15,192,63,47,129,255,255,195,244,15,192,63,63,65,250,170,131,244,15,192,63,63,65,240,0,3,244,15,255,255,127,0,0,0,3,244,15,255,255,254,0,0,5,91,244,15,255,255,253,0,0,11,255,240,15,192,0,252,0,0,7,255,224,5,64,0,40,0,0,3,255,64,0,0,0,0,0,0,0,0,0,
  // 0x8acb  請
  203,138,36,36,68,38,1,252,0,0,0,0,0,2,248,0,0,7,255,255,192,0,3,248,0,0,11,255,255,209,170,171,254,170,164,11,255,255,209,255,255,255,255,248,0,0,0,1,255,255,255,255,248,0,0,0,0,0,3,248,0,0,127,255,255,248,0,3,248,0,0,127,255,255,248,127,255,255,255,240,127,255,255,248,127,255,255,255,240,0,0,0,0,21,87,253,85,80,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,11,255,255,215,255,255,255,255,253,11,255,255,215,255,255,255,255,253,10,170,170,146,170,170,170,170,168,0,0,0,0,0,0,0,0,0,0,0,0,0,26,170,170,170,128,11,255,255,208,47,255,255,255,192,11,255,255,208,47,255,255,255,192,11,255,255,208,47,128,0,15,192,0,0,0,0,47,128,0,15,192,0,0,0,0,47,213,85,95,192,11,255,255,208,47,255,255,255,192,15,255,255,208,47,255,255,255,192,15,255,255,208,47,128,0,15,192,15,208,11,208,47,128,0,15,192,15,208,11,208,47,255,255,255,192,15,208,11,208,47,255,255,255,192,15,208,11,208,47,213,85,111,192,15,208,11,208,47,128,0,15,192,15,208,11,208,47,128,0,15,192,15,255,255,208,47,128,0,15,192,15,255,255,208,47,128,0,31,192,15,255,255,208,47,128,15,255,192,15,208,0,0,47,128,15,255,128,5,64,0,0,47,128,7,249,0,
  // 0x8b70  議
  112,139,36,36,68,38,1,252,0,0,0,0,9,0,0,100,0,11,255,254,0,63,0,0,254,0,11,255,255,0,31,192,1,252,0,11,255,255,0,15,208,3,240,0,0,0,0,15,255,255,255,255,244,0,0,0,15,255,255,255,255,244,127,255,255,134,170,175,250,170,160,127,255,255,192,0,11,224,0,0,127,255,255,192,85,95,229,85,64,0,0,0,3,255,255,255,255,192,0,0,0,3,255,255,255,255,192,0,0,0,0,0,11,224,0,0,15,255,255,0,0,11,224,0,0,15,255,255,63,255,255,255,255,252,10,170,170,63,255,255,255,255,252,0,0,0,42,170,170,170,170,168,0,0,0,0,0,24,42,4,0,15,255,255,1,111,255,127,47,0,15,255,255,47,255,249,63,47,208,11,255,254,31,255,192,63,7,244,0,0,0,0,15,192,63,1,244,0,0,0,0,15,192,63,0,64,15,255,254,127,255,255,255,255,252,15,255,255,127,255,255,255,255,252,15,255,255,42,175,234,191,170,168,15,192,63,0,15,192,47,66,0,15,192,63,0,15,214,95,139,208,15,192,63,22,191,255,143,223,192,15,192,63,127,255,255,143,255,64,15,192,63,127,255,212,11,253,0,15,192,63,37,31,192,11,244,20,15,255,255,0,15,192,47,240,46,15,255,255,0,15,194,255,252,61,15,255,254,10,175,207,248,255,252,15,192,0,15,255,135,128,127,248,5,64,0,7,254,0,0,11,224,
  // 0x8b80  讀
  128,139,36,36,68,38,1,252,0,0,0,0,0,11,224,0,0,11,255,254,0,0,11,240,0,0,11,255,255,15,255,255,255,255,252,11,255,255,15,255,255,255,255,252,0,0,0,5,85,95,245,85,84,0,0,0,0,0,11,240,0,0,106,170,170,131,255,255,255,255,240,127,255,255,195,255,255,255,255,240,127,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,248,0,0,0,15,255,255,255,255,248,15,255,255,15,193,188,62,1,248,15,255,255,15,255,240,47,255,248,10,170,170,15,222,64,5,86,248,0,0,0,15,192,0,0,1,248,0,0,0,15,255,255,255,255,248,15,255,255,15,255,255,255,255,248,15,255,255,0,0,0,0,0,0,11,255,254,2,255,255,255,255,224,0,0,0,2,255,255,255,255,224,0,0,0,2,244,0,0,11,224,15,255,254,2,255,255,255,255,224,15,255,255,2,250,170,170,175,224,15,255,255,2,244,0,0,11,224,15,192,63,2,255,255,255,255,224,15,192,63,2,249,85,85,95,224,15,192,63,2,244,0,0,11,224,15,192,63,2,255,255,255,255,224,15,192,63,2,255,255,255,255,224,15,192,63,0,7,192,3,224,0,15,255,255,0,47,240,15,253,0,15,255,255,7,255,208,2,255,208,15,255,254,191,254,0,0,47,253,15,192,0,63,224,0,0,7,248,5,64,0,9,0,0,0,0,144,
  // 0x8b8a  變
  138,139,35,37,77,38,2,251,0,100,0,0,0,0,14,64,0,0,252,0,127,255,192,31,64,0,1,244,0,127,255,192,62,0,0,3,240,64,0,0,1,252,46,0,63,195,243,255,255,255,240,127,0,127,71,227,255,255,255,241,252,0,31,223,192,0,0,7,255,240,0,7,255,0,0,0,0,255,208,0,1,252,96,127,255,192,63,110,0,3,241,244,127,255,192,126,31,64,95,229,252,0,0,22,253,95,192,255,255,254,127,255,239,255,255,240,255,255,255,191,255,223,255,255,244,0,125,9,0,0,0,15,192,224,0,125,0,0,0,0,15,193,0,46,125,244,191,255,195,207,207,64,63,125,188,191,255,199,207,207,192,62,125,61,188,7,203,207,199,208,188,125,62,188,7,223,143,195,240,252,125,4,191,255,255,15,193,240,180,125,15,255,255,218,15,192,208,16,125,47,208,0,0,15,192,0,0,0,191,128,0,0,0,0,0,0,2,255,255,255,255,255,255,192,0,15,255,255,255,255,255,255,192,0,191,255,255,255,255,255,255,192,7,255,253,0,0,31,244,0,0,127,253,255,128,0,191,208,0,0,47,208,47,248,7,255,64,0,0,10,0,7,255,255,252,0,0,0,0,0,0,191,255,224,0,0,0,0,0,91,255,255,255,144,0,0,5,175,255,255,175,255,255,233,64,255,255,255,228,1,191,255,255,240,191,255,228,0,0,1,191,255,224,62,144,0,0,0,0,0,91,192,0,0,0,0,0,0,0,0,0,
  // 0x8cc7  資
  199,140,34,36,68,38,2,252,0,0,0,0,164,0,0,0,0,7,144,0,1,252,0,0,0,0,15,254,0,3,248,0,0,0,0,15,255,244,11,255,255,255,255,192,0,191,248,31,255,255,255,255,192,0,6,240,127,170,255,170,191,64,0,0,18,255,1,255,0,190,0,0,0,1,252,3,255,129,252,0,0,0,100,32,11,255,209,180,0,0,111,248,0,47,235,248,0,0,111,255,248,2,255,130,255,128,0,255,255,145,191,254,0,191,254,64,191,228,1,255,224,0,31,255,240,57,0,0,249,0,0,1,255,192,0,63,255,255,255,255,255,230,128,0,63,255,255,255,255,255,224,0,0,63,64,0,0,0,15,224,0,0,63,64,0,0,0,15,224,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,64,0,0,0,15,224,0,0,63,64,0,0,0,15,224,0,0,63,64,0,0,0,15,224,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,64,0,0,0,15,224,0,0,63,64,0,0,0,15,224,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,0,26,64,0,25,64,0,0,0,0,127,208,0,63,208,0,0,0,27,255,208,0,191,254,64,0,11,255,253,0,0,7,255,244,0,191,255,208,0,0,0,111,255,128,47,249,0,0,0,0,2,255,208,10,64,0,0,0,0,0,40,0,
  // 0x8ddd  距
  221,141,36,35,59,38,1,252,0,0,0,0,5,85,85,85,84,11,255,255,252,31,255,255,255,252,11,255,255,252,31,255,255,255,252,11,255,255,252,31,255,255,255,252,11,208,0,252,31,192,0,0,0,11,208,0,252,31,192,0,0,0,11,208,0,252,31,192,0,0,0,11,208,0,252,31,192,0,0,0,11,208,0,252,31,192,0,0,0,11,224,0,252,31,213,85,85,64,11,255,255,252,31,255,255,255,208,11,255,255,252,31,255,255,255,208,11,255,255,252,31,255,255,255,208,0,1,248,0,31,192,0,15,208,0,1,248,0,31,192,0,15,208,0,1,248,0,31,192,0,15,208,11,193,248,0,31,192,0,15,208,11,193,248,0,31,192,0,15,208,11,193,255,255,31,192,0,15,208,11,193,255,255,31,192,0,15,208,11,193,255,255,31,213,85,95,208,11,193,248,0,31,255,255,255,208,11,193,248,0,31,255,255,255,208,11,193,248,0,31,255,255,255,208,11,193,248,0,31,192,0,0,0,11,193,248,0,31,192,0,0,0,11,193,248,6,31,192,0,0,0,11,193,254,255,31,192,0,0,0,11,219,255,255,95,192,0,0,0,47,255,255,254,31,213,85,85,84,191,255,254,64,31,255,255,255,253,127,254,64,0,31,255,255,255,253,58,64,0,0,31,255,255,255,253,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,
  // 0x8eca  車
  202,142,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,252,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,253,0,3,248,0,7,240,0,0,253,0,3,248,0,7,240,0,0,253,0,3,248,0,7,240,0,0,255,170,171,254,170,175,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,253,0,3,248,0,7,240,0,0,253,0,3,248,0,7,240,0,0,253,0,3,248,0,7,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,3,252,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,
  // 0x8edf  軟
  223,142,36,36,68,38,1,252,0,1,252,0,0,122,0,0,0,0,1,252,0,0,127,0,0,0,0,1,252,0,0,191,0,0,0,0,1,252,0,0,254,0,0,0,63,255,255,255,208,253,0,0,0,63,255,255,255,208,253,0,0,0,63,255,255,255,209,252,0,0,0,0,1,252,0,2,255,255,255,248,0,1,252,0,3,255,255,255,252,0,1,252,0,3,255,255,255,248,15,255,255,255,203,240,254,3,248,15,255,255,255,207,224,253,3,244,15,234,254,175,223,208,253,3,240,15,128,248,15,239,192,253,7,240,15,128,248,15,255,128,253,7,224,15,149,249,95,255,0,253,11,208,15,255,255,255,254,0,253,15,192,15,255,255,255,204,0,253,15,192,15,128,248,15,192,0,254,0,64,15,128,248,15,192,0,254,0,0,15,128,248,15,192,1,255,0,0,15,255,255,255,192,2,255,0,0,15,255,255,255,192,3,255,64,0,10,171,254,170,64,7,255,192,0,0,1,252,0,0,15,223,192,0,0,1,252,0,0,31,203,224,0,127,255,255,255,240,63,131,240,0,127,255,255,255,240,191,3,252,0,127,255,255,255,241,254,1,253,0,0,1,252,0,3,252,0,255,64,0,1,252,0,15,244,0,63,208,0,1,252,0,127,224,0,47,244,0,1,252,2,255,192,0,15,254,0,1,252,3,254,0,0,3,253,0,1,252,0,248,0,0,0,248,0,1,248,0,80,0,0,0,32,
  // 0x8ef8  軸
  248,142,35,37,77,38,1,251,0,2,244,0,0,0,189,0,0,0,3,244,0,0,0,253,0,0,0,3,244,0,0,0,253,0,0,0,3,244,0,0,0,253,0,0,63,255,255,255,128,0,253,0,0,63,255,255,255,128,0,253,0,0,63,255,255,255,128,0,253,0,0,0,3,244,0,0,0,253,0,0,0,3,244,0,0,0,254,0,0,0,3,244,0,31,255,255,255,244,15,255,255,255,31,255,255,255,244,15,255,255,255,31,255,255,255,244,15,235,250,191,31,192,189,3,244,15,65,240,63,31,192,189,3,244,15,65,240,63,31,192,189,3,244,15,150,245,127,31,192,189,3,244,15,255,255,255,31,192,189,3,244,15,255,255,255,31,192,189,3,244,15,65,240,63,31,192,189,3,244,15,65,240,63,31,255,255,255,244,15,65,240,63,31,255,255,255,244,15,255,255,255,31,255,255,255,244,15,255,255,255,31,192,189,3,244,10,171,250,170,31,192,189,3,244,0,3,244,0,31,192,189,3,244,0,3,244,0,31,192,189,3,244,127,255,255,255,223,192,189,3,244,127,255,255,255,223,192,189,3,244,127,255,255,255,223,192,189,3,244,0,3,244,0,31,192,189,3,244,0,3,244,0,31,192,189,3,244,0,3,244,0,31,255,255,255,244,0,3,244,0,31,255,255,255,244,0,3,244,0,31,255,255,255,244,0,3,244,0,31,192,0,3,244,0,2,244,0,31,192,0,2,244,0,0,0,0,0,0,0,0,0,
  // 0x8f09  載
  9,143,35,36,68,38,2,252,0,0,190,0,0,190,0,0,0,0,0,190,0,0,254,7,208,0,0,0,190,0,0,254,15,244,0,15,255,255,255,240,254,3,253,0,15,255,255,255,240,254,0,255,64,15,255,255,255,240,254,0,127,192,0,0,190,0,0,254,0,47,64,0,0,190,0,0,190,0,13,0,0,0,190,0,0,190,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,190,0,0,127,0,0,0,0,0,190,0,0,127,0,0,0,63,255,255,255,252,127,0,62,64,63,255,255,255,252,63,0,127,0,26,170,255,170,164,63,64,191,0,0,0,190,0,0,63,64,253,0,15,255,255,255,240,63,129,252,0,15,255,255,255,240,63,131,248,0,15,128,125,2,240,47,199,244,0,15,128,125,2,240,47,207,240,0,15,255,255,255,240,31,239,208,0,15,255,255,255,240,15,255,192,0,15,128,125,2,240,15,255,0,0,15,128,125,2,240,11,254,0,0,15,255,255,255,240,11,252,1,64,15,255,255,255,240,15,248,1,224,0,0,190,0,0,63,248,1,244,106,170,255,170,168,255,252,2,244,127,255,255,255,255,255,254,2,244,127,255,255,255,255,252,191,67,240,0,0,190,0,191,240,63,235,240,0,0,190,0,255,192,31,255,224,0,0,190,0,62,0,11,255,192,0,0,189,0,20,0,1,190,0,
  // 0x8f2f  輯
  47,143,36,36,68,38,1,252,0,2,244,0,0,0,0,0,0,0,3,244,0,2,170,170,170,144,0,3,244,0,3,255,255,255,224,0,3,244,0,3,255,255,255,224,63,255,255,255,131,240,0,15,224,63,255,255,255,131,240,0,15,224,63,255,255,255,131,240,0,15,224,0,3,244,0,3,255,255,255,224,0,3,244,0,3,255,255,255,224,0,3,244,0,2,170,170,170,144,15,255,255,255,0,0,0,0,0,15,255,255,255,0,0,0,0,0,15,235,250,191,127,255,255,255,253,15,65,240,63,127,255,255,255,253,15,65,240,63,63,255,255,255,253,15,150,245,127,3,244,0,15,208,15,255,255,255,3,244,0,15,208,15,255,255,255,3,250,170,175,208,15,65,240,63,3,255,255,255,208,15,65,240,63,3,255,255,255,208,15,65,240,63,3,244,0,15,208,15,255,255,255,3,244,0,15,208,15,255,255,255,3,244,0,15,208,10,171,250,170,3,255,255,255,208,0,3,244,0,3,255,255,255,208,0,3,244,0,3,250,170,175,208,127,255,255,255,195,244,0,15,208,127,255,255,255,195,244,0,15,208,127,255,255,255,195,249,171,255,253,0,3,244,1,255,255,255,255,253,0,3,244,0,255,255,255,255,253,0,3,244,0,255,250,148,15,208,0,3,244,0,0,0,0,15,208,0,3,244,0,0,0,0,15,208,0,3,244,0,0,0,0,15,208,0,2,244,0,0,0,0,15,208,
  // 0x8f38  輸
  56,143,36,36,68,38,1,252,0,11,224,0,0,1,168,0,0,0,11,224,0,0,3,254,0,0,0,11,224,0,0,11,255,0,0,0,11,224,0,0,31,255,192,0,63,255,255,253,0,63,143,240,0,63,255,255,253,0,255,7,248,0,63,255,255,253,3,253,2,254,0,0,11,224,0,15,248,0,255,128,0,11,224,0,63,240,0,63,240,0,11,224,0,255,192,0,15,253,31,255,255,255,255,255,255,251,255,31,255,255,251,252,255,255,244,253,31,171,234,248,224,255,255,244,40,31,3,192,248,0,0,0,0,0,31,3,192,248,0,0,0,0,80,31,87,229,248,106,170,64,1,244,31,255,255,248,191,255,194,129,244,31,255,255,248,191,255,199,193,244,31,3,192,248,188,11,199,193,244,31,3,192,248,188,11,199,193,244,31,3,192,248,189,95,199,193,244,31,255,255,248,191,255,199,193,244,31,255,255,248,191,255,199,193,244,26,175,250,164,188,11,199,193,244,0,11,224,0,188,11,199,193,244,0,11,224,0,188,11,199,193,244,127,255,255,253,191,255,199,193,244,127,255,255,253,191,255,199,193,244,127,255,255,253,190,175,199,193,244,0,11,224,0,188,11,199,193,244,0,11,224,0,188,11,192,1,244,0,11,224,0,188,11,192,1,244,0,11,224,0,188,11,192,1,244,0,11,224,0,188,31,192,255,244,0,11,224,0,188,127,128,191,240,0,7,208,0,188,62,0,105,64,
  // 0x8f49  轉
  73,143,36,36,68,38,1,252,0,3,240,0,0,0,252,0,0,0,3,240,0,0,0,252,0,0,0,3,240,0,0,0,252,0,0,0,3,240,0,191,255,255,255,252,63,255,255,254,191,255,255,255,252,63,255,255,254,106,170,254,170,168,63,255,255,254,0,0,252,0,0,0,3,240,0,63,255,255,255,240,0,3,240,0,63,255,255,255,240,0,3,240,0,63,0,252,3,240,15,255,255,253,63,0,252,3,240,15,255,255,253,63,255,255,255,240,15,171,250,189,63,255,255,255,240,15,66,224,125,63,0,252,3,240,15,66,224,125,63,0,252,3,240,15,151,245,189,63,0,252,3,240,15,255,255,253,63,255,255,255,240,15,255,255,253,63,255,255,255,240,15,66,224,125,0,0,252,31,64,15,66,224,125,0,0,253,95,208,15,66,224,125,255,255,255,255,244,15,255,255,253,255,255,255,255,252,15,255,255,253,170,170,86,253,189,10,171,250,168,0,0,1,252,32,0,3,240,0,170,170,171,254,169,0,3,240,0,255,255,255,255,253,191,255,255,255,255,255,255,255,253,191,255,255,255,1,192,1,252,0,191,255,255,255,11,240,1,252,0,0,3,240,0,3,252,1,252,0,0,3,240,0,1,253,1,252,0,0,3,240,0,0,191,1,252,0,0,3,240,0,0,60,1,252,0,0,3,240,0,0,2,255,252,0,0,3,240,0,0,1,255,248,0,0,3,240,0,0,0,255,144,0,
  // 0x8fd1  近
  209,143,36,36,68,38,1,252,0,0,0,0,0,0,0,40,0,2,64,0,0,0,0,27,254,0,15,224,0,0,0,111,255,255,192,31,252,0,7,255,255,255,249,0,3,255,0,7,255,255,249,0,0,0,255,192,7,255,164,0,0,0,0,63,240,7,240,0,0,0,0,0,15,224,7,240,0,0,0,0,0,3,64,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,255,255,255,255,252,0,0,0,7,255,255,255,255,252,0,0,0,7,255,255,255,255,252,0,0,0,11,245,85,127,149,84,63,255,208,11,240,0,63,64,0,63,255,208,15,224,0,63,64,0,63,255,208,15,224,0,63,64,0,21,95,208,15,208,0,63,64,0,0,15,208,31,192,0,63,64,0,0,15,208,47,192,0,63,64,0,0,15,208,63,128,0,63,64,0,0,15,208,127,64,0,63,64,0,0,15,208,255,0,0,63,64,0,0,15,209,254,0,0,63,64,0,0,15,211,252,0,0,63,64,0,0,15,219,244,0,0,63,64,0,0,31,210,240,0,0,63,64,0,0,127,240,128,0,0,63,64,0,2,255,253,0,0,0,63,64,0,15,255,255,144,0,0,0,0,0,127,248,127,254,149,85,85,85,169,127,224,31,255,255,255,255,255,252,63,64,2,255,255,255,255,255,252,28,0,0,26,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0x8fd4  返
  212,143,36,35,59,38,1,252,2,64,0,0,0,0,0,0,0,15,208,0,31,255,255,255,255,240,31,248,0,31,255,255,255,255,240,7,254,0,31,255,255,255,255,240,1,255,128,31,213,85,85,85,80,0,127,208,31,192,0,0,0,0,0,31,224,31,192,0,0,0,0,0,11,64,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,47,255,255,255,255,128,0,0,0,47,255,255,255,255,128,0,0,0,47,255,255,255,255,64,0,0,0,47,239,192,0,191,0,0,0,0,47,207,208,0,254,0,63,255,192,47,139,240,1,253,0,63,255,192,63,135,244,3,252,0,63,255,192,63,131,252,11,244,0,21,111,192,63,65,254,31,240,0,0,47,192,127,0,191,127,208,0,0,47,192,191,0,63,255,128,0,0,47,192,255,0,31,255,0,0,0,47,192,253,0,15,253,0,0,0,47,193,252,0,63,255,64,0,0,47,195,252,1,255,255,240,0,0,47,199,244,27,255,127,254,0,0,47,207,241,255,252,11,255,228,0,47,203,210,255,224,1,255,252,0,127,241,192,255,0,0,47,244,2,255,252,0,52,0,0,1,224,15,255,255,128,0,0,0,0,0,127,244,191,254,149,85,85,85,105,127,208,47,255,255,255,255,255,252,63,64,2,255,255,255,255,255,252,28,0,0,27,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0x9000  退
  0,144,36,34,50,38,1,252,3,208,0,15,255,255,255,254,0,15,248,0,15,255,255,255,254,0,7,255,0,15,255,255,255,254,0,0,255,192,15,224,0,0,190,0,0,47,240,15,224,0,0,190,0,0,11,240,15,250,170,170,254,0,0,3,128,15,255,255,255,254,0,0,0,0,15,255,255,255,254,0,0,0,0,15,224,0,0,190,0,0,0,0,15,224,0,0,190,0,0,0,0,15,224,0,0,190,0,0,0,0,15,255,255,255,254,0,0,0,0,15,255,255,255,254,0,63,255,208,15,255,255,255,255,0,63,255,208,15,224,31,192,3,192,63,255,208,15,224,15,208,31,244,21,95,208,15,224,11,240,191,224,0,15,208,15,224,3,247,255,64,0,15,208,15,224,3,255,248,0,0,15,208,15,224,0,255,208,0,0,15,208,15,224,0,191,128,0,0,15,208,15,224,6,127,224,0,0,15,208,15,230,255,95,252,0,0,15,208,31,255,255,135,255,128,0,15,209,255,255,254,65,255,248,0,31,208,255,255,144,0,127,248,0,127,240,255,144,0,0,11,240,2,255,253,80,0,0,0,0,128,15,255,255,144,0,0,0,0,0,127,248,127,254,149,85,85,85,169,127,224,31,255,255,255,255,255,252,63,64,2,255,255,255,255,255,252,28,0,0,26,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0x901f  速
  31,144,36,36,68,38,1,252,0,0,0,0,0,63,64,0,0,2,64,0,0,0,63,64,0,0,15,224,0,0,0,63,64,0,0,31,248,0,0,0,63,64,0,0,7,255,3,255,255,255,255,255,248,1,255,195,255,255,255,255,255,248,0,63,243,255,255,255,255,255,248,0,15,240,0,0,63,64,0,0,0,7,128,0,0,63,64,0,0,0,1,0,0,0,63,64,0,0,0,0,0,127,255,255,255,255,192,0,0,0,127,255,255,255,255,192,0,0,0,127,170,255,234,191,192,0,0,0,127,0,63,64,15,192,0,0,0,127,0,63,64,15,192,63,255,208,127,0,63,64,15,192,63,255,208,127,0,63,64,15,192,63,255,208,127,255,255,255,255,192,21,95,208,127,255,255,255,255,192,0,15,208,127,255,255,255,255,192,0,15,208,0,7,255,244,0,0,0,15,208,0,31,255,253,0,0,0,15,208,0,127,191,255,128,0,0,15,208,1,255,63,95,240,0,0,15,208,11,252,63,71,253,0,0,15,208,127,240,63,65,255,192,0,15,211,255,192,63,64,127,248,0,31,211,254,0,63,64,31,240,0,127,240,244,0,63,64,2,208,2,255,253,0,0,63,64,0,0,15,255,255,144,0,21,0,0,0,127,248,127,254,149,85,85,85,169,127,224,31,255,255,255,255,255,252,63,64,2,255,255,255,255,255,252,28,0,0,26,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0x9023  連
  35,144,35,36,68,38,1,252,0,0,0,0,0,127,0,0,0,3,64,0,0,0,127,0,0,0,31,224,0,0,0,127,0,0,0,31,248,7,255,255,255,255,255,244,3,254,7,255,255,255,255,255,244,0,255,135,255,255,255,255,255,244,0,127,208,0,0,127,0,0,0,0,31,208,0,0,127,0,0,0,0,15,64,85,85,191,85,85,0,0,0,0,191,255,255,255,255,64,0,0,0,191,255,255,255,255,64,0,0,0,190,0,127,0,63,64,0,0,0,190,0,127,0,63,64,0,0,0,191,85,191,85,127,64,0,0,0,191,255,255,255,255,64,63,255,128,191,255,255,255,255,64,63,255,128,190,0,127,0,63,64,63,255,128,190,0,127,0,63,64,21,111,128,191,170,191,170,191,64,0,47,128,191,255,255,255,255,64,0,47,128,191,255,255,255,255,64,0,47,128,0,0,127,0,0,0,0,47,128,0,0,127,0,0,0,0,47,128,0,0,127,0,0,0,0,47,143,255,255,255,255,255,252,0,47,143,255,255,255,255,255,252,0,47,143,255,255,255,255,255,252,0,47,192,0,0,127,0,0,0,0,127,224,0,0,127,0,0,0,2,255,248,0,0,127,0,0,0,11,255,255,64,0,127,0,0,0,63,244,255,250,84,0,1,85,84,127,208,47,255,255,255,255,255,252,63,0,7,255,255,255,255,255,252,28,0,0,27,255,255,255,255,244,0,0,0,0,0,0,0,0,0,
  // 0x9032  進
  50,144,35,36,68,38,1,252,0,0,0,0,80,0,16,0,0,2,64,0,0,255,0,127,64,0,15,208,0,2,253,0,191,0,0,47,244,0,3,252,0,254,0,0,11,253,0,11,248,1,253,0,0,1,255,64,15,240,3,252,0,0,0,127,192,63,255,255,255,255,240,0,47,208,191,255,255,255,255,240,0,15,65,255,255,255,255,255,240,0,0,7,255,192,7,240,0,0,0,0,31,255,192,7,240,0,0,0,0,127,255,192,7,240,0,0,0,0,191,255,255,255,255,255,192,0,0,47,47,255,255,255,255,192,0,0,8,47,255,255,255,255,192,63,255,128,47,192,7,240,0,0,63,255,128,47,192,7,240,0,0,63,255,128,47,192,7,240,0,0,21,111,128,47,192,7,240,0,0,0,47,128,47,255,255,255,255,192,0,47,128,47,255,255,255,255,192,0,47,128,47,255,255,255,255,192,0,47,128,47,192,7,240,0,0,0,47,128,47,192,7,240,0,0,0,47,128,47,192,7,240,0,0,0,47,128,47,255,255,255,255,248,0,47,128,47,255,255,255,255,248,0,47,192,47,255,255,255,255,248,0,127,224,0,0,0,0,0,0,2,255,248,0,0,0,0,0,0,11,255,255,64,0,0,0,0,0,63,244,255,250,84,0,1,85,84,127,208,47,255,255,255,255,255,252,63,0,7,255,255,255,255,255,252,28,0,0,27,255,255,255,255,244,0,0,0,0,0,0,0,0,0,
  // 0x904b  運
  75,144,35,35,59,38,1,252,2,64,2,170,170,170,170,170,160,15,208,3,255,255,255,255,255,244,47,244,3,255,255,255,255,255,244,11,253,3,240,0,0,0,3,244,2,255,67,240,0,63,0,3,244,0,191,193,80,0,63,0,1,80,0,47,224,170,170,191,170,170,128,0,15,64,255,255,255,255,255,208,0,1,0,255,255,255,255,255,208,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,63,255,255,255,255,64,0,0,0,63,255,255,255,255,64,0,0,0,63,85,127,85,127,64,63,255,128,63,0,63,0,47,64,63,255,128,63,255,255,255,255,64,63,255,128,63,255,255,255,255,64,21,111,128,63,0,127,64,63,64,0,47,128,63,0,63,0,47,64,0,47,128,63,85,127,85,127,64,0,47,128,63,255,255,255,255,64,0,47,128,63,255,255,255,255,64,0,47,128,0,0,63,0,0,0,0,47,128,0,0,63,0,0,0,0,47,139,255,255,255,255,255,252,0,47,139,255,255,255,255,255,252,0,47,198,170,170,191,170,170,168,0,127,224,0,0,63,0,0,0,2,255,248,0,0,63,0,0,0,11,255,255,64,0,63,0,0,0,63,244,255,250,84,0,1,85,84,127,208,47,255,255,255,255,255,252,63,0,7,255,255,255,255,255,252,28,0,0,27,255,255,255,255,244,0,0,0,0,0,0,0,0,0,
  // 0x9054  達
  84,144,35,36,68,38,1,252,0,0,0,0,0,63,0,0,0,2,0,0,0,0,63,0,0,0,15,192,0,0,0,63,0,0,0,47,244,0,63,255,255,255,255,64,11,253,0,63,255,255,255,255,64,2,255,64,42,170,191,170,170,0,0,191,192,0,0,63,0,0,0,0,47,224,0,0,63,0,0,0,0,15,75,255,255,255,255,255,252,0,1,11,255,255,255,255,255,252,0,0,6,171,250,170,175,250,168,0,0,0,3,248,0,15,240,0,0,0,0,1,252,0,15,208,0,0,0,0,0,254,0,47,192,0,0,0,2,170,254,170,191,170,164,63,255,131,255,255,255,255,255,244,63,255,131,255,255,255,255,255,244,63,255,128,0,0,63,0,0,0,21,111,128,0,0,63,0,0,0,0,47,128,106,170,191,170,170,128,0,47,128,127,255,255,255,255,192,0,47,128,127,255,255,255,255,192,0,47,128,0,0,63,0,0,0,0,47,128,0,0,63,0,0,0,0,47,130,170,170,191,170,170,164,0,47,131,255,255,255,255,255,248,0,47,131,255,255,255,255,255,248,0,47,192,0,0,63,0,0,0,0,127,208,0,0,63,0,0,0,1,255,244,0,0,63,0,0,0,11,255,255,64,0,0,0,0,0,63,244,255,250,84,0,1,85,84,127,208,47,255,255,255,255,255,252,63,0,7,255,255,255,255,255,252,28,0,0,27,255,255,255,255,244,0,0,0,0,0,0,0,0,0,
  // 0x9078  選
  120,144,36,35,59,38,1,252,7,0,1,85,85,65,85,85,64,47,192,11,255,255,199,255,255,208,47,240,11,255,255,199,255,255,208,11,252,0,0,15,192,0,11,208,2,255,0,0,15,192,0,11,208,0,255,131,255,255,194,255,255,208,0,63,195,255,255,194,255,255,208,0,30,3,245,85,66,249,85,64,0,0,3,240,0,130,244,0,96,0,0,3,240,1,246,248,0,188,0,0,3,255,255,241,255,255,252,0,0,1,255,255,224,255,255,244,0,0,0,21,170,64,26,149,64,0,0,0,0,190,0,63,64,0,63,255,64,0,190,0,63,64,0,63,255,66,170,255,170,191,234,160,63,255,67,255,255,255,255,255,240,21,127,67,255,255,255,255,255,240,0,63,64,0,190,0,63,64,0,0,63,64,0,190,0,63,64,0,0,63,64,0,190,0,63,64,0,0,63,79,255,255,255,255,255,252,0,63,79,255,255,255,255,255,252,0,63,74,170,186,170,170,170,168,0,63,64,0,126,0,15,64,0,0,63,64,2,255,0,63,240,0,0,63,64,47,252,0,11,254,0,0,191,194,255,208,0,1,255,208,2,255,241,254,0,0,0,47,244,11,255,254,96,0,0,0,7,64,63,240,255,229,0,0,0,0,20,127,192,63,255,255,255,255,255,253,63,0,7,255,255,255,255,255,252,28,0,0,47,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0x9084  還
  132,144,35,35,59,38,1,252,3,64,1,255,255,255,255,255,192,31,224,1,255,255,255,255,255,192,31,248,1,252,31,129,248,15,192,7,254,1,248,15,128,248,15,192,1,255,65,248,15,128,248,15,192,0,191,193,248,15,128,248,15,192,0,47,225,255,255,255,255,255,192,0,15,129,255,255,255,255,255,192,0,5,0,0,0,0,0,0,0,0,0,5,85,85,85,85,85,84,0,0,15,255,255,255,255,255,252,0,0,15,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,128,63,255,255,255,255,0,63,255,128,63,255,255,255,255,0,63,255,128,63,0,0,0,191,0,21,111,128,63,0,0,0,191,0,0,47,128,63,255,255,255,255,0,0,47,128,63,255,255,255,255,64,0,47,128,0,7,255,0,31,224,0,47,128,0,31,255,192,127,192,0,47,128,0,255,255,245,254,0,0,47,128,11,254,255,255,244,0,0,47,129,255,244,254,191,224,0,0,47,139,255,192,254,31,255,64,0,47,195,253,0,254,2,255,248,0,127,224,208,0,254,0,111,240,2,255,248,0,0,254,0,1,192,11,255,255,64,0,169,0,0,0,63,244,255,250,84,0,1,85,84,127,208,47,255,255,255,255,255,252,63,0,7,255,255,255,255,255,252,28,0,0,27,255,255,255,255,244,0,0,0,0,0,0,0,0,0,
  // 0x908a  邊
  138,144,35,36,68,38,1,252,0,64,0,0,0,62,0,0,0,1,240,0,0,0,191,0,0,0,7,254,0,47,255,255,255,255,0,2,255,128,47,234,170,170,255,0,0,127,240,47,128,0,0,191,0,0,15,240,47,255,255,255,255,0,0,3,192,47,234,170,170,255,0,0,0,0,47,128,0,0,191,0,1,0,0,47,255,255,255,255,0,15,208,0,47,234,170,170,255,0,63,248,0,47,128,0,0,191,0,11,255,0,47,255,255,255,255,0,0,255,192,26,170,191,170,169,0,0,47,64,0,0,127,0,0,0,0,10,7,255,255,255,255,255,248,0,0,7,255,255,255,255,255,248,0,0,7,224,31,3,240,2,248,0,0,7,224,127,3,240,47,248,127,255,128,6,252,2,255,253,0,127,255,128,255,224,127,255,248,0,127,255,128,126,0,127,0,0,0,21,127,135,255,255,255,255,255,252,0,63,135,255,255,255,255,255,252,0,63,128,0,31,192,0,0,0,0,63,128,0,47,128,0,0,0,0,63,128,0,127,255,255,252,0,0,63,128,1,255,255,255,252,0,0,63,128,31,252,0,2,248,0,0,63,211,255,244,0,3,240,0,1,255,245,255,128,15,255,240,0,11,255,255,228,0,11,255,128,0,63,244,255,249,80,0,84,1,84,127,208,63,255,255,255,255,255,252,63,64,7,255,255,255,255,255,252,28,0,0,27,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0x90e8  部
  232,144,36,36,68,38,1,252,0,0,42,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,5,85,85,64,0,0,63,0,0,47,255,255,244,31,255,255,255,254,47,255,255,253,31,255,255,255,254,47,255,255,252,31,255,255,255,254,47,192,3,248,0,4,0,5,0,47,192,11,240,0,252,0,15,208,47,192,15,224,0,253,0,15,192,47,192,31,208,0,190,0,31,192,47,192,47,192,0,127,0,63,64,47,192,63,64,0,63,0,63,0,47,192,127,0,0,63,64,126,0,47,192,254,0,0,37,0,25,0,47,193,252,0,127,255,255,255,255,47,194,252,0,127,255,255,255,255,47,194,253,0,127,255,255,255,255,47,192,191,0,0,0,0,0,0,47,192,47,192,0,0,0,0,0,47,192,15,224,0,0,0,0,0,47,192,7,240,3,255,255,255,240,47,192,3,244,3,255,255,255,240,47,192,2,248,3,255,255,255,240,47,192,2,252,3,244,0,7,240,47,192,2,252,3,244,0,7,240,47,192,2,252,3,244,0,7,240,47,192,3,252,3,244,0,7,240,47,193,111,248,3,244,0,7,240,47,195,255,240,3,244,0,7,240,47,195,255,224,3,244,0,7,240,47,194,254,64,3,255,255,255,240,47,192,0,0,3,255,255,255,240,47,192,0,0,3,255,255,255,240,47,192,0,0,3,244,0,7,240,47,192,0,0,3,244,0,3,240,31,192,0,0,
  // 0x91cb  釋
  203,145,36,36,68,38,1,252,0,0,0,64,0,0,0,0,0,0,0,27,240,85,85,85,85,80,1,111,255,248,255,255,255,255,240,63,255,255,224,255,255,255,255,240,63,255,240,0,252,46,11,130,240,21,7,224,0,252,46,11,130,240,6,7,224,188,252,46,11,130,240,31,71,224,252,252,46,11,130,240,15,135,224,252,255,255,255,255,240,15,199,225,244,255,255,255,255,240,11,199,226,240,85,87,253,85,80,7,215,227,224,0,2,248,0,0,3,215,231,208,21,87,253,85,64,1,7,224,128,63,255,255,255,192,127,255,255,253,63,255,255,255,192,127,255,255,253,0,2,248,0,0,127,255,255,253,0,2,248,0,0,0,31,224,3,255,255,255,255,253,0,47,240,3,255,255,255,255,253,0,63,248,1,91,229,85,190,84,0,127,255,0,3,224,0,189,0,0,255,255,192,3,240,0,252,0,1,255,255,240,1,248,2,244,0,3,247,227,252,0,248,2,240,0,7,231,224,249,255,255,255,255,248,15,199,224,113,255,255,255,255,248,31,199,224,0,170,171,254,170,164,63,71,224,0,0,2,248,0,0,191,7,224,0,106,171,254,170,144,61,7,224,0,127,255,255,255,240,40,7,224,0,127,255,255,255,240,0,7,224,0,0,2,248,0,0,0,7,224,0,0,2,248,0,0,0,7,224,0,0,2,248,0,0,0,7,224,0,0,2,248,0,0,0,7,224,0,0,2,248,0,0,
  // 0x91cd  重
  205,145,34,35,59,38,2,253,0,0,0,0,0,0,22,128,0,0,0,0,5,106,255,255,192,0,2,255,255,255,255,255,255,240,0,1,255,255,255,255,255,233,64,0,1,255,170,151,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,254,85,87,253,85,91,240,0,0,254,0,3,248,0,7,240,0,0,254,0,3,248,0,11,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,254,0,3,248,0,7,240,0,0,254,0,3,248,0,7,240,0,0,255,85,87,253,85,91,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,3,255,255,255,255,255,255,253,0,3,255,255,255,255,255,255,254,0,3,255,255,255,255,255,255,254,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x91cf  量
  207,145,34,34,50,38,2,253,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,0,0,0,0,31,192,0,0,63,0,0,0,0,31,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,0,0,0,0,31,192,0,0,63,0,0,0,0,31,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,160,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,253,0,3,248,0,7,240,0,0,253,0,3,248,0,7,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,253,0,3,248,0,7,240,0,0,253,0,3,248,0,7,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,3,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,252,0,1,85,85,87,253,85,85,84,0,0,0,0,3,248,0,0,0,0,170,170,170,171,254,170,170,170,160,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x91dd  針
  221,145,36,36,68,38,1,252,0,2,253,0,0,0,106,0,0,0,3,255,64,0,0,127,0,0,0,11,255,208,0,0,127,0,0,0,15,255,248,0,0,127,0,0,0,63,199,254,0,0,127,0,0,0,191,65,255,64,0,127,0,0,1,255,0,127,208,0,127,0,0,3,252,0,31,240,0,127,0,0,15,244,0,11,224,0,127,0,0,63,208,0,3,128,0,127,0,0,255,255,255,254,0,0,127,0,0,63,255,255,253,0,0,127,0,0,5,255,255,253,21,85,191,149,85,0,0,252,0,63,255,255,255,254,0,0,252,0,63,255,255,255,254,0,0,252,0,63,255,255,255,254,0,1,252,0,0,0,127,0,0,47,255,255,255,192,0,127,0,0,47,255,255,255,192,0,127,0,0,47,255,255,255,192,0,127,0,0,0,0,252,0,0,0,127,0,0,0,0,252,4,0,0,127,0,0,11,192,252,31,128,0,127,0,0,11,192,252,47,64,0,127,0,0,7,208,252,63,0,0,127,0,0,3,224,252,62,0,0,127,0,0,3,240,252,125,0,0,127,0,0,2,240,252,188,0,0,127,0,0,1,240,252,20,0,0,127,0,0,0,0,252,22,208,0,127,0,0,0,1,255,255,208,0,127,0,0,26,255,255,255,208,0,127,0,0,63,255,255,254,64,0,127,0,0,47,255,233,0,0,0,127,0,0,30,144,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,
  // 0x9215  鈕
  21,146,36,36,68,38,1,252,0,7,240,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,31,255,0,21,85,85,85,0,0,63,255,208,63,255,255,255,128,0,127,111,240,63,255,255,255,128,0,254,11,252,63,255,255,255,128,3,252,3,255,0,63,128,63,128,11,244,0,255,0,63,64,63,128,31,224,0,61,0,63,64,63,128,127,192,0,40,0,63,64,63,64,191,255,255,240,0,63,0,63,64,47,255,255,240,0,127,0,63,64,3,255,255,240,0,127,0,63,64,0,3,240,0,0,127,0,63,64,0,3,240,0,0,127,0,63,64,0,3,240,0,0,191,0,63,64,63,255,255,252,255,255,255,255,254,63,255,255,252,255,255,255,255,254,63,255,255,252,255,255,255,255,254,0,3,240,0,85,254,85,191,84,0,3,240,0,0,253,0,127,0,11,3,240,252,0,252,0,127,0,15,131,240,252,0,252,0,127,0,15,195,240,248,1,252,0,127,0,11,195,241,240,1,252,0,191,0,7,211,242,240,2,252,0,191,0,3,211,243,224,2,248,0,191,0,3,227,243,208,2,248,0,191,0,2,67,240,0,3,248,0,190,0,0,3,240,26,3,244,0,254,0,0,7,255,255,3,244,0,254,0,6,191,255,255,87,249,85,255,84,63,255,255,255,255,255,255,255,254,63,255,228,11,255,255,255,255,254,46,144,0,11,255,255,255,255,254,0,0,0,0,0,0,0,0,0,
  // 0x932f  錯
  47,147,36,36,68,38,1,252,0,7,240,0,0,252,1,248,0,0,15,252,0,0,252,2,248,0,0,31,255,0,0,252,2,248,0,0,63,255,192,0,252,2,248,0,0,127,111,240,0,252,2,248,0,0,254,11,252,191,255,255,255,248,3,252,2,254,191,255,255,255,248,11,244,0,255,255,255,255,255,248,31,224,0,62,0,252,2,248,0,127,192,0,24,0,252,2,248,0,191,255,255,240,0,252,2,248,0,47,255,255,240,0,252,2,248,0,3,255,255,240,0,252,2,248,0,0,3,240,3,255,255,255,255,253,0,3,240,3,255,255,255,255,253,0,3,240,3,255,255,255,255,253,63,255,255,253,0,0,0,0,0,63,255,255,252,0,0,0,0,0,63,255,255,252,0,0,0,0,0,0,3,240,0,15,255,255,255,208,0,3,240,0,15,255,255,255,208,6,3,240,184,15,255,255,255,208,15,67,240,252,15,192,0,15,208,15,195,240,248,15,192,0,15,208,11,195,241,244,15,192,0,15,208,7,211,242,240,15,234,170,175,208,3,211,243,224,15,255,255,255,208,3,227,243,208,15,255,255,255,208,2,131,240,64,15,192,0,15,208,0,3,241,190,15,192,0,15,208,0,27,255,255,15,192,0,15,208,47,255,255,255,15,255,255,255,208,63,255,255,144,15,255,255,255,208,63,254,80,0,15,255,255,255,208,25,64,0,0,15,192,0,15,208,0,0,0,0,10,128,0,10,128,
  // 0x9375  鍵
  117,147,36,36,68,38,1,252,0,15,208,0,0,0,10,128,0,0,31,240,0,0,0,15,128,0,0,63,252,0,0,0,15,128,0,0,127,255,31,255,138,175,234,160,0,254,127,175,255,79,255,255,240,1,252,47,255,255,15,255,255,240,3,248,15,240,63,0,15,130,240,15,240,3,240,125,0,15,130,240,47,192,2,192,252,106,191,235,254,191,64,0,64,252,191,255,255,254,255,255,255,129,248,191,255,255,254,63,255,255,130,240,0,15,130,240,7,255,255,131,240,0,15,130,240,0,15,192,7,224,10,175,235,240,0,15,192,11,255,223,255,255,240,0,15,192,15,255,223,255,255,240,63,255,255,239,255,192,15,128,0,63,255,255,219,75,192,15,128,0,63,255,255,192,11,192,15,128,0,0,15,192,1,15,223,255,255,240,0,15,192,15,15,159,255,255,240,10,15,199,207,79,159,255,255,240,31,15,203,143,159,64,15,128,0,15,79,203,139,239,0,15,128,0,15,79,207,71,255,63,255,255,252,11,143,207,3,254,63,255,255,252,11,207,223,3,252,63,255,255,252,7,207,201,1,252,0,15,128,0,6,79,192,2,253,0,15,128,0,0,15,198,147,255,0,15,128,0,0,31,255,239,255,224,15,128,0,47,255,255,255,207,254,64,0,0,63,255,254,255,3,255,255,255,254,63,249,3,253,0,191,255,255,253,20,0,1,244,0,6,255,255,252,0,0,0,80,0,0,0,0,0,
  // 0x9577  長
  119,149,34,35,59,38,2,251,0,7,255,255,255,255,255,240,0,0,7,255,255,255,255,255,240,0,0,7,255,255,255,255,255,240,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,255,255,255,255,255,192,0,0,7,255,255,255,255,255,192,0,0,7,255,255,255,255,255,192,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,255,255,255,255,255,192,0,0,7,255,255,255,255,255,192,0,0,7,255,255,255,255,255,192,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,7,240,2,252,0,0,52,0,0,7,240,0,254,0,1,254,0,0,7,240,0,191,64,15,254,0,0,7,240,0,63,192,191,244,0,0,7,240,0,31,247,255,128,0,0,7,240,0,11,255,248,0,0,0,7,240,0,3,255,208,0,0,0,7,240,0,0,255,224,0,0,0,7,240,26,253,63,254,0,0,0,11,255,255,253,11,255,228,0,11,255,255,255,253,1,255,255,208,15,255,255,250,64,0,31,255,240,11,255,164,0,0,0,1,255,208,6,64,0,0,0,0,0,7,128,0,0,0,0,0,0,0,0,0,
  // 0x9589  閉
  137,149,32,34,16,38,3,252,191,255,255,244,47,255,255,255,191,255,255,244,47,255,255,255,191,170,171,244,47,234,170,255,191,0,3,244,47,192,0,255,191,0,3,244,47,192,0,255,191,255,255,244,47,255,255,255,191,255,255,244,47,255,255,255,191,170,171,244,47,234,170,255,191,0,3,244,47,192,0,255,191,0,3,244,47,192,0,255,191,170,171,244,47,234,170,255,191,255,255,244,47,255,255,255,191,255,255,244,47,255,255,255,191,0,0,0,0,0,0,255,191,0,0,0,63,0,0,255,191,0,0,0,63,0,0,255,191,0,0,0,63,0,0,255,191,7,255,255,255,255,208,255,191,7,255,255,255,255,208,255,191,7,255,255,255,255,208,255,191,0,0,3,255,0,0,255,191,0,0,15,255,0,0,255,191,0,0,63,255,0,0,255,191,0,0,255,127,0,0,255,191,0,3,253,63,0,0,255,191,0,31,244,63,0,0,255,191,0,255,208,63,0,0,255,191,11,255,0,63,0,0,255,191,15,252,0,63,0,0,255,191,3,208,0,63,0,0,255,191,1,0,63,255,10,170,254,191,0,0,47,254,15,255,254,191,0,0,15,228,7,255,252,191,0,0,0,0,3,255,224,
  // 0x958b  開
  139,149,32,35,24,38,3,251,191,255,255,244,47,255,255,255,191,255,255,244,47,255,255,255,191,170,171,244,47,234,170,255,191,0,3,244,47,192,0,191,191,0,3,244,47,192,0,191,191,255,255,244,47,255,255,255,191,255,255,244,47,255,255,255,191,85,87,244,47,213,85,255,191,0,3,244,47,192,0,191,191,0,3,244,47,192,0,191,191,170,171,244,47,234,170,255,191,255,255,244,47,255,255,255,191,255,255,244,47,255,255,255,191,0,0,0,0,0,0,191,191,0,0,0,0,0,0,191,191,3,255,255,255,255,192,191,191,3,255,255,255,255,192,191,191,3,255,255,255,255,192,191,191,0,7,224,15,192,0,191,191,0,7,224,15,192,0,191,191,0,7,224,15,192,0,191,191,0,7,224,15,192,0,191,191,15,255,255,255,255,240,191,191,15,255,255,255,255,240,191,191,15,255,255,255,255,240,191,191,0,11,208,15,192,0,191,191,0,15,192,15,192,0,191,191,0,31,192,15,192,0,191,191,0,63,128,15,192,0,191,191,0,127,0,15,192,0,191,191,1,254,0,15,193,85,254,191,7,252,0,15,194,255,254,191,2,240,0,15,192,255,252,191,0,128,0,0,0,255,224,0,0,0,0,0,0,0,0,
  // 0x9593  間
  147,149,32,34,16,38,3,252,191,255,255,244,47,255,255,255,191,255,255,244,47,255,255,255,191,170,171,244,47,234,170,255,191,0,3,244,47,192,0,255,191,0,3,244,47,192,0,255,191,255,255,244,47,255,255,255,191,255,255,244,47,255,255,255,191,170,171,244,47,234,170,255,191,0,3,244,47,192,0,255,191,0,3,244,47,192,0,255,191,170,171,244,47,234,170,255,191,255,255,244,47,255,255,255,191,255,255,244,47,255,255,255,191,0,0,0,0,0,0,255,191,0,0,0,0,0,0,255,191,0,0,0,0,0,0,255,191,0,63,255,255,252,0,255,191,0,63,255,255,252,0,255,191,0,63,170,171,252,0,255,191,0,63,0,0,252,0,255,191,0,63,0,0,252,0,255,191,0,63,0,0,252,0,255,191,0,63,255,255,252,0,255,191,0,63,255,255,252,0,255,191,0,63,170,170,252,0,255,191,0,63,0,0,252,0,255,191,0,63,0,0,252,0,255,191,0,63,170,170,252,0,255,191,0,63,255,255,252,0,255,191,0,63,255,255,252,0,255,191,0,63,0,0,10,170,254,191,0,63,0,0,7,255,254,191,0,0,0,0,3,255,252,191,0,0,0,0,2,255,224,
  // 0x95dc  關
  220,149,32,35,24,38,3,252,85,85,85,80,21,85,85,85,191,255,255,244,47,255,255,255,191,255,255,244,47,255,255,255,190,0,3,244,47,192,0,191,190,0,3,244,47,192,0,191,191,0,3,244,47,192,0,191,191,255,255,244,47,255,255,255,191,255,255,244,47,255,255,255,190,0,3,244,47,192,0,191,190,0,3,244,47,192,0,191,191,85,87,244,47,213,85,255,191,255,255,244,47,255,255,255,191,255,255,244,47,255,255,255,190,0,15,64,3,224,0,191,190,0,62,0,11,192,0,191,190,3,188,32,239,4,0,191,190,11,240,249,253,47,0,191,190,1,246,224,125,124,0,191,190,0,127,192,31,244,0,191,190,0,63,116,11,215,64,191,190,0,188,60,31,67,192,191,190,15,255,254,255,255,224,191,190,15,255,255,255,255,240,191,190,0,0,9,0,0,160,191,190,2,128,188,61,7,128,191,190,3,208,188,61,7,192,191,190,3,208,188,61,7,192,191,190,3,208,188,61,11,192,191,190,3,255,248,63,255,192,191,190,3,255,248,63,255,192,191,190,0,2,240,61,0,0,191,190,0,11,240,61,0,191,255,190,0,191,192,61,0,63,254,190,0,126,0,61,0,63,248,190,0,16,0,0,0,21,64,
  // 0x964d  降
  77,150,34,36,68,38,3,252,0,0,0,0,3,160,0,0,0,0,0,0,0,11,240,0,0,0,255,255,244,0,31,208,0,0,0,255,255,252,0,63,255,255,224,0,255,255,252,0,255,255,255,248,0,252,3,244,2,255,255,255,240,0,252,3,240,11,252,0,15,224,0,252,7,240,47,255,0,47,192,0,252,11,224,255,255,128,127,128,0,252,15,195,254,31,209,255,0,0,252,31,192,248,11,251,252,0,0,252,47,64,16,3,255,240,0,0,252,63,0,0,0,255,224,0,0,252,63,0,0,7,255,248,0,0,252,63,64,0,127,255,255,144,0,252,31,192,11,255,225,255,254,64,252,11,225,255,255,0,47,255,208,252,3,241,255,244,7,242,255,128,252,3,244,254,64,7,240,11,0,252,2,248,80,0,7,240,0,0,252,1,252,63,255,255,255,255,0,252,1,252,63,255,255,255,255,0,252,1,252,63,255,255,255,255,0,252,3,248,2,244,7,240,0,0,252,255,244,2,244,7,240,0,0,252,191,240,2,244,7,240,0,0,252,127,128,2,244,7,240,0,0,252,0,3,255,255,255,255,255,192,252,0,3,255,255,255,255,255,192,252,0,3,255,255,255,255,255,192,252,0,0,0,0,7,240,0,0,252,0,0,0,0,7,240,0,0,252,0,0,0,0,7,240,0,0,252,0,0,0,0,7,240,0,0,252,0,0,0,0,7,240,0,0,252,0,0,0,0,7,240,0,0,
  // 0x9664  除
  100,150,34,36,68,38,3,252,0,0,0,0,1,252,0,0,0,0,0,0,0,3,255,0,0,0,255,255,244,0,11,255,128,0,0,255,255,252,0,31,255,224,0,0,255,255,252,0,63,203,244,0,0,252,3,244,0,255,3,253,0,0,252,3,240,3,253,0,255,128,0,252,7,240,15,244,0,63,224,0,252,11,208,127,208,0,15,252,0,252,15,194,255,64,0,3,255,128,252,31,143,253,0,0,0,191,224,252,47,79,251,255,255,255,239,192,252,63,3,139,255,255,255,199,64,252,63,0,11,255,255,255,192,0,252,47,128,0,0,253,0,0,0,252,15,192,0,0,253,0,0,0,252,11,224,0,0,253,0,0,0,252,3,240,0,0,253,0,0,0,252,3,244,0,0,253,0,0,0,252,2,248,255,255,255,255,255,0,252,1,252,255,255,255,255,255,0,252,1,252,255,255,255,255,255,0,252,1,252,0,0,253,0,0,0,252,3,248,0,0,253,0,0,0,252,255,244,31,128,253,11,192,0,252,191,240,47,128,253,15,208,0,252,127,128,63,64,253,11,240,0,252,0,0,191,0,253,3,252,0,252,0,1,253,0,253,1,253,0,252,0,3,252,0,253,0,191,0,252,0,15,240,0,253,0,63,64,252,0,47,224,0,253,0,47,192,252,0,11,128,85,253,0,15,64,252,0,2,0,255,252,0,4,0,252,0,0,0,191,252,0,0,0,252,0,0,0,63,160,0,0,0,
  // 0x968e  階
  142,150,34,36,68,38,3,252,0,0,0,20,0,1,80,0,0,0,0,0,190,0,11,224,0,0,255,255,244,190,0,11,224,0,0,255,255,252,190,0,11,224,29,0,255,255,248,190,0,11,225,255,64,253,3,244,191,255,203,255,255,64,253,7,240,191,255,203,255,244,0,253,11,224,191,255,203,254,64,0,253,15,208,190,0,11,240,0,0,253,15,192,190,0,11,224,0,0,253,31,128,190,0,11,224,3,64,253,47,64,190,0,11,224,7,224,253,63,0,190,27,219,224,11,208,253,127,1,255,255,215,255,255,192,253,63,79,255,255,131,255,255,192,253,15,199,255,145,165,255,254,0,253,11,211,144,2,252,0,0,0,253,3,240,0,3,248,0,0,0,253,3,240,0,3,240,0,0,0,253,2,244,63,255,255,255,254,0,253,2,248,63,255,255,255,254,0,253,2,248,63,255,255,255,254,0,253,2,248,63,64,0,0,254,0,253,3,244,63,64,0,0,254,0,253,255,240,63,64,0,0,254,0,253,191,224,63,234,170,170,254,0,253,127,64,63,255,255,255,254,0,253,0,0,63,255,255,255,254,0,253,0,0,63,64,0,0,254,0,253,0,0,63,64,0,0,254,0,253,0,0,63,64,0,0,254,0,253,0,0,63,255,255,255,254,0,253,0,0,63,255,255,255,254,0,253,0,0,63,255,255,255,254,0,253,0,0,63,64,0,0,254,0,253,0,0,21,0,0,0,84,0,
  // 0x96d9  雙
  217,150,35,36,68,38,1,252,0,25,0,0,0,13,0,0,0,0,47,67,244,0,47,131,240,0,0,63,3,240,0,63,7,224,0,0,190,11,192,0,190,11,192,0,0,255,255,255,224,255,255,255,244,2,255,255,255,226,255,255,255,244,7,253,95,213,71,253,95,213,80,15,252,15,128,15,252,15,192,0,63,252,31,192,47,252,15,192,0,127,255,255,255,255,255,255,255,208,63,255,255,255,255,255,255,255,208,8,252,15,128,28,252,15,192,0,0,252,31,192,0,252,15,192,0,0,255,255,255,192,255,255,255,208,0,255,255,255,192,255,255,255,208,0,252,15,128,0,252,15,192,0,0,252,15,128,0,252,15,192,0,0,255,255,255,240,255,255,255,252,0,255,255,255,240,255,255,255,252,0,85,85,85,80,85,85,85,84,0,0,0,0,0,0,0,0,0,3,255,255,255,255,255,255,224,0,3,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,244,0,0,0,127,0,0,0,127,224,0,0,0,255,192,0,2,255,128,0,0,0,63,244,0,15,254,0,0,0,0,15,255,64,191,244,0,0,0,0,2,255,251,255,208,0,0,0,0,0,127,255,254,0,0,0,0,0,1,191,255,254,64,0,0,0,1,191,255,255,255,254,144,0,43,255,255,255,235,255,255,255,248,47,255,255,248,0,31,255,255,244,15,255,233,0,0,0,111,255,224,10,144,0,0,0,0,0,26,192,
  // 0x96e2  離
  226,150,36,36,68,38,1,252,0,0,253,0,0,2,64,0,0,0,0,253,0,0,7,240,47,128,0,0,253,0,0,11,240,63,128,127,255,255,255,252,15,208,63,64,127,255,255,255,252,15,192,127,0,127,255,255,255,252,47,192,190,0,0,0,0,0,0,63,128,252,0,1,64,3,208,0,127,65,252,0,11,199,15,199,208,191,255,255,252,11,207,239,71,208,255,255,255,252,11,194,255,7,210,255,255,255,252,11,192,255,135,211,255,1,248,0,11,195,255,231,223,255,1,248,0,11,207,226,231,255,255,1,248,0,11,223,128,135,255,255,1,248,0,11,193,0,7,239,191,255,255,248,11,255,255,255,210,127,255,255,248,11,255,255,255,208,127,255,255,248,5,85,254,85,64,127,1,248,0,0,0,252,0,0,127,1,248,0,0,0,252,0,0,127,1,248,0,47,255,255,255,244,127,1,248,0,47,255,255,255,244,127,1,248,0,47,235,250,171,244,127,255,255,248,47,66,240,2,244,127,255,255,248,47,67,242,194,244,127,255,255,248,47,67,226,226,244,127,1,248,0,47,67,209,242,244,127,1,248,0,47,127,255,246,244,127,1,248,0,47,127,255,250,244,127,1,248,0,47,85,80,126,244,127,1,248,0,47,64,0,18,244,127,255,255,253,47,64,0,2,244,127,255,255,253,47,64,1,255,240,127,255,255,253,47,64,0,255,224,127,0,0,0,47,64,0,170,64,127,0,0,0,
  // 0x96fb  電
  251,150,34,34,50,38,3,252,15,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,240,0,10,170,170,175,250,170,170,160,0,0,0,0,15,224,0,0,0,0,85,85,85,95,245,85,85,85,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,252,0,0,15,224,0,0,63,0,252,0,0,15,224,0,0,63,0,252,63,255,79,226,255,252,63,0,252,63,255,79,226,255,252,63,0,252,0,0,15,224,0,0,63,0,0,0,0,15,224,0,0,0,0,0,255,255,79,226,255,255,0,0,0,255,255,79,226,255,255,0,0,0,0,0,0,0,0,0,0,0,1,85,85,85,85,85,85,64,0,3,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,192,0,3,248,0,15,208,0,47,192,0,3,248,0,15,208,0,47,192,0,3,248,0,15,208,0,47,192,0,3,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,192,0,3,248,0,15,208,0,47,192,0,3,248,0,15,208,0,47,192,0,3,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,199,128,3,254,170,175,234,170,170,75,208,3,248,0,15,208,0,0,15,208,1,164,0,15,224,0,0,31,192,0,0,0,11,255,255,255,255,192,0,0,0,3,255,255,255,255,0,0,0,0,0,106,170,170,164,0,
  // 0x9752  青
  82,151,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,2,170,170,171,254,170,170,169,0,7,255,255,255,255,255,255,254,0,7,255,255,255,255,255,255,254,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,170,170,171,254,170,170,160,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,106,170,170,171,254,170,170,170,144,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,170,170,170,170,170,128,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,192,0,0,0,63,192,0,0,47,192,0,0,0,63,192,0,0,47,213,85,85,85,127,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,192,0,0,0,63,192,0,0,47,192,0,0,0,63,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,213,85,85,85,127,192,0,0,47,192,0,0,0,63,192,0,0,47,192,0,0,0,63,192,0,0,47,192,0,0,0,63,192,0,0,47,192,0,1,255,255,128,0,0,47,192,0,0,255,255,0,0,0,31,192,0,0,191,164,0,0,
  // 0x975e  非
  94,151,36,37,77,38,1,251,0,0,1,168,0,106,0,0,0,0,0,1,252,0,127,0,0,0,0,0,1,252,0,127,0,0,0,0,0,1,252,0,127,0,0,0,0,0,1,252,0,127,0,0,0,5,85,86,252,0,127,85,85,80,15,255,255,252,0,127,255,255,248,15,255,255,252,0,127,255,255,248,15,255,255,252,0,127,255,255,248,0,0,1,252,0,127,0,0,0,0,0,1,252,0,127,0,0,0,0,0,1,252,0,127,0,0,0,0,0,1,252,0,127,0,0,0,0,0,1,252,0,127,0,0,0,1,85,86,252,0,127,85,85,64,11,255,255,252,0,127,255,255,240,11,255,255,252,0,127,255,255,240,11,255,255,252,0,127,255,255,240,0,0,2,252,0,127,0,0,0,0,0,2,252,0,127,0,0,0,0,0,2,252,0,127,0,0,0,0,0,2,252,0,127,0,0,0,0,0,3,255,240,127,0,0,0,0,90,255,255,240,127,85,85,84,127,255,255,255,240,127,255,255,253,127,255,255,249,0,127,255,255,253,63,254,175,224,0,127,255,255,253,41,0,63,192,0,127,0,0,0,0,0,191,128,0,127,0,0,0,0,1,255,0,0,127,0,0,0,0,7,253,0,0,127,0,0,0,0,47,248,0,0,127,0,0,0,0,255,224,0,0,127,0,0,0,11,255,128,0,0,127,0,0,0,7,253,0,0,0,127,0,0,0,1,224,0,0,0,127,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9762  面
  98,151,34,34,50,38,2,252,21,85,85,85,85,85,85,85,80,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,0,0,0,11,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,31,208,0,0,0,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,208,15,208,0,254,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,255,255,253,0,191,0,15,208,15,255,255,253,0,191,0,15,208,15,255,255,253,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,255,255,253,0,191,0,15,208,15,255,255,253,0,191,0,15,208,15,255,255,253,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,192,0,189,0,191,0,15,229,95,213,85,254,85,191,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,208,0,0,0,0,0,191,0,15,208,0,0,0,0,0,191,0,
  // 0x9805  項
  5,152,36,34,50,38,1,252,0,0,0,15,255,255,255,255,253,0,0,0,15,255,255,255,255,253,21,85,85,95,255,255,255,255,253,63,255,255,240,0,7,248,0,0,63,255,255,240,0,11,240,0,0,63,255,255,240,0,15,240,0,0,0,31,192,0,170,175,250,170,160,0,31,192,0,255,255,255,255,240,0,31,192,0,255,255,255,255,240,0,31,192,0,252,0,0,7,240,0,31,192,0,252,0,0,7,240,0,31,192,0,252,0,0,7,240,0,31,192,0,255,255,255,255,240,0,31,192,0,255,255,255,255,240,0,31,192,0,254,85,85,91,240,0,31,192,0,252,0,0,7,240,0,31,192,0,252,0,0,7,240,0,31,192,0,252,0,0,7,240,0,31,192,0,255,255,255,255,240,0,31,193,184,255,255,255,255,240,0,31,255,248,254,85,85,91,240,0,31,255,252,252,0,0,7,240,6,255,255,208,252,0,0,7,240,191,255,248,0,252,0,0,7,240,127,254,64,0,255,255,255,255,240,63,208,0,0,255,255,255,255,240,20,0,0,0,170,170,170,170,160,0,0,0,0,3,192,0,208,0,0,0,0,0,31,244,7,253,0,0,0,0,1,255,240,7,255,128,0,0,0,31,255,128,0,191,244,0,0,2,255,248,0,0,15,254,0,0,0,255,128,0,0,2,253,0,0,0,52,0,0,0,0,96,
  // 0x9810  預
  16,152,36,35,59,38,1,251,47,255,255,253,255,255,255,255,252,47,255,255,254,255,255,255,255,252,47,255,255,252,255,255,255,255,252,0,0,11,240,0,2,253,0,0,0,0,31,224,0,2,252,0,0,2,208,63,128,0,3,248,0,0,7,253,255,0,47,255,255,255,240,7,255,252,0,47,255,255,255,240,0,191,244,0,47,234,170,175,240,0,15,253,0,47,128,0,7,240,0,2,255,128,47,128,0,7,240,0,0,127,64,47,128,0,7,240,191,255,255,255,175,255,255,255,240,191,255,255,255,175,255,255,255,240,191,255,255,255,111,213,85,91,240,0,11,240,63,47,128,0,7,240,0,11,240,126,47,128,0,7,240,0,11,240,189,47,128,0,7,240,0,11,240,252,47,255,255,255,240,0,11,241,248,47,255,255,255,240,0,11,241,244,47,213,85,91,240,0,11,240,16,47,128,0,7,240,0,11,240,0,47,128,0,7,240,0,11,240,0,47,128,0,7,240,0,11,240,0,47,255,255,255,240,0,11,240,0,47,255,255,255,240,0,11,240,0,26,170,170,170,160,0,11,240,0,0,160,0,32,0,0,11,240,0,2,253,1,253,0,0,11,240,0,31,253,2,255,128,5,95,240,0,191,244,0,127,240,15,255,224,27,255,128,0,15,252,11,255,208,31,253,0,0,2,253,7,254,0,3,208,0,0,0,176,0,0,0,0,0,0,0,0,0,
  // 0x984d  額
  77,152,36,37,77,38,1,251,0,2,248,0,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,2,248,0,47,255,255,255,252,47,255,255,255,239,255,255,255,252,63,255,255,255,239,255,255,255,252,63,255,255,255,192,0,254,0,0,63,0,0,15,192,0,253,0,0,63,2,64,15,192,1,252,0,0,63,11,224,15,198,171,254,170,160,0,15,192,0,7,255,255,255,240,0,63,255,253,7,255,255,255,240,0,191,255,253,7,240,0,7,240,1,254,86,252,7,240,0,7,240,7,248,3,248,7,240,0,7,240,47,254,7,240,7,255,255,255,240,191,255,223,208,7,255,255,255,240,46,47,255,192,7,250,170,171,240,4,7,255,0,7,240,0,7,240,0,3,255,192,7,240,0,7,240,0,31,255,244,7,240,0,7,240,0,127,215,254,7,255,255,255,240,7,255,65,255,135,255,255,255,240,127,252,0,63,199,250,170,171,240,127,254,170,191,71,240,0,7,240,63,255,255,253,7,240,0,7,240,3,255,255,252,7,240,0,7,240,3,240,0,252,7,255,255,255,240,3,240,0,252,7,255,255,255,240,3,240,0,252,6,170,170,170,160,3,240,0,252,0,36,0,16,0,3,240,0,252,0,190,0,253,0,3,255,255,252,7,255,1,255,128,3,255,255,252,47,252,0,63,240,3,254,170,174,255,224,0,11,252,3,240,0,2,254,0,0,1,254,1,80,0,0,160,0,0,0,116,0,0,0,0,0,0,0,0,0,
  // 0x985e  類
  94,152,36,36,68,38,1,252,0,0,80,0,0,0,0,0,0,6,2,248,30,0,0,0,0,0,15,194,248,47,111,255,255,255,252,11,210,248,63,47,255,255,255,252,3,226,248,189,47,255,255,255,252,3,226,248,252,0,0,254,0,0,0,2,248,0,0,1,253,0,0,63,255,255,255,192,2,252,0,0,63,255,255,255,203,255,255,255,240,47,255,255,255,203,255,255,255,240,0,15,253,0,11,250,170,175,240,0,63,255,128,11,224,0,7,240,0,255,255,244,11,224,0,7,240,3,254,250,255,11,224,0,7,240,15,242,248,127,203,255,255,255,240,127,194,248,31,75,255,255,255,240,47,2,248,2,11,250,170,171,240,8,1,244,0,11,224,0,7,240,0,0,0,0,11,224,0,7,240,0,2,248,0,11,224,0,7,240,0,2,248,0,11,255,255,255,240,0,2,248,0,11,255,255,255,240,63,255,255,255,203,250,170,171,240,63,255,255,255,203,224,0,7,240,63,255,255,255,203,224,0,7,240,0,3,244,0,11,250,170,175,240,0,3,248,0,11,255,255,255,240,0,11,255,64,11,255,255,255,240,0,15,255,224,0,0,0,0,0,0,63,223,252,0,40,0,36,0,0,255,131,255,64,255,65,254,0,7,254,0,191,71,255,0,255,192,127,248,0,30,127,248,0,47,244,63,208,0,7,255,208,0,7,253,30,0,0,1,254,0,0,1,253,0,0,0,0,96,0,0,0,32,
  // 0x98a8  風
  168,152,36,34,50,38,1,252,0,127,255,255,255,255,255,252,0,0,127,255,255,255,255,255,252,0,0,127,255,255,255,255,255,252,0,0,127,85,85,85,85,86,252,0,0,127,0,0,0,6,1,252,0,0,127,0,0,91,255,193,252,0,0,127,47,255,255,255,241,252,0,0,127,47,255,255,250,65,252,0,0,127,31,255,253,0,1,252,0,0,127,0,0,252,0,1,252,0,0,127,0,0,252,0,1,252,0,0,127,0,0,252,0,1,252,0,0,127,15,255,255,255,225,252,0,0,127,15,255,255,255,225,252,0,0,127,15,255,255,255,224,252,0,0,127,15,128,252,7,224,252,0,0,127,15,128,252,7,224,252,0,0,127,15,128,252,7,224,252,0,0,191,15,128,252,7,224,252,0,0,190,15,128,252,7,224,253,0,0,254,15,255,255,255,224,253,0,0,253,15,255,255,255,224,253,0,0,253,10,170,255,170,144,253,0,0,252,0,0,252,2,64,253,0,2,252,0,0,252,31,192,190,0,3,248,0,0,252,11,224,190,8,3,244,0,0,252,3,240,127,29,7,240,21,106,255,255,248,63,31,15,240,255,255,255,255,252,63,30,15,224,255,255,255,255,254,63,174,63,192,255,169,80,0,127,31,253,127,128,0,0,0,0,63,15,252,47,0,0,0,0,0,16,11,248,5,0,0,0,0,0,0,1,224,
  // 0x98fd  飽
  253,152,36,36,68,38,1,252,0,3,252,0,0,168,0,0,0,0,7,255,0,0,253,0,0,0,0,15,255,192,1,252,0,0,0,0,47,223,244,3,252,0,0,0,0,63,135,252,3,244,0,0,0,0,255,1,255,7,255,255,255,244,2,253,0,127,207,255,255,255,244,7,248,252,47,95,255,255,255,244,31,240,252,9,63,192,0,3,244,127,192,252,0,127,64,0,3,244,255,170,254,169,255,0,0,3,244,63,255,255,255,254,0,0,3,244,7,255,255,255,255,255,254,3,244,3,240,0,254,187,255,254,3,244,3,240,0,253,7,255,254,3,240,3,245,85,253,0,0,126,3,240,3,255,255,253,0,0,126,3,240,3,255,255,253,0,0,126,3,240,3,240,0,253,0,0,126,3,240,3,240,0,253,15,255,254,7,240,3,250,170,253,15,255,254,7,240,3,255,255,253,15,255,254,11,240,3,255,255,253,15,208,0,15,224,3,240,0,0,15,208,7,255,224,3,240,2,128,15,208,3,255,192,3,240,15,208,15,208,3,254,0,3,240,15,240,15,208,0,0,0,3,240,3,244,15,208,0,0,0,3,240,3,252,15,208,0,0,116,3,240,127,253,15,208,0,0,126,3,255,255,255,15,208,0,0,190,47,255,255,255,79,208,0,0,189,63,255,228,63,143,224,0,1,253,63,249,0,31,203,255,255,255,252,41,0,0,9,3,255,255,255,244,0,0,0,0,0,191,255,255,208,
  // 0x9918  餘
  24,153,36,36,68,38,1,252,0,7,244,0,0,2,252,0,0,0,15,253,0,0,7,253,0,0,0,31,255,64,0,15,255,0,0,0,63,175,208,0,31,255,128,0,0,191,11,244,0,63,223,208,0,1,253,3,252,0,255,79,240,0,7,248,0,255,2,254,3,252,0,31,255,255,254,11,252,2,255,0,127,239,255,172,31,244,0,191,192,255,5,85,64,191,224,0,63,240,60,0,0,2,255,128,0,15,252,5,85,85,87,255,0,0,7,254,3,255,255,249,247,255,255,255,252,3,255,255,248,147,255,255,255,120,3,240,1,248,3,255,255,255,0,3,240,1,248,0,1,252,0,0,3,255,255,248,0,1,252,0,0,3,255,255,248,0,1,252,0,0,3,245,85,248,255,255,255,255,248,3,240,1,248,255,255,255,255,248,3,245,86,248,255,255,255,255,248,3,255,255,248,0,1,252,0,0,3,255,255,248,0,1,252,1,0,3,240,0,0,10,129,252,47,0,3,240,0,0,15,193,252,47,128,3,250,170,168,31,129,252,15,192,3,255,255,252,47,65,252,15,224,3,255,255,252,63,1,252,7,240,3,240,0,0,190,1,252,3,244,3,240,0,0,252,1,252,2,252,3,255,255,255,248,1,252,1,252,3,255,255,254,240,1,252,0,253,3,255,255,253,16,1,252,0,160,3,240,0,0,0,255,252,0,0,3,240,0,0,0,191,244,0,0,3,224,0,0,0,127,144,0,0,
  // 0x99ac  馬
  172,153,35,35,59,38,1,251,0,47,255,255,255,255,255,255,0,0,47,255,255,255,255,255,255,0,0,47,255,255,255,255,255,255,0,0,47,128,0,127,0,0,0,0,0,47,128,0,127,0,0,0,0,0,47,128,0,127,0,0,0,0,0,47,255,255,255,255,255,248,0,0,47,255,255,255,255,255,248,0,0,47,255,255,255,255,255,248,0,0,47,128,0,127,0,0,0,0,0,47,128,0,127,0,0,0,0,0,47,128,0,127,0,0,0,0,0,47,255,255,255,255,255,248,0,0,47,255,255,255,255,255,248,0,0,47,255,255,255,255,255,248,0,0,47,128,0,127,0,0,0,0,0,47,128,0,127,0,0,0,0,0,47,128,0,127,0,0,0,0,0,47,255,255,255,255,255,255,244,0,47,255,255,255,255,255,255,244,0,47,255,255,255,255,255,255,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,64,7,240,0,189,0,0,24,7,224,7,240,0,253,15,192,126,3,244,7,240,0,252,15,208,63,1,252,11,240,1,252,11,208,63,64,253,11,240,3,248,7,224,31,128,127,15,240,7,244,7,240,15,192,61,15,224,15,240,3,240,15,192,0,15,208,31,224,3,240,11,208,0,63,208,127,192,3,240,5,0,191,255,192,47,64,1,64,0,0,127,255,64,5,0,0,0,0,0,63,253,0,0,0,0,0,0,0,0,0,0,
  // 0x9a45  驅
  69,154,36,36,68,38,1,251,10,170,170,168,106,170,170,170,168,15,255,255,252,127,255,255,255,248,15,255,255,252,127,255,255,255,248,15,255,255,252,125,0,0,0,0,15,192,248,0,125,0,0,0,0,15,192,248,0,125,0,0,0,0,15,234,254,160,125,3,255,255,64,15,255,255,244,125,3,255,255,64,15,255,255,244,125,3,208,15,64,15,192,248,0,125,3,208,15,64,15,192,248,0,125,3,208,15,64,15,192,248,0,125,3,208,15,64,15,234,254,164,125,3,224,31,64,15,255,255,244,125,3,255,255,64,15,255,255,244,125,3,255,255,64,15,192,248,0,125,0,0,0,0,15,192,248,0,125,0,0,0,0,15,192,248,0,125,63,252,191,248,15,255,255,252,125,63,252,191,248,15,255,255,253,125,60,60,180,184,15,255,255,253,125,56,60,176,120,0,0,0,188,125,56,60,176,120,0,0,0,188,125,56,60,176,120,14,2,108,188,125,56,60,176,120,15,115,157,188,125,56,60,176,120,30,118,207,188,125,60,124,180,184,30,117,199,252,125,63,252,191,248,46,56,211,252,125,63,252,191,248,45,56,224,252,125,0,0,0,0,60,56,144,252,125,0,0,0,0,124,52,0,248,127,170,170,170,169,184,0,1,248,127,255,255,255,253,16,0,171,244,127,255,255,255,253,0,0,191,240,125,0,0,0,0,0,0,191,128,125,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9ad4  體
  212,154,35,36,68,38,2,252,0,0,0,0,0,46,15,128,0,6,170,170,144,0,47,15,128,0,11,255,255,224,0,47,15,128,0,11,255,255,224,21,127,95,149,64,11,192,3,224,63,255,255,255,192,11,192,3,224,63,255,255,255,192,11,199,255,224,62,31,15,11,192,11,199,255,224,62,31,15,11,192,11,199,195,224,63,255,255,255,192,11,199,195,224,63,255,255,255,192,11,199,195,224,62,31,15,75,192,11,199,195,224,62,31,15,11,192,91,219,215,245,62,111,95,95,192,191,255,255,255,63,255,255,255,192,191,255,255,255,63,255,255,255,192,188,0,0,63,0,0,0,0,0,188,0,0,63,0,0,0,0,0,191,255,255,255,255,255,255,255,240,7,255,255,208,255,255,255,255,240,7,250,175,208,170,170,170,170,160,7,208,11,208,0,0,0,0,0,7,208,11,208,31,255,255,255,128,7,255,255,208,31,255,255,255,128,7,255,255,208,31,128,0,47,128,7,229,91,208,31,64,0,47,128,7,208,11,208,31,64,0,47,128,7,229,95,208,31,255,255,255,128,7,255,255,208,31,255,255,255,128,7,255,255,208,1,176,1,228,0,7,208,11,208,2,244,1,248,0,7,208,11,208,0,248,3,240,0,7,208,11,208,0,252,7,208,0,7,208,11,209,170,254,175,234,164,7,209,255,211,255,255,255,255,244,7,208,255,195,255,255,255,255,244,6,144,105,0,0,0,0,0,0,
  // 0x9ad8  高
  216,154,34,36,68,38,2,252,0,0,0,3,244,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,0,0,0,0,0,0,0,0,0,0,1,85,85,85,85,84,0,0,0,3,255,255,255,255,252,0,0,0,3,255,255,255,255,252,0,0,0,3,240,0,0,1,252,0,0,0,3,240,0,0,1,252,0,0,0,3,240,0,0,1,252,0,0,0,3,249,85,85,86,252,0,0,0,3,255,255,255,255,252,0,0,0,3,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,224,0,0,0,0,0,127,0,15,224,0,0,0,0,0,127,0,15,224,15,255,255,255,0,127,0,15,224,15,255,255,255,0,127,0,15,224,15,234,170,191,0,127,0,15,224,15,192,0,63,0,127,0,15,224,15,192,0,63,0,127,0,15,224,15,192,0,63,0,127,0,15,224,15,255,255,255,0,127,0,15,224,15,255,255,255,0,127,0,15,224,15,213,85,87,65,191,0,15,224,15,192,0,2,255,255,0,15,224,5,64,0,1,255,254,0,15,224,0,0,0,0,255,228,0,
  // 0x9ec3  黃
  195,158,34,36,68,38,2,252,0,0,127,0,0,15,208,0,0,0,0,127,0,0,15,208,0,0,0,0,127,0,0,15,208,0,0,15,255,255,255,255,255,255,255,64,15,255,255,255,255,255,255,255,64,10,170,255,234,170,175,250,170,0,0,0,127,0,0,15,208,0,0,0,0,127,0,0,15,208,0,0,0,0,127,255,255,255,208,0,0,0,0,127,255,255,255,208,0,0,0,0,21,85,85,85,64,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,191,255,255,255,255,255,240,0,0,191,255,255,255,255,255,240,0,0,191,170,171,254,170,175,240,0,0,190,0,3,248,0,11,240,0,0,190,0,3,248,0,11,240,0,0,191,255,255,255,255,255,240,0,0,191,255,255,255,255,255,240,0,0,191,85,87,253,85,91,240,0,0,190,0,3,248,0,11,240,0,0,190,0,3,248,0,11,240,0,0,191,255,255,255,255,255,240,0,0,191,255,255,255,255,255,240,0,0,106,175,170,170,175,234,160,0,0,1,191,128,0,47,248,0,0,0,31,255,192,0,127,255,224,0,7,255,253,0,0,2,255,254,64,255,255,144,0,0,0,27,255,240,127,244,0,0,0,0,0,191,192,29,0,0,0,0,0,0,6,0,
  // 0x9ede  點
  222,158,36,36,68,38,1,252,0,0,0,0,0,0,190,0,0,5,85,85,85,64,0,190,0,0,15,255,255,255,192,0,190,0,0,15,255,255,255,192,0,190,0,0,15,128,184,11,192,0,190,0,0,15,148,184,91,192,0,190,0,0,15,188,184,251,192,0,190,0,0,15,172,184,251,192,0,190,0,0,15,157,185,219,192,0,191,85,84,15,142,186,203,192,0,191,255,253,15,142,187,203,192,0,191,255,253,15,132,185,75,192,0,191,255,253,15,128,184,11,192,0,190,0,0,15,255,255,255,192,0,190,0,0,15,255,255,255,192,0,190,0,0,5,86,254,85,64,0,190,0,0,0,0,252,0,0,0,190,0,0,0,0,252,0,0,0,190,0,0,15,255,255,255,208,0,255,0,0,15,255,255,255,211,255,255,255,240,10,171,255,170,147,255,255,255,240,0,0,252,0,3,255,255,255,240,0,0,254,170,163,240,0,7,240,47,255,255,255,243,240,0,7,240,63,255,255,255,243,240,0,7,240,63,254,169,80,3,240,0,7,240,0,0,0,0,3,240,0,7,240,0,0,5,31,3,240,0,7,240,7,207,79,15,131,240,0,7,240,11,203,143,135,211,240,0,7,240,15,203,199,195,243,240,0,7,240,15,135,195,193,243,255,255,255,240,47,71,195,208,247,255,255,255,240,63,7,194,208,3,255,255,255,240,125,2,64,0,3,244,0,7,240,24,0,0,0,3,240,0,2,160,
  // 0x9f4a  齊
  74,159,36,37,77,38,1,251,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,47,255,255,255,255,255,255,255,244,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,0,0,0,5,0,180,0,0,0,0,0,0,63,0,252,0,10,0,5,85,85,111,130,248,6,255,192,15,255,255,219,195,243,255,255,64,15,255,255,211,130,211,255,248,0,0,126,7,208,253,3,240,252,0,0,189,7,208,253,3,224,125,0,0,252,11,192,253,3,224,63,0,1,248,11,192,253,3,224,47,128,3,244,15,192,253,3,245,175,224,31,227,255,128,253,63,255,247,248,127,131,255,0,253,63,255,226,253,46,1,84,0,253,42,80,0,116,0,7,240,0,0,0,7,240,0,0,7,240,0,0,0,7,240,0,0,7,250,170,170,170,175,240,0,0,7,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,240,0,0,0,7,240,0,0,11,240,0,0,0,7,240,0,0,15,240,0,0,0,7,240,0,0,15,255,255,255,255,255,240,0,0,31,255,255,255,255,255,240,0,0,63,250,170,170,170,175,240,0,0,127,192,0,0,0,7,240,0,1,255,64,0,0,0,7,240,0,7,255,0,0,0,0,7,240,0,31,252,0,0,0,0,7,240,0,11,240,0,0,0,0,7,240,0,3,192,0,0,0,0,7,240,0,0,0,0,0,0,0,0,0,0,
  // 0xff1a  ：
  26,255,6,25,50,38,16,1,63,192,255,240,255,240,255,240,191,224,47,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,192,255,240,255,240,255,240,191,224,47,128,
};

#endif // HAS_GRAPHICAL_TFT
