/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Latin Extended-A 38pt, capital 'A' height: 28px, width: 100%, range: 0x0100-0x017f
extern const uint8_t NotoSans_Medium_Latin_Extended_A_28[21187] = {
  130,28,0,1,127,1,37,246, // unifont_t
  // 0x0100  Ā
  25,33,231,25,0,0,0,7,255,255,240,0,0,0,7,255,255,240,0,0,0,7,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,
  // 0x0101  ā
  18,27,135,22,1,255,0,255,255,254,0,0,255,255,254,0,0,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,0,0,
  // 0x0102  Ă
  25,36,252,25,0,0,0,5,0,0,84,0,0,0,15,128,0,248,0,0,0,11,228,7,240,0,0,0,3,255,255,224,0,0,0,1,255,255,128,0,0,0,0,47,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,
  // 0x0103  ă
  18,30,150,22,1,255,0,80,0,5,0,1,240,0,47,0,0,253,1,190,0,0,127,255,252,0,0,47,255,244,0,0,6,255,128,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,0,0,
  // 0x0104  Ą
  25,37,3,25,0,247,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,0,0,0,0,0,188,0,0,0,0,0,2,244,0,0,0,0,0,7,224,0,0,0,0,0,15,192,0,0,0,0,0,15,192,0,0,0,0,0,15,224,0,0,0,0,0,11,255,128,0,0,0,0,3,255,128,0,0,0,0,0,105,0,
  // 0x0105  ą
  19,30,150,22,1,247,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,11,192,0,0,0,47,64,0,0,0,126,0,0,0,0,252,0,0,0,0,252,0,0,0,0,253,0,0,0,0,191,248,0,0,0,63,248,0,0,0,6,144,
  // 0x0106  Ć
  21,37,222,24,2,255,0,0,0,31,248,0,0,0,0,63,224,0,0,0,0,191,128,0,0,0,1,254,0,0,0,0,3,248,0,0,0,0,11,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,85,0,0,0,1,255,255,249,0,0,31,255,255,255,128,0,127,255,255,255,0,1,255,244,1,191,0,3,255,64,0,4,0,15,252,0,0,0,0,31,244,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,192,0,0,0,0,127,192,0,0,0,0,63,208,0,0,0,0,63,240,0,0,0,0,31,244,0,0,0,0,15,252,0,0,0,0,7,255,64,0,0,0,2,255,249,1,111,0,0,191,255,255,255,0,0,31,255,255,255,0,0,2,255,255,249,0,0,0,1,84,0,0,
  // 0x0107  ć
  15,30,120,19,2,255,0,0,15,252,0,0,47,240,0,0,63,192,0,0,255,0,0,2,252,0,0,7,240,0,0,0,0,0,0,0,0,0,0,6,254,144,0,191,255,252,3,255,255,252,15,255,171,248,47,244,0,16,63,208,0,0,127,192,0,0,191,128,0,0,255,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,64,0,0,191,128,0,0,127,192,0,0,63,240,0,0,31,253,0,124,11,255,255,252,2,255,255,252,0,47,255,244,0,0,84,0,
  // 0x0108  Ĉ
  21,37,222,24,2,255,0,0,15,252,0,0,0,0,63,254,0,0,0,0,255,255,64,0,0,2,253,47,208,0,0,11,244,11,244,0,0,31,128,1,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,85,0,0,0,1,255,255,249,0,0,31,255,255,255,128,0,127,255,255,255,0,1,255,244,1,191,0,3,255,64,0,4,0,15,252,0,0,0,0,31,244,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,192,0,0,0,0,127,192,0,0,0,0,63,208,0,0,0,0,63,240,0,0,0,0,31,244,0,0,0,0,15,252,0,0,0,0,7,255,64,0,0,0,2,255,249,1,111,0,0,191,255,255,255,0,0,31,255,255,255,0,0,2,255,255,249,0,0,0,1,84,0,0,
  // 0x0109  ĉ
  16,30,120,19,2,255,0,15,253,0,0,47,255,0,0,127,255,192,0,254,31,240,3,248,3,248,15,208,0,190,0,0,0,0,0,0,0,0,0,6,254,144,0,191,255,252,3,255,255,252,15,255,171,248,47,244,0,16,63,208,0,0,127,192,0,0,191,128,0,0,255,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,64,0,0,191,128,0,0,127,192,0,0,63,240,0,0,31,253,0,124,11,255,255,252,2,255,255,252,0,47,255,244,0,0,84,0,
  // 0x010a  Ċ
  21,36,216,24,2,255,0,0,7,240,0,0,0,0,15,248,0,0,0,0,15,248,0,0,0,0,7,240,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,85,0,0,0,1,255,255,249,0,0,31,255,255,255,128,0,127,255,255,255,0,1,255,244,1,191,0,3,255,64,0,4,0,15,252,0,0,0,0,31,244,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,192,0,0,0,0,127,192,0,0,0,0,63,208,0,0,0,0,63,240,0,0,0,0,31,244,0,0,0,0,15,252,0,0,0,0,7,255,64,0,0,0,2,255,249,1,111,0,0,191,255,255,255,0,0,31,255,255,255,0,0,2,255,255,249,0,0,0,1,84,0,0,
  // 0x010b  ċ
  15,29,116,19,2,255,0,3,248,0,0,7,252,0,0,7,252,0,0,3,248,0,0,0,64,0,0,0,0,0,0,0,0,0,0,6,254,144,0,191,255,252,3,255,255,252,15,255,171,248,47,244,0,16,63,208,0,0,127,192,0,0,191,128,0,0,255,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,64,0,0,191,128,0,0,127,192,0,0,63,240,0,0,31,253,0,124,11,255,255,252,2,255,255,252,0,47,255,244,0,0,84,0,
  // 0x010c  Č
  21,37,222,24,2,255,0,31,192,1,252,0,0,7,244,11,240,0,0,2,253,47,208,0,0,0,191,255,64,0,0,0,63,254,0,0,0,0,15,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,85,0,0,0,1,255,255,249,0,0,31,255,255,255,128,0,127,255,255,255,0,1,255,244,1,191,0,3,255,64,0,4,0,15,252,0,0,0,0,31,244,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,192,0,0,0,0,127,192,0,0,0,0,63,208,0,0,0,0,63,240,0,0,0,0,31,244,0,0,0,0,15,252,0,0,0,0,7,255,64,0,0,0,2,255,249,1,111,0,0,191,255,255,255,0,0,31,255,255,255,0,0,2,255,255,249,0,0,0,1,84,0,0,
  // 0x010d  č
  16,30,120,19,2,255,15,208,0,254,3,248,7,248,0,255,31,224,0,127,255,192,0,31,255,0,0,11,253,0,0,0,0,0,0,0,0,0,0,6,254,144,0,191,255,252,3,255,255,252,15,255,171,248,47,244,0,16,63,208,0,0,127,192,0,0,191,128,0,0,255,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,64,0,0,191,128,0,0,127,192,0,0,63,240,0,0,31,253,0,124,11,255,255,252,2,255,255,252,0,47,255,244,0,0,84,0,
  // 0x010e  Ď
  23,36,216,28,3,0,0,253,0,15,224,0,0,63,128,127,128,0,0,15,241,254,0,0,0,7,255,252,0,0,0,1,255,240,0,0,0,0,191,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,228,0,0,127,255,255,255,64,0,127,255,255,255,240,0,127,213,86,255,252,0,127,128,0,31,255,0,127,128,0,2,255,128,127,128,0,0,191,192,127,128,0,0,63,224,127,128,0,0,47,240,127,128,0,0,15,240,127,128,0,0,15,244,127,128,0,0,15,244,127,128,0,0,15,248,127,128,0,0,11,248,127,128,0,0,15,244,127,128,0,0,15,244,127,128,0,0,15,244,127,128,0,0,31,240,127,128,0,0,47,240,127,128,0,0,63,208,127,128,0,0,255,192,127,128,0,3,255,64,127,128,0,47,254,0,127,213,107,255,248,0,127,255,255,255,208,0,127,255,255,254,0,0,127,255,255,144,0,0,
  // 0x010f  ď
  25,30,210,24,2,255,0,0,0,11,244,63,128,0,0,0,11,244,63,128,0,0,0,11,244,127,0,0,0,0,11,244,190,0,0,0,0,11,244,252,0,0,0,0,11,244,248,0,0,0,0,11,244,0,0,0,0,0,11,244,0,0,0,27,232,11,244,0,0,1,255,255,139,244,0,0,7,255,255,247,244,0,0,15,254,155,255,244,0,0,63,244,0,127,244,0,0,63,208,0,47,244,0,0,191,192,0,15,244,0,0,191,128,0,15,244,0,0,255,64,0,11,244,0,0,255,0,0,11,244,0,0,255,0,0,7,244,0,0,255,0,0,7,244,0,0,255,0,0,11,244,0,0,255,64,0,11,244,0,0,191,128,0,15,244,0,0,127,192,0,15,244,0,0,63,224,0,63,244,0,0,47,248,1,255,244,0,0,15,255,255,251,244,0,0,3,255,255,211,244,0,0,0,127,254,3,244,0,0,0,1,64,0,0,0,0,
  // 0x0110  Đ
  25,27,189,28,1,0,3,255,255,254,64,0,0,3,255,255,255,244,0,0,3,255,255,255,255,0,0,3,253,85,111,255,192,0,3,252,0,1,255,240,0,3,252,0,0,47,248,0,3,252,0,0,11,252,0,3,252,0,0,3,254,0,3,252,0,0,2,255,0,3,252,0,0,0,255,0,3,252,0,0,0,255,64,7,252,0,0,0,255,64,255,255,255,192,0,255,128,255,255,255,192,0,191,128,255,255,255,192,0,255,64,87,253,85,64,0,255,64,3,252,0,0,0,255,64,3,252,0,0,1,255,0,3,252,0,0,2,255,0,3,252,0,0,3,253,0,3,252,0,0,15,252,0,3,252,0,0,63,244,0,3,252,0,2,255,224,0,3,253,86,191,255,128,0,3,255,255,255,253,0,0,3,255,255,255,224,0,0,3,255,255,233,0,0,0,
  // 0x0111  đ
  22,30,180,24,2,255,0,0,0,11,244,0,0,0,0,11,244,0,0,0,0,11,244,0,0,2,170,175,254,128,0,3,255,255,255,208,0,3,255,255,255,208,0,0,0,11,248,0,0,0,0,11,244,0,0,5,80,11,244,0,0,191,255,75,244,0,3,255,255,215,244,0,15,255,255,255,244,0,47,248,1,255,244,0,63,224,0,63,244,0,127,192,0,15,244,0,191,128,0,15,244,0,255,64,0,11,244,0,255,0,0,11,244,0,255,0,0,7,244,0,255,0,0,7,244,0,255,0,0,11,244,0,255,64,0,11,244,0,191,128,0,15,244,0,127,192,0,15,244,0,63,224,0,47,244,0,47,248,1,255,244,0,15,255,255,251,244,0,3,255,255,211,244,0,0,191,254,3,244,0,0,1,64,0,0,0,
  // 0x0112  Ē
  16,33,132,21,3,0,7,255,255,244,7,255,255,244,7,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,127,255,255,255,127,255,255,255,127,213,85,85,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,255,255,252,127,255,255,252,127,255,255,252,127,234,170,168,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,234,170,169,127,255,255,255,127,255,255,255,127,255,255,255,
  // 0x0113  ē
  18,27,135,22,2,255,3,255,255,252,0,3,255,255,252,0,3,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,244,0,3,255,255,253,0,15,254,87,255,0,47,240,0,191,192,63,192,0,63,192,127,128,0,31,224,191,64,0,31,224,255,85,85,95,240,255,255,255,255,240,255,255,255,255,240,255,170,170,170,160,255,0,0,0,0,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,240,0,0,0,31,253,0,7,192,7,255,255,255,192,1,255,255,255,192,0,47,255,254,0,0,0,85,0,0,
  // 0x0114  Ĕ
  16,36,144,21,3,0,5,64,0,84,11,192,0,248,7,228,7,244,3,255,255,240,0,255,255,192,0,31,249,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,127,255,255,255,127,255,255,255,127,213,85,85,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,255,255,252,127,255,255,252,127,255,255,252,127,234,170,168,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,234,170,169,127,255,255,255,127,255,255,255,127,255,255,255,
  // 0x0115  ĕ
  18,30,150,22,2,255,1,64,0,20,0,3,208,0,124,0,3,244,6,252,0,1,255,255,240,0,0,191,255,208,0,0,27,254,0,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,244,0,3,255,255,253,0,15,254,87,255,0,47,240,0,191,192,63,192,0,63,192,127,128,0,31,224,191,64,0,31,224,255,85,85,95,240,255,255,255,255,240,255,255,255,255,240,255,170,170,170,160,255,0,0,0,0,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,240,0,0,0,31,253,0,7,192,7,255,255,255,192,1,255,255,255,192,0,47,255,254,0,0,0,85,0,0,
  // 0x0116  Ė
  16,35,140,21,3,0,0,3,244,0,0,11,248,0,0,11,252,0,0,7,244,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,127,255,255,255,127,255,255,255,127,213,85,85,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,255,255,252,127,255,255,252,127,255,255,252,127,234,170,168,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,234,170,169,127,255,255,255,127,255,255,255,127,255,255,255,
  // 0x0117  ė
  18,29,145,22,2,255,0,3,248,0,0,0,7,252,0,0,0,7,252,0,0,0,3,248,0,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,244,0,3,255,255,253,0,15,254,87,255,0,47,240,0,191,192,63,192,0,63,192,127,128,0,31,224,191,64,0,31,224,255,85,85,95,240,255,255,255,255,240,255,255,255,255,240,255,170,170,170,160,255,0,0,0,0,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,240,0,0,0,31,253,0,7,192,7,255,255,255,192,1,255,255,255,192,0,47,255,254,0,0,0,85,0,0,
  // 0x0118  Ę
  16,36,144,21,3,247,127,255,255,255,127,255,255,255,127,255,255,255,127,213,85,85,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,255,255,252,127,255,255,252,127,255,255,252,127,234,170,168,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,234,170,169,127,255,255,255,127,255,255,255,127,255,255,255,0,0,2,244,0,0,7,208,0,0,15,192,0,0,47,64,0,0,63,0,0,0,63,128,0,0,47,255,0,0,15,255,0,0,1,164,
  // 0x0119  ę
  18,30,150,22,2,247,0,6,254,64,0,0,191,255,244,0,3,255,255,253,0,15,254,87,255,0,47,240,0,191,192,63,192,0,63,192,127,128,0,31,224,191,64,0,31,224,255,85,85,95,240,255,255,255,255,240,255,255,255,255,240,255,170,170,170,160,255,0,0,0,0,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,240,0,0,0,31,253,0,7,192,7,255,255,255,192,1,255,255,255,192,0,47,255,255,64,0,0,85,253,0,0,0,2,244,0,0,0,7,224,0,0,0,15,192,0,0,0,15,192,0,0,0,15,224,0,0,0,11,255,128,0,0,3,255,128,0,0,0,105,0,
  // 0x011a  Ě
  16,36,144,21,3,0,15,208,1,253,7,248,11,244,1,254,47,208,0,191,255,128,0,47,254,0,0,15,252,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,127,255,255,255,127,255,255,255,127,213,85,85,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,255,255,252,127,255,255,252,127,255,255,252,127,234,170,168,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,234,170,169,127,255,255,255,127,255,255,255,127,255,255,255,
  // 0x011b  ě
  18,30,150,22,2,255,15,224,0,190,0,3,252,3,252,0,0,255,31,240,0,0,63,255,192,0,0,31,255,0,0,0,11,253,0,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,244,0,3,255,255,253,0,15,254,87,255,0,47,240,0,191,192,63,192,0,63,192,127,128,0,31,224,191,64,0,31,224,255,85,85,95,240,255,255,255,255,240,255,255,255,255,240,255,170,170,170,160,255,0,0,0,0,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,240,0,0,0,31,253,0,7,192,7,255,255,255,192,1,255,255,255,192,0,47,255,254,0,0,0,85,0,0,
  // 0x011c  Ĝ
  23,37,222,28,2,255,0,0,7,255,0,0,0,0,15,255,128,0,0,0,63,255,208,0,0,0,191,75,244,0,0,2,253,2,253,0,0,7,224,0,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,89,80,0,0,0,191,255,255,128,0,11,255,255,255,244,0,63,255,255,255,240,1,255,249,0,27,208,3,255,128,0,0,64,11,253,0,0,0,0,31,248,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,191,128,0,42,170,164,191,128,0,63,255,248,191,128,0,63,255,248,191,128,0,63,255,248,127,192,0,0,7,248,127,192,0,0,7,248,63,208,0,0,7,248,63,240,0,0,7,248,31,244,0,0,7,248,15,253,0,0,7,248,3,255,64,0,7,248,1,255,249,0,91,248,0,127,255,255,255,248,0,31,255,255,255,248,0,1,191,255,255,144,0,0,0,85,0,0,
  // 0x011d  ĝ
  19,39,195,24,2,246,0,3,255,0,0,0,15,255,128,0,0,47,255,224,0,0,191,75,244,0,1,253,1,253,0,7,240,0,63,0,0,0,0,0,0,0,0,0,0,0,0,27,232,1,80,1,255,255,131,244,7,255,255,243,244,15,255,171,255,244,47,244,0,191,244,63,208,0,47,244,127,192,0,15,244,191,128,0,15,244,255,64,0,11,244,255,0,0,11,244,255,0,0,7,244,255,0,0,7,244,255,0,0,7,244,255,64,0,11,244,191,128,0,15,244,127,192,0,15,244,63,224,0,47,244,47,248,0,191,244,15,255,255,251,244,3,255,255,219,244,0,191,254,11,244,0,1,80,11,244,0,0,0,11,244,0,0,0,15,240,0,0,0,31,240,16,0,0,63,224,47,148,2,255,192,47,255,255,255,64,47,255,255,253,0,2,191,255,144,0,0,0,0,0,0,
  // 0x011e  Ğ
  23,37,222,28,2,255,0,1,64,0,21,0,0,3,224,0,61,0,0,2,249,1,252,0,0,0,255,255,248,0,0,0,127,255,224,0,0,0,11,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,89,80,0,0,0,191,255,255,128,0,11,255,255,255,244,0,63,255,255,255,240,1,255,249,0,27,208,3,255,128,0,0,64,11,253,0,0,0,0,31,248,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,191,128,0,42,170,164,191,128,0,63,255,248,191,128,0,63,255,248,191,128,0,63,255,248,127,192,0,0,7,248,127,192,0,0,7,248,63,208,0,0,7,248,63,240,0,0,7,248,31,244,0,0,7,248,15,253,0,0,7,248,3,255,64,0,7,248,1,255,249,0,91,248,0,127,255,255,255,248,0,31,255,255,255,248,0,1,191,255,255,144,0,0,0,85,0,0,
  // 0x011f  ğ
  19,39,195,24,2,246,1,80,0,21,0,2,240,0,62,0,1,249,1,253,0,0,255,255,248,0,0,63,255,224,0,0,7,254,64,0,0,0,0,0,0,0,0,0,0,0,0,27,232,1,80,1,255,255,131,244,7,255,255,243,244,15,255,171,255,244,47,244,0,191,244,63,208,0,47,244,127,192,0,15,244,191,128,0,15,244,255,64,0,11,244,255,0,0,11,244,255,0,0,7,244,255,0,0,7,244,255,0,0,7,244,255,64,0,11,244,191,128,0,15,244,127,192,0,15,244,63,224,0,47,244,47,248,0,191,244,15,255,255,251,244,3,255,255,219,244,0,191,254,11,244,0,1,80,11,244,0,0,0,11,244,0,0,0,15,240,0,0,0,31,240,16,0,0,63,224,47,148,2,255,192,47,255,255,255,64,47,255,255,253,0,2,191,255,144,0,0,0,0,0,0,
  // 0x0120  Ġ
  23,36,216,28,2,255,0,0,1,252,0,0,0,0,3,254,0,0,0,0,3,254,0,0,0,0,1,252,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,89,80,0,0,0,191,255,255,128,0,11,255,255,255,244,0,63,255,255,255,240,1,255,249,0,27,208,3,255,128,0,0,64,11,253,0,0,0,0,31,248,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,191,128,0,42,170,164,191,128,0,63,255,248,191,128,0,63,255,248,191,128,0,63,255,248,127,192,0,0,7,248,127,192,0,0,7,248,63,208,0,0,7,248,63,240,0,0,7,248,31,244,0,0,7,248,15,253,0,0,7,248,3,255,64,0,7,248,1,255,249,0,91,248,0,127,255,255,255,248,0,31,255,255,255,248,0,1,191,255,255,144,0,0,0,85,0,0,
  // 0x0121  ġ
  19,38,190,24,2,246,0,1,252,0,0,0,2,254,0,0,0,2,254,0,0,0,1,253,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,27,232,1,80,1,255,255,131,244,7,255,255,243,244,15,255,171,255,244,47,244,0,191,244,63,208,0,47,244,127,192,0,15,244,191,128,0,15,244,255,64,0,11,244,255,0,0,11,244,255,0,0,7,244,255,0,0,7,244,255,0,0,7,244,255,64,0,11,244,191,128,0,15,244,127,192,0,15,244,63,224,0,47,244,47,248,0,191,244,15,255,255,251,244,3,255,255,219,244,0,191,254,11,244,0,1,80,11,244,0,0,0,11,244,0,0,0,15,240,0,0,0,31,240,16,0,0,63,224,47,148,2,255,192,47,255,255,255,64,47,255,255,253,0,2,191,255,144,0,0,0,0,0,0,
  // 0x0122  Ģ
  23,37,222,28,2,247,0,0,1,89,80,0,0,0,191,255,255,128,0,11,255,255,255,244,0,63,255,255,255,240,1,255,249,0,27,208,3,255,128,0,0,64,11,253,0,0,0,0,31,248,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,191,128,0,42,170,164,191,128,0,63,255,248,191,128,0,63,255,248,191,128,0,63,255,248,127,192,0,0,7,248,127,192,0,0,7,248,63,208,0,0,7,248,63,240,0,0,7,248,31,244,0,0,7,248,15,253,0,0,7,248,3,255,64,0,7,248,1,255,249,0,91,248,0,127,255,255,255,248,0,31,255,255,255,248,0,1,191,255,255,144,0,0,0,85,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,0,1,253,0,0,0,0,2,252,0,0,0,0,3,248,0,0,0,0,3,240,0,0,0,0,7,208,0,0,0,0,1,64,0,0,
  // 0x0123  ģ
  19,39,195,24,2,246,0,0,47,0,0,0,0,62,0,0,0,0,253,0,0,0,1,252,0,0,0,3,252,0,0,0,3,248,0,0,0,0,0,0,0,0,0,0,0,0,0,27,232,1,80,1,255,255,131,244,7,255,255,243,244,15,255,171,255,244,47,244,0,191,244,63,208,0,47,244,127,192,0,15,244,191,128,0,15,244,255,64,0,11,244,255,0,0,11,244,255,0,0,7,244,255,0,0,7,244,255,0,0,7,244,255,64,0,11,244,191,128,0,15,244,127,192,0,15,244,63,224,0,47,244,47,248,0,191,244,15,255,255,251,244,3,255,255,219,244,0,191,254,11,244,0,1,80,11,244,0,0,0,11,244,0,0,0,15,240,0,0,0,31,240,16,0,0,63,224,47,148,2,255,192,47,255,255,255,64,47,255,255,253,0,2,191,255,144,0,0,0,0,0,0,
  // 0x0124  Ĥ
  22,36,216,28,3,0,0,0,127,240,0,0,0,0,255,248,0,0,0,3,255,253,0,0,0,15,240,255,0,0,0,47,192,47,192,0,0,190,0,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,255,255,255,255,240,127,255,255,255,255,240,127,255,255,255,255,240,127,234,170,170,175,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,
  // 0x0125  ĥ
  23,37,222,24,254,0,0,127,240,0,0,0,0,255,248,0,0,0,3,255,253,0,0,0,15,240,255,0,0,0,47,192,47,192,0,0,190,0,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,107,228,0,0,63,195,255,255,64,0,63,207,255,255,208,0,63,255,230,255,240,0,63,252,0,31,244,0,63,244,0,11,248,0,63,240,0,7,252,0,63,224,0,3,252,0,63,208,0,3,252,0,63,192,0,3,252,0,63,192,0,3,252,0,63,192,0,3,252,0,63,192,0,3,252,0,63,192,0,3,252,0,63,192,0,3,252,0,63,192,0,3,252,0,63,192,0,3,252,0,63,192,0,3,252,0,63,192,0,3,252,0,63,192,0,3,252,0,63,192,0,3,252,
  // 0x0126  Ħ
  29,27,216,28,0,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,64,1,255,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,255,255,255,255,255,192,0,1,255,255,255,255,255,192,0,1,255,255,255,255,255,192,0,1,255,170,170,170,191,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,127,192,0,
  // 0x0127  ħ
  21,29,174,24,0,0,2,252,0,0,0,0,3,252,0,0,0,0,3,252,0,0,0,0,107,254,170,164,0,0,191,255,255,248,0,0,191,255,255,248,0,0,23,253,85,80,0,0,3,252,0,0,0,0,3,252,0,0,0,0,3,252,6,255,128,0,3,252,127,255,248,0,3,253,255,255,254,0,3,255,249,91,255,0,3,255,192,0,255,128,3,255,0,0,191,128,3,255,0,0,127,192,3,253,0,0,63,192,3,253,0,0,63,192,3,252,0,0,63,192,3,252,0,0,63,192,3,252,0,0,63,192,3,252,0,0,63,192,3,252,0,0,63,192,3,252,0,0,63,192,3,252,0,0,63,192,3,252,0,0,63,192,3,252,0,0,63,192,3,252,0,0,63,192,3,252,0,0,63,192,
  // 0x0128  Ĩ
  15,35,140,13,255,0,7,253,0,124,15,255,209,248,63,255,255,240,61,7,255,224,124,0,127,64,0,0,0,0,0,0,0,0,0,0,0,0,11,255,255,192,11,255,255,192,2,255,254,64,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,2,255,255,64,11,255,255,192,11,255,255,192,
  // 0x0129  ĩ
  15,28,112,10,254,0,11,248,0,244,63,255,130,240,127,255,255,224,188,11,255,192,244,0,190,0,0,0,0,0,0,0,0,0,0,21,64,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,
  // 0x012a  Ī
  12,33,99,13,1,0,255,255,254,255,255,254,255,255,254,0,0,0,0,0,0,0,0,0,191,255,252,191,255,252,47,255,228,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,47,255,244,191,255,252,191,255,252,
  // 0x012b  ī
  12,26,78,10,255,0,191,255,255,191,255,255,191,255,255,0,0,0,0,0,0,0,85,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,
  // 0x012c  Ĭ
  13,36,144,13,0,0,84,0,1,64,124,0,11,192,63,64,111,128,47,255,255,0,15,255,252,0,1,191,208,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,0,47,255,255,0,11,255,249,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,127,192,0,11,255,253,0,47,255,255,0,47,255,255,0,
  // 0x012d  ĭ
  13,29,116,10,255,0,80,0,5,0,244,0,31,64,253,0,191,0,127,255,253,0,31,255,244,0,2,255,128,0,0,0,0,0,0,0,0,0,0,85,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,
  // 0x012e  Į
  11,36,108,13,1,247,191,255,252,191,255,252,47,255,228,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,47,255,244,191,255,252,191,255,252,0,7,208,0,31,128,0,63,0,0,189,0,0,189,0,0,190,0,0,127,252,0,47,252,0,6,148,
  // 0x012f  į
  7,37,74,10,1,247,11,240,15,244,15,244,11,240,0,64,0,0,0,0,5,80,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,7,208,31,128,63,0,189,0,189,0,190,0,127,252,47,252,6,148,
  // 0x0130  İ
  11,35,105,13,1,0,0,254,0,1,255,0,1,255,0,0,254,0,0,16,0,0,0,0,0,0,0,0,0,0,191,255,252,191,255,252,47,255,228,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,47,255,244,191,255,252,191,255,252,
  // 0x0131  ı
  4,21,21,10,3,0,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x0132  Ĳ
  20,35,175,24,1,248,191,255,252,0,255,191,255,252,0,255,47,255,228,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,1,255,0,0,255,47,255,244,0,255,191,255,252,0,255,191,255,252,0,255,0,0,0,0,255,0,0,0,1,255,0,0,0,3,254,0,0,4,31,252,0,0,31,255,248,0,0,31,255,240,0,0,31,255,128,0,0,1,80,0,
  // 0x0133  ĳ
  15,38,152,21,3,246,191,0,7,244,255,64,11,248,255,64,11,252,191,0,7,244,4,0,0,64,0,0,0,0,0,0,0,0,85,0,1,84,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,255,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,244,0,0,15,244,0,20,111,240,0,63,255,224,0,63,255,192,0,47,254,0,0,0,0,0,
  // 0x0134  Ĵ
  16,44,176,11,253,248,0,15,252,0,0,63,255,0,0,191,255,128,2,253,47,224,7,244,7,244,15,192,0,253,0,0,0,0,0,0,0,0,0,0,0,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,248,0,0,11,244,0,0,15,244,0,0,31,240,0,64,127,240,0,255,255,208,0,255,255,64,0,255,252,0,0,21,64,0,0,
  // 0x0135  ĵ
  14,39,156,10,254,246,0,127,224,0,0,255,244,0,3,255,253,0,15,240,255,0,47,192,47,192,190,0,7,240,0,0,0,0,0,0,0,0,0,21,64,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,65,255,192,0,255,255,64,0,255,254,0,0,255,244,0,0,0,0,0,0,
  // 0x0136  Ķ
  21,36,216,24,3,247,127,128,0,2,255,0,127,128,0,7,253,0,127,128,0,31,244,0,127,128,0,63,224,0,127,128,0,255,128,0,127,128,3,255,0,0,127,128,11,252,0,0,127,128,47,240,0,0,127,128,127,192,0,0,127,129,255,64,0,0,127,131,253,0,0,0,127,143,248,0,0,0,127,255,252,0,0,0,127,255,254,0,0,0,127,255,255,64,0,0,127,240,255,192,0,0,127,192,63,224,0,0,127,128,31,244,0,0,127,128,15,252,0,0,127,128,3,255,0,0,127,128,1,255,64,0,127,128,0,191,192,0,127,128,0,63,240,0,127,128,0,15,248,0,127,128,0,11,253,0,127,128,0,3,255,0,127,128,0,0,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,0,0,0,0,0,191,0,0,0,0,0,254,0,0,0,0,0,252,0,0,0,0,1,248,0,0,0,0,3,240,0,0,0,0,1,64,0,0,0,
  // 0x0137  ķ
  18,38,190,21,3,247,191,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,21,64,255,0,0,255,128,255,0,3,254,0,255,0,15,248,0,255,0,63,224,0,255,0,255,192,0,255,2,255,0,0,255,11,252,0,0,255,47,240,0,0,255,127,208,0,0,255,255,240,0,0,255,255,252,0,0,255,227,254,0,0,255,129,255,64,0,255,0,191,192,0,255,0,63,240,0,255,0,15,248,0,255,0,7,253,0,255,0,2,255,0,255,0,0,255,192,255,0,0,63,224,0,0,0,0,0,0,0,0,0,0,0,6,160,0,0,0,15,240,0,0,0,15,224,0,0,0,31,192,0,0,0,47,64,0,0,0,63,0,0,0,0,20,0,0,0,
  // 0x0138  ĸ
  18,21,105,21,3,0,85,0,0,21,64,255,64,0,255,128,255,64,3,254,0,255,64,11,252,0,255,64,47,240,0,255,64,127,192,0,255,65,255,64,0,255,67,253,0,0,255,15,248,0,0,255,63,240,0,0,255,191,240,0,0,255,255,252,0,0,255,247,254,0,0,255,192,255,64,0,255,64,127,192,0,255,64,47,240,0,255,64,15,248,0,255,64,7,253,0,255,64,2,255,0,255,64,0,255,192,255,64,0,63,224,
  // 0x0139  Ĺ
  17,36,180,20,3,0,0,255,128,0,0,3,255,0,0,0,7,252,0,0,0,15,240,0,0,0,63,128,0,0,0,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,234,170,170,0,127,255,255,255,64,127,255,255,255,64,127,255,255,255,64,
  // 0x013a  ĺ
  9,37,111,10,3,0,2,255,64,3,253,0,15,244,0,47,208,0,127,64,0,253,0,0,0,0,0,0,0,0,191,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,
  // 0x013b  Ļ
  17,36,180,20,3,247,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,234,170,170,0,127,255,255,255,64,127,255,255,255,64,127,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,2,168,0,0,0,3,252,0,0,0,3,244,0,0,0,7,240,0,0,0,11,208,0,0,0,15,128,0,0,0,5,0,0,0,
  // 0x013c  ļ
  6,38,76,10,2,247,47,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,0,0,0,0,10,160,31,224,31,192,47,128,63,0,125,0,20,0,
  // 0x013d  Ľ
  17,27,135,20,3,0,127,128,0,127,128,127,128,0,127,0,127,128,0,190,0,127,128,0,252,0,127,128,0,248,0,127,128,1,240,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,234,170,170,0,127,255,255,255,64,127,255,255,255,64,127,255,255,255,64,
  // 0x013e  ľ
  11,29,87,10,3,0,191,3,248,255,7,244,255,11,240,255,15,208,255,15,192,255,31,64,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,
  // 0x013f  Ŀ
  17,27,135,20,3,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,11,240,0,127,128,15,244,0,127,128,15,244,0,127,128,11,240,0,127,128,0,64,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,234,170,170,0,127,255,255,255,64,127,255,255,255,64,127,255,255,255,64,
  // 0x0140  ŀ
  10,29,87,11,3,0,191,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,15,208,255,31,240,255,31,240,255,15,224,255,1,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,
  // 0x0141  Ł
  20,27,135,20,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,2,64,0,1,254,31,192,0,1,255,255,224,0,1,255,255,64,0,1,255,248,0,0,7,255,192,0,0,47,255,0,0,0,127,254,0,0,0,63,254,0,0,0,5,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,255,170,170,168,1,255,255,255,253,1,255,255,255,253,1,255,255,255,253,
  // 0x0142  ł
  11,29,87,10,0,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,144,3,255,240,3,255,244,3,255,224,11,255,0,127,252,0,255,252,0,191,252,0,35,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,
  // 0x0143  Ń
  23,36,216,29,3,0,0,0,0,63,240,0,0,0,0,191,192,0,0,0,1,255,0,0,0,0,3,252,0,0,0,0,11,240,0,0,0,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,240,0,0,3,252,127,248,0,0,3,252,127,252,0,0,3,252,127,255,0,0,3,252,127,255,64,0,3,252,127,191,192,0,3,252,127,63,224,0,3,252,127,31,244,0,3,252,127,11,252,0,3,252,127,3,254,0,3,252,127,65,255,0,3,252,127,64,255,192,3,252,127,64,63,208,3,252,127,64,47,240,3,252,127,64,15,248,3,252,127,64,7,253,3,252,127,64,2,255,3,252,127,64,0,255,131,252,127,64,0,127,195,252,127,64,0,63,243,252,127,64,0,15,246,252,127,64,0,11,255,252,127,64,0,3,255,252,127,64,0,1,255,252,127,64,0,0,191,252,127,64,0,0,63,252,127,64,0,0,31,252,
  // 0x0144  ń
  18,29,145,24,3,0,0,0,15,252,0,0,0,31,244,0,0,0,63,208,0,0,0,191,64,0,0,1,253,0,0,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,84,1,191,144,0,254,15,255,253,0,255,63,255,255,64,255,255,155,255,192,255,240,0,127,208,255,208,0,47,224,255,192,0,31,240,255,128,0,15,240,255,64,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,
  // 0x0145  Ņ
  23,36,216,29,3,247,127,240,0,0,3,252,127,248,0,0,3,252,127,252,0,0,3,252,127,255,0,0,3,252,127,255,64,0,3,252,127,191,192,0,3,252,127,63,224,0,3,252,127,31,244,0,3,252,127,11,252,0,3,252,127,3,254,0,3,252,127,65,255,0,3,252,127,64,255,192,3,252,127,64,63,208,3,252,127,64,47,240,3,252,127,64,15,248,3,252,127,64,7,253,3,252,127,64,2,255,3,252,127,64,0,255,131,252,127,64,0,127,195,252,127,64,0,63,243,252,127,64,0,15,246,252,127,64,0,11,255,252,127,64,0,3,255,252,127,64,0,1,255,252,127,64,0,0,191,252,127,64,0,0,63,252,127,64,0,0,31,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,164,0,0,0,0,11,240,0,0,0,0,15,224,0,0,0,0,15,192,0,0,0,0,31,128,0,0,0,0,47,0,0,0,0,0,20,0,0,0,
  // 0x0146  ņ
  18,30,150,24,3,247,84,1,191,144,0,254,15,255,253,0,255,63,255,255,64,255,255,155,255,192,255,240,0,127,208,255,208,0,47,224,255,192,0,31,240,255,128,0,15,240,255,64,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,0,0,0,0,0,0,0,0,0,0,0,0,169,0,0,0,1,253,0,0,0,2,252,0,0,0,3,244,0,0,0,3,240,0,0,0,11,192,0,0,0,5,64,0,0,
  // 0x0147  Ň
  23,36,216,29,3,0,0,63,64,3,244,0,0,15,224,31,224,0,0,3,252,127,128,0,0,1,255,254,0,0,0,0,127,252,0,0,0,0,47,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,240,0,0,3,252,127,248,0,0,3,252,127,252,0,0,3,252,127,255,0,0,3,252,127,255,64,0,3,252,127,191,192,0,3,252,127,63,224,0,3,252,127,31,244,0,3,252,127,11,252,0,3,252,127,3,254,0,3,252,127,65,255,0,3,252,127,64,255,192,3,252,127,64,63,208,3,252,127,64,47,240,3,252,127,64,15,248,3,252,127,64,7,253,3,252,127,64,2,255,3,252,127,64,0,255,131,252,127,64,0,127,195,252,127,64,0,63,243,252,127,64,0,15,246,252,127,64,0,11,255,252,127,64,0,3,255,252,127,64,0,1,255,252,127,64,0,0,191,252,127,64,0,0,63,252,127,64,0,0,31,252,
  // 0x0148  ň
  18,29,145,24,3,0,15,224,0,190,0,3,252,3,248,0,0,255,31,240,0,0,63,255,192,0,0,31,255,0,0,0,11,253,0,0,0,0,0,0,0,0,0,0,0,0,84,1,191,144,0,254,15,255,253,0,255,63,255,255,64,255,255,155,255,192,255,240,0,127,208,255,208,0,47,224,255,192,0,31,240,255,128,0,15,240,255,64,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,
  // 0x0149  ŉ
  24,27,162,27,0,0,15,240,0,0,0,0,31,240,0,0,0,0,47,224,0,0,0,0,47,192,0,0,0,0,63,192,0,0,0,0,63,128,0,0,0,0,127,5,80,10,249,0,190,11,224,255,255,224,252,11,243,255,255,248,0,11,255,249,111,252,0,11,255,64,3,254,0,11,253,0,1,255,0,11,252,0,0,255,0,11,248,0,0,255,0,11,244,0,0,255,0,11,244,0,0,255,0,11,244,0,0,255,0,11,244,0,0,255,0,11,244,0,0,255,0,11,244,0,0,255,0,11,244,0,0,255,0,11,244,0,0,255,0,11,244,0,0,255,0,11,244,0,0,255,0,11,244,0,0,255,0,11,244,0,0,255,0,11,244,0,0,255,
  // 0x014a  Ŋ
  23,35,210,29,3,248,127,240,0,0,3,252,127,248,0,0,3,252,127,253,0,0,3,252,127,255,0,0,3,252,127,255,128,0,3,252,127,191,208,0,3,252,127,63,240,0,3,252,127,15,248,0,3,252,127,7,253,0,3,252,127,67,255,0,3,252,127,64,255,128,3,252,127,64,127,208,3,252,127,64,47,240,3,252,127,64,15,248,3,252,127,64,7,253,3,252,127,64,2,255,3,252,127,64,0,255,195,252,127,64,0,127,211,252,127,64,0,47,242,252,127,64,0,15,254,252,127,64,0,7,255,252,127,64,0,2,255,252,127,64,0,0,255,252,127,64,0,0,63,252,127,64,0,0,47,252,127,64,0,0,15,252,127,64,0,0,3,252,0,0,0,0,3,252,0,0,0,0,3,248,0,0,0,0,11,248,0,0,0,64,47,240,0,0,0,255,255,224,0,0,0,255,255,192,0,0,0,255,253,0,0,0,0,21,64,0,
  // 0x014b  ŋ
  18,31,155,24,3,246,84,1,191,144,0,254,15,255,253,0,255,63,255,255,64,255,255,154,255,192,255,244,0,127,224,255,208,0,47,224,255,192,0,31,240,255,128,0,15,240,255,64,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,31,240,0,0,20,127,224,0,0,63,255,192,0,0,63,255,64,0,0,47,249,0,0,0,0,0,0,
  // 0x014c  Ō
  26,34,238,30,2,255,0,3,255,255,252,0,0,0,3,255,255,252,0,0,0,3,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,165,0,0,0,0,2,255,255,248,0,0,0,47,255,255,255,64,0,0,191,255,255,255,224,0,2,255,228,1,191,248,0,7,255,0,0,15,253,0,15,252,0,0,3,255,0,47,240,0,0,1,255,64,63,224,0,0,0,255,128,63,208,0,0,0,127,192,127,192,0,0,0,63,192,191,192,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,224,191,128,0,0,0,63,224,191,128,0,0,0,63,208,191,128,0,0,0,63,208,127,192,0,0,0,63,208,127,192,0,0,0,63,192,63,208,0,0,0,191,192,63,240,0,0,0,255,128,31,244,0,0,1,255,0,15,252,0,0,3,254,0,7,255,0,0,31,252,0,2,255,228,1,255,244,0,0,191,255,255,255,208,0,0,31,255,255,255,0,0,0,1,255,255,228,0,0,0,0,1,84,0,0,0,
  // 0x014d  ō
  19,27,135,23,2,255,1,255,255,253,0,1,255,255,253,0,1,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,248,0,3,255,255,255,0,15,255,171,255,192,47,244,0,127,224,63,208,0,15,240,127,192,0,11,248,191,128,0,7,252,255,64,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,64,0,3,252,191,128,0,7,248,63,192,0,15,244,63,224,0,47,240,15,253,0,191,208,7,255,255,255,128,1,255,255,254,0,0,47,255,224,0,0,0,84,0,0,
  // 0x014e  Ŏ
  26,37,3,30,2,255,0,1,64,0,20,0,0,0,7,192,0,188,0,0,0,3,244,6,248,0,0,0,2,255,255,240,0,0,0,0,191,255,208,0,0,0,0,27,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,165,0,0,0,0,2,255,255,248,0,0,0,47,255,255,255,64,0,0,191,255,255,255,224,0,2,255,228,1,191,248,0,7,255,0,0,15,253,0,15,252,0,0,3,255,0,47,240,0,0,1,255,64,63,224,0,0,0,255,128,63,208,0,0,0,127,192,127,192,0,0,0,63,192,191,192,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,224,191,128,0,0,0,63,224,191,128,0,0,0,63,208,191,128,0,0,0,63,208,127,192,0,0,0,63,208,127,192,0,0,0,63,192,63,208,0,0,0,191,192,63,240,0,0,0,255,128,31,244,0,0,1,255,0,15,252,0,0,3,254,0,7,255,0,0,31,252,0,2,255,228,1,255,244,0,0,191,255,255,255,208,0,0,31,255,255,255,0,0,0,1,255,255,228,0,0,0,0,1,84,0,0,0,
  // 0x014f  ŏ
  19,30,150,23,2,255,1,80,0,21,0,2,240,0,62,0,1,249,1,253,0,0,255,255,252,0,0,63,255,240,0,0,7,254,64,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,248,0,3,255,255,255,0,15,255,171,255,192,47,244,0,127,224,63,208,0,15,240,127,192,0,11,248,191,128,0,7,252,255,64,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,64,0,3,252,191,128,0,7,248,63,192,0,15,244,63,224,0,47,240,15,253,0,191,208,7,255,255,255,128,1,255,255,254,0,0,47,255,224,0,0,0,84,0,0,
  // 0x0150  Ő
  26,37,3,30,2,255,0,0,127,193,255,0,0,0,0,255,67,253,0,0,0,1,253,7,244,0,0,0,3,248,15,208,0,0,0,11,224,47,64,0,0,0,15,64,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,165,0,0,0,0,2,255,255,248,0,0,0,47,255,255,255,64,0,0,191,255,255,255,224,0,2,255,228,1,191,248,0,7,255,0,0,15,253,0,15,252,0,0,3,255,0,47,240,0,0,1,255,64,63,224,0,0,0,255,128,63,208,0,0,0,127,192,127,192,0,0,0,63,192,191,192,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,224,191,128,0,0,0,63,224,191,128,0,0,0,63,208,191,128,0,0,0,63,208,127,192,0,0,0,63,208,127,192,0,0,0,63,192,63,208,0,0,0,191,192,63,240,0,0,0,255,128,31,244,0,0,1,255,0,15,252,0,0,3,254,0,7,255,0,0,31,252,0,2,255,228,1,255,244,0,0,191,255,255,255,208,0,0,31,255,255,255,0,0,0,1,255,255,228,0,0,0,0,1,84,0,0,0,
  // 0x0151  ő
  19,30,150,23,2,255,0,47,240,191,128,0,63,192,255,0,0,191,3,252,0,1,252,7,240,0,3,244,15,192,0,11,192,47,0,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,248,0,3,255,255,255,0,15,255,171,255,192,47,244,0,127,224,63,208,0,15,240,127,192,0,11,248,191,128,0,7,252,255,64,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,64,0,3,252,191,128,0,7,248,63,192,0,15,244,63,224,0,47,240,15,253,0,191,208,7,255,255,255,128,1,255,255,254,0,0,47,255,224,0,0,0,84,0,0,
  // 0x0152  Œ
  32,29,232,36,2,255,0,0,5,149,0,0,0,0,0,2,255,255,255,255,255,254,0,47,255,255,255,255,255,254,0,255,255,255,255,255,255,254,3,255,228,1,191,213,85,84,11,254,0,0,127,128,0,0,15,252,0,0,127,128,0,0,47,240,0,0,127,128,0,0,63,224,0,0,127,128,0,0,63,192,0,0,127,128,0,0,127,192,0,0,127,128,0,0,191,192,0,0,127,128,0,0,191,128,0,0,127,255,255,248,191,128,0,0,127,255,255,252,191,128,0,0,127,255,255,252,191,128,0,0,127,234,170,164,191,128,0,0,127,128,0,0,127,192,0,0,127,128,0,0,127,192,0,0,127,128,0,0,63,208,0,0,127,128,0,0,63,224,0,0,127,128,0,0,31,240,0,0,127,128,0,0,15,252,0,0,127,128,0,0,7,255,0,0,127,128,0,0,2,255,228,5,255,234,170,169,0,191,255,255,255,255,255,254,0,31,255,255,255,255,255,254,0,1,255,255,255,255,255,254,0,0,1,84,0,0,0,0,
  // 0x0153  œ
  33,22,198,36,2,255,0,6,186,64,0,43,228,0,0,0,191,255,244,2,255,255,128,0,3,255,255,253,15,255,255,240,0,15,255,171,255,127,245,111,248,0,47,240,0,127,255,128,3,253,0,63,208,0,31,255,0,1,255,0,127,192,0,15,253,0,0,255,0,191,64,0,11,252,0,0,191,64,255,64,0,7,253,85,85,255,64,255,0,0,7,255,255,255,255,64,255,0,0,7,255,255,255,255,64,255,0,0,7,254,170,170,170,64,255,0,0,7,252,0,0,0,0,255,64,0,11,252,0,0,0,0,191,128,0,15,253,0,0,0,0,127,192,0,15,254,0,0,0,0,63,224,0,63,255,64,0,0,0,15,248,1,255,255,224,0,109,0,7,255,255,255,31,255,255,253,0,1,255,255,252,7,255,255,253,0,0,47,255,208,0,191,255,228,0,0,0,84,0,0,1,84,0,0,
  // 0x0154  Ŕ
  21,36,216,24,3,0,0,0,11,252,0,0,0,0,15,244,0,0,0,0,63,208,0,0,0,0,191,64,0,0,0,1,253,0,0,0,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,144,0,0,127,255,255,253,0,0,127,255,255,255,128,0,127,213,91,255,208,0,127,128,0,127,240,0,127,128,0,31,240,0,127,128,0,15,244,0,127,128,0,15,244,0,127,128,0,15,244,0,127,128,0,15,240,0,127,128,0,47,240,0,127,128,0,127,208,0,127,213,91,255,128,0,127,255,255,254,0,0,127,255,255,240,0,0,127,255,255,208,0,0,127,128,31,240,0,0,127,128,11,248,0,0,127,128,3,253,0,0,127,128,2,255,0,0,127,128,0,255,128,0,127,128,0,127,192,0,127,128,0,47,240,0,127,128,0,15,244,0,127,128,0,11,252,0,127,128,0,3,254,0,127,128,0,1,255,64,
  // 0x0155  ŕ
  13,29,116,16,3,0,0,1,255,64,0,3,254,0,0,11,248,0,0,31,224,0,0,63,64,0,0,253,0,0,0,0,0,0,0,0,0,0,84,0,191,64,253,11,255,64,254,47,255,64,255,127,255,0,255,253,0,0,255,240,0,0,255,192,0,0,255,128,0,0,255,64,0,0,255,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,
  // 0x0156  Ŗ
  21,36,216,24,3,247,127,255,255,144,0,0,127,255,255,253,0,0,127,255,255,255,128,0,127,213,91,255,208,0,127,128,0,127,240,0,127,128,0,31,240,0,127,128,0,15,244,0,127,128,0,15,244,0,127,128,0,15,244,0,127,128,0,15,240,0,127,128,0,47,240,0,127,128,0,127,208,0,127,213,91,255,128,0,127,255,255,254,0,0,127,255,255,240,0,0,127,255,255,208,0,0,127,128,31,240,0,0,127,128,11,248,0,0,127,128,3,253,0,0,127,128,2,255,0,0,127,128,0,255,128,0,127,128,0,127,192,0,127,128,0,47,240,0,127,128,0,15,244,0,127,128,0,11,252,0,127,128,0,3,254,0,127,128,0,1,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,0,0,0,191,0,0,0,0,0,254,0,0,0,0,0,252,0,0,0,0,1,248,0,0,0,0,2,240,0,0,0,0,1,64,0,0,0,
  // 0x0157  ŗ
  14,30,120,16,2,247,21,0,47,208,63,66,255,208,63,139,255,208,63,223,255,192,63,255,64,0,63,252,0,0,63,240,0,0,63,224,0,0,63,208,0,0,63,208,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,0,0,0,0,0,0,0,0,10,160,0,0,31,208,0,0,47,192,0,0,63,128,0,0,63,0,0,0,125,0,0,0,20,0,0,0,
  // 0x0158  Ř
  21,36,216,24,3,0,11,224,0,191,0,0,2,252,3,252,0,0,0,255,15,240,0,0,0,63,255,192,0,0,0,15,255,64,0,0,0,7,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,144,0,0,127,255,255,253,0,0,127,255,255,255,128,0,127,213,91,255,208,0,127,128,0,127,240,0,127,128,0,31,240,0,127,128,0,15,244,0,127,128,0,15,244,0,127,128,0,15,244,0,127,128,0,15,240,0,127,128,0,47,240,0,127,128,0,127,208,0,127,213,91,255,128,0,127,255,255,254,0,0,127,255,255,240,0,0,127,255,255,208,0,0,127,128,31,240,0,0,127,128,11,248,0,0,127,128,3,253,0,0,127,128,2,255,0,0,127,128,0,255,128,0,127,128,0,127,192,0,127,128,0,47,240,0,127,128,0,15,244,0,127,128,0,11,252,0,127,128,0,3,254,0,127,128,0,1,255,64,
  // 0x0159  ř
  14,29,116,16,2,0,127,0,7,240,47,208,47,192,11,244,255,0,3,255,253,0,0,255,244,0,0,63,224,0,0,0,0,0,0,0,0,0,21,0,47,208,63,66,255,208,63,139,255,208,63,223,255,192,63,255,64,0,63,252,0,0,63,240,0,0,63,224,0,0,63,208,0,0,63,208,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,
  // 0x015a  Ś
  17,37,185,21,2,255,0,0,15,252,0,0,0,47,240,0,0,0,63,192,0,0,0,255,0,0,0,2,252,0,0,0,7,224,0,0,0,0,0,0,0,0,0,0,0,0,0,5,85,0,0,0,191,255,249,0,7,255,255,255,128,31,255,255,255,0,63,244,1,191,0,127,192,0,0,0,191,64,0,0,0,255,64,0,0,0,191,64,0,0,0,191,192,0,0,0,127,224,0,0,0,63,253,0,0,0,15,255,208,0,0,3,255,254,0,0,0,127,255,224,0,0,7,255,252,0,0,0,127,255,0,0,0,7,255,64,0,0,0,255,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,144,0,0,255,128,254,80,27,255,0,255,255,255,253,0,255,255,255,244,0,47,255,255,64,0,0,21,64,0,0,
  // 0x015b  ś
  15,30,120,18,2,255,0,0,191,208,0,0,255,64,0,3,253,0,0,11,244,0,0,15,208,0,0,63,64,0,0,0,0,0,0,0,0,0,0,111,233,0,11,255,255,240,63,255,255,240,191,229,111,224,255,0,0,64,255,0,0,0,255,0,0,0,255,208,0,0,127,253,0,0,31,255,224,0,2,255,254,0,0,47,255,208,0,1,255,240,0,0,47,248,0,0,11,248,0,0,3,248,0,0,7,248,244,0,31,244,255,251,255,240,255,255,255,192,111,255,253,0,0,85,0,0,
  // 0x015c  Ŝ
  17,37,185,21,2,255,0,15,253,0,0,0,47,255,0,0,0,127,255,192,0,0,254,31,240,0,3,248,3,248,0,15,208,0,190,0,0,0,0,0,0,0,0,0,0,0,0,5,85,0,0,0,191,255,249,0,7,255,255,255,128,31,255,255,255,0,63,244,1,191,0,127,192,0,0,0,191,64,0,0,0,255,64,0,0,0,191,64,0,0,0,191,192,0,0,0,127,224,0,0,0,63,253,0,0,0,15,255,208,0,0,3,255,254,0,0,0,127,255,224,0,0,7,255,252,0,0,0,127,255,0,0,0,7,255,64,0,0,0,255,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,144,0,0,255,128,254,80,27,255,0,255,255,255,253,0,255,255,255,244,0,47,255,255,64,0,0,21,64,0,0,
  // 0x015d  ŝ
  15,30,120,18,2,255,0,127,240,0,0,255,244,0,3,255,253,0,15,240,255,0,47,192,47,192,190,0,7,240,0,0,0,0,0,0,0,0,0,111,233,0,11,255,255,240,63,255,255,240,191,229,111,224,255,0,0,64,255,0,0,0,255,0,0,0,255,208,0,0,127,253,0,0,31,255,224,0,2,255,254,0,0,47,255,208,0,1,255,240,0,0,47,248,0,0,11,248,0,0,3,248,0,0,7,248,244,0,31,244,255,251,255,240,255,255,255,192,111,255,253,0,0,85,0,0,
  // 0x015e  Ş
  17,38,190,21,2,246,0,5,85,0,0,0,191,255,249,0,7,255,255,255,128,31,255,255,255,0,63,244,1,191,0,127,192,0,0,0,191,64,0,0,0,255,64,0,0,0,191,64,0,0,0,191,192,0,0,0,127,224,0,0,0,63,253,0,0,0,15,255,208,0,0,3,255,254,0,0,0,127,255,224,0,0,7,255,252,0,0,0,127,255,0,0,0,7,255,64,0,0,0,255,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,144,0,0,255,128,254,80,27,255,0,255,255,255,253,0,255,255,255,244,0,47,255,255,64,0,0,31,208,0,0,0,15,192,0,0,0,31,244,0,0,0,7,253,0,0,0,0,190,0,0,0,0,191,0,0,0,85,254,0,0,0,255,252,0,0,0,255,224,0,0,0,0,0,0,0,
  // 0x015f  ş
  15,31,124,18,2,246,0,111,233,0,11,255,255,240,63,255,255,240,191,229,111,224,255,0,0,64,255,0,0,0,255,0,0,0,255,208,0,0,127,253,0,0,31,255,224,0,2,255,254,0,0,47,255,208,0,1,255,240,0,0,47,248,0,0,11,248,0,0,3,248,0,0,7,248,244,0,31,244,255,251,255,240,255,255,255,192,111,255,253,0,0,95,192,0,0,47,0,0,0,63,224,0,0,27,248,0,0,1,252,0,0,0,252,0,1,87,252,0,2,255,244,0,2,255,128,0,0,0,0,0,
  // 0x0160  Š
  17,37,185,21,2,255,15,208,0,254,0,3,248,7,248,0,0,255,31,224,0,0,127,255,192,0,0,31,255,0,0,0,11,253,0,0,0,0,0,0,0,0,0,0,0,0,0,5,85,0,0,0,191,255,249,0,7,255,255,255,128,31,255,255,255,0,63,244,1,191,0,127,192,0,0,0,191,64,0,0,0,255,64,0,0,0,191,64,0,0,0,191,192,0,0,0,127,224,0,0,0,63,253,0,0,0,15,255,208,0,0,3,255,254,0,0,0,127,255,224,0,0,7,255,252,0,0,0,127,255,0,0,0,7,255,64,0,0,0,255,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,144,0,0,255,128,254,80,27,255,0,255,255,255,253,0,255,255,255,244,0,47,255,255,64,0,0,21,64,0,0,
  // 0x0161  š
  15,30,120,18,2,255,191,0,7,240,47,208,47,192,11,244,255,0,3,255,252,0,0,255,244,0,0,127,224,0,0,0,0,0,0,0,0,0,0,111,233,0,11,255,255,240,63,255,255,240,191,229,111,224,255,0,0,64,255,0,0,0,255,0,0,0,255,208,0,0,127,253,0,0,31,255,224,0,2,255,254,0,0,47,255,208,0,1,255,240,0,0,47,248,0,0,11,248,0,0,3,248,0,0,7,248,244,0,31,244,255,251,255,240,255,255,255,192,111,255,253,0,0,85,0,0,
  // 0x0162  Ţ
  21,37,222,21,0,246,191,255,255,255,255,192,191,255,255,255,255,192,191,255,255,255,255,192,21,85,191,213,85,64,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,47,0,0,0,0,0,62,0,0,0,0,0,191,208,0,0,0,0,31,240,0,0,0,0,3,248,0,0,0,0,2,248,0,0,0,1,87,244,0,0,0,3,255,240,0,0,0,3,255,128,0,0,0,0,0,0,0,0,
  // 0x0163  ţ
  14,35,140,15,0,246,0,62,0,0,0,126,0,0,0,190,0,0,0,254,0,0,2,255,85,64,47,255,255,208,127,255,255,208,43,255,170,128,1,254,0,0,1,254,0,0,1,254,0,0,1,254,0,0,1,254,0,0,1,254,0,0,1,254,0,0,1,254,0,0,1,254,0,0,1,254,0,0,1,254,0,0,1,254,0,0,1,255,0,0,0,255,128,0,0,255,255,224,0,63,255,224,0,11,255,208,0,3,244,0,0,7,208,0,0,15,248,0,0,6,255,0,0,0,63,64,0,0,63,64,0,21,191,0,0,127,254,0,0,127,244,0,0,0,0,0,
  // 0x0164  Ť
  21,36,216,21,0,0,0,253,0,15,208,0,0,63,128,127,128,0,0,31,225,254,0,0,0,7,255,248,0,0,0,2,255,240,0,0,0,0,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,192,191,255,255,255,255,192,191,255,255,255,255,192,21,85,191,213,85,64,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,
  // 0x0165  ť
  19,30,150,15,0,255,0,0,0,3,252,0,0,0,3,248,0,0,0,7,240,0,0,0,11,224,0,62,0,15,192,0,126,0,15,128,0,190,0,0,0,0,254,0,0,0,2,255,85,64,0,47,255,255,208,0,127,255,255,208,0,43,255,170,128,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,255,0,0,0,0,255,128,0,0,0,255,255,224,0,0,63,255,224,0,0,11,255,208,0,0,0,84,0,0,
  // 0x0166  Ŧ
  21,27,162,21,0,0,191,255,255,255,255,192,191,255,255,255,255,192,191,255,255,255,255,192,21,85,191,213,85,64,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,1,85,191,213,80,0,2,255,255,255,240,0,2,255,255,255,240,0,2,255,255,255,240,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,
  // 0x0167  ŧ
  14,26,104,15,0,255,0,62,0,0,0,126,0,0,0,190,0,0,0,254,0,0,2,255,85,64,47,255,255,208,127,255,255,208,43,255,170,128,1,254,0,0,1,254,0,0,1,254,0,0,2,254,0,0,63,255,255,192,63,255,255,192,63,255,255,192,1,254,0,0,1,254,0,0,1,254,0,0,1,254,0,0,1,254,0,0,1,255,0,0,0,255,128,0,0,255,255,224,0,63,255,224,0,11,255,208,0,0,84,0,
  // 0x0168  Ũ
  22,36,216,28,3,255,0,11,248,0,240,0,0,63,255,67,240,0,0,191,255,255,224,0,0,248,11,255,192,0,0,240,1,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,128,0,0,31,224,191,128,0,0,47,224,127,192,0,0,47,208,63,192,0,0,63,192,63,224,0,0,191,192,31,248,0,1,255,64,15,255,64,31,255,0,3,255,255,255,252,0,0,255,255,255,224,0,0,27,255,254,64,0,0,0,21,64,0,0,
  // 0x0169  ũ
  18,29,145,24,3,255,0,191,64,31,0,3,255,244,63,0,11,255,255,253,0,15,129,255,252,0,15,0,27,224,0,0,0,0,0,0,0,0,0,0,0,85,0,0,5,80,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,240,255,0,0,31,240,255,0,0,31,240,255,0,0,47,240,255,64,0,63,240,191,192,0,191,240,127,224,7,255,240,63,255,255,239,240,15,255,255,143,240,2,255,253,11,240,0,5,64,0,0,
  // 0x016a  Ū
  22,34,204,28,3,255,0,63,255,255,192,0,0,63,255,255,192,0,0,63,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,128,0,0,31,224,191,128,0,0,47,224,127,192,0,0,47,208,63,192,0,0,63,192,63,224,0,0,191,192,31,248,0,1,255,64,15,255,64,31,255,0,3,255,255,255,252,0,0,255,255,255,224,0,0,27,255,254,64,0,0,0,21,64,0,0,
  // 0x016b  ū
  18,27,135,24,3,255,3,255,255,252,0,3,255,255,252,0,3,255,255,252,0,0,0,0,0,0,0,0,0,0,0,85,0,0,5,80,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,240,255,0,0,31,240,255,0,0,31,240,255,0,0,47,240,255,64,0,63,240,191,192,0,191,240,127,224,7,255,240,63,255,255,239,240,15,255,255,143,240,2,255,253,11,240,0,5,64,0,0,
  // 0x016c  Ŭ
  22,37,222,28,3,255,0,20,0,1,64,0,0,61,0,7,192,0,0,63,64,111,192,0,0,31,255,255,64,0,0,11,255,253,0,0,0,0,191,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,128,0,0,31,224,191,128,0,0,47,224,127,192,0,0,47,208,63,192,0,0,63,192,63,224,0,0,191,192,31,248,0,1,255,64,15,255,64,31,255,0,3,255,255,255,252,0,0,255,255,255,224,0,0,27,255,254,64,0,0,0,21,64,0,0,
  // 0x016d  ŭ
  18,30,150,24,3,255,1,64,0,20,0,3,208,0,124,0,3,244,6,252,0,1,255,255,240,0,0,191,255,208,0,0,27,254,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,5,80,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,240,255,0,0,31,240,255,0,0,31,240,255,0,0,47,240,255,64,0,63,240,191,192,0,191,240,127,224,7,255,240,63,255,255,239,240,15,255,255,143,240,2,255,253,11,240,0,5,64,0,0,
  // 0x016e  Ů
  22,39,234,28,3,255,0,0,191,224,0,0,0,2,255,248,0,0,0,3,208,188,0,0,0,7,192,61,0,0,0,3,192,61,0,0,0,3,224,188,0,0,0,1,255,244,0,0,0,0,127,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,128,0,0,31,224,191,128,0,0,47,224,127,192,0,0,47,208,63,192,0,0,63,192,63,224,0,0,191,192,31,248,0,1,255,64,15,255,64,31,255,0,3,255,255,255,252,0,0,255,255,255,224,0,0,27,255,254,64,0,0,0,21,64,0,0,
  // 0x016f  ů
  18,32,160,24,3,255,0,11,254,0,0,0,47,255,128,0,0,61,11,192,0,0,124,3,192,0,0,124,3,192,0,0,62,15,192,0,0,47,255,64,0,0,7,249,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,5,80,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,240,255,0,0,31,240,255,0,0,31,240,255,0,0,47,240,255,64,0,63,240,191,192,0,191,240,127,224,7,255,240,63,255,255,239,240,15,255,255,143,240,2,255,253,11,240,0,5,64,0,0,
  // 0x0170  Ű
  22,37,222,28,3,255,0,3,252,31,240,0,0,11,244,63,208,0,0,31,224,127,64,0,0,63,128,254,0,0,0,190,2,248,0,0,0,248,7,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,128,0,0,31,224,191,128,0,0,47,224,127,192,0,0,47,208,63,192,0,0,63,192,63,224,0,0,191,192,31,248,0,1,255,64,15,255,64,31,255,0,3,255,255,255,252,0,0,255,255,255,224,0,0,27,255,254,64,0,0,0,21,64,0,0,
  // 0x0171  ű
  18,30,150,24,3,255,0,63,193,255,0,0,255,67,253,0,1,254,7,244,0,3,248,15,208,0,11,224,47,64,0,15,128,125,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,5,80,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,240,255,0,0,31,240,255,0,0,31,240,255,0,0,47,240,255,64,0,63,240,191,192,0,191,240,127,224,7,255,240,63,255,255,239,240,15,255,255,143,240,2,255,253,11,240,0,5,64,0,0,
  // 0x0172  Ų
  22,36,216,28,3,247,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,128,0,0,31,224,191,128,0,0,47,224,127,192,0,0,47,208,63,192,0,0,63,192,63,224,0,0,191,192,31,248,0,1,255,64,15,255,64,31,255,0,3,255,255,255,252,0,0,255,255,255,240,0,0,27,255,255,192,0,0,0,21,111,64,0,0,0,0,62,0,0,0,0,0,188,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,0,253,0,0,0,0,0,255,244,0,0,0,0,63,244,0,0,0,0,6,144,0,
  // 0x0173  ų
  18,30,150,24,3,247,85,0,0,5,80,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,240,255,0,0,31,240,255,0,0,31,240,255,0,0,47,240,255,64,0,63,240,191,192,0,191,240,127,224,7,255,240,63,255,255,239,240,15,255,255,143,240,2,255,253,15,240,0,5,64,31,64,0,0,0,126,0,0,0,0,252,0,0,0,2,244,0,0,0,2,244,0,0,0,2,248,0,0,0,1,255,240,0,0,0,191,240,0,0,0,26,80,
  // 0x0174  Ŵ
  36,36,68,36,0,0,0,0,0,2,255,64,0,0,0,0,0,0,7,255,192,0,0,0,0,0,0,31,255,240,0,0,0,0,0,0,63,195,252,0,0,0,0,0,0,254,0,255,0,0,0,0,0,3,244,0,47,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,128,0,1,255,0,0,3,253,127,192,0,2,255,64,0,3,252,63,192,0,3,255,128,0,7,248,63,208,0,7,255,192,0,11,244,31,224,0,11,255,192,0,15,240,15,240,0,15,239,208,0,15,240,15,240,0,15,223,240,0,31,224,11,244,0,31,203,240,0,47,208,7,248,0,47,199,244,0,63,192,3,252,0,63,131,248,0,63,192,3,252,0,127,67,252,0,127,128,2,253,0,191,2,252,0,191,64,1,254,0,255,0,254,0,255,0,0,255,0,254,0,255,0,255,0,0,255,1,253,0,191,1,254,0,0,191,66,252,0,127,66,253,0,0,127,131,248,0,63,131,252,0,0,63,195,244,0,63,195,252,0,0,63,199,240,0,47,199,248,0,0,47,219,240,0,15,219,240,0,0,31,223,224,0,15,235,240,0,0,15,239,208,0,11,239,224,0,0,15,255,192,0,7,255,208,0,0,11,255,192,0,3,255,192,0,0,7,255,64,0,3,255,192,0,0,3,255,0,0,2,255,128,0,0,2,255,0,0,0,255,64,0,
  // 0x0175  ŵ
  30,29,232,31,0,0,0,0,0,127,240,0,0,0,0,0,0,255,248,0,0,0,0,0,3,255,253,0,0,0,0,0,11,244,191,64,0,0,0,0,47,208,47,208,0,0,0,0,126,0,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,26,144,0,6,160,127,192,0,63,240,0,15,240,63,192,0,127,240,0,31,224,47,208,0,255,244,0,47,208,31,224,0,255,248,0,63,192,15,240,1,253,252,0,63,192,15,240,2,248,253,0,127,128,11,244,3,244,254,0,191,64,7,248,3,240,191,0,255,0,3,252,11,240,127,0,254,0,3,252,15,224,63,65,253,0,2,253,15,208,63,130,252,0,1,254,31,192,47,195,252,0,0,255,47,192,15,211,248,0,0,191,63,64,15,231,244,0,0,127,127,0,11,235,240,0,0,63,191,0,7,255,240,0,0,63,254,0,3,255,208,0,0,47,253,0,3,255,192,0,0,31,252,0,2,255,192,0,0,15,248,0,0,255,128,0,
  // 0x0176  Ŷ
  22,36,216,22,0,0,0,0,191,224,0,0,0,1,255,244,0,0,0,3,255,252,0,0,0,15,240,255,0,0,0,63,192,63,192,0,0,190,0,11,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,192,0,0,47,240,63,208,0,0,63,208,47,240,0,0,191,128,15,244,0,0,255,0,11,252,0,2,254,0,3,253,0,3,252,0,1,255,0,11,248,0,0,255,64,31,240,0,0,127,192,63,208,0,0,63,208,127,192,0,0,31,240,255,64,0,0,11,249,255,0,0,0,3,255,253,0,0,0,2,255,248,0,0,0,0,255,240,0,0,0,0,191,224,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,
  // 0x0177  ŷ
  20,39,195,20,0,246,0,2,255,128,0,0,7,255,208,0,0,15,255,240,0,0,63,195,252,0,0,255,0,255,0,2,244,0,47,128,0,0,0,0,0,0,0,0,0,0,85,0,0,0,85,191,128,0,2,254,63,192,0,3,253,63,208,0,7,252,31,240,0,11,248,15,240,0,15,240,11,248,0,31,240,3,252,0,47,208,3,253,0,63,192,1,254,0,127,128,0,255,0,255,64,0,191,64,255,0,0,63,129,254,0,0,63,195,252,0,0,31,211,252,0,0,15,231,244,0,0,11,251,240,0,0,3,255,224,0,0,3,255,192,0,0,1,255,192,0,0,0,255,64,0,0,0,255,0,0,0,1,254,0,0,0,2,253,0,0,0,3,252,0,0,0,15,244,0,0,16,127,240,0,0,127,255,192,0,0,127,255,64,0,0,127,248,0,0,0,0,0,0,0,0,
  // 0x0178  Ÿ
  22,35,210,22,0,0,0,11,128,47,0,0,0,31,208,63,128,0,0,31,208,63,128,0,0,15,192,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,192,0,0,47,240,63,208,0,0,63,208,47,240,0,0,191,128,15,244,0,0,255,0,11,252,0,2,254,0,3,253,0,3,252,0,1,255,0,11,248,0,0,255,64,31,240,0,0,127,192,63,208,0,0,63,208,127,192,0,0,31,240,255,64,0,0,11,249,255,0,0,0,3,255,253,0,0,0,2,255,248,0,0,0,0,255,240,0,0,0,0,191,224,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,
  // 0x0179  Ź
  20,36,180,22,1,0,0,0,2,255,0,0,0,7,253,0,0,0,15,244,0,0,0,47,208,0,0,0,127,64,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,252,127,255,255,255,252,127,255,255,255,252,21,85,85,95,248,0,0,0,47,240,0,0,0,63,208,0,0,0,255,128,0,0,2,255,0,0,0,3,253,0,0,0,15,248,0,0,0,47,240,0,0,0,63,208,0,0,0,255,128,0,0,2,255,0,0,0,7,253,0,0,0,15,248,0,0,0,47,240,0,0,0,127,208,0,0,0,255,128,0,0,2,255,0,0,0,7,252,0,0,0,15,248,0,0,0,47,240,0,0,0,127,234,170,170,169,191,255,255,255,253,191,255,255,255,253,191,255,255,255,253,
  // 0x017a  ź
  16,29,116,18,1,0,0,0,47,240,0,0,127,208,0,0,255,64,0,2,253,0,0,7,244,0,0,15,192,0,0,0,0,0,0,0,0,0,21,85,85,84,63,255,255,253,63,255,255,253,42,170,171,252,0,0,11,248,0,0,31,240,0,0,63,192,0,0,255,64,0,2,254,0,0,7,252,0,0,15,244,0,0,47,224,0,0,127,192,0,0,255,0,0,3,253,0,0,11,248,0,0,31,240,0,0,63,208,0,0,191,255,255,254,191,255,255,254,191,255,255,254,
  // 0x017b  Ż
  20,35,175,22,1,0,0,0,191,0,0,0,0,255,64,0,0,0,255,64,0,0,0,191,0,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,252,127,255,255,255,252,127,255,255,255,252,21,85,85,95,248,0,0,0,47,240,0,0,0,63,208,0,0,0,255,128,0,0,2,255,0,0,0,3,253,0,0,0,15,248,0,0,0,47,240,0,0,0,63,208,0,0,0,255,128,0,0,2,255,0,0,0,7,253,0,0,0,15,248,0,0,0,47,240,0,0,0,127,208,0,0,0,255,128,0,0,2,255,0,0,0,7,252,0,0,0,15,248,0,0,0,47,240,0,0,0,127,234,170,170,169,191,255,255,255,253,191,255,255,255,253,191,255,255,255,253,
  // 0x017c  ż
  16,28,112,18,1,0,0,11,240,0,0,15,240,0,0,15,244,0,0,15,240,0,0,1,64,0,0,0,0,0,0,0,0,0,21,85,85,84,63,255,255,253,63,255,255,253,42,170,171,252,0,0,11,248,0,0,31,240,0,0,63,192,0,0,255,64,0,2,254,0,0,7,252,0,0,15,244,0,0,47,224,0,0,127,192,0,0,255,0,0,3,253,0,0,11,248,0,0,31,240,0,0,63,208,0,0,191,255,255,254,191,255,255,254,191,255,255,254,
  // 0x017d  Ž
  20,36,180,22,1,0,2,248,0,47,192,0,191,0,255,0,0,63,195,252,0,0,15,255,240,0,0,3,255,208,0,0,1,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,252,127,255,255,255,252,127,255,255,255,252,21,85,85,95,248,0,0,0,47,240,0,0,0,63,208,0,0,0,255,128,0,0,2,255,0,0,0,3,253,0,0,0,15,248,0,0,0,47,240,0,0,0,63,208,0,0,0,255,128,0,0,2,255,0,0,0,7,253,0,0,0,15,248,0,0,0,47,240,0,0,0,127,208,0,0,0,255,128,0,0,2,255,0,0,0,7,252,0,0,0,15,248,0,0,0,47,240,0,0,0,127,234,170,170,169,191,255,255,255,253,191,255,255,255,253,191,255,255,255,253,
  // 0x017e  ž
  16,29,116,18,1,0,47,128,2,248,15,240,15,240,3,252,63,192,0,255,255,0,0,63,252,0,0,31,244,0,0,0,0,0,0,0,0,0,21,85,85,84,63,255,255,253,63,255,255,253,42,170,171,252,0,0,11,248,0,0,31,240,0,0,63,192,0,0,255,64,0,2,254,0,0,7,252,0,0,15,244,0,0,47,224,0,0,127,192,0,0,255,0,0,3,253,0,0,11,248,0,0,31,240,0,0,63,208,0,0,191,255,255,254,191,255,255,254,191,255,255,254,
  // 0x017f  ſ
  11,29,87,13,3,0,1,191,248,15,255,252,63,255,248,127,228,100,191,128,0,191,64,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,
};

#endif // HAS_GRAPHICAL_TFT
